!
!#######                                         ######
!#          #    ######  #       #####    ####  #     #  #    #   #   #   ####
!#          #    #       #       #    #  #      #     #  #    #    # #   #
!#####      #    #####   #       #    #   ####  ######   ######     #     ####
!#          #    #       #       #    #       # #        #    #     #         #
!#          #    #       #       #    #  #    # #        #    #     #    #    #
!#          #    ######  ######  #####    ####  #        #    #     #     ####


MODULE FieldsPhysics

 USE Constants, ONLY: &
       r4,i4, r8,i8

  IMPLICIT NONE
  
  
  REAL(KIND=r8), PUBLIC, ALLOCATABLE, DIMENSION(:  ,:) :: gtsea ! (tseam < 0) sea surface temp.(K) tseam > 0) ground temp.(K)
  REAL(KIND=r8), PUBLIC, ALLOCATABLE, DIMENSION(:  ,:) :: soilm ! total soil water in (mm)
  REAL(KIND=r8), PUBLIC, ALLOCATABLE, DIMENSION(:,:,:) :: o3mix ! ozone mass mixing ratio (g/g)
  REAL(KIND=r8), PUBLIC, ALLOCATABLE, DIMENSION(:,:  ) :: tg1   ! deep soil temp (K)
  REAL(KIND=r8), PUBLIC, ALLOCATABLE, DIMENSION(:,:  ) :: tg2   ! ground temperature (K)
  REAL(KIND=r8), PUBLIC, ALLOCATABLE, DIMENSION(:,:  ) :: tg3   ! canopy temperature (K)
  REAL(KIND=r8), PUBLIC, ALLOCATABLE, DIMENSION(:,:  ) :: ssib  ! Soil Humidity Fraction
  REAL(KIND=r8), PUBLIC, ALLOCATABLE, DIMENSION(:,:,:) :: wsib3d! initial soil wetness data at sib soil layers
  REAL(KIND=r8), PUBLIC, ALLOCATABLE, DIMENSION(:,:  ) :: gl0   ! Maximum mixing length l0 in blackerdar's formula (m)
  REAL(KIND=r8), PUBLIC, ALLOCATABLE, DIMENSION(:,:  ) :: Mmlen ! Maximum mixing length l0 in blackerdar's formula (m)
  REAL(KIND=r8), PUBLIC, ALLOCATABLE, DIMENSION(:,:  ) :: tg0   ! surface soil temperature (K)    t+1
  REAL(KIND=r8), PUBLIC, ALLOCATABLE, DIMENSION(:,:  ) :: tgm   ! Temperatura da superficie do solo  (K)   modificada  t-1
  REAL(KIND=r8), PUBLIC, ALLOCATABLE, DIMENSION(:,:  ) :: tseam ! (tseam < 0) sea surface temp.(K) (tseam > 0) ground temp.(K)
  REAL(KIND=r8), PUBLIC, ALLOCATABLE, DIMENSION(:,:  ) :: z0    ! Roughness length
  REAL(KIND=r8), PUBLIC, ALLOCATABLE, DIMENSION(:,:  ) :: zorl      ! Aero. Roughness length  (m)
  REAL(KIND=r8), PUBLIC, ALLOCATABLE, DIMENSION(:,:  ) :: AlbVisDiff! Visible diffuse surface albedo
  REAL(KIND=r8), PUBLIC, ALLOCATABLE, DIMENSION(:,:  ) :: sheleg    ! Snow amount in (mm) (equivalent water depth)
  REAL(KIND=r8), PUBLIC, ALLOCATABLE, DIMENSION(:,:  ) :: rVisDiff  ! Down Sfc SW flux visible diffuse (all-sky)
  REAL(KIND=r8), PUBLIC, ALLOCATABLE, DIMENSION(:,:  ) :: gndvi     ! Nomalized difference vegetation index
  INTEGER(KIND=i8),PUBLIC,ALLOCATABLE, DIMENSION(:,:  ) :: imask      ! vegetation mask
  INTEGER(KIND=i8),PUBLIC,ALLOCATABLE, DIMENSION(:,:  ) :: MskAnt    ! Antartida mask
  REAL(KIND=r8), PUBLIC, ALLOCATABLE, DIMENSION(:,:  ) :: tc0       ! "dossel" canopy of temparature (K) t+1
  REAL(KIND=r8), PUBLIC, ALLOCATABLE, DIMENSION(:,:  ) :: ppli      ! Precipitation rate ( large scale ) ( mm/s)
  REAL(KIND=r8), PUBLIC, ALLOCATABLE, DIMENSION(:,:  ) :: ppci      ! Precipitation rate ( cumulus ) ( mm/s )
  REAL(KIND=r8), PUBLIC, ALLOCATABLE, DIMENSION(:,:,:) :: capac0! Intercepted Water iv=1 at the dossel"water store capacity of leaves"(m)  modificada t+1
                                                           ! Intercepted Water iv=2 on surface soil (m) modificada
  REAL(KIND=r8), PUBLIC, ALLOCATABLE, DIMENSION(:,:,:) :: capacm! Intercepted Water iv=1 at the dossel"water store capacity of leaves"(m)  modificada t-1
                                                           ! Intercepted Water iv=2 na cobertura do solo(m)modific.
  REAL(KIND=r8), PUBLIC, ALLOCATABLE, DIMENSION(:,:  ) :: td0   ! dep soil temperature (K) t+1
  REAL(KIND=r8), PUBLIC, ALLOCATABLE, DIMENSION(:,:,:) :: w0    ! w0(id)Grau de saturacao de umid do solo id=1 na camada superficial t+1
                                                           ! w0(id)Grau de saturacao de umid do solo id=2 na camada de raizes t+1
                                                           ! w0(id)Grau de saturacao de umid do solo id=3 na camada de drenagem t+1
  REAL(KIND=r8), PUBLIC, ALLOCATABLE, DIMENSION(:,:,:) :: wm    ! w0(id)Grau de saturacao de umid do solo id=1 na camada superficial t+1
                                                           ! w0(id)Grau de saturacao de umid do solo id=2 na camada de raizes t+1
                                                           ! w0(id)Grau de saturacao de umid do solo id=3 na camada de drenagem t+1
  REAL(KIND=r8), PUBLIC, ALLOCATABLE, DIMENSION(:,:  ) :: tdm   ! Temperatura do solo profundo (K)   modificada   t-1
  REAL(KIND=r8), PUBLIC, ALLOCATABLE, DIMENSION(:,:  ) :: tcm   ! Temperatura da copa "dossel"(K)   modificada   t-1
  REAL(KIND=r8), PUBLIC, ALLOCATABLE, DIMENSION(:,:  ) :: qsfc0 ! prognostic surface ocean temparature (K) t+1
  REAL(KIND=r8), PUBLIC, ALLOCATABLE, DIMENSION(:,:  ) :: tsfc0 ! prognostic surface ocean temparature (K) t+1
  REAL(KIND=r8), PUBLIC, ALLOCATABLE, DIMENSION(:,:  ) :: qsfcm ! prognostic surface ocean temparature (K) t-1
  REAL(KIND=r8), PUBLIC, ALLOCATABLE, DIMENSION(:,:  ) :: tsfcm ! prognostic surface ocean temparature (K) t-1
  REAL(KIND=r8), PUBLIC, ALLOCATABLE, DIMENSION(:,:,:) :: tkemyj

  
CONTAINS

SUBROUTINE initFieldsPhysics(iMax,jMax,kMax,ibMax,jbMax)   
  INTEGER, INTENT(IN   ) :: iMax
  INTEGER, INTENT(IN   ) :: jMax
  INTEGER, INTENT(IN   ) :: kMax
  INTEGER, INTENT(IN   ) :: ibMax
  INTEGER, INTENT(IN   ) :: jbMax  
  ALLOCATE(imask      (ibMax,  jbMax));imask	  =0
  ALLOCATE(MskAnt     (ibMax,  jbMax));MskAnt	  =0
  ALLOCATE(gndvi      (ibMax,  jbMax));gndvi	  =0.0_r8
  ALLOCATE(AlbVisDiff (ibMax,  jbMax));AlbVisDiff =0.0_r8
  ALLOCATE(gtsea      (ibMax,  jbMax));gtsea	  =0.0_r8
  ALLOCATE(tseam      (ibMax,  jbMax));tseam	  =0.0_r8
  ALLOCATE(rVisDiff   (ibMax,  jbMax));rVisDiff   =0.0_r8
  ALLOCATE(z0         (ibMax,  jbMax));z0	  =0.0_r8
  ALLOCATE(soilm      (ibMax,  jbMax));soilm	  =0.0_r8
  ALLOCATE(ssib       (ibMax,  jbMax));ssib	  =0.0_r8
  ALLOCATE(td0        (ibMax,  jbMax));td0	  =0.0_r8
  ALLOCATE(tdm        (ibMax,  jbMax));tdm	  =0.0_r8
  ALLOCATE(tcm        (ibMax,  jbMax));tcm	  =0.0_r8
  ALLOCATE(tc0        (ibMax,  jbMax));tc0	  =0.0_r8
  ALLOCATE(tgm        (ibMax,  jbMax));tgm	  =0.0_r8
  ALLOCATE(tg0        (ibMax,  jbMax));tg0	  =0.0_r8
  ALLOCATE(w0         (ibMax,3,jbMax));w0	  =0.0_r8
  ALLOCATE(wm         (ibMax,3,jbMax));wm	  =0.0_r8
  ALLOCATE(capac0     (ibMax,2,jbMax));capac0	  =0.0_r8
  ALLOCATE(capacm     (ibMax,2,jbMax));capacm	  =0.0_r8
  ALLOCATE(tg1        (ibMax,  jbMax));tg1	  =0.0_r8
  ALLOCATE(tg2        (ibMax,  jbMax));tg2	  =0.0_r8
  ALLOCATE(tg3        (ibMax,  jbMax));tg3	  =0.0_r8
  ALLOCATE(zorl       (ibMax,  jbMax));zorl	  =0.0_r8
  ALLOCATE(ppli       (ibMax,  jbMax));ppli       =0.0_r8
  ALLOCATE(ppci       (ibMax,  jbMax));ppci       =0.0_r8
  ALLOCATE(gl0        (ibMax,  jbMax));gl0        =0.0_r8
  ALLOCATE(Mmlen      (ibMax,  jbMax));Mmlen      =0.0_r8
  ALLOCATE(sheleg     (ibMax,  jbMax));sheleg     =0.0_r8
  ALLOCATE(qsfc0      (ibMax,  jbMax));qsfc0	  =0.0_r8
  ALLOCATE(tsfc0      (ibMax,  jbMax));tsfc0	  =0.0_r8
  ALLOCATE(qsfcm      (ibMax,  jbMax));qsfcm	  =0.0_r8
  ALLOCATE(tsfcm      (ibMax,  jbMax));tsfcm	  =0.0_r8
  ALLOCATE(wsib3d     (ibMax,jbMax,50));wsib3d=0.0_r8

END SUBROUTINE initFieldsPhysics

END MODULE FieldsPhysics

