!
!    #    #    #     #     #####    ##    #       #
!    #    ##   #     #       #     #  #   #       #
!    #    # #  #     #       #    #    #  #       #
!    #    #  # #     #       #    ######  #       #
!    #    #   ##     #       #    #    #  #       #
!    #    #    #     #       #    #    #  ######  ######
!
!
!  $Author: pkubota $
!  $Date: 2008/09/23 17:51:54 $
!  $Revision: 1.9 $
!
MODULE InitAll
  USE Constants, Only: &
       r8,             &
       i8
  USE Options       , Only : InitOptions,dt,path_inp,idate,idatec,idatep,nfsibd,nfprt,nfsibt,&
                             fNameSibVeg,fNameSibmsk,ifday,tod,fNameIBISMask,fNameSSTAOI,&
			     fNameIBISDeltaTemp,fNameSandMask,fNameClayMask,fNameClimaTemp,&
			     RESTART,DELTAOUT,DELTAIN,UNDIMENSION,icn_data
  USE Sfc_Ibis_Fiels, Only : InitFieldsIbis,nband,nsoilay,depth
  USE Sizes         , Only : InitSizes, ibMaxPerJB,iMax, jMax, kMax, ibMax, jbMax
  USE FieldsPhysics , Only : initFieldsPhysics,iMask
  USE Utils         , Only : InitUtils
  USE IbisOutput    , ONLY : Init_IbisOutput
  USE AtmosModel    , ONLY : RunAtmosModel2D,InitAtmosModel,RunAtmosModel1D
  !PK USE ReadNETCDF    , ONLY : InitReadNETCDF

  IMPLICIT NONE
  PRIVATE
  PUBLIC :: InitA
CONTAINS

  SUBROUTINE InitA()  
    IMPLICIT NONE
    INTEGER :: nVars=410
    INTEGER :: nVarscp=5
    REAL(KIND=r8) :: xres
    REAL(KIND=r8) :: yres
    INTEGER :: rec_local

    print*,'InitOptions'

    CALL InitOptions(iMax,jMax,kMax)
    xres= 360.0_r8/REAL(iMax,kind=r8)
    yres= 180.0_r8/REAL(jMax,kind=r8)
         print*,'InitOptions'
   
    CALL InitSizes(iMax,jMax)
    print*,'InitUtils'

    CALL InitUtils(iMax,jMax)

    CALL initFieldsPhysics  (iMax,jMax,kMax,ibMax,jbMax)   


    CALL InitAtmosModel(ibMax,jbMax,nband)


    IF(.NOT.UNDIMENSION)THEN
       IF(TRIM(icn_data) == 'ERA5')THEN
          !PRECIPITATION
          !PK CALL InitReadNETCDF("inputdata/Merger_prec_2004070100_2005022823.nc" ,icn_data ,nFile=1)
          !TEMPERATURE
          !PK CALL InitReadNETCDF("inputdata/Merger_temp_2004070100_2005022823.nc" ,icn_data ,nFile=2)
          !RELATIVE HUMIDITY
          !PK CALL InitReadNETCDF("inputdata/Merger_rhum_2004070100_2005022823.nc" ,icn_data ,nFile=3)
          !WIND
          !PK CALL InitReadNETCDF("inputdata/Merger_wind_2004070100_2005022823.nc" ,icn_data ,nFile=4)
          !DOWNWARD SHORT WAVE RADIATION 
          !PK CALL InitReadNETCDF("inputdata/Merger_swrad_2004070100_2005022823.nc",icn_data ,nFile=5)
          !DOWNWARD LONG WAVE RADIATION 
          !PK CALL InitReadNETCDF("inputdata/Merger_lwrad_2004070100_2005022823.nc",icn_data ,nFile=6)
       ELSE IF (TRIM(icn_data) == 'GLDAS')THEN 
          !PRESSURE
          !PK CALL InitReadNETCDF("inputdata/GLDAS_PRES2004070100.nc" ,icn_data,nFile=1)
          !TEMPERATURE
          !PK CALL InitReadNETCDF("inputdata/GLDAS_TEMP2004070100.nc" ,icn_data,nFile=2)
          !RELATIVE HUMIDITY
          !PK CALL InitReadNETCDF("inputdata/GLDAS_UMES2004070100.nc" ,icn_data,nFile=3)
          !WIND
          !PK CALL InitReadNETCDF("inputdata/GLDAS_WIND2004070100.nc" ,icn_data,nFile=4)
          !PRECIPITATION
          !PK CALL InitReadNETCDF("inputdata/GLDAS_PREC2004070100.nc" ,icn_data,nFile=5)
          !DOWNWARD SHORT WAVE RADIATION 
          !PK CALL InitReadNETCDF("inputdata/GLDAS_SWRD2004070100.nc" ,icn_data,nFile=6)
          !DOWNWARD LONG WAVE RADIATION 
          !PK CALL InitReadNETCDF("inputdata/GLDAS_LWRD2004070100.nc" ,icn_data,nFile=7)
       ELSE
          PRINT*,'ERROR',TRIM(icn_data),'diff','ERA5','GLDAS'
          STOP
       END IF    
    END IF

    IF(.NOT.UNDIMENSION)THEN
       rec_local=0
       CALL RunAtmosModel2D(rec_local,1,dt,nband,dt,idate,idatec,idatep,DELTAIN,.TRUE.,iMask)
    ELSE
       CALL RunAtmosModel1D(1,dt,nband,dt,idate,idatec,idatep,DELTAIN,.TRUE.)
    END IF
   
    CALL InitFieldsIbis (iMax,jMax,kMax,ibMax,jbMax,dt,xres,&
                         yres,idate,idatec,path_inp,nfsibd,nfprt,nfsibt,fNameSibVeg,&
                         fNameSibmsk,ifday ,ibMaxPerJB,tod ,fNameIBISMask,fNameSSTAOI,&
                         fNameIBISDeltaTemp,fNameSandMask,fNameClayMask,fNameClimaTemp,RESTART   )
PRINT*,'InitFieldsIbis'
    CALL Init_IbisOutput(nVars,nVarscp,ibMax,jbMax,nsoilay,DELTAOUT,dt,depth)
PRINT*,'Init_IbisOutput'


  END SUBROUTINE InitA
END MODULE InitAll
