PROGRAM MAIN_OFFLINE
  USE Utils, ONLY :tmstmp2,lati

  USE InitAll, ONLY : InitA

  USE Options, ONLY : idate,idatec,idatep,tod,tod2,ifday,ifday2,dt,intg,initlz,ilwrad,iswrad,epsflt,istrt,filta,&
                      DELTAIN,DELTAOUT,maxtim,UNDIMENSION,rootmode

  USE Constants, ONLY: &
       r8,             &
       i8,             &
       pi

  USE Sfc_Ibis_Interface, ONLY : Ibis_Interface

  USE Sizes,ONLY :ibMax,jbMax,kMax

  USE FieldsPhysics, ONLY: iMask,MskAnt

  USE AtmosModel, ONLY : RunAtmosModel2D,FinalizeAtmosModel,RunAtmosModel1D,&
       gu,gv,gq,gt,gps,dcupr_sib,&
       dlspr_sib,radvbc_sib,radnbc_sib,radvdc_sib,radndc_sib,& 
       dlwbot_sib,cosz_sib,ws,psb_g,bps_g,tseam ,tsea,slrad ,&
       tsurf,qsurf,zorl,tmtx,qmtx,umtx ,sigki ,delsig,latic,longc,slhf,sshf,swdown
  USE Sfc_Ibis_Fiels, ONLY:nsoilay

  USE IbisOutput, ONLY : RunOutput,RunOutput1D,RunOutput1D_Grads,RunOutput1D_Grads2
  IMPLICIT NONE
  INTEGER          :: ljdt
  INTEGER          :: limlow=1
  INTEGER          :: nband=2
  INTEGER          :: jdt
  REAL(KIND=r8)   :: ahour
  REAL(KIND=r8)   :: dtc3x
  INTEGER          :: ktp 
  INTEGER          :: kt
  INTEGER          :: ktm
  INTEGER          :: jb
  INTEGER          :: i
  INTEGER          :: nmax
  INTEGER          :: rec 
   
  INTEGER       , ALLOCATABLE :: nsx      (:)
  REAL(KIND=r8), ALLOCATABLE :: mskant8  (:,:)
  REAL(KIND=r8), ALLOCATABLE :: colrad   (:,:)
  REAL(KIND=r8), ALLOCATABLE :: snow     (:,:)
  REAL(KIND=r8), ALLOCATABLE :: speedm   (:,:)
  REAL(KIND=r8), ALLOCATABLE :: taux     (:,:) 
  REAL(KIND=r8), ALLOCATABLE :: tauy     (:,:) 
  REAL(KIND=r8), ALLOCATABLE :: sens     (:,:)  
  REAL(KIND=r8), ALLOCATABLE :: evap     (:,:) 
  REAL(KIND=r8), ALLOCATABLE :: umom     (:,:) 
  REAL(KIND=r8), ALLOCATABLE :: vmom     (:,:) 
  REAL(KIND=r8), ALLOCATABLE :: rmi      (:,:)  
  REAL(KIND=r8), ALLOCATABLE :: rhi      (:,:) 
  REAL(KIND=r8), ALLOCATABLE :: z0       (:,:) 
  REAL(KIND=r8), ALLOCATABLE :: ustar    (:,:) 
  REAL(KIND=r8), ALLOCATABLE :: hc       (:,:) 
  REAL(KIND=r8), ALLOCATABLE :: hg       (:,:) 
  REAL(KIND=r8), ALLOCATABLE :: ec       (:,:) 
  REAL(KIND=r8), ALLOCATABLE :: eg       (:,:) 
  REAL(KIND=r8), ALLOCATABLE :: ts2      (:,:)  
  REAL(KIND=r8), ALLOCATABLE :: qs2      (:,:) 
  REAL(KIND=r8), ALLOCATABLE :: qsfc     (:,:) 
  REAL(KIND=r8), ALLOCATABLE :: tsfc     (:,:) 
  REAL(KIND=r8), ALLOCATABLE :: z0sea    (:,:)  
  REAL(KIND=r8), ALLOCATABLE :: d        (:,:) 
  REAL(KIND=r8), ALLOCATABLE :: cu       (:,:) 
  REAL(KIND=r8), ALLOCATABLE :: Ustarm   (:,:)
  REAL(KIND=r8), ALLOCATABLE :: tgrd     (:,:) 
  REAL(KIND=r8), ALLOCATABLE :: roff     (:,:) 
  REAL(KIND=r8), ALLOCATABLE :: ect      (:,:) 
  REAL(KIND=r8), ALLOCATABLE :: eci      (:,:)  
  REAL(KIND=r8), ALLOCATABLE :: egt      (:,:) 
  REAL(KIND=r8), ALLOCATABLE :: egi      (:,:) 
  REAL(KIND=r8), ALLOCATABLE :: egs      (:,:) 
  REAL(KIND=r8), ALLOCATABLE :: rho      (:,:)  
  REAL(KIND=r8), ALLOCATABLE :: bstar    (:,:) 

  WRITE(0,*)' Init' 
  CALL Init()
  WRITE(0,*)' fim Init' 

  ALLOCATE(nsx        (1:ibMax    )      );nsx     = 0.0_r8
  ALLOCATE(colrad     (1:ibMax  ,1:jbMax));colrad  = 3.140_r8/2.0_r8
  ALLOCATE(snow       (1:ibMax  ,1:jbMax));snow    = 0.0_r8
  ALLOCATE(speedm     (1:ibMax  ,1:jbMax));speedm  = 0.0_r8
  ALLOCATE(taux       (1:ibMax  ,1:jbMax));taux    = 0.0_r8
  ALLOCATE(tauy       (1:ibMax  ,1:jbMax));tauy    = 0.0_r8
  ALLOCATE(sens       (1:ibMax  ,1:jbMax));sens    = 0.0_r8
  ALLOCATE(evap       (1:ibMax  ,1:jbMax));evap    = 0.0_r8
  ALLOCATE(umom       (1:ibMax  ,1:jbMax));umom    = 0.0_r8
  ALLOCATE(vmom       (1:ibMax  ,1:jbMax));vmom    = 0.0_r8
  ALLOCATE(rmi        (1:ibMax  ,1:jbMax));rmi     = 0.0_r8
  ALLOCATE(rhi        (1:ibMax  ,1:jbMax));rhi     = 0.0_r8
  ALLOCATE(z0         (1:ibMax  ,1:jbMax));z0      = 0.0_r8
  ALLOCATE(ustar      (1:ibMax  ,1:jbMax));ustar   = 0.0_r8
  ALLOCATE(hc         (1:ibMax  ,1:jbMax));hc      = 0.0_r8
  ALLOCATE(hg         (1:ibMax  ,1:jbMax));hg      = 0.0_r8
  ALLOCATE(ec         (1:ibMax  ,1:jbMax));ec      = 0.0_r8
  ALLOCATE(eg         (1:ibMax  ,1:jbMax));eg      = 0.0_r8
  ALLOCATE(ts2        (1:ibMax  ,1:jbMax));ts2     = 0.0_r8
  ALLOCATE(qs2        (1:ibMax  ,1:jbMax));qs2     = 0.0_r8
  ALLOCATE(qsfc       (1:ibMax  ,1:jbMax));qsfc    = 0.0_r8
  ALLOCATE(tsfc       (1:ibMax  ,1:jbMax));tsfc    = 0.0_r8
  ALLOCATE(z0sea      (1:ibMax  ,1:jbMax));z0sea   = 0.0_r8
  ALLOCATE(d          (1:ibMax  ,1:jbMax));d       = 0.0_r8
  ALLOCATE(cu         (1:ibMax  ,1:jbMax));cu      = 0.0_r8
  ALLOCATE(Ustarm     (1:ibMax  ,1:jbMax));Ustarm  = 0.0_r8
  ALLOCATE(tgrd       (1:ibMax  ,1:jbMax));tgrd    = 0.0_r8
  ALLOCATE(roff       (1:ibMax  ,1:jbMax));roff    = 0.0_r8
  ALLOCATE(ect        (1:ibMax  ,1:jbMax));ect     = 0.0_r8
  ALLOCATE(eci        (1:ibMax  ,1:jbMax));eci     = 0.0_r8
  ALLOCATE(egt        (1:ibMax  ,1:jbMax));egt     = 0.0_r8
  ALLOCATE(egi        (1:ibMax  ,1:jbMax));egi     = 0.0_r8
  ALLOCATE(egs        (1:ibMax  ,1:jbMax));egs     = 0.0_r8
  ALLOCATE(rho        (1:ibMax  ,1:jbMax));rho     = 0.0_r8
  ALLOCATE(bstar      (1:ibMax  ,1:jbMax));bstar   = 0.0_r8

  rec=0
  tod=0.0_r8
  tod2=tod+DELTAIN
  DO ljdt=limlow,maxtim
     !
     !     step loop starts
     !
     jdt = ljdt
     tod=tod+dt
     tod2=tod2+dt
     IF(ABS( MOD(tod+0.03125_r8,86400.0_r8)-0.03125_r8).LT.0.0625_r8)THEN
        tod=0.0_r8
        ifday=ifday+1
     END IF
     IF(ABS( MOD(tod2+0.03125_r8,86400.0_r8)-0.03125_r8).LT.0.0625_r8)THEN
        tod2=0.0_r8
        ifday2=ifday2+1
     END IF
     CALL tmstmp2(idate,ifday,tod,idatec(1),idatec(3),idatec(2),idatec(4))
     CALL tmstmp2(idate,ifday2,tod2,idatep(1),idatep(3),idatep(2),idatep(4))
     ahour=(ifday*24.0e0_r8)+(tod/3.6e3_r8)
     dtc3x   =dt*REAL(intg,r8)
     IF(jdt<=2)THEN
        istrt=jdt
     ELSE
        istrt=0
     END IF
     CALL run(rec,jdt,tod,DELTAIN)
     kt   =INT(ahour-(1.0e-2_r8))
     ktp  =INT(ahour+(dt/3.6e3_r8)-(1.0e-2_r8))
     IF(jdt.EQ.maxtim) THEN
        ktm=kt
     END IF
     ktm=kt
  END DO
  
  CALL Finalize()
  
CONTAINS

  SUBROUTINE Init()
    IMPLICIT NONE
    
    CALL InitA()
  END SUBROUTINE Init

  SUBROUTINE run(rec,jdt,tod,DELTAIN)
    IMPLICIT NONE
    INTEGER, INTENT(INOUT) :: rec
    INTEGER, INTENT(IN   ) :: jdt
    REAL(KIND=r8), INTENT(IN   ) :: tod
    REAL(KIND=r8), INTENT(IN   ) :: DELTAIN

    !
    IF(.NOT.UNDIMENSION)THEN
      CALL RunAtmosModel2D(rec,jdt,tod,nband,dt,idate,idatec,idatep,DELTAIN,.FALSE.,iMask)
    ELSE
      CALL RunAtmosModel1D(jdt,tod,nband,dt,idate,idatec,idatep,DELTAIN,.FALSE.)
    END IF
    print*,'antes Ibis_Interface',jb,jdt,rec,idatec(1:4) 
    
    DO jb=1,jbMax
        nmax=0
        nsx=0
        DO i=1,ibMax
           IF (iMask(i,jb) >= 1) THEN
              nmax=nmax+1
           END IF
        END DO
        CALL Ibis_Interface(DELTAIN,dt                        ,intg              ,istrt           , &
             jdt                   ,jb                        ,dtc3x                     ,ibMax                     , &
             nmax                  ,kMax                      ,ktm                       ,initlz                    , &
             kt                    ,nsx                       ,iswrad                    ,ilwrad                    , &
             tod                   ,idatec(1:4)               ,filta                     ,epsflt                    , &
             gt        (1:ibMax,jb),gq        (1:ibMax    ,jb),gu        (1:ibMax    ,jb),gv        (1:ibMax    ,jb), &
             gps       (1:ibMax,jb),tmtx      (1:ibMax,1:3,jb),qmtx      (1:ibMax,1:3,jb),umtx      (1:ibMax,1:4,jb), &
             cosz_sib  (1:ibMax,jb),colrad    (1:ibMax    ,jb),dlwbot_sib(1:ibMax    ,jb),radvbc_sib(1:ibMax    ,jb), &
             radvdc_sib(1:ibMax,jb),radnbc_sib(1:ibMax    ,jb),radndc_sib(1:ibMax    ,jb),dlspr_sib (1:ibMax    ,jb), &
             dcupr_sib (1:ibMax,jb),snow      (1:ibMax    ,jb),sigki                     ,delsig                    , & 
             tseam     (1:ibMax,jb),tsea      (1:ibMax    ,jb),mskant    (1:ibMax    ,jb),speedm    (1:ibMax    ,jb), &
             slrad     (1:ibMax,jb),tsurf     (1:ibMax    ,jb),qsurf     (1:ibMax    ,jb),zorl      (1:ibMax    ,jb), &
             taux      (1:ibMax,jb),tauy      (1:ibMax    ,jb),sens      (1:ibMax    ,jb),evap      (1:ibMax    ,jb), & 
             umom      (1:ibMax,jb),vmom      (1:ibMax    ,jb),rmi       (1:ibMax    ,jb),rhi       (1:ibMax    ,jb), &
             z0        (1:ibMax,jb),ustar     (1:ibMax    ,jb),hc        (1:ibMax    ,jb),hg        (1:ibMax    ,jb), & 
             ec        (1:ibMax,jb),eg        (1:ibMax    ,jb),ts2       (1:ibMax    ,jb),qs2       (1:ibMax    ,jb), &
             qsfc      (1:ibMax,jb),tsfc      (1:ibMax    ,jb),z0sea     (1:ibMax    ,jb),d         (1:ibMax    ,jb), &
             cu        (1:ibMax,jb),imask     (1:ibMax    ,jb),Ustarm    (1:ibMax    ,jb),tgrd      (1:ibMax    ,jb), &
             roff      (1:ibMax,jb),ect       (1:ibMax    ,jb),eci       (1:ibMax    ,jb),egt       (1:ibMax    ,jb), &
             egi       (1:ibMax,jb),egs       (1:ibMax    ,jb),rho       (1:ibMax    ,jb),bstar     (1:ibMax    ,jb), &
             slhf      (1:ibMax,jb),sshf      (1:ibMax,jb)   ,swdown     (1:ibMax,jb) ,rootmode)
    END DO

    print*,'depois Ibis_Interface',jb,jdt,rec,idatec(1:4) 

    IF(.NOT.UNDIMENSION)THEN
       CALL RunOutput(jdt,tod,nband,dt,idate,idatec,idatep,DELTAOUT,REAL(latic,kind=r8),REAL(longc,kind=r8))
    ELSE
!      ! CALL RunOutput1D(jdt,tod,nband,dt,idate,idatec,idatep,DELTAOUT,REAL(latic,kind=r8),REAL(longc,kind=r8))
       CALL RunOutput1D_Grads(jdt,tod,nband,dt,idate,idatec,idatep,DELTAOUT,REAL(latic,kind=r8),REAL(longc,kind=r8))
       CALL RunOutput1D_Grads2(jdt,tod,nband,dt,idate,idatec,idatep,DELTAOUT,REAL(latic,kind=r8),REAL(longc,kind=r8))

    END IF
  END SUBROUTINE run

  SUBROUTINE Finalize()
    IMPLICIT NONE
    CALL FinalizeAtmosModel()
  END SUBROUTINE Finalize

END PROGRAM MAIN_OFFLINE
