#!/bin/bash -x
opt=Nwp        #Sa3  ; Nwp  ; Sa1 ; Ma2 ;  CST
par=MILENA      #JACKSON   or   MILENA
path='/cygdrive/d/paulo.kubota/land_Ibis/AgroIBIS_2.6b5_fabi'
cd ${path}
#make -f Makefile linux_dbx

path_in=${path}/inputdata/

if [ ${opt} = "Sa3" ];then
cp  ${path_in}/test_${opt}.txt       ${path_in}/Clima_input.S001
cp  ${path_in}/test_${opt}.txt       ${path_in}/Clim_input.S001
sed 's/MILENA/'${par}'/g'  ${path}/IBISIN_santarem_${opt} > ${path}/IBISIN
fi
if [ ${opt} = "Nwp" ];then
echo test_Npw.txt
cp  ${path_in}/test_${opt}.txt       ${path_in}/Clima_input.S001
cp  ${path_in}/test_${opt}.txt       ${path_in}/Clim_input.S001
sed 's/MILENA/'${par}'/g'  ${path}/IBISIN_NWP > ${path}/IBISIN
fi
if [ ${opt} = "Sa1" ];then
echo test_Sa1.txt
cp  ${path_in}/test_Sa1.txt       ${path_in}/Clima_input.S001
cp  ${path_in}/test_Sa1.txt       ${path_in}/Clim_input.S001
sed 's/MILENA/'${par}'/g'  ${path}/IBISIN_santarem_Sa1 > ${path}/IBISIN

fi
if [ ${opt} = "Ma2" ];then
echo test_Ma2.txt
cp  ${path_in}/test_Ma2.txt       ${path_in}/Clima_input.S001
cp  ${path_in}/test_Ma2.txt       ${path_in}/Clim_input.S001
sed 's/MILENA/'${par}'/g'  ${path}/IBISIN_MANAUS > ${path}/IBISIN
fi
if [ ${opt} = "CST" ];then
echo test_CST.txt
cp  ${path_in}/test_CST.txt       ${path_in}/Clima_input.S001
cp  ${path_in}/test_CST.txt       ${path_in}/Clim_input.S001
sed 's/MILENA/'${par}'/g'  ${path}/IBISIN_Caatinga > ${path}/IBISIN
fi
rm -f ${path}/File.Check
export PBS_SERVER=aux20-eth4
cat<<EOF>${path}/run.bash
#!/bin/bash
#PBS -o eslogin01:${path}/Out.MPI1
#PBS -j oe
#PBS -l walltime=0:30:00
#PBS -A CPTEC
#
#PBS -l mppnppn=1
#PBS -V
#PBS -S /bin/bash
#PBS -N debug_bamh
#PBS -N TopoSpectra
#PBS -q pesq.q

#
export PBS_SERVER=aux20-eth4

export KMP_STACKSIZE=128m
ulimit -s unlimited
#module swap PrgEnv-cray PrgEnv-gnu
#module load netcdf

#
cd ${path}
date
time ${path}/ibis-2.6b5.exe -i ${path}/IBISIN
echo "Finalize Model" > ${path}/File.Check
date
EOF

chmod 777 ${path}/run.bash
${path}/run.bash
#qsub ${path}/run.bash
exit

FILE="${path}/File.Check"
icheck=0
while [ $icheck -le 1 ]; do
   if test -s $FILE; then
      echo "$FILE exists and not empty"
      echo "Welcome $icheck times"
      icheck=$(( $icheck + 1 ))
      teste=`grep "Finalize Model" ${path}/File.Check  |  awk '{print $1}'`
      echo $teste
      if [ $teste != "Finalize" ];then
        sleep 60
      fi
   else
    sleep 60
    echo "$FILE doesn't exist or is empty"
   fi
done

path_out=${path}/outputdata/${opt}/${par}
mkdir -p  ${path_out}

cp ${path}/outputdata/SAIDAMODELIBIS.S001*  ${path_out}/

cd ${path}/outputdata
grads -lc "run ${path}/outputdata/cycle_${opt}.gs"
