PROGRAM MODELRAD
 USE Constants, ONLY : r8,r4,i8,grav
 USE Options  , ONLY : tmstmp2,SetTimeOutput,first,nlcs,mxrdcc,&
                       yrl,nls,monl,iccon
 USE MODRadiationDriver, ONLY  : radtim,InitRadiationDriver,RadiationDriver,DestroyRadiationDriver
 USE VerticalInterpolation, ONLY  : VertSigmaInter
 USE Mod_GET_PRS, ONLY: GET_PRS,GET_PHI,sig2press
 USE PhysicalFunctions,Only : InitPhysicalFunctions
 USE wv_saturation,Only: gestbl

 IMPLICIT NONE
  INTEGER      , PARAMETER :: imax=1
  INTEGER      , PARAMETER :: jmax=1  
  INTEGER      , PARAMETER :: kMaxIn=27
  INTEGER      , PARAMETER :: kMax=42
  REAL(KIND=r8), PARAMETER :: dt      = 3600.0_r8   !Passo de tempo
  REAL(KIND=r8), PARAMETER :: deltout = 3600.0_r8  !Passo de tempo print
  REAL(KIND=r8), PARAMETER :: zero    = 0.0_r8
  REAL(KIND=r8), PARAMETER :: f3600   = 3600.0_r8
  REAL(KIND=r8), PARAMETER :: f10m2   = 1.0e-2_r8
  REAL(KIND=r8), PARAMETER :: f24     = 24.0e0_r8 
  CHARACTER(LEN=12)        :: time0='20z18feb2014'!'00z19feb2014'
  CHARACTER(LEN=3)         :: deltat='1hr'
  REAL(KIND=r8)            :: undef=-999.99999
  REAL(KIND=r8)            :: lon0
  REAL(KIND=r8)            :: lat0
  REAL(KIND=r8)            :: dlon=1.8
  REAL(KIND=r8)            :: dlat=1.8
  INTEGER                  :: nvar
  INTEGER                  :: maxtim     !numero de passos de tempo
  REAL(KIND=r4)            :: IRSo(imax,jmax)
  INTEGER                  :: PlotStep 
  REAL(KIND=r8)            :: lat(jmax)
  REAL(KIND=r8)            :: lon(imax)
  INTEGER                  :: idate(4)
  INTEGER                  :: idatec(4)  
  INTEGER                  :: idatef(4)  
  INTEGER                  :: ifday
  INTEGER                  :: isteps  
  INTEGER                  :: istep    
  INTEGER                  :: limlow 
  INTEGER                  :: kt  
  INTEGER                  :: ktp 
  INTEGER                  :: kdt
  INTEGER                  :: ktm 
  REAL(KIND=r8)            :: tod =0.0   
  INTEGER                  :: jhr 
  INTEGER                  :: jmon
  INTEGER                  :: jday
  INTEGER                  :: jyr 
  REAL(KIND=r8)            :: ahour 
  REAL(KIND=r8)            :: dt2   
  INTEGER                  :: jdt 
  INTEGER                  :: lrec,lrec2
  INTEGER                  :: dhfct
  REAL(KIND=r8)            :: lati(imax)
  REAL(KIND=r8)            :: lonrad  (imax)!=(i-1)*360.0_r8/REAL(iMaxPerJ(j),r8)
  INTEGER(kind=i8)         :: imask(imax)
  REAL(kind=r8)            :: topog(imax)

    ! Atmospheric fields
    REAL(KIND=r8) :: prsiIn   (iMax,kMaxIn+1)
    REAL(KIND=r8) :: prslIn   (iMax,kMaxIn)
    REAL(KIND=r8) :: phiiIn   (iMax,kMaxIn+1)
    REAL(KIND=r8) :: philIn   (iMax,kMaxIn)
    REAL(KIND=r8) :: gpsIN    (iMax)
    REAL(KIND=r8) :: gttIn    (iMax,kMaxIn)
    REAL(KIND=r8) :: gqqIn    (iMax,kMaxIn)
    REAL(KIND=r8) :: tsurfIN  (iMax)
    REAL(KIND=r8) :: omgIn    (iMax,kMaxIn)
    REAL(KIND=r8) :: tseaIN   (iMax)
    REAL(KIND=r8) :: QCFIn    (iMax,kMaxIn)
    REAL(KIND=r8) :: QCLIn    (iMax,kMaxIn)
    REAL(KIND=r8) :: QCRIn    (iMax,kMaxIn)
    REAL(KIND=r8) :: cldfracIn(iMax,kMaxIn)
    REAL(KIND=r8) :: prcptIn    (iMax)

    ! Atmospheric fields
    REAL(KIND=r8) :: prsi   (iMax,kMax+1)
    REAL(KIND=r8) :: prsl   (iMax,kMax)
    REAL(KIND=r8) :: phii   (iMax,kMax+1)
    REAL(KIND=r8) :: phil   (iMax,kMax)
    REAL(KIND=r8) :: gps    (iMax)
    REAL(KIND=r8) :: gtt    (iMax,kmax)
    REAL(KIND=r8) :: gqq    (iMax,kmax)
    REAL(KIND=r8) :: tsurf  (iMax)
    REAL(KIND=r8) :: omg    (iMax,kmax)
    REAL(KIND=r8) :: tsea   (iMax)
    REAL(KIND=r8) :: QCF    (iMax,kMax)
    REAL(KIND=r8) :: QCL    (iMax,kMax)
    REAL(KIND=r8) :: QCR    (iMax,kMax)
    REAL(KIND=r8) :: cldfrac(iMax,kMax)
    REAL(KIND=r8) :: grh    (iMax,kMax)
    REAL(KIND=r8) :: prcpt    (iMax)
    REAL(KIND=r8) :: ad_omg  (iMax,kMax,2)
    REAL(KIND=r8) :: ad_tmp  (iMax,kMax,2)
    REAL(KIND=r8) :: ad_grh  (iMax,kMax,2)
    INTEGER       :: ndtimesCld (iMax)

    ! SURFACE:  albedo
    REAL(KIND=r8) :: AlbVisDiff (iMax)
    REAL(KIND=r8) :: AlbNirDiff (iMax)
    REAL(KIND=r8) :: AlbVisBeam (iMax)
    REAL(KIND=r8) :: AlbNirBeam (iMax)
    ! SW Radiation fields at last integer hour
    REAL(KIND=r8) :: rSwToaDown(iMax)
    REAL(KIND=r8) :: rVisDiff (iMax)
    REAL(KIND=r8) :: rNirDiff (iMax)
    REAL(KIND=r8) :: rVisBeam (iMax)
    REAL(KIND=r8) :: rNirBeam (iMax)
    REAL(KIND=r8) :: rVisDiffC(iMax)
    REAL(KIND=r8) :: rNirDiffC(iMax)
    REAL(KIND=r8) :: rVisBeamC(iMax)
    REAL(KIND=r8) :: rNirBeamC(iMax)
    REAL(KIND=r8) :: rSwSfcNet   (iMax)
    REAL(KIND=r8) :: rSwSfcNetC  (iMax)
    REAL(KIND=r8) :: SwSfcUp (iMax)
    ! SW Radiation fields at next integer hour
    REAL(KIND=r8) :: ySwToaDown(iMax)
    REAL(KIND=r8) :: yVisDiff (iMax)
    REAL(KIND=r8) :: yNirDiff (iMax)
    REAL(KIND=r8) :: yVisBeam (iMax)
    REAL(KIND=r8) :: yNirBeam (iMax)
    REAL(KIND=r8) :: yVisDiffC(iMax)
    REAL(KIND=r8) :: yNirDiffC(iMax)
    REAL(KIND=r8) :: yVisBeamC(iMax)
    REAL(KIND=r8) :: yNirBeamC(iMax)
    REAL(KIND=r8) :: ySwHeatRate   (iMax,kmax)
    REAL(KIND=r8) :: ySwHeatRateC  (iMax,kmax)
    REAL(KIND=r8) :: ySwSfcNet   (iMax)
    REAL(KIND=r8) :: ySwSfcNetC  (iMax)

    ! Radiation field (Interpolated) at time = tod
    REAL(KIND=r8) :: xVisDiff (iMax)
    REAL(KIND=r8) :: xNirDiff (iMax)
    REAL(KIND=r8) :: xVisBeam (iMax)
    REAL(KIND=r8) :: xNirBeam (iMax)
    REAL(KIND=r8) :: xVisDiffC (iMax)
    REAL(KIND=r8) :: xNirDiffC (iMax)
    REAL(KIND=r8) :: xVisBeamC (iMax)
    REAL(KIND=r8) :: xNirBeamC (iMax)

    ! LW Radiation fields at last integer hour
    REAL(KIND=r8) :: LwCoolRate (iMax,kmax)
    REAL(KIND=r8) :: LwSfcDown  (iMax)
    REAL(KIND=r8) :: LwSfcNet   (iMax)
    REAL(KIND=r8) :: LwToaUp    (iMax)
    REAL(KIND=r8) :: LwCoolRateC(iMax,kmax)
    REAL(KIND=r8) :: LwSfcDownC (iMax)
    REAL(KIND=r8) :: LwSfcNetC  (iMax)
    REAL(KIND=r8) :: LwToaUpC	(iMax)

    ! SSIB: Total radiation absorbed at ground
    REAL(KIND=r8)  :: slrad(iMax)

    ! SSIB INIT: Solar radiation with cos2
    REAL(KIND=r8)  :: ssib_VisBeam (iMax)
    REAL(KIND=r8)  :: ssib_VisDiff (iMax)
    REAL(KIND=r8)  :: ssib_NirBeam (iMax)
    REAL(KIND=r8)  :: ssib_NirDiff (iMax)

    ! Cloud field
    REAL(KIND=r8) :: cldsav   (iMax)
    REAL(KIND=r8) :: CldCovTot(iMax,kmax)
    REAL(KIND=r8) :: CldCovInv(iMax,kmax)
    REAL(KIND=r8) :: CldCovSat(iMax,kmax)
    REAL(KIND=r8) :: CldCovCon(iMax,kmax)
    REAL(KIND=r8) :: CldCovSha(iMax,kmax)

    ! Microphysics
    REAL(KIND=r8) :: CldLiqWatPath  (iMax,kmax)
    REAL(KIND=r8) :: emisd (iMax,kmax)
    REAL(KIND=r8) :: taud  (iMax,kmax)
    REAL(KIND=r8) :: EFFCS (iMax,kmax)
    REAL(KIND=r8) :: EFFIS (iMax,kmax)

    ! Chemistry
    REAL(KIND=r8) :: o3mix(iMax,kMax)   
    REAL(KIND=r8) :: co2m(iMax,kMax)   !mol/mol
    REAL(KIND=r8) :: dump(iMax,kMax) 
    REAL(KIND=r8) :: CLDF(iMax,kMax)
!tar begin  
! climate aerosol optical parameters of coarse mode
!
    REAL(KIND=r8) :: aod(iMax,14)
    REAL(KIND=r8) :: asy(iMax,14)    
    REAL(KIND=r8) :: ssa(iMax,14)    
    REAL(KIND=r8) :: z_aer(iMax,40)
!        
!tar end 
!
!tar begin  
! climate aerosol optical parameters of fine mode
!
    REAL(KIND=r8) :: aodF(iMax,14)
    REAL(KIND=r8) :: asyF(iMax,14)    
    REAL(KIND=r8) :: ssaF(iMax,14)    
    REAL(KIND=r8) :: z_aerF(iMax,40)
    REAL(KIND=r8) :: DeltaP(kMax)
    REAL(KIND=r4) :: aux   (iMax,KmaxIn)  
    REAL(KIND=r4) :: aux2  (iMax) 
    INTEGER, PARAMETER :: Unit31=31
    INTEGER, PARAMETER :: Unit32=32
    INTEGER, PARAMETER :: Unit33=33
    INTEGER, PARAMETER :: Unit34=34
    INTEGER, PARAMETER :: Unit35=35
    INTEGER, PARAMETER :: Unit36=36
    INTEGER, PARAMETER :: Unit37=37
    INTEGER, PARAMETER :: Unit38=38
    INTEGER, PARAMETER :: Unit39=39
    INTEGER :: irec=0
    INTEGER :: irec2=0
    INTEGER :: irec3=0
    INTEGER :: ntime
    REAL(KIND=r4) :: albedo  

    REAL(KIND=r8), PARAMETER ::PDEF(kMaxIn)=(/1000.0_r8, 975.0_r8, 950.0_r8, 925.0_r8, 900.0_r8,&
                                               875.0_r8, 850.0_r8, 825.0_r8, 800.0_r8, 775.0_r8,&
                                               750.0_r8, 700.0_r8, 650.0_r8, 600.0_r8, 550.0_r8,&
                                               500.0_r8, 450.0_r8, 400.0_r8, 350.0_r8, 300.0_r8,&
                                               250.0_r8, 225.0_r8, 200.0_r8, 175.0_r8, 150.0_r8,&
                                               125.0_r8, 100.0_r8/) 

    REAL(KIND=r8), PARAMETER ::a_hybr(kMax+1)=(/      .000_r8,          .000_r8,        1.934_r8,       22.949_r8, &
                                                    82.986_r8,       199.750_r8,      391.250_r8,      675.265_r8, &
                                                  1068.610_r8,      1586.215_r8,     2240.051_r8,     3037.925_r8, &
                                                  3982.226_r8,      5068.710_r8,     6285.476_r8,     7612.263_r8, &
                                                  9020.227_r8,     10472.313_r8,    11924.286_r8,    13326.392_r8, &
                                                 14625.550_r8,     15767.873_r8,    16701.271_r8,    17377.869_r8, &
                                                 17756.019_r8,     17801.724_r8,    17489.420_r8,    16812.225_r8, &
                                                 15812.992_r8,     14552.540_r8,    13097.874_r8,    11520.933_r8, &
                                                  9897.348_r8,      8305.282_r8,     6824.375_r8,     5511.896_r8, &
                                                  4361.609_r8,      3356.837_r8,     2481.735_r8,     1721.505_r8, &
                                                  1062.530_r8,       492.416_r8,         .000_r8 /)

    REAL(KIND=r8), PARAMETER ::b_hybr(kMax+1)=(/1.00000000_r8, .99197450_r8, .98272560_r8, .97192966_r8, &
                                               .95922528_r8, .94426634_r8, .92670039_r8, .90617952_r8, &
                                               .88237470_r8, .85499376_r8, .82380243_r8, .78864794_r8, &
                                               .74948356_r8, .70639231_r8, .65960709_r8, .60952439_r8, &
                                               .55670866_r8, .50188499_r8, .44591905_r8, .38978444_r8, &
                                               .33451989_r8, .28117990_r8, .23078383_r8, .18426853_r8, &
                                               .14244900_r8, .10599051_r8, .07539334_r8, .05088901_r8, &
                                               .03213383_r8, .01853460_r8, .00937715_r8, .00385071_r8, &
                                               .00107227_r8, .00010929_r8, .00000000_r8, .00000000_r8, &
                                               .00000000_r8, .00000000_r8, .00000000_r8, .00000000_r8, &
                                               .00000000_r8, .00000000_r8, .00000000_r8 /)

    REAL(KIND=r8), PARAMETER ::PSurf(1)=100.0_r8*PDEF(1)*(1.0_r8 + 0.001_r8)

   INTEGER i,k,j
  cldsav   =0.0_r8;  CldCovTot=0.0_r8;  CldCovInv=0.0_r8
  CldCovSat=0.0_r8;  CldCovCon=0.0_r8;  CldCovSha=0.0_r8;ad_tmp=0.0_r8;ad_grh=0.0_r8
  QCF=0.0_r8;QCL=0.0_r8;QCR=0.0_r8;CLDF=0.0_r8;ad_omg=0.0_r8;ndtimesCld=0
  INQUIRE(IOLENGTH=lrec)aux
  OPEN(Unit31,FILE='dados_entrada/ERA5_cf_IOP1.bin',ACCESS='DIRECT',FORM='UNFORMATTED',RECL=lrec,&
       ACTION='READ',STATUS='OLD')

  OPEN(Unit32,FILE='dados_entrada/ERA5_qi_IOP1.bin',ACCESS='DIRECT',FORM='UNFORMATTED',RECL=lrec,&
       ACTION='READ',STATUS='OLD')

  OPEN(Unit33,FILE='dados_entrada/ERA5_qc_IOP1.bin',ACCESS='DIRECT',FORM='UNFORMATTED',RECL=lrec,&
       ACTION='READ',STATUS='OLD')

  OPEN(Unit34,FILE='dados_entrada/ERA5_t_IOP1.bin',ACCESS='DIRECT',FORM='UNFORMATTED',RECL=lrec,&
       ACTION='READ',STATUS='OLD') 

  OPEN(Unit35,FILE='dados_entrada/ERA5_q_IOP1.bin',ACCESS='DIRECT',FORM='UNFORMATTED',RECL=lrec,&
       ACTION='READ',STATUS='OLD')

  OPEN(Unit36,FILE='dados_entrada/ERA5_omega_IOP1.bin',ACCESS='DIRECT',FORM='UNFORMATTED',RECL=lrec,&
       ACTION='READ',STATUS='OLD')

  INQUIRE(IOLENGTH=lrec2)aux2
  OPEN(Unit37,file='dados_entrada/ERA5_prec_IOP1.bin',ACCESS='DIRECT',FORM='UNFORMATTED',RECL=lrec2,&
       ACTION='READ',STATUS='OLD')


  OPEN(Unit38,FILE='dados_saida/radiation.bin',ACCESS='DIRECT',RECL=lrec2,&
           STATUS='UNKNOWN',FORM='UNFORMATTED',ACTION='WRITE') 
  

  OPEN(Unit39,file='dados_saida/radiation.ctl',access='sequential',form='formatted', status='unknown',&
       action='WRITE')

  PlotStep = NINT(deltOut/dt)



  idate(1) =   00    ! initial hour of GMT
  idate(3) =   19    ! day of month.
  idate(2) =   02    ! month of year.
  idate(4) = 2014    ! year.

  idatef(1) =   00    ! initial hour of GMT
  idatef(3) =   25    ! day of month.
  idatef(2) =   03    ! month of year.
  idatef(4) = 2014    ! year.

  time0='20z18feb2014'!'00z19feb2014'
  deltat='1hr'
  lati     = -2.2_r8  ! Latitude -90 <->  90 
  lonrad   = 300.0_r8 ! Longitude  0 <-> 360
  lat0=lati(1)
  lon0=lonrad(1)
  imask    =  1_i8    ! rainfall forest
  albedo   =0.14_r8

  AlbVisDiff = albedo/4.0_r8
  AlbNirDiff = albedo/4.0_r8
  AlbVisBeam = albedo/4.0_r8
  AlbNirBeam = albedo/4.0_r8
  o3mix =2e-6_r8
  co2m  =350e-6_r8
  EFFCS =1e-6
  EFFIS =1e-6
  idatec   = idate 
  ifday    =  0
  dhfct    =  1
  isteps   =  1
  istep    =  1
  limlow   =  1
  first    = .true.
  DO k=1,kMax+1
     DO i=1,iMax 
       prsi(i,k  ) =         a_hybr(k)   + b_hybr(k) * PSurf(1)
     END DO
  END DO
  DO k=1,kMax
     DO i=1,iMax 
       prsl(i,k) = (prsi(i,k+1)+prsi(i,k))/2.0_r8
     END DO
  END DO
  tsurfIN =+299.0
  tseaIN  =-295.0
  CALL gestbl()
  CALL InitPhysicalFunctions() 
  CALL SetTimeOutput(dt,idate ,idatef,dhfct ,maxtim) 
  
    nls=5!numero de niveis acima de 200 hPa
    IF (nls == 0) nls=1
    nlcs=kMax+2
  CALL InitRadiationDriver(monl,yrl,kmax,a_hybr,b_hybr,dt,nls)
  tod=idate(1)*f3600
  ntime=0
  irec =0
  irec2=0
  irec3=0  
  DO jdt=limlow,maxtim
      kdt=jdt
      IF(jdt>1)tod=tod+dt
      IF(abs( mod(tod+0.03125_r8,86400.0_r8)-0.03125_r8).lt.0.0625_r8)THEN
        tod=zero
        ifday=ifday+1
      END IF     
      CALL tmstmp2(idate,ifday,tod,jhr,jday,jmon,jyr)
      idatec(1)=jhr
      idatec(2)=jmon
      idatec(3)=jday
      idatec(4)=jyr
      ahour=ifday*f24+tod/f3600
      kt   =int(ahour-f10m2)
      ktp  =int(ahour+dt/f3600-f10m2)
      WRITE(*,*)'timestep=',jdt,tod,jhr,jday,jmon,jyr     
      IF(jdt.eq.maxtim.and.istep.eq.isteps) THEN
         ktm=kt
      END IF

      CALL Dynamics(iMax,kMax,KmaxIn,PDEF,&
      prsiIn ,prslIn ,phiiIn ,philIn ,PSurf,gttIn  ,&
      gqqIn  ,tsurfIN,omgIn  ,tseaIN ,QCFIn,QCLIn  ,&
      QCRIn  ,cldfracIn,prcptIn,imask,&
      prsi   ,prsl   ,phii   ,phil   ,gps  ,gtt    ,&
      gqq    ,tsurf  ,omg    ,tsea   ,QCF  ,QCL    ,&
      QCR    ,cldfrac,grh,prcpt,&
      Unit31,Unit32,Unit33,Unit34,Unit35,Unit36,&
      Unit37,irec ,irec2,irec3)


      CALL TimeStep(ifday,kt,idate,idatec,tod,jdt,dt,lati,lonrad,imask,topog,&
    ! Atmospheric fields
                      prsi  ,&
                      prsl  ,&
                      phii  ,&
                      phil  ,&
                      gps   ,&
                      gtt   ,&
                      gqq   ,&
                      tsurf ,&
                      omg   ,&
                      ad_omg,&
                      ad_tmp,&
                      ad_grh,&
                      tsea  ,&
                      QCF   ,&
                      QCL   ,&
                      QCR   ,&
                      prcpt ,&
                      ndtimesCld,&
    ! SURFACE:  albedo
                      AlbVisDiff  ,&
                      AlbNirDiff  ,&
                      AlbVisBeam  ,&
                      AlbNirBeam  ,&
    ! SW Radiation fields at last integer hour
                      rSwToaDown  ,&
                      rVisDiff    ,&
                      rNirDiff    ,&
                      rVisBeam    ,&
                      rNirBeam    ,&
                      rVisDiffC   ,&
                      rNirDiffC   ,&
                      rVisBeamC   ,&
                      rNirBeamC   ,&
                      rSwSfcNet   ,&
                      rSwSfcNetC  ,&
                      SwSfcUp     ,&
    ! SW Radiation fields at next integer hour
                      ySwToaDown  ,&
                      yVisDiff    ,&
                      yNirDiff    ,&
                      yVisBeam    ,&
                      yNirBeam    ,&
                      yVisDiffC   ,&
                      yNirDiffC   ,&
                      yVisBeamC   ,&
                      yNirBeamC   ,&
                      ySwHeatRate ,&
                      ySwHeatRateC,&
                      ySwSfcNet   ,&
                      ySwSfcNetC  ,&

    ! Radiation field (Interpolated) at time = tod
                      xVisDiff    ,&
                      xNirDiff    ,&
                      xVisBeam    ,&
                      xNirBeam    ,&
                      xVisDiffC   ,&
                      xNirDiffC   ,&
                      xVisBeamC   ,&
                      xNirBeamC   ,&

    ! LW Radiation fields at last integer hour
                      LwCoolRate  ,&
                      LwSfcDown   ,&
                      LwSfcNet    ,&
                      LwToaUp     ,&
                      LwCoolRateC ,&
                      LwSfcDownC  ,&
                      LwSfcNetC   ,&
                      LwToaUpC    ,&

    ! SSIB: Total radiation absorbed at ground
                      slrad       ,&

    ! SSIB INIT: Solar radiation with cos2
                     ssib_VisBeam ,&
                     ssib_VisDiff ,&
                     ssib_NirBeam ,&
                     ssib_NirDiff ,&

    ! Cloud field
                      cldsav     , &
                      CldCovTot  , &
                      CldCovInv  , &
                      CldCovSat  , &
                      CldCovCon  , &
                      CldCovSha  , &

    ! Microphysics
                      CldLiqWatPath  , &
                      emisd , &
                      taud  , &
                      EFFCS , &
                      EFFIS , &

    ! Chemistry
                      o3mix, &   
                      co2m , &!mol/mol
                      dump , & 
                      CLDF , &
!tar begin  
! climate aerosol optical parameters of coarse mode
!
                      aod    ,&
                      asy    ,&
                      ssa    ,&
                      z_aer  ,&
!        
!tar end 
!
!tar begin  
! climate aerosol optical parameters of fine mode
!
                      aodF    ,&
                      asyF    ,&
                      ssaF    ,&
                      z_aerF  ,&


                    iMax,kmax)

      ktm=kt
      dt2=dt+dt
      
      IF(MOD(jdt,plotstep)==0) THEN
          ntime=ntime+1
          CALL DUMPFIELDS(iMax,kMax,irec3,Unit38 ,aux2 )
         limlow=1
      END IF

  END DO


 nvar=19
WRITE(Unit39,'(A6,A               )')'dset  ','^radiation.bin'
WRITE(Unit39,'(A6,F12.5           )')'undef ',undef
WRITE(Unit39,'(A6,I6,A8,2F12.4    )')'xdef  ',iMax ,' linear ',lon0 ,dlon
WRITE(Unit39,'(A6,I6,A8,2F12.4    )')'ydef  ',jMax ,' linear ',lat0 ,dlat
WRITE(Unit39,'(A6,I6,A8,A12,A,A3  )')'tdef  ',ntime,' linear ',time0,'  ', deltat
WRITE(Unit39,'(A6,I6,A8           )')'zdef  ',kMax ,' levels '
WRITE(Unit39,'(10F15.5            )')(prsl(1,k)/100.0,k=1,kMax)
WRITE(Unit39,'(A6,I6              )')'VARS  ',nvar
WRITE(Unit39,'(A6,I6,A            )')'gtmp  ',kMax,' 99 absolute temperature '
WRITE(Unit39,'(A6,I6,A            )')'shmt  ',kMax,' 99 specific humidity '
WRITE(Unit39,'(A6,I6,A            )')'omg   ',kMax,' 99 vertical velocity '
WRITE(Unit39,'(A6,I6,A            )')'grh   ',kMax,' 99 relativa humidity '
WRITE(Unit39,'(A6,I6,A            )')'prec  ',kMax-kMax,' 99 precipitation  '
WRITE(Unit39,'(A6,I6,A            )')'css   ',kMax-kMax,' 99 Cloud cover      '
WRITE(Unit39,'(A6,I6,A            )')'CldTot',kMax,' 99 Total cloud cover (at each layer)          '
WRITE(Unit39,'(A6,I6,A            )')'CldInv',kMax,' 99  Inversion clouds '
WRITE(Unit39,'(A6,I6,A            )')'CldSat',kMax,' 99  Saturation clouds'
WRITE(Unit39,'(A6,I6,A            )')'CldCon',kMax,' 99  Convection clouds '
WRITE(Unit39,'(A6,I6,A            )')'CldSha',kMax,' 99  Shallow convective clouds'
WRITE(Unit39,'(A6,I6,A            )')'fliq  ',kMax,' 99  liquid water clouds'
WRITE(Unit39,'(A6,I6,A            )')'fice  ',kMax,' 99  ice water  clouds'
WRITE(Unit39,'(A6,I6,A            )')'ftot  ',kMax,' 99  SAM Total cloud cover '
WRITE(Unit39,'(A6,I6,A            )')'adomg ',kMax,' 99  daily mean vertical velocity'
WRITE(Unit39,'(A6,I6,A            )')'adtmp ',kMax,' 99  daily mean temperature'
WRITE(Unit39,'(A6,I6,A            )')'adgrh ',kMax,' 99  daily mean relative humidity'
WRITE(Unit39,'(A6,I6,A            )')'ocis  ',kMax-kMax,' 99  shortwave downward at ground'
WRITE(Unit39,'(A6,I6,A            )')'ocic  ',kMax-kMax,' 99  shortwave downward at ground clear sky'

WRITE(Unit39,'(A7                 )')'ENDVARS'
 CLOSE(Unit39,STATUS='KEEP')

CONTAINS
    SUBROUTINE DUMPFIELDS(iMax,kMax,irec3,Unit38 ,var1 )
      IMPLICIT NONE
      INTEGER , INTENT(IN   )      :: iMax,kMax,Unit38
      INTEGER , INTENT(INOUT)      :: irec3
      REAL(KIND=r4), INTENT(INOUT) :: var1(iMax)
      INTEGER :: i,k 
!  print*, prsl
      DO k=1,kMax
         DO i=1,iMax
            var1(i) = real(gtt(i,k))
            irec3=irec3+1
            write(Unit38,rec=irec3) real(var1(i))
         END DO
      END DO
!  print*, prsl
      DO k=1,kMax
         DO i=1,iMax
            var1(i) = real(gqq(i,k))
            irec3=irec3+1
            write(Unit38,rec=irec3) real(var1(i))
         END DO
      END DO
!  print*, prsl
      DO k=1,kMax
         DO i=1,iMax
            var1(i) = real(omg(i,k))
            irec3=irec3+1
            write(Unit38,rec=irec3) real(var1(i))
         END DO
      END DO
!  print*, prsl
      DO k=1,kMax
         DO i=1,iMax
            var1(i) = real(grh(i,k))
            irec3=irec3+1
            write(Unit38,rec=irec3) real(var1(i))
         END DO
      END DO
!  print*, prsl
      DO i=1,iMax
         var1(i) = real(prcpt(i))
         irec3=irec3+1
         write(Unit38,rec=irec3) real(var1(i))
      END DO
    ! ___________
    ! Cloud field
    ! cldsav......Cloud cover
      DO i=1,iMax
         var1(i) = real(cldsav(i))
         irec3=irec3+1
         write(Unit38,rec=irec3) real(var1(i))
      END DO

    ! CldCovTot......Total cloud cover (at each layer)
      DO k=1,kMax
         DO i=1,iMax
            var1(i) = real(CldCovTot(i,k))
            irec3=irec3+1
            write(Unit38,rec=irec3) real(var1(i))
         END DO
      END DO
!
    ! CldCovInv......Inversion clouds                 
      DO k=1,kMax
         DO i=1,iMax
            var1(i) = real(CldCovInv(i,k))
            irec3=irec3+1
            write(Unit38,rec=irec3) real(var1(i))
         END DO
      END DO
    ! CldCovSat......Saturation clouds                
      DO k=1,kMax
         DO i=1,iMax
            var1(i) = real(CldCovSat(i,k))
            irec3=irec3+1
            write(Unit38,rec=irec3) real(var1(i))
         END DO
      END DO
    ! CldCovCon......Convection clouds
      DO k=1,kMax
         DO i=1,iMax
            var1(i) = real(CldCovCon(i,k))
            irec3=irec3+1
            write(Unit38,rec=irec3) real(var1(i))
         END DO
      END DO
    ! CldCovSha......Shallow convective clouds        
      DO k=1,kMax
         DO i=1,iMax
            var1(i) = real(CldCovSha(i,k))
            irec3=irec3+1
            write(Unit38,rec=irec3) real(var1(i))
         END DO
      END DO
    ! CldCovSha......clouds liquid water
      DO k=1,kMax
         DO i=1,iMax
            var1(i) = real(QCL(i,k))
            irec3=irec3+1
            write(Unit38,rec=irec3) real(var1(i))
         END DO
      END DO
    ! CldCovSha......clouds ice water
      DO k=1,kMax
         DO i=1,iMax
            var1(i) = real(QCF(i,k))
            irec3=irec3+1
            write(Unit38,rec=irec3) real(var1(i))
         END DO
      END DO
    ! CldCovSha......SAM Total clouds        
      DO k=1,kMax
         DO i=1,iMax
            var1(i) = real(cldfrac(i,k))
            irec3=irec3+1
            write(Unit38,rec=irec3) real(var1(i))
         END DO
      END DO
    ! Atmos......omega daily
      DO k=1,kMax
         DO i=1,iMax
            var1(i) = real(ad_omg(i,k,2))
            irec3=irec3+1
            write(Unit38,rec=irec3) real(var1(i))
         END DO
      END DO
    ! Atmos......temp daily
      DO k=1,kMax
         DO i=1,iMax
            var1(i) = real(ad_tmp(i,k,2))
            irec3=irec3+1
            write(Unit38,rec=irec3) real(var1(i))
         END DO
      END DO
    ! Atmos......rh daily
      DO k=1,kMax
         DO i=1,iMax
            var1(i) = real(ad_grh(i,k,2))
            irec3=irec3+1
            write(Unit38,rec=irec3) real(var1(i))
         END DO
      END DO
      !shortwave downward at ground
      DO i=1,iMax
         var1(i) = real(xVisDiff(i)+xVisBeam(i)+xNirDiff(i)+xNirBeam(i))
         irec3=irec3+1
         write(Unit38,rec=irec3) real(var1(i))
      END DO

      !shortwave downward at ground clear sky
      DO i=1,iMax
         var1(i) = real(xVisDiffC(i)+xVisBeamC(i)+xNirDiffC(i)+xNirBeamC(i))
         irec3=irec3+1
         write(Unit38,rec=irec3) real(var1(i))
      END DO

    END SUBROUTINE DUMPFIELDS

    SUBROUTINE Dynamics(iMax,kMax,KmaxIn,PDEF,&
      prsiIn ,prslIn ,phiiIn ,philIn ,gpsIN,gttIn  ,&
      gqqIn  ,tsurfIN,omgIn  ,tseaIN ,QCFIn,QCLIn  ,&
      QCRIn  ,cldfracIn,prcptIn,imask,&
      prsi   ,prsl   ,phii   ,phil   ,gps  ,gtt    ,&
      gqq    ,tsurf  ,omg    ,tsea   ,QCF  ,QCL    ,&
      QCR    ,cldfrac,grh,prcpt  ,&
      Unit31,Unit32,Unit33,Unit34,Unit35,Unit36,&
      Unit37,irec ,irec2,irec3)
      IMPLICIT NONE

    INTEGER , INTENT(IN   )      :: iMax,kMax,KmaxIn
    INTEGER(kind=i8) , INTENT(IN   )      :: imask(iMax)
    ! Atmospheric fields
    REAL(KIND=r8), INTENT(IN   ) :: PDEF(kMaxIn)
    REAL(KIND=r8), INTENT(INOUT) :: prsiIn   (iMax,kMaxIn+1)
    REAL(KIND=r8), INTENT(INOUT) :: prslIn   (iMax,kMaxIn)
    REAL(KIND=r8), INTENT(INOUT) :: phiiIn   (iMax,kMaxIn+1)
    REAL(KIND=r8), INTENT(INOUT) :: philIn   (iMax,kMaxIn)
    REAL(KIND=r8), INTENT(IN   ) :: gpsIN    (iMax)
    REAL(KIND=r8), INTENT(INOUT) :: gttIn    (iMax,kMaxIn)
    REAL(KIND=r8), INTENT(INOUT) :: gqqIn    (iMax,kMaxIn)
    REAL(KIND=r8), INTENT(INOUT) :: tsurfIN  (iMax)
    REAL(KIND=r8), INTENT(INOUT) :: omgIn    (iMax,kMaxIn)
    REAL(KIND=r8), INTENT(INOUT) :: tseaIN   (iMax)
    REAL(KIND=r8), INTENT(INOUT) :: QCFIn    (iMax,kMaxIn)
    REAL(KIND=r8), INTENT(INOUT) :: QCLIn    (iMax,kMaxIn)
    REAL(KIND=r8), INTENT(INOUT) :: QCRIn    (iMax,kMaxIn)
    REAL(KIND=r8), INTENT(INOUT) :: cldfracIn(iMax,kMaxIn)
    REAL(KIND=r8), INTENT(INOUT) :: prcptIn(iMax)

    ! Atmospheric fields
    REAL(KIND=r8), INTENT(IN    ) :: prsi   (iMax,kMax+1)
    REAL(KIND=r8), INTENT(IN    ) :: prsl   (iMax,kMax)
    REAL(KIND=r8), INTENT(OUT   ) :: phii   (iMax,kMax+1)
    REAL(KIND=r8), INTENT(OUT   ) :: phil   (iMax,kMax)
    REAL(KIND=r8), INTENT(OUT   ) :: gps    (iMax)
    REAL(KIND=r8), INTENT(OUT   ) :: gtt    (iMax,kmax)
    REAL(KIND=r8), INTENT(OUT   ) :: gqq    (iMax,kmax)
    REAL(KIND=r8), INTENT(OUT   ) :: tsurf  (iMax)
    REAL(KIND=r8), INTENT(OUT   ) :: omg    (iMax,kmax)
    REAL(KIND=r8), INTENT(OUT   ) :: tsea   (iMax)
    REAL(KIND=r8), INTENT(OUT   ) :: QCF    (iMax,kMax)
    REAL(KIND=r8), INTENT(OUT   ) :: QCL    (iMax,kMax)
    REAL(KIND=r8), INTENT(OUT   ) :: QCR    (iMax,kMax)
    REAL(KIND=r8), INTENT(OUT   ) :: cldfrac(iMax,kMax)
    REAL(KIND=r8), INTENT(OUT   ) :: grh    (iMax,kMax)
    REAL(KIND=r8), INTENT(OUT   ) :: prcpt(iMax)

    INTEGER, INTENT(IN   ) :: Unit31
    INTEGER, INTENT(IN   ) :: Unit32
    INTEGER, INTENT(IN   ) :: Unit33
    INTEGER, INTENT(IN   ) :: Unit34
    INTEGER, INTENT(IN   ) :: Unit35
    INTEGER, INTENT(IN   ) :: Unit36
    INTEGER, INTENT(IN   ) :: Unit37
    INTEGER, INTENT(INOUT) :: irec ,irec2,irec3
    REAL(KIND=r8) :: grhin(iMax,KmaxIn) 
    REAL(KIND=r8) :: rs(iMax,KmaxIn) 
    REAL(KIND=r8) :: es(iMax,KmaxIn) 
    REAL(KIND=r8) :: TEMPC,PRESS
    REAL(KIND=r4) :: aux   (iMax,KmaxIn)  
    REAL(KIND=r4) :: aux2  (iMax) 
    INTEGER, PARAMETER :: Nt=4
    REAL (KIND=r8) :: q1(iMax,kMaxIn,Nt)
    REAL (KIND=r8) :: q2(iMax,kMax,Nt)
    REAL (KIND=r8) :: prsik  (1:iMax,1:kMax+1)
    REAL (KIND=r8) :: prslk  (1:iMax,1:kMax)  
    REAL (KIND=r8) ::del(1:iMax,1:kMax)  
    INTEGER   :: k,i
      prsik=0.0_r8
      prslk=0.0_r8
      del=0.0_r8
      irec=irec+1
      irec2=irec2+1
      gps=gpsIN
      tsurf  =tsurfin
      tsea =  tseain  
      DO k=1,KmaxIn
         DO i=1,iMax
             prslIn(i,k)=100.0_r8*PDEF(k)
         END DO
      END DO

      !********** Cloud Fraction "%" ()***********
      READ(Unit31,rec=irec)aux
      DO k=1,KmaxIn
         DO i=1,iMax
            cldfracIn(i,k)=aux(i,k)
         END DO
      END DO
      !********** Mixed Ratio ice water "kg/Kg" (Eq. 2.64 do Wallace e Hobbs)***********
      READ(Unit32,rec=irec)aux
      DO k=1,KmaxIn
         DO i=1,iMax
            QCFIn (i,k)=aux(i,k)!/1000.0
         END DO
      END DO
      !********** Mixed Ratio  liquid water "kg/Kg" (Eq. 2.64 do Wallace e Hobbs)***********
      READ(Unit33,rec=irec)aux
      DO k=1,KmaxIn
         DO i=1,iMax
            QCLIn (i,k)=aux(i,k)!/1000.0
         END DO
      END DO
      !**********Temperature "K" (Eq. 2.64 do Wallace e Hobbs)***********
      READ(Unit34,rec=irec)aux
      DO k=1,KmaxIn
         DO i=1,iMax
            gttIn (i,k)=aux(i,k)
         END DO
      END DO
      !********** Relative Hunidity "%" (Eq. 2.64 do Wallace e Hobbs)***********
      READ(Unit35,rec=irec)aux
      DO k=1,KmaxIn
         DO i=1,iMax
            gqqIn(i,k)=aux(i,k)!/1000.0_r8            !g/kg ---> kg/kg
            TEMPC=gttIn(i,k)-273.16_r8
            !********Pressao de vapor de saturacao "hPa" (Eq. 10 do Bolton, 1980)*******
            es(i,k)=6.112_r8*EXP(17.67*TEMPC/(243.5_r8 + TEMPC))     
            PRESS=PDEF(k)
            !**** Razao de mistura de saturacao "kg/Kg" (Eq. 2.64 do Wallace e Hobbs)****
            rs(i,k)=(es(i,k)*622.0_r8/(PRESS-es(i,k)))/1000.0_r8
            !************************* Umidade Relativa "%"*****************************
            grhin(i,k)=gqqIn(i,k)/rs(i,k)
         END DO
      END DO
      !********** Omega "Pa/s" (Eq. 2.64 do Wallace e Hobbs)***********
      READ(Unit36,rec=irec)aux
      DO k=1,KmaxIn
         DO i=1,iMax
            !omg=((aux)/10.0_r8)/3600.0_r8  !  mb/hr --- > cb/sec
            !omgIn (i,k)=((aux(i,k)/10.0_r8)/3600.0_r8)

            omgIn (i,k)=((aux(i,k)/1000.0_r8))
         END DO
      END DO

      !********** Precipitation mm/h" (Eq. 2.64 do Wallace e Hobbs)***********
      READ(Unit37,rec=irec2)aux2
      DO i=1,iMax
         !    Comvert (mm/hr)  to (m) 
         !prcpt(i)=(aux2(i)/1000.0)*3 ! convective precipitation [m]
         prcpt(i)=aux2(i)             ! convective precipitation [m]
      END DO


      DO k=1,KmaxIn
         DO i=1,iMax
            q1(i,k,1)=gqqIn(i,k)
            q1(i,k,2)=QCFIn (i,k)
            q1(i,k,3)=QCLIn (i,k)
            q1(i,k,4)=grhin(i,k)
         END DO
      END DO

      CALL VertSigmaInter (iMax  , 1    , KmaxIn    , Kmax    , Nt, &
                           prslIn, omgIn, cldfracIn , gttIn   , q1, &
                           prsl  , omg  , cldfrac   , gtt     , q2  )


      DO k=1,Kmax
         DO i=1,iMax
            gqq(i,k) =q2(i,k,1)
            QCF (i,k)=q2(i,k,2)
            QCL (i,k)=q2(i,k,3)
            grh (i,k)=q2(i,k,4)
!PRINT*,prsl(i,k), omg(i,k), cldfrac(i,k) , gtt(i,k),gqq(i,k),QCF (i,k),QCL (i,k)

         END DO
      END DO
    CALL GET_PHI(&
                     iMax                            , &!INTEGER         , INTENT(IN   ) :: ix
                     kMax                            , &!INTEGER         , INTENT(IN   ) :: levs
                     1                               , &!INTEGER         , INTENT(IN   ) :: ntrac
                     gtt    (1:iMax,1:kMax)          , &!REAL(kind=r8), INTENT(IN   ) :: T(ix,levs)
                     gqq    (1:iMax,1:kMax)          , &!REAL(kind=r8), INTENT(IN   ) :: q(ix,levs)
                     prsi   (1:iMax,1:kMax+1)        , &!REAL(kind=r8), INTENT(IN   ) :: prsi(ix,levs+1)
                     prsik  (1:iMax,1:kMax+1)        , &!REAL(kind=r8), INTENT(IN   ) :: prki(ix,levs+1)
                     prslk  (1:iMax,1:kMax)          , &!REAL(kind=r8), INTENT(IN   ) :: prkl(ix,levs)
                     imask  (1:iMax)                 , &!INTEGER(KIND=i8), INTENT(IN) :: imask  (ix)
                     ABS(tsea(1:iMax))               , &!REAL(KIND=r8),    INTENT(in) :: TSK    (ix)
                     prsl  (1:iMax,1:kMax)           , &!REAL(KIND=r8),    INTENT(in) :: prsl   (ix,levs)
                     phii  (1:iMax,1:kMax+1)         , &!===>  PHIH(K+1)  INPUT GEOPOTENTIAL @ EDGES  IN MKS units (m^2/s^2)
                     phil  (1:iMax,1:kMax  )         , &!===>  PHIL(K)	INPUT GEOPOTENTIAL @ LAYERS IN MKS units (m^2/s^2)
                     del   (1:iMax,1:kMax)            )

   DO i=1, iMax
         phii (i,kmax+1)  = phii(i,kmax+1)/grav  ! convert  (m^2/s^2) to m
   END DO
   DO  k=1, kmax
       DO i=1, iMax
         phii  (i,k)  = phii(i,k)/grav  ! convert  (m^2/s^2) to m
         phil  (i,k)  = phil(i,k)/grav  ! convert  (m^2/s^2) to m
      END DO
   END DO

    END SUBROUTINE Dynamics


  SUBROUTINE  TimeStep(ifday,kt,idate,idatec,tod,jdt,delt,lati,lonrad,imask,topog,&
    ! Atmospheric fields
                      prsi  ,&
                      prsl  ,&
                      phii  ,&
                      phil  ,&
                      gps   ,&
                      gtt   ,&
                      gqq   ,&
                      tsurf ,&
                      omg   ,&
                      ad_omg,&
                      ad_tmp,&
                      ad_grh,&
                      tsea  ,&
                      QCF   ,&
                      QCL   ,&
                      QCR   ,&
                      prcpt   ,&
                      ndtimesCld,&
    ! SURFACE:  albedo
                      AlbVisDiff  ,&
                      AlbNirDiff  ,&
                      AlbVisBeam  ,&
                      AlbNirBeam  ,&
    ! SW Radiation fields at last integer hour
                      rSwToaDown  ,&
                      rVisDiff    ,&
                      rNirDiff    ,&
                      rVisBeam    ,&
                      rNirBeam    ,&
                      rVisDiffC   ,&
                      rNirDiffC   ,&
                      rVisBeamC   ,&
                      rNirBeamC   ,&
                      rSwSfcNet   ,&
                      rSwSfcNetC  ,&
                      SwSfcUp     ,&
    ! SW Radiation fields at next integer hour
                      ySwToaDown  ,&
                      yVisDiff    ,&
                      yNirDiff    ,&
                      yVisBeam    ,&
                      yNirBeam    ,&
                      yVisDiffC   ,&
                      yNirDiffC   ,&
                      yVisBeamC   ,&
                      yNirBeamC   ,&
                      ySwHeatRate ,&
                      ySwHeatRateC,&
                      ySwSfcNet   ,&
                      ySwSfcNetC  ,&

    ! Radiation field (Interpolated) at time = tod
                      xVisDiff    ,&
                      xNirDiff    ,&
                      xVisBeam    ,&
                      xNirBeam    ,&
                      xVisDiffC   ,&
                      xNirDiffC   ,&
                      xVisBeamC   ,&
                      xNirBeamC   ,&

    ! LW Radiation fields at last integer hour
                      LwCoolRate  ,&
                      LwSfcDown   ,&
                      LwSfcNet    ,&
                      LwToaUp     ,&
                      LwCoolRateC ,&
                      LwSfcDownC  ,&
                      LwSfcNetC   ,&
                      LwToaUpC    ,&

    ! SSIB: Total radiation absorbed at ground
                      slrad       ,&

    ! SSIB INIT: Solar radiation with cos2
                     ssib_VisBeam ,&
                     ssib_VisDiff ,&
                     ssib_NirBeam ,&
                     ssib_NirDiff ,&

    ! Cloud field
                      cldsav     , &
                      CldCovTot  , &
                      CldCovInv  , &
                      CldCovSat  , &
                      CldCovCon  , &
                      CldCovSha  , &

    ! Microphysics
                      CldLiqWatPath  , &
                      emisd , &
                      taud  , &
                      EFFCS , &
                      EFFIS , &

    ! Chemistry
                      o3mix, &   
                      co2m , &!mol/mol
                      dump , & 
                      CLDF , &
!tar begin  
! climate aerosol optical parameters of coarse mode
!
                      aod    ,&
                      asy    ,&
                      ssa    ,&
                      z_aer  ,&
!        
!tar end 
!
!tar begin  
! climate aerosol optical parameters of fine mode
!
                      aodF    ,&
                      asyF    ,&
                      ssaF    ,&
                      z_aerF  ,&

                      ncols,kmax)
    USE Constants, ONLY : pai12
    USE Options  , ONLY : first,lcnvl,lthncl,nfin0,nfin1,nfcnv0,intcosz,&
                          yrl,swint,trint
    IMPLICIT NONE
    INTEGER, INTENT(IN   ):: nCols
    INTEGER, INTENT(IN   ):: kmax
    INTEGER, INTENT(IN   ):: ifday
    INTEGER, INTENT(IN   ):: kt
    INTEGER, INTENT(IN   ):: idate(4)! idate(4)....output : idate(1) = initial hour of day
    !                      idate(2) = month.(???)
    !                      idate(3) = day of  month of year.(???)
    !                      idate(4) = year.
    INTEGER, INTENT(IN   ):: idatec(4)! idatec(4)...output : idatec(1)= current hour of day
    !                      idatec(2)= current month of year. 
    !                      idatec(3)= current day of month.
    !                      idatec(4)= current year.
    REAL(KIND=r8), INTENT(IN   ):: tod!  tod......model forecast time of day in seconds
    INTEGER      , INTENT(IN   ):: jdt      ! jdt.........time step 
    REAL(KIND=r8), INTENT(IN   ):: delt    ! delt........time interval in sec (fixed throuh the integration)
    REAL(KIND=r8), INTENT(IN   ) :: lati(ncols)
    REAL(KIND=r8), INTENT(IN   ) :: lonrad(ncols)
    INTEGER(kind=i8), INTENT(IN   ):: imask(ncols)
    REAL(kind=r8)   , INTENT(INout):: topog(ncols)
    ! Atmospheric fields
    REAL(KIND=r8),    INTENT(in   ) :: prsi  (ncols,kMax+1)
    REAL(KIND=r8),    INTENT(in   ) :: prsl  (ncols,kMax)
    REAL(KIND=r8),    INTENT(in   ) :: phii  (nCols,kMax+1)
    REAL(KIND=r8),    INTENT(in   ) :: phil  (nCols,kMax)
    REAL(KIND=r8),    INTENT(in   ) :: gps   (ncols)
    REAL(KIND=r8),    INTENT(in   ) :: gtt   (ncols,kmax)
    REAL(KIND=r8),    INTENT(in   ) :: gqq   (ncols,kmax)
    REAL(KIND=r8),    INTENT(in   ) :: tsurf (ncols)
    REAL(KIND=r8),    INTENT(in   ) :: omg   (ncols,kmax)
    REAL(KIND=r8),    INTENT(inout) :: ad_omg(ncols,kmax,2)
    REAL(KIND=r8),    INTENT(inout) :: ad_tmp(ncols,kmax,2)
    REAL(KIND=r8),    INTENT(inout) :: ad_grh(ncols,kmax,2)
    REAL(KIND=r8),    INTENT(in   ) :: tsea  (ncols)
    REAL(KIND=r8),    INTENT(in   ) :: QCF   (ncols,kMax)
    REAL(KIND=r8),    INTENT(in   ) :: QCL   (ncols,kMax)
    REAL(KIND=r8),    INTENT(in   ) :: QCR   (ncols,kMax)
    REAL(KIND=r8),    INTENT(inout) :: prcpt(ncols)
    INTEGER      ,    INTENT(inout) :: ndtimesCld(ncols)

    ! SURFACE:  albedo
    REAL(KIND=r8),    INTENT(in   ) :: AlbVisDiff (ncols)
    REAL(KIND=r8),    INTENT(in   ) :: AlbNirDiff (ncols)
    REAL(KIND=r8),    INTENT(inout) :: AlbVisBeam (ncols)
    REAL(KIND=r8),    INTENT(inout) :: AlbNirBeam (ncols)
    ! SW Radiation fields at last integer hour
    REAL(KIND=r8),    INTENT(inout) :: rSwToaDown(ncols)
    REAL(KIND=r8),    INTENT(inout) :: rVisDiff (ncols)
    REAL(KIND=r8),    INTENT(inout) :: rNirDiff (ncols)
    REAL(KIND=r8),    INTENT(inout) :: rVisBeam (ncols)
    REAL(KIND=r8),    INTENT(inout) :: rNirBeam (ncols)
    REAL(KIND=r8),    INTENT(inout) :: rVisDiffC(ncols)
    REAL(KIND=r8),    INTENT(inout) :: rNirDiffC(ncols)
    REAL(KIND=r8),    INTENT(inout) :: rVisBeamC(ncols)
    REAL(KIND=r8),    INTENT(inout) :: rNirBeamC(ncols)
    REAL(KIND=r8),    INTENT(inout) :: rSwSfcNet   (ncols)
    REAL(KIND=r8),    INTENT(inout) :: rSwSfcNetC  (ncols)
    REAL(KIND=r8),    INTENT(inout) :: SwSfcUp (ncols)
    ! SW Radiation fields at next integer hour
    REAL(KIND=r8),    INTENT(inout) :: ySwToaDown(ncols)
    REAL(KIND=r8),    INTENT(inout) :: yVisDiff (ncols)
    REAL(KIND=r8),    INTENT(inout) :: yNirDiff (ncols)
    REAL(KIND=r8),    INTENT(inout) :: yVisBeam (ncols)
    REAL(KIND=r8),    INTENT(inout) :: yNirBeam (ncols)
    REAL(KIND=r8),    INTENT(inout) :: yVisDiffC(ncols)
    REAL(KIND=r8),    INTENT(inout) :: yNirDiffC(ncols)
    REAL(KIND=r8),    INTENT(inout) :: yVisBeamC(ncols)
    REAL(KIND=r8),    INTENT(inout) :: yNirBeamC(ncols)
    REAL(KIND=r8),    INTENT(inout) :: ySwHeatRate   (ncols,kmax)
    REAL(KIND=r8),    INTENT(inout) :: ySwHeatRateC  (ncols,kmax)
    REAL(KIND=r8),    INTENT(inout) :: ySwSfcNet   (ncols)
    REAL(KIND=r8),    INTENT(inout) :: ySwSfcNetC  (ncols)

    ! Radiation field (Interpolated) at time = tod
    REAL(KIND=r8),    INTENT(inout) :: xVisDiff (ncols)
    REAL(KIND=r8),    INTENT(inout) :: xNirDiff (ncols)
    REAL(KIND=r8),    INTENT(inout) :: xVisBeam (ncols)
    REAL(KIND=r8),    INTENT(inout) :: xNirBeam (ncols)
    REAL(KIND=r8),    INTENT(inout) :: xVisDiffC (ncols)
    REAL(KIND=r8),    INTENT(inout) :: xNirDiffC (ncols)
    REAL(KIND=r8),    INTENT(inout) :: xVisBeamC (ncols)
    REAL(KIND=r8),    INTENT(inout) :: xNirBeamC (ncols)

    ! LW Radiation fields at last integer hour
    REAL(KIND=r8),    INTENT(inout) :: LwCoolRate (ncols,kmax)
    REAL(KIND=r8),    INTENT(inout) :: LwSfcDown  (ncols)
    REAL(KIND=r8),    INTENT(inout) :: LwSfcNet   (ncols)
    REAL(KIND=r8),    INTENT(inout) :: LwToaUp    (ncols)
    REAL(KIND=r8),    INTENT(inout) :: LwCoolRateC(ncols,kmax)
    REAL(KIND=r8),    INTENT(inout) :: LwSfcDownC (ncols)
    REAL(KIND=r8),    INTENT(inout) :: LwSfcNetC  (ncols)
    REAL(KIND=r8),    INTENT(inout) :: LwToaUpC   (ncols)

    ! SSIB: Total radiation absorbed at ground
    REAL(KIND=r8)  :: slrad(ncols)

    ! SSIB INIT: Solar radiation with cos2
    REAL(KIND=r8)  :: ssib_VisBeam (ncols)
    REAL(KIND=r8)  :: ssib_VisDiff (ncols)
    REAL(KIND=r8)  :: ssib_NirBeam (ncols)
    REAL(KIND=r8)  :: ssib_NirDiff (ncols)

    ! Cloud field
    REAL(KIND=r8),    INTENT(inout) :: cldsav(ncols)
    REAL(KIND=r8),    INTENT(inout) :: CldCovTot(ncols,kmax)
    REAL(KIND=r8),    INTENT(inout) :: CldCovInv(ncols,kmax)
    REAL(KIND=r8),    INTENT(inout) :: CldCovSat(ncols,kmax)
    REAL(KIND=r8),    INTENT(inout) :: CldCovCon(ncols,kmax)
    REAL(KIND=r8),    INTENT(inout) :: CldCovSha(ncols,kmax)

    ! Microphysics
    REAL(KIND=r8),    INTENT(inout) :: CldLiqWatPath  (ncols,kmax)
    REAL(KIND=r8),    INTENT(inout) :: emisd (ncols,kmax)
    REAL(KIND=r8),    INTENT(inout) :: taud  (ncols,kmax)
    REAL(KIND=r8),    INTENT(inout) :: EFFCS (ncols,kmax)
    REAL(KIND=r8),    INTENT(inout) :: EFFIS (ncols,kmax)

    ! Chemistry
    REAL(KIND=r8),    INTENT(INOUT) :: o3mix(ncols,kMax)   
    REAL(KIND=r8),    INTENT(INOUT) :: co2m(ncols,kMax)   !mol/mol
    REAL(KIND=r8),    INTENT(INOUT) :: dump(ncols,kMax) 
    REAL(KIND=r8),    INTENT(INOUT) :: CLDF(ncols,kMax)
!tar begin  
! climate aerosol optical parameters of coarse mode
!
    REAL(KIND=r8),    INTENT(inout) :: aod(ncols,14)
    REAL(KIND=r8),    INTENT(inout) :: asy(ncols,14)    
    REAL(KIND=r8),    INTENT(inout) :: ssa(ncols,14)    
    REAL(KIND=r8),    INTENT(inout) :: z_aer(ncols,40)    
!        
!tar end 
!
!tar begin  
! climate aerosol optical parameters of fine mode
!
    REAL(KIND=r8),    INTENT(inout) :: aodF(ncols,14)
    REAL(KIND=r8),    INTENT(inout) :: asyF(ncols,14)    
    REAL(KIND=r8),    INTENT(inout) :: ssaF(ncols,14)    
    REAL(KIND=r8),    INTENT(inout) :: z_aerF(ncols,40)    


    !
    !   LOCAL 
    !
    REAL(KIND=r8) :: colrad(ncols)
    REAL(KIND=r8) :: cosz(ncols)
    REAL(KIND=r8) :: zenith1(ncols)
    REAL(KIND=r8) :: zenith2 (ncols)
    REAL(KIND=r8) :: zenith  (ncols)
    REAL(KIND=r8) :: cos2(ncols)

   ! CONVECTION: convective clouds

    REAL(KIND=r8) :: convcs(ncols)!....ncols convective cloud cover in 3 hr. avrage
    REAL(KIND=r8) :: convts(ncols)!....ncols convective cloud top  (sigma layer)
    REAL(KIND=r8) :: convbs(ncols)!....ncols convective cloud base (sigma layer)
    REAL(KIND=r8) :: convc (ncols)!....ncols convective cloud cover in 3 hr. avrage
    REAL(KIND=r8) :: convt (ncols)!....ncols convective cloud top  (sigma layer)
    REAL(KIND=r8) :: convb (ncols)!....ncols convective cloud base (sigma layer)

    REAL(KIND=r8) :: sdelt
    REAL(KIND=r8) :: delta
    REAL(KIND=r8) :: ratio
    REAL(KIND=r8) :: etime
    REAL(KIND=r8) :: xday
    REAL(KIND=r8) :: fimxi
    REAL(KIND=r8) :: ctime
    REAL(KIND=r8) :: btime 
    REAL(KIND=r8) :: atime 
    REAL(KIND=r8) :: sindel
    REAL(KIND=r8) :: cosdel
    REAL(KIND=r8) :: frh
    INTEGER      :: ncount,i
    INTEGER      :: latco=1
    REAL(KIND=r8)   , PARAMETER :: alon   =  0.0_r8
    REAL(KIND=r8)   , PARAMETER :: fp2457 = 0.2457_r8
    REAL(KIND=r8)   , PARAMETER :: fp1253 = 0.1253_r8
    REAL(KIND=r8)   , PARAMETER :: f8p0e3 = 8.0e3_r8  ! 1000 * 8
    REAL(KIND=r8)   , PARAMETER :: f0p8 = 0.8e0_r8!Critical Relative Humidity down level 400mb 
    convcs=0.0_r8
    convts=0.0_r8
    convbs=0.0_r8
    convc =0.0_r8
    convt =0.0_r8
    convb =0.0_r8
    sdelt=0.0_r8
    ratio=0.0_r8
    etime=0.0_r8
    xday=0.0_r8
    !
    !     mon is the month used for vegetation data input
    !
    DO i = 1, ncols 
       IF(prcpt(i) <0.00_r8)then
          prcpt(i) =0.0e0_r8
       END IF
    END DO

    IF(TRIM(iccon).EQ.'ARA')THEN
      DO i = 1, ncols 
         IF (prcpt(i) .GT. 0.0e0_r8) THEN
            convc(i) = fp2457 + fp1253 * LOG(prcpt(i) * f8p0e3)
            convc(i) = MAX(convc(i), 0.0e0_r8)
            convc(i) = MIN(convc(i), f0p8)
         END IF
      END DO
    ELSE
      DO i = 1, ncols 
         IF (prcpt(i) .GT. 0.0e0_r8) THEN
            convc(i) = fp2457 + fp1253 * LOG(prcpt(i) * f8p0e3)
            convc(i) = MAX(convc(i), 0.0e0_r8)
            convc(i) = MIN(convc(i), f0p8)
         END IF
      END DO
    END IF      !
      DO i = 1, ncols 
       colrad(i)=((lati(i)+90.0_r8)*3.1415926e0_r8)/180.0_r8

      !READ(1,rec=irec)aux
       convt(i)=kMax-nls   ! index top cloud convective  
      !READ(1,rec=irec)aux
       convb(i)=2          ! index botton cloud convective 
      END DO
    !     computation of astronomical parameters
    !     sdelt ;solar inclination
    !     etime ;correction factor to local time
    !     ratio ;factor relating to the distance between the earth and the sun
    !
    CALL radtim(idatec,sdelt ,ratio ,etime ,tod   ,xday  ,yrl)
    sindel = SIN(sdelt)
    cosdel = COS(sdelt)
    fimxi  = 24.0e0_r8 /360.0_r8
    ctime  = alon/15.0e0_r8
    cos2   = 0.0e0_r8
    ncount = 0
    frh    = ( MOD(tod+0.03125_r8,3600.0_r8)-0.03125_r8)/3600.0_r8

    DO i=1,ncols
       zenith1(i)  = sindel*COS(colrad(i))
    ENDDO

    DO i=1,ncols
       btime       = fimxi*lonrad(i)+ctime
       atime       = etime+pai12*(12.0_r8-idatec(1)-frh-btime)
       zenith2 (i) = cosdel*SIN(colrad(i))*COS(atime)
       zenith  (i) = zenith1(i) + zenith2(i)
    END DO
    !IF(intcosz)THEN
    !   !cos2=cos2/REAL(ncount,r8)!!!!mudanca forcada
    !   cos2(1:ncols)=cos2d(1:ncols)
    !ELSE
       cos2(1:ncols)=zenith(1:ncols)
    !END IF
    ncount = 0
    DO i=1,ncols
       IF(imask(i).GE.1_i8) THEN
          ncount=ncount+1
          cosz(ncount)=zenith(i)
       END IF
    END DO

    !
    !     radiation parameterization
    !
    CALL RadiationDriver (&
      ! Run Flags
      first , ifday , lcnvl , lthncl, nfin0 , nfin1 , nfcnv0,  &
      intcosz, kt   , mxrdcc,                                  &
      ! Time info
      yrl   , idatec , idate , tod   , jdt   , delt  ,         &
      trint , swint  ,                                         &
      ! Model Geometry
      colrad, lonrad, zenith, cos2   ,                         &
      ! Model information
      latco , ncols , kmax  , nls   , nlcs  , imask ,          &
      ! Atmospheric fields
      prsi ,prsl  ,phii ,phil    ,&
      gps   , gtt   , gqq   , tsurf , omg   , tsea  ,          &
      QCF   ,QCL    , QCR   ,ad_omg,ad_tmp,ad_grh  ,           &
      ndtimesCld,&
      ! CONVECTION: convective clouds
      convts, convcs, convbs, convc , convt , convb ,          &
      ! Surface Albedo
      AlbVisDiff , AlbNirDiff , AlbVisBeam , AlbNirBeam ,      &
      ! SW Radiation fields at last integer hour
      rSwToaDown,                                              &
      rVisDiff , rNirDiff , rVisBeam , rNirBeam ,              &
      rVisDiffC, rNirDiffC, rVisBeamC, rNirBeamC,              &
      rSwSfcNet , rSwSfcNetC,SwSfcUp ,                         &
      ! SW Radiation fields at next integer hour               
      ySwToaDown,                                              &
      yVisDiff , yNirDiff , yVisBeam , yNirBeam ,              &
      yVisDiffC, yNirDiffC, yVisBeamC, yNirBeamC,              &
      ySwHeatRate, ySwHeatRateC  ,                             &
      ySwSfcNet  , ySwSfcNetC ,                                &
      ! Radiation field (Interpolated) at time = tod           
      xVisDiff , xNirDiff , xVisBeam , xNirBeam ,              &
      xVisDiffC,xNirDiffC , xVisBeamC, xNirBeamC,              &
      ! LW Radiation fields at last integer hour               
      LwCoolRate   , LwSfcDown, LwSfcNet    , LwToaUp,         &
      LwCoolRateC  , LwSfcDownC, LwSfcNetC , LwToaUpC,         &
      ! SSIB: Total radiation absorbed at ground
      slrad ,                                                  &
      ! SSIB INIT: Solar radiation with cos2
      ssib_VisBeam,ssib_VisDiff, ssib_NirBeam, ssib_NirDiff,   &
      ! Cloud field
      cldsav, CldCovTot,                                       &
      CldCovInv, CldCovSat, CldCovCon, CldCovSha  ,            &
      ! Microphysics
      CldLiqWatPath  , emisd , taud  , EFFCS    ,EFFIS  ,      &
      ! Chemistry
      o3mix  ,co2m ,dump,CLDF,&
      !tar begin 
      !climate aerosol optical parameters of coarse mode    
      aod,asy,ssa,z_aer,topog, &
      !tar end
      !
      !tar begin 
      !climate aerosol optical parameters of fine mode    
      aodF,asyF,ssaF,z_aerF)
      !tar end
      !  
  END SUBROUTINE TimeStep

END PROGRAM MODELRAD
