!     path:      $Source: /storm/rc1/cvsroot/rc/rrtmg_lw/src/rrtmg_lw_k_g.f90,v $
!     author:    $Author: mike $
!     revision:  $Revision: 1.2 $
!     created:   $Date: 2007/08/22 19:20:03 $
!
!  --------------------------------------------------------------------------
! |                                                                          |
! |  Copyright 2002-2007, Atmospheric & Environmental Research, Inc. (AER).  |
! |  This software may be used, copied, or redistributed as long as it is    |
! |  not sold and this copyright notice is reproduced on each copy made.     |
! |  This model is provided as is without any express or implied warranties. |
! |                       (http://www.rtweb.aer.com/)                        |
! |                                                                          |
!  --------------------------------------------------------------------------

! **************************************************************************
!      subroutine lw_kgbnn
! **************************************************************************
!  RRTM Longwave Radiative Transfer Model
!  Atmospheric and Environmental Research, Inc., Cambridge, MA
!
!  Original version:   E. J. Mlawer, et al.
!  Revision for GCMs:  Michael J. Iacono; October, 2002
!
!  This file contains 16 subroutines that include the 
!  absorption coefficients and other data for each of the 16 longwave
!  spectral bands used in RRTM.  Here, the data are defined for 16
!  g-points, or sub-intervals, per band.  These data are combined and
!  weighted using a mapping procedure in routine RRTMG_LW_INIT to reduce
!  the total number of g-points from 256 to 140 for use in the GCM.
! **************************************************************************
! **************************************************************************
      subroutine lw_kgb02
! **************************************************************************

      use shr_kind_mod, only: r8 => shr_kind_r8

!      use parkind, only : jpim, jprb 
      use rrlw_kg02, only : fracrefao, fracrefbo, kao, kbo, selfrefo, forrefo

      implicit none
      save

! Planck fraction mapping level: P = 1053.630 mbar, T = 294.2 K
      fracrefao(:) = (/ &
        1.6388e-01_r8, 1.5241e-01_r8, 1.4290e-01_r8, 1.2864e-01_r8, &
        1.1615e-01_r8, 1.0047e-01_r8, 8.0013e-02_r8, 6.0445e-02_r8, &
        4.0530e-02_r8, 4.3879e-03_r8, 3.5726e-03_r8, 2.7669e-03_r8, &
        2.0078e-03_r8, 1.2864e-03_r8, 4.7630e-04_r8, 6.9109e-05_r8/)

! Planck fraction mapping level: P = 3.206e-2 mb, T = 197.92 K
      fracrefbo(:) = (/ &
        1.4697e-01_r8, 1.4826e-01_r8, 1.4278e-01_r8, 1.3320e-01_r8, &
        1.1965e-01_r8, 1.0297e-01_r8, 8.4170e-02_r8, 6.3282e-02_r8, &
        4.2868e-02_r8, 4.6644e-03_r8, 3.8619e-03_r8, 3.0533e-03_r8, &
        2.2359e-03_r8, 1.4226e-03_r8, 5.3642e-04_r8, 7.6316e-05_r8/)

!     The array KAO contains absorption coefs at the 16 chosen g-values 
!     for a range of pressure levels > ~100mb and temperatures.  The first
!     index in the array, JT, which runs from 1 to 5, corresponds to 
!     different temperatures.  More specifically, JT = 3 means that the 
!     data are for the corresponding TREF for this  pressure level, 
!     JT = 2 refers to the temperatureTREF-15, JT = 1 is for TREF-30, 
!     JT = 4 is for TREF+15, and JT = 5 is for TREF+30.  The second 
!     index, JP, runs from 1 to 13 and refers to the corresponding 
!     pressure level in PREF (e.g. JP = 1 is for a pressure of 1053.63 mb).  
!     The third index, IG, goes from 1 to 16, and tells us which 
!     g-interval the absorption coefficients are for.

      kao(:, 1, 1) = (/ &
     &4.9444e-03_r8,5.9459e-03_r8,7.0909e-03_r8,8.2082e-03_r8,9.2071e-03_r8/)
      kao(:, 2, 1) = (/ &
     &3.6253e-03_r8,4.3860e-03_r8,5.2541e-03_r8,6.0419e-03_r8,6.8835e-03_r8/)
      kao(:, 3, 1) = (/ &
     &2.5338e-03_r8,3.0985e-03_r8,3.7400e-03_r8,4.2996e-03_r8,4.9675e-03_r8/)
      kao(:, 4, 1) = (/ &
     &1.7755e-03_r8,2.1973e-03_r8,2.6664e-03_r8,3.1111e-03_r8,3.6091e-03_r8/)
      kao(:, 5, 1) = (/ &
     &1.2565e-03_r8,1.5789e-03_r8,1.9196e-03_r8,2.3096e-03_r8,2.6519e-03_r8/)
      kao(:, 6, 1) = (/ &
     &8.8624e-04_r8,1.1175e-03_r8,1.3818e-03_r8,1.6934e-03_r8,1.9635e-03_r8/)
      kao(:, 7, 1) = (/ &
     &6.2843e-04_r8,7.9253e-04_r8,1.0012e-03_r8,1.2222e-03_r8,1.4734e-03_r8/)
      kao(:, 8, 1) = (/ &
     &4.5023e-04_r8,5.6483e-04_r8,7.1568e-04_r8,8.9026e-04_r8,1.0929e-03_r8/)
      kao(:, 9, 1) = (/ &
     &3.2520e-04_r8,4.0407e-04_r8,5.1209e-04_r8,6.4949e-04_r8,7.9581e-04_r8/)
      kao(:,10, 1) = (/ &
     &2.4126e-04_r8,2.9581e-04_r8,3.7404e-04_r8,4.7585e-04_r8,5.9085e-04_r8/)
      kao(:,11, 1) = (/ &
     &1.9501e-04_r8,2.4152e-04_r8,3.0649e-04_r8,3.9104e-04_r8,4.8881e-04_r8/)
      kao(:,12, 1) = (/ &
     &1.5881e-04_r8,1.9763e-04_r8,2.5177e-04_r8,3.2441e-04_r8,4.0632e-04_r8/)
      kao(:,13, 1) = (/ &
     &1.3003e-04_r8,1.6216e-04_r8,2.0768e-04_r8,2.6864e-04_r8,3.3497e-04_r8/)
      kao(:, 1, 2) = (/ &
     &1.0027e-02_r8,1.1791e-02_r8,1.3932e-02_r8,1.6666e-02_r8,2.0126e-02_r8/)
      kao(:, 2, 2) = (/ &
     &7.4056e-03_r8,8.8285e-03_r8,1.0460e-02_r8,1.2669e-02_r8,1.5282e-02_r8/)
      kao(:, 3, 2) = (/ &
     &5.2661e-03_r8,6.2928e-03_r8,7.5540e-03_r8,9.2387e-03_r8,1.1182e-02_r8/)
      kao(:, 4, 2) = (/ &
     &3.7830e-03_r8,4.5144e-03_r8,5.4622e-03_r8,6.6869e-03_r8,8.1435e-03_r8/)
      kao(:, 5, 2) = (/ &
     &2.7480e-03_r8,3.3042e-03_r8,3.9726e-03_r8,4.8258e-03_r8,5.9510e-03_r8/)
      kao(:, 6, 2) = (/ &
     &2.0063e-03_r8,2.3984e-03_r8,2.8713e-03_r8,3.4864e-03_r8,4.3135e-03_r8/)
      kao(:, 7, 2) = (/ &
     &1.4846e-03_r8,1.7453e-03_r8,2.0981e-03_r8,2.5444e-03_r8,3.1056e-03_r8/)
      kao(:, 8, 2) = (/ &
     &1.1210e-03_r8,1.2879e-03_r8,1.5449e-03_r8,1.8524e-03_r8,2.2562e-03_r8/)
      kao(:, 9, 2) = (/ &
     &8.5574e-04_r8,9.6423e-04_r8,1.1336e-03_r8,1.3659e-03_r8,1.6594e-03_r8/)
      kao(:,10, 2) = (/ &
     &6.6848e-04_r8,7.4016e-04_r8,8.5479e-04_r8,1.0274e-03_r8,1.2343e-03_r8/)
      kao(:,11, 2) = (/ &
     &5.5022e-04_r8,6.0473e-04_r8,6.9963e-04_r8,8.4106e-04_r8,1.0097e-03_r8/)
      kao(:,12, 2) = (/ &
     &4.4972e-04_r8,4.9436e-04_r8,5.7239e-04_r8,6.8738e-04_r8,8.3038e-04_r8/)
      kao(:,13, 2) = (/ &
     &3.6745e-04_r8,4.0460e-04_r8,4.6828e-04_r8,5.6427e-04_r8,6.8387e-04_r8/)
      kao(:, 1, 3) = (/ &
     &2.0475e-02_r8,2.4886e-02_r8,2.8056e-02_r8,3.1687e-02_r8,3.6011e-02_r8/)
      kao(:, 2, 3) = (/ &
     &1.5293e-02_r8,1.8649e-02_r8,2.1197e-02_r8,2.4106e-02_r8,2.7485e-02_r8/)
      kao(:, 3, 3) = (/ &
     &1.0918e-02_r8,1.3480e-02_r8,1.5496e-02_r8,1.7769e-02_r8,2.0398e-02_r8/)
      kao(:, 4, 3) = (/ &
     &7.7395e-03_r8,9.6625e-03_r8,1.1379e-02_r8,1.3130e-02_r8,1.5170e-02_r8/)
      kao(:, 5, 3) = (/ &
     &5.4995e-03_r8,6.9063e-03_r8,8.5233e-03_r8,9.8125e-03_r8,1.1368e-02_r8/)
      kao(:, 6, 3) = (/ &
     &3.9002e-03_r8,4.9307e-03_r8,6.2037e-03_r8,7.3100e-03_r8,8.4689e-03_r8/)
      kao(:, 7, 3) = (/ &
     &2.7369e-03_r8,3.5078e-03_r8,4.4352e-03_r8,5.5098e-03_r8,6.3463e-03_r8/)
      kao(:, 8, 3) = (/ &
     &1.9294e-03_r8,2.5028e-03_r8,3.1751e-03_r8,4.0255e-03_r8,4.7593e-03_r8/)
      kao(:, 9, 3) = (/ &
     &1.2806e-03_r8,1.7659e-03_r8,2.2786e-03_r8,2.8933e-03_r8,3.6112e-03_r8/)
      kao(:,10, 3) = (/ &
     &8.6429e-04_r8,1.2871e-03_r8,1.6661e-03_r8,2.1207e-03_r8,2.6956e-03_r8/)
      kao(:,11, 3) = (/ &
     &7.0989e-04_r8,1.0555e-03_r8,1.3691e-03_r8,1.7450e-03_r8,2.2184e-03_r8/)
      kao(:,12, 3) = (/ &
     &5.8630e-04_r8,8.6615e-04_r8,1.1265e-03_r8,1.4357e-03_r8,1.8221e-03_r8/)
      kao(:,13, 3) = (/ &
     &4.8372e-04_r8,7.1031e-04_r8,9.2618e-04_r8,1.1787e-03_r8,1.4998e-03_r8/)
      kao(:, 1, 4) = (/ &
     &3.4150e-02_r8,4.0367e-02_r8,4.9280e-02_r8,5.9100e-02_r8,6.9499e-02_r8/)
      kao(:, 2, 4) = (/ &
     &2.5504e-02_r8,3.0447e-02_r8,3.7321e-02_r8,4.4944e-02_r8,5.3298e-02_r8/)
      kao(:, 3, 4) = (/ &
     &1.8371e-02_r8,2.2085e-02_r8,2.7226e-02_r8,3.2994e-02_r8,3.9403e-02_r8/)
      kao(:, 4, 4) = (/ &
     &1.3235e-02_r8,1.6046e-02_r8,1.9813e-02_r8,2.4156e-02_r8,2.9082e-02_r8/)
      kao(:, 5, 4) = (/ &
     &9.5998e-03_r8,1.1709e-02_r8,1.4338e-02_r8,1.7707e-02_r8,2.1505e-02_r8/)
      kao(:, 6, 4) = (/ &
     &6.9022e-03_r8,8.5630e-03_r8,1.0395e-02_r8,1.2869e-02_r8,1.5787e-02_r8/)
      kao(:, 7, 4) = (/ &
     &5.0622e-03_r8,6.1861e-03_r8,7.5642e-03_r8,9.2835e-03_r8,1.1530e-02_r8/)
      kao(:, 8, 4) = (/ &
     &3.7734e-03_r8,4.4956e-03_r8,5.5749e-03_r8,6.7721e-03_r8,8.4253e-03_r8/)
      kao(:, 9, 4) = (/ &
     &2.9619e-03_r8,3.3315e-03_r8,4.0621e-03_r8,4.9694e-03_r8,6.1117e-03_r8/)
      kao(:,10, 4) = (/ &
     &2.2204e-03_r8,2.5123e-03_r8,3.0176e-03_r8,3.7321e-03_r8,4.5545e-03_r8/)
      kao(:,11, 4) = (/ &
     &1.8288e-03_r8,2.0602e-03_r8,2.4838e-03_r8,3.0685e-03_r8,3.7508e-03_r8/)
      kao(:,12, 4) = (/ &
     &1.5051e-03_r8,1.6916e-03_r8,2.0466e-03_r8,2.5239e-03_r8,3.0905e-03_r8/)
      kao(:,13, 4) = (/ &
     &1.2373e-03_r8,1.3907e-03_r8,1.6848e-03_r8,2.0764e-03_r8,2.5455e-03_r8/)
      kao(:, 1, 5) = (/ &
     &7.4128e-02_r8,9.0328e-02_r8,1.0845e-01_r8,1.2842e-01_r8,1.4993e-01_r8/)
      kao(:, 2, 5) = (/ &
     &5.6421e-02_r8,6.8932e-02_r8,8.3294e-02_r8,9.9111e-02_r8,1.1617e-01_r8/)
      kao(:, 3, 5) = (/ &
     &4.0916e-02_r8,5.0385e-02_r8,6.1257e-02_r8,7.3474e-02_r8,8.6732e-02_r8/)
      kao(:, 4, 5) = (/ &
     &2.9430e-02_r8,3.6556e-02_r8,4.4742e-02_r8,5.4199e-02_r8,6.4580e-02_r8/)
      kao(:, 5, 5) = (/ &
     &2.1212e-02_r8,2.6602e-02_r8,3.2780e-02_r8,4.0084e-02_r8,4.8236e-02_r8/)
      kao(:, 6, 5) = (/ &
     &1.5151e-02_r8,1.9129e-02_r8,2.3897e-02_r8,2.9436e-02_r8,3.5798e-02_r8/)
      kao(:, 7, 5) = (/ &
     &1.0718e-02_r8,1.3802e-02_r8,1.7389e-02_r8,2.1505e-02_r8,2.6440e-02_r8/)
      kao(:, 8, 5) = (/ &
     &7.4917e-03_r8,9.9125e-03_r8,1.2578e-02_r8,1.5770e-02_r8,1.9483e-02_r8/)
      kao(:, 9, 5) = (/ &
     &5.1168e-03_r8,7.0368e-03_r8,9.1089e-03_r8,1.1527e-02_r8,1.4293e-02_r8/)
      kao(:,10, 5) = (/ &
     &3.6983e-03_r8,5.0627e-03_r8,6.6991e-03_r8,8.5275e-03_r8,1.0696e-02_r8/)
      kao(:,11, 5) = (/ &
     &3.0484e-03_r8,4.1916e-03_r8,5.5346e-03_r8,7.0513e-03_r8,8.8498e-03_r8/)
      kao(:,12, 5) = (/ &
     &2.5174e-03_r8,3.4714e-03_r8,4.5718e-03_r8,5.8341e-03_r8,7.3195e-03_r8/)
      kao(:,13, 5) = (/ &
     &2.0770e-03_r8,2.8684e-03_r8,3.7718e-03_r8,4.8192e-03_r8,6.0412e-03_r8/)
      kao(:, 1, 6) = (/ &
     &2.0613e-01_r8,2.5157e-01_r8,3.0178e-01_r8,3.5683e-01_r8,4.1542e-01_r8/)
      kao(:, 2, 6) = (/ &
     &1.5819e-01_r8,1.9432e-01_r8,2.3452e-01_r8,2.7858e-01_r8,3.2587e-01_r8/)
      kao(:, 3, 6) = (/ &
     &1.1531e-01_r8,1.4306e-01_r8,1.7435e-01_r8,2.0876e-01_r8,2.4632e-01_r8/)
      kao(:, 4, 6) = (/ &
     &8.3284e-02_r8,1.0444e-01_r8,1.2864e-01_r8,1.5560e-01_r8,1.8535e-01_r8/)
      kao(:, 5, 6) = (/ &
     &6.0166e-02_r8,7.6315e-02_r8,9.4937e-02_r8,1.1604e-01_r8,1.3958e-01_r8/)
      kao(:, 6, 6) = (/ &
     &4.3003e-02_r8,5.5230e-02_r8,6.9447e-02_r8,8.5781e-02_r8,1.0424e-01_r8/)
      kao(:, 7, 6) = (/ &
     &3.0490e-02_r8,3.9769e-02_r8,5.0618e-02_r8,6.3200e-02_r8,7.7597e-02_r8/)
      kao(:, 8, 6) = (/ &
     &2.1570e-02_r8,2.8573e-02_r8,3.6803e-02_r8,4.6437e-02_r8,5.7626e-02_r8/)
      kao(:, 9, 6) = (/ &
     &1.5155e-02_r8,2.0450e-02_r8,2.6673e-02_r8,3.4004e-02_r8,4.2620e-02_r8/)
      kao(:,10, 6) = (/ &
     &1.0852e-02_r8,1.4893e-02_r8,1.9668e-02_r8,2.5324e-02_r8,3.1992e-02_r8/)
      kao(:,11, 6) = (/ &
     &9.0511e-03_r8,1.2422e-02_r8,1.6374e-02_r8,2.1084e-02_r8,2.6643e-02_r8/)
      kao(:,12, 6) = (/ &
     &7.5332e-03_r8,1.0338e-02_r8,1.3623e-02_r8,1.7531e-02_r8,2.2174e-02_r8/)
      kao(:,13, 6) = (/ &
     &6.2568e-03_r8,8.5754e-03_r8,1.1313e-02_r8,1.4562e-02_r8,1.8439e-02_r8/)
      kao(:, 1, 7) = (/ &
     &6.4924e-01_r8,7.7307e-01_r8,9.0386e-01_r8,1.0388e+00_r8,1.1773e+00_r8/)
      kao(:, 2, 7) = (/ &
     &5.0577e-01_r8,6.0786e-01_r8,7.1639e-01_r8,8.2855e-01_r8,9.4493e-01_r8/)
      kao(:, 3, 7) = (/ &
     &3.7384e-01_r8,4.5638e-01_r8,5.4361e-01_r8,6.3563e-01_r8,7.3108e-01_r8/)
      kao(:, 4, 7) = (/ &
     &2.7157e-01_r8,3.3769e-01_r8,4.0798e-01_r8,4.8298e-01_r8,5.6158e-01_r8/)
      kao(:, 5, 7) = (/ &
     &1.9648e-01_r8,2.4838e-01_r8,3.0521e-01_r8,3.6590e-01_r8,4.3005e-01_r8/)
      kao(:, 6, 7) = (/ &
     &1.3966e-01_r8,1.7987e-01_r8,2.2524e-01_r8,2.7405e-01_r8,3.2593e-01_r8/)
      kao(:, 7, 7) = (/ &
     &9.8353e-02_r8,1.2917e-01_r8,1.6445e-01_r8,2.0365e-01_r8,2.4531e-01_r8/)
      kao(:, 8, 7) = (/ &
     &6.8795e-02_r8,9.2244e-02_r8,1.1951e-01_r8,1.5053e-01_r8,1.8392e-01_r8/)
      kao(:, 9, 7) = (/ &
     &4.7720e-02_r8,6.5374e-02_r8,8.6294e-02_r8,1.1044e-01_r8,1.3721e-01_r8/)
      kao(:,10, 7) = (/ &
     &3.3881e-02_r8,4.7211e-02_r8,6.3377e-02_r8,8.2294e-02_r8,1.0374e-01_r8/)
      kao(:,11, 7) = (/ &
     &2.8304e-02_r8,3.9386e-02_r8,5.2911e-02_r8,6.8671e-02_r8,8.6477e-02_r8/)
      kao(:,12, 7) = (/ &
     &2.3643e-02_r8,3.2849e-02_r8,4.4121e-02_r8,5.7246e-02_r8,7.2052e-02_r8/)
      kao(:,13, 7) = (/ &
     &1.9678e-02_r8,2.7339e-02_r8,3.6693e-02_r8,4.7583e-02_r8,5.9838e-02_r8/)
      kao(:, 1, 8) = (/ &
     &1.5852e+00_r8,1.8937e+00_r8,2.2233e+00_r8,2.5759e+00_r8,2.9447e+00_r8/)
      kao(:, 2, 8) = (/ &
     &1.3020e+00_r8,1.5608e+00_r8,1.8408e+00_r8,2.1415e+00_r8,2.4614e+00_r8/)
      kao(:, 3, 8) = (/ &
     &1.0126e+00_r8,1.2239e+00_r8,1.4553e+00_r8,1.7040e+00_r8,1.9702e+00_r8/)
      kao(:, 4, 8) = (/ &
     &7.6856e-01_r8,9.4025e-01_r8,1.1316e+00_r8,1.3386e+00_r8,1.5605e+00_r8/)
      kao(:, 5, 8) = (/ &
     &5.7616e-01_r8,7.1359e-01_r8,8.6832e-01_r8,1.0388e+00_r8,1.2228e+00_r8/)
      kao(:, 6, 8) = (/ &
     &4.2350e-01_r8,5.3268e-01_r8,6.5605e-01_r8,7.9334e-01_r8,9.4223e-01_r8/)
      kao(:, 7, 8) = (/ &
     &3.0686e-01_r8,3.9225e-01_r8,4.9010e-01_r8,5.9944e-01_r8,7.1967e-01_r8/)
      kao(:, 8, 8) = (/ &
     &2.2070e-01_r8,2.8688e-01_r8,3.6348e-01_r8,4.5007e-01_r8,5.4597e-01_r8/)
      kao(:, 9, 8) = (/ &
     &1.5750e-01_r8,2.0832e-01_r8,2.6774e-01_r8,3.3584e-01_r8,4.1169e-01_r8/)
      kao(:,10, 8) = (/ &
     &1.1458e-01_r8,1.5398e-01_r8,2.0047e-01_r8,2.5420e-01_r8,3.1452e-01_r8/)
      kao(:,11, 8) = (/ &
     &9.6352e-02_r8,1.2945e-01_r8,1.6850e-01_r8,2.1343e-01_r8,2.6418e-01_r8/)
      kao(:,12, 8) = (/ &
     &8.0859e-02_r8,1.0869e-01_r8,1.4142e-01_r8,1.7905e-01_r8,2.2159e-01_r8/)
      kao(:,13, 8) = (/ &
     &6.7685e-02_r8,9.1028e-02_r8,1.1838e-01_r8,1.4990e-01_r8,1.8559e-01_r8/)
      kao(:, 1, 9) = (/ &
     &5.2550e+00_r8,6.3269e+00_r8,7.5188e+00_r8,8.8046e+00_r8,1.0194e+01_r8/)
      kao(:, 2, 9) = (/ &
     &4.6603e+00_r8,5.6500e+00_r8,6.7441e+00_r8,7.9369e+00_r8,9.2112e+00_r8/)
      kao(:, 3, 9) = (/ &
     &3.9124e+00_r8,4.7902e+00_r8,5.7591e+00_r8,6.8243e+00_r8,7.9677e+00_r8/)
      kao(:, 4, 9) = (/ &
     &3.2096e+00_r8,3.9597e+00_r8,4.8029e+00_r8,5.7377e+00_r8,6.7626e+00_r8/)
      kao(:, 5, 9) = (/ &
     &2.5970e+00_r8,3.2435e+00_r8,3.9726e+00_r8,4.7826e+00_r8,5.6814e+00_r8/)
      kao(:, 6, 9) = (/ &
     &2.0409e+00_r8,2.5854e+00_r8,3.2065e+00_r8,3.9078e+00_r8,4.6887e+00_r8/)
      kao(:, 7, 9) = (/ &
     &1.5708e+00_r8,2.0187e+00_r8,2.5381e+00_r8,3.1327e+00_r8,3.8016e+00_r8/)
      kao(:, 8, 9) = (/ &
     &1.1892e+00_r8,1.5546e+00_r8,1.9836e+00_r8,2.4782e+00_r8,3.0361e+00_r8/)
      kao(:, 9, 9) = (/ &
     &8.8412e-01_r8,1.1765e+00_r8,1.5263e+00_r8,1.9325e+00_r8,2.3921e+00_r8/)
      kao(:,10, 9) = (/ &
     &6.6160e-01_r8,8.9598e-01_r8,1.1789e+00_r8,1.5110e+00_r8,1.8897e+00_r8/)
      kao(:,11, 9) = (/ &
     &5.6952e-01_r8,7.7339e-01_r8,1.0185e+00_r8,1.3041e+00_r8,1.6292e+00_r8/)
      kao(:,12, 9) = (/ &
     &4.8820e-01_r8,6.6319e-01_r8,8.7290e-01_r8,1.1167e+00_r8,1.3956e+00_r8/)
      kao(:,13, 9) = (/ &
     &4.1555e-01_r8,5.6459e-01_r8,7.4208e-01_r8,9.4959e-01_r8,1.1894e+00_r8/)
      kao(:, 1,10) = (/ &
     &1.2977e+01_r8,1.5399e+01_r8,1.8084e+01_r8,2.1107e+01_r8,2.4279e+01_r8/)
      kao(:, 2,10) = (/ &
     &1.2242e+01_r8,1.4713e+01_r8,1.7530e+01_r8,2.0660e+01_r8,2.4161e+01_r8/)
      kao(:, 3,10) = (/ &
     &1.0793e+01_r8,1.3120e+01_r8,1.5954e+01_r8,1.9118e+01_r8,2.2561e+01_r8/)
      kao(:, 4,10) = (/ &
     &9.2115e+00_r8,1.1467e+01_r8,1.4090e+01_r8,1.6870e+01_r8,1.9865e+01_r8/)
      kao(:, 5,10) = (/ &
     &7.7076e+00_r8,9.6964e+00_r8,1.2018e+01_r8,1.4581e+01_r8,1.7283e+01_r8/)
      kao(:, 6,10) = (/ &
     &6.3938e+00_r8,8.1632e+00_r8,1.0170e+01_r8,1.2328e+01_r8,1.4702e+01_r8/)
      kao(:, 7,10) = (/ &
     &5.2643e+00_r8,6.8431e+00_r8,8.5879e+00_r8,1.0497e+01_r8,1.2599e+01_r8/)
      kao(:, 8,10) = (/ &
     &4.2306e+00_r8,5.5592e+00_r8,7.0542e+00_r8,8.7515e+00_r8,1.0687e+01_r8/)
      kao(:, 9,10) = (/ &
     &3.3029e+00_r8,4.4196e+00_r8,5.6740e+00_r8,7.1182e+00_r8,8.8343e+00_r8/)
      kao(:,10,10) = (/ &
     &2.6002e+00_r8,3.5171e+00_r8,4.6049e+00_r8,5.8654e+00_r8,7.3550e+00_r8/)
      kao(:,11,10) = (/ &
     &2.3411e+00_r8,3.1582e+00_r8,4.1576e+00_r8,5.3440e+00_r8,6.7154e+00_r8/)
      kao(:,12,10) = (/ &
     &2.0671e+00_r8,2.8097e+00_r8,3.7158e+00_r8,4.7938e+00_r8,5.9967e+00_r8/)
      kao(:,13,10) = (/ &
     &1.8130e+00_r8,2.4724e+00_r8,3.2908e+00_r8,4.2191e+00_r8,5.2351e+00_r8/)
      kao(:, 1,11) = (/ &
     &1.7369e+01_r8,2.0982e+01_r8,2.4652e+01_r8,2.8692e+01_r8,3.3179e+01_r8/)
      kao(:, 2,11) = (/ &
     &1.6823e+01_r8,2.0457e+01_r8,2.4236e+01_r8,2.8171e+01_r8,3.2333e+01_r8/)
      kao(:, 3,11) = (/ &
     &1.5375e+01_r8,1.8905e+01_r8,2.2457e+01_r8,2.6420e+01_r8,3.0766e+01_r8/)
      kao(:, 4,11) = (/ &
     &1.3375e+01_r8,1.6618e+01_r8,2.0128e+01_r8,2.4207e+01_r8,2.8664e+01_r8/)
      kao(:, 5,11) = (/ &
     &1.1552e+01_r8,1.4477e+01_r8,1.7747e+01_r8,2.1616e+01_r8,2.5966e+01_r8/)
      kao(:, 6,11) = (/ &
     &9.7662e+00_r8,1.2339e+01_r8,1.5425e+01_r8,1.9082e+01_r8,2.3024e+01_r8/)
      kao(:, 7,11) = (/ &
     &8.0435e+00_r8,1.0356e+01_r8,1.3162e+01_r8,1.6422e+01_r8,1.9976e+01_r8/)
      kao(:, 8,11) = (/ &
     &6.6475e+00_r8,8.6800e+00_r8,1.1208e+01_r8,1.4127e+01_r8,1.7194e+01_r8/)
      kao(:, 9,11) = (/ &
     &5.4286e+00_r8,7.1938e+00_r8,9.4274e+00_r8,1.1995e+01_r8,1.4788e+01_r8/)
      kao(:,10,11) = (/ &
     &4.4519e+00_r8,5.9777e+00_r8,7.8591e+00_r8,1.0067e+01_r8,1.2572e+01_r8/)
      kao(:,11,11) = (/ &
     &4.1097e+00_r8,5.5519e+00_r8,7.2615e+00_r8,9.2610e+00_r8,1.1615e+01_r8/)
      kao(:,12,11) = (/ &
     &3.7565e+00_r8,5.0648e+00_r8,6.6341e+00_r8,8.4916e+00_r8,1.0710e+01_r8/)
      kao(:,13,11) = (/ &
     &3.3842e+00_r8,4.5598e+00_r8,5.9909e+00_r8,7.7387e+00_r8,9.7720e+00_r8/)
      kao(:, 1,12) = (/ &
     &2.2275e+01_r8,2.7471e+01_r8,3.3492e+01_r8,4.0225e+01_r8,4.7465e+01_r8/)
      kao(:, 2,12) = (/ &
     &2.2476e+01_r8,2.7446e+01_r8,3.3072e+01_r8,3.9336e+01_r8,4.6205e+01_r8/)
      kao(:, 3,12) = (/ &
     &2.1150e+01_r8,2.6276e+01_r8,3.1885e+01_r8,3.7595e+01_r8,4.3863e+01_r8/)
      kao(:, 4,12) = (/ &
     &1.9455e+01_r8,2.4367e+01_r8,2.9875e+01_r8,3.5713e+01_r8,4.1802e+01_r8/)
      kao(:, 5,12) = (/ &
     &1.7406e+01_r8,2.2244e+01_r8,2.7648e+01_r8,3.3299e+01_r8,3.9489e+01_r8/)
      kao(:, 6,12) = (/ &
     &1.5271e+01_r8,1.9641e+01_r8,2.4614e+01_r8,3.0133e+01_r8,3.6348e+01_r8/)
      kao(:, 7,12) = (/ &
     &1.3343e+01_r8,1.7102e+01_r8,2.1495e+01_r8,2.6582e+01_r8,3.2562e+01_r8/)
      kao(:, 8,12) = (/ &
     &1.1399e+01_r8,1.4767e+01_r8,1.8657e+01_r8,2.3239e+01_r8,2.8870e+01_r8/)
      kao(:, 9,12) = (/ &
     &9.4462e+00_r8,1.2437e+01_r8,1.5942e+01_r8,2.0083e+01_r8,2.5175e+01_r8/)
      kao(:,10,12) = (/ &
     &7.9561e+00_r8,1.0576e+01_r8,1.3751e+01_r8,1.7625e+01_r8,2.2224e+01_r8/)
      kao(:,11,12) = (/ &
     &7.6703e+00_r8,1.0214e+01_r8,1.3362e+01_r8,1.7172e+01_r8,2.1565e+01_r8/)
      kao(:,12,12) = (/ &
     &7.3002e+00_r8,9.7613e+00_r8,1.2808e+01_r8,1.6448e+01_r8,2.0508e+01_r8/)
      kao(:,13,12) = (/ &
     &6.8227e+00_r8,9.1662e+00_r8,1.2005e+01_r8,1.5291e+01_r8,1.9104e+01_r8/)
      kao(:, 1,13) = (/ &
     &2.8154e+01_r8,3.5750e+01_r8,4.4791e+01_r8,5.4873e+01_r8,6.6140e+01_r8/)
      kao(:, 2,13) = (/ &
     &2.8745e+01_r8,3.6229e+01_r8,4.5340e+01_r8,5.5950e+01_r8,6.7860e+01_r8/)
      kao(:, 3,13) = (/ &
     &2.8731e+01_r8,3.5740e+01_r8,4.4190e+01_r8,5.4581e+01_r8,6.6390e+01_r8/)
      kao(:, 4,13) = (/ &
     &2.7586e+01_r8,3.5028e+01_r8,4.3053e+01_r8,5.2513e+01_r8,6.3590e+01_r8/)
      kao(:, 5,13) = (/ &
     &2.6083e+01_r8,3.3437e+01_r8,4.1632e+01_r8,5.0781e+01_r8,6.1113e+01_r8/)
      kao(:, 6,13) = (/ &
     &2.3829e+01_r8,3.1109e+01_r8,3.9228e+01_r8,4.8371e+01_r8,5.8278e+01_r8/)
      kao(:, 7,13) = (/ &
     &2.1209e+01_r8,2.8372e+01_r8,3.6376e+01_r8,4.5363e+01_r8,5.5372e+01_r8/)
      kao(:, 8,13) = (/ &
     &1.8790e+01_r8,2.5354e+01_r8,3.3043e+01_r8,4.1793e+01_r8,5.1443e+01_r8/)
      kao(:, 9,13) = (/ &
     &1.6798e+01_r8,2.2642e+01_r8,2.9578e+01_r8,3.7822e+01_r8,4.7058e+01_r8/)
      kao(:,10,13) = (/ &
     &1.4972e+01_r8,2.0558e+01_r8,2.6854e+01_r8,3.4253e+01_r8,4.2864e+01_r8/)
      kao(:,11,13) = (/ &
     &1.5310e+01_r8,2.0781e+01_r8,2.6920e+01_r8,3.4183e+01_r8,4.2625e+01_r8/)
      kao(:,12,13) = (/ &
     &1.5266e+01_r8,2.0520e+01_r8,2.6628e+01_r8,3.3712e+01_r8,4.2182e+01_r8/)
      kao(:,13,13) = (/ &
     &1.4957e+01_r8,1.9939e+01_r8,2.5957e+01_r8,3.3111e+01_r8,4.1486e+01_r8/)
      kao(:, 1,14) = (/ &
     &4.6330e+01_r8,6.0030e+01_r8,7.5480e+01_r8,9.2536e+01_r8,1.1059e+02_r8/)
      kao(:, 2,14) = (/ &
     &4.4855e+01_r8,5.8960e+01_r8,7.5059e+01_r8,9.2958e+01_r8,1.1209e+02_r8/)
      kao(:, 3,14) = (/ &
     &4.1447e+01_r8,5.4787e+01_r8,7.1113e+01_r8,8.9291e+01_r8,1.0911e+02_r8/)
      kao(:, 4,14) = (/ &
     &3.9104e+01_r8,5.0668e+01_r8,6.5934e+01_r8,8.3732e+01_r8,1.0396e+02_r8/)
      kao(:, 5,14) = (/ &
     &3.8023e+01_r8,4.8275e+01_r8,6.1835e+01_r8,7.8920e+01_r8,9.8684e+01_r8/)
      kao(:, 6,14) = (/ &
     &3.6671e+01_r8,4.6928e+01_r8,5.9373e+01_r8,7.4910e+01_r8,9.4120e+01_r8/)
      kao(:, 7,14) = (/ &
     &3.4713e+01_r8,4.5254e+01_r8,5.8164e+01_r8,7.3270e+01_r8,9.1067e+01_r8/)
      kao(:, 8,14) = (/ &
     &3.2317e+01_r8,4.2931e+01_r8,5.6350e+01_r8,7.1845e+01_r8,8.9533e+01_r8/)
      kao(:, 9,14) = (/ &
     &2.9466e+01_r8,3.9947e+01_r8,5.3450e+01_r8,6.9454e+01_r8,8.7436e+01_r8/)
      kao(:,10,14) = (/ &
     &2.7304e+01_r8,3.7491e+01_r8,5.1151e+01_r8,6.7458e+01_r8,8.6217e+01_r8/)
      kao(:,11,14) = (/ &
     &2.9371e+01_r8,4.0579e+01_r8,5.5614e+01_r8,7.3135e+01_r8,9.3406e+01_r8/)
      kao(:,12,14) = (/ &
     &3.1557e+01_r8,4.3832e+01_r8,5.9668e+01_r8,7.8288e+01_r8,9.9282e+01_r8/)
      kao(:,13,14) = (/ &
     &3.3702e+01_r8,4.7002e+01_r8,6.3302e+01_r8,8.2327e+01_r8,1.0363e+02_r8/)
      kao(:, 1,15) = (/ &
     &7.1097e+01_r8,9.1809e+01_r8,1.1513e+02_r8,1.4077e+02_r8,1.6931e+02_r8/)
      kao(:, 2,15) = (/ &
     &7.6481e+01_r8,9.9988e+01_r8,1.2655e+02_r8,1.5641e+02_r8,1.9001e+02_r8/)
      kao(:, 3,15) = (/ &
     &7.6089e+01_r8,1.0186e+02_r8,1.3121e+02_r8,1.6509e+02_r8,2.0316e+02_r8/)
      kao(:, 4,15) = (/ &
     &7.1689e+01_r8,9.8693e+01_r8,1.3061e+02_r8,1.6745e+02_r8,2.0924e+02_r8/)
      kao(:, 5,15) = (/ &
     &6.5396e+01_r8,9.2850e+01_r8,1.2644e+02_r8,1.6569e+02_r8,2.1030e+02_r8/)
      kao(:, 6,15) = (/ &
     &5.9839e+01_r8,8.4120e+01_r8,1.1791e+02_r8,1.5835e+02_r8,2.0497e+02_r8/)
      kao(:, 7,15) = (/ &
     &5.7504e+01_r8,7.7966e+01_r8,1.0776e+02_r8,1.4729e+02_r8,1.9476e+02_r8/)
      kao(:, 8,15) = (/ &
     &5.7004e+01_r8,7.5268e+01_r8,1.0086e+02_r8,1.3678e+02_r8,1.8339e+02_r8/)
      kao(:, 9,15) = (/ &
     &5.5577e+01_r8,7.3906e+01_r8,9.7044e+01_r8,1.2904e+02_r8,1.7226e+02_r8/)
      kao(:,10,15) = (/ &
     &5.5416e+01_r8,7.4211e+01_r8,9.6440e+01_r8,1.2687e+02_r8,1.6750e+02_r8/)
      kao(:,11,15) = (/ &
     &6.2860e+01_r8,8.4332e+01_r8,1.0913e+02_r8,1.4265e+02_r8,1.8694e+02_r8/)
      kao(:,12,15) = (/ &
     &7.1048e+01_r8,9.5286e+01_r8,1.2362e+02_r8,1.6046e+02_r8,2.0975e+02_r8/)
      kao(:,13,15) = (/ &
     &7.9451e+01_r8,1.0631e+02_r8,1.3951e+02_r8,1.8076e+02_r8,2.3534e+02_r8/)
      kao(:, 1,16) = (/ &
     &7.6064e+01_r8,1.0164e+02_r8,1.3126e+02_r8,1.6469e+02_r8,2.0152e+02_r8/)
      kao(:, 2,16) = (/ &
     &8.3803e+01_r8,1.1323e+02_r8,1.4816e+02_r8,1.8796e+02_r8,2.3219e+02_r8/)
      kao(:, 3,16) = (/ &
     &8.7402e+01_r8,1.1813e+02_r8,1.5778e+02_r8,2.0377e+02_r8,2.5553e+02_r8/)
      kao(:, 4,16) = (/ &
     &8.7865e+01_r8,1.1968e+02_r8,1.6142e+02_r8,2.1263e+02_r8,2.7144e+02_r8/)
      kao(:, 5,16) = (/ &
     &8.6499e+01_r8,1.2062e+02_r8,1.6367e+02_r8,2.1790e+02_r8,2.8301e+02_r8/)
      kao(:, 6,16) = (/ &
     &8.2494e+01_r8,1.1893e+02_r8,1.6400e+02_r8,2.2086e+02_r8,2.8964e+02_r8/)
      kao(:, 7,16) = (/ &
     &7.7078e+01_r8,1.1526e+02_r8,1.6302e+02_r8,2.2306e+02_r8,2.9645e+02_r8/)
      kao(:, 8,16) = (/ &
     &7.0841e+01_r8,1.1011e+02_r8,1.6059e+02_r8,2.2458e+02_r8,3.0342e+02_r8/)
      kao(:, 9,16) = (/ &
     &7.4013e+01_r8,1.0313e+02_r8,1.5566e+02_r8,2.2324e+02_r8,3.0785e+02_r8/)
      kao(:,10,16) = (/ &
     &8.3043e+01_r8,1.0119e+02_r8,1.5304e+02_r8,2.2535e+02_r8,3.1705e+02_r8/)
      kao(:,11,16) = (/ &
     &1.0007e+02_r8,1.2237e+02_r8,1.8107e+02_r8,2.6762e+02_r8,3.7672e+02_r8/)
      kao(:,12,16) = (/ &
     &1.1998e+02_r8,1.4801e+02_r8,2.1370e+02_r8,3.1623e+02_r8,4.4496e+02_r8/)
      kao(:,13,16) = (/ &
     &1.4282e+02_r8,1.7830e+02_r8,2.5018e+02_r8,3.7037e+02_r8,5.2070e+02_r8/)

!     The array KBO contains absorption coefs at the 16 chosen g-values 
!     for a range of pressure levels < ~100mb and temperatures. The first 
!     index in the array, JT, which runs from 1 to 5, corresponds to 
!     different temperatures.  More specifically, JT = 3 means that the 
!     data are for the reference temperature TREF for this pressure 
!     level, JT = 2 refers to the temperature TREF-15, JT = 1 is for
!     TREF-30, JT = 4 is for TREF+15, and JT = 5 is for TREF+30.  
!     The second index, JP, runs from 13 to 59 and refers to the JPth
!     reference pressure level (see taumol.f for the value of these
!     pressure levels in mb).  The third index, IG, goes from 1 to 16,
!     and tells us which g-interval the absorption coefficients are for.

      kbo(:,13, 1) = (/ &
     &1.3000e-04_r8,1.6216e-04_r8,2.0768e-04_r8,2.6864e-04_r8,3.3497e-04_r8/)
      kbo(:,14, 1) = (/ &
     &1.0850e-04_r8,1.3602e-04_r8,1.7553e-04_r8,2.2686e-04_r8,2.8162e-04_r8/)
      kbo(:,15, 1) = (/ &
     &9.0864e-05_r8,1.1476e-04_r8,1.4832e-04_r8,1.9081e-04_r8,2.3698e-04_r8/)
      kbo(:,16, 1) = (/ &
     &7.6202e-05_r8,9.6897e-05_r8,1.2521e-04_r8,1.6032e-04_r8,1.9925e-04_r8/)
      kbo(:,17, 1) = (/ &
     &6.3984e-05_r8,8.1671e-05_r8,1.0565e-04_r8,1.3448e-04_r8,1.6696e-04_r8/)
      kbo(:,18, 1) = (/ &
     &5.3749e-05_r8,6.8759e-05_r8,8.9036e-05_r8,1.1274e-04_r8,1.3824e-04_r8/)
      kbo(:,19, 1) = (/ &
     &4.5160e-05_r8,5.7874e-05_r8,7.4954e-05_r8,9.4487e-05_r8,1.1485e-04_r8/)
      kbo(:,20, 1) = (/ &
     &3.8050e-05_r8,4.8934e-05_r8,6.3376e-05_r8,7.9393e-05_r8,9.5565e-05_r8/)
      kbo(:,21, 1) = (/ &
     &3.2121e-05_r8,4.1368e-05_r8,5.3585e-05_r8,6.6749e-05_r8,7.9704e-05_r8/)
      kbo(:,22, 1) = (/ &
     &2.7597e-05_r8,3.5606e-05_r8,4.6066e-05_r8,5.6919e-05_r8,6.7252e-05_r8/)
      kbo(:,23, 1) = (/ &
     &2.3703e-05_r8,3.0672e-05_r8,3.9251e-05_r8,4.8622e-05_r8,5.6783e-05_r8/)
      kbo(:,24, 1) = (/ &
     &2.0444e-05_r8,2.6471e-05_r8,3.3535e-05_r8,4.1441e-05_r8,4.8070e-05_r8/)
      kbo(:,25, 1) = (/ &
     &1.7691e-05_r8,2.2899e-05_r8,2.8737e-05_r8,3.4776e-05_r8,4.0820e-05_r8/)
      kbo(:,26, 1) = (/ &
     &1.5391e-05_r8,1.9900e-05_r8,2.4708e-05_r8,2.9438e-05_r8,3.4884e-05_r8/)
      kbo(:,27, 1) = (/ &
     &1.3401e-05_r8,1.7231e-05_r8,2.1300e-05_r8,2.5041e-05_r8,2.9843e-05_r8/)
      kbo(:,28, 1) = (/ &
     &1.1671e-05_r8,1.4827e-05_r8,1.8383e-05_r8,2.1307e-05_r8,2.5549e-05_r8/)
      kbo(:,29, 1) = (/ &
     &1.0183e-05_r8,1.2798e-05_r8,1.5535e-05_r8,1.8197e-05_r8,2.1838e-05_r8/)
      kbo(:,30, 1) = (/ &
     &8.8844e-06_r8,1.1043e-05_r8,1.3172e-05_r8,1.5593e-05_r8,1.8678e-05_r8/)
      kbo(:,31, 1) = (/ &
     &7.7313e-06_r8,9.5518e-06_r8,1.1237e-05_r8,1.3382e-05_r8,1.5999e-05_r8/)
      kbo(:,32, 1) = (/ &
     &6.6794e-06_r8,8.2781e-06_r8,9.5924e-06_r8,1.1496e-05_r8,1.3717e-05_r8/)
      kbo(:,33, 1) = (/ &
     &5.7815e-06_r8,7.0042e-06_r8,8.2098e-06_r8,9.8489e-06_r8,1.1766e-05_r8/)
      kbo(:,34, 1) = (/ &
     &4.9641e-06_r8,5.9235e-06_r8,7.0090e-06_r8,8.3895e-06_r8,1.0037e-05_r8/)
      kbo(:,35, 1) = (/ &
     &4.1780e-06_r8,4.9520e-06_r8,5.8797e-06_r8,7.0288e-06_r8,8.4123e-06_r8/)
      kbo(:,36, 1) = (/ &
     &3.4370e-06_r8,4.0690e-06_r8,4.8335e-06_r8,5.7766e-06_r8,6.9140e-06_r8/)
      kbo(:,37, 1) = (/ &
     &2.7366e-06_r8,3.2617e-06_r8,3.8617e-06_r8,4.6224e-06_r8,5.5308e-06_r8/)
      kbo(:,38, 1) = (/ &
     &2.1763e-06_r8,2.6155e-06_r8,3.0811e-06_r8,3.6939e-06_r8,4.4152e-06_r8/)
      kbo(:,39, 1) = (/ &
     &1.7313e-06_r8,2.1017e-06_r8,2.4606e-06_r8,2.9519e-06_r8,3.5266e-06_r8/)
      kbo(:,40, 1) = (/ &
     &1.3469e-06_r8,1.6693e-06_r8,1.9344e-06_r8,2.3182e-06_r8,2.7667e-06_r8/)
      kbo(:,41, 1) = (/ &
     &1.0461e-06_r8,1.2927e-06_r8,1.5201e-06_r8,1.8107e-06_r8,2.1653e-06_r8/)
      kbo(:,42, 1) = (/ &
     &8.0658e-07_r8,1.0022e-06_r8,1.1943e-06_r8,1.4143e-06_r8,1.6945e-06_r8/)
      kbo(:,43, 1) = (/ &
     &6.1022e-07_r8,7.6847e-07_r8,9.3637e-07_r8,1.0945e-06_r8,1.3137e-06_r8/)
      kbo(:,44, 1) = (/ &
     &4.5840e-07_r8,5.8613e-07_r8,7.2558e-07_r8,8.4731e-07_r8,1.0130e-06_r8/)
      kbo(:,45, 1) = (/ &
     &3.4424e-07_r8,4.4504e-07_r8,5.5242e-07_r8,6.5691e-07_r8,7.7925e-07_r8/)
      kbo(:,46, 1) = (/ &
     &2.5697e-07_r8,3.3261e-07_r8,4.1921e-07_r8,5.1218e-07_r8,5.9773e-07_r8/)
      kbo(:,47, 1) = (/ &
     &1.8987e-07_r8,2.4567e-07_r8,3.1544e-07_r8,3.9053e-07_r8,4.5787e-07_r8/)
      kbo(:,48, 1) = (/ &
     &1.4058e-07_r8,1.8138e-07_r8,2.3483e-07_r8,2.9330e-07_r8,3.5197e-07_r8/)
      kbo(:,49, 1) = (/ &
     &1.0462e-07_r8,1.3385e-07_r8,1.7347e-07_r8,2.2053e-07_r8,2.7396e-07_r8/)
      kbo(:,50, 1) = (/ &
     &7.9205e-08_r8,9.9611e-08_r8,1.2890e-07_r8,1.6695e-07_r8,2.0670e-07_r8/)
      kbo(:,51, 1) = (/ &
     &6.0628e-08_r8,7.4396e-08_r8,9.6049e-08_r8,1.2454e-07_r8,1.5638e-07_r8/)
      kbo(:,52, 1) = (/ &
     &4.5002e-08_r8,5.5943e-08_r8,7.1532e-08_r8,9.2844e-08_r8,1.1852e-07_r8/)
      kbo(:,53, 1) = (/ &
     &3.2555e-08_r8,4.2490e-08_r8,5.3383e-08_r8,6.9149e-08_r8,8.9727e-08_r8/)
      kbo(:,54, 1) = (/ &
     &2.3696e-08_r8,3.2653e-08_r8,4.0140e-08_r8,5.1914e-08_r8,6.7441e-08_r8/)
      kbo(:,55, 1) = (/ &
     &1.7247e-08_r8,2.4546e-08_r8,3.0469e-08_r8,3.9087e-08_r8,5.0840e-08_r8/)
      kbo(:,56, 1) = (/ &
     &1.2515e-08_r8,1.8025e-08_r8,2.3296e-08_r8,2.9456e-08_r8,3.8300e-08_r8/)
      kbo(:,57, 1) = (/ &
     &9.0211e-09_r8,1.3183e-08_r8,1.7891e-08_r8,2.2220e-08_r8,2.8857e-08_r8/)
      kbo(:,58, 1) = (/ &
     &6.4935e-09_r8,9.6472e-09_r8,1.3706e-08_r8,1.6858e-08_r8,2.1803e-08_r8/)
      kbo(:,59, 1) = (/ &
     &5.0413e-09_r8,7.5477e-09_r8,1.0800e-08_r8,1.3392e-08_r8,1.7290e-08_r8/)
      kbo(:,13, 2) = (/ &
     &3.6782e-04_r8,4.0460e-04_r8,4.6828e-04_r8,5.6427e-04_r8,6.8387e-04_r8/)
      kbo(:,14, 2) = (/ &
     &3.0206e-04_r8,3.3534e-04_r8,3.8904e-04_r8,4.6908e-04_r8,5.7354e-04_r8/)
      kbo(:,15, 2) = (/ &
     &2.4903e-04_r8,2.7718e-04_r8,3.2574e-04_r8,3.9271e-04_r8,4.8202e-04_r8/)
      kbo(:,16, 2) = (/ &
     &2.0570e-04_r8,2.3043e-04_r8,2.7323e-04_r8,3.2940e-04_r8,4.0539e-04_r8/)
      kbo(:,17, 2) = (/ &
     &1.6973e-04_r8,1.9226e-04_r8,2.2908e-04_r8,2.7627e-04_r8,3.4057e-04_r8/)
      kbo(:,18, 2) = (/ &
     &1.4059e-04_r8,1.6018e-04_r8,1.9182e-04_r8,2.3171e-04_r8,2.8730e-04_r8/)
      kbo(:,19, 2) = (/ &
     &1.1617e-04_r8,1.3358e-04_r8,1.6042e-04_r8,1.9424e-04_r8,2.4177e-04_r8/)
      kbo(:,20, 2) = (/ &
     &9.6546e-05_r8,1.1187e-04_r8,1.3461e-04_r8,1.6319e-04_r8,2.0430e-04_r8/)
      kbo(:,21, 2) = (/ &
     &8.0465e-05_r8,9.3512e-05_r8,1.1260e-04_r8,1.3712e-04_r8,1.7240e-04_r8/)
      kbo(:,22, 2) = (/ &
     &6.7521e-05_r8,7.9100e-05_r8,9.4853e-05_r8,1.1694e-04_r8,1.4756e-04_r8/)
      kbo(:,23, 2) = (/ &
     &5.6632e-05_r8,6.7211e-05_r8,8.0875e-05_r8,9.9624e-05_r8,1.2638e-04_r8/)
      kbo(:,24, 2) = (/ &
     &4.7866e-05_r8,5.7310e-05_r8,6.9154e-05_r8,8.5301e-05_r8,1.0831e-04_r8/)
      kbo(:,25, 2) = (/ &
     &4.0652e-05_r8,4.8933e-05_r8,5.9257e-05_r8,7.3835e-05_r8,9.2951e-05_r8/)
      kbo(:,26, 2) = (/ &
     &3.4655e-05_r8,4.1694e-05_r8,5.0935e-05_r8,6.3979e-05_r8,8.0042e-05_r8/)
      kbo(:,27, 2) = (/ &
     &2.9633e-05_r8,3.5562e-05_r8,4.3853e-05_r8,5.5348e-05_r8,6.8920e-05_r8/)
      kbo(:,28, 2) = (/ &
     &2.5432e-05_r8,3.0614e-05_r8,3.7665e-05_r8,4.7871e-05_r8,5.9328e-05_r8/)
      kbo(:,29, 2) = (/ &
     &2.1848e-05_r8,2.6432e-05_r8,3.2844e-05_r8,4.1383e-05_r8,5.1047e-05_r8/)
      kbo(:,30, 2) = (/ &
     &1.8680e-05_r8,2.2782e-05_r8,2.8578e-05_r8,3.5766e-05_r8,4.3772e-05_r8/)
      kbo(:,31, 2) = (/ &
     &1.5971e-05_r8,1.9690e-05_r8,2.4825e-05_r8,3.0907e-05_r8,3.7564e-05_r8/)
      kbo(:,32, 2) = (/ &
     &1.3804e-05_r8,1.6977e-05_r8,2.1562e-05_r8,2.6712e-05_r8,3.2275e-05_r8/)
      kbo(:,33, 2) = (/ &
     &1.1945e-05_r8,1.4856e-05_r8,1.8696e-05_r8,2.3037e-05_r8,2.7659e-05_r8/)
      kbo(:,34, 2) = (/ &
     &1.0252e-05_r8,1.2851e-05_r8,1.6075e-05_r8,1.9670e-05_r8,2.3561e-05_r8/)
      kbo(:,35, 2) = (/ &
     &8.6288e-06_r8,1.0847e-05_r8,1.3532e-05_r8,1.6502e-05_r8,1.9733e-05_r8/)
      kbo(:,36, 2) = (/ &
     &7.0970e-06_r8,8.9246e-06_r8,1.1130e-05_r8,1.3564e-05_r8,1.6217e-05_r8/)
      kbo(:,37, 2) = (/ &
     &5.6546e-06_r8,7.0912e-06_r8,8.8667e-06_r8,1.0842e-05_r8,1.2980e-05_r8/)
      kbo(:,38, 2) = (/ &
     &4.4964e-06_r8,5.6180e-06_r8,7.0484e-06_r8,8.6481e-06_r8,1.0377e-05_r8/)
      kbo(:,39, 2) = (/ &
     &3.5794e-06_r8,4.4460e-06_r8,5.6006e-06_r8,6.9055e-06_r8,8.2935e-06_r8/)
      kbo(:,40, 2) = (/ &
     &2.7849e-06_r8,3.4244e-06_r8,4.3497e-06_r8,5.3888e-06_r8,6.5103e-06_r8/)
      kbo(:,41, 2) = (/ &
     &2.1634e-06_r8,2.6661e-06_r8,3.3623e-06_r8,4.1856e-06_r8,5.0849e-06_r8/)
      kbo(:,42, 2) = (/ &
     &1.6951e-06_r8,2.0688e-06_r8,2.5958e-06_r8,3.2479e-06_r8,3.9733e-06_r8/)
      kbo(:,43, 2) = (/ &
     &1.3156e-06_r8,1.5889e-06_r8,1.9703e-06_r8,2.4872e-06_r8,3.0727e-06_r8/)
      kbo(:,44, 2) = (/ &
     &1.0083e-06_r8,1.2108e-06_r8,1.4918e-06_r8,1.8898e-06_r8,2.3484e-06_r8/)
      kbo(:,45, 2) = (/ &
     &7.7597e-07_r8,9.3178e-07_r8,1.1396e-06_r8,1.4323e-06_r8,1.7919e-06_r8/)
      kbo(:,46, 2) = (/ &
     &5.9640e-07_r8,7.1743e-07_r8,8.6664e-07_r8,1.0739e-06_r8,1.3585e-06_r8/)
      kbo(:,47, 2) = (/ &
     &4.5875e-07_r8,5.4303e-07_r8,6.5202e-07_r8,8.0415e-07_r8,1.0165e-06_r8/)
      kbo(:,48, 2) = (/ &
     &3.5634e-07_r8,4.1385e-07_r8,4.9968e-07_r8,6.0505e-07_r8,7.5779e-07_r8/)
      kbo(:,49, 2) = (/ &
     &2.7966e-07_r8,3.1607e-07_r8,3.7849e-07_r8,4.5539e-07_r8,5.6073e-07_r8/)
      kbo(:,50, 2) = (/ &
     &2.2335e-07_r8,2.4619e-07_r8,2.8832e-07_r8,3.4563e-07_r8,4.2520e-07_r8/)
      kbo(:,51, 2) = (/ &
     &1.6810e-07_r8,1.9184e-07_r8,2.2126e-07_r8,2.6681e-07_r8,3.2272e-07_r8/)
      kbo(:,52, 2) = (/ &
     &1.2477e-07_r8,1.5183e-07_r8,1.7051e-07_r8,2.0325e-07_r8,2.4465e-07_r8/)
      kbo(:,53, 2) = (/ &
     &9.1697e-08_r8,1.2163e-07_r8,1.3293e-07_r8,1.5546e-07_r8,1.8654e-07_r8/)
      kbo(:,54, 2) = (/ &
     &6.8066e-08_r8,9.0724e-08_r8,1.0426e-07_r8,1.1988e-07_r8,1.4459e-07_r8/)
      kbo(:,55, 2) = (/ &
     &5.0853e-08_r8,6.8116e-08_r8,8.2949e-08_r8,9.3086e-08_r8,1.1106e-07_r8/)
      kbo(:,56, 2) = (/ &
     &3.8097e-08_r8,5.0708e-08_r8,6.6601e-08_r8,7.3097e-08_r8,8.5626e-08_r8/)
      kbo(:,57, 2) = (/ &
     &2.8575e-08_r8,3.7778e-08_r8,5.0543e-08_r8,5.7226e-08_r8,6.6193e-08_r8/)
      kbo(:,58, 2) = (/ &
     &2.1274e-08_r8,2.8319e-08_r8,3.8061e-08_r8,4.5485e-08_r8,5.1336e-08_r8/)
      kbo(:,59, 2) = (/ &
     &1.6785e-08_r8,2.2389e-08_r8,3.0047e-08_r8,3.6850e-08_r8,4.1308e-08_r8/)
      kbo(:,13, 3) = (/ &
     &4.8329e-04_r8,7.1031e-04_r8,9.2618e-04_r8,1.1787e-03_r8,1.4998e-03_r8/)
      kbo(:,14, 3) = (/ &
     &4.1573e-04_r8,5.9621e-04_r8,7.7781e-04_r8,9.9253e-04_r8,1.2561e-03_r8/)
      kbo(:,15, 3) = (/ &
     &3.5745e-04_r8,5.0356e-04_r8,6.5391e-04_r8,8.3999e-04_r8,1.0559e-03_r8/)
      kbo(:,16, 3) = (/ &
     &3.0758e-04_r8,4.2512e-04_r8,5.5063e-04_r8,7.1032e-04_r8,8.8405e-04_r8/)
      kbo(:,17, 3) = (/ &
     &2.6428e-04_r8,3.5939e-04_r8,4.6476e-04_r8,5.9990e-04_r8,7.3444e-04_r8/)
      kbo(:,18, 3) = (/ &
     &2.2620e-04_r8,3.0371e-04_r8,3.9242e-04_r8,5.0569e-04_r8,6.1057e-04_r8/)
      kbo(:,19, 3) = (/ &
     &1.9349e-04_r8,2.5703e-04_r8,3.3045e-04_r8,4.2572e-04_r8,5.0885e-04_r8/)
      kbo(:,20, 3) = (/ &
     &1.6601e-04_r8,2.1679e-04_r8,2.7938e-04_r8,3.5877e-04_r8,4.2456e-04_r8/)
      kbo(:,21, 3) = (/ &
     &1.3973e-04_r8,1.8356e-04_r8,2.3660e-04_r8,3.0163e-04_r8,3.5438e-04_r8/)
      kbo(:,22, 3) = (/ &
     &1.2024e-04_r8,1.5775e-04_r8,2.0424e-04_r8,2.5718e-04_r8,2.9870e-04_r8/)
      kbo(:,23, 3) = (/ &
     &1.0421e-04_r8,1.3581e-04_r8,1.7576e-04_r8,2.1785e-04_r8,2.5256e-04_r8/)
      kbo(:,24, 3) = (/ &
     &9.0642e-05_r8,1.1736e-04_r8,1.5142e-04_r8,1.8334e-04_r8,2.1432e-04_r8/)
      kbo(:,25, 3) = (/ &
     &7.8653e-05_r8,1.0139e-04_r8,1.3046e-04_r8,1.5520e-04_r8,1.8200e-04_r8/)
      kbo(:,26, 3) = (/ &
     &6.8347e-05_r8,8.8330e-05_r8,1.1221e-04_r8,1.3139e-04_r8,1.5501e-04_r8/)
      kbo(:,27, 3) = (/ &
     &5.9438e-05_r8,7.7110e-05_r8,9.6484e-05_r8,1.1163e-04_r8,1.3198e-04_r8/)
      kbo(:,28, 3) = (/ &
     &5.1865e-05_r8,6.7062e-05_r8,8.1622e-05_r8,9.5189e-05_r8,1.1250e-04_r8/)
      kbo(:,29, 3) = (/ &
     &4.5229e-05_r8,5.8248e-05_r8,6.9371e-05_r8,8.1305e-05_r8,9.5987e-05_r8/)
      kbo(:,30, 3) = (/ &
     &3.9548e-05_r8,5.0236e-05_r8,5.8927e-05_r8,6.9361e-05_r8,8.1985e-05_r8/)
      kbo(:,31, 3) = (/ &
     &3.4672e-05_r8,4.3357e-05_r8,5.0119e-05_r8,5.9230e-05_r8,7.0087e-05_r8/)
      kbo(:,32, 3) = (/ &
     &3.0291e-05_r8,3.6761e-05_r8,4.2859e-05_r8,5.0621e-05_r8,5.9826e-05_r8/)
      kbo(:,33, 3) = (/ &
     &2.6343e-05_r8,3.1291e-05_r8,3.6685e-05_r8,4.3251e-05_r8,5.1136e-05_r8/)
      kbo(:,34, 3) = (/ &
     &2.2619e-05_r8,2.6479e-05_r8,3.1160e-05_r8,3.6817e-05_r8,4.3454e-05_r8/)
      kbo(:,35, 3) = (/ &
     &1.9044e-05_r8,2.2094e-05_r8,2.6069e-05_r8,3.0814e-05_r8,3.6332e-05_r8/)
      kbo(:,36, 3) = (/ &
     &1.5660e-05_r8,1.8150e-05_r8,2.1420e-05_r8,2.5318e-05_r8,2.9845e-05_r8/)
      kbo(:,37, 3) = (/ &
     &1.2481e-05_r8,1.4567e-05_r8,1.7160e-05_r8,2.0273e-05_r8,2.3924e-05_r8/)
      kbo(:,38, 3) = (/ &
     &9.9229e-06_r8,1.1707e-05_r8,1.3728e-05_r8,1.6208e-05_r8,1.9147e-05_r8/)
      kbo(:,39, 3) = (/ &
     &7.8980e-06_r8,9.3824e-06_r8,1.0994e-05_r8,1.2956e-05_r8,1.5319e-05_r8/)
      kbo(:,40, 3) = (/ &
     &6.1214e-06_r8,7.4148e-06_r8,8.6411e-06_r8,1.0203e-05_r8,1.2052e-05_r8/)
      kbo(:,41, 3) = (/ &
     &4.7079e-06_r8,5.8792e-06_r8,6.7814e-06_r8,8.0075e-06_r8,9.4649e-06_r8/)
      kbo(:,42, 3) = (/ &
     &3.6048e-06_r8,4.5698e-06_r8,5.3449e-06_r8,6.2854e-06_r8,7.4263e-06_r8/)
      kbo(:,43, 3) = (/ &
     &2.7216e-06_r8,3.5076e-06_r8,4.1783e-06_r8,4.8932e-06_r8,5.7661e-06_r8/)
      kbo(:,44, 3) = (/ &
     &2.0468e-06_r8,2.6504e-06_r8,3.2648e-06_r8,3.7820e-06_r8,4.4701e-06_r8/)
      kbo(:,45, 3) = (/ &
     &1.5361e-06_r8,1.9893e-06_r8,2.5184e-06_r8,2.9393e-06_r8,3.4602e-06_r8/)
      kbo(:,46, 3) = (/ &
     &1.1503e-06_r8,1.4832e-06_r8,1.9137e-06_r8,2.2823e-06_r8,2.6719e-06_r8/)
      kbo(:,47, 3) = (/ &
     &8.3777e-07_r8,1.0971e-06_r8,1.4217e-06_r8,1.7739e-06_r8,2.0443e-06_r8/)
      kbo(:,48, 3) = (/ &
     &6.1407e-07_r8,8.0972e-07_r8,1.0453e-06_r8,1.3363e-06_r8,1.5776e-06_r8/)
      kbo(:,49, 3) = (/ &
     &4.3890e-07_r8,5.9676e-07_r8,7.7449e-07_r8,1.0018e-06_r8,1.2151e-06_r8/)
      kbo(:,50, 3) = (/ &
     &3.0232e-07_r8,4.3632e-07_r8,5.7501e-07_r8,7.4600e-07_r8,9.3964e-07_r8/)
      kbo(:,51, 3) = (/ &
     &2.1820e-07_r8,3.2558e-07_r8,4.2933e-07_r8,5.5411e-07_r8,7.1236e-07_r8/)
      kbo(:,52, 3) = (/ &
     &1.6142e-07_r8,2.3096e-07_r8,3.1815e-07_r8,4.1428e-07_r8,5.3670e-07_r8/)
      kbo(:,53, 3) = (/ &
     &1.2239e-07_r8,1.5927e-07_r8,2.3415e-07_r8,3.0848e-07_r8,4.0010e-07_r8/)
      kbo(:,54, 3) = (/ &
     &9.4287e-08_r8,1.1772e-07_r8,1.7609e-07_r8,2.3226e-07_r8,2.9972e-07_r8/)
      kbo(:,55, 3) = (/ &
     &7.3559e-08_r8,8.8158e-08_r8,1.2627e-07_r8,1.7401e-07_r8,2.2659e-07_r8/)
      kbo(:,56, 3) = (/ &
     &5.7474e-08_r8,6.7419e-08_r8,8.9064e-08_r8,1.2949e-07_r8,1.7067e-07_r8/)
      kbo(:,57, 3) = (/ &
     &4.5317e-08_r8,5.2043e-08_r8,6.5424e-08_r8,9.7761e-08_r8,1.2882e-07_r8/)
      kbo(:,58, 3) = (/ &
     &3.4988e-08_r8,4.0617e-08_r8,4.8970e-08_r8,7.1601e-08_r8,9.7431e-08_r8/)
      kbo(:,59, 3) = (/ &
     &2.8131e-08_r8,3.2653e-08_r8,3.8986e-08_r8,5.5678e-08_r8,7.6933e-08_r8/)
      kbo(:,13, 4) = (/ &
     &1.2375e-03_r8,1.3907e-03_r8,1.6848e-03_r8,2.0764e-03_r8,2.5455e-03_r8/)
      kbo(:,14, 4) = (/ &
     &1.0352e-03_r8,1.1626e-03_r8,1.4153e-03_r8,1.7410e-03_r8,2.1410e-03_r8/)
      kbo(:,15, 4) = (/ &
     &8.6916e-04_r8,9.7450e-04_r8,1.1918e-03_r8,1.4617e-03_r8,1.8090e-03_r8/)
      kbo(:,16, 4) = (/ &
     &7.1556e-04_r8,8.1812e-04_r8,1.0040e-03_r8,1.2311e-03_r8,1.5286e-03_r8/)
      kbo(:,17, 4) = (/ &
     &5.8965e-04_r8,6.8521e-04_r8,8.4372e-04_r8,1.0375e-03_r8,1.2976e-03_r8/)
      kbo(:,18, 4) = (/ &
     &4.8726e-04_r8,5.7342e-04_r8,7.0979e-04_r8,8.7350e-04_r8,1.0996e-03_r8/)
      kbo(:,19, 4) = (/ &
     &4.0346e-04_r8,4.7923e-04_r8,5.9512e-04_r8,7.3474e-04_r8,9.2909e-04_r8/)
      kbo(:,20, 4) = (/ &
     &3.3252e-04_r8,4.0340e-04_r8,5.0129e-04_r8,6.2120e-04_r8,7.8738e-04_r8/)
      kbo(:,21, 4) = (/ &
     &2.7824e-04_r8,3.3959e-04_r8,4.2206e-04_r8,5.2456e-04_r8,6.6651e-04_r8/)
      kbo(:,22, 4) = (/ &
     &2.3686e-04_r8,2.9111e-04_r8,3.6067e-04_r8,4.4836e-04_r8,5.7225e-04_r8/)
      kbo(:,23, 4) = (/ &
     &2.0203e-04_r8,2.4985e-04_r8,3.0880e-04_r8,3.8545e-04_r8,4.9113e-04_r8/)
      kbo(:,24, 4) = (/ &
     &1.7215e-04_r8,2.1409e-04_r8,2.6491e-04_r8,3.3340e-04_r8,4.2129e-04_r8/)
      kbo(:,25, 4) = (/ &
     &1.4744e-04_r8,1.8341e-04_r8,2.2761e-04_r8,2.8826e-04_r8,3.6138e-04_r8/)
      kbo(:,26, 4) = (/ &
     &1.2712e-04_r8,1.5795e-04_r8,1.9671e-04_r8,2.5046e-04_r8,3.1109e-04_r8/)
      kbo(:,27, 4) = (/ &
     &1.1012e-04_r8,1.3626e-04_r8,1.6969e-04_r8,2.1697e-04_r8,2.6764e-04_r8/)
      kbo(:,28, 4) = (/ &
     &9.5268e-05_r8,1.1775e-04_r8,1.4811e-04_r8,1.8739e-04_r8,2.3002e-04_r8/)
      kbo(:,29, 4) = (/ &
     &8.1990e-05_r8,1.0183e-04_r8,1.2887e-04_r8,1.6155e-04_r8,1.9779e-04_r8/)
      kbo(:,30, 4) = (/ &
     &7.0812e-05_r8,8.8197e-05_r8,1.1209e-04_r8,1.3932e-04_r8,1.6990e-04_r8/)
      kbo(:,31, 4) = (/ &
     &6.1297e-05_r8,7.6242e-05_r8,9.7371e-05_r8,1.2004e-04_r8,1.4578e-04_r8/)
      kbo(:,32, 4) = (/ &
     &5.3068e-05_r8,6.6743e-05_r8,8.4358e-05_r8,1.0341e-04_r8,1.2514e-04_r8/)
      kbo(:,33, 4) = (/ &
     &4.6021e-05_r8,5.8210e-05_r8,7.2823e-05_r8,8.9095e-05_r8,1.0732e-04_r8/)
      kbo(:,34, 4) = (/ &
     &3.9611e-05_r8,5.0325e-05_r8,6.2484e-05_r8,7.6131e-05_r8,9.1418e-05_r8/)
      kbo(:,35, 4) = (/ &
     &3.3314e-05_r8,4.2493e-05_r8,5.2519e-05_r8,6.3851e-05_r8,7.6543e-05_r8/)
      kbo(:,36, 4) = (/ &
     &2.7397e-05_r8,3.4956e-05_r8,4.3170e-05_r8,5.2466e-05_r8,6.2879e-05_r8/)
      kbo(:,37, 4) = (/ &
     &2.1842e-05_r8,2.7769e-05_r8,3.4424e-05_r8,4.1912e-05_r8,5.0314e-05_r8/)
      kbo(:,38, 4) = (/ &
     &1.7352e-05_r8,2.1971e-05_r8,2.7389e-05_r8,3.3429e-05_r8,4.0195e-05_r8/)
      kbo(:,39, 4) = (/ &
     &1.3770e-05_r8,1.7414e-05_r8,2.1778e-05_r8,2.6648e-05_r8,3.2100e-05_r8/)
      kbo(:,40, 4) = (/ &
     &1.0696e-05_r8,1.3450e-05_r8,1.6968e-05_r8,2.0795e-05_r8,2.5164e-05_r8/)
      kbo(:,41, 4) = (/ &
     &8.2926e-06_r8,1.0301e-05_r8,1.3150e-05_r8,1.6196e-05_r8,1.9663e-05_r8/)
      kbo(:,42, 4) = (/ &
     &6.4321e-06_r8,7.9930e-06_r8,1.0153e-05_r8,1.2599e-05_r8,1.5345e-05_r8/)
      kbo(:,43, 4) = (/ &
     &4.9294e-06_r8,6.1147e-06_r8,7.7222e-06_r8,9.6711e-06_r8,1.1840e-05_r8/)
      kbo(:,44, 4) = (/ &
     &3.7796e-06_r8,4.6518e-06_r8,5.8136e-06_r8,7.3808e-06_r8,9.0677e-06_r8/)
      kbo(:,45, 4) = (/ &
     &2.8649e-06_r8,3.5446e-06_r8,4.4045e-06_r8,5.6003e-06_r8,6.9419e-06_r8/)
      kbo(:,46, 4) = (/ &
     &2.1636e-06_r8,2.6897e-06_r8,3.3348e-06_r8,4.2109e-06_r8,5.2785e-06_r8/)
      kbo(:,47, 4) = (/ &
     &1.6423e-06_r8,2.0325e-06_r8,2.5019e-06_r8,3.1092e-06_r8,3.9697e-06_r8/)
      kbo(:,48, 4) = (/ &
     &1.2438e-06_r8,1.5176e-06_r8,1.8805e-06_r8,2.3386e-06_r8,2.9598e-06_r8/)
      kbo(:,49, 4) = (/ &
     &9.6637e-07_r8,1.1421e-06_r8,1.4184e-06_r8,1.7520e-06_r8,2.2027e-06_r8/)
      kbo(:,50, 4) = (/ &
     &7.6681e-07_r8,8.7015e-07_r8,1.0718e-06_r8,1.3233e-06_r8,1.6436e-06_r8/)
      kbo(:,51, 4) = (/ &
     &5.7638e-07_r8,6.6674e-07_r8,8.0765e-07_r8,1.0019e-06_r8,1.2448e-06_r8/)
      kbo(:,52, 4) = (/ &
     &4.3579e-07_r8,5.2641e-07_r8,6.1480e-07_r8,7.6360e-07_r8,9.4101e-07_r8/)
      kbo(:,53, 4) = (/ &
     &3.2630e-07_r8,4.1175e-07_r8,4.6866e-07_r8,5.7670e-07_r8,7.1273e-07_r8/)
      kbo(:,54, 4) = (/ &
     &2.4508e-07_r8,3.1226e-07_r8,3.6234e-07_r8,4.3785e-07_r8,5.4334e-07_r8/)
      kbo(:,55, 4) = (/ &
     &1.8867e-07_r8,2.3849e-07_r8,2.8812e-07_r8,3.3656e-07_r8,4.1795e-07_r8/)
      kbo(:,56, 4) = (/ &
     &1.3888e-07_r8,1.8052e-07_r8,2.2770e-07_r8,2.5896e-07_r8,3.1922e-07_r8/)
      kbo(:,57, 4) = (/ &
     &9.9211e-08_r8,1.3628e-07_r8,1.7309e-07_r8,2.0040e-07_r8,2.4315e-07_r8/)
      kbo(:,58, 4) = (/ &
     &7.2311e-08_r8,1.0440e-07_r8,1.3249e-07_r8,1.5839e-07_r8,1.8707e-07_r8/)
      kbo(:,59, 4) = (/ &
     &5.6449e-08_r8,8.3969e-08_r8,1.0579e-07_r8,1.2870e-07_r8,1.4987e-07_r8/)
      kbo(:,13, 5) = (/ &
     &2.0768e-03_r8,2.8684e-03_r8,3.7718e-03_r8,4.8192e-03_r8,6.0412e-03_r8/)
      kbo(:,14, 5) = (/ &
     &1.7564e-03_r8,2.4332e-03_r8,3.1824e-03_r8,4.0625e-03_r8,5.0889e-03_r8/)
      kbo(:,15, 5) = (/ &
     &1.4908e-03_r8,2.0712e-03_r8,2.6934e-03_r8,3.4353e-03_r8,4.2909e-03_r8/)
      kbo(:,16, 5) = (/ &
     &1.2837e-03_r8,1.7624e-03_r8,2.2850e-03_r8,2.9120e-03_r8,3.6366e-03_r8/)
      kbo(:,17, 5) = (/ &
     &1.1007e-03_r8,1.4970e-03_r8,1.9372e-03_r8,2.4633e-03_r8,3.0868e-03_r8/)
      kbo(:,18, 5) = (/ &
     &9.3998e-04_r8,1.2697e-03_r8,1.6378e-03_r8,2.0802e-03_r8,2.6082e-03_r8/)
      kbo(:,19, 5) = (/ &
     &8.0100e-04_r8,1.0742e-03_r8,1.3849e-03_r8,1.7569e-03_r8,2.2030e-03_r8/)
      kbo(:,20, 5) = (/ &
     &6.8663e-04_r8,9.1195e-04_r8,1.1757e-03_r8,1.4883e-03_r8,1.8647e-03_r8/)
      kbo(:,21, 5) = (/ &
     &5.8705e-04_r8,7.7399e-04_r8,9.9752e-04_r8,1.2607e-03_r8,1.5771e-03_r8/)
      kbo(:,22, 5) = (/ &
     &5.1050e-04_r8,6.6826e-04_r8,8.5880e-04_r8,1.0835e-03_r8,1.3514e-03_r8/)
      kbo(:,23, 5) = (/ &
     &4.4216e-04_r8,5.7700e-04_r8,7.3906e-04_r8,9.3102e-04_r8,1.1572e-03_r8/)
      kbo(:,24, 5) = (/ &
     &3.8397e-04_r8,4.9926e-04_r8,6.3682e-04_r8,8.0099e-04_r8,9.9155e-04_r8/)
      kbo(:,25, 5) = (/ &
     &3.3452e-04_r8,4.3352e-04_r8,5.4972e-04_r8,6.8946e-04_r8,8.5204e-04_r8/)
      kbo(:,26, 5) = (/ &
     &2.9253e-04_r8,3.7705e-04_r8,4.7637e-04_r8,5.9546e-04_r8,7.3410e-04_r8/)
      kbo(:,27, 5) = (/ &
     &2.5516e-04_r8,3.2740e-04_r8,4.1271e-04_r8,5.1423e-04_r8,6.3183e-04_r8/)
      kbo(:,28, 5) = (/ &
     &2.2216e-04_r8,2.8389e-04_r8,3.5748e-04_r8,4.4367e-04_r8,5.4344e-04_r8/)
      kbo(:,29, 5) = (/ &
     &1.9425e-04_r8,2.4642e-04_r8,3.0966e-04_r8,3.8285e-04_r8,4.6743e-04_r8/)
      kbo(:,30, 5) = (/ &
     &1.6916e-04_r8,2.1405e-04_r8,2.6782e-04_r8,3.3008e-04_r8,4.0176e-04_r8/)
      kbo(:,31, 5) = (/ &
     &1.4722e-04_r8,1.8596e-04_r8,2.3162e-04_r8,2.8455e-04_r8,3.4535e-04_r8/)
      kbo(:,32, 5) = (/ &
     &1.2822e-04_r8,1.6146e-04_r8,2.0021e-04_r8,2.4528e-04_r8,2.9677e-04_r8/)
      kbo(:,33, 5) = (/ &
     &1.1158e-04_r8,1.4011e-04_r8,1.7313e-04_r8,2.1133e-04_r8,2.5496e-04_r8/)
      kbo(:,34, 5) = (/ &
     &9.6356e-05_r8,1.2055e-04_r8,1.4854e-04_r8,1.8079e-04_r8,2.1758e-04_r8/)
      kbo(:,35, 5) = (/ &
     &8.1343e-05_r8,1.0151e-04_r8,1.2490e-04_r8,1.5178e-04_r8,1.8239e-04_r8/)
      kbo(:,36, 5) = (/ &
     &6.6965e-05_r8,8.3520e-05_r8,1.0275e-04_r8,1.2482e-04_r8,1.4993e-04_r8/)
      kbo(:,37, 5) = (/ &
     &5.3206e-05_r8,6.6545e-05_r8,8.1990e-05_r8,9.9764e-05_r8,1.2001e-04_r8/)
      kbo(:,38, 5) = (/ &
     &4.2208e-05_r8,5.2902e-05_r8,6.5299e-05_r8,7.9577e-05_r8,9.5895e-05_r8/)
      kbo(:,39, 5) = (/ &
     &3.3472e-05_r8,4.2041e-05_r8,5.1984e-05_r8,6.3462e-05_r8,7.6593e-05_r8/)
      kbo(:,40, 5) = (/ &
     &2.5925e-05_r8,3.2660e-05_r8,4.0509e-05_r8,4.9627e-05_r8,6.0037e-05_r8/)
      kbo(:,41, 5) = (/ &
     &2.0003e-05_r8,2.5267e-05_r8,3.1469e-05_r8,3.8672e-05_r8,4.6923e-05_r8/)
      kbo(:,42, 5) = (/ &
     &1.5411e-05_r8,1.9519e-05_r8,2.4420e-05_r8,3.0101e-05_r8,3.6637e-05_r8/)
      kbo(:,43, 5) = (/ &
     &1.1687e-05_r8,1.4867e-05_r8,1.8698e-05_r8,2.3140e-05_r8,2.8269e-05_r8/)
      kbo(:,44, 5) = (/ &
     &8.7679e-06_r8,1.1261e-05_r8,1.4209e-05_r8,1.7673e-05_r8,2.1693e-05_r8/)
      kbo(:,45, 5) = (/ &
     &6.5931e-06_r8,8.5087e-06_r8,1.0776e-05_r8,1.3478e-05_r8,1.6614e-05_r8/)
      kbo(:,46, 5) = (/ &
     &4.9080e-06_r8,6.3755e-06_r8,8.1160e-06_r8,1.0213e-05_r8,1.2647e-05_r8/)
      kbo(:,47, 5) = (/ &
     &3.5919e-06_r8,4.7038e-06_r8,6.0534e-06_r8,7.6485e-06_r8,9.5281e-06_r8/)
      kbo(:,48, 5) = (/ &
     &2.6062e-06_r8,3.4739e-06_r8,4.4987e-06_r8,5.7085e-06_r8,7.1618e-06_r8/)
      kbo(:,49, 5) = (/ &
     &1.8621e-06_r8,2.5496e-06_r8,3.3246e-06_r8,4.2578e-06_r8,5.3684e-06_r8/)
      kbo(:,50, 5) = (/ &
     &1.3311e-06_r8,1.8748e-06_r8,2.4717e-06_r8,3.1893e-06_r8,4.0386e-06_r8/)
      kbo(:,51, 5) = (/ &
     &9.8374e-07_r8,1.3665e-06_r8,1.8393e-06_r8,2.3887e-06_r8,3.0388e-06_r8/)
      kbo(:,52, 5) = (/ &
     &7.2293e-07_r8,9.8525e-07_r8,1.3616e-06_r8,1.7795e-06_r8,2.2858e-06_r8/)
      kbo(:,53, 5) = (/ &
     &5.3539e-07_r8,7.1322e-07_r8,1.0025e-06_r8,1.3275e-06_r8,1.7157e-06_r8/)
      kbo(:,54, 5) = (/ &
     &3.9532e-07_r8,5.3074e-07_r8,7.3585e-07_r8,9.9485e-07_r8,1.2941e-06_r8/)
      kbo(:,55, 5) = (/ &
     &2.9574e-07_r8,3.9534e-07_r8,5.3898e-07_r8,7.4534e-07_r8,9.7510e-07_r8/)
      kbo(:,56, 5) = (/ &
     &2.2158e-07_r8,2.9575e-07_r8,3.9553e-07_r8,5.5662e-07_r8,7.3612e-07_r8/)
      kbo(:,57, 5) = (/ &
     &1.7387e-07_r8,2.1999e-07_r8,2.9597e-07_r8,4.1152e-07_r8,5.5434e-07_r8/)
      kbo(:,58, 5) = (/ &
     &1.3813e-07_r8,1.6569e-07_r8,2.2197e-07_r8,3.0386e-07_r8,4.1774e-07_r8/)
      kbo(:,59, 5) = (/ &
     &1.1153e-07_r8,1.3014e-07_r8,1.7513e-07_r8,2.3832e-07_r8,3.3096e-07_r8/)
      kbo(:,13, 6) = (/ &
     &6.2563e-03_r8,8.5754e-03_r8,1.1313e-02_r8,1.4562e-02_r8,1.8439e-02_r8/)
      kbo(:,14, 6) = (/ &
     &5.3407e-03_r8,7.2874e-03_r8,9.6031e-03_r8,1.2344e-02_r8,1.5616e-02_r8/)
      kbo(:,15, 6) = (/ &
     &4.5624e-03_r8,6.2026e-03_r8,8.1616e-03_r8,1.0480e-02_r8,1.3236e-02_r8/)
      kbo(:,16, 6) = (/ &
     &3.8957e-03_r8,5.2793e-03_r8,6.9259e-03_r8,8.8846e-03_r8,1.1202e-02_r8/)
      kbo(:,17, 6) = (/ &
     &3.3209e-03_r8,4.4815e-03_r8,5.8698e-03_r8,7.5204e-03_r8,9.4486e-03_r8/)
      kbo(:,18, 6) = (/ &
     &2.8290e-03_r8,3.8089e-03_r8,4.9773e-03_r8,6.3684e-03_r8,7.9890e-03_r8/)
      kbo(:,19, 6) = (/ &
     &2.4112e-03_r8,3.2462e-03_r8,4.2316e-03_r8,5.4060e-03_r8,6.7720e-03_r8/)
      kbo(:,20, 6) = (/ &
     &2.0691e-03_r8,2.7791e-03_r8,3.6122e-03_r8,4.6028e-03_r8,5.7715e-03_r8/)
      kbo(:,21, 6) = (/ &
     &1.7739e-03_r8,2.3724e-03_r8,3.0729e-03_r8,3.9123e-03_r8,4.9081e-03_r8/)
      kbo(:,22, 6) = (/ &
     &1.5468e-03_r8,2.0535e-03_r8,2.6512e-03_r8,3.3770e-03_r8,4.2260e-03_r8/)
      kbo(:,23, 6) = (/ &
     &1.3475e-03_r8,1.7768e-03_r8,2.2959e-03_r8,2.9141e-03_r8,3.6373e-03_r8/)
      kbo(:,24, 6) = (/ &
     &1.1752e-03_r8,1.5439e-03_r8,1.9895e-03_r8,2.5170e-03_r8,3.1328e-03_r8/)
      kbo(:,25, 6) = (/ &
     &1.0263e-03_r8,1.3444e-03_r8,1.7264e-03_r8,2.1761e-03_r8,2.6990e-03_r8/)
      kbo(:,26, 6) = (/ &
     &9.0166e-04_r8,1.1758e-03_r8,1.5031e-03_r8,1.8871e-03_r8,2.3306e-03_r8/)
      kbo(:,27, 6) = (/ &
     &7.9141e-04_r8,1.0269e-03_r8,1.3074e-03_r8,1.6348e-03_r8,2.0092e-03_r8/)
      kbo(:,28, 6) = (/ &
     &6.9371e-04_r8,8.9592e-04_r8,1.1355e-03_r8,1.4137e-03_r8,1.7327e-03_r8/)
      kbo(:,29, 6) = (/ &
     &6.0795e-04_r8,7.8166e-04_r8,9.8572e-04_r8,1.2233e-03_r8,1.4938e-03_r8/)
      kbo(:,30, 6) = (/ &
     &5.3230e-04_r8,6.8106e-04_r8,8.5522e-04_r8,1.0576e-03_r8,1.2859e-03_r8/)
      kbo(:,31, 6) = (/ &
     &4.6592e-04_r8,5.9303e-04_r8,7.4221e-04_r8,9.1346e-04_r8,1.1061e-03_r8/)
      kbo(:,32, 6) = (/ &
     &4.0751e-04_r8,5.1643e-04_r8,6.4366e-04_r8,7.8848e-04_r8,9.5095e-04_r8/)
      kbo(:,33, 6) = (/ &
     &3.5610e-04_r8,4.4934e-04_r8,5.5753e-04_r8,6.8015e-04_r8,8.1668e-04_r8/)
      kbo(:,34, 6) = (/ &
     &3.0849e-04_r8,3.8773e-04_r8,4.7909e-04_r8,5.8242e-04_r8,6.9697e-04_r8/)
      kbo(:,35, 6) = (/ &
     &2.6100e-04_r8,3.2729e-04_r8,4.0344e-04_r8,4.8961e-04_r8,5.8449e-04_r8/)
      kbo(:,36, 6) = (/ &
     &2.1525e-04_r8,2.6972e-04_r8,3.3236e-04_r8,4.0320e-04_r8,4.8106e-04_r8/)
      kbo(:,37, 6) = (/ &
     &1.7127e-04_r8,2.1505e-04_r8,2.6562e-04_r8,3.2288e-04_r8,3.8605e-04_r8/)
      kbo(:,38, 6) = (/ &
     &1.3592e-04_r8,1.7107e-04_r8,2.1184e-04_r8,2.5803e-04_r8,3.0917e-04_r8/)
      kbo(:,39, 6) = (/ &
     &1.0785e-04_r8,1.3607e-04_r8,1.6885e-04_r8,2.0614e-04_r8,2.4755e-04_r8/)
      kbo(:,40, 6) = (/ &
     &8.3445e-05_r8,1.0573e-04_r8,1.3174e-04_r8,1.6145e-04_r8,1.9465e-04_r8/)
      kbo(:,41, 6) = (/ &
     &6.4274e-05_r8,8.1836e-05_r8,1.0238e-04_r8,1.2600e-04_r8,1.5256e-04_r8/)
      kbo(:,42, 6) = (/ &
     &4.9425e-05_r8,6.3242e-05_r8,7.9461e-05_r8,9.8197e-05_r8,1.1940e-04_r8/)
      kbo(:,43, 6) = (/ &
     &3.7393e-05_r8,4.8142e-05_r8,6.0818e-05_r8,7.5575e-05_r8,9.2337e-05_r8/)
      kbo(:,44, 6) = (/ &
     &2.8031e-05_r8,3.6364e-05_r8,4.6223e-05_r8,5.7754e-05_r8,7.0960e-05_r8/)
      kbo(:,45, 6) = (/ &
     &2.0952e-05_r8,2.7396e-05_r8,3.5050e-05_r8,4.4048e-05_r8,5.4413e-05_r8/)
      kbo(:,46, 6) = (/ &
     &1.5504e-05_r8,2.0469e-05_r8,2.6380e-05_r8,3.3353e-05_r8,4.1465e-05_r8/)
      kbo(:,47, 6) = (/ &
     &1.1285e-05_r8,1.5071e-05_r8,1.9596e-05_r8,2.4961e-05_r8,3.1243e-05_r8/)
      kbo(:,48, 6) = (/ &
     &8.1713e-06_r8,1.1048e-05_r8,1.4507e-05_r8,1.8626e-05_r8,2.3478e-05_r8/)
      kbo(:,49, 6) = (/ &
     &5.8892e-06_r8,8.0594e-06_r8,1.0700e-05_r8,1.3854e-05_r8,1.7591e-05_r8/)
      kbo(:,50, 6) = (/ &
     &4.2527e-06_r8,5.8989e-06_r8,7.9160e-06_r8,1.0341e-05_r8,1.3223e-05_r8/)
      kbo(:,51, 6) = (/ &
     &3.0672e-06_r8,4.3146e-06_r8,5.8537e-06_r8,7.7179e-06_r8,9.9420e-06_r8/)
      kbo(:,52, 6) = (/ &
     &2.1919e-06_r8,3.1415e-06_r8,4.3130e-06_r8,5.7435e-06_r8,7.4576e-06_r8/)
      kbo(:,53, 6) = (/ &
     &1.5489e-06_r8,2.2740e-06_r8,3.1638e-06_r8,4.2575e-06_r8,5.5767e-06_r8/)
      kbo(:,54, 6) = (/ &
     &1.1055e-06_r8,1.6569e-06_r8,2.3353e-06_r8,3.1738e-06_r8,4.1929e-06_r8/)
      kbo(:,55, 6) = (/ &
     &7.7959e-07_r8,1.2025e-06_r8,1.7241e-06_r8,2.3677e-06_r8,3.1567e-06_r8/)
      kbo(:,56, 6) = (/ &
     &5.5393e-07_r8,8.6666e-07_r8,1.2673e-06_r8,1.7619e-06_r8,2.3695e-06_r8/)
      kbo(:,57, 6) = (/ &
     &3.8362e-07_r8,6.2174e-07_r8,9.3002e-07_r8,1.3068e-06_r8,1.7740e-06_r8/)
      kbo(:,58, 6) = (/ &
     &2.6381e-07_r8,4.4330e-07_r8,6.7991e-07_r8,9.7066e-07_r8,1.3310e-06_r8/)
      kbo(:,59, 6) = (/ &
     &2.0120e-07_r8,3.4415e-07_r8,5.3237e-07_r8,7.6501e-07_r8,1.0533e-06_r8/)
      kbo(:,13, 7) = (/ &
     &1.9678e-02_r8,2.7339e-02_r8,3.6693e-02_r8,4.7583e-02_r8,5.9838e-02_r8/)
      kbo(:,14, 7) = (/ &
     &1.6855e-02_r8,2.3332e-02_r8,3.1200e-02_r8,4.0354e-02_r8,5.0549e-02_r8/)
      kbo(:,15, 7) = (/ &
     &1.4447e-02_r8,1.9926e-02_r8,2.6539e-02_r8,3.4203e-02_r8,4.2741e-02_r8/)
      kbo(:,16, 7) = (/ &
     &1.2375e-02_r8,1.7007e-02_r8,2.2570e-02_r8,2.9011e-02_r8,3.6155e-02_r8/)
      kbo(:,17, 7) = (/ &
     &1.0572e-02_r8,1.4480e-02_r8,1.9148e-02_r8,2.4557e-02_r8,3.0543e-02_r8/)
      kbo(:,18, 7) = (/ &
     &9.0187e-03_r8,1.2308e-02_r8,1.6230e-02_r8,2.0762e-02_r8,2.5754e-02_r8/)
      kbo(:,19, 7) = (/ &
     &7.6960e-03_r8,1.0462e-02_r8,1.3757e-02_r8,1.7553e-02_r8,2.1712e-02_r8/)
      kbo(:,20, 7) = (/ &
     &6.5947e-03_r8,8.9295e-03_r8,1.1707e-02_r8,1.4880e-02_r8,1.8332e-02_r8/)
      kbo(:,21, 7) = (/ &
     &5.6518e-03_r8,7.6362e-03_r8,9.9897e-03_r8,1.2646e-02_r8,1.5515e-02_r8/)
      kbo(:,22, 7) = (/ &
     &4.9551e-03_r8,6.6562e-03_r8,8.6611e-03_r8,1.0883e-02_r8,1.3285e-02_r8/)
      kbo(:,23, 7) = (/ &
     &4.3463e-03_r8,5.8019e-03_r8,7.4874e-03_r8,9.3424e-03_r8,1.1393e-02_r8/)
      kbo(:,24, 7) = (/ &
     &3.8088e-03_r8,5.0439e-03_r8,6.4617e-03_r8,8.0406e-03_r8,9.7631e-03_r8/)
      kbo(:,25, 7) = (/ &
     &3.3364e-03_r8,4.3855e-03_r8,5.5891e-03_r8,6.9199e-03_r8,8.3730e-03_r8/)
      kbo(:,26, 7) = (/ &
     &2.9302e-03_r8,3.8269e-03_r8,4.8484e-03_r8,5.9724e-03_r8,7.1930e-03_r8/)
      kbo(:,27, 7) = (/ &
     &2.5694e-03_r8,3.3414e-03_r8,4.2035e-03_r8,5.1445e-03_r8,6.1710e-03_r8/)
      kbo(:,28, 7) = (/ &
     &2.2557e-03_r8,2.9117e-03_r8,3.6362e-03_r8,4.4284e-03_r8,5.2859e-03_r8/)
      kbo(:,29, 7) = (/ &
     &1.9791e-03_r8,2.5337e-03_r8,3.1431e-03_r8,3.8083e-03_r8,4.5227e-03_r8/)
      kbo(:,30, 7) = (/ &
     &1.7348e-03_r8,2.2004e-03_r8,2.7128e-03_r8,3.2695e-03_r8,3.8671e-03_r8/)
      kbo(:,31, 7) = (/ &
     &1.5168e-03_r8,1.9090e-03_r8,2.3389e-03_r8,2.8042e-03_r8,3.3063e-03_r8/)
      kbo(:,32, 7) = (/ &
     &1.3245e-03_r8,1.6546e-03_r8,2.0148e-03_r8,2.4067e-03_r8,2.8256e-03_r8/)
      kbo(:,33, 7) = (/ &
     &1.1547e-03_r8,1.4322e-03_r8,1.7355e-03_r8,2.0639e-03_r8,2.4127e-03_r8/)
      kbo(:,34, 7) = (/ &
     &9.9732e-04_r8,1.2299e-03_r8,1.4851e-03_r8,1.7585e-03_r8,2.0486e-03_r8/)
      kbo(:,35, 7) = (/ &
     &8.4240e-04_r8,1.0365e-03_r8,1.2482e-03_r8,1.4745e-03_r8,1.7149e-03_r8/)
      kbo(:,36, 7) = (/ &
     &6.9459e-04_r8,8.5479e-04_r8,1.0290e-03_r8,1.2151e-03_r8,1.4131e-03_r8/)
      kbo(:,37, 7) = (/ &
     &5.5418e-04_r8,6.8431e-04_r8,8.2605e-04_r8,9.7772e-04_r8,1.1393e-03_r8/)
      kbo(:,38, 7) = (/ &
     &4.4103e-04_r8,5.4666e-04_r8,6.6164e-04_r8,7.8531e-04_r8,9.1717e-04_r8/)
      kbo(:,39, 7) = (/ &
     &3.5078e-04_r8,4.3647e-04_r8,5.2986e-04_r8,6.3056e-04_r8,7.3809e-04_r8/)
      kbo(:,40, 7) = (/ &
     &2.7223e-04_r8,3.4099e-04_r8,4.1623e-04_r8,4.9763e-04_r8,5.8479e-04_r8/)
      kbo(:,41, 7) = (/ &
     &2.1016e-04_r8,2.6529e-04_r8,3.2578e-04_r8,3.9146e-04_r8,4.6190e-04_r8/)
      kbo(:,42, 7) = (/ &
     &1.6186e-04_r8,2.0599e-04_r8,2.5454e-04_r8,3.0749e-04_r8,3.6441e-04_r8/)
      kbo(:,43, 7) = (/ &
     &1.2244e-04_r8,1.5755e-04_r8,1.9631e-04_r8,2.3871e-04_r8,2.8458e-04_r8/)
      kbo(:,44, 7) = (/ &
     &9.1656e-05_r8,1.1940e-04_r8,1.5021e-04_r8,1.8408e-04_r8,2.2084e-04_r8/)
      kbo(:,45, 7) = (/ &
     &6.8343e-05_r8,9.0130e-05_r8,1.1460e-04_r8,1.4155e-04_r8,1.7102e-04_r8/)
      kbo(:,46, 7) = (/ &
     &5.0438e-05_r8,6.7336e-05_r8,8.6692e-05_r8,1.0813e-04_r8,1.3160e-04_r8/)
      kbo(:,47, 7) = (/ &
     &3.6553e-05_r8,4.9462e-05_r8,6.4648e-05_r8,8.1563e-05_r8,1.0018e-04_r8/)
      kbo(:,48, 7) = (/ &
     &2.6343e-05_r8,3.6142e-05_r8,4.7933e-05_r8,6.1264e-05_r8,7.5986e-05_r8/)
      kbo(:,49, 7) = (/ &
     &1.8866e-05_r8,2.6263e-05_r8,3.5311e-05_r8,4.5778e-05_r8,5.7425e-05_r8/)
      kbo(:,50, 7) = (/ &
     &1.3557e-05_r8,1.9139e-05_r8,2.6064e-05_r8,3.4268e-05_r8,4.3473e-05_r8/)
      kbo(:,51, 7) = (/ &
     &9.7297e-06_r8,1.3926e-05_r8,1.9216e-05_r8,2.5597e-05_r8,3.2867e-05_r8/)
      kbo(:,52, 7) = (/ &
     &6.9563e-06_r8,1.0085e-05_r8,1.4103e-05_r8,1.9022e-05_r8,2.4754e-05_r8/)
      kbo(:,53, 7) = (/ &
     &4.9502e-06_r8,7.2644e-06_r8,1.0302e-05_r8,1.4070e-05_r8,1.8558e-05_r8/)
      kbo(:,54, 7) = (/ &
     &3.5499e-06_r8,5.2696e-06_r8,7.5685e-06_r8,1.0462e-05_r8,1.3965e-05_r8/)
      kbo(:,55, 7) = (/ &
     &2.5517e-06_r8,3.8332e-06_r8,5.5671e-06_r8,7.7870e-06_r8,1.0502e-05_r8/)
      kbo(:,56, 7) = (/ &
     &1.8250e-06_r8,2.7802e-06_r8,4.0807e-06_r8,5.7760e-06_r8,7.8765e-06_r8/)
      kbo(:,57, 7) = (/ &
     &1.3020e-06_r8,2.0096e-06_r8,2.9783e-06_r8,4.2688e-06_r8,5.8872e-06_r8/)
      kbo(:,58, 7) = (/ &
     &9.3216e-07_r8,1.4580e-06_r8,2.1842e-06_r8,3.1634e-06_r8,4.4097e-06_r8/)
      kbo(:,59, 7) = (/ &
     &7.2634e-07_r8,1.1405e-06_r8,1.7167e-06_r8,2.4950e-06_r8,3.4919e-06_r8/)
      kbo(:,13, 8) = (/ &
     &6.7703e-02_r8,9.1028e-02_r8,1.1838e-01_r8,1.4990e-01_r8,1.8559e-01_r8/)
      kbo(:,14, 8) = (/ &
     &5.8222e-02_r8,7.8007e-02_r8,1.0118e-01_r8,1.2784e-01_r8,1.5811e-01_r8/)
      kbo(:,15, 8) = (/ &
     &5.0069e-02_r8,6.6838e-02_r8,8.6469e-02_r8,1.0901e-01_r8,1.3468e-01_r8/)
      kbo(:,16, 8) = (/ &
     &4.3038e-02_r8,5.7247e-02_r8,7.3838e-02_r8,9.2876e-02_r8,1.1462e-01_r8/)
      kbo(:,17, 8) = (/ &
     &3.6905e-02_r8,4.8922e-02_r8,6.2921e-02_r8,7.8980e-02_r8,9.7249e-02_r8/)
      kbo(:,18, 8) = (/ &
     &3.1539e-02_r8,4.1670e-02_r8,5.3450e-02_r8,6.6951e-02_r8,8.2335e-02_r8/)
      kbo(:,19, 8) = (/ &
     &2.6840e-02_r8,3.5366e-02_r8,4.5264e-02_r8,5.6569e-02_r8,6.9496e-02_r8/)
      kbo(:,20, 8) = (/ &
     &2.2918e-02_r8,3.0090e-02_r8,3.8404e-02_r8,4.7928e-02_r8,5.8831e-02_r8/)
      kbo(:,21, 8) = (/ &
     &1.9556e-02_r8,2.5586e-02_r8,3.2570e-02_r8,4.0587e-02_r8,4.9753e-02_r8/)
      kbo(:,22, 8) = (/ &
     &1.6988e-02_r8,2.2111e-02_r8,2.8028e-02_r8,3.4852e-02_r8,4.2609e-02_r8/)
      kbo(:,23, 8) = (/ &
     &1.4811e-02_r8,1.9201e-02_r8,2.4269e-02_r8,3.0112e-02_r8,3.6663e-02_r8/)
      kbo(:,24, 8) = (/ &
     &1.2965e-02_r8,1.6745e-02_r8,2.1118e-02_r8,2.6093e-02_r8,3.1689e-02_r8/)
      kbo(:,25, 8) = (/ &
     &1.1393e-02_r8,1.4643e-02_r8,1.8383e-02_r8,2.2644e-02_r8,2.7400e-02_r8/)
      kbo(:,26, 8) = (/ &
     &1.0038e-02_r8,1.2830e-02_r8,1.6015e-02_r8,1.9632e-02_r8,2.3704e-02_r8/)
      kbo(:,27, 8) = (/ &
     &8.8123e-03_r8,1.1178e-02_r8,1.3890e-02_r8,1.6992e-02_r8,2.0492e-02_r8/)
      kbo(:,28, 8) = (/ &
     &7.6974e-03_r8,9.7127e-03_r8,1.2040e-02_r8,1.4716e-02_r8,1.7696e-02_r8/)
      kbo(:,29, 8) = (/ &
     &6.7206e-03_r8,8.4382e-03_r8,1.0458e-02_r8,1.2740e-02_r8,1.5282e-02_r8/)
      kbo(:,30, 8) = (/ &
     &5.8552e-03_r8,7.3524e-03_r8,9.0759e-03_r8,1.1022e-02_r8,1.3175e-02_r8/)
      kbo(:,31, 8) = (/ &
     &5.1145e-03_r8,6.3996e-03_r8,7.8758e-03_r8,9.5283e-03_r8,1.1351e-02_r8/)
      kbo(:,32, 8) = (/ &
     &4.4686e-03_r8,5.5753e-03_r8,6.8326e-03_r8,8.2331e-03_r8,9.7798e-03_r8/)
      kbo(:,33, 8) = (/ &
     &3.9075e-03_r8,4.8544e-03_r8,5.9240e-03_r8,7.1154e-03_r8,8.4216e-03_r8/)
      kbo(:,34, 8) = (/ &
     &3.3885e-03_r8,4.1943e-03_r8,5.1017e-03_r8,6.1096e-03_r8,7.2102e-03_r8/)
      kbo(:,35, 8) = (/ &
     &2.8755e-03_r8,3.5515e-03_r8,4.3142e-03_r8,5.1540e-03_r8,6.0867e-03_r8/)
      kbo(:,36, 8) = (/ &
     &2.3819e-03_r8,2.9429e-03_r8,3.5744e-03_r8,4.2743e-03_r8,5.0503e-03_r8/)
      kbo(:,37, 8) = (/ &
     &1.9080e-03_r8,2.3651e-03_r8,2.8794e-03_r8,3.4539e-03_r8,4.0906e-03_r8/)
      kbo(:,38, 8) = (/ &
     &1.5252e-03_r8,1.8961e-03_r8,2.3154e-03_r8,2.7875e-03_r8,3.3076e-03_r8/)
      kbo(:,39, 8) = (/ &
     &1.2186e-03_r8,1.5204e-03_r8,1.8625e-03_r8,2.2483e-03_r8,2.6746e-03_r8/)
      kbo(:,40, 8) = (/ &
     &9.5047e-04_r8,1.1919e-03_r8,1.4679e-03_r8,1.7800e-03_r8,2.1255e-03_r8/)
      kbo(:,41, 8) = (/ &
     &7.3797e-04_r8,9.3055e-04_r8,1.1523e-03_r8,1.4042e-03_r8,1.6837e-03_r8/)
      kbo(:,42, 8) = (/ &
     &5.7195e-04_r8,7.2531e-04_r8,9.0341e-04_r8,1.1062e-03_r8,1.3320e-03_r8/)
      kbo(:,43, 8) = (/ &
     &4.3632e-04_r8,5.5716e-04_r8,6.9866e-04_r8,8.6074e-04_r8,1.0421e-03_r8/)
      kbo(:,44, 8) = (/ &
     &3.2967e-04_r8,4.2439e-04_r8,5.3607e-04_r8,6.6494e-04_r8,8.0995e-04_r8/)
      kbo(:,45, 8) = (/ &
     &2.4830e-04_r8,3.2230e-04_r8,4.1025e-04_r8,5.1229e-04_r8,6.2794e-04_r8/)
      kbo(:,46, 8) = (/ &
     &1.8517e-04_r8,2.4270e-04_r8,3.1143e-04_r8,3.9189e-04_r8,4.8363e-04_r8/)
      kbo(:,47, 8) = (/ &
     &1.3585e-04_r8,1.8008e-04_r8,2.3317e-04_r8,2.9603e-04_r8,3.6826e-04_r8/)
      kbo(:,48, 8) = (/ &
     &9.9135e-05_r8,1.3301e-04_r8,1.7388e-04_r8,2.2278e-04_r8,2.7947e-04_r8/)
      kbo(:,49, 8) = (/ &
     &7.1904e-05_r8,9.7733e-05_r8,1.2918e-04_r8,1.6699e-04_r8,2.1129e-04_r8/)
      kbo(:,50, 8) = (/ &
     &5.2307e-05_r8,7.2019e-05_r8,9.6216e-05_r8,1.2554e-04_r8,1.6020e-04_r8/)
      kbo(:,51, 8) = (/ &
     &3.7969e-05_r8,5.2997e-05_r8,7.1620e-05_r8,9.4315e-05_r8,1.2143e-04_r8/)
      kbo(:,52, 8) = (/ &
     &2.7413e-05_r8,3.8825e-05_r8,5.3093e-05_r8,7.0665e-05_r8,9.1720e-05_r8/)
      kbo(:,53, 8) = (/ &
     &1.9654e-05_r8,2.8289e-05_r8,3.9179e-05_r8,5.2708e-05_r8,6.9024e-05_r8/)
      kbo(:,54, 8) = (/ &
     &1.4176e-05_r8,2.0734e-05_r8,2.9077e-05_r8,3.9534e-05_r8,5.2234e-05_r8/)
      kbo(:,55, 8) = (/ &
     &1.0223e-05_r8,1.5194e-05_r8,2.1592e-05_r8,2.9664e-05_r8,3.9585e-05_r8/)
      kbo(:,56, 8) = (/ &
     &7.3305e-06_r8,1.1089e-05_r8,1.5976e-05_r8,2.2196e-05_r8,2.9906e-05_r8/)
      kbo(:,57, 8) = (/ &
     &5.2231e-06_r8,8.0475e-06_r8,1.1769e-05_r8,1.6548e-05_r8,2.2524e-05_r8/)
      kbo(:,58, 8) = (/ &
     &3.7230e-06_r8,5.8489e-06_r8,8.6848e-06_r8,1.2363e-05_r8,1.6999e-05_r8/)
      kbo(:,59, 8) = (/ &
     &2.8893e-06_r8,4.5778e-06_r8,6.8447e-06_r8,9.7955e-06_r8,1.3534e-05_r8/)
      kbo(:,13, 9) = (/ &
     &4.1576e-01_r8,5.6459e-01_r8,7.4208e-01_r8,9.4959e-01_r8,1.1894e+00_r8/)
      kbo(:,14, 9) = (/ &
     &3.6259e-01_r8,4.8996e-01_r8,6.4236e-01_r8,8.2178e-01_r8,1.0273e+00_r8/)
      kbo(:,15, 9) = (/ &
     &3.1572e-01_r8,4.2505e-01_r8,5.5650e-01_r8,7.1044e-01_r8,8.8534e-01_r8/)
      kbo(:,16, 9) = (/ &
     &2.7461e-01_r8,3.6869e-01_r8,4.8148e-01_r8,6.1276e-01_r8,7.6136e-01_r8/)
      kbo(:,17, 9) = (/ &
     &2.3842e-01_r8,3.1920e-01_r8,4.1566e-01_r8,5.2724e-01_r8,6.5339e-01_r8/)
      kbo(:,18, 9) = (/ &
     &2.0643e-01_r8,2.7580e-01_r8,3.5808e-01_r8,4.5284e-01_r8,5.5957e-01_r8/)
      kbo(:,19, 9) = (/ &
     &1.7844e-01_r8,2.3768e-01_r8,3.0746e-01_r8,3.8778e-01_r8,4.7826e-01_r8/)
      kbo(:,20, 9) = (/ &
     &1.5457e-01_r8,2.0515e-01_r8,2.6455e-01_r8,3.3275e-01_r8,4.0945e-01_r8/)
      kbo(:,21, 9) = (/ &
     &1.3372e-01_r8,1.7673e-01_r8,2.2718e-01_r8,2.8500e-01_r8,3.5014e-01_r8/)
      kbo(:,22, 9) = (/ &
     &1.1755e-01_r8,1.5455e-01_r8,1.9772e-01_r8,2.4719e-01_r8,3.0287e-01_r8/)
      kbo(:,23, 9) = (/ &
     &1.0319e-01_r8,1.3488e-01_r8,1.7188e-01_r8,2.1417e-01_r8,2.6161e-01_r8/)
      kbo(:,24, 9) = (/ &
     &9.0543e-02_r8,1.1778e-01_r8,1.4943e-01_r8,1.8553e-01_r8,2.2596e-01_r8/)
      kbo(:,25, 9) = (/ &
     &7.9491e-02_r8,1.0285e-01_r8,1.2998e-01_r8,1.6082e-01_r8,1.9540e-01_r8/)
      kbo(:,26, 9) = (/ &
     &7.0023e-02_r8,9.0152e-02_r8,1.1342e-01_r8,1.3988e-01_r8,1.6957e-01_r8/)
      kbo(:,27, 9) = (/ &
     &6.1675e-02_r8,7.9028e-02_r8,9.9049e-02_r8,1.2176e-01_r8,1.4715e-01_r8/)
      kbo(:,28, 9) = (/ &
     &5.4332e-02_r8,6.9290e-02_r8,8.6538e-02_r8,1.0602e-01_r8,1.2768e-01_r8/)
      kbo(:,29, 9) = (/ &
     &4.8016e-02_r8,6.0968e-02_r8,7.5734e-02_r8,9.2386e-02_r8,1.1090e-01_r8/)
      kbo(:,30, 9) = (/ &
     &4.2494e-02_r8,5.3680e-02_r8,6.6413e-02_r8,8.0729e-02_r8,9.6539e-02_r8/)
      kbo(:,31, 9) = (/ &
     &3.7548e-02_r8,4.7237e-02_r8,5.8255e-02_r8,7.0556e-02_r8,8.4102e-02_r8/)
      kbo(:,32, 9) = (/ &
     &3.3189e-02_r8,4.1551e-02_r8,5.1044e-02_r8,6.1646e-02_r8,7.3306e-02_r8/)
      kbo(:,33, 9) = (/ &
     &2.9274e-02_r8,3.6514e-02_r8,4.4704e-02_r8,5.3824e-02_r8,6.3833e-02_r8/)
      kbo(:,34, 9) = (/ &
     &2.5627e-02_r8,3.1864e-02_r8,3.8903e-02_r8,4.6747e-02_r8,5.5596e-02_r8/)
      kbo(:,35, 9) = (/ &
     &2.1952e-02_r8,2.7259e-02_r8,3.3247e-02_r8,4.0073e-02_r8,4.7679e-02_r8/)
      kbo(:,36, 9) = (/ &
     &1.8347e-02_r8,2.2808e-02_r8,2.7904e-02_r8,3.3738e-02_r8,4.0178e-02_r8/)
      kbo(:,37, 9) = (/ &
     &1.4833e-02_r8,1.8504e-02_r8,2.2807e-02_r8,2.7664e-02_r8,3.3111e-02_r8/)
      kbo(:,38, 9) = (/ &
     &1.1957e-02_r8,1.5000e-02_r8,1.8592e-02_r8,2.2638e-02_r8,2.7241e-02_r8/)
      kbo(:,39, 9) = (/ &
     &9.6263e-03_r8,1.2169e-02_r8,1.5133e-02_r8,1.8540e-02_r8,2.2409e-02_r8/)
      kbo(:,40, 9) = (/ &
     &7.5755e-03_r8,9.6595e-03_r8,1.2095e-02_r8,1.4919e-02_r8,1.8126e-02_r8/)
      kbo(:,41, 9) = (/ &
     &5.9308e-03_r8,7.6313e-03_r8,9.6291e-03_r8,1.1965e-02_r8,1.4606e-02_r8/)
      kbo(:,42, 9) = (/ &
     &4.6365e-03_r8,6.0158e-03_r8,7.6539e-03_r8,9.5769e-03_r8,1.1776e-02_r8/)
      kbo(:,43, 9) = (/ &
     &3.5646e-03_r8,4.6692e-03_r8,5.9951e-03_r8,7.5584e-03_r8,9.3611e-03_r8/)
      kbo(:,44, 9) = (/ &
     &2.7083e-03_r8,3.5831e-03_r8,4.6545e-03_r8,5.9178e-03_r8,7.3883e-03_r8/)
      kbo(:,45, 9) = (/ &
     &2.0498e-03_r8,2.7405e-03_r8,3.5962e-03_r8,4.6175e-03_r8,5.8123e-03_r8/)
      kbo(:,46, 9) = (/ &
     &1.5335e-03_r8,2.0746e-03_r8,2.7520e-03_r8,3.5687e-03_r8,4.5390e-03_r8/)
      kbo(:,47, 9) = (/ &
     &1.1263e-03_r8,1.5445e-03_r8,2.0740e-03_r8,2.7200e-03_r8,3.4958e-03_r8/)
      kbo(:,48, 9) = (/ &
     &8.2184e-04_r8,1.1429e-03_r8,1.5538e-03_r8,2.0625e-03_r8,2.6781e-03_r8/)
      kbo(:,49, 9) = (/ &
     &5.9594e-04_r8,8.3975e-04_r8,1.1570e-03_r8,1.5542e-03_r8,2.0406e-03_r8/)
      kbo(:,50, 9) = (/ &
     &4.3385e-04_r8,6.1951e-04_r8,8.6528e-04_r8,1.1761e-03_r8,1.5615e-03_r8/)
      kbo(:,51, 9) = (/ &
     &3.1545e-04_r8,4.5652e-04_r8,6.4640e-04_r8,8.8983e-04_r8,1.1948e-03_r8/)
      kbo(:,52, 9) = (/ &
     &2.2788e-04_r8,3.3444e-04_r8,4.7984e-04_r8,6.6976e-04_r8,9.1050e-04_r8/)
      kbo(:,53, 9) = (/ &
     &1.6338e-04_r8,2.4338e-04_r8,3.5401e-04_r8,5.0057e-04_r8,6.8907e-04_r8/)
      kbo(:,54, 9) = (/ &
     &1.1823e-04_r8,1.7879e-04_r8,2.6356e-04_r8,3.7767e-04_r8,5.2615e-04_r8/)
      kbo(:,55, 9) = (/ &
     &8.5773e-05_r8,1.3160e-04_r8,1.9666e-04_r8,2.8549e-04_r8,4.0286e-04_r8/)
      kbo(:,56, 9) = (/ &
     &6.1815e-05_r8,9.6294e-05_r8,1.4602e-04_r8,2.1495e-04_r8,3.0724e-04_r8/)
      kbo(:,57, 9) = (/ &
     &4.4282e-05_r8,7.0071e-05_r8,1.0785e-04_r8,1.6097e-04_r8,2.3304e-04_r8/)
      kbo(:,58, 9) = (/ &
     &3.1779e-05_r8,5.1099e-05_r8,7.9795e-05_r8,1.2084e-04_r8,1.7730e-04_r8/)
      kbo(:,59, 9) = (/ &
     &2.4962e-05_r8,4.0511e-05_r8,6.3843e-05_r8,9.7519e-05_r8,1.4426e-04_r8/)
      kbo(:,13,10) = (/ &
     &1.8139e+00_r8,2.4724e+00_r8,3.2908e+00_r8,4.2191e+00_r8,5.2351e+00_r8/)
      kbo(:,14,10) = (/ &
     &1.6219e+00_r8,2.2181e+00_r8,2.9298e+00_r8,3.7301e+00_r8,4.6329e+00_r8/)
      kbo(:,15,10) = (/ &
     &1.4445e+00_r8,1.9645e+00_r8,2.5717e+00_r8,3.2739e+00_r8,4.0834e+00_r8/)
      kbo(:,16,10) = (/ &
     &1.2756e+00_r8,1.7196e+00_r8,2.2454e+00_r8,2.8649e+00_r8,3.5710e+00_r8/)
      kbo(:,17,10) = (/ &
     &1.1121e+00_r8,1.4934e+00_r8,1.9517e+00_r8,2.4879e+00_r8,3.0883e+00_r8/)
      kbo(:,18,10) = (/ &
     &9.6871e-01_r8,1.2953e+00_r8,1.6900e+00_r8,2.1475e+00_r8,2.6630e+00_r8/)
      kbo(:,19,10) = (/ &
     &8.4238e-01_r8,1.1243e+00_r8,1.4633e+00_r8,1.8537e+00_r8,2.2906e+00_r8/)
      kbo(:,20,10) = (/ &
     &7.3459e-01_r8,9.7958e-01_r8,1.2711e+00_r8,1.6026e+00_r8,1.9721e+00_r8/)
      kbo(:,21,10) = (/ &
     &6.4101e-01_r8,8.5278e-01_r8,1.0998e+00_r8,1.3825e+00_r8,1.6970e+00_r8/)
      kbo(:,22,10) = (/ &
     &5.6942e-01_r8,7.5220e-01_r8,9.6596e-01_r8,1.2079e+00_r8,1.4762e+00_r8/)
      kbo(:,23,10) = (/ &
     &5.0503e-01_r8,6.6296e-01_r8,8.4599e-01_r8,1.0531e+00_r8,1.2851e+00_r8/)
      kbo(:,24,10) = (/ &
     &4.4682e-01_r8,5.8292e-01_r8,7.4005e-01_r8,9.1863e-01_r8,1.1187e+00_r8/)
      kbo(:,25,10) = (/ &
     &3.9593e-01_r8,5.1361e-01_r8,6.4951e-01_r8,8.0398e-01_r8,9.7427e-01_r8/)
      kbo(:,26,10) = (/ &
     &3.5212e-01_r8,4.5450e-01_r8,5.7266e-01_r8,7.0571e-01_r8,8.5181e-01_r8/)
      kbo(:,27,10) = (/ &
     &3.1284e-01_r8,4.0173e-01_r8,5.0408e-01_r8,6.1838e-01_r8,7.4572e-01_r8/)
      kbo(:,28,10) = (/ &
     &2.7721e-01_r8,3.5447e-01_r8,4.4231e-01_r8,5.4145e-01_r8,6.5404e-01_r8/)
      kbo(:,29,10) = (/ &
     &2.4517e-01_r8,3.1175e-01_r8,3.8832e-01_r8,4.7588e-01_r8,5.7437e-01_r8/)
      kbo(:,30,10) = (/ &
     &2.1578e-01_r8,2.7344e-01_r8,3.4039e-01_r8,4.1657e-01_r8,5.0271e-01_r8/)
      kbo(:,31,10) = (/ &
     &1.9067e-01_r8,2.4099e-01_r8,2.9914e-01_r8,3.6552e-01_r8,4.4046e-01_r8/)
      kbo(:,32,10) = (/ &
     &1.6874e-01_r8,2.1279e-01_r8,2.6352e-01_r8,3.2154e-01_r8,3.8678e-01_r8/)
      kbo(:,33,10) = (/ &
     &1.4979e-01_r8,1.8828e-01_r8,2.3277e-01_r8,2.8345e-01_r8,3.4103e-01_r8/)
      kbo(:,34,10) = (/ &
     &1.3170e-01_r8,1.6528e-01_r8,2.0425e-01_r8,2.4841e-01_r8,2.9642e-01_r8/)
      kbo(:,35,10) = (/ &
     &1.1324e-01_r8,1.4235e-01_r8,1.7590e-01_r8,2.1287e-01_r8,2.5375e-01_r8/)
      kbo(:,36,10) = (/ &
     &9.5231e-02_r8,1.1973e-01_r8,1.4778e-01_r8,1.7871e-01_r8,2.1338e-01_r8/)
      kbo(:,37,10) = (/ &
     &7.7445e-02_r8,9.7552e-02_r8,1.1991e-01_r8,1.4578e-01_r8,1.7559e-01_r8/)
      kbo(:,38,10) = (/ &
     &6.2913e-02_r8,7.9354e-02_r8,9.7396e-02_r8,1.1872e-01_r8,1.4502e-01_r8/)
      kbo(:,39,10) = (/ &
     &5.1069e-02_r8,6.4406e-02_r8,7.9431e-02_r8,9.7751e-02_r8,1.1994e-01_r8/)
      kbo(:,40,10) = (/ &
     &4.0487e-02_r8,5.1192e-02_r8,6.3494e-02_r8,7.8782e-02_r8,9.6672e-02_r8/)
      kbo(:,41,10) = (/ &
     &3.1933e-02_r8,4.0574e-02_r8,5.0815e-02_r8,6.3454e-02_r8,7.7908e-02_r8/)
      kbo(:,42,10) = (/ &
     &2.5104e-02_r8,3.2117e-02_r8,4.0690e-02_r8,5.1132e-02_r8,6.3360e-02_r8/)
      kbo(:,43,10) = (/ &
     &1.9359e-02_r8,2.4985e-02_r8,3.2134e-02_r8,4.0672e-02_r8,5.0944e-02_r8/)
      kbo(:,44,10) = (/ &
     &1.4822e-02_r8,1.9377e-02_r8,2.5087e-02_r8,3.2083e-02_r8,4.0842e-02_r8/)
      kbo(:,45,10) = (/ &
     &1.1292e-02_r8,1.4912e-02_r8,1.9592e-02_r8,2.5310e-02_r8,3.2495e-02_r8/)
      kbo(:,46,10) = (/ &
     &8.5215e-03_r8,1.1374e-02_r8,1.5134e-02_r8,1.9829e-02_r8,2.5701e-02_r8/)
      kbo(:,47,10) = (/ &
     &6.3304e-03_r8,8.5539e-03_r8,1.1519e-02_r8,1.5304e-02_r8,2.0043e-02_r8/)
      kbo(:,48,10) = (/ &
     &4.6596e-03_r8,6.3842e-03_r8,8.7184e-03_r8,1.1727e-02_r8,1.5575e-02_r8/)
      kbo(:,49,10) = (/ &
     &3.3978e-03_r8,4.7268e-03_r8,6.5354e-03_r8,8.9194e-03_r8,1.1986e-02_r8/)
      kbo(:,50,10) = (/ &
     &2.4889e-03_r8,3.5204e-03_r8,4.9247e-03_r8,6.8240e-03_r8,9.2921e-03_r8/)
      kbo(:,51,10) = (/ &
     &1.8182e-03_r8,2.6209e-03_r8,3.7132e-03_r8,5.2128e-03_r8,7.2010e-03_r8/)
      kbo(:,52,10) = (/ &
     &1.3186e-03_r8,1.9376e-03_r8,2.7823e-03_r8,3.9639e-03_r8,5.5462e-03_r8/)
      kbo(:,53,10) = (/ &
     &9.4728e-04_r8,1.4218e-03_r8,2.0704e-03_r8,2.9919e-03_r8,4.2442e-03_r8/)
      kbo(:,54,10) = (/ &
     &6.9069e-04_r8,1.0561e-03_r8,1.5627e-03_r8,2.2955e-03_r8,3.3049e-03_r8/)
      kbo(:,55,10) = (/ &
     &5.0377e-04_r8,7.8848e-04_r8,1.1876e-03_r8,1.7754e-03_r8,2.5917e-03_r8/)
      kbo(:,56,10) = (/ &
     &3.6627e-04_r8,5.8682e-04_r8,8.9763e-04_r8,1.3649e-03_r8,2.0311e-03_r8/)
      kbo(:,57,10) = (/ &
     &2.6429e-04_r8,4.3296e-04_r8,6.7428e-04_r8,1.0407e-03_r8,1.5759e-03_r8/)
      kbo(:,58,10) = (/ &
     &1.9120e-04_r8,3.1987e-04_r8,5.0621e-04_r8,7.9436e-04_r8,1.2215e-03_r8/)
      kbo(:,59,10) = (/ &
     &1.5379e-04_r8,2.5891e-04_r8,4.1558e-04_r8,6.6123e-04_r8,1.0327e-03_r8/)
      kbo(:,13,11) = (/ &
     &3.3861e+00_r8,4.5598e+00_r8,5.9909e+00_r8,7.7387e+00_r8,9.7720e+00_r8/)
      kbo(:,14,11) = (/ &
     &3.0835e+00_r8,4.1638e+00_r8,5.4907e+00_r8,7.0868e+00_r8,8.8764e+00_r8/)
      kbo(:,15,11) = (/ &
     &2.7946e+00_r8,3.7805e+00_r8,4.9918e+00_r8,6.3780e+00_r8,7.9256e+00_r8/)
      kbo(:,16,11) = (/ &
     &2.5106e+00_r8,3.4021e+00_r8,4.4602e+00_r8,5.6582e+00_r8,7.0321e+00_r8/)
      kbo(:,17,11) = (/ &
     &2.2366e+00_r8,3.0111e+00_r8,3.9217e+00_r8,4.9755e+00_r8,6.2040e+00_r8/)
      kbo(:,18,11) = (/ &
     &1.9672e+00_r8,2.6349e+00_r8,3.4220e+00_r8,4.3497e+00_r8,5.4155e+00_r8/)
      kbo(:,19,11) = (/ &
     &1.7131e+00_r8,2.2896e+00_r8,2.9754e+00_r8,3.7775e+00_r8,4.6830e+00_r8/)
      kbo(:,20,11) = (/ &
     &1.4996e+00_r8,1.9951e+00_r8,2.5864e+00_r8,3.2729e+00_r8,4.0503e+00_r8/)
      kbo(:,21,11) = (/ &
     &1.3113e+00_r8,1.7407e+00_r8,2.2502e+00_r8,2.8371e+00_r8,3.4967e+00_r8/)
      kbo(:,22,11) = (/ &
     &1.1682e+00_r8,1.5452e+00_r8,1.9872e+00_r8,2.4911e+00_r8,3.0547e+00_r8/)
      kbo(:,23,11) = (/ &
     &1.0421e+00_r8,1.3707e+00_r8,1.7516e+00_r8,2.1846e+00_r8,2.6659e+00_r8/)
      kbo(:,24,11) = (/ &
     &9.2979e-01_r8,1.2143e+00_r8,1.5435e+00_r8,1.9148e+00_r8,2.3275e+00_r8/)
      kbo(:,25,11) = (/ &
     &8.2875e-01_r8,1.0753e+00_r8,1.3588e+00_r8,1.6784e+00_r8,2.0353e+00_r8/)
      kbo(:,26,11) = (/ &
     &7.3934e-01_r8,9.5318e-01_r8,1.1984e+00_r8,1.4754e+00_r8,1.7853e+00_r8/)
      kbo(:,27,11) = (/ &
     &6.5883e-01_r8,8.4429e-01_r8,1.0568e+00_r8,1.2987e+00_r8,1.5650e+00_r8/)
      kbo(:,28,11) = (/ &
     &5.8647e-01_r8,7.4845e-01_r8,9.3430e-01_r8,1.1424e+00_r8,1.3714e+00_r8/)
      kbo(:,29,11) = (/ &
     &5.2333e-01_r8,6.6481e-01_r8,8.2647e-01_r8,1.0068e+00_r8,1.2071e+00_r8/)
      kbo(:,30,11) = (/ &
     &4.6646e-01_r8,5.9039e-01_r8,7.3092e-01_r8,8.8855e-01_r8,1.0662e+00_r8/)
      kbo(:,31,11) = (/ &
     &4.1617e-01_r8,5.2426e-01_r8,6.4699e-01_r8,7.8730e-01_r8,9.4645e-01_r8/)
      kbo(:,32,11) = (/ &
     &3.7143e-01_r8,4.6600e-01_r8,5.7506e-01_r8,6.9984e-01_r8,8.4024e-01_r8/)
      kbo(:,33,11) = (/ &
     &3.3164e-01_r8,4.1539e-01_r8,5.1227e-01_r8,6.2282e-01_r8,7.4734e-01_r8/)
      kbo(:,34,11) = (/ &
     &2.9391e-01_r8,3.6839e-01_r8,4.5381e-01_r8,5.5129e-01_r8,6.6077e-01_r8/)
      kbo(:,35,11) = (/ &
     &2.5539e-01_r8,3.2000e-01_r8,3.9467e-01_r8,4.7981e-01_r8,5.7557e-01_r8/)
      kbo(:,36,11) = (/ &
     &2.1634e-01_r8,2.7190e-01_r8,3.3604e-01_r8,4.0953e-01_r8,4.9314e-01_r8/)
      kbo(:,37,11) = (/ &
     &1.7643e-01_r8,2.2324e-01_r8,2.7784e-01_r8,3.4019e-01_r8,4.0996e-01_r8/)
      kbo(:,38,11) = (/ &
     &1.4359e-01_r8,1.8284e-01_r8,2.2947e-01_r8,2.8247e-01_r8,3.3992e-01_r8/)
      kbo(:,39,11) = (/ &
     &1.1703e-01_r8,1.4999e-01_r8,1.8946e-01_r8,2.3346e-01_r8,2.8235e-01_r8/)
      kbo(:,40,11) = (/ &
     &9.2508e-02_r8,1.1962e-01_r8,1.5225e-01_r8,1.8852e-01_r8,2.3037e-01_r8/)
      kbo(:,41,11) = (/ &
     &7.2812e-02_r8,9.4920e-02_r8,1.2149e-01_r8,1.5155e-01_r8,1.8718e-01_r8/)
      kbo(:,42,11) = (/ &
     &5.7212e-02_r8,7.5261e-02_r8,9.6717e-02_r8,1.2163e-01_r8,1.5109e-01_r8/)
      kbo(:,43,11) = (/ &
     &4.4118e-02_r8,5.8641e-02_r8,7.5812e-02_r8,9.6186e-02_r8,1.2035e-01_r8/)
      kbo(:,44,11) = (/ &
     &3.3705e-02_r8,4.5203e-02_r8,5.8991e-02_r8,7.5535e-02_r8,9.5312e-02_r8/)
      kbo(:,45,11) = (/ &
     &2.5795e-02_r8,3.4826e-02_r8,4.5764e-02_r8,5.9102e-02_r8,7.5973e-02_r8/)
      kbo(:,46,11) = (/ &
     &1.9500e-02_r8,2.6666e-02_r8,3.5264e-02_r8,4.5887e-02_r8,6.0050e-02_r8/)
      kbo(:,47,11) = (/ &
     &1.4478e-02_r8,2.0069e-02_r8,2.6758e-02_r8,3.5119e-02_r8,4.6750e-02_r8/)
      kbo(:,48,11) = (/ &
     &1.0673e-02_r8,1.5022e-02_r8,2.0274e-02_r8,2.6837e-02_r8,3.6213e-02_r8/)
      kbo(:,49,11) = (/ &
     &7.8044e-03_r8,1.1183e-02_r8,1.5301e-02_r8,2.0457e-02_r8,2.8037e-02_r8/)
      kbo(:,50,11) = (/ &
     &5.7286e-03_r8,8.3541e-03_r8,1.1590e-02_r8,1.5692e-02_r8,2.1700e-02_r8/)
      kbo(:,51,11) = (/ &
     &4.2038e-03_r8,6.2320e-03_r8,8.7867e-03_r8,1.2044e-02_r8,1.6737e-02_r8/)
      kbo(:,52,11) = (/ &
     &3.0623e-03_r8,4.6247e-03_r8,6.6271e-03_r8,9.2102e-03_r8,1.2933e-02_r8/)
      kbo(:,53,11) = (/ &
     &2.2163e-03_r8,3.3976e-03_r8,4.9642e-03_r8,7.0028e-03_r8,9.9664e-03_r8/)
      kbo(:,54,11) = (/ &
     &1.6196e-03_r8,2.5242e-03_r8,3.7641e-03_r8,5.3709e-03_r8,7.7537e-03_r8/)
      kbo(:,55,11) = (/ &
     &1.1913e-03_r8,1.8900e-03_r8,2.8670e-03_r8,4.1465e-03_r8,6.0719e-03_r8/)
      kbo(:,56,11) = (/ &
     &8.6854e-04_r8,1.4072e-03_r8,2.1797e-03_r8,3.2039e-03_r8,4.7482e-03_r8/)
      kbo(:,57,11) = (/ &
     &6.2940e-04_r8,1.0423e-03_r8,1.6521e-03_r8,2.4738e-03_r8,3.7243e-03_r8/)
      kbo(:,58,11) = (/ &
     &4.5766e-04_r8,7.7541e-04_r8,1.2578e-03_r8,1.9222e-03_r8,2.9509e-03_r8/)
      kbo(:,59,11) = (/ &
     &3.7158e-04_r8,6.4512e-04_r8,1.0666e-03_r8,1.6673e-03_r8,2.6085e-03_r8/)
      kbo(:,13,12) = (/ &
     &6.8265e+00_r8,9.1662e+00_r8,1.2005e+01_r8,1.5291e+01_r8,1.9104e+01_r8/)
      kbo(:,14,12) = (/ &
     &6.4505e+00_r8,8.6663e+00_r8,1.1302e+01_r8,1.4372e+01_r8,1.8022e+01_r8/)
      kbo(:,15,12) = (/ &
     &6.0333e+00_r8,8.0721e+00_r8,1.0531e+01_r8,1.3476e+01_r8,1.6920e+01_r8/)
      kbo(:,16,12) = (/ &
     &5.5683e+00_r8,7.4562e+00_r8,9.7508e+00_r8,1.2490e+01_r8,1.5606e+01_r8/)
      kbo(:,17,12) = (/ &
     &5.0713e+00_r8,6.8025e+00_r8,8.9065e+00_r8,1.1361e+01_r8,1.4093e+01_r8/)
      kbo(:,18,12) = (/ &
     &4.5774e+00_r8,6.1450e+00_r8,8.0133e+00_r8,1.0144e+01_r8,1.2548e+01_r8/)
      kbo(:,19,12) = (/ &
     &4.0864e+00_r8,5.4694e+00_r8,7.0931e+00_r8,8.9659e+00_r8,1.1117e+01_r8/)
      kbo(:,20,12) = (/ &
     &3.6294e+00_r8,4.8248e+00_r8,6.2421e+00_r8,7.9048e+00_r8,9.7882e+00_r8/)
      kbo(:,21,12) = (/ &
     &3.1876e+00_r8,4.2266e+00_r8,5.4689e+00_r8,6.9148e+00_r8,8.5415e+00_r8/)
      kbo(:,22,12) = (/ &
     &2.8446e+00_r8,3.7580e+00_r8,4.8472e+00_r8,6.1036e+00_r8,7.5044e+00_r8/)
      kbo(:,23,12) = (/ &
     &2.5375e+00_r8,3.3389e+00_r8,4.2884e+00_r8,5.3709e+00_r8,6.5794e+00_r8/)
      kbo(:,24,12) = (/ &
     &2.2687e+00_r8,2.9742e+00_r8,3.7979e+00_r8,4.7327e+00_r8,5.7691e+00_r8/)
      kbo(:,25,12) = (/ &
     &2.0354e+00_r8,2.6539e+00_r8,3.3704e+00_r8,4.1780e+00_r8,5.0680e+00_r8/)
      kbo(:,26,12) = (/ &
     &1.8347e+00_r8,2.3795e+00_r8,3.0035e+00_r8,3.7009e+00_r8,4.4678e+00_r8/)
      kbo(:,27,12) = (/ &
     &1.6539e+00_r8,2.1288e+00_r8,2.6709e+00_r8,3.2754e+00_r8,3.9447e+00_r8/)
      kbo(:,28,12) = (/ &
     &1.4848e+00_r8,1.8995e+00_r8,2.3700e+00_r8,2.8962e+00_r8,3.4805e+00_r8/)
      kbo(:,29,12) = (/ &
     &1.3323e+00_r8,1.6945e+00_r8,2.1064e+00_r8,2.5664e+00_r8,3.0755e+00_r8/)
      kbo(:,30,12) = (/ &
     &1.1951e+00_r8,1.5124e+00_r8,1.8729e+00_r8,2.2771e+00_r8,2.7207e+00_r8/)
      kbo(:,31,12) = (/ &
     &1.0723e+00_r8,1.3520e+00_r8,1.6707e+00_r8,2.0245e+00_r8,2.4134e+00_r8/)
      kbo(:,32,12) = (/ &
     &9.6436e-01_r8,1.2123e+00_r8,1.4924e+00_r8,1.8027e+00_r8,2.1488e+00_r8/)
      kbo(:,33,12) = (/ &
     &8.6875e-01_r8,1.0883e+00_r8,1.3350e+00_r8,1.6111e+00_r8,1.9241e+00_r8/)
      kbo(:,34,12) = (/ &
     &7.7744e-01_r8,9.7074e-01_r8,1.1897e+00_r8,1.4382e+00_r8,1.7216e+00_r8/)
      kbo(:,35,12) = (/ &
     &6.8108e-01_r8,8.5081e-01_r8,1.0447e+00_r8,1.2673e+00_r8,1.5231e+00_r8/)
      kbo(:,36,12) = (/ &
     &5.8251e-01_r8,7.3036e-01_r8,9.0117e-01_r8,1.0985e+00_r8,1.3262e+00_r8/)
      kbo(:,37,12) = (/ &
     &4.8147e-01_r8,6.0751e-01_r8,7.5487e-01_r8,9.2714e-01_r8,1.1257e+00_r8/)
      kbo(:,38,12) = (/ &
     &3.9749e-01_r8,5.0467e-01_r8,6.3154e-01_r8,7.8124e-01_r8,9.5438e-01_r8/)
      kbo(:,39,12) = (/ &
     &3.2829e-01_r8,4.1995e-01_r8,5.2901e-01_r8,6.5861e-01_r8,8.0986e-01_r8/)
      kbo(:,40,12) = (/ &
     &2.6399e-01_r8,3.4098e-01_r8,4.3333e-01_r8,5.4338e-01_r8,6.7333e-01_r8/)
      kbo(:,41,12) = (/ &
     &2.1121e-01_r8,2.7554e-01_r8,3.5340e-01_r8,4.4699e-01_r8,5.5819e-01_r8/)
      kbo(:,42,12) = (/ &
     &1.6875e-01_r8,2.2242e-01_r8,2.8790e-01_r8,3.6718e-01_r8,4.6248e-01_r8/)
      kbo(:,43,12) = (/ &
     &1.3242e-01_r8,1.7649e-01_r8,2.3091e-01_r8,2.9729e-01_r8,3.7802e-01_r8/)
      kbo(:,44,12) = (/ &
     &1.0268e-01_r8,1.3874e-01_r8,1.8350e-01_r8,2.3873e-01_r8,3.0615e-01_r8/)
      kbo(:,45,12) = (/ &
     &7.9157e-02_r8,1.0857e-01_r8,1.4543e-01_r8,1.9132e-01_r8,2.4703e-01_r8/)
      kbo(:,46,12) = (/ &
     &6.0349e-02_r8,8.3945e-02_r8,1.1412e-01_r8,1.5200e-01_r8,1.9783e-01_r8/)
      kbo(:,47,12) = (/ &
     &4.5026e-02_r8,6.3638e-02_r8,8.7982e-02_r8,1.1888e-01_r8,1.5630e-01_r8/)
      kbo(:,48,12) = (/ &
     &3.3400e-02_r8,4.7982e-02_r8,6.7403e-02_r8,9.2494e-02_r8,1.2316e-01_r8/)
      kbo(:,49,12) = (/ &
     &2.4633e-02_r8,3.5960e-02_r8,5.1349e-02_r8,7.1624e-02_r8,9.6517e-02_r8/)
      kbo(:,50,12) = (/ &
     &1.8199e-02_r8,2.7006e-02_r8,3.9181e-02_r8,5.5479e-02_r8,7.5913e-02_r8/)
      kbo(:,51,12) = (/ &
     &1.3397e-02_r8,2.0251e-02_r8,2.9827e-02_r8,4.2894e-02_r8,5.9697e-02_r8/)
      kbo(:,52,12) = (/ &
     &9.8047e-03_r8,1.5092e-02_r8,2.2613e-02_r8,3.3016e-02_r8,4.6660e-02_r8/)
      kbo(:,53,12) = (/ &
     &7.1233e-03_r8,1.1184e-02_r8,1.7048e-02_r8,2.5317e-02_r8,3.6316e-02_r8/)
      kbo(:,54,12) = (/ &
     &5.1904e-03_r8,8.3108e-03_r8,1.2872e-02_r8,1.9462e-02_r8,2.8342e-02_r8/)
      kbo(:,55,12) = (/ &
     &3.7706e-03_r8,6.1523e-03_r8,9.6915e-03_r8,1.4909e-02_r8,2.2083e-02_r8/)
      kbo(:,56,12) = (/ &
     &2.7214e-03_r8,4.5313e-03_r8,7.2581e-03_r8,1.1344e-02_r8,1.7112e-02_r8/)
      kbo(:,57,12) = (/ &
     &1.9679e-03_r8,3.3305e-03_r8,5.4024e-03_r8,8.5896e-03_r8,1.3181e-02_r8/)
      kbo(:,58,12) = (/ &
     &1.4312e-03_r8,2.4830e-03_r8,4.0992e-03_r8,6.5707e-03_r8,1.0148e-02_r8/)
      kbo(:,59,12) = (/ &
     &1.1735e-03_r8,2.0715e-03_r8,3.4672e-03_r8,5.6187e-03_r8,8.6747e-03_r8/)
      kbo(:,13,13) = (/ &
     &1.4965e+01_r8,1.9939e+01_r8,2.5957e+01_r8,3.3111e+01_r8,4.1486e+01_r8/)
      kbo(:,14,13) = (/ &
     &1.4891e+01_r8,1.9752e+01_r8,2.5714e+01_r8,3.2877e+01_r8,4.1201e+01_r8/)
      kbo(:,15,13) = (/ &
     &1.4632e+01_r8,1.9464e+01_r8,2.5349e+01_r8,3.2327e+01_r8,4.0239e+01_r8/)
      kbo(:,16,13) = (/ &
     &1.4224e+01_r8,1.8920e+01_r8,2.4612e+01_r8,3.1240e+01_r8,3.8764e+01_r8/)
      kbo(:,17,13) = (/ &
     &1.3596e+01_r8,1.8071e+01_r8,2.3399e+01_r8,2.9603e+01_r8,3.6827e+01_r8/)
      kbo(:,18,13) = (/ &
     &1.2765e+01_r8,1.6956e+01_r8,2.1940e+01_r8,2.7801e+01_r8,3.4621e+01_r8/)
      kbo(:,19,13) = (/ &
     &1.1845e+01_r8,1.5708e+01_r8,2.0355e+01_r8,2.5828e+01_r8,3.2043e+01_r8/)
      kbo(:,20,13) = (/ &
     &1.0881e+01_r8,1.4480e+01_r8,1.8761e+01_r8,2.3735e+01_r8,2.9355e+01_r8/)
      kbo(:,21,13) = (/ &
     &9.9388e+00_r8,1.3181e+01_r8,1.7060e+01_r8,2.1504e+01_r8,2.6520e+01_r8/)
      kbo(:,22,13) = (/ &
     &9.1395e+00_r8,1.2102e+01_r8,1.5540e+01_r8,1.9513e+01_r8,2.4061e+01_r8/)
      kbo(:,23,13) = (/ &
     &8.3446e+00_r8,1.0972e+01_r8,1.4055e+01_r8,1.7623e+01_r8,2.1727e+01_r8/)
      kbo(:,24,13) = (/ &
     &7.5591e+00_r8,9.8924e+00_r8,1.2651e+01_r8,1.5869e+01_r8,1.9520e+01_r8/)
      kbo(:,25,13) = (/ &
     &6.8143e+00_r8,8.8970e+00_r8,1.1359e+01_r8,1.4218e+01_r8,1.7424e+01_r8/)
      kbo(:,26,13) = (/ &
     &6.1698e+00_r8,8.0210e+00_r8,1.0220e+01_r8,1.2729e+01_r8,1.5532e+01_r8/)
      kbo(:,27,13) = (/ &
     &5.5728e+00_r8,7.2306e+00_r8,9.1639e+00_r8,1.1369e+01_r8,1.3833e+01_r8/)
      kbo(:,28,13) = (/ &
     &5.0450e+00_r8,6.5146e+00_r8,8.2221e+00_r8,1.0165e+01_r8,1.2320e+01_r8/)
      kbo(:,29,13) = (/ &
     &4.5820e+00_r8,5.8856e+00_r8,7.3962e+00_r8,9.1032e+00_r8,1.0999e+01_r8/)
      kbo(:,30,13) = (/ &
     &4.1619e+00_r8,5.3258e+00_r8,6.6581e+00_r8,8.1640e+00_r8,9.8348e+00_r8/)
      kbo(:,31,13) = (/ &
     &3.7986e+00_r8,4.8336e+00_r8,6.0169e+00_r8,7.3498e+00_r8,8.8372e+00_r8/)
      kbo(:,32,13) = (/ &
     &3.4747e+00_r8,4.3988e+00_r8,5.4556e+00_r8,6.6497e+00_r8,7.9860e+00_r8/)
      kbo(:,33,13) = (/ &
     &3.1806e+00_r8,4.0134e+00_r8,4.9644e+00_r8,6.0424e+00_r8,7.2445e+00_r8/)
      kbo(:,34,13) = (/ &
     &2.8901e+00_r8,3.6383e+00_r8,4.4979e+00_r8,5.4687e+00_r8,6.5591e+00_r8/)
      kbo(:,35,13) = (/ &
     &2.5701e+00_r8,3.2361e+00_r8,4.0067e+00_r8,4.8794e+00_r8,5.8576e+00_r8/)
      kbo(:,36,13) = (/ &
     &2.2323e+00_r8,2.8199e+00_r8,3.4998e+00_r8,4.2791e+00_r8,5.1575e+00_r8/)
      kbo(:,37,13) = (/ &
     &1.8736e+00_r8,2.3827e+00_r8,2.9738e+00_r8,3.6564e+00_r8,4.4360e+00_r8/)
      kbo(:,38,13) = (/ &
     &1.5728e+00_r8,2.0148e+00_r8,2.5311e+00_r8,3.1303e+00_r8,3.8226e+00_r8/)
      kbo(:,39,13) = (/ &
     &1.3237e+00_r8,1.7072e+00_r8,2.1603e+00_r8,2.6914e+00_r8,3.3072e+00_r8/)
      kbo(:,40,13) = (/ &
     &1.0847e+00_r8,1.4132e+00_r8,1.8059e+00_r8,2.2702e+00_r8,2.8143e+00_r8/)
      kbo(:,41,13) = (/ &
     &8.8581e-01_r8,1.1668e+00_r8,1.5064e+00_r8,1.9133e+00_r8,2.3935e+00_r8/)
      kbo(:,42,13) = (/ &
     &7.2374e-01_r8,9.6367e-01_r8,1.2577e+00_r8,1.6144e+00_r8,2.0403e+00_r8/)
      kbo(:,43,13) = (/ &
     &5.8123e-01_r8,7.8367e-01_r8,1.0353e+00_r8,1.3440e+00_r8,1.7177e+00_r8/)
      kbo(:,44,13) = (/ &
     &4.6198e-01_r8,6.3195e-01_r8,8.4539e-01_r8,1.1117e+00_r8,1.4376e+00_r8/)
      kbo(:,45,13) = (/ &
     &3.6584e-01_r8,5.0822e-01_r8,6.8932e-01_r8,9.1864e-01_r8,1.2028e+00_r8/)
      kbo(:,46,13) = (/ &
     &2.8644e-01_r8,4.0442e-01_r8,5.5738e-01_r8,7.5306e-01_r8,9.9957e-01_r8/)
      kbo(:,47,13) = (/ &
     &2.1956e-01_r8,3.1585e-01_r8,4.4303e-01_r8,6.0814e-01_r8,8.1897e-01_r8/)
      kbo(:,48,13) = (/ &
     &1.6674e-01_r8,2.4495e-01_r8,3.5019e-01_r8,4.8911e-01_r8,6.6858e-01_r8/)
      kbo(:,49,13) = (/ &
     &1.2553e-01_r8,1.8856e-01_r8,2.7515e-01_r8,3.9103e-01_r8,5.4421e-01_r8/)
      kbo(:,50,13) = (/ &
     &9.4665e-02_r8,1.4544e-01_r8,2.1677e-01_r8,3.1374e-01_r8,4.4454e-01_r8/)
      kbo(:,51,13) = (/ &
     &7.1191e-02_r8,1.1194e-01_r8,1.7036e-01_r8,2.5168e-01_r8,3.6277e-01_r8/)
      kbo(:,52,13) = (/ &
     &5.3052e-02_r8,8.5501e-02_r8,1.3304e-01_r8,2.0087e-01_r8,2.9517e-01_r8/)
      kbo(:,53,13) = (/ &
     &3.9132e-02_r8,6.4715e-02_r8,1.0314e-01_r8,1.5924e-01_r8,2.3881e-01_r8/)
      kbo(:,54,13) = (/ &
     &2.9043e-02_r8,4.9273e-02_r8,8.0552e-02_r8,1.2707e-01_r8,1.9473e-01_r8/)
      kbo(:,55,13) = (/ &
     &2.1525e-02_r8,3.7498e-02_r8,6.2875e-02_r8,1.0150e-01_r8,1.5889e-01_r8/)
      kbo(:,56,13) = (/ &
     &1.5833e-02_r8,2.8322e-02_r8,4.8765e-02_r8,8.0651e-02_r8,1.2905e-01_r8/)
      kbo(:,57,13) = (/ &
     &1.1526e-02_r8,2.1205e-02_r8,3.7510e-02_r8,6.3651e-02_r8,1.0431e-01_r8/)
      kbo(:,58,13) = (/ &
     &8.3779e-03_r8,1.5855e-02_r8,2.8776e-02_r8,5.0260e-02_r8,8.4604e-02_r8/)
      kbo(:,59,13) = (/ &
     &6.7851e-03_r8,1.3119e-02_r8,2.4293e-02_r8,4.3321e-02_r8,7.4531e-02_r8/)
      kbo(:,13,14) = (/ &
     &3.3721e+01_r8,4.7002e+01_r8,6.3302e+01_r8,8.2327e+01_r8,1.0363e+02_r8/)
      kbo(:,14,14) = (/ &
     &3.6911e+01_r8,5.0874e+01_r8,6.7511e+01_r8,8.6774e+01_r8,1.0872e+02_r8/)
      kbo(:,15,14) = (/ &
     &3.9962e+01_r8,5.4067e+01_r8,7.0780e+01_r8,9.0289e+01_r8,1.1312e+02_r8/)
      kbo(:,16,14) = (/ &
     &4.2338e+01_r8,5.6683e+01_r8,7.3332e+01_r8,9.3095e+01_r8,1.1626e+02_r8/)
      kbo(:,17,14) = (/ &
     &4.3916e+01_r8,5.8217e+01_r8,7.5023e+01_r8,9.4925e+01_r8,1.1793e+02_r8/)
      kbo(:,18,14) = (/ &
     &4.4576e+01_r8,5.8845e+01_r8,7.5702e+01_r8,9.5514e+01_r8,1.1830e+02_r8/)
      kbo(:,19,14) = (/ &
     &4.4328e+01_r8,5.8466e+01_r8,7.5196e+01_r8,9.4726e+01_r8,1.1748e+02_r8/)
      kbo(:,20,14) = (/ &
     &4.3798e+01_r8,5.7631e+01_r8,7.4169e+01_r8,9.3518e+01_r8,1.1584e+02_r8/)
      kbo(:,21,14) = (/ &
     &4.2847e+01_r8,5.6429e+01_r8,7.2627e+01_r8,9.1567e+01_r8,1.1316e+02_r8/)
      kbo(:,22,14) = (/ &
     &4.2232e+01_r8,5.5705e+01_r8,7.1694e+01_r8,9.0118e+01_r8,1.1101e+02_r8/)
      kbo(:,23,14) = (/ &
     &4.1301e+01_r8,5.4371e+01_r8,6.9797e+01_r8,8.7676e+01_r8,1.0772e+02_r8/)
      kbo(:,24,14) = (/ &
     &4.0036e+01_r8,5.2522e+01_r8,6.7301e+01_r8,8.4384e+01_r8,1.0387e+02_r8/)
      kbo(:,25,14) = (/ &
     &3.8535e+01_r8,5.0451e+01_r8,6.4572e+01_r8,8.0891e+01_r8,9.9814e+01_r8/)
      kbo(:,26,14) = (/ &
     &3.6990e+01_r8,4.8476e+01_r8,6.1896e+01_r8,7.7604e+01_r8,9.5632e+01_r8/)
      kbo(:,27,14) = (/ &
     &3.5439e+01_r8,4.6349e+01_r8,5.9201e+01_r8,7.4166e+01_r8,9.1237e+01_r8/)
      kbo(:,28,14) = (/ &
     &3.3799e+01_r8,4.4185e+01_r8,5.6512e+01_r8,7.0702e+01_r8,8.6988e+01_r8/)
      kbo(:,29,14) = (/ &
     &3.2225e+01_r8,4.2139e+01_r8,5.3908e+01_r8,6.7503e+01_r8,8.3109e+01_r8/)
      kbo(:,30,14) = (/ &
     &3.0748e+01_r8,4.0218e+01_r8,5.1459e+01_r8,6.4621e+01_r8,7.9612e+01_r8/)
      kbo(:,31,14) = (/ &
     &2.9425e+01_r8,3.8499e+01_r8,4.9352e+01_r8,6.2118e+01_r8,7.6745e+01_r8/)
      kbo(:,32,14) = (/ &
     &2.8242e+01_r8,3.7039e+01_r8,4.7648e+01_r8,6.0092e+01_r8,7.4536e+01_r8/)
      kbo(:,33,14) = (/ &
     &2.7263e+01_r8,3.5883e+01_r8,4.6290e+01_r8,5.8616e+01_r8,7.3025e+01_r8/)
      kbo(:,34,14) = (/ &
     &2.6245e+01_r8,3.4728e+01_r8,4.4963e+01_r8,5.7211e+01_r8,7.1614e+01_r8/)
      kbo(:,35,14) = (/ &
     &2.4792e+01_r8,3.3010e+01_r8,4.3016e+01_r8,5.5082e+01_r8,6.9332e+01_r8/)
      kbo(:,36,14) = (/ &
     &2.2854e+01_r8,3.0681e+01_r8,4.0335e+01_r8,5.2076e+01_r8,6.5971e+01_r8/)
      kbo(:,37,14) = (/ &
     &2.0215e+01_r8,2.7477e+01_r8,3.6561e+01_r8,4.7698e+01_r8,6.0990e+01_r8/)
      kbo(:,38,14) = (/ &
     &1.7901e+01_r8,2.4657e+01_r8,3.3200e+01_r8,4.3777e+01_r8,5.6518e+01_r8/)
      kbo(:,39,14) = (/ &
     &1.5916e+01_r8,2.2229e+01_r8,3.0285e+01_r8,4.0352e+01_r8,5.2594e+01_r8/)
      kbo(:,40,14) = (/ &
     &1.3687e+01_r8,1.9453e+01_r8,2.6865e+01_r8,3.6273e+01_r8,4.7801e+01_r8/)
      kbo(:,41,14) = (/ &
     &1.1706e+01_r8,1.6957e+01_r8,2.3775e+01_r8,3.2529e+01_r8,4.3345e+01_r8/)
      kbo(:,42,14) = (/ &
     &1.0015e+01_r8,1.4777e+01_r8,2.1056e+01_r8,2.9181e+01_r8,3.9336e+01_r8/)
      kbo(:,43,14) = (/ &
     &8.3602e+00_r8,1.2595e+01_r8,1.8289e+01_r8,2.5700e+01_r8,3.5139e+01_r8/)
      kbo(:,44,14) = (/ &
     &6.8842e+00_r8,1.0588e+01_r8,1.5702e+01_r8,2.2421e+01_r8,3.1090e+01_r8/)
      kbo(:,45,14) = (/ &
     &5.6505e+00_r8,8.8697e+00_r8,1.3428e+01_r8,1.9525e+01_r8,2.7445e+01_r8/)
      kbo(:,46,14) = (/ &
     &4.5669e+00_r8,7.3282e+00_r8,1.1331e+01_r8,1.6810e+01_r8,2.3987e+01_r8/)
      kbo(:,47,14) = (/ &
     &3.5910e+00_r8,5.9011e+00_r8,9.3338e+00_r8,1.4162e+01_r8,2.0590e+01_r8/)
      kbo(:,48,14) = (/ &
     &2.8046e+00_r8,4.7156e+00_r8,7.6334e+00_r8,1.1848e+01_r8,1.7577e+01_r8/)
      kbo(:,49,14) = (/ &
     &2.1748e+00_r8,3.7383e+00_r8,6.1955e+00_r8,9.8356e+00_r8,1.4909e+01_r8/)
      kbo(:,50,14) = (/ &
     &1.6968e+00_r8,2.9824e+00_r8,5.0552e+00_r8,8.1970e+00_r8,1.2692e+01_r8/)
      kbo(:,51,14) = (/ &
     &1.3228e+00_r8,2.3793e+00_r8,4.1196e+00_r8,6.8244e+00_r8,1.0784e+01_r8/)
      kbo(:,52,14) = (/ &
     &1.0245e+00_r8,1.8865e+00_r8,3.3355e+00_r8,5.6478e+00_r8,9.1028e+00_r8/)
      kbo(:,53,14) = (/ &
     &7.8728e-01_r8,1.4840e+00_r8,2.6816e+00_r8,4.6391e+00_r8,7.6341e+00_r8/)
      kbo(:,54,14) = (/ &
     &6.1018e-01_r8,1.1815e+00_r8,2.1812e+00_r8,3.8474e+00_r8,6.4584e+00_r8/)
      kbo(:,55,14) = (/ &
     &4.7246e-01_r8,9.4354e-01_r8,1.7799e+00_r8,3.1974e+00_r8,5.4714e+00_r8/)
      kbo(:,56,14) = (/ &
     &3.6268e-01_r8,7.4897e-01_r8,1.4435e+00_r8,2.6438e+00_r8,4.6110e+00_r8/)
      kbo(:,57,14) = (/ &
     &2.7617e-01_r8,5.8818e-01_r8,1.1638e+00_r8,2.1763e+00_r8,3.8632e+00_r8/)
      kbo(:,58,14) = (/ &
     &2.1026e-01_r8,4.6281e-01_r8,9.4334e-01_r8,1.8002e+00_r8,3.2506e+00_r8/)
      kbo(:,59,14) = (/ &
     &1.8510e-01_r8,4.1578e-01_r8,8.6198e-01_r8,1.6609e+00_r8,3.0231e+00_r8/)
      kbo(:,13,15) = (/ &
     &7.9497e+01_r8,1.0631e+02_r8,1.3951e+02_r8,1.8076e+02_r8,2.3534e+02_r8/)
      kbo(:,14,15) = (/ &
     &9.0008e+01_r8,1.2102e+02_r8,1.6070e+02_r8,2.0844e+02_r8,2.6891e+02_r8/)
      kbo(:,15,15) = (/ &
     &1.0142e+02_r8,1.3773e+02_r8,1.8424e+02_r8,2.3942e+02_r8,3.0596e+02_r8/)
      kbo(:,16,15) = (/ &
     &1.1444e+02_r8,1.5595e+02_r8,2.0951e+02_r8,2.7261e+02_r8,3.4599e+02_r8/)
      kbo(:,17,15) = (/ &
     &1.2871e+02_r8,1.7599e+02_r8,2.3611e+02_r8,3.0737e+02_r8,3.8849e+02_r8/)
      kbo(:,18,15) = (/ &
     &1.4444e+02_r8,1.9729e+02_r8,2.6334e+02_r8,3.4204e+02_r8,4.3103e+02_r8/)
      kbo(:,19,15) = (/ &
     &1.6121e+02_r8,2.1913e+02_r8,2.9095e+02_r8,3.7632e+02_r8,4.7170e+02_r8/)
      kbo(:,20,15) = (/ &
     &1.7880e+02_r8,2.4196e+02_r8,3.1956e+02_r8,4.1027e+02_r8,5.1312e+02_r8/)
      kbo(:,21,15) = (/ &
     &1.9582e+02_r8,2.6409e+02_r8,3.4675e+02_r8,4.4276e+02_r8,5.5264e+02_r8/)
      kbo(:,22,15) = (/ &
     &2.1631e+02_r8,2.9018e+02_r8,3.7825e+02_r8,4.8067e+02_r8,5.9651e+02_r8/)
      kbo(:,23,15) = (/ &
     &2.3693e+02_r8,3.1638e+02_r8,4.0986e+02_r8,5.1726e+02_r8,6.3877e+02_r8/)
      kbo(:,24,15) = (/ &
     &2.5815e+02_r8,3.4252e+02_r8,4.4099e+02_r8,5.5343e+02_r8,6.7985e+02_r8/)
      kbo(:,25,15) = (/ &
     &2.7940e+02_r8,3.6830e+02_r8,4.7141e+02_r8,5.8880e+02_r8,7.2036e+02_r8/)
      kbo(:,26,15) = (/ &
     &3.0147e+02_r8,3.9459e+02_r8,5.0246e+02_r8,6.2482e+02_r8,7.6276e+02_r8/)
      kbo(:,27,15) = (/ &
     &3.2318e+02_r8,4.2065e+02_r8,5.3313e+02_r8,6.6087e+02_r8,8.0529e+02_r8/)
      kbo(:,28,15) = (/ &
     &3.4508e+02_r8,4.4657e+02_r8,5.6379e+02_r8,6.9725e+02_r8,8.4792e+02_r8/)
      kbo(:,29,15) = (/ &
     &3.6777e+02_r8,4.7381e+02_r8,5.9626e+02_r8,7.3554e+02_r8,8.9251e+02_r8/)
      kbo(:,30,15) = (/ &
     &3.9103e+02_r8,5.0185e+02_r8,6.2997e+02_r8,7.7485e+02_r8,9.3819e+02_r8/)
      kbo(:,31,15) = (/ &
     &4.1560e+02_r8,5.3166e+02_r8,6.6523e+02_r8,8.1615e+02_r8,9.8559e+02_r8/)
      kbo(:,32,15) = (/ &
     &4.4194e+02_r8,5.6341e+02_r8,7.0244e+02_r8,8.5957e+02_r8,1.0345e+03_r8/)
      kbo(:,33,15) = (/ &
     &4.7004e+02_r8,5.9690e+02_r8,7.4161e+02_r8,9.0465e+02_r8,1.0849e+03_r8/)
      kbo(:,34,15) = (/ &
     &4.9560e+02_r8,6.2720e+02_r8,7.7702e+02_r8,9.4526e+02_r8,1.1301e+03_r8/)
      kbo(:,35,15) = (/ &
     &5.1020e+02_r8,6.4498e+02_r8,7.9798e+02_r8,9.6921e+02_r8,1.1571e+03_r8/)
      kbo(:,36,15) = (/ &
     &5.1153e+02_r8,6.4732e+02_r8,8.0146e+02_r8,9.7374e+02_r8,1.1629e+03_r8/)
      kbo(:,37,15) = (/ &
     &4.9411e+02_r8,6.2784e+02_r8,7.8019e+02_r8,9.5084e+02_r8,1.1384e+03_r8/)
      kbo(:,38,15) = (/ &
     &4.7607e+02_r8,6.0738e+02_r8,7.5785e+02_r8,9.2634e+02_r8,1.1122e+03_r8/)
      kbo(:,39,15) = (/ &
     &4.5860e+02_r8,5.8729e+02_r8,7.3571e+02_r8,9.0212e+02_r8,1.0835e+03_r8/)
      kbo(:,40,15) = (/ &
     &4.2990e+02_r8,5.5385e+02_r8,6.9803e+02_r8,8.6039e+02_r8,1.0406e+03_r8/)
      kbo(:,41,15) = (/ &
     &4.0087e+02_r8,5.1992e+02_r8,6.5921e+02_r8,8.1732e+02_r8,9.9347e+02_r8/)
      kbo(:,42,15) = (/ &
     &3.7298e+02_r8,4.8724e+02_r8,6.2146e+02_r8,7.7537e+02_r8,9.4699e+02_r8/)
      kbo(:,43,15) = (/ &
     &3.4053e+02_r8,4.4909e+02_r8,5.7712e+02_r8,7.2520e+02_r8,8.9154e+02_r8/)
      kbo(:,44,15) = (/ &
     &3.0753e+02_r8,4.1020e+02_r8,5.3144e+02_r8,6.7302e+02_r8,8.3358e+02_r8/)
      kbo(:,45,15) = (/ &
     &2.7654e+02_r8,3.7323e+02_r8,4.8808e+02_r8,6.2285e+02_r8,7.7741e+02_r8/)
      kbo(:,46,15) = (/ &
     &2.4531e+02_r8,3.3622e+02_r8,4.4437e+02_r8,5.7189e+02_r8,7.1969e+02_r8/)
      kbo(:,47,15) = (/ &
     &2.1302e+02_r8,2.9761e+02_r8,3.9853e+02_r8,5.1809e+02_r8,6.5783e+02_r8/)
      kbo(:,48,15) = (/ &
     &1.8355e+02_r8,2.6147e+02_r8,3.5562e+02_r8,4.6754e+02_r8,5.9909e+02_r8/)
      kbo(:,49,15) = (/ &
     &1.5701e+02_r8,2.2791e+02_r8,3.1569e+02_r8,4.2021e+02_r8,5.4365e+02_r8/)
      kbo(:,50,15) = (/ &
     &1.3468e+02_r8,1.9893e+02_r8,2.8071e+02_r8,3.7858e+02_r8,4.9472e+02_r8/)
      kbo(:,51,15) = (/ &
     &1.1526e+02_r8,1.7331e+02_r8,2.4880e+02_r8,3.4068e+02_r8,4.5000e+02_r8/)
      kbo(:,52,15) = (/ &
     &9.7991e+01_r8,1.5012e+02_r8,2.1915e+02_r8,3.0532e+02_r8,4.0798e+02_r8/)
      kbo(:,53,15) = (/ &
     &8.2622e+01_r8,1.2914e+02_r8,1.9179e+02_r8,2.7194e+02_r8,3.6825e+02_r8/)
      kbo(:,54,15) = (/ &
     &7.0111e+01_r8,1.1182e+02_r8,1.6882e+02_r8,2.4316e+02_r8,3.3408e+02_r8/)
      kbo(:,55,15) = (/ &
     &5.9451e+01_r8,9.6898e+01_r8,1.4869e+02_r8,2.1737e+02_r8,3.0323e+02_r8/)
      kbo(:,56,15) = (/ &
     &4.9982e+01_r8,8.3446e+01_r8,1.3033e+02_r8,1.9338e+02_r8,2.7397e+02_r8/)
      kbo(:,57,15) = (/ &
     &4.1621e+01_r8,7.1384e+01_r8,1.1363e+02_r8,1.7127e+02_r8,2.4633e+02_r8/)
      kbo(:,58,15) = (/ &
     &3.4650e+01_r8,6.1162e+01_r8,9.9313e+01_r8,1.5200e+02_r8,2.2168e+02_r8/)
      kbo(:,59,15) = (/ &
     &3.2067e+01_r8,5.7347e+01_r8,9.3961e+01_r8,1.4472e+02_r8,2.1224e+02_r8/)
      kbo(:,13,16) = (/ &
     &1.4292e+02_r8,1.7830e+02_r8,2.5018e+02_r8,3.7037e+02_r8,5.2070e+02_r8/)
      kbo(:,14,16) = (/ &
     &1.7229e+02_r8,2.1935e+02_r8,3.0306e+02_r8,4.4388e+02_r8,6.2020e+02_r8/)
      kbo(:,15,16) = (/ &
     &2.0873e+02_r8,2.6972e+02_r8,3.6756e+02_r8,5.2712e+02_r8,7.3393e+02_r8/)
      kbo(:,16,16) = (/ &
     &2.5439e+02_r8,3.3072e+02_r8,4.4570e+02_r8,6.2226e+02_r8,8.6517e+02_r8/)
      kbo(:,17,16) = (/ &
     &3.0902e+02_r8,4.0145e+02_r8,5.3763e+02_r8,7.3415e+02_r8,1.0082e+03_r8/)
      kbo(:,18,16) = (/ &
     &3.7239e+02_r8,4.8343e+02_r8,6.4354e+02_r8,8.6401e+02_r8,1.1697e+03_r8/)
      kbo(:,19,16) = (/ &
     &4.4344e+02_r8,5.7744e+02_r8,7.6245e+02_r8,1.0126e+03_r8,1.3544e+03_r8/)
      kbo(:,20,16) = (/ &
     &5.2591e+02_r8,6.8473e+02_r8,8.9843e+02_r8,1.1879e+03_r8,1.5662e+03_r8/)
      kbo(:,21,16) = (/ &
     &6.1975e+02_r8,8.0389e+02_r8,1.0527e+03_r8,1.3850e+03_r8,1.8066e+03_r8/)
      kbo(:,22,16) = (/ &
     &7.3890e+02_r8,9.5515e+02_r8,1.2474e+03_r8,1.6302e+03_r8,2.1130e+03_r8/)
      kbo(:,23,16) = (/ &
     &8.7503e+02_r8,1.1289e+03_r8,1.4705e+03_r8,1.9102e+03_r8,2.4554e+03_r8/)
      kbo(:,24,16) = (/ &
     &1.0277e+03_r8,1.3283e+03_r8,1.7241e+03_r8,2.2247e+03_r8,2.8319e+03_r8/)
      kbo(:,25,16) = (/ &
     &1.2034e+03_r8,1.5543e+03_r8,2.0073e+03_r8,2.5693e+03_r8,3.2356e+03_r8/)
      kbo(:,26,16) = (/ &
     &1.4042e+03_r8,1.8088e+03_r8,2.3218e+03_r8,2.9229e+03_r8,3.6714e+03_r8/)
      kbo(:,27,16) = (/ &
     &1.6234e+03_r8,2.0833e+03_r8,2.6544e+03_r8,3.3382e+03_r8,4.1196e+03_r8/)
      kbo(:,28,16) = (/ &
     &1.8563e+03_r8,2.3730e+03_r8,3.0002e+03_r8,3.7388e+03_r8,4.5730e+03_r8/)
      kbo(:,29,16) = (/ &
     &2.1060e+03_r8,2.6609e+03_r8,3.3576e+03_r8,4.1487e+03_r8,5.0295e+03_r8/)
      kbo(:,30,16) = (/ &
     &2.3669e+03_r8,2.9882e+03_r8,3.7190e+03_r8,4.5573e+03_r8,5.4823e+03_r8/)
      kbo(:,31,16) = (/ &
     &2.6382e+03_r8,3.3079e+03_r8,4.0851e+03_r8,4.9669e+03_r8,5.9326e+03_r8/)
      kbo(:,32,16) = (/ &
     &2.9162e+03_r8,3.6311e+03_r8,4.4535e+03_r8,5.3188e+03_r8,6.3774e+03_r8/)
      kbo(:,33,16) = (/ &
     &3.1977e+03_r8,3.9546e+03_r8,4.8182e+03_r8,5.7741e+03_r8,6.8136e+03_r8/)
      kbo(:,34,16) = (/ &
     &3.4540e+03_r8,4.2467e+03_r8,5.1445e+03_r8,6.1305e+03_r8,7.1986e+03_r8/)
      kbo(:,35,16) = (/ &
     &3.6329e+03_r8,4.4502e+03_r8,5.3698e+03_r8,6.3759e+03_r8,7.4635e+03_r8/)
      kbo(:,36,16) = (/ &
     &3.7190e+03_r8,4.5470e+03_r8,5.4751e+03_r8,6.4918e+03_r8,7.5883e+03_r8/)
      kbo(:,37,16) = (/ &
     &3.6766e+03_r8,4.4979e+03_r8,5.4194e+03_r8,6.4326e+03_r8,7.5253e+03_r8/)
      kbo(:,38,16) = (/ &
     &3.6175e+03_r8,4.4311e+03_r8,5.3444e+03_r8,6.3514e+03_r8,7.4384e+03_r8/)
      kbo(:,39,16) = (/ &
     &3.5511e+03_r8,4.3577e+03_r8,5.2603e+03_r8,6.2593e+03_r8,7.3011e+03_r8/)
      kbo(:,40,16) = (/ &
     &3.4038e+03_r8,4.1899e+03_r8,5.0730e+03_r8,6.0546e+03_r8,7.1202e+03_r8/)
      kbo(:,41,16) = (/ &
     &3.2449e+03_r8,4.0090e+03_r8,4.8718e+03_r8,5.8306e+03_r8,6.8794e+03_r8/)
      kbo(:,42,16) = (/ &
     &3.0878e+03_r8,3.8270e+03_r8,4.6679e+03_r8,5.6043e+03_r8,6.6342e+03_r8/)
      kbo(:,43,16) = (/ &
     &2.8974e+03_r8,3.6038e+03_r8,4.4171e+03_r8,5.3250e+03_r8,6.3295e+03_r8/)
      kbo(:,44,16) = (/ &
     &2.6963e+03_r8,3.3670e+03_r8,4.1477e+03_r8,5.0263e+03_r8,5.9993e+03_r8/)
      kbo(:,45,16) = (/ &
     &2.5060e+03_r8,3.1396e+03_r8,3.8862e+03_r8,4.7337e+03_r8,5.6766e+03_r8/)
      kbo(:,46,16) = (/ &
     &2.3164e+03_r8,2.9079e+03_r8,3.6158e+03_r8,4.4299e+03_r8,5.3398e+03_r8/)
      kbo(:,47,16) = (/ &
     &2.1174e+03_r8,2.6621e+03_r8,3.3261e+03_r8,4.0998e+03_r8,4.9727e+03_r8/)
      kbo(:,48,16) = (/ &
     &1.9329e+03_r8,2.4347e+03_r8,3.0518e+03_r8,3.7834e+03_r8,4.6186e+03_r8/)
      kbo(:,49,16) = (/ &
     &1.7595e+03_r8,2.2251e+03_r8,2.7943e+03_r8,3.4811e+03_r8,4.2776e+03_r8/)
      kbo(:,50,16) = (/ &
     &1.6082e+03_r8,2.0431e+03_r8,2.5690e+03_r8,3.2137e+03_r8,3.9707e+03_r8/)
      kbo(:,51,16) = (/ &
     &1.4710e+03_r8,1.8773e+03_r8,2.3673e+03_r8,2.9684e+03_r8,3.6854e+03_r8/)
      kbo(:,52,16) = (/ &
     &1.3426e+03_r8,1.7222e+03_r8,2.1800e+03_r8,2.7371e+03_r8,3.4141e+03_r8/)
      kbo(:,53,16) = (/ &
     &1.2224e+03_r8,1.5765e+03_r8,2.0045e+03_r8,2.5219e+03_r8,3.1562e+03_r8/)
      kbo(:,54,16) = (/ &
     &1.1196e+03_r8,1.4516e+03_r8,1.8541e+03_r8,2.3387e+03_r8,2.9325e+03_r8/)
      kbo(:,55,16) = (/ &
     &1.0267e+03_r8,1.3387e+03_r8,1.7175e+03_r8,2.1745e+03_r8,2.7302e+03_r8/)
      kbo(:,56,16) = (/ &
     &9.3987e+02_r8,1.2326e+03_r8,1.5894e+03_r8,2.0202e+03_r8,2.5405e+03_r8/)
      kbo(:,57,16) = (/ &
     &8.5792e+02_r8,1.1333e+03_r8,1.4474e+03_r8,1.8742e+03_r8,2.3631e+03_r8/)
      kbo(:,58,16) = (/ &
     &7.8443e+02_r8,1.0443e+03_r8,1.3605e+03_r8,1.7435e+03_r8,2.2055e+03_r8/)
      kbo(:,59,16) = (/ &
     &7.5656e+02_r8,1.0103e+03_r8,1.3189e+03_r8,1.6936e+03_r8,2.1455e+03_r8/)

!     The array FORREFO contains the coefficient of the water vapor
!     foreign-continuum (including the energy term).  The first 
!     index refers to reference temperature (296,260,224,260) and 
!     pressure (970,475,219,3 mbar) levels.  The second index 
!     runs over the g-channel (1 to 16).

      forrefo(1,:) = (/ &
     &2.8549e-03_r8,4.8281e-03_r8,6.2570e-03_r8,8.2731e-03_r8,7.9056e-03_r8,7.7840e-03_r8, &
     &1.0115e-02_r8,9.6599e-03_r8,1.0153e-02_r8,1.0921e-02_r8,1.2408e-02_r8,1.3496e-02_r8, &
     &1.5059e-02_r8,1.4636e-02_r8,1.6483e-02_r8,1.2394e-02_r8/)
      forrefo(2,:) = (/ &
     &3.0036e-03_r8,5.1093e-03_r8,5.7317e-03_r8,9.2246e-03_r8,8.9829e-03_r8,8.6477e-03_r8, &
     &1.1448e-02_r8,1.0391e-02_r8,1.0211e-02_r8,1.2921e-02_r8,1.2726e-02_r8,1.2426e-02_r8, &
     &1.4609e-02_r8,1.5783e-02_r8,1.6617e-02_r8,1.6858e-02_r8/)
      forrefo(3,:) = (/ &
     &3.0771e-03_r8,5.1206e-03_r8,5.8426e-03_r8,9.5727e-03_r8,1.0338e-02_r8,9.3737e-03_r8, &
     &1.2805e-02_r8,1.1272e-02_r8,1.1353e-02_r8,1.1837e-02_r8,1.1550e-02_r8,1.3020e-02_r8, &
     &1.3536e-02_r8,1.6226e-02_r8,1.6039e-02_r8,2.2578e-02_r8/)
      forrefo(4,:) = (/ &
     &3.3072e-03_r8,5.0240e-03_r8,6.8474e-03_r8,8.2736e-03_r8,8.6151e-03_r8,8.6762e-03_r8, &
     &1.1476e-02_r8,1.0246e-02_r8,1.0819e-02_r8,1.0640e-02_r8,1.0545e-02_r8,1.0533e-02_r8, &
     &1.0496e-02_r8,1.0142e-02_r8,9.7979e-03_r8,1.5255e-02_r8/)

!     The array SELFREFO contains the coefficient of the water vapor
!     self-continuum (including the energy term).  The first index
!     refers to temperature in 7.2 degree increments.  For instance,
!     JT = 1 refers to a temperature of 245.6, JT = 2 refers to 252.8,
!     etc.  The second index runs over the g-channel (1 to 16).

      selfrefo(:, 1) = (/ &
     & 7.25695e-01_r8, 6.53591e-01_r8, 5.88650e-01_r8, 5.30162e-01_r8, 4.77485e-01_r8, &
     & 4.30042e-01_r8, 3.87313e-01_r8, 3.48830e-01_r8, 3.14170e-01_r8, 2.82954e-01_r8/)
      selfrefo(:, 2) = (/ &
     & 9.61996e-01_r8, 8.77853e-01_r8, 8.01070e-01_r8, 7.31003e-01_r8, 6.67064e-01_r8, &
     & 6.08718e-01_r8, 5.55476e-01_r8, 5.06890e-01_r8, 4.62554e-01_r8, 4.22096e-01_r8/)
      selfrefo(:, 3) = (/ &
     & 9.72584e-01_r8, 9.02658e-01_r8, 8.37760e-01_r8, 7.77527e-01_r8, 7.21626e-01_r8, &
     & 6.69743e-01_r8, 6.21591e-01_r8, 5.76900e-01_r8, 5.35423e-01_r8, 4.96927e-01_r8/)
      selfrefo(:, 4) = (/ &
     & 1.24790e+00_r8, 1.14353e+00_r8, 1.04790e+00_r8, 9.60263e-01_r8, 8.79956e-01_r8, &
     & 8.06364e-01_r8, 7.38927e-01_r8, 6.77130e-01_r8, 6.20501e-01_r8, 5.68608e-01_r8/)
      selfrefo(:, 5) = (/ &
     & 1.23574e+00_r8, 1.12928e+00_r8, 1.03200e+00_r8, 9.43096e-01_r8, 8.61851e-01_r8, &
     & 7.87605e-01_r8, 7.19755e-01_r8, 6.57750e-01_r8, 6.01087e-01_r8, 5.49305e-01_r8/)
      selfrefo(:, 6) = (/ &
     & 1.20921e+00_r8, 1.10660e+00_r8, 1.01270e+00_r8, 9.26766e-01_r8, 8.48124e-01_r8, &
     & 7.76155e-01_r8, 7.10293e-01_r8, 6.50020e-01_r8, 5.94861e-01_r8, 5.44384e-01_r8/)
      selfrefo(:, 7) = (/ &
     & 1.38112e+00_r8, 1.26727e+00_r8, 1.16280e+00_r8, 1.06694e+00_r8, 9.78990e-01_r8, &
     & 8.98287e-01_r8, 8.24236e-01_r8, 7.56290e-01_r8, 6.93945e-01_r8, 6.36739e-01_r8/)
      selfrefo(:, 8) = (/ &
     & 1.30321e+00_r8, 1.20127e+00_r8, 1.10730e+00_r8, 1.02068e+00_r8, 9.40840e-01_r8, &
     & 8.67243e-01_r8, 7.99403e-01_r8, 7.36870e-01_r8, 6.79229e-01_r8, 6.26096e-01_r8/)
      selfrefo(:, 9) = (/ &
     & 1.26713e+00_r8, 1.17927e+00_r8, 1.09750e+00_r8, 1.02140e+00_r8, 9.50575e-01_r8, &
     & 8.84662e-01_r8, 8.23319e-01_r8, 7.66230e-01_r8, 7.13099e-01_r8, 6.63653e-01_r8/)
      selfrefo(:,10) = (/ &
     & 1.49824e+00_r8, 1.37053e+00_r8, 1.25370e+00_r8, 1.14683e+00_r8, 1.04908e+00_r8, &
     & 9.59651e-01_r8, 8.77849e-01_r8, 8.03020e-01_r8, 7.34569e-01_r8, 6.71954e-01_r8/)
      selfrefo(:,11) = (/ &
     & 1.44786e+00_r8, 1.34594e+00_r8, 1.25120e+00_r8, 1.16313e+00_r8, 1.08125e+00_r8, &
     & 1.00514e+00_r8, 9.34392e-01_r8, 8.68620e-01_r8, 8.07477e-01_r8, 7.50639e-01_r8/)
      selfrefo(:,12) = (/ &
     & 1.38460e+00_r8, 1.30437e+00_r8, 1.22880e+00_r8, 1.15760e+00_r8, 1.09053e+00_r8, &
     & 1.02735e+00_r8, 9.67825e-01_r8, 9.11750e-01_r8, 8.58924e-01_r8, 8.09159e-01_r8/)
      selfrefo(:,13) = (/ &
     & 1.51953e+00_r8, 1.42822e+00_r8, 1.34240e+00_r8, 1.26173e+00_r8, 1.18592e+00_r8, &
     & 1.11465e+00_r8, 1.04768e+00_r8, 9.84720e-01_r8, 9.25548e-01_r8, 8.69932e-01_r8/)
      selfrefo(:,14) = (/ &
     & 1.62608e+00_r8, 1.51021e+00_r8, 1.40260e+00_r8, 1.30266e+00_r8, 1.20983e+00_r8, &
     & 1.12363e+00_r8, 1.04356e+00_r8, 9.69200e-01_r8, 9.00138e-01_r8, 8.35998e-01_r8/)
      selfrefo(:,15) = (/ &
     & 1.65383e+00_r8, 1.54808e+00_r8, 1.44910e+00_r8, 1.35644e+00_r8, 1.26971e+00_r8, &
     & 1.18853e+00_r8, 1.11254e+00_r8, 1.04140e+00_r8, 9.74813e-01_r8, 9.12484e-01_r8/)
      selfrefo(:,16) = (/ &
     & 1.78105e+00_r8, 1.61421e+00_r8, 1.46300e+00_r8, 1.32595e+00_r8, 1.20174e+00_r8, &
     & 1.08917e+00_r8, 9.87141e-01_r8, 8.94670e-01_r8, 8.10861e-01_r8, 7.34904e-01_r8/)

      end subroutine lw_kgb02

