!     path:      $Source: /storm/rc1/cvsroot/rc/rrtmg_lw/src/rrtmg_lw_k_g.f90,v $
!     author:    $Author: mike $
!     revision:  $Revision: 1.2 $
!     created:   $Date: 2007/08/22 19:20:03 $
!
!  --------------------------------------------------------------------------
! |                                                                          |
! |  Copyright 2002-2007, Atmospheric & Environmental Research, Inc. (AER).  |
! |  This software may be used, copied, or redistributed as long as it is    |
! |  not sold and this copyright notice is reproduced on each copy made.     |
! |  This model is provided as is without any express or implied warranties. |
! |                       (http://www.rtweb.aer.com/)                        |
! |                                                                          |
!  --------------------------------------------------------------------------

! **************************************************************************
!      subroutine lw_kgbnn
! **************************************************************************
!  RRTM Longwave Radiative Transfer Model
!  Atmospheric and Environmental Research, Inc., Cambridge, MA
!
!  Original version:   E. J. Mlawer, et al.
!  Revision for GCMs:  Michael J. Iacono; October, 2002
!
!  This file contains 16 subroutines that include the 
!  absorption coefficients and other data for each of the 16 longwave
!  spectral bands used in RRTM.  Here, the data are defined for 16
!  g-points, or sub-intervals, per band.  These data are combined and
!  weighted using a mapping procedure in routine RRTMG_LW_INIT to reduce
!  the total number of g-points from 256 to 140 for use in the GCM.
! **************************************************************************
      subroutine lw_kgb08
! **************************************************************************

      use shr_kind_mod, only: r8 => shr_kind_r8

!      use parkind, only : jpim, jprb 
      use rrlw_kg08, only : fracrefao, fracrefbo, kao, kao_mco2, kao_mn2o, &
                            kao_mo3, kbo, kbo_mco2, kbo_mn2o, selfrefo, forrefo, &
                            cfc12o, cfc22adjo

      implicit none
      save

! Planck fraction mapping level : P=473.4280 mb, T = 259.83 K
      fracrefao(:) = (/ &
        1.6004e-01_r8,1.5437e-01_r8,1.4502e-01_r8,1.3084e-01_r8,1.1523e-01_r8,9.7743e-02_r8, &
        8.0376e-02_r8,6.0261e-02_r8,4.1111e-02_r8,4.4772e-03_r8,3.6511e-03_r8,2.9154e-03_r8, &
        2.1184e-03_r8,1.3048e-03_r8,4.6637e-04_r8,6.5624e-05_r8/)

! Planck fraction mapping level : P=95.5835 mb, T= 215.7 K
      fracrefbo(:) = (/ &
        1.4987e-01_r8,1.4665e-01_r8,1.4154e-01_r8,1.3200e-01_r8,1.1902e-01_r8,1.0352e-01_r8, &
        8.4939e-02_r8,6.4105e-02_r8,4.3190e-02_r8,4.5129e-03_r8,3.7656e-03_r8,2.8733e-03_r8, &
        2.0947e-03_r8,1.3201e-03_r8,5.1832e-04_r8,7.7473e-05_r8/)

! Minor gas mapping level:
!     lower - co2, p = 1053.63 mb, t = 294.2 k
!     lower - o3,  p = 317.348 mb, t = 240.77 k
!     lower - n2o, p = 706.2720 mb, t= 278.94 k
!     lower - cfc12,cfc11
!     upper - co2, p = 35.1632 mb, t = 223.28 k
!     upper - n2o, p = 8.716e-2 mb, t = 226.03 k

      cfc12o(:) = (/ &
        85.4027_r8, 89.4696_r8, 74.0959_r8, 67.7480_r8, &
        61.2444_r8, 59.9073_r8, 60.8296_r8, 63.0998_r8, &
        59.6110_r8, 64.0735_r8, 57.2622_r8, 58.9721_r8, &
        43.5505_r8, 26.1192_r8, 32.7023_r8, 32.8667_r8/)
! Original CFC22 is multiplied by 1.485 to account for the 780-850 cm-1 
! and 1290-1335 cm-1 bands.
      cfc22adjo(:) = (/ &
        135.335_r8, 89.6642_r8, 76.2375_r8, 65.9748_r8, &
        63.1164_r8, 60.2935_r8, 64.0299_r8, 75.4264_r8, &
        51.3018_r8, 7.07911_r8, 5.86928_r8, 0.398693_r8, &
        2.82885_r8, 9.12751_r8, 6.28271_r8, 0._r8/)

!     The array KAO contains absorption coefs at the 16 chosen g-values 
!     for a range of pressure levels > ~100mb and temperatures.  The first
!     index in the array, JT, which runs from 1 to 5, corresponds to 
!     different temperatures.  More specifically, JT = 3 means that the 
!     data are for the corresponding TREF for this  pressure level, 
!     JT = 2 refers to the temperatureTREF-15, JT = 1 is for TREF-30, 
!     JT = 4 is for TREF+15, and JT = 5 is for TREF+30.  The second 
!     index, JP, runs from 1 to 13 and refers to the corresponding 
!     pressure level in PREF (e.g. JP = 1 is for a pressure of 1053.63 mb).  
!     The third index, IG, goes from 1 to 16, and tells us which 
!     g-interval the absorption coefficients are for.

      kao(:, 1, 1) = (/ &
     &1.4664e-05_r8,1.7114e-05_r8,1.8876e-05_r8,2.2301e-05_r8,2.6622e-05_r8/)
      kao(:, 2, 1) = (/ &
     &1.0571e-05_r8,1.1718e-05_r8,1.4060e-05_r8,1.7193e-05_r8,2.1557e-05_r8/)
      kao(:, 3, 1) = (/ &
     &6.6138e-06_r8,8.1523e-06_r8,1.0695e-05_r8,1.3782e-05_r8,1.7449e-05_r8/)
      kao(:, 4, 1) = (/ &
     &5.1390e-06_r8,7.0055e-06_r8,9.4447e-06_r8,1.2362e-05_r8,1.5431e-05_r8/)
      kao(:, 5, 1) = (/ &
     &4.7765e-06_r8,6.4140e-06_r8,8.4242e-06_r8,1.0772e-05_r8,1.3788e-05_r8/)
      kao(:, 6, 1) = (/ &
     &4.4818e-06_r8,6.1945e-06_r8,8.3186e-06_r8,1.0638e-05_r8,1.3072e-05_r8/)
      kao(:, 7, 1) = (/ &
     &4.1781e-06_r8,5.8651e-06_r8,8.2034e-06_r8,1.0966e-05_r8,1.3592e-05_r8/)
      kao(:, 8, 1) = (/ &
     &4.6559e-06_r8,6.5570e-06_r8,8.8606e-06_r8,1.1636e-05_r8,1.4449e-05_r8/)
      kao(:, 9, 1) = (/ &
     &6.3964e-06_r8,9.3461e-06_r8,1.3202e-05_r8,1.7140e-05_r8,2.2124e-05_r8/)
      kao(:,10, 1) = (/ &
     &1.0453e-05_r8,1.6266e-05_r8,2.2571e-05_r8,3.2675e-05_r8,4.3832e-05_r8/)
      kao(:,11, 1) = (/ &
     &1.9225e-05_r8,2.5219e-05_r8,3.3439e-05_r8,4.2567e-05_r8,5.0999e-05_r8/)
      kao(:,12, 1) = (/ &
     &1.8581e-05_r8,2.6464e-05_r8,3.4892e-05_r8,4.5782e-05_r8,5.8008e-05_r8/)
      kao(:,13, 1) = (/ &
     &2.3252e-05_r8,2.6601e-05_r8,3.1497e-05_r8,4.1728e-05_r8,5.3564e-05_r8/)
      kao(:, 1, 2) = (/ &
     &2.4622e-05_r8,2.2121e-05_r8,2.5151e-05_r8,3.1972e-05_r8,4.1114e-05_r8/)
      kao(:, 2, 2) = (/ &
     &1.5738e-05_r8,1.6913e-05_r8,2.0782e-05_r8,2.6880e-05_r8,3.4084e-05_r8/)
      kao(:, 3, 2) = (/ &
     &9.8655e-06_r8,1.2753e-05_r8,1.6558e-05_r8,2.1755e-05_r8,2.8126e-05_r8/)
      kao(:, 4, 2) = (/ &
     &7.9265e-06_r8,1.0229e-05_r8,1.3524e-05_r8,1.7603e-05_r8,2.3192e-05_r8/)
      kao(:, 5, 2) = (/ &
     &7.0537e-06_r8,9.6733e-06_r8,1.2570e-05_r8,1.6079e-05_r8,2.0384e-05_r8/)
      kao(:, 6, 2) = (/ &
     &6.5277e-06_r8,9.1084e-06_r8,1.2443e-05_r8,1.5914e-05_r8,2.0339e-05_r8/)
      kao(:, 7, 2) = (/ &
     &7.4442e-06_r8,1.0146e-05_r8,1.2791e-05_r8,1.6212e-05_r8,2.1044e-05_r8/)
      kao(:, 8, 2) = (/ &
     &7.4223e-06_r8,1.0854e-05_r8,1.4643e-05_r8,1.9376e-05_r8,2.5625e-05_r8/)
      kao(:, 9, 2) = (/ &
     &1.4157e-05_r8,1.8510e-05_r8,2.5064e-05_r8,3.4631e-05_r8,4.4655e-05_r8/)
      kao(:,10, 2) = (/ &
     &3.4785e-05_r8,4.4053e-05_r8,5.4155e-05_r8,6.0764e-05_r8,5.9887e-05_r8/)
      kao(:,11, 2) = (/ &
     &4.4199e-05_r8,5.6024e-05_r8,6.6252e-05_r8,8.3322e-05_r8,1.0437e-04_r8/)
      kao(:,12, 2) = (/ &
     &4.8012e-05_r8,6.2560e-05_r8,7.6674e-05_r8,8.6164e-05_r8,1.0081e-04_r8/)
      kao(:,13, 2) = (/ &
     &3.9220e-05_r8,5.8614e-05_r8,7.6090e-05_r8,8.9710e-05_r8,9.6705e-05_r8/)
      kao(:, 1, 3) = (/ &
     &2.7517e-05_r8,3.2252e-05_r8,4.5774e-05_r8,5.9187e-05_r8,7.3901e-05_r8/)
      kao(:, 2, 3) = (/ &
     &1.9414e-05_r8,2.5349e-05_r8,3.4494e-05_r8,4.4078e-05_r8,5.4475e-05_r8/)
      kao(:, 3, 3) = (/ &
     &1.4431e-05_r8,1.9862e-05_r8,2.6815e-05_r8,3.5045e-05_r8,4.4510e-05_r8/)
      kao(:, 4, 3) = (/ &
     &1.1163e-05_r8,1.5886e-05_r8,2.1047e-05_r8,2.7352e-05_r8,3.5151e-05_r8/)
      kao(:, 5, 3) = (/ &
     &1.0004e-05_r8,1.3946e-05_r8,1.9070e-05_r8,2.4940e-05_r8,3.2122e-05_r8/)
      kao(:, 6, 3) = (/ &
     &9.8796e-06_r8,1.2389e-05_r8,1.6574e-05_r8,2.2677e-05_r8,2.9114e-05_r8/)
      kao(:, 7, 3) = (/ &
     &9.6705e-06_r8,1.3203e-05_r8,1.8009e-05_r8,2.4248e-05_r8,2.9926e-05_r8/)
      kao(:, 8, 3) = (/ &
     &1.2684e-05_r8,1.5798e-05_r8,2.0751e-05_r8,2.7135e-05_r8,3.4302e-05_r8/)
      kao(:, 9, 3) = (/ &
     &2.3748e-05_r8,2.8117e-05_r8,3.3728e-05_r8,4.1366e-05_r8,5.3787e-05_r8/)
      kao(:,10, 3) = (/ &
     &4.9449e-05_r8,6.0387e-05_r8,8.1388e-05_r8,1.0134e-04_r8,1.3311e-04_r8/)
      kao(:,11, 3) = (/ &
     &6.5933e-05_r8,8.9755e-05_r8,1.2191e-04_r8,1.3795e-04_r8,1.5355e-04_r8/)
      kao(:,12, 3) = (/ &
     &6.2437e-05_r8,8.0247e-05_r8,1.0990e-04_r8,1.3683e-04_r8,1.6418e-04_r8/)
      kao(:,13, 3) = (/ &
     &5.9989e-05_r8,6.7831e-05_r8,9.4332e-05_r8,1.1542e-04_r8,1.5040e-04_r8/)
      kao(:, 1, 4) = (/ &
     &3.6489e-05_r8,5.9568e-05_r8,7.8043e-05_r8,9.8599e-05_r8,1.2261e-04_r8/)
      kao(:, 2, 4) = (/ &
     &3.0751e-05_r8,4.5700e-05_r8,5.9720e-05_r8,7.6230e-05_r8,9.5698e-05_r8/)
      kao(:, 3, 4) = (/ &
     &2.6862e-05_r8,3.6448e-05_r8,4.6703e-05_r8,5.7936e-05_r8,7.1216e-05_r8/)
      kao(:, 4, 4) = (/ &
     &2.0754e-05_r8,2.7900e-05_r8,3.6677e-05_r8,4.8008e-05_r8,6.1630e-05_r8/)
      kao(:, 5, 4) = (/ &
     &1.6362e-05_r8,2.1862e-05_r8,2.9666e-05_r8,3.8981e-05_r8,5.0305e-05_r8/)
      kao(:, 6, 4) = (/ &
     &1.4991e-05_r8,2.0957e-05_r8,2.6223e-05_r8,3.2254e-05_r8,4.2632e-05_r8/)
      kao(:, 7, 4) = (/ &
     &1.3833e-05_r8,1.9399e-05_r8,2.5656e-05_r8,3.2001e-05_r8,4.1685e-05_r8/)
      kao(:, 8, 4) = (/ &
     &1.6855e-05_r8,2.2852e-05_r8,3.0265e-05_r8,3.5778e-05_r8,4.6073e-05_r8/)
      kao(:, 9, 4) = (/ &
     &3.3370e-05_r8,4.7904e-05_r8,5.8243e-05_r8,6.4094e-05_r8,7.6700e-05_r8/)
      kao(:,10, 4) = (/ &
     &6.8238e-05_r8,1.0340e-04_r8,1.2739e-04_r8,1.5464e-04_r8,1.7523e-04_r8/)
      kao(:,11, 4) = (/ &
     &6.1230e-05_r8,9.6227e-05_r8,1.3743e-04_r8,1.9846e-04_r8,2.3838e-04_r8/)
      kao(:,12, 4) = (/ &
     &6.8823e-05_r8,1.0715e-04_r8,1.3058e-04_r8,1.9049e-04_r8,2.2996e-04_r8/)
      kao(:,13, 4) = (/ &
     &6.5444e-05_r8,1.1659e-04_r8,1.2685e-04_r8,1.7368e-04_r8,2.0128e-04_r8/)
      kao(:, 1, 5) = (/ &
     &7.8999e-05_r8,1.0665e-04_r8,1.3776e-04_r8,1.7432e-04_r8,2.1687e-04_r8/)
      kao(:, 2, 5) = (/ &
     &6.1797e-05_r8,8.3347e-05_r8,1.0862e-04_r8,1.3836e-04_r8,1.7490e-04_r8/)
      kao(:, 3, 5) = (/ &
     &4.7325e-05_r8,6.2800e-05_r8,8.1194e-05_r8,1.0315e-04_r8,1.3026e-04_r8/)
      kao(:, 4, 5) = (/ &
     &3.8433e-05_r8,5.0865e-05_r8,6.5549e-05_r8,8.2585e-05_r8,1.0247e-04_r8/)
      kao(:, 5, 5) = (/ &
     &3.0177e-05_r8,3.9082e-05_r8,4.9288e-05_r8,6.5674e-05_r8,8.5494e-05_r8/)
      kao(:, 6, 5) = (/ &
     &2.4712e-05_r8,3.2374e-05_r8,4.1224e-05_r8,5.5035e-05_r8,7.0157e-05_r8/)
      kao(:, 7, 5) = (/ &
     &2.2530e-05_r8,2.6200e-05_r8,3.5121e-05_r8,4.6306e-05_r8,5.9652e-05_r8/)
      kao(:, 8, 5) = (/ &
     &2.8297e-05_r8,3.6551e-05_r8,4.4329e-05_r8,5.9550e-05_r8,7.1792e-05_r8/)
      kao(:, 9, 5) = (/ &
     &5.6002e-05_r8,7.4631e-05_r8,8.8607e-05_r8,1.1720e-04_r8,1.2997e-04_r8/)
      kao(:,10, 5) = (/ &
     &8.1020e-05_r8,1.1580e-04_r8,1.6197e-04_r8,2.3825e-04_r8,2.8441e-04_r8/)
      kao(:,11, 5) = (/ &
     &9.6146e-05_r8,1.4644e-04_r8,1.7805e-04_r8,2.2438e-04_r8,3.1753e-04_r8/)
      kao(:,12, 5) = (/ &
     &9.5441e-05_r8,1.4982e-04_r8,2.4222e-04_r8,2.7134e-04_r8,3.3168e-04_r8/)
      kao(:,13, 5) = (/ &
     &9.5058e-05_r8,1.4349e-04_r8,2.4835e-04_r8,2.9526e-04_r8,3.7011e-04_r8/)
      kao(:, 1, 6) = (/ &
     &1.5625e-04_r8,2.0681e-04_r8,2.6299e-04_r8,3.2669e-04_r8,4.0038e-04_r8/)
      kao(:, 2, 6) = (/ &
     &1.1702e-04_r8,1.5581e-04_r8,2.0084e-04_r8,2.5419e-04_r8,3.1669e-04_r8/)
      kao(:, 3, 6) = (/ &
     &8.6159e-05_r8,1.1329e-04_r8,1.4769e-04_r8,1.9151e-04_r8,2.4537e-04_r8/)
      kao(:, 4, 6) = (/ &
     &7.1655e-05_r8,9.4348e-05_r8,1.2251e-04_r8,1.5312e-04_r8,1.8840e-04_r8/)
      kao(:, 5, 6) = (/ &
     &5.9776e-05_r8,8.0388e-05_r8,1.0504e-04_r8,1.3009e-04_r8,1.5686e-04_r8/)
      kao(:, 6, 6) = (/ &
     &4.1587e-05_r8,5.6800e-05_r8,7.7481e-05_r8,9.9930e-05_r8,1.3028e-04_r8/)
      kao(:, 7, 6) = (/ &
     &3.7625e-05_r8,5.2950e-05_r8,6.5572e-05_r8,8.3943e-05_r8,1.0947e-04_r8/)
      kao(:, 8, 6) = (/ &
     &4.0934e-05_r8,5.1706e-05_r8,6.6726e-05_r8,8.2858e-05_r8,1.0389e-04_r8/)
      kao(:, 9, 6) = (/ &
     &8.3177e-05_r8,1.0693e-04_r8,1.2771e-04_r8,1.5344e-04_r8,1.9338e-04_r8/)
      kao(:,10, 6) = (/ &
     &1.2590e-04_r8,1.6860e-04_r8,2.4332e-04_r8,2.8123e-04_r8,4.3002e-04_r8/)
      kao(:,11, 6) = (/ &
     &1.5778e-04_r8,2.1103e-04_r8,2.9773e-04_r8,4.5434e-04_r8,5.2006e-04_r8/)
      kao(:,12, 6) = (/ &
     &1.7734e-04_r8,2.3169e-04_r8,2.6921e-04_r8,4.5377e-04_r8,6.4453e-04_r8/)
      kao(:,13, 6) = (/ &
     &1.7874e-04_r8,2.2968e-04_r8,2.8292e-04_r8,4.5303e-04_r8,6.1897e-04_r8/)
      kao(:, 1, 7) = (/ &
     &3.7144e-04_r8,4.7830e-04_r8,6.0203e-04_r8,7.4238e-04_r8,8.9847e-04_r8/)
      kao(:, 2, 7) = (/ &
     &2.8002e-04_r8,3.6431e-04_r8,4.6140e-04_r8,5.7047e-04_r8,6.9195e-04_r8/)
      kao(:, 3, 7) = (/ &
     &1.8338e-04_r8,2.5018e-04_r8,3.2929e-04_r8,4.2096e-04_r8,5.2583e-04_r8/)
      kao(:, 4, 7) = (/ &
     &1.3365e-04_r8,1.7565e-04_r8,2.2370e-04_r8,2.9770e-04_r8,3.9171e-04_r8/)
      kao(:, 5, 7) = (/ &
     &1.1609e-04_r8,1.5410e-04_r8,1.9723e-04_r8,2.4620e-04_r8,3.0830e-04_r8/)
      kao(:, 6, 7) = (/ &
     &1.0480e-04_r8,1.3862e-04_r8,1.7991e-04_r8,2.2372e-04_r8,2.7406e-04_r8/)
      kao(:, 7, 7) = (/ &
     &8.7767e-05_r8,1.1689e-04_r8,1.5270e-04_r8,1.9631e-04_r8,2.3773e-04_r8/)
      kao(:, 8, 7) = (/ &
     &9.8366e-05_r8,1.1738e-04_r8,1.4725e-04_r8,1.8494e-04_r8,2.3601e-04_r8/)
      kao(:, 9, 7) = (/ &
     &1.5443e-04_r8,1.9009e-04_r8,2.4404e-04_r8,2.8078e-04_r8,3.3602e-04_r8/)
      kao(:,10, 7) = (/ &
     &1.5274e-04_r8,2.6878e-04_r8,3.7659e-04_r8,5.3377e-04_r8,5.6306e-04_r8/)
      kao(:,11, 7) = (/ &
     &2.0214e-04_r8,2.6794e-04_r8,4.2457e-04_r8,5.7376e-04_r8,8.8285e-04_r8/)
      kao(:,12, 7) = (/ &
     &2.5054e-04_r8,3.1232e-04_r8,4.4996e-04_r8,6.0765e-04_r8,8.8689e-04_r8/)
      kao(:,13, 7) = (/ &
     &2.7318e-04_r8,3.6929e-04_r8,4.5362e-04_r8,6.1364e-04_r8,9.2141e-04_r8/)
      kao(:, 1, 8) = (/ &
     &1.1751e-03_r8,1.5113e-03_r8,1.8892e-03_r8,2.3109e-03_r8,2.7776e-03_r8/)
      kao(:, 2, 8) = (/ &
     &8.9844e-04_r8,1.1675e-03_r8,1.4748e-03_r8,1.8223e-03_r8,2.2105e-03_r8/)
      kao(:, 3, 8) = (/ &
     &6.3916e-04_r8,8.4337e-04_r8,1.0777e-03_r8,1.3420e-03_r8,1.6361e-03_r8/)
      kao(:, 4, 8) = (/ &
     &3.9704e-04_r8,5.5491e-04_r8,7.4493e-04_r8,9.5633e-04_r8,1.1972e-03_r8/)
      kao(:, 5, 8) = (/ &
     &2.8104e-04_r8,3.5275e-04_r8,4.8572e-04_r8,6.7373e-04_r8,9.0464e-04_r8/)
      kao(:, 6, 8) = (/ &
     &2.6538e-04_r8,3.4221e-04_r8,4.3816e-04_r8,5.5889e-04_r8,6.9563e-04_r8/)
      kao(:, 7, 8) = (/ &
     &2.6802e-04_r8,3.3443e-04_r8,4.3228e-04_r8,5.4299e-04_r8,6.7937e-04_r8/)
      kao(:, 8, 8) = (/ &
     &2.6587e-04_r8,3.6538e-04_r8,4.4243e-04_r8,5.3612e-04_r8,6.5384e-04_r8/)
      kao(:, 9, 8) = (/ &
     &3.1669e-04_r8,4.3173e-04_r8,5.9018e-04_r8,7.8164e-04_r8,9.3453e-04_r8/)
      kao(:,10, 8) = (/ &
     &2.7923e-04_r8,3.5605e-04_r8,4.7230e-04_r8,7.5710e-04_r8,1.3303e-03_r8/)
      kao(:,11, 8) = (/ &
     &3.9189e-04_r8,4.5454e-04_r8,6.3718e-04_r8,5.9520e-04_r8,8.3511e-04_r8/)
      kao(:,12, 8) = (/ &
     &2.6981e-04_r8,5.3035e-04_r8,6.9787e-04_r8,8.5120e-04_r8,7.8888e-04_r8/)
      kao(:,13, 8) = (/ &
     &2.5533e-04_r8,5.3884e-04_r8,7.3128e-04_r8,1.0359e-03_r8,9.5286e-04_r8/)
      kao(:, 1, 9) = (/ &
     &4.1658e-03_r8,5.4654e-03_r8,6.9658e-03_r8,8.6722e-03_r8,1.0572e-02_r8/)
      kao(:, 2, 9) = (/ &
     &3.6223e-03_r8,4.7934e-03_r8,6.1539e-03_r8,7.6963e-03_r8,9.3961e-03_r8/)
      kao(:, 3, 9) = (/ &
     &2.8899e-03_r8,3.8874e-03_r8,5.0544e-03_r8,6.3815e-03_r8,7.8638e-03_r8/)
      kao(:, 4, 9) = (/ &
     &2.1989e-03_r8,3.0197e-03_r8,3.9971e-03_r8,5.1085e-03_r8,6.3356e-03_r8/)
      kao(:, 5, 9) = (/ &
     &1.5192e-03_r8,2.2278e-03_r8,3.0194e-03_r8,3.9009e-03_r8,4.8746e-03_r8/)
      kao(:, 6, 9) = (/ &
     &8.7921e-04_r8,1.3751e-03_r8,1.9853e-03_r8,2.7076e-03_r8,3.5697e-03_r8/)
      kao(:, 7, 9) = (/ &
     &8.1169e-04_r8,1.0620e-03_r8,1.3025e-03_r8,1.8213e-03_r8,2.5733e-03_r8/)
      kao(:, 8, 9) = (/ &
     &8.9592e-04_r8,1.1349e-03_r8,1.5068e-03_r8,1.9574e-03_r8,2.3526e-03_r8/)
      kao(:, 9, 9) = (/ &
     &6.4937e-04_r8,9.7395e-04_r8,1.5824e-03_r8,2.3319e-03_r8,3.1640e-03_r8/)
      kao(:,10, 9) = (/ &
     &5.2173e-04_r8,1.2542e-03_r8,1.3511e-03_r8,1.8295e-03_r8,2.2102e-03_r8/)
      kao(:,11, 9) = (/ &
     &3.8299e-05_r8,7.6837e-04_r8,1.6073e-03_r8,2.1707e-03_r8,2.6859e-03_r8/)
      kao(:,12, 9) = (/ &
     &5.7389e-05_r8,4.8395e-04_r8,1.3815e-03_r8,2.5956e-03_r8,2.8856e-03_r8/)
      kao(:,13, 9) = (/ &
     &6.6437e-05_r8,4.1020e-04_r8,1.3561e-03_r8,2.3769e-03_r8,2.6400e-03_r8/)
      kao(:, 1,10) = (/ &
     &8.5531e-03_r8,1.1311e-02_r8,1.4946e-02_r8,1.9199e-02_r8,2.4070e-02_r8/)
      kao(:, 2,10) = (/ &
     &7.9512e-03_r8,1.0579e-02_r8,1.3947e-02_r8,1.7937e-02_r8,2.2682e-02_r8/)
      kao(:, 3,10) = (/ &
     &6.8586e-03_r8,9.3196e-03_r8,1.2459e-02_r8,1.6108e-02_r8,2.0278e-02_r8/)
      kao(:, 4,10) = (/ &
     &5.7104e-03_r8,7.9133e-03_r8,1.0642e-02_r8,1.3936e-02_r8,1.7830e-02_r8/)
      kao(:, 5,10) = (/ &
     &4.5965e-03_r8,6.4891e-03_r8,8.9433e-03_r8,1.1923e-02_r8,1.5372e-02_r8/)
      kao(:, 6,10) = (/ &
     &3.5770e-03_r8,5.1433e-03_r8,7.2049e-03_r8,9.7750e-03_r8,1.2529e-02_r8/)
      kao(:, 7,10) = (/ &
     &1.4544e-03_r8,1.6129e-03_r8,4.3574e-03_r8,7.0808e-03_r8,9.3333e-03_r8/)
      kao(:, 8,10) = (/ &
     &1.6681e-03_r8,2.3313e-03_r8,2.9075e-03_r8,3.3382e-03_r8,4.3787e-03_r8/)
      kao(:, 9,10) = (/ &
     &8.5765e-04_r8,1.7252e-03_r8,1.7039e-03_r8,3.3311e-03_r8,4.8997e-03_r8/)
      kao(:,10,10) = (/ &
     &2.2034e-05_r8,3.2730e-05_r8,2.9477e-03_r8,2.5954e-03_r8,5.2191e-03_r8/)
      kao(:,11,10) = (/ &
     &1.5700e-05_r8,2.2697e-05_r8,3.1811e-05_r8,9.1022e-03_r8,5.0873e-03_r8/)
      kao(:,12,10) = (/ &
     &1.1747e-05_r8,1.7581e-05_r8,2.4222e-05_r8,3.4764e-05_r8,8.4666e-03_r8/)
      kao(:,13,10) = (/ &
     &8.0435e-06_r8,1.2386e-05_r8,1.8547e-05_r8,2.6164e-05_r8,8.2788e-03_r8/)
      kao(:, 1,11) = (/ &
     &1.1747e-02_r8,1.5703e-02_r8,2.0198e-02_r8,2.5614e-02_r8,3.2111e-02_r8/)
      kao(:, 2,11) = (/ &
     &1.0674e-02_r8,1.4371e-02_r8,1.8733e-02_r8,2.4132e-02_r8,3.0707e-02_r8/)
      kao(:, 3,11) = (/ &
     &9.1890e-03_r8,1.2390e-02_r8,1.6367e-02_r8,2.1591e-02_r8,2.7893e-02_r8/)
      kao(:, 4,11) = (/ &
     &7.8825e-03_r8,1.0755e-02_r8,1.4391e-02_r8,1.9071e-02_r8,2.4702e-02_r8/)
      kao(:, 5,11) = (/ &
     &6.5907e-03_r8,9.1636e-03_r8,1.2468e-02_r8,1.6782e-02_r8,2.1901e-02_r8/)
      kao(:, 6,11) = (/ &
     &5.2625e-03_r8,7.5549e-03_r8,1.0521e-02_r8,1.4321e-02_r8,1.8906e-02_r8/)
      kao(:, 7,11) = (/ &
     &1.3421e-03_r8,5.0016e-03_r8,8.2742e-03_r8,1.0825e-02_r8,1.4096e-02_r8/)
      kao(:, 8,11) = (/ &
     &1.1288e-03_r8,2.7904e-03_r8,2.9048e-03_r8,3.8915e-03_r8,1.0764e-02_r8/)
      kao(:, 9,11) = (/ &
     &1.1212e-03_r8,3.3992e-03_r8,2.3130e-03_r8,2.5518e-03_r8,6.4495e-03_r8/)
      kao(:,10,11) = (/ &
     &2.4789e-05_r8,3.8028e-05_r8,7.9034e-03_r8,4.9082e-03_r8,4.7487e-03_r8/)
      kao(:,11,11) = (/ &
     &1.5630e-05_r8,2.4780e-05_r8,3.4663e-05_r8,4.3353e-05_r8,1.1174e-02_r8/)
      kao(:,12,11) = (/ &
     &1.2516e-05_r8,1.8590e-05_r8,2.5768e-05_r8,3.2997e-05_r8,7.6429e-03_r8/)
      kao(:,13,11) = (/ &
     &9.1474e-06_r8,1.3280e-05_r8,1.7796e-05_r8,2.4600e-05_r8,8.5245e-03_r8/)
      kao(:, 1,12) = (/ &
     &1.9137e-02_r8,2.4205e-02_r8,3.0237e-02_r8,3.7229e-02_r8,4.5273e-02_r8/)
      kao(:, 2,12) = (/ &
     &1.6304e-02_r8,2.1414e-02_r8,2.7665e-02_r8,3.5151e-02_r8,4.3535e-02_r8/)
      kao(:, 3,12) = (/ &
     &1.3446e-02_r8,1.8468e-02_r8,2.4699e-02_r8,3.1802e-02_r8,4.0159e-02_r8/)
      kao(:, 4,12) = (/ &
     &1.0988e-02_r8,1.5565e-02_r8,2.1262e-02_r8,2.7914e-02_r8,3.5968e-02_r8/)
      kao(:, 5,12) = (/ &
     &9.1659e-03_r8,1.3233e-02_r8,1.8175e-02_r8,2.4059e-02_r8,3.1596e-02_r8/)
      kao(:, 6,12) = (/ &
     &7.6758e-03_r8,1.1199e-02_r8,1.5520e-02_r8,2.0906e-02_r8,2.7754e-02_r8/)
      kao(:, 7,12) = (/ &
     &5.4756e-03_r8,9.3901e-03_r8,1.3292e-02_r8,1.8129e-02_r8,2.3738e-02_r8/)
      kao(:, 8,12) = (/ &
     &8.4306e-04_r8,3.0332e-03_r8,3.5332e-03_r8,1.1602e-02_r8,1.7968e-02_r8/)
      kao(:, 9,12) = (/ &
     &1.4946e-03_r8,1.5749e-03_r8,3.2158e-03_r8,3.1867e-03_r8,3.5737e-03_r8/)
      kao(:,10,12) = (/ &
     &2.3105e-05_r8,3.7657e-05_r8,5.4692e-05_r8,1.0942e-02_r8,7.6646e-03_r8/)
      kao(:,11,12) = (/ &
     &1.6278e-05_r8,2.6849e-05_r8,3.8655e-05_r8,5.4498e-05_r8,7.7401e-03_r8/)
      kao(:,12,12) = (/ &
     &1.1713e-05_r8,1.9330e-05_r8,2.9159e-05_r8,3.9386e-05_r8,5.6995e-05_r8/)
      kao(:,13,12) = (/ &
     &9.2970e-06_r8,1.5197e-05_r8,2.2881e-05_r8,3.3051e-05_r8,4.6248e-05_r8/)
      kao(:, 1,13) = (/ &
     &3.6366e-02_r8,4.6887e-02_r8,5.8513e-02_r8,7.0986e-02_r8,8.4117e-02_r8/)
      kao(:, 2,13) = (/ &
     &3.3990e-02_r8,4.3857e-02_r8,5.4708e-02_r8,6.6354e-02_r8,7.9156e-02_r8/)
      kao(:, 3,13) = (/ &
     &2.8482e-02_r8,3.7147e-02_r8,4.6806e-02_r8,5.7889e-02_r8,7.0408e-02_r8/)
      kao(:, 4,13) = (/ &
     &2.2450e-02_r8,2.9975e-02_r8,3.8835e-02_r8,4.9297e-02_r8,6.1450e-02_r8/)
      kao(:, 5,13) = (/ &
     &1.7322e-02_r8,2.3874e-02_r8,3.2063e-02_r8,4.2032e-02_r8,5.3868e-02_r8/)
      kao(:, 6,13) = (/ &
     &1.3022e-02_r8,1.8695e-02_r8,2.6114e-02_r8,3.5380e-02_r8,4.6717e-02_r8/)
      kao(:, 7,13) = (/ &
     &9.9635e-03_r8,1.4798e-02_r8,2.1337e-02_r8,2.9901e-02_r8,4.0578e-02_r8/)
      kao(:, 8,13) = (/ &
     &9.7470e-04_r8,2.7616e-03_r8,1.5907e-02_r8,2.2415e-02_r8,2.7492e-02_r8/)
      kao(:, 9,13) = (/ &
     &1.9362e-03_r8,1.8145e-03_r8,4.1737e-03_r8,3.7651e-03_r8,6.5913e-03_r8/)
      kao(:,10,13) = (/ &
     &2.8915e-05_r8,4.8621e-05_r8,6.9201e-05_r8,8.4840e-03_r8,1.1790e-02_r8/)
      kao(:,11,13) = (/ &
     &2.3309e-05_r8,3.4553e-05_r8,5.2552e-05_r8,7.2505e-05_r8,8.3347e-05_r8/)
      kao(:,12,13) = (/ &
     &1.5870e-05_r8,2.3577e-05_r8,3.4029e-05_r8,5.3277e-05_r8,6.5207e-05_r8/)
      kao(:,13,13) = (/ &
     &1.1931e-05_r8,1.9929e-05_r8,2.7393e-05_r8,3.2822e-05_r8,4.4265e-05_r8/)
      kao(:, 1,14) = (/ &
     &6.9682e-02_r8,8.7076e-02_r8,1.0644e-01_r8,1.2772e-01_r8,1.5052e-01_r8/)
      kao(:, 2,14) = (/ &
     &6.7443e-02_r8,8.6048e-02_r8,1.0697e-01_r8,1.3011e-01_r8,1.5516e-01_r8/)
      kao(:, 3,14) = (/ &
     &6.1305e-02_r8,8.0158e-02_r8,1.0175e-01_r8,1.2582e-01_r8,1.5220e-01_r8/)
      kao(:, 4,14) = (/ &
     &5.3357e-02_r8,7.1652e-02_r8,9.2935e-02_r8,1.1706e-01_r8,1.4376e-01_r8/)
      kao(:, 5,14) = (/ &
     &4.5060e-02_r8,6.2229e-02_r8,8.2609e-02_r8,1.0608e-01_r8,1.3238e-01_r8/)
      kao(:, 6,14) = (/ &
     &3.6438e-02_r8,5.1966e-02_r8,7.0824e-02_r8,9.2958e-02_r8,1.1819e-01_r8/)
      kao(:, 7,14) = (/ &
     &2.8491e-02_r8,4.2112e-02_r8,5.9112e-02_r8,7.9508e-02_r8,1.0325e-01_r8/)
      kao(:, 8,14) = (/ &
     &1.8236e-02_r8,3.3304e-02_r8,4.8438e-02_r8,6.6896e-02_r8,8.8683e-02_r8/)
      kao(:, 9,14) = (/ &
     &2.4537e-03_r8,2.3453e-03_r8,8.8067e-03_r8,2.0762e-02_r8,4.5513e-02_r8/)
      kao(:,10,14) = (/ &
     &1.4330e-05_r8,1.7518e-05_r8,3.1868e-05_r8,4.9025e-05_r8,3.3153e-02_r8/)
      kao(:,11,14) = (/ &
     &1.4087e-05_r8,2.3580e-05_r8,3.6793e-05_r8,4.1734e-05_r8,4.2976e-05_r8/)
      kao(:,12,14) = (/ &
     &1.3087e-05_r8,2.2036e-05_r8,3.4770e-05_r8,3.7226e-05_r8,3.8663e-05_r8/)
      kao(:,13,14) = (/ &
     &6.3004e-06_r8,7.4647e-06_r8,1.3256e-05_r8,1.9422e-05_r8,2.7358e-05_r8/)
      kao(:, 1,15) = (/ &
     &1.0457e-01_r8,1.3337e-01_r8,1.6543e-01_r8,2.0044e-01_r8,2.3788e-01_r8/)
      kao(:, 2,15) = (/ &
     &1.1420e-01_r8,1.4734e-01_r8,1.8451e-01_r8,2.2524e-01_r8,2.6907e-01_r8/)
      kao(:, 3,15) = (/ &
     &1.1631e-01_r8,1.5291e-01_r8,1.9437e-01_r8,2.4033e-01_r8,2.9013e-01_r8/)
      kao(:, 4,15) = (/ &
     &1.1302e-01_r8,1.5183e-01_r8,1.9657e-01_r8,2.4665e-01_r8,3.0148e-01_r8/)
      kao(:, 5,15) = (/ &
     &1.0669e-01_r8,1.4681e-01_r8,1.9375e-01_r8,2.4698e-01_r8,3.0586e-01_r8/)
      kao(:, 6,15) = (/ &
     &9.6727e-02_r8,1.3681e-01_r8,1.8458e-01_r8,2.3961e-01_r8,3.0104e-01_r8/)
      kao(:, 7,15) = (/ &
     &8.4990e-02_r8,1.2388e-01_r8,1.7124e-01_r8,2.2660e-01_r8,2.8964e-01_r8/)
      kao(:, 8,15) = (/ &
     &7.2581e-02_r8,1.0932e-01_r8,1.5506e-01_r8,2.1052e-01_r8,2.7593e-01_r8/)
      kao(:, 9,15) = (/ &
     &2.1552e-02_r8,6.6962e-02_r8,1.2166e-01_r8,1.8985e-01_r8,2.2620e-01_r8/)
      kao(:,10,15) = (/ &
     &8.5757e-06_r8,7.9319e-06_r8,7.5384e-06_r8,5.2149e-06_r8,3.5776e-06_r8/)
      kao(:,11,15) = (/ &
     &7.3855e-06_r8,7.4681e-06_r8,7.1804e-06_r8,6.5771e-06_r8,3.3890e-06_r8/)
      kao(:,12,15) = (/ &
     &5.9318e-06_r8,6.7082e-06_r8,7.4828e-06_r8,6.0815e-06_r8,3.2500e-06_r8/)
      kao(:,13,15) = (/ &
     &7.9734e-06_r8,1.0467e-05_r8,1.8551e-05_r8,3.3018e-05_r8,1.4396e-05_r8/)
      kao(:, 1,16) = (/ &
     &1.0940e-01_r8,1.4000e-01_r8,1.7421e-01_r8,2.1173e-01_r8,2.5214e-01_r8/)
      kao(:, 2,16) = (/ &
     &1.2207e-01_r8,1.5824e-01_r8,1.9908e-01_r8,2.4418e-01_r8,2.9310e-01_r8/)
      kao(:, 3,16) = (/ &
     &1.2803e-01_r8,1.6941e-01_r8,2.1687e-01_r8,2.6992e-01_r8,3.2810e-01_r8/)
      kao(:, 4,16) = (/ &
     &1.2912e-01_r8,1.7512e-01_r8,2.2885e-01_r8,2.8989e-01_r8,3.5760e-01_r8/)
      kao(:, 5,16) = (/ &
     &1.2782e-01_r8,1.7809e-01_r8,2.3798e-01_r8,3.0717e-01_r8,3.8500e-01_r8/)
      kao(:, 6,16) = (/ &
     &1.2288e-01_r8,1.7665e-01_r8,2.4226e-01_r8,3.1945e-01_r8,4.0769e-01_r8/)
      kao(:, 7,16) = (/ &
     &1.1601e-01_r8,1.7265e-01_r8,2.4356e-01_r8,3.2874e-01_r8,4.2783e-01_r8/)
      kao(:, 8,16) = (/ &
     &1.0802e-01_r8,1.6690e-01_r8,2.4265e-01_r8,3.3582e-01_r8,4.4617e-01_r8/)
      kao(:, 9,16) = (/ &
     &9.8584e-02_r8,1.5878e-01_r8,2.3864e-01_r8,3.3924e-01_r8,4.6085e-01_r8/)
      kao(:,10,16) = (/ &
     &2.5370e-06_r8,3.6996e-06_r8,5.1180e-06_r8,9.0911e-06_r8,1.0521e-05_r8/)
      kao(:,11,16) = (/ &
     &2.1410e-06_r8,3.1393e-06_r8,2.7559e-06_r8,9.6933e-06_r8,1.1052e-05_r8/)
      kao(:,12,16) = (/ &
     &1.7911e-06_r8,2.0648e-06_r8,1.9476e-06_r8,1.0250e-05_r8,1.1569e-05_r8/)
      kao(:,13,16) = (/ &
     &6.8424e-07_r8,2.1307e-05_r8,3.0235e-05_r8,1.0419e-05_r8,1.1877e-05_r8/)

!     The array KBO contains absorption coefs at the 16 chosen g-values 
!     for a range of pressure levels < ~100mb and temperatures. The first 
!     index in the array, JT, which runs from 1 to 5, corresponds to 
!     different temperatures.  More specifically, JT = 3 means that the 
!     data are for the reference temperature TREF for this pressure 
!     level, JT = 2 refers to the temperature TREF-15, JT = 1 is for
!     TREF-30, JT = 4 is for TREF+15, and JT = 5 is for TREF+30.  
!     The second index, JP, runs from 13 to 59 and refers to the JPth
!     reference pressure level (see taumol.f for the value of these
!     pressure levels in mb).  The third index, IG, goes from 1 to 16,
!     and tells us which g-interval the absorption coefficients are for.

      kbo(:,13, 1) = (/ &
     &2.1590e-02_r8,2.2747e-02_r8,2.3755e-02_r8,2.4762e-02_r8,2.5739e-02_r8/)
      kbo(:,14, 1) = (/ &
     &1.5891e-02_r8,1.6865e-02_r8,1.7785e-02_r8,1.8588e-02_r8,1.9375e-02_r8/)
      kbo(:,15, 1) = (/ &
     &1.2008e-02_r8,1.2891e-02_r8,1.3700e-02_r8,1.4369e-02_r8,1.4970e-02_r8/)
      kbo(:,16, 1) = (/ &
     &9.5594e-03_r8,1.0266e-02_r8,1.0893e-02_r8,1.1429e-02_r8,1.1863e-02_r8/)
      kbo(:,17, 1) = (/ &
     &7.6979e-03_r8,8.2617e-03_r8,8.7527e-03_r8,9.1620e-03_r8,9.5161e-03_r8/)
      kbo(:,18, 1) = (/ &
     &6.2689e-03_r8,6.7130e-03_r8,7.1029e-03_r8,7.4199e-03_r8,7.7032e-03_r8/)
      kbo(:,19, 1) = (/ &
     &5.1124e-03_r8,5.4669e-03_r8,5.7636e-03_r8,6.0175e-03_r8,6.2439e-03_r8/)
      kbo(:,20, 1) = (/ &
     &4.2074e-03_r8,4.4879e-03_r8,4.7226e-03_r8,4.9240e-03_r8,5.1066e-03_r8/)
      kbo(:,21, 1) = (/ &
     &3.4689e-03_r8,3.6905e-03_r8,3.8771e-03_r8,4.0402e-03_r8,4.1874e-03_r8/)
      kbo(:,22, 1) = (/ &
     &2.8675e-03_r8,3.0422e-03_r8,3.1923e-03_r8,3.3247e-03_r8,3.4419e-03_r8/)
      kbo(:,23, 1) = (/ &
     &2.3673e-03_r8,2.5068e-03_r8,2.6269e-03_r8,2.7338e-03_r8,2.8272e-03_r8/)
      kbo(:,24, 1) = (/ &
     &1.9512e-03_r8,2.0620e-03_r8,2.1580e-03_r8,2.2436e-03_r8,2.3178e-03_r8/)
      kbo(:,25, 1) = (/ &
     &1.6104e-03_r8,1.6991e-03_r8,1.7756e-03_r8,1.8445e-03_r8,1.9031e-03_r8/)
      kbo(:,26, 1) = (/ &
     &1.3324e-03_r8,1.4030e-03_r8,1.4641e-03_r8,1.5181e-03_r8,1.5647e-03_r8/)
      kbo(:,27, 1) = (/ &
     &1.1030e-03_r8,1.1588e-03_r8,1.2079e-03_r8,1.2506e-03_r8,1.2885e-03_r8/)
      kbo(:,28, 1) = (/ &
     &9.1277e-04_r8,9.5694e-04_r8,9.9621e-04_r8,1.0308e-03_r8,1.0603e-03_r8/)
      kbo(:,29, 1) = (/ &
     &7.5709e-04_r8,7.9257e-04_r8,8.2415e-04_r8,8.5205e-04_r8,8.7500e-04_r8/)
      kbo(:,30, 1) = (/ &
     &6.2805e-04_r8,6.5667e-04_r8,6.8205e-04_r8,7.0403e-04_r8,7.2224e-04_r8/)
      kbo(:,31, 1) = (/ &
     &5.2190e-04_r8,5.4469e-04_r8,5.6521e-04_r8,5.8274e-04_r8,5.9713e-04_r8/)
      kbo(:,32, 1) = (/ &
     &4.3349e-04_r8,4.5214e-04_r8,4.6842e-04_r8,4.8237e-04_r8,4.9367e-04_r8/)
      kbo(:,33, 1) = (/ &
     &3.5999e-04_r8,3.7522e-04_r8,3.8828e-04_r8,3.9917e-04_r8,4.0831e-04_r8/)
      kbo(:,34, 1) = (/ &
     &2.9885e-04_r8,3.1108e-04_r8,3.2123e-04_r8,3.3020e-04_r8,3.3735e-04_r8/)
      kbo(:,35, 1) = (/ &
     &2.4686e-04_r8,2.5649e-04_r8,2.6489e-04_r8,2.7217e-04_r8,2.7798e-04_r8/)
      kbo(:,36, 1) = (/ &
     &2.0249e-04_r8,2.1050e-04_r8,2.1752e-04_r8,2.2349e-04_r8,2.2845e-04_r8/)
      kbo(:,37, 1) = (/ &
     &1.6556e-04_r8,1.7221e-04_r8,1.7821e-04_r8,1.8323e-04_r8,1.8756e-04_r8/)
      kbo(:,38, 1) = (/ &
     &1.3530e-04_r8,1.4093e-04_r8,1.4599e-04_r8,1.5028e-04_r8,1.5406e-04_r8/)
      kbo(:,39, 1) = (/ &
     &1.1062e-04_r8,1.1539e-04_r8,1.1961e-04_r8,1.2331e-04_r8,1.2663e-04_r8/)
      kbo(:,40, 1) = (/ &
     &8.9884e-05_r8,9.3980e-05_r8,9.7546e-05_r8,1.0075e-04_r8,1.0361e-04_r8/)
      kbo(:,41, 1) = (/ &
     &7.2964e-05_r8,7.6433e-05_r8,7.9468e-05_r8,8.2219e-05_r8,8.4723e-05_r8/)
      kbo(:,42, 1) = (/ &
     &5.9182e-05_r8,6.2146e-05_r8,6.4721e-05_r8,6.7085e-05_r8,6.9267e-05_r8/)
      kbo(:,43, 1) = (/ &
     &4.7864e-05_r8,5.0382e-05_r8,5.2591e-05_r8,5.4634e-05_r8,5.6528e-05_r8/)
      kbo(:,44, 1) = (/ &
     &3.8628e-05_r8,4.0783e-05_r8,4.2701e-05_r8,4.4436e-05_r8,4.6114e-05_r8/)
      kbo(:,45, 1) = (/ &
     &3.1127e-05_r8,3.3002e-05_r8,3.4654e-05_r8,3.6151e-05_r8,3.7566e-05_r8/)
      kbo(:,46, 1) = (/ &
     &2.5026e-05_r8,2.6649e-05_r8,2.8068e-05_r8,2.9367e-05_r8,3.0563e-05_r8/)
      kbo(:,47, 1) = (/ &
     &2.0040e-05_r8,2.1423e-05_r8,2.2656e-05_r8,2.3781e-05_r8,2.4816e-05_r8/)
      kbo(:,48, 1) = (/ &
     &1.6036e-05_r8,1.7209e-05_r8,1.8283e-05_r8,1.9267e-05_r8,2.0138e-05_r8/)
      kbo(:,49, 1) = (/ &
     &1.2828e-05_r8,1.3830e-05_r8,1.4752e-05_r8,1.5602e-05_r8,1.6354e-05_r8/)
      kbo(:,50, 1) = (/ &
     &1.0257e-05_r8,1.1106e-05_r8,1.1884e-05_r8,1.2616e-05_r8,1.3265e-05_r8/)
      kbo(:,51, 1) = (/ &
     &8.1934e-06_r8,8.9110e-06_r8,9.5669e-06_r8,1.0186e-05_r8,1.0748e-05_r8/)
      kbo(:,52, 1) = (/ &
     &6.5467e-06_r8,7.1424e-06_r8,7.7065e-06_r8,8.2286e-06_r8,8.7123e-06_r8/)
      kbo(:,53, 1) = (/ &
     &5.2332e-06_r8,5.7328e-06_r8,6.2119e-06_r8,6.6510e-06_r8,7.0700e-06_r8/)
      kbo(:,54, 1) = (/ &
     &4.1577e-06_r8,4.5779e-06_r8,4.9804e-06_r8,5.3498e-06_r8,5.7020e-06_r8/)
      kbo(:,55, 1) = (/ &
     &3.2878e-06_r8,3.6403e-06_r8,3.9741e-06_r8,4.2805e-06_r8,4.5760e-06_r8/)
      kbo(:,56, 1) = (/ &
     &2.5965e-06_r8,2.8911e-06_r8,3.1663e-06_r8,3.4265e-06_r8,3.6666e-06_r8/)
      kbo(:,57, 1) = (/ &
     &2.0466e-06_r8,2.2908e-06_r8,2.5217e-06_r8,2.7403e-06_r8,2.9373e-06_r8/)
      kbo(:,58, 1) = (/ &
     &1.6093e-06_r8,1.8128e-06_r8,2.0059e-06_r8,2.1882e-06_r8,2.3529e-06_r8/)
      kbo(:,59, 1) = (/ &
     &1.2776e-06_r8,1.4459e-06_r8,1.6042e-06_r8,1.7524e-06_r8,1.8906e-06_r8/)
      kbo(:,13, 2) = (/ &
     &3.8014e-02_r8,3.9737e-02_r8,4.1825e-02_r8,4.3879e-02_r8,4.5802e-02_r8/)
      kbo(:,14, 2) = (/ &
     &3.0759e-02_r8,3.2195e-02_r8,3.3860e-02_r8,3.5735e-02_r8,3.7445e-02_r8/)
      kbo(:,15, 2) = (/ &
     &2.4737e-02_r8,2.6065e-02_r8,2.7499e-02_r8,2.8985e-02_r8,3.0345e-02_r8/)
      kbo(:,16, 2) = (/ &
     &2.0386e-02_r8,2.1604e-02_r8,2.2870e-02_r8,2.4062e-02_r8,2.5169e-02_r8/)
      kbo(:,17, 2) = (/ &
     &1.6973e-02_r8,1.8030e-02_r8,1.9046e-02_r8,1.9999e-02_r8,2.0836e-02_r8/)
      kbo(:,18, 2) = (/ &
     &1.4179e-02_r8,1.5045e-02_r8,1.5843e-02_r8,1.6598e-02_r8,1.7207e-02_r8/)
      kbo(:,19, 2) = (/ &
     &1.1784e-02_r8,1.2488e-02_r8,1.3131e-02_r8,1.3688e-02_r8,1.4139e-02_r8/)
      kbo(:,20, 2) = (/ &
     &9.8208e-03_r8,1.0377e-02_r8,1.0872e-02_r8,1.1296e-02_r8,1.1641e-02_r8/)
      kbo(:,21, 2) = (/ &
     &8.1632e-03_r8,8.5996e-03_r8,8.9808e-03_r8,9.3040e-03_r8,9.5696e-03_r8/)
      kbo(:,22, 2) = (/ &
     &6.7970e-03_r8,7.1290e-03_r8,7.4204e-03_r8,7.6665e-03_r8,7.8692e-03_r8/)
      kbo(:,23, 2) = (/ &
     &5.6384e-03_r8,5.8917e-03_r8,6.1228e-03_r8,6.3098e-03_r8,6.4698e-03_r8/)
      kbo(:,24, 2) = (/ &
     &4.6602e-03_r8,4.8595e-03_r8,5.0396e-03_r8,5.1884e-03_r8,5.3131e-03_r8/)
      kbo(:,25, 2) = (/ &
     &3.8492e-03_r8,4.0101e-03_r8,4.1507e-03_r8,4.2656e-03_r8,4.3666e-03_r8/)
      kbo(:,26, 2) = (/ &
     &3.1817e-03_r8,3.3089e-03_r8,3.4202e-03_r8,3.5130e-03_r8,3.5943e-03_r8/)
      kbo(:,27, 2) = (/ &
     &2.6312e-03_r8,2.7340e-03_r8,2.8215e-03_r8,2.8952e-03_r8,2.9585e-03_r8/)
      kbo(:,28, 2) = (/ &
     &2.1766e-03_r8,2.2592e-03_r8,2.3277e-03_r8,2.3874e-03_r8,2.4369e-03_r8/)
      kbo(:,29, 2) = (/ &
     &1.8050e-03_r8,1.8690e-03_r8,1.9243e-03_r8,1.9721e-03_r8,2.0134e-03_r8/)
      kbo(:,30, 2) = (/ &
     &1.4965e-03_r8,1.5474e-03_r8,1.5922e-03_r8,1.6307e-03_r8,1.6644e-03_r8/)
      kbo(:,31, 2) = (/ &
     &1.2416e-03_r8,1.2835e-03_r8,1.3200e-03_r8,1.3519e-03_r8,1.3783e-03_r8/)
      kbo(:,32, 2) = (/ &
     &1.0308e-03_r8,1.0652e-03_r8,1.0950e-03_r8,1.1207e-03_r8,1.1427e-03_r8/)
      kbo(:,33, 2) = (/ &
     &8.5698e-04_r8,8.8430e-04_r8,9.0863e-04_r8,9.2966e-04_r8,9.4803e-04_r8/)
      kbo(:,34, 2) = (/ &
     &7.1109e-04_r8,7.3332e-04_r8,7.5331e-04_r8,7.7074e-04_r8,7.8601e-04_r8/)
      kbo(:,35, 2) = (/ &
     &5.8729e-04_r8,6.0603e-04_r8,6.2268e-04_r8,6.3737e-04_r8,6.5045e-04_r8/)
      kbo(:,36, 2) = (/ &
     &4.8310e-04_r8,4.9861e-04_r8,5.1251e-04_r8,5.2508e-04_r8,5.3615e-04_r8/)
      kbo(:,37, 2) = (/ &
     &3.9625e-04_r8,4.0955e-04_r8,4.2151e-04_r8,4.3225e-04_r8,4.4172e-04_r8/)
      kbo(:,38, 2) = (/ &
     &3.2503e-04_r8,3.3643e-04_r8,3.4664e-04_r8,3.5587e-04_r8,3.6445e-04_r8/)
      kbo(:,39, 2) = (/ &
     &2.6664e-04_r8,2.7639e-04_r8,2.8514e-04_r8,2.9332e-04_r8,3.0098e-04_r8/)
      kbo(:,40, 2) = (/ &
     &2.1759e-04_r8,2.2608e-04_r8,2.3348e-04_r8,2.4050e-04_r8,2.4712e-04_r8/)
      kbo(:,41, 2) = (/ &
     &1.7739e-04_r8,1.8462e-04_r8,1.9097e-04_r8,1.9703e-04_r8,2.0268e-04_r8/)
      kbo(:,42, 2) = (/ &
     &1.4453e-04_r8,1.5070e-04_r8,1.5612e-04_r8,1.6130e-04_r8,1.6626e-04_r8/)
      kbo(:,43, 2) = (/ &
     &1.1750e-04_r8,1.2276e-04_r8,1.2736e-04_r8,1.3185e-04_r8,1.3616e-04_r8/)
      kbo(:,44, 2) = (/ &
     &9.5367e-05_r8,9.9857e-05_r8,1.0380e-04_r8,1.0768e-04_r8,1.1140e-04_r8/)
      kbo(:,45, 2) = (/ &
     &7.7428e-05_r8,8.1152e-05_r8,8.4582e-05_r8,8.7898e-05_r8,9.1175e-05_r8/)
      kbo(:,46, 2) = (/ &
     &6.2722e-05_r8,6.5854e-05_r8,6.8828e-05_r8,7.1656e-05_r8,7.4494e-05_r8/)
      kbo(:,47, 2) = (/ &
     &5.0620e-05_r8,5.3291e-05_r8,5.5834e-05_r8,5.8234e-05_r8,6.0703e-05_r8/)
      kbo(:,48, 2) = (/ &
     &4.0839e-05_r8,4.3112e-05_r8,4.5285e-05_r8,4.7326e-05_r8,4.9468e-05_r8/)
      kbo(:,49, 2) = (/ &
     &3.2956e-05_r8,3.4871e-05_r8,3.6734e-05_r8,3.8477e-05_r8,4.0339e-05_r8/)
      kbo(:,50, 2) = (/ &
     &2.6578e-05_r8,2.8186e-05_r8,2.9765e-05_r8,3.1246e-05_r8,3.2810e-05_r8/)
      kbo(:,51, 2) = (/ &
     &2.1419e-05_r8,2.2753e-05_r8,2.4086e-05_r8,2.5342e-05_r8,2.6653e-05_r8/)
      kbo(:,52, 2) = (/ &
     &1.7265e-05_r8,1.8376e-05_r8,1.9492e-05_r8,2.0556e-05_r8,2.1651e-05_r8/)
      kbo(:,53, 2) = (/ &
     &1.3928e-05_r8,1.4844e-05_r8,1.5782e-05_r8,1.6689e-05_r8,1.7614e-05_r8/)
      kbo(:,54, 2) = (/ &
     &1.1205e-05_r8,1.1963e-05_r8,1.2726e-05_r8,1.3478e-05_r8,1.4240e-05_r8/)
      kbo(:,55, 2) = (/ &
     &8.9889e-06_r8,9.6190e-06_r8,1.0235e-05_r8,1.0868e-05_r8,1.1479e-05_r8/)
      kbo(:,56, 2) = (/ &
     &7.2032e-06_r8,7.7304e-06_r8,8.2333e-06_r8,8.7486e-06_r8,9.2547e-06_r8/)
      kbo(:,57, 2) = (/ &
     &5.7621e-06_r8,6.2097e-06_r8,6.6195e-06_r8,7.0372e-06_r8,7.4615e-06_r8/)
      kbo(:,58, 2) = (/ &
     &4.6073e-06_r8,4.9865e-06_r8,5.3240e-06_r8,5.6615e-06_r8,6.0083e-06_r8/)
      kbo(:,59, 2) = (/ &
     &3.7094e-06_r8,4.0178e-06_r8,4.3021e-06_r8,4.5755e-06_r8,4.8477e-06_r8/)
      kbo(:,13, 3) = (/ &
     &6.3405e-02_r8,6.5846e-02_r8,6.7902e-02_r8,7.0344e-02_r8,7.3087e-02_r8/)
      kbo(:,14, 3) = (/ &
     &5.1252e-02_r8,5.3361e-02_r8,5.5658e-02_r8,5.8048e-02_r8,6.0738e-02_r8/)
      kbo(:,15, 3) = (/ &
     &4.2340e-02_r8,4.4418e-02_r8,4.6657e-02_r8,4.8923e-02_r8,5.1338e-02_r8/)
      kbo(:,16, 3) = (/ &
     &3.5507e-02_r8,3.7339e-02_r8,3.9465e-02_r8,4.1652e-02_r8,4.3669e-02_r8/)
      kbo(:,17, 3) = (/ &
     &2.9824e-02_r8,3.1523e-02_r8,3.3435e-02_r8,3.5273e-02_r8,3.6953e-02_r8/)
      kbo(:,18, 3) = (/ &
     &2.5125e-02_r8,2.6683e-02_r8,2.8323e-02_r8,2.9797e-02_r8,3.1126e-02_r8/)
      kbo(:,19, 3) = (/ &
     &2.1223e-02_r8,2.2544e-02_r8,2.3820e-02_r8,2.4985e-02_r8,2.5990e-02_r8/)
      kbo(:,20, 3) = (/ &
     &1.7915e-02_r8,1.8986e-02_r8,1.9994e-02_r8,2.0861e-02_r8,2.1602e-02_r8/)
      kbo(:,21, 3) = (/ &
     &1.5062e-02_r8,1.5916e-02_r8,1.6665e-02_r8,1.7312e-02_r8,1.7872e-02_r8/)
      kbo(:,22, 3) = (/ &
     &1.2635e-02_r8,1.3292e-02_r8,1.3846e-02_r8,1.4329e-02_r8,1.4769e-02_r8/)
      kbo(:,23, 3) = (/ &
     &1.0554e-02_r8,1.1051e-02_r8,1.1464e-02_r8,1.1841e-02_r8,1.2180e-02_r8/)
      kbo(:,24, 3) = (/ &
     &8.7770e-03_r8,9.1488e-03_r8,9.4668e-03_r8,9.7625e-03_r8,1.0031e-02_r8/)
      kbo(:,25, 3) = (/ &
     &7.2756e-03_r8,7.5544e-03_r8,7.8035e-03_r8,8.0431e-03_r8,8.2495e-03_r8/)
      kbo(:,26, 3) = (/ &
     &6.0226e-03_r8,6.2378e-03_r8,6.4382e-03_r8,6.6253e-03_r8,6.7857e-03_r8/)
      kbo(:,27, 3) = (/ &
     &4.9811e-03_r8,5.1501e-03_r8,5.3115e-03_r8,5.4587e-03_r8,5.5851e-03_r8/)
      kbo(:,28, 3) = (/ &
     &4.1172e-03_r8,4.2566e-03_r8,4.3852e-03_r8,4.4995e-03_r8,4.6022e-03_r8/)
      kbo(:,29, 3) = (/ &
     &3.4101e-03_r8,3.5232e-03_r8,3.6273e-03_r8,3.7181e-03_r8,3.8009e-03_r8/)
      kbo(:,30, 3) = (/ &
     &2.8248e-03_r8,2.9164e-03_r8,2.9992e-03_r8,3.0754e-03_r8,3.1419e-03_r8/)
      kbo(:,31, 3) = (/ &
     &2.3450e-03_r8,2.4195e-03_r8,2.4879e-03_r8,2.5493e-03_r8,2.6070e-03_r8/)
      kbo(:,32, 3) = (/ &
     &1.9491e-03_r8,2.0095e-03_r8,2.0670e-03_r8,2.1190e-03_r8,2.1683e-03_r8/)
      kbo(:,33, 3) = (/ &
     &1.6195e-03_r8,1.6713e-03_r8,1.7189e-03_r8,1.7649e-03_r8,1.8032e-03_r8/)
      kbo(:,34, 3) = (/ &
     &1.3454e-03_r8,1.3883e-03_r8,1.4290e-03_r8,1.4663e-03_r8,1.4976e-03_r8/)
      kbo(:,35, 3) = (/ &
     &1.1151e-03_r8,1.1504e-03_r8,1.1846e-03_r8,1.2147e-03_r8,1.2425e-03_r8/)
      kbo(:,36, 3) = (/ &
     &9.1872e-04_r8,9.4904e-04_r8,9.7800e-04_r8,1.0033e-03_r8,1.0278e-03_r8/)
      kbo(:,37, 3) = (/ &
     &7.5556e-04_r8,7.8161e-04_r8,8.0630e-04_r8,8.2845e-04_r8,8.4914e-04_r8/)
      kbo(:,38, 3) = (/ &
     &6.2192e-04_r8,6.4458e-04_r8,6.6572e-04_r8,6.8474e-04_r8,7.0313e-04_r8/)
      kbo(:,39, 3) = (/ &
     &5.1238e-04_r8,5.3172e-04_r8,5.4973e-04_r8,5.6636e-04_r8,5.8235e-04_r8/)
      kbo(:,40, 3) = (/ &
     &4.1982e-04_r8,4.3621e-04_r8,4.5139e-04_r8,4.6596e-04_r8,4.7961e-04_r8/)
      kbo(:,41, 3) = (/ &
     &3.4388e-04_r8,3.5746e-04_r8,3.7054e-04_r8,3.8291e-04_r8,3.9470e-04_r8/)
      kbo(:,42, 3) = (/ &
     &2.8144e-04_r8,2.9295e-04_r8,3.0424e-04_r8,3.1457e-04_r8,3.2459e-04_r8/)
      kbo(:,43, 3) = (/ &
     &2.2990e-04_r8,2.3955e-04_r8,2.4928e-04_r8,2.5827e-04_r8,2.6672e-04_r8/)
      kbo(:,44, 3) = (/ &
     &1.8744e-04_r8,1.9582e-04_r8,2.0413e-04_r8,2.1176e-04_r8,2.1912e-04_r8/)
      kbo(:,45, 3) = (/ &
     &1.5285e-04_r8,1.6000e-04_r8,1.6711e-04_r8,1.7363e-04_r8,1.7993e-04_r8/)
      kbo(:,46, 3) = (/ &
     &1.2448e-04_r8,1.3059e-04_r8,1.3656e-04_r8,1.4216e-04_r8,1.4758e-04_r8/)
      kbo(:,47, 3) = (/ &
     &1.0103e-04_r8,1.0628e-04_r8,1.1130e-04_r8,1.1611e-04_r8,1.2074e-04_r8/)
      kbo(:,48, 3) = (/ &
     &8.1983e-05_r8,8.6504e-05_r8,9.0728e-05_r8,9.4862e-05_r8,9.8826e-05_r8/)
      kbo(:,49, 3) = (/ &
     &6.6563e-05_r8,7.0429e-05_r8,7.4014e-05_r8,7.7542e-05_r8,8.0976e-05_r8/)
      kbo(:,50, 3) = (/ &
     &5.3952e-05_r8,5.7235e-05_r8,6.0247e-05_r8,6.3258e-05_r8,6.6182e-05_r8/)
      kbo(:,51, 3) = (/ &
     &4.3663e-05_r8,4.6470e-05_r8,4.9001e-05_r8,5.1519e-05_r8,5.4013e-05_r8/)
      kbo(:,52, 3) = (/ &
     &3.5323e-05_r8,3.7705e-05_r8,3.9846e-05_r8,4.1973e-05_r8,4.4086e-05_r8/)
      kbo(:,53, 3) = (/ &
     &2.8583e-05_r8,3.0614e-05_r8,3.2428e-05_r8,3.4214e-05_r8,3.6024e-05_r8/)
      kbo(:,54, 3) = (/ &
     &2.3052e-05_r8,2.4741e-05_r8,2.6291e-05_r8,2.7754e-05_r8,2.9233e-05_r8/)
      kbo(:,55, 3) = (/ &
     &1.8532e-05_r8,1.9924e-05_r8,2.1226e-05_r8,2.2443e-05_r8,2.3644e-05_r8/)
      kbo(:,56, 3) = (/ &
     &1.4892e-05_r8,1.6026e-05_r8,1.7132e-05_r8,1.8148e-05_r8,1.9127e-05_r8/)
      kbo(:,57, 3) = (/ &
     &1.1957e-05_r8,1.2880e-05_r8,1.3809e-05_r8,1.4669e-05_r8,1.5458e-05_r8/)
      kbo(:,58, 3) = (/ &
     &9.6000e-06_r8,1.0349e-05_r8,1.1127e-05_r8,1.1847e-05_r8,1.2497e-05_r8/)
      kbo(:,59, 3) = (/ &
     &7.7452e-06_r8,8.3627e-06_r8,8.9895e-06_r8,9.5703e-06_r8,1.0120e-05_r8/)
      kbo(:,13, 4) = (/ &
     &9.9915e-02_r8,1.0385e-01_r8,1.0749e-01_r8,1.1095e-01_r8,1.1480e-01_r8/)
      kbo(:,14, 4) = (/ &
     &8.4174e-02_r8,8.7314e-02_r8,9.0833e-02_r8,9.4040e-02_r8,9.7483e-02_r8/)
      kbo(:,15, 4) = (/ &
     &7.1798e-02_r8,7.3772e-02_r8,7.6218e-02_r8,7.9303e-02_r8,8.2911e-02_r8/)
      kbo(:,16, 4) = (/ &
     &6.0987e-02_r8,6.2861e-02_r8,6.5027e-02_r8,6.7869e-02_r8,7.1492e-02_r8/)
      kbo(:,17, 4) = (/ &
     &5.1988e-02_r8,5.3759e-02_r8,5.5853e-02_r8,5.8672e-02_r8,6.1980e-02_r8/)
      kbo(:,18, 4) = (/ &
     &4.4171e-02_r8,4.5935e-02_r8,4.8095e-02_r8,5.0759e-02_r8,5.3616e-02_r8/)
      kbo(:,19, 4) = (/ &
     &3.7411e-02_r8,3.9215e-02_r8,4.1337e-02_r8,4.3631e-02_r8,4.5910e-02_r8/)
      kbo(:,20, 4) = (/ &
     &3.1780e-02_r8,3.3510e-02_r8,3.5386e-02_r8,3.7312e-02_r8,3.9095e-02_r8/)
      kbo(:,21, 4) = (/ &
     &2.6954e-02_r8,2.8513e-02_r8,3.0099e-02_r8,3.1617e-02_r8,3.2915e-02_r8/)
      kbo(:,22, 4) = (/ &
     &2.2888e-02_r8,2.4194e-02_r8,2.5477e-02_r8,2.6596e-02_r8,2.7511e-02_r8/)
      kbo(:,23, 4) = (/ &
     &1.9346e-02_r8,2.0404e-02_r8,2.1382e-02_r8,2.2165e-02_r8,2.2830e-02_r8/)
      kbo(:,24, 4) = (/ &
     &1.6247e-02_r8,1.7083e-02_r8,1.7781e-02_r8,1.8353e-02_r8,1.8851e-02_r8/)
      kbo(:,25, 4) = (/ &
     &1.3597e-02_r8,1.4221e-02_r8,1.4742e-02_r8,1.5163e-02_r8,1.5551e-02_r8/)
      kbo(:,26, 4) = (/ &
     &1.1347e-02_r8,1.1808e-02_r8,1.2193e-02_r8,1.2519e-02_r8,1.2827e-02_r8/)
      kbo(:,27, 4) = (/ &
     &9.4352e-03_r8,9.7820e-03_r8,1.0071e-02_r8,1.0331e-02_r8,1.0583e-02_r8/)
      kbo(:,28, 4) = (/ &
     &7.8281e-03_r8,8.0857e-03_r8,8.3110e-03_r8,8.5276e-03_r8,8.7304e-03_r8/)
      kbo(:,29, 4) = (/ &
     &6.4877e-03_r8,6.6881e-03_r8,6.8753e-03_r8,7.0489e-03_r8,7.2105e-03_r8/)
      kbo(:,30, 4) = (/ &
     &5.3741e-03_r8,5.5372e-03_r8,5.6910e-03_r8,5.8358e-03_r8,5.9652e-03_r8/)
      kbo(:,31, 4) = (/ &
     &4.4624e-03_r8,4.5974e-03_r8,4.7269e-03_r8,4.8416e-03_r8,4.9477e-03_r8/)
      kbo(:,32, 4) = (/ &
     &3.7110e-03_r8,3.8251e-03_r8,3.9302e-03_r8,4.0264e-03_r8,4.1112e-03_r8/)
      kbo(:,33, 4) = (/ &
     &3.0918e-03_r8,3.1864e-03_r8,3.2713e-03_r8,3.3504e-03_r8,3.4219e-03_r8/)
      kbo(:,34, 4) = (/ &
     &2.5734e-03_r8,2.6501e-03_r8,2.7238e-03_r8,2.7897e-03_r8,2.8499e-03_r8/)
      kbo(:,35, 4) = (/ &
     &2.1361e-03_r8,2.2030e-03_r8,2.2659e-03_r8,2.3224e-03_r8,2.3696e-03_r8/)
      kbo(:,36, 4) = (/ &
     &1.7673e-03_r8,1.8262e-03_r8,1.8805e-03_r8,1.9284e-03_r8,1.9688e-03_r8/)
      kbo(:,37, 4) = (/ &
     &1.4584e-03_r8,1.5086e-03_r8,1.5546e-03_r8,1.5960e-03_r8,1.6338e-03_r8/)
      kbo(:,38, 4) = (/ &
     &1.2034e-03_r8,1.2453e-03_r8,1.2856e-03_r8,1.3227e-03_r8,1.3572e-03_r8/)
      kbo(:,39, 4) = (/ &
     &9.9454e-04_r8,1.0299e-03_r8,1.0651e-03_r8,1.0982e-03_r8,1.1293e-03_r8/)
      kbo(:,40, 4) = (/ &
     &8.1766e-04_r8,8.4814e-04_r8,8.7922e-04_r8,9.0780e-04_r8,9.3604e-04_r8/)
      kbo(:,41, 4) = (/ &
     &6.7161e-04_r8,6.9882e-04_r8,7.2604e-04_r8,7.5179e-04_r8,7.7573e-04_r8/)
      kbo(:,42, 4) = (/ &
     &5.5233e-04_r8,5.7642e-04_r8,5.9983e-04_r8,6.2278e-04_r8,6.4351e-04_r8/)
      kbo(:,43, 4) = (/ &
     &4.5350e-04_r8,4.7458e-04_r8,4.9522e-04_r8,5.1500e-04_r8,5.3326e-04_r8/)
      kbo(:,44, 4) = (/ &
     &3.7202e-04_r8,3.9025e-04_r8,4.0848e-04_r8,4.2568e-04_r8,4.4143e-04_r8/)
      kbo(:,45, 4) = (/ &
     &3.0534e-04_r8,3.2126e-04_r8,3.3706e-04_r8,3.5201e-04_r8,3.6606e-04_r8/)
      kbo(:,46, 4) = (/ &
     &2.5026e-04_r8,2.6416e-04_r8,2.7768e-04_r8,2.9081e-04_r8,3.0319e-04_r8/)
      kbo(:,47, 4) = (/ &
     &2.0428e-04_r8,2.1616e-04_r8,2.2794e-04_r8,2.3946e-04_r8,2.5046e-04_r8/)
      kbo(:,48, 4) = (/ &
     &1.6667e-04_r8,1.7701e-04_r8,1.8729e-04_r8,1.9740e-04_r8,2.0693e-04_r8/)
      kbo(:,49, 4) = (/ &
     &1.3611e-04_r8,1.4498e-04_r8,1.5402e-04_r8,1.6290e-04_r8,1.7121e-04_r8/)
      kbo(:,50, 4) = (/ &
     &1.1088e-04_r8,1.1847e-04_r8,1.2631e-04_r8,1.3390e-04_r8,1.4119e-04_r8/)
      kbo(:,51, 4) = (/ &
     &9.0216e-05_r8,9.6607e-05_r8,1.0331e-04_r8,1.0986e-04_r8,1.1615e-04_r8/)
      kbo(:,52, 4) = (/ &
     &7.3423e-05_r8,7.8834e-05_r8,8.4566e-05_r8,9.0143e-05_r8,9.5562e-05_r8/)
      kbo(:,53, 4) = (/ &
     &5.9754e-05_r8,6.4377e-05_r8,6.9227e-05_r8,7.4054e-05_r8,7.8692e-05_r8/)
      kbo(:,54, 4) = (/ &
     &4.8298e-05_r8,5.2166e-05_r8,5.6219e-05_r8,6.0246e-05_r8,6.4263e-05_r8/)
      kbo(:,55, 4) = (/ &
     &3.8831e-05_r8,4.2066e-05_r8,4.5431e-05_r8,4.8757e-05_r8,5.2064e-05_r8/)
      kbo(:,56, 4) = (/ &
     &3.1190e-05_r8,3.3925e-05_r8,3.6680e-05_r8,3.9437e-05_r8,4.2169e-05_r8/)
      kbo(:,57, 4) = (/ &
     &2.5026e-05_r8,2.7326e-05_r8,2.9588e-05_r8,3.1864e-05_r8,3.4154e-05_r8/)
      kbo(:,58, 4) = (/ &
     &2.0044e-05_r8,2.1985e-05_r8,2.3836e-05_r8,2.5731e-05_r8,2.7590e-05_r8/)
      kbo(:,59, 4) = (/ &
     &1.6187e-05_r8,1.7736e-05_r8,1.9214e-05_r8,2.0762e-05_r8,2.2244e-05_r8/)
      kbo(:,13, 5) = (/ &
     &1.6183e-01_r8,1.6388e-01_r8,1.6830e-01_r8,1.7476e-01_r8,1.8120e-01_r8/)
      kbo(:,14, 5) = (/ &
     &1.4136e-01_r8,1.4390e-01_r8,1.4614e-01_r8,1.5033e-01_r8,1.5561e-01_r8/)
      kbo(:,15, 5) = (/ &
     &1.2277e-01_r8,1.2594e-01_r8,1.2862e-01_r8,1.3140e-01_r8,1.3513e-01_r8/)
      kbo(:,16, 5) = (/ &
     &1.0716e-01_r8,1.1019e-01_r8,1.1295e-01_r8,1.1569e-01_r8,1.1878e-01_r8/)
      kbo(:,17, 5) = (/ &
     &9.2722e-02_r8,9.5517e-02_r8,9.8213e-02_r8,1.0105e-01_r8,1.0426e-01_r8/)
      kbo(:,18, 5) = (/ &
     &7.9838e-02_r8,8.2414e-02_r8,8.5010e-02_r8,8.8074e-02_r8,9.1598e-02_r8/)
      kbo(:,19, 5) = (/ &
     &6.8325e-02_r8,7.0740e-02_r8,7.3430e-02_r8,7.6659e-02_r8,8.0269e-02_r8/)
      kbo(:,20, 5) = (/ &
     &5.8275e-02_r8,6.0721e-02_r8,6.3630e-02_r8,6.6772e-02_r8,7.0098e-02_r8/)
      kbo(:,21, 5) = (/ &
     &4.9672e-02_r8,5.2190e-02_r8,5.4967e-02_r8,5.7853e-02_r8,6.0822e-02_r8/)
      kbo(:,22, 5) = (/ &
     &4.2534e-02_r8,4.4900e-02_r8,4.7398e-02_r8,4.9961e-02_r8,5.2416e-02_r8/)
      kbo(:,23, 5) = (/ &
     &3.6361e-02_r8,3.8477e-02_r8,4.0633e-02_r8,4.2770e-02_r8,4.4639e-02_r8/)
      kbo(:,24, 5) = (/ &
     &3.0984e-02_r8,3.2792e-02_r8,3.4594e-02_r8,3.6198e-02_r8,3.7541e-02_r8/)
      kbo(:,25, 5) = (/ &
     &2.6322e-02_r8,2.7818e-02_r8,2.9192e-02_r8,3.0375e-02_r8,3.1335e-02_r8/)
      kbo(:,26, 5) = (/ &
     &2.2285e-02_r8,2.3473e-02_r8,2.4485e-02_r8,2.5360e-02_r8,2.6084e-02_r8/)
      kbo(:,27, 5) = (/ &
     &1.8777e-02_r8,1.9670e-02_r8,2.0440e-02_r8,2.1104e-02_r8,2.1661e-02_r8/)
      kbo(:,28, 5) = (/ &
     &1.5739e-02_r8,1.6410e-02_r8,1.7009e-02_r8,1.7502e-02_r8,1.7957e-02_r8/)
      kbo(:,29, 5) = (/ &
     &1.3157e-02_r8,1.3689e-02_r8,1.4135e-02_r8,1.4550e-02_r8,1.4908e-02_r8/)
      kbo(:,30, 5) = (/ &
     &1.0985e-02_r8,1.1390e-02_r8,1.1749e-02_r8,1.2076e-02_r8,1.2372e-02_r8/)
      kbo(:,31, 5) = (/ &
     &9.1582e-03_r8,9.4742e-03_r8,9.7675e-03_r8,1.0044e-02_r8,1.0289e-02_r8/)
      kbo(:,32, 5) = (/ &
     &7.6339e-03_r8,7.8923e-03_r8,8.1271e-03_r8,8.3548e-03_r8,8.5695e-03_r8/)
      kbo(:,33, 5) = (/ &
     &6.3715e-03_r8,6.5845e-03_r8,6.7878e-03_r8,6.9736e-03_r8,7.1535e-03_r8/)
      kbo(:,34, 5) = (/ &
     &5.3224e-03_r8,5.5025e-03_r8,5.6652e-03_r8,5.8262e-03_r8,5.9749e-03_r8/)
      kbo(:,35, 5) = (/ &
     &4.4348e-03_r8,4.5841e-03_r8,4.7248e-03_r8,4.8589e-03_r8,4.9851e-03_r8/)
      kbo(:,36, 5) = (/ &
     &3.6880e-03_r8,3.8127e-03_r8,3.9338e-03_r8,4.0484e-03_r8,4.1576e-03_r8/)
      kbo(:,37, 5) = (/ &
     &3.0534e-03_r8,3.1615e-03_r8,3.2693e-03_r8,3.3693e-03_r8,3.4657e-03_r8/)
      kbo(:,38, 5) = (/ &
     &2.5332e-03_r8,2.6300e-03_r8,2.7225e-03_r8,2.8131e-03_r8,2.8939e-03_r8/)
      kbo(:,39, 5) = (/ &
     &2.1084e-03_r8,2.1961e-03_r8,2.2783e-03_r8,2.3583e-03_r8,2.4286e-03_r8/)
      kbo(:,40, 5) = (/ &
     &1.7458e-03_r8,1.8240e-03_r8,1.8981e-03_r8,1.9682e-03_r8,2.0283e-03_r8/)
      kbo(:,41, 5) = (/ &
     &1.4453e-03_r8,1.5145e-03_r8,1.5781e-03_r8,1.6391e-03_r8,1.6964e-03_r8/)
      kbo(:,42, 5) = (/ &
     &1.1954e-03_r8,1.2559e-03_r8,1.3113e-03_r8,1.3662e-03_r8,1.4193e-03_r8/)
      kbo(:,43, 5) = (/ &
     &9.8711e-04_r8,1.0388e-03_r8,1.0881e-03_r8,1.1376e-03_r8,1.1854e-03_r8/)
      kbo(:,44, 5) = (/ &
     &8.1670e-04_r8,8.6083e-04_r8,9.0273e-04_r8,9.4724e-04_r8,9.9183e-04_r8/)
      kbo(:,45, 5) = (/ &
     &6.7571e-04_r8,7.1462e-04_r8,7.5340e-04_r8,7.9241e-04_r8,8.3252e-04_r8/)
      kbo(:,46, 5) = (/ &
     &5.5868e-04_r8,5.9210e-04_r8,6.2784e-04_r8,6.6315e-04_r8,6.9901e-04_r8/)
      kbo(:,47, 5) = (/ &
     &4.6002e-04_r8,4.8924e-04_r8,5.2084e-04_r8,5.5250e-04_r8,5.8555e-04_r8/)
      kbo(:,48, 5) = (/ &
     &3.7900e-04_r8,4.0478e-04_r8,4.3312e-04_r8,4.6138e-04_r8,4.9219e-04_r8/)
      kbo(:,49, 5) = (/ &
     &3.1223e-04_r8,3.3515e-04_r8,3.6106e-04_r8,3.8737e-04_r8,4.1475e-04_r8/)
      kbo(:,50, 5) = (/ &
     &2.5631e-04_r8,2.7625e-04_r8,2.9941e-04_r8,3.2338e-04_r8,3.4759e-04_r8/)
      kbo(:,51, 5) = (/ &
     &2.0956e-04_r8,2.2726e-04_r8,2.4758e-04_r8,2.6894e-04_r8,2.9020e-04_r8/)
      kbo(:,52, 5) = (/ &
     &1.7113e-04_r8,1.8689e-04_r8,2.0470e-04_r8,2.2361e-04_r8,2.4260e-04_r8/)
      kbo(:,53, 5) = (/ &
     &1.3975e-04_r8,1.5381e-04_r8,1.6939e-04_r8,1.8611e-04_r8,2.0352e-04_r8/)
      kbo(:,54, 5) = (/ &
     &1.1323e-04_r8,1.2519e-04_r8,1.3824e-04_r8,1.5269e-04_r8,1.6768e-04_r8/)
      kbo(:,55, 5) = (/ &
     &9.1211e-05_r8,1.0111e-04_r8,1.1195e-04_r8,1.2407e-04_r8,1.3663e-04_r8/)
      kbo(:,56, 5) = (/ &
     &7.3375e-05_r8,8.1461e-05_r8,9.0533e-05_r8,1.0060e-04_r8,1.1119e-04_r8/)
      kbo(:,57, 5) = (/ &
     &5.8946e-05_r8,6.5535e-05_r8,7.3109e-05_r8,8.1511e-05_r8,9.0294e-05_r8/)
      kbo(:,58, 5) = (/ &
     &4.7323e-05_r8,5.2682e-05_r8,5.8966e-05_r8,6.5820e-05_r8,7.3137e-05_r8/)
      kbo(:,59, 5) = (/ &
     &3.8250e-05_r8,4.2565e-05_r8,4.7446e-05_r8,5.2866e-05_r8,5.8710e-05_r8/)
      kbo(:,13, 6) = (/ &
     &2.7197e-01_r8,2.7739e-01_r8,2.8096e-01_r8,2.8231e-01_r8,2.8660e-01_r8/)
      kbo(:,14, 6) = (/ &
     &2.4407e-01_r8,2.4904e-01_r8,2.5343e-01_r8,2.5569e-01_r8,2.5783e-01_r8/)
      kbo(:,15, 6) = (/ &
     &2.1616e-01_r8,2.2099e-01_r8,2.2537e-01_r8,2.2864e-01_r8,2.3140e-01_r8/)
      kbo(:,16, 6) = (/ &
     &1.9106e-01_r8,1.9585e-01_r8,1.9991e-01_r8,2.0367e-01_r8,2.0768e-01_r8/)
      kbo(:,17, 6) = (/ &
     &1.6891e-01_r8,1.7330e-01_r8,1.7742e-01_r8,1.8116e-01_r8,1.8548e-01_r8/)
      kbo(:,18, 6) = (/ &
     &1.4873e-01_r8,1.5292e-01_r8,1.5684e-01_r8,1.6048e-01_r8,1.6482e-01_r8/)
      kbo(:,19, 6) = (/ &
     &1.3023e-01_r8,1.3403e-01_r8,1.3773e-01_r8,1.4155e-01_r8,1.4625e-01_r8/)
      kbo(:,20, 6) = (/ &
     &1.1343e-01_r8,1.1684e-01_r8,1.2043e-01_r8,1.2478e-01_r8,1.2990e-01_r8/)
      kbo(:,21, 6) = (/ &
     &9.8160e-02_r8,1.0135e-01_r8,1.0525e-01_r8,1.1007e-01_r8,1.1526e-01_r8/)
      kbo(:,22, 6) = (/ &
     &8.4655e-02_r8,8.8120e-02_r8,9.2429e-02_r8,9.7184e-02_r8,1.0215e-01_r8/)
      kbo(:,23, 6) = (/ &
     &7.3019e-02_r8,7.6775e-02_r8,8.1076e-02_r8,8.5515e-02_r8,9.0104e-02_r8/)
      kbo(:,24, 6) = (/ &
     &6.3162e-02_r8,6.6861e-02_r8,7.0760e-02_r8,7.4872e-02_r8,7.8956e-02_r8/)
      kbo(:,25, 6) = (/ &
     &5.4670e-02_r8,5.8059e-02_r8,6.1565e-02_r8,6.5142e-02_r8,6.8514e-02_r8/)
      kbo(:,26, 6) = (/ &
     &4.7238e-02_r8,5.0243e-02_r8,5.3330e-02_r8,5.6237e-02_r8,5.8783e-02_r8/)
      kbo(:,27, 6) = (/ &
     &4.0718e-02_r8,4.3335e-02_r8,4.5897e-02_r8,4.8107e-02_r8,4.9970e-02_r8/)
      kbo(:,28, 6) = (/ &
     &3.4992e-02_r8,3.7210e-02_r8,3.9178e-02_r8,4.0837e-02_r8,4.2251e-02_r8/)
      kbo(:,29, 6) = (/ &
     &2.9986e-02_r8,3.1757e-02_r8,3.3246e-02_r8,3.4515e-02_r8,3.5697e-02_r8/)
      kbo(:,30, 6) = (/ &
     &2.5598e-02_r8,2.6947e-02_r8,2.8105e-02_r8,2.9142e-02_r8,3.0127e-02_r8/)
      kbo(:,31, 6) = (/ &
     &2.1742e-02_r8,2.2800e-02_r8,2.3733e-02_r8,2.4625e-02_r8,2.5488e-02_r8/)
      kbo(:,32, 6) = (/ &
     &1.8409e-02_r8,1.9261e-02_r8,2.0062e-02_r8,2.0837e-02_r8,2.1556e-02_r8/)
      kbo(:,33, 6) = (/ &
     &1.5564e-02_r8,1.6264e-02_r8,1.6973e-02_r8,1.7637e-02_r8,1.8281e-02_r8/)
      kbo(:,34, 6) = (/ &
     &1.3120e-02_r8,1.3750e-02_r8,1.4364e-02_r8,1.4950e-02_r8,1.5574e-02_r8/)
      kbo(:,35, 6) = (/ &
     &1.1037e-02_r8,1.1597e-02_r8,1.2120e-02_r8,1.2671e-02_r8,1.3247e-02_r8/)
      kbo(:,36, 6) = (/ &
     &9.2368e-03_r8,9.7140e-03_r8,1.0180e-02_r8,1.0677e-02_r8,1.1200e-02_r8/)
      kbo(:,37, 6) = (/ &
     &7.7240e-03_r8,8.1368e-03_r8,8.5470e-03_r8,8.9958e-03_r8,9.4504e-03_r8/)
      kbo(:,38, 6) = (/ &
     &6.4758e-03_r8,6.8295e-03_r8,7.1958e-03_r8,7.5972e-03_r8,8.0066e-03_r8/)
      kbo(:,39, 6) = (/ &
     &5.4501e-03_r8,5.7576e-03_r8,6.0862e-03_r8,6.4345e-03_r8,6.8065e-03_r8/)
      kbo(:,40, 6) = (/ &
     &4.5611e-03_r8,4.8311e-03_r8,5.1160e-03_r8,5.4160e-03_r8,5.7404e-03_r8/)
      kbo(:,41, 6) = (/ &
     &3.8156e-03_r8,4.0605e-03_r8,4.3157e-03_r8,4.5812e-03_r8,4.8631e-03_r8/)
      kbo(:,42, 6) = (/ &
     &3.1991e-03_r8,3.4174e-03_r8,3.6479e-03_r8,3.8959e-03_r8,4.1438e-03_r8/)
      kbo(:,43, 6) = (/ &
     &2.6778e-03_r8,2.8754e-03_r8,3.0830e-03_r8,3.3106e-03_r8,3.5418e-03_r8/)
      kbo(:,44, 6) = (/ &
     &2.2384e-03_r8,2.4221e-03_r8,2.6165e-03_r8,2.8279e-03_r8,3.0365e-03_r8/)
      kbo(:,45, 6) = (/ &
     &1.8762e-03_r8,2.0454e-03_r8,2.2217e-03_r8,2.4182e-03_r8,2.6139e-03_r8/)
      kbo(:,46, 6) = (/ &
     &1.5669e-03_r8,1.7239e-03_r8,1.8868e-03_r8,2.0694e-03_r8,2.2548e-03_r8/)
      kbo(:,47, 6) = (/ &
     &1.2965e-03_r8,1.4378e-03_r8,1.5876e-03_r8,1.7568e-03_r8,1.9326e-03_r8/)
      kbo(:,48, 6) = (/ &
     &1.0774e-03_r8,1.2001e-03_r8,1.3389e-03_r8,1.4948e-03_r8,1.6630e-03_r8/)
      kbo(:,49, 6) = (/ &
     &8.9852e-04_r8,1.0105e-03_r8,1.1309e-03_r8,1.2754e-03_r8,1.4391e-03_r8/)
      kbo(:,50, 6) = (/ &
     &7.4445e-04_r8,8.4643e-04_r8,9.5631e-04_r8,1.0809e-03_r8,1.2318e-03_r8/)
      kbo(:,51, 6) = (/ &
     &6.1558e-04_r8,7.0452e-04_r8,8.0429e-04_r8,9.1653e-04_r8,1.0518e-03_r8/)
      kbo(:,52, 6) = (/ &
     &5.0970e-04_r8,5.8893e-04_r8,6.7706e-04_r8,7.7959e-04_r8,9.0341e-04_r8/)
      kbo(:,53, 6) = (/ &
     &4.2152e-04_r8,4.9282e-04_r8,5.7291e-04_r8,6.6638e-04_r8,7.8149e-04_r8/)
      kbo(:,54, 6) = (/ &
     &3.4337e-04_r8,4.0415e-04_r8,4.7438e-04_r8,5.5660e-04_r8,6.5618e-04_r8/)
      kbo(:,55, 6) = (/ &
     &2.7643e-04_r8,3.2706e-04_r8,3.8585e-04_r8,4.5635e-04_r8,5.3989e-04_r8/)
      kbo(:,56, 6) = (/ &
     &2.2200e-04_r8,2.6388e-04_r8,3.1337e-04_r8,3.7328e-04_r8,4.4370e-04_r8/)
      kbo(:,57, 6) = (/ &
     &1.7748e-04_r8,2.1244e-04_r8,2.5395e-04_r8,3.0395e-04_r8,3.6371e-04_r8/)
      kbo(:,58, 6) = (/ &
     &1.4157e-04_r8,1.7062e-04_r8,2.0500e-04_r8,2.4610e-04_r8,2.9686e-04_r8/)
      kbo(:,59, 6) = (/ &
     &1.1414e-04_r8,1.3738e-04_r8,1.6469e-04_r8,1.9701e-04_r8,2.3735e-04_r8/)
      kbo(:,13, 7) = (/ &
     &4.6955e-01_r8,4.7919e-01_r8,4.8757e-01_r8,4.9335e-01_r8,4.9501e-01_r8/)
      kbo(:,14, 7) = (/ &
     &4.3446e-01_r8,4.4412e-01_r8,4.5217e-01_r8,4.5833e-01_r8,4.6211e-01_r8/)
      kbo(:,15, 7) = (/ &
     &3.9856e-01_r8,4.0695e-01_r8,4.1403e-01_r8,4.2050e-01_r8,4.2565e-01_r8/)
      kbo(:,16, 7) = (/ &
     &3.6468e-01_r8,3.7159e-01_r8,3.7817e-01_r8,3.8407e-01_r8,3.8859e-01_r8/)
      kbo(:,17, 7) = (/ &
     &3.3137e-01_r8,3.3763e-01_r8,3.4358e-01_r8,3.4927e-01_r8,3.5406e-01_r8/)
      kbo(:,18, 7) = (/ &
     &2.9961e-01_r8,3.0527e-01_r8,3.1117e-01_r8,3.1677e-01_r8,3.2160e-01_r8/)
      kbo(:,19, 7) = (/ &
     &2.6897e-01_r8,2.7470e-01_r8,2.8068e-01_r8,2.8609e-01_r8,2.9127e-01_r8/)
      kbo(:,20, 7) = (/ &
     &2.4079e-01_r8,2.4662e-01_r8,2.5228e-01_r8,2.5749e-01_r8,2.6294e-01_r8/)
      kbo(:,21, 7) = (/ &
     &2.1419e-01_r8,2.1985e-01_r8,2.2509e-01_r8,2.3029e-01_r8,2.3688e-01_r8/)
      kbo(:,22, 7) = (/ &
     &1.8948e-01_r8,1.9472e-01_r8,1.9983e-01_r8,2.0584e-01_r8,2.1394e-01_r8/)
      kbo(:,23, 7) = (/ &
     &1.6639e-01_r8,1.7145e-01_r8,1.7716e-01_r8,1.8457e-01_r8,1.9389e-01_r8/)
      kbo(:,24, 7) = (/ &
     &1.4538e-01_r8,1.5085e-01_r8,1.5765e-01_r8,1.6633e-01_r8,1.7588e-01_r8/)
      kbo(:,25, 7) = (/ &
     &1.2705e-01_r8,1.3331e-01_r8,1.4121e-01_r8,1.5025e-01_r8,1.5987e-01_r8/)
      kbo(:,26, 7) = (/ &
     &1.1163e-01_r8,1.1872e-01_r8,1.2704e-01_r8,1.3598e-01_r8,1.4549e-01_r8/)
      kbo(:,27, 7) = (/ &
     &9.8775e-02_r8,1.0620e-01_r8,1.1436e-01_r8,1.2321e-01_r8,1.3236e-01_r8/)
      kbo(:,28, 7) = (/ &
     &8.7819e-02_r8,9.5125e-02_r8,1.0304e-01_r8,1.1161e-01_r8,1.2007e-01_r8/)
      kbo(:,29, 7) = (/ &
     &7.8356e-02_r8,8.5376e-02_r8,9.3117e-02_r8,1.0101e-01_r8,1.0879e-01_r8/)
      kbo(:,30, 7) = (/ &
     &7.0020e-02_r8,7.6849e-02_r8,8.4078e-02_r8,9.1302e-02_r8,9.8416e-02_r8/)
      kbo(:,31, 7) = (/ &
     &6.2819e-02_r8,6.9270e-02_r8,7.5879e-02_r8,8.2483e-02_r8,8.8967e-02_r8/)
      kbo(:,32, 7) = (/ &
     &5.6483e-02_r8,6.2430e-02_r8,6.8481e-02_r8,7.4539e-02_r8,8.0648e-02_r8/)
      kbo(:,33, 7) = (/ &
     &5.0860e-02_r8,5.6316e-02_r8,6.1885e-02_r8,6.7612e-02_r8,7.3808e-02_r8/)
      kbo(:,34, 7) = (/ &
     &4.5682e-02_r8,5.0745e-02_r8,5.5935e-02_r8,6.1551e-02_r8,6.7601e-02_r8/)
      kbo(:,35, 7) = (/ &
     &4.0692e-02_r8,4.5316e-02_r8,5.0264e-02_r8,5.5834e-02_r8,6.1807e-02_r8/)
      kbo(:,36, 7) = (/ &
     &3.5794e-02_r8,4.0089e-02_r8,4.4914e-02_r8,5.0304e-02_r8,5.6176e-02_r8/)
      kbo(:,37, 7) = (/ &
     &3.0961e-02_r8,3.4978e-02_r8,3.9573e-02_r8,4.4775e-02_r8,5.0561e-02_r8/)
      kbo(:,38, 7) = (/ &
     &2.6776e-02_r8,3.0559e-02_r8,3.4968e-02_r8,3.9997e-02_r8,4.5685e-02_r8/)
      kbo(:,39, 7) = (/ &
     &2.3185e-02_r8,2.6765e-02_r8,3.1022e-02_r8,3.5959e-02_r8,4.1519e-02_r8/)
      kbo(:,40, 7) = (/ &
     &1.9763e-02_r8,2.3065e-02_r8,2.7085e-02_r8,3.1775e-02_r8,3.7215e-02_r8/)
      kbo(:,41, 7) = (/ &
     &1.6812e-02_r8,1.9830e-02_r8,2.3604e-02_r8,2.8085e-02_r8,3.3399e-02_r8/)
      kbo(:,42, 7) = (/ &
     &1.4318e-02_r8,1.7069e-02_r8,2.0605e-02_r8,2.4882e-02_r8,3.0046e-02_r8/)
      kbo(:,43, 7) = (/ &
     &1.2083e-02_r8,1.4567e-02_r8,1.7802e-02_r8,2.1853e-02_r8,2.6807e-02_r8/)
      kbo(:,44, 7) = (/ &
     &1.0170e-02_r8,1.2372e-02_r8,1.5314e-02_r8,1.9108e-02_r8,2.3821e-02_r8/)
      kbo(:,45, 7) = (/ &
     &8.6090e-03_r8,1.0534e-02_r8,1.3191e-02_r8,1.6726e-02_r8,2.1197e-02_r8/)
      kbo(:,46, 7) = (/ &
     &7.3022e-03_r8,8.9907e-03_r8,1.1353e-02_r8,1.4581e-02_r8,1.8771e-02_r8/)
      kbo(:,47, 7) = (/ &
     &6.1213e-03_r8,7.6431e-03_r8,9.7321e-03_r8,1.2583e-02_r8,1.6455e-02_r8/)
      kbo(:,48, 7) = (/ &
     &5.1186e-03_r8,6.5188e-03_r8,8.4138e-03_r8,1.0987e-02_r8,1.4502e-02_r8/)
      kbo(:,49, 7) = (/ &
     &4.2957e-03_r8,5.5597e-03_r8,7.3442e-03_r8,9.7283e-03_r8,1.2936e-02_r8/)
      kbo(:,50, 7) = (/ &
     &3.6145e-03_r8,4.7398e-03_r8,6.3555e-03_r8,8.6287e-03_r8,1.1590e-02_r8/)
      kbo(:,51, 7) = (/ &
     &3.0102e-03_r8,4.0430e-03_r8,5.4860e-03_r8,7.5896e-03_r8,1.0447e-02_r8/)
      kbo(:,52, 7) = (/ &
     &2.4958e-03_r8,3.4406e-03_r8,4.7896e-03_r8,6.7274e-03_r8,9.4519e-03_r8/)
      kbo(:,53, 7) = (/ &
     &2.0685e-03_r8,2.9229e-03_r8,4.2030e-03_r8,6.0566e-03_r8,8.6137e-03_r8/)
      kbo(:,54, 7) = (/ &
     &1.6899e-03_r8,2.4174e-03_r8,3.5607e-03_r8,5.2595e-03_r8,7.6384e-03_r8/)
      kbo(:,55, 7) = (/ &
     &1.3559e-03_r8,1.9570e-03_r8,2.9412e-03_r8,4.4253e-03_r8,6.5827e-03_r8/)
      kbo(:,56, 7) = (/ &
     &1.0806e-03_r8,1.5745e-03_r8,2.4094e-03_r8,3.7108e-03_r8,5.6277e-03_r8/)
      kbo(:,57, 7) = (/ &
     &8.5457e-04_r8,1.2632e-03_r8,1.9536e-03_r8,3.0874e-03_r8,4.7870e-03_r8/)
      kbo(:,58, 7) = (/ &
     &6.7302e-04_r8,1.0065e-03_r8,1.5736e-03_r8,2.5427e-03_r8,4.0334e-03_r8/)
      kbo(:,59, 7) = (/ &
     &5.4147e-04_r8,8.1396e-04_r8,1.2891e-03_r8,2.1042e-03_r8,3.3560e-03_r8/)
      kbo(:,13, 8) = (/ &
     &8.0034e-01_r8,8.1640e-01_r8,8.3288e-01_r8,8.4808e-01_r8,8.6148e-01_r8/)
      kbo(:,14, 8) = (/ &
     &7.8054e-01_r8,7.9433e-01_r8,8.0919e-01_r8,8.2411e-01_r8,8.3905e-01_r8/)
      kbo(:,15, 8) = (/ &
     &7.5909e-01_r8,7.7248e-01_r8,7.8592e-01_r8,7.9872e-01_r8,8.1170e-01_r8/)
      kbo(:,16, 8) = (/ &
     &7.3580e-01_r8,7.4804e-01_r8,7.6085e-01_r8,7.7248e-01_r8,7.8295e-01_r8/)
      kbo(:,17, 8) = (/ &
     &7.0630e-01_r8,7.1844e-01_r8,7.2965e-01_r8,7.3912e-01_r8,7.4743e-01_r8/)
      kbo(:,18, 8) = (/ &
     &6.7101e-01_r8,6.8279e-01_r8,6.9322e-01_r8,7.0102e-01_r8,7.0887e-01_r8/)
      kbo(:,19, 8) = (/ &
     &6.2981e-01_r8,6.4055e-01_r8,6.4979e-01_r8,6.5773e-01_r8,6.6515e-01_r8/)
      kbo(:,20, 8) = (/ &
     &5.8544e-01_r8,5.9608e-01_r8,6.0511e-01_r8,6.1342e-01_r8,6.2187e-01_r8/)
      kbo(:,21, 8) = (/ &
     &5.3944e-01_r8,5.5063e-01_r8,5.6005e-01_r8,5.6946e-01_r8,5.7856e-01_r8/)
      kbo(:,22, 8) = (/ &
     &4.9436e-01_r8,5.0585e-01_r8,5.1644e-01_r8,5.2703e-01_r8,5.3664e-01_r8/)
      kbo(:,23, 8) = (/ &
     &4.5102e-01_r8,4.6300e-01_r8,4.7455e-01_r8,4.8579e-01_r8,4.9663e-01_r8/)
      kbo(:,24, 8) = (/ &
     &4.0950e-01_r8,4.2198e-01_r8,4.3426e-01_r8,4.4606e-01_r8,4.5946e-01_r8/)
      kbo(:,25, 8) = (/ &
     &3.7091e-01_r8,3.8365e-01_r8,3.9643e-01_r8,4.1000e-01_r8,4.2576e-01_r8/)
      kbo(:,26, 8) = (/ &
     &3.3534e-01_r8,3.4839e-01_r8,3.6241e-01_r8,3.7838e-01_r8,3.9777e-01_r8/)
      kbo(:,27, 8) = (/ &
     &3.0274e-01_r8,3.1698e-01_r8,3.3298e-01_r8,3.5138e-01_r8,3.7450e-01_r8/)
      kbo(:,28, 8) = (/ &
     &2.7401e-01_r8,2.8968e-01_r8,3.0792e-01_r8,3.3011e-01_r8,3.5579e-01_r8/)
      kbo(:,29, 8) = (/ &
     &2.4984e-01_r8,2.6749e-01_r8,2.8805e-01_r8,3.1339e-01_r8,3.4148e-01_r8/)
      kbo(:,30, 8) = (/ &
     &2.2976e-01_r8,2.4923e-01_r8,2.7317e-01_r8,3.0058e-01_r8,3.3054e-01_r8/)
      kbo(:,31, 8) = (/ &
     &2.1378e-01_r8,2.3592e-01_r8,2.6234e-01_r8,2.9177e-01_r8,3.2355e-01_r8/)
      kbo(:,32, 8) = (/ &
     &2.0184e-01_r8,2.2666e-01_r8,2.5501e-01_r8,2.8631e-01_r8,3.1911e-01_r8/)
      kbo(:,33, 8) = (/ &
     &1.9381e-01_r8,2.2050e-01_r8,2.5091e-01_r8,2.8341e-01_r8,3.1739e-01_r8/)
      kbo(:,34, 8) = (/ &
     &1.8744e-01_r8,2.1594e-01_r8,2.4774e-01_r8,2.8137e-01_r8,3.1632e-01_r8/)
      kbo(:,35, 8) = (/ &
     &1.8056e-01_r8,2.1069e-01_r8,2.4353e-01_r8,2.7798e-01_r8,3.1405e-01_r8/)
      kbo(:,36, 8) = (/ &
     &1.7277e-01_r8,2.0381e-01_r8,2.3716e-01_r8,2.7253e-01_r8,3.0956e-01_r8/)
      kbo(:,37, 8) = (/ &
     &1.6168e-01_r8,1.9289e-01_r8,2.2650e-01_r8,2.6234e-01_r8,2.9987e-01_r8/)
      kbo(:,38, 8) = (/ &
     &1.5148e-01_r8,1.8272e-01_r8,2.1663e-01_r8,2.5277e-01_r8,2.9084e-01_r8/)
      kbo(:,39, 8) = (/ &
     &1.4247e-01_r8,1.7365e-01_r8,2.0770e-01_r8,2.4421e-01_r8,2.8306e-01_r8/)
      kbo(:,40, 8) = (/ &
     &1.3121e-01_r8,1.6190e-01_r8,1.9569e-01_r8,2.3227e-01_r8,2.7141e-01_r8/)
      kbo(:,41, 8) = (/ &
     &1.2044e-01_r8,1.5044e-01_r8,1.8388e-01_r8,2.2048e-01_r8,2.5951e-01_r8/)
      kbo(:,42, 8) = (/ &
     &1.1043e-01_r8,1.3967e-01_r8,1.7269e-01_r8,2.0919e-01_r8,2.4811e-01_r8/)
      kbo(:,43, 8) = (/ &
     &9.9679e-02_r8,1.2792e-01_r8,1.6034e-01_r8,1.9622e-01_r8,2.3472e-01_r8/)
      kbo(:,44, 8) = (/ &
     &8.9034e-02_r8,1.1631e-01_r8,1.4764e-01_r8,1.8285e-01_r8,2.2093e-01_r8/)
      kbo(:,45, 8) = (/ &
     &7.9054e-02_r8,1.0536e-01_r8,1.3566e-01_r8,1.6992e-01_r8,2.0745e-01_r8/)
      kbo(:,46, 8) = (/ &
     &6.9318e-02_r8,9.4501e-02_r8,1.2377e-01_r8,1.5667e-01_r8,1.9349e-01_r8/)
      kbo(:,47, 8) = (/ &
     &5.9551e-02_r8,8.3032e-02_r8,1.1103e-01_r8,1.4286e-01_r8,1.7816e-01_r8/)
      kbo(:,48, 8) = (/ &
     &5.0798e-02_r8,7.2525e-02_r8,9.9035e-02_r8,1.2969e-01_r8,1.6375e-01_r8/)
      kbo(:,49, 8) = (/ &
     &4.3152e-02_r8,6.3003e-02_r8,8.7833e-02_r8,1.1716e-01_r8,1.5024e-01_r8/)
      kbo(:,50, 8) = (/ &
     &3.6793e-02_r8,5.4813e-02_r8,7.7929e-02_r8,1.0576e-01_r8,1.3787e-01_r8/)
      kbo(:,51, 8) = (/ &
     &3.1426e-02_r8,4.7509e-02_r8,6.8953e-02_r8,9.5149e-02_r8,1.2582e-01_r8/)
      kbo(:,52, 8) = (/ &
     &2.6907e-02_r8,4.1306e-02_r8,6.0841e-02_r8,8.5477e-02_r8,1.1483e-01_r8/)
      kbo(:,53, 8) = (/ &
     &2.3168e-02_r8,3.6049e-02_r8,5.3816e-02_r8,7.6669e-02_r8,1.0462e-01_r8/)
      kbo(:,54, 8) = (/ &
     &1.9633e-02_r8,3.1217e-02_r8,4.7423e-02_r8,6.8592e-02_r8,9.4967e-02_r8/)
      kbo(:,55, 8) = (/ &
     &1.6386e-02_r8,2.6769e-02_r8,4.1346e-02_r8,6.0965e-02_r8,8.5476e-02_r8/)
      kbo(:,56, 8) = (/ &
     &1.3620e-02_r8,2.2714e-02_r8,3.5826e-02_r8,5.3847e-02_r8,7.6755e-02_r8/)
      kbo(:,57, 8) = (/ &
     &1.1197e-02_r8,1.9124e-02_r8,3.0904e-02_r8,4.7282e-02_r8,6.8602e-02_r8/)
      kbo(:,58, 8) = (/ &
     &9.1481e-03_r8,1.6046e-02_r8,2.6605e-02_r8,4.1371e-02_r8,6.1207e-02_r8/)
      kbo(:,59, 8) = (/ &
     &7.9051e-03_r8,1.4193e-02_r8,2.3774e-02_r8,3.7742e-02_r8,5.6658e-02_r8/)
      kbo(:,13, 9) = (/ &
     &1.3350e+00_r8,1.3653e+00_r8,1.3981e+00_r8,1.4396e+00_r8,1.4753e+00_r8/)
      kbo(:,14, 9) = (/ &
     &1.4178e+00_r8,1.4520e+00_r8,1.4843e+00_r8,1.5206e+00_r8,1.5583e+00_r8/)
      kbo(:,15, 9) = (/ &
     &1.4732e+00_r8,1.5083e+00_r8,1.5396e+00_r8,1.5755e+00_r8,1.6045e+00_r8/)
      kbo(:,16, 9) = (/ &
     &1.5430e+00_r8,1.5830e+00_r8,1.6160e+00_r8,1.6547e+00_r8,1.6902e+00_r8/)
      kbo(:,17, 9) = (/ &
     &1.6452e+00_r8,1.6845e+00_r8,1.7176e+00_r8,1.7564e+00_r8,1.7915e+00_r8/)
      kbo(:,18, 9) = (/ &
     &1.7229e+00_r8,1.7605e+00_r8,1.7922e+00_r8,1.8300e+00_r8,1.8621e+00_r8/)
      kbo(:,19, 9) = (/ &
     &1.7775e+00_r8,1.8140e+00_r8,1.8454e+00_r8,1.8798e+00_r8,1.9094e+00_r8/)
      kbo(:,20, 9) = (/ &
     &1.8038e+00_r8,1.8386e+00_r8,1.8699e+00_r8,1.9034e+00_r8,1.9311e+00_r8/)
      kbo(:,21, 9) = (/ &
     &1.8050e+00_r8,1.8386e+00_r8,1.8712e+00_r8,1.9046e+00_r8,1.9320e+00_r8/)
      kbo(:,22, 9) = (/ &
     &1.7869e+00_r8,1.8213e+00_r8,1.8557e+00_r8,1.8890e+00_r8,1.9178e+00_r8/)
      kbo(:,23, 9) = (/ &
     &1.7516e+00_r8,1.7874e+00_r8,1.8248e+00_r8,1.8592e+00_r8,1.8901e+00_r8/)
      kbo(:,24, 9) = (/ &
     &1.7051e+00_r8,1.7440e+00_r8,1.7841e+00_r8,1.8220e+00_r8,1.8561e+00_r8/)
      kbo(:,25, 9) = (/ &
     &1.6513e+00_r8,1.6948e+00_r8,1.7396e+00_r8,1.7805e+00_r8,1.8194e+00_r8/)
      kbo(:,26, 9) = (/ &
     &1.5955e+00_r8,1.6454e+00_r8,1.6945e+00_r8,1.7402e+00_r8,1.7819e+00_r8/)
      kbo(:,27, 9) = (/ &
     &1.5421e+00_r8,1.5985e+00_r8,1.6517e+00_r8,1.7028e+00_r8,1.7485e+00_r8/)
      kbo(:,28, 9) = (/ &
     &1.4940e+00_r8,1.5568e+00_r8,1.6151e+00_r8,1.6694e+00_r8,1.7213e+00_r8/)
      kbo(:,29, 9) = (/ &
     &1.4533e+00_r8,1.5206e+00_r8,1.5846e+00_r8,1.6444e+00_r8,1.7003e+00_r8/)
      kbo(:,30, 9) = (/ &
     &1.4208e+00_r8,1.4930e+00_r8,1.5618e+00_r8,1.6263e+00_r8,1.6869e+00_r8/)
      kbo(:,31, 9) = (/ &
     &1.3961e+00_r8,1.4744e+00_r8,1.5474e+00_r8,1.6161e+00_r8,1.6805e+00_r8/)
      kbo(:,32, 9) = (/ &
     &1.3821e+00_r8,1.4633e+00_r8,1.5401e+00_r8,1.6122e+00_r8,1.6817e+00_r8/)
      kbo(:,33, 9) = (/ &
     &1.3749e+00_r8,1.4598e+00_r8,1.5393e+00_r8,1.6160e+00_r8,1.6953e+00_r8/)
      kbo(:,34, 9) = (/ &
     &1.3713e+00_r8,1.4588e+00_r8,1.5429e+00_r8,1.6218e+00_r8,1.7156e+00_r8/)
      kbo(:,35, 9) = (/ &
     &1.3644e+00_r8,1.4561e+00_r8,1.5422e+00_r8,1.6338e+00_r8,1.7288e+00_r8/)
      kbo(:,36, 9) = (/ &
     &1.3516e+00_r8,1.4466e+00_r8,1.5348e+00_r8,1.6360e+00_r8,1.7340e+00_r8/)
      kbo(:,37, 9) = (/ &
     &1.3275e+00_r8,1.4250e+00_r8,1.5169e+00_r8,1.6237e+00_r8,1.7238e+00_r8/)
      kbo(:,38, 9) = (/ &
     &1.3040e+00_r8,1.4043e+00_r8,1.5021e+00_r8,1.6114e+00_r8,1.7135e+00_r8/)
      kbo(:,39, 9) = (/ &
     &1.2823e+00_r8,1.3849e+00_r8,1.4910e+00_r8,1.6008e+00_r8,1.7062e+00_r8/)
      kbo(:,40, 9) = (/ &
     &1.2494e+00_r8,1.3552e+00_r8,1.4636e+00_r8,1.5759e+00_r8,1.6836e+00_r8/)
      kbo(:,41, 9) = (/ &
     &1.2158e+00_r8,1.3244e+00_r8,1.4340e+00_r8,1.5489e+00_r8,1.6593e+00_r8/)
      kbo(:,42, 9) = (/ &
     &1.1826e+00_r8,1.2939e+00_r8,1.4045e+00_r8,1.5221e+00_r8,1.6360e+00_r8/)
      kbo(:,43, 9) = (/ &
     &1.1430e+00_r8,1.2570e+00_r8,1.3680e+00_r8,1.4889e+00_r8,1.6061e+00_r8/)
      kbo(:,44, 9) = (/ &
     &1.1001e+00_r8,1.2164e+00_r8,1.3282e+00_r8,1.4525e+00_r8,1.5734e+00_r8/)
      kbo(:,45, 9) = (/ &
     &1.0569e+00_r8,1.1761e+00_r8,1.2894e+00_r8,1.4161e+00_r8,1.5408e+00_r8/)
      kbo(:,46, 9) = (/ &
     &1.0113e+00_r8,1.1324e+00_r8,1.2480e+00_r8,1.3769e+00_r8,1.5047e+00_r8/)
      kbo(:,47, 9) = (/ &
     &9.5935e-01_r8,1.0831e+00_r8,1.2009e+00_r8,1.3301e+00_r8,1.4611e+00_r8/)
      kbo(:,48, 9) = (/ &
     &9.0670e-01_r8,1.0329e+00_r8,1.1535e+00_r8,1.2830e+00_r8,1.4185e+00_r8/)
      kbo(:,49, 9) = (/ &
     &8.5414e-01_r8,9.8225e-01_r8,1.1056e+00_r8,1.2370e+00_r8,1.3774e+00_r8/)
      kbo(:,50, 9) = (/ &
     &8.0339e-01_r8,9.3369e-01_r8,1.0592e+00_r8,1.1907e+00_r8,1.3340e+00_r8/)
      kbo(:,51, 9) = (/ &
     &7.5351e-01_r8,8.8571e-01_r8,1.0133e+00_r8,1.1450e+00_r8,1.2894e+00_r8/)
      kbo(:,52, 9) = (/ &
     &7.0363e-01_r8,8.3718e-01_r8,9.6715e-01_r8,1.0991e+00_r8,1.2446e+00_r8/)
      kbo(:,53, 9) = (/ &
     &6.5356e-01_r8,7.8813e-01_r8,9.1966e-01_r8,1.0529e+00_r8,1.2015e+00_r8/)
      kbo(:,54, 9) = (/ &
     &6.0842e-01_r8,7.4258e-01_r8,8.7513e-01_r8,1.0061e+00_r8,1.1543e+00_r8/)
      kbo(:,55, 9) = (/ &
     &5.6587e-01_r8,6.9834e-01_r8,8.3229e-01_r8,9.6266e-01_r8,1.1037e+00_r8/)
      kbo(:,56, 9) = (/ &
     &5.2358e-01_r8,6.5442e-01_r8,7.8939e-01_r8,9.2104e-01_r8,1.0541e+00_r8/)
      kbo(:,57, 9) = (/ &
     &4.8183e-01_r8,6.1174e-01_r8,7.4558e-01_r8,8.7862e-01_r8,1.0077e+00_r8/)
      kbo(:,58, 9) = (/ &
     &4.4300e-01_r8,5.7151e-01_r8,7.0375e-01_r8,8.3825e-01_r8,9.6862e-01_r8/)
      kbo(:,59, 9) = (/ &
     &4.2745e-01_r8,5.5483e-01_r8,6.8739e-01_r8,8.2045e-01_r8,9.5225e-01_r8/)
      kbo(:,13,10) = (/ &
     &1.9893e+00_r8,1.9563e+00_r8,1.9174e+00_r8,1.9426e+00_r8,2.0503e+00_r8/)
      kbo(:,14,10) = (/ &
     &1.9716e+00_r8,2.0101e+00_r8,2.0332e+00_r8,2.0825e+00_r8,2.0990e+00_r8/)
      kbo(:,15,10) = (/ &
     &2.2404e+00_r8,2.3114e+00_r8,2.3474e+00_r8,2.4414e+00_r8,2.5235e+00_r8/)
      kbo(:,16,10) = (/ &
     &2.6948e+00_r8,2.7693e+00_r8,2.8500e+00_r8,2.9277e+00_r8,3.0098e+00_r8/)
      kbo(:,17,10) = (/ &
     &2.9786e+00_r8,3.0578e+00_r8,3.1508e+00_r8,3.2081e+00_r8,3.2791e+00_r8/)
      kbo(:,18,10) = (/ &
     &3.2445e+00_r8,3.3300e+00_r8,3.4200e+00_r8,3.4641e+00_r8,3.5430e+00_r8/)
      kbo(:,19,10) = (/ &
     &3.4975e+00_r8,3.5857e+00_r8,3.6668e+00_r8,3.7210e+00_r8,3.8007e+00_r8/)
      kbo(:,20,10) = (/ &
     &3.7569e+00_r8,3.8465e+00_r8,3.9165e+00_r8,3.9790e+00_r8,4.0533e+00_r8/)
      kbo(:,21,10) = (/ &
     &4.0221e+00_r8,4.1092e+00_r8,4.1701e+00_r8,4.2261e+00_r8,4.2948e+00_r8/)
      kbo(:,22,10) = (/ &
     &4.2735e+00_r8,4.3579e+00_r8,4.4003e+00_r8,4.4698e+00_r8,4.5287e+00_r8/)
      kbo(:,23,10) = (/ &
     &4.4889e+00_r8,4.5713e+00_r8,4.6026e+00_r8,4.6888e+00_r8,4.7442e+00_r8/)
      kbo(:,24,10) = (/ &
     &4.6627e+00_r8,4.7429e+00_r8,4.7936e+00_r8,4.8738e+00_r8,4.9305e+00_r8/)
      kbo(:,25,10) = (/ &
     &4.8010e+00_r8,4.8792e+00_r8,4.9473e+00_r8,5.0350e+00_r8,5.0940e+00_r8/)
      kbo(:,26,10) = (/ &
     &4.9124e+00_r8,4.9871e+00_r8,5.0797e+00_r8,5.1628e+00_r8,5.2299e+00_r8/)
      kbo(:,27,10) = (/ &
     &4.9985e+00_r8,5.0753e+00_r8,5.2023e+00_r8,5.2822e+00_r8,5.3506e+00_r8/)
      kbo(:,28,10) = (/ &
     &5.0601e+00_r8,5.1633e+00_r8,5.2946e+00_r8,5.3826e+00_r8,5.4390e+00_r8/)
      kbo(:,29,10) = (/ &
     &5.1149e+00_r8,5.2551e+00_r8,5.3769e+00_r8,5.4560e+00_r8,5.5331e+00_r8/)
      kbo(:,30,10) = (/ &
     &5.1829e+00_r8,5.3405e+00_r8,5.4468e+00_r8,5.5366e+00_r8,5.6267e+00_r8/)
      kbo(:,31,10) = (/ &
     &5.2708e+00_r8,5.3990e+00_r8,5.5145e+00_r8,5.6271e+00_r8,5.7226e+00_r8/)
      kbo(:,32,10) = (/ &
     &5.3210e+00_r8,5.4615e+00_r8,5.6064e+00_r8,5.7149e+00_r8,5.7961e+00_r8/)
      kbo(:,33,10) = (/ &
     &5.3784e+00_r8,5.5514e+00_r8,5.6898e+00_r8,5.7825e+00_r8,5.7881e+00_r8/)
      kbo(:,34,10) = (/ &
     &5.4610e+00_r8,5.6264e+00_r8,5.7421e+00_r8,5.8351e+00_r8,5.7469e+00_r8/)
      kbo(:,35,10) = (/ &
     &5.5182e+00_r8,5.6646e+00_r8,5.7805e+00_r8,5.8049e+00_r8,5.8731e+00_r8/)
      kbo(:,36,10) = (/ &
     &5.5474e+00_r8,5.6825e+00_r8,5.8317e+00_r8,5.7746e+00_r8,5.9436e+00_r8/)
      kbo(:,37,10) = (/ &
     &5.5356e+00_r8,5.6848e+00_r8,5.8413e+00_r8,5.7830e+00_r8,5.9888e+00_r8/)
      kbo(:,38,10) = (/ &
     &5.5240e+00_r8,5.6924e+00_r8,5.8161e+00_r8,5.8447e+00_r8,6.0305e+00_r8/)
      kbo(:,39,10) = (/ &
     &5.5062e+00_r8,5.7035e+00_r8,5.7750e+00_r8,5.8907e+00_r8,6.0598e+00_r8/)
      kbo(:,40,10) = (/ &
     &5.4721e+00_r8,5.6790e+00_r8,5.7621e+00_r8,5.8808e+00_r8,6.0578e+00_r8/)
      kbo(:,41,10) = (/ &
     &5.4259e+00_r8,5.6462e+00_r8,5.7509e+00_r8,5.8640e+00_r8,6.0494e+00_r8/)
      kbo(:,42,10) = (/ &
     &5.3746e+00_r8,5.6111e+00_r8,5.7387e+00_r8,5.8493e+00_r8,6.0309e+00_r8/)
      kbo(:,43,10) = (/ &
     &5.3001e+00_r8,5.5493e+00_r8,5.7206e+00_r8,5.8145e+00_r8,6.0040e+00_r8/)
      kbo(:,44,10) = (/ &
     &5.2173e+00_r8,5.4929e+00_r8,5.6988e+00_r8,5.7584e+00_r8,5.9757e+00_r8/)
      kbo(:,45,10) = (/ &
     &5.1348e+00_r8,5.4235e+00_r8,5.6596e+00_r8,5.7148e+00_r8,5.9430e+00_r8/)
      kbo(:,46,10) = (/ &
     &5.0314e+00_r8,5.3386e+00_r8,5.5941e+00_r8,5.6594e+00_r8,5.8994e+00_r8/)
      kbo(:,47,10) = (/ &
     &4.9050e+00_r8,5.2288e+00_r8,5.5164e+00_r8,5.5882e+00_r8,5.8407e+00_r8/)
      kbo(:,48,10) = (/ &
     &4.7768e+00_r8,5.1235e+00_r8,5.4274e+00_r8,5.5412e+00_r8,5.7765e+00_r8/)
      kbo(:,49,10) = (/ &
     &4.6322e+00_r8,5.0058e+00_r8,5.3313e+00_r8,5.4722e+00_r8,5.7006e+00_r8/)
      kbo(:,50,10) = (/ &
     &4.4926e+00_r8,4.8780e+00_r8,5.2241e+00_r8,5.4133e+00_r8,5.6277e+00_r8/)
      kbo(:,51,10) = (/ &
     &4.3523e+00_r8,4.7488e+00_r8,5.1238e+00_r8,5.3514e+00_r8,5.5587e+00_r8/)
      kbo(:,52,10) = (/ &
     &4.2056e+00_r8,4.6099e+00_r8,5.0074e+00_r8,5.2732e+00_r8,5.4803e+00_r8/)
      kbo(:,53,10) = (/ &
     &4.0530e+00_r8,4.4698e+00_r8,4.8873e+00_r8,5.1842e+00_r8,5.3844e+00_r8/)
      kbo(:,54,10) = (/ &
     &3.8976e+00_r8,4.3362e+00_r8,4.7616e+00_r8,5.1168e+00_r8,5.2766e+00_r8/)
      kbo(:,55,10) = (/ &
     &3.7298e+00_r8,4.2020e+00_r8,4.6200e+00_r8,5.0133e+00_r8,5.2077e+00_r8/)
      kbo(:,56,10) = (/ &
     &3.5605e+00_r8,4.0625e+00_r8,4.4800e+00_r8,4.8943e+00_r8,5.1989e+00_r8/)
      kbo(:,57,10) = (/ &
     &3.3848e+00_r8,3.9107e+00_r8,4.3536e+00_r8,4.7626e+00_r8,5.1398e+00_r8/)
      kbo(:,58,10) = (/ &
     &3.2413e+00_r8,3.7494e+00_r8,4.2254e+00_r8,4.6312e+00_r8,5.0237e+00_r8/)
      kbo(:,59,10) = (/ &
     &3.1874e+00_r8,3.6712e+00_r8,4.1570e+00_r8,4.5764e+00_r8,4.9431e+00_r8/)
      kbo(:,13,11) = (/ &
     &2.0655e+00_r8,2.2522e+00_r8,2.3749e+00_r8,2.3793e+00_r8,2.3141e+00_r8/)
      kbo(:,14,11) = (/ &
     &2.3056e+00_r8,2.3392e+00_r8,2.3483e+00_r8,2.4161e+00_r8,2.4783e+00_r8/)
      kbo(:,15,11) = (/ &
     &2.5044e+00_r8,2.5910e+00_r8,2.7153e+00_r8,2.7838e+00_r8,2.9462e+00_r8/)
      kbo(:,16,11) = (/ &
     &3.2130e+00_r8,3.2960e+00_r8,3.3708e+00_r8,3.3957e+00_r8,3.4936e+00_r8/)
      kbo(:,17,11) = (/ &
     &3.5929e+00_r8,3.6854e+00_r8,3.7568e+00_r8,3.8084e+00_r8,3.9070e+00_r8/)
      kbo(:,18,11) = (/ &
     &3.9502e+00_r8,4.0564e+00_r8,4.1260e+00_r8,4.2219e+00_r8,4.3335e+00_r8/)
      kbo(:,19,11) = (/ &
     &4.3215e+00_r8,4.4423e+00_r8,4.5361e+00_r8,4.6179e+00_r8,4.7405e+00_r8/)
      kbo(:,20,11) = (/ &
     &4.7059e+00_r8,4.8304e+00_r8,4.9342e+00_r8,4.9958e+00_r8,5.1320e+00_r8/)
      kbo(:,21,11) = (/ &
     &5.0845e+00_r8,5.2089e+00_r8,5.3085e+00_r8,5.3635e+00_r8,5.4973e+00_r8/)
      kbo(:,22,11) = (/ &
     &5.4678e+00_r8,5.5866e+00_r8,5.6718e+00_r8,5.7157e+00_r8,5.8446e+00_r8/)
      kbo(:,23,11) = (/ &
     &5.8472e+00_r8,5.9542e+00_r8,6.0224e+00_r8,6.0657e+00_r8,6.1751e+00_r8/)
      kbo(:,24,11) = (/ &
     &6.2102e+00_r8,6.3055e+00_r8,6.3477e+00_r8,6.4025e+00_r8,6.4818e+00_r8/)
      kbo(:,25,11) = (/ &
     &6.5425e+00_r8,6.6276e+00_r8,6.6464e+00_r8,6.7138e+00_r8,6.7776e+00_r8/)
      kbo(:,26,11) = (/ &
     &6.8397e+00_r8,6.9134e+00_r8,6.9153e+00_r8,7.0099e+00_r8,7.0590e+00_r8/)
      kbo(:,27,11) = (/ &
     &7.1001e+00_r8,7.1597e+00_r8,7.1676e+00_r8,7.2592e+00_r8,7.2956e+00_r8/)
      kbo(:,28,11) = (/ &
     &7.3310e+00_r8,7.3578e+00_r8,7.4192e+00_r8,7.4714e+00_r8,7.5147e+00_r8/)
      kbo(:,29,11) = (/ &
     &7.5220e+00_r8,7.5568e+00_r8,7.6448e+00_r8,7.6786e+00_r8,7.7106e+00_r8/)
      kbo(:,30,11) = (/ &
     &7.6639e+00_r8,7.7470e+00_r8,7.8152e+00_r8,7.8571e+00_r8,7.8626e+00_r8/)
      kbo(:,31,11) = (/ &
     &7.8082e+00_r8,7.9292e+00_r8,7.9711e+00_r8,7.9864e+00_r8,7.9914e+00_r8/)
      kbo(:,32,11) = (/ &
     &7.9725e+00_r8,8.0661e+00_r8,8.0888e+00_r8,8.1052e+00_r8,8.1459e+00_r8/)
      kbo(:,33,11) = (/ &
     &8.1196e+00_r8,8.1648e+00_r8,8.2204e+00_r8,8.2561e+00_r8,8.2714e+00_r8/)
      kbo(:,34,11) = (/ &
     &8.1982e+00_r8,8.2822e+00_r8,8.3431e+00_r8,8.3695e+00_r8,8.3494e+00_r8/)
      kbo(:,35,11) = (/ &
     &8.2893e+00_r8,8.3914e+00_r8,8.4459e+00_r8,8.4367e+00_r8,8.2201e+00_r8/)
      kbo(:,36,11) = (/ &
     &8.3709e+00_r8,8.4754e+00_r8,8.5081e+00_r8,8.5002e+00_r8,8.2056e+00_r8/)
      kbo(:,37,11) = (/ &
     &8.4255e+00_r8,8.5299e+00_r8,8.5562e+00_r8,8.5457e+00_r8,8.3297e+00_r8/)
      kbo(:,38,11) = (/ &
     &8.4692e+00_r8,8.5729e+00_r8,8.6048e+00_r8,8.5329e+00_r8,8.4574e+00_r8/)
      kbo(:,39,11) = (/ &
     &8.5044e+00_r8,8.6011e+00_r8,8.6529e+00_r8,8.5036e+00_r8,8.5412e+00_r8/)
      kbo(:,40,11) = (/ &
     &8.5034e+00_r8,8.6122e+00_r8,8.6861e+00_r8,8.5500e+00_r8,8.5878e+00_r8/)
      kbo(:,41,11) = (/ &
     &8.4921e+00_r8,8.6152e+00_r8,8.7146e+00_r8,8.6037e+00_r8,8.6322e+00_r8/)
      kbo(:,42,11) = (/ &
     &8.4716e+00_r8,8.6012e+00_r8,8.7281e+00_r8,8.6344e+00_r8,8.6768e+00_r8/)
      kbo(:,43,11) = (/ &
     &8.4399e+00_r8,8.6022e+00_r8,8.7354e+00_r8,8.6857e+00_r8,8.7108e+00_r8/)
      kbo(:,44,11) = (/ &
     &8.4042e+00_r8,8.5707e+00_r8,8.7247e+00_r8,8.7306e+00_r8,8.7301e+00_r8/)
      kbo(:,45,11) = (/ &
     &8.3422e+00_r8,8.5367e+00_r8,8.7092e+00_r8,8.7655e+00_r8,8.7531e+00_r8/)
      kbo(:,46,11) = (/ &
     &8.2614e+00_r8,8.4925e+00_r8,8.6796e+00_r8,8.7911e+00_r8,8.7636e+00_r8/)
      kbo(:,47,11) = (/ &
     &8.1773e+00_r8,8.4296e+00_r8,8.6376e+00_r8,8.8172e+00_r8,8.7465e+00_r8/)
      kbo(:,48,11) = (/ &
     &8.0681e+00_r8,8.3512e+00_r8,8.5867e+00_r8,8.7946e+00_r8,8.7119e+00_r8/)
      kbo(:,49,11) = (/ &
     &7.9551e+00_r8,8.2607e+00_r8,8.5307e+00_r8,8.7608e+00_r8,8.6937e+00_r8/)
      kbo(:,50,11) = (/ &
     &7.8252e+00_r8,8.1751e+00_r8,8.4616e+00_r8,8.7182e+00_r8,8.6487e+00_r8/)
      kbo(:,51,11) = (/ &
     &7.6779e+00_r8,8.0748e+00_r8,8.3664e+00_r8,8.6630e+00_r8,8.6216e+00_r8/)
      kbo(:,52,11) = (/ &
     &7.5020e+00_r8,7.9591e+00_r8,8.2751e+00_r8,8.6024e+00_r8,8.6131e+00_r8/)
      kbo(:,53,11) = (/ &
     &7.3138e+00_r8,7.8339e+00_r8,8.1806e+00_r8,8.5263e+00_r8,8.5994e+00_r8/)
      kbo(:,54,11) = (/ &
     &7.1204e+00_r8,7.6772e+00_r8,8.0838e+00_r8,8.4459e+00_r8,8.6417e+00_r8/)
      kbo(:,55,11) = (/ &
     &6.9256e+00_r8,7.5251e+00_r8,7.9750e+00_r8,8.3203e+00_r8,8.6369e+00_r8/)
      kbo(:,56,11) = (/ &
     &6.7619e+00_r8,7.3247e+00_r8,7.8477e+00_r8,8.2055e+00_r8,8.5418e+00_r8/)
      kbo(:,57,11) = (/ &
     &6.5989e+00_r8,7.1193e+00_r8,7.6865e+00_r8,8.1073e+00_r8,8.4236e+00_r8/)
      kbo(:,58,11) = (/ &
     &6.3964e+00_r8,6.9666e+00_r8,7.5354e+00_r8,7.9999e+00_r8,8.3228e+00_r8/)
      kbo(:,59,11) = (/ &
     &6.3130e+00_r8,6.9330e+00_r8,7.4209e+00_r8,7.9087e+00_r8,8.2712e+00_r8/)
      kbo(:,13,12) = (/ &
     &2.2326e+00_r8,2.2492e+00_r8,2.2166e+00_r8,2.2179e+00_r8,2.3939e+00_r8/)
      kbo(:,14,12) = (/ &
     &2.6624e+00_r8,2.8068e+00_r8,2.8766e+00_r8,2.8509e+00_r8,2.8616e+00_r8/)
      kbo(:,15,12) = (/ &
     &3.7151e+00_r8,3.8338e+00_r8,3.8710e+00_r8,3.8938e+00_r8,4.0387e+00_r8/)
      kbo(:,16,12) = (/ &
     &4.1478e+00_r8,4.2453e+00_r8,4.2845e+00_r8,4.3058e+00_r8,4.4171e+00_r8/)
      kbo(:,17,12) = (/ &
     &4.4594e+00_r8,4.5666e+00_r8,4.6335e+00_r8,4.6600e+00_r8,4.7776e+00_r8/)
      kbo(:,18,12) = (/ &
     &4.8949e+00_r8,5.0141e+00_r8,5.1198e+00_r8,5.1461e+00_r8,5.2514e+00_r8/)
      kbo(:,19,12) = (/ &
     &5.4166e+00_r8,5.5448e+00_r8,5.6541e+00_r8,5.7098e+00_r8,5.7608e+00_r8/)
      kbo(:,20,12) = (/ &
     &5.9687e+00_r8,6.1117e+00_r8,6.2318e+00_r8,6.2991e+00_r8,6.3382e+00_r8/)
      kbo(:,21,12) = (/ &
     &6.5357e+00_r8,6.6891e+00_r8,6.8185e+00_r8,6.8922e+00_r8,6.9339e+00_r8/)
      kbo(:,22,12) = (/ &
     &7.1247e+00_r8,7.2763e+00_r8,7.4121e+00_r8,7.4770e+00_r8,7.5498e+00_r8/)
      kbo(:,23,12) = (/ &
     &7.7039e+00_r8,7.8572e+00_r8,7.9884e+00_r8,8.0284e+00_r8,8.1432e+00_r8/)
      kbo(:,24,12) = (/ &
     &8.2700e+00_r8,8.4098e+00_r8,8.5280e+00_r8,8.5448e+00_r8,8.6892e+00_r8/)
      kbo(:,25,12) = (/ &
     &8.8099e+00_r8,8.9417e+00_r8,9.0327e+00_r8,9.0480e+00_r8,9.1843e+00_r8/)
      kbo(:,26,12) = (/ &
     &9.3282e+00_r8,9.4425e+00_r8,9.5016e+00_r8,9.4918e+00_r8,9.6320e+00_r8/)
      kbo(:,27,12) = (/ &
     &9.8120e+00_r8,9.9020e+00_r8,9.8963e+00_r8,9.9235e+00_r8,1.0029e+01_r8/)
      kbo(:,28,12) = (/ &
     &1.0246e+01_r8,1.0311e+01_r8,1.0256e+01_r8,1.0345e+01_r8,1.0401e+01_r8/)
      kbo(:,29,12) = (/ &
     &1.0631e+01_r8,1.0621e+01_r8,1.0577e+01_r8,1.0691e+01_r8,1.0719e+01_r8/)
      kbo(:,30,12) = (/ &
     &1.0962e+01_r8,1.0883e+01_r8,1.0936e+01_r8,1.0968e+01_r8,1.0995e+01_r8/)
      kbo(:,31,12) = (/ &
     &1.1183e+01_r8,1.1144e+01_r8,1.1216e+01_r8,1.1241e+01_r8,1.1250e+01_r8/)
      kbo(:,32,12) = (/ &
     &1.1390e+01_r8,1.1439e+01_r8,1.1434e+01_r8,1.1471e+01_r8,1.1430e+01_r8/)
      kbo(:,33,12) = (/ &
     &1.1588e+01_r8,1.1624e+01_r8,1.1599e+01_r8,1.1614e+01_r8,1.1630e+01_r8/)
      kbo(:,34,12) = (/ &
     &1.1823e+01_r8,1.1780e+01_r8,1.1748e+01_r8,1.1805e+01_r8,1.1825e+01_r8/)
      kbo(:,35,12) = (/ &
     &1.1935e+01_r8,1.1885e+01_r8,1.1934e+01_r8,1.1981e+01_r8,1.2011e+01_r8/)
      kbo(:,36,12) = (/ &
     &1.2055e+01_r8,1.2055e+01_r8,1.2092e+01_r8,1.2129e+01_r8,1.2083e+01_r8/)
      kbo(:,37,12) = (/ &
     &1.2143e+01_r8,1.2189e+01_r8,1.2217e+01_r8,1.2211e+01_r8,1.2038e+01_r8/)
      kbo(:,38,12) = (/ &
     &1.2240e+01_r8,1.2287e+01_r8,1.2320e+01_r8,1.2293e+01_r8,1.1958e+01_r8/)
      kbo(:,39,12) = (/ &
     &1.2384e+01_r8,1.2401e+01_r8,1.2395e+01_r8,1.2388e+01_r8,1.1943e+01_r8/)
      kbo(:,40,12) = (/ &
     &1.2464e+01_r8,1.2479e+01_r8,1.2477e+01_r8,1.2446e+01_r8,1.2032e+01_r8/)
      kbo(:,41,12) = (/ &
     &1.2528e+01_r8,1.2533e+01_r8,1.2534e+01_r8,1.2503e+01_r8,1.2103e+01_r8/)
      kbo(:,42,12) = (/ &
     &1.2585e+01_r8,1.2609e+01_r8,1.2591e+01_r8,1.2562e+01_r8,1.2170e+01_r8/)
      kbo(:,43,12) = (/ &
     &1.2648e+01_r8,1.2666e+01_r8,1.2643e+01_r8,1.2594e+01_r8,1.2252e+01_r8/)
      kbo(:,44,12) = (/ &
     &1.2682e+01_r8,1.2728e+01_r8,1.2701e+01_r8,1.2655e+01_r8,1.2340e+01_r8/)
      kbo(:,45,12) = (/ &
     &1.2706e+01_r8,1.2763e+01_r8,1.2739e+01_r8,1.2702e+01_r8,1.2417e+01_r8/)
      kbo(:,46,12) = (/ &
     &1.2744e+01_r8,1.2798e+01_r8,1.2795e+01_r8,1.2773e+01_r8,1.2516e+01_r8/)
      kbo(:,47,12) = (/ &
     &1.2744e+01_r8,1.2852e+01_r8,1.2846e+01_r8,1.2816e+01_r8,1.2652e+01_r8/)
      kbo(:,48,12) = (/ &
     &1.2714e+01_r8,1.2860e+01_r8,1.2886e+01_r8,1.2860e+01_r8,1.2772e+01_r8/)
      kbo(:,49,12) = (/ &
     &1.2667e+01_r8,1.2862e+01_r8,1.2927e+01_r8,1.2926e+01_r8,1.2873e+01_r8/)
      kbo(:,50,12) = (/ &
     &1.2568e+01_r8,1.2858e+01_r8,1.2953e+01_r8,1.2955e+01_r8,1.2993e+01_r8/)
      kbo(:,51,12) = (/ &
     &1.2506e+01_r8,1.2803e+01_r8,1.2982e+01_r8,1.2983e+01_r8,1.3071e+01_r8/)
      kbo(:,52,12) = (/ &
     &1.2444e+01_r8,1.2786e+01_r8,1.2969e+01_r8,1.3005e+01_r8,1.3112e+01_r8/)
      kbo(:,53,12) = (/ &
     &1.2352e+01_r8,1.2737e+01_r8,1.2961e+01_r8,1.3024e+01_r8,1.3150e+01_r8/)
      kbo(:,54,12) = (/ &
     &1.2273e+01_r8,1.2640e+01_r8,1.2911e+01_r8,1.3015e+01_r8,1.3144e+01_r8/)
      kbo(:,55,12) = (/ &
     &1.2241e+01_r8,1.2456e+01_r8,1.2830e+01_r8,1.3015e+01_r8,1.3103e+01_r8/)
      kbo(:,56,12) = (/ &
     &1.2129e+01_r8,1.2403e+01_r8,1.2744e+01_r8,1.2955e+01_r8,1.3054e+01_r8/)
      kbo(:,57,12) = (/ &
     &1.1983e+01_r8,1.2327e+01_r8,1.2603e+01_r8,1.2910e+01_r8,1.3056e+01_r8/)
      kbo(:,58,12) = (/ &
     &1.1825e+01_r8,1.2269e+01_r8,1.2506e+01_r8,1.2817e+01_r8,1.3023e+01_r8/)
      kbo(:,59,12) = (/ &
     &1.1756e+01_r8,1.2243e+01_r8,1.2496e+01_r8,1.2736e+01_r8,1.2923e+01_r8/)
      kbo(:,13,13) = (/ &
     &2.4382e+00_r8,2.5269e+00_r8,2.6487e+00_r8,2.6115e+00_r8,2.6014e+00_r8/)
      kbo(:,14,13) = (/ &
     &3.1530e+00_r8,3.3624e+00_r8,3.5863e+00_r8,3.8586e+00_r8,4.4708e+00_r8/)
      kbo(:,15,13) = (/ &
     &5.2015e+00_r8,5.3405e+00_r8,5.5020e+00_r8,5.5114e+00_r8,5.5124e+00_r8/)
      kbo(:,16,13) = (/ &
     &5.7225e+00_r8,5.8966e+00_r8,6.0571e+00_r8,6.0559e+00_r8,6.0668e+00_r8/)
      kbo(:,17,13) = (/ &
     &6.2716e+00_r8,6.4422e+00_r8,6.5990e+00_r8,6.6435e+00_r8,6.5757e+00_r8/)
      kbo(:,18,13) = (/ &
     &6.7715e+00_r8,6.9371e+00_r8,7.0939e+00_r8,7.1586e+00_r8,7.0596e+00_r8/)
      kbo(:,19,13) = (/ &
     &7.2728e+00_r8,7.4403e+00_r8,7.6008e+00_r8,7.7026e+00_r8,7.6789e+00_r8/)
      kbo(:,20,13) = (/ &
     &7.8570e+00_r8,8.0286e+00_r8,8.1992e+00_r8,8.3169e+00_r8,8.3122e+00_r8/)
      kbo(:,21,13) = (/ &
     &8.5574e+00_r8,8.7300e+00_r8,8.9004e+00_r8,9.0231e+00_r8,9.0274e+00_r8/)
      kbo(:,22,13) = (/ &
     &9.3806e+00_r8,9.5518e+00_r8,9.7137e+00_r8,9.8169e+00_r8,9.7877e+00_r8/)
      kbo(:,23,13) = (/ &
     &1.0275e+01_r8,1.0446e+01_r8,1.0597e+01_r8,1.0672e+01_r8,1.0640e+01_r8/)
      kbo(:,24,13) = (/ &
     &1.1189e+01_r8,1.1360e+01_r8,1.1491e+01_r8,1.1535e+01_r8,1.1479e+01_r8/)
      kbo(:,25,13) = (/ &
     &1.2097e+01_r8,1.2245e+01_r8,1.2356e+01_r8,1.2332e+01_r8,1.2284e+01_r8/)
      kbo(:,26,13) = (/ &
     &1.2961e+01_r8,1.3082e+01_r8,1.3167e+01_r8,1.3081e+01_r8,1.3047e+01_r8/)
      kbo(:,27,13) = (/ &
     &1.3759e+01_r8,1.3850e+01_r8,1.3907e+01_r8,1.3774e+01_r8,1.3731e+01_r8/)
      kbo(:,28,13) = (/ &
     &1.4487e+01_r8,1.4544e+01_r8,1.4510e+01_r8,1.4345e+01_r8,1.4410e+01_r8/)
      kbo(:,29,13) = (/ &
     &1.5131e+01_r8,1.5152e+01_r8,1.4989e+01_r8,1.4893e+01_r8,1.4931e+01_r8/)
      kbo(:,30,13) = (/ &
     &1.5691e+01_r8,1.5628e+01_r8,1.5428e+01_r8,1.5458e+01_r8,1.5409e+01_r8/)
      kbo(:,31,13) = (/ &
     &1.6170e+01_r8,1.5957e+01_r8,1.5859e+01_r8,1.5855e+01_r8,1.5824e+01_r8/)
      kbo(:,32,13) = (/ &
     &1.6473e+01_r8,1.6259e+01_r8,1.6330e+01_r8,1.6208e+01_r8,1.6186e+01_r8/)
      kbo(:,33,13) = (/ &
     &1.6723e+01_r8,1.6704e+01_r8,1.6654e+01_r8,1.6563e+01_r8,1.6454e+01_r8/)
      kbo(:,34,13) = (/ &
     &1.6982e+01_r8,1.6991e+01_r8,1.6942e+01_r8,1.6797e+01_r8,1.6670e+01_r8/)
      kbo(:,35,13) = (/ &
     &1.7322e+01_r8,1.7270e+01_r8,1.7135e+01_r8,1.6953e+01_r8,1.6879e+01_r8/)
      kbo(:,36,13) = (/ &
     &1.7562e+01_r8,1.7451e+01_r8,1.7282e+01_r8,1.7228e+01_r8,1.7169e+01_r8/)
      kbo(:,37,13) = (/ &
     &1.7777e+01_r8,1.7615e+01_r8,1.7471e+01_r8,1.7494e+01_r8,1.7411e+01_r8/)
      kbo(:,38,13) = (/ &
     &1.7932e+01_r8,1.7773e+01_r8,1.7733e+01_r8,1.7665e+01_r8,1.7616e+01_r8/)
      kbo(:,39,13) = (/ &
     &1.7993e+01_r8,1.7881e+01_r8,1.7968e+01_r8,1.7898e+01_r8,1.7772e+01_r8/)
      kbo(:,40,13) = (/ &
     &1.8148e+01_r8,1.8027e+01_r8,1.8107e+01_r8,1.8066e+01_r8,1.7907e+01_r8/)
      kbo(:,41,13) = (/ &
     &1.8273e+01_r8,1.8183e+01_r8,1.8251e+01_r8,1.8205e+01_r8,1.8057e+01_r8/)
      kbo(:,42,13) = (/ &
     &1.8408e+01_r8,1.8324e+01_r8,1.8378e+01_r8,1.8322e+01_r8,1.8177e+01_r8/)
      kbo(:,43,13) = (/ &
     &1.8505e+01_r8,1.8424e+01_r8,1.8497e+01_r8,1.8450e+01_r8,1.8293e+01_r8/)
      kbo(:,44,13) = (/ &
     &1.8604e+01_r8,1.8490e+01_r8,1.8578e+01_r8,1.8585e+01_r8,1.8430e+01_r8/)
      kbo(:,45,13) = (/ &
     &1.8704e+01_r8,1.8600e+01_r8,1.8704e+01_r8,1.8731e+01_r8,1.8566e+01_r8/)
      kbo(:,46,13) = (/ &
     &1.8778e+01_r8,1.8729e+01_r8,1.8813e+01_r8,1.8830e+01_r8,1.8670e+01_r8/)
      kbo(:,47,13) = (/ &
     &1.8850e+01_r8,1.8781e+01_r8,1.8910e+01_r8,1.8941e+01_r8,1.8764e+01_r8/)
      kbo(:,48,13) = (/ &
     &1.8986e+01_r8,1.8857e+01_r8,1.8976e+01_r8,1.9005e+01_r8,1.8895e+01_r8/)
      kbo(:,49,13) = (/ &
     &1.9095e+01_r8,1.9011e+01_r8,1.9061e+01_r8,1.9086e+01_r8,1.9025e+01_r8/)
      kbo(:,50,13) = (/ &
     &1.9280e+01_r8,1.9083e+01_r8,1.9157e+01_r8,1.9191e+01_r8,1.9123e+01_r8/)
      kbo(:,51,13) = (/ &
     &1.9385e+01_r8,1.9151e+01_r8,1.9215e+01_r8,1.9259e+01_r8,1.9196e+01_r8/)
      kbo(:,52,13) = (/ &
     &1.9488e+01_r8,1.9188e+01_r8,1.9260e+01_r8,1.9328e+01_r8,1.9259e+01_r8/)
      kbo(:,53,13) = (/ &
     &1.9657e+01_r8,1.9231e+01_r8,1.9381e+01_r8,1.9391e+01_r8,1.9331e+01_r8/)
      kbo(:,54,13) = (/ &
     &1.9810e+01_r8,1.9362e+01_r8,1.9357e+01_r8,1.9443e+01_r8,1.9402e+01_r8/)
      kbo(:,55,13) = (/ &
     &1.9885e+01_r8,1.9515e+01_r8,1.9337e+01_r8,1.9415e+01_r8,1.9400e+01_r8/)
      kbo(:,56,13) = (/ &
     &1.9952e+01_r8,1.9629e+01_r8,1.9325e+01_r8,1.9383e+01_r8,1.9431e+01_r8/)
      kbo(:,57,13) = (/ &
     &2.0005e+01_r8,1.9822e+01_r8,1.9466e+01_r8,1.9235e+01_r8,1.9419e+01_r8/)
      kbo(:,58,13) = (/ &
     &2.0044e+01_r8,1.9891e+01_r8,1.9520e+01_r8,1.9352e+01_r8,1.9344e+01_r8/)
      kbo(:,59,13) = (/ &
     &2.0058e+01_r8,1.9920e+01_r8,1.9627e+01_r8,1.9319e+01_r8,1.9225e+01_r8/)
      kbo(:,13,14) = (/ &
     &3.1216e+00_r8,3.1914e+00_r8,3.0899e+00_r8,3.3224e+00_r8,4.2010e+00_r8/)
      kbo(:,14,14) = (/ &
     &7.0173e+00_r8,7.2031e+00_r8,7.3581e+00_r8,7.0289e+00_r8,6.9115e+00_r8/)
      kbo(:,15,14) = (/ &
     &7.9333e+00_r8,8.1347e+00_r8,8.2980e+00_r8,8.2914e+00_r8,7.9259e+00_r8/)
      kbo(:,16,14) = (/ &
     &8.8725e+00_r8,9.0683e+00_r8,9.2568e+00_r8,9.4307e+00_r8,9.0182e+00_r8/)
      kbo(:,17,14) = (/ &
     &9.8363e+00_r8,1.0075e+01_r8,1.0298e+01_r8,1.0509e+01_r8,1.0358e+01_r8/)
      kbo(:,18,14) = (/ &
     &1.0886e+01_r8,1.1174e+01_r8,1.1435e+01_r8,1.1674e+01_r8,1.1694e+01_r8/)
      kbo(:,19,14) = (/ &
     &1.2011e+01_r8,1.2333e+01_r8,1.2632e+01_r8,1.2897e+01_r8,1.3012e+01_r8/)
      kbo(:,20,14) = (/ &
     &1.3190e+01_r8,1.3540e+01_r8,1.3861e+01_r8,1.4163e+01_r8,1.4313e+01_r8/)
      kbo(:,21,14) = (/ &
     &1.4385e+01_r8,1.4764e+01_r8,1.5119e+01_r8,1.5437e+01_r8,1.5593e+01_r8/)
      kbo(:,22,14) = (/ &
     &1.5599e+01_r8,1.6013e+01_r8,1.6388e+01_r8,1.6714e+01_r8,1.6844e+01_r8/)
      kbo(:,23,14) = (/ &
     &1.6855e+01_r8,1.7274e+01_r8,1.7644e+01_r8,1.7957e+01_r8,1.7983e+01_r8/)
      kbo(:,24,14) = (/ &
     &1.8152e+01_r8,1.8541e+01_r8,1.8882e+01_r8,1.9172e+01_r8,1.9130e+01_r8/)
      kbo(:,25,14) = (/ &
     &1.9440e+01_r8,1.9782e+01_r8,2.0084e+01_r8,2.0333e+01_r8,2.0194e+01_r8/)
      kbo(:,26,14) = (/ &
     &2.0688e+01_r8,2.0983e+01_r8,2.1232e+01_r8,2.1433e+01_r8,2.1144e+01_r8/)
      kbo(:,27,14) = (/ &
     &2.1870e+01_r8,2.2106e+01_r8,2.2296e+01_r8,2.2344e+01_r8,2.1989e+01_r8/)
      kbo(:,28,14) = (/ &
     &2.2959e+01_r8,2.3128e+01_r8,2.3255e+01_r8,2.3127e+01_r8,2.2540e+01_r8/)
      kbo(:,29,14) = (/ &
     &2.3936e+01_r8,2.4040e+01_r8,2.4108e+01_r8,2.3686e+01_r8,2.3118e+01_r8/)
      kbo(:,30,14) = (/ &
     &2.4794e+01_r8,2.4831e+01_r8,2.4631e+01_r8,2.3967e+01_r8,2.3807e+01_r8/)
      kbo(:,31,14) = (/ &
     &2.5525e+01_r8,2.5458e+01_r8,2.4921e+01_r8,2.4395e+01_r8,2.4482e+01_r8/)
      kbo(:,32,14) = (/ &
     &2.6140e+01_r8,2.5757e+01_r8,2.4988e+01_r8,2.5111e+01_r8,2.5399e+01_r8/)
      kbo(:,33,14) = (/ &
     &2.6507e+01_r8,2.5703e+01_r8,2.5535e+01_r8,2.5869e+01_r8,2.6121e+01_r8/)
      kbo(:,34,14) = (/ &
     &2.6569e+01_r8,2.5953e+01_r8,2.6151e+01_r8,2.6361e+01_r8,2.6801e+01_r8/)
      kbo(:,35,14) = (/ &
     &2.6562e+01_r8,2.6504e+01_r8,2.6810e+01_r8,2.7029e+01_r8,2.7434e+01_r8/)
      kbo(:,36,14) = (/ &
     &2.6827e+01_r8,2.6824e+01_r8,2.7232e+01_r8,2.7537e+01_r8,2.7695e+01_r8/)
      kbo(:,37,14) = (/ &
     &2.7090e+01_r8,2.7286e+01_r8,2.7649e+01_r8,2.7765e+01_r8,2.8180e+01_r8/)
      kbo(:,38,14) = (/ &
     &2.7488e+01_r8,2.7623e+01_r8,2.7893e+01_r8,2.8192e+01_r8,2.8556e+01_r8/)
      kbo(:,39,14) = (/ &
     &2.7778e+01_r8,2.8122e+01_r8,2.8064e+01_r8,2.8480e+01_r8,2.8841e+01_r8/)
      kbo(:,40,14) = (/ &
     &2.8002e+01_r8,2.8307e+01_r8,2.8286e+01_r8,2.8653e+01_r8,2.9020e+01_r8/)
      kbo(:,41,14) = (/ &
     &2.8205e+01_r8,2.8457e+01_r8,2.8430e+01_r8,2.8865e+01_r8,2.9164e+01_r8/)
      kbo(:,42,14) = (/ &
     &2.8421e+01_r8,2.8563e+01_r8,2.8567e+01_r8,2.9033e+01_r8,2.9360e+01_r8/)
      kbo(:,43,14) = (/ &
     &2.8605e+01_r8,2.8649e+01_r8,2.8746e+01_r8,2.9195e+01_r8,2.9582e+01_r8/)
      kbo(:,44,14) = (/ &
     &2.8719e+01_r8,2.8847e+01_r8,2.8915e+01_r8,2.9326e+01_r8,2.9712e+01_r8/)
      kbo(:,45,14) = (/ &
     &2.9008e+01_r8,2.9000e+01_r8,2.9085e+01_r8,2.9440e+01_r8,2.9882e+01_r8/)
      kbo(:,46,14) = (/ &
     &2.9283e+01_r8,2.9066e+01_r8,2.9214e+01_r8,2.9505e+01_r8,3.0075e+01_r8/)
      kbo(:,47,14) = (/ &
     &2.9505e+01_r8,2.9215e+01_r8,2.9192e+01_r8,2.9549e+01_r8,3.0231e+01_r8/)
      kbo(:,48,14) = (/ &
     &2.9847e+01_r8,2.9465e+01_r8,2.9377e+01_r8,2.9796e+01_r8,3.0530e+01_r8/)
      kbo(:,49,14) = (/ &
     &3.0209e+01_r8,2.9590e+01_r8,2.9613e+01_r8,2.9947e+01_r8,3.0891e+01_r8/)
      kbo(:,50,14) = (/ &
     &3.0555e+01_r8,2.9682e+01_r8,2.9721e+01_r8,3.0034e+01_r8,3.0987e+01_r8/)
      kbo(:,51,14) = (/ &
     &3.0932e+01_r8,2.9941e+01_r8,2.9791e+01_r8,3.0042e+01_r8,3.0973e+01_r8/)
      kbo(:,52,14) = (/ &
     &3.1304e+01_r8,3.0128e+01_r8,2.9896e+01_r8,3.0085e+01_r8,3.1235e+01_r8/)
      kbo(:,53,14) = (/ &
     &3.1593e+01_r8,3.0463e+01_r8,3.0008e+01_r8,3.0297e+01_r8,3.1448e+01_r8/)
      kbo(:,54,14) = (/ &
     &3.1880e+01_r8,3.0666e+01_r8,3.0079e+01_r8,3.0245e+01_r8,3.1244e+01_r8/)
      kbo(:,55,14) = (/ &
     &3.2179e+01_r8,3.1215e+01_r8,3.0197e+01_r8,3.0244e+01_r8,3.0630e+01_r8/)
      kbo(:,56,14) = (/ &
     &3.2496e+01_r8,3.1618e+01_r8,3.0405e+01_r8,3.0157e+01_r8,3.0368e+01_r8/)
      kbo(:,57,14) = (/ &
     &3.2846e+01_r8,3.1885e+01_r8,3.0675e+01_r8,3.0336e+01_r8,3.0326e+01_r8/)
      kbo(:,58,14) = (/ &
     &3.3194e+01_r8,3.2160e+01_r8,3.1205e+01_r8,3.0229e+01_r8,3.0346e+01_r8/)
      kbo(:,59,14) = (/ &
     &3.3342e+01_r8,3.2279e+01_r8,3.1453e+01_r8,3.0328e+01_r8,3.0152e+01_r8/)
      kbo(:,13,15) = (/ &
     &4.0030e+00_r8,4.7414e+00_r8,5.8560e+00_r8,6.7438e+00_r8,3.2808e+00_r8/)
      kbo(:,14,15) = (/ &
     &9.0899e+00_r8,9.4664e+00_r8,9.7823e+00_r8,1.0059e+01_r8,8.9794e+00_r8/)
      kbo(:,15,15) = (/ &
     &1.0857e+01_r8,1.1261e+01_r8,1.1617e+01_r8,1.1923e+01_r8,1.1563e+01_r8/)
      kbo(:,16,15) = (/ &
     &1.2889e+01_r8,1.3334e+01_r8,1.3725e+01_r8,1.4064e+01_r8,1.4341e+01_r8/)
      kbo(:,17,15) = (/ &
     &1.5204e+01_r8,1.5687e+01_r8,1.6115e+01_r8,1.6474e+01_r8,1.6771e+01_r8/)
      kbo(:,18,15) = (/ &
     &1.7808e+01_r8,1.8322e+01_r8,1.8770e+01_r8,1.9149e+01_r8,1.9438e+01_r8/)
      kbo(:,19,15) = (/ &
     &2.0675e+01_r8,2.1216e+01_r8,2.1671e+01_r8,2.2040e+01_r8,2.2294e+01_r8/)
      kbo(:,20,15) = (/ &
     &2.3784e+01_r8,2.4335e+01_r8,2.4780e+01_r8,2.5092e+01_r8,2.5318e+01_r8/)
      kbo(:,21,15) = (/ &
     &2.7074e+01_r8,2.7616e+01_r8,2.7992e+01_r8,2.8260e+01_r8,2.8435e+01_r8/)
      kbo(:,22,15) = (/ &
     &3.0512e+01_r8,3.0967e+01_r8,3.1281e+01_r8,3.1482e+01_r8,3.1588e+01_r8/)
      kbo(:,23,15) = (/ &
     &3.3946e+01_r8,3.4307e+01_r8,3.4554e+01_r8,3.4683e+01_r8,3.4702e+01_r8/)
      kbo(:,24,15) = (/ &
     &3.7353e+01_r8,3.7642e+01_r8,3.7797e+01_r8,3.7830e+01_r8,3.7737e+01_r8/)
      kbo(:,25,15) = (/ &
     &4.0725e+01_r8,4.0910e+01_r8,4.0948e+01_r8,4.0847e+01_r8,4.0612e+01_r8/)
      kbo(:,26,15) = (/ &
     &4.3991e+01_r8,4.4018e+01_r8,4.3898e+01_r8,4.3642e+01_r8,4.3255e+01_r8/)
      kbo(:,27,15) = (/ &
     &4.7033e+01_r8,4.6887e+01_r8,4.6594e+01_r8,4.6165e+01_r8,4.5614e+01_r8/)
      kbo(:,28,15) = (/ &
     &4.9783e+01_r8,4.9454e+01_r8,4.8983e+01_r8,4.8387e+01_r8,4.7672e+01_r8/)
      kbo(:,29,15) = (/ &
     &5.2209e+01_r8,5.1689e+01_r8,5.1048e+01_r8,5.0282e+01_r8,4.9143e+01_r8/)
      kbo(:,30,15) = (/ &
     &5.4285e+01_r8,5.3590e+01_r8,5.2778e+01_r8,5.1862e+01_r8,4.9504e+01_r8/)
      kbo(:,31,15) = (/ &
     &5.6017e+01_r8,5.5158e+01_r8,5.4192e+01_r8,5.2520e+01_r8,4.8958e+01_r8/)
      kbo(:,32,15) = (/ &
     &5.7422e+01_r8,5.6414e+01_r8,5.5126e+01_r8,5.1643e+01_r8,4.7729e+01_r8/)
      kbo(:,33,15) = (/ &
     &5.8538e+01_r8,5.7396e+01_r8,5.4438e+01_r8,4.9797e+01_r8,4.8468e+01_r8/)
      kbo(:,34,15) = (/ &
     &5.9425e+01_r8,5.7428e+01_r8,5.3101e+01_r8,5.0744e+01_r8,5.0414e+01_r8/)
      kbo(:,35,15) = (/ &
     &6.0220e+01_r8,5.6550e+01_r8,5.2246e+01_r8,5.2031e+01_r8,5.2160e+01_r8/)
      kbo(:,36,15) = (/ &
     &6.0380e+01_r8,5.6323e+01_r8,5.3290e+01_r8,5.3091e+01_r8,5.1837e+01_r8/)
      kbo(:,37,15) = (/ &
     &6.1064e+01_r8,5.6288e+01_r8,5.3962e+01_r8,5.4330e+01_r8,5.1190e+01_r8/)
      kbo(:,38,15) = (/ &
     &6.1244e+01_r8,5.6422e+01_r8,5.4974e+01_r8,5.5783e+01_r8,5.0823e+01_r8/)
      kbo(:,39,15) = (/ &
     &6.1491e+01_r8,5.6521e+01_r8,5.6495e+01_r8,5.7139e+01_r8,5.0363e+01_r8/)
      kbo(:,40,15) = (/ &
     &6.2285e+01_r8,5.7310e+01_r8,5.7143e+01_r8,5.8068e+01_r8,5.1166e+01_r8/)
      kbo(:,41,15) = (/ &
     &6.3214e+01_r8,5.7786e+01_r8,5.7889e+01_r8,5.8807e+01_r8,5.2057e+01_r8/)
      kbo(:,42,15) = (/ &
     &6.3921e+01_r8,5.8540e+01_r8,5.8564e+01_r8,5.9508e+01_r8,5.2732e+01_r8/)
      kbo(:,43,15) = (/ &
     &6.4936e+01_r8,5.9750e+01_r8,5.9252e+01_r8,6.0188e+01_r8,5.3641e+01_r8/)
      kbo(:,44,15) = (/ &
     &6.6180e+01_r8,6.0810e+01_r8,5.9653e+01_r8,6.1132e+01_r8,5.4737e+01_r8/)
      kbo(:,45,15) = (/ &
     &6.6949e+01_r8,6.1798e+01_r8,5.9966e+01_r8,6.1660e+01_r8,5.5582e+01_r8/)
      kbo(:,46,15) = (/ &
     &6.7824e+01_r8,6.2979e+01_r8,6.0686e+01_r8,6.2546e+01_r8,5.6565e+01_r8/)
      kbo(:,47,15) = (/ &
     &6.9039e+01_r8,6.4342e+01_r8,6.1803e+01_r8,6.2906e+01_r8,5.8086e+01_r8/)
      kbo(:,48,15) = (/ &
     &6.9761e+01_r8,6.5409e+01_r8,6.2421e+01_r8,6.3565e+01_r8,5.8945e+01_r8/)
      kbo(:,49,15) = (/ &
     &7.0431e+01_r8,6.6423e+01_r8,6.3050e+01_r8,6.4501e+01_r8,5.9296e+01_r8/)
      kbo(:,50,15) = (/ &
     &7.1030e+01_r8,6.7738e+01_r8,6.3115e+01_r8,6.5100e+01_r8,6.0669e+01_r8/)
      kbo(:,51,15) = (/ &
     &7.1594e+01_r8,6.8849e+01_r8,6.3996e+01_r8,6.5429e+01_r8,6.2495e+01_r8/)
      kbo(:,52,15) = (/ &
     &7.2143e+01_r8,7.0005e+01_r8,6.4776e+01_r8,6.5575e+01_r8,6.3548e+01_r8/)
      kbo(:,53,15) = (/ &
     &7.2670e+01_r8,7.0732e+01_r8,6.5046e+01_r8,6.6263e+01_r8,6.4505e+01_r8/)
      kbo(:,54,15) = (/ &
     &7.3127e+01_r8,7.1823e+01_r8,6.6914e+01_r8,6.6275e+01_r8,6.7029e+01_r8/)
      kbo(:,55,15) = (/ &
     &7.3553e+01_r8,7.2289e+01_r8,6.8950e+01_r8,6.5529e+01_r8,6.7722e+01_r8/)
      kbo(:,56,15) = (/ &
     &7.3983e+01_r8,7.2738e+01_r8,7.0656e+01_r8,6.5646e+01_r8,6.6961e+01_r8/)
      kbo(:,57,15) = (/ &
     &7.4388e+01_r8,7.3166e+01_r8,7.1848e+01_r8,6.6976e+01_r8,6.6137e+01_r8/)
      kbo(:,58,15) = (/ &
     &7.4771e+01_r8,7.3567e+01_r8,7.2279e+01_r8,6.9020e+01_r8,6.5380e+01_r8/)
      kbo(:,59,15) = (/ &
     &7.4949e+01_r8,7.3730e+01_r8,7.2460e+01_r8,7.0691e+01_r8,6.5332e+01_r8/)
      kbo(:,13,16) = (/ &
     &5.0420e+00_r8,8.6337e+00_r8,8.8692e+00_r8,1.2195e+00_r8,9.3776e-01_r8/)
      kbo(:,14,16) = (/ &
     &1.0108e+01_r8,1.0449e+01_r8,1.0740e+01_r8,1.1004e+01_r8,9.1915e-01_r8/)
      kbo(:,15,16) = (/ &
     &1.2227e+01_r8,1.2648e+01_r8,1.3007e+01_r8,1.3327e+01_r8,1.3667e+01_r8/)
      kbo(:,16,16) = (/ &
     &1.4789e+01_r8,1.5299e+01_r8,1.5728e+01_r8,1.6109e+01_r8,1.6498e+01_r8/)
      kbo(:,17,16) = (/ &
     &1.7862e+01_r8,1.8466e+01_r8,1.8964e+01_r8,1.9401e+01_r8,1.9824e+01_r8/)
      kbo(:,18,16) = (/ &
     &2.1506e+01_r8,2.2192e+01_r8,2.2762e+01_r8,2.3238e+01_r8,2.3665e+01_r8/)
      kbo(:,19,16) = (/ &
     &2.5786e+01_r8,2.6523e+01_r8,2.7142e+01_r8,2.7627e+01_r8,2.8030e+01_r8/)
      kbo(:,20,16) = (/ &
     &3.0723e+01_r8,3.1489e+01_r8,3.2109e+01_r8,3.2556e+01_r8,3.2877e+01_r8/)
      kbo(:,21,16) = (/ &
     &3.6293e+01_r8,3.7031e+01_r8,3.7583e+01_r8,3.7941e+01_r8,3.8130e+01_r8/)
      kbo(:,22,16) = (/ &
     &4.2493e+01_r8,4.3104e+01_r8,4.3485e+01_r8,4.3668e+01_r8,4.3655e+01_r8/)
      kbo(:,23,16) = (/ &
     &4.9099e+01_r8,4.9493e+01_r8,4.9618e+01_r8,4.9538e+01_r8,4.9251e+01_r8/)
      kbo(:,24,16) = (/ &
     &5.5931e+01_r8,5.5983e+01_r8,5.5792e+01_r8,5.5378e+01_r8,5.4757e+01_r8/)
      kbo(:,25,16) = (/ &
     &6.2744e+01_r8,6.2387e+01_r8,6.1774e+01_r8,6.0982e+01_r8,5.9987e+01_r8/)
      kbo(:,26,16) = (/ &
     &6.9294e+01_r8,6.8455e+01_r8,6.7400e+01_r8,6.6158e+01_r8,6.4771e+01_r8/)
      kbo(:,27,16) = (/ &
     &7.5369e+01_r8,7.4018e+01_r8,7.2501e+01_r8,7.0820e+01_r8,6.9030e+01_r8/)
      kbo(:,28,16) = (/ &
     &8.0847e+01_r8,7.8971e+01_r8,7.6973e+01_r8,7.4879e+01_r8,7.2699e+01_r8/)
      kbo(:,29,16) = (/ &
     &8.5588e+01_r8,8.3223e+01_r8,8.0777e+01_r8,7.8292e+01_r8,7.5762e+01_r8/)
      kbo(:,30,16) = (/ &
     &8.9575e+01_r8,8.6758e+01_r8,8.3320e+01_r8,8.1073e+01_r8,7.8238e+01_r8/)
      kbo(:,31,16) = (/ &
     &9.2801e+01_r8,8.9596e+01_r8,8.6404e+01_r8,8.3251e+01_r8,8.0171e+01_r8/)
      kbo(:,32,16) = (/ &
     &9.5328e+01_r8,9.1774e+01_r8,8.8298e+01_r8,8.4902e+01_r8,7.6985e+01_r8/)
      kbo(:,33,16) = (/ &
     &9.7221e+01_r8,9.3383e+01_r8,8.9667e+01_r8,8.6065e+01_r8,5.8850e+01_r8/)
      kbo(:,34,16) = (/ &
     &9.8688e+01_r8,9.4629e+01_r8,9.0722e+01_r8,7.0430e+01_r8,3.0605e+01_r8/)
      kbo(:,35,16) = (/ &
     &1.0011e+02_r8,9.5862e+01_r8,8.7207e+01_r8,5.0589e+01_r8,4.4567e+00_r8/)
      kbo(:,36,16) = (/ &
     &1.0168e+02_r8,9.7257e+01_r8,7.6588e+01_r8,3.3945e+01_r8,3.3821e-01_r8/)
      kbo(:,37,16) = (/ &
     &1.0369e+02_r8,9.9078e+01_r8,7.2492e+01_r8,2.6526e+01_r8,3.3765e-01_r8/)
      kbo(:,38,16) = (/ &
     &1.0555e+02_r8,1.0077e+02_r8,6.5594e+01_r8,1.3779e+01_r8,3.3740e-01_r8/)
      kbo(:,39,16) = (/ &
     &1.0726e+02_r8,9.7866e+01_r8,5.5055e+01_r8,3.4196e-01_r8,3.3714e-01_r8/)
      kbo(:,40,16) = (/ &
     &1.0936e+02_r8,1.0037e+02_r8,5.6740e+01_r8,3.4227e-01_r8,3.3798e-01_r8/)
      kbo(:,41,16) = (/ &
     &1.1147e+02_r8,1.0552e+02_r8,5.9119e+01_r8,1.0312e+00_r8,3.3873e-01_r8/)
      kbo(:,42,16) = (/ &
     &1.1349e+02_r8,1.0806e+02_r8,6.1522e+01_r8,2.4025e+00_r8,3.3958e-01_r8/)
      kbo(:,43,16) = (/ &
     &1.1581e+02_r8,1.1021e+02_r8,6.4818e+01_r8,5.9686e+00_r8,3.4048e-01_r8/)
      kbo(:,44,16) = (/ &
     &1.1830e+02_r8,1.1248e+02_r8,7.1730e+01_r8,8.2150e+00_r8,3.4135e-01_r8/)
      kbo(:,45,16) = (/ &
     &1.2075e+02_r8,1.1473e+02_r8,7.7444e+01_r8,1.2041e+01_r8,3.1303e-01_r8/)
      kbo(:,46,16) = (/ &
     &1.2335e+02_r8,1.1716e+02_r8,8.1949e+01_r8,1.5245e+01_r8,3.1351e-01_r8/)
      kbo(:,47,16) = (/ &
     &1.2629e+02_r8,1.1987e+02_r8,8.8206e+01_r8,2.5272e+01_r8,3.1369e-01_r8/)
      kbo(:,48,16) = (/ &
     &1.2931e+02_r8,1.2262e+02_r8,9.4686e+01_r8,2.9706e+01_r8,3.1394e-01_r8/)
      kbo(:,49,16) = (/ &
     &1.3237e+02_r8,1.2544e+02_r8,9.8342e+01_r8,3.1959e+01_r8,3.1361e-01_r8/)
      kbo(:,50,16) = (/ &
     &1.3530e+02_r8,1.2816e+02_r8,1.0881e+02_r8,3.8226e+01_r8,3.1326e-01_r8/)
      kbo(:,51,16) = (/ &
     &1.3828e+02_r8,1.3089e+02_r8,1.1491e+02_r8,4.8666e+01_r8,3.1193e-01_r8/)
      kbo(:,52,16) = (/ &
     &1.4134e+02_r8,1.3361e+02_r8,1.2195e+02_r8,5.9393e+01_r8,3.1051e-01_r8/)
      kbo(:,53,16) = (/ &
     &1.4442e+02_r8,1.3646e+02_r8,1.2918e+02_r8,6.3097e+01_r8,3.0922e-01_r8/)
      kbo(:,54,16) = (/ &
     &1.4741e+02_r8,1.3916e+02_r8,1.3165e+02_r8,7.8318e+01_r8,3.0699e-01_r8/)
      kbo(:,55,16) = (/ &
     &1.5037e+02_r8,1.4182e+02_r8,1.3403e+02_r8,1.0259e+02_r8,2.6611e+01_r8/)
      kbo(:,56,16) = (/ &
     &1.5341e+02_r8,1.4449e+02_r8,1.3650e+02_r8,1.2291e+02_r8,5.4887e+01_r8/)
      kbo(:,57,16) = (/ &
     &1.5661e+02_r8,1.4731e+02_r8,1.3904e+02_r8,1.3152e+02_r8,7.9860e+01_r8/)
      kbo(:,58,16) = (/ &
     &1.5976e+02_r8,1.5007e+02_r8,1.4153e+02_r8,1.3378e+02_r8,1.0477e+02_r8/)
      kbo(:,59,16) = (/ &
     &1.6110e+02_r8,1.5124e+02_r8,1.4255e+02_r8,1.3470e+02_r8,1.2755e+02_r8/)

!     The array KAO_Mxx contains the absorption coefficient for 
!     a minor species at the 16 chosen g-values for a reference pressure
!     level below 100~ mb.   The first index refers to temperature 
!     in 7.2 degree increments.  For instance, JT = 1 refers to a 
!     temperature of 188.0, JT = 2 refers to 195.2, etc. The second index 
!     runs over the g-channel (1 to 16).

      kao_mco2(:, 1) = (/ &
     & 8.88964e-07_r8, 1.13087e-06_r8, 1.43861e-06_r8, 1.83010e-06_r8, 2.32811e-06_r8, &
     & 2.96165e-06_r8, 3.76760e-06_r8, 4.79286e-06_r8, 6.09712e-06_r8, 7.75630e-06_r8, &
     & 9.86699e-06_r8, 1.25521e-05_r8, 1.59678e-05_r8, 2.03130e-05_r8, 2.58407e-05_r8, &
     & 3.28727e-05_r8, 4.18182e-05_r8, 5.31980e-05_r8, 6.76745e-05_r8/)
      kao_mco2(:, 2) = (/ &
     & 1.10492e-05_r8, 1.35003e-05_r8, 1.64952e-05_r8, 2.01545e-05_r8, 2.46256e-05_r8, &
     & 3.00885e-05_r8, 3.67632e-05_r8, 4.49188e-05_r8, 5.48835e-05_r8, 6.70588e-05_r8, &
     & 8.19351e-05_r8, 1.00111e-04_r8, 1.22320e-04_r8, 1.49455e-04_r8, 1.82610e-04_r8, &
     & 2.23121e-04_r8, 2.72618e-04_r8, 3.33095e-04_r8, 4.06988e-04_r8/)
      kao_mco2(:, 3) = (/ &
     & 1.51034e-05_r8, 1.81249e-05_r8, 2.17508e-05_r8, 2.61020e-05_r8, 3.13238e-05_r8, &
     & 3.75901e-05_r8, 4.51101e-05_r8, 5.41344e-05_r8, 6.49640e-05_r8, 7.79601e-05_r8, &
     & 9.35562e-05_r8, 1.12272e-04_r8, 1.34732e-04_r8, 1.61686e-04_r8, 1.94031e-04_r8, &
     & 2.32847e-04_r8, 2.79429e-04_r8, 3.35329e-04_r8, 4.02411e-04_r8/)
      kao_mco2(:, 4) = (/ &
     & 1.57088e-05_r8, 1.89537e-05_r8, 2.28688e-05_r8, 2.75928e-05_r8, 3.32924e-05_r8, &
     & 4.01695e-05_r8, 4.84671e-05_r8, 5.84787e-05_r8, 7.05584e-05_r8, 8.51332e-05_r8, &
     & 1.02719e-04_r8, 1.23937e-04_r8, 1.49538e-04_r8, 1.80427e-04_r8, 2.17697e-04_r8, &
     & 2.62666e-04_r8, 3.16923e-04_r8, 3.82388e-04_r8, 4.61376e-04_r8/)
      kao_mco2(:, 5) = (/ &
     & 3.09299e-05_r8, 3.73196e-05_r8, 4.50294e-05_r8, 5.43320e-05_r8, 6.55563e-05_r8, &
     & 7.90995e-05_r8, 9.54405e-05_r8, 1.15157e-04_r8, 1.38948e-04_r8, 1.67652e-04_r8, &
     & 2.02288e-04_r8, 2.44078e-04_r8, 2.94501e-04_r8, 3.55342e-04_r8, 4.28751e-04_r8, &
     & 5.17327e-04_r8, 6.24200e-04_r8, 7.53153e-04_r8, 9.08745e-04_r8/)
      kao_mco2(:, 6) = (/ &
     & 1.98653e-05_r8, 2.38878e-05_r8, 2.87248e-05_r8, 3.45413e-05_r8, 4.15355e-05_r8, &
     & 4.99459e-05_r8, 6.00593e-05_r8, 7.22206e-05_r8, 8.68445e-05_r8, 1.04429e-04_r8, &
     & 1.25575e-04_r8, 1.51003e-04_r8, 1.81579e-04_r8, 2.18346e-04_r8, 2.62559e-04_r8, &
     & 3.15724e-04_r8, 3.79654e-04_r8, 4.56529e-04_r8, 5.48971e-04_r8/)
      kao_mco2(:, 7) = (/ &
     & 1.54276e-06_r8, 1.90144e-06_r8, 2.34351e-06_r8, 2.88836e-06_r8, 3.55989e-06_r8, &
     & 4.38754e-06_r8, 5.40761e-06_r8, 6.66485e-06_r8, 8.21439e-06_r8, 1.01242e-05_r8, &
     & 1.24780e-05_r8, 1.53790e-05_r8, 1.89546e-05_r8, 2.33614e-05_r8, 2.87928e-05_r8, &
     & 3.54869e-05_r8, 4.37374e-05_r8, 5.39060e-05_r8, 6.64388e-05_r8/)
      kao_mco2(:, 8) = (/ &
     & 1.66907e-06_r8, 2.11106e-06_r8, 2.67008e-06_r8, 3.37714e-06_r8, 4.27143e-06_r8, &
     & 5.40254e-06_r8, 6.83318e-06_r8, 8.64266e-06_r8, 1.09313e-05_r8, 1.38260e-05_r8, &
     & 1.74872e-05_r8, 2.21180e-05_r8, 2.79750e-05_r8, 3.53830e-05_r8, 4.47527e-05_r8, &
     & 5.66036e-05_r8, 7.15927e-05_r8, 9.05509e-05_r8, 1.14529e-04_r8/)
      kao_mco2(:, 9) = (/ &
     & 1.22817e-06_r8, 1.56416e-06_r8, 1.99206e-06_r8, 2.53703e-06_r8, 3.23108e-06_r8, &
     & 4.11501e-06_r8, 5.24074e-06_r8, 6.67445e-06_r8, 8.50037e-06_r8, 1.08258e-05_r8, &
     & 1.37874e-05_r8, 1.75592e-05_r8, 2.23629e-05_r8, 2.84807e-05_r8, 3.62721e-05_r8, &
     & 4.61950e-05_r8, 5.88325e-05_r8, 7.49272e-05_r8, 9.54249e-05_r8/)
      kao_mco2(:,10) = (/ &
     & 3.45943e-08_r8, 3.84726e-08_r8, 4.27856e-08_r8, 4.75821e-08_r8, 5.29164e-08_r8, &
     & 5.88487e-08_r8, 6.54460e-08_r8, 7.27829e-08_r8, 8.09423e-08_r8, 9.00164e-08_r8, &
     & 1.00108e-07_r8, 1.11331e-07_r8, 1.23811e-07_r8, 1.37691e-07_r8, 1.53128e-07_r8, &
     & 1.70294e-07_r8, 1.89385e-07_r8, 2.10616e-07_r8, 2.34228e-07_r8/)
      kao_mco2(:,11) = (/ &
     & 2.89971e-08_r8, 3.35110e-08_r8, 3.87275e-08_r8, 4.47561e-08_r8, 5.17230e-08_r8, &
     & 5.97745e-08_r8, 6.90794e-08_r8, 7.98327e-08_r8, 9.22599e-08_r8, 1.06622e-07_r8, &
     & 1.23219e-07_r8, 1.42400e-07_r8, 1.64567e-07_r8, 1.90184e-07_r8, 2.19789e-07_r8, &
     & 2.54003e-07_r8, 2.93542e-07_r8, 3.39237e-07_r8, 3.92044e-07_r8/)
      kao_mco2(:,12) = (/ &
     & 2.51330e-08_r8, 2.96783e-08_r8, 3.50457e-08_r8, 4.13837e-08_r8, 4.88679e-08_r8, &
     & 5.77056e-08_r8, 6.81416e-08_r8, 8.04650e-08_r8, 9.50171e-08_r8, 1.12201e-07_r8, &
     & 1.32492e-07_r8, 1.56454e-07_r8, 1.84748e-07_r8, 2.18160e-07_r8, 2.57614e-07_r8, &
     & 3.04203e-07_r8, 3.59218e-07_r8, 4.24182e-07_r8, 5.00895e-07_r8/)
      kao_mco2(:,13) = (/ &
     & 1.16966e-07_r8, 1.13960e-07_r8, 1.11032e-07_r8, 1.08179e-07_r8, 1.05400e-07_r8, &
     & 1.02691e-07_r8, 1.00053e-07_r8, 9.74820e-08_r8, 9.49772e-08_r8, 9.25368e-08_r8, &
     & 9.01591e-08_r8, 8.78425e-08_r8, 8.55854e-08_r8, 8.33863e-08_r8, 8.12437e-08_r8, &
     & 7.91562e-08_r8, 7.71223e-08_r8, 7.51407e-08_r8, 7.32100e-08_r8/)
      kao_mco2(:,14) = (/ &
     & 9.17853e-08_r8, 8.94322e-08_r8, 8.71395e-08_r8, 8.49055e-08_r8, 8.27289e-08_r8, &
     & 8.06080e-08_r8, 7.85415e-08_r8, 7.65279e-08_r8, 7.45660e-08_r8, 7.26544e-08_r8, &
     & 7.07918e-08_r8, 6.89770e-08_r8, 6.72086e-08_r8, 6.54856e-08_r8, 6.38068e-08_r8, &
     & 6.21710e-08_r8, 6.05772e-08_r8, 5.90242e-08_r8, 5.75110e-08_r8/)
      kao_mco2(:,15) = (/ &
     & 8.34607e-08_r8, 8.13236e-08_r8, 7.92413e-08_r8, 7.72122e-08_r8, 7.52351e-08_r8, &
     & 7.33087e-08_r8, 7.14315e-08_r8, 6.96025e-08_r8, 6.78202e-08_r8, 6.60837e-08_r8, &
     & 6.43915e-08_r8, 6.27427e-08_r8, 6.11361e-08_r8, 5.95707e-08_r8, 5.80453e-08_r8, &
     & 5.65590e-08_r8, 5.51108e-08_r8, 5.36996e-08_r8, 5.23246e-08_r8/)
      kao_mco2(:,16) = (/ &
     & 8.34607e-08_r8, 8.13236e-08_r8, 7.92413e-08_r8, 7.72122e-08_r8, 7.52351e-08_r8, &
     & 7.33087e-08_r8, 7.14315e-08_r8, 6.96025e-08_r8, 6.78202e-08_r8, 6.60837e-08_r8, &
     & 6.43915e-08_r8, 6.27427e-08_r8, 6.11361e-08_r8, 5.95707e-08_r8, 5.80453e-08_r8, &
     & 5.65590e-08_r8, 5.51108e-08_r8, 5.36996e-08_r8, 5.23246e-08_r8/)
      kao_mo3(:, 1) = (/ &
     & 1.18276e-01_r8, 1.18009e-01_r8, 1.17742e-01_r8, 1.17476e-01_r8, 1.17210e-01_r8, &
     & 1.16945e-01_r8, 1.16681e-01_r8, 1.16417e-01_r8, 1.16153e-01_r8, 1.15891e-01_r8, &
     & 1.15629e-01_r8, 1.15367e-01_r8, 1.15106e-01_r8, 1.14846e-01_r8, 1.14586e-01_r8, &
     & 1.14327e-01_r8, 1.14069e-01_r8, 1.13811e-01_r8, 1.13553e-01_r8/)
      kao_mo3(:, 2) = (/ &
     & 1.83777e-01_r8, 1.84268e-01_r8, 1.84761e-01_r8, 1.85255e-01_r8, 1.85751e-01_r8, &
     & 1.86248e-01_r8, 1.86746e-01_r8, 1.87245e-01_r8, 1.87746e-01_r8, 1.88248e-01_r8, &
     & 1.88752e-01_r8, 1.89257e-01_r8, 1.89763e-01_r8, 1.90270e-01_r8, 1.90779e-01_r8, &
     & 1.91290e-01_r8, 1.91801e-01_r8, 1.92314e-01_r8, 1.92829e-01_r8/)
      kao_mo3(:, 3) = (/ &
     & 2.33414e-01_r8, 2.34511e-01_r8, 2.35614e-01_r8, 2.36722e-01_r8, 2.37836e-01_r8, &
     & 2.38954e-01_r8, 2.40078e-01_r8, 2.41207e-01_r8, 2.42342e-01_r8, 2.43481e-01_r8, &
     & 2.44626e-01_r8, 2.45777e-01_r8, 2.46933e-01_r8, 2.48094e-01_r8, 2.49261e-01_r8, &
     & 2.50433e-01_r8, 2.51611e-01_r8, 2.52794e-01_r8, 2.53983e-01_r8/)
      kao_mo3(:, 4) = (/ &
     & 2.84906e-01_r8, 2.87358e-01_r8, 2.89832e-01_r8, 2.92328e-01_r8, 2.94844e-01_r8, &
     & 2.97383e-01_r8, 2.99943e-01_r8, 3.02525e-01_r8, 3.05130e-01_r8, 3.07757e-01_r8, &
     & 3.10406e-01_r8, 3.13078e-01_r8, 3.15774e-01_r8, 3.18492e-01_r8, 3.21234e-01_r8, &
     & 3.24000e-01_r8, 3.26789e-01_r8, 3.29603e-01_r8, 3.32440e-01_r8/)
      kao_mo3(:, 5) = (/ &
     & 3.40508e-01_r8, 3.44095e-01_r8, 3.47720e-01_r8, 3.51383e-01_r8, 3.55084e-01_r8, &
     & 3.58824e-01_r8, 3.62604e-01_r8, 3.66424e-01_r8, 3.70284e-01_r8, 3.74184e-01_r8, &
     & 3.78126e-01_r8, 3.82109e-01_r8, 3.86134e-01_r8, 3.90202e-01_r8, 3.94312e-01_r8, &
     & 3.98466e-01_r8, 4.02663e-01_r8, 4.06905e-01_r8, 4.11191e-01_r8/)
      kao_mo3(:, 6) = (/ &
     & 3.78368e-01_r8, 3.83690e-01_r8, 3.89086e-01_r8, 3.94558e-01_r8, 4.00107e-01_r8, &
     & 4.05735e-01_r8, 4.11441e-01_r8, 4.17227e-01_r8, 4.23095e-01_r8, 4.29046e-01_r8, &
     & 4.35080e-01_r8, 4.41199e-01_r8, 4.47404e-01_r8, 4.53697e-01_r8, 4.60078e-01_r8, &
     & 4.66548e-01_r8, 4.73110e-01_r8, 4.79764e-01_r8, 4.86511e-01_r8/)
      kao_mo3(:, 7) = (/ &
     & 4.51965e-01_r8, 4.58461e-01_r8, 4.65051e-01_r8, 4.71735e-01_r8, 4.78516e-01_r8, &
     & 4.85394e-01_r8, 4.92371e-01_r8, 4.99448e-01_r8, 5.06627e-01_r8, 5.13909e-01_r8, &
     & 5.21296e-01_r8, 5.28789e-01_r8, 5.36390e-01_r8, 5.44100e-01_r8, 5.51920e-01_r8, &
     & 5.59854e-01_r8, 5.67901e-01_r8, 5.76064e-01_r8, 5.84344e-01_r8/)
      kao_mo3(:, 8) = (/ &
     & 3.00557e-01_r8, 3.03974e-01_r8, 3.07430e-01_r8, 3.10925e-01_r8, 3.14460e-01_r8, &
     & 3.18035e-01_r8, 3.21651e-01_r8, 3.25307e-01_r8, 3.29006e-01_r8, 3.32746e-01_r8, &
     & 3.36529e-01_r8, 3.40355e-01_r8, 3.44224e-01_r8, 3.48137e-01_r8, 3.52095e-01_r8, &
     & 3.56098e-01_r8, 3.60146e-01_r8, 3.64241e-01_r8, 3.68381e-01_r8/)
      kao_mo3(:, 9) = (/ &
     & 2.10042e-01_r8, 2.12905e-01_r8, 2.15806e-01_r8, 2.18748e-01_r8, 2.21729e-01_r8, &
     & 2.24751e-01_r8, 2.27814e-01_r8, 2.30919e-01_r8, 2.34066e-01_r8, 2.37256e-01_r8, &
     & 2.40489e-01_r8, 2.43767e-01_r8, 2.47089e-01_r8, 2.50457e-01_r8, 2.53870e-01_r8, &
     & 2.57330e-01_r8, 2.60837e-01_r8, 2.64392e-01_r8, 2.67996e-01_r8/)
      kao_mo3(:,10) = (/ &
     & 2.09288e-01_r8, 2.11759e-01_r8, 2.14259e-01_r8, 2.16789e-01_r8, 2.19349e-01_r8, &
     & 2.21939e-01_r8, 2.24559e-01_r8, 2.27210e-01_r8, 2.29893e-01_r8, 2.32607e-01_r8, &
     & 2.35354e-01_r8, 2.38133e-01_r8, 2.40944e-01_r8, 2.43789e-01_r8, 2.46667e-01_r8, &
     & 2.49580e-01_r8, 2.52527e-01_r8, 2.55508e-01_r8, 2.58525e-01_r8/)
      kao_mo3(:,11) = (/ &
     & 2.28947e-01_r8, 2.30609e-01_r8, 2.32283e-01_r8, 2.33969e-01_r8, 2.35667e-01_r8, &
     & 2.37378e-01_r8, 2.39101e-01_r8, 2.40836e-01_r8, 2.42584e-01_r8, 2.44345e-01_r8, &
     & 2.46118e-01_r8, 2.47905e-01_r8, 2.49704e-01_r8, 2.51516e-01_r8, 2.53342e-01_r8, &
     & 2.55181e-01_r8, 2.57033e-01_r8, 2.58899e-01_r8, 2.60778e-01_r8/)
      kao_mo3(:,12) = (/ &
     & 2.57263e-01_r8, 2.58272e-01_r8, 2.59285e-01_r8, 2.60302e-01_r8, 2.61323e-01_r8, &
     & 2.62347e-01_r8, 2.63376e-01_r8, 2.64409e-01_r8, 2.65446e-01_r8, 2.66487e-01_r8, &
     & 2.67532e-01_r8, 2.68581e-01_r8, 2.69635e-01_r8, 2.70692e-01_r8, 2.71753e-01_r8, &
     & 2.72819e-01_r8, 2.73889e-01_r8, 2.74963e-01_r8, 2.76042e-01_r8/)
      kao_mo3(:,13) = (/ &
     & 2.43322e-01_r8, 2.45918e-01_r8, 2.48541e-01_r8, 2.51192e-01_r8, 2.53872e-01_r8, &
     & 2.56580e-01_r8, 2.59317e-01_r8, 2.62083e-01_r8, 2.64879e-01_r8, 2.67704e-01_r8, &
     & 2.70560e-01_r8, 2.73446e-01_r8, 2.76363e-01_r8, 2.79311e-01_r8, 2.82290e-01_r8, &
     & 2.85302e-01_r8, 2.88345e-01_r8, 2.91421e-01_r8, 2.94529e-01_r8/)
      kao_mo3(:,14) = (/ &
     & 2.10568e-01_r8, 2.16529e-01_r8, 2.22660e-01_r8, 2.28964e-01_r8, 2.35446e-01_r8, &
     & 2.42113e-01_r8, 2.48967e-01_r8, 2.56016e-01_r8, 2.63265e-01_r8, 2.70719e-01_r8, &
     & 2.78383e-01_r8, 2.86265e-01_r8, 2.94370e-01_r8, 3.02704e-01_r8, 3.11275e-01_r8, &
     & 3.20088e-01_r8, 3.29150e-01_r8, 3.38470e-01_r8, 3.48052e-01_r8/)
      kao_mo3(:,15) = (/ &
     & 2.60406e-02_r8, 2.78779e-02_r8, 2.98448e-02_r8, 3.19505e-02_r8, 3.42048e-02_r8, &
     & 3.66181e-02_r8, 3.92017e-02_r8, 4.19675e-02_r8, 4.49285e-02_r8, 4.80985e-02_r8, &
     & 5.14920e-02_r8, 5.51250e-02_r8, 5.90143e-02_r8, 6.31781e-02_r8, 6.76356e-02_r8, &
     & 7.24076e-02_r8, 7.75163e-02_r8, 8.29854e-02_r8, 8.88404e-02_r8/)
      kao_mo3(:,16) = (/ &
     & 2.31483e-02_r8, 2.46840e-02_r8, 2.63217e-02_r8, 2.80681e-02_r8, 2.99302e-02_r8, &
     & 3.19160e-02_r8, 3.40335e-02_r8, 3.62914e-02_r8, 3.86992e-02_r8, 4.12668e-02_r8, &
     & 4.40046e-02_r8, 4.69242e-02_r8, 5.00374e-02_r8, 5.33571e-02_r8, 5.68971e-02_r8, &
     & 6.06720e-02_r8, 6.46974e-02_r8, 6.89897e-02_r8, 7.35669e-02_r8/)
      kao_mn2o(:, 1) = (/ &
     & 3.02276e-02_r8, 3.10321e-02_r8, 3.18580e-02_r8, 3.27059e-02_r8, 3.35764e-02_r8, &
     & 3.44700e-02_r8, 3.53875e-02_r8, 3.63293e-02_r8, 3.72962e-02_r8, 3.82889e-02_r8, &
     & 3.93079e-02_r8, 4.03541e-02_r8, 4.14281e-02_r8, 4.25307e-02_r8, 4.36627e-02_r8, &
     & 4.48248e-02_r8, 4.60178e-02_r8, 4.72425e-02_r8, 4.84999e-02_r8/)
      kao_mn2o(:, 2) = (/ &
     & 6.10132e-02_r8, 6.17435e-02_r8, 6.24825e-02_r8, 6.32304e-02_r8, 6.39872e-02_r8, &
     & 6.47531e-02_r8, 6.55281e-02_r8, 6.63124e-02_r8, 6.71061e-02_r8, 6.79093e-02_r8, &
     & 6.87221e-02_r8, 6.95446e-02_r8, 7.03770e-02_r8, 7.12194e-02_r8, 7.20718e-02_r8, &
     & 7.29344e-02_r8, 7.38074e-02_r8, 7.46908e-02_r8, 7.55848e-02_r8/)
      kao_mn2o(:, 3) = (/ &
     & 1.04479e-01_r8, 1.05566e-01_r8, 1.06664e-01_r8, 1.07774e-01_r8, 1.08895e-01_r8, &
     & 1.10028e-01_r8, 1.11173e-01_r8, 1.12329e-01_r8, 1.13498e-01_r8, 1.14679e-01_r8, &
     & 1.15872e-01_r8, 1.17077e-01_r8, 1.18295e-01_r8, 1.19526e-01_r8, 1.20770e-01_r8, &
     & 1.22026e-01_r8, 1.23296e-01_r8, 1.24578e-01_r8, 1.25875e-01_r8/)
      kao_mn2o(:, 4) = (/ &
     & 2.07260e-01_r8, 2.08126e-01_r8, 2.08996e-01_r8, 2.09869e-01_r8, 2.10746e-01_r8, &
     & 2.11627e-01_r8, 2.12511e-01_r8, 2.13399e-01_r8, 2.14291e-01_r8, 2.15187e-01_r8, &
     & 2.16086e-01_r8, 2.16989e-01_r8, 2.17896e-01_r8, 2.18807e-01_r8, 2.19721e-01_r8, &
     & 2.20640e-01_r8, 2.21562e-01_r8, 2.22488e-01_r8, 2.23418e-01_r8/)
      kao_mn2o(:, 5) = (/ &
     & 3.71566e-01_r8, 3.71353e-01_r8, 3.71141e-01_r8, 3.70928e-01_r8, 3.70716e-01_r8, &
     & 3.70504e-01_r8, 3.70292e-01_r8, 3.70080e-01_r8, 3.69869e-01_r8, 3.69657e-01_r8, &
     & 3.69446e-01_r8, 3.69234e-01_r8, 3.69023e-01_r8, 3.68812e-01_r8, 3.68601e-01_r8, &
     & 3.68390e-01_r8, 3.68179e-01_r8, 3.67969e-01_r8, 3.67758e-01_r8/)
      kao_mn2o(:, 6) = (/ &
     & 5.28092e-01_r8, 5.27262e-01_r8, 5.26433e-01_r8, 5.25605e-01_r8, 5.24779e-01_r8, &
     & 5.23954e-01_r8, 5.23130e-01_r8, 5.22307e-01_r8, 5.21486e-01_r8, 5.20666e-01_r8, &
     & 5.19847e-01_r8, 5.19030e-01_r8, 5.18214e-01_r8, 5.17399e-01_r8, 5.16586e-01_r8, &
     & 5.15773e-01_r8, 5.14962e-01_r8, 5.14153e-01_r8, 5.13344e-01_r8/)
      kao_mn2o(:, 7) = (/ &
     & 3.88140e-01_r8, 3.87956e-01_r8, 3.87773e-01_r8, 3.87590e-01_r8, 3.87407e-01_r8, &
     & 3.87224e-01_r8, 3.87041e-01_r8, 3.86858e-01_r8, 3.86675e-01_r8, 3.86492e-01_r8, &
     & 3.86310e-01_r8, 3.86127e-01_r8, 3.85945e-01_r8, 3.85763e-01_r8, 3.85580e-01_r8, &
     & 3.85398e-01_r8, 3.85216e-01_r8, 3.85034e-01_r8, 3.84852e-01_r8/)
      kao_mn2o(:, 8) = (/ &
     & 3.12991e-01_r8, 3.12246e-01_r8, 3.11504e-01_r8, 3.10763e-01_r8, 3.10024e-01_r8, &
     & 3.09287e-01_r8, 3.08552e-01_r8, 3.07818e-01_r8, 3.07086e-01_r8, 3.06356e-01_r8, &
     & 3.05628e-01_r8, 3.04901e-01_r8, 3.04176e-01_r8, 3.03453e-01_r8, 3.02732e-01_r8, &
     & 3.02012e-01_r8, 3.01294e-01_r8, 3.00577e-01_r8, 2.99863e-01_r8/)
      kao_mn2o(:, 9) = (/ &
     & 4.11761e-01_r8, 4.11309e-01_r8, 4.10858e-01_r8, 4.10407e-01_r8, 4.09957e-01_r8, &
     & 4.09507e-01_r8, 4.09057e-01_r8, 4.08608e-01_r8, 4.08160e-01_r8, 4.07712e-01_r8, &
     & 4.07265e-01_r8, 4.06818e-01_r8, 4.06371e-01_r8, 4.05925e-01_r8, 4.05480e-01_r8, &
     & 4.05035e-01_r8, 4.04590e-01_r8, 4.04146e-01_r8, 4.03703e-01_r8/)
      kao_mn2o(:,10) = (/ &
     & 2.84648e-01_r8, 2.87025e-01_r8, 2.89421e-01_r8, 2.91838e-01_r8, 2.94275e-01_r8, &
     & 2.96732e-01_r8, 2.99210e-01_r8, 3.01708e-01_r8, 3.04227e-01_r8, 3.06768e-01_r8, &
     & 3.09329e-01_r8, 3.11912e-01_r8, 3.14517e-01_r8, 3.17143e-01_r8, 3.19791e-01_r8, &
     & 3.22461e-01_r8, 3.25154e-01_r8, 3.27869e-01_r8, 3.30606e-01_r8/)
      kao_mn2o(:,11) = (/ &
     & 2.75090e-01_r8, 2.79370e-01_r8, 2.83716e-01_r8, 2.88129e-01_r8, 2.92611e-01_r8, &
     & 2.97163e-01_r8, 3.01786e-01_r8, 3.06480e-01_r8, 3.11248e-01_r8, 3.16090e-01_r8, &
     & 3.21007e-01_r8, 3.26001e-01_r8, 3.31072e-01_r8, 3.36222e-01_r8, 3.41452e-01_r8, &
     & 3.46764e-01_r8, 3.52158e-01_r8, 3.57636e-01_r8, 3.63200e-01_r8/)
      kao_mn2o(:,12) = (/ &
     & 1.67753e-01_r8, 1.71386e-01_r8, 1.75098e-01_r8, 1.78890e-01_r8, 1.82765e-01_r8, &
     & 1.86723e-01_r8, 1.90767e-01_r8, 1.94899e-01_r8, 1.99120e-01_r8, 2.03433e-01_r8, &
     & 2.07839e-01_r8, 2.12340e-01_r8, 2.16939e-01_r8, 2.21638e-01_r8, 2.26438e-01_r8, &
     & 2.31342e-01_r8, 2.36353e-01_r8, 2.41472e-01_r8, 2.46701e-01_r8/)
      kao_mn2o(:,13) = (/ &
     & 1.40543e-01_r8, 1.42049e-01_r8, 1.43571e-01_r8, 1.45109e-01_r8, 1.46663e-01_r8, &
     & 1.48234e-01_r8, 1.49822e-01_r8, 1.51427e-01_r8, 1.53049e-01_r8, 1.54689e-01_r8, &
     & 1.56346e-01_r8, 1.58021e-01_r8, 1.59713e-01_r8, 1.61424e-01_r8, 1.63153e-01_r8, &
     & 1.64901e-01_r8, 1.66668e-01_r8, 1.68453e-01_r8, 1.70258e-01_r8/)
      kao_mn2o(:,14) = (/ &
     & 1.51530e-01_r8, 1.50944e-01_r8, 1.50360e-01_r8, 1.49779e-01_r8, 1.49199e-01_r8, &
     & 1.48622e-01_r8, 1.48047e-01_r8, 1.47474e-01_r8, 1.46903e-01_r8, 1.46335e-01_r8, &
     & 1.45769e-01_r8, 1.45205e-01_r8, 1.44643e-01_r8, 1.44083e-01_r8, 1.43526e-01_r8, &
     & 1.42971e-01_r8, 1.42418e-01_r8, 1.41867e-01_r8, 1.41318e-01_r8/)
      kao_mn2o(:,15) = (/ &
     & 2.20492e-01_r8, 2.16479e-01_r8, 2.12539e-01_r8, 2.08671e-01_r8, 2.04873e-01_r8, &
     & 2.01145e-01_r8, 1.97484e-01_r8, 1.93890e-01_r8, 1.90361e-01_r8, 1.86897e-01_r8, &
     & 1.83495e-01_r8, 1.80156e-01_r8, 1.76877e-01_r8, 1.73658e-01_r8, 1.70497e-01_r8, &
     & 1.67394e-01_r8, 1.64348e-01_r8, 1.61356e-01_r8, 1.58420e-01_r8/)
      kao_mn2o(:,16) = (/ &
     & 2.19848e-01_r8, 2.15847e-01_r8, 2.11919e-01_r8, 2.08062e-01_r8, 2.04275e-01_r8, &
     & 2.00558e-01_r8, 1.96908e-01_r8, 1.93324e-01_r8, 1.89806e-01_r8, 1.86351e-01_r8, &
     & 1.82960e-01_r8, 1.79630e-01_r8, 1.76361e-01_r8, 1.73151e-01_r8, 1.70000e-01_r8, &
     & 1.66906e-01_r8, 1.63868e-01_r8, 1.60886e-01_r8, 1.57958e-01_r8/)

!     The array KBO_Mxx contains the absorption coefficient for 
!     a minor species at the 16 chosen g-values for a reference pressure
!     level above 100~ mb.   The first index refers to temperature 
!     in 7.2 degree increments.  For instance, JT = 1 refers to a 
!     temperature of 188.0, JT = 2 refers to 195.2, etc. The second index 
!     runs over the g-channel (1 to 16).

      kbo_mco2(:, 1) = (/ &
     & 4.74280e-08_r8, 6.62724e-08_r8, 9.26042e-08_r8, 1.29398e-07_r8, 1.80812e-07_r8, &
     & 2.52653e-07_r8, 3.53039e-07_r8, 4.93310e-07_r8, 6.89316e-07_r8, 9.63198e-07_r8, &
     & 1.34590e-06_r8, 1.88067e-06_r8, 2.62790e-06_r8, 3.67204e-06_r8, 5.13104e-06_r8, &
     & 7.16974e-06_r8, 1.00185e-05_r8, 1.39991e-05_r8, 1.95613e-05_r8/)
      kbo_mco2(:, 2) = (/ &
     & 1.14872e-07_r8, 1.63356e-07_r8, 2.32304e-07_r8, 3.30352e-07_r8, 4.69783e-07_r8, &
     & 6.68064e-07_r8, 9.50033e-07_r8, 1.35101e-06_r8, 1.92123e-06_r8, 2.73213e-06_r8, &
     & 3.88527e-06_r8, 5.52513e-06_r8, 7.85711e-06_r8, 1.11734e-05_r8, 1.58893e-05_r8, &
     & 2.25957e-05_r8, 3.21326e-05_r8, 4.56948e-05_r8, 6.49811e-05_r8/)
      kbo_mco2(:, 3) = (/ &
     & 3.30676e-07_r8, 4.76313e-07_r8, 6.86094e-07_r8, 9.88267e-07_r8, 1.42353e-06_r8, &
     & 2.05048e-06_r8, 2.95356e-06_r8, 4.25439e-06_r8, 6.12813e-06_r8, 8.82711e-06_r8, &
     & 1.27148e-05_r8, 1.83147e-05_r8, 2.63810e-05_r8, 3.79998e-05_r8, 5.47359e-05_r8, &
     & 7.88430e-05_r8, 1.13568e-04_r8, 1.63585e-04_r8, 2.35632e-04_r8/)
      kbo_mco2(:, 4) = (/ &
     & 6.58642e-07_r8, 9.52761e-07_r8, 1.37822e-06_r8, 1.99368e-06_r8, 2.88396e-06_r8, &
     & 4.17181e-06_r8, 6.03475e-06_r8, 8.72960e-06_r8, 1.26279e-05_r8, 1.82669e-05_r8, &
     & 2.64241e-05_r8, 3.82239e-05_r8, 5.52929e-05_r8, 7.99844e-05_r8, 1.15702e-04_r8, &
     & 1.67369e-04_r8, 2.42109e-04_r8, 3.50223e-04_r8, 5.06617e-04_r8/)
      kbo_mco2(:, 5) = (/ &
     & 1.26418e-06_r8, 1.82095e-06_r8, 2.62292e-06_r8, 3.77810e-06_r8, 5.44204e-06_r8, &
     & 7.83881e-06_r8, 1.12911e-05_r8, 1.62640e-05_r8, 2.34269e-05_r8, 3.37445e-05_r8, &
     & 4.86061e-05_r8, 7.00131e-05_r8, 1.00848e-04_r8, 1.45263e-04_r8, 2.09239e-04_r8, &
     & 3.01392e-04_r8, 4.34131e-04_r8, 6.25329e-04_r8, 9.00733e-04_r8/)
      kbo_mco2(:, 6) = (/ &
     & 2.38529e-06_r8, 3.43110e-06_r8, 4.93545e-06_r8, 7.09937e-06_r8, 1.02120e-05_r8, &
     & 1.46895e-05_r8, 2.11300e-05_r8, 3.03943e-05_r8, 4.37205e-05_r8, 6.28894e-05_r8, &
     & 9.04630e-05_r8, 1.30126e-04_r8, 1.87179e-04_r8, 2.69247e-04_r8, 3.87296e-04_r8, &
     & 5.57104e-04_r8, 8.01364e-04_r8, 1.15272e-03_r8, 1.65812e-03_r8/)
      kbo_mco2(:, 7) = (/ &
     & 5.41398e-06_r8, 7.54295e-06_r8, 1.05091e-05_r8, 1.46417e-05_r8, 2.03993e-05_r8, &
     & 2.84211e-05_r8, 3.95973e-05_r8, 5.51683e-05_r8, 7.68626e-05_r8, 1.07088e-04_r8, &
     & 1.49199e-04_r8, 2.07869e-04_r8, 2.89610e-04_r8, 4.03496e-04_r8, 5.62165e-04_r8, &
     & 7.83229e-04_r8, 1.09122e-03_r8, 1.52033e-03_r8, 2.11818e-03_r8/)
      kbo_mco2(:, 8) = (/ &
     & 1.09995e-05_r8, 1.54018e-05_r8, 2.15660e-05_r8, 3.01973e-05_r8, 4.22831e-05_r8, &
     & 5.92059e-05_r8, 8.29017e-05_r8, 1.16081e-04_r8, 1.62540e-04_r8, 2.27592e-04_r8, &
     & 3.18681e-04_r8, 4.46226e-04_r8, 6.24817e-04_r8, 8.74886e-04_r8, 1.22504e-03_r8, &
     & 1.71533e-03_r8, 2.40185e-03_r8, 3.36313e-03_r8, 4.70915e-03_r8/)
      kbo_mco2(:, 9) = (/ &
     & 3.29051e-05_r8, 4.59996e-05_r8, 6.43050e-05_r8, 8.98950e-05_r8, 1.25668e-04_r8, &
     & 1.75678e-04_r8, 2.45588e-04_r8, 3.43319e-04_r8, 4.79942e-04_r8, 6.70933e-04_r8, &
     & 9.37930e-04_r8, 1.31118e-03_r8, 1.83295e-03_r8, 2.56237e-03_r8, 3.58206e-03_r8, &
     & 5.00753e-03_r8, 7.00027e-03_r8, 9.78599e-03_r8, 1.36803e-02_r8/)
      kbo_mco2(:,10) = (/ &
     & 1.95126e-05_r8, 2.65944e-05_r8, 3.62463e-05_r8, 4.94013e-05_r8, 6.73305e-05_r8, &
     & 9.17669e-05_r8, 1.25072e-04_r8, 1.70465e-04_r8, 2.32332e-04_r8, 3.16652e-04_r8, &
     & 4.31575e-04_r8, 5.88208e-04_r8, 8.01687e-04_r8, 1.09264e-03_r8, 1.48920e-03_r8, &
     & 2.02968e-03_r8, 2.76631e-03_r8, 3.77029e-03_r8, 5.13865e-03_r8/)
      kbo_mco2(:,11) = (/ &
     & 8.67271e-05_r8, 1.19228e-04_r8, 1.63908e-04_r8, 2.25332e-04_r8, 3.09774e-04_r8, &
     & 4.25860e-04_r8, 5.85450e-04_r8, 8.04845e-04_r8, 1.10646e-03_r8, 1.52110e-03_r8, &
     & 2.09112e-03_r8, 2.87476e-03_r8, 3.95207e-03_r8, 5.43309e-03_r8, 7.46911e-03_r8, &
     & 1.02681e-02_r8, 1.41161e-02_r8, 1.94060e-02_r8, 2.66783e-02_r8/)
      kbo_mco2(:,12) = (/ &
     & 3.79194e-07_r8, 5.51419e-07_r8, 8.01866e-07_r8, 1.16606e-06_r8, 1.69567e-06_r8, &
     & 2.46582e-06_r8, 3.58577e-06_r8, 5.21438e-06_r8, 7.58268e-06_r8, 1.10266e-05_r8, &
     & 1.60348e-05_r8, 2.33176e-05_r8, 3.39081e-05_r8, 4.93087e-05_r8, 7.17040e-05_r8, &
     & 1.04271e-04_r8, 1.51630e-04_r8, 2.20498e-04_r8, 3.20644e-04_r8/)
      kbo_mco2(:,13) = (/ &
     & 1.72555e-07_r8, 2.29952e-07_r8, 3.06441e-07_r8, 4.08373e-07_r8, 5.44209e-07_r8, &
     & 7.25229e-07_r8, 9.66461e-07_r8, 1.28793e-06_r8, 1.71634e-06_r8, 2.28724e-06_r8, &
     & 3.04805e-06_r8, 4.06192e-06_r8, 5.41303e-06_r8, 7.21356e-06_r8, 9.61299e-06_r8, &
     & 1.28106e-05_r8, 1.70717e-05_r8, 2.27503e-05_r8, 3.03177e-05_r8/)
      kbo_mco2(:,14) = (/ &
     & 7.42245e-09_r8, 7.17780e-09_r8, 6.94122e-09_r8, 6.71243e-09_r8, 6.49118e-09_r8, &
     & 6.27723e-09_r8, 6.07032e-09_r8, 5.87024e-09_r8, 5.67675e-09_r8, 5.48964e-09_r8, &
     & 5.30870e-09_r8, 5.13372e-09_r8, 4.96451e-09_r8, 4.80087e-09_r8, 4.64263e-09_r8, &
     & 4.48961e-09_r8, 4.34163e-09_r8, 4.19852e-09_r8, 4.06014e-09_r8/)
      kbo_mco2(:,15) = (/ &
     & 7.41847e-09_r8, 7.17332e-09_r8, 6.93627e-09_r8, 6.70705e-09_r8, 6.48541e-09_r8, &
     & 6.27109e-09_r8, 6.06386e-09_r8, 5.86347e-09_r8, 5.66970e-09_r8, 5.48234e-09_r8, &
     & 5.30117e-09_r8, 5.12599e-09_r8, 4.95659e-09_r8, 4.79280e-09_r8, 4.63441e-09_r8, &
     & 4.48126e-09_r8, 4.33317e-09_r8, 4.18998e-09_r8, 4.05152e-09_r8/)
      kbo_mco2(:,16) = (/ &
     & 7.42855e-09_r8, 7.18278e-09_r8, 6.94513e-09_r8, 6.71535e-09_r8, 6.49317e-09_r8, &
     & 6.27834e-09_r8, 6.07062e-09_r8, 5.86977e-09_r8, 5.67557e-09_r8, 5.48779e-09_r8, &
     & 5.30622e-09_r8, 5.13066e-09_r8, 4.96091e-09_r8, 4.79678e-09_r8, 4.63808e-09_r8, &
     & 4.48462e-09_r8, 4.33625e-09_r8, 4.19278e-09_r8, 4.05406e-09_r8/)
      kbo_mn2o(:, 1) = (/ &
     & 2.49055e-04_r8, 2.53574e-04_r8, 2.58175e-04_r8, 2.62860e-04_r8, 2.67629e-04_r8, &
     & 2.72485e-04_r8, 2.77429e-04_r8, 2.82463e-04_r8, 2.87588e-04_r8, 2.92806e-04_r8, &
     & 2.98119e-04_r8, 3.03528e-04_r8, 3.09036e-04_r8, 3.14643e-04_r8, 3.20352e-04_r8, &
     & 3.26165e-04_r8, 3.32083e-04_r8, 3.38109e-04_r8, 3.44243e-04_r8/)
      kbo_mn2o(:, 2) = (/ &
     & 3.79251e-04_r8, 4.04353e-04_r8, 4.31117e-04_r8, 4.59652e-04_r8, 4.90075e-04_r8, &
     & 5.22513e-04_r8, 5.57097e-04_r8, 5.93970e-04_r8, 6.33284e-04_r8, 6.75200e-04_r8, &
     & 7.19890e-04_r8, 7.67539e-04_r8, 8.18340e-04_r8, 8.72505e-04_r8, 9.30255e-04_r8, &
     & 9.91827e-04_r8, 1.05747e-03_r8, 1.12747e-03_r8, 1.20209e-03_r8/)
      kbo_mn2o(:, 3) = (/ &
     & 7.61140e-04_r8, 8.36483e-04_r8, 9.19284e-04_r8, 1.01028e-03_r8, 1.11029e-03_r8, &
     & 1.22019e-03_r8, 1.34098e-03_r8, 1.47372e-03_r8, 1.61959e-03_r8, 1.77991e-03_r8, &
     & 1.95610e-03_r8, 2.14973e-03_r8, 2.36253e-03_r8, 2.59639e-03_r8, 2.85340e-03_r8, &
     & 3.13585e-03_r8, 3.44626e-03_r8, 3.78740e-03_r8, 4.16230e-03_r8/)
      kbo_mn2o(:, 4) = (/ &
     & 2.01074e-03_r8, 2.26915e-03_r8, 2.56077e-03_r8, 2.88987e-03_r8, 3.26126e-03_r8, &
     & 3.68038e-03_r8, 4.15337e-03_r8, 4.68714e-03_r8, 5.28951e-03_r8, 5.96929e-03_r8, &
     & 6.73643e-03_r8, 7.60217e-03_r8, 8.57916e-03_r8, 9.68172e-03_r8, 1.09260e-02_r8, &
     & 1.23301e-02_r8, 1.39147e-02_r8, 1.57030e-02_r8, 1.77211e-02_r8/)
      kbo_mn2o(:, 5) = (/ &
     & 7.43302e-03_r8, 8.32582e-03_r8, 9.32585e-03_r8, 1.04460e-02_r8, 1.17007e-02_r8, &
     & 1.31061e-02_r8, 1.46803e-02_r8, 1.64436e-02_r8, 1.84186e-02_r8, 2.06309e-02_r8, &
     & 2.31090e-02_r8, 2.58846e-02_r8, 2.89937e-02_r8, 3.24762e-02_r8, 3.63769e-02_r8, &
     & 4.07463e-02_r8, 4.56404e-02_r8, 5.11223e-02_r8, 5.72627e-02_r8/)
      kbo_mn2o(:, 6) = (/ &
     & 2.71911e-02_r8, 2.94258e-02_r8, 3.18441e-02_r8, 3.44612e-02_r8, 3.72933e-02_r8, &
     & 4.03582e-02_r8, 4.36750e-02_r8, 4.72644e-02_r8, 5.11487e-02_r8, 5.53523e-02_r8, &
     & 5.99014e-02_r8, 6.48243e-02_r8, 7.01518e-02_r8, 7.59172e-02_r8, 8.21563e-02_r8, &
     & 8.89082e-02_r8, 9.62150e-02_r8, 1.04122e-01_r8, 1.12679e-01_r8/)
      kbo_mn2o(:, 7) = (/ &
     & 1.63331e-01_r8, 1.80469e-01_r8, 1.99406e-01_r8, 2.20330e-01_r8, 2.43449e-01_r8, &
     & 2.68995e-01_r8, 2.97221e-01_r8, 3.28408e-01_r8, 3.62869e-01_r8, 4.00945e-01_r8, &
     & 4.43017e-01_r8, 4.89503e-01_r8, 5.40867e-01_r8, 5.97621e-01_r8, 6.60330e-01_r8, &
     & 7.29619e-01_r8, 8.06179e-01_r8, 8.90772e-01_r8, 9.84242e-01_r8/)
      kbo_mn2o(:, 8) = (/ &
     & 1.32648e+00_r8, 1.33515e+00_r8, 1.34387e+00_r8, 1.35265e+00_r8, 1.36149e+00_r8, &
     & 1.37038e+00_r8, 1.37933e+00_r8, 1.38835e+00_r8, 1.39742e+00_r8, 1.40655e+00_r8, &
     & 1.41574e+00_r8, 1.42499e+00_r8, 1.43429e+00_r8, 1.44367e+00_r8, 1.45310e+00_r8, &
     & 1.46259e+00_r8, 1.47215e+00_r8, 1.48176e+00_r8, 1.49144e+00_r8/)
      kbo_mn2o(:, 9) = (/ &
     & 3.12620e+00_r8, 3.03118e+00_r8, 2.93905e+00_r8, 2.84972e+00_r8, 2.76310e+00_r8, &
     & 2.67911e+00_r8, 2.59768e+00_r8, 2.51873e+00_r8, 2.44217e+00_r8, 2.36794e+00_r8, &
     & 2.29596e+00_r8, 2.22618e+00_r8, 2.15851e+00_r8, 2.09290e+00_r8, 2.02929e+00_r8, &
     & 1.96761e+00_r8, 1.90780e+00_r8, 1.84982e+00_r8, 1.79359e+00_r8/)
      kbo_mn2o(:,10) = (/ &
     & 1.60677e-02_r8, 1.82485e-02_r8, 2.07254e-02_r8, 2.35384e-02_r8, 2.67332e-02_r8, &
     & 3.03617e-02_r8, 3.44827e-02_r8, 3.91629e-02_r8, 4.44785e-02_r8, 5.05154e-02_r8, &
     & 5.73718e-02_r8, 6.51589e-02_r8, 7.40027e-02_r8, 8.40470e-02_r8, 9.54546e-02_r8, &
     & 1.08411e-01_r8, 1.23125e-01_r8, 1.39836e-01_r8, 1.58816e-01_r8/)
      kbo_mn2o(:,11) = (/ &
     & 1.55287e-02_r8, 1.78265e-02_r8, 2.04642e-02_r8, 2.34922e-02_r8, 2.69683e-02_r8, &
     & 3.09588e-02_r8, 3.55397e-02_r8, 4.07984e-02_r8, 4.68352e-02_r8, 5.37653e-02_r8, &
     & 6.17208e-02_r8, 7.08535e-02_r8, 8.13375e-02_r8, 9.33728e-02_r8, 1.07189e-01_r8, &
     & 1.23049e-01_r8, 1.41257e-01_r8, 1.62158e-01_r8, 1.86152e-01_r8/)
      kbo_mn2o(:,12) = (/ &
     & 7.13719e-03_r8, 8.18879e-03_r8, 9.39535e-03_r8, 1.07797e-02_r8, 1.23680e-02_r8, &
     & 1.41903e-02_r8, 1.62811e-02_r8, 1.86800e-02_r8, 2.14324e-02_r8, 2.45902e-02_r8, &
     & 2.82134e-02_r8, 3.23704e-02_r8, 3.71400e-02_r8, 4.26122e-02_r8, 4.88908e-02_r8, &
     & 5.60945e-02_r8, 6.43596e-02_r8, 7.38424e-02_r8, 8.47224e-02_r8/)
      kbo_mn2o(:,13) = (/ &
     & 9.28813e-03_r8, 1.06108e-02_r8, 1.21218e-02_r8, 1.38480e-02_r8, 1.58199e-02_r8, &
     & 1.80727e-02_r8, 2.06463e-02_r8, 2.35864e-02_r8, 2.69452e-02_r8, 3.07822e-02_r8, &
     & 3.51657e-02_r8, 4.01734e-02_r8, 4.58941e-02_r8, 5.24296e-02_r8, 5.98956e-02_r8, &
     & 6.84249e-02_r8, 7.81688e-02_r8, 8.93002e-02_r8, 1.02017e-01_r8/)
      kbo_mn2o(:,14) = (/ &
     & 2.17205e-02_r8, 2.51661e-02_r8, 2.91581e-02_r8, 3.37835e-02_r8, 3.91425e-02_r8, &
     & 4.53517e-02_r8, 5.25458e-02_r8, 6.08811e-02_r8, 7.05387e-02_r8, 8.17282e-02_r8, &
     & 9.46927e-02_r8, 1.09714e-01_r8, 1.27118e-01_r8, 1.47282e-01_r8, 1.70645e-01_r8, &
     & 1.97715e-01_r8, 2.29078e-01_r8, 2.65417e-01_r8, 3.07520e-01_r8/)
      kbo_mn2o(:,15) = (/ &
     & 4.89156e-02_r8, 5.70504e-02_r8, 6.65379e-02_r8, 7.76033e-02_r8, 9.05089e-02_r8, &
     & 1.05561e-01_r8, 1.23116e-01_r8, 1.43590e-01_r8, 1.67469e-01_r8, 1.95320e-01_r8, &
     & 2.27802e-01_r8, 2.65686e-01_r8, 3.09869e-01_r8, 3.61401e-01_r8, 4.21503e-01_r8, &
     & 4.91600e-01_r8, 5.73354e-01_r8, 6.68703e-01_r8, 7.79910e-01_r8/)
      kbo_mn2o(:,16) = (/ &
     & 1.13156e-02_r8, 1.46199e-02_r8, 1.88891e-02_r8, 2.44050e-02_r8, 3.15316e-02_r8, &
     & 4.07393e-02_r8, 5.26358e-02_r8, 6.80061e-02_r8, 8.78649e-02_r8, 1.13523e-01_r8, &
     & 1.46673e-01_r8, 1.89504e-01_r8, 2.44841e-01_r8, 3.16338e-01_r8, 4.08713e-01_r8, &
     & 5.28064e-01_r8, 6.82266e-01_r8, 8.81496e-01_r8, 1.13891e+00_r8/)

!     The array FORREFO contains the coefficient of the water vapor
!     foreign-continuum (including the energy term).  The first 
!     index refers to reference temperature (296,260,224,260) and 
!     pressure (970,475,219,3 mbar) levels.  The second index 
!     runs over the g-channel (1 to 16).

      forrefo(1,:) = (/ &
     &4.8166e-07_r8,3.7500e-07_r8,4.8978e-07_r8,5.9624e-07_r8,6.3742e-07_r8,7.5551e-07_r8, &
     &7.7706e-07_r8,6.8681e-07_r8,7.5212e-07_r8,8.0956e-07_r8,7.8117e-07_r8,7.4835e-07_r8, &
     &9.4118e-07_r8,1.2585e-06_r8,1.4976e-06_r8,1.4976e-06_r8/)
      forrefo(2,:) = (/ &
     &3.1320e-07_r8,4.0764e-07_r8,4.7468e-07_r8,5.9976e-07_r8,7.3324e-07_r8,8.1488e-07_r8, &
     &7.6442e-07_r8,8.2007e-07_r8,7.7721e-07_r8,7.6377e-07_r8,8.0327e-07_r8,7.1881e-07_r8, &
     &8.2148e-07_r8,1.0203e-06_r8,1.5033e-06_r8,1.5032e-06_r8/)
      forrefo(3,:) = (/ &
     &4.1831e-07_r8,5.5043e-07_r8,5.7783e-07_r8,6.1294e-07_r8,6.3396e-07_r8,6.2292e-07_r8, &
     &6.1719e-07_r8,6.4183e-07_r8,7.6180e-07_r8,9.5477e-07_r8,9.5901e-07_r8,1.0207e-06_r8, &
     &1.0387e-06_r8,1.1305e-06_r8,1.3602e-06_r8,1.5063e-06_r8/)
      forrefo(4,:) = (/ &
     &8.5878e-07_r8,6.0921e-07_r8,5.5773e-07_r8,5.3374e-07_r8,5.0495e-07_r8,4.9844e-07_r8, &
     &5.1536e-07_r8,5.2908e-07_r8,4.7977e-07_r8,5.3177e-07_r8,4.9266e-07_r8,4.5403e-07_r8, &
     &3.9695e-07_r8,3.4792e-07_r8,3.4912e-07_r8,3.4102e-07_r8/)

!     The array SELFREFO contains the coefficient of the water vapor
!     self-continuum (including the energy term).  The first index
!     refers to temperature in 7.2 degree increments.  For instance,
!     JT = 1 refers to a temperature of 245.6, JT = 2 refers to 252.8,
!     etc.  The second index runs over the g-channel (1 to 16).

      selfrefo(:, 1) = (/ &
     & 3.16029e-02_r8, 2.74633e-02_r8, 2.38660e-02_r8, 2.07399e-02_r8, 1.80232e-02_r8, &
     & 1.56624e-02_r8, 1.36108e-02_r8, 1.18280e-02_r8, 1.02787e-02_r8, 8.93231e-03_r8/)
      selfrefo(:, 2) = (/ &
     & 3.10422e-02_r8, 2.71312e-02_r8, 2.37130e-02_r8, 2.07254e-02_r8, 1.81142e-02_r8, &
     & 1.58320e-02_r8, 1.38374e-02_r8, 1.20940e-02_r8, 1.05703e-02_r8, 9.23854e-03_r8/)
      selfrefo(:, 3) = (/ &
     & 3.08657e-02_r8, 2.69431e-02_r8, 2.35190e-02_r8, 2.05301e-02_r8, 1.79210e-02_r8, &
     & 1.56435e-02_r8, 1.36554e-02_r8, 1.19200e-02_r8, 1.04051e-02_r8, 9.08279e-03_r8/)
      selfrefo(:, 4) = (/ &
     & 3.02668e-02_r8, 2.64686e-02_r8, 2.31470e-02_r8, 2.02422e-02_r8, 1.77020e-02_r8, &
     & 1.54806e-02_r8, 1.35379e-02_r8, 1.18390e-02_r8, 1.03533e-02_r8, 9.05406e-03_r8/)
      selfrefo(:, 5) = (/ &
     & 2.98317e-02_r8, 2.61491e-02_r8, 2.29210e-02_r8, 2.00914e-02_r8, 1.76112e-02_r8, &
     & 1.54371e-02_r8, 1.35314e-02_r8, 1.18610e-02_r8, 1.03968e-02_r8, 9.11332e-03_r8/)
      selfrefo(:, 6) = (/ &
     & 2.95545e-02_r8, 2.59083e-02_r8, 2.27120e-02_r8, 1.99100e-02_r8, 1.74537e-02_r8, &
     & 1.53004e-02_r8, 1.34128e-02_r8, 1.17580e-02_r8, 1.03074e-02_r8, 9.03576e-03_r8/)
      selfrefo(:, 7) = (/ &
     & 2.97352e-02_r8, 2.60320e-02_r8, 2.27900e-02_r8, 1.99517e-02_r8, 1.74670e-02_r8, &
     & 1.52916e-02_r8, 1.33872e-02_r8, 1.17200e-02_r8, 1.02604e-02_r8, 8.98258e-03_r8/)
      selfrefo(:, 8) = (/ &
     & 2.96543e-02_r8, 2.59760e-02_r8, 2.27540e-02_r8, 1.99316e-02_r8, 1.74593e-02_r8, &
     & 1.52937e-02_r8, 1.33967e-02_r8, 1.17350e-02_r8, 1.02794e-02_r8, 9.00437e-03_r8/)
      selfrefo(:, 9) = (/ &
     & 2.97998e-02_r8, 2.60786e-02_r8, 2.28220e-02_r8, 1.99721e-02_r8, 1.74781e-02_r8, &
     & 1.52955e-02_r8, 1.33855e-02_r8, 1.17140e-02_r8, 1.02512e-02_r8, 8.97110e-03_r8/)
      selfrefo(:,10) = (/ &
     & 2.98826e-02_r8, 2.61096e-02_r8, 2.28130e-02_r8, 1.99326e-02_r8, 1.74159e-02_r8, &
     & 1.52170e-02_r8, 1.32957e-02_r8, 1.16170e-02_r8, 1.01502e-02_r8, 8.86867e-03_r8/)
      selfrefo(:,11) = (/ &
     & 2.94710e-02_r8, 2.58147e-02_r8, 2.26120e-02_r8, 1.98066e-02_r8, 1.73493e-02_r8, &
     & 1.51969e-02_r8, 1.33115e-02_r8, 1.16600e-02_r8, 1.02134e-02_r8, 8.94628e-03_r8/)
      selfrefo(:,12) = (/ &
     & 2.96297e-02_r8, 2.59544e-02_r8, 2.27350e-02_r8, 1.99149e-02_r8, 1.74446e-02_r8, &
     & 1.52808e-02_r8, 1.33853e-02_r8, 1.17250e-02_r8, 1.02706e-02_r8, 8.99663e-03_r8/)
      selfrefo(:,13) = (/ &
     & 2.96272e-02_r8, 2.59013e-02_r8, 2.26440e-02_r8, 1.97963e-02_r8, 1.73067e-02_r8, &
     & 1.51302e-02_r8, 1.32275e-02_r8, 1.15640e-02_r8, 1.01097e-02_r8, 8.83833e-03_r8/)
      selfrefo(:,14) = (/ &
     & 2.89906e-02_r8, 2.53971e-02_r8, 2.22490e-02_r8, 1.94911e-02_r8, 1.70751e-02_r8, &
     & 1.49585e-02_r8, 1.31044e-02_r8, 1.14800e-02_r8, 1.00570e-02_r8, 8.81038e-03_r8/)
      selfrefo(:,15) = (/ &
     & 2.80884e-02_r8, 2.46987e-02_r8, 2.17180e-02_r8, 1.90970e-02_r8, 1.67924e-02_r8, &
     & 1.47659e-02_r8, 1.29839e-02_r8, 1.14170e-02_r8, 1.00392e-02_r8, 8.82765e-03_r8/)
      selfrefo(:,16) = (/ &
     & 2.80884e-02_r8, 2.46987e-02_r8, 2.17180e-02_r8, 1.90970e-02_r8, 1.67924e-02_r8, &
     & 1.47659e-02_r8, 1.29839e-02_r8, 1.14170e-02_r8, 1.00392e-02_r8, 8.82765e-03_r8/)

      end subroutine lw_kgb08

! **************************************************************************
 
