!     path:      $Source: /storm/rc1/cvsroot/rc/rrtmg_lw/src/rrtmg_lw_k_g.f90,v $
!     author:    $Author: mike $
!     revision:  $Revision: 1.2 $
!     created:   $Date: 2007/08/22 19:20:03 $
!
!  --------------------------------------------------------------------------
! |                                                                          |
! |  Copyright 2002-2007, Atmospheric & Environmental Research, Inc. (AER).  |
! |  This software may be used, copied, or redistributed as long as it is    |
! |  not sold and this copyright notice is reproduced on each copy made.     |
! |  This model is provided as is without any express or implied warranties. |
! |                       (http://www.rtweb.aer.com/)                        |
! |                                                                          |
!  --------------------------------------------------------------------------

! **************************************************************************
!      subroutine lw_kgbnn
! **************************************************************************
!  RRTM Longwave Radiative Transfer Model
!  Atmospheric and Environmental Research, Inc., Cambridge, MA
!
!  Original version:   E. J. Mlawer, et al.
!  Revision for GCMs:  Michael J. Iacono; October, 2002
!
!  This file contains 16 subroutines that include the 
!  absorption coefficients and other data for each of the 16 longwave
!  spectral bands used in RRTM.  Here, the data are defined for 16
!  g-points, or sub-intervals, per band.  These data are combined and
!  weighted using a mapping procedure in routine RRTMG_LW_INIT to reduce
!  the total number of g-points from 256 to 140 for use in the GCM.
! **************************************************************************
      subroutine lw_kgb09
! **************************************************************************

      use shr_kind_mod, only: r8 => shr_kind_r8

!      use parkind, only : jpim, jprb 
      use rrlw_kg09, only : fracrefao, fracrefbo, kao, kbo, kao_mn2o, &
                            kbo_mn2o, selfrefo, forrefo

      implicit none
      save

! Planck fractions mapping level : P=212.7250 mb, T = 223.06 K
      fracrefao(:, 1) = (/ &
     &  1.8129e-01_r8,1.6119e-01_r8,1.3308e-01_r8,1.2342e-01_r8,1.1259e-01_r8,9.7580e-02_r8, &
     &  7.9176e-02_r8,5.8541e-02_r8,3.9084e-02_r8,4.2419e-03_r8,3.4314e-03_r8,2.6935e-03_r8, &
     &  1.9404e-03_r8,1.2218e-03_r8,4.5263e-04_r8,6.0909e-05_r8/)
      fracrefao(:, 2) = (/ &
     &  1.9665e-01_r8,1.5640e-01_r8,1.3101e-01_r8,1.2153e-01_r8,1.1037e-01_r8,9.6043e-02_r8, &
     &  7.7856e-02_r8,5.7547e-02_r8,3.8670e-02_r8,4.1955e-03_r8,3.4104e-03_r8,2.6781e-03_r8, &
     &  1.9245e-03_r8,1.2093e-03_r8,4.4113e-04_r8,6.0913e-05_r8/)
      fracrefao(:, 3) = (/ &
     &  2.0273e-01_r8,1.5506e-01_r8,1.3044e-01_r8,1.2043e-01_r8,1.0952e-01_r8,9.5384e-02_r8, &
     &  7.7157e-02_r8,5.7176e-02_r8,3.8379e-02_r8,4.1584e-03_r8,3.3836e-03_r8,2.6412e-03_r8, &
     &  1.8865e-03_r8,1.1791e-03_r8,4.2094e-04_r8,4.7410e-05_r8/)
      fracrefao(:, 4) = (/ &
     &  2.0272e-01_r8,1.5963e-01_r8,1.2913e-01_r8,1.2060e-01_r8,1.0820e-01_r8,9.4685e-02_r8, &
     &  7.6544e-02_r8,5.6851e-02_r8,3.8155e-02_r8,4.0913e-03_r8,3.3442e-03_r8,2.6054e-03_r8, &
     &  1.8875e-03_r8,1.1263e-03_r8,3.7743e-04_r8,4.7410e-05_r8/)
      fracrefao(:, 5) = (/ &
     &  2.0280e-01_r8,1.6353e-01_r8,1.2910e-01_r8,1.1968e-01_r8,1.0725e-01_r8,9.4112e-02_r8, &
     &  7.5828e-02_r8,5.6526e-02_r8,3.7972e-02_r8,4.0205e-03_r8,3.3063e-03_r8,2.5681e-03_r8, &
     &  1.8386e-03_r8,1.0757e-03_r8,3.5301e-04_r8,4.7410e-05_r8/)
      fracrefao(:, 6) = (/ &
     &  2.0294e-01_r8,1.6840e-01_r8,1.2852e-01_r8,1.1813e-01_r8,1.0724e-01_r8,9.2946e-02_r8, &
     &  7.5029e-02_r8,5.6158e-02_r8,3.7744e-02_r8,3.9632e-03_r8,3.2434e-03_r8,2.5275e-03_r8, &
     &  1.7558e-03_r8,1.0080e-03_r8,3.5301e-04_r8,4.7410e-05_r8/)
      fracrefao(:, 7) = (/ &
     &  2.0313e-01_r8,1.7390e-01_r8,1.2864e-01_r8,1.1689e-01_r8,1.0601e-01_r8,9.1791e-02_r8, &
     &  7.4224e-02_r8,5.5500e-02_r8,3.7374e-02_r8,3.9214e-03_r8,3.1984e-03_r8,2.4162e-03_r8, &
     &  1.6394e-03_r8,9.7275e-04_r8,3.5299e-04_r8,4.7410e-05_r8/)
      fracrefao(:, 8) = (/ &
     &  2.0332e-01_r8,1.7800e-01_r8,1.3286e-01_r8,1.1555e-01_r8,1.0407e-01_r8,9.0475e-02_r8, &
     &  7.2452e-02_r8,5.4566e-02_r8,3.6677e-02_r8,3.7889e-03_r8,3.0351e-03_r8,2.2587e-03_r8, &
     &  1.5764e-03_r8,9.7270e-04_r8,3.5300e-04_r8,4.7410e-05_r8/)
      fracrefao(:, 9) = (/ &
     &  1.9624e-01_r8,1.6519e-01_r8,1.3663e-01_r8,1.1535e-01_r8,1.0719e-01_r8,9.4156e-02_r8, &
     &  7.6745e-02_r8,5.6987e-02_r8,3.8135e-02_r8,4.1626e-03_r8,3.4243e-03_r8,2.7116e-03_r8, &
     &  1.7095e-03_r8,9.7271e-04_r8,3.5299e-04_r8,4.7410e-05_r8/)

! Planck fraction mapping level : p=3.20e-2 mb, t = 197.92 k
      fracrefbo(:) = (/ &
     &  2.0914e-01_r8,1.5077e-01_r8,1.2878e-01_r8,1.1856e-01_r8,1.0695e-01_r8,9.3048e-02_r8, &
     &  7.7645e-02_r8,6.0785e-02_r8,4.0642e-02_r8,4.0499e-03_r8,3.3931e-03_r8,2.6363e-03_r8, &
     &  1.9151e-03_r8,1.1963e-03_r8,4.3471e-04_r8,5.1421e-05_r8/)

!     The array KAO contains absorption coefs for each of the 16 g-intervals
!     for a range of pressure levels > ~100mb, temperatures, and ratios
!     of water vapor to CO2.  The first index in the array, JS, runs
!     from 1 to 10, and corresponds to different gas column amount ratios,
!     as expressed through the binary species parameter eta, defined as
!     eta = gas1/(gas1 + (rat) * gas2), where rat is the 
!     ratio of the reference MLS column amount value of gas 1 
!     to that of gas2.
!     The 2nd index in the array, JT, which runs from 1 to 5, corresponds 
!     to different temperatures.  More specifically, JT = 3 means that the 
!     data are for the reference temperature TREF for this  pressure 
!     level, JT = 2 refers to the temperature
!     TREF-15, JT = 1 is for TREF-30, JT = 4 is for TREF+15, and JT = 5
!     is for TREF+30.  The third index, JP, runs from 1 to 13 and refers
!     to the reference pressure level (e.g. JP = 1 is for a
!     pressure of 1053.63 mb).  The fourth index, IG, goes from 1 to 16,
!     and tells us which g-interval the absorption coefficients are for.

      kao(:, 1, 1, 1) = (/ &
     &2.1746e-06_r8,2.0220e-05_r8,3.5039e-05_r8,4.9564e-05_r8,6.4547e-05_r8,8.0645e-05_r8, &
     &1.0050e-04_r8,1.3591e-04_r8,1.1422e-04_r8/)
      kao(:, 2, 1, 1) = (/ &
     &2.4567e-06_r8,2.4642e-05_r8,4.2577e-05_r8,6.0179e-05_r8,7.8156e-05_r8,9.7521e-05_r8, &
     &1.2325e-04_r8,1.6438e-04_r8,1.3834e-04_r8/)
      kao(:, 3, 1, 1) = (/ &
     &2.7778e-06_r8,2.9755e-05_r8,5.1233e-05_r8,7.2538e-05_r8,9.4256e-05_r8,1.1716e-04_r8, &
     &1.4583e-04_r8,1.9818e-04_r8,1.6722e-04_r8/)
      kao(:, 4, 1, 1) = (/ &
     &3.1364e-06_r8,3.5376e-05_r8,6.1122e-05_r8,8.6709e-05_r8,1.1261e-04_r8,1.4025e-04_r8, &
     &1.7411e-04_r8,2.3326e-04_r8,2.0043e-04_r8/)
      kao(:, 5, 1, 1) = (/ &
     &3.4866e-06_r8,4.1773e-05_r8,7.2421e-05_r8,1.0284e-04_r8,1.3368e-04_r8,1.6658e-04_r8, &
     &2.0645e-04_r8,2.7379e-04_r8,2.3933e-04_r8/)
      kao(:, 1, 2, 1) = (/ &
     &2.7658e-06_r8,1.8665e-05_r8,2.9579e-05_r8,4.0556e-05_r8,5.1475e-05_r8,6.3012e-05_r8, &
     &7.6030e-05_r8,9.6554e-05_r8,8.6790e-05_r8/)
      kao(:, 2, 2, 1) = (/ &
     &3.1474e-06_r8,2.2675e-05_r8,3.6322e-05_r8,4.9569e-05_r8,6.2848e-05_r8,7.6725e-05_r8, &
     &9.2975e-05_r8,1.1920e-04_r8,1.0628e-04_r8/)
      kao(:, 3, 2, 1) = (/ &
     &3.5619e-06_r8,2.7222e-05_r8,4.3763e-05_r8,5.9895e-05_r8,7.6025e-05_r8,9.2855e-05_r8, &
     &1.1166e-04_r8,1.4410e-04_r8,1.2840e-04_r8/)
      kao(:, 4, 2, 1) = (/ &
     &4.0332e-06_r8,3.2194e-05_r8,5.2284e-05_r8,7.1664e-05_r8,9.1201e-05_r8,1.1132e-04_r8, &
     &1.3395e-04_r8,1.6948e-04_r8,1.5482e-04_r8/)
      kao(:, 5, 2, 1) = (/ &
     &4.5426e-06_r8,3.7892e-05_r8,6.1930e-05_r8,8.5200e-05_r8,1.0845e-04_r8,1.3257e-04_r8, &
     &1.5957e-04_r8,2.0150e-04_r8,1.8531e-04_r8/)
      kao(:, 1, 3, 1) = (/ &
     &4.6515e-06_r8,1.9518e-05_r8,2.8024e-05_r8,3.5437e-05_r8,4.2060e-05_r8,4.8949e-05_r8, &
     &5.6458e-05_r8,6.6193e-05_r8,6.4702e-05_r8/)
      kao(:, 2, 3, 1) = (/ &
     &5.3085e-06_r8,2.3661e-05_r8,3.4250e-05_r8,4.3649e-05_r8,5.1882e-05_r8,6.0429e-05_r8, &
     &6.9536e-05_r8,8.2456e-05_r8,7.9400e-05_r8/)
      kao(:, 3, 3, 1) = (/ &
     &6.0401e-06_r8,2.8338e-05_r8,4.1344e-05_r8,5.2675e-05_r8,6.2996e-05_r8,7.3527e-05_r8, &
     &8.4697e-05_r8,9.9499e-05_r8,9.6161e-05_r8/)
      kao(:, 4, 3, 1) = (/ &
     &6.8636e-06_r8,3.3625e-05_r8,4.9393e-05_r8,6.2729e-05_r8,7.5705e-05_r8,8.8632e-05_r8, &
     &1.0218e-04_r8,1.1965e-04_r8,1.1595e-04_r8/)
      kao(:, 5, 3, 1) = (/ &
     &7.7592e-06_r8,3.9481e-05_r8,5.8243e-05_r8,7.4429e-05_r8,9.0184e-05_r8,1.0593e-04_r8, &
     &1.2226e-04_r8,1.4329e-04_r8,1.3957e-04_r8/)
      kao(:, 1, 4, 1) = (/ &
     &7.8254e-06_r8,2.2162e-05_r8,2.8768e-05_r8,3.4092e-05_r8,3.8273e-05_r8,4.1617e-05_r8, &
     &4.4585e-05_r8,4.7843e-05_r8,5.0090e-05_r8/)
      kao(:, 2, 4, 1) = (/ &
     &9.0107e-06_r8,2.6852e-05_r8,3.5234e-05_r8,4.2063e-05_r8,4.7365e-05_r8,5.1787e-05_r8, &
     &5.5276e-05_r8,5.9864e-05_r8,6.1930e-05_r8/)
      kao(:, 3, 4, 1) = (/ &
     &1.0349e-05_r8,3.2172e-05_r8,4.2565e-05_r8,5.1061e-05_r8,5.7654e-05_r8,6.3243e-05_r8, &
     &6.7675e-05_r8,7.3397e-05_r8,7.5548e-05_r8/)
      kao(:, 4, 4, 1) = (/ &
     &1.1906e-05_r8,3.8190e-05_r8,5.0960e-05_r8,6.1161e-05_r8,6.9192e-05_r8,7.6085e-05_r8, &
     &8.1960e-05_r8,8.9085e-05_r8,9.1511e-05_r8/)
      kao(:, 5, 4, 1) = (/ &
     &1.3610e-05_r8,4.4853e-05_r8,6.0373e-05_r8,7.2336e-05_r8,8.2116e-05_r8,9.0436e-05_r8, &
     &9.8270e-05_r8,1.0717e-04_r8,1.0994e-04_r8/)
      kao(:, 1, 5, 1) = (/ &
     &1.2215e-05_r8,2.6429e-05_r8,3.0893e-05_r8,3.4176e-05_r8,3.6538e-05_r8,3.7893e-05_r8, &
     &3.8292e-05_r8,3.7482e-05_r8,3.9876e-05_r8/)
      kao(:, 2, 5, 1) = (/ &
     &1.4086e-05_r8,3.1907e-05_r8,3.7874e-05_r8,4.2237e-05_r8,4.5377e-05_r8,4.7376e-05_r8, &
     &4.7976e-05_r8,4.7239e-05_r8,4.9622e-05_r8/)
      kao(:, 3, 5, 1) = (/ &
     &1.6264e-05_r8,3.8161e-05_r8,4.5845e-05_r8,5.1471e-05_r8,5.5412e-05_r8,5.8145e-05_r8, &
     &5.8993e-05_r8,5.8204e-05_r8,6.0963e-05_r8/)
      kao(:, 4, 5, 1) = (/ &
     &1.8858e-05_r8,4.5142e-05_r8,5.4763e-05_r8,6.1781e-05_r8,6.6831e-05_r8,7.0144e-05_r8, &
     &7.1439e-05_r8,7.0642e-05_r8,7.3664e-05_r8/)
      kao(:, 5, 5, 1) = (/ &
     &2.1682e-05_r8,5.2995e-05_r8,6.4832e-05_r8,7.3555e-05_r8,7.9689e-05_r8,8.3689e-05_r8, &
     &8.5451e-05_r8,8.5137e-05_r8,8.8330e-05_r8/)
      kao(:, 1, 6, 1) = (/ &
     &1.7737e-05_r8,3.1507e-05_r8,3.4689e-05_r8,3.5923e-05_r8,3.6042e-05_r8,3.5547e-05_r8, &
     &3.3855e-05_r8,3.0889e-05_r8,3.3707e-05_r8/)
      kao(:, 2, 6, 1) = (/ &
     &2.0662e-05_r8,3.8270e-05_r8,4.2282e-05_r8,4.3931e-05_r8,4.4914e-05_r8,4.4463e-05_r8, &
     &4.2744e-05_r8,3.9347e-05_r8,4.1797e-05_r8/)
      kao(:, 3, 6, 1) = (/ &
     &2.4128e-05_r8,4.5613e-05_r8,5.0898e-05_r8,5.3590e-05_r8,5.4968e-05_r8,5.4808e-05_r8, &
     &5.3000e-05_r8,4.8943e-05_r8,5.1147e-05_r8/)
      kao(:, 4, 6, 1) = (/ &
     &2.7999e-05_r8,5.3907e-05_r8,6.0955e-05_r8,6.4423e-05_r8,6.6442e-05_r8,6.6605e-05_r8, &
     &6.4604e-05_r8,5.9878e-05_r8,6.1516e-05_r8/)
      kao(:, 5, 6, 1) = (/ &
     &3.2152e-05_r8,6.3564e-05_r8,7.2012e-05_r8,7.6692e-05_r8,7.9463e-05_r8,7.9823e-05_r8, &
     &7.7573e-05_r8,7.2281e-05_r8,7.4081e-05_r8/)
      kao(:, 1, 7, 1) = (/ &
     &2.6880e-05_r8,4.1451e-05_r8,4.2153e-05_r8,4.1795e-05_r8,4.0071e-05_r8,3.7010e-05_r8, &
     &3.2935e-05_r8,2.7157e-05_r8,3.0165e-05_r8/)
      kao(:, 2, 7, 1) = (/ &
     &3.1867e-05_r8,5.0449e-05_r8,5.1950e-05_r8,5.1350e-05_r8,4.9502e-05_r8,4.6117e-05_r8, &
     &4.1536e-05_r8,3.4782e-05_r8,3.7420e-05_r8/)
      kao(:, 3, 7, 1) = (/ &
     &3.7274e-05_r8,6.0537e-05_r8,6.2610e-05_r8,6.2280e-05_r8,6.0355e-05_r8,5.6848e-05_r8, &
     &5.1457e-05_r8,4.3658e-05_r8,4.5586e-05_r8/)
      kao(:, 4, 7, 1) = (/ &
     &4.3315e-05_r8,7.1931e-05_r8,7.4511e-05_r8,7.5005e-05_r8,7.2731e-05_r8,6.8916e-05_r8, &
     &6.2904e-05_r8,5.3755e-05_r8,5.5264e-05_r8/)
      kao(:, 5, 7, 1) = (/ &
     &4.9907e-05_r8,8.4683e-05_r8,8.8542e-05_r8,8.9292e-05_r8,8.6631e-05_r8,8.2549e-05_r8, &
     &7.6077e-05_r8,6.5242e-05_r8,6.5892e-05_r8/)
      kao(:, 1, 8, 1) = (/ &
     &4.7627e-05_r8,6.4864e-05_r8,6.3521e-05_r8,5.9018e-05_r8,5.3108e-05_r8,4.6571e-05_r8, &
     &3.8650e-05_r8,2.8473e-05_r8,2.9135e-05_r8/)
      kao(:, 2, 8, 1) = (/ &
     &5.7767e-05_r8,7.9036e-05_r8,7.7751e-05_r8,7.3012e-05_r8,6.6279e-05_r8,5.8148e-05_r8, &
     &4.8459e-05_r8,3.6303e-05_r8,3.6552e-05_r8/)
      kao(:, 3, 8, 1) = (/ &
     &6.8331e-05_r8,9.5161e-05_r8,9.3980e-05_r8,8.8741e-05_r8,8.0901e-05_r8,7.1279e-05_r8, &
     &5.9682e-05_r8,4.5314e-05_r8,4.4112e-05_r8/)
      kao(:, 4, 8, 1) = (/ &
     &7.9894e-05_r8,1.1320e-04_r8,1.1263e-04_r8,1.0646e-04_r8,9.7413e-05_r8,8.6626e-05_r8, &
     &7.2540e-05_r8,5.5667e-05_r8,5.2996e-05_r8/)
      kao(:, 5, 8, 1) = (/ &
     &9.2972e-05_r8,1.3437e-04_r8,1.3320e-04_r8,1.2651e-04_r8,1.1648e-04_r8,1.0389e-04_r8, &
     &8.7249e-05_r8,6.7590e-05_r8,6.3371e-05_r8/)
      kao(:, 1, 9, 1) = (/ &
     &1.5799e-04_r8,1.8833e-04_r8,1.7550e-04_r8,1.5612e-04_r8,1.3380e-04_r8,1.0918e-04_r8, &
     &8.2063e-05_r8,5.1241e-05_r8,3.5341e-05_r8/)
      kao(:, 2, 9, 1) = (/ &
     &1.9443e-04_r8,2.2819e-04_r8,2.1471e-04_r8,1.9244e-04_r8,1.6566e-04_r8,1.3587e-04_r8, &
     &1.0320e-04_r8,6.4536e-05_r8,4.5195e-05_r8/)
      kao(:, 3, 9, 1) = (/ &
     &2.3622e-04_r8,2.7685e-04_r8,2.6057e-04_r8,2.3445e-04_r8,2.0276e-04_r8,1.6671e-04_r8, &
     &1.2651e-04_r8,7.9797e-05_r8,5.6882e-05_r8/)
      kao(:, 4, 9, 1) = (/ &
     &2.7828e-04_r8,3.3139e-04_r8,3.1210e-04_r8,2.8146e-04_r8,2.4413e-04_r8,2.0071e-04_r8, &
     &1.5211e-04_r8,9.7273e-05_r8,6.9081e-05_r8/)
      kao(:, 5, 9, 1) = (/ &
     &3.2528e-04_r8,3.9307e-04_r8,3.6944e-04_r8,3.3441e-04_r8,2.9052e-04_r8,2.3944e-04_r8, &
     &1.8220e-04_r8,1.1689e-04_r8,8.4202e-05_r8/)
      kao(:, 1,10, 1) = (/ &
     &5.9822e-04_r8,6.2372e-04_r8,5.8089e-04_r8,5.1261e-04_r8,4.3322e-04_r8,3.4273e-04_r8, &
     &2.4200e-04_r8,1.3558e-04_r8,7.2135e-05_r8/)
      kao(:, 2,10, 1) = (/ &
     &7.4373e-04_r8,7.8308e-04_r8,7.2223e-04_r8,6.3443e-04_r8,5.3223e-04_r8,4.2429e-04_r8, &
     &3.0242e-04_r8,1.7107e-04_r8,9.5831e-05_r8/)
      kao(:, 3,10, 1) = (/ &
     &9.1691e-04_r8,9.5621e-04_r8,8.7625e-04_r8,7.6950e-04_r8,6.5144e-04_r8,5.1701e-04_r8, &
     &3.7121e-04_r8,2.1199e-04_r8,1.2423e-04_r8/)
      kao(:, 4,10, 1) = (/ &
     &1.1043e-03_r8,1.1414e-03_r8,1.0539e-03_r8,9.3161e-04_r8,7.8672e-04_r8,6.2626e-04_r8, &
     &4.5160e-04_r8,2.5892e-04_r8,1.5666e-04_r8/)
      kao(:, 5,10, 1) = (/ &
     &1.3045e-03_r8,1.3552e-03_r8,1.2556e-03_r8,1.1172e-03_r8,9.4316e-04_r8,7.4718e-04_r8, &
     &5.4008e-04_r8,3.1196e-04_r8,1.9599e-04_r8/)
      kao(:, 1,11, 1) = (/ &
     &8.7712e-04_r8,8.8837e-04_r8,8.1430e-04_r8,7.2064e-04_r8,6.0791e-04_r8,4.8638e-04_r8, &
     &3.4855e-04_r8,1.8904e-04_r8,9.5086e-05_r8/)
      kao(:, 2,11, 1) = (/ &
     &1.1025e-03_r8,1.1220e-03_r8,1.0310e-03_r8,9.0820e-04_r8,7.5807e-04_r8,5.9864e-04_r8, &
     &4.3064e-04_r8,2.3702e-04_r8,1.2669e-04_r8/)
      kao(:, 3,11, 1) = (/ &
     &1.3684e-03_r8,1.3746e-03_r8,1.2594e-03_r8,1.1058e-03_r8,9.3187e-04_r8,7.3748e-04_r8, &
     &5.2465e-04_r8,2.9520e-04_r8,1.6181e-04_r8/)
      kao(:, 4,11, 1) = (/ &
     &1.6471e-03_r8,1.6623e-03_r8,1.5206e-03_r8,1.3382e-03_r8,1.1315e-03_r8,8.9471e-04_r8, &
     &6.4214e-04_r8,3.6310e-04_r8,2.0489e-04_r8/)
      kao(:, 5,11, 1) = (/ &
     &1.9688e-03_r8,1.9772e-03_r8,1.8138e-03_r8,1.6028e-03_r8,1.3619e-03_r8,1.0826e-03_r8, &
     &7.7699e-04_r8,4.3404e-04_r8,2.5459e-04_r8/)
      kao(:, 1,12, 1) = (/ &
     &9.4409e-04_r8,9.5030e-04_r8,8.6958e-04_r8,7.6723e-04_r8,6.4799e-04_r8,5.1804e-04_r8, &
     &3.7162e-04_r8,2.0179e-04_r8,1.0181e-04_r8/)
      kao(:, 2,12, 1) = (/ &
     &1.2024e-03_r8,1.2024e-03_r8,1.1035e-03_r8,9.7105e-04_r8,8.1245e-04_r8,6.4379e-04_r8, &
     &4.6123e-04_r8,2.5624e-04_r8,1.3746e-04_r8/)
      kao(:, 3,12, 1) = (/ &
     &1.5009e-03_r8,1.4895e-03_r8,1.3527e-03_r8,1.1889e-03_r8,1.0016e-03_r8,7.9376e-04_r8, &
     &5.6671e-04_r8,3.1943e-04_r8,1.7568e-04_r8/)
      kao(:, 4,12, 1) = (/ &
     &1.8192e-03_r8,1.8117e-03_r8,1.6422e-03_r8,1.4410e-03_r8,1.2151e-03_r8,9.6812e-04_r8, &
     &6.9546e-04_r8,3.9137e-04_r8,2.1782e-04_r8/)
      kao(:, 5,12, 1) = (/ &
     &2.1766e-03_r8,2.1635e-03_r8,1.9700e-03_r8,1.7314e-03_r8,1.4651e-03_r8,1.1736e-03_r8, &
     &8.4593e-04_r8,4.7032e-04_r8,2.5768e-04_r8/)
      kao(:, 1,13, 1) = (/ &
     &8.2069e-04_r8,8.2445e-04_r8,7.5154e-04_r8,6.6188e-04_r8,5.6185e-04_r8,4.5083e-04_r8, &
     &3.2275e-04_r8,1.7851e-04_r8,9.1099e-05_r8/)
      kao(:, 2,13, 1) = (/ &
     &1.0473e-03_r8,1.0502e-03_r8,9.5966e-04_r8,8.4257e-04_r8,7.0741e-04_r8,5.6233e-04_r8, &
     &4.0370e-04_r8,2.2679e-04_r8,1.2172e-04_r8/)
      kao(:, 3,13, 1) = (/ &
     &1.3133e-03_r8,1.3024e-03_r8,1.1846e-03_r8,1.0375e-03_r8,8.7436e-04_r8,6.9645e-04_r8, &
     &5.0292e-04_r8,2.8463e-04_r8,1.5549e-04_r8/)
      kao(:, 4,13, 1) = (/ &
     &1.6064e-03_r8,1.5873e-03_r8,1.4461e-03_r8,1.2677e-03_r8,1.0715e-03_r8,8.5901e-04_r8, &
     &6.1842e-04_r8,3.4781e-04_r8,1.9357e-04_r8/)
      kao(:, 5,13, 1) = (/ &
     &1.9305e-03_r8,1.9051e-03_r8,1.7364e-03_r8,1.5314e-03_r8,1.2972e-03_r8,1.0440e-03_r8, &
     &7.5312e-04_r8,4.2210e-04_r8,2.3145e-04_r8/)
      kao(:, 1, 1, 2) = (/ &
     &8.1346e-06_r8,1.0615e-04_r8,1.6451e-04_r8,2.1843e-04_r8,2.7217e-04_r8,3.3271e-04_r8, &
     &4.0424e-04_r8,5.2737e-04_r8,4.6457e-04_r8/)
      kao(:, 2, 1, 2) = (/ &
     &9.5357e-06_r8,1.2245e-04_r8,1.9203e-04_r8,2.5686e-04_r8,3.2147e-04_r8,3.9091e-04_r8, &
     &4.7632e-04_r8,6.1736e-04_r8,5.3890e-04_r8/)
      kao(:, 3, 1, 2) = (/ &
     &1.0894e-05_r8,1.4027e-04_r8,2.2328e-04_r8,3.0098e-04_r8,3.7740e-04_r8,4.5873e-04_r8, &
     &5.6256e-04_r8,7.2836e-04_r8,6.2820e-04_r8/)
      kao(:, 4, 1, 2) = (/ &
     &1.2218e-05_r8,1.6125e-04_r8,2.5837e-04_r8,3.4988e-04_r8,4.3991e-04_r8,5.3396e-04_r8, &
     &6.5212e-04_r8,8.5783e-04_r8,7.3258e-04_r8/)
      kao(:, 5, 1, 2) = (/ &
     &1.3559e-05_r8,1.8418e-04_r8,2.9709e-04_r8,4.0563e-04_r8,5.0913e-04_r8,6.2018e-04_r8, &
     &7.5464e-04_r8,9.9267e-04_r8,8.5248e-04_r8/)
      kao(:, 1, 2, 2) = (/ &
     &1.0648e-05_r8,1.0205e-04_r8,1.5218e-04_r8,1.9460e-04_r8,2.3469e-04_r8,2.7445e-04_r8, &
     &3.2374e-04_r8,3.9687e-04_r8,3.7021e-04_r8/)
      kao(:, 2, 2, 2) = (/ &
     &1.2479e-05_r8,1.1864e-04_r8,1.7693e-04_r8,2.2906e-04_r8,2.7817e-04_r8,3.2635e-04_r8, &
     &3.8100e-04_r8,4.6812e-04_r8,4.2972e-04_r8/)
      kao(:, 3, 2, 2) = (/ &
     &1.4325e-05_r8,1.3615e-04_r8,2.0613e-04_r8,2.6822e-04_r8,3.2742e-04_r8,3.8532e-04_r8, &
     &4.4992e-04_r8,5.5581e-04_r8,5.0382e-04_r8/)
      kao(:, 4, 2, 2) = (/ &
     &1.6131e-05_r8,1.5522e-04_r8,2.3823e-04_r8,3.1216e-04_r8,3.8163e-04_r8,4.4987e-04_r8, &
     &5.2423e-04_r8,6.5095e-04_r8,5.8901e-04_r8/)
      kao(:, 5, 2, 2) = (/ &
     &1.7840e-05_r8,1.7738e-04_r8,2.7413e-04_r8,3.6145e-04_r8,4.4307e-04_r8,5.2217e-04_r8, &
     &6.0968e-04_r8,7.4929e-04_r8,6.8588e-04_r8/)
      kao(:, 1, 3, 2) = (/ &
     &1.7975e-05_r8,1.1236e-04_r8,1.5383e-04_r8,1.8734e-04_r8,2.1612e-04_r8,2.4014e-04_r8, &
     &2.6058e-04_r8,2.9343e-04_r8,2.9752e-04_r8/)
      kao(:, 2, 3, 2) = (/ &
     &2.1208e-05_r8,1.3084e-04_r8,1.8013e-04_r8,2.2080e-04_r8,2.5543e-04_r8,2.8432e-04_r8, &
     &3.1199e-04_r8,3.4846e-04_r8,3.5196e-04_r8/)
      kao(:, 3, 3, 2) = (/ &
     &2.4558e-05_r8,1.5021e-04_r8,2.0878e-04_r8,2.5693e-04_r8,2.9945e-04_r8,3.3619e-04_r8, &
     &3.7048e-04_r8,4.1334e-04_r8,4.1350e-04_r8/)
      kao(:, 4, 3, 2) = (/ &
     &2.7720e-05_r8,1.7111e-04_r8,2.4012e-04_r8,2.9904e-04_r8,3.4910e-04_r8,3.9367e-04_r8, &
     &4.3560e-04_r8,4.8351e-04_r8,4.8248e-04_r8/)
      kao(:, 5, 3, 2) = (/ &
     &3.0839e-05_r8,1.9412e-04_r8,2.7570e-04_r8,3.4584e-04_r8,4.0483e-04_r8,4.5917e-04_r8, &
     &5.0628e-04_r8,5.6356e-04_r8,5.6016e-04_r8/)
      kao(:, 1, 4, 2) = (/ &
     &3.0257e-05_r8,1.3348e-04_r8,1.6797e-04_r8,1.9240e-04_r8,2.0954e-04_r8,2.2222e-04_r8, &
     &2.2898e-04_r8,2.3143e-04_r8,2.5081e-04_r8/)
      kao(:, 2, 4, 2) = (/ &
     &3.6110e-05_r8,1.5427e-04_r8,1.9683e-04_r8,2.2498e-04_r8,2.4900e-04_r8,2.6495e-04_r8, &
     &2.7383e-04_r8,2.7831e-04_r8,3.0130e-04_r8/)
      kao(:, 3, 4, 2) = (/ &
     &4.2020e-05_r8,1.7731e-04_r8,2.2733e-04_r8,2.6268e-04_r8,2.9200e-04_r8,3.1270e-04_r8, &
     &3.2430e-04_r8,3.3243e-04_r8,3.4977e-04_r8/)
      kao(:, 4, 4, 2) = (/ &
     &4.7704e-05_r8,2.0254e-04_r8,2.6080e-04_r8,3.0470e-04_r8,3.4066e-04_r8,3.6571e-04_r8, &
     &3.8177e-04_r8,3.9329e-04_r8,4.0928e-04_r8/)
      kao(:, 5, 4, 2) = (/ &
     &5.3448e-05_r8,2.2883e-04_r8,2.9767e-04_r8,3.4976e-04_r8,3.9269e-04_r8,4.2565e-04_r8, &
     &4.4636e-04_r8,4.5989e-04_r8,4.7277e-04_r8/)
      kao(:, 1, 5, 2) = (/ &
     &4.6988e-05_r8,1.6787e-04_r8,1.9191e-04_r8,2.0648e-04_r8,2.1525e-04_r8,2.1596e-04_r8, &
     &2.0906e-04_r8,1.9576e-04_r8,2.0610e-04_r8/)
      kao(:, 2, 5, 2) = (/ &
     &5.6510e-05_r8,1.9317e-04_r8,2.2448e-04_r8,2.4373e-04_r8,2.5210e-04_r8,2.5521e-04_r8, &
     &2.5032e-04_r8,2.3737e-04_r8,2.5015e-04_r8/)
      kao(:, 3, 5, 2) = (/ &
     &6.6097e-05_r8,2.2111e-04_r8,2.5901e-04_r8,2.8182e-04_r8,2.9480e-04_r8,2.9992e-04_r8, &
     &2.9852e-04_r8,2.8340e-04_r8,3.0111e-04_r8/)
      kao(:, 4, 5, 2) = (/ &
     &7.5373e-05_r8,2.5095e-04_r8,2.9694e-04_r8,3.2434e-04_r8,3.4231e-04_r8,3.5125e-04_r8, &
     &3.5172e-04_r8,3.3625e-04_r8,3.5720e-04_r8/)
      kao(:, 5, 5, 2) = (/ &
     &8.4653e-05_r8,2.8271e-04_r8,3.3633e-04_r8,3.7103e-04_r8,3.9540e-04_r8,4.0854e-04_r8, &
     &4.1017e-04_r8,3.9523e-04_r8,4.0911e-04_r8/)
      kao(:, 1, 6, 2) = (/ &
     &6.8194e-05_r8,2.1119e-04_r8,2.2511e-04_r8,2.2905e-04_r8,2.2761e-04_r8,2.1982e-04_r8, &
     &2.0183e-04_r8,1.7113e-04_r8,1.7129e-04_r8/)
      kao(:, 2, 6, 2) = (/ &
     &8.3032e-05_r8,2.4138e-04_r8,2.6267e-04_r8,2.7055e-04_r8,2.6995e-04_r8,2.6005e-04_r8, &
     &2.3793e-04_r8,2.0771e-04_r8,2.1052e-04_r8/)
      kao(:, 3, 6, 2) = (/ &
     &9.7316e-05_r8,2.7435e-04_r8,3.0334e-04_r8,3.1415e-04_r8,3.1605e-04_r8,3.0269e-04_r8, &
     &2.8123e-04_r8,2.4990e-04_r8,2.5531e-04_r8/)
      kao(:, 4, 6, 2) = (/ &
     &1.1184e-04_r8,3.0984e-04_r8,3.4680e-04_r8,3.6228e-04_r8,3.6303e-04_r8,3.5165e-04_r8, &
     &3.2989e-04_r8,2.9654e-04_r8,3.0715e-04_r8/)
      kao(:, 5, 6, 2) = (/ &
     &1.2632e-04_r8,3.4683e-04_r8,3.9318e-04_r8,4.1205e-04_r8,4.1568e-04_r8,4.0572e-04_r8, &
     &3.8584e-04_r8,3.4794e-04_r8,3.6334e-04_r8/)
      kao(:, 1, 7, 2) = (/ &
     &1.0382e-04_r8,2.6395e-04_r8,2.8989e-04_r8,2.8076e-04_r8,2.6344e-04_r8,2.4071e-04_r8, &
     &2.1106e-04_r8,1.6791e-04_r8,1.4516e-04_r8/)
      kao(:, 2, 7, 2) = (/ &
     &1.2713e-04_r8,3.0635e-04_r8,3.3550e-04_r8,3.2897e-04_r8,3.1196e-04_r8,2.8824e-04_r8, &
     &2.5288e-04_r8,2.0031e-04_r8,1.8143e-04_r8/)
      kao(:, 3, 7, 2) = (/ &
     &1.5126e-04_r8,3.5047e-04_r8,3.8510e-04_r8,3.8068e-04_r8,3.6466e-04_r8,3.3889e-04_r8, &
     &2.9600e-04_r8,2.3790e-04_r8,2.2323e-04_r8/)
      kao(:, 4, 7, 2) = (/ &
     &1.7453e-04_r8,3.9749e-04_r8,4.3569e-04_r8,4.3708e-04_r8,4.2166e-04_r8,3.9085e-04_r8, &
     &3.4474e-04_r8,2.8074e-04_r8,2.7137e-04_r8/)
      kao(:, 5, 7, 2) = (/ &
     &1.9815e-04_r8,4.4700e-04_r8,4.9020e-04_r8,4.9608e-04_r8,4.8316e-04_r8,4.4845e-04_r8, &
     &4.0007e-04_r8,3.2811e-04_r8,3.2529e-04_r8/)
      kao(:, 1, 8, 2) = (/ &
     &1.8568e-04_r8,3.7522e-04_r8,4.0441e-04_r8,4.0400e-04_r8,3.7101e-04_r8,3.2090e-04_r8, &
     &2.6014e-04_r8,1.8741e-04_r8,1.4093e-04_r8/)
      kao(:, 2, 8, 2) = (/ &
     &2.2706e-04_r8,4.4100e-04_r8,4.7331e-04_r8,4.6941e-04_r8,4.3330e-04_r8,3.7933e-04_r8, &
     &3.1116e-04_r8,2.2753e-04_r8,1.7550e-04_r8/)
      kao(:, 3, 8, 2) = (/ &
     &2.7313e-04_r8,5.0681e-04_r8,5.4665e-04_r8,5.4041e-04_r8,5.0328e-04_r8,4.4299e-04_r8, &
     &3.6626e-04_r8,2.6706e-04_r8,2.1512e-04_r8/)
      kao(:, 4, 8, 2) = (/ &
     &3.2050e-04_r8,5.7784e-04_r8,6.2469e-04_r8,6.1766e-04_r8,5.7799e-04_r8,5.1310e-04_r8, &
     &4.2712e-04_r8,3.1237e-04_r8,2.5864e-04_r8/)
      kao(:, 5, 8, 2) = (/ &
     &3.6492e-04_r8,6.4972e-04_r8,7.0632e-04_r8,6.9926e-04_r8,6.5563e-04_r8,5.8535e-04_r8, &
     &4.8972e-04_r8,3.6487e-04_r8,3.1085e-04_r8/)
      kao(:, 1, 9, 2) = (/ &
     &6.2599e-04_r8,8.6654e-04_r8,9.0634e-04_r8,8.8937e-04_r8,8.1140e-04_r8,7.1027e-04_r8, &
     &5.7167e-04_r8,3.5735e-04_r8,2.0982e-04_r8/)
      kao(:, 2, 9, 2) = (/ &
     &7.7627e-04_r8,1.0704e-03_r8,1.1043e-03_r8,1.0586e-03_r8,9.6032e-04_r8,8.3995e-04_r8, &
     &6.6547e-04_r8,4.2636e-04_r8,2.5832e-04_r8/)
      kao(:, 3, 9, 2) = (/ &
     &9.3794e-04_r8,1.2619e-03_r8,1.2949e-03_r8,1.2284e-03_r8,1.1156e-03_r8,9.7182e-04_r8, &
     &7.6979e-04_r8,5.0109e-04_r8,3.1973e-04_r8/)
      kao(:, 4, 9, 2) = (/ &
     &1.1114e-03_r8,1.4537e-03_r8,1.4722e-03_r8,1.4030e-03_r8,1.2802e-03_r8,1.1177e-03_r8, &
     &8.8445e-04_r8,5.8120e-04_r8,3.8922e-04_r8/)
      kao(:, 5, 9, 2) = (/ &
     &1.2779e-03_r8,1.6415e-03_r8,1.6560e-03_r8,1.5834e-03_r8,1.4519e-03_r8,1.2713e-03_r8, &
     &1.0105e-03_r8,6.6729e-04_r8,4.6624e-04_r8/)
      kao(:, 1,10, 2) = (/ &
     &2.4553e-03_r8,2.6165e-03_r8,2.4993e-03_r8,2.2847e-03_r8,2.0267e-03_r8,1.7115e-03_r8, &
     &1.3397e-03_r8,8.6368e-04_r8,3.6576e-04_r8/)
      kao(:, 2,10, 2) = (/ &
     &3.0620e-03_r8,3.2511e-03_r8,3.1049e-03_r8,2.8553e-03_r8,2.5348e-03_r8,2.1265e-03_r8, &
     &1.6314e-03_r8,1.0269e-03_r8,4.5803e-04_r8/)
      kao(:, 3,10, 2) = (/ &
     &3.7364e-03_r8,3.9627e-03_r8,3.7660e-03_r8,3.4224e-03_r8,3.0121e-03_r8,2.5166e-03_r8, &
     &1.9135e-03_r8,1.1990e-03_r8,5.6685e-04_r8/)
      kao(:, 4,10, 2) = (/ &
     &4.4530e-03_r8,4.6554e-03_r8,4.3836e-03_r8,3.9682e-03_r8,3.4829e-03_r8,2.8809e-03_r8, &
     &2.1972e-03_r8,1.3815e-03_r8,6.9188e-04_r8/)
      kao(:, 5,10, 2) = (/ &
     &5.1575e-03_r8,5.3264e-03_r8,4.9909e-03_r8,4.5087e-03_r8,3.9257e-03_r8,3.2602e-03_r8, &
     &2.4888e-03_r8,1.5715e-03_r8,8.2270e-04_r8/)
      kao(:, 1,11, 2) = (/ &
     &3.7833e-03_r8,3.8112e-03_r8,3.5566e-03_r8,3.1989e-03_r8,2.7686e-03_r8,2.2723e-03_r8, &
     &1.7364e-03_r8,1.0753e-03_r8,4.0590e-04_r8/)
      kao(:, 2,11, 2) = (/ &
     &4.6966e-03_r8,4.7207e-03_r8,4.4156e-03_r8,3.9736e-03_r8,3.4554e-03_r8,2.8577e-03_r8, &
     &2.1338e-03_r8,1.2945e-03_r8,5.0517e-04_r8/)
      kao(:, 3,11, 2) = (/ &
     &5.7189e-03_r8,5.7590e-03_r8,5.3345e-03_r8,4.7708e-03_r8,4.1084e-03_r8,3.3729e-03_r8, &
     &2.5008e-03_r8,1.5078e-03_r8,6.3337e-04_r8/)
      kao(:, 4,11, 2) = (/ &
     &6.7827e-03_r8,6.7469e-03_r8,6.2278e-03_r8,5.5367e-03_r8,4.7380e-03_r8,3.8594e-03_r8, &
     &2.8648e-03_r8,1.7294e-03_r8,7.7415e-04_r8/)
      kao(:, 5,11, 2) = (/ &
     &7.8200e-03_r8,7.7382e-03_r8,7.0901e-03_r8,6.2644e-03_r8,5.3533e-03_r8,4.3510e-03_r8, &
     &3.2356e-03_r8,1.9722e-03_r8,9.3312e-04_r8/)
      kao(:, 1,12, 2) = (/ &
     &4.2783e-03_r8,4.2041e-03_r8,3.8742e-03_r8,3.4634e-03_r8,2.9720e-03_r8,2.4393e-03_r8, &
     &1.8351e-03_r8,1.1175e-03_r8,3.9253e-04_r8/)
      kao(:, 2,12, 2) = (/ &
     &5.3337e-03_r8,5.2652e-03_r8,4.8301e-03_r8,4.3189e-03_r8,3.7223e-03_r8,3.0228e-03_r8, &
     &2.2408e-03_r8,1.3443e-03_r8,4.8795e-04_r8/)
      kao(:, 3,12, 2) = (/ &
     &6.5143e-03_r8,6.3579e-03_r8,5.8237e-03_r8,5.1812e-03_r8,4.4118e-03_r8,3.5721e-03_r8, &
     &2.6281e-03_r8,1.5684e-03_r8,6.0394e-04_r8/)
      kao(:, 4,12, 2) = (/ &
     &7.6468e-03_r8,7.4276e-03_r8,6.7625e-03_r8,6.0120e-03_r8,5.0805e-03_r8,4.0892e-03_r8, &
     &3.0024e-03_r8,1.8032e-03_r8,7.4856e-04_r8/)
      kao(:, 5,12, 2) = (/ &
     &8.7322e-03_r8,8.4845e-03_r8,7.6878e-03_r8,6.7875e-03_r8,5.7064e-03_r8,4.6095e-03_r8, &
     &3.4027e-03_r8,2.0497e-03_r8,9.3030e-04_r8/)
      kao(:, 1,13, 2) = (/ &
     &3.8383e-03_r8,3.7685e-03_r8,3.4781e-03_r8,3.1000e-03_r8,2.6661e-03_r8,2.1777e-03_r8, &
     &1.6207e-03_r8,9.7395e-04_r8,3.4434e-04_r8/)
      kao(:, 2,13, 2) = (/ &
     &4.7991e-03_r8,4.7287e-03_r8,4.3604e-03_r8,3.8801e-03_r8,3.3054e-03_r8,2.6658e-03_r8, &
     &1.9755e-03_r8,1.1692e-03_r8,4.3018e-04_r8/)
      kao(:, 3,13, 2) = (/ &
     &5.8240e-03_r8,5.6632e-03_r8,5.1895e-03_r8,4.6114e-03_r8,3.9052e-03_r8,3.1338e-03_r8, &
     &2.3066e-03_r8,1.3724e-03_r8,5.3490e-04_r8/)
      kao(:, 4,13, 2) = (/ &
     &6.7942e-03_r8,6.6067e-03_r8,6.0062e-03_r8,5.2927e-03_r8,4.4607e-03_r8,3.5870e-03_r8, &
     &2.6413e-03_r8,1.5766e-03_r8,6.6330e-04_r8/)
      kao(:, 5,13, 2) = (/ &
     &7.7135e-03_r8,7.4856e-03_r8,6.7623e-03_r8,5.9543e-03_r8,5.0216e-03_r8,4.0477e-03_r8, &
     &2.9856e-03_r8,1.7918e-03_r8,8.1116e-04_r8/)
      kao(:, 1, 1, 3) = (/ &
     &2.4793e-05_r8,3.0799e-04_r8,4.6290e-04_r8,5.9325e-04_r8,7.1737e-04_r8,8.2193e-04_r8, &
     &9.4048e-04_r8,1.1399e-03_r8,1.0252e-03_r8/)
      kao(:, 2, 1, 3) = (/ &
     &2.6296e-05_r8,3.5350e-04_r8,5.3963e-04_r8,6.9573e-04_r8,8.4910e-04_r8,9.9005e-04_r8, &
     &1.1353e-03_r8,1.3914e-03_r8,1.2872e-03_r8/)
      kao(:, 3, 1, 3) = (/ &
     &2.7819e-05_r8,4.0345e-04_r8,6.2337e-04_r8,8.1130e-04_r8,9.9260e-04_r8,1.1727e-03_r8, &
     &1.3740e-03_r8,1.6958e-03_r8,1.5768e-03_r8/)
      kao(:, 4, 1, 3) = (/ &
     &2.9505e-05_r8,4.5829e-04_r8,7.1308e-04_r8,9.3786e-04_r8,1.1508e-03_r8,1.3827e-03_r8, &
     &1.6466e-03_r8,2.0604e-03_r8,1.9074e-03_r8/)
      kao(:, 5, 1, 3) = (/ &
     &3.1281e-05_r8,5.1795e-04_r8,8.1473e-04_r8,1.0770e-03_r8,1.3366e-03_r8,1.6108e-03_r8, &
     &1.9547e-03_r8,2.4904e-03_r8,2.2803e-03_r8/)
      kao(:, 1, 2, 3) = (/ &
     &3.2793e-05_r8,3.0694e-04_r8,4.5221e-04_r8,5.6459e-04_r8,6.5806e-04_r8,7.4456e-04_r8, &
     &8.0925e-04_r8,9.1019e-04_r8,8.6945e-04_r8/)
      kao(:, 2, 2, 3) = (/ &
     &3.4666e-05_r8,3.5123e-04_r8,5.2466e-04_r8,6.5968e-04_r8,7.7040e-04_r8,8.8249e-04_r8, &
     &9.7906e-04_r8,1.1056e-03_r8,1.0654e-03_r8/)
      kao(:, 3, 2, 3) = (/ &
     &3.6731e-05_r8,4.0004e-04_r8,6.0292e-04_r8,7.6491e-04_r8,9.0091e-04_r8,1.0289e-03_r8, &
     &1.1668e-03_r8,1.3438e-03_r8,1.2804e-03_r8/)
      kao(:, 4, 2, 3) = (/ &
     &3.8918e-05_r8,4.5420e-04_r8,6.8900e-04_r8,8.8273e-04_r8,1.0463e-03_r8,1.2043e-03_r8, &
     &1.3845e-03_r8,1.6322e-03_r8,1.5338e-03_r8/)
      kao(:, 5, 2, 3) = (/ &
     &4.1070e-05_r8,5.1139e-04_r8,7.8412e-04_r8,1.0082e-03_r8,1.2070e-03_r8,1.4003e-03_r8, &
     &1.6106e-03_r8,1.9566e-03_r8,1.8338e-03_r8/)
      kao(:, 1, 3, 3) = (/ &
     &5.7419e-05_r8,3.4417e-04_r8,4.7657e-04_r8,5.8011e-04_r8,6.5776e-04_r8,7.1017e-04_r8, &
     &7.4352e-04_r8,7.5165e-04_r8,7.1905e-04_r8/)
      kao(:, 2, 3, 3) = (/ &
     &6.1098e-05_r8,3.8894e-04_r8,5.5050e-04_r8,6.7283e-04_r8,7.6814e-04_r8,8.3562e-04_r8, &
     &8.7563e-04_r8,9.0812e-04_r8,8.7884e-04_r8/)
      kao(:, 3, 3, 3) = (/ &
     &6.4950e-05_r8,4.3994e-04_r8,6.3159e-04_r8,7.7584e-04_r8,8.9433e-04_r8,9.7562e-04_r8, &
     &1.0278e-03_r8,1.0860e-03_r8,1.0655e-03_r8/)
      kao(:, 4, 3, 3) = (/ &
     &6.9137e-05_r8,4.9606e-04_r8,7.1905e-04_r8,8.8979e-04_r8,1.0295e-03_r8,1.1315e-03_r8, &
     &1.2033e-03_r8,1.2952e-03_r8,1.2839e-03_r8/)
      kao(:, 5, 3, 3) = (/ &
     &7.3375e-05_r8,5.5536e-04_r8,8.1436e-04_r8,1.0155e-03_r8,1.1795e-03_r8,1.3051e-03_r8, &
     &1.4046e-03_r8,1.5168e-03_r8,1.5296e-03_r8/)
      kao(:, 1, 4, 3) = (/ &
     &1.0086e-04_r8,4.2454e-04_r8,5.2985e-04_r8,6.0848e-04_r8,6.7121e-04_r8,7.0723e-04_r8, &
     &7.1237e-04_r8,6.8193e-04_r8,6.1640e-04_r8/)
      kao(:, 2, 4, 3) = (/ &
     &1.0794e-04_r8,4.6886e-04_r8,6.0099e-04_r8,7.0397e-04_r8,7.8290e-04_r8,8.2924e-04_r8, &
     &8.4042e-04_r8,8.0656e-04_r8,7.3923e-04_r8/)
      kao(:, 3, 4, 3) = (/ &
     &1.1564e-04_r8,5.1937e-04_r8,6.8316e-04_r8,8.0764e-04_r8,9.0488e-04_r8,9.5975e-04_r8, &
     &9.8680e-04_r8,9.5115e-04_r8,8.9690e-04_r8/)
      kao(:, 4, 4, 3) = (/ &
     &1.2339e-04_r8,5.7610e-04_r8,7.7301e-04_r8,9.2354e-04_r8,1.0350e-03_r8,1.1092e-03_r8, &
     &1.1493e-03_r8,1.1169e-03_r8,1.0760e-03_r8/)
      kao(:, 5, 4, 3) = (/ &
     &1.3105e-04_r8,6.3905e-04_r8,8.6996e-04_r8,1.0475e-03_r8,1.1809e-03_r8,1.2763e-03_r8, &
     &1.3289e-03_r8,1.3078e-03_r8,1.2869e-03_r8/)
      kao(:, 1, 5, 3) = (/ &
     &1.6100e-04_r8,5.0634e-04_r8,6.1668e-04_r8,6.6467e-04_r8,6.8745e-04_r8,6.9758e-04_r8, &
     &6.8538e-04_r8,6.2098e-04_r8,6.1721e-04_r8/)
      kao(:, 2, 5, 3) = (/ &
     &1.7365e-04_r8,5.5505e-04_r8,6.8253e-04_r8,7.5603e-04_r8,7.9631e-04_r8,8.1600e-04_r8, &
     &8.0888e-04_r8,7.3807e-04_r8,7.1431e-04_r8/)
      kao(:, 3, 5, 3) = (/ &
     &1.8648e-04_r8,6.0992e-04_r8,7.6141e-04_r8,8.5901e-04_r8,9.1428e-04_r8,9.4703e-04_r8, &
     &9.4315e-04_r8,8.7432e-04_r8,8.2918e-04_r8/)
      kao(:, 4, 5, 3) = (/ &
     &1.9988e-04_r8,6.7074e-04_r8,8.4873e-04_r8,9.7496e-04_r8,1.0437e-03_r8,1.0922e-03_r8, &
     &1.0916e-03_r8,1.0269e-03_r8,9.7489e-04_r8/)
      kao(:, 5, 5, 3) = (/ &
     &2.1403e-04_r8,7.3152e-04_r8,9.4776e-04_r8,1.0959e-03_r8,1.1876e-03_r8,1.2477e-03_r8, &
     &1.2592e-03_r8,1.1994e-03_r8,1.1556e-03_r8/)
      kao(:, 1, 6, 3) = (/ &
     &2.3782e-04_r8,5.8473e-04_r8,7.0057e-04_r8,7.3727e-04_r8,7.3866e-04_r8,7.0622e-04_r8, &
     &6.5578e-04_r8,5.7152e-04_r8,6.4834e-04_r8/)
      kao(:, 2, 6, 3) = (/ &
     &2.5744e-04_r8,6.5190e-04_r8,7.6744e-04_r8,8.2296e-04_r8,8.3569e-04_r8,8.1871e-04_r8, &
     &7.7021e-04_r8,6.8232e-04_r8,7.1639e-04_r8/)
      kao(:, 3, 6, 3) = (/ &
     &2.7664e-04_r8,7.1488e-04_r8,8.5237e-04_r8,9.1762e-04_r8,9.4622e-04_r8,9.4392e-04_r8, &
     &8.9795e-04_r8,8.0363e-04_r8,8.0674e-04_r8/)
      kao(:, 4, 6, 3) = (/ &
     &2.9757e-04_r8,7.7689e-04_r8,9.3669e-04_r8,1.0212e-03_r8,1.0750e-03_r8,1.0793e-03_r8, &
     &1.0394e-03_r8,9.3920e-04_r8,9.2478e-04_r8/)
      kao(:, 5, 6, 3) = (/ &
     &3.2013e-04_r8,8.4833e-04_r8,1.0249e-03_r8,1.1443e-03_r8,1.2150e-03_r8,1.2313e-03_r8, &
     &1.1962e-03_r8,1.0926e-03_r8,1.0558e-03_r8/)
      kao(:, 1, 7, 3) = (/ &
     &3.7226e-04_r8,7.2122e-04_r8,8.2273e-04_r8,8.7424e-04_r8,8.4905e-04_r8,7.9504e-04_r8, &
     &6.8600e-04_r8,5.4748e-04_r8,6.4757e-04_r8/)
      kao(:, 2, 7, 3) = (/ &
     &4.0471e-04_r8,8.0580e-04_r8,9.2241e-04_r8,9.6290e-04_r8,9.4856e-04_r8,8.9436e-04_r8, &
     &7.9088e-04_r8,6.5024e-04_r8,7.6906e-04_r8/)
      kao(:, 3, 7, 3) = (/ &
     &4.3485e-04_r8,8.8728e-04_r8,1.0201e-03_r8,1.0664e-03_r8,1.0598e-03_r8,1.0046e-03_r8, &
     &9.1434e-04_r8,7.6471e-04_r8,8.8345e-04_r8/)
      kao(:, 4, 7, 3) = (/ &
     &4.6779e-04_r8,9.6940e-04_r8,1.1214e-03_r8,1.1802e-03_r8,1.1771e-03_r8,1.1317e-03_r8, &
     &1.0506e-03_r8,8.9487e-04_r8,9.7870e-04_r8/)
      kao(:, 5, 7, 3) = (/ &
     &5.0564e-04_r8,1.0493e-03_r8,1.2285e-03_r8,1.2989e-03_r8,1.3103e-03_r8,1.2822e-03_r8, &
     &1.2004e-03_r8,1.0399e-03_r8,1.0827e-03_r8/)
      kao(:, 1, 8, 3) = (/ &
     &6.8834e-04_r8,1.0497e-03_r8,1.1354e-03_r8,1.1403e-03_r8,1.1091e-03_r8,1.0282e-03_r8, &
     &8.6922e-04_r8,6.2179e-04_r8,6.4394e-04_r8/)
      kao(:, 2, 8, 3) = (/ &
     &7.5262e-04_r8,1.1719e-03_r8,1.2711e-03_r8,1.2847e-03_r8,1.2498e-03_r8,1.1356e-03_r8, &
     &9.7177e-04_r8,7.1700e-04_r8,7.5449e-04_r8/)
      kao(:, 3, 8, 3) = (/ &
     &8.1196e-04_r8,1.2925e-03_r8,1.4075e-03_r8,1.4221e-03_r8,1.3886e-03_r8,1.2652e-03_r8, &
     &1.0898e-03_r8,8.2946e-04_r8,8.8164e-04_r8/)
      kao(:, 4, 8, 3) = (/ &
     &8.7357e-04_r8,1.4119e-03_r8,1.5462e-03_r8,1.5662e-03_r8,1.5234e-03_r8,1.4066e-03_r8, &
     &1.2187e-03_r8,9.5583e-04_r8,1.0263e-03_r8/)
      kao(:, 5, 8, 3) = (/ &
     &9.4776e-04_r8,1.5351e-03_r8,1.6779e-03_r8,1.7191e-03_r8,1.6760e-03_r8,1.5541e-03_r8, &
     &1.3711e-03_r8,1.0942e-03_r8,1.1866e-03_r8/)
      kao(:, 1, 9, 3) = (/ &
     &2.4030e-03_r8,2.8116e-03_r8,2.7490e-03_r8,2.5782e-03_r8,2.3739e-03_r8,2.0451e-03_r8, &
     &1.6352e-03_r8,1.1525e-03_r8,7.8397e-04_r8/)
      kao(:, 2, 9, 3) = (/ &
     &2.6406e-03_r8,3.0780e-03_r8,3.0311e-03_r8,2.8880e-03_r8,2.6562e-03_r8,2.3012e-03_r8, &
     &1.8579e-03_r8,1.2942e-03_r8,9.5305e-04_r8/)
      kao(:, 3, 9, 3) = (/ &
     &2.8588e-03_r8,3.3826e-03_r8,3.3331e-03_r8,3.2003e-03_r8,2.9491e-03_r8,2.5645e-03_r8, &
     &2.0822e-03_r8,1.4320e-03_r8,1.1371e-03_r8/)
      kao(:, 4, 9, 3) = (/ &
     &3.0751e-03_r8,3.6837e-03_r8,3.6521e-03_r8,3.5172e-03_r8,3.2330e-03_r8,2.8266e-03_r8, &
     &2.3022e-03_r8,1.5958e-03_r8,1.3270e-03_r8/)
      kao(:, 5, 9, 3) = (/ &
     &3.3401e-03_r8,4.0139e-03_r8,3.9712e-03_r8,3.8387e-03_r8,3.5273e-03_r8,3.0908e-03_r8, &
     &2.5332e-03_r8,1.7734e-03_r8,1.5421e-03_r8/)
      kao(:, 1,10, 3) = (/ &
     &9.4661e-03_r8,9.3672e-03_r8,8.6815e-03_r8,7.7670e-03_r8,6.6533e-03_r8,5.4267e-03_r8, &
     &4.0804e-03_r8,2.5558e-03_r8,1.0683e-03_r8/)
      kao(:, 2,10, 3) = (/ &
     &1.0403e-02_r8,1.0310e-02_r8,9.5215e-03_r8,8.5122e-03_r8,7.3124e-03_r8,5.9813e-03_r8, &
     &4.5509e-03_r8,2.8739e-03_r8,1.2946e-03_r8/)
      kao(:, 3,10, 3) = (/ &
     &1.1289e-02_r8,1.1218e-02_r8,1.0349e-02_r8,9.3127e-03_r8,8.0182e-03_r8,6.6138e-03_r8, &
     &5.0551e-03_r8,3.2072e-03_r8,1.5622e-03_r8/)
      kao(:, 4,10, 3) = (/ &
     &1.2130e-02_r8,1.2221e-02_r8,1.1320e-02_r8,1.0189e-02_r8,8.7979e-03_r8,7.2832e-03_r8, &
     &5.5873e-03_r8,3.5427e-03_r8,1.8389e-03_r8/)
      kao(:, 5,10, 3) = (/ &
     &1.3100e-02_r8,1.3300e-02_r8,1.2340e-02_r8,1.1131e-02_r8,9.6189e-03_r8,7.9428e-03_r8, &
     &6.1291e-03_r8,3.8793e-03_r8,2.1440e-03_r8/)
      kao(:, 1,11, 3) = (/ &
     &1.3487e-02_r8,1.2984e-02_r8,1.1782e-02_r8,1.0398e-02_r8,8.8336e-03_r8,7.1334e-03_r8, &
     &5.2262e-03_r8,3.1590e-03_r8,1.1845e-03_r8/)
      kao(:, 2,11, 3) = (/ &
     &1.4804e-02_r8,1.4185e-02_r8,1.2823e-02_r8,1.1346e-02_r8,9.6530e-03_r8,7.7631e-03_r8, &
     &5.7673e-03_r8,3.5383e-03_r8,1.4275e-03_r8/)
      kao(:, 3,11, 3) = (/ &
     &1.5980e-02_r8,1.5367e-02_r8,1.3971e-02_r8,1.2366e-02_r8,1.0542e-02_r8,8.5565e-03_r8, &
     &6.3780e-03_r8,3.9351e-03_r8,1.7235e-03_r8/)
      kao(:, 4,11, 3) = (/ &
     &1.7219e-02_r8,1.6745e-02_r8,1.5253e-02_r8,1.3475e-02_r8,1.1557e-02_r8,9.4243e-03_r8, &
     &6.9880e-03_r8,4.3338e-03_r8,2.0121e-03_r8/)
      kao(:, 5,11, 3) = (/ &
     &1.8659e-02_r8,1.8178e-02_r8,1.6582e-02_r8,1.4739e-02_r8,1.2667e-02_r8,1.0254e-02_r8, &
     &7.6524e-03_r8,4.7481e-03_r8,2.3669e-03_r8/)
      kao(:, 1,12, 3) = (/ &
     &1.4430e-02_r8,1.3711e-02_r8,1.2344e-02_r8,1.0793e-02_r8,9.1312e-03_r8,7.2788e-03_r8, &
     &5.2885e-03_r8,3.1556e-03_r8,1.1392e-03_r8/)
      kao(:, 2,12, 3) = (/ &
     &1.5757e-02_r8,1.4929e-02_r8,1.3431e-02_r8,1.1729e-02_r8,9.9240e-03_r8,7.9738e-03_r8, &
     &5.8467e-03_r8,3.5123e-03_r8,1.3911e-03_r8/)
      kao(:, 3,12, 3) = (/ &
     &1.6948e-02_r8,1.6169e-02_r8,1.4634e-02_r8,1.2830e-02_r8,1.0856e-02_r8,8.7512e-03_r8, &
     &6.4418e-03_r8,3.8765e-03_r8,1.6585e-03_r8/)
      kao(:, 4,12, 3) = (/ &
     &1.8340e-02_r8,1.7651e-02_r8,1.6013e-02_r8,1.4019e-02_r8,1.1962e-02_r8,9.6662e-03_r8, &
     &7.0623e-03_r8,4.2621e-03_r8,1.9806e-03_r8/)
      kao(:, 5,12, 3) = (/ &
     &1.9917e-02_r8,1.9194e-02_r8,1.7450e-02_r8,1.5375e-02_r8,1.3136e-02_r8,1.0559e-02_r8, &
     &7.7061e-03_r8,4.6735e-03_r8,2.2886e-03_r8/)
      kao(:, 1,13, 3) = (/ &
     &1.2378e-02_r8,1.1740e-02_r8,1.0520e-02_r8,9.1794e-03_r8,7.7313e-03_r8,6.1547e-03_r8, &
     &4.4837e-03_r8,2.6655e-03_r8,9.8041e-04_r8/)
      kao(:, 2,13, 3) = (/ &
     &1.3400e-02_r8,1.2704e-02_r8,1.1442e-02_r8,9.9607e-03_r8,8.4166e-03_r8,6.7824e-03_r8, &
     &4.9464e-03_r8,2.9635e-03_r8,1.2027e-03_r8/)
      kao(:, 3,13, 3) = (/ &
     &1.4376e-02_r8,1.3828e-02_r8,1.2497e-02_r8,1.0944e-02_r8,9.2894e-03_r8,7.4859e-03_r8, &
     &5.4627e-03_r8,3.2639e-03_r8,1.4455e-03_r8/)
      kao(:, 4,13, 3) = (/ &
     &1.5663e-02_r8,1.5087e-02_r8,1.3675e-02_r8,1.2023e-02_r8,1.0248e-02_r8,8.2522e-03_r8, &
     &5.9994e-03_r8,3.5980e-03_r8,1.7132e-03_r8/)
      kao(:, 5,13, 3) = (/ &
     &1.7084e-02_r8,1.6538e-02_r8,1.5027e-02_r8,1.3180e-02_r8,1.1220e-02_r8,9.0513e-03_r8, &
     &6.5567e-03_r8,3.9396e-03_r8,2.0154e-03_r8/)
      kao(:, 1, 1, 4) = (/ &
     &4.5432e-05_r8,6.4085e-04_r8,1.0470e-03_r8,1.4404e-03_r8,1.8333e-03_r8,2.2857e-03_r8, &
     &2.8540e-03_r8,3.7474e-03_r8,3.3078e-03_r8/)
      kao(:, 2, 1, 4) = (/ &
     &4.6775e-05_r8,7.3260e-04_r8,1.2196e-03_r8,1.6906e-03_r8,2.1700e-03_r8,2.7279e-03_r8, &
     &3.3928e-03_r8,4.5435e-03_r8,4.0031e-03_r8/)
      kao(:, 3, 1, 4) = (/ &
     &4.7907e-05_r8,8.4030e-04_r8,1.4168e-03_r8,1.9771e-03_r8,2.5623e-03_r8,3.2199e-03_r8, &
     &4.0380e-03_r8,5.3656e-03_r8,4.7474e-03_r8/)
      kao(:, 4, 1, 4) = (/ &
     &4.8733e-05_r8,9.6171e-04_r8,1.6416e-03_r8,2.3126e-03_r8,3.0275e-03_r8,3.7946e-03_r8, &
     &4.7571e-03_r8,6.3684e-03_r8,5.6396e-03_r8/)
      kao(:, 5, 1, 4) = (/ &
     &4.9568e-05_r8,1.0960e-03_r8,1.8926e-03_r8,2.6893e-03_r8,3.5365e-03_r8,4.4677e-03_r8, &
     &5.5986e-03_r8,7.4848e-03_r8,6.6760e-03_r8/)
      kao(:, 1, 2, 4) = (/ &
     &5.9644e-05_r8,6.5165e-04_r8,9.7095e-04_r8,1.2735e-03_r8,1.5693e-03_r8,1.8723e-03_r8, &
     &2.2435e-03_r8,2.8303e-03_r8,2.5518e-03_r8/)
      kao(:, 2, 2, 4) = (/ &
     &6.1550e-05_r8,7.3433e-04_r8,1.1155e-03_r8,1.4862e-03_r8,1.8480e-03_r8,2.2144e-03_r8, &
     &2.6782e-03_r8,3.3851e-03_r8,3.1028e-03_r8/)
      kao(:, 3, 2, 4) = (/ &
     &6.3424e-05_r8,8.2814e-04_r8,1.2862e-03_r8,1.7299e-03_r8,2.1667e-03_r8,2.6220e-03_r8, &
     &3.1654e-03_r8,4.0290e-03_r8,3.7219e-03_r8/)
      kao(:, 4, 2, 4) = (/ &
     &6.4618e-05_r8,9.2770e-04_r8,1.4812e-03_r8,2.0000e-03_r8,2.5281e-03_r8,3.0889e-03_r8, &
     &3.7301e-03_r8,4.7467e-03_r8,4.4551e-03_r8/)
      kao(:, 5, 2, 4) = (/ &
     &6.6495e-05_r8,1.0413e-03_r8,1.6912e-03_r8,2.3096e-03_r8,2.9324e-03_r8,3.6063e-03_r8, &
     &4.3915e-03_r8,5.5831e-03_r8,5.2779e-03_r8/)
      kao(:, 1, 3, 4) = (/ &
     &1.0462e-04_r8,7.2939e-04_r8,1.0510e-03_r8,1.2708e-03_r8,1.4590e-03_r8,1.6268e-03_r8, &
     &1.8071e-03_r8,2.0571e-03_r8,1.9983e-03_r8/)
      kao(:, 2, 3, 4) = (/ &
     &1.0853e-04_r8,8.1591e-04_r8,1.1915e-03_r8,1.4605e-03_r8,1.6878e-03_r8,1.9079e-03_r8, &
     &2.1403e-03_r8,2.4652e-03_r8,2.3859e-03_r8/)
      kao(:, 3, 3, 4) = (/ &
     &1.1161e-04_r8,9.0807e-04_r8,1.3452e-03_r8,1.6696e-03_r8,1.9436e-03_r8,2.2298e-03_r8, &
     &2.5245e-03_r8,2.9256e-03_r8,2.8236e-03_r8/)
      kao(:, 4, 3, 4) = (/ &
     &1.1463e-04_r8,1.0096e-03_r8,1.5126e-03_r8,1.9029e-03_r8,2.2460e-03_r8,2.5957e-03_r8, &
     &2.9637e-03_r8,3.4539e-03_r8,3.3286e-03_r8/)
      kao(:, 5, 3, 4) = (/ &
     &1.1771e-04_r8,1.1227e-03_r8,1.6998e-03_r8,2.1624e-03_r8,2.5867e-03_r8,3.0031e-03_r8, &
     &3.4507e-03_r8,4.0691e-03_r8,3.9216e-03_r8/)
      kao(:, 1, 4, 4) = (/ &
     &1.8980e-04_r8,8.1690e-04_r8,1.1496e-03_r8,1.3743e-03_r8,1.5174e-03_r8,1.5997e-03_r8, &
     &1.6364e-03_r8,1.6486e-03_r8,1.6867e-03_r8/)
      kao(:, 2, 4, 4) = (/ &
     &1.9681e-04_r8,9.1682e-04_r8,1.2947e-03_r8,1.5538e-03_r8,1.7351e-03_r8,1.8526e-03_r8, &
     &1.9065e-03_r8,1.9583e-03_r8,2.0215e-03_r8/)
      kao(:, 3, 4, 4) = (/ &
     &2.0208e-04_r8,1.0146e-03_r8,1.4514e-03_r8,1.7516e-03_r8,1.9841e-03_r8,2.1383e-03_r8, &
     &2.2138e-03_r8,2.3082e-03_r8,2.3998e-03_r8/)
      kao(:, 4, 4, 4) = (/ &
     &2.0762e-04_r8,1.1226e-03_r8,1.6211e-03_r8,1.9728e-03_r8,2.2623e-03_r8,2.4506e-03_r8, &
     &2.5563e-03_r8,2.7166e-03_r8,2.8343e-03_r8/)
      kao(:, 5, 4, 4) = (/ &
     &2.1385e-04_r8,1.2397e-03_r8,1.8026e-03_r8,2.2223e-03_r8,2.5659e-03_r8,2.7894e-03_r8, &
     &2.9545e-03_r8,3.1771e-03_r8,3.3076e-03_r8/)
      kao(:, 1, 5, 4) = (/ &
     &3.1379e-04_r8,9.3426e-04_r8,1.2166e-03_r8,1.4285e-03_r8,1.5654e-03_r8,1.6404e-03_r8, &
     &1.5965e-03_r8,1.4828e-03_r8,1.3604e-03_r8/)
      kao(:, 2, 5, 4) = (/ &
     &3.2699e-04_r8,1.0358e-03_r8,1.3783e-03_r8,1.6163e-03_r8,1.7786e-03_r8,1.8763e-03_r8, &
     &1.8530e-03_r8,1.7399e-03_r8,1.6555e-03_r8/)
      kao(:, 3, 5, 4) = (/ &
     &3.3749e-04_r8,1.1387e-03_r8,1.5374e-03_r8,1.8184e-03_r8,2.0178e-03_r8,2.1215e-03_r8, &
     &2.1453e-03_r8,2.0239e-03_r8,1.9794e-03_r8/)
      kao(:, 4, 5, 4) = (/ &
     &3.4807e-04_r8,1.2529e-03_r8,1.7131e-03_r8,2.0397e-03_r8,2.2808e-03_r8,2.4051e-03_r8, &
     &2.4718e-03_r8,2.3502e-03_r8,2.3300e-03_r8/)
      kao(:, 5, 5, 4) = (/ &
     &3.5954e-04_r8,1.3777e-03_r8,1.8982e-03_r8,2.2796e-03_r8,2.5586e-03_r8,2.7323e-03_r8, &
     &2.8236e-03_r8,2.7161e-03_r8,2.7237e-03_r8/)
      kao(:, 1, 6, 4) = (/ &
     &4.7800e-04_r8,1.0890e-03_r8,1.3133e-03_r8,1.4652e-03_r8,1.5696e-03_r8,1.6077e-03_r8, &
     &1.5816e-03_r8,1.3782e-03_r8,1.1543e-03_r8/)
      kao(:, 2, 6, 4) = (/ &
     &5.0135e-04_r8,1.1692e-03_r8,1.4789e-03_r8,1.6725e-03_r8,1.7871e-03_r8,1.8348e-03_r8, &
     &1.8106e-03_r8,1.6080e-03_r8,1.4185e-03_r8/)
      kao(:, 3, 6, 4) = (/ &
     &5.2250e-04_r8,1.2684e-03_r8,1.6447e-03_r8,1.8893e-03_r8,2.0173e-03_r8,2.0845e-03_r8, &
     &2.0641e-03_r8,1.8764e-03_r8,1.6970e-03_r8/)
      kao(:, 4, 6, 4) = (/ &
     &5.4010e-04_r8,1.3890e-03_r8,1.8350e-03_r8,2.1143e-03_r8,2.2731e-03_r8,2.3591e-03_r8, &
     &2.3476e-03_r8,2.1762e-03_r8,2.0061e-03_r8/)
      kao(:, 5, 6, 4) = (/ &
     &5.6086e-04_r8,1.5152e-03_r8,2.0323e-03_r8,2.3522e-03_r8,2.5434e-03_r8,2.6585e-03_r8, &
     &2.6646e-03_r8,2.5043e-03_r8,2.3580e-03_r8/)
      kao(:, 1, 7, 4) = (/ &
     &7.6472e-04_r8,1.4103e-03_r8,1.5811e-03_r8,1.6521e-03_r8,1.6700e-03_r8,1.6355e-03_r8, &
     &1.5716e-03_r8,1.3655e-03_r8,1.1953e-03_r8/)
      kao(:, 2, 7, 4) = (/ &
     &8.0405e-04_r8,1.4820e-03_r8,1.7182e-03_r8,1.8432e-03_r8,1.9040e-03_r8,1.8839e-03_r8, &
     &1.8004e-03_r8,1.5836e-03_r8,1.3245e-03_r8/)
      kao(:, 3, 7, 4) = (/ &
     &8.3976e-04_r8,1.5925e-03_r8,1.8706e-03_r8,2.0547e-03_r8,2.1511e-03_r8,2.1580e-03_r8, &
     &2.0497e-03_r8,1.8151e-03_r8,1.5136e-03_r8/)
      kao(:, 4, 7, 4) = (/ &
     &8.7606e-04_r8,1.7044e-03_r8,2.0552e-03_r8,2.2845e-03_r8,2.4212e-03_r8,2.4433e-03_r8, &
     &2.3312e-03_r8,2.0671e-03_r8,1.7685e-03_r8/)
      kao(:, 5, 7, 4) = (/ &
     &9.1065e-04_r8,1.8368e-03_r8,2.2563e-03_r8,2.5472e-03_r8,2.7054e-03_r8,2.7384e-03_r8, &
     &2.6284e-03_r8,2.3513e-03_r8,2.0612e-03_r8/)
      kao(:, 1, 8, 4) = (/ &
     &1.4362e-03_r8,2.1402e-03_r8,2.2733e-03_r8,2.2579e-03_r8,2.1547e-03_r8,1.9686e-03_r8, &
     &1.7196e-03_r8,1.4177e-03_r8,1.4603e-03_r8/)
      kao(:, 2, 8, 4) = (/ &
     &1.5196e-03_r8,2.2635e-03_r8,2.4111e-03_r8,2.4495e-03_r8,2.3642e-03_r8,2.2258e-03_r8, &
     &1.9891e-03_r8,1.6444e-03_r8,1.7173e-03_r8/)
      kao(:, 3, 8, 4) = (/ &
     &1.5863e-03_r8,2.3882e-03_r8,2.5869e-03_r8,2.6588e-03_r8,2.5952e-03_r8,2.5025e-03_r8, &
     &2.2780e-03_r8,1.8819e-03_r8,1.8908e-03_r8/)
      kao(:, 4, 8, 4) = (/ &
     &1.6588e-03_r8,2.5177e-03_r8,2.7792e-03_r8,2.8954e-03_r8,2.8908e-03_r8,2.7990e-03_r8, &
     &2.5915e-03_r8,2.1558e-03_r8,2.0333e-03_r8/)
      kao(:, 5, 8, 4) = (/ &
     &1.7367e-03_r8,2.6935e-03_r8,3.0017e-03_r8,3.1619e-03_r8,3.2065e-03_r8,3.1297e-03_r8, &
     &2.9147e-03_r8,2.4525e-03_r8,2.1765e-03_r8/)
      kao(:, 1, 9, 4) = (/ &
     &5.1377e-03_r8,5.6879e-03_r8,5.6413e-03_r8,5.3776e-03_r8,4.8224e-03_r8,4.1689e-03_r8, &
     &3.3325e-03_r8,2.2481e-03_r8,2.0122e-03_r8/)
      kao(:, 2, 9, 4) = (/ &
     &5.4511e-03_r8,6.1548e-03_r8,6.1332e-03_r8,5.7185e-03_r8,5.1593e-03_r8,4.4551e-03_r8, &
     &3.6302e-03_r8,2.5234e-03_r8,2.3673e-03_r8/)
      kao(:, 3, 9, 4) = (/ &
     &5.7014e-03_r8,6.5729e-03_r8,6.5250e-03_r8,6.0830e-03_r8,5.4507e-03_r8,4.7941e-03_r8, &
     &3.9451e-03_r8,2.8561e-03_r8,2.7249e-03_r8/)
      kao(:, 4, 9, 4) = (/ &
     &5.9876e-03_r8,6.9491e-03_r8,6.9266e-03_r8,6.3994e-03_r8,5.8665e-03_r8,5.2094e-03_r8, &
     &4.3177e-03_r8,3.2100e-03_r8,3.0655e-03_r8/)
      kao(:, 5, 9, 4) = (/ &
     &6.2578e-03_r8,7.3161e-03_r8,7.3395e-03_r8,6.8572e-03_r8,6.3066e-03_r8,5.6391e-03_r8, &
     &4.7410e-03_r8,3.6035e-03_r8,3.3864e-03_r8/)
      kao(:, 1,10, 4) = (/ &
     &2.0796e-02_r8,2.0019e-02_r8,1.8165e-02_r8,1.6068e-02_r8,1.3873e-02_r8,1.1404e-02_r8, &
     &8.6779e-03_r8,5.2784e-03_r8,2.8413e-03_r8/)
      kao(:, 2,10, 4) = (/ &
     &2.2188e-02_r8,2.1487e-02_r8,1.9617e-02_r8,1.7448e-02_r8,1.5124e-02_r8,1.2499e-02_r8, &
     &9.2630e-03_r8,5.6664e-03_r8,3.3963e-03_r8/)
      kao(:, 3,10, 4) = (/ &
     &2.3219e-02_r8,2.2843e-02_r8,2.1086e-02_r8,1.8777e-02_r8,1.6130e-02_r8,1.3209e-02_r8, &
     &9.9059e-03_r8,6.0802e-03_r8,4.0019e-03_r8/)
      kao(:, 4,10, 4) = (/ &
     &2.4435e-02_r8,2.4082e-02_r8,2.2303e-02_r8,1.9851e-02_r8,1.7023e-02_r8,1.4121e-02_r8, &
     &1.0410e-02_r8,6.5843e-03_r8,4.6477e-03_r8/)
      kao(:, 5,10, 4) = (/ &
     &2.5609e-02_r8,2.5343e-02_r8,2.3560e-02_r8,2.0930e-02_r8,1.8042e-02_r8,1.4937e-02_r8, &
     &1.1163e-02_r8,7.1400e-03_r8,5.2598e-03_r8/)
      kao(:, 1,11, 4) = (/ &
     &3.0218e-02_r8,2.8464e-02_r8,2.5566e-02_r8,2.2189e-02_r8,1.8763e-02_r8,1.5165e-02_r8, &
     &1.1286e-02_r8,6.7271e-03_r8,3.0443e-03_r8/)
      kao(:, 2,11, 4) = (/ &
     &3.2017e-02_r8,3.0288e-02_r8,2.7351e-02_r8,2.3960e-02_r8,2.0417e-02_r8,1.6571e-02_r8, &
     &1.2201e-02_r8,7.2159e-03_r8,3.6072e-03_r8/)
      kao(:, 3,11, 4) = (/ &
     &3.3713e-02_r8,3.2141e-02_r8,2.9172e-02_r8,2.5698e-02_r8,2.1768e-02_r8,1.7546e-02_r8, &
     &1.2989e-02_r8,7.6734e-03_r8,4.2021e-03_r8/)
      kao(:, 4,11, 4) = (/ &
     &3.5523e-02_r8,3.3941e-02_r8,3.0802e-02_r8,2.7264e-02_r8,2.3091e-02_r8,1.8512e-02_r8, &
     &1.3848e-02_r8,8.2207e-03_r8,4.9261e-03_r8/)
      kao(:, 5,11, 4) = (/ &
     &3.7048e-02_r8,3.5659e-02_r8,3.2500e-02_r8,2.8766e-02_r8,2.4380e-02_r8,1.9724e-02_r8, &
     &1.4735e-02_r8,8.8773e-03_r8,5.6292e-03_r8/)
      kao(:, 1,12, 4) = (/ &
     &3.2170e-02_r8,2.9965e-02_r8,2.6774e-02_r8,2.3265e-02_r8,1.9604e-02_r8,1.5767e-02_r8, &
     &1.1665e-02_r8,6.8628e-03_r8,2.9693e-03_r8/)
      kao(:, 2,12, 4) = (/ &
     &3.3877e-02_r8,3.1857e-02_r8,2.8686e-02_r8,2.5070e-02_r8,2.1306e-02_r8,1.7043e-02_r8, &
     &1.2460e-02_r8,7.3567e-03_r8,3.5157e-03_r8/)
      kao(:, 3,12, 4) = (/ &
     &3.5821e-02_r8,3.3840e-02_r8,3.0497e-02_r8,2.6646e-02_r8,2.2619e-02_r8,1.8108e-02_r8, &
     &1.3276e-02_r8,7.8561e-03_r8,4.1559e-03_r8/)
      kao(:, 4,12, 4) = (/ &
     &3.7503e-02_r8,3.5506e-02_r8,3.2126e-02_r8,2.8288e-02_r8,2.3902e-02_r8,1.9181e-02_r8, &
     &1.4142e-02_r8,8.3990e-03_r8,4.8088e-03_r8/)
      kao(:, 5,12, 4) = (/ &
     &3.9218e-02_r8,3.7289e-02_r8,3.3764e-02_r8,2.9747e-02_r8,2.5253e-02_r8,2.0345e-02_r8, &
     &1.5175e-02_r8,9.0569e-03_r8,5.5254e-03_r8/)
      kao(:, 1,13, 4) = (/ &
     &2.7021e-02_r8,2.5240e-02_r8,2.2638e-02_r8,1.9764e-02_r8,1.6669e-02_r8,1.3389e-02_r8, &
     &9.8031e-03_r8,5.7609e-03_r8,2.5391e-03_r8/)
      kao(:, 2,13, 4) = (/ &
     &2.8550e-02_r8,2.6888e-02_r8,2.4164e-02_r8,2.1146e-02_r8,1.7859e-02_r8,1.4211e-02_r8, &
     &1.0456e-02_r8,6.1648e-03_r8,3.0359e-03_r8/)
      kao(:, 3,13, 4) = (/ &
     &3.0206e-02_r8,2.8336e-02_r8,2.5560e-02_r8,2.2362e-02_r8,1.8953e-02_r8,1.5151e-02_r8, &
     &1.1086e-02_r8,6.5998e-03_r8,3.5704e-03_r8/)
      kao(:, 4,13, 4) = (/ &
     &3.1495e-02_r8,2.9878e-02_r8,2.6989e-02_r8,2.3626e-02_r8,1.9993e-02_r8,1.6052e-02_r8, &
     &1.1891e-02_r8,7.0977e-03_r8,4.1349e-03_r8/)
      kao(:, 5,13, 4) = (/ &
     &3.2969e-02_r8,3.1259e-02_r8,2.8282e-02_r8,2.5005e-02_r8,2.1232e-02_r8,1.7061e-02_r8, &
     &1.2808e-02_r8,7.6578e-03_r8,4.7180e-03_r8/)
      kao(:, 1, 1, 5) = (/ &
     &7.7208e-05_r8,1.2983e-03_r8,2.1990e-03_r8,3.0698e-03_r8,3.9335e-03_r8,4.8939e-03_r8, &
     &6.0507e-03_r8,7.9864e-03_r8,7.3950e-03_r8/)
      kao(:, 2, 1, 5) = (/ &
     &7.7960e-05_r8,1.4953e-03_r8,2.5372e-03_r8,3.5852e-03_r8,4.6877e-03_r8,5.9141e-03_r8, &
     &7.4453e-03_r8,9.6664e-03_r8,8.9362e-03_r8/)
      kao(:, 3, 1, 5) = (/ &
     &7.8616e-05_r8,1.7027e-03_r8,2.9428e-03_r8,4.1895e-03_r8,5.5241e-03_r8,7.0220e-03_r8, &
     &8.8894e-03_r8,1.1837e-02_r8,1.0698e-02_r8/)
      kao(:, 4, 1, 5) = (/ &
     &7.9284e-05_r8,1.9233e-03_r8,3.3889e-03_r8,4.8861e-03_r8,6.4864e-03_r8,8.2886e-03_r8, &
     &1.0489e-02_r8,1.4031e-02_r8,1.2687e-02_r8/)
      kao(:, 5, 1, 5) = (/ &
     &8.0311e-05_r8,2.1623e-03_r8,3.8730e-03_r8,5.6513e-03_r8,7.5603e-03_r8,9.7064e-03_r8, &
     &1.2306e-02_r8,1.6419e-02_r8,1.4857e-02_r8/)
      kao(:, 1, 2, 5) = (/ &
     &1.0510e-04_r8,1.2010e-03_r8,1.9708e-03_r8,2.6863e-03_r8,3.3801e-03_r8,4.0401e-03_r8, &
     &4.8065e-03_r8,5.9839e-03_r8,5.8720e-03_r8/)
      kao(:, 2, 2, 5) = (/ &
     &1.0618e-04_r8,1.3719e-03_r8,2.2892e-03_r8,3.1040e-03_r8,3.9264e-03_r8,4.7961e-03_r8, &
     &5.8356e-03_r8,7.3351e-03_r8,7.0925e-03_r8/)
      kao(:, 3, 2, 5) = (/ &
     &1.0689e-04_r8,1.5661e-03_r8,2.6266e-03_r8,3.5943e-03_r8,4.5681e-03_r8,5.6180e-03_r8, &
     &6.8759e-03_r8,8.8640e-03_r8,8.4509e-03_r8/)
      kao(:, 4, 2, 5) = (/ &
     &1.0861e-04_r8,1.7752e-03_r8,2.9853e-03_r8,4.1453e-03_r8,5.3192e-03_r8,6.5973e-03_r8, &
     &8.1274e-03_r8,1.0456e-02_r8,1.0031e-02_r8/)
      kao(:, 5, 2, 5) = (/ &
     &1.1004e-04_r8,1.9945e-03_r8,3.3831e-03_r8,4.7368e-03_r8,6.1454e-03_r8,7.6846e-03_r8, &
     &9.5320e-03_r8,1.2312e-02_r8,1.1757e-02_r8/)
      kao(:, 1, 3, 5) = (/ &
     &1.9166e-04_r8,1.3172e-03_r8,1.9278e-03_r8,2.4677e-03_r8,2.9707e-03_r8,3.4895e-03_r8, &
     &3.9440e-03_r8,4.4484e-03_r8,4.3497e-03_r8/)
      kao(:, 2, 3, 5) = (/ &
     &1.9336e-04_r8,1.4888e-03_r8,2.1997e-03_r8,2.8500e-03_r8,3.4656e-03_r8,4.0405e-03_r8, &
     &4.6494e-03_r8,5.3886e-03_r8,5.2876e-03_r8/)
      kao(:, 3, 3, 5) = (/ &
     &1.9552e-04_r8,1.6719e-03_r8,2.4978e-03_r8,3.2794e-03_r8,4.0171e-03_r8,4.6883e-03_r8, &
     &5.3810e-03_r8,6.3663e-03_r8,6.3594e-03_r8/)
      kao(:, 4, 3, 5) = (/ &
     &1.9793e-04_r8,1.8618e-03_r8,2.8193e-03_r8,3.7421e-03_r8,4.6002e-03_r8,5.4246e-03_r8, &
     &6.2790e-03_r8,7.4939e-03_r8,7.6260e-03_r8/)
      kao(:, 5, 3, 5) = (/ &
     &2.0202e-04_r8,2.0622e-03_r8,3.1772e-03_r8,4.2408e-03_r8,5.2345e-03_r8,6.2239e-03_r8, &
     &7.2922e-03_r8,8.8196e-03_r8,9.0035e-03_r8/)
      kao(:, 1, 4, 5) = (/ &
     &3.5080e-04_r8,1.5106e-03_r8,2.1048e-03_r8,2.5530e-03_r8,2.8923e-03_r8,3.1426e-03_r8, &
     &3.3832e-03_r8,3.6360e-03_r8,3.6099e-03_r8/)
      kao(:, 2, 4, 5) = (/ &
     &3.5494e-04_r8,1.6898e-03_r8,2.3828e-03_r8,2.9160e-03_r8,3.3056e-03_r8,3.6304e-03_r8, &
     &3.9520e-03_r8,4.2994e-03_r8,4.2882e-03_r8/)
      kao(:, 3, 4, 5) = (/ &
     &3.5978e-04_r8,1.8836e-03_r8,2.6877e-03_r8,3.3008e-03_r8,3.7593e-03_r8,4.1815e-03_r8, &
     &4.6053e-03_r8,4.9917e-03_r8,5.0514e-03_r8/)
      kao(:, 4, 4, 5) = (/ &
     &3.6746e-04_r8,2.0763e-03_r8,3.0082e-03_r8,3.7203e-03_r8,4.2549e-03_r8,4.7934e-03_r8, &
     &5.3242e-03_r8,5.8169e-03_r8,5.8760e-03_r8/)
      kao(:, 5, 4, 5) = (/ &
     &3.7911e-04_r8,2.2831e-03_r8,3.3520e-03_r8,4.1619e-03_r8,4.7913e-03_r8,5.4605e-03_r8, &
     &6.1003e-03_r8,6.7476e-03_r8,6.8032e-03_r8/)
      kao(:, 1, 5, 5) = (/ &
     &5.8701e-04_r8,1.7294e-03_r8,2.3007e-03_r8,2.6940e-03_r8,2.9671e-03_r8,3.1134e-03_r8, &
     &3.1768e-03_r8,3.0490e-03_r8,3.1049e-03_r8/)
      kao(:, 2, 5, 5) = (/ &
     &5.9308e-04_r8,1.9111e-03_r8,2.5835e-03_r8,3.0407e-03_r8,3.3851e-03_r8,3.5845e-03_r8, &
     &3.6445e-03_r8,3.5746e-03_r8,3.6940e-03_r8/)
      kao(:, 3, 5, 5) = (/ &
     &6.0356e-04_r8,2.1186e-03_r8,2.8868e-03_r8,3.4242e-03_r8,3.8486e-03_r8,4.1112e-03_r8, &
     &4.1722e-03_r8,4.1940e-03_r8,4.3605e-03_r8/)
      kao(:, 4, 5, 5) = (/ &
     &6.1818e-04_r8,2.3278e-03_r8,3.1936e-03_r8,3.8321e-03_r8,4.3352e-03_r8,4.6666e-03_r8, &
     &4.7552e-03_r8,4.8779e-03_r8,5.1110e-03_r8/)
      kao(:, 5, 5, 5) = (/ &
     &6.3535e-04_r8,2.5512e-03_r8,3.5322e-03_r8,4.2882e-03_r8,4.8679e-03_r8,5.2358e-03_r8, &
     &5.3921e-03_r8,5.6199e-03_r8,5.9412e-03_r8/)
      kao(:, 1, 6, 5) = (/ &
     &9.2532e-04_r8,2.0015e-03_r8,2.5277e-03_r8,2.8421e-03_r8,3.0437e-03_r8,3.1018e-03_r8, &
     &3.0296e-03_r8,2.8221e-03_r8,2.6040e-03_r8/)
      kao(:, 2, 6, 5) = (/ &
     &9.2928e-04_r8,2.2000e-03_r8,2.8005e-03_r8,3.1777e-03_r8,3.4468e-03_r8,3.5577e-03_r8, &
     &3.5029e-03_r8,3.2686e-03_r8,3.0871e-03_r8/)
      kao(:, 3, 6, 5) = (/ &
     &9.4818e-04_r8,2.4342e-03_r8,3.0892e-03_r8,3.5513e-03_r8,3.8786e-03_r8,4.0485e-03_r8, &
     &4.0367e-03_r8,3.7564e-03_r8,3.6084e-03_r8/)
      kao(:, 4, 6, 5) = (/ &
     &9.7245e-04_r8,2.6688e-03_r8,3.4060e-03_r8,3.9527e-03_r8,4.3416e-03_r8,4.5754e-03_r8, &
     &4.6140e-03_r8,4.3161e-03_r8,4.2427e-03_r8/)
      kao(:, 5, 6, 5) = (/ &
     &9.9339e-04_r8,2.9158e-03_r8,3.7426e-03_r8,4.3630e-03_r8,4.8503e-03_r8,5.1436e-03_r8, &
     &5.2166e-03_r8,4.9082e-03_r8,4.9378e-03_r8/)
      kao(:, 1, 7, 5) = (/ &
     &1.5302e-03_r8,2.5414e-03_r8,2.9540e-03_r8,3.1974e-03_r8,3.3103e-03_r8,3.2792e-03_r8, &
     &3.0626e-03_r8,2.6477e-03_r8,2.2296e-03_r8/)
      kao(:, 2, 7, 5) = (/ &
     &1.5437e-03_r8,2.8069e-03_r8,3.2725e-03_r8,3.5730e-03_r8,3.6894e-03_r8,3.7000e-03_r8, &
     &3.5141e-03_r8,3.0866e-03_r8,2.7517e-03_r8/)
      kao(:, 3, 7, 5) = (/ &
     &1.5828e-03_r8,3.0663e-03_r8,3.6143e-03_r8,3.9451e-03_r8,4.1195e-03_r8,4.1576e-03_r8, &
     &4.0163e-03_r8,3.5822e-03_r8,3.3032e-03_r8/)
      kao(:, 4, 7, 5) = (/ &
     &1.6196e-03_r8,3.3257e-03_r8,3.9578e-03_r8,4.3834e-03_r8,4.5853e-03_r8,4.6606e-03_r8, &
     &4.5385e-03_r8,4.1261e-03_r8,3.9000e-03_r8/)
      kao(:, 5, 7, 5) = (/ &
     &1.6660e-03_r8,3.6179e-03_r8,4.3451e-03_r8,4.8226e-03_r8,5.0668e-03_r8,5.1930e-03_r8, &
     &5.1180e-03_r8,4.7030e-03_r8,4.5474e-03_r8/)
      kao(:, 1, 8, 5) = (/ &
     &2.9602e-03_r8,3.9304e-03_r8,4.1580e-03_r8,4.2228e-03_r8,4.1165e-03_r8,3.9147e-03_r8, &
     &3.5216e-03_r8,2.8265e-03_r8,2.2242e-03_r8/)
      kao(:, 2, 8, 5) = (/ &
     &2.9996e-03_r8,4.2668e-03_r8,4.6028e-03_r8,4.6806e-03_r8,4.6212e-03_r8,4.3859e-03_r8, &
     &3.9542e-03_r8,3.2447e-03_r8,2.5165e-03_r8/)
      kao(:, 3, 8, 5) = (/ &
     &3.0790e-03_r8,4.6440e-03_r8,5.0256e-03_r8,5.1447e-03_r8,5.1348e-03_r8,4.8892e-03_r8, &
     &4.4430e-03_r8,3.7287e-03_r8,2.9386e-03_r8/)
      kao(:, 4, 8, 5) = (/ &
     &3.1467e-03_r8,5.0515e-03_r8,5.4655e-03_r8,5.6295e-03_r8,5.6440e-03_r8,5.4532e-03_r8, &
     &4.9689e-03_r8,4.2347e-03_r8,3.5150e-03_r8/)
      kao(:, 5, 8, 5) = (/ &
     &3.2473e-03_r8,5.4319e-03_r8,5.9099e-03_r8,6.1513e-03_r8,6.2421e-03_r8,6.0606e-03_r8, &
     &5.5483e-03_r8,4.7752e-03_r8,4.1476e-03_r8/)
      kao(:, 1, 9, 5) = (/ &
     &1.0715e-02_r8,1.1382e-02_r8,1.0899e-02_r8,1.0007e-02_r8,9.0437e-03_r8,7.6976e-03_r8, &
     &6.2825e-03_r8,4.4971e-03_r8,3.7652e-03_r8/)
      kao(:, 2, 9, 5) = (/ &
     &1.0909e-02_r8,1.1862e-02_r8,1.1397e-02_r8,1.0777e-02_r8,9.8877e-03_r8,8.5937e-03_r8, &
     &7.0755e-03_r8,5.0938e-03_r8,4.2507e-03_r8/)
      kao(:, 3, 9, 5) = (/ &
     &1.1246e-02_r8,1.2418e-02_r8,1.2293e-02_r8,1.1701e-02_r8,1.0880e-02_r8,9.4889e-03_r8, &
     &7.8244e-03_r8,5.6718e-03_r8,4.5213e-03_r8/)
      kao(:, 4, 9, 5) = (/ &
     &1.1484e-02_r8,1.3245e-02_r8,1.3252e-02_r8,1.2816e-02_r8,1.1850e-02_r8,1.0328e-02_r8, &
     &8.6168e-03_r8,6.3257e-03_r8,4.7999e-03_r8/)
      kao(:, 5, 9, 5) = (/ &
     &1.1883e-02_r8,1.4169e-02_r8,1.4256e-02_r8,1.3856e-02_r8,1.2835e-02_r8,1.1196e-02_r8, &
     &9.4286e-03_r8,7.0084e-03_r8,5.1834e-03_r8/)
      kao(:, 1,10, 5) = (/ &
     &4.3348e-02_r8,4.0646e-02_r8,3.6539e-02_r8,3.2078e-02_r8,2.7151e-02_r8,2.1841e-02_r8, &
     &1.6185e-02_r8,9.9201e-03_r8,6.7193e-03_r8/)
      kao(:, 2,10, 5) = (/ &
     &4.4149e-02_r8,4.2066e-02_r8,3.8091e-02_r8,3.3609e-02_r8,2.8552e-02_r8,2.2983e-02_r8, &
     &1.7376e-02_r8,1.1009e-02_r8,7.5436e-03_r8/)
      kao(:, 3,10, 5) = (/ &
     &4.5674e-02_r8,4.3639e-02_r8,3.9624e-02_r8,3.4947e-02_r8,3.0188e-02_r8,2.4887e-02_r8, &
     &1.8903e-02_r8,1.2177e-02_r8,8.3556e-03_r8/)
      kao(:, 4,10, 5) = (/ &
     &4.6947e-02_r8,4.5302e-02_r8,4.1477e-02_r8,3.7249e-02_r8,3.2588e-02_r8,2.6746e-02_r8, &
     &2.0815e-02_r8,1.3320e-02_r8,9.0276e-03_r8/)
      kao(:, 5,10, 5) = (/ &
     &4.8633e-02_r8,4.7885e-02_r8,4.4096e-02_r8,3.9864e-02_r8,3.4957e-02_r8,2.9104e-02_r8, &
     &2.2653e-02_r8,1.4428e-02_r8,9.7333e-03_r8/)
      kao(:, 1,11, 5) = (/ &
     &6.1692e-02_r8,5.6780e-02_r8,5.0232e-02_r8,4.3693e-02_r8,3.6664e-02_r8,2.9101e-02_r8, &
     &2.1139e-02_r8,1.2500e-02_r8,7.3091e-03_r8/)
      kao(:, 2,11, 5) = (/ &
     &6.3633e-02_r8,5.9268e-02_r8,5.2865e-02_r8,4.5871e-02_r8,3.8419e-02_r8,3.0609e-02_r8, &
     &2.2496e-02_r8,1.3660e-02_r8,8.2073e-03_r8/)
      kao(:, 3,11, 5) = (/ &
     &6.5598e-02_r8,6.1281e-02_r8,5.4828e-02_r8,4.7713e-02_r8,4.0401e-02_r8,3.2790e-02_r8, &
     &2.4296e-02_r8,1.5126e-02_r8,8.8706e-03_r8/)
      kao(:, 4,11, 5) = (/ &
     &6.7575e-02_r8,6.3884e-02_r8,5.7739e-02_r8,5.0715e-02_r8,4.3385e-02_r8,3.5358e-02_r8, &
     &2.6343e-02_r8,1.6652e-02_r8,9.5120e-03_r8/)
      kao(:, 5,11, 5) = (/ &
     &7.0953e-02_r8,6.7728e-02_r8,6.1195e-02_r8,5.3939e-02_r8,4.6283e-02_r8,3.8093e-02_r8, &
     &2.8648e-02_r8,1.8051e-02_r8,1.0472e-02_r8/)
      kao(:, 1,12, 5) = (/ &
     &6.6289e-02_r8,6.0781e-02_r8,5.3636e-02_r8,4.6304e-02_r8,3.8429e-02_r8,3.0261e-02_r8, &
     &2.1777e-02_r8,1.2752e-02_r8,6.7746e-03_r8/)
      kao(:, 2,12, 5) = (/ &
     &6.8551e-02_r8,6.3174e-02_r8,5.6063e-02_r8,4.8348e-02_r8,4.0059e-02_r8,3.1785e-02_r8, &
     &2.3315e-02_r8,1.3856e-02_r8,7.6622e-03_r8/)
      kao(:, 3,12, 5) = (/ &
     &7.0441e-02_r8,6.5327e-02_r8,5.8258e-02_r8,5.0611e-02_r8,4.2587e-02_r8,3.4170e-02_r8, &
     &2.5237e-02_r8,1.5295e-02_r8,8.3950e-03_r8/)
      kao(:, 4,12, 5) = (/ &
     &7.3259e-02_r8,6.8842e-02_r8,6.1685e-02_r8,5.3758e-02_r8,4.5436e-02_r8,3.6706e-02_r8, &
     &2.7377e-02_r8,1.6771e-02_r8,8.9439e-03_r8/)
      kao(:, 5,12, 5) = (/ &
     &7.7467e-02_r8,7.3081e-02_r8,6.5449e-02_r8,5.7418e-02_r8,4.8677e-02_r8,3.9671e-02_r8, &
     &2.9550e-02_r8,1.8202e-02_r8,9.6319e-03_r8/)
      kao(:, 1,13, 5) = (/ &
     &5.6671e-02_r8,5.1982e-02_r8,4.5878e-02_r8,3.9500e-02_r8,3.2807e-02_r8,2.5894e-02_r8, &
     &1.8717e-02_r8,1.0942e-02_r8,5.7523e-03_r8/)
      kao(:, 2,13, 5) = (/ &
     &5.8577e-02_r8,5.4011e-02_r8,4.7896e-02_r8,4.1459e-02_r8,3.4661e-02_r8,2.7671e-02_r8, &
     &2.0186e-02_r8,1.2025e-02_r8,6.4664e-03_r8/)
      kao(:, 3,13, 5) = (/ &
     &6.0296e-02_r8,5.6294e-02_r8,5.0261e-02_r8,4.3702e-02_r8,3.6751e-02_r8,2.9579e-02_r8, &
     &2.1985e-02_r8,1.3253e-02_r8,7.0517e-03_r8/)
      kao(:, 4,13, 5) = (/ &
     &6.3403e-02_r8,5.9492e-02_r8,5.3202e-02_r8,4.6643e-02_r8,3.9435e-02_r8,3.1951e-02_r8, &
     &2.3841e-02_r8,1.4493e-02_r8,7.4965e-03_r8/)
      kao(:, 5,13, 5) = (/ &
     &6.7016e-02_r8,6.3341e-02_r8,5.7105e-02_r8,5.0058e-02_r8,4.2357e-02_r8,3.4571e-02_r8, &
     &2.5674e-02_r8,1.5753e-02_r8,8.1075e-03_r8/)
      kao(:, 1, 1, 6) = (/ &
     &1.5042e-04_r8,2.4198e-03_r8,4.3016e-03_r8,6.2979e-03_r8,8.5168e-03_r8,1.0968e-02_r8, &
     &1.3929e-02_r8,1.8584e-02_r8,1.6834e-02_r8/)
      kao(:, 2, 1, 6) = (/ &
     &1.5402e-04_r8,2.7874e-03_r8,5.0906e-03_r8,7.5405e-03_r8,1.0172e-02_r8,1.3049e-02_r8, &
     &1.6523e-02_r8,2.2172e-02_r8,2.0134e-02_r8/)
      kao(:, 3, 1, 6) = (/ &
     &1.5658e-04_r8,3.2116e-03_r8,5.9652e-03_r8,8.9274e-03_r8,1.2070e-02_r8,1.5491e-02_r8, &
     &1.9553e-02_r8,2.6056e-02_r8,2.3919e-02_r8/)
      kao(:, 4, 1, 6) = (/ &
     &1.5960e-04_r8,3.6836e-03_r8,6.9617e-03_r8,1.0460e-02_r8,1.4154e-02_r8,1.8205e-02_r8, &
     &2.3055e-02_r8,3.0555e-02_r8,2.8089e-02_r8/)
      kao(:, 5, 1, 6) = (/ &
     &1.6165e-04_r8,4.2037e-03_r8,8.0817e-03_r8,1.2177e-02_r8,1.6484e-02_r8,2.1191e-02_r8, &
     &2.6875e-02_r8,3.5769e-02_r8,3.2739e-02_r8/)
      kao(:, 1, 2, 6) = (/ &
     &2.0998e-04_r8,2.2589e-03_r8,3.7899e-03_r8,5.2410e-03_r8,6.7744e-03_r8,8.5703e-03_r8, &
     &1.0697e-02_r8,1.3881e-02_r8,1.3198e-02_r8/)
      kao(:, 2, 2, 6) = (/ &
     &2.1456e-04_r8,2.6007e-03_r8,4.3946e-03_r8,6.1987e-03_r8,8.1361e-03_r8,1.0272e-02_r8, &
     &1.2733e-02_r8,1.6541e-02_r8,1.5875e-02_r8/)
      kao(:, 3, 2, 6) = (/ &
     &2.1842e-04_r8,2.9560e-03_r8,5.0887e-03_r8,7.2752e-03_r8,9.6552e-03_r8,1.2252e-02_r8, &
     &1.5232e-02_r8,1.9582e-02_r8,1.8968e-02_r8/)
      kao(:, 4, 2, 6) = (/ &
     &2.2236e-04_r8,3.3459e-03_r8,5.8736e-03_r8,8.5067e-03_r8,1.1349e-02_r8,1.4414e-02_r8, &
     &1.7964e-02_r8,2.3187e-02_r8,2.2355e-02_r8/)
      kao(:, 5, 2, 6) = (/ &
     &2.2547e-04_r8,3.7713e-03_r8,6.7501e-03_r8,9.9039e-03_r8,1.3264e-02_r8,1.6870e-02_r8, &
     &2.1032e-02_r8,2.7154e-02_r8,2.6176e-02_r8/)
      kao(:, 1, 3, 6) = (/ &
     &3.8749e-04_r8,2.3567e-03_r8,3.5784e-03_r8,4.7302e-03_r8,5.7992e-03_r8,6.7584e-03_r8, &
     &7.8929e-03_r8,9.6810e-03_r8,9.8950e-03_r8/)
      kao(:, 2, 3, 6) = (/ &
     &3.9603e-04_r8,2.6464e-03_r8,4.1366e-03_r8,5.5007e-03_r8,6.7822e-03_r8,8.0470e-03_r8, &
     &9.4913e-03_r8,1.1619e-02_r8,1.2036e-02_r8/)
      kao(:, 3, 3, 6) = (/ &
     &4.0456e-04_r8,2.9559e-03_r8,4.7389e-03_r8,6.3508e-03_r8,7.8799e-03_r8,9.4907e-03_r8, &
     &1.1392e-02_r8,1.3956e-02_r8,1.4457e-02_r8/)
      kao(:, 4, 3, 6) = (/ &
     &4.1360e-04_r8,3.3032e-03_r8,5.4024e-03_r8,7.2987e-03_r8,9.1447e-03_r8,1.1131e-02_r8, &
     &1.3466e-02_r8,1.6568e-02_r8,1.7113e-02_r8/)
      kao(:, 5, 3, 6) = (/ &
     &4.1860e-04_r8,3.6941e-03_r8,6.1025e-03_r8,8.3274e-03_r8,1.0570e-02_r8,1.3013e-02_r8, &
     &1.5813e-02_r8,1.9496e-02_r8,2.0111e-02_r8/)
      kao(:, 1, 4, 6) = (/ &
     &7.1991e-04_r8,2.8586e-03_r8,3.8493e-03_r8,4.6115e-03_r8,5.2750e-03_r8,5.9823e-03_r8, &
     &6.5939e-03_r8,7.1204e-03_r8,6.9950e-03_r8/)
      kao(:, 2, 4, 6) = (/ &
     &7.3932e-04_r8,3.1546e-03_r8,4.3292e-03_r8,5.2487e-03_r8,6.1632e-03_r8,7.0322e-03_r8, &
     &7.8025e-03_r8,8.5583e-03_r8,8.4949e-03_r8/)
      kao(:, 3, 4, 6) = (/ &
     &7.5829e-04_r8,3.4592e-03_r8,4.8355e-03_r8,5.9709e-03_r8,7.1395e-03_r8,8.1909e-03_r8, &
     &9.1159e-03_r8,1.0292e-02_r8,1.0335e-02_r8/)
      kao(:, 4, 4, 6) = (/ &
     &7.6959e-04_r8,3.8025e-03_r8,5.3880e-03_r8,6.7853e-03_r8,8.1872e-03_r8,9.4673e-03_r8, &
     &1.0631e-02_r8,1.2218e-02_r8,1.2516e-02_r8/)
      kao(:, 5, 4, 6) = (/ &
     &7.7964e-04_r8,4.1796e-03_r8,5.9947e-03_r8,7.6582e-03_r8,9.3446e-03_r8,1.0850e-02_r8, &
     &1.2339e-02_r8,1.4388e-02_r8,1.5009e-02_r8/)
      kao(:, 1, 5, 6) = (/ &
     &1.2241e-03_r8,3.4685e-03_r8,4.4046e-03_r8,5.0844e-03_r8,5.4871e-03_r8,5.7179e-03_r8, &
     &5.7620e-03_r8,5.9818e-03_r8,6.1472e-03_r8/)
      kao(:, 2, 5, 6) = (/ &
     &1.2601e-03_r8,3.8071e-03_r8,4.8995e-03_r8,5.7159e-03_r8,6.2114e-03_r8,6.5597e-03_r8, &
     &6.8164e-03_r8,7.1370e-03_r8,7.3501e-03_r8/)
      kao(:, 3, 5, 6) = (/ &
     &1.2927e-03_r8,4.1224e-03_r8,5.4389e-03_r8,6.3889e-03_r8,6.9938e-03_r8,7.4901e-03_r8, &
     &7.9768e-03_r8,8.3697e-03_r8,8.6918e-03_r8/)
      kao(:, 4, 5, 6) = (/ &
     &1.3168e-03_r8,4.4980e-03_r8,6.0112e-03_r8,7.1194e-03_r8,7.8654e-03_r8,8.4979e-03_r8, &
     &9.2325e-03_r8,9.7616e-03_r8,1.0181e-02_r8/)
      kao(:, 5, 5, 6) = (/ &
     &1.3499e-03_r8,4.8864e-03_r8,6.6201e-03_r8,7.8699e-03_r8,8.7970e-03_r8,9.6632e-03_r8, &
     &1.0606e-02_r8,1.1344e-02_r8,1.1812e-02_r8/)
      kao(:, 1, 6, 6) = (/ &
     &1.9359e-03_r8,4.1954e-03_r8,5.0050e-03_r8,5.5462e-03_r8,5.8539e-03_r8,5.9443e-03_r8, &
     &5.7417e-03_r8,5.1473e-03_r8,5.2472e-03_r8/)
      kao(:, 2, 6, 6) = (/ &
     &2.0045e-03_r8,4.5957e-03_r8,5.5374e-03_r8,6.1876e-03_r8,6.5964e-03_r8,6.7501e-03_r8, &
     &6.5907e-03_r8,6.0581e-03_r8,6.2872e-03_r8/)
      kao(:, 3, 6, 6) = (/ &
     &2.0656e-03_r8,4.9538e-03_r8,6.0748e-03_r8,6.8772e-03_r8,7.3778e-03_r8,7.6157e-03_r8, &
     &7.5054e-03_r8,7.1291e-03_r8,7.4717e-03_r8/)
      kao(:, 4, 6, 6) = (/ &
     &2.1235e-03_r8,5.3117e-03_r8,6.6418e-03_r8,7.6042e-03_r8,8.2374e-03_r8,8.5589e-03_r8, &
     &8.5173e-03_r8,8.3153e-03_r8,8.7345e-03_r8/)
      kao(:, 5, 6, 6) = (/ &
     &2.1708e-03_r8,5.7022e-03_r8,7.2758e-03_r8,8.4071e-03_r8,9.1623e-03_r8,9.5678e-03_r8, &
     &9.5860e-03_r8,9.6197e-03_r8,1.0118e-02_r8/)
      kao(:, 1, 7, 6) = (/ &
     &3.2088e-03_r8,5.3976e-03_r8,6.1152e-03_r8,6.4273e-03_r8,6.5565e-03_r8,6.4169e-03_r8, &
     &6.0483e-03_r8,5.1718e-03_r8,4.3840e-03_r8/)
      kao(:, 2, 7, 6) = (/ &
     &3.3329e-03_r8,5.8617e-03_r8,6.7065e-03_r8,7.1293e-03_r8,7.3332e-03_r8,7.2483e-03_r8, &
     &6.8991e-03_r8,6.0070e-03_r8,5.1893e-03_r8/)
      kao(:, 3, 7, 6) = (/ &
     &3.4526e-03_r8,6.3215e-03_r8,7.2907e-03_r8,7.8484e-03_r8,8.1105e-03_r8,8.1244e-03_r8, &
     &7.7961e-03_r8,6.9012e-03_r8,6.1115e-03_r8/)
      kao(:, 4, 7, 6) = (/ &
     &3.5398e-03_r8,6.7841e-03_r8,7.9069e-03_r8,8.5448e-03_r8,8.9613e-03_r8,9.0608e-03_r8, &
     &8.7760e-03_r8,7.8768e-03_r8,7.1030e-03_r8/)
      kao(:, 5, 7, 6) = (/ &
     &3.6419e-03_r8,7.2100e-03_r8,8.5218e-03_r8,9.3036e-03_r8,9.8959e-03_r8,1.0073e-02_r8, &
     &9.8505e-03_r8,8.9292e-03_r8,8.2308e-03_r8/)
      kao(:, 1, 8, 6) = (/ &
     &6.2734e-03_r8,8.1929e-03_r8,8.7347e-03_r8,8.8396e-03_r8,8.5498e-03_r8,7.9153e-03_r8, &
     &7.0346e-03_r8,5.6808e-03_r8,4.1552e-03_r8/)
      kao(:, 2, 8, 6) = (/ &
     &6.5441e-03_r8,8.8580e-03_r8,9.5108e-03_r8,9.7024e-03_r8,9.3653e-03_r8,8.8364e-03_r8, &
     &7.9480e-03_r8,6.5304e-03_r8,4.9813e-03_r8/)
      kao(:, 3, 8, 6) = (/ &
     &6.7938e-03_r8,9.5212e-03_r8,1.0312e-02_r8,1.0573e-02_r8,1.0260e-02_r8,9.7376e-03_r8, &
     &8.8728e-03_r8,7.4306e-03_r8,5.9661e-03_r8/)
      kao(:, 4, 8, 6) = (/ &
     &6.9763e-03_r8,1.0160e-02_r8,1.1107e-02_r8,1.1420e-02_r8,1.1193e-02_r8,1.0684e-02_r8, &
     &9.8581e-03_r8,8.3990e-03_r8,6.9644e-03_r8/)
      kao(:, 5, 8, 6) = (/ &
     &7.1912e-03_r8,1.0832e-02_r8,1.1979e-02_r8,1.2319e-02_r8,1.2084e-02_r8,1.1646e-02_r8, &
     &1.0942e-02_r8,9.4605e-03_r8,8.0079e-03_r8/)
      kao(:, 1, 9, 6) = (/ &
     &2.3423e-02_r8,2.3874e-02_r8,2.2570e-02_r8,2.0907e-02_r8,1.8747e-02_r8,1.6279e-02_r8, &
     &1.3268e-02_r8,9.1967e-03_r8,5.4472e-03_r8/)
      kao(:, 2, 9, 6) = (/ &
     &2.4372e-02_r8,2.5487e-02_r8,2.4526e-02_r8,2.2806e-02_r8,2.0430e-02_r8,1.7721e-02_r8, &
     &1.4547e-02_r8,1.0257e-02_r8,5.8874e-03_r8/)
      kao(:, 3, 9, 6) = (/ &
     &2.5322e-02_r8,2.7228e-02_r8,2.6228e-02_r8,2.4576e-02_r8,2.2164e-02_r8,1.9365e-02_r8, &
     &1.5921e-02_r8,1.1389e-02_r8,6.8168e-03_r8/)
      kao(:, 4, 9, 6) = (/ &
     &2.6144e-02_r8,2.8709e-02_r8,2.7958e-02_r8,2.6366e-02_r8,2.3791e-02_r8,2.0979e-02_r8, &
     &1.7361e-02_r8,1.2542e-02_r8,7.8623e-03_r8/)
      kao(:, 5, 9, 6) = (/ &
     &2.7002e-02_r8,3.0246e-02_r8,2.9564e-02_r8,2.8028e-02_r8,2.5537e-02_r8,2.2731e-02_r8, &
     &1.8860e-02_r8,1.3722e-02_r8,9.0318e-03_r8/)
      kao(:, 1,10, 6) = (/ &
     &9.6759e-02_r8,8.9920e-02_r8,8.0281e-02_r8,6.9298e-02_r8,5.8160e-02_r8,4.6685e-02_r8, &
     &3.4489e-02_r8,2.1137e-02_r8,9.1317e-03_r8/)
      kao(:, 2,10, 6) = (/ &
     &1.0130e-01_r8,9.4928e-02_r8,8.5063e-02_r8,7.4190e-02_r8,6.2751e-02_r8,5.0819e-02_r8, &
     &3.7815e-02_r8,2.3107e-02_r8,9.7753e-03_r8/)
      kao(:, 3,10, 6) = (/ &
     &1.0500e-01_r8,9.9899e-02_r8,9.0245e-02_r8,7.9682e-02_r8,6.7667e-02_r8,5.4638e-02_r8, &
     &4.0873e-02_r8,2.5040e-02_r8,1.0330e-02_r8/)
      kao(:, 4,10, 6) = (/ &
     &1.0896e-01_r8,1.0463e-01_r8,9.5171e-02_r8,8.3946e-02_r8,7.1420e-02_r8,5.8144e-02_r8, &
     &4.3799e-02_r8,2.7205e-02_r8,1.1084e-02_r8/)
      kao(:, 5,10, 6) = (/ &
     &1.1285e-01_r8,1.0942e-01_r8,9.9931e-02_r8,8.8439e-02_r8,7.5783e-02_r8,6.1708e-02_r8, &
     &4.6484e-02_r8,2.9531e-02_r8,1.2060e-02_r8/)
      kao(:, 1,11, 6) = (/ &
     &1.4204e-01_r8,1.2997e-01_r8,1.1520e-01_r8,9.8769e-02_r8,8.1420e-02_r8,6.4217e-02_r8, &
     &4.6399e-02_r8,2.7414e-02_r8,9.3511e-03_r8/)
      kao(:, 2,11, 6) = (/ &
     &1.4781e-01_r8,1.3669e-01_r8,1.2188e-01_r8,1.0492e-01_r8,8.7668e-02_r8,6.9566e-02_r8, &
     &5.0549e-02_r8,3.0014e-02_r8,1.0330e-02_r8/)
      kao(:, 3,11, 6) = (/ &
     &1.5380e-01_r8,1.4353e-01_r8,1.2793e-01_r8,1.1113e-01_r8,9.3325e-02_r8,7.4108e-02_r8, &
     &5.4029e-02_r8,3.2498e-02_r8,1.1533e-02_r8/)
      kao(:, 4,11, 6) = (/ &
     &1.6004e-01_r8,1.5059e-01_r8,1.3460e-01_r8,1.1704e-01_r8,9.8404e-02_r8,7.8709e-02_r8, &
     &5.7847e-02_r8,3.4798e-02_r8,1.2510e-02_r8/)
      kao(:, 5,11, 6) = (/ &
     &1.6529e-01_r8,1.5606e-01_r8,1.4056e-01_r8,1.2310e-01_r8,1.0396e-01_r8,8.3240e-02_r8, &
     &6.1355e-02_r8,3.7415e-02_r8,1.3283e-02_r8/)
      kao(:, 1,12, 6) = (/ &
     &1.5238e-01_r8,1.3897e-01_r8,1.2274e-01_r8,1.0509e-01_r8,8.6816e-02_r8,6.8213e-02_r8, &
     &4.8813e-02_r8,2.8303e-02_r8,8.9094e-03_r8/)
      kao(:, 2,12, 6) = (/ &
     &1.5887e-01_r8,1.4598e-01_r8,1.2939e-01_r8,1.1123e-01_r8,9.2497e-02_r8,7.3141e-02_r8, &
     &5.2574e-02_r8,3.0889e-02_r8,9.4910e-03_r8/)
      kao(:, 3,12, 6) = (/ &
     &1.6583e-01_r8,1.5402e-01_r8,1.3664e-01_r8,1.1788e-01_r8,9.8276e-02_r8,7.7826e-02_r8, &
     &5.6134e-02_r8,3.3329e-02_r8,1.0354e-02_r8/)
      kao(:, 4,12, 6) = (/ &
     &1.7232e-01_r8,1.6056e-01_r8,1.4294e-01_r8,1.2398e-01_r8,1.0387e-01_r8,8.2524e-02_r8, &
     &5.9981e-02_r8,3.5800e-02_r8,1.1471e-02_r8/)
      kao(:, 5,12, 6) = (/ &
     &1.7822e-01_r8,1.6713e-01_r8,1.4985e-01_r8,1.3045e-01_r8,1.0965e-01_r8,8.7208e-02_r8, &
     &6.3531e-02_r8,3.8400e-02_r8,1.2648e-02_r8/)
      kao(:, 1,13, 6) = (/ &
     &1.2851e-01_r8,1.1760e-01_r8,1.0432e-01_r8,8.9471e-02_r8,7.3952e-02_r8,5.7965e-02_r8, &
     &4.1571e-02_r8,2.4244e-02_r8,7.5271e-03_r8/)
      kao(:, 2,13, 6) = (/ &
     &1.3461e-01_r8,1.2431e-01_r8,1.1020e-01_r8,9.4715e-02_r8,7.8713e-02_r8,6.2191e-02_r8, &
     &4.4720e-02_r8,2.6349e-02_r8,7.9374e-03_r8/)
      kao(:, 3,13, 6) = (/ &
     &1.4091e-01_r8,1.3079e-01_r8,1.1585e-01_r8,1.0015e-01_r8,8.3554e-02_r8,6.6181e-02_r8, &
     &4.7816e-02_r8,2.8551e-02_r8,8.7113e-03_r8/)
      kao(:, 4,13, 6) = (/ &
     &1.4657e-01_r8,1.3673e-01_r8,1.2189e-01_r8,1.0573e-01_r8,8.8680e-02_r8,7.0418e-02_r8, &
     &5.0990e-02_r8,3.0632e-02_r8,9.8158e-03_r8/)
      kao(:, 5,13, 6) = (/ &
     &1.5197e-01_r8,1.4281e-01_r8,1.2778e-01_r8,1.1111e-01_r8,9.3402e-02_r8,7.4099e-02_r8, &
     &5.4192e-02_r8,3.2952e-02_r8,1.0865e-02_r8/)
      kao(:, 1, 1, 7) = (/ &
     &2.9775e-04_r8,4.9903e-03_r8,9.5966e-03_r8,1.4458e-02_r8,1.9550e-02_r8,2.5066e-02_r8, &
     &3.1548e-02_r8,4.0907e-02_r8,3.8920e-02_r8/)
      kao(:, 2, 1, 7) = (/ &
     &2.9974e-04_r8,5.8708e-03_r8,1.1484e-02_r8,1.7340e-02_r8,2.3486e-02_r8,3.0156e-02_r8, &
     &3.8022e-02_r8,4.9522e-02_r8,4.6798e-02_r8/)
      kao(:, 3, 1, 7) = (/ &
     &3.0249e-04_r8,6.8379e-03_r8,1.3523e-02_r8,2.0453e-02_r8,2.7734e-02_r8,3.5680e-02_r8, &
     &4.5116e-02_r8,5.8960e-02_r8,5.5301e-02_r8/)
      kao(:, 4, 1, 7) = (/ &
     &3.0505e-04_r8,7.9161e-03_r8,1.5750e-02_r8,2.3843e-02_r8,3.2353e-02_r8,4.1634e-02_r8, &
     &5.2683e-02_r8,6.9279e-02_r8,6.4544e-02_r8/)
      kao(:, 5, 1, 7) = (/ &
     &3.0784e-04_r8,9.1145e-03_r8,1.8178e-02_r8,2.7529e-02_r8,3.7353e-02_r8,4.8074e-02_r8, &
     &6.0824e-02_r8,8.0052e-02_r8,7.4551e-02_r8/)
      kao(:, 1, 2, 7) = (/ &
     &4.4044e-04_r8,4.5745e-03_r8,7.9442e-03_r8,1.1658e-02_r8,1.5612e-02_r8,1.9809e-02_r8, &
     &2.4586e-02_r8,3.1373e-02_r8,3.0910e-02_r8/)
      kao(:, 2, 2, 7) = (/ &
     &4.4502e-04_r8,5.2457e-03_r8,9.4321e-03_r8,1.4009e-02_r8,1.8804e-02_r8,2.3915e-02_r8, &
     &2.9756e-02_r8,3.8088e-02_r8,3.7317e-02_r8/)
      kao(:, 3, 2, 7) = (/ &
     &4.4893e-04_r8,5.9898e-03_r8,1.1101e-02_r8,1.6604e-02_r8,2.2319e-02_r8,2.8413e-02_r8, &
     &3.5386e-02_r8,4.5425e-02_r8,4.4358e-02_r8/)
      kao(:, 4, 2, 7) = (/ &
     &4.5303e-04_r8,6.8346e-03_r8,1.2966e-02_r8,1.9451e-02_r8,2.6168e-02_r8,3.3333e-02_r8, &
     &4.1534e-02_r8,5.3372e-02_r8,5.2063e-02_r8/)
      kao(:, 5, 2, 7) = (/ &
     &4.5653e-04_r8,7.7989e-03_r8,1.5045e-02_r8,2.2592e-02_r8,3.0407e-02_r8,3.8717e-02_r8, &
     &4.8217e-02_r8,6.1953e-02_r8,6.0541e-02_r8/)
      kao(:, 1, 3, 7) = (/ &
     &8.7011e-04_r8,4.7519e-03_r8,7.4191e-03_r8,9.7724e-03_r8,1.2242e-02_r8,1.5076e-02_r8, &
     &1.8293e-02_r8,2.2402e-02_r8,2.3454e-02_r8/)
      kao(:, 2, 3, 7) = (/ &
     &8.7761e-04_r8,5.4004e-03_r8,8.5169e-03_r8,1.1449e-02_r8,1.4656e-02_r8,1.8245e-02_r8, &
     &2.2203e-02_r8,2.7303e-02_r8,2.8468e-02_r8/)
      kao(:, 3, 3, 7) = (/ &
     &8.8555e-04_r8,6.0960e-03_r8,9.7399e-03_r8,1.3383e-02_r8,1.7420e-02_r8,2.1805e-02_r8, &
     &2.6578e-02_r8,3.2747e-02_r8,3.4102e-02_r8/)
      kao(:, 4, 3, 7) = (/ &
     &8.8837e-04_r8,6.8303e-03_r8,1.1116e-02_r8,1.5598e-02_r8,2.0532e-02_r8,2.5757e-02_r8, &
     &3.1445e-02_r8,3.8773e-02_r8,4.0387e-02_r8/)
      kao(:, 5, 3, 7) = (/ &
     &8.9568e-04_r8,7.6159e-03_r8,1.2685e-02_r8,1.8136e-02_r8,2.4011e-02_r8,3.0157e-02_r8, &
     &3.6817e-02_r8,4.5383e-02_r8,4.7355e-02_r8/)
      kao(:, 1, 4, 7) = (/ &
     &1.7216e-03_r8,5.6014e-03_r8,7.5736e-03_r8,9.4674e-03_r8,1.1191e-02_r8,1.2535e-02_r8, &
     &1.3987e-02_r8,1.6268e-02_r8,1.7296e-02_r8/)
      kao(:, 2, 4, 7) = (/ &
     &1.7298e-03_r8,6.1879e-03_r8,8.6832e-03_r8,1.0978e-02_r8,1.2974e-02_r8,1.4749e-02_r8, &
     &1.6870e-02_r8,1.9909e-02_r8,2.1431e-02_r8/)
      kao(:, 3, 4, 7) = (/ &
     &1.7341e-03_r8,6.8367e-03_r8,9.8584e-03_r8,1.2616e-02_r8,1.4944e-02_r8,1.7324e-02_r8, &
     &2.0237e-02_r8,2.4035e-02_r8,2.5998e-02_r8/)
      kao(:, 4, 4, 7) = (/ &
     &1.7534e-03_r8,7.5128e-03_r8,1.1127e-02_r8,1.4362e-02_r8,1.7213e-02_r8,2.0310e-02_r8, &
     &2.4053e-02_r8,2.8665e-02_r8,3.1074e-02_r8/)
      kao(:, 5, 4, 7) = (/ &
     &1.7641e-03_r8,8.2760e-03_r8,1.2507e-02_r8,1.6268e-02_r8,1.9802e-02_r8,2.3773e-02_r8, &
     &2.8361e-02_r8,3.3846e-02_r8,3.6727e-02_r8/)
      kao(:, 1, 5, 7) = (/ &
     &3.0539e-03_r8,7.3205e-03_r8,8.9564e-03_r8,9.9240e-03_r8,1.0675e-02_r8,1.1625e-02_r8, &
     &1.2424e-02_r8,1.2649e-02_r8,1.2475e-02_r8/)
      kao(:, 2, 5, 7) = (/ &
     &3.0697e-03_r8,8.0642e-03_r8,9.9550e-03_r8,1.1166e-02_r8,1.2428e-02_r8,1.3587e-02_r8, &
     &1.4545e-02_r8,1.5222e-02_r8,1.4936e-02_r8/)
      kao(:, 3, 5, 7) = (/ &
     &3.0978e-03_r8,8.8320e-03_r8,1.1001e-02_r8,1.2560e-02_r8,1.4306e-02_r8,1.5802e-02_r8, &
     &1.6906e-02_r8,1.8302e-02_r8,1.7957e-02_r8/)
      kao(:, 4, 5, 7) = (/ &
     &3.1191e-03_r8,9.5288e-03_r8,1.2130e-02_r8,1.4148e-02_r8,1.6348e-02_r8,1.8245e-02_r8, &
     &1.9668e-02_r8,2.1849e-02_r8,2.2010e-02_r8/)
      kao(:, 5, 5, 7) = (/ &
     &3.1173e-03_r8,1.0269e-02_r8,1.3281e-02_r8,1.5937e-02_r8,1.8604e-02_r8,2.0861e-02_r8, &
     &2.2868e-02_r8,2.5903e-02_r8,2.6735e-02_r8/)
      kao(:, 1, 6, 7) = (/ &
     &4.9571e-03_r8,9.1596e-03_r8,1.0920e-02_r8,1.1683e-02_r8,1.1947e-02_r8,1.1808e-02_r8, &
     &1.1212e-02_r8,1.1074e-02_r8,1.1113e-02_r8/)
      kao(:, 2, 6, 7) = (/ &
     &5.0027e-03_r8,9.9969e-03_r8,1.2157e-02_r8,1.3082e-02_r8,1.3449e-02_r8,1.3422e-02_r8, &
     &1.3156e-02_r8,1.3134e-02_r8,1.3279e-02_r8/)
      kao(:, 3, 6, 7) = (/ &
     &5.0299e-03_r8,1.0940e-02_r8,1.3400e-02_r8,1.4481e-02_r8,1.5090e-02_r8,1.5137e-02_r8, &
     &1.5334e-02_r8,1.5370e-02_r8,1.5787e-02_r8/)
      kao(:, 4, 6, 7) = (/ &
     &5.0401e-03_r8,1.1872e-02_r8,1.4616e-02_r8,1.5947e-02_r8,1.6778e-02_r8,1.7087e-02_r8, &
     &1.7734e-02_r8,1.7868e-02_r8,1.8548e-02_r8/)
      kao(:, 5, 6, 7) = (/ &
     &5.0929e-03_r8,1.2799e-02_r8,1.5866e-02_r8,1.7551e-02_r8,1.8584e-02_r8,1.9414e-02_r8, &
     &2.0410e-02_r8,2.0816e-02_r8,2.1713e-02_r8/)
      kao(:, 1, 7, 7) = (/ &
     &8.4314e-03_r8,1.2463e-02_r8,1.3843e-02_r8,1.4407e-02_r8,1.4329e-02_r8,1.3643e-02_r8, &
     &1.2423e-02_r8,1.0398e-02_r8,1.0049e-02_r8/)
      kao(:, 2, 7, 7) = (/ &
     &8.4877e-03_r8,1.3426e-02_r8,1.5237e-02_r8,1.6099e-02_r8,1.6143e-02_r8,1.5465e-02_r8, &
     &1.4143e-02_r8,1.1980e-02_r8,1.1912e-02_r8/)
      kao(:, 3, 7, 7) = (/ &
     &8.5061e-03_r8,1.4450e-02_r8,1.6739e-02_r8,1.7865e-02_r8,1.8006e-02_r8,1.7376e-02_r8, &
     &1.5998e-02_r8,1.3868e-02_r8,1.3962e-02_r8/)
      kao(:, 4, 7, 7) = (/ &
     &8.5919e-03_r8,1.5490e-02_r8,1.8250e-02_r8,1.9632e-02_r8,1.9933e-02_r8,1.9343e-02_r8, &
     &1.7978e-02_r8,1.6120e-02_r8,1.6346e-02_r8/)
      kao(:, 5, 7, 7) = (/ &
     &8.6244e-03_r8,1.6546e-02_r8,1.9762e-02_r8,2.1475e-02_r8,2.1907e-02_r8,2.1414e-02_r8, &
     &2.0099e-02_r8,1.8617e-02_r8,1.9113e-02_r8/)
      kao(:, 1, 8, 7) = (/ &
     &1.6801e-02_r8,2.0166e-02_r8,2.0707e-02_r8,2.0359e-02_r8,1.9438e-02_r8,1.7889e-02_r8, &
     &1.5556e-02_r8,1.2093e-02_r8,8.8687e-03_r8/)
      kao(:, 2, 8, 7) = (/ &
     &1.6841e-02_r8,2.1258e-02_r8,2.2460e-02_r8,2.2381e-02_r8,2.1605e-02_r8,2.0124e-02_r8, &
     &1.7632e-02_r8,1.3928e-02_r8,1.0513e-02_r8/)
      kao(:, 3, 8, 7) = (/ &
     &1.6945e-02_r8,2.2389e-02_r8,2.4138e-02_r8,2.4525e-02_r8,2.3968e-02_r8,2.2498e-02_r8, &
     &1.9836e-02_r8,1.5792e-02_r8,1.2224e-02_r8/)
      kao(:, 4, 8, 7) = (/ &
     &1.7081e-02_r8,2.3610e-02_r8,2.5903e-02_r8,2.6682e-02_r8,2.6351e-02_r8,2.4884e-02_r8, &
     &2.2197e-02_r8,1.7790e-02_r8,1.4133e-02_r8/)
      kao(:, 5, 8, 7) = (/ &
     &1.7107e-02_r8,2.4831e-02_r8,2.7681e-02_r8,2.8814e-02_r8,2.8766e-02_r8,2.7453e-02_r8, &
     &2.4610e-02_r8,1.9914e-02_r8,1.6383e-02_r8/)
      kao(:, 1, 9, 7) = (/ &
     &6.2717e-02_r8,6.2735e-02_r8,5.8603e-02_r8,5.2748e-02_r8,4.6263e-02_r8,3.9117e-02_r8, &
     &3.0759e-02_r8,2.1087e-02_r8,9.9200e-03_r8/)
      kao(:, 2, 9, 7) = (/ &
     &6.3094e-02_r8,6.4670e-02_r8,6.0602e-02_r8,5.5392e-02_r8,4.9420e-02_r8,4.2558e-02_r8, &
     &3.4002e-02_r8,2.3733e-02_r8,1.2138e-02_r8/)
      kao(:, 3, 9, 7) = (/ &
     &6.3563e-02_r8,6.6269e-02_r8,6.3058e-02_r8,5.8357e-02_r8,5.2632e-02_r8,4.5743e-02_r8, &
     &3.7261e-02_r8,2.6594e-02_r8,1.4716e-02_r8/)
      kao(:, 4, 9, 7) = (/ &
     &6.4005e-02_r8,6.8005e-02_r8,6.5556e-02_r8,6.1466e-02_r8,5.6121e-02_r8,4.9302e-02_r8, &
     &4.0642e-02_r8,2.9533e-02_r8,1.7598e-02_r8/)
      kao(:, 5, 9, 7) = (/ &
     &6.4303e-02_r8,6.9477e-02_r8,6.8109e-02_r8,6.4600e-02_r8,5.9691e-02_r8,5.2874e-02_r8, &
     &4.4056e-02_r8,3.2670e-02_r8,2.0612e-02_r8/)
      kao(:, 1,10, 7) = (/ &
     &2.6283e-01_r8,2.3848e-01_r8,2.1237e-01_r8,1.8399e-01_r8,1.5364e-01_r8,1.2096e-01_r8, &
     &8.6686e-02_r8,5.0921e-02_r8,1.2662e-02_r8/)
      kao(:, 2,10, 7) = (/ &
     &2.6495e-01_r8,2.4348e-01_r8,2.1796e-01_r8,1.8933e-01_r8,1.5813e-01_r8,1.2513e-01_r8, &
     &9.1228e-02_r8,5.5191e-02_r8,1.6120e-02_r8/)
      kao(:, 3,10, 7) = (/ &
     &2.6701e-01_r8,2.4762e-01_r8,2.2286e-01_r8,1.9379e-01_r8,1.6250e-01_r8,1.3046e-01_r8, &
     &9.6273e-02_r8,5.9643e-02_r8,2.0041e-02_r8/)
      kao(:, 4,10, 7) = (/ &
     &2.6827e-01_r8,2.5124e-01_r8,2.2683e-01_r8,1.9843e-01_r8,1.6799e-01_r8,1.3618e-01_r8, &
     &1.0159e-01_r8,6.3939e-02_r8,2.4035e-02_r8/)
      kao(:, 5,10, 7) = (/ &
     &2.7234e-01_r8,2.5705e-01_r8,2.3264e-01_r8,2.0401e-01_r8,1.7374e-01_r8,1.4157e-01_r8, &
     &1.0689e-01_r8,6.8300e-02_r8,2.8241e-02_r8/)
      kao(:, 1,11, 7) = (/ &
     &3.8435e-01_r8,3.4486e-01_r8,3.0408e-01_r8,2.6025e-01_r8,2.1577e-01_r8,1.6840e-01_r8, &
     &1.1827e-01_r8,6.6862e-02_r8,1.4067e-02_r8/)
      kao(:, 2,11, 7) = (/ &
     &3.8808e-01_r8,3.5079e-01_r8,3.0947e-01_r8,2.6705e-01_r8,2.2115e-01_r8,1.7271e-01_r8, &
     &1.2306e-01_r8,7.1102e-02_r8,1.7282e-02_r8/)
      kao(:, 3,11, 7) = (/ &
     &3.9133e-01_r8,3.5683e-01_r8,3.1692e-01_r8,2.7320e-01_r8,2.2652e-01_r8,1.7854e-01_r8, &
     &1.2887e-01_r8,7.5471e-02_r8,2.0650e-02_r8/)
      kao(:, 4,11, 7) = (/ &
     &3.9688e-01_r8,3.6404e-01_r8,3.2547e-01_r8,2.8118e-01_r8,2.3421e-01_r8,1.8549e-01_r8, &
     &1.3490e-01_r8,8.0175e-02_r8,2.4385e-02_r8/)
      kao(:, 5,11, 7) = (/ &
     &4.0366e-01_r8,3.7211e-01_r8,3.3310e-01_r8,2.8891e-01_r8,2.4168e-01_r8,1.9277e-01_r8, &
     &1.4118e-01_r8,8.5255e-02_r8,2.8315e-02_r8/)
      kao(:, 1,12, 7) = (/ &
     &4.1788e-01_r8,3.7417e-01_r8,3.2848e-01_r8,2.8026e-01_r8,2.3093e-01_r8,1.7900e-01_r8, &
     &1.2516e-01_r8,6.9829e-02_r8,1.3077e-02_r8/)
      kao(:, 2,12, 7) = (/ &
     &4.2346e-01_r8,3.8197e-01_r8,3.3568e-01_r8,2.8761e-01_r8,2.3734e-01_r8,1.8458e-01_r8, &
     &1.3037e-01_r8,7.4069e-02_r8,1.6501e-02_r8/)
      kao(:, 3,12, 7) = (/ &
     &4.3061e-01_r8,3.9035e-01_r8,3.4485e-01_r8,2.9676e-01_r8,2.4502e-01_r8,1.9175e-01_r8, &
     &1.3672e-01_r8,7.8434e-02_r8,1.9942e-02_r8/)
      kao(:, 4,12, 7) = (/ &
     &4.3991e-01_r8,4.0142e-01_r8,3.5621e-01_r8,3.0583e-01_r8,2.5354e-01_r8,1.9941e-01_r8, &
     &1.4294e-01_r8,8.2867e-02_r8,2.3156e-02_r8/)
      kao(:, 5,12, 7) = (/ &
     &4.5018e-01_r8,4.1383e-01_r8,3.6847e-01_r8,3.1728e-01_r8,2.6385e-01_r8,2.0769e-01_r8, &
     &1.4984e-01_r8,8.7550e-02_r8,2.5906e-02_r8/)
      kao(:, 1,13, 7) = (/ &
     &3.5954e-01_r8,3.2293e-01_r8,2.8290e-01_r8,2.4149e-01_r8,1.9855e-01_r8,1.5392e-01_r8, &
     &1.0799e-01_r8,6.0538e-02_r8,1.1582e-02_r8/)
      kao(:, 2,13, 7) = (/ &
     &3.6620e-01_r8,3.3095e-01_r8,2.9118e-01_r8,2.4962e-01_r8,2.0579e-01_r8,1.6035e-01_r8, &
     &1.1345e-01_r8,6.4561e-02_r8,1.4555e-02_r8/)
      kao(:, 3,13, 7) = (/ &
     &3.7497e-01_r8,3.4139e-01_r8,3.0205e-01_r8,2.5902e-01_r8,2.1397e-01_r8,1.6755e-01_r8, &
     &1.1907e-01_r8,6.8274e-02_r8,1.7516e-02_r8/)
      kao(:, 4,13, 7) = (/ &
     &3.8491e-01_r8,3.5293e-01_r8,3.1344e-01_r8,2.6951e-01_r8,2.2338e-01_r8,1.7537e-01_r8, &
     &1.2550e-01_r8,7.2213e-02_r8,1.9685e-02_r8/)
      kao(:, 5,13, 7) = (/ &
     &3.9456e-01_r8,3.6430e-01_r8,3.2370e-01_r8,2.7885e-01_r8,2.3209e-01_r8,1.8326e-01_r8, &
     &1.3235e-01_r8,7.6929e-02_r8,2.1105e-02_r8/)
      kao(:, 1, 1, 8) = (/ &
     &6.2097e-04_r8,1.4117e-02_r8,2.8277e-02_r8,4.2775e-02_r8,5.7848e-02_r8,7.3960e-02_r8, &
     &9.2407e-02_r8,1.1864e-01_r8,1.1554e-01_r8/)
      kao(:, 2, 1, 8) = (/ &
     &6.1974e-04_r8,1.6905e-02_r8,3.3889e-02_r8,5.1276e-02_r8,6.9348e-02_r8,8.8703e-02_r8, &
     &1.1084e-01_r8,1.4177e-01_r8,1.3853e-01_r8/)
      kao(:, 3, 1, 8) = (/ &
     &6.1587e-04_r8,1.9900e-02_r8,3.9925e-02_r8,6.0422e-02_r8,8.1729e-02_r8,1.0451e-01_r8, &
     &1.3061e-01_r8,1.6696e-01_r8,1.6328e-01_r8/)
      kao(:, 4, 1, 8) = (/ &
     &6.1184e-04_r8,2.3086e-02_r8,4.6344e-02_r8,7.0163e-02_r8,9.4901e-02_r8,1.2137e-01_r8, &
     &1.5165e-01_r8,1.9370e-01_r8,1.8962e-01_r8/)
      kao(:, 5, 1, 8) = (/ &
     &6.0950e-04_r8,2.6468e-02_r8,5.3164e-02_r8,8.0478e-02_r8,1.0886e-01_r8,1.3922e-01_r8, &
     &1.7398e-01_r8,2.2192e-01_r8,2.1753e-01_r8/)
      kao(:, 1, 2, 8) = (/ &
     &9.4214e-04_r8,1.1864e-02_r8,2.3368e-02_r8,3.5168e-02_r8,4.7308e-02_r8,6.0060e-02_r8, &
     &7.4293e-02_r8,9.3548e-02_r8,9.4381e-02_r8/)
      kao(:, 2, 2, 8) = (/ &
     &9.3967e-04_r8,1.4205e-02_r8,2.8221e-02_r8,4.2491e-02_r8,5.7165e-02_r8,7.2616e-02_r8, &
     &8.9835e-02_r8,1.1322e-01_r8,1.1408e-01_r8/)
      kao(:, 3, 2, 8) = (/ &
     &9.3666e-04_r8,1.6793e-02_r8,3.3453e-02_r8,5.0403e-02_r8,6.7823e-02_r8,8.6143e-02_r8, &
     &1.0657e-01_r8,1.3437e-01_r8,1.3538e-01_r8/)
      kao(:, 4, 2, 8) = (/ &
     &9.3490e-04_r8,1.9589e-02_r8,3.9087e-02_r8,5.8901e-02_r8,7.9281e-02_r8,1.0068e-01_r8, &
     &1.2458e-01_r8,1.5697e-01_r8,1.5829e-01_r8/)
      kao(:, 5, 2, 8) = (/ &
     &9.3255e-04_r8,2.2561e-02_r8,4.5087e-02_r8,6.7983e-02_r8,9.1508e-02_r8,1.1621e-01_r8, &
     &1.4375e-01_r8,1.8108e-01_r8,1.8274e-01_r8/)
      kao(:, 1, 3, 8) = (/ &
     &1.9614e-03_r8,1.1299e-02_r8,1.9005e-02_r8,2.7782e-02_r8,3.7000e-02_r8,4.6522e-02_r8, &
     &5.6657e-02_r8,6.9080e-02_r8,7.3508e-02_r8/)
      kao(:, 2, 3, 8) = (/ &
     &1.9548e-03_r8,1.2955e-02_r8,2.2891e-02_r8,3.3903e-02_r8,4.5254e-02_r8,5.6922e-02_r8, &
     &6.9355e-02_r8,8.4555e-02_r8,9.0001e-02_r8/)
      kao(:, 3, 3, 8) = (/ &
     &1.9534e-03_r8,1.4833e-02_r8,2.7240e-02_r8,4.0599e-02_r8,5.4239e-02_r8,6.8264e-02_r8, &
     &8.3194e-02_r8,1.0146e-01_r8,1.0796e-01_r8/)
      kao(:, 4, 3, 8) = (/ &
     &1.9479e-03_r8,1.6939e-02_r8,3.1981e-02_r8,4.7805e-02_r8,6.3918e-02_r8,8.0501e-02_r8, &
     &9.8164e-02_r8,1.1980e-01_r8,1.2731e-01_r8/)
      kao(:, 5, 3, 8) = (/ &
     &1.9437e-03_r8,1.9215e-02_r8,3.7014e-02_r8,5.5432e-02_r8,7.4159e-02_r8,9.3422e-02_r8, &
     &1.1404e-01_r8,1.3937e-01_r8,1.4780e-01_r8/)
      kao(:, 1, 4, 8) = (/ &
     &4.1141e-03_r8,1.2873e-02_r8,1.8872e-02_r8,2.3795e-02_r8,2.9310e-02_r8,3.5813e-02_r8, &
     &4.3001e-02_r8,5.1220e-02_r8,5.6278e-02_r8/)
      kao(:, 2, 4, 8) = (/ &
     &4.1183e-03_r8,1.4575e-02_r8,2.1599e-02_r8,2.8253e-02_r8,3.5801e-02_r8,4.4309e-02_r8, &
     &5.3363e-02_r8,6.3628e-02_r8,6.9867e-02_r8/)
      kao(:, 3, 4, 8) = (/ &
     &4.1349e-03_r8,1.6355e-02_r8,2.4672e-02_r8,3.3305e-02_r8,4.3074e-02_r8,5.3625e-02_r8, &
     &6.4673e-02_r8,7.7228e-02_r8,8.4695e-02_r8/)
      kao(:, 4, 4, 8) = (/ &
     &4.1308e-03_r8,1.8173e-02_r8,2.8034e-02_r8,3.8865e-02_r8,5.0949e-02_r8,6.3606e-02_r8, &
     &7.6798e-02_r8,9.1846e-02_r8,1.0056e-01_r8/)
      kao(:, 5, 4, 8) = (/ &
     &4.1264e-03_r8,1.9905e-02_r8,3.1676e-02_r8,4.4946e-02_r8,5.9333e-02_r8,7.4191e-02_r8, &
     &8.9640e-02_r8,1.0735e-01_r8,1.1739e-01_r8/)
      kao(:, 1, 5, 8) = (/ &
     &7.8459e-03_r8,1.5273e-02_r8,2.0315e-02_r8,2.4490e-02_r8,2.7833e-02_r8,3.0201e-02_r8, &
     &3.3378e-02_r8,3.8411e-02_r8,4.1001e-02_r8/)
      kao(:, 2, 5, 8) = (/ &
     &7.8747e-03_r8,1.6898e-02_r8,2.3176e-02_r8,2.8487e-02_r8,3.2405e-02_r8,3.6383e-02_r8, &
     &4.1437e-02_r8,4.8316e-02_r8,5.2769e-02_r8/)
      kao(:, 3, 5, 8) = (/ &
     &7.8992e-03_r8,1.8661e-02_r8,2.6253e-02_r8,3.2541e-02_r8,3.7550e-02_r8,4.3266e-02_r8, &
     &5.0422e-02_r8,5.9136e-02_r8,6.5527e-02_r8/)
      kao(:, 4, 5, 8) = (/ &
     &7.8989e-03_r8,2.0558e-02_r8,2.9408e-02_r8,3.6576e-02_r8,4.3219e-02_r8,5.0946e-02_r8, &
     &6.0207e-02_r8,7.0821e-02_r8,7.8616e-02_r8/)
      kao(:, 5, 5, 8) = (/ &
     &7.9229e-03_r8,2.2512e-02_r8,3.2599e-02_r8,4.0913e-02_r8,4.9454e-02_r8,5.9390e-02_r8, &
     &7.0729e-02_r8,8.3313e-02_r8,9.2573e-02_r8/)
      kao(:, 1, 6, 8) = (/ &
     &1.3755e-02_r8,2.1264e-02_r8,2.4103e-02_r8,2.5712e-02_r8,2.7798e-02_r8,2.9236e-02_r8, &
     &2.9846e-02_r8,2.9593e-02_r8,2.7586e-02_r8/)
      kao(:, 2, 6, 8) = (/ &
     &1.3782e-02_r8,2.2999e-02_r8,2.6490e-02_r8,2.9514e-02_r8,3.2454e-02_r8,3.4496e-02_r8, &
     &3.5566e-02_r8,3.7000e-02_r8,3.5132e-02_r8/)
      kao(:, 3, 6, 8) = (/ &
     &1.3863e-02_r8,2.4665e-02_r8,2.9042e-02_r8,3.3641e-02_r8,3.7254e-02_r8,4.0147e-02_r8, &
     &4.1998e-02_r8,4.5403e-02_r8,4.4921e-02_r8/)
      kao(:, 4, 6, 8) = (/ &
     &1.3921e-02_r8,2.6309e-02_r8,3.1937e-02_r8,3.7874e-02_r8,4.2332e-02_r8,4.5980e-02_r8, &
     &4.9161e-02_r8,5.4719e-02_r8,5.5713e-02_r8/)
      kao(:, 5, 6, 8) = (/ &
     &1.4010e-02_r8,2.7955e-02_r8,3.5119e-02_r8,4.2034e-02_r8,4.7545e-02_r8,5.2148e-02_r8, &
     &5.7163e-02_r8,6.4833e-02_r8,6.7480e-02_r8/)
      kao(:, 1, 7, 8) = (/ &
     &2.4762e-02_r8,3.1775e-02_r8,3.3749e-02_r8,3.4176e-02_r8,3.3323e-02_r8,3.1060e-02_r8, &
     &2.9254e-02_r8,2.6750e-02_r8,2.6287e-02_r8/)
      kao(:, 2, 7, 8) = (/ &
     &2.4951e-02_r8,3.3870e-02_r8,3.6729e-02_r8,3.7700e-02_r8,3.7125e-02_r8,3.5645e-02_r8, &
     &3.4725e-02_r8,3.2382e-02_r8,3.2363e-02_r8/)
      kao(:, 3, 7, 8) = (/ &
     &2.5173e-02_r8,3.5837e-02_r8,3.9660e-02_r8,4.1206e-02_r8,4.1346e-02_r8,4.1029e-02_r8, &
     &4.0471e-02_r8,3.8518e-02_r8,3.8913e-02_r8/)
      kao(:, 4, 7, 8) = (/ &
     &2.5363e-02_r8,3.7886e-02_r8,4.2599e-02_r8,4.5028e-02_r8,4.5616e-02_r8,4.6713e-02_r8, &
     &4.6613e-02_r8,4.5204e-02_r8,4.5916e-02_r8/)
      kao(:, 5, 7, 8) = (/ &
     &2.5554e-02_r8,3.9913e-02_r8,4.5725e-02_r8,4.8757e-02_r8,5.0398e-02_r8,5.2532e-02_r8, &
     &5.3118e-02_r8,5.2718e-02_r8,5.3341e-02_r8/)
      kao(:, 1, 8, 8) = (/ &
     &5.1772e-02_r8,5.6742e-02_r8,5.6311e-02_r8,5.3676e-02_r8,4.9761e-02_r8,4.4432e-02_r8, &
     &3.7642e-02_r8,2.8159e-02_r8,2.5366e-02_r8/)
      kao(:, 2, 8, 8) = (/ &
     &5.2310e-02_r8,5.9935e-02_r8,6.0103e-02_r8,5.8243e-02_r8,5.4861e-02_r8,4.9530e-02_r8, &
     &4.2560e-02_r8,3.2942e-02_r8,3.0796e-02_r8/)
      kao(:, 3, 8, 8) = (/ &
     &5.2803e-02_r8,6.3037e-02_r8,6.4134e-02_r8,6.2766e-02_r8,5.9645e-02_r8,5.4655e-02_r8, &
     &4.7864e-02_r8,3.8688e-02_r8,3.7143e-02_r8/)
      kao(:, 4, 8, 8) = (/ &
     &5.3460e-02_r8,6.5918e-02_r8,6.8003e-02_r8,6.7271e-02_r8,6.4711e-02_r8,6.0132e-02_r8, &
     &5.3215e-02_r8,4.4724e-02_r8,4.4005e-02_r8/)
      kao(:, 5, 8, 8) = (/ &
     &5.3710e-02_r8,6.8699e-02_r8,7.1633e-02_r8,7.2036e-02_r8,6.9887e-02_r8,6.5520e-02_r8, &
     &5.8694e-02_r8,5.1143e-02_r8,5.1305e-02_r8/)
      kao(:, 1, 9, 8) = (/ &
     &2.0198e-01_r8,1.8901e-01_r8,1.7403e-01_r8,1.5566e-01_r8,1.3460e-01_r8,1.1050e-01_r8, &
     &8.4423e-02_r8,5.5049e-02_r8,2.7409e-02_r8/)
      kao(:, 2, 9, 8) = (/ &
     &2.0495e-01_r8,1.9639e-01_r8,1.8291e-01_r8,1.6519e-01_r8,1.4305e-01_r8,1.1881e-01_r8, &
     &9.2245e-02_r8,6.1787e-02_r8,3.3663e-02_r8/)
      kao(:, 3, 9, 8) = (/ &
     &2.0775e-01_r8,2.0359e-01_r8,1.9173e-01_r8,1.7370e-01_r8,1.5212e-01_r8,1.2752e-01_r8, &
     &1.0028e-01_r8,6.8520e-02_r8,3.9556e-02_r8/)
      kao(:, 4, 9, 8) = (/ &
     &2.0971e-01_r8,2.1033e-01_r8,1.9959e-01_r8,1.8173e-01_r8,1.6052e-01_r8,1.3619e-01_r8, &
     &1.0838e-01_r8,7.5430e-02_r8,4.6210e-02_r8/)
      kao(:, 5, 9, 8) = (/ &
     &2.1122e-01_r8,2.1661e-01_r8,2.0701e-01_r8,1.8977e-01_r8,1.6868e-01_r8,1.4451e-01_r8, &
     &1.1695e-01_r8,8.2426e-02_r8,5.2611e-02_r8/)
      kao(:, 1,10, 8) = (/ &
     &8.7179e-01_r8,7.7305e-01_r8,6.7676e-01_r8,5.7800e-01_r8,4.7858e-01_r8,3.7509e-01_r8, &
     &2.6780e-01_r8,1.5257e-01_r8,3.4825e-02_r8/)
      kao(:, 2,10, 8) = (/ &
     &8.8690e-01_r8,7.9154e-01_r8,6.9682e-01_r8,6.0089e-01_r8,5.0085e-01_r8,3.9677e-01_r8, &
     &2.8510e-01_r8,1.6381e-01_r8,4.0840e-02_r8/)
      kao(:, 3,10, 8) = (/ &
     &8.9846e-01_r8,8.0873e-01_r8,7.1712e-01_r8,6.2211e-01_r8,5.2235e-01_r8,4.1529e-01_r8, &
     &3.0033e-01_r8,1.7576e-01_r8,4.8253e-02_r8/)
      kao(:, 4,10, 8) = (/ &
     &9.1202e-01_r8,8.2713e-01_r8,7.3854e-01_r8,6.4399e-01_r8,5.4276e-01_r8,4.3255e-01_r8, &
     &3.1463e-01_r8,1.8727e-01_r8,5.7567e-02_r8/)
      kao(:, 5,10, 8) = (/ &
     &9.1292e-01_r8,8.3520e-01_r8,7.5311e-01_r8,6.6058e-01_r8,5.5851e-01_r8,4.4868e-01_r8, &
     &3.2919e-01_r8,1.9841e-01_r8,6.5659e-02_r8/)
      kao(:, 1,11, 8) = (/ &
     &1.3103e+00_r8,1.1565e+00_r8,1.0072e+00_r8,8.5492e-01_r8,7.0080e-01_r8,5.4405e-01_r8, &
     &3.8288e-01_r8,2.1296e-01_r8,3.6932e-02_r8/)
      kao(:, 2,11, 8) = (/ &
     &1.3299e+00_r8,1.1796e+00_r8,1.0327e+00_r8,8.8125e-01_r8,7.2693e-01_r8,5.6857e-01_r8, &
     &4.0335e-01_r8,2.2633e-01_r8,4.3190e-02_r8/)
      kao(:, 3,11, 8) = (/ &
     &1.3530e+00_r8,1.2064e+00_r8,1.0600e+00_r8,9.1131e-01_r8,7.5598e-01_r8,5.9411e-01_r8, &
     &4.2265e-01_r8,2.3978e-01_r8,5.2762e-02_r8/)
      kao(:, 4,11, 8) = (/ &
     &1.3587e+00_r8,1.2195e+00_r8,1.0781e+00_r8,9.3079e-01_r8,7.7634e-01_r8,6.1327e-01_r8, &
     &4.3892e-01_r8,2.5297e-01_r8,6.4865e-02_r8/)
      kao(:, 5,11, 8) = (/ &
     &1.3600e+00_r8,1.2284e+00_r8,1.0908e+00_r8,9.4457e-01_r8,7.9211e-01_r8,6.2699e-01_r8, &
     &4.5262e-01_r8,2.6437e-01_r8,7.6848e-02_r8/)
      kao(:, 1,12, 8) = (/ &
     &1.4407e+00_r8,1.2713e+00_r8,1.1065e+00_r8,9.3835e-01_r8,7.6825e-01_r8,5.9432e-01_r8, &
     &4.1638e-01_r8,2.2888e-01_r8,3.4685e-02_r8/)
      kao(:, 2,12, 8) = (/ &
     &1.4696e+00_r8,1.3029e+00_r8,1.1378e+00_r8,9.6981e-01_r8,7.9767e-01_r8,6.2103e-01_r8, &
     &4.3779e-01_r8,2.4254e-01_r8,4.2654e-02_r8/)
      kao(:, 3,12, 8) = (/ &
     &1.4810e+00_r8,1.3211e+00_r8,1.1578e+00_r8,9.9148e-01_r8,8.2013e-01_r8,6.4181e-01_r8, &
     &4.5466e-01_r8,2.5578e-01_r8,5.2496e-02_r8/)
      kao(:, 4,12, 8) = (/ &
     &1.4858e+00_r8,1.3306e+00_r8,1.1727e+00_r8,1.0074e+00_r8,8.3618e-01_r8,6.5672e-01_r8, &
     &4.6743e-01_r8,2.6737e-01_r8,6.3361e-02_r8/)
      kao(:, 5,12, 8) = (/ &
     &1.4815e+00_r8,1.3335e+00_r8,1.1804e+00_r8,1.0190e+00_r8,8.4985e-01_r8,6.7121e-01_r8, &
     &4.8121e-01_r8,2.7853e-01_r8,7.5291e-02_r8/)
      kao(:, 1,13, 8) = (/ &
     &1.2616e+00_r8,1.1163e+00_r8,9.7204e-01_r8,8.2547e-01_r8,6.7669e-01_r8,5.2391e-01_r8, &
     &3.6673e-01_r8,2.0106e-01_r8,2.9782e-02_r8/)
      kao(:, 2,13, 8) = (/ &
     &1.2777e+00_r8,1.1375e+00_r8,9.9345e-01_r8,8.4804e-01_r8,6.9806e-01_r8,5.4388e-01_r8, &
     &3.8298e-01_r8,2.1265e-01_r8,3.7539e-02_r8/)
      kao(:, 3,13, 8) = (/ &
     &1.2857e+00_r8,1.1501e+00_r8,1.0105e+00_r8,8.6538e-01_r8,7.1567e-01_r8,5.5928e-01_r8, &
     &3.9596e-01_r8,2.2292e-01_r8,4.5370e-02_r8/)
      kao(:, 4,13, 8) = (/ &
     &1.2877e+00_r8,1.1566e+00_r8,1.0204e+00_r8,8.7739e-01_r8,7.2832e-01_r8,5.7170e-01_r8, &
     &4.0727e-01_r8,2.3325e-01_r8,5.5134e-02_r8/)
      kao(:, 5,13, 8) = (/ &
     &1.2810e+00_r8,1.1580e+00_r8,1.0267e+00_r8,8.8778e-01_r8,7.3941e-01_r8,5.8252e-01_r8, &
     &4.1760e-01_r8,2.4248e-01_r8,6.6222e-02_r8/)
      kao(:, 1, 1, 9) = (/ &
     &1.6209e-03_r8,5.7589e-02_r8,1.1558e-01_r8,1.7436e-01_r8,2.3438e-01_r8,2.9678e-01_r8, &
     &3.6435e-01_r8,4.4557e-01_r8,4.6867e-01_r8/)
      kao(:, 2, 1, 9) = (/ &
     &1.6160e-03_r8,6.8254e-02_r8,1.3700e-01_r8,2.0665e-01_r8,2.7776e-01_r8,3.5160e-01_r8, &
     &4.3147e-01_r8,5.2804e-01_r8,5.5543e-01_r8/)
      kao(:, 3, 1, 9) = (/ &
     &1.6156e-03_r8,7.9739e-02_r8,1.6004e-01_r8,2.4140e-01_r8,3.2446e-01_r8,4.1061e-01_r8, &
     &5.0337e-01_r8,6.1528e-01_r8,6.4882e-01_r8/)
      kao(:, 4, 1, 9) = (/ &
     &1.6118e-03_r8,9.1878e-02_r8,1.8447e-01_r8,2.7828e-01_r8,3.7409e-01_r8,4.7339e-01_r8, &
     &5.8011e-01_r8,7.0748e-01_r8,7.4809e-01_r8/)
      kao(:, 5, 1, 9) = (/ &
     &1.6027e-03_r8,1.0449e-01_r8,2.0983e-01_r8,3.1665e-01_r8,4.2579e-01_r8,5.3908e-01_r8, &
     &6.6087e-01_r8,8.0485e-01_r8,8.5148e-01_r8/)
      kao(:, 1, 2, 9) = (/ &
     &2.5385e-03_r8,4.9947e-02_r8,1.0010e-01_r8,1.5075e-01_r8,2.0224e-01_r8,2.5529e-01_r8, &
     &3.1202e-01_r8,3.8059e-01_r8,4.0436e-01_r8/)
      kao(:, 2, 2, 9) = (/ &
     &2.5420e-03_r8,5.9613e-02_r8,1.1949e-01_r8,1.7998e-01_r8,2.4152e-01_r8,3.0496e-01_r8, &
     &3.7260e-01_r8,4.5413e-01_r8,4.8291e-01_r8/)
      kao(:, 3, 2, 9) = (/ &
     &2.5425e-03_r8,6.9977e-02_r8,1.4031e-01_r8,2.1138e-01_r8,2.8370e-01_r8,3.5840e-01_r8, &
     &4.3825e-01_r8,5.3358e-01_r8,5.6726e-01_r8/)
      kao(:, 4, 2, 9) = (/ &
     &2.5349e-03_r8,8.0938e-02_r8,1.6229e-01_r8,2.4456e-01_r8,3.2834e-01_r8,4.1497e-01_r8, &
     &5.0769e-01_r8,6.1900e-01_r8,6.5654e-01_r8/)
      kao(:, 5, 2, 9) = (/ &
     &2.5236e-03_r8,9.2377e-02_r8,1.8522e-01_r8,2.7915e-01_r8,3.7480e-01_r8,4.7381e-01_r8, &
     &5.8018e-01_r8,7.0850e-01_r8,7.4944e-01_r8/)
      kao(:, 1, 3, 9) = (/ &
     &5.2884e-03_r8,4.1358e-02_r8,8.2480e-02_r8,1.2391e-01_r8,1.6574e-01_r8,2.0832e-01_r8, &
     &2.5278e-01_r8,3.0394e-01_r8,3.3126e-01_r8/)
      kao(:, 2, 3, 9) = (/ &
     &5.3098e-03_r8,4.9746e-02_r8,9.9365e-02_r8,1.4928e-01_r8,1.9972e-01_r8,2.5111e-01_r8, &
     &3.0480e-01_r8,3.6676e-01_r8,3.9919e-01_r8/)
      kao(:, 3, 3, 9) = (/ &
     &5.3133e-03_r8,5.8864e-02_r8,1.1765e-01_r8,1.7679e-01_r8,2.3653e-01_r8,2.9742e-01_r8, &
     &3.6115e-01_r8,4.3493e-01_r8,4.7279e-01_r8/)
      kao(:, 4, 3, 9) = (/ &
     &5.3184e-03_r8,6.8570e-02_r8,1.3708e-01_r8,2.0601e-01_r8,2.7562e-01_r8,3.4665e-01_r8, &
     &4.2100e-01_r8,5.0744e-01_r8,5.5094e-01_r8/)
      kao(:, 5, 3, 9) = (/ &
     &5.2937e-03_r8,7.8913e-02_r8,1.5776e-01_r8,2.3709e-01_r8,3.1721e-01_r8,3.9889e-01_r8, &
     &4.8431e-01_r8,5.8366e-01_r8,6.3409e-01_r8/)
      kao(:, 1, 4, 9) = (/ &
     &1.1189e-02_r8,3.7631e-02_r8,6.6855e-02_r8,9.9420e-02_r8,1.3264e-01_r8,1.6622e-01_r8, &
     &2.0064e-01_r8,2.3828e-01_r8,2.6479e-01_r8/)
      kao(:, 2, 4, 9) = (/ &
     &1.1235e-02_r8,4.3836e-02_r8,8.1298e-02_r8,1.2151e-01_r8,1.6212e-01_r8,2.0319e-01_r8, &
     &2.4526e-01_r8,2.9131e-01_r8,3.2370e-01_r8/)
      kao(:, 3, 4, 9) = (/ &
     &1.1256e-02_r8,5.0846e-02_r8,9.7157e-02_r8,1.4551e-01_r8,1.9420e-01_r8,2.4340e-01_r8, &
     &2.9384e-01_r8,3.4897e-01_r8,3.8783e-01_r8/)
      kao(:, 4, 4, 9) = (/ &
     &1.1233e-02_r8,5.8695e-02_r8,1.1439e-01_r8,1.7147e-01_r8,2.2883e-01_r8,2.8678e-01_r8, &
     &3.4608e-01_r8,4.1077e-01_r8,4.5705e-01_r8/)
      kao(:, 5, 4, 9) = (/ &
     &1.1193e-02_r8,6.7408e-02_r8,1.3290e-01_r8,1.9926e-01_r8,2.6591e-01_r8,3.3325e-01_r8, &
     &4.0214e-01_r8,4.7714e-01_r8,5.3115e-01_r8/)
      kao(:, 1, 5, 9) = (/ &
     &2.1456e-02_r8,4.5196e-02_r8,6.1958e-02_r8,8.2153e-02_r8,1.0545e-01_r8,1.3112e-01_r8, &
     &1.5772e-01_r8,1.8584e-01_r8,2.0874e-01_r8/)
      kao(:, 2, 5, 9) = (/ &
     &2.1627e-02_r8,4.9543e-02_r8,7.2420e-02_r8,9.9628e-02_r8,1.3042e-01_r8,1.6274e-01_r8, &
     &1.9580e-01_r8,2.3075e-01_r8,2.5926e-01_r8/)
      kao(:, 3, 5, 9) = (/ &
     &2.1648e-02_r8,5.4430e-02_r8,8.4381e-02_r8,1.1963e-01_r8,1.5816e-01_r8,1.9769e-01_r8, &
     &2.3786e-01_r8,2.8024e-01_r8,3.1505e-01_r8/)
      kao(:, 4, 5, 9) = (/ &
     &2.1655e-02_r8,5.9909e-02_r8,9.8020e-02_r8,1.4216e-01_r8,1.8871e-01_r8,2.3596e-01_r8, &
     &2.8391e-01_r8,3.3439e-01_r8,3.7619e-01_r8/)
      kao(:, 5, 5, 9) = (/ &
     &2.1575e-02_r8,6.6071e-02_r8,1.1341e-01_r8,1.6675e-01_r8,2.2186e-01_r8,2.7746e-01_r8, &
     &3.3388e-01_r8,3.9317e-01_r8,4.4246e-01_r8/)
      kao(:, 1, 6, 9) = (/ &
     &3.8314e-02_r8,5.9481e-02_r8,7.1457e-02_r8,8.1684e-02_r8,9.1784e-02_r8,1.0487e-01_r8, &
     &1.2171e-01_r8,1.4213e-01_r8,1.5860e-01_r8/)
      kao(:, 2, 6, 9) = (/ &
     &3.8611e-02_r8,6.4337e-02_r8,7.9461e-02_r8,9.3850e-02_r8,1.0993e-01_r8,1.2967e-01_r8, &
     &1.5327e-01_r8,1.7946e-01_r8,2.0255e-01_r8/)
      kao(:, 3, 6, 9) = (/ &
     &3.8670e-02_r8,6.9241e-02_r8,8.8613e-02_r8,1.0808e-01_r8,1.3134e-01_r8,1.5836e-01_r8, &
     &1.8890e-01_r8,2.2142e-01_r8,2.5002e-01_r8/)
      kao(:, 4, 6, 9) = (/ &
     &3.8675e-02_r8,7.4319e-02_r8,9.8760e-02_r8,1.2484e-01_r8,1.5591e-01_r8,1.9105e-01_r8, &
     &2.2866e-01_r8,2.6805e-01_r8,3.0304e-01_r8/)
      kao(:, 5, 6, 9) = (/ &
     &3.8508e-02_r8,7.9526e-02_r8,1.0987e-01_r8,1.4404e-01_r8,1.8357e-01_r8,2.2696e-01_r8, &
     &2.7218e-01_r8,3.1912e-01_r8,3.6102e-01_r8/)
      kao(:, 1, 7, 9) = (/ &
     &7.2084e-02_r8,8.8512e-02_r8,9.7172e-02_r8,1.0090e-01_r8,1.0168e-01_r8,1.0216e-01_r8, &
     &1.0271e-01_r8,1.0842e-01_r8,1.0501e-01_r8/)
      kao(:, 2, 7, 9) = (/ &
     &7.2564e-02_r8,9.4711e-02_r8,1.0583e-01_r8,1.1196e-01_r8,1.1550e-01_r8,1.2008e-01_r8, &
     &1.2583e-01_r8,1.3849e-01_r8,1.4021e-01_r8/)
      kao(:, 3, 7, 9) = (/ &
     &7.2730e-02_r8,1.0095e-01_r8,1.1490e-01_r8,1.2380e-01_r8,1.3141e-01_r8,1.4065e-01_r8, &
     &1.5344e-01_r8,1.7335e-01_r8,1.8125e-01_r8/)
      kao(:, 4, 7, 9) = (/ &
     &7.2941e-02_r8,1.0706e-01_r8,1.2422e-01_r8,1.3654e-01_r8,1.5005e-01_r8,1.6497e-01_r8, &
     &1.8541e-01_r8,2.1284e-01_r8,2.2809e-01_r8/)
      kao(:, 5, 7, 9) = (/ &
     &7.3026e-02_r8,1.1297e-01_r8,1.3379e-01_r8,1.5116e-01_r8,1.7068e-01_r8,1.9286e-01_r8, &
     &2.2139e-01_r8,2.5637e-01_r8,2.7993e-01_r8/)
      kao(:, 1, 8, 9) = (/ &
     &1.6179e-01_r8,1.6443e-01_r8,1.6310e-01_r8,1.5765e-01_r8,1.4868e-01_r8,1.3533e-01_r8, &
     &1.1770e-01_r8,9.8380e-02_r8,8.1836e-02_r8/)
      kao(:, 2, 8, 9) = (/ &
     &1.6423e-01_r8,1.7218e-01_r8,1.7516e-01_r8,1.7171e-01_r8,1.6374e-01_r8,1.5153e-01_r8, &
     &1.3534e-01_r8,1.1999e-01_r8,1.0061e-01_r8/)
      kao(:, 3, 8, 9) = (/ &
     &1.6654e-01_r8,1.7965e-01_r8,1.8707e-01_r8,1.8587e-01_r8,1.7956e-01_r8,1.6926e-01_r8, &
     &1.5537e-01_r8,1.4544e-01_r8,1.2284e-01_r8/)
      kao(:, 4, 8, 9) = (/ &
     &1.6762e-01_r8,1.8741e-01_r8,1.9894e-01_r8,2.0043e-01_r8,1.9638e-01_r8,1.8821e-01_r8, &
     &1.7907e-01_r8,1.7570e-01_r8,1.5659e-01_r8/)
      kao(:, 5, 8, 9) = (/ &
     &1.6808e-01_r8,1.9570e-01_r8,2.1084e-01_r8,2.1493e-01_r8,2.1406e-01_r8,2.0908e-01_r8, &
     &2.0616e-01_r8,2.1009e-01_r8,1.9730e-01_r8/)
      kao(:, 1, 9, 9) = (/ &
     &7.0428e-01_r8,6.3434e-01_r8,5.6644e-01_r8,4.9559e-01_r8,4.2070e-01_r8,3.4143e-01_r8, &
     &2.6063e-01_r8,1.7246e-01_r8,1.1446e-01_r8/)
      kao(:, 2, 9, 9) = (/ &
     &7.1533e-01_r8,6.5148e-01_r8,5.8487e-01_r8,5.1694e-01_r8,4.4379e-01_r8,3.6693e-01_r8, &
     &2.8562e-01_r8,1.9355e-01_r8,1.3717e-01_r8/)
      kao(:, 3, 9, 9) = (/ &
     &7.2105e-01_r8,6.6501e-01_r8,6.0595e-01_r8,5.4025e-01_r8,4.6705e-01_r8,3.9267e-01_r8, &
     &3.1101e-01_r8,2.1648e-01_r8,1.6351e-01_r8/)
      kao(:, 4, 9, 9) = (/ &
     &7.2262e-01_r8,6.7430e-01_r8,6.2376e-01_r8,5.6249e-01_r8,4.9295e-01_r8,4.1839e-01_r8, &
     &3.3764e-01_r8,2.4119e-01_r8,1.9114e-01_r8/)
      kao(:, 5, 9, 9) = (/ &
     &7.2252e-01_r8,6.8406e-01_r8,6.4078e-01_r8,5.8400e-01_r8,5.1738e-01_r8,4.4614e-01_r8, &
     &3.6505e-01_r8,2.6763e-01_r8,2.2362e-01_r8/)
      kao(:, 1,10, 9) = (/ &
     &3.3754e+00_r8,2.9579e+00_r8,2.5567e+00_r8,2.1598e+00_r8,1.7623e+00_r8,1.3527e+00_r8, &
     &9.4464e-01_r8,5.2414e-01_r8,1.6022e-01_r8/)
      kao(:, 2,10, 9) = (/ &
     &3.4121e+00_r8,2.9947e+00_r8,2.5993e+00_r8,2.2033e+00_r8,1.8038e+00_r8,1.3952e+00_r8, &
     &9.8851e-01_r8,5.5797e-01_r8,1.9922e-01_r8/)
      kao(:, 3,10, 9) = (/ &
     &3.4354e+00_r8,3.0219e+00_r8,2.6345e+00_r8,2.2476e+00_r8,1.8449e+00_r8,1.4451e+00_r8, &
     &1.0317e+00_r8,5.9234e-01_r8,2.4180e-01_r8/)
      kao(:, 4,10, 9) = (/ &
     &3.4369e+00_r8,3.0367e+00_r8,2.6577e+00_r8,2.2740e+00_r8,1.8821e+00_r8,1.4871e+00_r8, &
     &1.0728e+00_r8,6.2615e-01_r8,2.8291e-01_r8/)
      kao(:, 5,10, 9) = (/ &
     &3.4461e+00_r8,3.0546e+00_r8,2.6839e+00_r8,2.3057e+00_r8,1.9262e+00_r8,1.5287e+00_r8, &
     &1.1134e+00_r8,6.5955e-01_r8,3.3010e-01_r8/)
      kao(:, 1,11, 9) = (/ &
     &5.5731e+00_r8,4.8785e+00_r8,4.1979e+00_r8,3.5322e+00_r8,2.8619e+00_r8,2.1883e+00_r8, &
     &1.5051e+00_r8,8.1479e-01_r8,1.7197e-01_r8/)
      kao(:, 2,11, 9) = (/ &
     &5.6124e+00_r8,4.9158e+00_r8,4.2449e+00_r8,3.5793e+00_r8,2.9170e+00_r8,2.2388e+00_r8, &
     &1.5568e+00_r8,8.5687e-01_r8,2.2531e-01_r8/)
      kao(:, 3,11, 9) = (/ &
     &5.6253e+00_r8,4.9334e+00_r8,4.2755e+00_r8,3.6196e+00_r8,2.9577e+00_r8,2.2787e+00_r8, &
     &1.6022e+00_r8,8.9680e-01_r8,2.6360e-01_r8/)
      kao(:, 4,11, 9) = (/ &
     &5.6351e+00_r8,4.9513e+00_r8,4.3021e+00_r8,3.6565e+00_r8,2.9923e+00_r8,2.3311e+00_r8, &
     &1.6513e+00_r8,9.3728e-01_r8,3.0681e-01_r8/)
      kao(:, 5,11, 9) = (/ &
     &5.6511e+00_r8,4.9808e+00_r8,4.3475e+00_r8,3.7008e+00_r8,3.0483e+00_r8,2.3866e+00_r8, &
     &1.7012e+00_r8,9.7887e-01_r8,3.4951e-01_r8/)
      kao(:, 1,12, 9) = (/ &
     &6.6833e+00_r8,5.8503e+00_r8,5.0320e+00_r8,4.2291e+00_r8,3.4220e+00_r8,2.6133e+00_r8, &
     &1.7900e+00_r8,9.6260e-01_r8,1.7445e-01_r8/)
      kao(:, 2,12, 9) = (/ &
     &6.6977e+00_r8,5.8665e+00_r8,5.0629e+00_r8,4.2649e+00_r8,3.4722e+00_r8,2.6560e+00_r8, &
     &1.8378e+00_r8,1.0034e+00_r8,2.1910e-01_r8/)
      kao(:, 3,12, 9) = (/ &
     &6.7112e+00_r8,5.8830e+00_r8,5.0943e+00_r8,4.3071e+00_r8,3.5122e+00_r8,2.7000e+00_r8, &
     &1.8863e+00_r8,1.0455e+00_r8,2.5420e-01_r8/)
      kao(:, 4,12, 9) = (/ &
     &6.7306e+00_r8,5.9135e+00_r8,5.1333e+00_r8,4.3624e+00_r8,3.5635e+00_r8,2.7641e+00_r8, &
     &1.9469e+00_r8,1.0906e+00_r8,2.9618e-01_r8/)
      kao(:, 5,12, 9) = (/ &
     &6.7198e+00_r8,5.9182e+00_r8,5.1572e+00_r8,4.3874e+00_r8,3.6068e+00_r8,2.8158e+00_r8, &
     &1.9979e+00_r8,1.1364e+00_r8,3.4172e-01_r8/)
      kao(:, 1,13, 9) = (/ &
     &6.2228e+00_r8,5.4483e+00_r8,4.6948e+00_r8,3.9489e+00_r8,3.2053e+00_r8,2.4477e+00_r8, &
     &1.6826e+00_r8,9.0899e-01_r8,1.6340e-01_r8/)
      kao(:, 2,13, 9) = (/ &
     &6.2479e+00_r8,5.4750e+00_r8,4.7365e+00_r8,3.9942e+00_r8,3.2532e+00_r8,2.4916e+00_r8, &
     &1.7319e+00_r8,9.4656e-01_r8,1.9164e-01_r8/)
      kao(:, 3,13, 9) = (/ &
     &6.2720e+00_r8,5.5063e+00_r8,4.7748e+00_r8,4.0523e+00_r8,3.3026e+00_r8,2.5508e+00_r8, &
     &1.7859e+00_r8,9.9108e-01_r8,2.3050e-01_r8/)
      kao(:, 4,13, 9) = (/ &
     &6.2663e+00_r8,5.5165e+00_r8,4.8016e+00_r8,4.0858e+00_r8,3.3448e+00_r8,2.6010e+00_r8, &
     &1.8364e+00_r8,1.0337e+00_r8,2.6420e-01_r8/)
      kao(:, 5,13, 9) = (/ &
     &6.2869e+00_r8,5.5494e+00_r8,4.8492e+00_r8,4.1318e+00_r8,3.4036e+00_r8,2.6598e+00_r8, &
     &1.8865e+00_r8,1.0759e+00_r8,2.9687e-01_r8/)
      kao(:, 1, 1,10) = (/ &
     &2.7731e-03_r8,1.5625e-01_r8,3.1254e-01_r8,4.6910e-01_r8,6.2583e-01_r8,7.8249e-01_r8, &
     &9.3706e-01_r8,1.0845e+00_r8,1.2516e+00_r8/)
      kao(:, 2, 1,10) = (/ &
     &2.6994e-03_r8,1.8576e-01_r8,3.7148e-01_r8,5.5698e-01_r8,7.4226e-01_r8,9.2683e-01_r8, &
     &1.1083e+00_r8,1.2874e+00_r8,1.4844e+00_r8/)
      kao(:, 3, 1,10) = (/ &
     &2.5977e-03_r8,2.1688e-01_r8,4.3344e-01_r8,6.4957e-01_r8,8.6528e-01_r8,1.0791e+00_r8, &
     &1.2881e+00_r8,1.4959e+00_r8,1.7305e+00_r8/)
      kao(:, 4, 1,10) = (/ &
     &2.4994e-03_r8,2.5005e-01_r8,4.9954e-01_r8,7.4789e-01_r8,9.9444e-01_r8,1.2373e+00_r8, &
     &1.4746e+00_r8,1.7076e+00_r8,1.9888e+00_r8/)
      kao(:, 5, 1,10) = (/ &
     &2.4443e-03_r8,2.8623e-01_r8,5.7132e-01_r8,8.5454e-01_r8,1.1344e+00_r8,1.4080e+00_r8, &
     &1.6698e+00_r8,1.9238e+00_r8,2.2687e+00_r8/)
      kao(:, 1, 2,10) = (/ &
     &4.6033e-03_r8,1.4235e-01_r8,2.8494e-01_r8,4.2818e-01_r8,5.7234e-01_r8,7.1833e-01_r8, &
     &8.6574e-01_r8,1.0139e+00_r8,1.1445e+00_r8/)
      kao(:, 2, 2,10) = (/ &
     &4.4279e-03_r8,1.7116e-01_r8,3.4236e-01_r8,5.1392e-01_r8,6.8612e-01_r8,8.5990e-01_r8, &
     &1.0377e+00_r8,1.2137e+00_r8,1.3721e+00_r8/)
      kao(:, 3, 2,10) = (/ &
     &4.2606e-03_r8,2.0315e-01_r8,4.0616e-01_r8,6.0913e-01_r8,8.1201e-01_r8,1.0152e+00_r8, &
     &1.2192e+00_r8,1.4256e+00_r8,1.6238e+00_r8/)
      kao(:, 4, 2,10) = (/ &
     &4.1205e-03_r8,2.3773e-01_r8,4.7526e-01_r8,7.1252e-01_r8,9.4929e-01_r8,1.1850e+00_r8, &
     &1.4175e+00_r8,1.6433e+00_r8,1.8984e+00_r8/)
      kao(:, 5, 2,10) = (/ &
     &4.0494e-03_r8,2.7547e-01_r8,5.5055e-01_r8,8.2539e-01_r8,1.0993e+00_r8,1.3710e+00_r8, &
     &1.6368e+00_r8,1.8772e+00_r8,2.1984e+00_r8/)
      kao(:, 1, 3,10) = (/ &
     &1.0161e-02_r8,1.2214e-01_r8,2.4424e-01_r8,3.6667e-01_r8,4.8955e-01_r8,6.1355e-01_r8, &
     &7.4009e-01_r8,8.7555e-01_r8,9.7887e-01_r8/)
      kao(:, 2, 3,10) = (/ &
     &9.8188e-03_r8,1.5023e-01_r8,3.0029e-01_r8,4.5055e-01_r8,6.0115e-01_r8,7.5236e-01_r8, &
     &9.0544e-01_r8,1.0662e+00_r8,1.2020e+00_r8/)
      kao(:, 3, 3,10) = (/ &
     &9.4977e-03_r8,1.8146e-01_r8,3.6272e-01_r8,5.4423e-01_r8,7.2598e-01_r8,9.0829e-01_r8, &
     &1.0912e+00_r8,1.2774e+00_r8,1.4517e+00_r8/)
      kao(:, 4, 3,10) = (/ &
     &9.2658e-03_r8,2.1540e-01_r8,4.3072e-01_r8,6.4627e-01_r8,8.6225e-01_r8,1.0787e+00_r8, &
     &1.2961e+00_r8,1.5118e+00_r8,1.7242e+00_r8/)
      kao(:, 5, 3,10) = (/ &
     &9.2390e-03_r8,2.5102e-01_r8,5.0193e-01_r8,7.5312e-01_r8,1.0052e+00_r8,1.2582e+00_r8, &
     &1.5132e+00_r8,1.7682e+00_r8,2.0100e+00_r8/)
      kao(:, 1, 4,10) = (/ &
     &2.2805e-02_r8,1.0395e-01_r8,2.0752e-01_r8,3.1119e-01_r8,4.1502e-01_r8,5.1909e-01_r8, &
     &6.2381e-01_r8,7.3100e-01_r8,8.2961e-01_r8/)
      kao(:, 2, 4,10) = (/ &
     &2.2222e-02_r8,1.2866e-01_r8,2.5687e-01_r8,3.8520e-01_r8,5.1380e-01_r8,6.4273e-01_r8, &
     &7.7289e-01_r8,9.0648e-01_r8,1.0271e+00_r8/)
      kao(:, 3, 4,10) = (/ &
     &2.1664e-02_r8,1.5642e-01_r8,3.1238e-01_r8,4.6876e-01_r8,6.2523e-01_r8,7.8254e-01_r8, &
     &9.4140e-01_r8,1.1052e+00_r8,1.2499e+00_r8/)
      kao(:, 4, 4,10) = (/ &
     &2.1586e-02_r8,1.8661e-01_r8,3.7283e-01_r8,5.5940e-01_r8,7.4664e-01_r8,9.3462e-01_r8, &
     &1.1258e+00_r8,1.3254e+00_r8,1.4927e+00_r8/)
      kao(:, 5, 4,10) = (/ &
     &2.1462e-02_r8,2.1863e-01_r8,4.3680e-01_r8,6.5519e-01_r8,8.7456e-01_r8,1.0957e+00_r8, &
     &1.3203e+00_r8,1.5569e+00_r8,1.7484e+00_r8/)
      kao(:, 1, 5,10) = (/ &
     &4.7130e-02_r8,9.3953e-02_r8,1.7393e-01_r8,2.6053e-01_r8,3.4731e-01_r8,4.3431e-01_r8, &
     &5.2182e-01_r8,6.1134e-01_r8,6.9380e-01_r8/)
      kao(:, 2, 5,10) = (/ &
     &4.5557e-02_r8,1.1245e-01_r8,2.1773e-01_r8,3.2619e-01_r8,4.3487e-01_r8,5.4373e-01_r8, &
     &6.5319e-01_r8,7.6497e-01_r8,8.6883e-01_r8/)
      kao(:, 3, 5,10) = (/ &
     &4.5179e-02_r8,1.3419e-01_r8,2.6606e-01_r8,3.9876e-01_r8,5.3167e-01_r8,6.6490e-01_r8, &
     &7.9898e-01_r8,9.3637e-01_r8,1.0624e+00_r8/)
      kao(:, 4, 5,10) = (/ &
     &4.5058e-02_r8,1.5943e-01_r8,3.1786e-01_r8,4.7639e-01_r8,6.3534e-01_r8,7.9462e-01_r8, &
     &9.5569e-01_r8,1.1218e+00_r8,1.2696e+00_r8/)
      kao(:, 5, 5,10) = (/ &
     &4.5124e-02_r8,1.8659e-01_r8,3.7199e-01_r8,5.5748e-01_r8,7.4317e-01_r8,9.2965e-01_r8, &
     &1.1179e+00_r8,1.3144e+00_r8,1.4843e+00_r8/)
      kao(:, 1, 6,10) = (/ &
     &9.1822e-02_r8,1.2595e-01_r8,1.5650e-01_r8,2.1453e-01_r8,2.8383e-01_r8,3.5468e-01_r8, &
     &4.2569e-01_r8,4.9790e-01_r8,5.6600e-01_r8/)
      kao(:, 2, 6,10) = (/ &
     &9.0834e-02_r8,1.3514e-01_r8,1.8905e-01_r8,2.7114e-01_r8,3.6116e-01_r8,4.5123e-01_r8, &
     &5.4153e-01_r8,6.3330e-01_r8,7.2013e-01_r8/)
      kao(:, 3, 6,10) = (/ &
     &9.0336e-02_r8,1.4401e-01_r8,2.2730e-01_r8,3.3603e-01_r8,4.4738e-01_r8,5.5884e-01_r8, &
     &6.7092e-01_r8,7.8481e-01_r8,8.9194e-01_r8/)
      kao(:, 4, 6,10) = (/ &
     &9.0439e-02_r8,1.5770e-01_r8,2.7084e-01_r8,4.0445e-01_r8,5.3847e-01_r8,6.7263e-01_r8, &
     &8.0760e-01_r8,9.4541e-01_r8,1.0734e+00_r8/)
      kao(:, 5, 6,10) = (/ &
     &8.9534e-02_r8,1.7535e-01_r8,3.1878e-01_r8,4.7665e-01_r8,6.3445e-01_r8,7.9249e-01_r8, &
     &9.5149e-01_r8,1.1135e+00_r8,1.2646e+00_r8/)
      kao(:, 1, 7,10) = (/ &
     &1.8704e-01_r8,2.0782e-01_r8,2.1870e-01_r8,2.2895e-01_r8,2.4473e-01_r8,2.8566e-01_r8, &
     &3.3903e-01_r8,3.9559e-01_r8,4.4999e-01_r8/)
      kao(:, 2, 7,10) = (/ &
     &1.8532e-01_r8,2.1563e-01_r8,2.3939e-01_r8,2.5636e-01_r8,3.0272e-01_r8,3.6581e-01_r8, &
     &4.3811e-01_r8,5.1140e-01_r8,5.8167e-01_r8/)
      kao(:, 3, 7,10) = (/ &
     &1.8680e-01_r8,2.2377e-01_r8,2.5927e-01_r8,2.9855e-01_r8,3.7097e-01_r8,4.5865e-01_r8, &
     &5.4953e-01_r8,6.4162e-01_r8,7.2947e-01_r8/)
      kao(:, 4, 7,10) = (/ &
     &1.8310e-01_r8,2.3512e-01_r8,2.8042e-01_r8,3.5020e-01_r8,4.4840e-01_r8,5.5852e-01_r8, &
     &6.6925e-01_r8,7.8169e-01_r8,8.8834e-01_r8/)
      kao(:, 5, 7,10) = (/ &
     &1.7882e-01_r8,2.4826e-01_r8,3.0849e-01_r8,4.0772e-01_r8,5.3530e-01_r8,6.6727e-01_r8, &
     &7.9969e-01_r8,9.3357e-01_r8,1.0615e+00_r8/)
      kao(:, 1, 8,10) = (/ &
     &4.1112e-01_r8,4.0974e-01_r8,4.1065e-01_r8,3.9316e-01_r8,3.5874e-01_r8,3.2789e-01_r8, &
     &2.9581e-01_r8,3.0764e-01_r8,1.9137e-01_r8/)
      kao(:, 2, 8,10) = (/ &
     &4.0366e-01_r8,4.2457e-01_r8,4.2635e-01_r8,4.1703e-01_r8,3.9720e-01_r8,3.6880e-01_r8, &
     &3.6253e-01_r8,4.0327e-01_r8,3.4592e-01_r8/)
      kao(:, 3, 8,10) = (/ &
     &3.8607e-01_r8,4.4207e-01_r8,4.4571e-01_r8,4.4555e-01_r8,4.3797e-01_r8,4.1894e-01_r8, &
     &4.4727e-01_r8,5.1245e-01_r8,5.5117e-01_r8/)
      kao(:, 4, 8,10) = (/ &
     &3.7227e-01_r8,4.5775e-01_r8,4.6855e-01_r8,4.7950e-01_r8,4.7625e-01_r8,4.8559e-01_r8, &
     &5.4513e-01_r8,6.3288e-01_r8,7.1148e-01_r8/)
      kao(:, 5, 8,10) = (/ &
     &3.6637e-01_r8,4.6773e-01_r8,4.9188e-01_r8,5.1329e-01_r8,5.2260e-01_r8,5.7072e-01_r8, &
     &6.6113e-01_r8,7.6991e-01_r8,8.6824e-01_r8/)
      kao(:, 1, 9,10) = (/ &
     &1.5096e+00_r8,1.3467e+00_r8,1.2191e+00_r8,1.0959e+00_r8,9.8221e-01_r8,8.6433e-01_r8, &
     &6.8915e-01_r8,4.5155e-01_r8,2.5455e-01_r8/)
      kao(:, 2, 9,10) = (/ &
     &1.4729e+00_r8,1.3283e+00_r8,1.2484e+00_r8,1.1515e+00_r8,1.0570e+00_r8,9.2603e-01_r8, &
     &7.4690e-01_r8,5.0470e-01_r8,3.4249e-01_r8/)
      kao(:, 3, 9,10) = (/ &
     &1.4533e+00_r8,1.3348e+00_r8,1.2453e+00_r8,1.1987e+00_r8,1.1351e+00_r8,9.9543e-01_r8, &
     &8.1023e-01_r8,5.6196e-01_r8,4.0591e-01_r8/)
      kao(:, 4, 9,10) = (/ &
     &1.4744e+00_r8,1.3676e+00_r8,1.2850e+00_r8,1.2602e+00_r8,1.1957e+00_r8,1.0697e+00_r8, &
     &8.6704e-01_r8,6.2711e-01_r8,4.8211e-01_r8/)
      kao(:, 5, 9,10) = (/ &
     &1.4999e+00_r8,1.4091e+00_r8,1.3355e+00_r8,1.3264e+00_r8,1.2721e+00_r8,1.1339e+00_r8, &
     &9.2252e-01_r8,7.1025e-01_r8,5.3091e-01_r8/)
      kao(:, 1,10,10) = (/ &
     &7.2829e+00_r8,6.3687e+00_r8,5.4628e+00_r8,4.5827e+00_r8,3.6816e+00_r8,2.8784e+00_r8, &
     &1.9461e+00_r8,1.1228e+00_r8,2.9615e-01_r8/)
      kao(:, 2,10,10) = (/ &
     &7.2567e+00_r8,6.3523e+00_r8,5.5013e+00_r8,4.6178e+00_r8,3.8060e+00_r8,2.8925e+00_r8, &
     &1.9877e+00_r8,1.2045e+00_r8,5.0840e-01_r8/)
      kao(:, 3,10,10) = (/ &
     &7.3526e+00_r8,6.4384e+00_r8,5.5471e+00_r8,4.6686e+00_r8,3.8188e+00_r8,2.9106e+00_r8, &
     &2.0584e+00_r8,1.3182e+00_r8,5.8969e-01_r8/)
      kao(:, 4,10,10) = (/ &
     &7.6517e+00_r8,6.6965e+00_r8,5.8098e+00_r8,4.9129e+00_r8,3.9609e+00_r8,3.0608e+00_r8, &
     &2.1952e+00_r8,1.4642e+00_r8,7.2061e-01_r8/)
      kao(:, 5,10,10) = (/ &
     &7.6682e+00_r8,6.7495e+00_r8,5.8665e+00_r8,4.9992e+00_r8,4.0971e+00_r8,3.1895e+00_r8, &
     &2.3244e+00_r8,1.6171e+00_r8,8.0277e-01_r8/)
      kao(:, 1,11,10) = (/ &
     &1.2863e+01_r8,1.1253e+01_r8,9.6455e+00_r8,8.0559e+00_r8,6.4984e+00_r8,4.9709e+00_r8, &
     &3.3831e+00_r8,1.7991e+00_r8,3.6644e-01_r8/)
      kao(:, 2,11,10) = (/ &
     &1.3151e+01_r8,1.1511e+01_r8,9.8627e+00_r8,8.2765e+00_r8,6.6703e+00_r8,5.1195e+00_r8, &
     &3.4235e+00_r8,1.8440e+00_r8,4.6729e-01_r8/)
      kao(:, 3,11,10) = (/ &
     &1.3385e+01_r8,1.1711e+01_r8,1.0081e+01_r8,8.4279e+00_r8,6.8536e+00_r8,5.2620e+00_r8, &
     &3.6394e+00_r8,1.9452e+00_r8,7.7574e-01_r8/)
      kao(:, 4,11,10) = (/ &
     &1.3506e+01_r8,1.1818e+01_r8,1.0183e+01_r8,8.6029e+00_r8,7.0409e+00_r8,5.3665e+00_r8, &
     &3.7651e+00_r8,2.0591e+00_r8,8.8231e-01_r8/)
      kao(:, 5,11,10) = (/ &
     &1.3392e+01_r8,1.1719e+01_r8,1.0115e+01_r8,8.6680e+00_r8,7.0525e+00_r8,5.5043e+00_r8, &
     &3.9029e+00_r8,2.2010e+00_r8,9.9688e-01_r8/)
      kao(:, 1,12,10) = (/ &
     &1.6670e+01_r8,1.4588e+01_r8,1.2501e+01_r8,1.0421e+01_r8,8.3941e+00_r8,6.4270e+00_r8, &
     &4.3660e+00_r8,2.2934e+00_r8,3.9405e-01_r8/)
      kao(:, 2,12,10) = (/ &
     &1.7105e+01_r8,1.4960e+01_r8,1.2826e+01_r8,1.0751e+01_r8,8.6199e+00_r8,6.6739e+00_r8, &
     &4.5154e+00_r8,2.4126e+00_r8,5.4759e-01_r8/)
      kao(:, 3,12,10) = (/ &
     &1.7307e+01_r8,1.5147e+01_r8,1.3016e+01_r8,1.0902e+01_r8,8.9354e+00_r8,6.8220e+00_r8, &
     &4.7181e+00_r8,2.5631e+00_r8,8.3787e-01_r8/)
      kao(:, 4,12,10) = (/ &
     &1.7279e+01_r8,1.5121e+01_r8,1.3042e+01_r8,1.0948e+01_r8,8.9655e+00_r8,6.8546e+00_r8, &
     &4.7965e+00_r8,2.6658e+00_r8,9.5310e-01_r8/)
      kao(:, 5,12,10) = (/ &
     &1.7622e+01_r8,1.5423e+01_r8,1.3295e+01_r8,1.1391e+01_r8,9.1951e+00_r8,7.1021e+00_r8, &
     &4.9630e+00_r8,2.7853e+00_r8,1.0381e+00_r8/)
      kao(:, 1,13,10) = (/ &
     &1.7285e+01_r8,1.5124e+01_r8,1.2963e+01_r8,1.0843e+01_r8,8.6958e+00_r8,6.7399e+00_r8, &
     &4.5324e+00_r8,2.3893e+00_r8,3.8223e-01_r8/)
      kao(:, 2,13,10) = (/ &
     &1.7394e+01_r8,1.5220e+01_r8,1.3045e+01_r8,1.0933e+01_r8,8.8783e+00_r8,6.8319e+00_r8, &
     &4.6535e+00_r8,2.5278e+00_r8,6.6322e-01_r8/)
      kao(:, 3,13,10) = (/ &
     &1.7534e+01_r8,1.5350e+01_r8,1.3222e+01_r8,1.1038e+01_r8,9.1270e+00_r8,6.8978e+00_r8, &
     &4.7818e+00_r8,2.6214e+00_r8,7.3123e-01_r8/)
      kao(:, 4,13,10) = (/ &
     &1.7891e+01_r8,1.5660e+01_r8,1.3479e+01_r8,1.1400e+01_r8,9.3159e+00_r8,7.0998e+00_r8, &
     &4.9577e+00_r8,2.7354e+00_r8,8.9654e-01_r8/)
      kao(:, 5,13,10) = (/ &
     &1.8019e+01_r8,1.5767e+01_r8,1.3610e+01_r8,1.1614e+01_r8,9.4166e+00_r8,7.3122e+00_r8, &
     &5.1530e+00_r8,2.8785e+00_r8,1.0692e+00_r8/)
      kao(:, 1, 1,11) = (/ &
     &3.1711e-03_r8,2.2841e-01_r8,4.5620e-01_r8,6.8299e-01_r8,9.0802e-01_r8,1.1291e+00_r8, &
     &1.3398e+00_r8,1.4993e+00_r8,1.8159e+00_r8/)
      kao(:, 2, 1,11) = (/ &
     &3.0704e-03_r8,2.7128e-01_r8,5.4234e-01_r8,8.1284e-01_r8,1.0822e+00_r8,1.3468e+00_r8, &
     &1.5998e+00_r8,1.7945e+00_r8,2.1643e+00_r8/)
      kao(:, 3, 1,11) = (/ &
     &2.9866e-03_r8,3.1478e-01_r8,6.2947e-01_r8,9.4408e-01_r8,1.2581e+00_r8,1.5709e+00_r8, &
     &1.8741e+00_r8,2.1028e+00_r8,2.5161e+00_r8/)
      kao(:, 4, 1,11) = (/ &
     &2.9163e-03_r8,3.5938e-01_r8,7.1835e-01_r8,1.0774e+00_r8,1.4362e+00_r8,1.7946e+00_r8, &
     &2.1451e+00_r8,2.4217e+00_r8,2.8722e+00_r8/)
      kao(:, 5, 1,11) = (/ &
     &2.8034e-03_r8,4.0521e-01_r8,8.0970e-01_r8,1.2136e+00_r8,1.6171e+00_r8,2.0187e+00_r8, &
     &2.4125e+00_r8,2.7343e+00_r8,3.2340e+00_r8/)
      kao(:, 1, 2,11) = (/ &
     &5.2383e-03_r8,2.1282e-01_r8,4.2542e-01_r8,6.3727e-01_r8,8.4863e-01_r8,1.0581e+00_r8, &
     &1.2660e+00_r8,1.4631e+00_r8,1.6971e+00_r8/)
      kao(:, 2, 2,11) = (/ &
     &5.1027e-03_r8,2.5414e-01_r8,5.0811e-01_r8,7.6215e-01_r8,1.0157e+00_r8,1.2690e+00_r8, &
     &1.5182e+00_r8,1.7540e+00_r8,2.0313e+00_r8/)
      kao(:, 3, 2,11) = (/ &
     &4.9821e-03_r8,2.9639e-01_r8,5.9276e-01_r8,8.8910e-01_r8,1.1857e+00_r8,1.4825e+00_r8, &
     &1.7783e+00_r8,2.0622e+00_r8,2.3711e+00_r8/)
      kao(:, 4, 2,11) = (/ &
     &4.8330e-03_r8,3.4110e-01_r8,6.8181e-01_r8,1.0221e+00_r8,1.3622e+00_r8,1.7021e+00_r8, &
     &2.0428e+00_r8,2.3773e+00_r8,2.7241e+00_r8/)
      kao(:, 5, 2,11) = (/ &
     &4.6466e-03_r8,3.8845e-01_r8,7.7604e-01_r8,1.1627e+00_r8,1.5479e+00_r8,1.9317e+00_r8, &
     &2.3125e+00_r8,2.6917e+00_r8,3.0955e+00_r8/)
      kao(:, 1, 3,11) = (/ &
     &1.1968e-02_r8,1.8925e-01_r8,3.7814e-01_r8,5.6720e-01_r8,7.5640e-01_r8,9.4598e-01_r8, &
     &1.1354e+00_r8,1.3192e+00_r8,1.5123e+00_r8/)
      kao(:, 2, 3,11) = (/ &
     &1.1738e-02_r8,2.2858e-01_r8,4.5676e-01_r8,6.8520e-01_r8,9.1426e-01_r8,1.1439e+00_r8, &
     &1.3747e+00_r8,1.6035e+00_r8,1.8280e+00_r8/)
      kao(:, 3, 3,11) = (/ &
     &1.1441e-02_r8,2.7028e-01_r8,5.3999e-01_r8,8.0979e-01_r8,1.0799e+00_r8,1.3506e+00_r8, &
     &1.6224e+00_r8,1.8949e+00_r8,2.1592e+00_r8/)
      kao(:, 4, 3,11) = (/ &
     &1.1066e-02_r8,3.1556e-01_r8,6.3024e-01_r8,9.4495e-01_r8,1.2595e+00_r8,1.5736e+00_r8, &
     &1.8868e+00_r8,2.1970e+00_r8,2.5183e+00_r8/)
      kao(:, 5, 3,11) = (/ &
     &1.0627e-02_r8,3.6442e-01_r8,7.2807e-01_r8,1.0914e+00_r8,1.4538e+00_r8,1.8154e+00_r8, &
     &2.1726e+00_r8,2.5191e+00_r8,2.9067e+00_r8/)
      kao(:, 1, 4,11) = (/ &
     &2.8048e-02_r8,1.6151e-01_r8,3.2202e-01_r8,4.8262e-01_r8,6.4375e-01_r8,8.0530e-01_r8, &
     &9.6854e-01_r8,1.1364e+00_r8,1.2863e+00_r8/)
      kao(:, 2, 4,11) = (/ &
     &2.7460e-02_r8,1.9867e-01_r8,3.9620e-01_r8,5.9396e-01_r8,7.9208e-01_r8,9.9102e-01_r8, &
     &1.1917e+00_r8,1.3983e+00_r8,1.5828e+00_r8/)
      kao(:, 3, 4,11) = (/ &
     &2.6672e-02_r8,2.3899e-01_r8,4.7658e-01_r8,7.1429e-01_r8,9.5231e-01_r8,1.1913e+00_r8, &
     &1.4318e+00_r8,1.6791e+00_r8,1.9031e+00_r8/)
      kao(:, 4, 4,11) = (/ &
     &2.5665e-02_r8,2.8345e-01_r8,5.6525e-01_r8,8.4715e-01_r8,1.1294e+00_r8,1.4117e+00_r8, &
     &1.6956e+00_r8,1.9833e+00_r8,2.2571e+00_r8/)
      kao(:, 5, 4,11) = (/ &
     &2.4958e-02_r8,3.3271e-01_r8,6.6383e-01_r8,9.9466e-01_r8,1.3259e+00_r8,1.6572e+00_r8, &
     &1.9874e+00_r8,2.3183e+00_r8,2.6500e+00_r8/)
      kao(:, 1, 5,11) = (/ &
     &5.9740e-02_r8,1.3717e-01_r8,2.6992e-01_r8,4.0387e-01_r8,5.3789e-01_r8,6.7238e-01_r8, &
     &8.0752e-01_r8,9.4549e-01_r8,1.0734e+00_r8/)
      kao(:, 2, 5,11) = (/ &
     &5.8323e-02_r8,1.6942e-01_r8,3.3625e-01_r8,5.0313e-01_r8,6.7036e-01_r8,8.3790e-01_r8, &
     &1.0063e+00_r8,1.1790e+00_r8,1.3380e+00_r8/)
      kao(:, 3, 5,11) = (/ &
     &5.6700e-02_r8,2.0744e-01_r8,4.1183e-01_r8,6.1629e-01_r8,8.2117e-01_r8,1.0263e+00_r8, &
     &1.2326e+00_r8,1.4427e+00_r8,1.6392e+00_r8/)
      kao(:, 4, 5,11) = (/ &
     &5.4845e-02_r8,2.5070e-01_r8,4.9802e-01_r8,7.4525e-01_r8,9.9296e-01_r8,1.2407e+00_r8, &
     &1.4895e+00_r8,1.7409e+00_r8,1.9825e+00_r8/)
      kao(:, 5, 5,11) = (/ &
     &5.3384e-02_r8,2.9836e-01_r8,5.9305e-01_r8,8.8824e-01_r8,1.1834e+00_r8,1.4792e+00_r8, &
     &1.7758e+00_r8,2.0754e+00_r8,2.3639e+00_r8/)
      kao(:, 1, 6,11) = (/ &
     &1.1443e-01_r8,1.5330e-01_r8,2.2814e-01_r8,3.3358e-01_r8,4.4343e-01_r8,5.5347e-01_r8, &
     &6.6399e-01_r8,7.7608e-01_r8,8.8294e-01_r8/)
      kao(:, 2, 6,11) = (/ &
     &1.1139e-01_r8,1.6753e-01_r8,2.8410e-01_r8,4.2322e-01_r8,5.6271e-01_r8,7.0257e-01_r8, &
     &8.4275e-01_r8,9.8447e-01_r8,1.1213e+00_r8/)
      kao(:, 3, 6,11) = (/ &
     &1.0816e-01_r8,1.9391e-01_r8,3.5154e-01_r8,5.2463e-01_r8,6.9799e-01_r8,8.7181e-01_r8, &
     &1.0460e+00_r8,1.2220e+00_r8,1.3917e+00_r8/)
      kao(:, 4, 6,11) = (/ &
     &1.0514e-01_r8,2.2522e-01_r8,4.2775e-01_r8,6.3893e-01_r8,8.5037e-01_r8,1.0626e+00_r8, &
     &1.2753e+00_r8,1.4901e+00_r8,1.6964e+00_r8/)
      kao(:, 5, 6,11) = (/ &
     &1.0414e-01_r8,2.6189e-01_r8,5.1110e-01_r8,7.6424e-01_r8,1.0178e+00_r8,1.2716e+00_r8, &
     &1.5264e+00_r8,1.7854e+00_r8,2.0311e+00_r8/)
      kao(:, 1, 7,11) = (/ &
     &2.3680e-01_r8,2.5474e-01_r8,2.7467e-01_r8,2.9968e-01_r8,3.6549e-01_r8,4.4931e-01_r8, &
     &5.3835e-01_r8,6.2811e-01_r8,7.1559e-01_r8/)
      kao(:, 2, 7,11) = (/ &
     &2.3126e-01_r8,2.6667e-01_r8,2.9742e-01_r8,3.6770e-01_r8,4.6828e-01_r8,5.8355e-01_r8, &
     &6.9932e-01_r8,8.1593e-01_r8,9.2966e-01_r8/)
      kao(:, 3, 7,11) = (/ &
     &2.2333e-01_r8,2.8145e-01_r8,3.3561e-01_r8,4.4803e-01_r8,5.8828e-01_r8,7.3378e-01_r8, &
     &8.7969e-01_r8,1.0266e+00_r8,1.1700e+00_r8/)
      kao(:, 4, 7,11) = (/ &
     &2.2006e-01_r8,2.9370e-01_r8,3.8943e-01_r8,5.4388e-01_r8,7.2193e-01_r8,9.0087e-01_r8, &
     &1.0804e+00_r8,1.2609e+00_r8,1.4372e+00_r8/)
      kao(:, 5, 7,11) = (/ &
     &2.1836e-01_r8,3.0927e-01_r8,4.5013e-01_r8,6.5145e-01_r8,8.6638e-01_r8,1.0814e+00_r8, &
     &1.2967e+00_r8,1.5147e+00_r8,1.7257e+00_r8/)
      kao(:, 1, 8,11) = (/ &
     &5.7508e-01_r8,5.5228e-01_r8,5.1832e-01_r8,4.8920e-01_r8,4.5962e-01_r8,4.2790e-01_r8, &
     &4.4544e-01_r8,5.0496e-01_r8,5.4406e-01_r8/)
      kao(:, 2, 8,11) = (/ &
     &5.5570e-01_r8,5.5086e-01_r8,5.3954e-01_r8,5.2836e-01_r8,5.0571e-01_r8,5.1612e-01_r8, &
     &5.7597e-01_r8,6.6763e-01_r8,7.6063e-01_r8/)
      kao(:, 3, 8,11) = (/ &
     &5.4644e-01_r8,5.5917e-01_r8,5.6849e-01_r8,5.6772e-01_r8,5.6845e-01_r8,6.3045e-01_r8, &
     &7.3261e-01_r8,8.5320e-01_r8,9.7237e-01_r8/)
      kao(:, 4, 8,11) = (/ &
     &5.4298e-01_r8,5.6882e-01_r8,5.9693e-01_r8,6.1038e-01_r8,6.5823e-01_r8,7.6720e-01_r8, &
     &9.1091e-01_r8,1.0615e+00_r8,1.2099e+00_r8/)
      kao(:, 5, 8,11) = (/ &
     &5.3663e-01_r8,5.8485e-01_r8,6.2913e-01_r8,6.6732e-01_r8,7.6736e-01_r8,9.2195e-01_r8, &
     &1.1025e+00_r8,1.2850e+00_r8,1.4649e+00_r8/)
      kao(:, 1, 9,11) = (/ &
     &2.5279e+00_r8,2.2431e+00_r8,2.0106e+00_r8,1.7600e+00_r8,1.4790e+00_r8,1.2051e+00_r8, &
     &8.9590e-01_r8,5.8517e-01_r8,3.0795e-01_r8/)
      kao(:, 2, 9,11) = (/ &
     &2.4601e+00_r8,2.1917e+00_r8,2.0103e+00_r8,1.7592e+00_r8,1.5280e+00_r8,1.2575e+00_r8, &
     &9.5967e-01_r8,6.7082e-01_r8,3.9930e-01_r8/)
      kao(:, 3, 9,11) = (/ &
     &2.4168e+00_r8,2.1757e+00_r8,2.0177e+00_r8,1.7994e+00_r8,1.5699e+00_r8,1.3186e+00_r8, &
     &1.0425e+00_r8,7.7727e-01_r8,5.2484e-01_r8/)
      kao(:, 4, 9,11) = (/ &
     &2.3770e+00_r8,2.1985e+00_r8,2.0410e+00_r8,1.8443e+00_r8,1.6274e+00_r8,1.3869e+00_r8, &
     &1.1288e+00_r8,9.2337e-01_r8,5.9212e-01_r8/)
      kao(:, 5, 9,11) = (/ &
     &2.3400e+00_r8,2.1850e+00_r8,2.0960e+00_r8,1.9025e+00_r8,1.6878e+00_r8,1.4602e+00_r8, &
     &1.2280e+00_r8,1.0954e+00_r8,7.2073e-01_r8/)
      kao(:, 1,10,11) = (/ &
     &1.1112e+01_r8,9.7248e+00_r8,8.3361e+00_r8,7.0270e+00_r8,5.7440e+00_r8,4.5096e+00_r8, &
     &3.2779e+00_r8,1.8950e+00_r8,4.0940e-01_r8/)
      kao(:, 2,10,11) = (/ &
     &1.0924e+01_r8,9.5564e+00_r8,8.1917e+00_r8,6.9650e+00_r8,5.7085e+00_r8,4.6298e+00_r8, &
     &3.3486e+00_r8,2.0156e+00_r8,4.6752e-01_r8/)
      kao(:, 3,10,11) = (/ &
     &1.0832e+01_r8,9.4781e+00_r8,8.2229e+00_r8,6.9872e+00_r8,5.8796e+00_r8,4.6954e+00_r8, &
     &3.5108e+00_r8,2.1192e+00_r8,8.0168e-01_r8/)
      kao(:, 4,10,11) = (/ &
     &1.0490e+01_r8,9.1768e+00_r8,8.0065e+00_r8,6.9497e+00_r8,5.9506e+00_r8,4.7816e+00_r8, &
     &3.6391e+00_r8,2.2227e+00_r8,9.3825e-01_r8/)
      kao(:, 5,10,11) = (/ &
     &1.0399e+01_r8,9.1010e+00_r8,8.0219e+00_r8,7.0325e+00_r8,5.9506e+00_r8,4.9243e+00_r8, &
     &3.8048e+00_r8,2.3499e+00_r8,1.1716e+00_r8/)
      kao(:, 1,11,11) = (/ &
     &1.6964e+01_r8,1.4849e+01_r8,1.2726e+01_r8,1.0607e+01_r8,8.5722e+00_r8,6.5304e+00_r8, &
     &4.5723e+00_r8,2.5353e+00_r8,5.7715e-01_r8/)
      kao(:, 2,11,11) = (/ &
     &1.6824e+01_r8,1.4725e+01_r8,1.2623e+01_r8,1.0586e+01_r8,8.5709e+00_r8,6.6756e+00_r8, &
     &4.7183e+00_r8,2.7595e+00_r8,6.2192e-01_r8/)
      kao(:, 3,11,11) = (/ &
     &1.6755e+01_r8,1.4665e+01_r8,1.2572e+01_r8,1.0610e+01_r8,8.6759e+00_r8,6.8661e+00_r8, &
     &4.7973e+00_r8,2.9494e+00_r8,7.1889e-01_r8/)
      kao(:, 4,11,11) = (/ &
     &1.6922e+01_r8,1.4802e+01_r8,1.2769e+01_r8,1.0738e+01_r8,8.9005e+00_r8,6.9130e+00_r8, &
     &5.0022e+00_r8,3.1663e+00_r8,1.1906e+00_r8/)
      kao(:, 5,11,11) = (/ &
     &1.7198e+01_r8,1.5045e+01_r8,1.3001e+01_r8,1.1038e+01_r8,9.0834e+00_r8,7.0679e+00_r8, &
     &5.2222e+00_r8,3.3529e+00_r8,1.3885e+00_r8/)
      kao(:, 1,12,11) = (/ &
     &2.1802e+01_r8,1.9077e+01_r8,1.6353e+01_r8,1.3626e+01_r8,1.0986e+01_r8,8.2719e+00_r8, &
     &5.7215e+00_r8,2.9889e+00_r8,6.5084e-01_r8/)
      kao(:, 2,12,11) = (/ &
     &2.2052e+01_r8,1.9310e+01_r8,1.6546e+01_r8,1.3830e+01_r8,1.1139e+01_r8,8.5492e+00_r8, &
     &5.8655e+00_r8,3.1860e+00_r8,7.2046e-01_r8/)
      kao(:, 3,12,11) = (/ &
     &2.2451e+01_r8,1.9654e+01_r8,1.6841e+01_r8,1.4123e+01_r8,1.1335e+01_r8,8.7814e+00_r8, &
     &5.9237e+00_r8,3.3098e+00_r8,8.3218e-01_r8/)
      kao(:, 4,12,11) = (/ &
     &2.3090e+01_r8,2.0216e+01_r8,1.7353e+01_r8,1.4511e+01_r8,1.1935e+01_r8,9.0228e+00_r8, &
     &6.2499e+00_r8,3.5354e+00_r8,1.3462e+00_r8/)
      kao(:, 5,12,11) = (/ &
     &2.3297e+01_r8,2.0383e+01_r8,1.7601e+01_r8,1.4664e+01_r8,1.2080e+01_r8,9.1910e+00_r8, &
     &6.4263e+00_r8,3.7093e+00_r8,1.5753e+00_r8/)
      kao(:, 1,13,11) = (/ &
     &2.3137e+01_r8,2.0253e+01_r8,1.7360e+01_r8,1.4461e+01_r8,1.1660e+01_r8,8.7711e+00_r8, &
     &6.0766e+00_r8,3.2004e+00_r8,6.2333e-01_r8/)
      kao(:, 2,13,11) = (/ &
     &2.3705e+01_r8,2.0739e+01_r8,1.7789e+01_r8,1.4919e+01_r8,1.1958e+01_r8,9.2720e+00_r8, &
     &6.2579e+00_r8,3.3419e+00_r8,6.6494e-01_r8/)
      kao(:, 3,13,11) = (/ &
     &2.4274e+01_r8,2.1226e+01_r8,1.8190e+01_r8,1.5260e+01_r8,1.2326e+01_r8,9.5663e+00_r8, &
     &6.4788e+00_r8,3.4909e+00_r8,1.1201e+00_r8/)
      kao(:, 4,13,11) = (/ &
     &2.4386e+01_r8,2.1333e+01_r8,1.8377e+01_r8,1.5357e+01_r8,1.2667e+01_r8,9.6781e+00_r8, &
     &6.7508e+00_r8,3.6779e+00_r8,1.3420e+00_r8/)
      kao(:, 5,13,11) = (/ &
     &2.4394e+01_r8,2.1348e+01_r8,1.8396e+01_r8,1.5507e+01_r8,1.2756e+01_r8,9.7415e+00_r8, &
     &6.8863e+00_r8,3.8176e+00_r8,1.6819e+00_r8/)
      kao(:, 1, 1,12) = (/ &
     &3.7292e-03_r8,3.2906e-01_r8,6.5580e-01_r8,9.7933e-01_r8,1.2975e+00_r8,1.6059e+00_r8, &
     &1.8953e+00_r8,2.1342e+00_r8,2.5948e+00_r8/)
      kao(:, 2, 1,12) = (/ &
     &3.6338e-03_r8,3.9331e-01_r8,7.8289e-01_r8,1.1672e+00_r8,1.5430e+00_r8,1.9051e+00_r8, &
     &2.2331e+00_r8,2.4741e+00_r8,3.0857e+00_r8/)
      kao(:, 3, 1,12) = (/ &
     &3.5564e-03_r8,4.6323e-01_r8,9.2190e-01_r8,1.3739e+00_r8,1.8144e+00_r8,2.2323e+00_r8, &
     &2.6037e+00_r8,2.8683e+00_r8,3.6286e+00_r8/)
      kao(:, 4, 1,12) = (/ &
     &3.4829e-03_r8,5.3356e-01_r8,1.0626e+00_r8,1.5845e+00_r8,2.0933e+00_r8,2.5784e+00_r8, &
     &3.0158e+00_r8,3.3179e+00_r8,4.1863e+00_r8/)
      kao(:, 5, 1,12) = (/ &
     &3.4329e-03_r8,6.0324e-01_r8,1.2029e+00_r8,1.7965e+00_r8,2.3794e+00_r8,2.9402e+00_r8, &
     &3.4530e+00_r8,3.8265e+00_r8,4.7585e+00_r8/)
      kao(:, 1, 2,12) = (/ &
     &6.2080e-03_r8,3.1766e-01_r8,6.3367e-01_r8,9.4784e-01_r8,1.2588e+00_r8,1.5639e+00_r8, &
     &1.8558e+00_r8,2.1035e+00_r8,2.5172e+00_r8/)
      kao(:, 2, 2,12) = (/ &
     &6.0635e-03_r8,3.8413e-01_r8,7.6634e-01_r8,1.1462e+00_r8,1.5215e+00_r8,1.8884e+00_r8, &
     &2.2355e+00_r8,2.5176e+00_r8,3.0427e+00_r8/)
      kao(:, 3, 2,12) = (/ &
     &5.9382e-03_r8,4.5423e-01_r8,9.0644e-01_r8,1.3562e+00_r8,1.8011e+00_r8,2.2367e+00_r8, &
     &2.6480e+00_r8,2.9724e+00_r8,3.6017e+00_r8/)
      kao(:, 4, 2,12) = (/ &
     &5.8323e-03_r8,5.2519e-01_r8,1.0487e+00_r8,1.5700e+00_r8,2.0875e+00_r8,2.5951e+00_r8, &
     &3.0747e+00_r8,3.4387e+00_r8,4.1744e+00_r8/)
      kao(:, 5, 2,12) = (/ &
     &5.7338e-03_r8,5.9386e-01_r8,1.1863e+00_r8,1.7768e+00_r8,2.3632e+00_r8,2.9403e+00_r8, &
     &3.4914e+00_r8,3.9302e+00_r8,4.7260e+00_r8/)
      kao(:, 1, 3,12) = (/ &
     &1.4176e-02_r8,2.8836e-01_r8,5.7586e-01_r8,8.6297e-01_r8,1.1493e+00_r8,1.4343e+00_r8, &
     &1.7160e+00_r8,1.9825e+00_r8,2.2980e+00_r8/)
      kao(:, 2, 3,12) = (/ &
     &1.3806e-02_r8,3.5186e-01_r8,7.0276e-01_r8,1.0533e+00_r8,1.4030e+00_r8,1.7510e+00_r8, &
     &2.0945e+00_r8,2.4186e+00_r8,2.8053e+00_r8/)
      kao(:, 3, 3,12) = (/ &
     &1.3514e-02_r8,4.1890e-01_r8,8.3697e-01_r8,1.2547e+00_r8,1.6718e+00_r8,2.0870e+00_r8, &
     &2.4990e+00_r8,2.8908e+00_r8,3.3428e+00_r8/)
      kao(:, 4, 3,12) = (/ &
     &1.3249e-02_r8,4.8707e-01_r8,9.7331e-01_r8,1.4597e+00_r8,1.9459e+00_r8,2.4316e+00_r8, &
     &2.9156e+00_r8,3.3828e+00_r8,3.8910e+00_r8/)
      kao(:, 5, 3,12) = (/ &
     &1.3015e-02_r8,5.5537e-01_r8,1.1100e+00_r8,1.6644e+00_r8,2.2195e+00_r8,2.7745e+00_r8, &
     &3.3300e+00_r8,3.8734e+00_r8,4.4382e+00_r8/)
      kao(:, 1, 4,12) = (/ &
     &3.3184e-02_r8,2.5339e-01_r8,5.0565e-01_r8,7.5787e-01_r8,1.0100e+00_r8,1.2620e+00_r8, &
     &1.5135e+00_r8,1.7634e+00_r8,2.0190e+00_r8/)
      kao(:, 2, 4,12) = (/ &
     &3.2427e-02_r8,3.1318e-01_r8,6.2514e-01_r8,9.3708e-01_r8,1.2489e+00_r8,1.5601e+00_r8, &
     &1.8704e+00_r8,2.1781e+00_r8,2.4966e+00_r8/)
      kao(:, 3, 4,12) = (/ &
     &3.1776e-02_r8,3.7781e-01_r8,7.5434e-01_r8,1.1309e+00_r8,1.5072e+00_r8,1.8833e+00_r8, &
     &2.2580e+00_r8,2.6266e+00_r8,3.0132e+00_r8/)
      kao(:, 4, 4,12) = (/ &
     &3.1130e-02_r8,4.4383e-01_r8,8.8640e-01_r8,1.3292e+00_r8,1.7718e+00_r8,2.2142e+00_r8, &
     &2.6572e+00_r8,3.0981e+00_r8,3.5423e+00_r8/)
      kao(:, 5, 4,12) = (/ &
     &3.0303e-02_r8,5.1080e-01_r8,1.0203e+00_r8,1.5301e+00_r8,2.0399e+00_r8,2.5495e+00_r8, &
     &3.0593e+00_r8,3.5718e+00_r8,4.0785e+00_r8/)
      kao(:, 1, 5,12) = (/ &
     &7.0197e-02_r8,2.2033e-01_r8,4.3908e-01_r8,6.5775e-01_r8,8.7643e-01_r8,1.0950e+00_r8, &
     &1.3134e+00_r8,1.5311e+00_r8,1.7514e+00_r8/)
      kao(:, 2, 5,12) = (/ &
     &6.8848e-02_r8,2.7720e-01_r8,5.5265e-01_r8,8.2808e-01_r8,1.1036e+00_r8,1.3787e+00_r8, &
     &1.6538e+00_r8,1.9275e+00_r8,2.2056e+00_r8/)
      kao(:, 3, 5,12) = (/ &
     &6.6971e-02_r8,3.3853e-01_r8,6.7513e-01_r8,1.0119e+00_r8,1.3485e+00_r8,1.6854e+00_r8, &
     &2.0224e+00_r8,2.3592e+00_r8,2.6952e+00_r8/)
      kao(:, 4, 5,12) = (/ &
     &6.5365e-02_r8,4.0161e-01_r8,8.0132e-01_r8,1.2011e+00_r8,1.6012e+00_r8,2.0009e+00_r8, &
     &2.4008e+00_r8,2.8038e+00_r8,3.2005e+00_r8/)
      kao(:, 5, 5,12) = (/ &
     &6.3431e-02_r8,4.6828e-01_r8,9.3456e-01_r8,1.4005e+00_r8,1.8671e+00_r8,2.3331e+00_r8, &
     &2.7981e+00_r8,3.2640e+00_r8,3.7323e+00_r8/)
      kao(:, 1, 6,12) = (/ &
     &1.3973e-01_r8,2.0662e-01_r8,3.6962e-01_r8,5.5318e-01_r8,7.3681e-01_r8,9.2064e-01_r8, &
     &1.1045e+00_r8,1.2891e+00_r8,1.4713e+00_r8/)
      kao(:, 2, 6,12) = (/ &
     &1.3671e-01_r8,2.4877e-01_r8,4.7403e-01_r8,7.0978e-01_r8,9.4572e-01_r8,1.1814e+00_r8, &
     &1.4179e+00_r8,1.6551e+00_r8,1.8888e+00_r8/)
      kao(:, 3, 6,12) = (/ &
     &1.3368e-01_r8,2.9917e-01_r8,5.8968e-01_r8,8.8312e-01_r8,1.1767e+00_r8,1.4704e+00_r8, &
     &1.7646e+00_r8,2.0602e+00_r8,2.3507e+00_r8/)
      kao(:, 4, 6,12) = (/ &
     &1.2994e-01_r8,3.5894e-01_r8,7.1459e-01_r8,1.0704e+00_r8,1.4263e+00_r8,1.7824e+00_r8, &
     &2.1385e+00_r8,2.4959e+00_r8,2.8498e+00_r8/)
      kao(:, 5, 6,12) = (/ &
     &1.2525e-01_r8,4.2650e-01_r8,8.4975e-01_r8,1.2729e+00_r8,1.6963e+00_r8,2.1200e+00_r8, &
     &2.5435e+00_r8,2.9674e+00_r8,3.3897e+00_r8/)
      kao(:, 1, 7,12) = (/ &
     &2.8974e-01_r8,3.1610e-01_r8,3.5823e-01_r8,4.6930e-01_r8,6.1329e-01_r8,7.6583e-01_r8, &
     &9.1850e-01_r8,1.0715e+00_r8,1.2231e+00_r8/)
      kao(:, 2, 7,12) = (/ &
     &2.8480e-01_r8,3.2946e-01_r8,4.3038e-01_r8,6.0019e-01_r8,7.9796e-01_r8,9.9665e-01_r8, &
     &1.1955e+00_r8,1.3949e+00_r8,1.5921e+00_r8/)
      kao(:, 3, 7,12) = (/ &
     &2.7871e-01_r8,3.5067e-01_r8,5.1857e-01_r8,7.5801e-01_r8,1.0094e+00_r8,1.2608e+00_r8, &
     &1.5125e+00_r8,1.7653e+00_r8,2.0145e+00_r8/)
      kao(:, 4, 7,12) = (/ &
     &2.7300e-01_r8,3.8461e-01_r8,6.2621e-01_r8,9.3301e-01_r8,1.2423e+00_r8,1.5518e+00_r8, &
     &1.8620e+00_r8,2.1734e+00_r8,2.4799e+00_r8/)
      kao(:, 5, 7,12) = (/ &
     &2.6591e-01_r8,4.2736e-01_r8,7.5270e-01_r8,1.1266e+00_r8,1.5003e+00_r8,1.8747e+00_r8, &
     &2.2489e+00_r8,2.6247e+00_r8,2.9958e+00_r8/)
      kao(:, 1, 8,12) = (/ &
     &7.1395e-01_r8,6.8533e-01_r8,6.5866e-01_r8,6.2646e-01_r8,6.1056e-01_r8,6.5589e-01_r8, &
     &7.5232e-01_r8,8.7691e-01_r8,1.0005e+00_r8/)
      kao(:, 2, 8,12) = (/ &
     &7.0494e-01_r8,6.9398e-01_r8,6.9094e-01_r8,6.7668e-01_r8,7.2746e-01_r8,8.4153e-01_r8, &
     &1.0006e+00_r8,1.1668e+00_r8,1.3319e+00_r8/)
      kao(:, 3, 8,12) = (/ &
     &6.9397e-01_r8,7.0598e-01_r8,7.2266e-01_r8,7.6185e-01_r8,8.8476e-01_r8,1.0705e+00_r8, &
     &1.2831e+00_r8,1.4961e+00_r8,1.7076e+00_r8/)
      kao(:, 4, 8,12) = (/ &
     &6.8087e-01_r8,7.2362e-01_r8,7.6721e-01_r8,8.7767e-01_r8,1.0787e+00_r8,1.3359e+00_r8, &
     &1.6015e+00_r8,1.8678e+00_r8,2.1324e+00_r8/)
      kao(:, 5, 8,12) = (/ &
     &6.7139e-01_r8,7.3688e-01_r8,8.3187e-01_r8,1.0246e+00_r8,1.3106e+00_r8,1.6352e+00_r8, &
     &1.9607e+00_r8,2.2865e+00_r8,2.6110e+00_r8/)
      kao(:, 1, 9,12) = (/ &
     &3.4095e+00_r8,2.9940e+00_r8,2.6084e+00_r8,2.2712e+00_r8,1.8987e+00_r8,1.5323e+00_r8, &
     &1.1724e+00_r8,8.1780e-01_r8,4.0421e-01_r8/)
      kao(:, 2, 9,12) = (/ &
     &3.3693e+00_r8,2.9832e+00_r8,2.6354e+00_r8,2.2978e+00_r8,1.9462e+00_r8,1.6166e+00_r8, &
     &1.2713e+00_r8,1.0128e+00_r8,5.1858e-01_r8/)
      kao(:, 3, 9,12) = (/ &
     &3.3273e+00_r8,2.9606e+00_r8,2.6476e+00_r8,2.3138e+00_r8,2.0240e+00_r8,1.7033e+00_r8, &
     &1.3935e+00_r8,1.2814e+00_r8,6.1493e-01_r8/)
      kao(:, 4, 9,12) = (/ &
     &3.2577e+00_r8,2.9148e+00_r8,2.6437e+00_r8,2.3667e+00_r8,2.0968e+00_r8,1.8097e+00_r8, &
     &1.5817e+00_r8,1.6061e+00_r8,8.7818e-01_r8/)
      kao(:, 5, 9,12) = (/ &
     &3.1999e+00_r8,2.9208e+00_r8,2.6366e+00_r8,2.4121e+00_r8,2.1879e+00_r8,1.9394e+00_r8, &
     &1.8270e+00_r8,1.9776e+00_r8,1.4315e+00_r8/)
      kao(:, 1,10,12) = (/ &
     &1.8080e+01_r8,1.5820e+01_r8,1.3560e+01_r8,1.1300e+01_r8,9.1208e+00_r8,6.9174e+00_r8, &
     &4.8050e+00_r8,2.5816e+00_r8,5.9225e-01_r8/)
      kao(:, 2,10,12) = (/ &
     &1.7863e+01_r8,1.5633e+01_r8,1.3401e+01_r8,1.1233e+01_r8,9.0719e+00_r8,6.9705e+00_r8, &
     &4.8769e+00_r8,2.6813e+00_r8,6.3411e-01_r8/)
      kao(:, 3,10,12) = (/ &
     &1.7446e+01_r8,1.5265e+01_r8,1.3103e+01_r8,1.1057e+01_r8,9.0250e+00_r8,7.0448e+00_r8, &
     &4.8922e+00_r8,2.7949e+00_r8,7.0806e-01_r8/)
      kao(:, 4,10,12) = (/ &
     &1.7175e+01_r8,1.5031e+01_r8,1.2961e+01_r8,1.0925e+01_r8,8.9744e+00_r8,7.0129e+00_r8, &
     &4.9823e+00_r8,2.9347e+00_r8,1.2270e+00_r8/)
      kao(:, 5,10,12) = (/ &
     &1.6980e+01_r8,1.4865e+01_r8,1.2847e+01_r8,1.0927e+01_r8,9.0016e+00_r8,7.0557e+00_r8, &
     &5.0460e+00_r8,3.0782e+00_r8,1.3161e+00_r8/)
      kao(:, 1,11,12) = (/ &
     &3.1621e+01_r8,2.7664e+01_r8,2.3716e+01_r8,1.9762e+01_r8,1.5836e+01_r8,1.2028e+01_r8, &
     &8.3404e+00_r8,4.4951e+00_r8,7.7226e-01_r8/)
      kao(:, 2,11,12) = (/ &
     &3.1089e+01_r8,2.7197e+01_r8,2.3314e+01_r8,1.9432e+01_r8,1.5688e+01_r8,1.1946e+01_r8, &
     &8.4568e+00_r8,4.5500e+00_r8,1.2396e+00_r8/)
      kao(:, 3,11,12) = (/ &
     &3.0576e+01_r8,2.6758e+01_r8,2.2933e+01_r8,1.9212e+01_r8,1.5533e+01_r8,1.1953e+01_r8, &
     &8.4697e+00_r8,4.6829e+00_r8,1.0564e+00_r8/)
      kao(:, 4,11,12) = (/ &
     &3.0097e+01_r8,2.6346e+01_r8,2.2583e+01_r8,1.9026e+01_r8,1.5507e+01_r8,1.2181e+01_r8, &
     &8.5232e+00_r8,4.7855e+00_r8,1.0613e+00_r8/)
      kao(:, 5,11,12) = (/ &
     &2.9719e+01_r8,2.6007e+01_r8,2.2377e+01_r8,1.8843e+01_r8,1.5650e+01_r8,1.2244e+01_r8, &
     &8.6646e+00_r8,4.9270e+00_r8,1.7788e+00_r8/)
      kao(:, 1,12,12) = (/ &
     &3.8089e+01_r8,3.3321e+01_r8,2.8563e+01_r8,2.3805e+01_r8,1.9048e+01_r8,1.4479e+01_r8, &
     &1.0042e+01_r8,5.5700e+00_r8,1.0139e+00_r8/)
      kao(:, 2,12,12) = (/ &
     &3.7254e+01_r8,3.2590e+01_r8,2.7941e+01_r8,2.3286e+01_r8,1.8814e+01_r8,1.4266e+01_r8, &
     &1.0187e+01_r8,5.6505e+00_r8,1.3358e+00_r8/)
      kao(:, 3,12,12) = (/ &
     &3.6753e+01_r8,3.2149e+01_r8,2.7565e+01_r8,2.3058e+01_r8,1.8681e+01_r8,1.4515e+01_r8, &
     &1.0441e+01_r8,5.8743e+00_r8,1.3962e+00_r8/)
      kao(:, 4,12,12) = (/ &
     &3.6095e+01_r8,3.1568e+01_r8,2.7073e+01_r8,2.2830e+01_r8,1.8483e+01_r8,1.4754e+01_r8, &
     &1.0446e+01_r8,6.0858e+00_r8,1.2630e+00_r8/)
      kao(:, 5,12,12) = (/ &
     &3.5605e+01_r8,3.1165e+01_r8,2.6709e+01_r8,2.2579e+01_r8,1.8648e+01_r8,1.4780e+01_r8, &
     &1.0721e+01_r8,6.3554e+00_r8,1.9400e+00_r8/)
      kao(:, 1,13,12) = (/ &
     &3.6373e+01_r8,3.1828e+01_r8,2.7282e+01_r8,2.2746e+01_r8,1.8235e+01_r8,1.3858e+01_r8, &
     &9.7116e+00_r8,5.3620e+00_r8,1.4114e+00_r8/)
      kao(:, 2,13,12) = (/ &
     &3.6095e+01_r8,3.1587e+01_r8,2.7062e+01_r8,2.2560e+01_r8,1.8254e+01_r8,1.3864e+01_r8, &
     &1.0010e+01_r8,5.5792e+00_r8,1.4567e+00_r8/)
      kao(:, 3,13,12) = (/ &
     &3.5583e+01_r8,3.1140e+01_r8,2.6700e+01_r8,2.2381e+01_r8,1.8087e+01_r8,1.4135e+01_r8, &
     &1.0160e+01_r8,5.8997e+00_r8,1.1528e+00_r8/)
      kao(:, 4,13,12) = (/ &
     &3.5474e+01_r8,3.1045e+01_r8,2.6613e+01_r8,2.2429e+01_r8,1.8206e+01_r8,1.4545e+01_r8, &
     &1.0311e+01_r8,6.1832e+00_r8,1.6292e+00_r8/)
      kao(:, 5,13,12) = (/ &
     &3.5565e+01_r8,3.1124e+01_r8,2.6773e+01_r8,2.2531e+01_r8,1.8670e+01_r8,1.4802e+01_r8, &
     &1.0686e+01_r8,6.5577e+00_r8,2.3163e+00_r8/)
      kao(:, 1, 1,13) = (/ &
     &4.6813e-03_r8,5.0961e-01_r8,1.0176e+00_r8,1.5220e+00_r8,2.0224e+00_r8,2.5138e+00_r8, &
     &2.9825e+00_r8,3.3723e+00_r8,4.0446e+00_r8/)
      kao(:, 2, 1,13) = (/ &
     &4.5378e-03_r8,5.9150e-01_r8,1.1812e+00_r8,1.7694e+00_r8,2.3540e+00_r8,2.9329e+00_r8, &
     &3.4999e+00_r8,3.9983e+00_r8,4.7077e+00_r8/)
      kao(:, 3, 1,13) = (/ &
     &4.3993e-03_r8,6.8031e-01_r8,1.3585e+00_r8,2.0344e+00_r8,2.7071e+00_r8,3.3760e+00_r8, &
     &4.0375e+00_r8,4.6330e+00_r8,5.4138e+00_r8/)
      kao(:, 4, 1,13) = (/ &
     &4.2648e-03_r8,7.8088e-01_r8,1.5583e+00_r8,2.3313e+00_r8,3.0997e+00_r8,3.8593e+00_r8, &
     &4.5971e+00_r8,5.2655e+00_r8,6.1991e+00_r8/)
      kao(:, 5, 1,13) = (/ &
     &4.1347e-03_r8,8.9242e-01_r8,1.7790e+00_r8,2.6579e+00_r8,3.5250e+00_r8,4.3745e+00_r8, &
     &5.1887e+00_r8,5.9002e+00_r8,7.0497e+00_r8/)
      kao(:, 1, 2,13) = (/ &
     &7.6228e-03_r8,4.9032e-01_r8,9.7924e-01_r8,1.4667e+00_r8,1.9517e+00_r8,2.4315e+00_r8, &
     &2.8986e+00_r8,3.3149e+00_r8,3.9031e+00_r8/)
      kao(:, 2, 2,13) = (/ &
     &7.3845e-03_r8,5.7215e-01_r8,1.1423e+00_r8,1.7099e+00_r8,2.2735e+00_r8,2.8309e+00_r8, &
     &3.3762e+00_r8,3.8853e+00_r8,4.5466e+00_r8/)
      kao(:, 3, 2,13) = (/ &
     &7.1668e-03_r8,6.6400e-01_r8,1.3252e+00_r8,1.9825e+00_r8,2.6343e+00_r8,3.2753e+00_r8, &
     &3.8969e+00_r8,4.4792e+00_r8,5.2681e+00_r8/)
      kao(:, 4, 2,13) = (/ &
     &6.9674e-03_r8,7.6745e-01_r8,1.5306e+00_r8,2.2881e+00_r8,3.0362e+00_r8,3.7701e+00_r8, &
     &4.4777e+00_r8,5.1450e+00_r8,6.0719e+00_r8/)
      kao(:, 5, 2,13) = (/ &
     &6.7870e-03_r8,8.8445e-01_r8,1.7639e+00_r8,2.6357e+00_r8,3.4964e+00_r8,4.3377e+00_r8, &
     &5.1390e+00_r8,5.8595e+00_r8,6.9924e+00_r8/)
      kao(:, 1, 3,13) = (/ &
     &1.6838e-02_r8,4.6207e-01_r8,9.2280e-01_r8,1.3820e+00_r8,1.8387e+00_r8,2.2901e+00_r8, &
     &2.7306e+00_r8,3.1427e+00_r8,3.6769e+00_r8/)
      kao(:, 2, 3,13) = (/ &
     &1.6384e-02_r8,5.4636e-01_r8,1.0908e+00_r8,1.6331e+00_r8,2.1721e+00_r8,2.7041e+00_r8, &
     &3.2216e+00_r8,3.6963e+00_r8,4.3436e+00_r8/)
      kao(:, 3, 3,13) = (/ &
     &1.5944e-02_r8,6.4109e-01_r8,1.2798e+00_r8,1.9157e+00_r8,2.5468e+00_r8,3.1693e+00_r8, &
     &3.7717e+00_r8,4.3145e+00_r8,5.0931e+00_r8/)
      kao(:, 4, 3,13) = (/ &
     &1.5558e-02_r8,7.4877e-01_r8,1.4944e+00_r8,2.2360e+00_r8,2.9707e+00_r8,3.6929e+00_r8, &
     &4.3862e+00_r8,5.0013e+00_r8,5.9409e+00_r8/)
      kao(:, 5, 3,13) = (/ &
     &1.5161e-02_r8,8.6996e-01_r8,1.7361e+00_r8,2.5972e+00_r8,3.4498e+00_r8,4.2854e+00_r8, &
     &5.0840e+00_r8,5.7719e+00_r8,6.8989e+00_r8/)
      kao(:, 1, 4,13) = (/ &
     &3.7812e-02_r8,4.2471e-01_r8,8.4847e-01_r8,1.2717e+00_r8,1.6944e+00_r8,2.1155e+00_r8, &
     &2.5337e+00_r8,2.9379e+00_r8,3.3881e+00_r8/)
      kao(:, 2, 4,13) = (/ &
     &3.6812e-02_r8,5.1516e-01_r8,1.0290e+00_r8,1.5422e+00_r8,2.0538e+00_r8,2.5636e+00_r8, &
     &3.0667e+00_r8,3.5462e+00_r8,4.1066e+00_r8/)
      kao(:, 3, 4,13) = (/ &
     &3.5849e-02_r8,6.1666e-01_r8,1.2316e+00_r8,1.8451e+00_r8,2.4569e+00_r8,3.0640e+00_r8, &
     &3.6618e+00_r8,4.2232e+00_r8,4.9129e+00_r8/)
      kao(:, 4, 4,13) = (/ &
     &3.5079e-02_r8,7.3193e-01_r8,1.4618e+00_r8,2.1899e+00_r8,2.9146e+00_r8,3.6330e+00_r8, &
     &4.3356e+00_r8,4.9789e+00_r8,5.8283e+00_r8/)
      kao(:, 5, 4,13) = (/ &
     &3.4393e-02_r8,8.5645e-01_r8,1.7103e+00_r8,2.5622e+00_r8,3.4100e+00_r8,4.2503e+00_r8, &
     &5.0712e+00_r8,5.8174e+00_r8,6.8190e+00_r8/)
      kao(:, 1, 5,13) = (/ &
     &8.0627e-02_r8,3.8028e-01_r8,7.5923e-01_r8,1.1381e+00_r8,1.5165e+00_r8,1.8947e+00_r8, &
     &2.2720e+00_r8,2.6453e+00_r8,3.0318e+00_r8/)
      kao(:, 2, 5,13) = (/ &
     &7.8562e-02_r8,4.7262e-01_r8,9.4356e-01_r8,1.4144e+00_r8,1.8847e+00_r8,2.3543e+00_r8, &
     &2.8214e+00_r8,3.2802e+00_r8,3.7680e+00_r8/)
      kao(:, 3, 5,13) = (/ &
     &7.6982e-02_r8,5.7810e-01_r8,1.1544e+00_r8,1.7303e+00_r8,2.3053e+00_r8,2.8784e+00_r8, &
     &3.4478e+00_r8,4.0008e+00_r8,4.6091e+00_r8/)
      kao(:, 4, 5,13) = (/ &
     &7.5657e-02_r8,6.9735e-01_r8,1.3928e+00_r8,2.0875e+00_r8,2.7814e+00_r8,3.4728e+00_r8, &
     &4.1587e+00_r8,4.8230e+00_r8,5.5613e+00_r8/)
      kao(:, 5, 5,13) = (/ &
     &7.4333e-02_r8,8.2506e-01_r8,1.6482e+00_r8,2.4702e+00_r8,3.2916e+00_r8,4.1103e+00_r8, &
     &4.9228e+00_r8,5.7104e+00_r8,6.5816e+00_r8/)
      kao(:, 1, 6,13) = (/ &
     &1.6425e-01_r8,3.3608e-01_r8,6.6609e-01_r8,9.9817e-01_r8,1.3302e+00_r8,1.6619e+00_r8, &
     &1.9931e+00_r8,2.3215e+00_r8,2.6587e+00_r8/)
      kao(:, 2, 6,13) = (/ &
     &1.6074e-01_r8,4.2522e-01_r8,8.4831e-01_r8,1.2715e+00_r8,1.6941e+00_r8,2.1166e+00_r8, &
     &2.5378e+00_r8,2.9543e+00_r8,3.3863e+00_r8/)
      kao(:, 3, 6,13) = (/ &
     &1.5834e-01_r8,5.2989e-01_r8,1.0574e+00_r8,1.5848e+00_r8,2.1117e+00_r8,2.6382e+00_r8, &
     &3.1634e+00_r8,3.6820e+00_r8,4.2213e+00_r8/)
      kao(:, 4, 6,13) = (/ &
     &1.5607e-01_r8,6.4460e-01_r8,1.2868e+00_r8,1.9290e+00_r8,2.5707e+00_r8,3.2115e+00_r8, &
     &3.8511e+00_r8,4.4833e+00_r8,5.1392e+00_r8/)
      kao(:, 5, 6,13) = (/ &
     &1.5296e-01_r8,7.6868e-01_r8,1.5350e+00_r8,2.3008e+00_r8,3.0663e+00_r8,3.8313e+00_r8, &
     &4.5942e+00_r8,5.3490e+00_r8,6.1304e+00_r8/)
      kao(:, 1, 7,13) = (/ &
     &3.5667e-01_r8,3.9890e-01_r8,5.8897e-01_r8,8.6077e-01_r8,1.1469e+00_r8,1.4325e+00_r8, &
     &1.7184e+00_r8,2.0036e+00_r8,2.2913e+00_r8/)
      kao(:, 2, 7,13) = (/ &
     &3.5161e-01_r8,4.4967e-01_r8,7.5040e-01_r8,1.1221e+00_r8,1.4950e+00_r8,1.8682e+00_r8, &
     &2.2405e+00_r8,2.6119e+00_r8,2.9872e+00_r8/)
      kao(:, 3, 7,13) = (/ &
     &3.4606e-01_r8,5.1859e-01_r8,9.4635e-01_r8,1.4181e+00_r8,1.8897e+00_r8,2.3609e+00_r8, &
     &2.8323e+00_r8,3.3018e+00_r8,3.7764e+00_r8/)
      kao(:, 4, 7,13) = (/ &
     &3.3825e-01_r8,6.0265e-01_r8,1.1668e+00_r8,1.7485e+00_r8,2.3304e+00_r8,2.9114e+00_r8, &
     &3.4925e+00_r8,4.0716e+00_r8,4.6575e+00_r8/)
      kao(:, 5, 7,13) = (/ &
     &3.3043e-01_r8,7.1091e-01_r8,1.4088e+00_r8,2.1112e+00_r8,2.8136e+00_r8,3.5161e+00_r8, &
     &4.2182e+00_r8,4.9170e+00_r8,5.6239e+00_r8/)
      kao(:, 1, 8,13) = (/ &
     &9.2067e-01_r8,8.6182e-01_r8,8.2952e-01_r8,8.7491e-01_r8,1.0086e+00_r8,1.2181e+00_r8, &
     &1.4607e+00_r8,1.7034e+00_r8,1.9462e+00_r8/)
      kao(:, 2, 8,13) = (/ &
     &9.0671e-01_r8,8.7567e-01_r8,8.9610e-01_r8,1.0491e+00_r8,1.2996e+00_r8,1.6153e+00_r8, &
     &1.9371e+00_r8,2.2592e+00_r8,2.5816e+00_r8/)
      kao(:, 3, 8,13) = (/ &
     &8.8973e-01_r8,8.8439e-01_r8,1.0044e+00_r8,1.2766e+00_r8,1.6623e+00_r8,2.0766e+00_r8, &
     &2.4910e+00_r8,2.9049e+00_r8,3.3193e+00_r8/)
      kao(:, 4, 8,13) = (/ &
     &8.6846e-01_r8,9.1357e-01_r8,1.1469e+00_r8,1.5675e+00_r8,2.0797e+00_r8,2.5979e+00_r8, &
     &3.1162e+00_r8,3.6352e+00_r8,4.1539e+00_r8/)
      kao(:, 5, 8,13) = (/ &
     &8.4664e-01_r8,9.6627e-01_r8,1.3262e+00_r8,1.9064e+00_r8,2.5399e+00_r8,3.1734e+00_r8, &
     &3.8073e+00_r8,4.4405e+00_r8,5.0740e+00_r8/)
      kao(:, 1, 9,13) = (/ &
     &4.4067e+00_r8,3.8562e+00_r8,3.3799e+00_r8,2.9279e+00_r8,2.4898e+00_r8,2.0023e+00_r8, &
     &1.6061e+00_r8,1.4556e+00_r8,5.3966e-01_r8/)
      kao(:, 2, 9,13) = (/ &
     &4.3584e+00_r8,3.8431e+00_r8,3.3719e+00_r8,2.9985e+00_r8,2.5395e+00_r8,2.1329e+00_r8, &
     &1.8824e+00_r8,1.9290e+00_r8,1.2534e+00_r8/)
      kao(:, 3, 9,13) = (/ &
     &4.2715e+00_r8,3.7950e+00_r8,3.4185e+00_r8,3.0378e+00_r8,2.6388e+00_r8,2.3497e+00_r8, &
     &2.2667e+00_r8,2.5092e+00_r8,2.3205e+00_r8/)
      kao(:, 4, 9,13) = (/ &
     &4.1934e+00_r8,3.7482e+00_r8,3.4519e+00_r8,3.0862e+00_r8,2.7969e+00_r8,2.6493e+00_r8, &
     &2.7789e+00_r8,3.1851e+00_r8,3.5246e+00_r8/)
      kao(:, 5, 9,13) = (/ &
     &4.0917e+00_r8,3.7105e+00_r8,3.4634e+00_r8,3.1979e+00_r8,3.0093e+00_r8,3.0525e+00_r8, &
     &3.4012e+00_r8,3.9555e+00_r8,4.5178e+00_r8/)
      kao(:, 1,10,13) = (/ &
     &2.3719e+01_r8,2.0753e+01_r8,1.7788e+01_r8,1.4825e+01_r8,1.1907e+01_r8,9.0621e+00_r8, &
     &6.2541e+00_r8,3.4363e+00_r8,9.1814e-01_r8/)
      kao(:, 2,10,13) = (/ &
     &2.3432e+01_r8,2.0501e+01_r8,1.7571e+01_r8,1.4658e+01_r8,1.1890e+01_r8,9.0622e+00_r8, &
     &6.4024e+00_r8,3.5910e+00_r8,1.1158e+00_r8/)
      kao(:, 3,10,13) = (/ &
     &2.3069e+01_r8,2.0187e+01_r8,1.7300e+01_r8,1.4541e+01_r8,1.1793e+01_r8,9.1570e+00_r8, &
     &6.5099e+00_r8,3.8249e+00_r8,9.3188e-01_r8/)
      kao(:, 4,10,13) = (/ &
     &2.2641e+01_r8,1.9809e+01_r8,1.6998e+01_r8,1.4367e+01_r8,1.1776e+01_r8,9.2770e+00_r8, &
     &6.6180e+00_r8,4.0885e+00_r8,9.9189e-01_r8/)
      kao(:, 5,10,13) = (/ &
     &2.2220e+01_r8,1.9436e+01_r8,1.6770e+01_r8,1.4187e+01_r8,1.1792e+01_r8,9.2910e+00_r8, &
     &6.8771e+00_r8,4.4865e+00_r8,1.9399e+00_r8/)
      kao(:, 1,11,13) = (/ &
     &4.4319e+01_r8,3.8780e+01_r8,3.3240e+01_r8,2.7701e+01_r8,2.2160e+01_r8,1.6704e+01_r8, &
     &1.1307e+01_r8,6.0563e+00_r8,5.8625e-01_r8/)
      kao(:, 2,11,13) = (/ &
     &4.3809e+01_r8,3.8330e+01_r8,3.2852e+01_r8,2.7376e+01_r8,2.1936e+01_r8,1.6626e+01_r8, &
     &1.1378e+01_r8,6.1989e+00_r8,8.1730e-01_r8/)
      kao(:, 3,11,13) = (/ &
     &4.3202e+01_r8,3.7799e+01_r8,3.2400e+01_r8,2.7000e+01_r8,2.1788e+01_r8,1.6575e+01_r8, &
     &1.1586e+01_r8,6.3577e+00_r8,1.8296e+00_r8/)
      kao(:, 4,11,13) = (/ &
     &4.2458e+01_r8,3.7147e+01_r8,3.1841e+01_r8,2.6621e+01_r8,2.1500e+01_r8,1.6577e+01_r8, &
     &1.1663e+01_r8,6.6208e+00_r8,1.8735e+00_r8/)
      kao(:, 5,11,13) = (/ &
     &4.1634e+01_r8,3.6429e+01_r8,3.1221e+01_r8,2.6233e+01_r8,2.1246e+01_r8,1.6580e+01_r8, &
     &1.1685e+01_r8,6.9092e+00_r8,1.7032e+00_r8/)
      kao(:, 1,12,13) = (/ &
     &6.1904e+01_r8,5.4167e+01_r8,4.6429e+01_r8,3.8690e+01_r8,3.0952e+01_r8,2.3248e+01_r8, &
     &1.5661e+01_r8,8.2582e+00_r8,4.3930e-01_r8/)
      kao(:, 2,12,13) = (/ &
     &6.1270e+01_r8,5.3611e+01_r8,4.5953e+01_r8,3.8296e+01_r8,3.0637e+01_r8,2.3190e+01_r8, &
     &1.5723e+01_r8,8.4338e+00_r8,1.2396e+00_r8/)
      kao(:, 3,12,13) = (/ &
     &6.0345e+01_r8,5.2802e+01_r8,4.5261e+01_r8,3.7714e+01_r8,3.0326e+01_r8,2.2898e+01_r8, &
     &1.5824e+01_r8,8.5563e+00_r8,2.5106e+00_r8/)
      kao(:, 4,12,13) = (/ &
     &5.9306e+01_r8,5.1895e+01_r8,4.4474e+01_r8,3.7089e+01_r8,2.9895e+01_r8,2.2756e+01_r8, &
     &1.5929e+01_r8,8.7873e+00_r8,2.2974e+00_r8/)
      kao(:, 5,12,13) = (/ &
     &5.8419e+01_r8,5.1111e+01_r8,4.3811e+01_r8,3.6683e+01_r8,2.9523e+01_r8,2.2821e+01_r8, &
     &1.5911e+01_r8,9.0327e+00_r8,2.2973e+00_r8/)
      kao(:, 1,13,13) = (/ &
     &6.8544e+01_r8,5.9975e+01_r8,5.1408e+01_r8,4.2840e+01_r8,3.4272e+01_r8,2.5775e+01_r8, &
     &1.7340e+01_r8,9.2235e+00_r8,4.0824e-01_r8/)
      kao(:, 2,13,13) = (/ &
     &6.7698e+01_r8,5.9233e+01_r8,5.0770e+01_r8,4.2312e+01_r8,3.3875e+01_r8,2.5602e+01_r8, &
     &1.7402e+01_r8,9.3485e+00_r8,1.7747e+00_r8/)
      kao(:, 3,13,13) = (/ &
     &6.6803e+01_r8,5.8453e+01_r8,5.0103e+01_r8,4.1750e+01_r8,3.3601e+01_r8,2.5372e+01_r8, &
     &1.7686e+01_r8,9.4660e+00_r8,2.9931e+00_r8/)
      kao(:, 4,13,13) = (/ &
     &6.5956e+01_r8,5.7706e+01_r8,4.9463e+01_r8,4.1288e+01_r8,3.3259e+01_r8,2.5336e+01_r8, &
     &1.7750e+01_r8,9.7483e+00_r8,2.7732e+00_r8/)
      kao(:, 5,13,13) = (/ &
     &6.5110e+01_r8,5.6969e+01_r8,4.8829e+01_r8,4.0948e+01_r8,3.2989e+01_r8,2.5559e+01_r8, &
     &1.7705e+01_r8,9.9706e+00_r8,2.2584e+00_r8/)
      kao(:, 1, 1,14) = (/ &
     &5.3617e-03_r8,8.8862e-01_r8,1.7657e+00_r8,2.6246e+00_r8,3.4547e+00_r8,4.2326e+00_r8, &
     &4.9022e+00_r8,5.2848e+00_r8,6.9093e+00_r8/)
      kao(:, 2, 1,14) = (/ &
     &5.2510e-03_r8,1.0670e+00_r8,2.1191e+00_r8,3.1492e+00_r8,4.1423e+00_r8,5.0696e+00_r8, &
     &5.8593e+00_r8,6.2778e+00_r8,8.2844e+00_r8/)
      kao(:, 3, 1,14) = (/ &
     &5.1410e-03_r8,1.2574e+00_r8,2.4970e+00_r8,3.7095e+00_r8,4.8778e+00_r8,5.9654e+00_r8, &
     &6.8831e+00_r8,7.3419e+00_r8,9.7553e+00_r8/)
      kao(:, 4, 1,14) = (/ &
     &5.0266e-03_r8,1.4566e+00_r8,2.8932e+00_r8,4.2987e+00_r8,5.6515e+00_r8,6.9086e+00_r8, &
     &7.9640e+00_r8,8.4651e+00_r8,1.1303e+01_r8/)
      kao(:, 5, 1,14) = (/ &
     &4.9104e-03_r8,1.6562e+00_r8,3.2920e+00_r8,4.8956e+00_r8,6.4440e+00_r8,7.8868e+00_r8, &
     &9.0871e+00_r8,9.6375e+00_r8,1.2888e+01_r8/)
      kao(:, 1, 2,14) = (/ &
     &8.7449e-03_r8,9.0334e-01_r8,1.7988e+00_r8,2.6821e+00_r8,3.5450e+00_r8,4.3691e+00_r8, &
     &5.1072e+00_r8,5.5794e+00_r8,7.0898e+00_r8/)
      kao(:, 2, 2,14) = (/ &
     &8.5771e-03_r8,1.0973e+00_r8,2.1846e+00_r8,3.2569e+00_r8,4.3031e+00_r8,5.3011e+00_r8, &
     &6.1907e+00_r8,6.7403e+00_r8,8.6059e+00_r8/)
      kao(:, 3, 2,14) = (/ &
     &8.3757e-03_r8,1.3007e+00_r8,2.5910e+00_r8,3.8649e+00_r8,5.1100e+00_r8,6.3010e+00_r8, &
     &7.3563e+00_r8,7.9915e+00_r8,1.0220e+01_r8/)
      kao(:, 4, 2,14) = (/ &
     &8.1726e-03_r8,1.5076e+00_r8,3.0039e+00_r8,4.4835e+00_r8,5.9326e+00_r8,7.3236e+00_r8, &
     &8.5740e+00_r8,9.3177e+00_r8,1.1865e+01_r8/)
      kao(:, 5, 2,14) = (/ &
     &7.9706e-03_r8,1.7155e+00_r8,3.4194e+00_r8,5.1046e+00_r8,6.7592e+00_r8,8.3528e+00_r8, &
     &9.7973e+00_r8,1.0700e+01_r8,1.3518e+01_r8/)
      kao(:, 1, 3,14) = (/ &
     &1.9310e-02_r8,8.7468e-01_r8,1.7453e+00_r8,2.6103e+00_r8,3.4663e+00_r8,4.3037e+00_r8, &
     &5.0955e+00_r8,5.7297e+00_r8,6.9321e+00_r8/)
      kao(:, 2, 3,14) = (/ &
     &1.8969e-02_r8,1.0738e+00_r8,2.1432e+00_r8,3.2076e+00_r8,4.2608e+00_r8,5.2941e+00_r8, &
     &6.2765e+00_r8,7.0620e+00_r8,8.5210e+00_r8/)
      kao(:, 3, 3,14) = (/ &
     &1.8605e-02_r8,1.2813e+00_r8,2.5582e+00_r8,3.8286e+00_r8,5.0883e+00_r8,6.3262e+00_r8, &
     &7.5114e+00_r8,8.4846e+00_r8,1.0176e+01_r8/)
      kao(:, 4, 3,14) = (/ &
     &1.8213e-02_r8,1.4944e+00_r8,2.9835e+00_r8,4.4663e+00_r8,5.9372e+00_r8,7.3859e+00_r8, &
     &8.7760e+00_r8,9.9435e+00_r8,1.1874e+01_r8/)
      kao(:, 5, 3,14) = (/ &
     &1.7876e-02_r8,1.7091e+00_r8,3.4131e+00_r8,5.1104e+00_r8,6.7954e+00_r8,8.4548e+00_r8, &
     &1.0056e+01_r8,1.1421e+01_r8,1.3590e+01_r8/)
      kao(:, 1, 4,14) = (/ &
     &4.4344e-02_r8,8.3370e-01_r8,1.6650e+00_r8,2.4941e+00_r8,3.3185e+00_r8,4.1344e+00_r8, &
     &4.9297e+00_r8,5.6430e+00_r8,6.6364e+00_r8/)
      kao(:, 2, 4,14) = (/ &
     &4.3566e-02_r8,1.0283e+00_r8,2.0545e+00_r8,3.0778e+00_r8,4.0971e+00_r8,5.1067e+00_r8, &
     &6.0943e+00_r8,6.9950e+00_r8,8.1935e+00_r8/)
      kao(:, 3, 4,14) = (/ &
     &4.2932e-02_r8,1.2330e+00_r8,2.4636e+00_r8,3.6915e+00_r8,4.9148e+00_r8,6.1292e+00_r8, &
     &7.3214e+00_r8,8.4254e+00_r8,9.8287e+00_r8/)
      kao(:, 4, 4,14) = (/ &
     &4.2251e-02_r8,1.4427e+00_r8,2.8831e+00_r8,4.3208e+00_r8,5.7549e+00_r8,7.1799e+00_r8, &
     &8.5827e+00_r8,9.9037e+00_r8,1.1509e+01_r8/)
      kao(:, 5, 4,14) = (/ &
     &4.1551e-02_r8,1.6617e+00_r8,3.3208e+00_r8,4.9772e+00_r8,6.6290e+00_r8,8.2714e+00_r8, &
     &9.8934e+00_r8,1.1428e+01_r8,1.3257e+01_r8/)
      kao(:, 1, 5,14) = (/ &
     &9.4754e-02_r8,7.8821e-01_r8,1.5748e+00_r8,2.3603e+00_r8,3.1437e+00_r8,3.9237e+00_r8, &
     &4.6947e+00_r8,5.4302e+00_r8,6.2865e+00_r8/)
      kao(:, 2, 5,14) = (/ &
     &9.3575e-02_r8,9.7845e-01_r8,1.9550e+00_r8,2.9310e+00_r8,3.9047e+00_r8,4.8748e+00_r8, &
     &5.8356e+00_r8,6.7595e+00_r8,7.8084e+00_r8/)
      kao(:, 3, 5,14) = (/ &
     &9.2188e-02_r8,1.1782e+00_r8,2.3547e+00_r8,3.5302e+00_r8,4.7038e+00_r8,5.8743e+00_r8, &
     &7.0357e+00_r8,8.1610e+00_r8,9.4064e+00_r8/)
      kao(:, 4, 5,14) = (/ &
     &9.0816e-02_r8,1.3863e+00_r8,2.7710e+00_r8,4.1546e+00_r8,5.5362e+00_r8,6.9136e+00_r8, &
     &8.2813e+00_r8,9.6122e+00_r8,1.1071e+01_r8/)
      kao(:, 5, 5,14) = (/ &
     &8.9641e-02_r8,1.6059e+00_r8,3.2095e+00_r8,4.8121e+00_r8,6.4122e+00_r8,8.0077e+00_r8, &
     &9.5924e+00_r8,1.1136e+01_r8,1.2823e+01_r8/)
      kao(:, 1, 6,14) = (/ &
     &1.9317e-01_r8,7.2809e-01_r8,1.4547e+00_r8,2.1811e+00_r8,2.9065e+00_r8,3.6305e+00_r8, &
     &4.3507e+00_r8,5.0577e+00_r8,5.8117e+00_r8/)
      kao(:, 2, 6,14) = (/ &
     &1.9031e-01_r8,9.0988e-01_r8,1.8182e+00_r8,2.7260e+00_r8,3.6329e+00_r8,4.5385e+00_r8, &
     &5.4408e+00_r8,6.3293e+00_r8,7.2643e+00_r8/)
      kao(:, 3, 6,14) = (/ &
     &1.8758e-01_r8,1.1038e+00_r8,2.2061e+00_r8,3.3074e+00_r8,4.4083e+00_r8,5.5073e+00_r8, &
     &6.6028e+00_r8,7.6822e+00_r8,8.8149e+00_r8/)
      kao(:, 4, 6,14) = (/ &
     &1.8516e-01_r8,1.3141e+00_r8,2.6258e+00_r8,3.9372e+00_r8,5.2485e+00_r8,6.5558e+00_r8, &
     &7.8598e+00_r8,9.1449e+00_r8,1.0495e+01_r8/)
      kao(:, 5, 6,14) = (/ &
     &1.8433e-01_r8,1.5378e+00_r8,3.0732e+00_r8,4.6078e+00_r8,6.1419e+00_r8,7.6735e+00_r8, &
     &9.1990e+00_r8,1.0701e+01_r8,1.2282e+01_r8/)
      kao(:, 1, 7,14) = (/ &
     &4.2545e-01_r8,7.0197e-01_r8,1.3229e+00_r8,1.9833e+00_r8,2.6434e+00_r8,3.3025e+00_r8, &
     &3.9608e+00_r8,4.6133e+00_r8,5.2849e+00_r8/)
      kao(:, 2, 7,14) = (/ &
     &4.1807e-01_r8,8.4884e-01_r8,1.6721e+00_r8,2.5066e+00_r8,3.3410e+00_r8,4.1750e+00_r8, &
     &5.0067e+00_r8,5.8326e+00_r8,6.6798e+00_r8/)
      kao(:, 3, 7,14) = (/ &
     &4.1332e-01_r8,1.0301e+00_r8,2.0577e+00_r8,3.0848e+00_r8,4.1118e+00_r8,5.1378e+00_r8, &
     &6.1618e+00_r8,7.1777e+00_r8,8.2211e+00_r8/)
      kao(:, 4, 7,14) = (/ &
     &4.0936e-01_r8,1.2414e+00_r8,2.4798e+00_r8,3.7180e+00_r8,4.9556e+00_r8,6.1921e+00_r8, &
     &7.4267e+00_r8,8.6520e+00_r8,9.9083e+00_r8/)
      kao(:, 5, 7,14) = (/ &
     &4.0685e-01_r8,1.4675e+00_r8,2.9318e+00_r8,4.3961e+00_r8,5.8593e+00_r8,7.3214e+00_r8, &
     &8.7804e+00_r8,1.0230e+01_r8,1.1715e+01_r8/)
      kao(:, 1, 8,14) = (/ &
     &1.1195e+00_r8,1.0895e+00_r8,1.3598e+00_r8,1.7846e+00_r8,2.3466e+00_r8,2.9325e+00_r8, &
     &3.5182e+00_r8,4.1012e+00_r8,4.6898e+00_r8/)
      kao(:, 2, 8,14) = (/ &
     &1.1037e+00_r8,1.1788e+00_r8,1.6176e+00_r8,2.2927e+00_r8,3.0553e+00_r8,3.8181e+00_r8, &
     &4.5804e+00_r8,5.3406e+00_r8,6.1069e+00_r8/)
      kao(:, 3, 8,14) = (/ &
     &1.0884e+00_r8,1.2851e+00_r8,1.9342e+00_r8,2.8650e+00_r8,3.8186e+00_r8,4.7719e+00_r8, &
     &5.7236e+00_r8,6.6739e+00_r8,7.6330e+00_r8/)
      kao(:, 4, 8,14) = (/ &
     &1.0777e+00_r8,1.3879e+00_r8,2.3316e+00_r8,3.4927e+00_r8,4.6551e+00_r8,5.8169e+00_r8, &
     &6.9783e+00_r8,8.1364e+00_r8,9.3055e+00_r8/)
      kao(:, 5, 8,14) = (/ &
     &1.0697e+00_r8,1.5195e+00_r8,2.7843e+00_r8,4.1737e+00_r8,5.5632e+00_r8,6.9521e+00_r8, &
     &8.3391e+00_r8,9.7222e+00_r8,1.1121e+01_r8/)
      kao(:, 1, 9,14) = (/ &
     &5.6190e+00_r8,4.9167e+00_r8,4.3250e+00_r8,3.7358e+00_r8,3.4047e+00_r8,3.1579e+00_r8, &
     &3.1500e+00_r8,3.5459e+00_r8,3.9362e+00_r8/)
      kao(:, 2, 9,14) = (/ &
     &5.5255e+00_r8,4.8418e+00_r8,4.3146e+00_r8,3.9154e+00_r8,3.7623e+00_r8,3.7282e+00_r8, &
     &4.0980e+00_r8,4.7612e+00_r8,5.4406e+00_r8/)
      kao(:, 3, 9,14) = (/ &
     &5.4430e+00_r8,4.8357e+00_r8,4.3573e+00_r8,4.2040e+00_r8,4.1594e+00_r8,4.5007e+00_r8, &
     &5.2453e+00_r8,6.1166e+00_r8,6.9893e+00_r8/)
      kao(:, 4, 9,14) = (/ &
     &5.3842e+00_r8,4.8388e+00_r8,4.5334e+00_r8,4.4707e+00_r8,4.7073e+00_r8,5.4536e+00_r8, &
     &6.5005e+00_r8,7.5810e+00_r8,8.6617e+00_r8/)
      kao(:, 5, 9,14) = (/ &
     &5.3385e+00_r8,4.8392e+00_r8,4.7032e+00_r8,4.7787e+00_r8,5.4197e+00_r8,6.5502e+00_r8, &
     &7.8564e+00_r8,9.1615e+00_r8,1.0470e+01_r8/)
      kao(:, 1,10,14) = (/ &
     &3.1503e+01_r8,2.7564e+01_r8,2.3627e+01_r8,1.9689e+01_r8,1.5752e+01_r8,1.2029e+01_r8, &
     &8.2850e+00_r8,5.0089e+00_r8,2.6421e-01_r8/)
      kao(:, 2,10,14) = (/ &
     &3.1041e+01_r8,2.7162e+01_r8,2.3282e+01_r8,1.9402e+01_r8,1.5696e+01_r8,1.2052e+01_r8, &
     &8.5363e+00_r8,5.5767e+00_r8,1.2004e+00_r8/)
      kao(:, 3,10,14) = (/ &
     &3.0653e+01_r8,2.6822e+01_r8,2.2991e+01_r8,1.9210e+01_r8,1.5684e+01_r8,1.2101e+01_r8, &
     &9.0343e+00_r8,6.3229e+00_r8,1.6811e+00_r8/)
      kao(:, 4,10,14) = (/ &
     &3.0330e+01_r8,2.6541e+01_r8,2.2749e+01_r8,1.9185e+01_r8,1.5678e+01_r8,1.2425e+01_r8, &
     &9.5207e+00_r8,7.4497e+00_r8,1.5881e+00_r8/)
      kao(:, 5,10,14) = (/ &
     &2.9986e+01_r8,2.6238e+01_r8,2.2506e+01_r8,1.9078e+01_r8,1.5796e+01_r8,1.2833e+01_r8, &
     &1.0036e+01_r8,8.8467e+00_r8,2.8996e+00_r8/)
      kao(:, 1,11,14) = (/ &
     &6.1029e+01_r8,5.3402e+01_r8,4.5771e+01_r8,3.8145e+01_r8,3.0515e+01_r8,2.2887e+01_r8, &
     &1.5544e+01_r8,8.4710e+00_r8,5.1903e-01_r8/)
      kao(:, 2,11,14) = (/ &
     &6.0319e+01_r8,5.2777e+01_r8,4.5238e+01_r8,3.7700e+01_r8,3.0160e+01_r8,2.2857e+01_r8, &
     &1.5622e+01_r8,8.8835e+00_r8,1.0450e+00_r8/)
      kao(:, 3,11,14) = (/ &
     &5.9632e+01_r8,5.2177e+01_r8,4.4723e+01_r8,3.7270e+01_r8,2.9909e+01_r8,2.2818e+01_r8, &
     &1.5829e+01_r8,9.3768e+00_r8,1.3014e+00_r8/)
      kao(:, 4,11,14) = (/ &
     &5.9020e+01_r8,5.1642e+01_r8,4.4266e+01_r8,3.6888e+01_r8,2.9847e+01_r8,2.2764e+01_r8, &
     &1.6262e+01_r8,9.9702e+00_r8,2.2647e+00_r8/)
      kao(:, 5,11,14) = (/ &
     &5.8283e+01_r8,5.0998e+01_r8,4.3714e+01_r8,3.6531e+01_r8,2.9620e+01_r8,2.3044e+01_r8, &
     &1.6667e+01_r8,1.0858e+01_r8,2.1604e+00_r8/)
      kao(:, 1,12,14) = (/ &
     &8.6818e+01_r8,7.5961e+01_r8,6.5105e+01_r8,5.4264e+01_r8,4.3410e+01_r8,3.2557e+01_r8, &
     &2.1958e+01_r8,1.1756e+01_r8,1.0818e+00_r8/)
      kao(:, 2,12,14) = (/ &
     &8.5898e+01_r8,7.5160e+01_r8,6.4423e+01_r8,5.3685e+01_r8,4.2947e+01_r8,3.2329e+01_r8, &
     &2.1951e+01_r8,1.2183e+01_r8,6.2703e-01_r8/)
      kao(:, 3,12,14) = (/ &
     &8.4970e+01_r8,7.4354e+01_r8,6.3731e+01_r8,5.3109e+01_r8,4.2485e+01_r8,3.2310e+01_r8, &
     &2.2149e+01_r8,1.2602e+01_r8,1.0531e+00_r8/)
      kao(:, 4,12,14) = (/ &
     &8.4043e+01_r8,7.3537e+01_r8,6.3034e+01_r8,5.2533e+01_r8,4.2288e+01_r8,3.2140e+01_r8, &
     &2.2696e+01_r8,1.3012e+01_r8,4.3852e+00_r8/)
      kao(:, 5,12,14) = (/ &
     &8.3130e+01_r8,7.2745e+01_r8,6.2351e+01_r8,5.1964e+01_r8,4.2084e+01_r8,3.2159e+01_r8, &
     &2.3067e+01_r8,1.3670e+01_r8,3.1697e+00_r8/)
      kao(:, 1,13,14) = (/ &
     &9.9062e+01_r8,8.6679e+01_r8,7.4295e+01_r8,6.1914e+01_r8,4.9531e+01_r8,3.7148e+01_r8, &
     &2.5053e+01_r8,1.3336e+01_r8,1.0355e+00_r8/)
      kao(:, 2,13,14) = (/ &
     &9.8005e+01_r8,8.5755e+01_r8,7.3503e+01_r8,6.1254e+01_r8,4.9004e+01_r8,3.6913e+01_r8, &
     &2.4991e+01_r8,1.3937e+01_r8,6.5467e-01_r8/)
      kao(:, 3,13,14) = (/ &
     &9.6910e+01_r8,8.4797e+01_r8,7.2683e+01_r8,6.0573e+01_r8,4.8483e+01_r8,3.6814e+01_r8, &
     &2.5110e+01_r8,1.4339e+01_r8,1.8215e+00_r8/)
      kao(:, 4,13,14) = (/ &
     &9.5837e+01_r8,8.3857e+01_r8,7.1882e+01_r8,5.9896e+01_r8,4.8229e+01_r8,3.6584e+01_r8, &
     &2.5752e+01_r8,1.4680e+01_r8,4.3881e+00_r8/)
      kao(:, 5,13,14) = (/ &
     &9.4386e+01_r8,8.2585e+01_r8,7.0788e+01_r8,5.9024e+01_r8,4.7765e+01_r8,3.6452e+01_r8, &
     &2.6308e+01_r8,1.5330e+01_r8,4.3734e+00_r8/)
      kao(:, 1, 1,15) = (/ &
     &6.2662e-03_r8,2.0747e+00_r8,4.1170e+00_r8,6.1089e+00_r8,8.0146e+00_r8,9.7584e+00_r8, &
     &1.1145e+01_r8,1.1422e+01_r8,1.6029e+01_r8/)
      kao(:, 2, 1,15) = (/ &
     &6.1351e-03_r8,2.4271e+00_r8,4.8178e+00_r8,7.1504e+00_r8,9.3877e+00_r8,1.1443e+01_r8, &
     &1.3088e+01_r8,1.3461e+01_r8,1.8775e+01_r8/)
      kao(:, 3, 1,15) = (/ &
     &6.0097e-03_r8,2.7826e+00_r8,5.5248e+00_r8,8.2041e+00_r8,1.0775e+01_r8,1.3145e+01_r8, &
     &1.5060e+01_r8,1.5543e+01_r8,2.1551e+01_r8/)
      kao(:, 4, 1,15) = (/ &
     &5.9020e-03_r8,3.1403e+00_r8,6.2337e+00_r8,9.2578e+00_r8,1.2161e+01_r8,1.4850e+01_r8, &
     &1.7039e+01_r8,1.7642e+01_r8,2.4321e+01_r8/)
      kao(:, 5, 1,15) = (/ &
     &5.8030e-03_r8,3.5098e+00_r8,6.9636e+00_r8,1.0331e+01_r8,1.3560e+01_r8,1.6533e+01_r8, &
     &1.8991e+01_r8,1.9724e+01_r8,2.7120e+01_r8/)
      kao(:, 1, 2,15) = (/ &
     &1.0266e-02_r8,2.1405e+00_r8,4.2622e+00_r8,6.3547e+00_r8,8.3970e+00_r8,1.0344e+01_r8, &
     &1.2064e+01_r8,1.2985e+01_r8,1.6794e+01_r8/)
      kao(:, 2, 2,15) = (/ &
     &1.0014e-02_r8,2.5163e+00_r8,5.0119e+00_r8,7.4752e+00_r8,9.8815e+00_r8,1.2172e+01_r8, &
     &1.4218e+01_r8,1.5356e+01_r8,1.9763e+01_r8/)
      kao(:, 3, 2,15) = (/ &
     &9.8638e-03_r8,2.9079e+00_r8,5.7890e+00_r8,8.6292e+00_r8,1.1401e+01_r8,1.4046e+01_r8, &
     &1.6408e+01_r8,1.7772e+01_r8,2.2802e+01_r8/)
      kao(:, 4, 2,15) = (/ &
     &9.7234e-03_r8,3.3191e+00_r8,6.6057e+00_r8,9.8408e+00_r8,1.2995e+01_r8,1.5989e+01_r8, &
     &1.8633e+01_r8,2.0195e+01_r8,2.5989e+01_r8/)
      kao(:, 5, 2,15) = (/ &
     &9.5893e-03_r8,3.7435e+00_r8,7.4476e+00_r8,1.1096e+01_r8,1.4644e+01_r8,1.8006e+01_r8, &
     &2.0946e+01_r8,2.2600e+01_r8,2.9288e+01_r8/)
      kao(:, 1, 3,15) = (/ &
     &2.3937e-02_r8,2.0884e+00_r8,4.1689e+00_r8,6.2403e+00_r8,8.2897e+00_r8,1.0301e+01_r8, &
     &1.2219e+01_r8,1.3769e+01_r8,1.6579e+01_r8/)
      kao(:, 2, 3,15) = (/ &
     &2.3289e-02_r8,2.4959e+00_r8,4.9798e+00_r8,7.4513e+00_r8,9.8967e+00_r8,1.2286e+01_r8, &
     &1.4557e+01_r8,1.6412e+01_r8,1.9793e+01_r8/)
      kao(:, 3, 3,15) = (/ &
     &2.2745e-02_r8,2.9294e+00_r8,5.8465e+00_r8,8.7448e+00_r8,1.1610e+01_r8,1.4408e+01_r8, &
     &1.7054e+01_r8,1.9158e+01_r8,2.3219e+01_r8/)
      kao(:, 4, 3,15) = (/ &
     &2.2330e-02_r8,3.3848e+00_r8,6.7550e+00_r8,1.0101e+01_r8,1.3409e+01_r8,1.6637e+01_r8, &
     &1.9679e+01_r8,2.2057e+01_r8,2.6817e+01_r8/)
      kao(:, 5, 3,15) = (/ &
     &2.1962e-02_r8,3.8549e+00_r8,7.6925e+00_r8,1.1504e+01_r8,1.5265e+01_r8,1.8935e+01_r8, &
     &2.2399e+01_r8,2.5067e+01_r8,3.0529e+01_r8/)
      kao(:, 1, 4,15) = (/ &
     &5.8511e-02_r8,1.9940e+00_r8,3.9844e+00_r8,5.9687e+00_r8,7.9437e+00_r8,9.9016e+00_r8, &
     &1.1811e+01_r8,1.3553e+01_r8,1.5887e+01_r8/)
      kao(:, 2, 4,15) = (/ &
     &5.6982e-02_r8,2.4233e+00_r8,4.8420e+00_r8,7.2530e+00_r8,9.6512e+00_r8,1.2029e+01_r8, &
     &1.4341e+01_r8,1.6438e+01_r8,1.9302e+01_r8/)
      kao(:, 3, 4,15) = (/ &
     &5.5673e-02_r8,2.8886e+00_r8,5.7711e+00_r8,8.6444e+00_r8,1.1501e+01_r8,1.4329e+01_r8, &
     &1.7084e+01_r8,1.9562e+01_r8,2.3002e+01_r8/)
      kao(:, 4, 4,15) = (/ &
     &5.4580e-02_r8,3.3869e+00_r8,6.7661e+00_r8,1.0134e+01_r8,1.3482e+01_r8,1.6795e+01_r8, &
     &2.0015e+01_r8,2.2895e+01_r8,2.6964e+01_r8/)
      kao(:, 5, 4,15) = (/ &
     &5.3615e-02_r8,3.9077e+00_r8,7.8058e+00_r8,1.1691e+01_r8,1.5555e+01_r8,1.9373e+01_r8, &
     &2.3083e+01_r8,2.6384e+01_r8,3.1109e+01_r8/)
      kao(:, 1, 5,15) = (/ &
     &1.2989e-01_r8,1.8900e+00_r8,3.7783e+00_r8,5.6637e+00_r8,7.5463e+00_r8,9.4177e+00_r8, &
     &1.1267e+01_r8,1.3028e+01_r8,1.5093e+01_r8/)
      kao(:, 2, 5,15) = (/ &
     &1.2665e-01_r8,2.3422e+00_r8,4.6829e+00_r8,7.0179e+00_r8,9.3476e+00_r8,1.1662e+01_r8, &
     &1.3953e+01_r8,1.6125e+01_r8,1.8695e+01_r8/)
      kao(:, 3, 5,15) = (/ &
     &1.2397e-01_r8,2.8405e+00_r8,5.6772e+00_r8,8.5098e+00_r8,1.1334e+01_r8,1.4142e+01_r8, &
     &1.6912e+01_r8,1.9527e+01_r8,2.2668e+01_r8/)
      kao(:, 4, 5,15) = (/ &
     &1.2164e-01_r8,3.3767e+00_r8,6.7490e+00_r8,1.0116e+01_r8,1.3472e+01_r8,1.6807e+01_r8, &
     &2.0097e+01_r8,2.3197e+01_r8,2.6943e+01_r8/)
      kao(:, 5, 5,15) = (/ &
     &1.1945e-01_r8,3.9432e+00_r8,7.8814e+00_r8,1.1812e+01_r8,1.5732e+01_r8,1.9624e+01_r8, &
     &2.3463e+01_r8,2.7077e+01_r8,3.1463e+01_r8/)
      kao(:, 1, 6,15) = (/ &
     &2.7269e-01_r8,1.7592e+00_r8,3.5166e+00_r8,5.2733e+00_r8,7.0272e+00_r8,8.7771e+00_r8, &
     &1.0515e+01_r8,1.2209e+01_r8,1.4054e+01_r8/)
      kao(:, 2, 6,15) = (/ &
     &2.6586e-01_r8,2.2331e+00_r8,4.4644e+00_r8,6.6948e+00_r8,8.9210e+00_r8,1.1141e+01_r8, &
     &1.3343e+01_r8,1.5486e+01_r8,1.7841e+01_r8/)
      kao(:, 3, 6,15) = (/ &
     &2.5987e-01_r8,2.7625e+00_r8,5.5224e+00_r8,8.2799e+00_r8,1.1033e+01_r8,1.3778e+01_r8, &
     &1.6504e+01_r8,1.9146e+01_r8,2.2064e+01_r8/)
      kao(:, 4, 6,15) = (/ &
     &2.5470e-01_r8,3.3380e+00_r8,6.6713e+00_r8,1.0004e+01_r8,1.3331e+01_r8,1.6646e+01_r8, &
     &1.9934e+01_r8,2.3121e+01_r8,2.6661e+01_r8/)
      kao(:, 5, 6,15) = (/ &
     &2.4980e-01_r8,3.9509e+00_r8,7.8982e+00_r8,1.1841e+01_r8,1.5778e+01_r8,1.9702e+01_r8, &
     &2.3595e+01_r8,2.7362e+01_r8,3.1554e+01_r8/)
      kao(:, 1, 7,15) = (/ &
     &6.0751e-01_r8,1.6155e+00_r8,3.2295e+00_r8,4.8433e+00_r8,6.4556e+00_r8,8.0666e+00_r8, &
     &9.6721e+00_r8,1.1255e+01_r8,1.2910e+01_r8/)
      kao(:, 2, 7,15) = (/ &
     &5.9214e-01_r8,2.1056e+00_r8,4.2107e+00_r8,6.3119e+00_r8,8.4131e+00_r8,1.0511e+01_r8, &
     &1.2602e+01_r8,1.4667e+01_r8,1.6825e+01_r8/)
      kao(:, 3, 7,15) = (/ &
     &5.7904e-01_r8,2.6613e+00_r8,5.3198e+00_r8,7.9772e+00_r8,1.0632e+01_r8,1.3285e+01_r8, &
     &1.5925e+01_r8,1.8528e+01_r8,2.1262e+01_r8/)
      kao(:, 4, 7,15) = (/ &
     &5.6819e-01_r8,3.2710e+00_r8,6.5412e+00_r8,9.8097e+00_r8,1.3074e+01_r8,1.6330e+01_r8, &
     &1.9581e+01_r8,2.2775e+01_r8,2.6146e+01_r8/)
      kao(:, 5, 7,15) = (/ &
     &5.5940e-01_r8,3.9287e+00_r8,7.8537e+00_r8,1.1777e+01_r8,1.5697e+01_r8,1.9610e+01_r8, &
     &2.3510e+01_r8,2.7346e+01_r8,3.1392e+01_r8/)
      kao(:, 1, 8,15) = (/ &
     &1.5944e+00_r8,1.8253e+00_r8,2.9741e+00_r8,4.4602e+00_r8,5.9464e+00_r8,7.4314e+00_r8, &
     &8.9145e+00_r8,1.0387e+01_r8,1.1892e+01_r8/)
      kao(:, 2, 8,15) = (/ &
     &1.5557e+00_r8,2.1022e+00_r8,3.9278e+00_r8,5.8889e+00_r8,7.8512e+00_r8,9.8106e+00_r8, &
     &1.1770e+01_r8,1.3716e+01_r8,1.5700e+01_r8/)
      kao(:, 3, 8,15) = (/ &
     &1.5271e+00_r8,2.5583e+00_r8,5.0719e+00_r8,7.6057e+00_r8,1.0139e+01_r8,1.2670e+01_r8, &
     &1.5200e+01_r8,1.7713e+01_r8,2.0275e+01_r8/)
      kao(:, 4, 8,15) = (/ &
     &1.5040e+00_r8,3.1773e+00_r8,6.3513e+00_r8,9.5214e+00_r8,1.2692e+01_r8,1.5861e+01_r8, &
     &1.9025e+01_r8,2.2168e+01_r8,2.5379e+01_r8/)
      kao(:, 5, 8,15) = (/ &
     &1.4829e+00_r8,3.8723e+00_r8,7.7385e+00_r8,1.1605e+01_r8,1.5469e+01_r8,1.9331e+01_r8, &
     &2.3189e+01_r8,2.7019e+01_r8,3.0932e+01_r8/)
      kao(:, 1, 9,15) = (/ &
     &7.9603e+00_r8,6.9650e+00_r8,6.1670e+00_r8,5.9409e+00_r8,5.9163e+00_r8,6.8445e+00_r8, &
     &8.2104e+00_r8,9.5758e+00_r8,1.0949e+01_r8/)
      kao(:, 2, 9,15) = (/ &
     &7.7491e+00_r8,6.7807e+00_r8,6.5143e+00_r8,6.5222e+00_r8,7.4209e+00_r8,9.1698e+00_r8, &
     &1.1001e+01_r8,1.2830e+01_r8,1.4668e+01_r8/)
      kao(:, 3, 9,15) = (/ &
     &7.6260e+00_r8,6.7058e+00_r8,6.8127e+00_r8,7.5772e+00_r8,9.5702e+00_r8,1.1961e+01_r8, &
     &1.4350e+01_r8,1.6735e+01_r8,1.9129e+01_r8/)
      kao(:, 4, 9,15) = (/ &
     &7.5222e+00_r8,6.8189e+00_r8,7.2464e+00_r8,9.2266e+00_r8,1.2156e+01_r8,1.5192e+01_r8, &
     &1.8221e+01_r8,2.1251e+01_r8,2.4297e+01_r8/)
      kao(:, 5, 9,15) = (/ &
     &7.4213e+00_r8,6.9850e+00_r8,8.1141e+00_r8,1.1288e+01_r8,1.5041e+01_r8,1.8797e+01_r8, &
     &2.2550e+01_r8,2.6298e+01_r8,3.0063e+01_r8/)
      kao(:, 1,10,15) = (/ &
     &4.4970e+01_r8,3.9351e+01_r8,3.3728e+01_r8,2.8106e+01_r8,2.2484e+01_r8,1.7001e+01_r8, &
     &1.2662e+01_r8,9.3833e+00_r8,3.0844e+00_r8/)
      kao(:, 2,10,15) = (/ &
     &4.3703e+01_r8,3.8241e+01_r8,3.2779e+01_r8,2.7313e+01_r8,2.1862e+01_r8,1.7553e+01_r8, &
     &1.3621e+01_r8,1.2273e+01_r8,6.8989e+00_r8/)
      kao(:, 3,10,15) = (/ &
     &4.2828e+01_r8,3.7472e+01_r8,3.2122e+01_r8,2.6765e+01_r8,2.2087e+01_r8,1.8341e+01_r8, &
     &1.5372e+01_r8,1.6156e+01_r8,1.4584e+01_r8/)
      kao(:, 4,10,15) = (/ &
     &4.2192e+01_r8,3.6921e+01_r8,3.1646e+01_r8,2.6524e+01_r8,2.2776e+01_r8,1.9260e+01_r8, &
     &1.8346e+01_r8,2.0694e+01_r8,2.3643e+01_r8/)
      kao(:, 5,10,15) = (/ &
     &4.1609e+01_r8,3.6411e+01_r8,3.1210e+01_r8,2.6835e+01_r8,2.3359e+01_r8,2.1143e+01_r8, &
     &2.2256e+01_r8,2.5773e+01_r8,2.9447e+01_r8/)
      kao(:, 1,11,15) = (/ &
     &8.7878e+01_r8,7.6892e+01_r8,6.5913e+01_r8,5.4929e+01_r8,4.3942e+01_r8,3.2958e+01_r8, &
     &2.2278e+01_r8,1.3146e+01_r8,1.2934e+00_r8/)
      kao(:, 2,11,15) = (/ &
     &8.5528e+01_r8,7.4837e+01_r8,6.4148e+01_r8,5.3454e+01_r8,4.2765e+01_r8,3.2087e+01_r8, &
     &2.2860e+01_r8,1.5064e+01_r8,9.2095e-01_r8/)
      kao(:, 3,11,15) = (/ &
     &8.3842e+01_r8,7.3371e+01_r8,6.2884e+01_r8,5.2405e+01_r8,4.1923e+01_r8,3.2241e+01_r8, &
     &2.3615e+01_r8,1.8250e+01_r8,5.0549e+00_r8/)
      kao(:, 4,11,15) = (/ &
     &8.2422e+01_r8,7.2123e+01_r8,6.1819e+01_r8,5.1515e+01_r8,4.1404e+01_r8,3.2935e+01_r8, &
     &2.5033e+01_r8,2.2612e+01_r8,1.1342e+01_r8/)
      kao(:, 5,11,15) = (/ &
     &8.1155e+01_r8,7.1009e+01_r8,6.0866e+01_r8,5.0722e+01_r8,4.1664e+01_r8,3.3361e+01_r8, &
     &2.7672e+01_r8,2.7836e+01_r8,2.1588e+01_r8/)
      kao(:, 1,12,15) = (/ &
     &1.2764e+02_r8,1.1168e+02_r8,9.5717e+01_r8,7.9766e+01_r8,6.3821e+01_r8,4.7862e+01_r8, &
     &3.1927e+01_r8,1.7517e+01_r8,5.0733e-04_r8/)
      kao(:, 2,12,15) = (/ &
     &1.2458e+02_r8,1.0901e+02_r8,9.3437e+01_r8,7.7867e+01_r8,6.2287e+01_r8,4.6718e+01_r8, &
     &3.2041e+01_r8,1.8889e+01_r8,1.2295e+00_r8/)
      kao(:, 3,12,15) = (/ &
     &1.2214e+02_r8,1.0687e+02_r8,9.1606e+01_r8,7.6332e+01_r8,6.1069e+01_r8,4.6041e+01_r8, &
     &3.2605e+01_r8,2.1597e+01_r8,1.0764e+00_r8/)
      kao(:, 4,12,15) = (/ &
     &1.1993e+02_r8,1.0494e+02_r8,8.9942e+01_r8,7.4954e+01_r8,5.9961e+01_r8,4.6289e+01_r8, &
     &3.3082e+01_r8,2.5581e+01_r8,1.5268e+00_r8/)
      kao(:, 5,12,15) = (/ &
     &1.1793e+02_r8,1.0318e+02_r8,8.8443e+01_r8,7.3700e+01_r8,5.9323e+01_r8,4.6666e+01_r8, &
     &3.5017e+01_r8,3.0597e+01_r8,1.3997e+01_r8/)
      kao(:, 1,13,15) = (/ &
     &1.4863e+02_r8,1.3005e+02_r8,1.1147e+02_r8,9.2892e+01_r8,7.4315e+01_r8,5.5737e+01_r8, &
     &3.7199e+01_r8,2.0080e+01_r8,6.4806e-01_r8/)
      kao(:, 2,13,15) = (/ &
     &1.4520e+02_r8,1.2704e+02_r8,1.0889e+02_r8,9.0753e+01_r8,7.2597e+01_r8,5.4452e+01_r8, &
     &3.7281e+01_r8,2.1314e+01_r8,1.2348e+00_r8/)
      kao(:, 3,13,15) = (/ &
     &1.4229e+02_r8,1.2450e+02_r8,1.0672e+02_r8,8.8931e+01_r8,7.1150e+01_r8,5.3675e+01_r8, &
     &3.7660e+01_r8,2.4186e+01_r8,1.1194e+00_r8/)
      kao(:, 4,13,15) = (/ &
     &1.3965e+02_r8,1.2219e+02_r8,1.0474e+02_r8,8.7285e+01_r8,6.9825e+01_r8,5.3800e+01_r8, &
     &3.7958e+01_r8,2.8295e+01_r8,2.6393e+00_r8/)
      kao(:, 5,13,15) = (/ &
     &1.3732e+02_r8,1.2017e+02_r8,1.0299e+02_r8,8.5829e+01_r8,6.9074e+01_r8,5.3874e+01_r8, &
     &3.9693e+01_r8,3.3322e+01_r8,1.2822e+01_r8/)
      kao(:, 1, 1,16) = (/ &
     &6.7483e-03_r8,2.7477e+00_r8,5.4216e+00_r8,7.9838e+00_r8,1.0362e+01_r8,1.2414e+01_r8, &
     &1.3792e+01_r8,1.3364e+01_r8,2.0724e+01_r8/)
      kao(:, 2, 1,16) = (/ &
     &6.6276e-03_r8,3.2705e+00_r8,6.4539e+00_r8,9.5049e+00_r8,1.2338e+01_r8,1.4784e+01_r8, &
     &1.6428e+01_r8,1.5929e+01_r8,2.4675e+01_r8/)
      kao(:, 3, 1,16) = (/ &
     &6.5036e-03_r8,3.8140e+00_r8,7.5283e+00_r8,1.1085e+01_r8,1.4395e+01_r8,1.7249e+01_r8, &
     &1.9172e+01_r8,1.8603e+01_r8,2.8790e+01_r8/)
      kao(:, 4, 1,16) = (/ &
     &6.3721e-03_r8,4.3730e+00_r8,8.6292e+00_r8,1.2711e+01_r8,1.6503e+01_r8,1.9784e+01_r8, &
     &2.1993e+01_r8,2.1351e+01_r8,3.3006e+01_r8/)
      kao(:, 5, 1,16) = (/ &
     &6.2363e-03_r8,4.9396e+00_r8,9.7465e+00_r8,1.4357e+01_r8,1.8648e+01_r8,2.2353e+01_r8, &
     &2.4860e+01_r8,2.4146e+01_r8,3.7295e+01_r8/)
      kao(:, 1, 2,16) = (/ &
     &1.1399e-02_r8,3.0700e+00_r8,6.0865e+00_r8,9.0222e+00_r8,1.1819e+01_r8,1.4357e+01_r8, &
     &1.6335e+01_r8,1.6615e+01_r8,2.3637e+01_r8/)
      kao(:, 2, 2,16) = (/ &
     &1.1191e-02_r8,3.6855e+00_r8,7.3071e+00_r8,1.0831e+01_r8,1.4189e+01_r8,1.7243e+01_r8, &
     &1.9624e+01_r8,1.9971e+01_r8,2.8378e+01_r8/)
      kao(:, 3, 2,16) = (/ &
     &1.0967e-02_r8,4.3287e+00_r8,8.5840e+00_r8,1.2722e+01_r8,1.6670e+01_r8,2.0258e+01_r8, &
     &2.3062e+01_r8,2.3488e+01_r8,3.3340e+01_r8/)
      kao(:, 4, 2,16) = (/ &
     &1.0738e-02_r8,4.9902e+00_r8,9.8948e+00_r8,1.4671e+01_r8,1.9224e+01_r8,2.3370e+01_r8, &
     &2.6613e+01_r8,2.7035e+01_r8,3.8446e+01_r8/)
      kao(:, 5, 2,16) = (/ &
     &1.0463e-02_r8,5.6638e+00_r8,1.1230e+01_r8,1.6648e+01_r8,2.1823e+01_r8,2.6530e+01_r8, &
     &3.0222e+01_r8,3.0819e+01_r8,4.3644e+01_r8/)
      kao(:, 1, 3,16) = (/ &
     &2.6306e-02_r8,3.2694e+00_r8,6.5125e+00_r8,9.7138e+00_r8,1.2840e+01_r8,1.5828e+01_r8, &
     &1.8484e+01_r8,2.0009e+01_r8,2.5680e+01_r8/)
      kao(:, 2, 3,16) = (/ &
     &2.5884e-02_r8,3.9785e+00_r8,7.9277e+00_r8,1.1819e+01_r8,1.5631e+01_r8,1.9201e+01_r8, &
     &2.2505e+01_r8,2.4372e+01_r8,3.1262e+01_r8/)
      kao(:, 3, 3,16) = (/ &
     &2.5346e-02_r8,4.7273e+00_r8,9.4145e+00_r8,1.4042e+01_r8,1.8571e+01_r8,2.2894e+01_r8, &
     &2.6751e+01_r8,2.8974e+01_r8,3.7022e+01_r8/)
      kao(:, 4, 3,16) = (/ &
     &2.4784e-02_r8,5.5013e+00_r8,1.0958e+01_r8,1.6345e+01_r8,2.1611e+01_r8,2.6651e+01_r8, &
     &3.1147e+01_r8,3.3763e+01_r8,4.3221e+01_r8/)
      kao(:, 5, 3,16) = (/ &
     &2.4200e-02_r8,6.2942e+00_r8,1.2535e+01_r8,1.8701e+01_r8,2.4733e+01_r8,3.0502e+01_r8, &
     &3.5641e+01_r8,3.8658e+01_r8,4.9465e+01_r8/)
      kao(:, 1, 4,16) = (/ &
     &6.3011e-02_r8,3.3909e+00_r8,6.7686e+00_r8,1.0126e+01_r8,1.3449e+01_r8,1.6701e+01_r8, &
     &1.9789e+01_r8,2.2242e+01_r8,2.6898e+01_r8/)
      kao(:, 2, 4,16) = (/ &
     &6.1738e-02_r8,4.1953e+00_r8,8.3750e+00_r8,1.2529e+01_r8,1.6640e+01_r8,2.0669e+01_r8, &
     &2.4483e+01_r8,2.7534e+01_r8,3.3280e+01_r8/)
      kao(:, 3, 4,16) = (/ &
     &6.0385e-02_r8,5.0522e+00_r8,1.0085e+01_r8,1.5088e+01_r8,2.0041e+01_r8,2.4891e+01_r8, &
     &2.9498e+01_r8,3.3182e+01_r8,4.0082e+01_r8/)
      kao(:, 4, 4,16) = (/ &
     &5.8960e-02_r8,5.9475e+00_r8,1.1873e+01_r8,1.7764e+01_r8,2.3588e+01_r8,2.9299e+01_r8, &
     &3.4723e+01_r8,3.9079e+01_r8,4.7175e+01_r8/)
      kao(:, 5, 4,16) = (/ &
     &5.7513e-02_r8,6.8674e+00_r8,1.3704e+01_r8,2.0508e+01_r8,2.7243e+01_r8,3.3832e+01_r8, &
     &4.0104e+01_r8,4.5142e+01_r8,5.4486e+01_r8/)
      kao(:, 1, 5,16) = (/ &
     &1.5311e-01_r8,3.4647e+00_r8,6.9218e+00_r8,1.0370e+01_r8,1.3799e+01_r8,1.7194e+01_r8, &
     &2.0501e+01_r8,2.3473e+01_r8,2.7599e+01_r8/)
      kao(:, 2, 5,16) = (/ &
     &1.4808e-01_r8,4.3642e+00_r8,8.7211e+00_r8,1.3066e+01_r8,1.7386e+01_r8,2.1656e+01_r8, &
     &2.5836e+01_r8,2.9576e+01_r8,3.4772e+01_r8/)
      kao(:, 3, 5,16) = (/ &
     &1.4324e-01_r8,5.3326e+00_r8,1.0656e+01_r8,1.5962e+01_r8,2.1244e+01_r8,2.6472e+01_r8, &
     &3.1566e+01_r8,3.6158e+01_r8,4.2487e+01_r8/)
      kao(:, 4, 5,16) = (/ &
     &1.3867e-01_r8,6.3343e+00_r8,1.2694e+01_r8,1.9018e+01_r8,2.5310e+01_r8,3.1544e+01_r8, &
     &3.7609e+01_r8,4.3076e+01_r8,5.0619e+01_r8/)
      kao(:, 5, 5,16) = (/ &
     &1.3442e-01_r8,7.4110e+00_r8,1.4809e+01_r8,2.2187e+01_r8,2.9523e+01_r8,3.6788e+01_r8, &
     &4.3874e+01_r8,5.0262e+01_r8,5.9046e+01_r8/)
      kao(:, 1, 6,16) = (/ &
     &3.3965e-01_r8,3.4550e+00_r8,6.9058e+00_r8,1.0352e+01_r8,1.3789e+01_r8,1.7206e+01_r8, &
     &2.0578e+01_r8,2.3766e+01_r8,2.7578e+01_r8/)
      kao(:, 2, 6,16) = (/ &
     &3.2990e-01_r8,4.4451e+00_r8,8.8565e+00_r8,1.3318e+01_r8,1.7740e+01_r8,2.2139e+01_r8, &
     &2.6477e+01_r8,3.0582e+01_r8,3.5479e+01_r8/)
      kao(:, 3, 6,16) = (/ &
     &3.2021e-01_r8,5.5240e+00_r8,1.1042e+01_r8,1.6554e+01_r8,2.2048e+01_r8,2.7511e+01_r8, &
     &3.2908e+01_r8,3.8025e+01_r8,4.4095e+01_r8/)
      kao(:, 4, 6,16) = (/ &
     &3.1092e-01_r8,6.6752e+00_r8,1.3341e+01_r8,2.0002e+01_r8,2.6641e+01_r8,3.3245e+01_r8, &
     &3.9761e+01_r8,4.5941e+01_r8,5.3282e+01_r8/)
      kao(:, 5, 6,16) = (/ &
     &3.0227e-01_r8,7.8771e+00_r8,1.5743e+01_r8,2.3602e+01_r8,3.1434e+01_r8,3.9236e+01_r8, &
     &4.6923e+01_r8,5.4228e+01_r8,6.2865e+01_r8/)
      kao(:, 1, 7,16) = (/ &
     &7.9672e-01_r8,3.3862e+00_r8,6.7703e+00_r8,1.0151e+01_r8,1.3528e+01_r8,1.6895e+01_r8, &
     &2.0243e+01_r8,2.3498e+01_r8,2.7056e+01_r8/)
      kao(:, 2, 7,16) = (/ &
     &7.7399e-01_r8,4.4592e+00_r8,8.9171e+00_r8,1.3369e+01_r8,1.7816e+01_r8,2.2252e+01_r8, &
     &2.6655e+01_r8,3.0954e+01_r8,3.5514e+01_r8/)
      kao(:, 3, 7,16) = (/ &
     &7.5170e-01_r8,5.6480e+00_r8,1.1293e+01_r8,1.6933e+01_r8,2.2566e+01_r8,2.8186e+01_r8, &
     &3.3769e+01_r8,3.9205e+01_r8,4.5131e+01_r8/)
      kao(:, 4, 7,16) = (/ &
     &7.3106e-01_r8,6.9294e+00_r8,1.3857e+01_r8,2.0779e+01_r8,2.7691e+01_r8,3.4583e+01_r8, &
     &4.1435e+01_r8,4.8102e+01_r8,5.5380e+01_r8/)
      kao(:, 5, 7,16) = (/ &
     &7.1147e-01_r8,8.2841e+00_r8,1.6563e+01_r8,2.4830e+01_r8,3.3089e+01_r8,4.1334e+01_r8, &
     &4.9522e+01_r8,5.7496e+01_r8,6.6175e+01_r8/)
      kao(:, 1, 8,16) = (/ &
     &2.2037e+00_r8,3.2722e+00_r8,6.5418e+00_r8,9.8122e+00_r8,1.3082e+01_r8,1.6344e+01_r8, &
     &1.9599e+01_r8,2.2817e+01_r8,2.6163e+01_r8/)
      kao(:, 2, 8,16) = (/ &
     &2.1416e+00_r8,4.4204e+00_r8,8.8385e+00_r8,1.3255e+01_r8,1.7675e+01_r8,2.2079e+01_r8, &
     &2.6477e+01_r8,3.0833e+01_r8,3.5348e+01_r8/)
      kao(:, 3, 8,16) = (/ &
     &2.0842e+00_r8,5.7151e+00_r8,1.1428e+01_r8,1.7137e+01_r8,2.2842e+01_r8,2.8548e+01_r8, &
     &3.4230e+01_r8,3.9856e+01_r8,4.5681e+01_r8/)
      kao(:, 4, 8,16) = (/ &
     &2.0305e+00_r8,7.1274e+00_r8,1.4255e+01_r8,2.1373e+01_r8,2.8489e+01_r8,3.5598e+01_r8, &
     &4.2693e+01_r8,4.9704e+01_r8,5.6975e+01_r8/)
      kao(:, 5, 8,16) = (/ &
     &1.9781e+00_r8,8.6369e+00_r8,1.7269e+01_r8,2.5895e+01_r8,3.4524e+01_r8,4.3140e+01_r8, &
     &5.1725e+01_r8,6.0225e+01_r8,6.9043e+01_r8/)
      kao(:, 1, 9,16) = (/ &
     &1.1509e+01_r8,1.0070e+01_r8,8.6316e+00_r8,9.3146e+00_r8,1.2418e+01_r8,1.5525e+01_r8, &
     &1.8622e+01_r8,2.1717e+01_r8,2.4834e+01_r8/)
      kao(:, 2, 9,16) = (/ &
     &1.1216e+01_r8,9.8124e+00_r8,8.9628e+00_r8,1.2947e+01_r8,1.7258e+01_r8,2.1566e+01_r8, &
     &2.5882e+01_r8,3.0171e+01_r8,3.4512e+01_r8/)
      kao(:, 3, 9,16) = (/ &
     &1.0936e+01_r8,9.5703e+00_r8,1.1414e+01_r8,1.7115e+01_r8,2.2811e+01_r8,2.8515e+01_r8, &
     &3.4212e+01_r8,3.9896e+01_r8,4.5613e+01_r8/)
      kao(:, 4, 9,16) = (/ &
     &1.0665e+01_r8,9.3327e+00_r8,1.4497e+01_r8,2.1741e+01_r8,2.8981e+01_r8,3.6218e+01_r8, &
     &4.3300e+01_r8,5.0677e+01_r8,5.7950e+01_r8/)
      kao(:, 5, 9,16) = (/ &
     &1.0398e+01_r8,9.5016e+00_r8,1.7820e+01_r8,2.6724e+01_r8,3.5623e+01_r8,4.4518e+01_r8, &
     &5.3410e+01_r8,6.2271e+01_r8,7.1226e+01_r8/)
      kao(:, 1,10,16) = (/ &
     &6.7305e+01_r8,5.8689e+01_r8,5.0477e+01_r8,4.2062e+01_r8,3.3650e+01_r8,2.5240e+01_r8, &
     &1.8527e+01_r8,2.0871e+01_r8,2.3854e+01_r8/)
      kao(:, 2,10,16) = (/ &
     &6.5751e+01_r8,5.7530e+01_r8,4.9313e+01_r8,4.1093e+01_r8,3.2876e+01_r8,2.4802e+01_r8, &
     &2.5524e+01_r8,2.9774e+01_r8,3.4038e+01_r8/)
      kao(:, 3,10,16) = (/ &
     &6.4198e+01_r8,5.6172e+01_r8,4.8149e+01_r8,4.0130e+01_r8,3.2100e+01_r8,2.8998e+01_r8, &
     &3.4448e+01_r8,4.0179e+01_r8,4.5916e+01_r8/)
      kao(:, 4,10,16) = (/ &
     &6.2664e+01_r8,5.4833e+01_r8,4.6832e+01_r8,3.9166e+01_r8,3.2607e+01_r8,3.7058e+01_r8, &
     &4.4476e+01_r8,5.1875e+01_r8,5.9284e+01_r8/)
      kao(:, 5,10,16) = (/ &
     &6.1101e+01_r8,5.3467e+01_r8,4.5664e+01_r8,3.8190e+01_r8,3.7365e+01_r8,4.6149e+01_r8, &
     &5.5367e+01_r8,6.4570e+01_r8,7.3787e+01_r8/)
      kao(:, 1,11,16) = (/ &
     &1.3576e+02_r8,1.1879e+02_r8,1.0182e+02_r8,8.4849e+01_r8,6.7875e+01_r8,5.0907e+01_r8, &
     &3.3938e+01_r8,2.3799e+01_r8,9.0162e+00_r8/)
      kao(:, 2,11,16) = (/ &
     &1.3280e+02_r8,1.1619e+02_r8,9.9587e+01_r8,8.3000e+01_r8,6.6392e+01_r8,4.9800e+01_r8, &
     &3.3906e+01_r8,3.3859e+01_r8,3.7265e+01_r8/)
      kao(:, 3,11,16) = (/ &
     &1.2969e+02_r8,1.1350e+02_r8,9.7289e+01_r8,8.1076e+01_r8,6.4844e+01_r8,4.8642e+01_r8, &
     &3.9970e+01_r8,4.5587e+01_r8,5.2094e+01_r8/)
      kao(:, 4,11,16) = (/ &
     &1.2653e+02_r8,1.1071e+02_r8,9.4885e+01_r8,7.9077e+01_r8,6.3265e+01_r8,4.8850e+01_r8, &
     &5.0310e+01_r8,5.8678e+01_r8,6.7071e+01_r8/)
      kao(:, 5,11,16) = (/ &
     &1.2325e+02_r8,1.0784e+02_r8,9.2433e+01_r8,7.7029e+01_r8,6.1622e+01_r8,5.4553e+01_r8, &
     &6.2511e+01_r8,7.2895e+01_r8,8.3291e+01_r8/)
      kao(:, 1,12,16) = (/ &
     &2.0298e+02_r8,1.7762e+02_r8,1.5224e+02_r8,1.2687e+02_r8,1.0147e+02_r8,7.6126e+01_r8, &
     &5.0748e+01_r8,2.9045e+01_r8,9.6314e-05_r8/)
      kao(:, 2,12,16) = (/ &
     &1.9850e+02_r8,1.7368e+02_r8,1.4888e+02_r8,1.2405e+02_r8,9.9250e+01_r8,7.4435e+01_r8, &
     &4.9625e+01_r8,3.8234e+01_r8,2.3705e+01_r8/)
      kao(:, 3,12,16) = (/ &
     &1.9369e+02_r8,1.6949e+02_r8,1.4528e+02_r8,1.2103e+02_r8,9.6845e+01_r8,7.2640e+01_r8, &
     &5.1319e+01_r8,5.1242e+01_r8,5.0529e+01_r8/)
      kao(:, 4,12,16) = (/ &
     &1.8865e+02_r8,1.6508e+02_r8,1.4148e+02_r8,1.1791e+02_r8,9.4323e+01_r8,7.0746e+01_r8, &
     &5.9155e+01_r8,6.5776e+01_r8,7.5148e+01_r8/)
      kao(:, 5,12,16) = (/ &
     &1.8345e+02_r8,1.6051e+02_r8,1.3757e+02_r8,1.1465e+02_r8,9.1715e+01_r8,7.1673e+01_r8, &
     &7.0340e+01_r8,8.1440e+01_r8,9.3046e+01_r8/)
      kao(:, 1,13,16) = (/ &
     &2.4179e+02_r8,2.1156e+02_r8,1.8133e+02_r8,1.5111e+02_r8,1.2089e+02_r8,9.0670e+01_r8, &
     &6.0447e+01_r8,3.4181e+01_r8,7.5740e-05_r8/)
      kao(:, 2,13,16) = (/ &
     &2.3602e+02_r8,2.0653e+02_r8,1.7702e+02_r8,1.4755e+02_r8,1.1802e+02_r8,8.8512e+01_r8, &
     &5.9018e+01_r8,4.3484e+01_r8,2.5520e+01_r8/)
      kao(:, 3,13,16) = (/ &
     &2.2984e+02_r8,2.0112e+02_r8,1.7238e+02_r8,1.4366e+02_r8,1.1493e+02_r8,8.6216e+01_r8, &
     &6.0956e+01_r8,5.6909e+01_r8,5.1259e+01_r8/)
      kao(:, 4,13,16) = (/ &
     &2.2335e+02_r8,1.9547e+02_r8,1.6749e+02_r8,1.3960e+02_r8,1.1169e+02_r8,8.3756e+01_r8, &
     &6.8596e+01_r8,7.2790e+01_r8,7.7355e+01_r8/)
      kao(:, 5,13,16) = (/ &
     &2.1661e+02_r8,1.8954e+02_r8,1.6247e+02_r8,1.3539e+02_r8,1.0832e+02_r8,8.5058e+01_r8, &
     &7.9741e+01_r8,8.9915e+01_r8,1.0226e+02_r8/)

!     The array KBO contains absorption coefs at the 16 chosen g-values 
!     for a range of pressure levels < ~100mb and temperatures. The first 
!     index in the array, JT, which runs from 1 to 5, corresponds to 
!     different temperatures.  More specifically, JT = 3 means that the 
!     data are for the reference temperature TREF for this pressure 
!     level, JT = 2 refers to the temperature TREF-15, JT = 1 is for
!     TREF-30, JT = 4 is for TREF+15, and JT = 5 is for TREF+30.  
!     The second index, JP, runs from 13 to 59 and refers to the JPth
!     reference pressure level (see taumol.f for the value of these
!     pressure levels in mb).  The third index, IG, goes from 1 to 16,
!     and tells us which g-interval the absorption coefficients are for.

      kbo(:,13, 1) = (/ &
     &2.3382e-03_r8,2.8918e-03_r8,3.5228e-03_r8,4.2513e-03_r8,5.0992e-03_r8/)
      kbo(:,14, 1) = (/ &
     &2.0993e-03_r8,2.6087e-03_r8,3.2027e-03_r8,3.9155e-03_r8,4.7075e-03_r8/)
      kbo(:,15, 1) = (/ &
     &1.9068e-03_r8,2.4224e-03_r8,2.9993e-03_r8,3.6366e-03_r8,4.4490e-03_r8/)
      kbo(:,16, 1) = (/ &
     &1.7630e-03_r8,2.2267e-03_r8,2.7514e-03_r8,3.4114e-03_r8,4.1614e-03_r8/)
      kbo(:,17, 1) = (/ &
     &1.6519e-03_r8,2.0886e-03_r8,2.6010e-03_r8,3.2457e-03_r8,3.9066e-03_r8/)
      kbo(:,18, 1) = (/ &
     &1.5561e-03_r8,1.9733e-03_r8,2.5429e-03_r8,3.1325e-03_r8,3.6764e-03_r8/)
      kbo(:,19, 1) = (/ &
     &1.4778e-03_r8,1.9477e-03_r8,2.4734e-03_r8,2.9725e-03_r8,3.4413e-03_r8/)
      kbo(:,20, 1) = (/ &
     &1.3764e-03_r8,1.8206e-03_r8,2.2794e-03_r8,2.6918e-03_r8,3.0807e-03_r8/)
      kbo(:,21, 1) = (/ &
     &1.2547e-03_r8,1.6614e-03_r8,2.0387e-03_r8,2.3912e-03_r8,2.7222e-03_r8/)
      kbo(:,22, 1) = (/ &
     &1.1692e-03_r8,1.5034e-03_r8,1.8117e-03_r8,2.1136e-03_r8,2.3959e-03_r8/)
      kbo(:,23, 1) = (/ &
     &1.0852e-03_r8,1.3578e-03_r8,1.6152e-03_r8,1.8580e-03_r8,2.0983e-03_r8/)
      kbo(:,24, 1) = (/ &
     &9.9196e-04_r8,1.2216e-03_r8,1.4332e-03_r8,1.6336e-03_r8,1.8396e-03_r8/)
      kbo(:,25, 1) = (/ &
     &9.0621e-04_r8,1.0934e-03_r8,1.2579e-03_r8,1.4326e-03_r8,1.5972e-03_r8/)
      kbo(:,26, 1) = (/ &
     &8.1196e-04_r8,9.6544e-04_r8,1.0989e-03_r8,1.2439e-03_r8,1.3772e-03_r8/)
      kbo(:,27, 1) = (/ &
     &7.2402e-04_r8,8.4382e-04_r8,9.5455e-04_r8,1.0692e-03_r8,1.1790e-03_r8/)
      kbo(:,28, 1) = (/ &
     &6.3816e-04_r8,7.3173e-04_r8,8.2333e-04_r8,9.1530e-04_r8,1.0008e-03_r8/)
      kbo(:,29, 1) = (/ &
     &5.5611e-04_r8,6.2561e-04_r8,7.0457e-04_r8,7.7239e-04_r8,8.4074e-04_r8/)
      kbo(:,30, 1) = (/ &
     &4.7758e-04_r8,5.3585e-04_r8,5.9602e-04_r8,6.4848e-04_r8,7.0299e-04_r8/)
      kbo(:,31, 1) = (/ &
     &4.0233e-04_r8,4.5494e-04_r8,5.0095e-04_r8,5.4165e-04_r8,5.8359e-04_r8/)
      kbo(:,32, 1) = (/ &
     &3.4147e-04_r8,3.8327e-04_r8,4.2049e-04_r8,4.5512e-04_r8,4.8721e-04_r8/)
      kbo(:,33, 1) = (/ &
     &2.9210e-04_r8,3.2465e-04_r8,3.5276e-04_r8,3.8153e-04_r8,4.1121e-04_r8/)
      kbo(:,34, 1) = (/ &
     &2.4930e-04_r8,2.7584e-04_r8,2.9920e-04_r8,3.2247e-04_r8,3.4759e-04_r8/)
      kbo(:,35, 1) = (/ &
     &2.1208e-04_r8,2.3419e-04_r8,2.5253e-04_r8,2.7252e-04_r8,2.9279e-04_r8/)
      kbo(:,36, 1) = (/ &
     &1.7811e-04_r8,1.9459e-04_r8,2.1195e-04_r8,2.2908e-04_r8,2.4619e-04_r8/)
      kbo(:,37, 1) = (/ &
     &1.4252e-04_r8,1.5802e-04_r8,1.7124e-04_r8,1.8557e-04_r8,1.9967e-04_r8/)
      kbo(:,38, 1) = (/ &
     &1.1316e-04_r8,1.2691e-04_r8,1.3875e-04_r8,1.4940e-04_r8,1.6149e-04_r8/)
      kbo(:,39, 1) = (/ &
     &8.9734e-05_r8,1.0111e-04_r8,1.1110e-04_r8,1.2104e-04_r8,1.3018e-04_r8/)
      kbo(:,40, 1) = (/ &
     &6.9862e-05_r8,7.9338e-05_r8,8.7351e-05_r8,9.5361e-05_r8,1.0350e-04_r8/)
      kbo(:,41, 1) = (/ &
     &5.3903e-05_r8,6.1377e-05_r8,6.8596e-05_r8,7.4910e-05_r8,8.1525e-05_r8/)
      kbo(:,42, 1) = (/ &
     &4.1353e-05_r8,4.7327e-05_r8,5.3464e-05_r8,5.8873e-05_r8,6.3813e-05_r8/)
      kbo(:,43, 1) = (/ &
     &3.1177e-05_r8,3.6021e-05_r8,4.0748e-05_r8,4.5236e-05_r8,4.9388e-05_r8/)
      kbo(:,44, 1) = (/ &
     &2.3155e-05_r8,2.7105e-05_r8,3.0750e-05_r8,3.4487e-05_r8,3.7902e-05_r8/)
      kbo(:,45, 1) = (/ &
     &1.6939e-05_r8,2.0019e-05_r8,2.3152e-05_r8,2.6034e-05_r8,2.8825e-05_r8/)
      kbo(:,46, 1) = (/ &
     &1.2188e-05_r8,1.4774e-05_r8,1.7220e-05_r8,1.9590e-05_r8,2.1820e-05_r8/)
      kbo(:,47, 1) = (/ &
     &8.5598e-06_r8,1.0765e-05_r8,1.2719e-05_r8,1.4628e-05_r8,1.6428e-05_r8/)
      kbo(:,48, 1) = (/ &
     &5.9262e-06_r8,7.6349e-06_r8,9.2601e-06_r8,1.0811e-05_r8,1.2306e-05_r8/)
      kbo(:,49, 1) = (/ &
     &3.9332e-06_r8,5.2612e-06_r8,6.6345e-06_r8,7.8390e-06_r8,9.0160e-06_r8/)
      kbo(:,50, 1) = (/ &
     &2.6915e-06_r8,3.7062e-06_r8,4.7528e-06_r8,5.7591e-06_r8,6.6828e-06_r8/)
      kbo(:,51, 1) = (/ &
     &1.9031e-06_r8,2.5633e-06_r8,3.3817e-06_r8,4.2212e-06_r8,4.9973e-06_r8/)
      kbo(:,52, 1) = (/ &
     &1.3022e-06_r8,1.7876e-06_r8,2.4129e-06_r8,3.0582e-06_r8,3.6770e-06_r8/)
      kbo(:,53, 1) = (/ &
     &8.8514e-07_r8,1.2531e-06_r8,1.6651e-06_r8,2.1701e-06_r8,2.6821e-06_r8/)
      kbo(:,54, 1) = (/ &
     &6.3174e-07_r8,9.0490e-07_r8,1.2164e-06_r8,1.6231e-06_r8,2.0201e-06_r8/)
      kbo(:,55, 1) = (/ &
     &4.6092e-07_r8,6.6386e-07_r8,9.1477e-07_r8,1.2278e-06_r8,1.5504e-06_r8/)
      kbo(:,56, 1) = (/ &
     &3.3312e-07_r8,4.8579e-07_r8,6.8774e-07_r8,9.1495e-07_r8,1.1856e-06_r8/)
      kbo(:,57, 1) = (/ &
     &2.4004e-07_r8,3.5567e-07_r8,5.1418e-07_r8,6.8280e-07_r8,9.0960e-07_r8/)
      kbo(:,58, 1) = (/ &
     &1.7424e-07_r8,2.6290e-07_r8,3.8304e-07_r8,5.1880e-07_r8,6.9948e-07_r8/)
      kbo(:,59, 1) = (/ &
     &1.4545e-07_r8,2.2249e-07_r8,3.3056e-07_r8,4.4487e-07_r8,6.0780e-07_r8/)
      kbo(:,13, 2) = (/ &
     &1.0289e-02_r8,1.3009e-02_r8,1.5474e-02_r8,1.7839e-02_r8,2.0097e-02_r8/)
      kbo(:,14, 2) = (/ &
     &9.5725e-03_r8,1.1818e-02_r8,1.3904e-02_r8,1.5918e-02_r8,1.7958e-02_r8/)
      kbo(:,15, 2) = (/ &
     &8.9675e-03_r8,1.0842e-02_r8,1.2642e-02_r8,1.4399e-02_r8,1.6048e-02_r8/)
      kbo(:,16, 2) = (/ &
     &8.1677e-03_r8,9.7202e-03_r8,1.1280e-02_r8,1.2681e-02_r8,1.4168e-02_r8/)
      kbo(:,17, 2) = (/ &
     &7.4338e-03_r8,8.8205e-03_r8,1.0076e-02_r8,1.1262e-02_r8,1.2428e-02_r8/)
      kbo(:,18, 2) = (/ &
     &6.8634e-03_r8,8.0133e-03_r8,8.9513e-03_r8,9.9366e-03_r8,1.1014e-02_r8/)
      kbo(:,19, 2) = (/ &
     &6.3552e-03_r8,7.2047e-03_r8,8.0129e-03_r8,8.8966e-03_r8,9.8381e-03_r8/)
      kbo(:,20, 2) = (/ &
     &5.6397e-03_r8,6.2755e-03_r8,6.9887e-03_r8,7.7846e-03_r8,8.5391e-03_r8/)
      kbo(:,21, 2) = (/ &
     &4.8925e-03_r8,5.4088e-03_r8,6.0399e-03_r8,6.7004e-03_r8,7.3289e-03_r8/)
      kbo(:,22, 2) = (/ &
     &4.2004e-03_r8,4.6864e-03_r8,5.2247e-03_r8,5.7527e-03_r8,6.2510e-03_r8/)
      kbo(:,23, 2) = (/ &
     &3.5982e-03_r8,4.0432e-03_r8,4.4892e-03_r8,4.9192e-03_r8,5.3260e-03_r8/)
      kbo(:,24, 2) = (/ &
     &3.1341e-03_r8,3.4942e-03_r8,3.8506e-03_r8,4.1837e-03_r8,4.5083e-03_r8/)
      kbo(:,25, 2) = (/ &
     &2.7078e-03_r8,2.9853e-03_r8,3.2644e-03_r8,3.5527e-03_r8,3.8354e-03_r8/)
      kbo(:,26, 2) = (/ &
     &2.3166e-03_r8,2.5349e-03_r8,2.7760e-03_r8,3.0099e-03_r8,3.2441e-03_r8/)
      kbo(:,27, 2) = (/ &
     &1.9581e-03_r8,2.1476e-03_r8,2.3442e-03_r8,2.5333e-03_r8,2.7284e-03_r8/)
      kbo(:,28, 2) = (/ &
     &1.6566e-03_r8,1.8064e-03_r8,1.9708e-03_r8,2.1221e-03_r8,2.2915e-03_r8/)
      kbo(:,29, 2) = (/ &
     &1.3865e-03_r8,1.5225e-03_r8,1.6510e-03_r8,1.7817e-03_r8,1.9308e-03_r8/)
      kbo(:,30, 2) = (/ &
     &1.1671e-03_r8,1.2777e-03_r8,1.3825e-03_r8,1.4960e-03_r8,1.6203e-03_r8/)
      kbo(:,31, 2) = (/ &
     &9.8586e-04_r8,1.0724e-03_r8,1.1604e-03_r8,1.2563e-03_r8,1.3588e-03_r8/)
      kbo(:,32, 2) = (/ &
     &8.3378e-04_r8,9.0396e-04_r8,9.7429e-04_r8,1.0568e-03_r8,1.1470e-03_r8/)
      kbo(:,33, 2) = (/ &
     &7.0369e-04_r8,7.5618e-04_r8,8.2196e-04_r8,8.9196e-04_r8,9.6493e-04_r8/)
      kbo(:,34, 2) = (/ &
     &5.9334e-04_r8,6.3847e-04_r8,6.9888e-04_r8,7.5675e-04_r8,8.1741e-04_r8/)
      kbo(:,35, 2) = (/ &
     &4.9419e-04_r8,5.3430e-04_r8,5.8625e-04_r8,6.3690e-04_r8,6.8685e-04_r8/)
      kbo(:,36, 2) = (/ &
     &4.1196e-04_r8,4.5151e-04_r8,4.9203e-04_r8,5.3162e-04_r8,5.7140e-04_r8/)
      kbo(:,37, 2) = (/ &
     &3.3813e-04_r8,3.6860e-04_r8,4.0277e-04_r8,4.3459e-04_r8,4.6722e-04_r8/)
      kbo(:,38, 2) = (/ &
     &2.7817e-04_r8,3.0151e-04_r8,3.2943e-04_r8,3.5593e-04_r8,3.8227e-04_r8/)
      kbo(:,39, 2) = (/ &
     &2.2867e-04_r8,2.4762e-04_r8,2.6968e-04_r8,2.9008e-04_r8,3.1209e-04_r8/)
      kbo(:,40, 2) = (/ &
     &1.8342e-04_r8,1.9773e-04_r8,2.1631e-04_r8,2.3254e-04_r8,2.4976e-04_r8/)
      kbo(:,41, 2) = (/ &
     &1.4676e-04_r8,1.5810e-04_r8,1.7216e-04_r8,1.8594e-04_r8,1.9960e-04_r8/)
      kbo(:,42, 2) = (/ &
     &1.1746e-04_r8,1.2665e-04_r8,1.3672e-04_r8,1.4836e-04_r8,1.5881e-04_r8/)
      kbo(:,43, 2) = (/ &
     &9.3086e-05_r8,1.0013e-04_r8,1.0780e-04_r8,1.1711e-04_r8,1.2583e-04_r8/)
      kbo(:,44, 2) = (/ &
     &7.3232e-05_r8,7.8805e-05_r8,8.4882e-05_r8,9.2011e-05_r8,9.9424e-05_r8/)
      kbo(:,45, 2) = (/ &
     &5.7257e-05_r8,6.2283e-05_r8,6.6827e-05_r8,7.2104e-05_r8,7.8039e-05_r8/)
      kbo(:,46, 2) = (/ &
     &4.5024e-05_r8,4.8935e-05_r8,5.2600e-05_r8,5.6600e-05_r8,6.1280e-05_r8/)
      kbo(:,47, 2) = (/ &
     &3.5357e-05_r8,3.8098e-05_r8,4.1339e-05_r8,4.4405e-05_r8,4.7940e-05_r8/)
      kbo(:,48, 2) = (/ &
     &2.7815e-05_r8,2.9967e-05_r8,3.2437e-05_r8,3.4873e-05_r8,3.7402e-05_r8/)
      kbo(:,49, 2) = (/ &
     &2.1939e-05_r8,2.3492e-05_r8,2.5305e-05_r8,2.7332e-05_r8,2.9323e-05_r8/)
      kbo(:,50, 2) = (/ &
     &1.7237e-05_r8,1.8528e-05_r8,1.9953e-05_r8,2.1525e-05_r8,2.3159e-05_r8/)
      kbo(:,51, 2) = (/ &
     &1.3436e-05_r8,1.4671e-05_r8,1.5802e-05_r8,1.6957e-05_r8,1.8296e-05_r8/)
      kbo(:,52, 2) = (/ &
     &1.0450e-05_r8,1.1538e-05_r8,1.2438e-05_r8,1.3421e-05_r8,1.4433e-05_r8/)
      kbo(:,53, 2) = (/ &
     &8.1106e-06_r8,9.0282e-06_r8,9.8120e-06_r8,1.0593e-05_r8,1.1339e-05_r8/)
      kbo(:,54, 2) = (/ &
     &6.3166e-06_r8,7.0785e-06_r8,7.7924e-06_r8,8.4016e-06_r8,8.9926e-06_r8/)
      kbo(:,55, 2) = (/ &
     &4.9361e-06_r8,5.5830e-06_r8,6.1858e-06_r8,6.7021e-06_r8,7.1744e-06_r8/)
      kbo(:,56, 2) = (/ &
     &3.8472e-06_r8,4.3596e-06_r8,4.8727e-06_r8,5.3362e-06_r8,5.7261e-06_r8/)
      kbo(:,57, 2) = (/ &
     &2.9833e-06_r8,3.4045e-06_r8,3.8019e-06_r8,4.2184e-06_r8,4.5533e-06_r8/)
      kbo(:,58, 2) = (/ &
     &2.2932e-06_r8,2.6742e-06_r8,3.0024e-06_r8,3.3291e-06_r8,3.6047e-06_r8/)
      kbo(:,59, 2) = (/ &
     &1.8323e-06_r8,2.1714e-06_r8,2.4292e-06_r8,2.6999e-06_r8,2.9218e-06_r8/)
      kbo(:,13, 3) = (/ &
     &3.0891e-02_r8,3.3118e-02_r8,3.6308e-02_r8,3.9588e-02_r8,4.3089e-02_r8/)
      kbo(:,14, 3) = (/ &
     &2.6329e-02_r8,2.8653e-02_r8,3.1325e-02_r8,3.4211e-02_r8,3.7000e-02_r8/)
      kbo(:,15, 3) = (/ &
     &2.2620e-02_r8,2.4702e-02_r8,2.7101e-02_r8,2.9342e-02_r8,3.1645e-02_r8/)
      kbo(:,16, 3) = (/ &
     &1.9521e-02_r8,2.1493e-02_r8,2.3534e-02_r8,2.5338e-02_r8,2.7120e-02_r8/)
      kbo(:,17, 3) = (/ &
     &1.7199e-02_r8,1.8861e-02_r8,2.0377e-02_r8,2.1918e-02_r8,2.3545e-02_r8/)
      kbo(:,18, 3) = (/ &
     &1.5181e-02_r8,1.6445e-02_r8,1.7796e-02_r8,1.9171e-02_r8,2.0759e-02_r8/)
      kbo(:,19, 3) = (/ &
     &1.3401e-02_r8,1.4529e-02_r8,1.5713e-02_r8,1.7031e-02_r8,1.8531e-02_r8/)
      kbo(:,20, 3) = (/ &
     &1.1566e-02_r8,1.2595e-02_r8,1.3616e-02_r8,1.4797e-02_r8,1.6195e-02_r8/)
      kbo(:,21, 3) = (/ &
     &9.9790e-03_r8,1.0856e-02_r8,1.1739e-02_r8,1.2840e-02_r8,1.4039e-02_r8/)
      kbo(:,22, 3) = (/ &
     &8.5571e-03_r8,9.3189e-03_r8,1.0148e-02_r8,1.1149e-02_r8,1.2271e-02_r8/)
      kbo(:,23, 3) = (/ &
     &7.3578e-03_r8,7.9960e-03_r8,8.8066e-03_r8,9.6774e-03_r8,1.0719e-02_r8/)
      kbo(:,24, 3) = (/ &
     &6.2710e-03_r8,6.8510e-03_r8,7.5829e-03_r8,8.4285e-03_r8,9.3410e-03_r8/)
      kbo(:,25, 3) = (/ &
     &5.3189e-03_r8,5.9223e-03_r8,6.5735e-03_r8,7.3163e-03_r8,8.1167e-03_r8/)
      kbo(:,26, 3) = (/ &
     &4.5763e-03_r8,5.1227e-03_r8,5.7207e-03_r8,6.3561e-03_r8,7.0425e-03_r8/)
      kbo(:,27, 3) = (/ &
     &3.9329e-03_r8,4.4226e-03_r8,4.9281e-03_r8,5.4554e-03_r8,6.0474e-03_r8/)
      kbo(:,28, 3) = (/ &
     &3.3818e-03_r8,3.7926e-03_r8,4.2066e-03_r8,4.6531e-03_r8,5.1585e-03_r8/)
      kbo(:,29, 3) = (/ &
     &2.9035e-03_r8,3.2271e-03_r8,3.5855e-03_r8,3.9705e-03_r8,4.3799e-03_r8/)
      kbo(:,30, 3) = (/ &
     &2.4837e-03_r8,2.7647e-03_r8,3.0488e-03_r8,3.3703e-03_r8,3.7029e-03_r8/)
      kbo(:,31, 3) = (/ &
     &2.0927e-03_r8,2.3283e-03_r8,2.5712e-03_r8,2.8545e-03_r8,3.1157e-03_r8/)
      kbo(:,32, 3) = (/ &
     &1.7660e-03_r8,1.9568e-03_r8,2.1676e-03_r8,2.3923e-03_r8,2.6159e-03_r8/)
      kbo(:,33, 3) = (/ &
     &1.4871e-03_r8,1.6499e-03_r8,1.8213e-03_r8,2.0066e-03_r8,2.1979e-03_r8/)
      kbo(:,34, 3) = (/ &
     &1.2670e-03_r8,1.4012e-03_r8,1.5485e-03_r8,1.7073e-03_r8,1.8735e-03_r8/)
      kbo(:,35, 3) = (/ &
     &1.0672e-03_r8,1.1813e-03_r8,1.3131e-03_r8,1.4449e-03_r8,1.5924e-03_r8/)
      kbo(:,36, 3) = (/ &
     &8.9185e-04_r8,9.8733e-04_r8,1.0955e-03_r8,1.2168e-03_r8,1.3441e-03_r8/)
      kbo(:,37, 3) = (/ &
     &7.2820e-04_r8,8.0537e-04_r8,8.9528e-04_r8,9.9910e-04_r8,1.1050e-03_r8/)
      kbo(:,38, 3) = (/ &
     &5.9186e-04_r8,6.5591e-04_r8,7.2922e-04_r8,8.1759e-04_r8,9.0441e-04_r8/)
      kbo(:,39, 3) = (/ &
     &4.8327e-04_r8,5.3477e-04_r8,5.9527e-04_r8,6.6884e-04_r8,7.4026e-04_r8/)
      kbo(:,40, 3) = (/ &
     &3.8671e-04_r8,4.2869e-04_r8,4.7628e-04_r8,5.3686e-04_r8,5.9502e-04_r8/)
      kbo(:,41, 3) = (/ &
     &3.0862e-04_r8,3.4166e-04_r8,3.8000e-04_r8,4.2745e-04_r8,4.7580e-04_r8/)
      kbo(:,42, 3) = (/ &
     &2.4577e-04_r8,2.7168e-04_r8,3.0221e-04_r8,3.3942e-04_r8,3.8025e-04_r8/)
      kbo(:,43, 3) = (/ &
     &1.9416e-04_r8,2.1479e-04_r8,2.3878e-04_r8,2.6702e-04_r8,3.0069e-04_r8/)
      kbo(:,44, 3) = (/ &
     &1.5374e-04_r8,1.6929e-04_r8,1.8776e-04_r8,2.0950e-04_r8,2.3556e-04_r8/)
      kbo(:,45, 3) = (/ &
     &1.2163e-04_r8,1.3301e-04_r8,1.4695e-04_r8,1.6433e-04_r8,1.8435e-04_r8/)
      kbo(:,46, 3) = (/ &
     &9.4928e-05_r8,1.0426e-04_r8,1.1546e-04_r8,1.2841e-04_r8,1.4410e-04_r8/)
      kbo(:,47, 3) = (/ &
     &7.3995e-05_r8,8.2130e-05_r8,9.0212e-05_r8,1.0006e-04_r8,1.1186e-04_r8/)
      kbo(:,48, 3) = (/ &
     &5.7893e-05_r8,6.3962e-05_r8,7.0352e-05_r8,7.8032e-05_r8,8.7072e-05_r8/)
      kbo(:,49, 3) = (/ &
     &4.5051e-05_r8,4.9908e-05_r8,5.5306e-05_r8,6.0837e-05_r8,6.7927e-05_r8/)
      kbo(:,50, 3) = (/ &
     &3.5303e-05_r8,3.9326e-05_r8,4.3324e-05_r8,4.7812e-05_r8,5.3164e-05_r8/)
      kbo(:,51, 3) = (/ &
     &2.7771e-05_r8,3.0856e-05_r8,3.4054e-05_r8,3.7804e-05_r8,4.1758e-05_r8/)
      kbo(:,52, 3) = (/ &
     &2.1938e-05_r8,2.4227e-05_r8,2.6919e-05_r8,2.9733e-05_r8,3.2981e-05_r8/)
      kbo(:,53, 3) = (/ &
     &1.7187e-05_r8,1.9050e-05_r8,2.1224e-05_r8,2.3374e-05_r8,2.5986e-05_r8/)
      kbo(:,54, 3) = (/ &
     &1.3551e-05_r8,1.5084e-05_r8,1.6671e-05_r8,1.8493e-05_r8,2.0639e-05_r8/)
      kbo(:,55, 3) = (/ &
     &1.0736e-05_r8,1.1998e-05_r8,1.3230e-05_r8,1.4714e-05_r8,1.6387e-05_r8/)
      kbo(:,56, 3) = (/ &
     &8.4780e-06_r8,9.5613e-06_r8,1.0535e-05_r8,1.1722e-05_r8,1.2981e-05_r8/)
      kbo(:,57, 3) = (/ &
     &6.6892e-06_r8,7.5486e-06_r8,8.3874e-06_r8,9.3040e-06_r8,1.0324e-05_r8/)
      kbo(:,58, 3) = (/ &
     &5.3282e-06_r8,5.9530e-06_r8,6.6841e-06_r8,7.4078e-06_r8,8.2298e-06_r8/)
      kbo(:,59, 3) = (/ &
     &4.3459e-06_r8,4.8321e-06_r8,5.4567e-06_r8,6.0369e-06_r8,6.7261e-06_r8/)
      kbo(:,13, 4) = (/ &
     &6.7009e-02_r8,7.0746e-02_r8,7.4150e-02_r8,7.7569e-02_r8,8.1680e-02_r8/)
      kbo(:,14, 4) = (/ &
     &5.5943e-02_r8,5.8697e-02_r8,6.1678e-02_r8,6.4914e-02_r8,6.9379e-02_r8/)
      kbo(:,15, 4) = (/ &
     &4.6843e-02_r8,4.9217e-02_r8,5.1833e-02_r8,5.5783e-02_r8,5.9767e-02_r8/)
      kbo(:,16, 4) = (/ &
     &3.9239e-02_r8,4.1262e-02_r8,4.4032e-02_r8,4.7642e-02_r8,5.1925e-02_r8/)
      kbo(:,17, 4) = (/ &
     &3.3107e-02_r8,3.5295e-02_r8,3.8541e-02_r8,4.2220e-02_r8,4.6357e-02_r8/)
      kbo(:,18, 4) = (/ &
     &2.8797e-02_r8,3.1620e-02_r8,3.4631e-02_r8,3.8034e-02_r8,4.1725e-02_r8/)
      kbo(:,19, 4) = (/ &
     &2.5628e-02_r8,2.8281e-02_r8,3.1139e-02_r8,3.4358e-02_r8,3.7925e-02_r8/)
      kbo(:,20, 4) = (/ &
     &2.2579e-02_r8,2.4906e-02_r8,2.7554e-02_r8,3.0345e-02_r8,3.3488e-02_r8/)
      kbo(:,21, 4) = (/ &
     &1.9528e-02_r8,2.1738e-02_r8,2.4107e-02_r8,2.6707e-02_r8,2.9475e-02_r8/)
      kbo(:,22, 4) = (/ &
     &1.7101e-02_r8,1.8986e-02_r8,2.1039e-02_r8,2.3296e-02_r8,2.5855e-02_r8/)
      kbo(:,23, 4) = (/ &
     &1.4866e-02_r8,1.6502e-02_r8,1.8337e-02_r8,2.0414e-02_r8,2.2548e-02_r8/)
      kbo(:,24, 4) = (/ &
     &1.2821e-02_r8,1.4288e-02_r8,1.5941e-02_r8,1.7747e-02_r8,1.9679e-02_r8/)
      kbo(:,25, 4) = (/ &
     &1.1061e-02_r8,1.2369e-02_r8,1.3872e-02_r8,1.5379e-02_r8,1.7059e-02_r8/)
      kbo(:,26, 4) = (/ &
     &9.5354e-03_r8,1.0723e-02_r8,1.2012e-02_r8,1.3430e-02_r8,1.4839e-02_r8/)
      kbo(:,27, 4) = (/ &
     &8.1975e-03_r8,9.2673e-03_r8,1.0387e-02_r8,1.1650e-02_r8,1.2827e-02_r8/)
      kbo(:,28, 4) = (/ &
     &7.0231e-03_r8,7.9702e-03_r8,8.9828e-03_r8,1.0032e-02_r8,1.1053e-02_r8/)
      kbo(:,29, 4) = (/ &
     &6.0200e-03_r8,6.8421e-03_r8,7.7670e-03_r8,8.6094e-03_r8,9.5249e-03_r8/)
      kbo(:,30, 4) = (/ &
     &5.1558e-03_r8,5.8823e-03_r8,6.6735e-03_r8,7.4143e-03_r8,8.2222e-03_r8/)
      kbo(:,31, 4) = (/ &
     &4.4508e-03_r8,5.1031e-03_r8,5.7395e-03_r8,6.3990e-03_r8,7.0930e-03_r8/)
      kbo(:,32, 4) = (/ &
     &3.8687e-03_r8,4.4226e-03_r8,4.9634e-03_r8,5.5499e-03_r8,6.1447e-03_r8/)
      kbo(:,33, 4) = (/ &
     &3.3860e-03_r8,3.8414e-03_r8,4.3170e-03_r8,4.8129e-03_r8,5.3113e-03_r8/)
      kbo(:,34, 4) = (/ &
     &2.9667e-03_r8,3.3572e-03_r8,3.7642e-03_r8,4.1882e-03_r8,4.5973e-03_r8/)
      kbo(:,35, 4) = (/ &
     &2.5854e-03_r8,2.9160e-03_r8,3.2542e-03_r8,3.6120e-03_r8,3.9574e-03_r8/)
      kbo(:,36, 4) = (/ &
     &2.2132e-03_r8,2.5004e-03_r8,2.7859e-03_r8,3.0722e-03_r8,3.3673e-03_r8/)
      kbo(:,37, 4) = (/ &
     &1.8397e-03_r8,2.0798e-03_r8,2.3185e-03_r8,2.5525e-03_r8,2.8046e-03_r8/)
      kbo(:,38, 4) = (/ &
     &1.5241e-03_r8,1.7240e-03_r8,1.9250e-03_r8,2.1190e-03_r8,2.3334e-03_r8/)
      kbo(:,39, 4) = (/ &
     &1.2578e-03_r8,1.4258e-03_r8,1.5974e-03_r8,1.7602e-03_r8,1.9414e-03_r8/)
      kbo(:,40, 4) = (/ &
     &1.0136e-03_r8,1.1511e-03_r8,1.2925e-03_r8,1.4274e-03_r8,1.5799e-03_r8/)
      kbo(:,41, 4) = (/ &
     &8.1255e-04_r8,9.2485e-04_r8,1.0421e-03_r8,1.1560e-03_r8,1.2823e-03_r8/)
      kbo(:,42, 4) = (/ &
     &6.5076e-04_r8,7.4076e-04_r8,8.3891e-04_r8,9.3536e-04_r8,1.0398e-03_r8/)
      kbo(:,43, 4) = (/ &
     &5.1457e-04_r8,5.8675e-04_r8,6.6625e-04_r8,7.5025e-04_r8,8.3332e-04_r8/)
      kbo(:,44, 4) = (/ &
     &4.0130e-04_r8,4.6112e-04_r8,5.2500e-04_r8,5.9353e-04_r8,6.6396e-04_r8/)
      kbo(:,45, 4) = (/ &
     &3.1174e-04_r8,3.6176e-04_r8,4.1281e-04_r8,4.6943e-04_r8,5.2749e-04_r8/)
      kbo(:,46, 4) = (/ &
     &2.4198e-04_r8,2.8347e-04_r8,3.2327e-04_r8,3.6940e-04_r8,4.1847e-04_r8/)
      kbo(:,47, 4) = (/ &
     &1.8653e-04_r8,2.1946e-04_r8,2.5297e-04_r8,2.9033e-04_r8,3.3117e-04_r8/)
      kbo(:,48, 4) = (/ &
     &1.4273e-04_r8,1.6990e-04_r8,1.9780e-04_r8,2.2703e-04_r8,2.6076e-04_r8/)
      kbo(:,49, 4) = (/ &
     &1.1020e-04_r8,1.3076e-04_r8,1.5369e-04_r8,1.7736e-04_r8,2.0453e-04_r8/)
      kbo(:,50, 4) = (/ &
     &8.5840e-05_r8,1.0098e-04_r8,1.2003e-04_r8,1.3937e-04_r8,1.6133e-04_r8/)
      kbo(:,51, 4) = (/ &
     &6.7375e-05_r8,7.8667e-05_r8,9.3691e-05_r8,1.0967e-04_r8,1.2714e-04_r8/)
      kbo(:,52, 4) = (/ &
     &5.2333e-05_r8,6.1321e-05_r8,7.2765e-05_r8,8.6008e-05_r8,9.9915e-05_r8/)
      kbo(:,53, 4) = (/ &
     &4.0658e-05_r8,4.7664e-05_r8,5.6514e-05_r8,6.7300e-05_r8,7.8701e-05_r8/)
      kbo(:,54, 4) = (/ &
     &3.1857e-05_r8,3.7478e-05_r8,4.4306e-05_r8,5.3025e-05_r8,6.2299e-05_r8/)
      kbo(:,55, 4) = (/ &
     &2.4955e-05_r8,2.9435e-05_r8,3.4823e-05_r8,4.1578e-05_r8,4.9419e-05_r8/)
      kbo(:,56, 4) = (/ &
     &1.9655e-05_r8,2.3009e-05_r8,2.7169e-05_r8,3.2570e-05_r8,3.9005e-05_r8/)
      kbo(:,57, 4) = (/ &
     &1.5476e-05_r8,1.8100e-05_r8,2.1340e-05_r8,2.5521e-05_r8,3.0667e-05_r8/)
      kbo(:,58, 4) = (/ &
     &1.2154e-05_r8,1.4292e-05_r8,1.6827e-05_r8,2.0050e-05_r8,2.4167e-05_r8/)
      kbo(:,59, 4) = (/ &
     &9.8901e-06_r8,1.1647e-05_r8,1.3760e-05_r8,1.6454e-05_r8,1.9831e-05_r8/)
      kbo(:,13, 5) = (/ &
     &1.3634e-01_r8,1.4252e-01_r8,1.5001e-01_r8,1.6028e-01_r8,1.7134e-01_r8/)
      kbo(:,14, 5) = (/ &
     &1.1274e-01_r8,1.1839e-01_r8,1.2582e-01_r8,1.3453e-01_r8,1.4378e-01_r8/)
      kbo(:,15, 5) = (/ &
     &9.3550e-02_r8,9.9682e-02_r8,1.0681e-01_r8,1.1432e-01_r8,1.2335e-01_r8/)
      kbo(:,16, 5) = (/ &
     &7.9704e-02_r8,8.5926e-02_r8,9.2006e-02_r8,9.9216e-02_r8,1.0669e-01_r8/)
      kbo(:,17, 5) = (/ &
     &6.9562e-02_r8,7.4399e-02_r8,8.0031e-02_r8,8.6090e-02_r8,9.3210e-02_r8/)
      kbo(:,18, 5) = (/ &
     &6.1028e-02_r8,6.5373e-02_r8,7.1097e-02_r8,7.7143e-02_r8,8.4153e-02_r8/)
      kbo(:,19, 5) = (/ &
     &5.4138e-02_r8,5.9145e-02_r8,6.4366e-02_r8,7.0461e-02_r8,7.6822e-02_r8/)
      kbo(:,20, 5) = (/ &
     &4.7698e-02_r8,5.2419e-02_r8,5.7657e-02_r8,6.3398e-02_r8,6.9523e-02_r8/)
      kbo(:,21, 5) = (/ &
     &4.2126e-02_r8,4.6323e-02_r8,5.1164e-02_r8,5.6007e-02_r8,6.1597e-02_r8/)
      kbo(:,22, 5) = (/ &
     &3.6873e-02_r8,4.0763e-02_r8,4.4958e-02_r8,4.9556e-02_r8,5.4204e-02_r8/)
      kbo(:,23, 5) = (/ &
     &3.2201e-02_r8,3.5761e-02_r8,3.9530e-02_r8,4.3670e-02_r8,4.7920e-02_r8/)
      kbo(:,24, 5) = (/ &
     &2.8239e-02_r8,3.1305e-02_r8,3.4844e-02_r8,3.8415e-02_r8,4.2157e-02_r8/)
      kbo(:,25, 5) = (/ &
     &2.4669e-02_r8,2.7511e-02_r8,3.0568e-02_r8,3.3769e-02_r8,3.6890e-02_r8/)
      kbo(:,26, 5) = (/ &
     &2.1582e-02_r8,2.4173e-02_r8,2.6811e-02_r8,2.9496e-02_r8,3.2330e-02_r8/)
      kbo(:,27, 5) = (/ &
     &1.8849e-02_r8,2.1094e-02_r8,2.3446e-02_r8,2.5755e-02_r8,2.8374e-02_r8/)
      kbo(:,28, 5) = (/ &
     &1.6379e-02_r8,1.8330e-02_r8,2.0367e-02_r8,2.2542e-02_r8,2.4931e-02_r8/)
      kbo(:,29, 5) = (/ &
     &1.4280e-02_r8,1.5993e-02_r8,1.7723e-02_r8,1.9736e-02_r8,2.1895e-02_r8/)
      kbo(:,30, 5) = (/ &
     &1.2451e-02_r8,1.3902e-02_r8,1.5477e-02_r8,1.7322e-02_r8,1.9234e-02_r8/)
      kbo(:,31, 5) = (/ &
     &1.0840e-02_r8,1.2122e-02_r8,1.3593e-02_r8,1.5159e-02_r8,1.6921e-02_r8/)
      kbo(:,32, 5) = (/ &
     &9.4753e-03_r8,1.0651e-02_r8,1.1992e-02_r8,1.3397e-02_r8,1.4887e-02_r8/)
      kbo(:,33, 5) = (/ &
     &8.3358e-03_r8,9.4249e-03_r8,1.0592e-02_r8,1.1871e-02_r8,1.3208e-02_r8/)
      kbo(:,34, 5) = (/ &
     &7.3799e-03_r8,8.3765e-03_r8,9.4456e-03_r8,1.0582e-02_r8,1.1863e-02_r8/)
      kbo(:,35, 5) = (/ &
     &6.4631e-03_r8,7.3628e-03_r8,8.3364e-03_r8,9.3419e-03_r8,1.0526e-02_r8/)
      kbo(:,36, 5) = (/ &
     &5.5926e-03_r8,6.3888e-03_r8,7.2585e-03_r8,8.2192e-03_r8,9.2462e-03_r8/)
      kbo(:,37, 5) = (/ &
     &4.7015e-03_r8,5.3951e-03_r8,6.1680e-03_r8,7.0229e-03_r8,7.9329e-03_r8/)
      kbo(:,38, 5) = (/ &
     &3.9517e-03_r8,4.5644e-03_r8,5.2429e-03_r8,6.0141e-03_r8,6.8184e-03_r8/)
      kbo(:,39, 5) = (/ &
     &3.3266e-03_r8,3.8629e-03_r8,4.4575e-03_r8,5.1473e-03_r8,5.8646e-03_r8/)
      kbo(:,40, 5) = (/ &
     &2.7281e-03_r8,3.1818e-03_r8,3.6932e-03_r8,4.2742e-03_r8,4.8976e-03_r8/)
      kbo(:,41, 5) = (/ &
     &2.2270e-03_r8,2.6113e-03_r8,3.0386e-03_r8,3.5308e-03_r8,4.0601e-03_r8/)
      kbo(:,42, 5) = (/ &
     &1.8093e-03_r8,2.1403e-03_r8,2.4947e-03_r8,2.9136e-03_r8,3.3566e-03_r8/)
      kbo(:,43, 5) = (/ &
     &1.4510e-03_r8,1.7247e-03_r8,2.0294e-03_r8,2.3716e-03_r8,2.7407e-03_r8/)
      kbo(:,44, 5) = (/ &
     &1.1565e-03_r8,1.3809e-03_r8,1.6356e-03_r8,1.9170e-03_r8,2.2199e-03_r8/)
      kbo(:,45, 5) = (/ &
     &9.2074e-04_r8,1.1011e-03_r8,1.3110e-03_r8,1.5432e-03_r8,1.7974e-03_r8/)
      kbo(:,46, 5) = (/ &
     &7.2799e-04_r8,8.7147e-04_r8,1.0468e-03_r8,1.2375e-03_r8,1.4475e-03_r8/)
      kbo(:,47, 5) = (/ &
     &5.6825e-04_r8,6.8576e-04_r8,8.2827e-04_r8,9.8300e-04_r8,1.1595e-03_r8/)
      kbo(:,48, 5) = (/ &
     &4.4362e-04_r8,5.3785e-04_r8,6.5132e-04_r8,7.7947e-04_r8,9.2729e-04_r8/)
      kbo(:,49, 5) = (/ &
     &3.4360e-04_r8,4.2004e-04_r8,5.1060e-04_r8,6.1673e-04_r8,7.3913e-04_r8/)
      kbo(:,50, 5) = (/ &
     &2.6639e-04_r8,3.2974e-04_r8,4.0310e-04_r8,4.8991e-04_r8,5.9182e-04_r8/)
      kbo(:,51, 5) = (/ &
     &2.0705e-04_r8,2.5803e-04_r8,3.1790e-04_r8,3.8886e-04_r8,4.7401e-04_r8/)
      kbo(:,52, 5) = (/ &
     &1.6104e-04_r8,2.0156e-04_r8,2.4998e-04_r8,3.0713e-04_r8,3.7759e-04_r8/)
      kbo(:,53, 5) = (/ &
     &1.2422e-04_r8,1.5670e-04_r8,1.9587e-04_r8,2.4211e-04_r8,2.9925e-04_r8/)
      kbo(:,54, 5) = (/ &
     &9.6443e-05_r8,1.2239e-04_r8,1.5459e-04_r8,1.9203e-04_r8,2.3866e-04_r8/)
      kbo(:,55, 5) = (/ &
     &7.5345e-05_r8,9.6163e-05_r8,1.2185e-04_r8,1.5278e-04_r8,1.9092e-04_r8/)
      kbo(:,56, 5) = (/ &
     &5.8479e-05_r8,7.5388e-05_r8,9.6163e-05_r8,1.2109e-04_r8,1.5224e-04_r8/)
      kbo(:,57, 5) = (/ &
     &4.5173e-05_r8,5.8728e-05_r8,7.5432e-05_r8,9.5735e-05_r8,1.2084e-04_r8/)
      kbo(:,58, 5) = (/ &
     &3.5110e-05_r8,4.5659e-05_r8,5.9108e-05_r8,7.5684e-05_r8,9.5780e-05_r8/)
      kbo(:,59, 5) = (/ &
     &2.8669e-05_r8,3.7452e-05_r8,4.8577e-05_r8,6.2553e-05_r8,7.9913e-05_r8/)
      kbo(:,13, 6) = (/ &
     &3.1943e-01_r8,3.3627e-01_r8,3.5152e-01_r8,3.6856e-01_r8,3.8489e-01_r8/)
      kbo(:,14, 6) = (/ &
     &2.6955e-01_r8,2.8315e-01_r8,2.9631e-01_r8,3.1035e-01_r8,3.2480e-01_r8/)
      kbo(:,15, 6) = (/ &
     &2.2744e-01_r8,2.3792e-01_r8,2.4935e-01_r8,2.6127e-01_r8,2.7359e-01_r8/)
      kbo(:,16, 6) = (/ &
     &1.9190e-01_r8,2.0128e-01_r8,2.1209e-01_r8,2.2354e-01_r8,2.3634e-01_r8/)
      kbo(:,17, 6) = (/ &
     &1.6550e-01_r8,1.7572e-01_r8,1.8575e-01_r8,1.9639e-01_r8,2.0864e-01_r8/)
      kbo(:,18, 6) = (/ &
     &1.4664e-01_r8,1.5533e-01_r8,1.6464e-01_r8,1.7496e-01_r8,1.8532e-01_r8/)
      kbo(:,19, 6) = (/ &
     &1.3086e-01_r8,1.3857e-01_r8,1.4754e-01_r8,1.5676e-01_r8,1.6804e-01_r8/)
      kbo(:,20, 6) = (/ &
     &1.1476e-01_r8,1.2256e-01_r8,1.3048e-01_r8,1.3999e-01_r8,1.5052e-01_r8/)
      kbo(:,21, 6) = (/ &
     &1.0042e-01_r8,1.0755e-01_r8,1.1552e-01_r8,1.2457e-01_r8,1.3541e-01_r8/)
      kbo(:,22, 6) = (/ &
     &8.7811e-02_r8,9.4376e-02_r8,1.0240e-01_r8,1.1139e-01_r8,1.2190e-01_r8/)
      kbo(:,23, 6) = (/ &
     &7.6746e-02_r8,8.3440e-02_r8,9.0958e-02_r8,9.9436e-02_r8,1.0837e-01_r8/)
      kbo(:,24, 6) = (/ &
     &6.7020e-02_r8,7.3597e-02_r8,8.0186e-02_r8,8.7655e-02_r8,9.5847e-02_r8/)
      kbo(:,25, 6) = (/ &
     &5.8852e-02_r8,6.4342e-02_r8,7.0651e-02_r8,7.7553e-02_r8,8.5595e-02_r8/)
      kbo(:,26, 6) = (/ &
     &5.1501e-02_r8,5.6677e-02_r8,6.2671e-02_r8,6.9309e-02_r8,7.6862e-02_r8/)
      kbo(:,27, 6) = (/ &
     &4.5068e-02_r8,5.0089e-02_r8,5.5571e-02_r8,6.2056e-02_r8,6.8532e-02_r8/)
      kbo(:,28, 6) = (/ &
     &3.9606e-02_r8,4.4193e-02_r8,4.9408e-02_r8,5.5057e-02_r8,6.0956e-02_r8/)
      kbo(:,29, 6) = (/ &
     &3.4989e-02_r8,3.9176e-02_r8,4.4032e-02_r8,4.9174e-02_r8,5.4655e-02_r8/)
      kbo(:,30, 6) = (/ &
     &3.0943e-02_r8,3.4971e-02_r8,3.9398e-02_r8,4.4027e-02_r8,4.9163e-02_r8/)
      kbo(:,31, 6) = (/ &
     &2.7553e-02_r8,3.1287e-02_r8,3.5351e-02_r8,3.9782e-02_r8,4.4558e-02_r8/)
      kbo(:,32, 6) = (/ &
     &2.4710e-02_r8,2.8155e-02_r8,3.1869e-02_r8,3.6099e-02_r8,4.0666e-02_r8/)
      kbo(:,33, 6) = (/ &
     &2.2173e-02_r8,2.5362e-02_r8,2.8990e-02_r8,3.2965e-02_r8,3.7297e-02_r8/)
      kbo(:,34, 6) = (/ &
     &2.0107e-02_r8,2.3109e-02_r8,2.6574e-02_r8,3.0332e-02_r8,3.4357e-02_r8/)
      kbo(:,35, 6) = (/ &
     &1.8022e-02_r8,2.0877e-02_r8,2.4132e-02_r8,2.7710e-02_r8,3.1520e-02_r8/)
      kbo(:,36, 6) = (/ &
     &1.5963e-02_r8,1.8659e-02_r8,2.1660e-02_r8,2.4929e-02_r8,2.8560e-02_r8/)
      kbo(:,37, 6) = (/ &
     &1.3764e-02_r8,1.6188e-02_r8,1.8916e-02_r8,2.1932e-02_r8,2.5294e-02_r8/)
      kbo(:,38, 6) = (/ &
     &1.1849e-02_r8,1.4028e-02_r8,1.6494e-02_r8,1.9269e-02_r8,2.2340e-02_r8/)
      kbo(:,39, 6) = (/ &
     &1.0207e-02_r8,1.2194e-02_r8,1.4401e-02_r8,1.6941e-02_r8,1.9796e-02_r8/)
      kbo(:,40, 6) = (/ &
     &8.5573e-03_r8,1.0315e-02_r8,1.2260e-02_r8,1.4559e-02_r8,1.7141e-02_r8/)
      kbo(:,41, 6) = (/ &
     &7.1290e-03_r8,8.6738e-03_r8,1.0403e-02_r8,1.2445e-02_r8,1.4801e-02_r8/)
      kbo(:,42, 6) = (/ &
     &5.9179e-03_r8,7.2709e-03_r8,8.8122e-03_r8,1.0627e-02_r8,1.2787e-02_r8/)
      kbo(:,43, 6) = (/ &
     &4.8318e-03_r8,5.9892e-03_r8,7.3334e-03_r8,8.9514e-03_r8,1.0874e-02_r8/)
      kbo(:,44, 6) = (/ &
     &3.8999e-03_r8,4.8767e-03_r8,6.0501e-03_r8,7.4816e-03_r8,9.1794e-03_r8/)
      kbo(:,45, 6) = (/ &
     &3.1360e-03_r8,3.9601e-03_r8,4.9837e-03_r8,6.2240e-03_r8,7.7311e-03_r8/)
      kbo(:,46, 6) = (/ &
     &2.5027e-03_r8,3.1827e-03_r8,4.0540e-03_r8,5.1329e-03_r8,6.4480e-03_r8/)
      kbo(:,47, 6) = (/ &
     &1.9756e-03_r8,2.5273e-03_r8,3.2610e-03_r8,4.1749e-03_r8,5.3122e-03_r8/)
      kbo(:,48, 6) = (/ &
     &1.5473e-03_r8,1.9960e-03_r8,2.6043e-03_r8,3.3772e-03_r8,4.3437e-03_r8/)
      kbo(:,49, 6) = (/ &
     &1.2068e-03_r8,1.5706e-03_r8,2.0674e-03_r8,2.7091e-03_r8,3.5307e-03_r8/)
      kbo(:,50, 6) = (/ &
     &9.4521e-04_r8,1.2396e-03_r8,1.6445e-03_r8,2.1801e-03_r8,2.8792e-03_r8/)
      kbo(:,51, 6) = (/ &
     &7.3804e-04_r8,9.7746e-04_r8,1.3076e-03_r8,1.7542e-03_r8,2.3409e-03_r8/)
      kbo(:,52, 6) = (/ &
     &5.7206e-04_r8,7.6763e-04_r8,1.0338e-03_r8,1.4015e-03_r8,1.8909e-03_r8/)
      kbo(:,53, 6) = (/ &
     &4.4225e-04_r8,5.9805e-04_r8,8.1248e-04_r8,1.1113e-03_r8,1.5170e-03_r8/)
      kbo(:,54, 6) = (/ &
     &3.4467e-04_r8,4.7010e-04_r8,6.4272e-04_r8,8.8848e-04_r8,1.2276e-03_r8/)
      kbo(:,55, 6) = (/ &
     &2.6885e-04_r8,3.6925e-04_r8,5.1051e-04_r8,7.1238e-04_r8,9.9424e-04_r8/)
      kbo(:,56, 6) = (/ &
     &2.0891e-04_r8,2.8866e-04_r8,4.0323e-04_r8,5.6854e-04_r8,8.0318e-04_r8/)
      kbo(:,57, 6) = (/ &
     &1.6206e-04_r8,2.2457e-04_r8,3.1663e-04_r8,4.5154e-04_r8,6.4436e-04_r8/)
      kbo(:,58, 6) = (/ &
     &1.2565e-04_r8,1.7534e-04_r8,2.4919e-04_r8,3.5849e-04_r8,5.1835e-04_r8/)
      kbo(:,59, 6) = (/ &
     &1.0370e-04_r8,1.4590e-04_r8,2.0972e-04_r8,3.0572e-04_r8,4.4824e-04_r8/)
      kbo(:,13, 7) = (/ &
     &8.6885e-01_r8,8.9426e-01_r8,9.2071e-01_r8,9.5081e-01_r8,9.7593e-01_r8/)
      kbo(:,14, 7) = (/ &
     &7.3422e-01_r8,7.5692e-01_r8,7.8528e-01_r8,8.1141e-01_r8,8.3349e-01_r8/)
      kbo(:,15, 7) = (/ &
     &6.1192e-01_r8,6.3447e-01_r8,6.5837e-01_r8,6.7854e-01_r8,7.0269e-01_r8/)
      kbo(:,16, 7) = (/ &
     &5.0884e-01_r8,5.2842e-01_r8,5.4670e-01_r8,5.6627e-01_r8,5.8867e-01_r8/)
      kbo(:,17, 7) = (/ &
     &4.3640e-01_r8,4.5419e-01_r8,4.7288e-01_r8,4.9197e-01_r8,5.1336e-01_r8/)
      kbo(:,18, 7) = (/ &
     &3.8407e-01_r8,4.0203e-01_r8,4.1993e-01_r8,4.4018e-01_r8,4.6362e-01_r8/)
      kbo(:,19, 7) = (/ &
     &3.4228e-01_r8,3.5912e-01_r8,3.7740e-01_r8,3.9888e-01_r8,4.2103e-01_r8/)
      kbo(:,20, 7) = (/ &
     &3.0199e-01_r8,3.1730e-01_r8,3.3484e-01_r8,3.5351e-01_r8,3.7675e-01_r8/)
      kbo(:,21, 7) = (/ &
     &2.6553e-01_r8,2.8042e-01_r8,2.9603e-01_r8,3.1609e-01_r8,3.3882e-01_r8/)
      kbo(:,22, 7) = (/ &
     &2.3320e-01_r8,2.4726e-01_r8,2.6434e-01_r8,2.8368e-01_r8,3.0736e-01_r8/)
      kbo(:,23, 7) = (/ &
     &2.0578e-01_r8,2.1941e-01_r8,2.3579e-01_r8,2.5629e-01_r8,2.8224e-01_r8/)
      kbo(:,24, 7) = (/ &
     &1.8045e-01_r8,1.9362e-01_r8,2.1135e-01_r8,2.3376e-01_r8,2.5793e-01_r8/)
      kbo(:,25, 7) = (/ &
     &1.5885e-01_r8,1.7311e-01_r8,1.9174e-01_r8,2.1249e-01_r8,2.3261e-01_r8/)
      kbo(:,26, 7) = (/ &
     &1.4101e-01_r8,1.5639e-01_r8,1.7418e-01_r8,1.9114e-01_r8,2.1048e-01_r8/)
      kbo(:,27, 7) = (/ &
     &1.2599e-01_r8,1.4076e-01_r8,1.5557e-01_r8,1.7183e-01_r8,1.9023e-01_r8/)
      kbo(:,28, 7) = (/ &
     &1.1218e-01_r8,1.2546e-01_r8,1.3903e-01_r8,1.5482e-01_r8,1.7215e-01_r8/)
      kbo(:,29, 7) = (/ &
     &1.0072e-01_r8,1.1254e-01_r8,1.2583e-01_r8,1.4062e-01_r8,1.5650e-01_r8/)
      kbo(:,30, 7) = (/ &
     &9.0713e-02_r8,1.0192e-01_r8,1.1464e-01_r8,1.2854e-01_r8,1.4398e-01_r8/)
      kbo(:,31, 7) = (/ &
     &8.2277e-02_r8,9.3097e-02_r8,1.0524e-01_r8,1.1856e-01_r8,1.3355e-01_r8/)
      kbo(:,32, 7) = (/ &
     &7.5303e-02_r8,8.5763e-02_r8,9.7401e-02_r8,1.1054e-01_r8,1.2526e-01_r8/)
      kbo(:,33, 7) = (/ &
     &6.9506e-02_r8,7.9549e-02_r8,9.0902e-02_r8,1.0398e-01_r8,1.1862e-01_r8/)
      kbo(:,34, 7) = (/ &
     &6.4727e-02_r8,7.4554e-02_r8,8.5918e-02_r8,9.8930e-02_r8,1.1374e-01_r8/)
      kbo(:,35, 7) = (/ &
     &5.9573e-02_r8,6.9480e-02_r8,8.0602e-02_r8,9.3549e-02_r8,1.0847e-01_r8/)
      kbo(:,36, 7) = (/ &
     &5.4200e-02_r8,6.3825e-02_r8,7.4842e-02_r8,8.7689e-02_r8,1.0224e-01_r8/)
      kbo(:,37, 7) = (/ &
     &4.7941e-02_r8,5.7083e-02_r8,6.7560e-02_r8,8.0041e-02_r8,9.3919e-02_r8/)
      kbo(:,38, 7) = (/ &
     &4.2423e-02_r8,5.1057e-02_r8,6.0983e-02_r8,7.2873e-02_r8,8.6484e-02_r8/)
      kbo(:,39, 7) = (/ &
     &3.7589e-02_r8,4.5606e-02_r8,5.5155e-02_r8,6.6511e-02_r8,7.9703e-02_r8/)
      kbo(:,40, 7) = (/ &
     &3.2287e-02_r8,3.9605e-02_r8,4.8489e-02_r8,5.9153e-02_r8,7.1379e-02_r8/)
      kbo(:,41, 7) = (/ &
     &2.7611e-02_r8,3.4241e-02_r8,4.2425e-02_r8,5.2312e-02_r8,6.3597e-02_r8/)
      kbo(:,42, 7) = (/ &
     &2.3526e-02_r8,2.9544e-02_r8,3.7050e-02_r8,4.6066e-02_r8,5.6624e-02_r8/)
      kbo(:,43, 7) = (/ &
     &1.9724e-02_r8,2.5077e-02_r8,3.1787e-02_r8,3.9922e-02_r8,4.9656e-02_r8/)
      kbo(:,44, 7) = (/ &
     &1.6360e-02_r8,2.1054e-02_r8,2.6994e-02_r8,3.4254e-02_r8,4.3106e-02_r8/)
      kbo(:,45, 7) = (/ &
     &1.3479e-02_r8,1.7563e-02_r8,2.2810e-02_r8,2.9308e-02_r8,3.7331e-02_r8/)
      kbo(:,46, 7) = (/ &
     &1.0982e-02_r8,1.4524e-02_r8,1.9109e-02_r8,2.4872e-02_r8,3.2032e-02_r8/)
      kbo(:,47, 7) = (/ &
     &8.8182e-03_r8,1.1815e-02_r8,1.5755e-02_r8,2.0785e-02_r8,2.7117e-02_r8/)
      kbo(:,48, 7) = (/ &
     &7.0297e-03_r8,9.5228e-03_r8,1.2883e-02_r8,1.7248e-02_r8,2.2808e-02_r8/)
      kbo(:,49, 7) = (/ &
     &5.5570e-03_r8,7.6141e-03_r8,1.0446e-02_r8,1.4193e-02_r8,1.9030e-02_r8/)
      kbo(:,50, 7) = (/ &
     &4.4018e-03_r8,6.0988e-03_r8,8.5078e-03_r8,1.1727e-02_r8,1.5958e-02_r8/)
      kbo(:,51, 7) = (/ &
     &3.4813e-03_r8,4.8790e-03_r8,6.9087e-03_r8,9.6740e-03_r8,1.3370e-02_r8/)
      kbo(:,52, 7) = (/ &
     &2.7259e-03_r8,3.8645e-03_r8,5.5503e-03_r8,7.9313e-03_r8,1.1133e-02_r8/)
      kbo(:,53, 7) = (/ &
     &2.1153e-03_r8,3.0336e-03_r8,4.4195e-03_r8,6.4300e-03_r8,9.1714e-03_r8/)
      kbo(:,54, 7) = (/ &
     &1.6649e-03_r8,2.4099e-03_r8,3.5602e-03_r8,5.2651e-03_r8,7.6558e-03_r8/)
      kbo(:,55, 7) = (/ &
     &1.3120e-03_r8,1.9223e-03_r8,2.8746e-03_r8,4.3204e-03_r8,6.4144e-03_r8/)
      kbo(:,56, 7) = (/ &
     &1.0280e-03_r8,1.5213e-03_r8,2.3034e-03_r8,3.5254e-03_r8,5.3355e-03_r8/)
      kbo(:,57, 7) = (/ &
     &8.0119e-04_r8,1.1961e-03_r8,1.8353e-03_r8,2.8565e-03_r8,4.4054e-03_r8/)
      kbo(:,58, 7) = (/ &
     &6.2596e-04_r8,9.4223e-04_r8,1.4648e-03_r8,2.3194e-03_r8,3.6416e-03_r8/)
      kbo(:,59, 7) = (/ &
     &5.2923e-04_r8,8.1079e-04_r8,1.2847e-03_r8,2.0681e-03_r8,3.3065e-03_r8/)
      kbo(:,13, 8) = (/ &
     &3.0137e+00_r8,3.0721e+00_r8,3.1135e+00_r8,3.1353e+00_r8,3.1526e+00_r8/)
      kbo(:,14, 8) = (/ &
     &2.5881e+00_r8,2.6331e+00_r8,2.6669e+00_r8,2.6887e+00_r8,2.7106e+00_r8/)
      kbo(:,15, 8) = (/ &
     &2.2017e+00_r8,2.2477e+00_r8,2.2747e+00_r8,2.3022e+00_r8,2.3199e+00_r8/)
      kbo(:,16, 8) = (/ &
     &1.8745e+00_r8,1.9119e+00_r8,1.9407e+00_r8,1.9650e+00_r8,1.9910e+00_r8/)
      kbo(:,17, 8) = (/ &
     &1.5865e+00_r8,1.6181e+00_r8,1.6438e+00_r8,1.6744e+00_r8,1.7044e+00_r8/)
      kbo(:,18, 8) = (/ &
     &1.3469e+00_r8,1.3737e+00_r8,1.4061e+00_r8,1.4422e+00_r8,1.4784e+00_r8/)
      kbo(:,19, 8) = (/ &
     &1.1589e+00_r8,1.1936e+00_r8,1.2348e+00_r8,1.2728e+00_r8,1.3146e+00_r8/)
      kbo(:,20, 8) = (/ &
     &1.0242e+00_r8,1.0660e+00_r8,1.1056e+00_r8,1.1466e+00_r8,1.1869e+00_r8/)
      kbo(:,21, 8) = (/ &
     &9.1121e-01_r8,9.5273e-01_r8,9.9427e-01_r8,1.0332e+00_r8,1.0710e+00_r8/)
      kbo(:,22, 8) = (/ &
     &8.0647e-01_r8,8.4440e-01_r8,8.8114e-01_r8,9.1866e-01_r8,9.5785e-01_r8/)
      kbo(:,23, 8) = (/ &
     &7.0834e-01_r8,7.4542e-01_r8,7.7998e-01_r8,8.1759e-01_r8,8.5850e-01_r8/)
      kbo(:,24, 8) = (/ &
     &6.2177e-01_r8,6.5425e-01_r8,6.8799e-01_r8,7.2751e-01_r8,7.7799e-01_r8/)
      kbo(:,25, 8) = (/ &
     &5.4589e-01_r8,5.7729e-01_r8,6.1309e-01_r8,6.5804e-01_r8,7.1412e-01_r8/)
      kbo(:,26, 8) = (/ &
     &4.8128e-01_r8,5.1418e-01_r8,5.5324e-01_r8,6.0347e-01_r8,6.6308e-01_r8/)
      kbo(:,27, 8) = (/ &
     &4.2682e-01_r8,4.6055e-01_r8,5.0524e-01_r8,5.5765e-01_r8,6.2135e-01_r8/)
      kbo(:,28, 8) = (/ &
     &3.8006e-01_r8,4.1721e-01_r8,4.6337e-01_r8,5.1919e-01_r8,5.8322e-01_r8/)
      kbo(:,29, 8) = (/ &
     &3.4196e-01_r8,3.8125e-01_r8,4.2943e-01_r8,4.8588e-01_r8,5.5221e-01_r8/)
      kbo(:,30, 8) = (/ &
     &3.1093e-01_r8,3.5114e-01_r8,4.0038e-01_r8,4.5863e-01_r8,5.2276e-01_r8/)
      kbo(:,31, 8) = (/ &
     &2.8616e-01_r8,3.2668e-01_r8,3.7633e-01_r8,4.3472e-01_r8,4.9941e-01_r8/)
      kbo(:,32, 8) = (/ &
     &2.6688e-01_r8,3.0820e-01_r8,3.5883e-01_r8,4.1523e-01_r8,4.8206e-01_r8/)
      kbo(:,33, 8) = (/ &
     &2.5149e-01_r8,2.9538e-01_r8,3.4473e-01_r8,4.0327e-01_r8,4.6953e-01_r8/)
      kbo(:,34, 8) = (/ &
     &2.4069e-01_r8,2.8516e-01_r8,3.3563e-01_r8,3.9421e-01_r8,4.6040e-01_r8/)
      kbo(:,35, 8) = (/ &
     &2.2923e-01_r8,2.7328e-01_r8,3.2510e-01_r8,3.8300e-01_r8,4.4899e-01_r8/)
      kbo(:,36, 8) = (/ &
     &2.1677e-01_r8,2.6037e-01_r8,3.1183e-01_r8,3.6883e-01_r8,4.3509e-01_r8/)
      kbo(:,37, 8) = (/ &
     &1.9848e-01_r8,2.3986e-01_r8,2.8965e-01_r8,3.4421e-01_r8,4.0854e-01_r8/)
      kbo(:,38, 8) = (/ &
     &1.8143e-01_r8,2.2127e-01_r8,2.6901e-01_r8,3.2212e-01_r8,3.8468e-01_r8/)
      kbo(:,39, 8) = (/ &
     &1.6606e-01_r8,2.0455e-01_r8,2.5024e-01_r8,3.0203e-01_r8,3.6363e-01_r8/)
      kbo(:,40, 8) = (/ &
     &1.4741e-01_r8,1.8322e-01_r8,2.2603e-01_r8,2.7520e-01_r8,3.3417e-01_r8/)
      kbo(:,41, 8) = (/ &
     &1.3011e-01_r8,1.6308e-01_r8,2.0319e-01_r8,2.4965e-01_r8,3.0588e-01_r8/)
      kbo(:,42, 8) = (/ &
     &1.1484e-01_r8,1.4491e-01_r8,1.8233e-01_r8,2.2638e-01_r8,2.7964e-01_r8/)
      kbo(:,43, 8) = (/ &
     &9.9279e-02_r8,1.2633e-01_r8,1.6039e-01_r8,2.0179e-01_r8,2.5143e-01_r8/)
      kbo(:,44, 8) = (/ &
     &8.4904e-02_r8,1.0929e-01_r8,1.3953e-01_r8,1.7766e-01_r8,2.2379e-01_r8/)
      kbo(:,45, 8) = (/ &
     &7.2367e-02_r8,9.4015e-02_r8,1.2097e-01_r8,1.5526e-01_r8,1.9786e-01_r8/)
      kbo(:,46, 8) = (/ &
     &6.1012e-02_r8,8.0269e-02_r8,1.0419e-01_r8,1.3470e-01_r8,1.7331e-01_r8/)
      kbo(:,47, 8) = (/ &
     &5.0418e-02_r8,6.7581e-02_r8,8.8667e-02_r8,1.1556e-01_r8,1.5023e-01_r8/)
      kbo(:,48, 8) = (/ &
     &4.1555e-02_r8,5.6345e-02_r8,7.4999e-02_r8,9.8811e-02_r8,1.2934e-01_r8/)
      kbo(:,49, 8) = (/ &
     &3.3904e-02_r8,4.6392e-02_r8,6.2939e-02_r8,8.3873e-02_r8,1.1077e-01_r8/)
      kbo(:,50, 8) = (/ &
     &2.7924e-02_r8,3.8644e-02_r8,5.3103e-02_r8,7.1817e-02_r8,9.5860e-02_r8/)
      kbo(:,51, 8) = (/ &
     &2.3027e-02_r8,3.2254e-02_r8,4.4770e-02_r8,6.1630e-02_r8,8.3189e-02_r8/)
      kbo(:,52, 8) = (/ &
     &1.8860e-02_r8,2.6783e-02_r8,3.7563e-02_r8,5.2481e-02_r8,7.1941e-02_r8/)
      kbo(:,53, 8) = (/ &
     &1.5315e-02_r8,2.2045e-02_r8,3.1363e-02_r8,4.4231e-02_r8,6.1710e-02_r8/)
      kbo(:,54, 8) = (/ &
     &1.2583e-02_r8,1.8403e-02_r8,2.6586e-02_r8,3.7901e-02_r8,5.3727e-02_r8/)
      kbo(:,55, 8) = (/ &
     &1.0382e-02_r8,1.5404e-02_r8,2.2584e-02_r8,3.2684e-02_r8,4.7053e-02_r8/)
      kbo(:,56, 8) = (/ &
     &8.4944e-03_r8,1.2799e-02_r8,1.9133e-02_r8,2.8106e-02_r8,4.1010e-02_r8/)
      kbo(:,57, 8) = (/ &
     &6.8852e-03_r8,1.0598e-02_r8,1.6081e-02_r8,2.3991e-02_r8,3.5498e-02_r8/)
      kbo(:,58, 8) = (/ &
     &5.5895e-03_r8,8.7768e-03_r8,1.3535e-02_r8,2.0567e-02_r8,3.0872e-02_r8/)
      kbo(:,59, 8) = (/ &
     &4.9705e-03_r8,7.9600e-03_r8,1.2473e-02_r8,1.9319e-02_r8,2.9463e-02_r8/)
      kbo(:,13, 9) = (/ &
     &1.4590e+01_r8,1.4670e+01_r8,1.4841e+01_r8,1.4854e+01_r8,1.4880e+01_r8/)
      kbo(:,14, 9) = (/ &
     &1.3239e+01_r8,1.3368e+01_r8,1.3423e+01_r8,1.3479e+01_r8,1.3588e+01_r8/)
      kbo(:,15, 9) = (/ &
     &1.1801e+01_r8,1.1873e+01_r8,1.1983e+01_r8,1.2092e+01_r8,1.2194e+01_r8/)
      kbo(:,16, 9) = (/ &
     &1.0397e+01_r8,1.0519e+01_r8,1.0636e+01_r8,1.0761e+01_r8,1.0910e+01_r8/)
      kbo(:,17, 9) = (/ &
     &9.1941e+00_r8,9.3273e+00_r8,9.4699e+00_r8,9.6116e+00_r8,9.7497e+00_r8/)
      kbo(:,18, 9) = (/ &
     &8.2105e+00_r8,8.3532e+00_r8,8.4897e+00_r8,8.6223e+00_r8,8.7373e+00_r8/)
      kbo(:,19, 9) = (/ &
     &7.2827e+00_r8,7.4240e+00_r8,7.5562e+00_r8,7.6727e+00_r8,7.7914e+00_r8/)
      kbo(:,20, 9) = (/ &
     &6.3721e+00_r8,6.4943e+00_r8,6.6028e+00_r8,6.7186e+00_r8,6.8391e+00_r8/)
      kbo(:,21, 9) = (/ &
     &5.5515e+00_r8,5.6468e+00_r8,5.7503e+00_r8,5.8563e+00_r8,5.9656e+00_r8/)
      kbo(:,22, 9) = (/ &
     &4.8000e+00_r8,4.8972e+00_r8,4.9944e+00_r8,5.1084e+00_r8,5.2408e+00_r8/)
      kbo(:,23, 9) = (/ &
     &4.1624e+00_r8,4.2656e+00_r8,4.3811e+00_r8,4.5085e+00_r8,4.6380e+00_r8/)
      kbo(:,24, 9) = (/ &
     &3.6468e+00_r8,3.7664e+00_r8,3.9092e+00_r8,4.0407e+00_r8,4.1687e+00_r8/)
      kbo(:,25, 9) = (/ &
     &3.2292e+00_r8,3.3800e+00_r8,3.5189e+00_r8,3.6529e+00_r8,3.8087e+00_r8/)
      kbo(:,26, 9) = (/ &
     &2.9129e+00_r8,3.0593e+00_r8,3.1926e+00_r8,3.3487e+00_r8,3.5171e+00_r8/)
      kbo(:,27, 9) = (/ &
     &2.6651e+00_r8,2.7860e+00_r8,2.9417e+00_r8,3.1050e+00_r8,3.2838e+00_r8/)
      kbo(:,28, 9) = (/ &
     &2.4547e+00_r8,2.5852e+00_r8,2.7243e+00_r8,2.8973e+00_r8,3.0879e+00_r8/)
      kbo(:,29, 9) = (/ &
     &2.2775e+00_r8,2.4144e+00_r8,2.5520e+00_r8,2.7166e+00_r8,2.9171e+00_r8/)
      kbo(:,30, 9) = (/ &
     &2.1281e+00_r8,2.2766e+00_r8,2.4266e+00_r8,2.5792e+00_r8,2.7778e+00_r8/)
      kbo(:,31, 9) = (/ &
     &1.9982e+00_r8,2.1596e+00_r8,2.3215e+00_r8,2.4758e+00_r8,2.6690e+00_r8/)
      kbo(:,32, 9) = (/ &
     &1.8974e+00_r8,2.0696e+00_r8,2.2391e+00_r8,2.4103e+00_r8,2.6183e+00_r8/)
      kbo(:,33, 9) = (/ &
     &1.8191e+00_r8,1.9994e+00_r8,2.1809e+00_r8,2.3775e+00_r8,2.6019e+00_r8/)
      kbo(:,34, 9) = (/ &
     &1.7674e+00_r8,1.9617e+00_r8,2.1590e+00_r8,2.3767e+00_r8,2.6194e+00_r8/)
      kbo(:,35, 9) = (/ &
     &1.7160e+00_r8,1.9253e+00_r8,2.1379e+00_r8,2.3725e+00_r8,2.6356e+00_r8/)
      kbo(:,36, 9) = (/ &
     &1.6660e+00_r8,1.8913e+00_r8,2.1169e+00_r8,2.3615e+00_r8,2.6378e+00_r8/)
      kbo(:,37, 9) = (/ &
     &1.5784e+00_r8,1.8090e+00_r8,2.0343e+00_r8,2.2860e+00_r8,2.5707e+00_r8/)
      kbo(:,38, 9) = (/ &
     &1.4967e+00_r8,1.7299e+00_r8,1.9619e+00_r8,2.2122e+00_r8,2.4970e+00_r8/)
      kbo(:,39, 9) = (/ &
     &1.4275e+00_r8,1.6566e+00_r8,1.8885e+00_r8,2.1422e+00_r8,2.4238e+00_r8/)
      kbo(:,40, 9) = (/ &
     &1.3319e+00_r8,1.5527e+00_r8,1.7867e+00_r8,2.0342e+00_r8,2.3084e+00_r8/)
      kbo(:,41, 9) = (/ &
     &1.2324e+00_r8,1.4488e+00_r8,1.6798e+00_r8,1.9260e+00_r8,2.1920e+00_r8/)
      kbo(:,42, 9) = (/ &
     &1.1393e+00_r8,1.3560e+00_r8,1.5786e+00_r8,1.8237e+00_r8,2.0822e+00_r8/)
      kbo(:,43, 9) = (/ &
     &1.0393e+00_r8,1.2480e+00_r8,1.4586e+00_r8,1.7011e+00_r8,1.9564e+00_r8/)
      kbo(:,44, 9) = (/ &
     &9.4004e-01_r8,1.1318e+00_r8,1.3401e+00_r8,1.5753e+00_r8,1.8301e+00_r8/)
      kbo(:,45, 9) = (/ &
     &8.4677e-01_r8,1.0287e+00_r8,1.2277e+00_r8,1.4538e+00_r8,1.7017e+00_r8/)
      kbo(:,46, 9) = (/ &
     &7.5668e-01_r8,9.2772e-01_r8,1.1175e+00_r8,1.3351e+00_r8,1.5740e+00_r8/)
      kbo(:,47, 9) = (/ &
     &6.6952e-01_r8,8.3230e-01_r8,1.0096e+00_r8,1.2100e+00_r8,1.4418e+00_r8/)
      kbo(:,48, 9) = (/ &
     &5.9179e-01_r8,7.4047e-01_r8,9.0922e-01_r8,1.0966e+00_r8,1.3183e+00_r8/)
      kbo(:,49, 9) = (/ &
     &5.2110e-01_r8,6.5712e-01_r8,8.1623e-01_r8,9.9075e-01_r8,1.1944e+00_r8/)
      kbo(:,50, 9) = (/ &
     &4.6158e-01_r8,5.8589e-01_r8,7.3680e-01_r8,8.9883e-01_r8,1.0896e+00_r8/)
      kbo(:,51, 9) = (/ &
     &4.0970e-01_r8,5.2471e-01_r8,6.6511e-01_r8,8.1893e-01_r8,1.0001e+00_r8/)
      kbo(:,52, 9) = (/ &
     &3.6376e-01_r8,4.6797e-01_r8,5.9787e-01_r8,7.4696e-01_r8,9.1589e-01_r8/)
      kbo(:,53, 9) = (/ &
     &3.2051e-01_r8,4.1628e-01_r8,5.3506e-01_r8,6.7993e-01_r8,8.3743e-01_r8/)
      kbo(:,54, 9) = (/ &
     &2.8466e-01_r8,3.7491e-01_r8,4.8412e-01_r8,6.2077e-01_r8,7.6925e-01_r8/)
      kbo(:,55, 9) = (/ &
     &2.5367e-01_r8,3.3870e-01_r8,4.3869e-01_r8,5.6524e-01_r8,7.0875e-01_r8/)
      kbo(:,56, 9) = (/ &
     &2.2562e-01_r8,3.0476e-01_r8,3.9766e-01_r8,5.1473e-01_r8,6.5170e-01_r8/)
      kbo(:,57, 9) = (/ &
     &1.9827e-01_r8,2.7217e-01_r8,3.6127e-01_r8,4.6695e-01_r8,5.9679e-01_r8/)
      kbo(:,58, 9) = (/ &
     &1.7439e-01_r8,2.4383e-01_r8,3.2816e-01_r8,4.2523e-01_r8,5.4584e-01_r8/)
      kbo(:,59, 9) = (/ &
     &1.6511e-01_r8,2.3377e-01_r8,3.1581e-01_r8,4.1157e-01_r8,5.2975e-01_r8/)
      kbo(:,13,10) = (/ &
     &4.0695e+01_r8,4.0469e+01_r8,4.0155e+01_r8,4.1544e+01_r8,4.2682e+01_r8/)
      kbo(:,14,10) = (/ &
     &3.9304e+01_r8,3.9060e+01_r8,4.0807e+01_r8,4.1587e+01_r8,4.0953e+01_r8/)
      kbo(:,15,10) = (/ &
     &3.7657e+01_r8,3.9117e+01_r8,3.9307e+01_r8,3.8957e+01_r8,3.9710e+01_r8/)
      kbo(:,16,10) = (/ &
     &3.6278e+01_r8,3.6420e+01_r8,3.6566e+01_r8,3.7322e+01_r8,3.7268e+01_r8/)
      kbo(:,17,10) = (/ &
     &3.3662e+01_r8,3.3973e+01_r8,3.4667e+01_r8,3.4884e+01_r8,3.5251e+01_r8/)
      kbo(:,18,10) = (/ &
     &3.1195e+01_r8,3.1946e+01_r8,3.2272e+01_r8,3.2818e+01_r8,3.3898e+01_r8/)
      kbo(:,19,10) = (/ &
     &2.9346e+01_r8,2.9678e+01_r8,3.0231e+01_r8,3.1581e+01_r8,3.2542e+01_r8/)
      kbo(:,20,10) = (/ &
     &2.6569e+01_r8,2.7189e+01_r8,2.8571e+01_r8,2.9702e+01_r8,3.0461e+01_r8/)
      kbo(:,21,10) = (/ &
     &2.3800e+01_r8,2.5133e+01_r8,2.6296e+01_r8,2.7333e+01_r8,2.8348e+01_r8/)
      kbo(:,22,10) = (/ &
     &2.1748e+01_r8,2.2899e+01_r8,2.3947e+01_r8,2.5006e+01_r8,2.6299e+01_r8/)
      kbo(:,23,10) = (/ &
     &1.9685e+01_r8,2.0476e+01_r8,2.1391e+01_r8,2.2690e+01_r8,2.3900e+01_r8/)
      kbo(:,24,10) = (/ &
     &1.7032e+01_r8,1.7826e+01_r8,1.8674e+01_r8,1.9703e+01_r8,2.1087e+01_r8/)
      kbo(:,25,10) = (/ &
     &1.4880e+01_r8,1.5564e+01_r8,1.6390e+01_r8,1.7502e+01_r8,1.8671e+01_r8/)
      kbo(:,26,10) = (/ &
     &1.3363e+01_r8,1.4020e+01_r8,1.5087e+01_r8,1.6178e+01_r8,1.7289e+01_r8/)
      kbo(:,27,10) = (/ &
     &1.1727e+01_r8,1.2959e+01_r8,1.3942e+01_r8,1.5094e+01_r8,1.6463e+01_r8/)
      kbo(:,28,10) = (/ &
     &1.0659e+01_r8,1.1764e+01_r8,1.3018e+01_r8,1.4300e+01_r8,1.5936e+01_r8/)
      kbo(:,29,10) = (/ &
     &9.6581e+00_r8,1.0907e+01_r8,1.2325e+01_r8,1.4028e+01_r8,1.5807e+01_r8/)
      kbo(:,30,10) = (/ &
     &8.9612e+00_r8,1.0145e+01_r8,1.1747e+01_r8,1.3771e+01_r8,1.5726e+01_r8/)
      kbo(:,31,10) = (/ &
     &8.6124e+00_r8,9.7350e+00_r8,1.1421e+01_r8,1.3475e+01_r8,1.5366e+01_r8/)
      kbo(:,32,10) = (/ &
     &8.5911e+00_r8,9.4800e+00_r8,1.1115e+01_r8,1.3010e+01_r8,1.4984e+01_r8/)
      kbo(:,33,10) = (/ &
     &8.6709e+00_r8,9.3343e+00_r8,1.0809e+01_r8,1.2622e+01_r8,1.4676e+01_r8/)
      kbo(:,34,10) = (/ &
     &8.8793e+00_r8,9.5541e+00_r8,1.0639e+01_r8,1.2461e+01_r8,1.4700e+01_r8/)
      kbo(:,35,10) = (/ &
     &9.1036e+00_r8,9.7617e+00_r8,1.0550e+01_r8,1.2303e+01_r8,1.4597e+01_r8/)
      kbo(:,36,10) = (/ &
     &9.1500e+00_r8,9.8472e+00_r8,1.0675e+01_r8,1.1920e+01_r8,1.4033e+01_r8/)
      kbo(:,37,10) = (/ &
     &8.9913e+00_r8,9.7513e+00_r8,1.0626e+01_r8,1.1848e+01_r8,1.3311e+01_r8/)
      kbo(:,38,10) = (/ &
     &8.8541e+00_r8,9.6133e+00_r8,1.0479e+01_r8,1.1805e+01_r8,1.2978e+01_r8/)
      kbo(:,39,10) = (/ &
     &8.6355e+00_r8,9.4791e+00_r8,1.0441e+01_r8,1.1774e+01_r8,1.2974e+01_r8/)
      kbo(:,40,10) = (/ &
     &8.2572e+00_r8,9.1900e+00_r8,1.0103e+01_r8,1.1340e+01_r8,1.2612e+01_r8/)
      kbo(:,41,10) = (/ &
     &7.9700e+00_r8,8.8564e+00_r8,9.7227e+00_r8,1.0892e+01_r8,1.2191e+01_r8/)
      kbo(:,42,10) = (/ &
     &7.7269e+00_r8,8.5147e+00_r8,9.3572e+00_r8,1.0449e+01_r8,1.1769e+01_r8/)
      kbo(:,43,10) = (/ &
     &7.3457e+00_r8,8.1022e+00_r8,8.9870e+00_r8,9.9755e+00_r8,1.1267e+01_r8/)
      kbo(:,44,10) = (/ &
     &6.8559e+00_r8,7.7825e+00_r8,8.6085e+00_r8,9.5618e+00_r8,1.0705e+01_r8/)
      kbo(:,45,10) = (/ &
     &6.3680e+00_r8,7.3808e+00_r8,8.2404e+00_r8,9.1444e+00_r8,1.0228e+01_r8/)
      kbo(:,46,10) = (/ &
     &5.9178e+00_r8,6.9688e+00_r8,7.8931e+00_r8,8.8310e+00_r8,9.8114e+00_r8/)
      kbo(:,47,10) = (/ &
     &5.4530e+00_r8,6.4924e+00_r8,7.5375e+00_r8,8.5314e+00_r8,9.4745e+00_r8/)
      kbo(:,48,10) = (/ &
     &4.9630e+00_r8,6.0598e+00_r8,7.0862e+00_r8,8.1895e+00_r8,9.1462e+00_r8/)
      kbo(:,49,10) = (/ &
     &4.4814e+00_r8,5.6082e+00_r8,6.6461e+00_r8,7.8385e+00_r8,8.8792e+00_r8/)
      kbo(:,50,10) = (/ &
     &4.0666e+00_r8,5.1497e+00_r8,6.2742e+00_r8,7.4367e+00_r8,8.5539e+00_r8/)
      kbo(:,51,10) = (/ &
     &3.6813e+00_r8,4.7093e+00_r8,5.9040e+00_r8,7.0217e+00_r8,8.2062e+00_r8/)
      kbo(:,52,10) = (/ &
     &3.3213e+00_r8,4.2985e+00_r8,5.4430e+00_r8,6.5658e+00_r8,7.7730e+00_r8/)
      kbo(:,53,10) = (/ &
     &2.9730e+00_r8,3.8940e+00_r8,5.0012e+00_r8,6.1367e+00_r8,7.2957e+00_r8/)
      kbo(:,54,10) = (/ &
     &2.6494e+00_r8,3.5088e+00_r8,4.5590e+00_r8,5.7479e+00_r8,6.8609e+00_r8/)
      kbo(:,55,10) = (/ &
     &2.3517e+00_r8,3.1542e+00_r8,4.1525e+00_r8,5.3587e+00_r8,6.4637e+00_r8/)
      kbo(:,56,10) = (/ &
     &2.0870e+00_r8,2.8232e+00_r8,3.7684e+00_r8,4.9288e+00_r8,6.0659e+00_r8/)
      kbo(:,57,10) = (/ &
     &1.8716e+00_r8,2.5211e+00_r8,3.3862e+00_r8,4.4963e+00_r8,5.6364e+00_r8/)
      kbo(:,58,10) = (/ &
     &1.6996e+00_r8,2.2494e+00_r8,3.0457e+00_r8,4.0946e+00_r8,5.2813e+00_r8/)
      kbo(:,59,10) = (/ &
     &1.6125e+00_r8,2.1057e+00_r8,2.8675e+00_r8,3.8607e+00_r8,5.0173e+00_r8/)
      kbo(:,13,11) = (/ &
     &5.4280e+01_r8,5.5937e+01_r8,5.6472e+01_r8,5.6083e+01_r8,5.6645e+01_r8/)
      kbo(:,14,11) = (/ &
     &5.6104e+01_r8,5.7569e+01_r8,5.6325e+01_r8,5.6970e+01_r8,5.8322e+01_r8/)
      kbo(:,15,11) = (/ &
     &5.6157e+01_r8,5.5505e+01_r8,5.6534e+01_r8,5.8680e+01_r8,5.8495e+01_r8/)
      kbo(:,16,11) = (/ &
     &5.4215e+01_r8,5.5590e+01_r8,5.7381e+01_r8,5.6844e+01_r8,5.6502e+01_r8/)
      kbo(:,17,11) = (/ &
     &5.3917e+01_r8,5.5209e+01_r8,5.4751e+01_r8,5.5176e+01_r8,5.5535e+01_r8/)
      kbo(:,18,11) = (/ &
     &5.2925e+01_r8,5.3017e+01_r8,5.3849e+01_r8,5.4671e+01_r8,5.5470e+01_r8/)
      kbo(:,19,11) = (/ &
     &5.0412e+01_r8,5.1474e+01_r8,5.2761e+01_r8,5.3623e+01_r8,5.4522e+01_r8/)
      kbo(:,20,11) = (/ &
     &4.7799e+01_r8,4.9437e+01_r8,5.0594e+01_r8,5.1515e+01_r8,5.3379e+01_r8/)
      kbo(:,21,11) = (/ &
     &4.5510e+01_r8,4.6838e+01_r8,4.7923e+01_r8,4.9803e+01_r8,5.2087e+01_r8/)
      kbo(:,22,11) = (/ &
     &4.2197e+01_r8,4.3528e+01_r8,4.5703e+01_r8,4.8296e+01_r8,5.0603e+01_r8/)
      kbo(:,23,11) = (/ &
     &3.8776e+01_r8,4.1167e+01_r8,4.4015e+01_r8,4.6341e+01_r8,4.9195e+01_r8/)
      kbo(:,24,11) = (/ &
     &3.6077e+01_r8,3.8799e+01_r8,4.1478e+01_r8,4.4468e+01_r8,4.7105e+01_r8/)
      kbo(:,25,11) = (/ &
     &3.3423e+01_r8,3.6288e+01_r8,3.9007e+01_r8,4.1836e+01_r8,4.5174e+01_r8/)
      kbo(:,26,11) = (/ &
     &3.0575e+01_r8,3.3241e+01_r8,3.5927e+01_r8,3.9133e+01_r8,4.2785e+01_r8/)
      kbo(:,27,11) = (/ &
     &2.7764e+01_r8,3.0312e+01_r8,3.3054e+01_r8,3.6826e+01_r8,4.0509e+01_r8/)
      kbo(:,28,11) = (/ &
     &2.5413e+01_r8,2.8045e+01_r8,3.1419e+01_r8,3.5118e+01_r8,3.8747e+01_r8/)
      kbo(:,29,11) = (/ &
     &2.4096e+01_r8,2.6980e+01_r8,3.0700e+01_r8,3.4243e+01_r8,3.7699e+01_r8/)
      kbo(:,30,11) = (/ &
     &2.3140e+01_r8,2.6541e+01_r8,2.9953e+01_r8,3.3565e+01_r8,3.7298e+01_r8/)
      kbo(:,31,11) = (/ &
     &2.2574e+01_r8,2.6228e+01_r8,2.9925e+01_r8,3.3653e+01_r8,3.8032e+01_r8/)
      kbo(:,32,11) = (/ &
     &2.2078e+01_r8,2.6231e+01_r8,3.0164e+01_r8,3.4342e+01_r8,3.9067e+01_r8/)
      kbo(:,33,11) = (/ &
     &2.1802e+01_r8,2.6392e+01_r8,3.0637e+01_r8,3.5356e+01_r8,4.0173e+01_r8/)
      kbo(:,34,11) = (/ &
     &2.1886e+01_r8,2.6523e+01_r8,3.1557e+01_r8,3.6504e+01_r8,4.1183e+01_r8/)
      kbo(:,35,11) = (/ &
     &2.1287e+01_r8,2.6137e+01_r8,3.1875e+01_r8,3.7051e+01_r8,4.1397e+01_r8/)
      kbo(:,36,11) = (/ &
     &2.0396e+01_r8,2.5293e+01_r8,3.0920e+01_r8,3.6387e+01_r8,4.1546e+01_r8/)
      kbo(:,37,11) = (/ &
     &1.9398e+01_r8,2.4195e+01_r8,2.9734e+01_r8,3.5138e+01_r8,4.1598e+01_r8/)
      kbo(:,38,11) = (/ &
     &1.8580e+01_r8,2.3161e+01_r8,2.8626e+01_r8,3.3912e+01_r8,4.1158e+01_r8/)
      kbo(:,39,11) = (/ &
     &1.8482e+01_r8,2.2205e+01_r8,2.7504e+01_r8,3.3104e+01_r8,4.0527e+01_r8/)
      kbo(:,40,11) = (/ &
     &1.7984e+01_r8,2.0750e+01_r8,2.5770e+01_r8,3.1669e+01_r8,3.8818e+01_r8/)
      kbo(:,41,11) = (/ &
     &1.7355e+01_r8,1.9936e+01_r8,2.4013e+01_r8,3.0152e+01_r8,3.7102e+01_r8/)
      kbo(:,42,11) = (/ &
     &1.6681e+01_r8,1.9220e+01_r8,2.2251e+01_r8,2.8625e+01_r8,3.5420e+01_r8/)
      kbo(:,43,11) = (/ &
     &1.5870e+01_r8,1.8435e+01_r8,2.1070e+01_r8,2.6668e+01_r8,3.3375e+01_r8/)
      kbo(:,44,11) = (/ &
     &1.5165e+01_r8,1.7568e+01_r8,2.0082e+01_r8,2.4204e+01_r8,3.1050e+01_r8/)
      kbo(:,45,11) = (/ &
     &1.4453e+01_r8,1.6684e+01_r8,1.9148e+01_r8,2.2404e+01_r8,2.8741e+01_r8/)
      kbo(:,46,11) = (/ &
     &1.3674e+01_r8,1.5793e+01_r8,1.8236e+01_r8,2.1064e+01_r8,2.6017e+01_r8/)
      kbo(:,47,11) = (/ &
     &1.2730e+01_r8,1.4847e+01_r8,1.7129e+01_r8,1.9769e+01_r8,2.3301e+01_r8/)
      kbo(:,48,11) = (/ &
     &1.1966e+01_r8,1.3921e+01_r8,1.6062e+01_r8,1.8570e+01_r8,2.1519e+01_r8/)
      kbo(:,49,11) = (/ &
     &1.1256e+01_r8,1.2947e+01_r8,1.5051e+01_r8,1.7441e+01_r8,2.0164e+01_r8/)
      kbo(:,50,11) = (/ &
     &1.0630e+01_r8,1.2231e+01_r8,1.4125e+01_r8,1.6384e+01_r8,1.9019e+01_r8/)
      kbo(:,51,11) = (/ &
     &9.8987e+00_r8,1.1569e+01_r8,1.3215e+01_r8,1.5489e+01_r8,1.7851e+01_r8/)
      kbo(:,52,11) = (/ &
     &9.1901e+00_r8,1.0969e+01_r8,1.2500e+01_r8,1.4560e+01_r8,1.6807e+01_r8/)
      kbo(:,53,11) = (/ &
     &8.5518e+00_r8,1.0279e+01_r8,1.1856e+01_r8,1.3672e+01_r8,1.5980e+01_r8/)
      kbo(:,54,11) = (/ &
     &7.8898e+00_r8,9.6237e+00_r8,1.1322e+01_r8,1.2850e+01_r8,1.5109e+01_r8/)
      kbo(:,55,11) = (/ &
     &7.2910e+00_r8,9.0794e+00_r8,1.0802e+01_r8,1.2222e+01_r8,1.4316e+01_r8/)
      kbo(:,56,11) = (/ &
     &6.6231e+00_r8,8.4503e+00_r8,1.0147e+01_r8,1.1641e+01_r8,1.3475e+01_r8/)
      kbo(:,57,11) = (/ &
     &5.9797e+00_r8,7.8956e+00_r8,9.5656e+00_r8,1.1172e+01_r8,1.2770e+01_r8/)
      kbo(:,58,11) = (/ &
     &5.3792e+00_r8,7.3070e+00_r8,9.0406e+00_r8,1.0661e+01_r8,1.2099e+01_r8/)
      kbo(:,59,11) = (/ &
     &5.1187e+00_r8,7.0446e+00_r8,8.7908e+00_r8,1.0434e+01_r8,1.1861e+01_r8/)
      kbo(:,13,12) = (/ &
     &8.5594e+01_r8,8.5081e+01_r8,8.4548e+01_r8,8.3781e+01_r8,8.2265e+01_r8/)
      kbo(:,14,12) = (/ &
     &8.5160e+01_r8,8.5106e+01_r8,8.5561e+01_r8,8.4404e+01_r8,8.6474e+01_r8/)
      kbo(:,15,12) = (/ &
     &8.6225e+01_r8,8.6934e+01_r8,8.6406e+01_r8,8.7005e+01_r8,8.9359e+01_r8/)
      kbo(:,16,12) = (/ &
     &8.5430e+01_r8,8.5513e+01_r8,8.6639e+01_r8,9.0490e+01_r8,9.3290e+01_r8/)
      kbo(:,17,12) = (/ &
     &8.2443e+01_r8,8.4907e+01_r8,8.8384e+01_r8,9.0076e+01_r8,9.1263e+01_r8/)
      kbo(:,18,12) = (/ &
     &8.5149e+01_r8,8.7540e+01_r8,8.9291e+01_r8,9.0823e+01_r8,9.2775e+01_r8/)
      kbo(:,19,12) = (/ &
     &8.8628e+01_r8,9.0598e+01_r8,9.2322e+01_r8,9.4441e+01_r8,9.6854e+01_r8/)
      kbo(:,20,12) = (/ &
     &8.9356e+01_r8,9.1085e+01_r8,9.4127e+01_r8,9.6914e+01_r8,9.9051e+01_r8/)
      kbo(:,21,12) = (/ &
     &8.7608e+01_r8,9.1521e+01_r8,9.5537e+01_r8,9.7630e+01_r8,9.9135e+01_r8/)
      kbo(:,22,12) = (/ &
     &8.6703e+01_r8,9.1359e+01_r8,9.3725e+01_r8,9.6097e+01_r8,9.8620e+01_r8/)
      kbo(:,23,12) = (/ &
     &8.4986e+01_r8,8.8658e+01_r8,9.1547e+01_r8,9.4897e+01_r8,9.8884e+01_r8/)
      kbo(:,24,12) = (/ &
     &8.1861e+01_r8,8.5495e+01_r8,8.9569e+01_r8,9.4335e+01_r8,9.9177e+01_r8/)
      kbo(:,25,12) = (/ &
     &7.8144e+01_r8,8.2621e+01_r8,8.8221e+01_r8,9.4555e+01_r8,9.9082e+01_r8/)
      kbo(:,26,12) = (/ &
     &7.5558e+01_r8,8.1550e+01_r8,8.8515e+01_r8,9.4800e+01_r8,1.0018e+02_r8/)
      kbo(:,27,12) = (/ &
     &7.4385e+01_r8,8.1401e+01_r8,8.8755e+01_r8,9.4867e+01_r8,9.9863e+01_r8/)
      kbo(:,28,12) = (/ &
     &7.2786e+01_r8,8.0630e+01_r8,8.7375e+01_r8,9.3177e+01_r8,9.7577e+01_r8/)
      kbo(:,29,12) = (/ &
     &7.2494e+01_r8,7.9832e+01_r8,8.6004e+01_r8,9.1472e+01_r8,9.7317e+01_r8/)
      kbo(:,30,12) = (/ &
     &7.1849e+01_r8,7.8701e+01_r8,8.4991e+01_r8,9.0891e+01_r8,9.7338e+01_r8/)
      kbo(:,31,12) = (/ &
     &7.1241e+01_r8,7.7805e+01_r8,8.4010e+01_r8,9.1171e+01_r8,1.0059e+02_r8/)
      kbo(:,32,12) = (/ &
     &7.0698e+01_r8,7.7293e+01_r8,8.4547e+01_r8,9.6001e+01_r8,1.0686e+02_r8/)
      kbo(:,33,12) = (/ &
     &7.0154e+01_r8,7.8613e+01_r8,9.0857e+01_r8,1.0245e+02_r8,1.1312e+02_r8/)
      kbo(:,34,12) = (/ &
     &7.1031e+01_r8,8.3561e+01_r8,9.6187e+01_r8,1.0815e+02_r8,1.1901e+02_r8/)
      kbo(:,35,12) = (/ &
     &7.5071e+01_r8,8.8162e+01_r8,1.0114e+02_r8,1.1296e+02_r8,1.2569e+02_r8/)
      kbo(:,36,12) = (/ &
     &7.8029e+01_r8,9.1692e+01_r8,1.0504e+02_r8,1.1849e+02_r8,1.3079e+02_r8/)
      kbo(:,37,12) = (/ &
     &7.7450e+01_r8,9.1080e+01_r8,1.0499e+02_r8,1.1872e+02_r8,1.3083e+02_r8/)
      kbo(:,38,12) = (/ &
     &7.6390e+01_r8,9.0295e+01_r8,1.0451e+02_r8,1.1896e+02_r8,1.3094e+02_r8/)
      kbo(:,39,12) = (/ &
     &7.4846e+01_r8,8.9967e+01_r8,1.0468e+02_r8,1.1884e+02_r8,1.3087e+02_r8/)
      kbo(:,40,12) = (/ &
     &7.0636e+01_r8,8.6765e+01_r8,1.0145e+02_r8,1.1588e+02_r8,1.2805e+02_r8/)
      kbo(:,41,12) = (/ &
     &6.6305e+01_r8,8.2647e+01_r8,9.8224e+01_r8,1.1219e+02_r8,1.2504e+02_r8/)
      kbo(:,42,12) = (/ &
     &6.2198e+01_r8,7.8258e+01_r8,9.4811e+01_r8,1.0862e+02_r8,1.2155e+02_r8/)
      kbo(:,43,12) = (/ &
     &5.7303e+01_r8,7.2832e+01_r8,8.9604e+01_r8,1.0357e+02_r8,1.1674e+02_r8/)
      kbo(:,44,12) = (/ &
     &5.2689e+01_r8,6.6907e+01_r8,8.3558e+01_r8,9.8406e+01_r8,1.1125e+02_r8/)
      kbo(:,45,12) = (/ &
     &4.8182e+01_r8,6.1264e+01_r8,7.7478e+01_r8,9.3228e+01_r8,1.0590e+02_r8/)
      kbo(:,46,12) = (/ &
     &4.3386e+01_r8,5.6258e+01_r8,7.0871e+01_r8,8.6833e+01_r8,1.0102e+02_r8/)
      kbo(:,47,12) = (/ &
     &3.8704e+01_r8,5.0818e+01_r8,6.4039e+01_r8,7.9666e+01_r8,9.5229e+01_r8/)
      kbo(:,48,12) = (/ &
     &3.3968e+01_r8,4.5364e+01_r8,5.8393e+01_r8,7.2512e+01_r8,8.8396e+01_r8/)
      kbo(:,49,12) = (/ &
     &2.9879e+01_r8,4.0583e+01_r8,5.2774e+01_r8,6.5752e+01_r8,8.1056e+01_r8/)
      kbo(:,50,12) = (/ &
     &2.7602e+01_r8,3.6039e+01_r8,4.7664e+01_r8,6.0460e+01_r8,7.4304e+01_r8/)
      kbo(:,51,12) = (/ &
     &2.6051e+01_r8,3.1889e+01_r8,4.2974e+01_r8,5.5102e+01_r8,6.8169e+01_r8/)
      kbo(:,52,12) = (/ &
     &2.4438e+01_r8,2.8876e+01_r8,3.8469e+01_r8,5.0102e+01_r8,6.2912e+01_r8/)
      kbo(:,53,12) = (/ &
     &2.2776e+01_r8,2.7295e+01_r8,3.4271e+01_r8,4.5285e+01_r8,5.7384e+01_r8/)
      kbo(:,54,12) = (/ &
     &2.1249e+01_r8,2.5821e+01_r8,3.0686e+01_r8,4.1216e+01_r8,5.2669e+01_r8/)
      kbo(:,55,12) = (/ &
     &2.0155e+01_r8,2.4296e+01_r8,2.8676e+01_r8,3.7338e+01_r8,4.8393e+01_r8/)
      kbo(:,56,12) = (/ &
     &1.8949e+01_r8,2.2808e+01_r8,2.7284e+01_r8,3.3732e+01_r8,4.4387e+01_r8/)
      kbo(:,57,12) = (/ &
     &1.7651e+01_r8,2.1401e+01_r8,2.5896e+01_r8,3.0538e+01_r8,4.0399e+01_r8/)
      kbo(:,58,12) = (/ &
     &1.6454e+01_r8,2.0257e+01_r8,2.4400e+01_r8,2.8791e+01_r8,3.6888e+01_r8/)
      kbo(:,59,12) = (/ &
     &1.6078e+01_r8,1.9650e+01_r8,2.3686e+01_r8,2.8130e+01_r8,3.5337e+01_r8/)
      kbo(:,13,13) = (/ &
     &1.6179e+02_r8,1.5851e+02_r8,1.5620e+02_r8,1.5532e+02_r8,1.5316e+02_r8/)
      kbo(:,14,13) = (/ &
     &1.7476e+02_r8,1.7156e+02_r8,1.7068e+02_r8,1.6952e+02_r8,1.6413e+02_r8/)
      kbo(:,15,13) = (/ &
     &1.8520e+02_r8,1.8372e+02_r8,1.8384e+02_r8,1.8019e+02_r8,1.7522e+02_r8/)
      kbo(:,16,13) = (/ &
     &1.9454e+02_r8,1.9542e+02_r8,1.9248e+02_r8,1.8773e+02_r8,1.8813e+02_r8/)
      kbo(:,17,13) = (/ &
     &2.0028e+02_r8,1.9793e+02_r8,1.9596e+02_r8,1.9785e+02_r8,2.0205e+02_r8/)
      kbo(:,18,13) = (/ &
     &1.9037e+02_r8,1.9170e+02_r8,1.9555e+02_r8,2.0164e+02_r8,2.0309e+02_r8/)
      kbo(:,19,13) = (/ &
     &1.7958e+02_r8,1.8623e+02_r8,1.9196e+02_r8,1.9543e+02_r8,1.9670e+02_r8/)
      kbo(:,20,13) = (/ &
     &1.7423e+02_r8,1.8217e+02_r8,1.8721e+02_r8,1.9064e+02_r8,1.9763e+02_r8/)
      kbo(:,21,13) = (/ &
     &1.7205e+02_r8,1.7751e+02_r8,1.8259e+02_r8,1.9102e+02_r8,1.9985e+02_r8/)
      kbo(:,22,13) = (/ &
     &1.7310e+02_r8,1.7837e+02_r8,1.8681e+02_r8,1.9582e+02_r8,2.0409e+02_r8/)
      kbo(:,23,13) = (/ &
     &1.7691e+02_r8,1.8432e+02_r8,1.9387e+02_r8,2.0103e+02_r8,2.1026e+02_r8/)
      kbo(:,24,13) = (/ &
     &1.8088e+02_r8,1.8942e+02_r8,1.9891e+02_r8,2.0699e+02_r8,2.1646e+02_r8/)
      kbo(:,25,13) = (/ &
     &1.8492e+02_r8,1.9434e+02_r8,2.0408e+02_r8,2.1437e+02_r8,2.2277e+02_r8/)
      kbo(:,26,13) = (/ &
     &1.8625e+02_r8,1.9837e+02_r8,2.0945e+02_r8,2.1941e+02_r8,2.3087e+02_r8/)
      kbo(:,27,13) = (/ &
     &1.9010e+02_r8,2.0364e+02_r8,2.1615e+02_r8,2.2715e+02_r8,2.4079e+02_r8/)
      kbo(:,28,13) = (/ &
     &1.9712e+02_r8,2.1090e+02_r8,2.2463e+02_r8,2.3844e+02_r8,2.5439e+02_r8/)
      kbo(:,29,13) = (/ &
     &2.0453e+02_r8,2.1990e+02_r8,2.3570e+02_r8,2.5241e+02_r8,2.6509e+02_r8/)
      kbo(:,30,13) = (/ &
     &2.1308e+02_r8,2.3113e+02_r8,2.4908e+02_r8,2.6461e+02_r8,2.7735e+02_r8/)
      kbo(:,31,13) = (/ &
     &2.2395e+02_r8,2.4239e+02_r8,2.6296e+02_r8,2.7710e+02_r8,2.8754e+02_r8/)
      kbo(:,32,13) = (/ &
     &2.3649e+02_r8,2.5891e+02_r8,2.7696e+02_r8,2.8809e+02_r8,2.9409e+02_r8/)
      kbo(:,33,13) = (/ &
     &2.5295e+02_r8,2.7352e+02_r8,2.8553e+02_r8,2.9364e+02_r8,3.0036e+02_r8/)
      kbo(:,34,13) = (/ &
     &2.6621e+02_r8,2.8028e+02_r8,2.9209e+02_r8,2.9925e+02_r8,3.0905e+02_r8/)
      kbo(:,35,13) = (/ &
     &2.7274e+02_r8,2.8720e+02_r8,2.9678e+02_r8,3.0598e+02_r8,3.1573e+02_r8/)
      kbo(:,36,13) = (/ &
     &2.7668e+02_r8,2.9126e+02_r8,3.0131e+02_r8,3.1293e+02_r8,3.2456e+02_r8/)
      kbo(:,37,13) = (/ &
     &2.7566e+02_r8,2.9125e+02_r8,3.0241e+02_r8,3.1513e+02_r8,3.2636e+02_r8/)
      kbo(:,38,13) = (/ &
     &2.7524e+02_r8,2.9197e+02_r8,3.0411e+02_r8,3.1688e+02_r8,3.2854e+02_r8/)
      kbo(:,39,13) = (/ &
     &2.7502e+02_r8,2.9241e+02_r8,3.0488e+02_r8,3.1825e+02_r8,3.3122e+02_r8/)
      kbo(:,40,13) = (/ &
     &2.7103e+02_r8,2.8939e+02_r8,3.0276e+02_r8,3.1510e+02_r8,3.2909e+02_r8/)
      kbo(:,41,13) = (/ &
     &2.6612e+02_r8,2.8502e+02_r8,2.9924e+02_r8,3.1164e+02_r8,3.2628e+02_r8/)
      kbo(:,42,13) = (/ &
     &2.6020e+02_r8,2.7999e+02_r8,2.9554e+02_r8,3.0769e+02_r8,3.2142e+02_r8/)
      kbo(:,43,13) = (/ &
     &2.5242e+02_r8,2.7289e+02_r8,2.9079e+02_r8,3.0394e+02_r8,3.1657e+02_r8/)
      kbo(:,44,13) = (/ &
     &2.4141e+02_r8,2.6492e+02_r8,2.8389e+02_r8,2.9851e+02_r8,3.1003e+02_r8/)
      kbo(:,45,13) = (/ &
     &2.3199e+02_r8,2.5697e+02_r8,2.7534e+02_r8,2.9238e+02_r8,3.0488e+02_r8/)
      kbo(:,46,13) = (/ &
     &2.2099e+02_r8,2.4628e+02_r8,2.6862e+02_r8,2.8625e+02_r8,2.9891e+02_r8/)
      kbo(:,47,13) = (/ &
     &2.0813e+02_r8,2.3515e+02_r8,2.5936e+02_r8,2.7698e+02_r8,2.9245e+02_r8/)
      kbo(:,48,13) = (/ &
     &1.9611e+02_r8,2.2305e+02_r8,2.4767e+02_r8,2.6948e+02_r8,2.8622e+02_r8/)
      kbo(:,49,13) = (/ &
     &1.8313e+02_r8,2.1047e+02_r8,2.3654e+02_r8,2.6025e+02_r8,2.7775e+02_r8/)
      kbo(:,50,13) = (/ &
     &1.6903e+02_r8,1.9938e+02_r8,2.2519e+02_r8,2.4907e+02_r8,2.7015e+02_r8/)
      kbo(:,51,13) = (/ &
     &1.5421e+02_r8,1.8800e+02_r8,2.1428e+02_r8,2.3876e+02_r8,2.6215e+02_r8/)
      kbo(:,52,13) = (/ &
     &1.4056e+02_r8,1.7488e+02_r8,2.0358e+02_r8,2.2873e+02_r8,2.5153e+02_r8/)
      kbo(:,53,13) = (/ &
     &1.2774e+02_r8,1.6089e+02_r8,1.9159e+02_r8,2.1758e+02_r8,2.4063e+02_r8/)
      kbo(:,54,13) = (/ &
     &1.1505e+02_r8,1.4830e+02_r8,1.8148e+02_r8,2.0706e+02_r8,2.3185e+02_r8/)
      kbo(:,55,13) = (/ &
     &1.0455e+02_r8,1.3680e+02_r8,1.7009e+02_r8,1.9749e+02_r8,2.2149e+02_r8/)
      kbo(:,56,13) = (/ &
     &9.5380e+01_r8,1.2458e+02_r8,1.5763e+02_r8,1.8850e+02_r8,2.1165e+02_r8/)
      kbo(:,57,13) = (/ &
     &8.6328e+01_r8,1.1370e+02_r8,1.4580e+02_r8,1.7843e+02_r8,2.0341e+02_r8/)
      kbo(:,58,13) = (/ &
     &7.7503e+01_r8,1.0463e+02_r8,1.3405e+02_r8,1.6684e+02_r8,1.9463e+02_r8/)
      kbo(:,59,13) = (/ &
     &7.3613e+01_r8,1.0087e+02_r8,1.2946e+02_r8,1.6169e+02_r8,1.9043e+02_r8/)
      kbo(:,13,14) = (/ &
     &2.3384e+02_r8,2.3134e+02_r8,2.2678e+02_r8,2.2105e+02_r8,2.2130e+02_r8/)
      kbo(:,14,14) = (/ &
     &2.6370e+02_r8,2.6091e+02_r8,2.5467e+02_r8,2.5118e+02_r8,2.4954e+02_r8/)
      kbo(:,15,14) = (/ &
     &2.9591e+02_r8,2.9159e+02_r8,2.8464e+02_r8,2.8328e+02_r8,2.7984e+02_r8/)
      kbo(:,16,14) = (/ &
     &3.2944e+02_r8,3.2156e+02_r8,3.1816e+02_r8,3.1521e+02_r8,3.0449e+02_r8/)
      kbo(:,17,14) = (/ &
     &3.5907e+02_r8,3.5209e+02_r8,3.5084e+02_r8,3.4076e+02_r8,3.2553e+02_r8/)
      kbo(:,18,14) = (/ &
     &3.8932e+02_r8,3.8700e+02_r8,3.7610e+02_r8,3.6121e+02_r8,3.5570e+02_r8/)
      kbo(:,19,14) = (/ &
     &4.2093e+02_r8,4.0885e+02_r8,3.9722e+02_r8,3.9095e+02_r8,3.9197e+02_r8/)
      kbo(:,20,14) = (/ &
     &4.4653e+02_r8,4.3247e+02_r8,4.2391e+02_r8,4.2574e+02_r8,4.2089e+02_r8/)
      kbo(:,21,14) = (/ &
     &4.6745e+02_r8,4.5974e+02_r8,4.5782e+02_r8,4.5591e+02_r8,4.4616e+02_r8/)
      kbo(:,22,14) = (/ &
     &4.8396e+02_r8,4.8410e+02_r8,4.8532e+02_r8,4.7987e+02_r8,4.6662e+02_r8/)
      kbo(:,23,14) = (/ &
     &5.0568e+02_r8,5.0696e+02_r8,5.0168e+02_r8,4.9917e+02_r8,4.8477e+02_r8/)
      kbo(:,24,14) = (/ &
     &5.2372e+02_r8,5.2925e+02_r8,5.2568e+02_r8,5.1576e+02_r8,5.0916e+02_r8/)
      kbo(:,25,14) = (/ &
     &5.4773e+02_r8,5.4681e+02_r8,5.4261e+02_r8,5.3467e+02_r8,5.2926e+02_r8/)
      kbo(:,26,14) = (/ &
     &5.6992e+02_r8,5.6525e+02_r8,5.5986e+02_r8,5.5383e+02_r8,5.4189e+02_r8/)
      kbo(:,27,14) = (/ &
     &5.8413e+02_r8,5.7753e+02_r8,5.7399e+02_r8,5.6915e+02_r8,5.5630e+02_r8/)
      kbo(:,28,14) = (/ &
     &5.9410e+02_r8,5.9489e+02_r8,5.8870e+02_r8,5.8276e+02_r8,5.7225e+02_r8/)
      kbo(:,29,14) = (/ &
     &6.0586e+02_r8,6.0400e+02_r8,6.0319e+02_r8,5.9066e+02_r8,5.8348e+02_r8/)
      kbo(:,30,14) = (/ &
     &6.2023e+02_r8,6.2112e+02_r8,6.1269e+02_r8,6.0507e+02_r8,5.8831e+02_r8/)
      kbo(:,31,14) = (/ &
     &6.3249e+02_r8,6.3678e+02_r8,6.2186e+02_r8,6.1145e+02_r8,5.9841e+02_r8/)
      kbo(:,32,14) = (/ &
     &6.5129e+02_r8,6.4085e+02_r8,6.3065e+02_r8,6.1664e+02_r8,6.0677e+02_r8/)
      kbo(:,33,14) = (/ &
     &6.5648e+02_r8,6.4719e+02_r8,6.3483e+02_r8,6.2799e+02_r8,6.1689e+02_r8/)
      kbo(:,34,14) = (/ &
     &6.6261e+02_r8,6.5214e+02_r8,6.4542e+02_r8,6.3852e+02_r8,6.1993e+02_r8/)
      kbo(:,35,14) = (/ &
     &6.7078e+02_r8,6.6309e+02_r8,6.5953e+02_r8,6.4635e+02_r8,6.1863e+02_r8/)
      kbo(:,36,14) = (/ &
     &6.8510e+02_r8,6.7944e+02_r8,6.7467e+02_r8,6.5682e+02_r8,6.1696e+02_r8/)
      kbo(:,37,14) = (/ &
     &6.9465e+02_r8,6.8814e+02_r8,6.8342e+02_r8,6.6410e+02_r8,6.2485e+02_r8/)
      kbo(:,38,14) = (/ &
     &7.0151e+02_r8,6.9441e+02_r8,6.9017e+02_r8,6.7086e+02_r8,6.3205e+02_r8/)
      kbo(:,39,14) = (/ &
     &7.0868e+02_r8,7.0183e+02_r8,6.9685e+02_r8,6.7866e+02_r8,6.3921e+02_r8/)
      kbo(:,40,14) = (/ &
     &7.1075e+02_r8,7.0438e+02_r8,7.0305e+02_r8,6.8866e+02_r8,6.5105e+02_r8/)
      kbo(:,41,14) = (/ &
     &7.0971e+02_r8,7.0837e+02_r8,7.0822e+02_r8,6.9421e+02_r8,6.5990e+02_r8/)
      kbo(:,42,14) = (/ &
     &7.1142e+02_r8,7.1113e+02_r8,7.1018e+02_r8,6.9720e+02_r8,6.7342e+02_r8/)
      kbo(:,43,14) = (/ &
     &7.1363e+02_r8,7.1120e+02_r8,7.0210e+02_r8,7.0055e+02_r8,6.8488e+02_r8/)
      kbo(:,44,14) = (/ &
     &7.1148e+02_r8,7.0646e+02_r8,7.0565e+02_r8,7.0398e+02_r8,6.8877e+02_r8/)
      kbo(:,45,14) = (/ &
     &7.0895e+02_r8,7.0958e+02_r8,7.0605e+02_r8,6.9798e+02_r8,6.9240e+02_r8/)
      kbo(:,46,14) = (/ &
     &6.9950e+02_r8,7.0866e+02_r8,7.0226e+02_r8,6.9819e+02_r8,6.9658e+02_r8/)
      kbo(:,47,14) = (/ &
     &6.8721e+02_r8,7.0244e+02_r8,7.0188e+02_r8,6.9806e+02_r8,6.9161e+02_r8/)
      kbo(:,48,14) = (/ &
     &6.8035e+02_r8,6.9565e+02_r8,6.9976e+02_r8,6.9387e+02_r8,6.8913e+02_r8/)
      kbo(:,49,14) = (/ &
     &6.6852e+02_r8,6.8533e+02_r8,6.9809e+02_r8,6.9470e+02_r8,6.8647e+02_r8/)
      kbo(:,50,14) = (/ &
     &6.5815e+02_r8,6.7824e+02_r8,6.9156e+02_r8,6.9473e+02_r8,6.8677e+02_r8/)
      kbo(:,51,14) = (/ &
     &6.5633e+02_r8,6.6741e+02_r8,6.8334e+02_r8,6.9427e+02_r8,6.8718e+02_r8/)
      kbo(:,52,14) = (/ &
     &6.4799e+02_r8,6.6007e+02_r8,6.7742e+02_r8,6.8641e+02_r8,6.8886e+02_r8/)
      kbo(:,53,14) = (/ &
     &6.3478e+02_r8,6.5848e+02_r8,6.6595e+02_r8,6.8004e+02_r8,6.8977e+02_r8/)
      kbo(:,54,14) = (/ &
     &6.3075e+02_r8,6.5140e+02_r8,6.6048e+02_r8,6.7510e+02_r8,6.7898e+02_r8/)
      kbo(:,55,14) = (/ &
     &6.2053e+02_r8,6.3982e+02_r8,6.5909e+02_r8,6.6252e+02_r8,6.7620e+02_r8/)
      kbo(:,56,14) = (/ &
     &6.0488e+02_r8,6.3692e+02_r8,6.5472e+02_r8,6.5961e+02_r8,6.7144e+02_r8/)
      kbo(:,57,14) = (/ &
     &5.9240e+02_r8,6.2947e+02_r8,6.4320e+02_r8,6.5881e+02_r8,6.5824e+02_r8/)
      kbo(:,58,14) = (/ &
     &5.7619e+02_r8,6.1537e+02_r8,6.4199e+02_r8,6.5527e+02_r8,6.5777e+02_r8/)
      kbo(:,59,14) = (/ &
     &5.7161e+02_r8,6.1151e+02_r8,6.3977e+02_r8,6.4718e+02_r8,6.5762e+02_r8/)
      kbo(:,13,15) = (/ &
     &3.5083e+02_r8,3.4274e+02_r8,3.3588e+02_r8,3.2964e+02_r8,3.0980e+02_r8/)
      kbo(:,14,15) = (/ &
     &4.0382e+02_r8,3.9443e+02_r8,3.8616e+02_r8,3.7379e+02_r8,3.5621e+02_r8/)
      kbo(:,15,15) = (/ &
     &4.6271e+02_r8,4.5170e+02_r8,4.4204e+02_r8,4.2053e+02_r8,4.0520e+02_r8/)
      kbo(:,16,15) = (/ &
     &5.2768e+02_r8,5.1495e+02_r8,4.9504e+02_r8,4.7377e+02_r8,4.6833e+02_r8/)
      kbo(:,17,15) = (/ &
     &5.9879e+02_r8,5.8378e+02_r8,5.5161e+02_r8,5.3753e+02_r8,5.3799e+02_r8/)
      kbo(:,18,15) = (/ &
     &6.7489e+02_r8,6.3850e+02_r8,6.1688e+02_r8,6.0987e+02_r8,5.7677e+02_r8/)
      kbo(:,19,15) = (/ &
     &7.3779e+02_r8,7.0513e+02_r8,6.9510e+02_r8,6.5830e+02_r8,6.0487e+02_r8/)
      kbo(:,20,15) = (/ &
     &8.1079e+02_r8,7.9490e+02_r8,7.5998e+02_r8,6.9897e+02_r8,6.4843e+02_r8/)
      kbo(:,21,15) = (/ &
     &8.8426e+02_r8,8.6003e+02_r8,8.0304e+02_r8,7.3384e+02_r8,6.9837e+02_r8/)
      kbo(:,22,15) = (/ &
     &9.6812e+02_r8,9.1088e+02_r8,8.3391e+02_r8,7.8330e+02_r8,7.5669e+02_r8/)
      kbo(:,23,15) = (/ &
     &1.0128e+03_r8,9.4218e+02_r8,8.8720e+02_r8,8.2530e+02_r8,7.8833e+02_r8/)
      kbo(:,24,15) = (/ &
     &1.0622e+03_r8,9.7878e+02_r8,9.1791e+02_r8,8.7765e+02_r8,7.9731e+02_r8/)
      kbo(:,25,15) = (/ &
     &1.0853e+03_r8,1.0245e+03_r8,9.5328e+02_r8,8.9340e+02_r8,8.1721e+02_r8/)
      kbo(:,26,15) = (/ &
     &1.1200e+03_r8,1.0458e+03_r8,9.9235e+02_r8,9.0775e+02_r8,8.4493e+02_r8/)
      kbo(:,27,15) = (/ &
     &1.1556e+03_r8,1.0812e+03_r8,1.0090e+03_r8,9.2343e+02_r8,8.1758e+02_r8/)
      kbo(:,28,15) = (/ &
     &1.1865e+03_r8,1.1049e+03_r8,1.0073e+03_r8,9.1620e+02_r8,7.7173e+02_r8/)
      kbo(:,29,15) = (/ &
     &1.1906e+03_r8,1.1065e+03_r8,1.0028e+03_r8,8.7527e+02_r8,7.2650e+02_r8/)
      kbo(:,30,15) = (/ &
     &1.1992e+03_r8,1.0831e+03_r8,9.6830e+02_r8,8.1150e+02_r8,6.8040e+02_r8/)
      kbo(:,31,15) = (/ &
     &1.1794e+03_r8,1.0618e+03_r8,9.0601e+02_r8,7.5400e+02_r8,6.0274e+02_r8/)
      kbo(:,32,15) = (/ &
     &1.1491e+03_r8,9.9644e+02_r8,8.3044e+02_r8,6.7287e+02_r8,5.1890e+02_r8/)
      kbo(:,33,15) = (/ &
     &1.0978e+03_r8,9.1760e+02_r8,7.5228e+02_r8,5.8187e+02_r8,4.2649e+02_r8/)
      kbo(:,34,15) = (/ &
     &1.0237e+03_r8,8.4870e+02_r8,6.6311e+02_r8,4.9111e+02_r8,3.3958e+02_r8/)
      kbo(:,35,15) = (/ &
     &9.6010e+02_r8,7.7009e+02_r8,5.7949e+02_r8,4.1414e+02_r8,2.7668e+02_r8/)
      kbo(:,36,15) = (/ &
     &9.0171e+02_r8,7.0086e+02_r8,5.0886e+02_r8,3.3823e+02_r8,2.2240e+02_r8/)
      kbo(:,37,15) = (/ &
     &9.0464e+02_r8,7.0259e+02_r8,5.0334e+02_r8,3.3120e+02_r8,2.1250e+02_r8/)
      kbo(:,38,15) = (/ &
     &9.1272e+02_r8,7.0777e+02_r8,5.0236e+02_r8,3.2627e+02_r8,2.0281e+02_r8/)
      kbo(:,39,15) = (/ &
     &9.1592e+02_r8,7.0699e+02_r8,5.0029e+02_r8,3.1832e+02_r8,1.8984e+02_r8/)
      kbo(:,40,15) = (/ &
     &9.7111e+02_r8,7.5888e+02_r8,5.4218e+02_r8,3.5289e+02_r8,2.1710e+02_r8/)
      kbo(:,41,15) = (/ &
     &1.0392e+03_r8,8.1334e+02_r8,5.9329e+02_r8,4.0507e+02_r8,2.5679e+02_r8/)
      kbo(:,42,15) = (/ &
     &1.1018e+03_r8,8.7332e+02_r8,6.5360e+02_r8,4.6461e+02_r8,2.9410e+02_r8/)
      kbo(:,43,15) = (/ &
     &1.1780e+03_r8,9.5750e+02_r8,7.5295e+02_r8,5.3640e+02_r8,3.4968e+02_r8/)
      kbo(:,44,15) = (/ &
     &1.2774e+03_r8,1.0610e+03_r8,8.3382e+02_r8,6.1903e+02_r8,4.3881e+02_r8/)
      kbo(:,45,15) = (/ &
     &1.3696e+03_r8,1.1411e+03_r8,9.2825e+02_r8,7.2390e+02_r8,5.2087e+02_r8/)
      kbo(:,46,15) = (/ &
     &1.4458e+03_r8,1.2392e+03_r8,1.0284e+03_r8,8.1462e+02_r8,6.0446e+02_r8/)
      kbo(:,47,15) = (/ &
     &1.5185e+03_r8,1.3558e+03_r8,1.1323e+03_r8,9.2353e+02_r8,7.1923e+02_r8/)
      kbo(:,48,15) = (/ &
     &1.5480e+03_r8,1.4278e+03_r8,1.2433e+03_r8,1.0338e+03_r8,8.2416e+02_r8/)
      kbo(:,49,15) = (/ &
     &1.6321e+03_r8,1.4959e+03_r8,1.3391e+03_r8,1.1340e+03_r8,9.3754e+02_r8/)
      kbo(:,50,15) = (/ &
     &1.7049e+03_r8,1.5268e+03_r8,1.4037e+03_r8,1.2337e+03_r8,1.0324e+03_r8/)
      kbo(:,51,15) = (/ &
     &1.7473e+03_r8,1.6024e+03_r8,1.4662e+03_r8,1.3130e+03_r8,1.1235e+03_r8/)
      kbo(:,52,15) = (/ &
     &1.7742e+03_r8,1.6697e+03_r8,1.4942e+03_r8,1.3753e+03_r8,1.2160e+03_r8/)
      kbo(:,53,15) = (/ &
     &1.8257e+03_r8,1.7098e+03_r8,1.5772e+03_r8,1.4297e+03_r8,1.2866e+03_r8/)
      kbo(:,54,15) = (/ &
     &1.8238e+03_r8,1.7301e+03_r8,1.6290e+03_r8,1.4640e+03_r8,1.3508e+03_r8/)
      kbo(:,55,15) = (/ &
     &1.8598e+03_r8,1.7789e+03_r8,1.6666e+03_r8,1.5389e+03_r8,1.3930e+03_r8/)
      kbo(:,56,15) = (/ &
     &1.9305e+03_r8,1.7834e+03_r8,1.6800e+03_r8,1.5831e+03_r8,1.4252e+03_r8/)
      kbo(:,57,15) = (/ &
     &1.9902e+03_r8,1.8099e+03_r8,1.7296e+03_r8,1.6197e+03_r8,1.4994e+03_r8/)
      kbo(:,58,15) = (/ &
     &2.0569e+03_r8,1.8785e+03_r8,1.7252e+03_r8,1.6299e+03_r8,1.5366e+03_r8/)
      kbo(:,59,15) = (/ &
     &2.0792e+03_r8,1.9024e+03_r8,1.7290e+03_r8,1.6559e+03_r8,1.5493e+03_r8/)
      kbo(:,13,16) = (/ &
     &5.7074e+02_r8,5.5713e+02_r8,5.4253e+02_r8,5.2721e+02_r8,5.1131e+02_r8/)
      kbo(:,14,16) = (/ &
     &6.6774e+02_r8,6.5027e+02_r8,6.3161e+02_r8,6.1261e+02_r8,5.9377e+02_r8/)
      kbo(:,15,16) = (/ &
     &7.7763e+02_r8,7.5535e+02_r8,7.3247e+02_r8,7.0914e+02_r8,6.8554e+02_r8/)
      kbo(:,16,16) = (/ &
     &9.0056e+02_r8,8.7306e+02_r8,8.4456e+02_r8,8.1516e+02_r8,7.0895e+02_r8/)
      kbo(:,17,16) = (/ &
     &1.0366e+03_r8,1.0015e+03_r8,9.6519e+02_r8,8.8128e+02_r8,7.1380e+02_r8/)
      kbo(:,18,16) = (/ &
     &1.1817e+03_r8,1.1369e+03_r8,1.0597e+03_r8,8.5644e+02_r8,7.3707e+02_r8/)
      kbo(:,19,16) = (/ &
     &1.3316e+03_r8,1.2750e+03_r8,1.0321e+03_r8,8.8674e+02_r8,7.7129e+02_r8/)
      kbo(:,20,16) = (/ &
     &1.4803e+03_r8,1.2710e+03_r8,1.0855e+03_r8,9.4408e+02_r8,7.2356e+02_r8/)
      kbo(:,21,16) = (/ &
     &1.6247e+03_r8,1.3272e+03_r8,1.1530e+03_r8,9.8338e+02_r8,6.9198e+02_r8/)
      kbo(:,22,16) = (/ &
     &1.6008e+03_r8,1.3778e+03_r8,1.2081e+03_r8,9.0370e+02_r8,5.5641e+02_r8/)
      kbo(:,23,16) = (/ &
     &1.6342e+03_r8,1.4243e+03_r8,1.1304e+03_r8,8.5528e+02_r8,4.9240e+02_r8/)
      kbo(:,24,16) = (/ &
     &1.6690e+03_r8,1.4128e+03_r8,1.0773e+03_r8,6.8055e+02_r8,4.3204e+02_r8/)
      kbo(:,25,16) = (/ &
     &1.6932e+03_r8,1.3171e+03_r8,9.9569e+02_r8,5.6924e+02_r8,2.7405e+02_r8/)
      kbo(:,26,16) = (/ &
     &1.5997e+03_r8,1.2565e+03_r8,7.2147e+02_r8,4.1508e+02_r8,1.6363e+00_r8/)
      kbo(:,27,16) = (/ &
     &1.4709e+03_r8,1.0620e+03_r8,5.5367e+02_r8,1.6801e+02_r8,1.7711e+00_r8/)
      kbo(:,28,16) = (/ &
     &1.2868e+03_r8,7.4225e+02_r8,4.1091e+02_r8,1.3979e+00_r8,1.9138e+00_r8/)
      kbo(:,29,16) = (/ &
     &1.1046e+03_r8,5.7327e+02_r8,1.1435e+02_r8,1.5227e+00_r8,2.0690e+00_r8/)
      kbo(:,30,16) = (/ &
     &7.5951e+02_r8,3.1070e+02_r8,1.1800e+00_r8,1.6572e+00_r8,2.2234e+00_r8/)
      kbo(:,31,16) = (/ &
     &5.2269e+02_r8,8.9357e-01_r8,1.2993e+00_r8,1.7936e+00_r8,2.3615e+00_r8/)
      kbo(:,32,16) = (/ &
     &1.3504e+02_r8,9.8754e-01_r8,1.4263e+00_r8,1.9479e+00_r8,2.5792e+00_r8/)
      kbo(:,33,16) = (/ &
     &7.3408e-01_r8,1.0937e+00_r8,1.5601e+00_r8,2.1018e+00_r8,2.7689e+00_r8/)
      kbo(:,34,16) = (/ &
     &8.0973e-01_r8,1.1916e+00_r8,1.6719e+00_r8,2.2462e+00_r8,2.9376e+00_r8/)
      kbo(:,35,16) = (/ &
     &8.5624e-01_r8,1.2515e+00_r8,1.7457e+00_r8,2.3340e+00_r8,3.0393e+00_r8/)
      kbo(:,36,16) = (/ &
     &8.6582e-01_r8,1.2640e+00_r8,1.7620e+00_r8,2.3537e+00_r8,3.0624e+00_r8/)
      kbo(:,37,16) = (/ &
     &8.2392e-01_r8,1.2109e+00_r8,1.6970e+00_r8,2.2619e+00_r8,2.9651e+00_r8/)
      kbo(:,38,16) = (/ &
     &7.7820e-01_r8,1.1515e+00_r8,1.6284e+00_r8,2.1818e+00_r8,2.8537e+00_r8/)
      kbo(:,39,16) = (/ &
     &7.3137e-01_r8,1.0905e+00_r8,1.5568e+00_r8,2.1026e+00_r8,2.7617e+00_r8/)
      kbo(:,40,16) = (/ &
     &6.6113e-01_r8,9.9827e-01_r8,1.4324e+00_r8,1.9599e+00_r8,2.5782e+00_r8/)
      kbo(:,41,16) = (/ &
     &5.8979e-01_r8,9.0432e-01_r8,1.3165e+00_r8,1.8211e+00_r8,2.4166e+00_r8/)
      kbo(:,42,16) = (/ &
     &5.2189e-01_r8,8.1262e-01_r8,1.2033e+00_r8,1.6872e+00_r8,2.2584e+00_r8/)
      kbo(:,43,16) = (/ &
     &4.5012e-01_r8,7.1522e-01_r8,1.0693e+00_r8,1.5212e+00_r8,2.0670e+00_r8/)
      kbo(:,44,16) = (/ &
     &3.7946e-01_r8,6.1667e-01_r8,9.4312e-01_r8,1.3624e+00_r8,1.8770e+00_r8/)
      kbo(:,45,16) = (/ &
     &3.1558e-01_r8,5.2623e-01_r8,8.0787e-01_r8,1.2032e+00_r8,1.6863e+00_r8/)
      kbo(:,46,16) = (/ &
     &2.9590e+02_r8,4.4343e-01_r8,7.0619e-01_r8,1.0578e+00_r8,1.5068e+00_r8/)
      kbo(:,47,16) = (/ &
     &7.2659e+02_r8,3.5873e-01_r8,5.9101e-01_r8,9.0599e-01_r8,1.3156e+00_r8/)
      kbo(:,48,16) = (/ &
     &1.3181e+03_r8,3.4672e+02_r8,4.8767e-01_r8,7.6683e-01_r8,1.1370e+00_r8/)
      kbo(:,49,16) = (/ &
     &1.6047e+03_r8,7.6641e+02_r8,7.0071e+01_r8,6.4471e-01_r8,9.8037e-01_r8/)
      kbo(:,50,16) = (/ &
     &1.8848e+03_r8,1.3103e+03_r8,4.1613e+02_r8,5.4100e-01_r8,8.3899e-01_r8/)
      kbo(:,51,16) = (/ &
     &2.2044e+03_r8,1.5848e+03_r8,7.6808e+02_r8,1.1316e+02_r8,7.2276e-01_r8/)
      kbo(:,52,16) = (/ &
     &2.7162e+03_r8,1.8452e+03_r8,1.2957e+03_r8,4.5829e+02_r8,6.1559e-01_r8/)
      kbo(:,53,16) = (/ &
     &3.1107e+03_r8,2.1559e+03_r8,1.5529e+03_r8,8.4689e+02_r8,1.7464e+02_r8/)
      kbo(:,54,16) = (/ &
     &3.6955e+03_r8,2.6522e+03_r8,1.8196e+03_r8,1.2866e+03_r8,5.0615e+02_r8/)
      kbo(:,55,16) = (/ &
     &4.0343e+03_r8,2.9873e+03_r8,2.0751e+03_r8,1.5293e+03_r8,8.5669e+02_r8/)
      kbo(:,56,16) = (/ &
     &4.1921e+03_r8,3.4914e+03_r8,2.5653e+03_r8,1.7745e+03_r8,1.2881e+03_r8/)
      kbo(:,57,16) = (/ &
     &4.3609e+03_r8,3.8712e+03_r8,2.9041e+03_r8,2.0379e+03_r8,1.5211e+03_r8/)
      kbo(:,58,16) = (/ &
     &4.5313e+03_r8,4.0098e+03_r8,3.4243e+03_r8,2.5213e+03_r8,1.7627e+03_r8/)
      kbo(:,59,16) = (/ &
     &4.6034e+03_r8,4.0679e+03_r8,3.6299e+03_r8,2.7016e+03_r8,1.9029e+03_r8/)

!     The array KAO_Mxx contains the absorption coefficient for 
!     a minor species at the 16 chosen g-values for a reference pressure
!     level below 100~ mb.   The first index in the array, JS, runs
!     from 1 to 10, and corresponds to different gas column amount ratios,
!     as expressed through the binary species parameter eta, defined as
!     eta = gas1/(gas1 + (rat) * gas2), where rat is the 
!     ratio of the reference MLS column amount value of gas 1 
!     to that of gas2.  The second index refers to temperature 
!     in 7.2 degree increments.  For instance, JT = 1 refers to a 
!     temperature of 188.0, JT = 2 refers to 195.2, etc. The third index 
!     runs over the g-channel (1 to 16).

      kao_mn2o( 1, :, 1) = (/ &
     & 5.41078e-02_r8, 5.59051e-02_r8, 5.77620e-02_r8, 5.96805e-02_r8, 6.16628e-02_r8, &
     & 6.37110e-02_r8, 6.58272e-02_r8, 6.80137e-02_r8, 7.02728e-02_r8, 7.26069e-02_r8, &
     & 7.50185e-02_r8, 7.75103e-02_r8, 8.00848e-02_r8, 8.27449e-02_r8, 8.54933e-02_r8, &
     & 8.83330e-02_r8, 9.12670e-02_r8, 9.42984e-02_r8, 9.74306e-02_r8/)
      kao_mn2o( 2, :, 1) = (/ &
     & 1.19602e-01_r8, 1.22963e-01_r8, 1.26417e-01_r8, 1.29969e-01_r8, 1.33621e-01_r8, &
     & 1.37375e-01_r8, 1.41235e-01_r8, 1.45203e-01_r8, 1.49283e-01_r8, 1.53477e-01_r8, &
     & 1.57789e-01_r8, 1.62223e-01_r8, 1.66780e-01_r8, 1.71466e-01_r8, 1.76284e-01_r8, &
     & 1.81237e-01_r8, 1.86329e-01_r8, 1.91564e-01_r8, 1.96946e-01_r8/)
      kao_mn2o( 3, :, 1) = (/ &
     & 1.49614e-01_r8, 1.53427e-01_r8, 1.57337e-01_r8, 1.61346e-01_r8, 1.65457e-01_r8, &
     & 1.69674e-01_r8, 1.73997e-01_r8, 1.78431e-01_r8, 1.82978e-01_r8, 1.87641e-01_r8, &
     & 1.92422e-01_r8, 1.97325e-01_r8, 2.02354e-01_r8, 2.07510e-01_r8, 2.12798e-01_r8, &
     & 2.18221e-01_r8, 2.23781e-01_r8, 2.29484e-01_r8, 2.35331e-01_r8/)
      kao_mn2o( 4, :, 1) = (/ &
     & 1.80029e-01_r8, 1.84202e-01_r8, 1.88472e-01_r8, 1.92841e-01_r8, 1.97311e-01_r8, &
     & 2.01884e-01_r8, 2.06564e-01_r8, 2.11352e-01_r8, 2.16252e-01_r8, 2.21264e-01_r8, &
     & 2.26393e-01_r8, 2.31641e-01_r8, 2.37010e-01_r8, 2.42504e-01_r8, 2.48126e-01_r8, &
     & 2.53877e-01_r8, 2.59762e-01_r8, 2.65783e-01_r8, 2.71944e-01_r8/)
      kao_mn2o( 5, :, 1) = (/ &
     & 2.08279e-01_r8, 2.13029e-01_r8, 2.17888e-01_r8, 2.22858e-01_r8, 2.27941e-01_r8, &
     & 2.33140e-01_r8, 2.38458e-01_r8, 2.43897e-01_r8, 2.49460e-01_r8, 2.55150e-01_r8, &
     & 2.60969e-01_r8, 2.66922e-01_r8, 2.73010e-01_r8, 2.79237e-01_r8, 2.85606e-01_r8, &
     & 2.92120e-01_r8, 2.98783e-01_r8, 3.05598e-01_r8, 3.12568e-01_r8/)
      kao_mn2o( 6, :, 1) = (/ &
     & 2.17336e-01_r8, 2.22571e-01_r8, 2.27931e-01_r8, 2.33421e-01_r8, 2.39043e-01_r8, &
     & 2.44801e-01_r8, 2.50697e-01_r8, 2.56735e-01_r8, 2.62918e-01_r8, 2.69251e-01_r8, &
     & 2.75735e-01_r8, 2.82377e-01_r8, 2.89178e-01_r8, 2.96142e-01_r8, 3.03275e-01_r8, &
     & 3.10579e-01_r8, 3.18060e-01_r8, 3.25720e-01_r8, 3.33565e-01_r8/)
      kao_mn2o( 7, :, 1) = (/ &
     & 2.23903e-01_r8, 2.29349e-01_r8, 2.34926e-01_r8, 2.40640e-01_r8, 2.46493e-01_r8, &
     & 2.52488e-01_r8, 2.58628e-01_r8, 2.64918e-01_r8, 2.71361e-01_r8, 2.77961e-01_r8, &
     & 2.84721e-01_r8, 2.91646e-01_r8, 2.98739e-01_r8, 3.06005e-01_r8, 3.13447e-01_r8, &
     & 3.21070e-01_r8, 3.28879e-01_r8, 3.36877e-01_r8, 3.45071e-01_r8/)
      kao_mn2o( 8, :, 1) = (/ &
     & 2.23400e-01_r8, 2.28843e-01_r8, 2.34418e-01_r8, 2.40130e-01_r8, 2.45980e-01_r8, &
     & 2.51973e-01_r8, 2.58112e-01_r8, 2.64401e-01_r8, 2.70843e-01_r8, 2.77442e-01_r8, &
     & 2.84202e-01_r8, 2.91126e-01_r8, 2.98219e-01_r8, 3.05485e-01_r8, 3.12928e-01_r8, &
     & 3.20552e-01_r8, 3.28362e-01_r8, 3.36362e-01_r8, 3.44557e-01_r8/)
      kao_mn2o( 9, :, 1) = (/ &
     & 1.89279e-01_r8, 1.94423e-01_r8, 1.99707e-01_r8, 2.05135e-01_r8, 2.10710e-01_r8, &
     & 2.16437e-01_r8, 2.22319e-01_r8, 2.28361e-01_r8, 2.34568e-01_r8, 2.40943e-01_r8, &
     & 2.47492e-01_r8, 2.54218e-01_r8, 2.61127e-01_r8, 2.68224e-01_r8, 2.75514e-01_r8, &
     & 2.83002e-01_r8, 2.90694e-01_r8, 2.98594e-01_r8, 3.06709e-01_r8/)
      kao_mn2o( 1, :, 2) = (/ &
     & 9.46669e-02_r8, 9.77137e-02_r8, 1.00858e-01_r8, 1.04104e-01_r8, 1.07455e-01_r8, &
     & 1.10913e-01_r8, 1.14483e-01_r8, 1.18167e-01_r8, 1.21971e-01_r8, 1.25896e-01_r8, &
     & 1.29948e-01_r8, 1.34130e-01_r8, 1.38447e-01_r8, 1.42903e-01_r8, 1.47502e-01_r8, &
     & 1.52249e-01_r8, 1.57149e-01_r8, 1.62207e-01_r8, 1.67427e-01_r8/)
      kao_mn2o( 2, :, 2) = (/ &
     & 5.11901e-01_r8, 5.24950e-01_r8, 5.38331e-01_r8, 5.52053e-01_r8, 5.66125e-01_r8, &
     & 5.80556e-01_r8, 5.95354e-01_r8, 6.10530e-01_r8, 6.26093e-01_r8, 6.42052e-01_r8, &
     & 6.58418e-01_r8, 6.75202e-01_r8, 6.92413e-01_r8, 7.10062e-01_r8, 7.28162e-01_r8, &
     & 7.46723e-01_r8, 7.65758e-01_r8, 7.85277e-01_r8, 8.05294e-01_r8/)
      kao_mn2o( 3, :, 2) = (/ &
     & 8.32946e-01_r8, 8.45780e-01_r8, 8.58813e-01_r8, 8.72046e-01_r8, 8.85482e-01_r8, &
     & 8.99126e-01_r8, 9.12980e-01_r8, 9.27048e-01_r8, 9.41332e-01_r8, 9.55837e-01_r8, &
     & 9.70565e-01_r8, 9.85520e-01_r8, 1.00070e+00_r8, 1.01612e+00_r8, 1.03178e+00_r8, &
     & 1.04768e+00_r8, 1.06382e+00_r8, 1.08021e+00_r8, 1.09686e+00_r8/)
      kao_mn2o( 4, :, 2) = (/ &
     & 1.04032e+00_r8, 1.05475e+00_r8, 1.06937e+00_r8, 1.08419e+00_r8, 1.09922e+00_r8, &
     & 1.11446e+00_r8, 1.12991e+00_r8, 1.14557e+00_r8, 1.16145e+00_r8, 1.17755e+00_r8, &
     & 1.19387e+00_r8, 1.21042e+00_r8, 1.22720e+00_r8, 1.24421e+00_r8, 1.26146e+00_r8, &
     & 1.27895e+00_r8, 1.29668e+00_r8, 1.31465e+00_r8, 1.33287e+00_r8/)
      kao_mn2o( 5, :, 2) = (/ &
     & 1.22685e+00_r8, 1.24267e+00_r8, 1.25870e+00_r8, 1.27493e+00_r8, 1.29137e+00_r8, &
     & 1.30803e+00_r8, 1.32490e+00_r8, 1.34199e+00_r8, 1.35930e+00_r8, 1.37683e+00_r8, &
     & 1.39459e+00_r8, 1.41257e+00_r8, 1.43079e+00_r8, 1.44925e+00_r8, 1.46794e+00_r8, &
     & 1.48687e+00_r8, 1.50605e+00_r8, 1.52547e+00_r8, 1.54515e+00_r8/)
      kao_mn2o( 6, :, 2) = (/ &
     & 1.53781e+00_r8, 1.55206e+00_r8, 1.56645e+00_r8, 1.58097e+00_r8, 1.59563e+00_r8, &
     & 1.61042e+00_r8, 1.62535e+00_r8, 1.64042e+00_r8, 1.65562e+00_r8, 1.67097e+00_r8, &
     & 1.68646e+00_r8, 1.70210e+00_r8, 1.71788e+00_r8, 1.73380e+00_r8, 1.74987e+00_r8, &
     & 1.76610e+00_r8, 1.78247e+00_r8, 1.79899e+00_r8, 1.81567e+00_r8/)
      kao_mn2o( 7, :, 2) = (/ &
     & 1.90476e+00_r8, 1.91858e+00_r8, 1.93251e+00_r8, 1.94653e+00_r8, 1.96065e+00_r8, &
     & 1.97488e+00_r8, 1.98921e+00_r8, 2.00365e+00_r8, 2.01819e+00_r8, 2.03283e+00_r8, &
     & 2.04758e+00_r8, 2.06244e+00_r8, 2.07741e+00_r8, 2.09248e+00_r8, 2.10767e+00_r8, &
     & 2.12296e+00_r8, 2.13837e+00_r8, 2.15388e+00_r8, 2.16951e+00_r8/)
      kao_mn2o( 8, :, 2) = (/ &
     & 2.38211e+00_r8, 2.39819e+00_r8, 2.41438e+00_r8, 2.43068e+00_r8, 2.44709e+00_r8, &
     & 2.46361e+00_r8, 2.48024e+00_r8, 2.49699e+00_r8, 2.51384e+00_r8, 2.53082e+00_r8, &
     & 2.54790e+00_r8, 2.56510e+00_r8, 2.58242e+00_r8, 2.59985e+00_r8, 2.61741e+00_r8, &
     & 2.63508e+00_r8, 2.65287e+00_r8, 2.67078e+00_r8, 2.68881e+00_r8/)
      kao_mn2o( 9, :, 2) = (/ &
     & 1.26464e+00_r8, 1.28107e+00_r8, 1.29772e+00_r8, 1.31458e+00_r8, 1.33166e+00_r8, &
     & 1.34896e+00_r8, 1.36649e+00_r8, 1.38424e+00_r8, 1.40223e+00_r8, 1.42044e+00_r8, &
     & 1.43890e+00_r8, 1.45759e+00_r8, 1.47653e+00_r8, 1.49572e+00_r8, 1.51515e+00_r8, &
     & 1.53483e+00_r8, 1.55478e+00_r8, 1.57498e+00_r8, 1.59544e+00_r8/)
      kao_mn2o( 1, :, 3) = (/ &
     & 1.50082e-01_r8, 1.59095e-01_r8, 1.68650e-01_r8, 1.78779e-01_r8, 1.89516e-01_r8, &
     & 2.00898e-01_r8, 2.12963e-01_r8, 2.25753e-01_r8, 2.39311e-01_r8, 2.53683e-01_r8, &
     & 2.68919e-01_r8, 2.85069e-01_r8, 3.02190e-01_r8, 3.20339e-01_r8, 3.39577e-01_r8, &
     & 3.59971e-01_r8, 3.81590e-01_r8, 4.04507e-01_r8, 4.28801e-01_r8/)
      kao_mn2o( 2, :, 3) = (/ &
     & 3.09551e+00_r8, 3.09780e+00_r8, 3.10008e+00_r8, 3.10237e+00_r8, 3.10466e+00_r8, &
     & 3.10695e+00_r8, 3.10925e+00_r8, 3.11154e+00_r8, 3.11384e+00_r8, 3.11614e+00_r8, &
     & 3.11844e+00_r8, 3.12074e+00_r8, 3.12305e+00_r8, 3.12535e+00_r8, 3.12766e+00_r8, &
     & 3.12997e+00_r8, 3.13228e+00_r8, 3.13459e+00_r8, 3.13691e+00_r8/)
      kao_mn2o( 3, :, 3) = (/ &
     & 4.42661e+00_r8, 4.40858e+00_r8, 4.39062e+00_r8, 4.37274e+00_r8, 4.35493e+00_r8, &
     & 4.33719e+00_r8, 4.31953e+00_r8, 4.30193e+00_r8, 4.28441e+00_r8, 4.26696e+00_r8, &
     & 4.24958e+00_r8, 4.23227e+00_r8, 4.21503e+00_r8, 4.19787e+00_r8, 4.18077e+00_r8, &
     & 4.16374e+00_r8, 4.14678e+00_r8, 4.12989e+00_r8, 4.11307e+00_r8/)
      kao_mn2o( 4, :, 3) = (/ &
     & 5.77864e+00_r8, 5.74085e+00_r8, 5.70331e+00_r8, 5.66602e+00_r8, 5.62897e+00_r8, &
     & 5.59216e+00_r8, 5.55559e+00_r8, 5.51926e+00_r8, 5.48317e+00_r8, 5.44731e+00_r8, &
     & 5.41169e+00_r8, 5.37631e+00_r8, 5.34115e+00_r8, 5.30622e+00_r8, 5.27152e+00_r8, &
     & 5.23705e+00_r8, 5.20281e+00_r8, 5.16879e+00_r8, 5.13499e+00_r8/)
      kao_mn2o( 5, :, 3) = (/ &
     & 7.17294e+00_r8, 7.10890e+00_r8, 7.04542e+00_r8, 6.98251e+00_r8, 6.92017e+00_r8, &
     & 6.85838e+00_r8, 6.79714e+00_r8, 6.73645e+00_r8, 6.67630e+00_r8, 6.61669e+00_r8, &
     & 6.55761e+00_r8, 6.49905e+00_r8, 6.44102e+00_r8, 6.38351e+00_r8, 6.32651e+00_r8, &
     & 6.27003e+00_r8, 6.21404e+00_r8, 6.15856e+00_r8, 6.10357e+00_r8/)
      kao_mn2o( 6, :, 3) = (/ &
     & 9.05082e+00_r8, 8.96132e+00_r8, 8.87271e+00_r8, 8.78498e+00_r8, 8.69811e+00_r8, &
     & 8.61210e+00_r8, 8.52694e+00_r8, 8.44262e+00_r8, 8.35914e+00_r8, 8.27648e+00_r8, &
     & 8.19464e+00_r8, 8.11361e+00_r8, 8.03338e+00_r8, 7.95394e+00_r8, 7.87529e+00_r8, &
     & 7.79742e+00_r8, 7.72032e+00_r8, 7.64398e+00_r8, 7.56839e+00_r8/)
      kao_mn2o( 7, :, 3) = (/ &
     & 1.18749e+01_r8, 1.17648e+01_r8, 1.16556e+01_r8, 1.15475e+01_r8, 1.14403e+01_r8, &
     & 1.13342e+01_r8, 1.12290e+01_r8, 1.11248e+01_r8, 1.10216e+01_r8, 1.09194e+01_r8, &
     & 1.08180e+01_r8, 1.07177e+01_r8, 1.06182e+01_r8, 1.05197e+01_r8, 1.04221e+01_r8, &
     & 1.03254e+01_r8, 1.02296e+01_r8, 1.01347e+01_r8, 1.00407e+01_r8/)
      kao_mn2o( 8, :, 3) = (/ &
     & 1.41428e+01_r8, 1.40323e+01_r8, 1.39227e+01_r8, 1.38139e+01_r8, 1.37060e+01_r8, &
     & 1.35989e+01_r8, 1.34927e+01_r8, 1.33873e+01_r8, 1.32827e+01_r8, 1.31790e+01_r8, &
     & 1.30760e+01_r8, 1.29738e+01_r8, 1.28725e+01_r8, 1.27719e+01_r8, 1.26722e+01_r8, &
     & 1.25732e+01_r8, 1.24750e+01_r8, 1.23775e+01_r8, 1.22808e+01_r8/)
      kao_mn2o( 9, :, 3) = (/ &
     & 7.34993e+00_r8, 7.29335e+00_r8, 7.23720e+00_r8, 7.18149e+00_r8, 7.12620e+00_r8, &
     & 7.07134e+00_r8, 7.01690e+00_r8, 6.96288e+00_r8, 6.90928e+00_r8, 6.85609e+00_r8, &
     & 6.80331e+00_r8, 6.75094e+00_r8, 6.69897e+00_r8, 6.64739e+00_r8, 6.59622e+00_r8, &
     & 6.54544e+00_r8, 6.49505e+00_r8, 6.44505e+00_r8, 6.39543e+00_r8/)
      kao_mn2o( 1, :, 4) = (/ &
     & 6.11248e-01_r8, 6.37225e-01_r8, 6.64306e-01_r8, 6.92538e-01_r8, 7.21970e-01_r8, &
     & 7.52653e-01_r8, 7.84639e-01_r8, 8.17985e-01_r8, 8.52749e-01_r8, 8.88989e-01_r8, &
     & 9.26770e-01_r8, 9.66157e-01_r8, 1.00722e+00_r8, 1.05002e+00_r8, 1.09465e+00_r8, &
     & 1.14117e+00_r8, 1.18967e+00_r8, 1.24022e+00_r8, 1.29293e+00_r8/)
      kao_mn2o( 2, :, 4) = (/ &
     & 5.07253e+00_r8, 5.05299e+00_r8, 5.03353e+00_r8, 5.01414e+00_r8, 4.99483e+00_r8, &
     & 4.97559e+00_r8, 4.95642e+00_r8, 4.93733e+00_r8, 4.91831e+00_r8, 4.89937e+00_r8, &
     & 4.88050e+00_r8, 4.86170e+00_r8, 4.84297e+00_r8, 4.82432e+00_r8, 4.80573e+00_r8, &
     & 4.78722e+00_r8, 4.76878e+00_r8, 4.75042e+00_r8, 4.73212e+00_r8/)
      kao_mn2o( 3, :, 4) = (/ &
     & 7.45829e+00_r8, 7.42266e+00_r8, 7.38719e+00_r8, 7.35190e+00_r8, 7.31677e+00_r8, &
     & 7.28181e+00_r8, 7.24702e+00_r8, 7.21240e+00_r8, 7.17794e+00_r8, 7.14364e+00_r8, &
     & 7.10951e+00_r8, 7.07554e+00_r8, 7.04173e+00_r8, 7.00809e+00_r8, 6.97461e+00_r8, &
     & 6.94128e+00_r8, 6.90812e+00_r8, 6.87511e+00_r8, 6.84226e+00_r8/)
      kao_mn2o( 4, :, 4) = (/ &
     & 9.58893e+00_r8, 9.54796e+00_r8, 9.50716e+00_r8, 9.46654e+00_r8, 9.42609e+00_r8, &
     & 9.38581e+00_r8, 9.34571e+00_r8, 9.30578e+00_r8, 9.26602e+00_r8, 9.22642e+00_r8, &
     & 9.18700e+00_r8, 9.14775e+00_r8, 9.10866e+00_r8, 9.06974e+00_r8, 9.03099e+00_r8, &
     & 8.99240e+00_r8, 8.95398e+00_r8, 8.91572e+00_r8, 8.87762e+00_r8/)
      kao_mn2o( 5, :, 4) = (/ &
     & 1.16344e+01_r8, 1.16012e+01_r8, 1.15681e+01_r8, 1.15351e+01_r8, 1.15022e+01_r8, &
     & 1.14694e+01_r8, 1.14366e+01_r8, 1.14040e+01_r8, 1.13715e+01_r8, 1.13390e+01_r8, &
     & 1.13067e+01_r8, 1.12744e+01_r8, 1.12422e+01_r8, 1.12102e+01_r8, 1.11782e+01_r8, &
     & 1.11463e+01_r8, 1.11145e+01_r8, 1.10828e+01_r8, 1.10511e+01_r8/)
      kao_mn2o( 6, :, 4) = (/ &
     & 1.12460e+01_r8, 1.12402e+01_r8, 1.12344e+01_r8, 1.12286e+01_r8, 1.12228e+01_r8, &
     & 1.12170e+01_r8, 1.12112e+01_r8, 1.12055e+01_r8, 1.11997e+01_r8, 1.11939e+01_r8, &
     & 1.11882e+01_r8, 1.11824e+01_r8, 1.11766e+01_r8, 1.11709e+01_r8, 1.11651e+01_r8, &
     & 1.11594e+01_r8, 1.11536e+01_r8, 1.11479e+01_r8, 1.11421e+01_r8/)
      kao_mn2o( 7, :, 4) = (/ &
     & 8.89265e+00_r8, 8.91419e+00_r8, 8.93578e+00_r8, 8.95743e+00_r8, 8.97913e+00_r8, &
     & 9.00088e+00_r8, 9.02268e+00_r8, 9.04454e+00_r8, 9.06645e+00_r8, 9.08841e+00_r8, &
     & 9.11043e+00_r8, 9.13250e+00_r8, 9.15462e+00_r8, 9.17680e+00_r8, 9.19903e+00_r8, &
     & 9.22131e+00_r8, 9.24365e+00_r8, 9.26604e+00_r8, 9.28849e+00_r8/)
      kao_mn2o( 8, :, 4) = (/ &
     & 6.83933e+00_r8, 6.86688e+00_r8, 6.89453e+00_r8, 6.92230e+00_r8, 6.95018e+00_r8, &
     & 6.97817e+00_r8, 7.00627e+00_r8, 7.03449e+00_r8, 7.06282e+00_r8, 7.09126e+00_r8, &
     & 7.11982e+00_r8, 7.14850e+00_r8, 7.17729e+00_r8, 7.20619e+00_r8, 7.23521e+00_r8, &
     & 7.26435e+00_r8, 7.29361e+00_r8, 7.32298e+00_r8, 7.35248e+00_r8/)
      kao_mn2o( 9, :, 4) = (/ &
     & 1.10637e+01_r8, 1.10232e+01_r8, 1.09829e+01_r8, 1.09427e+01_r8, 1.09026e+01_r8, &
     & 1.08627e+01_r8, 1.08230e+01_r8, 1.07833e+01_r8, 1.07439e+01_r8, 1.07046e+01_r8, &
     & 1.06654e+01_r8, 1.06263e+01_r8, 1.05875e+01_r8, 1.05487e+01_r8, 1.05101e+01_r8, &
     & 1.04716e+01_r8, 1.04333e+01_r8, 1.03951e+01_r8, 1.03571e+01_r8/)
      kao_mn2o( 1, :, 5) = (/ &
     & 2.53460e+00_r8, 2.56050e+00_r8, 2.58667e+00_r8, 2.61310e+00_r8, 2.63980e+00_r8, &
     & 2.66678e+00_r8, 2.69403e+00_r8, 2.72156e+00_r8, 2.74937e+00_r8, 2.77746e+00_r8, &
     & 2.80585e+00_r8, 2.83452e+00_r8, 2.86348e+00_r8, 2.89275e+00_r8, 2.92231e+00_r8, &
     & 2.95217e+00_r8, 2.98234e+00_r8, 3.01281e+00_r8, 3.04360e+00_r8/)
      kao_mn2o( 2, :, 5) = (/ &
     & 7.45650e+00_r8, 7.44283e+00_r8, 7.42919e+00_r8, 7.41557e+00_r8, 7.40198e+00_r8, &
     & 7.38841e+00_r8, 7.37487e+00_r8, 7.36135e+00_r8, 7.34786e+00_r8, 7.33439e+00_r8, &
     & 7.32095e+00_r8, 7.30753e+00_r8, 7.29413e+00_r8, 7.28076e+00_r8, 7.26742e+00_r8, &
     & 7.25410e+00_r8, 7.24080e+00_r8, 7.22753e+00_r8, 7.21428e+00_r8/)
      kao_mn2o( 3, :, 5) = (/ &
     & 1.06311e+01_r8, 1.06110e+01_r8, 1.05909e+01_r8, 1.05709e+01_r8, 1.05509e+01_r8, &
     & 1.05310e+01_r8, 1.05111e+01_r8, 1.04912e+01_r8, 1.04713e+01_r8, 1.04516e+01_r8, &
     & 1.04318e+01_r8, 1.04121e+01_r8, 1.03924e+01_r8, 1.03727e+01_r8, 1.03531e+01_r8, &
     & 1.03336e+01_r8, 1.03140e+01_r8, 1.02945e+01_r8, 1.02751e+01_r8/)
      kao_mn2o( 4, :, 5) = (/ &
     & 1.03924e+01_r8, 1.03895e+01_r8, 1.03867e+01_r8, 1.03838e+01_r8, 1.03809e+01_r8, &
     & 1.03780e+01_r8, 1.03751e+01_r8, 1.03722e+01_r8, 1.03693e+01_r8, 1.03665e+01_r8, &
     & 1.03636e+01_r8, 1.03607e+01_r8, 1.03578e+01_r8, 1.03549e+01_r8, 1.03521e+01_r8, &
     & 1.03492e+01_r8, 1.03463e+01_r8, 1.03434e+01_r8, 1.03406e+01_r8/)
      kao_mn2o( 5, :, 5) = (/ &
     & 7.82277e+00_r8, 7.83872e+00_r8, 7.85471e+00_r8, 7.87073e+00_r8, 7.88678e+00_r8, &
     & 7.90287e+00_r8, 7.91899e+00_r8, 7.93514e+00_r8, 7.95132e+00_r8, 7.96754e+00_r8, &
     & 7.98379e+00_r8, 8.00008e+00_r8, 8.01639e+00_r8, 8.03274e+00_r8, 8.04913e+00_r8, &
     & 8.06555e+00_r8, 8.08200e+00_r8, 8.09848e+00_r8, 8.11500e+00_r8/)
      kao_mn2o( 6, :, 5) = (/ &
     & 6.05225e+00_r8, 6.06883e+00_r8, 6.08545e+00_r8, 6.10212e+00_r8, 6.11883e+00_r8, &
     & 6.13559e+00_r8, 6.15240e+00_r8, 6.16925e+00_r8, 6.18615e+00_r8, 6.20309e+00_r8, &
     & 6.22008e+00_r8, 6.23712e+00_r8, 6.25420e+00_r8, 6.27133e+00_r8, 6.28851e+00_r8, &
     & 6.30574e+00_r8, 6.32301e+00_r8, 6.34033e+00_r8, 6.35769e+00_r8/)
      kao_mn2o( 7, :, 5) = (/ &
     & 5.24135e+00_r8, 5.25696e+00_r8, 5.27261e+00_r8, 5.28831e+00_r8, 5.30405e+00_r8, &
     & 5.31984e+00_r8, 5.33568e+00_r8, 5.35157e+00_r8, 5.36750e+00_r8, 5.38348e+00_r8, &
     & 5.39951e+00_r8, 5.41558e+00_r8, 5.43171e+00_r8, 5.44788e+00_r8, 5.46410e+00_r8, &
     & 5.48037e+00_r8, 5.49668e+00_r8, 5.51305e+00_r8, 5.52946e+00_r8/)
      kao_mn2o( 8, :, 5) = (/ &
     & 4.40240e+00_r8, 4.40915e+00_r8, 4.41591e+00_r8, 4.42268e+00_r8, 4.42946e+00_r8, &
     & 4.43625e+00_r8, 4.44305e+00_r8, 4.44986e+00_r8, 4.45668e+00_r8, 4.46351e+00_r8, &
     & 4.47035e+00_r8, 4.47720e+00_r8, 4.48407e+00_r8, 4.49094e+00_r8, 4.49782e+00_r8, &
     & 4.50472e+00_r8, 4.51162e+00_r8, 4.51854e+00_r8, 4.52547e+00_r8/)
      kao_mn2o( 9, :, 5) = (/ &
     & 8.56554e+00_r8, 8.59185e+00_r8, 8.61824e+00_r8, 8.64470e+00_r8, 8.67125e+00_r8, &
     & 8.69788e+00_r8, 8.72460e+00_r8, 8.75139e+00_r8, 8.77827e+00_r8, 8.80523e+00_r8, &
     & 8.83227e+00_r8, 8.85939e+00_r8, 8.88660e+00_r8, 8.91389e+00_r8, 8.94127e+00_r8, &
     & 8.96873e+00_r8, 8.99627e+00_r8, 9.02390e+00_r8, 9.05161e+00_r8/)
      kao_mn2o( 1, :, 6) = (/ &
     & 5.78695e+00_r8, 5.78939e+00_r8, 5.79182e+00_r8, 5.79426e+00_r8, 5.79670e+00_r8, &
     & 5.79914e+00_r8, 5.80158e+00_r8, 5.80403e+00_r8, 5.80647e+00_r8, 5.80892e+00_r8, &
     & 5.81136e+00_r8, 5.81381e+00_r8, 5.81626e+00_r8, 5.81870e+00_r8, 5.82115e+00_r8, &
     & 5.82361e+00_r8, 5.82606e+00_r8, 5.82851e+00_r8, 5.83096e+00_r8/)
      kao_mn2o( 2, :, 6) = (/ &
     & 1.22893e+01_r8, 1.22556e+01_r8, 1.22221e+01_r8, 1.21886e+01_r8, 1.21552e+01_r8, &
     & 1.21220e+01_r8, 1.20888e+01_r8, 1.20557e+01_r8, 1.20227e+01_r8, 1.19898e+01_r8, &
     & 1.19569e+01_r8, 1.19242e+01_r8, 1.18915e+01_r8, 1.18590e+01_r8, 1.18265e+01_r8, &
     & 1.17941e+01_r8, 1.17618e+01_r8, 1.17296e+01_r8, 1.16975e+01_r8/)
      kao_mn2o( 3, :, 6) = (/ &
     & 7.93118e+00_r8, 7.94590e+00_r8, 7.96065e+00_r8, 7.97542e+00_r8, 7.99022e+00_r8, &
     & 8.00505e+00_r8, 8.01990e+00_r8, 8.03478e+00_r8, 8.04970e+00_r8, 8.06463e+00_r8, &
     & 8.07960e+00_r8, 8.09459e+00_r8, 8.10961e+00_r8, 8.12466e+00_r8, 8.13974e+00_r8, &
     & 8.15485e+00_r8, 8.16998e+00_r8, 8.18514e+00_r8, 8.20033e+00_r8/)
      kao_mn2o( 4, :, 6) = (/ &
     & 4.08899e+00_r8, 4.11435e+00_r8, 4.13988e+00_r8, 4.16556e+00_r8, 4.19140e+00_r8, &
     & 4.21740e+00_r8, 4.24357e+00_r8, 4.26989e+00_r8, 4.29638e+00_r8, 4.32304e+00_r8, &
     & 4.34985e+00_r8, 4.37684e+00_r8, 4.40399e+00_r8, 4.43131e+00_r8, 4.45880e+00_r8, &
     & 4.48646e+00_r8, 4.51430e+00_r8, 4.54230e+00_r8, 4.57048e+00_r8/)
      kao_mn2o( 5, :, 6) = (/ &
     & 2.61358e+00_r8, 2.64029e+00_r8, 2.66728e+00_r8, 2.69454e+00_r8, 2.72209e+00_r8, &
     & 2.74991e+00_r8, 2.77802e+00_r8, 2.80641e+00_r8, 2.83510e+00_r8, 2.86408e+00_r8, &
     & 2.89335e+00_r8, 2.92293e+00_r8, 2.95280e+00_r8, 2.98299e+00_r8, 3.01348e+00_r8, &
     & 3.04428e+00_r8, 3.07540e+00_r8, 3.10683e+00_r8, 3.13859e+00_r8/)
      kao_mn2o( 6, :, 6) = (/ &
     & 2.40720e+00_r8, 2.43430e+00_r8, 2.46169e+00_r8, 2.48940e+00_r8, 2.51741e+00_r8, &
     & 2.54575e+00_r8, 2.57440e+00_r8, 2.60337e+00_r8, 2.63267e+00_r8, 2.66230e+00_r8, &
     & 2.69226e+00_r8, 2.72256e+00_r8, 2.75320e+00_r8, 2.78419e+00_r8, 2.81552e+00_r8, &
     & 2.84721e+00_r8, 2.87925e+00_r8, 2.91166e+00_r8, 2.94443e+00_r8/)
      kao_mn2o( 7, :, 6) = (/ &
     & 1.99607e+00_r8, 2.01725e+00_r8, 2.03865e+00_r8, 2.06028e+00_r8, 2.08214e+00_r8, &
     & 2.10423e+00_r8, 2.12655e+00_r8, 2.14912e+00_r8, 2.17192e+00_r8, 2.19496e+00_r8, &
     & 2.21825e+00_r8, 2.24179e+00_r8, 2.26557e+00_r8, 2.28961e+00_r8, 2.31390e+00_r8, &
     & 2.33845e+00_r8, 2.36326e+00_r8, 2.38834e+00_r8, 2.41368e+00_r8/)
      kao_mn2o( 8, :, 6) = (/ &
     & 1.94150e+00_r8, 1.96398e+00_r8, 1.98671e+00_r8, 2.00971e+00_r8, 2.03298e+00_r8, &
     & 2.05651e+00_r8, 2.08032e+00_r8, 2.10440e+00_r8, 2.12876e+00_r8, 2.15341e+00_r8, &
     & 2.17834e+00_r8, 2.20355e+00_r8, 2.22906e+00_r8, 2.25487e+00_r8, 2.28097e+00_r8, &
     & 2.30738e+00_r8, 2.33409e+00_r8, 2.36111e+00_r8, 2.38844e+00_r8/)
      kao_mn2o( 9, :, 6) = (/ &
     & 2.47259e+00_r8, 2.48950e+00_r8, 2.50653e+00_r8, 2.52367e+00_r8, 2.54093e+00_r8, &
     & 2.55831e+00_r8, 2.57581e+00_r8, 2.59343e+00_r8, 2.61117e+00_r8, 2.62903e+00_r8, &
     & 2.64701e+00_r8, 2.66511e+00_r8, 2.68334e+00_r8, 2.70169e+00_r8, 2.72017e+00_r8, &
     & 2.73878e+00_r8, 2.75751e+00_r8, 2.77637e+00_r8, 2.79536e+00_r8/)
      kao_mn2o( 1, :, 7) = (/ &
     & 1.23417e+01_r8, 1.22618e+01_r8, 1.21823e+01_r8, 1.21034e+01_r8, 1.20250e+01_r8, &
     & 1.19471e+01_r8, 1.18697e+01_r8, 1.17928e+01_r8, 1.17164e+01_r8, 1.16405e+01_r8, &
     & 1.15651e+01_r8, 1.14901e+01_r8, 1.14157e+01_r8, 1.13417e+01_r8, 1.12683e+01_r8, &
     & 1.11952e+01_r8, 1.11227e+01_r8, 1.10507e+01_r8, 1.09791e+01_r8/)
      kao_mn2o( 2, :, 7) = (/ &
     & 9.30957e+00_r8, 9.32775e+00_r8, 9.34597e+00_r8, 9.36421e+00_r8, 9.38250e+00_r8, &
     & 9.40082e+00_r8, 9.41918e+00_r8, 9.43757e+00_r8, 9.45600e+00_r8, 9.47446e+00_r8, &
     & 9.49296e+00_r8, 9.51150e+00_r8, 9.53007e+00_r8, 9.54868e+00_r8, 9.56732e+00_r8, &
     & 9.58601e+00_r8, 9.60472e+00_r8, 9.62348e+00_r8, 9.64227e+00_r8/)
      kao_mn2o( 3, :, 7) = (/ &
     & 4.15867e+00_r8, 4.19254e+00_r8, 4.22668e+00_r8, 4.26110e+00_r8, 4.29581e+00_r8, &
     & 4.33079e+00_r8, 4.36606e+00_r8, 4.40162e+00_r8, 4.43747e+00_r8, 4.47360e+00_r8, &
     & 4.51004e+00_r8, 4.54677e+00_r8, 4.58380e+00_r8, 4.62113e+00_r8, 4.65876e+00_r8, &
     & 4.69670e+00_r8, 4.73495e+00_r8, 4.77351e+00_r8, 4.81239e+00_r8/)
      kao_mn2o( 4, :, 7) = (/ &
     & 3.55634e+00_r8, 3.59382e+00_r8, 3.63169e+00_r8, 3.66996e+00_r8, 3.70863e+00_r8, &
     & 3.74771e+00_r8, 3.78720e+00_r8, 3.82711e+00_r8, 3.86744e+00_r8, 3.90820e+00_r8, &
     & 3.94938e+00_r8, 3.99100e+00_r8, 4.03305e+00_r8, 4.07555e+00_r8, 4.11850e+00_r8, &
     & 4.16190e+00_r8, 4.20576e+00_r8, 4.25008e+00_r8, 4.29486e+00_r8/)
      kao_mn2o( 5, :, 7) = (/ &
     & 3.09468e+00_r8, 3.12655e+00_r8, 3.15876e+00_r8, 3.19129e+00_r8, 3.22416e+00_r8, &
     & 3.25737e+00_r8, 3.29092e+00_r8, 3.32482e+00_r8, 3.35907e+00_r8, 3.39366e+00_r8, &
     & 3.42862e+00_r8, 3.46393e+00_r8, 3.49961e+00_r8, 3.53566e+00_r8, 3.57208e+00_r8, &
     & 3.60887e+00_r8, 3.64604e+00_r8, 3.68360e+00_r8, 3.72154e+00_r8/)
      kao_mn2o( 6, :, 7) = (/ &
     & 2.75473e+00_r8, 2.78356e+00_r8, 2.81268e+00_r8, 2.84211e+00_r8, 2.87185e+00_r8, &
     & 2.90190e+00_r8, 2.93227e+00_r8, 2.96295e+00_r8, 2.99395e+00_r8, 3.02528e+00_r8, &
     & 3.05694e+00_r8, 3.08892e+00_r8, 3.12125e+00_r8, 3.15391e+00_r8, 3.18691e+00_r8, &
     & 3.22025e+00_r8, 3.25395e+00_r8, 3.28800e+00_r8, 3.32240e+00_r8/)
      kao_mn2o( 7, :, 7) = (/ &
     & 2.68587e+00_r8, 2.71431e+00_r8, 2.74306e+00_r8, 2.77211e+00_r8, 2.80146e+00_r8, &
     & 2.83113e+00_r8, 2.86111e+00_r8, 2.89141e+00_r8, 2.92203e+00_r8, 2.95298e+00_r8, &
     & 2.98425e+00_r8, 3.01585e+00_r8, 3.04779e+00_r8, 3.08006e+00_r8, 3.11268e+00_r8, &
     & 3.14564e+00_r8, 3.17896e+00_r8, 3.21262e+00_r8, 3.24664e+00_r8/)
      kao_mn2o( 8, :, 7) = (/ &
     & 2.54778e+00_r8, 2.57461e+00_r8, 2.60173e+00_r8, 2.62914e+00_r8, 2.65683e+00_r8, &
     & 2.68482e+00_r8, 2.71310e+00_r8, 2.74168e+00_r8, 2.77056e+00_r8, 2.79974e+00_r8, &
     & 2.82923e+00_r8, 2.85903e+00_r8, 2.88915e+00_r8, 2.91958e+00_r8, 2.95033e+00_r8, &
     & 2.98141e+00_r8, 3.01282e+00_r8, 3.04455e+00_r8, 3.07662e+00_r8/)
      kao_mn2o( 9, :, 7) = (/ &
     & 2.78137e+00_r8, 2.80957e+00_r8, 2.83805e+00_r8, 2.86682e+00_r8, 2.89589e+00_r8, &
     & 2.92525e+00_r8, 2.95491e+00_r8, 2.98486e+00_r8, 3.01512e+00_r8, 3.04569e+00_r8, &
     & 3.07657e+00_r8, 3.10776e+00_r8, 3.13927e+00_r8, 3.17110e+00_r8, 3.20324e+00_r8, &
     & 3.23572e+00_r8, 3.26852e+00_r8, 3.30166e+00_r8, 3.33513e+00_r8/)
      kao_mn2o( 1, :, 8) = (/ &
     & 2.28384e+01_r8, 2.27450e+01_r8, 2.26519e+01_r8, 2.25593e+01_r8, 2.24670e+01_r8, &
     & 2.23751e+01_r8, 2.22835e+01_r8, 2.21924e+01_r8, 2.21016e+01_r8, 2.20112e+01_r8, &
     & 2.19211e+01_r8, 2.18314e+01_r8, 2.17421e+01_r8, 2.16532e+01_r8, 2.15646e+01_r8, &
     & 2.14764e+01_r8, 2.13885e+01_r8, 2.13010e+01_r8, 2.12139e+01_r8/)
      kao_mn2o( 2, :, 8) = (/ &
     & 4.48608e+00_r8, 4.52259e+00_r8, 4.55939e+00_r8, 4.59649e+00_r8, 4.63389e+00_r8, &
     & 4.67160e+00_r8, 4.70961e+00_r8, 4.74793e+00_r8, 4.78656e+00_r8, 4.82551e+00_r8, &
     & 4.86478e+00_r8, 4.90436e+00_r8, 4.94427e+00_r8, 4.98450e+00_r8, 5.02506e+00_r8, &
     & 5.06595e+00_r8, 5.10717e+00_r8, 5.14873e+00_r8, 5.19062e+00_r8/)
      kao_mn2o( 3, :, 8) = (/ &
     & 3.69928e+00_r8, 3.72584e+00_r8, 3.75259e+00_r8, 3.77953e+00_r8, 3.80666e+00_r8, &
     & 3.83399e+00_r8, 3.86152e+00_r8, 3.88924e+00_r8, 3.91717e+00_r8, 3.94529e+00_r8, &
     & 3.97361e+00_r8, 4.00214e+00_r8, 4.03088e+00_r8, 4.05982e+00_r8, 4.08896e+00_r8, &
     & 4.11832e+00_r8, 4.14789e+00_r8, 4.17767e+00_r8, 4.20766e+00_r8/)
      kao_mn2o( 4, :, 8) = (/ &
     & 3.17856e+00_r8, 3.19596e+00_r8, 3.21345e+00_r8, 3.23104e+00_r8, 3.24872e+00_r8, &
     & 3.26650e+00_r8, 3.28437e+00_r8, 3.30235e+00_r8, 3.32042e+00_r8, 3.33859e+00_r8, &
     & 3.35686e+00_r8, 3.37523e+00_r8, 3.39370e+00_r8, 3.41227e+00_r8, 3.43095e+00_r8, &
     & 3.44972e+00_r8, 3.46860e+00_r8, 3.48758e+00_r8, 3.50667e+00_r8/)
      kao_mn2o( 5, :, 8) = (/ &
     & 3.16549e+00_r8, 3.18288e+00_r8, 3.20037e+00_r8, 3.21795e+00_r8, 3.23563e+00_r8, &
     & 3.25340e+00_r8, 3.27128e+00_r8, 3.28925e+00_r8, 3.30732e+00_r8, 3.32549e+00_r8, &
     & 3.34376e+00_r8, 3.36213e+00_r8, 3.38060e+00_r8, 3.39917e+00_r8, 3.41785e+00_r8, &
     & 3.43662e+00_r8, 3.45551e+00_r8, 3.47449e+00_r8, 3.49358e+00_r8/)
      kao_mn2o( 6, :, 8) = (/ &
     & 3.16612e+00_r8, 3.18355e+00_r8, 3.20108e+00_r8, 3.21870e+00_r8, 3.23643e+00_r8, &
     & 3.25425e+00_r8, 3.27217e+00_r8, 3.29018e+00_r8, 3.30830e+00_r8, 3.32652e+00_r8, &
     & 3.34483e+00_r8, 3.36325e+00_r8, 3.38177e+00_r8, 3.40039e+00_r8, 3.41911e+00_r8, &
     & 3.43794e+00_r8, 3.45687e+00_r8, 3.47591e+00_r8, 3.49505e+00_r8/)
      kao_mn2o( 7, :, 8) = (/ &
     & 3.19644e+00_r8, 3.21419e+00_r8, 3.23203e+00_r8, 3.24996e+00_r8, 3.26800e+00_r8, &
     & 3.28614e+00_r8, 3.30438e+00_r8, 3.32272e+00_r8, 3.34116e+00_r8, 3.35970e+00_r8, &
     & 3.37835e+00_r8, 3.39710e+00_r8, 3.41596e+00_r8, 3.43492e+00_r8, 3.45398e+00_r8, &
     & 3.47315e+00_r8, 3.49243e+00_r8, 3.51181e+00_r8, 3.53130e+00_r8/)
      kao_mn2o( 8, :, 8) = (/ &
     & 3.35759e+00_r8, 3.37775e+00_r8, 3.39804e+00_r8, 3.41845e+00_r8, 3.43899e+00_r8, &
     & 3.45964e+00_r8, 3.48042e+00_r8, 3.50133e+00_r8, 3.52236e+00_r8, 3.54351e+00_r8, &
     & 3.56480e+00_r8, 3.58621e+00_r8, 3.60775e+00_r8, 3.62942e+00_r8, 3.65122e+00_r8, &
     & 3.67315e+00_r8, 3.69521e+00_r8, 3.71741e+00_r8, 3.73974e+00_r8/)
      kao_mn2o( 9, :, 8) = (/ &
     & 3.17378e+00_r8, 3.19135e+00_r8, 3.20901e+00_r8, 3.22677e+00_r8, 3.24462e+00_r8, &
     & 3.26258e+00_r8, 3.28063e+00_r8, 3.29879e+00_r8, 3.31704e+00_r8, 3.33540e+00_r8, &
     & 3.35386e+00_r8, 3.37242e+00_r8, 3.39108e+00_r8, 3.40984e+00_r8, 3.42871e+00_r8, &
     & 3.44769e+00_r8, 3.46677e+00_r8, 3.48595e+00_r8, 3.50524e+00_r8/)
      kao_mn2o( 1, :, 9) = (/ &
     & 2.09106e+01_r8, 2.08779e+01_r8, 2.08452e+01_r8, 2.08126e+01_r8, 2.07800e+01_r8, &
     & 2.07475e+01_r8, 2.07150e+01_r8, 2.06826e+01_r8, 2.06502e+01_r8, 2.06179e+01_r8, &
     & 2.05856e+01_r8, 2.05534e+01_r8, 2.05213e+01_r8, 2.04891e+01_r8, 2.04571e+01_r8, &
     & 2.04251e+01_r8, 2.03931e+01_r8, 2.03612e+01_r8, 2.03293e+01_r8/)
      kao_mn2o( 2, :, 9) = (/ &
     & 2.60494e+00_r8, 2.62757e+00_r8, 2.65040e+00_r8, 2.67343e+00_r8, 2.69665e+00_r8, &
     & 2.72008e+00_r8, 2.74372e+00_r8, 2.76756e+00_r8, 2.79160e+00_r8, 2.81586e+00_r8, &
     & 2.84032e+00_r8, 2.86500e+00_r8, 2.88989e+00_r8, 2.91500e+00_r8, 2.94033e+00_r8, &
     & 2.96588e+00_r8, 2.99164e+00_r8, 3.01764e+00_r8, 3.04386e+00_r8/)
      kao_mn2o( 3, :, 9) = (/ &
     & 2.42238e+00_r8, 2.44514e+00_r8, 2.46811e+00_r8, 2.49130e+00_r8, 2.51471e+00_r8, &
     & 2.53834e+00_r8, 2.56219e+00_r8, 2.58626e+00_r8, 2.61056e+00_r8, 2.63509e+00_r8, &
     & 2.65985e+00_r8, 2.68484e+00_r8, 2.71007e+00_r8, 2.73554e+00_r8, 2.76124e+00_r8, &
     & 2.78718e+00_r8, 2.81337e+00_r8, 2.83981e+00_r8, 2.86649e+00_r8/)
      kao_mn2o( 4, :, 9) = (/ &
     & 2.33681e+00_r8, 2.35961e+00_r8, 2.38263e+00_r8, 2.40588e+00_r8, 2.42935e+00_r8, &
     & 2.45305e+00_r8, 2.47699e+00_r8, 2.50115e+00_r8, 2.52556e+00_r8, 2.55020e+00_r8, &
     & 2.57508e+00_r8, 2.60021e+00_r8, 2.62558e+00_r8, 2.65119e+00_r8, 2.67706e+00_r8, &
     & 2.70318e+00_r8, 2.72955e+00_r8, 2.75619e+00_r8, 2.78308e+00_r8/)
      kao_mn2o( 5, :, 9) = (/ &
     & 2.26420e+00_r8, 2.28696e+00_r8, 2.30996e+00_r8, 2.33319e+00_r8, 2.35665e+00_r8, &
     & 2.38035e+00_r8, 2.40429e+00_r8, 2.42846e+00_r8, 2.45288e+00_r8, 2.47755e+00_r8, &
     & 2.50246e+00_r8, 2.52763e+00_r8, 2.55304e+00_r8, 2.57871e+00_r8, 2.60465e+00_r8, &
     & 2.63084e+00_r8, 2.65729e+00_r8, 2.68401e+00_r8, 2.71100e+00_r8/)
      kao_mn2o( 6, :, 9) = (/ &
     & 2.19628e+00_r8, 2.21902e+00_r8, 2.24199e+00_r8, 2.26520e+00_r8, 2.28865e+00_r8, &
     & 2.31234e+00_r8, 2.33628e+00_r8, 2.36047e+00_r8, 2.38491e+00_r8, 2.40959e+00_r8, &
     & 2.43454e+00_r8, 2.45974e+00_r8, 2.48521e+00_r8, 2.51094e+00_r8, 2.53693e+00_r8, &
     & 2.56319e+00_r8, 2.58973e+00_r8, 2.61654e+00_r8, 2.64363e+00_r8/)
      kao_mn2o( 7, :, 9) = (/ &
     & 2.07829e+00_r8, 2.10090e+00_r8, 2.12375e+00_r8, 2.14685e+00_r8, 2.17021e+00_r8, &
     & 2.19381e+00_r8, 2.21767e+00_r8, 2.24180e+00_r8, 2.26618e+00_r8, 2.29083e+00_r8, &
     & 2.31575e+00_r8, 2.34094e+00_r8, 2.36640e+00_r8, 2.39214e+00_r8, 2.41816e+00_r8, &
     & 2.44446e+00_r8, 2.47105e+00_r8, 2.49793e+00_r8, 2.52510e+00_r8/)
      kao_mn2o( 8, :, 9) = (/ &
     & 1.68230e+00_r8, 1.70305e+00_r8, 1.72404e+00_r8, 1.74530e+00_r8, 1.76681e+00_r8, &
     & 1.78860e+00_r8, 1.81065e+00_r8, 1.83297e+00_r8, 1.85557e+00_r8, 1.87845e+00_r8, &
     & 1.90161e+00_r8, 1.92505e+00_r8, 1.94878e+00_r8, 1.97281e+00_r8, 1.99713e+00_r8, &
     & 2.02176e+00_r8, 2.04668e+00_r8, 2.07191e+00_r8, 2.09746e+00_r8/)
      kao_mn2o( 9, :, 9) = (/ &
     & 2.23224e+00_r8, 2.25486e+00_r8, 2.27771e+00_r8, 2.30079e+00_r8, 2.32411e+00_r8, &
     & 2.34766e+00_r8, 2.37145e+00_r8, 2.39548e+00_r8, 2.41975e+00_r8, 2.44427e+00_r8, &
     & 2.46904e+00_r8, 2.49406e+00_r8, 2.51933e+00_r8, 2.54486e+00_r8, 2.57065e+00_r8, &
     & 2.59670e+00_r8, 2.62301e+00_r8, 2.64959e+00_r8, 2.67644e+00_r8/)
      kao_mn2o( 1, :,10) = (/ &
     & 1.30711e+01_r8, 1.31853e+01_r8, 1.33004e+01_r8, 1.34166e+01_r8, 1.35339e+01_r8, &
     & 1.36521e+01_r8, 1.37714e+01_r8, 1.38917e+01_r8, 1.40130e+01_r8, 1.41355e+01_r8, &
     & 1.42590e+01_r8, 1.43835e+01_r8, 1.45092e+01_r8, 1.46360e+01_r8, 1.47638e+01_r8, &
     & 1.48928e+01_r8, 1.50229e+01_r8, 1.51542e+01_r8, 1.52866e+01_r8/)
      kao_mn2o( 2, :,10) = (/ &
     & 2.71206e-01_r8, 2.90148e-01_r8, 3.10413e-01_r8, 3.32093e-01_r8, 3.55287e-01_r8, &
     & 3.80102e-01_r8, 4.06649e-01_r8, 4.35051e-01_r8, 4.65436e-01_r8, 4.97943e-01_r8, &
     & 5.32721e-01_r8, 5.69928e-01_r8, 6.09733e-01_r8, 6.52319e-01_r8, 6.97879e-01_r8, &
     & 7.46621e-01_r8, 7.98767e-01_r8, 8.54555e-01_r8, 9.14239e-01_r8/)
      kao_mn2o( 3, :,10) = (/ &
     & 2.65609e-01_r8, 2.84236e-01_r8, 3.04170e-01_r8, 3.25501e-01_r8, 3.48329e-01_r8, &
     & 3.72758e-01_r8, 3.98900e-01_r8, 4.26875e-01_r8, 4.56812e-01_r8, 4.88849e-01_r8, &
     & 5.23132e-01_r8, 5.59820e-01_r8, 5.99080e-01_r8, 6.41095e-01_r8, 6.86055e-01_r8, &
     & 7.34169e-01_r8, 7.85657e-01_r8, 8.40756e-01_r8, 8.99718e-01_r8/)
      kao_mn2o( 4, :,10) = (/ &
     & 2.55277e-01_r8, 2.73370e-01_r8, 2.92745e-01_r8, 3.13494e-01_r8, 3.35714e-01_r8, &
     & 3.59508e-01_r8, 3.84989e-01_r8, 4.12275e-01_r8, 4.41496e-01_r8, 4.72788e-01_r8, &
     & 5.06298e-01_r8, 5.42183e-01_r8, 5.80611e-01_r8, 6.21763e-01_r8, 6.65831e-01_r8, &
     & 7.13023e-01_r8, 7.63560e-01_r8, 8.17678e-01_r8, 8.75633e-01_r8/)
      kao_mn2o( 5, :,10) = (/ &
     & 2.41481e-01_r8, 2.58840e-01_r8, 2.77446e-01_r8, 2.97390e-01_r8, 3.18768e-01_r8, &
     & 3.41682e-01_r8, 3.66244e-01_r8, 3.92571e-01_r8, 4.20791e-01_r8, 4.51039e-01_r8, &
     & 4.83461e-01_r8, 5.18215e-01_r8, 5.55466e-01_r8, 5.95396e-01_r8, 6.38195e-01_r8, &
     & 6.84071e-01_r8, 7.33245e-01_r8, 7.85954e-01_r8, 8.42452e-01_r8/)
      kao_mn2o( 6, :,10) = (/ &
     & 2.37173e-01_r8, 2.54360e-01_r8, 2.72792e-01_r8, 2.92559e-01_r8, 3.13759e-01_r8, &
     & 3.36495e-01_r8, 3.60878e-01_r8, 3.87029e-01_r8, 4.15074e-01_r8, 4.45152e-01_r8, &
     & 4.77409e-01_r8, 5.12004e-01_r8, 5.49105e-01_r8, 5.88895e-01_r8, 6.31569e-01_r8, &
     & 6.77334e-01_r8, 7.26416e-01_r8, 7.79055e-01_r8, 8.35508e-01_r8/)
      kao_mn2o( 7, :,10) = (/ &
     & 2.27414e-01_r8, 2.44231e-01_r8, 2.62292e-01_r8, 2.81689e-01_r8, 3.02520e-01_r8, &
     & 3.24891e-01_r8, 3.48917e-01_r8, 3.74720e-01_r8, 4.02430e-01_r8, 4.32190e-01_r8, &
     & 4.64151e-01_r8, 4.98475e-01_r8, 5.35337e-01_r8, 5.74926e-01_r8, 6.17442e-01_r8, &
     & 6.63102e-01_r8, 7.12138e-01_r8, 7.64801e-01_r8, 8.21358e-01_r8/)
      kao_mn2o( 8, :,10) = (/ &
     & 1.77234e-01_r8, 1.92029e-01_r8, 2.08060e-01_r8, 2.25429e-01_r8, 2.44248e-01_r8, &
     & 2.64638e-01_r8, 2.86730e-01_r8, 3.10667e-01_r8, 3.36601e-01_r8, 3.64701e-01_r8, &
     & 3.95147e-01_r8, 4.28134e-01_r8, 4.63875e-01_r8, 5.02600e-01_r8, 5.44557e-01_r8, &
     & 5.90017e-01_r8, 6.39272e-01_r8, 6.92639e-01_r8, 7.50461e-01_r8/)
      kao_mn2o( 9, :,10) = (/ &
     & 2.41727e-01_r8, 2.59094e-01_r8, 2.77710e-01_r8, 2.97662e-01_r8, 3.19049e-01_r8, &
     & 3.41972e-01_r8, 3.66541e-01_r8, 3.92877e-01_r8, 4.21104e-01_r8, 4.51359e-01_r8, &
     & 4.83788e-01_r8, 5.18547e-01_r8, 5.55804e-01_r8, 5.95737e-01_r8, 6.38539e-01_r8, &
     & 6.84417e-01_r8, 7.33590e-01_r8, 7.86297e-01_r8, 8.42790e-01_r8/)
      kao_mn2o( 1, :,11) = (/ &
     & 6.65287e+00_r8, 6.69137e+00_r8, 6.73008e+00_r8, 6.76903e+00_r8, 6.80820e+00_r8, &
     & 6.84759e+00_r8, 6.88721e+00_r8, 6.92707e+00_r8, 6.96715e+00_r8, 7.00746e+00_r8, &
     & 7.04801e+00_r8, 7.08879e+00_r8, 7.12981e+00_r8, 7.17107e+00_r8, 7.21256e+00_r8, &
     & 7.25430e+00_r8, 7.29628e+00_r8, 7.33850e+00_r8, 7.38096e+00_r8/)
      kao_mn2o( 2, :,11) = (/ &
     & 2.06252e-01_r8, 2.27731e-01_r8, 2.51447e-01_r8, 2.77633e-01_r8, 3.06546e-01_r8, &
     & 3.38470e-01_r8, 3.73719e-01_r8, 4.12638e-01_r8, 4.55611e-01_r8, 5.03058e-01_r8, &
     & 5.55447e-01_r8, 6.13292e-01_r8, 6.77160e-01_r8, 7.47680e-01_r8, 8.25544e-01_r8, &
     & 9.11517e-01_r8, 1.00644e+00_r8, 1.11125e+00_r8, 1.22698e+00_r8/)
      kao_mn2o( 3, :,11) = (/ &
     & 2.05840e-01_r8, 2.27279e-01_r8, 2.50952e-01_r8, 2.77090e-01_r8, 3.05950e-01_r8, &
     & 3.37816e-01_r8, 3.73002e-01_r8, 4.11852e-01_r8, 4.54748e-01_r8, 5.02113e-01_r8, &
     & 5.54411e-01_r8, 6.12155e-01_r8, 6.75915e-01_r8, 7.46315e-01_r8, 8.24047e-01_r8, &
     & 9.09876e-01_r8, 1.00465e+00_r8, 1.10928e+00_r8, 1.22482e+00_r8/)
      kao_mn2o( 4, :,11) = (/ &
     & 2.04702e-01_r8, 2.26031e-01_r8, 2.49582e-01_r8, 2.75587e-01_r8, 3.04301e-01_r8, &
     & 3.36008e-01_r8, 3.71018e-01_r8, 4.09675e-01_r8, 4.52361e-01_r8, 4.99495e-01_r8, &
     & 5.51539e-01_r8, 6.09007e-01_r8, 6.72461e-01_r8, 7.42528e-01_r8, 8.19895e-01_r8, &
     & 9.05323e-01_r8, 9.99653e-01_r8, 1.10381e+00_r8, 1.21882e+00_r8/)
      kao_mn2o( 5, :,11) = (/ &
     & 2.03481e-01_r8, 2.24689e-01_r8, 2.48108e-01_r8, 2.73967e-01_r8, 3.02522e-01_r8, &
     & 3.34053e-01_r8, 3.68871e-01_r8, 4.07317e-01_r8, 4.49771e-01_r8, 4.96649e-01_r8, &
     & 5.48414e-01_r8, 6.05574e-01_r8, 6.68691e-01_r8, 7.38387e-01_r8, 8.15347e-01_r8, &
     & 9.00329e-01_r8, 9.94168e-01_r8, 1.09779e+00_r8, 1.21221e+00_r8/)
      kao_mn2o( 6, :,11) = (/ &
     & 2.01513e-01_r8, 2.22529e-01_r8, 2.45738e-01_r8, 2.71367e-01_r8, 2.99670e-01_r8, &
     & 3.30924e-01_r8, 3.65437e-01_r8, 4.03550e-01_r8, 4.45639e-01_r8, 4.92117e-01_r8, &
     & 5.43442e-01_r8, 6.00120e-01_r8, 6.62710e-01_r8, 7.31827e-01_r8, 8.08153e-01_r8, &
     & 8.92439e-01_r8, 9.85516e-01_r8, 1.08830e+00_r8, 1.20180e+00_r8/)
      kao_mn2o( 7, :,11) = (/ &
     & 1.97136e-01_r8, 2.17723e-01_r8, 2.40459e-01_r8, 2.65570e-01_r8, 2.93304e-01_r8, &
     & 3.23933e-01_r8, 3.57762e-01_r8, 3.95122e-01_r8, 4.36385e-01_r8, 4.81956e-01_r8, &
     & 5.32287e-01_r8, 5.87873e-01_r8, 6.49264e-01_r8, 7.17067e-01_r8, 7.91950e-01_r8, &
     & 8.74653e-01_r8, 9.65992e-01_r8, 1.06687e+00_r8, 1.17828e+00_r8/)
      kao_mn2o( 8, :,11) = (/ &
     & 1.79518e-01_r8, 1.98371e-01_r8, 2.19204e-01_r8, 2.42224e-01_r8, 2.67662e-01_r8, &
     & 2.95772e-01_r8, 3.26833e-01_r8, 3.61157e-01_r8, 3.99085e-01_r8, 4.40996e-01_r8, &
     & 4.87309e-01_r8, 5.38486e-01_r8, 5.95037e-01_r8, 6.57526e-01_r8, 7.26579e-01_r8, &
     & 8.02883e-01_r8, 8.87201e-01_r8, 9.80373e-01_r8, 1.08333e+00_r8/)
      kao_mn2o( 9, :,11) = (/ &
     & 2.03481e-01_r8, 2.24689e-01_r8, 2.48108e-01_r8, 2.73967e-01_r8, 3.02522e-01_r8, &
     & 3.34053e-01_r8, 3.68871e-01_r8, 4.07317e-01_r8, 4.49771e-01_r8, 4.96649e-01_r8, &
     & 5.48414e-01_r8, 6.05574e-01_r8, 6.68691e-01_r8, 7.38387e-01_r8, 8.15347e-01_r8, &
     & 9.00329e-01_r8, 9.94168e-01_r8, 1.09779e+00_r8, 1.21221e+00_r8/)
      kao_mn2o( 1, :,12) = (/ &
     & 5.89636e+00_r8, 5.95081e+00_r8, 6.00576e+00_r8, 6.06121e+00_r8, 6.11718e+00_r8, &
     & 6.17366e+00_r8, 6.23067e+00_r8, 6.28820e+00_r8, 6.34627e+00_r8, 6.40487e+00_r8, &
     & 6.46401e+00_r8, 6.52369e+00_r8, 6.58393e+00_r8, 6.64472e+00_r8, 6.70608e+00_r8, &
     & 6.76800e+00_r8, 6.83050e+00_r8, 6.89357e+00_r8, 6.95722e+00_r8/)
      kao_mn2o( 2, :,12) = (/ &
     & 7.18699e-05_r8, 9.48140e-05_r8, 1.25083e-04_r8, 1.65015e-04_r8, 2.17695e-04_r8, &
     & 2.87193e-04_r8, 3.78877e-04_r8, 4.99831e-04_r8, 6.59400e-04_r8, 8.69909e-04_r8, &
     & 1.14762e-03_r8, 1.51400e-03_r8, 1.99733e-03_r8, 2.63497e-03_r8, 3.47616e-03_r8, &
     & 4.58591e-03_r8, 6.04993e-03_r8, 7.98133e-03_r8, 1.05293e-02_r8/)
      kao_mn2o( 3, :,12) = (/ &
     & 7.20868e-05_r8, 9.50993e-05_r8, 1.25458e-04_r8, 1.65508e-04_r8, 2.18344e-04_r8, &
     & 2.88046e-04_r8, 3.80000e-04_r8, 5.01307e-04_r8, 6.61341e-04_r8, 8.72462e-04_r8, &
     & 1.15098e-03_r8, 1.51841e-03_r8, 2.00313e-03_r8, 2.64260e-03_r8, 3.48620e-03_r8, &
     & 4.59911e-03_r8, 6.06729e-03_r8, 8.00416e-03_r8, 1.05593e-02_r8/)
      kao_mn2o( 4, :,12) = (/ &
     & 7.21734e-05_r8, 9.52161e-05_r8, 1.25616e-04_r8, 1.65721e-04_r8, 2.18630e-04_r8, &
     & 2.88432e-04_r8, 3.80519e-04_r8, 5.02007e-04_r8, 6.62282e-04_r8, 8.73727e-04_r8, &
     & 1.15268e-03_r8, 1.52070e-03_r8, 2.00621e-03_r8, 2.64673e-03_r8, 3.49174e-03_r8, &
     & 4.60655e-03_r8, 6.07727e-03_r8, 8.01755e-03_r8, 1.05773e-02_r8/)
      kao_mn2o( 5, :,12) = (/ &
     & 7.22599e-05_r8, 9.53329e-05_r8, 1.25773e-04_r8, 1.65933e-04_r8, 2.18916e-04_r8, &
     & 2.88818e-04_r8, 3.81038e-04_r8, 5.02706e-04_r8, 6.63223e-04_r8, 8.74992e-04_r8, &
     & 1.15438e-03_r8, 1.52298e-03_r8, 2.00928e-03_r8, 2.65085e-03_r8, 3.49728e-03_r8, &
     & 4.61398e-03_r8, 6.08725e-03_r8, 8.03094e-03_r8, 1.05952e-02_r8/)
      kao_mn2o( 6, :,12) = (/ &
     & 7.29962e-05_r8, 9.63091e-05_r8, 1.27067e-04_r8, 1.67649e-04_r8, 2.21191e-04_r8, &
     & 2.91833e-04_r8, 3.85036e-04_r8, 5.08005e-04_r8, 6.70247e-04_r8, 8.84304e-04_r8, &
     & 1.16672e-03_r8, 1.53934e-03_r8, 2.03096e-03_r8, 2.67959e-03_r8, 3.53537e-03_r8, &
     & 4.66447e-03_r8, 6.15417e-03_r8, 8.11962e-03_r8, 1.07128e-02_r8/)
      kao_mn2o( 7, :,12) = (/ &
     & 7.47398e-05_r8, 9.86139e-05_r8, 1.30114e-04_r8, 1.71677e-04_r8, 2.26516e-04_r8, &
     & 2.98872e-04_r8, 3.94340e-04_r8, 5.20305e-04_r8, 6.86506e-04_r8, 9.05797e-04_r8, &
     & 1.19514e-03_r8, 1.57690e-03_r8, 2.08061e-03_r8, 2.74522e-03_r8, 3.62213e-03_r8, &
     & 4.77915e-03_r8, 6.30576e-03_r8, 8.32001e-03_r8, 1.09777e-02_r8/)
      kao_mn2o( 8, :,12) = (/ &
     & 7.57487e-05_r8, 9.99802e-05_r8, 1.31963e-04_r8, 1.74177e-04_r8, 2.29896e-04_r8, &
     & 3.03438e-04_r8, 4.00506e-04_r8, 5.28625e-04_r8, 6.97729e-04_r8, 9.20927e-04_r8, &
     & 1.21553e-03_r8, 1.60437e-03_r8, 2.11759e-03_r8, 2.79499e-03_r8, 3.68909e-03_r8, &
     & 4.86921e-03_r8, 6.42684e-03_r8, 8.48274e-03_r8, 1.11963e-02_r8/)
      kao_mn2o( 9, :,12) = (/ &
     & 7.22467e-05_r8, 9.53177e-05_r8, 1.25756e-04_r8, 1.65915e-04_r8, 2.18898e-04_r8, &
     & 2.88800e-04_r8, 3.81024e-04_r8, 5.02700e-04_r8, 6.63231e-04_r8, 8.75024e-04_r8, &
     & 1.15445e-03_r8, 1.52311e-03_r8, 2.00950e-03_r8, 2.65121e-03_r8, 3.49784e-03_r8, &
     & 4.61483e-03_r8, 6.08852e-03_r8, 8.03280e-03_r8, 1.05980e-02_r8/)
      kao_mn2o( 1, :,13) = (/ &
     & 1.14265e+01_r8, 1.16380e+01_r8, 1.18534e+01_r8, 1.20728e+01_r8, 1.22962e+01_r8, &
     & 1.25238e+01_r8, 1.27556e+01_r8, 1.29917e+01_r8, 1.32322e+01_r8, 1.34771e+01_r8, &
     & 1.37265e+01_r8, 1.39806e+01_r8, 1.42394e+01_r8, 1.45029e+01_r8, 1.47714e+01_r8, &
     & 1.50448e+01_r8, 1.53232e+01_r8, 1.56068e+01_r8, 1.58957e+01_r8/)
      kao_mn2o( 2, :,13) = (/ &
     & 7.97796e-05_r8, 1.05659e-04_r8, 1.39932e-04_r8, 1.85324e-04_r8, 2.45439e-04_r8, &
     & 3.25054e-04_r8, 4.30496e-04_r8, 5.70140e-04_r8, 7.55082e-04_r8, 1.00002e-03_r8, &
     & 1.32440e-03_r8, 1.75401e-03_r8, 2.32298e-03_r8, 3.07651e-03_r8, 4.07447e-03_r8, &
     & 5.39614e-03_r8, 7.14655e-03_r8, 9.46475e-03_r8, 1.25349e-02_r8/)
      kao_mn2o( 3, :,13) = (/ &
     & 7.95035e-05_r8, 1.05293e-04_r8, 1.39449e-04_r8, 1.84684e-04_r8, 2.44592e-04_r8, &
     & 3.23934e-04_r8, 4.29013e-04_r8, 5.68178e-04_r8, 7.52486e-04_r8, 9.96580e-04_r8, &
     & 1.31985e-03_r8, 1.74800e-03_r8, 2.31502e-03_r8, 3.06597e-03_r8, 4.06052e-03_r8, &
     & 5.37770e-03_r8, 7.12214e-03_r8, 9.43244e-03_r8, 1.24922e-02_r8/)
      kao_mn2o( 4, :,13) = (/ &
     & 7.92339e-05_r8, 1.04938e-04_r8, 1.38980e-04_r8, 1.84065e-04_r8, 2.43776e-04_r8, &
     & 3.22857e-04_r8, 4.27593e-04_r8, 5.66305e-04_r8, 7.50016e-04_r8, 9.93322e-04_r8, &
     & 1.31556e-03_r8, 1.74233e-03_r8, 2.30754e-03_r8, 3.05612e-03_r8, 4.04752e-03_r8, &
     & 5.36055e-03_r8, 7.09953e-03_r8, 9.40262e-03_r8, 1.24528e-02_r8/)
      kao_mn2o( 5, :,13) = (/ &
     & 7.90000e-05_r8, 1.04627e-04_r8, 1.38566e-04_r8, 1.83516e-04_r8, 2.43046e-04_r8, &
     & 3.21887e-04_r8, 4.26303e-04_r8, 5.64591e-04_r8, 7.47738e-04_r8, 9.90295e-04_r8, &
     & 1.31154e-03_r8, 1.73698e-03_r8, 2.30044e-03_r8, 3.04667e-03_r8, 4.03498e-03_r8, &
     & 5.34388e-03_r8, 7.07737e-03_r8, 9.37318e-03_r8, 1.24137e-02_r8/)
      kao_mn2o( 6, :,13) = (/ &
     & 7.76004e-05_r8, 1.02776e-04_r8, 1.36118e-04_r8, 1.80278e-04_r8, 2.38764e-04_r8, &
     & 3.16224e-04_r8, 4.18814e-04_r8, 5.54686e-04_r8, 7.34638e-04_r8, 9.72970e-04_r8, &
     & 1.28862e-03_r8, 1.70668e-03_r8, 2.26036e-03_r8, 2.99367e-03_r8, 3.96488e-03_r8, &
     & 5.25118e-03_r8, 6.95477e-03_r8, 9.21105e-03_r8, 1.21993e-02_r8/)
      kao_mn2o( 7, :,13) = (/ &
     & 7.52813e-05_r8, 9.97094e-05_r8, 1.32064e-04_r8, 1.74918e-04_r8, 2.31677e-04_r8, &
     & 3.06854e-04_r8, 4.06426e-04_r8, 5.38308e-04_r8, 7.12984e-04_r8, 9.44341e-04_r8, &
     & 1.25077e-03_r8, 1.65664e-03_r8, 2.19420e-03_r8, 2.90620e-03_r8, 3.84923e-03_r8, &
     & 5.09828e-03_r8, 6.75263e-03_r8, 8.94379e-03_r8, 1.18460e-02_r8/)
      kao_mn2o( 8, :,13) = (/ &
     & 6.87436e-05_r8, 9.10605e-05_r8, 1.20622e-04_r8, 1.59781e-04_r8, 2.11653e-04_r8, &
     & 2.80364e-04_r8, 3.71381e-04_r8, 4.91946e-04_r8, 6.51651e-04_r8, 8.63203e-04_r8, &
     & 1.14343e-03_r8, 1.51464e-03_r8, 2.00635e-03_r8, 2.65769e-03_r8, 3.52048e-03_r8, &
     & 4.66337e-03_r8, 6.17729e-03_r8, 8.18269e-03_r8, 1.08391e-02_r8/)
      kao_mn2o( 9, :,13) = (/ &
     & 7.90357e-05_r8, 1.04671e-04_r8, 1.38622e-04_r8, 1.83585e-04_r8, 2.43132e-04_r8, &
     & 3.21994e-04_r8, 4.26434e-04_r8, 5.64750e-04_r8, 7.47931e-04_r8, 9.90526e-04_r8, &
     & 1.31181e-03_r8, 1.73730e-03_r8, 2.30081e-03_r8, 3.04709e-03_r8, 4.03543e-03_r8, &
     & 5.34435e-03_r8, 7.07782e-03_r8, 9.37355e-03_r8, 1.24139e-02_r8/)
      kao_mn2o( 1, :,14) = (/ &
     & 1.61373e+01_r8, 1.64784e+01_r8, 1.68266e+01_r8, 1.71822e+01_r8, 1.75454e+01_r8, &
     & 1.79162e+01_r8, 1.82948e+01_r8, 1.86814e+01_r8, 1.90762e+01_r8, 1.94794e+01_r8, &
     & 1.98911e+01_r8, 2.03114e+01_r8, 2.07407e+01_r8, 2.11790e+01_r8, 2.16266e+01_r8, &
     & 2.20836e+01_r8, 2.25504e+01_r8, 2.30269e+01_r8, 2.35136e+01_r8/)
      kao_mn2o( 2, :,14) = (/ &
     & 6.92866e-10_r8, 9.24655e-10_r8, 1.23398e-09_r8, 1.64680e-09_r8, 2.19771e-09_r8, &
     & 2.93292e-09_r8, 3.91409e-09_r8, 5.22349e-09_r8, 6.97093e-09_r8, 9.30295e-09_r8, &
     & 1.24151e-08_r8, 1.65684e-08_r8, 2.21111e-08_r8, 2.95081e-08_r8, 3.93796e-08_r8, &
     & 5.25535e-08_r8, 7.01346e-08_r8, 9.35970e-08_r8, 1.24908e-07_r8/)
      kao_mn2o( 3, :,14) = (/ &
     & 6.94564e-10_r8, 9.26928e-10_r8, 1.23703e-09_r8, 1.65088e-09_r8, 2.20317e-09_r8, &
     & 2.94024e-09_r8, 3.92389e-09_r8, 5.23661e-09_r8, 6.98851e-09_r8, 9.32650e-09_r8, &
     & 1.24467e-08_r8, 1.66107e-08_r8, 2.21677e-08_r8, 2.95839e-08_r8, 3.94811e-08_r8, &
     & 5.26894e-08_r8, 7.03165e-08_r8, 9.38407e-08_r8, 1.25235e-07_r8/)
      kao_mn2o( 4, :,14) = (/ &
     & 6.98644e-10_r8, 9.32310e-10_r8, 1.24413e-09_r8, 1.66023e-09_r8, 2.21551e-09_r8, &
     & 2.95649e-09_r8, 3.94531e-09_r8, 5.26484e-09_r8, 7.02570e-09_r8, 9.37548e-09_r8, &
     & 1.25112e-08_r8, 1.66956e-08_r8, 2.22795e-08_r8, 2.97311e-08_r8, 3.96748e-08_r8, &
     & 5.29443e-08_r8, 7.06518e-08_r8, 9.42817e-08_r8, 1.25815e-07_r8/)
      kao_mn2o( 5, :,14) = (/ &
     & 7.03261e-10_r8, 9.38472e-10_r8, 1.25235e-09_r8, 1.67121e-09_r8, 2.23016e-09_r8, &
     & 2.97605e-09_r8, 3.97141e-09_r8, 5.29968e-09_r8, 7.07220e-09_r8, 9.43754e-09_r8, &
     & 1.25940e-08_r8, 1.68062e-08_r8, 2.24271e-08_r8, 2.99280e-08_r8, 3.99376e-08_r8, &
     & 5.32951e-08_r8, 7.11200e-08_r8, 9.49066e-08_r8, 1.26649e-07_r8/)
      kao_mn2o( 6, :,14) = (/ &
     & 7.12478e-10_r8, 9.50674e-10_r8, 1.26850e-09_r8, 1.69259e-09_r8, 2.25845e-09_r8, &
     & 3.01350e-09_r8, 4.02096e-09_r8, 5.36525e-09_r8, 7.15896e-09_r8, 9.55233e-09_r8, &
     & 1.27459e-08_r8, 1.70071e-08_r8, 2.26928e-08_r8, 3.02795e-08_r8, 4.04025e-08_r8, &
     & 5.39099e-08_r8, 7.19330e-08_r8, 9.59815e-08_r8, 1.28070e-07_r8/)
      kao_mn2o( 7, :,14) = (/ &
     & 7.28994e-10_r8, 9.72644e-10_r8, 1.29773e-09_r8, 1.73147e-09_r8, 2.31017e-09_r8, &
     & 3.08230e-09_r8, 4.11249e-09_r8, 5.48700e-09_r8, 7.32092e-09_r8, 9.76777e-09_r8, &
     & 1.30324e-08_r8, 1.73883e-08_r8, 2.31999e-08_r8, 3.09540e-08_r8, 4.12996e-08_r8, &
     & 5.51032e-08_r8, 7.35203e-08_r8, 9.80928e-08_r8, 1.30878e-07_r8/)
      kao_mn2o( 8, :,14) = (/ &
     & 7.87604e-10_r8, 1.05043e-09_r8, 1.40097e-09_r8, 1.86848e-09_r8, 2.49201e-09_r8, &
     & 3.32360e-09_r8, 4.43271e-09_r8, 5.91194e-09_r8, 7.88479e-09_r8, 1.05160e-08_r8, &
     & 1.40253e-08_r8, 1.87056e-08_r8, 2.49478e-08_r8, 3.32730e-08_r8, 4.43764e-08_r8, &
     & 5.91851e-08_r8, 7.89356e-08_r8, 1.05277e-07_r8, 1.40408e-07_r8/)
      kao_mn2o( 9, :,14) = (/ &
     & 7.03261e-10_r8, 9.38472e-10_r8, 1.25235e-09_r8, 1.67121e-09_r8, 2.23016e-09_r8, &
     & 2.97605e-09_r8, 3.97141e-09_r8, 5.29968e-09_r8, 7.07220e-09_r8, 9.43754e-09_r8, &
     & 1.25940e-08_r8, 1.68062e-08_r8, 2.24271e-08_r8, 2.99280e-08_r8, 3.99376e-08_r8, &
     & 5.32951e-08_r8, 7.11200e-08_r8, 9.49066e-08_r8, 1.26649e-07_r8/)
      kao_mn2o( 1, :,15) = (/ &
     & 2.14029e+01_r8, 2.16782e+01_r8, 2.19571e+01_r8, 2.22396e+01_r8, 2.25257e+01_r8, &
     & 2.28155e+01_r8, 2.31090e+01_r8, 2.34063e+01_r8, 2.37074e+01_r8, 2.40124e+01_r8, &
     & 2.43213e+01_r8, 2.46342e+01_r8, 2.49511e+01_r8, 2.52721e+01_r8, 2.55972e+01_r8, &
     & 2.59265e+01_r8, 2.62600e+01_r8, 2.65979e+01_r8, 2.69400e+01_r8/)
      kao_mn2o( 2, :,15) = (/ &
     & 5.68659e-10_r8, 7.55629e-10_r8, 1.00407e-09_r8, 1.33421e-09_r8, 1.77288e-09_r8, &
     & 2.35579e-09_r8, 3.13036e-09_r8, 4.15960e-09_r8, 5.52724e-09_r8, 7.34455e-09_r8, &
     & 9.75939e-09_r8, 1.29682e-08_r8, 1.72320e-08_r8, 2.28978e-08_r8, 3.04264e-08_r8, &
     & 4.04304e-08_r8, 5.37236e-08_r8, 7.13875e-08_r8, 9.48591e-08_r8/)
      kao_mn2o( 3, :,15) = (/ &
     & 5.59573e-10_r8, 7.43558e-10_r8, 9.88035e-10_r8, 1.31290e-09_r8, 1.74457e-09_r8, &
     & 2.31817e-09_r8, 3.08037e-09_r8, 4.09318e-09_r8, 5.43900e-09_r8, 7.22730e-09_r8, &
     & 9.60360e-09_r8, 1.27612e-08_r8, 1.69570e-08_r8, 2.25324e-08_r8, 2.99409e-08_r8, &
     & 3.97853e-08_r8, 5.28665e-08_r8, 7.02486e-08_r8, 9.33459e-08_r8/)
      kao_mn2o( 4, :,15) = (/ &
     & 5.50488e-10_r8, 7.31486e-10_r8, 9.71996e-10_r8, 1.29158e-09_r8, 1.71625e-09_r8, &
     & 2.28055e-09_r8, 3.03039e-09_r8, 4.02676e-09_r8, 5.35075e-09_r8, 7.11005e-09_r8, &
     & 9.44781e-09_r8, 1.25542e-08_r8, 1.66820e-08_r8, 2.21670e-08_r8, 2.94554e-08_r8, &
     & 3.91402e-08_r8, 5.20093e-08_r8, 6.91098e-08_r8, 9.18327e-08_r8/)
      kao_mn2o( 5, :,15) = (/ &
     & 5.34010e-10_r8, 7.09574e-10_r8, 9.42858e-10_r8, 1.25284e-09_r8, 1.66473e-09_r8, &
     & 2.21203e-09_r8, 2.93927e-09_r8, 3.90560e-09_r8, 5.18963e-09_r8, 6.89580e-09_r8, &
     & 9.16290e-09_r8, 1.21754e-08_r8, 1.61782e-08_r8, 2.14970e-08_r8, 2.85645e-08_r8, &
     & 3.79555e-08_r8, 5.04340e-08_r8, 6.70149e-08_r8, 8.90470e-08_r8/)
      kao_mn2o( 6, :,15) = (/ &
     & 5.08144e-10_r8, 6.75221e-10_r8, 8.97231e-10_r8, 1.19224e-09_r8, 1.58424e-09_r8, &
     & 2.10513e-09_r8, 2.79729e-09_r8, 3.71703e-09_r8, 4.93919e-09_r8, 6.56317e-09_r8, &
     & 8.72112e-09_r8, 1.15886e-08_r8, 1.53989e-08_r8, 2.04620e-08_r8, 2.71898e-08_r8, &
     & 3.61297e-08_r8, 4.80091e-08_r8, 6.37943e-08_r8, 8.47696e-08_r8/)
      kao_mn2o( 7, :,15) = (/ &
     & 4.56716e-10_r8, 6.06884e-10_r8, 8.06427e-10_r8, 1.07158e-09_r8, 1.42391e-09_r8, &
     & 1.89210e-09_r8, 2.51422e-09_r8, 3.34089e-09_r8, 4.43938e-09_r8, 5.89904e-09_r8, &
     & 7.83864e-09_r8, 1.04160e-08_r8, 1.38408e-08_r8, 1.83916e-08_r8, 2.44387e-08_r8, &
     & 3.24742e-08_r8, 4.31517e-08_r8, 5.73399e-08_r8, 7.61932e-08_r8/)
      kao_mn2o( 8, :,15) = (/ &
     & 2.78366e-10_r8, 3.69881e-10_r8, 4.91482e-10_r8, 6.53061e-10_r8, 8.67760e-10_r8, &
     & 1.15304e-09_r8, 1.53211e-09_r8, 2.03581e-09_r8, 2.70510e-09_r8, 3.59441e-09_r8, &
     & 4.77611e-09_r8, 6.34629e-09_r8, 8.43268e-09_r8, 1.12050e-08_r8, 1.48887e-08_r8, &
     & 1.97835e-08_r8, 2.62875e-08_r8, 3.49296e-08_r8, 4.64130e-08_r8/)
      kao_mn2o( 9, :,15) = (/ &
     & 5.34010e-10_r8, 7.09574e-10_r8, 9.42858e-10_r8, 1.25284e-09_r8, 1.66473e-09_r8, &
     & 2.21203e-09_r8, 2.93927e-09_r8, 3.90560e-09_r8, 5.18963e-09_r8, 6.89580e-09_r8, &
     & 9.16290e-09_r8, 1.21754e-08_r8, 1.61782e-08_r8, 2.14970e-08_r8, 2.85645e-08_r8, &
     & 3.79555e-08_r8, 5.04340e-08_r8, 6.70149e-08_r8, 8.90470e-08_r8/)
      kao_mn2o( 1, :,16) = (/ &
     & 2.90784e+01_r8, 2.93787e+01_r8, 2.96820e+01_r8, 2.99885e+01_r8, 3.02982e+01_r8, &
     & 3.06110e+01_r8, 3.09271e+01_r8, 3.12464e+01_r8, 3.15690e+01_r8, 3.18950e+01_r8, &
     & 3.22243e+01_r8, 3.25571e+01_r8, 3.28932e+01_r8, 3.32329e+01_r8, 3.35760e+01_r8, &
     & 3.39227e+01_r8, 3.42730e+01_r8, 3.46269e+01_r8, 3.49844e+01_r8/)
      kao_mn2o( 2, :,16) = (/ &
     & 0.00000e+00_r8, 0.00000e+00_r8, 0.00000e+00_r8, 0.00000e+00_r8, 0.00000e+00_r8, &
     & 0.00000e+00_r8, 0.00000e+00_r8, 0.00000e+00_r8, 0.00000e+00_r8, 0.00000e+00_r8, &
     & 0.00000e+00_r8, 0.00000e+00_r8, 0.00000e+00_r8, 0.00000e+00_r8, 0.00000e+00_r8, &
     & 0.00000e+00_r8, 0.00000e+00_r8, 0.00000e+00_r8, 0.00000e+00_r8/)
      kao_mn2o( 3, :,16) = (/ &
     & 0.00000e+00_r8, 0.00000e+00_r8, 0.00000e+00_r8, 0.00000e+00_r8, 0.00000e+00_r8, &
     & 0.00000e+00_r8, 0.00000e+00_r8, 0.00000e+00_r8, 0.00000e+00_r8, 0.00000e+00_r8, &
     & 0.00000e+00_r8, 0.00000e+00_r8, 0.00000e+00_r8, 0.00000e+00_r8, 0.00000e+00_r8, &
     & 0.00000e+00_r8, 0.00000e+00_r8, 0.00000e+00_r8, 0.00000e+00_r8/)
      kao_mn2o( 4, :,16) = (/ &
     & 0.00000e+00_r8, 0.00000e+00_r8, 0.00000e+00_r8, 0.00000e+00_r8, 0.00000e+00_r8, &
     & 0.00000e+00_r8, 0.00000e+00_r8, 0.00000e+00_r8, 0.00000e+00_r8, 0.00000e+00_r8, &
     & 0.00000e+00_r8, 0.00000e+00_r8, 0.00000e+00_r8, 0.00000e+00_r8, 0.00000e+00_r8, &
     & 0.00000e+00_r8, 0.00000e+00_r8, 0.00000e+00_r8, 0.00000e+00_r8/)
      kao_mn2o( 5, :,16) = (/ &
     & 0.00000e+00_r8, 0.00000e+00_r8, 0.00000e+00_r8, 0.00000e+00_r8, 0.00000e+00_r8, &
     & 0.00000e+00_r8, 0.00000e+00_r8, 0.00000e+00_r8, 0.00000e+00_r8, 0.00000e+00_r8, &
     & 0.00000e+00_r8, 0.00000e+00_r8, 0.00000e+00_r8, 0.00000e+00_r8, 0.00000e+00_r8, &
     & 0.00000e+00_r8, 0.00000e+00_r8, 0.00000e+00_r8, 0.00000e+00_r8/)
      kao_mn2o( 6, :,16) = (/ &
     & 0.00000e+00_r8, 0.00000e+00_r8, 0.00000e+00_r8, 0.00000e+00_r8, 0.00000e+00_r8, &
     & 0.00000e+00_r8, 0.00000e+00_r8, 0.00000e+00_r8, 0.00000e+00_r8, 0.00000e+00_r8, &
     & 0.00000e+00_r8, 0.00000e+00_r8, 0.00000e+00_r8, 0.00000e+00_r8, 0.00000e+00_r8, &
     & 0.00000e+00_r8, 0.00000e+00_r8, 0.00000e+00_r8, 0.00000e+00_r8/)
      kao_mn2o( 7, :,16) = (/ &
     & 0.00000e+00_r8, 0.00000e+00_r8, 0.00000e+00_r8, 0.00000e+00_r8, 0.00000e+00_r8, &
     & 0.00000e+00_r8, 0.00000e+00_r8, 0.00000e+00_r8, 0.00000e+00_r8, 0.00000e+00_r8, &
     & 0.00000e+00_r8, 0.00000e+00_r8, 0.00000e+00_r8, 0.00000e+00_r8, 0.00000e+00_r8, &
     & 0.00000e+00_r8, 0.00000e+00_r8, 0.00000e+00_r8, 0.00000e+00_r8/)
      kao_mn2o( 8, :,16) = (/ &
     & 0.00000e+00_r8, 0.00000e+00_r8, 0.00000e+00_r8, 0.00000e+00_r8, 0.00000e+00_r8, &
     & 0.00000e+00_r8, 0.00000e+00_r8, 0.00000e+00_r8, 0.00000e+00_r8, 0.00000e+00_r8, &
     & 0.00000e+00_r8, 0.00000e+00_r8, 0.00000e+00_r8, 0.00000e+00_r8, 0.00000e+00_r8, &
     & 0.00000e+00_r8, 0.00000e+00_r8, 0.00000e+00_r8, 0.00000e+00_r8/)
      kao_mn2o( 9, :,16) = (/ &
     & 0.00000e+00_r8, 0.00000e+00_r8, 0.00000e+00_r8, 0.00000e+00_r8, 0.00000e+00_r8, &
     & 0.00000e+00_r8, 0.00000e+00_r8, 0.00000e+00_r8, 0.00000e+00_r8, 0.00000e+00_r8, &
     & 0.00000e+00_r8, 0.00000e+00_r8, 0.00000e+00_r8, 0.00000e+00_r8, 0.00000e+00_r8, &
     & 0.00000e+00_r8, 0.00000e+00_r8, 0.00000e+00_r8, 0.00000e+00_r8/)

!     The array KBO_Mxx contains the absorption coefficient for 
!     a minor species at the 16 chosen g-values for a reference pressure
!     level above 100~ mb.   The first index refers to temperature 
!     in 7.2 degree increments.  For instance, JT = 1 refers to a 
!     temperature of 188.0, JT = 2 refers to 195.2, etc. The second index 
!     runs over the g-channel (1 to 16).

      kbo_mn2o(:, 1) = (/ &
     & 8.42688e-03_r8, 8.96787e-03_r8, 9.54358e-03_r8, 1.01563e-02_r8, 1.08083e-02_r8, &
     & 1.15021e-02_r8, 1.22405e-02_r8, 1.30263e-02_r8, 1.38626e-02_r8, 1.47525e-02_r8, &
     & 1.56996e-02_r8, 1.67075e-02_r8, 1.77800e-02_r8, 1.89215e-02_r8, 2.01362e-02_r8, &
     & 2.14289e-02_r8, 2.28045e-02_r8, 2.42685e-02_r8, 2.58265e-02_r8/)
      kbo_mn2o(:, 2) = (/ &
     & 2.24976e-02_r8, 2.38935e-02_r8, 2.53762e-02_r8, 2.69508e-02_r8, 2.86231e-02_r8, &
     & 3.03991e-02_r8, 3.22854e-02_r8, 3.42887e-02_r8, 3.64163e-02_r8, 3.86760e-02_r8, &
     & 4.10759e-02_r8, 4.36246e-02_r8, 4.63315e-02_r8, 4.92064e-02_r8, 5.22597e-02_r8, &
     & 5.55024e-02_r8, 5.89464e-02_r8, 6.26040e-02_r8, 6.64886e-02_r8/)
      kbo_mn2o(:, 3) = (/ &
     & 5.93542e-02_r8, 6.37312e-02_r8, 6.84310e-02_r8, 7.34774e-02_r8, 7.88960e-02_r8, &
     & 8.47141e-02_r8, 9.09613e-02_r8, 9.76692e-02_r8, 1.04872e-01_r8, 1.12605e-01_r8, &
     & 1.20910e-01_r8, 1.29826e-01_r8, 1.39400e-01_r8, 1.49680e-01_r8, 1.60718e-01_r8, &
     & 1.72570e-01_r8, 1.85296e-01_r8, 1.98961e-01_r8, 2.13633e-01_r8/)
      kbo_mn2o(:, 4) = (/ &
     & 1.98022e-01_r8, 2.05895e-01_r8, 2.14082e-01_r8, 2.22594e-01_r8, 2.31445e-01_r8, &
     & 2.40647e-01_r8, 2.50216e-01_r8, 2.60164e-01_r8, 2.70509e-01_r8, 2.81265e-01_r8, &
     & 2.92448e-01_r8, 3.04076e-01_r8, 3.16167e-01_r8, 3.28738e-01_r8, 3.41809e-01_r8, &
     & 3.55400e-01_r8, 3.69531e-01_r8, 3.84224e-01_r8, 3.99501e-01_r8/)
      kbo_mn2o(:, 5) = (/ &
     & 6.41413e-01_r8, 6.46239e-01_r8, 6.51101e-01_r8, 6.56000e-01_r8, 6.60936e-01_r8, &
     & 6.65910e-01_r8, 6.70920e-01_r8, 6.75968e-01_r8, 6.81054e-01_r8, 6.86179e-01_r8, &
     & 6.91342e-01_r8, 6.96544e-01_r8, 7.01785e-01_r8, 7.07065e-01_r8, 7.12385e-01_r8, &
     & 7.17746e-01_r8, 7.23146e-01_r8, 7.28587e-01_r8, 7.34070e-01_r8/)
      kbo_mn2o(:, 6) = (/ &
     & 1.47906e+00_r8, 1.48768e+00_r8, 1.49635e+00_r8, 1.50507e+00_r8, 1.51384e+00_r8, &
     & 1.52267e+00_r8, 1.53154e+00_r8, 1.54047e+00_r8, 1.54944e+00_r8, 1.55847e+00_r8, &
     & 1.56755e+00_r8, 1.57669e+00_r8, 1.58588e+00_r8, 1.59512e+00_r8, 1.60442e+00_r8, &
     & 1.61377e+00_r8, 1.62317e+00_r8, 1.63263e+00_r8, 1.64215e+00_r8/)
      kbo_mn2o(:, 7) = (/ &
     & 3.53152e+00_r8, 3.55492e+00_r8, 3.57848e+00_r8, 3.60219e+00_r8, 3.62606e+00_r8, &
     & 3.65008e+00_r8, 3.67427e+00_r8, 3.69862e+00_r8, 3.72313e+00_r8, 3.74780e+00_r8, &
     & 3.77263e+00_r8, 3.79763e+00_r8, 3.82279e+00_r8, 3.84812e+00_r8, 3.87362e+00_r8, &
     & 3.89929e+00_r8, 3.92513e+00_r8, 3.95114e+00_r8, 3.97732e+00_r8/)
      kbo_mn2o(:, 8) = (/ &
     & 9.06783e+00_r8, 9.04597e+00_r8, 9.02415e+00_r8, 9.00239e+00_r8, 8.98069e+00_r8, &
     & 8.95903e+00_r8, 8.93743e+00_r8, 8.91588e+00_r8, 8.89438e+00_r8, 8.87293e+00_r8, &
     & 8.85154e+00_r8, 8.83020e+00_r8, 8.80890e+00_r8, 8.78766e+00_r8, 8.76647e+00_r8, &
     & 8.74533e+00_r8, 8.72425e+00_r8, 8.70321e+00_r8, 8.68223e+00_r8/)
      kbo_mn2o(:, 9) = (/ &
     & 3.88220e+01_r8, 3.85805e+01_r8, 3.83405e+01_r8, 3.81019e+01_r8, 3.78649e+01_r8, &
     & 3.76293e+01_r8, 3.73952e+01_r8, 3.71625e+01_r8, 3.69313e+01_r8, 3.67016e+01_r8, &
     & 3.64732e+01_r8, 3.62463e+01_r8, 3.60208e+01_r8, 3.57967e+01_r8, 3.55740e+01_r8, &
     & 3.53527e+01_r8, 3.51327e+01_r8, 3.49142e+01_r8, 3.46970e+01_r8/)
      kbo_mn2o(:, 10) = (/ &
     & 1.14211e+02_r8, 1.13955e+02_r8, 1.13700e+02_r8, 1.13445e+02_r8, 1.13191e+02_r8, &
     & 1.12938e+02_r8, 1.12685e+02_r8, 1.12433e+02_r8, 1.12181e+02_r8, 1.11930e+02_r8, &
     & 1.11679e+02_r8, 1.11429e+02_r8, 1.11180e+02_r8, 1.10931e+02_r8, 1.10682e+02_r8, &
     & 1.10434e+02_r8, 1.10187e+02_r8, 1.09940e+02_r8, 1.09694e+02_r8/)
      kbo_mn2o(:, 11) = (/ &
     & 1.60513e+02_r8, 1.60857e+02_r8, 1.61201e+02_r8, 1.61547e+02_r8, 1.61893e+02_r8, &
     & 1.62240e+02_r8, 1.62587e+02_r8, 1.62936e+02_r8, 1.63285e+02_r8, 1.63635e+02_r8, &
     & 1.63985e+02_r8, 1.64337e+02_r8, 1.64689e+02_r8, 1.65041e+02_r8, 1.65395e+02_r8, &
     & 1.65749e+02_r8, 1.66105e+02_r8, 1.66460e+02_r8, 1.66817e+02_r8/)
      kbo_mn2o(:, 12) = (/ &
     & 1.71473e+02_r8, 1.72766e+02_r8, 1.74068e+02_r8, 1.75381e+02_r8, 1.76703e+02_r8, &
     & 1.78035e+02_r8, 1.79377e+02_r8, 1.80729e+02_r8, 1.82091e+02_r8, 1.83464e+02_r8, &
     & 1.84847e+02_r8, 1.86240e+02_r8, 1.87644e+02_r8, 1.89059e+02_r8, 1.90484e+02_r8, &
     & 1.91920e+02_r8, 1.93367e+02_r8, 1.94824e+02_r8, 1.96293e+02_r8/)
      kbo_mn2o(:, 13) = (/ &
     & 2.71287e+01_r8, 2.75538e+01_r8, 2.79856e+01_r8, 2.84241e+01_r8, 2.88695e+01_r8, &
     & 2.93219e+01_r8, 2.97814e+01_r8, 3.02480e+01_r8, 3.07220e+01_r8, 3.12035e+01_r8, &
     & 3.16924e+01_r8, 3.21890e+01_r8, 3.26934e+01_r8, 3.32058e+01_r8, 3.37261e+01_r8, &
     & 3.42546e+01_r8, 3.47914e+01_r8, 3.53365e+01_r8, 3.58903e+01_r8/)
      kbo_mn2o(:, 14) = (/ &
     & 1.70389e+01_r8, 1.70899e+01_r8, 1.71411e+01_r8, 1.71924e+01_r8, 1.72439e+01_r8, &
     & 1.72955e+01_r8, 1.73473e+01_r8, 1.73992e+01_r8, 1.74513e+01_r8, 1.75035e+01_r8, &
     & 1.75559e+01_r8, 1.76085e+01_r8, 1.76612e+01_r8, 1.77141e+01_r8, 1.77671e+01_r8, &
     & 1.78203e+01_r8, 1.78736e+01_r8, 1.79271e+01_r8, 1.79808e+01_r8/)
      kbo_mn2o(:, 15) = (/ &
     & 2.49725e+00_r8, 2.66861e+00_r8, 2.85174e+00_r8, 3.04743e+00_r8, 3.25655e+00_r8, &
     & 3.48003e+00_r8, 3.71883e+00_r8, 3.97403e+00_r8, 4.24673e+00_r8, 4.53815e+00_r8, &
     & 4.84957e+00_r8, 5.18236e+00_r8, 5.53798e+00_r8, 5.91801e+00_r8, 6.32412e+00_r8, &
     & 6.75809e+00_r8, 7.22185e+00_r8, 7.71742e+00_r8, 8.24701e+00_r8/)
      kbo_mn2o(:, 16) = (/ &
     & 1.82935e-03_r8, 2.58912e-03_r8, 3.66444e-03_r8, 5.18637e-03_r8, 7.34039e-03_r8, &
     & 1.03890e-02_r8, 1.47038e-02_r8, 2.08106e-02_r8, 2.94538e-02_r8, 4.16865e-02_r8, &
     & 5.89999e-02_r8, 8.35040e-02_r8, 1.18185e-01_r8, 1.67270e-01_r8, 2.36741e-01_r8, &
     & 3.35065e-01_r8, 4.74225e-01_r8, 6.71180e-01_r8, 9.49936e-01_r8/)

!     The array FORREFO contains the coefficient of the water vapor
!     foreign-continuum (including the energy term).  The first 
!     index refers to reference temperature (296,260,224,260) and 
!     pressure (970,475,219,3 mbar) levels.  The second index 
!     runs over the g-channel (1 to 16).

      forrefo(1,:) = (/ &
     &7.5352e-06_r8,2.9812e-05_r8,1.4497e-04_r8,4.4006e-04_r8,1.0492e-03_r8,1.9676e-03_r8, &
     &1.9989e-03_r8,1.9099e-03_r8,2.2121e-03_r8,2.4491e-03_r8,2.9573e-03_r8,2.6344e-03_r8, &
     &3.0629e-03_r8,3.3547e-03_r8,5.0643e-03_r8,5.0642e-03_r8/)
      forrefo(2,:) = (/ &
     &6.6070e-06_r8,4.8618e-05_r8,3.1112e-04_r8,8.4235e-04_r8,1.4179e-03_r8,1.4315e-03_r8, &
     &1.4685e-03_r8,1.6554e-03_r8,2.1171e-03_r8,2.3545e-03_r8,2.5165e-03_r8,2.7680e-03_r8, &
     &2.6985e-03_r8,3.5345e-03_r8,4.2924e-03_r8,5.0712e-03_r8/)
      forrefo(3,:) = (/ &
     &6.5962e-06_r8,7.2595e-04_r8,1.3429e-03_r8,1.1675e-03_r8,9.8384e-04_r8,8.8787e-04_r8, &
     &8.7557e-04_r8,8.0589e-04_r8,7.7024e-04_r8,8.7518e-04_r8,9.5213e-04_r8,9.0849e-04_r8, &
     &1.2596e-03_r8,2.5106e-03_r8,3.9471e-03_r8,5.0742e-03_r8/)
      forrefo(4,:) = (/ &
     &3.6217e-04_r8,1.0709e-03_r8,1.0628e-03_r8,8.5640e-04_r8,8.9332e-04_r8,8.3372e-04_r8, &
     &7.8539e-04_r8,8.2828e-04_r8,8.3329e-04_r8,8.5118e-04_r8,8.2878e-04_r8,6.8570e-04_r8, &
     &6.3815e-04_r8,8.0648e-04_r8,2.3236e-03_r8,4.0321e-03_r8/)

!     The array SELFREFO contains the coefficient of the water vapor
!     self-continuum (including the energy term).  The first index
!     refers to temperature in 7.2 degree increments.  For instance,
!     JT = 1 refers to a temperature of 245.6, JT = 2 refers to 252.8,
!     etc.  The second index runs over the g-channel (1 to 16).

      selfrefo(:, 1) = (/ &
     & 2.83453e-02_r8, 2.51439e-02_r8, 2.23040e-02_r8, 1.97849e-02_r8, 1.75503e-02_r8, &
     & 1.55681e-02_r8, 1.38097e-02_r8, 1.22500e-02_r8, 1.08664e-02_r8, 9.63912e-03_r8/)
      selfrefo(:, 2) = (/ &
     & 3.05185e-02_r8, 2.72374e-02_r8, 2.43090e-02_r8, 2.16955e-02_r8, 1.93629e-02_r8, &
     & 1.72811e-02_r8, 1.54232e-02_r8, 1.37650e-02_r8, 1.22851e-02_r8, 1.09643e-02_r8/)
      selfrefo(:, 3) = (/ &
     & 4.23833e-02_r8, 3.76250e-02_r8, 3.34010e-02_r8, 2.96512e-02_r8, 2.63223e-02_r8, &
     & 2.33672e-02_r8, 2.07439e-02_r8, 1.84150e-02_r8, 1.63476e-02_r8, 1.45123e-02_r8/)
      selfrefo(:, 4) = (/ &
     & 5.76481e-02_r8, 5.13686e-02_r8, 4.57730e-02_r8, 4.07870e-02_r8, 3.63441e-02_r8, &
     & 3.23851e-02_r8, 2.88574e-02_r8, 2.57140e-02_r8, 2.29130e-02_r8, 2.04171e-02_r8/)
      selfrefo(:, 5) = (/ &
     & 6.92255e-02_r8, 6.33521e-02_r8, 5.79770e-02_r8, 5.30580e-02_r8, 4.85563e-02_r8, &
     & 4.44365e-02_r8, 4.06663e-02_r8, 3.72160e-02_r8, 3.40584e-02_r8, 3.11687e-02_r8/)
      selfrefo(:, 6) = (/ &
     & 6.07694e-02_r8, 5.94182e-02_r8, 5.80970e-02_r8, 5.68052e-02_r8, 5.55422e-02_r8, &
     & 5.43072e-02_r8, 5.30997e-02_r8, 5.19190e-02_r8, 5.07646e-02_r8, 4.96358e-02_r8/)
      selfrefo(:, 7) = (/ &
     & 6.23749e-02_r8, 6.07744e-02_r8, 5.92150e-02_r8, 5.76956e-02_r8, 5.62152e-02_r8, &
     & 5.47728e-02_r8, 5.33674e-02_r8, 5.19980e-02_r8, 5.06638e-02_r8, 4.93638e-02_r8/)
      selfrefo(:, 8) = (/ &
     & 6.90744e-02_r8, 6.61811e-02_r8, 6.34090e-02_r8, 6.07530e-02_r8, 5.82083e-02_r8, &
     & 5.57702e-02_r8, 5.34342e-02_r8, 5.11960e-02_r8, 4.90516e-02_r8, 4.69970e-02_r8/)
      selfrefo(:, 9) = (/ &
     & 8.08992e-02_r8, 7.68876e-02_r8, 7.30750e-02_r8, 6.94514e-02_r8, 6.60075e-02_r8, &
     & 6.27344e-02_r8, 5.96236e-02_r8, 5.66670e-02_r8, 5.38570e-02_r8, 5.11864e-02_r8/)
      selfrefo(:,10) = (/ &
     & 8.70197e-02_r8, 8.27485e-02_r8, 7.86870e-02_r8, 7.48248e-02_r8, 7.11522e-02_r8, &
     & 6.76599e-02_r8, 6.43389e-02_r8, 6.11810e-02_r8, 5.81781e-02_r8, 5.53225e-02_r8/)
      selfrefo(:,11) = (/ &
     & 8.84776e-02_r8, 8.54262e-02_r8, 8.24800e-02_r8, 7.96354e-02_r8, 7.68890e-02_r8, &
     & 7.42373e-02_r8, 7.16770e-02_r8, 6.92050e-02_r8, 6.68183e-02_r8, 6.45139e-02_r8/)
      selfrefo(:,12) = (/ &
     & 9.82552e-02_r8, 9.25696e-02_r8, 8.72130e-02_r8, 8.21664e-02_r8, 7.74118e-02_r8, &
     & 7.29323e-02_r8, 6.87121e-02_r8, 6.47360e-02_r8, 6.09900e-02_r8, 5.74608e-02_r8/)
      selfrefo(:,13) = (/ &
     & 9.32447e-02_r8, 8.96818e-02_r8, 8.62550e-02_r8, 8.29592e-02_r8, 7.97893e-02_r8, &
     & 7.67405e-02_r8, 7.38082e-02_r8, 7.09880e-02_r8, 6.82755e-02_r8, 6.56667e-02_r8/)
      selfrefo(:,14) = (/ &
     & 1.15363e-01_r8, 1.08593e-01_r8, 1.02220e-01_r8, 9.62210e-02_r8, 9.05741e-02_r8, &
     & 8.52585e-02_r8, 8.02549e-02_r8, 7.55450e-02_r8, 7.11115e-02_r8, 6.69382e-02_r8/)
      selfrefo(:,15) = (/ &
     & 1.23179e-01_r8, 1.19247e-01_r8, 1.15440e-01_r8, 1.11755e-01_r8, 1.08187e-01_r8, &
     & 1.04734e-01_r8, 1.01391e-01_r8, 9.81540e-02_r8, 9.50207e-02_r8, 9.19875e-02_r8/)
      selfrefo(:,16) = (/ &
     & 1.44104e-01_r8, 1.36412e-01_r8, 1.29130e-01_r8, 1.22237e-01_r8, 1.15712e-01_r8, &
     & 1.09535e-01_r8, 1.03688e-01_r8, 9.81530e-02_r8, 9.29135e-02_r8, 8.79537e-02_r8/)

      end subroutine lw_kgb09

! **************************************************************************
