!     path:      $Source: /storm/rc1/cvsroot/rc/rrtmg_lw/src/rrtmg_lw_k_g.f90,v $
!     author:    $Author: mike $
!     revision:  $Revision: 1.2 $
!     created:   $Date: 2007/08/22 19:20:03 $
!
!  --------------------------------------------------------------------------
! |                                                                          |
! |  Copyright 2002-2007, Atmospheric & Environmental Research, Inc. (AER).  |
! |  This software may be used, copied, or redistributed as long as it is    |
! |  not sold and this copyright notice is reproduced on each copy made.     |
! |  This model is provided as is without any express or implied warranties. |
! |                       (http://www.rtweb.aer.com/)                        |
! |                                                                          |
!  --------------------------------------------------------------------------

! **************************************************************************
!      subroutine lw_kgbnn
! **************************************************************************
!  RRTM Longwave Radiative Transfer Model
!  Atmospheric and Environmental Research, Inc., Cambridge, MA
!
!  Original version:   E. J. Mlawer, et al.
!  Revision for GCMs:  Michael J. Iacono; October, 2002
!
!  This file contains 16 subroutines that include the 
!  absorption coefficients and other data for each of the 16 longwave
!  spectral bands used in RRTM.  Here, the data are defined for 16
!  g-points, or sub-intervals, per band.  These data are combined and
!  weighted using a mapping procedure in routine RRTMG_LW_INIT to reduce
!  the total number of g-points from 256 to 140 for use in the GCM.
! **************************************************************************
      subroutine lw_kgb15
! **************************************************************************

      use shr_kind_mod, only: r8 => shr_kind_r8

!      use parkind, only : jpim, jprb 
      use rrlw_kg15, only : fracrefao, kao, kao_mn2, selfrefo, forrefo

      implicit none
      save

! Planck fraction mapping level : P = 1053. mb, T = 294.2 K
      fracrefao(:, 1) = (/ &
     &  1.0689e-01_r8,1.1563e-01_r8,1.2447e-01_r8,1.2921e-01_r8,1.2840e-01_r8,1.2113e-01_r8, &
     &  1.0643e-01_r8,8.4987e-02_r8,6.0142e-02_r8,6.6798e-03_r8,5.5293e-03_r8,4.3700e-03_r8, &
     &  3.2061e-03_r8,2.0476e-03_r8,7.7366e-04_r8,1.0897e-04_r8/)
      fracrefao(:, 2) = (/ &
     &  1.0782e-01_r8,1.1637e-01_r8,1.2290e-01_r8,1.2911e-01_r8,1.2841e-01_r8,1.2113e-01_r8, &
     &  1.0643e-01_r8,8.4987e-02_r8,6.0142e-02_r8,6.6798e-03_r8,5.5293e-03_r8,4.3700e-03_r8, &
     &  3.2061e-03_r8,2.0476e-03_r8,7.7366e-04_r8,1.0897e-04_r8/)
      fracrefao(:, 3) = (/ &
     &  1.0858e-01_r8,1.1860e-01_r8,1.2237e-01_r8,1.2665e-01_r8,1.2841e-01_r8,1.2111e-01_r8, &
     &  1.0642e-01_r8,8.4987e-02_r8,6.0142e-02_r8,6.6798e-03_r8,5.5293e-03_r8,4.3700e-03_r8, &
     &  3.2061e-03_r8,2.0476e-03_r8,7.7366e-04_r8,1.0897e-04_r8/)
      fracrefao(:, 4) = (/ &
     &  1.1022e-01_r8,1.1965e-01_r8,1.2334e-01_r8,1.2383e-01_r8,1.2761e-01_r8,1.2109e-01_r8, &
     &  1.0642e-01_r8,8.4987e-02_r8,6.0142e-02_r8,6.6798e-03_r8,5.5293e-03_r8,4.3700e-03_r8, &
     &  3.2061e-03_r8,2.0476e-03_r8,7.7366e-04_r8,1.0897e-04_r8/)
      fracrefao(:, 5) = (/ &
     &  1.1342e-01_r8,1.2069e-01_r8,1.2360e-01_r8,1.2447e-01_r8,1.2340e-01_r8,1.2020e-01_r8, &
     &  1.0639e-01_r8,8.4987e-02_r8,6.0142e-02_r8,6.6798e-03_r8,5.5293e-03_r8,4.3700e-03_r8, &
     &  3.2061e-03_r8,2.0476e-03_r8,7.7366e-04_r8,1.0897e-04_r8/)
      fracrefao(:, 6) = (/ &
     &  1.1771e-01_r8,1.2280e-01_r8,1.2177e-01_r8,1.2672e-01_r8,1.2398e-01_r8,1.1787e-01_r8, &
     &  1.0131e-01_r8,8.4987e-02_r8,6.0142e-02_r8,6.6798e-03_r8,5.5293e-03_r8,4.3700e-03_r8, &
     &  3.2061e-03_r8,2.0476e-03_r8,7.7366e-04_r8,1.0897e-04_r8/)
      fracrefao(:, 7) = (/ &
     &  1.2320e-01_r8,1.2491e-01_r8,1.2001e-01_r8,1.2936e-01_r8,1.2653e-01_r8,1.1929e-01_r8, &
     &  9.8955e-02_r8,7.4887e-02_r8,6.0142e-02_r8,6.6798e-03_r8,5.5293e-03_r8,4.3700e-03_r8, &
     &  3.2061e-03_r8,2.0476e-03_r8,7.7366e-04_r8,1.0897e-04_r8/)
      fracrefao(:, 8) = (/ &
     &  1.3105e-01_r8,1.2563e-01_r8,1.3055e-01_r8,1.2854e-01_r8,1.3402e-01_r8,1.1571e-01_r8, &
     &  9.4876e-02_r8,6.0459e-02_r8,5.6457e-02_r8,6.6798e-03_r8,5.5293e-03_r8,4.3700e-03_r8, &
     &  3.2061e-03_r8,2.0476e-03_r8,7.7366e-04_r8,1.0897e-04_r8/)
      fracrefao(:, 9) = (/ &
     &  1.1375e-01_r8,1.2090e-01_r8,1.2348e-01_r8,1.2458e-01_r8,1.2406e-01_r8,1.1921e-01_r8, &
     &  1.0802e-01_r8,8.6613e-02_r8,5.8125e-02_r8,6.2984e-03_r8,5.2359e-03_r8,4.0641e-03_r8, &
     &  2.9379e-03_r8,1.9001e-03_r8,7.2646e-04_r8,1.0553e-04_r8/)

!     The array KAO contains absorption coefs for each of the 16 g-intervals
!     for a range of pressure levels > ~100mb, temperatures, and ratios
!     of water vapor to CO2.  The first index in the array, JS, runs
!     from 1 to 10, and corresponds to different gas column amount ratios,
!     as expressed through the binary species parameter eta, defined as
!     eta = gas1/(gas1 + (rat) * gas2), where rat is the 
!     ratio of the reference MLS column amount value of gas 1 
!     to that of gas2.
!     The 2nd index in the array, JT, which runs from 1 to 5, corresponds 
!     to different temperatures.  More specifically, JT = 3 means that the 
!     data are for the reference temperature TREF for this  pressure 
!     level, JT = 2 refers to the temperature
!     TREF-15, JT = 1 is for TREF-30, JT = 4 is for TREF+15, and JT = 5
!     is for TREF+30.  The third index, JP, runs from 1 to 13 and refers
!     to the reference pressure level (e.g. JP = 1 is for a
!     pressure of 1053.63 mb).  The fourth index, IG, goes from 1 to 16,
!     and tells us which g-interval the absorption coefficients are for.

      kao(:, 1, 1, 1) = (/ &
     &3.4242e-02_r8,1.7071e-01_r8,2.6138e-01_r8,3.1721e-01_r8,3.2432e-01_r8,2.6831e-01_r8, &
     &2.0528e-01_r8,1.1088e-01_r8,5.8968e-01_r8/)
      kao(:, 2, 1, 1) = (/ &
     &3.3652e-02_r8,1.6779e-01_r8,2.5725e-01_r8,3.0829e-01_r8,3.1520e-01_r8,2.6815e-01_r8, &
     &2.0103e-01_r8,1.1213e-01_r8,5.6496e-01_r8/)
      kao(:, 3, 1, 1) = (/ &
     &3.2936e-02_r8,1.6580e-01_r8,2.5340e-01_r8,3.0468e-01_r8,3.0583e-01_r8,2.6658e-01_r8, &
     &1.9781e-01_r8,1.1388e-01_r8,5.5053e-01_r8/)
      kao(:, 4, 1, 1) = (/ &
     &3.2004e-02_r8,1.6475e-01_r8,2.5029e-01_r8,3.0171e-01_r8,3.0308e-01_r8,2.6842e-01_r8, &
     &1.9857e-01_r8,1.1861e-01_r8,5.4961e-01_r8/)
      kao(:, 5, 1, 1) = (/ &
     &3.0990e-02_r8,1.6410e-01_r8,2.4670e-01_r8,2.9476e-01_r8,3.0044e-01_r8,2.7387e-01_r8, &
     &1.9493e-01_r8,1.2451e-01_r8,5.3996e-01_r8/)
      kao(:, 1, 2, 1) = (/ &
     &3.0564e-02_r8,1.4940e-01_r8,2.2694e-01_r8,2.6721e-01_r8,2.6456e-01_r8,2.1891e-01_r8, &
     &1.6459e-01_r8,9.1113e-02_r8,4.6587e-01_r8/)
      kao(:, 2, 2, 1) = (/ &
     &2.9826e-02_r8,1.4880e-01_r8,2.2345e-01_r8,2.6474e-01_r8,2.5889e-01_r8,2.2136e-01_r8, &
     &1.6243e-01_r8,9.1934e-02_r8,4.6056e-01_r8/)
      kao(:, 3, 2, 1) = (/ &
     &2.9292e-02_r8,1.4800e-01_r8,2.2058e-01_r8,2.6235e-01_r8,2.5684e-01_r8,2.2295e-01_r8, &
     &1.6276e-01_r8,9.5842e-02_r8,4.5687e-01_r8/)
      kao(:, 4, 2, 1) = (/ &
     &2.8631e-02_r8,1.4795e-01_r8,2.1809e-01_r8,2.5690e-01_r8,2.5387e-01_r8,2.2588e-01_r8, &
     &1.6201e-01_r8,9.9403e-02_r8,4.5029e-01_r8/)
      kao(:, 5, 2, 1) = (/ &
     &2.7916e-02_r8,1.4649e-01_r8,2.1539e-01_r8,2.5025e-01_r8,2.5060e-01_r8,2.2852e-01_r8, &
     &1.6118e-01_r8,1.0330e-01_r8,4.4510e-01_r8/)
      kao(:, 1, 3, 1) = (/ &
     &2.7060e-02_r8,1.3249e-01_r8,1.9563e-01_r8,2.2645e-01_r8,2.1616e-01_r8,1.7969e-01_r8, &
     &1.3284e-01_r8,7.4965e-02_r8,3.7244e-01_r8/)
      kao(:, 2, 3, 1) = (/ &
     &2.6723e-02_r8,1.3208e-01_r8,1.9386e-01_r8,2.2490e-01_r8,2.1534e-01_r8,1.8332e-01_r8, &
     &1.3372e-01_r8,7.6721e-02_r8,3.7364e-01_r8/)
      kao(:, 3, 3, 1) = (/ &
     &2.6384e-02_r8,1.3168e-01_r8,1.9203e-01_r8,2.2240e-01_r8,2.1507e-01_r8,1.8752e-01_r8, &
     &1.3386e-01_r8,7.9482e-02_r8,3.7891e-01_r8/)
      kao(:, 4, 3, 1) = (/ &
     &2.5689e-02_r8,1.3020e-01_r8,1.8980e-01_r8,2.1868e-01_r8,2.1152e-01_r8,1.8912e-01_r8, &
     &1.3349e-01_r8,8.2411e-02_r8,3.7480e-01_r8/)
      kao(:, 5, 3, 1) = (/ &
     &2.4939e-02_r8,1.2901e-01_r8,1.8570e-01_r8,2.1295e-01_r8,2.0942e-01_r8,1.8777e-01_r8, &
     &1.3349e-01_r8,8.5566e-02_r8,3.6973e-01_r8/)
      kao(:, 1, 4, 1) = (/ &
     &2.4242e-02_r8,1.1699e-01_r8,1.6835e-01_r8,1.9257e-01_r8,1.7909e-01_r8,1.4906e-01_r8, &
     &1.0978e-01_r8,6.3298e-02_r8,3.0317e-01_r8/)
      kao(:, 2, 4, 1) = (/ &
     &2.3651e-02_r8,1.1679e-01_r8,1.6721e-01_r8,1.9147e-01_r8,1.7987e-01_r8,1.5405e-01_r8, &
     &1.1069e-01_r8,6.4435e-02_r8,3.0873e-01_r8/)
      kao(:, 3, 4, 1) = (/ &
     &2.2665e-02_r8,1.1583e-01_r8,1.6543e-01_r8,1.8831e-01_r8,1.8066e-01_r8,1.5730e-01_r8, &
     &1.1107e-01_r8,6.6643e-02_r8,3.1154e-01_r8/)
      kao(:, 4, 4, 1) = (/ &
     &2.1814e-02_r8,1.1462e-01_r8,1.6249e-01_r8,1.8491e-01_r8,1.7772e-01_r8,1.5750e-01_r8, &
     &1.1124e-01_r8,6.9078e-02_r8,3.1214e-01_r8/)
      kao(:, 5, 4, 1) = (/ &
     &2.1129e-02_r8,1.1306e-01_r8,1.5907e-01_r8,1.7919e-01_r8,1.7465e-01_r8,1.5650e-01_r8, &
     &1.1133e-01_r8,7.1551e-02_r8,3.0812e-01_r8/)
      kao(:, 1, 5, 1) = (/ &
     &2.0560e-02_r8,1.0249e-01_r8,1.4447e-01_r8,1.6390e-01_r8,1.4827e-01_r8,1.2487e-01_r8, &
     &9.0642e-02_r8,5.3488e-02_r8,2.4754e-01_r8/)
      kao(:, 2, 5, 1) = (/ &
     &1.9799e-02_r8,1.0201e-01_r8,1.4357e-01_r8,1.6295e-01_r8,1.5070e-01_r8,1.2910e-01_r8, &
     &9.1763e-02_r8,5.4394e-02_r8,2.5641e-01_r8/)
      kao(:, 3, 5, 1) = (/ &
     &1.9183e-02_r8,1.0090e-01_r8,1.4151e-01_r8,1.5954e-01_r8,1.5069e-01_r8,1.3095e-01_r8, &
     &9.2718e-02_r8,5.6321e-02_r8,2.5912e-01_r8/)
      kao(:, 4, 5, 1) = (/ &
     &1.8512e-02_r8,9.9552e-02_r8,1.3834e-01_r8,1.5497e-01_r8,1.4881e-01_r8,1.3077e-01_r8, &
     &9.3091e-02_r8,5.8675e-02_r8,2.5974e-01_r8/)
      kao(:, 5, 5, 1) = (/ &
     &1.7786e-02_r8,9.7242e-02_r8,1.3532e-01_r8,1.5076e-01_r8,1.4713e-01_r8,1.3062e-01_r8, &
     &9.3284e-02_r8,6.0479e-02_r8,2.5760e-01_r8/)
      kao(:, 1, 6, 1) = (/ &
     &1.7311e-02_r8,8.8922e-02_r8,1.2346e-01_r8,1.3907e-01_r8,1.2282e-01_r8,1.0362e-01_r8, &
     &7.4353e-02_r8,4.4575e-02_r8,2.0465e-01_r8/)
      kao(:, 2, 6, 1) = (/ &
     &1.6759e-02_r8,8.7881e-02_r8,1.2272e-01_r8,1.3747e-01_r8,1.2636e-01_r8,1.0747e-01_r8, &
     &7.5966e-02_r8,4.6065e-02_r8,2.1117e-01_r8/)
      kao(:, 3, 6, 1) = (/ &
     &1.6118e-02_r8,8.6674e-02_r8,1.1960e-01_r8,1.3378e-01_r8,1.2578e-01_r8,1.0890e-01_r8, &
     &7.7032e-02_r8,4.7370e-02_r8,2.1535e-01_r8/)
      kao(:, 4, 6, 1) = (/ &
     &1.5604e-02_r8,8.5004e-02_r8,1.1715e-01_r8,1.3060e-01_r8,1.2464e-01_r8,1.0936e-01_r8, &
     &7.8068e-02_r8,4.9979e-02_r8,2.1513e-01_r8/)
      kao(:, 5, 6, 1) = (/ &
     &1.5010e-02_r8,8.2612e-02_r8,1.1457e-01_r8,1.2694e-01_r8,1.2379e-01_r8,1.0886e-01_r8, &
     &7.8577e-02_r8,5.1634e-02_r8,2.1475e-01_r8/)
      kao(:, 1, 7, 1) = (/ &
     &1.4769e-02_r8,7.6038e-02_r8,1.0565e-01_r8,1.1761e-01_r8,1.0346e-01_r8,8.6214e-02_r8, &
     &6.1132e-02_r8,3.6999e-02_r8,1.7055e-01_r8/)
      kao(:, 2, 7, 1) = (/ &
     &1.4212e-02_r8,7.5191e-02_r8,1.0412e-01_r8,1.1565e-01_r8,1.0591e-01_r8,8.9750e-02_r8, &
     &6.2857e-02_r8,3.8703e-02_r8,1.7619e-01_r8/)
      kao(:, 3, 7, 1) = (/ &
     &1.3756e-02_r8,7.4145e-02_r8,1.0177e-01_r8,1.1260e-01_r8,1.0586e-01_r8,9.1675e-02_r8, &
     &6.4846e-02_r8,4.0069e-02_r8,1.8020e-01_r8/)
      kao(:, 4, 7, 1) = (/ &
     &1.3258e-02_r8,7.2484e-02_r8,9.9439e-02_r8,1.0966e-01_r8,1.0522e-01_r8,9.2290e-02_r8, &
     &6.5394e-02_r8,4.2345e-02_r8,1.8038e-01_r8/)
      kao(:, 5, 7, 1) = (/ &
     &1.2766e-02_r8,7.0689e-02_r8,9.6896e-02_r8,1.0710e-01_r8,1.0411e-01_r8,9.1721e-02_r8, &
     &6.6375e-02_r8,4.4166e-02_r8,1.8031e-01_r8/)
      kao(:, 1, 8, 1) = (/ &
     &1.2774e-02_r8,6.5331e-02_r8,9.0505e-02_r8,1.0027e-01_r8,8.8579e-02_r8,7.2873e-02_r8, &
     &5.1439e-02_r8,3.0866e-02_r8,1.4484e-01_r8/)
      kao(:, 2, 8, 1) = (/ &
     &1.2386e-02_r8,6.4820e-02_r8,8.9216e-02_r8,9.8573e-02_r8,9.0271e-02_r8,7.6134e-02_r8, &
     &5.3003e-02_r8,3.2488e-02_r8,1.4948e-01_r8/)
      kao(:, 3, 8, 1) = (/ &
     &1.1934e-02_r8,6.3787e-02_r8,8.6950e-02_r8,9.5946e-02_r8,9.0138e-02_r8,7.8085e-02_r8, &
     &5.5347e-02_r8,3.4134e-02_r8,1.5219e-01_r8/)
      kao(:, 4, 8, 1) = (/ &
     &1.1544e-02_r8,6.2588e-02_r8,8.5063e-02_r8,9.3318e-02_r8,8.9759e-02_r8,7.8769e-02_r8, &
     &5.5958e-02_r8,3.6086e-02_r8,1.5324e-01_r8/)
      kao(:, 5, 8, 1) = (/ &
     &1.1084e-02_r8,6.0720e-02_r8,8.2631e-02_r8,9.1723e-02_r8,8.9027e-02_r8,7.8819e-02_r8, &
     &5.6823e-02_r8,3.7768e-02_r8,1.5367e-01_r8/)
      kao(:, 1, 9, 1) = (/ &
     &1.1061e-02_r8,5.5946e-02_r8,7.7372e-02_r8,8.4825e-02_r8,7.4671e-02_r8,6.0881e-02_r8, &
     &4.3320e-02_r8,2.5693e-02_r8,1.2149e-01_r8/)
      kao(:, 2, 9, 1) = (/ &
     &1.0663e-02_r8,5.5517e-02_r8,7.6169e-02_r8,8.3555e-02_r8,7.6380e-02_r8,6.3832e-02_r8, &
     &4.4653e-02_r8,2.7044e-02_r8,1.2592e-01_r8/)
      kao(:, 3, 9, 1) = (/ &
     &1.0298e-02_r8,5.4609e-02_r8,7.4061e-02_r8,8.1380e-02_r8,7.6283e-02_r8,6.5805e-02_r8, &
     &4.6544e-02_r8,2.8652e-02_r8,1.2784e-01_r8/)
      kao(:, 4, 9, 1) = (/ &
     &9.9642e-03_r8,5.3590e-02_r8,7.2457e-02_r8,7.9291e-02_r8,7.6297e-02_r8,6.6701e-02_r8, &
     &4.7215e-02_r8,3.0429e-02_r8,1.2985e-01_r8/)
      kao(:, 5, 9, 1) = (/ &
     &9.5838e-03_r8,5.1774e-02_r8,7.0525e-02_r8,7.7952e-02_r8,7.5761e-02_r8,6.7035e-02_r8, &
     &4.8099e-02_r8,3.1771e-02_r8,1.2981e-01_r8/)
      kao(:, 1,10, 1) = (/ &
     &9.5065e-03_r8,4.7743e-02_r8,6.5906e-02_r8,7.1569e-02_r8,6.3088e-02_r8,5.1008e-02_r8, &
     &3.6270e-02_r8,2.1647e-02_r8,1.0151e-01_r8/)
      kao(:, 2,10, 1) = (/ &
     &9.1696e-03_r8,4.7417e-02_r8,6.4599e-02_r8,7.0371e-02_r8,6.4348e-02_r8,5.3431e-02_r8, &
     &3.7744e-02_r8,2.2620e-02_r8,1.0603e-01_r8/)
      kao(:, 3,10, 1) = (/ &
     &8.8668e-03_r8,4.6740e-02_r8,6.2818e-02_r8,6.8749e-02_r8,6.4307e-02_r8,5.5442e-02_r8, &
     &3.9323e-02_r8,2.3889e-02_r8,1.0716e-01_r8/)
      kao(:, 4,10, 1) = (/ &
     &8.5593e-03_r8,4.5273e-02_r8,6.1475e-02_r8,6.7236e-02_r8,6.4539e-02_r8,5.6295e-02_r8, &
     &4.0023e-02_r8,2.5561e-02_r8,1.0908e-01_r8/)
      kao(:, 5,10, 1) = (/ &
     &8.2765e-03_r8,4.3918e-02_r8,5.9902e-02_r8,6.5936e-02_r8,6.4146e-02_r8,5.6753e-02_r8, &
     &4.0609e-02_r8,2.6739e-02_r8,1.0938e-01_r8/)
      kao(:, 1,11, 1) = (/ &
     &8.0135e-03_r8,4.0574e-02_r8,5.5523e-02_r8,5.9842e-02_r8,5.3590e-02_r8,4.3205e-02_r8, &
     &3.0578e-02_r8,1.8553e-02_r8,8.6419e-02_r8/)
      kao(:, 2,11, 1) = (/ &
     &7.7438e-03_r8,4.0051e-02_r8,5.3954e-02_r8,5.8561e-02_r8,5.4366e-02_r8,4.5533e-02_r8, &
     &3.1980e-02_r8,1.9368e-02_r8,8.9461e-02_r8/)
      kao(:, 3,11, 1) = (/ &
     &7.4839e-03_r8,3.9067e-02_r8,5.2580e-02_r8,5.7160e-02_r8,5.4156e-02_r8,4.6927e-02_r8, &
     &3.3356e-02_r8,2.0535e-02_r8,9.0297e-02_r8/)
      kao(:, 4,11, 1) = (/ &
     &7.2468e-03_r8,3.7809e-02_r8,5.1257e-02_r8,5.6080e-02_r8,5.4294e-02_r8,4.7574e-02_r8, &
     &3.3980e-02_r8,2.1720e-02_r8,9.1828e-02_r8/)
      kao(:, 5,11, 1) = (/ &
     &6.9859e-03_r8,3.6737e-02_r8,5.0287e-02_r8,5.5092e-02_r8,5.3946e-02_r8,4.8082e-02_r8, &
     &3.4738e-02_r8,2.2682e-02_r8,9.1913e-02_r8/)
      kao(:, 1,12, 1) = (/ &
     &6.8723e-03_r8,3.4461e-02_r8,4.6618e-02_r8,5.0325e-02_r8,4.5843e-02_r8,3.7154e-02_r8, &
     &2.6350e-02_r8,1.5945e-02_r8,7.4796e-02_r8/)
      kao(:, 2,12, 1) = (/ &
     &6.6342e-03_r8,3.3814e-02_r8,4.5285e-02_r8,4.9258e-02_r8,4.6140e-02_r8,3.8916e-02_r8, &
     &2.7614e-02_r8,1.6684e-02_r8,7.6431e-02_r8/)
      kao(:, 3,12, 1) = (/ &
     &6.4256e-03_r8,3.2718e-02_r8,4.4302e-02_r8,4.8163e-02_r8,4.5963e-02_r8,4.0038e-02_r8, &
     &2.8672e-02_r8,1.7798e-02_r8,7.6864e-02_r8/)
      kao(:, 4,12, 1) = (/ &
     &6.1980e-03_r8,3.1806e-02_r8,4.3232e-02_r8,4.7321e-02_r8,4.6023e-02_r8,4.0771e-02_r8, &
     &2.9167e-02_r8,1.8567e-02_r8,7.7874e-02_r8/)
      kao(:, 5,12, 1) = (/ &
     &5.9663e-03_r8,3.0964e-02_r8,4.2379e-02_r8,4.6375e-02_r8,4.5692e-02_r8,4.1306e-02_r8, &
     &2.9920e-02_r8,1.9375e-02_r8,7.7903e-02_r8/)
      kao(:, 1,13, 1) = (/ &
     &6.1312e-03_r8,2.9682e-02_r8,3.9975e-02_r8,4.3642e-02_r8,4.0252e-02_r8,3.3035e-02_r8, &
     &2.3558e-02_r8,1.4050e-02_r8,6.6647e-02_r8/)
      kao(:, 2,13, 1) = (/ &
     &5.9440e-03_r8,2.8920e-02_r8,3.8788e-02_r8,4.2829e-02_r8,4.0420e-02_r8,3.4105e-02_r8, &
     &2.4570e-02_r8,1.4699e-02_r8,6.7206e-02_r8/)
      kao(:, 3,13, 1) = (/ &
     &5.7437e-03_r8,2.7994e-02_r8,3.7951e-02_r8,4.1862e-02_r8,4.0303e-02_r8,3.5364e-02_r8, &
     &2.5449e-02_r8,1.5507e-02_r8,6.7644e-02_r8/)
      kao(:, 4,13, 1) = (/ &
     &5.5406e-03_r8,2.7263e-02_r8,3.7056e-02_r8,4.0900e-02_r8,3.9818e-02_r8,3.6193e-02_r8, &
     &2.6077e-02_r8,1.6255e-02_r8,6.7402e-02_r8/)
      kao(:, 5,13, 1) = (/ &
     &5.3457e-03_r8,2.6652e-02_r8,3.6336e-02_r8,3.9995e-02_r8,3.9467e-02_r8,3.6352e-02_r8, &
     &2.6575e-02_r8,1.6998e-02_r8,6.7304e-02_r8/)
      kao(:, 1, 1, 2) = (/ &
     &4.1184e-02_r8,2.7179e-01_r8,3.3427e-01_r8,3.7214e-01_r8,4.0092e-01_r8,3.9640e-01_r8, &
     &3.3752e-01_r8,3.1662e-01_r8,7.0395e-01_r8/)
      kao(:, 2, 1, 2) = (/ &
     &3.9613e-02_r8,2.5448e-01_r8,3.1529e-01_r8,3.6420e-01_r8,3.9285e-01_r8,3.8292e-01_r8, &
     &3.4622e-01_r8,3.3570e-01_r8,7.0351e-01_r8/)
      kao(:, 3, 1, 2) = (/ &
     &3.8482e-02_r8,2.4018e-01_r8,3.0435e-01_r8,3.6080e-01_r8,3.8815e-01_r8,3.7286e-01_r8, &
     &3.5535e-01_r8,3.5400e-01_r8,6.9477e-01_r8/)
      kao(:, 4, 1, 2) = (/ &
     &3.7848e-02_r8,2.2963e-01_r8,2.9537e-01_r8,3.6193e-01_r8,3.8220e-01_r8,3.7308e-01_r8, &
     &3.6939e-01_r8,3.6570e-01_r8,6.8368e-01_r8/)
      kao(:, 5, 1, 2) = (/ &
     &3.7774e-02_r8,2.2394e-01_r8,2.9359e-01_r8,3.5744e-01_r8,3.7874e-01_r8,3.6962e-01_r8, &
     &3.8607e-01_r8,3.7579e-01_r8,6.9280e-01_r8/)
      kao(:, 1, 2, 2) = (/ &
     &3.5631e-02_r8,2.2069e-01_r8,2.7258e-01_r8,3.1550e-01_r8,3.3342e-01_r8,3.2657e-01_r8, &
     &2.8024e-01_r8,2.7588e-01_r8,5.9197e-01_r8/)
      kao(:, 2, 2, 2) = (/ &
     &3.4562e-02_r8,2.0891e-01_r8,2.6384e-01_r8,3.1412e-01_r8,3.2954e-01_r8,3.2211e-01_r8, &
     &2.9490e-01_r8,2.9533e-01_r8,5.8323e-01_r8/)
      kao(:, 3, 2, 2) = (/ &
     &3.3571e-02_r8,1.9802e-01_r8,2.5784e-01_r8,3.1122e-01_r8,3.2677e-01_r8,3.1912e-01_r8, &
     &3.0590e-01_r8,3.0715e-01_r8,5.7853e-01_r8/)
      kao(:, 4, 2, 2) = (/ &
     &3.2736e-02_r8,1.9123e-01_r8,2.5333e-01_r8,3.0890e-01_r8,3.2624e-01_r8,3.1676e-01_r8, &
     &3.1863e-01_r8,3.1850e-01_r8,5.8754e-01_r8/)
      kao(:, 5, 2, 2) = (/ &
     &3.2264e-02_r8,1.8835e-01_r8,2.5452e-01_r8,3.0891e-01_r8,3.2749e-01_r8,3.1271e-01_r8, &
     &3.2651e-01_r8,3.2839e-01_r8,5.9068e-01_r8/)
      kao(:, 1, 3, 2) = (/ &
     &3.1584e-02_r8,1.8152e-01_r8,2.2653e-01_r8,2.6984e-01_r8,2.8266e-01_r8,2.7419e-01_r8, &
     &2.3718e-01_r8,2.3355e-01_r8,4.9551e-01_r8/)
      kao(:, 2, 3, 2) = (/ &
     &3.0265e-02_r8,1.7457e-01_r8,2.2109e-01_r8,2.6703e-01_r8,2.7958e-01_r8,2.7087e-01_r8, &
     &2.4754e-01_r8,2.5014e-01_r8,4.9470e-01_r8/)
      kao(:, 3, 3, 2) = (/ &
     &2.9150e-02_r8,1.6735e-01_r8,2.1902e-01_r8,2.6391e-01_r8,2.7849e-01_r8,2.6534e-01_r8, &
     &2.5781e-01_r8,2.6293e-01_r8,4.9430e-01_r8/)
      kao(:, 4, 3, 2) = (/ &
     &2.8592e-02_r8,1.6364e-01_r8,2.1995e-01_r8,2.6189e-01_r8,2.7866e-01_r8,2.6352e-01_r8, &
     &2.7044e-01_r8,2.7363e-01_r8,4.9527e-01_r8/)
      kao(:, 5, 3, 2) = (/ &
     &2.8231e-02_r8,1.6046e-01_r8,2.1887e-01_r8,2.6443e-01_r8,2.7635e-01_r8,2.6884e-01_r8, &
     &2.7778e-01_r8,2.8066e-01_r8,4.9153e-01_r8/)
      kao(:, 1, 4, 2) = (/ &
     &2.7586e-02_r8,1.5275e-01_r8,1.9293e-01_r8,2.2899e-01_r8,2.4107e-01_r8,2.3244e-01_r8, &
     &2.0047e-01_r8,1.9534e-01_r8,4.2244e-01_r8/)
      kao(:, 2, 4, 2) = (/ &
     &2.6887e-02_r8,1.4829e-01_r8,1.9195e-01_r8,2.2560e-01_r8,2.3907e-01_r8,2.2550e-01_r8, &
     &2.1032e-01_r8,2.1041e-01_r8,4.2198e-01_r8/)
      kao(:, 3, 4, 2) = (/ &
     &2.6805e-02_r8,1.4416e-01_r8,1.9016e-01_r8,2.2531e-01_r8,2.3789e-01_r8,2.2485e-01_r8, &
     &2.1879e-01_r8,2.2259e-01_r8,4.1901e-01_r8/)
      kao(:, 4, 4, 2) = (/ &
     &2.6734e-02_r8,1.4087e-01_r8,1.9109e-01_r8,2.2675e-01_r8,2.3622e-01_r8,2.2628e-01_r8, &
     &2.2901e-01_r8,2.3158e-01_r8,4.1030e-01_r8/)
      kao(:, 5, 4, 2) = (/ &
     &2.6617e-02_r8,1.3796e-01_r8,1.9377e-01_r8,2.2557e-01_r8,2.3342e-01_r8,2.2649e-01_r8, &
     &2.3523e-01_r8,2.3617e-01_r8,4.1160e-01_r8/)
      kao(:, 1, 5, 2) = (/ &
     &2.5332e-02_r8,1.2963e-01_r8,1.6655e-01_r8,1.9042e-01_r8,2.0895e-01_r8,1.9510e-01_r8, &
     &1.6916e-01_r8,1.6222e-01_r8,3.6316e-01_r8/)
      kao(:, 2, 5, 2) = (/ &
     &2.5181e-02_r8,1.2537e-01_r8,1.6592e-01_r8,1.8998e-01_r8,2.0621e-01_r8,1.9136e-01_r8, &
     &1.7764e-01_r8,1.7625e-01_r8,3.5695e-01_r8/)
      kao(:, 3, 5, 2) = (/ &
     &2.4972e-02_r8,1.2219e-01_r8,1.6618e-01_r8,1.9129e-01_r8,2.0217e-01_r8,1.9130e-01_r8, &
     &1.8535e-01_r8,1.8719e-01_r8,3.4788e-01_r8/)
      kao(:, 4, 5, 2) = (/ &
     &2.4749e-02_r8,1.2096e-01_r8,1.6848e-01_r8,1.9087e-01_r8,1.9911e-01_r8,1.9130e-01_r8, &
     &1.9341e-01_r8,1.9372e-01_r8,3.4412e-01_r8/)
      kao(:, 5, 5, 2) = (/ &
     &2.4660e-02_r8,1.2126e-01_r8,1.7164e-01_r8,1.8946e-01_r8,1.9462e-01_r8,1.9216e-01_r8, &
     &1.9926e-01_r8,1.9935e-01_r8,3.3902e-01_r8/)
      kao(:, 1, 6, 2) = (/ &
     &2.3422e-02_r8,1.0907e-01_r8,1.4314e-01_r8,1.6055e-01_r8,1.7919e-01_r8,1.6497e-01_r8, &
     &1.4423e-01_r8,1.3518e-01_r8,3.0537e-01_r8/)
      kao(:, 2, 6, 2) = (/ &
     &2.3193e-02_r8,1.0714e-01_r8,1.4280e-01_r8,1.6151e-01_r8,1.7408e-01_r8,1.6236e-01_r8, &
     &1.4991e-01_r8,1.4676e-01_r8,2.9795e-01_r8/)
      kao(:, 3, 6, 2) = (/ &
     &2.2992e-02_r8,1.0582e-01_r8,1.4541e-01_r8,1.6228e-01_r8,1.7059e-01_r8,1.6204e-01_r8, &
     &1.5617e-01_r8,1.5704e-01_r8,2.9013e-01_r8/)
      kao(:, 4, 6, 2) = (/ &
     &2.2904e-02_r8,1.0595e-01_r8,1.4661e-01_r8,1.6015e-01_r8,1.6718e-01_r8,1.6268e-01_r8, &
     &1.6254e-01_r8,1.6133e-01_r8,2.8558e-01_r8/)
      kao(:, 5, 6, 2) = (/ &
     &2.3037e-02_r8,1.0659e-01_r8,1.4720e-01_r8,1.5884e-01_r8,1.6394e-01_r8,1.6537e-01_r8, &
     &1.6790e-01_r8,1.6640e-01_r8,2.8291e-01_r8/)
      kao(:, 1, 7, 2) = (/ &
     &2.1778e-02_r8,9.4871e-02_r8,1.2415e-01_r8,1.3737e-01_r8,1.5258e-01_r8,1.4160e-01_r8, &
     &1.2347e-01_r8,1.1302e-01_r8,2.5408e-01_r8/)
      kao(:, 2, 7, 2) = (/ &
     &2.1522e-02_r8,9.3423e-02_r8,1.2417e-01_r8,1.3839e-01_r8,1.4741e-01_r8,1.4006e-01_r8, &
     &1.2799e-01_r8,1.2268e-01_r8,2.4943e-01_r8/)
      kao(:, 3, 7, 2) = (/ &
     &2.1257e-02_r8,9.3282e-02_r8,1.2533e-01_r8,1.3843e-01_r8,1.4474e-01_r8,1.3911e-01_r8, &
     &1.3239e-01_r8,1.3095e-01_r8,2.4208e-01_r8/)
      kao(:, 4, 7, 2) = (/ &
     &2.0841e-02_r8,9.3161e-02_r8,1.2672e-01_r8,1.3698e-01_r8,1.4106e-01_r8,1.4019e-01_r8, &
     &1.3855e-01_r8,1.3550e-01_r8,2.3874e-01_r8/)
      kao(:, 5, 7, 2) = (/ &
     &2.0486e-02_r8,9.4079e-02_r8,1.2713e-01_r8,1.3508e-01_r8,1.3852e-01_r8,1.4171e-01_r8, &
     &1.4291e-01_r8,1.3980e-01_r8,2.3641e-01_r8/)
      kao(:, 1, 8, 2) = (/ &
     &2.0219e-02_r8,8.3245e-02_r8,1.0821e-01_r8,1.1854e-01_r8,1.3123e-01_r8,1.2323e-01_r8, &
     &1.0617e-01_r8,9.4794e-02_r8,2.1425e-01_r8/)
      kao(:, 2, 8, 2) = (/ &
     &1.9540e-02_r8,8.2217e-02_r8,1.0811e-01_r8,1.1985e-01_r8,1.2621e-01_r8,1.2208e-01_r8, &
     &1.0997e-01_r8,1.0316e-01_r8,2.0956e-01_r8/)
      kao(:, 3, 8, 2) = (/ &
     &1.9115e-02_r8,8.1811e-02_r8,1.0961e-01_r8,1.1959e-01_r8,1.2388e-01_r8,1.2129e-01_r8, &
     &1.1337e-01_r8,1.1053e-01_r8,2.0624e-01_r8/)
      kao(:, 4, 8, 2) = (/ &
     &1.8733e-02_r8,8.1851e-02_r8,1.1044e-01_r8,1.1828e-01_r8,1.2090e-01_r8,1.2160e-01_r8, &
     &1.1850e-01_r8,1.1463e-01_r8,2.0160e-01_r8/)
      kao(:, 5, 8, 2) = (/ &
     &1.8489e-02_r8,8.3310e-02_r8,1.0940e-01_r8,1.1607e-01_r8,1.1923e-01_r8,1.2205e-01_r8, &
     &1.2223e-01_r8,1.1845e-01_r8,2.0014e-01_r8/)
      kao(:, 1, 9, 2) = (/ &
     &1.7934e-02_r8,7.2499e-02_r8,9.3347e-02_r8,1.0259e-01_r8,1.1263e-01_r8,1.0693e-01_r8, &
     &9.0284e-02_r8,7.9546e-02_r8,1.8180e-01_r8/)
      kao(:, 2, 9, 2) = (/ &
     &1.7445e-02_r8,7.1879e-02_r8,9.3312e-02_r8,1.0334e-01_r8,1.0867e-01_r8,1.0654e-01_r8, &
     &9.3871e-02_r8,8.7011e-02_r8,1.7650e-01_r8/)
      kao(:, 3, 9, 2) = (/ &
     &1.7054e-02_r8,7.1164e-02_r8,9.4558e-02_r8,1.0223e-01_r8,1.0632e-01_r8,1.0559e-01_r8, &
     &9.7124e-02_r8,9.3354e-02_r8,1.7444e-01_r8/)
      kao(:, 4, 9, 2) = (/ &
     &1.6642e-02_r8,7.2006e-02_r8,9.4764e-02_r8,1.0087e-01_r8,1.0340e-01_r8,1.0507e-01_r8, &
     &1.0155e-01_r8,9.7191e-02_r8,1.7012e-01_r8/)
      kao(:, 5, 9, 2) = (/ &
     &1.6243e-02_r8,7.2866e-02_r8,9.2285e-02_r8,9.9097e-02_r8,1.0185e-01_r8,1.0516e-01_r8, &
     &1.0490e-01_r8,1.0097e-01_r8,1.7041e-01_r8/)
      kao(:, 1,10, 2) = (/ &
     &1.5979e-02_r8,6.3035e-02_r8,8.0318e-02_r8,8.8320e-02_r8,9.6214e-02_r8,9.2269e-02_r8, &
     &7.7109e-02_r8,6.7263e-02_r8,1.5451e-01_r8/)
      kao(:, 2,10, 2) = (/ &
     &1.5470e-02_r8,6.2313e-02_r8,8.0559e-02_r8,8.8699e-02_r8,9.3120e-02_r8,9.2382e-02_r8, &
     &7.9788e-02_r8,7.3810e-02_r8,1.5001e-01_r8/)
      kao(:, 3,10, 2) = (/ &
     &1.4968e-02_r8,6.2321e-02_r8,8.1515e-02_r8,8.7265e-02_r8,9.0898e-02_r8,9.1273e-02_r8, &
     &8.3098e-02_r8,7.9462e-02_r8,1.4837e-01_r8/)
      kao(:, 4,10, 2) = (/ &
     &1.4648e-02_r8,6.3201e-02_r8,8.0459e-02_r8,8.6353e-02_r8,8.8769e-02_r8,9.0582e-02_r8, &
     &8.6861e-02_r8,8.2886e-02_r8,1.4494e-01_r8/)
      kao(:, 5,10, 2) = (/ &
     &1.4327e-02_r8,6.4058e-02_r8,7.8092e-02_r8,8.4556e-02_r8,8.7537e-02_r8,9.0662e-02_r8, &
     &8.9892e-02_r8,8.5887e-02_r8,1.4505e-01_r8/)
      kao(:, 1,11, 2) = (/ &
     &1.3861e-02_r8,5.4196e-02_r8,6.8747e-02_r8,7.5984e-02_r8,8.0767e-02_r8,7.9801e-02_r8, &
     &6.6830e-02_r8,5.9302e-02_r8,1.2963e-01_r8/)
      kao(:, 2,11, 2) = (/ &
     &1.3347e-02_r8,5.4113e-02_r8,6.9722e-02_r8,7.5263e-02_r8,7.8466e-02_r8,7.8575e-02_r8, &
     &6.9140e-02_r8,6.4556e-02_r8,1.2675e-01_r8/)
      kao(:, 3,11, 2) = (/ &
     &1.3016e-02_r8,5.4555e-02_r8,6.9179e-02_r8,7.4613e-02_r8,7.7291e-02_r8,7.7531e-02_r8, &
     &7.2200e-02_r8,6.9022e-02_r8,1.2482e-01_r8/)
      kao(:, 4,11, 2) = (/ &
     &1.2671e-02_r8,5.5408e-02_r8,6.7230e-02_r8,7.3198e-02_r8,7.5526e-02_r8,7.7122e-02_r8, &
     &7.5177e-02_r8,7.1296e-02_r8,1.2336e-01_r8/)
      kao(:, 5,11, 2) = (/ &
     &1.2351e-02_r8,5.6031e-02_r8,6.5093e-02_r8,7.1581e-02_r8,7.4883e-02_r8,7.6822e-02_r8, &
     &7.7284e-02_r8,7.3771e-02_r8,1.2246e-01_r8/)
      kao(:, 1,12, 2) = (/ &
     &1.2126e-02_r8,4.7285e-02_r8,5.9933e-02_r8,6.5129e-02_r8,6.8290e-02_r8,6.7884e-02_r8, &
     &5.7878e-02_r8,5.1782e-02_r8,1.0839e-01_r8/)
      kao(:, 2,12, 2) = (/ &
     &1.1745e-02_r8,4.7398e-02_r8,5.9988e-02_r8,6.4477e-02_r8,6.6821e-02_r8,6.6892e-02_r8, &
     &6.0270e-02_r8,5.6137e-02_r8,1.0621e-01_r8/)
      kao(:, 3,12, 2) = (/ &
     &1.1385e-02_r8,4.8238e-02_r8,5.8218e-02_r8,6.3614e-02_r8,6.5819e-02_r8,6.5904e-02_r8, &
     &6.2567e-02_r8,5.9036e-02_r8,1.0557e-01_r8/)
      kao(:, 4,12, 2) = (/ &
     &1.1087e-02_r8,4.8582e-02_r8,5.6782e-02_r8,6.2244e-02_r8,6.4582e-02_r8,6.5133e-02_r8, &
     &6.4669e-02_r8,6.1446e-02_r8,1.0435e-01_r8/)
      kao(:, 5,12, 2) = (/ &
     &1.0909e-02_r8,4.7898e-02_r8,5.5031e-02_r8,6.0882e-02_r8,6.4057e-02_r8,6.5202e-02_r8, &
     &6.6350e-02_r8,6.3114e-02_r8,1.0415e-01_r8/)
      kao(:, 1,13, 2) = (/ &
     &1.1050e-02_r8,4.2216e-02_r8,5.3216e-02_r8,5.6607e-02_r8,5.8614e-02_r8,5.8762e-02_r8, &
     &5.1111e-02_r8,4.5278e-02_r8,9.1112e-02_r8/)
      kao(:, 2,13, 2) = (/ &
     &1.0650e-02_r8,4.2640e-02_r8,5.2374e-02_r8,5.5676e-02_r8,5.7428e-02_r8,5.7903e-02_r8, &
     &5.3022e-02_r8,4.8756e-02_r8,9.0299e-02_r8/)
      kao(:, 3,13, 2) = (/ &
     &1.0375e-02_r8,4.2997e-02_r8,5.0849e-02_r8,5.4963e-02_r8,5.6516e-02_r8,5.6613e-02_r8, &
     &5.4398e-02_r8,5.1351e-02_r8,8.9757e-02_r8/)
      kao(:, 4,13, 2) = (/ &
     &1.0186e-02_r8,4.2550e-02_r8,4.9650e-02_r8,5.4126e-02_r8,5.6087e-02_r8,5.6100e-02_r8, &
     &5.5740e-02_r8,5.3111e-02_r8,8.9898e-02_r8/)
      kao(:, 5,13, 2) = (/ &
     &9.9803e-03_r8,4.1596e-02_r8,4.8435e-02_r8,5.3214e-02_r8,5.5733e-02_r8,5.6166e-02_r8, &
     &5.6820e-02_r8,5.4773e-02_r8,8.9718e-02_r8/)
      kao(:, 1, 1, 3) = (/ &
     &1.0349e-01_r8,2.2333e-01_r8,4.3448e-01_r8,4.7188e-01_r8,4.9049e-01_r8,5.6379e-01_r8, &
     &6.8188e-01_r8,5.5213e-01_r8,8.7331e-01_r8/)
      kao(:, 2, 1, 3) = (/ &
     &9.8776e-02_r8,2.3587e-01_r8,4.2090e-01_r8,4.7099e-01_r8,4.8532e-01_r8,5.6756e-01_r8, &
     &6.8304e-01_r8,5.3972e-01_r8,8.6585e-01_r8/)
      kao(:, 3, 1, 3) = (/ &
     &9.4379e-02_r8,2.4459e-01_r8,4.0703e-01_r8,4.4771e-01_r8,4.8054e-01_r8,5.8051e-01_r8, &
     &6.8126e-01_r8,5.2715e-01_r8,8.6189e-01_r8/)
      kao(:, 4, 1, 3) = (/ &
     &8.9966e-02_r8,2.4911e-01_r8,4.0891e-01_r8,4.3132e-01_r8,4.8073e-01_r8,5.8214e-01_r8, &
     &6.7058e-01_r8,5.2176e-01_r8,8.6463e-01_r8/)
      kao(:, 5, 1, 3) = (/ &
     &8.6080e-02_r8,2.4561e-01_r8,4.0823e-01_r8,4.3495e-01_r8,4.8341e-01_r8,5.8583e-01_r8, &
     &6.6494e-01_r8,5.1295e-01_r8,8.6781e-01_r8/)
      kao(:, 1, 2, 3) = (/ &
     &9.1121e-02_r8,2.7597e-01_r8,3.6090e-01_r8,3.8864e-01_r8,4.2468e-01_r8,5.0778e-01_r8, &
     &6.0614e-01_r8,4.7263e-01_r8,7.5147e-01_r8/)
      kao(:, 2, 2, 3) = (/ &
     &8.6968e-02_r8,2.8112e-01_r8,3.5384e-01_r8,3.7604e-01_r8,4.2522e-01_r8,5.1397e-01_r8, &
     &5.9893e-01_r8,4.6387e-01_r8,7.5402e-01_r8/)
      kao(:, 3, 2, 3) = (/ &
     &8.3177e-02_r8,2.8458e-01_r8,3.4657e-01_r8,3.6832e-01_r8,4.2349e-01_r8,5.1886e-01_r8, &
     &5.9537e-01_r8,4.5576e-01_r8,7.6481e-01_r8/)
      kao(:, 4, 2, 3) = (/ &
     &7.9593e-02_r8,2.8362e-01_r8,3.4405e-01_r8,3.6602e-01_r8,4.2737e-01_r8,5.2263e-01_r8, &
     &5.9169e-01_r8,4.4715e-01_r8,7.7154e-01_r8/)
      kao(:, 5, 2, 3) = (/ &
     &7.6305e-02_r8,2.7901e-01_r8,3.3923e-01_r8,3.6563e-01_r8,4.2905e-01_r8,5.2631e-01_r8, &
     &5.9188e-01_r8,4.4184e-01_r8,7.8075e-01_r8/)
      kao(:, 1, 3, 3) = (/ &
     &8.1532e-02_r8,2.6557e-01_r8,3.0691e-01_r8,3.2639e-01_r8,3.6998e-01_r8,4.4624e-01_r8, &
     &5.2995e-01_r8,4.1015e-01_r8,6.5448e-01_r8/)
      kao(:, 2, 3, 3) = (/ &
     &7.8061e-02_r8,2.5705e-01_r8,3.0144e-01_r8,3.1922e-01_r8,3.7157e-01_r8,4.5007e-01_r8, &
     &5.2671e-01_r8,4.0238e-01_r8,6.6049e-01_r8/)
      kao(:, 3, 3, 3) = (/ &
     &7.4871e-02_r8,2.4964e-01_r8,2.9703e-01_r8,3.1658e-01_r8,3.7272e-01_r8,4.5628e-01_r8, &
     &5.2424e-01_r8,3.9540e-01_r8,6.6589e-01_r8/)
      kao(:, 4, 3, 3) = (/ &
     &7.1934e-02_r8,2.4252e-01_r8,2.8855e-01_r8,3.1667e-01_r8,3.7723e-01_r8,4.6275e-01_r8, &
     &5.1485e-01_r8,3.8931e-01_r8,6.7492e-01_r8/)
      kao(:, 5, 3, 3) = (/ &
     &6.9067e-02_r8,2.3451e-01_r8,2.8461e-01_r8,3.1625e-01_r8,3.8425e-01_r8,4.6414e-01_r8, &
     &5.0872e-01_r8,3.8671e-01_r8,6.9966e-01_r8/)
      kao(:, 1, 4, 3) = (/ &
     &7.4166e-02_r8,2.1898e-01_r8,2.6310e-01_r8,2.7673e-01_r8,3.2117e-01_r8,3.8906e-01_r8, &
     &4.5677e-01_r8,3.5535e-01_r8,5.6605e-01_r8/)
      kao(:, 2, 4, 3) = (/ &
     &7.1027e-02_r8,2.1158e-01_r8,2.5634e-01_r8,2.7577e-01_r8,3.2463e-01_r8,3.9708e-01_r8, &
     &4.5460e-01_r8,3.5060e-01_r8,5.7431e-01_r8/)
      kao(:, 3, 4, 3) = (/ &
     &6.8100e-02_r8,2.0832e-01_r8,2.5127e-01_r8,2.7640e-01_r8,3.2722e-01_r8,4.0091e-01_r8, &
     &4.5112e-01_r8,3.4506e-01_r8,5.8564e-01_r8/)
      kao(:, 4, 4, 3) = (/ &
     &6.5366e-02_r8,2.0407e-01_r8,2.4599e-01_r8,2.7530e-01_r8,3.3554e-01_r8,4.0555e-01_r8, &
     &4.3614e-01_r8,3.4106e-01_r8,6.0722e-01_r8/)
      kao(:, 5, 4, 3) = (/ &
     &6.2828e-02_r8,2.0183e-01_r8,2.4016e-01_r8,2.8032e-01_r8,3.4415e-01_r8,4.1256e-01_r8, &
     &4.2811e-01_r8,3.3888e-01_r8,6.2274e-01_r8/)
      kao(:, 1, 5, 3) = (/ &
     &6.8085e-02_r8,1.8443e-01_r8,2.2193e-01_r8,2.4125e-01_r8,2.7858e-01_r8,3.3878e-01_r8, &
     &3.9224e-01_r8,3.0775e-01_r8,4.8825e-01_r8/)
      kao(:, 2, 5, 3) = (/ &
     &6.5024e-02_r8,1.8062e-01_r8,2.1594e-01_r8,2.3959e-01_r8,2.8255e-01_r8,3.4709e-01_r8, &
     &3.8693e-01_r8,3.0387e-01_r8,4.9773e-01_r8/)
      kao(:, 3, 5, 3) = (/ &
     &6.2309e-02_r8,1.7709e-01_r8,2.1233e-01_r8,2.4099e-01_r8,2.9052e-01_r8,3.5084e-01_r8, &
     &3.7550e-01_r8,2.9937e-01_r8,5.1983e-01_r8/)
      kao(:, 4, 5, 3) = (/ &
     &6.0049e-02_r8,1.7340e-01_r8,2.0891e-01_r8,2.4567e-01_r8,2.9963e-01_r8,3.5573e-01_r8, &
     &3.6423e-01_r8,2.9642e-01_r8,5.3792e-01_r8/)
      kao(:, 5, 5, 3) = (/ &
     &5.7860e-02_r8,1.7101e-01_r8,2.0517e-01_r8,2.5155e-01_r8,3.0986e-01_r8,3.5542e-01_r8, &
     &3.5482e-01_r8,2.9214e-01_r8,5.5424e-01_r8/)
      kao(:, 1, 6, 3) = (/ &
     &6.1553e-02_r8,1.6486e-01_r8,1.8851e-01_r8,2.1013e-01_r8,2.4069e-01_r8,2.9423e-01_r8, &
     &3.2998e-01_r8,2.6499e-01_r8,4.1520e-01_r8/)
      kao(:, 2, 6, 3) = (/ &
     &5.8962e-02_r8,1.6161e-01_r8,1.8469e-01_r8,2.1043e-01_r8,2.4572e-01_r8,3.0023e-01_r8, &
     &3.2384e-01_r8,2.6279e-01_r8,4.2954e-01_r8/)
      kao(:, 3, 6, 3) = (/ &
     &5.6865e-02_r8,1.5845e-01_r8,1.8137e-01_r8,2.1320e-01_r8,2.5567e-01_r8,3.0422e-01_r8, &
     &3.1399e-01_r8,2.5823e-01_r8,4.4811e-01_r8/)
      kao(:, 4, 6, 3) = (/ &
     &5.4727e-02_r8,1.5470e-01_r8,1.8033e-01_r8,2.2018e-01_r8,2.6466e-01_r8,3.0350e-01_r8, &
     &3.0450e-01_r8,2.5479e-01_r8,4.6359e-01_r8/)
      kao(:, 5, 6, 3) = (/ &
     &5.2654e-02_r8,1.5114e-01_r8,1.8009e-01_r8,2.2727e-01_r8,2.7074e-01_r8,3.0288e-01_r8, &
     &2.9697e-01_r8,2.5146e-01_r8,4.7630e-01_r8/)
      kao(:, 1, 7, 3) = (/ &
     &5.4386e-02_r8,1.4374e-01_r8,1.6223e-01_r8,1.8219e-01_r8,2.0984e-01_r8,2.5288e-01_r8, &
     &2.7777e-01_r8,2.2929e-01_r8,3.5662e-01_r8/)
      kao(:, 2, 7, 3) = (/ &
     &5.2357e-02_r8,1.4042e-01_r8,1.5995e-01_r8,1.8335e-01_r8,2.1810e-01_r8,2.5710e-01_r8, &
     &2.7180e-01_r8,2.2723e-01_r8,3.7033e-01_r8/)
      kao(:, 3, 7, 3) = (/ &
     &5.0433e-02_r8,1.3664e-01_r8,1.5916e-01_r8,1.8872e-01_r8,2.2495e-01_r8,2.5913e-01_r8, &
     &2.6518e-01_r8,2.2296e-01_r8,3.8796e-01_r8/)
      kao(:, 4, 7, 3) = (/ &
     &4.8970e-02_r8,1.3435e-01_r8,1.5882e-01_r8,1.9514e-01_r8,2.3146e-01_r8,2.5861e-01_r8, &
     &2.5643e-01_r8,2.1963e-01_r8,4.0045e-01_r8/)
      kao(:, 5, 7, 3) = (/ &
     &4.7677e-02_r8,1.3141e-01_r8,1.5996e-01_r8,2.0198e-01_r8,2.3377e-01_r8,2.5698e-01_r8, &
     &2.5063e-01_r8,2.1548e-01_r8,4.0471e-01_r8/)
      kao(:, 1, 8, 3) = (/ &
     &4.9561e-02_r8,1.2585e-01_r8,1.4205e-01_r8,1.6041e-01_r8,1.8455e-01_r8,2.1813e-01_r8, &
     &2.3719e-01_r8,1.9955e-01_r8,3.0456e-01_r8/)
      kao(:, 2, 8, 3) = (/ &
     &4.7879e-02_r8,1.2232e-01_r8,1.4089e-01_r8,1.6222e-01_r8,1.9194e-01_r8,2.2092e-01_r8, &
     &2.3163e-01_r8,1.9730e-01_r8,3.1885e-01_r8/)
      kao(:, 3, 8, 3) = (/ &
     &4.6426e-02_r8,1.1957e-01_r8,1.4043e-01_r8,1.6717e-01_r8,1.9752e-01_r8,2.2121e-01_r8, &
     &2.2638e-01_r8,1.9261e-01_r8,3.3187e-01_r8/)
      kao(:, 4, 8, 3) = (/ &
     &4.5268e-02_r8,1.1738e-01_r8,1.4149e-01_r8,1.7294e-01_r8,2.0208e-01_r8,2.2061e-01_r8, &
     &2.1864e-01_r8,1.8926e-01_r8,3.4074e-01_r8/)
      kao(:, 5, 8, 3) = (/ &
     &4.3956e-02_r8,1.1566e-01_r8,1.4446e-01_r8,1.7951e-01_r8,2.0361e-01_r8,2.1938e-01_r8, &
     &2.1462e-01_r8,1.8542e-01_r8,3.4583e-01_r8/)
      kao(:, 1, 9, 3) = (/ &
     &4.5250e-02_r8,1.0911e-01_r8,1.2308e-01_r8,1.4028e-01_r8,1.6172e-01_r8,1.8816e-01_r8, &
     &2.0368e-01_r8,1.7299e-01_r8,2.5859e-01_r8/)
      kao(:, 2, 9, 3) = (/ &
     &4.3924e-02_r8,1.0618e-01_r8,1.2262e-01_r8,1.4258e-01_r8,1.6714e-01_r8,1.8918e-01_r8, &
     &1.9807e-01_r8,1.7073e-01_r8,2.7235e-01_r8/)
      kao(:, 3, 9, 3) = (/ &
     &4.2608e-02_r8,1.0467e-01_r8,1.2300e-01_r8,1.4745e-01_r8,1.7253e-01_r8,1.8886e-01_r8, &
     &1.9316e-01_r8,1.6589e-01_r8,2.8262e-01_r8/)
      kao(:, 4, 9, 3) = (/ &
     &4.1423e-02_r8,1.0229e-01_r8,1.2419e-01_r8,1.5295e-01_r8,1.7546e-01_r8,1.8853e-01_r8, &
     &1.8673e-01_r8,1.6267e-01_r8,2.8816e-01_r8/)
      kao(:, 5, 9, 3) = (/ &
     &4.0021e-02_r8,1.0144e-01_r8,1.2853e-01_r8,1.5736e-01_r8,1.7632e-01_r8,1.8748e-01_r8, &
     &1.8330e-01_r8,1.5887e-01_r8,2.9011e-01_r8/)
      kao(:, 1,10, 3) = (/ &
     &4.1171e-02_r8,9.3658e-02_r8,1.0622e-01_r8,1.2188e-01_r8,1.4076e-01_r8,1.6261e-01_r8, &
     &1.7423e-01_r8,1.4922e-01_r8,2.1862e-01_r8/)
      kao(:, 2,10, 3) = (/ &
     &3.9662e-02_r8,9.1742e-02_r8,1.0641e-01_r8,1.2434e-01_r8,1.4583e-01_r8,1.6228e-01_r8, &
     &1.6976e-01_r8,1.4678e-01_r8,2.3073e-01_r8/)
      kao(:, 3,10, 3) = (/ &
     &3.8151e-02_r8,8.9581e-02_r8,1.0765e-01_r8,1.2937e-01_r8,1.4971e-01_r8,1.6177e-01_r8, &
     &1.6479e-01_r8,1.4256e-01_r8,2.3771e-01_r8/)
      kao(:, 4,10, 3) = (/ &
     &3.6829e-02_r8,8.8190e-02_r8,1.0980e-01_r8,1.3385e-01_r8,1.5088e-01_r8,1.6121e-01_r8, &
     &1.5970e-01_r8,1.3919e-01_r8,2.4389e-01_r8/)
      kao(:, 5,10, 3) = (/ &
     &3.5799e-02_r8,8.7081e-02_r8,1.1397e-01_r8,1.3613e-01_r8,1.5068e-01_r8,1.6032e-01_r8, &
     &1.5668e-01_r8,1.3612e-01_r8,2.4347e-01_r8/)
      kao(:, 1,11, 3) = (/ &
     &3.5950e-02_r8,7.9375e-02_r8,9.2025e-02_r8,1.0686e-01_r8,1.2416e-01_r8,1.3928e-01_r8, &
     &1.4761e-01_r8,1.2730e-01_r8,1.9139e-01_r8/)
      kao(:, 2,11, 3) = (/ &
     &3.4807e-02_r8,7.7447e-02_r8,9.2655e-02_r8,1.1006e-01_r8,1.2736e-01_r8,1.3892e-01_r8, &
     &1.4381e-01_r8,1.2426e-01_r8,1.9723e-01_r8/)
      kao(:, 3,11, 3) = (/ &
     &3.3668e-02_r8,7.6215e-02_r8,9.4748e-02_r8,1.1430e-01_r8,1.2842e-01_r8,1.3852e-01_r8, &
     &1.3892e-01_r8,1.2007e-01_r8,2.0316e-01_r8/)
      kao(:, 4,11, 3) = (/ &
     &3.2675e-02_r8,7.5405e-02_r8,9.7335e-02_r8,1.1502e-01_r8,1.2820e-01_r8,1.3796e-01_r8, &
     &1.3569e-01_r8,1.1793e-01_r8,2.0391e-01_r8/)
      kao(:, 5,11, 3) = (/ &
     &3.1803e-02_r8,7.5385e-02_r8,1.0078e-01_r8,1.1505e-01_r8,1.2792e-01_r8,1.3782e-01_r8, &
     &1.3291e-01_r8,1.1573e-01_r8,2.0592e-01_r8/)
      kao(:, 1,12, 3) = (/ &
     &3.2107e-02_r8,6.7817e-02_r8,8.0190e-02_r8,9.4418e-02_r8,1.0883e-01_r8,1.2016e-01_r8, &
     &1.2478e-01_r8,1.0916e-01_r8,1.6437e-01_r8/)
      kao(:, 2,12, 3) = (/ &
     &3.0865e-02_r8,6.6495e-02_r8,8.1339e-02_r8,9.7570e-02_r8,1.0958e-01_r8,1.1971e-01_r8, &
     &1.2159e-01_r8,1.0575e-01_r8,1.6979e-01_r8/)
      kao(:, 3,12, 3) = (/ &
     &2.9814e-02_r8,6.5982e-02_r8,8.4322e-02_r8,9.8160e-02_r8,1.0983e-01_r8,1.1899e-01_r8, &
     &1.1775e-01_r8,1.0260e-01_r8,1.7251e-01_r8/)
      kao(:, 4,12, 3) = (/ &
     &2.8719e-02_r8,6.6210e-02_r8,8.5962e-02_r8,9.8372e-02_r8,1.0963e-01_r8,1.1883e-01_r8, &
     &1.1590e-01_r8,1.0037e-01_r8,1.7377e-01_r8/)
      kao(:, 5,12, 3) = (/ &
     &2.7641e-02_r8,6.7001e-02_r8,8.6676e-02_r8,9.9268e-02_r8,1.1059e-01_r8,1.1880e-01_r8, &
     &1.1301e-01_r8,9.8900e-02_r8,1.7602e-01_r8/)
      kao(:, 1,13, 3) = (/ &
     &2.9283e-02_r8,6.0178e-02_r8,7.1238e-02_r8,8.4877e-02_r8,9.5368e-02_r8,1.0416e-01_r8, &
     &1.0619e-01_r8,9.4038e-02_r8,1.4273e-01_r8/)
      kao(:, 2,13, 3) = (/ &
     &2.8137e-02_r8,5.9367e-02_r8,7.3469e-02_r8,8.5617e-02_r8,9.5728e-02_r8,1.0364e-01_r8, &
     &1.0343e-01_r8,9.0972e-02_r8,1.4741e-01_r8/)
      kao(:, 3,13, 3) = (/ &
     &2.7056e-02_r8,5.9346e-02_r8,7.4992e-02_r8,8.5630e-02_r8,9.5820e-02_r8,1.0325e-01_r8, &
     &1.0105e-01_r8,8.7823e-02_r8,1.4877e-01_r8/)
      kao(:, 4,13, 3) = (/ &
     &2.6017e-02_r8,6.0117e-02_r8,7.5313e-02_r8,8.5867e-02_r8,9.6184e-02_r8,1.0321e-01_r8, &
     &9.9567e-02_r8,8.6122e-02_r8,1.5028e-01_r8/)
      kao(:, 5,13, 3) = (/ &
     &2.5188e-02_r8,6.1586e-02_r8,7.5405e-02_r8,8.7449e-02_r8,9.7275e-02_r8,1.0347e-01_r8, &
     &9.7619e-02_r8,8.4749e-02_r8,1.5271e-01_r8/)
      kao(:, 1, 1, 4) = (/ &
     &2.0140e-01_r8,2.2296e-01_r8,3.8441e-01_r8,7.9237e-01_r8,8.6626e-01_r8,8.2263e-01_r8, &
     &7.4305e-01_r8,7.5768e-01_r8,1.5145e+00_r8/)
      kao(:, 2, 1, 4) = (/ &
     &1.9181e-01_r8,2.1723e-01_r8,4.1174e-01_r8,7.7988e-01_r8,8.4188e-01_r8,7.8979e-01_r8, &
     &7.0362e-01_r8,7.1757e-01_r8,1.4753e+00_r8/)
      kao(:, 3, 1, 4) = (/ &
     &1.8358e-01_r8,2.1296e-01_r8,4.3167e-01_r8,7.6375e-01_r8,8.2127e-01_r8,7.5942e-01_r8, &
     &6.7535e-01_r8,6.8460e-01_r8,1.4372e+00_r8/)
      kao(:, 4, 1, 4) = (/ &
     &1.7731e-01_r8,2.0956e-01_r8,4.3260e-01_r8,7.5378e-01_r8,8.0524e-01_r8,7.2961e-01_r8, &
     &6.5477e-01_r8,6.4648e-01_r8,1.3999e+00_r8/)
      kao(:, 5, 1, 4) = (/ &
     &1.7164e-01_r8,2.1055e-01_r8,4.2755e-01_r8,7.3334e-01_r8,7.8436e-01_r8,7.1000e-01_r8, &
     &6.4297e-01_r8,6.0884e-01_r8,1.3521e+00_r8/)
      kao(:, 1, 2, 4) = (/ &
     &1.7302e-01_r8,2.0244e-01_r8,5.3076e-01_r8,6.9942e-01_r8,7.3274e-01_r8,6.9098e-01_r8, &
     &6.5285e-01_r8,6.3638e-01_r8,1.2559e+00_r8/)
      kao(:, 2, 2, 4) = (/ &
     &1.6489e-01_r8,1.9797e-01_r8,5.4053e-01_r8,6.8204e-01_r8,7.0789e-01_r8,6.6109e-01_r8, &
     &6.3152e-01_r8,6.0382e-01_r8,1.2010e+00_r8/)
      kao(:, 3, 2, 4) = (/ &
     &1.5760e-01_r8,1.9570e-01_r8,5.4478e-01_r8,6.6415e-01_r8,6.8272e-01_r8,6.3617e-01_r8, &
     &6.0950e-01_r8,5.7193e-01_r8,1.1640e+00_r8/)
      kao(:, 4, 2, 4) = (/ &
     &1.5184e-01_r8,1.9435e-01_r8,5.4381e-01_r8,6.4780e-01_r8,6.6147e-01_r8,6.1692e-01_r8, &
     &5.8732e-01_r8,5.4197e-01_r8,1.1223e+00_r8/)
      kao(:, 5, 2, 4) = (/ &
     &1.4698e-01_r8,1.9520e-01_r8,5.4107e-01_r8,6.3896e-01_r8,6.4395e-01_r8,6.0782e-01_r8, &
     &5.7401e-01_r8,5.1623e-01_r8,1.0839e+00_r8/)
      kao(:, 1, 3, 4) = (/ &
     &1.5095e-01_r8,2.3961e-01_r8,5.3891e-01_r8,5.9274e-01_r8,6.0360e-01_r8,5.9975e-01_r8, &
     &5.7583e-01_r8,5.3639e-01_r8,1.0254e+00_r8/)
      kao(:, 2, 3, 4) = (/ &
     &1.4378e-01_r8,2.4579e-01_r8,5.2840e-01_r8,5.8072e-01_r8,5.8574e-01_r8,5.7325e-01_r8, &
     &5.5457e-01_r8,5.1150e-01_r8,9.9368e-01_r8/)
      kao(:, 3, 3, 4) = (/ &
     &1.3744e-01_r8,2.5218e-01_r8,5.1071e-01_r8,5.6679e-01_r8,5.6782e-01_r8,5.5647e-01_r8, &
     &5.3781e-01_r8,4.7984e-01_r8,9.5622e-01_r8/)
      kao(:, 4, 3, 4) = (/ &
     &1.3182e-01_r8,2.5642e-01_r8,4.9891e-01_r8,5.5373e-01_r8,5.5212e-01_r8,5.4201e-01_r8, &
     &5.2720e-01_r8,4.5497e-01_r8,9.3692e-01_r8/)
      kao(:, 5, 3, 4) = (/ &
     &1.2736e-01_r8,2.6156e-01_r8,4.9042e-01_r8,5.4609e-01_r8,5.4094e-01_r8,5.2788e-01_r8, &
     &5.2063e-01_r8,4.2896e-01_r8,9.1393e-01_r8/)
      kao(:, 1, 4, 4) = (/ &
     &1.3296e-01_r8,3.0808e-01_r8,4.5560e-01_r8,5.0161e-01_r8,5.1973e-01_r8,5.1660e-01_r8, &
     &5.1162e-01_r8,4.5889e-01_r8,8.7778e-01_r8/)
      kao(:, 2, 4, 4) = (/ &
     &1.2659e-01_r8,3.1156e-01_r8,4.4164e-01_r8,4.8779e-01_r8,5.0041e-01_r8,4.9812e-01_r8, &
     &4.9015e-01_r8,4.3243e-01_r8,8.4542e-01_r8/)
      kao(:, 3, 4, 4) = (/ &
     &1.2094e-01_r8,3.1188e-01_r8,4.3105e-01_r8,4.7578e-01_r8,4.8617e-01_r8,4.8333e-01_r8, &
     &4.7842e-01_r8,4.0299e-01_r8,8.1678e-01_r8/)
      kao(:, 4, 4, 4) = (/ &
     &1.1593e-01_r8,3.1351e-01_r8,4.2237e-01_r8,4.6451e-01_r8,4.7350e-01_r8,4.7079e-01_r8, &
     &4.7610e-01_r8,3.7858e-01_r8,7.9667e-01_r8/)
      kao(:, 5, 4, 4) = (/ &
     &1.1150e-01_r8,3.1306e-01_r8,4.1390e-01_r8,4.5362e-01_r8,4.6429e-01_r8,4.6167e-01_r8, &
     &4.7081e-01_r8,3.5772e-01_r8,7.7552e-01_r8/)
      kao(:, 1, 5, 4) = (/ &
     &1.1755e-01_r8,3.2807e-01_r8,3.8548e-01_r8,4.2521e-01_r8,4.4554e-01_r8,4.5203e-01_r8, &
     &4.4500e-01_r8,3.9225e-01_r8,7.4478e-01_r8/)
      kao(:, 2, 5, 4) = (/ &
     &1.1209e-01_r8,3.1909e-01_r8,3.7705e-01_r8,4.1235e-01_r8,4.2996e-01_r8,4.3302e-01_r8, &
     &4.3279e-01_r8,3.6494e-01_r8,7.1780e-01_r8/)
      kao(:, 3, 5, 4) = (/ &
     &1.0716e-01_r8,3.1181e-01_r8,3.6570e-01_r8,3.9834e-01_r8,4.1575e-01_r8,4.2162e-01_r8, &
     &4.2981e-01_r8,3.4051e-01_r8,6.9974e-01_r8/)
      kao(:, 4, 5, 4) = (/ &
     &1.0275e-01_r8,3.0301e-01_r8,3.5750e-01_r8,3.8990e-01_r8,4.0553e-01_r8,4.1539e-01_r8, &
     &4.2536e-01_r8,3.1843e-01_r8,6.8036e-01_r8/)
      kao(:, 5, 5, 4) = (/ &
     &9.8998e-02_r8,2.9446e-01_r8,3.5111e-01_r8,3.8417e-01_r8,3.9923e-01_r8,4.1474e-01_r8, &
     &4.2083e-01_r8,3.0243e-01_r8,6.6644e-01_r8/)
      kao(:, 1, 6, 4) = (/ &
     &1.0705e-01_r8,2.7318e-01_r8,3.3208e-01_r8,3.6143e-01_r8,3.8591e-01_r8,3.9313e-01_r8, &
     &3.9284e-01_r8,3.3741e-01_r8,6.4786e-01_r8/)
      kao(:, 2, 6, 4) = (/ &
     &1.0199e-01_r8,2.6545e-01_r8,3.2251e-01_r8,3.5040e-01_r8,3.7450e-01_r8,3.7890e-01_r8, &
     &3.8585e-01_r8,3.0993e-01_r8,6.2347e-01_r8/)
      kao(:, 3, 6, 4) = (/ &
     &9.7437e-02_r8,2.5576e-01_r8,3.1499e-01_r8,3.4107e-01_r8,3.6300e-01_r8,3.7247e-01_r8, &
     &3.8009e-01_r8,2.8815e-01_r8,6.0580e-01_r8/)
      kao(:, 4, 6, 4) = (/ &
     &9.3482e-02_r8,2.4922e-01_r8,3.0800e-01_r8,3.3313e-01_r8,3.5414e-01_r8,3.7096e-01_r8, &
     &3.7706e-01_r8,2.7157e-01_r8,5.9892e-01_r8/)
      kao(:, 5, 6, 4) = (/ &
     &9.0031e-02_r8,2.4481e-01_r8,3.0199e-01_r8,3.2745e-01_r8,3.5204e-01_r8,3.7018e-01_r8, &
     &3.6552e-01_r8,2.5507e-01_r8,5.9364e-01_r8/)
      kao(:, 1, 7, 4) = (/ &
     &1.0201e-01_r8,2.3487e-01_r8,2.8528e-01_r8,3.1378e-01_r8,3.3635e-01_r8,3.4598e-01_r8, &
     &3.4770e-01_r8,2.9069e-01_r8,5.6026e-01_r8/)
      kao(:, 2, 7, 4) = (/ &
     &9.7333e-02_r8,2.2730e-01_r8,2.7830e-01_r8,3.0507e-01_r8,3.2187e-01_r8,3.3481e-01_r8, &
     &3.4172e-01_r8,2.6797e-01_r8,5.4227e-01_r8/)
      kao(:, 3, 7, 4) = (/ &
     &9.3243e-02_r8,2.2136e-01_r8,2.6944e-01_r8,2.9618e-01_r8,3.1454e-01_r8,3.2973e-01_r8, &
     &3.3451e-01_r8,2.4821e-01_r8,5.2884e-01_r8/)
      kao(:, 4, 7, 4) = (/ &
     &8.9660e-02_r8,2.1638e-01_r8,2.6334e-01_r8,2.9056e-01_r8,3.1245e-01_r8,3.2791e-01_r8, &
     &3.2519e-01_r8,2.3192e-01_r8,5.2407e-01_r8/)
      kao(:, 5, 7, 4) = (/ &
     &8.6492e-02_r8,2.1156e-01_r8,2.5984e-01_r8,2.8528e-01_r8,3.1573e-01_r8,3.2789e-01_r8, &
     &3.1681e-01_r8,2.1806e-01_r8,5.2688e-01_r8/)
      kao(:, 1, 8, 4) = (/ &
     &1.0039e-01_r8,2.1049e-01_r8,2.5117e-01_r8,2.7733e-01_r8,2.9294e-01_r8,3.0451e-01_r8, &
     &3.0671e-01_r8,2.5418e-01_r8,4.9108e-01_r8/)
      kao(:, 2, 8, 4) = (/ &
     &9.6148e-02_r8,2.0539e-01_r8,2.4350e-01_r8,2.6931e-01_r8,2.8451e-01_r8,2.9582e-01_r8, &
     &3.0170e-01_r8,2.3605e-01_r8,4.7511e-01_r8/)
      kao(:, 3, 8, 4) = (/ &
     &9.2145e-02_r8,2.0009e-01_r8,2.3646e-01_r8,2.6177e-01_r8,2.7896e-01_r8,2.9276e-01_r8, &
     &2.9264e-01_r8,2.1892e-01_r8,4.6537e-01_r8/)
      kao(:, 4, 8, 4) = (/ &
     &8.8569e-02_r8,1.9568e-01_r8,2.3097e-01_r8,2.5688e-01_r8,2.7814e-01_r8,2.9214e-01_r8, &
     &2.8481e-01_r8,2.0263e-01_r8,4.6603e-01_r8/)
      kao(:, 5, 8, 4) = (/ &
     &8.5629e-02_r8,1.9094e-01_r8,2.2714e-01_r8,2.5259e-01_r8,2.7953e-01_r8,2.8904e-01_r8, &
     &2.7433e-01_r8,1.9066e-01_r8,4.6777e-01_r8/)
      kao(:, 1, 9, 4) = (/ &
     &9.8021e-02_r8,1.9151e-01_r8,2.2309e-01_r8,2.4564e-01_r8,2.5865e-01_r8,2.6783e-01_r8, &
     &2.6894e-01_r8,2.2292e-01_r8,4.2854e-01_r8/)
      kao(:, 2, 9, 4) = (/ &
     &9.3022e-02_r8,1.8527e-01_r8,2.1592e-01_r8,2.3651e-01_r8,2.5064e-01_r8,2.6055e-01_r8, &
     &2.6499e-01_r8,2.0617e-01_r8,4.1580e-01_r8/)
      kao(:, 3, 9, 4) = (/ &
     &8.8595e-02_r8,1.8097e-01_r8,2.1073e-01_r8,2.3156e-01_r8,2.4703e-01_r8,2.5851e-01_r8, &
     &2.5441e-01_r8,1.9146e-01_r8,4.1005e-01_r8/)
      kao(:, 4, 9, 4) = (/ &
     &8.4486e-02_r8,1.7670e-01_r8,2.0686e-01_r8,2.2734e-01_r8,2.4622e-01_r8,2.5730e-01_r8, &
     &2.4711e-01_r8,1.7700e-01_r8,4.1054e-01_r8/)
      kao(:, 5, 9, 4) = (/ &
     &8.1546e-02_r8,1.7284e-01_r8,2.0523e-01_r8,2.2674e-01_r8,2.4921e-01_r8,2.5266e-01_r8, &
     &2.3614e-01_r8,1.6619e-01_r8,4.1551e-01_r8/)
      kao(:, 1,10, 4) = (/ &
     &9.1049e-02_r8,1.7362e-01_r8,1.9833e-01_r8,2.1764e-01_r8,2.2798e-01_r8,2.3471e-01_r8, &
     &2.3646e-01_r8,1.9422e-01_r8,3.7343e-01_r8/)
      kao(:, 2,10, 4) = (/ &
     &8.6996e-02_r8,1.6791e-01_r8,1.9240e-01_r8,2.1075e-01_r8,2.2237e-01_r8,2.2936e-01_r8, &
     &2.3178e-01_r8,1.7985e-01_r8,3.6356e-01_r8/)
      kao(:, 3,10, 4) = (/ &
     &8.2800e-02_r8,1.6395e-01_r8,1.8777e-01_r8,2.0552e-01_r8,2.1940e-01_r8,2.2862e-01_r8, &
     &2.2169e-01_r8,1.6614e-01_r8,3.6046e-01_r8/)
      kao(:, 4,10, 4) = (/ &
     &7.8811e-02_r8,1.5975e-01_r8,1.8561e-01_r8,2.0375e-01_r8,2.1988e-01_r8,2.2450e-01_r8, &
     &2.1345e-01_r8,1.5492e-01_r8,3.6096e-01_r8/)
      kao(:, 5,10, 4) = (/ &
     &7.5529e-02_r8,1.5650e-01_r8,1.8353e-01_r8,2.0505e-01_r8,2.1950e-01_r8,2.1739e-01_r8, &
     &2.0454e-01_r8,1.4507e-01_r8,3.6055e-01_r8/)
      kao(:, 1,11, 4) = (/ &
     &7.7672e-02_r8,1.5145e-01_r8,1.7382e-01_r8,1.8990e-01_r8,1.9990e-01_r8,2.0432e-01_r8, &
     &2.0547e-01_r8,1.6386e-01_r8,3.1843e-01_r8/)
      kao(:, 2,11, 4) = (/ &
     &7.3723e-02_r8,1.4611e-01_r8,1.6807e-01_r8,1.8489e-01_r8,1.9610e-01_r8,2.0254e-01_r8, &
     &1.9720e-01_r8,1.5217e-01_r8,3.1488e-01_r8/)
      kao(:, 3,11, 4) = (/ &
     &7.0457e-02_r8,1.4249e-01_r8,1.6412e-01_r8,1.8266e-01_r8,1.9585e-01_r8,1.9778e-01_r8, &
     &1.8906e-01_r8,1.4085e-01_r8,3.1421e-01_r8/)
      kao(:, 4,11, 4) = (/ &
     &6.7094e-02_r8,1.3863e-01_r8,1.6386e-01_r8,1.8321e-01_r8,1.9415e-01_r8,1.9186e-01_r8, &
     &1.8023e-01_r8,1.3105e-01_r8,3.1088e-01_r8/)
      kao(:, 5,11, 4) = (/ &
     &6.4100e-02_r8,1.3524e-01_r8,1.6357e-01_r8,1.8497e-01_r8,1.9137e-01_r8,1.8498e-01_r8, &
     &1.7319e-01_r8,1.2321e-01_r8,3.0324e-01_r8/)
      kao(:, 1,12, 4) = (/ &
     &6.6765e-02_r8,1.2994e-01_r8,1.4944e-01_r8,1.6445e-01_r8,1.7587e-01_r8,1.8101e-01_r8, &
     &1.7769e-01_r8,1.3984e-01_r8,2.7673e-01_r8/)
      kao(:, 2,12, 4) = (/ &
     &6.3023e-02_r8,1.2593e-01_r8,1.4588e-01_r8,1.6162e-01_r8,1.7387e-01_r8,1.7653e-01_r8, &
     &1.6990e-01_r8,1.2980e-01_r8,2.7397e-01_r8/)
      kao(:, 3,12, 4) = (/ &
     &6.0078e-02_r8,1.2173e-01_r8,1.4433e-01_r8,1.6136e-01_r8,1.7141e-01_r8,1.7100e-01_r8, &
     &1.6190e-01_r8,1.2017e-01_r8,2.6912e-01_r8/)
      kao(:, 4,12, 4) = (/ &
     &5.7591e-02_r8,1.1797e-01_r8,1.4432e-01_r8,1.6200e-01_r8,1.6903e-01_r8,1.6549e-01_r8, &
     &1.5510e-01_r8,1.1177e-01_r8,2.6329e-01_r8/)
      kao(:, 5,12, 4) = (/ &
     &5.5506e-02_r8,1.1583e-01_r8,1.4556e-01_r8,1.5779e-01_r8,1.6302e-01_r8,1.5857e-01_r8, &
     &1.4926e-01_r8,1.0509e-01_r8,2.5258e-01_r8/)
      kao(:, 1,13, 4) = (/ &
     &5.9522e-02_r8,1.1440e-01_r8,1.3268e-01_r8,1.4518e-01_r8,1.5668e-01_r8,1.6016e-01_r8, &
     &1.5672e-01_r8,1.2200e-01_r8,2.4269e-01_r8/)
      kao(:, 2,13, 4) = (/ &
     &5.6603e-02_r8,1.1049e-01_r8,1.3023e-01_r8,1.4451e-01_r8,1.5437e-01_r8,1.5452e-01_r8, &
     &1.4924e-01_r8,1.1346e-01_r8,2.3750e-01_r8/)
      kao(:, 3,13, 4) = (/ &
     &5.4101e-02_r8,1.0639e-01_r8,1.2967e-01_r8,1.4482e-01_r8,1.5052e-01_r8,1.4869e-01_r8, &
     &1.4191e-01_r8,1.0569e-01_r8,2.3366e-01_r8/)
      kao(:, 4,13, 4) = (/ &
     &5.1959e-02_r8,1.0421e-01_r8,1.3053e-01_r8,1.4062e-01_r8,1.4577e-01_r8,1.4358e-01_r8, &
     &1.3605e-01_r8,9.8273e-02_r8,2.2442e-01_r8/)
      kao(:, 5,13, 4) = (/ &
     &4.9821e-02_r8,1.0307e-01_r8,1.3162e-01_r8,1.3605e-01_r8,1.4048e-01_r8,1.3772e-01_r8, &
     &1.3142e-01_r8,9.2354e-02_r8,2.1552e-01_r8/)
      kao(:, 1, 1, 5) = (/ &
     &4.4662e-01_r8,4.5491e-01_r8,4.6518e-01_r8,4.8073e-01_r8,9.6301e-01_r8,1.0662e+00_r8, &
     &9.6837e-01_r8,6.1516e-01_r8,1.5492e+00_r8/)
      kao(:, 2, 1, 5) = (/ &
     &4.3070e-01_r8,4.3901e-01_r8,4.4894e-01_r8,4.8843e-01_r8,9.7366e-01_r8,1.0185e+00_r8, &
     &9.1919e-01_r8,5.9289e-01_r8,1.4372e+00_r8/)
      kao(:, 3, 1, 5) = (/ &
     &4.1920e-01_r8,4.2623e-01_r8,4.3584e-01_r8,5.1853e-01_r8,9.4077e-01_r8,9.6967e-01_r8, &
     &8.7962e-01_r8,5.7716e-01_r8,1.3511e+00_r8/)
      kao(:, 4, 1, 5) = (/ &
     &4.1320e-01_r8,4.1951e-01_r8,4.2768e-01_r8,5.3113e-01_r8,8.9548e-01_r8,9.3086e-01_r8, &
     &8.2656e-01_r8,5.7871e-01_r8,1.2540e+00_r8/)
      kao(:, 5, 1, 5) = (/ &
     &4.1049e-01_r8,4.1583e-01_r8,4.2551e-01_r8,5.4820e-01_r8,8.6249e-01_r8,8.9543e-01_r8, &
     &7.7827e-01_r8,5.9312e-01_r8,1.1774e+00_r8/)
      kao(:, 1, 2, 5) = (/ &
     &3.7419e-01_r8,3.9315e-01_r8,4.1387e-01_r8,7.3684e-01_r8,9.3729e-01_r8,9.5798e-01_r8, &
     &8.1977e-01_r8,5.4534e-01_r8,1.3830e+00_r8/)
      kao(:, 2, 2, 5) = (/ &
     &3.6046e-01_r8,3.7870e-01_r8,3.9949e-01_r8,7.5022e-01_r8,8.9119e-01_r8,9.0575e-01_r8, &
     &7.6682e-01_r8,5.2408e-01_r8,1.3014e+00_r8/)
      kao(:, 3, 2, 5) = (/ &
     &3.5058e-01_r8,3.6732e-01_r8,3.9129e-01_r8,7.6077e-01_r8,8.5537e-01_r8,8.6853e-01_r8, &
     &7.2131e-01_r8,5.2368e-01_r8,1.1992e+00_r8/)
      kao(:, 4, 2, 5) = (/ &
     &3.4363e-01_r8,3.5974e-01_r8,3.8593e-01_r8,7.6592e-01_r8,8.1963e-01_r8,8.3241e-01_r8, &
     &6.8939e-01_r8,5.2630e-01_r8,1.1280e+00_r8/)
      kao(:, 5, 2, 5) = (/ &
     &3.4117e-01_r8,3.5633e-01_r8,3.8040e-01_r8,7.4257e-01_r8,7.9365e-01_r8,7.8846e-01_r8, &
     &6.5921e-01_r8,5.2675e-01_r8,1.0716e+00_r8/)
      kao(:, 1, 3, 5) = (/ &
     &3.1617e-01_r8,3.4533e-01_r8,4.9004e-01_r8,8.0662e-01_r8,8.6490e-01_r8,8.2831e-01_r8, &
     &6.9369e-01_r8,4.9053e-01_r8,1.2685e+00_r8/)
      kao(:, 2, 3, 5) = (/ &
     &3.0386e-01_r8,3.3185e-01_r8,4.9271e-01_r8,7.6499e-01_r8,8.1967e-01_r8,7.8960e-01_r8, &
     &6.4565e-01_r8,4.7244e-01_r8,1.1699e+00_r8/)
      kao(:, 3, 3, 5) = (/ &
     &2.9464e-01_r8,3.2055e-01_r8,5.0043e-01_r8,7.2785e-01_r8,7.8235e-01_r8,7.5123e-01_r8, &
     &6.1372e-01_r8,4.7097e-01_r8,1.0909e+00_r8/)
      kao(:, 4, 3, 5) = (/ &
     &2.8765e-01_r8,3.1339e-01_r8,5.0754e-01_r8,6.9697e-01_r8,7.5208e-01_r8,7.1843e-01_r8, &
     &5.8571e-01_r8,4.6400e-01_r8,1.0036e+00_r8/)
      kao(:, 5, 3, 5) = (/ &
     &2.8344e-01_r8,3.0751e-01_r8,5.1242e-01_r8,6.6855e-01_r8,7.1995e-01_r8,6.9218e-01_r8, &
     &5.7184e-01_r8,4.7451e-01_r8,9.2127e-01_r8/)
      kao(:, 1, 4, 5) = (/ &
     &2.6775e-01_r8,3.0604e-01_r8,6.4660e-01_r8,7.3076e-01_r8,7.6521e-01_r8,7.2923e-01_r8, &
     &5.8618e-01_r8,4.3353e-01_r8,1.1015e+00_r8/)
      kao(:, 2, 4, 5) = (/ &
     &2.5632e-01_r8,2.9306e-01_r8,6.2522e-01_r8,6.9215e-01_r8,7.2674e-01_r8,6.8433e-01_r8, &
     &5.5230e-01_r8,4.1918e-01_r8,1.0081e+00_r8/)
      kao(:, 3, 4, 5) = (/ &
     &2.4780e-01_r8,2.8292e-01_r8,5.9390e-01_r8,6.5413e-01_r8,6.8773e-01_r8,6.5028e-01_r8, &
     &5.2160e-01_r8,4.1724e-01_r8,9.3062e-01_r8/)
      kao(:, 4, 4, 5) = (/ &
     &2.4100e-01_r8,2.7551e-01_r8,5.7041e-01_r8,6.2793e-01_r8,6.5534e-01_r8,6.2452e-01_r8, &
     &5.0866e-01_r8,4.1719e-01_r8,8.4917e-01_r8/)
      kao(:, 5, 4, 5) = (/ &
     &2.3658e-01_r8,2.6967e-01_r8,5.4813e-01_r8,6.0747e-01_r8,6.2636e-01_r8,5.9897e-01_r8, &
     &4.9899e-01_r8,4.2737e-01_r8,7.8635e-01_r8/)
      kao(:, 1, 5, 5) = (/ &
     &2.2714e-01_r8,3.0892e-01_r8,5.8868e-01_r8,6.5760e-01_r8,6.7083e-01_r8,6.2555e-01_r8, &
     &5.1259e-01_r8,3.8131e-01_r8,9.5049e-01_r8/)
      kao(:, 2, 5, 5) = (/ &
     &2.1666e-01_r8,3.0798e-01_r8,5.5062e-01_r8,6.2165e-01_r8,6.2939e-01_r8,5.9031e-01_r8, &
     &4.8040e-01_r8,3.7074e-01_r8,8.6898e-01_r8/)
      kao(:, 3, 5, 5) = (/ &
     &2.0871e-01_r8,3.0702e-01_r8,5.2691e-01_r8,5.8794e-01_r8,5.9599e-01_r8,5.6236e-01_r8, &
     &4.6150e-01_r8,3.6395e-01_r8,7.8288e-01_r8/)
      kao(:, 4, 5, 5) = (/ &
     &2.0276e-01_r8,3.0943e-01_r8,5.0433e-01_r8,5.5988e-01_r8,5.6518e-01_r8,5.3494e-01_r8, &
     &4.4833e-01_r8,3.6773e-01_r8,7.2419e-01_r8/)
      kao(:, 5, 5, 5) = (/ &
     &1.9892e-01_r8,3.1215e-01_r8,4.8278e-01_r8,5.3676e-01_r8,5.4170e-01_r8,5.0924e-01_r8, &
     &4.4109e-01_r8,3.7855e-01_r8,6.8358e-01_r8/)
      kao(:, 1, 6, 5) = (/ &
     &1.9298e-01_r8,3.8310e-01_r8,5.2601e-01_r8,5.8117e-01_r8,5.8505e-01_r8,5.4459e-01_r8, &
     &4.4513e-01_r8,3.3639e-01_r8,8.1804e-01_r8/)
      kao(:, 2, 6, 5) = (/ &
     &1.8380e-01_r8,3.7978e-01_r8,4.9784e-01_r8,5.4325e-01_r8,5.4503e-01_r8,5.1006e-01_r8, &
     &4.1750e-01_r8,3.2606e-01_r8,7.4136e-01_r8/)
      kao(:, 3, 6, 5) = (/ &
     &1.7694e-01_r8,3.8180e-01_r8,4.7027e-01_r8,5.1699e-01_r8,5.1079e-01_r8,4.8235e-01_r8, &
     &4.0208e-01_r8,3.2052e-01_r8,6.7777e-01_r8/)
      kao(:, 4, 6, 5) = (/ &
     &1.7133e-01_r8,3.7179e-01_r8,4.4558e-01_r8,4.8630e-01_r8,4.9002e-01_r8,4.5737e-01_r8, &
     &3.9155e-01_r8,3.2262e-01_r8,6.2593e-01_r8/)
      kao(:, 5, 6, 5) = (/ &
     &1.6754e-01_r8,3.5443e-01_r8,4.2444e-01_r8,4.6383e-01_r8,4.6954e-01_r8,4.4064e-01_r8, &
     &3.8904e-01_r8,3.3286e-01_r8,5.7664e-01_r8/)
      kao(:, 1, 7, 5) = (/ &
     &1.6680e-01_r8,3.8673e-01_r8,4.6977e-01_r8,5.0982e-01_r8,5.0645e-01_r8,4.7419e-01_r8, &
     &3.9067e-01_r8,2.9795e-01_r8,7.1500e-01_r8/)
      kao(:, 2, 7, 5) = (/ &
     &1.5848e-01_r8,3.6483e-01_r8,4.3657e-01_r8,4.7719e-01_r8,4.7339e-01_r8,4.4276e-01_r8, &
     &3.6591e-01_r8,2.8456e-01_r8,6.4266e-01_r8/)
      kao(:, 3, 7, 5) = (/ &
     &1.5206e-01_r8,3.4607e-01_r8,4.1294e-01_r8,4.4755e-01_r8,4.4747e-01_r8,4.1880e-01_r8, &
     &3.5274e-01_r8,2.8027e-01_r8,5.8922e-01_r8/)
      kao(:, 4, 7, 5) = (/ &
     &1.4707e-01_r8,3.2827e-01_r8,3.9251e-01_r8,4.2303e-01_r8,4.2524e-01_r8,3.9890e-01_r8, &
     &3.4920e-01_r8,2.8325e-01_r8,5.4340e-01_r8/)
      kao(:, 5, 7, 5) = (/ &
     &1.4361e-01_r8,3.1545e-01_r8,3.7348e-01_r8,4.0710e-01_r8,4.0646e-01_r8,3.8591e-01_r8, &
     &3.3880e-01_r8,2.9285e-01_r8,5.0986e-01_r8/)
      kao(:, 1, 8, 5) = (/ &
     &1.4820e-01_r8,3.5091e-01_r8,4.2013e-01_r8,4.5147e-01_r8,4.5056e-01_r8,4.1729e-01_r8, &
     &3.4786e-01_r8,2.6599e-01_r8,6.3121e-01_r8/)
      kao(:, 2, 8, 5) = (/ &
     &1.4070e-01_r8,3.2895e-01_r8,3.9148e-01_r8,4.1739e-01_r8,4.1786e-01_r8,3.8937e-01_r8, &
     &3.2642e-01_r8,2.5048e-01_r8,5.6833e-01_r8/)
      kao(:, 3, 8, 5) = (/ &
     &1.3491e-01_r8,3.1064e-01_r8,3.6928e-01_r8,3.9231e-01_r8,3.9615e-01_r8,3.7023e-01_r8, &
     &3.1619e-01_r8,2.4413e-01_r8,5.2283e-01_r8/)
      kao(:, 4, 8, 5) = (/ &
     &1.3040e-01_r8,2.9486e-01_r8,3.4865e-01_r8,3.7267e-01_r8,3.7585e-01_r8,3.5308e-01_r8, &
     &3.1289e-01_r8,2.4763e-01_r8,4.8158e-01_r8/)
      kao(:, 5, 8, 5) = (/ &
     &1.2713e-01_r8,2.8372e-01_r8,3.3299e-01_r8,3.5768e-01_r8,3.6293e-01_r8,3.4468e-01_r8, &
     &2.9924e-01_r8,2.5414e-01_r8,4.5058e-01_r8/)
      kao(:, 1, 9, 5) = (/ &
     &1.3333e-01_r8,3.1732e-01_r8,3.7806e-01_r8,3.9822e-01_r8,3.9576e-01_r8,3.6830e-01_r8, &
     &3.0959e-01_r8,2.3751e-01_r8,5.5734e-01_r8/)
      kao(:, 2, 9, 5) = (/ &
     &1.2728e-01_r8,2.9745e-01_r8,3.4973e-01_r8,3.7018e-01_r8,3.6774e-01_r8,3.4366e-01_r8, &
     &2.8994e-01_r8,2.2165e-01_r8,5.0172e-01_r8/)
      kao(:, 3, 9, 5) = (/ &
     &1.2260e-01_r8,2.7734e-01_r8,3.2656e-01_r8,3.4735e-01_r8,3.4508e-01_r8,3.2798e-01_r8, &
     &2.8353e-01_r8,2.1398e-01_r8,4.5989e-01_r8/)
      kao(:, 4, 9, 5) = (/ &
     &1.1943e-01_r8,2.6308e-01_r8,3.0660e-01_r8,3.2980e-01_r8,3.3173e-01_r8,3.1278e-01_r8, &
     &2.7390e-01_r8,2.1485e-01_r8,4.2942e-01_r8/)
      kao(:, 5, 9, 5) = (/ &
     &1.1701e-01_r8,2.4928e-01_r8,2.9183e-01_r8,3.1474e-01_r8,3.2039e-01_r8,3.0863e-01_r8, &
     &2.6433e-01_r8,2.1871e-01_r8,3.9836e-01_r8/)
      kao(:, 1,10, 5) = (/ &
     &1.2488e-01_r8,2.8649e-01_r8,3.3436e-01_r8,3.5060e-01_r8,3.4715e-01_r8,3.2381e-01_r8, &
     &2.7352e-01_r8,2.0897e-01_r8,4.9029e-01_r8/)
      kao(:, 2,10, 5) = (/ &
     &1.1908e-01_r8,2.6494e-01_r8,3.0883e-01_r8,3.2464e-01_r8,3.2171e-01_r8,3.0303e-01_r8, &
     &2.5647e-01_r8,1.9520e-01_r8,4.4008e-01_r8/)
      kao(:, 3,10, 5) = (/ &
     &1.1556e-01_r8,2.4763e-01_r8,2.8674e-01_r8,3.0514e-01_r8,3.0302e-01_r8,2.8868e-01_r8, &
     &2.5222e-01_r8,1.8782e-01_r8,4.0842e-01_r8/)
      kao(:, 4,10, 5) = (/ &
     &1.1322e-01_r8,2.3334e-01_r8,2.7126e-01_r8,2.8846e-01_r8,2.9340e-01_r8,2.7863e-01_r8, &
     &2.4033e-01_r8,1.8521e-01_r8,3.8163e-01_r8/)
      kao(:, 5,10, 5) = (/ &
     &1.1126e-01_r8,2.2285e-01_r8,2.5915e-01_r8,2.7811e-01_r8,2.8680e-01_r8,2.7376e-01_r8, &
     &2.3030e-01_r8,1.8823e-01_r8,3.5861e-01_r8/)
      kao(:, 1,11, 5) = (/ &
     &1.2133e-01_r8,2.4900e-01_r8,2.8640e-01_r8,2.9703e-01_r8,2.9301e-01_r8,2.7475e-01_r8, &
     &2.3250e-01_r8,1.7899e-01_r8,4.0785e-01_r8/)
      kao(:, 2,11, 5) = (/ &
     &1.1707e-01_r8,2.3382e-01_r8,2.6584e-01_r8,2.7776e-01_r8,2.7455e-01_r8,2.6096e-01_r8, &
     &2.2631e-01_r8,1.6847e-01_r8,3.7573e-01_r8/)
      kao(:, 3,11, 5) = (/ &
     &1.1375e-01_r8,2.1845e-01_r8,2.5115e-01_r8,2.6117e-01_r8,2.6335e-01_r8,2.5113e-01_r8, &
     &2.1653e-01_r8,1.6132e-01_r8,3.4922e-01_r8/)
      kao(:, 4,11, 5) = (/ &
     &1.1166e-01_r8,2.0864e-01_r8,2.3761e-01_r8,2.5163e-01_r8,2.5840e-01_r8,2.4419e-01_r8, &
     &2.0592e-01_r8,1.6130e-01_r8,3.3156e-01_r8/)
      kao(:, 5,11, 5) = (/ &
     &1.1026e-01_r8,2.0025e-01_r8,2.2827e-01_r8,2.4711e-01_r8,2.5459e-01_r8,2.3449e-01_r8, &
     &1.9737e-01_r8,1.6301e-01_r8,3.1155e-01_r8/)
      kao(:, 1,12, 5) = (/ &
     &1.2068e-01_r8,2.2498e-01_r8,2.5241e-01_r8,2.6093e-01_r8,2.5316e-01_r8,2.3830e-01_r8, &
     &2.0580e-01_r8,1.5434e-01_r8,3.4650e-01_r8/)
      kao(:, 2,12, 5) = (/ &
     &1.1732e-01_r8,2.1063e-01_r8,2.3754e-01_r8,2.4422e-01_r8,2.4130e-01_r8,2.2913e-01_r8, &
     &1.9581e-01_r8,1.4538e-01_r8,3.2419e-01_r8/)
      kao(:, 3,12, 5) = (/ &
     &1.1291e-01_r8,2.0050e-01_r8,2.2356e-01_r8,2.3528e-01_r8,2.3734e-01_r8,2.2099e-01_r8, &
     &1.8732e-01_r8,1.4169e-01_r8,3.0809e-01_r8/)
      kao(:, 4,12, 5) = (/ &
     &1.0801e-01_r8,1.9213e-01_r8,2.1514e-01_r8,2.2964e-01_r8,2.3229e-01_r8,2.1151e-01_r8, &
     &1.7615e-01_r8,1.4140e-01_r8,2.8807e-01_r8/)
      kao(:, 5,12, 5) = (/ &
     &1.0409e-01_r8,1.8478e-01_r8,2.0856e-01_r8,2.2937e-01_r8,2.2388e-01_r8,2.0038e-01_r8, &
     &1.7052e-01_r8,1.4327e-01_r8,2.6150e-01_r8/)
      kao(:, 1,13, 5) = (/ &
     &1.1514e-01_r8,2.0822e-01_r8,2.3178e-01_r8,2.3757e-01_r8,2.2988e-01_r8,2.1559e-01_r8, &
     &1.8505e-01_r8,1.3755e-01_r8,3.0255e-01_r8/)
      kao(:, 2,13, 5) = (/ &
     &1.0856e-01_r8,1.9378e-01_r8,2.1572e-01_r8,2.2466e-01_r8,2.2140e-01_r8,2.1071e-01_r8, &
     &1.7476e-01_r8,1.2903e-01_r8,2.8912e-01_r8/)
      kao(:, 3,13, 5) = (/ &
     &1.0257e-01_r8,1.8315e-01_r8,2.0306e-01_r8,2.1501e-01_r8,2.1837e-01_r8,1.9973e-01_r8, &
     &1.6546e-01_r8,1.2594e-01_r8,2.7440e-01_r8/)
      kao(:, 4,13, 5) = (/ &
     &9.7502e-02_r8,1.7382e-01_r8,1.9450e-01_r8,2.1448e-01_r8,2.0917e-01_r8,1.8735e-01_r8, &
     &1.5671e-01_r8,1.2605e-01_r8,2.4875e-01_r8/)
      kao(:, 5,13, 5) = (/ &
     &9.4048e-02_r8,1.6507e-01_r8,1.8951e-01_r8,2.1087e-01_r8,1.9884e-01_r8,1.7732e-01_r8, &
     &1.5188e-01_r8,1.2757e-01_r8,2.1998e-01_r8/)
      kao(:, 1, 1, 6) = (/ &
     &1.2242e+00_r8,1.1159e+00_r8,1.0120e+00_r8,9.1389e-01_r8,8.1856e-01_r8,1.1483e+00_r8, &
     &9.8709e-01_r8,9.2159e-01_r8,4.7502e-01_r8/)
      kao(:, 2, 1, 6) = (/ &
     &1.1928e+00_r8,1.0903e+00_r8,9.9311e-01_r8,9.0065e-01_r8,8.3223e-01_r8,1.1145e+00_r8, &
     &9.5738e-01_r8,9.2153e-01_r8,6.9449e-01_r8/)
      kao(:, 3, 1, 6) = (/ &
     &1.1808e+00_r8,1.0824e+00_r8,9.8824e-01_r8,8.9828e-01_r8,8.9586e-01_r8,1.0864e+00_r8, &
     &9.3281e-01_r8,9.2795e-01_r8,8.4213e-01_r8/)
      kao(:, 4, 1, 6) = (/ &
     &1.1721e+00_r8,1.0760e+00_r8,9.8481e-01_r8,8.9679e-01_r8,9.5583e-01_r8,1.0646e+00_r8, &
     &9.4941e-01_r8,9.2047e-01_r8,8.5863e-01_r8/)
      kao(:, 5, 1, 6) = (/ &
     &1.1790e+00_r8,1.0814e+00_r8,9.8996e-01_r8,8.9927e-01_r8,1.0035e+00_r8,1.0346e+00_r8, &
     &9.5167e-01_r8,9.2657e-01_r8,7.2509e-01_r8/)
      kao(:, 1, 2, 6) = (/ &
     &1.0264e+00_r8,9.4284e-01_r8,8.6709e-01_r8,7.9559e-01_r8,1.1080e+00_r8,1.0254e+00_r8, &
     &9.2224e-01_r8,8.7122e-01_r8,1.0512e+00_r8/)
      kao(:, 2, 2, 6) = (/ &
     &1.0018e+00_r8,9.2359e-01_r8,8.5299e-01_r8,7.8672e-01_r8,1.0674e+00_r8,9.8417e-01_r8, &
     &8.9700e-01_r8,8.6779e-01_r8,9.4293e-01_r8/)
      kao(:, 3, 2, 6) = (/ &
     &9.8988e-01_r8,9.1596e-01_r8,8.4833e-01_r8,7.8816e-01_r8,1.0499e+00_r8,9.5536e-01_r8, &
     &8.7579e-01_r8,8.5648e-01_r8,8.1445e-01_r8/)
      kao(:, 4, 2, 6) = (/ &
     &9.8822e-01_r8,9.1536e-01_r8,8.4663e-01_r8,7.9377e-01_r8,1.0292e+00_r8,9.3843e-01_r8, &
     &8.7227e-01_r8,8.6174e-01_r8,7.0730e-01_r8/)
      kao(:, 5, 2, 6) = (/ &
     &9.8800e-01_r8,9.1393e-01_r8,8.4855e-01_r8,8.2484e-01_r8,1.0072e+00_r8,9.4807e-01_r8, &
     &8.8827e-01_r8,8.7216e-01_r8,5.9331e-01_r8/)
      kao(:, 1, 3, 6) = (/ &
     &8.6794e-01_r8,8.0430e-01_r8,7.5031e-01_r8,8.9541e-01_r8,1.0214e+00_r8,9.4865e-01_r8, &
     &8.5821e-01_r8,7.9700e-01_r8,8.7719e-01_r8/)
      kao(:, 2, 3, 6) = (/ &
     &8.4313e-01_r8,7.8532e-01_r8,7.3608e-01_r8,9.3906e-01_r8,9.7060e-01_r8,9.0816e-01_r8, &
     &8.3425e-01_r8,7.9621e-01_r8,7.6329e-01_r8/)
      kao(:, 3, 3, 6) = (/ &
     &8.3157e-01_r8,7.7858e-01_r8,7.3266e-01_r8,9.5972e-01_r8,9.4116e-01_r8,8.8096e-01_r8, &
     &8.0848e-01_r8,7.9477e-01_r8,6.5966e-01_r8/)
      kao(:, 4, 3, 6) = (/ &
     &8.2987e-01_r8,7.7678e-01_r8,7.3040e-01_r8,9.3971e-01_r8,9.0923e-01_r8,8.7002e-01_r8, &
     &8.0556e-01_r8,8.1217e-01_r8,6.0022e-01_r8/)
      kao(:, 5, 3, 6) = (/ &
     &8.2093e-01_r8,7.6968e-01_r8,7.2610e-01_r8,9.2404e-01_r8,8.9670e-01_r8,8.5391e-01_r8, &
     &7.9373e-01_r8,8.1610e-01_r8,5.3117e-01_r8/)
      kao(:, 1, 4, 6) = (/ &
     &7.3504e-01_r8,6.8896e-01_r8,6.5474e-01_r8,9.5125e-01_r8,9.3510e-01_r8,8.8191e-01_r8, &
     &7.8339e-01_r8,7.2709e-01_r8,7.9136e-01_r8/)
      kao(:, 2, 4, 6) = (/ &
     &7.1205e-01_r8,6.7167e-01_r8,6.7088e-01_r8,9.0689e-01_r8,8.7886e-01_r8,8.4133e-01_r8, &
     &7.6196e-01_r8,7.2232e-01_r8,6.9067e-01_r8/)
      kao(:, 3, 4, 6) = (/ &
     &7.0055e-01_r8,6.6424e-01_r8,7.0492e-01_r8,8.8094e-01_r8,8.5026e-01_r8,8.0832e-01_r8, &
     &7.4494e-01_r8,7.3074e-01_r8,6.1263e-01_r8/)
      kao(:, 4, 4, 6) = (/ &
     &6.9588e-01_r8,6.6015e-01_r8,7.3043e-01_r8,8.5040e-01_r8,8.2745e-01_r8,7.8458e-01_r8, &
     &7.3728e-01_r8,7.3901e-01_r8,5.3700e-01_r8/)
      kao(:, 5, 4, 6) = (/ &
     &6.8558e-01_r8,6.5206e-01_r8,7.5371e-01_r8,8.2365e-01_r8,8.2063e-01_r8,7.6670e-01_r8, &
     &7.3328e-01_r8,7.4717e-01_r8,4.4797e-01_r8/)
      kao(:, 1, 5, 6) = (/ &
     &6.2240e-01_r8,5.9202e-01_r8,7.9818e-01_r8,8.6221e-01_r8,8.4556e-01_r8,7.9840e-01_r8, &
     &7.0353e-01_r8,6.4834e-01_r8,7.3196e-01_r8/)
      kao(:, 2, 5, 6) = (/ &
     &6.0152e-01_r8,5.7633e-01_r8,8.0789e-01_r8,8.1513e-01_r8,8.0789e-01_r8,7.5099e-01_r8, &
     &6.7710e-01_r8,6.4945e-01_r8,6.3067e-01_r8/)
      kao(:, 3, 5, 6) = (/ &
     &5.8999e-01_r8,5.6942e-01_r8,7.6969e-01_r8,7.8647e-01_r8,7.7674e-01_r8,7.1468e-01_r8, &
     &6.6534e-01_r8,6.5860e-01_r8,5.4173e-01_r8/)
      kao(:, 4, 5, 6) = (/ &
     &5.8241e-01_r8,5.6326e-01_r8,7.5015e-01_r8,7.6096e-01_r8,7.5392e-01_r8,6.9429e-01_r8, &
     &6.6094e-01_r8,6.6621e-01_r8,4.4433e-01_r8/)
      kao(:, 5, 5, 6) = (/ &
     &5.7098e-01_r8,5.5310e-01_r8,7.2743e-01_r8,7.3939e-01_r8,7.3730e-01_r8,6.8982e-01_r8, &
     &6.6680e-01_r8,6.6632e-01_r8,3.5896e-01_r8/)
      kao(:, 1, 6, 6) = (/ &
     &5.2885e-01_r8,5.1244e-01_r8,7.5494e-01_r8,7.8724e-01_r8,7.7080e-01_r8,7.0256e-01_r8, &
     &6.2568e-01_r8,5.6883e-01_r8,6.4732e-01_r8/)
      kao(:, 2, 6, 6) = (/ &
     &5.0860e-01_r8,4.9747e-01_r8,7.1101e-01_r8,7.4294e-01_r8,7.2488e-01_r8,6.6139e-01_r8, &
     &6.0894e-01_r8,5.7630e-01_r8,5.5132e-01_r8/)
      kao(:, 3, 6, 6) = (/ &
     &4.9680e-01_r8,4.8858e-01_r8,6.8601e-01_r8,7.0262e-01_r8,6.9083e-01_r8,6.2832e-01_r8, &
     &5.9581e-01_r8,5.8177e-01_r8,4.5843e-01_r8/)
      kao(:, 4, 6, 6) = (/ &
     &4.8828e-01_r8,4.9338e-01_r8,6.6185e-01_r8,6.8834e-01_r8,6.6433e-01_r8,6.1518e-01_r8, &
     &5.9405e-01_r8,5.8713e-01_r8,3.7286e-01_r8/)
      kao(:, 5, 6, 6) = (/ &
     &4.7758e-01_r8,5.0393e-01_r8,6.4306e-01_r8,6.6695e-01_r8,6.4365e-01_r8,6.0629e-01_r8, &
     &5.9623e-01_r8,5.8994e-01_r8,3.0878e-01_r8/)
      kao(:, 1, 7, 6) = (/ &
     &4.5544e-01_r8,5.1675e-01_r8,6.9040e-01_r8,7.2442e-01_r8,6.9583e-01_r8,6.2374e-01_r8, &
     &5.5330e-01_r8,4.9819e-01_r8,5.7066e-01_r8/)
      kao(:, 2, 7, 6) = (/ &
     &4.3526e-01_r8,5.2433e-01_r8,6.5887e-01_r8,6.7132e-01_r8,6.4888e-01_r8,5.8229e-01_r8, &
     &5.3592e-01_r8,5.0387e-01_r8,4.7263e-01_r8/)
      kao(:, 3, 7, 6) = (/ &
     &4.2386e-01_r8,5.3503e-01_r8,6.2067e-01_r8,6.3646e-01_r8,6.0983e-01_r8,5.5722e-01_r8, &
     &5.2827e-01_r8,5.1003e-01_r8,3.8891e-01_r8/)
      kao(:, 4, 7, 6) = (/ &
     &4.1478e-01_r8,5.3714e-01_r8,5.9921e-01_r8,6.0957e-01_r8,5.8334e-01_r8,5.4159e-01_r8, &
     &5.2418e-01_r8,5.1278e-01_r8,3.1885e-01_r8/)
      kao(:, 5, 7, 6) = (/ &
     &4.0467e-01_r8,5.2009e-01_r8,5.7701e-01_r8,5.8575e-01_r8,5.6859e-01_r8,5.4155e-01_r8, &
     &5.3930e-01_r8,5.1710e-01_r8,2.6235e-01_r8/)
      kao(:, 1, 8, 6) = (/ &
     &4.0091e-01_r8,5.6115e-01_r8,6.4335e-01_r8,6.5229e-01_r8,6.2013e-01_r8,5.5832e-01_r8, &
     &4.9333e-01_r8,4.3362e-01_r8,5.1143e-01_r8/)
      kao(:, 2, 8, 6) = (/ &
     &3.8169e-01_r8,5.2953e-01_r8,5.9829e-01_r8,6.0811e-01_r8,5.7734e-01_r8,5.1950e-01_r8, &
     &4.7393e-01_r8,4.3986e-01_r8,4.2322e-01_r8/)
      kao(:, 3, 8, 6) = (/ &
     &3.7078e-01_r8,5.0436e-01_r8,5.6958e-01_r8,5.7197e-01_r8,5.3831e-01_r8,4.9299e-01_r8, &
     &4.6737e-01_r8,4.4557e-01_r8,3.4628e-01_r8/)
      kao(:, 4, 8, 6) = (/ &
     &3.6161e-01_r8,4.8989e-01_r8,5.4426e-01_r8,5.4657e-01_r8,5.1938e-01_r8,4.8189e-01_r8, &
     &4.6346e-01_r8,4.4852e-01_r8,2.8491e-01_r8/)
      kao(:, 5, 8, 6) = (/ &
     &3.5235e-01_r8,4.6785e-01_r8,5.2499e-01_r8,5.2434e-01_r8,5.0210e-01_r8,4.7954e-01_r8, &
     &4.8680e-01_r8,4.5258e-01_r8,2.3809e-01_r8/)
      kao(:, 1, 9, 6) = (/ &
     &3.5188e-01_r8,5.0784e-01_r8,5.8680e-01_r8,5.8599e-01_r8,5.5453e-01_r8,4.9355e-01_r8, &
     &4.3434e-01_r8,3.7345e-01_r8,4.5760e-01_r8/)
      kao(:, 2, 9, 6) = (/ &
     &3.3384e-01_r8,4.7725e-01_r8,5.4527e-01_r8,5.4039e-01_r8,5.1277e-01_r8,4.6053e-01_r8, &
     &4.1752e-01_r8,3.8054e-01_r8,3.7664e-01_r8/)
      kao(:, 3, 9, 6) = (/ &
     &3.2337e-01_r8,4.6079e-01_r8,5.0889e-01_r8,5.0540e-01_r8,4.8167e-01_r8,4.3259e-01_r8, &
     &4.1005e-01_r8,3.8447e-01_r8,3.0502e-01_r8/)
      kao(:, 4, 9, 6) = (/ &
     &3.1489e-01_r8,4.4224e-01_r8,4.8906e-01_r8,4.8098e-01_r8,4.5962e-01_r8,4.2889e-01_r8, &
     &4.1407e-01_r8,3.8891e-01_r8,2.4901e-01_r8/)
      kao(:, 5, 9, 6) = (/ &
     &3.0731e-01_r8,4.2604e-01_r8,4.6542e-01_r8,4.6457e-01_r8,4.4425e-01_r8,4.2325e-01_r8, &
     &4.3000e-01_r8,3.9500e-01_r8,2.1365e-01_r8/)
      kao(:, 1,10, 6) = (/ &
     &3.0872e-01_r8,4.6438e-01_r8,5.2605e-01_r8,5.1940e-01_r8,4.8758e-01_r8,4.3435e-01_r8, &
     &3.8048e-01_r8,3.2415e-01_r8,4.0329e-01_r8/)
      kao(:, 2,10, 6) = (/ &
     &2.9295e-01_r8,4.4115e-01_r8,4.8348e-01_r8,4.7740e-01_r8,4.4909e-01_r8,4.0221e-01_r8, &
     &3.6624e-01_r8,3.2721e-01_r8,3.3011e-01_r8/)
      kao(:, 3,10, 6) = (/ &
     &2.8328e-01_r8,4.1772e-01_r8,4.5515e-01_r8,4.4741e-01_r8,4.2330e-01_r8,3.8012e-01_r8, &
     &3.5851e-01_r8,3.3085e-01_r8,2.6425e-01_r8/)
      kao(:, 4,10, 6) = (/ &
     &2.7562e-01_r8,4.0009e-01_r8,4.2827e-01_r8,4.2695e-01_r8,4.0250e-01_r8,3.7844e-01_r8, &
     &3.6844e-01_r8,3.3695e-01_r8,2.1886e-01_r8/)
      kao(:, 5,10, 6) = (/ &
     &2.6849e-01_r8,3.8403e-01_r8,4.1066e-01_r8,4.0861e-01_r8,3.9231e-01_r8,3.7926e-01_r8, &
     &3.7696e-01_r8,3.4332e-01_r8,1.9262e-01_r8/)
      kao(:, 1,11, 6) = (/ &
     &2.6466e-01_r8,4.1355e-01_r8,4.4454e-01_r8,4.4042e-01_r8,4.1233e-01_r8,3.6752e-01_r8, &
     &3.2678e-01_r8,2.7894e-01_r8,3.2749e-01_r8/)
      kao(:, 2,11, 6) = (/ &
     &2.5291e-01_r8,3.8781e-01_r8,4.1430e-01_r8,4.0659e-01_r8,3.8277e-01_r8,3.4153e-01_r8, &
     &3.1495e-01_r8,2.7988e-01_r8,2.6257e-01_r8/)
      kao(:, 3,11, 6) = (/ &
     &2.4541e-01_r8,3.7100e-01_r8,3.8849e-01_r8,3.8315e-01_r8,3.6055e-01_r8,3.3569e-01_r8, &
     &3.1896e-01_r8,2.8851e-01_r8,2.1720e-01_r8/)
      kao(:, 4,11, 6) = (/ &
     &2.3761e-01_r8,3.4992e-01_r8,3.7138e-01_r8,3.6645e-01_r8,3.4895e-01_r8,3.3415e-01_r8, &
     &3.2576e-01_r8,2.9375e-01_r8,1.9101e-01_r8/)
      kao(:, 5,11, 6) = (/ &
     &2.3136e-01_r8,3.3422e-01_r8,3.5550e-01_r8,3.5462e-01_r8,3.4596e-01_r8,3.4410e-01_r8, &
     &3.3336e-01_r8,3.0010e-01_r8,1.7683e-01_r8/)
      kao(:, 1,12, 6) = (/ &
     &2.3099e-01_r8,3.6467e-01_r8,3.8654e-01_r8,3.7740e-01_r8,3.5454e-01_r8,3.1341e-01_r8, &
     &2.8207e-01_r8,2.4141e-01_r8,2.7098e-01_r8/)
      kao(:, 2,12, 6) = (/ &
     &2.2244e-01_r8,3.4190e-01_r8,3.5753e-01_r8,3.5048e-01_r8,3.3109e-01_r8,2.9786e-01_r8, &
     &2.7909e-01_r8,2.4469e-01_r8,2.1730e-01_r8/)
      kao(:, 3,12, 6) = (/ &
     &2.1694e-01_r8,3.2183e-01_r8,3.3982e-01_r8,3.3193e-01_r8,3.1521e-01_r8,2.9823e-01_r8, &
     &2.8101e-01_r8,2.4988e-01_r8,1.8539e-01_r8/)
      kao(:, 4,12, 6) = (/ &
     &2.1365e-01_r8,3.0582e-01_r8,3.2214e-01_r8,3.1915e-01_r8,3.0963e-01_r8,3.0101e-01_r8, &
     &2.9010e-01_r8,2.5511e-01_r8,1.7246e-01_r8/)
      kao(:, 5,12, 6) = (/ &
     &2.1126e-01_r8,2.9440e-01_r8,3.1065e-01_r8,3.1395e-01_r8,3.1604e-01_r8,3.0993e-01_r8, &
     &2.9537e-01_r8,2.6162e-01_r8,1.5291e-01_r8/)
      kao(:, 1,13, 6) = (/ &
     &2.2386e-01_r8,3.3097e-01_r8,3.4162e-01_r8,3.3327e-01_r8,3.1314e-01_r8,2.7728e-01_r8, &
     &2.5014e-01_r8,2.1154e-01_r8,2.3428e-01_r8/)
      kao(:, 2,13, 6) = (/ &
     &2.2040e-01_r8,3.1261e-01_r8,3.2237e-01_r8,3.1373e-01_r8,2.9682e-01_r8,2.6651e-01_r8, &
     &2.5032e-01_r8,2.1702e-01_r8,1.9039e-01_r8/)
      kao(:, 3,13, 6) = (/ &
     &2.1610e-01_r8,2.9730e-01_r8,3.0955e-01_r8,3.0133e-01_r8,2.8651e-01_r8,2.7201e-01_r8, &
     &2.5430e-01_r8,2.2027e-01_r8,1.6665e-01_r8/)
      kao(:, 4,13, 6) = (/ &
     &2.1312e-01_r8,2.8629e-01_r8,2.9748e-01_r8,2.9400e-01_r8,2.8967e-01_r8,2.7599e-01_r8, &
     &2.5853e-01_r8,2.2523e-01_r8,1.5373e-01_r8/)
      kao(:, 5,13, 6) = (/ &
     &2.0806e-01_r8,2.7757e-01_r8,2.8967e-01_r8,2.9354e-01_r8,2.9376e-01_r8,2.8253e-01_r8, &
     &2.6218e-01_r8,2.3101e-01_r8,1.3574e-01_r8/)
      kao(:, 1, 1, 7) = (/ &
     &3.5613e+00_r8,3.1188e+00_r8,2.6764e+00_r8,2.2340e+00_r8,1.7917e+00_r8,1.6352e+00_r8, &
     &1.8092e+00_r8,1.6379e+00_r8,2.7539e-02_r8/)
      kao(:, 2, 1, 7) = (/ &
     &3.4002e+00_r8,2.9785e+00_r8,2.5569e+00_r8,2.1349e+00_r8,1.7133e+00_r8,1.7200e+00_r8, &
     &1.7738e+00_r8,1.6325e+00_r8,3.6313e-02_r8/)
      kao(:, 3, 1, 7) = (/ &
     &3.2557e+00_r8,2.8529e+00_r8,2.4503e+00_r8,2.0478e+00_r8,1.6479e+00_r8,1.7947e+00_r8, &
     &1.7613e+00_r8,1.6123e+00_r8,7.9598e-02_r8/)
      kao(:, 4, 1, 7) = (/ &
     &3.1418e+00_r8,2.7541e+00_r8,2.3673e+00_r8,1.9817e+00_r8,1.6011e+00_r8,1.8327e+00_r8, &
     &1.7198e+00_r8,1.6148e+00_r8,2.1944e-01_r8/)
      kao(:, 5, 1, 7) = (/ &
     &3.1204e+00_r8,2.7380e+00_r8,2.3562e+00_r8,1.9785e+00_r8,1.6099e+00_r8,1.8773e+00_r8, &
     &1.7180e+00_r8,1.6127e+00_r8,2.9776e-01_r8/)
      kao(:, 1, 2, 7) = (/ &
     &2.9874e+00_r8,2.6163e+00_r8,2.2453e+00_r8,1.8746e+00_r8,1.5312e+00_r8,1.8525e+00_r8, &
     &1.7071e+00_r8,1.5893e+00_r8,5.1776e-01_r8/)
      kao(:, 2, 2, 7) = (/ &
     &2.8505e+00_r8,2.4972e+00_r8,2.1440e+00_r8,1.7909e+00_r8,1.5966e+00_r8,1.8306e+00_r8, &
     &1.6863e+00_r8,1.5842e+00_r8,4.3879e-01_r8/)
      kao(:, 3, 2, 7) = (/ &
     &2.7350e+00_r8,2.3969e+00_r8,2.0589e+00_r8,1.7214e+00_r8,1.6370e+00_r8,1.7877e+00_r8, &
     &1.6805e+00_r8,1.5918e+00_r8,4.1523e-01_r8/)
      kao(:, 4, 2, 7) = (/ &
     &2.6409e+00_r8,2.3156e+00_r8,1.9935e+00_r8,1.6727e+00_r8,1.6830e+00_r8,1.7575e+00_r8, &
     &1.6634e+00_r8,1.5980e+00_r8,2.9373e-01_r8/)
      kao(:, 5, 2, 7) = (/ &
     &2.5886e+00_r8,2.2740e+00_r8,1.9607e+00_r8,1.6497e+00_r8,1.7391e+00_r8,1.7232e+00_r8, &
     &1.6344e+00_r8,1.6105e+00_r8,1.8509e-01_r8/)
      kao(:, 1, 3, 7) = (/ &
     &2.5285e+00_r8,2.2147e+00_r8,1.9010e+00_r8,1.5874e+00_r8,1.8079e+00_r8,1.7347e+00_r8, &
     &1.6267e+00_r8,1.5173e+00_r8,4.9543e-01_r8/)
      kao(:, 2, 3, 7) = (/ &
     &2.4109e+00_r8,2.1124e+00_r8,1.8139e+00_r8,1.5156e+00_r8,1.7831e+00_r8,1.7011e+00_r8, &
     &1.6143e+00_r8,1.5141e+00_r8,4.4268e-01_r8/)
      kao(:, 3, 3, 7) = (/ &
     &2.3122e+00_r8,2.0266e+00_r8,1.7413e+00_r8,1.4891e+00_r8,1.7442e+00_r8,1.6741e+00_r8, &
     &1.6075e+00_r8,1.5297e+00_r8,3.4522e-01_r8/)
      kao(:, 4, 3, 7) = (/ &
     &2.2338e+00_r8,1.9602e+00_r8,1.6889e+00_r8,1.5208e+00_r8,1.7228e+00_r8,1.6317e+00_r8, &
     &1.5933e+00_r8,1.5434e+00_r8,2.1394e-01_r8/)
      kao(:, 5, 3, 7) = (/ &
     &2.1901e+00_r8,1.9250e+00_r8,1.6600e+00_r8,1.5510e+00_r8,1.6972e+00_r8,1.6258e+00_r8, &
     &1.5808e+00_r8,1.5686e+00_r8,1.5097e-01_r8/)
      kao(:, 1, 4, 7) = (/ &
     &2.1490e+00_r8,1.8824e+00_r8,1.6159e+00_r8,1.5783e+00_r8,1.6916e+00_r8,1.6097e+00_r8, &
     &1.5676e+00_r8,1.4069e+00_r8,5.0896e-01_r8/)
      kao(:, 2, 4, 7) = (/ &
     &2.0429e+00_r8,1.7900e+00_r8,1.5373e+00_r8,1.6130e+00_r8,1.6613e+00_r8,1.5828e+00_r8, &
     &1.5388e+00_r8,1.4176e+00_r8,3.7374e-01_r8/)
      kao(:, 3, 4, 7) = (/ &
     &1.9560e+00_r8,1.7146e+00_r8,1.4748e+00_r8,1.6326e+00_r8,1.6129e+00_r8,1.5608e+00_r8, &
     &1.5146e+00_r8,1.4336e+00_r8,2.6187e-01_r8/)
      kao(:, 4, 4, 7) = (/ &
     &1.8914e+00_r8,1.6603e+00_r8,1.4322e+00_r8,1.6118e+00_r8,1.5843e+00_r8,1.5418e+00_r8, &
     &1.4880e+00_r8,1.4608e+00_r8,1.8007e-01_r8/)
      kao(:, 5, 4, 7) = (/ &
     &1.8569e+00_r8,1.6328e+00_r8,1.4097e+00_r8,1.6022e+00_r8,1.5587e+00_r8,1.5446e+00_r8, &
     &1.4805e+00_r8,1.4912e+00_r8,1.1749e-01_r8/)
      kao(:, 1, 5, 7) = (/ &
     &1.8276e+00_r8,1.6010e+00_r8,1.3745e+00_r8,1.6030e+00_r8,1.5630e+00_r8,1.5166e+00_r8, &
     &1.4457e+00_r8,1.2855e+00_r8,4.3144e-01_r8/)
      kao(:, 2, 5, 7) = (/ &
     &1.7325e+00_r8,1.5182e+00_r8,1.3289e+00_r8,1.5483e+00_r8,1.5172e+00_r8,1.4962e+00_r8, &
     &1.4204e+00_r8,1.2974e+00_r8,3.2532e-01_r8/)
      kao(:, 3, 5, 7) = (/ &
     &1.6556e+00_r8,1.4514e+00_r8,1.3491e+00_r8,1.5022e+00_r8,1.4839e+00_r8,1.4801e+00_r8, &
     &1.3899e+00_r8,1.3214e+00_r8,2.2874e-01_r8/)
      kao(:, 4, 5, 7) = (/ &
     &1.6008e+00_r8,1.4058e+00_r8,1.3614e+00_r8,1.4817e+00_r8,1.4667e+00_r8,1.4542e+00_r8, &
     &1.3728e+00_r8,1.3543e+00_r8,1.4774e-01_r8/)
      kao(:, 5, 5, 7) = (/ &
     &1.5722e+00_r8,1.3835e+00_r8,1.3910e+00_r8,1.4609e+00_r8,1.4510e+00_r8,1.4341e+00_r8, &
     &1.3580e+00_r8,1.3940e+00_r8,9.9947e-02_r8/)
      kao(:, 1, 6, 7) = (/ &
     &1.5600e+00_r8,1.3665e+00_r8,1.3891e+00_r8,1.4520e+00_r8,1.4361e+00_r8,1.4207e+00_r8, &
     &1.3105e+00_r8,1.1513e+00_r8,3.8692e-01_r8/)
      kao(:, 2, 6, 7) = (/ &
     &1.4739e+00_r8,1.2917e+00_r8,1.3972e+00_r8,1.4114e+00_r8,1.4085e+00_r8,1.3840e+00_r8, &
     &1.2763e+00_r8,1.1653e+00_r8,2.7607e-01_r8/)
      kao(:, 3, 6, 7) = (/ &
     &1.4042e+00_r8,1.2317e+00_r8,1.3535e+00_r8,1.3731e+00_r8,1.3834e+00_r8,1.3540e+00_r8, &
     &1.2537e+00_r8,1.1954e+00_r8,1.8549e-01_r8/)
      kao(:, 4, 6, 7) = (/ &
     &1.3553e+00_r8,1.1909e+00_r8,1.3235e+00_r8,1.3411e+00_r8,1.3606e+00_r8,1.3282e+00_r8, &
     &1.2356e+00_r8,1.2339e+00_r8,1.3113e-01_r8/)
      kao(:, 5, 6, 7) = (/ &
     &1.3290e+00_r8,1.1708e+00_r8,1.3052e+00_r8,1.3291e+00_r8,1.3435e+00_r8,1.3084e+00_r8, &
     &1.2394e+00_r8,1.2789e+00_r8,8.5104e-02_r8/)
      kao(:, 1, 7, 7) = (/ &
     &1.3486e+00_r8,1.1821e+00_r8,1.3320e+00_r8,1.3296e+00_r8,1.3530e+00_r8,1.2921e+00_r8, &
     &1.1792e+00_r8,1.0146e+00_r8,3.3967e-01_r8/)
      kao(:, 2, 7, 7) = (/ &
     &1.2698e+00_r8,1.1140e+00_r8,1.2658e+00_r8,1.2934e+00_r8,1.3084e+00_r8,1.2591e+00_r8, &
     &1.1496e+00_r8,1.0323e+00_r8,2.4089e-01_r8/)
      kao(:, 3, 7, 7) = (/ &
     &1.2066e+00_r8,1.0597e+00_r8,1.2265e+00_r8,1.2606e+00_r8,1.2717e+00_r8,1.2202e+00_r8, &
     &1.1236e+00_r8,1.0630e+00_r8,1.6653e-01_r8/)
      kao(:, 4, 7, 7) = (/ &
     &1.1624e+00_r8,1.0337e+00_r8,1.1938e+00_r8,1.2388e+00_r8,1.2436e+00_r8,1.1958e+00_r8, &
     &1.1143e+00_r8,1.1071e+00_r8,1.1640e-01_r8/)
      kao(:, 5, 7, 7) = (/ &
     &1.1373e+00_r8,1.0419e+00_r8,1.1824e+00_r8,1.2289e+00_r8,1.2206e+00_r8,1.1715e+00_r8, &
     &1.1114e+00_r8,1.1517e+00_r8,7.1520e-02_r8/)
      kao(:, 1, 8, 7) = (/ &
     &1.1959e+00_r8,1.0587e+00_r8,1.2168e+00_r8,1.2562e+00_r8,1.2533e+00_r8,1.1755e+00_r8, &
     &1.0535e+00_r8,8.9257e-01_r8,2.9562e-01_r8/)
      kao(:, 2, 8, 7) = (/ &
     &1.1212e+00_r8,1.0393e+00_r8,1.1676e+00_r8,1.2170e+00_r8,1.2001e+00_r8,1.1361e+00_r8, &
     &1.0253e+00_r8,9.0430e-01_r8,2.1449e-01_r8/)
      kao(:, 3, 8, 7) = (/ &
     &1.0601e+00_r8,1.0297e+00_r8,1.1266e+00_r8,1.1809e+00_r8,1.1623e+00_r8,1.1020e+00_r8, &
     &1.0023e+00_r8,9.3591e-01_r8,1.5382e-01_r8/)
      kao(:, 4, 8, 7) = (/ &
     &1.0187e+00_r8,1.0227e+00_r8,1.0991e+00_r8,1.1460e+00_r8,1.1243e+00_r8,1.0751e+00_r8, &
     &9.9421e-01_r8,9.7855e-01_r8,1.0944e-01_r8/)
      kao(:, 5, 8, 7) = (/ &
     &9.9531e-01_r8,1.0219e+00_r8,1.0832e+00_r8,1.1243e+00_r8,1.1050e+00_r8,1.0609e+00_r8, &
     &9.9136e-01_r8,1.0252e+00_r8,7.0614e-02_r8/)
      kao(:, 1, 9, 7) = (/ &
     &1.0539e+00_r8,1.0559e+00_r8,1.1142e+00_r8,1.1729e+00_r8,1.1295e+00_r8,1.0580e+00_r8, &
     &9.3382e-01_r8,7.7194e-01_r8,2.7489e-01_r8/)
      kao(:, 2, 9, 7) = (/ &
     &9.8392e-01_r8,1.0263e+00_r8,1.0713e+00_r8,1.1148e+00_r8,1.0796e+00_r8,1.0137e+00_r8, &
     &9.0260e-01_r8,7.8234e-01_r8,1.9796e-01_r8/)
      kao(:, 3, 9, 7) = (/ &
     &9.2807e-01_r8,9.7104e-01_r8,1.0401e+00_r8,1.0698e+00_r8,1.0381e+00_r8,9.8279e-01_r8, &
     &8.8087e-01_r8,8.1424e-01_r8,1.4396e-01_r8/)
      kao(:, 4, 9, 7) = (/ &
     &8.9022e-01_r8,9.3422e-01_r8,1.0109e+00_r8,1.0366e+00_r8,1.0048e+00_r8,9.5511e-01_r8, &
     &8.7539e-01_r8,8.5432e-01_r8,1.0430e-01_r8/)
      kao(:, 5, 9, 7) = (/ &
     &8.6877e-01_r8,9.2050e-01_r8,1.0000e+00_r8,1.0116e+00_r8,9.8826e-01_r8,9.4009e-01_r8, &
     &8.7922e-01_r8,9.0156e-01_r8,6.8077e-02_r8/)
      kao(:, 1,10, 7) = (/ &
     &9.2527e-01_r8,9.7705e-01_r8,1.0325e+00_r8,1.0578e+00_r8,1.0149e+00_r8,9.3478e-01_r8, &
     &8.1724e-01_r8,6.6415e-01_r8,2.3891e-01_r8/)
      kao(:, 2,10, 7) = (/ &
     &8.6097e-01_r8,9.1106e-01_r8,9.9506e-01_r8,1.0007e+00_r8,9.6610e-01_r8,8.9639e-01_r8, &
     &7.8861e-01_r8,6.7596e-01_r8,1.7815e-01_r8/)
      kao(:, 3,10, 7) = (/ &
     &8.1181e-01_r8,8.7070e-01_r8,9.5033e-01_r8,9.5476e-01_r8,9.2168e-01_r8,8.6431e-01_r8, &
     &7.7032e-01_r8,7.0318e-01_r8,1.3199e-01_r8/)
      kao(:, 4,10, 7) = (/ &
     &7.7887e-01_r8,8.4520e-01_r8,9.2163e-01_r8,9.1956e-01_r8,8.9130e-01_r8,8.3659e-01_r8, &
     &7.6501e-01_r8,7.4145e-01_r8,9.1831e-02_r8/)
      kao(:, 5,10, 7) = (/ &
     &7.5933e-01_r8,8.3227e-01_r8,9.0273e-01_r8,9.0188e-01_r8,8.7623e-01_r8,8.2773e-01_r8, &
     &7.7824e-01_r8,7.8260e-01_r8,6.3171e-02_r8/)
      kao(:, 1,11, 7) = (/ &
     &7.8226e-01_r8,8.4719e-01_r8,9.2612e-01_r8,9.1570e-01_r8,8.7421e-01_r8,8.0479e-01_r8, &
     &6.9799e-01_r8,5.7039e-01_r8,1.8643e-01_r8/)
      kao(:, 2,11, 7) = (/ &
     &7.3229e-01_r8,8.0376e-01_r8,8.7472e-01_r8,8.6879e-01_r8,8.2958e-01_r8,7.6891e-01_r8, &
     &6.7602e-01_r8,5.8714e-01_r8,1.4000e-01_r8/)
      kao(:, 3,11, 7) = (/ &
     &6.9599e-01_r8,7.7478e-01_r8,8.4133e-01_r8,8.3314e-01_r8,7.9919e-01_r8,7.4119e-01_r8, &
     &6.6696e-01_r8,6.1671e-01_r8,1.0181e-01_r8/)
      kao(:, 4,11, 7) = (/ &
     &6.7489e-01_r8,7.6185e-01_r8,8.1367e-01_r8,8.1128e-01_r8,7.7952e-01_r8,7.3228e-01_r8, &
     &6.7358e-01_r8,6.5125e-01_r8,7.0225e-02_r8/)
      kao(:, 5,11, 7) = (/ &
     &6.5905e-01_r8,7.5391e-01_r8,7.9725e-01_r8,7.9623e-01_r8,7.7236e-01_r8,7.3477e-01_r8, &
     &6.9321e-01_r8,6.9245e-01_r8,4.7555e-02_r8/)
      kao(:, 1,12, 7) = (/ &
     &6.7862e-01_r8,7.6075e-01_r8,8.1212e-01_r8,7.9974e-01_r8,7.5616e-01_r8,6.9320e-01_r8, &
     &5.9851e-01_r8,4.9309e-01_r8,1.4949e-01_r8/)
      kao(:, 2,12, 7) = (/ &
     &6.3807e-01_r8,7.3022e-01_r8,7.7190e-01_r8,7.6245e-01_r8,7.2390e-01_r8,6.6782e-01_r8, &
     &5.8563e-01_r8,5.1153e-01_r8,1.1607e-01_r8/)
      kao(:, 3,12, 7) = (/ &
     &6.1294e-01_r8,7.1220e-01_r8,7.4125e-01_r8,7.3342e-01_r8,6.9810e-01_r8,6.4969e-01_r8, &
     &5.8866e-01_r8,5.3877e-01_r8,8.5989e-02_r8/)
      kao(:, 4,12, 7) = (/ &
     &5.9734e-01_r8,7.0046e-01_r8,7.2548e-01_r8,7.1635e-01_r8,6.8868e-01_r8,6.5109e-01_r8, &
     &5.9747e-01_r8,5.7263e-01_r8,5.7849e-02_r8/)
      kao(:, 5,12, 7) = (/ &
     &5.8148e-01_r8,6.8644e-01_r8,7.1487e-01_r8,7.0660e-01_r8,6.8790e-01_r8,6.6368e-01_r8, &
     &6.1903e-01_r8,6.0994e-01_r8,3.8734e-02_r8/)
      kao(:, 1,13, 7) = (/ &
     &6.1552e-01_r8,7.1356e-01_r8,7.3721e-01_r8,7.1646e-01_r8,6.7473e-01_r8,6.1507e-01_r8, &
     &5.2767e-01_r8,4.3311e-01_r8,1.2482e-01_r8/)
      kao(:, 2,13, 7) = (/ &
     &5.8292e-01_r8,6.8409e-01_r8,7.0235e-01_r8,6.8503e-01_r8,6.4503e-01_r8,5.9514e-01_r8, &
     &5.2204e-01_r8,4.4742e-01_r8,9.8236e-02_r8/)
      kao(:, 3,13, 7) = (/ &
     &5.6436e-01_r8,6.6497e-01_r8,6.8075e-01_r8,6.6573e-01_r8,6.3039e-01_r8,5.8718e-01_r8, &
     &5.2651e-01_r8,4.7434e-01_r8,7.2297e-02_r8/)
      kao(:, 4,13, 7) = (/ &
     &5.4811e-01_r8,6.4832e-01_r8,6.6742e-01_r8,6.5348e-01_r8,6.2977e-01_r8,5.9747e-01_r8, &
     &5.3863e-01_r8,5.0502e-01_r8,5.7494e-02_r8/)
      kao(:, 5,13, 7) = (/ &
     &5.3739e-01_r8,6.3448e-01_r8,6.5434e-01_r8,6.4659e-01_r8,6.3825e-01_r8,6.0640e-01_r8, &
     &5.6100e-01_r8,5.4046e-01_r8,3.2048e-02_r8/)
      kao(:, 1, 1, 8) = (/ &
     &1.1660e+01_r8,1.0203e+01_r8,8.7459e+00_r8,7.2889e+00_r8,5.8318e+00_r8,4.3748e+00_r8, &
     &3.7766e+00_r8,3.7739e+00_r8,2.3608e-03_r8/)
      kao(:, 2, 1, 8) = (/ &
     &1.1346e+01_r8,9.9282e+00_r8,8.5104e+00_r8,7.0926e+00_r8,5.6748e+00_r8,4.2570e+00_r8, &
     &3.8721e+00_r8,3.9057e+00_r8,3.1824e-03_r8/)
      kao(:, 3, 1, 8) = (/ &
     &1.1194e+01_r8,9.7951e+00_r8,8.3963e+00_r8,6.9976e+00_r8,5.5988e+00_r8,4.2000e+00_r8, &
     &3.9469e+00_r8,4.0712e+00_r8,4.2520e-03_r8/)
      kao(:, 4, 1, 8) = (/ &
     &1.1228e+01_r8,9.8250e+00_r8,8.4220e+00_r8,7.0189e+00_r8,5.6159e+00_r8,4.2457e+00_r8, &
     &4.0615e+00_r8,4.2140e+00_r8,1.1766e-02_r8/)
      kao(:, 5, 1, 8) = (/ &
     &1.1405e+01_r8,9.9798e+00_r8,8.5545e+00_r8,7.1289e+00_r8,5.7036e+00_r8,4.3747e+00_r8, &
     &4.1857e+00_r8,4.3557e+00_r8,1.5766e-01_r8/)
      kao(:, 1, 2, 8) = (/ &
     &9.6985e+00_r8,8.4867e+00_r8,7.2748e+00_r8,6.0630e+00_r8,4.8511e+00_r8,3.9524e+00_r8, &
     &3.9347e+00_r8,3.7679e+00_r8,7.6708e-02_r8/)
      kao(:, 2, 2, 8) = (/ &
     &9.4032e+00_r8,8.2283e+00_r8,7.0533e+00_r8,5.8784e+00_r8,4.7035e+00_r8,3.9843e+00_r8, &
     &4.0089e+00_r8,3.9489e+00_r8,9.1596e-02_r8/)
      kao(:, 3, 2, 8) = (/ &
     &9.2359e+00_r8,8.0819e+00_r8,6.9278e+00_r8,5.7738e+00_r8,4.6198e+00_r8,4.0563e+00_r8, &
     &4.1174e+00_r8,4.1185e+00_r8,7.3144e-02_r8/)
      kao(:, 4, 2, 8) = (/ &
     &9.2178e+00_r8,8.0660e+00_r8,6.9143e+00_r8,5.7625e+00_r8,4.6107e+00_r8,4.1515e+00_r8, &
     &4.2394e+00_r8,4.2904e+00_r8,1.1674e-01_r8/)
      kao(:, 5, 2, 8) = (/ &
     &9.3781e+00_r8,8.2055e+00_r8,7.0329e+00_r8,5.8605e+00_r8,4.6883e+00_r8,4.2988e+00_r8, &
     &4.3503e+00_r8,4.4505e+00_r8,1.2134e-01_r8/)
      kao(:, 1, 3, 8) = (/ &
     &8.1381e+00_r8,7.1213e+00_r8,6.1045e+00_r8,5.0877e+00_r8,4.0880e+00_r8,4.0519e+00_r8, &
     &3.8139e+00_r8,3.6880e+00_r8,8.7204e-02_r8/)
      kao(:, 2, 3, 8) = (/ &
     &7.8478e+00_r8,6.8673e+00_r8,5.8868e+00_r8,4.9063e+00_r8,4.0625e+00_r8,4.0788e+00_r8, &
     &3.9290e+00_r8,3.8689e+00_r8,6.5887e-02_r8/)
      kao(:, 3, 3, 8) = (/ &
     &7.6555e+00_r8,6.6990e+00_r8,5.7426e+00_r8,4.7861e+00_r8,4.0779e+00_r8,4.1101e+00_r8, &
     &4.0765e+00_r8,4.0574e+00_r8,7.1216e-02_r8/)
      kao(:, 4, 3, 8) = (/ &
     &7.5783e+00_r8,6.6314e+00_r8,5.6846e+00_r8,4.7378e+00_r8,4.1353e+00_r8,4.1781e+00_r8, &
     &4.2207e+00_r8,4.2405e+00_r8,8.4339e-02_r8/)
      kao(:, 5, 3, 8) = (/ &
     &7.6543e+00_r8,6.6980e+00_r8,5.7416e+00_r8,4.7853e+00_r8,4.2544e+00_r8,4.2669e+00_r8, &
     &4.4018e+00_r8,4.4237e+00_r8,7.8612e-02_r8/)
      kao(:, 1, 4, 8) = (/ &
     &6.8589e+00_r8,6.0020e+00_r8,5.1451e+00_r8,4.2882e+00_r8,3.9706e+00_r8,3.8613e+00_r8, &
     &3.5947e+00_r8,3.5300e+00_r8,6.1710e-02_r8/)
      kao(:, 2, 4, 8) = (/ &
     &6.5794e+00_r8,5.7574e+00_r8,4.9355e+00_r8,4.1135e+00_r8,3.9575e+00_r8,3.8878e+00_r8, &
     &3.7477e+00_r8,3.7212e+00_r8,6.0817e-02_r8/)
      kao(:, 3, 4, 8) = (/ &
     &6.3760e+00_r8,5.5795e+00_r8,4.7829e+00_r8,3.9985e+00_r8,3.9783e+00_r8,3.9606e+00_r8, &
     &3.9214e+00_r8,3.9164e+00_r8,6.3574e-02_r8/)
      kao(:, 4, 4, 8) = (/ &
     &6.2600e+00_r8,5.4779e+00_r8,4.6959e+00_r8,4.0045e+00_r8,4.0114e+00_r8,4.0769e+00_r8, &
     &4.1164e+00_r8,4.1060e+00_r8,7.8132e-02_r8/)
      kao(:, 5, 4, 8) = (/ &
     &6.2608e+00_r8,5.4787e+00_r8,4.6966e+00_r8,4.0716e+00_r8,4.0797e+00_r8,4.1992e+00_r8, &
     &4.3140e+00_r8,4.3043e+00_r8,7.5353e-02_r8/)
      kao(:, 1, 5, 8) = (/ &
     &5.7927e+00_r8,5.0691e+00_r8,4.3455e+00_r8,3.8105e+00_r8,3.8237e+00_r8,3.5526e+00_r8, &
     &3.3728e+00_r8,3.3373e+00_r8,4.9756e-02_r8/)
      kao(:, 2, 5, 8) = (/ &
     &5.5277e+00_r8,4.8372e+00_r8,4.1467e+00_r8,3.7691e+00_r8,3.7793e+00_r8,3.6108e+00_r8, &
     &3.5410e+00_r8,3.5220e+00_r8,4.2289e-02_r8/)
      kao(:, 3, 5, 8) = (/ &
     &5.3258e+00_r8,4.6606e+00_r8,3.9953e+00_r8,3.7485e+00_r8,3.7814e+00_r8,3.7044e+00_r8, &
     &3.7302e+00_r8,3.7158e+00_r8,4.7217e-02_r8/)
      kao(:, 4, 5, 8) = (/ &
     &5.1933e+00_r8,4.5445e+00_r8,3.8958e+00_r8,3.7349e+00_r8,3.8276e+00_r8,3.8482e+00_r8, &
     &3.9315e+00_r8,3.9070e+00_r8,5.2805e-02_r8/)
      kao(:, 5, 5, 8) = (/ &
     &5.1489e+00_r8,4.5057e+00_r8,3.8627e+00_r8,3.7753e+00_r8,3.9160e+00_r8,4.0236e+00_r8, &
     &4.1558e+00_r8,4.1173e+00_r8,7.3119e-02_r8/)
      kao(:, 1, 6, 8) = (/ &
     &4.9153e+00_r8,4.3014e+00_r8,3.6874e+00_r8,3.6742e+00_r8,3.4664e+00_r8,3.2352e+00_r8, &
     &3.1382e+00_r8,3.1290e+00_r8,5.3656e-02_r8/)
      kao(:, 2, 6, 8) = (/ &
     &4.6666e+00_r8,4.0837e+00_r8,3.5075e+00_r8,3.5947e+00_r8,3.4390e+00_r8,3.3186e+00_r8, &
     &3.2995e+00_r8,3.2957e+00_r8,3.0716e-02_r8/)
      kao(:, 3, 6, 8) = (/ &
     &4.4714e+00_r8,3.9130e+00_r8,3.4299e+00_r8,3.5379e+00_r8,3.4620e+00_r8,3.4453e+00_r8, &
     &3.4927e+00_r8,3.4789e+00_r8,2.2748e-02_r8/)
      kao(:, 4, 6, 8) = (/ &
     &4.3327e+00_r8,3.7916e+00_r8,3.3931e+00_r8,3.5287e+00_r8,3.5342e+00_r8,3.5995e+00_r8, &
     &3.6934e+00_r8,3.6650e+00_r8,4.0419e-02_r8/)
      kao(:, 5, 6, 8) = (/ &
     &4.2621e+00_r8,3.7298e+00_r8,3.3976e+00_r8,3.5656e+00_r8,3.6513e+00_r8,3.7826e+00_r8, &
     &3.9184e+00_r8,3.8666e+00_r8,1.0762e-01_r8/)
      kao(:, 1, 7, 8) = (/ &
     &4.2315e+00_r8,3.7030e+00_r8,3.3451e+00_r8,3.3493e+00_r8,3.1177e+00_r8,2.9742e+00_r8, &
     &2.9072e+00_r8,2.9068e+00_r8,5.8460e-02_r8/)
      kao(:, 2, 7, 8) = (/ &
     &3.9985e+00_r8,3.4984e+00_r8,3.2669e+00_r8,3.2554e+00_r8,3.1149e+00_r8,3.0526e+00_r8, &
     &3.0595e+00_r8,3.0700e+00_r8,2.7402e-02_r8/)
      kao(:, 3, 7, 8) = (/ &
     &3.8099e+00_r8,3.3338e+00_r8,3.2097e+00_r8,3.2104e+00_r8,3.1587e+00_r8,3.1808e+00_r8, &
     &3.2348e+00_r8,3.2401e+00_r8,1.9004e-02_r8/)
      kao(:, 4, 7, 8) = (/ &
     &3.6700e+00_r8,3.2116e+00_r8,3.1648e+00_r8,3.2052e+00_r8,3.2433e+00_r8,3.3349e+00_r8, &
     &3.4286e+00_r8,3.4160e+00_r8,4.2481e-02_r8/)
      kao(:, 5, 7, 8) = (/ &
     &3.5860e+00_r8,3.1383e+00_r8,3.1473e+00_r8,3.2492e+00_r8,3.3786e+00_r8,3.5157e+00_r8, &
     &3.6429e+00_r8,3.6020e+00_r8,1.5676e-01_r8/)
      kao(:, 1, 8, 8) = (/ &
     &3.7309e+00_r8,3.2652e+00_r8,3.2085e+00_r8,3.0458e+00_r8,2.8667e+00_r8,2.7650e+00_r8, &
     &2.6802e+00_r8,2.6374e+00_r8,6.7482e-02_r8/)
      kao(:, 2, 8, 8) = (/ &
     &3.5088e+00_r8,3.0710e+00_r8,3.0883e+00_r8,2.9531e+00_r8,2.8706e+00_r8,2.8363e+00_r8, &
     &2.8330e+00_r8,2.8092e+00_r8,3.1671e-02_r8/)
      kao(:, 3, 8, 8) = (/ &
     &3.3283e+00_r8,2.9131e+00_r8,2.9801e+00_r8,2.9151e+00_r8,2.9077e+00_r8,2.9395e+00_r8, &
     &2.9913e+00_r8,2.9792e+00_r8,1.9457e-02_r8/)
      kao(:, 4, 8, 8) = (/ &
     &3.1890e+00_r8,2.7912e+00_r8,2.9223e+00_r8,2.9235e+00_r8,2.9935e+00_r8,3.0761e+00_r8, &
     &3.1767e+00_r8,3.1591e+00_r8,4.5502e-02_r8/)
      kao(:, 5, 8, 8) = (/ &
     &3.0966e+00_r8,2.7276e+00_r8,2.9000e+00_r8,2.9842e+00_r8,3.1139e+00_r8,3.2433e+00_r8, &
     &3.3703e+00_r8,3.3444e+00_r8,1.7959e-01_r8/)
      kao(:, 1, 9, 8) = (/ &
     &3.2795e+00_r8,2.8728e+00_r8,2.9171e+00_r8,2.7516e+00_r8,2.6513e+00_r8,2.5188e+00_r8, &
     &2.4080e+00_r8,2.3392e+00_r8,6.9869e-02_r8/)
      kao(:, 2, 9, 8) = (/ &
     &3.0734e+00_r8,2.7076e+00_r8,2.7821e+00_r8,2.6844e+00_r8,2.6368e+00_r8,2.5852e+00_r8, &
     &2.5517e+00_r8,2.5045e+00_r8,4.1359e-02_r8/)
      kao(:, 3, 9, 8) = (/ &
     &2.9006e+00_r8,2.6099e+00_r8,2.6833e+00_r8,2.6568e+00_r8,2.6662e+00_r8,2.6837e+00_r8, &
     &2.7125e+00_r8,2.6712e+00_r8,2.1538e-02_r8/)
      kao(:, 4, 9, 8) = (/ &
     &2.7639e+00_r8,2.5377e+00_r8,2.6242e+00_r8,2.6595e+00_r8,2.7323e+00_r8,2.8096e+00_r8, &
     &2.8901e+00_r8,2.8466e+00_r8,5.4396e-02_r8/)
      kao(:, 5, 9, 8) = (/ &
     &2.6669e+00_r8,2.4856e+00_r8,2.6031e+00_r8,2.7098e+00_r8,2.8344e+00_r8,2.9696e+00_r8, &
     &3.0834e+00_r8,3.0331e+00_r8,2.0077e-01_r8/)
      kao(:, 1,10, 8) = (/ &
     &2.8722e+00_r8,2.6105e+00_r8,2.6085e+00_r8,2.5091e+00_r8,2.4056e+00_r8,2.2547e+00_r8, &
     &2.1348e+00_r8,2.0413e+00_r8,7.1950e-02_r8/)
      kao(:, 2,10, 8) = (/ &
     &2.6764e+00_r8,2.5038e+00_r8,2.4795e+00_r8,2.4482e+00_r8,2.3806e+00_r8,2.3128e+00_r8, &
     &2.2556e+00_r8,2.1912e+00_r8,3.7979e-02_r8/)
      kao(:, 3,10, 8) = (/ &
     &2.5139e+00_r8,2.4083e+00_r8,2.3949e+00_r8,2.4105e+00_r8,2.4135e+00_r8,2.4077e+00_r8, &
     &2.4119e+00_r8,2.3558e+00_r8,2.2438e-02_r8/)
      kao(:, 4,10, 8) = (/ &
     &2.3840e+00_r8,2.3185e+00_r8,2.3481e+00_r8,2.4127e+00_r8,2.4770e+00_r8,2.5357e+00_r8, &
     &2.5771e+00_r8,2.5231e+00_r8,7.0033e-02_r8/)
      kao(:, 5,10, 8) = (/ &
     &2.2922e+00_r8,2.2525e+00_r8,2.3358e+00_r8,2.4514e+00_r8,2.5719e+00_r8,2.6836e+00_r8, &
     &2.7691e+00_r8,2.7055e+00_r8,2.1431e-01_r8/)
      kao(:, 1,11, 8) = (/ &
     &2.4203e+00_r8,2.3366e+00_r8,2.2726e+00_r8,2.2388e+00_r8,2.1243e+00_r8,2.0012e+00_r8, &
     &1.8959e+00_r8,1.8076e+00_r8,5.5769e-02_r8/)
      kao(:, 2,11, 8) = (/ &
     &2.2551e+00_r8,2.2021e+00_r8,2.1879e+00_r8,2.1841e+00_r8,2.1218e+00_r8,2.0691e+00_r8, &
     &2.0223e+00_r8,1.9543e+00_r8,2.8668e-02_r8/)
      kao(:, 3,11, 8) = (/ &
     &2.1166e+00_r8,2.0926e+00_r8,2.1229e+00_r8,2.1590e+00_r8,2.1592e+00_r8,2.1682e+00_r8, &
     &2.1642e+00_r8,2.1075e+00_r8,3.1850e-02_r8/)
      kao(:, 4,11, 8) = (/ &
     &2.0122e+00_r8,2.0159e+00_r8,2.0901e+00_r8,2.1693e+00_r8,2.2337e+00_r8,2.2891e+00_r8, &
     &2.3331e+00_r8,2.2748e+00_r8,1.4071e-01_r8/)
      kao(:, 5,11, 8) = (/ &
     &1.9514e+00_r8,1.9763e+00_r8,2.0989e+00_r8,2.2225e+00_r8,2.3388e+00_r8,2.4447e+00_r8, &
     &2.5215e+00_r8,2.4588e+00_r8,2.8723e-01_r8/)
      kao(:, 1,12, 8) = (/ &
     &2.0683e+00_r8,2.0370e+00_r8,2.0375e+00_r8,1.9798e+00_r8,1.8792e+00_r8,1.7675e+00_r8, &
     &1.6700e+00_r8,1.5868e+00_r8,4.4568e-02_r8/)
      kao(:, 2,12, 8) = (/ &
     &1.9287e+00_r8,1.9214e+00_r8,1.9599e+00_r8,1.9353e+00_r8,1.8869e+00_r8,1.8278e+00_r8, &
     &1.7894e+00_r8,1.7244e+00_r8,2.3573e-02_r8/)
      kao(:, 3,12, 8) = (/ &
     &1.8200e+00_r8,1.8347e+00_r8,1.9076e+00_r8,1.9217e+00_r8,1.9295e+00_r8,1.9250e+00_r8, &
     &1.9263e+00_r8,1.8738e+00_r8,5.2475e-02_r8/)
      kao(:, 4,12, 8) = (/ &
     &1.7432e+00_r8,1.7845e+00_r8,1.8845e+00_r8,1.9488e+00_r8,2.0009e+00_r8,2.0498e+00_r8, &
     &2.0942e+00_r8,2.0382e+00_r8,1.8765e-01_r8/)
      kao(:, 5,12, 8) = (/ &
     &1.7053e+00_r8,1.7760e+00_r8,1.9065e+00_r8,2.0215e+00_r8,2.1153e+00_r8,2.2054e+00_r8, &
     &2.2781e+00_r8,2.2210e+00_r8,3.6587e-01_r8/)
      kao(:, 1,13, 8) = (/ &
     &1.8562e+00_r8,1.8459e+00_r8,1.8637e+00_r8,1.7957e+00_r8,1.6878e+00_r8,1.5797e+00_r8, &
     &1.4757e+00_r8,1.3906e+00_r8,3.6132e-02_r8/)
      kao(:, 2,13, 8) = (/ &
     &1.7399e+00_r8,1.7611e+00_r8,1.7971e+00_r8,1.7529e+00_r8,1.6955e+00_r8,1.6354e+00_r8, &
     &1.5829e+00_r8,1.5250e+00_r8,2.1418e-02_r8/)
      kao(:, 3,13, 8) = (/ &
     &1.6467e+00_r8,1.6945e+00_r8,1.7550e+00_r8,1.7487e+00_r8,1.7380e+00_r8,1.7251e+00_r8, &
     &1.7178e+00_r8,1.6689e+00_r8,6.4309e-02_r8/)
      kao(:, 4,13, 8) = (/ &
     &1.5930e+00_r8,1.6654e+00_r8,1.7520e+00_r8,1.7797e+00_r8,1.8113e+00_r8,1.8460e+00_r8, &
     &1.8831e+00_r8,1.8288e+00_r8,2.0946e-01_r8/)
      kao(:, 5,13, 8) = (/ &
     &1.5695e+00_r8,1.6755e+00_r8,1.7906e+00_r8,1.8612e+00_r8,1.9314e+00_r8,2.0101e+00_r8, &
     &2.0671e+00_r8,2.0074e+00_r8,3.8278e-01_r8/)
      kao(:, 1, 1, 9) = (/ &
     &4.3448e+02_r8,3.8017e+02_r8,3.2586e+02_r8,2.7155e+02_r8,2.1724e+02_r8,1.6293e+02_r8, &
     &1.0862e+02_r8,5.5107e+01_r8,2.7465e-03_r8/)
      kao(:, 2, 1, 9) = (/ &
     &5.8321e+02_r8,5.1031e+02_r8,4.3741e+02_r8,3.6451e+02_r8,2.9161e+02_r8,2.1870e+02_r8, &
     &1.4580e+02_r8,7.3550e+01_r8,3.5822e-03_r8/)
      kao(:, 3, 1, 9) = (/ &
     &7.6101e+02_r8,6.6588e+02_r8,5.7076e+02_r8,4.7563e+02_r8,3.8051e+02_r8,2.8538e+02_r8, &
     &1.9025e+02_r8,9.5593e+01_r8,5.6366e-03_r8/)
      kao(:, 4, 1, 9) = (/ &
     &9.6683e+02_r8,8.4598e+02_r8,7.2512e+02_r8,6.0427e+02_r8,4.8342e+02_r8,3.6256e+02_r8, &
     &2.4171e+02_r8,1.2116e+02_r8,6.3697e-02_r8/)
      kao(:, 5, 1, 9) = (/ &
     &1.1977e+03_r8,1.0480e+03_r8,8.9827e+02_r8,7.4856e+02_r8,5.9885e+02_r8,4.4914e+02_r8, &
     &2.9942e+02_r8,1.4986e+02_r8,2.8050e-01_r8/)
      kao(:, 1, 2, 9) = (/ &
     &3.3233e+02_r8,2.9079e+02_r8,2.4925e+02_r8,2.0770e+02_r8,1.6616e+02_r8,1.2462e+02_r8, &
     &8.3297e+01_r8,4.3020e+01_r8,1.2769e-02_r8/)
      kao(:, 2, 2, 9) = (/ &
     &4.5139e+02_r8,3.9497e+02_r8,3.3854e+02_r8,2.8212e+02_r8,2.2570e+02_r8,1.6927e+02_r8, &
     &1.1303e+02_r8,5.7664e+01_r8,6.8183e-02_r8/)
      kao(:, 3, 2, 9) = (/ &
     &5.9515e+02_r8,5.2076e+02_r8,4.4637e+02_r8,3.7197e+02_r8,2.9758e+02_r8,2.2318e+02_r8, &
     &1.4890e+02_r8,7.5394e+01_r8,1.7070e-01_r8/)
      kao(:, 4, 2, 9) = (/ &
     &7.6179e+02_r8,6.6657e+02_r8,5.7134e+02_r8,4.7612e+02_r8,3.8090e+02_r8,2.8567e+02_r8, &
     &1.9048e+02_r8,9.5968e+01_r8,4.9948e-01_r8/)
      kao(:, 5, 2, 9) = (/ &
     &9.5206e+02_r8,8.3305e+02_r8,7.1404e+02_r8,5.9504e+02_r8,4.7603e+02_r8,3.5702e+02_r8, &
     &2.3802e+02_r8,1.1952e+02_r8,1.1527e+00_r8/)
      kao(:, 1, 3, 9) = (/ &
     &2.3507e+02_r8,2.0568e+02_r8,1.7630e+02_r8,1.4692e+02_r8,1.1753e+02_r8,8.8151e+01_r8, &
     &5.9624e+01_r8,3.1706e+01_r8,5.0754e-02_r8/)
      kao(:, 2, 3, 9) = (/ &
     &3.2531e+02_r8,2.8465e+02_r8,2.4398e+02_r8,2.0332e+02_r8,1.6266e+02_r8,1.2199e+02_r8, &
     &8.2067e+01_r8,4.2715e+01_r8,9.9945e-02_r8/)
      kao(:, 3, 3, 9) = (/ &
     &4.3545e+02_r8,3.8102e+02_r8,3.2659e+02_r8,2.7216e+02_r8,2.1773e+02_r8,1.6330e+02_r8, &
     &1.0943e+02_r8,5.6175e+01_r8,4.3033e-01_r8/)
      kao(:, 4, 3, 9) = (/ &
     &5.6623e+02_r8,4.9545e+02_r8,4.2468e+02_r8,3.5390e+02_r8,2.8312e+02_r8,2.1234e+02_r8, &
     &1.4196e+02_r8,7.2208e+01_r8,1.0055e+00_r8/)
      kao(:, 5, 3, 9) = (/ &
     &7.1637e+02_r8,6.2682e+02_r8,5.3728e+02_r8,4.4773e+02_r8,3.5819e+02_r8,2.6864e+02_r8, &
     &1.7932e+02_r8,9.0659e+01_r8,1.5764e+00_r8/)
      kao(:, 1, 4, 9) = (/ &
     &1.6080e+02_r8,1.4070e+02_r8,1.2060e+02_r8,1.0050e+02_r8,8.0399e+01_r8,6.0779e+01_r8, &
     &4.1842e+01_r8,2.3410e+01_r8,9.5747e-02_r8/)
      kao(:, 2, 4, 9) = (/ &
     &2.2661e+02_r8,1.9829e+02_r8,1.6996e+02_r8,1.4163e+02_r8,1.1331e+02_r8,8.5452e+01_r8, &
     &5.8120e+01_r8,3.1330e+01_r8,8.2203e-01_r8/)
      kao(:, 3, 4, 9) = (/ &
     &3.0940e+02_r8,2.7072e+02_r8,2.3205e+02_r8,1.9338e+02_r8,1.5470e+02_r8,1.1642e+02_r8, &
     &7.8610e+01_r8,4.1331e+01_r8,1.4967e+00_r8/)
      kao(:, 4, 4, 9) = (/ &
     &4.0889e+02_r8,3.5778e+02_r8,3.0667e+02_r8,2.5556e+02_r8,2.0445e+02_r8,1.5361e+02_r8, &
     &1.0323e+02_r8,5.3416e+01_r8,2.0722e+00_r8/)
      kao(:, 5, 4, 9) = (/ &
     &5.2581e+02_r8,4.6008e+02_r8,3.9436e+02_r8,3.2863e+02_r8,2.6291e+02_r8,1.9734e+02_r8, &
     &1.3221e+02_r8,6.7657e+01_r8,2.6260e+00_r8/)
      kao(:, 1, 5, 9) = (/ &
     &1.0850e+02_r8,9.4934e+01_r8,8.1372e+01_r8,6.7810e+01_r8,5.4459e+01_r8,4.1884e+01_r8, &
     &2.9671e+01_r8,1.7923e+01_r8,1.1913e+00_r8/)
      kao(:, 2, 5, 9) = (/ &
     &1.5572e+02_r8,1.3625e+02_r8,1.1679e+02_r8,9.7324e+01_r8,7.8121e+01_r8,5.9526e+01_r8, &
     &4.1277e+01_r8,2.3510e+01_r8,1.9137e+00_r8/)
      kao(:, 3, 5, 9) = (/ &
     &2.1676e+02_r8,1.8967e+02_r8,1.6257e+02_r8,1.3548e+02_r8,1.0864e+02_r8,8.2293e+01_r8, &
     &5.6282e+01_r8,3.0781e+01_r8,2.5565e+00_r8/)
      kao(:, 4, 5, 9) = (/ &
     &2.9183e+02_r8,2.5535e+02_r8,2.1887e+02_r8,1.8239e+02_r8,1.4612e+02_r8,1.1027e+02_r8, &
     &7.4761e+01_r8,3.9788e+01_r8,3.1260e+00_r8/)
      kao(:, 5, 5, 9) = (/ &
     &3.8115e+02_r8,3.3351e+02_r8,2.8587e+02_r8,2.3822e+02_r8,1.9070e+02_r8,1.4356e+02_r8, &
     &9.6772e+01_r8,5.0545e+01_r8,3.5402e+00_r8/)
      kao(:, 1, 6, 9) = (/ &
     &7.1661e+01_r8,6.2704e+01_r8,5.3746e+01_r8,4.4797e+01_r8,3.6644e+01_r8,2.8875e+01_r8, &
     &2.1420e+01_r8,1.4378e+01_r8,2.0773e+00_r8/)
      kao(:, 2, 6, 9) = (/ &
     &1.0465e+02_r8,9.1565e+01_r8,7.8484e+01_r8,6.5455e+01_r8,5.3153e+01_r8,4.1163e+01_r8, &
     &2.9464e+01_r8,1.8199e+01_r8,2.7911e+00_r8/)
      kao(:, 3, 6, 9) = (/ &
     &1.4858e+02_r8,1.3001e+02_r8,1.1144e+02_r8,9.2961e+01_r8,7.5079e+01_r8,5.7480e+01_r8, &
     &4.0178e+01_r8,2.3340e+01_r8,3.3860e+00_r8/)
      kao(:, 4, 6, 9) = (/ &
     &2.0400e+02_r8,1.7850e+02_r8,1.5300e+02_r8,1.2759e+02_r8,1.0268e+02_r8,7.8054e+01_r8, &
     &5.3729e+01_r8,2.9889e+01_r8,3.8146e+00_r8/)
      kao(:, 5, 6, 9) = (/ &
     &2.7127e+02_r8,2.3736e+02_r8,2.0345e+02_r8,1.6959e+02_r8,1.3617e+02_r8,1.0303e+02_r8, &
     &7.0191e+01_r8,3.7883e+01_r8,4.1027e+00_r8/)
      kao(:, 1, 7, 9) = (/ &
     &4.7664e+01_r8,4.1706e+01_r8,3.5748e+01_r8,3.0192e+01_r8,2.5283e+01_r8,2.0687e+01_r8, &
     &1.6356e+01_r8,1.2414e+01_r8,2.7141e+00_r8/)
      kao(:, 2, 7, 9) = (/ &
     &7.0406e+01_r8,6.1605e+01_r8,5.2805e+01_r8,4.4485e+01_r8,3.6675e+01_r8,2.9135e+01_r8, &
     &2.1846e+01_r8,1.4960e+01_r8,3.3740e+00_r8/)
      kao(:, 3, 7, 9) = (/ &
     &1.0189e+02_r8,8.9150e+01_r8,7.6414e+01_r8,6.4182e+01_r8,5.2360e+01_r8,4.0780e+01_r8, &
     &2.9464e+01_r8,1.8559e+01_r8,3.8705e+00_r8/)
      kao(:, 4, 7, 9) = (/ &
     &1.4268e+02_r8,1.2484e+02_r8,1.0701e+02_r8,8.9652e+01_r8,7.2635e+01_r8,5.5858e+01_r8, &
     &3.9357e+01_r8,2.3287e+01_r8,4.2268e+00_r8/)
      kao(:, 5, 7, 9) = (/ &
     &1.9337e+02_r8,1.6920e+02_r8,1.4503e+02_r8,1.2126e+02_r8,9.7796e+01_r8,7.4601e+01_r8, &
     &5.1680e+01_r8,2.9228e+01_r8,4.3853e+00_r8/)
      kao(:, 1, 8, 9) = (/ &
     &3.2619e+01_r8,2.8542e+01_r8,2.4489e+01_r8,2.1251e+01_r8,1.8391e+01_r8,1.5792e+01_r8, &
     &1.3493e+01_r8,1.1316e+01_r8,3.0747e+00_r8/)
      kao(:, 2, 8, 9) = (/ &
     &4.8375e+01_r8,4.2328e+01_r8,3.6375e+01_r8,3.1177e+01_r8,2.6286e+01_r8,2.1635e+01_r8, &
     &1.7234e+01_r8,1.3233e+01_r8,3.6551e+00_r8/)
      kao(:, 3, 8, 9) = (/ &
     &7.1088e+01_r8,6.2202e+01_r8,5.3468e+01_r8,4.5389e+01_r8,3.7595e+01_r8,3.0015e+01_r8, &
     &2.2675e+01_r8,1.5741e+01_r8,4.0898e+00_r8/)
      kao(:, 4, 8, 9) = (/ &
     &1.0151e+02_r8,8.8821e+01_r8,7.6303e+01_r8,6.4370e+01_r8,5.2682e+01_r8,4.1218e+01_r8, &
     &2.9982e+01_r8,1.9170e+01_r8,4.3948e+00_r8/)
      kao(:, 5, 8, 9) = (/ &
     &1.4013e+02_r8,1.2261e+02_r8,1.0526e+02_r8,8.8413e+01_r8,7.1810e+01_r8,5.5432e+01_r8, &
     &3.9307e+01_r8,2.3602e+01_r8,4.4795e+00_r8/)
      kao(:, 1, 9, 9) = (/ &
     &2.2374e+01_r8,1.9574e+01_r8,1.7087e+01_r8,1.5322e+01_r8,1.3873e+01_r8,1.2730e+01_r8, &
     &1.1784e+01_r8,1.0057e+01_r8,3.2920e+00_r8/)
      kao(:, 2, 9, 9) = (/ &
     &3.3006e+01_r8,2.8880e+01_r8,2.5155e+01_r8,2.2057e+01_r8,1.9232e+01_r8,1.6658e+01_r8, &
     &1.4329e+01_r8,1.1850e+01_r8,3.8043e+00_r8/)
      kao(:, 3, 9, 9) = (/ &
     &4.8965e+01_r8,4.2845e+01_r8,3.7181e+01_r8,3.2051e+01_r8,2.7172e+01_r8,2.2508e+01_r8, &
     &1.8078e+01_r8,1.3961e+01_r8,4.2059e+00_r8/)
      kao(:, 4, 9, 9) = (/ &
     &7.1218e+01_r8,6.2316e+01_r8,5.3886e+01_r8,4.5928e+01_r8,3.8193e+01_r8,3.0649e+01_r8, &
     &2.3347e+01_r8,1.6446e+01_r8,4.4539e+00_r8/)
      kao(:, 5, 9, 9) = (/ &
     &1.0013e+02_r8,8.7618e+01_r8,7.5558e+01_r8,6.3912e+01_r8,5.2481e+01_r8,4.1239e+01_r8, &
     &3.0241e+01_r8,1.9662e+01_r8,4.4837e+00_r8/)
      kao(:, 1,10, 9) = (/ &
     &1.6016e+01_r8,1.4014e+01_r8,1.2654e+01_r8,1.1832e+01_r8,1.1333e+01_r8,1.1079e+01_r8, &
     &1.0430e+01_r8,8.9198e+00_r8,3.4165e+00_r8/)
      kao(:, 2,10, 9) = (/ &
     &2.3316e+01_r8,2.0402e+01_r8,1.8216e+01_r8,1.6474e+01_r8,1.5033e+01_r8,1.3817e+01_r8, &
     &1.2667e+01_r8,1.0521e+01_r8,3.8593e+00_r8/)
      kao(:, 3,10, 9) = (/ &
     &3.4676e+01_r8,3.0345e+01_r8,2.6796e+01_r8,2.3607e+01_r8,2.0669e+01_r8,1.7940e+01_r8, &
     &1.5414e+01_r8,1.2426e+01_r8,4.1980e+00_r8/)
      kao(:, 4,10, 9) = (/ &
     &5.1075e+01_r8,4.4715e+01_r8,3.9109e+01_r8,3.3826e+01_r8,2.8757e+01_r8,2.3883e+01_r8, &
     &1.9235e+01_r8,1.4676e+01_r8,4.3830e+00_r8/)
      kao(:, 5,10, 9) = (/ &
     &7.2971e+01_r8,6.3894e+01_r8,5.5508e+01_r8,4.7426e+01_r8,3.9536e+01_r8,3.1844e+01_r8, &
     &2.4374e+01_r8,1.7279e+01_r8,4.3810e+00_r8/)
      kao(:, 1,11, 9) = (/ &
     &1.3577e+01_r8,1.1946e+01_r8,1.1209e+01_r8,1.0837e+01_r8,1.0794e+01_r8,1.0607e+01_r8, &
     &9.9046e+00_r8,8.4158e+00_r8,3.5771e+00_r8/)
      kao(:, 2,11, 9) = (/ &
     &1.9792e+01_r8,1.7445e+01_r8,1.5940e+01_r8,1.4785e+01_r8,1.3920e+01_r8,1.3199e+01_r8, &
     &1.2097e+01_r8,9.9522e+00_r8,3.9185e+00_r8/)
      kao(:, 3,11, 9) = (/ &
     &2.9476e+01_r8,2.5957e+01_r8,2.3237e+01_r8,2.0843e+01_r8,1.8688e+01_r8,1.6684e+01_r8, &
     &1.4791e+01_r8,1.1766e+01_r8,4.1553e+00_r8/)
      kao(:, 4,11, 9) = (/ &
     &4.3413e+01_r8,3.8176e+01_r8,3.3695e+01_r8,2.9502e+01_r8,2.5515e+01_r8,2.1698e+01_r8, &
     &1.8077e+01_r8,1.3908e+01_r8,4.1942e+00_r8/)
      kao(:, 5,11, 9) = (/ &
     &6.2007e+01_r8,5.4458e+01_r8,4.7606e+01_r8,4.1020e+01_r8,3.4622e+01_r8,2.8398e+01_r8, &
     &2.2392e+01_r8,1.6392e+01_r8,4.1692e+00_r8/)
      kao(:, 1,12, 9) = (/ &
     &1.1680e+01_r8,1.0479e+01_r8,1.0122e+01_r8,1.0167e+01_r8,1.0289e+01_r8,1.0072e+01_r8, &
     &9.3417e+00_r8,7.9079e+00_r8,3.5200e+00_r8/)
      kao(:, 2,12, 9) = (/ &
     &1.7053e+01_r8,1.5231e+01_r8,1.4215e+01_r8,1.3566e+01_r8,1.3123e+01_r8,1.2618e+01_r8, &
     &1.1431e+01_r8,9.3416e+00_r8,3.7828e+00_r8/)
      kao(:, 3,12, 9) = (/ &
     &2.5404e+01_r8,2.2573e+01_r8,2.0511e+01_r8,1.8777e+01_r8,1.7216e+01_r8,1.5812e+01_r8, &
     &1.4031e+01_r8,1.1064e+01_r8,3.9374e+00_r8/)
      kao(:, 4,12, 9) = (/ &
     &3.7431e+01_r8,3.3112e+01_r8,2.9529e+01_r8,2.6224e+01_r8,2.3088e+01_r8,2.0100e+01_r8, &
     &1.7184e+01_r8,1.3093e+01_r8,3.9253e+00_r8/)
      kao(:, 5,12, 9) = (/ &
     &5.3474e+01_r8,4.7145e+01_r8,4.1510e+01_r8,3.6119e+01_r8,3.0908e+01_r8,2.5843e+01_r8, &
     &2.0970e+01_r8,1.5444e+01_r8,3.9004e+00_r8/)
      kao(:, 1,13, 9) = (/ &
     &1.0438e+01_r8,9.5597e+00_r8,9.5087e+00_r8,9.7911e+00_r8,9.8820e+00_r8,9.5875e+00_r8, &
     &8.8692e+00_r8,7.4811e+00_r8,3.3069e+00_r8/)
      kao(:, 2,13, 9) = (/ &
     &1.5260e+01_r8,1.3818e+01_r8,1.3178e+01_r8,1.2874e+01_r8,1.2679e+01_r8,1.2091e+01_r8, &
     &1.0875e+01_r8,8.8312e+00_r8,3.5228e+00_r8/)
      kao(:, 3,13, 9) = (/ &
     &2.2789e+01_r8,2.0434e+01_r8,1.8837e+01_r8,1.7547e+01_r8,1.6403e+01_r8,1.5263e+01_r8, &
     &1.3389e+01_r8,1.0463e+01_r8,3.6351e+00_r8/)
      kao(:, 4,13, 9) = (/ &
     &3.3586e+01_r8,2.9891e+01_r8,2.6912e+01_r8,2.4218e+01_r8,2.1653e+01_r8,1.9218e+01_r8, &
     &1.6457e+01_r8,1.2402e+01_r8,3.6180e+00_r8/)
      kao(:, 5,13, 9) = (/ &
     &4.7989e+01_r8,4.2477e+01_r8,3.7650e+01_r8,3.3082e+01_r8,2.8647e+01_r8,2.4351e+01_r8, &
     &2.0129e+01_r8,1.4659e+01_r8,3.6174e+00_r8/)
      kao(:, 1, 1,10) = (/ &
     &2.6405e+03_r8,2.3104e+03_r8,1.9803e+03_r8,1.6503e+03_r8,1.3202e+03_r8,9.9017e+02_r8, &
     &6.6011e+02_r8,3.3006e+02_r8,2.0071e-03_r8/)
      kao(:, 2, 1,10) = (/ &
     &3.3430e+03_r8,2.9251e+03_r8,2.5072e+03_r8,2.0894e+03_r8,1.6715e+03_r8,1.2536e+03_r8, &
     &8.3575e+02_r8,4.1787e+02_r8,3.1756e-03_r8/)
      kao(:, 3, 1,10) = (/ &
     &4.1007e+03_r8,3.5881e+03_r8,3.0756e+03_r8,2.5630e+03_r8,2.0504e+03_r8,1.5378e+03_r8, &
     &1.0252e+03_r8,5.1259e+02_r8,1.5257e-02_r8/)
      kao(:, 4, 1,10) = (/ &
     &4.9110e+03_r8,4.2972e+03_r8,3.6833e+03_r8,3.0694e+03_r8,2.4555e+03_r8,1.8416e+03_r8, &
     &1.2278e+03_r8,6.1388e+02_r8,1.9623e-01_r8/)
      kao(:, 5, 1,10) = (/ &
     &5.7642e+03_r8,5.0437e+03_r8,4.3232e+03_r8,3.6026e+03_r8,2.8821e+03_r8,2.1616e+03_r8, &
     &1.4411e+03_r8,7.2053e+02_r8,3.1630e-01_r8/)
      kao(:, 1, 2,10) = (/ &
     &2.0643e+03_r8,1.8062e+03_r8,1.5482e+03_r8,1.2902e+03_r8,1.0321e+03_r8,7.7410e+02_r8, &
     &5.1607e+02_r8,2.5804e+02_r8,7.9610e-02_r8/)
      kao(:, 2, 2,10) = (/ &
     &2.6419e+03_r8,2.3117e+03_r8,1.9815e+03_r8,1.6512e+03_r8,1.3210e+03_r8,9.9073e+02_r8, &
     &6.6049e+02_r8,3.3024e+02_r8,3.1756e-01_r8/)
      kao(:, 3, 2,10) = (/ &
     &3.2679e+03_r8,2.8594e+03_r8,2.4509e+03_r8,2.0424e+03_r8,1.6340e+03_r8,1.2255e+03_r8, &
     &8.1698e+02_r8,4.0849e+02_r8,1.6019e+00_r8/)
      kao(:, 4, 2,10) = (/ &
     &3.9535e+03_r8,3.4593e+03_r8,2.9652e+03_r8,2.4710e+03_r8,1.9768e+03_r8,1.4826e+03_r8, &
     &9.8838e+02_r8,4.9419e+02_r8,2.9545e+00_r8/)
      kao(:, 5, 2,10) = (/ &
     &4.6801e+03_r8,4.0951e+03_r8,3.5101e+03_r8,2.9251e+03_r8,2.3401e+03_r8,1.7551e+03_r8, &
     &1.1700e+03_r8,5.8502e+02_r8,4.1449e+00_r8/)
      kao(:, 1, 3,10) = (/ &
     &1.5076e+03_r8,1.3191e+03_r8,1.1307e+03_r8,9.4224e+02_r8,7.5379e+02_r8,5.6534e+02_r8, &
     &3.7689e+02_r8,1.8845e+02_r8,5.0945e-01_r8/)
      kao(:, 2, 3,10) = (/ &
     &1.9623e+03_r8,1.7170e+03_r8,1.4718e+03_r8,1.2265e+03_r8,9.8117e+02_r8,7.3588e+02_r8, &
     &4.9059e+02_r8,2.4529e+02_r8,2.4679e+00_r8/)
      kao(:, 3, 3,10) = (/ &
     &2.4731e+03_r8,2.1640e+03_r8,1.8549e+03_r8,1.5457e+03_r8,1.2366e+03_r8,9.2743e+02_r8, &
     &6.1829e+02_r8,3.0914e+02_r8,5.8082e+00_r8/)
      kao(:, 4, 3,10) = (/ &
     &3.0330e+03_r8,2.6538e+03_r8,2.2747e+03_r8,1.8956e+03_r8,1.5165e+03_r8,1.1374e+03_r8, &
     &7.5824e+02_r8,3.7912e+02_r8,6.6677e+00_r8/)
      kao(:, 5, 3,10) = (/ &
     &3.6345e+03_r8,3.1802e+03_r8,2.7259e+03_r8,2.2715e+03_r8,1.8172e+03_r8,1.3629e+03_r8, &
     &9.0862e+02_r8,4.5431e+02_r8,6.6949e+00_r8/)
      kao(:, 1, 4,10) = (/ &
     &1.0627e+03_r8,9.2986e+02_r8,7.9702e+02_r8,6.6419e+02_r8,5.3135e+02_r8,3.9851e+02_r8, &
     &2.6568e+02_r8,1.3284e+02_r8,8.6599e+00_r8/)
      kao(:, 2, 4,10) = (/ &
     &1.4166e+03_r8,1.2395e+03_r8,1.0624e+03_r8,8.8537e+02_r8,7.0829e+02_r8,5.3122e+02_r8, &
     &3.5415e+02_r8,1.7707e+02_r8,9.4746e+00_r8/)
      kao(:, 3, 4,10) = (/ &
     &1.8198e+03_r8,1.5923e+03_r8,1.3648e+03_r8,1.1374e+03_r8,9.0989e+02_r8,6.8241e+02_r8, &
     &4.5494e+02_r8,2.2747e+02_r8,9.4272e+00_r8/)
      kao(:, 4, 4,10) = (/ &
     &2.2704e+03_r8,1.9866e+03_r8,1.7028e+03_r8,1.4190e+03_r8,1.1352e+03_r8,8.5140e+02_r8, &
     &5.6760e+02_r8,2.8380e+02_r8,9.3833e+00_r8/)
      kao(:, 5, 4,10) = (/ &
     &2.7615e+03_r8,2.4164e+03_r8,2.0712e+03_r8,1.7260e+03_r8,1.3808e+03_r8,1.0356e+03_r8, &
     &6.9039e+02_r8,3.4519e+02_r8,9.3214e+00_r8/)
      kao(:, 1, 5,10) = (/ &
     &7.3556e+02_r8,6.4362e+02_r8,5.5167e+02_r8,4.5973e+02_r8,3.6778e+02_r8,2.7584e+02_r8, &
     &1.8389e+02_r8,9.1946e+01_r8,1.0345e+01_r8/)
      kao(:, 2, 5,10) = (/ &
     &1.0082e+03_r8,8.8219e+02_r8,7.5616e+02_r8,6.3013e+02_r8,5.0411e+02_r8,3.7808e+02_r8, &
     &2.5205e+02_r8,1.2603e+02_r8,1.0318e+01_r8/)
      kao(:, 3, 5,10) = (/ &
     &1.3203e+03_r8,1.1552e+03_r8,9.9020e+02_r8,8.2516e+02_r8,6.6013e+02_r8,4.9510e+02_r8, &
     &3.3007e+02_r8,1.6503e+02_r8,1.0269e+01_r8/)
      kao(:, 4, 5,10) = (/ &
     &1.6790e+03_r8,1.4691e+03_r8,1.2593e+03_r8,1.0494e+03_r8,8.3951e+02_r8,6.2963e+02_r8, &
     &4.1976e+02_r8,2.0988e+02_r8,1.0211e+01_r8/)
      kao(:, 5, 5,10) = (/ &
     &2.0720e+03_r8,1.8130e+03_r8,1.5540e+03_r8,1.2950e+03_r8,1.0360e+03_r8,7.7699e+02_r8, &
     &5.1799e+02_r8,2.5900e+02_r8,1.0128e+01_r8/)
      kao(:, 1, 6,10) = (/ &
     &4.9443e+02_r8,4.3263e+02_r8,3.7082e+02_r8,3.0902e+02_r8,2.4721e+02_r8,1.8541e+02_r8, &
     &1.2361e+02_r8,6.1804e+01_r8,1.1088e+01_r8/)
      kao(:, 2, 6,10) = (/ &
     &6.9842e+02_r8,6.1111e+02_r8,5.2381e+02_r8,4.3651e+02_r8,3.4921e+02_r8,2.6191e+02_r8, &
     &1.7460e+02_r8,8.7302e+01_r8,1.1041e+01_r8/)
      kao(:, 3, 6,10) = (/ &
     &9.3821e+02_r8,8.2094e+02_r8,7.0366e+02_r8,5.8638e+02_r8,4.6911e+02_r8,3.5183e+02_r8, &
     &2.3455e+02_r8,1.1728e+02_r8,1.0988e+01_r8/)
      kao(:, 4, 6,10) = (/ &
     &1.2155e+03_r8,1.0636e+03_r8,9.1165e+02_r8,7.5971e+02_r8,6.0777e+02_r8,4.5582e+02_r8, &
     &3.0388e+02_r8,1.5194e+02_r8,1.0913e+01_r8/)
      kao(:, 5, 6,10) = (/ &
     &1.5286e+03_r8,1.3375e+03_r8,1.1464e+03_r8,9.5536e+02_r8,7.6429e+02_r8,5.7321e+02_r8, &
     &3.8214e+02_r8,1.9107e+02_r8,1.0808e+01_r8/)
      kao(:, 1, 7,10) = (/ &
     &3.2977e+02_r8,2.8854e+02_r8,2.4732e+02_r8,2.0610e+02_r8,1.6488e+02_r8,1.2366e+02_r8, &
     &8.2441e+01_r8,4.1221e+01_r8,1.1566e+01_r8/)
      kao(:, 2, 7,10) = (/ &
     &4.8209e+02_r8,4.2183e+02_r8,3.6157e+02_r8,3.0131e+02_r8,2.4104e+02_r8,1.8078e+02_r8, &
     &1.2052e+02_r8,6.0261e+01_r8,1.1564e+01_r8/)
      kao(:, 3, 7,10) = (/ &
     &6.6530e+02_r8,5.8214e+02_r8,4.9898e+02_r8,4.1581e+02_r8,3.3265e+02_r8,2.4949e+02_r8, &
     &1.6632e+02_r8,8.3163e+01_r8,1.1535e+01_r8/)
      kao(:, 4, 7,10) = (/ &
     &8.8049e+02_r8,7.7043e+02_r8,6.6036e+02_r8,5.5030e+02_r8,4.4024e+02_r8,3.3018e+02_r8, &
     &2.2012e+02_r8,1.1006e+02_r8,1.1437e+01_r8/)
      kao(:, 5, 7,10) = (/ &
     &1.1278e+03_r8,9.8684e+02_r8,8.4586e+02_r8,7.0488e+02_r8,5.6391e+02_r8,4.2293e+02_r8, &
     &2.8195e+02_r8,1.4098e+02_r8,1.1316e+01_r8/)
      kao(:, 1, 8,10) = (/ &
     &2.2204e+02_r8,1.9428e+02_r8,1.6653e+02_r8,1.3877e+02_r8,1.1102e+02_r8,8.3264e+01_r8, &
     &5.5510e+01_r8,3.0059e+01_r8,1.1861e+01_r8/)
      kao(:, 2, 8,10) = (/ &
     &3.3638e+02_r8,2.9433e+02_r8,2.5228e+02_r8,2.1024e+02_r8,1.6819e+02_r8,1.2614e+02_r8, &
     &8.4095e+01_r8,4.2076e+01_r8,1.1785e+01_r8/)
      kao(:, 3, 8,10) = (/ &
     &4.7771e+02_r8,4.1800e+02_r8,3.5828e+02_r8,2.9857e+02_r8,2.3886e+02_r8,1.7914e+02_r8, &
     &1.1943e+02_r8,5.9714e+01_r8,1.1693e+01_r8/)
      kao(:, 4, 8,10) = (/ &
     &6.4744e+02_r8,5.6651e+02_r8,4.8558e+02_r8,4.0465e+02_r8,3.2372e+02_r8,2.4279e+02_r8, &
     &1.6186e+02_r8,8.0931e+01_r8,1.1572e+01_r8/)
      kao(:, 5, 8,10) = (/ &
     &8.4463e+02_r8,7.3905e+02_r8,6.3347e+02_r8,5.2789e+02_r8,4.2232e+02_r8,3.1674e+02_r8, &
     &2.1116e+02_r8,1.0558e+02_r8,1.1447e+01_r8/)
      kao(:, 1, 9,10) = (/ &
     &1.4633e+02_r8,1.2804e+02_r8,1.0975e+02_r8,9.1455e+01_r8,7.3164e+01_r8,5.4873e+01_r8, &
     &3.7228e+01_r8,2.6999e+01_r8,1.1829e+01_r8/)
      kao(:, 2, 9,10) = (/ &
     &2.2961e+02_r8,2.0091e+02_r8,1.7220e+02_r8,1.4350e+02_r8,1.1480e+02_r8,8.6102e+01_r8, &
     &5.7402e+01_r8,3.3291e+01_r8,1.1753e+01_r8/)
      kao(:, 3, 9,10) = (/ &
     &3.3705e+02_r8,2.9492e+02_r8,2.5279e+02_r8,2.1066e+02_r8,1.6852e+02_r8,1.2639e+02_r8, &
     &8.4263e+01_r8,4.2726e+01_r8,1.1656e+01_r8/)
      kao(:, 4, 9,10) = (/ &
     &4.6791e+02_r8,4.0942e+02_r8,3.5094e+02_r8,2.9245e+02_r8,2.3396e+02_r8,1.7547e+02_r8, &
     &1.1698e+02_r8,5.8490e+01_r8,1.1546e+01_r8/)
      kao(:, 5, 9,10) = (/ &
     &6.2380e+02_r8,5.4582e+02_r8,4.6785e+02_r8,3.8987e+02_r8,3.1190e+02_r8,2.3392e+02_r8, &
     &1.5595e+02_r8,7.7975e+01_r8,1.1440e+01_r8/)
      kao(:, 1,10,10) = (/ &
     &9.9121e+01_r8,8.6731e+01_r8,7.4340e+01_r8,6.1950e+01_r8,4.9560e+01_r8,3.7719e+01_r8, &
     &3.0913e+01_r8,2.3571e+01_r8,1.2025e+01_r8/)
      kao(:, 2,10,10) = (/ &
     &1.5969e+02_r8,1.3973e+02_r8,1.1977e+02_r8,9.9804e+01_r8,7.9844e+01_r8,5.9883e+01_r8, &
     &4.1267e+01_r8,2.9611e+01_r8,1.1959e+01_r8/)
      kao(:, 3,10,10) = (/ &
     &2.4182e+02_r8,2.1160e+02_r8,1.8137e+02_r8,1.5114e+02_r8,1.2091e+02_r8,9.0684e+01_r8, &
     &6.0456e+01_r8,3.6780e+01_r8,1.1864e+01_r8/)
      kao(:, 4,10,10) = (/ &
     &3.4325e+02_r8,3.0034e+02_r8,2.5744e+02_r8,2.1453e+02_r8,1.7163e+02_r8,1.2872e+02_r8, &
     &8.5813e+01_r8,4.5301e+01_r8,1.1768e+01_r8/)
      kao(:, 5,10,10) = (/ &
     &4.6649e+02_r8,4.0818e+02_r8,3.4987e+02_r8,2.9156e+02_r8,2.3325e+02_r8,1.7493e+02_r8, &
     &1.1662e+02_r8,5.8448e+01_r8,1.1666e+01_r8/)
      kao(:, 1,11,10) = (/ &
     &8.4453e+01_r8,7.3896e+01_r8,6.3339e+01_r8,5.2783e+01_r8,4.2282e+01_r8,3.5008e+01_r8, &
     &3.0468e+01_r8,2.2795e+01_r8,1.2480e+01_r8/)
      kao(:, 2,11,10) = (/ &
     &1.3606e+02_r8,1.1905e+02_r8,1.0204e+02_r8,8.5035e+01_r8,6.8028e+01_r8,5.1171e+01_r8, &
     &3.9405e+01_r8,2.8346e+01_r8,1.2418e+01_r8/)
      kao(:, 3,11,10) = (/ &
     &2.0562e+02_r8,1.7991e+02_r8,1.5421e+02_r8,1.2851e+02_r8,1.0281e+02_r8,7.7106e+01_r8, &
     &5.2236e+01_r8,3.5283e+01_r8,1.2333e+01_r8/)
      kao(:, 4,11,10) = (/ &
     &2.9197e+02_r8,2.5547e+02_r8,2.1898e+02_r8,1.8248e+02_r8,1.4598e+02_r8,1.0949e+02_r8, &
     &7.2992e+01_r8,4.3383e+01_r8,1.2243e+01_r8/)
      kao(:, 5,11,10) = (/ &
     &3.9645e+02_r8,3.4690e+02_r8,2.9734e+02_r8,2.4778e+02_r8,1.9823e+02_r8,1.4867e+02_r8, &
     &9.9113e+01_r8,5.2639e+01_r8,1.2132e+01_r8/)
      kao(:, 1,12,10) = (/ &
     &7.3008e+01_r8,6.3882e+01_r8,5.4756e+01_r8,4.5630e+01_r8,3.8097e+01_r8,3.4292e+01_r8, &
     &2.9157e+01_r8,2.1820e+01_r8,1.2784e+01_r8/)
      kao(:, 2,12,10) = (/ &
     &1.1777e+02_r8,1.0304e+02_r8,8.8324e+01_r8,7.3604e+01_r8,5.8883e+01_r8,4.6283e+01_r8, &
     &3.8218e+01_r8,2.7110e+01_r8,1.2693e+01_r8/)
      kao(:, 3,12,10) = (/ &
     &1.7754e+02_r8,1.5535e+02_r8,1.3316e+02_r8,1.1096e+02_r8,8.8771e+01_r8,6.6578e+01_r8, &
     &4.9180e+01_r8,3.3603e+01_r8,1.2566e+01_r8/)
      kao(:, 4,12,10) = (/ &
     &2.5172e+02_r8,2.2026e+02_r8,1.8879e+02_r8,1.5733e+02_r8,1.2586e+02_r8,9.4396e+01_r8, &
     &6.3855e+01_r8,4.1285e+01_r8,1.2431e+01_r8/)
      kao(:, 5,12,10) = (/ &
     &3.4203e+02_r8,2.9928e+02_r8,2.5652e+02_r8,2.1377e+02_r8,1.7102e+02_r8,1.2826e+02_r8, &
     &8.5508e+01_r8,5.0087e+01_r8,1.2252e+01_r8/)
      kao(:, 1,13,10) = (/ &
     &6.5744e+01_r8,5.7526e+01_r8,4.9308e+01_r8,4.1412e+01_r8,3.7107e+01_r8,3.3686e+01_r8, &
     &2.7959e+01_r8,2.0954e+01_r8,1.2543e+01_r8/)
      kao(:, 2,13,10) = (/ &
     &1.0592e+02_r8,9.2679e+01_r8,7.9440e+01_r8,6.6200e+01_r8,5.3492e+01_r8,4.5296e+01_r8, &
     &3.7012e+01_r8,2.6073e+01_r8,1.2385e+01_r8/)
      kao(:, 3,13,10) = (/ &
     &1.5952e+02_r8,1.3958e+02_r8,1.1964e+02_r8,9.9699e+01_r8,7.9759e+01_r8,6.0961e+01_r8, &
     &4.7985e+01_r8,3.2430e+01_r8,1.2250e+01_r8/)
      kao(:, 4,13,10) = (/ &
     &2.2626e+02_r8,1.9798e+02_r8,1.6969e+02_r8,1.4141e+02_r8,1.1313e+02_r8,8.4848e+01_r8, &
     &6.0965e+01_r8,3.9929e+01_r8,1.2100e+01_r8/)
      kao(:, 5,13,10) = (/ &
     &3.0736e+02_r8,2.6894e+02_r8,2.3052e+02_r8,1.9210e+02_r8,1.5368e+02_r8,1.1526e+02_r8, &
     &7.7678e+01_r8,4.8494e+01_r8,1.1980e+01_r8/)
      kao(:, 1, 1,11) = (/ &
     &3.9010e+03_r8,3.4134e+03_r8,2.9257e+03_r8,2.4381e+03_r8,1.9505e+03_r8,1.4629e+03_r8, &
     &9.7525e+02_r8,4.8762e+02_r8,2.5641e-03_r8/)
      kao(:, 2, 1,11) = (/ &
     &4.8941e+03_r8,4.2823e+03_r8,3.6706e+03_r8,3.0588e+03_r8,2.4471e+03_r8,1.8353e+03_r8, &
     &1.2235e+03_r8,6.1176e+02_r8,4.7147e-03_r8/)
      kao(:, 3, 1,11) = (/ &
     &6.0244e+03_r8,5.2713e+03_r8,4.5183e+03_r8,3.7652e+03_r8,3.0122e+03_r8,2.2591e+03_r8, &
     &1.5061e+03_r8,7.5305e+02_r8,1.8229e-02_r8/)
      kao(:, 4, 1,11) = (/ &
     &7.2726e+03_r8,6.3635e+03_r8,5.4544e+03_r8,4.5454e+03_r8,3.6363e+03_r8,2.7272e+03_r8, &
     &1.8181e+03_r8,9.0907e+02_r8,4.1403e-02_r8/)
      kao(:, 5, 1,11) = (/ &
     &8.6200e+03_r8,7.5425e+03_r8,6.4650e+03_r8,5.3875e+03_r8,4.3100e+03_r8,3.2325e+03_r8, &
     &2.1550e+03_r8,1.0775e+03_r8,7.0391e-01_r8/)
      kao(:, 1, 2,11) = (/ &
     &3.0926e+03_r8,2.7060e+03_r8,2.3194e+03_r8,1.9329e+03_r8,1.5463e+03_r8,1.1597e+03_r8, &
     &7.7315e+02_r8,3.8657e+02_r8,1.4758e-01_r8/)
      kao(:, 2, 2,11) = (/ &
     &3.9512e+03_r8,3.4573e+03_r8,2.9634e+03_r8,2.4695e+03_r8,1.9756e+03_r8,1.4817e+03_r8, &
     &9.8779e+02_r8,4.9390e+02_r8,7.5464e-01_r8/)
      kao(:, 3, 2,11) = (/ &
     &4.9225e+03_r8,4.3072e+03_r8,3.6919e+03_r8,3.0766e+03_r8,2.4613e+03_r8,1.8460e+03_r8, &
     &1.2306e+03_r8,6.1532e+02_r8,2.2469e+00_r8/)
      kao(:, 4, 2,11) = (/ &
     &6.0042e+03_r8,5.2537e+03_r8,4.5032e+03_r8,3.7526e+03_r8,3.0021e+03_r8,2.2516e+03_r8, &
     &1.5011e+03_r8,7.5053e+02_r8,4.5134e+00_r8/)
      kao(:, 5, 2,11) = (/ &
     &7.1983e+03_r8,6.2985e+03_r8,5.3987e+03_r8,4.4989e+03_r8,3.5991e+03_r8,2.6994e+03_r8, &
     &1.7996e+03_r8,8.9979e+02_r8,5.4294e+00_r8/)
      kao(:, 1, 3,11) = (/ &
     &2.3009e+03_r8,2.0133e+03_r8,1.7257e+03_r8,1.4381e+03_r8,1.1505e+03_r8,8.6285e+02_r8, &
     &5.7523e+02_r8,2.8762e+02_r8,4.0343e+00_r8/)
      kao(:, 2, 3,11) = (/ &
     &2.9916e+03_r8,2.6177e+03_r8,2.2437e+03_r8,1.8698e+03_r8,1.4958e+03_r8,1.1219e+03_r8, &
     &7.4790e+02_r8,3.7395e+02_r8,9.4960e+00_r8/)
      kao(:, 3, 3,11) = (/ &
     &3.7957e+03_r8,3.3213e+03_r8,2.8468e+03_r8,2.3723e+03_r8,1.8979e+03_r8,1.4234e+03_r8, &
     &9.4893e+02_r8,4.7447e+02_r8,9.8961e+00_r8/)
      kao(:, 4, 3,11) = (/ &
     &4.7090e+03_r8,4.1204e+03_r8,3.5318e+03_r8,2.9432e+03_r8,2.3545e+03_r8,1.7659e+03_r8, &
     &1.1773e+03_r8,5.8863e+02_r8,9.8448e+00_r8/)
      kao(:, 5, 3,11) = (/ &
     &5.7119e+03_r8,4.9979e+03_r8,4.2839e+03_r8,3.5699e+03_r8,2.8560e+03_r8,2.1420e+03_r8, &
     &1.4280e+03_r8,7.1399e+02_r8,9.5434e+00_r8/)
      kao(:, 1, 4,11) = (/ &
     &1.6459e+03_r8,1.4402e+03_r8,1.2345e+03_r8,1.0287e+03_r8,8.2297e+02_r8,6.1723e+02_r8, &
     &4.1148e+02_r8,2.0574e+02_r8,1.1261e+01_r8/)
      kao(:, 2, 4,11) = (/ &
     &2.1944e+03_r8,1.9201e+03_r8,1.6458e+03_r8,1.3715e+03_r8,1.0972e+03_r8,8.2292e+02_r8, &
     &5.4861e+02_r8,2.7431e+02_r8,1.1246e+01_r8/)
      kao(:, 3, 4,11) = (/ &
     &2.8415e+03_r8,2.4863e+03_r8,2.1311e+03_r8,1.7759e+03_r8,1.4207e+03_r8,1.0656e+03_r8, &
     &7.1037e+02_r8,3.5519e+02_r8,1.1203e+01_r8/)
      kao(:, 4, 4,11) = (/ &
     &3.5819e+03_r8,3.1342e+03_r8,2.6865e+03_r8,2.2387e+03_r8,1.7910e+03_r8,1.3432e+03_r8, &
     &8.9549e+02_r8,4.4774e+02_r8,1.1137e+01_r8/)
      kao(:, 5, 4,11) = (/ &
     &4.4164e+03_r8,3.8643e+03_r8,3.3123e+03_r8,2.7602e+03_r8,2.2082e+03_r8,1.6561e+03_r8, &
     &1.1041e+03_r8,5.5205e+02_r8,1.1062e+01_r8/)
      kao(:, 1, 5,11) = (/ &
     &1.1573e+03_r8,1.0126e+03_r8,8.6797e+02_r8,7.2331e+02_r8,5.7865e+02_r8,4.3399e+02_r8, &
     &2.8932e+02_r8,1.4466e+02_r8,1.2627e+01_r8/)
      kao(:, 2, 5,11) = (/ &
     &1.5804e+03_r8,1.3829e+03_r8,1.1853e+03_r8,9.8775e+02_r8,7.9020e+02_r8,5.9265e+02_r8, &
     &3.9510e+02_r8,1.9755e+02_r8,1.2599e+01_r8/)
      kao(:, 3, 5,11) = (/ &
     &2.0873e+03_r8,1.8264e+03_r8,1.5655e+03_r8,1.3046e+03_r8,1.0437e+03_r8,7.8274e+02_r8, &
     &5.2183e+02_r8,2.6092e+02_r8,1.2536e+01_r8/)
      kao(:, 4, 5,11) = (/ &
     &2.6827e+03_r8,2.3473e+03_r8,2.0120e+03_r8,1.6767e+03_r8,1.3413e+03_r8,1.0060e+03_r8, &
     &6.7067e+02_r8,3.3534e+02_r8,1.2467e+01_r8/)
      kao(:, 5, 5,11) = (/ &
     &3.3592e+03_r8,2.9393e+03_r8,2.5194e+03_r8,2.0995e+03_r8,1.6796e+03_r8,1.2597e+03_r8, &
     &8.3980e+02_r8,4.1990e+02_r8,1.2393e+01_r8/)
      kao(:, 1, 6,11) = (/ &
     &7.9180e+02_r8,6.9282e+02_r8,5.9385e+02_r8,4.9487e+02_r8,3.9590e+02_r8,2.9692e+02_r8, &
     &1.9795e+02_r8,9.8975e+01_r8,1.3948e+01_r8/)
      kao(:, 2, 6,11) = (/ &
     &1.1067e+03_r8,9.6838e+02_r8,8.3004e+02_r8,6.9170e+02_r8,5.5336e+02_r8,4.1502e+02_r8, &
     &2.7668e+02_r8,1.3834e+02_r8,1.3917e+01_r8/)
      kao(:, 3, 6,11) = (/ &
     &1.4976e+03_r8,1.3104e+03_r8,1.1232e+03_r8,9.3600e+02_r8,7.4880e+02_r8,5.6160e+02_r8, &
     &3.7440e+02_r8,1.8720e+02_r8,1.3860e+01_r8/)
      kao(:, 4, 6,11) = (/ &
     &1.9619e+03_r8,1.7167e+03_r8,1.4715e+03_r8,1.2262e+03_r8,9.8097e+02_r8,7.3573e+02_r8, &
     &4.9049e+02_r8,2.4524e+02_r8,1.3785e+01_r8/)
      kao(:, 5, 6,11) = (/ &
     &2.4991e+03_r8,2.1867e+03_r8,1.8743e+03_r8,1.5619e+03_r8,1.2496e+03_r8,9.3716e+02_r8, &
     &6.2477e+02_r8,3.1239e+02_r8,1.3707e+01_r8/)
      kao(:, 1, 7,11) = (/ &
     &5.3794e+02_r8,4.7070e+02_r8,4.0346e+02_r8,3.3621e+02_r8,2.6897e+02_r8,2.0173e+02_r8, &
     &1.3449e+02_r8,6.7243e+01_r8,1.5200e+01_r8/)
      kao(:, 2, 7,11) = (/ &
     &7.7168e+02_r8,6.7522e+02_r8,5.7876e+02_r8,4.8230e+02_r8,3.8584e+02_r8,2.8938e+02_r8, &
     &1.9292e+02_r8,9.6460e+01_r8,1.5161e+01_r8/)
      kao(:, 3, 7,11) = (/ &
     &1.0690e+03_r8,9.3537e+02_r8,8.0174e+02_r8,6.6812e+02_r8,5.3449e+02_r8,4.0087e+02_r8, &
     &2.6725e+02_r8,1.3362e+02_r8,1.5097e+01_r8/)
      kao(:, 4, 7,11) = (/ &
     &1.4303e+03_r8,1.2515e+03_r8,1.0727e+03_r8,8.9396e+02_r8,7.1516e+02_r8,5.3637e+02_r8, &
     &3.5758e+02_r8,1.7879e+02_r8,1.5017e+01_r8/)
      kao(:, 5, 7,11) = (/ &
     &1.8576e+03_r8,1.6254e+03_r8,1.3932e+03_r8,1.1610e+03_r8,9.2880e+02_r8,6.9660e+02_r8, &
     &4.6440e+02_r8,2.3220e+02_r8,1.4920e+01_r8/)
      kao(:, 1, 8,11) = (/ &
     &3.6857e+02_r8,3.2250e+02_r8,2.7643e+02_r8,2.3036e+02_r8,1.8428e+02_r8,1.3821e+02_r8, &
     &9.2143e+01_r8,4.6072e+01_r8,1.6297e+01_r8/)
      kao(:, 2, 8,11) = (/ &
     &5.4427e+02_r8,4.7624e+02_r8,4.0820e+02_r8,3.4017e+02_r8,2.7214e+02_r8,2.0410e+02_r8, &
     &1.3607e+02_r8,6.8035e+01_r8,1.6238e+01_r8/)
      kao(:, 3, 8,11) = (/ &
     &7.7191e+02_r8,6.7542e+02_r8,5.7893e+02_r8,4.8244e+02_r8,3.8595e+02_r8,2.8947e+02_r8, &
     &1.9298e+02_r8,9.6489e+01_r8,1.6155e+01_r8/)
      kao(:, 4, 8,11) = (/ &
     &1.0564e+03_r8,9.2435e+02_r8,7.9230e+02_r8,6.6025e+02_r8,5.2820e+02_r8,3.9615e+02_r8, &
     &2.6410e+02_r8,1.3205e+02_r8,1.6062e+01_r8/)
      kao(:, 5, 8,11) = (/ &
     &1.3972e+03_r8,1.2225e+03_r8,1.0479e+03_r8,8.7322e+02_r8,6.9858e+02_r8,5.2393e+02_r8, &
     &3.4929e+02_r8,1.7465e+02_r8,1.5943e+01_r8/)
      kao(:, 1, 9,11) = (/ &
     &2.4734e+02_r8,2.1642e+02_r8,1.8550e+02_r8,1.5459e+02_r8,1.2367e+02_r8,9.2751e+01_r8, &
     &6.1834e+01_r8,3.4329e+01_r8,1.7139e+01_r8/)
      kao(:, 2, 9,11) = (/ &
     &3.7646e+02_r8,3.2941e+02_r8,2.8235e+02_r8,2.3529e+02_r8,1.8823e+02_r8,1.4117e+02_r8, &
     &9.4116e+01_r8,4.7119e+01_r8,1.7064e+01_r8/)
      kao(:, 3, 9,11) = (/ &
     &5.4702e+02_r8,4.7864e+02_r8,4.1027e+02_r8,3.4189e+02_r8,2.7351e+02_r8,2.0513e+02_r8, &
     &1.3676e+02_r8,6.8378e+01_r8,1.6972e+01_r8/)
      kao(:, 4, 9,11) = (/ &
     &7.6564e+02_r8,6.6994e+02_r8,5.7423e+02_r8,4.7853e+02_r8,3.8282e+02_r8,2.8712e+02_r8, &
     &1.9141e+02_r8,9.5706e+01_r8,1.6856e+01_r8/)
      kao(:, 5, 9,11) = (/ &
     &1.0333e+03_r8,9.0412e+02_r8,7.7496e+02_r8,6.4580e+02_r8,5.1664e+02_r8,3.8748e+02_r8, &
     &2.5832e+02_r8,1.2916e+02_r8,1.6713e+01_r8/)
      kao(:, 1,10,11) = (/ &
     &1.6975e+02_r8,1.4853e+02_r8,1.2731e+02_r8,1.0609e+02_r8,8.4874e+01_r8,6.3656e+01_r8, &
     &4.3000e+01_r8,3.1831e+01_r8,1.7572e+01_r8/)
      kao(:, 2,10,11) = (/ &
     &2.6544e+02_r8,2.3226e+02_r8,1.9908e+02_r8,1.6590e+02_r8,1.3272e+02_r8,9.9541e+01_r8, &
     &6.6361e+01_r8,3.9122e+01_r8,1.7485e+01_r8/)
      kao(:, 3,10,11) = (/ &
     &3.9471e+02_r8,3.4537e+02_r8,2.9603e+02_r8,2.4669e+02_r8,1.9735e+02_r8,1.4801e+02_r8, &
     &9.8676e+01_r8,5.0382e+01_r8,1.7381e+01_r8/)
      kao(:, 4,10,11) = (/ &
     &5.6315e+02_r8,4.9275e+02_r8,4.2236e+02_r8,3.5197e+02_r8,2.8157e+02_r8,2.1118e+02_r8, &
     &1.4079e+02_r8,7.0394e+01_r8,1.7247e+01_r8/)
      kao(:, 5,10,11) = (/ &
     &7.7410e+02_r8,6.7734e+02_r8,5.8057e+02_r8,4.8381e+02_r8,3.8705e+02_r8,2.9029e+02_r8, &
     &1.9352e+02_r8,9.6763e+01_r8,1.7092e+01_r8/)
      kao(:, 1,11,11) = (/ &
     &1.4476e+02_r8,1.2667e+02_r8,1.0857e+02_r8,9.0475e+01_r8,7.2380e+01_r8,5.4285e+01_r8, &
     &4.0590e+01_r8,3.2171e+01_r8,1.7597e+01_r8/)
      kao(:, 2,11,11) = (/ &
     &2.2628e+02_r8,1.9800e+02_r8,1.6971e+02_r8,1.4143e+02_r8,1.1314e+02_r8,8.4856e+01_r8, &
     &5.6719e+01_r8,3.9479e+01_r8,1.7480e+01_r8/)
      kao(:, 3,11,11) = (/ &
     &3.3682e+02_r8,2.9472e+02_r8,2.5262e+02_r8,2.1051e+02_r8,1.6841e+02_r8,1.2631e+02_r8, &
     &8.4204e+01_r8,4.8355e+01_r8,1.7349e+01_r8/)
      kao(:, 4,11,11) = (/ &
     &4.8164e+02_r8,4.2144e+02_r8,3.6123e+02_r8,3.0103e+02_r8,2.4082e+02_r8,1.8062e+02_r8, &
     &1.2041e+02_r8,6.1572e+01_r8,1.7186e+01_r8/)
      kao(:, 5,11,11) = (/ &
     &6.6267e+02_r8,5.7984e+02_r8,4.9701e+02_r8,4.1417e+02_r8,3.3134e+02_r8,2.4850e+02_r8, &
     &1.6567e+02_r8,8.2835e+01_r8,1.7015e+01_r8/)
      kao(:, 1,12,11) = (/ &
     &1.2510e+02_r8,1.0946e+02_r8,9.3823e+01_r8,7.8186e+01_r8,6.2549e+01_r8,4.8100e+01_r8, &
     &4.0318e+01_r8,3.2221e+01_r8,1.7708e+01_r8/)
      kao(:, 2,12,11) = (/ &
     &1.9563e+02_r8,1.7117e+02_r8,1.4672e+02_r8,1.2227e+02_r8,9.7813e+01_r8,7.3360e+01_r8, &
     &5.2529e+01_r8,3.9562e+01_r8,1.7612e+01_r8/)
      kao(:, 3,12,11) = (/ &
     &2.9201e+02_r8,2.5551e+02_r8,2.1901e+02_r8,1.8251e+02_r8,1.4600e+02_r8,1.0950e+02_r8, &
     &7.3154e+01_r8,4.8447e+01_r8,1.7481e+01_r8/)
      kao(:, 4,12,11) = (/ &
     &4.1774e+02_r8,3.6552e+02_r8,3.1331e+02_r8,2.6109e+02_r8,2.0887e+02_r8,1.5665e+02_r8, &
     &1.0444e+02_r8,5.8915e+01_r8,1.7339e+01_r8/)
      kao(:, 5,12,11) = (/ &
     &5.7504e+02_r8,5.0316e+02_r8,4.3128e+02_r8,3.5940e+02_r8,2.8752e+02_r8,2.1564e+02_r8, &
     &1.4376e+02_r8,7.3682e+01_r8,1.7186e+01_r8/)
      kao(:, 1,13,11) = (/ &
     &1.1264e+02_r8,9.8561e+01_r8,8.4481e+01_r8,7.0401e+01_r8,5.6432e+01_r8,4.7061e+01_r8, &
     &4.0409e+01_r8,3.2253e+01_r8,1.8302e+01_r8/)
      kao(:, 2,13,11) = (/ &
     &1.7621e+02_r8,1.5419e+02_r8,1.3216e+02_r8,1.1013e+02_r8,8.8108e+01_r8,6.6456e+01_r8, &
     &5.2592e+01_r8,3.9667e+01_r8,1.8194e+01_r8/)
      kao(:, 3,13,11) = (/ &
     &2.6303e+02_r8,2.3015e+02_r8,1.9727e+02_r8,1.6440e+02_r8,1.3152e+02_r8,9.8638e+01_r8, &
     &6.8547e+01_r8,4.8772e+01_r8,1.8071e+01_r8/)
      kao(:, 4,13,11) = (/ &
     &3.7673e+02_r8,3.2964e+02_r8,2.8255e+02_r8,2.3546e+02_r8,1.8837e+02_r8,1.4128e+02_r8, &
     &9.4251e+01_r8,5.9423e+01_r8,1.7926e+01_r8/)
      kao(:, 5,13,11) = (/ &
     &5.1904e+02_r8,4.5416e+02_r8,3.8928e+02_r8,3.2440e+02_r8,2.5952e+02_r8,1.9464e+02_r8, &
     &1.2976e+02_r8,7.1698e+01_r8,1.7708e+01_r8/)
      kao(:, 1, 1,12) = (/ &
     &6.1566e+03_r8,5.3871e+03_r8,4.6175e+03_r8,3.8479e+03_r8,3.0783e+03_r8,2.3087e+03_r8, &
     &1.5392e+03_r8,7.6958e+02_r8,3.6622e-03_r8/)
      kao(:, 2, 1,12) = (/ &
     &7.8640e+03_r8,6.8810e+03_r8,5.8980e+03_r8,4.9150e+03_r8,3.9320e+03_r8,2.9490e+03_r8, &
     &1.9660e+03_r8,9.8301e+02_r8,3.6025e-03_r8/)
      kao(:, 3, 1,12) = (/ &
     &9.7949e+03_r8,8.5705e+03_r8,7.3462e+03_r8,6.1218e+03_r8,4.8974e+03_r8,3.6731e+03_r8, &
     &2.4487e+03_r8,1.2244e+03_r8,3.3010e-02_r8/)
      kao(:, 4, 1,12) = (/ &
     &1.1959e+04_r8,1.0464e+04_r8,8.9695e+03_r8,7.4746e+03_r8,5.9797e+03_r8,4.4847e+03_r8, &
     &2.9898e+03_r8,1.4949e+03_r8,6.0612e-02_r8/)
      kao(:, 5, 1,12) = (/ &
     &1.4386e+04_r8,1.2588e+04_r8,1.0790e+04_r8,8.9913e+03_r8,7.1931e+03_r8,5.3948e+03_r8, &
     &3.5965e+03_r8,1.7983e+03_r8,7.6915e-02_r8/)
      kao(:, 1, 2,12) = (/ &
     &5.0811e+03_r8,4.4460e+03_r8,3.8109e+03_r8,3.1757e+03_r8,2.5406e+03_r8,1.9054e+03_r8, &
     &1.2703e+03_r8,6.3514e+02_r8,2.7963e-01_r8/)
      kao(:, 2, 2,12) = (/ &
     &6.5891e+03_r8,5.7655e+03_r8,4.9418e+03_r8,4.1182e+03_r8,3.2946e+03_r8,2.4709e+03_r8, &
     &1.6473e+03_r8,8.2364e+02_r8,2.3002e+00_r8/)
      kao(:, 3, 2,12) = (/ &
     &8.3666e+03_r8,7.3208e+03_r8,6.2750e+03_r8,5.2291e+03_r8,4.1833e+03_r8,3.1375e+03_r8, &
     &2.0917e+03_r8,1.0458e+03_r8,4.9790e+00_r8/)
      kao(:, 4, 2,12) = (/ &
     &1.0356e+04_r8,9.0616e+03_r8,7.7671e+03_r8,6.4726e+03_r8,5.1781e+03_r8,3.8836e+03_r8, &
     &2.5890e+03_r8,1.2945e+03_r8,6.0169e+00_r8/)
      kao(:, 5, 2,12) = (/ &
     &1.2531e+04_r8,1.0965e+04_r8,9.3984e+03_r8,7.8320e+03_r8,6.2656e+03_r8,4.6992e+03_r8, &
     &3.1328e+03_r8,1.5664e+03_r8,6.8160e+00_r8/)
      kao(:, 1, 3,12) = (/ &
     &3.8913e+03_r8,3.4049e+03_r8,2.9185e+03_r8,2.4321e+03_r8,1.9457e+03_r8,1.4593e+03_r8, &
     &9.7284e+02_r8,4.8642e+02_r8,1.1253e+01_r8/)
      kao(:, 2, 3,12) = (/ &
     &5.1870e+03_r8,4.5386e+03_r8,3.8902e+03_r8,3.2418e+03_r8,2.5935e+03_r8,1.9451e+03_r8, &
     &1.2967e+03_r8,6.4837e+02_r8,1.1246e+01_r8/)
      kao(:, 3, 3,12) = (/ &
     &6.6906e+03_r8,5.8543e+03_r8,5.0180e+03_r8,4.1816e+03_r8,3.3453e+03_r8,2.5090e+03_r8, &
     &1.6727e+03_r8,8.3633e+02_r8,1.1235e+01_r8/)
      kao(:, 4, 3,12) = (/ &
     &8.4124e+03_r8,7.3608e+03_r8,6.3093e+03_r8,5.2577e+03_r8,4.2062e+03_r8,3.1546e+03_r8, &
     &2.1031e+03_r8,1.0515e+03_r8,1.1206e+01_r8/)
      kao(:, 5, 3,12) = (/ &
     &1.0381e+04_r8,9.0837e+03_r8,7.7860e+03_r8,6.4883e+03_r8,5.1907e+03_r8,3.8930e+03_r8, &
     &2.5953e+03_r8,1.2977e+03_r8,1.1154e+01_r8/)
      kao(:, 1, 4,12) = (/ &
     &2.8697e+03_r8,2.5110e+03_r8,2.1523e+03_r8,1.7936e+03_r8,1.4349e+03_r8,1.0761e+03_r8, &
     &7.1743e+02_r8,3.5872e+02_r8,1.3022e+01_r8/)
      kao(:, 2, 4,12) = (/ &
     &3.9101e+03_r8,3.4213e+03_r8,2.9326e+03_r8,2.4438e+03_r8,1.9551e+03_r8,1.4663e+03_r8, &
     &9.7753e+02_r8,4.8877e+02_r8,1.3025e+01_r8/)
      kao(:, 3, 4,12) = (/ &
     &5.1573e+03_r8,4.5126e+03_r8,3.8680e+03_r8,3.2233e+03_r8,2.5786e+03_r8,1.9340e+03_r8, &
     &1.2893e+03_r8,6.4466e+02_r8,1.3008e+01_r8/)
      kao(:, 4, 4,12) = (/ &
     &6.6403e+03_r8,5.8103e+03_r8,4.9802e+03_r8,4.1502e+03_r8,3.3201e+03_r8,2.4901e+03_r8, &
     &1.6601e+03_r8,8.3004e+02_r8,1.2981e+01_r8/)
      kao(:, 5, 4,12) = (/ &
     &8.3023e+03_r8,7.2645e+03_r8,6.2267e+03_r8,5.1889e+03_r8,4.1511e+03_r8,3.1134e+03_r8, &
     &2.0756e+03_r8,1.0378e+03_r8,1.2927e+01_r8/)
      kao(:, 1, 5,12) = (/ &
     &2.0574e+03_r8,1.8002e+03_r8,1.5431e+03_r8,1.2859e+03_r8,1.0287e+03_r8,7.7153e+02_r8, &
     &5.1435e+02_r8,2.5718e+02_r8,1.4941e+01_r8/)
      kao(:, 2, 5,12) = (/ &
     &2.8796e+03_r8,2.5197e+03_r8,2.1597e+03_r8,1.7998e+03_r8,1.4398e+03_r8,1.0799e+03_r8, &
     &7.1991e+02_r8,3.5996e+02_r8,1.4958e+01_r8/)
      kao(:, 3, 5,12) = (/ &
     &3.9044e+03_r8,3.4163e+03_r8,2.9283e+03_r8,2.4402e+03_r8,1.9522e+03_r8,1.4641e+03_r8, &
     &9.7610e+02_r8,4.8805e+02_r8,1.4965e+01_r8/)
      kao(:, 4, 5,12) = (/ &
     &5.1045e+03_r8,4.4665e+03_r8,3.8284e+03_r8,3.1903e+03_r8,2.5523e+03_r8,1.9142e+03_r8, &
     &1.2761e+03_r8,6.3807e+02_r8,1.4927e+01_r8/)
      kao(:, 5, 5,12) = (/ &
     &6.5127e+03_r8,5.6986e+03_r8,4.8846e+03_r8,4.0705e+03_r8,3.2564e+03_r8,2.4423e+03_r8, &
     &1.6282e+03_r8,8.1409e+02_r8,1.4857e+01_r8/)
      kao(:, 1, 6,12) = (/ &
     &1.4218e+03_r8,1.2441e+03_r8,1.0663e+03_r8,8.8861e+02_r8,7.1089e+02_r8,5.3316e+02_r8, &
     &3.5544e+02_r8,1.7772e+02_r8,1.7034e+01_r8/)
      kao(:, 2, 6,12) = (/ &
     &2.0585e+03_r8,1.8012e+03_r8,1.5439e+03_r8,1.2865e+03_r8,1.0292e+03_r8,7.7193e+02_r8, &
     &5.1462e+02_r8,2.5731e+02_r8,1.7052e+01_r8/)
      kao(:, 3, 6,12) = (/ &
     &2.8529e+03_r8,2.4963e+03_r8,2.1397e+03_r8,1.7831e+03_r8,1.4265e+03_r8,1.0699e+03_r8, &
     &7.1324e+02_r8,3.5662e+02_r8,1.7043e+01_r8/)
      kao(:, 4, 6,12) = (/ &
     &3.8237e+03_r8,3.3458e+03_r8,2.8678e+03_r8,2.3898e+03_r8,1.9119e+03_r8,1.4339e+03_r8, &
     &9.5593e+02_r8,4.7797e+02_r8,1.6999e+01_r8/)
      kao(:, 5, 6,12) = (/ &
     &4.9757e+03_r8,4.3537e+03_r8,3.7318e+03_r8,3.1098e+03_r8,2.4878e+03_r8,1.8659e+03_r8, &
     &1.2439e+03_r8,6.2196e+02_r8,1.6923e+01_r8/)
      kao(:, 1, 7,12) = (/ &
     &9.7219e+02_r8,8.5066e+02_r8,7.2914e+02_r8,6.0761e+02_r8,4.8609e+02_r8,3.6457e+02_r8, &
     &2.4305e+02_r8,1.2152e+02_r8,1.9204e+01_r8/)
      kao(:, 2, 7,12) = (/ &
     &1.4501e+03_r8,1.2688e+03_r8,1.0876e+03_r8,9.0631e+02_r8,7.2505e+02_r8,5.4378e+02_r8, &
     &3.6252e+02_r8,1.8126e+02_r8,1.9225e+01_r8/)
      kao(:, 3, 7,12) = (/ &
     &2.0671e+03_r8,1.8087e+03_r8,1.5503e+03_r8,1.2919e+03_r8,1.0335e+03_r8,7.7515e+02_r8, &
     &5.1676e+02_r8,2.5838e+02_r8,1.9209e+01_r8/)
      kao(:, 4, 7,12) = (/ &
     &2.8414e+03_r8,2.4862e+03_r8,2.1311e+03_r8,1.7759e+03_r8,1.4207e+03_r8,1.0655e+03_r8, &
     &7.1035e+02_r8,3.5518e+02_r8,1.9156e+01_r8/)
      kao(:, 5, 7,12) = (/ &
     &3.7638e+03_r8,3.2933e+03_r8,2.8228e+03_r8,2.3524e+03_r8,1.8819e+03_r8,1.4114e+03_r8, &
     &9.4094e+02_r8,4.7047e+02_r8,1.9066e+01_r8/)
      kao(:, 1, 8,12) = (/ &
     &6.6611e+02_r8,5.8284e+02_r8,4.9958e+02_r8,4.1632e+02_r8,3.3305e+02_r8,2.4979e+02_r8, &
     &1.6653e+02_r8,8.3265e+01_r8,2.1374e+01_r8/)
      kao(:, 2, 8,12) = (/ &
     &1.0262e+03_r8,8.9794e+02_r8,7.6966e+02_r8,6.4139e+02_r8,5.1311e+02_r8,3.8483e+02_r8, &
     &2.5656e+02_r8,1.2828e+02_r8,2.1403e+01_r8/)
      kao(:, 3, 8,12) = (/ &
     &1.5100e+03_r8,1.3213e+03_r8,1.1325e+03_r8,9.4376e+02_r8,7.5501e+02_r8,5.6626e+02_r8, &
     &3.7751e+02_r8,1.8875e+02_r8,2.1385e+01_r8/)
      kao(:, 4, 8,12) = (/ &
     &2.1206e+03_r8,1.8555e+03_r8,1.5904e+03_r8,1.3254e+03_r8,1.0603e+03_r8,7.9522e+02_r8, &
     &5.3015e+02_r8,2.6507e+02_r8,2.1320e+01_r8/)
      kao(:, 5, 8,12) = (/ &
     &2.8794e+03_r8,2.5195e+03_r8,2.1596e+03_r8,1.7996e+03_r8,1.4397e+03_r8,1.0798e+03_r8, &
     &7.1985e+02_r8,3.5993e+02_r8,2.1216e+01_r8/)
      kao(:, 1, 9,12) = (/ &
     &4.4380e+02_r8,3.8832e+02_r8,3.3285e+02_r8,2.7737e+02_r8,2.2190e+02_r8,1.6642e+02_r8, &
     &1.1095e+02_r8,5.5475e+01_r8,2.3490e+01_r8/)
      kao(:, 2, 9,12) = (/ &
     &7.0869e+02_r8,6.2011e+02_r8,5.3152e+02_r8,4.4293e+02_r8,3.5435e+02_r8,2.6576e+02_r8, &
     &1.7717e+02_r8,8.8587e+01_r8,2.3505e+01_r8/)
      kao(:, 3, 9,12) = (/ &
     &1.0731e+03_r8,9.3894e+02_r8,8.0481e+02_r8,6.7067e+02_r8,5.3654e+02_r8,4.0240e+02_r8, &
     &2.6827e+02_r8,1.3414e+02_r8,2.3465e+01_r8/)
      kao(:, 4, 9,12) = (/ &
     &1.5496e+03_r8,1.3559e+03_r8,1.1622e+03_r8,9.6851e+02_r8,7.7481e+02_r8,5.8111e+02_r8, &
     &3.8741e+02_r8,1.9370e+02_r8,2.3379e+01_r8/)
      kao(:, 5, 9,12) = (/ &
     &2.1497e+03_r8,1.8810e+03_r8,1.6123e+03_r8,1.3436e+03_r8,1.0749e+03_r8,8.0615e+02_r8, &
     &5.3743e+02_r8,2.6872e+02_r8,2.3258e+01_r8/)
      kao(:, 1,10,12) = (/ &
     &3.0213e+02_r8,2.6436e+02_r8,2.2659e+02_r8,1.8883e+02_r8,1.5106e+02_r8,1.1330e+02_r8, &
     &7.5532e+01_r8,4.3106e+01_r8,2.5395e+01_r8/)
      kao(:, 2,10,12) = (/ &
     &4.9804e+02_r8,4.3578e+02_r8,3.7353e+02_r8,3.1127e+02_r8,2.4902e+02_r8,1.8676e+02_r8, &
     &1.2451e+02_r8,6.2505e+01_r8,2.5385e+01_r8/)
      kao(:, 3,10,12) = (/ &
     &7.7418e+02_r8,6.7741e+02_r8,5.8063e+02_r8,4.8386e+02_r8,3.8709e+02_r8,2.9032e+02_r8, &
     &1.9354e+02_r8,9.6773e+01_r8,2.5325e+01_r8/)
      kao(:, 4,10,12) = (/ &
     &1.1469e+03_r8,1.0035e+03_r8,8.6015e+02_r8,7.1679e+02_r8,5.7343e+02_r8,4.3007e+02_r8, &
     &2.8671e+02_r8,1.4336e+02_r8,2.5217e+01_r8/)
      kao(:, 5,10,12) = (/ &
     &1.6217e+03_r8,1.4190e+03_r8,1.2162e+03_r8,1.0135e+03_r8,8.1083e+02_r8,6.0812e+02_r8, &
     &4.0541e+02_r8,2.0271e+02_r8,2.5082e+01_r8/)
      kao(:, 1,11,12) = (/ &
     &2.6097e+02_r8,2.2835e+02_r8,1.9573e+02_r8,1.6311e+02_r8,1.3048e+02_r8,9.7863e+01_r8, &
     &6.5361e+01_r8,4.5364e+01_r8,2.6989e+01_r8/)
      kao(:, 2,11,12) = (/ &
     &4.3087e+02_r8,3.7701e+02_r8,3.2315e+02_r8,2.6929e+02_r8,2.1543e+02_r8,1.6158e+02_r8, &
     &1.0772e+02_r8,5.7754e+01_r8,2.6926e+01_r8/)
      kao(:, 3,11,12) = (/ &
     &6.7272e+02_r8,5.8863e+02_r8,5.0454e+02_r8,4.2045e+02_r8,3.3636e+02_r8,2.5227e+02_r8, &
     &1.6818e+02_r8,8.4156e+01_r8,2.6813e+01_r8/)
      kao(:, 4,11,12) = (/ &
     &9.9607e+02_r8,8.7156e+02_r8,7.4705e+02_r8,6.2254e+02_r8,4.9803e+02_r8,3.7353e+02_r8, &
     &2.4902e+02_r8,1.2451e+02_r8,2.6666e+01_r8/)
      kao(:, 5,11,12) = (/ &
     &1.4127e+03_r8,1.2361e+03_r8,1.0595e+03_r8,8.8291e+02_r8,7.0633e+02_r8,5.2975e+02_r8, &
     &3.5316e+02_r8,1.7658e+02_r8,2.6473e+01_r8/)
      kao(:, 1,12,12) = (/ &
     &2.2830e+02_r8,1.9976e+02_r8,1.7123e+02_r8,1.4269e+02_r8,1.1415e+02_r8,8.5613e+01_r8, &
     &6.0099e+01_r8,4.8249e+01_r8,2.8107e+01_r8/)
      kao(:, 2,12,12) = (/ &
     &3.7815e+02_r8,3.3089e+02_r8,2.8362e+02_r8,2.3635e+02_r8,1.8908e+02_r8,1.4181e+02_r8, &
     &9.4540e+01_r8,5.8332e+01_r8,2.7966e+01_r8/)
      kao(:, 3,12,12) = (/ &
     &5.9040e+02_r8,5.1660e+02_r8,4.4280e+02_r8,3.6900e+02_r8,2.9520e+02_r8,2.2140e+02_r8, &
     &1.4760e+02_r8,7.6746e+01_r8,2.7793e+01_r8/)
      kao(:, 4,12,12) = (/ &
     &8.7660e+02_r8,7.6702e+02_r8,6.5745e+02_r8,5.4787e+02_r8,4.3830e+02_r8,3.2873e+02_r8, &
     &2.1915e+02_r8,1.0959e+02_r8,2.7580e+01_r8/)
      kao(:, 5,12,12) = (/ &
     &1.2432e+03_r8,1.0878e+03_r8,9.3242e+02_r8,7.7702e+02_r8,6.2161e+02_r8,4.6621e+02_r8, &
     &3.1081e+02_r8,1.5540e+02_r8,2.7330e+01_r8/)
      kao(:, 1,13,12) = (/ &
     &2.0770e+02_r8,1.8173e+02_r8,1.5577e+02_r8,1.2981e+02_r8,1.0385e+02_r8,7.8129e+01_r8, &
     &6.0586e+01_r8,5.1072e+01_r8,2.8383e+01_r8/)
      kao(:, 2,13,12) = (/ &
     &3.4420e+02_r8,3.0118e+02_r8,2.5815e+02_r8,2.1513e+02_r8,1.7210e+02_r8,1.2908e+02_r8, &
     &8.7185e+01_r8,6.1802e+01_r8,2.8222e+01_r8/)
      kao(:, 3,13,12) = (/ &
     &5.3871e+02_r8,4.7137e+02_r8,4.0403e+02_r8,3.3670e+02_r8,2.6936e+02_r8,2.0202e+02_r8, &
     &1.3468e+02_r8,7.6219e+01_r8,2.8010e+01_r8/)
      kao(:, 4,13,12) = (/ &
     &7.9982e+02_r8,6.9985e+02_r8,5.9987e+02_r8,4.9989e+02_r8,3.9991e+02_r8,2.9994e+02_r8, &
     &1.9996e+02_r8,1.0196e+02_r8,2.7782e+01_r8/)
      kao(:, 5,13,12) = (/ &
     &1.1353e+03_r8,9.9341e+02_r8,8.5150e+02_r8,7.0958e+02_r8,5.6767e+02_r8,4.2575e+02_r8, &
     &2.8384e+02_r8,1.4192e+02_r8,2.7521e+01_r8/)
      kao(:, 1, 1,13) = (/ &
     &1.0877e+04_r8,9.5175e+03_r8,8.1579e+03_r8,6.7982e+03_r8,5.4386e+03_r8,4.0789e+03_r8, &
     &2.7193e+03_r8,1.3596e+03_r8,2.7375e-03_r8/)
      kao(:, 2, 1,13) = (/ &
     &1.4140e+04_r8,1.2372e+04_r8,1.0605e+04_r8,8.8373e+03_r8,7.0699e+03_r8,5.3024e+03_r8, &
     &3.5349e+03_r8,1.7675e+03_r8,2.6515e-03_r8/)
      kao(:, 3, 1,13) = (/ &
     &1.7904e+04_r8,1.5666e+04_r8,1.3428e+04_r8,1.1190e+04_r8,8.9519e+03_r8,6.7139e+03_r8, &
     &4.4759e+03_r8,2.2380e+03_r8,3.8993e-02_r8/)
      kao(:, 4, 1,13) = (/ &
     &2.2059e+04_r8,1.9302e+04_r8,1.6544e+04_r8,1.3787e+04_r8,1.1029e+04_r8,8.2721e+03_r8, &
     &5.5147e+03_r8,2.7574e+03_r8,9.2576e-02_r8/)
      kao(:, 5, 1,13) = (/ &
     &2.6544e+04_r8,2.3226e+04_r8,1.9908e+04_r8,1.6590e+04_r8,1.3272e+04_r8,9.9541e+03_r8, &
     &6.6361e+03_r8,3.3180e+03_r8,1.0695e-01_r8/)
      kao(:, 1, 2,13) = (/ &
     &9.6500e+03_r8,8.4437e+03_r8,7.2375e+03_r8,6.0312e+03_r8,4.8250e+03_r8,3.6187e+03_r8, &
     &2.4125e+03_r8,1.2062e+03_r8,3.2200e-01_r8/)
      kao(:, 2, 2,13) = (/ &
     &1.2735e+04_r8,1.1143e+04_r8,9.5512e+03_r8,7.9593e+03_r8,6.3674e+03_r8,4.7756e+03_r8, &
     &3.1837e+03_r8,1.5919e+03_r8,5.1280e+00_r8/)
      kao(:, 3, 2,13) = (/ &
     &1.6244e+04_r8,1.4213e+04_r8,1.2183e+04_r8,1.0152e+04_r8,8.1218e+03_r8,6.0913e+03_r8, &
     &4.0609e+03_r8,2.0304e+03_r8,7.4252e+00_r8/)
      kao(:, 4, 2,13) = (/ &
     &2.0224e+04_r8,1.7696e+04_r8,1.5168e+04_r8,1.2640e+04_r8,1.0112e+04_r8,7.5839e+03_r8, &
     &5.0559e+03_r8,2.5280e+03_r8,7.7282e+00_r8/)
      kao(:, 5, 2,13) = (/ &
     &2.4645e+04_r8,2.1565e+04_r8,1.8484e+04_r8,1.5403e+04_r8,1.2323e+04_r8,9.2420e+03_r8, &
     &6.1614e+03_r8,3.0807e+03_r8,7.1576e+00_r8/)
      kao(:, 1, 3,13) = (/ &
     &7.8601e+03_r8,6.8776e+03_r8,5.8951e+03_r8,4.9126e+03_r8,3.9300e+03_r8,2.9475e+03_r8, &
     &1.9650e+03_r8,9.8251e+02_r8,1.2409e+01_r8/)
      kao(:, 2, 3,13) = (/ &
     &1.0573e+04_r8,9.2512e+03_r8,7.9296e+03_r8,6.6080e+03_r8,5.2864e+03_r8,3.9648e+03_r8, &
     &2.6432e+03_r8,1.3216e+03_r8,1.2422e+01_r8/)
      kao(:, 3, 3,13) = (/ &
     &1.3794e+04_r8,1.2070e+04_r8,1.0346e+04_r8,8.6214e+03_r8,6.8971e+03_r8,5.1729e+03_r8, &
     &3.4486e+03_r8,1.7243e+03_r8,1.2413e+01_r8/)
      kao(:, 4, 3,13) = (/ &
     &1.7502e+04_r8,1.5315e+04_r8,1.3127e+04_r8,1.0939e+04_r8,8.7512e+03_r8,6.5634e+03_r8, &
     &4.3756e+03_r8,2.1878e+03_r8,1.2394e+01_r8/)
      kao(:, 5, 3,13) = (/ &
     &2.1662e+04_r8,1.8954e+04_r8,1.6247e+04_r8,1.3539e+04_r8,1.0831e+04_r8,8.1233e+03_r8, &
     &5.4155e+03_r8,2.7078e+03_r8,1.2358e+01_r8/)
      kao(:, 1, 4,13) = (/ &
     &6.0906e+03_r8,5.3293e+03_r8,4.5680e+03_r8,3.8067e+03_r8,3.0453e+03_r8,2.2840e+03_r8, &
     &1.5227e+03_r8,7.6133e+02_r8,1.4627e+01_r8/)
      kao(:, 2, 4,13) = (/ &
     &8.4475e+03_r8,7.3915e+03_r8,6.3356e+03_r8,5.2797e+03_r8,4.2237e+03_r8,3.1678e+03_r8, &
     &2.1119e+03_r8,1.0559e+03_r8,1.4656e+01_r8/)
      kao(:, 3, 4,13) = (/ &
     &1.1299e+04_r8,9.8868e+03_r8,8.4744e+03_r8,7.0620e+03_r8,5.6496e+03_r8,4.2372e+03_r8, &
     &2.8248e+03_r8,1.4124e+03_r8,1.4666e+01_r8/)
      kao(:, 4, 4,13) = (/ &
     &1.4605e+04_r8,1.2779e+04_r8,1.0954e+04_r8,9.1282e+03_r8,7.3025e+03_r8,5.4769e+03_r8, &
     &3.6513e+03_r8,1.8256e+03_r8,1.4645e+01_r8/)
      kao(:, 5, 4,13) = (/ &
     &1.8360e+04_r8,1.6065e+04_r8,1.3770e+04_r8,1.1475e+04_r8,9.1801e+03_r8,6.8851e+03_r8, &
     &4.5900e+03_r8,2.2950e+03_r8,1.4604e+01_r8/)
      kao(:, 1, 5,13) = (/ &
     &4.6024e+03_r8,4.0271e+03_r8,3.4518e+03_r8,2.8765e+03_r8,2.3012e+03_r8,1.7259e+03_r8, &
     &1.1506e+03_r8,5.7529e+02_r8,1.7191e+01_r8/)
      kao(:, 2, 5,13) = (/ &
     &6.5855e+03_r8,5.7623e+03_r8,4.9391e+03_r8,4.1159e+03_r8,3.2927e+03_r8,2.4695e+03_r8, &
     &1.6464e+03_r8,8.2318e+02_r8,1.7235e+01_r8/)
      kao(:, 3, 5,13) = (/ &
     &8.9962e+03_r8,7.8717e+03_r8,6.7471e+03_r8,5.6226e+03_r8,4.4981e+03_r8,3.3736e+03_r8, &
     &2.2490e+03_r8,1.1245e+03_r8,1.7249e+01_r8/)
      kao(:, 4, 5,13) = (/ &
     &1.1873e+04_r8,1.0388e+04_r8,8.9044e+03_r8,7.4203e+03_r8,5.9363e+03_r8,4.4522e+03_r8, &
     &2.9681e+03_r8,1.4841e+03_r8,1.7236e+01_r8/)
      kao(:, 5, 5,13) = (/ &
     &1.5203e+04_r8,1.3303e+04_r8,1.1402e+04_r8,9.5020e+03_r8,7.6016e+03_r8,5.7012e+03_r8, &
     &3.8008e+03_r8,1.9004e+03_r8,1.7202e+01_r8/)
      kao(:, 1, 6,13) = (/ &
     &3.3402e+03_r8,2.9227e+03_r8,2.5052e+03_r8,2.0876e+03_r8,1.6701e+03_r8,1.2526e+03_r8, &
     &8.3506e+02_r8,4.1753e+02_r8,2.0086e+01_r8/)
      kao(:, 2, 6,13) = (/ &
     &4.9170e+03_r8,4.3024e+03_r8,3.6877e+03_r8,3.0731e+03_r8,2.4585e+03_r8,1.8439e+03_r8, &
     &1.2292e+03_r8,6.1462e+02_r8,2.0160e+01_r8/)
      kao(:, 3, 6,13) = (/ &
     &6.9136e+03_r8,6.0494e+03_r8,5.1852e+03_r8,4.3210e+03_r8,3.4568e+03_r8,2.5926e+03_r8, &
     &1.7284e+03_r8,8.6420e+02_r8,2.0194e+01_r8/)
      kao(:, 4, 6,13) = (/ &
     &9.3499e+03_r8,8.1811e+03_r8,7.0124e+03_r8,5.8437e+03_r8,4.6749e+03_r8,3.5062e+03_r8, &
     &2.3375e+03_r8,1.1687e+03_r8,2.0186e+01_r8/)
      kao(:, 5, 6,13) = (/ &
     &1.2234e+04_r8,1.0705e+04_r8,9.1755e+03_r8,7.6462e+03_r8,6.1170e+03_r8,4.5877e+03_r8, &
     &3.0585e+03_r8,1.5292e+03_r8,2.0149e+01_r8/)
      kao(:, 1, 7,13) = (/ &
     &2.3634e+03_r8,2.0680e+03_r8,1.7726e+03_r8,1.4771e+03_r8,1.1817e+03_r8,8.8628e+02_r8, &
     &5.9086e+02_r8,2.9543e+02_r8,2.3318e+01_r8/)
      kao(:, 2, 7,13) = (/ &
     &3.6109e+03_r8,3.1596e+03_r8,2.7082e+03_r8,2.2568e+03_r8,1.8055e+03_r8,1.3541e+03_r8, &
     &9.0273e+02_r8,4.5136e+02_r8,2.3426e+01_r8/)
      kao(:, 3, 7,13) = (/ &
     &5.2430e+03_r8,4.5876e+03_r8,3.9322e+03_r8,3.2769e+03_r8,2.6215e+03_r8,1.9661e+03_r8, &
     &1.3107e+03_r8,6.5537e+02_r8,2.3476e+01_r8/)
      kao(:, 4, 7,13) = (/ &
     &7.2754e+03_r8,6.3660e+03_r8,5.4565e+03_r8,4.5471e+03_r8,3.6377e+03_r8,2.7283e+03_r8, &
     &1.8188e+03_r8,9.0942e+02_r8,2.3476e+01_r8/)
      kao(:, 5, 7,13) = (/ &
     &9.7107e+03_r8,8.4968e+03_r8,7.2830e+03_r8,6.0691e+03_r8,4.8553e+03_r8,3.6415e+03_r8, &
     &2.4276e+03_r8,1.2138e+03_r8,2.3445e+01_r8/)
      kao(:, 1, 8,13) = (/ &
     &1.6675e+03_r8,1.4591e+03_r8,1.2506e+03_r8,1.0422e+03_r8,8.3375e+02_r8,6.2531e+02_r8, &
     &4.1687e+02_r8,2.0844e+02_r8,2.6870e+01_r8/)
      kao(:, 2, 8,13) = (/ &
     &2.6544e+03_r8,2.3226e+03_r8,1.9908e+03_r8,1.6590e+03_r8,1.3272e+03_r8,9.9538e+02_r8, &
     &6.6359e+02_r8,3.3179e+02_r8,2.6998e+01_r8/)
      kao(:, 3, 8,13) = (/ &
     &3.9767e+03_r8,3.4797e+03_r8,2.9826e+03_r8,2.4855e+03_r8,1.9884e+03_r8,1.4913e+03_r8, &
     &9.9419e+02_r8,4.9709e+02_r8,2.7066e+01_r8/)
      kao(:, 4, 8,13) = (/ &
     &5.6620e+03_r8,4.9542e+03_r8,4.2465e+03_r8,3.5387e+03_r8,2.8310e+03_r8,2.1232e+03_r8, &
     &1.4155e+03_r8,7.0775e+02_r8,2.7083e+01_r8/)
      kao(:, 5, 8,13) = (/ &
     &7.7334e+03_r8,6.7667e+03_r8,5.8000e+03_r8,4.8334e+03_r8,3.8667e+03_r8,2.9000e+03_r8, &
     &1.9333e+03_r8,9.6667e+02_r8,2.7049e+01_r8/)
      kao(:, 1, 9,13) = (/ &
     &1.1358e+03_r8,9.9378e+02_r8,8.5181e+02_r8,7.0984e+02_r8,5.6787e+02_r8,4.2591e+02_r8, &
     &2.8394e+02_r8,1.4197e+02_r8,3.0678e+01_r8/)
      kao(:, 2, 9,13) = (/ &
     &1.8861e+03_r8,1.6503e+03_r8,1.4146e+03_r8,1.1788e+03_r8,9.4305e+02_r8,7.0729e+02_r8, &
     &4.7153e+02_r8,2.3576e+02_r8,3.0840e+01_r8/)
      kao(:, 3, 9,13) = (/ &
     &2.9209e+03_r8,2.5558e+03_r8,2.1907e+03_r8,1.8256e+03_r8,1.4605e+03_r8,1.0953e+03_r8, &
     &7.3023e+02_r8,3.6511e+02_r8,3.0929e+01_r8/)
      kao(:, 4, 9,13) = (/ &
     &4.2847e+03_r8,3.7491e+03_r8,3.2135e+03_r8,2.6779e+03_r8,2.1424e+03_r8,1.6068e+03_r8, &
     &1.0712e+03_r8,5.3559e+02_r8,3.0953e+01_r8/)
      kao(:, 5, 9,13) = (/ &
     &6.0053e+03_r8,5.2546e+03_r8,4.5040e+03_r8,3.7533e+03_r8,3.0026e+03_r8,2.2520e+03_r8, &
     &1.5013e+03_r8,7.5066e+02_r8,3.0913e+01_r8/)
      kao(:, 1,10,13) = (/ &
     &7.8733e+02_r8,6.8892e+02_r8,5.9050e+02_r8,4.9208e+02_r8,3.9366e+02_r8,2.9525e+02_r8, &
     &1.9683e+02_r8,9.8416e+01_r8,3.4699e+01_r8/)
      kao(:, 2,10,13) = (/ &
     &1.3543e+03_r8,1.1850e+03_r8,1.0157e+03_r8,8.4641e+02_r8,6.7713e+02_r8,5.0785e+02_r8, &
     &3.3856e+02_r8,1.6928e+02_r8,3.4872e+01_r8/)
      kao(:, 3,10,13) = (/ &
     &2.1695e+03_r8,1.8983e+03_r8,1.6271e+03_r8,1.3559e+03_r8,1.0848e+03_r8,8.1356e+02_r8, &
     &5.4238e+02_r8,2.7119e+02_r8,3.4962e+01_r8/)
      kao(:, 4,10,13) = (/ &
     &3.2703e+03_r8,2.8615e+03_r8,2.4527e+03_r8,2.0439e+03_r8,1.6351e+03_r8,1.2263e+03_r8, &
     &8.1756e+02_r8,4.0878e+02_r8,3.4974e+01_r8/)
      kao(:, 5,10,13) = (/ &
     &4.6791e+03_r8,4.0942e+03_r8,3.5093e+03_r8,2.9244e+03_r8,2.3395e+03_r8,1.7546e+03_r8, &
     &1.1698e+03_r8,5.8488e+02_r8,3.4915e+01_r8/)
      kao(:, 1,11,13) = (/ &
     &7.0254e+02_r8,6.1472e+02_r8,5.2690e+02_r8,4.3908e+02_r8,3.5127e+02_r8,2.6345e+02_r8, &
     &1.7563e+02_r8,8.8441e+01_r8,3.8867e+01_r8/)
      kao(:, 2,11,13) = (/ &
     &1.2148e+03_r8,1.0630e+03_r8,9.1111e+02_r8,7.5926e+02_r8,6.0740e+02_r8,4.5555e+02_r8, &
     &3.0370e+02_r8,1.5185e+02_r8,3.8999e+01_r8/)
      kao(:, 3,11,13) = (/ &
     &1.9474e+03_r8,1.7040e+03_r8,1.4606e+03_r8,1.2171e+03_r8,9.7371e+02_r8,7.3028e+02_r8, &
     &4.8685e+02_r8,2.4343e+02_r8,3.9046e+01_r8/)
      kao(:, 4,11,13) = (/ &
     &2.9354e+03_r8,2.5684e+03_r8,2.2015e+03_r8,1.8346e+03_r8,1.4677e+03_r8,1.1008e+03_r8, &
     &7.3384e+02_r8,3.6692e+02_r8,3.9009e+01_r8/)
      kao(:, 5,11,13) = (/ &
     &4.2118e+03_r8,3.6853e+03_r8,3.1589e+03_r8,2.6324e+03_r8,2.1059e+03_r8,1.5794e+03_r8, &
     &1.0529e+03_r8,5.2647e+02_r8,3.8898e+01_r8/)
      kao(:, 1,12,13) = (/ &
     &6.3490e+02_r8,5.5553e+02_r8,4.7617e+02_r8,3.9681e+02_r8,3.1745e+02_r8,2.3809e+02_r8, &
     &1.5872e+02_r8,8.3817e+01_r8,4.2920e+01_r8/)
      kao(:, 2,12,13) = (/ &
     &1.0964e+03_r8,9.5936e+02_r8,8.2231e+02_r8,6.8526e+02_r8,5.4821e+02_r8,4.1116e+02_r8, &
     &2.7410e+02_r8,1.3705e+02_r8,4.3006e+01_r8/)
      kao(:, 3,12,13) = (/ &
     &1.7602e+03_r8,1.5402e+03_r8,1.3202e+03_r8,1.1001e+03_r8,8.8010e+02_r8,6.6008e+02_r8, &
     &4.4005e+02_r8,2.2003e+02_r8,4.2996e+01_r8/)
      kao(:, 4,12,13) = (/ &
     &2.6586e+03_r8,2.3263e+03_r8,1.9940e+03_r8,1.6616e+03_r8,1.3293e+03_r8,9.9698e+02_r8, &
     &6.6465e+02_r8,3.3233e+02_r8,4.2901e+01_r8/)
      kao(:, 5,12,13) = (/ &
     &3.8091e+03_r8,3.3329e+03_r8,2.8568e+03_r8,2.3807e+03_r8,1.9045e+03_r8,1.4284e+03_r8, &
     &9.5227e+02_r8,4.7613e+02_r8,4.2723e+01_r8/)
      kao(:, 1,13,13) = (/ &
     &5.9158e+02_r8,5.1763e+02_r8,4.4368e+02_r8,3.6974e+02_r8,2.9579e+02_r8,2.2184e+02_r8, &
     &1.4790e+02_r8,8.4889e+01_r8,4.6678e+01_r8/)
      kao(:, 2,13,13) = (/ &
     &1.0244e+03_r8,8.9631e+02_r8,7.6827e+02_r8,6.4022e+02_r8,5.1218e+02_r8,3.8414e+02_r8, &
     &2.5609e+02_r8,1.2940e+02_r8,4.6683e+01_r8/)
      kao(:, 3,13,13) = (/ &
     &1.6452e+03_r8,1.4395e+03_r8,1.2339e+03_r8,1.0282e+03_r8,8.2259e+02_r8,6.1694e+02_r8, &
     &4.1130e+02_r8,2.0565e+02_r8,4.6592e+01_r8/)
      kao(:, 4,13,13) = (/ &
     &2.4841e+03_r8,2.1736e+03_r8,1.8631e+03_r8,1.5526e+03_r8,1.2421e+03_r8,9.3154e+02_r8, &
     &6.2103e+02_r8,3.1052e+02_r8,4.6412e+01_r8/)
      kao(:, 5,13,13) = (/ &
     &3.5669e+03_r8,3.1210e+03_r8,2.6752e+03_r8,2.2293e+03_r8,1.7834e+03_r8,1.3376e+03_r8, &
     &8.9172e+02_r8,4.4586e+02_r8,4.6169e+01_r8/)
      kao(:, 1, 1,14) = (/ &
     &2.0814e+04_r8,1.8212e+04_r8,1.5610e+04_r8,1.3008e+04_r8,1.0407e+04_r8,7.8051e+03_r8, &
     &5.2034e+03_r8,2.6017e+03_r8,4.7014e-03_r8/)
      kao(:, 2, 1,14) = (/ &
     &2.6951e+04_r8,2.3582e+04_r8,2.0213e+04_r8,1.6844e+04_r8,1.3475e+04_r8,1.0107e+04_r8, &
     &6.7377e+03_r8,3.3688e+03_r8,6.0711e-03_r8/)
      kao(:, 3, 1,14) = (/ &
     &3.3875e+04_r8,2.9641e+04_r8,2.5406e+04_r8,2.1172e+04_r8,1.6938e+04_r8,1.2703e+04_r8, &
     &8.4688e+03_r8,4.2344e+03_r8,2.5176e-02_r8/)
      kao(:, 4, 1,14) = (/ &
     &4.1606e+04_r8,3.6405e+04_r8,3.1205e+04_r8,2.6004e+04_r8,2.0803e+04_r8,1.5602e+04_r8, &
     &1.0402e+04_r8,5.2008e+03_r8,1.0468e-01_r8/)
      kao(:, 5, 1,14) = (/ &
     &5.0069e+04_r8,4.3810e+04_r8,3.7551e+04_r8,3.1293e+04_r8,2.5034e+04_r8,1.8776e+04_r8, &
     &1.2517e+04_r8,6.2586e+03_r8,1.0717e-01_r8/)
      kao(:, 1, 2,14) = (/ &
     &1.9736e+04_r8,1.7269e+04_r8,1.4802e+04_r8,1.2335e+04_r8,9.8681e+03_r8,7.4011e+03_r8, &
     &4.9341e+03_r8,2.4670e+03_r8,1.4424e-01_r8/)
      kao(:, 2, 2,14) = (/ &
     &2.5938e+04_r8,2.2696e+04_r8,1.9454e+04_r8,1.6211e+04_r8,1.2969e+04_r8,9.7268e+03_r8, &
     &6.4845e+03_r8,3.2423e+03_r8,5.4893e+00_r8/)
      kao(:, 3, 2,14) = (/ &
     &3.3117e+04_r8,2.8978e+04_r8,2.4838e+04_r8,2.0698e+04_r8,1.6559e+04_r8,1.2419e+04_r8, &
     &8.2793e+03_r8,4.1397e+03_r8,6.5583e+00_r8/)
      kao(:, 4, 2,14) = (/ &
     &4.1192e+04_r8,3.6043e+04_r8,3.0894e+04_r8,2.5745e+04_r8,2.0596e+04_r8,1.5447e+04_r8, &
     &1.0298e+04_r8,5.1490e+03_r8,7.2955e+00_r8/)
      kao(:, 5, 2,14) = (/ &
     &5.0084e+04_r8,4.3824e+04_r8,3.7563e+04_r8,3.1303e+04_r8,2.5042e+04_r8,1.8782e+04_r8, &
     &1.2521e+04_r8,6.2605e+03_r8,4.5976e+00_r8/)
      kao(:, 1, 3,14) = (/ &
     &1.7352e+04_r8,1.5183e+04_r8,1.3014e+04_r8,1.0845e+04_r8,8.6759e+03_r8,6.5069e+03_r8, &
     &4.3379e+03_r8,2.1690e+03_r8,1.3353e+01_r8/)
      kao(:, 2, 3,14) = (/ &
     &2.3378e+04_r8,2.0456e+04_r8,1.7533e+04_r8,1.4611e+04_r8,1.1689e+04_r8,8.7667e+03_r8, &
     &5.8445e+03_r8,2.9222e+03_r8,1.3389e+01_r8/)
      kao(:, 3, 3,14) = (/ &
     &3.0448e+04_r8,2.6642e+04_r8,2.2836e+04_r8,1.9030e+04_r8,1.5224e+04_r8,1.1418e+04_r8, &
     &7.6119e+03_r8,3.8060e+03_r8,1.3397e+01_r8/)
      kao(:, 4, 3,14) = (/ &
     &3.8507e+04_r8,3.3693e+04_r8,2.8880e+04_r8,2.4067e+04_r8,1.9253e+04_r8,1.4440e+04_r8, &
     &9.6266e+03_r8,4.8133e+03_r8,1.3385e+01_r8/)
      kao(:, 5, 3,14) = (/ &
     &4.7469e+04_r8,4.1535e+04_r8,3.5602e+04_r8,2.9668e+04_r8,2.3734e+04_r8,1.7801e+04_r8, &
     &1.1867e+04_r8,5.9336e+03_r8,1.3346e+01_r8/)
      kao(:, 1, 4,14) = (/ &
     &1.4631e+04_r8,1.2802e+04_r8,1.0973e+04_r8,9.1445e+03_r8,7.3156e+03_r8,5.4867e+03_r8, &
     &3.6578e+03_r8,1.8289e+03_r8,1.5943e+01_r8/)
      kao(:, 2, 4,14) = (/ &
     &2.0262e+04_r8,1.7729e+04_r8,1.5197e+04_r8,1.2664e+04_r8,1.0131e+04_r8,7.5983e+03_r8, &
     &5.0655e+03_r8,2.5328e+03_r8,1.6007e+01_r8/)
      kao(:, 3, 4,14) = (/ &
     &2.6988e+04_r8,2.3615e+04_r8,2.0241e+04_r8,1.6868e+04_r8,1.3494e+04_r8,1.0121e+04_r8, &
     &6.7470e+03_r8,3.3735e+03_r8,1.6031e+01_r8/)
      kao(:, 4, 4,14) = (/ &
     &3.4853e+04_r8,3.0497e+04_r8,2.6140e+04_r8,2.1783e+04_r8,1.7427e+04_r8,1.3070e+04_r8, &
     &8.7133e+03_r8,4.3567e+03_r8,1.6028e+01_r8/)
      kao(:, 5, 4,14) = (/ &
     &4.3821e+04_r8,3.8343e+04_r8,3.2866e+04_r8,2.7388e+04_r8,2.1910e+04_r8,1.6433e+04_r8, &
     &1.0955e+04_r8,5.4776e+03_r8,1.6009e+01_r8/)
      kao(:, 1, 5,14) = (/ &
     &1.2010e+04_r8,1.0509e+04_r8,9.0077e+03_r8,7.5064e+03_r8,6.0051e+03_r8,4.5038e+03_r8, &
     &3.0026e+03_r8,1.5013e+03_r8,1.9009e+01_r8/)
      kao(:, 2, 5,14) = (/ &
     &1.7127e+04_r8,1.4986e+04_r8,1.2846e+04_r8,1.0705e+04_r8,8.5637e+03_r8,6.4228e+03_r8, &
     &4.2818e+03_r8,2.1409e+03_r8,1.9111e+01_r8/)
      kao(:, 3, 5,14) = (/ &
     &2.3449e+04_r8,2.0517e+04_r8,1.7586e+04_r8,1.4655e+04_r8,1.1724e+04_r8,8.7932e+03_r8, &
     &5.8621e+03_r8,2.9311e+03_r8,1.9171e+01_r8/)
      kao(:, 4, 5,14) = (/ &
     &3.0924e+04_r8,2.7059e+04_r8,2.3193e+04_r8,1.9328e+04_r8,1.5462e+04_r8,1.1597e+04_r8, &
     &7.7310e+03_r8,3.8655e+03_r8,1.9184e+01_r8/)
      kao(:, 5, 5,14) = (/ &
     &3.9495e+04_r8,3.4558e+04_r8,2.9621e+04_r8,2.4684e+04_r8,1.9748e+04_r8,1.4811e+04_r8, &
     &9.8738e+03_r8,4.9369e+03_r8,1.9172e+01_r8/)
      kao(:, 1, 6,14) = (/ &
     &9.4628e+03_r8,8.2800e+03_r8,7.0971e+03_r8,5.9142e+03_r8,4.7314e+03_r8,3.5485e+03_r8, &
     &2.3657e+03_r8,1.1828e+03_r8,2.2644e+01_r8/)
      kao(:, 2, 6,14) = (/ &
     &1.3981e+04_r8,1.2233e+04_r8,1.0486e+04_r8,8.7381e+03_r8,6.9905e+03_r8,5.2429e+03_r8, &
     &3.4952e+03_r8,1.7476e+03_r8,2.2781e+01_r8/)
      kao(:, 3, 6,14) = (/ &
     &1.9648e+04_r8,1.7192e+04_r8,1.4736e+04_r8,1.2280e+04_r8,9.8239e+03_r8,7.3679e+03_r8, &
     &4.9119e+03_r8,2.4560e+03_r8,2.2869e+01_r8/)
      kao(:, 4, 6,14) = (/ &
     &2.6483e+04_r8,2.3173e+04_r8,1.9862e+04_r8,1.6552e+04_r8,1.3242e+04_r8,9.9312e+03_r8, &
     &6.6208e+03_r8,3.3104e+03_r8,2.2915e+01_r8/)
      kao(:, 5, 6,14) = (/ &
     &3.4470e+04_r8,3.0161e+04_r8,2.5853e+04_r8,2.1544e+04_r8,1.7235e+04_r8,1.2926e+04_r8, &
     &8.6175e+03_r8,4.3088e+03_r8,2.2923e+01_r8/)
      kao(:, 1, 7,14) = (/ &
     &7.3078e+03_r8,6.3943e+03_r8,5.4808e+03_r8,4.5673e+03_r8,3.6539e+03_r8,2.7404e+03_r8, &
     &1.8269e+03_r8,9.1346e+02_r8,2.6896e+01_r8/)
      kao(:, 2, 7,14) = (/ &
     &1.1178e+04_r8,9.7811e+03_r8,8.3838e+03_r8,6.9865e+03_r8,5.5892e+03_r8,4.1919e+03_r8, &
     &2.7946e+03_r8,1.3973e+03_r8,2.7090e+01_r8/)
      kao(:, 3, 7,14) = (/ &
     &1.6168e+04_r8,1.4147e+04_r8,1.2126e+04_r8,1.0105e+04_r8,8.0839e+03_r8,6.0629e+03_r8, &
     &4.0420e+03_r8,2.0210e+03_r8,2.7221e+01_r8/)
      kao(:, 4, 7,14) = (/ &
     &2.2360e+04_r8,1.9565e+04_r8,1.6770e+04_r8,1.3975e+04_r8,1.1180e+04_r8,8.3848e+03_r8, &
     &5.5899e+03_r8,2.7949e+03_r8,2.7298e+01_r8/)
      kao(:, 5, 7,14) = (/ &
     &2.9827e+04_r8,2.6099e+04_r8,2.2370e+04_r8,1.8642e+04_r8,1.4913e+04_r8,1.1185e+04_r8, &
     &7.4567e+03_r8,3.7283e+03_r8,2.7315e+01_r8/)
      kao(:, 1, 8,14) = (/ &
     &5.5945e+03_r8,4.8952e+03_r8,4.1959e+03_r8,3.4966e+03_r8,2.7972e+03_r8,2.0979e+03_r8, &
     &1.3986e+03_r8,6.9931e+02_r8,3.1842e+01_r8/)
      kao(:, 2, 8,14) = (/ &
     &8.8907e+03_r8,7.7794e+03_r8,6.6680e+03_r8,5.5567e+03_r8,4.4454e+03_r8,3.3340e+03_r8, &
     &2.2227e+03_r8,1.1113e+03_r8,3.2101e+01_r8/)
      kao(:, 3, 8,14) = (/ &
     &1.3296e+04_r8,1.1634e+04_r8,9.9724e+03_r8,8.3103e+03_r8,6.6483e+03_r8,4.9862e+03_r8, &
     &3.3241e+03_r8,1.6621e+03_r8,3.2282e+01_r8/)
      kao(:, 4, 8,14) = (/ &
     &1.8955e+04_r8,1.6586e+04_r8,1.4216e+04_r8,1.1847e+04_r8,9.4776e+03_r8,7.1082e+03_r8, &
     &4.7388e+03_r8,2.3694e+03_r8,3.2388e+01_r8/)
      kao(:, 5, 8,14) = (/ &
     &2.5906e+04_r8,2.2668e+04_r8,1.9430e+04_r8,1.6191e+04_r8,1.2953e+04_r8,9.7149e+03_r8, &
     &6.4766e+03_r8,3.2383e+03_r8,3.2425e+01_r8/)
      kao(:, 1, 9,14) = (/ &
     &4.1067e+03_r8,3.5934e+03_r8,3.0800e+03_r8,2.5667e+03_r8,2.0533e+03_r8,1.5400e+03_r8, &
     &1.0267e+03_r8,5.1334e+02_r8,3.7521e+01_r8/)
      kao(:, 2, 9,14) = (/ &
     &6.8230e+03_r8,5.9701e+03_r8,5.1172e+03_r8,4.2644e+03_r8,3.4115e+03_r8,2.5586e+03_r8, &
     &1.7057e+03_r8,8.5287e+02_r8,3.7865e+01_r8/)
      kao(:, 3, 9,14) = (/ &
     &1.0614e+04_r8,9.2875e+03_r8,7.9607e+03_r8,6.6339e+03_r8,5.3071e+03_r8,3.9804e+03_r8, &
     &2.6536e+03_r8,1.3268e+03_r8,3.8104e+01_r8/)
      kao(:, 4, 9,14) = (/ &
     &1.5585e+04_r8,1.3637e+04_r8,1.1689e+04_r8,9.7408e+03_r8,7.7926e+03_r8,5.8445e+03_r8, &
     &3.8963e+03_r8,1.9481e+03_r8,3.8251e+01_r8/)
      kao(:, 5, 9,14) = (/ &
     &2.1772e+04_r8,1.9051e+04_r8,1.6329e+04_r8,1.3608e+04_r8,1.0886e+04_r8,8.1646e+03_r8, &
     &5.4430e+03_r8,2.7215e+03_r8,3.8308e+01_r8/)
      kao(:, 1,10,14) = (/ &
     &3.0498e+03_r8,2.6686e+03_r8,2.2874e+03_r8,1.9061e+03_r8,1.5249e+03_r8,1.1437e+03_r8, &
     &7.6245e+02_r8,3.8122e+02_r8,4.4006e+01_r8/)
      kao(:, 2,10,14) = (/ &
     &5.3046e+03_r8,4.6415e+03_r8,3.9785e+03_r8,3.3154e+03_r8,2.6523e+03_r8,1.9892e+03_r8, &
     &1.3261e+03_r8,6.6307e+02_r8,4.4440e+01_r8/)
      kao(:, 3,10,14) = (/ &
     &8.5201e+03_r8,7.4551e+03_r8,6.3901e+03_r8,5.3250e+03_r8,4.2600e+03_r8,3.1950e+03_r8, &
     &2.1300e+03_r8,1.0650e+03_r8,4.4746e+01_r8/)
      kao(:, 4,10,14) = (/ &
     &1.2818e+04_r8,1.1216e+04_r8,9.6138e+03_r8,8.0115e+03_r8,6.4092e+03_r8,4.8069e+03_r8, &
     &3.2046e+03_r8,1.6023e+03_r8,4.4928e+01_r8/)
      kao(:, 5,10,14) = (/ &
     &1.8340e+04_r8,1.6048e+04_r8,1.3755e+04_r8,1.1463e+04_r8,9.1701e+03_r8,6.8776e+03_r8, &
     &4.5851e+03_r8,2.2925e+03_r8,4.5005e+01_r8/)
      kao(:, 1,11,14) = (/ &
     &2.9434e+03_r8,2.5755e+03_r8,2.2076e+03_r8,1.8396e+03_r8,1.4717e+03_r8,1.1038e+03_r8, &
     &7.3585e+02_r8,3.6793e+02_r8,5.1570e+01_r8/)
      kao(:, 2,11,14) = (/ &
     &5.1056e+03_r8,4.4674e+03_r8,3.8292e+03_r8,3.1910e+03_r8,2.5528e+03_r8,1.9146e+03_r8, &
     &1.2764e+03_r8,6.3819e+02_r8,5.2012e+01_r8/)
      kao(:, 3,11,14) = (/ &
     &8.1976e+03_r8,7.1728e+03_r8,6.1481e+03_r8,5.1234e+03_r8,4.0987e+03_r8,3.0741e+03_r8, &
     &2.0494e+03_r8,1.0247e+03_r8,5.2312e+01_r8/)
      kao(:, 4,11,14) = (/ &
     &1.2377e+04_r8,1.0830e+04_r8,9.2826e+03_r8,7.7355e+03_r8,6.1884e+03_r8,4.6413e+03_r8, &
     &3.0942e+03_r8,1.5471e+03_r8,5.2478e+01_r8/)
      kao(:, 5,11,14) = (/ &
     &1.7764e+04_r8,1.5544e+04_r8,1.3323e+04_r8,1.1103e+04_r8,8.8820e+03_r8,6.6616e+03_r8, &
     &4.4410e+03_r8,2.2205e+03_r8,5.2507e+01_r8/)
      kao(:, 1,12,14) = (/ &
     &2.8315e+03_r8,2.4776e+03_r8,2.1237e+03_r8,1.7697e+03_r8,1.4158e+03_r8,1.0618e+03_r8, &
     &7.0789e+02_r8,3.5394e+02_r8,5.9960e+01_r8/)
      kao(:, 2,12,14) = (/ &
     &4.9224e+03_r8,4.3071e+03_r8,3.6918e+03_r8,3.0765e+03_r8,2.4612e+03_r8,1.8459e+03_r8, &
     &1.2306e+03_r8,6.1530e+02_r8,6.0405e+01_r8/)
      kao(:, 3,12,14) = (/ &
     &7.9376e+03_r8,6.9454e+03_r8,5.9532e+03_r8,4.9610e+03_r8,3.9688e+03_r8,2.9766e+03_r8, &
     &1.9844e+03_r8,9.9220e+02_r8,6.0667e+01_r8/)
      kao(:, 4,12,14) = (/ &
     &1.2004e+04_r8,1.0504e+04_r8,9.0032e+03_r8,7.5027e+03_r8,6.0021e+03_r8,4.5016e+03_r8, &
     &3.0011e+03_r8,1.5005e+03_r8,6.0769e+01_r8/)
      kao(:, 5,12,14) = (/ &
     &1.7211e+04_r8,1.5059e+04_r8,1.2908e+04_r8,1.0757e+04_r8,8.6054e+03_r8,6.4541e+03_r8, &
     &4.3027e+03_r8,2.1514e+03_r8,6.0741e+01_r8/)
      kao(:, 1,13,14) = (/ &
     &2.8060e+03_r8,2.4552e+03_r8,2.1045e+03_r8,1.7537e+03_r8,1.4030e+03_r8,1.0522e+03_r8, &
     &7.0149e+02_r8,3.5075e+02_r8,6.9076e+01_r8/)
      kao(:, 2,13,14) = (/ &
     &4.9007e+03_r8,4.2881e+03_r8,3.6756e+03_r8,3.0630e+03_r8,2.4504e+03_r8,1.8378e+03_r8, &
     &1.2252e+03_r8,6.1260e+02_r8,6.9478e+01_r8/)
      kao(:, 3,13,14) = (/ &
     &7.8921e+03_r8,6.9056e+03_r8,5.9191e+03_r8,4.9326e+03_r8,3.9460e+03_r8,2.9595e+03_r8, &
     &1.9730e+03_r8,9.8652e+02_r8,6.9694e+01_r8/)
      kao(:, 4,13,14) = (/ &
     &1.1933e+04_r8,1.0441e+04_r8,8.9495e+03_r8,7.4579e+03_r8,5.9663e+03_r8,4.4748e+03_r8, &
     &2.9832e+03_r8,1.4916e+03_r8,6.9728e+01_r8/)
      kao(:, 5,13,14) = (/ &
     &1.7152e+04_r8,1.5008e+04_r8,1.2864e+04_r8,1.0720e+04_r8,8.5759e+03_r8,6.4320e+03_r8, &
     &4.2880e+03_r8,2.1440e+03_r8,6.9601e+01_r8/)
      kao(:, 1, 1,15) = (/ &
     &3.5423e+04_r8,3.0995e+04_r8,2.6567e+04_r8,2.2139e+04_r8,1.7712e+04_r8,1.3284e+04_r8, &
     &8.8558e+03_r8,4.4279e+03_r8,7.1610e-03_r8/)
      kao(:, 2, 1,15) = (/ &
     &4.5820e+04_r8,4.0093e+04_r8,3.4365e+04_r8,2.8638e+04_r8,2.2910e+04_r8,1.7183e+04_r8, &
     &1.1455e+04_r8,5.7276e+03_r8,7.1091e-03_r8/)
      kao(:, 3, 1,15) = (/ &
     &5.7623e+04_r8,5.0421e+04_r8,4.3218e+04_r8,3.6015e+04_r8,2.8812e+04_r8,2.1609e+04_r8, &
     &1.4406e+04_r8,7.2029e+03_r8,7.8150e-03_r8/)
      kao(:, 4, 1,15) = (/ &
     &7.0726e+04_r8,6.1885e+04_r8,5.3044e+04_r8,4.4204e+04_r8,3.5363e+04_r8,2.6522e+04_r8, &
     &1.7681e+04_r8,8.8407e+03_r8,4.0966e-02_r8/)
      kao(:, 5, 1,15) = (/ &
     &8.4947e+04_r8,7.4329e+04_r8,6.3711e+04_r8,5.3092e+04_r8,4.2474e+04_r8,3.1855e+04_r8, &
     &2.1237e+04_r8,1.0618e+04_r8,1.7079e-01_r8/)
      kao(:, 1, 2,15) = (/ &
     &3.6296e+04_r8,3.1759e+04_r8,2.7222e+04_r8,2.2685e+04_r8,1.8148e+04_r8,1.3611e+04_r8, &
     &9.0740e+03_r8,4.5370e+03_r8,7.6264e-03_r8/)
      kao(:, 2, 2,15) = (/ &
     &4.7676e+04_r8,4.1717e+04_r8,3.5757e+04_r8,2.9798e+04_r8,2.3838e+04_r8,1.7879e+04_r8, &
     &1.1919e+04_r8,5.9595e+03_r8,7.8530e+00_r8/)
      kao(:, 3, 2,15) = (/ &
     &6.0722e+04_r8,5.3132e+04_r8,4.5542e+04_r8,3.7951e+04_r8,3.0361e+04_r8,2.2771e+04_r8, &
     &1.5181e+04_r8,7.5903e+03_r8,1.1682e+01_r8/)
      kao(:, 4, 2,15) = (/ &
     &7.5305e+04_r8,6.5892e+04_r8,5.6479e+04_r8,4.7065e+04_r8,3.7652e+04_r8,2.8239e+04_r8, &
     &1.8826e+04_r8,9.4131e+03_r8,7.5532e+00_r8/)
      kao(:, 5, 2,15) = (/ &
     &9.1241e+04_r8,7.9835e+04_r8,6.8430e+04_r8,5.7025e+04_r8,4.5620e+04_r8,3.4215e+04_r8, &
     &2.2810e+04_r8,1.1405e+04_r8,1.0957e+00_r8/)
      kao(:, 1, 3,15) = (/ &
     &3.4715e+04_r8,3.0376e+04_r8,2.6036e+04_r8,2.1697e+04_r8,1.7358e+04_r8,1.3018e+04_r8, &
     &8.6788e+03_r8,4.3394e+03_r8,1.4232e+01_r8/)
      kao(:, 2, 3,15) = (/ &
     &4.6613e+04_r8,4.0787e+04_r8,3.4960e+04_r8,2.9133e+04_r8,2.3307e+04_r8,1.7480e+04_r8, &
     &1.1653e+04_r8,5.8267e+03_r8,1.4235e+01_r8/)
      kao(:, 3, 3,15) = (/ &
     &6.0451e+04_r8,5.2894e+04_r8,4.5338e+04_r8,3.7782e+04_r8,3.0225e+04_r8,2.2669e+04_r8, &
     &1.5113e+04_r8,7.5563e+03_r8,1.4209e+01_r8/)
      kao(:, 4, 3,15) = (/ &
     &7.6104e+04_r8,6.6591e+04_r8,5.7078e+04_r8,4.7565e+04_r8,3.8052e+04_r8,2.8539e+04_r8, &
     &1.9026e+04_r8,9.5130e+03_r8,1.4121e+01_r8/)
      kao(:, 5, 3,15) = (/ &
     &9.3385e+04_r8,8.1712e+04_r8,7.0039e+04_r8,5.8365e+04_r8,4.6692e+04_r8,3.5019e+04_r8, &
     &2.3346e+04_r8,1.1673e+04_r8,1.4063e+01_r8/)
      kao(:, 1, 4,15) = (/ &
     &3.1974e+04_r8,2.7977e+04_r8,2.3981e+04_r8,1.9984e+04_r8,1.5987e+04_r8,1.1990e+04_r8, &
     &7.9936e+03_r8,3.9968e+03_r8,1.7130e+01_r8/)
      kao(:, 2, 4,15) = (/ &
     &4.4033e+04_r8,3.8529e+04_r8,3.3025e+04_r8,2.7521e+04_r8,2.2017e+04_r8,1.6512e+04_r8, &
     &1.1008e+04_r8,5.5042e+03_r8,1.7154e+01_r8/)
      kao(:, 3, 4,15) = (/ &
     &5.8299e+04_r8,5.1012e+04_r8,4.3725e+04_r8,3.6437e+04_r8,2.9150e+04_r8,2.1862e+04_r8, &
     &1.4575e+04_r8,7.2874e+03_r8,1.7147e+01_r8/)
      kao(:, 4, 4,15) = (/ &
     &7.4658e+04_r8,6.5325e+04_r8,5.5993e+04_r8,4.6661e+04_r8,3.7329e+04_r8,2.7997e+04_r8, &
     &1.8664e+04_r8,9.3322e+03_r8,1.7125e+01_r8/)
      kao(:, 5, 4,15) = (/ &
     &9.3061e+04_r8,8.1428e+04_r8,6.9796e+04_r8,5.8163e+04_r8,4.6530e+04_r8,3.4898e+04_r8, &
     &2.3265e+04_r8,1.1633e+04_r8,1.7053e+01_r8/)
      kao(:, 1, 5,15) = (/ &
     &2.8780e+04_r8,2.5183e+04_r8,2.1585e+04_r8,1.7988e+04_r8,1.4390e+04_r8,1.0793e+04_r8, &
     &7.1950e+03_r8,3.5975e+03_r8,2.0610e+01_r8/)
      kao(:, 2, 5,15) = (/ &
     &4.0696e+04_r8,3.5609e+04_r8,3.0522e+04_r8,2.5435e+04_r8,2.0348e+04_r8,1.5261e+04_r8, &
     &1.0174e+04_r8,5.0871e+03_r8,2.0673e+01_r8/)
      kao(:, 3, 5,15) = (/ &
     &5.5132e+04_r8,4.8240e+04_r8,4.1349e+04_r8,3.4457e+04_r8,2.7566e+04_r8,2.0674e+04_r8, &
     &1.3783e+04_r8,6.8915e+03_r8,2.0688e+01_r8/)
      kao(:, 4, 5,15) = (/ &
     &7.2202e+04_r8,6.3177e+04_r8,5.4152e+04_r8,4.5126e+04_r8,3.6101e+04_r8,2.7076e+04_r8, &
     &1.8051e+04_r8,9.0253e+03_r8,2.0678e+01_r8/)
      kao(:, 5, 5,15) = (/ &
     &9.1794e+04_r8,8.0320e+04_r8,6.8846e+04_r8,5.7371e+04_r8,4.5897e+04_r8,3.4423e+04_r8, &
     &2.2949e+04_r8,1.1474e+04_r8,2.0627e+01_r8/)
      kao(:, 1, 6,15) = (/ &
     &2.4928e+04_r8,2.1812e+04_r8,1.8696e+04_r8,1.5580e+04_r8,1.2464e+04_r8,9.3479e+03_r8, &
     &6.2319e+03_r8,3.1160e+03_r8,2.4743e+01_r8/)
      kao(:, 2, 6,15) = (/ &
     &3.6459e+04_r8,3.1902e+04_r8,2.7344e+04_r8,2.2787e+04_r8,1.8230e+04_r8,1.3672e+04_r8, &
     &9.1148e+03_r8,4.5574e+03_r8,2.4868e+01_r8/)
      kao(:, 3, 6,15) = (/ &
     &5.0921e+04_r8,4.4556e+04_r8,3.8191e+04_r8,3.1826e+04_r8,2.5461e+04_r8,1.9095e+04_r8, &
     &1.2730e+04_r8,6.3651e+03_r8,2.4935e+01_r8/)
      kao(:, 4, 6,15) = (/ &
     &6.8337e+04_r8,5.9795e+04_r8,5.1253e+04_r8,4.2711e+04_r8,3.4168e+04_r8,2.5626e+04_r8, &
     &1.7084e+04_r8,8.5421e+03_r8,2.4952e+01_r8/)
      kao(:, 5, 6,15) = (/ &
     &8.8665e+04_r8,7.7582e+04_r8,6.6499e+04_r8,5.5416e+04_r8,4.4333e+04_r8,3.3249e+04_r8, &
     &2.2166e+04_r8,1.1083e+04_r8,2.4917e+01_r8/)
      kao(:, 1, 7,15) = (/ &
     &2.1322e+04_r8,1.8657e+04_r8,1.5992e+04_r8,1.3326e+04_r8,1.0661e+04_r8,7.9957e+03_r8, &
     &5.3305e+03_r8,2.6652e+03_r8,2.9665e+01_r8/)
      kao(:, 2, 7,15) = (/ &
     &3.2413e+04_r8,2.8361e+04_r8,2.4310e+04_r8,2.0258e+04_r8,1.6206e+04_r8,1.2155e+04_r8, &
     &8.1031e+03_r8,4.0516e+03_r8,2.9861e+01_r8/)
      kao(:, 3, 7,15) = (/ &
     &4.6696e+04_r8,4.0859e+04_r8,3.5022e+04_r8,2.9185e+04_r8,2.3348e+04_r8,1.7511e+04_r8, &
     &1.1674e+04_r8,5.8369e+03_r8,3.0001e+01_r8/)
      kao(:, 4, 7,15) = (/ &
     &6.4261e+04_r8,5.6228e+04_r8,4.8195e+04_r8,4.0163e+04_r8,3.2130e+04_r8,2.4098e+04_r8, &
     &1.6065e+04_r8,8.0325e+03_r8,3.0074e+01_r8/)
      kao(:, 5, 7,15) = (/ &
     &8.5103e+04_r8,7.4465e+04_r8,6.3827e+04_r8,5.3189e+04_r8,4.2551e+04_r8,3.1914e+04_r8, &
     &2.1276e+04_r8,1.0638e+04_r8,3.0077e+01_r8/)
      kao(:, 1, 8,15) = (/ &
     &1.8276e+04_r8,1.5991e+04_r8,1.3707e+04_r8,1.1422e+04_r8,9.1380e+03_r8,6.8535e+03_r8, &
     &4.5690e+03_r8,2.2845e+03_r8,3.5525e+01_r8/)
      kao(:, 2, 8,15) = (/ &
     &2.8919e+04_r8,2.5304e+04_r8,2.1689e+04_r8,1.8074e+04_r8,1.4459e+04_r8,1.0845e+04_r8, &
     &7.2298e+03_r8,3.6149e+03_r8,3.5844e+01_r8/)
      kao(:, 3, 8,15) = (/ &
     &4.2999e+04_r8,3.7624e+04_r8,3.2249e+04_r8,2.6874e+04_r8,2.1500e+04_r8,1.6125e+04_r8, &
     &1.0750e+04_r8,5.3749e+03_r8,3.6058e+01_r8/)
      kao(:, 4, 8,15) = (/ &
     &6.0712e+04_r8,5.3123e+04_r8,4.5534e+04_r8,3.7945e+04_r8,3.0356e+04_r8,2.2767e+04_r8, &
     &1.5178e+04_r8,7.5890e+03_r8,3.6184e+01_r8/)
      kao(:, 5, 8,15) = (/ &
     &8.2146e+04_r8,7.1878e+04_r8,6.1610e+04_r8,5.1341e+04_r8,4.1073e+04_r8,3.0805e+04_r8, &
     &2.0537e+04_r8,1.0268e+04_r8,3.6243e+01_r8/)
      kao(:, 1, 9,15) = (/ &
     &1.5122e+04_r8,1.3232e+04_r8,1.1341e+04_r8,9.4512e+03_r8,7.5610e+03_r8,5.6707e+03_r8, &
     &3.7805e+03_r8,1.8902e+03_r8,4.2513e+01_r8/)
      kao(:, 2, 9,15) = (/ &
     &2.4972e+04_r8,2.1851e+04_r8,1.8729e+04_r8,1.5608e+04_r8,1.2486e+04_r8,9.3646e+03_r8, &
     &6.2431e+03_r8,3.1215e+03_r8,4.2950e+01_r8/)
      kao(:, 3, 9,15) = (/ &
     &3.8412e+04_r8,3.3611e+04_r8,2.8809e+04_r8,2.4007e+04_r8,1.9206e+04_r8,1.4404e+04_r8, &
     &9.6030e+03_r8,4.8015e+03_r8,4.3278e+01_r8/)
      kao(:, 4, 9,15) = (/ &
     &5.5843e+04_r8,4.8863e+04_r8,4.1882e+04_r8,3.4902e+04_r8,2.7921e+04_r8,2.0941e+04_r8, &
     &1.3961e+04_r8,6.9804e+03_r8,4.3480e+01_r8/)
      kao(:, 5, 9,15) = (/ &
     &7.7611e+04_r8,6.7910e+04_r8,5.8208e+04_r8,4.8507e+04_r8,3.8805e+04_r8,2.9104e+04_r8, &
     &1.9403e+04_r8,9.7013e+03_r8,4.3587e+01_r8/)
      kao(:, 1,10,15) = (/ &
     &1.2684e+04_r8,1.1099e+04_r8,9.5132e+03_r8,7.9276e+03_r8,6.3421e+03_r8,4.7566e+03_r8, &
     &3.1710e+03_r8,1.5855e+03_r8,5.0840e+01_r8/)
      kao(:, 2,10,15) = (/ &
     &2.1787e+04_r8,1.9064e+04_r8,1.6340e+04_r8,1.3617e+04_r8,1.0893e+04_r8,8.1700e+03_r8, &
     &5.4467e+03_r8,2.7233e+03_r8,5.1430e+01_r8/)
      kao(:, 3,10,15) = (/ &
     &3.4684e+04_r8,3.0349e+04_r8,2.6013e+04_r8,2.1678e+04_r8,1.7342e+04_r8,1.3007e+04_r8, &
     &8.6710e+03_r8,4.3355e+03_r8,5.1863e+01_r8/)
      kao(:, 4,10,15) = (/ &
     &5.1947e+04_r8,4.5454e+04_r8,3.8960e+04_r8,3.2467e+04_r8,2.5974e+04_r8,1.9480e+04_r8, &
     &1.2987e+04_r8,6.4934e+03_r8,5.2160e+01_r8/)
      kao(:, 5,10,15) = (/ &
     &7.3912e+04_r8,6.4673e+04_r8,5.5434e+04_r8,4.6195e+04_r8,3.6956e+04_r8,2.7717e+04_r8, &
     &1.8478e+04_r8,9.2389e+03_r8,5.2321e+01_r8/)
      kao(:, 1,11,15) = (/ &
     &1.3711e+04_r8,1.1997e+04_r8,1.0283e+04_r8,8.5694e+03_r8,6.8555e+03_r8,5.1416e+03_r8, &
     &3.4277e+03_r8,1.7139e+03_r8,6.1054e+01_r8/)
      kao(:, 2,11,15) = (/ &
     &2.3669e+04_r8,2.0711e+04_r8,1.7752e+04_r8,1.4793e+04_r8,1.1835e+04_r8,8.8760e+03_r8, &
     &5.9173e+03_r8,2.9586e+03_r8,6.1742e+01_r8/)
      kao(:, 3,11,15) = (/ &
     &3.7832e+04_r8,3.3103e+04_r8,2.8374e+04_r8,2.3645e+04_r8,1.8916e+04_r8,1.4187e+04_r8, &
     &9.4579e+03_r8,4.7289e+03_r8,6.2215e+01_r8/)
      kao(:, 4,11,15) = (/ &
     &5.6757e+04_r8,4.9662e+04_r8,4.2568e+04_r8,3.5473e+04_r8,2.8378e+04_r8,2.1284e+04_r8, &
     &1.4189e+04_r8,7.0945e+03_r8,6.2524e+01_r8/)
      kao(:, 5,11,15) = (/ &
     &8.0798e+04_r8,7.0698e+04_r8,6.0598e+04_r8,5.0499e+04_r8,4.0399e+04_r8,3.0299e+04_r8, &
     &2.0199e+04_r8,1.0100e+04_r8,6.2689e+01_r8/)
      kao(:, 1,12,15) = (/ &
     &1.4989e+04_r8,1.3115e+04_r8,1.1241e+04_r8,9.3679e+03_r8,7.4943e+03_r8,5.6207e+03_r8, &
     &3.7471e+03_r8,1.8736e+03_r8,7.3162e+01_r8/)
      kao(:, 2,12,15) = (/ &
     &2.5949e+04_r8,2.2705e+04_r8,1.9461e+04_r8,1.6218e+04_r8,1.2974e+04_r8,9.7307e+03_r8, &
     &6.4871e+03_r8,3.2436e+03_r8,7.3885e+01_r8/)
      kao(:, 3,12,15) = (/ &
     &4.1513e+04_r8,3.6324e+04_r8,3.1134e+04_r8,2.5945e+04_r8,2.0756e+04_r8,1.5567e+04_r8, &
     &1.0378e+04_r8,5.1891e+03_r8,7.4405e+01_r8/)
      kao(:, 4,12,15) = (/ &
     &6.2315e+04_r8,5.4526e+04_r8,4.6737e+04_r8,3.8947e+04_r8,3.1158e+04_r8,2.3368e+04_r8, &
     &1.5579e+04_r8,7.7894e+03_r8,7.4701e+01_r8/)
      kao(:, 5,12,15) = (/ &
     &8.8861e+04_r8,7.7754e+04_r8,6.6646e+04_r8,5.5538e+04_r8,4.4431e+04_r8,3.3323e+04_r8, &
     &2.2215e+04_r8,1.1108e+04_r8,7.4795e+01_r8/)
      kao(:, 1,13,15) = (/ &
     &1.6915e+04_r8,1.4801e+04_r8,1.2687e+04_r8,1.0572e+04_r8,8.4577e+03_r8,6.3433e+03_r8, &
     &4.2289e+03_r8,2.1144e+03_r8,8.7334e+01_r8/)
      kao(:, 2,13,15) = (/ &
     &2.9284e+04_r8,2.5624e+04_r8,2.1963e+04_r8,1.8303e+04_r8,1.4642e+04_r8,1.0982e+04_r8, &
     &7.3211e+03_r8,3.6605e+03_r8,8.8104e+01_r8/)
      kao(:, 3,13,15) = (/ &
     &4.6892e+04_r8,4.1031e+04_r8,3.5169e+04_r8,2.9308e+04_r8,2.3446e+04_r8,1.7585e+04_r8, &
     &1.1723e+04_r8,5.8616e+03_r8,8.8585e+01_r8/)
      kao(:, 4,13,15) = (/ &
     &7.0448e+04_r8,6.1642e+04_r8,5.2836e+04_r8,4.4030e+04_r8,3.5224e+04_r8,2.6418e+04_r8, &
     &1.7612e+04_r8,8.8061e+03_r8,8.8802e+01_r8/)
      kao(:, 5,13,15) = (/ &
     &1.0039e+05_r8,8.7843e+04_r8,7.5294e+04_r8,6.2745e+04_r8,5.0196e+04_r8,3.7647e+04_r8, &
     &2.5098e+04_r8,1.2549e+04_r8,8.8791e+01_r8/)
      kao(:, 1, 1,16) = (/ &
     &4.3683e+04_r8,3.8223e+04_r8,3.2762e+04_r8,2.7302e+04_r8,2.1842e+04_r8,1.6381e+04_r8, &
     &1.0921e+04_r8,5.4604e+03_r8,7.6073e-03_r8/)
      kao(:, 2, 1,16) = (/ &
     &5.6813e+04_r8,4.9712e+04_r8,4.2610e+04_r8,3.5508e+04_r8,2.8407e+04_r8,2.1305e+04_r8, &
     &1.4203e+04_r8,7.1017e+03_r8,7.6403e-03_r8/)
      kao(:, 3, 1,16) = (/ &
     &7.1746e+04_r8,6.2777e+04_r8,5.3809e+04_r8,4.4841e+04_r8,3.5873e+04_r8,2.6905e+04_r8, &
     &1.7936e+04_r8,8.9682e+03_r8,3.7278e-03_r8/)
      kao(:, 4, 1,16) = (/ &
     &8.8334e+04_r8,7.7292e+04_r8,6.6250e+04_r8,5.5209e+04_r8,4.4167e+04_r8,3.3125e+04_r8, &
     &2.2083e+04_r8,1.1042e+04_r8,3.7292e-03_r8/)
      kao(:, 5, 1,16) = (/ &
     &1.0639e+05_r8,9.3091e+04_r8,7.9793e+04_r8,6.6494e+04_r8,5.3195e+04_r8,3.9896e+04_r8, &
     &2.6598e+04_r8,1.3299e+04_r8,7.8826e-01_r8/)
      kao(:, 1, 2,16) = (/ &
     &4.6897e+04_r8,4.1035e+04_r8,3.5173e+04_r8,2.9311e+04_r8,2.3449e+04_r8,1.7586e+04_r8, &
     &1.1724e+04_r8,5.8622e+03_r8,8.2408e-03_r8/)
      kao(:, 2, 2,16) = (/ &
     &6.1887e+04_r8,5.4151e+04_r8,4.6415e+04_r8,3.8679e+04_r8,3.0943e+04_r8,2.3208e+04_r8, &
     &1.5472e+04_r8,7.7359e+03_r8,1.2063e+01_r8/)
      kao(:, 3, 2,16) = (/ &
     &7.9108e+04_r8,6.9219e+04_r8,5.9331e+04_r8,4.9442e+04_r8,3.9554e+04_r8,2.9666e+04_r8, &
     &1.9777e+04_r8,9.8885e+03_r8,1.1743e+01_r8/)
      kao(:, 4, 2,16) = (/ &
     &9.8415e+04_r8,8.6113e+04_r8,7.3811e+04_r8,6.1509e+04_r8,4.9207e+04_r8,3.6906e+04_r8, &
     &2.4604e+04_r8,1.2302e+04_r8,3.5693e-03_r8/)
      kao(:, 5, 2,16) = (/ &
     &1.1961e+05_r8,1.0466e+05_r8,8.9707e+04_r8,7.4755e+04_r8,5.9804e+04_r8,4.4853e+04_r8, &
     &2.9902e+04_r8,1.4951e+04_r8,5.8824e-01_r8/)
      kao(:, 1, 3,16) = (/ &
     &4.7187e+04_r8,4.1289e+04_r8,3.5390e+04_r8,2.9492e+04_r8,2.3594e+04_r8,1.7695e+04_r8, &
     &1.1797e+04_r8,5.8984e+03_r8,1.4554e+01_r8/)
      kao(:, 2, 3,16) = (/ &
     &6.3662e+04_r8,5.5704e+04_r8,4.7746e+04_r8,3.9789e+04_r8,3.1831e+04_r8,2.3873e+04_r8, &
     &1.5915e+04_r8,7.9577e+03_r8,1.4573e+01_r8/)
      kao(:, 3, 3,16) = (/ &
     &8.2931e+04_r8,7.2565e+04_r8,6.2198e+04_r8,5.1832e+04_r8,4.1465e+04_r8,3.1099e+04_r8, &
     &2.0733e+04_r8,1.0366e+04_r8,1.4578e+01_r8/)
      kao(:, 4, 3,16) = (/ &
     &1.0484e+05_r8,9.1735e+04_r8,7.8630e+04_r8,6.5525e+04_r8,5.2420e+04_r8,3.9315e+04_r8, &
     &2.6210e+04_r8,1.3105e+04_r8,1.4538e+01_r8/)
      kao(:, 5, 3,16) = (/ &
     &1.2920e+05_r8,1.1305e+05_r8,9.6898e+04_r8,8.0748e+04_r8,6.4599e+04_r8,4.8449e+04_r8, &
     &3.2299e+04_r8,1.6150e+04_r8,1.4475e+01_r8/)
      kao(:, 1, 4,16) = (/ &
     &4.6077e+04_r8,4.0317e+04_r8,3.4558e+04_r8,2.8798e+04_r8,2.3038e+04_r8,1.7279e+04_r8, &
     &1.1519e+04_r8,5.7596e+03_r8,1.7584e+01_r8/)
      kao(:, 2, 4,16) = (/ &
     &6.3824e+04_r8,5.5846e+04_r8,4.7868e+04_r8,3.9890e+04_r8,3.1912e+04_r8,2.3934e+04_r8, &
     &1.5956e+04_r8,7.9779e+03_r8,1.7639e+01_r8/)
      kao(:, 3, 4,16) = (/ &
     &8.4999e+04_r8,7.4374e+04_r8,6.3749e+04_r8,5.3124e+04_r8,4.2499e+04_r8,3.1874e+04_r8, &
     &2.1250e+04_r8,1.0625e+04_r8,1.7665e+01_r8/)
      kao(:, 4, 4,16) = (/ &
     &1.0949e+05_r8,9.5804e+04_r8,8.2118e+04_r8,6.8432e+04_r8,5.4745e+04_r8,4.1059e+04_r8, &
     &2.7373e+04_r8,1.3686e+04_r8,1.7655e+01_r8/)
      kao(:, 5, 4,16) = (/ &
     &1.3706e+05_r8,1.1993e+05_r8,1.0280e+05_r8,8.5665e+04_r8,6.8532e+04_r8,5.1399e+04_r8, &
     &3.4266e+04_r8,1.7133e+04_r8,1.7601e+01_r8/)
      kao(:, 1, 5,16) = (/ &
     &4.4408e+04_r8,3.8857e+04_r8,3.3306e+04_r8,2.7755e+04_r8,2.2204e+04_r8,1.6653e+04_r8, &
     &1.1102e+04_r8,5.5509e+03_r8,2.1257e+01_r8/)
      kao(:, 2, 5,16) = (/ &
     &6.3274e+04_r8,5.5364e+04_r8,4.7455e+04_r8,3.9546e+04_r8,3.1637e+04_r8,2.3728e+04_r8, &
     &1.5818e+04_r8,7.9092e+03_r8,2.1367e+01_r8/)
      kao(:, 3, 5,16) = (/ &
     &8.6266e+04_r8,7.5483e+04_r8,6.4700e+04_r8,5.3916e+04_r8,4.3133e+04_r8,3.2350e+04_r8, &
     &2.1567e+04_r8,1.0783e+04_r8,2.1428e+01_r8/)
      kao(:, 4, 5,16) = (/ &
     &1.1336e+05_r8,9.9194e+04_r8,8.5023e+04_r8,7.0853e+04_r8,5.6682e+04_r8,4.2512e+04_r8, &
     &2.8341e+04_r8,1.4171e+04_r8,2.1442e+01_r8/)
      kao(:, 5, 5,16) = (/ &
     &1.4437e+05_r8,1.2632e+05_r8,1.0827e+05_r8,9.0229e+04_r8,7.2183e+04_r8,5.4137e+04_r8, &
     &3.6091e+04_r8,1.8046e+04_r8,2.1411e+01_r8/)
      kao(:, 1, 6,16) = (/ &
     &4.1622e+04_r8,3.6419e+04_r8,3.1217e+04_r8,2.6014e+04_r8,2.0811e+04_r8,1.5608e+04_r8, &
     &1.0406e+04_r8,5.2028e+03_r8,2.5704e+01_r8/)
      kao(:, 2, 6,16) = (/ &
     &6.1272e+04_r8,5.3613e+04_r8,4.5954e+04_r8,3.8295e+04_r8,3.0636e+04_r8,2.2977e+04_r8, &
     &1.5318e+04_r8,7.6590e+03_r8,2.5880e+01_r8/)
      kao(:, 3, 6,16) = (/ &
     &8.5823e+04_r8,7.5095e+04_r8,6.4367e+04_r8,5.3639e+04_r8,4.2911e+04_r8,3.2183e+04_r8, &
     &2.1456e+04_r8,1.0728e+04_r8,2.5988e+01_r8/)
      kao(:, 4, 6,16) = (/ &
     &1.1534e+05_r8,1.0092e+05_r8,8.6501e+04_r8,7.2084e+04_r8,5.7667e+04_r8,4.3251e+04_r8, &
     &2.8834e+04_r8,1.4417e+04_r8,2.6050e+01_r8/)
      kao(:, 5, 6,16) = (/ &
     &1.4970e+05_r8,1.3098e+05_r8,1.1227e+05_r8,9.3560e+04_r8,7.4848e+04_r8,5.6136e+04_r8, &
     &3.7424e+04_r8,1.8712e+04_r8,2.6033e+01_r8/)
      kao(:, 1, 7,16) = (/ &
     &3.8762e+04_r8,3.3917e+04_r8,2.9071e+04_r8,2.4226e+04_r8,1.9381e+04_r8,1.4536e+04_r8, &
     &9.6904e+03_r8,4.8452e+03_r8,3.1098e+01_r8/)
      kao(:, 2, 7,16) = (/ &
     &5.9114e+04_r8,5.1725e+04_r8,4.4335e+04_r8,3.6946e+04_r8,2.9557e+04_r8,2.2168e+04_r8, &
     &1.4778e+04_r8,7.3892e+03_r8,3.1343e+01_r8/)
      kao(:, 3, 7,16) = (/ &
     &8.5273e+04_r8,7.4614e+04_r8,6.3955e+04_r8,5.3296e+04_r8,4.2636e+04_r8,3.1977e+04_r8, &
     &2.1318e+04_r8,1.0659e+04_r8,3.1509e+01_r8/)
      kao(:, 4, 7,16) = (/ &
     &1.1738e+05_r8,1.0271e+05_r8,8.8034e+04_r8,7.3362e+04_r8,5.8689e+04_r8,4.4017e+04_r8, &
     &2.9345e+04_r8,1.4672e+04_r8,3.1622e+01_r8/)
      kao(:, 5, 7,16) = (/ &
     &1.5542e+05_r8,1.3599e+05_r8,1.1657e+05_r8,9.7138e+04_r8,7.7710e+04_r8,5.8283e+04_r8, &
     &3.8855e+04_r8,1.9427e+04_r8,3.1655e+01_r8/)
      kao(:, 1, 8,16) = (/ &
     &3.6377e+04_r8,3.1830e+04_r8,2.7279e+04_r8,2.2736e+04_r8,1.8189e+04_r8,1.3641e+04_r8, &
     &9.0943e+03_r8,4.5472e+03_r8,3.7610e+01_r8/)
      kao(:, 2, 8,16) = (/ &
     &5.7649e+04_r8,5.0443e+04_r8,4.3237e+04_r8,3.6031e+04_r8,2.8825e+04_r8,2.1619e+04_r8, &
     &1.4412e+04_r8,7.2062e+03_r8,3.7934e+01_r8/)
      kao(:, 3, 8,16) = (/ &
     &8.5747e+04_r8,7.5029e+04_r8,6.4311e+04_r8,5.3592e+04_r8,4.2874e+04_r8,3.2155e+04_r8, &
     &2.1437e+04_r8,1.0718e+04_r8,3.8193e+01_r8/)
      kao(:, 4, 8,16) = (/ &
     &1.2106e+05_r8,1.0593e+05_r8,9.0796e+04_r8,7.5663e+04_r8,6.0531e+04_r8,4.5398e+04_r8, &
     &3.0265e+04_r8,1.5133e+04_r8,3.8356e+01_r8/)
      kao(:, 5, 8,16) = (/ &
     &1.6369e+05_r8,1.4323e+05_r8,1.2277e+05_r8,1.0231e+05_r8,8.1844e+04_r8,6.1383e+04_r8, &
     &4.0922e+04_r8,2.0461e+04_r8,3.8437e+01_r8/)
      kao(:, 1, 9,16) = (/ &
     &3.3210e+04_r8,2.9058e+04_r8,2.4907e+04_r8,2.0756e+04_r8,1.6605e+04_r8,1.2454e+04_r8, &
     &8.3024e+03_r8,4.1512e+03_r8,4.5425e+01_r8/)
      kao(:, 2, 9,16) = (/ &
     &5.4859e+04_r8,4.8001e+04_r8,4.1144e+04_r8,3.4287e+04_r8,2.7429e+04_r8,2.0572e+04_r8, &
     &1.3715e+04_r8,6.8573e+03_r8,4.5889e+01_r8/)
      kao(:, 3, 9,16) = (/ &
     &8.4365e+04_r8,7.3820e+04_r8,6.3274e+04_r8,5.2728e+04_r8,4.2183e+04_r8,3.1637e+04_r8, &
     &2.1091e+04_r8,1.0546e+04_r8,4.6246e+01_r8/)
      kao(:, 4, 9,16) = (/ &
     &1.2241e+05_r8,1.0711e+05_r8,9.1805e+04_r8,7.6504e+04_r8,6.1203e+04_r8,4.5902e+04_r8, &
     &3.0602e+04_r8,1.5301e+04_r8,4.6486e+01_r8/)
      kao(:, 5, 9,16) = (/ &
     &1.6922e+05_r8,1.4806e+05_r8,1.2691e+05_r8,1.0576e+05_r8,8.4608e+04_r8,6.3456e+04_r8, &
     &4.2304e+04_r8,2.1152e+04_r8,4.6625e+01_r8/)
      kao(:, 1,10,16) = (/ &
     &3.0979e+04_r8,2.7106e+04_r8,2.3234e+04_r8,1.9362e+04_r8,1.5489e+04_r8,1.1617e+04_r8, &
     &7.7447e+03_r8,3.8723e+03_r8,5.4886e+01_r8/)
      kao(:, 2,10,16) = (/ &
     &5.3196e+04_r8,4.6547e+04_r8,3.9897e+04_r8,3.3248e+04_r8,2.6598e+04_r8,1.9948e+04_r8, &
     &1.3299e+04_r8,6.6495e+03_r8,5.5476e+01_r8/)
      kao(:, 3,10,16) = (/ &
     &8.4341e+04_r8,7.3798e+04_r8,6.3256e+04_r8,5.2713e+04_r8,4.2170e+04_r8,3.1628e+04_r8, &
     &2.1085e+04_r8,1.0332e+04_r8,5.5974e+01_r8/)
      kao(:, 4,10,16) = (/ &
     &1.2535e+05_r8,1.0968e+05_r8,9.4014e+04_r8,7.8345e+04_r8,6.2676e+04_r8,4.7007e+04_r8, &
     &3.1338e+04_r8,1.5669e+04_r8,5.6279e+01_r8/)
      kao(:, 5,10,16) = (/ &
     &1.7674e+05_r8,1.5464e+05_r8,1.3255e+05_r8,1.1046e+05_r8,8.8368e+04_r8,6.6276e+04_r8, &
     &4.4184e+04_r8,2.2092e+04_r8,5.6482e+01_r8/)
      kao(:, 1,11,16) = (/ &
     &3.7488e+04_r8,3.2802e+04_r8,2.8116e+04_r8,2.3430e+04_r8,1.8744e+04_r8,1.4058e+04_r8, &
     &9.3718e+03_r8,4.6859e+03_r8,6.6623e+01_r8/)
      kao(:, 2,11,16) = (/ &
     &6.4180e+04_r8,5.6158e+04_r8,4.8135e+04_r8,4.0112e+04_r8,3.2090e+04_r8,2.4067e+04_r8, &
     &1.6045e+04_r8,8.0224e+03_r8,6.7308e+01_r8/)
      kao(:, 3,11,16) = (/ &
     &1.0143e+05_r8,8.8753e+04_r8,7.6074e+04_r8,6.3395e+04_r8,5.0716e+04_r8,3.8037e+04_r8, &
     &2.5358e+04_r8,1.2679e+04_r8,6.7849e+01_r8/)
      kao(:, 4,11,16) = (/ &
     &1.5034e+05_r8,1.3155e+05_r8,1.1275e+05_r8,9.3961e+04_r8,7.5169e+04_r8,5.6376e+04_r8, &
     &3.7584e+04_r8,1.8792e+04_r8,6.8179e+01_r8/)
      kao(:, 5,11,16) = (/ &
     &2.1140e+05_r8,1.8498e+05_r8,1.5855e+05_r8,1.3213e+05_r8,1.0570e+05_r8,7.9275e+04_r8, &
     &5.2850e+04_r8,2.6425e+04_r8,6.8333e+01_r8/)
      kao(:, 1,12,16) = (/ &
     &4.5641e+04_r8,3.9936e+04_r8,3.4231e+04_r8,2.8526e+04_r8,2.2821e+04_r8,1.7116e+04_r8, &
     &1.1410e+04_r8,5.7052e+03_r8,8.0729e+01_r8/)
      kao(:, 2,12,16) = (/ &
     &7.7843e+04_r8,6.8113e+04_r8,5.8382e+04_r8,4.8652e+04_r8,3.8922e+04_r8,2.9191e+04_r8, &
     &1.9461e+04_r8,9.7304e+03_r8,8.1511e+01_r8/)
      kao(:, 3,12,16) = (/ &
     &1.2264e+05_r8,1.0731e+05_r8,9.1979e+04_r8,7.6649e+04_r8,6.1320e+04_r8,4.5990e+04_r8, &
     &3.0660e+04_r8,1.5330e+04_r8,8.2042e+01_r8/)
      kao(:, 4,12,16) = (/ &
     &1.8173e+05_r8,1.5901e+05_r8,1.3629e+05_r8,1.1358e+05_r8,9.0863e+04_r8,6.8147e+04_r8, &
     &4.5431e+04_r8,2.2716e+04_r8,8.2374e+01_r8/)
      kao(:, 5,12,16) = (/ &
     &2.5615e+05_r8,2.2413e+05_r8,1.9211e+05_r8,1.6009e+05_r8,1.2807e+05_r8,9.6056e+04_r8, &
     &6.4037e+04_r8,3.2019e+04_r8,8.2428e+01_r8/)
      kao(:, 1,13,16) = (/ &
     &5.7163e+04_r8,5.0018e+04_r8,4.2872e+04_r8,3.5727e+04_r8,2.8582e+04_r8,2.1436e+04_r8, &
     &1.4291e+04_r8,7.1455e+03_r8,9.7539e+01_r8/)
      kao(:, 2,13,16) = (/ &
     &9.7458e+04_r8,8.5276e+04_r8,7.3094e+04_r8,6.0911e+04_r8,4.8729e+04_r8,3.6547e+04_r8, &
     &2.4365e+04_r8,1.2182e+04_r8,9.8425e+01_r8/)
      kao(:, 3,13,16) = (/ &
     &1.5404e+05_r8,1.3479e+05_r8,1.1553e+05_r8,9.6277e+04_r8,7.7021e+04_r8,5.7766e+04_r8, &
     &3.8511e+04_r8,1.9255e+04_r8,9.8903e+01_r8/)
      kao(:, 4,13,16) = (/ &
     &2.2887e+05_r8,2.0026e+05_r8,1.7165e+05_r8,1.4304e+05_r8,1.1444e+05_r8,8.5827e+04_r8, &
     &5.7218e+04_r8,2.8609e+04_r8,9.9135e+01_r8/)
      kao(:, 5,13,16) = (/ &
     &3.2310e+05_r8,2.8271e+05_r8,2.4232e+05_r8,2.0194e+05_r8,1.6155e+05_r8,1.2116e+05_r8, &
     &8.0775e+04_r8,4.0387e+04_r8,9.9042e+01_r8/)

!     The array KA_Mxx contains the absorption coefficient for 
!     a minor species at the 16 chosen g-values for a reference pressure
!     level below 100~ mb.   The first index in the array, JS, runs
!     from 1 to 10, and corresponds to different gas column amount ratios,
!     as expressed through the binary species parameter eta, defined as
!     eta = gas1/(gas1 + (rat) * gas2), where rat is the 
!     ratio of the reference MLS column amount value of gas 1 
!     to that of gas2.  The second index refers to temperature 
!     in 7.2 degree increments.  For instance, JT = 1 refers to a 
!     temperature of 188.0, JT = 2 refers to 195.2, etc. The third index 
!     runs over the g-channel (1 to 16).

       kao_mn2( 1, :, 1) = (/ &
     & 3.24352e-08_r8, 3.39625e-08_r8, 3.55618e-08_r8, 3.72364e-08_r8, 3.89899e-08_r8, &
     & 4.08259e-08_r8, 4.27484e-08_r8, 4.47614e-08_r8, 4.68692e-08_r8, 4.90763e-08_r8, &
     & 5.13873e-08_r8, 5.38071e-08_r8, 5.63409e-08_r8, 5.89940e-08_r8, 6.17720e-08_r8, &
     & 6.46808e-08_r8, 6.77266e-08_r8, 7.09158e-08_r8, 7.42553e-08_r8/)
       kao_mn2( 2, :, 1) = (/ &
     & 3.44203e-08_r8, 3.60254e-08_r8, 3.77053e-08_r8, 3.94636e-08_r8, 4.13038e-08_r8, &
     & 4.32299e-08_r8, 4.52458e-08_r8, 4.73557e-08_r8, 4.95640e-08_r8, 5.18753e-08_r8, &
     & 5.42943e-08_r8, 5.68262e-08_r8, 5.94761e-08_r8, 6.22496e-08_r8, 6.51524e-08_r8, &
     & 6.81906e-08_r8, 7.13704e-08_r8, 7.46986e-08_r8, 7.81819e-08_r8/)
       kao_mn2( 3, :, 1) = (/ &
     & 3.44344e-08_r8, 3.61485e-08_r8, 3.79480e-08_r8, 3.98370e-08_r8, 4.18201e-08_r8, &
     & 4.39019e-08_r8, 4.60873e-08_r8, 4.83815e-08_r8, 5.07899e-08_r8, 5.33182e-08_r8, &
     & 5.59723e-08_r8, 5.87586e-08_r8, 6.16836e-08_r8, 6.47541e-08_r8, 6.79776e-08_r8, &
     & 7.13614e-08_r8, 7.49138e-08_r8, 7.86429e-08_r8, 8.25577e-08_r8/)
       kao_mn2( 4, :, 1) = (/ &
     & 4.21102e-08_r8, 4.38921e-08_r8, 4.57493e-08_r8, 4.76852e-08_r8, 4.97029e-08_r8, &
     & 5.18061e-08_r8, 5.39982e-08_r8, 5.62831e-08_r8, 5.86647e-08_r8, 6.11470e-08_r8, &
     & 6.37344e-08_r8, 6.64313e-08_r8, 6.92422e-08_r8, 7.21722e-08_r8, 7.52261e-08_r8, &
     & 7.84092e-08_r8, 8.17270e-08_r8, 8.51852e-08_r8, 8.87897e-08_r8/)
       kao_mn2( 5, :, 1) = (/ &
     & 4.78813e-08_r8, 5.01015e-08_r8, 5.24246e-08_r8, 5.48554e-08_r8, 5.73989e-08_r8, &
     & 6.00603e-08_r8, 6.28452e-08_r8, 6.57592e-08_r8, 6.88083e-08_r8, 7.19987e-08_r8, &
     & 7.53371e-08_r8, 7.88304e-08_r8, 8.24855e-08_r8, 8.63102e-08_r8, 9.03122e-08_r8, &
     & 9.44997e-08_r8, 9.88815e-08_r8, 1.03466e-07_r8, 1.08264e-07_r8/)
       kao_mn2( 6, :, 1) = (/ &
     & 7.03115e-08_r8, 7.27877e-08_r8, 7.53511e-08_r8, 7.80048e-08_r8, 8.07519e-08_r8, &
     & 8.35958e-08_r8, 8.65398e-08_r8, 8.95875e-08_r8, 9.27426e-08_r8, 9.60087e-08_r8, &
     & 9.93899e-08_r8, 1.02890e-07_r8, 1.06514e-07_r8, 1.10265e-07_r8, 1.14148e-07_r8, &
     & 1.18168e-07_r8, 1.22330e-07_r8, 1.26638e-07_r8, 1.31098e-07_r8/)
       kao_mn2( 7, :, 1) = (/ &
     & 8.86454e-08_r8, 9.20065e-08_r8, 9.54951e-08_r8, 9.91159e-08_r8, 1.02874e-07_r8, &
     & 1.06775e-07_r8, 1.10823e-07_r8, 1.15025e-07_r8, 1.19387e-07_r8, 1.23913e-07_r8, &
     & 1.28612e-07_r8, 1.33488e-07_r8, 1.38550e-07_r8, 1.43803e-07_r8, 1.49255e-07_r8, &
     & 1.54915e-07_r8, 1.60788e-07_r8, 1.66885e-07_r8, 1.73213e-07_r8/)
       kao_mn2( 8, :, 1) = (/ &
     & 1.34118e-07_r8, 1.38267e-07_r8, 1.42545e-07_r8, 1.46955e-07_r8, 1.51502e-07_r8, &
     & 1.56189e-07_r8, 1.61022e-07_r8, 1.66004e-07_r8, 1.71140e-07_r8, 1.76435e-07_r8, &
     & 1.81893e-07_r8, 1.87521e-07_r8, 1.93323e-07_r8, 1.99304e-07_r8, 2.05470e-07_r8, &
     & 2.11827e-07_r8, 2.18381e-07_r8, 2.25138e-07_r8, 2.32103e-07_r8/)
       kao_mn2( 9, :, 1) = (/ &
     & 5.08256e-08_r8, 5.30384e-08_r8, 5.53476e-08_r8, 5.77573e-08_r8, 6.02718e-08_r8, &
     & 6.28959e-08_r8, 6.56342e-08_r8, 6.84917e-08_r8, 7.14737e-08_r8, 7.45854e-08_r8, &
     & 7.78327e-08_r8, 8.12213e-08_r8, 8.47574e-08_r8, 8.84475e-08_r8, 9.22983e-08_r8, &
     & 9.63167e-08_r8, 1.00510e-07_r8, 1.04886e-07_r8, 1.09452e-07_r8/)
       kao_mn2( 1, :, 2) = (/ &
     & 8.23958e-08_r8, 8.39092e-08_r8, 8.54504e-08_r8, 8.70200e-08_r8, 8.86183e-08_r8, &
     & 9.02460e-08_r8, 9.19036e-08_r8, 9.35917e-08_r8, 9.53107e-08_r8, 9.70614e-08_r8, &
     & 9.88442e-08_r8, 1.00660e-07_r8, 1.02509e-07_r8, 1.04391e-07_r8, 1.06309e-07_r8, &
     & 1.08261e-07_r8, 1.10250e-07_r8, 1.12275e-07_r8, 1.14337e-07_r8/)
       kao_mn2( 2, :, 2) = (/ &
     & 8.52335e-08_r8, 8.69254e-08_r8, 8.86509e-08_r8, 9.04107e-08_r8, 9.22054e-08_r8, &
     & 9.40357e-08_r8, 9.59024e-08_r8, 9.78061e-08_r8, 9.97476e-08_r8, 1.01728e-07_r8, &
     & 1.03747e-07_r8, 1.05806e-07_r8, 1.07907e-07_r8, 1.10049e-07_r8, 1.12233e-07_r8, &
     & 1.14461e-07_r8, 1.16733e-07_r8, 1.19050e-07_r8, 1.21414e-07_r8/)
       kao_mn2( 3, :, 2) = (/ &
     & 1.04608e-07_r8, 1.06067e-07_r8, 1.07546e-07_r8, 1.09046e-07_r8, 1.10567e-07_r8, &
     & 1.12110e-07_r8, 1.13673e-07_r8, 1.15259e-07_r8, 1.16866e-07_r8, 1.18496e-07_r8, &
     & 1.20149e-07_r8, 1.21825e-07_r8, 1.23524e-07_r8, 1.25247e-07_r8, 1.26994e-07_r8, &
     & 1.28765e-07_r8, 1.30561e-07_r8, 1.32382e-07_r8, 1.34229e-07_r8/)
       kao_mn2( 4, :, 2) = (/ &
     & 1.17504e-07_r8, 1.18763e-07_r8, 1.20036e-07_r8, 1.21322e-07_r8, 1.22622e-07_r8, &
     & 1.23936e-07_r8, 1.25265e-07_r8, 1.26607e-07_r8, 1.27964e-07_r8, 1.29335e-07_r8, &
     & 1.30721e-07_r8, 1.32122e-07_r8, 1.33538e-07_r8, 1.34969e-07_r8, 1.36415e-07_r8, &
     & 1.37877e-07_r8, 1.39354e-07_r8, 1.40848e-07_r8, 1.42357e-07_r8/)
       kao_mn2( 5, :, 2) = (/ &
     & 1.23552e-07_r8, 1.25200e-07_r8, 1.26870e-07_r8, 1.28562e-07_r8, 1.30277e-07_r8, &
     & 1.32015e-07_r8, 1.33776e-07_r8, 1.35560e-07_r8, 1.37368e-07_r8, 1.39200e-07_r8, &
     & 1.41057e-07_r8, 1.42938e-07_r8, 1.44845e-07_r8, 1.46777e-07_r8, 1.48735e-07_r8, &
     & 1.50718e-07_r8, 1.52729e-07_r8, 1.54766e-07_r8, 1.56830e-07_r8/)
       kao_mn2( 6, :, 2) = (/ &
     & 1.29682e-07_r8, 1.32226e-07_r8, 1.34820e-07_r8, 1.37464e-07_r8, 1.40161e-07_r8, &
     & 1.42910e-07_r8, 1.45713e-07_r8, 1.48571e-07_r8, 1.51486e-07_r8, 1.54457e-07_r8, &
     & 1.57487e-07_r8, 1.60576e-07_r8, 1.63726e-07_r8, 1.66937e-07_r8, 1.70212e-07_r8, &
     & 1.73551e-07_r8, 1.76955e-07_r8, 1.80426e-07_r8, 1.83965e-07_r8/)
       kao_mn2( 7, :, 2) = (/ &
     & 1.77416e-07_r8, 1.78627e-07_r8, 1.79846e-07_r8, 1.81073e-07_r8, 1.82309e-07_r8, &
     & 1.83554e-07_r8, 1.84806e-07_r8, 1.86068e-07_r8, 1.87338e-07_r8, 1.88616e-07_r8, &
     & 1.89904e-07_r8, 1.91200e-07_r8, 1.92505e-07_r8, 1.93819e-07_r8, 1.95142e-07_r8, &
     & 1.96474e-07_r8, 1.97815e-07_r8, 1.99165e-07_r8, 2.00524e-07_r8/)
       kao_mn2( 8, :, 2) = (/ &
     & 2.20695e-07_r8, 2.20451e-07_r8, 2.20208e-07_r8, 2.19965e-07_r8, 2.19722e-07_r8, &
     & 2.19480e-07_r8, 2.19238e-07_r8, 2.18996e-07_r8, 2.18754e-07_r8, 2.18513e-07_r8, &
     & 2.18272e-07_r8, 2.18031e-07_r8, 2.17790e-07_r8, 2.17550e-07_r8, 2.17310e-07_r8, &
     & 2.17070e-07_r8, 2.16831e-07_r8, 2.16591e-07_r8, 2.16352e-07_r8/)
       kao_mn2( 9, :, 2) = (/ &
     & 1.23015e-07_r8, 1.24808e-07_r8, 1.26626e-07_r8, 1.28471e-07_r8, 1.30343e-07_r8, &
     & 1.32242e-07_r8, 1.34168e-07_r8, 1.36123e-07_r8, 1.38106e-07_r8, 1.40118e-07_r8, &
     & 1.42160e-07_r8, 1.44231e-07_r8, 1.46332e-07_r8, 1.48464e-07_r8, 1.50627e-07_r8, &
     & 1.52822e-07_r8, 1.55048e-07_r8, 1.57307e-07_r8, 1.59599e-07_r8/)
       kao_mn2( 1, :, 3) = (/ &
     & 1.87585e-07_r8, 1.89503e-07_r8, 1.91440e-07_r8, 1.93398e-07_r8, 1.95375e-07_r8, &
     & 1.97372e-07_r8, 1.99390e-07_r8, 2.01429e-07_r8, 2.03488e-07_r8, 2.05568e-07_r8, &
     & 2.07670e-07_r8, 2.09793e-07_r8, 2.11938e-07_r8, 2.14105e-07_r8, 2.16294e-07_r8, &
     & 2.18505e-07_r8, 2.20739e-07_r8, 2.22996e-07_r8, 2.25275e-07_r8/)
       kao_mn2( 2, :, 3) = (/ &
     & 1.82585e-07_r8, 1.84249e-07_r8, 1.85929e-07_r8, 1.87624e-07_r8, 1.89335e-07_r8, &
     & 1.91061e-07_r8, 1.92803e-07_r8, 1.94561e-07_r8, 1.96335e-07_r8, 1.98125e-07_r8, &
     & 1.99932e-07_r8, 2.01755e-07_r8, 2.03594e-07_r8, 2.05451e-07_r8, 2.07324e-07_r8, &
     & 2.09214e-07_r8, 2.11122e-07_r8, 2.13047e-07_r8, 2.14989e-07_r8/)
       kao_mn2( 3, :, 3) = (/ &
     & 1.64711e-07_r8, 1.67539e-07_r8, 1.70417e-07_r8, 1.73343e-07_r8, 1.76321e-07_r8, &
     & 1.79349e-07_r8, 1.82429e-07_r8, 1.85562e-07_r8, 1.88749e-07_r8, 1.91990e-07_r8, &
     & 1.95288e-07_r8, 1.98642e-07_r8, 2.02053e-07_r8, 2.05523e-07_r8, 2.09053e-07_r8, &
     & 2.12643e-07_r8, 2.16295e-07_r8, 2.20010e-07_r8, 2.23788e-07_r8/)
       kao_mn2( 4, :, 3) = (/ &
     & 1.67494e-07_r8, 1.71011e-07_r8, 1.74601e-07_r8, 1.78267e-07_r8, 1.82009e-07_r8, &
     & 1.85831e-07_r8, 1.89732e-07_r8, 1.93715e-07_r8, 1.97782e-07_r8, 2.01935e-07_r8, &
     & 2.06174e-07_r8, 2.10503e-07_r8, 2.14922e-07_r8, 2.19434e-07_r8, 2.24041e-07_r8, &
     & 2.28745e-07_r8, 2.33548e-07_r8, 2.38451e-07_r8, 2.43457e-07_r8/)
       kao_mn2( 5, :, 3) = (/ &
     & 1.97399e-07_r8, 2.00092e-07_r8, 2.02821e-07_r8, 2.05588e-07_r8, 2.08393e-07_r8, &
     & 2.11236e-07_r8, 2.14118e-07_r8, 2.17039e-07_r8, 2.20000e-07_r8, 2.23001e-07_r8, &
     & 2.26043e-07_r8, 2.29127e-07_r8, 2.32252e-07_r8, 2.35421e-07_r8, 2.38633e-07_r8, &
     & 2.41888e-07_r8, 2.45188e-07_r8, 2.48533e-07_r8, 2.51923e-07_r8/)
       kao_mn2( 6, :, 3) = (/ &
     & 2.24021e-07_r8, 2.24970e-07_r8, 2.25923e-07_r8, 2.26880e-07_r8, 2.27840e-07_r8, &
     & 2.28805e-07_r8, 2.29774e-07_r8, 2.30747e-07_r8, 2.31725e-07_r8, 2.32706e-07_r8, &
     & 2.33692e-07_r8, 2.34681e-07_r8, 2.35675e-07_r8, 2.36673e-07_r8, 2.37675e-07_r8, &
     & 2.38682e-07_r8, 2.39693e-07_r8, 2.40708e-07_r8, 2.41727e-07_r8/)
       kao_mn2( 7, :, 3) = (/ &
     & 1.98178e-07_r8, 2.00676e-07_r8, 2.03205e-07_r8, 2.05766e-07_r8, 2.08359e-07_r8, &
     & 2.10986e-07_r8, 2.13645e-07_r8, 2.16337e-07_r8, 2.19064e-07_r8, 2.21825e-07_r8, &
     & 2.24621e-07_r8, 2.27452e-07_r8, 2.30319e-07_r8, 2.33222e-07_r8, 2.36161e-07_r8, &
     & 2.39138e-07_r8, 2.42152e-07_r8, 2.45204e-07_r8, 2.48294e-07_r8/)
       kao_mn2( 8, :, 3) = (/ &
     & 2.83042e-07_r8, 2.89941e-07_r8, 2.97009e-07_r8, 3.04250e-07_r8, 3.11666e-07_r8, &
     & 3.19264e-07_r8, 3.27047e-07_r8, 3.35019e-07_r8, 3.43186e-07_r8, 3.51552e-07_r8, &
     & 3.60122e-07_r8, 3.68901e-07_r8, 3.77893e-07_r8, 3.87105e-07_r8, 3.96542e-07_r8, &
     & 4.06208e-07_r8, 4.16111e-07_r8, 4.26254e-07_r8, 4.36645e-07_r8/)
       kao_mn2( 9, :, 3) = (/ &
     & 1.98963e-07_r8, 2.01576e-07_r8, 2.04224e-07_r8, 2.06907e-07_r8, 2.09626e-07_r8, &
     & 2.12379e-07_r8, 2.15169e-07_r8, 2.17996e-07_r8, 2.20860e-07_r8, 2.23761e-07_r8, &
     & 2.26701e-07_r8, 2.29679e-07_r8, 2.32696e-07_r8, 2.35753e-07_r8, 2.38851e-07_r8, &
     & 2.41988e-07_r8, 2.45167e-07_r8, 2.48388e-07_r8, 2.51651e-07_r8/)
       kao_mn2( 1, :, 4) = (/ &
     & 3.75434e-07_r8, 3.79581e-07_r8, 3.83775e-07_r8, 3.88014e-07_r8, 3.92301e-07_r8, &
     & 3.96634e-07_r8, 4.01016e-07_r8, 4.05446e-07_r8, 4.09925e-07_r8, 4.14453e-07_r8, &
     & 4.19032e-07_r8, 4.23661e-07_r8, 4.28341e-07_r8, 4.33073e-07_r8, 4.37857e-07_r8, &
     & 4.42694e-07_r8, 4.47585e-07_r8, 4.52529e-07_r8, 4.57528e-07_r8/)
       kao_mn2( 2, :, 4) = (/ &
     & 3.76756e-07_r8, 3.80760e-07_r8, 3.84805e-07_r8, 3.88894e-07_r8, 3.93027e-07_r8, &
     & 3.97203e-07_r8, 4.01423e-07_r8, 4.05689e-07_r8, 4.10000e-07_r8, 4.14356e-07_r8, &
     & 4.18759e-07_r8, 4.23209e-07_r8, 4.27706e-07_r8, 4.32250e-07_r8, 4.36843e-07_r8, &
     & 4.41485e-07_r8, 4.46176e-07_r8, 4.50917e-07_r8, 4.55708e-07_r8/)
       kao_mn2( 3, :, 4) = (/ &
     & 3.76258e-07_r8, 3.78929e-07_r8, 3.81619e-07_r8, 3.84329e-07_r8, 3.87057e-07_r8, &
     & 3.89805e-07_r8, 3.92572e-07_r8, 3.95359e-07_r8, 3.98166e-07_r8, 4.00993e-07_r8, &
     & 4.03839e-07_r8, 4.06706e-07_r8, 4.09594e-07_r8, 4.12502e-07_r8, 4.15430e-07_r8, &
     & 4.18379e-07_r8, 4.21349e-07_r8, 4.24341e-07_r8, 4.27353e-07_r8/)
       kao_mn2( 4, :, 4) = (/ &
     & 3.17796e-07_r8, 3.22447e-07_r8, 3.27166e-07_r8, 3.31954e-07_r8, 3.36812e-07_r8, &
     & 3.41742e-07_r8, 3.46743e-07_r8, 3.51818e-07_r8, 3.56967e-07_r8, 3.62191e-07_r8, &
     & 3.67492e-07_r8, 3.72870e-07_r8, 3.78328e-07_r8, 3.83865e-07_r8, 3.89483e-07_r8, &
     & 3.95183e-07_r8, 4.00967e-07_r8, 4.06835e-07_r8, 4.12789e-07_r8/)
       kao_mn2( 5, :, 4) = (/ &
     & 3.33793e-07_r8, 3.38941e-07_r8, 3.44169e-07_r8, 3.49478e-07_r8, 3.54868e-07_r8, &
     & 3.60342e-07_r8, 3.65900e-07_r8, 3.71544e-07_r8, 3.77275e-07_r8, 3.83094e-07_r8, &
     & 3.89003e-07_r8, 3.95003e-07_r8, 4.01096e-07_r8, 4.07283e-07_r8, 4.13565e-07_r8, &
     & 4.19944e-07_r8, 4.26421e-07_r8, 4.32999e-07_r8, 4.39677e-07_r8/)
       kao_mn2( 6, :, 4) = (/ &
     & 3.60052e-07_r8, 3.66686e-07_r8, 3.73442e-07_r8, 3.80323e-07_r8, 3.87330e-07_r8, &
     & 3.94466e-07_r8, 4.01734e-07_r8, 4.09136e-07_r8, 4.16674e-07_r8, 4.24351e-07_r8, &
     & 4.32169e-07_r8, 4.40132e-07_r8, 4.48241e-07_r8, 4.56500e-07_r8, 4.64910e-07_r8, &
     & 4.73476e-07_r8, 4.82200e-07_r8, 4.91084e-07_r8, 5.00132e-07_r8/)
       kao_mn2( 7, :, 4) = (/ &
     & 4.14713e-07_r8, 4.21885e-07_r8, 4.29181e-07_r8, 4.36603e-07_r8, 4.44153e-07_r8, &
     & 4.51834e-07_r8, 4.59648e-07_r8, 4.67598e-07_r8, 4.75684e-07_r8, 4.83910e-07_r8, &
     & 4.92279e-07_r8, 5.00793e-07_r8, 5.09453e-07_r8, 5.18264e-07_r8, 5.27226e-07_r8, &
     & 5.36344e-07_r8, 5.45620e-07_r8, 5.55055e-07_r8, 5.64654e-07_r8/)
       kao_mn2( 8, :, 4) = (/ &
     & 4.15352e-07_r8, 4.24386e-07_r8, 4.33617e-07_r8, 4.43049e-07_r8, 4.52685e-07_r8, &
     & 4.62532e-07_r8, 4.72592e-07_r8, 4.82872e-07_r8, 4.93374e-07_r8, 5.04106e-07_r8, &
     & 5.15071e-07_r8, 5.26274e-07_r8, 5.37721e-07_r8, 5.49417e-07_r8, 5.61367e-07_r8, &
     & 5.73577e-07_r8, 5.86053e-07_r8, 5.98800e-07_r8, 6.11825e-07_r8/)
       kao_mn2( 9, :, 4) = (/ &
     & 3.33820e-07_r8, 3.39144e-07_r8, 3.44553e-07_r8, 3.50048e-07_r8, 3.55631e-07_r8, &
     & 3.61302e-07_r8, 3.67065e-07_r8, 3.72919e-07_r8, 3.78866e-07_r8, 3.84908e-07_r8, &
     & 3.91047e-07_r8, 3.97284e-07_r8, 4.03620e-07_r8, 4.10057e-07_r8, 4.16597e-07_r8, &
     & 4.23241e-07_r8, 4.29991e-07_r8, 4.36849e-07_r8, 4.43816e-07_r8/)
       kao_mn2( 1, :, 5) = (/ &
     & 6.99819e-07_r8, 7.04629e-07_r8, 7.09472e-07_r8, 7.14349e-07_r8, 7.19258e-07_r8, &
     & 7.24202e-07_r8, 7.29180e-07_r8, 7.34192e-07_r8, 7.39238e-07_r8, 7.44319e-07_r8, &
     & 7.49435e-07_r8, 7.54586e-07_r8, 7.59773e-07_r8, 7.64995e-07_r8, 7.70253e-07_r8, &
     & 7.75547e-07_r8, 7.80877e-07_r8, 7.86245e-07_r8, 7.91649e-07_r8/)
       kao_mn2( 2, :, 5) = (/ &
     & 6.98257e-07_r8, 7.03182e-07_r8, 7.08143e-07_r8, 7.13138e-07_r8, 7.18169e-07_r8, &
     & 7.23235e-07_r8, 7.28336e-07_r8, 7.33474e-07_r8, 7.38648e-07_r8, 7.43858e-07_r8, &
     & 7.49106e-07_r8, 7.54390e-07_r8, 7.59711e-07_r8, 7.65071e-07_r8, 7.70467e-07_r8, &
     & 7.75902e-07_r8, 7.81376e-07_r8, 7.86887e-07_r8, 7.92438e-07_r8/)
       kao_mn2( 3, :, 5) = (/ &
     & 6.98531e-07_r8, 7.03429e-07_r8, 7.08361e-07_r8, 7.13328e-07_r8, 7.18329e-07_r8, &
     & 7.23365e-07_r8, 7.28437e-07_r8, 7.33545e-07_r8, 7.38688e-07_r8, 7.43867e-07_r8, &
     & 7.49082e-07_r8, 7.54335e-07_r8, 7.59623e-07_r8, 7.64950e-07_r8, 7.70313e-07_r8, &
     & 7.75714e-07_r8, 7.81153e-07_r8, 7.86630e-07_r8, 7.92145e-07_r8/)
       kao_mn2( 4, :, 5) = (/ &
     & 7.37210e-07_r8, 7.38869e-07_r8, 7.40532e-07_r8, 7.42198e-07_r8, 7.43868e-07_r8, &
     & 7.45542e-07_r8, 7.47219e-07_r8, 7.48901e-07_r8, 7.50586e-07_r8, 7.52275e-07_r8, &
     & 7.53967e-07_r8, 7.55664e-07_r8, 7.57364e-07_r8, 7.59068e-07_r8, 7.60777e-07_r8, &
     & 7.62488e-07_r8, 7.64204e-07_r8, 7.65924e-07_r8, 7.67647e-07_r8/)
       kao_mn2( 5, :, 5) = (/ &
     & 6.07063e-07_r8, 6.12893e-07_r8, 6.18779e-07_r8, 6.24722e-07_r8, 6.30721e-07_r8, &
     & 6.36778e-07_r8, 6.42893e-07_r8, 6.49067e-07_r8, 6.55301e-07_r8, 6.61594e-07_r8, &
     & 6.67947e-07_r8, 6.74362e-07_r8, 6.80838e-07_r8, 6.87376e-07_r8, 6.93978e-07_r8, &
     & 7.00642e-07_r8, 7.07371e-07_r8, 7.14164e-07_r8, 7.21022e-07_r8/)
       kao_mn2( 6, :, 5) = (/ &
     & 6.13354e-07_r8, 6.20147e-07_r8, 6.27016e-07_r8, 6.33961e-07_r8, 6.40983e-07_r8, &
     & 6.48082e-07_r8, 6.55260e-07_r8, 6.62518e-07_r8, 6.69856e-07_r8, 6.77276e-07_r8, &
     & 6.84777e-07_r8, 6.92362e-07_r8, 7.00030e-07_r8, 7.07784e-07_r8, 7.15624e-07_r8, &
     & 7.23550e-07_r8, 7.31564e-07_r8, 7.39667e-07_r8, 7.47859e-07_r8/)
       kao_mn2( 7, :, 5) = (/ &
     & 6.86666e-07_r8, 6.92902e-07_r8, 6.99195e-07_r8, 7.05545e-07_r8, 7.11952e-07_r8, &
     & 7.18418e-07_r8, 7.24943e-07_r8, 7.31526e-07_r8, 7.38170e-07_r8, 7.44874e-07_r8, &
     & 7.51639e-07_r8, 7.58465e-07_r8, 7.65353e-07_r8, 7.72304e-07_r8, 7.79318e-07_r8, &
     & 7.86395e-07_r8, 7.93537e-07_r8, 8.00744e-07_r8, 8.08016e-07_r8/)
       kao_mn2( 8, :, 5) = (/ &
     & 9.39664e-07_r8, 9.39765e-07_r8, 9.39866e-07_r8, 9.39966e-07_r8, 9.40067e-07_r8, &
     & 9.40168e-07_r8, 9.40268e-07_r8, 9.40369e-07_r8, 9.40470e-07_r8, 9.40571e-07_r8, &
     & 9.40671e-07_r8, 9.40772e-07_r8, 9.40873e-07_r8, 9.40974e-07_r8, 9.41074e-07_r8, &
     & 9.41175e-07_r8, 9.41276e-07_r8, 9.41377e-07_r8, 9.41478e-07_r8/)
       kao_mn2( 9, :, 5) = (/ &
     & 6.02847e-07_r8, 6.09726e-07_r8, 6.16684e-07_r8, 6.23722e-07_r8, 6.30839e-07_r8, &
     & 6.38038e-07_r8, 6.45320e-07_r8, 6.52684e-07_r8, 6.60132e-07_r8, 6.67665e-07_r8, &
     & 6.75284e-07_r8, 6.82991e-07_r8, 6.90785e-07_r8, 6.98668e-07_r8, 7.06641e-07_r8, &
     & 7.14705e-07_r8, 7.22861e-07_r8, 7.31110e-07_r8, 7.39453e-07_r8/)
       kao_mn2( 1, :, 6) = (/ &
     & 1.13692e-06_r8, 1.13231e-06_r8, 1.12772e-06_r8, 1.12315e-06_r8, 1.11859e-06_r8, &
     & 1.11406e-06_r8, 1.10954e-06_r8, 1.10505e-06_r8, 1.10057e-06_r8, 1.09610e-06_r8, &
     & 1.09166e-06_r8, 1.08724e-06_r8, 1.08283e-06_r8, 1.07844e-06_r8, 1.07407e-06_r8, &
     & 1.06971e-06_r8, 1.06538e-06_r8, 1.06106e-06_r8, 1.05676e-06_r8/)
       kao_mn2( 2, :, 6) = (/ &
     & 1.13682e-06_r8, 1.13221e-06_r8, 1.12762e-06_r8, 1.12305e-06_r8, 1.11849e-06_r8, &
     & 1.11396e-06_r8, 1.10944e-06_r8, 1.10495e-06_r8, 1.10047e-06_r8, 1.09600e-06_r8, &
     & 1.09156e-06_r8, 1.08714e-06_r8, 1.08273e-06_r8, 1.07834e-06_r8, 1.07397e-06_r8, &
     & 1.06961e-06_r8, 1.06528e-06_r8, 1.06096e-06_r8, 1.05666e-06_r8/)
       kao_mn2( 3, :, 6) = (/ &
     & 1.13642e-06_r8, 1.13181e-06_r8, 1.12722e-06_r8, 1.12265e-06_r8, 1.11809e-06_r8, &
     & 1.11356e-06_r8, 1.10904e-06_r8, 1.10455e-06_r8, 1.10007e-06_r8, 1.09560e-06_r8, &
     & 1.09116e-06_r8, 1.08674e-06_r8, 1.08233e-06_r8, 1.07794e-06_r8, 1.07357e-06_r8, &
     & 1.06921e-06_r8, 1.06488e-06_r8, 1.06056e-06_r8, 1.05626e-06_r8/)
       kao_mn2( 4, :, 6) = (/ &
     & 1.13626e-06_r8, 1.13160e-06_r8, 1.12696e-06_r8, 1.12233e-06_r8, 1.11773e-06_r8, &
     & 1.11314e-06_r8, 1.10858e-06_r8, 1.10403e-06_r8, 1.09950e-06_r8, 1.09498e-06_r8, &
     & 1.09049e-06_r8, 1.08602e-06_r8, 1.08156e-06_r8, 1.07712e-06_r8, 1.07270e-06_r8, &
     & 1.06830e-06_r8, 1.06392e-06_r8, 1.05955e-06_r8, 1.05520e-06_r8/)
       kao_mn2( 5, :, 6) = (/ &
     & 1.22429e-06_r8, 1.21163e-06_r8, 1.19909e-06_r8, 1.18669e-06_r8, 1.17441e-06_r8, &
     & 1.16226e-06_r8, 1.15024e-06_r8, 1.13834e-06_r8, 1.12656e-06_r8, 1.11491e-06_r8, &
     & 1.10338e-06_r8, 1.09196e-06_r8, 1.08067e-06_r8, 1.06949e-06_r8, 1.05842e-06_r8, &
     & 1.04747e-06_r8, 1.03664e-06_r8, 1.02591e-06_r8, 1.01530e-06_r8/)
       kao_mn2( 6, :, 6) = (/ &
     & 1.02400e-06_r8, 1.02238e-06_r8, 1.02077e-06_r8, 1.01916e-06_r8, 1.01755e-06_r8, &
     & 1.01594e-06_r8, 1.01433e-06_r8, 1.01273e-06_r8, 1.01113e-06_r8, 1.00953e-06_r8, &
     & 1.00794e-06_r8, 1.00635e-06_r8, 1.00476e-06_r8, 1.00317e-06_r8, 1.00159e-06_r8, &
     & 1.00000e-06_r8, 9.98425e-07_r8, 9.96848e-07_r8, 9.95273e-07_r8/)
       kao_mn2( 7, :, 6) = (/ &
     & 1.08594e-06_r8, 1.08185e-06_r8, 1.07778e-06_r8, 1.07373e-06_r8, 1.06969e-06_r8, &
     & 1.06566e-06_r8, 1.06165e-06_r8, 1.05766e-06_r8, 1.05368e-06_r8, 1.04971e-06_r8, &
     & 1.04576e-06_r8, 1.04183e-06_r8, 1.03791e-06_r8, 1.03400e-06_r8, 1.03011e-06_r8, &
     & 1.02623e-06_r8, 1.02237e-06_r8, 1.01852e-06_r8, 1.01469e-06_r8/)
       kao_mn2( 8, :, 6) = (/ &
     & 1.25029e-06_r8, 1.22508e-06_r8, 1.20038e-06_r8, 1.17618e-06_r8, 1.15247e-06_r8, &
     & 1.12924e-06_r8, 1.10647e-06_r8, 1.08416e-06_r8, 1.06231e-06_r8, 1.04089e-06_r8, &
     & 1.01990e-06_r8, 9.99343e-07_r8, 9.79196e-07_r8, 9.59454e-07_r8, 9.40111e-07_r8, &
     & 9.21158e-07_r8, 9.02587e-07_r8, 8.84390e-07_r8, 8.66560e-07_r8/)
       kao_mn2( 9, :, 6) = (/ &
     & 1.21299e-06_r8, 1.19953e-06_r8, 1.18622e-06_r8, 1.17305e-06_r8, 1.16003e-06_r8, &
     & 1.14716e-06_r8, 1.13443e-06_r8, 1.12184e-06_r8, 1.10939e-06_r8, 1.09708e-06_r8, &
     & 1.08491e-06_r8, 1.07287e-06_r8, 1.06096e-06_r8, 1.04919e-06_r8, 1.03755e-06_r8, &
     & 1.02603e-06_r8, 1.01465e-06_r8, 1.00339e-06_r8, 9.92253e-07_r8/)
       kao_mn2( 1, :, 7) = (/ &
     & 1.53893e-06_r8, 1.51743e-06_r8, 1.49623e-06_r8, 1.47532e-06_r8, 1.45471e-06_r8, &
     & 1.43438e-06_r8, 1.41434e-06_r8, 1.39458e-06_r8, 1.37509e-06_r8, 1.35588e-06_r8, &
     & 1.33694e-06_r8, 1.31826e-06_r8, 1.29984e-06_r8, 1.28167e-06_r8, 1.26377e-06_r8, &
     & 1.24611e-06_r8, 1.22870e-06_r8, 1.21153e-06_r8, 1.19460e-06_r8/)
       kao_mn2( 2, :, 7) = (/ &
     & 1.53809e-06_r8, 1.51665e-06_r8, 1.49552e-06_r8, 1.47467e-06_r8, 1.45412e-06_r8, &
     & 1.43386e-06_r8, 1.41388e-06_r8, 1.39418e-06_r8, 1.37475e-06_r8, 1.35559e-06_r8, &
     & 1.33670e-06_r8, 1.31807e-06_r8, 1.29970e-06_r8, 1.28159e-06_r8, 1.26373e-06_r8, &
     & 1.24612e-06_r8, 1.22875e-06_r8, 1.21163e-06_r8, 1.19475e-06_r8/)
       kao_mn2( 3, :, 7) = (/ &
     & 1.53883e-06_r8, 1.51733e-06_r8, 1.49613e-06_r8, 1.47522e-06_r8, 1.45461e-06_r8, &
     & 1.43428e-06_r8, 1.41424e-06_r8, 1.39448e-06_r8, 1.37499e-06_r8, 1.35578e-06_r8, &
     & 1.33684e-06_r8, 1.31816e-06_r8, 1.29974e-06_r8, 1.28157e-06_r8, 1.26367e-06_r8, &
     & 1.24601e-06_r8, 1.22860e-06_r8, 1.21143e-06_r8, 1.19450e-06_r8/)
       kao_mn2( 4, :, 7) = (/ &
     & 1.53789e-06_r8, 1.51645e-06_r8, 1.49532e-06_r8, 1.47448e-06_r8, 1.45393e-06_r8, &
     & 1.43366e-06_r8, 1.41368e-06_r8, 1.39398e-06_r8, 1.37455e-06_r8, 1.35539e-06_r8, &
     & 1.33650e-06_r8, 1.31787e-06_r8, 1.29950e-06_r8, 1.28139e-06_r8, 1.26353e-06_r8, &
     & 1.24592e-06_r8, 1.22856e-06_r8, 1.21143e-06_r8, 1.19455e-06_r8/)
       kao_mn2( 5, :, 7) = (/ &
     & 1.54059e-06_r8, 1.51888e-06_r8, 1.49747e-06_r8, 1.47637e-06_r8, 1.45557e-06_r8, &
     & 1.43505e-06_r8, 1.41483e-06_r8, 1.39489e-06_r8, 1.37523e-06_r8, 1.35585e-06_r8, &
     & 1.33675e-06_r8, 1.31791e-06_r8, 1.29934e-06_r8, 1.28103e-06_r8, 1.26297e-06_r8, &
     & 1.24517e-06_r8, 1.22763e-06_r8, 1.21033e-06_r8, 1.19327e-06_r8/)
       kao_mn2( 6, :, 7) = (/ &
     & 1.70605e-06_r8, 1.65759e-06_r8, 1.61052e-06_r8, 1.56478e-06_r8, 1.52034e-06_r8, &
     & 1.47716e-06_r8, 1.43521e-06_r8, 1.39445e-06_r8, 1.35485e-06_r8, 1.31637e-06_r8, &
     & 1.27898e-06_r8, 1.24266e-06_r8, 1.20737e-06_r8, 1.17308e-06_r8, 1.13976e-06_r8, &
     & 1.10739e-06_r8, 1.07594e-06_r8, 1.04539e-06_r8, 1.01570e-06_r8/)
       kao_mn2( 7, :, 7) = (/ &
     & 1.39128e-06_r8, 1.36388e-06_r8, 1.33702e-06_r8, 1.31068e-06_r8, 1.28487e-06_r8, &
     & 1.25956e-06_r8, 1.23475e-06_r8, 1.21044e-06_r8, 1.18659e-06_r8, 1.16322e-06_r8, &
     & 1.14031e-06_r8, 1.11785e-06_r8, 1.09584e-06_r8, 1.07425e-06_r8, 1.05309e-06_r8, &
     & 1.03235e-06_r8, 1.01202e-06_r8, 9.92088e-07_r8, 9.72548e-07_r8/)
       kao_mn2( 8, :, 7) = (/ &
     & 1.15676e-06_r8, 1.13709e-06_r8, 1.11775e-06_r8, 1.09874e-06_r8, 1.08005e-06_r8, &
     & 1.06168e-06_r8, 1.04362e-06_r8, 1.02587e-06_r8, 1.00842e-06_r8, 9.91271e-07_r8, &
     & 9.74411e-07_r8, 9.57838e-07_r8, 9.41547e-07_r8, 9.25532e-07_r8, 9.09791e-07_r8, &
     & 8.94316e-07_r8, 8.79105e-07_r8, 8.64153e-07_r8, 8.49455e-07_r8/)
       kao_mn2( 9, :, 7) = (/ &
     & 1.53483e-06_r8, 1.51352e-06_r8, 1.49252e-06_r8, 1.47180e-06_r8, 1.45138e-06_r8, &
     & 1.43123e-06_r8, 1.41137e-06_r8, 1.39178e-06_r8, 1.37246e-06_r8, 1.35341e-06_r8, &
     & 1.33463e-06_r8, 1.31610e-06_r8, 1.29784e-06_r8, 1.27982e-06_r8, 1.26206e-06_r8, &
     & 1.24454e-06_r8, 1.22727e-06_r8, 1.21024e-06_r8, 1.19344e-06_r8/)
       kao_mn2( 1, :, 8) = (/ &
     & 1.70380e-06_r8, 1.67470e-06_r8, 1.64609e-06_r8, 1.61796e-06_r8, 1.59032e-06_r8, &
     & 1.56315e-06_r8, 1.53645e-06_r8, 1.51020e-06_r8, 1.48440e-06_r8, 1.45904e-06_r8, &
     & 1.43411e-06_r8, 1.40961e-06_r8, 1.38553e-06_r8, 1.36186e-06_r8, 1.33859e-06_r8, &
     & 1.31572e-06_r8, 1.29324e-06_r8, 1.27115e-06_r8, 1.24943e-06_r8/)
       kao_mn2( 2, :, 8) = (/ &
     & 1.70380e-06_r8, 1.67470e-06_r8, 1.64609e-06_r8, 1.61796e-06_r8, 1.59032e-06_r8, &
     & 1.56315e-06_r8, 1.53645e-06_r8, 1.51020e-06_r8, 1.48440e-06_r8, 1.45904e-06_r8, &
     & 1.43411e-06_r8, 1.40961e-06_r8, 1.38553e-06_r8, 1.36186e-06_r8, 1.33859e-06_r8, &
     & 1.31572e-06_r8, 1.29324e-06_r8, 1.27115e-06_r8, 1.24943e-06_r8/)
       kao_mn2( 3, :, 8) = (/ &
     & 1.70380e-06_r8, 1.67470e-06_r8, 1.64609e-06_r8, 1.61796e-06_r8, 1.59032e-06_r8, &
     & 1.56315e-06_r8, 1.53645e-06_r8, 1.51020e-06_r8, 1.48440e-06_r8, 1.45904e-06_r8, &
     & 1.43411e-06_r8, 1.40961e-06_r8, 1.38553e-06_r8, 1.36186e-06_r8, 1.33859e-06_r8, &
     & 1.31572e-06_r8, 1.29324e-06_r8, 1.27115e-06_r8, 1.24943e-06_r8/)
       kao_mn2( 4, :, 8) = (/ &
     & 1.70380e-06_r8, 1.67470e-06_r8, 1.64609e-06_r8, 1.61796e-06_r8, 1.59032e-06_r8, &
     & 1.56315e-06_r8, 1.53645e-06_r8, 1.51020e-06_r8, 1.48440e-06_r8, 1.45904e-06_r8, &
     & 1.43411e-06_r8, 1.40961e-06_r8, 1.38553e-06_r8, 1.36186e-06_r8, 1.33859e-06_r8, &
     & 1.31572e-06_r8, 1.29324e-06_r8, 1.27115e-06_r8, 1.24943e-06_r8/)
       kao_mn2( 5, :, 8) = (/ &
     & 1.70380e-06_r8, 1.67470e-06_r8, 1.64609e-06_r8, 1.61796e-06_r8, 1.59032e-06_r8, &
     & 1.56315e-06_r8, 1.53645e-06_r8, 1.51020e-06_r8, 1.48440e-06_r8, 1.45904e-06_r8, &
     & 1.43411e-06_r8, 1.40961e-06_r8, 1.38553e-06_r8, 1.36186e-06_r8, 1.33859e-06_r8, &
     & 1.31572e-06_r8, 1.29324e-06_r8, 1.27115e-06_r8, 1.24943e-06_r8/)
       kao_mn2( 6, :, 8) = (/ &
     & 1.70380e-06_r8, 1.67470e-06_r8, 1.64609e-06_r8, 1.61796e-06_r8, 1.59032e-06_r8, &
     & 1.56315e-06_r8, 1.53645e-06_r8, 1.51020e-06_r8, 1.48440e-06_r8, 1.45904e-06_r8, &
     & 1.43411e-06_r8, 1.40961e-06_r8, 1.38553e-06_r8, 1.36186e-06_r8, 1.33859e-06_r8, &
     & 1.31572e-06_r8, 1.29324e-06_r8, 1.27115e-06_r8, 1.24943e-06_r8/)
       kao_mn2( 7, :, 8) = (/ &
     & 1.71827e-06_r8, 1.65481e-06_r8, 1.59370e-06_r8, 1.53484e-06_r8, 1.47816e-06_r8, &
     & 1.42357e-06_r8, 1.37099e-06_r8, 1.32036e-06_r8, 1.27160e-06_r8, 1.22464e-06_r8, &
     & 1.17941e-06_r8, 1.13585e-06_r8, 1.09390e-06_r8, 1.05350e-06_r8, 1.01459e-06_r8, &
     & 9.77124e-07_r8, 9.41037e-07_r8, 9.06284e-07_r8, 8.72813e-07_r8/)
       kao_mn2( 8, :, 8) = (/ &
     & 1.77169e-06_r8, 1.62858e-06_r8, 1.49703e-06_r8, 1.37610e-06_r8, 1.26494e-06_r8, &
     & 1.16276e-06_r8, 1.06883e-06_r8, 9.82495e-07_r8, 9.03131e-07_r8, 8.30177e-07_r8, &
     & 7.63117e-07_r8, 7.01473e-07_r8, 6.44810e-07_r8, 5.92723e-07_r8, 5.44844e-07_r8, &
     & 5.00832e-07_r8, 4.60376e-07_r8, 4.23187e-07_r8, 3.89003e-07_r8/)
       kao_mn2( 9, :, 8) = (/ &
     & 1.70025e-06_r8, 1.67042e-06_r8, 1.64110e-06_r8, 1.61231e-06_r8, 1.58401e-06_r8, &
     & 1.55622e-06_r8, 1.52891e-06_r8, 1.50208e-06_r8, 1.47572e-06_r8, 1.44982e-06_r8, &
     & 1.42438e-06_r8, 1.39939e-06_r8, 1.37483e-06_r8, 1.35071e-06_r8, 1.32700e-06_r8, &
     & 1.30372e-06_r8, 1.28084e-06_r8, 1.25836e-06_r8, 1.23628e-06_r8/)
       kao_mn2( 1, :, 9) = (/ &
     & 1.74004e-06_r8, 1.70661e-06_r8, 1.67383e-06_r8, 1.64167e-06_r8, 1.61014e-06_r8, &
     & 1.57921e-06_r8, 1.54887e-06_r8, 1.51912e-06_r8, 1.48994e-06_r8, 1.46132e-06_r8, &
     & 1.43325e-06_r8, 1.40572e-06_r8, 1.37871e-06_r8, 1.35223e-06_r8, 1.32625e-06_r8, &
     & 1.30078e-06_r8, 1.27579e-06_r8, 1.25128e-06_r8, 1.22725e-06_r8/)
       kao_mn2( 2, :, 9) = (/ &
     & 1.74004e-06_r8, 1.70661e-06_r8, 1.67383e-06_r8, 1.64167e-06_r8, 1.61014e-06_r8, &
     & 1.57921e-06_r8, 1.54887e-06_r8, 1.51912e-06_r8, 1.48994e-06_r8, 1.46132e-06_r8, &
     & 1.43325e-06_r8, 1.40572e-06_r8, 1.37871e-06_r8, 1.35223e-06_r8, 1.32625e-06_r8, &
     & 1.30078e-06_r8, 1.27579e-06_r8, 1.25128e-06_r8, 1.22725e-06_r8/)
       kao_mn2( 3, :, 9) = (/ &
     & 1.74004e-06_r8, 1.70661e-06_r8, 1.67383e-06_r8, 1.64167e-06_r8, 1.61014e-06_r8, &
     & 1.57921e-06_r8, 1.54887e-06_r8, 1.51912e-06_r8, 1.48994e-06_r8, 1.46132e-06_r8, &
     & 1.43325e-06_r8, 1.40572e-06_r8, 1.37871e-06_r8, 1.35223e-06_r8, 1.32625e-06_r8, &
     & 1.30078e-06_r8, 1.27579e-06_r8, 1.25128e-06_r8, 1.22725e-06_r8/)
       kao_mn2( 4, :, 9) = (/ &
     & 1.74004e-06_r8, 1.70661e-06_r8, 1.67383e-06_r8, 1.64167e-06_r8, 1.61014e-06_r8, &
     & 1.57921e-06_r8, 1.54887e-06_r8, 1.51912e-06_r8, 1.48994e-06_r8, 1.46132e-06_r8, &
     & 1.43325e-06_r8, 1.40572e-06_r8, 1.37871e-06_r8, 1.35223e-06_r8, 1.32625e-06_r8, &
     & 1.30078e-06_r8, 1.27579e-06_r8, 1.25128e-06_r8, 1.22725e-06_r8/)
       kao_mn2( 5, :, 9) = (/ &
     & 1.74004e-06_r8, 1.70661e-06_r8, 1.67383e-06_r8, 1.64167e-06_r8, 1.61014e-06_r8, &
     & 1.57921e-06_r8, 1.54887e-06_r8, 1.51912e-06_r8, 1.48994e-06_r8, 1.46132e-06_r8, &
     & 1.43325e-06_r8, 1.40572e-06_r8, 1.37871e-06_r8, 1.35223e-06_r8, 1.32625e-06_r8, &
     & 1.30078e-06_r8, 1.27579e-06_r8, 1.25128e-06_r8, 1.22725e-06_r8/)
       kao_mn2( 6, :, 9) = (/ &
     & 1.74004e-06_r8, 1.70661e-06_r8, 1.67383e-06_r8, 1.64167e-06_r8, 1.61014e-06_r8, &
     & 1.57921e-06_r8, 1.54887e-06_r8, 1.51912e-06_r8, 1.48994e-06_r8, 1.46132e-06_r8, &
     & 1.43325e-06_r8, 1.40572e-06_r8, 1.37871e-06_r8, 1.35223e-06_r8, 1.32625e-06_r8, &
     & 1.30078e-06_r8, 1.27579e-06_r8, 1.25128e-06_r8, 1.22725e-06_r8/)
       kao_mn2( 7, :, 9) = (/ &
     & 1.74004e-06_r8, 1.70661e-06_r8, 1.67383e-06_r8, 1.64167e-06_r8, 1.61014e-06_r8, &
     & 1.57921e-06_r8, 1.54887e-06_r8, 1.51912e-06_r8, 1.48994e-06_r8, 1.46132e-06_r8, &
     & 1.43325e-06_r8, 1.40572e-06_r8, 1.37871e-06_r8, 1.35223e-06_r8, 1.32625e-06_r8, &
     & 1.30078e-06_r8, 1.27579e-06_r8, 1.25128e-06_r8, 1.22725e-06_r8/)
       kao_mn2( 8, :, 9) = (/ &
     & 1.08654e-06_r8, 1.09039e-06_r8, 1.09425e-06_r8, 1.09812e-06_r8, 1.10201e-06_r8, &
     & 1.10592e-06_r8, 1.10983e-06_r8, 1.11376e-06_r8, 1.11771e-06_r8, 1.12167e-06_r8, &
     & 1.12564e-06_r8, 1.12962e-06_r8, 1.13363e-06_r8, 1.13764e-06_r8, 1.14167e-06_r8, &
     & 1.14571e-06_r8, 1.14977e-06_r8, 1.15384e-06_r8, 1.15793e-06_r8/)
       kao_mn2( 9, :, 9) = (/ &
     & 1.74382e-06_r8, 1.71092e-06_r8, 1.67864e-06_r8, 1.64697e-06_r8, 1.61589e-06_r8, &
     & 1.58541e-06_r8, 1.55549e-06_r8, 1.52615e-06_r8, 1.49735e-06_r8, 1.46910e-06_r8, &
     & 1.44138e-06_r8, 1.41419e-06_r8, 1.38751e-06_r8, 1.36133e-06_r8, 1.33564e-06_r8, &
     & 1.31045e-06_r8, 1.28572e-06_r8, 1.26146e-06_r8, 1.23766e-06_r8/)
       kao_mn2( 1, :,10) = (/ &
     & 1.73703e-06_r8, 1.70249e-06_r8, 1.66863e-06_r8, 1.63544e-06_r8, 1.60292e-06_r8, &
     & 1.57104e-06_r8, 1.53980e-06_r8, 1.50917e-06_r8, 1.47916e-06_r8, 1.44974e-06_r8, &
     & 1.42091e-06_r8, 1.39265e-06_r8, 1.36496e-06_r8, 1.33781e-06_r8, 1.31121e-06_r8, &
     & 1.28513e-06_r8, 1.25957e-06_r8, 1.23452e-06_r8, 1.20997e-06_r8/)
       kao_mn2( 2, :,10) = (/ &
     & 1.73703e-06_r8, 1.70249e-06_r8, 1.66863e-06_r8, 1.63544e-06_r8, 1.60292e-06_r8, &
     & 1.57104e-06_r8, 1.53980e-06_r8, 1.50917e-06_r8, 1.47916e-06_r8, 1.44974e-06_r8, &
     & 1.42091e-06_r8, 1.39265e-06_r8, 1.36496e-06_r8, 1.33781e-06_r8, 1.31121e-06_r8, &
     & 1.28513e-06_r8, 1.25957e-06_r8, 1.23452e-06_r8, 1.20997e-06_r8/)
       kao_mn2( 3, :,10) = (/ &
     & 1.73703e-06_r8, 1.70249e-06_r8, 1.66863e-06_r8, 1.63544e-06_r8, 1.60292e-06_r8, &
     & 1.57104e-06_r8, 1.53980e-06_r8, 1.50917e-06_r8, 1.47916e-06_r8, 1.44974e-06_r8, &
     & 1.42091e-06_r8, 1.39265e-06_r8, 1.36496e-06_r8, 1.33781e-06_r8, 1.31121e-06_r8, &
     & 1.28513e-06_r8, 1.25957e-06_r8, 1.23452e-06_r8, 1.20997e-06_r8/)
       kao_mn2( 4, :,10) = (/ &
     & 1.73703e-06_r8, 1.70249e-06_r8, 1.66863e-06_r8, 1.63544e-06_r8, 1.60292e-06_r8, &
     & 1.57104e-06_r8, 1.53980e-06_r8, 1.50917e-06_r8, 1.47916e-06_r8, 1.44974e-06_r8, &
     & 1.42091e-06_r8, 1.39265e-06_r8, 1.36496e-06_r8, 1.33781e-06_r8, 1.31121e-06_r8, &
     & 1.28513e-06_r8, 1.25957e-06_r8, 1.23452e-06_r8, 1.20997e-06_r8/)
       kao_mn2( 5, :,10) = (/ &
     & 1.73703e-06_r8, 1.70249e-06_r8, 1.66863e-06_r8, 1.63544e-06_r8, 1.60292e-06_r8, &
     & 1.57104e-06_r8, 1.53980e-06_r8, 1.50917e-06_r8, 1.47916e-06_r8, 1.44974e-06_r8, &
     & 1.42091e-06_r8, 1.39265e-06_r8, 1.36496e-06_r8, 1.33781e-06_r8, 1.31121e-06_r8, &
     & 1.28513e-06_r8, 1.25957e-06_r8, 1.23452e-06_r8, 1.20997e-06_r8/)
       kao_mn2( 6, :,10) = (/ &
     & 1.73703e-06_r8, 1.70249e-06_r8, 1.66863e-06_r8, 1.63544e-06_r8, 1.60292e-06_r8, &
     & 1.57104e-06_r8, 1.53980e-06_r8, 1.50917e-06_r8, 1.47916e-06_r8, 1.44974e-06_r8, &
     & 1.42091e-06_r8, 1.39265e-06_r8, 1.36496e-06_r8, 1.33781e-06_r8, 1.31121e-06_r8, &
     & 1.28513e-06_r8, 1.25957e-06_r8, 1.23452e-06_r8, 1.20997e-06_r8/)
       kao_mn2( 7, :,10) = (/ &
     & 1.73703e-06_r8, 1.70249e-06_r8, 1.66863e-06_r8, 1.63544e-06_r8, 1.60292e-06_r8, &
     & 1.57104e-06_r8, 1.53980e-06_r8, 1.50917e-06_r8, 1.47916e-06_r8, 1.44974e-06_r8, &
     & 1.42091e-06_r8, 1.39265e-06_r8, 1.36496e-06_r8, 1.33781e-06_r8, 1.31121e-06_r8, &
     & 1.28513e-06_r8, 1.25957e-06_r8, 1.23452e-06_r8, 1.20997e-06_r8/)
       kao_mn2( 8, :,10) = (/ &
     & 1.73703e-06_r8, 1.70249e-06_r8, 1.66863e-06_r8, 1.63544e-06_r8, 1.60292e-06_r8, &
     & 1.57104e-06_r8, 1.53980e-06_r8, 1.50917e-06_r8, 1.47916e-06_r8, 1.44974e-06_r8, &
     & 1.42091e-06_r8, 1.39265e-06_r8, 1.36496e-06_r8, 1.33781e-06_r8, 1.31121e-06_r8, &
     & 1.28513e-06_r8, 1.25957e-06_r8, 1.23452e-06_r8, 1.20997e-06_r8/)
       kao_mn2( 9, :,10) = (/ &
     & 1.82903e-06_r8, 1.78673e-06_r8, 1.74541e-06_r8, 1.70505e-06_r8, 1.66562e-06_r8, &
     & 1.62710e-06_r8, 1.58947e-06_r8, 1.55271e-06_r8, 1.51680e-06_r8, 1.48172e-06_r8, &
     & 1.44745e-06_r8, 1.41398e-06_r8, 1.38128e-06_r8, 1.34933e-06_r8, 1.31813e-06_r8, &
     & 1.28765e-06_r8, 1.25787e-06_r8, 1.22878e-06_r8, 1.20036e-06_r8/)
       kao_mn2( 1, :,11) = (/ &
     & 1.73118e-06_r8, 1.69710e-06_r8, 1.66370e-06_r8, 1.63095e-06_r8, 1.59885e-06_r8, &
     & 1.56737e-06_r8, 1.53652e-06_r8, 1.50628e-06_r8, 1.47663e-06_r8, 1.44756e-06_r8, &
     & 1.41907e-06_r8, 1.39114e-06_r8, 1.36376e-06_r8, 1.33691e-06_r8, 1.31060e-06_r8, &
     & 1.28480e-06_r8, 1.25951e-06_r8, 1.23472e-06_r8, 1.21041e-06_r8/)
       kao_mn2( 2, :,11) = (/ &
     & 1.73118e-06_r8, 1.69710e-06_r8, 1.66370e-06_r8, 1.63095e-06_r8, 1.59885e-06_r8, &
     & 1.56737e-06_r8, 1.53652e-06_r8, 1.50628e-06_r8, 1.47663e-06_r8, 1.44756e-06_r8, &
     & 1.41907e-06_r8, 1.39114e-06_r8, 1.36376e-06_r8, 1.33691e-06_r8, 1.31060e-06_r8, &
     & 1.28480e-06_r8, 1.25951e-06_r8, 1.23472e-06_r8, 1.21041e-06_r8/)
       kao_mn2( 3, :,11) = (/ &
     & 1.73118e-06_r8, 1.69710e-06_r8, 1.66370e-06_r8, 1.63095e-06_r8, 1.59885e-06_r8, &
     & 1.56737e-06_r8, 1.53652e-06_r8, 1.50628e-06_r8, 1.47663e-06_r8, 1.44756e-06_r8, &
     & 1.41907e-06_r8, 1.39114e-06_r8, 1.36376e-06_r8, 1.33691e-06_r8, 1.31060e-06_r8, &
     & 1.28480e-06_r8, 1.25951e-06_r8, 1.23472e-06_r8, 1.21041e-06_r8/)
       kao_mn2( 4, :,11) = (/ &
     & 1.73118e-06_r8, 1.69710e-06_r8, 1.66370e-06_r8, 1.63095e-06_r8, 1.59885e-06_r8, &
     & 1.56737e-06_r8, 1.53652e-06_r8, 1.50628e-06_r8, 1.47663e-06_r8, 1.44756e-06_r8, &
     & 1.41907e-06_r8, 1.39114e-06_r8, 1.36376e-06_r8, 1.33691e-06_r8, 1.31060e-06_r8, &
     & 1.28480e-06_r8, 1.25951e-06_r8, 1.23472e-06_r8, 1.21041e-06_r8/)
       kao_mn2( 5, :,11) = (/ &
     & 1.73118e-06_r8, 1.69710e-06_r8, 1.66370e-06_r8, 1.63095e-06_r8, 1.59885e-06_r8, &
     & 1.56737e-06_r8, 1.53652e-06_r8, 1.50628e-06_r8, 1.47663e-06_r8, 1.44756e-06_r8, &
     & 1.41907e-06_r8, 1.39114e-06_r8, 1.36376e-06_r8, 1.33691e-06_r8, 1.31060e-06_r8, &
     & 1.28480e-06_r8, 1.25951e-06_r8, 1.23472e-06_r8, 1.21041e-06_r8/)
       kao_mn2( 6, :,11) = (/ &
     & 1.73118e-06_r8, 1.69710e-06_r8, 1.66370e-06_r8, 1.63095e-06_r8, 1.59885e-06_r8, &
     & 1.56737e-06_r8, 1.53652e-06_r8, 1.50628e-06_r8, 1.47663e-06_r8, 1.44756e-06_r8, &
     & 1.41907e-06_r8, 1.39114e-06_r8, 1.36376e-06_r8, 1.33691e-06_r8, 1.31060e-06_r8, &
     & 1.28480e-06_r8, 1.25951e-06_r8, 1.23472e-06_r8, 1.21041e-06_r8/)
       kao_mn2( 7, :,11) = (/ &
     & 1.73118e-06_r8, 1.69710e-06_r8, 1.66370e-06_r8, 1.63095e-06_r8, 1.59885e-06_r8, &
     & 1.56737e-06_r8, 1.53652e-06_r8, 1.50628e-06_r8, 1.47663e-06_r8, 1.44756e-06_r8, &
     & 1.41907e-06_r8, 1.39114e-06_r8, 1.36376e-06_r8, 1.33691e-06_r8, 1.31060e-06_r8, &
     & 1.28480e-06_r8, 1.25951e-06_r8, 1.23472e-06_r8, 1.21041e-06_r8/)
       kao_mn2( 8, :,11) = (/ &
     & 1.73118e-06_r8, 1.69710e-06_r8, 1.66370e-06_r8, 1.63095e-06_r8, 1.59885e-06_r8, &
     & 1.56737e-06_r8, 1.53652e-06_r8, 1.50628e-06_r8, 1.47663e-06_r8, 1.44756e-06_r8, &
     & 1.41907e-06_r8, 1.39114e-06_r8, 1.36376e-06_r8, 1.33691e-06_r8, 1.31060e-06_r8, &
     & 1.28480e-06_r8, 1.25951e-06_r8, 1.23472e-06_r8, 1.21041e-06_r8/)
       kao_mn2( 9, :,11) = (/ &
     & 1.81037e-06_r8, 1.76948e-06_r8, 1.72952e-06_r8, 1.69045e-06_r8, 1.65228e-06_r8, &
     & 1.61496e-06_r8, 1.57848e-06_r8, 1.54283e-06_r8, 1.50799e-06_r8, 1.47393e-06_r8, &
     & 1.44064e-06_r8, 1.40810e-06_r8, 1.37630e-06_r8, 1.34522e-06_r8, 1.31484e-06_r8, &
     & 1.28514e-06_r8, 1.25611e-06_r8, 1.22774e-06_r8, 1.20002e-06_r8/)
       kao_mn2( 1, :,12) = (/ &
     & 1.73338e-06_r8, 1.69915e-06_r8, 1.66560e-06_r8, 1.63271e-06_r8, 1.60046e-06_r8, &
     & 1.56886e-06_r8, 1.53788e-06_r8, 1.50751e-06_r8, 1.47774e-06_r8, 1.44856e-06_r8, &
     & 1.41995e-06_r8, 1.39191e-06_r8, 1.36442e-06_r8, 1.33748e-06_r8, 1.31107e-06_r8, &
     & 1.28518e-06_r8, 1.25980e-06_r8, 1.23492e-06_r8, 1.21053e-06_r8/)
       kao_mn2( 2, :,12) = (/ &
     & 1.73338e-06_r8, 1.69915e-06_r8, 1.66560e-06_r8, 1.63271e-06_r8, 1.60046e-06_r8, &
     & 1.56886e-06_r8, 1.53788e-06_r8, 1.50751e-06_r8, 1.47774e-06_r8, 1.44856e-06_r8, &
     & 1.41995e-06_r8, 1.39191e-06_r8, 1.36442e-06_r8, 1.33748e-06_r8, 1.31107e-06_r8, &
     & 1.28518e-06_r8, 1.25980e-06_r8, 1.23492e-06_r8, 1.21053e-06_r8/)
       kao_mn2( 3, :,12) = (/ &
     & 1.73338e-06_r8, 1.69915e-06_r8, 1.66560e-06_r8, 1.63271e-06_r8, 1.60046e-06_r8, &
     & 1.56886e-06_r8, 1.53788e-06_r8, 1.50751e-06_r8, 1.47774e-06_r8, 1.44856e-06_r8, &
     & 1.41995e-06_r8, 1.39191e-06_r8, 1.36442e-06_r8, 1.33748e-06_r8, 1.31107e-06_r8, &
     & 1.28518e-06_r8, 1.25980e-06_r8, 1.23492e-06_r8, 1.21053e-06_r8/)
       kao_mn2( 4, :,12) = (/ &
     & 1.73338e-06_r8, 1.69915e-06_r8, 1.66560e-06_r8, 1.63271e-06_r8, 1.60046e-06_r8, &
     & 1.56886e-06_r8, 1.53788e-06_r8, 1.50751e-06_r8, 1.47774e-06_r8, 1.44856e-06_r8, &
     & 1.41995e-06_r8, 1.39191e-06_r8, 1.36442e-06_r8, 1.33748e-06_r8, 1.31107e-06_r8, &
     & 1.28518e-06_r8, 1.25980e-06_r8, 1.23492e-06_r8, 1.21053e-06_r8/)
       kao_mn2( 5, :,12) = (/ &
     & 1.73338e-06_r8, 1.69915e-06_r8, 1.66560e-06_r8, 1.63271e-06_r8, 1.60046e-06_r8, &
     & 1.56886e-06_r8, 1.53788e-06_r8, 1.50751e-06_r8, 1.47774e-06_r8, 1.44856e-06_r8, &
     & 1.41995e-06_r8, 1.39191e-06_r8, 1.36442e-06_r8, 1.33748e-06_r8, 1.31107e-06_r8, &
     & 1.28518e-06_r8, 1.25980e-06_r8, 1.23492e-06_r8, 1.21053e-06_r8/)
       kao_mn2( 6, :,12) = (/ &
     & 1.73338e-06_r8, 1.69915e-06_r8, 1.66560e-06_r8, 1.63271e-06_r8, 1.60046e-06_r8, &
     & 1.56886e-06_r8, 1.53788e-06_r8, 1.50751e-06_r8, 1.47774e-06_r8, 1.44856e-06_r8, &
     & 1.41995e-06_r8, 1.39191e-06_r8, 1.36442e-06_r8, 1.33748e-06_r8, 1.31107e-06_r8, &
     & 1.28518e-06_r8, 1.25980e-06_r8, 1.23492e-06_r8, 1.21053e-06_r8/)
       kao_mn2( 7, :,12) = (/ &
     & 1.73338e-06_r8, 1.69915e-06_r8, 1.66560e-06_r8, 1.63271e-06_r8, 1.60046e-06_r8, &
     & 1.56886e-06_r8, 1.53788e-06_r8, 1.50751e-06_r8, 1.47774e-06_r8, 1.44856e-06_r8, &
     & 1.41995e-06_r8, 1.39191e-06_r8, 1.36442e-06_r8, 1.33748e-06_r8, 1.31107e-06_r8, &
     & 1.28518e-06_r8, 1.25980e-06_r8, 1.23492e-06_r8, 1.21053e-06_r8/)
       kao_mn2( 8, :,12) = (/ &
     & 1.73338e-06_r8, 1.69915e-06_r8, 1.66560e-06_r8, 1.63271e-06_r8, 1.60046e-06_r8, &
     & 1.56886e-06_r8, 1.53788e-06_r8, 1.50751e-06_r8, 1.47774e-06_r8, 1.44856e-06_r8, &
     & 1.41995e-06_r8, 1.39191e-06_r8, 1.36442e-06_r8, 1.33748e-06_r8, 1.31107e-06_r8, &
     & 1.28518e-06_r8, 1.25980e-06_r8, 1.23492e-06_r8, 1.21053e-06_r8/)
       kao_mn2( 9, :,12) = (/ &
     & 2.04857e-06_r8, 1.98353e-06_r8, 1.92055e-06_r8, 1.85957e-06_r8, 1.80053e-06_r8, &
     & 1.74336e-06_r8, 1.68800e-06_r8, 1.63441e-06_r8, 1.58251e-06_r8, 1.53227e-06_r8, &
     & 1.48362e-06_r8, 1.43651e-06_r8, 1.39090e-06_r8, 1.34674e-06_r8, 1.30398e-06_r8, &
     & 1.26257e-06_r8, 1.22249e-06_r8, 1.18367e-06_r8, 1.14609e-06_r8/)
       kao_mn2( 1, :,13) = (/ &
     & 1.73511e-06_r8, 1.70072e-06_r8, 1.66702e-06_r8, 1.63398e-06_r8, 1.60159e-06_r8, &
     & 1.56985e-06_r8, 1.53874e-06_r8, 1.50824e-06_r8, 1.47835e-06_r8, 1.44905e-06_r8, &
     & 1.42033e-06_r8, 1.39218e-06_r8, 1.36459e-06_r8, 1.33755e-06_r8, 1.31104e-06_r8, &
     & 1.28505e-06_r8, 1.25958e-06_r8, 1.23462e-06_r8, 1.21015e-06_r8/)
       kao_mn2( 2, :,13) = (/ &
     & 1.73511e-06_r8, 1.70072e-06_r8, 1.66702e-06_r8, 1.63398e-06_r8, 1.60159e-06_r8, &
     & 1.56985e-06_r8, 1.53874e-06_r8, 1.50824e-06_r8, 1.47835e-06_r8, 1.44905e-06_r8, &
     & 1.42033e-06_r8, 1.39218e-06_r8, 1.36459e-06_r8, 1.33755e-06_r8, 1.31104e-06_r8, &
     & 1.28505e-06_r8, 1.25958e-06_r8, 1.23462e-06_r8, 1.21015e-06_r8/)
       kao_mn2( 3, :,13) = (/ &
     & 1.73511e-06_r8, 1.70072e-06_r8, 1.66702e-06_r8, 1.63398e-06_r8, 1.60159e-06_r8, &
     & 1.56985e-06_r8, 1.53874e-06_r8, 1.50824e-06_r8, 1.47835e-06_r8, 1.44905e-06_r8, &
     & 1.42033e-06_r8, 1.39218e-06_r8, 1.36459e-06_r8, 1.33755e-06_r8, 1.31104e-06_r8, &
     & 1.28505e-06_r8, 1.25958e-06_r8, 1.23462e-06_r8, 1.21015e-06_r8/)
       kao_mn2( 4, :,13) = (/ &
     & 1.73511e-06_r8, 1.70072e-06_r8, 1.66702e-06_r8, 1.63398e-06_r8, 1.60159e-06_r8, &
     & 1.56985e-06_r8, 1.53874e-06_r8, 1.50824e-06_r8, 1.47835e-06_r8, 1.44905e-06_r8, &
     & 1.42033e-06_r8, 1.39218e-06_r8, 1.36459e-06_r8, 1.33755e-06_r8, 1.31104e-06_r8, &
     & 1.28505e-06_r8, 1.25958e-06_r8, 1.23462e-06_r8, 1.21015e-06_r8/)
       kao_mn2( 5, :,13) = (/ &
     & 1.73511e-06_r8, 1.70072e-06_r8, 1.66702e-06_r8, 1.63398e-06_r8, 1.60159e-06_r8, &
     & 1.56985e-06_r8, 1.53874e-06_r8, 1.50824e-06_r8, 1.47835e-06_r8, 1.44905e-06_r8, &
     & 1.42033e-06_r8, 1.39218e-06_r8, 1.36459e-06_r8, 1.33755e-06_r8, 1.31104e-06_r8, &
     & 1.28505e-06_r8, 1.25958e-06_r8, 1.23462e-06_r8, 1.21015e-06_r8/)
       kao_mn2( 6, :,13) = (/ &
     & 1.73511e-06_r8, 1.70072e-06_r8, 1.66702e-06_r8, 1.63398e-06_r8, 1.60159e-06_r8, &
     & 1.56985e-06_r8, 1.53874e-06_r8, 1.50824e-06_r8, 1.47835e-06_r8, 1.44905e-06_r8, &
     & 1.42033e-06_r8, 1.39218e-06_r8, 1.36459e-06_r8, 1.33755e-06_r8, 1.31104e-06_r8, &
     & 1.28505e-06_r8, 1.25958e-06_r8, 1.23462e-06_r8, 1.21015e-06_r8/)
       kao_mn2( 7, :,13) = (/ &
     & 1.73511e-06_r8, 1.70072e-06_r8, 1.66702e-06_r8, 1.63398e-06_r8, 1.60159e-06_r8, &
     & 1.56985e-06_r8, 1.53874e-06_r8, 1.50824e-06_r8, 1.47835e-06_r8, 1.44905e-06_r8, &
     & 1.42033e-06_r8, 1.39218e-06_r8, 1.36459e-06_r8, 1.33755e-06_r8, 1.31104e-06_r8, &
     & 1.28505e-06_r8, 1.25958e-06_r8, 1.23462e-06_r8, 1.21015e-06_r8/)
       kao_mn2( 8, :,13) = (/ &
     & 1.73511e-06_r8, 1.70072e-06_r8, 1.66702e-06_r8, 1.63398e-06_r8, 1.60159e-06_r8, &
     & 1.56985e-06_r8, 1.53874e-06_r8, 1.50824e-06_r8, 1.47835e-06_r8, 1.44905e-06_r8, &
     & 1.42033e-06_r8, 1.39218e-06_r8, 1.36459e-06_r8, 1.33755e-06_r8, 1.31104e-06_r8, &
     & 1.28505e-06_r8, 1.25958e-06_r8, 1.23462e-06_r8, 1.21015e-06_r8/)
       kao_mn2( 9, :,13) = (/ &
     & 2.13403e-06_r8, 2.05906e-06_r8, 1.98673e-06_r8, 1.91694e-06_r8, 1.84961e-06_r8, &
     & 1.78463e-06_r8, 1.72194e-06_r8, 1.66145e-06_r8, 1.60309e-06_r8, 1.54678e-06_r8, &
     & 1.49244e-06_r8, 1.44002e-06_r8, 1.38943e-06_r8, 1.34062e-06_r8, 1.29353e-06_r8, &
     & 1.24809e-06_r8, 1.20425e-06_r8, 1.16195e-06_r8, 1.12113e-06_r8/)
       kao_mn2( 1, :,14) = (/ &
     & 1.73398e-06_r8, 1.69941e-06_r8, 1.66553e-06_r8, 1.63233e-06_r8, 1.59979e-06_r8, &
     & 1.56790e-06_r8, 1.53664e-06_r8, 1.50601e-06_r8, 1.47598e-06_r8, 1.44656e-06_r8, &
     & 1.41772e-06_r8, 1.38946e-06_r8, 1.36176e-06_r8, 1.33461e-06_r8, 1.30801e-06_r8, &
     & 1.28193e-06_r8, 1.25637e-06_r8, 1.23133e-06_r8, 1.20678e-06_r8/)
       kao_mn2( 2, :,14) = (/ &
     & 1.73398e-06_r8, 1.69941e-06_r8, 1.66553e-06_r8, 1.63233e-06_r8, 1.59979e-06_r8, &
     & 1.56790e-06_r8, 1.53664e-06_r8, 1.50601e-06_r8, 1.47598e-06_r8, 1.44656e-06_r8, &
     & 1.41772e-06_r8, 1.38946e-06_r8, 1.36176e-06_r8, 1.33461e-06_r8, 1.30801e-06_r8, &
     & 1.28193e-06_r8, 1.25637e-06_r8, 1.23133e-06_r8, 1.20678e-06_r8/)
       kao_mn2( 3, :,14) = (/ &
     & 1.73398e-06_r8, 1.69941e-06_r8, 1.66553e-06_r8, 1.63233e-06_r8, 1.59979e-06_r8, &
     & 1.56790e-06_r8, 1.53664e-06_r8, 1.50601e-06_r8, 1.47598e-06_r8, 1.44656e-06_r8, &
     & 1.41772e-06_r8, 1.38946e-06_r8, 1.36176e-06_r8, 1.33461e-06_r8, 1.30801e-06_r8, &
     & 1.28193e-06_r8, 1.25637e-06_r8, 1.23133e-06_r8, 1.20678e-06_r8/)
       kao_mn2( 4, :,14) = (/ &
     & 1.73398e-06_r8, 1.69941e-06_r8, 1.66553e-06_r8, 1.63233e-06_r8, 1.59979e-06_r8, &
     & 1.56790e-06_r8, 1.53664e-06_r8, 1.50601e-06_r8, 1.47598e-06_r8, 1.44656e-06_r8, &
     & 1.41772e-06_r8, 1.38946e-06_r8, 1.36176e-06_r8, 1.33461e-06_r8, 1.30801e-06_r8, &
     & 1.28193e-06_r8, 1.25637e-06_r8, 1.23133e-06_r8, 1.20678e-06_r8/)
       kao_mn2( 5, :,14) = (/ &
     & 1.73398e-06_r8, 1.69941e-06_r8, 1.66553e-06_r8, 1.63233e-06_r8, 1.59979e-06_r8, &
     & 1.56790e-06_r8, 1.53664e-06_r8, 1.50601e-06_r8, 1.47598e-06_r8, 1.44656e-06_r8, &
     & 1.41772e-06_r8, 1.38946e-06_r8, 1.36176e-06_r8, 1.33461e-06_r8, 1.30801e-06_r8, &
     & 1.28193e-06_r8, 1.25637e-06_r8, 1.23133e-06_r8, 1.20678e-06_r8/)
       kao_mn2( 6, :,14) = (/ &
     & 1.73398e-06_r8, 1.69941e-06_r8, 1.66553e-06_r8, 1.63233e-06_r8, 1.59979e-06_r8, &
     & 1.56790e-06_r8, 1.53664e-06_r8, 1.50601e-06_r8, 1.47598e-06_r8, 1.44656e-06_r8, &
     & 1.41772e-06_r8, 1.38946e-06_r8, 1.36176e-06_r8, 1.33461e-06_r8, 1.30801e-06_r8, &
     & 1.28193e-06_r8, 1.25637e-06_r8, 1.23133e-06_r8, 1.20678e-06_r8/)
       kao_mn2( 7, :,14) = (/ &
     & 1.73398e-06_r8, 1.69941e-06_r8, 1.66553e-06_r8, 1.63233e-06_r8, 1.59979e-06_r8, &
     & 1.56790e-06_r8, 1.53664e-06_r8, 1.50601e-06_r8, 1.47598e-06_r8, 1.44656e-06_r8, &
     & 1.41772e-06_r8, 1.38946e-06_r8, 1.36176e-06_r8, 1.33461e-06_r8, 1.30801e-06_r8, &
     & 1.28193e-06_r8, 1.25637e-06_r8, 1.23133e-06_r8, 1.20678e-06_r8/)
       kao_mn2( 8, :,14) = (/ &
     & 1.73398e-06_r8, 1.69941e-06_r8, 1.66553e-06_r8, 1.63233e-06_r8, 1.59979e-06_r8, &
     & 1.56790e-06_r8, 1.53664e-06_r8, 1.50601e-06_r8, 1.47598e-06_r8, 1.44656e-06_r8, &
     & 1.41772e-06_r8, 1.38946e-06_r8, 1.36176e-06_r8, 1.33461e-06_r8, 1.30801e-06_r8, &
     & 1.28193e-06_r8, 1.25637e-06_r8, 1.23133e-06_r8, 1.20678e-06_r8/)
       kao_mn2( 9, :,14) = (/ &
     & 1.83423e-06_r8, 1.79123e-06_r8, 1.74923e-06_r8, 1.70821e-06_r8, 1.66816e-06_r8, &
     & 1.62904e-06_r8, 1.59085e-06_r8, 1.55354e-06_r8, 1.51712e-06_r8, 1.48154e-06_r8, &
     & 1.44681e-06_r8, 1.41288e-06_r8, 1.37975e-06_r8, 1.34740e-06_r8, 1.31581e-06_r8, &
     & 1.28496e-06_r8, 1.25483e-06_r8, 1.22540e-06_r8, 1.19667e-06_r8/)
       kao_mn2( 1, :,15) = (/ &
     & 1.73231e-06_r8, 1.69765e-06_r8, 1.66368e-06_r8, 1.63039e-06_r8, 1.59776e-06_r8, &
     & 1.56579e-06_r8, 1.53445e-06_r8, 1.50375e-06_r8, 1.47366e-06_r8, 1.44417e-06_r8, &
     & 1.41527e-06_r8, 1.38695e-06_r8, 1.35919e-06_r8, 1.33199e-06_r8, 1.30534e-06_r8, &
     & 1.27922e-06_r8, 1.25362e-06_r8, 1.22853e-06_r8, 1.20395e-06_r8/)
       kao_mn2( 2, :,15) = (/ &
     & 1.73231e-06_r8, 1.69765e-06_r8, 1.66368e-06_r8, 1.63039e-06_r8, 1.59776e-06_r8, &
     & 1.56579e-06_r8, 1.53445e-06_r8, 1.50375e-06_r8, 1.47366e-06_r8, 1.44417e-06_r8, &
     & 1.41527e-06_r8, 1.38695e-06_r8, 1.35919e-06_r8, 1.33199e-06_r8, 1.30534e-06_r8, &
     & 1.27922e-06_r8, 1.25362e-06_r8, 1.22853e-06_r8, 1.20395e-06_r8/)
       kao_mn2( 3, :,15) = (/ &
     & 1.73231e-06_r8, 1.69765e-06_r8, 1.66368e-06_r8, 1.63039e-06_r8, 1.59776e-06_r8, &
     & 1.56579e-06_r8, 1.53445e-06_r8, 1.50375e-06_r8, 1.47366e-06_r8, 1.44417e-06_r8, &
     & 1.41527e-06_r8, 1.38695e-06_r8, 1.35919e-06_r8, 1.33199e-06_r8, 1.30534e-06_r8, &
     & 1.27922e-06_r8, 1.25362e-06_r8, 1.22853e-06_r8, 1.20395e-06_r8/)
       kao_mn2( 4, :,15) = (/ &
     & 1.73231e-06_r8, 1.69765e-06_r8, 1.66368e-06_r8, 1.63039e-06_r8, 1.59776e-06_r8, &
     & 1.56579e-06_r8, 1.53445e-06_r8, 1.50375e-06_r8, 1.47366e-06_r8, 1.44417e-06_r8, &
     & 1.41527e-06_r8, 1.38695e-06_r8, 1.35919e-06_r8, 1.33199e-06_r8, 1.30534e-06_r8, &
     & 1.27922e-06_r8, 1.25362e-06_r8, 1.22853e-06_r8, 1.20395e-06_r8/)
       kao_mn2( 5, :,15) = (/ &
     & 1.73231e-06_r8, 1.69765e-06_r8, 1.66368e-06_r8, 1.63039e-06_r8, 1.59776e-06_r8, &
     & 1.56579e-06_r8, 1.53445e-06_r8, 1.50375e-06_r8, 1.47366e-06_r8, 1.44417e-06_r8, &
     & 1.41527e-06_r8, 1.38695e-06_r8, 1.35919e-06_r8, 1.33199e-06_r8, 1.30534e-06_r8, &
     & 1.27922e-06_r8, 1.25362e-06_r8, 1.22853e-06_r8, 1.20395e-06_r8/)
       kao_mn2( 6, :,15) = (/ &
     & 1.73231e-06_r8, 1.69765e-06_r8, 1.66368e-06_r8, 1.63039e-06_r8, 1.59776e-06_r8, &
     & 1.56579e-06_r8, 1.53445e-06_r8, 1.50375e-06_r8, 1.47366e-06_r8, 1.44417e-06_r8, &
     & 1.41527e-06_r8, 1.38695e-06_r8, 1.35919e-06_r8, 1.33199e-06_r8, 1.30534e-06_r8, &
     & 1.27922e-06_r8, 1.25362e-06_r8, 1.22853e-06_r8, 1.20395e-06_r8/)
       kao_mn2( 7, :,15) = (/ &
     & 1.73231e-06_r8, 1.69765e-06_r8, 1.66368e-06_r8, 1.63039e-06_r8, 1.59776e-06_r8, &
     & 1.56579e-06_r8, 1.53445e-06_r8, 1.50375e-06_r8, 1.47366e-06_r8, 1.44417e-06_r8, &
     & 1.41527e-06_r8, 1.38695e-06_r8, 1.35919e-06_r8, 1.33199e-06_r8, 1.30534e-06_r8, &
     & 1.27922e-06_r8, 1.25362e-06_r8, 1.22853e-06_r8, 1.20395e-06_r8/)
       kao_mn2( 8, :,15) = (/ &
     & 1.73231e-06_r8, 1.69765e-06_r8, 1.66368e-06_r8, 1.63039e-06_r8, 1.59776e-06_r8, &
     & 1.56579e-06_r8, 1.53445e-06_r8, 1.50375e-06_r8, 1.47366e-06_r8, 1.44417e-06_r8, &
     & 1.41527e-06_r8, 1.38695e-06_r8, 1.35919e-06_r8, 1.33199e-06_r8, 1.30534e-06_r8, &
     & 1.27922e-06_r8, 1.25362e-06_r8, 1.22853e-06_r8, 1.20395e-06_r8/)
       kao_mn2( 9, :,15) = (/ &
     & 1.71602e-06_r8, 1.68499e-06_r8, 1.65452e-06_r8, 1.62461e-06_r8, 1.59523e-06_r8, &
     & 1.56639e-06_r8, 1.53807e-06_r8, 1.51026e-06_r8, 1.48295e-06_r8, 1.45614e-06_r8, &
     & 1.42981e-06_r8, 1.40395e-06_r8, 1.37857e-06_r8, 1.35364e-06_r8, 1.32917e-06_r8, &
     & 1.30513e-06_r8, 1.28153e-06_r8, 1.25836e-06_r8, 1.23561e-06_r8/)
       kao_mn2( 1, :,16) = (/ &
     & 1.73310e-06_r8, 1.69826e-06_r8, 1.66413e-06_r8, 1.63069e-06_r8, 1.59791e-06_r8, &
     & 1.56580e-06_r8, 1.53433e-06_r8, 1.50349e-06_r8, 1.47328e-06_r8, 1.44367e-06_r8, &
     & 1.41465e-06_r8, 1.38622e-06_r8, 1.35836e-06_r8, 1.33106e-06_r8, 1.30431e-06_r8, &
     & 1.27810e-06_r8, 1.25241e-06_r8, 1.22724e-06_r8, 1.20257e-06_r8/)
       kao_mn2( 2, :,16) = (/ &
     & 1.73310e-06_r8, 1.69826e-06_r8, 1.66413e-06_r8, 1.63069e-06_r8, 1.59791e-06_r8, &
     & 1.56580e-06_r8, 1.53433e-06_r8, 1.50349e-06_r8, 1.47328e-06_r8, 1.44367e-06_r8, &
     & 1.41465e-06_r8, 1.38622e-06_r8, 1.35836e-06_r8, 1.33106e-06_r8, 1.30431e-06_r8, &
     & 1.27810e-06_r8, 1.25241e-06_r8, 1.22724e-06_r8, 1.20257e-06_r8/)
       kao_mn2( 3, :,16) = (/ &
     & 1.73310e-06_r8, 1.69826e-06_r8, 1.66413e-06_r8, 1.63069e-06_r8, 1.59791e-06_r8, &
     & 1.56580e-06_r8, 1.53433e-06_r8, 1.50349e-06_r8, 1.47328e-06_r8, 1.44367e-06_r8, &
     & 1.41465e-06_r8, 1.38622e-06_r8, 1.35836e-06_r8, 1.33106e-06_r8, 1.30431e-06_r8, &
     & 1.27810e-06_r8, 1.25241e-06_r8, 1.22724e-06_r8, 1.20257e-06_r8/)
       kao_mn2( 4, :,16) = (/ &
     & 1.73310e-06_r8, 1.69826e-06_r8, 1.66413e-06_r8, 1.63069e-06_r8, 1.59791e-06_r8, &
     & 1.56580e-06_r8, 1.53433e-06_r8, 1.50349e-06_r8, 1.47328e-06_r8, 1.44367e-06_r8, &
     & 1.41465e-06_r8, 1.38622e-06_r8, 1.35836e-06_r8, 1.33106e-06_r8, 1.30431e-06_r8, &
     & 1.27810e-06_r8, 1.25241e-06_r8, 1.22724e-06_r8, 1.20257e-06_r8/)
       kao_mn2( 5, :,16) = (/ &
     & 1.73310e-06_r8, 1.69826e-06_r8, 1.66413e-06_r8, 1.63069e-06_r8, 1.59791e-06_r8, &
     & 1.56580e-06_r8, 1.53433e-06_r8, 1.50349e-06_r8, 1.47328e-06_r8, 1.44367e-06_r8, &
     & 1.41465e-06_r8, 1.38622e-06_r8, 1.35836e-06_r8, 1.33106e-06_r8, 1.30431e-06_r8, &
     & 1.27810e-06_r8, 1.25241e-06_r8, 1.22724e-06_r8, 1.20257e-06_r8/)
       kao_mn2( 6, :,16) = (/ &
     & 1.73310e-06_r8, 1.69826e-06_r8, 1.66413e-06_r8, 1.63069e-06_r8, 1.59791e-06_r8, &
     & 1.56580e-06_r8, 1.53433e-06_r8, 1.50349e-06_r8, 1.47328e-06_r8, 1.44367e-06_r8, &
     & 1.41465e-06_r8, 1.38622e-06_r8, 1.35836e-06_r8, 1.33106e-06_r8, 1.30431e-06_r8, &
     & 1.27810e-06_r8, 1.25241e-06_r8, 1.22724e-06_r8, 1.20257e-06_r8/)
       kao_mn2( 7, :,16) = (/ &
     & 1.73310e-06_r8, 1.69826e-06_r8, 1.66413e-06_r8, 1.63069e-06_r8, 1.59791e-06_r8, &
     & 1.56580e-06_r8, 1.53433e-06_r8, 1.50349e-06_r8, 1.47328e-06_r8, 1.44367e-06_r8, &
     & 1.41465e-06_r8, 1.38622e-06_r8, 1.35836e-06_r8, 1.33106e-06_r8, 1.30431e-06_r8, &
     & 1.27810e-06_r8, 1.25241e-06_r8, 1.22724e-06_r8, 1.20257e-06_r8/)
       kao_mn2( 8, :,16) = (/ &
     & 1.73310e-06_r8, 1.69826e-06_r8, 1.66413e-06_r8, 1.63069e-06_r8, 1.59791e-06_r8, &
     & 1.56580e-06_r8, 1.53433e-06_r8, 1.50349e-06_r8, 1.47328e-06_r8, 1.44367e-06_r8, &
     & 1.41465e-06_r8, 1.38622e-06_r8, 1.35836e-06_r8, 1.33106e-06_r8, 1.30431e-06_r8, &
     & 1.27810e-06_r8, 1.25241e-06_r8, 1.22724e-06_r8, 1.20257e-06_r8/)
       kao_mn2( 9, :,16) = (/ &
     & 1.79375e-06_r8, 1.75599e-06_r8, 1.71903e-06_r8, 1.68284e-06_r8, 1.64741e-06_r8, &
     & 1.61273e-06_r8, 1.57878e-06_r8, 1.54554e-06_r8, 1.51301e-06_r8, 1.48116e-06_r8, &
     & 1.44998e-06_r8, 1.41945e-06_r8, 1.38957e-06_r8, 1.36032e-06_r8, 1.33168e-06_r8, &
     & 1.30365e-06_r8, 1.27620e-06_r8, 1.24934e-06_r8, 1.22304e-06_r8/)

!     The array FORREFO contains the coefficient of the water vapor
!     foreign-continuum (including the energy term).  The first 
!     index refers to reference temperature (296,260,224,260) and 
!     pressure (970,475,219,3 mbar) levels.  The second index 
!     runs over the g-channel (1 to 16).

      forrefo(1,:) = (/ &
     &1.1755e-06_r8,6.5398e-07_r8,4.3915e-07_r8,3.0753e-07_r8,1.9677e-07_r8,1.4362e-07_r8, &
     &9.4598e-08_r8,1.1848e-07_r8,1.4280e-07_r8,1.5821e-07_r8,1.5816e-07_r8,1.5769e-07_r8, &
     &1.5844e-07_r8,1.6016e-07_r8,1.6232e-07_r8,1.6320e-07_r8/)
      forrefo(2,:) = (/ &
     &1.0703e-06_r8,6.2783e-07_r8,4.7122e-07_r8,2.6300e-07_r8,1.8538e-07_r8,1.5076e-07_r8, &
     &1.9474e-07_r8,2.9543e-07_r8,2.0093e-07_r8,1.5819e-07_r8,1.5826e-07_r8,1.5737e-07_r8, &
     &1.5751e-07_r8,1.5910e-07_r8,1.6181e-07_r8,1.6320e-07_r8/)
      forrefo(3,:) = (/ &
     &1.0470e-06_r8,5.8184e-07_r8,4.8218e-07_r8,2.7771e-07_r8,1.9036e-07_r8,1.5737e-07_r8, &
     &1.8633e-07_r8,2.5754e-07_r8,4.0647e-07_r8,1.5839e-07_r8,1.5914e-07_r8,1.5788e-07_r8, &
     &1.5731e-07_r8,1.5836e-07_r8,1.6103e-07_r8,1.6320e-07_r8/)
      forrefo(4,:) = (/ &
     &1.3891e-06_r8,5.4901e-07_r8,2.8850e-07_r8,1.9176e-07_r8,1.4549e-07_r8,1.3603e-07_r8, &
     &1.7472e-07_r8,2.9796e-07_r8,3.2452e-07_r8,2.5231e-07_r8,2.8195e-07_r8,1.5527e-07_r8, &
     &1.5507e-07_r8,1.5442e-07_r8,1.5275e-07_r8,1.6057e-07_r8/)

!     The array SELFREFO contains the coefficient of the water vapor
!     self-continuum (including the energy term).  The first index
!     refers to temperature in 7.2 degree increments.  For instance,
!     JT = 1 refers to a temperature of 245.6, JT = 2 refers to 252.8,
!     etc.  The second index runs over the g-channel (1 to 16).

      selfrefo(:, 1) = (/ &
     & 1.73980e-03_r8, 1.41928e-03_r8, 1.15780e-03_r8, 9.44496e-04_r8, 7.70490e-04_r8, &
     & 6.28541e-04_r8, 5.12744e-04_r8, 4.18280e-04_r8, 3.41219e-04_r8, 2.78356e-04_r8/)
      selfrefo(:, 2) = (/ &
     & 1.84082e-03_r8, 1.50228e-03_r8, 1.22600e-03_r8, 1.00053e-03_r8, 8.16525e-04_r8, &
     & 6.66359e-04_r8, 5.43811e-04_r8, 4.43800e-04_r8, 3.62182e-04_r8, 2.95574e-04_r8/)
      selfrefo(:, 3) = (/ &
     & 1.92957e-03_r8, 1.57727e-03_r8, 1.28930e-03_r8, 1.05390e-03_r8, 8.61484e-04_r8, &
     & 7.04197e-04_r8, 5.75627e-04_r8, 4.70530e-04_r8, 3.84622e-04_r8, 3.14399e-04_r8/)
      selfrefo(:, 4) = (/ &
     & 2.12958e-03_r8, 1.73572e-03_r8, 1.41470e-03_r8, 1.15305e-03_r8, 9.39798e-04_r8, &
     & 7.65984e-04_r8, 6.24317e-04_r8, 5.08850e-04_r8, 4.14739e-04_r8, 3.38034e-04_r8/)
      selfrefo(:, 5) = (/ &
     & 2.30636e-03_r8, 1.88401e-03_r8, 1.53900e-03_r8, 1.25717e-03_r8, 1.02695e-03_r8, &
     & 8.38891e-04_r8, 6.85270e-04_r8, 5.59780e-04_r8, 4.57270e-04_r8, 3.73533e-04_r8/)
      selfrefo(:, 6) = (/ &
     & 2.47824e-03_r8, 2.03278e-03_r8, 1.66740e-03_r8, 1.36769e-03_r8, 1.12185e-03_r8, &
     & 9.20206e-04_r8, 7.54803e-04_r8, 6.19130e-04_r8, 5.07844e-04_r8, 4.16561e-04_r8/)
      selfrefo(:, 7) = (/ &
     & 2.54196e-03_r8, 2.10768e-03_r8, 1.74760e-03_r8, 1.44904e-03_r8, 1.20148e-03_r8, &
     & 9.96215e-04_r8, 8.26019e-04_r8, 6.84900e-04_r8, 5.67890e-04_r8, 4.70870e-04_r8/)
      selfrefo(:, 8) = (/ &
     & 2.52650e-03_r8, 2.11773e-03_r8, 1.77510e-03_r8, 1.48790e-03_r8, 1.24717e-03_r8, &
     & 1.04539e-03_r8, 8.76251e-04_r8, 7.34480e-04_r8, 6.15646e-04_r8, 5.16039e-04_r8/)
      selfrefo(:, 9) = (/ &
     & 2.82351e-03_r8, 2.34652e-03_r8, 1.95010e-03_r8, 1.62065e-03_r8, 1.34686e-03_r8, &
     & 1.11933e-03_r8, 9.30232e-04_r8, 7.73080e-04_r8, 6.42477e-04_r8, 5.33939e-04_r8/)
      selfrefo(:,10) = (/ &
     & 2.98189e-03_r8, 2.46741e-03_r8, 2.04170e-03_r8, 1.68944e-03_r8, 1.39795e-03_r8, &
     & 1.15676e-03_r8, 9.57176e-04_r8, 7.92030e-04_r8, 6.55377e-04_r8, 5.42302e-04_r8/)
      selfrefo(:,11) = (/ &
     & 2.98239e-03_r8, 2.46774e-03_r8, 2.04190e-03_r8, 1.68954e-03_r8, 1.39799e-03_r8, &
     & 1.15675e-03_r8, 9.57137e-04_r8, 7.91970e-04_r8, 6.55305e-04_r8, 5.42224e-04_r8/)
      selfrefo(:,12) = (/ &
     & 2.97833e-03_r8, 2.46461e-03_r8, 2.03950e-03_r8, 1.68772e-03_r8, 1.39661e-03_r8, &
     & 1.15571e-03_r8, 9.56370e-04_r8, 7.91410e-04_r8, 6.54903e-04_r8, 5.41942e-04_r8/)
      selfrefo(:,13) = (/ &
     & 2.97779e-03_r8, 2.46463e-03_r8, 2.03990e-03_r8, 1.68836e-03_r8, 1.39741e-03_r8, &
     & 1.15659e-03_r8, 9.57278e-04_r8, 7.92310e-04_r8, 6.55771e-04_r8, 5.42762e-04_r8/)
      selfrefo(:,14) = (/ &
     & 2.98326e-03_r8, 2.46943e-03_r8, 2.04410e-03_r8, 1.69203e-03_r8, 1.40060e-03_r8, &
     & 1.15936e-03_r8, 9.59673e-04_r8, 7.94380e-04_r8, 6.57557e-04_r8, 5.44301e-04_r8/)
      selfrefo(:,15) = (/ &
     & 2.99407e-03_r8, 2.47825e-03_r8, 2.05130e-03_r8, 1.69790e-03_r8, 1.40539e-03_r8, &
     & 1.16327e-03_r8, 9.62862e-04_r8, 7.96980e-04_r8, 6.59676e-04_r8, 5.46028e-04_r8/)
      selfrefo(:,16) = (/ &
     & 3.00005e-03_r8, 2.48296e-03_r8, 2.05500e-03_r8, 1.70080e-03_r8, 1.40765e-03_r8, &
     & 1.16503e-03_r8, 9.64224e-04_r8, 7.98030e-04_r8, 6.60481e-04_r8, 5.46641e-04_r8/)

      end subroutine lw_kgb15

! **************************************************************************
