!     path:      $Source: /storm/rc1/cvsroot/rc/rrtmg_sw/src/rrtmg_sw_k_g.f90,v $
!     author:    $Author: mike $
!     revision:  $Revision: 1.2 $
!     created:   $Date: 2007/08/23 20:40:13 $

!  --------------------------------------------------------------------------
! |                                                                          |
! |  Copyright 2002-2007, Atmospheric & Environmental Research, Inc. (AER).  |
! |  This software may be used, copied, or redistributed as long as it is    |
! |  not sold and this copyright notice is reproduced on each copy made.     |
! |  This model is provided as is without any express or implied warranties. |
! |                       (http://www.rtweb.aer.com/)                        |
! |                                                                          |
!  --------------------------------------------------------------------------

! **************************************************************************
!      subroutine sw_kgbnn
! **************************************************************************
!  RRTM Shortwave Radiative Transfer Model
!  Atmospheric and Environmental Research, Inc., Cambridge, MA
!
!  Original by J.Delamere, Atmospheric & Environmental Research.
!  Reformatted for F90: JJMorcrette, ECMWF
!  Further F90 and GCM revisions:  MJIacono, AER, July 2002
!
!  This file contains 14 subroutines that include the 
!  absorption coefficients and other data for each of the 14 shortwave
!  spectral bands used in RRTM_SW.  Here, the data are defined for 16
!  g-points, or sub-intervals, per band.  These data are combined and
!  weighted using a mapping procedure in routine RRTMG_SW_INIT to reduce
!  the total number of g-points from 224 to 112 for use in the GCM.
! **************************************************************************

      subroutine sw_kgb24
! **************************************************************************

      use shr_kind_mod, only: r8 => shr_kind_r8

!      use parkind, only : jpim, jprb 
      use rrsw_kg24, only : kao, kbo, selfrefo, forrefo, sfluxrefo, &
                            raylao, raylbo, abso3ao, abso3bo, strrat, layreffr

      implicit none
      save

! Kurucz solar source function
      sfluxrefo(:,1) = (/ &
        & 34.3610_r8 , 33.1240_r8, 31.3948_r8, 28.7248_r8, &
        & 24.7884_r8 , 21.4892_r8, 17.3972_r8, 13.7928_r8, &
        & 9.54462_r8 , 1.05002_r8,0.867332_r8,0.685753_r8, &
        & 0.504718_r8,0.323112_r8,0.122183_r8, 1.70288e-02_r8 /)
      sfluxrefo(:,2) = (/ &
        & 34.2367_r8 , 32.4327_r8, 30.0863_r8, 28.2085_r8, & 
        & 25.6533_r8 , 22.3412_r8, 18.3112_r8, 13.8521_r8, &
        & 9.51035_r8 , 1.04138_r8,0.863493_r8,0.682790_r8, &
        & 0.504721_r8,0.323102_r8,0.122193_r8, 1.70288e-02_r8 /)
      sfluxrefo(:,3) = (/ &
        & 34.1883_r8 , 32.2479_r8, 30.2650_r8, 28.2914_r8, &
        & 25.6626_r8 , 22.3163_r8, 18.3327_r8, 13.8508_r8, &
        & 9.49190_r8 , 1.03672_r8,0.858272_r8,0.681485_r8, &
        & 0.501363_r8,0.323110_r8,0.122183_r8, 1.70288e-02_r8 /)
      sfluxrefo(:,4) = (/ &
        & 34.1365_r8 , 32.2316_r8, 30.3325_r8, 28.3305_r8, &
        & 25.6420_r8 , 22.3223_r8, 18.3411_r8, 13.8471_r8, &
        & 9.47492_r8 , 1.03376_r8,0.855380_r8,0.679085_r8, &
        & 0.497998_r8,0.323053_r8,0.122183_r8, 1.70288e-02_r8 /)
      sfluxrefo(:,5) = (/ &
        & 34.0460_r8 , 32.2795_r8, 30.4147_r8, 28.3123_r8, &
        & 25.6438_r8 , 22.3238_r8, 18.3441_r8, 13.8528_r8, &
        & 9.45222_r8 , 1.03058_r8,0.854037_r8,0.675554_r8, &
        & 0.498344_r8,0.320072_r8,0.122193_r8, 1.70288e-02_r8 /)
      sfluxrefo(:,6) = (/ &
        & 33.9909_r8 , 32.3127_r8, 30.4854_r8, 28.3005_r8, &
        & 25.6310_r8 , 22.3294_r8, 18.3459_r8, 13.8488_r8, &
        & 9.43336_r8 , 1.02901_r8,0.852728_r8,0.672322_r8, &
        & 0.498056_r8,0.317753_r8,0.122183_r8, 1.70288e-02_r8 /)
      sfluxrefo(:,7) = (/ &
        & 33.9225_r8 , 32.4097_r8, 30.5125_r8, 28.2810_r8, &
        & 25.6387_r8 , 22.3080_r8, 18.3715_r8, 13.8248_r8, &
        & 9.41834_r8 , 1.02735_r8,0.850807_r8,0.671379_r8, &
        & 0.496975_r8,0.317158_r8,0.119297_r8, 1.70207e-02_r8 /)
      sfluxrefo(:,8) = (/ &
        & 33.8940_r8 , 32.4951_r8, 30.5494_r8, 28.2788_r8, &
        & 25.5975_r8 , 22.3225_r8, 18.3358_r8, 13.8199_r8, &
        & 9.40283_r8 , 1.02751_r8,0.850729_r8,0.670152_r8, &
        & 0.494294_r8,0.315829_r8,0.116195_r8, 1.64138e-02_r8 /)
      sfluxrefo(:,9) = (/ &
        & 34.6501_r8 , 32.6690_r8, 30.2872_r8, 28.0955_r8, &
        & 25.4662_r8 , 22.1446_r8, 18.2754_r8, 13.7573_r8, &
        & 9.36645_r8 , 1.02356_r8,0.847154_r8,0.668519_r8, &
        & 0.489186_r8,0.313790_r8,0.117074_r8, 1.60943e-02_r8 /)

! Rayleigh extinction coefficient at all v
      raylao(:,1) = (/ &
        & 1.28405e-07_r8,1.45501e-07_r8,1.67272e-07_r8,1.94856e-07_r8, &
        & 2.15248e-07_r8,2.34920e-07_r8,2.48558e-07_r8,1.80004e-07_r8, &
        & 1.46504e-07_r8,1.31355e-07_r8,1.33562e-07_r8,1.35618e-07_r8, &
        & 1.22412e-07_r8,1.19842e-07_r8,1.19924e-07_r8,1.20264e-07_r8 /)
      raylao(:,2) = (/ &
        & 1.41622e-07_r8,1.93436e-07_r8,2.25057e-07_r8,2.01025e-07_r8, &
        & 1.85138e-07_r8,1.72672e-07_r8,1.64771e-07_r8,1.59312e-07_r8, &
        & 1.44961e-07_r8,1.37448e-07_r8,1.37506e-07_r8,1.38081e-07_r8, &
        & 1.22432e-07_r8,1.19844e-07_r8,1.19921e-07_r8,1.20287e-07_r8 /)
      raylao(:,3) = (/ &
        & 1.45382e-07_r8,1.97020e-07_r8,2.22781e-07_r8,1.96062e-07_r8, &
        & 1.83495e-07_r8,1.72495e-07_r8,1.64910e-07_r8,1.58797e-07_r8, &
        & 1.46208e-07_r8,1.42274e-07_r8,1.40445e-07_r8,1.39496e-07_r8, &
        & 1.26940e-07_r8,1.19844e-07_r8,1.19921e-07_r8,1.20287e-07_r8 /)
      raylao(:,4) = (/ &
        & 1.48247e-07_r8,1.99958e-07_r8,2.18048e-07_r8,1.93896e-07_r8, &
        & 1.83125e-07_r8,1.73244e-07_r8,1.64320e-07_r8,1.58298e-07_r8, &
        & 1.48428e-07_r8,1.44769e-07_r8,1.43704e-07_r8,1.38498e-07_r8, &
        & 1.31732e-07_r8,1.22299e-07_r8,1.19921e-07_r8,1.20287e-07_r8 /)
      raylao(:,5) = (/ &
        & 1.51343e-07_r8,1.99621e-07_r8,2.14563e-07_r8,1.93824e-07_r8, &
        & 1.82992e-07_r8,1.73143e-07_r8,1.64587e-07_r8,1.57355e-07_r8, &
        & 1.51198e-07_r8,1.46373e-07_r8,1.45438e-07_r8,1.38095e-07_r8, &
        & 1.35026e-07_r8,1.27504e-07_r8,1.19921e-07_r8,1.20287e-07_r8 /)
      raylao(:,6) = (/ &
        & 1.54462e-07_r8,1.97610e-07_r8,2.11992e-07_r8,1.93831e-07_r8, &
        & 1.83900e-07_r8,1.73125e-07_r8,1.64093e-07_r8,1.57651e-07_r8, &
        & 1.53158e-07_r8,1.46843e-07_r8,1.44733e-07_r8,1.40611e-07_r8, &
        & 1.37320e-07_r8,1.33932e-07_r8,1.20423e-07_r8,1.20287e-07_r8 /)
      raylao(:,7) = (/ &
        & 1.59068e-07_r8,1.92757e-07_r8,2.09865e-07_r8,1.95132e-07_r8, &
        & 1.83641e-07_r8,1.73778e-07_r8,1.63215e-07_r8,1.59462e-07_r8, &
        & 1.54331e-07_r8,1.46177e-07_r8,1.45819e-07_r8,1.43177e-07_r8, &
        & 1.39797e-07_r8,1.36780e-07_r8,1.33385e-07_r8,1.20287e-07_r8 /)
      raylao(:,8) = (/ &
        & 1.62066e-07_r8,1.87529e-07_r8,2.07191e-07_r8,1.97788e-07_r8, &
        & 1.84920e-07_r8,1.72951e-07_r8,1.65450e-07_r8,1.60344e-07_r8, &
        & 1.54403e-07_r8,1.47679e-07_r8,1.47287e-07_r8,1.44951e-07_r8, &
        & 1.42517e-07_r8,1.41107e-07_r8,1.48688e-07_r8,1.51127e-07_r8 /)
      raylao(:,9) = (/ &
        & 1.19177e-07_r8,1.86522e-07_r8,2.20324e-07_r8,2.13543e-07_r8, &
        & 1.92198e-07_r8,1.81641e-07_r8,1.70092e-07_r8,1.65072e-07_r8, &
        & 1.59804e-07_r8,1.56745e-07_r8,1.51235e-07_r8,1.51400e-07_r8, &
        & 1.49635e-07_r8,1.48056e-07_r8,1.49046e-07_r8,1.51010e-07_r8 /)

      raylbo(:) = (/ &
        & 1.23766e-07_r8,1.40524e-07_r8,1.61610e-07_r8,1.83232e-07_r8, &
        & 2.02951e-07_r8,2.21367e-07_r8,2.38367e-07_r8,2.53019e-07_r8, &
        & 2.12202e-07_r8,1.36977e-07_r8,1.39118e-07_r8,1.37097e-07_r8, &
        & 1.33223e-07_r8,1.38695e-07_r8,1.19868e-07_r8,1.20062e-07_r8 /)

      abso3ao(:) = (/ &
        & 8.03067e-02_r8,0.180926_r8   ,0.227484_r8   ,0.168015_r8   , &
        & 0.138284_r8   ,0.114537_r8   ,9.50114e-02_r8,8.06816e-02_r8, &
        & 6.76406e-02_r8,5.69802e-02_r8,5.63283e-02_r8,4.57592e-02_r8, &
        & 4.21862e-02_r8,3.47949e-02_r8,2.65731e-02_r8,2.67628e-02_r8 /)

      abso3bo(:) = (/ &
        & 2.94848e-02_r8,4.33642e-02_r8,6.70197e-02_r8,0.104990_r8   , &
        & 0.156180_r8   ,0.214638_r8   ,0.266281_r8   ,0.317941_r8   , &
        & 0.355327_r8   ,0.371241_r8   ,0.374396_r8   ,0.326847_r8   , &
        & 0.126497_r8   ,6.95264e-02_r8,2.58175e-02_r8,2.52862e-02_r8 /)

      strrat = 0.124692_r8

      layreffr = 1

!     ------------------------------------------------------------------
!     The array KAO contains absorption coefs at the 16 chosen g-values 
!     for a range of pressure levels> ~100mb, temperatures, and binary
!     species parameters (see taumol.f for definition).  The first 
!     index in the array, JS, runs from 1 to 9, and corresponds to 
!     different values of the binary species parameter.  For instance, 
!     JS=1 refers to dry air, JS = 2 corresponds to the paramter value 1/8, 
!     JS = 3 corresponds to the parameter value 2/8, etc.  The second index
!     in the array, JT, which runs from 1 to 5, corresponds to different
!     temperatures.  More specifically, JT = 3 means that the data are for
!     the reference temperature TREF for this  pressure level, JT = 2 refers
!     to TREF-15, JT = 1 is for TREF-30, JT = 4 is for TREF+15, and JT = 5
!     is for TREF+30.  The third index, JP, runs from 1 to 13 and refers
!     to the JPth reference pressure level (see taumol.f for these levels
!     in mb).  The fourth index, IG, goes from 1 to 16, and indicates
!     which g-interval the absorption coefficients are for.
!     -----------------------------------------------------------------

      kao(:, 1, 1, 1) = (/ &
        & 0.73110e-09_r8,0.95257e-08_r8,0.84454e-08_r8,0.69367e-08_r8,0.55267e-08_r8, &
        & 0.41107e-08_r8,0.32800e-08_r8,0.33548e-08_r8,0.22111e-08_r8 /)
      kao(:, 2, 1, 1) = (/ &
        & 0.71850e-09_r8,0.98856e-08_r8,0.88084e-08_r8,0.72442e-08_r8,0.57586e-08_r8, &
        & 0.43475e-08_r8,0.34021e-08_r8,0.32425e-08_r8,0.21911e-08_r8 /)
      kao(:, 3, 1, 1) = (/ &
        & 0.57048e-09_r8,0.11944e-07_r8,0.10693e-07_r8,0.91787e-08_r8,0.75423e-08_r8, &
        & 0.56949e-08_r8,0.43124e-08_r8,0.42335e-08_r8,0.57788e-08_r8 /)
      kao(:, 4, 1, 1) = (/ &
        & 0.45283e-09_r8,0.10517e-07_r8,0.93142e-08_r8,0.77267e-08_r8,0.61927e-08_r8, &
        & 0.47485e-08_r8,0.34557e-08_r8,0.32691e-08_r8,0.21836e-08_r8 /)
      kao(:, 5, 1, 1) = (/ &
        & 0.40037e-09_r8,0.10599e-07_r8,0.93529e-08_r8,0.78411e-08_r8,0.63421e-08_r8, &
        & 0.49082e-08_r8,0.36312e-08_r8,0.32874e-08_r8,0.21861e-08_r8 /)
      kao(:, 1, 2, 1) = (/ &
        & 0.77671e-09_r8,0.11163e-07_r8,0.95032e-08_r8,0.79805e-08_r8,0.60721e-08_r8, &
        & 0.45440e-08_r8,0.31263e-08_r8,0.28631e-08_r8,0.19430e-08_r8 /)
      kao(:, 2, 2, 1) = (/ &
        & 0.85527e-09_r8,0.11271e-07_r8,0.97269e-08_r8,0.82280e-08_r8,0.62706e-08_r8, &
        & 0.47926e-08_r8,0.32802e-08_r8,0.28152e-08_r8,0.19155e-08_r8 /)
      kao(:, 3, 2, 1) = (/ &
        & 0.85773e-09_r8,0.13292e-07_r8,0.11943e-07_r8,0.10177e-07_r8,0.81637e-08_r8, &
        & 0.62054e-08_r8,0.44045e-08_r8,0.35504e-08_r8,0.48274e-08_r8 /)
      kao(:, 4, 2, 1) = (/ &
        & 0.76956e-09_r8,0.13343e-07_r8,0.12140e-07_r8,0.10403e-07_r8,0.83916e-08_r8, &
        & 0.64414e-08_r8,0.46212e-08_r8,0.36611e-08_r8,0.46523e-08_r8 /)
      kao(:, 5, 2, 1) = (/ &
        & 0.53187e-09_r8,0.11759e-07_r8,0.10564e-07_r8,0.89416e-08_r8,0.69566e-08_r8, &
        & 0.54336e-08_r8,0.36797e-08_r8,0.28238e-08_r8,0.18838e-08_r8 /)
      kao(:, 1, 3, 1) = (/ &
        & 0.99065e-09_r8,0.13223e-07_r8,0.11222e-07_r8,0.94282e-08_r8,0.74664e-08_r8, &
        & 0.54084e-08_r8,0.35205e-08_r8,0.24806e-08_r8,0.20205e-08_r8 /)
      kao(:, 2, 3, 1) = (/ &
        & 0.98793e-09_r8,0.13673e-07_r8,0.11444e-07_r8,0.96735e-08_r8,0.76364e-08_r8, &
        & 0.55809e-08_r8,0.37259e-08_r8,0.25419e-08_r8,0.20086e-08_r8 /)
      kao(:, 3, 3, 1) = (/ &
        & 0.10274e-08_r8,0.14243e-07_r8,0.12051e-07_r8,0.10168e-07_r8,0.80110e-08_r8, &
        & 0.59129e-08_r8,0.38720e-08_r8,0.26806e-08_r8,0.19959e-08_r8 /)
      kao(:, 4, 3, 1) = (/ &
        & 0.10879e-08_r8,0.15991e-07_r8,0.14290e-07_r8,0.12193e-07_r8,0.99943e-08_r8, &
        & 0.76411e-08_r8,0.49949e-08_r8,0.32117e-08_r8,0.45196e-08_r8 /)
      kao(:, 5, 3, 1) = (/ &
        & 0.10733e-08_r8,0.14460e-07_r8,0.12483e-07_r8,0.10703e-07_r8,0.84924e-08_r8, &
        & 0.62896e-08_r8,0.42753e-08_r8,0.27408e-08_r8,0.19679e-08_r8 /)
      kao(:, 1, 4, 1) = (/ &
        & 0.11948e-08_r8,0.15804e-07_r8,0.13423e-07_r8,0.10964e-07_r8,0.86345e-08_r8, &
        & 0.61421e-08_r8,0.39130e-08_r8,0.24271e-08_r8,0.26282e-08_r8 /)
      kao(:, 2, 4, 1) = (/ &
        & 0.12796e-08_r8,0.16985e-07_r8,0.14121e-07_r8,0.11784e-07_r8,0.93415e-08_r8, &
        & 0.67310e-08_r8,0.43124e-08_r8,0.25170e-08_r8,0.26033e-08_r8 /)
      kao(:, 3, 4, 1) = (/ &
        & 0.12903e-08_r8,0.17863e-07_r8,0.14703e-07_r8,0.12387e-07_r8,0.99243e-08_r8, &
        & 0.72283e-08_r8,0.46892e-08_r8,0.26092e-08_r8,0.25739e-08_r8 /)
      kao(:, 4, 4, 1) = (/ &
        & 0.13030e-08_r8,0.17982e-07_r8,0.14488e-07_r8,0.12389e-07_r8,0.10284e-07_r8, &
        & 0.76192e-08_r8,0.50049e-08_r8,0.27184e-08_r8,0.25450e-08_r8 /)
      kao(:, 5, 4, 1) = (/ &
        & 0.13295e-08_r8,0.20084e-07_r8,0.17213e-07_r8,0.15086e-07_r8,0.12255e-07_r8, &
        & 0.93192e-08_r8,0.61747e-08_r8,0.34151e-08_r8,0.50409e-08_r8 /)
      kao(:, 1, 5, 1) = (/ &
        & 0.14930e-08_r8,0.19740e-07_r8,0.16353e-07_r8,0.13382e-07_r8,0.10370e-07_r8, &
        & 0.76167e-08_r8,0.46913e-08_r8,0.23740e-08_r8,0.37254e-08_r8 /)
      kao(:, 2, 5, 1) = (/ &
        & 0.15750e-08_r8,0.20826e-07_r8,0.17352e-07_r8,0.14080e-07_r8,0.11109e-07_r8, &
        & 0.82293e-08_r8,0.51142e-08_r8,0.25900e-08_r8,0.36977e-08_r8 /)
      kao(:, 3, 5, 1) = (/ &
        & 0.16427e-08_r8,0.22313e-07_r8,0.18005e-07_r8,0.14545e-07_r8,0.11545e-07_r8, &
        & 0.85987e-08_r8,0.53849e-08_r8,0.27523e-08_r8,0.36628e-08_r8 /)
      kao(:, 4, 5, 1) = (/ &
        & 0.17106e-08_r8,0.23821e-07_r8,0.18882e-07_r8,0.15226e-07_r8,0.12313e-07_r8, &
        & 0.92367e-08_r8,0.58646e-08_r8,0.29020e-08_r8,0.36336e-08_r8 /)
      kao(:, 5, 5, 1) = (/ &
        & 0.17465e-08_r8,0.26750e-07_r8,0.22103e-07_r8,0.18690e-07_r8,0.15320e-07_r8, &
        & 0.11508e-07_r8,0.77281e-08_r8,0.34929e-08_r8,0.69801e-08_r8 /)
      kao(:, 1, 6, 1) = (/ &
        & 0.17561e-08_r8,0.17298e-07_r8,0.18888e-07_r8,0.16164e-07_r8,0.12676e-07_r8, &
        & 0.91128e-08_r8,0.57292e-08_r8,0.25945e-08_r8,0.52718e-08_r8 /)
      kao(:, 2, 6, 1) = (/ &
        & 0.19997e-08_r8,0.20866e-07_r8,0.20612e-07_r8,0.17467e-07_r8,0.13431e-07_r8, &
        & 0.96178e-08_r8,0.60009e-08_r8,0.28959e-08_r8,0.52609e-08_r8 /)
      kao(:, 3, 6, 1) = (/ &
        & 0.21808e-08_r8,0.24689e-07_r8,0.22590e-07_r8,0.18672e-07_r8,0.14573e-07_r8, &
        & 0.10599e-07_r8,0.66802e-08_r8,0.31104e-08_r8,0.52649e-08_r8 /)
      kao(:, 4, 6, 1) = (/ &
        & 0.22321e-08_r8,0.28043e-07_r8,0.23802e-07_r8,0.19473e-07_r8,0.15182e-07_r8, &
        & 0.11372e-07_r8,0.73223e-08_r8,0.34820e-08_r8,0.52977e-08_r8 /)
      kao(:, 5, 6, 1) = (/ &
        & 0.23033e-08_r8,0.30784e-07_r8,0.25188e-07_r8,0.20376e-07_r8,0.16019e-07_r8, &
        & 0.12009e-07_r8,0.77933e-08_r8,0.37322e-08_r8,0.52777e-08_r8 /)
      kao(:, 1, 7, 1) = (/ &
        & 0.22679e-08_r8,0.13507e-07_r8,0.20320e-07_r8,0.19549e-07_r8,0.15905e-07_r8, &
        & 0.11277e-07_r8,0.68710e-08_r8,0.29328e-08_r8,0.79703e-08_r8 /)
      kao(:, 2, 7, 1) = (/ &
        & 0.25718e-08_r8,0.16957e-07_r8,0.24375e-07_r8,0.21175e-07_r8,0.17080e-07_r8, &
        & 0.12233e-07_r8,0.77114e-08_r8,0.34113e-08_r8,0.79963e-08_r8 /)
      kao(:, 3, 7, 1) = (/ &
        & 0.27598e-08_r8,0.19896e-07_r8,0.28092e-07_r8,0.23059e-07_r8,0.18272e-07_r8, &
        & 0.13117e-07_r8,0.84449e-08_r8,0.37817e-08_r8,0.79824e-08_r8 /)
      kao(:, 4, 7, 1) = (/ &
        & 0.28979e-08_r8,0.22997e-07_r8,0.29556e-07_r8,0.24211e-07_r8,0.19134e-07_r8, &
        & 0.13799e-07_r8,0.90980e-08_r8,0.41849e-08_r8,0.79622e-08_r8 /)
      kao(:, 5, 7, 1) = (/ &
        & 0.31158e-08_r8,0.26193e-07_r8,0.32426e-07_r8,0.25685e-07_r8,0.19970e-07_r8, &
        & 0.14504e-07_r8,0.96379e-08_r8,0.45034e-08_r8,0.78914e-08_r8 /)
      kao(:, 1, 8, 1) = (/ &
        & 0.27286e-08_r8,0.10085e-07_r8,0.15014e-07_r8,0.19090e-07_r8,0.19831e-07_r8, &
        & 0.15054e-07_r8,0.91059e-08_r8,0.39324e-08_r8,0.14155e-07_r8 /)
      kao(:, 2, 8, 1) = (/ &
        & 0.30146e-08_r8,0.12680e-07_r8,0.19259e-07_r8,0.23896e-07_r8,0.21584e-07_r8, &
        & 0.16217e-07_r8,0.99712e-08_r8,0.44108e-08_r8,0.14243e-07_r8 /)
      kao(:, 3, 8, 1) = (/ &
        & 0.35571e-08_r8,0.15989e-07_r8,0.23328e-07_r8,0.28003e-07_r8,0.22999e-07_r8, &
        & 0.17316e-07_r8,0.10856e-07_r8,0.49279e-08_r8,0.13770e-07_r8 /)
      kao(:, 4, 8, 1) = (/ &
        & 0.40065e-08_r8,0.19481e-07_r8,0.27247e-07_r8,0.30922e-07_r8,0.24592e-07_r8, &
        & 0.18005e-07_r8,0.11331e-07_r8,0.53242e-08_r8,0.13758e-07_r8 /)
      kao(:, 5, 8, 1) = (/ &
        & 0.44047e-08_r8,0.23368e-07_r8,0.31337e-07_r8,0.33478e-07_r8,0.26467e-07_r8, &
        & 0.19093e-07_r8,0.12194e-07_r8,0.56088e-08_r8,0.13665e-07_r8 /)
      kao(:, 1, 9, 1) = (/ &
        & 0.32692e-08_r8,0.79127e-08_r8,0.11108e-07_r8,0.13962e-07_r8,0.15949e-07_r8, &
        & 0.18125e-07_r8,0.12367e-07_r8,0.53666e-08_r8,0.28048e-07_r8 /)
      kao(:, 2, 9, 1) = (/ &
        & 0.39872e-08_r8,0.10056e-07_r8,0.14185e-07_r8,0.17838e-07_r8,0.20262e-07_r8, &
        & 0.19824e-07_r8,0.13459e-07_r8,0.59111e-08_r8,0.29491e-07_r8 /)
      kao(:, 3, 9, 1) = (/ &
        & 0.46117e-08_r8,0.12472e-07_r8,0.17902e-07_r8,0.22130e-07_r8,0.25362e-07_r8, &
        & 0.21745e-07_r8,0.14226e-07_r8,0.62741e-08_r8,0.30373e-07_r8 /)
      kao(:, 4, 9, 1) = (/ &
        & 0.52024e-08_r8,0.15275e-07_r8,0.21923e-07_r8,0.27295e-07_r8,0.30210e-07_r8, &
        & 0.23240e-07_r8,0.15087e-07_r8,0.66869e-08_r8,0.31196e-07_r8 /)
      kao(:, 5, 9, 1) = (/ &
        & 0.56198e-08_r8,0.17975e-07_r8,0.26684e-07_r8,0.30762e-07_r8,0.34012e-07_r8, &
        & 0.25509e-07_r8,0.16208e-07_r8,0.72951e-08_r8,0.31583e-07_r8 /)
      kao(:, 1,10, 1) = (/ &
        & 0.48178e-08_r8,0.70531e-08_r8,0.93321e-08_r8,0.10834e-07_r8,0.12386e-07_r8, &
        & 0.13718e-07_r8,0.14795e-07_r8,0.73464e-08_r8,0.35934e-07_r8 /)
      kao(:, 2,10, 1) = (/ &
        & 0.55752e-08_r8,0.86985e-08_r8,0.11492e-07_r8,0.13823e-07_r8,0.15291e-07_r8, &
        & 0.17278e-07_r8,0.18153e-07_r8,0.81439e-08_r8,0.37177e-07_r8 /)
      kao(:, 3,10, 1) = (/ &
        & 0.63274e-08_r8,0.10735e-07_r8,0.13985e-07_r8,0.17136e-07_r8,0.19303e-07_r8, &
        & 0.20940e-07_r8,0.20044e-07_r8,0.88008e-08_r8,0.38431e-07_r8 /)
      kao(:, 4,10, 1) = (/ &
        & 0.70007e-08_r8,0.12858e-07_r8,0.17195e-07_r8,0.20946e-07_r8,0.23543e-07_r8, &
        & 0.25732e-07_r8,0.21748e-07_r8,0.95846e-08_r8,0.39768e-07_r8 /)
      kao(:, 5,10, 1) = (/ &
        & 0.75858e-08_r8,0.15576e-07_r8,0.20803e-07_r8,0.25331e-07_r8,0.28222e-07_r8, &
        & 0.30974e-07_r8,0.23346e-07_r8,0.10532e-07_r8,0.41126e-07_r8 /)
      kao(:, 1,11, 1) = (/ &
        & 0.71066e-08_r8,0.91105e-08_r8,0.91823e-08_r8,0.10078e-07_r8,0.11080e-07_r8, &
        & 0.11808e-07_r8,0.12592e-07_r8,0.10585e-07_r8,0.36646e-07_r8 /)
      kao(:, 2,11, 1) = (/ &
        & 0.75651e-08_r8,0.10196e-07_r8,0.11288e-07_r8,0.12341e-07_r8,0.13264e-07_r8, &
        & 0.14635e-07_r8,0.15304e-07_r8,0.12113e-07_r8,0.37821e-07_r8 /)
      kao(:, 3,11, 1) = (/ &
        & 0.84521e-08_r8,0.11641e-07_r8,0.13494e-07_r8,0.15134e-07_r8,0.16494e-07_r8, &
        & 0.17667e-07_r8,0.18637e-07_r8,0.13998e-07_r8,0.39151e-07_r8 /)
      kao(:, 4,11, 1) = (/ &
        & 0.96535e-08_r8,0.13091e-07_r8,0.16210e-07_r8,0.18132e-07_r8,0.20108e-07_r8, &
        & 0.21506e-07_r8,0.22578e-07_r8,0.15372e-07_r8,0.40534e-07_r8 /)
      kao(:, 5,11, 1) = (/ &
        & 0.10866e-07_r8,0.15259e-07_r8,0.19222e-07_r8,0.21816e-07_r8,0.23808e-07_r8, &
        & 0.25779e-07_r8,0.26640e-07_r8,0.16560e-07_r8,0.41783e-07_r8 /)
      kao(:, 1,12, 1) = (/ &
        & 0.80834e-08_r8,0.10420e-07_r8,0.92387e-08_r8,0.95448e-08_r8,0.10004e-07_r8, &
        & 0.10210e-07_r8,0.10715e-07_r8,0.12956e-07_r8,0.37307e-07_r8 /)
      kao(:, 2,12, 1) = (/ &
        & 0.93300e-08_r8,0.11721e-07_r8,0.10935e-07_r8,0.11240e-07_r8,0.12099e-07_r8, &
        & 0.12529e-07_r8,0.12978e-07_r8,0.14968e-07_r8,0.38619e-07_r8 /)
      kao(:, 3,12, 1) = (/ &
        & 0.10509e-07_r8,0.12830e-07_r8,0.12793e-07_r8,0.13649e-07_r8,0.14634e-07_r8, &
        & 0.15024e-07_r8,0.15635e-07_r8,0.17087e-07_r8,0.40001e-07_r8 /)
      kao(:, 4,12, 1) = (/ &
        & 0.11973e-07_r8,0.14173e-07_r8,0.14811e-07_r8,0.16236e-07_r8,0.17652e-07_r8, &
        & 0.18139e-07_r8,0.18897e-07_r8,0.19167e-07_r8,0.41426e-07_r8 /)
      kao(:, 5,12, 1) = (/ &
        & 0.13412e-07_r8,0.16145e-07_r8,0.17438e-07_r8,0.18946e-07_r8,0.20873e-07_r8, &
        & 0.21649e-07_r8,0.22446e-07_r8,0.20222e-07_r8,0.42866e-07_r8 /)
      kao(:, 1,13, 1) = (/ &
        & 0.96752e-08_r8,0.12525e-07_r8,0.10944e-07_r8,0.96402e-08_r8,0.92613e-08_r8, &
        & 0.89183e-08_r8,0.91757e-08_r8,0.10962e-07_r8,0.37700e-07_r8 /)
      kao(:, 2,13, 1) = (/ &
        & 0.10573e-07_r8,0.14013e-07_r8,0.12095e-07_r8,0.11243e-07_r8,0.11108e-07_r8, &
        & 0.10880e-07_r8,0.11099e-07_r8,0.12700e-07_r8,0.39054e-07_r8 /)
      kao(:, 3,13, 1) = (/ &
        & 0.12096e-07_r8,0.15476e-07_r8,0.13719e-07_r8,0.13357e-07_r8,0.13060e-07_r8, &
        & 0.13122e-07_r8,0.13232e-07_r8,0.14320e-07_r8,0.40767e-07_r8 /)
      kao(:, 4,13, 1) = (/ &
        & 0.13461e-07_r8,0.16674e-07_r8,0.15454e-07_r8,0.15611e-07_r8,0.15616e-07_r8, &
        & 0.15505e-07_r8,0.16233e-07_r8,0.16510e-07_r8,0.42192e-07_r8 /)
      kao(:, 5,13, 1) = (/ &
        & 0.14863e-07_r8,0.17307e-07_r8,0.17245e-07_r8,0.18041e-07_r8,0.18314e-07_r8, &
        & 0.18445e-07_r8,0.19222e-07_r8,0.18635e-07_r8,0.43353e-07_r8 /)
      kao(:, 1, 1, 2) = (/ &
        & 0.11698e-08_r8,0.30848e-07_r8,0.36454e-07_r8,0.38710e-07_r8,0.45901e-07_r8, &
        & 0.55227e-07_r8,0.66976e-07_r8,0.88407e-07_r8,0.23422e-07_r8 /)
      kao(:, 2, 1, 2) = (/ &
        & 0.11855e-08_r8,0.31924e-07_r8,0.37139e-07_r8,0.40576e-07_r8,0.48515e-07_r8, &
        & 0.57453e-07_r8,0.68267e-07_r8,0.87661e-07_r8,0.23548e-07_r8 /)
      kao(:, 3, 1, 2) = (/ &
        & 0.14595e-08_r8,0.39594e-07_r8,0.49562e-07_r8,0.62806e-07_r8,0.77187e-07_r8, &
        & 0.93412e-07_r8,0.11204e-06_r8,0.13944e-06_r8,0.36327e-07_r8 /)
      kao(:, 4, 1, 2) = (/ &
        & 0.16033e-08_r8,0.32903e-07_r8,0.39616e-07_r8,0.43600e-07_r8,0.51878e-07_r8, &
        & 0.61189e-07_r8,0.71838e-07_r8,0.88579e-07_r8,0.23754e-07_r8 /)
      kao(:, 5, 1, 2) = (/ &
        & 0.16713e-08_r8,0.33816e-07_r8,0.40271e-07_r8,0.44761e-07_r8,0.53112e-07_r8, &
        & 0.62817e-07_r8,0.73214e-07_r8,0.89918e-07_r8,0.23712e-07_r8 /)
      kao(:, 1, 2, 2) = (/ &
        & 0.14413e-08_r8,0.29542e-07_r8,0.33672e-07_r8,0.38233e-07_r8,0.38429e-07_r8, &
        & 0.45175e-07_r8,0.55138e-07_r8,0.73579e-07_r8,0.25050e-07_r8 /)
      kao(:, 2, 2, 2) = (/ &
        & 0.13819e-08_r8,0.33839e-07_r8,0.35660e-07_r8,0.39637e-07_r8,0.40862e-07_r8, &
        & 0.47496e-07_r8,0.56716e-07_r8,0.72256e-07_r8,0.25722e-07_r8 /)
      kao(:, 3, 2, 2) = (/ &
        & 0.14034e-08_r8,0.38888e-07_r8,0.49224e-07_r8,0.54694e-07_r8,0.64529e-07_r8, &
        & 0.76758e-07_r8,0.91615e-07_r8,0.11521e-06_r8,0.39473e-07_r8 /)
      kao(:, 4, 2, 2) = (/ &
        & 0.15427e-08_r8,0.40736e-07_r8,0.49562e-07_r8,0.55626e-07_r8,0.65520e-07_r8, &
        & 0.77421e-07_r8,0.92434e-07_r8,0.11487e-06_r8,0.39089e-07_r8 /)
      kao(:, 5, 2, 2) = (/ &
        & 0.19146e-08_r8,0.37020e-07_r8,0.37998e-07_r8,0.40828e-07_r8,0.46417e-07_r8, &
        & 0.52511e-07_r8,0.60306e-07_r8,0.73583e-07_r8,0.26882e-07_r8 /)
      kao(:, 1, 3, 2) = (/ &
        & 0.16720e-08_r8,0.23360e-07_r8,0.34106e-07_r8,0.35883e-07_r8,0.37371e-07_r8, &
        & 0.37719e-07_r8,0.44564e-07_r8,0.59521e-07_r8,0.60171e-07_r8 /)
      kao(:, 2, 3, 2) = (/ &
        & 0.17699e-08_r8,0.26546e-07_r8,0.36000e-07_r8,0.36846e-07_r8,0.38381e-07_r8, &
        & 0.39667e-07_r8,0.46368e-07_r8,0.60306e-07_r8,0.60604e-07_r8 /)
      kao(:, 3, 3, 2) = (/ &
        & 0.18009e-08_r8,0.29450e-07_r8,0.37614e-07_r8,0.38630e-07_r8,0.39041e-07_r8, &
        & 0.41600e-07_r8,0.48142e-07_r8,0.59638e-07_r8,0.61274e-07_r8 /)
      kao(:, 4, 3, 2) = (/ &
        & 0.18222e-08_r8,0.39219e-07_r8,0.48109e-07_r8,0.53485e-07_r8,0.57150e-07_r8, &
        & 0.64444e-07_r8,0.75574e-07_r8,0.94813e-07_r8,0.76759e-07_r8 /)
      kao(:, 5, 3, 2) = (/ &
        & 0.18210e-08_r8,0.34020e-07_r8,0.40366e-07_r8,0.41710e-07_r8,0.42164e-07_r8, &
        & 0.45001e-07_r8,0.49878e-07_r8,0.60009e-07_r8,0.61481e-07_r8 /)
      kao(:, 1, 4, 2) = (/ &
        & 0.21152e-08_r8,0.23706e-07_r8,0.29784e-07_r8,0.35302e-07_r8,0.35282e-07_r8, &
        & 0.34361e-07_r8,0.35938e-07_r8,0.47065e-07_r8,0.17050e-06_r8 /)
      kao(:, 2, 4, 2) = (/ &
        & 0.22014e-08_r8,0.24318e-07_r8,0.33239e-07_r8,0.37390e-07_r8,0.36975e-07_r8, &
        & 0.35774e-07_r8,0.38207e-07_r8,0.49025e-07_r8,0.17312e-06_r8 /)
      kao(:, 3, 4, 2) = (/ &
        & 0.21940e-08_r8,0.26005e-07_r8,0.37067e-07_r8,0.38353e-07_r8,0.38894e-07_r8, &
        & 0.37527e-07_r8,0.40105e-07_r8,0.50082e-07_r8,0.17777e-06_r8 /)
      kao(:, 4, 4, 2) = (/ &
        & 0.23140e-08_r8,0.28378e-07_r8,0.41743e-07_r8,0.40523e-07_r8,0.40492e-07_r8, &
        & 0.38652e-07_r8,0.40876e-07_r8,0.49640e-07_r8,0.18336e-06_r8 /)
      kao(:, 5, 4, 2) = (/ &
        & 0.23213e-08_r8,0.34154e-07_r8,0.50461e-07_r8,0.52357e-07_r8,0.54187e-07_r8, &
        & 0.57113e-07_r8,0.62843e-07_r8,0.77605e-07_r8,0.21695e-06_r8 /)
      kao(:, 1, 5, 2) = (/ &
        & 0.26738e-08_r8,0.26329e-07_r8,0.23971e-07_r8,0.31112e-07_r8,0.35671e-07_r8, &
        & 0.34087e-07_r8,0.29799e-07_r8,0.37789e-07_r8,0.52514e-06_r8 /)
      kao(:, 2, 5, 2) = (/ &
        & 0.25455e-08_r8,0.28564e-07_r8,0.26376e-07_r8,0.34876e-07_r8,0.38195e-07_r8, &
        & 0.36126e-07_r8,0.31889e-07_r8,0.38787e-07_r8,0.53894e-06_r8 /)
      kao(:, 3, 5, 2) = (/ &
        & 0.27955e-08_r8,0.30168e-07_r8,0.29598e-07_r8,0.39256e-07_r8,0.39488e-07_r8, &
        & 0.38121e-07_r8,0.34110e-07_r8,0.40225e-07_r8,0.55617e-06_r8 /)
      kao(:, 4, 5, 2) = (/ &
        & 0.30518e-08_r8,0.31696e-07_r8,0.32642e-07_r8,0.43581e-07_r8,0.40810e-07_r8, &
        & 0.38887e-07_r8,0.35568e-07_r8,0.41837e-07_r8,0.57141e-06_r8 /)
      kao(:, 5, 5, 2) = (/ &
        & 0.29545e-08_r8,0.34626e-07_r8,0.42873e-07_r8,0.52742e-07_r8,0.53043e-07_r8, &
        & 0.52428e-07_r8,0.54304e-07_r8,0.64247e-07_r8,0.63906e-06_r8 /)
      kao(:, 1, 6, 2) = (/ &
        & 0.30127e-08_r8,0.42606e-07_r8,0.28980e-07_r8,0.24923e-07_r8,0.29265e-07_r8, &
        & 0.34534e-07_r8,0.31090e-07_r8,0.30814e-07_r8,0.12844e-05_r8 /)
      kao(:, 2, 6, 2) = (/ &
        & 0.33504e-08_r8,0.42102e-07_r8,0.30491e-07_r8,0.27666e-07_r8,0.33477e-07_r8, &
        & 0.35643e-07_r8,0.33324e-07_r8,0.31448e-07_r8,0.13231e-05_r8 /)
      kao(:, 3, 6, 2) = (/ &
        & 0.37714e-08_r8,0.40516e-07_r8,0.32080e-07_r8,0.30623e-07_r8,0.37391e-07_r8, &
        & 0.37255e-07_r8,0.35144e-07_r8,0.32296e-07_r8,0.13598e-05_r8 /)
      kao(:, 4, 6, 2) = (/ &
        & 0.40809e-08_r8,0.41419e-07_r8,0.33638e-07_r8,0.33756e-07_r8,0.41072e-07_r8, &
        & 0.38814e-07_r8,0.36264e-07_r8,0.33664e-07_r8,0.13955e-05_r8 /)
      kao(:, 5, 6, 2) = (/ &
        & 0.38112e-08_r8,0.42764e-07_r8,0.35694e-07_r8,0.36747e-07_r8,0.45193e-07_r8, &
        & 0.40460e-07_r8,0.37371e-07_r8,0.35107e-07_r8,0.14282e-05_r8 /)
      kao(:, 1, 7, 2) = (/ &
        & 0.36577e-08_r8,0.64857e-07_r8,0.37268e-07_r8,0.28977e-07_r8,0.24480e-07_r8, &
        & 0.26864e-07_r8,0.30486e-07_r8,0.25122e-07_r8,0.20521e-05_r8 /)
      kao(:, 2, 7, 2) = (/ &
        & 0.39427e-08_r8,0.65731e-07_r8,0.37248e-07_r8,0.30585e-07_r8,0.26773e-07_r8, &
        & 0.30114e-07_r8,0.31576e-07_r8,0.26187e-07_r8,0.21480e-05_r8 /)
      kao(:, 3, 7, 2) = (/ &
        & 0.43811e-08_r8,0.66809e-07_r8,0.38170e-07_r8,0.32043e-07_r8,0.28837e-07_r8, &
        & 0.34005e-07_r8,0.32765e-07_r8,0.27322e-07_r8,0.22122e-05_r8 /)
      kao(:, 4, 7, 2) = (/ &
        & 0.46591e-08_r8,0.68244e-07_r8,0.41020e-07_r8,0.34183e-07_r8,0.31347e-07_r8, &
        & 0.37946e-07_r8,0.34473e-07_r8,0.28264e-07_r8,0.22876e-05_r8 /)
      kao(:, 5, 7, 2) = (/ &
        & 0.51635e-08_r8,0.69768e-07_r8,0.42241e-07_r8,0.36125e-07_r8,0.34689e-07_r8, &
        & 0.41422e-07_r8,0.36208e-07_r8,0.29319e-07_r8,0.23528e-05_r8 /)
      kao(:, 1, 8, 2) = (/ &
        & 0.48063e-08_r8,0.99492e-07_r8,0.67977e-07_r8,0.40583e-07_r8,0.27462e-07_r8, &
        & 0.23261e-07_r8,0.24790e-07_r8,0.24175e-07_r8,0.34404e-05_r8 /)
      kao(:, 2, 8, 2) = (/ &
        & 0.46794e-08_r8,0.10207e-06_r8,0.68838e-07_r8,0.41170e-07_r8,0.30068e-07_r8, &
        & 0.24536e-07_r8,0.27696e-07_r8,0.25318e-07_r8,0.35579e-05_r8 /)
      kao(:, 3, 8, 2) = (/ &
        & 0.51560e-08_r8,0.10436e-06_r8,0.69782e-07_r8,0.42105e-07_r8,0.32065e-07_r8, &
        & 0.26776e-07_r8,0.30613e-07_r8,0.26859e-07_r8,0.36807e-05_r8 /)
      kao(:, 4, 8, 2) = (/ &
        & 0.59944e-08_r8,0.10484e-06_r8,0.71027e-07_r8,0.44319e-07_r8,0.34843e-07_r8, &
        & 0.29788e-07_r8,0.33876e-07_r8,0.28922e-07_r8,0.37740e-05_r8 /)
      kao(:, 5, 8, 2) = (/ &
        & 0.64682e-08_r8,0.10541e-06_r8,0.71736e-07_r8,0.46124e-07_r8,0.36934e-07_r8, &
        & 0.32173e-07_r8,0.36502e-07_r8,0.30991e-07_r8,0.38805e-05_r8 /)
      kao(:, 1, 9, 2) = (/ &
        & 0.56433e-08_r8,0.13757e-06_r8,0.10641e-06_r8,0.72870e-07_r8,0.43453e-07_r8, &
        & 0.25530e-07_r8,0.19778e-07_r8,0.25383e-07_r8,0.95912e-05_r8 /)
      kao(:, 2, 9, 2) = (/ &
        & 0.61882e-08_r8,0.14041e-06_r8,0.11046e-06_r8,0.75424e-07_r8,0.44204e-07_r8, &
        & 0.28513e-07_r8,0.22344e-07_r8,0.27258e-07_r8,0.98257e-05_r8 /)
      kao(:, 3, 9, 2) = (/ &
        & 0.68724e-08_r8,0.14355e-06_r8,0.11272e-06_r8,0.76977e-07_r8,0.44934e-07_r8, &
        & 0.30972e-07_r8,0.24609e-07_r8,0.29074e-07_r8,0.10035e-04_r8 /)
      kao(:, 4, 9, 2) = (/ &
        & 0.75288e-08_r8,0.14628e-06_r8,0.11397e-06_r8,0.77508e-07_r8,0.45913e-07_r8, &
        & 0.33498e-07_r8,0.27308e-07_r8,0.31237e-07_r8,0.10206e-04_r8 /)
      kao(:, 5, 9, 2) = (/ &
        & 0.82361e-08_r8,0.14989e-06_r8,0.11575e-06_r8,0.78052e-07_r8,0.47282e-07_r8, &
        & 0.34986e-07_r8,0.29571e-07_r8,0.31933e-07_r8,0.10332e-04_r8 /)
      kao(:, 1,10, 2) = (/ &
        & 0.80705e-08_r8,0.18916e-06_r8,0.16332e-06_r8,0.12182e-06_r8,0.80167e-07_r8, &
        & 0.44659e-07_r8,0.24027e-07_r8,0.20514e-07_r8,0.18076e-04_r8 /)
      kao(:, 2,10, 2) = (/ &
        & 0.86522e-08_r8,0.19825e-06_r8,0.16839e-06_r8,0.12817e-06_r8,0.85984e-07_r8, &
        & 0.48117e-07_r8,0.24937e-07_r8,0.22855e-07_r8,0.18392e-04_r8 /)
      kao(:, 3,10, 2) = (/ &
        & 0.93838e-08_r8,0.20474e-06_r8,0.17472e-06_r8,0.13185e-06_r8,0.89897e-07_r8, &
        & 0.50484e-07_r8,0.27069e-07_r8,0.24729e-07_r8,0.18827e-04_r8 /)
      kao(:, 4,10, 2) = (/ &
        & 0.10442e-07_r8,0.21110e-06_r8,0.17958e-06_r8,0.13546e-06_r8,0.92462e-07_r8, &
        & 0.51368e-07_r8,0.29958e-07_r8,0.26382e-07_r8,0.19325e-04_r8 /)
      kao(:, 5,10, 2) = (/ &
        & 0.11203e-07_r8,0.21676e-06_r8,0.18359e-06_r8,0.14012e-06_r8,0.94090e-07_r8, &
        & 0.51431e-07_r8,0.32637e-07_r8,0.27900e-07_r8,0.19654e-04_r8 /)
      kao(:, 1,11, 2) = (/ &
        & 0.10898e-07_r8,0.20490e-06_r8,0.23352e-06_r8,0.18592e-06_r8,0.13108e-06_r8, &
        & 0.82594e-07_r8,0.41478e-07_r8,0.20359e-07_r8,0.24656e-04_r8 /)
      kao(:, 2,11, 2) = (/ &
        & 0.12100e-07_r8,0.21595e-06_r8,0.24259e-06_r8,0.19598e-06_r8,0.14307e-06_r8, &
        & 0.90287e-07_r8,0.44897e-07_r8,0.21400e-07_r8,0.25439e-04_r8 /)
      kao(:, 3,11, 2) = (/ &
        & 0.12997e-07_r8,0.22559e-06_r8,0.25028e-06_r8,0.20624e-06_r8,0.15074e-06_r8, &
        & 0.95763e-07_r8,0.46972e-07_r8,0.22656e-07_r8,0.26128e-04_r8 /)
      kao(:, 4,11, 2) = (/ &
        & 0.12774e-07_r8,0.23494e-06_r8,0.26130e-06_r8,0.21398e-06_r8,0.15730e-06_r8, &
        & 0.98985e-07_r8,0.48309e-07_r8,0.24026e-07_r8,0.26834e-04_r8 /)
      kao(:, 5,11, 2) = (/ &
        & 0.13184e-07_r8,0.24219e-06_r8,0.26811e-06_r8,0.22059e-06_r8,0.16314e-06_r8, &
        & 0.10271e-06_r8,0.49802e-07_r8,0.25441e-07_r8,0.27644e-04_r8 /)
      kao(:, 1,12, 2) = (/ &
        & 0.11394e-07_r8,0.19172e-06_r8,0.27076e-06_r8,0.23579e-06_r8,0.17648e-06_r8, &
        & 0.11366e-06_r8,0.56463e-07_r8,0.20869e-07_r8,0.27151e-04_r8 /)
      kao(:, 2,12, 2) = (/ &
        & 0.12908e-07_r8,0.20309e-06_r8,0.28462e-06_r8,0.24753e-06_r8,0.18719e-06_r8, &
        & 0.12033e-06_r8,0.60157e-07_r8,0.21646e-07_r8,0.27962e-04_r8 /)
      kao(:, 3,12, 2) = (/ &
        & 0.13752e-07_r8,0.21619e-06_r8,0.29476e-06_r8,0.25594e-06_r8,0.19641e-06_r8, &
        & 0.12734e-06_r8,0.64272e-07_r8,0.22557e-07_r8,0.28912e-04_r8 /)
      kao(:, 4,12, 2) = (/ &
        & 0.14906e-07_r8,0.22665e-06_r8,0.30298e-06_r8,0.26272e-06_r8,0.20331e-06_r8, &
        & 0.13316e-06_r8,0.68243e-07_r8,0.23417e-07_r8,0.29816e-04_r8 /)
      kao(:, 5,12, 2) = (/ &
        & 0.15969e-07_r8,0.23477e-06_r8,0.31068e-06_r8,0.27029e-06_r8,0.20850e-06_r8, &
        & 0.13902e-06_r8,0.71857e-07_r8,0.25264e-07_r8,0.30765e-04_r8 /)
      kao(:, 1,13, 2) = (/ &
        & 0.13593e-07_r8,0.19801e-06_r8,0.26490e-06_r8,0.27826e-06_r8,0.22531e-06_r8, &
        & 0.15112e-06_r8,0.78691e-07_r8,0.27273e-07_r8,0.28055e-04_r8 /)
      kao(:, 2,13, 2) = (/ &
        & 0.15426e-07_r8,0.20839e-06_r8,0.27732e-06_r8,0.28785e-06_r8,0.23371e-06_r8, &
        & 0.16027e-06_r8,0.86131e-07_r8,0.29011e-07_r8,0.29165e-04_r8 /)
      kao(:, 3,13, 2) = (/ &
        & 0.16638e-07_r8,0.21808e-06_r8,0.28896e-06_r8,0.29666e-06_r8,0.24201e-06_r8, &
        & 0.16845e-06_r8,0.91791e-07_r8,0.30670e-07_r8,0.30372e-04_r8 /)
      kao(:, 4,13, 2) = (/ &
        & 0.17929e-07_r8,0.22577e-06_r8,0.29798e-06_r8,0.30533e-06_r8,0.24895e-06_r8, &
        & 0.17573e-06_r8,0.96085e-07_r8,0.31360e-07_r8,0.31437e-04_r8 /)
      kao(:, 5,13, 2) = (/ &
        & 0.18861e-07_r8,0.23397e-06_r8,0.30715e-06_r8,0.31382e-06_r8,0.25665e-06_r8, &
        & 0.18246e-06_r8,0.10017e-06_r8,0.32454e-07_r8,0.32266e-04_r8 /)
      kao(:, 1, 1, 3) = (/ &
        & 0.39751e-08_r8,0.10094e-06_r8,0.20247e-06_r8,0.30028e-06_r8,0.39102e-06_r8, &
        & 0.48711e-06_r8,0.59106e-06_r8,0.72709e-06_r8,0.20885e-06_r8 /)
      kao(:, 2, 1, 3) = (/ &
        & 0.43080e-08_r8,0.10546e-06_r8,0.20982e-06_r8,0.31135e-06_r8,0.40303e-06_r8, &
        & 0.49632e-06_r8,0.59855e-06_r8,0.74477e-06_r8,0.21012e-06_r8 /)
      kao(:, 3, 1, 3) = (/ &
        & 0.42986e-08_r8,0.15269e-06_r8,0.29890e-06_r8,0.43493e-06_r8,0.56429e-06_r8, &
        & 0.69336e-06_r8,0.83181e-06_r8,0.10423e-05_r8,0.36557e-06_r8 /)
      kao(:, 4, 1, 3) = (/ &
        & 0.43554e-08_r8,0.11271e-06_r8,0.22069e-06_r8,0.32651e-06_r8,0.42391e-06_r8, &
        & 0.51393e-06_r8,0.61294e-06_r8,0.75229e-06_r8,0.20945e-06_r8 /)
      kao(:, 5, 1, 3) = (/ &
        & 0.45047e-08_r8,0.11576e-06_r8,0.22657e-06_r8,0.33173e-06_r8,0.43142e-06_r8, &
        & 0.52151e-06_r8,0.61871e-06_r8,0.74980e-06_r8,0.20891e-06_r8 /)
      kao(:, 1, 2, 3) = (/ &
        & 0.46065e-08_r8,0.81519e-07_r8,0.15960e-06_r8,0.23610e-06_r8,0.31656e-06_r8, &
        & 0.39839e-06_r8,0.48591e-06_r8,0.60182e-06_r8,0.18230e-06_r8 /)
      kao(:, 2, 2, 3) = (/ &
        & 0.46837e-08_r8,0.82106e-07_r8,0.16429e-06_r8,0.24471e-06_r8,0.32626e-06_r8, &
        & 0.40531e-06_r8,0.49330e-06_r8,0.61810e-06_r8,0.18355e-06_r8 /)
      kao(:, 3, 2, 3) = (/ &
        & 0.50163e-08_r8,0.12328e-06_r8,0.23602e-06_r8,0.35332e-06_r8,0.46387e-06_r8, &
        & 0.57515e-06_r8,0.69445e-06_r8,0.88167e-06_r8,0.30546e-06_r8 /)
      kao(:, 4, 2, 3) = (/ &
        & 0.49809e-08_r8,0.12454e-06_r8,0.23839e-06_r8,0.35429e-06_r8,0.46515e-06_r8, &
        & 0.57491e-06_r8,0.69031e-06_r8,0.86630e-06_r8,0.29807e-06_r8 /)
      kao(:, 5, 2, 3) = (/ &
        & 0.51988e-08_r8,0.91291e-07_r8,0.17869e-06_r8,0.26485e-06_r8,0.34907e-06_r8, &
        & 0.42509e-06_r8,0.50894e-06_r8,0.62361e-06_r8,0.18234e-06_r8 /)
      kao(:, 1, 3, 3) = (/ &
        & 0.51916e-08_r8,0.88867e-07_r8,0.12220e-06_r8,0.18411e-06_r8,0.24720e-06_r8, &
        & 0.32303e-06_r8,0.39526e-06_r8,0.49595e-06_r8,0.27125e-06_r8 /)
      kao(:, 2, 3, 3) = (/ &
        & 0.56319e-08_r8,0.87189e-07_r8,0.12678e-06_r8,0.19176e-06_r8,0.25624e-06_r8, &
        & 0.32740e-06_r8,0.40564e-06_r8,0.50601e-06_r8,0.28010e-06_r8 /)
      kao(:, 3, 3, 3) = (/ &
        & 0.59026e-08_r8,0.86017e-07_r8,0.13043e-06_r8,0.19649e-06_r8,0.26497e-06_r8, &
        & 0.33305e-06_r8,0.40679e-06_r8,0.51963e-06_r8,0.28660e-06_r8 /)
      kao(:, 4, 3, 3) = (/ &
        & 0.59909e-08_r8,0.10759e-06_r8,0.18790e-06_r8,0.28104e-06_r8,0.37702e-06_r8, &
        & 0.47222e-06_r8,0.57322e-06_r8,0.72906e-06_r8,0.37657e-06_r8 /)
      kao(:, 5, 3, 3) = (/ &
        & 0.64422e-08_r8,0.89472e-07_r8,0.13687e-06_r8,0.20453e-06_r8,0.27802e-06_r8, &
        & 0.34266e-06_r8,0.41565e-06_r8,0.51746e-06_r8,0.29675e-06_r8 /)
      kao(:, 1, 4, 3) = (/ &
        & 0.62298e-08_r8,0.99509e-07_r8,0.10306e-06_r8,0.14232e-06_r8,0.19390e-06_r8, &
        & 0.25435e-06_r8,0.31764e-06_r8,0.40578e-06_r8,0.49031e-06_r8 /)
      kao(:, 2, 4, 3) = (/ &
        & 0.68419e-08_r8,0.10415e-06_r8,0.10349e-06_r8,0.14672e-06_r8,0.19860e-06_r8, &
        & 0.26012e-06_r8,0.32720e-06_r8,0.41327e-06_r8,0.51522e-06_r8 /)
      kao(:, 3, 4, 3) = (/ &
        & 0.71418e-08_r8,0.10626e-06_r8,0.10522e-06_r8,0.15175e-06_r8,0.20471e-06_r8, &
        & 0.26435e-06_r8,0.33148e-06_r8,0.42294e-06_r8,0.53456e-06_r8 /)
      kao(:, 4, 4, 3) = (/ &
        & 0.72470e-08_r8,0.10891e-06_r8,0.10648e-06_r8,0.15457e-06_r8,0.21007e-06_r8, &
        & 0.26937e-06_r8,0.33376e-06_r8,0.42939e-06_r8,0.55207e-06_r8 /)
      kao(:, 5, 4, 3) = (/ &
        & 0.77585e-08_r8,0.12954e-06_r8,0.14999e-06_r8,0.22224e-06_r8,0.29994e-06_r8, &
        & 0.38053e-06_r8,0.47027e-06_r8,0.60032e-06_r8,0.76592e-06_r8 /)
      kao(:, 1, 5, 3) = (/ &
        & 0.68852e-08_r8,0.11288e-06_r8,0.11969e-06_r8,0.11689e-06_r8,0.14994e-06_r8, &
        & 0.19637e-06_r8,0.25309e-06_r8,0.33018e-06_r8,0.84551e-06_r8 /)
      kao(:, 2, 5, 3) = (/ &
        & 0.75119e-08_r8,0.11838e-06_r8,0.12255e-06_r8,0.11926e-06_r8,0.15341e-06_r8, &
        & 0.20169e-06_r8,0.26231e-06_r8,0.33745e-06_r8,0.85714e-06_r8 /)
      kao(:, 3, 5, 3) = (/ &
        & 0.84416e-08_r8,0.12128e-06_r8,0.12324e-06_r8,0.12015e-06_r8,0.15812e-06_r8, &
        & 0.20463e-06_r8,0.26808e-06_r8,0.34461e-06_r8,0.86734e-06_r8 /)
      kao(:, 4, 5, 3) = (/ &
        & 0.92293e-08_r8,0.12493e-06_r8,0.12330e-06_r8,0.12093e-06_r8,0.16146e-06_r8, &
        & 0.20899e-06_r8,0.26904e-06_r8,0.35101e-06_r8,0.88204e-06_r8 /)
      kao(:, 5, 5, 3) = (/ &
        & 0.10279e-07_r8,0.14631e-06_r8,0.14078e-06_r8,0.17511e-06_r8,0.23546e-06_r8, &
        & 0.30442e-06_r8,0.38374e-06_r8,0.50000e-06_r8,0.10431e-05_r8 /)
      kao(:, 1, 6, 3) = (/ &
        & 0.51921e-08_r8,0.14437e-06_r8,0.12917e-06_r8,0.11673e-06_r8,0.12444e-06_r8, &
        & 0.14966e-06_r8,0.19338e-06_r8,0.26674e-06_r8,0.16987e-05_r8 /)
      kao(:, 2, 6, 3) = (/ &
        & 0.69052e-08_r8,0.14822e-06_r8,0.13564e-06_r8,0.12080e-06_r8,0.12884e-06_r8, &
        & 0.15616e-06_r8,0.20083e-06_r8,0.27373e-06_r8,0.17147e-05_r8 /)
      kao(:, 3, 6, 3) = (/ &
        & 0.93932e-08_r8,0.15309e-06_r8,0.13785e-06_r8,0.12361e-06_r8,0.12904e-06_r8, &
        & 0.16004e-06_r8,0.20790e-06_r8,0.27928e-06_r8,0.17384e-05_r8 /)
      kao(:, 4, 6, 3) = (/ &
        & 0.10364e-07_r8,0.15577e-06_r8,0.14281e-06_r8,0.12445e-06_r8,0.13032e-06_r8, &
        & 0.16178e-06_r8,0.21225e-06_r8,0.28499e-06_r8,0.17733e-05_r8 /)
      kao(:, 5, 6, 3) = (/ &
        & 0.10950e-07_r8,0.15768e-06_r8,0.14728e-06_r8,0.12674e-06_r8,0.12961e-06_r8, &
        & 0.16455e-06_r8,0.21080e-06_r8,0.28744e-06_r8,0.17869e-05_r8 /)
      kao(:, 1, 7, 3) = (/ &
        & 0.51527e-08_r8,0.13331e-06_r8,0.15220e-06_r8,0.13781e-06_r8,0.11791e-06_r8, &
        & 0.12291e-06_r8,0.14839e-06_r8,0.21430e-06_r8,0.45802e-05_r8 /)
      kao(:, 2, 7, 3) = (/ &
        & 0.52409e-08_r8,0.14109e-06_r8,0.15809e-06_r8,0.14393e-06_r8,0.12362e-06_r8, &
        & 0.12831e-06_r8,0.15572e-06_r8,0.22059e-06_r8,0.46088e-05_r8 /)
      kao(:, 3, 7, 3) = (/ &
        & 0.66901e-08_r8,0.14833e-06_r8,0.16524e-06_r8,0.14893e-06_r8,0.12670e-06_r8, &
        & 0.13152e-06_r8,0.16110e-06_r8,0.22404e-06_r8,0.46200e-05_r8 /)
      kao(:, 4, 7, 3) = (/ &
        & 0.90836e-08_r8,0.15267e-06_r8,0.17113e-06_r8,0.15541e-06_r8,0.12966e-06_r8, &
        & 0.13240e-06_r8,0.16410e-06_r8,0.22868e-06_r8,0.45999e-05_r8 /)
      kao(:, 5, 7, 3) = (/ &
        & 0.11721e-07_r8,0.15605e-06_r8,0.17580e-06_r8,0.16064e-06_r8,0.13194e-06_r8, &
        & 0.13127e-06_r8,0.16676e-06_r8,0.23245e-06_r8,0.46103e-05_r8 /)
      kao(:, 1, 8, 3) = (/ &
        & 0.53770e-08_r8,0.12906e-06_r8,0.19117e-06_r8,0.16928e-06_r8,0.14454e-06_r8, &
        & 0.11318e-06_r8,0.12091e-06_r8,0.16771e-06_r8,0.10838e-04_r8 /)
      kao(:, 2, 8, 3) = (/ &
        & 0.71217e-08_r8,0.13171e-06_r8,0.20115e-06_r8,0.17525e-06_r8,0.15189e-06_r8, &
        & 0.11980e-06_r8,0.12589e-06_r8,0.17247e-06_r8,0.10844e-04_r8 /)
      kao(:, 3, 8, 3) = (/ &
        & 0.76051e-08_r8,0.13463e-06_r8,0.20837e-06_r8,0.18092e-06_r8,0.15831e-06_r8, &
        & 0.12491e-06_r8,0.12782e-06_r8,0.17568e-06_r8,0.10855e-04_r8 /)
      kao(:, 4, 8, 3) = (/ &
        & 0.87276e-08_r8,0.14002e-06_r8,0.21488e-06_r8,0.18616e-06_r8,0.16272e-06_r8, &
        & 0.12991e-06_r8,0.13139e-06_r8,0.17775e-06_r8,0.10873e-04_r8 /)
      kao(:, 5, 8, 3) = (/ &
        & 0.98102e-08_r8,0.14390e-06_r8,0.21715e-06_r8,0.19383e-06_r8,0.16843e-06_r8, &
        & 0.13102e-06_r8,0.13320e-06_r8,0.18001e-06_r8,0.10883e-04_r8 /)
      kao(:, 1, 9, 3) = (/ &
        & 0.78846e-08_r8,0.14921e-06_r8,0.16266e-06_r8,0.21810e-06_r8,0.17257e-06_r8, &
        & 0.13914e-06_r8,0.10621e-06_r8,0.13009e-06_r8,0.22193e-04_r8 /)
      kao(:, 2, 9, 3) = (/ &
        & 0.87670e-08_r8,0.15667e-06_r8,0.17179e-06_r8,0.22870e-06_r8,0.18453e-06_r8, &
        & 0.14806e-06_r8,0.11198e-06_r8,0.13228e-06_r8,0.22470e-04_r8 /)
      kao(:, 3, 9, 3) = (/ &
        & 0.94042e-08_r8,0.16331e-06_r8,0.17929e-06_r8,0.23732e-06_r8,0.19309e-06_r8, &
        & 0.15669e-06_r8,0.11769e-06_r8,0.13462e-06_r8,0.22759e-04_r8 /)
      kao(:, 4, 9, 3) = (/ &
        & 0.10052e-07_r8,0.16738e-06_r8,0.18654e-06_r8,0.24428e-06_r8,0.19714e-06_r8, &
        & 0.16469e-06_r8,0.12194e-06_r8,0.13694e-06_r8,0.23037e-04_r8 /)
      kao(:, 5, 9, 3) = (/ &
        & 0.99609e-08_r8,0.16974e-06_r8,0.19096e-06_r8,0.25212e-06_r8,0.20604e-06_r8, &
        & 0.17005e-06_r8,0.12529e-06_r8,0.13965e-06_r8,0.23331e-04_r8 /)
      kao(:, 1,10, 3) = (/ &
        & 0.10600e-07_r8,0.19194e-06_r8,0.19694e-06_r8,0.19228e-06_r8,0.23306e-06_r8, &
        & 0.18017e-06_r8,0.13563e-06_r8,0.11106e-06_r8,0.57833e-04_r8 /)
      kao(:, 2,10, 3) = (/ &
        & 0.11513e-07_r8,0.19670e-06_r8,0.20600e-06_r8,0.20153e-06_r8,0.24712e-06_r8, &
        & 0.19420e-06_r8,0.14374e-06_r8,0.11223e-06_r8,0.59252e-04_r8 /)
      kao(:, 3,10, 3) = (/ &
        & 0.12267e-07_r8,0.20052e-06_r8,0.21125e-06_r8,0.21502e-06_r8,0.25879e-06_r8, &
        & 0.20809e-06_r8,0.15257e-06_r8,0.11412e-06_r8,0.60474e-04_r8 /)
      kao(:, 4,10, 3) = (/ &
        & 0.11377e-07_r8,0.20485e-06_r8,0.21479e-06_r8,0.22527e-06_r8,0.26884e-06_r8, &
        & 0.21723e-06_r8,0.15872e-06_r8,0.11733e-06_r8,0.61380e-04_r8 /)
      kao(:, 5,10, 3) = (/ &
        & 0.12141e-07_r8,0.20611e-06_r8,0.22439e-06_r8,0.22986e-06_r8,0.27411e-06_r8, &
        & 0.22402e-06_r8,0.16342e-06_r8,0.11916e-06_r8,0.62353e-04_r8 /)
      kao(:, 1,11, 3) = (/ &
        & 0.12251e-07_r8,0.29022e-06_r8,0.24496e-06_r8,0.24059e-06_r8,0.21631e-06_r8, &
        & 0.23923e-06_r8,0.16597e-06_r8,0.10842e-06_r8,0.80074e-04_r8 /)
      kao(:, 2,11, 3) = (/ &
        & 0.12224e-07_r8,0.29680e-06_r8,0.25368e-06_r8,0.24691e-06_r8,0.22294e-06_r8, &
        & 0.24912e-06_r8,0.17747e-06_r8,0.10969e-06_r8,0.81125e-04_r8 /)
      kao(:, 3,11, 3) = (/ &
        & 0.14264e-07_r8,0.29886e-06_r8,0.26040e-06_r8,0.25256e-06_r8,0.23184e-06_r8, &
        & 0.25957e-06_r8,0.18845e-06_r8,0.11123e-06_r8,0.82960e-04_r8 /)
      kao(:, 4,11, 3) = (/ &
        & 0.16608e-07_r8,0.30056e-06_r8,0.26198e-06_r8,0.25724e-06_r8,0.23897e-06_r8, &
        & 0.26977e-06_r8,0.19716e-06_r8,0.11521e-06_r8,0.84911e-04_r8 /)
      kao(:, 5,11, 3) = (/ &
        & 0.18982e-07_r8,0.30200e-06_r8,0.26559e-06_r8,0.26090e-06_r8,0.24427e-06_r8, &
        & 0.27763e-06_r8,0.20825e-06_r8,0.11858e-06_r8,0.86586e-04_r8 /)
      kao(:, 1,12, 3) = (/ &
        & 0.16186e-07_r8,0.36864e-06_r8,0.27735e-06_r8,0.24475e-06_r8,0.23659e-06_r8, &
        & 0.20178e-06_r8,0.20651e-06_r8,0.11504e-06_r8,0.90323e-04_r8 /)
      kao(:, 2,12, 3) = (/ &
        & 0.16900e-07_r8,0.36903e-06_r8,0.27865e-06_r8,0.25015e-06_r8,0.24279e-06_r8, &
        & 0.21379e-06_r8,0.22149e-06_r8,0.12739e-06_r8,0.92788e-04_r8 /)
      kao(:, 3,12, 3) = (/ &
        & 0.18900e-07_r8,0.36546e-06_r8,0.28369e-06_r8,0.25919e-06_r8,0.24650e-06_r8, &
        & 0.22349e-06_r8,0.23741e-06_r8,0.13455e-06_r8,0.94381e-04_r8 /)
      kao(:, 4,12, 3) = (/ &
        & 0.24666e-07_r8,0.36289e-06_r8,0.28992e-06_r8,0.26755e-06_r8,0.25261e-06_r8, &
        & 0.23012e-06_r8,0.24862e-06_r8,0.14012e-06_r8,0.95689e-04_r8 /)
      kao(:, 5,12, 3) = (/ &
        & 0.28047e-07_r8,0.36144e-06_r8,0.29439e-06_r8,0.27280e-06_r8,0.25910e-06_r8, &
        & 0.23527e-06_r8,0.25804e-06_r8,0.14441e-06_r8,0.97273e-04_r8 /)
      kao(:, 1,13, 3) = (/ &
        & 0.27099e-07_r8,0.42452e-06_r8,0.36469e-06_r8,0.28012e-06_r8,0.24206e-06_r8, &
        & 0.21452e-06_r8,0.19737e-06_r8,0.12552e-06_r8,0.93221e-04_r8 /)
      kao(:, 2,13, 3) = (/ &
        & 0.30641e-07_r8,0.42348e-06_r8,0.36821e-06_r8,0.29049e-06_r8,0.25191e-06_r8, &
        & 0.22447e-06_r8,0.20459e-06_r8,0.13174e-06_r8,0.95326e-04_r8 /)
      kao(:, 3,13, 3) = (/ &
        & 0.31538e-07_r8,0.42218e-06_r8,0.36978e-06_r8,0.29801e-06_r8,0.26042e-06_r8, &
        & 0.23413e-06_r8,0.21354e-06_r8,0.13999e-06_r8,0.97244e-04_r8 /)
      kao(:, 4,13, 3) = (/ &
        & 0.33087e-07_r8,0.42233e-06_r8,0.36980e-06_r8,0.30223e-06_r8,0.26697e-06_r8, &
        & 0.24077e-06_r8,0.22289e-06_r8,0.14849e-06_r8,0.99282e-04_r8 /)
      kao(:, 5,13, 3) = (/ &
        & 0.35771e-07_r8,0.42124e-06_r8,0.36949e-06_r8,0.30814e-06_r8,0.27423e-06_r8, &
        & 0.24510e-06_r8,0.22998e-06_r8,0.15431e-06_r8,0.10189e-03_r8 /)
      kao(:, 1, 1, 4) = (/ &
        & 0.60599e-08_r8,0.49839e-06_r8,0.90796e-06_r8,0.12825e-05_r8,0.16387e-05_r8, &
        & 0.20000e-05_r8,0.24097e-05_r8,0.30198e-05_r8,0.14012e-05_r8 /)
      kao(:, 2, 1, 4) = (/ &
        & 0.57361e-08_r8,0.51373e-06_r8,0.93344e-06_r8,0.13150e-05_r8,0.16776e-05_r8, &
        & 0.20412e-05_r8,0.24476e-05_r8,0.30155e-05_r8,0.14079e-05_r8 /)
      kao(:, 3, 1, 4) = (/ &
        & 0.61895e-08_r8,0.64074e-06_r8,0.11706e-05_r8,0.16523e-05_r8,0.21138e-05_r8, &
        & 0.25765e-05_r8,0.30714e-05_r8,0.37148e-05_r8,0.20046e-05_r8 /)
      kao(:, 4, 1, 4) = (/ &
        & 0.63590e-08_r8,0.53918e-06_r8,0.97233e-06_r8,0.13614e-05_r8,0.17274e-05_r8, &
        & 0.21018e-05_r8,0.24992e-05_r8,0.30391e-05_r8,0.14106e-05_r8 /)
      kao(:, 5, 1, 4) = (/ &
        & 0.66907e-08_r8,0.54769e-06_r8,0.98459e-06_r8,0.13756e-05_r8,0.17428e-05_r8, &
        & 0.21216e-05_r8,0.25190e-05_r8,0.30528e-05_r8,0.14057e-05_r8 /)
      kao(:, 1, 2, 4) = (/ &
        & 0.63247e-08_r8,0.40976e-06_r8,0.75743e-06_r8,0.10729e-05_r8,0.13776e-05_r8, &
        & 0.16847e-05_r8,0.20386e-05_r8,0.25923e-05_r8,0.11016e-05_r8 /)
      kao(:, 2, 2, 4) = (/ &
        & 0.71971e-08_r8,0.42277e-06_r8,0.77866e-06_r8,0.11006e-05_r8,0.14075e-05_r8, &
        & 0.17208e-05_r8,0.20689e-05_r8,0.25842e-05_r8,0.11093e-05_r8 /)
      kao(:, 3, 2, 4) = (/ &
        & 0.68862e-08_r8,0.54111e-06_r8,0.99924e-06_r8,0.14135e-05_r8,0.18137e-05_r8, &
        & 0.22190e-05_r8,0.26613e-05_r8,0.32636e-05_r8,0.16377e-05_r8 /)
      kao(:, 4, 2, 4) = (/ &
        & 0.74570e-08_r8,0.54374e-06_r8,0.10016e-05_r8,0.14142e-05_r8,0.18118e-05_r8, &
        & 0.22093e-05_r8,0.26451e-05_r8,0.32306e-05_r8,0.16062e-05_r8 /)
      kao(:, 5, 2, 4) = (/ &
        & 0.76975e-08_r8,0.44890e-06_r8,0.82016e-06_r8,0.11488e-05_r8,0.14591e-05_r8, &
        & 0.17814e-05_r8,0.21241e-05_r8,0.26089e-05_r8,0.11145e-05_r8 /)
      kao(:, 1, 3, 4) = (/ &
        & 0.83656e-08_r8,0.31311e-06_r8,0.61949e-06_r8,0.88176e-06_r8,0.11379e-05_r8, &
        & 0.13977e-05_r8,0.17043e-05_r8,0.22078e-05_r8,0.73836e-06_r8 /)
      kao(:, 2, 3, 4) = (/ &
        & 0.85171e-08_r8,0.32573e-06_r8,0.63573e-06_r8,0.90517e-06_r8,0.11641e-05_r8, &
        & 0.14286e-05_r8,0.17247e-05_r8,0.21938e-05_r8,0.74285e-06_r8 /)
      kao(:, 3, 3, 4) = (/ &
        & 0.78702e-08_r8,0.33673e-06_r8,0.64948e-06_r8,0.92347e-06_r8,0.11844e-05_r8, &
        & 0.14525e-05_r8,0.17473e-05_r8,0.21823e-05_r8,0.74417e-06_r8 /)
      kao(:, 4, 3, 4) = (/ &
        & 0.88135e-08_r8,0.44484e-06_r8,0.84006e-06_r8,0.11924e-05_r8,0.15326e-05_r8, &
        & 0.18766e-05_r8,0.22592e-05_r8,0.27980e-05_r8,0.11629e-05_r8 /)
      kao(:, 5, 3, 4) = (/ &
        & 0.83594e-08_r8,0.34852e-06_r8,0.67171e-06_r8,0.94786e-06_r8,0.12080e-05_r8, &
        & 0.14818e-05_r8,0.17721e-05_r8,0.22017e-05_r8,0.74162e-06_r8 /)
      kao(:, 1, 4, 4) = (/ &
        & 0.82233e-08_r8,0.22714e-06_r8,0.49574e-06_r8,0.71618e-06_r8,0.92897e-06_r8, &
        & 0.11522e-05_r8,0.14150e-05_r8,0.18749e-05_r8,0.10829e-05_r8 /)
      kao(:, 2, 4, 4) = (/ &
        & 0.90906e-08_r8,0.23281e-06_r8,0.51082e-06_r8,0.73615e-06_r8,0.95322e-06_r8, &
        & 0.11749e-05_r8,0.14287e-05_r8,0.18456e-05_r8,0.10964e-05_r8 /)
      kao(:, 3, 4, 4) = (/ &
        & 0.10403e-07_r8,0.23873e-06_r8,0.52083e-06_r8,0.75142e-06_r8,0.97057e-06_r8, &
        & 0.11959e-05_r8,0.14456e-05_r8,0.18299e-05_r8,0.11024e-05_r8 /)
      kao(:, 4, 4, 4) = (/ &
        & 0.11681e-07_r8,0.24287e-06_r8,0.52982e-06_r8,0.76518e-06_r8,0.98418e-06_r8, &
        & 0.12105e-05_r8,0.14593e-05_r8,0.18314e-05_r8,0.11002e-05_r8 /)
      kao(:, 5, 4, 4) = (/ &
        & 0.11781e-07_r8,0.32919e-06_r8,0.69041e-06_r8,0.99008e-06_r8,0.12781e-05_r8, &
        & 0.15684e-05_r8,0.18900e-05_r8,0.23626e-05_r8,0.11507e-05_r8 /)
      kao(:, 1, 5, 4) = (/ &
        & 0.10746e-07_r8,0.16960e-06_r8,0.36271e-06_r8,0.57393e-06_r8,0.75088e-06_r8, &
        & 0.94078e-06_r8,0.11700e-05_r8,0.15610e-05_r8,0.23060e-05_r8 /)
      kao(:, 2, 5, 4) = (/ &
        & 0.12322e-07_r8,0.17145e-06_r8,0.37466e-06_r8,0.58975e-06_r8,0.77156e-06_r8, &
        & 0.96051e-06_r8,0.11773e-05_r8,0.15431e-05_r8,0.23550e-05_r8 /)
      kao(:, 3, 5, 4) = (/ &
        & 0.12362e-07_r8,0.17491e-06_r8,0.38517e-06_r8,0.60273e-06_r8,0.78779e-06_r8, &
        & 0.97831e-06_r8,0.11895e-05_r8,0.15264e-05_r8,0.23946e-05_r8 /)
      kao(:, 4, 5, 4) = (/ &
        & 0.11932e-07_r8,0.17603e-06_r8,0.39310e-06_r8,0.61276e-06_r8,0.80198e-06_r8, &
        & 0.99168e-06_r8,0.12014e-05_r8,0.15209e-05_r8,0.24122e-05_r8 /)
      kao(:, 5, 5, 4) = (/ &
        & 0.12827e-07_r8,0.23797e-06_r8,0.54915e-06_r8,0.81314e-06_r8,0.10605e-05_r8, &
        & 0.13079e-05_r8,0.15848e-05_r8,0.19982e-05_r8,0.26265e-05_r8 /)
      kao(:, 1, 6, 4) = (/ &
        & 0.16887e-07_r8,0.16918e-06_r8,0.26182e-06_r8,0.43955e-06_r8,0.59876e-06_r8, &
        & 0.76220e-06_r8,0.96205e-06_r8,0.12977e-05_r8,0.30196e-05_r8 /)
      kao(:, 2, 6, 4) = (/ &
        & 0.16463e-07_r8,0.17256e-06_r8,0.26723e-06_r8,0.45266e-06_r8,0.61330e-06_r8, &
        & 0.77949e-06_r8,0.96881e-06_r8,0.12938e-05_r8,0.31027e-05_r8 /)
      kao(:, 3, 6, 4) = (/ &
        & 0.14297e-07_r8,0.17174e-06_r8,0.27626e-06_r8,0.46141e-06_r8,0.62873e-06_r8, &
        & 0.79335e-06_r8,0.97523e-06_r8,0.12716e-05_r8,0.31487e-05_r8 /)
      kao(:, 4, 6, 4) = (/ &
        & 0.15984e-07_r8,0.17093e-06_r8,0.27951e-06_r8,0.46972e-06_r8,0.64062e-06_r8, &
        & 0.80616e-06_r8,0.98183e-06_r8,0.12602e-05_r8,0.31591e-05_r8 /)
      kao(:, 5, 6, 4) = (/ &
        & 0.17832e-07_r8,0.17197e-06_r8,0.28124e-06_r8,0.47610e-06_r8,0.64900e-06_r8, &
        & 0.81537e-06_r8,0.99403e-06_r8,0.12613e-05_r8,0.32001e-05_r8 /)
      kao(:, 1, 7, 4) = (/ &
        & 0.19543e-07_r8,0.20424e-06_r8,0.20827e-06_r8,0.30613e-06_r8,0.46038e-06_r8, &
        & 0.61052e-06_r8,0.78796e-06_r8,0.10769e-05_r8,0.53495e-05_r8 /)
      kao(:, 2, 7, 4) = (/ &
        & 0.21943e-07_r8,0.20486e-06_r8,0.21292e-06_r8,0.31650e-06_r8,0.47369e-06_r8, &
        & 0.62546e-06_r8,0.78997e-06_r8,0.10696e-05_r8,0.53612e-05_r8 /)
      kao(:, 3, 7, 4) = (/ &
        & 0.23096e-07_r8,0.20519e-06_r8,0.21260e-06_r8,0.32419e-06_r8,0.48522e-06_r8, &
        & 0.63494e-06_r8,0.79556e-06_r8,0.10562e-05_r8,0.54125e-05_r8 /)
      kao(:, 4, 7, 4) = (/ &
        & 0.23811e-07_r8,0.20761e-06_r8,0.21334e-06_r8,0.32752e-06_r8,0.49467e-06_r8, &
        & 0.64456e-06_r8,0.80411e-06_r8,0.10435e-05_r8,0.54920e-05_r8 /)
      kao(:, 5, 7, 4) = (/ &
        & 0.23502e-07_r8,0.20918e-06_r8,0.21430e-06_r8,0.32878e-06_r8,0.50037e-06_r8, &
        & 0.65413e-06_r8,0.80879e-06_r8,0.10409e-05_r8,0.55076e-05_r8 /)
      kao(:, 1, 8, 4) = (/ &
        & 0.28818e-07_r8,0.26386e-06_r8,0.23322e-06_r8,0.23394e-06_r8,0.31766e-06_r8, &
        & 0.47372e-06_r8,0.64268e-06_r8,0.89272e-06_r8,0.10691e-04_r8 /)
      kao(:, 2, 8, 4) = (/ &
        & 0.30094e-07_r8,0.27235e-06_r8,0.23524e-06_r8,0.24245e-06_r8,0.32636e-06_r8, &
        & 0.48411e-06_r8,0.63773e-06_r8,0.88040e-06_r8,0.10770e-04_r8 /)
      kao(:, 3, 8, 4) = (/ &
        & 0.32474e-07_r8,0.27799e-06_r8,0.23717e-06_r8,0.24789e-06_r8,0.33554e-06_r8, &
        & 0.49304e-06_r8,0.64255e-06_r8,0.87788e-06_r8,0.10799e-04_r8 /)
      kao(:, 4, 8, 4) = (/ &
        & 0.33631e-07_r8,0.28020e-06_r8,0.23819e-06_r8,0.25000e-06_r8,0.34187e-06_r8, &
        & 0.49874e-06_r8,0.64803e-06_r8,0.86373e-06_r8,0.10824e-04_r8 /)
      kao(:, 5, 8, 4) = (/ &
        & 0.34597e-07_r8,0.28107e-06_r8,0.24266e-06_r8,0.24933e-06_r8,0.34607e-06_r8, &
        & 0.50692e-06_r8,0.65081e-06_r8,0.85686e-06_r8,0.10819e-04_r8 /)
      kao(:, 1, 9, 4) = (/ &
        & 0.37049e-07_r8,0.33070e-06_r8,0.32147e-06_r8,0.25828e-06_r8,0.24460e-06_r8, &
        & 0.33057e-06_r8,0.51182e-06_r8,0.72970e-06_r8,0.32667e-04_r8 /)
      kao(:, 2, 9, 4) = (/ &
        & 0.39634e-07_r8,0.34282e-06_r8,0.32875e-06_r8,0.26785e-06_r8,0.25757e-06_r8, &
        & 0.33579e-06_r8,0.50462e-06_r8,0.72240e-06_r8,0.32638e-04_r8 /)
      kao(:, 3, 9, 4) = (/ &
        & 0.42012e-07_r8,0.34998e-06_r8,0.33495e-06_r8,0.27514e-06_r8,0.26581e-06_r8, &
        & 0.33988e-06_r8,0.50360e-06_r8,0.72105e-06_r8,0.32828e-04_r8 /)
      kao(:, 4, 9, 4) = (/ &
        & 0.43216e-07_r8,0.35061e-06_r8,0.33953e-06_r8,0.28140e-06_r8,0.27172e-06_r8, &
        & 0.34266e-06_r8,0.50914e-06_r8,0.70829e-06_r8,0.32970e-04_r8 /)
      kao(:, 5, 9, 4) = (/ &
        & 0.43838e-07_r8,0.35447e-06_r8,0.34674e-06_r8,0.28252e-06_r8,0.27122e-06_r8, &
        & 0.34740e-06_r8,0.51058e-06_r8,0.70194e-06_r8,0.33023e-04_r8 /)
      kao(:, 1,10, 4) = (/ &
        & 0.46492e-07_r8,0.34673e-06_r8,0.43959e-06_r8,0.39620e-06_r8,0.30969e-06_r8, &
        & 0.25359e-06_r8,0.35579e-06_r8,0.58999e-06_r8,0.75308e-04_r8 /)
      kao(:, 2,10, 4) = (/ &
        & 0.51642e-07_r8,0.35814e-06_r8,0.45251e-06_r8,0.40694e-06_r8,0.31643e-06_r8, &
        & 0.25658e-06_r8,0.34700e-06_r8,0.58340e-06_r8,0.75445e-04_r8 /)
      kao(:, 3,10, 4) = (/ &
        & 0.55139e-07_r8,0.36959e-06_r8,0.46273e-06_r8,0.41592e-06_r8,0.32168e-06_r8, &
        & 0.26320e-06_r8,0.34598e-06_r8,0.57972e-06_r8,0.75796e-04_r8 /)
      kao(:, 4,10, 4) = (/ &
        & 0.58094e-07_r8,0.37731e-06_r8,0.47160e-06_r8,0.41969e-06_r8,0.32536e-06_r8, &
        & 0.27186e-06_r8,0.34692e-06_r8,0.57173e-06_r8,0.76680e-04_r8 /)
      kao(:, 5,10, 4) = (/ &
        & 0.62665e-07_r8,0.38529e-06_r8,0.47122e-06_r8,0.42322e-06_r8,0.32990e-06_r8, &
        & 0.28125e-06_r8,0.34920e-06_r8,0.56204e-06_r8,0.77515e-04_r8 /)
      kao(:, 1,11, 4) = (/ &
        & 0.71997e-07_r8,0.39039e-06_r8,0.48930e-06_r8,0.52037e-06_r8,0.44835e-06_r8, &
        & 0.32920e-06_r8,0.25424e-06_r8,0.45719e-06_r8,0.97599e-04_r8 /)
      kao(:, 2,11, 4) = (/ &
        & 0.84174e-07_r8,0.39220e-06_r8,0.49753e-06_r8,0.53466e-06_r8,0.46035e-06_r8, &
        & 0.34028e-06_r8,0.25580e-06_r8,0.44804e-06_r8,0.98017e-04_r8 /)
      kao(:, 3,11, 4) = (/ &
        & 0.88241e-07_r8,0.39809e-06_r8,0.50514e-06_r8,0.54464e-06_r8,0.47069e-06_r8, &
        & 0.34919e-06_r8,0.25830e-06_r8,0.44783e-06_r8,0.97609e-04_r8 /)
      kao(:, 4,11, 4) = (/ &
        & 0.93462e-07_r8,0.40271e-06_r8,0.51216e-06_r8,0.55531e-06_r8,0.48178e-06_r8, &
        & 0.35530e-06_r8,0.26505e-06_r8,0.43524e-06_r8,0.97099e-04_r8 /)
      kao(:, 5,11, 4) = (/ &
        & 0.96966e-07_r8,0.40660e-06_r8,0.51682e-06_r8,0.56367e-06_r8,0.48662e-06_r8, &
        & 0.35706e-06_r8,0.26903e-06_r8,0.42986e-06_r8,0.97653e-04_r8 /)
      kao(:, 1,12, 4) = (/ &
        & 0.99102e-07_r8,0.42179e-06_r8,0.46920e-06_r8,0.54974e-06_r8,0.50699e-06_r8, &
        & 0.41543e-06_r8,0.26692e-06_r8,0.34287e-06_r8,0.10692e-03_r8 /)
      kao(:, 2,12, 4) = (/ &
        & 0.10220e-06_r8,0.42343e-06_r8,0.48263e-06_r8,0.56179e-06_r8,0.52088e-06_r8, &
        & 0.42826e-06_r8,0.27416e-06_r8,0.32165e-06_r8,0.10849e-03_r8 /)
      kao(:, 3,12, 4) = (/ &
        & 0.10736e-06_r8,0.42994e-06_r8,0.49237e-06_r8,0.56848e-06_r8,0.53837e-06_r8, &
        & 0.43862e-06_r8,0.28070e-06_r8,0.31402e-06_r8,0.10890e-03_r8 /)
      kao(:, 4,12, 4) = (/ &
        & 0.10535e-06_r8,0.42853e-06_r8,0.49830e-06_r8,0.57259e-06_r8,0.55337e-06_r8, &
        & 0.45117e-06_r8,0.28964e-06_r8,0.30229e-06_r8,0.11005e-03_r8 /)
      kao(:, 5,12, 4) = (/ &
        & 0.10635e-06_r8,0.42826e-06_r8,0.50038e-06_r8,0.57688e-06_r8,0.56182e-06_r8, &
        & 0.45862e-06_r8,0.29473e-06_r8,0.29904e-06_r8,0.11056e-03_r8 /)
      kao(:, 1,13, 4) = (/ &
        & 0.11521e-06_r8,0.43118e-06_r8,0.49222e-06_r8,0.52624e-06_r8,0.55771e-06_r8, &
        & 0.47186e-06_r8,0.32691e-06_r8,0.24833e-06_r8,0.10886e-03_r8 /)
      kao(:, 2,13, 4) = (/ &
        & 0.11730e-06_r8,0.43904e-06_r8,0.49350e-06_r8,0.54164e-06_r8,0.56845e-06_r8, &
        & 0.49098e-06_r8,0.34261e-06_r8,0.23938e-06_r8,0.11077e-03_r8 /)
      kao(:, 3,13, 4) = (/ &
        & 0.11952e-06_r8,0.44327e-06_r8,0.50284e-06_r8,0.55816e-06_r8,0.58198e-06_r8, &
        & 0.50372e-06_r8,0.35861e-06_r8,0.22850e-06_r8,0.11296e-03_r8 /)
      kao(:, 4,13, 4) = (/ &
        & 0.11965e-06_r8,0.44664e-06_r8,0.51058e-06_r8,0.56661e-06_r8,0.59093e-06_r8, &
        & 0.51146e-06_r8,0.36596e-06_r8,0.22349e-06_r8,0.11560e-03_r8 /)
      kao(:, 5,13, 4) = (/ &
        & 0.12171e-06_r8,0.45566e-06_r8,0.52364e-06_r8,0.57439e-06_r8,0.59010e-06_r8, &
        & 0.52011e-06_r8,0.37200e-06_r8,0.22417e-06_r8,0.11598e-03_r8 /)
      kao(:, 1, 1, 5) = (/ &
        & 0.64393e-08_r8,0.14477e-05_r8,0.26383e-05_r8,0.37578e-05_r8,0.48497e-05_r8, &
        & 0.58771e-05_r8,0.69748e-05_r8,0.83337e-05_r8,0.52972e-05_r8 /)
      kao(:, 2, 1, 5) = (/ &
        & 0.74788e-08_r8,0.14813e-05_r8,0.26820e-05_r8,0.38123e-05_r8,0.49043e-05_r8, &
        & 0.59719e-05_r8,0.70794e-05_r8,0.84777e-05_r8,0.53686e-05_r8 /)
      kao(:, 3, 1, 5) = (/ &
        & 0.70698e-08_r8,0.17381e-05_r8,0.31521e-05_r8,0.44815e-05_r8,0.57370e-05_r8, &
        & 0.69696e-05_r8,0.82426e-05_r8,0.98195e-05_r8,0.67445e-05_r8 /)
      kao(:, 4, 1, 5) = (/ &
        & 0.75728e-08_r8,0.15363e-05_r8,0.27544e-05_r8,0.38956e-05_r8,0.49855e-05_r8, &
        & 0.60556e-05_r8,0.72284e-05_r8,0.86770e-05_r8,0.54442e-05_r8 /)
      kao(:, 5, 1, 5) = (/ &
        & 0.72646e-08_r8,0.15573e-05_r8,0.27840e-05_r8,0.39266e-05_r8,0.50091e-05_r8, &
        & 0.60781e-05_r8,0.72327e-05_r8,0.87344e-05_r8,0.54537e-05_r8 /)
      kao(:, 1, 2, 5) = (/ &
        & 0.91682e-08_r8,0.12471e-05_r8,0.22727e-05_r8,0.32462e-05_r8,0.42007e-05_r8, &
        & 0.51012e-05_r8,0.60761e-05_r8,0.73379e-05_r8,0.44448e-05_r8 /)
      kao(:, 2, 2, 5) = (/ &
        & 0.78841e-08_r8,0.12745e-05_r8,0.23098e-05_r8,0.32938e-05_r8,0.42384e-05_r8, &
        & 0.51817e-05_r8,0.61658e-05_r8,0.74615e-05_r8,0.44925e-05_r8 /)
      kao(:, 3, 2, 5) = (/ &
        & 0.88457e-08_r8,0.15305e-05_r8,0.27824e-05_r8,0.39573e-05_r8,0.50820e-05_r8, &
        & 0.61863e-05_r8,0.73547e-05_r8,0.88186e-05_r8,0.58192e-05_r8 /)
      kao(:, 4, 2, 5) = (/ &
        & 0.81699e-08_r8,0.15379e-05_r8,0.27884e-05_r8,0.39554e-05_r8,0.50640e-05_r8, &
        & 0.61598e-05_r8,0.73260e-05_r8,0.88047e-05_r8,0.57596e-05_r8 /)
      kao(:, 5, 2, 5) = (/ &
        & 0.81267e-08_r8,0.13345e-05_r8,0.23941e-05_r8,0.33760e-05_r8,0.43121e-05_r8, &
        & 0.52406e-05_r8,0.62663e-05_r8,0.76657e-05_r8,0.45393e-05_r8 /)
      kao(:, 1, 3, 5) = (/ &
        & 0.91717e-08_r8,0.10541e-05_r8,0.19313e-05_r8,0.27682e-05_r8,0.35915e-05_r8, &
        & 0.43666e-05_r8,0.52222e-05_r8,0.63759e-05_r8,0.36110e-05_r8 /)
      kao(:, 2, 3, 5) = (/ &
        & 0.10331e-07_r8,0.10789e-05_r8,0.19645e-05_r8,0.28075e-05_r8,0.36240e-05_r8, &
        & 0.44392e-05_r8,0.52990e-05_r8,0.64883e-05_r8,0.36530e-05_r8 /)
      kao(:, 3, 3, 5) = (/ &
        & 0.12324e-07_r8,0.10988e-05_r8,0.19944e-05_r8,0.28363e-05_r8,0.36532e-05_r8, &
        & 0.44650e-05_r8,0.53622e-05_r8,0.65761e-05_r8,0.36791e-05_r8 /)
      kao(:, 4, 3, 5) = (/ &
        & 0.11596e-07_r8,0.13389e-05_r8,0.24365e-05_r8,0.34597e-05_r8,0.44354e-05_r8, &
        & 0.54167e-05_r8,0.64681e-05_r8,0.78697e-05_r8,0.48568e-05_r8 /)
      kao(:, 5, 3, 5) = (/ &
        & 0.11476e-07_r8,0.11282e-05_r8,0.20370e-05_r8,0.28768e-05_r8,0.36785e-05_r8, &
        & 0.44764e-05_r8,0.53828e-05_r8,0.66660e-05_r8,0.36841e-05_r8 /)
      kao(:, 1, 4, 5) = (/ &
        & 0.12942e-07_r8,0.87057e-06_r8,0.16185e-05_r8,0.23328e-05_r8,0.30327e-05_r8, &
        & 0.36939e-05_r8,0.44351e-05_r8,0.54720e-05_r8,0.21271e-05_r8 /)
      kao(:, 2, 4, 5) = (/ &
        & 0.12911e-07_r8,0.89351e-06_r8,0.16491e-05_r8,0.23657e-05_r8,0.30660e-05_r8, &
        & 0.37589e-05_r8,0.45049e-05_r8,0.55808e-05_r8,0.21315e-05_r8 /)
      kao(:, 3, 4, 5) = (/ &
        & 0.11919e-07_r8,0.91285e-06_r8,0.16762e-05_r8,0.23907e-05_r8,0.30911e-05_r8, &
        & 0.37889e-05_r8,0.45584e-05_r8,0.56554e-05_r8,0.21302e-05_r8 /)
      kao(:, 4, 4, 5) = (/ &
        & 0.12644e-07_r8,0.92680e-06_r8,0.16966e-05_r8,0.24115e-05_r8,0.31023e-05_r8, &
        & 0.37973e-05_r8,0.46002e-05_r8,0.57029e-05_r8,0.21090e-05_r8 /)
      kao(:, 5, 4, 5) = (/ &
        & 0.14252e-07_r8,0.11501e-05_r8,0.21042e-05_r8,0.29827e-05_r8,0.38200e-05_r8, &
        & 0.46680e-05_r8,0.55977e-05_r8,0.69211e-05_r8,0.32123e-05_r8 /)
      kao(:, 1, 5, 5) = (/ &
        & 0.14457e-07_r8,0.68848e-06_r8,0.13403e-05_r8,0.19448e-05_r8,0.25364e-05_r8, &
        & 0.30956e-05_r8,0.37236e-05_r8,0.46561e-05_r8,0.23476e-05_r8 /)
      kao(:, 2, 5, 5) = (/ &
        & 0.13664e-07_r8,0.70724e-06_r8,0.13666e-05_r8,0.19744e-05_r8,0.25701e-05_r8, &
        & 0.31515e-05_r8,0.37903e-05_r8,0.47386e-05_r8,0.23292e-05_r8 /)
      kao(:, 3, 5, 5) = (/ &
        & 0.16363e-07_r8,0.72382e-06_r8,0.13894e-05_r8,0.19966e-05_r8,0.25908e-05_r8, &
        & 0.31942e-05_r8,0.38380e-05_r8,0.48063e-05_r8,0.23210e-05_r8 /)
      kao(:, 4, 5, 5) = (/ &
        & 0.18854e-07_r8,0.73645e-06_r8,0.14075e-05_r8,0.20143e-05_r8,0.25995e-05_r8, &
        & 0.31924e-05_r8,0.38751e-05_r8,0.48509e-05_r8,0.23084e-05_r8 /)
      kao(:, 5, 5, 5) = (/ &
        & 0.19502e-07_r8,0.95711e-06_r8,0.17948e-05_r8,0.25536e-05_r8,0.32756e-05_r8, &
        & 0.40127e-05_r8,0.48356e-05_r8,0.60502e-05_r8,0.26522e-05_r8 /)
      kao(:, 1, 6, 5) = (/ &
        & 0.20265e-07_r8,0.45716e-06_r8,0.10840e-05_r8,0.16034e-05_r8,0.20999e-05_r8, &
        & 0.25681e-05_r8,0.30977e-05_r8,0.39107e-05_r8,0.52450e-05_r8 /)
      kao(:, 2, 6, 5) = (/ &
        & 0.21598e-07_r8,0.47132e-06_r8,0.11079e-05_r8,0.16263e-05_r8,0.21396e-05_r8, &
        & 0.26164e-05_r8,0.31577e-05_r8,0.39701e-05_r8,0.52182e-05_r8 /)
      kao(:, 3, 6, 5) = (/ &
        & 0.24575e-07_r8,0.48601e-06_r8,0.11257e-05_r8,0.16486e-05_r8,0.21513e-05_r8, &
        & 0.26585e-05_r8,0.32022e-05_r8,0.40354e-05_r8,0.51968e-05_r8 /)
      kao(:, 4, 6, 5) = (/ &
        & 0.24397e-07_r8,0.49804e-06_r8,0.11416e-05_r8,0.16645e-05_r8,0.21605e-05_r8, &
        & 0.26639e-05_r8,0.32353e-05_r8,0.40822e-05_r8,0.51575e-05_r8 /)
      kao(:, 5, 6, 5) = (/ &
        & 0.24456e-07_r8,0.50499e-06_r8,0.11522e-05_r8,0.16738e-05_r8,0.21632e-05_r8, &
        & 0.26629e-05_r8,0.32463e-05_r8,0.41051e-05_r8,0.51085e-05_r8 /)
      kao(:, 1, 7, 5) = (/ &
        & 0.28039e-07_r8,0.29800e-06_r8,0.81783e-06_r8,0.13008e-05_r8,0.17226e-05_r8, &
        & 0.21163e-05_r8,0.25578e-05_r8,0.32519e-05_r8,0.82307e-05_r8 /)
      kao(:, 2, 7, 5) = (/ &
        & 0.29388e-07_r8,0.30492e-06_r8,0.83771e-06_r8,0.13192e-05_r8,0.17591e-05_r8, &
        & 0.21563e-05_r8,0.26128e-05_r8,0.33130e-05_r8,0.81908e-05_r8 /)
      kao(:, 3, 7, 5) = (/ &
        & 0.29556e-07_r8,0.30866e-06_r8,0.85444e-06_r8,0.13376e-05_r8,0.17722e-05_r8, &
        & 0.21943e-05_r8,0.26541e-05_r8,0.33584e-05_r8,0.81819e-05_r8 /)
      kao(:, 4, 7, 5) = (/ &
        & 0.26709e-07_r8,0.30951e-06_r8,0.86739e-06_r8,0.13505e-05_r8,0.17805e-05_r8, &
        & 0.22093e-05_r8,0.26812e-05_r8,0.34009e-05_r8,0.81017e-05_r8 /)
      kao(:, 5, 7, 5) = (/ &
        & 0.27877e-07_r8,0.31158e-06_r8,0.87645e-06_r8,0.13597e-05_r8,0.17817e-05_r8, &
        & 0.22083e-05_r8,0.26996e-05_r8,0.34240e-05_r8,0.80774e-05_r8 /)
      kao(:, 1, 8, 5) = (/ &
        & 0.34498e-07_r8,0.30504e-06_r8,0.50025e-06_r8,0.99104e-06_r8,0.13907e-05_r8, &
        & 0.17284e-05_r8,0.20950e-05_r8,0.26875e-05_r8,0.12492e-04_r8 /)
      kao(:, 2, 8, 5) = (/ &
        & 0.34468e-07_r8,0.31253e-06_r8,0.51376e-06_r8,0.10029e-05_r8,0.14233e-05_r8, &
        & 0.17665e-05_r8,0.21486e-05_r8,0.27439e-05_r8,0.12811e-04_r8 /)
      kao(:, 3, 8, 5) = (/ &
        & 0.33481e-07_r8,0.31885e-06_r8,0.52532e-06_r8,0.10176e-05_r8,0.14361e-05_r8, &
        & 0.18000e-05_r8,0.21864e-05_r8,0.27713e-05_r8,0.12979e-04_r8 /)
      kao(:, 4, 8, 5) = (/ &
        & 0.35023e-07_r8,0.32212e-06_r8,0.53171e-06_r8,0.10292e-05_r8,0.14414e-05_r8, &
        & 0.18222e-05_r8,0.22113e-05_r8,0.28111e-05_r8,0.13061e-04_r8 /)
      kao(:, 5, 8, 5) = (/ &
        & 0.38480e-07_r8,0.32386e-06_r8,0.53818e-06_r8,0.10355e-05_r8,0.14400e-05_r8, &
        & 0.18162e-05_r8,0.22298e-05_r8,0.28367e-05_r8,0.13100e-04_r8 /)
      kao(:, 1, 9, 5) = (/ &
        & 0.41152e-07_r8,0.31870e-06_r8,0.36402e-06_r8,0.61613e-06_r8,0.10619e-05_r8, &
        & 0.13940e-05_r8,0.17098e-05_r8,0.22173e-05_r8,0.27198e-04_r8 /)
      kao(:, 2, 9, 5) = (/ &
        & 0.47020e-07_r8,0.31765e-06_r8,0.37312e-06_r8,0.61961e-06_r8,0.10763e-05_r8, &
        & 0.14273e-05_r8,0.17555e-05_r8,0.22573e-05_r8,0.28218e-04_r8 /)
      kao(:, 3, 9, 5) = (/ &
        & 0.48171e-07_r8,0.31526e-06_r8,0.38468e-06_r8,0.62540e-06_r8,0.10803e-05_r8, &
        & 0.14543e-05_r8,0.17919e-05_r8,0.22822e-05_r8,0.28600e-04_r8 /)
      kao(:, 4, 9, 5) = (/ &
        & 0.52826e-07_r8,0.32481e-06_r8,0.38733e-06_r8,0.62721e-06_r8,0.10854e-05_r8, &
        & 0.14750e-05_r8,0.18124e-05_r8,0.23140e-05_r8,0.29051e-04_r8 /)
      kao(:, 5, 9, 5) = (/ &
        & 0.56456e-07_r8,0.32727e-06_r8,0.38424e-06_r8,0.63178e-06_r8,0.10853e-05_r8, &
        & 0.14692e-05_r8,0.18309e-05_r8,0.23369e-05_r8,0.29958e-04_r8 /)
      kao(:, 1,10, 5) = (/ &
        & 0.62033e-07_r8,0.45418e-06_r8,0.43247e-06_r8,0.44775e-06_r8,0.62834e-06_r8, &
        & 0.10534e-05_r8,0.13865e-05_r8,0.18301e-05_r8,0.47779e-04_r8 /)
      kao(:, 2,10, 5) = (/ &
        & 0.66259e-07_r8,0.45321e-06_r8,0.43983e-06_r8,0.45223e-06_r8,0.63440e-06_r8, &
        & 0.10746e-05_r8,0.14253e-05_r8,0.18534e-05_r8,0.48468e-04_r8 /)
      kao(:, 3,10, 5) = (/ &
        & 0.78966e-07_r8,0.45246e-06_r8,0.44780e-06_r8,0.45868e-06_r8,0.63026e-06_r8, &
        & 0.10842e-05_r8,0.14519e-05_r8,0.18794e-05_r8,0.49251e-04_r8 /)
      kao(:, 4,10, 5) = (/ &
        & 0.87881e-07_r8,0.44642e-06_r8,0.45426e-06_r8,0.46583e-06_r8,0.63116e-06_r8, &
        & 0.10925e-05_r8,0.14710e-05_r8,0.18965e-05_r8,0.49742e-04_r8 /)
      kao(:, 5,10, 5) = (/ &
        & 0.92572e-07_r8,0.44310e-06_r8,0.45326e-06_r8,0.47005e-06_r8,0.63094e-06_r8, &
        & 0.10763e-05_r8,0.14843e-05_r8,0.19214e-05_r8,0.50457e-04_r8 /)
      kao(:, 1,11, 5) = (/ &
        & 0.10522e-06_r8,0.58600e-06_r8,0.57473e-06_r8,0.52150e-06_r8,0.51202e-06_r8, &
        & 0.62383e-06_r8,0.10987e-05_r8,0.15032e-05_r8,0.50557e-04_r8 /)
      kao(:, 2,11, 5) = (/ &
        & 0.98332e-07_r8,0.58669e-06_r8,0.57910e-06_r8,0.52997e-06_r8,0.52591e-06_r8, &
        & 0.62992e-06_r8,0.11144e-05_r8,0.15271e-05_r8,0.52915e-04_r8 /)
      kao(:, 3,11, 5) = (/ &
        & 0.10383e-06_r8,0.58976e-06_r8,0.58650e-06_r8,0.53573e-06_r8,0.53394e-06_r8, &
        & 0.63743e-06_r8,0.11251e-05_r8,0.15415e-05_r8,0.55206e-04_r8 /)
      kao(:, 4,11, 5) = (/ &
        & 0.10626e-06_r8,0.58622e-06_r8,0.58747e-06_r8,0.53868e-06_r8,0.53891e-06_r8, &
        & 0.62645e-06_r8,0.11296e-05_r8,0.15628e-05_r8,0.58020e-04_r8 /)
      kao(:, 5,11, 5) = (/ &
        & 0.10795e-06_r8,0.57800e-06_r8,0.58664e-06_r8,0.53883e-06_r8,0.54784e-06_r8, &
        & 0.62145e-06_r8,0.11279e-05_r8,0.15782e-05_r8,0.60369e-04_r8 /)
      kao(:, 1,12, 5) = (/ &
        & 0.11905e-06_r8,0.60759e-06_r8,0.68611e-06_r8,0.59318e-06_r8,0.53805e-06_r8, &
        & 0.44962e-06_r8,0.74828e-06_r8,0.12279e-05_r8,0.57098e-04_r8 /)
      kao(:, 2,12, 5) = (/ &
        & 0.12660e-06_r8,0.61695e-06_r8,0.68094e-06_r8,0.60079e-06_r8,0.55064e-06_r8, &
        & 0.44953e-06_r8,0.74858e-06_r8,0.12489e-05_r8,0.55969e-04_r8 /)
      kao(:, 3,12, 5) = (/ &
        & 0.12824e-06_r8,0.61561e-06_r8,0.67586e-06_r8,0.61662e-06_r8,0.55533e-06_r8, &
        & 0.46796e-06_r8,0.74406e-06_r8,0.12615e-05_r8,0.57249e-04_r8 /)
      kao(:, 4,12, 5) = (/ &
        & 0.12834e-06_r8,0.62554e-06_r8,0.67923e-06_r8,0.62343e-06_r8,0.55964e-06_r8, &
        & 0.48091e-06_r8,0.73622e-06_r8,0.12795e-05_r8,0.58462e-04_r8 /)
      kao(:, 5,12, 5) = (/ &
        & 0.13022e-06_r8,0.63206e-06_r8,0.68726e-06_r8,0.62663e-06_r8,0.56231e-06_r8, &
        & 0.48008e-06_r8,0.72942e-06_r8,0.12885e-05_r8,0.57642e-04_r8 /)
      kao(:, 1,13, 5) = (/ &
        & 0.15325e-06_r8,0.60909e-06_r8,0.76952e-06_r8,0.71232e-06_r8,0.57983e-06_r8, &
        & 0.50489e-06_r8,0.48627e-06_r8,0.99183e-06_r8,0.58778e-04_r8 /)
      kao(:, 2,13, 5) = (/ &
        & 0.15519e-06_r8,0.62152e-06_r8,0.78639e-06_r8,0.71888e-06_r8,0.59866e-06_r8, &
        & 0.50930e-06_r8,0.48247e-06_r8,0.10069e-05_r8,0.57959e-04_r8 /)
      kao(:, 3,13, 5) = (/ &
        & 0.17242e-06_r8,0.64099e-06_r8,0.78686e-06_r8,0.71502e-06_r8,0.60678e-06_r8, &
        & 0.51633e-06_r8,0.47220e-06_r8,0.10180e-05_r8,0.56844e-04_r8 /)
      kao(:, 4,13, 5) = (/ &
        & 0.18585e-06_r8,0.65002e-06_r8,0.78368e-06_r8,0.71421e-06_r8,0.61538e-06_r8, &
        & 0.52650e-06_r8,0.46857e-06_r8,0.10263e-05_r8,0.55757e-04_r8 /)
      kao(:, 5,13, 5) = (/ &
        & 0.19235e-06_r8,0.64166e-06_r8,0.76203e-06_r8,0.70622e-06_r8,0.61837e-06_r8, &
        & 0.53042e-06_r8,0.45529e-06_r8,0.10275e-05_r8,0.55475e-04_r8 /)
      kao(:, 1, 1, 6) = (/ &
        & 0.95617e-08_r8,0.36774e-05_r8,0.65849e-05_r8,0.92221e-05_r8,0.11700e-04_r8, &
        & 0.14161e-04_r8,0.16732e-04_r8,0.20350e-04_r8,0.14554e-04_r8 /)
      kao(:, 2, 1, 6) = (/ &
        & 0.93327e-08_r8,0.37537e-05_r8,0.66916e-05_r8,0.93495e-05_r8,0.11842e-04_r8, &
        & 0.14289e-04_r8,0.16848e-04_r8,0.20318e-04_r8,0.14747e-04_r8 /)
      kao(:, 3, 1, 6) = (/ &
        & 0.98298e-08_r8,0.41944e-05_r8,0.75022e-05_r8,0.10503e-04_r8,0.13381e-04_r8, &
        & 0.16104e-04_r8,0.19004e-04_r8,0.22601e-04_r8,0.17337e-04_r8 /)
      kao(:, 4, 1, 6) = (/ &
        & 0.92318e-08_r8,0.38872e-05_r8,0.68816e-05_r8,0.95784e-05_r8,0.12112e-04_r8, &
        & 0.14510e-04_r8,0.17052e-04_r8,0.20522e-04_r8,0.14967e-04_r8 /)
      kao(:, 5, 1, 6) = (/ &
        & 0.98053e-08_r8,0.39438e-05_r8,0.69574e-05_r8,0.96665e-05_r8,0.12218e-04_r8, &
        & 0.14607e-04_r8,0.17135e-04_r8,0.20557e-04_r8,0.15005e-04_r8 /)
      kao(:, 1, 2, 6) = (/ &
        & 0.99669e-08_r8,0.32456e-05_r8,0.58216e-05_r8,0.81575e-05_r8,0.10349e-04_r8, &
        & 0.12573e-04_r8,0.14901e-04_r8,0.18163e-04_r8,0.12615e-04_r8 /)
      kao(:, 2, 2, 6) = (/ &
        & 0.12231e-07_r8,0.33138e-05_r8,0.59221e-05_r8,0.82752e-05_r8,0.10501e-04_r8, &
        & 0.12666e-04_r8,0.15004e-04_r8,0.18147e-04_r8,0.12797e-04_r8 /)
      kao(:, 3, 2, 6) = (/ &
        & 0.10745e-07_r8,0.37581e-05_r8,0.67327e-05_r8,0.94426e-05_r8,0.12044e-04_r8, &
        & 0.14533e-04_r8,0.17181e-04_r8,0.20503e-04_r8,0.15464e-04_r8 /)
      kao(:, 4, 2, 6) = (/ &
        & 0.11723e-07_r8,0.37897e-05_r8,0.67581e-05_r8,0.94584e-05_r8,0.12035e-04_r8, &
        & 0.14508e-04_r8,0.17115e-04_r8,0.20450e-04_r8,0.15378e-04_r8 /)
      kao(:, 5, 2, 6) = (/ &
        & 0.10775e-07_r8,0.34864e-05_r8,0.61478e-05_r8,0.85479e-05_r8,0.10823e-04_r8, &
        & 0.12985e-04_r8,0.15273e-04_r8,0.18381e-04_r8,0.12972e-04_r8 /)
      kao(:, 1, 3, 6) = (/ &
        & 0.12159e-07_r8,0.28311e-05_r8,0.50923e-05_r8,0.71433e-05_r8,0.90735e-05_r8, &
        & 0.11042e-04_r8,0.13160e-04_r8,0.16141e-04_r8,0.10790e-04_r8 /)
      kao(:, 2, 3, 6) = (/ &
        & 0.11403e-07_r8,0.28950e-05_r8,0.51829e-05_r8,0.72481e-05_r8,0.92149e-05_r8, &
        & 0.11135e-04_r8,0.13267e-04_r8,0.16084e-04_r8,0.10912e-04_r8 /)
      kao(:, 3, 3, 6) = (/ &
        & 0.12436e-07_r8,0.29531e-05_r8,0.52642e-05_r8,0.73461e-05_r8,0.93337e-05_r8, &
        & 0.11250e-04_r8,0.13358e-04_r8,0.16208e-04_r8,0.10995e-04_r8 /)
      kao(:, 4, 3, 6) = (/ &
        & 0.14856e-07_r8,0.33723e-05_r8,0.60342e-05_r8,0.84579e-05_r8,0.10776e-04_r8, &
        & 0.13025e-04_r8,0.15434e-04_r8,0.18466e-04_r8,0.13550e-04_r8 /)
      kao(:, 5, 3, 6) = (/ &
        & 0.16537e-07_r8,0.30506e-05_r8,0.53821e-05_r8,0.74897e-05_r8,0.94861e-05_r8, &
        & 0.11421e-04_r8,0.13503e-04_r8,0.16308e-04_r8,0.11045e-04_r8 /)
      kao(:, 1, 4, 6) = (/ &
        & 0.13114e-07_r8,0.24467e-05_r8,0.44159e-05_r8,0.61941e-05_r8,0.78845e-05_r8, &
        & 0.96031e-05_r8,0.11513e-04_r8,0.14234e-04_r8,0.89642e-05_r8 /)
      kao(:, 2, 4, 6) = (/ &
        & 0.15028e-07_r8,0.25040e-05_r8,0.44954e-05_r8,0.62931e-05_r8,0.80050e-05_r8, &
        & 0.97056e-05_r8,0.11618e-04_r8,0.14175e-04_r8,0.90802e-05_r8 /)
      kao(:, 3, 4, 6) = (/ &
        & 0.18213e-07_r8,0.25556e-05_r8,0.45678e-05_r8,0.63789e-05_r8,0.81071e-05_r8, &
        & 0.98077e-05_r8,0.11694e-04_r8,0.14301e-04_r8,0.91538e-05_r8 /)
      kao(:, 4, 4, 6) = (/ &
        & 0.19097e-07_r8,0.26037e-05_r8,0.46288e-05_r8,0.64476e-05_r8,0.81897e-05_r8, &
        & 0.98941e-05_r8,0.11740e-04_r8,0.14344e-04_r8,0.91968e-05_r8 /)
      kao(:, 5, 4, 6) = (/ &
        & 0.18014e-07_r8,0.29993e-05_r8,0.53622e-05_r8,0.75209e-05_r8,0.95686e-05_r8, &
        & 0.11571e-04_r8,0.13783e-04_r8,0.16522e-04_r8,0.11644e-04_r8 /)
      kao(:, 1, 5, 6) = (/ &
        & 0.21237e-07_r8,0.20921e-05_r8,0.37961e-05_r8,0.53264e-05_r8,0.67905e-05_r8, &
        & 0.82846e-05_r8,0.99803e-05_r8,0.12512e-04_r8,0.44075e-05_r8 /)
      kao(:, 2, 5, 6) = (/ &
        & 0.23885e-07_r8,0.21444e-05_r8,0.38676e-05_r8,0.54146e-05_r8,0.68931e-05_r8, &
        & 0.83832e-05_r8,0.10077e-04_r8,0.12417e-04_r8,0.44982e-05_r8 /)
      kao(:, 3, 5, 6) = (/ &
        & 0.20851e-07_r8,0.21906e-05_r8,0.39301e-05_r8,0.54900e-05_r8,0.69833e-05_r8, &
        & 0.84513e-05_r8,0.10145e-04_r8,0.12513e-04_r8,0.45299e-05_r8 /)
      kao(:, 4, 5, 6) = (/ &
        & 0.22487e-07_r8,0.22322e-05_r8,0.39843e-05_r8,0.55506e-05_r8,0.70502e-05_r8, &
        & 0.85357e-05_r8,0.10189e-04_r8,0.12546e-04_r8,0.45220e-05_r8 /)
      kao(:, 5, 5, 6) = (/ &
        & 0.23015e-07_r8,0.26442e-05_r8,0.47363e-05_r8,0.66520e-05_r8,0.84676e-05_r8, &
        & 0.10272e-04_r8,0.12268e-04_r8,0.14801e-04_r8,0.72945e-05_r8 /)
      kao(:, 1, 6, 6) = (/ &
        & 0.22693e-07_r8,0.17592e-05_r8,0.32289e-05_r8,0.45327e-05_r8,0.57876e-05_r8, &
        & 0.70822e-05_r8,0.85643e-05_r8,0.10966e-04_r8,0.53375e-05_r8 /)
      kao(:, 2, 6, 6) = (/ &
        & 0.22407e-07_r8,0.18081e-05_r8,0.32912e-05_r8,0.46136e-05_r8,0.58716e-05_r8, &
        & 0.71710e-05_r8,0.86530e-05_r8,0.10805e-04_r8,0.53845e-05_r8 /)
      kao(:, 3, 6, 6) = (/ &
        & 0.22705e-07_r8,0.18504e-05_r8,0.33475e-05_r8,0.46786e-05_r8,0.59585e-05_r8, &
        & 0.72252e-05_r8,0.87123e-05_r8,0.10876e-04_r8,0.53808e-05_r8 /)
      kao(:, 4, 6, 6) = (/ &
        & 0.23941e-07_r8,0.18862e-05_r8,0.33938e-05_r8,0.47325e-05_r8,0.60159e-05_r8, &
        & 0.72910e-05_r8,0.87573e-05_r8,0.10893e-04_r8,0.53357e-05_r8 /)
      kao(:, 5, 6, 6) = (/ &
        & 0.27004e-07_r8,0.19136e-05_r8,0.34294e-05_r8,0.47766e-05_r8,0.60573e-05_r8, &
        & 0.73309e-05_r8,0.87892e-05_r8,0.10892e-04_r8,0.52484e-05_r8 /)
      kao(:, 1, 7, 6) = (/ &
        & 0.27131e-07_r8,0.14236e-05_r8,0.27128e-05_r8,0.38203e-05_r8,0.48870e-05_r8, &
        & 0.59983e-05_r8,0.72827e-05_r8,0.94729e-05_r8,0.86942e-05_r8 /)
      kao(:, 2, 7, 6) = (/ &
        & 0.26214e-07_r8,0.14673e-05_r8,0.27677e-05_r8,0.38940e-05_r8,0.49627e-05_r8, &
        & 0.60727e-05_r8,0.73587e-05_r8,0.93332e-05_r8,0.87651e-05_r8 /)
      kao(:, 3, 7, 6) = (/ &
        & 0.29249e-07_r8,0.15085e-05_r8,0.28175e-05_r8,0.39503e-05_r8,0.50362e-05_r8, &
        & 0.61230e-05_r8,0.74095e-05_r8,0.93608e-05_r8,0.87497e-05_r8 /)
      kao(:, 4, 7, 6) = (/ &
        & 0.35846e-07_r8,0.15423e-05_r8,0.28570e-05_r8,0.39988e-05_r8,0.50875e-05_r8, &
        & 0.61709e-05_r8,0.74491e-05_r8,0.93691e-05_r8,0.88300e-05_r8 /)
      kao(:, 5, 7, 6) = (/ &
        & 0.36255e-07_r8,0.15665e-05_r8,0.28868e-05_r8,0.40378e-05_r8,0.51248e-05_r8, &
        & 0.62083e-05_r8,0.74689e-05_r8,0.93597e-05_r8,0.88065e-05_r8 /)
      kao(:, 1, 8, 6) = (/ &
        & 0.37619e-07_r8,0.92017e-06_r8,0.22295e-05_r8,0.31821e-05_r8,0.40883e-05_r8, &
        & 0.50331e-05_r8,0.61447e-05_r8,0.80461e-05_r8,0.15512e-04_r8 /)
      kao(:, 2, 8, 6) = (/ &
        & 0.43015e-07_r8,0.95048e-06_r8,0.22782e-05_r8,0.32493e-05_r8,0.41585e-05_r8, &
        & 0.50968e-05_r8,0.61995e-05_r8,0.80232e-05_r8,0.15472e-04_r8 /)
      kao(:, 3, 8, 6) = (/ &
        & 0.47635e-07_r8,0.97934e-06_r8,0.23207e-05_r8,0.33002e-05_r8,0.42181e-05_r8, &
        & 0.51430e-05_r8,0.62468e-05_r8,0.79821e-05_r8,0.15652e-04_r8 /)
      kao(:, 4, 8, 6) = (/ &
        & 0.48140e-07_r8,0.10026e-05_r8,0.23582e-05_r8,0.33416e-05_r8,0.42650e-05_r8, &
        & 0.51734e-05_r8,0.62779e-05_r8,0.79833e-05_r8,0.15762e-04_r8 /)
      kao(:, 5, 8, 6) = (/ &
        & 0.45231e-07_r8,0.10212e-05_r8,0.23819e-05_r8,0.33754e-05_r8,0.42991e-05_r8, &
        & 0.52146e-05_r8,0.62945e-05_r8,0.79701e-05_r8,0.15840e-04_r8 /)
      kao(:, 1, 9, 6) = (/ &
        & 0.48601e-07_r8,0.49350e-06_r8,0.16585e-05_r8,0.26009e-05_r8,0.33796e-05_r8, &
        & 0.41888e-05_r8,0.51434e-05_r8,0.67867e-05_r8,0.26875e-04_r8 /)
      kao(:, 2, 9, 6) = (/ &
        & 0.49825e-07_r8,0.51680e-06_r8,0.16935e-05_r8,0.26607e-05_r8,0.34457e-05_r8, &
        & 0.42434e-05_r8,0.51839e-05_r8,0.68587e-05_r8,0.27475e-04_r8 /)
      kao(:, 3, 9, 6) = (/ &
        & 0.52843e-07_r8,0.53573e-06_r8,0.17199e-05_r8,0.27038e-05_r8,0.35027e-05_r8, &
        & 0.42858e-05_r8,0.52233e-05_r8,0.67410e-05_r8,0.28097e-04_r8 /)
      kao(:, 4, 9, 6) = (/ &
        & 0.49841e-07_r8,0.54248e-06_r8,0.17493e-05_r8,0.27418e-05_r8,0.35427e-05_r8, &
        & 0.43127e-05_r8,0.52517e-05_r8,0.67418e-05_r8,0.28632e-04_r8 /)
      kao(:, 5, 9, 6) = (/ &
        & 0.50649e-07_r8,0.54940e-06_r8,0.17700e-05_r8,0.27695e-05_r8,0.35712e-05_r8, &
        & 0.43482e-05_r8,0.52645e-05_r8,0.67282e-05_r8,0.28662e-04_r8 /)
      kao(:, 1,10, 6) = (/ &
        & 0.82685e-07_r8,0.54022e-06_r8,0.87761e-06_r8,0.18752e-05_r8,0.27293e-05_r8, &
        & 0.34506e-05_r8,0.42821e-05_r8,0.56501e-05_r8,0.44067e-04_r8 /)
      kao(:, 2,10, 6) = (/ &
        & 0.87011e-07_r8,0.54017e-06_r8,0.89732e-06_r8,0.19208e-05_r8,0.27945e-05_r8, &
        & 0.35005e-05_r8,0.43124e-05_r8,0.57881e-05_r8,0.45858e-04_r8 /)
      kao(:, 3,10, 6) = (/ &
        & 0.79909e-07_r8,0.55355e-06_r8,0.90995e-06_r8,0.19451e-05_r8,0.28460e-05_r8, &
        & 0.35425e-05_r8,0.43438e-05_r8,0.56593e-05_r8,0.45805e-04_r8 /)
      kao(:, 4,10, 6) = (/ &
        & 0.75533e-07_r8,0.55705e-06_r8,0.92147e-06_r8,0.19661e-05_r8,0.28785e-05_r8, &
        & 0.35628e-05_r8,0.43635e-05_r8,0.56526e-05_r8,0.46295e-04_r8 /)
      kao(:, 5,10, 6) = (/ &
        & 0.76631e-07_r8,0.55159e-06_r8,0.93362e-06_r8,0.19832e-05_r8,0.29003e-05_r8, &
        & 0.35965e-05_r8,0.43731e-05_r8,0.56385e-05_r8,0.46720e-04_r8 /)
      kao(:, 1,11, 6) = (/ &
        & 0.11164e-06_r8,0.57710e-06_r8,0.71279e-06_r8,0.10003e-05_r8,0.19253e-05_r8, &
        & 0.28027e-05_r8,0.35523e-05_r8,0.47607e-05_r8,0.51144e-04_r8 /)
      kao(:, 2,11, 6) = (/ &
        & 0.11484e-06_r8,0.58649e-06_r8,0.71918e-06_r8,0.10167e-05_r8,0.19538e-05_r8, &
        & 0.28431e-05_r8,0.35713e-05_r8,0.48333e-05_r8,0.49887e-04_r8 /)
      kao(:, 3,11, 6) = (/ &
        & 0.11442e-06_r8,0.58483e-06_r8,0.70503e-06_r8,0.10320e-05_r8,0.19684e-05_r8, &
        & 0.28674e-05_r8,0.35911e-05_r8,0.47191e-05_r8,0.50222e-04_r8 /)
      kao(:, 4,11, 6) = (/ &
        & 0.11737e-06_r8,0.58895e-06_r8,0.70242e-06_r8,0.10442e-05_r8,0.19738e-05_r8, &
        & 0.28962e-05_r8,0.36035e-05_r8,0.47045e-05_r8,0.48754e-04_r8 /)
      kao(:, 5,11, 6) = (/ &
        & 0.12314e-06_r8,0.59299e-06_r8,0.70874e-06_r8,0.10470e-05_r8,0.19736e-05_r8, &
        & 0.29100e-05_r8,0.36075e-05_r8,0.46813e-05_r8,0.45986e-04_r8 /)
      kao(:, 1,12, 6) = (/ &
        & 0.14446e-06_r8,0.57459e-06_r8,0.72800e-06_r8,0.69912e-06_r8,0.11693e-05_r8, &
        & 0.21457e-05_r8,0.29151e-05_r8,0.39683e-05_r8,0.42970e-04_r8 /)
      kao(:, 2,12, 6) = (/ &
        & 0.14738e-06_r8,0.58568e-06_r8,0.75374e-06_r8,0.69814e-06_r8,0.11797e-05_r8, &
        & 0.21759e-05_r8,0.29287e-05_r8,0.39942e-05_r8,0.41434e-04_r8 /)
      kao(:, 3,12, 6) = (/ &
        & 0.15006e-06_r8,0.60144e-06_r8,0.75420e-06_r8,0.70559e-06_r8,0.11849e-05_r8, &
        & 0.21718e-05_r8,0.29383e-05_r8,0.39185e-05_r8,0.42909e-04_r8 /)
      kao(:, 4,12, 6) = (/ &
        & 0.15745e-06_r8,0.60776e-06_r8,0.75984e-06_r8,0.71270e-06_r8,0.11804e-05_r8, &
        & 0.21578e-05_r8,0.29477e-05_r8,0.38939e-05_r8,0.41761e-04_r8 /)
      kao(:, 5,12, 6) = (/ &
        & 0.16583e-06_r8,0.62207e-06_r8,0.74591e-06_r8,0.69746e-06_r8,0.11751e-05_r8, &
        & 0.21552e-05_r8,0.29514e-05_r8,0.38695e-05_r8,0.45252e-04_r8 /)
      kao(:, 1,13, 6) = (/ &
        & 0.18492e-06_r8,0.65841e-06_r8,0.74904e-06_r8,0.82698e-06_r8,0.69790e-06_r8, &
        & 0.13356e-05_r8,0.23333e-05_r8,0.33010e-05_r8,0.43502e-04_r8 /)
      kao(:, 2,13, 6) = (/ &
        & 0.18447e-06_r8,0.66115e-06_r8,0.74200e-06_r8,0.80748e-06_r8,0.68676e-06_r8, &
        & 0.13419e-05_r8,0.23369e-05_r8,0.32873e-05_r8,0.44908e-04_r8 /)
      kao(:, 3,13, 6) = (/ &
        & 0.20107e-06_r8,0.65387e-06_r8,0.73155e-06_r8,0.79291e-06_r8,0.67848e-06_r8, &
        & 0.13368e-05_r8,0.23434e-05_r8,0.32337e-05_r8,0.47417e-04_r8 /)
      kao(:, 4,13, 6) = (/ &
        & 0.20493e-06_r8,0.66191e-06_r8,0.72707e-06_r8,0.79839e-06_r8,0.67208e-06_r8, &
        & 0.13273e-05_r8,0.23466e-05_r8,0.32075e-05_r8,0.48703e-04_r8 /)
      kao(:, 5,13, 6) = (/ &
        & 0.20003e-06_r8,0.66753e-06_r8,0.73390e-06_r8,0.79794e-06_r8,0.66936e-06_r8, &
        & 0.13150e-05_r8,0.23558e-05_r8,0.31828e-05_r8,0.50012e-04_r8 /)
      kao(:, 1, 1, 7) = (/ &
        & 0.45955e-07_r8,0.96988e-05_r8,0.16766e-04_r8,0.23073e-04_r8,0.28829e-04_r8, &
        & 0.34350e-04_r8,0.39744e-04_r8,0.45071e-04_r8,0.36783e-04_r8 /)
      kao(:, 2, 1, 7) = (/ &
        & 0.57268e-07_r8,0.98413e-05_r8,0.16970e-04_r8,0.23311e-04_r8,0.29149e-04_r8, &
        & 0.34726e-04_r8,0.40229e-04_r8,0.45682e-04_r8,0.37190e-04_r8 /)
      kao(:, 3, 1, 7) = (/ &
        & 0.70060e-07_r8,0.10517e-04_r8,0.18168e-04_r8,0.24965e-04_r8,0.31264e-04_r8, &
        & 0.37439e-04_r8,0.43299e-04_r8,0.49335e-04_r8,0.41254e-04_r8 /)
      kao(:, 4, 1, 7) = (/ &
        & 0.84370e-07_r8,0.10120e-04_r8,0.17302e-04_r8,0.23633e-04_r8,0.29544e-04_r8, &
        & 0.35368e-04_r8,0.40885e-04_r8,0.46535e-04_r8,0.37819e-04_r8 /)
      kao(:, 5, 1, 7) = (/ &
        & 0.97346e-07_r8,0.10254e-04_r8,0.17458e-04_r8,0.23773e-04_r8,0.29672e-04_r8, &
        & 0.35542e-04_r8,0.41140e-04_r8,0.46864e-04_r8,0.38054e-04_r8 /)
      kao(:, 1, 2, 7) = (/ &
        & 0.27937e-07_r8,0.87332e-05_r8,0.15102e-04_r8,0.20785e-04_r8,0.26002e-04_r8, &
        & 0.30993e-04_r8,0.35918e-04_r8,0.41124e-04_r8,0.32692e-04_r8 /)
      kao(:, 2, 2, 7) = (/ &
        & 0.34502e-07_r8,0.88655e-05_r8,0.15279e-04_r8,0.20992e-04_r8,0.26281e-04_r8, &
        & 0.31393e-04_r8,0.36363e-04_r8,0.41768e-04_r8,0.33047e-04_r8 /)
      kao(:, 3, 2, 7) = (/ &
        & 0.45243e-07_r8,0.95567e-05_r8,0.16535e-04_r8,0.22740e-04_r8,0.28503e-04_r8, &
        & 0.34161e-04_r8,0.39521e-04_r8,0.45509e-04_r8,0.37184e-04_r8 /)
      kao(:, 4, 2, 7) = (/ &
        & 0.56029e-07_r8,0.96404e-05_r8,0.16599e-04_r8,0.22759e-04_r8,0.28526e-04_r8, &
        & 0.34207e-04_r8,0.39586e-04_r8,0.45601e-04_r8,0.37152e-04_r8 /)
      kao(:, 5, 2, 7) = (/ &
        & 0.67453e-07_r8,0.92372e-05_r8,0.15744e-04_r8,0.21435e-04_r8,0.26769e-04_r8, &
        & 0.32085e-04_r8,0.37228e-04_r8,0.42908e-04_r8,0.33841e-04_r8 /)
      kao(:, 1, 3, 7) = (/ &
        & 0.21909e-07_r8,0.77821e-05_r8,0.13457e-04_r8,0.18525e-04_r8,0.23194e-04_r8, &
        & 0.27662e-04_r8,0.32086e-04_r8,0.37089e-04_r8,0.28700e-04_r8 /)
      kao(:, 2, 3, 7) = (/ &
        & 0.25816e-07_r8,0.78998e-05_r8,0.13627e-04_r8,0.18723e-04_r8,0.23459e-04_r8, &
        & 0.28049e-04_r8,0.32494e-04_r8,0.37775e-04_r8,0.29060e-04_r8 /)
      kao(:, 3, 3, 7) = (/ &
        & 0.28009e-07_r8,0.80177e-05_r8,0.13778e-04_r8,0.18883e-04_r8,0.23652e-04_r8, &
        & 0.28348e-04_r8,0.32831e-04_r8,0.38183e-04_r8,0.29363e-04_r8 /)
      kao(:, 4, 3, 7) = (/ &
        & 0.32250e-07_r8,0.87000e-05_r8,0.14997e-04_r8,0.20591e-04_r8,0.25858e-04_r8, &
        & 0.30984e-04_r8,0.35855e-04_r8,0.41716e-04_r8,0.33352e-04_r8 /)
      kao(:, 5, 3, 7) = (/ &
        & 0.38565e-07_r8,0.82442e-05_r8,0.14048e-04_r8,0.19147e-04_r8,0.23963e-04_r8, &
        & 0.28712e-04_r8,0.33322e-04_r8,0.38841e-04_r8,0.29827e-04_r8 /)
      kao(:, 1, 4, 7) = (/ &
        & 0.27845e-07_r8,0.68782e-05_r8,0.11887e-04_r8,0.16370e-04_r8,0.20522e-04_r8, &
        & 0.24507e-04_r8,0.28445e-04_r8,0.33146e-04_r8,0.25091e-04_r8 /)
      kao(:, 2, 4, 7) = (/ &
        & 0.30162e-07_r8,0.69860e-05_r8,0.12053e-04_r8,0.16569e-04_r8,0.20786e-04_r8, &
        & 0.24863e-04_r8,0.28833e-04_r8,0.33823e-04_r8,0.25439e-04_r8 /)
      kao(:, 3, 4, 7) = (/ &
        & 0.31547e-07_r8,0.70934e-05_r8,0.12196e-04_r8,0.16734e-04_r8,0.20984e-04_r8, &
        & 0.25140e-04_r8,0.29167e-04_r8,0.34188e-04_r8,0.25743e-04_r8 /)
      kao(:, 4, 4, 7) = (/ &
        & 0.30733e-07_r8,0.72009e-05_r8,0.12319e-04_r8,0.16870e-04_r8,0.21150e-04_r8, &
        & 0.25350e-04_r8,0.29432e-04_r8,0.34551e-04_r8,0.26011e-04_r8 /)
      kao(:, 5, 4, 7) = (/ &
        & 0.33104e-07_r8,0.78742e-05_r8,0.13511e-04_r8,0.18536e-04_r8,0.23314e-04_r8, &
        & 0.27934e-04_r8,0.32284e-04_r8,0.37983e-04_r8,0.29911e-04_r8 /)
      kao(:, 1, 5, 7) = (/ &
        & 0.31453e-07_r8,0.60344e-05_r8,0.10431e-04_r8,0.14360e-04_r8,0.18025e-04_r8, &
        & 0.21556e-04_r8,0.25057e-04_r8,0.29352e-04_r8,0.21244e-04_r8 /)
      kao(:, 2, 5, 7) = (/ &
        & 0.32645e-07_r8,0.61373e-05_r8,0.10589e-04_r8,0.14561e-04_r8,0.18288e-04_r8, &
        & 0.21896e-04_r8,0.25427e-04_r8,0.30041e-04_r8,0.21582e-04_r8 /)
      kao(:, 3, 5, 7) = (/ &
        & 0.36285e-07_r8,0.62371e-05_r8,0.10724e-04_r8,0.14730e-04_r8,0.18494e-04_r8, &
        & 0.22175e-04_r8,0.25749e-04_r8,0.30401e-04_r8,0.21875e-04_r8 /)
      kao(:, 4, 5, 7) = (/ &
        & 0.35840e-07_r8,0.63361e-05_r8,0.10841e-04_r8,0.14872e-04_r8,0.18672e-04_r8, &
        & 0.22386e-04_r8,0.26001e-04_r8,0.30772e-04_r8,0.22136e-04_r8 /)
      kao(:, 5, 5, 7) = (/ &
        & 0.34391e-07_r8,0.70384e-05_r8,0.12100e-04_r8,0.16639e-04_r8,0.20967e-04_r8, &
        & 0.25106e-04_r8,0.29033e-04_r8,0.34382e-04_r8,0.26458e-04_r8 /)
      kao(:, 1, 6, 7) = (/ &
        & 0.38317e-07_r8,0.52554e-05_r8,0.90847e-05_r8,0.12506e-04_r8,0.15706e-04_r8, &
        & 0.18802e-04_r8,0.21926e-04_r8,0.25721e-04_r8,0.82786e-05_r8 /)
      kao(:, 2, 6, 7) = (/ &
        & 0.42993e-07_r8,0.53521e-05_r8,0.92425e-05_r8,0.12708e-04_r8,0.15965e-04_r8, &
        & 0.19131e-04_r8,0.22269e-04_r8,0.26449e-04_r8,0.85145e-05_r8 /)
      kao(:, 3, 6, 7) = (/ &
        & 0.43612e-07_r8,0.54474e-05_r8,0.93707e-05_r8,0.12875e-04_r8,0.16176e-04_r8, &
        & 0.19407e-04_r8,0.22575e-04_r8,0.26830e-04_r8,0.87594e-05_r8 /)
      kao(:, 4, 6, 7) = (/ &
        & 0.42757e-07_r8,0.55405e-05_r8,0.94823e-05_r8,0.13019e-04_r8,0.16363e-04_r8, &
        & 0.19625e-04_r8,0.22815e-04_r8,0.27200e-04_r8,0.90170e-05_r8 /)
      kao(:, 5, 6, 7) = (/ &
        & 0.43664e-07_r8,0.56274e-05_r8,0.95923e-05_r8,0.13140e-04_r8,0.16520e-04_r8, &
        & 0.19797e-04_r8,0.22995e-04_r8,0.27528e-04_r8,0.91836e-05_r8 /)
      kao(:, 1, 7, 7) = (/ &
        & 0.39995e-07_r8,0.45414e-05_r8,0.78502e-05_r8,0.10801e-04_r8,0.13562e-04_r8, &
        & 0.16248e-04_r8,0.19009e-04_r8,0.22439e-04_r8,0.93804e-05_r8 /)
      kao(:, 2, 7, 7) = (/ &
        & 0.43614e-07_r8,0.46331e-05_r8,0.80059e-05_r8,0.11000e-04_r8,0.13813e-04_r8, &
        & 0.16577e-04_r8,0.19346e-04_r8,0.23103e-04_r8,0.95334e-05_r8 /)
      kao(:, 3, 7, 7) = (/ &
        & 0.45687e-07_r8,0.47201e-05_r8,0.81316e-05_r8,0.11167e-04_r8,0.14031e-04_r8, &
        & 0.16844e-04_r8,0.19646e-04_r8,0.23513e-04_r8,0.96503e-05_r8 /)
      kao(:, 4, 7, 7) = (/ &
        & 0.48386e-07_r8,0.48081e-05_r8,0.82413e-05_r8,0.11310e-04_r8,0.14223e-04_r8, &
        & 0.17063e-04_r8,0.19885e-04_r8,0.23881e-04_r8,0.95360e-05_r8 /)
      kao(:, 5, 7, 7) = (/ &
        & 0.54287e-07_r8,0.48899e-05_r8,0.83473e-05_r8,0.11434e-04_r8,0.14383e-04_r8, &
        & 0.17240e-04_r8,0.20064e-04_r8,0.24201e-04_r8,0.94267e-05_r8 /)
      kao(:, 1, 8, 7) = (/ &
        & 0.45720e-07_r8,0.38685e-05_r8,0.67269e-05_r8,0.92537e-05_r8,0.11613e-04_r8, &
        & 0.13930e-04_r8,0.16333e-04_r8,0.19500e-04_r8,0.15537e-04_r8 /)
      kao(:, 2, 8, 7) = (/ &
        & 0.46817e-07_r8,0.39568e-05_r8,0.68775e-05_r8,0.94493e-05_r8,0.11857e-04_r8, &
        & 0.14250e-04_r8,0.16679e-04_r8,0.19983e-04_r8,0.15822e-04_r8 /)
      kao(:, 3, 8, 7) = (/ &
        & 0.48700e-07_r8,0.40362e-05_r8,0.70012e-05_r8,0.96148e-05_r8,0.12076e-04_r8, &
        & 0.14508e-04_r8,0.16969e-04_r8,0.20440e-04_r8,0.15878e-04_r8 /)
      kao(:, 4, 8, 7) = (/ &
        & 0.54460e-07_r8,0.41199e-05_r8,0.71098e-05_r8,0.97580e-05_r8,0.12268e-04_r8, &
        & 0.14725e-04_r8,0.17206e-04_r8,0.20805e-04_r8,0.16014e-04_r8 /)
      kao(:, 5, 8, 7) = (/ &
        & 0.59565e-07_r8,0.42000e-05_r8,0.72128e-05_r8,0.98789e-05_r8,0.12424e-04_r8, &
        & 0.14896e-04_r8,0.17382e-04_r8,0.21113e-04_r8,0.15894e-04_r8 /)
      kao(:, 1, 9, 7) = (/ &
        & 0.60502e-07_r8,0.31758e-05_r8,0.57011e-05_r8,0.78602e-05_r8,0.98646e-05_r8, &
        & 0.11842e-04_r8,0.13914e-04_r8,0.16812e-04_r8,0.32738e-04_r8 /)
      kao(:, 2, 9, 7) = (/ &
        & 0.61920e-07_r8,0.32583e-05_r8,0.58474e-05_r8,0.80501e-05_r8,0.10097e-04_r8, &
        & 0.12150e-04_r8,0.14260e-04_r8,0.17128e-04_r8,0.32707e-04_r8 /)
      kao(:, 3, 9, 7) = (/ &
        & 0.66102e-07_r8,0.33410e-05_r8,0.59686e-05_r8,0.82148e-05_r8,0.10310e-04_r8, &
        & 0.12398e-04_r8,0.14542e-04_r8,0.17650e-04_r8,0.33629e-04_r8 /)
      kao(:, 4, 9, 7) = (/ &
        & 0.86168e-07_r8,0.34261e-05_r8,0.60763e-05_r8,0.83539e-05_r8,0.10496e-04_r8, &
        & 0.12604e-04_r8,0.14773e-04_r8,0.17994e-04_r8,0.33878e-04_r8 /)
      kao(:, 5, 9, 7) = (/ &
        & 0.91586e-07_r8,0.35057e-05_r8,0.61764e-05_r8,0.84703e-05_r8,0.10646e-04_r8, &
        & 0.12765e-04_r8,0.14939e-04_r8,0.18282e-04_r8,0.33645e-04_r8 /)
      kao(:, 1,10, 7) = (/ &
        & 0.96997e-07_r8,0.19211e-05_r8,0.47098e-05_r8,0.66155e-05_r8,0.83225e-05_r8, &
        & 0.10005e-04_r8,0.11773e-04_r8,0.14404e-04_r8,0.53631e-04_r8 /)
      kao(:, 2,10, 7) = (/ &
        & 0.96064e-07_r8,0.20141e-05_r8,0.48491e-05_r8,0.67941e-05_r8,0.85382e-05_r8, &
        & 0.10290e-04_r8,0.12102e-04_r8,0.14626e-04_r8,0.54289e-04_r8 /)
      kao(:, 3,10, 7) = (/ &
        & 0.10431e-06_r8,0.20834e-05_r8,0.49690e-05_r8,0.69520e-05_r8,0.87398e-05_r8, &
        & 0.10520e-04_r8,0.12369e-04_r8,0.15124e-04_r8,0.55603e-04_r8 /)
      kao(:, 4,10, 7) = (/ &
        & 0.11432e-06_r8,0.21653e-05_r8,0.50755e-05_r8,0.70852e-05_r8,0.89148e-05_r8, &
        & 0.10714e-04_r8,0.12591e-04_r8,0.15457e-04_r8,0.56630e-04_r8 /)
      kao(:, 5,10, 7) = (/ &
        & 0.11074e-06_r8,0.22480e-05_r8,0.51732e-05_r8,0.71951e-05_r8,0.90530e-05_r8, &
        & 0.10860e-04_r8,0.12745e-04_r8,0.15721e-04_r8,0.54963e-04_r8 /)
      kao(:, 1,11, 7) = (/ &
        & 0.15854e-06_r8,0.91297e-06_r8,0.32555e-05_r8,0.55113e-05_r8,0.70464e-05_r8, &
        & 0.85121e-05_r8,0.10027e-04_r8,0.12303e-04_r8,0.52607e-04_r8 /)
      kao(:, 2,11, 7) = (/ &
        & 0.16751e-06_r8,0.96634e-06_r8,0.33790e-05_r8,0.56722e-05_r8,0.72351e-05_r8, &
        & 0.87519e-05_r8,0.10311e-04_r8,0.12547e-04_r8,0.52883e-04_r8 /)
      kao(:, 3,11, 7) = (/ &
        & 0.16741e-06_r8,0.10318e-05_r8,0.35064e-05_r8,0.58058e-05_r8,0.74099e-05_r8, &
        & 0.89413e-05_r8,0.10546e-04_r8,0.12998e-04_r8,0.52407e-04_r8 /)
      kao(:, 4,11, 7) = (/ &
        & 0.16708e-06_r8,0.10925e-05_r8,0.36064e-05_r8,0.59145e-05_r8,0.75531e-05_r8, &
        & 0.90996e-05_r8,0.10715e-04_r8,0.13285e-04_r8,0.53203e-04_r8 /)
      kao(:, 5,11, 7) = (/ &
        & 0.16578e-06_r8,0.11490e-05_r8,0.36852e-05_r8,0.60104e-05_r8,0.76652e-05_r8, &
        & 0.92182e-05_r8,0.10838e-04_r8,0.13496e-04_r8,0.54467e-04_r8 /)
      kao(:, 1,12, 7) = (/ &
        & 0.17287e-06_r8,0.67222e-06_r8,0.20177e-05_r8,0.42045e-05_r8,0.58863e-05_r8, &
        & 0.71911e-05_r8,0.84904e-05_r8,0.10467e-04_r8,0.53824e-04_r8 /)
      kao(:, 2,12, 7) = (/ &
        & 0.17534e-06_r8,0.66930e-06_r8,0.20902e-05_r8,0.43510e-05_r8,0.60518e-05_r8, &
        & 0.73834e-05_r8,0.87285e-05_r8,0.10723e-04_r8,0.57713e-04_r8 /)
      kao(:, 3,12, 7) = (/ &
        & 0.19862e-06_r8,0.69271e-06_r8,0.21807e-05_r8,0.44473e-05_r8,0.61938e-05_r8, &
        & 0.75395e-05_r8,0.89230e-05_r8,0.11082e-04_r8,0.58727e-04_r8 /)
      kao(:, 4,12, 7) = (/ &
        & 0.20481e-06_r8,0.70155e-06_r8,0.22437e-05_r8,0.45330e-05_r8,0.63072e-05_r8, &
        & 0.76639e-05_r8,0.90515e-05_r8,0.11316e-04_r8,0.62478e-04_r8 /)
      kao(:, 5,12, 7) = (/ &
        & 0.22362e-06_r8,0.66686e-06_r8,0.23107e-05_r8,0.46277e-05_r8,0.64004e-05_r8, &
        & 0.77560e-05_r8,0.91460e-05_r8,0.11480e-04_r8,0.61459e-04_r8 /)
      kao(:, 1,13, 7) = (/ &
        & 0.24394e-06_r8,0.78850e-06_r8,0.10005e-05_r8,0.25869e-05_r8,0.46671e-05_r8, &
        & 0.60110e-05_r8,0.71462e-05_r8,0.88357e-05_r8,0.59707e-04_r8 /)
      kao(:, 2,13, 7) = (/ &
        & 0.25387e-06_r8,0.77656e-06_r8,0.10565e-05_r8,0.27093e-05_r8,0.48105e-05_r8, &
        & 0.61610e-05_r8,0.73436e-05_r8,0.90989e-05_r8,0.60151e-04_r8 /)
      kao(:, 3,13, 7) = (/ &
        & 0.22260e-06_r8,0.76604e-06_r8,0.11188e-05_r8,0.28168e-05_r8,0.49259e-05_r8, &
        & 0.62864e-05_r8,0.74912e-05_r8,0.93777e-05_r8,0.58560e-04_r8 /)
      kao(:, 4,13, 7) = (/ &
        & 0.22499e-06_r8,0.75979e-06_r8,0.11746e-05_r8,0.28869e-05_r8,0.50154e-05_r8, &
        & 0.63819e-05_r8,0.75933e-05_r8,0.95633e-05_r8,0.61656e-04_r8 /)
      kao(:, 5,13, 7) = (/ &
        & 0.22527e-06_r8,0.74699e-06_r8,0.12195e-05_r8,0.29526e-05_r8,0.50915e-05_r8, &
        & 0.64528e-05_r8,0.76669e-05_r8,0.96909e-05_r8,0.60588e-04_r8 /)
      kao(:, 1, 1, 8) = (/ &
        & 0.29788e-05_r8,0.29380e-04_r8,0.47103e-04_r8,0.62484e-04_r8,0.75923e-04_r8, &
        & 0.86945e-04_r8,0.96459e-04_r8,0.10727e-03_r8,0.95715e-04_r8 /)
      kao(:, 2, 1, 8) = (/ &
        & 0.31829e-05_r8,0.29542e-04_r8,0.47406e-04_r8,0.62987e-04_r8,0.76500e-04_r8, &
        & 0.87575e-04_r8,0.97244e-04_r8,0.10847e-03_r8,0.96769e-04_r8 /)
      kao(:, 3, 1, 8) = (/ &
        & 0.34017e-05_r8,0.30451e-04_r8,0.49181e-04_r8,0.65673e-04_r8,0.79848e-04_r8, &
        & 0.91475e-04_r8,0.10206e-03_r8,0.11418e-03_r8,0.10339e-03_r8 /)
      kao(:, 4, 1, 8) = (/ &
        & 0.36204e-05_r8,0.29858e-04_r8,0.47964e-04_r8,0.63849e-04_r8,0.77416e-04_r8, &
        & 0.88495e-04_r8,0.98624e-04_r8,0.11030e-03_r8,0.98665e-04_r8 /)
      kao(:, 5, 1, 8) = (/ &
        & 0.38336e-05_r8,0.30032e-04_r8,0.48176e-04_r8,0.64174e-04_r8,0.77743e-04_r8, &
        & 0.88899e-04_r8,0.99219e-04_r8,0.11117e-03_r8,0.99410e-04_r8 /)
      kao(:, 1, 2, 8) = (/ &
        & 0.24422e-05_r8,0.27039e-04_r8,0.43472e-04_r8,0.57657e-04_r8,0.69985e-04_r8, &
        & 0.80297e-04_r8,0.89716e-04_r8,0.10091e-03_r8,0.87814e-04_r8 /)
      kao(:, 2, 2, 8) = (/ &
        & 0.26194e-05_r8,0.27224e-04_r8,0.43834e-04_r8,0.58227e-04_r8,0.70564e-04_r8, &
        & 0.80899e-04_r8,0.90555e-04_r8,0.10201e-03_r8,0.88900e-04_r8 /)
      kao(:, 3, 2, 8) = (/ &
        & 0.28026e-05_r8,0.28185e-04_r8,0.45675e-04_r8,0.60941e-04_r8,0.73932e-04_r8, &
        & 0.84933e-04_r8,0.95539e-04_r8,0.10795e-03_r8,0.95932e-04_r8 /)
      kao(:, 4, 2, 8) = (/ &
        & 0.29807e-05_r8,0.28297e-04_r8,0.45818e-04_r8,0.61151e-04_r8,0.74119e-04_r8, &
        & 0.85132e-04_r8,0.95905e-04_r8,0.10857e-03_r8,0.96316e-04_r8 /)
      kao(:, 5, 2, 8) = (/ &
        & 0.31559e-05_r8,0.27777e-04_r8,0.44649e-04_r8,0.59431e-04_r8,0.71821e-04_r8, &
        & 0.82324e-04_r8,0.92537e-04_r8,0.10487e-03_r8,0.91446e-04_r8 /)
      kao(:, 1, 3, 8) = (/ &
        & 0.19527e-05_r8,0.24728e-04_r8,0.39864e-04_r8,0.52777e-04_r8,0.63893e-04_r8, &
        & 0.73441e-04_r8,0.82582e-04_r8,0.93968e-04_r8,0.79571e-04_r8 /)
      kao(:, 2, 3, 8) = (/ &
        & 0.21028e-05_r8,0.24948e-04_r8,0.40273e-04_r8,0.53366e-04_r8,0.64472e-04_r8, &
        & 0.74070e-04_r8,0.83496e-04_r8,0.95166e-04_r8,0.80711e-04_r8 /)
      kao(:, 3, 3, 8) = (/ &
        & 0.22571e-05_r8,0.25146e-04_r8,0.40613e-04_r8,0.53873e-04_r8,0.64998e-04_r8, &
        & 0.74638e-04_r8,0.84298e-04_r8,0.96249e-04_r8,0.81670e-04_r8 /)
      kao(:, 4, 3, 8) = (/ &
        & 0.24052e-05_r8,0.26082e-04_r8,0.42367e-04_r8,0.56407e-04_r8,0.68204e-04_r8, &
        & 0.78600e-04_r8,0.89199e-04_r8,0.10217e-03_r8,0.88502e-04_r8 /)
      kao(:, 5, 3, 8) = (/ &
        & 0.25493e-05_r8,0.25521e-04_r8,0.41156e-04_r8,0.54597e-04_r8,0.65795e-04_r8, &
        & 0.75610e-04_r8,0.85600e-04_r8,0.98234e-04_r8,0.83132e-04_r8 /)
      kao(:, 1, 4, 8) = (/ &
        & 0.15249e-05_r8,0.22458e-04_r8,0.36230e-04_r8,0.47832e-04_r8,0.57788e-04_r8, &
        & 0.66572e-04_r8,0.75267e-04_r8,0.86613e-04_r8,0.71765e-04_r8 /)
      kao(:, 2, 4, 8) = (/ &
        & 0.16472e-05_r8,0.22706e-04_r8,0.36674e-04_r8,0.48420e-04_r8,0.58373e-04_r8, &
        & 0.67233e-04_r8,0.76205e-04_r8,0.87918e-04_r8,0.72872e-04_r8 /)
      kao(:, 3, 4, 8) = (/ &
        & 0.17727e-05_r8,0.22924e-04_r8,0.37041e-04_r8,0.48925e-04_r8,0.58917e-04_r8, &
        & 0.67822e-04_r8,0.77056e-04_r8,0.89127e-04_r8,0.73812e-04_r8 /)
      kao(:, 4, 4, 8) = (/ &
        & 0.18979e-05_r8,0.23116e-04_r8,0.37363e-04_r8,0.49353e-04_r8,0.59386e-04_r8, &
        & 0.68373e-04_r8,0.77816e-04_r8,0.90208e-04_r8,0.74597e-04_r8 /)
      kao(:, 5, 4, 8) = (/ &
        & 0.20187e-05_r8,0.24032e-04_r8,0.39090e-04_r8,0.51784e-04_r8,0.62486e-04_r8, &
        & 0.72274e-04_r8,0.82652e-04_r8,0.95944e-04_r8,0.81360e-04_r8 /)
      kao(:, 1, 5, 8) = (/ &
        & 0.11616e-05_r8,0.20230e-04_r8,0.32593e-04_r8,0.43015e-04_r8,0.51913e-04_r8, &
        & 0.59885e-04_r8,0.68041e-04_r8,0.79091e-04_r8,0.64237e-04_r8 /)
      kao(:, 2, 5, 8) = (/ &
        & 0.12634e-05_r8,0.20493e-04_r8,0.33052e-04_r8,0.43575e-04_r8,0.52485e-04_r8, &
        & 0.60579e-04_r8,0.68993e-04_r8,0.80447e-04_r8,0.65308e-04_r8 /)
      kao(:, 3, 5, 8) = (/ &
        & 0.13665e-05_r8,0.20722e-04_r8,0.33449e-04_r8,0.44078e-04_r8,0.53031e-04_r8, &
        & 0.61206e-04_r8,0.69878e-04_r8,0.81712e-04_r8,0.66219e-04_r8 /)
      kao(:, 4, 5, 8) = (/ &
        & 0.14654e-05_r8,0.20926e-04_r8,0.33806e-04_r8,0.44507e-04_r8,0.53511e-04_r8, &
        & 0.61775e-04_r8,0.70644e-04_r8,0.82800e-04_r8,0.67010e-04_r8 /)
      kao(:, 5, 5, 8) = (/ &
        & 0.15654e-05_r8,0.21919e-04_r8,0.35683e-04_r8,0.47135e-04_r8,0.56892e-04_r8, &
        & 0.66014e-04_r8,0.75901e-04_r8,0.88948e-04_r8,0.74367e-04_r8 /)
      kao(:, 1, 6, 8) = (/ &
        & 0.85477e-06_r8,0.18056e-04_r8,0.29058e-04_r8,0.38374e-04_r8,0.46318e-04_r8, &
        & 0.53503e-04_r8,0.60983e-04_r8,0.71567e-04_r8,0.55220e-04_r8 /)
      kao(:, 2, 6, 8) = (/ &
        & 0.93399e-06_r8,0.18333e-04_r8,0.29518e-04_r8,0.38924e-04_r8,0.46903e-04_r8, &
        & 0.54228e-04_r8,0.61990e-04_r8,0.72960e-04_r8,0.56327e-04_r8 /)
      kao(:, 3, 6, 8) = (/ &
        & 0.10173e-05_r8,0.18568e-04_r8,0.29940e-04_r8,0.39430e-04_r8,0.47457e-04_r8, &
        & 0.54891e-04_r8,0.62912e-04_r8,0.74219e-04_r8,0.57262e-04_r8 /)
      kao(:, 4, 6, 8) = (/ &
        & 0.10990e-05_r8,0.18773e-04_r8,0.30321e-04_r8,0.39858e-04_r8,0.47937e-04_r8, &
        & 0.55463e-04_r8,0.63685e-04_r8,0.75339e-04_r8,0.58060e-04_r8 /)
      kao(:, 5, 6, 8) = (/ &
        & 0.11736e-05_r8,0.18980e-04_r8,0.30632e-04_r8,0.40210e-04_r8,0.48338e-04_r8, &
        & 0.55952e-04_r8,0.64349e-04_r8,0.76243e-04_r8,0.58787e-04_r8 /)
      kao(:, 1, 7, 8) = (/ &
        & 0.60315e-06_r8,0.15982e-04_r8,0.25725e-04_r8,0.33991e-04_r8,0.41066e-04_r8, &
        & 0.47516e-04_r8,0.54302e-04_r8,0.64196e-04_r8,0.19175e-04_r8 /)
      kao(:, 2, 7, 8) = (/ &
        & 0.66792e-06_r8,0.16270e-04_r8,0.26184e-04_r8,0.34534e-04_r8,0.41673e-04_r8, &
        & 0.48253e-04_r8,0.55322e-04_r8,0.65617e-04_r8,0.20214e-04_r8 /)
      kao(:, 3, 7, 8) = (/ &
        & 0.72908e-06_r8,0.16517e-04_r8,0.26616e-04_r8,0.35037e-04_r8,0.42229e-04_r8, &
        & 0.48924e-04_r8,0.56239e-04_r8,0.66903e-04_r8,0.21171e-04_r8 /)
      kao(:, 4, 7, 8) = (/ &
        & 0.78570e-06_r8,0.16735e-04_r8,0.27002e-04_r8,0.35463e-04_r8,0.42700e-04_r8, &
        & 0.49504e-04_r8,0.57015e-04_r8,0.68011e-04_r8,0.22118e-04_r8 /)
      kao(:, 5, 7, 8) = (/ &
        & 0.83832e-06_r8,0.16948e-04_r8,0.27325e-04_r8,0.35815e-04_r8,0.43102e-04_r8, &
        & 0.50003e-04_r8,0.57693e-04_r8,0.68917e-04_r8,0.22989e-04_r8 /)
      kao(:, 1, 8, 8) = (/ &
        & 0.37835e-06_r8,0.14042e-04_r8,0.22619e-04_r8,0.29906e-04_r8,0.36184e-04_r8, &
        & 0.41943e-04_r8,0.48058e-04_r8,0.57159e-04_r8,0.15030e-04_r8 /)
      kao(:, 2, 8, 8) = (/ &
        & 0.42400e-06_r8,0.14336e-04_r8,0.23076e-04_r8,0.30441e-04_r8,0.36790e-04_r8, &
        & 0.42677e-04_r8,0.49055e-04_r8,0.58574e-04_r8,0.15267e-04_r8 /)
      kao(:, 3, 8, 8) = (/ &
        & 0.47003e-06_r8,0.14598e-04_r8,0.23503e-04_r8,0.30926e-04_r8,0.37338e-04_r8, &
        & 0.43345e-04_r8,0.49944e-04_r8,0.59871e-04_r8,0.15168e-04_r8 /)
      kao(:, 4, 8, 8) = (/ &
        & 0.50983e-06_r8,0.14832e-04_r8,0.23887e-04_r8,0.31342e-04_r8,0.37806e-04_r8, &
        & 0.43932e-04_r8,0.50714e-04_r8,0.60954e-04_r8,0.15479e-04_r8 /)
      kao(:, 5, 8, 8) = (/ &
        & 0.55238e-06_r8,0.15050e-04_r8,0.24211e-04_r8,0.31698e-04_r8,0.38215e-04_r8, &
        & 0.44447e-04_r8,0.51404e-04_r8,0.61843e-04_r8,0.15864e-04_r8 /)
      kao(:, 1, 9, 8) = (/ &
        & 0.20614e-06_r8,0.12247e-04_r8,0.19755e-04_r8,0.26136e-04_r8,0.31671e-04_r8, &
        & 0.36795e-04_r8,0.42267e-04_r8,0.50480e-04_r8,0.31415e-04_r8 /)
      kao(:, 2, 9, 8) = (/ &
        & 0.22820e-06_r8,0.12543e-04_r8,0.20203e-04_r8,0.26660e-04_r8,0.32273e-04_r8, &
        & 0.37518e-04_r8,0.43228e-04_r8,0.51895e-04_r8,0.32257e-04_r8 /)
      kao(:, 3, 9, 8) = (/ &
        & 0.25381e-06_r8,0.12814e-04_r8,0.20621e-04_r8,0.27129e-04_r8,0.32814e-04_r8, &
        & 0.38186e-04_r8,0.44095e-04_r8,0.53151e-04_r8,0.31766e-04_r8 /)
      kao(:, 4, 9, 8) = (/ &
        & 0.26266e-06_r8,0.13056e-04_r8,0.20991e-04_r8,0.27538e-04_r8,0.33285e-04_r8, &
        & 0.38781e-04_r8,0.44859e-04_r8,0.54214e-04_r8,0.32184e-04_r8 /)
      kao(:, 5, 9, 8) = (/ &
        & 0.28878e-06_r8,0.13277e-04_r8,0.21308e-04_r8,0.27899e-04_r8,0.33704e-04_r8, &
        & 0.39313e-04_r8,0.45556e-04_r8,0.55111e-04_r8,0.32436e-04_r8 /)
      kao(:, 1,10, 8) = (/ &
        & 0.12421e-06_r8,0.10598e-04_r8,0.17170e-04_r8,0.22745e-04_r8,0.27597e-04_r8, &
        & 0.32129e-04_r8,0.37024e-04_r8,0.44410e-04_r8,0.36288e-04_r8 /)
      kao(:, 2,10, 8) = (/ &
        & 0.11833e-06_r8,0.10888e-04_r8,0.17606e-04_r8,0.23251e-04_r8,0.28191e-04_r8, &
        & 0.32843e-04_r8,0.37957e-04_r8,0.45757e-04_r8,0.36706e-04_r8 /)
      kao(:, 3,10, 8) = (/ &
        & 0.11564e-06_r8,0.11153e-04_r8,0.18009e-04_r8,0.23706e-04_r8,0.28726e-04_r8, &
        & 0.33507e-04_r8,0.38804e-04_r8,0.46971e-04_r8,0.39285e-04_r8 /)
      kao(:, 4,10, 8) = (/ &
        & 0.11888e-06_r8,0.11400e-04_r8,0.18364e-04_r8,0.24104e-04_r8,0.29196e-04_r8, &
        & 0.34101e-04_r8,0.39555e-04_r8,0.47996e-04_r8,0.37765e-04_r8 /)
      kao(:, 5,10, 8) = (/ &
        & 0.13250e-06_r8,0.11625e-04_r8,0.18671e-04_r8,0.24463e-04_r8,0.29622e-04_r8, &
        & 0.34646e-04_r8,0.40249e-04_r8,0.48876e-04_r8,0.41184e-04_r8 /)
      kao(:, 1,11, 8) = (/ &
        & 0.17958e-06_r8,0.90757e-05_r8,0.15007e-04_r8,0.19889e-04_r8,0.24154e-04_r8, &
        & 0.28187e-04_r8,0.32636e-04_r8,0.39437e-04_r8,0.34162e-04_r8 /)
      kao(:, 2,11, 8) = (/ &
        & 0.18139e-06_r8,0.93666e-05_r8,0.15418e-04_r8,0.20361e-04_r8,0.24716e-04_r8, &
        & 0.28864e-04_r8,0.33507e-04_r8,0.40680e-04_r8,0.35787e-04_r8 /)
      kao(:, 3,11, 8) = (/ &
        & 0.18275e-06_r8,0.96291e-05_r8,0.15787e-04_r8,0.20786e-04_r8,0.25221e-04_r8, &
        & 0.29495e-04_r8,0.34295e-04_r8,0.41765e-04_r8,0.33878e-04_r8 /)
      kao(:, 4,11, 8) = (/ &
        & 0.18574e-06_r8,0.98743e-05_r8,0.16117e-04_r8,0.21165e-04_r8,0.25673e-04_r8, &
        & 0.30069e-04_r8,0.35015e-04_r8,0.42686e-04_r8,0.32841e-04_r8 /)
      kao(:, 5,11, 8) = (/ &
        & 0.20082e-06_r8,0.10102e-04_r8,0.16409e-04_r8,0.21512e-04_r8,0.26096e-04_r8, &
        & 0.30600e-04_r8,0.35678e-04_r8,0.43526e-04_r8,0.33904e-04_r8 /)
      kao(:, 1,12, 8) = (/ &
        & 0.23860e-06_r8,0.72127e-05_r8,0.13015e-04_r8,0.17297e-04_r8,0.21033e-04_r8, &
        & 0.24600e-04_r8,0.28604e-04_r8,0.34818e-04_r8,0.40933e-04_r8 /)
      kao(:, 2,12, 8) = (/ &
        & 0.23391e-06_r8,0.75352e-05_r8,0.13408e-04_r8,0.17740e-04_r8,0.21564e-04_r8, &
        & 0.25251e-04_r8,0.29426e-04_r8,0.35947e-04_r8,0.39399e-04_r8 /)
      kao(:, 3,12, 8) = (/ &
        & 0.24701e-06_r8,0.78057e-05_r8,0.13760e-04_r8,0.18144e-04_r8,0.22045e-04_r8, &
        & 0.25844e-04_r8,0.30162e-04_r8,0.36924e-04_r8,0.38294e-04_r8 /)
      kao(:, 4,12, 8) = (/ &
        & 0.26761e-06_r8,0.80774e-05_r8,0.14071e-04_r8,0.18509e-04_r8,0.22485e-04_r8, &
        & 0.26399e-04_r8,0.30850e-04_r8,0.37793e-04_r8,0.37310e-04_r8 /)
      kao(:, 5,12, 8) = (/ &
        & 0.23665e-06_r8,0.83711e-05_r8,0.14360e-04_r8,0.18850e-04_r8,0.22903e-04_r8, &
        & 0.26918e-04_r8,0.31485e-04_r8,0.38601e-04_r8,0.34593e-04_r8 /)
      kao(:, 1,13, 8) = (/ &
        & 0.27521e-06_r8,0.50755e-05_r8,0.11059e-04_r8,0.14942e-04_r8,0.18221e-04_r8, &
        & 0.21366e-04_r8,0.24941e-04_r8,0.30569e-04_r8,0.35909e-04_r8 /)
      kao(:, 2,13, 8) = (/ &
        & 0.25317e-06_r8,0.53749e-05_r8,0.11450e-04_r8,0.15364e-04_r8,0.18725e-04_r8, &
        & 0.21982e-04_r8,0.25707e-04_r8,0.31598e-04_r8,0.37411e-04_r8 /)
      kao(:, 3,13, 8) = (/ &
        & 0.23895e-06_r8,0.56684e-05_r8,0.11800e-04_r8,0.15745e-04_r8,0.19182e-04_r8, &
        & 0.22548e-04_r8,0.26403e-04_r8,0.32490e-04_r8,0.35715e-04_r8 /)
      kao(:, 4,13, 8) = (/ &
        & 0.23323e-06_r8,0.59219e-05_r8,0.12110e-04_r8,0.16104e-04_r8,0.19621e-04_r8, &
        & 0.23090e-04_r8,0.27069e-04_r8,0.33309e-04_r8,0.26489e-04_r8 /)
      kao(:, 5,13, 8) = (/ &
        & 0.23115e-06_r8,0.61949e-05_r8,0.12408e-04_r8,0.16438e-04_r8,0.20031e-04_r8, &
        & 0.23602e-04_r8,0.27683e-04_r8,0.34068e-04_r8,0.26612e-04_r8 /)
      kao(:, 1, 1, 9) = (/ &
        & 0.91507e-04_r8,0.14710e-03_r8,0.19128e-03_r8,0.22605e-03_r8,0.25532e-03_r8, &
        & 0.28077e-03_r8,0.30345e-03_r8,0.32646e-03_r8,0.30807e-03_r8 /)
      kao(:, 2, 1, 9) = (/ &
        & 0.91242e-04_r8,0.14642e-03_r8,0.19074e-03_r8,0.22564e-03_r8,0.25500e-03_r8, &
        & 0.28086e-03_r8,0.30369e-03_r8,0.32690e-03_r8,0.30957e-03_r8 /)
      kao(:, 3, 1, 9) = (/ &
        & 0.90877e-04_r8,0.14692e-03_r8,0.19251e-03_r8,0.22869e-03_r8,0.25946e-03_r8, &
        & 0.28682e-03_r8,0.31087e-03_r8,0.33538e-03_r8,0.32011e-03_r8 /)
      kao(:, 4, 1, 9) = (/ &
        & 0.90459e-04_r8,0.14494e-03_r8,0.18943e-03_r8,0.22459e-03_r8,0.25465e-03_r8, &
        & 0.28114e-03_r8,0.30414e-03_r8,0.32755e-03_r8,0.31196e-03_r8 /)
      kao(:, 5, 1, 9) = (/ &
        & 0.89993e-04_r8,0.14416e-03_r8,0.18875e-03_r8,0.22408e-03_r8,0.25453e-03_r8, &
        & 0.28137e-03_r8,0.30449e-03_r8,0.32780e-03_r8,0.31307e-03_r8 /)
      kao(:, 1, 2, 9) = (/ &
        & 0.77262e-04_r8,0.13432e-03_r8,0.17769e-03_r8,0.21240e-03_r8,0.24204e-03_r8, &
        & 0.26866e-03_r8,0.29235e-03_r8,0.31628e-03_r8,0.29582e-03_r8 /)
      kao(:, 2, 2, 9) = (/ &
        & 0.77061e-04_r8,0.13375e-03_r8,0.17727e-03_r8,0.21210e-03_r8,0.24206e-03_r8, &
        & 0.26905e-03_r8,0.29288e-03_r8,0.31707e-03_r8,0.29754e-03_r8 /)
      kao(:, 3, 2, 9) = (/ &
        & 0.76803e-04_r8,0.13443e-03_r8,0.17926e-03_r8,0.21557e-03_r8,0.24713e-03_r8, &
        & 0.27557e-03_r8,0.30072e-03_r8,0.32610e-03_r8,0.30880e-03_r8 /)
      kao(:, 4, 2, 9) = (/ &
        & 0.76502e-04_r8,0.13372e-03_r8,0.17855e-03_r8,0.21503e-03_r8,0.24689e-03_r8, &
        & 0.27560e-03_r8,0.30084e-03_r8,0.32601e-03_r8,0.30963e-03_r8 /)
      kao(:, 5, 2, 9) = (/ &
        & 0.76149e-04_r8,0.13198e-03_r8,0.17568e-03_r8,0.21133e-03_r8,0.24254e-03_r8, &
        & 0.27051e-03_r8,0.29485e-03_r8,0.31890e-03_r8,0.30223e-03_r8 /)
      kao(:, 1, 3, 9) = (/ &
        & 0.65103e-04_r8,0.12258e-03_r8,0.16452e-03_r8,0.19865e-03_r8,0.22866e-03_r8, &
        & 0.25591e-03_r8,0.28055e-03_r8,0.30511e-03_r8,0.28178e-03_r8 /)
      kao(:, 2, 3, 9) = (/ &
        & 0.64961e-04_r8,0.12216e-03_r8,0.16424e-03_r8,0.19863e-03_r8,0.22903e-03_r8, &
        & 0.25664e-03_r8,0.28152e-03_r8,0.30626e-03_r8,0.28379e-03_r8 /)
      kao(:, 3, 3, 9) = (/ &
        & 0.64796e-04_r8,0.12170e-03_r8,0.16393e-03_r8,0.19861e-03_r8,0.22948e-03_r8, &
        & 0.25740e-03_r8,0.28253e-03_r8,0.30727e-03_r8,0.28578e-03_r8 /)
      kao(:, 4, 3, 9) = (/ &
        & 0.64583e-04_r8,0.12248e-03_r8,0.16600e-03_r8,0.20227e-03_r8,0.23481e-03_r8, &
        & 0.26421e-03_r8,0.29055e-03_r8,0.31636e-03_r8,0.29736e-03_r8 /)
      kao(:, 5, 3, 9) = (/ &
        & 0.64341e-04_r8,0.12081e-03_r8,0.16325e-03_r8,0.19869e-03_r8,0.23043e-03_r8, &
        & 0.25903e-03_r8,0.28445e-03_r8,0.30920e-03_r8,0.28976e-03_r8 /)
      kao(:, 1, 4, 9) = (/ &
        & 0.54784e-04_r8,0.11174e-03_r8,0.15188e-03_r8,0.18523e-03_r8,0.21503e-03_r8, &
        & 0.24239e-03_r8,0.26770e-03_r8,0.29311e-03_r8,0.26685e-03_r8 /)
      kao(:, 2, 4, 9) = (/ &
        & 0.54700e-04_r8,0.11144e-03_r8,0.15177e-03_r8,0.18550e-03_r8,0.21578e-03_r8, &
        & 0.24348e-03_r8,0.26903e-03_r8,0.29466e-03_r8,0.26928e-03_r8 /)
      kao(:, 3, 4, 9) = (/ &
        & 0.54592e-04_r8,0.11111e-03_r8,0.15167e-03_r8,0.18578e-03_r8,0.21655e-03_r8, &
        & 0.24456e-03_r8,0.27029e-03_r8,0.29609e-03_r8,0.27162e-03_r8 /)
      kao(:, 4, 4, 9) = (/ &
        & 0.54457e-04_r8,0.11078e-03_r8,0.15152e-03_r8,0.18607e-03_r8,0.21728e-03_r8, &
        & 0.24565e-03_r8,0.27151e-03_r8,0.29746e-03_r8,0.27399e-03_r8 /)
      kao(:, 5, 4, 9) = (/ &
        & 0.54312e-04_r8,0.11162e-03_r8,0.15369e-03_r8,0.18993e-03_r8,0.22281e-03_r8, &
        & 0.25263e-03_r8,0.27972e-03_r8,0.30664e-03_r8,0.28593e-03_r8 /)
      kao(:, 1, 5, 9) = (/ &
        & 0.46088e-04_r8,0.10164e-03_r8,0.13985e-03_r8,0.17192e-03_r8,0.20105e-03_r8, &
        & 0.22810e-03_r8,0.25365e-03_r8,0.28019e-03_r8,0.25169e-03_r8 /)
      kao(:, 2, 5, 9) = (/ &
        & 0.46037e-04_r8,0.10150e-03_r8,0.13996e-03_r8,0.17251e-03_r8,0.20208e-03_r8, &
        & 0.22949e-03_r8,0.25532e-03_r8,0.28211e-03_r8,0.25438e-03_r8 /)
      kao(:, 3, 5, 9) = (/ &
        & 0.45971e-04_r8,0.10129e-03_r8,0.14008e-03_r8,0.17302e-03_r8,0.20310e-03_r8, &
        & 0.23085e-03_r8,0.25690e-03_r8,0.28385e-03_r8,0.25702e-03_r8 /)
      kao(:, 4, 5, 9) = (/ &
        & 0.45890e-04_r8,0.10111e-03_r8,0.14015e-03_r8,0.17355e-03_r8,0.20405e-03_r8, &
        & 0.23221e-03_r8,0.25843e-03_r8,0.28547e-03_r8,0.25970e-03_r8 /)
      kao(:, 5, 5, 9) = (/ &
        & 0.45808e-04_r8,0.10210e-03_r8,0.14263e-03_r8,0.17783e-03_r8,0.21010e-03_r8, &
        & 0.23994e-03_r8,0.26750e-03_r8,0.29545e-03_r8,0.27288e-03_r8 /)
      kao(:, 1, 6, 9) = (/ &
        & 0.38759e-04_r8,0.92287e-04_r8,0.12830e-03_r8,0.15873e-03_r8,0.18673e-03_r8, &
        & 0.21305e-03_r8,0.23858e-03_r8,0.26603e-03_r8,0.23576e-03_r8 /)
      kao(:, 2, 6, 9) = (/ &
        & 0.38742e-04_r8,0.92285e-04_r8,0.12860e-03_r8,0.15956e-03_r8,0.18804e-03_r8, &
        & 0.21479e-03_r8,0.24061e-03_r8,0.26833e-03_r8,0.23876e-03_r8 /)
      kao(:, 3, 6, 9) = (/ &
        & 0.38716e-04_r8,0.92248e-04_r8,0.12890e-03_r8,0.16031e-03_r8,0.18934e-03_r8, &
        & 0.21647e-03_r8,0.24252e-03_r8,0.27042e-03_r8,0.24167e-03_r8 /)
      kao(:, 4, 6, 9) = (/ &
        & 0.38672e-04_r8,0.92189e-04_r8,0.12914e-03_r8,0.16108e-03_r8,0.19055e-03_r8, &
        & 0.21815e-03_r8,0.24441e-03_r8,0.27232e-03_r8,0.24468e-03_r8 /)
      kao(:, 5, 6, 9) = (/ &
        & 0.38631e-04_r8,0.92110e-04_r8,0.12940e-03_r8,0.16181e-03_r8,0.19180e-03_r8, &
        & 0.21982e-03_r8,0.24634e-03_r8,0.27420e-03_r8,0.24778e-03_r8 /)
      kao(:, 1, 7, 9) = (/ &
        & 0.32524e-04_r8,0.83578e-04_r8,0.11715e-03_r8,0.14581e-03_r8,0.17242e-03_r8, &
        & 0.19778e-03_r8,0.22289e-03_r8,0.25099e-03_r8,0.21544e-03_r8 /)
      kao(:, 2, 7, 9) = (/ &
        & 0.32544e-04_r8,0.83724e-04_r8,0.11765e-03_r8,0.14685e-03_r8,0.17402e-03_r8, &
        & 0.19984e-03_r8,0.22531e-03_r8,0.25360e-03_r8,0.21897e-03_r8 /)
      kao(:, 3, 7, 9) = (/ &
        & 0.32541e-04_r8,0.83837e-04_r8,0.11812e-03_r8,0.14785e-03_r8,0.17560e-03_r8, &
        & 0.20184e-03_r8,0.22764e-03_r8,0.25604e-03_r8,0.22234e-03_r8 /)
      kao(:, 4, 7, 9) = (/ &
        & 0.32522e-04_r8,0.83911e-04_r8,0.11855e-03_r8,0.14886e-03_r8,0.17710e-03_r8, &
        & 0.20381e-03_r8,0.22989e-03_r8,0.25831e-03_r8,0.22586e-03_r8 /)
      kao(:, 5, 7, 9) = (/ &
        & 0.32511e-04_r8,0.83972e-04_r8,0.11899e-03_r8,0.14985e-03_r8,0.17863e-03_r8, &
        & 0.20577e-03_r8,0.23212e-03_r8,0.26056e-03_r8,0.22930e-03_r8 /)
      kao(:, 1, 8, 9) = (/ &
        & 0.27162e-04_r8,0.75477e-04_r8,0.10657e-03_r8,0.13337e-03_r8,0.15848e-03_r8, &
        & 0.18267e-03_r8,0.20707e-03_r8,0.23532e-03_r8,0.10685e-03_r8 /)
      kao(:, 2, 8, 9) = (/ &
        & 0.27219e-04_r8,0.75747e-04_r8,0.10724e-03_r8,0.13464e-03_r8,0.16036e-03_r8, &
        & 0.18507e-03_r8,0.20988e-03_r8,0.23834e-03_r8,0.11049e-03_r8 /)
      kao(:, 3, 8, 9) = (/ &
        & 0.27240e-04_r8,0.75981e-04_r8,0.10788e-03_r8,0.13591e-03_r8,0.16217e-03_r8, &
        & 0.18731e-03_r8,0.21250e-03_r8,0.24115e-03_r8,0.11463e-03_r8 /)
      kao(:, 4, 8, 9) = (/ &
        & 0.27241e-04_r8,0.76175e-04_r8,0.10851e-03_r8,0.13715e-03_r8,0.16392e-03_r8, &
        & 0.18952e-03_r8,0.21504e-03_r8,0.24375e-03_r8,0.11830e-03_r8 /)
      kao(:, 5, 8, 9) = (/ &
        & 0.27254e-04_r8,0.76338e-04_r8,0.10913e-03_r8,0.13836e-03_r8,0.16569e-03_r8, &
        & 0.19172e-03_r8,0.21755e-03_r8,0.24638e-03_r8,0.12227e-03_r8 /)
      kao(:, 1, 9, 9) = (/ &
        & 0.22546e-04_r8,0.67903e-04_r8,0.96628e-04_r8,0.12150e-03_r8,0.14489e-03_r8, &
        & 0.16757e-03_r8,0.19095e-03_r8,0.21913e-03_r8,0.25626e-04_r8 /)
      kao(:, 2, 9, 9) = (/ &
        & 0.22635e-04_r8,0.68268e-04_r8,0.97460e-04_r8,0.12301e-03_r8,0.14702e-03_r8, &
        & 0.17028e-03_r8,0.19411e-03_r8,0.22260e-03_r8,0.25839e-04_r8 /)
      kao(:, 3, 9, 9) = (/ &
        & 0.22685e-04_r8,0.68616e-04_r8,0.98277e-04_r8,0.12450e-03_r8,0.14909e-03_r8, &
        & 0.17284e-03_r8,0.19709e-03_r8,0.22578e-03_r8,0.27443e-04_r8 /)
      kao(:, 4, 9, 9) = (/ &
        & 0.22709e-04_r8,0.68929e-04_r8,0.99095e-04_r8,0.12593e-03_r8,0.15108e-03_r8, &
        & 0.17530e-03_r8,0.19995e-03_r8,0.22878e-03_r8,0.28531e-04_r8 /)
      kao(:, 5, 9, 9) = (/ &
        & 0.22740e-04_r8,0.69227e-04_r8,0.99896e-04_r8,0.12734e-03_r8,0.15306e-03_r8, &
        & 0.17777e-03_r8,0.20277e-03_r8,0.23170e-03_r8,0.28894e-04_r8 /)
      kao(:, 1,10, 9) = (/ &
        & 0.18403e-04_r8,0.60856e-04_r8,0.87340e-04_r8,0.11017e-03_r8,0.13174e-03_r8, &
        & 0.15284e-03_r8,0.17492e-03_r8,0.20267e-03_r8,0.31931e-04_r8 /)
      kao(:, 2,10, 9) = (/ &
        & 0.18527e-04_r8,0.61329e-04_r8,0.88371e-04_r8,0.11191e-03_r8,0.13412e-03_r8, &
        & 0.15579e-03_r8,0.17838e-03_r8,0.20650e-03_r8,0.29084e-04_r8 /)
      kao(:, 3,10, 9) = (/ &
        & 0.18600e-04_r8,0.61796e-04_r8,0.89354e-04_r8,0.11363e-03_r8,0.13643e-03_r8, &
        & 0.15861e-03_r8,0.18170e-03_r8,0.21009e-03_r8,0.27893e-04_r8 /)
      kao(:, 4,10, 9) = (/ &
        & 0.18642e-04_r8,0.62226e-04_r8,0.90339e-04_r8,0.11526e-03_r8,0.13867e-03_r8, &
        & 0.16137e-03_r8,0.18486e-03_r8,0.21346e-03_r8,0.33895e-04_r8 /)
      kao(:, 5,10, 9) = (/ &
        & 0.18688e-04_r8,0.62651e-04_r8,0.91302e-04_r8,0.11690e-03_r8,0.14093e-03_r8, &
        & 0.16416e-03_r8,0.18804e-03_r8,0.21676e-03_r8,0.31724e-04_r8 /)
      kao(:, 1,11, 9) = (/ &
        & 0.14636e-04_r8,0.54588e-04_r8,0.79114e-04_r8,0.10030e-03_r8,0.12035e-03_r8, &
        & 0.14003e-03_r8,0.16089e-03_r8,0.18797e-03_r8,0.24886e-04_r8 /)
      kao(:, 2,11, 9) = (/ &
        & 0.14721e-04_r8,0.55182e-04_r8,0.80295e-04_r8,0.10221e-03_r8,0.12288e-03_r8, &
        & 0.14315e-03_r8,0.16455e-03_r8,0.19200e-03_r8,0.28280e-04_r8 /)
      kao(:, 3,11, 9) = (/ &
        & 0.14784e-04_r8,0.55751e-04_r8,0.81465e-04_r8,0.10405e-03_r8,0.12535e-03_r8, &
        & 0.14614e-03_r8,0.16802e-03_r8,0.19578e-03_r8,0.31405e-04_r8 /)
      kao(:, 4,11, 9) = (/ &
        & 0.14831e-04_r8,0.56293e-04_r8,0.82611e-04_r8,0.10589e-03_r8,0.12782e-03_r8, &
        & 0.14918e-03_r8,0.17147e-03_r8,0.19942e-03_r8,0.34684e-04_r8 /)
      kao(:, 5,11, 9) = (/ &
        & 0.14856e-04_r8,0.56829e-04_r8,0.83754e-04_r8,0.10776e-03_r8,0.13034e-03_r8, &
        & 0.15225e-03_r8,0.17499e-03_r8,0.20312e-03_r8,0.30970e-04_r8 /)
      kao(:, 1,12, 9) = (/ &
        & 0.11572e-04_r8,0.48876e-04_r8,0.71553e-04_r8,0.91191e-04_r8,0.10973e-03_r8, &
        & 0.12799e-03_r8,0.14756e-03_r8,0.17351e-03_r8,0.30682e-04_r8 /)
      kao(:, 2,12, 9) = (/ &
        & 0.11642e-04_r8,0.49592e-04_r8,0.72882e-04_r8,0.93233e-04_r8,0.11240e-03_r8, &
        & 0.13124e-03_r8,0.15132e-03_r8,0.17770e-03_r8,0.31240e-04_r8 /)
      kao(:, 3,12, 9) = (/ &
        & 0.11629e-04_r8,0.50261e-04_r8,0.74205e-04_r8,0.95210e-04_r8,0.11505e-03_r8, &
        & 0.13447e-03_r8,0.15502e-03_r8,0.18170e-03_r8,0.31943e-04_r8 /)
      kao(:, 4,12, 9) = (/ &
        & 0.11633e-04_r8,0.50925e-04_r8,0.75501e-04_r8,0.97246e-04_r8,0.11773e-03_r8, &
        & 0.13775e-03_r8,0.15878e-03_r8,0.18567e-03_r8,0.23441e-04_r8 /)
      kao(:, 5,12, 9) = (/ &
        & 0.11677e-04_r8,0.51560e-04_r8,0.76851e-04_r8,0.99310e-04_r8,0.12044e-03_r8, &
        & 0.14103e-03_r8,0.16255e-03_r8,0.18968e-03_r8,0.23249e-04_r8 /)
      kao(:, 1,13, 9) = (/ &
        & 0.88185e-05_r8,0.43709e-04_r8,0.64627e-04_r8,0.82824e-04_r8,0.99889e-04_r8, &
        & 0.11672e-03_r8,0.13488e-03_r8,0.15952e-03_r8,0.30903e-04_r8 /)
      kao(:, 2,13, 9) = (/ &
        & 0.88986e-05_r8,0.44515e-04_r8,0.66093e-04_r8,0.84980e-04_r8,0.10270e-03_r8, &
        & 0.12016e-03_r8,0.13885e-03_r8,0.16386e-03_r8,0.25840e-04_r8 /)
      kao(:, 3,13, 9) = (/ &
        & 0.89568e-05_r8,0.45280e-04_r8,0.67556e-04_r8,0.87134e-04_r8,0.10555e-03_r8, &
        & 0.12361e-03_r8,0.14282e-03_r8,0.16813e-03_r8,0.26878e-04_r8 /)
      kao(:, 4,13, 9) = (/ &
        & 0.89829e-05_r8,0.46045e-04_r8,0.69040e-04_r8,0.89346e-04_r8,0.10842e-03_r8, &
        & 0.12710e-03_r8,0.14682e-03_r8,0.17243e-03_r8,0.28852e-04_r8 /)
      kao(:, 5,13, 9) = (/ &
        & 0.90413e-05_r8,0.46787e-04_r8,0.70568e-04_r8,0.91561e-04_r8,0.11129e-03_r8, &
        & 0.13056e-03_r8,0.15080e-03_r8,0.17669e-03_r8,0.28623e-04_r8 /)
      kao(:, 1, 1,10) = (/ &
        & 0.44112e-03_r8,0.47423e-03_r8,0.54876e-03_r8,0.61567e-03_r8,0.66971e-03_r8, &
        & 0.71699e-03_r8,0.76347e-03_r8,0.77814e-03_r8,0.77298e-03_r8 /)
      kao(:, 2, 1,10) = (/ &
        & 0.43794e-03_r8,0.47285e-03_r8,0.54643e-03_r8,0.61370e-03_r8,0.66959e-03_r8, &
        & 0.71530e-03_r8,0.76226e-03_r8,0.77693e-03_r8,0.76966e-03_r8 /)
      kao(:, 3, 1,10) = (/ &
        & 0.43480e-03_r8,0.47183e-03_r8,0.54721e-03_r8,0.61831e-03_r8,0.67726e-03_r8, &
        & 0.72423e-03_r8,0.77288e-03_r8,0.78901e-03_r8,0.78603e-03_r8 /)
      kao(:, 4, 1,10) = (/ &
        & 0.43220e-03_r8,0.46825e-03_r8,0.54213e-03_r8,0.61349e-03_r8,0.66880e-03_r8, &
        & 0.71215e-03_r8,0.75938e-03_r8,0.77341e-03_r8,0.76775e-03_r8 /)
      kao(:, 5, 1,10) = (/ &
        & 0.42987e-03_r8,0.46597e-03_r8,0.54025e-03_r8,0.61237e-03_r8,0.66800e-03_r8, &
        & 0.70968e-03_r8,0.75599e-03_r8,0.77132e-03_r8,0.76754e-03_r8 /)
      kao(:, 1, 2,10) = (/ &
        & 0.37934e-03_r8,0.43540e-03_r8,0.51852e-03_r8,0.59327e-03_r8,0.65919e-03_r8, &
        & 0.71028e-03_r8,0.75523e-03_r8,0.78660e-03_r8,0.77018e-03_r8 /)
      kao(:, 2, 2,10) = (/ &
        & 0.37616e-03_r8,0.43418e-03_r8,0.51743e-03_r8,0.59232e-03_r8,0.65869e-03_r8, &
        & 0.70879e-03_r8,0.75385e-03_r8,0.78506e-03_r8,0.76914e-03_r8 /)
      kao(:, 3, 2,10) = (/ &
        & 0.37285e-03_r8,0.43338e-03_r8,0.51992e-03_r8,0.59796e-03_r8,0.66588e-03_r8, &
        & 0.71863e-03_r8,0.76525e-03_r8,0.79746e-03_r8,0.78726e-03_r8 /)
      kao(:, 4, 2,10) = (/ &
        & 0.36993e-03_r8,0.43092e-03_r8,0.51858e-03_r8,0.59729e-03_r8,0.66425e-03_r8, &
        & 0.71582e-03_r8,0.76129e-03_r8,0.79428e-03_r8,0.78557e-03_r8 /)
      kao(:, 5, 2,10) = (/ &
        & 0.36795e-03_r8,0.42667e-03_r8,0.51498e-03_r8,0.59125e-03_r8,0.65451e-03_r8, &
        & 0.70295e-03_r8,0.74646e-03_r8,0.77706e-03_r8,0.76846e-03_r8 /)
      kao(:, 1, 3,10) = (/ &
        & 0.32398e-03_r8,0.39840e-03_r8,0.48910e-03_r8,0.57202e-03_r8,0.64247e-03_r8, &
        & 0.69920e-03_r8,0.74272e-03_r8,0.78560e-03_r8,0.76158e-03_r8 /)
      kao(:, 2, 3,10) = (/ &
        & 0.32107e-03_r8,0.39683e-03_r8,0.48877e-03_r8,0.57106e-03_r8,0.64200e-03_r8, &
        & 0.69780e-03_r8,0.74068e-03_r8,0.78389e-03_r8,0.76255e-03_r8 /)
      kao(:, 3, 3,10) = (/ &
        & 0.31808e-03_r8,0.39502e-03_r8,0.48851e-03_r8,0.57104e-03_r8,0.64052e-03_r8, &
        & 0.69677e-03_r8,0.73846e-03_r8,0.78156e-03_r8,0.76341e-03_r8 /)
      kao(:, 4, 3,10) = (/ &
        & 0.31534e-03_r8,0.39419e-03_r8,0.49223e-03_r8,0.57621e-03_r8,0.64746e-03_r8, &
        & 0.70569e-03_r8,0.74986e-03_r8,0.79350e-03_r8,0.78192e-03_r8 /)
      kao(:, 5, 3,10) = (/ &
        & 0.31343e-03_r8,0.39031e-03_r8,0.48789e-03_r8,0.56911e-03_r8,0.63804e-03_r8, &
        & 0.69322e-03_r8,0.73529e-03_r8,0.77554e-03_r8,0.76249e-03_r8 /)
      kao(:, 1, 4,10) = (/ &
        & 0.27516e-03_r8,0.36405e-03_r8,0.46107e-03_r8,0.54790e-03_r8,0.62253e-03_r8, &
        & 0.68384e-03_r8,0.73057e-03_r8,0.77856e-03_r8,0.74793e-03_r8 /)
      kao(:, 2, 4,10) = (/ &
        & 0.27272e-03_r8,0.36262e-03_r8,0.46080e-03_r8,0.54700e-03_r8,0.62201e-03_r8, &
        & 0.68300e-03_r8,0.72976e-03_r8,0.77591e-03_r8,0.74919e-03_r8 /)
      kao(:, 3, 4,10) = (/ &
        & 0.26991e-03_r8,0.36139e-03_r8,0.46064e-03_r8,0.54673e-03_r8,0.62063e-03_r8, &
        & 0.68269e-03_r8,0.72862e-03_r8,0.77298e-03_r8,0.75070e-03_r8 /)
      kao(:, 4, 4,10) = (/ &
        & 0.26757e-03_r8,0.35993e-03_r8,0.46053e-03_r8,0.54625e-03_r8,0.61982e-03_r8, &
        & 0.68167e-03_r8,0.72799e-03_r8,0.77005e-03_r8,0.75046e-03_r8 /)
      kao(:, 5, 4,10) = (/ &
        & 0.26556e-03_r8,0.36025e-03_r8,0.46433e-03_r8,0.55132e-03_r8,0.62683e-03_r8, &
        & 0.69143e-03_r8,0.74137e-03_r8,0.78366e-03_r8,0.76845e-03_r8 /)
      kao(:, 1, 5,10) = (/ &
        & 0.23277e-03_r8,0.33279e-03_r8,0.43313e-03_r8,0.52236e-03_r8,0.59970e-03_r8, &
        & 0.66464e-03_r8,0.71686e-03_r8,0.76626e-03_r8,0.72457e-03_r8 /)
      kao(:, 2, 5,10) = (/ &
        & 0.23078e-03_r8,0.33167e-03_r8,0.43303e-03_r8,0.52181e-03_r8,0.60054e-03_r8, &
        & 0.66529e-03_r8,0.71807e-03_r8,0.76458e-03_r8,0.72852e-03_r8 /)
      kao(:, 3, 5,10) = (/ &
        & 0.22839e-03_r8,0.33111e-03_r8,0.43245e-03_r8,0.52229e-03_r8,0.60068e-03_r8, &
        & 0.66640e-03_r8,0.71880e-03_r8,0.76367e-03_r8,0.73165e-03_r8 /)
      kao(:, 4, 5,10) = (/ &
        & 0.22634e-03_r8,0.33010e-03_r8,0.43234e-03_r8,0.52220e-03_r8,0.60179e-03_r8, &
        & 0.66699e-03_r8,0.71996e-03_r8,0.76305e-03_r8,0.73316e-03_r8 /)
      kao(:, 5, 5,10) = (/ &
        & 0.22442e-03_r8,0.33158e-03_r8,0.43680e-03_r8,0.52864e-03_r8,0.61018e-03_r8, &
        & 0.67770e-03_r8,0.73371e-03_r8,0.78031e-03_r8,0.75138e-03_r8 /)
      kao(:, 1, 6,10) = (/ &
        & 0.19685e-03_r8,0.30442e-03_r8,0.40547e-03_r8,0.49610e-03_r8,0.57453e-03_r8, &
        & 0.64299e-03_r8,0.69899e-03_r8,0.74954e-03_r8,0.69460e-03_r8 /)
      kao(:, 2, 6,10) = (/ &
        & 0.19517e-03_r8,0.30338e-03_r8,0.40585e-03_r8,0.49683e-03_r8,0.57671e-03_r8, &
        & 0.64425e-03_r8,0.70130e-03_r8,0.75004e-03_r8,0.70036e-03_r8 /)
      kao(:, 3, 6,10) = (/ &
        & 0.19324e-03_r8,0.30268e-03_r8,0.40573e-03_r8,0.49834e-03_r8,0.57803e-03_r8, &
        & 0.64627e-03_r8,0.70310e-03_r8,0.75130e-03_r8,0.70596e-03_r8 /)
      kao(:, 4, 6,10) = (/ &
        & 0.19132e-03_r8,0.30224e-03_r8,0.40644e-03_r8,0.49947e-03_r8,0.58014e-03_r8, &
        & 0.64741e-03_r8,0.70472e-03_r8,0.75293e-03_r8,0.70917e-03_r8 /)
      kao(:, 5, 6,10) = (/ &
        & 0.18952e-03_r8,0.30177e-03_r8,0.40672e-03_r8,0.50101e-03_r8,0.58137e-03_r8, &
        & 0.64847e-03_r8,0.70602e-03_r8,0.75537e-03_r8,0.71121e-03_r8 /)
      kao(:, 1, 7,10) = (/ &
        & 0.16684e-03_r8,0.27825e-03_r8,0.37860e-03_r8,0.46883e-03_r8,0.54680e-03_r8, &
        & 0.61510e-03_r8,0.67386e-03_r8,0.72824e-03_r8,0.66391e-03_r8 /)
      kao(:, 2, 7,10) = (/ &
        & 0.16553e-03_r8,0.27719e-03_r8,0.37963e-03_r8,0.47077e-03_r8,0.54985e-03_r8, &
        & 0.61768e-03_r8,0.67717e-03_r8,0.73093e-03_r8,0.67156e-03_r8 /)
      kao(:, 3, 7,10) = (/ &
        & 0.16397e-03_r8,0.27663e-03_r8,0.38054e-03_r8,0.47308e-03_r8,0.55166e-03_r8, &
        & 0.62067e-03_r8,0.67975e-03_r8,0.73342e-03_r8,0.67787e-03_r8 /)
      kao(:, 4, 7,10) = (/ &
        & 0.16246e-03_r8,0.27634e-03_r8,0.38198e-03_r8,0.47489e-03_r8,0.55414e-03_r8, &
        & 0.62280e-03_r8,0.68232e-03_r8,0.73600e-03_r8,0.68175e-03_r8 /)
      kao(:, 5, 7,10) = (/ &
        & 0.16089e-03_r8,0.27624e-03_r8,0.38314e-03_r8,0.47665e-03_r8,0.55585e-03_r8, &
        & 0.62443e-03_r8,0.68436e-03_r8,0.73852e-03_r8,0.68559e-03_r8 /)
      kao(:, 1, 8,10) = (/ &
        & 0.14215e-03_r8,0.25407e-03_r8,0.35215e-03_r8,0.43863e-03_r8,0.51443e-03_r8, &
        & 0.58154e-03_r8,0.64180e-03_r8,0.70004e-03_r8,0.62276e-03_r8 /)
      kao(:, 2, 8,10) = (/ &
        & 0.14104e-03_r8,0.25332e-03_r8,0.35394e-03_r8,0.44179e-03_r8,0.51810e-03_r8, &
        & 0.58508e-03_r8,0.64584e-03_r8,0.70407e-03_r8,0.63285e-03_r8 /)
      kao(:, 3, 8,10) = (/ &
        & 0.13977e-03_r8,0.25313e-03_r8,0.35560e-03_r8,0.44458e-03_r8,0.52101e-03_r8, &
        & 0.58953e-03_r8,0.65037e-03_r8,0.70785e-03_r8,0.64108e-03_r8 /)
      kao(:, 4, 8,10) = (/ &
        & 0.13869e-03_r8,0.25332e-03_r8,0.35744e-03_r8,0.44722e-03_r8,0.52464e-03_r8, &
        & 0.59336e-03_r8,0.65468e-03_r8,0.71201e-03_r8,0.64611e-03_r8 /)
      kao(:, 5, 8,10) = (/ &
        & 0.13742e-03_r8,0.25367e-03_r8,0.35927e-03_r8,0.44959e-03_r8,0.52752e-03_r8, &
        & 0.59656e-03_r8,0.65824e-03_r8,0.71554e-03_r8,0.65066e-03_r8 /)
      kao(:, 1, 9,10) = (/ &
        & 0.12109e-03_r8,0.23210e-03_r8,0.32446e-03_r8,0.40715e-03_r8,0.48065e-03_r8, &
        & 0.54715e-03_r8,0.60775e-03_r8,0.66825e-03_r8,0.18336e-04_r8 /)
      kao(:, 2, 9,10) = (/ &
        & 0.12018e-03_r8,0.23207e-03_r8,0.32699e-03_r8,0.41058e-03_r8,0.48505e-03_r8, &
        & 0.55180e-03_r8,0.61323e-03_r8,0.67309e-03_r8,0.24327e-04_r8 /)
      kao(:, 3, 9,10) = (/ &
        & 0.11917e-03_r8,0.23229e-03_r8,0.32956e-03_r8,0.41390e-03_r8,0.48910e-03_r8, &
        & 0.55710e-03_r8,0.61911e-03_r8,0.67851e-03_r8,0.23065e-04_r8 /)
      kao(:, 4, 9,10) = (/ &
        & 0.11843e-03_r8,0.23292e-03_r8,0.33197e-03_r8,0.41764e-03_r8,0.49354e-03_r8, &
        & 0.56238e-03_r8,0.62497e-03_r8,0.68395e-03_r8,0.23680e-04_r8 /)
      kao(:, 5, 9,10) = (/ &
        & 0.11748e-03_r8,0.23365e-03_r8,0.33458e-03_r8,0.42109e-03_r8,0.49774e-03_r8, &
        & 0.56667e-03_r8,0.62987e-03_r8,0.68909e-03_r8,0.25905e-04_r8 /)
      kao(:, 1,10,10) = (/ &
        & 0.10273e-03_r8,0.21204e-03_r8,0.29794e-03_r8,0.37761e-03_r8,0.44937e-03_r8, &
        & 0.51495e-03_r8,0.57567e-03_r8,0.63761e-03_r8,0.19724e-04_r8 /)
      kao(:, 2,10,10) = (/ &
        & 0.10190e-03_r8,0.21272e-03_r8,0.30059e-03_r8,0.38150e-03_r8,0.45434e-03_r8, &
        & 0.52089e-03_r8,0.58270e-03_r8,0.64346e-03_r8,0.24197e-04_r8 /)
      kao(:, 3,10,10) = (/ &
        & 0.10112e-03_r8,0.21334e-03_r8,0.30377e-03_r8,0.38507e-03_r8,0.45917e-03_r8, &
        & 0.52739e-03_r8,0.58976e-03_r8,0.64941e-03_r8,0.34326e-04_r8 /)
      kao(:, 4,10,10) = (/ &
        & 0.10061e-03_r8,0.21443e-03_r8,0.30659e-03_r8,0.38965e-03_r8,0.46453e-03_r8, &
        & 0.53354e-03_r8,0.59675e-03_r8,0.65639e-03_r8,0.33702e-04_r8 /)
      kao(:, 5,10,10) = (/ &
        & 0.99890e-04_r8,0.21543e-03_r8,0.30998e-03_r8,0.39375e-03_r8,0.46925e-03_r8, &
        & 0.53804e-03_r8,0.60223e-03_r8,0.66255e-03_r8,0.31412e-04_r8 /)
      kao(:, 1,11,10) = (/ &
        & 0.86338e-04_r8,0.19398e-03_r8,0.27516e-03_r8,0.35204e-03_r8,0.42116e-03_r8, &
        & 0.48556e-03_r8,0.54615e-03_r8,0.60927e-03_r8,0.19945e-04_r8 /)
      kao(:, 2,11,10) = (/ &
        & 0.85730e-04_r8,0.19502e-03_r8,0.27834e-03_r8,0.35636e-03_r8,0.42792e-03_r8, &
        & 0.49403e-03_r8,0.55597e-03_r8,0.61737e-03_r8,0.90093e-05_r8 /)
      kao(:, 3,11,10) = (/ &
        & 0.85275e-04_r8,0.19618e-03_r8,0.28168e-03_r8,0.36165e-03_r8,0.43438e-03_r8, &
        & 0.50224e-03_r8,0.56492e-03_r8,0.62614e-03_r8,0.37496e-04_r8 /)
      kao(:, 4,11,10) = (/ &
        & 0.84865e-04_r8,0.19761e-03_r8,0.28526e-03_r8,0.36657e-03_r8,0.44042e-03_r8, &
        & 0.50863e-03_r8,0.57263e-03_r8,0.63413e-03_r8,0.15044e-04_r8 /)
      kao(:, 5,11,10) = (/ &
        & 0.84443e-04_r8,0.19914e-03_r8,0.28886e-03_r8,0.37069e-03_r8,0.44492e-03_r8, &
        & 0.51377e-03_r8,0.57803e-03_r8,0.63993e-03_r8,0.48683e-04_r8 /)
      kao(:, 1,12,10) = (/ &
        & 0.72237e-04_r8,0.17794e-03_r8,0.25491e-03_r8,0.32737e-03_r8,0.39376e-03_r8, &
        & 0.45690e-03_r8,0.51684e-03_r8,0.58057e-03_r8,0.10800e-04_r8 /)
      kao(:, 2,12,10) = (/ &
        & 0.71846e-04_r8,0.17916e-03_r8,0.25896e-03_r8,0.33355e-03_r8,0.40234e-03_r8, &
        & 0.46708e-03_r8,0.52856e-03_r8,0.59174e-03_r8,0.37304e-04_r8 /)
      kao(:, 3,12,10) = (/ &
        & 0.71641e-04_r8,0.18095e-03_r8,0.26291e-03_r8,0.34013e-03_r8,0.41022e-03_r8, &
        & 0.47645e-03_r8,0.53911e-03_r8,0.60240e-03_r8,0.20066e-04_r8 /)
      kao(:, 4,12,10) = (/ &
        & 0.71337e-04_r8,0.18255e-03_r8,0.26698e-03_r8,0.34557e-03_r8,0.41722e-03_r8, &
        & 0.48390e-03_r8,0.54753e-03_r8,0.61134e-03_r8,0.20267e-04_r8 /)
      kao(:, 5,12,10) = (/ &
        & 0.71187e-04_r8,0.18456e-03_r8,0.27032e-03_r8,0.35012e-03_r8,0.42265e-03_r8, &
        & 0.49079e-03_r8,0.55462e-03_r8,0.61760e-03_r8,0.29175e-04_r8 /)
      kao(:, 1,13,10) = (/ &
        & 0.60308e-04_r8,0.16344e-03_r8,0.23674e-03_r8,0.30451e-03_r8,0.36859e-03_r8, &
        & 0.42973e-03_r8,0.48896e-03_r8,0.55265e-03_r8,0.35870e-04_r8 /)
      kao(:, 2,13,10) = (/ &
        & 0.60075e-04_r8,0.16518e-03_r8,0.24182e-03_r8,0.31202e-03_r8,0.37817e-03_r8, &
        & 0.44097e-03_r8,0.50163e-03_r8,0.56563e-03_r8,0.24717e-04_r8 /)
      kao(:, 3,13,10) = (/ &
        & 0.59963e-04_r8,0.16736e-03_r8,0.24636e-03_r8,0.31956e-03_r8,0.38717e-03_r8, &
        & 0.45122e-03_r8,0.51282e-03_r8,0.57786e-03_r8,0.24967e-04_r8 /)
      kao(:, 4,13,10) = (/ &
        & 0.59808e-04_r8,0.16950e-03_r8,0.25081e-03_r8,0.32559e-03_r8,0.39488e-03_r8, &
        & 0.45992e-03_r8,0.52243e-03_r8,0.58716e-03_r8,0.25073e-04_r8 /)
      kao(:, 5,13,10) = (/ &
        & 0.59738e-04_r8,0.17182e-03_r8,0.25430e-03_r8,0.33121e-03_r8,0.40220e-03_r8, &
        & 0.46925e-03_r8,0.53224e-03_r8,0.59573e-03_r8,0.14031e-04_r8 /)
      kao(:, 1, 1,11) = (/ &
        & 0.79109e-03_r8,0.77354e-03_r8,0.84795e-03_r8,0.91837e-03_r8,0.98287e-03_r8, &
        & 0.10467e-02_r8,0.10876e-02_r8,0.10899e-02_r8,0.10918e-02_r8 /)
      kao(:, 2, 1,11) = (/ &
        & 0.79035e-03_r8,0.76999e-03_r8,0.84502e-03_r8,0.91315e-03_r8,0.97569e-03_r8, &
        & 0.10420e-02_r8,0.10843e-02_r8,0.10840e-02_r8,0.10904e-02_r8 /)
      kao(:, 3, 1,11) = (/ &
        & 0.79094e-03_r8,0.76969e-03_r8,0.84501e-03_r8,0.91212e-03_r8,0.97616e-03_r8, &
        & 0.10502e-02_r8,0.10978e-02_r8,0.10968e-02_r8,0.11098e-02_r8 /)
      kao(:, 4, 1,11) = (/ &
        & 0.79012e-03_r8,0.76698e-03_r8,0.84052e-03_r8,0.90224e-03_r8,0.96448e-03_r8, &
        & 0.10367e-02_r8,0.10810e-02_r8,0.10798e-02_r8,0.10838e-02_r8 /)
      kao(:, 5, 1,11) = (/ &
        & 0.78840e-03_r8,0.76416e-03_r8,0.83816e-03_r8,0.89971e-03_r8,0.96199e-03_r8, &
        & 0.10344e-02_r8,0.10796e-02_r8,0.10773e-02_r8,0.10800e-02_r8 /)
      kao(:, 1, 2,11) = (/ &
        & 0.69789e-03_r8,0.72093e-03_r8,0.81475e-03_r8,0.89922e-03_r8,0.96655e-03_r8, &
        & 0.10286e-02_r8,0.10852e-02_r8,0.10968e-02_r8,0.10998e-02_r8 /)
      kao(:, 2, 2,11) = (/ &
        & 0.69799e-03_r8,0.71831e-03_r8,0.81026e-03_r8,0.89390e-03_r8,0.96162e-03_r8, &
        & 0.10278e-02_r8,0.10853e-02_r8,0.10953e-02_r8,0.10980e-02_r8 /)
      kao(:, 3, 2,11) = (/ &
        & 0.69849e-03_r8,0.71872e-03_r8,0.81039e-03_r8,0.89368e-03_r8,0.96713e-03_r8, &
        & 0.10387e-02_r8,0.11003e-02_r8,0.11139e-02_r8,0.11199e-02_r8 /)
      kao(:, 4, 2,11) = (/ &
        & 0.69786e-03_r8,0.71702e-03_r8,0.80831e-03_r8,0.88926e-03_r8,0.96426e-03_r8, &
        & 0.10353e-02_r8,0.10976e-02_r8,0.11107e-02_r8,0.11152e-02_r8 /)
      kao(:, 5, 2,11) = (/ &
        & 0.69639e-03_r8,0.71420e-03_r8,0.80246e-03_r8,0.88289e-03_r8,0.95515e-03_r8, &
        & 0.10226e-02_r8,0.10812e-02_r8,0.10915e-02_r8,0.10904e-02_r8 /)
      kao(:, 1, 3,11) = (/ &
        & 0.60717e-03_r8,0.66595e-03_r8,0.77916e-03_r8,0.87509e-03_r8,0.95372e-03_r8, &
        & 0.10167e-02_r8,0.10820e-02_r8,0.11070e-02_r8,0.11005e-02_r8 /)
      kao(:, 2, 3,11) = (/ &
        & 0.60740e-03_r8,0.66447e-03_r8,0.77425e-03_r8,0.87078e-03_r8,0.95087e-03_r8, &
        & 0.10164e-02_r8,0.10820e-02_r8,0.11070e-02_r8,0.10996e-02_r8 /)
      kao(:, 3, 3,11) = (/ &
        & 0.60743e-03_r8,0.66421e-03_r8,0.77076e-03_r8,0.86668e-03_r8,0.94936e-03_r8, &
        & 0.10146e-02_r8,0.10809e-02_r8,0.11066e-02_r8,0.10979e-02_r8 /)
      kao(:, 4, 3,11) = (/ &
        & 0.60721e-03_r8,0.66487e-03_r8,0.77207e-03_r8,0.87093e-03_r8,0.95679e-03_r8, &
        & 0.10247e-02_r8,0.10950e-02_r8,0.11248e-02_r8,0.11171e-02_r8 /)
      kao(:, 5, 3,11) = (/ &
        & 0.60632e-03_r8,0.66259e-03_r8,0.76645e-03_r8,0.86469e-03_r8,0.94611e-03_r8, &
        & 0.10116e-02_r8,0.10778e-02_r8,0.11040e-02_r8,0.10953e-02_r8 /)
      kao(:, 1, 4,11) = (/ &
        & 0.52196e-03_r8,0.61309e-03_r8,0.74127e-03_r8,0.84825e-03_r8,0.93805e-03_r8, &
        & 0.10078e-02_r8,0.10732e-02_r8,0.11156e-02_r8,0.10964e-02_r8 /)
      kao(:, 2, 4,11) = (/ &
        & 0.52205e-03_r8,0.61209e-03_r8,0.73709e-03_r8,0.84586e-03_r8,0.93585e-03_r8, &
        & 0.10074e-02_r8,0.10727e-02_r8,0.11168e-02_r8,0.10976e-02_r8 /)
      kao(:, 3, 4,11) = (/ &
        & 0.52218e-03_r8,0.61175e-03_r8,0.73426e-03_r8,0.84316e-03_r8,0.93485e-03_r8, &
        & 0.10055e-02_r8,0.10718e-02_r8,0.11162e-02_r8,0.10985e-02_r8 /)
      kao(:, 4, 4,11) = (/ &
        & 0.52176e-03_r8,0.61131e-03_r8,0.73315e-03_r8,0.84162e-03_r8,0.93319e-03_r8, &
        & 0.10035e-02_r8,0.10709e-02_r8,0.11149e-02_r8,0.11000e-02_r8 /)
      kao(:, 5, 4,11) = (/ &
        & 0.52100e-03_r8,0.61215e-03_r8,0.73639e-03_r8,0.84868e-03_r8,0.94102e-03_r8, &
        & 0.10132e-02_r8,0.10822e-02_r8,0.11303e-02_r8,0.11192e-02_r8 /)
      kao(:, 1, 5,11) = (/ &
        & 0.44537e-03_r8,0.56415e-03_r8,0.70334e-03_r8,0.81986e-03_r8,0.91737e-03_r8, &
        & 0.99505e-03_r8,0.10590e-02_r8,0.11155e-02_r8,0.10855e-02_r8 /)
      kao(:, 2, 5,11) = (/ &
        & 0.44499e-03_r8,0.56304e-03_r8,0.70021e-03_r8,0.81824e-03_r8,0.91496e-03_r8, &
        & 0.99465e-03_r8,0.10577e-02_r8,0.11163e-02_r8,0.10886e-02_r8 /)
      kao(:, 3, 5,11) = (/ &
        & 0.44481e-03_r8,0.56231e-03_r8,0.69884e-03_r8,0.81557e-03_r8,0.91387e-03_r8, &
        & 0.99269e-03_r8,0.10566e-02_r8,0.11154e-02_r8,0.10925e-02_r8 /)
      kao(:, 4, 5,11) = (/ &
        & 0.44459e-03_r8,0.56155e-03_r8,0.69827e-03_r8,0.81462e-03_r8,0.91145e-03_r8, &
        & 0.99105e-03_r8,0.10558e-02_r8,0.11141e-02_r8,0.10950e-02_r8 /)
      kao(:, 5, 5,11) = (/ &
        & 0.44401e-03_r8,0.56266e-03_r8,0.70342e-03_r8,0.82262e-03_r8,0.92017e-03_r8, &
        & 0.10017e-02_r8,0.10686e-02_r8,0.11300e-02_r8,0.11166e-02_r8 /)
      kao(:, 1, 6,11) = (/ &
        & 0.37714e-03_r8,0.51787e-03_r8,0.66544e-03_r8,0.78793e-03_r8,0.89178e-03_r8, &
        & 0.97506e-03_r8,0.10421e-02_r8,0.11072e-02_r8,0.10679e-02_r8 /)
      kao(:, 2, 6,11) = (/ &
        & 0.37645e-03_r8,0.51719e-03_r8,0.66329e-03_r8,0.78619e-03_r8,0.88946e-03_r8, &
        & 0.97613e-03_r8,0.10421e-02_r8,0.11076e-02_r8,0.10727e-02_r8 /)
      kao(:, 3, 6,11) = (/ &
        & 0.37621e-03_r8,0.51663e-03_r8,0.66248e-03_r8,0.78421e-03_r8,0.88840e-03_r8, &
        & 0.97530e-03_r8,0.10423e-02_r8,0.11074e-02_r8,0.10773e-02_r8 /)
      kao(:, 4, 6,11) = (/ &
        & 0.37625e-03_r8,0.51591e-03_r8,0.66198e-03_r8,0.78342e-03_r8,0.88665e-03_r8, &
        & 0.97510e-03_r8,0.10427e-02_r8,0.11065e-02_r8,0.10807e-02_r8 /)
      kao(:, 5, 6,11) = (/ &
        & 0.37578e-03_r8,0.51583e-03_r8,0.66231e-03_r8,0.78322e-03_r8,0.88597e-03_r8, &
        & 0.97458e-03_r8,0.10416e-02_r8,0.11045e-02_r8,0.10828e-02_r8 /)
      kao(:, 1, 7,11) = (/ &
        & 0.31849e-03_r8,0.47598e-03_r8,0.62784e-03_r8,0.75245e-03_r8,0.86097e-03_r8, &
        & 0.95037e-03_r8,0.10228e-02_r8,0.10907e-02_r8,0.10381e-02_r8 /)
      kao(:, 2, 7,11) = (/ &
        & 0.31748e-03_r8,0.47565e-03_r8,0.62625e-03_r8,0.75127e-03_r8,0.86016e-03_r8, &
        & 0.95292e-03_r8,0.10249e-02_r8,0.10924e-02_r8,0.10446e-02_r8 /)
      kao(:, 3, 7,11) = (/ &
        & 0.31709e-03_r8,0.47527e-03_r8,0.62527e-03_r8,0.75044e-03_r8,0.86086e-03_r8, &
        & 0.95398e-03_r8,0.10272e-02_r8,0.10943e-02_r8,0.10513e-02_r8 /)
      kao(:, 4, 7,11) = (/ &
        & 0.31690e-03_r8,0.47506e-03_r8,0.62534e-03_r8,0.75023e-03_r8,0.86098e-03_r8, &
        & 0.95576e-03_r8,0.10298e-02_r8,0.10956e-02_r8,0.10570e-02_r8 /)
      kao(:, 5, 7,11) = (/ &
        & 0.31661e-03_r8,0.47556e-03_r8,0.62564e-03_r8,0.75129e-03_r8,0.86194e-03_r8, &
        & 0.95752e-03_r8,0.10312e-02_r8,0.10967e-02_r8,0.10605e-02_r8 /)
      kao(:, 1, 8,11) = (/ &
        & 0.26920e-03_r8,0.43740e-03_r8,0.58907e-03_r8,0.71604e-03_r8,0.82585e-03_r8, &
        & 0.92017e-03_r8,0.99828e-03_r8,0.10677e-02_r8,0.99191e-03_r8 /)
      kao(:, 2, 8,11) = (/ &
        & 0.26802e-03_r8,0.43738e-03_r8,0.58846e-03_r8,0.71590e-03_r8,0.82753e-03_r8, &
        & 0.92484e-03_r8,0.10036e-02_r8,0.10726e-02_r8,0.10010e-02_r8 /)
      kao(:, 3, 8,11) = (/ &
        & 0.26738e-03_r8,0.43742e-03_r8,0.58827e-03_r8,0.71679e-03_r8,0.83051e-03_r8, &
        & 0.92821e-03_r8,0.10079e-02_r8,0.10772e-02_r8,0.10102e-02_r8 /)
      kao(:, 4, 8,11) = (/ &
        & 0.26701e-03_r8,0.43751e-03_r8,0.58933e-03_r8,0.71793e-03_r8,0.83304e-03_r8, &
        & 0.93190e-03_r8,0.10124e-02_r8,0.10810e-02_r8,0.10188e-02_r8 /)
      kao(:, 5, 8,11) = (/ &
        & 0.26686e-03_r8,0.43824e-03_r8,0.58999e-03_r8,0.72050e-03_r8,0.83607e-03_r8, &
        & 0.93581e-03_r8,0.10160e-02_r8,0.10848e-02_r8,0.10263e-02_r8 /)
      kao(:, 1, 9,11) = (/ &
        & 0.22904e-03_r8,0.40123e-03_r8,0.55115e-03_r8,0.67712e-03_r8,0.78732e-03_r8, &
        & 0.88313e-03_r8,0.96568e-03_r8,0.10387e-02_r8,0.14403e-04_r8 /)
      kao(:, 2, 9,11) = (/ &
        & 0.22775e-03_r8,0.40129e-03_r8,0.55155e-03_r8,0.67918e-03_r8,0.79168e-03_r8, &
        & 0.89045e-03_r8,0.97356e-03_r8,0.10468e-02_r8,0.17396e-04_r8 /)
      kao(:, 3, 9,11) = (/ &
        & 0.22691e-03_r8,0.40187e-03_r8,0.55239e-03_r8,0.68238e-03_r8,0.79664e-03_r8, &
        & 0.89641e-03_r8,0.98013e-03_r8,0.10538e-02_r8,0.17983e-04_r8 /)
      kao(:, 4, 9,11) = (/ &
        & 0.22637e-03_r8,0.40220e-03_r8,0.55452e-03_r8,0.68525e-03_r8,0.80145e-03_r8, &
        & 0.90223e-03_r8,0.98673e-03_r8,0.10599e-02_r8,0.14884e-04_r8 /)
      kao(:, 5, 9,11) = (/ &
        & 0.22595e-03_r8,0.40316e-03_r8,0.55613e-03_r8,0.68950e-03_r8,0.80623e-03_r8, &
        & 0.90849e-03_r8,0.99244e-03_r8,0.10655e-02_r8,0.19485e-04_r8 /)
      kao(:, 1,10,11) = (/ &
        & 0.19610e-03_r8,0.36707e-03_r8,0.51305e-03_r8,0.63612e-03_r8,0.74337e-03_r8, &
        & 0.83875e-03_r8,0.92458e-03_r8,0.10007e-02_r8,0.30583e-04_r8 /)
      kao(:, 2,10,11) = (/ &
        & 0.19499e-03_r8,0.36759e-03_r8,0.51501e-03_r8,0.64066e-03_r8,0.75082e-03_r8, &
        & 0.84853e-03_r8,0.93443e-03_r8,0.10117e-02_r8,0.20484e-04_r8 /)
      kao(:, 3,10,11) = (/ &
        & 0.19427e-03_r8,0.36886e-03_r8,0.51745e-03_r8,0.64625e-03_r8,0.75815e-03_r8, &
        & 0.85733e-03_r8,0.94303e-03_r8,0.10217e-02_r8,0.20784e-04_r8 /)
      kao(:, 4,10,11) = (/ &
        & 0.19367e-03_r8,0.36958e-03_r8,0.52106e-03_r8,0.65093e-03_r8,0.76545e-03_r8, &
        & 0.86571e-03_r8,0.95244e-03_r8,0.10301e-02_r8,0.30511e-04_r8 /)
      kao(:, 5,10,11) = (/ &
        & 0.19319e-03_r8,0.37098e-03_r8,0.52409e-03_r8,0.65675e-03_r8,0.77258e-03_r8, &
        & 0.87491e-03_r8,0.96110e-03_r8,0.10378e-02_r8,0.19883e-04_r8 /)
      kao(:, 1,11,11) = (/ &
        & 0.16767e-03_r8,0.33624e-03_r8,0.47635e-03_r8,0.59543e-03_r8,0.70301e-03_r8, &
        & 0.79872e-03_r8,0.88652e-03_r8,0.96550e-03_r8,0.27483e-04_r8 /)
      kao(:, 2,11,11) = (/ &
        & 0.16687e-03_r8,0.33764e-03_r8,0.48055e-03_r8,0.60283e-03_r8,0.71186e-03_r8, &
        & 0.80978e-03_r8,0.89673e-03_r8,0.97758e-03_r8,0.20639e-04_r8 /)
      kao(:, 3,11,11) = (/ &
        & 0.16664e-03_r8,0.33942e-03_r8,0.48524e-03_r8,0.60962e-03_r8,0.72075e-03_r8, &
        & 0.81953e-03_r8,0.90753e-03_r8,0.98729e-03_r8,0.27689e-04_r8 /)
      kao(:, 4,11,11) = (/ &
        & 0.16611e-03_r8,0.34104e-03_r8,0.48994e-03_r8,0.61708e-03_r8,0.72992e-03_r8, &
        & 0.83047e-03_r8,0.91898e-03_r8,0.99769e-03_r8,0.13719e-04_r8 /)
      kao(:, 5,11,11) = (/ &
        & 0.16596e-03_r8,0.34313e-03_r8,0.49467e-03_r8,0.62538e-03_r8,0.73960e-03_r8, &
        & 0.84171e-03_r8,0.92999e-03_r8,0.10075e-02_r8,0.27137e-04_r8 /)
      kao(:, 1,12,11) = (/ &
        & 0.14282e-03_r8,0.30890e-03_r8,0.44183e-03_r8,0.55831e-03_r8,0.66503e-03_r8, &
        & 0.76077e-03_r8,0.84890e-03_r8,0.93128e-03_r8,0.21228e-04_r8 /)
      kao(:, 2,12,11) = (/ &
        & 0.14255e-03_r8,0.31125e-03_r8,0.44731e-03_r8,0.56685e-03_r8,0.67491e-03_r8, &
        & 0.77277e-03_r8,0.86092e-03_r8,0.94274e-03_r8,0.32331e-04_r8 /)
      kao(:, 3,12,11) = (/ &
        & 0.14244e-03_r8,0.31334e-03_r8,0.45354e-03_r8,0.57479e-03_r8,0.68552e-03_r8, &
        & 0.78420e-03_r8,0.87396e-03_r8,0.95434e-03_r8,0.19978e-06_r8 /)
      kao(:, 4,12,11) = (/ &
        & 0.14239e-03_r8,0.31614e-03_r8,0.45984e-03_r8,0.58419e-03_r8,0.69607e-03_r8, &
        & 0.79750e-03_r8,0.88765e-03_r8,0.96637e-03_r8,0.21475e-04_r8 /)
      kao(:, 5,12,11) = (/ &
        & 0.14252e-03_r8,0.31876e-03_r8,0.46658e-03_r8,0.59385e-03_r8,0.70775e-03_r8, &
        & 0.80986e-03_r8,0.90037e-03_r8,0.97814e-03_r8,0.21476e-04_r8 /)
      kao(:, 1,13,11) = (/ &
        & 0.12125e-03_r8,0.28444e-03_r8,0.41080e-03_r8,0.52444e-03_r8,0.62932e-03_r8, &
        & 0.72481e-03_r8,0.81245e-03_r8,0.89716e-03_r8,0.27405e-04_r8 /)
      kao(:, 2,13,11) = (/ &
        & 0.12138e-03_r8,0.28788e-03_r8,0.41712e-03_r8,0.53396e-03_r8,0.64078e-03_r8, &
        & 0.73819e-03_r8,0.82737e-03_r8,0.91020e-03_r8,0.13699e-04_r8 /)
      kao(:, 3,13,11) = (/ &
        & 0.12142e-03_r8,0.29086e-03_r8,0.42441e-03_r8,0.54338e-03_r8,0.65260e-03_r8, &
        & 0.75224e-03_r8,0.84352e-03_r8,0.92398e-03_r8,0.13820e-04_r8 /)
      kao(:, 4,13,11) = (/ &
        & 0.12174e-03_r8,0.29430e-03_r8,0.43176e-03_r8,0.55440e-03_r8,0.66546e-03_r8, &
        & 0.76738e-03_r8,0.85914e-03_r8,0.93821e-03_r8,0.26505e-06_r8 /)
      kao(:, 5,13,11) = (/ &
        & 0.12197e-03_r8,0.29750e-03_r8,0.43989e-03_r8,0.56500e-03_r8,0.67844e-03_r8, &
        & 0.78071e-03_r8,0.87280e-03_r8,0.95108e-03_r8,0.33764e-06_r8 /)
      kao(:, 1, 1,12) = (/ &
        & 0.15537e-02_r8,0.13818e-02_r8,0.14273e-02_r8,0.15055e-02_r8,0.15786e-02_r8, &
        & 0.16339e-02_r8,0.16467e-02_r8,0.15800e-02_r8,0.16050e-02_r8 /)
      kao(:, 2, 1,12) = (/ &
        & 0.15485e-02_r8,0.13765e-02_r8,0.14181e-02_r8,0.14978e-02_r8,0.15727e-02_r8, &
        & 0.16256e-02_r8,0.16371e-02_r8,0.15728e-02_r8,0.16005e-02_r8 /)
      kao(:, 3, 1,12) = (/ &
        & 0.15437e-02_r8,0.13722e-02_r8,0.14122e-02_r8,0.14971e-02_r8,0.15752e-02_r8, &
        & 0.16261e-02_r8,0.16396e-02_r8,0.15797e-02_r8,0.16209e-02_r8 /)
      kao(:, 4, 1,12) = (/ &
        & 0.15424e-02_r8,0.13691e-02_r8,0.14015e-02_r8,0.14839e-02_r8,0.15593e-02_r8, &
        & 0.16040e-02_r8,0.16150e-02_r8,0.15487e-02_r8,0.15957e-02_r8 /)
      kao(:, 5, 1,12) = (/ &
        & 0.15425e-02_r8,0.13681e-02_r8,0.13961e-02_r8,0.14766e-02_r8,0.15502e-02_r8, &
        & 0.15943e-02_r8,0.16046e-02_r8,0.15376e-02_r8,0.15923e-02_r8 /)
      kao(:, 1, 2,12) = (/ &
        & 0.14274e-02_r8,0.13101e-02_r8,0.13901e-02_r8,0.14665e-02_r8,0.15597e-02_r8, &
        & 0.16365e-02_r8,0.16682e-02_r8,0.16286e-02_r8,0.16381e-02_r8 /)
      kao(:, 2, 2,12) = (/ &
        & 0.14223e-02_r8,0.13039e-02_r8,0.13828e-02_r8,0.14629e-02_r8,0.15522e-02_r8, &
        & 0.16256e-02_r8,0.16567e-02_r8,0.16183e-02_r8,0.16362e-02_r8 /)
      kao(:, 3, 2,12) = (/ &
        & 0.14195e-02_r8,0.12999e-02_r8,0.13791e-02_r8,0.14641e-02_r8,0.15538e-02_r8, &
        & 0.16259e-02_r8,0.16605e-02_r8,0.16235e-02_r8,0.16585e-02_r8 /)
      kao(:, 4, 2,12) = (/ &
        & 0.14181e-02_r8,0.12958e-02_r8,0.13726e-02_r8,0.14576e-02_r8,0.15447e-02_r8, &
        & 0.16149e-02_r8,0.16487e-02_r8,0.16101e-02_r8,0.16540e-02_r8 /)
      kao(:, 5, 2,12) = (/ &
        & 0.14191e-02_r8,0.12933e-02_r8,0.13650e-02_r8,0.14448e-02_r8,0.15270e-02_r8, &
        & 0.15959e-02_r8,0.16273e-02_r8,0.15850e-02_r8,0.16279e-02_r8 /)
      kao(:, 1, 3,12) = (/ &
        & 0.12975e-02_r8,0.12495e-02_r8,0.13516e-02_r8,0.14440e-02_r8,0.15390e-02_r8, &
        & 0.16298e-02_r8,0.16807e-02_r8,0.16634e-02_r8,0.16697e-02_r8 /)
      kao(:, 2, 3,12) = (/ &
        & 0.12938e-02_r8,0.12434e-02_r8,0.13457e-02_r8,0.14406e-02_r8,0.15301e-02_r8, &
        & 0.16196e-02_r8,0.16709e-02_r8,0.16534e-02_r8,0.16671e-02_r8 /)
      kao(:, 3, 3,12) = (/ &
        & 0.12920e-02_r8,0.12378e-02_r8,0.13412e-02_r8,0.14340e-02_r8,0.15221e-02_r8, &
        & 0.16094e-02_r8,0.16610e-02_r8,0.16426e-02_r8,0.16655e-02_r8 /)
      kao(:, 4, 3,12) = (/ &
        & 0.12905e-02_r8,0.12343e-02_r8,0.13399e-02_r8,0.14335e-02_r8,0.15224e-02_r8, &
        & 0.16137e-02_r8,0.16692e-02_r8,0.16519e-02_r8,0.16891e-02_r8 /)
      kao(:, 5, 3,12) = (/ &
        & 0.12916e-02_r8,0.12305e-02_r8,0.13333e-02_r8,0.14197e-02_r8,0.15049e-02_r8, &
        & 0.15945e-02_r8,0.16481e-02_r8,0.16282e-02_r8,0.16593e-02_r8 /)
      kao(:, 1, 4,12) = (/ &
        & 0.11586e-02_r8,0.11791e-02_r8,0.13059e-02_r8,0.14246e-02_r8,0.15191e-02_r8, &
        & 0.16155e-02_r8,0.16888e-02_r8,0.16884e-02_r8,0.16900e-02_r8 /)
      kao(:, 2, 4,12) = (/ &
        & 0.11563e-02_r8,0.11735e-02_r8,0.13020e-02_r8,0.14191e-02_r8,0.15117e-02_r8, &
        & 0.16067e-02_r8,0.16804e-02_r8,0.16804e-02_r8,0.16885e-02_r8 /)
      kao(:, 3, 4,12) = (/ &
        & 0.11547e-02_r8,0.11684e-02_r8,0.12989e-02_r8,0.14121e-02_r8,0.15049e-02_r8, &
        & 0.15986e-02_r8,0.16736e-02_r8,0.16742e-02_r8,0.16864e-02_r8 /)
      kao(:, 4, 4,12) = (/ &
        & 0.11549e-02_r8,0.11640e-02_r8,0.12947e-02_r8,0.14053e-02_r8,0.14971e-02_r8, &
        & 0.15940e-02_r8,0.16690e-02_r8,0.16701e-02_r8,0.16826e-02_r8 /)
      kao(:, 5, 4,12) = (/ &
        & 0.11568e-02_r8,0.11629e-02_r8,0.12947e-02_r8,0.14048e-02_r8,0.15017e-02_r8, &
        & 0.16054e-02_r8,0.16836e-02_r8,0.16886e-02_r8,0.17044e-02_r8 /)
      kao(:, 1, 5,12) = (/ &
        & 0.10197e-02_r8,0.11002e-02_r8,0.12563e-02_r8,0.13948e-02_r8,0.15048e-02_r8, &
        & 0.16026e-02_r8,0.16898e-02_r8,0.17082e-02_r8,0.17013e-02_r8 /)
      kao(:, 2, 5,12) = (/ &
        & 0.10187e-02_r8,0.10963e-02_r8,0.12532e-02_r8,0.13909e-02_r8,0.14993e-02_r8, &
        & 0.15953e-02_r8,0.16843e-02_r8,0.17040e-02_r8,0.16991e-02_r8 /)
      kao(:, 3, 5,12) = (/ &
        & 0.10179e-02_r8,0.10925e-02_r8,0.12502e-02_r8,0.13858e-02_r8,0.14932e-02_r8, &
        & 0.15900e-02_r8,0.16803e-02_r8,0.17019e-02_r8,0.16952e-02_r8 /)
      kao(:, 4, 5,12) = (/ &
        & 0.10188e-02_r8,0.10896e-02_r8,0.12461e-02_r8,0.13806e-02_r8,0.14878e-02_r8, &
        & 0.15873e-02_r8,0.16767e-02_r8,0.17001e-02_r8,0.16925e-02_r8 /)
      kao(:, 5, 5,12) = (/ &
        & 0.10211e-02_r8,0.10901e-02_r8,0.12464e-02_r8,0.13834e-02_r8,0.14970e-02_r8, &
        & 0.16026e-02_r8,0.16952e-02_r8,0.17210e-02_r8,0.17180e-02_r8 /)
      kao(:, 1, 6,12) = (/ &
        & 0.88455e-03_r8,0.10185e-02_r8,0.12021e-02_r8,0.13605e-02_r8,0.14894e-02_r8, &
        & 0.15922e-02_r8,0.16870e-02_r8,0.17277e-02_r8,0.17006e-02_r8 /)
      kao(:, 2, 6,12) = (/ &
        & 0.88487e-03_r8,0.10158e-02_r8,0.12001e-02_r8,0.13587e-02_r8,0.14854e-02_r8, &
        & 0.15856e-02_r8,0.16819e-02_r8,0.17253e-02_r8,0.17001e-02_r8 /)
      kao(:, 3, 6,12) = (/ &
        & 0.88512e-03_r8,0.10136e-02_r8,0.11981e-02_r8,0.13544e-02_r8,0.14820e-02_r8, &
        & 0.15811e-02_r8,0.16785e-02_r8,0.17233e-02_r8,0.16989e-02_r8 /)
      kao(:, 4, 6,12) = (/ &
        & 0.88698e-03_r8,0.10127e-02_r8,0.11948e-02_r8,0.13505e-02_r8,0.14784e-02_r8, &
        & 0.15789e-02_r8,0.16749e-02_r8,0.17211e-02_r8,0.16988e-02_r8 /)
      kao(:, 5, 6,12) = (/ &
        & 0.88923e-03_r8,0.10128e-02_r8,0.11919e-02_r8,0.13468e-02_r8,0.14756e-02_r8, &
        & 0.15764e-02_r8,0.16734e-02_r8,0.17190e-02_r8,0.16990e-02_r8 /)
      kao(:, 1, 7,12) = (/ &
        & 0.75937e-03_r8,0.93876e-03_r8,0.11443e-02_r8,0.13228e-02_r8,0.14681e-02_r8, &
        & 0.15807e-02_r8,0.16771e-02_r8,0.17403e-02_r8,0.16920e-02_r8 /)
      kao(:, 2, 7,12) = (/ &
        & 0.75998e-03_r8,0.93770e-03_r8,0.11447e-02_r8,0.13222e-02_r8,0.14656e-02_r8, &
        & 0.15751e-02_r8,0.16722e-02_r8,0.17374e-02_r8,0.16943e-02_r8 /)
      kao(:, 3, 7,12) = (/ &
        & 0.76057e-03_r8,0.93698e-03_r8,0.11442e-02_r8,0.13192e-02_r8,0.14630e-02_r8, &
        & 0.15711e-02_r8,0.16684e-02_r8,0.17351e-02_r8,0.16966e-02_r8 /)
      kao(:, 4, 7,12) = (/ &
        & 0.76306e-03_r8,0.93700e-03_r8,0.11417e-02_r8,0.13175e-02_r8,0.14605e-02_r8, &
        & 0.15679e-02_r8,0.16649e-02_r8,0.17327e-02_r8,0.16998e-02_r8 /)
      kao(:, 5, 7,12) = (/ &
        & 0.76563e-03_r8,0.93740e-03_r8,0.11401e-02_r8,0.13155e-02_r8,0.14583e-02_r8, &
        & 0.15655e-02_r8,0.16637e-02_r8,0.17306e-02_r8,0.17045e-02_r8 /)
      kao(:, 1, 8,12) = (/ &
        & 0.64586e-03_r8,0.86421e-03_r8,0.10884e-02_r8,0.12806e-02_r8,0.14383e-02_r8, &
        & 0.15636e-02_r8,0.16605e-02_r8,0.17434e-02_r8,0.16711e-02_r8 /)
      kao(:, 2, 8,12) = (/ &
        & 0.64665e-03_r8,0.86473e-03_r8,0.10896e-02_r8,0.12820e-02_r8,0.14363e-02_r8, &
        & 0.15592e-02_r8,0.16561e-02_r8,0.17403e-02_r8,0.16771e-02_r8 /)
      kao(:, 3, 8,12) = (/ &
        & 0.64816e-03_r8,0.86506e-03_r8,0.10903e-02_r8,0.12802e-02_r8,0.14357e-02_r8, &
        & 0.15554e-02_r8,0.16529e-02_r8,0.17367e-02_r8,0.16846e-02_r8 /)
      kao(:, 4, 8,12) = (/ &
        & 0.65115e-03_r8,0.86561e-03_r8,0.10893e-02_r8,0.12797e-02_r8,0.14336e-02_r8, &
        & 0.15533e-02_r8,0.16505e-02_r8,0.17349e-02_r8,0.16920e-02_r8 /)
      kao(:, 5, 8,12) = (/ &
        & 0.65335e-03_r8,0.86692e-03_r8,0.10897e-02_r8,0.12788e-02_r8,0.14323e-02_r8, &
        & 0.15519e-02_r8,0.16494e-02_r8,0.17328e-02_r8,0.17005e-02_r8 /)
      kao(:, 1, 9,12) = (/ &
        & 0.54495e-03_r8,0.79374e-03_r8,0.10331e-02_r8,0.12325e-02_r8,0.13999e-02_r8, &
        & 0.15343e-02_r8,0.16359e-02_r8,0.17304e-02_r8,0.88289e-03_r8 /)
      kao(:, 2, 9,12) = (/ &
        & 0.54631e-03_r8,0.79621e-03_r8,0.10351e-02_r8,0.12356e-02_r8,0.13999e-02_r8, &
        & 0.15332e-02_r8,0.16343e-02_r8,0.17287e-02_r8,0.90009e-03_r8 /)
      kao(:, 3, 9,12) = (/ &
        & 0.54838e-03_r8,0.79738e-03_r8,0.10366e-02_r8,0.12358e-02_r8,0.14008e-02_r8, &
        & 0.15312e-02_r8,0.16325e-02_r8,0.17267e-02_r8,0.91715e-03_r8 /)
      kao(:, 4, 9,12) = (/ &
        & 0.55103e-03_r8,0.79925e-03_r8,0.10373e-02_r8,0.12370e-02_r8,0.14003e-02_r8, &
        & 0.15313e-02_r8,0.16317e-02_r8,0.17265e-02_r8,0.93948e-03_r8 /)
      kao(:, 5, 9,12) = (/ &
        & 0.55358e-03_r8,0.80158e-03_r8,0.10391e-02_r8,0.12370e-02_r8,0.14008e-02_r8, &
        & 0.15320e-02_r8,0.16328e-02_r8,0.17271e-02_r8,0.97099e-03_r8 /)
      kao(:, 1,10,12) = (/ &
        & 0.45828e-03_r8,0.73128e-03_r8,0.97725e-03_r8,0.11801e-02_r8,0.13541e-02_r8, &
        & 0.14966e-02_r8,0.16059e-02_r8,0.17081e-02_r8,0.25261e-04_r8 /)
      kao(:, 2,10,12) = (/ &
        & 0.45994e-03_r8,0.73433e-03_r8,0.98047e-03_r8,0.11852e-02_r8,0.13571e-02_r8, &
        & 0.14993e-02_r8,0.16071e-02_r8,0.17093e-02_r8,0.32778e-04_r8 /)
      kao(:, 3,10,12) = (/ &
        & 0.46172e-03_r8,0.73698e-03_r8,0.98332e-03_r8,0.11877e-02_r8,0.13607e-02_r8, &
        & 0.15001e-02_r8,0.16089e-02_r8,0.17098e-02_r8,0.30108e-04_r8 /)
      kao(:, 4,10,12) = (/ &
        & 0.46419e-03_r8,0.73967e-03_r8,0.98568e-03_r8,0.11903e-02_r8,0.13620e-02_r8, &
        & 0.15042e-02_r8,0.16117e-02_r8,0.17131e-02_r8,0.14814e-04_r8 /)
      kao(:, 5,10,12) = (/ &
        & 0.46710e-03_r8,0.74287e-03_r8,0.98852e-03_r8,0.11927e-02_r8,0.13653e-02_r8, &
        & 0.15080e-02_r8,0.16153e-02_r8,0.17174e-02_r8,0.18206e-04_r8 /)
      kao(:, 1,11,12) = (/ &
        & 0.38711e-03_r8,0.67660e-03_r8,0.92352e-03_r8,0.11285e-02_r8,0.13042e-02_r8, &
        & 0.14533e-02_r8,0.15680e-02_r8,0.16768e-02_r8,0.35375e-04_r8 /)
      kao(:, 2,11,12) = (/ &
        & 0.38827e-03_r8,0.68076e-03_r8,0.92811e-03_r8,0.11355e-02_r8,0.13110e-02_r8, &
        & 0.14578e-02_r8,0.15732e-02_r8,0.16802e-02_r8,0.17785e-04_r8 /)
      kao(:, 3,11,12) = (/ &
        & 0.39017e-03_r8,0.68339e-03_r8,0.93243e-03_r8,0.11404e-02_r8,0.13179e-02_r8, &
        & 0.14648e-02_r8,0.15809e-02_r8,0.16870e-02_r8,0.17310e-04_r8 /)
      kao(:, 4,11,12) = (/ &
        & 0.39259e-03_r8,0.68706e-03_r8,0.93609e-03_r8,0.11451e-02_r8,0.13243e-02_r8, &
        & 0.14746e-02_r8,0.15892e-02_r8,0.16958e-02_r8,0.17795e-04_r8 /)
      kao(:, 5,11,12) = (/ &
        & 0.39544e-03_r8,0.69011e-03_r8,0.94016e-03_r8,0.11496e-02_r8,0.13318e-02_r8, &
        & 0.14825e-02_r8,0.15980e-02_r8,0.17052e-02_r8,0.87581e-05_r8 /)
      kao(:, 1,12,12) = (/ &
        & 0.32882e-03_r8,0.62658e-03_r8,0.87124e-03_r8,0.10770e-02_r8,0.12526e-02_r8, &
        & 0.14042e-02_r8,0.15246e-02_r8,0.16367e-02_r8,0.13823e-04_r8 /)
      kao(:, 2,12,12) = (/ &
        & 0.33008e-03_r8,0.63068e-03_r8,0.87790e-03_r8,0.10857e-02_r8,0.12638e-02_r8, &
        & 0.14155e-02_r8,0.15376e-02_r8,0.16473e-02_r8,0.27356e-04_r8 /)
      kao(:, 3,12,12) = (/ &
        & 0.33191e-03_r8,0.63479e-03_r8,0.88401e-03_r8,0.10939e-02_r8,0.12749e-02_r8, &
        & 0.14298e-02_r8,0.15521e-02_r8,0.16615e-02_r8,0.26924e-04_r8 /)
      kao(:, 4,12,12) = (/ &
        & 0.33384e-03_r8,0.63914e-03_r8,0.88945e-03_r8,0.11023e-02_r8,0.12871e-02_r8, &
        & 0.14439e-02_r8,0.15651e-02_r8,0.16755e-02_r8,0.13486e-04_r8 /)
      kao(:, 5,12,12) = (/ &
        & 0.33630e-03_r8,0.64288e-03_r8,0.89554e-03_r8,0.11106e-02_r8,0.12985e-02_r8, &
        & 0.14567e-02_r8,0.15792e-02_r8,0.16910e-02_r8,0.54470e-04_r8 /)
      kao(:, 1,13,12) = (/ &
        & 0.28179e-03_r8,0.58039e-03_r8,0.82131e-03_r8,0.10258e-02_r8,0.12001e-02_r8, &
        & 0.13522e-02_r8,0.14762e-02_r8,0.15892e-02_r8,0.17365e-04_r8 /)
      kao(:, 2,13,12) = (/ &
        & 0.28322e-03_r8,0.58517e-03_r8,0.83048e-03_r8,0.10376e-02_r8,0.12180e-02_r8, &
        & 0.13721e-02_r8,0.14980e-02_r8,0.16092e-02_r8,0.19167e-10_r8 /)
      kao(:, 3,13,12) = (/ &
        & 0.28449e-03_r8,0.59004e-03_r8,0.83867e-03_r8,0.10495e-02_r8,0.12349e-02_r8, &
        & 0.13937e-02_r8,0.15189e-02_r8,0.16302e-02_r8,0.17686e-04_r8 /)
      kao(:, 4,13,12) = (/ &
        & 0.28623e-03_r8,0.59506e-03_r8,0.84661e-03_r8,0.10616e-02_r8,0.12511e-02_r8, &
        & 0.14124e-02_r8,0.15380e-02_r8,0.16505e-02_r8,0.27174e-10_r8 /)
      kao(:, 5,13,12) = (/ &
        & 0.28834e-03_r8,0.60000e-03_r8,0.85510e-03_r8,0.10735e-02_r8,0.12664e-02_r8, &
        & 0.14298e-02_r8,0.15583e-02_r8,0.16724e-02_r8,0.30930e-10_r8 /)
      kao(:, 1, 1,13) = (/ &
        & 0.39229e-02_r8,0.34326e-02_r8,0.30162e-02_r8,0.28699e-02_r8,0.28381e-02_r8, &
        & 0.27734e-02_r8,0.26260e-02_r8,0.23062e-02_r8,0.25522e-02_r8 /)
      kao(:, 2, 1,13) = (/ &
        & 0.39213e-02_r8,0.34310e-02_r8,0.30108e-02_r8,0.28565e-02_r8,0.28216e-02_r8, &
        & 0.27552e-02_r8,0.26075e-02_r8,0.22956e-02_r8,0.25296e-02_r8 /)
      kao(:, 3, 1,13) = (/ &
        & 0.39180e-02_r8,0.34283e-02_r8,0.30095e-02_r8,0.28490e-02_r8,0.28140e-02_r8, &
        & 0.27516e-02_r8,0.26057e-02_r8,0.23031e-02_r8,0.25320e-02_r8 /)
      kao(:, 4, 1,13) = (/ &
        & 0.39161e-02_r8,0.34265e-02_r8,0.30039e-02_r8,0.28320e-02_r8,0.27864e-02_r8, &
        & 0.27263e-02_r8,0.25779e-02_r8,0.22767e-02_r8,0.24834e-02_r8 /)
      kao(:, 5, 1,13) = (/ &
        & 0.39129e-02_r8,0.34239e-02_r8,0.29985e-02_r8,0.28202e-02_r8,0.27725e-02_r8, &
        & 0.27107e-02_r8,0.25647e-02_r8,0.22654e-02_r8,0.24632e-02_r8 /)
      kao(:, 1, 2,13) = (/ &
        & 0.35717e-02_r8,0.31250e-02_r8,0.28583e-02_r8,0.28716e-02_r8,0.28885e-02_r8, &
        & 0.28569e-02_r8,0.27419e-02_r8,0.24528e-02_r8,0.26589e-02_r8 /)
      kao(:, 2, 2,13) = (/ &
        & 0.35704e-02_r8,0.31241e-02_r8,0.28509e-02_r8,0.28521e-02_r8,0.28717e-02_r8, &
        & 0.28411e-02_r8,0.27277e-02_r8,0.24440e-02_r8,0.26352e-02_r8 /)
      kao(:, 3, 2,13) = (/ &
        & 0.35692e-02_r8,0.31228e-02_r8,0.28479e-02_r8,0.28438e-02_r8,0.28636e-02_r8, &
        & 0.28419e-02_r8,0.27327e-02_r8,0.24542e-02_r8,0.26382e-02_r8 /)
      kao(:, 4, 2,13) = (/ &
        & 0.35651e-02_r8,0.31194e-02_r8,0.28382e-02_r8,0.28288e-02_r8,0.28472e-02_r8, &
        & 0.28288e-02_r8,0.27211e-02_r8,0.24428e-02_r8,0.26140e-02_r8 /)
      kao(:, 5, 2,13) = (/ &
        & 0.35614e-02_r8,0.31162e-02_r8,0.28280e-02_r8,0.28080e-02_r8,0.28270e-02_r8, &
        & 0.28018e-02_r8,0.26919e-02_r8,0.24122e-02_r8,0.25721e-02_r8 /)
      kao(:, 1, 3,13) = (/ &
        & 0.32370e-02_r8,0.28408e-02_r8,0.27429e-02_r8,0.28459e-02_r8,0.29107e-02_r8, &
        & 0.29163e-02_r8,0.28452e-02_r8,0.26013e-02_r8,0.27589e-02_r8 /)
      kao(:, 2, 3,13) = (/ &
        & 0.32378e-02_r8,0.28409e-02_r8,0.27346e-02_r8,0.28282e-02_r8,0.28967e-02_r8, &
        & 0.29036e-02_r8,0.28357e-02_r8,0.25912e-02_r8,0.27381e-02_r8 /)
      kao(:, 3, 3,13) = (/ &
        & 0.32344e-02_r8,0.28366e-02_r8,0.27224e-02_r8,0.28159e-02_r8,0.28824e-02_r8, &
        & 0.28940e-02_r8,0.28268e-02_r8,0.25801e-02_r8,0.27164e-02_r8 /)
      kao(:, 4, 3,13) = (/ &
        & 0.32328e-02_r8,0.28349e-02_r8,0.27139e-02_r8,0.28071e-02_r8,0.28820e-02_r8, &
        & 0.28985e-02_r8,0.28328e-02_r8,0.25870e-02_r8,0.27280e-02_r8 /)
      kao(:, 5, 3,13) = (/ &
        & 0.32337e-02_r8,0.28348e-02_r8,0.27027e-02_r8,0.27877e-02_r8,0.28613e-02_r8, &
        & 0.28723e-02_r8,0.28004e-02_r8,0.25498e-02_r8,0.26848e-02_r8 /)
      kao(:, 1, 4,13) = (/ &
        & 0.29442e-02_r8,0.26158e-02_r8,0.26686e-02_r8,0.28002e-02_r8,0.29074e-02_r8, &
        & 0.29569e-02_r8,0.29354e-02_r8,0.27381e-02_r8,0.28491e-02_r8 /)
      kao(:, 2, 4,13) = (/ &
        & 0.29416e-02_r8,0.26110e-02_r8,0.26570e-02_r8,0.27866e-02_r8,0.28959e-02_r8, &
        & 0.29477e-02_r8,0.29295e-02_r8,0.27262e-02_r8,0.28287e-02_r8 /)
      kao(:, 3, 4,13) = (/ &
        & 0.29392e-02_r8,0.26064e-02_r8,0.26421e-02_r8,0.27765e-02_r8,0.28845e-02_r8, &
        & 0.29406e-02_r8,0.29202e-02_r8,0.27107e-02_r8,0.28099e-02_r8 /)
      kao(:, 4, 4,13) = (/ &
        & 0.29406e-02_r8,0.26055e-02_r8,0.26309e-02_r8,0.27645e-02_r8,0.28769e-02_r8, &
        & 0.29312e-02_r8,0.29057e-02_r8,0.26928e-02_r8,0.27972e-02_r8 /)
      kao(:, 5, 4,13) = (/ &
        & 0.29379e-02_r8,0.26016e-02_r8,0.26230e-02_r8,0.27605e-02_r8,0.28772e-02_r8, &
        & 0.29338e-02_r8,0.29114e-02_r8,0.26956e-02_r8,0.28225e-02_r8 /)
      kao(:, 1, 5,13) = (/ &
        & 0.26861e-02_r8,0.24510e-02_r8,0.26014e-02_r8,0.27478e-02_r8,0.28811e-02_r8, &
        & 0.29878e-02_r8,0.30091e-02_r8,0.28610e-02_r8,0.29320e-02_r8 /)
      kao(:, 2, 5,13) = (/ &
        & 0.26822e-02_r8,0.24426e-02_r8,0.25898e-02_r8,0.27369e-02_r8,0.28725e-02_r8, &
        & 0.29815e-02_r8,0.30039e-02_r8,0.28485e-02_r8,0.29157e-02_r8 /)
      kao(:, 3, 5,13) = (/ &
        & 0.26829e-02_r8,0.24377e-02_r8,0.25766e-02_r8,0.27289e-02_r8,0.28648e-02_r8, &
        & 0.29741e-02_r8,0.29940e-02_r8,0.28292e-02_r8,0.29014e-02_r8 /)
      kao(:, 4, 5,13) = (/ &
        & 0.26816e-02_r8,0.24329e-02_r8,0.25674e-02_r8,0.27192e-02_r8,0.28602e-02_r8, &
        & 0.29643e-02_r8,0.29808e-02_r8,0.28105e-02_r8,0.28911e-02_r8 /)
      kao(:, 5, 5,13) = (/ &
        & 0.26776e-02_r8,0.24242e-02_r8,0.25584e-02_r8,0.27174e-02_r8,0.28631e-02_r8, &
        & 0.29690e-02_r8,0.29916e-02_r8,0.28176e-02_r8,0.29253e-02_r8 /)
      kao(:, 1, 6,13) = (/ &
        & 0.24590e-02_r8,0.23376e-02_r8,0.25355e-02_r8,0.26945e-02_r8,0.28553e-02_r8, &
        & 0.29996e-02_r8,0.30574e-02_r8,0.29544e-02_r8,0.30033e-02_r8 /)
      kao(:, 2, 6,13) = (/ &
        & 0.24565e-02_r8,0.23281e-02_r8,0.25242e-02_r8,0.26862e-02_r8,0.28495e-02_r8, &
        & 0.29966e-02_r8,0.30559e-02_r8,0.29459e-02_r8,0.29901e-02_r8 /)
      kao(:, 3, 6,13) = (/ &
        & 0.24594e-02_r8,0.23224e-02_r8,0.25135e-02_r8,0.26796e-02_r8,0.28441e-02_r8, &
        & 0.29914e-02_r8,0.30494e-02_r8,0.29315e-02_r8,0.29796e-02_r8 /)
      kao(:, 4, 6,13) = (/ &
        & 0.24561e-02_r8,0.23120e-02_r8,0.25070e-02_r8,0.26723e-02_r8,0.28398e-02_r8, &
        & 0.29830e-02_r8,0.30431e-02_r8,0.29165e-02_r8,0.29718e-02_r8 /)
      kao(:, 5, 6,13) = (/ &
        & 0.24544e-02_r8,0.23009e-02_r8,0.24971e-02_r8,0.26678e-02_r8,0.28335e-02_r8, &
        & 0.29758e-02_r8,0.30342e-02_r8,0.29019e-02_r8,0.29654e-02_r8 /)
      kao(:, 1, 7,13) = (/ &
        & 0.22277e-02_r8,0.22296e-02_r8,0.24669e-02_r8,0.26497e-02_r8,0.28285e-02_r8, &
        & 0.29885e-02_r8,0.30855e-02_r8,0.30292e-02_r8,0.30616e-02_r8 /)
      kao(:, 2, 7,13) = (/ &
        & 0.22293e-02_r8,0.22219e-02_r8,0.24569e-02_r8,0.26437e-02_r8,0.28247e-02_r8, &
        & 0.29924e-02_r8,0.30879e-02_r8,0.30266e-02_r8,0.30510e-02_r8 /)
      kao(:, 3, 7,13) = (/ &
        & 0.22351e-02_r8,0.22176e-02_r8,0.24495e-02_r8,0.26382e-02_r8,0.28222e-02_r8, &
        & 0.29913e-02_r8,0.30877e-02_r8,0.30175e-02_r8,0.30415e-02_r8 /)
      kao(:, 4, 7,13) = (/ &
        & 0.22344e-02_r8,0.22079e-02_r8,0.24453e-02_r8,0.26324e-02_r8,0.28192e-02_r8, &
        & 0.29887e-02_r8,0.30862e-02_r8,0.30074e-02_r8,0.30342e-02_r8 /)
      kao(:, 5, 7,13) = (/ &
        & 0.22361e-02_r8,0.21982e-02_r8,0.24378e-02_r8,0.26291e-02_r8,0.28143e-02_r8, &
        & 0.29850e-02_r8,0.30822e-02_r8,0.29969e-02_r8,0.30270e-02_r8 /)
      kao(:, 1, 8,13) = (/ &
        & 0.19878e-02_r8,0.21080e-02_r8,0.23886e-02_r8,0.26087e-02_r8,0.27952e-02_r8, &
        & 0.29676e-02_r8,0.31003e-02_r8,0.30904e-02_r8,0.31018e-02_r8 /)
      kao(:, 2, 8,13) = (/ &
        & 0.19936e-02_r8,0.21034e-02_r8,0.23825e-02_r8,0.26049e-02_r8,0.27978e-02_r8, &
        & 0.29755e-02_r8,0.31107e-02_r8,0.30954e-02_r8,0.30940e-02_r8 /)
      kao(:, 3, 8,13) = (/ &
        & 0.20012e-02_r8,0.21016e-02_r8,0.23778e-02_r8,0.26010e-02_r8,0.27982e-02_r8, &
        & 0.29815e-02_r8,0.31166e-02_r8,0.30929e-02_r8,0.30865e-02_r8 /)
      kao(:, 4, 8,13) = (/ &
        & 0.20034e-02_r8,0.20960e-02_r8,0.23764e-02_r8,0.25979e-02_r8,0.27992e-02_r8, &
        & 0.29823e-02_r8,0.31192e-02_r8,0.30868e-02_r8,0.30812e-02_r8 /)
      kao(:, 5, 8,13) = (/ &
        & 0.20095e-02_r8,0.20891e-02_r8,0.23711e-02_r8,0.25960e-02_r8,0.27964e-02_r8, &
        & 0.29828e-02_r8,0.31181e-02_r8,0.30806e-02_r8,0.30733e-02_r8 /)
      kao(:, 1, 9,13) = (/ &
        & 0.17523e-02_r8,0.19789e-02_r8,0.23024e-02_r8,0.25572e-02_r8,0.27629e-02_r8, &
        & 0.29479e-02_r8,0.31085e-02_r8,0.31444e-02_r8,0.30417e-02_r8 /)
      kao(:, 2, 9,13) = (/ &
        & 0.17607e-02_r8,0.19777e-02_r8,0.23013e-02_r8,0.25587e-02_r8,0.27691e-02_r8, &
        & 0.29613e-02_r8,0.31227e-02_r8,0.31535e-02_r8,0.30346e-02_r8 /)
      kao(:, 3, 9,13) = (/ &
        & 0.17693e-02_r8,0.19800e-02_r8,0.23011e-02_r8,0.25605e-02_r8,0.27739e-02_r8, &
        & 0.29714e-02_r8,0.31329e-02_r8,0.31549e-02_r8,0.30299e-02_r8 /)
      kao(:, 4, 9,13) = (/ &
        & 0.17751e-02_r8,0.19773e-02_r8,0.23025e-02_r8,0.25606e-02_r8,0.27770e-02_r8, &
        & 0.29770e-02_r8,0.31405e-02_r8,0.31532e-02_r8,0.30280e-02_r8 /)
      kao(:, 5, 9,13) = (/ &
        & 0.17845e-02_r8,0.19738e-02_r8,0.23006e-02_r8,0.25633e-02_r8,0.27766e-02_r8, &
        & 0.29802e-02_r8,0.31452e-02_r8,0.31517e-02_r8,0.30317e-02_r8 /)
      kao(:, 1,10,13) = (/ &
        & 0.15244e-02_r8,0.18437e-02_r8,0.22100e-02_r8,0.24972e-02_r8,0.27331e-02_r8, &
        & 0.29304e-02_r8,0.31059e-02_r8,0.31844e-02_r8,0.23817e-04_r8 /)
      kao(:, 2,10,13) = (/ &
        & 0.15360e-02_r8,0.18467e-02_r8,0.22145e-02_r8,0.25068e-02_r8,0.27437e-02_r8, &
        & 0.29473e-02_r8,0.31260e-02_r8,0.31986e-02_r8,0.12454e-04_r8 /)
      kao(:, 3,10,13) = (/ &
        & 0.15476e-02_r8,0.18512e-02_r8,0.22181e-02_r8,0.25119e-02_r8,0.27538e-02_r8, &
        & 0.29593e-02_r8,0.31389e-02_r8,0.32042e-02_r8,0.30814e-04_r8 /)
      kao(:, 4,10,13) = (/ &
        & 0.15571e-02_r8,0.18528e-02_r8,0.22235e-02_r8,0.25174e-02_r8,0.27591e-02_r8, &
        & 0.29666e-02_r8,0.31497e-02_r8,0.32063e-02_r8,0.11698e-04_r8 /)
      kao(:, 5,10,13) = (/ &
        & 0.15695e-02_r8,0.18534e-02_r8,0.22262e-02_r8,0.25236e-02_r8,0.27611e-02_r8, &
        & 0.29733e-02_r8,0.31600e-02_r8,0.32093e-02_r8,0.22330e-04_r8 /)
      kao(:, 1,11,13) = (/ &
        & 0.13188e-02_r8,0.17123e-02_r8,0.21150e-02_r8,0.24398e-02_r8,0.27060e-02_r8, &
        & 0.29190e-02_r8,0.31061e-02_r8,0.32197e-02_r8,0.11689e-04_r8 /)
      kao(:, 2,11,13) = (/ &
        & 0.13341e-02_r8,0.17189e-02_r8,0.21240e-02_r8,0.24532e-02_r8,0.27222e-02_r8, &
        & 0.29371e-02_r8,0.31262e-02_r8,0.32338e-02_r8,0.11845e-04_r8 /)
      kao(:, 3,11,13) = (/ &
        & 0.13447e-02_r8,0.17274e-02_r8,0.21339e-02_r8,0.24651e-02_r8,0.27343e-02_r8, &
        & 0.29498e-02_r8,0.31430e-02_r8,0.32440e-02_r8,0.24255e-04_r8 /)
      kao(:, 4,11,13) = (/ &
        & 0.13578e-02_r8,0.17324e-02_r8,0.21454e-02_r8,0.24765e-02_r8,0.27400e-02_r8, &
        & 0.29585e-02_r8,0.31579e-02_r8,0.32502e-02_r8,0.35648e-04_r8 /)
      kao(:, 5,11,13) = (/ &
        & 0.13715e-02_r8,0.17394e-02_r8,0.21518e-02_r8,0.24842e-02_r8,0.27436e-02_r8, &
        & 0.29689e-02_r8,0.31719e-02_r8,0.32570e-02_r8,0.48216e-04_r8 /)
      kao(:, 1,12,13) = (/ &
        & 0.11367e-02_r8,0.15942e-02_r8,0.20255e-02_r8,0.23827e-02_r8,0.26757e-02_r8, &
        & 0.29001e-02_r8,0.30944e-02_r8,0.32386e-02_r8,0.48616e-12_r8 /)
      kao(:, 2,12,13) = (/ &
        & 0.11495e-02_r8,0.16057e-02_r8,0.20405e-02_r8,0.24019e-02_r8,0.26965e-02_r8, &
        & 0.29177e-02_r8,0.31160e-02_r8,0.32553e-02_r8,0.63803e-12_r8 /)
      kao(:, 3,12,13) = (/ &
        & 0.11626e-02_r8,0.16147e-02_r8,0.20558e-02_r8,0.24193e-02_r8,0.27102e-02_r8, &
        & 0.29330e-02_r8,0.31363e-02_r8,0.32673e-02_r8,0.18451e-04_r8 /)
      kao(:, 4,12,13) = (/ &
        & 0.11784e-02_r8,0.16224e-02_r8,0.20681e-02_r8,0.24334e-02_r8,0.27187e-02_r8, &
        & 0.29473e-02_r8,0.31560e-02_r8,0.32789e-02_r8,0.93725e-12_r8 /)
      kao(:, 5,12,13) = (/ &
        & 0.11935e-02_r8,0.16327e-02_r8,0.20790e-02_r8,0.24438e-02_r8,0.27275e-02_r8, &
        & 0.29614e-02_r8,0.31756e-02_r8,0.32901e-02_r8,0.36773e-04_r8 /)
      kao(:, 1,13,13) = (/ &
        & 0.97386e-03_r8,0.14865e-02_r8,0.19422e-02_r8,0.23265e-02_r8,0.26377e-02_r8, &
        & 0.28742e-02_r8,0.30758e-02_r8,0.32440e-02_r8,0.42838e-12_r8 /)
      kao(:, 2,13,13) = (/ &
        & 0.98704e-03_r8,0.15018e-02_r8,0.19617e-02_r8,0.23518e-02_r8,0.26608e-02_r8, &
        & 0.28955e-02_r8,0.31025e-02_r8,0.32660e-02_r8,0.54956e-12_r8 /)
      kao(:, 3,13,13) = (/ &
        & 0.10034e-02_r8,0.15127e-02_r8,0.19822e-02_r8,0.23722e-02_r8,0.26791e-02_r8, &
        & 0.29131e-02_r8,0.31272e-02_r8,0.32827e-02_r8,0.68281e-12_r8 /)
      kao(:, 4,13,13) = (/ &
        & 0.10185e-02_r8,0.15248e-02_r8,0.19990e-02_r8,0.23896e-02_r8,0.26942e-02_r8, &
        & 0.29331e-02_r8,0.31525e-02_r8,0.33003e-02_r8,0.47348e-04_r8 /)
      kao(:, 5,13,13) = (/ &
        & 0.10353e-02_r8,0.15370e-02_r8,0.20122e-02_r8,0.24032e-02_r8,0.27096e-02_r8, &
        & 0.29526e-02_r8,0.31774e-02_r8,0.33154e-02_r8,0.94094e-12_r8 /)
      kao(:, 1, 1,14) = (/ &
        & 0.11127e-01_r8,0.97365e-02_r8,0.83450e-02_r8,0.69546e-02_r8,0.57518e-02_r8, &
        & 0.48972e-02_r8,0.42517e-02_r8,0.34771e-02_r8,0.44616e-02_r8 /)
      kao(:, 2, 1,14) = (/ &
        & 0.11168e-01_r8,0.97719e-02_r8,0.83762e-02_r8,0.69801e-02_r8,0.57613e-02_r8, &
        & 0.48914e-02_r8,0.42324e-02_r8,0.34356e-02_r8,0.44183e-02_r8 /)
      kao(:, 3, 1,14) = (/ &
        & 0.11206e-01_r8,0.98061e-02_r8,0.84051e-02_r8,0.70040e-02_r8,0.57786e-02_r8, &
        & 0.48973e-02_r8,0.42300e-02_r8,0.34167e-02_r8,0.44088e-02_r8 /)
      kao(:, 4, 1,14) = (/ &
        & 0.11230e-01_r8,0.98265e-02_r8,0.84228e-02_r8,0.70190e-02_r8,0.57794e-02_r8, &
        & 0.48702e-02_r8,0.41927e-02_r8,0.33658e-02_r8,0.43365e-02_r8 /)
      kao(:, 5, 1,14) = (/ &
        & 0.11247e-01_r8,0.98411e-02_r8,0.84348e-02_r8,0.70292e-02_r8,0.57800e-02_r8, &
        & 0.48600e-02_r8,0.41735e-02_r8,0.33367e-02_r8,0.43003e-02_r8 /)
      kao(:, 1, 2,14) = (/ &
        & 0.11360e-01_r8,0.99403e-02_r8,0.85204e-02_r8,0.71449e-02_r8,0.60754e-02_r8, &
        & 0.53678e-02_r8,0.47333e-02_r8,0.38804e-02_r8,0.48459e-02_r8 /)
      kao(:, 2, 2,14) = (/ &
        & 0.11402e-01_r8,0.99768e-02_r8,0.85517e-02_r8,0.71687e-02_r8,0.60816e-02_r8, &
        & 0.53522e-02_r8,0.47062e-02_r8,0.38343e-02_r8,0.48034e-02_r8 /)
      kao(:, 3, 2,14) = (/ &
        & 0.11432e-01_r8,0.10003e-01_r8,0.85744e-02_r8,0.71872e-02_r8,0.60934e-02_r8, &
        & 0.53498e-02_r8,0.46968e-02_r8,0.38177e-02_r8,0.48004e-02_r8 /)
      kao(:, 4, 2,14) = (/ &
        & 0.11460e-01_r8,0.10028e-01_r8,0.85956e-02_r8,0.72000e-02_r8,0.60909e-02_r8, &
        & 0.53282e-02_r8,0.46686e-02_r8,0.37852e-02_r8,0.47598e-02_r8 /)
      kao(:, 5, 2,14) = (/ &
        & 0.11484e-01_r8,0.10049e-01_r8,0.86132e-02_r8,0.72108e-02_r8,0.60794e-02_r8, &
        & 0.52951e-02_r8,0.46284e-02_r8,0.37347e-02_r8,0.46895e-02_r8 /)
      kao(:, 1, 3,14) = (/ &
        & 0.11375e-01_r8,0.99535e-02_r8,0.85318e-02_r8,0.72748e-02_r8,0.63965e-02_r8, &
        & 0.58374e-02_r8,0.52215e-02_r8,0.43002e-02_r8,0.52258e-02_r8 /)
      kao(:, 2, 3,14) = (/ &
        & 0.11412e-01_r8,0.99855e-02_r8,0.85592e-02_r8,0.72909e-02_r8,0.63926e-02_r8, &
        & 0.58142e-02_r8,0.51838e-02_r8,0.42530e-02_r8,0.51857e-02_r8 /)
      kao(:, 3, 3,14) = (/ &
        & 0.11451e-01_r8,0.10019e-01_r8,0.85873e-02_r8,0.73027e-02_r8,0.63856e-02_r8, &
        & 0.57886e-02_r8,0.51485e-02_r8,0.42153e-02_r8,0.51479e-02_r8 /)
      kao(:, 4, 3,14) = (/ &
        & 0.11483e-01_r8,0.10047e-01_r8,0.86122e-02_r8,0.73190e-02_r8,0.63840e-02_r8, &
        & 0.57742e-02_r8,0.51342e-02_r8,0.42027e-02_r8,0.51482e-02_r8 /)
      kao(:, 5, 3,14) = (/ &
        & 0.11512e-01_r8,0.10073e-01_r8,0.86339e-02_r8,0.73301e-02_r8,0.63706e-02_r8, &
        & 0.57344e-02_r8,0.50899e-02_r8,0.41496e-02_r8,0.50782e-02_r8 /)
      kao(:, 1, 4,14) = (/ &
        & 0.11149e-01_r8,0.97560e-02_r8,0.83906e-02_r8,0.73568e-02_r8,0.67050e-02_r8, &
        & 0.62789e-02_r8,0.56809e-02_r8,0.47244e-02_r8,0.55742e-02_r8 /)
      kao(:, 2, 4,14) = (/ &
        & 0.11201e-01_r8,0.98016e-02_r8,0.84237e-02_r8,0.73684e-02_r8,0.66927e-02_r8, &
        & 0.62506e-02_r8,0.56398e-02_r8,0.46775e-02_r8,0.55381e-02_r8 /)
      kao(:, 3, 4,14) = (/ &
        & 0.11250e-01_r8,0.98437e-02_r8,0.84576e-02_r8,0.73794e-02_r8,0.66793e-02_r8, &
        & 0.62192e-02_r8,0.56018e-02_r8,0.46402e-02_r8,0.55028e-02_r8 /)
      kao(:, 4, 4,14) = (/ &
        & 0.11293e-01_r8,0.98814e-02_r8,0.84883e-02_r8,0.73928e-02_r8,0.66658e-02_r8, &
        & 0.61879e-02_r8,0.55699e-02_r8,0.46073e-02_r8,0.54669e-02_r8 /)
      kao(:, 5, 4,14) = (/ &
        & 0.11341e-01_r8,0.99237e-02_r8,0.85206e-02_r8,0.74085e-02_r8,0.66636e-02_r8, &
        & 0.61710e-02_r8,0.55548e-02_r8,0.45934e-02_r8,0.54646e-02_r8 /)
      kao(:, 1, 5,14) = (/ &
        & 0.10704e-01_r8,0.93660e-02_r8,0.81568e-02_r8,0.74021e-02_r8,0.69945e-02_r8, &
        & 0.66654e-02_r8,0.61172e-02_r8,0.51470e-02_r8,0.58967e-02_r8 /)
      kao(:, 2, 5,14) = (/ &
        & 0.10771e-01_r8,0.94250e-02_r8,0.81953e-02_r8,0.74101e-02_r8,0.69769e-02_r8, &
        & 0.66347e-02_r8,0.60743e-02_r8,0.50992e-02_r8,0.58616e-02_r8 /)
      kao(:, 3, 5,14) = (/ &
        & 0.10834e-01_r8,0.94795e-02_r8,0.82348e-02_r8,0.74202e-02_r8,0.69586e-02_r8, &
        & 0.66047e-02_r8,0.60376e-02_r8,0.50623e-02_r8,0.58279e-02_r8 /)
      kao(:, 4, 5,14) = (/ &
        & 0.10899e-01_r8,0.95365e-02_r8,0.82726e-02_r8,0.74343e-02_r8,0.69400e-02_r8, &
        & 0.65760e-02_r8,0.60076e-02_r8,0.50289e-02_r8,0.57953e-02_r8 /)
      kao(:, 5, 5,14) = (/ &
        & 0.10965e-01_r8,0.95941e-02_r8,0.83123e-02_r8,0.74464e-02_r8,0.69292e-02_r8, &
        & 0.65626e-02_r8,0.59940e-02_r8,0.50178e-02_r8,0.57938e-02_r8 /)
      kao(:, 1, 6,14) = (/ &
        & 0.10078e-01_r8,0.88178e-02_r8,0.78666e-02_r8,0.74112e-02_r8,0.72308e-02_r8, &
        & 0.70100e-02_r8,0.65312e-02_r8,0.55779e-02_r8,0.62140e-02_r8 /)
      kao(:, 2, 6,14) = (/ &
        & 0.10161e-01_r8,0.88906e-02_r8,0.79113e-02_r8,0.74185e-02_r8,0.72160e-02_r8, &
        & 0.69843e-02_r8,0.64888e-02_r8,0.55247e-02_r8,0.61818e-02_r8 /)
      kao(:, 3, 6,14) = (/ &
        & 0.10243e-01_r8,0.89616e-02_r8,0.79583e-02_r8,0.74318e-02_r8,0.71999e-02_r8, &
        & 0.69579e-02_r8,0.64523e-02_r8,0.54833e-02_r8,0.61492e-02_r8 /)
      kao(:, 4, 6,14) = (/ &
        & 0.10327e-01_r8,0.90374e-02_r8,0.79989e-02_r8,0.74443e-02_r8,0.71832e-02_r8, &
        & 0.69350e-02_r8,0.64210e-02_r8,0.54479e-02_r8,0.61172e-02_r8 /)
      kao(:, 5, 6,14) = (/ &
        & 0.10409e-01_r8,0.91075e-02_r8,0.80421e-02_r8,0.74489e-02_r8,0.71645e-02_r8, &
        & 0.69118e-02_r8,0.63952e-02_r8,0.54129e-02_r8,0.60849e-02_r8 /)
      kao(:, 1, 7,14) = (/ &
        & 0.93799e-02_r8,0.82246e-02_r8,0.75645e-02_r8,0.73983e-02_r8,0.74124e-02_r8, &
        & 0.73054e-02_r8,0.69103e-02_r8,0.59986e-02_r8,0.65205e-02_r8 /)
      kao(:, 2, 7,14) = (/ &
        & 0.94746e-02_r8,0.83048e-02_r8,0.76105e-02_r8,0.74041e-02_r8,0.74008e-02_r8, &
        & 0.72835e-02_r8,0.68745e-02_r8,0.59435e-02_r8,0.64911e-02_r8 /)
      kao(:, 3, 7,14) = (/ &
        & 0.95665e-02_r8,0.83814e-02_r8,0.76560e-02_r8,0.74150e-02_r8,0.73885e-02_r8, &
        & 0.72645e-02_r8,0.68399e-02_r8,0.59000e-02_r8,0.64612e-02_r8 /)
      kao(:, 4, 7,14) = (/ &
        & 0.96610e-02_r8,0.84615e-02_r8,0.76953e-02_r8,0.74218e-02_r8,0.73786e-02_r8, &
        & 0.72467e-02_r8,0.68110e-02_r8,0.58618e-02_r8,0.64309e-02_r8 /)
      kao(:, 5, 7,14) = (/ &
        & 0.97576e-02_r8,0.85445e-02_r8,0.77428e-02_r8,0.74271e-02_r8,0.73666e-02_r8, &
        & 0.72295e-02_r8,0.67856e-02_r8,0.58248e-02_r8,0.64018e-02_r8 /)
      kao(:, 1, 8,14) = (/ &
        & 0.86695e-02_r8,0.76539e-02_r8,0.72832e-02_r8,0.73811e-02_r8,0.75539e-02_r8, &
        & 0.75395e-02_r8,0.72391e-02_r8,0.63979e-02_r8,0.68067e-02_r8 /)
      kao(:, 2, 8,14) = (/ &
        & 0.87714e-02_r8,0.77350e-02_r8,0.73260e-02_r8,0.73889e-02_r8,0.75481e-02_r8, &
        & 0.75307e-02_r8,0.72059e-02_r8,0.63386e-02_r8,0.67797e-02_r8 /)
      kao(:, 3, 8,14) = (/ &
        & 0.88648e-02_r8,0.78065e-02_r8,0.73635e-02_r8,0.73928e-02_r8,0.75428e-02_r8, &
        & 0.75176e-02_r8,0.71786e-02_r8,0.62948e-02_r8,0.67512e-02_r8 /)
      kao(:, 4, 8,14) = (/ &
        & 0.89696e-02_r8,0.78903e-02_r8,0.74008e-02_r8,0.73947e-02_r8,0.75364e-02_r8, &
        & 0.75091e-02_r8,0.71562e-02_r8,0.62573e-02_r8,0.67249e-02_r8 /)
      kao(:, 5, 8,14) = (/ &
        & 0.90827e-02_r8,0.79827e-02_r8,0.74524e-02_r8,0.74004e-02_r8,0.75307e-02_r8, &
        & 0.75004e-02_r8,0.71406e-02_r8,0.62196e-02_r8,0.66995e-02_r8 /)
      kao(:, 1, 9,14) = (/ &
        & 0.79522e-02_r8,0.71197e-02_r8,0.70358e-02_r8,0.73522e-02_r8,0.76328e-02_r8, &
        & 0.77097e-02_r8,0.75175e-02_r8,0.67703e-02_r8,0.70524e-02_r8 /)
      kao(:, 2, 9,14) = (/ &
        & 0.80598e-02_r8,0.71969e-02_r8,0.70715e-02_r8,0.73653e-02_r8,0.76374e-02_r8, &
        & 0.77113e-02_r8,0.74908e-02_r8,0.67151e-02_r8,0.70338e-02_r8 /)
      kao(:, 3, 9,14) = (/ &
        & 0.81632e-02_r8,0.72678e-02_r8,0.71027e-02_r8,0.73712e-02_r8,0.76458e-02_r8, &
        & 0.77123e-02_r8,0.74742e-02_r8,0.66728e-02_r8,0.70182e-02_r8 /)
      kao(:, 4, 9,14) = (/ &
        & 0.82823e-02_r8,0.73561e-02_r8,0.71392e-02_r8,0.73768e-02_r8,0.76576e-02_r8, &
        & 0.77143e-02_r8,0.74622e-02_r8,0.66357e-02_r8,0.69991e-02_r8 /)
      kao(:, 5, 9,14) = (/ &
        & 0.84105e-02_r8,0.74558e-02_r8,0.71910e-02_r8,0.73874e-02_r8,0.76648e-02_r8, &
        & 0.77180e-02_r8,0.74509e-02_r8,0.65977e-02_r8,0.69736e-02_r8 /)
      kao(:, 1,10,14) = (/ &
        & 0.72630e-02_r8,0.66377e-02_r8,0.68373e-02_r8,0.72984e-02_r8,0.76509e-02_r8, &
        & 0.78294e-02_r8,0.77460e-02_r8,0.71207e-02_r8,0.20344e-04_r8 /)
      kao(:, 2,10,14) = (/ &
        & 0.73671e-02_r8,0.67055e-02_r8,0.68587e-02_r8,0.73198e-02_r8,0.76710e-02_r8, &
        & 0.78437e-02_r8,0.77323e-02_r8,0.70655e-02_r8,0.20564e-04_r8 /)
      kao(:, 3,10,14) = (/ &
        & 0.74810e-02_r8,0.67793e-02_r8,0.68858e-02_r8,0.73353e-02_r8,0.76947e-02_r8, &
        & 0.78590e-02_r8,0.77307e-02_r8,0.70272e-02_r8,0.37563e-05_r8 /)
      kao(:, 4,10,14) = (/ &
        & 0.76171e-02_r8,0.68754e-02_r8,0.69230e-02_r8,0.73502e-02_r8,0.77241e-02_r8, &
        & 0.78765e-02_r8,0.77271e-02_r8,0.69915e-02_r8,0.47236e-05_r8 /)
      kao(:, 5,10,14) = (/ &
        & 0.77608e-02_r8,0.69811e-02_r8,0.69732e-02_r8,0.73676e-02_r8,0.77455e-02_r8, &
        & 0.78941e-02_r8,0.77236e-02_r8,0.69531e-02_r8,0.26047e-04_r8 /)
      kao(:, 1,11,14) = (/ &
        & 0.66493e-02_r8,0.62366e-02_r8,0.66807e-02_r8,0.72344e-02_r8,0.76404e-02_r8, &
        & 0.79217e-02_r8,0.79405e-02_r8,0.74097e-02_r8,0.00000e+00_r8 /)
      kao(:, 2,11,14) = (/ &
        & 0.67616e-02_r8,0.63044e-02_r8,0.67053e-02_r8,0.72656e-02_r8,0.76819e-02_r8, &
        & 0.79515e-02_r8,0.79506e-02_r8,0.73718e-02_r8,0.18408e-04_r8 /)
      kao(:, 3,11,14) = (/ &
        & 0.69005e-02_r8,0.63894e-02_r8,0.67349e-02_r8,0.72931e-02_r8,0.77291e-02_r8, &
        & 0.79845e-02_r8,0.79576e-02_r8,0.73388e-02_r8,0.37607e-04_r8 /)
      kao(:, 4,11,14) = (/ &
        & 0.70530e-02_r8,0.64912e-02_r8,0.67712e-02_r8,0.73223e-02_r8,0.77726e-02_r8, &
        & 0.80170e-02_r8,0.79618e-02_r8,0.73054e-02_r8,0.56367e-04_r8 /)
      kao(:, 5,11,14) = (/ &
        & 0.72039e-02_r8,0.65911e-02_r8,0.68118e-02_r8,0.73572e-02_r8,0.78096e-02_r8, &
        & 0.80477e-02_r8,0.79648e-02_r8,0.72708e-02_r8,0.00000e+00_r8 /)
      kao(:, 1,12,14) = (/ &
        & 0.60858e-02_r8,0.58916e-02_r8,0.65335e-02_r8,0.71525e-02_r8,0.76284e-02_r8, &
        & 0.80006e-02_r8,0.81294e-02_r8,0.76675e-02_r8,0.58588e-04_r8 /)
      kao(:, 2,12,14) = (/ &
        & 0.62191e-02_r8,0.59612e-02_r8,0.65675e-02_r8,0.71998e-02_r8,0.76898e-02_r8, &
        & 0.80500e-02_r8,0.81534e-02_r8,0.76479e-02_r8,0.00000e+00_r8 /)
      kao(:, 3,12,14) = (/ &
        & 0.63725e-02_r8,0.60546e-02_r8,0.66095e-02_r8,0.72445e-02_r8,0.77558e-02_r8, &
        & 0.80973e-02_r8,0.81695e-02_r8,0.76255e-02_r8,0.29841e-04_r8 /)
      kao(:, 4,12,14) = (/ &
        & 0.65241e-02_r8,0.61494e-02_r8,0.66519e-02_r8,0.72916e-02_r8,0.78126e-02_r8, &
        & 0.81445e-02_r8,0.81839e-02_r8,0.75955e-02_r8,0.00000e+00_r8 /)
      kao(:, 5,12,14) = (/ &
        & 0.66908e-02_r8,0.62534e-02_r8,0.66904e-02_r8,0.73429e-02_r8,0.78615e-02_r8, &
        & 0.81879e-02_r8,0.81898e-02_r8,0.75652e-02_r8,0.00000e+00_r8 /)
      kao(:, 1,13,14) = (/ &
        & 0.55891e-02_r8,0.56116e-02_r8,0.63936e-02_r8,0.70621e-02_r8,0.76241e-02_r8, &
        & 0.80837e-02_r8,0.82964e-02_r8,0.79007e-02_r8,0.00000e+00_r8 /)
      kao(:, 2,13,14) = (/ &
        & 0.57354e-02_r8,0.56825e-02_r8,0.64439e-02_r8,0.71280e-02_r8,0.77039e-02_r8, &
        & 0.81460e-02_r8,0.83322e-02_r8,0.78896e-02_r8,0.38090e-04_r8 /)
      kao(:, 3,13,14) = (/ &
        & 0.58847e-02_r8,0.57651e-02_r8,0.64971e-02_r8,0.71963e-02_r8,0.77792e-02_r8, &
        & 0.82047e-02_r8,0.83632e-02_r8,0.78746e-02_r8,0.00000e+00_r8 /)
      kao(:, 4,13,14) = (/ &
        & 0.60503e-02_r8,0.58579e-02_r8,0.65448e-02_r8,0.72663e-02_r8,0.78467e-02_r8, &
        & 0.82617e-02_r8,0.83886e-02_r8,0.78555e-02_r8,0.00000e+00_r8 /)
      kao(:, 5,13,14) = (/ &
        & 0.62326e-02_r8,0.59678e-02_r8,0.65939e-02_r8,0.73313e-02_r8,0.79071e-02_r8, &
        & 0.83133e-02_r8,0.83975e-02_r8,0.78294e-02_r8,0.00000e+00_r8 /)
      kao(:, 1, 1,15) = (/ &
        & 0.22784e-01_r8,0.19937e-01_r8,0.17089e-01_r8,0.14240e-01_r8,0.11393e-01_r8, &
        & 0.85439e-02_r8,0.62360e-02_r8,0.50515e-02_r8,0.76952e-02_r8 /)
      kao(:, 2, 1,15) = (/ &
        & 0.22781e-01_r8,0.19933e-01_r8,0.17085e-01_r8,0.14238e-01_r8,0.11390e-01_r8, &
        & 0.85426e-02_r8,0.62118e-02_r8,0.49990e-02_r8,0.75953e-02_r8 /)
      kao(:, 3, 1,15) = (/ &
        & 0.22781e-01_r8,0.19934e-01_r8,0.17086e-01_r8,0.14239e-01_r8,0.11390e-01_r8, &
        & 0.85428e-02_r8,0.62149e-02_r8,0.49913e-02_r8,0.75531e-02_r8 /)
      kao(:, 4, 1,15) = (/ &
        & 0.22807e-01_r8,0.19955e-01_r8,0.17104e-01_r8,0.14253e-01_r8,0.11403e-01_r8, &
        & 0.85521e-02_r8,0.61662e-02_r8,0.48921e-02_r8,0.74213e-02_r8 /)
      kao(:, 5, 1,15) = (/ &
        & 0.22846e-01_r8,0.19991e-01_r8,0.17134e-01_r8,0.14278e-01_r8,0.11422e-01_r8, &
        & 0.85672e-02_r8,0.61477e-02_r8,0.48442e-02_r8,0.73437e-02_r8 /)
      kao(:, 1, 2,15) = (/ &
        & 0.25963e-01_r8,0.22716e-01_r8,0.19471e-01_r8,0.16227e-01_r8,0.12981e-01_r8, &
        & 0.97432e-02_r8,0.72799e-02_r8,0.58913e-02_r8,0.89930e-02_r8 /)
      kao(:, 2, 2,15) = (/ &
        & 0.25957e-01_r8,0.22712e-01_r8,0.19468e-01_r8,0.16223e-01_r8,0.12978e-01_r8, &
        & 0.97376e-02_r8,0.72409e-02_r8,0.58243e-02_r8,0.88738e-02_r8 /)
      kao(:, 3, 2,15) = (/ &
        & 0.25967e-01_r8,0.22721e-01_r8,0.19475e-01_r8,0.16229e-01_r8,0.12984e-01_r8, &
        & 0.97376e-02_r8,0.72294e-02_r8,0.57970e-02_r8,0.88082e-02_r8 /)
      kao(:, 4, 2,15) = (/ &
        & 0.25991e-01_r8,0.22741e-01_r8,0.19493e-01_r8,0.16243e-01_r8,0.12995e-01_r8, &
        & 0.97464e-02_r8,0.71939e-02_r8,0.57194e-02_r8,0.86974e-02_r8 /)
      kao(:, 5, 2,15) = (/ &
        & 0.26012e-01_r8,0.22759e-01_r8,0.19508e-01_r8,0.16256e-01_r8,0.13005e-01_r8, &
        & 0.97539e-02_r8,0.71378e-02_r8,0.56167e-02_r8,0.85506e-02_r8 /)
      kao(:, 1, 3,15) = (/ &
        & 0.29273e-01_r8,0.25614e-01_r8,0.21954e-01_r8,0.18296e-01_r8,0.14638e-01_r8, &
        & 0.11059e-01_r8,0.84536e-02_r8,0.68488e-02_r8,0.10453e-01_r8 /)
      kao(:, 2, 3,15) = (/ &
        & 0.29273e-01_r8,0.25613e-01_r8,0.21954e-01_r8,0.18296e-01_r8,0.14636e-01_r8, &
        & 0.11040e-01_r8,0.84006e-02_r8,0.67671e-02_r8,0.10308e-01_r8 /)
      kao(:, 3, 3,15) = (/ &
        & 0.29281e-01_r8,0.25620e-01_r8,0.21957e-01_r8,0.18299e-01_r8,0.14639e-01_r8, &
        & 0.11029e-01_r8,0.83532e-02_r8,0.66803e-02_r8,0.10170e-01_r8 /)
      kao(:, 4, 3,15) = (/ &
        & 0.29284e-01_r8,0.25622e-01_r8,0.21963e-01_r8,0.18303e-01_r8,0.14642e-01_r8, &
        & 0.11027e-01_r8,0.83265e-02_r8,0.66328e-02_r8,0.10072e-01_r8 /)
      kao(:, 5, 3,15) = (/ &
        & 0.29273e-01_r8,0.25615e-01_r8,0.21955e-01_r8,0.18297e-01_r8,0.14636e-01_r8, &
        & 0.11016e-01_r8,0.82524e-02_r8,0.65141e-02_r8,0.98927e-02_r8 /)
      kao(:, 1, 4,15) = (/ &
        & 0.32689e-01_r8,0.28601e-01_r8,0.24517e-01_r8,0.20431e-01_r8,0.16343e-01_r8, &
        & 0.12498e-01_r8,0.97860e-02_r8,0.79359e-02_r8,0.11964e-01_r8 /)
      kao(:, 2, 4,15) = (/ &
        & 0.32673e-01_r8,0.28590e-01_r8,0.24505e-01_r8,0.20420e-01_r8,0.16336e-01_r8, &
        & 0.12462e-01_r8,0.97090e-02_r8,0.78356e-02_r8,0.11793e-01_r8 /)
      kao(:, 3, 4,15) = (/ &
        & 0.32657e-01_r8,0.28575e-01_r8,0.24494e-01_r8,0.20410e-01_r8,0.16330e-01_r8, &
        & 0.12434e-01_r8,0.96384e-02_r8,0.77321e-02_r8,0.11625e-01_r8 /)
      kao(:, 4, 4,15) = (/ &
        & 0.32631e-01_r8,0.28553e-01_r8,0.24473e-01_r8,0.20396e-01_r8,0.16316e-01_r8, &
        & 0.12404e-01_r8,0.95671e-02_r8,0.76286e-02_r8,0.11457e-01_r8 /)
      kao(:, 5, 4,15) = (/ &
        & 0.32595e-01_r8,0.28521e-01_r8,0.24445e-01_r8,0.20372e-01_r8,0.16297e-01_r8, &
        & 0.12376e-01_r8,0.95137e-02_r8,0.75694e-02_r8,0.11318e-01_r8 /)
      kao(:, 1, 5,15) = (/ &
        & 0.36129e-01_r8,0.31613e-01_r8,0.27097e-01_r8,0.22582e-01_r8,0.18065e-01_r8, &
        & 0.14059e-01_r8,0.11253e-01_r8,0.91497e-02_r8,0.13513e-01_r8 /)
      kao(:, 2, 5,15) = (/ &
        & 0.36091e-01_r8,0.31580e-01_r8,0.27068e-01_r8,0.22557e-01_r8,0.18046e-01_r8, &
        & 0.13996e-01_r8,0.11159e-01_r8,0.90273e-02_r8,0.13314e-01_r8 /)
      kao(:, 3, 5,15) = (/ &
        & 0.36050e-01_r8,0.31543e-01_r8,0.27038e-01_r8,0.22530e-01_r8,0.18025e-01_r8, &
        & 0.13938e-01_r8,0.11057e-01_r8,0.89022e-02_r8,0.13117e-01_r8 /)
      kao(:, 4, 5,15) = (/ &
        & 0.35994e-01_r8,0.31496e-01_r8,0.26994e-01_r8,0.22495e-01_r8,0.17996e-01_r8, &
        & 0.13877e-01_r8,0.10953e-01_r8,0.87755e-02_r8,0.12914e-01_r8 /)
      kao(:, 5, 5,15) = (/ &
        & 0.35944e-01_r8,0.31450e-01_r8,0.26957e-01_r8,0.22466e-01_r8,0.17973e-01_r8, &
        & 0.13819e-01_r8,0.10863e-01_r8,0.86942e-02_r8,0.12744e-01_r8 /)
      kao(:, 1, 6,15) = (/ &
        & 0.39506e-01_r8,0.34566e-01_r8,0.29627e-01_r8,0.24691e-01_r8,0.19819e-01_r8, &
        & 0.15734e-01_r8,0.12852e-01_r8,0.10482e-01_r8,0.15100e-01_r8 /)
      kao(:, 2, 6,15) = (/ &
        & 0.39438e-01_r8,0.34510e-01_r8,0.29581e-01_r8,0.24651e-01_r8,0.19767e-01_r8, &
        & 0.15626e-01_r8,0.12723e-01_r8,0.10339e-01_r8,0.14869e-01_r8 /)
      kao(:, 3, 6,15) = (/ &
        & 0.39363e-01_r8,0.34443e-01_r8,0.29524e-01_r8,0.24601e-01_r8,0.19714e-01_r8, &
        & 0.15531e-01_r8,0.12593e-01_r8,0.10189e-01_r8,0.14636e-01_r8 /)
      kao(:, 4, 6,15) = (/ &
        & 0.39295e-01_r8,0.34380e-01_r8,0.29468e-01_r8,0.24559e-01_r8,0.19663e-01_r8, &
        & 0.15432e-01_r8,0.12453e-01_r8,0.10038e-01_r8,0.14402e-01_r8 /)
      kao(:, 5, 6,15) = (/ &
        & 0.39232e-01_r8,0.34326e-01_r8,0.29423e-01_r8,0.24518e-01_r8,0.19622e-01_r8, &
        & 0.15336e-01_r8,0.12308e-01_r8,0.98939e-02_r8,0.14172e-01_r8 /)
      kao(:, 1, 7,15) = (/ &
        & 0.42642e-01_r8,0.37314e-01_r8,0.31983e-01_r8,0.26652e-01_r8,0.21609e-01_r8, &
        & 0.17542e-01_r8,0.14584e-01_r8,0.11924e-01_r8,0.16714e-01_r8 /)
      kao(:, 2, 7,15) = (/ &
        & 0.42588e-01_r8,0.37267e-01_r8,0.31942e-01_r8,0.26620e-01_r8,0.21537e-01_r8, &
        & 0.17385e-01_r8,0.14405e-01_r8,0.11750e-01_r8,0.16453e-01_r8 /)
      kao(:, 3, 7,15) = (/ &
        & 0.42519e-01_r8,0.37203e-01_r8,0.31888e-01_r8,0.26575e-01_r8,0.21450e-01_r8, &
        & 0.17237e-01_r8,0.14233e-01_r8,0.11569e-01_r8,0.16190e-01_r8 /)
      kao(:, 4, 7,15) = (/ &
        & 0.42450e-01_r8,0.37145e-01_r8,0.31837e-01_r8,0.26531e-01_r8,0.21364e-01_r8, &
        & 0.17089e-01_r8,0.14051e-01_r8,0.11390e-01_r8,0.15924e-01_r8 /)
      kao(:, 5, 7,15) = (/ &
        & 0.42372e-01_r8,0.37075e-01_r8,0.31780e-01_r8,0.26482e-01_r8,0.21293e-01_r8, &
        & 0.16947e-01_r8,0.13866e-01_r8,0.11216e-01_r8,0.15662e-01_r8 /)
      kao(:, 1, 8,15) = (/ &
        & 0.45438e-01_r8,0.39757e-01_r8,0.34077e-01_r8,0.28427e-01_r8,0.23418e-01_r8, &
        & 0.19456e-01_r8,0.16427e-01_r8,0.13456e-01_r8,0.18359e-01_r8 /)
      kao(:, 2, 8,15) = (/ &
        & 0.45420e-01_r8,0.39742e-01_r8,0.34065e-01_r8,0.28396e-01_r8,0.23308e-01_r8, &
        & 0.19242e-01_r8,0.16196e-01_r8,0.13253e-01_r8,0.18076e-01_r8 /)
      kao(:, 3, 8,15) = (/ &
        & 0.45404e-01_r8,0.39728e-01_r8,0.34054e-01_r8,0.28379e-01_r8,0.23190e-01_r8, &
        & 0.19044e-01_r8,0.15968e-01_r8,0.13036e-01_r8,0.17789e-01_r8 /)
      kao(:, 4, 8,15) = (/ &
        & 0.45355e-01_r8,0.39684e-01_r8,0.34015e-01_r8,0.28348e-01_r8,0.23074e-01_r8, &
        & 0.18841e-01_r8,0.15735e-01_r8,0.12818e-01_r8,0.17487e-01_r8 /)
      kao(:, 5, 8,15) = (/ &
        & 0.45268e-01_r8,0.39604e-01_r8,0.33951e-01_r8,0.28294e-01_r8,0.22964e-01_r8, &
        & 0.18639e-01_r8,0.15495e-01_r8,0.12608e-01_r8,0.17187e-01_r8 /)
      kao(:, 1, 9,15) = (/ &
        & 0.47828e-01_r8,0.41848e-01_r8,0.35870e-01_r8,0.30096e-01_r8,0.25238e-01_r8, &
        & 0.21453e-01_r8,0.18348e-01_r8,0.15048e-01_r8,0.20030e-01_r8 /)
      kao(:, 2, 9,15) = (/ &
        & 0.47883e-01_r8,0.41899e-01_r8,0.35911e-01_r8,0.30061e-01_r8,0.25102e-01_r8, &
        & 0.21178e-01_r8,0.18071e-01_r8,0.14812e-01_r8,0.19720e-01_r8 /)
      kao(:, 3, 9,15) = (/ &
        & 0.47917e-01_r8,0.41930e-01_r8,0.35941e-01_r8,0.30033e-01_r8,0.24934e-01_r8, &
        & 0.20917e-01_r8,0.17786e-01_r8,0.14566e-01_r8,0.19396e-01_r8 /)
      kao(:, 4, 9,15) = (/ &
        & 0.47914e-01_r8,0.41927e-01_r8,0.35936e-01_r8,0.29997e-01_r8,0.24771e-01_r8, &
        & 0.20657e-01_r8,0.17491e-01_r8,0.14311e-01_r8,0.19056e-01_r8 /)
      kao(:, 5, 9,15) = (/ &
        & 0.47853e-01_r8,0.41872e-01_r8,0.35889e-01_r8,0.29935e-01_r8,0.24616e-01_r8, &
        & 0.20393e-01_r8,0.17196e-01_r8,0.14061e-01_r8,0.18721e-01_r8 /)
      kao(:, 1,10,15) = (/ &
        & 0.49786e-01_r8,0.43562e-01_r8,0.37346e-01_r8,0.31673e-01_r8,0.27058e-01_r8, &
        & 0.23446e-01_r8,0.20298e-01_r8,0.16634e-01_r8,0.20401e-01_r8 /)
      kao(:, 2,10,15) = (/ &
        & 0.49957e-01_r8,0.43713e-01_r8,0.37470e-01_r8,0.31624e-01_r8,0.26879e-01_r8, &
        & 0.23121e-01_r8,0.19962e-01_r8,0.16379e-01_r8,0.19980e-01_r8 /)
      kao(:, 3,10,15) = (/ &
        & 0.50073e-01_r8,0.43811e-01_r8,0.37553e-01_r8,0.31591e-01_r8,0.26668e-01_r8, &
        & 0.22810e-01_r8,0.19616e-01_r8,0.16101e-01_r8,0.19150e-01_r8 /)
      kao(:, 4,10,15) = (/ &
        & 0.50104e-01_r8,0.43839e-01_r8,0.37576e-01_r8,0.31542e-01_r8,0.26451e-01_r8, &
        & 0.22487e-01_r8,0.19263e-01_r8,0.15810e-01_r8,0.18309e-01_r8 /)
      kao(:, 5,10,15) = (/ &
        & 0.50083e-01_r8,0.43821e-01_r8,0.37560e-01_r8,0.31463e-01_r8,0.26247e-01_r8, &
        & 0.22153e-01_r8,0.18906e-01_r8,0.15516e-01_r8,0.17790e-01_r8 /)
      kao(:, 1,11,15) = (/ &
        & 0.51449e-01_r8,0.45016e-01_r8,0.38642e-01_r8,0.33136e-01_r8,0.28759e-01_r8, &
        & 0.25254e-01_r8,0.22053e-01_r8,0.18120e-01_r8,0.53897e-02_r8 /)
      kao(:, 2,11,15) = (/ &
        & 0.51718e-01_r8,0.45255e-01_r8,0.38815e-01_r8,0.33090e-01_r8,0.28517e-01_r8, &
        & 0.24894e-01_r8,0.21659e-01_r8,0.17825e-01_r8,0.47196e-02_r8 /)
      kao(:, 3,11,15) = (/ &
        & 0.51885e-01_r8,0.45397e-01_r8,0.38919e-01_r8,0.33034e-01_r8,0.28248e-01_r8, &
        & 0.24520e-01_r8,0.21252e-01_r8,0.17499e-01_r8,0.36639e-02_r8 /)
      kao(:, 4,11,15) = (/ &
        & 0.51965e-01_r8,0.45468e-01_r8,0.38969e-01_r8,0.32946e-01_r8,0.27987e-01_r8, &
        & 0.24125e-01_r8,0.20834e-01_r8,0.17164e-01_r8,0.30436e-02_r8 /)
      kao(:, 5,11,15) = (/ &
        & 0.52007e-01_r8,0.45508e-01_r8,0.39008e-01_r8,0.32828e-01_r8,0.27732e-01_r8, &
        & 0.23720e-01_r8,0.20415e-01_r8,0.16822e-01_r8,0.23024e-02_r8 /)
      kao(:, 1,12,15) = (/ &
        & 0.52772e-01_r8,0.46179e-01_r8,0.39786e-01_r8,0.34518e-01_r8,0.30341e-01_r8, &
        & 0.26996e-01_r8,0.23719e-01_r8,0.19625e-01_r8,0.00000e+00_r8 /)
      kao(:, 2,12,15) = (/ &
        & 0.53131e-01_r8,0.46489e-01_r8,0.39976e-01_r8,0.34451e-01_r8,0.30050e-01_r8, &
        & 0.26583e-01_r8,0.23271e-01_r8,0.19259e-01_r8,0.79250e-04_r8 /)
      kao(:, 3,12,15) = (/ &
        & 0.53372e-01_r8,0.46707e-01_r8,0.40090e-01_r8,0.34369e-01_r8,0.29734e-01_r8, &
        & 0.26140e-01_r8,0.22802e-01_r8,0.18870e-01_r8,0.00000e+00_r8 /)
      kao(:, 4,12,15) = (/ &
        & 0.53549e-01_r8,0.46855e-01_r8,0.40175e-01_r8,0.34238e-01_r8,0.29424e-01_r8, &
        & 0.25661e-01_r8,0.22318e-01_r8,0.18486e-01_r8,0.00000e+00_r8 /)
      kao(:, 5,12,15) = (/ &
        & 0.53641e-01_r8,0.46944e-01_r8,0.40238e-01_r8,0.34087e-01_r8,0.29108e-01_r8, &
        & 0.25184e-01_r8,0.21836e-01_r8,0.18091e-01_r8,0.00000e+00_r8 /)
      kao(:, 1,13,15) = (/ &
        & 0.53794e-01_r8,0.47070e-01_r8,0.40802e-01_r8,0.35804e-01_r8,0.31808e-01_r8, &
        & 0.28611e-01_r8,0.25317e-01_r8,0.21103e-01_r8,0.00000e+00_r8 /)
      kao(:, 2,13,15) = (/ &
        & 0.54248e-01_r8,0.47468e-01_r8,0.40994e-01_r8,0.35717e-01_r8,0.31468e-01_r8, &
        & 0.28147e-01_r8,0.24800e-01_r8,0.20666e-01_r8,0.99549e-04_r8 /)
      kao(:, 3,13,15) = (/ &
        & 0.54616e-01_r8,0.47795e-01_r8,0.41127e-01_r8,0.35591e-01_r8,0.31112e-01_r8, &
        & 0.27634e-01_r8,0.24251e-01_r8,0.20223e-01_r8,0.00000e+00_r8 /)
      kao(:, 4,13,15) = (/ &
        & 0.54881e-01_r8,0.48017e-01_r8,0.41234e-01_r8,0.35410e-01_r8,0.30749e-01_r8, &
        & 0.27090e-01_r8,0.23692e-01_r8,0.19766e-01_r8,0.00000e+00_r8 /)
      kao(:, 5,13,15) = (/ &
        & 0.55030e-01_r8,0.48150e-01_r8,0.41295e-01_r8,0.35229e-01_r8,0.30369e-01_r8, &
        & 0.26544e-01_r8,0.23150e-01_r8,0.19313e-01_r8,0.00000e+00_r8 /)
      kao(:, 1, 1,16) = (/ &
        & 0.31412e-01_r8,0.27484e-01_r8,0.23556e-01_r8,0.19630e-01_r8,0.15703e-01_r8, &
        & 0.11777e-01_r8,0.78503e-02_r8,0.63859e-02_r8,0.10546e-01_r8 /)
      kao(:, 2, 1,16) = (/ &
        & 0.31306e-01_r8,0.27393e-01_r8,0.23480e-01_r8,0.19566e-01_r8,0.15652e-01_r8, &
        & 0.11737e-01_r8,0.78244e-02_r8,0.64039e-02_r8,0.10543e-01_r8 /)
      kao(:, 3, 1,16) = (/ &
        & 0.31189e-01_r8,0.27291e-01_r8,0.23390e-01_r8,0.19492e-01_r8,0.15594e-01_r8, &
        & 0.11694e-01_r8,0.77949e-02_r8,0.65607e-02_r8,0.10621e-01_r8 /)
      kao(:, 4, 1,16) = (/ &
        & 0.31060e-01_r8,0.27175e-01_r8,0.23293e-01_r8,0.19412e-01_r8,0.15526e-01_r8, &
        & 0.11645e-01_r8,0.77621e-02_r8,0.64197e-02_r8,0.10470e-01_r8 /)
      kao(:, 5, 1,16) = (/ &
        & 0.30934e-01_r8,0.27069e-01_r8,0.23201e-01_r8,0.19334e-01_r8,0.15466e-01_r8, &
        & 0.11599e-01_r8,0.77309e-02_r8,0.64181e-02_r8,0.10407e-01_r8 /)
      kao(:, 1, 2,16) = (/ &
        & 0.37345e-01_r8,0.32673e-01_r8,0.28007e-01_r8,0.23341e-01_r8,0.18670e-01_r8, &
        & 0.14002e-01_r8,0.93330e-02_r8,0.76035e-02_r8,0.12759e-01_r8 /)
      kao(:, 2, 2,16) = (/ &
        & 0.37160e-01_r8,0.32513e-01_r8,0.27871e-01_r8,0.23225e-01_r8,0.18579e-01_r8, &
        & 0.13933e-01_r8,0.92868e-02_r8,0.75902e-02_r8,0.12702e-01_r8 /)
      kao(:, 3, 2,16) = (/ &
        & 0.36977e-01_r8,0.32353e-01_r8,0.27732e-01_r8,0.23111e-01_r8,0.18487e-01_r8, &
        & 0.13864e-01_r8,0.92415e-02_r8,0.77168e-02_r8,0.12729e-01_r8 /)
      kao(:, 4, 2,16) = (/ &
        & 0.36807e-01_r8,0.32204e-01_r8,0.27602e-01_r8,0.23002e-01_r8,0.18402e-01_r8, &
        & 0.13798e-01_r8,0.91981e-02_r8,0.77023e-02_r8,0.12641e-01_r8 /)
      kao(:, 5, 2,16) = (/ &
        & 0.36620e-01_r8,0.32046e-01_r8,0.27465e-01_r8,0.22887e-01_r8,0.18309e-01_r8, &
        & 0.13731e-01_r8,0.91527e-02_r8,0.75684e-02_r8,0.12457e-01_r8 /)
      kao(:, 1, 3,16) = (/ &
        & 0.44232e-01_r8,0.38700e-01_r8,0.33173e-01_r8,0.27644e-01_r8,0.22114e-01_r8, &
        & 0.16581e-01_r8,0.11054e-01_r8,0.91028e-02_r8,0.15510e-01_r8 /)
      kao(:, 2, 3,16) = (/ &
        & 0.43957e-01_r8,0.38463e-01_r8,0.32969e-01_r8,0.27474e-01_r8,0.21977e-01_r8, &
        & 0.16483e-01_r8,0.10987e-01_r8,0.90298e-02_r8,0.15354e-01_r8 /)
      kao(:, 3, 3,16) = (/ &
        & 0.43680e-01_r8,0.38217e-01_r8,0.32756e-01_r8,0.27297e-01_r8,0.21838e-01_r8, &
        & 0.16376e-01_r8,0.10918e-01_r8,0.89896e-02_r8,0.15195e-01_r8 /)
      kao(:, 4, 3,16) = (/ &
        & 0.43409e-01_r8,0.37982e-01_r8,0.32556e-01_r8,0.27128e-01_r8,0.21703e-01_r8, &
        & 0.16277e-01_r8,0.10849e-01_r8,0.90630e-02_r8,0.15090e-01_r8 /)
      kao(:, 5, 3,16) = (/ &
        & 0.43148e-01_r8,0.37757e-01_r8,0.32362e-01_r8,0.26967e-01_r8,0.21574e-01_r8, &
        & 0.16179e-01_r8,0.10784e-01_r8,0.89323e-02_r8,0.14861e-01_r8 /)
      kao(:, 1, 4,16) = (/ &
        & 0.52173e-01_r8,0.45650e-01_r8,0.39129e-01_r8,0.32609e-01_r8,0.26084e-01_r8, &
        & 0.19564e-01_r8,0.13063e-01_r8,0.10928e-01_r8,0.18665e-01_r8 /)
      kao(:, 2, 4,16) = (/ &
        & 0.51767e-01_r8,0.45298e-01_r8,0.38824e-01_r8,0.32358e-01_r8,0.25882e-01_r8, &
        & 0.19411e-01_r8,0.12948e-01_r8,0.10795e-01_r8,0.18386e-01_r8 /)
      kao(:, 3, 4,16) = (/ &
        & 0.51358e-01_r8,0.44935e-01_r8,0.38514e-01_r8,0.32093e-01_r8,0.25677e-01_r8, &
        & 0.19255e-01_r8,0.12843e-01_r8,0.10694e-01_r8,0.18120e-01_r8 /)
      kao(:, 4, 4,16) = (/ &
        & 0.50955e-01_r8,0.44587e-01_r8,0.38218e-01_r8,0.31847e-01_r8,0.25475e-01_r8, &
        & 0.19107e-01_r8,0.12737e-01_r8,0.10607e-01_r8,0.17851e-01_r8 /)
      kao(:, 5, 4,16) = (/ &
        & 0.50544e-01_r8,0.44227e-01_r8,0.37909e-01_r8,0.31588e-01_r8,0.25270e-01_r8, &
        & 0.18952e-01_r8,0.12634e-01_r8,0.10599e-01_r8,0.17618e-01_r8 /)
      kao(:, 1, 5,16) = (/ &
        & 0.61214e-01_r8,0.53565e-01_r8,0.45917e-01_r8,0.38262e-01_r8,0.30607e-01_r8, &
        & 0.22954e-01_r8,0.15462e-01_r8,0.13125e-01_r8,0.22278e-01_r8 /)
      kao(:, 2, 5,16) = (/ &
        & 0.60651e-01_r8,0.53068e-01_r8,0.45484e-01_r8,0.37903e-01_r8,0.30322e-01_r8, &
        & 0.22741e-01_r8,0.15244e-01_r8,0.12927e-01_r8,0.21870e-01_r8 /)
      kao(:, 3, 5,16) = (/ &
        & 0.60040e-01_r8,0.52533e-01_r8,0.45028e-01_r8,0.37524e-01_r8,0.30019e-01_r8, &
        & 0.22514e-01_r8,0.15074e-01_r8,0.12758e-01_r8,0.21465e-01_r8 /)
      kao(:, 4, 5,16) = (/ &
        & 0.59437e-01_r8,0.52006e-01_r8,0.44573e-01_r8,0.37145e-01_r8,0.29715e-01_r8, &
        & 0.22286e-01_r8,0.14911e-01_r8,0.12602e-01_r8,0.21062e-01_r8 /)
      kao(:, 5, 5,16) = (/ &
        & 0.58809e-01_r8,0.51461e-01_r8,0.44106e-01_r8,0.36755e-01_r8,0.29405e-01_r8, &
        & 0.22053e-01_r8,0.14746e-01_r8,0.12499e-01_r8,0.20685e-01_r8 /)
      kao(:, 1, 6,16) = (/ &
        & 0.71375e-01_r8,0.62451e-01_r8,0.53529e-01_r8,0.44607e-01_r8,0.35687e-01_r8, &
        & 0.26759e-01_r8,0.18273e-01_r8,0.15758e-01_r8,0.26378e-01_r8 /)
      kao(:, 2, 6,16) = (/ &
        & 0.70571e-01_r8,0.61748e-01_r8,0.52933e-01_r8,0.44107e-01_r8,0.35285e-01_r8, &
        & 0.26462e-01_r8,0.17959e-01_r8,0.15470e-01_r8,0.25822e-01_r8 /)
      kao(:, 3, 6,16) = (/ &
        & 0.69734e-01_r8,0.61022e-01_r8,0.52301e-01_r8,0.43583e-01_r8,0.34867e-01_r8, &
        & 0.26147e-01_r8,0.17660e-01_r8,0.15207e-01_r8,0.25265e-01_r8 /)
      kao(:, 4, 6,16) = (/ &
        & 0.68870e-01_r8,0.60256e-01_r8,0.51654e-01_r8,0.43043e-01_r8,0.34432e-01_r8, &
        & 0.25826e-01_r8,0.17391e-01_r8,0.14968e-01_r8,0.24710e-01_r8 /)
      kao(:, 5, 6,16) = (/ &
        & 0.67988e-01_r8,0.59482e-01_r8,0.50988e-01_r8,0.42488e-01_r8,0.33987e-01_r8, &
        & 0.25491e-01_r8,0.17159e-01_r8,0.14740e-01_r8,0.24148e-01_r8 /)
      kao(:, 1, 7,16) = (/ &
        & 0.82705e-01_r8,0.72369e-01_r8,0.62031e-01_r8,0.51694e-01_r8,0.41353e-01_r8, &
        & 0.31012e-01_r8,0.21511e-01_r8,0.18843e-01_r8,0.31008e-01_r8 /)
      kao(:, 2, 7,16) = (/ &
        & 0.81487e-01_r8,0.71304e-01_r8,0.61113e-01_r8,0.50924e-01_r8,0.40740e-01_r8, &
        & 0.30554e-01_r8,0.21074e-01_r8,0.18457e-01_r8,0.30235e-01_r8 /)
      kao(:, 3, 7,16) = (/ &
        & 0.80318e-01_r8,0.70281e-01_r8,0.60235e-01_r8,0.50200e-01_r8,0.40157e-01_r8, &
        & 0.30117e-01_r8,0.20636e-01_r8,0.18102e-01_r8,0.29494e-01_r8 /)
      kao(:, 4, 7,16) = (/ &
        & 0.79154e-01_r8,0.69255e-01_r8,0.59365e-01_r8,0.49470e-01_r8,0.39576e-01_r8, &
        & 0.29680e-01_r8,0.20228e-01_r8,0.17748e-01_r8,0.28759e-01_r8 /)
      kao(:, 5, 7,16) = (/ &
        & 0.77937e-01_r8,0.68190e-01_r8,0.58450e-01_r8,0.48707e-01_r8,0.38965e-01_r8, &
        & 0.29223e-01_r8,0.19858e-01_r8,0.17406e-01_r8,0.28017e-01_r8 /)
      kao(:, 1, 8,16) = (/ &
        & 0.95173e-01_r8,0.83270e-01_r8,0.71377e-01_r8,0.59480e-01_r8,0.47582e-01_r8, &
        & 0.35684e-01_r8,0.25169e-01_r8,0.22449e-01_r8,0.36274e-01_r8 /)
      kao(:, 2, 8,16) = (/ &
        & 0.93409e-01_r8,0.81740e-01_r8,0.70058e-01_r8,0.58384e-01_r8,0.46709e-01_r8, &
        & 0.35028e-01_r8,0.24581e-01_r8,0.21893e-01_r8,0.35207e-01_r8 /)
      kao(:, 3, 8,16) = (/ &
        & 0.91737e-01_r8,0.80263e-01_r8,0.68796e-01_r8,0.57330e-01_r8,0.45863e-01_r8, &
        & 0.34396e-01_r8,0.23987e-01_r8,0.21409e-01_r8,0.34174e-01_r8 /)
      kao(:, 4, 8,16) = (/ &
        & 0.90113e-01_r8,0.78852e-01_r8,0.67585e-01_r8,0.56324e-01_r8,0.45060e-01_r8, &
        & 0.33794e-01_r8,0.23415e-01_r8,0.20940e-01_r8,0.33185e-01_r8 /)
      kao(:, 5, 8,16) = (/ &
        & 0.88500e-01_r8,0.77445e-01_r8,0.66378e-01_r8,0.55317e-01_r8,0.44252e-01_r8, &
        & 0.33190e-01_r8,0.22890e-01_r8,0.20471e-01_r8,0.32236e-01_r8 /)
      kao(:, 1, 9,16) = (/ &
        & 0.10878e+00_r8,0.95186e-01_r8,0.81587e-01_r8,0.67986e-01_r8,0.54386e-01_r8, &
        & 0.40792e-01_r8,0.29314e-01_r8,0.26669e-01_r8,0.42265e-01_r8 /)
      kao(:, 2, 9,16) = (/ &
        & 0.10631e+00_r8,0.93021e-01_r8,0.79732e-01_r8,0.66444e-01_r8,0.53150e-01_r8, &
        & 0.39864e-01_r8,0.28508e-01_r8,0.25873e-01_r8,0.40792e-01_r8 /)
      kao(:, 3, 9,16) = (/ &
        & 0.10400e+00_r8,0.91002e-01_r8,0.78003e-01_r8,0.64997e-01_r8,0.51997e-01_r8, &
        & 0.39001e-01_r8,0.27707e-01_r8,0.25186e-01_r8,0.39383e-01_r8 /)
      kao(:, 4, 9,16) = (/ &
        & 0.10173e+00_r8,0.89018e-01_r8,0.76292e-01_r8,0.63582e-01_r8,0.50863e-01_r8, &
        & 0.38144e-01_r8,0.26926e-01_r8,0.24532e-01_r8,0.38084e-01_r8 /)
      kao(:, 5, 9,16) = (/ &
        & 0.99555e-01_r8,0.87113e-01_r8,0.74666e-01_r8,0.62221e-01_r8,0.49774e-01_r8, &
        & 0.37334e-01_r8,0.26211e-01_r8,0.23902e-01_r8,0.36825e-01_r8 /)
      kao(:, 1,10,16) = (/ &
        & 0.12320e+00_r8,0.10779e+00_r8,0.92400e-01_r8,0.76993e-01_r8,0.61601e-01_r8, &
        & 0.46197e-01_r8,0.33879e-01_r8,0.31475e-01_r8,0.48792e-01_r8 /)
      kao(:, 2,10,16) = (/ &
        & 0.11986e+00_r8,0.10487e+00_r8,0.89890e-01_r8,0.74910e-01_r8,0.59927e-01_r8, &
        & 0.44946e-01_r8,0.32786e-01_r8,0.30373e-01_r8,0.46838e-01_r8 /)
      kao(:, 3,10,16) = (/ &
        & 0.11671e+00_r8,0.10212e+00_r8,0.87531e-01_r8,0.72938e-01_r8,0.58350e-01_r8, &
        & 0.43767e-01_r8,0.31728e-01_r8,0.29415e-01_r8,0.45011e-01_r8 /)
      kao(:, 4,10,16) = (/ &
        & 0.11373e+00_r8,0.99514e-01_r8,0.85291e-01_r8,0.71084e-01_r8,0.56859e-01_r8, &
        & 0.42648e-01_r8,0.30712e-01_r8,0.28518e-01_r8,0.43306e-01_r8 /)
      kao(:, 5,10,16) = (/ &
        & 0.11086e+00_r8,0.97005e-01_r8,0.83130e-01_r8,0.69287e-01_r8,0.55428e-01_r8, &
        & 0.41573e-01_r8,0.29748e-01_r8,0.27669e-01_r8,0.41673e-01_r8 /)
      kao(:, 1,11,16) = (/ &
        & 0.13635e+00_r8,0.11930e+00_r8,0.10226e+00_r8,0.85213e-01_r8,0.68170e-01_r8, &
        & 0.51126e-01_r8,0.38257e-01_r8,0.36212e-01_r8,0.54706e-01_r8 /)
      kao(:, 2,11,16) = (/ &
        & 0.13203e+00_r8,0.11554e+00_r8,0.99030e-01_r8,0.82523e-01_r8,0.66019e-01_r8, &
        & 0.49513e-01_r8,0.36799e-01_r8,0.34833e-01_r8,0.52312e-01_r8 /)
      kao(:, 3,11,16) = (/ &
        & 0.12805e+00_r8,0.11203e+00_r8,0.96022e-01_r8,0.80023e-01_r8,0.64019e-01_r8, &
        & 0.48015e-01_r8,0.35435e-01_r8,0.33591e-01_r8,0.50057e-01_r8 /)
      kao(:, 4,11,16) = (/ &
        & 0.12432e+00_r8,0.10877e+00_r8,0.93237e-01_r8,0.77695e-01_r8,0.62158e-01_r8, &
        & 0.46618e-01_r8,0.34181e-01_r8,0.32427e-01_r8,0.47918e-01_r8 /)
      kao(:, 5,11,16) = (/ &
        & 0.12077e+00_r8,0.10567e+00_r8,0.90572e-01_r8,0.75471e-01_r8,0.60381e-01_r8, &
        & 0.45284e-01_r8,0.32973e-01_r8,0.31331e-01_r8,0.45895e-01_r8 /)
      kao(:, 1,12,16) = (/ &
        & 0.14909e+00_r8,0.13045e+00_r8,0.11182e+00_r8,0.93176e-01_r8,0.74537e-01_r8, &
        & 0.55927e-01_r8,0.42736e-01_r8,0.41194e-01_r8,0.43864e-01_r8 /)
      kao(:, 2,12,16) = (/ &
        & 0.14380e+00_r8,0.12582e+00_r8,0.10785e+00_r8,0.89883e-01_r8,0.71900e-01_r8, &
        & 0.53925e-01_r8,0.40874e-01_r8,0.39509e-01_r8,0.34410e-01_r8 /)
      kao(:, 3,12,16) = (/ &
        & 0.13887e+00_r8,0.12152e+00_r8,0.10414e+00_r8,0.86796e-01_r8,0.69431e-01_r8, &
        & 0.52073e-01_r8,0.39165e-01_r8,0.37950e-01_r8,0.27228e-01_r8 /)
      kao(:, 4,12,16) = (/ &
        & 0.13436e+00_r8,0.11758e+00_r8,0.10078e+00_r8,0.83978e-01_r8,0.67186e-01_r8, &
        & 0.50383e-01_r8,0.37599e-01_r8,0.36473e-01_r8,0.23165e-01_r8 /)
      kao(:, 5,12,16) = (/ &
        & 0.13007e+00_r8,0.11382e+00_r8,0.97560e-01_r8,0.81293e-01_r8,0.65042e-01_r8, &
        & 0.48775e-01_r8,0.36131e-01_r8,0.35083e-01_r8,0.14412e-01_r8 /)
      kao(:, 1,13,16) = (/ &
        & 0.16113e+00_r8,0.14100e+00_r8,0.12085e+00_r8,0.10071e+00_r8,0.80563e-01_r8, &
        & 0.60580e-01_r8,0.47246e-01_r8,0.46365e-01_r8,0.26456e-01_r8 /)
      kao(:, 2,13,16) = (/ &
        & 0.15486e+00_r8,0.13550e+00_r8,0.11616e+00_r8,0.96791e-01_r8,0.77431e-01_r8, &
        & 0.58082e-01_r8,0.44915e-01_r8,0.44314e-01_r8,0.19340e-01_r8 /)
      kao(:, 3,13,16) = (/ &
        & 0.14906e+00_r8,0.13042e+00_r8,0.11179e+00_r8,0.93156e-01_r8,0.74526e-01_r8, &
        & 0.55893e-01_r8,0.42831e-01_r8,0.42380e-01_r8,0.11993e-01_r8 /)
      kao(:, 4,13,16) = (/ &
        & 0.14369e+00_r8,0.12574e+00_r8,0.10777e+00_r8,0.89817e-01_r8,0.71849e-01_r8, &
        & 0.53884e-01_r8,0.40915e-01_r8,0.40556e-01_r8,0.50486e-02_r8 /)
      kao(:, 5,13,16) = (/ &
        & 0.13868e+00_r8,0.12134e+00_r8,0.10400e+00_r8,0.86669e-01_r8,0.69338e-01_r8, &
        & 0.52006e-01_r8,0.39136e-01_r8,0.38851e-01_r8,0.00000e+00_r8 /)
  
!     -----------------------------------------------------------------
!     The array KBO contains absorption coefs at the 16 chosen g-values 
!     for a range of pressure levels < ~100mb and temperatures. The first 
!     index in the array, JT, which runs from 1 to 5, corresponds to 
!     different temperatures.  More specifically, JT = 3 means that the 
!     data are for the reference temperature TREF for this pressure 
!     level, JT = 2 refers to the temperature TREF-15, JT = 1 is for
!     TREF-30, JT = 4 is for TREF+15, and JT = 5 is for TREF+30.  
!     The second index, JP, runs from 13 to 59 and refers to the JPth
!     reference pressure level (see taumol.f for the value of these
!     pressure levels in mb).  The third index, IG, goes from 1 to 16,
!     and tells us which g-interval the absorption coefficients are for.
!     -----------------------------------------------------------------

      kbo(:,13, 1) = (/ &
        & 0.12158e-08_r8,0.13238e-08_r8,0.15146e-08_r8,0.16862e-08_r8,0.18609e-08_r8 /)
      kbo(:,14, 1) = (/ &
        & 0.16931e-08_r8,0.20047e-08_r8,0.23006e-08_r8,0.25636e-08_r8,0.28912e-08_r8 /)
      kbo(:,15, 1) = (/ &
        & 0.31521e-08_r8,0.36963e-08_r8,0.41550e-08_r8,0.46365e-08_r8,0.50834e-08_r8 /)
      kbo(:,16, 1) = (/ &
        & 0.46152e-08_r8,0.50173e-08_r8,0.55381e-08_r8,0.60748e-08_r8,0.66355e-08_r8 /)
      kbo(:,17, 1) = (/ &
        & 0.62662e-08_r8,0.67518e-08_r8,0.71765e-08_r8,0.80302e-08_r8,0.89056e-08_r8 /)
      kbo(:,18, 1) = (/ &
        & 0.81764e-08_r8,0.91818e-08_r8,0.10385e-07_r8,0.11708e-07_r8,0.12536e-07_r8 /)
      kbo(:,19, 1) = (/ &
        & 0.12946e-07_r8,0.13631e-07_r8,0.14453e-07_r8,0.15133e-07_r8,0.15911e-07_r8 /)
      kbo(:,20, 1) = (/ &
        & 0.15868e-07_r8,0.16654e-07_r8,0.17281e-07_r8,0.17857e-07_r8,0.18383e-07_r8 /)
      kbo(:,21, 1) = (/ &
        & 0.18151e-07_r8,0.19056e-07_r8,0.20057e-07_r8,0.20708e-07_r8,0.21229e-07_r8 /)
      kbo(:,22, 1) = (/ &
        & 0.20234e-07_r8,0.21482e-07_r8,0.22599e-07_r8,0.23778e-07_r8,0.25115e-07_r8 /)
      kbo(:,23, 1) = (/ &
        & 0.23827e-07_r8,0.25405e-07_r8,0.26545e-07_r8,0.27716e-07_r8,0.28422e-07_r8 /)
      kbo(:,24, 1) = (/ &
        & 0.27638e-07_r8,0.28518e-07_r8,0.29101e-07_r8,0.29639e-07_r8,0.30077e-07_r8 /)
      kbo(:,25, 1) = (/ &
        & 0.28942e-07_r8,0.29436e-07_r8,0.29831e-07_r8,0.30066e-07_r8,0.30242e-07_r8 /)
      kbo(:,26, 1) = (/ &
        & 0.28774e-07_r8,0.29004e-07_r8,0.29272e-07_r8,0.29431e-07_r8,0.29616e-07_r8 /)
      kbo(:,27, 1) = (/ &
        & 0.27317e-07_r8,0.27462e-07_r8,0.27698e-07_r8,0.27835e-07_r8,0.27843e-07_r8 /)
      kbo(:,28, 1) = (/ &
        & 0.25463e-07_r8,0.25523e-07_r8,0.25678e-07_r8,0.25658e-07_r8,0.25687e-07_r8 /)
      kbo(:,29, 1) = (/ &
        & 0.22603e-07_r8,0.22672e-07_r8,0.22704e-07_r8,0.22668e-07_r8,0.22698e-07_r8 /)
      kbo(:,30, 1) = (/ &
        & 0.19657e-07_r8,0.19747e-07_r8,0.19687e-07_r8,0.19659e-07_r8,0.19680e-07_r8 /)
      kbo(:,31, 1) = (/ &
        & 0.16553e-07_r8,0.16571e-07_r8,0.16522e-07_r8,0.16545e-07_r8,0.16563e-07_r8 /)
      kbo(:,32, 1) = (/ &
        & 0.13867e-07_r8,0.13795e-07_r8,0.13808e-07_r8,0.13815e-07_r8,0.13799e-07_r8 /)
      kbo(:,33, 1) = (/ &
        & 0.11414e-07_r8,0.11409e-07_r8,0.11395e-07_r8,0.11384e-07_r8,0.11416e-07_r8 /)
      kbo(:,34, 1) = (/ &
        & 0.95639e-08_r8,0.95514e-08_r8,0.95251e-08_r8,0.95607e-08_r8,0.95767e-08_r8 /)
      kbo(:,35, 1) = (/ &
        & 0.80018e-08_r8,0.79882e-08_r8,0.79720e-08_r8,0.79934e-08_r8,0.79942e-08_r8 /)
      kbo(:,36, 1) = (/ &
        & 0.67279e-08_r8,0.67135e-08_r8,0.67089e-08_r8,0.67131e-08_r8,0.67290e-08_r8 /)
      kbo(:,37, 1) = (/ &
        & 0.57292e-08_r8,0.57278e-08_r8,0.57247e-08_r8,0.57298e-08_r8,0.57269e-08_r8 /)
      kbo(:,38, 1) = (/ &
        & 0.48406e-08_r8,0.48461e-08_r8,0.48394e-08_r8,0.48468e-08_r8,0.48401e-08_r8 /)
      kbo(:,39, 1) = (/ &
        & 0.40368e-08_r8,0.40419e-08_r8,0.40353e-08_r8,0.40432e-08_r8,0.40267e-08_r8 /)
      kbo(:,40, 1) = (/ &
        & 0.34875e-08_r8,0.34931e-08_r8,0.34872e-08_r8,0.34940e-08_r8,0.34782e-08_r8 /)
      kbo(:,41, 1) = (/ &
        & 0.30195e-08_r8,0.30243e-08_r8,0.30129e-08_r8,0.30148e-08_r8,0.30016e-08_r8 /)
      kbo(:,42, 1) = (/ &
        & 0.25993e-08_r8,0.25924e-08_r8,0.25861e-08_r8,0.25841e-08_r8,0.25734e-08_r8 /)
      kbo(:,43, 1) = (/ &
        & 0.22290e-08_r8,0.22166e-08_r8,0.22080e-08_r8,0.22067e-08_r8,0.21992e-08_r8 /)
      kbo(:,44, 1) = (/ &
        & 0.18916e-08_r8,0.18847e-08_r8,0.18733e-08_r8,0.18685e-08_r8,0.18685e-08_r8 /)
      kbo(:,45, 1) = (/ &
        & 0.15840e-08_r8,0.15787e-08_r8,0.15719e-08_r8,0.15641e-08_r8,0.15644e-08_r8 /)
      kbo(:,46, 1) = (/ &
        & 0.13197e-08_r8,0.13138e-08_r8,0.13098e-08_r8,0.13024e-08_r8,0.13049e-08_r8 /)
      kbo(:,47, 1) = (/ &
        & 0.11052e-08_r8,0.11003e-08_r8,0.10954e-08_r8,0.10927e-08_r8,0.10941e-08_r8 /)
      kbo(:,48, 1) = (/ &
        & 0.91115e-09_r8,0.90837e-09_r8,0.90520e-09_r8,0.90009e-09_r8,0.90047e-09_r8 /)
      kbo(:,49, 1) = (/ &
        & 0.73101e-09_r8,0.73246e-09_r8,0.73006e-09_r8,0.72687e-09_r8,0.72508e-09_r8 /)
      kbo(:,50, 1) = (/ &
        & 0.60565e-09_r8,0.60526e-09_r8,0.60121e-09_r8,0.60117e-09_r8,0.60056e-09_r8 /)
      kbo(:,51, 1) = (/ &
        & 0.50736e-09_r8,0.50750e-09_r8,0.50421e-09_r8,0.50378e-09_r8,0.50259e-09_r8 /)
      kbo(:,52, 1) = (/ &
        & 0.41843e-09_r8,0.41856e-09_r8,0.41499e-09_r8,0.41535e-09_r8,0.41353e-09_r8 /)
      kbo(:,53, 1) = (/ &
        & 0.33766e-09_r8,0.33794e-09_r8,0.33511e-09_r8,0.33405e-09_r8,0.33405e-09_r8 /)
      kbo(:,54, 1) = (/ &
        & 0.29473e-09_r8,0.29448e-09_r8,0.29284e-09_r8,0.29146e-09_r8,0.29053e-09_r8 /)
      kbo(:,55, 1) = (/ &
        & 0.26948e-09_r8,0.27034e-09_r8,0.27016e-09_r8,0.26799e-09_r8,0.26580e-09_r8 /)
      kbo(:,56, 1) = (/ &
        & 0.24773e-09_r8,0.24784e-09_r8,0.24734e-09_r8,0.24436e-09_r8,0.24377e-09_r8 /)
      kbo(:,57, 1) = (/ &
        & 0.22707e-09_r8,0.22765e-09_r8,0.22683e-09_r8,0.22503e-09_r8,0.22447e-09_r8 /)
      kbo(:,58, 1) = (/ &
        & 0.21180e-09_r8,0.21264e-09_r8,0.21254e-09_r8,0.21338e-09_r8,0.21089e-09_r8 /)
      kbo(:,59, 1) = (/ &
        & 0.22898e-09_r8,0.23089e-09_r8,0.23471e-09_r8,0.23606e-09_r8,0.23388e-09_r8 /)
      kbo(:,13, 2) = (/ &
        & 0.18001e-08_r8,0.19945e-08_r8,0.21612e-08_r8,0.23316e-08_r8,0.25983e-08_r8 /)
      kbo(:,14, 2) = (/ &
        & 0.39853e-08_r8,0.42632e-08_r8,0.44602e-08_r8,0.46784e-08_r8,0.48071e-08_r8 /)
      kbo(:,15, 2) = (/ &
        & 0.60848e-08_r8,0.61494e-08_r8,0.61069e-08_r8,0.61295e-08_r8,0.65707e-08_r8 /)
      kbo(:,16, 2) = (/ &
        & 0.75494e-08_r8,0.85999e-08_r8,0.91057e-08_r8,0.10175e-07_r8,0.10943e-07_r8 /)
      kbo(:,17, 2) = (/ &
        & 0.12037e-07_r8,0.12753e-07_r8,0.13314e-07_r8,0.13239e-07_r8,0.13306e-07_r8 /)
      kbo(:,18, 2) = (/ &
        & 0.15519e-07_r8,0.15517e-07_r8,0.15097e-07_r8,0.14435e-07_r8,0.13983e-07_r8 /)
      kbo(:,19, 2) = (/ &
        & 0.16420e-07_r8,0.17025e-07_r8,0.17639e-07_r8,0.17633e-07_r8,0.17513e-07_r8 /)
      kbo(:,20, 2) = (/ &
        & 0.18021e-07_r8,0.19301e-07_r8,0.20621e-07_r8,0.22238e-07_r8,0.23351e-07_r8 /)
      kbo(:,21, 2) = (/ &
        & 0.22378e-07_r8,0.23582e-07_r8,0.24409e-07_r8,0.24915e-07_r8,0.25516e-07_r8 /)
      kbo(:,22, 2) = (/ &
        & 0.24712e-07_r8,0.24864e-07_r8,0.24556e-07_r8,0.23953e-07_r8,0.23424e-07_r8 /)
      kbo(:,23, 2) = (/ &
        & 0.22545e-07_r8,0.22002e-07_r8,0.21325e-07_r8,0.20492e-07_r8,0.20022e-07_r8 /)
      kbo(:,24, 2) = (/ &
        & 0.18798e-07_r8,0.18566e-07_r8,0.18366e-07_r8,0.18099e-07_r8,0.17971e-07_r8 /)
      kbo(:,25, 2) = (/ &
        & 0.16773e-07_r8,0.16803e-07_r8,0.16541e-07_r8,0.16450e-07_r8,0.16482e-07_r8 /)
      kbo(:,26, 2) = (/ &
        & 0.15222e-07_r8,0.15398e-07_r8,0.15177e-07_r8,0.15147e-07_r8,0.14951e-07_r8 /)
      kbo(:,27, 2) = (/ &
        & 0.13792e-07_r8,0.13944e-07_r8,0.13534e-07_r8,0.13546e-07_r8,0.13516e-07_r8 /)
      kbo(:,28, 2) = (/ &
        & 0.12157e-07_r8,0.12221e-07_r8,0.11930e-07_r8,0.12115e-07_r8,0.12027e-07_r8 /)
      kbo(:,29, 2) = (/ &
        & 0.10487e-07_r8,0.10393e-07_r8,0.10366e-07_r8,0.10455e-07_r8,0.10269e-07_r8 /)
      kbo(:,30, 2) = (/ &
        & 0.90084e-08_r8,0.88590e-08_r8,0.90055e-08_r8,0.88655e-08_r8,0.87392e-08_r8 /)
      kbo(:,31, 2) = (/ &
        & 0.74765e-08_r8,0.74889e-08_r8,0.73915e-08_r8,0.73289e-08_r8,0.72219e-08_r8 /)
      kbo(:,32, 2) = (/ &
        & 0.62311e-08_r8,0.62461e-08_r8,0.61378e-08_r8,0.59795e-08_r8,0.60309e-08_r8 /)
      kbo(:,33, 2) = (/ &
        & 0.51421e-08_r8,0.50519e-08_r8,0.50031e-08_r8,0.49630e-08_r8,0.49489e-08_r8 /)
      kbo(:,34, 2) = (/ &
        & 0.42880e-08_r8,0.42042e-08_r8,0.41366e-08_r8,0.41198e-08_r8,0.41265e-08_r8 /)
      kbo(:,35, 2) = (/ &
        & 0.35718e-08_r8,0.34728e-08_r8,0.34599e-08_r8,0.34385e-08_r8,0.34695e-08_r8 /)
      kbo(:,36, 2) = (/ &
        & 0.29713e-08_r8,0.29023e-08_r8,0.28707e-08_r8,0.28790e-08_r8,0.28873e-08_r8 /)
      kbo(:,37, 2) = (/ &
        & 0.25246e-08_r8,0.24463e-08_r8,0.24323e-08_r8,0.24308e-08_r8,0.24753e-08_r8 /)
      kbo(:,38, 2) = (/ &
        & 0.21159e-08_r8,0.20527e-08_r8,0.20532e-08_r8,0.20325e-08_r8,0.20615e-08_r8 /)
      kbo(:,39, 2) = (/ &
        & 0.17631e-08_r8,0.17097e-08_r8,0.17043e-08_r8,0.16987e-08_r8,0.17298e-08_r8 /)
      kbo(:,40, 2) = (/ &
        & 0.15260e-08_r8,0.14757e-08_r8,0.14566e-08_r8,0.14513e-08_r8,0.14651e-08_r8 /)
      kbo(:,41, 2) = (/ &
        & 0.13009e-08_r8,0.12457e-08_r8,0.12523e-08_r8,0.12490e-08_r8,0.12671e-08_r8 /)
      kbo(:,42, 2) = (/ &
        & 0.10990e-08_r8,0.10789e-08_r8,0.10741e-08_r8,0.10762e-08_r8,0.10873e-08_r8 /)
      kbo(:,43, 2) = (/ &
        & 0.94313e-09_r8,0.92236e-09_r8,0.92369e-09_r8,0.91495e-09_r8,0.92405e-09_r8 /)
      kbo(:,44, 2) = (/ &
        & 0.80746e-09_r8,0.78453e-09_r8,0.77646e-09_r8,0.77477e-09_r8,0.77888e-09_r8 /)
      kbo(:,45, 2) = (/ &
        & 0.67944e-09_r8,0.66381e-09_r8,0.65747e-09_r8,0.65286e-09_r8,0.65668e-09_r8 /)
      kbo(:,46, 2) = (/ &
        & 0.56677e-09_r8,0.55682e-09_r8,0.54825e-09_r8,0.54623e-09_r8,0.54843e-09_r8 /)
      kbo(:,47, 2) = (/ &
        & 0.47375e-09_r8,0.47120e-09_r8,0.45836e-09_r8,0.45709e-09_r8,0.45689e-09_r8 /)
      kbo(:,48, 2) = (/ &
        & 0.39797e-09_r8,0.39204e-09_r8,0.37735e-09_r8,0.37505e-09_r8,0.37687e-09_r8 /)
      kbo(:,49, 2) = (/ &
        & 0.32772e-09_r8,0.31857e-09_r8,0.30808e-09_r8,0.30232e-09_r8,0.30140e-09_r8 /)
      kbo(:,50, 2) = (/ &
        & 0.27300e-09_r8,0.26581e-09_r8,0.26125e-09_r8,0.24922e-09_r8,0.25029e-09_r8 /)
      kbo(:,51, 2) = (/ &
        & 0.23073e-09_r8,0.22159e-09_r8,0.21979e-09_r8,0.20969e-09_r8,0.21117e-09_r8 /)
      kbo(:,52, 2) = (/ &
        & 0.18868e-09_r8,0.18466e-09_r8,0.18517e-09_r8,0.17470e-09_r8,0.17469e-09_r8 /)
      kbo(:,53, 2) = (/ &
        & 0.15290e-09_r8,0.14970e-09_r8,0.15032e-09_r8,0.14201e-09_r8,0.14053e-09_r8 /)
      kbo(:,54, 2) = (/ &
        & 0.13616e-09_r8,0.13340e-09_r8,0.13256e-09_r8,0.12713e-09_r8,0.12621e-09_r8 /)
      kbo(:,55, 2) = (/ &
        & 0.12605e-09_r8,0.12524e-09_r8,0.12106e-09_r8,0.11994e-09_r8,0.11735e-09_r8 /)
      kbo(:,56, 2) = (/ &
        & 0.11625e-09_r8,0.11350e-09_r8,0.11287e-09_r8,0.11534e-09_r8,0.10942e-09_r8 /)
      kbo(:,57, 2) = (/ &
        & 0.10168e-09_r8,0.10628e-09_r8,0.10684e-09_r8,0.10799e-09_r8,0.10313e-09_r8 /)
      kbo(:,58, 2) = (/ &
        & 0.92659e-10_r8,0.10050e-09_r8,0.10168e-09_r8,0.97877e-10_r8,0.97971e-10_r8 /)
      kbo(:,59, 2) = (/ &
        & 0.10198e-09_r8,0.11632e-09_r8,0.11127e-09_r8,0.10947e-09_r8,0.11000e-09_r8 /)
      kbo(:,13, 3) = (/ &
        & 0.33788e-08_r8,0.38685e-08_r8,0.40059e-08_r8,0.41301e-08_r8,0.43316e-08_r8 /)
      kbo(:,14, 3) = (/ &
        & 0.54022e-08_r8,0.55644e-08_r8,0.55814e-08_r8,0.55195e-08_r8,0.57708e-08_r8 /)
      kbo(:,15, 3) = (/ &
        & 0.95769e-08_r8,0.10205e-07_r8,0.12445e-07_r8,0.13419e-07_r8,0.13357e-07_r8 /)
      kbo(:,16, 3) = (/ &
        & 0.17233e-07_r8,0.16177e-07_r8,0.16092e-07_r8,0.15590e-07_r8,0.15068e-07_r8 /)
      kbo(:,17, 3) = (/ &
        & 0.19731e-07_r8,0.19947e-07_r8,0.20278e-07_r8,0.20235e-07_r8,0.20699e-07_r8 /)
      kbo(:,18, 3) = (/ &
        & 0.23168e-07_r8,0.23970e-07_r8,0.25507e-07_r8,0.27034e-07_r8,0.29135e-07_r8 /)
      kbo(:,19, 3) = (/ &
        & 0.33749e-07_r8,0.35374e-07_r8,0.37333e-07_r8,0.38730e-07_r8,0.39816e-07_r8 /)
      kbo(:,20, 3) = (/ &
        & 0.39844e-07_r8,0.39698e-07_r8,0.39651e-07_r8,0.38618e-07_r8,0.37699e-07_r8 /)
      kbo(:,21, 3) = (/ &
        & 0.37013e-07_r8,0.35923e-07_r8,0.35560e-07_r8,0.35217e-07_r8,0.34594e-07_r8 /)
      kbo(:,22, 3) = (/ &
        & 0.32381e-07_r8,0.31844e-07_r8,0.32272e-07_r8,0.32430e-07_r8,0.31922e-07_r8 /)
      kbo(:,23, 3) = (/ &
        & 0.29924e-07_r8,0.29834e-07_r8,0.30537e-07_r8,0.30494e-07_r8,0.30313e-07_r8 /)
      kbo(:,24, 3) = (/ &
        & 0.27849e-07_r8,0.28147e-07_r8,0.29005e-07_r8,0.29081e-07_r8,0.28673e-07_r8 /)
      kbo(:,25, 3) = (/ &
        & 0.25534e-07_r8,0.25854e-07_r8,0.26978e-07_r8,0.27173e-07_r8,0.27116e-07_r8 /)
      kbo(:,26, 3) = (/ &
        & 0.23413e-07_r8,0.24124e-07_r8,0.25341e-07_r8,0.25322e-07_r8,0.25266e-07_r8 /)
      kbo(:,27, 3) = (/ &
        & 0.21218e-07_r8,0.22105e-07_r8,0.23470e-07_r8,0.23280e-07_r8,0.23250e-07_r8 /)
      kbo(:,28, 3) = (/ &
        & 0.19002e-07_r8,0.20309e-07_r8,0.21106e-07_r8,0.20908e-07_r8,0.21199e-07_r8 /)
      kbo(:,29, 3) = (/ &
        & 0.16901e-07_r8,0.18244e-07_r8,0.18426e-07_r8,0.18398e-07_r8,0.18708e-07_r8 /)
      kbo(:,30, 3) = (/ &
        & 0.15065e-07_r8,0.15814e-07_r8,0.15711e-07_r8,0.16012e-07_r8,0.16145e-07_r8 /)
      kbo(:,31, 3) = (/ &
        & 0.13100e-07_r8,0.13194e-07_r8,0.13385e-07_r8,0.13455e-07_r8,0.13435e-07_r8 /)
      kbo(:,32, 3) = (/ &
        & 0.10972e-07_r8,0.10986e-07_r8,0.11085e-07_r8,0.11182e-07_r8,0.11030e-07_r8 /)
      kbo(:,33, 3) = (/ &
        & 0.90750e-08_r8,0.90832e-08_r8,0.91769e-08_r8,0.89877e-08_r8,0.89513e-08_r8 /)
      kbo(:,34, 3) = (/ &
        & 0.75008e-08_r8,0.76569e-08_r8,0.76237e-08_r8,0.74547e-08_r8,0.74719e-08_r8 /)
      kbo(:,35, 3) = (/ &
        & 0.63063e-08_r8,0.64050e-08_r8,0.62067e-08_r8,0.61836e-08_r8,0.61775e-08_r8 /)
      kbo(:,36, 3) = (/ &
        & 0.53250e-08_r8,0.52712e-08_r8,0.52454e-08_r8,0.51153e-08_r8,0.51657e-08_r8 /)
      kbo(:,37, 3) = (/ &
        & 0.45450e-08_r8,0.45358e-08_r8,0.44274e-08_r8,0.43893e-08_r8,0.43616e-08_r8 /)
      kbo(:,38, 3) = (/ &
        & 0.38039e-08_r8,0.38254e-08_r8,0.37172e-08_r8,0.37203e-08_r8,0.37278e-08_r8 /)
      kbo(:,39, 3) = (/ &
        & 0.31821e-08_r8,0.31632e-08_r8,0.30774e-08_r8,0.30626e-08_r8,0.30979e-08_r8 /)
      kbo(:,40, 3) = (/ &
        & 0.27339e-08_r8,0.27443e-08_r8,0.26754e-08_r8,0.26505e-08_r8,0.27022e-08_r8 /)
      kbo(:,41, 3) = (/ &
        & 0.23939e-08_r8,0.24228e-08_r8,0.23415e-08_r8,0.23287e-08_r8,0.23327e-08_r8 /)
      kbo(:,42, 3) = (/ &
        & 0.20895e-08_r8,0.20874e-08_r8,0.20298e-08_r8,0.20180e-08_r8,0.19876e-08_r8 /)
      kbo(:,43, 3) = (/ &
        & 0.17869e-08_r8,0.17800e-08_r8,0.17392e-08_r8,0.17376e-08_r8,0.16927e-08_r8 /)
      kbo(:,44, 3) = (/ &
        & 0.15169e-08_r8,0.15335e-08_r8,0.14778e-08_r8,0.14668e-08_r8,0.14407e-08_r8 /)
      kbo(:,45, 3) = (/ &
        & 0.12692e-08_r8,0.12902e-08_r8,0.12439e-08_r8,0.12324e-08_r8,0.11996e-08_r8 /)
      kbo(:,46, 3) = (/ &
        & 0.10611e-08_r8,0.10656e-08_r8,0.10472e-08_r8,0.10282e-08_r8,0.10015e-08_r8 /)
      kbo(:,47, 3) = (/ &
        & 0.90394e-09_r8,0.88143e-09_r8,0.87958e-09_r8,0.84984e-09_r8,0.85121e-09_r8 /)
      kbo(:,48, 3) = (/ &
        & 0.73451e-09_r8,0.71978e-09_r8,0.73014e-09_r8,0.70436e-09_r8,0.69840e-09_r8 /)
      kbo(:,49, 3) = (/ &
        & 0.58678e-09_r8,0.58259e-09_r8,0.58316e-09_r8,0.55960e-09_r8,0.56079e-09_r8 /)
      kbo(:,50, 3) = (/ &
        & 0.48502e-09_r8,0.47984e-09_r8,0.48693e-09_r8,0.47265e-09_r8,0.46016e-09_r8 /)
      kbo(:,51, 3) = (/ &
        & 0.40704e-09_r8,0.40367e-09_r8,0.41046e-09_r8,0.39764e-09_r8,0.38714e-09_r8 /)
      kbo(:,52, 3) = (/ &
        & 0.33771e-09_r8,0.33070e-09_r8,0.32984e-09_r8,0.33231e-09_r8,0.32299e-09_r8 /)
      kbo(:,53, 3) = (/ &
        & 0.27062e-09_r8,0.27028e-09_r8,0.26516e-09_r8,0.26816e-09_r8,0.25661e-09_r8 /)
      kbo(:,54, 3) = (/ &
        & 0.23501e-09_r8,0.23579e-09_r8,0.23460e-09_r8,0.23532e-09_r8,0.22777e-09_r8 /)
      kbo(:,55, 3) = (/ &
        & 0.20561e-09_r8,0.21843e-09_r8,0.22171e-09_r8,0.22358e-09_r8,0.21702e-09_r8 /)
      kbo(:,56, 3) = (/ &
        & 0.18557e-09_r8,0.20864e-09_r8,0.21196e-09_r8,0.20646e-09_r8,0.20759e-09_r8 /)
      kbo(:,57, 3) = (/ &
        & 0.17099e-09_r8,0.19489e-09_r8,0.19486e-09_r8,0.19102e-09_r8,0.19124e-09_r8 /)
      kbo(:,58, 3) = (/ &
        & 0.16535e-09_r8,0.16955e-09_r8,0.18769e-09_r8,0.18586e-09_r8,0.18358e-09_r8 /)
      kbo(:,59, 3) = (/ &
        & 0.18472e-09_r8,0.17614e-09_r8,0.20835e-09_r8,0.19900e-09_r8,0.17587e-09_r8 /)
      kbo(:,13, 4) = (/ &
        & 0.14276e-07_r8,0.14530e-07_r8,0.14762e-07_r8,0.14823e-07_r8,0.15070e-07_r8 /)
      kbo(:,14, 4) = (/ &
        & 0.22710e-07_r8,0.23419e-07_r8,0.26577e-07_r8,0.28008e-07_r8,0.28298e-07_r8 /)
      kbo(:,15, 4) = (/ &
        & 0.40218e-07_r8,0.40306e-07_r8,0.38786e-07_r8,0.38421e-07_r8,0.37982e-07_r8 /)
      kbo(:,16, 4) = (/ &
        & 0.46010e-07_r8,0.46709e-07_r8,0.48658e-07_r8,0.49166e-07_r8,0.49018e-07_r8 /)
      kbo(:,17, 4) = (/ &
        & 0.57896e-07_r8,0.59606e-07_r8,0.62582e-07_r8,0.65981e-07_r8,0.66467e-07_r8 /)
      kbo(:,18, 4) = (/ &
        & 0.74731e-07_r8,0.75116e-07_r8,0.75181e-07_r8,0.74922e-07_r8,0.73535e-07_r8 /)
      kbo(:,19, 4) = (/ &
        & 0.76222e-07_r8,0.73788e-07_r8,0.71345e-07_r8,0.70864e-07_r8,0.69839e-07_r8 /)
      kbo(:,20, 4) = (/ &
        & 0.69638e-07_r8,0.67680e-07_r8,0.66694e-07_r8,0.67021e-07_r8,0.67066e-07_r8 /)
      kbo(:,21, 4) = (/ &
        & 0.65779e-07_r8,0.64200e-07_r8,0.63508e-07_r8,0.64106e-07_r8,0.64461e-07_r8 /)
      kbo(:,22, 4) = (/ &
        & 0.61488e-07_r8,0.60248e-07_r8,0.59719e-07_r8,0.60704e-07_r8,0.61392e-07_r8 /)
      kbo(:,23, 4) = (/ &
        & 0.56738e-07_r8,0.55143e-07_r8,0.55071e-07_r8,0.56796e-07_r8,0.58031e-07_r8 /)
      kbo(:,24, 4) = (/ &
        & 0.53299e-07_r8,0.52091e-07_r8,0.52308e-07_r8,0.54157e-07_r8,0.55094e-07_r8 /)
      kbo(:,25, 4) = (/ &
        & 0.49763e-07_r8,0.48954e-07_r8,0.49068e-07_r8,0.51533e-07_r8,0.52367e-07_r8 /)
      kbo(:,26, 4) = (/ &
        & 0.46006e-07_r8,0.45410e-07_r8,0.45860e-07_r8,0.48840e-07_r8,0.49788e-07_r8 /)
      kbo(:,27, 4) = (/ &
        & 0.42208e-07_r8,0.41876e-07_r8,0.43006e-07_r8,0.46350e-07_r8,0.47032e-07_r8 /)
      kbo(:,28, 4) = (/ &
        & 0.38508e-07_r8,0.38430e-07_r8,0.40481e-07_r8,0.43465e-07_r8,0.43170e-07_r8 /)
      kbo(:,29, 4) = (/ &
        & 0.33913e-07_r8,0.34466e-07_r8,0.37202e-07_r8,0.38288e-07_r8,0.38327e-07_r8 /)
      kbo(:,30, 4) = (/ &
        & 0.29454e-07_r8,0.30842e-07_r8,0.33204e-07_r8,0.33354e-07_r8,0.33727e-07_r8 /)
      kbo(:,31, 4) = (/ &
        & 0.25253e-07_r8,0.27183e-07_r8,0.28228e-07_r8,0.27946e-07_r8,0.28495e-07_r8 /)
      kbo(:,32, 4) = (/ &
        & 0.21784e-07_r8,0.23351e-07_r8,0.23372e-07_r8,0.23449e-07_r8,0.23246e-07_r8 /)
      kbo(:,33, 4) = (/ &
        & 0.18910e-07_r8,0.19134e-07_r8,0.18984e-07_r8,0.19294e-07_r8,0.18955e-07_r8 /)
      kbo(:,34, 4) = (/ &
        & 0.15933e-07_r8,0.15755e-07_r8,0.16059e-07_r8,0.15913e-07_r8,0.15386e-07_r8 /)
      kbo(:,35, 4) = (/ &
        & 0.13356e-07_r8,0.13247e-07_r8,0.13429e-07_r8,0.13202e-07_r8,0.12675e-07_r8 /)
      kbo(:,36, 4) = (/ &
        & 0.11207e-07_r8,0.11196e-07_r8,0.11048e-07_r8,0.10870e-07_r8,0.10431e-07_r8 /)
      kbo(:,37, 4) = (/ &
        & 0.95811e-08_r8,0.94647e-08_r8,0.93875e-08_r8,0.90968e-08_r8,0.88553e-08_r8 /)
      kbo(:,38, 4) = (/ &
        & 0.81243e-08_r8,0.80255e-08_r8,0.78559e-08_r8,0.75538e-08_r8,0.74057e-08_r8 /)
      kbo(:,39, 4) = (/ &
        & 0.66871e-08_r8,0.66553e-08_r8,0.65003e-08_r8,0.62809e-08_r8,0.60862e-08_r8 /)
      kbo(:,40, 4) = (/ &
        & 0.58254e-08_r8,0.57657e-08_r8,0.56185e-08_r8,0.54242e-08_r8,0.52135e-08_r8 /)
      kbo(:,41, 4) = (/ &
        & 0.50967e-08_r8,0.50027e-08_r8,0.48304e-08_r8,0.46813e-08_r8,0.44864e-08_r8 /)
      kbo(:,42, 4) = (/ &
        & 0.43731e-08_r8,0.43157e-08_r8,0.41432e-08_r8,0.39968e-08_r8,0.38854e-08_r8 /)
      kbo(:,43, 4) = (/ &
        & 0.37430e-08_r8,0.37088e-08_r8,0.35491e-08_r8,0.34012e-08_r8,0.33022e-08_r8 /)
      kbo(:,44, 4) = (/ &
        & 0.32207e-08_r8,0.31034e-08_r8,0.30690e-08_r8,0.29015e-08_r8,0.27644e-08_r8 /)
      kbo(:,45, 4) = (/ &
        & 0.27111e-08_r8,0.25582e-08_r8,0.26092e-08_r8,0.24352e-08_r8,0.23234e-08_r8 /)
      kbo(:,46, 4) = (/ &
        & 0.22675e-08_r8,0.21455e-08_r8,0.21930e-08_r8,0.20490e-08_r8,0.19277e-08_r8 /)
      kbo(:,47, 4) = (/ &
        & 0.18722e-08_r8,0.18163e-08_r8,0.18222e-08_r8,0.17256e-08_r8,0.16025e-08_r8 /)
      kbo(:,48, 4) = (/ &
        & 0.15670e-08_r8,0.15133e-08_r8,0.14751e-08_r8,0.14433e-08_r8,0.13269e-08_r8 /)
      kbo(:,49, 4) = (/ &
        & 0.12576e-08_r8,0.12106e-08_r8,0.11779e-08_r8,0.11664e-08_r8,0.10722e-08_r8 /)
      kbo(:,50, 4) = (/ &
        & 0.10308e-08_r8,0.10019e-08_r8,0.98151e-09_r8,0.96758e-09_r8,0.89739e-09_r8 /)
      kbo(:,51, 4) = (/ &
        & 0.84050e-09_r8,0.85047e-09_r8,0.83131e-09_r8,0.81346e-09_r8,0.77303e-09_r8 /)
      kbo(:,52, 4) = (/ &
        & 0.67669e-09_r8,0.70190e-09_r8,0.68695e-09_r8,0.66858e-09_r8,0.63719e-09_r8 /)
      kbo(:,53, 4) = (/ &
        & 0.52755e-09_r8,0.56097e-09_r8,0.54716e-09_r8,0.53877e-09_r8,0.51047e-09_r8 /)
      kbo(:,54, 4) = (/ &
        & 0.44864e-09_r8,0.48984e-09_r8,0.48831e-09_r8,0.46728e-09_r8,0.45462e-09_r8 /)
      kbo(:,55, 4) = (/ &
        & 0.40938e-09_r8,0.45501e-09_r8,0.45212e-09_r8,0.43586e-09_r8,0.42245e-09_r8 /)
      kbo(:,56, 4) = (/ &
        & 0.38293e-09_r8,0.40217e-09_r8,0.41760e-09_r8,0.39645e-09_r8,0.38652e-09_r8 /)
      kbo(:,57, 4) = (/ &
        & 0.35808e-09_r8,0.34306e-09_r8,0.38440e-09_r8,0.37442e-09_r8,0.33472e-09_r8 /)
      kbo(:,58, 4) = (/ &
        & 0.33278e-09_r8,0.31839e-09_r8,0.35327e-09_r8,0.33061e-09_r8,0.29093e-09_r8 /)
      kbo(:,59, 4) = (/ &
        & 0.32589e-09_r8,0.30766e-09_r8,0.30185e-09_r8,0.35182e-09_r8,0.34474e-09_r8 /)
      kbo(:,13, 5) = (/ &
        & 0.19090e-07_r8,0.19323e-07_r8,0.21491e-07_r8,0.23162e-07_r8,0.23970e-07_r8 /)
      kbo(:,14, 5) = (/ &
        & 0.37888e-07_r8,0.37108e-07_r8,0.33727e-07_r8,0.34146e-07_r8,0.33930e-07_r8 /)
      kbo(:,15, 5) = (/ &
        & 0.46395e-07_r8,0.47265e-07_r8,0.48201e-07_r8,0.50512e-07_r8,0.51101e-07_r8 /)
      kbo(:,16, 5) = (/ &
        & 0.60743e-07_r8,0.64371e-07_r8,0.67862e-07_r8,0.71479e-07_r8,0.74200e-07_r8 /)
      kbo(:,17, 5) = (/ &
        & 0.79052e-07_r8,0.79011e-07_r8,0.77558e-07_r8,0.75900e-07_r8,0.76450e-07_r8 /)
      kbo(:,18, 5) = (/ &
        & 0.75325e-07_r8,0.74009e-07_r8,0.72866e-07_r8,0.72803e-07_r8,0.73869e-07_r8 /)
      kbo(:,19, 5) = (/ &
        & 0.74009e-07_r8,0.74054e-07_r8,0.73970e-07_r8,0.73800e-07_r8,0.75638e-07_r8 /)
      kbo(:,20, 5) = (/ &
        & 0.73077e-07_r8,0.73306e-07_r8,0.72248e-07_r8,0.73120e-07_r8,0.74630e-07_r8 /)
      kbo(:,21, 5) = (/ &
        & 0.68928e-07_r8,0.70100e-07_r8,0.69203e-07_r8,0.69478e-07_r8,0.71860e-07_r8 /)
      kbo(:,22, 5) = (/ &
        & 0.65324e-07_r8,0.66570e-07_r8,0.66457e-07_r8,0.66345e-07_r8,0.68314e-07_r8 /)
      kbo(:,23, 5) = (/ &
        & 0.62411e-07_r8,0.63996e-07_r8,0.63443e-07_r8,0.63576e-07_r8,0.65766e-07_r8 /)
      kbo(:,24, 5) = (/ &
        & 0.60058e-07_r8,0.60956e-07_r8,0.60176e-07_r8,0.60222e-07_r8,0.63287e-07_r8 /)
      kbo(:,25, 5) = (/ &
        & 0.57223e-07_r8,0.58225e-07_r8,0.58348e-07_r8,0.58584e-07_r8,0.61933e-07_r8 /)
      kbo(:,26, 5) = (/ &
        & 0.55089e-07_r8,0.55723e-07_r8,0.55839e-07_r8,0.56337e-07_r8,0.60335e-07_r8 /)
      kbo(:,27, 5) = (/ &
        & 0.52294e-07_r8,0.51745e-07_r8,0.52750e-07_r8,0.52701e-07_r8,0.57676e-07_r8 /)
      kbo(:,28, 5) = (/ &
        & 0.48915e-07_r8,0.48234e-07_r8,0.48708e-07_r8,0.49873e-07_r8,0.54442e-07_r8 /)
      kbo(:,29, 5) = (/ &
        & 0.43357e-07_r8,0.43230e-07_r8,0.43679e-07_r8,0.47285e-07_r8,0.49519e-07_r8 /)
      kbo(:,30, 5) = (/ &
        & 0.37379e-07_r8,0.38427e-07_r8,0.39703e-07_r8,0.43492e-07_r8,0.43278e-07_r8 /)
      kbo(:,31, 5) = (/ &
        & 0.31354e-07_r8,0.32238e-07_r8,0.35376e-07_r8,0.37358e-07_r8,0.37130e-07_r8 /)
      kbo(:,32, 5) = (/ &
        & 0.26553e-07_r8,0.27801e-07_r8,0.30978e-07_r8,0.30698e-07_r8,0.31234e-07_r8 /)
      kbo(:,33, 5) = (/ &
        & 0.21542e-07_r8,0.24274e-07_r8,0.24944e-07_r8,0.25194e-07_r8,0.25415e-07_r8 /)
      kbo(:,34, 5) = (/ &
        & 0.19097e-07_r8,0.20582e-07_r8,0.20324e-07_r8,0.21006e-07_r8,0.20944e-07_r8 /)
      kbo(:,35, 5) = (/ &
        & 0.16377e-07_r8,0.16881e-07_r8,0.16957e-07_r8,0.16743e-07_r8,0.16958e-07_r8 /)
      kbo(:,36, 5) = (/ &
        & 0.13727e-07_r8,0.13834e-07_r8,0.13766e-07_r8,0.13776e-07_r8,0.13546e-07_r8 /)
      kbo(:,37, 5) = (/ &
        & 0.11550e-07_r8,0.11601e-07_r8,0.11757e-07_r8,0.11723e-07_r8,0.11413e-07_r8 /)
      kbo(:,38, 5) = (/ &
        & 0.98076e-08_r8,0.96320e-08_r8,0.10028e-07_r8,0.98197e-08_r8,0.91408e-08_r8 /)
      kbo(:,39, 5) = (/ &
        & 0.80861e-08_r8,0.80113e-08_r8,0.81586e-08_r8,0.80121e-08_r8,0.75021e-08_r8 /)
      kbo(:,40, 5) = (/ &
        & 0.70348e-08_r8,0.69980e-08_r8,0.71058e-08_r8,0.69171e-08_r8,0.64103e-08_r8 /)
      kbo(:,41, 5) = (/ &
        & 0.61395e-08_r8,0.60379e-08_r8,0.61651e-08_r8,0.59006e-08_r8,0.54433e-08_r8 /)
      kbo(:,42, 5) = (/ &
        & 0.51740e-08_r8,0.51391e-08_r8,0.53717e-08_r8,0.50506e-08_r8,0.46901e-08_r8 /)
      kbo(:,43, 5) = (/ &
        & 0.44374e-08_r8,0.44002e-08_r8,0.45405e-08_r8,0.42888e-08_r8,0.39390e-08_r8 /)
      kbo(:,44, 5) = (/ &
        & 0.36635e-08_r8,0.37555e-08_r8,0.37320e-08_r8,0.35598e-08_r8,0.33280e-08_r8 /)
      kbo(:,45, 5) = (/ &
        & 0.30833e-08_r8,0.31320e-08_r8,0.30264e-08_r8,0.29827e-08_r8,0.28298e-08_r8 /)
      kbo(:,46, 5) = (/ &
        & 0.25366e-08_r8,0.26077e-08_r8,0.24905e-08_r8,0.24281e-08_r8,0.22727e-08_r8 /)
      kbo(:,47, 5) = (/ &
        & 0.20576e-08_r8,0.22029e-08_r8,0.20905e-08_r8,0.21040e-08_r8,0.19027e-08_r8 /)
      kbo(:,48, 5) = (/ &
        & 0.16047e-08_r8,0.18190e-08_r8,0.17008e-08_r8,0.17298e-08_r8,0.16059e-08_r8 /)
      kbo(:,49, 5) = (/ &
        & 0.12276e-08_r8,0.14135e-08_r8,0.13565e-08_r8,0.13704e-08_r8,0.13029e-08_r8 /)
      kbo(:,50, 5) = (/ &
        & 0.98291e-09_r8,0.11837e-08_r8,0.11000e-08_r8,0.11342e-08_r8,0.10621e-08_r8 /)
      kbo(:,51, 5) = (/ &
        & 0.79374e-09_r8,0.97756e-09_r8,0.90252e-09_r8,0.90527e-09_r8,0.86815e-09_r8 /)
      kbo(:,52, 5) = (/ &
        & 0.64781e-09_r8,0.78454e-09_r8,0.75690e-09_r8,0.74124e-09_r8,0.73195e-09_r8 /)
      kbo(:,53, 5) = (/ &
        & 0.51536e-09_r8,0.61158e-09_r8,0.60936e-09_r8,0.59007e-09_r8,0.58458e-09_r8 /)
      kbo(:,54, 5) = (/ &
        & 0.46178e-09_r8,0.51944e-09_r8,0.52167e-09_r8,0.53965e-09_r8,0.50524e-09_r8 /)
      kbo(:,55, 5) = (/ &
        & 0.44467e-09_r8,0.42857e-09_r8,0.50799e-09_r8,0.47528e-09_r8,0.43900e-09_r8 /)
      kbo(:,56, 5) = (/ &
        & 0.39667e-09_r8,0.37862e-09_r8,0.45808e-09_r8,0.43270e-09_r8,0.38817e-09_r8 /)
      kbo(:,57, 5) = (/ &
        & 0.35926e-09_r8,0.35410e-09_r8,0.38962e-09_r8,0.37502e-09_r8,0.40935e-09_r8 /)
      kbo(:,58, 5) = (/ &
        & 0.31517e-09_r8,0.32964e-09_r8,0.29323e-09_r8,0.39945e-09_r8,0.40389e-09_r8 /)
      kbo(:,59, 5) = (/ &
        & 0.36198e-09_r8,0.38633e-09_r8,0.41096e-09_r8,0.53914e-09_r8,0.57631e-09_r8 /)
      kbo(:,13, 6) = (/ &
        & 0.23095e-07_r8,0.23025e-07_r8,0.25126e-07_r8,0.25618e-07_r8,0.24969e-07_r8 /)
      kbo(:,14, 6) = (/ &
        & 0.31573e-07_r8,0.32360e-07_r8,0.33220e-07_r8,0.32611e-07_r8,0.32150e-07_r8 /)
      kbo(:,15, 6) = (/ &
        & 0.45219e-07_r8,0.45787e-07_r8,0.47088e-07_r8,0.49543e-07_r8,0.54072e-07_r8 /)
      kbo(:,16, 6) = (/ &
        & 0.65293e-07_r8,0.67448e-07_r8,0.64557e-07_r8,0.63976e-07_r8,0.64905e-07_r8 /)
      kbo(:,17, 6) = (/ &
        & 0.64862e-07_r8,0.63259e-07_r8,0.62851e-07_r8,0.62500e-07_r8,0.63112e-07_r8 /)
      kbo(:,18, 6) = (/ &
        & 0.61849e-07_r8,0.62108e-07_r8,0.60565e-07_r8,0.60920e-07_r8,0.61810e-07_r8 /)
      kbo(:,19, 6) = (/ &
        & 0.63930e-07_r8,0.63195e-07_r8,0.62478e-07_r8,0.62282e-07_r8,0.62250e-07_r8 /)
      kbo(:,20, 6) = (/ &
        & 0.60100e-07_r8,0.60269e-07_r8,0.59919e-07_r8,0.57578e-07_r8,0.57933e-07_r8 /)
      kbo(:,21, 6) = (/ &
        & 0.56465e-07_r8,0.56674e-07_r8,0.56992e-07_r8,0.55969e-07_r8,0.54719e-07_r8 /)
      kbo(:,22, 6) = (/ &
        & 0.54280e-07_r8,0.53760e-07_r8,0.52615e-07_r8,0.52261e-07_r8,0.51523e-07_r8 /)
      kbo(:,23, 6) = (/ &
        & 0.49921e-07_r8,0.49472e-07_r8,0.49168e-07_r8,0.47959e-07_r8,0.47449e-07_r8 /)
      kbo(:,24, 6) = (/ &
        & 0.45803e-07_r8,0.46271e-07_r8,0.46322e-07_r8,0.46536e-07_r8,0.46494e-07_r8 /)
      kbo(:,25, 6) = (/ &
        & 0.43723e-07_r8,0.44225e-07_r8,0.44324e-07_r8,0.43726e-07_r8,0.43579e-07_r8 /)
      kbo(:,26, 6) = (/ &
        & 0.41617e-07_r8,0.42588e-07_r8,0.42306e-07_r8,0.41086e-07_r8,0.41943e-07_r8 /)
      kbo(:,27, 6) = (/ &
        & 0.38855e-07_r8,0.40231e-07_r8,0.39090e-07_r8,0.39461e-07_r8,0.39072e-07_r8 /)
      kbo(:,28, 6) = (/ &
        & 0.35912e-07_r8,0.36691e-07_r8,0.35670e-07_r8,0.35644e-07_r8,0.38295e-07_r8 /)
      kbo(:,29, 6) = (/ &
        & 0.33357e-07_r8,0.33134e-07_r8,0.32394e-07_r8,0.32909e-07_r8,0.36234e-07_r8 /)
      kbo(:,30, 6) = (/ &
        & 0.30529e-07_r8,0.29196e-07_r8,0.29147e-07_r8,0.30292e-07_r8,0.33912e-07_r8 /)
      kbo(:,31, 6) = (/ &
        & 0.27228e-07_r8,0.27081e-07_r8,0.26630e-07_r8,0.30010e-07_r8,0.28781e-07_r8 /)
      kbo(:,32, 6) = (/ &
        & 0.24109e-07_r8,0.24388e-07_r8,0.25546e-07_r8,0.26823e-07_r8,0.26681e-07_r8 /)
      kbo(:,33, 6) = (/ &
        & 0.21402e-07_r8,0.22303e-07_r8,0.24668e-07_r8,0.24556e-07_r8,0.24369e-07_r8 /)
      kbo(:,34, 6) = (/ &
        & 0.18136e-07_r8,0.20944e-07_r8,0.21211e-07_r8,0.21286e-07_r8,0.21648e-07_r8 /)
      kbo(:,35, 6) = (/ &
        & 0.16306e-07_r8,0.17531e-07_r8,0.17744e-07_r8,0.18061e-07_r8,0.18282e-07_r8 /)
      kbo(:,36, 6) = (/ &
        & 0.13873e-07_r8,0.14963e-07_r8,0.15398e-07_r8,0.15527e-07_r8,0.15391e-07_r8 /)
      kbo(:,37, 6) = (/ &
        & 0.11948e-07_r8,0.12614e-07_r8,0.12946e-07_r8,0.12916e-07_r8,0.13085e-07_r8 /)
      kbo(:,38, 6) = (/ &
        & 0.98235e-08_r8,0.10612e-07_r8,0.10029e-07_r8,0.10618e-07_r8,0.10860e-07_r8 /)
      kbo(:,39, 6) = (/ &
        & 0.81514e-08_r8,0.84716e-08_r8,0.81123e-08_r8,0.83644e-08_r8,0.81668e-08_r8 /)
      kbo(:,40, 6) = (/ &
        & 0.68179e-08_r8,0.69030e-08_r8,0.69393e-08_r8,0.69969e-08_r8,0.71027e-08_r8 /)
      kbo(:,41, 6) = (/ &
        & 0.59350e-08_r8,0.60668e-08_r8,0.59026e-08_r8,0.60181e-08_r8,0.60779e-08_r8 /)
      kbo(:,42, 6) = (/ &
        & 0.51181e-08_r8,0.52127e-08_r8,0.48788e-08_r8,0.51397e-08_r8,0.50230e-08_r8 /)
      kbo(:,43, 6) = (/ &
        & 0.42653e-08_r8,0.44600e-08_r8,0.41100e-08_r8,0.44735e-08_r8,0.42607e-08_r8 /)
      kbo(:,44, 6) = (/ &
        & 0.34724e-08_r8,0.37628e-08_r8,0.35340e-08_r8,0.38309e-08_r8,0.36188e-08_r8 /)
      kbo(:,45, 6) = (/ &
        & 0.27994e-08_r8,0.31690e-08_r8,0.28599e-08_r8,0.30290e-08_r8,0.27730e-08_r8 /)
      kbo(:,46, 6) = (/ &
        & 0.22089e-08_r8,0.25761e-08_r8,0.23856e-08_r8,0.24874e-08_r8,0.23603e-08_r8 /)
      kbo(:,47, 6) = (/ &
        & 0.18078e-08_r8,0.20304e-08_r8,0.19457e-08_r8,0.19366e-08_r8,0.19286e-08_r8 /)
      kbo(:,48, 6) = (/ &
        & 0.14716e-08_r8,0.15703e-08_r8,0.17393e-08_r8,0.14836e-08_r8,0.15316e-08_r8 /)
      kbo(:,49, 6) = (/ &
        & 0.11334e-08_r8,0.12901e-08_r8,0.13556e-08_r8,0.11610e-08_r8,0.11617e-08_r8 /)
      kbo(:,50, 6) = (/ &
        & 0.90881e-09_r8,0.10323e-08_r8,0.11378e-08_r8,0.95509e-09_r8,0.96291e-09_r8 /)
      kbo(:,51, 6) = (/ &
        & 0.76751e-09_r8,0.81710e-09_r8,0.97432e-09_r8,0.82408e-09_r8,0.81205e-09_r8 /)
      kbo(:,52, 6) = (/ &
        & 0.62668e-09_r8,0.66223e-09_r8,0.76870e-09_r8,0.68347e-09_r8,0.65771e-09_r8 /)
      kbo(:,53, 6) = (/ &
        & 0.50547e-09_r8,0.49991e-09_r8,0.61494e-09_r8,0.55640e-09_r8,0.52803e-09_r8 /)
      kbo(:,54, 6) = (/ &
        & 0.42841e-09_r8,0.42678e-09_r8,0.51796e-09_r8,0.46340e-09_r8,0.44830e-09_r8 /)
      kbo(:,55, 6) = (/ &
        & 0.40234e-09_r8,0.40065e-09_r8,0.45944e-09_r8,0.42252e-09_r8,0.44365e-09_r8 /)
      kbo(:,56, 6) = (/ &
        & 0.36764e-09_r8,0.35937e-09_r8,0.36570e-09_r8,0.44631e-09_r8,0.45684e-09_r8 /)
      kbo(:,57, 6) = (/ &
        & 0.33321e-09_r8,0.29808e-09_r8,0.31056e-09_r8,0.44585e-09_r8,0.41122e-09_r8 /)
      kbo(:,58, 6) = (/ &
        & 0.31198e-09_r8,0.29542e-09_r8,0.33327e-09_r8,0.43871e-09_r8,0.45291e-09_r8 /)
      kbo(:,59, 6) = (/ &
        & 0.38710e-09_r8,0.42412e-09_r8,0.44197e-09_r8,0.49964e-09_r8,0.70387e-09_r8 /)
      kbo(:,13, 7) = (/ &
        & 0.30377e-07_r8,0.31586e-07_r8,0.27647e-07_r8,0.27937e-07_r8,0.28036e-07_r8 /)
      kbo(:,14, 7) = (/ &
        & 0.37766e-07_r8,0.39819e-07_r8,0.39822e-07_r8,0.40069e-07_r8,0.42091e-07_r8 /)
      kbo(:,15, 7) = (/ &
        & 0.57996e-07_r8,0.64474e-07_r8,0.69368e-07_r8,0.70909e-07_r8,0.70748e-07_r8 /)
      kbo(:,16, 7) = (/ &
        & 0.73220e-07_r8,0.70124e-07_r8,0.69135e-07_r8,0.68058e-07_r8,0.66524e-07_r8 /)
      kbo(:,17, 7) = (/ &
        & 0.66529e-07_r8,0.66306e-07_r8,0.63797e-07_r8,0.63551e-07_r8,0.63462e-07_r8 /)
      kbo(:,18, 7) = (/ &
        & 0.66492e-07_r8,0.65156e-07_r8,0.66323e-07_r8,0.64485e-07_r8,0.63285e-07_r8 /)
      kbo(:,19, 7) = (/ &
        & 0.62980e-07_r8,0.62900e-07_r8,0.62718e-07_r8,0.61114e-07_r8,0.59765e-07_r8 /)
      kbo(:,20, 7) = (/ &
        & 0.59754e-07_r8,0.58066e-07_r8,0.59540e-07_r8,0.58926e-07_r8,0.57835e-07_r8 /)
      kbo(:,21, 7) = (/ &
        & 0.57368e-07_r8,0.55161e-07_r8,0.55685e-07_r8,0.55360e-07_r8,0.53982e-07_r8 /)
      kbo(:,22, 7) = (/ &
        & 0.51435e-07_r8,0.49998e-07_r8,0.50952e-07_r8,0.50442e-07_r8,0.49717e-07_r8 /)
      kbo(:,23, 7) = (/ &
        & 0.47663e-07_r8,0.46845e-07_r8,0.47849e-07_r8,0.48876e-07_r8,0.48885e-07_r8 /)
      kbo(:,24, 7) = (/ &
        & 0.47926e-07_r8,0.45619e-07_r8,0.45793e-07_r8,0.46467e-07_r8,0.45938e-07_r8 /)
      kbo(:,25, 7) = (/ &
        & 0.44687e-07_r8,0.43904e-07_r8,0.44284e-07_r8,0.44176e-07_r8,0.45520e-07_r8 /)
      kbo(:,26, 7) = (/ &
        & 0.42751e-07_r8,0.41938e-07_r8,0.42889e-07_r8,0.42927e-07_r8,0.43868e-07_r8 /)
      kbo(:,27, 7) = (/ &
        & 0.40180e-07_r8,0.40529e-07_r8,0.40621e-07_r8,0.40949e-07_r8,0.41005e-07_r8 /)
      kbo(:,28, 7) = (/ &
        & 0.35890e-07_r8,0.36716e-07_r8,0.37875e-07_r8,0.38308e-07_r8,0.37626e-07_r8 /)
      kbo(:,29, 7) = (/ &
        & 0.31499e-07_r8,0.33284e-07_r8,0.32725e-07_r8,0.32493e-07_r8,0.35018e-07_r8 /)
      kbo(:,30, 7) = (/ &
        & 0.29364e-07_r8,0.28675e-07_r8,0.28942e-07_r8,0.28761e-07_r8,0.33960e-07_r8 /)
      kbo(:,31, 7) = (/ &
        & 0.25558e-07_r8,0.23679e-07_r8,0.24292e-07_r8,0.26053e-07_r8,0.29211e-07_r8 /)
      kbo(:,32, 7) = (/ &
        & 0.20860e-07_r8,0.21491e-07_r8,0.20910e-07_r8,0.25598e-07_r8,0.24209e-07_r8 /)
      kbo(:,33, 7) = (/ &
        & 0.18874e-07_r8,0.18554e-07_r8,0.21206e-07_r8,0.20708e-07_r8,0.21100e-07_r8 /)
      kbo(:,34, 7) = (/ &
        & 0.18632e-07_r8,0.18625e-07_r8,0.20707e-07_r8,0.19570e-07_r8,0.18956e-07_r8 /)
      kbo(:,35, 7) = (/ &
        & 0.15958e-07_r8,0.19141e-07_r8,0.19004e-07_r8,0.19249e-07_r8,0.17793e-07_r8 /)
      kbo(:,36, 7) = (/ &
        & 0.14552e-07_r8,0.16561e-07_r8,0.16607e-07_r8,0.16784e-07_r8,0.16326e-07_r8 /)
      kbo(:,37, 7) = (/ &
        & 0.13127e-07_r8,0.14300e-07_r8,0.14021e-07_r8,0.14385e-07_r8,0.13328e-07_r8 /)
      kbo(:,38, 7) = (/ &
        & 0.11514e-07_r8,0.12356e-07_r8,0.12677e-07_r8,0.12181e-07_r8,0.11774e-07_r8 /)
      kbo(:,39, 7) = (/ &
        & 0.93434e-08_r8,0.10196e-07_r8,0.10605e-07_r8,0.10201e-07_r8,0.10584e-07_r8 /)
      kbo(:,40, 7) = (/ &
        & 0.81790e-08_r8,0.89000e-08_r8,0.85315e-08_r8,0.89663e-08_r8,0.91635e-08_r8 /)
      kbo(:,41, 7) = (/ &
        & 0.65541e-08_r8,0.74884e-08_r8,0.72364e-08_r8,0.72692e-08_r8,0.75649e-08_r8 /)
      kbo(:,42, 7) = (/ &
        & 0.54665e-08_r8,0.61796e-08_r8,0.61564e-08_r8,0.61304e-08_r8,0.64285e-08_r8 /)
      kbo(:,43, 7) = (/ &
        & 0.43531e-08_r8,0.47798e-08_r8,0.51393e-08_r8,0.49135e-08_r8,0.53520e-08_r8 /)
      kbo(:,44, 7) = (/ &
        & 0.35872e-08_r8,0.38233e-08_r8,0.42659e-08_r8,0.39384e-08_r8,0.44541e-08_r8 /)
      kbo(:,45, 7) = (/ &
        & 0.28156e-08_r8,0.32775e-08_r8,0.36262e-08_r8,0.32518e-08_r8,0.36805e-08_r8 /)
      kbo(:,46, 7) = (/ &
        & 0.23879e-08_r8,0.26299e-08_r8,0.28972e-08_r8,0.27379e-08_r8,0.30333e-08_r8 /)
      kbo(:,47, 7) = (/ &
        & 0.19282e-08_r8,0.22066e-08_r8,0.23812e-08_r8,0.23512e-08_r8,0.23794e-08_r8 /)
      kbo(:,48, 7) = (/ &
        & 0.15092e-08_r8,0.18255e-08_r8,0.17414e-08_r8,0.19322e-08_r8,0.19399e-08_r8 /)
      kbo(:,49, 7) = (/ &
        & 0.11905e-08_r8,0.13964e-08_r8,0.14306e-08_r8,0.14791e-08_r8,0.14939e-08_r8 /)
      kbo(:,50, 7) = (/ &
        & 0.98537e-09_r8,0.10687e-08_r8,0.11753e-08_r8,0.11334e-08_r8,0.13178e-08_r8 /)
      kbo(:,51, 7) = (/ &
        & 0.84255e-09_r8,0.88069e-09_r8,0.95073e-09_r8,0.92632e-09_r8,0.10457e-08_r8 /)
      kbo(:,52, 7) = (/ &
        & 0.68238e-09_r8,0.70376e-09_r8,0.74795e-09_r8,0.75152e-09_r8,0.78131e-09_r8 /)
      kbo(:,53, 7) = (/ &
        & 0.56271e-09_r8,0.58527e-09_r8,0.61397e-09_r8,0.56343e-09_r8,0.61138e-09_r8 /)
      kbo(:,54, 7) = (/ &
        & 0.52493e-09_r8,0.46040e-09_r8,0.53769e-09_r8,0.51459e-09_r8,0.52912e-09_r8 /)
      kbo(:,55, 7) = (/ &
        & 0.40372e-09_r8,0.38720e-09_r8,0.40004e-09_r8,0.56294e-09_r8,0.55844e-09_r8 /)
      kbo(:,56, 7) = (/ &
        & 0.37372e-09_r8,0.35358e-09_r8,0.39920e-09_r8,0.52819e-09_r8,0.50147e-09_r8 /)
      kbo(:,57, 7) = (/ &
        & 0.31149e-09_r8,0.39454e-09_r8,0.38951e-09_r8,0.52086e-09_r8,0.54542e-09_r8 /)
      kbo(:,58, 7) = (/ &
        & 0.30564e-09_r8,0.36251e-09_r8,0.38551e-09_r8,0.43845e-09_r8,0.61772e-09_r8 /)
      kbo(:,59, 7) = (/ &
        & 0.46934e-09_r8,0.57639e-09_r8,0.58591e-09_r8,0.63021e-09_r8,0.71158e-09_r8 /)
      kbo(:,13, 8) = (/ &
        & 0.34320e-07_r8,0.31607e-07_r8,0.29840e-07_r8,0.29114e-07_r8,0.28831e-07_r8 /)
      kbo(:,14, 8) = (/ &
        & 0.38157e-07_r8,0.37907e-07_r8,0.40351e-07_r8,0.45015e-07_r8,0.44786e-07_r8 /)
      kbo(:,15, 8) = (/ &
        & 0.71231e-07_r8,0.71647e-07_r8,0.71034e-07_r8,0.71647e-07_r8,0.71755e-07_r8 /)
      kbo(:,16, 8) = (/ &
        & 0.72049e-07_r8,0.69075e-07_r8,0.67707e-07_r8,0.67019e-07_r8,0.66780e-07_r8 /)
      kbo(:,17, 8) = (/ &
        & 0.69751e-07_r8,0.66211e-07_r8,0.66017e-07_r8,0.63095e-07_r8,0.63343e-07_r8 /)
      kbo(:,18, 8) = (/ &
        & 0.67728e-07_r8,0.66581e-07_r8,0.64787e-07_r8,0.62981e-07_r8,0.62245e-07_r8 /)
      kbo(:,19, 8) = (/ &
        & 0.65864e-07_r8,0.63789e-07_r8,0.62712e-07_r8,0.62065e-07_r8,0.61005e-07_r8 /)
      kbo(:,20, 8) = (/ &
        & 0.61816e-07_r8,0.63755e-07_r8,0.63424e-07_r8,0.61945e-07_r8,0.58720e-07_r8 /)
      kbo(:,21, 8) = (/ &
        & 0.59112e-07_r8,0.58061e-07_r8,0.57019e-07_r8,0.54795e-07_r8,0.56069e-07_r8 /)
      kbo(:,22, 8) = (/ &
        & 0.56217e-07_r8,0.53887e-07_r8,0.54812e-07_r8,0.52500e-07_r8,0.53303e-07_r8 /)
      kbo(:,23, 8) = (/ &
        & 0.54428e-07_r8,0.52930e-07_r8,0.53278e-07_r8,0.52797e-07_r8,0.51840e-07_r8 /)
      kbo(:,24, 8) = (/ &
        & 0.51236e-07_r8,0.52532e-07_r8,0.53348e-07_r8,0.51715e-07_r8,0.53224e-07_r8 /)
      kbo(:,25, 8) = (/ &
        & 0.49989e-07_r8,0.50872e-07_r8,0.49932e-07_r8,0.52702e-07_r8,0.51493e-07_r8 /)
      kbo(:,26, 8) = (/ &
        & 0.49845e-07_r8,0.48733e-07_r8,0.48348e-07_r8,0.51346e-07_r8,0.51109e-07_r8 /)
      kbo(:,27, 8) = (/ &
        & 0.43883e-07_r8,0.43853e-07_r8,0.46523e-07_r8,0.47281e-07_r8,0.47292e-07_r8 /)
      kbo(:,28, 8) = (/ &
        & 0.41424e-07_r8,0.42057e-07_r8,0.43773e-07_r8,0.43422e-07_r8,0.41438e-07_r8 /)
      kbo(:,29, 8) = (/ &
        & 0.37736e-07_r8,0.34915e-07_r8,0.37971e-07_r8,0.38437e-07_r8,0.38122e-07_r8 /)
      kbo(:,30, 8) = (/ &
        & 0.30209e-07_r8,0.32936e-07_r8,0.31853e-07_r8,0.30285e-07_r8,0.31746e-07_r8 /)
      kbo(:,31, 8) = (/ &
        & 0.25886e-07_r8,0.26990e-07_r8,0.27039e-07_r8,0.26019e-07_r8,0.34246e-07_r8 /)
      kbo(:,32, 8) = (/ &
        & 0.24750e-07_r8,0.20653e-07_r8,0.21921e-07_r8,0.25087e-07_r8,0.25874e-07_r8 /)
      kbo(:,33, 8) = (/ &
        & 0.19410e-07_r8,0.18820e-07_r8,0.18768e-07_r8,0.23223e-07_r8,0.20942e-07_r8 /)
      kbo(:,34, 8) = (/ &
        & 0.16037e-07_r8,0.16060e-07_r8,0.19012e-07_r8,0.17686e-07_r8,0.18319e-07_r8 /)
      kbo(:,35, 8) = (/ &
        & 0.16085e-07_r8,0.15072e-07_r8,0.16472e-07_r8,0.15719e-07_r8,0.16406e-07_r8 /)
      kbo(:,36, 8) = (/ &
        & 0.15014e-07_r8,0.17144e-07_r8,0.16353e-07_r8,0.15223e-07_r8,0.14884e-07_r8 /)
      kbo(:,37, 8) = (/ &
        & 0.12909e-07_r8,0.15628e-07_r8,0.16086e-07_r8,0.15318e-07_r8,0.15605e-07_r8 /)
      kbo(:,38, 8) = (/ &
        & 0.11803e-07_r8,0.12970e-07_r8,0.13587e-07_r8,0.13257e-07_r8,0.13920e-07_r8 /)
      kbo(:,39, 8) = (/ &
        & 0.10299e-07_r8,0.10951e-07_r8,0.11006e-07_r8,0.11507e-07_r8,0.10553e-07_r8 /)
      kbo(:,40, 8) = (/ &
        & 0.87605e-08_r8,0.10094e-07_r8,0.10641e-07_r8,0.94199e-08_r8,0.97115e-08_r8 /)
      kbo(:,41, 8) = (/ &
        & 0.69747e-08_r8,0.82105e-08_r8,0.93516e-08_r8,0.90234e-08_r8,0.91657e-08_r8 /)
      kbo(:,42, 8) = (/ &
        & 0.60201e-08_r8,0.73523e-08_r8,0.76249e-08_r8,0.76962e-08_r8,0.80489e-08_r8 /)
      kbo(:,43, 8) = (/ &
        & 0.50249e-08_r8,0.64035e-08_r8,0.62997e-08_r8,0.63745e-08_r8,0.65773e-08_r8 /)
      kbo(:,44, 8) = (/ &
        & 0.43021e-08_r8,0.55682e-08_r8,0.52391e-08_r8,0.55432e-08_r8,0.53417e-08_r8 /)
      kbo(:,45, 8) = (/ &
        & 0.34659e-08_r8,0.41011e-08_r8,0.41998e-08_r8,0.45328e-08_r8,0.45452e-08_r8 /)
      kbo(:,46, 8) = (/ &
        & 0.26629e-08_r8,0.30573e-08_r8,0.34050e-08_r8,0.36018e-08_r8,0.38146e-08_r8 /)
      kbo(:,47, 8) = (/ &
        & 0.20352e-08_r8,0.25120e-08_r8,0.29668e-08_r8,0.27818e-08_r8,0.34015e-08_r8 /)
      kbo(:,48, 8) = (/ &
        & 0.16537e-08_r8,0.17568e-08_r8,0.23894e-08_r8,0.22154e-08_r8,0.25802e-08_r8 /)
      kbo(:,49, 8) = (/ &
        & 0.13981e-08_r8,0.14349e-08_r8,0.17246e-08_r8,0.17767e-08_r8,0.19090e-08_r8 /)
      kbo(:,50, 8) = (/ &
        & 0.10918e-08_r8,0.11356e-08_r8,0.12258e-08_r8,0.14996e-08_r8,0.12493e-08_r8 /)
      kbo(:,51, 8) = (/ &
        & 0.96204e-09_r8,0.88786e-09_r8,0.10061e-08_r8,0.12415e-08_r8,0.10774e-08_r8 /)
      kbo(:,52, 8) = (/ &
        & 0.79848e-09_r8,0.70289e-09_r8,0.84515e-09_r8,0.10143e-08_r8,0.85552e-09_r8 /)
      kbo(:,53, 8) = (/ &
        & 0.60435e-09_r8,0.54746e-09_r8,0.63806e-09_r8,0.74615e-09_r8,0.64507e-09_r8 /)
      kbo(:,54, 8) = (/ &
        & 0.47378e-09_r8,0.48059e-09_r8,0.54886e-09_r8,0.73215e-09_r8,0.65721e-09_r8 /)
      kbo(:,55, 8) = (/ &
        & 0.45346e-09_r8,0.46291e-09_r8,0.55380e-09_r8,0.67829e-09_r8,0.56756e-09_r8 /)
      kbo(:,56, 8) = (/ &
        & 0.43938e-09_r8,0.46043e-09_r8,0.50980e-09_r8,0.62685e-09_r8,0.70094e-09_r8 /)
      kbo(:,57, 8) = (/ &
        & 0.42587e-09_r8,0.43184e-09_r8,0.47819e-09_r8,0.57152e-09_r8,0.76528e-09_r8 /)
      kbo(:,58, 8) = (/ &
        & 0.47403e-09_r8,0.46387e-09_r8,0.50904e-09_r8,0.58886e-09_r8,0.70162e-09_r8 /)
      kbo(:,59, 8) = (/ &
        & 0.54448e-09_r8,0.50172e-09_r8,0.65155e-09_r8,0.65748e-09_r8,0.98321e-09_r8 /)
      kbo(:,13, 9) = (/ &
        & 0.10995e-05_r8,0.11095e-05_r8,0.11168e-05_r8,0.11200e-05_r8,0.11274e-05_r8 /)
      kbo(:,14, 9) = (/ &
        & 0.73340e-06_r8,0.73567e-06_r8,0.73740e-06_r8,0.73330e-06_r8,0.73919e-06_r8 /)
      kbo(:,15, 9) = (/ &
        & 0.32510e-06_r8,0.31252e-06_r8,0.30243e-06_r8,0.29146e-06_r8,0.28830e-06_r8 /)
      kbo(:,16, 9) = (/ &
        & 0.61567e-07_r8,0.60590e-07_r8,0.61057e-07_r8,0.58821e-07_r8,0.58536e-07_r8 /)
      kbo(:,17, 9) = (/ &
        & 0.60009e-07_r8,0.60924e-07_r8,0.61205e-07_r8,0.63591e-07_r8,0.59950e-07_r8 /)
      kbo(:,18, 9) = (/ &
        & 0.61458e-07_r8,0.61692e-07_r8,0.60339e-07_r8,0.59878e-07_r8,0.58575e-07_r8 /)
      kbo(:,19, 9) = (/ &
        & 0.57878e-07_r8,0.60299e-07_r8,0.60236e-07_r8,0.59512e-07_r8,0.58126e-07_r8 /)
      kbo(:,20, 9) = (/ &
        & 0.58329e-07_r8,0.57451e-07_r8,0.54760e-07_r8,0.57082e-07_r8,0.56805e-07_r8 /)
      kbo(:,21, 9) = (/ &
        & 0.53092e-07_r8,0.51700e-07_r8,0.51833e-07_r8,0.52853e-07_r8,0.52467e-07_r8 /)
      kbo(:,22, 9) = (/ &
        & 0.47591e-07_r8,0.51357e-07_r8,0.49075e-07_r8,0.53548e-07_r8,0.55924e-07_r8 /)
      kbo(:,23, 9) = (/ &
        & 0.49724e-07_r8,0.51803e-07_r8,0.51793e-07_r8,0.49922e-07_r8,0.52665e-07_r8 /)
      kbo(:,24, 9) = (/ &
        & 0.47737e-07_r8,0.49279e-07_r8,0.51207e-07_r8,0.49000e-07_r8,0.51613e-07_r8 /)
      kbo(:,25, 9) = (/ &
        & 0.49014e-07_r8,0.50174e-07_r8,0.54886e-07_r8,0.47520e-07_r8,0.49798e-07_r8 /)
      kbo(:,26, 9) = (/ &
        & 0.42783e-07_r8,0.51200e-07_r8,0.50600e-07_r8,0.47620e-07_r8,0.43709e-07_r8 /)
      kbo(:,27, 9) = (/ &
        & 0.42685e-07_r8,0.50611e-07_r8,0.42800e-07_r8,0.43026e-07_r8,0.46518e-07_r8 /)
      kbo(:,28, 9) = (/ &
        & 0.40023e-07_r8,0.44433e-07_r8,0.38380e-07_r8,0.40945e-07_r8,0.42005e-07_r8 /)
      kbo(:,29, 9) = (/ &
        & 0.34641e-07_r8,0.38943e-07_r8,0.36153e-07_r8,0.36773e-07_r8,0.32051e-07_r8 /)
      kbo(:,30, 9) = (/ &
        & 0.31936e-07_r8,0.28774e-07_r8,0.32629e-07_r8,0.32074e-07_r8,0.31547e-07_r8 /)
      kbo(:,31, 9) = (/ &
        & 0.25468e-07_r8,0.25946e-07_r8,0.23671e-07_r8,0.23770e-07_r8,0.28704e-07_r8 /)
      kbo(:,32, 9) = (/ &
        & 0.18317e-07_r8,0.22069e-07_r8,0.20055e-07_r8,0.21665e-07_r8,0.25653e-07_r8 /)
      kbo(:,33, 9) = (/ &
        & 0.18319e-07_r8,0.17920e-07_r8,0.16523e-07_r8,0.20049e-07_r8,0.19951e-07_r8 /)
      kbo(:,34, 9) = (/ &
        & 0.15127e-07_r8,0.13546e-07_r8,0.16257e-07_r8,0.16818e-07_r8,0.15661e-07_r8 /)
      kbo(:,35, 9) = (/ &
        & 0.12192e-07_r8,0.13829e-07_r8,0.15792e-07_r8,0.15440e-07_r8,0.14596e-07_r8 /)
      kbo(:,36, 9) = (/ &
        & 0.11593e-07_r8,0.10509e-07_r8,0.13211e-07_r8,0.13026e-07_r8,0.13917e-07_r8 /)
      kbo(:,37, 9) = (/ &
        & 0.12302e-07_r8,0.13196e-07_r8,0.12558e-07_r8,0.11760e-07_r8,0.12490e-07_r8 /)
      kbo(:,38, 9) = (/ &
        & 0.10116e-07_r8,0.12498e-07_r8,0.12546e-07_r8,0.12890e-07_r8,0.12908e-07_r8 /)
      kbo(:,39, 9) = (/ &
        & 0.88258e-08_r8,0.10400e-07_r8,0.11293e-07_r8,0.11361e-07_r8,0.11468e-07_r8 /)
      kbo(:,40, 9) = (/ &
        & 0.70753e-08_r8,0.81481e-08_r8,0.94292e-08_r8,0.10943e-07_r8,0.90300e-08_r8 /)
      kbo(:,41, 9) = (/ &
        & 0.71994e-08_r8,0.84394e-08_r8,0.89108e-08_r8,0.89407e-08_r8,0.87875e-08_r8 /)
      kbo(:,42, 9) = (/ &
        & 0.55536e-08_r8,0.66846e-08_r8,0.83965e-08_r8,0.80560e-08_r8,0.79305e-08_r8 /)
      kbo(:,43, 9) = (/ &
        & 0.50223e-08_r8,0.59958e-08_r8,0.69583e-08_r8,0.70648e-08_r8,0.76990e-08_r8 /)
      kbo(:,44, 9) = (/ &
        & 0.40990e-08_r8,0.43884e-08_r8,0.50706e-08_r8,0.56081e-08_r8,0.62414e-08_r8 /)
      kbo(:,45, 9) = (/ &
        & 0.35590e-08_r8,0.38731e-08_r8,0.41923e-08_r8,0.44278e-08_r8,0.44950e-08_r8 /)
      kbo(:,46, 9) = (/ &
        & 0.26814e-08_r8,0.33691e-08_r8,0.34101e-08_r8,0.34324e-08_r8,0.35321e-08_r8 /)
      kbo(:,47, 9) = (/ &
        & 0.21424e-08_r8,0.21249e-08_r8,0.27532e-08_r8,0.28475e-08_r8,0.25748e-08_r8 /)
      kbo(:,48, 9) = (/ &
        & 0.16514e-08_r8,0.18931e-08_r8,0.22507e-08_r8,0.22575e-08_r8,0.21238e-08_r8 /)
      kbo(:,49, 9) = (/ &
        & 0.12235e-08_r8,0.12503e-08_r8,0.16643e-08_r8,0.16742e-08_r8,0.16438e-08_r8 /)
      kbo(:,50, 9) = (/ &
        & 0.11340e-08_r8,0.11248e-08_r8,0.13120e-08_r8,0.13854e-08_r8,0.13503e-08_r8 /)
      kbo(:,51, 9) = (/ &
        & 0.79176e-09_r8,0.91681e-09_r8,0.99908e-09_r8,0.13532e-08_r8,0.10405e-08_r8 /)
      kbo(:,52, 9) = (/ &
        & 0.64785e-09_r8,0.57185e-09_r8,0.84784e-09_r8,0.90912e-09_r8,0.87721e-09_r8 /)
      kbo(:,53, 9) = (/ &
        & 0.51330e-09_r8,0.43209e-09_r8,0.61659e-09_r8,0.79798e-09_r8,0.65017e-09_r8 /)
      kbo(:,54, 9) = (/ &
        & 0.40227e-09_r8,0.45562e-09_r8,0.54691e-09_r8,0.63160e-09_r8,0.62902e-09_r8 /)
      kbo(:,55, 9) = (/ &
        & 0.44280e-09_r8,0.43833e-09_r8,0.48132e-09_r8,0.55748e-09_r8,0.72672e-09_r8 /)
      kbo(:,56, 9) = (/ &
        & 0.33767e-09_r8,0.43448e-09_r8,0.42774e-09_r8,0.52401e-09_r8,0.66273e-09_r8 /)
      kbo(:,57, 9) = (/ &
        & 0.40113e-09_r8,0.38794e-09_r8,0.46286e-09_r8,0.57261e-09_r8,0.60773e-09_r8 /)
      kbo(:,58, 9) = (/ &
        & 0.36624e-09_r8,0.52965e-09_r8,0.49530e-09_r8,0.54114e-09_r8,0.65708e-09_r8 /)
      kbo(:,59, 9) = (/ &
        & 0.52598e-09_r8,0.55940e-09_r8,0.70094e-09_r8,0.71749e-09_r8,0.81086e-09_r8 /)
      kbo(:,13,10) = (/ &
        & 0.75197e-05_r8,0.74908e-05_r8,0.74768e-05_r8,0.74579e-05_r8,0.74485e-05_r8 /)
      kbo(:,14,10) = (/ &
        & 0.62427e-05_r8,0.62400e-05_r8,0.62314e-05_r8,0.62357e-05_r8,0.62230e-05_r8 /)
      kbo(:,15,10) = (/ &
        & 0.51235e-05_r8,0.51220e-05_r8,0.51270e-05_r8,0.51388e-05_r8,0.51377e-05_r8 /)
      kbo(:,16,10) = (/ &
        & 0.36653e-05_r8,0.36812e-05_r8,0.36844e-05_r8,0.36893e-05_r8,0.37175e-05_r8 /)
      kbo(:,17,10) = (/ &
        & 0.10067e-05_r8,0.10571e-05_r8,0.10948e-05_r8,0.11331e-05_r8,0.11791e-05_r8 /)
      kbo(:,18,10) = (/ &
        & 0.37963e-07_r8,0.35028e-07_r8,0.38085e-07_r8,0.36252e-07_r8,0.39741e-07_r8 /)
      kbo(:,19,10) = (/ &
        & 0.58861e-07_r8,0.39909e-07_r8,0.43872e-07_r8,0.52963e-07_r8,0.37762e-07_r8 /)
      kbo(:,20,10) = (/ &
        & 0.65438e-07_r8,0.43429e-07_r8,0.52709e-07_r8,0.35811e-07_r8,0.59833e-07_r8 /)
      kbo(:,21,10) = (/ &
        & 0.50452e-07_r8,0.50995e-07_r8,0.40371e-07_r8,0.51145e-07_r8,0.52725e-07_r8 /)
      kbo(:,22,10) = (/ &
        & 0.42139e-07_r8,0.45011e-07_r8,0.61867e-07_r8,0.41292e-07_r8,0.37916e-07_r8 /)
      kbo(:,23,10) = (/ &
        & 0.30176e-07_r8,0.29856e-07_r8,0.39637e-07_r8,0.38957e-07_r8,0.64896e-07_r8 /)
      kbo(:,24,10) = (/ &
        & 0.36010e-07_r8,0.42155e-07_r8,0.32787e-07_r8,0.46750e-07_r8,0.46940e-07_r8 /)
      kbo(:,25,10) = (/ &
        & 0.34802e-07_r8,0.41607e-07_r8,0.40854e-07_r8,0.61643e-07_r8,0.53762e-07_r8 /)
      kbo(:,26,10) = (/ &
        & 0.41295e-07_r8,0.39697e-07_r8,0.46005e-07_r8,0.46334e-07_r8,0.53334e-07_r8 /)
      kbo(:,27,10) = (/ &
        & 0.61711e-07_r8,0.29641e-07_r8,0.51823e-07_r8,0.42625e-07_r8,0.36336e-07_r8 /)
      kbo(:,28,10) = (/ &
        & 0.45196e-07_r8,0.56637e-07_r8,0.31716e-07_r8,0.38569e-07_r8,0.45693e-07_r8 /)
      kbo(:,29,10) = (/ &
        & 0.47349e-07_r8,0.38492e-07_r8,0.26330e-07_r8,0.30953e-07_r8,0.33330e-07_r8 /)
      kbo(:,30,10) = (/ &
        & 0.20700e-07_r8,0.24999e-07_r8,0.19626e-07_r8,0.33645e-07_r8,0.21883e-07_r8 /)
      kbo(:,31,10) = (/ &
        & 0.31879e-07_r8,0.26245e-07_r8,0.28697e-07_r8,0.26867e-07_r8,0.26801e-07_r8 /)
      kbo(:,32,10) = (/ &
        & 0.29616e-07_r8,0.18927e-07_r8,0.18903e-07_r8,0.14917e-07_r8,0.25602e-07_r8 /)
      kbo(:,33,10) = (/ &
        & 0.22437e-07_r8,0.26260e-07_r8,0.17262e-07_r8,0.13354e-07_r8,0.18413e-07_r8 /)
      kbo(:,34,10) = (/ &
        & 0.15957e-07_r8,0.11226e-07_r8,0.16852e-07_r8,0.11987e-07_r8,0.14358e-07_r8 /)
      kbo(:,35,10) = (/ &
        & 0.11233e-07_r8,0.90736e-08_r8,0.13960e-07_r8,0.76472e-08_r8,0.11733e-07_r8 /)
      kbo(:,36,10) = (/ &
        & 0.13919e-07_r8,0.10081e-07_r8,0.10035e-07_r8,0.10345e-07_r8,0.10622e-07_r8 /)
      kbo(:,37,10) = (/ &
        & 0.76780e-08_r8,0.12331e-07_r8,0.10794e-07_r8,0.16023e-07_r8,0.11524e-07_r8 /)
      kbo(:,38,10) = (/ &
        & 0.65416e-08_r8,0.97484e-08_r8,0.12132e-07_r8,0.10472e-07_r8,0.11363e-07_r8 /)
      kbo(:,39,10) = (/ &
        & 0.78511e-08_r8,0.70392e-08_r8,0.91444e-08_r8,0.84352e-08_r8,0.95946e-08_r8 /)
      kbo(:,40,10) = (/ &
        & 0.81878e-08_r8,0.94957e-08_r8,0.84996e-08_r8,0.11246e-07_r8,0.13024e-07_r8 /)
      kbo(:,41,10) = (/ &
        & 0.65901e-08_r8,0.80717e-08_r8,0.78357e-08_r8,0.67309e-08_r8,0.85966e-08_r8 /)
      kbo(:,42,10) = (/ &
        & 0.64210e-08_r8,0.59979e-08_r8,0.56936e-08_r8,0.70018e-08_r8,0.70433e-08_r8 /)
      kbo(:,43,10) = (/ &
        & 0.40388e-08_r8,0.71452e-08_r8,0.63548e-08_r8,0.84902e-08_r8,0.75828e-08_r8 /)
      kbo(:,44,10) = (/ &
        & 0.39142e-08_r8,0.55915e-08_r8,0.49863e-08_r8,0.52254e-08_r8,0.62790e-08_r8 /)
      kbo(:,45,10) = (/ &
        & 0.42931e-08_r8,0.31608e-08_r8,0.46572e-08_r8,0.47490e-08_r8,0.59912e-08_r8 /)
      kbo(:,46,10) = (/ &
        & 0.38722e-08_r8,0.16146e-08_r8,0.40010e-08_r8,0.24242e-08_r8,0.45711e-08_r8 /)
      kbo(:,47,10) = (/ &
        & 0.14942e-08_r8,0.28671e-08_r8,0.27168e-08_r8,0.40090e-08_r8,0.42343e-08_r8 /)
      kbo(:,48,10) = (/ &
        & 0.11911e-08_r8,0.13582e-08_r8,0.26580e-08_r8,0.29275e-08_r8,0.17855e-08_r8 /)
      kbo(:,49,10) = (/ &
        & 0.14130e-08_r8,0.10553e-08_r8,0.10543e-08_r8,0.11428e-08_r8,0.14141e-08_r8 /)
      kbo(:,50,10) = (/ &
        & 0.12182e-08_r8,0.14973e-08_r8,0.13182e-08_r8,0.84197e-09_r8,0.12115e-08_r8 /)
      kbo(:,51,10) = (/ &
        & 0.81227e-09_r8,0.90496e-09_r8,0.77903e-09_r8,0.83007e-09_r8,0.86051e-09_r8 /)
      kbo(:,52,10) = (/ &
        & 0.96715e-09_r8,0.52504e-09_r8,0.42702e-09_r8,0.99435e-09_r8,0.91829e-09_r8 /)
      kbo(:,53,10) = (/ &
        & 0.37232e-09_r8,0.22359e-09_r8,0.89279e-09_r8,0.85173e-09_r8,0.51790e-09_r8 /)
      kbo(:,54,10) = (/ &
        & 0.34402e-09_r8,0.40116e-09_r8,0.54696e-09_r8,0.50848e-09_r8,0.53123e-09_r8 /)
      kbo(:,55,10) = (/ &
        & 0.66100e-09_r8,0.65370e-09_r8,0.58427e-09_r8,0.74840e-09_r8,0.49778e-09_r8 /)
      kbo(:,56,10) = (/ &
        & 0.43138e-09_r8,0.39155e-09_r8,0.52944e-09_r8,0.58374e-09_r8,0.77481e-09_r8 /)
      kbo(:,57,10) = (/ &
        & 0.48190e-09_r8,0.37726e-09_r8,0.54783e-09_r8,0.43462e-09_r8,0.46295e-09_r8 /)
      kbo(:,58,10) = (/ &
        & 0.42276e-09_r8,0.62831e-09_r8,0.68493e-09_r8,0.49089e-09_r8,0.43799e-09_r8 /)
      kbo(:,59,10) = (/ &
        & 0.37023e-09_r8,0.90764e-09_r8,0.36527e-09_r8,0.99235e-09_r8,0.10719e-08_r8 /)
      kbo(:,13,11) = (/ &
        & 0.15119e-04_r8,0.15135e-04_r8,0.15140e-04_r8,0.15181e-04_r8,0.15209e-04_r8 /)
      kbo(:,14,11) = (/ &
        & 0.12807e-04_r8,0.12837e-04_r8,0.12873e-04_r8,0.12938e-04_r8,0.12999e-04_r8 /)
      kbo(:,15,11) = (/ &
        & 0.10789e-04_r8,0.10839e-04_r8,0.10921e-04_r8,0.10986e-04_r8,0.11078e-04_r8 /)
      kbo(:,16,11) = (/ &
        & 0.90472e-05_r8,0.91077e-05_r8,0.91930e-05_r8,0.92812e-05_r8,0.93959e-05_r8 /)
      kbo(:,17,11) = (/ &
        & 0.74085e-05_r8,0.75116e-05_r8,0.76103e-05_r8,0.77238e-05_r8,0.78364e-05_r8 /)
      kbo(:,18,11) = (/ &
        & 0.47863e-05_r8,0.49607e-05_r8,0.51634e-05_r8,0.53824e-05_r8,0.55724e-05_r8 /)
      kbo(:,19,11) = (/ &
        & 0.17849e-05_r8,0.19797e-05_r8,0.21641e-05_r8,0.23597e-05_r8,0.26015e-05_r8 /)
      kbo(:,20,11) = (/ &
        & 0.14011e-06_r8,0.26424e-06_r8,0.39902e-06_r8,0.56382e-06_r8,0.75666e-06_r8 /)
      kbo(:,21,11) = (/ &
        & 0.32681e-07_r8,0.30855e-07_r8,0.23688e-07_r8,0.28954e-07_r8,0.30262e-07_r8 /)
      kbo(:,22,11) = (/ &
        & 0.39000e-07_r8,0.34641e-07_r8,0.36220e-07_r8,0.29230e-07_r8,0.25365e-07_r8 /)
      kbo(:,23,11) = (/ &
        & 0.39936e-07_r8,0.40586e-07_r8,0.26460e-07_r8,0.13886e-07_r8,0.18108e-07_r8 /)
      kbo(:,24,11) = (/ &
        & 0.34546e-07_r8,0.30818e-07_r8,0.33243e-07_r8,0.31408e-07_r8,0.37755e-07_r8 /)
      kbo(:,25,11) = (/ &
        & 0.36078e-07_r8,0.45586e-07_r8,0.18117e-07_r8,0.20176e-07_r8,0.46256e-07_r8 /)
      kbo(:,26,11) = (/ &
        & 0.61382e-07_r8,0.31185e-07_r8,0.38578e-07_r8,0.18908e-07_r8,0.43919e-07_r8 /)
      kbo(:,27,11) = (/ &
        & 0.37585e-07_r8,0.28323e-07_r8,0.45638e-07_r8,0.34261e-07_r8,0.26227e-07_r8 /)
      kbo(:,28,11) = (/ &
        & 0.41226e-07_r8,0.24793e-07_r8,0.23296e-07_r8,0.20952e-07_r8,0.27899e-07_r8 /)
      kbo(:,29,11) = (/ &
        & 0.21318e-07_r8,0.23768e-07_r8,0.39220e-07_r8,0.28896e-07_r8,0.15703e-07_r8 /)
      kbo(:,30,11) = (/ &
        & 0.25522e-07_r8,0.29485e-07_r8,0.39326e-07_r8,0.29293e-07_r8,0.36529e-07_r8 /)
      kbo(:,31,11) = (/ &
        & 0.14494e-07_r8,0.25417e-07_r8,0.13732e-07_r8,0.97827e-08_r8,0.20014e-07_r8 /)
      kbo(:,32,11) = (/ &
        & 0.14101e-07_r8,0.26239e-07_r8,0.22312e-07_r8,0.10163e-07_r8,0.17547e-07_r8 /)
      kbo(:,33,11) = (/ &
        & 0.17347e-07_r8,0.17261e-07_r8,0.13014e-07_r8,0.21130e-07_r8,0.31576e-08_r8 /)
      kbo(:,34,11) = (/ &
        & 0.11923e-07_r8,0.13818e-07_r8,0.14692e-07_r8,0.14120e-07_r8,0.12000e-07_r8 /)
      kbo(:,35,11) = (/ &
        & 0.86917e-08_r8,0.10083e-07_r8,0.11872e-07_r8,0.58578e-08_r8,0.13194e-07_r8 /)
      kbo(:,36,11) = (/ &
        & 0.74538e-08_r8,0.94606e-08_r8,0.85633e-08_r8,0.15394e-07_r8,0.81997e-08_r8 /)
      kbo(:,37,11) = (/ &
        & 0.59982e-08_r8,0.58805e-08_r8,0.92255e-08_r8,0.69472e-08_r8,0.63632e-08_r8 /)
      kbo(:,38,11) = (/ &
        & 0.75481e-08_r8,0.82094e-08_r8,0.10405e-07_r8,0.62921e-08_r8,0.70021e-08_r8 /)
      kbo(:,39,11) = (/ &
        & 0.65770e-08_r8,0.73715e-08_r8,0.70899e-08_r8,0.49884e-08_r8,0.73567e-08_r8 /)
      kbo(:,40,11) = (/ &
        & 0.62200e-08_r8,0.79227e-08_r8,0.65710e-08_r8,0.35793e-08_r8,0.48653e-08_r8 /)
      kbo(:,41,11) = (/ &
        & 0.67810e-08_r8,0.64933e-08_r8,0.26651e-08_r8,0.71067e-08_r8,0.42136e-08_r8 /)
      kbo(:,42,11) = (/ &
        & 0.32351e-08_r8,0.79993e-08_r8,0.25727e-08_r8,0.70581e-08_r8,0.58932e-08_r8 /)
      kbo(:,43,11) = (/ &
        & 0.54331e-08_r8,0.21653e-08_r8,0.69372e-08_r8,0.30142e-08_r8,0.23071e-07_r8 /)
      kbo(:,44,11) = (/ &
        & 0.26834e-08_r8,0.43047e-08_r8,0.44246e-08_r8,0.29474e-08_r8,0.52315e-07_r8 /)
      kbo(:,45,11) = (/ &
        & 0.22521e-08_r8,0.21920e-08_r8,0.35952e-08_r8,0.29799e-08_r8,0.81164e-07_r8 /)
      kbo(:,46,11) = (/ &
        & 0.28580e-08_r8,0.12605e-08_r8,0.64390e-09_r8,0.24255e-07_r8,0.96879e-07_r8 /)
      kbo(:,47,11) = (/ &
        & 0.13005e-08_r8,0.17967e-08_r8,0.21618e-08_r8,0.30225e-07_r8,0.10319e-06_r8 /)
      kbo(:,48,11) = (/ &
        & 0.13676e-08_r8,0.96043e-09_r8,0.14275e-08_r8,0.39735e-07_r8,0.11261e-06_r8 /)
      kbo(:,49,11) = (/ &
        & 0.79619e-09_r8,0.85338e-09_r8,0.14300e-08_r8,0.51821e-07_r8,0.12169e-06_r8 /)
      kbo(:,50,11) = (/ &
        & 0.49284e-09_r8,0.21801e-09_r8,0.75017e-08_r8,0.50308e-07_r8,0.11953e-06_r8 /)
      kbo(:,51,11) = (/ &
        & 0.51956e-09_r8,0.59927e-09_r8,0.87276e-08_r8,0.45028e-07_r8,0.11141e-06_r8 /)
      kbo(:,52,11) = (/ &
        & 0.35814e-09_r8,0.78982e-09_r8,0.10205e-07_r8,0.45574e-07_r8,0.10332e-06_r8 /)
      kbo(:,53,11) = (/ &
        & 0.69729e-09_r8,0.23757e-09_r8,0.11741e-07_r8,0.45086e-07_r8,0.98023e-07_r8 /)
      kbo(:,54,11) = (/ &
        & 0.38203e-09_r8,0.28792e-09_r8,0.72239e-08_r8,0.35770e-07_r8,0.80771e-07_r8 /)
      kbo(:,55,11) = (/ &
        & 0.33870e-09_r8,0.39698e-09_r8,0.15883e-08_r8,0.22568e-07_r8,0.61465e-07_r8 /)
      kbo(:,56,11) = (/ &
        & 0.50424e-09_r8,0.25383e-09_r8,0.46226e-09_r8,0.12214e-07_r8,0.43776e-07_r8 /)
      kbo(:,57,11) = (/ &
        & 0.18824e-09_r8,0.14340e-09_r8,0.96547e-10_r8,0.36771e-08_r8,0.28437e-07_r8 /)
      kbo(:,58,11) = (/ &
        & 0.53960e-09_r8,0.71198e-09_r8,0.40290e-09_r8,0.38600e-09_r8,0.14449e-07_r8 /)
      kbo(:,59,11) = (/ &
        & 0.64570e-09_r8,0.80856e-09_r8,0.54439e-09_r8,0.66021e-09_r8,0.28306e-09_r8 /)
      kbo(:,13,12) = (/ &
        & 0.35137e-04_r8,0.35315e-04_r8,0.35473e-04_r8,0.35691e-04_r8,0.35953e-04_r8 /)
      kbo(:,14,12) = (/ &
        & 0.30387e-04_r8,0.30535e-04_r8,0.30693e-04_r8,0.30906e-04_r8,0.31121e-04_r8 /)
      kbo(:,15,12) = (/ &
        & 0.26404e-04_r8,0.26560e-04_r8,0.26776e-04_r8,0.26963e-04_r8,0.27157e-04_r8 /)
      kbo(:,16,12) = (/ &
        & 0.22908e-04_r8,0.23161e-04_r8,0.23420e-04_r8,0.23636e-04_r8,0.23864e-04_r8 /)
      kbo(:,17,12) = (/ &
        & 0.19849e-04_r8,0.20170e-04_r8,0.20453e-04_r8,0.20723e-04_r8,0.21011e-04_r8 /)
      kbo(:,18,12) = (/ &
        & 0.17158e-04_r8,0.17516e-04_r8,0.17820e-04_r8,0.18149e-04_r8,0.18467e-04_r8 /)
      kbo(:,19,12) = (/ &
        & 0.14706e-04_r8,0.15074e-04_r8,0.15426e-04_r8,0.15809e-04_r8,0.16128e-04_r8 /)
      kbo(:,20,12) = (/ &
        & 0.12200e-04_r8,0.12654e-04_r8,0.13122e-04_r8,0.13561e-04_r8,0.13942e-04_r8 /)
      kbo(:,21,12) = (/ &
        & 0.88744e-05_r8,0.95294e-05_r8,0.10194e-04_r8,0.10811e-04_r8,0.11447e-04_r8 /)
      kbo(:,22,12) = (/ &
        & 0.63063e-05_r8,0.69160e-05_r8,0.75170e-05_r8,0.81696e-05_r8,0.87829e-05_r8 /)
      kbo(:,23,12) = (/ &
        & 0.42549e-05_r8,0.48576e-05_r8,0.54224e-05_r8,0.60649e-05_r8,0.65852e-05_r8 /)
      kbo(:,24,12) = (/ &
        & 0.26155e-05_r8,0.31537e-05_r8,0.36816e-05_r8,0.42795e-05_r8,0.47356e-05_r8 /)
      kbo(:,25,12) = (/ &
        & 0.14576e-05_r8,0.18762e-05_r8,0.23875e-05_r8,0.29308e-05_r8,0.33846e-05_r8 /)
      kbo(:,26,12) = (/ &
        & 0.67369e-06_r8,0.10096e-05_r8,0.14730e-05_r8,0.19592e-05_r8,0.24356e-05_r8 /)
      kbo(:,27,12) = (/ &
        & 0.27240e-06_r8,0.59733e-06_r8,0.98553e-06_r8,0.13968e-05_r8,0.18466e-05_r8 /)
      kbo(:,28,12) = (/ &
        & 0.81179e-07_r8,0.35063e-06_r8,0.74692e-06_r8,0.11081e-05_r8,0.15613e-05_r8 /)
      kbo(:,29,12) = (/ &
        & 0.94800e-07_r8,0.40513e-06_r8,0.73547e-06_r8,0.10914e-05_r8,0.16188e-05_r8 /)
      kbo(:,30,12) = (/ &
        & 0.19045e-06_r8,0.51192e-06_r8,0.80594e-06_r8,0.12694e-05_r8,0.16954e-05_r8 /)
      kbo(:,31,12) = (/ &
        & 0.38493e-06_r8,0.71230e-06_r8,0.11392e-05_r8,0.15875e-05_r8,0.20565e-05_r8 /)
      kbo(:,32,12) = (/ &
        & 0.61444e-06_r8,0.97779e-06_r8,0.14257e-05_r8,0.18883e-05_r8,0.26649e-05_r8 /)
      kbo(:,33,12) = (/ &
        & 0.84230e-06_r8,0.12390e-05_r8,0.17304e-05_r8,0.23322e-05_r8,0.32859e-05_r8 /)
      kbo(:,34,12) = (/ &
        & 0.10458e-05_r8,0.14709e-05_r8,0.19634e-05_r8,0.28004e-05_r8,0.37724e-05_r8 /)
      kbo(:,35,12) = (/ &
        & 0.11901e-05_r8,0.16306e-05_r8,0.22411e-05_r8,0.31089e-05_r8,0.41007e-05_r8 /)
      kbo(:,36,12) = (/ &
        & 0.12859e-05_r8,0.17604e-05_r8,0.24414e-05_r8,0.32964e-05_r8,0.43267e-05_r8 /)
      kbo(:,37,12) = (/ &
        & 0.13015e-05_r8,0.17577e-05_r8,0.24562e-05_r8,0.33117e-05_r8,0.43238e-05_r8 /)
      kbo(:,38,12) = (/ &
        & 0.13522e-05_r8,0.18247e-05_r8,0.25116e-05_r8,0.33483e-05_r8,0.43352e-05_r8 /)
      kbo(:,39,12) = (/ &
        & 0.14322e-05_r8,0.19336e-05_r8,0.26107e-05_r8,0.34258e-05_r8,0.44158e-05_r8 /)
      kbo(:,40,12) = (/ &
        & 0.14006e-05_r8,0.18728e-05_r8,0.25304e-05_r8,0.33179e-05_r8,0.42738e-05_r8 /)
      kbo(:,41,12) = (/ &
        & 0.13551e-05_r8,0.18012e-05_r8,0.24357e-05_r8,0.32084e-05_r8,0.41141e-05_r8 /)
      kbo(:,42,12) = (/ &
        & 0.13297e-05_r8,0.17512e-05_r8,0.23561e-05_r8,0.30946e-05_r8,0.39665e-05_r8 /)
      kbo(:,43,12) = (/ &
        & 0.12687e-05_r8,0.16768e-05_r8,0.22464e-05_r8,0.29540e-05_r8,0.37527e-05_r8 /)
      kbo(:,44,12) = (/ &
        & 0.12099e-05_r8,0.15968e-05_r8,0.21385e-05_r8,0.28006e-05_r8,0.35240e-05_r8 /)
      kbo(:,45,12) = (/ &
        & 0.11534e-05_r8,0.15243e-05_r8,0.20279e-05_r8,0.26581e-05_r8,0.33062e-05_r8 /)
      kbo(:,46,12) = (/ &
        & 0.10898e-05_r8,0.14434e-05_r8,0.19097e-05_r8,0.24739e-05_r8,0.30807e-05_r8 /)
      kbo(:,47,12) = (/ &
        & 0.10111e-05_r8,0.13412e-05_r8,0.17607e-05_r8,0.22724e-05_r8,0.28391e-05_r8 /)
      kbo(:,48,12) = (/ &
        & 0.92540e-06_r8,0.12447e-05_r8,0.16295e-05_r8,0.20863e-05_r8,0.26097e-05_r8 /)
      kbo(:,49,12) = (/ &
        & 0.84684e-06_r8,0.11506e-05_r8,0.15141e-05_r8,0.19160e-05_r8,0.23957e-05_r8 /)
      kbo(:,50,12) = (/ &
        & 0.76391e-06_r8,0.10519e-05_r8,0.13910e-05_r8,0.17635e-05_r8,0.22060e-05_r8 /)
      kbo(:,51,12) = (/ &
        & 0.68139e-06_r8,0.95640e-06_r8,0.12771e-05_r8,0.16252e-05_r8,0.20363e-05_r8 /)
      kbo(:,52,12) = (/ &
        & 0.60392e-06_r8,0.86706e-06_r8,0.11671e-05_r8,0.14940e-05_r8,0.18793e-05_r8 /)
      kbo(:,53,12) = (/ &
        & 0.53856e-06_r8,0.78259e-06_r8,0.10620e-05_r8,0.13737e-05_r8,0.17330e-05_r8 /)
      kbo(:,54,12) = (/ &
        & 0.46919e-06_r8,0.69589e-06_r8,0.96582e-06_r8,0.12666e-05_r8,0.16070e-05_r8 /)
      kbo(:,55,12) = (/ &
        & 0.40013e-06_r8,0.61215e-06_r8,0.87450e-06_r8,0.11663e-05_r8,0.14929e-05_r8 /)
      kbo(:,56,12) = (/ &
        & 0.33987e-06_r8,0.53286e-06_r8,0.78520e-06_r8,0.10697e-05_r8,0.13857e-05_r8 /)
      kbo(:,57,12) = (/ &
        & 0.28415e-06_r8,0.45936e-06_r8,0.69784e-06_r8,0.97544e-06_r8,0.12829e-05_r8 /)
      kbo(:,58,12) = (/ &
        & 0.23457e-06_r8,0.39019e-06_r8,0.61528e-06_r8,0.88439e-06_r8,0.11866e-05_r8 /)
      kbo(:,59,12) = (/ &
        & 0.19576e-06_r8,0.34385e-06_r8,0.56055e-06_r8,0.82347e-06_r8,0.11274e-05_r8 /)
      kbo(:,13,13) = (/ &
        & 0.12143e-03_r8,0.12308e-03_r8,0.12512e-03_r8,0.12699e-03_r8,0.12910e-03_r8 /)
      kbo(:,14,13) = (/ &
        & 0.10385e-03_r8,0.10569e-03_r8,0.10770e-03_r8,0.10972e-03_r8,0.11214e-03_r8 /)
      kbo(:,15,13) = (/ &
        & 0.88944e-04_r8,0.90837e-04_r8,0.92688e-04_r8,0.94910e-04_r8,0.97472e-04_r8 /)
      kbo(:,16,13) = (/ &
        & 0.76542e-04_r8,0.78268e-04_r8,0.80179e-04_r8,0.82469e-04_r8,0.84734e-04_r8 /)
      kbo(:,17,13) = (/ &
        & 0.66332e-04_r8,0.67885e-04_r8,0.69742e-04_r8,0.71831e-04_r8,0.74034e-04_r8 /)
      kbo(:,18,13) = (/ &
        & 0.57811e-04_r8,0.59251e-04_r8,0.61096e-04_r8,0.62954e-04_r8,0.65175e-04_r8 /)
      kbo(:,19,13) = (/ &
        & 0.50669e-04_r8,0.52124e-04_r8,0.53790e-04_r8,0.55608e-04_r8,0.57861e-04_r8 /)
      kbo(:,20,13) = (/ &
        & 0.44810e-04_r8,0.46258e-04_r8,0.47774e-04_r8,0.49573e-04_r8,0.51715e-04_r8 /)
      kbo(:,21,13) = (/ &
        & 0.40009e-04_r8,0.41361e-04_r8,0.42755e-04_r8,0.44560e-04_r8,0.46559e-04_r8 /)
      kbo(:,22,13) = (/ &
        & 0.36116e-04_r8,0.37297e-04_r8,0.38718e-04_r8,0.40472e-04_r8,0.42441e-04_r8 /)
      kbo(:,23,13) = (/ &
        & 0.32736e-04_r8,0.33861e-04_r8,0.35361e-04_r8,0.37075e-04_r8,0.39134e-04_r8 /)
      kbo(:,24,13) = (/ &
        & 0.29883e-04_r8,0.31056e-04_r8,0.32552e-04_r8,0.34296e-04_r8,0.36499e-04_r8 /)
      kbo(:,25,13) = (/ &
        & 0.27373e-04_r8,0.28693e-04_r8,0.30179e-04_r8,0.32033e-04_r8,0.34358e-04_r8 /)
      kbo(:,26,13) = (/ &
        & 0.25273e-04_r8,0.26749e-04_r8,0.28306e-04_r8,0.30341e-04_r8,0.32793e-04_r8 /)
      kbo(:,27,13) = (/ &
        & 0.23652e-04_r8,0.25175e-04_r8,0.26905e-04_r8,0.29145e-04_r8,0.31814e-04_r8 /)
      kbo(:,28,13) = (/ &
        & 0.22453e-04_r8,0.24077e-04_r8,0.26031e-04_r8,0.28419e-04_r8,0.31259e-04_r8 /)
      kbo(:,29,13) = (/ &
        & 0.21794e-04_r8,0.23553e-04_r8,0.25672e-04_r8,0.28266e-04_r8,0.31243e-04_r8 /)
      kbo(:,30,13) = (/ &
        & 0.21501e-04_r8,0.23414e-04_r8,0.25687e-04_r8,0.28389e-04_r8,0.31547e-04_r8 /)
      kbo(:,31,13) = (/ &
        & 0.21532e-04_r8,0.23577e-04_r8,0.25947e-04_r8,0.28793e-04_r8,0.32070e-04_r8 /)
      kbo(:,32,13) = (/ &
        & 0.21702e-04_r8,0.23850e-04_r8,0.26365e-04_r8,0.29337e-04_r8,0.32730e-04_r8 /)
      kbo(:,33,13) = (/ &
        & 0.21999e-04_r8,0.24243e-04_r8,0.26895e-04_r8,0.29970e-04_r8,0.33492e-04_r8 /)
      kbo(:,34,13) = (/ &
        & 0.22272e-04_r8,0.24615e-04_r8,0.27365e-04_r8,0.30535e-04_r8,0.34149e-04_r8 /)
      kbo(:,35,13) = (/ &
        & 0.22408e-04_r8,0.24786e-04_r8,0.27609e-04_r8,0.30838e-04_r8,0.34518e-04_r8 /)
      kbo(:,36,13) = (/ &
        & 0.22324e-04_r8,0.24717e-04_r8,0.27535e-04_r8,0.30781e-04_r8,0.34466e-04_r8 /)
      kbo(:,37,13) = (/ &
        & 0.21914e-04_r8,0.24278e-04_r8,0.27037e-04_r8,0.30223e-04_r8,0.33847e-04_r8 /)
      kbo(:,38,13) = (/ &
        & 0.21518e-04_r8,0.23846e-04_r8,0.26529e-04_r8,0.29664e-04_r8,0.33219e-04_r8 /)
      kbo(:,39,13) = (/ &
        & 0.21138e-04_r8,0.23443e-04_r8,0.26064e-04_r8,0.29132e-04_r8,0.32628e-04_r8 /)
      kbo(:,40,13) = (/ &
        & 0.20535e-04_r8,0.22813e-04_r8,0.25328e-04_r8,0.28289e-04_r8,0.31682e-04_r8 /)
      kbo(:,41,13) = (/ &
        & 0.19918e-04_r8,0.22174e-04_r8,0.24598e-04_r8,0.27447e-04_r8,0.30722e-04_r8 /)
      kbo(:,42,13) = (/ &
        & 0.19309e-04_r8,0.21550e-04_r8,0.23909e-04_r8,0.26639e-04_r8,0.29801e-04_r8 /)
      kbo(:,43,13) = (/ &
        & 0.18566e-04_r8,0.20812e-04_r8,0.23112e-04_r8,0.25700e-04_r8,0.28732e-04_r8 /)
      kbo(:,44,13) = (/ &
        & 0.17767e-04_r8,0.20035e-04_r8,0.22299e-04_r8,0.24756e-04_r8,0.27639e-04_r8 /)
      kbo(:,45,13) = (/ &
        & 0.16962e-04_r8,0.19260e-04_r8,0.21500e-04_r8,0.23864e-04_r8,0.26597e-04_r8 /)
      kbo(:,46,13) = (/ &
        & 0.16086e-04_r8,0.18421e-04_r8,0.20671e-04_r8,0.22972e-04_r8,0.25545e-04_r8 /)
      kbo(:,47,13) = (/ &
        & 0.15115e-04_r8,0.17481e-04_r8,0.19766e-04_r8,0.22019e-04_r8,0.24442e-04_r8 /)
      kbo(:,48,13) = (/ &
        & 0.14158e-04_r8,0.16526e-04_r8,0.18843e-04_r8,0.21088e-04_r8,0.23419e-04_r8 /)
      kbo(:,49,13) = (/ &
        & 0.13195e-04_r8,0.15552e-04_r8,0.17911e-04_r8,0.20179e-04_r8,0.22454e-04_r8 /)
      kbo(:,50,13) = (/ &
        & 0.12314e-04_r8,0.14653e-04_r8,0.17032e-04_r8,0.19326e-04_r8,0.21576e-04_r8 /)
      kbo(:,51,13) = (/ &
        & 0.11480e-04_r8,0.13788e-04_r8,0.16154e-04_r8,0.18484e-04_r8,0.20739e-04_r8 /)
      kbo(:,52,13) = (/ &
        & 0.10629e-04_r8,0.12922e-04_r8,0.15279e-04_r8,0.17642e-04_r8,0.19921e-04_r8 /)
      kbo(:,53,13) = (/ &
        & 0.97710e-05_r8,0.12082e-04_r8,0.14410e-04_r8,0.16788e-04_r8,0.19091e-04_r8 /)
      kbo(:,54,13) = (/ &
        & 0.90074e-05_r8,0.11316e-04_r8,0.13617e-04_r8,0.15981e-04_r8,0.18321e-04_r8 /)
      kbo(:,55,13) = (/ &
        & 0.83042e-05_r8,0.10569e-04_r8,0.12859e-04_r8,0.15214e-04_r8,0.17581e-04_r8 /)
      kbo(:,56,13) = (/ &
        & 0.76202e-05_r8,0.98296e-05_r8,0.12125e-04_r8,0.14457e-04_r8,0.16835e-04_r8 /)
      kbo(:,57,13) = (/ &
        & 0.69561e-05_r8,0.91024e-05_r8,0.11398e-04_r8,0.13700e-04_r8,0.16068e-04_r8 /)
      kbo(:,58,13) = (/ &
        & 0.63426e-05_r8,0.84347e-05_r8,0.10695e-04_r8,0.12984e-04_r8,0.15340e-04_r8 /)
      kbo(:,59,13) = (/ &
        & 0.61056e-05_r8,0.81719e-05_r8,0.10410e-04_r8,0.12698e-04_r8,0.15054e-04_r8 /)
      kbo(:,13,14) = (/ &
        & 0.69692e-03_r8,0.71516e-03_r8,0.73378e-03_r8,0.75443e-03_r8,0.77716e-03_r8 /)
      kbo(:,14,14) = (/ &
        & 0.64436e-03_r8,0.66211e-03_r8,0.68199e-03_r8,0.70460e-03_r8,0.72891e-03_r8 /)
      kbo(:,15,14) = (/ &
        & 0.59775e-03_r8,0.61618e-03_r8,0.63785e-03_r8,0.66198e-03_r8,0.68803e-03_r8 /)
      kbo(:,16,14) = (/ &
        & 0.55668e-03_r8,0.57752e-03_r8,0.60052e-03_r8,0.62615e-03_r8,0.65391e-03_r8 /)
      kbo(:,17,14) = (/ &
        & 0.52104e-03_r8,0.54458e-03_r8,0.56934e-03_r8,0.59627e-03_r8,0.62539e-03_r8 /)
      kbo(:,18,14) = (/ &
        & 0.49086e-03_r8,0.51685e-03_r8,0.54337e-03_r8,0.57147e-03_r8,0.60182e-03_r8 /)
      kbo(:,19,14) = (/ &
        & 0.46544e-03_r8,0.49373e-03_r8,0.52192e-03_r8,0.55124e-03_r8,0.58277e-03_r8 /)
      kbo(:,20,14) = (/ &
        & 0.44496e-03_r8,0.47526e-03_r8,0.50494e-03_r8,0.53564e-03_r8,0.56857e-03_r8 /)
      kbo(:,21,14) = (/ &
        & 0.42855e-03_r8,0.46070e-03_r8,0.49202e-03_r8,0.52375e-03_r8,0.55795e-03_r8 /)
      kbo(:,22,14) = (/ &
        & 0.41783e-03_r8,0.45160e-03_r8,0.48421e-03_r8,0.51739e-03_r8,0.55269e-03_r8 /)
      kbo(:,23,14) = (/ &
        & 0.41085e-03_r8,0.44564e-03_r8,0.47947e-03_r8,0.51389e-03_r8,0.55016e-03_r8 /)
      kbo(:,24,14) = (/ &
        & 0.40699e-03_r8,0.44263e-03_r8,0.47766e-03_r8,0.51290e-03_r8,0.55008e-03_r8 /)
      kbo(:,25,14) = (/ &
        & 0.40592e-03_r8,0.44215e-03_r8,0.47812e-03_r8,0.51419e-03_r8,0.55216e-03_r8 /)
      kbo(:,26,14) = (/ &
        & 0.40741e-03_r8,0.44425e-03_r8,0.48085e-03_r8,0.51770e-03_r8,0.55654e-03_r8 /)
      kbo(:,27,14) = (/ &
        & 0.41074e-03_r8,0.44811e-03_r8,0.48506e-03_r8,0.52264e-03_r8,0.56211e-03_r8 /)
      kbo(:,28,14) = (/ &
        & 0.41538e-03_r8,0.45333e-03_r8,0.49042e-03_r8,0.52868e-03_r8,0.56877e-03_r8 /)
      kbo(:,29,14) = (/ &
        & 0.42139e-03_r8,0.45956e-03_r8,0.49700e-03_r8,0.53588e-03_r8,0.57647e-03_r8 /)
      kbo(:,30,14) = (/ &
        & 0.42836e-03_r8,0.46659e-03_r8,0.50435e-03_r8,0.54377e-03_r8,0.58489e-03_r8 /)
      kbo(:,31,14) = (/ &
        & 0.43618e-03_r8,0.47431e-03_r8,0.51248e-03_r8,0.55256e-03_r8,0.59401e-03_r8 /)
      kbo(:,32,14) = (/ &
        & 0.44466e-03_r8,0.48256e-03_r8,0.52138e-03_r8,0.56187e-03_r8,0.60364e-03_r8 /)
      kbo(:,33,14) = (/ &
        & 0.45349e-03_r8,0.49137e-03_r8,0.53076e-03_r8,0.57166e-03_r8,0.61359e-03_r8 /)
      kbo(:,34,14) = (/ &
        & 0.46108e-03_r8,0.49922e-03_r8,0.53902e-03_r8,0.58028e-03_r8,0.62237e-03_r8 /)
      kbo(:,35,14) = (/ &
        & 0.46528e-03_r8,0.50354e-03_r8,0.54368e-03_r8,0.58501e-03_r8,0.62724e-03_r8 /)
      kbo(:,36,14) = (/ &
        & 0.46539e-03_r8,0.50375e-03_r8,0.54391e-03_r8,0.58538e-03_r8,0.62763e-03_r8 /)
      kbo(:,37,14) = (/ &
        & 0.45984e-03_r8,0.49817e-03_r8,0.53806e-03_r8,0.57948e-03_r8,0.62153e-03_r8 /)
      kbo(:,38,14) = (/ &
        & 0.45408e-03_r8,0.49229e-03_r8,0.53205e-03_r8,0.57322e-03_r8,0.61533e-03_r8 /)
      kbo(:,39,14) = (/ &
        & 0.44837e-03_r8,0.48652e-03_r8,0.52604e-03_r8,0.56712e-03_r8,0.60916e-03_r8 /)
      kbo(:,40,14) = (/ &
        & 0.43865e-03_r8,0.47705e-03_r8,0.51607e-03_r8,0.55678e-03_r8,0.59870e-03_r8 /)
      kbo(:,41,14) = (/ &
        & 0.42850e-03_r8,0.46708e-03_r8,0.50578e-03_r8,0.54611e-03_r8,0.58790e-03_r8 /)
      kbo(:,42,14) = (/ &
        & 0.41832e-03_r8,0.45718e-03_r8,0.49552e-03_r8,0.53551e-03_r8,0.57688e-03_r8 /)
      kbo(:,43,14) = (/ &
        & 0.40611e-03_r8,0.44501e-03_r8,0.48328e-03_r8,0.52271e-03_r8,0.56375e-03_r8 /)
      kbo(:,44,14) = (/ &
        & 0.39281e-03_r8,0.43169e-03_r8,0.47025e-03_r8,0.50904e-03_r8,0.54960e-03_r8 /)
      kbo(:,45,14) = (/ &
        & 0.37939e-03_r8,0.41841e-03_r8,0.45722e-03_r8,0.49565e-03_r8,0.53564e-03_r8 /)
      kbo(:,46,14) = (/ &
        & 0.36481e-03_r8,0.40443e-03_r8,0.44334e-03_r8,0.48171e-03_r8,0.52104e-03_r8 /)
      kbo(:,47,14) = (/ &
        & 0.34813e-03_r8,0.38867e-03_r8,0.42754e-03_r8,0.46626e-03_r8,0.50489e-03_r8 /)
      kbo(:,48,14) = (/ &
        & 0.33101e-03_r8,0.37257e-03_r8,0.41188e-03_r8,0.45078e-03_r8,0.48906e-03_r8 /)
      kbo(:,49,14) = (/ &
        & 0.31369e-03_r8,0.35613e-03_r8,0.39621e-03_r8,0.43508e-03_r8,0.47354e-03_r8 /)
      kbo(:,50,14) = (/ &
        & 0.29739e-03_r8,0.34030e-03_r8,0.38132e-03_r8,0.42035e-03_r8,0.45918e-03_r8 /)
      kbo(:,51,14) = (/ &
        & 0.28140e-03_r8,0.32461e-03_r8,0.36662e-03_r8,0.40619e-03_r8,0.44511e-03_r8 /)
      kbo(:,52,14) = (/ &
        & 0.26563e-03_r8,0.30898e-03_r8,0.35161e-03_r8,0.39193e-03_r8,0.43080e-03_r8 /)
      kbo(:,53,14) = (/ &
        & 0.24997e-03_r8,0.29311e-03_r8,0.33618e-03_r8,0.37741e-03_r8,0.41655e-03_r8 /)
      kbo(:,54,14) = (/ &
        & 0.23534e-03_r8,0.27846e-03_r8,0.32175e-03_r8,0.36391e-03_r8,0.40359e-03_r8 /)
      kbo(:,55,14) = (/ &
        & 0.22140e-03_r8,0.26468e-03_r8,0.30799e-03_r8,0.35062e-03_r8,0.39107e-03_r8 /)
      kbo(:,56,14) = (/ &
        & 0.20748e-03_r8,0.25097e-03_r8,0.29409e-03_r8,0.33714e-03_r8,0.37835e-03_r8 /)
      kbo(:,57,14) = (/ &
        & 0.19363e-03_r8,0.23702e-03_r8,0.28013e-03_r8,0.32339e-03_r8,0.36545e-03_r8 /)
      kbo(:,58,14) = (/ &
        & 0.18066e-03_r8,0.22379e-03_r8,0.26710e-03_r8,0.31040e-03_r8,0.35295e-03_r8 /)
      kbo(:,59,14) = (/ &
        & 0.17550e-03_r8,0.21855e-03_r8,0.26188e-03_r8,0.30515e-03_r8,0.34793e-03_r8 /)
      kbo(:,13,15) = (/ &
        & 0.67077e-02_r8,0.67643e-02_r8,0.68102e-02_r8,0.68432e-02_r8,0.68617e-02_r8 /)
      kbo(:,14,15) = (/ &
        & 0.68112e-02_r8,0.68842e-02_r8,0.69413e-02_r8,0.69806e-02_r8,0.70063e-02_r8 /)
      kbo(:,15,15) = (/ &
        & 0.68961e-02_r8,0.69833e-02_r8,0.70488e-02_r8,0.70965e-02_r8,0.71269e-02_r8 /)
      kbo(:,16,15) = (/ &
        & 0.69706e-02_r8,0.70648e-02_r8,0.71387e-02_r8,0.71925e-02_r8,0.72279e-02_r8 /)
      kbo(:,17,15) = (/ &
        & 0.70342e-02_r8,0.71339e-02_r8,0.72130e-02_r8,0.72737e-02_r8,0.73138e-02_r8 /)
      kbo(:,18,15) = (/ &
        & 0.70890e-02_r8,0.71933e-02_r8,0.72776e-02_r8,0.73426e-02_r8,0.73856e-02_r8 /)
      kbo(:,19,15) = (/ &
        & 0.71380e-02_r8,0.72441e-02_r8,0.73326e-02_r8,0.74006e-02_r8,0.74464e-02_r8 /)
      kbo(:,20,15) = (/ &
        & 0.71838e-02_r8,0.72907e-02_r8,0.73816e-02_r8,0.74514e-02_r8,0.74969e-02_r8 /)
      kbo(:,21,15) = (/ &
        & 0.72239e-02_r8,0.73326e-02_r8,0.74235e-02_r8,0.74941e-02_r8,0.75405e-02_r8 /)
      kbo(:,22,15) = (/ &
        & 0.72699e-02_r8,0.73767e-02_r8,0.74650e-02_r8,0.75340e-02_r8,0.75785e-02_r8 /)
      kbo(:,23,15) = (/ &
        & 0.73111e-02_r8,0.74172e-02_r8,0.75033e-02_r8,0.75687e-02_r8,0.76113e-02_r8 /)
      kbo(:,24,15) = (/ &
        & 0.73510e-02_r8,0.74537e-02_r8,0.75371e-02_r8,0.76008e-02_r8,0.76395e-02_r8 /)
      kbo(:,25,15) = (/ &
        & 0.73875e-02_r8,0.74885e-02_r8,0.75684e-02_r8,0.76282e-02_r8,0.76634e-02_r8 /)
      kbo(:,26,15) = (/ &
        & 0.74256e-02_r8,0.75226e-02_r8,0.75985e-02_r8,0.76530e-02_r8,0.76835e-02_r8 /)
      kbo(:,27,15) = (/ &
        & 0.74605e-02_r8,0.75517e-02_r8,0.76248e-02_r8,0.76742e-02_r8,0.77008e-02_r8 /)
      kbo(:,28,15) = (/ &
        & 0.74927e-02_r8,0.75800e-02_r8,0.76483e-02_r8,0.76927e-02_r8,0.77139e-02_r8 /)
      kbo(:,29,15) = (/ &
        & 0.75244e-02_r8,0.76057e-02_r8,0.76690e-02_r8,0.77086e-02_r8,0.77249e-02_r8 /)
      kbo(:,30,15) = (/ &
        & 0.75518e-02_r8,0.76303e-02_r8,0.76877e-02_r8,0.77209e-02_r8,0.77334e-02_r8 /)
      kbo(:,31,15) = (/ &
        & 0.75781e-02_r8,0.76519e-02_r8,0.77036e-02_r8,0.77320e-02_r8,0.77395e-02_r8 /)
      kbo(:,32,15) = (/ &
        & 0.76025e-02_r8,0.76727e-02_r8,0.77178e-02_r8,0.77409e-02_r8,0.77439e-02_r8 /)
      kbo(:,33,15) = (/ &
        & 0.76266e-02_r8,0.76908e-02_r8,0.77289e-02_r8,0.77461e-02_r8,0.77464e-02_r8 /)
      kbo(:,34,15) = (/ &
        & 0.76450e-02_r8,0.77038e-02_r8,0.77387e-02_r8,0.77507e-02_r8,0.77465e-02_r8 /)
      kbo(:,35,15) = (/ &
        & 0.76558e-02_r8,0.77117e-02_r8,0.77433e-02_r8,0.77536e-02_r8,0.77475e-02_r8 /)
      kbo(:,36,15) = (/ &
        & 0.76587e-02_r8,0.77150e-02_r8,0.77452e-02_r8,0.77564e-02_r8,0.77495e-02_r8 /)
      kbo(:,37,15) = (/ &
        & 0.76522e-02_r8,0.77109e-02_r8,0.77439e-02_r8,0.77579e-02_r8,0.77534e-02_r8 /)
      kbo(:,38,15) = (/ &
        & 0.76429e-02_r8,0.77056e-02_r8,0.77426e-02_r8,0.77582e-02_r8,0.77560e-02_r8 /)
      kbo(:,39,15) = (/ &
        & 0.76339e-02_r8,0.76993e-02_r8,0.77402e-02_r8,0.77587e-02_r8,0.77588e-02_r8 /)
      kbo(:,40,15) = (/ &
        & 0.76166e-02_r8,0.76865e-02_r8,0.77335e-02_r8,0.77564e-02_r8,0.77613e-02_r8 /)
      kbo(:,41,15) = (/ &
        & 0.75961e-02_r8,0.76706e-02_r8,0.77239e-02_r8,0.77534e-02_r8,0.77621e-02_r8 /)
      kbo(:,42,15) = (/ &
        & 0.75752e-02_r8,0.76537e-02_r8,0.77143e-02_r8,0.77487e-02_r8,0.77622e-02_r8 /)
      kbo(:,43,15) = (/ &
        & 0.75459e-02_r8,0.76317e-02_r8,0.76988e-02_r8,0.77406e-02_r8,0.77602e-02_r8 /)
      kbo(:,44,15) = (/ &
        & 0.75134e-02_r8,0.76061e-02_r8,0.76788e-02_r8,0.77299e-02_r8,0.77567e-02_r8 /)
      kbo(:,45,15) = (/ &
        & 0.74772e-02_r8,0.75773e-02_r8,0.76562e-02_r8,0.77161e-02_r8,0.77502e-02_r8 /)
      kbo(:,46,15) = (/ &
        & 0.74372e-02_r8,0.75438e-02_r8,0.76298e-02_r8,0.76975e-02_r8,0.77405e-02_r8 /)
      kbo(:,47,15) = (/ &
        & 0.73875e-02_r8,0.75032e-02_r8,0.75980e-02_r8,0.76724e-02_r8,0.77261e-02_r8 /)
      kbo(:,48,15) = (/ &
        & 0.73358e-02_r8,0.74597e-02_r8,0.75632e-02_r8,0.76453e-02_r8,0.77080e-02_r8 /)
      kbo(:,49,15) = (/ &
        & 0.72811e-02_r8,0.74117e-02_r8,0.75238e-02_r8,0.76147e-02_r8,0.76865e-02_r8 /)
      kbo(:,50,15) = (/ &
        & 0.72248e-02_r8,0.73656e-02_r8,0.74842e-02_r8,0.75831e-02_r8,0.76614e-02_r8 /)
      kbo(:,51,15) = (/ &
        & 0.71662e-02_r8,0.73174e-02_r8,0.74427e-02_r8,0.75493e-02_r8,0.76342e-02_r8 /)
      kbo(:,52,15) = (/ &
        & 0.71006e-02_r8,0.72655e-02_r8,0.73997e-02_r8,0.75133e-02_r8,0.76064e-02_r8 /)
      kbo(:,53,15) = (/ &
        & 0.70300e-02_r8,0.72101e-02_r8,0.73531e-02_r8,0.74734e-02_r8,0.75745e-02_r8 /)
      kbo(:,54,15) = (/ &
        & 0.69596e-02_r8,0.71548e-02_r8,0.73082e-02_r8,0.74357e-02_r8,0.75431e-02_r8 /)
      kbo(:,55,15) = (/ &
        & 0.68873e-02_r8,0.70968e-02_r8,0.72620e-02_r8,0.73967e-02_r8,0.75110e-02_r8 /)
      kbo(:,56,15) = (/ &
        & 0.68089e-02_r8,0.70345e-02_r8,0.72141e-02_r8,0.73575e-02_r8,0.74766e-02_r8 /)
      kbo(:,57,15) = (/ &
        & 0.67241e-02_r8,0.69678e-02_r8,0.71623e-02_r8,0.73141e-02_r8,0.74401e-02_r8 /)
      kbo(:,58,15) = (/ &
        & 0.66371e-02_r8,0.69009e-02_r8,0.71063e-02_r8,0.72699e-02_r8,0.74044e-02_r8 /)
      kbo(:,59,15) = (/ &
        & 0.66009e-02_r8,0.68723e-02_r8,0.70852e-02_r8,0.72532e-02_r8,0.73888e-02_r8 /)
      kbo(:,13,16) = (/ &
        & 0.20091e-01_r8,0.19310e-01_r8,0.18586e-01_r8,0.17917e-01_r8,0.17293e-01_r8 /)
      kbo(:,14,16) = (/ &
        & 0.21405e-01_r8,0.20507e-01_r8,0.19679e-01_r8,0.18912e-01_r8,0.18201e-01_r8 /)
      kbo(:,15,16) = (/ &
        & 0.22567e-01_r8,0.21555e-01_r8,0.20633e-01_r8,0.19775e-01_r8,0.18992e-01_r8 /)
      kbo(:,16,16) = (/ &
        & 0.23562e-01_r8,0.22456e-01_r8,0.21445e-01_r8,0.20508e-01_r8,0.19661e-01_r8 /)
      kbo(:,17,16) = (/ &
        & 0.24411e-01_r8,0.23217e-01_r8,0.22126e-01_r8,0.21126e-01_r8,0.20220e-01_r8 /)
      kbo(:,18,16) = (/ &
        & 0.25116e-01_r8,0.23847e-01_r8,0.22688e-01_r8,0.21635e-01_r8,0.20680e-01_r8 /)
      kbo(:,19,16) = (/ &
        & 0.25693e-01_r8,0.24361e-01_r8,0.23149e-01_r8,0.22047e-01_r8,0.21053e-01_r8 /)
      kbo(:,20,16) = (/ &
        & 0.26126e-01_r8,0.24747e-01_r8,0.23489e-01_r8,0.22355e-01_r8,0.21332e-01_r8 /)
      kbo(:,21,16) = (/ &
        & 0.26457e-01_r8,0.25034e-01_r8,0.23751e-01_r8,0.22588e-01_r8,0.21537e-01_r8 /)
      kbo(:,22,16) = (/ &
        & 0.26586e-01_r8,0.25153e-01_r8,0.23857e-01_r8,0.22677e-01_r8,0.21621e-01_r8 /)
      kbo(:,23,16) = (/ &
        & 0.26640e-01_r8,0.25191e-01_r8,0.23890e-01_r8,0.22706e-01_r8,0.21649e-01_r8 /)
      kbo(:,24,16) = (/ &
        & 0.26616e-01_r8,0.25160e-01_r8,0.23861e-01_r8,0.22680e-01_r8,0.21622e-01_r8 /)
      kbo(:,25,16) = (/ &
        & 0.26518e-01_r8,0.25075e-01_r8,0.23777e-01_r8,0.22603e-01_r8,0.21555e-01_r8 /)
      kbo(:,26,16) = (/ &
        & 0.26348e-01_r8,0.24922e-01_r8,0.23637e-01_r8,0.22478e-01_r8,0.21437e-01_r8 /)
      kbo(:,27,16) = (/ &
        & 0.26138e-01_r8,0.24737e-01_r8,0.23465e-01_r8,0.22328e-01_r8,0.21299e-01_r8 /)
      kbo(:,28,16) = (/ &
        & 0.25904e-01_r8,0.24526e-01_r8,0.23272e-01_r8,0.22156e-01_r8,0.21140e-01_r8 /)
      kbo(:,29,16) = (/ &
        & 0.25645e-01_r8,0.24289e-01_r8,0.23059e-01_r8,0.21960e-01_r8,0.20965e-01_r8 /)
      kbo(:,30,16) = (/ &
        & 0.25364e-01_r8,0.24034e-01_r8,0.22831e-01_r8,0.21758e-01_r8,0.20776e-01_r8 /)
      kbo(:,31,16) = (/ &
        & 0.25075e-01_r8,0.23766e-01_r8,0.22595e-01_r8,0.21541e-01_r8,0.20581e-01_r8 /)
      kbo(:,32,16) = (/ &
        & 0.24769e-01_r8,0.23490e-01_r8,0.22348e-01_r8,0.21316e-01_r8,0.20377e-01_r8 /)
      kbo(:,33,16) = (/ &
        & 0.24460e-01_r8,0.23211e-01_r8,0.22098e-01_r8,0.21090e-01_r8,0.20170e-01_r8 /)
      kbo(:,34,16) = (/ &
        & 0.24193e-01_r8,0.22975e-01_r8,0.21887e-01_r8,0.20894e-01_r8,0.19994e-01_r8 /)
      kbo(:,35,16) = (/ &
        & 0.24050e-01_r8,0.22849e-01_r8,0.21770e-01_r8,0.20789e-01_r8,0.19901e-01_r8 /)
      kbo(:,36,16) = (/ &
        & 0.24043e-01_r8,0.22842e-01_r8,0.21764e-01_r8,0.20784e-01_r8,0.19894e-01_r8 /)
      kbo(:,37,16) = (/ &
        & 0.24229e-01_r8,0.23006e-01_r8,0.21915e-01_r8,0.20918e-01_r8,0.20018e-01_r8 /)
      kbo(:,38,16) = (/ &
        & 0.24421e-01_r8,0.23180e-01_r8,0.22070e-01_r8,0.21062e-01_r8,0.20144e-01_r8 /)
      kbo(:,39,16) = (/ &
        & 0.24617e-01_r8,0.23352e-01_r8,0.22226e-01_r8,0.21205e-01_r8,0.20274e-01_r8 /)
      kbo(:,40,16) = (/ &
        & 0.24953e-01_r8,0.23654e-01_r8,0.22496e-01_r8,0.21449e-01_r8,0.20495e-01_r8 /)
      kbo(:,41,16) = (/ &
        & 0.25312e-01_r8,0.23980e-01_r8,0.22786e-01_r8,0.21712e-01_r8,0.20738e-01_r8 /)
      kbo(:,42,16) = (/ &
        & 0.25679e-01_r8,0.24315e-01_r8,0.23082e-01_r8,0.21982e-01_r8,0.20981e-01_r8 /)
      kbo(:,43,16) = (/ &
        & 0.26140e-01_r8,0.24730e-01_r8,0.23454e-01_r8,0.22317e-01_r8,0.21287e-01_r8 /)
      kbo(:,44,16) = (/ &
        & 0.26653e-01_r8,0.25200e-01_r8,0.23871e-01_r8,0.22691e-01_r8,0.21628e-01_r8 /)
      kbo(:,45,16) = (/ &
        & 0.27190e-01_r8,0.25674e-01_r8,0.24311e-01_r8,0.23078e-01_r8,0.21977e-01_r8 /)
      kbo(:,46,16) = (/ &
        & 0.27783e-01_r8,0.26205e-01_r8,0.24787e-01_r8,0.23504e-01_r8,0.22362e-01_r8 /)
      kbo(:,47,16) = (/ &
        & 0.28471e-01_r8,0.26819e-01_r8,0.25343e-01_r8,0.24006e-01_r8,0.22809e-01_r8 /)
      kbo(:,48,16) = (/ &
        & 0.29185e-01_r8,0.27464e-01_r8,0.25918e-01_r8,0.24532e-01_r8,0.23275e-01_r8 /)
      kbo(:,49,16) = (/ &
        & 0.29935e-01_r8,0.28138e-01_r8,0.26520e-01_r8,0.25074e-01_r8,0.23762e-01_r8 /)
      kbo(:,50,16) = (/ &
        & 0.30661e-01_r8,0.28793e-01_r8,0.27111e-01_r8,0.25603e-01_r8,0.24243e-01_r8 /)
      kbo(:,51,16) = (/ &
        & 0.31401e-01_r8,0.29455e-01_r8,0.27706e-01_r8,0.26135e-01_r8,0.24726e-01_r8 /)
      kbo(:,52,16) = (/ &
        & 0.32182e-01_r8,0.30140e-01_r8,0.28322e-01_r8,0.26686e-01_r8,0.25224e-01_r8 /)
      kbo(:,53,16) = (/ &
        & 0.33002e-01_r8,0.30856e-01_r8,0.28966e-01_r8,0.27268e-01_r8,0.25738e-01_r8 /)
      kbo(:,54,16) = (/ &
        & 0.33792e-01_r8,0.31541e-01_r8,0.29577e-01_r8,0.27816e-01_r8,0.26234e-01_r8 /)
      kbo(:,55,16) = (/ &
        & 0.34581e-01_r8,0.32233e-01_r8,0.30182e-01_r8,0.28363e-01_r8,0.26721e-01_r8 /)
      kbo(:,56,16) = (/ &
        & 0.35416e-01_r8,0.32947e-01_r8,0.30807e-01_r8,0.28926e-01_r8,0.27227e-01_r8 /)
      kbo(:,57,16) = (/ &
        & 0.36291e-01_r8,0.33701e-01_r8,0.31460e-01_r8,0.29510e-01_r8,0.27750e-01_r8 /)
      kbo(:,58,16) = (/ &
        & 0.37161e-01_r8,0.34436e-01_r8,0.32106e-01_r8,0.30077e-01_r8,0.28264e-01_r8 /)
      kbo(:,59,16) = (/ &
        & 0.37521e-01_r8,0.34750e-01_r8,0.32373e-01_r8,0.30309e-01_r8,0.28477e-01_r8 /)

!     -----------------------------------------------------------------

      forrefo(:, 1) = (/ 0.515619e-08_r8, 0.131078e-06_r8, 0.349038e-06_r8 /)
      forrefo(:, 2) = (/ 0.329605e-07_r8, 0.430497e-06_r8, 0.458569e-05_r8 /)
      forrefo(:, 3) = (/ 0.188244e-06_r8, 0.792931e-06_r8, 0.267176e-05_r8 /)
      forrefo(:, 4) = (/ 0.611237e-06_r8, 0.798868e-06_r8, 0.411583e-06_r8 /)
      forrefo(:, 5) = (/ 0.111903e-05_r8, 0.914895e-06_r8, 0.444828e-06_r8 /)
      forrefo(:, 6) = (/ 0.235399e-05_r8, 0.269099e-05_r8, 0.739855e-06_r8 /)
      forrefo(:, 7) = (/ 0.400131e-05_r8, 0.378135e-05_r8, 0.231265e-06_r8 /)
      forrefo(:, 8) = (/ 0.464257e-05_r8, 0.371927e-05_r8, 0.460611e-06_r8 /)
      forrefo(:, 9) = (/ 0.476792e-05_r8, 0.311841e-05_r8, 0.934811e-06_r8 /)
      forrefo(:,10) = (/ 0.555683e-05_r8, 0.238129e-05_r8, 0.400334e-07_r8 /)
      forrefo(:,11) = (/ 0.569068e-05_r8, 0.196039e-05_r8, 0.374476e-07_r8 /)
      forrefo(:,12) = (/ 0.554154e-05_r8, 0.131724e-05_r8, 0.399720e-07_r8 /)
      forrefo(:,13) = (/ 0.462684e-05_r8, 0.238826e-07_r8, 0.325793e-07_r8 /)
      forrefo(:,14) = (/ 0.808644e-06_r8, 0.105126e-11_r8, 0.148691e-07_r8 /)
      forrefo(:,15) = (/ 0.865024e-12_r8, 0.822434e-12_r8, 0.825756e-12_r8 /)
      forrefo(:,16) = (/ 0.945747e-12_r8, 0.802065e-12_r8, 0.724732e-12_r8 /)

!     -----------------------------------------------------------------
!     The array SELFREFO contains the coefficient of the water vapor
!     self-continuum (including the energy term).  The first index
!     refers to temperature in 7.2 degree increments.  For instance,
!     JT = 1 refers to a temperature of 245.6, JT = 2 refers to 252.8,
!     etc.  The second index runs over the g-channel (1 to 16).

      selfrefo(:, 1) = (/ &
        &  0.637755e-05_r8, 0.403921e-05_r8, 0.255823e-05_r8, 0.162025e-05_r8, 0.102618e-05_r8, &
        &  0.649930e-06_r8, 0.411632e-06_r8, 0.260707e-06_r8, 0.165118e-06_r8, 0.104577e-06_r8 /)
      selfrefo(:, 2) = (/ &
        &  0.180887e-04_r8, 0.108890e-04_r8, 0.655493e-05_r8, 0.394592e-05_r8, 0.237536e-05_r8, &
        &  0.142991e-05_r8, 0.860774e-06_r8, 0.518167e-06_r8, 0.311925e-06_r8, 0.187772e-06_r8 /)
      selfrefo(:, 3) = (/ &
        &  0.212261e-04_r8, 0.150697e-04_r8, 0.106989e-04_r8, 0.759581e-05_r8, 0.539274e-05_r8, &
        &  0.382864e-05_r8, 0.271819e-05_r8, 0.192981e-05_r8, 0.137009e-05_r8, 0.972711e-06_r8 /)
      selfrefo(:, 4) = (/ &
        &  0.132497e-04_r8, 0.118071e-04_r8, 0.105216e-04_r8, 0.937599e-05_r8, 0.835516e-05_r8, &
        &  0.744547e-05_r8, 0.663482e-05_r8, 0.591243e-05_r8, 0.526870e-05_r8, 0.469506e-05_r8 /)
      selfrefo(:, 5) = (/ &
        &  0.124069e-04_r8, 0.120785e-04_r8, 0.117589e-04_r8, 0.114477e-04_r8, 0.111447e-04_r8, &
        &  0.108498e-04_r8, 0.105626e-04_r8, 0.102831e-04_r8, 0.100109e-04_r8, 0.974601e-05_r8 /)
      selfrefo(:, 6) = (/ &
        &  0.411994e-04_r8, 0.372560e-04_r8, 0.336901e-04_r8, 0.304654e-04_r8, 0.275494e-04_r8, &
        &  0.249126e-04_r8, 0.225281e-04_r8, 0.203718e-04_r8, 0.184219e-04_r8, 0.166587e-04_r8 /)
      selfrefo(:, 7) = (/ &
        &  0.537376e-04_r8, 0.501002e-04_r8, 0.467090e-04_r8, 0.435473e-04_r8, 0.405996e-04_r8, &
        &  0.378515e-04_r8, 0.352893e-04_r8, 0.329006e-04_r8, 0.306736e-04_r8, 0.285974e-04_r8 /)
      selfrefo(:, 8) = (/ &
        &  0.494279e-04_r8, 0.475365e-04_r8, 0.457175e-04_r8, 0.439681e-04_r8, 0.422857e-04_r8, &
        &  0.406676e-04_r8, 0.391114e-04_r8, 0.376148e-04_r8, 0.361755e-04_r8, 0.347912e-04_r8 /)
      selfrefo(:, 9) = (/ &
        &  0.377444e-04_r8, 0.378199e-04_r8, 0.378956e-04_r8, 0.379715e-04_r8, 0.380475e-04_r8, &
        &  0.381236e-04_r8, 0.381999e-04_r8, 0.382763e-04_r8, 0.383529e-04_r8, 0.384297e-04_r8 /)
      selfrefo(:,10) = (/ &
        &  0.245916e-04_r8, 0.267183e-04_r8, 0.290289e-04_r8, 0.315394e-04_r8, 0.342669e-04_r8, &
        &  0.372304e-04_r8, 0.404501e-04_r8, 0.439483e-04_r8, 0.477490e-04_r8, 0.518784e-04_r8 /)
      selfrefo(:,11) = (/ &
        &  0.186528e-04_r8, 0.211417e-04_r8, 0.239628e-04_r8, 0.271603e-04_r8, 0.307845e-04_r8, &
        &  0.348923e-04_r8, 0.395482e-04_r8, 0.448254e-04_r8, 0.508068e-04_r8, 0.575863e-04_r8 /)
      selfrefo(:,12) = (/ &
        &  0.109896e-04_r8, 0.133794e-04_r8, 0.162890e-04_r8, 0.198312e-04_r8, 0.241438e-04_r8, &
        &  0.293942e-04_r8, 0.357864e-04_r8, 0.435686e-04_r8, 0.530432e-04_r8, 0.645781e-04_r8 /)
      selfrefo(:,13) = (/ &
        &  0.183885e-06_r8, 0.391019e-06_r8, 0.831472e-06_r8, 0.176806e-05_r8, 0.375966e-05_r8, &
        &  0.799463e-05_r8, 0.170000e-04_r8, 0.361492e-04_r8, 0.768686e-04_r8, 0.163455e-03_r8 /)
      selfrefo(:,14) = (/ &
        &  0.466057e-07_r8, 0.937419e-07_r8, 0.188551e-06_r8, 0.379248e-06_r8, 0.762813e-06_r8, &
        &  0.153431e-05_r8, 0.308608e-05_r8, 0.620729e-05_r8, 0.124852e-04_r8, 0.251126e-04_r8 /)
      selfrefo(:,15) = (/ &
        &  0.248961e-06_r8, 0.216780e-06_r8, 0.188758e-06_r8, 0.164358e-06_r8, 0.143113e-06_r8, &
        &  0.124613e-06_r8, 0.108505e-06_r8, 0.944795e-07_r8, 0.822667e-07_r8, 0.716326e-07_r8 /)
      selfrefo(:,16) = (/ &
        &  0.252246e-06_r8, 0.220335e-06_r8, 0.192462e-06_r8, 0.168114e-06_r8, 0.146847e-06_r8, &
        &  0.128270e-06_r8, 0.112043e-06_r8, 0.978688e-07_r8, 0.854878e-07_r8, 0.746731e-07_r8 /)
     
      end subroutine sw_kgb24

! **************************************************************************
      subroutine sw_kgb25
! **************************************************************************

      use shr_kind_mod, only: r8 => shr_kind_r8

!      use parkind, only : jpim, jprb 
      use rrsw_kg25, only : kao, sfluxrefo, &
                            raylo, abso3ao, abso3bo, layreffr

      implicit none
      save

! Kurucz solar source function
      sfluxrefo(:) = (/ &
        & 42.6858_r8 , 45.7720_r8, 44.9872_r8, 45.9662_r8    , &
        & 46.5458_r8 , 41.6926_r8, 32.2893_r8, 24.0928_r8    , &
        & 16.7686_r8 , 1.86048_r8, 1.54057_r8, 1.23503_r8    , &
        & 0.915085_r8,0.590099_r8,0.218622_r8, 3.21287e-02_r8 /)

! Rayleigh extinction coefficient at v = 2925 cm-1.
      raylo(:) = (/ &
        & 9.81132e-07_r8,8.25605e-07_r8,6.71302e-07_r8,5.53556e-07_r8, & 
        & 3.97383e-07_r8,3.68206e-07_r8,4.42379e-07_r8,4.57799e-07_r8, &
        & 4.22683e-07_r8,3.87113e-07_r8,3.79810e-07_r8,3.63192e-07_r8, &
        & 3.51921e-07_r8,3.34231e-07_r8,3.34294e-07_r8,3.32673e-07_r8 /)
     
      abso3ao(:) = (/ &
        & 2.32664e-02_r8,5.76154e-02_r8,0.125389_r8,0.250158_r8, &
        & 0.378756_r8   ,0.402196_r8   ,0.352026_r8,0.352036_r8, &
        & 0.386253_r8   ,0.414598_r8   ,0.420079_r8,0.435471_r8, &
        & 0.445487_r8   ,0.459549_r8   ,0.452920_r8,0.456838_r8 /)

      abso3bo(:) = (/ &     
        & 1.76917e-02_r8,4.64185e-02_r8,1.03640e-01_r8,0.189469_r8, &
        & 0.303858_r8   ,0.400248_r8   ,0.447357_r8   ,0.470009_r8, &
        & 0.498673_r8   ,0.515696_r8   ,0.517053_r8   ,0.517930_r8, &
        & 0.518345_r8   ,0.524952_r8   ,0.508244_r8   ,0.468981_r8 /)

     layreffr = 2

!     ------------------------------------------------------------------
!     The array KAO contains absorption coefs at the 16 chosen g-values 
!     for a range of pressure levels> ~100mb, temperatures, and binary
!     species parameters (see taumol.f for definition).  The first 
!     index in the array, JS, runs from 1 to 9, and corresponds to 
!     different values of the binary species parameter.  For instance, 
!     JS=1 refers to dry air, JS = 2 corresponds to the paramter value 1/8, 
!     JS = 3 corresponds to the parameter value 2/8, etc.  The second index
!     in the array, JT, which runs from 1 to 5, corresponds to different
!     temperatures.  More specifically, JT = 3 means that the data are for
!     the reference temperature TREF for this  pressure level, JT = 2 refers
!     to TREF-15, JT = 1 is for TREF-30, JT = 4 is for TREF+15, and JT = 5
!     is for TREF+30.  The third index, JP, runs from 1 to 13 and refers
!     to the JPth reference pressure level (see taumol.f for these levels
!     in mb).  The fourth index, IG, goes from 1 to 16, and indicates
!     which g-interval the absorption coefficients are for.
!     -----------------------------------------------------------------

      kao(:, 1, 1) = (/ &
        & 0.16461e-08_r8,0.16782e-08_r8,0.19339e-08_r8,0.17100e-08_r8,0.17045e-08_r8 /)
      kao(:, 2, 1) = (/ &
        & 0.28759e-08_r8,0.29469e-08_r8,0.33789e-08_r8,0.34357e-08_r8,0.28833e-08_r8 /)
      kao(:, 3, 1) = (/ &
        & 0.55148e-08_r8,0.54808e-08_r8,0.54190e-08_r8,0.68260e-08_r8,0.51972e-08_r8 /)
      kao(:, 4, 1) = (/ &
        & 0.95336e-08_r8,0.94552e-08_r8,0.93001e-08_r8,0.90961e-08_r8,0.14451e-07_r8 /)
      kao(:, 5, 1) = (/ &
        & 0.14930e-07_r8,0.14736e-07_r8,0.14432e-07_r8,0.14074e-07_r8,0.24102e-07_r8 /)
      kao(:, 6, 1) = (/ &
        & 0.22770e-07_r8,0.22301e-07_r8,0.21778e-07_r8,0.21194e-07_r8,0.20569e-07_r8 /)
      kao(:, 7, 1) = (/ &
        & 0.34699e-07_r8,0.33951e-07_r8,0.33124e-07_r8,0.32144e-07_r8,0.31220e-07_r8 /)
      kao(:, 8, 1) = (/ &
        & 0.62339e-07_r8,0.60405e-07_r8,0.59548e-07_r8,0.58214e-07_r8,0.56977e-07_r8 /)
      kao(:, 9, 1) = (/ &
        & 0.17411e-06_r8,0.17654e-06_r8,0.18315e-06_r8,0.18100e-06_r8,0.17839e-06_r8 /)
      kao(:,10, 1) = (/ &
        & 0.23526e-06_r8,0.22729e-06_r8,0.21947e-06_r8,0.21188e-06_r8,0.20454e-06_r8 /)
      kao(:,11, 1) = (/ &
        & 0.23535e-06_r8,0.22737e-06_r8,0.21956e-06_r8,0.21196e-06_r8,0.20461e-06_r8 /)
      kao(:,12, 1) = (/ &
        & 0.23539e-06_r8,0.22740e-06_r8,0.21959e-06_r8,0.21199e-06_r8,0.20465e-06_r8 /)
      kao(:,13, 1) = (/ &
        & 0.23543e-06_r8,0.22744e-06_r8,0.21962e-06_r8,0.21202e-06_r8,0.20467e-06_r8 /)
      kao(:, 1, 2) = (/ &
        & 0.62912e-08_r8,0.61559e-08_r8,0.84640e-08_r8,0.59240e-08_r8,0.58217e-08_r8 /)
      kao(:, 2, 2) = (/ &
        & 0.83749e-08_r8,0.80756e-08_r8,0.11623e-07_r8,0.11272e-07_r8,0.73636e-08_r8 /)
      kao(:, 3, 2) = (/ &
        & 0.13304e-07_r8,0.12795e-07_r8,0.12343e-07_r8,0.21235e-07_r8,0.11577e-07_r8 /)
      kao(:, 4, 2) = (/ &
        & 0.20704e-07_r8,0.19736e-07_r8,0.18900e-07_r8,0.18228e-07_r8,0.31601e-07_r8 /)
      kao(:, 5, 2) = (/ &
        & 0.31149e-07_r8,0.29669e-07_r8,0.28318e-07_r8,0.27101e-07_r8,0.49649e-07_r8 /)
      kao(:, 6, 2) = (/ &
        & 0.45713e-07_r8,0.43519e-07_r8,0.41488e-07_r8,0.39918e-07_r8,0.38291e-07_r8 /)
      kao(:, 7, 2) = (/ &
        & 0.77265e-07_r8,0.73848e-07_r8,0.70437e-07_r8,0.67945e-07_r8,0.66127e-07_r8 /)
      kao(:, 8, 2) = (/ &
        & 0.15754e-06_r8,0.15664e-06_r8,0.15378e-06_r8,0.15027e-06_r8,0.14633e-06_r8 /)
      kao(:, 9, 2) = (/ &
        & 0.16439e-06_r8,0.14678e-06_r8,0.12610e-06_r8,0.11532e-06_r8,0.10591e-06_r8 /)
      kao(:,10, 2) = (/ &
        & 0.14366e-06_r8,0.13506e-06_r8,0.12583e-06_r8,0.11774e-06_r8,0.11011e-06_r8 /)
      kao(:,11, 2) = (/ &
        & 0.14521e-06_r8,0.13766e-06_r8,0.13072e-06_r8,0.12218e-06_r8,0.11400e-06_r8 /)
      kao(:,12, 2) = (/ &
        & 0.14524e-06_r8,0.13769e-06_r8,0.13074e-06_r8,0.12241e-06_r8,0.11552e-06_r8 /)
      kao(:,13, 2) = (/ &
        & 0.14525e-06_r8,0.13770e-06_r8,0.13075e-06_r8,0.12252e-06_r8,0.11553e-06_r8 /)
      kao(:, 1, 3) = (/ &
        & 0.14060e-07_r8,0.13587e-07_r8,0.24644e-07_r8,0.12716e-07_r8,0.12367e-07_r8 /)
      kao(:, 2, 3) = (/ &
        & 0.17055e-07_r8,0.16577e-07_r8,0.32443e-07_r8,0.31273e-07_r8,0.15381e-07_r8 /)
      kao(:, 3, 3) = (/ &
        & 0.25414e-07_r8,0.24672e-07_r8,0.23874e-07_r8,0.47281e-07_r8,0.22346e-07_r8 /)
      kao(:, 4, 3) = (/ &
        & 0.39536e-07_r8,0.38124e-07_r8,0.36836e-07_r8,0.35587e-07_r8,0.72260e-07_r8 /)
      kao(:, 5, 3) = (/ &
        & 0.59488e-07_r8,0.57630e-07_r8,0.55623e-07_r8,0.53878e-07_r8,0.11230e-06_r8 /)
      kao(:, 6, 3) = (/ &
        & 0.99996e-07_r8,0.96206e-07_r8,0.93184e-07_r8,0.90812e-07_r8,0.89206e-07_r8 /)
      kao(:, 7, 3) = (/ &
        & 0.17678e-06_r8,0.17554e-06_r8,0.17358e-06_r8,0.17091e-06_r8,0.16830e-06_r8 /)
      kao(:, 8, 3) = (/ &
        & 0.18672e-06_r8,0.17850e-06_r8,0.16967e-06_r8,0.16275e-06_r8,0.15875e-06_r8 /)
      kao(:, 9, 3) = (/ &
        & 0.13558e-06_r8,0.13493e-06_r8,0.13633e-06_r8,0.13799e-06_r8,0.13932e-06_r8 /)
      kao(:,10, 3) = (/ &
        & 0.18883e-06_r8,0.20452e-06_r8,0.22206e-06_r8,0.24347e-06_r8,0.26091e-06_r8 /)
      kao(:,11, 3) = (/ &
        & 0.21296e-06_r8,0.23580e-06_r8,0.26439e-06_r8,0.30148e-06_r8,0.34942e-06_r8 /)
      kao(:,12, 3) = (/ &
        & 0.22072e-06_r8,0.25535e-06_r8,0.28661e-06_r8,0.34814e-06_r8,0.39337e-06_r8 /)
      kao(:,13, 3) = (/ &
        & 0.22515e-06_r8,0.26161e-06_r8,0.30833e-06_r8,0.36527e-06_r8,0.40123e-06_r8 /)
      kao(:, 1, 4) = (/ &
        & 0.32735e-07_r8,0.31345e-07_r8,0.58846e-07_r8,0.28258e-07_r8,0.27022e-07_r8 /)
      kao(:, 2, 4) = (/ &
        & 0.37754e-07_r8,0.36873e-07_r8,0.82776e-07_r8,0.80947e-07_r8,0.35190e-07_r8 /)
      kao(:, 3, 4) = (/ &
        & 0.76368e-07_r8,0.75292e-07_r8,0.74075e-07_r8,0.10820e-06_r8,0.73183e-07_r8 /)
      kao(:, 4, 4) = (/ &
        & 0.16392e-06_r8,0.16130e-06_r8,0.15926e-06_r8,0.15700e-06_r8,0.22041e-06_r8 /)
      kao(:, 5, 4) = (/ &
        & 0.29704e-06_r8,0.28924e-06_r8,0.28301e-06_r8,0.27633e-06_r8,0.42284e-06_r8 /)
      kao(:, 6, 4) = (/ &
        & 0.48466e-06_r8,0.47240e-06_r8,0.46143e-06_r8,0.45012e-06_r8,0.43867e-06_r8 /)
      kao(:, 7, 4) = (/ &
        & 0.71637e-06_r8,0.69847e-06_r8,0.67384e-06_r8,0.65368e-06_r8,0.63375e-06_r8 /)
      kao(:, 8, 4) = (/ &
        & 0.11904e-05_r8,0.11714e-05_r8,0.11524e-05_r8,0.11354e-05_r8,0.11172e-05_r8 /)
      kao(:, 9, 4) = (/ &
        & 0.21976e-05_r8,0.21606e-05_r8,0.21332e-05_r8,0.20944e-05_r8,0.20536e-05_r8 /)
      kao(:,10, 4) = (/ &
        & 0.21713e-05_r8,0.21144e-05_r8,0.20553e-05_r8,0.19901e-05_r8,0.19286e-05_r8 /)
      kao(:,11, 4) = (/ &
        & 0.21443e-05_r8,0.20785e-05_r8,0.20048e-05_r8,0.19232e-05_r8,0.18295e-05_r8 /)
      kao(:,12, 4) = (/ &
        & 0.21363e-05_r8,0.20578e-05_r8,0.19811e-05_r8,0.18729e-05_r8,0.17807e-05_r8 /)
      kao(:,13, 4) = (/ &
        & 0.21319e-05_r8,0.20513e-05_r8,0.19580e-05_r8,0.18546e-05_r8,0.17725e-05_r8 /)
      kao(:, 1, 5) = (/ &
        & 0.36050e-07_r8,0.36125e-07_r8,0.46253e-07_r8,0.37280e-07_r8,0.37359e-07_r8 /)
      kao(:, 2, 5) = (/ &
        & 0.65102e-07_r8,0.64266e-07_r8,0.68896e-07_r8,0.65925e-07_r8,0.61190e-07_r8 /)
      kao(:, 3, 5) = (/ &
        & 0.12173e-06_r8,0.11889e-06_r8,0.11625e-06_r8,0.17574e-06_r8,0.10921e-06_r8 /)
      kao(:, 4, 5) = (/ &
        & 0.20555e-06_r8,0.19853e-06_r8,0.19068e-06_r8,0.18313e-06_r8,0.30241e-06_r8 /)
      kao(:, 5, 5) = (/ &
        & 0.30900e-06_r8,0.29996e-06_r8,0.28857e-06_r8,0.27772e-06_r8,0.51631e-06_r8 /)
      kao(:, 6, 5) = (/ &
        & 0.43774e-06_r8,0.42465e-06_r8,0.40920e-06_r8,0.39315e-06_r8,0.37901e-06_r8 /)
      kao(:, 7, 5) = (/ &
        & 0.63869e-06_r8,0.61654e-06_r8,0.60324e-06_r8,0.58966e-06_r8,0.57948e-06_r8 /)
      kao(:, 8, 5) = (/ &
        & 0.98362e-06_r8,0.96271e-06_r8,0.94180e-06_r8,0.92206e-06_r8,0.91105e-06_r8 /)
      kao(:, 9, 5) = (/ &
        & 0.12061e-05_r8,0.11895e-05_r8,0.11564e-05_r8,0.11296e-05_r8,0.11110e-05_r8 /)
      kao(:,10, 5) = (/ &
        & 0.12958e-05_r8,0.12694e-05_r8,0.12425e-05_r8,0.12153e-05_r8,0.11880e-05_r8 /)
      kao(:,11, 5) = (/ &
        & 0.12962e-05_r8,0.12698e-05_r8,0.12429e-05_r8,0.12156e-05_r8,0.11883e-05_r8 /)
      kao(:,12, 5) = (/ &
        & 0.12964e-05_r8,0.12701e-05_r8,0.12431e-05_r8,0.12158e-05_r8,0.11885e-05_r8 /)
      kao(:,13, 5) = (/ &
        & 0.12966e-05_r8,0.12702e-05_r8,0.12433e-05_r8,0.12160e-05_r8,0.11886e-05_r8 /)
      kao(:, 1, 6) = (/ &
        & 0.73925e-07_r8,0.70231e-07_r8,0.21454e-06_r8,0.63477e-07_r8,0.60912e-07_r8 /)
      kao(:, 2, 6) = (/ &
        & 0.67794e-07_r8,0.65807e-07_r8,0.13854e-06_r8,0.13061e-06_r8,0.59361e-07_r8 /)
      kao(:, 3, 6) = (/ &
        & 0.98353e-07_r8,0.95275e-07_r8,0.92426e-07_r8,0.15768e-06_r8,0.87986e-07_r8 /)
      kao(:, 4, 6) = (/ &
        & 0.15855e-06_r8,0.15394e-06_r8,0.14948e-06_r8,0.14655e-06_r8,0.23172e-06_r8 /)
      kao(:, 5, 6) = (/ &
        & 0.27764e-06_r8,0.26941e-06_r8,0.26299e-06_r8,0.25975e-06_r8,0.40526e-06_r8 /)
      kao(:, 6, 6) = (/ &
        & 0.45469e-06_r8,0.44417e-06_r8,0.43276e-06_r8,0.42440e-06_r8,0.41489e-06_r8 /)
      kao(:, 7, 6) = (/ &
        & 0.71540e-06_r8,0.71291e-06_r8,0.70656e-06_r8,0.69823e-06_r8,0.68342e-06_r8 /)
      kao(:, 8, 6) = (/ &
        & 0.79651e-06_r8,0.79807e-06_r8,0.80621e-06_r8,0.80941e-06_r8,0.79835e-06_r8 /)
      kao(:, 9, 6) = (/ &
        & 0.18716e-06_r8,0.16713e-06_r8,0.14725e-06_r8,0.13728e-06_r8,0.11763e-06_r8 /)
      kao(:,10, 6) = (/ &
        & 0.92638e-07_r8,0.86207e-07_r8,0.80877e-07_r8,0.70432e-07_r8,0.64517e-07_r8 /)
      kao(:,11, 6) = (/ &
        & 0.13396e-06_r8,0.12820e-06_r8,0.12387e-06_r8,0.10427e-06_r8,0.94091e-07_r8 /)
      kao(:,12, 6) = (/ &
        & 0.14877e-06_r8,0.14827e-06_r8,0.14350e-06_r8,0.12154e-06_r8,0.10552e-06_r8 /)
      kao(:,13, 6) = (/ &
        & 0.15437e-06_r8,0.15323e-06_r8,0.14992e-06_r8,0.12715e-06_r8,0.10933e-06_r8 /)
      kao(:, 1, 7) = (/ &
        & 0.72717e-06_r8,0.70656e-06_r8,0.13933e-05_r8,0.66449e-06_r8,0.64269e-06_r8 /)
      kao(:, 2, 7) = (/ &
        & 0.52595e-06_r8,0.50791e-06_r8,0.11171e-05_r8,0.10538e-05_r8,0.45644e-06_r8 /)
      kao(:, 3, 7) = (/ &
        & 0.29919e-06_r8,0.29227e-06_r8,0.28284e-06_r8,0.65215e-06_r8,0.26347e-06_r8 /)
      kao(:, 4, 7) = (/ &
        & 0.27961e-06_r8,0.27579e-06_r8,0.27068e-06_r8,0.26343e-06_r8,0.41265e-06_r8 /)
      kao(:, 5, 7) = (/ &
        & 0.37031e-06_r8,0.36318e-06_r8,0.35475e-06_r8,0.34488e-06_r8,0.53740e-06_r8 /)
      kao(:, 6, 7) = (/ &
        & 0.53195e-06_r8,0.52692e-06_r8,0.52224e-06_r8,0.51934e-06_r8,0.51146e-06_r8 /)
      kao(:, 7, 7) = (/ &
        & 0.83043e-06_r8,0.84552e-06_r8,0.84833e-06_r8,0.82800e-06_r8,0.80930e-06_r8 /)
      kao(:, 8, 7) = (/ &
        & 0.14910e-05_r8,0.15179e-05_r8,0.15248e-05_r8,0.15091e-05_r8,0.14853e-05_r8 /)
      kao(:, 9, 7) = (/ &
        & 0.37340e-05_r8,0.37823e-05_r8,0.38311e-05_r8,0.38453e-05_r8,0.38567e-05_r8 /)
      kao(:,10, 7) = (/ &
        & 0.86791e-05_r8,0.89697e-05_r8,0.92118e-05_r8,0.93991e-05_r8,0.95564e-05_r8 /)
      kao(:,11, 7) = (/ &
        & 0.11878e-04_r8,0.12201e-04_r8,0.12588e-04_r8,0.12897e-04_r8,0.13151e-04_r8 /)
      kao(:,12, 7) = (/ &
        & 0.13192e-04_r8,0.13732e-04_r8,0.14137e-04_r8,0.14465e-04_r8,0.14643e-04_r8 /)
      kao(:,13, 7) = (/ &
        & 0.13716e-04_r8,0.14229e-04_r8,0.14617e-04_r8,0.14944e-04_r8,0.15182e-04_r8 /)
      kao(:, 1, 8) = (/ &
        & 0.39538e-05_r8,0.38949e-05_r8,0.56188e-05_r8,0.37475e-05_r8,0.36648e-05_r8 /)
      kao(:, 2, 8) = (/ &
        & 0.34231e-05_r8,0.33633e-05_r8,0.51877e-05_r8,0.50048e-05_r8,0.31425e-05_r8 /)
      kao(:, 3, 8) = (/ &
        & 0.28073e-05_r8,0.27497e-05_r8,0.26875e-05_r8,0.44405e-05_r8,0.25492e-05_r8 /)
      kao(:, 4, 8) = (/ &
        & 0.19229e-05_r8,0.18818e-05_r8,0.18382e-05_r8,0.17896e-05_r8,0.33073e-05_r8 /)
      kao(:, 5, 8) = (/ &
        & 0.11453e-05_r8,0.11293e-05_r8,0.11095e-05_r8,0.10866e-05_r8,0.19344e-05_r8 /)
      kao(:, 6, 8) = (/ &
        & 0.14565e-05_r8,0.14517e-05_r8,0.14369e-05_r8,0.14141e-05_r8,0.13944e-05_r8 /)
      kao(:, 7, 8) = (/ &
        & 0.23228e-05_r8,0.22753e-05_r8,0.22395e-05_r8,0.22124e-05_r8,0.21731e-05_r8 /)
      kao(:, 8, 8) = (/ &
        & 0.34877e-05_r8,0.34362e-05_r8,0.33796e-05_r8,0.33389e-05_r8,0.32924e-05_r8 /)
      kao(:, 9, 8) = (/ &
        & 0.63448e-05_r8,0.63701e-05_r8,0.63619e-05_r8,0.62632e-05_r8,0.61645e-05_r8 /)
      kao(:,10, 8) = (/ &
        & 0.12155e-04_r8,0.11880e-04_r8,0.11762e-04_r8,0.11759e-04_r8,0.11651e-04_r8 /)
      kao(:,11, 8) = (/ &
        & 0.14093e-04_r8,0.13835e-04_r8,0.13547e-04_r8,0.13205e-04_r8,0.12690e-04_r8 /)
      kao(:,12, 8) = (/ &
        & 0.14428e-04_r8,0.14056e-04_r8,0.13932e-04_r8,0.13396e-04_r8,0.12885e-04_r8 /)
      kao(:,13, 8) = (/ &
        & 0.15229e-04_r8,0.14534e-04_r8,0.13849e-04_r8,0.13292e-04_r8,0.12704e-04_r8 /)
      kao(:, 1, 9) = (/ &
        & 0.19250e-04_r8,0.19148e-04_r8,0.21702e-04_r8,0.18906e-04_r8,0.18761e-04_r8 /)
      kao(:, 2, 9) = (/ &
        & 0.18132e-04_r8,0.18040e-04_r8,0.20884e-04_r8,0.20523e-04_r8,0.17656e-04_r8 /)
      kao(:, 3, 9) = (/ &
        & 0.16928e-04_r8,0.16843e-04_r8,0.16742e-04_r8,0.19715e-04_r8,0.16470e-04_r8 /)
      kao(:, 4, 9) = (/ &
        & 0.15526e-04_r8,0.15463e-04_r8,0.15377e-04_r8,0.15268e-04_r8,0.18367e-04_r8 /)
      kao(:, 5, 9) = (/ &
        & 0.13545e-04_r8,0.13511e-04_r8,0.13455e-04_r8,0.13362e-04_r8,0.16722e-04_r8 /)
      kao(:, 6, 9) = (/ &
        & 0.97183e-05_r8,0.97218e-05_r8,0.97084e-05_r8,0.96717e-05_r8,0.96030e-05_r8 /)
      kao(:, 7, 9) = (/ &
        & 0.50307e-05_r8,0.50984e-05_r8,0.51628e-05_r8,0.52093e-05_r8,0.52354e-05_r8 /)
      kao(:, 8, 9) = (/ &
        & 0.45837e-05_r8,0.45939e-05_r8,0.45938e-05_r8,0.45639e-05_r8,0.45109e-05_r8 /)
      kao(:, 9, 9) = (/ &
        & 0.12254e-04_r8,0.12319e-04_r8,0.12397e-04_r8,0.12584e-04_r8,0.12620e-04_r8 /)
      kao(:,10, 9) = (/ &
        & 0.21545e-04_r8,0.21836e-04_r8,0.21718e-04_r8,0.21511e-04_r8,0.21211e-04_r8 /)
      kao(:,11, 9) = (/ &
        & 0.20079e-04_r8,0.19539e-04_r8,0.18859e-04_r8,0.18393e-04_r8,0.18181e-04_r8 /)
      kao(:,12, 9) = (/ &
        & 0.17115e-04_r8,0.16357e-04_r8,0.15410e-04_r8,0.15220e-04_r8,0.15207e-04_r8 /)
      kao(:,13, 9) = (/ &
        & 0.14935e-04_r8,0.14679e-04_r8,0.14593e-04_r8,0.14448e-04_r8,0.14436e-04_r8 /)
      kao(:, 1,10) = (/ &
        & 0.53569e-04_r8,0.53042e-04_r8,0.55454e-04_r8,0.52098e-04_r8,0.51678e-04_r8 /)
      kao(:, 2,10) = (/ &
        & 0.52196e-04_r8,0.51739e-04_r8,0.54777e-04_r8,0.54075e-04_r8,0.50624e-04_r8 /)
      kao(:, 3,10) = (/ &
        & 0.50339e-04_r8,0.50046e-04_r8,0.49769e-04_r8,0.53168e-04_r8,0.49370e-04_r8 /)
      kao(:, 4,10) = (/ &
        & 0.48505e-04_r8,0.48316e-04_r8,0.48143e-04_r8,0.47993e-04_r8,0.51621e-04_r8 /)
      kao(:, 5,10) = (/ &
        & 0.46313e-04_r8,0.46267e-04_r8,0.46119e-04_r8,0.46064e-04_r8,0.50279e-04_r8 /)
      kao(:, 6,10) = (/ &
        & 0.42662e-04_r8,0.42818e-04_r8,0.42935e-04_r8,0.43007e-04_r8,0.43099e-04_r8 /)
      kao(:, 7,10) = (/ &
        & 0.35762e-04_r8,0.36149e-04_r8,0.36450e-04_r8,0.36639e-04_r8,0.36887e-04_r8 /)
      kao(:, 8,10) = (/ &
        & 0.13516e-05_r8,0.18607e-05_r8,0.23061e-05_r8,0.27339e-05_r8,0.36516e-05_r8 /)
      kao(:, 9,10) = (/ &
        & 0.36432e-05_r8,0.40739e-05_r8,0.43830e-05_r8,0.41136e-05_r8,0.43128e-05_r8 /)
      kao(:,10,10) = (/ &
        & 0.62049e-05_r8,0.69116e-05_r8,0.73244e-05_r8,0.65087e-05_r8,0.78951e-05_r8 /)
      kao(:,11,10) = (/ &
        & 0.32156e-05_r8,0.38834e-05_r8,0.41231e-05_r8,0.43386e-05_r8,0.43405e-05_r8 /)
      kao(:,12,10) = (/ &
        & 0.22152e-05_r8,0.26754e-05_r8,0.31971e-05_r8,0.34911e-05_r8,0.37935e-05_r8 /)
      kao(:,13,10) = (/ &
        & 0.19792e-05_r8,0.26543e-05_r8,0.31511e-05_r8,0.34597e-05_r8,0.40624e-05_r8 /)
      kao(:, 1,11) = (/ &
        & 0.75384e-04_r8,0.75103e-04_r8,0.77406e-04_r8,0.74222e-04_r8,0.73734e-04_r8 /)
      kao(:, 2,11) = (/ &
        & 0.75458e-04_r8,0.75244e-04_r8,0.77778e-04_r8,0.77018e-04_r8,0.73942e-04_r8 /)
      kao(:, 3,11) = (/ &
        & 0.75023e-04_r8,0.74844e-04_r8,0.74477e-04_r8,0.77271e-04_r8,0.73633e-04_r8 /)
      kao(:, 4,11) = (/ &
        & 0.73633e-04_r8,0.73539e-04_r8,0.73257e-04_r8,0.72934e-04_r8,0.76232e-04_r8 /)
      kao(:, 5,11) = (/ &
        & 0.71348e-04_r8,0.71322e-04_r8,0.71227e-04_r8,0.71069e-04_r8,0.75258e-04_r8 /)
      kao(:, 6,11) = (/ &
        & 0.67784e-04_r8,0.67873e-04_r8,0.67974e-04_r8,0.67924e-04_r8,0.67903e-04_r8 /)
      kao(:, 7,11) = (/ &
        & 0.61855e-04_r8,0.61922e-04_r8,0.61973e-04_r8,0.62206e-04_r8,0.62496e-04_r8 /)
      kao(:, 8,11) = (/ &
        & 0.36622e-04_r8,0.37413e-04_r8,0.38740e-04_r8,0.40550e-04_r8,0.41833e-04_r8 /)
      kao(:, 9,11) = (/ &
        & 0.28544e-05_r8,0.28831e-05_r8,0.31445e-05_r8,0.32900e-05_r8,0.27967e-05_r8 /)
      kao(:,10,11) = (/ &
        & 0.53755e-05_r8,0.42123e-05_r8,0.51154e-05_r8,0.63481e-05_r8,0.54219e-05_r8 /)
      kao(:,11,11) = (/ &
        & 0.12605e-05_r8,0.14078e-05_r8,0.19167e-05_r8,0.23729e-05_r8,0.30161e-05_r8 /)
      kao(:,12,11) = (/ &
        & 0.11370e-05_r8,0.91524e-06_r8,0.11150e-05_r8,0.14746e-05_r8,0.20128e-05_r8 /)
      kao(:,13,11) = (/ &
        & 0.10511e-05_r8,0.10014e-05_r8,0.11405e-05_r8,0.13852e-05_r8,0.15576e-05_r8 /)
      kao(:, 1,12) = (/ &
        & 0.11184e-03_r8,0.11117e-03_r8,0.11327e-03_r8,0.10989e-03_r8,0.10910e-03_r8 /)
      kao(:, 2,12) = (/ &
        & 0.11379e-03_r8,0.11322e-03_r8,0.11555e-03_r8,0.11462e-03_r8,0.11135e-03_r8 /)
      kao(:, 3,12) = (/ &
        & 0.11508e-03_r8,0.11459e-03_r8,0.11421e-03_r8,0.11671e-03_r8,0.11339e-03_r8 /)
      kao(:, 4,12) = (/ &
        & 0.11596e-03_r8,0.11563e-03_r8,0.11538e-03_r8,0.11511e-03_r8,0.11770e-03_r8 /)
      kao(:, 5,12) = (/ &
        & 0.11597e-03_r8,0.11581e-03_r8,0.11569e-03_r8,0.11553e-03_r8,0.11890e-03_r8 /)
      kao(:, 6,12) = (/ &
        & 0.11443e-03_r8,0.11445e-03_r8,0.11443e-03_r8,0.11443e-03_r8,0.11438e-03_r8 /)
      kao(:, 7,12) = (/ &
        & 0.10852e-03_r8,0.10888e-03_r8,0.10912e-03_r8,0.10934e-03_r8,0.10942e-03_r8 /)
      kao(:, 8,12) = (/ &
        & 0.93194e-04_r8,0.94766e-04_r8,0.95355e-04_r8,0.95090e-04_r8,0.94926e-04_r8 /)
      kao(:, 9,12) = (/ &
        & 0.11836e-05_r8,0.16115e-05_r8,0.12883e-05_r8,0.14202e-05_r8,0.16541e-05_r8 /)
      kao(:,10,12) = (/ &
        & 0.18748e-05_r8,0.34401e-05_r8,0.39984e-05_r8,0.44576e-05_r8,0.33683e-05_r8 /)
      kao(:,11,12) = (/ &
        & 0.29890e-06_r8,0.48741e-06_r8,0.66276e-06_r8,0.99698e-06_r8,0.19230e-05_r8 /)
      kao(:,12,12) = (/ &
        & 0.15034e-06_r8,0.39966e-06_r8,0.56523e-06_r8,0.70494e-06_r8,0.10046e-05_r8 /)
      kao(:,13,12) = (/ &
        & 0.15016e-06_r8,0.25751e-06_r8,0.48928e-06_r8,0.63534e-06_r8,0.93575e-06_r8 /)
      kao(:, 1,13) = (/ &
        & 0.17305e-03_r8,0.17234e-03_r8,0.17389e-03_r8,0.17055e-03_r8,0.16974e-03_r8 /)
      kao(:, 2,13) = (/ &
        & 0.18170e-03_r8,0.18075e-03_r8,0.18265e-03_r8,0.18138e-03_r8,0.17772e-03_r8 /)
      kao(:, 3,13) = (/ &
        & 0.18990e-03_r8,0.18892e-03_r8,0.18776e-03_r8,0.18950e-03_r8,0.18494e-03_r8 /)
      kao(:, 4,13) = (/ &
        & 0.19649e-03_r8,0.19552e-03_r8,0.19424e-03_r8,0.19281e-03_r8,0.19464e-03_r8 /)
      kao(:, 5,13) = (/ &
        & 0.20197e-03_r8,0.20109e-03_r8,0.19993e-03_r8,0.19856e-03_r8,0.20092e-03_r8 /)
      kao(:, 6,13) = (/ &
        & 0.20595e-03_r8,0.20549e-03_r8,0.20452e-03_r8,0.20331e-03_r8,0.20199e-03_r8 /)
      kao(:, 7,13) = (/ &
        & 0.20703e-03_r8,0.20710e-03_r8,0.20649e-03_r8,0.20552e-03_r8,0.20428e-03_r8 /)
      kao(:, 8,13) = (/ &
        & 0.19874e-03_r8,0.19767e-03_r8,0.19696e-03_r8,0.19655e-03_r8,0.19591e-03_r8 /)
      kao(:, 9,13) = (/ &
        & 0.20434e-04_r8,0.23398e-04_r8,0.27400e-04_r8,0.32409e-04_r8,0.38451e-04_r8 /)
      kao(:,10,13) = (/ &
        & 0.18617e-05_r8,0.99513e-06_r8,0.10554e-05_r8,0.16516e-05_r8,0.37792e-05_r8 /)
      kao(:,11,13) = (/ &
        & 0.12517e-06_r8,0.29518e-06_r8,0.77058e-06_r8,0.11660e-05_r8,0.15349e-05_r8 /)
      kao(:,12,13) = (/ &
        & 0.12734e-06_r8,0.36524e-06_r8,0.66699e-06_r8,0.10362e-05_r8,0.14158e-05_r8 /)
      kao(:,13,13) = (/ &
        & 0.12431e-06_r8,0.39389e-06_r8,0.67331e-06_r8,0.10292e-05_r8,0.14448e-05_r8 /)
      kao(:, 1,14) = (/ &
        & 0.29365e-03_r8,0.29046e-03_r8,0.29008e-03_r8,0.28509e-03_r8,0.28286e-03_r8 /)
      kao(:, 2,14) = (/ &
        & 0.31990e-03_r8,0.31668e-03_r8,0.31617e-03_r8,0.31332e-03_r8,0.30885e-03_r8 /)
      kao(:, 3,14) = (/ &
        & 0.34787e-03_r8,0.34432e-03_r8,0.34112e-03_r8,0.34052e-03_r8,0.33589e-03_r8 /)
      kao(:, 4,14) = (/ &
        & 0.37401e-03_r8,0.37027e-03_r8,0.36696e-03_r8,0.36394e-03_r8,0.36355e-03_r8 /)
      kao(:, 5,14) = (/ &
        & 0.39840e-03_r8,0.39446e-03_r8,0.39082e-03_r8,0.38763e-03_r8,0.38760e-03_r8 /)
      kao(:, 6,14) = (/ &
        & 0.42165e-03_r8,0.41729e-03_r8,0.41335e-03_r8,0.41006e-03_r8,0.40721e-03_r8 /)
      kao(:, 7,14) = (/ &
        & 0.44257e-03_r8,0.43782e-03_r8,0.43364e-03_r8,0.43014e-03_r8,0.42736e-03_r8 /)
      kao(:, 8,14) = (/ &
        & 0.45299e-03_r8,0.44953e-03_r8,0.44586e-03_r8,0.44260e-03_r8,0.44006e-03_r8 /)
      kao(:, 9,14) = (/ &
        & 0.40190e-03_r8,0.39751e-03_r8,0.39238e-03_r8,0.38812e-03_r8,0.38612e-03_r8 /)
      kao(:,10,14) = (/ &
        & 0.64278e-05_r8,0.18248e-05_r8,0.16996e-05_r8,0.31086e-06_r8,0.16836e-06_r8 /)
      kao(:,11,14) = (/ &
        & 0.14350e-05_r8,0.94778e-06_r8,0.41349e-06_r8,0.20817e-06_r8,0.20238e-06_r8 /)
      kao(:,12,14) = (/ &
        & 0.16805e-05_r8,0.15323e-05_r8,0.62348e-06_r8,0.99743e-07_r8,0.12977e-06_r8 /)
      kao(:,13,14) = (/ &
        & 0.16858e-05_r8,0.17103e-05_r8,0.80574e-06_r8,0.15825e-06_r8,0.15032e-06_r8 /)
      kao(:, 1,15) = (/ &
        & 0.52181e-03_r8,0.51578e-03_r8,0.51251e-03_r8,0.50356e-03_r8,0.49731e-03_r8 /)
      kao(:, 2,15) = (/ &
        & 0.59491e-03_r8,0.58822e-03_r8,0.58413e-03_r8,0.57646e-03_r8,0.56692e-03_r8 /)
      kao(:, 3,15) = (/ &
        & 0.67653e-03_r8,0.66881e-03_r8,0.66126e-03_r8,0.65540e-03_r8,0.64461e-03_r8 /)
      kao(:, 4,15) = (/ &
        & 0.76388e-03_r8,0.75456e-03_r8,0.74556e-03_r8,0.73649e-03_r8,0.72840e-03_r8 /)
      kao(:, 5,15) = (/ &
        & 0.85507e-03_r8,0.84417e-03_r8,0.83378e-03_r8,0.82338e-03_r8,0.81349e-03_r8 /)
      kao(:, 6,15) = (/ &
        & 0.95034e-03_r8,0.93798e-03_r8,0.92553e-03_r8,0.91287e-03_r8,0.89957e-03_r8 /)
      kao(:, 7,15) = (/ &
        & 0.10496e-02_r8,0.10352e-02_r8,0.10206e-02_r8,0.10054e-02_r8,0.98958e-03_r8 /)
      kao(:, 8,15) = (/ &
        & 0.11507e-02_r8,0.11337e-02_r8,0.11169e-02_r8,0.10991e-02_r8,0.10806e-02_r8 /)
      kao(:, 9,15) = (/ &
        & 0.12408e-02_r8,0.12207e-02_r8,0.11996e-02_r8,0.11773e-02_r8,0.11531e-02_r8 /)
      kao(:,10,15) = (/ &
        & 0.12042e-03_r8,0.11501e-03_r8,0.11424e-03_r8,0.11450e-03_r8,0.13219e-03_r8 /)
      kao(:,11,15) = (/ &
        & 0.68914e-06_r8,0.83960e-06_r8,0.74591e-06_r8,0.18660e-05_r8,0.32503e-05_r8 /)
      kao(:,12,15) = (/ &
        & 0.35963e-07_r8,0.46256e-06_r8,0.56223e-06_r8,0.98816e-06_r8,0.92366e-06_r8 /)
      kao(:,13,15) = (/ &
        & 0.36605e-07_r8,0.56591e-06_r8,0.84008e-06_r8,0.86042e-06_r8,0.68452e-06_r8 /)
      kao(:, 1,16) = (/ &
        & 0.76517e-03_r8,0.75944e-03_r8,0.76010e-03_r8,0.76100e-03_r8,0.76498e-03_r8 /)
      kao(:, 2,16) = (/ &
        & 0.92375e-03_r8,0.91357e-03_r8,0.90997e-03_r8,0.90997e-03_r8,0.90993e-03_r8 /)
      kao(:, 3,16) = (/ &
        & 0.11142e-02_r8,0.10974e-02_r8,0.10835e-02_r8,0.10789e-02_r8,0.10748e-02_r8 /)
      kao(:, 4,16) = (/ &
        & 0.13278e-02_r8,0.13025e-02_r8,0.12802e-02_r8,0.12631e-02_r8,0.12539e-02_r8 /)
      kao(:, 5,16) = (/ &
        & 0.15712e-02_r8,0.15343e-02_r8,0.15017e-02_r8,0.14713e-02_r8,0.14497e-02_r8 /)
      kao(:, 6,16) = (/ &
        & 0.18525e-02_r8,0.17982e-02_r8,0.17525e-02_r8,0.17101e-02_r8,0.16714e-02_r8 /)
      kao(:, 7,16) = (/ &
        & 0.21731e-02_r8,0.20986e-02_r8,0.20340e-02_r8,0.19757e-02_r8,0.19210e-02_r8 /)
      kao(:, 8,16) = (/ &
        & 0.25325e-02_r8,0.24346e-02_r8,0.23473e-02_r8,0.22687e-02_r8,0.21950e-02_r8 /)
      kao(:, 9,16) = (/ &
        & 0.29269e-02_r8,0.28006e-02_r8,0.26863e-02_r8,0.25805e-02_r8,0.24878e-02_r8 /)
      kao(:,10,16) = (/ &
        & 0.29442e-02_r8,0.27008e-02_r8,0.23913e-02_r8,0.21437e-02_r8,0.18865e-02_r8 /)
      kao(:,11,16) = (/ &
        & 0.23220e-05_r8,0.22310e-04_r8,0.48349e-04_r8,0.67183e-04_r8,0.88908e-04_r8 /)
      kao(:,12,16) = (/ &
        & 0.22857e-05_r8,0.11848e-04_r8,0.42066e-04_r8,0.67613e-04_r8,0.86033e-04_r8 /)
      kao(:,13,16) = (/ &
        & 0.22823e-05_r8,0.69105e-05_r8,0.36212e-04_r8,0.66247e-04_r8,0.85488e-04_r8 /)
  
      end subroutine sw_kgb25

! **************************************************************************
      subroutine sw_kgb26
! **************************************************************************

      use shr_kind_mod, only: r8 => shr_kind_r8

!      use parkind, only : jpim, jprb 
      use rrsw_kg26, only : sfluxrefo, raylo

      implicit none
      save

! Kurucz solar source function
      sfluxrefo(:) = (/ &
!         &     129.462_r8, 15*0._r8 /)
        &   29.0079_r8,  28.4088_r8,     20.3099_r8,  13.0283_r8 &
        &,  11.8619_r8,  9.95840_r8,     6.68696_r8,  5.38987_r8 &
        &,  3.49829_r8, 0.407693_r8,    0.299027_r8, 0.236827_r8 &
        &, 0.188502_r8, 0.163489_r8, 4.64335e-02_r8, 2.72662e-03_r8 /)

! Rayleigh extinction coefficient at all v 
      raylo(:) = (/ &
        &  1.21263e-06_r8,1.43428e-06_r8,1.67677e-06_r8,1.93255e-06_r8 &
        &, 2.19177e-06_r8,2.44195e-06_r8,2.66926e-06_r8,2.85990e-06_r8 &
        &, 3.00380e-06_r8,3.06996e-06_r8,3.08184e-06_r8,3.09172e-06_r8 &
        &, 3.09938e-06_r8,3.10456e-06_r8,3.10727e-06_r8,3.10818e-06_r8 /)

      end subroutine sw_kgb26

! **************************************************************************
      subroutine sw_kgb27
! **************************************************************************

      use shr_kind_mod, only: r8 => shr_kind_r8

!      use parkind, only : jpim, jprb 
      use rrsw_kg27, only : kao, kbo, sfluxrefo, raylo, &
                            scalekur, layreffr

      implicit none
      save

! Kurucz solar source function
! The following values were obtained using the "low resolution"
! version of the Kurucz solar source function.  For unknown reasons,
! the total irradiance in this band differs from the corresponding
! total in the "high-resolution" version of the Kurucz function.
! Therefore, below these values are scaled by the factor SCALEKUR.
      sfluxrefo(:) = (/ &
        & 14.0526_r8    , 11.4794_r8    , 8.72590_r8    , 5.56966_r8    , &
        & 3.80927_r8    , 1.57690_r8    , 1.15099_r8    , 1.10012_r8    , &
        & 0.658212_r8   , 5.86859e-02_r8, 5.56186e-02_r8, 4.68040e-02_r8, &
        & 3.64897e-02_r8, 3.58053e-02_r8, 1.38130e-02_r8, 1.90193e-03_r8 /)

! Rayleigh extinction coefficient at v = 2925 cm-1.
      raylo(:) = (/ &
        & 3.44534e-06_r8,4.14480e-06_r8,4.95069e-06_r8,5.81204e-06_r8, &
        & 6.69748e-06_r8,7.56488e-06_r8,8.36344e-06_r8,9.04135e-06_r8, &
        & 9.58324e-06_r8,9.81542e-06_r8,9.75119e-06_r8,9.74533e-06_r8, &
        & 9.74139e-06_r8,9.73525e-06_r8,9.73577e-06_r8,9.73618e-06_r8 /)

      scalekur = 50.15_r8/48.37_r8

      layreffr = 32

!     ------------------------------------------------------------------
!     The array KAO contains absorption coefs at the 16 chosen g-values 
!     for a range of pressure levels> ~100mb, temperatures, and binary
!     species parameters (see taumol.f for definition).  The first 
!     index in the array, JS, runs from 1 to 9, and corresponds to 
!     different values of the binary species parameter.  For instance, 
!     JS=1 refers to dry air, JS = 2 corresponds to the paramter value 1/8, 
!     JS = 3 corresponds to the parameter value 2/8, etc.  The second index
!     in the array, JT, which runs from 1 to 5, corresponds to different
!     temperatures.  More specifically, JT = 3 means that the data are for
!     the reference temperature TREF for this  pressure level, JT = 2 refers
!     to TREF-15, JT = 1 is for TREF-30, JT = 4 is for TREF+15, and JT = 5
!     is for TREF+30.  The third index, JP, runs from 1 to 13 and refers
!     to the JPth reference pressure level (see taumol.f for these levels
!     in mb).  The fourth index, IG, goes from 1 to 16, and indicates
!     which g-interval the absorption coefficients are for.
!     -----------------------------------------------------------------

      kao(:, 1, 1) = (/ &
        & 0.22907e+00_r8,0.25625e+00_r8,0.28779e+00_r8,0.32376e+00_r8,0.36426e+00_r8 /)
      kao(:, 2, 1) = (/ &
        & 0.21913e+00_r8,0.24445e+00_r8,0.27422e+00_r8,0.30832e+00_r8,0.34694e+00_r8 /)
      kao(:, 3, 1) = (/ &
        & 0.20602e+00_r8,0.22864e+00_r8,0.25574e+00_r8,0.28721e+00_r8,0.32310e+00_r8 /)
      kao(:, 4, 1) = (/ &
        & 0.19379e+00_r8,0.21352e+00_r8,0.23771e+00_r8,0.26643e+00_r8,0.29940e+00_r8 /)
      kao(:, 5, 1) = (/ &
        & 0.18369e+00_r8,0.20061e+00_r8,0.22200e+00_r8,0.24786e+00_r8,0.27816e+00_r8 /)
      kao(:, 6, 1) = (/ &
        & 0.17517e+00_r8,0.18920e+00_r8,0.20771e+00_r8,0.23069e+00_r8,0.25817e+00_r8 /)
      kao(:, 7, 1) = (/ &
        & 0.16888e+00_r8,0.17988e+00_r8,0.19559e+00_r8,0.21577e+00_r8,0.24042e+00_r8 /)
      kao(:, 8, 1) = (/ &
        & 0.16442e+00_r8,0.17273e+00_r8,0.18565e+00_r8,0.20315e+00_r8,0.22512e+00_r8 /)
      kao(:, 9, 1) = (/ &
        & 0.16159e+00_r8,0.16738e+00_r8,0.17752e+00_r8,0.19242e+00_r8,0.21179e+00_r8 /)
      kao(:,10, 1) = (/ &
        & 0.16037e+00_r8,0.16402e+00_r8,0.17204e+00_r8,0.18463e+00_r8,0.20183e+00_r8 /)
      kao(:,11, 1) = (/ &
        & 0.16036e+00_r8,0.16399e+00_r8,0.17198e+00_r8,0.18455e+00_r8,0.20173e+00_r8 /)
      kao(:,12, 1) = (/ &
        & 0.16036e+00_r8,0.16399e+00_r8,0.17198e+00_r8,0.18455e+00_r8,0.20173e+00_r8 /)
      kao(:,13, 1) = (/ &
        & 0.16036e+00_r8,0.16399e+00_r8,0.17198e+00_r8,0.18455e+00_r8,0.20173e+00_r8 /)
      kao(:, 1, 2) = (/ &
        & 0.20716e+01_r8,0.21925e+01_r8,0.23327e+01_r8,0.24921e+01_r8,0.26726e+01_r8 /)
      kao(:, 2, 2) = (/ &
        & 0.20272e+01_r8,0.21401e+01_r8,0.22723e+01_r8,0.24238e+01_r8,0.25950e+01_r8 /)
      kao(:, 3, 2) = (/ &
        & 0.19684e+01_r8,0.20697e+01_r8,0.21902e+01_r8,0.23301e+01_r8,0.24892e+01_r8 /)
      kao(:, 4, 2) = (/ &
        & 0.19133e+01_r8,0.20021e+01_r8,0.21101e+01_r8,0.22375e+01_r8,0.23842e+01_r8 /)
      kao(:, 5, 2) = (/ &
        & 0.18673e+01_r8,0.19441e+01_r8,0.20400e+01_r8,0.21553e+01_r8,0.22898e+01_r8 /)
      kao(:, 6, 2) = (/ &
        & 0.18277e+01_r8,0.18925e+01_r8,0.19760e+01_r8,0.20788e+01_r8,0.22009e+01_r8 /)
      kao(:, 7, 2) = (/ &
        & 0.17963e+01_r8,0.18497e+01_r8,0.19214e+01_r8,0.20121e+01_r8,0.21222e+01_r8 /)
      kao(:, 8, 2) = (/ &
        & 0.17749e+01_r8,0.18156e+01_r8,0.18763e+01_r8,0.19555e+01_r8,0.20540e+01_r8 /)
      kao(:, 9, 2) = (/ &
        & 0.17600e+01_r8,0.17885e+01_r8,0.18388e+01_r8,0.19071e+01_r8,0.19943e+01_r8 /)
      kao(:,10, 2) = (/ &
        & 0.17526e+01_r8,0.17729e+01_r8,0.18121e+01_r8,0.18716e+01_r8,0.19496e+01_r8 /)
      kao(:,11, 2) = (/ &
        & 0.17525e+01_r8,0.17727e+01_r8,0.18119e+01_r8,0.18712e+01_r8,0.19491e+01_r8 /)
      kao(:,12, 2) = (/ &
        & 0.17525e+01_r8,0.17727e+01_r8,0.18119e+01_r8,0.18712e+01_r8,0.19491e+01_r8 /)
      kao(:,13, 2) = (/ &
        & 0.17525e+01_r8,0.17727e+01_r8,0.18119e+01_r8,0.18712e+01_r8,0.19491e+01_r8 /)
      kao(:, 1, 3) = (/ &
        & 0.12189e+02_r8,0.12619e+02_r8,0.13110e+02_r8,0.13663e+02_r8,0.14275e+02_r8 /)
      kao(:, 2, 3) = (/ &
        & 0.12030e+02_r8,0.12434e+02_r8,0.12899e+02_r8,0.13427e+02_r8,0.14015e+02_r8 /)
      kao(:, 3, 3) = (/ &
        & 0.11816e+02_r8,0.12183e+02_r8,0.12611e+02_r8,0.13101e+02_r8,0.13653e+02_r8 /)
      kao(:, 4, 3) = (/ &
        & 0.11611e+02_r8,0.11938e+02_r8,0.12327e+02_r8,0.12777e+02_r8,0.13289e+02_r8 /)
      kao(:, 5, 3) = (/ &
        & 0.11437e+02_r8,0.11726e+02_r8,0.12076e+02_r8,0.12488e+02_r8,0.12961e+02_r8 /)
      kao(:, 6, 3) = (/ &
        & 0.11284e+02_r8,0.11533e+02_r8,0.11843e+02_r8,0.12215e+02_r8,0.12649e+02_r8 /)
      kao(:, 7, 3) = (/ &
        & 0.11160e+02_r8,0.11370e+02_r8,0.11641e+02_r8,0.11975e+02_r8,0.12370e+02_r8 /)
      kao(:, 8, 3) = (/ &
        & 0.11063e+02_r8,0.11237e+02_r8,0.11471e+02_r8,0.11768e+02_r8,0.12126e+02_r8 /)
      kao(:, 9, 3) = (/ &
        & 0.10990e+02_r8,0.11129e+02_r8,0.11327e+02_r8,0.11588e+02_r8,0.11910e+02_r8 /)
      kao(:,10, 3) = (/ &
        & 0.10945e+02_r8,0.11053e+02_r8,0.11223e+02_r8,0.11454e+02_r8,0.11746e+02_r8 /)
      kao(:,11, 3) = (/ &
        & 0.10945e+02_r8,0.11052e+02_r8,0.11222e+02_r8,0.11452e+02_r8,0.11744e+02_r8 /)
      kao(:,12, 3) = (/ &
        & 0.10945e+02_r8,0.11052e+02_r8,0.11222e+02_r8,0.11452e+02_r8,0.11744e+02_r8 /)
      kao(:,13, 3) = (/ &
        & 0.10945e+02_r8,0.11052e+02_r8,0.11222e+02_r8,0.11452e+02_r8,0.11744e+02_r8 /)
      kao(:, 1, 4) = (/ &
        & 0.55057e+02_r8,0.56143e+02_r8,0.57364e+02_r8,0.58719e+02_r8,0.60208e+02_r8 /)
      kao(:, 2, 4) = (/ &
        & 0.54647e+02_r8,0.55677e+02_r8,0.56842e+02_r8,0.58142e+02_r8,0.59575e+02_r8 /)
      kao(:, 3, 4) = (/ &
        & 0.54090e+02_r8,0.55039e+02_r8,0.56123e+02_r8,0.57342e+02_r8,0.58694e+02_r8 /)
      kao(:, 4, 4) = (/ &
        & 0.53548e+02_r8,0.54410e+02_r8,0.55408e+02_r8,0.56539e+02_r8,0.57805e+02_r8 /)
      kao(:, 5, 4) = (/ &
        & 0.53074e+02_r8,0.53853e+02_r8,0.54766e+02_r8,0.55813e+02_r8,0.56995e+02_r8 /)
      kao(:, 6, 4) = (/ &
        & 0.52644e+02_r8,0.53336e+02_r8,0.54162e+02_r8,0.55123e+02_r8,0.56218e+02_r8 /)
      kao(:, 7, 4) = (/ &
        & 0.52279e+02_r8,0.52887e+02_r8,0.53629e+02_r8,0.54505e+02_r8,0.55516e+02_r8 /)
      kao(:, 8, 4) = (/ &
        & 0.51979e+02_r8,0.52507e+02_r8,0.53168e+02_r8,0.53965e+02_r8,0.54895e+02_r8 /)
      kao(:, 9, 4) = (/ &
        & 0.51734e+02_r8,0.52183e+02_r8,0.52767e+02_r8,0.53485e+02_r8,0.54337e+02_r8 /)
      kao(:,10, 4) = (/ &
        & 0.51565e+02_r8,0.51948e+02_r8,0.52467e+02_r8,0.53120e+02_r8,0.53907e+02_r8 /)
      kao(:,11, 4) = (/ &
        & 0.51563e+02_r8,0.51946e+02_r8,0.52464e+02_r8,0.53116e+02_r8,0.53902e+02_r8 /)
      kao(:,12, 4) = (/ &
        & 0.51563e+02_r8,0.51946e+02_r8,0.52464e+02_r8,0.53116e+02_r8,0.53902e+02_r8 /)
      kao(:,13, 4) = (/ &
        & 0.51563e+02_r8,0.51946e+02_r8,0.52464e+02_r8,0.53116e+02_r8,0.53902e+02_r8 /)
      kao(:, 1, 5) = (/ &
        & 0.17794e+03_r8,0.17973e+03_r8,0.18164e+03_r8,0.18366e+03_r8,0.18581e+03_r8 /)
      kao(:, 2, 5) = (/ &
        & 0.17724e+03_r8,0.17898e+03_r8,0.18083e+03_r8,0.18281e+03_r8,0.18491e+03_r8 /)
      kao(:, 3, 5) = (/ &
        & 0.17624e+03_r8,0.17791e+03_r8,0.17970e+03_r8,0.18160e+03_r8,0.18363e+03_r8 /)
      kao(:, 4, 5) = (/ &
        & 0.17523e+03_r8,0.17682e+03_r8,0.17853e+03_r8,0.18036e+03_r8,0.18231e+03_r8 /)
      kao(:, 5, 5) = (/ &
        & 0.17429e+03_r8,0.17581e+03_r8,0.17744e+03_r8,0.17920e+03_r8,0.18107e+03_r8 /)
      kao(:, 6, 5) = (/ &
        & 0.17338e+03_r8,0.17482e+03_r8,0.17638e+03_r8,0.17805e+03_r8,0.17985e+03_r8 /)
      kao(:, 7, 5) = (/ &
        & 0.17253e+03_r8,0.17390e+03_r8,0.17539e+03_r8,0.17699e+03_r8,0.17871e+03_r8 /)
      kao(:, 8, 5) = (/ &
        & 0.17177e+03_r8,0.17307e+03_r8,0.17448e+03_r8,0.17601e+03_r8,0.17767e+03_r8 /)
      kao(:, 9, 5) = (/ &
        & 0.17107e+03_r8,0.17230e+03_r8,0.17364e+03_r8,0.17511e+03_r8,0.17669e+03_r8 /)
      kao(:,10, 5) = (/ &
        & 0.17052e+03_r8,0.17169e+03_r8,0.17298e+03_r8,0.17438e+03_r8,0.17591e+03_r8 /)
      kao(:,11, 5) = (/ &
        & 0.17051e+03_r8,0.17168e+03_r8,0.17297e+03_r8,0.17437e+03_r8,0.17590e+03_r8 /)
      kao(:,12, 5) = (/ &
        & 0.17051e+03_r8,0.17168e+03_r8,0.17297e+03_r8,0.17437e+03_r8,0.17590e+03_r8 /)
      kao(:,13, 5) = (/ &
        & 0.17051e+03_r8,0.17168e+03_r8,0.17297e+03_r8,0.17437e+03_r8,0.17590e+03_r8 /)
      kao(:, 1, 6) = (/ &
        & 0.37680e+05_r8,0.36801e+05_r8,0.36011e+05_r8,0.35298e+05_r8,0.34715e+05_r8 /)
      kao(:, 2, 6) = (/ &
        & 0.39286e+03_r8,0.39463e+03_r8,0.39616e+03_r8,0.39748e+03_r8,0.39858e+03_r8 /)
      kao(:, 3, 6) = (/ &
        & 0.39169e+03_r8,0.39359e+03_r8,0.39526e+03_r8,0.39671e+03_r8,0.39794e+03_r8 /)
      kao(:, 4, 6) = (/ &
        & 0.39034e+03_r8,0.39239e+03_r8,0.39421e+03_r8,0.39580e+03_r8,0.39717e+03_r8 /)
      kao(:, 5, 6) = (/ &
        & 0.38895e+03_r8,0.39113e+03_r8,0.39309e+03_r8,0.39483e+03_r8,0.39634e+03_r8 /)
      kao(:, 6, 6) = (/ &
        & 0.38742e+03_r8,0.38975e+03_r8,0.39185e+03_r8,0.39373e+03_r8,0.39539e+03_r8 /)
      kao(:, 7, 6) = (/ &
        & 0.38585e+03_r8,0.38832e+03_r8,0.39056e+03_r8,0.39258e+03_r8,0.39438e+03_r8 /)
      kao(:, 8, 6) = (/ &
        & 0.38426e+03_r8,0.38686e+03_r8,0.38924e+03_r8,0.39140e+03_r8,0.39333e+03_r8 /)
      kao(:, 9, 6) = (/ &
        & 0.38264e+03_r8,0.38538e+03_r8,0.38789e+03_r8,0.39017e+03_r8,0.39223e+03_r8 /)
      kao(:,10, 6) = (/ &
        & 0.38123e+03_r8,0.38408e+03_r8,0.38670e+03_r8,0.38909e+03_r8,0.39126e+03_r8 /)
      kao(:,11, 6) = (/ &
        & 0.38122e+03_r8,0.38406e+03_r8,0.38668e+03_r8,0.38908e+03_r8,0.39125e+03_r8 /)
      kao(:,12, 6) = (/ &
        & 0.38122e+03_r8,0.38406e+03_r8,0.38668e+03_r8,0.38908e+03_r8,0.39125e+03_r8 /)
      kao(:,13, 6) = (/ &
        & 0.38122e+03_r8,0.38406e+03_r8,0.38668e+03_r8,0.38908e+03_r8,0.39125e+03_r8 /)
      kao(:, 1, 7) = (/ &
        & 0.18202e+07_r8,0.17771e+07_r8,0.17382e+07_r8,0.17034e+07_r8,0.16716e+07_r8 /)
      kao(:, 2, 7) = (/ &
        & 0.63027e+03_r8,0.63194e+03_r8,0.63388e+03_r8,0.63607e+03_r8,0.63849e+03_r8 /)
      kao(:, 3, 7) = (/ &
        & 0.62938e+03_r8,0.63090e+03_r8,0.63268e+03_r8,0.63472e+03_r8,0.63701e+03_r8 /)
      kao(:, 4, 7) = (/ &
        & 0.62853e+03_r8,0.62989e+03_r8,0.63150e+03_r8,0.63337e+03_r8,0.63550e+03_r8 /)
      kao(:, 5, 7) = (/ &
        & 0.62781e+03_r8,0.62901e+03_r8,0.63046e+03_r8,0.63217e+03_r8,0.63413e+03_r8 /)
      kao(:, 6, 7) = (/ &
        & 0.62717e+03_r8,0.62821e+03_r8,0.62950e+03_r8,0.63104e+03_r8,0.63283e+03_r8 /)
      kao(:, 7, 7) = (/ &
        & 0.62666e+03_r8,0.62753e+03_r8,0.62867e+03_r8,0.63005e+03_r8,0.63168e+03_r8 /)
      kao(:, 8, 7) = (/ &
        & 0.62627e+03_r8,0.62698e+03_r8,0.62795e+03_r8,0.62919e+03_r8,0.63067e+03_r8 /)
      kao(:, 9, 7) = (/ &
        & 0.62600e+03_r8,0.62653e+03_r8,0.62735e+03_r8,0.62844e+03_r8,0.62978e+03_r8 /)
      kao(:,10, 7) = (/ &
        & 0.62583e+03_r8,0.62624e+03_r8,0.62692e+03_r8,0.62788e+03_r8,0.62910e+03_r8 /)
      kao(:,11, 7) = (/ &
        & 0.62583e+03_r8,0.62623e+03_r8,0.62691e+03_r8,0.62787e+03_r8,0.62909e+03_r8 /)
      kao(:,12, 7) = (/ &
        & 0.62583e+03_r8,0.62623e+03_r8,0.62691e+03_r8,0.62787e+03_r8,0.62909e+03_r8 /)
      kao(:,13, 7) = (/ &
        & 0.62583e+03_r8,0.62623e+03_r8,0.62691e+03_r8,0.62787e+03_r8,0.62909e+03_r8 /)
      kao(:, 1, 8) = (/ &
        & 0.55488e+07_r8,0.54180e+07_r8,0.53005e+07_r8,0.51943e+07_r8,0.50978e+07_r8 /)
      kao(:, 2, 8) = (/ &
        & 0.82143e+03_r8,0.82232e+03_r8,0.82327e+03_r8,0.82429e+03_r8,0.82541e+03_r8 /)
      kao(:, 3, 8) = (/ &
        & 0.82092e+03_r8,0.82177e+03_r8,0.82269e+03_r8,0.82366e+03_r8,0.82472e+03_r8 /)
      kao(:, 4, 8) = (/ &
        & 0.82041e+03_r8,0.82121e+03_r8,0.82209e+03_r8,0.82303e+03_r8,0.82402e+03_r8 /)
      kao(:, 5, 8) = (/ &
        & 0.81996e+03_r8,0.82070e+03_r8,0.82152e+03_r8,0.82243e+03_r8,0.82339e+03_r8 /)
      kao(:, 6, 8) = (/ &
        & 0.81952e+03_r8,0.82021e+03_r8,0.82098e+03_r8,0.82184e+03_r8,0.82277e+03_r8 /)
      kao(:, 7, 8) = (/ &
        & 0.81917e+03_r8,0.81977e+03_r8,0.82048e+03_r8,0.82129e+03_r8,0.82218e+03_r8 /)
      kao(:, 8, 8) = (/ &
        & 0.81881e+03_r8,0.81938e+03_r8,0.82004e+03_r8,0.82080e+03_r8,0.82163e+03_r8 /)
      kao(:, 9, 8) = (/ &
        & 0.81846e+03_r8,0.81906e+03_r8,0.81965e+03_r8,0.82035e+03_r8,0.82114e+03_r8 /)
      kao(:,10, 8) = (/ &
        & 0.81821e+03_r8,0.81877e+03_r8,0.81934e+03_r8,0.82000e+03_r8,0.82074e+03_r8 /)
      kao(:,11, 8) = (/ &
        & 0.81821e+03_r8,0.81877e+03_r8,0.81934e+03_r8,0.81999e+03_r8,0.82074e+03_r8 /)
      kao(:,12, 8) = (/ &
        & 0.81821e+03_r8,0.81877e+03_r8,0.81934e+03_r8,0.81999e+03_r8,0.82074e+03_r8 /)
      kao(:,13, 8) = (/ &
        & 0.81821e+03_r8,0.81877e+03_r8,0.81935e+03_r8,0.81999e+03_r8,0.82074e+03_r8 /)
      kao(:, 1, 9) = (/ &
        & 0.10204e+08_r8,0.99477e+07_r8,0.97209e+07_r8,0.95103e+07_r8,0.92960e+07_r8 /)
      kao(:, 2, 9) = (/ &
        & 0.95102e+03_r8,0.95144e+03_r8,0.95133e+03_r8,0.95066e+03_r8,0.94964e+03_r8 /)
      kao(:, 3, 9) = (/ &
        & 0.95048e+03_r8,0.95118e+03_r8,0.95136e+03_r8,0.95103e+03_r8,0.95020e+03_r8 /)
      kao(:, 4, 9) = (/ &
        & 0.94969e+03_r8,0.95077e+03_r8,0.95126e+03_r8,0.95124e+03_r8,0.95074e+03_r8 /)
      kao(:, 5, 9) = (/ &
        & 0.94872e+03_r8,0.95015e+03_r8,0.95101e+03_r8,0.95129e+03_r8,0.95105e+03_r8 /)
      kao(:, 6, 9) = (/ &
        & 0.94752e+03_r8,0.94929e+03_r8,0.95052e+03_r8,0.95116e+03_r8,0.95126e+03_r8 /)
      kao(:, 7, 9) = (/ &
        & 0.94612e+03_r8,0.94825e+03_r8,0.94981e+03_r8,0.95083e+03_r8,0.95126e+03_r8 /)
      kao(:, 8, 9) = (/ &
        & 0.94461e+03_r8,0.94704e+03_r8,0.94894e+03_r8,0.95029e+03_r8,0.95107e+03_r8 /)
      kao(:, 9, 9) = (/ &
        & 0.94291e+03_r8,0.94567e+03_r8,0.94791e+03_r8,0.94957e+03_r8,0.95069e+03_r8 /)
      kao(:,10, 9) = (/ &
        & 0.94135e+03_r8,0.94441e+03_r8,0.94689e+03_r8,0.94884e+03_r8,0.95022e+03_r8 /)
      kao(:,11, 9) = (/ &
        & 0.94133e+03_r8,0.94440e+03_r8,0.94688e+03_r8,0.94883e+03_r8,0.95021e+03_r8 /)
      kao(:,12, 9) = (/ &
        & 0.94133e+03_r8,0.94438e+03_r8,0.94688e+03_r8,0.94883e+03_r8,0.95021e+03_r8 /)
      kao(:,13, 9) = (/ &
        & 0.94133e+03_r8,0.94438e+03_r8,0.94687e+03_r8,0.94883e+03_r8,0.95021e+03_r8 /)
      kao(:, 1,10) = (/ &
        & 0.12764e+08_r8,0.12408e+08_r8,0.12012e+08_r8,0.11438e+08_r8,0.11217e+08_r8 /)
      kao(:, 2,10) = (/ &
        & 0.99589e+03_r8,0.99493e+03_r8,0.99263e+03_r8,0.98974e+03_r8,0.98742e+03_r8 /)
      kao(:, 3,10) = (/ &
        & 0.99532e+03_r8,0.99571e+03_r8,0.99447e+03_r8,0.99207e+03_r8,0.98779e+03_r8 /)
      kao(:, 4,10) = (/ &
        & 0.99446e+03_r8,0.99559e+03_r8,0.99536e+03_r8,0.99386e+03_r8,0.99088e+03_r8 /)
      kao(:, 5,10) = (/ &
        & 0.99288e+03_r8,0.99493e+03_r8,0.99558e+03_r8,0.99487e+03_r8,0.99336e+03_r8 /)
      kao(:, 6,10) = (/ &
        & 0.99069e+03_r8,0.99366e+03_r8,0.99519e+03_r8,0.99534e+03_r8,0.99428e+03_r8 /)
      kao(:, 7,10) = (/ &
        & 0.98811e+03_r8,0.99191e+03_r8,0.99430e+03_r8,0.99510e+03_r8,0.99504e+03_r8 /)
      kao(:, 8,10) = (/ &
        & 0.98531e+03_r8,0.98996e+03_r8,0.99300e+03_r8,0.99479e+03_r8,0.99513e+03_r8 /)
      kao(:, 9,10) = (/ &
        & 0.98264e+03_r8,0.98737e+03_r8,0.99138e+03_r8,0.99390e+03_r8,0.99503e+03_r8 /)
      kao(:,10,10) = (/ &
        & 0.98010e+03_r8,0.98517e+03_r8,0.98974e+03_r8,0.99281e+03_r8,0.99470e+03_r8 /)
      kao(:,11,10) = (/ &
        & 0.98010e+03_r8,0.98509e+03_r8,0.98985e+03_r8,0.99280e+03_r8,0.99468e+03_r8 /)
      kao(:,12,10) = (/ &
        & 0.98035e+03_r8,0.98524e+03_r8,0.98973e+03_r8,0.99279e+03_r8,0.99468e+03_r8 /)
      kao(:,13,10) = (/ &
        & 0.98012e+03_r8,0.98526e+03_r8,0.98973e+03_r8,0.99279e+03_r8,0.99468e+03_r8 /)
      kao(:, 1,11) = (/ &
        & 0.12266e+08_r8,0.12000e+08_r8,0.11724e+08_r8,0.11828e+08_r8,0.11523e+08_r8 /)
      kao(:, 2,11) = (/ &
        & 0.10001e+04_r8,0.99984e+03_r8,0.99745e+03_r8,0.99535e+03_r8,0.98599e+03_r8 /)
      kao(:, 3,11) = (/ &
        & 0.99963e+03_r8,0.99927e+03_r8,0.99848e+03_r8,0.99596e+03_r8,0.99390e+03_r8 /)
      kao(:, 4,11) = (/ &
        & 0.99904e+03_r8,0.99942e+03_r8,0.99870e+03_r8,0.99747e+03_r8,0.99542e+03_r8 /)
      kao(:, 5,11) = (/ &
        & 0.99826e+03_r8,0.99927e+03_r8,0.99919e+03_r8,0.99821e+03_r8,0.99627e+03_r8 /)
      kao(:, 6,11) = (/ &
        & 0.99730e+03_r8,0.99882e+03_r8,0.99938e+03_r8,0.99902e+03_r8,0.99764e+03_r8 /)
      kao(:, 7,11) = (/ &
        & 0.99551e+03_r8,0.99810e+03_r8,0.99919e+03_r8,0.99961e+03_r8,0.99863e+03_r8 /)
      kao(:, 8,11) = (/ &
        & 0.99324e+03_r8,0.99688e+03_r8,0.99871e+03_r8,0.99940e+03_r8,0.99942e+03_r8 /)
      kao(:, 9,11) = (/ &
        & 0.99058e+03_r8,0.99489e+03_r8,0.99773e+03_r8,0.99912e+03_r8,0.99954e+03_r8 /)
      kao(:,10,11) = (/ &
        & 0.98802e+03_r8,0.99297e+03_r8,0.99656e+03_r8,0.99861e+03_r8,0.99937e+03_r8 /)
      kao(:,11,11) = (/ &
        & 0.98800e+03_r8,0.99310e+03_r8,0.99655e+03_r8,0.99860e+03_r8,0.99936e+03_r8 /)
      kao(:,12,11) = (/ &
        & 0.98771e+03_r8,0.99296e+03_r8,0.99669e+03_r8,0.99859e+03_r8,0.99936e+03_r8 /)
      kao(:,13,11) = (/ &
        & 0.98800e+03_r8,0.99296e+03_r8,0.99655e+03_r8,0.99859e+03_r8,0.99936e+03_r8 /)
      kao(:, 1,12) = (/ &
        & 0.12503e+08_r8,0.11946e+08_r8,0.11557e+08_r8,0.11503e+08_r8,0.11901e+08_r8 /)
      kao(:, 2,12) = (/ &
        & 0.10015e+04_r8,0.10004e+04_r8,0.99932e+03_r8,0.99373e+03_r8,0.98591e+03_r8 /)
      kao(:, 3,12) = (/ &
        & 0.10024e+04_r8,0.10021e+04_r8,0.10003e+04_r8,0.99817e+03_r8,0.99146e+03_r8 /)
      kao(:, 4,12) = (/ &
        & 0.10022e+04_r8,0.10027e+04_r8,0.10021e+04_r8,0.99956e+03_r8,0.99610e+03_r8 /)
      kao(:, 5,12) = (/ &
        & 0.10024e+04_r8,0.10024e+04_r8,0.10028e+04_r8,0.10015e+04_r8,0.99826e+03_r8 /)
      kao(:, 6,12) = (/ &
        & 0.10017e+04_r8,0.10025e+04_r8,0.10025e+04_r8,0.10023e+04_r8,0.10008e+04_r8 /)
      kao(:, 7,12) = (/ &
        & 0.10005e+04_r8,0.10020e+04_r8,0.10028e+04_r8,0.10028e+04_r8,0.10019e+04_r8 /)
      kao(:, 8,12) = (/ &
        & 0.10000e+04_r8,0.10010e+04_r8,0.10024e+04_r8,0.10029e+04_r8,0.10023e+04_r8 /)
      kao(:, 9,12) = (/ &
        & 0.99906e+03_r8,0.10004e+04_r8,0.10018e+04_r8,0.10029e+04_r8,0.10028e+04_r8 /)
      kao(:,10,12) = (/ &
        & 0.99791e+03_r8,0.99989e+03_r8,0.10010e+04_r8,0.10024e+04_r8,0.10031e+04_r8 /)
      kao(:,11,12) = (/ &
        & 0.99769e+03_r8,0.99967e+03_r8,0.10008e+04_r8,0.10024e+04_r8,0.10029e+04_r8 /)
      kao(:,12,12) = (/ &
        & 0.99787e+03_r8,0.99985e+03_r8,0.10008e+04_r8,0.10025e+04_r8,0.10029e+04_r8 /)
      kao(:,13,12) = (/ &
        & 0.99768e+03_r8,0.99984e+03_r8,0.10012e+04_r8,0.10026e+04_r8,0.10029e+04_r8 /)
      kao(:, 1,13) = (/ &
        & 0.12359e+08_r8,0.12469e+08_r8,0.12868e+08_r8,0.12776e+08_r8,0.12590e+08_r8 /)
      kao(:, 2,13) = (/ &
        & 0.10045e+04_r8,0.10033e+04_r8,0.99840e+03_r8,0.99184e+03_r8,0.98861e+03_r8 /)
      kao(:, 3,13) = (/ &
        & 0.10050e+04_r8,0.10041e+04_r8,0.10024e+04_r8,0.99701e+03_r8,0.99083e+03_r8 /)
      kao(:, 4,13) = (/ &
        & 0.10053e+04_r8,0.10043e+04_r8,0.10035e+04_r8,0.10017e+04_r8,0.99538e+03_r8 /)
      kao(:, 5,13) = (/ &
        & 0.10048e+04_r8,0.10056e+04_r8,0.10038e+04_r8,0.10026e+04_r8,0.10008e+04_r8 /)
      kao(:, 6,13) = (/ &
        & 0.10042e+04_r8,0.10054e+04_r8,0.10054e+04_r8,0.10039e+04_r8,0.10017e+04_r8 /)
      kao(:, 7,13) = (/ &
        & 0.10029e+04_r8,0.10046e+04_r8,0.10055e+04_r8,0.10046e+04_r8,0.10033e+04_r8 /)
      kao(:, 8,13) = (/ &
        & 0.10002e+04_r8,0.10039e+04_r8,0.10051e+04_r8,0.10054e+04_r8,0.10046e+04_r8 /)
      kao(:, 9,13) = (/ &
        & 0.99825e+03_r8,0.10019e+04_r8,0.10043e+04_r8,0.10051e+04_r8,0.10052e+04_r8 /)
      kao(:,10,13) = (/ &
        & 0.99595e+03_r8,0.99983e+03_r8,0.10034e+04_r8,0.10050e+04_r8,0.10051e+04_r8 /)
      kao(:,11,13) = (/ &
        & 0.99621e+03_r8,0.99979e+03_r8,0.10034e+04_r8,0.10050e+04_r8,0.10054e+04_r8 /)
      kao(:,12,13) = (/ &
        & 0.99597e+03_r8,0.99979e+03_r8,0.10031e+04_r8,0.10047e+04_r8,0.10054e+04_r8 /)
      kao(:,13,13) = (/ &
        & 0.99623e+03_r8,0.99978e+03_r8,0.10031e+04_r8,0.10047e+04_r8,0.10054e+04_r8 /)
      kao(:, 1,14) = (/ &
        & 0.13636e+08_r8,0.13818e+08_r8,0.13518e+08_r8,0.13266e+08_r8,0.13048e+08_r8 /)
      kao(:, 2,14) = (/ &
        & 0.10049e+04_r8,0.99946e+03_r8,0.99774e+03_r8,0.99774e+03_r8,0.99771e+03_r8 /)
      kao(:, 3,14) = (/ &
        & 0.10051e+04_r8,0.10068e+04_r8,0.10007e+04_r8,0.99775e+03_r8,0.99778e+03_r8 /)
      kao(:, 4,14) = (/ &
        & 0.10071e+04_r8,0.10061e+04_r8,0.10050e+04_r8,0.10005e+04_r8,0.99776e+03_r8 /)
      kao(:, 5,14) = (/ &
        & 0.10067e+04_r8,0.10072e+04_r8,0.10061e+04_r8,0.10044e+04_r8,0.99972e+03_r8 /)
      kao(:, 6,14) = (/ &
        & 0.10049e+04_r8,0.10070e+04_r8,0.10074e+04_r8,0.10057e+04_r8,0.10037e+04_r8 /)
      kao(:, 7,14) = (/ &
        & 0.10033e+04_r8,0.10063e+04_r8,0.10072e+04_r8,0.10067e+04_r8,0.10050e+04_r8 /)
      kao(:, 8,14) = (/ &
        & 0.10025e+04_r8,0.10048e+04_r8,0.10068e+04_r8,0.10071e+04_r8,0.10062e+04_r8 /)
      kao(:, 9,14) = (/ &
        & 0.99880e+03_r8,0.10031e+04_r8,0.10060e+04_r8,0.10071e+04_r8,0.10069e+04_r8 /)
      kao(:,10,14) = (/ &
        & 0.99610e+03_r8,0.10023e+04_r8,0.10047e+04_r8,0.10067e+04_r8,0.10072e+04_r8 /)
      kao(:,11,14) = (/ &
        & 0.99601e+03_r8,0.10023e+04_r8,0.10047e+04_r8,0.10067e+04_r8,0.10072e+04_r8 /)
      kao(:,12,14) = (/ &
        & 0.99598e+03_r8,0.10023e+04_r8,0.10051e+04_r8,0.10067e+04_r8,0.10076e+04_r8 /)
      kao(:,13,14) = (/ &
        & 0.99596e+03_r8,0.10027e+04_r8,0.10047e+04_r8,0.10067e+04_r8,0.10072e+04_r8 /)
      kao(:, 1,15) = (/ &
        & 0.14285e+08_r8,0.13947e+08_r8,0.13644e+08_r8,0.13317e+08_r8,0.13015e+08_r8 /)
      kao(:, 2,15) = (/ &
        & 0.99932e+03_r8,0.10011e+04_r8,0.10018e+04_r8,0.10007e+04_r8,0.99706e+03_r8 /)
      kao(:, 3,15) = (/ &
        & 0.10097e+04_r8,0.99743e+03_r8,0.10015e+04_r8,0.10018e+04_r8,0.99920e+03_r8 /)
      kao(:, 4,15) = (/ &
        & 0.10099e+04_r8,0.10076e+04_r8,0.10030e+04_r8,0.10017e+04_r8,0.10013e+04_r8 /)
      kao(:, 5,15) = (/ &
        & 0.10075e+04_r8,0.10079e+04_r8,0.10073e+04_r8,0.10035e+04_r8,0.10018e+04_r8 /)
      kao(:, 6,15) = (/ &
        & 0.10068e+04_r8,0.10088e+04_r8,0.10068e+04_r8,0.10090e+04_r8,0.10033e+04_r8 /)
      kao(:, 7,15) = (/ &
        & 0.10057e+04_r8,0.10073e+04_r8,0.10090e+04_r8,0.10087e+04_r8,0.10062e+04_r8 /)
      kao(:, 8,15) = (/ &
        & 0.10010e+04_r8,0.10054e+04_r8,0.10076e+04_r8,0.10079e+04_r8,0.10072e+04_r8 /)
      kao(:, 9,15) = (/ &
        & 0.99853e+03_r8,0.10054e+04_r8,0.10071e+04_r8,0.10079e+04_r8,0.10078e+04_r8 /)
      kao(:,10,15) = (/ &
        & 0.99742e+03_r8,0.10007e+04_r8,0.10064e+04_r8,0.10076e+04_r8,0.10080e+04_r8 /)
      kao(:,11,15) = (/ &
        & 0.99635e+03_r8,0.10006e+04_r8,0.10064e+04_r8,0.10087e+04_r8,0.10090e+04_r8 /)
      kao(:,12,15) = (/ &
        & 0.99635e+03_r8,0.10006e+04_r8,0.10064e+04_r8,0.10087e+04_r8,0.10069e+04_r8 /)
      kao(:,13,15) = (/ &
        & 0.99635e+03_r8,0.99960e+03_r8,0.10064e+04_r8,0.10076e+04_r8,0.10080e+04_r8 /)
      kao(:, 1,16) = (/ &
        & 0.14326e+08_r8,0.13988e+08_r8,0.13684e+08_r8,0.13409e+08_r8,0.13021e+08_r8 /)
      kao(:, 2,16) = (/ &
        & 0.10008e+04_r8,0.10027e+04_r8,0.10036e+04_r8,0.10037e+04_r8,0.99673e+03_r8 /)
      kao(:, 3,16) = (/ &
        & 0.99286e+03_r8,0.10016e+04_r8,0.10031e+04_r8,0.10038e+04_r8,0.10035e+04_r8 /)
      kao(:, 4,16) = (/ &
        & 0.99278e+03_r8,0.10078e+04_r8,0.10023e+04_r8,0.10035e+04_r8,0.10038e+04_r8 /)
      kao(:, 5,16) = (/ &
        & 0.10074e+04_r8,0.10079e+04_r8,0.10075e+04_r8,0.10028e+04_r8,0.10037e+04_r8 /)
      kao(:, 6,16) = (/ &
        & 0.10069e+04_r8,0.10002e+04_r8,0.10079e+04_r8,0.99212e+03_r8,0.10032e+04_r8 /)
      kao(:, 7,16) = (/ &
        & 0.10060e+04_r8,0.10072e+04_r8,0.10004e+04_r8,0.10003e+04_r8,0.10063e+04_r8 /)
      kao(:, 8,16) = (/ &
        & 0.10009e+04_r8,0.10066e+04_r8,0.10075e+04_r8,0.10080e+04_r8,0.10074e+04_r8 /)
      kao(:, 9,16) = (/ &
        & 0.99860e+03_r8,0.10057e+04_r8,0.10071e+04_r8,0.10078e+04_r8,0.10079e+04_r8 /)
      kao(:,10,16) = (/ &
        & 0.98908e+03_r8,0.10006e+04_r8,0.10065e+04_r8,0.10075e+04_r8,0.10080e+04_r8 /)
      kao(:,11,16) = (/ &
        & 0.99644e+03_r8,0.10006e+04_r8,0.10065e+04_r8,0.10000e+04_r8,0.10005e+04_r8 /)
      kao(:,12,16) = (/ &
        & 0.99644e+03_r8,0.10006e+04_r8,0.10065e+04_r8,0.10000e+04_r8,0.10080e+04_r8 /)
      kao(:,13,16) = (/ &
        & 0.99644e+03_r8,0.10006e+04_r8,0.10065e+04_r8,0.10075e+04_r8,0.10080e+04_r8 /)
  
!     -----------------------------------------------------------------
!     The array KBO contains absorption coefs at the 16 chosen g-values 
!     for a range of pressure levels < ~100mb and temperatures. The first 
!     index in the array, JT, which runs from 1 to 5, corresponds to 
!     different temperatures.  More specifically, JT = 3 means that the 
!     data are for the reference temperature TREF for this pressure 
!     level, JT = 2 refers to the temperature TREF-15, JT = 1 is for
!     TREF-30, JT = 4 is for TREF+15, and JT = 5 is for TREF+30.  
!     The second index, JP, runs from 13 to 59 and refers to the JPth
!     reference pressure level (see taumol.f for the value of these
!     pressure levels in mb).  The third index, IG, goes from 1 to 16,
!     and tells us which g-interval the absorption coefficients are for.
!     -----------------------------------------------------------------
  
      kbo(:,13, 1) = (/ &
        & 0.16036e+00_r8,0.16399e+00_r8,0.17198e+00_r8,0.18455e+00_r8,0.20173e+00_r8 /)
      kbo(:,14, 1) = (/ &
        & 0.16050e+00_r8,0.16454e+00_r8,0.17292e+00_r8,0.18592e+00_r8,0.20351e+00_r8 /)
      kbo(:,15, 1) = (/ &
        & 0.16071e+00_r8,0.16519e+00_r8,0.17400e+00_r8,0.18750e+00_r8,0.20554e+00_r8 /)
      kbo(:,16, 1) = (/ &
        & 0.16098e+00_r8,0.16593e+00_r8,0.17517e+00_r8,0.18921e+00_r8,0.20772e+00_r8 /)
      kbo(:,17, 1) = (/ &
        & 0.16129e+00_r8,0.16670e+00_r8,0.17642e+00_r8,0.19093e+00_r8,0.20991e+00_r8 /)
      kbo(:,18, 1) = (/ &
        & 0.16164e+00_r8,0.16750e+00_r8,0.17771e+00_r8,0.19267e+00_r8,0.21211e+00_r8 /)
      kbo(:,19, 1) = (/ &
        & 0.16203e+00_r8,0.16832e+00_r8,0.17901e+00_r8,0.19443e+00_r8,0.21431e+00_r8 /)
      kbo(:,20, 1) = (/ &
        & 0.16255e+00_r8,0.16934e+00_r8,0.18059e+00_r8,0.19653e+00_r8,0.21694e+00_r8 /)
      kbo(:,21, 1) = (/ &
        & 0.16313e+00_r8,0.17044e+00_r8,0.18225e+00_r8,0.19873e+00_r8,0.21967e+00_r8 /)
      kbo(:,22, 1) = (/ &
        & 0.16416e+00_r8,0.17227e+00_r8,0.18498e+00_r8,0.20229e+00_r8,0.22406e+00_r8 /)
      kbo(:,23, 1) = (/ &
        & 0.16539e+00_r8,0.17431e+00_r8,0.18796e+00_r8,0.20612e+00_r8,0.22875e+00_r8 /)
      kbo(:,24, 1) = (/ &
        & 0.16684e+00_r8,0.17666e+00_r8,0.19125e+00_r8,0.21032e+00_r8,0.23385e+00_r8 /)
      kbo(:,25, 1) = (/ &
        & 0.16856e+00_r8,0.17939e+00_r8,0.19493e+00_r8,0.21495e+00_r8,0.23943e+00_r8 /)
      kbo(:,26, 1) = (/ &
        & 0.17067e+00_r8,0.18260e+00_r8,0.19919e+00_r8,0.22024e+00_r8,0.24578e+00_r8 /)
      kbo(:,27, 1) = (/ &
        & 0.17306e+00_r8,0.18613e+00_r8,0.20377e+00_r8,0.22588e+00_r8,0.25248e+00_r8 /)
      kbo(:,28, 1) = (/ &
        & 0.17570e+00_r8,0.18994e+00_r8,0.20865e+00_r8,0.23184e+00_r8,0.25952e+00_r8 /)
      kbo(:,29, 1) = (/ &
        & 0.17882e+00_r8,0.19417e+00_r8,0.21399e+00_r8,0.23828e+00_r8,0.26708e+00_r8 /)
      kbo(:,30, 1) = (/ &
        & 0.18223e+00_r8,0.19870e+00_r8,0.21964e+00_r8,0.24505e+00_r8,0.27492e+00_r8 /)
      kbo(:,31, 1) = (/ &
        & 0.18602e+00_r8,0.20364e+00_r8,0.22572e+00_r8,0.25229e+00_r8,0.28325e+00_r8 /)
      kbo(:,32, 1) = (/ &
        & 0.19018e+00_r8,0.20895e+00_r8,0.23219e+00_r8,0.25994e+00_r8,0.29200e+00_r8 /)
      kbo(:,33, 1) = (/ &
        & 0.19466e+00_r8,0.21461e+00_r8,0.23902e+00_r8,0.26795e+00_r8,0.30114e+00_r8 /)
      kbo(:,34, 1) = (/ &
        & 0.19880e+00_r8,0.21976e+00_r8,0.24520e+00_r8,0.27509e+00_r8,0.30932e+00_r8 /)
      kbo(:,35, 1) = (/ &
        & 0.20129e+00_r8,0.22283e+00_r8,0.24886e+00_r8,0.27931e+00_r8,0.31412e+00_r8 /)
      kbo(:,36, 1) = (/ &
        & 0.20170e+00_r8,0.22334e+00_r8,0.24946e+00_r8,0.28000e+00_r8,0.31492e+00_r8 /)
      kbo(:,37, 1) = (/ &
        & 0.19920e+00_r8,0.22026e+00_r8,0.24579e+00_r8,0.27578e+00_r8,0.31010e+00_r8 /)
      kbo(:,38, 1) = (/ &
        & 0.19662e+00_r8,0.21706e+00_r8,0.24197e+00_r8,0.27135e+00_r8,0.30504e+00_r8 /)
      kbo(:,39, 1) = (/ &
        & 0.19414e+00_r8,0.21396e+00_r8,0.23824e+00_r8,0.26704e+00_r8,0.30010e+00_r8 /)
      kbo(:,40, 1) = (/ &
        & 0.19003e+00_r8,0.20877e+00_r8,0.23197e+00_r8,0.25968e+00_r8,0.29171e+00_r8 /)
      kbo(:,41, 1) = (/ &
        & 0.18597e+00_r8,0.20357e+00_r8,0.22564e+00_r8,0.25219e+00_r8,0.28314e+00_r8 /)
      kbo(:,42, 1) = (/ &
        & 0.18220e+00_r8,0.19865e+00_r8,0.21958e+00_r8,0.24498e+00_r8,0.27484e+00_r8 /)
      kbo(:,43, 1) = (/ &
        & 0.17798e+00_r8,0.19304e+00_r8,0.21257e+00_r8,0.23657e+00_r8,0.26510e+00_r8 /)
      kbo(:,44, 1) = (/ &
        & 0.17397e+00_r8,0.18746e+00_r8,0.20548e+00_r8,0.22798e+00_r8,0.25496e+00_r8 /)
      kbo(:,45, 1) = (/ &
        & 0.17053e+00_r8,0.18239e+00_r8,0.19890e+00_r8,0.21989e+00_r8,0.24535e+00_r8 /)
      kbo(:,46, 1) = (/ &
        & 0.16739e+00_r8,0.17754e+00_r8,0.19245e+00_r8,0.21183e+00_r8,0.23568e+00_r8 /)
      kbo(:,47, 1) = (/ &
        & 0.16454e+00_r8,0.17292e+00_r8,0.18592e+00_r8,0.20351e+00_r8,0.22556e+00_r8 /)
      kbo(:,48, 1) = (/ &
        & 0.16239e+00_r8,0.16903e+00_r8,0.18011e+00_r8,0.19590e+00_r8,0.21615e+00_r8 /)
      kbo(:,49, 1) = (/ &
        & 0.16095e+00_r8,0.16584e+00_r8,0.17504e+00_r8,0.18902e+00_r8,0.20747e+00_r8 /)
      kbo(:,50, 1) = (/ &
        & 0.16025e+00_r8,0.16348e+00_r8,0.17109e+00_r8,0.18322e+00_r8,0.20000e+00_r8 /)
      kbo(:,51, 1) = (/ &
        & 0.16021e+00_r8,0.16179e+00_r8,0.16781e+00_r8,0.17821e+00_r8,0.19335e+00_r8 /)
      kbo(:,52, 1) = (/ &
        & 0.16078e+00_r8,0.16068e+00_r8,0.16511e+00_r8,0.17387e+00_r8,0.18731e+00_r8 /)
      kbo(:,53, 1) = (/ &
        & 0.16197e+00_r8,0.16018e+00_r8,0.16299e+00_r8,0.17017e+00_r8,0.18186e+00_r8 /)
      kbo(:,54, 1) = (/ &
        & 0.16362e+00_r8,0.16026e+00_r8,0.16155e+00_r8,0.16729e+00_r8,0.17738e+00_r8 /)
      kbo(:,55, 1) = (/ &
        & 0.16570e+00_r8,0.16083e+00_r8,0.16064e+00_r8,0.16498e+00_r8,0.17365e+00_r8 /)
      kbo(:,56, 1) = (/ &
        & 0.16825e+00_r8,0.16187e+00_r8,0.16020e+00_r8,0.16311e+00_r8,0.17041e+00_r8 /)
      kbo(:,57, 1) = (/ &
        & 0.17129e+00_r8,0.16340e+00_r8,0.16023e+00_r8,0.16169e+00_r8,0.16761e+00_r8 /)
      kbo(:,58, 1) = (/ &
        & 0.17462e+00_r8,0.16529e+00_r8,0.16069e+00_r8,0.16077e+00_r8,0.16535e+00_r8 /)
      kbo(:,59, 1) = (/ &
        & 0.17607e+00_r8,0.16617e+00_r8,0.16100e+00_r8,0.16051e+00_r8,0.16456e+00_r8 /)
      kbo(:,13, 2) = (/ &
        & 0.17525e+01_r8,0.17727e+01_r8,0.18119e+01_r8,0.18712e+01_r8,0.19491e+01_r8 /)
      kbo(:,14, 2) = (/ &
        & 0.17536e+01_r8,0.17755e+01_r8,0.18165e+01_r8,0.18775e+01_r8,0.19571e+01_r8 /)
      kbo(:,15, 2) = (/ &
        & 0.17549e+01_r8,0.17787e+01_r8,0.18219e+01_r8,0.18847e+01_r8,0.19662e+01_r8 /)
      kbo(:,16, 2) = (/ &
        & 0.17565e+01_r8,0.17819e+01_r8,0.18278e+01_r8,0.18925e+01_r8,0.19761e+01_r8 /)
      kbo(:,17, 2) = (/ &
        & 0.17583e+01_r8,0.17850e+01_r8,0.18336e+01_r8,0.19003e+01_r8,0.19859e+01_r8 /)
      kbo(:,18, 2) = (/ &
        & 0.17603e+01_r8,0.17891e+01_r8,0.18396e+01_r8,0.19082e+01_r8,0.19957e+01_r8 /)
      kbo(:,19, 2) = (/ &
        & 0.17624e+01_r8,0.17934e+01_r8,0.18457e+01_r8,0.19162e+01_r8,0.20056e+01_r8 /)
      kbo(:,20, 2) = (/ &
        & 0.17652e+01_r8,0.17986e+01_r8,0.18530e+01_r8,0.19257e+01_r8,0.20174e+01_r8 /)
      kbo(:,21, 2) = (/ &
        & 0.17683e+01_r8,0.18042e+01_r8,0.18607e+01_r8,0.19356e+01_r8,0.20296e+01_r8 /)
      kbo(:,22, 2) = (/ &
        & 0.17736e+01_r8,0.18133e+01_r8,0.18732e+01_r8,0.19516e+01_r8,0.20492e+01_r8 /)
      kbo(:,23, 2) = (/ &
        & 0.17796e+01_r8,0.18234e+01_r8,0.18868e+01_r8,0.19689e+01_r8,0.20702e+01_r8 /)
      kbo(:,24, 2) = (/ &
        & 0.17857e+01_r8,0.18347e+01_r8,0.19018e+01_r8,0.19877e+01_r8,0.20929e+01_r8 /)
      kbo(:,25, 2) = (/ &
        & 0.17946e+01_r8,0.18475e+01_r8,0.19185e+01_r8,0.20085e+01_r8,0.21178e+01_r8 /)
      kbo(:,26, 2) = (/ &
        & 0.18053e+01_r8,0.18623e+01_r8,0.19377e+01_r8,0.20322e+01_r8,0.21460e+01_r8 /)
      kbo(:,27, 2) = (/ &
        & 0.18172e+01_r8,0.18785e+01_r8,0.19583e+01_r8,0.20574e+01_r8,0.21757e+01_r8 /)
      kbo(:,28, 2) = (/ &
        & 0.18303e+01_r8,0.18959e+01_r8,0.19802e+01_r8,0.20839e+01_r8,0.22069e+01_r8 /)
      kbo(:,29, 2) = (/ &
        & 0.18448e+01_r8,0.19150e+01_r8,0.20042e+01_r8,0.21126e+01_r8,0.22404e+01_r8 /)
      kbo(:,30, 2) = (/ &
        & 0.18606e+01_r8,0.19355e+01_r8,0.20295e+01_r8,0.21428e+01_r8,0.22754e+01_r8 /)
      kbo(:,31, 2) = (/ &
        & 0.18780e+01_r8,0.19577e+01_r8,0.20566e+01_r8,0.21749e+01_r8,0.23125e+01_r8 /)
      kbo(:,32, 2) = (/ &
        & 0.18969e+01_r8,0.19816e+01_r8,0.20855e+01_r8,0.22088e+01_r8,0.23514e+01_r8 /)
      kbo(:,33, 2) = (/ &
        & 0.19172e+01_r8,0.20069e+01_r8,0.21160e+01_r8,0.22443e+01_r8,0.23920e+01_r8 /)
      kbo(:,34, 2) = (/ &
        & 0.19359e+01_r8,0.20300e+01_r8,0.21434e+01_r8,0.22762e+01_r8,0.24282e+01_r8 /)
      kbo(:,35, 2) = (/ &
        & 0.19471e+01_r8,0.20437e+01_r8,0.21597e+01_r8,0.22949e+01_r8,0.24495e+01_r8 /)
      kbo(:,36, 2) = (/ &
        & 0.19490e+01_r8,0.20460e+01_r8,0.21624e+01_r8,0.22980e+01_r8,0.24530e+01_r8 /)
      kbo(:,37, 2) = (/ &
        & 0.19377e+01_r8,0.20322e+01_r8,0.21461e+01_r8,0.22792e+01_r8,0.24317e+01_r8 /)
      kbo(:,38, 2) = (/ &
        & 0.19261e+01_r8,0.20179e+01_r8,0.21291e+01_r8,0.22595e+01_r8,0.24093e+01_r8 /)
      kbo(:,39, 2) = (/ &
        & 0.19149e+01_r8,0.20040e+01_r8,0.21125e+01_r8,0.22402e+01_r8,0.23873e+01_r8 /)
      kbo(:,40, 2) = (/ &
        & 0.18963e+01_r8,0.19807e+01_r8,0.20845e+01_r8,0.22076e+01_r8,0.23501e+01_r8 /)
      kbo(:,41, 2) = (/ &
        & 0.18778e+01_r8,0.19574e+01_r8,0.20563e+01_r8,0.21745e+01_r8,0.23120e+01_r8 /)
      kbo(:,42, 2) = (/ &
        & 0.18604e+01_r8,0.19352e+01_r8,0.20292e+01_r8,0.21425e+01_r8,0.22750e+01_r8 /)
      kbo(:,43, 2) = (/ &
        & 0.18409e+01_r8,0.19099e+01_r8,0.19978e+01_r8,0.21050e+01_r8,0.22315e+01_r8 /)
      kbo(:,44, 2) = (/ &
        & 0.18217e+01_r8,0.18845e+01_r8,0.19660e+01_r8,0.20667e+01_r8,0.21867e+01_r8 /)
      kbo(:,45, 2) = (/ &
        & 0.18046e+01_r8,0.18613e+01_r8,0.19364e+01_r8,0.20306e+01_r8,0.21441e+01_r8 /)
      kbo(:,46, 2) = (/ &
        & 0.17886e+01_r8,0.18389e+01_r8,0.19072e+01_r8,0.19945e+01_r8,0.21011e+01_r8 /)
      kbo(:,47, 2) = (/ &
        & 0.17755e+01_r8,0.18165e+01_r8,0.18775e+01_r8,0.19571e+01_r8,0.20559e+01_r8 /)
      kbo(:,48, 2) = (/ &
        & 0.17644e+01_r8,0.17970e+01_r8,0.18508e+01_r8,0.19228e+01_r8,0.20139e+01_r8 /)
      kbo(:,49, 2) = (/ &
        & 0.17563e+01_r8,0.17816e+01_r8,0.18271e+01_r8,0.18916e+01_r8,0.19749e+01_r8 /)
      kbo(:,50, 2) = (/ &
        & 0.17517e+01_r8,0.17702e+01_r8,0.18074e+01_r8,0.18651e+01_r8,0.19413e+01_r8 /)
      kbo(:,51, 2) = (/ &
        & 0.17504e+01_r8,0.17611e+01_r8,0.17908e+01_r8,0.18420e+01_r8,0.19113e+01_r8 /)
      kbo(:,52, 2) = (/ &
        & 0.17523e+01_r8,0.17547e+01_r8,0.17783e+01_r8,0.18212e+01_r8,0.18839e+01_r8 /)
      kbo(:,53, 2) = (/ &
        & 0.17566e+01_r8,0.17510e+01_r8,0.17675e+01_r8,0.18028e+01_r8,0.18589e+01_r8 /)
      kbo(:,54, 2) = (/ &
        & 0.17623e+01_r8,0.17507e+01_r8,0.17598e+01_r8,0.17881e+01_r8,0.18381e+01_r8 /)
      kbo(:,55, 2) = (/ &
        & 0.17691e+01_r8,0.17524e+01_r8,0.17544e+01_r8,0.17777e+01_r8,0.18201e+01_r8 /)
      kbo(:,56, 2) = (/ &
        & 0.17776e+01_r8,0.17562e+01_r8,0.17512e+01_r8,0.17682e+01_r8,0.18040e+01_r8 /)
      kbo(:,57, 2) = (/ &
        & 0.17881e+01_r8,0.17616e+01_r8,0.17505e+01_r8,0.17606e+01_r8,0.17897e+01_r8 /)
      kbo(:,58, 2) = (/ &
        & 0.17996e+01_r8,0.17678e+01_r8,0.17520e+01_r8,0.17552e+01_r8,0.17794e+01_r8 /)
      kbo(:,59, 2) = (/ &
        & 0.18045e+01_r8,0.17707e+01_r8,0.17530e+01_r8,0.17536e+01_r8,0.17756e+01_r8 /)
      kbo(:,13, 3) = (/ &
        & 0.10945e+02_r8,0.11052e+02_r8,0.11222e+02_r8,0.11452e+02_r8,0.11744e+02_r8 /)
      kbo(:,14, 3) = (/ &
        & 0.10952e+02_r8,0.11065e+02_r8,0.11240e+02_r8,0.11476e+02_r8,0.11774e+02_r8 /)
      kbo(:,15, 3) = (/ &
        & 0.10961e+02_r8,0.11080e+02_r8,0.11261e+02_r8,0.11503e+02_r8,0.11807e+02_r8 /)
      kbo(:,16, 3) = (/ &
        & 0.10971e+02_r8,0.11097e+02_r8,0.11284e+02_r8,0.11533e+02_r8,0.11844e+02_r8 /)
      kbo(:,17, 3) = (/ &
        & 0.10981e+02_r8,0.11115e+02_r8,0.11307e+02_r8,0.11562e+02_r8,0.11879e+02_r8 /)
      kbo(:,18, 3) = (/ &
        & 0.10992e+02_r8,0.11132e+02_r8,0.11331e+02_r8,0.11592e+02_r8,0.11915e+02_r8 /)
      kbo(:,19, 3) = (/ &
        & 0.11003e+02_r8,0.11149e+02_r8,0.11354e+02_r8,0.11622e+02_r8,0.11951e+02_r8 /)
      kbo(:,20, 3) = (/ &
        & 0.11017e+02_r8,0.11170e+02_r8,0.11382e+02_r8,0.11657e+02_r8,0.11994e+02_r8 /)
      kbo(:,21, 3) = (/ &
        & 0.11031e+02_r8,0.11192e+02_r8,0.11412e+02_r8,0.11694e+02_r8,0.12038e+02_r8 /)
      kbo(:,22, 3) = (/ &
        & 0.11056e+02_r8,0.11228e+02_r8,0.11460e+02_r8,0.11754e+02_r8,0.12109e+02_r8 /)
      kbo(:,23, 3) = (/ &
        & 0.11085e+02_r8,0.11267e+02_r8,0.11511e+02_r8,0.11817e+02_r8,0.12184e+02_r8 /)
      kbo(:,24, 3) = (/ &
        & 0.11118e+02_r8,0.11312e+02_r8,0.11568e+02_r8,0.11886e+02_r8,0.12266e+02_r8 /)
      kbo(:,25, 3) = (/ &
        & 0.11154e+02_r8,0.11361e+02_r8,0.11630e+02_r8,0.11962e+02_r8,0.12354e+02_r8 /)
      kbo(:,26, 3) = (/ &
        & 0.11196e+02_r8,0.11418e+02_r8,0.11702e+02_r8,0.12048e+02_r8,0.12455e+02_r8 /)
      kbo(:,27, 3) = (/ &
        & 0.11243e+02_r8,0.11480e+02_r8,0.11778e+02_r8,0.12138e+02_r8,0.12560e+02_r8 /)
      kbo(:,28, 3) = (/ &
        & 0.11294e+02_r8,0.11545e+02_r8,0.11859e+02_r8,0.12234e+02_r8,0.12670e+02_r8 /)
      kbo(:,29, 3) = (/ &
        & 0.11351e+02_r8,0.11617e+02_r8,0.11946e+02_r8,0.12336e+02_r8,0.12788e+02_r8 /)
      kbo(:,30, 3) = (/ &
        & 0.11411e+02_r8,0.11694e+02_r8,0.12038e+02_r8,0.12443e+02_r8,0.12910e+02_r8 /)
      kbo(:,31, 3) = (/ &
        & 0.11478e+02_r8,0.11776e+02_r8,0.12136e+02_r8,0.12557e+02_r8,0.13040e+02_r8 /)
      kbo(:,32, 3) = (/ &
        & 0.11549e+02_r8,0.11864e+02_r8,0.12239e+02_r8,0.12677e+02_r8,0.13175e+02_r8 /)
      kbo(:,33, 3) = (/ &
        & 0.11626e+02_r8,0.11956e+02_r8,0.12348e+02_r8,0.12801e+02_r8,0.13316e+02_r8 /)
      kbo(:,34, 3) = (/ &
        & 0.11695e+02_r8,0.12040e+02_r8,0.12446e+02_r8,0.12913e+02_r8,0.13442e+02_r8 /)
      kbo(:,35, 3) = (/ &
        & 0.11737e+02_r8,0.12089e+02_r8,0.12503e+02_r8,0.12979e+02_r8,0.13515e+02_r8 /)
      kbo(:,36, 3) = (/ &
        & 0.11744e+02_r8,0.12098e+02_r8,0.12513e+02_r8,0.12989e+02_r8,0.13528e+02_r8 /)
      kbo(:,37, 3) = (/ &
        & 0.11702e+02_r8,0.12048e+02_r8,0.12455e+02_r8,0.12924e+02_r8,0.13454e+02_r8 /)
      kbo(:,38, 3) = (/ &
        & 0.11659e+02_r8,0.11996e+02_r8,0.12395e+02_r8,0.12855e+02_r8,0.13376e+02_r8 /)
      kbo(:,39, 3) = (/ &
        & 0.11617e+02_r8,0.11946e+02_r8,0.12336e+02_r8,0.12787e+02_r8,0.13300e+02_r8 /)
      kbo(:,40, 3) = (/ &
        & 0.11547e+02_r8,0.11861e+02_r8,0.12236e+02_r8,0.12673e+02_r8,0.13171e+02_r8 /)
      kbo(:,41, 3) = (/ &
        & 0.11477e+02_r8,0.11775e+02_r8,0.12134e+02_r8,0.12555e+02_r8,0.13038e+02_r8 /)
      kbo(:,42, 3) = (/ &
        & 0.11411e+02_r8,0.11693e+02_r8,0.12037e+02_r8,0.12442e+02_r8,0.12909e+02_r8 /)
      kbo(:,43, 3) = (/ &
        & 0.11335e+02_r8,0.11598e+02_r8,0.11923e+02_r8,0.12309e+02_r8,0.12757e+02_r8 /)
      kbo(:,44, 3) = (/ &
        & 0.11261e+02_r8,0.11503e+02_r8,0.11807e+02_r8,0.12172e+02_r8,0.12599e+02_r8 /)
      kbo(:,45, 3) = (/ &
        & 0.11193e+02_r8,0.11414e+02_r8,0.11697e+02_r8,0.12042e+02_r8,0.12448e+02_r8 /)
      kbo(:,46, 3) = (/ &
        & 0.11129e+02_r8,0.11328e+02_r8,0.11588e+02_r8,0.11911e+02_r8,0.12295e+02_r8 /)
      kbo(:,47, 3) = (/ &
        & 0.11065e+02_r8,0.11240e+02_r8,0.11476e+02_r8,0.11774e+02_r8,0.12133e+02_r8 /)
      kbo(:,48, 3) = (/ &
        & 0.11012e+02_r8,0.11163e+02_r8,0.11374e+02_r8,0.11647e+02_r8,0.11981e+02_r8 /)
      kbo(:,49, 3) = (/ &
        & 0.10969e+02_r8,0.11095e+02_r8,0.11282e+02_r8,0.11530e+02_r8,0.11839e+02_r8 /)
      kbo(:,50, 3) = (/ &
        & 0.10938e+02_r8,0.11040e+02_r8,0.11204e+02_r8,0.11429e+02_r8,0.11715e+02_r8 /)
      kbo(:,51, 3) = (/ &
        & 0.10916e+02_r8,0.10996e+02_r8,0.11138e+02_r8,0.11340e+02_r8,0.11604e+02_r8 /)
      kbo(:,52, 3) = (/ &
        & 0.10900e+02_r8,0.10960e+02_r8,0.11079e+02_r8,0.11259e+02_r8,0.11500e+02_r8 /)
      kbo(:,53, 3) = (/ &
        & 0.10894e+02_r8,0.10932e+02_r8,0.11028e+02_r8,0.11186e+02_r8,0.11405e+02_r8 /)
      kbo(:,54, 3) = (/ &
        & 0.10895e+02_r8,0.10912e+02_r8,0.10989e+02_r8,0.11127e+02_r8,0.11325e+02_r8 /)
      kbo(:,55, 3) = (/ &
        & 0.10903e+02_r8,0.10900e+02_r8,0.10958e+02_r8,0.11075e+02_r8,0.11255e+02_r8 /)
      kbo(:,56, 3) = (/ &
        & 0.10921e+02_r8,0.10894e+02_r8,0.10933e+02_r8,0.11031e+02_r8,0.11191e+02_r8 /)
      kbo(:,57, 3) = (/ &
        & 0.10944e+02_r8,0.10894e+02_r8,0.10914e+02_r8,0.10993e+02_r8,0.11134e+02_r8 /)
      kbo(:,58, 3) = (/ &
        & 0.10972e+02_r8,0.10901e+02_r8,0.10902e+02_r8,0.10963e+02_r8,0.11084e+02_r8 /)
      kbo(:,59, 3) = (/ &
        & 0.10984e+02_r8,0.10906e+02_r8,0.10898e+02_r8,0.10952e+02_r8,0.11066e+02_r8 /)
      kbo(:,13, 4) = (/ &
        & 0.51563e+02_r8,0.51946e+02_r8,0.52464e+02_r8,0.53116e+02_r8,0.53902e+02_r8 /)
      kbo(:,14, 4) = (/ &
        & 0.51593e+02_r8,0.51987e+02_r8,0.52517e+02_r8,0.53182e+02_r8,0.53980e+02_r8 /)
      kbo(:,15, 4) = (/ &
        & 0.51626e+02_r8,0.52035e+02_r8,0.52579e+02_r8,0.53256e+02_r8,0.54069e+02_r8 /)
      kbo(:,16, 4) = (/ &
        & 0.51664e+02_r8,0.52087e+02_r8,0.52644e+02_r8,0.53337e+02_r8,0.54163e+02_r8 /)
      kbo(:,17, 4) = (/ &
        & 0.51701e+02_r8,0.52138e+02_r8,0.52710e+02_r8,0.53416e+02_r8,0.54257e+02_r8 /)
      kbo(:,18, 4) = (/ &
        & 0.51740e+02_r8,0.52191e+02_r8,0.52776e+02_r8,0.53496e+02_r8,0.54351e+02_r8 /)
      kbo(:,19, 4) = (/ &
        & 0.51779e+02_r8,0.52244e+02_r8,0.52843e+02_r8,0.53576e+02_r8,0.54444e+02_r8 /)
      kbo(:,20, 4) = (/ &
        & 0.51827e+02_r8,0.52307e+02_r8,0.52922e+02_r8,0.53671e+02_r8,0.54555e+02_r8 /)
      kbo(:,21, 4) = (/ &
        & 0.51877e+02_r8,0.52373e+02_r8,0.53004e+02_r8,0.53770e+02_r8,0.54669e+02_r8 /)
      kbo(:,22, 4) = (/ &
        & 0.51959e+02_r8,0.52481e+02_r8,0.53136e+02_r8,0.53927e+02_r8,0.54851e+02_r8 /)
      kbo(:,23, 4) = (/ &
        & 0.52049e+02_r8,0.52596e+02_r8,0.53278e+02_r8,0.54094e+02_r8,0.55044e+02_r8 /)
      kbo(:,24, 4) = (/ &
        & 0.52148e+02_r8,0.52723e+02_r8,0.53431e+02_r8,0.54274e+02_r8,0.55252e+02_r8 /)
      kbo(:,25, 4) = (/ &
        & 0.52259e+02_r8,0.52862e+02_r8,0.53599e+02_r8,0.54471e+02_r8,0.55477e+02_r8 /)
      kbo(:,26, 4) = (/ &
        & 0.52387e+02_r8,0.53022e+02_r8,0.53790e+02_r8,0.54693e+02_r8,0.55730e+02_r8 /)
      kbo(:,27, 4) = (/ &
        & 0.52525e+02_r8,0.53191e+02_r8,0.53992e+02_r8,0.54926e+02_r8,0.55995e+02_r8 /)
      kbo(:,28, 4) = (/ &
        & 0.52672e+02_r8,0.53371e+02_r8,0.54203e+02_r8,0.55170e+02_r8,0.56271e+02_r8 /)
      kbo(:,29, 4) = (/ &
        & 0.52833e+02_r8,0.53565e+02_r8,0.54430e+02_r8,0.55430e+02_r8,0.56565e+02_r8 /)
      kbo(:,30, 4) = (/ &
        & 0.53003e+02_r8,0.53768e+02_r8,0.54668e+02_r8,0.55702e+02_r8,0.56870e+02_r8 /)
      kbo(:,31, 4) = (/ &
        & 0.53186e+02_r8,0.53986e+02_r8,0.54920e+02_r8,0.55988e+02_r8,0.57190e+02_r8 /)
      kbo(:,32, 4) = (/ &
        & 0.53381e+02_r8,0.54216e+02_r8,0.55184e+02_r8,0.56287e+02_r8,0.57525e+02_r8 /)
      kbo(:,33, 4) = (/ &
        & 0.53587e+02_r8,0.54457e+02_r8,0.55460e+02_r8,0.56599e+02_r8,0.57871e+02_r8 /)
      kbo(:,34, 4) = (/ &
        & 0.53773e+02_r8,0.54673e+02_r8,0.55707e+02_r8,0.56876e+02_r8,0.58179e+02_r8 /)
      kbo(:,35, 4) = (/ &
        & 0.53883e+02_r8,0.54800e+02_r8,0.55852e+02_r8,0.57039e+02_r8,0.58359e+02_r8 /)
      kbo(:,36, 4) = (/ &
        & 0.53901e+02_r8,0.54822e+02_r8,0.55876e+02_r8,0.57066e+02_r8,0.58389e+02_r8 /)
      kbo(:,37, 4) = (/ &
        & 0.53791e+02_r8,0.54694e+02_r8,0.55731e+02_r8,0.56903e+02_r8,0.58208e+02_r8 /)
      kbo(:,38, 4) = (/ &
        & 0.53676e+02_r8,0.54560e+02_r8,0.55578e+02_r8,0.56731e+02_r8,0.58018e+02_r8 /)
      kbo(:,39, 4) = (/ &
        & 0.53563e+02_r8,0.54429e+02_r8,0.55429e+02_r8,0.56563e+02_r8,0.57832e+02_r8 /)
      kbo(:,40, 4) = (/ &
        & 0.53375e+02_r8,0.54208e+02_r8,0.55175e+02_r8,0.56277e+02_r8,0.57513e+02_r8 /)
      kbo(:,41, 4) = (/ &
        & 0.53184e+02_r8,0.53983e+02_r8,0.54916e+02_r8,0.55984e+02_r8,0.57186e+02_r8 /)
      kbo(:,42, 4) = (/ &
        & 0.53001e+02_r8,0.53766e+02_r8,0.54665e+02_r8,0.55699e+02_r8,0.56866e+02_r8 /)
      kbo(:,43, 4) = (/ &
        & 0.52790e+02_r8,0.53513e+02_r8,0.54370e+02_r8,0.55362e+02_r8,0.56488e+02_r8 /)
      kbo(:,44, 4) = (/ &
        & 0.52577e+02_r8,0.53254e+02_r8,0.54066e+02_r8,0.55012e+02_r8,0.56093e+02_r8 /)
      kbo(:,45, 4) = (/ &
        & 0.52379e+02_r8,0.53011e+02_r8,0.53777e+02_r8,0.54678e+02_r8,0.55713e+02_r8 /)
      kbo(:,46, 4) = (/ &
        & 0.52184e+02_r8,0.52768e+02_r8,0.53486e+02_r8,0.54339e+02_r8,0.55326e+02_r8 /)
      kbo(:,47, 4) = (/ &
        & 0.51987e+02_r8,0.52517e+02_r8,0.53182e+02_r8,0.53980e+02_r8,0.54913e+02_r8 /)
      kbo(:,48, 4) = (/ &
        & 0.51812e+02_r8,0.52288e+02_r8,0.52898e+02_r8,0.53643e+02_r8,0.54522e+02_r8 /)
      kbo(:,49, 4) = (/ &
        & 0.51659e+02_r8,0.52081e+02_r8,0.52637e+02_r8,0.53327e+02_r8,0.54152e+02_r8 /)
      kbo(:,50, 4) = (/ &
        & 0.51535e+02_r8,0.51906e+02_r8,0.52412e+02_r8,0.53052e+02_r8,0.53826e+02_r8 /)
      kbo(:,51, 4) = (/ &
        & 0.51433e+02_r8,0.51755e+02_r8,0.52211e+02_r8,0.52802e+02_r8,0.53527e+02_r8 /)
      kbo(:,52, 4) = (/ &
        & 0.51349e+02_r8,0.51622e+02_r8,0.52029e+02_r8,0.52571e+02_r8,0.53247e+02_r8 /)
      kbo(:,53, 4) = (/ &
        & 0.51285e+02_r8,0.51507e+02_r8,0.51865e+02_r8,0.52358e+02_r8,0.52985e+02_r8 /)
      kbo(:,54, 4) = (/ &
        & 0.51240e+02_r8,0.51417e+02_r8,0.51730e+02_r8,0.52178e+02_r8,0.52760e+02_r8 /)
      kbo(:,55, 4) = (/ &
        & 0.51211e+02_r8,0.51346e+02_r8,0.51615e+02_r8,0.52020e+02_r8,0.52559e+02_r8 /)
      kbo(:,56, 4) = (/ &
        & 0.51194e+02_r8,0.51288e+02_r8,0.51514e+02_r8,0.51875e+02_r8,0.52371e+02_r8 /)
      kbo(:,57, 4) = (/ &
        & 0.51190e+02_r8,0.51245e+02_r8,0.51426e+02_r8,0.51746e+02_r8,0.52198e+02_r8 /)
      kbo(:,58, 4) = (/ &
        & 0.51200e+02_r8,0.51216e+02_r8,0.51357e+02_r8,0.51635e+02_r8,0.52046e+02_r8 /)
      kbo(:,59, 4) = (/ &
        & 0.51207e+02_r8,0.51207e+02_r8,0.51333e+02_r8,0.51594e+02_r8,0.51989e+02_r8 /)
      kbo(:,13, 5) = (/ &
        & 0.17051e+03_r8,0.17168e+03_r8,0.17297e+03_r8,0.17437e+03_r8,0.17590e+03_r8 /)
      kbo(:,14, 5) = (/ &
        & 0.17061e+03_r8,0.17179e+03_r8,0.17309e+03_r8,0.17451e+03_r8,0.17604e+03_r8 /)
      kbo(:,15, 5) = (/ &
        & 0.17073e+03_r8,0.17192e+03_r8,0.17323e+03_r8,0.17466e+03_r8,0.17621e+03_r8 /)
      kbo(:,16, 5) = (/ &
        & 0.17085e+03_r8,0.17205e+03_r8,0.17338e+03_r8,0.17482e+03_r8,0.17638e+03_r8 /)
      kbo(:,17, 5) = (/ &
        & 0.17097e+03_r8,0.17218e+03_r8,0.17352e+03_r8,0.17497e+03_r8,0.17655e+03_r8 /)
      kbo(:,18, 5) = (/ &
        & 0.17109e+03_r8,0.17232e+03_r8,0.17366e+03_r8,0.17513e+03_r8,0.17671e+03_r8 /)
      kbo(:,19, 5) = (/ &
        & 0.17121e+03_r8,0.17245e+03_r8,0.17381e+03_r8,0.17528e+03_r8,0.17688e+03_r8 /)
      kbo(:,20, 5) = (/ &
        & 0.17134e+03_r8,0.17260e+03_r8,0.17397e+03_r8,0.17547e+03_r8,0.17708e+03_r8 /)
      kbo(:,21, 5) = (/ &
        & 0.17149e+03_r8,0.17276e+03_r8,0.17415e+03_r8,0.17565e+03_r8,0.17728e+03_r8 /)
      kbo(:,22, 5) = (/ &
        & 0.17172e+03_r8,0.17301e+03_r8,0.17442e+03_r8,0.17594e+03_r8,0.17759e+03_r8 /)
      kbo(:,23, 5) = (/ &
        & 0.17195e+03_r8,0.17327e+03_r8,0.17470e+03_r8,0.17625e+03_r8,0.17792e+03_r8 /)
      kbo(:,24, 5) = (/ &
        & 0.17221e+03_r8,0.17355e+03_r8,0.17500e+03_r8,0.17658e+03_r8,0.17827e+03_r8 /)
      kbo(:,25, 5) = (/ &
        & 0.17248e+03_r8,0.17385e+03_r8,0.17533e+03_r8,0.17693e+03_r8,0.17865e+03_r8 /)
      kbo(:,26, 5) = (/ &
        & 0.17279e+03_r8,0.17418e+03_r8,0.17569e+03_r8,0.17732e+03_r8,0.17906e+03_r8 /)
      kbo(:,27, 5) = (/ &
        & 0.17311e+03_r8,0.17453e+03_r8,0.17606e+03_r8,0.17772e+03_r8,0.17949e+03_r8 /)
      kbo(:,28, 5) = (/ &
        & 0.17344e+03_r8,0.17488e+03_r8,0.17645e+03_r8,0.17813e+03_r8,0.17994e+03_r8 /)
      kbo(:,29, 5) = (/ &
        & 0.17379e+03_r8,0.17526e+03_r8,0.17686e+03_r8,0.17857e+03_r8,0.18040e+03_r8 /)
      kbo(:,30, 5) = (/ &
        & 0.17414e+03_r8,0.17565e+03_r8,0.17727e+03_r8,0.17902e+03_r8,0.18088e+03_r8 /)
      kbo(:,31, 5) = (/ &
        & 0.17452e+03_r8,0.17605e+03_r8,0.17771e+03_r8,0.17948e+03_r8,0.18137e+03_r8 /)
      kbo(:,32, 5) = (/ &
        & 0.17491e+03_r8,0.17647e+03_r8,0.17816e+03_r8,0.17996e+03_r8,0.18188e+03_r8 /)
      kbo(:,33, 5) = (/ &
        & 0.17531e+03_r8,0.17690e+03_r8,0.17862e+03_r8,0.18045e+03_r8,0.18241e+03_r8 /)
      kbo(:,34, 5) = (/ &
        & 0.17566e+03_r8,0.17728e+03_r8,0.17903e+03_r8,0.18089e+03_r8,0.18287e+03_r8 /)
      kbo(:,35, 5) = (/ &
        & 0.17586e+03_r8,0.17750e+03_r8,0.17926e+03_r8,0.18114e+03_r8,0.18313e+03_r8 /)
      kbo(:,36, 5) = (/ &
        & 0.17590e+03_r8,0.17754e+03_r8,0.17930e+03_r8,0.18118e+03_r8,0.18318e+03_r8 /)
      kbo(:,37, 5) = (/ &
        & 0.17569e+03_r8,0.17732e+03_r8,0.17906e+03_r8,0.18093e+03_r8,0.18291e+03_r8 /)
      kbo(:,38, 5) = (/ &
        & 0.17547e+03_r8,0.17708e+03_r8,0.17881e+03_r8,0.18066e+03_r8,0.18263e+03_r8 /)
      kbo(:,39, 5) = (/ &
        & 0.17526e+03_r8,0.17685e+03_r8,0.17857e+03_r8,0.18040e+03_r8,0.18235e+03_r8 /)
      kbo(:,40, 5) = (/ &
        & 0.17489e+03_r8,0.17646e+03_r8,0.17814e+03_r8,0.17995e+03_r8,0.18187e+03_r8 /)
      kbo(:,41, 5) = (/ &
        & 0.17451e+03_r8,0.17605e+03_r8,0.17770e+03_r8,0.17948e+03_r8,0.18137e+03_r8 /)
      kbo(:,42, 5) = (/ &
        & 0.17414e+03_r8,0.17565e+03_r8,0.17727e+03_r8,0.17901e+03_r8,0.18087e+03_r8 /)
      kbo(:,43, 5) = (/ &
        & 0.17369e+03_r8,0.17516e+03_r8,0.17675e+03_r8,0.17846e+03_r8,0.18028e+03_r8 /)
      kbo(:,44, 5) = (/ &
        & 0.17323e+03_r8,0.17465e+03_r8,0.17620e+03_r8,0.17787e+03_r8,0.17965e+03_r8 /)
      kbo(:,45, 5) = (/ &
        & 0.17277e+03_r8,0.17416e+03_r8,0.17567e+03_r8,0.17729e+03_r8,0.17904e+03_r8 /)
      kbo(:,46, 5) = (/ &
        & 0.17230e+03_r8,0.17365e+03_r8,0.17511e+03_r8,0.17669e+03_r8,0.17840e+03_r8 /)
      kbo(:,47, 5) = (/ &
        & 0.17179e+03_r8,0.17309e+03_r8,0.17451e+03_r8,0.17604e+03_r8,0.17770e+03_r8 /)
      kbo(:,48, 5) = (/ &
        & 0.17130e+03_r8,0.17255e+03_r8,0.17392e+03_r8,0.17541e+03_r8,0.17702e+03_r8 /)
      kbo(:,49, 5) = (/ &
        & 0.17083e+03_r8,0.17204e+03_r8,0.17336e+03_r8,0.17480e+03_r8,0.17636e+03_r8 /)
      kbo(:,50, 5) = (/ &
        & 0.17041e+03_r8,0.17157e+03_r8,0.17285e+03_r8,0.17424e+03_r8,0.17576e+03_r8 /)
      kbo(:,51, 5) = (/ &
        & 0.17002e+03_r8,0.17113e+03_r8,0.17237e+03_r8,0.17372e+03_r8,0.17519e+03_r8 /)
      kbo(:,52, 5) = (/ &
        & 0.16964e+03_r8,0.17071e+03_r8,0.17190e+03_r8,0.17321e+03_r8,0.17464e+03_r8 /)
      kbo(:,53, 5) = (/ &
        & 0.16927e+03_r8,0.17031e+03_r8,0.17145e+03_r8,0.17272e+03_r8,0.17411e+03_r8 /)
      kbo(:,54, 5) = (/ &
        & 0.16896e+03_r8,0.16995e+03_r8,0.17106e+03_r8,0.17228e+03_r8,0.17363e+03_r8 /)
      kbo(:,55, 5) = (/ &
        & 0.16866e+03_r8,0.16962e+03_r8,0.17069e+03_r8,0.17188e+03_r8,0.17318e+03_r8 /)
      kbo(:,56, 5) = (/ &
        & 0.16839e+03_r8,0.16930e+03_r8,0.17033e+03_r8,0.17148e+03_r8,0.17275e+03_r8 /)
      kbo(:,57, 5) = (/ &
        & 0.16812e+03_r8,0.16899e+03_r8,0.16999e+03_r8,0.17110e+03_r8,0.17233e+03_r8 /)
      kbo(:,58, 5) = (/ &
        & 0.16788e+03_r8,0.16871e+03_r8,0.16968e+03_r8,0.17075e+03_r8,0.17195e+03_r8 /)
      kbo(:,59, 5) = (/ &
        & 0.16779e+03_r8,0.16861e+03_r8,0.16955e+03_r8,0.17062e+03_r8,0.17180e+03_r8 /)
      kbo(:,13, 6) = (/ &
        & 0.38122e+03_r8,0.38406e+03_r8,0.38668e+03_r8,0.38908e+03_r8,0.39125e+03_r8 /)
      kbo(:,14, 6) = (/ &
        & 0.38148e+03_r8,0.38431e+03_r8,0.38691e+03_r8,0.38929e+03_r8,0.39144e+03_r8 /)
      kbo(:,15, 6) = (/ &
        & 0.38178e+03_r8,0.38458e+03_r8,0.38716e+03_r8,0.38951e+03_r8,0.39164e+03_r8 /)
      kbo(:,16, 6) = (/ &
        & 0.38209e+03_r8,0.38487e+03_r8,0.38742e+03_r8,0.38975e+03_r8,0.39186e+03_r8 /)
      kbo(:,17, 6) = (/ &
        & 0.38239e+03_r8,0.38514e+03_r8,0.38767e+03_r8,0.38998e+03_r8,0.39206e+03_r8 /)
      kbo(:,18, 6) = (/ &
        & 0.38268e+03_r8,0.38541e+03_r8,0.38792e+03_r8,0.39020e+03_r8,0.39226e+03_r8 /)
      kbo(:,19, 6) = (/ &
        & 0.38297e+03_r8,0.38568e+03_r8,0.38816e+03_r8,0.39042e+03_r8,0.39246e+03_r8 /)
      kbo(:,20, 6) = (/ &
        & 0.38330e+03_r8,0.38598e+03_r8,0.38844e+03_r8,0.39067e+03_r8,0.39268e+03_r8 /)
      kbo(:,21, 6) = (/ &
        & 0.38363e+03_r8,0.38629e+03_r8,0.38872e+03_r8,0.39092e+03_r8,0.39291e+03_r8 /)
      kbo(:,22, 6) = (/ &
        & 0.38414e+03_r8,0.38675e+03_r8,0.38914e+03_r8,0.39131e+03_r8,0.39325e+03_r8 /)
      kbo(:,23, 6) = (/ &
        & 0.38466e+03_r8,0.38723e+03_r8,0.38958e+03_r8,0.39170e+03_r8,0.39360e+03_r8 /)
      kbo(:,24, 6) = (/ &
        & 0.38520e+03_r8,0.38772e+03_r8,0.39002e+03_r8,0.39210e+03_r8,0.39395e+03_r8 /)
      kbo(:,25, 6) = (/ &
        & 0.38575e+03_r8,0.38823e+03_r8,0.39048e+03_r8,0.39251e+03_r8,0.39432e+03_r8 /)
      kbo(:,26, 6) = (/ &
        & 0.38635e+03_r8,0.38877e+03_r8,0.39098e+03_r8,0.39295e+03_r8,0.39470e+03_r8 /)
      kbo(:,27, 6) = (/ &
        & 0.38694e+03_r8,0.38932e+03_r8,0.39146e+03_r8,0.39339e+03_r8,0.39509e+03_r8 /)
      kbo(:,28, 6) = (/ &
        & 0.38753e+03_r8,0.38985e+03_r8,0.39194e+03_r8,0.39381e+03_r8,0.39546e+03_r8 /)
      kbo(:,29, 6) = (/ &
        & 0.38813e+03_r8,0.39039e+03_r8,0.39243e+03_r8,0.39424e+03_r8,0.39583e+03_r8 /)
      kbo(:,30, 6) = (/ &
        & 0.38871e+03_r8,0.39092e+03_r8,0.39290e+03_r8,0.39466e+03_r8,0.39620e+03_r8 /)
      kbo(:,31, 6) = (/ &
        & 0.38930e+03_r8,0.39145e+03_r8,0.39338e+03_r8,0.39508e+03_r8,0.39655e+03_r8 /)
      kbo(:,32, 6) = (/ &
        & 0.38988e+03_r8,0.39197e+03_r8,0.39384e+03_r8,0.39548e+03_r8,0.39690e+03_r8 /)
      kbo(:,33, 6) = (/ &
        & 0.39045e+03_r8,0.39248e+03_r8,0.39429e+03_r8,0.39587e+03_r8,0.39723e+03_r8 /)
      kbo(:,34, 6) = (/ &
        & 0.39093e+03_r8,0.39291e+03_r8,0.39467e+03_r8,0.39620e+03_r8,0.39751e+03_r8 /)
      kbo(:,35, 6) = (/ &
        & 0.39120e+03_r8,0.39316e+03_r8,0.39488e+03_r8,0.39639e+03_r8,0.39766e+03_r8 /)
      kbo(:,36, 6) = (/ &
        & 0.39125e+03_r8,0.39320e+03_r8,0.39492e+03_r8,0.39642e+03_r8,0.39769e+03_r8 /)
      kbo(:,37, 6) = (/ &
        & 0.39098e+03_r8,0.39295e+03_r8,0.39471e+03_r8,0.39623e+03_r8,0.39754e+03_r8 /)
      kbo(:,38, 6) = (/ &
        & 0.39068e+03_r8,0.39269e+03_r8,0.39447e+03_r8,0.39603e+03_r8,0.39737e+03_r8 /)
      kbo(:,39, 6) = (/ &
        & 0.39039e+03_r8,0.39243e+03_r8,0.39424e+03_r8,0.39583e+03_r8,0.39720e+03_r8 /)
      kbo(:,40, 6) = (/ &
        & 0.38986e+03_r8,0.39196e+03_r8,0.39382e+03_r8,0.39547e+03_r8,0.39689e+03_r8 /)
      kbo(:,41, 6) = (/ &
        & 0.38929e+03_r8,0.39144e+03_r8,0.39337e+03_r8,0.39507e+03_r8,0.39655e+03_r8 /)
      kbo(:,42, 6) = (/ &
        & 0.38871e+03_r8,0.39092e+03_r8,0.39290e+03_r8,0.39466e+03_r8,0.39619e+03_r8 /)
      kbo(:,43, 6) = (/ &
        & 0.38797e+03_r8,0.39025e+03_r8,0.39230e+03_r8,0.39413e+03_r8,0.39574e+03_r8 /)
      kbo(:,44, 6) = (/ &
        & 0.38715e+03_r8,0.38951e+03_r8,0.39164e+03_r8,0.39354e+03_r8,0.39522e+03_r8 /)
      kbo(:,45, 6) = (/ &
        & 0.38631e+03_r8,0.38874e+03_r8,0.39094e+03_r8,0.39292e+03_r8,0.39468e+03_r8 /)
      kbo(:,46, 6) = (/ &
        & 0.38538e+03_r8,0.38789e+03_r8,0.39018e+03_r8,0.39224e+03_r8,0.39407e+03_r8 /)
      kbo(:,47, 6) = (/ &
        & 0.38431e+03_r8,0.38691e+03_r8,0.38929e+03_r8,0.39144e+03_r8,0.39336e+03_r8 /)
      kbo(:,48, 6) = (/ &
        & 0.38320e+03_r8,0.38589e+03_r8,0.38836e+03_r8,0.39060e+03_r8,0.39262e+03_r8 /)
      kbo(:,49, 6) = (/ &
        & 0.38206e+03_r8,0.38484e+03_r8,0.38739e+03_r8,0.38972e+03_r8,0.39183e+03_r8 /)
      kbo(:,50, 6) = (/ &
        & 0.38095e+03_r8,0.38382e+03_r8,0.38646e+03_r8,0.38887e+03_r8,0.39106e+03_r8 /)
      kbo(:,51, 6) = (/ &
        & 0.37985e+03_r8,0.38279e+03_r8,0.38552e+03_r8,0.38802e+03_r8,0.39029e+03_r8 /)
      kbo(:,52, 6) = (/ &
        & 0.37873e+03_r8,0.38175e+03_r8,0.38455e+03_r8,0.38713e+03_r8,0.38949e+03_r8 /)
      kbo(:,53, 6) = (/ &
        & 0.37762e+03_r8,0.38067e+03_r8,0.38355e+03_r8,0.38621e+03_r8,0.38865e+03_r8 /)
      kbo(:,54, 6) = (/ &
        & 0.37661e+03_r8,0.37965e+03_r8,0.38261e+03_r8,0.38535e+03_r8,0.38786e+03_r8 /)
      kbo(:,55, 6) = (/ &
        & 0.37559e+03_r8,0.37867e+03_r8,0.38169e+03_r8,0.38450e+03_r8,0.38708e+03_r8 /)
      kbo(:,56, 6) = (/ &
        & 0.37459e+03_r8,0.37768e+03_r8,0.38074e+03_r8,0.38362e+03_r8,0.38628e+03_r8 /)
      kbo(:,57, 6) = (/ &
        & 0.37353e+03_r8,0.37673e+03_r8,0.37977e+03_r8,0.38272e+03_r8,0.38545e+03_r8 /)
      kbo(:,58, 6) = (/ &
        & 0.37251e+03_r8,0.37577e+03_r8,0.37885e+03_r8,0.38185e+03_r8,0.38465e+03_r8 /)
      kbo(:,59, 6) = (/ &
        & 0.37212e+03_r8,0.37539e+03_r8,0.37847e+03_r8,0.38150e+03_r8,0.38432e+03_r8 /)
      kbo(:,13, 7) = (/ &
        & 0.62583e+03_r8,0.62623e+03_r8,0.62691e+03_r8,0.62787e+03_r8,0.62909e+03_r8 /)
      kbo(:,14, 7) = (/ &
        & 0.62586e+03_r8,0.62628e+03_r8,0.62699e+03_r8,0.62797e+03_r8,0.62921e+03_r8 /)
      kbo(:,15, 7) = (/ &
        & 0.62589e+03_r8,0.62634e+03_r8,0.62708e+03_r8,0.62809e+03_r8,0.62935e+03_r8 /)
      kbo(:,16, 7) = (/ &
        & 0.62593e+03_r8,0.62640e+03_r8,0.62717e+03_r8,0.62821e+03_r8,0.62950e+03_r8 /)
      kbo(:,17, 7) = (/ &
        & 0.62597e+03_r8,0.62647e+03_r8,0.62727e+03_r8,0.62833e+03_r8,0.62965e+03_r8 /)
      kbo(:,18, 7) = (/ &
        & 0.62601e+03_r8,0.62654e+03_r8,0.62737e+03_r8,0.62846e+03_r8,0.62980e+03_r8 /)
      kbo(:,19, 7) = (/ &
        & 0.62605e+03_r8,0.62661e+03_r8,0.62746e+03_r8,0.62858e+03_r8,0.62995e+03_r8 /)
      kbo(:,20, 7) = (/ &
        & 0.62610e+03_r8,0.62670e+03_r8,0.62758e+03_r8,0.62873e+03_r8,0.63012e+03_r8 /)
      kbo(:,21, 7) = (/ &
        & 0.62615e+03_r8,0.62679e+03_r8,0.62770e+03_r8,0.62888e+03_r8,0.63031e+03_r8 /)
      kbo(:,22, 7) = (/ &
        & 0.62625e+03_r8,0.62694e+03_r8,0.62790e+03_r8,0.62913e+03_r8,0.63060e+03_r8 /)
      kbo(:,23, 7) = (/ &
        & 0.62636e+03_r8,0.62710e+03_r8,0.62812e+03_r8,0.62939e+03_r8,0.63091e+03_r8 /)
      kbo(:,24, 7) = (/ &
        & 0.62648e+03_r8,0.62729e+03_r8,0.62835e+03_r8,0.62968e+03_r8,0.63125e+03_r8 /)
      kbo(:,25, 7) = (/ &
        & 0.62663e+03_r8,0.62749e+03_r8,0.62861e+03_r8,0.62999e+03_r8,0.63162e+03_r8 /)
      kbo(:,26, 7) = (/ &
        & 0.62681e+03_r8,0.62773e+03_r8,0.62891e+03_r8,0.63035e+03_r8,0.63203e+03_r8 /)
      kbo(:,27, 7) = (/ &
        & 0.62700e+03_r8,0.62799e+03_r8,0.62923e+03_r8,0.63072e+03_r8,0.63247e+03_r8 /)
      kbo(:,28, 7) = (/ &
        & 0.62721e+03_r8,0.62826e+03_r8,0.62956e+03_r8,0.63112e+03_r8,0.63292e+03_r8 /)
      kbo(:,29, 7) = (/ &
        & 0.62745e+03_r8,0.62856e+03_r8,0.62993e+03_r8,0.63154e+03_r8,0.63341e+03_r8 /)
      kbo(:,30, 7) = (/ &
        & 0.62770e+03_r8,0.62888e+03_r8,0.63031e+03_r8,0.63198e+03_r8,0.63392e+03_r8 /)
      kbo(:,31, 7) = (/ &
        & 0.62798e+03_r8,0.62922e+03_r8,0.63071e+03_r8,0.63245e+03_r8,0.63446e+03_r8 /)
      kbo(:,32, 7) = (/ &
        & 0.62828e+03_r8,0.62958e+03_r8,0.63114e+03_r8,0.63295e+03_r8,0.63503e+03_r8 /)
      kbo(:,33, 7) = (/ &
        & 0.62860e+03_r8,0.62997e+03_r8,0.63159e+03_r8,0.63347e+03_r8,0.63562e+03_r8 /)
      kbo(:,34, 7) = (/ &
        & 0.62889e+03_r8,0.63031e+03_r8,0.63199e+03_r8,0.63393e+03_r8,0.63614e+03_r8 /)
      kbo(:,35, 7) = (/ &
        & 0.62906e+03_r8,0.63052e+03_r8,0.63223e+03_r8,0.63421e+03_r8,0.63644e+03_r8 /)
      kbo(:,36, 7) = (/ &
        & 0.62909e+03_r8,0.63055e+03_r8,0.63227e+03_r8,0.63425e+03_r8,0.63649e+03_r8 /)
      kbo(:,37, 7) = (/ &
        & 0.62891e+03_r8,0.63035e+03_r8,0.63203e+03_r8,0.63397e+03_r8,0.63619e+03_r8 /)
      kbo(:,38, 7) = (/ &
        & 0.62873e+03_r8,0.63013e+03_r8,0.63178e+03_r8,0.63369e+03_r8,0.63586e+03_r8 /)
      kbo(:,39, 7) = (/ &
        & 0.62856e+03_r8,0.62992e+03_r8,0.63154e+03_r8,0.63341e+03_r8,0.63555e+03_r8 /)
      kbo(:,40, 7) = (/ &
        & 0.62827e+03_r8,0.62957e+03_r8,0.63113e+03_r8,0.63293e+03_r8,0.63501e+03_r8 /)
      kbo(:,41, 7) = (/ &
        & 0.62798e+03_r8,0.62922e+03_r8,0.63071e+03_r8,0.63245e+03_r8,0.63445e+03_r8 /)
      kbo(:,42, 7) = (/ &
        & 0.62770e+03_r8,0.62887e+03_r8,0.63030e+03_r8,0.63198e+03_r8,0.63391e+03_r8 /)
      kbo(:,43, 7) = (/ &
        & 0.62739e+03_r8,0.62848e+03_r8,0.62983e+03_r8,0.63143e+03_r8,0.63328e+03_r8 /)
      kbo(:,44, 7) = (/ &
        & 0.62708e+03_r8,0.62808e+03_r8,0.62935e+03_r8,0.63086e+03_r8,0.63263e+03_r8 /)
      kbo(:,45, 7) = (/ &
        & 0.62679e+03_r8,0.62771e+03_r8,0.62889e+03_r8,0.63032e+03_r8,0.63200e+03_r8 /)
      kbo(:,46, 7) = (/ &
        & 0.62653e+03_r8,0.62735e+03_r8,0.62844e+03_r8,0.62978e+03_r8,0.63137e+03_r8 /)
      kbo(:,47, 7) = (/ &
        & 0.62629e+03_r8,0.62699e+03_r8,0.62797e+03_r8,0.62921e+03_r8,0.63070e+03_r8 /)
      kbo(:,48, 7) = (/ &
        & 0.62608e+03_r8,0.62667e+03_r8,0.62755e+03_r8,0.62868e+03_r8,0.63007e+03_r8 /)
      kbo(:,49, 7) = (/ &
        & 0.62592e+03_r8,0.62640e+03_r8,0.62716e+03_r8,0.62820e+03_r8,0.62948e+03_r8 /)
      kbo(:,50, 7) = (/ &
        & 0.62580e+03_r8,0.62619e+03_r8,0.62684e+03_r8,0.62778e+03_r8,0.62897e+03_r8 /)
      kbo(:,51, 7) = (/ &
        & 0.62580e+03_r8,0.62602e+03_r8,0.62657e+03_r8,0.62741e+03_r8,0.62850e+03_r8 /)
      kbo(:,52, 7) = (/ &
        & 0.62578e+03_r8,0.62589e+03_r8,0.62633e+03_r8,0.62707e+03_r8,0.62807e+03_r8 /)
      kbo(:,53, 7) = (/ &
        & 0.62574e+03_r8,0.62578e+03_r8,0.62614e+03_r8,0.62677e+03_r8,0.62768e+03_r8 /)
      kbo(:,54, 7) = (/ &
        & 0.62576e+03_r8,0.62580e+03_r8,0.62600e+03_r8,0.62652e+03_r8,0.62734e+03_r8 /)
      kbo(:,55, 7) = (/ &
        & 0.62585e+03_r8,0.62578e+03_r8,0.62588e+03_r8,0.62632e+03_r8,0.62705e+03_r8 /)
      kbo(:,56, 7) = (/ &
        & 0.62587e+03_r8,0.62576e+03_r8,0.62579e+03_r8,0.62615e+03_r8,0.62678e+03_r8 /)
      kbo(:,57, 7) = (/ &
        & 0.62591e+03_r8,0.62574e+03_r8,0.62580e+03_r8,0.62601e+03_r8,0.62655e+03_r8 /)
      kbo(:,58, 7) = (/ &
        & 0.62591e+03_r8,0.62583e+03_r8,0.62578e+03_r8,0.62590e+03_r8,0.62636e+03_r8 /)
      kbo(:,59, 7) = (/ &
        & 0.62590e+03_r8,0.62586e+03_r8,0.62578e+03_r8,0.62586e+03_r8,0.62628e+03_r8 /)
      kbo(:,13, 8) = (/ &
        & 0.81821e+03_r8,0.81877e+03_r8,0.81935e+03_r8,0.81999e+03_r8,0.82074e+03_r8 /)
      kbo(:,14, 8) = (/ &
        & 0.81826e+03_r8,0.81882e+03_r8,0.81939e+03_r8,0.82006e+03_r8,0.82081e+03_r8 /)
      kbo(:,15, 8) = (/ &
        & 0.81831e+03_r8,0.81888e+03_r8,0.81946e+03_r8,0.82012e+03_r8,0.82089e+03_r8 /)
      kbo(:,16, 8) = (/ &
        & 0.81836e+03_r8,0.81895e+03_r8,0.81952e+03_r8,0.82021e+03_r8,0.82098e+03_r8 /)
      kbo(:,17, 8) = (/ &
        & 0.81842e+03_r8,0.81901e+03_r8,0.81959e+03_r8,0.82028e+03_r8,0.82106e+03_r8 /)
      kbo(:,18, 8) = (/ &
        & 0.81847e+03_r8,0.81907e+03_r8,0.81965e+03_r8,0.82036e+03_r8,0.82116e+03_r8 /)
      kbo(:,19, 8) = (/ &
        & 0.81853e+03_r8,0.81913e+03_r8,0.81972e+03_r8,0.82043e+03_r8,0.82123e+03_r8 /)
      kbo(:,20, 8) = (/ &
        & 0.81860e+03_r8,0.81919e+03_r8,0.81980e+03_r8,0.82052e+03_r8,0.82133e+03_r8 /)
      kbo(:,21, 8) = (/ &
        & 0.81868e+03_r8,0.81925e+03_r8,0.81988e+03_r8,0.82061e+03_r8,0.82143e+03_r8 /)
      kbo(:,22, 8) = (/ &
        & 0.81879e+03_r8,0.81936e+03_r8,0.82001e+03_r8,0.82076e+03_r8,0.82160e+03_r8 /)
      kbo(:,23, 8) = (/ &
        & 0.81889e+03_r8,0.81947e+03_r8,0.82015e+03_r8,0.82091e+03_r8,0.82177e+03_r8 /)
      kbo(:,24, 8) = (/ &
        & 0.81902e+03_r8,0.81960e+03_r8,0.82030e+03_r8,0.82108e+03_r8,0.82195e+03_r8 /)
      kbo(:,25, 8) = (/ &
        & 0.81914e+03_r8,0.81974e+03_r8,0.82046e+03_r8,0.82126e+03_r8,0.82214e+03_r8 /)
      kbo(:,26, 8) = (/ &
        & 0.81927e+03_r8,0.81990e+03_r8,0.82063e+03_r8,0.82145e+03_r8,0.82236e+03_r8 /)
      kbo(:,27, 8) = (/ &
        & 0.81941e+03_r8,0.82006e+03_r8,0.82082e+03_r8,0.82166e+03_r8,0.82258e+03_r8 /)
      kbo(:,28, 8) = (/ &
        & 0.81957e+03_r8,0.82024e+03_r8,0.82101e+03_r8,0.82188e+03_r8,0.82281e+03_r8 /)
      kbo(:,29, 8) = (/ &
        & 0.81971e+03_r8,0.82042e+03_r8,0.82122e+03_r8,0.82210e+03_r8,0.82305e+03_r8 /)
      kbo(:,30, 8) = (/ &
        & 0.81988e+03_r8,0.82061e+03_r8,0.82143e+03_r8,0.82233e+03_r8,0.82330e+03_r8 /)
      kbo(:,31, 8) = (/ &
        & 0.82006e+03_r8,0.82081e+03_r8,0.82166e+03_r8,0.82258e+03_r8,0.82355e+03_r8 /)
      kbo(:,32, 8) = (/ &
        & 0.82025e+03_r8,0.82103e+03_r8,0.82189e+03_r8,0.82283e+03_r8,0.82380e+03_r8 /)
      kbo(:,33, 8) = (/ &
        & 0.82044e+03_r8,0.82124e+03_r8,0.82213e+03_r8,0.82308e+03_r8,0.82408e+03_r8 /)
      kbo(:,34, 8) = (/ &
        & 0.82062e+03_r8,0.82144e+03_r8,0.82234e+03_r8,0.82330e+03_r8,0.82432e+03_r8 /)
      kbo(:,35, 8) = (/ &
        & 0.82072e+03_r8,0.82155e+03_r8,0.82246e+03_r8,0.82342e+03_r8,0.82446e+03_r8 /)
      kbo(:,36, 8) = (/ &
        & 0.82074e+03_r8,0.82157e+03_r8,0.82248e+03_r8,0.82345e+03_r8,0.82448e+03_r8 /)
      kbo(:,37, 8) = (/ &
        & 0.82063e+03_r8,0.82146e+03_r8,0.82236e+03_r8,0.82332e+03_r8,0.82434e+03_r8 /)
      kbo(:,38, 8) = (/ &
        & 0.82053e+03_r8,0.82134e+03_r8,0.82223e+03_r8,0.82319e+03_r8,0.82419e+03_r8 /)
      kbo(:,39, 8) = (/ &
        & 0.82042e+03_r8,0.82122e+03_r8,0.82210e+03_r8,0.82305e+03_r8,0.82405e+03_r8 /)
      kbo(:,40, 8) = (/ &
        & 0.82024e+03_r8,0.82102e+03_r8,0.82188e+03_r8,0.82282e+03_r8,0.82380e+03_r8 /)
      kbo(:,41, 8) = (/ &
        & 0.82006e+03_r8,0.82081e+03_r8,0.82165e+03_r8,0.82257e+03_r8,0.82354e+03_r8 /)
      kbo(:,42, 8) = (/ &
        & 0.81988e+03_r8,0.82061e+03_r8,0.82143e+03_r8,0.82233e+03_r8,0.82329e+03_r8 /)
      kbo(:,43, 8) = (/ &
        & 0.81967e+03_r8,0.82037e+03_r8,0.82117e+03_r8,0.82204e+03_r8,0.82299e+03_r8 /)
      kbo(:,44, 8) = (/ &
        & 0.81946e+03_r8,0.82013e+03_r8,0.82089e+03_r8,0.82174e+03_r8,0.82267e+03_r8 /)
      kbo(:,45, 8) = (/ &
        & 0.81926e+03_r8,0.81989e+03_r8,0.82062e+03_r8,0.82144e+03_r8,0.82234e+03_r8 /)
      kbo(:,46, 8) = (/ &
        & 0.81907e+03_r8,0.81965e+03_r8,0.82034e+03_r8,0.82114e+03_r8,0.82201e+03_r8 /)
      kbo(:,47, 8) = (/ &
        & 0.81882e+03_r8,0.81939e+03_r8,0.82006e+03_r8,0.82081e+03_r8,0.82165e+03_r8 /)
      kbo(:,48, 8) = (/ &
        & 0.81858e+03_r8,0.81917e+03_r8,0.81978e+03_r8,0.82050e+03_r8,0.82130e+03_r8 /)
      kbo(:,49, 8) = (/ &
        & 0.81836e+03_r8,0.81894e+03_r8,0.81953e+03_r8,0.82019e+03_r8,0.82097e+03_r8 /)
      kbo(:,50, 8) = (/ &
        & 0.81817e+03_r8,0.81871e+03_r8,0.81929e+03_r8,0.81993e+03_r8,0.82067e+03_r8 /)
      kbo(:,51, 8) = (/ &
        & 0.81790e+03_r8,0.81850e+03_r8,0.81910e+03_r8,0.81967e+03_r8,0.82039e+03_r8 /)
      kbo(:,52, 8) = (/ &
        & 0.81779e+03_r8,0.81830e+03_r8,0.81888e+03_r8,0.81945e+03_r8,0.82012e+03_r8 /)
      kbo(:,53, 8) = (/ &
        & 0.81766e+03_r8,0.81812e+03_r8,0.81866e+03_r8,0.81924e+03_r8,0.81986e+03_r8 /)
      kbo(:,54, 8) = (/ &
        & 0.81744e+03_r8,0.81785e+03_r8,0.81846e+03_r8,0.81906e+03_r8,0.81964e+03_r8 /)
      kbo(:,55, 8) = (/ &
        & 0.81733e+03_r8,0.81777e+03_r8,0.81829e+03_r8,0.81886e+03_r8,0.81944e+03_r8 /)
      kbo(:,56, 8) = (/ &
        & 0.81741e+03_r8,0.81767e+03_r8,0.81813e+03_r8,0.81867e+03_r8,0.81925e+03_r8 /)
      kbo(:,57, 8) = (/ &
        & 0.81785e+03_r8,0.81749e+03_r8,0.81788e+03_r8,0.81848e+03_r8,0.81908e+03_r8 /)
      kbo(:,58, 8) = (/ &
        & 0.81817e+03_r8,0.81731e+03_r8,0.81779e+03_r8,0.81832e+03_r8,0.81889e+03_r8 /)
      kbo(:,59, 8) = (/ &
        & 0.81824e+03_r8,0.81736e+03_r8,0.81776e+03_r8,0.81826e+03_r8,0.81883e+03_r8 /)
      kbo(:,13, 9) = (/ &
        & 0.94133e+03_r8,0.94438e+03_r8,0.94687e+03_r8,0.94883e+03_r8,0.95021e+03_r8 /)
      kbo(:,14, 9) = (/ &
        & 0.94163e+03_r8,0.94463e+03_r8,0.94708e+03_r8,0.94898e+03_r8,0.95031e+03_r8 /)
      kbo(:,15, 9) = (/ &
        & 0.94195e+03_r8,0.94490e+03_r8,0.94731e+03_r8,0.94914e+03_r8,0.95042e+03_r8 /)
      kbo(:,16, 9) = (/ &
        & 0.94229e+03_r8,0.94518e+03_r8,0.94753e+03_r8,0.94930e+03_r8,0.95052e+03_r8 /)
      kbo(:,17, 9) = (/ &
        & 0.94262e+03_r8,0.94544e+03_r8,0.94774e+03_r8,0.94946e+03_r8,0.95061e+03_r8 /)
      kbo(:,18, 9) = (/ &
        & 0.94293e+03_r8,0.94570e+03_r8,0.94795e+03_r8,0.94960e+03_r8,0.95069e+03_r8 /)
      kbo(:,19, 9) = (/ &
        & 0.94323e+03_r8,0.94595e+03_r8,0.94814e+03_r8,0.94974e+03_r8,0.95078e+03_r8 /)
      kbo(:,20, 9) = (/ &
        & 0.94357e+03_r8,0.94624e+03_r8,0.94835e+03_r8,0.94989e+03_r8,0.95087e+03_r8 /)
      kbo(:,21, 9) = (/ &
        & 0.94393e+03_r8,0.94654e+03_r8,0.94857e+03_r8,0.95003e+03_r8,0.95096e+03_r8 /)
      kbo(:,22, 9) = (/ &
        & 0.94445e+03_r8,0.94695e+03_r8,0.94888e+03_r8,0.95025e+03_r8,0.95105e+03_r8 /)
      kbo(:,23, 9) = (/ &
        & 0.94499e+03_r8,0.94737e+03_r8,0.94919e+03_r8,0.95045e+03_r8,0.95113e+03_r8 /)
      kbo(:,24, 9) = (/ &
        & 0.94549e+03_r8,0.94778e+03_r8,0.94948e+03_r8,0.95063e+03_r8,0.95120e+03_r8 /)
      kbo(:,25, 9) = (/ &
        & 0.94602e+03_r8,0.94819e+03_r8,0.94978e+03_r8,0.95082e+03_r8,0.95125e+03_r8 /)
      kbo(:,26, 9) = (/ &
        & 0.94658e+03_r8,0.94861e+03_r8,0.95006e+03_r8,0.95096e+03_r8,0.95127e+03_r8 /)
      kbo(:,27, 9) = (/ &
        & 0.94710e+03_r8,0.94900e+03_r8,0.95033e+03_r8,0.95109e+03_r8,0.95126e+03_r8 /)
      kbo(:,28, 9) = (/ &
        & 0.94759e+03_r8,0.94937e+03_r8,0.95056e+03_r8,0.95118e+03_r8,0.95123e+03_r8 /)
      kbo(:,29, 9) = (/ &
        & 0.94811e+03_r8,0.94973e+03_r8,0.95077e+03_r8,0.95124e+03_r8,0.95116e+03_r8 /)
      kbo(:,30, 9) = (/ &
        & 0.94856e+03_r8,0.95003e+03_r8,0.95095e+03_r8,0.95127e+03_r8,0.95105e+03_r8 /)
      kbo(:,31, 9) = (/ &
        & 0.94901e+03_r8,0.95032e+03_r8,0.95108e+03_r8,0.95127e+03_r8,0.95090e+03_r8 /)
      kbo(:,32, 9) = (/ &
        & 0.94939e+03_r8,0.95057e+03_r8,0.95118e+03_r8,0.95121e+03_r8,0.95071e+03_r8 /)
      kbo(:,33, 9) = (/ &
        & 0.94975e+03_r8,0.95079e+03_r8,0.95125e+03_r8,0.95115e+03_r8,0.95050e+03_r8 /)
      kbo(:,34, 9) = (/ &
        & 0.95004e+03_r8,0.95095e+03_r8,0.95128e+03_r8,0.95105e+03_r8,0.95030e+03_r8 /)
      kbo(:,35, 9) = (/ &
        & 0.95020e+03_r8,0.95102e+03_r8,0.95127e+03_r8,0.95098e+03_r8,0.95016e+03_r8 /)
      kbo(:,36, 9) = (/ &
        & 0.95021e+03_r8,0.95103e+03_r8,0.95127e+03_r8,0.95096e+03_r8,0.95023e+03_r8 /)
      kbo(:,37, 9) = (/ &
        & 0.95006e+03_r8,0.95096e+03_r8,0.95127e+03_r8,0.95104e+03_r8,0.95027e+03_r8 /)
      kbo(:,38, 9) = (/ &
        & 0.94990e+03_r8,0.95087e+03_r8,0.95126e+03_r8,0.95110e+03_r8,0.95040e+03_r8 /)
      kbo(:,39, 9) = (/ &
        & 0.94972e+03_r8,0.95077e+03_r8,0.95124e+03_r8,0.95117e+03_r8,0.95053e+03_r8 /)
      kbo(:,40, 9) = (/ &
        & 0.94939e+03_r8,0.95057e+03_r8,0.95118e+03_r8,0.95123e+03_r8,0.95072e+03_r8 /)
      kbo(:,41, 9) = (/ &
        & 0.94899e+03_r8,0.95032e+03_r8,0.95108e+03_r8,0.95127e+03_r8,0.95090e+03_r8 /)
      kbo(:,42, 9) = (/ &
        & 0.94856e+03_r8,0.95004e+03_r8,0.95094e+03_r8,0.95127e+03_r8,0.95105e+03_r8 /)
      kbo(:,43, 9) = (/ &
        & 0.94799e+03_r8,0.94963e+03_r8,0.95073e+03_r8,0.95123e+03_r8,0.95118e+03_r8 /)
      kbo(:,44, 9) = (/ &
        & 0.94729e+03_r8,0.94914e+03_r8,0.95041e+03_r8,0.95112e+03_r8,0.95126e+03_r8 /)
      kbo(:,45, 9) = (/ &
        & 0.94655e+03_r8,0.94858e+03_r8,0.95004e+03_r8,0.95095e+03_r8,0.95127e+03_r8 /)
      kbo(:,46, 9) = (/ &
        & 0.94568e+03_r8,0.94792e+03_r8,0.94958e+03_r8,0.95070e+03_r8,0.95122e+03_r8 /)
      kbo(:,47, 9) = (/ &
        & 0.94463e+03_r8,0.94708e+03_r8,0.94898e+03_r8,0.95031e+03_r8,0.95108e+03_r8 /)
      kbo(:,48, 9) = (/ &
        & 0.94348e+03_r8,0.94616e+03_r8,0.94829e+03_r8,0.94984e+03_r8,0.95084e+03_r8 /)
      kbo(:,49, 9) = (/ &
        & 0.94226e+03_r8,0.94515e+03_r8,0.94748e+03_r8,0.94928e+03_r8,0.95051e+03_r8 /)
      kbo(:,50, 9) = (/ &
        & 0.94103e+03_r8,0.94413e+03_r8,0.94669e+03_r8,0.94868e+03_r8,0.95011e+03_r8 /)
      kbo(:,51, 9) = (/ &
        & 0.93978e+03_r8,0.94307e+03_r8,0.94580e+03_r8,0.94802e+03_r8,0.94965e+03_r8 /)
      kbo(:,52, 9) = (/ &
        & 0.93828e+03_r8,0.94192e+03_r8,0.94488e+03_r8,0.94728e+03_r8,0.94912e+03_r8 /)
      kbo(:,53, 9) = (/ &
        & 0.93678e+03_r8,0.94072e+03_r8,0.94388e+03_r8,0.94646e+03_r8,0.94851e+03_r8 /)
      kbo(:,54, 9) = (/ &
        & 0.93537e+03_r8,0.93955e+03_r8,0.94287e+03_r8,0.94565e+03_r8,0.94789e+03_r8 /)
      kbo(:,55, 9) = (/ &
        & 0.93380e+03_r8,0.93820e+03_r8,0.94186e+03_r8,0.94483e+03_r8,0.94722e+03_r8 /)
      kbo(:,56, 9) = (/ &
        & 0.93205e+03_r8,0.93688e+03_r8,0.94080e+03_r8,0.94394e+03_r8,0.94652e+03_r8 /)
      kbo(:,57, 9) = (/ &
        & 0.92997e+03_r8,0.93554e+03_r8,0.93969e+03_r8,0.94299e+03_r8,0.94574e+03_r8 /)
      kbo(:,58, 9) = (/ &
        & 0.92808e+03_r8,0.93414e+03_r8,0.93844e+03_r8,0.94204e+03_r8,0.94498e+03_r8 /)
      kbo(:,59, 9) = (/ &
        & 0.92793e+03_r8,0.93341e+03_r8,0.93792e+03_r8,0.94165e+03_r8,0.94465e+03_r8 /)
      kbo(:,13,10) = (/ &
        & 0.98036e+03_r8,0.98526e+03_r8,0.98973e+03_r8,0.99279e+03_r8,0.99468e+03_r8 /)
      kbo(:,14,10) = (/ &
        & 0.98067e+03_r8,0.98568e+03_r8,0.99005e+03_r8,0.99301e+03_r8,0.99477e+03_r8 /)
      kbo(:,15,10) = (/ &
        & 0.98125e+03_r8,0.98614e+03_r8,0.99040e+03_r8,0.99324e+03_r8,0.99485e+03_r8 /)
      kbo(:,16,10) = (/ &
        & 0.98185e+03_r8,0.98662e+03_r8,0.99076e+03_r8,0.99348e+03_r8,0.99493e+03_r8 /)
      kbo(:,17,10) = (/ &
        & 0.98242e+03_r8,0.98721e+03_r8,0.99109e+03_r8,0.99369e+03_r8,0.99498e+03_r8 /)
      kbo(:,18,10) = (/ &
        & 0.98296e+03_r8,0.98755e+03_r8,0.99141e+03_r8,0.99390e+03_r8,0.99502e+03_r8 /)
      kbo(:,19,10) = (/ &
        & 0.98350e+03_r8,0.98800e+03_r8,0.99172e+03_r8,0.99408e+03_r8,0.99505e+03_r8 /)
      kbo(:,20,10) = (/ &
        & 0.98411e+03_r8,0.98852e+03_r8,0.99205e+03_r8,0.99428e+03_r8,0.99507e+03_r8 /)
      kbo(:,21,10) = (/ &
        & 0.98464e+03_r8,0.98894e+03_r8,0.99238e+03_r8,0.99447e+03_r8,0.99496e+03_r8 /)
      kbo(:,22,10) = (/ &
        & 0.98547e+03_r8,0.98983e+03_r8,0.99286e+03_r8,0.99470e+03_r8,0.99509e+03_r8 /)
      kbo(:,23,10) = (/ &
        & 0.98617e+03_r8,0.99062e+03_r8,0.99331e+03_r8,0.99487e+03_r8,0.99508e+03_r8 /)
      kbo(:,24,10) = (/ &
        & 0.98718e+03_r8,0.99115e+03_r8,0.99373e+03_r8,0.99499e+03_r8,0.99503e+03_r8 /)
      kbo(:,25,10) = (/ &
        & 0.98813e+03_r8,0.99180e+03_r8,0.99413e+03_r8,0.99494e+03_r8,0.99492e+03_r8 /)
      kbo(:,26,10) = (/ &
        & 0.98918e+03_r8,0.99244e+03_r8,0.99450e+03_r8,0.99508e+03_r8,0.99475e+03_r8 /)
      kbo(:,27,10) = (/ &
        & 0.99010e+03_r8,0.99304e+03_r8,0.99478e+03_r8,0.99509e+03_r8,0.99499e+03_r8 /)
      kbo(:,28,10) = (/ &
        & 0.99090e+03_r8,0.99357e+03_r8,0.99495e+03_r8,0.99505e+03_r8,0.99433e+03_r8 /)
      kbo(:,29,10) = (/ &
        & 0.99167e+03_r8,0.99393e+03_r8,0.99505e+03_r8,0.99495e+03_r8,0.99385e+03_r8 /)
      kbo(:,30,10) = (/ &
        & 0.99249e+03_r8,0.99447e+03_r8,0.99508e+03_r8,0.99477e+03_r8,0.99348e+03_r8 /)
      kbo(:,31,10) = (/ &
        & 0.99290e+03_r8,0.99477e+03_r8,0.99509e+03_r8,0.99452e+03_r8,0.99326e+03_r8 /)
      kbo(:,32,10) = (/ &
        & 0.99360e+03_r8,0.99496e+03_r8,0.99505e+03_r8,0.99419e+03_r8,0.99287e+03_r8 /)
      kbo(:,33,10) = (/ &
        & 0.99410e+03_r8,0.99506e+03_r8,0.99493e+03_r8,0.99381e+03_r8,0.99210e+03_r8 /)
      kbo(:,34,10) = (/ &
        & 0.99447e+03_r8,0.99508e+03_r8,0.99465e+03_r8,0.99347e+03_r8,0.99121e+03_r8 /)
      kbo(:,35,10) = (/ &
        & 0.99453e+03_r8,0.99509e+03_r8,0.99465e+03_r8,0.99330e+03_r8,0.99083e+03_r8 /)
      kbo(:,36,10) = (/ &
        & 0.99467e+03_r8,0.99509e+03_r8,0.99463e+03_r8,0.99327e+03_r8,0.98992e+03_r8 /)
      kbo(:,37,10) = (/ &
        & 0.99451e+03_r8,0.99508e+03_r8,0.99475e+03_r8,0.99344e+03_r8,0.99124e+03_r8 /)
      kbo(:,38,10) = (/ &
        & 0.99429e+03_r8,0.99507e+03_r8,0.99486e+03_r8,0.99365e+03_r8,0.99174e+03_r8 /)
      kbo(:,39,10) = (/ &
        & 0.99405e+03_r8,0.99505e+03_r8,0.99495e+03_r8,0.99373e+03_r8,0.99219e+03_r8 /)
      kbo(:,40,10) = (/ &
        & 0.99347e+03_r8,0.99496e+03_r8,0.99505e+03_r8,0.99420e+03_r8,0.99289e+03_r8 /)
      kbo(:,41,10) = (/ &
        & 0.99302e+03_r8,0.99477e+03_r8,0.99509e+03_r8,0.99452e+03_r8,0.99315e+03_r8 /)
      kbo(:,42,10) = (/ &
        & 0.99237e+03_r8,0.99435e+03_r8,0.99508e+03_r8,0.99477e+03_r8,0.99348e+03_r8 /)
      kbo(:,43,10) = (/ &
        & 0.99148e+03_r8,0.99394e+03_r8,0.99491e+03_r8,0.99498e+03_r8,0.99395e+03_r8 /)
      kbo(:,44,10) = (/ &
        & 0.99040e+03_r8,0.99324e+03_r8,0.99485e+03_r8,0.99508e+03_r8,0.99453e+03_r8 /)
      kbo(:,45,10) = (/ &
        & 0.98910e+03_r8,0.99241e+03_r8,0.99449e+03_r8,0.99508e+03_r8,0.99476e+03_r8 /)
      kbo(:,46,10) = (/ &
        & 0.98735e+03_r8,0.99138e+03_r8,0.99388e+03_r8,0.99490e+03_r8,0.99500e+03_r8 /)
      kbo(:,47,10) = (/ &
        & 0.98565e+03_r8,0.99006e+03_r8,0.99301e+03_r8,0.99477e+03_r8,0.99509e+03_r8 /)
      kbo(:,48,10) = (/ &
        & 0.98383e+03_r8,0.98834e+03_r8,0.99196e+03_r8,0.99423e+03_r8,0.99507e+03_r8 /)
      kbo(:,49,10) = (/ &
        & 0.98174e+03_r8,0.98651e+03_r8,0.99073e+03_r8,0.99346e+03_r8,0.99492e+03_r8 /)
      kbo(:,50,10) = (/ &
        & 0.97955e+03_r8,0.98480e+03_r8,0.98924e+03_r8,0.99257e+03_r8,0.99470e+03_r8 /)
      kbo(:,51,10) = (/ &
        & 0.97755e+03_r8,0.98298e+03_r8,0.98767e+03_r8,0.99154e+03_r8,0.99399e+03_r8 /)
      kbo(:,52,10) = (/ &
        & 0.97554e+03_r8,0.98111e+03_r8,0.98597e+03_r8,0.99036e+03_r8,0.99323e+03_r8 /)
      kbo(:,53,10) = (/ &
        & 0.97320e+03_r8,0.97892e+03_r8,0.98413e+03_r8,0.98888e+03_r8,0.99232e+03_r8 /)
      kbo(:,54,10) = (/ &
        & 0.97086e+03_r8,0.97720e+03_r8,0.98263e+03_r8,0.98733e+03_r8,0.99135e+03_r8 /)
      kbo(:,55,10) = (/ &
        & 0.96881e+03_r8,0.97539e+03_r8,0.98096e+03_r8,0.98583e+03_r8,0.99029e+03_r8 /)
      kbo(:,56,10) = (/ &
        & 0.96735e+03_r8,0.97336e+03_r8,0.97906e+03_r8,0.98435e+03_r8,0.98900e+03_r8 /)
      kbo(:,57,10) = (/ &
        & 0.96407e+03_r8,0.97115e+03_r8,0.97740e+03_r8,0.98282e+03_r8,0.98752e+03_r8 /)
      kbo(:,58,10) = (/ &
        & 0.96154e+03_r8,0.96893e+03_r8,0.97574e+03_r8,0.98129e+03_r8,0.98611e+03_r8 /)
      kbo(:,59,10) = (/ &
        & 0.95571e+03_r8,0.96861e+03_r8,0.97503e+03_r8,0.98063e+03_r8,0.98557e+03_r8 /)
      kbo(:,13,11) = (/ &
        & 0.98771e+03_r8,0.99296e+03_r8,0.99655e+03_r8,0.99859e+03_r8,0.99936e+03_r8 /)
      kbo(:,14,11) = (/ &
        & 0.98850e+03_r8,0.99335e+03_r8,0.99679e+03_r8,0.99871e+03_r8,0.99939e+03_r8 /)
      kbo(:,15,11) = (/ &
        & 0.98905e+03_r8,0.99377e+03_r8,0.99705e+03_r8,0.99882e+03_r8,0.99942e+03_r8 /)
      kbo(:,16,11) = (/ &
        & 0.98962e+03_r8,0.99419e+03_r8,0.99730e+03_r8,0.99893e+03_r8,0.99945e+03_r8 /)
      kbo(:,17,11) = (/ &
        & 0.99016e+03_r8,0.99444e+03_r8,0.99754e+03_r8,0.99903e+03_r8,0.99947e+03_r8 /)
      kbo(:,18,11) = (/ &
        & 0.99067e+03_r8,0.99497e+03_r8,0.99775e+03_r8,0.99911e+03_r8,0.99948e+03_r8 /)
      kbo(:,19,11) = (/ &
        & 0.99117e+03_r8,0.99532e+03_r8,0.99795e+03_r8,0.99918e+03_r8,0.99949e+03_r8 /)
      kbo(:,20,11) = (/ &
        & 0.99173e+03_r8,0.99572e+03_r8,0.99816e+03_r8,0.99924e+03_r8,0.99949e+03_r8 /)
      kbo(:,21,11) = (/ &
        & 0.99228e+03_r8,0.99610e+03_r8,0.99835e+03_r8,0.99929e+03_r8,0.99946e+03_r8 /)
      kbo(:,22,11) = (/ &
        & 0.99309e+03_r8,0.99663e+03_r8,0.99862e+03_r8,0.99936e+03_r8,0.99953e+03_r8 /)
      kbo(:,23,11) = (/ &
        & 0.99388e+03_r8,0.99698e+03_r8,0.99900e+03_r8,0.99942e+03_r8,0.99925e+03_r8 /)
      kbo(:,24,11) = (/ &
        & 0.99466e+03_r8,0.99758e+03_r8,0.99904e+03_r8,0.99947e+03_r8,0.99905e+03_r8 /)
      kbo(:,25,11) = (/ &
        & 0.99542e+03_r8,0.99800e+03_r8,0.99919e+03_r8,0.99963e+03_r8,0.99878e+03_r8 /)
      kbo(:,26,11) = (/ &
        & 0.99618e+03_r8,0.99839e+03_r8,0.99930e+03_r8,0.99945e+03_r8,0.99847e+03_r8 /)
      kbo(:,27,11) = (/ &
        & 0.99683e+03_r8,0.99872e+03_r8,0.99939e+03_r8,0.99934e+03_r8,0.99751e+03_r8 /)
      kbo(:,28,11) = (/ &
        & 0.99741e+03_r8,0.99897e+03_r8,0.99946e+03_r8,0.99913e+03_r8,0.99749e+03_r8 /)
      kbo(:,29,11) = (/ &
        & 0.99792e+03_r8,0.99917e+03_r8,0.99949e+03_r8,0.99884e+03_r8,0.99707e+03_r8 /)
      kbo(:,30,11) = (/ &
        & 0.99821e+03_r8,0.99929e+03_r8,0.99946e+03_r8,0.99850e+03_r8,0.99637e+03_r8 /)
      kbo(:,31,11) = (/ &
        & 0.99871e+03_r8,0.99938e+03_r8,0.99949e+03_r8,0.99810e+03_r8,0.99532e+03_r8 /)
      kbo(:,32,11) = (/ &
        & 0.99899e+03_r8,0.99961e+03_r8,0.99926e+03_r8,0.99761e+03_r8,0.99460e+03_r8 /)
      kbo(:,33,11) = (/ &
        & 0.99918e+03_r8,0.99949e+03_r8,0.99880e+03_r8,0.99700e+03_r8,0.99413e+03_r8 /)
      kbo(:,34,11) = (/ &
        & 0.99929e+03_r8,0.99946e+03_r8,0.99850e+03_r8,0.99635e+03_r8,0.99329e+03_r8 /)
      kbo(:,35,11) = (/ &
        & 0.99934e+03_r8,0.99941e+03_r8,0.99830e+03_r8,0.99590e+03_r8,0.99292e+03_r8 /)
      kbo(:,36,11) = (/ &
        & 0.99935e+03_r8,0.99940e+03_r8,0.99826e+03_r8,0.99583e+03_r8,0.99287e+03_r8 /)
      kbo(:,37,11) = (/ &
        & 0.99930e+03_r8,0.99946e+03_r8,0.99846e+03_r8,0.99628e+03_r8,0.99327e+03_r8 /)
      kbo(:,38,11) = (/ &
        & 0.99924e+03_r8,0.99949e+03_r8,0.99866e+03_r8,0.99670e+03_r8,0.99350e+03_r8 /)
      kbo(:,39,11) = (/ &
        & 0.99917e+03_r8,0.99949e+03_r8,0.99899e+03_r8,0.99707e+03_r8,0.99451e+03_r8 /)
      kbo(:,40,11) = (/ &
        & 0.99898e+03_r8,0.99946e+03_r8,0.99913e+03_r8,0.99777e+03_r8,0.99505e+03_r8 /)
      kbo(:,41,11) = (/ &
        & 0.99871e+03_r8,0.99939e+03_r8,0.99935e+03_r8,0.99810e+03_r8,0.99546e+03_r8 /)
      kbo(:,42,11) = (/ &
        & 0.99835e+03_r8,0.99929e+03_r8,0.99947e+03_r8,0.99851e+03_r8,0.99637e+03_r8 /)
      kbo(:,43,11) = (/ &
        & 0.99780e+03_r8,0.99913e+03_r8,0.99949e+03_r8,0.99893e+03_r8,0.99722e+03_r8 /)
      kbo(:,44,11) = (/ &
        & 0.99704e+03_r8,0.99882e+03_r8,0.99942e+03_r8,0.99928e+03_r8,0.99778e+03_r8 /)
      kbo(:,45,11) = (/ &
        & 0.99613e+03_r8,0.99837e+03_r8,0.99930e+03_r8,0.99947e+03_r8,0.99849e+03_r8 /)
      kbo(:,46,11) = (/ &
        & 0.99492e+03_r8,0.99787e+03_r8,0.99911e+03_r8,0.99949e+03_r8,0.99897e+03_r8 /)
      kbo(:,47,11) = (/ &
        & 0.99335e+03_r8,0.99679e+03_r8,0.99871e+03_r8,0.99939e+03_r8,0.99936e+03_r8 /)
      kbo(:,48,11) = (/ &
        & 0.99156e+03_r8,0.99560e+03_r8,0.99810e+03_r8,0.99923e+03_r8,0.99951e+03_r8 /)
      kbo(:,49,11) = (/ &
        & 0.98955e+03_r8,0.99414e+03_r8,0.99727e+03_r8,0.99894e+03_r8,0.99946e+03_r8 /)
      kbo(:,50,11) = (/ &
        & 0.98749e+03_r8,0.99256e+03_r8,0.99630e+03_r8,0.99847e+03_r8,0.99918e+03_r8 /)
      kbo(:,51,11) = (/ &
        & 0.98496e+03_r8,0.99085e+03_r8,0.99509e+03_r8,0.99784e+03_r8,0.99916e+03_r8 /)
      kbo(:,52,11) = (/ &
        & 0.98304e+03_r8,0.98897e+03_r8,0.99370e+03_r8,0.99701e+03_r8,0.99883e+03_r8 /)
      kbo(:,53,11) = (/ &
        & 0.98104e+03_r8,0.98693e+03_r8,0.99213e+03_r8,0.99600e+03_r8,0.99833e+03_r8 /)
      kbo(:,54,11) = (/ &
        & 0.97906e+03_r8,0.98440e+03_r8,0.99053e+03_r8,0.99485e+03_r8,0.99771e+03_r8 /)
      kbo(:,55,11) = (/ &
        & 0.97789e+03_r8,0.98286e+03_r8,0.98886e+03_r8,0.99361e+03_r8,0.99696e+03_r8 /)
      kbo(:,56,11) = (/ &
        & 0.97514e+03_r8,0.98117e+03_r8,0.98708e+03_r8,0.99224e+03_r8,0.99622e+03_r8 /)
      kbo(:,57,11) = (/ &
        & 0.97242e+03_r8,0.97945e+03_r8,0.98472e+03_r8,0.99072e+03_r8,0.99500e+03_r8 /)
      kbo(:,58,11) = (/ &
        & 0.96969e+03_r8,0.97814e+03_r8,0.98316e+03_r8,0.98916e+03_r8,0.99384e+03_r8 /)
      kbo(:,59,11) = (/ &
        & 0.96859e+03_r8,0.97725e+03_r8,0.98261e+03_r8,0.98851e+03_r8,0.99335e+03_r8 /)
      kbo(:,13,12) = (/ &
        & 0.99768e+03_r8,0.99984e+03_r8,0.10010e+04_r8,0.10024e+04_r8,0.10029e+04_r8 /)
      kbo(:,14,12) = (/ &
        & 0.99795e+03_r8,0.99992e+03_r8,0.10011e+04_r8,0.10025e+04_r8,0.10029e+04_r8 /)
      kbo(:,15,12) = (/ &
        & 0.99880e+03_r8,0.99996e+03_r8,0.10013e+04_r8,0.10026e+04_r8,0.10031e+04_r8 /)
      kbo(:,16,12) = (/ &
        & 0.99852e+03_r8,0.10003e+04_r8,0.10015e+04_r8,0.10028e+04_r8,0.10029e+04_r8 /)
      kbo(:,17,12) = (/ &
        & 0.99876e+03_r8,0.10000e+04_r8,0.10016e+04_r8,0.10027e+04_r8,0.10029e+04_r8 /)
      kbo(:,18,12) = (/ &
        & 0.99898e+03_r8,0.10001e+04_r8,0.10018e+04_r8,0.10028e+04_r8,0.10028e+04_r8 /)
      kbo(:,19,12) = (/ &
        & 0.99918e+03_r8,0.10003e+04_r8,0.10021e+04_r8,0.10028e+04_r8,0.10028e+04_r8 /)
      kbo(:,20,12) = (/ &
        & 0.99940e+03_r8,0.10005e+04_r8,0.10026e+04_r8,0.10029e+04_r8,0.10031e+04_r8 /)
      kbo(:,21,12) = (/ &
        & 0.99959e+03_r8,0.10007e+04_r8,0.10022e+04_r8,0.10029e+04_r8,0.10026e+04_r8 /)
      kbo(:,22,12) = (/ &
        & 0.99984e+03_r8,0.10010e+04_r8,0.10024e+04_r8,0.10030e+04_r8,0.10023e+04_r8 /)
      kbo(:,23,12) = (/ &
        & 0.99996e+03_r8,0.10013e+04_r8,0.10024e+04_r8,0.10029e+04_r8,0.10025e+04_r8 /)
      kbo(:,24,12) = (/ &
        & 0.10000e+04_r8,0.10016e+04_r8,0.10029e+04_r8,0.10029e+04_r8,0.10023e+04_r8 /)
      kbo(:,25,12) = (/ &
        & 0.10003e+04_r8,0.10023e+04_r8,0.10029e+04_r8,0.10026e+04_r8,0.10019e+04_r8 /)
      kbo(:,26,12) = (/ &
        & 0.10007e+04_r8,0.10022e+04_r8,0.10029e+04_r8,0.10026e+04_r8,0.10015e+04_r8 /)
      kbo(:,27,12) = (/ &
        & 0.10012e+04_r8,0.10025e+04_r8,0.10031e+04_r8,0.10024e+04_r8,0.10010e+04_r8 /)
      kbo(:,28,12) = (/ &
        & 0.10015e+04_r8,0.10027e+04_r8,0.10029e+04_r8,0.10022e+04_r8,0.10005e+04_r8 /)
      kbo(:,29,12) = (/ &
        & 0.10019e+04_r8,0.10028e+04_r8,0.10028e+04_r8,0.10019e+04_r8,0.99992e+03_r8 /)
      kbo(:,30,12) = (/ &
        & 0.10022e+04_r8,0.10029e+04_r8,0.10026e+04_r8,0.10017e+04_r8,0.99965e+03_r8 /)
      kbo(:,31,12) = (/ &
        & 0.10025e+04_r8,0.10030e+04_r8,0.10022e+04_r8,0.10011e+04_r8,0.99843e+03_r8 /)
      kbo(:,32,12) = (/ &
        & 0.10027e+04_r8,0.10029e+04_r8,0.10020e+04_r8,0.10007e+04_r8,0.99748e+03_r8 /)
      kbo(:,33,12) = (/ &
        & 0.10029e+04_r8,0.10028e+04_r8,0.10021e+04_r8,0.10000e+04_r8,0.99658e+03_r8 /)
      kbo(:,34,12) = (/ &
        & 0.10031e+04_r8,0.10026e+04_r8,0.10017e+04_r8,0.99945e+03_r8,0.99563e+03_r8 /)
      kbo(:,35,12) = (/ &
        & 0.10030e+04_r8,0.10025e+04_r8,0.10031e+04_r8,0.99888e+03_r8,0.99496e+03_r8 /)
      kbo(:,36,12) = (/ &
        & 0.10030e+04_r8,0.10025e+04_r8,0.10020e+04_r8,0.99880e+03_r8,0.99482e+03_r8 /)
      kbo(:,37,12) = (/ &
        & 0.10029e+04_r8,0.10026e+04_r8,0.10015e+04_r8,0.99939e+03_r8,0.99547e+03_r8 /)
      kbo(:,38,12) = (/ &
        & 0.10029e+04_r8,0.10027e+04_r8,0.10017e+04_r8,0.99958e+03_r8,0.99634e+03_r8 /)
      kbo(:,39,12) = (/ &
        & 0.10028e+04_r8,0.10028e+04_r8,0.10017e+04_r8,0.99993e+03_r8,0.99613e+03_r8 /)
      kbo(:,40,12) = (/ &
        & 0.10027e+04_r8,0.10029e+04_r8,0.10022e+04_r8,0.10003e+04_r8,0.99696e+03_r8 /)
      kbo(:,41,12) = (/ &
        & 0.10027e+04_r8,0.10029e+04_r8,0.10024e+04_r8,0.10013e+04_r8,0.99857e+03_r8 /)
      kbo(:,42,12) = (/ &
        & 0.10022e+04_r8,0.10029e+04_r8,0.10028e+04_r8,0.10021e+04_r8,0.99929e+03_r8 /)
      kbo(:,43,12) = (/ &
        & 0.10018e+04_r8,0.10028e+04_r8,0.10028e+04_r8,0.10020e+04_r8,0.10001e+04_r8 /)
      kbo(:,44,12) = (/ &
        & 0.10013e+04_r8,0.10026e+04_r8,0.10029e+04_r8,0.10023e+04_r8,0.10016e+04_r8 /)
      kbo(:,45,12) = (/ &
        & 0.10007e+04_r8,0.10022e+04_r8,0.10029e+04_r8,0.10026e+04_r8,0.10015e+04_r8 /)
      kbo(:,46,12) = (/ &
        & 0.10014e+04_r8,0.10016e+04_r8,0.10028e+04_r8,0.10028e+04_r8,0.10020e+04_r8 /)
      kbo(:,47,12) = (/ &
        & 0.99993e+03_r8,0.10012e+04_r8,0.10025e+04_r8,0.10029e+04_r8,0.10024e+04_r8 /)
      kbo(:,48,12) = (/ &
        & 0.99937e+03_r8,0.10005e+04_r8,0.10022e+04_r8,0.10029e+04_r8,0.10027e+04_r8 /)
      kbo(:,49,12) = (/ &
        & 0.99853e+03_r8,0.10002e+04_r8,0.10015e+04_r8,0.10026e+04_r8,0.10029e+04_r8 /)
      kbo(:,50,12) = (/ &
        & 0.99741e+03_r8,0.99993e+03_r8,0.10008e+04_r8,0.10023e+04_r8,0.10029e+04_r8 /)
      kbo(:,51,12) = (/ &
        & 0.99665e+03_r8,0.99912e+03_r8,0.10002e+04_r8,0.10018e+04_r8,0.10028e+04_r8 /)
      kbo(:,52,12) = (/ &
        & 0.99385e+03_r8,0.99826e+03_r8,0.10000e+04_r8,0.10013e+04_r8,0.10025e+04_r8 /)
      kbo(:,53,12) = (/ &
        & 0.99099e+03_r8,0.99714e+03_r8,0.99965e+03_r8,0.10007e+04_r8,0.10022e+04_r8 /)
      kbo(:,54,12) = (/ &
        & 0.98826e+03_r8,0.99612e+03_r8,0.99903e+03_r8,0.10002e+04_r8,0.10018e+04_r8 /)
      kbo(:,55,12) = (/ &
        & 0.98397e+03_r8,0.99379e+03_r8,0.99822e+03_r8,0.10000e+04_r8,0.10013e+04_r8 /)
      kbo(:,56,12) = (/ &
        & 0.98006e+03_r8,0.99120e+03_r8,0.99722e+03_r8,0.99969e+03_r8,0.10006e+04_r8 /)
      kbo(:,57,12) = (/ &
        & 0.97631e+03_r8,0.98840e+03_r8,0.99624e+03_r8,0.99911e+03_r8,0.10002e+04_r8 /)
      kbo(:,58,12) = (/ &
        & 0.97279e+03_r8,0.98508e+03_r8,0.99422e+03_r8,0.99838e+03_r8,0.10001e+04_r8 /)
      kbo(:,59,12) = (/ &
        & 0.97171e+03_r8,0.98327e+03_r8,0.99315e+03_r8,0.99818e+03_r8,0.99997e+03_r8 /)
      kbo(:,13,13) = (/ &
        & 0.99623e+03_r8,0.99978e+03_r8,0.10034e+04_r8,0.10050e+04_r8,0.10054e+04_r8 /)
      kbo(:,14,13) = (/ &
        & 0.99674e+03_r8,0.10002e+04_r8,0.10034e+04_r8,0.10050e+04_r8,0.10053e+04_r8 /)
      kbo(:,15,13) = (/ &
        & 0.99652e+03_r8,0.10007e+04_r8,0.10036e+04_r8,0.10051e+04_r8,0.10051e+04_r8 /)
      kbo(:,16,13) = (/ &
        & 0.99785e+03_r8,0.10007e+04_r8,0.10039e+04_r8,0.10049e+04_r8,0.10053e+04_r8 /)
      kbo(:,17,13) = (/ &
        & 0.99816e+03_r8,0.10017e+04_r8,0.10043e+04_r8,0.10052e+04_r8,0.10052e+04_r8 /)
      kbo(:,18,13) = (/ &
        & 0.99792e+03_r8,0.10021e+04_r8,0.10042e+04_r8,0.10053e+04_r8,0.10051e+04_r8 /)
      kbo(:,19,13) = (/ &
        & 0.99826e+03_r8,0.10023e+04_r8,0.10042e+04_r8,0.10053e+04_r8,0.10051e+04_r8 /)
      kbo(:,20,13) = (/ &
        & 0.99869e+03_r8,0.10028e+04_r8,0.10038e+04_r8,0.10053e+04_r8,0.10044e+04_r8 /)
      kbo(:,21,13) = (/ &
        & 0.99914e+03_r8,0.10028e+04_r8,0.10048e+04_r8,0.10054e+04_r8,0.10048e+04_r8 /)
      kbo(:,22,13) = (/ &
        & 0.99989e+03_r8,0.10035e+04_r8,0.10050e+04_r8,0.10053e+04_r8,0.10046e+04_r8 /)
      kbo(:,23,13) = (/ &
        & 0.10011e+04_r8,0.10037e+04_r8,0.10051e+04_r8,0.10053e+04_r8,0.10041e+04_r8 /)
      kbo(:,24,13) = (/ &
        & 0.10018e+04_r8,0.10041e+04_r8,0.10050e+04_r8,0.10052e+04_r8,0.10037e+04_r8 /)
      kbo(:,25,13) = (/ &
        & 0.10026e+04_r8,0.10040e+04_r8,0.10056e+04_r8,0.10050e+04_r8,0.10036e+04_r8 /)
      kbo(:,26,13) = (/ &
        & 0.10031e+04_r8,0.10048e+04_r8,0.10054e+04_r8,0.10050e+04_r8,0.10030e+04_r8 /)
      kbo(:,27,13) = (/ &
        & 0.10047e+04_r8,0.10050e+04_r8,0.10051e+04_r8,0.10045e+04_r8,0.10025e+04_r8 /)
      kbo(:,28,13) = (/ &
        & 0.10039e+04_r8,0.10052e+04_r8,0.10052e+04_r8,0.10041e+04_r8,0.10018e+04_r8 /)
      kbo(:,29,13) = (/ &
        & 0.10044e+04_r8,0.10053e+04_r8,0.10051e+04_r8,0.10037e+04_r8,0.10011e+04_r8 /)
      kbo(:,30,13) = (/ &
        & 0.10048e+04_r8,0.10054e+04_r8,0.10048e+04_r8,0.10029e+04_r8,0.99977e+03_r8 /)
      kbo(:,31,13) = (/ &
        & 0.10050e+04_r8,0.10053e+04_r8,0.10045e+04_r8,0.10025e+04_r8,0.99968e+03_r8 /)
      kbo(:,32,13) = (/ &
        & 0.10052e+04_r8,0.10050e+04_r8,0.10041e+04_r8,0.10015e+04_r8,0.99880e+03_r8 /)
      kbo(:,33,13) = (/ &
        & 0.10053e+04_r8,0.10050e+04_r8,0.10033e+04_r8,0.10008e+04_r8,0.99675e+03_r8 /)
      kbo(:,34,13) = (/ &
        & 0.10051e+04_r8,0.10048e+04_r8,0.10028e+04_r8,0.10000e+04_r8,0.99529e+03_r8 /)
      kbo(:,35,13) = (/ &
        & 0.10054e+04_r8,0.10047e+04_r8,0.10003e+04_r8,0.99992e+03_r8,0.99481e+03_r8 /)
      kbo(:,36,13) = (/ &
        & 0.10054e+04_r8,0.10046e+04_r8,0.10017e+04_r8,0.99987e+03_r8,0.99445e+03_r8 /)
      kbo(:,37,13) = (/ &
        & 0.10054e+04_r8,0.10048e+04_r8,0.10030e+04_r8,0.99995e+03_r8,0.99517e+03_r8 /)
      kbo(:,38,13) = (/ &
        & 0.10054e+04_r8,0.10049e+04_r8,0.10034e+04_r8,0.10006e+04_r8,0.99603e+03_r8 /)
      kbo(:,39,13) = (/ &
        & 0.10053e+04_r8,0.10051e+04_r8,0.10037e+04_r8,0.10011e+04_r8,0.99693e+03_r8 /)
      kbo(:,40,13) = (/ &
        & 0.10052e+04_r8,0.10052e+04_r8,0.10041e+04_r8,0.10018e+04_r8,0.99860e+03_r8 /)
      kbo(:,41,13) = (/ &
        & 0.10048e+04_r8,0.10053e+04_r8,0.10045e+04_r8,0.10023e+04_r8,0.99951e+03_r8 /)
      kbo(:,42,13) = (/ &
        & 0.10048e+04_r8,0.10054e+04_r8,0.10046e+04_r8,0.10024e+04_r8,0.10003e+04_r8 /)
      kbo(:,43,13) = (/ &
        & 0.10043e+04_r8,0.10053e+04_r8,0.10051e+04_r8,0.10038e+04_r8,0.10013e+04_r8 /)
      kbo(:,44,13) = (/ &
        & 0.10036e+04_r8,0.10051e+04_r8,0.10053e+04_r8,0.10044e+04_r8,0.10012e+04_r8 /)
      kbo(:,45,13) = (/ &
        & 0.10028e+04_r8,0.10048e+04_r8,0.10054e+04_r8,0.10048e+04_r8,0.10031e+04_r8 /)
      kbo(:,46,13) = (/ &
        & 0.10008e+04_r8,0.10042e+04_r8,0.10053e+04_r8,0.10052e+04_r8,0.10038e+04_r8 /)
      kbo(:,47,13) = (/ &
        & 0.10002e+04_r8,0.10039e+04_r8,0.10050e+04_r8,0.10053e+04_r8,0.10045e+04_r8 /)
      kbo(:,48,13) = (/ &
        & 0.99859e+03_r8,0.10025e+04_r8,0.10043e+04_r8,0.10054e+04_r8,0.10050e+04_r8 /)
      kbo(:,49,13) = (/ &
        & 0.99776e+03_r8,0.10009e+04_r8,0.10041e+04_r8,0.10052e+04_r8,0.10053e+04_r8 /)
      kbo(:,50,13) = (/ &
        & 0.99565e+03_r8,0.99944e+03_r8,0.10034e+04_r8,0.10049e+04_r8,0.10054e+04_r8 /)
      kbo(:,51,13) = (/ &
        & 0.99271e+03_r8,0.99811e+03_r8,0.10022e+04_r8,0.10043e+04_r8,0.10053e+04_r8 /)
      kbo(:,52,13) = (/ &
        & 0.99056e+03_r8,0.99717e+03_r8,0.10006e+04_r8,0.10036e+04_r8,0.10051e+04_r8 /)
      kbo(:,53,13) = (/ &
        & 0.98830e+03_r8,0.99502e+03_r8,0.99909e+03_r8,0.10028e+04_r8,0.10048e+04_r8 /)
      kbo(:,54,13) = (/ &
        & 0.98610e+03_r8,0.99275e+03_r8,0.99821e+03_r8,0.10021e+04_r8,0.10042e+04_r8 /)
      kbo(:,55,13) = (/ &
        & 0.98386e+03_r8,0.99045e+03_r8,0.99729e+03_r8,0.10008e+04_r8,0.10038e+04_r8 /)
      kbo(:,56,13) = (/ &
        & 0.98150e+03_r8,0.98846e+03_r8,0.99517e+03_r8,0.99919e+03_r8,0.10028e+04_r8 /)
      kbo(:,57,13) = (/ &
        & 0.97902e+03_r8,0.98636e+03_r8,0.99303e+03_r8,0.99832e+03_r8,0.10022e+04_r8 /)
      kbo(:,58,13) = (/ &
        & 0.97656e+03_r8,0.98426e+03_r8,0.99079e+03_r8,0.99735e+03_r8,0.10008e+04_r8 /)
      kbo(:,59,13) = (/ &
        & 0.97503e+03_r8,0.98337e+03_r8,0.99004e+03_r8,0.99647e+03_r8,0.10002e+04_r8 /)
      kbo(:,13,14) = (/ &
        & 0.99596e+03_r8,0.10023e+04_r8,0.10047e+04_r8,0.10067e+04_r8,0.10072e+04_r8 /)
      kbo(:,14,14) = (/ &
        & 0.99625e+03_r8,0.10024e+04_r8,0.10052e+04_r8,0.10068e+04_r8,0.10071e+04_r8 /)
      kbo(:,15,14) = (/ &
        & 0.99662e+03_r8,0.10025e+04_r8,0.10054e+04_r8,0.10069e+04_r8,0.10071e+04_r8 /)
      kbo(:,16,14) = (/ &
        & 0.99703e+03_r8,0.10026e+04_r8,0.10056e+04_r8,0.10070e+04_r8,0.10070e+04_r8 /)
      kbo(:,17,14) = (/ &
        & 0.99784e+03_r8,0.10032e+04_r8,0.10054e+04_r8,0.10071e+04_r8,0.10070e+04_r8 /)
      kbo(:,18,14) = (/ &
        & 0.99947e+03_r8,0.10032e+04_r8,0.10060e+04_r8,0.10071e+04_r8,0.10069e+04_r8 /)
      kbo(:,19,14) = (/ &
        & 0.10001e+04_r8,0.10036e+04_r8,0.10062e+04_r8,0.10071e+04_r8,0.10068e+04_r8 /)
      kbo(:,20,14) = (/ &
        & 0.10009e+04_r8,0.10037e+04_r8,0.10064e+04_r8,0.10076e+04_r8,0.10067e+04_r8 /)
      kbo(:,21,14) = (/ &
        & 0.10015e+04_r8,0.10046e+04_r8,0.10065e+04_r8,0.10072e+04_r8,0.10065e+04_r8 /)
      kbo(:,22,14) = (/ &
        & 0.10023e+04_r8,0.10047e+04_r8,0.10068e+04_r8,0.10071e+04_r8,0.10063e+04_r8 /)
      kbo(:,23,14) = (/ &
        & 0.10021e+04_r8,0.10055e+04_r8,0.10069e+04_r8,0.10071e+04_r8,0.10060e+04_r8 /)
      kbo(:,24,14) = (/ &
        & 0.10028e+04_r8,0.10059e+04_r8,0.10071e+04_r8,0.10069e+04_r8,0.10057e+04_r8 /)
      kbo(:,25,14) = (/ &
        & 0.10033e+04_r8,0.10062e+04_r8,0.10068e+04_r8,0.10068e+04_r8,0.10052e+04_r8 /)
      kbo(:,26,14) = (/ &
        & 0.10043e+04_r8,0.10066e+04_r8,0.10072e+04_r8,0.10061e+04_r8,0.10047e+04_r8 /)
      kbo(:,27,14) = (/ &
        & 0.10033e+04_r8,0.10068e+04_r8,0.10071e+04_r8,0.10062e+04_r8,0.10042e+04_r8 /)
      kbo(:,28,14) = (/ &
        & 0.10057e+04_r8,0.10070e+04_r8,0.10070e+04_r8,0.10058e+04_r8,0.10036e+04_r8 /)
      kbo(:,29,14) = (/ &
        & 0.10062e+04_r8,0.10075e+04_r8,0.10068e+04_r8,0.10053e+04_r8,0.10030e+04_r8 /)
      kbo(:,30,14) = (/ &
        & 0.10065e+04_r8,0.10072e+04_r8,0.10069e+04_r8,0.10048e+04_r8,0.10022e+04_r8 /)
      kbo(:,31,14) = (/ &
        & 0.10068e+04_r8,0.10071e+04_r8,0.10062e+04_r8,0.10042e+04_r8,0.10014e+04_r8 /)
      kbo(:,32,14) = (/ &
        & 0.10070e+04_r8,0.10070e+04_r8,0.10058e+04_r8,0.10035e+04_r8,0.99925e+03_r8 /)
      kbo(:,33,14) = (/ &
        & 0.10071e+04_r8,0.10068e+04_r8,0.10053e+04_r8,0.10029e+04_r8,0.99808e+03_r8 /)
      kbo(:,34,14) = (/ &
        & 0.10072e+04_r8,0.10065e+04_r8,0.10048e+04_r8,0.10021e+04_r8,0.99788e+03_r8 /)
      kbo(:,35,14) = (/ &
        & 0.10072e+04_r8,0.10064e+04_r8,0.10045e+04_r8,0.10016e+04_r8,0.99700e+03_r8 /)
      kbo(:,36,14) = (/ &
        & 0.10072e+04_r8,0.10063e+04_r8,0.10044e+04_r8,0.10015e+04_r8,0.99731e+03_r8 /)
      kbo(:,37,14) = (/ &
        & 0.10072e+04_r8,0.10065e+04_r8,0.10047e+04_r8,0.10021e+04_r8,0.99778e+03_r8 /)
      kbo(:,38,14) = (/ &
        & 0.10072e+04_r8,0.10067e+04_r8,0.10050e+04_r8,0.10026e+04_r8,0.99820e+03_r8 /)
      kbo(:,39,14) = (/ &
        & 0.10071e+04_r8,0.10068e+04_r8,0.10053e+04_r8,0.10030e+04_r8,0.99855e+03_r8 /)
      kbo(:,40,14) = (/ &
        & 0.10070e+04_r8,0.10070e+04_r8,0.10058e+04_r8,0.10036e+04_r8,0.99965e+03_r8 /)
      kbo(:,41,14) = (/ &
        & 0.10068e+04_r8,0.10071e+04_r8,0.10062e+04_r8,0.10042e+04_r8,0.10010e+04_r8 /)
      kbo(:,42,14) = (/ &
        & 0.10065e+04_r8,0.10072e+04_r8,0.10065e+04_r8,0.10048e+04_r8,0.10022e+04_r8 /)
      kbo(:,43,14) = (/ &
        & 0.10061e+04_r8,0.10071e+04_r8,0.10069e+04_r8,0.10055e+04_r8,0.10031e+04_r8 /)
      kbo(:,44,14) = (/ &
        & 0.10054e+04_r8,0.10069e+04_r8,0.10071e+04_r8,0.10061e+04_r8,0.10039e+04_r8 /)
      kbo(:,45,14) = (/ &
        & 0.10046e+04_r8,0.10066e+04_r8,0.10072e+04_r8,0.10065e+04_r8,0.10048e+04_r8 /)
      kbo(:,46,14) = (/ &
        & 0.10023e+04_r8,0.10060e+04_r8,0.10075e+04_r8,0.10069e+04_r8,0.10055e+04_r8 /)
      kbo(:,47,14) = (/ &
        & 0.10024e+04_r8,0.10044e+04_r8,0.10068e+04_r8,0.10071e+04_r8,0.10062e+04_r8 /)
      kbo(:,48,14) = (/ &
        & 0.10006e+04_r8,0.10039e+04_r8,0.10063e+04_r8,0.10072e+04_r8,0.10067e+04_r8 /)
      kbo(:,49,14) = (/ &
        & 0.99705e+03_r8,0.10026e+04_r8,0.10052e+04_r8,0.10070e+04_r8,0.10070e+04_r8 /)
      kbo(:,50,14) = (/ &
        & 0.99574e+03_r8,0.10014e+04_r8,0.10040e+04_r8,0.10066e+04_r8,0.10072e+04_r8 /)
      kbo(:,51,14) = (/ &
        & 0.99447e+03_r8,0.99966e+03_r8,0.10033e+04_r8,0.10065e+04_r8,0.10071e+04_r8 /)
      kbo(:,52,14) = (/ &
        & 0.99299e+03_r8,0.99670e+03_r8,0.10025e+04_r8,0.10054e+04_r8,0.10069e+04_r8 /)
      kbo(:,53,14) = (/ &
        & 0.99138e+03_r8,0.99552e+03_r8,0.10013e+04_r8,0.10044e+04_r8,0.10065e+04_r8 /)
      kbo(:,54,14) = (/ &
        & 0.98979e+03_r8,0.99462e+03_r8,0.99874e+03_r8,0.10030e+04_r8,0.10060e+04_r8 /)
      kbo(:,55,14) = (/ &
        & 0.98814e+03_r8,0.99291e+03_r8,0.99630e+03_r8,0.10029e+04_r8,0.10050e+04_r8 /)
      kbo(:,56,14) = (/ &
        & 0.98639e+03_r8,0.99150e+03_r8,0.99562e+03_r8,0.10014e+04_r8,0.10045e+04_r8 /)
      kbo(:,57,14) = (/ &
        & 0.98454e+03_r8,0.98998e+03_r8,0.99438e+03_r8,0.99904e+03_r8,0.10032e+04_r8 /)
      kbo(:,58,14) = (/ &
        & 0.98268e+03_r8,0.98844e+03_r8,0.99315e+03_r8,0.99688e+03_r8,0.10025e+04_r8 /)
      kbo(:,59,14) = (/ &
        & 0.98190e+03_r8,0.98779e+03_r8,0.99262e+03_r8,0.99638e+03_r8,0.10024e+04_r8 /)
      kbo(:,13,15) = (/ &
        & 0.99739e+03_r8,0.10017e+04_r8,0.10064e+04_r8,0.10076e+04_r8,0.10080e+04_r8 /)
      kbo(:,14,15) = (/ &
        & 0.99781e+03_r8,0.10021e+04_r8,0.10065e+04_r8,0.10077e+04_r8,0.10090e+04_r8 /)
      kbo(:,15,15) = (/ &
        & 0.99827e+03_r8,0.10029e+04_r8,0.10067e+04_r8,0.10077e+04_r8,0.10079e+04_r8 /)
      kbo(:,16,15) = (/ &
        & 0.99875e+03_r8,0.10040e+04_r8,0.10068e+04_r8,0.10078e+04_r8,0.10089e+04_r8 /)
      kbo(:,17,15) = (/ &
        & 0.99816e+03_r8,0.10041e+04_r8,0.10080e+04_r8,0.10079e+04_r8,0.10078e+04_r8 /)
      kbo(:,18,15) = (/ &
        & 0.99861e+03_r8,0.10065e+04_r8,0.10071e+04_r8,0.10090e+04_r8,0.10078e+04_r8 /)
      kbo(:,19,15) = (/ &
        & 0.10001e+04_r8,0.10056e+04_r8,0.10072e+04_r8,0.10079e+04_r8,0.10077e+04_r8 /)
      kbo(:,20,15) = (/ &
        & 0.99952e+03_r8,0.10059e+04_r8,0.10074e+04_r8,0.10090e+04_r8,0.10087e+04_r8 /)
      kbo(:,21,15) = (/ &
        & 0.10000e+04_r8,0.10061e+04_r8,0.10085e+04_r8,0.10080e+04_r8,0.10085e+04_r8 /)
      kbo(:,22,15) = (/ &
        & 0.10012e+04_r8,0.10064e+04_r8,0.10076e+04_r8,0.10090e+04_r8,0.10073e+04_r8 /)
      kbo(:,23,15) = (/ &
        & 0.10032e+04_r8,0.10067e+04_r8,0.10088e+04_r8,0.10079e+04_r8,0.10070e+04_r8 /)
      kbo(:,24,15) = (/ &
        & 0.10052e+04_r8,0.10070e+04_r8,0.10079e+04_r8,0.10089e+04_r8,0.10067e+04_r8 /)
      kbo(:,25,15) = (/ &
        & 0.10057e+04_r8,0.10083e+04_r8,0.10079e+04_r8,0.10098e+04_r8,0.10062e+04_r8 /)
      kbo(:,26,15) = (/ &
        & 0.10061e+04_r8,0.10085e+04_r8,0.10080e+04_r8,0.10075e+04_r8,0.10068e+04_r8 /)
      kbo(:,27,15) = (/ &
        & 0.10066e+04_r8,0.10087e+04_r8,0.10111e+04_r8,0.10072e+04_r8,0.10051e+04_r8 /)
      kbo(:,28,15) = (/ &
        & 0.10069e+04_r8,0.10089e+04_r8,0.10079e+04_r8,0.10068e+04_r8,0.10054e+04_r8 /)
      kbo(:,29,15) = (/ &
        & 0.10072e+04_r8,0.10069e+04_r8,0.10077e+04_r8,0.10063e+04_r8,0.10034e+04_r8 /)
      kbo(:,30,15) = (/ &
        & 0.10075e+04_r8,0.10111e+04_r8,0.10075e+04_r8,0.10068e+04_r8,0.10088e+04_r8 /)
      kbo(:,31,15) = (/ &
        & 0.10077e+04_r8,0.10080e+04_r8,0.10072e+04_r8,0.10061e+04_r8,0.10007e+04_r8 /)
      kbo(:,32,15) = (/ &
        & 0.10078e+04_r8,0.10089e+04_r8,0.10068e+04_r8,0.10043e+04_r8,0.10013e+04_r8 /)
      kbo(:,33,15) = (/ &
        & 0.10079e+04_r8,0.10077e+04_r8,0.10063e+04_r8,0.10044e+04_r8,0.10009e+04_r8 /)
      kbo(:,34,15) = (/ &
        & 0.10090e+04_r8,0.10075e+04_r8,0.10058e+04_r8,0.10025e+04_r8,0.10002e+04_r8 /)
      kbo(:,35,15) = (/ &
        & 0.10080e+04_r8,0.10073e+04_r8,0.10054e+04_r8,0.10021e+04_r8,0.99972e+03_r8 /)
      kbo(:,36,15) = (/ &
        & 0.10090e+04_r8,0.10073e+04_r8,0.10054e+04_r8,0.10020e+04_r8,0.99964e+03_r8 /)
      kbo(:,37,15) = (/ &
        & 0.10080e+04_r8,0.10075e+04_r8,0.10057e+04_r8,0.10024e+04_r8,0.10001e+04_r8 /)
      kbo(:,38,15) = (/ &
        & 0.10090e+04_r8,0.10076e+04_r8,0.10060e+04_r8,0.10040e+04_r8,0.10006e+04_r8 /)
      kbo(:,39,15) = (/ &
        & 0.10079e+04_r8,0.10077e+04_r8,0.10063e+04_r8,0.10034e+04_r8,0.10010e+04_r8 /)
      kbo(:,40,15) = (/ &
        & 0.10089e+04_r8,0.10089e+04_r8,0.10068e+04_r8,0.10054e+04_r8,0.10014e+04_r8 /)
      kbo(:,41,15) = (/ &
        & 0.10087e+04_r8,0.10090e+04_r8,0.10082e+04_r8,0.10051e+04_r8,0.10018e+04_r8 /)
      kbo(:,42,15) = (/ &
        & 0.10085e+04_r8,0.10090e+04_r8,0.10075e+04_r8,0.10058e+04_r8,0.10025e+04_r8 /)
      kbo(:,43,15) = (/ &
        & 0.10071e+04_r8,0.10079e+04_r8,0.10078e+04_r8,0.10086e+04_r8,0.10037e+04_r8 /)
      kbo(:,44,15) = (/ &
        & 0.10067e+04_r8,0.10088e+04_r8,0.10079e+04_r8,0.10071e+04_r8,0.10048e+04_r8 /)
      kbo(:,45,15) = (/ &
        & 0.10061e+04_r8,0.10075e+04_r8,0.10090e+04_r8,0.10096e+04_r8,0.10057e+04_r8 /)
      kbo(:,46,15) = (/ &
        & 0.10054e+04_r8,0.10071e+04_r8,0.10068e+04_r8,0.10078e+04_r8,0.10065e+04_r8 /)
      kbo(:,47,15) = (/ &
        & 0.10020e+04_r8,0.10065e+04_r8,0.10087e+04_r8,0.10079e+04_r8,0.10093e+04_r8 /)
      kbo(:,48,15) = (/ &
        & 0.99938e+03_r8,0.10058e+04_r8,0.10073e+04_r8,0.10079e+04_r8,0.10087e+04_r8 /)
      kbo(:,49,15) = (/ &
        & 0.99869e+03_r8,0.10038e+04_r8,0.10079e+04_r8,0.10099e+04_r8,0.10089e+04_r8 /)
      kbo(:,50,15) = (/ &
        & 0.99593e+03_r8,0.10003e+04_r8,0.10062e+04_r8,0.10075e+04_r8,0.10090e+04_r8 /)
      kbo(:,51,15) = (/ &
        & 0.99417e+03_r8,0.99877e+03_r8,0.10055e+04_r8,0.10061e+04_r8,0.10090e+04_r8 /)
      kbo(:,52,15) = (/ &
        & 0.99334e+03_r8,0.99717e+03_r8,0.10030e+04_r8,0.10077e+04_r8,0.10077e+04_r8 /)
      kbo(:,53,15) = (/ &
        & 0.99034e+03_r8,0.99548e+03_r8,0.99989e+03_r8,0.10071e+04_r8,0.10085e+04_r8 /)
      kbo(:,54,15) = (/ &
        & 0.98844e+03_r8,0.99385e+03_r8,0.99849e+03_r8,0.10064e+04_r8,0.10081e+04_r8 /)
      kbo(:,55,15) = (/ &
        & 0.98654e+03_r8,0.99323e+03_r8,0.99708e+03_r8,0.10005e+04_r8,0.10066e+04_r8 /)
      kbo(:,56,15) = (/ &
        & 0.98558e+03_r8,0.99048e+03_r8,0.99560e+03_r8,0.99999e+03_r8,0.10071e+04_r8 /)
      kbo(:,57,15) = (/ &
        & 0.98349e+03_r8,0.98867e+03_r8,0.99404e+03_r8,0.99866e+03_r8,0.10054e+04_r8 /)
      kbo(:,58,15) = (/ &
        & 0.98039e+03_r8,0.98688e+03_r8,0.99250e+03_r8,0.99837e+03_r8,0.10028e+04_r8 /)
      kbo(:,59,15) = (/ &
        & 0.97954e+03_r8,0.98614e+03_r8,0.99186e+03_r8,0.99679e+03_r8,0.10019e+04_r8 /)
      kbo(:,13,16) = (/ &
        & 0.98905e+03_r8,0.99319e+03_r8,0.10065e+04_r8,0.10075e+04_r8,0.10080e+04_r8 /)
      kbo(:,14,16) = (/ &
        & 0.98947e+03_r8,0.10009e+04_r8,0.10067e+04_r8,0.10076e+04_r8,0.10005e+04_r8 /)
      kbo(:,15,16) = (/ &
        & 0.98993e+03_r8,0.10052e+04_r8,0.10068e+04_r8,0.10076e+04_r8,0.10080e+04_r8 /)
      kbo(:,16,16) = (/ &
        & 0.99040e+03_r8,0.10054e+04_r8,0.10069e+04_r8,0.10077e+04_r8,0.10005e+04_r8 /)
      kbo(:,17,16) = (/ &
        & 0.99823e+03_r8,0.10056e+04_r8,0.99955e+03_r8,0.10078e+04_r8,0.10080e+04_r8 /)
      kbo(:,18,16) = (/ &
        & 0.99867e+03_r8,0.99832e+03_r8,0.10071e+04_r8,0.10003e+04_r8,0.10079e+04_r8 /)
      kbo(:,19,16) = (/ &
        & 0.99168e+03_r8,0.10059e+04_r8,0.10072e+04_r8,0.10078e+04_r8,0.10079e+04_r8 /)
      kbo(:,20,16) = (/ &
        & 0.99955e+03_r8,0.10061e+04_r8,0.10073e+04_r8,0.99297e+03_r8,0.10003e+04_r8 /)
      kbo(:,21,16) = (/ &
        & 0.10000e+04_r8,0.10063e+04_r8,0.99994e+03_r8,0.10079e+04_r8,0.10002e+04_r8 /)
      kbo(:,22,16) = (/ &
        & 0.10007e+04_r8,0.10066e+04_r8,0.10075e+04_r8,0.10005e+04_r8,0.10075e+04_r8 /)
      kbo(:,23,16) = (/ &
        & 0.10052e+04_r8,0.10068e+04_r8,0.10002e+04_r8,0.10080e+04_r8,0.10072e+04_r8 /)
      kbo(:,24,16) = (/ &
        & 0.10056e+04_r8,0.10070e+04_r8,0.10078e+04_r8,0.10005e+04_r8,0.10068e+04_r8 /)
      kbo(:,25,16) = (/ &
        & 0.10060e+04_r8,0.99977e+03_r8,0.10079e+04_r8,0.99294e+03_r8,0.10064e+04_r8 /)
      kbo(:,26,16) = (/ &
        & 0.10064e+04_r8,0.99996e+03_r8,0.10080e+04_r8,0.10077e+04_r8,0.99839e+03_r8 /)
      kbo(:,27,16) = (/ &
        & 0.10067e+04_r8,0.10001e+04_r8,0.98561e+03_r8,0.10074e+04_r8,0.10052e+04_r8 /)
      kbo(:,28,16) = (/ &
        & 0.10069e+04_r8,0.10003e+04_r8,0.10080e+04_r8,0.10070e+04_r8,0.99700e+03_r8 /)
      kbo(:,29,16) = (/ &
        & 0.10072e+04_r8,0.10078e+04_r8,0.10079e+04_r8,0.10065e+04_r8,0.10036e+04_r8 /)
      kbo(:,30,16) = (/ &
        & 0.10074e+04_r8,0.98555e+03_r8,0.10002e+04_r8,0.99845e+03_r8,0.95900e+03_r8 /)
      kbo(:,31,16) = (/ &
        & 0.10076e+04_r8,0.10080e+04_r8,0.10074e+04_r8,0.99776e+03_r8,0.10037e+04_r8 /)
      kbo(:,32,16) = (/ &
        & 0.10077e+04_r8,0.10005e+04_r8,0.10070e+04_r8,0.10044e+04_r8,0.10038e+04_r8 /)
      kbo(:,33,16) = (/ &
        & 0.10079e+04_r8,0.10079e+04_r8,0.10064e+04_r8,0.99602e+03_r8,0.10038e+04_r8 /)
      kbo(:,34,16) = (/ &
        & 0.10005e+04_r8,0.10077e+04_r8,0.10059e+04_r8,0.10036e+04_r8,0.10037e+04_r8 /)
      kbo(:,35,16) = (/ &
        & 0.10080e+04_r8,0.10075e+04_r8,0.10055e+04_r8,0.10037e+04_r8,0.10036e+04_r8 /)
      kbo(:,36,16) = (/ &
        & 0.10005e+04_r8,0.10075e+04_r8,0.10055e+04_r8,0.10037e+04_r8,0.10036e+04_r8 /)
      kbo(:,37,16) = (/ &
        & 0.10080e+04_r8,0.10077e+04_r8,0.10058e+04_r8,0.10037e+04_r8,0.10037e+04_r8 /)
      kbo(:,38,16) = (/ &
        & 0.10004e+04_r8,0.10078e+04_r8,0.10062e+04_r8,0.99569e+03_r8,0.10037e+04_r8 /)
      kbo(:,39,16) = (/ &
        & 0.10078e+04_r8,0.10079e+04_r8,0.10065e+04_r8,0.10036e+04_r8,0.10038e+04_r8 /)
      kbo(:,40,16) = (/ &
        & 0.10003e+04_r8,0.10005e+04_r8,0.10070e+04_r8,0.99698e+03_r8,0.10038e+04_r8 /)
      kbo(:,41,16) = (/ &
        & 0.10001e+04_r8,0.10005e+04_r8,0.99992e+03_r8,0.10052e+04_r8,0.10037e+04_r8 /)
      kbo(:,42,16) = (/ &
        & 0.99994e+03_r8,0.10005e+04_r8,0.10077e+04_r8,0.10059e+04_r8,0.10036e+04_r8 /)
      kbo(:,43,16) = (/ &
        & 0.10071e+04_r8,0.10078e+04_r8,0.10079e+04_r8,0.99172e+03_r8,0.10038e+04_r8 /)
      kbo(:,44,16) = (/ &
        & 0.10068e+04_r8,0.10002e+04_r8,0.10080e+04_r8,0.10072e+04_r8,0.10049e+04_r8 /)
      kbo(:,45,16) = (/ &
        & 0.10063e+04_r8,0.10074e+04_r8,0.10005e+04_r8,0.99276e+03_r8,0.10059e+04_r8 /)
      kbo(:,46,16) = (/ &
        & 0.10057e+04_r8,0.10071e+04_r8,0.10078e+04_r8,0.10079e+04_r8,0.10067e+04_r8 /)
      kbo(:,47,16) = (/ &
        & 0.10009e+04_r8,0.10067e+04_r8,0.10001e+04_r8,0.10080e+04_r8,0.99247e+03_r8 /)
      kbo(:,48,16) = (/ &
        & 0.99941e+03_r8,0.10061e+04_r8,0.10073e+04_r8,0.10079e+04_r8,0.10004e+04_r8 /)
      kbo(:,49,16) = (/ &
        & 0.99034e+03_r8,0.10054e+04_r8,0.99943e+03_r8,0.99276e+03_r8,0.10005e+04_r8 /)
      kbo(:,50,16) = (/ &
        & 0.99601e+03_r8,0.10003e+04_r8,0.10064e+04_r8,0.10074e+04_r8,0.10005e+04_r8 /)
      kbo(:,51,16) = (/ &
        & 0.99422e+03_r8,0.99882e+03_r8,0.10058e+04_r8,0.10071e+04_r8,0.10003e+04_r8 /)
      kbo(:,52,16) = (/ &
        & 0.98496e+03_r8,0.99726e+03_r8,0.10013e+04_r8,0.99930e+03_r8,0.10076e+04_r8 /)
      kbo(:,53,16) = (/ &
        & 0.99030e+03_r8,0.99555e+03_r8,0.99990e+03_r8,0.99882e+03_r8,0.99991e+03_r8 /)
      kbo(:,54,16) = (/ &
        & 0.98836e+03_r8,0.98653e+03_r8,0.99856e+03_r8,0.99827e+03_r8,0.99962e+03_r8 /)
      kbo(:,55,16) = (/ &
        & 0.98643e+03_r8,0.98485e+03_r8,0.99716e+03_r8,0.10012e+04_r8,0.10067e+04_r8 /)
      kbo(:,56,16) = (/ &
        & 0.97714e+03_r8,0.99044e+03_r8,0.99567e+03_r8,0.99999e+03_r8,0.99885e+03_r8 /)
      kbo(:,57,16) = (/ &
        & 0.97511e+03_r8,0.98860e+03_r8,0.99409e+03_r8,0.99872e+03_r8,0.10058e+04_r8 /)
      kbo(:,58,16) = (/ &
        & 0.98036e+03_r8,0.98678e+03_r8,0.99251e+03_r8,0.99003e+03_r8,0.10052e+04_r8 /)
      kbo(:,59,16) = (/ &
        & 0.97953e+03_r8,0.98603e+03_r8,0.99185e+03_r8,0.99687e+03_r8,0.10009e+04_r8 /)
     
      end subroutine sw_kgb27

! **************************************************************************
      subroutine sw_kgb28
! **************************************************************************

      use shr_kind_mod, only: r8 => shr_kind_r8

!      use parkind, only : jpim, jprb 
      use rrsw_kg28, only : kao, kbo, sfluxrefo, &
                            rayl, strrat, layreffr

      implicit none
      save

! Kurucz solar source function
      sfluxrefo(:,1) = (/ &
        & 1.06156_r8    , 0.599910_r8   , 0.422462_r8   , 0.400077_r8   , &
        & 0.282221_r8   , 0.187893_r8   , 6.77357e-02_r8, 3.04572e-02_r8, &
        & 2.00442e-02_r8, 2.30786e-03_r8, 2.08824e-03_r8, 1.42604e-03_r8, &
        & 9.67384e-04_r8, 6.35362e-04_r8, 1.47727e-04_r8, 6.87639e-06_r8 /)
      sfluxrefo(:,2) = (/ &
        & 1.07598_r8    , 0.585099_r8   , 0.422852_r8   , 0.400077_r8   , &
        & 0.282221_r8   , 0.187893_r8   , 6.69686e-02_r8, 3.09070e-02_r8, &
        & 2.02400e-02_r8, 2.47760e-03_r8, 1.89411e-03_r8, 1.41122e-03_r8, &
        & 1.12449e-03_r8, 5.73505e-04_r8, 2.04160e-04_r8, 1.58371e-05_r8 /)
      sfluxrefo(:,3) = (/ &
        & 0.461647_r8   , 0.406113_r8   , 0.332506_r8   , 0.307508_r8   , &
        & 0.211167_r8   , 0.235457_r8   , 0.495886_r8   , 0.363921_r8   , &
        & 0.192700_r8   , 2.04678e-02_r8, 1.55407e-02_r8, 1.03882e-02_r8, &
        & 1.10778e-02_r8, 1.00504e-02_r8, 4.93497e-03_r8, 5.73410e-04_r8 /)
      sfluxrefo(:,4) = (/ &
        & 0.132669_r8   , 0.175058_r8   , 0.359263_r8   , 0.388142_r8   , &
        & 0.350359_r8   , 0.475892_r8   , 0.489593_r8   , 0.408437_r8   , &
        & 0.221049_r8   , 1.94514e-02_r8, 1.54848e-02_r8, 1.44999e-02_r8, &
        & 1.44568e-02_r8, 1.00527e-02_r8, 4.95897e-03_r8, 5.73327e-04_r8 /)
      sfluxrefo(:,5) = (/ &
        & 7.54800e-02_r8, 0.232246_r8   , 0.359263_r8   , 0.388142_r8   , &
        & 0.350359_r8   , 0.426317_r8   , 0.493485_r8   , 0.432016_r8   , &
        & 0.239203_r8   , 1.74951e-02_r8, 1.74477e-02_r8, 1.83566e-02_r8, &
        & 1.44818e-02_r8, 1.01048e-02_r8, 4.97487e-03_r8, 5.66831e-04_r8 /)

! Rayleigh extinction coefficient at v = ????? cm-1.
      rayl = 2.02e-05_r8

      strrat = 6.67029e-07_r8

      layreffr = 58

!     ------------------------------------------------------------------
!     The array KAO contains absorption coefs at the 16 chosen g-values 
!     for a range of pressure levels> ~100mb, temperatures, and binary
!     species parameters (see taumol.f for definition).  The first 
!     index in the array, JS, runs from 1 to 9, and corresponds to 
!     different values of the binary species parameter.  For instance, 
!     JS=1 refers to dry air, JS = 2 corresponds to the paramter value 1/8, 
!     JS = 3 corresponds to the parameter value 2/8, etc.  The second index
!     in the array, JT, which runs from 1 to 5, corresponds to different
!     temperatures.  More specifically, JT = 3 means that the data are for
!     the reference temperature TREF for this  pressure level, JT = 2 refers
!     to TREF-15, JT = 1 is for TREF-30, JT = 4 is for TREF+15, and JT = 5
!     is for TREF+30.  The third index, JP, runs from 1 to 13 and refers
!     to the JPth reference pressure level (see taumol.f for these levels
!     in mb).  The fourth index, IG, goes from 1 to 16, and indicates
!     which g-interval the absorption coefficients are for.
!     -----------------------------------------------------------------

      kao(:, 1, 1, 1) = (/ &
        & 0.46447e+02_r8,0.18001e+03_r8,0.31338e+03_r8,0.44652e+03_r8,0.54636e+03_r8, &
        & 0.54173e+03_r8,0.45707e+03_r8,0.27363e+03_r8,0.35000e+02_r8 /)
      kao(:, 2, 1, 1) = (/ &
        & 0.45270e+02_r8,0.17886e+03_r8,0.31225e+03_r8,0.44541e+03_r8,0.54177e+03_r8, &
        & 0.53436e+03_r8,0.44932e+03_r8,0.26748e+03_r8,0.35000e+02_r8 /)
      kao(:, 3, 1, 1) = (/ &
        & 0.44214e+02_r8,0.17776e+03_r8,0.31115e+03_r8,0.44427e+03_r8,0.53733e+03_r8, &
        & 0.52756e+03_r8,0.44224e+03_r8,0.26195e+03_r8,0.35000e+02_r8 /)
      kao(:, 4, 1, 1) = (/ &
        & 0.43259e+02_r8,0.17673e+03_r8,0.31005e+03_r8,0.44305e+03_r8,0.53298e+03_r8, &
        & 0.52129e+03_r8,0.43574e+03_r8,0.25696e+03_r8,0.35000e+02_r8 /)
      kao(:, 5, 1, 1) = (/ &
        & 0.42393e+02_r8,0.17575e+03_r8,0.30896e+03_r8,0.44173e+03_r8,0.52883e+03_r8, &
        & 0.51548e+03_r8,0.42976e+03_r8,0.25242e+03_r8,0.35000e+02_r8 /)
      kao(:, 1, 2, 1) = (/ &
        & 0.42908e+02_r8,0.17695e+03_r8,0.31077e+03_r8,0.44434e+03_r8,0.53161e+03_r8, &
        & 0.51895e+03_r8,0.43332e+03_r8,0.25512e+03_r8,0.35000e+02_r8 /)
      kao(:, 2, 2, 1) = (/ &
        & 0.41899e+02_r8,0.17596e+03_r8,0.30980e+03_r8,0.44336e+03_r8,0.52686e+03_r8, &
        & 0.51213e+03_r8,0.42632e+03_r8,0.24984e+03_r8,0.35000e+02_r8 /)
      kao(:, 3, 2, 1) = (/ &
        & 0.40995e+02_r8,0.17502e+03_r8,0.30884e+03_r8,0.44232e+03_r8,0.52230e+03_r8, &
        & 0.50592e+03_r8,0.41995e+03_r8,0.24511e+03_r8,0.35000e+02_r8 /)
      kao(:, 4, 2, 1) = (/ &
        & 0.40181e+02_r8,0.17412e+03_r8,0.30788e+03_r8,0.44119e+03_r8,0.51785e+03_r8, &
        & 0.50025e+03_r8,0.41414e+03_r8,0.24085e+03_r8,0.35000e+02_r8 /)
      kao(:, 5, 2, 1) = (/ &
        & 0.39443e+02_r8,0.17326e+03_r8,0.30691e+03_r8,0.43992e+03_r8,0.51364e+03_r8, &
        & 0.49503e+03_r8,0.40882e+03_r8,0.23699e+03_r8,0.35000e+02_r8 /)
      kao(:, 1, 3, 1) = (/ &
        & 0.40126e+02_r8,0.17457e+03_r8,0.30876e+03_r8,0.44248e+03_r8,0.51755e+03_r8, &
        & 0.49986e+03_r8,0.41375e+03_r8,0.24056e+03_r8,0.35000e+02_r8 /)
      kao(:, 2, 3, 1) = (/ &
        & 0.39240e+02_r8,0.17370e+03_r8,0.30792e+03_r8,0.44146e+03_r8,0.51254e+03_r8, &
        & 0.49358e+03_r8,0.40735e+03_r8,0.23593e+03_r8,0.35000e+02_r8 /)
      kao(:, 3, 3, 1) = (/ &
        & 0.38450e+02_r8,0.17288e+03_r8,0.30708e+03_r8,0.44031e+03_r8,0.50793e+03_r8, &
        & 0.48786e+03_r8,0.40155e+03_r8,0.23179e+03_r8,0.35000e+02_r8 /)
      kao(:, 4, 3, 1) = (/ &
        & 0.37740e+02_r8,0.17210e+03_r8,0.30624e+03_r8,0.43908e+03_r8,0.50368e+03_r8, &
        & 0.48264e+03_r8,0.39629e+03_r8,0.22808e+03_r8,0.35000e+02_r8 /)
      kao(:, 5, 3, 1) = (/ &
        & 0.37099e+02_r8,0.17134e+03_r8,0.30539e+03_r8,0.43781e+03_r8,0.49975e+03_r8, &
        & 0.47787e+03_r8,0.39149e+03_r8,0.22473e+03_r8,0.35000e+02_r8 /)
      kao(:, 1, 4, 1) = (/ &
        & 0.37818e+02_r8,0.17258e+03_r8,0.30708e+03_r8,0.43967e+03_r8,0.50412e+03_r8, &
        & 0.48321e+03_r8,0.39687e+03_r8,0.22848e+03_r8,0.35000e+02_r8 /)
      kao(:, 2, 4, 1) = (/ &
        & 0.37034e+02_r8,0.17183e+03_r8,0.30636e+03_r8,0.43833e+03_r8,0.49935e+03_r8, &
        & 0.47738e+03_r8,0.39100e+03_r8,0.22439e+03_r8,0.35000e+02_r8 /)
      kao(:, 3, 4, 1) = (/ &
        & 0.36338e+02_r8,0.17111e+03_r8,0.30564e+03_r8,0.43700e+03_r8,0.49496e+03_r8, &
        & 0.47212e+03_r8,0.38572e+03_r8,0.22075e+03_r8,0.35000e+02_r8 /)
      kao(:, 4, 4, 1) = (/ &
        & 0.35716e+02_r8,0.17043e+03_r8,0.30491e+03_r8,0.43569e+03_r8,0.49094e+03_r8, &
        & 0.46732e+03_r8,0.38094e+03_r8,0.21749e+03_r8,0.35000e+02_r8 /)
      kao(:, 5, 4, 1) = (/ &
        & 0.35156e+02_r8,0.16977e+03_r8,0.30416e+03_r8,0.43437e+03_r8,0.48726e+03_r8, &
        & 0.46294e+03_r8,0.37660e+03_r8,0.21456e+03_r8,0.35000e+02_r8 /)
      kao(:, 1, 5, 1) = (/ &
        & 0.35857e+02_r8,0.17089e+03_r8,0.30563e+03_r8,0.43619e+03_r8,0.49186e+03_r8, &
        & 0.46841e+03_r8,0.38202e+03_r8,0.21822e+03_r8,0.35000e+02_r8 /)
      kao(:, 2, 5, 1) = (/ &
        & 0.35163e+02_r8,0.17023e+03_r8,0.30502e+03_r8,0.43478e+03_r8,0.48731e+03_r8, &
        & 0.46300e+03_r8,0.37666e+03_r8,0.21460e+03_r8,0.35000e+02_r8 /)
      kao(:, 3, 5, 1) = (/ &
        & 0.34550e+02_r8,0.16961e+03_r8,0.30441e+03_r8,0.43332e+03_r8,0.48321e+03_r8, &
        & 0.45813e+03_r8,0.37186e+03_r8,0.21139e+03_r8,0.35000e+02_r8 /)
      kao(:, 4, 5, 1) = (/ &
        & 0.34004e+02_r8,0.16902e+03_r8,0.30378e+03_r8,0.43194e+03_r8,0.47950e+03_r8, &
        & 0.45375e+03_r8,0.36755e+03_r8,0.20853e+03_r8,0.35000e+02_r8 /)
      kao(:, 5, 5, 1) = (/ &
        & 0.33514e+02_r8,0.16844e+03_r8,0.30312e+03_r8,0.43058e+03_r8,0.47611e+03_r8, &
        & 0.44977e+03_r8,0.36365e+03_r8,0.20597e+03_r8,0.35000e+02_r8 /)
      kao(:, 1, 6, 1) = (/ &
        & 0.34212e+02_r8,0.16946e+03_r8,0.30440e+03_r8,0.43247e+03_r8,0.48092e+03_r8, &
        & 0.45542e+03_r8,0.36920e+03_r8,0.20962e+03_r8,0.35000e+02_r8 /)
      kao(:, 2, 6, 1) = (/ &
        & 0.33595e+02_r8,0.16889e+03_r8,0.30389e+03_r8,0.43093e+03_r8,0.47667e+03_r8, &
        & 0.45043e+03_r8,0.36430e+03_r8,0.20639e+03_r8,0.35000e+02_r8 /)
      kao(:, 3, 6, 1) = (/ &
        & 0.33052e+02_r8,0.16835e+03_r8,0.30337e+03_r8,0.42946e+03_r8,0.47287e+03_r8, &
        & 0.44599e+03_r8,0.35993e+03_r8,0.20355e+03_r8,0.35000e+02_r8 /)
      kao(:, 4, 6, 1) = (/ &
        & 0.32571e+02_r8,0.16784e+03_r8,0.30283e+03_r8,0.42807e+03_r8,0.46947e+03_r8, &
        & 0.44201e+03_r8,0.35602e+03_r8,0.20103e+03_r8,0.35000e+02_r8 /)
      kao(:, 5, 6, 1) = (/ &
        & 0.32141e+02_r8,0.16733e+03_r8,0.30227e+03_r8,0.42674e+03_r8,0.46640e+03_r8, &
        & 0.43842e+03_r8,0.35250e+03_r8,0.19879e+03_r8,0.35000e+02_r8 /)
      kao(:, 1, 7, 1) = (/ &
        & 0.32812e+02_r8,0.16823e+03_r8,0.30334e+03_r8,0.42859e+03_r8,0.47118e+03_r8, &
        & 0.44401e+03_r8,0.35799e+03_r8,0.20230e+03_r8,0.35000e+02_r8 /)
      kao(:, 2, 7, 1) = (/ &
        & 0.32263e+02_r8,0.16774e+03_r8,0.30291e+03_r8,0.42708e+03_r8,0.46727e+03_r8, &
        & 0.43944e+03_r8,0.35350e+03_r8,0.19942e+03_r8,0.35000e+02_r8 /)
      kao(:, 3, 7, 1) = (/ &
        & 0.31782e+02_r8,0.16728e+03_r8,0.30248e+03_r8,0.42558e+03_r8,0.46381e+03_r8, &
        & 0.43539e+03_r8,0.34954e+03_r8,0.19691e+03_r8,0.35000e+02_r8 /)
      kao(:, 4, 7, 1) = (/ &
        & 0.31357e+02_r8,0.16683e+03_r8,0.30203e+03_r8,0.42413e+03_r8,0.46069e+03_r8, &
        & 0.43177e+03_r8,0.34599e+03_r8,0.19468e+03_r8,0.35000e+02_r8 /)
      kao(:, 5, 7, 1) = (/ &
        & 0.30980e+02_r8,0.16640e+03_r8,0.30154e+03_r8,0.42276e+03_r8,0.45787e+03_r8, &
        & 0.42852e+03_r8,0.34280e+03_r8,0.19271e+03_r8,0.35000e+02_r8 /)
      kao(:, 1, 8, 1) = (/ &
        & 0.31614e+02_r8,0.16716e+03_r8,0.30239e+03_r8,0.42473e+03_r8,0.46259e+03_r8, &
        & 0.43397e+03_r8,0.34814e+03_r8,0.19603e+03_r8,0.35000e+02_r8 /)
      kao(:, 2, 8, 1) = (/ &
        & 0.31125e+02_r8,0.16674e+03_r8,0.30206e+03_r8,0.42311e+03_r8,0.45896e+03_r8, &
        & 0.42978e+03_r8,0.34403e+03_r8,0.19347e+03_r8,0.35000e+02_r8 /)
      kao(:, 3, 8, 1) = (/ &
        & 0.30699e+02_r8,0.16635e+03_r8,0.30170e+03_r8,0.42163e+03_r8,0.45573e+03_r8, &
        & 0.42608e+03_r8,0.34039e+03_r8,0.19124e+03_r8,0.35000e+02_r8 /)
      kao(:, 4, 8, 1) = (/ &
        & 0.30325e+02_r8,0.16597e+03_r8,0.30133e+03_r8,0.42027e+03_r8,0.45286e+03_r8, &
        & 0.42281e+03_r8,0.33716e+03_r8,0.18928e+03_r8,0.35000e+02_r8 /)
      kao(:, 5, 8, 1) = (/ &
        & 0.29993e+02_r8,0.16559e+03_r8,0.30092e+03_r8,0.41901e+03_r8,0.45030e+03_r8, &
        & 0.41988e+03_r8,0.33427e+03_r8,0.18755e+03_r8,0.35000e+02_r8 /)
      kao(:, 1, 9, 1) = (/ &
        & 0.30594e+02_r8,0.16624e+03_r8,0.30156e+03_r8,0.42087e+03_r8,0.45493e+03_r8, &
        & 0.42517e+03_r8,0.33949e+03_r8,0.19069e+03_r8,0.35000e+02_r8 /)
      kao(:, 2, 9, 1) = (/ &
        & 0.30158e+02_r8,0.16589e+03_r8,0.30131e+03_r8,0.41937e+03_r8,0.45157e+03_r8, &
        & 0.42134e+03_r8,0.33570e+03_r8,0.18841e+03_r8,0.35000e+02_r8 /)
      kao(:, 3, 9, 1) = (/ &
        & 0.29780e+02_r8,0.16556e+03_r8,0.30103e+03_r8,0.41800e+03_r8,0.44864e+03_r8, &
        & 0.41799e+03_r8,0.33239e+03_r8,0.18643e+03_r8,0.35000e+02_r8 /)
      kao(:, 4, 9, 1) = (/ &
        & 0.29450e+02_r8,0.16523e+03_r8,0.30072e+03_r8,0.41674e+03_r8,0.44606e+03_r8, &
        & 0.41504e+03_r8,0.32946e+03_r8,0.18471e+03_r8,0.35000e+02_r8 /)
      kao(:, 5, 9, 1) = (/ &
        & 0.29159e+02_r8,0.16491e+03_r8,0.30039e+03_r8,0.41557e+03_r8,0.44377e+03_r8, &
        & 0.41242e+03_r8,0.32686e+03_r8,0.18318e+03_r8,0.35000e+02_r8 /)
      kao(:, 1,10, 1) = (/ &
        & 0.29691e+02_r8,0.16541e+03_r8,0.30081e+03_r8,0.41722e+03_r8,0.44795e+03_r8, &
        & 0.41720e+03_r8,0.33160e+03_r8,0.18597e+03_r8,0.35000e+02_r8 /)
      kao(:, 2,10, 1) = (/ &
        & 0.29307e+02_r8,0.16512e+03_r8,0.30063e+03_r8,0.41581e+03_r8,0.44493e+03_r8, &
        & 0.41375e+03_r8,0.32818e+03_r8,0.18396e+03_r8,0.35000e+02_r8 /)
      kao(:, 3,10, 1) = (/ &
        & 0.28975e+02_r8,0.16485e+03_r8,0.30042e+03_r8,0.41454e+03_r8,0.44231e+03_r8, &
        & 0.41076e+03_r8,0.32520e+03_r8,0.18222e+03_r8,0.35000e+02_r8 /)
      kao(:, 4,10, 1) = (/ &
        & 0.28687e+02_r8,0.16458e+03_r8,0.30018e+03_r8,0.41340e+03_r8,0.44002e+03_r8, &
        & 0.40814e+03_r8,0.32259e+03_r8,0.18071e+03_r8,0.35000e+02_r8 /)
      kao(:, 5,10, 1) = (/ &
        & 0.28434e+02_r8,0.16431e+03_r8,0.29989e+03_r8,0.41235e+03_r8,0.43799e+03_r8, &
        & 0.40583e+03_r8,0.32028e+03_r8,0.17939e+03_r8,0.35000e+02_r8 /)
      kao(:, 1,11, 1) = (/ &
        & 0.28760e+02_r8,0.16459e+03_r8,0.30010e+03_r8,0.41321e+03_r8,0.44060e+03_r8, &
        & 0.40880e+03_r8,0.32325e+03_r8,0.18109e+03_r8,0.35000e+02_r8 /)
      kao(:, 2,11, 1) = (/ &
        & 0.28444e+02_r8,0.16436e+03_r8,0.29997e+03_r8,0.41200e+03_r8,0.43807e+03_r8, &
        & 0.40592e+03_r8,0.32038e+03_r8,0.17944e+03_r8,0.35000e+02_r8 /)
      kao(:, 3,11, 1) = (/ &
        & 0.28173e+02_r8,0.16414e+03_r8,0.29981e+03_r8,0.41092e+03_r8,0.43587e+03_r8, &
        & 0.40342e+03_r8,0.31788e+03_r8,0.17802e+03_r8,0.35000e+02_r8 /)
      kao(:, 4,11, 1) = (/ &
        & 0.27937e+02_r8,0.16392e+03_r8,0.29960e+03_r8,0.40994e+03_r8,0.43395e+03_r8, &
        & 0.40124e+03_r8,0.31570e+03_r8,0.17679e+03_r8,0.35000e+02_r8 /)
      kao(:, 5,11, 1) = (/ &
        & 0.27730e+02_r8,0.16369e+03_r8,0.29936e+03_r8,0.40905e+03_r8,0.43224e+03_r8, &
        & 0.39931e+03_r8,0.31377e+03_r8,0.17571e+03_r8,0.35000e+02_r8 /)
      kao(:, 1,12, 1) = (/ &
        & 0.27995e+02_r8,0.16391e+03_r8,0.29951e+03_r8,0.40970e+03_r8,0.43443e+03_r8, &
        & 0.40178e+03_r8,0.31624e+03_r8,0.17709e+03_r8,0.35000e+02_r8 /)
      kao(:, 2,12, 1) = (/ &
        & 0.27737e+02_r8,0.16374e+03_r8,0.29943e+03_r8,0.40869e+03_r8,0.43230e+03_r8, &
        & 0.39938e+03_r8,0.31384e+03_r8,0.17574e+03_r8,0.35000e+02_r8 /)
      kao(:, 3,12, 1) = (/ &
        & 0.27515e+02_r8,0.16356e+03_r8,0.29930e+03_r8,0.40779e+03_r8,0.43046e+03_r8, &
        & 0.39730e+03_r8,0.31176e+03_r8,0.17458e+03_r8,0.35000e+02_r8 /)
      kao(:, 4,12, 1) = (/ &
        & 0.27322e+02_r8,0.16338e+03_r8,0.29913e+03_r8,0.40697e+03_r8,0.42883e+03_r8, &
        & 0.39548e+03_r8,0.30994e+03_r8,0.17357e+03_r8,0.35000e+02_r8 /)
      kao(:, 5,12, 1) = (/ &
        & 0.27152e+02_r8,0.16318e+03_r8,0.29892e+03_r8,0.40622e+03_r8,0.42740e+03_r8, &
        & 0.39387e+03_r8,0.30834e+03_r8,0.17268e+03_r8,0.35000e+02_r8 /)
      kao(:, 1,13, 1) = (/ &
        & 0.27369e+02_r8,0.16336e+03_r8,0.29903e+03_r8,0.40671e+03_r8,0.42924e+03_r8, &
        & 0.39593e+03_r8,0.31039e+03_r8,0.17382e+03_r8,0.35000e+02_r8 /)
      kao(:, 2,13, 1) = (/ &
        & 0.27158e+02_r8,0.16323e+03_r8,0.29898e+03_r8,0.40587e+03_r8,0.42745e+03_r8, &
        & 0.39393e+03_r8,0.30840e+03_r8,0.17271e+03_r8,0.35000e+02_r8 /)
      kao(:, 3,13, 1) = (/ &
        & 0.26976e+02_r8,0.16309e+03_r8,0.29889e+03_r8,0.40513e+03_r8,0.42590e+03_r8, &
        & 0.39221e+03_r8,0.30667e+03_r8,0.17176e+03_r8,0.35000e+02_r8 /)
      kao(:, 4,13, 1) = (/ &
        & 0.26818e+02_r8,0.16293e+03_r8,0.29875e+03_r8,0.40445e+03_r8,0.42455e+03_r8, &
        & 0.39070e+03_r8,0.30516e+03_r8,0.17093e+03_r8,0.35000e+02_r8 /)
      kao(:, 5,13, 1) = (/ &
        & 0.26679e+02_r8,0.16276e+03_r8,0.29855e+03_r8,0.40381e+03_r8,0.42335e+03_r8, &
        & 0.38937e+03_r8,0.30384e+03_r8,0.17021e+03_r8,0.35000e+02_r8 /)
      kao(:, 1, 1, 2) = (/ &
        & 0.17271e+03_r8,0.27646e+03_r8,0.38039e+03_r8,0.48420e+03_r8,0.56932e+03_r8, &
        & 0.57534e+03_r8,0.47873e+03_r8,0.28147e+03_r8,0.71840e+02_r8 /)
      kao(:, 2, 1, 2) = (/ &
        & 0.16834e+03_r8,0.27246e+03_r8,0.37678e+03_r8,0.48091e+03_r8,0.56471e+03_r8, &
        & 0.56734e+03_r8,0.47005e+03_r8,0.27593e+03_r8,0.71840e+02_r8 /)
      kao(:, 3, 1, 2) = (/ &
        & 0.16441e+03_r8,0.26883e+03_r8,0.37341e+03_r8,0.47777e+03_r8,0.56037e+03_r8, &
        & 0.56003e+03_r8,0.46210e+03_r8,0.27096e+03_r8,0.71840e+02_r8 /)
      kao(:, 4, 1, 2) = (/ &
        & 0.16086e+03_r8,0.26548e+03_r8,0.37025e+03_r8,0.47479e+03_r8,0.55629e+03_r8, &
        & 0.55327e+03_r8,0.45481e+03_r8,0.26647e+03_r8,0.71840e+02_r8 /)
      kao(:, 5, 1, 2) = (/ &
        & 0.15764e+03_r8,0.26237e+03_r8,0.36725e+03_r8,0.47195e+03_r8,0.55235e+03_r8, &
        & 0.54701e+03_r8,0.44810e+03_r8,0.26239e+03_r8,0.71840e+02_r8 /)
      kao(:, 1, 2, 2) = (/ &
        & 0.15955e+03_r8,0.26500e+03_r8,0.37067e+03_r8,0.47595e+03_r8,0.55480e+03_r8, &
        & 0.55074e+03_r8,0.45210e+03_r8,0.26482e+03_r8,0.71840e+02_r8 /)
      kao(:, 2, 2, 2) = (/ &
        & 0.15580e+03_r8,0.26157e+03_r8,0.36756e+03_r8,0.47303e+03_r8,0.55028e+03_r8, &
        & 0.54339e+03_r8,0.44423e+03_r8,0.26007e+03_r8,0.71840e+02_r8 /)
      kao(:, 3, 2, 2) = (/ &
        & 0.15244e+03_r8,0.25844e+03_r8,0.36465e+03_r8,0.47023e+03_r8,0.54619e+03_r8, &
        & 0.53664e+03_r8,0.43708e+03_r8,0.25581e+03_r8,0.71840e+02_r8 /)
      kao(:, 4, 2, 2) = (/ &
        & 0.14941e+03_r8,0.25556e+03_r8,0.36191e+03_r8,0.46753e+03_r8,0.54253e+03_r8, &
        & 0.53041e+03_r8,0.43052e+03_r8,0.25198e+03_r8,0.71840e+02_r8 /)
      kao(:, 5, 2, 2) = (/ &
        & 0.14667e+03_r8,0.25289e+03_r8,0.35930e+03_r8,0.46494e+03_r8,0.53908e+03_r8, &
        & 0.52470e+03_r8,0.42448e+03_r8,0.24851e+03_r8,0.71840e+02_r8 /)
      kao(:, 1, 3, 2) = (/ &
        & 0.14921e+03_r8,0.25601e+03_r8,0.36308e+03_r8,0.46872e+03_r8,0.54234e+03_r8, &
        & 0.52999e+03_r8,0.43007e+03_r8,0.25172e+03_r8,0.71840e+02_r8 /)
      kao(:, 2, 3, 2) = (/ &
        & 0.14591e+03_r8,0.25301e+03_r8,0.36036e+03_r8,0.46599e+03_r8,0.53834e+03_r8, &
        & 0.52313e+03_r8,0.42280e+03_r8,0.24755e+03_r8,0.71840e+02_r8 /)
      kao(:, 3, 3, 2) = (/ &
        & 0.14297e+03_r8,0.25028e+03_r8,0.35782e+03_r8,0.46350e+03_r8,0.53459e+03_r8, &
        & 0.51696e+03_r8,0.41619e+03_r8,0.24383e+03_r8,0.71840e+02_r8 /)
      kao(:, 4, 3, 2) = (/ &
        & 0.14033e+03_r8,0.24777e+03_r8,0.35542e+03_r8,0.46116e+03_r8,0.53100e+03_r8, &
        & 0.51122e+03_r8,0.41016e+03_r8,0.24049e+03_r8,0.71840e+02_r8 /)
      kao(:, 5, 3, 2) = (/ &
        & 0.13795e+03_r8,0.24544e+03_r8,0.35313e+03_r8,0.45882e+03_r8,0.52751e+03_r8, &
        & 0.50591e+03_r8,0.40463e+03_r8,0.23747e+03_r8,0.71840e+02_r8 /)
      kao(:, 1, 4, 2) = (/ &
        & 0.14062e+03_r8,0.24856e+03_r8,0.35678e+03_r8,0.46260e+03_r8,0.53137e+03_r8, &
        & 0.51186e+03_r8,0.41082e+03_r8,0.24086e+03_r8,0.71840e+02_r8 /)
      kao(:, 2, 4, 2) = (/ &
        & 0.13771e+03_r8,0.24592e+03_r8,0.35440e+03_r8,0.46020e+03_r8,0.52732e+03_r8, &
        & 0.50537e+03_r8,0.40407e+03_r8,0.23717e+03_r8,0.71840e+02_r8 /)
      kao(:, 3, 4, 2) = (/ &
        & 0.13512e+03_r8,0.24353e+03_r8,0.35219e+03_r8,0.45796e+03_r8,0.52348e+03_r8, &
        & 0.49954e+03_r8,0.39798e+03_r8,0.23389e+03_r8,0.71840e+02_r8 /)
      kao(:, 4, 4, 2) = (/ &
        & 0.13281e+03_r8,0.24133e+03_r8,0.35008e+03_r8,0.45583e+03_r8,0.51985e+03_r8, &
        & 0.49431e+03_r8,0.39246e+03_r8,0.23096e+03_r8,0.71840e+02_r8 /)
      kao(:, 5, 4, 2) = (/ &
        & 0.13073e+03_r8,0.23928e+03_r8,0.34807e+03_r8,0.45378e+03_r8,0.51643e+03_r8, &
        & 0.48957e+03_r8,0.38745e+03_r8,0.22833e+03_r8,0.71840e+02_r8 /)
      kao(:, 1, 5, 2) = (/ &
        & 0.13333e+03_r8,0.24222e+03_r8,0.35141e+03_r8,0.45702e+03_r8,0.52057e+03_r8, &
        & 0.49550e+03_r8,0.39372e+03_r8,0.23163e+03_r8,0.71840e+02_r8 /)
      kao(:, 2, 5, 2) = (/ &
        & 0.13075e+03_r8,0.23990e+03_r8,0.34934e+03_r8,0.45476e+03_r8,0.51651e+03_r8, &
        & 0.48963e+03_r8,0.38752e+03_r8,0.22836e+03_r8,0.71840e+02_r8 /)
      kao(:, 3, 5, 2) = (/ &
        & 0.12847e+03_r8,0.23780e+03_r8,0.34741e+03_r8,0.45266e+03_r8,0.51271e+03_r8, &
        & 0.48438e+03_r8,0.38196e+03_r8,0.22548e+03_r8,0.71840e+02_r8 /)
      kao(:, 4, 5, 2) = (/ &
        & 0.12644e+03_r8,0.23588e+03_r8,0.34557e+03_r8,0.45066e+03_r8,0.50911e+03_r8, &
        & 0.47962e+03_r8,0.37696e+03_r8,0.22291e+03_r8,0.71840e+02_r8 /)
      kao(:, 5, 5, 2) = (/ &
        & 0.12462e+03_r8,0.23409e+03_r8,0.34381e+03_r8,0.44874e+03_r8,0.50570e+03_r8, &
        & 0.47526e+03_r8,0.37245e+03_r8,0.22060e+03_r8,0.71840e+02_r8 /)
      kao(:, 1, 6, 2) = (/ &
        & 0.12722e+03_r8,0.23690e+03_r8,0.34688e+03_r8,0.45177e+03_r8,0.51032e+03_r8, &
        & 0.48144e+03_r8,0.37887e+03_r8,0.22389e+03_r8,0.71840e+02_r8 /)
      kao(:, 2, 6, 2) = (/ &
        & 0.12492e+03_r8,0.23485e+03_r8,0.34508e+03_r8,0.44967e+03_r8,0.50620e+03_r8, &
        & 0.47598e+03_r8,0.37319e+03_r8,0.22098e+03_r8,0.71840e+02_r8 /)
      kao(:, 3, 6, 2) = (/ &
        & 0.12290e+03_r8,0.23301e+03_r8,0.34340e+03_r8,0.44769e+03_r8,0.50242e+03_r8, &
        & 0.47108e+03_r8,0.36815e+03_r8,0.21843e+03_r8,0.71840e+02_r8 /)
      kao(:, 4, 6, 2) = (/ &
        & 0.12111e+03_r8,0.23132e+03_r8,0.34180e+03_r8,0.44582e+03_r8,0.49894e+03_r8, &
        & 0.46668e+03_r8,0.36363e+03_r8,0.21616e+03_r8,0.71840e+02_r8 /)
      kao(:, 5, 6, 2) = (/ &
        & 0.11952e+03_r8,0.22976e+03_r8,0.34026e+03_r8,0.44407e+03_r8,0.49574e+03_r8, &
        & 0.46270e+03_r8,0.35956e+03_r8,0.21414e+03_r8,0.71840e+02_r8 /)
      kao(:, 1, 7, 2) = (/ &
        & 0.12201e+03_r8,0.23235e+03_r8,0.34300e+03_r8,0.44700e+03_r8,0.50054e+03_r8, &
        & 0.46889e+03_r8,0.36590e+03_r8,0.21730e+03_r8,0.71840e+02_r8 /)
      kao(:, 2, 7, 2) = (/ &
        & 0.11997e+03_r8,0.23055e+03_r8,0.34145e+03_r8,0.44492e+03_r8,0.49657e+03_r8, &
        & 0.46383e+03_r8,0.36071e+03_r8,0.21471e+03_r8,0.71840e+02_r8 /)
      kao(:, 3, 7, 2) = (/ &
        & 0.11818e+03_r8,0.22894e+03_r8,0.33999e+03_r8,0.44309e+03_r8,0.49292e+03_r8, &
        & 0.45934e+03_r8,0.35613e+03_r8,0.21245e+03_r8,0.71840e+02_r8 /)
      kao(:, 4, 7, 2) = (/ &
        & 0.11660e+03_r8,0.22746e+03_r8,0.33859e+03_r8,0.44146e+03_r8,0.48959e+03_r8, &
        & 0.45533e+03_r8,0.35208e+03_r8,0.21045e+03_r8,0.71840e+02_r8 /)
      kao(:, 5, 7, 2) = (/ &
        & 0.11520e+03_r8,0.22609e+03_r8,0.33724e+03_r8,0.43996e+03_r8,0.48657e+03_r8, &
        & 0.45175e+03_r8,0.34847e+03_r8,0.20867e+03_r8,0.71840e+02_r8 /)
      kao(:, 1, 8, 2) = (/ &
        & 0.11756e+03_r8,0.22844e+03_r8,0.33965e+03_r8,0.44261e+03_r8,0.49147e+03_r8, &
        & 0.45776e+03_r8,0.35454e+03_r8,0.21166e+03_r8,0.71840e+02_r8 /)
      kao(:, 2, 8, 2) = (/ &
        & 0.11574e+03_r8,0.22687e+03_r8,0.33830e+03_r8,0.44082e+03_r8,0.48767e+03_r8, &
        & 0.45313e+03_r8,0.34986e+03_r8,0.20936e+03_r8,0.71840e+02_r8 /)
      kao(:, 3, 8, 2) = (/ &
        & 0.11415e+03_r8,0.22546e+03_r8,0.33704e+03_r8,0.43915e+03_r8,0.48429e+03_r8, &
        & 0.44908e+03_r8,0.34579e+03_r8,0.20735e+03_r8,0.71840e+02_r8 /)
      kao(:, 4, 8, 2) = (/ &
        & 0.11276e+03_r8,0.22417e+03_r8,0.33584e+03_r8,0.43758e+03_r8,0.48126e+03_r8, &
        & 0.44549e+03_r8,0.34220e+03_r8,0.20559e+03_r8,0.71840e+02_r8 /)
      kao(:, 5, 8, 2) = (/ &
        & 0.11153e+03_r8,0.22298e+03_r8,0.33466e+03_r8,0.43617e+03_r8,0.47855e+03_r8, &
        & 0.44228e+03_r8,0.33902e+03_r8,0.20403e+03_r8,0.71840e+02_r8 /)
      kao(:, 1, 9, 2) = (/ &
        & 0.11376e+03_r8,0.22510e+03_r8,0.33674e+03_r8,0.43882e+03_r8,0.48336e+03_r8, &
        & 0.44807e+03_r8,0.34479e+03_r8,0.20686e+03_r8,0.71840e+02_r8 /)
      kao(:, 2, 9, 2) = (/ &
        & 0.11214e+03_r8,0.22372e+03_r8,0.33559e+03_r8,0.43706e+03_r8,0.47989e+03_r8, &
        & 0.44388e+03_r8,0.34060e+03_r8,0.20480e+03_r8,0.71840e+02_r8 /)
      kao(:, 3, 9, 2) = (/ &
        & 0.11074e+03_r8,0.22250e+03_r8,0.33451e+03_r8,0.43547e+03_r8,0.47679e+03_r8, &
        & 0.44020e+03_r8,0.33697e+03_r8,0.20303e+03_r8,0.71840e+02_r8 /)
      kao(:, 4, 9, 2) = (/ &
        & 0.10951e+03_r8,0.22138e+03_r8,0.33348e+03_r8,0.43404e+03_r8,0.47404e+03_r8, &
        & 0.43694e+03_r8,0.33379e+03_r8,0.20147e+03_r8,0.71840e+02_r8 /)
      kao(:, 5, 9, 2) = (/ &
        & 0.10843e+03_r8,0.22034e+03_r8,0.33246e+03_r8,0.43277e+03_r8,0.47159e+03_r8, &
        & 0.43405e+03_r8,0.33096e+03_r8,0.20010e+03_r8,0.71840e+02_r8 /)
      kao(:, 1,10, 2) = (/ &
        & 0.11041e+03_r8,0.22214e+03_r8,0.33414e+03_r8,0.43517e+03_r8,0.47604e+03_r8, &
        & 0.43932e+03_r8,0.33611e+03_r8,0.20261e+03_r8,0.71840e+02_r8 /)
      kao(:, 2,10, 2) = (/ &
        & 0.10898e+03_r8,0.22095e+03_r8,0.33317e+03_r8,0.43358e+03_r8,0.47283e+03_r8, &
        & 0.43552e+03_r8,0.33239e+03_r8,0.20080e+03_r8,0.71840e+02_r8 /)
      kao(:, 3,10, 2) = (/ &
        & 0.10774e+03_r8,0.21989e+03_r8,0.33226e+03_r8,0.43213e+03_r8,0.47002e+03_r8, &
        & 0.43222e+03_r8,0.32917e+03_r8,0.19924e+03_r8,0.71840e+02_r8 /)
      kao(:, 4,10, 2) = (/ &
        & 0.10667e+03_r8,0.21893e+03_r8,0.33139e+03_r8,0.43083e+03_r8,0.46753e+03_r8, &
        & 0.42932e+03_r8,0.32634e+03_r8,0.19788e+03_r8,0.71840e+02_r8 /)
      kao(:, 5,10, 2) = (/ &
        & 0.10573e+03_r8,0.21803e+03_r8,0.33053e+03_r8,0.42965e+03_r8,0.46532e+03_r8, &
        & 0.42677e+03_r8,0.32386e+03_r8,0.19669e+03_r8,0.71840e+02_r8 /)
      kao(:, 1,11, 2) = (/ &
        & 0.10694e+03_r8,0.21911e+03_r8,0.33152e+03_r8,0.43127e+03_r8,0.46816e+03_r8, &
        & 0.43005e+03_r8,0.32706e+03_r8,0.19822e+03_r8,0.71840e+02_r8 /)
      kao(:, 2,11, 2) = (/ &
        & 0.10577e+03_r8,0.21815e+03_r8,0.33074e+03_r8,0.42984e+03_r8,0.46541e+03_r8, &
        & 0.42687e+03_r8,0.32396e+03_r8,0.19674e+03_r8,0.71840e+02_r8 /)
      kao(:, 3,11, 2) = (/ &
        & 0.10476e+03_r8,0.21728e+03_r8,0.33000e+03_r8,0.42855e+03_r8,0.46301e+03_r8, &
        & 0.42411e+03_r8,0.32130e+03_r8,0.19546e+03_r8,0.71840e+02_r8 /)
      kao(:, 4,11, 2) = (/ &
        & 0.10388e+03_r8,0.21649e+03_r8,0.32928e+03_r8,0.42741e+03_r8,0.46089e+03_r8, &
        & 0.42169e+03_r8,0.31897e+03_r8,0.19435e+03_r8,0.71840e+02_r8 /)
      kao(:, 5,11, 2) = (/ &
        & 0.10311e+03_r8,0.21575e+03_r8,0.32855e+03_r8,0.42639e+03_r8,0.45902e+03_r8, &
        & 0.41954e+03_r8,0.31692e+03_r8,0.19338e+03_r8,0.71840e+02_r8 /)
      kao(:, 1,12, 2) = (/ &
        & 0.10410e+03_r8,0.21663e+03_r8,0.32937e+03_r8,0.42778e+03_r8,0.46141e+03_r8, &
        & 0.42229e+03_r8,0.31955e+03_r8,0.19463e+03_r8,0.71840e+02_r8 /)
      kao(:, 2,12, 2) = (/ &
        & 0.10314e+03_r8,0.21585e+03_r8,0.32875e+03_r8,0.42654e+03_r8,0.45909e+03_r8, &
        & 0.41961e+03_r8,0.31700e+03_r8,0.19341e+03_r8,0.71840e+02_r8 /)
      kao(:, 3,12, 2) = (/ &
        & 0.10231e+03_r8,0.21515e+03_r8,0.32815e+03_r8,0.42544e+03_r8,0.45707e+03_r8, &
        & 0.41729e+03_r8,0.31480e+03_r8,0.19236e+03_r8,0.71840e+02_r8 /)
      kao(:, 4,12, 2) = (/ &
        & 0.10159e+03_r8,0.21449e+03_r8,0.32754e+03_r8,0.42445e+03_r8,0.45532e+03_r8, &
        & 0.41526e+03_r8,0.31288e+03_r8,0.19145e+03_r8,0.71840e+02_r8 /)
      kao(:, 5,12, 2) = (/ &
        & 0.10096e+03_r8,0.21387e+03_r8,0.32692e+03_r8,0.42356e+03_r8,0.45377e+03_r8, &
        & 0.41347e+03_r8,0.31119e+03_r8,0.19066e+03_r8,0.71840e+02_r8 /)
      kao(:, 1,13, 2) = (/ &
        & 0.10177e+03_r8,0.21460e+03_r8,0.32761e+03_r8,0.42475e+03_r8,0.45575e+03_r8, &
        & 0.41576e+03_r8,0.31335e+03_r8,0.19168e+03_r8,0.71840e+02_r8 /)
      kao(:, 2,13, 2) = (/ &
        & 0.10099e+03_r8,0.21397e+03_r8,0.32712e+03_r8,0.42368e+03_r8,0.45383e+03_r8, &
        & 0.41353e+03_r8,0.31125e+03_r8,0.19068e+03_r8,0.71840e+02_r8 /)
      kao(:, 3,13, 2) = (/ &
        & 0.10031e+03_r8,0.21340e+03_r8,0.32663e+03_r8,0.42272e+03_r8,0.45216e+03_r8, &
        & 0.41160e+03_r8,0.30943e+03_r8,0.18983e+03_r8,0.71840e+02_r8 /)
      kao(:, 4,13, 2) = (/ &
        & 0.99720e+02_r8,0.21286e+03_r8,0.32612e+03_r8,0.42187e+03_r8,0.45071e+03_r8, &
        & 0.40991e+03_r8,0.30785e+03_r8,0.18908e+03_r8,0.71840e+02_r8 /)
      kao(:, 5,13, 2) = (/ &
        & 0.99204e+02_r8,0.21233e+03_r8,0.32558e+03_r8,0.42112e+03_r8,0.44942e+03_r8, &
        & 0.40842e+03_r8,0.30646e+03_r8,0.18843e+03_r8,0.71840e+02_r8 /)
      kao(:, 1, 1, 3) = (/ &
        & 0.44909e+03_r8,0.47445e+03_r8,0.49981e+03_r8,0.52556e+03_r8,0.59352e+03_r8, &
        & 0.63011e+03_r8,0.50440e+03_r8,0.31793e+03_r8,0.17829e+03_r8 /)
      kao(:, 2, 1, 3) = (/ &
        & 0.43771e+03_r8,0.46449e+03_r8,0.49128e+03_r8,0.51852e+03_r8,0.58982e+03_r8, &
        & 0.62155e+03_r8,0.49364e+03_r8,0.31383e+03_r8,0.17829e+03_r8 /)
      kao(:, 3, 1, 3) = (/ &
        & 0.42749e+03_r8,0.45555e+03_r8,0.48362e+03_r8,0.51220e+03_r8,0.58623e+03_r8, &
        & 0.61324e+03_r8,0.48379e+03_r8,0.31014e+03_r8,0.17829e+03_r8 /)
      kao(:, 4, 1, 3) = (/ &
        & 0.41826e+03_r8,0.44748e+03_r8,0.47670e+03_r8,0.50650e+03_r8,0.58281e+03_r8, &
        & 0.60555e+03_r8,0.47483e+03_r8,0.30681e+03_r8,0.17829e+03_r8 /)
      kao(:, 5, 1, 3) = (/ &
        & 0.40989e+03_r8,0.44015e+03_r8,0.47042e+03_r8,0.50132e+03_r8,0.57944e+03_r8, &
        & 0.59846e+03_r8,0.46657e+03_r8,0.30379e+03_r8,0.17829e+03_r8 /)
      kao(:, 1, 2, 3) = (/ &
        & 0.41487e+03_r8,0.44451e+03_r8,0.47415e+03_r8,0.50447e+03_r8,0.58410e+03_r8, &
        & 0.60269e+03_r8,0.47150e+03_r8,0.30559e+03_r8,0.17829e+03_r8 /)
      kao(:, 2, 2, 3) = (/ &
        & 0.40511e+03_r8,0.43597e+03_r8,0.46683e+03_r8,0.49854e+03_r8,0.58056e+03_r8, &
        & 0.59434e+03_r8,0.46181e+03_r8,0.30207e+03_r8,0.17829e+03_r8 /)
      kao(:, 3, 2, 3) = (/ &
        & 0.39637e+03_r8,0.42832e+03_r8,0.46028e+03_r8,0.49326e+03_r8,0.57701e+03_r8, &
        & 0.58648e+03_r8,0.45298e+03_r8,0.29892e+03_r8,0.17829e+03_r8 /)
      kao(:, 4, 2, 3) = (/ &
        & 0.38850e+03_r8,0.42143e+03_r8,0.45437e+03_r8,0.48855e+03_r8,0.57350e+03_r8, &
        & 0.57914e+03_r8,0.44500e+03_r8,0.29608e+03_r8,0.17829e+03_r8 /)
      kao(:, 5, 2, 3) = (/ &
        & 0.38136e+03_r8,0.41519e+03_r8,0.44902e+03_r8,0.48433e+03_r8,0.57004e+03_r8, &
        & 0.57245e+03_r8,0.43774e+03_r8,0.29351e+03_r8,0.17829e+03_r8 /)
      kao(:, 1, 3, 3) = (/ &
        & 0.38797e+03_r8,0.42097e+03_r8,0.45397e+03_r8,0.48897e+03_r8,0.57508e+03_r8, &
        & 0.57865e+03_r8,0.44446e+03_r8,0.29589e+03_r8,0.17829e+03_r8 /)
      kao(:, 2, 3, 3) = (/ &
        & 0.37940e+03_r8,0.41348e+03_r8,0.44755e+03_r8,0.48416e+03_r8,0.57138e+03_r8, &
        & 0.57059e+03_r8,0.43573e+03_r8,0.29280e+03_r8,0.17829e+03_r8 /)
      kao(:, 3, 3, 3) = (/ &
        & 0.37176e+03_r8,0.40679e+03_r8,0.44182e+03_r8,0.47985e+03_r8,0.56781e+03_r8, &
        & 0.56324e+03_r8,0.42791e+03_r8,0.29005e+03_r8,0.17829e+03_r8 /)
      kao(:, 4, 3, 3) = (/ &
        & 0.36490e+03_r8,0.40078e+03_r8,0.43667e+03_r8,0.47599e+03_r8,0.56436e+03_r8, &
        & 0.55656e+03_r8,0.42088e+03_r8,0.28757e+03_r8,0.17829e+03_r8 /)
      kao(:, 5, 3, 3) = (/ &
        & 0.35870e+03_r8,0.39536e+03_r8,0.43202e+03_r8,0.47253e+03_r8,0.56109e+03_r8, &
        & 0.55041e+03_r8,0.41448e+03_r8,0.28534e+03_r8,0.17829e+03_r8 /)
      kao(:, 1, 4, 3) = (/ &
        & 0.36565e+03_r8,0.40144e+03_r8,0.43723e+03_r8,0.47759e+03_r8,0.56581e+03_r8, &
        & 0.55729e+03_r8,0.42164e+03_r8,0.28784e+03_r8,0.17829e+03_r8 /)
      kao(:, 2, 4, 3) = (/ &
        & 0.35808e+03_r8,0.39482e+03_r8,0.43155e+03_r8,0.47386e+03_r8,0.56215e+03_r8, &
        & 0.54978e+03_r8,0.41381e+03_r8,0.28511e+03_r8,0.17829e+03_r8 /)
      kao(:, 3, 4, 3) = (/ &
        & 0.35135e+03_r8,0.38893e+03_r8,0.42651e+03_r8,0.47052e+03_r8,0.55875e+03_r8, &
        & 0.54295e+03_r8,0.40683e+03_r8,0.28269e+03_r8,0.17829e+03_r8 /)
      kao(:, 4, 4, 3) = (/ &
        & 0.34533e+03_r8,0.38366e+03_r8,0.42199e+03_r8,0.46746e+03_r8,0.55555e+03_r8, &
        & 0.53669e+03_r8,0.40055e+03_r8,0.28052e+03_r8,0.17829e+03_r8 /)
      kao(:, 5, 4, 3) = (/ &
        & 0.33991e+03_r8,0.37892e+03_r8,0.41793e+03_r8,0.46467e+03_r8,0.55244e+03_r8, &
        & 0.53093e+03_r8,0.39488e+03_r8,0.27856e+03_r8,0.17829e+03_r8 /)
      kao(:, 1, 5, 3) = (/ &
        & 0.34669e+03_r8,0.38485e+03_r8,0.42301e+03_r8,0.46943e+03_r8,0.55667e+03_r8, &
        & 0.53812e+03_r8,0.40197e+03_r8,0.28101e+03_r8,0.17829e+03_r8 /)
      kao(:, 2, 5, 3) = (/ &
        & 0.33999e+03_r8,0.37899e+03_r8,0.41799e+03_r8,0.46662e+03_r8,0.55311e+03_r8, &
        & 0.53101e+03_r8,0.39496e+03_r8,0.27859e+03_r8,0.17829e+03_r8 /)
      kao(:, 3, 5, 3) = (/ &
        & 0.33406e+03_r8,0.37380e+03_r8,0.41354e+03_r8,0.46416e+03_r8,0.54976e+03_r8, &
        & 0.52459e+03_r8,0.38873e+03_r8,0.27645e+03_r8,0.17829e+03_r8 /)
      kao(:, 4, 5, 3) = (/ &
        & 0.32878e+03_r8,0.36918e+03_r8,0.40958e+03_r8,0.46185e+03_r8,0.54671e+03_r8, &
        & 0.51881e+03_r8,0.38326e+03_r8,0.27455e+03_r8,0.17829e+03_r8 /)
      kao(:, 5, 5, 3) = (/ &
        & 0.32404e+03_r8,0.36503e+03_r8,0.40603e+03_r8,0.45969e+03_r8,0.54395e+03_r8, &
        & 0.51356e+03_r8,0.37844e+03_r8,0.27284e+03_r8,0.17829e+03_r8 /)
      kao(:, 1, 6, 3) = (/ &
        & 0.33079e+03_r8,0.37094e+03_r8,0.41109e+03_r8,0.46395e+03_r8,0.54790e+03_r8, &
        & 0.52101e+03_r8,0.38534e+03_r8,0.27527e+03_r8,0.17829e+03_r8 /)
      kao(:, 2, 6, 3) = (/ &
        & 0.32482e+03_r8,0.36572e+03_r8,0.40662e+03_r8,0.46188e+03_r8,0.54448e+03_r8, &
        & 0.51443e+03_r8,0.37923e+03_r8,0.27312e+03_r8,0.17829e+03_r8 /)
      kao(:, 3, 6, 3) = (/ &
        & 0.31958e+03_r8,0.36113e+03_r8,0.40268e+03_r8,0.45998e+03_r8,0.54143e+03_r8, &
        & 0.50857e+03_r8,0.37397e+03_r8,0.27123e+03_r8,0.17829e+03_r8 /)
      kao(:, 4, 6, 3) = (/ &
        & 0.31492e+03_r8,0.35705e+03_r8,0.39919e+03_r8,0.45816e+03_r8,0.53866e+03_r8, &
        & 0.50335e+03_r8,0.36939e+03_r8,0.26955e+03_r8,0.17829e+03_r8 /)
      kao(:, 5, 6, 3) = (/ &
        & 0.31076e+03_r8,0.35342e+03_r8,0.39607e+03_r8,0.45638e+03_r8,0.53611e+03_r8, &
        & 0.49868e+03_r8,0.36537e+03_r8,0.26805e+03_r8,0.17829e+03_r8 /)
      kao(:, 1, 7, 3) = (/ &
        & 0.31725e+03_r8,0.35910e+03_r8,0.40094e+03_r8,0.45992e+03_r8,0.53978e+03_r8, &
        & 0.50597e+03_r8,0.37168e+03_r8,0.27039e+03_r8,0.17829e+03_r8 /)
      kao(:, 2, 7, 3) = (/ &
        & 0.31194e+03_r8,0.35445e+03_r8,0.39695e+03_r8,0.45835e+03_r8,0.53664e+03_r8, &
        & 0.50000e+03_r8,0.36650e+03_r8,0.26848e+03_r8,0.17829e+03_r8 /)
      kao(:, 3, 7, 3) = (/ &
        & 0.30729e+03_r8,0.35038e+03_r8,0.39347e+03_r8,0.45686e+03_r8,0.53383e+03_r8, &
        & 0.49465e+03_r8,0.36205e+03_r8,0.26680e+03_r8,0.17829e+03_r8 /)
      kao(:, 4, 7, 3) = (/ &
        & 0.30318e+03_r8,0.34679e+03_r8,0.39040e+03_r8,0.45536e+03_r8,0.53125e+03_r8, &
        & 0.48979e+03_r8,0.35818e+03_r8,0.26532e+03_r8,0.17829e+03_r8 /)
      kao(:, 5, 7, 3) = (/ &
        & 0.29953e+03_r8,0.34359e+03_r8,0.38767e+03_r8,0.45383e+03_r8,0.52882e+03_r8, &
        & 0.48543e+03_r8,0.35479e+03_r8,0.26401e+03_r8,0.17829e+03_r8 /)
      kao(:, 1, 8, 3) = (/ &
        & 0.30567e+03_r8,0.34896e+03_r8,0.39226e+03_r8,0.45673e+03_r8,0.53243e+03_r8, &
        & 0.49274e+03_r8,0.36052e+03_r8,0.26622e+03_r8,0.17829e+03_r8 /)
      kao(:, 2, 8, 3) = (/ &
        & 0.30094e+03_r8,0.34482e+03_r8,0.38872e+03_r8,0.45541e+03_r8,0.52945e+03_r8, &
        & 0.48711e+03_r8,0.35609e+03_r8,0.26451e+03_r8,0.17829e+03_r8 /)
      kao(:, 3, 8, 3) = (/ &
        & 0.29682e+03_r8,0.34122e+03_r8,0.38564e+03_r8,0.45413e+03_r8,0.52674e+03_r8, &
        & 0.48217e+03_r8,0.35231e+03_r8,0.26303e+03_r8,0.17829e+03_r8 /)
      kao(:, 4, 8, 3) = (/ &
        & 0.29320e+03_r8,0.33805e+03_r8,0.38294e+03_r8,0.45285e+03_r8,0.52426e+03_r8, &
        & 0.47779e+03_r8,0.34904e+03_r8,0.26172e+03_r8,0.17829e+03_r8 /)
      kao(:, 5, 8, 3) = (/ &
        & 0.29000e+03_r8,0.33525e+03_r8,0.38055e+03_r8,0.45152e+03_r8,0.52191e+03_r8, &
        & 0.47388e+03_r8,0.34618e+03_r8,0.26057e+03_r8,0.17829e+03_r8 /)
      kao(:, 1, 9, 3) = (/ &
        & 0.29581e+03_r8,0.34033e+03_r8,0.38489e+03_r8,0.45387e+03_r8,0.52555e+03_r8, &
        & 0.48095e+03_r8,0.35139e+03_r8,0.26266e+03_r8,0.17829e+03_r8 /)
      kao(:, 2, 9, 3) = (/ &
        & 0.29159e+03_r8,0.33664e+03_r8,0.38173e+03_r8,0.45277e+03_r8,0.52268e+03_r8, &
        & 0.47582e+03_r8,0.34759e+03_r8,0.26114e+03_r8,0.17829e+03_r8 /)
      kao(:, 3, 9, 3) = (/ &
        & 0.28794e+03_r8,0.33344e+03_r8,0.37901e+03_r8,0.45167e+03_r8,0.52008e+03_r8, &
        & 0.47135e+03_r8,0.34436e+03_r8,0.25982e+03_r8,0.17829e+03_r8 /)
      kao(:, 4, 9, 3) = (/ &
        & 0.28475e+03_r8,0.33065e+03_r8,0.37663e+03_r8,0.45055e+03_r8,0.51765e+03_r8, &
        & 0.46738e+03_r8,0.34157e+03_r8,0.25867e+03_r8,0.17829e+03_r8 /)
      kao(:, 5, 9, 3) = (/ &
        & 0.28193e+03_r8,0.32819e+03_r8,0.37453e+03_r8,0.44937e+03_r8,0.51538e+03_r8, &
        & 0.46382e+03_r8,0.33916e+03_r8,0.25766e+03_r8,0.17829e+03_r8 /)
      kao(:, 1,10, 3) = (/ &
        & 0.28708e+03_r8,0.33269e+03_r8,0.37836e+03_r8,0.45121e+03_r8,0.51885e+03_r8, &
        & 0.47029e+03_r8,0.34361e+03_r8,0.25951e+03_r8,0.17829e+03_r8 /)
      kao(:, 2,10, 3) = (/ &
        & 0.28336e+03_r8,0.32944e+03_r8,0.37559e+03_r8,0.45027e+03_r8,0.51611e+03_r8, &
        & 0.46563e+03_r8,0.34037e+03_r8,0.25817e+03_r8,0.17829e+03_r8 /)
      kao(:, 3,10, 3) = (/ &
        & 0.28016e+03_r8,0.32664e+03_r8,0.37320e+03_r8,0.44932e+03_r8,0.51361e+03_r8, &
        & 0.46153e+03_r8,0.33765e+03_r8,0.25702e+03_r8,0.17829e+03_r8 /)
      kao(:, 4,10, 3) = (/ &
        & 0.27737e+03_r8,0.32420e+03_r8,0.37112e+03_r8,0.44835e+03_r8,0.51133e+03_r8, &
        & 0.45793e+03_r8,0.33532e+03_r8,0.25601e+03_r8,0.17829e+03_r8 /)
      kao(:, 5,10, 3) = (/ &
        & 0.27492e+03_r8,0.32206e+03_r8,0.36930e+03_r8,0.44735e+03_r8,0.50922e+03_r8, &
        & 0.45473e+03_r8,0.33330e+03_r8,0.25513e+03_r8,0.17829e+03_r8 /)
      kao(:, 1,11, 3) = (/ &
        & 0.27807e+03_r8,0.32481e+03_r8,0.37164e+03_r8,0.44842e+03_r8,0.51141e+03_r8, &
        & 0.45884e+03_r8,0.33590e+03_r8,0.25627e+03_r8,0.17829e+03_r8 /)
      kao(:, 2,11, 3) = (/ &
        & 0.27502e+03_r8,0.32214e+03_r8,0.36937e+03_r8,0.44764e+03_r8,0.50894e+03_r8, &
        & 0.45486e+03_r8,0.33338e+03_r8,0.25517e+03_r8,0.17829e+03_r8 /)
      kao(:, 3,11, 3) = (/ &
        & 0.27240e+03_r8,0.31985e+03_r8,0.36742e+03_r8,0.44685e+03_r8,0.50671e+03_r8, &
        & 0.45139e+03_r8,0.33123e+03_r8,0.25422e+03_r8,0.17829e+03_r8 /)
      kao(:, 4,11, 3) = (/ &
        & 0.27012e+03_r8,0.31785e+03_r8,0.36572e+03_r8,0.44602e+03_r8,0.50464e+03_r8, &
        & 0.44836e+03_r8,0.32939e+03_r8,0.25340e+03_r8,0.17829e+03_r8 /)
      kao(:, 5,11, 3) = (/ &
        & 0.26811e+03_r8,0.31610e+03_r8,0.36422e+03_r8,0.44514e+03_r8,0.50273e+03_r8, &
        & 0.44569e+03_r8,0.32779e+03_r8,0.25268e+03_r8,0.17829e+03_r8 /)
      kao(:, 1,12, 3) = (/ &
        & 0.27068e+03_r8,0.31834e+03_r8,0.36613e+03_r8,0.44605e+03_r8,0.50476e+03_r8, &
        & 0.44911e+03_r8,0.32983e+03_r8,0.25360e+03_r8,0.17829e+03_r8 /)
      kao(:, 2,12, 3) = (/ &
        & 0.26818e+03_r8,0.31616e+03_r8,0.36428e+03_r8,0.44539e+03_r8,0.50255e+03_r8, &
        & 0.44579e+03_r8,0.32784e+03_r8,0.25270e+03_r8,0.17829e+03_r8 /)
      kao(:, 3,12, 3) = (/ &
        & 0.26603e+03_r8,0.31428e+03_r8,0.36268e+03_r8,0.44471e+03_r8,0.50054e+03_r8, &
        & 0.44293e+03_r8,0.32614e+03_r8,0.25193e+03_r8,0.17829e+03_r8 /)
      kao(:, 4,12, 3) = (/ &
        & 0.26417e+03_r8,0.31264e+03_r8,0.36129e+03_r8,0.44399e+03_r8,0.49874e+03_r8, &
        & 0.44043e+03_r8,0.32468e+03_r8,0.25125e+03_r8,0.17829e+03_r8 /)
      kao(:, 5,12, 3) = (/ &
        & 0.26252e+03_r8,0.31121e+03_r8,0.36005e+03_r8,0.44322e+03_r8,0.49710e+03_r8, &
        & 0.43824e+03_r8,0.32341e+03_r8,0.25066e+03_r8,0.17829e+03_r8 /)
      kao(:, 1,13, 3) = (/ &
        & 0.26463e+03_r8,0.31305e+03_r8,0.36163e+03_r8,0.44400e+03_r8,0.49889e+03_r8, &
        & 0.44105e+03_r8,0.32504e+03_r8,0.25142e+03_r8,0.17829e+03_r8 /)
      kao(:, 2,13, 3) = (/ &
        & 0.26258e+03_r8,0.31126e+03_r8,0.36010e+03_r8,0.44348e+03_r8,0.49698e+03_r8, &
        & 0.43831e+03_r8,0.32345e+03_r8,0.25068e+03_r8,0.17829e+03_r8 /)
      kao(:, 3,13, 3) = (/ &
        & 0.26082e+03_r8,0.30972e+03_r8,0.35880e+03_r8,0.44291e+03_r8,0.49519e+03_r8, &
        & 0.43595e+03_r8,0.32210e+03_r8,0.25005e+03_r8,0.17829e+03_r8 /)
      kao(:, 4,13, 3) = (/ &
        & 0.25929e+03_r8,0.30838e+03_r8,0.35766e+03_r8,0.44229e+03_r8,0.49360e+03_r8, &
        & 0.43388e+03_r8,0.32093e+03_r8,0.24950e+03_r8,0.17829e+03_r8 /)
      kao(:, 5,13, 3) = (/ &
        & 0.25795e+03_r8,0.30721e+03_r8,0.35666e+03_r8,0.44160e+03_r8,0.49217e+03_r8, &
        & 0.43204e+03_r8,0.31991e+03_r8,0.24901e+03_r8,0.17829e+03_r8 /)
      kao(:, 1, 1, 4) = (/ &
        & 0.86913e+03_r8,0.80389e+03_r8,0.73864e+03_r8,0.67339e+03_r8,0.62239e+03_r8, &
        & 0.67741e+03_r8,0.51596e+03_r8,0.43641e+03_r8,0.38437e+03_r8 /)
      kao(:, 2, 1, 4) = (/ &
        & 0.84711e+03_r8,0.78462e+03_r8,0.72212e+03_r8,0.65963e+03_r8,0.61530e+03_r8, &
        & 0.66963e+03_r8,0.50564e+03_r8,0.43387e+03_r8,0.38437e+03_r8 /)
      kao(:, 3, 1, 4) = (/ &
        & 0.82734e+03_r8,0.76731e+03_r8,0.70729e+03_r8,0.64727e+03_r8,0.60932e+03_r8, &
        & 0.66251e+03_r8,0.49688e+03_r8,0.43160e+03_r8,0.38437e+03_r8 /)
      kao(:, 4, 1, 4) = (/ &
        & 0.80948e+03_r8,0.75169e+03_r8,0.69390e+03_r8,0.63611e+03_r8,0.60420e+03_r8, &
        & 0.65531e+03_r8,0.48930e+03_r8,0.42954e+03_r8,0.38437e+03_r8 /)
      kao(:, 5, 1, 4) = (/ &
        & 0.79327e+03_r8,0.73751e+03_r8,0.68174e+03_r8,0.62598e+03_r8,0.59980e+03_r8, &
        & 0.64776e+03_r8,0.48275e+03_r8,0.42767e+03_r8,0.38437e+03_r8 /)
      kao(:, 1, 2, 4) = (/ &
        & 0.80291e+03_r8,0.74594e+03_r8,0.68897e+03_r8,0.63200e+03_r8,0.60547e+03_r8, &
        & 0.65273e+03_r8,0.48660e+03_r8,0.42878e+03_r8,0.38437e+03_r8 /)
      kao(:, 2, 2, 4) = (/ &
        & 0.78403e+03_r8,0.72942e+03_r8,0.67481e+03_r8,0.62020e+03_r8,0.60133e+03_r8, &
        & 0.64384e+03_r8,0.47915e+03_r8,0.42661e+03_r8,0.38437e+03_r8 /)
      kao(:, 3, 2, 4) = (/ &
        & 0.76711e+03_r8,0.71462e+03_r8,0.66212e+03_r8,0.60962e+03_r8,0.59788e+03_r8, &
        & 0.63506e+03_r8,0.47284e+03_r8,0.42466e+03_r8,0.38437e+03_r8 /)
      kao(:, 4, 2, 4) = (/ &
        & 0.75187e+03_r8,0.70128e+03_r8,0.65069e+03_r8,0.60010e+03_r8,0.59472e+03_r8, &
        & 0.62679e+03_r8,0.46742e+03_r8,0.42291e+03_r8,0.38437e+03_r8 /)
      kao(:, 5, 2, 4) = (/ &
        & 0.73807e+03_r8,0.68920e+03_r8,0.64034e+03_r8,0.59147e+03_r8,0.59165e+03_r8, &
        & 0.61864e+03_r8,0.46272e+03_r8,0.42132e+03_r8,0.38437e+03_r8 /)
      kao(:, 1, 3, 4) = (/ &
        & 0.75084e+03_r8,0.70038e+03_r8,0.64992e+03_r8,0.59946e+03_r8,0.59732e+03_r8, &
        & 0.62621e+03_r8,0.46707e+03_r8,0.42279e+03_r8,0.38437e+03_r8 /)
      kao(:, 2, 3, 4) = (/ &
        & 0.73427e+03_r8,0.68588e+03_r8,0.63749e+03_r8,0.58910e+03_r8,0.59435e+03_r8, &
        & 0.61627e+03_r8,0.46147e+03_r8,0.42088e+03_r8,0.38437e+03_r8 /)
      kao(:, 3, 3, 4) = (/ &
        & 0.71948e+03_r8,0.67294e+03_r8,0.62640e+03_r8,0.57986e+03_r8,0.59145e+03_r8, &
        & 0.60690e+03_r8,0.45675e+03_r8,0.41918e+03_r8,0.38437e+03_r8 /)
      kao(:, 4, 3, 4) = (/ &
        & 0.70620e+03_r8,0.66132e+03_r8,0.61644e+03_r8,0.57156e+03_r8,0.58863e+03_r8, &
        & 0.59842e+03_r8,0.45269e+03_r8,0.41765e+03_r8,0.38437e+03_r8 /)
      kao(:, 5, 3, 4) = (/ &
        & 0.69421e+03_r8,0.65083e+03_r8,0.60744e+03_r8,0.56406e+03_r8,0.58580e+03_r8, &
        & 0.59032e+03_r8,0.44923e+03_r8,0.41627e+03_r8,0.38437e+03_r8 /)
      kao(:, 1, 4, 4) = (/ &
        & 0.70765e+03_r8,0.66259e+03_r8,0.61753e+03_r8,0.57246e+03_r8,0.59114e+03_r8, &
        & 0.59936e+03_r8,0.45313e+03_r8,0.41781e+03_r8,0.38437e+03_r8 /)
      kao(:, 2, 4, 4) = (/ &
        & 0.69300e+03_r8,0.64977e+03_r8,0.60654e+03_r8,0.56330e+03_r8,0.58834e+03_r8, &
        & 0.58949e+03_r8,0.44892e+03_r8,0.41613e+03_r8,0.38437e+03_r8 /)
      kao(:, 3, 4, 4) = (/ &
        & 0.67997e+03_r8,0.63837e+03_r8,0.59677e+03_r8,0.55516e+03_r8,0.58563e+03_r8, &
        & 0.58057e+03_r8,0.44538e+03_r8,0.41463e+03_r8,0.38437e+03_r8 /)
      kao(:, 4, 4, 4) = (/ &
        & 0.66833e+03_r8,0.62818e+03_r8,0.58803e+03_r8,0.54788e+03_r8,0.58292e+03_r8, &
        & 0.57257e+03_r8,0.44238e+03_r8,0.41329e+03_r8,0.38437e+03_r8 /)
      kao(:, 5, 4, 4) = (/ &
        & 0.65784e+03_r8,0.61901e+03_r8,0.58017e+03_r8,0.54133e+03_r8,0.58031e+03_r8, &
        & 0.56522e+03_r8,0.43982e+03_r8,0.41208e+03_r8,0.38437e+03_r8 /)
      kao(:, 1, 5, 4) = (/ &
        & 0.67096e+03_r8,0.63048e+03_r8,0.59001e+03_r8,0.54953e+03_r8,0.58521e+03_r8, &
        & 0.57438e+03_r8,0.44304e+03_r8,0.41359e+03_r8,0.38437e+03_r8 /)
      kao(:, 2, 5, 4) = (/ &
        & 0.65799e+03_r8,0.61913e+03_r8,0.58028e+03_r8,0.54142e+03_r8,0.58256e+03_r8, &
        & 0.56532e+03_r8,0.43984e+03_r8,0.41210e+03_r8,0.38437e+03_r8 /)
      kao(:, 3, 5, 4) = (/ &
        & 0.64651e+03_r8,0.60909e+03_r8,0.57167e+03_r8,0.53427e+03_r8,0.57997e+03_r8, &
        & 0.55705e+03_r8,0.43718e+03_r8,0.41077e+03_r8,0.38437e+03_r8 /)
      kao(:, 4, 5, 4) = (/ &
        & 0.63629e+03_r8,0.60015e+03_r8,0.56401e+03_r8,0.52793e+03_r8,0.57742e+03_r8, &
        & 0.54959e+03_r8,0.43482e+03_r8,0.40960e+03_r8,0.38437e+03_r8 /)
      kao(:, 5, 5, 4) = (/ &
        & 0.62713e+03_r8,0.59213e+03_r8,0.55713e+03_r8,0.52227e+03_r8,0.57480e+03_r8, &
        & 0.54282e+03_r8,0.43271e+03_r8,0.40854e+03_r8,0.38437e+03_r8 /)
      kao(:, 1, 6, 4) = (/ &
        & 0.64019e+03_r8,0.60356e+03_r8,0.56693e+03_r8,0.53034e+03_r8,0.57955e+03_r8, &
        & 0.55244e+03_r8,0.43572e+03_r8,0.41005e+03_r8,0.38437e+03_r8 /)
      kao(:, 2, 6, 4) = (/ &
        & 0.62864e+03_r8,0.59346e+03_r8,0.55827e+03_r8,0.52321e+03_r8,0.57700e+03_r8, &
        & 0.54395e+03_r8,0.43306e+03_r8,0.40872e+03_r8,0.38437e+03_r8 /)
      kao(:, 3, 6, 4) = (/ &
        & 0.61849e+03_r8,0.58457e+03_r8,0.55065e+03_r8,0.51703e+03_r8,0.57439e+03_r8, &
        & 0.53634e+03_r8,0.43072e+03_r8,0.40755e+03_r8,0.38437e+03_r8 /)
      kao(:, 4, 6, 4) = (/ &
        & 0.60948e+03_r8,0.57669e+03_r8,0.54390e+03_r8,0.51158e+03_r8,0.57170e+03_r8, &
        & 0.52946e+03_r8,0.42865e+03_r8,0.40651e+03_r8,0.38437e+03_r8 /)
      kao(:, 5, 6, 4) = (/ &
        & 0.60143e+03_r8,0.56965e+03_r8,0.53786e+03_r8,0.50675e+03_r8,0.56897e+03_r8, &
        & 0.52321e+03_r8,0.42679e+03_r8,0.40558e+03_r8,0.38437e+03_r8 /)
      kao(:, 1, 7, 4) = (/ &
        & 0.61399e+03_r8,0.58064e+03_r8,0.54728e+03_r8,0.51440e+03_r8,0.57380e+03_r8, &
        & 0.53292e+03_r8,0.42969e+03_r8,0.40703e+03_r8,0.38437e+03_r8 /)
      kao(:, 2, 7, 4) = (/ &
        & 0.60371e+03_r8,0.57164e+03_r8,0.53957e+03_r8,0.50828e+03_r8,0.57103e+03_r8, &
        & 0.52498e+03_r8,0.42732e+03_r8,0.40585e+03_r8,0.38437e+03_r8 /)
      kao(:, 3, 7, 4) = (/ &
        & 0.59471e+03_r8,0.56376e+03_r8,0.53282e+03_r8,0.50302e+03_r8,0.56836e+03_r8, &
        & 0.51802e+03_r8,0.42525e+03_r8,0.40481e+03_r8,0.38437e+03_r8 /)
      kao(:, 4, 7, 4) = (/ &
        & 0.58676e+03_r8,0.55681e+03_r8,0.52686e+03_r8,0.49842e+03_r8,0.56580e+03_r8, &
        & 0.51197e+03_r8,0.42342e+03_r8,0.40389e+03_r8,0.38437e+03_r8 /)
      kao(:, 5, 7, 4) = (/ &
        & 0.57970e+03_r8,0.55063e+03_r8,0.52156e+03_r8,0.49437e+03_r8,0.56333e+03_r8, &
        & 0.50656e+03_r8,0.42179e+03_r8,0.40308e+03_r8,0.38437e+03_r8 /)
      kao(:, 1, 8, 4) = (/ &
        & 0.59158e+03_r8,0.56102e+03_r8,0.53047e+03_r8,0.50136e+03_r8,0.56762e+03_r8, &
        & 0.51564e+03_r8,0.42452e+03_r8,0.40445e+03_r8,0.38437e+03_r8 /)
      kao(:, 2, 8, 4) = (/ &
        & 0.58242e+03_r8,0.55301e+03_r8,0.52360e+03_r8,0.49623e+03_r8,0.56499e+03_r8, &
        & 0.50866e+03_r8,0.42242e+03_r8,0.40339e+03_r8,0.38437e+03_r8 /)
      kao(:, 3, 8, 4) = (/ &
        & 0.57445e+03_r8,0.54604e+03_r8,0.51762e+03_r8,0.49188e+03_r8,0.56245e+03_r8, &
        & 0.50238e+03_r8,0.42058e+03_r8,0.40248e+03_r8,0.38437e+03_r8 /)
      kao(:, 4, 8, 4) = (/ &
        & 0.56745e+03_r8,0.53991e+03_r8,0.51237e+03_r8,0.48811e+03_r8,0.55998e+03_r8, &
        & 0.49675e+03_r8,0.41897e+03_r8,0.40167e+03_r8,0.38437e+03_r8 /)
      kao(:, 5, 8, 4) = (/ &
        & 0.56125e+03_r8,0.53448e+03_r8,0.50772e+03_r8,0.48477e+03_r8,0.55757e+03_r8, &
        & 0.49178e+03_r8,0.41754e+03_r8,0.40096e+03_r8,0.38437e+03_r8 /)
      kao(:, 1, 9, 4) = (/ &
        & 0.57249e+03_r8,0.54432e+03_r8,0.51615e+03_r8,0.49103e+03_r8,0.56159e+03_r8, &
        & 0.50080e+03_r8,0.42013e+03_r8,0.40225e+03_r8,0.38437e+03_r8 /)
      kao(:, 2, 9, 4) = (/ &
        & 0.56432e+03_r8,0.53718e+03_r8,0.51003e+03_r8,0.48678e+03_r8,0.55899e+03_r8, &
        & 0.49424e+03_r8,0.41825e+03_r8,0.40131e+03_r8,0.38437e+03_r8 /)
      kao(:, 3, 9, 4) = (/ &
        & 0.55726e+03_r8,0.53099e+03_r8,0.50473e+03_r8,0.48321e+03_r8,0.55650e+03_r8, &
        & 0.48858e+03_r8,0.41662e+03_r8,0.40050e+03_r8,0.38437e+03_r8 /)
      kao(:, 4, 9, 4) = (/ &
        & 0.55108e+03_r8,0.52559e+03_r8,0.50010e+03_r8,0.48011e+03_r8,0.55416e+03_r8, &
        & 0.48367e+03_r8,0.41520e+03_r8,0.39978e+03_r8,0.38437e+03_r8 /)
      kao(:, 5, 9, 4) = (/ &
        & 0.54564e+03_r8,0.52083e+03_r8,0.49601e+03_r8,0.47737e+03_r8,0.55194e+03_r8, &
        & 0.47938e+03_r8,0.41394e+03_r8,0.39916e+03_r8,0.38437e+03_r8 /)
      kao(:, 1,10, 4) = (/ &
        & 0.55559e+03_r8,0.52954e+03_r8,0.50348e+03_r8,0.48256e+03_r8,0.55544e+03_r8, &
        & 0.48725e+03_r8,0.41624e+03_r8,0.40030e+03_r8,0.38437e+03_r8 /)
      kao(:, 2,10, 4) = (/ &
        & 0.54839e+03_r8,0.52324e+03_r8,0.49808e+03_r8,0.47910e+03_r8,0.55295e+03_r8, &
        & 0.48155e+03_r8,0.41458e+03_r8,0.39948e+03_r8,0.38437e+03_r8 /)
      kao(:, 3,10, 4) = (/ &
        & 0.54220e+03_r8,0.51781e+03_r8,0.49343e+03_r8,0.47621e+03_r8,0.55067e+03_r8, &
        & 0.47667e+03_r8,0.41315e+03_r8,0.39876e+03_r8,0.38437e+03_r8 /)
      kao(:, 4,10, 4) = (/ &
        & 0.53680e+03_r8,0.51310e+03_r8,0.48939e+03_r8,0.47371e+03_r8,0.54855e+03_r8, &
        & 0.47238e+03_r8,0.41191e+03_r8,0.39814e+03_r8,0.38437e+03_r8 /)
      kao(:, 5,10, 4) = (/ &
        & 0.53207e+03_r8,0.50895e+03_r8,0.48584e+03_r8,0.47148e+03_r8,0.54655e+03_r8, &
        & 0.46857e+03_r8,0.41082e+03_r8,0.39760e+03_r8,0.38437e+03_r8 /)
      kao(:, 1,11, 4) = (/ &
        & 0.53816e+03_r8,0.51428e+03_r8,0.49041e+03_r8,0.47455e+03_r8,0.54857e+03_r8, &
        & 0.47346e+03_r8,0.41222e+03_r8,0.39830e+03_r8,0.38437e+03_r8 /)
      kao(:, 2,11, 4) = (/ &
        & 0.53226e+03_r8,0.50912e+03_r8,0.48598e+03_r8,0.47200e+03_r8,0.54640e+03_r8, &
        & 0.46874e+03_r8,0.41086e+03_r8,0.39762e+03_r8,0.38437e+03_r8 /)
      kao(:, 3,11, 4) = (/ &
        & 0.52718e+03_r8,0.50468e+03_r8,0.48217e+03_r8,0.46982e+03_r8,0.54436e+03_r8, &
        & 0.46486e+03_r8,0.40969e+03_r8,0.39703e+03_r8,0.38437e+03_r8 /)
      kao(:, 4,11, 4) = (/ &
        & 0.52277e+03_r8,0.50081e+03_r8,0.47886e+03_r8,0.46790e+03_r8,0.54248e+03_r8, &
        & 0.46109e+03_r8,0.40868e+03_r8,0.39652e+03_r8,0.38437e+03_r8 /)
      kao(:, 5,11, 4) = (/ &
        & 0.51889e+03_r8,0.49742e+03_r8,0.47595e+03_r8,0.46618e+03_r8,0.54076e+03_r8, &
        & 0.45793e+03_r8,0.40778e+03_r8,0.39608e+03_r8,0.38437e+03_r8 /)
      kao(:, 1,12, 4) = (/ &
        & 0.52385e+03_r8,0.50177e+03_r8,0.47968e+03_r8,0.46863e+03_r8,0.54244e+03_r8, &
        & 0.46202e+03_r8,0.40893e+03_r8,0.39665e+03_r8,0.38437e+03_r8 /)
      kao(:, 2,12, 4) = (/ &
        & 0.51902e+03_r8,0.49754e+03_r8,0.47606e+03_r8,0.46673e+03_r8,0.54050e+03_r8, &
        & 0.45805e+03_r8,0.40782e+03_r8,0.39609e+03_r8,0.38437e+03_r8 /)
      kao(:, 3,12, 4) = (/ &
        & 0.51487e+03_r8,0.49390e+03_r8,0.47294e+03_r8,0.46509e+03_r8,0.53868e+03_r8, &
        & 0.45465e+03_r8,0.40686e+03_r8,0.39561e+03_r8,0.38437e+03_r8 /)
      kao(:, 4,12, 4) = (/ &
        & 0.51125e+03_r8,0.49074e+03_r8,0.47022e+03_r8,0.46362e+03_r8,0.53703e+03_r8, &
        & 0.45171e+03_r8,0.40602e+03_r8,0.39520e+03_r8,0.38437e+03_r8 /)
      kao(:, 5,12, 4) = (/ &
        & 0.50807e+03_r8,0.48796e+03_r8,0.46784e+03_r8,0.46227e+03_r8,0.53558e+03_r8, &
        & 0.44916e+03_r8,0.40529e+03_r8,0.39483e+03_r8,0.38437e+03_r8 /)
      kao(:, 1,13, 4) = (/ &
        & 0.51214e+03_r8,0.49152e+03_r8,0.47089e+03_r8,0.46425e+03_r8,0.53698e+03_r8, &
        & 0.45243e+03_r8,0.40623e+03_r8,0.39530e+03_r8,0.38437e+03_r8 /)
      kao(:, 2,13, 4) = (/ &
        & 0.50819e+03_r8,0.48806e+03_r8,0.46793e+03_r8,0.46281e+03_r8,0.53522e+03_r8, &
        & 0.44925e+03_r8,0.40532e+03_r8,0.39485e+03_r8,0.38437e+03_r8 /)
      kao(:, 3,13, 4) = (/ &
        & 0.50478e+03_r8,0.48508e+03_r8,0.46537e+03_r8,0.46157e+03_r8,0.53378e+03_r8, &
        & 0.44654e+03_r8,0.40453e+03_r8,0.39445e+03_r8,0.38437e+03_r8 /)
      kao(:, 4,13, 4) = (/ &
        & 0.50182e+03_r8,0.48249e+03_r8,0.46315e+03_r8,0.46044e+03_r8,0.53251e+03_r8, &
        & 0.44422e+03_r8,0.40385e+03_r8,0.39411e+03_r8,0.38437e+03_r8 /)
      kao(:, 5,13, 4) = (/ &
        & 0.49922e+03_r8,0.48021e+03_r8,0.46120e+03_r8,0.45936e+03_r8,0.53137e+03_r8, &
        & 0.44221e+03_r8,0.40325e+03_r8,0.39381e+03_r8,0.38437e+03_r8 /)
      kao(:, 1, 1, 5) = (/ &
        & 0.13243e+04_r8,0.11799e+04_r8,0.10354e+04_r8,0.89093e+03_r8,0.74647e+03_r8, &
        & 0.71044e+03_r8,0.61021e+03_r8,0.64069e+03_r8,0.67118e+03_r8 /)
      kao(:, 2, 1, 5) = (/ &
        & 0.12908e+04_r8,0.11505e+04_r8,0.10102e+04_r8,0.86996e+03_r8,0.72969e+03_r8, &
        & 0.70292e+03_r8,0.60750e+03_r8,0.63934e+03_r8,0.67118e+03_r8 /)
      kao(:, 3, 1, 5) = (/ &
        & 0.12606e+04_r8,0.11241e+04_r8,0.98763e+03_r8,0.85113e+03_r8,0.71463e+03_r8, &
        & 0.69451e+03_r8,0.60507e+03_r8,0.63812e+03_r8,0.67118e+03_r8 /)
      kao(:, 4, 1, 5) = (/ &
        & 0.12334e+04_r8,0.11003e+04_r8,0.96722e+03_r8,0.83412e+03_r8,0.70102e+03_r8, &
        & 0.68564e+03_r8,0.60287e+03_r8,0.63703e+03_r8,0.67118e+03_r8 /)
      kao(:, 5, 1, 5) = (/ &
        & 0.12087e+04_r8,0.10787e+04_r8,0.94870e+03_r8,0.81869e+03_r8,0.68867e+03_r8, &
        & 0.67724e+03_r8,0.60088e+03_r8,0.63603e+03_r8,0.67118e+03_r8 /)
      kao(:, 1, 2, 5) = (/ &
        & 0.12234e+04_r8,0.10916e+04_r8,0.95972e+03_r8,0.82787e+03_r8,0.69602e+03_r8, &
        & 0.68345e+03_r8,0.60207e+03_r8,0.63662e+03_r8,0.67118e+03_r8 /)
      kao(:, 2, 2, 5) = (/ &
        & 0.11946e+04_r8,0.10664e+04_r8,0.93814e+03_r8,0.80988e+03_r8,0.68163e+03_r8, &
        & 0.67225e+03_r8,0.59975e+03_r8,0.63546e+03_r8,0.67118e+03_r8 /)
      kao(:, 3, 2, 5) = (/ &
        & 0.11689e+04_r8,0.10438e+04_r8,0.91881e+03_r8,0.79377e+03_r8,0.66882e+03_r8, &
        & 0.66165e+03_r8,0.59767e+03_r8,0.63442e+03_r8,0.67118e+03_r8 /)
      kao(:, 4, 2, 5) = (/ &
        & 0.11456e+04_r8,0.10235e+04_r8,0.90139e+03_r8,0.77926e+03_r8,0.65759e+03_r8, &
        & 0.65058e+03_r8,0.59579e+03_r8,0.63348e+03_r8,0.67118e+03_r8 /)
      kao(:, 5, 2, 5) = (/ &
        & 0.11246e+04_r8,0.10051e+04_r8,0.88561e+03_r8,0.76611e+03_r8,0.64778e+03_r8, &
        & 0.64016e+03_r8,0.59410e+03_r8,0.63264e+03_r8,0.67118e+03_r8 /)
      kao(:, 1, 3, 5) = (/ &
        & 0.11441e+04_r8,0.10221e+04_r8,0.90021e+03_r8,0.77828e+03_r8,0.65728e+03_r8, &
        & 0.64981e+03_r8,0.59567e+03_r8,0.63342e+03_r8,0.67118e+03_r8 /)
      kao(:, 2, 3, 5) = (/ &
        & 0.11188e+04_r8,0.10001e+04_r8,0.88128e+03_r8,0.76250e+03_r8,0.64582e+03_r8, &
        & 0.63739e+03_r8,0.59363e+03_r8,0.63240e+03_r8,0.67118e+03_r8 /)
      kao(:, 3, 3, 5) = (/ &
        & 0.10963e+04_r8,0.98033e+03_r8,0.86437e+03_r8,0.74841e+03_r8,0.63611e+03_r8, &
        & 0.62581e+03_r8,0.59181e+03_r8,0.63149e+03_r8,0.67118e+03_r8 /)
      kao(:, 4, 3, 5) = (/ &
        & 0.10761e+04_r8,0.96263e+03_r8,0.84920e+03_r8,0.73577e+03_r8,0.62780e+03_r8, &
        & 0.61513e+03_r8,0.59018e+03_r8,0.63068e+03_r8,0.67118e+03_r8 /)
      kao(:, 5, 3, 5) = (/ &
        & 0.10578e+04_r8,0.94664e+03_r8,0.83549e+03_r8,0.72435e+03_r8,0.62066e+03_r8, &
        & 0.60588e+03_r8,0.58871e+03_r8,0.62994e+03_r8,0.67118e+03_r8 /)
      kao(:, 1, 4, 5) = (/ &
        & 0.10783e+04_r8,0.96456e+03_r8,0.85086e+03_r8,0.73715e+03_r8,0.62971e+03_r8, &
        & 0.61628e+03_r8,0.59036e+03_r8,0.63077e+03_r8,0.67118e+03_r8 /)
      kao(:, 2, 4, 5) = (/ &
        & 0.10559e+04_r8,0.94502e+03_r8,0.83411e+03_r8,0.72319e+03_r8,0.62145e+03_r8, &
        & 0.60490e+03_r8,0.58856e+03_r8,0.62987e+03_r8,0.67118e+03_r8 /)
      kao(:, 3, 4, 5) = (/ &
        & 0.10361e+04_r8,0.92766e+03_r8,0.81923e+03_r8,0.71079e+03_r8,0.61457e+03_r8, &
        & 0.59452e+03_r8,0.58696e+03_r8,0.62907e+03_r8,0.67118e+03_r8 /)
      kao(:, 4, 4, 5) = (/ &
        & 0.10183e+04_r8,0.91213e+03_r8,0.80591e+03_r8,0.69970e+03_r8,0.60876e+03_r8, &
        & 0.58559e+03_r8,0.58552e+03_r8,0.62835e+03_r8,0.67118e+03_r8 /)
      kao(:, 5, 4, 5) = (/ &
        & 0.10024e+04_r8,0.89816e+03_r8,0.79394e+03_r8,0.68972e+03_r8,0.60374e+03_r8, &
        & 0.57800e+03_r8,0.58424e+03_r8,0.62771e+03_r8,0.67118e+03_r8 /)
      kao(:, 1, 5, 5) = (/ &
        & 0.10224e+04_r8,0.91564e+03_r8,0.80892e+03_r8,0.70221e+03_r8,0.61144e+03_r8, &
        & 0.58757e+03_r8,0.58585e+03_r8,0.62851e+03_r8,0.67118e+03_r8 /)
      kao(:, 2, 5, 5) = (/ &
        & 0.10026e+04_r8,0.89835e+03_r8,0.79410e+03_r8,0.68985e+03_r8,0.60588e+03_r8, &
        & 0.57810e+03_r8,0.58425e+03_r8,0.62772e+03_r8,0.67118e+03_r8 /)
      kao(:, 3, 5, 5) = (/ &
        & 0.98511e+03_r8,0.88305e+03_r8,0.78099e+03_r8,0.67893e+03_r8,0.60138e+03_r8, &
        & 0.57034e+03_r8,0.58284e+03_r8,0.62701e+03_r8,0.67118e+03_r8 /)
      kao(:, 4, 5, 5) = (/ &
        & 0.96954e+03_r8,0.86942e+03_r8,0.76931e+03_r8,0.66919e+03_r8,0.59759e+03_r8, &
        & 0.56378e+03_r8,0.58159e+03_r8,0.62638e+03_r8,0.67118e+03_r8 /)
      kao(:, 5, 5, 5) = (/ &
        & 0.95557e+03_r8,0.85720e+03_r8,0.75883e+03_r8,0.66046e+03_r8,0.59436e+03_r8, &
        & 0.55823e+03_r8,0.58046e+03_r8,0.62582e+03_r8,0.67118e+03_r8 /)
      kao(:, 1, 6, 5) = (/ &
        & 0.97547e+03_r8,0.87461e+03_r8,0.77376e+03_r8,0.67290e+03_r8,0.60045e+03_r8, &
        & 0.56624e+03_r8,0.58207e+03_r8,0.62662e+03_r8,0.67118e+03_r8 /)
      kao(:, 2, 6, 5) = (/ &
        & 0.95788e+03_r8,0.85922e+03_r8,0.76057e+03_r8,0.66191e+03_r8,0.59710e+03_r8, &
        & 0.55912e+03_r8,0.58065e+03_r8,0.62591e+03_r8,0.67118e+03_r8 /)
      kao(:, 3, 6, 5) = (/ &
        & 0.94241e+03_r8,0.84568e+03_r8,0.74896e+03_r8,0.65223e+03_r8,0.59434e+03_r8, &
        & 0.55328e+03_r8,0.57940e+03_r8,0.62529e+03_r8,0.67118e+03_r8 /)
      kao(:, 4, 6, 5) = (/ &
        & 0.92868e+03_r8,0.83367e+03_r8,0.73866e+03_r8,0.64365e+03_r8,0.59182e+03_r8, &
        & 0.54839e+03_r8,0.57829e+03_r8,0.62473e+03_r8,0.67118e+03_r8 /)
      kao(:, 5, 6, 5) = (/ &
        & 0.91642e+03_r8,0.82295e+03_r8,0.72947e+03_r8,0.63599e+03_r8,0.58948e+03_r8, &
        & 0.54428e+03_r8,0.57730e+03_r8,0.62424e+03_r8,0.67118e+03_r8 /)
      kao(:, 1, 7, 5) = (/ &
        & 0.93556e+03_r8,0.83969e+03_r8,0.74382e+03_r8,0.64795e+03_r8,0.59420e+03_r8, &
        & 0.55081e+03_r8,0.57885e+03_r8,0.62501e+03_r8,0.67118e+03_r8 /)
      kao(:, 2, 7, 5) = (/ &
        & 0.91989e+03_r8,0.82598e+03_r8,0.73207e+03_r8,0.63816e+03_r8,0.59179e+03_r8, &
        & 0.54542e+03_r8,0.57758e+03_r8,0.62438e+03_r8,0.67118e+03_r8 /)
      kao(:, 3, 7, 5) = (/ &
        & 0.90618e+03_r8,0.81398e+03_r8,0.72179e+03_r8,0.62959e+03_r8,0.58955e+03_r8, &
        & 0.54102e+03_r8,0.57648e+03_r8,0.62383e+03_r8,0.67118e+03_r8 /)
      kao(:, 4, 7, 5) = (/ &
        & 0.89407e+03_r8,0.80339e+03_r8,0.71271e+03_r8,0.62202e+03_r8,0.58737e+03_r8, &
        & 0.53729e+03_r8,0.57550e+03_r8,0.62334e+03_r8,0.67118e+03_r8 /)
      kao(:, 5, 7, 5) = (/ &
        & 0.88331e+03_r8,0.79397e+03_r8,0.70463e+03_r8,0.61530e+03_r8,0.58524e+03_r8, &
        & 0.53413e+03_r8,0.57463e+03_r8,0.62290e+03_r8,0.67118e+03_r8 /)
      kao(:, 1, 8, 5) = (/ &
        & 0.90140e+03_r8,0.80981e+03_r8,0.71821e+03_r8,0.62661e+03_r8,0.58941e+03_r8, &
        & 0.53953e+03_r8,0.57609e+03_r8,0.62363e+03_r8,0.67118e+03_r8 /)
      kao(:, 2, 8, 5) = (/ &
        & 0.88745e+03_r8,0.79760e+03_r8,0.70774e+03_r8,0.61789e+03_r8,0.58727e+03_r8, &
        & 0.53533e+03_r8,0.57497e+03_r8,0.62307e+03_r8,0.67118e+03_r8 /)
      kao(:, 3, 8, 5) = (/ &
        & 0.87531e+03_r8,0.78697e+03_r8,0.69863e+03_r8,0.61030e+03_r8,0.58522e+03_r8, &
        & 0.53203e+03_r8,0.57399e+03_r8,0.62258e+03_r8,0.67118e+03_r8 /)
      kao(:, 4, 8, 5) = (/ &
        & 0.86464e+03_r8,0.77763e+03_r8,0.69063e+03_r8,0.60363e+03_r8,0.58317e+03_r8, &
        & 0.52938e+03_r8,0.57313e+03_r8,0.62215e+03_r8,0.67118e+03_r8 /)
      kao(:, 5, 8, 5) = (/ &
        & 0.85519e+03_r8,0.76937e+03_r8,0.68354e+03_r8,0.59772e+03_r8,0.58120e+03_r8, &
        & 0.52712e+03_r8,0.57236e+03_r8,0.62177e+03_r8,0.67118e+03_r8 /)
      kao(:, 1, 9, 5) = (/ &
        & 0.87232e+03_r8,0.78435e+03_r8,0.69639e+03_r8,0.60843e+03_r8,0.58508e+03_r8, &
        & 0.53128e+03_r8,0.57375e+03_r8,0.62246e+03_r8,0.67118e+03_r8 /)
      kao(:, 2, 9, 5) = (/ &
        & 0.85988e+03_r8,0.77347e+03_r8,0.68706e+03_r8,0.60065e+03_r8,0.58302e+03_r8, &
        & 0.52823e+03_r8,0.57274e+03_r8,0.62196e+03_r8,0.67118e+03_r8 /)
      kao(:, 3, 9, 5) = (/ &
        & 0.84911e+03_r8,0.76405e+03_r8,0.67898e+03_r8,0.59392e+03_r8,0.58102e+03_r8, &
        & 0.52572e+03_r8,0.57187e+03_r8,0.62153e+03_r8,0.67118e+03_r8 /)
      kao(:, 4, 9, 5) = (/ &
        & 0.83970e+03_r8,0.75581e+03_r8,0.67193e+03_r8,0.58804e+03_r8,0.57906e+03_r8, &
        & 0.52364e+03_r8,0.57111e+03_r8,0.62115e+03_r8,0.67118e+03_r8 /)
      kao(:, 5, 9, 5) = (/ &
        & 0.83140e+03_r8,0.74855e+03_r8,0.66571e+03_r8,0.58286e+03_r8,0.57713e+03_r8, &
        & 0.52190e+03_r8,0.57045e+03_r8,0.62081e+03_r8,0.67118e+03_r8 /)
      kao(:, 1,10, 5) = (/ &
        & 0.84657e+03_r8,0.76183e+03_r8,0.67708e+03_r8,0.59234e+03_r8,0.58061e+03_r8, &
        & 0.52515e+03_r8,0.57167e+03_r8,0.62142e+03_r8,0.67118e+03_r8 /)
      kao(:, 2,10, 5) = (/ &
        & 0.83560e+03_r8,0.75223e+03_r8,0.66886e+03_r8,0.58548e+03_r8,0.57865e+03_r8, &
        & 0.52276e+03_r8,0.57078e+03_r8,0.62098e+03_r8,0.67118e+03_r8 /)
      kao(:, 3,10, 5) = (/ &
        & 0.82616e+03_r8,0.74397e+03_r8,0.66177e+03_r8,0.57958e+03_r8,0.57663e+03_r8, &
        & 0.52085e+03_r8,0.57002e+03_r8,0.62060e+03_r8,0.67118e+03_r8 /)
      kao(:, 4,10, 5) = (/ &
        & 0.81794e+03_r8,0.73678e+03_r8,0.65561e+03_r8,0.57444e+03_r8,0.57466e+03_r8, &
        & 0.51933e+03_r8,0.56936e+03_r8,0.62027e+03_r8,0.67118e+03_r8 /)
      kao(:, 5,10, 5) = (/ &
        & 0.81073e+03_r8,0.73047e+03_r8,0.65020e+03_r8,0.56994e+03_r8,0.57276e+03_r8, &
        & 0.51811e+03_r8,0.56878e+03_r8,0.61998e+03_r8,0.67118e+03_r8 /)
      kao(:, 1,11, 5) = (/ &
        & 0.82001e+03_r8,0.73859e+03_r8,0.65716e+03_r8,0.57574e+03_r8,0.57531e+03_r8, &
        & 0.51970e+03_r8,0.56953e+03_r8,0.62035e+03_r8,0.67118e+03_r8 /)
      kao(:, 2,11, 5) = (/ &
        & 0.81102e+03_r8,0.73072e+03_r8,0.65042e+03_r8,0.57012e+03_r8,0.57326e+03_r8, &
        & 0.51814e+03_r8,0.56880e+03_r8,0.61999e+03_r8,0.67118e+03_r8 /)
      kao(:, 3,11, 5) = (/ &
        & 0.80328e+03_r8,0.72395e+03_r8,0.64462e+03_r8,0.56528e+03_r8,0.57135e+03_r8, &
        & 0.51670e+03_r8,0.56818e+03_r8,0.61968e+03_r8,0.67118e+03_r8 /)
      kao(:, 4,11, 5) = (/ &
        & 0.79655e+03_r8,0.71806e+03_r8,0.63957e+03_r8,0.56108e+03_r8,0.56956e+03_r8, &
        & 0.51595e+03_r8,0.56763e+03_r8,0.61941e+03_r8,0.67118e+03_r8 /)
      kao(:, 5,11, 5) = (/ &
        & 0.79064e+03_r8,0.71289e+03_r8,0.63514e+03_r8,0.55738e+03_r8,0.56781e+03_r8, &
        & 0.51517e+03_r8,0.56716e+03_r8,0.61917e+03_r8,0.67118e+03_r8 /)
      kao(:, 1,12, 5) = (/ &
        & 0.79821e+03_r8,0.71951e+03_r8,0.64081e+03_r8,0.56211e+03_r8,0.57002e+03_r8, &
        & 0.51613e+03_r8,0.56777e+03_r8,0.61947e+03_r8,0.67118e+03_r8 /)
      kao(:, 2,12, 5) = (/ &
        & 0.79085e+03_r8,0.71307e+03_r8,0.63529e+03_r8,0.55751e+03_r8,0.56813e+03_r8, &
        & 0.51519e+03_r8,0.56717e+03_r8,0.61918e+03_r8,0.67118e+03_r8 /)
      kao(:, 3,12, 5) = (/ &
        & 0.78452e+03_r8,0.70753e+03_r8,0.63054e+03_r8,0.55355e+03_r8,0.56648e+03_r8, &
        & 0.51441e+03_r8,0.56666e+03_r8,0.61892e+03_r8,0.67118e+03_r8 /)
      kao(:, 4,12, 5) = (/ &
        & 0.77901e+03_r8,0.70271e+03_r8,0.62641e+03_r8,0.55011e+03_r8,0.56489e+03_r8, &
        & 0.51374e+03_r8,0.56622e+03_r8,0.61870e+03_r8,0.67118e+03_r8 /)
      kao(:, 5,12, 5) = (/ &
        & 0.77417e+03_r8,0.69847e+03_r8,0.62278e+03_r8,0.54708e+03_r8,0.56325e+03_r8, &
        & 0.51315e+03_r8,0.56583e+03_r8,0.61850e+03_r8,0.67118e+03_r8 /)
      kao(:, 1,13, 5) = (/ &
        & 0.78036e+03_r8,0.70389e+03_r8,0.62743e+03_r8,0.55096e+03_r8,0.56495e+03_r8, &
        & 0.51390e+03_r8,0.56633e+03_r8,0.61875e+03_r8,0.67118e+03_r8 /)
      kao(:, 2,13, 5) = (/ &
        & 0.77434e+03_r8,0.69862e+03_r8,0.62291e+03_r8,0.54719e+03_r8,0.56343e+03_r8, &
        & 0.51318e+03_r8,0.56584e+03_r8,0.61851e+03_r8,0.67118e+03_r8 /)
      kao(:, 3,13, 5) = (/ &
        & 0.76915e+03_r8,0.69408e+03_r8,0.61902e+03_r8,0.54395e+03_r8,0.56189e+03_r8, &
        & 0.51255e+03_r8,0.56542e+03_r8,0.61830e+03_r8,0.67118e+03_r8 /)
      kao(:, 4,13, 5) = (/ &
        & 0.76464e+03_r8,0.69014e+03_r8,0.61563e+03_r8,0.54113e+03_r8,0.56027e+03_r8, &
        & 0.51200e+03_r8,0.56506e+03_r8,0.61812e+03_r8,0.67118e+03_r8 /)
      kao(:, 5,13, 5) = (/ &
        & 0.76068e+03_r8,0.68667e+03_r8,0.61266e+03_r8,0.53865e+03_r8,0.55865e+03_r8, &
        & 0.51152e+03_r8,0.56474e+03_r8,0.61796e+03_r8,0.67118e+03_r8 /)
      kao(:, 1, 1, 6) = (/ &
        & 0.16832e+04_r8,0.14832e+04_r8,0.12833e+04_r8,0.10834e+04_r8,0.88343e+03_r8, &
        & 0.73047e+03_r8,0.75923e+03_r8,0.85568e+03_r8,0.94989e+03_r8 /)
      kao(:, 2, 1, 6) = (/ &
        & 0.16405e+04_r8,0.14459e+04_r8,0.12513e+04_r8,0.10567e+04_r8,0.86211e+03_r8, &
        & 0.72257e+03_r8,0.75791e+03_r8,0.85457e+03_r8,0.94915e+03_r8 /)
      kao(:, 3, 1, 6) = (/ &
        & 0.16022e+04_r8,0.14124e+04_r8,0.12226e+04_r8,0.10328e+04_r8,0.84296e+03_r8, &
        & 0.71182e+03_r8,0.75643e+03_r8,0.85315e+03_r8,0.94805e+03_r8 /)
      kao(:, 4, 1, 6) = (/ &
        & 0.15677e+04_r8,0.13822e+04_r8,0.11967e+04_r8,0.10112e+04_r8,0.82566e+03_r8, &
        & 0.70003e+03_r8,0.75475e+03_r8,0.85145e+03_r8,0.94659e+03_r8 /)
      kao(:, 5, 1, 6) = (/ &
        & 0.15363e+04_r8,0.13547e+04_r8,0.11731e+04_r8,0.99155e+03_r8,0.80997e+03_r8, &
        & 0.68802e+03_r8,0.75277e+03_r8,0.84941e+03_r8,0.94478e+03_r8 /)
      kao(:, 1, 2, 6) = (/ &
        & 0.15549e+04_r8,0.13710e+04_r8,0.11871e+04_r8,0.10032e+04_r8,0.81930e+03_r8, &
        & 0.69644e+03_r8,0.75599e+03_r8,0.85402e+03_r8,0.95009e+03_r8 /)
      kao(:, 2, 2, 6) = (/ &
        & 0.15184e+04_r8,0.13390e+04_r8,0.11597e+04_r8,0.98036e+03_r8,0.80102e+03_r8, &
        & 0.68214e+03_r8,0.75486e+03_r8,0.85308e+03_r8,0.94950e+03_r8 /)
      kao(:, 3, 2, 6) = (/ &
        & 0.14856e+04_r8,0.13104e+04_r8,0.11351e+04_r8,0.95988e+03_r8,0.78464e+03_r8, &
        & 0.67032e+03_r8,0.75359e+03_r8,0.85186e+03_r8,0.94855e+03_r8 /)
      kao(:, 4, 2, 6) = (/ &
        & 0.14561e+04_r8,0.12845e+04_r8,0.11130e+04_r8,0.94143e+03_r8,0.76988e+03_r8, &
        & 0.66240e+03_r8,0.75215e+03_r8,0.85037e+03_r8,0.94724e+03_r8 /)
      kao(:, 5, 2, 6) = (/ &
        & 0.14294e+04_r8,0.12611e+04_r8,0.10929e+04_r8,0.92472e+03_r8,0.75651e+03_r8, &
        & 0.65660e+03_r8,0.75042e+03_r8,0.84857e+03_r8,0.94557e+03_r8 /)
      kao(:, 1, 3, 6) = (/ &
        & 0.14541e+04_r8,0.12828e+04_r8,0.11115e+04_r8,0.94019e+03_r8,0.76889e+03_r8, &
        & 0.66226e+03_r8,0.75340e+03_r8,0.85268e+03_r8,0.95029e+03_r8 /)
      kao(:, 2, 3, 6) = (/ &
        & 0.14220e+04_r8,0.12547e+04_r8,0.10874e+04_r8,0.92013e+03_r8,0.75284e+03_r8, &
        & 0.65611e+03_r8,0.75249e+03_r8,0.85200e+03_r8,0.94990e+03_r8 /)
      kao(:, 3, 3, 6) = (/ &
        & 0.13934e+04_r8,0.12297e+04_r8,0.10659e+04_r8,0.90223e+03_r8,0.73852e+03_r8, &
        & 0.65222e+03_r8,0.75143e+03_r8,0.85101e+03_r8,0.94916e+03_r8 /)
      kao(:, 4, 3, 6) = (/ &
        & 0.13676e+04_r8,0.12071e+04_r8,0.10467e+04_r8,0.88615e+03_r8,0.72566e+03_r8, &
        & 0.64945e+03_r8,0.75024e+03_r8,0.84977e+03_r8,0.94807e+03_r8 /)
      kao(:, 5, 3, 6) = (/ &
        & 0.13444e+04_r8,0.11868e+04_r8,0.10292e+04_r8,0.87164e+03_r8,0.71405e+03_r8, &
        & 0.64733e+03_r8,0.74880e+03_r8,0.84822e+03_r8,0.94662e+03_r8 /)
      kao(:, 1, 4, 6) = (/ &
        & 0.13705e+04_r8,0.12096e+04_r8,0.10488e+04_r8,0.88791e+03_r8,0.72707e+03_r8, &
        & 0.64976e+03_r8,0.75119e+03_r8,0.85151e+03_r8,0.95037e+03_r8 /)
      kao(:, 2, 4, 6) = (/ &
        & 0.13421e+04_r8,0.11848e+04_r8,0.10275e+04_r8,0.87017e+03_r8,0.71287e+03_r8, &
        & 0.64785e+03_r8,0.75047e+03_r8,0.85104e+03_r8,0.95019e+03_r8 /)
      kao(:, 3, 4, 6) = (/ &
        & 0.13169e+04_r8,0.11627e+04_r8,0.10086e+04_r8,0.85441e+03_r8,0.70026e+03_r8, &
        & 0.64696e+03_r8,0.74964e+03_r8,0.85031e+03_r8,0.94968e+03_r8 /)
      kao(:, 4, 4, 6) = (/ &
        & 0.12943e+04_r8,0.11430e+04_r8,0.99164e+03_r8,0.84031e+03_r8,0.68898e+03_r8, &
        & 0.64601e+03_r8,0.74865e+03_r8,0.84930e+03_r8,0.94882e+03_r8 /)
      kao(:, 5, 4, 6) = (/ &
        & 0.12740e+04_r8,0.11252e+04_r8,0.97642e+03_r8,0.82763e+03_r8,0.67884e+03_r8, &
        & 0.64496e+03_r8,0.74747e+03_r8,0.84802e+03_r8,0.94760e+03_r8 /)
      kao(:, 1, 5, 6) = (/ &
        & 0.12994e+04_r8,0.11474e+04_r8,0.99546e+03_r8,0.84350e+03_r8,0.69153e+03_r8, &
        & 0.64599e+03_r8,0.74922e+03_r8,0.85040e+03_r8,0.95032e+03_r8 /)
      kao(:, 2, 5, 6) = (/ &
        & 0.12743e+04_r8,0.11254e+04_r8,0.97662e+03_r8,0.82780e+03_r8,0.67897e+03_r8, &
        & 0.64529e+03_r8,0.74869e+03_r8,0.85015e+03_r8,0.95034e+03_r8 /)
      kao(:, 3, 5, 6) = (/ &
        & 0.12521e+04_r8,0.11060e+04_r8,0.95996e+03_r8,0.81391e+03_r8,0.66786e+03_r8, &
        & 0.64458e+03_r8,0.74805e+03_r8,0.84965e+03_r8,0.95004e+03_r8 /)
      kao(:, 4, 5, 6) = (/ &
        & 0.12323e+04_r8,0.10887e+04_r8,0.94511e+03_r8,0.80154e+03_r8,0.65797e+03_r8, &
        & 0.64380e+03_r8,0.74727e+03_r8,0.84886e+03_r8,0.94940e+03_r8 /)
      kao(:, 5, 5, 6) = (/ &
        & 0.12145e+04_r8,0.10732e+04_r8,0.93180e+03_r8,0.79045e+03_r8,0.64909e+03_r8, &
        & 0.64294e+03_r8,0.74629e+03_r8,0.84781e+03_r8,0.94841e+03_r8 /)
      kao(:, 1, 6, 6) = (/ &
        & 0.12398e+04_r8,0.10953e+04_r8,0.95077e+03_r8,0.80625e+03_r8,0.66174e+03_r8, &
        & 0.64362e+03_r8,0.74747e+03_r8,0.84935e+03_r8,0.95014e+03_r8 /)
      kao(:, 2, 6, 6) = (/ &
        & 0.12174e+04_r8,0.10757e+04_r8,0.93400e+03_r8,0.79228e+03_r8,0.65056e+03_r8, &
        & 0.64308e+03_r8,0.74712e+03_r8,0.84932e+03_r8,0.95036e+03_r8 /)
      kao(:, 3, 6, 6) = (/ &
        & 0.11978e+04_r8,0.10585e+04_r8,0.91925e+03_r8,0.77999e+03_r8,0.64087e+03_r8, &
        & 0.64253e+03_r8,0.74666e+03_r8,0.84902e+03_r8,0.95027e+03_r8 /)
      kao(:, 4, 6, 6) = (/ &
        & 0.11803e+04_r8,0.10432e+04_r8,0.90616e+03_r8,0.76908e+03_r8,0.63262e+03_r8, &
        & 0.64192e+03_r8,0.74606e+03_r8,0.84847e+03_r8,0.94985e+03_r8 /)
      kao(:, 5, 6, 6) = (/ &
        & 0.11647e+04_r8,0.10296e+04_r8,0.89448e+03_r8,0.75935e+03_r8,0.62549e+03_r8, &
        & 0.64122e+03_r8,0.74529e+03_r8,0.84763e+03_r8,0.94909e+03_r8 /)
      kao(:, 1, 7, 6) = (/ &
        & 0.11891e+04_r8,0.10509e+04_r8,0.91272e+03_r8,0.77455e+03_r8,0.63693e+03_r8, &
        & 0.64154e+03_r8,0.74584e+03_r8,0.84830e+03_r8,0.94975e+03_r8 /)
      kao(:, 2, 7, 6) = (/ &
        & 0.11692e+04_r8,0.10335e+04_r8,0.89779e+03_r8,0.76210e+03_r8,0.62795e+03_r8, &
        & 0.64115e+03_r8,0.74575e+03_r8,0.84848e+03_r8,0.95025e+03_r8 /)
      kao(:, 3, 7, 6) = (/ &
        & 0.11517e+04_r8,0.10182e+04_r8,0.88471e+03_r8,0.75121e+03_r8,0.62051e+03_r8, &
        & 0.64074e+03_r8,0.74542e+03_r8,0.84840e+03_r8,0.95037e+03_r8 /)
      kao(:, 4, 7, 6) = (/ &
        & 0.11363e+04_r8,0.10048e+04_r8,0.87317e+03_r8,0.74159e+03_r8,0.61432e+03_r8, &
        & 0.64028e+03_r8,0.74499e+03_r8,0.84806e+03_r8,0.95015e+03_r8 /)
      kao(:, 5, 7, 6) = (/ &
        & 0.11227e+04_r8,0.99279e+03_r8,0.86291e+03_r8,0.73304e+03_r8,0.60908e+03_r8, &
        & 0.63974e+03_r8,0.74440e+03_r8,0.84744e+03_r8,0.94961e+03_r8 /)
      kao(:, 1, 8, 6) = (/ &
        & 0.11457e+04_r8,0.10129e+04_r8,0.88017e+03_r8,0.74742e+03_r8,0.61848e+03_r8, &
        & 0.63968e+03_r8,0.74433e+03_r8,0.84725e+03_r8,0.94927e+03_r8 /)
      kao(:, 2, 8, 6) = (/ &
        & 0.11279e+04_r8,0.99740e+03_r8,0.86687e+03_r8,0.73633e+03_r8,0.61183e+03_r8, &
        & 0.63944e+03_r8,0.74439e+03_r8,0.84765e+03_r8,0.94999e+03_r8 /)
      kao(:, 3, 8, 6) = (/ &
        & 0.11125e+04_r8,0.98389e+03_r8,0.85529e+03_r8,0.72668e+03_r8,0.60652e+03_r8, &
        & 0.63917e+03_r8,0.74428e+03_r8,0.84777e+03_r8,0.95034e+03_r8 /)
      kao(:, 4, 8, 6) = (/ &
        & 0.10989e+04_r8,0.97202e+03_r8,0.84512e+03_r8,0.71821e+03_r8,0.60224e+03_r8, &
        & 0.63885e+03_r8,0.74401e+03_r8,0.84763e+03_r8,0.95032e+03_r8 /)
      kao(:, 5, 8, 6) = (/ &
        & 0.10869e+04_r8,0.96152e+03_r8,0.83611e+03_r8,0.71070e+03_r8,0.59867e+03_r8, &
        & 0.63844e+03_r8,0.74359e+03_r8,0.84721e+03_r8,0.94997e+03_r8 /)
      kao(:, 1, 9, 6) = (/ &
        & 0.11087e+04_r8,0.98057e+03_r8,0.85244e+03_r8,0.72431e+03_r8,0.60583e+03_r8, &
        & 0.63802e+03_r8,0.74290e+03_r8,0.84619e+03_r8,0.94868e+03_r8 /)
      kao(:, 2, 9, 6) = (/ &
        & 0.10929e+04_r8,0.96673e+03_r8,0.84058e+03_r8,0.71443e+03_r8,0.60128e+03_r8, &
        & 0.63792e+03_r8,0.74318e+03_r8,0.84681e+03_r8,0.94962e+03_r8 /)
      kao(:, 3, 9, 6) = (/ &
        & 0.10792e+04_r8,0.95475e+03_r8,0.83031e+03_r8,0.70587e+03_r8,0.59784e+03_r8, &
        & 0.63778e+03_r8,0.74323e+03_r8,0.84713e+03_r8,0.95019e+03_r8 /)
      kao(:, 4, 9, 6) = (/ &
        & 0.10672e+04_r8,0.94429e+03_r8,0.82134e+03_r8,0.69840e+03_r8,0.59517e+03_r8, &
        & 0.63759e+03_r8,0.74313e+03_r8,0.84718e+03_r8,0.95037e+03_r8 /)
      kao(:, 5, 9, 6) = (/ &
        & 0.10567e+04_r8,0.93506e+03_r8,0.81344e+03_r8,0.69181e+03_r8,0.59278e+03_r8, &
        & 0.63730e+03_r8,0.74285e+03_r8,0.84695e+03_r8,0.95021e+03_r8 /)
      kao(:, 1,10, 6) = (/ &
        & 0.10760e+04_r8,0.95193e+03_r8,0.82790e+03_r8,0.70386e+03_r8,0.59768e+03_r8, &
        & 0.63651e+03_r8,0.74157e+03_r8,0.84519e+03_r8,0.94809e+03_r8 /)
      kao(:, 2,10, 6) = (/ &
        & 0.10620e+04_r8,0.93974e+03_r8,0.81744e+03_r8,0.69515e+03_r8,0.59477e+03_r8, &
        & 0.63656e+03_r8,0.74203e+03_r8,0.84600e+03_r8,0.94921e+03_r8 /)
      kao(:, 3,10, 6) = (/ &
        & 0.10500e+04_r8,0.92923e+03_r8,0.80844e+03_r8,0.68764e+03_r8,0.59242e+03_r8, &
        & 0.63654e+03_r8,0.74226e+03_r8,0.84650e+03_r8,0.94996e+03_r8 /)
      kao(:, 4,10, 6) = (/ &
        & 0.10396e+04_r8,0.92010e+03_r8,0.80061e+03_r8,0.68112e+03_r8,0.59042e+03_r8, &
        & 0.63645e+03_r8,0.74230e+03_r8,0.84672e+03_r8,0.95033e+03_r8 /)
      kao(:, 5,10, 6) = (/ &
        & 0.10304e+04_r8,0.91207e+03_r8,0.79373e+03_r8,0.67539e+03_r8,0.58849e+03_r8, &
        & 0.63628e+03_r8,0.74216e+03_r8,0.84665e+03_r8,0.95033e+03_r8 /)
      kao(:, 1,11, 6) = (/ &
        & 0.10422e+04_r8,0.92239e+03_r8,0.80258e+03_r8,0.68276e+03_r8,0.59118e+03_r8, &
        & 0.63525e+03_r8,0.74065e+03_r8,0.84470e+03_r8,0.94808e+03_r8 /)
      kao(:, 2,11, 6) = (/ &
        & 0.10308e+04_r8,0.91240e+03_r8,0.79401e+03_r8,0.67562e+03_r8,0.58920e+03_r8, &
        & 0.63540e+03_r8,0.74118e+03_r8,0.84554e+03_r8,0.94920e+03_r8 /)
      kao(:, 3,11, 6) = (/ &
        & 0.10210e+04_r8,0.90379e+03_r8,0.78663e+03_r8,0.66947e+03_r8,0.58737e+03_r8, &
        & 0.63545e+03_r8,0.74147e+03_r8,0.84609e+03_r8,0.94995e+03_r8 /)
      kao(:, 4,11, 6) = (/ &
        & 0.10124e+04_r8,0.89631e+03_r8,0.78022e+03_r8,0.66413e+03_r8,0.58569e+03_r8, &
        & 0.63543e+03_r8,0.74156e+03_r8,0.84634e+03_r8,0.95033e+03_r8 /)
      kao(:, 5,11, 6) = (/ &
        & 0.10049e+04_r8,0.88974e+03_r8,0.77458e+03_r8,0.65943e+03_r8,0.58398e+03_r8, &
        & 0.63532e+03_r8,0.74146e+03_r8,0.84628e+03_r8,0.95033e+03_r8 /)
      kao(:, 1,12, 6) = (/ &
        & 0.10145e+04_r8,0.89815e+03_r8,0.78180e+03_r8,0.66544e+03_r8,0.58616e+03_r8, &
        & 0.63421e+03_r8,0.73990e+03_r8,0.84430e+03_r8,0.94808e+03_r8 /)
      kao(:, 2,12, 6) = (/ &
        & 0.10052e+04_r8,0.88997e+03_r8,0.77478e+03_r8,0.65960e+03_r8,0.58451e+03_r8, &
        & 0.63444e+03_r8,0.74048e+03_r8,0.84518e+03_r8,0.94921e+03_r8 /)
      kao(:, 3,12, 6) = (/ &
        & 0.99710e+03_r8,0.88292e+03_r8,0.76874e+03_r8,0.65457e+03_r8,0.58265e+03_r8, &
        & 0.63457e+03_r8,0.74082e+03_r8,0.84574e+03_r8,0.94995e+03_r8 /)
      kao(:, 4,12, 6) = (/ &
        & 0.99010e+03_r8,0.87679e+03_r8,0.76349e+03_r8,0.65019e+03_r8,0.58054e+03_r8, &
        & 0.63460e+03_r8,0.74095e+03_r8,0.84600e+03_r8,0.95033e+03_r8 /)
      kao(:, 5,12, 6) = (/ &
        & 0.98395e+03_r8,0.87141e+03_r8,0.75888e+03_r8,0.64634e+03_r8,0.57844e+03_r8, &
        & 0.63453e+03_r8,0.74089e+03_r8,0.84598e+03_r8,0.95033e+03_r8 /)
      kao(:, 1,13, 6) = (/ &
        & 0.99182e+03_r8,0.87830e+03_r8,0.76478e+03_r8,0.65127e+03_r8,0.58122e+03_r8, &
        & 0.63336e+03_r8,0.73928e+03_r8,0.84397e+03_r8,0.94808e+03_r8 /)
      kao(:, 2,13, 6) = (/ &
        & 0.98416e+03_r8,0.87160e+03_r8,0.75904e+03_r8,0.64648e+03_r8,0.57888e+03_r8, &
        & 0.63366e+03_r8,0.73991e+03_r8,0.84487e+03_r8,0.94921e+03_r8 /)
      kao(:, 3,13, 6) = (/ &
        & 0.97757e+03_r8,0.86583e+03_r8,0.75410e+03_r8,0.64236e+03_r8,0.57650e+03_r8, &
        & 0.63384e+03_r8,0.74029e+03_r8,0.84546e+03_r8,0.94996e+03_r8 /)
      kao(:, 4,13, 6) = (/ &
        & 0.97184e+03_r8,0.86082e+03_r8,0.74980e+03_r8,0.63878e+03_r8,0.57428e+03_r8, &
        & 0.63391e+03_r8,0.74045e+03_r8,0.84574e+03_r8,0.95033e+03_r8 /)
      kao(:, 5,13, 6) = (/ &
        & 0.96680e+03_r8,0.85641e+03_r8,0.74602e+03_r8,0.63563e+03_r8,0.57218e+03_r8, &
        & 0.63388e+03_r8,0.74043e+03_r8,0.84574e+03_r8,0.95033e+03_r8 /)
      kao(:, 1, 1, 7) = (/ &
        & 0.18845e+04_r8,0.16548e+04_r8,0.14251e+04_r8,0.11953e+04_r8,0.96557e+03_r8, &
        & 0.74301e+03_r8,0.82697e+03_r8,0.94964e+03_r8,0.10740e+04_r8 /)
      kao(:, 2, 1, 7) = (/ &
        & 0.18367e+04_r8,0.16130e+04_r8,0.13892e+04_r8,0.11655e+04_r8,0.94169e+03_r8, &
        & 0.73101e+03_r8,0.82533e+03_r8,0.94833e+03_r8,0.10730e+04_r8 /)
      kao(:, 3, 1, 7) = (/ &
        & 0.17938e+04_r8,0.15755e+04_r8,0.13571e+04_r8,0.11387e+04_r8,0.92025e+03_r8, &
        & 0.71894e+03_r8,0.82353e+03_r8,0.94679e+03_r8,0.10715e+04_r8 /)
      kao(:, 4, 1, 7) = (/ &
        & 0.17551e+04_r8,0.15416e+04_r8,0.13280e+04_r8,0.11145e+04_r8,0.90089e+03_r8, &
        & 0.70691e+03_r8,0.82149e+03_r8,0.94487e+03_r8,0.10696e+04_r8 /)
      kao(:, 5, 1, 7) = (/ &
        & 0.17200e+04_r8,0.15108e+04_r8,0.13017e+04_r8,0.10925e+04_r8,0.88332e+03_r8, &
        & 0.69946e+03_r8,0.81920e+03_r8,0.94260e+03_r8,0.10672e+04_r8 /)
      kao(:, 1, 2, 7) = (/ &
        & 0.17409e+04_r8,0.15291e+04_r8,0.13174e+04_r8,0.11056e+04_r8,0.89377e+03_r8, &
        & 0.70556e+03_r8,0.82545e+03_r8,0.94918e+03_r8,0.10743e+04_r8 /)
      kao(:, 2, 2, 7) = (/ &
        & 0.16999e+04_r8,0.14933e+04_r8,0.12867e+04_r8,0.10800e+04_r8,0.87329e+03_r8, &
        & 0.70177e+03_r8,0.82404e+03_r8,0.94806e+03_r8,0.10734e+04_r8 /)
      kao(:, 3, 2, 7) = (/ &
        & 0.16632e+04_r8,0.14612e+04_r8,0.12591e+04_r8,0.10571e+04_r8,0.85495e+03_r8, &
        & 0.69985e+03_r8,0.82245e+03_r8,0.94668e+03_r8,0.10721e+04_r8 /)
      kao(:, 4, 2, 7) = (/ &
        & 0.16302e+04_r8,0.14323e+04_r8,0.12344e+04_r8,0.10364e+04_r8,0.83842e+03_r8, &
        & 0.69778e+03_r8,0.82061e+03_r8,0.94495e+03_r8,0.10705e+04_r8 /)
      kao(:, 5, 2, 7) = (/ &
        & 0.16003e+04_r8,0.14061e+04_r8,0.12119e+04_r8,0.10177e+04_r8,0.82345e+03_r8, &
        & 0.69549e+03_r8,0.81853e+03_r8,0.94286e+03_r8,0.10683e+04_r8 /)
      kao(:, 1, 3, 7) = (/ &
        & 0.16280e+04_r8,0.14303e+04_r8,0.12327e+04_r8,0.10350e+04_r8,0.83731e+03_r8, &
        & 0.70164e+03_r8,0.82440e+03_r8,0.94900e+03_r8,0.10748e+04_r8 /)
      kao(:, 2, 3, 7) = (/ &
        & 0.15920e+04_r8,0.13989e+04_r8,0.12057e+04_r8,0.10126e+04_r8,0.81934e+03_r8, &
        & 0.70016e+03_r8,0.82323e+03_r8,0.94804e+03_r8,0.10740e+04_r8 /)
      kao(:, 3, 3, 7) = (/ &
        & 0.15600e+04_r8,0.13708e+04_r8,0.11817e+04_r8,0.99252e+03_r8,0.80330e+03_r8, &
        & 0.69850e+03_r8,0.82187e+03_r8,0.94688e+03_r8,0.10730e+04_r8 /)
      kao(:, 4, 3, 7) = (/ &
        & 0.15312e+04_r8,0.13457e+04_r8,0.11601e+04_r8,0.97452e+03_r8,0.78890e+03_r8, &
        & 0.69669e+03_r8,0.82029e+03_r8,0.94542e+03_r8,0.10716e+04_r8 /)
      kao(:, 5, 3, 7) = (/ &
        & 0.15052e+04_r8,0.13229e+04_r8,0.11406e+04_r8,0.95827e+03_r8,0.77590e+03_r8, &
        & 0.69468e+03_r8,0.81844e+03_r8,0.94358e+03_r8,0.10697e+04_r8 /)
      kao(:, 1, 4, 7) = (/ &
        & 0.15343e+04_r8,0.13484e+04_r8,0.11625e+04_r8,0.97650e+03_r8,0.79047e+03_r8, &
        & 0.70005e+03_r8,0.82352e+03_r8,0.94883e+03_r8,0.10751e+04_r8 /)
      kao(:, 2, 4, 7) = (/ &
        & 0.15026e+04_r8,0.13206e+04_r8,0.11386e+04_r8,0.95663e+03_r8,0.77458e+03_r8, &
        & 0.69884e+03_r8,0.82260e+03_r8,0.94808e+03_r8,0.10745e+04_r8 /)
      kao(:, 3, 4, 7) = (/ &
        & 0.14743e+04_r8,0.12959e+04_r8,0.11175e+04_r8,0.93898e+03_r8,0.76046e+03_r8, &
        & 0.69743e+03_r8,0.82145e+03_r8,0.94711e+03_r8,0.10737e+04_r8 /)
      kao(:, 4, 4, 7) = (/ &
        & 0.14491e+04_r8,0.12738e+04_r8,0.10985e+04_r8,0.92319e+03_r8,0.74783e+03_r8, &
        & 0.69586e+03_r8,0.82010e+03_r8,0.94588e+03_r8,0.10725e+04_r8 /)
      kao(:, 5, 4, 7) = (/ &
        & 0.14263e+04_r8,0.12539e+04_r8,0.10815e+04_r8,0.90900e+03_r8,0.73646e+03_r8, &
        & 0.69412e+03_r8,0.81852e+03_r8,0.94430e+03_r8,0.10710e+04_r8 /)
      kao(:, 1, 5, 7) = (/ &
        & 0.14548e+04_r8,0.12788e+04_r8,0.11028e+04_r8,0.92676e+03_r8,0.75068e+03_r8, &
        & 0.69862e+03_r8,0.82271e+03_r8,0.94860e+03_r8,0.10753e+04_r8 /)
      kao(:, 2, 5, 7) = (/ &
        & 0.14266e+04_r8,0.12542e+04_r8,0.10817e+04_r8,0.90918e+03_r8,0.73662e+03_r8, &
        & 0.69765e+03_r8,0.82202e+03_r8,0.94804e+03_r8,0.10749e+04_r8 /)
      kao(:, 3, 5, 7) = (/ &
        & 0.14018e+04_r8,0.12324e+04_r8,0.10630e+04_r8,0.89363e+03_r8,0.72418e+03_r8, &
        & 0.69649e+03_r8,0.82110e+03_r8,0.94729e+03_r8,0.10743e+04_r8 /)
      kao(:, 4, 5, 7) = (/ &
        & 0.13796e+04_r8,0.12130e+04_r8,0.10464e+04_r8,0.87978e+03_r8,0.71309e+03_r8, &
        & 0.69515e+03_r8,0.81992e+03_r8,0.94623e+03_r8,0.10733e+04_r8 /)
      kao(:, 5, 5, 7) = (/ &
        & 0.13597e+04_r8,0.11956e+04_r8,0.10315e+04_r8,0.86737e+03_r8,0.70315e+03_r8, &
        & 0.69363e+03_r8,0.81858e+03_r8,0.94492e+03_r8,0.10720e+04_r8 /)
      kao(:, 1, 6, 7) = (/ &
        & 0.13881e+04_r8,0.12204e+04_r8,0.10528e+04_r8,0.88506e+03_r8,0.71732e+03_r8, &
        & 0.69732e+03_r8,0.82195e+03_r8,0.94833e+03_r8,0.10753e+04_r8 /)
      kao(:, 2, 6, 7) = (/ &
        & 0.13630e+04_r8,0.11985e+04_r8,0.10340e+04_r8,0.86942e+03_r8,0.70480e+03_r8, &
        & 0.69661e+03_r8,0.82150e+03_r8,0.94796e+03_r8,0.10752e+04_r8 /)
      kao(:, 3, 6, 7) = (/ &
        & 0.13410e+04_r8,0.11792e+04_r8,0.10175e+04_r8,0.85565e+03_r8,0.69378e+03_r8, &
        & 0.69568e+03_r8,0.82079e+03_r8,0.94739e+03_r8,0.10747e+04_r8 /)
      kao(:, 4, 6, 7) = (/ &
        & 0.13215e+04_r8,0.11622e+04_r8,0.10028e+04_r8,0.84344e+03_r8,0.68401e+03_r8, &
        & 0.69456e+03_r8,0.81984e+03_r8,0.94655e+03_r8,0.10740e+04_r8 /)
      kao(:, 5, 6, 7) = (/ &
        & 0.13040e+04_r8,0.11469e+04_r8,0.98973e+03_r8,0.83254e+03_r8,0.67529e+03_r8, &
        & 0.69326e+03_r8,0.81868e+03_r8,0.94544e+03_r8,0.10729e+04_r8 /)
      kao(:, 1, 7, 7) = (/ &
        & 0.13313e+04_r8,0.11707e+04_r8,0.10101e+04_r8,0.84956e+03_r8,0.68891e+03_r8, &
        & 0.69611e+03_r8,0.82122e+03_r8,0.94800e+03_r8,0.10754e+04_r8 /)
      kao(:, 2, 7, 7) = (/ &
        & 0.13090e+04_r8,0.11512e+04_r8,0.99343e+03_r8,0.83562e+03_r8,0.67776e+03_r8, &
        & 0.69564e+03_r8,0.82091e+03_r8,0.94785e+03_r8,0.10753e+04_r8 /)
      kao(:, 3, 7, 7) = (/ &
        & 0.12894e+04_r8,0.11341e+04_r8,0.97879e+03_r8,0.82342e+03_r8,0.66800e+03_r8, &
        & 0.69494e+03_r8,0.82048e+03_r8,0.94742e+03_r8,0.10750e+04_r8 /)
      kao(:, 4, 7, 7) = (/ &
        & 0.12722e+04_r8,0.11191e+04_r8,0.96587e+03_r8,0.81266e+03_r8,0.65938e+03_r8, &
        & 0.69403e+03_r8,0.81973e+03_r8,0.94677e+03_r8,0.10745e+04_r8 /)
      kao(:, 5, 7, 7) = (/ &
        & 0.12569e+04_r8,0.11057e+04_r8,0.95438e+03_r8,0.80308e+03_r8,0.65172e+03_r8, &
        & 0.69293e+03_r8,0.81874e+03_r8,0.94587e+03_r8,0.10736e+04_r8 /)
      kao(:, 1, 8, 7) = (/ &
        & 0.12827e+04_r8,0.11282e+04_r8,0.97371e+03_r8,0.81918e+03_r8,0.66460e+03_r8, &
        & 0.69497e+03_r8,0.82050e+03_r8,0.94762e+03_r8,0.10753e+04_r8 /)
      kao(:, 2, 8, 7) = (/ &
        & 0.12628e+04_r8,0.11108e+04_r8,0.95881e+03_r8,0.80678e+03_r8,0.65467e+03_r8, &
        & 0.69473e+03_r8,0.82044e+03_r8,0.94765e+03_r8,0.10754e+04_r8 /)
      kao(:, 3, 8, 7) = (/ &
        & 0.12455e+04_r8,0.10957e+04_r8,0.94585e+03_r8,0.79597e+03_r8,0.64602e+03_r8, &
        & 0.69425e+03_r8,0.82014e+03_r8,0.94746e+03_r8,0.10752e+04_r8 /)
      kao(:, 4, 8, 7) = (/ &
        & 0.12303e+04_r8,0.10824e+04_r8,0.93446e+03_r8,0.78648e+03_r8,0.63843e+03_r8, &
        & 0.69354e+03_r8,0.81959e+03_r8,0.94691e+03_r8,0.10748e+04_r8 /)
      kao(:, 5, 8, 7) = (/ &
        & 0.12169e+04_r8,0.10706e+04_r8,0.92437e+03_r8,0.77807e+03_r8,0.63171e+03_r8, &
        & 0.69262e+03_r8,0.81878e+03_r8,0.94618e+03_r8,0.10741e+04_r8 /)
      kao(:, 1, 9, 7) = (/ &
        & 0.12413e+04_r8,0.10920e+04_r8,0.94266e+03_r8,0.79331e+03_r8,0.64390e+03_r8, &
        & 0.69387e+03_r8,0.81977e+03_r8,0.94713e+03_r8,0.10750e+04_r8 /)
      kao(:, 2, 9, 7) = (/ &
        & 0.12236e+04_r8,0.10765e+04_r8,0.92938e+03_r8,0.78225e+03_r8,0.63504e+03_r8, &
        & 0.69385e+03_r8,0.81989e+03_r8,0.94741e+03_r8,0.10753e+04_r8 /)
      kao(:, 3, 9, 7) = (/ &
        & 0.12082e+04_r8,0.10631e+04_r8,0.91789e+03_r8,0.77267e+03_r8,0.62738e+03_r8, &
        & 0.69359e+03_r8,0.81979e+03_r8,0.94732e+03_r8,0.10754e+04_r8 /)
      kao(:, 4, 9, 7) = (/ &
        & 0.11949e+04_r8,0.10514e+04_r8,0.90785e+03_r8,0.76430e+03_r8,0.62068e+03_r8, &
        & 0.69307e+03_r8,0.81942e+03_r8,0.94698e+03_r8,0.10751e+04_r8 /)
      kao(:, 5, 9, 7) = (/ &
        & 0.11831e+04_r8,0.10410e+04_r8,0.89899e+03_r8,0.75692e+03_r8,0.61500e+03_r8, &
        & 0.69235e+03_r8,0.81879e+03_r8,0.94641e+03_r8,0.10746e+04_r8 /)
      kao(:, 1,10, 7) = (/ &
        & 0.12046e+04_r8,0.10599e+04_r8,0.91518e+03_r8,0.77041e+03_r8,0.62557e+03_r8, &
        & 0.69285e+03_r8,0.81909e+03_r8,0.94663e+03_r8,0.10746e+04_r8 /)
      kao(:, 2,10, 7) = (/ &
        & 0.11890e+04_r8,0.10463e+04_r8,0.90347e+03_r8,0.76066e+03_r8,0.61799e+03_r8, &
        & 0.69301e+03_r8,0.81937e+03_r8,0.94709e+03_r8,0.10752e+04_r8 /)
      kao(:, 3,10, 7) = (/ &
        & 0.11756e+04_r8,0.10345e+04_r8,0.89339e+03_r8,0.75225e+03_r8,0.61189e+03_r8, &
        & 0.69293e+03_r8,0.81942e+03_r8,0.94719e+03_r8,0.10754e+04_r8 /)
      kao(:, 4,10, 7) = (/ &
        & 0.11639e+04_r8,0.10243e+04_r8,0.88463e+03_r8,0.74495e+03_r8,0.60683e+03_r8, &
        & 0.69260e+03_r8,0.81922e+03_r8,0.94698e+03_r8,0.10753e+04_r8 /)
      kao(:, 5,10, 7) = (/ &
        & 0.11536e+04_r8,0.10153e+04_r8,0.87693e+03_r8,0.73853e+03_r8,0.60268e+03_r8, &
        & 0.69203e+03_r8,0.81871e+03_r8,0.94653e+03_r8,0.10749e+04_r8 /)
      kao(:, 1,11, 7) = (/ &
        & 0.11668e+04_r8,0.10268e+04_r8,0.88684e+03_r8,0.74678e+03_r8,0.60837e+03_r8, &
        & 0.69208e+03_r8,0.81864e+03_r8,0.94642e+03_r8,0.10746e+04_r8 /)
      kao(:, 2,11, 7) = (/ &
        & 0.11540e+04_r8,0.10157e+04_r8,0.87724e+03_r8,0.73879e+03_r8,0.60335e+03_r8, &
        & 0.69229e+03_r8,0.81896e+03_r8,0.94691e+03_r8,0.10752e+04_r8 /)
      kao(:, 3,11, 7) = (/ &
        & 0.11430e+04_r8,0.10060e+04_r8,0.86898e+03_r8,0.73191e+03_r8,0.59939e+03_r8, &
        & 0.69226e+03_r8,0.81904e+03_r8,0.94700e+03_r8,0.10754e+04_r8 /)
      kao(:, 4,11, 7) = (/ &
        & 0.11335e+04_r8,0.99764e+03_r8,0.86180e+03_r8,0.72592e+03_r8,0.59585e+03_r8, &
        & 0.69198e+03_r8,0.81884e+03_r8,0.94679e+03_r8,0.10753e+04_r8 /)
      kao(:, 5,11, 7) = (/ &
        & 0.11251e+04_r8,0.99028e+03_r8,0.85549e+03_r8,0.72067e+03_r8,0.59286e+03_r8, &
        & 0.69146e+03_r8,0.81839e+03_r8,0.94639e+03_r8,0.10749e+04_r8 /)
      kao(:, 1,12, 7) = (/ &
        & 0.11358e+04_r8,0.99970e+03_r8,0.86357e+03_r8,0.72739e+03_r8,0.59707e+03_r8, &
        & 0.69145e+03_r8,0.81829e+03_r8,0.94626e+03_r8,0.10746e+04_r8 /)
      kao(:, 2,12, 7) = (/ &
        & 0.11253e+04_r8,0.99054e+03_r8,0.85571e+03_r8,0.72085e+03_r8,0.59339e+03_r8, &
        & 0.69172e+03_r8,0.81863e+03_r8,0.94675e+03_r8,0.10752e+04_r8 /)
      kao(:, 3,12, 7) = (/ &
        & 0.11163e+04_r8,0.98265e+03_r8,0.84895e+03_r8,0.71521e+03_r8,0.59030e+03_r8, &
        & 0.69172e+03_r8,0.81873e+03_r8,0.94686e+03_r8,0.10754e+04_r8 /)
      kao(:, 4,12, 7) = (/ &
        & 0.11085e+04_r8,0.97579e+03_r8,0.84307e+03_r8,0.71031e+03_r8,0.58782e+03_r8, &
        & 0.69148e+03_r8,0.81855e+03_r8,0.94672e+03_r8,0.10753e+04_r8 /)
      kao(:, 5,12, 7) = (/ &
        & 0.11016e+04_r8,0.96977e+03_r8,0.83790e+03_r8,0.70601e+03_r8,0.58538e+03_r8, &
        & 0.69099e+03_r8,0.81812e+03_r8,0.94628e+03_r8,0.10749e+04_r8 /)
      kao(:, 1,13, 7) = (/ &
        & 0.11104e+04_r8,0.97748e+03_r8,0.84452e+03_r8,0.71152e+03_r8,0.58852e+03_r8, &
        & 0.69093e+03_r8,0.81799e+03_r8,0.94612e+03_r8,0.10746e+04_r8 /)
      kao(:, 2,13, 7) = (/ &
        & 0.11018e+04_r8,0.96998e+03_r8,0.83809e+03_r8,0.70616e+03_r8,0.58570e+03_r8, &
        & 0.69123e+03_r8,0.81841e+03_r8,0.94664e+03_r8,0.10752e+04_r8 /)
      kao(:, 3,13, 7) = (/ &
        & 0.10945e+04_r8,0.96352e+03_r8,0.83255e+03_r8,0.70155e+03_r8,0.58307e+03_r8, &
        & 0.69128e+03_r8,0.81849e+03_r8,0.94675e+03_r8,0.10754e+04_r8 /)
      kao(:, 4,13, 7) = (/ &
        & 0.10880e+04_r8,0.95790e+03_r8,0.82774e+03_r8,0.69753e+03_r8,0.58045e+03_r8, &
        & 0.69107e+03_r8,0.81832e+03_r8,0.94657e+03_r8,0.10753e+04_r8 /)
      kao(:, 5,13, 7) = (/ &
        & 0.10824e+04_r8,0.95297e+03_r8,0.82351e+03_r8,0.69401e+03_r8,0.57806e+03_r8, &
        & 0.69061e+03_r8,0.81788e+03_r8,0.94614e+03_r8,0.10749e+04_r8 /)
      kao(:, 1, 1, 8) = (/ &
        & 0.19433e+04_r8,0.17047e+04_r8,0.14661e+04_r8,0.12275e+04_r8,0.98902e+03_r8, &
        & 0.75120e+03_r8,0.85754e+03_r8,0.98845e+03_r8,0.11206e+04_r8 /)
      kao(:, 2, 1, 8) = (/ &
        & 0.18941e+04_r8,0.16616e+04_r8,0.14292e+04_r8,0.11968e+04_r8,0.96439e+03_r8, &
        & 0.73548e+03_r8,0.85594e+03_r8,0.98707e+03_r8,0.11193e+04_r8 /)
      kao(:, 3, 1, 8) = (/ &
        & 0.18499e+04_r8,0.16229e+04_r8,0.13960e+04_r8,0.11691e+04_r8,0.94229e+03_r8, &
        & 0.72448e+03_r8,0.85413e+03_r8,0.98549e+03_r8,0.11177e+04_r8 /)
      kao(:, 4, 1, 8) = (/ &
        & 0.18099e+04_r8,0.15880e+04_r8,0.13661e+04_r8,0.11442e+04_r8,0.92233e+03_r8, &
        & 0.72225e+03_r8,0.85214e+03_r8,0.98373e+03_r8,0.11158e+04_r8 /)
      kao(:, 5, 1, 8) = (/ &
        & 0.17737e+04_r8,0.15563e+04_r8,0.13389e+04_r8,0.11215e+04_r8,0.90421e+03_r8, &
        & 0.72001e+03_r8,0.85005e+03_r8,0.98175e+03_r8,0.11138e+04_r8 /)
      kao(:, 1, 2, 8) = (/ &
        & 0.17953e+04_r8,0.15751e+04_r8,0.13551e+04_r8,0.11350e+04_r8,0.91499e+03_r8, &
        & 0.72569e+03_r8,0.85649e+03_r8,0.98821e+03_r8,0.11210e+04_r8 /)
      kao(:, 2, 2, 8) = (/ &
        & 0.17530e+04_r8,0.15382e+04_r8,0.13234e+04_r8,0.11086e+04_r8,0.89388e+03_r8, &
        & 0.72424e+03_r8,0.85509e+03_r8,0.98698e+03_r8,0.11198e+04_r8 /)
      kao(:, 3, 2, 8) = (/ &
        & 0.17152e+04_r8,0.15051e+04_r8,0.12950e+04_r8,0.10850e+04_r8,0.87497e+03_r8, &
        & 0.72267e+03_r8,0.85348e+03_r8,0.98553e+03_r8,0.11184e+04_r8 /)
      kao(:, 4, 2, 8) = (/ &
        & 0.16811e+04_r8,0.14753e+04_r8,0.12695e+04_r8,0.10637e+04_r8,0.85793e+03_r8, &
        & 0.72084e+03_r8,0.85163e+03_r8,0.98389e+03_r8,0.11166e+04_r8 /)
      kao(:, 5, 2, 8) = (/ &
        & 0.16502e+04_r8,0.14483e+04_r8,0.12463e+04_r8,0.10444e+04_r8,0.84250e+03_r8, &
        & 0.71877e+03_r8,0.84969e+03_r8,0.98204e+03_r8,0.11147e+04_r8 /)
      kao(:, 1, 3, 8) = (/ &
        & 0.16788e+04_r8,0.14733e+04_r8,0.12678e+04_r8,0.10623e+04_r8,0.85679e+03_r8, &
        & 0.72434e+03_r8,0.85588e+03_r8,0.98822e+03_r8,0.11216e+04_r8 /)
      kao(:, 2, 3, 8) = (/ &
        & 0.16418e+04_r8,0.14409e+04_r8,0.12400e+04_r8,0.10391e+04_r8,0.83827e+03_r8, &
        & 0.72306e+03_r8,0.85466e+03_r8,0.98716e+03_r8,0.11206e+04_r8 /)
      kao(:, 3, 3, 8) = (/ &
        & 0.16087e+04_r8,0.14119e+04_r8,0.12152e+04_r8,0.10184e+04_r8,0.82172e+03_r8, &
        & 0.72165e+03_r8,0.85327e+03_r8,0.98590e+03_r8,0.11193e+04_r8 /)
      kao(:, 4, 3, 8) = (/ &
        & 0.15790e+04_r8,0.13859e+04_r8,0.11929e+04_r8,0.99988e+03_r8,0.80688e+03_r8, &
        & 0.72007e+03_r8,0.85161e+03_r8,0.98438e+03_r8,0.11177e+04_r8 /)
      kao(:, 5, 3, 8) = (/ &
        & 0.15522e+04_r8,0.13625e+04_r8,0.11728e+04_r8,0.98311e+03_r8,0.79349e+03_r8, &
        & 0.71824e+03_r8,0.84982e+03_r8,0.98270e+03_r8,0.11159e+04_r8 /)
      kao(:, 1, 4, 8) = (/ &
        & 0.15823e+04_r8,0.13888e+04_r8,0.11953e+04_r8,0.10019e+04_r8,0.80851e+03_r8, &
        & 0.72326e+03_r8,0.85540e+03_r8,0.98823e+03_r8,0.11221e+04_r8 /)
      kao(:, 2, 4, 8) = (/ &
        & 0.15495e+04_r8,0.13601e+04_r8,0.11708e+04_r8,0.98142e+03_r8,0.79213e+03_r8, &
        & 0.72214e+03_r8,0.85436e+03_r8,0.98737e+03_r8,0.11213e+04_r8 /)
      kao(:, 3, 4, 8) = (/ &
        & 0.15204e+04_r8,0.13346e+04_r8,0.11489e+04_r8,0.96322e+03_r8,0.77758e+03_r8, &
        & 0.72091e+03_r8,0.85317e+03_r8,0.98628e+03_r8,0.11202e+04_r8 /)
      kao(:, 4, 4, 8) = (/ &
        & 0.14943e+04_r8,0.13118e+04_r8,0.11294e+04_r8,0.94694e+03_r8,0.76455e+03_r8, &
        & 0.71952e+03_r8,0.85175e+03_r8,0.98496e+03_r8,0.11188e+04_r8 /)
      kao(:, 5, 4, 8) = (/ &
        & 0.14709e+04_r8,0.12913e+04_r8,0.11118e+04_r8,0.93229e+03_r8,0.75284e+03_r8, &
        & 0.71792e+03_r8,0.85010e+03_r8,0.98342e+03_r8,0.11171e+04_r8 /)
      kao(:, 1, 5, 8) = (/ &
        & 0.15002e+04_r8,0.13170e+04_r8,0.11338e+04_r8,0.95063e+03_r8,0.76749e+03_r8, &
        & 0.72234e+03_r8,0.85495e+03_r8,0.98821e+03_r8,0.11224e+04_r8 /)
      kao(:, 2, 5, 8) = (/ &
        & 0.14712e+04_r8,0.12916e+04_r8,0.11120e+04_r8,0.93250e+03_r8,0.75300e+03_r8, &
        & 0.72139e+03_r8,0.85409e+03_r8,0.98753e+03_r8,0.11218e+04_r8 /)
      kao(:, 3, 5, 8) = (/ &
        & 0.14456e+04_r8,0.12692e+04_r8,0.10928e+04_r8,0.91647e+03_r8,0.74017e+03_r8, &
        & 0.72031e+03_r8,0.85307e+03_r8,0.98657e+03_r8,0.11209e+04_r8 /)
      kao(:, 4, 5, 8) = (/ &
        & 0.14227e+04_r8,0.12492e+04_r8,0.10757e+04_r8,0.90219e+03_r8,0.72875e+03_r8, &
        & 0.71909e+03_r8,0.85186e+03_r8,0.98546e+03_r8,0.11197e+04_r8 /)
      kao(:, 5, 5, 8) = (/ &
        & 0.14022e+04_r8,0.12312e+04_r8,0.10603e+04_r8,0.88937e+03_r8,0.71851e+03_r8, &
        & 0.71769e+03_r8,0.85037e+03_r8,0.98406e+03_r8,0.11182e+04_r8 /)
      kao(:, 1, 6, 8) = (/ &
        & 0.14314e+04_r8,0.12568e+04_r8,0.10822e+04_r8,0.90763e+03_r8,0.73310e+03_r8, &
        & 0.72155e+03_r8,0.85452e+03_r8,0.98813e+03_r8,0.11226e+04_r8 /)
      kao(:, 2, 6, 8) = (/ &
        & 0.14056e+04_r8,0.12342e+04_r8,0.10628e+04_r8,0.89150e+03_r8,0.72020e+03_r8, &
        & 0.72077e+03_r8,0.85386e+03_r8,0.98765e+03_r8,0.11222e+04_r8 /)
      kao(:, 3, 6, 8) = (/ &
        & 0.13829e+04_r8,0.12143e+04_r8,0.10458e+04_r8,0.87730e+03_r8,0.70887e+03_r8, &
        & 0.71986e+03_r8,0.85300e+03_r8,0.98688e+03_r8,0.11215e+04_r8 /)
      kao(:, 4, 6, 8) = (/ &
        & 0.13627e+04_r8,0.11967e+04_r8,0.10307e+04_r8,0.86473e+03_r8,0.69880e+03_r8, &
        & 0.71879e+03_r8,0.85197e+03_r8,0.98590e+03_r8,0.11205e+04_r8 /)
      kao(:, 5, 6, 8) = (/ &
        & 0.13448e+04_r8,0.11810e+04_r8,0.10172e+04_r8,0.85348e+03_r8,0.68979e+03_r8, &
        & 0.71757e+03_r8,0.85073e+03_r8,0.98469e+03_r8,0.11192e+04_r8 /)
      kao(:, 1, 7, 8) = (/ &
        & 0.13728e+04_r8,0.12055e+04_r8,0.10383e+04_r8,0.87102e+03_r8,0.70382e+03_r8, &
        & 0.72081e+03_r8,0.85410e+03_r8,0.98799e+03_r8,0.11227e+04_r8 /)
      kao(:, 2, 7, 8) = (/ &
        & 0.13499e+04_r8,0.11854e+04_r8,0.10210e+04_r8,0.85666e+03_r8,0.69233e+03_r8, &
        & 0.72022e+03_r8,0.85362e+03_r8,0.98768e+03_r8,0.11225e+04_r8 /)
      kao(:, 3, 7, 8) = (/ &
        & 0.13297e+04_r8,0.11678e+04_r8,0.10059e+04_r8,0.84408e+03_r8,0.68228e+03_r8, &
        & 0.71945e+03_r8,0.85293e+03_r8,0.98711e+03_r8,0.11220e+04_r8 /)
      kao(:, 4, 7, 8) = (/ &
        & 0.13120e+04_r8,0.11523e+04_r8,0.99261e+03_r8,0.83298e+03_r8,0.67339e+03_r8, &
        & 0.71854e+03_r8,0.85205e+03_r8,0.98632e+03_r8,0.11212e+04_r8 /)
      kao(:, 5, 7, 8) = (/ &
        & 0.12962e+04_r8,0.11384e+04_r8,0.98077e+03_r8,0.82312e+03_r8,0.66550e+03_r8, &
        & 0.71746e+03_r8,0.85098e+03_r8,0.98523e+03_r8,0.11200e+04_r8 /)
      kao(:, 1, 8, 8) = (/ &
        & 0.13227e+04_r8,0.11617e+04_r8,0.10007e+04_r8,0.83971e+03_r8,0.67877e+03_r8, &
        & 0.72007e+03_r8,0.85366e+03_r8,0.98779e+03_r8,0.11227e+04_r8 /)
      kao(:, 2, 8, 8) = (/ &
        & 0.13022e+04_r8,0.11438e+04_r8,0.98533e+03_r8,0.82690e+03_r8,0.66854e+03_r8, &
        & 0.71969e+03_r8,0.85334e+03_r8,0.98763e+03_r8,0.11227e+04_r8 /)
      kao(:, 3, 8, 8) = (/ &
        & 0.12844e+04_r8,0.11282e+04_r8,0.97196e+03_r8,0.81577e+03_r8,0.65963e+03_r8, &
        & 0.71908e+03_r8,0.85283e+03_r8,0.98717e+03_r8,0.11223e+04_r8 /)
      kao(:, 4, 8, 8) = (/ &
        & 0.12688e+04_r8,0.11145e+04_r8,0.96023e+03_r8,0.80599e+03_r8,0.65182e+03_r8, &
        & 0.71830e+03_r8,0.85210e+03_r8,0.98659e+03_r8,0.11217e+04_r8 /)
      kao(:, 5, 8, 8) = (/ &
        & 0.12549e+04_r8,0.11024e+04_r8,0.94982e+03_r8,0.79733e+03_r8,0.64488e+03_r8, &
        & 0.71736e+03_r8,0.85118e+03_r8,0.98569e+03_r8,0.11208e+04_r8 /)
      kao(:, 1, 9, 8) = (/ &
        & 0.12800e+04_r8,0.11244e+04_r8,0.96868e+03_r8,0.81302e+03_r8,0.65744e+03_r8, &
        & 0.71936e+03_r8,0.85323e+03_r8,0.98761e+03_r8,0.11226e+04_r8 /)
      kao(:, 2, 9, 8) = (/ &
        & 0.12618e+04_r8,0.11084e+04_r8,0.95498e+03_r8,0.80161e+03_r8,0.64832e+03_r8, &
        & 0.71916e+03_r8,0.85306e+03_r8,0.98751e+03_r8,0.11227e+04_r8 /)
      kao(:, 3, 9, 8) = (/ &
        & 0.12460e+04_r8,0.10945e+04_r8,0.94313e+03_r8,0.79175e+03_r8,0.64042e+03_r8, &
        & 0.71874e+03_r8,0.85269e+03_r8,0.98731e+03_r8,0.11226e+04_r8 /)
      kao(:, 4, 9, 8) = (/ &
        & 0.12322e+04_r8,0.10825e+04_r8,0.93277e+03_r8,0.78311e+03_r8,0.63351e+03_r8, &
        & 0.71809e+03_r8,0.85213e+03_r8,0.98681e+03_r8,0.11221e+04_r8 /)
      kao(:, 5, 9, 8) = (/ &
        & 0.12200e+04_r8,0.10718e+04_r8,0.92365e+03_r8,0.77552e+03_r8,0.62743e+03_r8, &
        & 0.71728e+03_r8,0.85134e+03_r8,0.98607e+03_r8,0.11214e+04_r8 /)
      kao(:, 1,10, 8) = (/ &
        & 0.12423e+04_r8,0.10913e+04_r8,0.94034e+03_r8,0.78942e+03_r8,0.63856e+03_r8, &
        & 0.71867e+03_r8,0.85279e+03_r8,0.98738e+03_r8,0.11225e+04_r8 /)
      kao(:, 2,10, 8) = (/ &
        & 0.12262e+04_r8,0.10772e+04_r8,0.92827e+03_r8,0.77936e+03_r8,0.63052e+03_r8, &
        & 0.71863e+03_r8,0.85274e+03_r8,0.98738e+03_r8,0.11227e+04_r8 /)
      kao(:, 3,10, 8) = (/ &
        & 0.12123e+04_r8,0.10651e+04_r8,0.91788e+03_r8,0.77071e+03_r8,0.62359e+03_r8, &
        & 0.71835e+03_r8,0.85251e+03_r8,0.98725e+03_r8,0.11227e+04_r8 /)
      kao(:, 4,10, 8) = (/ &
        & 0.12002e+04_r8,0.10545e+04_r8,0.90884e+03_r8,0.76317e+03_r8,0.61756e+03_r8, &
        & 0.71785e+03_r8,0.85203e+03_r8,0.98691e+03_r8,0.11224e+04_r8 /)
      kao(:, 5,10, 8) = (/ &
        & 0.11897e+04_r8,0.10453e+04_r8,0.90090e+03_r8,0.75655e+03_r8,0.61227e+03_r8, &
        & 0.71716e+03_r8,0.85141e+03_r8,0.98631e+03_r8,0.11218e+04_r8 /)
      kao(:, 1,11, 8) = (/ &
        & 0.12033e+04_r8,0.10572e+04_r8,0.91110e+03_r8,0.76506e+03_r8,0.61908e+03_r8, &
        & 0.71809e+03_r8,0.85242e+03_r8,0.98721e+03_r8,0.11225e+04_r8 /)
      kao(:, 2,11, 8) = (/ &
        & 0.11901e+04_r8,0.10456e+04_r8,0.90123e+03_r8,0.75682e+03_r8,0.61248e+03_r8, &
        & 0.71809e+03_r8,0.85240e+03_r8,0.98723e+03_r8,0.11226e+04_r8 /)
      kao(:, 3,11, 8) = (/ &
        & 0.11788e+04_r8,0.10357e+04_r8,0.89271e+03_r8,0.74972e+03_r8,0.60692e+03_r8, &
        & 0.71785e+03_r8,0.85217e+03_r8,0.98712e+03_r8,0.11227e+04_r8 /)
      kao(:, 4,11, 8) = (/ &
        & 0.11689e+04_r8,0.10271e+04_r8,0.88529e+03_r8,0.74355e+03_r8,0.60253e+03_r8, &
        & 0.71738e+03_r8,0.85177e+03_r8,0.98681e+03_r8,0.11224e+04_r8 /)
      kao(:, 5,11, 8) = (/ &
        & 0.11602e+04_r8,0.10195e+04_r8,0.87880e+03_r8,0.73813e+03_r8,0.59855e+03_r8, &
        & 0.71672e+03_r8,0.85114e+03_r8,0.98618e+03_r8,0.11218e+04_r8 /)
      kao(:, 1,12, 8) = (/ &
        & 0.11713e+04_r8,0.10292e+04_r8,0.88712e+03_r8,0.74507e+03_r8,0.60379e+03_r8, &
        & 0.71766e+03_r8,0.85212e+03_r8,0.98706e+03_r8,0.11225e+04_r8 /)
      kao(:, 2,12, 8) = (/ &
        & 0.11605e+04_r8,0.10197e+04_r8,0.87902e+03_r8,0.73833e+03_r8,0.59891e+03_r8, &
        & 0.71764e+03_r8,0.85212e+03_r8,0.98710e+03_r8,0.11227e+04_r8 /)
      kao(:, 3,12, 8) = (/ &
        & 0.11512e+04_r8,0.10116e+04_r8,0.87205e+03_r8,0.73251e+03_r8,0.59502e+03_r8, &
        & 0.71744e+03_r8,0.85192e+03_r8,0.98700e+03_r8,0.11227e+04_r8 /)
      kao(:, 4,12, 8) = (/ &
        & 0.11431e+04_r8,0.10045e+04_r8,0.86598e+03_r8,0.72746e+03_r8,0.59151e+03_r8, &
        & 0.71699e+03_r8,0.85153e+03_r8,0.98663e+03_r8,0.11224e+04_r8 /)
      kao(:, 5,12, 8) = (/ &
        & 0.11360e+04_r8,0.99832e+03_r8,0.86067e+03_r8,0.72302e+03_r8,0.58868e+03_r8, &
        & 0.71636e+03_r8,0.85092e+03_r8,0.98606e+03_r8,0.11218e+04_r8 /)
      kao(:, 1,13, 8) = (/ &
        & 0.11451e+04_r8,0.10063e+04_r8,0.86748e+03_r8,0.72871e+03_r8,0.59258e+03_r8, &
        & 0.71726e+03_r8,0.85187e+03_r8,0.98696e+03_r8,0.11225e+04_r8 /)
      kao(:, 2,13, 8) = (/ &
        & 0.11363e+04_r8,0.99855e+03_r8,0.86085e+03_r8,0.72320e+03_r8,0.58896e+03_r8, &
        & 0.71729e+03_r8,0.85183e+03_r8,0.98699e+03_r8,0.11227e+04_r8 /)
      kao(:, 3,13, 8) = (/ &
        & 0.11287e+04_r8,0.99189e+03_r8,0.85515e+03_r8,0.71842e+03_r8,0.58585e+03_r8, &
        & 0.71710e+03_r8,0.85169e+03_r8,0.98691e+03_r8,0.11227e+04_r8 /)
      kao(:, 4,13, 8) = (/ &
        & 0.11220e+04_r8,0.98609e+03_r8,0.85017e+03_r8,0.71429e+03_r8,0.58380e+03_r8, &
        & 0.71668e+03_r8,0.85133e+03_r8,0.98660e+03_r8,0.11224e+04_r8 /)
      kao(:, 5,13, 8) = (/ &
        & 0.11162e+04_r8,0.98101e+03_r8,0.84582e+03_r8,0.71065e+03_r8,0.58234e+03_r8, &
        & 0.71606e+03_r8,0.85074e+03_r8,0.98601e+03_r8,0.11218e+04_r8 /)
      kao(:, 1, 1, 9) = (/ &
        & 0.19571e+04_r8,0.17167e+04_r8,0.14761e+04_r8,0.12357e+04_r8,0.99528e+03_r8, &
        & 0.75488e+03_r8,0.87315e+03_r8,0.10086e+04_r8,0.11441e+04_r8 /)
      kao(:, 2, 1, 9) = (/ &
        & 0.19076e+04_r8,0.16733e+04_r8,0.14390e+04_r8,0.12047e+04_r8,0.97044e+03_r8, &
        & 0.73841e+03_r8,0.87146e+03_r8,0.10070e+04_r8,0.11425e+04_r8 /)
      kao(:, 3, 1, 9) = (/ &
        & 0.18630e+04_r8,0.16343e+04_r8,0.14056e+04_r8,0.11769e+04_r8,0.94822e+03_r8, &
        & 0.73460e+03_r8,0.86967e+03_r8,0.10052e+04_r8,0.11407e+04_r8 /)
      kao(:, 4, 1, 9) = (/ &
        & 0.18229e+04_r8,0.15991e+04_r8,0.13754e+04_r8,0.11517e+04_r8,0.92811e+03_r8, &
        & 0.73269e+03_r8,0.86788e+03_r8,0.10033e+04_r8,0.11387e+04_r8 /)
      kao(:, 5, 1, 9) = (/ &
        & 0.17864e+04_r8,0.15672e+04_r8,0.13481e+04_r8,0.11289e+04_r8,0.90984e+03_r8, &
        & 0.73091e+03_r8,0.86616e+03_r8,0.10016e+04_r8,0.11368e+04_r8 /)
      kao(:, 1, 2, 9) = (/ &
        & 0.18080e+04_r8,0.15862e+04_r8,0.13643e+04_r8,0.11425e+04_r8,0.92072e+03_r8, &
        & 0.73694e+03_r8,0.87246e+03_r8,0.10086e+04_r8,0.11448e+04_r8 /)
      kao(:, 2, 2, 9) = (/ &
        & 0.17655e+04_r8,0.15491e+04_r8,0.13324e+04_r8,0.11159e+04_r8,0.89943e+03_r8, &
        & 0.73525e+03_r8,0.87092e+03_r8,0.10070e+04_r8,0.11432e+04_r8 /)
      kao(:, 3, 2, 9) = (/ &
        & 0.17274e+04_r8,0.15157e+04_r8,0.13039e+04_r8,0.10921e+04_r8,0.88039e+03_r8, &
        & 0.73343e+03_r8,0.86922e+03_r8,0.10053e+04_r8,0.11415e+04_r8 /)
      kao(:, 4, 2, 9) = (/ &
        & 0.16931e+04_r8,0.14856e+04_r8,0.12781e+04_r8,0.10706e+04_r8,0.86326e+03_r8, &
        & 0.73166e+03_r8,0.86752e+03_r8,0.10036e+04_r8,0.11395e+04_r8 /)
      kao(:, 5, 2, 9) = (/ &
        & 0.16621e+04_r8,0.14584e+04_r8,0.12549e+04_r8,0.10512e+04_r8,0.84768e+03_r8, &
        & 0.73000e+03_r8,0.86583e+03_r8,0.10018e+04_r8,0.11376e+04_r8 /)
      kao(:, 1, 3, 9) = (/ &
        & 0.16908e+04_r8,0.14837e+04_r8,0.12764e+04_r8,0.10692e+04_r8,0.86209e+03_r8, &
        & 0.73591e+03_r8,0.87213e+03_r8,0.10088e+04_r8,0.11456e+04_r8 /)
      kao(:, 2, 3, 9) = (/ &
        & 0.16535e+04_r8,0.14509e+04_r8,0.12484e+04_r8,0.10459e+04_r8,0.84339e+03_r8, &
        & 0.73450e+03_r8,0.87080e+03_r8,0.10075e+04_r8,0.11442e+04_r8 /)
      kao(:, 3, 3, 9) = (/ &
        & 0.16202e+04_r8,0.14218e+04_r8,0.12234e+04_r8,0.10251e+04_r8,0.82680e+03_r8, &
        & 0.73291e+03_r8,0.86926e+03_r8,0.10059e+04_r8,0.11426e+04_r8 /)
      kao(:, 4, 3, 9) = (/ &
        & 0.15902e+04_r8,0.13956e+04_r8,0.12011e+04_r8,0.10064e+04_r8,0.81183e+03_r8, &
        & 0.73120e+03_r8,0.86761e+03_r8,0.10042e+04_r8,0.11407e+04_r8 /)
      kao(:, 5, 3, 9) = (/ &
        & 0.15632e+04_r8,0.13720e+04_r8,0.11808e+04_r8,0.98952e+03_r8,0.79832e+03_r8, &
        & 0.72957e+03_r8,0.86594e+03_r8,0.10024e+04_r8,0.11387e+04_r8 /)
      kao(:, 1, 4, 9) = (/ &
        & 0.15935e+04_r8,0.13985e+04_r8,0.12035e+04_r8,0.10084e+04_r8,0.81344e+03_r8, &
        & 0.73513e+03_r8,0.87195e+03_r8,0.10092e+04_r8,0.11463e+04_r8 /)
      kao(:, 2, 4, 9) = (/ &
        & 0.15605e+04_r8,0.13697e+04_r8,0.11787e+04_r8,0.98782e+03_r8,0.79694e+03_r8, &
        & 0.73394e+03_r8,0.87080e+03_r8,0.10079e+04_r8,0.11451e+04_r8 /)
      kao(:, 3, 4, 9) = (/ &
        & 0.15313e+04_r8,0.13439e+04_r8,0.11567e+04_r8,0.96950e+03_r8,0.78229e+03_r8, &
        & 0.73257e+03_r8,0.86942e+03_r8,0.10065e+04_r8,0.11436e+04_r8 /)
      kao(:, 4, 4, 9) = (/ &
        & 0.15050e+04_r8,0.13210e+04_r8,0.11371e+04_r8,0.95308e+03_r8,0.76922e+03_r8, &
        & 0.73104e+03_r8,0.86787e+03_r8,0.10049e+04_r8,0.11419e+04_r8 /)
      kao(:, 5, 4, 9) = (/ &
        & 0.14814e+04_r8,0.13003e+04_r8,0.11193e+04_r8,0.93833e+03_r8,0.75745e+03_r8, &
        & 0.72946e+03_r8,0.86622e+03_r8,0.10032e+04_r8,0.11400e+04_r8 /)
      kao(:, 1, 5, 9) = (/ &
        & 0.15109e+04_r8,0.13262e+04_r8,0.11415e+04_r8,0.95685e+03_r8,0.77217e+03_r8, &
        & 0.73443e+03_r8,0.87177e+03_r8,0.10094e+04_r8,0.11470e+04_r8 /)
      kao(:, 2, 5, 9) = (/ &
        & 0.14817e+04_r8,0.13007e+04_r8,0.11196e+04_r8,0.93852e+03_r8,0.75755e+03_r8, &
        & 0.73343e+03_r8,0.87078e+03_r8,0.10083e+04_r8,0.11459e+04_r8 /)
      kao(:, 3, 5, 9) = (/ &
        & 0.14559e+04_r8,0.12780e+04_r8,0.11003e+04_r8,0.92240e+03_r8,0.74463e+03_r8, &
        & 0.73229e+03_r8,0.86958e+03_r8,0.10071e+04_r8,0.11446e+04_r8 /)
      kao(:, 4, 5, 9) = (/ &
        & 0.14329e+04_r8,0.12579e+04_r8,0.10829e+04_r8,0.90802e+03_r8,0.73310e+03_r8, &
        & 0.73095e+03_r8,0.86817e+03_r8,0.10056e+04_r8,0.11430e+04_r8 /)
      kao(:, 5, 5, 9) = (/ &
        & 0.14122e+04_r8,0.12398e+04_r8,0.10675e+04_r8,0.89511e+03_r8,0.72281e+03_r8, &
        & 0.72946e+03_r8,0.86664e+03_r8,0.10039e+04_r8,0.11412e+04_r8 /)
      kao(:, 1, 6, 9) = (/ &
        & 0.14417e+04_r8,0.12655e+04_r8,0.10896e+04_r8,0.91348e+03_r8,0.73747e+03_r8, &
        & 0.73386e+03_r8,0.87165e+03_r8,0.10096e+04_r8,0.11475e+04_r8 /)
      kao(:, 2, 6, 9) = (/ &
        & 0.14156e+04_r8,0.12429e+04_r8,0.10700e+04_r8,0.89725e+03_r8,0.72457e+03_r8, &
        & 0.73304e+03_r8,0.87078e+03_r8,0.10087e+04_r8,0.11466e+04_r8 /)
      kao(:, 3, 6, 9) = (/ &
        & 0.13928e+04_r8,0.12228e+04_r8,0.10529e+04_r8,0.88300e+03_r8,0.71308e+03_r8, &
        & 0.73207e+03_r8,0.86977e+03_r8,0.10076e+04_r8,0.11455e+04_r8 /)
      kao(:, 4, 6, 9) = (/ &
        & 0.13725e+04_r8,0.12051e+04_r8,0.10377e+04_r8,0.87029e+03_r8,0.70290e+03_r8, &
        & 0.73093e+03_r8,0.86853e+03_r8,0.10063e+04_r8,0.11441e+04_r8 /)
      kao(:, 5, 6, 9) = (/ &
        & 0.13544e+04_r8,0.11892e+04_r8,0.10241e+04_r8,0.85897e+03_r8,0.69390e+03_r8, &
        & 0.72961e+03_r8,0.86706e+03_r8,0.10048e+04_r8,0.11424e+04_r8 /)
      kao(:, 1, 7, 9) = (/ &
        & 0.13826e+04_r8,0.12140e+04_r8,0.10453e+04_r8,0.87664e+03_r8,0.70803e+03_r8, &
        & 0.73339e+03_r8,0.87155e+03_r8,0.10098e+04_r8,0.11480e+04_r8 /)
      kao(:, 2, 7, 9) = (/ &
        & 0.13594e+04_r8,0.11937e+04_r8,0.10279e+04_r8,0.86216e+03_r8,0.69645e+03_r8, &
        & 0.73269e+03_r8,0.87079e+03_r8,0.10090e+04_r8,0.11472e+04_r8 /)
      kao(:, 3, 7, 9) = (/ &
        & 0.13392e+04_r8,0.11759e+04_r8,0.10127e+04_r8,0.84953e+03_r8,0.68632e+03_r8, &
        & 0.73188e+03_r8,0.86990e+03_r8,0.10081e+04_r8,0.11462e+04_r8 /)
      kao(:, 4, 7, 9) = (/ &
        & 0.13213e+04_r8,0.11603e+04_r8,0.99928e+03_r8,0.83829e+03_r8,0.67737e+03_r8, &
        & 0.73090e+03_r8,0.86884e+03_r8,0.10069e+04_r8,0.11450e+04_r8 /)
      kao(:, 5, 7, 9) = (/ &
        & 0.13054e+04_r8,0.11464e+04_r8,0.98739e+03_r8,0.82837e+03_r8,0.66946e+03_r8, &
        & 0.72975e+03_r8,0.86756e+03_r8,0.10055e+04_r8,0.11435e+04_r8 /)
      kao(:, 1, 8, 9) = (/ &
        & 0.13322e+04_r8,0.11698e+04_r8,0.10074e+04_r8,0.84511e+03_r8,0.68280e+03_r8, &
        & 0.73302e+03_r8,0.87145e+03_r8,0.10099e+04_r8,0.11483e+04_r8 /)
      kao(:, 2, 8, 9) = (/ &
        & 0.13116e+04_r8,0.11517e+04_r8,0.99199e+03_r8,0.83221e+03_r8,0.67250e+03_r8, &
        & 0.73244e+03_r8,0.87079e+03_r8,0.10093e+04_r8,0.11477e+04_r8 /)
      kao(:, 3, 8, 9) = (/ &
        & 0.12937e+04_r8,0.11360e+04_r8,0.97848e+03_r8,0.82097e+03_r8,0.66349e+03_r8, &
        & 0.73170e+03_r8,0.87002e+03_r8,0.10085e+04_r8,0.11469e+04_r8 /)
      kao(:, 4, 8, 9) = (/ &
        & 0.12778e+04_r8,0.11223e+04_r8,0.96666e+03_r8,0.81113e+03_r8,0.65562e+03_r8, &
        & 0.73087e+03_r8,0.86909e+03_r8,0.10075e+04_r8,0.11458e+04_r8 /)
      kao(:, 5, 8, 9) = (/ &
        & 0.12639e+04_r8,0.11101e+04_r8,0.95620e+03_r8,0.80244e+03_r8,0.64865e+03_r8, &
        & 0.72985e+03_r8,0.86796e+03_r8,0.10062e+04_r8,0.11444e+04_r8 /)
      kao(:, 1, 9, 9) = (/ &
        & 0.12892e+04_r8,0.11322e+04_r8,0.97520e+03_r8,0.81821e+03_r8,0.66134e+03_r8, &
        & 0.73274e+03_r8,0.87135e+03_r8,0.10099e+04_r8,0.11485e+04_r8 /)
      kao(:, 2, 9, 9) = (/ &
        & 0.12708e+04_r8,0.11161e+04_r8,0.96140e+03_r8,0.80674e+03_r8,0.65213e+03_r8, &
        & 0.73213e+03_r8,0.87079e+03_r8,0.10095e+04_r8,0.11481e+04_r8 /)
      kao(:, 3, 9, 9) = (/ &
        & 0.12548e+04_r8,0.11022e+04_r8,0.94949e+03_r8,0.79681e+03_r8,0.64421e+03_r8, &
        & 0.73152e+03_r8,0.87011e+03_r8,0.10088e+04_r8,0.11474e+04_r8 /)
      kao(:, 4, 9, 9) = (/ &
        & 0.12410e+04_r8,0.10900e+04_r8,0.93905e+03_r8,0.78808e+03_r8,0.63726e+03_r8, &
        & 0.73083e+03_r8,0.86928e+03_r8,0.10079e+04_r8,0.11464e+04_r8 /)
      kao(:, 5, 9, 9) = (/ &
        & 0.12287e+04_r8,0.10793e+04_r8,0.92981e+03_r8,0.78042e+03_r8,0.63106e+03_r8, &
        & 0.72995e+03_r8,0.86831e+03_r8,0.10068e+04_r8,0.11452e+04_r8 /)
      kao(:, 1,10, 9) = (/ &
        & 0.12511e+04_r8,0.10989e+04_r8,0.94665e+03_r8,0.79449e+03_r8,0.64227e+03_r8, &
        & 0.73248e+03_r8,0.87121e+03_r8,0.10099e+04_r8,0.11487e+04_r8 /)
      kao(:, 2,10, 9) = (/ &
        & 0.12350e+04_r8,0.10848e+04_r8,0.93449e+03_r8,0.78435e+03_r8,0.63416e+03_r8, &
        & 0.73188e+03_r8,0.87073e+03_r8,0.10095e+04_r8,0.11483e+04_r8 /)
      kao(:, 3,10, 9) = (/ &
        & 0.12209e+04_r8,0.10725e+04_r8,0.92407e+03_r8,0.77565e+03_r8,0.62724e+03_r8, &
        & 0.73132e+03_r8,0.87012e+03_r8,0.10091e+04_r8,0.11477e+04_r8 /)
      kao(:, 4,10, 9) = (/ &
        & 0.12088e+04_r8,0.10618e+04_r8,0.91493e+03_r8,0.76801e+03_r8,0.62113e+03_r8, &
        & 0.73072e+03_r8,0.86943e+03_r8,0.10082e+04_r8,0.11469e+04_r8 /)
      kao(:, 5,10, 9) = (/ &
        & 0.11981e+04_r8,0.10526e+04_r8,0.90691e+03_r8,0.76134e+03_r8,0.61583e+03_r8, &
        & 0.72997e+03_r8,0.86853e+03_r8,0.10072e+04_r8,0.11458e+04_r8 /)
      kao(:, 1,11, 9) = (/ &
        & 0.12119e+04_r8,0.10646e+04_r8,0.91723e+03_r8,0.76995e+03_r8,0.62265e+03_r8, &
        & 0.73201e+03_r8,0.87093e+03_r8,0.10098e+04_r8,0.11487e+04_r8 /)
      kao(:, 2,11, 9) = (/ &
        & 0.11986e+04_r8,0.10529e+04_r8,0.90727e+03_r8,0.76161e+03_r8,0.61603e+03_r8, &
        & 0.73147e+03_r8,0.87046e+03_r8,0.10094e+04_r8,0.11483e+04_r8 /)
      kao(:, 3,11, 9) = (/ &
        & 0.11871e+04_r8,0.10429e+04_r8,0.89865e+03_r8,0.75449e+03_r8,0.61031e+03_r8, &
        & 0.73094e+03_r8,0.86988e+03_r8,0.10088e+04_r8,0.11477e+04_r8 /)
      kao(:, 4,11, 9) = (/ &
        & 0.11772e+04_r8,0.10342e+04_r8,0.89122e+03_r8,0.74824e+03_r8,0.60537e+03_r8, &
        & 0.73035e+03_r8,0.86918e+03_r8,0.10081e+04_r8,0.11469e+04_r8 /)
      kao(:, 5,11, 9) = (/ &
        & 0.11684e+04_r8,0.10265e+04_r8,0.88467e+03_r8,0.74278e+03_r8,0.60127e+03_r8, &
        & 0.72963e+03_r8,0.86831e+03_r8,0.10071e+04_r8,0.11458e+04_r8 /)
      kao(:, 1,12, 9) = (/ &
        & 0.11796e+04_r8,0.10363e+04_r8,0.89308e+03_r8,0.74980e+03_r8,0.60664e+03_r8, &
        & 0.73158e+03_r8,0.87066e+03_r8,0.10097e+04_r8,0.11487e+04_r8 /)
      kao(:, 2,12, 9) = (/ &
        & 0.11688e+04_r8,0.10268e+04_r8,0.88492e+03_r8,0.74297e+03_r8,0.60173e+03_r8, &
        & 0.73111e+03_r8,0.87023e+03_r8,0.10093e+04_r8,0.11483e+04_r8 /)
      kao(:, 3,12, 9) = (/ &
        & 0.11594e+04_r8,0.10186e+04_r8,0.87787e+03_r8,0.73715e+03_r8,0.59711e+03_r8, &
        & 0.73061e+03_r8,0.86968e+03_r8,0.10088e+04_r8,0.11478e+04_r8 /)
      kao(:, 4,12, 9) = (/ &
        & 0.11512e+04_r8,0.10115e+04_r8,0.87180e+03_r8,0.73203e+03_r8,0.59373e+03_r8, &
        & 0.73004e+03_r8,0.86900e+03_r8,0.10080e+04_r8,0.11469e+04_r8 /)
      kao(:, 5,12, 9) = (/ &
        & 0.11441e+04_r8,0.10053e+04_r8,0.86640e+03_r8,0.72756e+03_r8,0.59149e+03_r8, &
        & 0.72934e+03_r8,0.86813e+03_r8,0.10070e+04_r8,0.11458e+04_r8 /)
      kao(:, 1,13, 9) = (/ &
        & 0.11533e+04_r8,0.10132e+04_r8,0.87330e+03_r8,0.73334e+03_r8,0.59476e+03_r8, &
        & 0.73130e+03_r8,0.87046e+03_r8,0.10096e+04_r8,0.11487e+04_r8 /)
      kao(:, 2,13, 9) = (/ &
        & 0.11444e+04_r8,0.10055e+04_r8,0.86659e+03_r8,0.72770e+03_r8,0.59240e+03_r8, &
        & 0.73084e+03_r8,0.87005e+03_r8,0.10092e+04_r8,0.11483e+04_r8 /)
      kao(:, 3,13, 9) = (/ &
        & 0.11367e+04_r8,0.99882e+03_r8,0.86084e+03_r8,0.72297e+03_r8,0.59186e+03_r8, &
        & 0.73036e+03_r8,0.86950e+03_r8,0.10087e+04_r8,0.11478e+04_r8 /)
      kao(:, 4,13, 9) = (/ &
        & 0.11300e+04_r8,0.99294e+03_r8,0.85585e+03_r8,0.71880e+03_r8,0.59143e+03_r8, &
        & 0.72979e+03_r8,0.86883e+03_r8,0.10079e+04_r8,0.11469e+04_r8 /)
      kao(:, 5,13, 9) = (/ &
        & 0.11242e+04_r8,0.98788e+03_r8,0.85146e+03_r8,0.71512e+03_r8,0.59082e+03_r8, &
        & 0.72910e+03_r8,0.86797e+03_r8,0.10069e+04_r8,0.11459e+04_r8 /)
      kao(:, 1, 1,10) = (/ &
        & 0.19609e+04_r8,0.17196e+04_r8,0.14787e+04_r8,0.12373e+04_r8,0.99636e+03_r8, &
        & 0.75577e+03_r8,0.88158e+03_r8,0.10175e+04_r8,0.11538e+04_r8 /)
      kao(:, 2, 1,10) = (/ &
        & 0.19102e+04_r8,0.16765e+04_r8,0.14403e+04_r8,0.12063e+04_r8,0.97232e+03_r8, &
        & 0.74406e+03_r8,0.87986e+03_r8,0.10152e+04_r8,0.11513e+04_r8 /)
      kao(:, 3, 1,10) = (/ &
        & 0.18658e+04_r8,0.16364e+04_r8,0.14075e+04_r8,0.11783e+04_r8,0.94916e+03_r8, &
        & 0.74249e+03_r8,0.87815e+03_r8,0.10135e+04_r8,0.11491e+04_r8 /)
      kao(:, 4, 1,10) = (/ &
        & 0.18250e+04_r8,0.16014e+04_r8,0.13778e+04_r8,0.11533e+04_r8,0.92945e+03_r8, &
        & 0.74050e+03_r8,0.87640e+03_r8,0.10114e+04_r8,0.11477e+04_r8 /)
      kao(:, 5, 1,10) = (/ &
        & 0.17888e+04_r8,0.15692e+04_r8,0.13504e+04_r8,0.11313e+04_r8,0.91134e+03_r8, &
        & 0.73837e+03_r8,0.87432e+03_r8,0.10096e+04_r8,0.11467e+04_r8 /)
      kao(:, 1, 2,10) = (/ &
        & 0.18108e+04_r8,0.15879e+04_r8,0.13673e+04_r8,0.11437e+04_r8,0.92213e+03_r8, &
        & 0.74428e+03_r8,0.88077e+03_r8,0.10175e+04_r8,0.11547e+04_r8 /)
      kao(:, 2, 2,10) = (/ &
        & 0.17684e+04_r8,0.15508e+04_r8,0.13352e+04_r8,0.11178e+04_r8,0.90099e+03_r8, &
        & 0.74265e+03_r8,0.87920e+03_r8,0.10158e+04_r8,0.11521e+04_r8 /)
      kao(:, 3, 2,10) = (/ &
        & 0.17293e+04_r8,0.15183e+04_r8,0.13063e+04_r8,0.10931e+04_r8,0.88199e+03_r8, &
        & 0.74117e+03_r8,0.87755e+03_r8,0.10136e+04_r8,0.11500e+04_r8 /)
      kao(:, 4, 2,10) = (/ &
        & 0.16960e+04_r8,0.14887e+04_r8,0.12799e+04_r8,0.10727e+04_r8,0.86433e+03_r8, &
        & 0.73957e+03_r8,0.87577e+03_r8,0.10116e+04_r8,0.11482e+04_r8 /)
      kao(:, 5, 2,10) = (/ &
        & 0.16637e+04_r8,0.14607e+04_r8,0.12562e+04_r8,0.10527e+04_r8,0.84877e+03_r8, &
        & 0.73748e+03_r8,0.87409e+03_r8,0.10096e+04_r8,0.11470e+04_r8 /)
      kao(:, 1, 3,10) = (/ &
        & 0.16939e+04_r8,0.14847e+04_r8,0.12786e+04_r8,0.10705e+04_r8,0.86372e+03_r8, &
        & 0.74343e+03_r8,0.88064e+03_r8,0.10178e+04_r8,0.11559e+04_r8 /)
      kao(:, 2, 3,10) = (/ &
        & 0.16557e+04_r8,0.14542e+04_r8,0.12503e+04_r8,0.10478e+04_r8,0.84533e+03_r8, &
        & 0.74182e+03_r8,0.87906e+03_r8,0.10163e+04_r8,0.11537e+04_r8 /)
      kao(:, 3, 3,10) = (/ &
        & 0.16218e+04_r8,0.14239e+04_r8,0.12249e+04_r8,0.10266e+04_r8,0.82819e+03_r8, &
        & 0.74031e+03_r8,0.87730e+03_r8,0.10137e+04_r8,0.11513e+04_r8 /)
      kao(:, 4, 3,10) = (/ &
        & 0.15929e+04_r8,0.13992e+04_r8,0.12027e+04_r8,0.10077e+04_r8,0.81299e+03_r8, &
        & 0.73896e+03_r8,0.87590e+03_r8,0.10123e+04_r8,0.11493e+04_r8 /)
      kao(:, 5, 3,10) = (/ &
        & 0.15654e+04_r8,0.13740e+04_r8,0.11824e+04_r8,0.99136e+03_r8,0.79933e+03_r8, &
        & 0.73740e+03_r8,0.87406e+03_r8,0.10104e+04_r8,0.11477e+04_r8 /)
      kao(:, 1, 4,10) = (/ &
        & 0.15959e+04_r8,0.14010e+04_r8,0.12054e+04_r8,0.10100e+04_r8,0.81522e+03_r8, &
        & 0.74271e+03_r8,0.88040e+03_r8,0.10180e+04_r8,0.11570e+04_r8 /)
      kao(:, 2, 4,10) = (/ &
        & 0.15637e+04_r8,0.13710e+04_r8,0.11804e+04_r8,0.98920e+03_r8,0.79803e+03_r8, &
        & 0.74139e+03_r8,0.87903e+03_r8,0.10168e+04_r8,0.11552e+04_r8 /)
      kao(:, 3, 4,10) = (/ &
        & 0.15330e+04_r8,0.13459e+04_r8,0.11594e+04_r8,0.97120e+03_r8,0.78314e+03_r8, &
        & 0.74000e+03_r8,0.87753e+03_r8,0.10151e+04_r8,0.11528e+04_r8 /)
      kao(:, 4, 4,10) = (/ &
        & 0.15077e+04_r8,0.13229e+04_r8,0.11386e+04_r8,0.95486e+03_r8,0.77029e+03_r8, &
        & 0.73854e+03_r8,0.87600e+03_r8,0.10131e+04_r8,0.11506e+04_r8 /)
      kao(:, 5, 4,10) = (/ &
        & 0.14835e+04_r8,0.13025e+04_r8,0.11209e+04_r8,0.94000e+03_r8,0.75786e+03_r8, &
        & 0.73717e+03_r8,0.87438e+03_r8,0.10111e+04_r8,0.11486e+04_r8 /)
      kao(:, 1, 5,10) = (/ &
        & 0.15126e+04_r8,0.13285e+04_r8,0.11431e+04_r8,0.95745e+03_r8,0.77284e+03_r8, &
        & 0.74220e+03_r8,0.88024e+03_r8,0.10187e+04_r8,0.11578e+04_r8 /)
      kao(:, 2, 5,10) = (/ &
        & 0.14829e+04_r8,0.13024e+04_r8,0.11209e+04_r8,0.94020e+03_r8,0.75863e+03_r8, &
        & 0.74099e+03_r8,0.87909e+03_r8,0.10174e+04_r8,0.11564e+04_r8 /)
      kao(:, 3, 5,10) = (/ &
        & 0.14582e+04_r8,0.12806e+04_r8,0.11014e+04_r8,0.92377e+03_r8,0.74596e+03_r8, &
        & 0.73960e+03_r8,0.87772e+03_r8,0.10159e+04_r8,0.11544e+04_r8 /)
      kao(:, 4, 5,10) = (/ &
        & 0.14345e+04_r8,0.12594e+04_r8,0.10847e+04_r8,0.90887e+03_r8,0.73410e+03_r8, &
        & 0.73828e+03_r8,0.87622e+03_r8,0.10139e+04_r8,0.11518e+04_r8 /)
      kao(:, 5, 5,10) = (/ &
        & 0.14140e+04_r8,0.12418e+04_r8,0.10683e+04_r8,0.89661e+03_r8,0.72364e+03_r8, &
        & 0.73696e+03_r8,0.87469e+03_r8,0.10119e+04_r8,0.11501e+04_r8 /)
      kao(:, 1, 6,10) = (/ &
        & 0.14435e+04_r8,0.12676e+04_r8,0.10914e+04_r8,0.91493e+03_r8,0.73889e+03_r8, &
        & 0.74179e+03_r8,0.88024e+03_r8,0.10190e+04_r8,0.11586e+04_r8 /)
      kao(:, 2, 6,10) = (/ &
        & 0.14184e+04_r8,0.12443e+04_r8,0.10722e+04_r8,0.89834e+03_r8,0.72535e+03_r8, &
        & 0.74069e+03_r8,0.87922e+03_r8,0.10178e+04_r8,0.11574e+04_r8 /)
      kao(:, 3, 6,10) = (/ &
        & 0.13949e+04_r8,0.12245e+04_r8,0.10548e+04_r8,0.88411e+03_r8,0.71441e+03_r8, &
        & 0.73951e+03_r8,0.87792e+03_r8,0.10164e+04_r8,0.11554e+04_r8 /)
      kao(:, 4, 6,10) = (/ &
        & 0.13745e+04_r8,0.12070e+04_r8,0.10388e+04_r8,0.87157e+03_r8,0.70381e+03_r8, &
        & 0.73817e+03_r8,0.87654e+03_r8,0.10150e+04_r8,0.11533e+04_r8 /)
      kao(:, 5, 6,10) = (/ &
        & 0.13558e+04_r8,0.11909e+04_r8,0.10253e+04_r8,0.86039e+03_r8,0.69505e+03_r8, &
        & 0.73669e+03_r8,0.87508e+03_r8,0.10128e+04_r8,0.11510e+04_r8 /)
      kao(:, 1, 7,10) = (/ &
        & 0.13849e+04_r8,0.12154e+04_r8,0.10465e+04_r8,0.87809e+03_r8,0.70922e+03_r8, &
        & 0.74150e+03_r8,0.88017e+03_r8,0.10197e+04_r8,0.11599e+04_r8 /)
      kao(:, 2, 7,10) = (/ &
        & 0.13622e+04_r8,0.11954e+04_r8,0.10296e+04_r8,0.86328e+03_r8,0.69750e+03_r8, &
        & 0.74031e+03_r8,0.87926e+03_r8,0.10184e+04_r8,0.11581e+04_r8 /)
      kao(:, 3, 7,10) = (/ &
        & 0.13407e+04_r8,0.11775e+04_r8,0.10144e+04_r8,0.85098e+03_r8,0.68710e+03_r8, &
        & 0.73933e+03_r8,0.87824e+03_r8,0.10171e+04_r8,0.11568e+04_r8 /)
      kao(:, 4, 7,10) = (/ &
        & 0.13234e+04_r8,0.11620e+04_r8,0.10006e+04_r8,0.83940e+03_r8,0.67808e+03_r8, &
        & 0.73818e+03_r8,0.87693e+03_r8,0.10157e+04_r8,0.11549e+04_r8 /)
      kao(:, 5, 7,10) = (/ &
        & 0.13077e+04_r8,0.11481e+04_r8,0.98850e+03_r8,0.82952e+03_r8,0.66976e+03_r8, &
        & 0.73685e+03_r8,0.87533e+03_r8,0.10140e+04_r8,0.11525e+04_r8 /)
      kao(:, 1, 8,10) = (/ &
        & 0.13336e+04_r8,0.11711e+04_r8,0.10088e+04_r8,0.84626e+03_r8,0.68382e+03_r8, &
        & 0.74131e+03_r8,0.88025e+03_r8,0.10205e+04_r8,0.11609e+04_r8 /)
      kao(:, 2, 8,10) = (/ &
        & 0.13133e+04_r8,0.11535e+04_r8,0.99382e+03_r8,0.83328e+03_r8,0.67355e+03_r8, &
        & 0.73954e+03_r8,0.87931e+03_r8,0.10187e+04_r8,0.11591e+04_r8 /)
      kao(:, 3, 8,10) = (/ &
        & 0.12952e+04_r8,0.11377e+04_r8,0.97980e+03_r8,0.82257e+03_r8,0.66450e+03_r8, &
        & 0.73910e+03_r8,0.87831e+03_r8,0.10177e+04_r8,0.11576e+04_r8 /)
      kao(:, 4, 8,10) = (/ &
        & 0.12798e+04_r8,0.11238e+04_r8,0.96848e+03_r8,0.81189e+03_r8,0.65672e+03_r8, &
        & 0.73820e+03_r8,0.87729e+03_r8,0.10162e+04_r8,0.11560e+04_r8 /)
      kao(:, 5, 8,10) = (/ &
        & 0.12652e+04_r8,0.11115e+04_r8,0.95739e+03_r8,0.80373e+03_r8,0.64938e+03_r8, &
        & 0.73712e+03_r8,0.87584e+03_r8,0.10149e+04_r8,0.11541e+04_r8 /)
      kao(:, 1, 9,10) = (/ &
        & 0.12921e+04_r8,0.11338e+04_r8,0.97649e+03_r8,0.81965e+03_r8,0.66193e+03_r8, &
        & 0.74117e+03_r8,0.88056e+03_r8,0.10212e+04_r8,0.11621e+04_r8 /)
      kao(:, 2, 9,10) = (/ &
        & 0.12725e+04_r8,0.11175e+04_r8,0.96294e+03_r8,0.80792e+03_r8,0.65314e+03_r8, &
        & 0.74018e+03_r8,0.87944e+03_r8,0.10196e+04_r8,0.11602e+04_r8 /)
      kao(:, 3, 9,10) = (/ &
        & 0.12569e+04_r8,0.11032e+04_r8,0.95038e+03_r8,0.79825e+03_r8,0.64471e+03_r8, &
        & 0.73910e+03_r8,0.87852e+03_r8,0.10181e+04_r8,0.11585e+04_r8 /)
      kao(:, 4, 9,10) = (/ &
        & 0.12428e+04_r8,0.10914e+04_r8,0.94028e+03_r8,0.78940e+03_r8,0.63769e+03_r8, &
        & 0.73816e+03_r8,0.87758e+03_r8,0.10170e+04_r8,0.11569e+04_r8 /)
      kao(:, 5, 9,10) = (/ &
        & 0.12310e+04_r8,0.10815e+04_r8,0.93149e+03_r8,0.78151e+03_r8,0.63218e+03_r8, &
        & 0.73726e+03_r8,0.87637e+03_r8,0.10156e+04_r8,0.11553e+04_r8 /)
      kao(:, 1,10,10) = (/ &
        & 0.12531e+04_r8,0.11009e+04_r8,0.94808e+03_r8,0.79569e+03_r8,0.64353e+03_r8, &
        & 0.74092e+03_r8,0.88101e+03_r8,0.10222e+04_r8,0.11631e+04_r8 /)
      kao(:, 2,10,10) = (/ &
        & 0.12357e+04_r8,0.10861e+04_r8,0.93599e+03_r8,0.78490e+03_r8,0.63564e+03_r8, &
        & 0.74008e+03_r8,0.87961e+03_r8,0.10203e+04_r8,0.11613e+04_r8 /)
      kao(:, 3,10,10) = (/ &
        & 0.12227e+04_r8,0.10738e+04_r8,0.92501e+03_r8,0.77680e+03_r8,0.62842e+03_r8, &
        & 0.73914e+03_r8,0.87860e+03_r8,0.10179e+04_r8,0.11592e+04_r8 /)
      kao(:, 4,10,10) = (/ &
        & 0.12109e+04_r8,0.10632e+04_r8,0.91605e+03_r8,0.76920e+03_r8,0.62177e+03_r8, &
        & 0.73819e+03_r8,0.87758e+03_r8,0.10174e+04_r8,0.11577e+04_r8 /)
      kao(:, 5,10,10) = (/ &
        & 0.11998e+04_r8,0.10537e+04_r8,0.90813e+03_r8,0.76232e+03_r8,0.61616e+03_r8, &
        & 0.73732e+03_r8,0.87676e+03_r8,0.10162e+04_r8,0.11563e+04_r8 /)
      kao(:, 1,11,10) = (/ &
        & 0.12137e+04_r8,0.10654e+04_r8,0.91884e+03_r8,0.77105e+03_r8,0.62358e+03_r8, &
        & 0.74042e+03_r8,0.88057e+03_r8,0.10221e+04_r8,0.11630e+04_r8 /)
      kao(:, 2,11,10) = (/ &
        & 0.11999e+04_r8,0.10545e+04_r8,0.90854e+03_r8,0.76253e+03_r8,0.61715e+03_r8, &
        & 0.73961e+03_r8,0.87932e+03_r8,0.10201e+04_r8,0.11611e+04_r8 /)
      kao(:, 3,11,10) = (/ &
        & 0.11890e+04_r8,0.10445e+04_r8,0.90019e+03_r8,0.75537e+03_r8,0.61109e+03_r8, &
        & 0.73864e+03_r8,0.87832e+03_r8,0.10186e+04_r8,0.11592e+04_r8 /)
      kao(:, 4,11,10) = (/ &
        & 0.11789e+04_r8,0.10359e+04_r8,0.89280e+03_r8,0.74928e+03_r8,0.60622e+03_r8, &
        & 0.73779e+03_r8,0.87747e+03_r8,0.10172e+04_r8,0.11577e+04_r8 /)
      kao(:, 5,11,10) = (/ &
        & 0.11709e+04_r8,0.10287e+04_r8,0.88607e+03_r8,0.74401e+03_r8,0.60247e+03_r8, &
        & 0.73688e+03_r8,0.87644e+03_r8,0.10160e+04_r8,0.11563e+04_r8 /)
      kao(:, 1,12,10) = (/ &
        & 0.11820e+04_r8,0.10383e+04_r8,0.89456e+03_r8,0.75081e+03_r8,0.60714e+03_r8, &
        & 0.74001e+03_r8,0.88049e+03_r8,0.10220e+04_r8,0.11631e+04_r8 /)
      kao(:, 2,12,10) = (/ &
        & 0.11713e+04_r8,0.10290e+04_r8,0.88623e+03_r8,0.74407e+03_r8,0.60058e+03_r8, &
        & 0.73921e+03_r8,0.87901e+03_r8,0.10201e+04_r8,0.11611e+04_r8 /)
      kao(:, 3,12,10) = (/ &
        & 0.11605e+04_r8,0.10200e+04_r8,0.87951e+03_r8,0.73788e+03_r8,0.59769e+03_r8, &
        & 0.73835e+03_r8,0.87808e+03_r8,0.10182e+04_r8,0.11591e+04_r8 /)
      kao(:, 4,12,10) = (/ &
        & 0.11533e+04_r8,0.10132e+04_r8,0.87284e+03_r8,0.73305e+03_r8,0.59795e+03_r8, &
        & 0.73753e+03_r8,0.87718e+03_r8,0.10171e+04_r8,0.11577e+04_r8 /)
      kao(:, 5,12,10) = (/ &
        & 0.11467e+04_r8,0.10071e+04_r8,0.86739e+03_r8,0.72890e+03_r8,0.59711e+03_r8, &
        & 0.73664e+03_r8,0.87623e+03_r8,0.10159e+04_r8,0.11563e+04_r8 /)
      kao(:, 1,13,10) = (/ &
        & 0.11553e+04_r8,0.10149e+04_r8,0.87419e+03_r8,0.73470e+03_r8,0.59975e+03_r8, &
        & 0.73968e+03_r8,0.88029e+03_r8,0.10219e+04_r8,0.11630e+04_r8 /)
      kao(:, 2,13,10) = (/ &
        & 0.11455e+04_r8,0.10072e+04_r8,0.86782e+03_r8,0.72873e+03_r8,0.59921e+03_r8, &
        & 0.73889e+03_r8,0.87889e+03_r8,0.10200e+04_r8,0.11611e+04_r8 /)
      kao(:, 3,13,10) = (/ &
        & 0.11380e+04_r8,0.10000e+04_r8,0.86190e+03_r8,0.72452e+03_r8,0.59831e+03_r8, &
        & 0.73799e+03_r8,0.87789e+03_r8,0.10182e+04_r8,0.11592e+04_r8 /)
      kao(:, 4,13,10) = (/ &
        & 0.11318e+04_r8,0.99472e+03_r8,0.85697e+03_r8,0.71950e+03_r8,0.59744e+03_r8, &
        & 0.73726e+03_r8,0.87708e+03_r8,0.10170e+04_r8,0.11577e+04_r8 /)
      kao(:, 5,13,10) = (/ &
        & 0.11253e+04_r8,0.98825e+03_r8,0.85273e+03_r8,0.71635e+03_r8,0.59683e+03_r8, &
        & 0.73639e+03_r8,0.87606e+03_r8,0.10160e+04_r8,0.11562e+04_r8 /)
      kao(:, 1, 1,11) = (/ &
        & 0.19598e+04_r8,0.17186e+04_r8,0.14777e+04_r8,0.12380e+04_r8,0.99729e+03_r8, &
        & 0.75567e+03_r8,0.88469e+03_r8,0.10202e+04_r8,0.11560e+04_r8 /)
      kao(:, 2, 1,11) = (/ &
        & 0.19102e+04_r8,0.16743e+04_r8,0.14414e+04_r8,0.12066e+04_r8,0.97117e+03_r8, &
        & 0.74679e+03_r8,0.88252e+03_r8,0.10178e+04_r8,0.11544e+04_r8 /)
      kao(:, 3, 1,11) = (/ &
        & 0.18656e+04_r8,0.16383e+04_r8,0.14073e+04_r8,0.11791e+04_r8,0.94951e+03_r8, &
        & 0.74505e+03_r8,0.88029e+03_r8,0.10159e+04_r8,0.11530e+04_r8 /)
      kao(:, 4, 1,11) = (/ &
        & 0.18261e+04_r8,0.16025e+04_r8,0.13782e+04_r8,0.11540e+04_r8,0.92917e+03_r8, &
        & 0.74299e+03_r8,0.87816e+03_r8,0.10141e+04_r8,0.11522e+04_r8 /)
      kao(:, 5, 1,11) = (/ &
        & 0.17888e+04_r8,0.15710e+04_r8,0.13500e+04_r8,0.11298e+04_r8,0.91140e+03_r8, &
        & 0.74109e+03_r8,0.87588e+03_r8,0.10122e+04_r8,0.11510e+04_r8 /)
      kao(:, 1, 2,11) = (/ &
        & 0.18117e+04_r8,0.15887e+04_r8,0.13651e+04_r8,0.11459e+04_r8,0.92177e+03_r8, &
        & 0.74731e+03_r8,0.88412e+03_r8,0.10203e+04_r8,0.11568e+04_r8 /)
      kao(:, 2, 2,11) = (/ &
        & 0.17673e+04_r8,0.15512e+04_r8,0.13335e+04_r8,0.11174e+04_r8,0.90028e+03_r8, &
        & 0.74546e+03_r8,0.88203e+03_r8,0.10179e+04_r8,0.11551e+04_r8 /)
      kao(:, 3, 2,11) = (/ &
        & 0.17317e+04_r8,0.15193e+04_r8,0.13050e+04_r8,0.10955e+04_r8,0.88112e+03_r8, &
        & 0.74378e+03_r8,0.87978e+03_r8,0.10161e+04_r8,0.11535e+04_r8 /)
      kao(:, 4, 2,11) = (/ &
        & 0.16956e+04_r8,0.14873e+04_r8,0.12805e+04_r8,0.10729e+04_r8,0.86470e+03_r8, &
        & 0.74189e+03_r8,0.87768e+03_r8,0.10142e+04_r8,0.11524e+04_r8 /)
      kao(:, 5, 2,11) = (/ &
        & 0.16657e+04_r8,0.14596e+04_r8,0.12568e+04_r8,0.10531e+04_r8,0.84904e+03_r8, &
        & 0.73979e+03_r8,0.87528e+03_r8,0.10122e+04_r8,0.11511e+04_r8 /)
      kao(:, 1, 3,11) = (/ &
        & 0.16927e+04_r8,0.14859e+04_r8,0.12782e+04_r8,0.10724e+04_r8,0.86335e+03_r8, &
        & 0.74646e+03_r8,0.88392e+03_r8,0.10211e+04_r8,0.11579e+04_r8 /)
      kao(:, 2, 3,11) = (/ &
        & 0.16581e+04_r8,0.14524e+04_r8,0.12540e+04_r8,0.10466e+04_r8,0.84448e+03_r8, &
        & 0.74471e+03_r8,0.88205e+03_r8,0.10189e+04_r8,0.11562e+04_r8 /)
      kao(:, 3, 3,11) = (/ &
        & 0.16261e+04_r8,0.14229e+04_r8,0.12269e+04_r8,0.10264e+04_r8,0.82790e+03_r8, &
        & 0.74305e+03_r8,0.87988e+03_r8,0.10167e+04_r8,0.11544e+04_r8 /)
      kao(:, 4, 3,11) = (/ &
        & 0.15929e+04_r8,0.13986e+04_r8,0.12038e+04_r8,0.10084e+04_r8,0.81266e+03_r8, &
        & 0.74160e+03_r8,0.87767e+03_r8,0.10148e+04_r8,0.11530e+04_r8 /)
      kao(:, 5, 3,11) = (/ &
        & 0.15661e+04_r8,0.13746e+04_r8,0.11837e+04_r8,0.99103e+03_r8,0.79967e+03_r8, &
        & 0.73929e+03_r8,0.87586e+03_r8,0.10132e+04_r8,0.11521e+04_r8 /)
      kao(:, 1, 4,11) = (/ &
        & 0.15973e+04_r8,0.14004e+04_r8,0.12065e+04_r8,0.10106e+04_r8,0.81385e+03_r8, &
        & 0.74599e+03_r8,0.88404e+03_r8,0.10218e+04_r8,0.11590e+04_r8 /)
      kao(:, 2, 4,11) = (/ &
        & 0.15637e+04_r8,0.13722e+04_r8,0.11812e+04_r8,0.98900e+03_r8,0.79856e+03_r8, &
        & 0.74428e+03_r8,0.88217e+03_r8,0.10197e+04_r8,0.11572e+04_r8 /)
      kao(:, 3, 4,11) = (/ &
        & 0.15340e+04_r8,0.13469e+04_r8,0.11576e+04_r8,0.97012e+03_r8,0.78412e+03_r8, &
        & 0.74257e+03_r8,0.88022e+03_r8,0.10176e+04_r8,0.11556e+04_r8 /)
      kao(:, 4, 4,11) = (/ &
        & 0.15085e+04_r8,0.13226e+04_r8,0.11393e+04_r8,0.95486e+03_r8,0.76980e+03_r8, &
        & 0.74114e+03_r8,0.87815e+03_r8,0.10155e+04_r8,0.11538e+04_r8 /)
      kao(:, 5, 4,11) = (/ &
        & 0.14836e+04_r8,0.13020e+04_r8,0.11212e+04_r8,0.93957e+03_r8,0.75824e+03_r8, &
        & 0.73939e+03_r8,0.87630e+03_r8,0.10138e+04_r8,0.11526e+04_r8 /)
      kao(:, 1, 5,11) = (/ &
        & 0.15143e+04_r8,0.13286e+04_r8,0.11431e+04_r8,0.95847e+03_r8,0.77403e+03_r8, &
        & 0.74572e+03_r8,0.88418e+03_r8,0.10223e+04_r8,0.11603e+04_r8 /)
      kao(:, 2, 5,11) = (/ &
        & 0.14842e+04_r8,0.13025e+04_r8,0.11230e+04_r8,0.94028e+03_r8,0.75881e+03_r8, &
        & 0.74405e+03_r8,0.88254e+03_r8,0.10205e+04_r8,0.11584e+04_r8 /)
      kao(:, 3, 5,11) = (/ &
        & 0.14577e+04_r8,0.12799e+04_r8,0.11020e+04_r8,0.92340e+03_r8,0.74531e+03_r8, &
        & 0.74244e+03_r8,0.88060e+03_r8,0.10185e+04_r8,0.11566e+04_r8 /)
      kao(:, 4, 5,11) = (/ &
        & 0.14365e+04_r8,0.12603e+04_r8,0.10859e+04_r8,0.90939e+03_r8,0.73467e+03_r8, &
        & 0.74090e+03_r8,0.87865e+03_r8,0.10164e+04_r8,0.11549e+04_r8 /)
      kao(:, 5, 5,11) = (/ &
        & 0.14147e+04_r8,0.12422e+04_r8,0.10695e+04_r8,0.89657e+03_r8,0.72409e+03_r8, &
        & 0.73938e+03_r8,0.87659e+03_r8,0.10145e+04_r8,0.11530e+04_r8 /)
      kao(:, 1, 6,11) = (/ &
        & 0.14426e+04_r8,0.12686e+04_r8,0.10911e+04_r8,0.91528e+03_r8,0.73914e+03_r8, &
        & 0.74563e+03_r8,0.88436e+03_r8,0.10228e+04_r8,0.11615e+04_r8 /)
      kao(:, 2, 6,11) = (/ &
        & 0.14171e+04_r8,0.12457e+04_r8,0.10728e+04_r8,0.89861e+03_r8,0.72517e+03_r8, &
        & 0.74402e+03_r8,0.88280e+03_r8,0.10215e+04_r8,0.11596e+04_r8 /)
      kao(:, 3, 6,11) = (/ &
        & 0.13943e+04_r8,0.12252e+04_r8,0.10539e+04_r8,0.88362e+03_r8,0.71333e+03_r8, &
        & 0.74243e+03_r8,0.88117e+03_r8,0.10194e+04_r8,0.11577e+04_r8 /)
      kao(:, 4, 6,11) = (/ &
        & 0.13749e+04_r8,0.12056e+04_r8,0.10405e+04_r8,0.87188e+03_r8,0.70449e+03_r8, &
        & 0.74089e+03_r8,0.87923e+03_r8,0.10173e+04_r8,0.11560e+04_r8 /)
      kao(:, 5, 6,11) = (/ &
        & 0.13580e+04_r8,0.11907e+04_r8,0.10258e+04_r8,0.85998e+03_r8,0.69473e+03_r8, &
        & 0.73937e+03_r8,0.87727e+03_r8,0.10154e+04_r8,0.11543e+04_r8 /)
      kao(:, 1, 7,11) = (/ &
        & 0.13844e+04_r8,0.12166e+04_r8,0.10469e+04_r8,0.87815e+03_r8,0.70873e+03_r8, &
        & 0.74560e+03_r8,0.88449e+03_r8,0.10233e+04_r8,0.11626e+04_r8 /)
      kao(:, 2, 7,11) = (/ &
        & 0.13610e+04_r8,0.11962e+04_r8,0.10291e+04_r8,0.86318e+03_r8,0.69730e+03_r8, &
        & 0.74409e+03_r8,0.88322e+03_r8,0.10221e+04_r8,0.11608e+04_r8 /)
      kao(:, 3, 7,11) = (/ &
        & 0.13413e+04_r8,0.11786e+04_r8,0.10145e+04_r8,0.85031e+03_r8,0.68760e+03_r8, &
        & 0.74253e+03_r8,0.88154e+03_r8,0.10203e+04_r8,0.11589e+04_r8 /)
      kao(:, 4, 7,11) = (/ &
        & 0.13235e+04_r8,0.11630e+04_r8,0.10007e+04_r8,0.84004e+03_r8,0.67864e+03_r8, &
        & 0.74101e+03_r8,0.87982e+03_r8,0.10185e+04_r8,0.11572e+04_r8 /)
      kao(:, 5, 7,11) = (/ &
        & 0.13063e+04_r8,0.11482e+04_r8,0.98932e+03_r8,0.82998e+03_r8,0.67037e+03_r8, &
        & 0.73955e+03_r8,0.87796e+03_r8,0.10167e+04_r8,0.11554e+04_r8 /)
      kao(:, 1, 8,11) = (/ &
        & 0.13361e+04_r8,0.11714e+04_r8,0.10092e+04_r8,0.84627e+03_r8,0.68340e+03_r8, &
        & 0.74540e+03_r8,0.88457e+03_r8,0.10236e+04_r8,0.11638e+04_r8 /)
      kao(:, 2, 8,11) = (/ &
        & 0.13143e+04_r8,0.11537e+04_r8,0.99295e+03_r8,0.83355e+03_r8,0.67330e+03_r8, &
        & 0.74420e+03_r8,0.88339e+03_r8,0.10225e+04_r8,0.11619e+04_r8 /)
      kao(:, 3, 8,11) = (/ &
        & 0.12952e+04_r8,0.11377e+04_r8,0.98075e+03_r8,0.82213e+03_r8,0.66496e+03_r8, &
        & 0.74271e+03_r8,0.88199e+03_r8,0.10211e+04_r8,0.11601e+04_r8 /)
      kao(:, 4, 8,11) = (/ &
        & 0.12808e+04_r8,0.11242e+04_r8,0.96858e+03_r8,0.81350e+03_r8,0.65663e+03_r8, &
        & 0.74121e+03_r8,0.88037e+03_r8,0.10192e+04_r8,0.11582e+04_r8 /)
      kao(:, 5, 8,11) = (/ &
        & 0.12664e+04_r8,0.11113e+04_r8,0.95757e+03_r8,0.80317e+03_r8,0.64978e+03_r8, &
        & 0.73975e+03_r8,0.87862e+03_r8,0.10173e+04_r8,0.11564e+04_r8 /)
      kao(:, 1, 9,11) = (/ &
        & 0.12911e+04_r8,0.11331e+04_r8,0.97754e+03_r8,0.81972e+03_r8,0.66210e+03_r8, &
        & 0.74501e+03_r8,0.88462e+03_r8,0.10244e+04_r8,0.11652e+04_r8 /)
      kao(:, 2, 9,11) = (/ &
        & 0.12743e+04_r8,0.11193e+04_r8,0.96288e+03_r8,0.80865e+03_r8,0.65325e+03_r8, &
        & 0.74437e+03_r8,0.88360e+03_r8,0.10230e+04_r8,0.11629e+04_r8 /)
      kao(:, 3, 9,11) = (/ &
        & 0.12573e+04_r8,0.11051e+04_r8,0.95155e+03_r8,0.79729e+03_r8,0.64451e+03_r8, &
        & 0.74294e+03_r8,0.88237e+03_r8,0.10218e+04_r8,0.11610e+04_r8 /)
      kao(:, 4, 9,11) = (/ &
        & 0.12441e+04_r8,0.10920e+04_r8,0.94089e+03_r8,0.78911e+03_r8,0.63797e+03_r8, &
        & 0.74148e+03_r8,0.88091e+03_r8,0.10202e+04_r8,0.11593e+04_r8 /)
      kao(:, 5, 9,11) = (/ &
        & 0.12297e+04_r8,0.10813e+04_r8,0.93127e+03_r8,0.78127e+03_r8,0.63265e+03_r8, &
        & 0.74003e+03_r8,0.87926e+03_r8,0.10184e+04_r8,0.11573e+04_r8 /)
      kao(:, 1,10,11) = (/ &
        & 0.12530e+04_r8,0.11001e+04_r8,0.94821e+03_r8,0.79486e+03_r8,0.64277e+03_r8, &
        & 0.74454e+03_r8,0.88447e+03_r8,0.10249e+04_r8,0.11664e+04_r8 /)
      kao(:, 2,10,11) = (/ &
        & 0.12387e+04_r8,0.10865e+04_r8,0.93685e+03_r8,0.78643e+03_r8,0.63425e+03_r8, &
        & 0.74423e+03_r8,0.88371e+03_r8,0.10234e+04_r8,0.11637e+04_r8 /)
      kao(:, 3,10,11) = (/ &
        & 0.12243e+04_r8,0.10744e+04_r8,0.92585e+03_r8,0.77676e+03_r8,0.62740e+03_r8, &
        & 0.74307e+03_r8,0.88260e+03_r8,0.10221e+04_r8,0.11620e+04_r8 /)
      kao(:, 4,10,11) = (/ &
        & 0.12107e+04_r8,0.10640e+04_r8,0.91623e+03_r8,0.76957e+03_r8,0.62235e+03_r8, &
        & 0.74168e+03_r8,0.88129e+03_r8,0.10208e+04_r8,0.11602e+04_r8 /)
      kao(:, 5,10,11) = (/ &
        & 0.12010e+04_r8,0.10536e+04_r8,0.90891e+03_r8,0.76248e+03_r8,0.61761e+03_r8, &
        & 0.74025e+03_r8,0.87965e+03_r8,0.10191e+04_r8,0.11583e+04_r8 /)
      kao(:, 1,11,11) = (/ &
        & 0.12140e+04_r8,0.10672e+04_r8,0.91852e+03_r8,0.77048e+03_r8,0.62320e+03_r8, &
        & 0.74401e+03_r8,0.88413e+03_r8,0.10249e+04_r8,0.11664e+04_r8 /)
      kao(:, 2,11,11) = (/ &
        & 0.12007e+04_r8,0.10549e+04_r8,0.90904e+03_r8,0.76333e+03_r8,0.61635e+03_r8, &
        & 0.74367e+03_r8,0.88337e+03_r8,0.10233e+04_r8,0.11639e+04_r8 /)
      kao(:, 3,11,11) = (/ &
        & 0.11891e+04_r8,0.10458e+04_r8,0.90055e+03_r8,0.75543e+03_r8,0.61123e+03_r8, &
        & 0.74262e+03_r8,0.88229e+03_r8,0.10219e+04_r8,0.11620e+04_r8 /)
      kao(:, 4,11,11) = (/ &
        & 0.11794e+04_r8,0.10371e+04_r8,0.89190e+03_r8,0.74912e+03_r8,0.60572e+03_r8, &
        & 0.74128e+03_r8,0.88110e+03_r8,0.10207e+04_r8,0.11602e+04_r8 /)
      kao(:, 5,11,11) = (/ &
        & 0.11697e+04_r8,0.10285e+04_r8,0.88631e+03_r8,0.74374e+03_r8,0.60062e+03_r8, &
        & 0.73987e+03_r8,0.87958e+03_r8,0.10191e+04_r8,0.11583e+04_r8 /)
      kao(:, 1,12,11) = (/ &
        & 0.11829e+04_r8,0.10373e+04_r8,0.89433e+03_r8,0.75107e+03_r8,0.60775e+03_r8, &
        & 0.74357e+03_r8,0.88385e+03_r8,0.10247e+04_r8,0.11664e+04_r8 /)
      kao(:, 2,12,11) = (/ &
        & 0.11707e+04_r8,0.10276e+04_r8,0.88712e+03_r8,0.74426e+03_r8,0.60163e+03_r8, &
        & 0.74327e+03_r8,0.88309e+03_r8,0.10231e+04_r8,0.11639e+04_r8 /)
      kao(:, 3,12,11) = (/ &
        & 0.11629e+04_r8,0.10211e+04_r8,0.88018e+03_r8,0.73831e+03_r8,0.60184e+03_r8, &
        & 0.74224e+03_r8,0.88203e+03_r8,0.10219e+04_r8,0.11620e+04_r8 /)
      kao(:, 4,12,11) = (/ &
        & 0.11538e+04_r8,0.10126e+04_r8,0.87253e+03_r8,0.73377e+03_r8,0.60080e+03_r8, &
        & 0.74101e+03_r8,0.88067e+03_r8,0.10205e+04_r8,0.11602e+04_r8 /)
      kao(:, 5,12,11) = (/ &
        & 0.11449e+04_r8,0.10062e+04_r8,0.86764e+03_r8,0.72842e+03_r8,0.59975e+03_r8, &
        & 0.73955e+03_r8,0.87926e+03_r8,0.10190e+04_r8,0.11583e+04_r8 /)
      kao(:, 1,13,11) = (/ &
        & 0.11561e+04_r8,0.10152e+04_r8,0.87509e+03_r8,0.73383e+03_r8,0.60253e+03_r8, &
        & 0.74321e+03_r8,0.88362e+03_r8,0.10246e+04_r8,0.11664e+04_r8 /)
      kao(:, 2,13,11) = (/ &
        & 0.11468e+04_r8,0.10069e+04_r8,0.86783e+03_r8,0.72921e+03_r8,0.60211e+03_r8, &
        & 0.74294e+03_r8,0.88286e+03_r8,0.10230e+04_r8,0.11639e+04_r8 /)
      kao(:, 3,13,11) = (/ &
        & 0.11390e+04_r8,0.10001e+04_r8,0.86301e+03_r8,0.72323e+03_r8,0.60140e+03_r8, &
        & 0.74194e+03_r8,0.88181e+03_r8,0.10218e+04_r8,0.11621e+04_r8 /)
      kao(:, 4,13,11) = (/ &
        & 0.11313e+04_r8,0.99361e+03_r8,0.85706e+03_r8,0.72032e+03_r8,0.60042e+03_r8, &
        & 0.74065e+03_r8,0.88048e+03_r8,0.10204e+04_r8,0.11602e+04_r8 /)
      kao(:, 5,13,11) = (/ &
        & 0.11266e+04_r8,0.99042e+03_r8,0.85257e+03_r8,0.71548e+03_r8,0.59931e+03_r8, &
        & 0.73930e+03_r8,0.87908e+03_r8,0.10187e+04_r8,0.11583e+04_r8 /)
      kao(:, 1, 1,12) = (/ &
        & 0.19596e+04_r8,0.17200e+04_r8,0.14802e+04_r8,0.12370e+04_r8,0.99641e+03_r8, &
        & 0.75556e+03_r8,0.88658e+03_r8,0.10236e+04_r8,0.11622e+04_r8 /)
      kao(:, 2, 1,12) = (/ &
        & 0.19107e+04_r8,0.16797e+04_r8,0.14463e+04_r8,0.12083e+04_r8,0.97440e+03_r8, &
        & 0.74935e+03_r8,0.88455e+03_r8,0.10223e+04_r8,0.11611e+04_r8 /)
      kao(:, 3, 1,12) = (/ &
        & 0.18687e+04_r8,0.16368e+04_r8,0.14091e+04_r8,0.11809e+04_r8,0.95100e+03_r8, &
        & 0.74626e+03_r8,0.88278e+03_r8,0.10214e+04_r8,0.11600e+04_r8 /)
      kao(:, 4, 1,12) = (/ &
        & 0.18274e+04_r8,0.15998e+04_r8,0.13805e+04_r8,0.11544e+04_r8,0.92955e+03_r8, &
        & 0.74432e+03_r8,0.88029e+03_r8,0.10193e+04_r8,0.11572e+04_r8 /)
      kao(:, 5, 1,12) = (/ &
        & 0.17908e+04_r8,0.15685e+04_r8,0.13492e+04_r8,0.11303e+04_r8,0.91228e+03_r8, &
        & 0.74183e+03_r8,0.87814e+03_r8,0.10165e+04_r8,0.11551e+04_r8 /)
      kao(:, 1, 2,12) = (/ &
        & 0.18091e+04_r8,0.15890e+04_r8,0.13701e+04_r8,0.11447e+04_r8,0.92240e+03_r8, &
        & 0.75031e+03_r8,0.88580e+03_r8,0.10236e+04_r8,0.11628e+04_r8 /)
      kao(:, 2, 2,12) = (/ &
        & 0.17702e+04_r8,0.15507e+04_r8,0.13346e+04_r8,0.11179e+04_r8,0.90072e+03_r8, &
        & 0.74790e+03_r8,0.88384e+03_r8,0.10222e+04_r8,0.11616e+04_r8 /)
      kao(:, 3, 2,12) = (/ &
        & 0.17282e+04_r8,0.15159e+04_r8,0.13066e+04_r8,0.10967e+04_r8,0.88274e+03_r8, &
        & 0.74530e+03_r8,0.88241e+03_r8,0.10213e+04_r8,0.11606e+04_r8 /)
      kao(:, 4, 2,12) = (/ &
        & 0.16964e+04_r8,0.14887e+04_r8,0.12816e+04_r8,0.10711e+04_r8,0.86387e+03_r8, &
        & 0.74308e+03_r8,0.88064e+03_r8,0.10199e+04_r8,0.11593e+04_r8 /)
      kao(:, 5, 2,12) = (/ &
        & 0.16664e+04_r8,0.14634e+04_r8,0.12570e+04_r8,0.10541e+04_r8,0.84878e+03_r8, &
        & 0.74105e+03_r8,0.87802e+03_r8,0.10170e+04_r8,0.11559e+04_r8 /)
      kao(:, 1, 3,12) = (/ &
        & 0.16969e+04_r8,0.14893e+04_r8,0.12806e+04_r8,0.10686e+04_r8,0.86200e+03_r8, &
        & 0.74953e+03_r8,0.88586e+03_r8,0.10239e+04_r8,0.11637e+04_r8 /)
      kao(:, 2, 3,12) = (/ &
        & 0.16530e+04_r8,0.14535e+04_r8,0.12505e+04_r8,0.10502e+04_r8,0.84485e+03_r8, &
        & 0.74734e+03_r8,0.88380e+03_r8,0.10224e+04_r8,0.11623e+04_r8 /)
      kao(:, 3, 3,12) = (/ &
        & 0.16258e+04_r8,0.14316e+04_r8,0.12308e+04_r8,0.10274e+04_r8,0.82737e+03_r8, &
        & 0.74498e+03_r8,0.88220e+03_r8,0.10214e+04_r8,0.11612e+04_r8 /)
      kao(:, 4, 3,12) = (/ &
        & 0.15947e+04_r8,0.13987e+04_r8,0.12036e+04_r8,0.10100e+04_r8,0.81398e+03_r8, &
        & 0.74250e+03_r8,0.88073e+03_r8,0.10203e+04_r8,0.11601e+04_r8 /)
      kao(:, 5, 3,12) = (/ &
        & 0.15659e+04_r8,0.13745e+04_r8,0.11827e+04_r8,0.99357e+03_r8,0.79945e+03_r8, &
        & 0.74072e+03_r8,0.87844e+03_r8,0.10192e+04_r8,0.11574e+04_r8 /)
      kao(:, 1, 4,12) = (/ &
        & 0.15993e+04_r8,0.14029e+04_r8,0.12034e+04_r8,0.10105e+04_r8,0.81494e+03_r8, &
        & 0.74898e+03_r8,0.88604e+03_r8,0.10246e+04_r8,0.11648e+04_r8 /)
      kao(:, 2, 4,12) = (/ &
        & 0.15603e+04_r8,0.13717e+04_r8,0.11803e+04_r8,0.99158e+03_r8,0.79797e+03_r8, &
        & 0.74702e+03_r8,0.88413e+03_r8,0.10230e+04_r8,0.11631e+04_r8 /)
      kao(:, 3, 4,12) = (/ &
        & 0.15363e+04_r8,0.13460e+04_r8,0.11581e+04_r8,0.97158e+03_r8,0.78286e+03_r8, &
        & 0.74488e+03_r8,0.88249e+03_r8,0.10215e+04_r8,0.11618e+04_r8 /)
      kao(:, 4, 4,12) = (/ &
        & 0.15069e+04_r8,0.13248e+04_r8,0.11397e+04_r8,0.95515e+03_r8,0.77185e+03_r8, &
        & 0.74259e+03_r8,0.88086e+03_r8,0.10207e+04_r8,0.11608e+04_r8 /)
      kao(:, 5, 4,12) = (/ &
        & 0.14842e+04_r8,0.13030e+04_r8,0.11201e+04_r8,0.94205e+03_r8,0.75928e+03_r8, &
        & 0.74072e+03_r8,0.87912e+03_r8,0.10193e+04_r8,0.11593e+04_r8 /)
      kao(:, 1, 5,12) = (/ &
        & 0.15161e+04_r8,0.13293e+04_r8,0.11434e+04_r8,0.96071e+03_r8,0.77366e+03_r8, &
        & 0.74856e+03_r8,0.88634e+03_r8,0.10256e+04_r8,0.11660e+04_r8 /)
      kao(:, 2, 5,12) = (/ &
        & 0.14862e+04_r8,0.13039e+04_r8,0.11202e+04_r8,0.93927e+03_r8,0.75808e+03_r8, &
        & 0.74678e+03_r8,0.88432e+03_r8,0.10237e+04_r8,0.11641e+04_r8 /)
      kao(:, 3, 5,12) = (/ &
        & 0.14569e+04_r8,0.12812e+04_r8,0.11040e+04_r8,0.92477e+03_r8,0.74608e+03_r8, &
        & 0.74483e+03_r8,0.88267e+03_r8,0.10221e+04_r8,0.11626e+04_r8 /)
      kao(:, 4, 5,12) = (/ &
        & 0.14370e+04_r8,0.12601e+04_r8,0.10866e+04_r8,0.91322e+03_r8,0.73546e+03_r8, &
        & 0.74282e+03_r8,0.88106e+03_r8,0.10210e+04_r8,0.11614e+04_r8 /)
      kao(:, 5, 5,12) = (/ &
        & 0.14157e+04_r8,0.12432e+04_r8,0.10692e+04_r8,0.89766e+03_r8,0.72371e+03_r8, &
        & 0.74075e+03_r8,0.87977e+03_r8,0.10201e+04_r8,0.11604e+04_r8 /)
      kao(:, 1, 6,12) = (/ &
        & 0.14446e+04_r8,0.12668e+04_r8,0.10902e+04_r8,0.91458e+03_r8,0.73853e+03_r8, &
        & 0.74800e+03_r8,0.88683e+03_r8,0.10267e+04_r8,0.11674e+04_r8 /)
      kao(:, 2, 6,12) = (/ &
        & 0.14180e+04_r8,0.12442e+04_r8,0.10729e+04_r8,0.90054e+03_r8,0.72712e+03_r8, &
        & 0.74664e+03_r8,0.88490e+03_r8,0.10243e+04_r8,0.11653e+04_r8 /)
      kao(:, 3, 6,12) = (/ &
        & 0.13970e+04_r8,0.12338e+04_r8,0.10562e+04_r8,0.88644e+03_r8,0.71466e+03_r8, &
        & 0.74490e+03_r8,0.88299e+03_r8,0.10228e+04_r8,0.11635e+04_r8 /)
      kao(:, 4, 6,12) = (/ &
        & 0.13772e+04_r8,0.12092e+04_r8,0.10403e+04_r8,0.87191e+03_r8,0.70566e+03_r8, &
        & 0.74297e+03_r8,0.88145e+03_r8,0.10214e+04_r8,0.11622e+04_r8 /)
      kao(:, 5, 6,12) = (/ &
        & 0.13536e+04_r8,0.11933e+04_r8,0.10279e+04_r8,0.85985e+03_r8,0.69532e+03_r8, &
        & 0.74091e+03_r8,0.88002e+03_r8,0.10207e+04_r8,0.11611e+04_r8 /)
      kao(:, 1, 7,12) = (/ &
        & 0.13872e+04_r8,0.12173e+04_r8,0.10473e+04_r8,0.87779e+03_r8,0.70929e+03_r8, &
        & 0.74753e+03_r8,0.88739e+03_r8,0.10279e+04_r8,0.11686e+04_r8 /)
      kao(:, 2, 7,12) = (/ &
        & 0.13614e+04_r8,0.11960e+04_r8,0.10302e+04_r8,0.86342e+03_r8,0.69779e+03_r8, &
        & 0.74649e+03_r8,0.88535e+03_r8,0.10254e+04_r8,0.11666e+04_r8 /)
      kao(:, 3, 7,12) = (/ &
        & 0.13423e+04_r8,0.11779e+04_r8,0.10152e+04_r8,0.85120e+03_r8,0.68669e+03_r8, &
        & 0.74500e+03_r8,0.88364e+03_r8,0.10236e+04_r8,0.11646e+04_r8 /)
      kao(:, 4, 7,12) = (/ &
        & 0.13222e+04_r8,0.11614e+04_r8,0.10027e+04_r8,0.84138e+03_r8,0.67980e+03_r8, &
        & 0.74324e+03_r8,0.88194e+03_r8,0.10219e+04_r8,0.11628e+04_r8 /)
      kao(:, 5, 7,12) = (/ &
        & 0.13077e+04_r8,0.11487e+04_r8,0.98870e+03_r8,0.82923e+03_r8,0.67117e+03_r8, &
        & 0.74131e+03_r8,0.88052e+03_r8,0.10200e+04_r8,0.11617e+04_r8 /)
      kao(:, 1, 8,12) = (/ &
        & 0.13318e+04_r8,0.11751e+04_r8,0.10116e+04_r8,0.84760e+03_r8,0.68552e+03_r8, &
        & 0.74755e+03_r8,0.88764e+03_r8,0.10284e+04_r8,0.11697e+04_r8 /)
      kao(:, 2, 8,12) = (/ &
        & 0.13123e+04_r8,0.11533e+04_r8,0.99316e+03_r8,0.83364e+03_r8,0.67452e+03_r8, &
        & 0.74634e+03_r8,0.88623e+03_r8,0.10267e+04_r8,0.11679e+04_r8 /)
      kao(:, 3, 8,12) = (/ &
        & 0.12963e+04_r8,0.11395e+04_r8,0.98036e+03_r8,0.82206e+03_r8,0.66378e+03_r8, &
        & 0.74528e+03_r8,0.88422e+03_r8,0.10245e+04_r8,0.11657e+04_r8 /)
      kao(:, 4, 8,12) = (/ &
        & 0.12799e+04_r8,0.11235e+04_r8,0.96838e+03_r8,0.81175e+03_r8,0.65688e+03_r8, &
        & 0.74350e+03_r8,0.88249e+03_r8,0.10227e+04_r8,0.11639e+04_r8 /)
      kao(:, 5, 8,12) = (/ &
        & 0.12649e+04_r8,0.11128e+04_r8,0.95762e+03_r8,0.80323e+03_r8,0.64917e+03_r8, &
        & 0.74172e+03_r8,0.88089e+03_r8,0.10213e+04_r8,0.11624e+04_r8 /)
      kao(:, 1, 9,12) = (/ &
        & 0.12892e+04_r8,0.11353e+04_r8,0.97529e+03_r8,0.81997e+03_r8,0.66439e+03_r8, &
        & 0.74689e+03_r8,0.88774e+03_r8,0.10288e+04_r8,0.11703e+04_r8 /)
      kao(:, 2, 9,12) = (/ &
        & 0.12710e+04_r8,0.11179e+04_r8,0.96230e+03_r8,0.80757e+03_r8,0.65174e+03_r8, &
        & 0.74606e+03_r8,0.88671e+03_r8,0.10277e+04_r8,0.11691e+04_r8 /)
      kao(:, 3, 9,12) = (/ &
        & 0.12556e+04_r8,0.11026e+04_r8,0.95506e+03_r8,0.79904e+03_r8,0.64512e+03_r8, &
        & 0.74525e+03_r8,0.88489e+03_r8,0.10254e+04_r8,0.11669e+04_r8 /)
      kao(:, 4, 9,12) = (/ &
        & 0.12434e+04_r8,0.10930e+04_r8,0.94625e+03_r8,0.79326e+03_r8,0.63956e+03_r8, &
        & 0.74375e+03_r8,0.88308e+03_r8,0.10236e+04_r8,0.11649e+04_r8 /)
      kao(:, 5, 9,12) = (/ &
        & 0.12362e+04_r8,0.10807e+04_r8,0.93519e+03_r8,0.78318e+03_r8,0.63176e+03_r8, &
        & 0.74222e+03_r8,0.88144e+03_r8,0.10218e+04_r8,0.11632e+04_r8 /)
      kao(:, 1,10,12) = (/ &
        & 0.12560e+04_r8,0.11008e+04_r8,0.94819e+03_r8,0.79713e+03_r8,0.64289e+03_r8, &
        & 0.74662e+03_r8,0.88790e+03_r8,0.10293e+04_r8,0.11710e+04_r8 /)
      kao(:, 2,10,12) = (/ &
        & 0.12370e+04_r8,0.10868e+04_r8,0.93614e+03_r8,0.78750e+03_r8,0.63591e+03_r8, &
        & 0.74589e+03_r8,0.88689e+03_r8,0.10281e+04_r8,0.11697e+04_r8 /)
      kao(:, 3,10,12) = (/ &
        & 0.12228e+04_r8,0.10745e+04_r8,0.92565e+03_r8,0.77586e+03_r8,0.63013e+03_r8, &
        & 0.74525e+03_r8,0.88546e+03_r8,0.10265e+04_r8,0.11680e+04_r8 /)
      kao(:, 4,10,12) = (/ &
        & 0.12130e+04_r8,0.10629e+04_r8,0.91805e+03_r8,0.77218e+03_r8,0.62214e+03_r8, &
        & 0.74398e+03_r8,0.88360e+03_r8,0.10243e+04_r8,0.11659e+04_r8 /)
      kao(:, 5,10,12) = (/ &
        & 0.11990e+04_r8,0.10561e+04_r8,0.90990e+03_r8,0.76234e+03_r8,0.61782e+03_r8, &
        & 0.74238e+03_r8,0.88192e+03_r8,0.10225e+04_r8,0.11640e+04_r8 /)
      kao(:, 1,11,12) = (/ &
        & 0.12160e+04_r8,0.10660e+04_r8,0.91756e+03_r8,0.77092e+03_r8,0.62410e+03_r8, &
        & 0.74614e+03_r8,0.88758e+03_r8,0.10288e+04_r8,0.11712e+04_r8 /)
      kao(:, 2,11,12) = (/ &
        & 0.12001e+04_r8,0.10573e+04_r8,0.90897e+03_r8,0.76187e+03_r8,0.61778e+03_r8, &
        & 0.74563e+03_r8,0.88659e+03_r8,0.10280e+04_r8,0.11697e+04_r8 /)
      kao(:, 3,11,12) = (/ &
        & 0.11883e+04_r8,0.10436e+04_r8,0.89901e+03_r8,0.75711e+03_r8,0.61087e+03_r8, &
        & 0.74468e+03_r8,0.88519e+03_r8,0.10264e+04_r8,0.11680e+04_r8 /)
      kao(:, 4,11,12) = (/ &
        & 0.11791e+04_r8,0.10338e+04_r8,0.89462e+03_r8,0.74974e+03_r8,0.60740e+03_r8, &
        & 0.74372e+03_r8,0.88322e+03_r8,0.10242e+04_r8,0.11659e+04_r8 /)
      kao(:, 5,11,12) = (/ &
        & 0.11736e+04_r8,0.10284e+04_r8,0.88610e+03_r8,0.74386e+03_r8,0.60256e+03_r8, &
        & 0.74204e+03_r8,0.88156e+03_r8,0.10223e+04_r8,0.11640e+04_r8 /)
      kao(:, 1,12,12) = (/ &
        & 0.11783e+04_r8,0.10408e+04_r8,0.89462e+03_r8,0.75034e+03_r8,0.60838e+03_r8, &
        & 0.74575e+03_r8,0.88732e+03_r8,0.10288e+04_r8,0.11710e+04_r8 /)
      kao(:, 2,12,12) = (/ &
        & 0.11693e+04_r8,0.10333e+04_r8,0.88486e+03_r8,0.74467e+03_r8,0.60420e+03_r8, &
        & 0.74514e+03_r8,0.88635e+03_r8,0.10279e+04_r8,0.11697e+04_r8 /)
      kao(:, 3,12,12) = (/ &
        & 0.11597e+04_r8,0.10197e+04_r8,0.87845e+03_r8,0.73901e+03_r8,0.60371e+03_r8, &
        & 0.74440e+03_r8,0.88495e+03_r8,0.10263e+04_r8,0.11680e+04_r8 /)
      kao(:, 4,12,12) = (/ &
        & 0.11554e+04_r8,0.10154e+04_r8,0.87390e+03_r8,0.73209e+03_r8,0.60310e+03_r8, &
        & 0.74343e+03_r8,0.88312e+03_r8,0.10241e+04_r8,0.11659e+04_r8 /)
      kao(:, 5,12,12) = (/ &
        & 0.11463e+04_r8,0.10081e+04_r8,0.86768e+03_r8,0.73113e+03_r8,0.60226e+03_r8, &
        & 0.74178e+03_r8,0.88148e+03_r8,0.10222e+04_r8,0.11640e+04_r8 /)
      kao(:, 1,13,12) = (/ &
        & 0.11576e+04_r8,0.10172e+04_r8,0.87697e+03_r8,0.73496e+03_r8,0.60442e+03_r8, &
        & 0.74542e+03_r8,0.88710e+03_r8,0.10287e+04_r8,0.11710e+04_r8 /)
      kao(:, 2,13,12) = (/ &
        & 0.11489e+04_r8,0.10121e+04_r8,0.86787e+03_r8,0.73038e+03_r8,0.60369e+03_r8, &
        & 0.74483e+03_r8,0.88615e+03_r8,0.10278e+04_r8,0.11697e+04_r8 /)
      kao(:, 3,13,12) = (/ &
        & 0.11408e+04_r8,0.10003e+04_r8,0.86069e+03_r8,0.72468e+03_r8,0.60332e+03_r8, &
        & 0.74398e+03_r8,0.88477e+03_r8,0.10262e+04_r8,0.11679e+04_r8 /)
      kao(:, 4,13,12) = (/ &
        & 0.11353e+04_r8,0.99812e+03_r8,0.85805e+03_r8,0.72010e+03_r8,0.60276e+03_r8, &
        & 0.74301e+03_r8,0.88294e+03_r8,0.10240e+04_r8,0.11659e+04_r8 /)
      kao(:, 5,13,12) = (/ &
        & 0.11276e+04_r8,0.99093e+03_r8,0.85424e+03_r8,0.71851e+03_r8,0.60186e+03_r8, &
        & 0.74137e+03_r8,0.88131e+03_r8,0.10223e+04_r8,0.11640e+04_r8 /)
      kao(:, 1, 1,13) = (/ &
        & 0.19698e+04_r8,0.17183e+04_r8,0.14812e+04_r8,0.12476e+04_r8,0.10057e+04_r8, &
        & 0.76142e+03_r8,0.89076e+03_r8,0.10305e+04_r8,0.11701e+04_r8 /)
      kao(:, 2, 1,13) = (/ &
        & 0.19138e+04_r8,0.16790e+04_r8,0.14471e+04_r8,0.12079e+04_r8,0.97024e+03_r8, &
        & 0.74958e+03_r8,0.88854e+03_r8,0.10281e+04_r8,0.11676e+04_r8 /)
      kao(:, 3, 1,13) = (/ &
        & 0.18656e+04_r8,0.16362e+04_r8,0.14072e+04_r8,0.11764e+04_r8,0.95368e+03_r8, &
        & 0.74756e+03_r8,0.88578e+03_r8,0.10247e+04_r8,0.11642e+04_r8 /)
      kao(:, 4, 1,13) = (/ &
        & 0.18274e+04_r8,0.16076e+04_r8,0.13744e+04_r8,0.11522e+04_r8,0.93101e+03_r8, &
        & 0.74489e+03_r8,0.88368e+03_r8,0.10224e+04_r8,0.11624e+04_r8 /)
      kao(:, 5, 1,13) = (/ &
        & 0.18123e+04_r8,0.15711e+04_r8,0.13539e+04_r8,0.11391e+04_r8,0.91271e+03_r8, &
        & 0.74309e+03_r8,0.88194e+03_r8,0.10210e+04_r8,0.11601e+04_r8 /)
      kao(:, 1, 2,13) = (/ &
        & 0.18136e+04_r8,0.16074e+04_r8,0.13682e+04_r8,0.11455e+04_r8,0.92152e+03_r8, &
        & 0.75090e+03_r8,0.89044e+03_r8,0.10309e+04_r8,0.11711e+04_r8 /)
      kao(:, 2, 2,13) = (/ &
        & 0.17663e+04_r8,0.15639e+04_r8,0.13412e+04_r8,0.11338e+04_r8,0.90565e+03_r8, &
        & 0.74892e+03_r8,0.88842e+03_r8,0.10286e+04_r8,0.11690e+04_r8 /)
      kao(:, 3, 2,13) = (/ &
        & 0.17473e+04_r8,0.15168e+04_r8,0.13179e+04_r8,0.10933e+04_r8,0.88564e+03_r8, &
        & 0.74657e+03_r8,0.88587e+03_r8,0.10277e+04_r8,0.11659e+04_r8 /)
      kao(:, 4, 2,13) = (/ &
        & 0.16935e+04_r8,0.14940e+04_r8,0.12866e+04_r8,0.10771e+04_r8,0.86513e+03_r8, &
        & 0.74388e+03_r8,0.88292e+03_r8,0.10226e+04_r8,0.11621e+04_r8 /)
      kao(:, 5, 2,13) = (/ &
        & 0.16796e+04_r8,0.14587e+04_r8,0.12610e+04_r8,0.10625e+04_r8,0.85051e+03_r8, &
        & 0.74222e+03_r8,0.88187e+03_r8,0.10215e+04_r8,0.11614e+04_r8 /)
      kao(:, 1, 3,13) = (/ &
        & 0.16915e+04_r8,0.14853e+04_r8,0.12759e+04_r8,0.10742e+04_r8,0.87078e+03_r8, &
        & 0.75040e+03_r8,0.89056e+03_r8,0.10314e+04_r8,0.11723e+04_r8 /)
      kao(:, 2, 3,13) = (/ &
        & 0.16685e+04_r8,0.14695e+04_r8,0.12569e+04_r8,0.10522e+04_r8,0.84369e+03_r8, &
        & 0.74849e+03_r8,0.88875e+03_r8,0.10295e+04_r8,0.11702e+04_r8 /)
      kao(:, 3, 3,13) = (/ &
        & 0.16315e+04_r8,0.14234e+04_r8,0.12207e+04_r8,0.10278e+04_r8,0.83542e+03_r8, &
        & 0.74665e+03_r8,0.88665e+03_r8,0.10272e+04_r8,0.11677e+04_r8 /)
      kao(:, 4, 3,13) = (/ &
        & 0.15936e+04_r8,0.13973e+04_r8,0.11983e+04_r8,0.10068e+04_r8,0.81253e+03_r8, &
        & 0.74392e+03_r8,0.88383e+03_r8,0.10241e+04_r8,0.11643e+04_r8 /)
      kao(:, 5, 3,13) = (/ &
        & 0.15704e+04_r8,0.13749e+04_r8,0.11794e+04_r8,0.99081e+03_r8,0.79887e+03_r8, &
        & 0.74214e+03_r8,0.88216e+03_r8,0.10204e+04_r8,0.11625e+04_r8 /)
      kao(:, 1, 4,13) = (/ &
        & 0.16005e+04_r8,0.14146e+04_r8,0.12141e+04_r8,0.10096e+04_r8,0.81830e+03_r8, &
        & 0.74981e+03_r8,0.89073e+03_r8,0.10323e+04_r8,0.11736e+04_r8 /)
      kao(:, 2, 4,13) = (/ &
        & 0.15697e+04_r8,0.13709e+04_r8,0.11792e+04_r8,0.98706e+03_r8,0.80274e+03_r8, &
        & 0.74843e+03_r8,0.88917e+03_r8,0.10304e+04_r8,0.11716e+04_r8 /)
      kao(:, 3, 4,13) = (/ &
        & 0.15342e+04_r8,0.13528e+04_r8,0.11633e+04_r8,0.97494e+03_r8,0.78298e+03_r8, &
        & 0.74655e+03_r8,0.88714e+03_r8,0.10283e+04_r8,0.11694e+04_r8 /)
      kao(:, 4, 4,13) = (/ &
        & 0.15079e+04_r8,0.13273e+04_r8,0.11368e+04_r8,0.95326e+03_r8,0.76898e+03_r8, &
        & 0.74477e+03_r8,0.88522e+03_r8,0.10258e+04_r8,0.11666e+04_r8 /)
      kao(:, 5, 4,13) = (/ &
        & 0.14904e+04_r8,0.13050e+04_r8,0.11274e+04_r8,0.94133e+03_r8,0.75918e+03_r8, &
        & 0.74185e+03_r8,0.88236e+03_r8,0.10229e+04_r8,0.11634e+04_r8 /)
      kao(:, 1, 5,13) = (/ &
        & 0.15223e+04_r8,0.13292e+04_r8,0.11458e+04_r8,0.96632e+03_r8,0.77253e+03_r8, &
        & 0.74931e+03_r8,0.89080e+03_r8,0.10327e+04_r8,0.11744e+04_r8 /)
      kao(:, 2, 5,13) = (/ &
        & 0.14887e+04_r8,0.13100e+04_r8,0.11308e+04_r8,0.95564e+03_r8,0.76318e+03_r8, &
        & 0.74814e+03_r8,0.88953e+03_r8,0.10311e+04_r8,0.11728e+04_r8 /)
      kao(:, 3, 5,13) = (/ &
        & 0.14666e+04_r8,0.12805e+04_r8,0.10990e+04_r8,0.92585e+03_r8,0.74527e+03_r8, &
        & 0.74662e+03_r8,0.88788e+03_r8,0.10293e+04_r8,0.11708e+04_r8 /)
      kao(:, 4, 5,13) = (/ &
        & 0.14380e+04_r8,0.12615e+04_r8,0.10805e+04_r8,0.91192e+03_r8,0.73306e+03_r8, &
        & 0.74471e+03_r8,0.88594e+03_r8,0.10272e+04_r8,0.11684e+04_r8 /)
      kao(:, 5, 5,13) = (/ &
        & 0.14117e+04_r8,0.12389e+04_r8,0.10707e+04_r8,0.89863e+03_r8,0.72872e+03_r8, &
        & 0.74254e+03_r8,0.88356e+03_r8,0.10243e+04_r8,0.11652e+04_r8 /)
      kao(:, 1, 6,13) = (/ &
        & 0.14428e+04_r8,0.12661e+04_r8,0.10990e+04_r8,0.91605e+03_r8,0.74645e+03_r8, &
        & 0.74914e+03_r8,0.89068e+03_r8,0.10327e+04_r8,0.11747e+04_r8 /)
      kao(:, 2, 6,13) = (/ &
        & 0.14277e+04_r8,0.12454e+04_r8,0.10670e+04_r8,0.90364e+03_r8,0.72758e+03_r8, &
        & 0.74802e+03_r8,0.88983e+03_r8,0.10318e+04_r8,0.11738e+04_r8 /)
      kao(:, 3, 6,13) = (/ &
        & 0.14072e+04_r8,0.12244e+04_r8,0.10539e+04_r8,0.88576e+03_r8,0.71342e+03_r8, &
        & 0.74674e+03_r8,0.88844e+03_r8,0.10303e+04_r8,0.11723e+04_r8 /)
      kao(:, 4, 6,13) = (/ &
        & 0.13764e+04_r8,0.12101e+04_r8,0.10371e+04_r8,0.87173e+03_r8,0.70565e+03_r8, &
        & 0.74519e+03_r8,0.88672e+03_r8,0.10284e+04_r8,0.11700e+04_r8 /)
      kao(:, 5, 6,13) = (/ &
        & 0.13559e+04_r8,0.11928e+04_r8,0.10275e+04_r8,0.87202e+03_r8,0.69916e+03_r8, &
        & 0.74337e+03_r8,0.88468e+03_r8,0.10257e+04_r8,0.11677e+04_r8 /)
      kao(:, 1, 7,13) = (/ &
        & 0.13816e+04_r8,0.12181e+04_r8,0.10498e+04_r8,0.87727e+03_r8,0.70862e+03_r8, &
        & 0.74879e+03_r8,0.89032e+03_r8,0.10324e+04_r8,0.11748e+04_r8 /)
      kao(:, 2, 7,13) = (/ &
        & 0.13746e+04_r8,0.12007e+04_r8,0.10368e+04_r8,0.86700e+03_r8,0.69742e+03_r8, &
        & 0.74791e+03_r8,0.88998e+03_r8,0.10322e+04_r8,0.11745e+04_r8 /)
      kao(:, 3, 7,13) = (/ &
        & 0.13471e+04_r8,0.11822e+04_r8,0.10118e+04_r8,0.85187e+03_r8,0.69076e+03_r8, &
        & 0.74684e+03_r8,0.88891e+03_r8,0.10311e+04_r8,0.11732e+04_r8 /)
      kao(:, 4, 7,13) = (/ &
        & 0.13306e+04_r8,0.11625e+04_r8,0.10055e+04_r8,0.83687e+03_r8,0.67946e+03_r8, &
        & 0.74564e+03_r8,0.88741e+03_r8,0.10294e+04_r8,0.11714e+04_r8 /)
      kao(:, 5, 7,13) = (/ &
        & 0.13072e+04_r8,0.11462e+04_r8,0.98997e+03_r8,0.82975e+03_r8,0.67148e+03_r8, &
        & 0.74390e+03_r8,0.88544e+03_r8,0.10275e+04_r8,0.11691e+04_r8 /)
      kao(:, 1, 8,13) = (/ &
        & 0.13342e+04_r8,0.11738e+04_r8,0.10072e+04_r8,0.84777e+03_r8,0.68336e+03_r8, &
        & 0.74810e+03_r8,0.89032e+03_r8,0.10328e+04_r8,0.11753e+04_r8 /)
      kao(:, 2, 8,13) = (/ &
        & 0.13170e+04_r8,0.11565e+04_r8,0.99551e+03_r8,0.83812e+03_r8,0.67873e+03_r8, &
        & 0.74767e+03_r8,0.88984e+03_r8,0.10325e+04_r8,0.11747e+04_r8 /)
      kao(:, 3, 8,13) = (/ &
        & 0.12961e+04_r8,0.11348e+04_r8,0.98531e+03_r8,0.82142e+03_r8,0.66767e+03_r8, &
        & 0.74660e+03_r8,0.88923e+03_r8,0.10317e+04_r8,0.11741e+04_r8 /)
      kao(:, 4, 8,13) = (/ &
        & 0.12863e+04_r8,0.11324e+04_r8,0.96704e+03_r8,0.81553e+03_r8,0.65703e+03_r8, &
        & 0.74590e+03_r8,0.88815e+03_r8,0.10305e+04_r8,0.11725e+04_r8 /)
      kao(:, 5, 8,13) = (/ &
        & 0.12689e+04_r8,0.11113e+04_r8,0.96142e+03_r8,0.81188e+03_r8,0.65150e+03_r8, &
        & 0.74435e+03_r8,0.88637e+03_r8,0.10284e+04_r8,0.11705e+04_r8 /)
      kao(:, 1, 9,13) = (/ &
        & 0.12929e+04_r8,0.11420e+04_r8,0.97941e+03_r8,0.82358e+03_r8,0.66259e+03_r8, &
        & 0.74862e+03_r8,0.89046e+03_r8,0.10332e+04_r8,0.11761e+04_r8 /)
      kao(:, 2, 9,13) = (/ &
        & 0.12739e+04_r8,0.11222e+04_r8,0.96918e+03_r8,0.81141e+03_r8,0.65436e+03_r8, &
        & 0.74747e+03_r8,0.88962e+03_r8,0.10323e+04_r8,0.11749e+04_r8 /)
      kao(:, 3, 9,13) = (/ &
        & 0.12674e+04_r8,0.11070e+04_r8,0.94554e+03_r8,0.79811e+03_r8,0.64989e+03_r8, &
        & 0.74671e+03_r8,0.88937e+03_r8,0.10320e+04_r8,0.11746e+04_r8 /)
      kao(:, 4, 9,13) = (/ &
        & 0.12536e+04_r8,0.10974e+04_r8,0.93180e+03_r8,0.78881e+03_r8,0.64048e+03_r8, &
        & 0.74596e+03_r8,0.88846e+03_r8,0.10310e+04_r8,0.11735e+04_r8 /)
      kao(:, 5, 9,13) = (/ &
        & 0.12304e+04_r8,0.10931e+04_r8,0.92897e+03_r8,0.78158e+03_r8,0.63657e+03_r8, &
        & 0.74461e+03_r8,0.88706e+03_r8,0.10294e+04_r8,0.11717e+04_r8 /)
      kao(:, 1,10,13) = (/ &
        & 0.12516e+04_r8,0.11039e+04_r8,0.96641e+03_r8,0.80204e+03_r8,0.64728e+03_r8, &
        & 0.74871e+03_r8,0.89043e+03_r8,0.10331e+04_r8,0.11761e+04_r8 /)
      kao(:, 2,10,13) = (/ &
        & 0.12445e+04_r8,0.10951e+04_r8,0.94205e+03_r8,0.78296e+03_r8,0.63684e+03_r8, &
        & 0.74738e+03_r8,0.88974e+03_r8,0.10326e+04_r8,0.11754e+04_r8 /)
      kao(:, 3,10,13) = (/ &
        & 0.12212e+04_r8,0.10830e+04_r8,0.92907e+03_r8,0.78344e+03_r8,0.62583e+03_r8, &
        & 0.74649e+03_r8,0.88924e+03_r8,0.10320e+04_r8,0.11747e+04_r8 /)
      kao(:, 4,10,13) = (/ &
        & 0.12116e+04_r8,0.10675e+04_r8,0.91424e+03_r8,0.76668e+03_r8,0.62374e+03_r8, &
        & 0.74589e+03_r8,0.88889e+03_r8,0.10314e+04_r8,0.11741e+04_r8 /)
      kao(:, 5,10,13) = (/ &
        & 0.12052e+04_r8,0.10532e+04_r8,0.90488e+03_r8,0.76246e+03_r8,0.61399e+03_r8, &
        & 0.74500e+03_r8,0.88754e+03_r8,0.10301e+04_r8,0.11727e+04_r8 /)
      kao(:, 1,11,13) = (/ &
        & 0.12119e+04_r8,0.10670e+04_r8,0.92549e+03_r8,0.77292e+03_r8,0.62469e+03_r8, &
        & 0.74822e+03_r8,0.89015e+03_r8,0.10331e+04_r8,0.11759e+04_r8 /)
      kao(:, 2,11,13) = (/ &
        & 0.12040e+04_r8,0.10529e+04_r8,0.90947e+03_r8,0.76631e+03_r8,0.61756e+03_r8, &
        & 0.74680e+03_r8,0.88950e+03_r8,0.10325e+04_r8,0.11754e+04_r8 /)
      kao(:, 3,11,13) = (/ &
        & 0.11932e+04_r8,0.10470e+04_r8,0.90374e+03_r8,0.75316e+03_r8,0.61137e+03_r8, &
        & 0.74625e+03_r8,0.88901e+03_r8,0.10319e+04_r8,0.11747e+04_r8 /)
      kao(:, 4,11,13) = (/ &
        & 0.11901e+04_r8,0.10395e+04_r8,0.89205e+03_r8,0.75483e+03_r8,0.60707e+03_r8, &
        & 0.74529e+03_r8,0.88868e+03_r8,0.10313e+04_r8,0.11742e+04_r8 /)
      kao(:, 5,11,13) = (/ &
        & 0.11740e+04_r8,0.10262e+04_r8,0.88782e+03_r8,0.74555e+03_r8,0.60321e+03_r8, &
        & 0.74456e+03_r8,0.88735e+03_r8,0.10302e+04_r8,0.11727e+04_r8 /)
      kao(:, 1,12,13) = (/ &
        & 0.11952e+04_r8,0.10387e+04_r8,0.90464e+03_r8,0.75031e+03_r8,0.60579e+03_r8, &
        & 0.74809e+03_r8,0.88993e+03_r8,0.10330e+04_r8,0.11761e+04_r8 /)
      kao(:, 2,12,13) = (/ &
        & 0.11767e+04_r8,0.10280e+04_r8,0.89305e+03_r8,0.74295e+03_r8,0.60520e+03_r8, &
        & 0.74658e+03_r8,0.88930e+03_r8,0.10324e+04_r8,0.11754e+04_r8 /)
      kao(:, 3,12,13) = (/ &
        & 0.11638e+04_r8,0.10252e+04_r8,0.88200e+03_r8,0.74209e+03_r8,0.60448e+03_r8, &
        & 0.74580e+03_r8,0.88883e+03_r8,0.10318e+04_r8,0.11747e+04_r8 /)
      kao(:, 4,12,13) = (/ &
        & 0.11608e+04_r8,0.10182e+04_r8,0.87717e+03_r8,0.73339e+03_r8,0.60384e+03_r8, &
        & 0.74474e+03_r8,0.88834e+03_r8,0.10314e+04_r8,0.11742e+04_r8 /)
      kao(:, 5,12,13) = (/ &
        & 0.11455e+04_r8,0.10085e+04_r8,0.86868e+03_r8,0.72782e+03_r8,0.60261e+03_r8, &
        & 0.74417e+03_r8,0.88752e+03_r8,0.10299e+04_r8,0.11727e+04_r8 /)
      kao(:, 1,13,13) = (/ &
        & 0.11538e+04_r8,0.10104e+04_r8,0.87836e+03_r8,0.74181e+03_r8,0.60545e+03_r8, &
        & 0.74747e+03_r8,0.88975e+03_r8,0.10329e+04_r8,0.11763e+04_r8 /)
      kao(:, 2,13,13) = (/ &
        & 0.11412e+04_r8,0.10013e+04_r8,0.88484e+03_r8,0.73153e+03_r8,0.60489e+03_r8, &
        & 0.74629e+03_r8,0.88914e+03_r8,0.10323e+04_r8,0.11754e+04_r8 /)
      kao(:, 3,13,13) = (/ &
        & 0.11370e+04_r8,0.10022e+04_r8,0.86246e+03_r8,0.73215e+03_r8,0.60419e+03_r8, &
        & 0.74569e+03_r8,0.88867e+03_r8,0.10317e+04_r8,0.11747e+04_r8 /)
      kao(:, 4,13,13) = (/ &
        & 0.11288e+04_r8,0.99109e+03_r8,0.86549e+03_r8,0.72280e+03_r8,0.60356e+03_r8, &
        & 0.74480e+03_r8,0.88820e+03_r8,0.10312e+04_r8,0.11742e+04_r8 /)
      kao(:, 5,13,13) = (/ &
        & 0.11445e+04_r8,0.99099e+03_r8,0.85129e+03_r8,0.71952e+03_r8,0.60234e+03_r8, &
        & 0.74410e+03_r8,0.88705e+03_r8,0.10299e+04_r8,0.11727e+04_r8 /)
      kao(:, 1, 1,14) = (/ &
        & 0.20185e+04_r8,0.18044e+04_r8,0.14758e+04_r8,0.13047e+04_r8,0.10029e+04_r8, &
        & 0.77460e+03_r8,0.89226e+03_r8,0.10322e+04_r8,0.11721e+04_r8 /)
      kao(:, 2, 1,14) = (/ &
        & 0.19173e+04_r8,0.17154e+04_r8,0.14467e+04_r8,0.12101e+04_r8,0.99594e+03_r8, &
        & 0.75026e+03_r8,0.88974e+03_r8,0.10295e+04_r8,0.11713e+04_r8 /)
      kao(:, 3, 1,14) = (/ &
        & 0.19468e+04_r8,0.16851e+04_r8,0.14136e+04_r8,0.12474e+04_r8,0.94959e+03_r8, &
        & 0.74773e+03_r8,0.88696e+03_r8,0.10271e+04_r8,0.11663e+04_r8 /)
      kao(:, 4, 1,14) = (/ &
        & 0.18423e+04_r8,0.16214e+04_r8,0.13991e+04_r8,0.11633e+04_r8,0.94698e+03_r8, &
        & 0.74507e+03_r8,0.88457e+03_r8,0.10239e+04_r8,0.11632e+04_r8 /)
      kao(:, 5, 1,14) = (/ &
        & 0.17538e+04_r8,0.16376e+04_r8,0.13645e+04_r8,0.11303e+04_r8,0.98877e+03_r8, &
        & 0.74430e+03_r8,0.88372e+03_r8,0.10232e+04_r8,0.11626e+04_r8 /)
      kao(:, 1, 2,14) = (/ &
        & 0.18551e+04_r8,0.16163e+04_r8,0.13640e+04_r8,0.12440e+04_r8,0.97095e+03_r8, &
        & 0.75153e+03_r8,0.89202e+03_r8,0.10323e+04_r8,0.11731e+04_r8 /)
      kao(:, 2, 2,14) = (/ &
        & 0.18136e+04_r8,0.16209e+04_r8,0.13887e+04_r8,0.11127e+04_r8,0.90845e+03_r8, &
        & 0.74936e+03_r8,0.88974e+03_r8,0.10301e+04_r8,0.11702e+04_r8 /)
      kao(:, 3, 2,14) = (/ &
        & 0.17918e+04_r8,0.15931e+04_r8,0.13282e+04_r8,0.11266e+04_r8,0.93052e+03_r8, &
        & 0.74732e+03_r8,0.88725e+03_r8,0.10243e+04_r8,0.11672e+04_r8 /)
      kao(:, 4, 2,14) = (/ &
        & 0.17507e+04_r8,0.14791e+04_r8,0.12865e+04_r8,0.10818e+04_r8,0.87901e+03_r8, &
        & 0.74478e+03_r8,0.88467e+03_r8,0.10246e+04_r8,0.11645e+04_r8 /)
      kao(:, 5, 2,14) = (/ &
        & 0.16872e+04_r8,0.14818e+04_r8,0.12871e+04_r8,0.10513e+04_r8,0.88744e+03_r8, &
        & 0.74325e+03_r8,0.88337e+03_r8,0.10230e+04_r8,0.11625e+04_r8 /)
      kao(:, 1, 3,14) = (/ &
        & 0.16919e+04_r8,0.15533e+04_r8,0.13337e+04_r8,0.10831e+04_r8,0.86308e+03_r8, &
        & 0.75085e+03_r8,0.89217e+03_r8,0.10333e+04_r8,0.11744e+04_r8 /)
      kao(:, 2, 3,14) = (/ &
        & 0.17034e+04_r8,0.15495e+04_r8,0.12643e+04_r8,0.11407e+04_r8,0.84365e+03_r8, &
        & 0.74929e+03_r8,0.89025e+03_r8,0.10312e+04_r8,0.11722e+04_r8 /)
      kao(:, 3, 3,14) = (/ &
        & 0.16844e+04_r8,0.14282e+04_r8,0.12585e+04_r8,0.10790e+04_r8,0.84114e+03_r8, &
        & 0.74691e+03_r8,0.88785e+03_r8,0.10286e+04_r8,0.11700e+04_r8 /)
      kao(:, 4, 3,14) = (/ &
        & 0.16791e+04_r8,0.14180e+04_r8,0.12209e+04_r8,0.10441e+04_r8,0.85899e+03_r8, &
        & 0.74519e+03_r8,0.88544e+03_r8,0.10259e+04_r8,0.11667e+04_r8 /)
      kao(:, 5, 3,14) = (/ &
        & 0.16063e+04_r8,0.13774e+04_r8,0.12181e+04_r8,0.10006e+04_r8,0.82020e+03_r8, &
        & 0.74245e+03_r8,0.88287e+03_r8,0.10231e+04_r8,0.11633e+04_r8 /)
      kao(:, 1, 4,14) = (/ &
        & 0.15960e+04_r8,0.13846e+04_r8,0.12078e+04_r8,0.10284e+04_r8,0.81079e+03_r8, &
        & 0.75078e+03_r8,0.89233e+03_r8,0.10336e+04_r8,0.11751e+04_r8 /)
      kao(:, 2, 4,14) = (/ &
        & 0.16237e+04_r8,0.13919e+04_r8,0.11906e+04_r8,0.10115e+04_r8,0.83009e+03_r8, &
        & 0.74909e+03_r8,0.89076e+03_r8,0.10322e+04_r8,0.11737e+04_r8 /)
      kao(:, 3, 4,14) = (/ &
        & 0.16136e+04_r8,0.13698e+04_r8,0.12046e+04_r8,0.98839e+03_r8,0.80997e+03_r8, &
        & 0.74745e+03_r8,0.88871e+03_r8,0.10300e+04_r8,0.11712e+04_r8 /)
      kao(:, 4, 4,14) = (/ &
        & 0.15739e+04_r8,0.13753e+04_r8,0.11394e+04_r8,0.97871e+03_r8,0.77029e+03_r8, &
        & 0.74770e+03_r8,0.88627e+03_r8,0.10279e+04_r8,0.11682e+04_r8 /)
      kao(:, 5, 4,14) = (/ &
        & 0.14863e+04_r8,0.13334e+04_r8,0.11445e+04_r8,0.95775e+03_r8,0.78998e+03_r8, &
        & 0.74317e+03_r8,0.88387e+03_r8,0.10246e+04_r8,0.11653e+04_r8 /)
      kao(:, 1, 5,14) = (/ &
        & 0.15101e+04_r8,0.14006e+04_r8,0.11513e+04_r8,0.96783e+03_r8,0.79581e+03_r8, &
        & 0.75045e+03_r8,0.89239e+03_r8,0.10340e+04_r8,0.11759e+04_r8 /)
      kao(:, 2, 5,14) = (/ &
        & 0.15461e+04_r8,0.13003e+04_r8,0.11685e+04_r8,0.92112e+03_r8,0.77517e+03_r8, &
        & 0.74927e+03_r8,0.89114e+03_r8,0.10330e+04_r8,0.11749e+04_r8 /)
      kao(:, 3, 5,14) = (/ &
        & 0.14676e+04_r8,0.12966e+04_r8,0.11042e+04_r8,0.93875e+03_r8,0.79645e+03_r8, &
        & 0.74772e+03_r8,0.88943e+03_r8,0.10311e+04_r8,0.11729e+04_r8 /)
      kao(:, 4, 5,14) = (/ &
        & 0.14571e+04_r8,0.12955e+04_r8,0.11734e+04_r8,0.89731e+03_r8,0.76986e+03_r8, &
        & 0.74578e+03_r8,0.88723e+03_r8,0.10287e+04_r8,0.11702e+04_r8 /)
      kao(:, 5, 5,14) = (/ &
        & 0.14311e+04_r8,0.13054e+04_r8,0.10738e+04_r8,0.10079e+04_r8,0.72704e+03_r8, &
        & 0.74437e+03_r8,0.88461e+03_r8,0.10260e+04_r8,0.11675e+04_r8 /)
      kao(:, 1, 6,14) = (/ &
        & 0.14715e+04_r8,0.12798e+04_r8,0.11182e+04_r8,0.92160e+03_r8,0.75379e+03_r8, &
        & 0.75023e+03_r8,0.89251e+03_r8,0.10348e+04_r8,0.11771e+04_r8 /)
      kao(:, 2, 6,14) = (/ &
        & 0.14479e+04_r8,0.12414e+04_r8,0.11222e+04_r8,0.91289e+03_r8,0.75013e+03_r8, &
        & 0.74921e+03_r8,0.89141e+03_r8,0.10336e+04_r8,0.11758e+04_r8 /)
      kao(:, 3, 6,14) = (/ &
        & 0.14270e+04_r8,0.12651e+04_r8,0.10793e+04_r8,0.91215e+03_r8,0.74649e+03_r8, &
        & 0.74796e+03_r8,0.89005e+03_r8,0.10321e+04_r8,0.11739e+04_r8 /)
      kao(:, 4, 6,14) = (/ &
        & 0.14058e+04_r8,0.12702e+04_r8,0.11005e+04_r8,0.93809e+03_r8,0.69854e+03_r8, &
        & 0.74632e+03_r8,0.88820e+03_r8,0.10301e+04_r8,0.11720e+04_r8 /)
      kao(:, 5, 6,14) = (/ &
        & 0.14048e+04_r8,0.12100e+04_r8,0.10413e+04_r8,0.84934e+03_r8,0.69794e+03_r8, &
        & 0.74429e+03_r8,0.88588e+03_r8,0.10284e+04_r8,0.11701e+04_r8 /)
      kao(:, 1, 7,14) = (/ &
        & 0.14325e+04_r8,0.12413e+04_r8,0.10595e+04_r8,0.88906e+03_r8,0.71717e+03_r8, &
        & 0.75037e+03_r8,0.89273e+03_r8,0.10353e+04_r8,0.11779e+04_r8 /)
      kao(:, 2, 7,14) = (/ &
        & 0.13620e+04_r8,0.12089e+04_r8,0.10598e+04_r8,0.89550e+03_r8,0.73134e+03_r8, &
        & 0.74911e+03_r8,0.89161e+03_r8,0.10341e+04_r8,0.11766e+04_r8 /)
      kao(:, 3, 7,14) = (/ &
        & 0.13346e+04_r8,0.12111e+04_r8,0.10262e+04_r8,0.84775e+03_r8,0.68161e+03_r8, &
        & 0.74811e+03_r8,0.89050e+03_r8,0.10329e+04_r8,0.11753e+04_r8 /)
      kao(:, 4, 7,14) = (/ &
        & 0.13132e+04_r8,0.11998e+04_r8,0.99757e+03_r8,0.86083e+03_r8,0.70251e+03_r8, &
        & 0.74653e+03_r8,0.88899e+03_r8,0.10312e+04_r8,0.11735e+04_r8 /)
      kao(:, 5, 7,14) = (/ &
        & 0.13232e+04_r8,0.11634e+04_r8,0.10230e+04_r8,0.84353e+03_r8,0.68339e+03_r8, &
        & 0.74500e+03_r8,0.88698e+03_r8,0.10287e+04_r8,0.11709e+04_r8 /)
      kao(:, 1, 8,14) = (/ &
        & 0.13366e+04_r8,0.11630e+04_r8,0.10188e+04_r8,0.86405e+03_r8,0.71800e+03_r8, &
        & 0.75008e+03_r8,0.89285e+03_r8,0.10357e+04_r8,0.11785e+04_r8 /)
      kao(:, 2, 8,14) = (/ &
        & 0.13647e+04_r8,0.11518e+04_r8,0.10110e+04_r8,0.84719e+03_r8,0.67819e+03_r8, &
        & 0.74911e+03_r8,0.89187e+03_r8,0.10343e+04_r8,0.11777e+04_r8 /)
      kao(:, 3, 8,14) = (/ &
        & 0.13128e+04_r8,0.11472e+04_r8,0.99038e+03_r8,0.82656e+03_r8,0.66483e+03_r8, &
        & 0.74815e+03_r8,0.89080e+03_r8,0.10335e+04_r8,0.11761e+04_r8 /)
      kao(:, 4, 8,14) = (/ &
        & 0.12817e+04_r8,0.11127e+04_r8,0.10092e+04_r8,0.82047e+03_r8,0.65442e+03_r8, &
        & 0.74685e+03_r8,0.88933e+03_r8,0.10318e+04_r8,0.11746e+04_r8 /)
      kao(:, 5, 8,14) = (/ &
        & 0.13162e+04_r8,0.11356e+04_r8,0.98305e+03_r8,0.84668e+03_r8,0.66544e+03_r8, &
        & 0.74558e+03_r8,0.88790e+03_r8,0.10302e+04_r8,0.11725e+04_r8 /)
      kao(:, 1, 9,14) = (/ &
        & 0.13174e+04_r8,0.11399e+04_r8,0.97696e+03_r8,0.84117e+03_r8,0.66145e+03_r8, &
        & 0.75011e+03_r8,0.89307e+03_r8,0.10362e+04_r8,0.11789e+04_r8 /)
      kao(:, 2, 9,14) = (/ &
        & 0.13196e+04_r8,0.11310e+04_r8,0.99094e+03_r8,0.80674e+03_r8,0.67265e+03_r8, &
        & 0.74915e+03_r8,0.89213e+03_r8,0.10351e+04_r8,0.11781e+04_r8 /)
      kao(:, 3, 9,14) = (/ &
        & 0.12950e+04_r8,0.10983e+04_r8,0.10229e+04_r8,0.86051e+03_r8,0.66007e+03_r8, &
        & 0.74819e+03_r8,0.89107e+03_r8,0.10339e+04_r8,0.11768e+04_r8 /)
      kao(:, 4, 9,14) = (/ &
        & 0.12605e+04_r8,0.10785e+04_r8,0.10061e+04_r8,0.79531e+03_r8,0.63414e+03_r8, &
        & 0.74728e+03_r8,0.89004e+03_r8,0.10328e+04_r8,0.11756e+04_r8 /)
      kao(:, 5, 9,14) = (/ &
        & 0.12553e+04_r8,0.10628e+04_r8,0.94908e+03_r8,0.82074e+03_r8,0.64983e+03_r8, &
        & 0.74606e+03_r8,0.88866e+03_r8,0.10313e+04_r8,0.11739e+04_r8 /)
      kao(:, 1,10,14) = (/ &
        & 0.13413e+04_r8,0.11632e+04_r8,0.10048e+04_r8,0.80476e+03_r8,0.65189e+03_r8, &
        & 0.75022e+03_r8,0.89354e+03_r8,0.10369e+04_r8,0.11806e+04_r8 /)
      kao(:, 2,10,14) = (/ &
        & 0.12838e+04_r8,0.11017e+04_r8,0.10173e+04_r8,0.85213e+03_r8,0.64367e+03_r8, &
        & 0.74909e+03_r8,0.89223e+03_r8,0.10354e+04_r8,0.11786e+04_r8 /)
      kao(:, 3,10,14) = (/ &
        & 0.12657e+04_r8,0.11229e+04_r8,0.92134e+03_r8,0.80214e+03_r8,0.64195e+03_r8, &
        & 0.74870e+03_r8,0.89159e+03_r8,0.10344e+04_r8,0.11778e+04_r8 /)
      kao(:, 4,10,14) = (/ &
        & 0.12310e+04_r8,0.10594e+04_r8,0.92792e+03_r8,0.78251e+03_r8,0.62401e+03_r8, &
        & 0.74734e+03_r8,0.89003e+03_r8,0.10332e+04_r8,0.11762e+04_r8 /)
      kao(:, 5,10,14) = (/ &
        & 0.12088e+04_r8,0.10663e+04_r8,0.92275e+03_r8,0.77707e+03_r8,0.64354e+03_r8, &
        & 0.74634e+03_r8,0.88914e+03_r8,0.10320e+04_r8,0.11748e+04_r8 /)
      kao(:, 1,11,14) = (/ &
        & 0.12205e+04_r8,0.10982e+04_r8,0.93349e+03_r8,0.79899e+03_r8,0.64961e+03_r8, &
        & 0.74981e+03_r8,0.89329e+03_r8,0.10368e+04_r8,0.11803e+04_r8 /)
      kao(:, 2,11,14) = (/ &
        & 0.12266e+04_r8,0.10977e+04_r8,0.90836e+03_r8,0.76723e+03_r8,0.61851e+03_r8, &
        & 0.74871e+03_r8,0.89199e+03_r8,0.10353e+04_r8,0.11786e+04_r8 /)
      kao(:, 3,11,14) = (/ &
        & 0.11876e+04_r8,0.10750e+04_r8,0.92258e+03_r8,0.76849e+03_r8,0.61349e+03_r8, &
        & 0.74902e+03_r8,0.89163e+03_r8,0.10343e+04_r8,0.11775e+04_r8 /)
      kao(:, 4,11,14) = (/ &
        & 0.12363e+04_r8,0.10327e+04_r8,0.91965e+03_r8,0.74736e+03_r8,0.60206e+03_r8, &
        & 0.74703e+03_r8,0.88982e+03_r8,0.10331e+04_r8,0.11762e+04_r8 /)
      kao(:, 5,11,14) = (/ &
        & 0.11827e+04_r8,0.10266e+04_r8,0.89018e+03_r8,0.76668e+03_r8,0.60360e+03_r8, &
        & 0.74604e+03_r8,0.88895e+03_r8,0.10316e+04_r8,0.11748e+04_r8 /)
      kao(:, 1,12,14) = (/ &
        & 0.11808e+04_r8,0.10792e+04_r8,0.88334e+03_r8,0.76947e+03_r8,0.60663e+03_r8, &
        & 0.74904e+03_r8,0.89307e+03_r8,0.10367e+04_r8,0.11803e+04_r8 /)
      kao(:, 2,12,14) = (/ &
        & 0.12120e+04_r8,0.10402e+04_r8,0.92096e+03_r8,0.78880e+03_r8,0.60609e+03_r8, &
        & 0.74841e+03_r8,0.89179e+03_r8,0.10352e+04_r8,0.11786e+04_r8 /)
      kao(:, 3,12,14) = (/ &
        & 0.12016e+04_r8,0.10899e+04_r8,0.90018e+03_r8,0.73017e+03_r8,0.60527e+03_r8, &
        & 0.75028e+03_r8,0.89119e+03_r8,0.10342e+04_r8,0.11778e+04_r8 /)
      kao(:, 4,12,14) = (/ &
        & 0.11901e+04_r8,0.10101e+04_r8,0.88929e+03_r8,0.75342e+03_r8,0.60426e+03_r8, &
        & 0.74677e+03_r8,0.88991e+03_r8,0.10327e+04_r8,0.11762e+04_r8 /)
      kao(:, 5,12,14) = (/ &
        & 0.12404e+04_r8,0.10285e+04_r8,0.87283e+03_r8,0.77029e+03_r8,0.60316e+03_r8, &
        & 0.74579e+03_r8,0.88852e+03_r8,0.10318e+04_r8,0.11748e+04_r8 /)
      kao(:, 1,13,14) = (/ &
        & 0.11819e+04_r8,0.10465e+04_r8,0.87588e+03_r8,0.72550e+03_r8,0.60649e+03_r8, &
        & 0.74922e+03_r8,0.89289e+03_r8,0.10366e+04_r8,0.11799e+04_r8 /)
      kao(:, 2,13,14) = (/ &
        & 0.11759e+04_r8,0.10245e+04_r8,0.86816e+03_r8,0.77411e+03_r8,0.60565e+03_r8, &
        & 0.74816e+03_r8,0.89163e+03_r8,0.10351e+04_r8,0.11786e+04_r8 /)
      kao(:, 3,13,14) = (/ &
        & 0.11354e+04_r8,0.10124e+04_r8,0.96299e+03_r8,0.72358e+03_r8,0.60486e+03_r8, &
        & 0.74851e+03_r8,0.89156e+03_r8,0.10341e+04_r8,0.11778e+04_r8 /)
      kao(:, 4,13,14) = (/ &
        & 0.11811e+04_r8,0.10736e+04_r8,0.85638e+03_r8,0.74549e+03_r8,0.60366e+03_r8, &
        & 0.74655e+03_r8,0.88977e+03_r8,0.10330e+04_r8,0.11762e+04_r8 /)
      kao(:, 5,13,14) = (/ &
        & 0.11332e+04_r8,0.99282e+03_r8,0.87259e+03_r8,0.77082e+03_r8,0.60280e+03_r8, &
        & 0.74559e+03_r8,0.88865e+03_r8,0.10317e+04_r8,0.11748e+04_r8 /)
      kao(:, 1, 1,15) = (/ &
        & 0.19847e+04_r8,0.16615e+04_r8,0.16299e+04_r8,0.11466e+04_r8,0.10123e+04_r8, &
        & 0.72871e+03_r8,0.89405e+03_r8,0.10334e+04_r8,0.11734e+04_r8 /)
      kao(:, 2, 1,15) = (/ &
        & 0.18867e+04_r8,0.16470e+04_r8,0.14051e+04_r8,0.12848e+04_r8,0.91870e+03_r8, &
        & 0.75104e+03_r8,0.89013e+03_r8,0.10307e+04_r8,0.11650e+04_r8 /)
      kao(:, 3, 1,15) = (/ &
        & 0.17405e+04_r8,0.16240e+04_r8,0.14364e+04_r8,0.10773e+04_r8,0.10008e+04_r8, &
        & 0.74790e+03_r8,0.89023e+03_r8,0.10382e+04_r8,0.11720e+04_r8 /)
      kao(:, 4, 1,15) = (/ &
        & 0.19099e+04_r8,0.16930e+04_r8,0.14454e+04_r8,0.12410e+04_r8,0.95925e+03_r8, &
        & 0.74605e+03_r8,0.88544e+03_r8,0.10248e+04_r8,0.11651e+04_r8 /)
      kao(:, 5, 1,15) = (/ &
        & 0.19738e+04_r8,0.13892e+04_r8,0.14377e+04_r8,0.12129e+04_r8,0.77083e+03_r8, &
        & 0.74496e+03_r8,0.88458e+03_r8,0.10242e+04_r8,0.11638e+04_r8 /)
      kao(:, 1, 2,15) = (/ &
        & 0.18788e+04_r8,0.15414e+04_r8,0.14391e+04_r8,0.94831e+03_r8,0.88384e+03_r8, &
        & 0.75320e+03_r8,0.89399e+03_r8,0.10340e+04_r8,0.11746e+04_r8 /)
      kao(:, 2, 2,15) = (/ &
        & 0.16660e+04_r8,0.14507e+04_r8,0.12145e+04_r8,0.11753e+04_r8,0.91977e+03_r8, &
        & 0.75003e+03_r8,0.89113e+03_r8,0.10308e+04_r8,0.11712e+04_r8 /)
      kao(:, 3, 2,15) = (/ &
        & 0.15746e+04_r8,0.14551e+04_r8,0.13375e+04_r8,0.10698e+04_r8,0.76931e+03_r8, &
        & 0.74657e+03_r8,0.88729e+03_r8,0.10267e+04_r8,0.11695e+04_r8 /)
      kao(:, 4, 2,15) = (/ &
        & 0.16772e+04_r8,0.16415e+04_r8,0.13391e+04_r8,0.10287e+04_r8,0.88207e+03_r8, &
        & 0.74593e+03_r8,0.88530e+03_r8,0.10252e+04_r8,0.11661e+04_r8 /)
      kao(:, 5, 2,15) = (/ &
        & 0.16581e+04_r8,0.15452e+04_r8,0.12479e+04_r8,0.10067e+04_r8,0.83698e+03_r8, &
        & 0.74419e+03_r8,0.88279e+03_r8,0.10234e+04_r8,0.11634e+04_r8 /)
      kao(:, 1, 3,15) = (/ &
        & 0.17888e+04_r8,0.13395e+04_r8,0.12224e+04_r8,0.11479e+04_r8,0.91734e+03_r8, &
        & 0.75291e+03_r8,0.89358e+03_r8,0.10348e+04_r8,0.11761e+04_r8 /)
      kao(:, 2, 3,15) = (/ &
        & 0.16146e+04_r8,0.11805e+04_r8,0.12709e+04_r8,0.85911e+03_r8,0.90210e+03_r8, &
        & 0.75028e+03_r8,0.89203e+03_r8,0.10324e+04_r8,0.11734e+04_r8 /)
      kao(:, 3, 3,15) = (/ &
        & 0.14717e+04_r8,0.15353e+04_r8,0.12224e+04_r8,0.96001e+03_r8,0.77554e+03_r8, &
        & 0.74753e+03_r8,0.88823e+03_r8,0.10297e+04_r8,0.11678e+04_r8 /)
      kao(:, 4, 3,15) = (/ &
        & 0.15479e+04_r8,0.14535e+04_r8,0.11756e+04_r8,0.99609e+03_r8,0.71892e+03_r8, &
        & 0.74634e+03_r8,0.88703e+03_r8,0.10366e+04_r8,0.11684e+04_r8 /)
      kao(:, 5, 3,15) = (/ &
        & 0.15155e+04_r8,0.14515e+04_r8,0.11733e+04_r8,0.10638e+04_r8,0.80510e+03_r8, &
        & 0.74461e+03_r8,0.88580e+03_r8,0.10240e+04_r8,0.11652e+04_r8 /)
      kao(:, 1, 4,15) = (/ &
        & 0.15848e+04_r8,0.14083e+04_r8,0.12006e+04_r8,0.10439e+04_r8,0.81336e+03_r8, &
        & 0.75201e+03_r8,0.89444e+03_r8,0.10363e+04_r8,0.11781e+04_r8 /)
      kao(:, 2, 4,15) = (/ &
        & 0.13736e+04_r8,0.13760e+04_r8,0.12165e+04_r8,0.94289e+03_r8,0.75006e+03_r8, &
        & 0.75167e+03_r8,0.89210e+03_r8,0.10337e+04_r8,0.11753e+04_r8 /)
      kao(:, 3, 4,15) = (/ &
        & 0.14353e+04_r8,0.13702e+04_r8,0.10217e+04_r8,0.10119e+04_r8,0.72585e+03_r8, &
        & 0.74883e+03_r8,0.88956e+03_r8,0.10325e+04_r8,0.11731e+04_r8 /)
      kao(:, 4, 4,15) = (/ &
        & 0.14295e+04_r8,0.12548e+04_r8,0.12198e+04_r8,0.96945e+03_r8,0.84557e+03_r8, &
        & 0.73846e+03_r8,0.88641e+03_r8,0.10258e+04_r8,0.11703e+04_r8 /)
      kao(:, 5, 4,15) = (/ &
        & 0.15742e+04_r8,0.13268e+04_r8,0.10395e+04_r8,0.90301e+03_r8,0.67604e+03_r8, &
        & 0.74473e+03_r8,0.88569e+03_r8,0.10266e+04_r8,0.11676e+04_r8 /)
      kao(:, 1, 5,15) = (/ &
        & 0.15038e+04_r8,0.11787e+04_r8,0.11191e+04_r8,0.96573e+03_r8,0.74364e+03_r8, &
        & 0.75161e+03_r8,0.89373e+03_r8,0.10358e+04_r8,0.11780e+04_r8 /)
      kao(:, 2, 5,15) = (/ &
        & 0.12972e+04_r8,0.14157e+04_r8,0.10073e+04_r8,0.10120e+04_r8,0.78829e+03_r8, &
        & 0.75051e+03_r8,0.89254e+03_r8,0.10346e+04_r8,0.11785e+04_r8 /)
      kao(:, 3, 5,15) = (/ &
        & 0.15562e+04_r8,0.12980e+04_r8,0.11053e+04_r8,0.96784e+03_r8,0.68156e+03_r8, &
        & 0.74938e+03_r8,0.89063e+03_r8,0.10325e+04_r8,0.11743e+04_r8 /)
      kao(:, 4, 5,15) = (/ &
        & 0.15203e+04_r8,0.12953e+04_r8,0.96757e+03_r8,0.95061e+03_r8,0.68480e+03_r8, &
        & 0.74750e+03_r8,0.88780e+03_r8,0.10293e+04_r8,0.11708e+04_r8 /)
      kao(:, 5, 5,15) = (/ &
        & 0.14730e+04_r8,0.11456e+04_r8,0.11151e+04_r8,0.68408e+03_r8,0.76176e+03_r8, &
        & 0.75307e+03_r8,0.89322e+03_r8,0.10317e+04_r8,0.11682e+04_r8 /)
      kao(:, 1, 6,15) = (/ &
        & 0.15240e+04_r8,0.12794e+04_r8,0.10826e+04_r8,0.93131e+03_r8,0.69525e+03_r8, &
        & 0.75122e+03_r8,0.89364e+03_r8,0.10361e+04_r8,0.11785e+04_r8 /)
      kao(:, 2, 6,15) = (/ &
        & 0.13735e+04_r8,0.12837e+04_r8,0.10725e+04_r8,0.91616e+03_r8,0.69548e+03_r8, &
        & 0.75041e+03_r8,0.89279e+03_r8,0.10360e+04_r8,0.11776e+04_r8 /)
      kao(:, 3, 6,15) = (/ &
        & 0.14287e+04_r8,0.11366e+04_r8,0.10240e+04_r8,0.87529e+03_r8,0.70795e+03_r8, &
        & 0.75034e+03_r8,0.89142e+03_r8,0.10337e+04_r8,0.11759e+04_r8 /)
      kao(:, 4, 6,15) = (/ &
        & 0.12768e+04_r8,0.11078e+04_r8,0.98805e+03_r8,0.76254e+03_r8,0.77383e+03_r8, &
        & 0.74782e+03_r8,0.88921e+03_r8,0.10312e+04_r8,0.11732e+04_r8 /)
      kao(:, 5, 6,15) = (/ &
        & 0.13045e+04_r8,0.12087e+04_r8,0.10585e+04_r8,0.89185e+03_r8,0.69378e+03_r8, &
        & 0.74461e+03_r8,0.88618e+03_r8,0.10253e+04_r8,0.11684e+04_r8 /)
      kao(:, 1, 7,15) = (/ &
        & 0.13068e+04_r8,0.11778e+04_r8,0.10485e+04_r8,0.87245e+03_r8,0.70237e+03_r8, &
        & 0.75029e+03_r8,0.89358e+03_r8,0.10363e+04_r8,0.11790e+04_r8 /)
      kao(:, 2, 7,15) = (/ &
        & 0.13988e+04_r8,0.11525e+04_r8,0.98924e+03_r8,0.83779e+03_r8,0.64617e+03_r8, &
        & 0.75022e+03_r8,0.89357e+03_r8,0.10355e+04_r8,0.11782e+04_r8 /)
      kao(:, 3, 7,15) = (/ &
        & 0.14294e+04_r8,0.11695e+04_r8,0.10182e+04_r8,0.91196e+03_r8,0.69696e+03_r8, &
        & 0.74932e+03_r8,0.89330e+03_r8,0.10353e+04_r8,0.11780e+04_r8 /)
      kao(:, 4, 7,15) = (/ &
        & 0.14082e+04_r8,0.10640e+04_r8,0.10540e+04_r8,0.79295e+03_r8,0.62688e+03_r8, &
        & 0.74789e+03_r8,0.89097e+03_r8,0.10327e+04_r8,0.11750e+04_r8 /)
      kao(:, 5, 7,15) = (/ &
        & 0.13514e+04_r8,0.12038e+04_r8,0.10012e+04_r8,0.83544e+03_r8,0.67927e+03_r8, &
        & 0.74629e+03_r8,0.88843e+03_r8,0.10298e+04_r8,0.11718e+04_r8 /)
      kao(:, 1, 8,15) = (/ &
        & 0.14761e+04_r8,0.12412e+04_r8,0.10429e+04_r8,0.84370e+03_r8,0.62388e+03_r8, &
        & 0.75133e+03_r8,0.89371e+03_r8,0.10367e+04_r8,0.11796e+04_r8 /)
      kao(:, 2, 8,15) = (/ &
        & 0.12119e+04_r8,0.11409e+04_r8,0.10121e+04_r8,0.85755e+03_r8,0.70976e+03_r8, &
        & 0.74998e+03_r8,0.89216e+03_r8,0.10357e+04_r8,0.11786e+04_r8 /)
      kao(:, 3, 8,15) = (/ &
        & 0.12581e+04_r8,0.11663e+04_r8,0.10198e+04_r8,0.88649e+03_r8,0.69509e+03_r8, &
        & 0.74932e+03_r8,0.89355e+03_r8,0.10350e+04_r8,0.11787e+04_r8 /)
      kao(:, 4, 8,15) = (/ &
        & 0.12478e+04_r8,0.12066e+04_r8,0.87201e+03_r8,0.84155e+03_r8,0.70223e+03_r8, &
        & 0.74886e+03_r8,0.89098e+03_r8,0.10337e+04_r8,0.11764e+04_r8 /)
      kao(:, 5, 8,15) = (/ &
        & 0.12322e+04_r8,0.11048e+04_r8,0.93070e+03_r8,0.68296e+03_r8,0.66022e+03_r8, &
        & 0.74776e+03_r8,0.88972e+03_r8,0.10315e+04_r8,0.11748e+04_r8 /)
      kao(:, 1, 9,15) = (/ &
        & 0.13164e+04_r8,0.12093e+04_r8,0.10729e+04_r8,0.80022e+03_r8,0.68605e+03_r8, &
        & 0.75075e+03_r8,0.89396e+03_r8,0.10372e+04_r8,0.11804e+04_r8 /)
      kao(:, 2, 9,15) = (/ &
        & 0.12738e+04_r8,0.11851e+04_r8,0.88381e+03_r8,0.85846e+03_r8,0.65813e+03_r8, &
        & 0.74985e+03_r8,0.89295e+03_r8,0.10369e+04_r8,0.11792e+04_r8 /)
      kao(:, 3, 9,15) = (/ &
        & 0.12657e+04_r8,0.12031e+04_r8,0.79849e+03_r8,0.64636e+03_r8,0.60824e+03_r8, &
        & 0.74924e+03_r8,0.89227e+03_r8,0.10353e+04_r8,0.11783e+04_r8 /)
      kao(:, 4, 9,15) = (/ &
        & 0.12866e+04_r8,0.11531e+04_r8,0.85958e+03_r8,0.76890e+03_r8,0.66204e+03_r8, &
        & 0.74965e+03_r8,0.89143e+03_r8,0.10344e+04_r8,0.11773e+04_r8 /)
      kao(:, 5, 9,15) = (/ &
        & 0.11604e+04_r8,0.11730e+04_r8,0.87009e+03_r8,0.73148e+03_r8,0.58106e+03_r8, &
        & 0.74723e+03_r8,0.88998e+03_r8,0.10327e+04_r8,0.11755e+04_r8 /)
      kao(:, 1,10,15) = (/ &
        & 0.11188e+04_r8,0.99215e+03_r8,0.73460e+03_r8,0.83046e+03_r8,0.68844e+03_r8, &
        & 0.75085e+03_r8,0.89429e+03_r8,0.10377e+04_r8,0.11803e+04_r8 /)
      kao(:, 2,10,15) = (/ &
        & 0.12059e+04_r8,0.10804e+04_r8,0.70761e+03_r8,0.65712e+03_r8,0.66535e+03_r8, &
        & 0.74980e+03_r8,0.89311e+03_r8,0.10364e+04_r8,0.11807e+04_r8 /)
      kao(:, 3,10,15) = (/ &
        & 0.11817e+04_r8,0.10195e+04_r8,0.95365e+03_r8,0.71601e+03_r8,0.59959e+03_r8, &
        & 0.74791e+03_r8,0.89228e+03_r8,0.10355e+04_r8,0.11778e+04_r8 /)
      kao(:, 4,10,15) = (/ &
        & 0.11350e+04_r8,0.11533e+04_r8,0.91058e+03_r8,0.81845e+03_r8,0.64874e+03_r8, &
        & 0.74908e+03_r8,0.89233e+03_r8,0.10356e+04_r8,0.11779e+04_r8 /)
      kao(:, 5,10,15) = (/ &
        & 0.12000e+04_r8,0.10896e+04_r8,0.93671e+03_r8,0.81314e+03_r8,0.60750e+03_r8, &
        & 0.74754e+03_r8,0.89053e+03_r8,0.10335e+04_r8,0.11765e+04_r8 /)
      kao(:, 1,11,15) = (/ &
        & 0.12887e+04_r8,0.10795e+04_r8,0.92507e+03_r8,0.76020e+03_r8,0.61621e+03_r8, &
        & 0.75046e+03_r8,0.89404e+03_r8,0.10376e+04_r8,0.11812e+04_r8 /)
      kao(:, 2,11,15) = (/ &
        & 0.11864e+04_r8,0.99352e+03_r8,0.96688e+03_r8,0.81999e+03_r8,0.65449e+03_r8, &
        & 0.74944e+03_r8,0.89287e+03_r8,0.10363e+04_r8,0.11797e+04_r8 /)
      kao(:, 3,11,15) = (/ &
        & 0.11946e+04_r8,0.10069e+04_r8,0.91904e+03_r8,0.81170e+03_r8,0.65606e+03_r8, &
        & 0.74582e+03_r8,0.89066e+03_r8,0.10354e+04_r8,0.11787e+04_r8 /)
      kao(:, 4,11,15) = (/ &
        & 0.10269e+04_r8,0.10463e+04_r8,0.82697e+03_r8,0.81731e+03_r8,0.61185e+03_r8, &
        & 0.74876e+03_r8,0.89142e+03_r8,0.10347e+04_r8,0.11779e+04_r8 /)
      kao(:, 5,11,15) = (/ &
        & 0.11483e+04_r8,0.10490e+04_r8,0.91718e+03_r8,0.72295e+03_r8,0.60510e+03_r8, &
        & 0.74783e+03_r8,0.89173e+03_r8,0.10334e+04_r8,0.11765e+04_r8 /)
      kao(:, 1,12,15) = (/ &
        & 0.12157e+04_r8,0.94948e+03_r8,0.89441e+03_r8,0.76380e+03_r8,0.60866e+03_r8, &
        & 0.75013e+03_r8,0.89382e+03_r8,0.10375e+04_r8,0.11812e+04_r8 /)
      kao(:, 2,12,15) = (/ &
        & 0.10470e+04_r8,0.10059e+04_r8,0.83704e+03_r8,0.70161e+03_r8,0.60721e+03_r8, &
        & 0.74914e+03_r8,0.89267e+03_r8,0.10370e+04_r8,0.11807e+04_r8 /)
      kao(:, 3,12,15) = (/ &
        & 0.10541e+04_r8,0.86865e+03_r8,0.86614e+03_r8,0.79420e+03_r8,0.60576e+03_r8, &
        & 0.74144e+03_r8,0.89117e+03_r8,0.10353e+04_r8,0.11778e+04_r8 /)
      kao(:, 4,12,15) = (/ &
        & 0.11152e+04_r8,0.10946e+04_r8,0.91200e+03_r8,0.75719e+03_r8,0.60459e+03_r8, &
        & 0.74791e+03_r8,0.89124e+03_r8,0.10346e+04_r8,0.11788e+04_r8 /)
      kao(:, 5,12,15) = (/ &
        & 0.10232e+04_r8,0.97767e+03_r8,0.95862e+03_r8,0.62268e+03_r8,0.60382e+03_r8, &
        & 0.74758e+03_r8,0.88947e+03_r8,0.10333e+04_r8,0.11765e+04_r8 /)
      kao(:, 1,13,15) = (/ &
        & 0.11027e+04_r8,0.93786e+03_r8,0.84040e+03_r8,0.77686e+03_r8,0.60858e+03_r8, &
        & 0.74987e+03_r8,0.89364e+03_r8,0.10374e+04_r8,0.11812e+04_r8 /)
      kao(:, 2,13,15) = (/ &
        & 0.10816e+04_r8,0.10747e+04_r8,0.88690e+03_r8,0.66213e+03_r8,0.60670e+03_r8, &
        & 0.74889e+03_r8,0.89251e+03_r8,0.10369e+04_r8,0.11797e+04_r8 /)
      kao(:, 3,13,15) = (/ &
        & 0.11963e+04_r8,0.98701e+03_r8,0.69767e+03_r8,0.73646e+03_r8,0.60528e+03_r8, &
        & 0.74531e+03_r8,0.88962e+03_r8,0.10352e+04_r8,0.11778e+04_r8 /)
      kao(:, 4,13,15) = (/ &
        & 0.10530e+04_r8,0.78530e+03_r8,0.91477e+03_r8,0.71026e+03_r8,0.60430e+03_r8, &
        & 0.74770e+03_r8,0.89110e+03_r8,0.10345e+04_r8,0.11779e+04_r8 /)
      kao(:, 5,13,15) = (/ &
        & 0.11409e+04_r8,0.10574e+04_r8,0.83207e+03_r8,0.61034e+03_r8,0.60355e+03_r8, &
        & 0.74679e+03_r8,0.89073e+03_r8,0.10333e+04_r8,0.11765e+04_r8 /)
      kao(:, 1, 1,16) = (/ &
        & 0.34848e+03_r8,0.49670e+03_r8,0.29569e+03_r8,0.31627e+03_r8,0.46514e+03_r8, &
        & 0.42834e+03_r8,0.88848e+03_r8,0.10335e+04_r8,0.11735e+04_r8 /)
      kao(:, 2, 1,16) = (/ &
        & 0.18044e+04_r8,0.87518e+03_r8,0.11930e+04_r8,0.45580e+03_r8,0.83690e+03_r8, &
        & 0.74631e+03_r8,0.89022e+03_r8,0.10242e+04_r8,0.11632e+04_r8 /)
      kao(:, 3, 1,16) = (/ &
        & 0.11196e+04_r8,0.73658e+03_r8,0.10480e+04_r8,0.53695e+03_r8,0.39566e+03_r8, &
        & 0.74377e+03_r8,0.86775e+03_r8,0.94144e+03_r8,0.11277e+04_r8 /)
      kao(:, 4, 1,16) = (/ &
        & 0.72013e+03_r8,0.40040e+03_r8,0.39030e+03_r8,0.31401e+03_r8,0.31498e+03_r8, &
        & 0.74613e+03_r8,0.88553e+03_r8,0.10249e+04_r8,0.11579e+04_r8 /)
      kao(:, 5, 1,16) = (/ &
        & 0.34789e+03_r8,0.14911e+04_r8,0.33003e+03_r8,0.29522e+03_r8,0.31385e+03_r8, &
        & 0.74516e+03_r8,0.88480e+03_r8,0.10244e+04_r8,0.11641e+04_r8 /)
      kao(:, 1, 2,16) = (/ &
        & 0.41247e+03_r8,0.81197e+03_r8,0.68322e+03_r8,0.50855e+03_r8,0.24076e+03_r8, &
        & 0.74851e+03_r8,0.88842e+03_r8,0.10341e+04_r8,0.11748e+04_r8 /)
      kao(:, 2, 2,16) = (/ &
        & 0.16209e+04_r8,0.56884e+03_r8,0.94156e+03_r8,0.29182e+03_r8,0.46039e+03_r8, &
        & 0.75011e+03_r8,0.88557e+03_r8,0.10309e+04_r8,0.11714e+04_r8 /)
      kao(:, 3, 2,16) = (/ &
        & 0.11534e+04_r8,0.51443e+03_r8,0.23941e+03_r8,0.44358e+03_r8,0.58779e+03_r8, &
        & 0.74720e+03_r8,0.88237e+03_r8,0.10275e+04_r8,0.11547e+04_r8 /)
      kao(:, 4, 2,16) = (/ &
        & 0.78193e+03_r8,0.30585e+03_r8,0.42670e+03_r8,0.10365e+04_r8,0.43225e+03_r8, &
        & 0.74126e+03_r8,0.88535e+03_r8,0.10253e+04_r8,0.11588e+04_r8 /)
      kao(:, 5, 2,16) = (/ &
        & 0.67509e+03_r8,0.40574e+03_r8,0.57252e+03_r8,0.10353e+04_r8,0.15564e+03_r8, &
        & 0.73954e+03_r8,0.88360e+03_r8,0.10236e+04_r8,0.11636e+04_r8 /)
      kao(:, 1, 3,16) = (/ &
        & 0.91257e+03_r8,0.11144e+04_r8,0.54685e+03_r8,0.19037e+03_r8,0.25900e+03_r8, &
        & 0.74823e+03_r8,0.89369e+03_r8,0.10350e+04_r8,0.11762e+04_r8 /)
      kao(:, 2, 3,16) = (/ &
        & 0.67162e+03_r8,0.10092e+04_r8,0.40983e+03_r8,0.37826e+03_r8,0.42702e+03_r8, &
        & 0.75035e+03_r8,0.88647e+03_r8,0.10325e+04_r8,0.11736e+04_r8 /)
      kao(:, 3, 3,16) = (/ &
        & 0.94657e+03_r8,0.26107e+03_r8,0.43567e+03_r8,0.41065e+03_r8,0.70838e+03_r8, &
        & 0.74760e+03_r8,0.88832e+03_r8,0.10233e+04_r8,0.11698e+04_r8 /)
      kao(:, 4, 3,16) = (/ &
        & 0.10618e+03_r8,0.45040e+03_r8,0.10291e+04_r8,0.30237e+03_r8,0.57813e+03_r8, &
        & 0.73277e+03_r8,0.87582e+03_r8,0.95203e+03_r8,0.11472e+04_r8 /)
      kao(:, 5, 3,16) = (/ &
        & 0.96551e+03_r8,0.68706e+03_r8,0.56500e+03_r8,0.14865e+03_r8,0.35532e+03_r8, &
        & 0.73527e+03_r8,0.86908e+03_r8,0.10241e+04_r8,0.11579e+04_r8 /)
      kao(:, 1, 4,16) = (/ &
        & 0.13211e+04_r8,0.11050e+04_r8,0.91067e+03_r8,0.34788e+03_r8,0.76485e+03_r8, &
        & 0.75213e+03_r8,0.88892e+03_r8,0.10299e+04_r8,0.11709e+04_r8 /)
      kao(:, 2, 4,16) = (/ &
        & 0.15543e+04_r8,0.92211e+03_r8,0.72798e+03_r8,0.86839e+03_r8,0.36802e+03_r8, &
        & 0.74223e+03_r8,0.89219e+03_r8,0.10338e+04_r8,0.11754e+04_r8 /)
      kao(:, 3, 4,16) = (/ &
        & 0.53676e+03_r8,0.46363e+03_r8,0.10941e+04_r8,0.19958e+03_r8,0.68767e+03_r8, &
        & 0.74416e+03_r8,0.88965e+03_r8,0.10195e+04_r8,0.11658e+04_r8 /)
      kao(:, 4, 4,16) = (/ &
        & 0.66992e+03_r8,0.61007e+03_r8,0.50612e+03_r8,0.34999e+03_r8,0.19685e+03_r8, &
        & 0.74139e+03_r8,0.88155e+03_r8,0.10274e+04_r8,0.11555e+04_r8 /)
      kao(:, 5, 4,16) = (/ &
        & 0.55226e+03_r8,0.42689e+03_r8,0.10712e+04_r8,0.69959e+03_r8,0.69105e+03_r8, &
        & 0.73534e+03_r8,0.87452e+03_r8,0.10137e+04_r8,0.11529e+04_r8 /)
      kao(:, 1, 5,16) = (/ &
        & 0.11854e+04_r8,0.90025e+03_r8,0.10734e+04_r8,0.36732e+03_r8,0.51551e+03_r8, &
        & 0.75181e+03_r8,0.89397e+03_r8,0.10361e+04_r8,0.11783e+04_r8 /)
      kao(:, 2, 5,16) = (/ &
        & 0.13933e+04_r8,0.23882e+03_r8,0.71015e+03_r8,0.29765e+03_r8,0.88507e+02_r8, &
        & 0.75060e+03_r8,0.89266e+03_r8,0.10347e+04_r8,0.11637e+04_r8 /)
      kao(:, 3, 5,16) = (/ &
        & 0.30783e+03_r8,0.72533e+03_r8,0.99782e+03_r8,0.22581e+03_r8,0.21957e+03_r8, &
        & 0.74471e+03_r8,0.89072e+03_r8,0.10326e+04_r8,0.11744e+04_r8 /)
      kao(:, 4, 5,16) = (/ &
        & 0.12756e+03_r8,0.23797e+03_r8,0.16871e+03_r8,0.60625e+03_r8,0.35893e+03_r8, &
        & 0.73811e+03_r8,0.88789e+03_r8,0.10294e+04_r8,0.11709e+04_r8 /)
      kao(:, 5, 5,16) = (/ &
        & 0.67577e+03_r8,0.67606e+03_r8,0.57612e+03_r8,0.15439e+03_r8,0.22922e+03_r8, &
        & 0.66526e+03_r8,0.82593e+03_r8,0.98621e+03_r8,0.11543e+04_r8 /)
      kao(:, 1, 6,16) = (/ &
        & 0.35294e+03_r8,0.92951e+03_r8,0.39404e+03_r8,0.59466e+03_r8,0.46365e+03_r8, &
        & 0.75155e+03_r8,0.89403e+03_r8,0.10365e+04_r8,0.11790e+04_r8 /)
      kao(:, 2, 6,16) = (/ &
        & 0.83494e+03_r8,0.91972e+03_r8,0.83351e+02_r8,0.26459e+03_r8,0.33053e+03_r8, &
        & 0.75056e+03_r8,0.89298e+03_r8,0.10296e+04_r8,0.11778e+04_r8 /)
      kao(:, 3, 6,16) = (/ &
        & 0.77495e+02_r8,0.67358e+03_r8,0.71470e+03_r8,0.28985e+03_r8,0.12695e+03_r8, &
        & 0.74093e+03_r8,0.89153e+03_r8,0.10338e+04_r8,0.11761e+04_r8 /)
      kao(:, 4, 6,16) = (/ &
        & 0.12524e+04_r8,0.52300e+03_r8,0.17321e+03_r8,0.31958e+03_r8,0.15643e+03_r8, &
        & 0.74316e+03_r8,0.88930e+03_r8,0.10313e+04_r8,0.11733e+04_r8 /)
      kao(:, 5, 6,16) = (/ &
        & 0.79880e+03_r8,0.54259e+03_r8,0.31909e+03_r8,0.47791e+03_r8,0.45938e+03_r8, &
        & 0.74468e+03_r8,0.88626e+03_r8,0.10278e+04_r8,0.11499e+04_r8 /)
      kao(:, 1, 7,16) = (/ &
        & 0.10078e+04_r8,0.83081e+03_r8,0.68047e+03_r8,0.68284e+03_r8,0.57904e+03_r8, &
        & 0.75128e+03_r8,0.89403e+03_r8,0.10368e+04_r8,0.11795e+04_r8 /)
      kao(:, 2, 7,16) = (/ &
        & 0.67323e+03_r8,0.10228e+04_r8,0.49758e+03_r8,0.33578e+03_r8,0.38746e+03_r8, &
        & 0.75047e+03_r8,0.88822e+03_r8,0.10359e+04_r8,0.11786e+04_r8 /)
      kao(:, 3, 7,16) = (/ &
        & 0.60358e+03_r8,0.41876e+03_r8,0.74942e+03_r8,0.38757e+03_r8,0.61092e+03_r8, &
        & 0.74943e+03_r8,0.88213e+03_r8,0.10289e+04_r8,0.11707e+04_r8 /)
      kao(:, 4, 7,16) = (/ &
        & 0.69109e+03_r8,0.11040e+04_r8,0.46705e+03_r8,0.74628e+03_r8,0.47483e+03_r8, &
        & 0.74797e+03_r8,0.88542e+03_r8,0.10328e+04_r8,0.11752e+04_r8 /)
      kao(:, 5, 7,16) = (/ &
        & 0.68277e+03_r8,0.46564e+03_r8,0.19228e+03_r8,0.48854e+03_r8,0.28304e+03_r8, &
        & 0.74163e+03_r8,0.88289e+03_r8,0.10299e+04_r8,0.11719e+04_r8 /)
      kao(:, 1, 8,16) = (/ &
        & 0.26685e+03_r8,0.60532e+03_r8,0.51009e+03_r8,0.40907e+03_r8,0.39126e+03_r8, &
        & 0.74682e+03_r8,0.89396e+03_r8,0.10369e+04_r8,0.11799e+04_r8 /)
      kao(:, 2, 8,16) = (/ &
        & 0.94869e+03_r8,0.11471e+04_r8,0.44706e+03_r8,0.23151e+03_r8,0.93532e+02_r8, &
        & 0.75035e+03_r8,0.89331e+03_r8,0.10363e+04_r8,0.11727e+04_r8 /)
      kao(:, 3, 8,16) = (/ &
        & 0.11588e+04_r8,0.74588e+03_r8,0.28311e+03_r8,0.27864e+03_r8,0.32853e+03_r8, &
        & 0.74950e+03_r8,0.88246e+03_r8,0.10352e+04_r8,0.11716e+04_r8 /)
      kao(:, 4, 8,16) = (/ &
        & 0.11874e+04_r8,0.47456e+03_r8,0.83368e+03_r8,0.31591e+03_r8,0.30274e+03_r8, &
        & 0.74421e+03_r8,0.89109e+03_r8,0.10338e+04_r8,0.11765e+04_r8 /)
      kao(:, 5, 8,16) = (/ &
        & 0.45710e+03_r8,0.66086e+03_r8,0.55863e+03_r8,0.58037e+03_r8,0.20569e+03_r8, &
        & 0.73836e+03_r8,0.88417e+03_r8,0.10316e+04_r8,0.11675e+04_r8 /)
      kao(:, 1, 9,16) = (/ &
        & 0.55233e+03_r8,0.18269e+03_r8,0.18991e+03_r8,0.35964e+03_r8,0.38998e+03_r8, &
        & 0.75089e+03_r8,0.89415e+03_r8,0.10374e+04_r8,0.11807e+04_r8 /)
      kao(:, 2, 9,16) = (/ &
        & 0.31819e+03_r8,0.14904e+03_r8,0.79703e+03_r8,0.32317e+03_r8,0.20679e+03_r8, &
        & 0.75021e+03_r8,0.89337e+03_r8,0.10308e+04_r8,0.11797e+04_r8 /)
      kao(:, 3, 9,16) = (/ &
        & 0.16059e+03_r8,0.37409e+03_r8,0.62337e+03_r8,0.62951e+03_r8,0.47662e+03_r8, &
        & 0.74953e+03_r8,0.89262e+03_r8,0.10357e+04_r8,0.11788e+04_r8 /)
      kao(:, 4, 9,16) = (/ &
        & 0.15191e+03_r8,0.63681e+03_r8,0.25601e+03_r8,0.65772e+03_r8,0.38994e+03_r8, &
        & 0.74029e+03_r8,0.89158e+03_r8,0.10346e+04_r8,0.11775e+04_r8 /)
      kao(:, 5, 9,16) = (/ &
        & 0.10392e+04_r8,0.33629e+03_r8,0.90538e+03_r8,0.33435e+03_r8,0.46694e+03_r8, &
        & 0.74731e+03_r8,0.89008e+03_r8,0.10329e+04_r8,0.11756e+04_r8 /)
      kao(:, 1,10,16) = (/ &
        & 0.43161e+03_r8,0.53194e+03_r8,0.82168e+03_r8,0.11050e+03_r8,0.32159e+02_r8, &
        & 0.75101e+03_r8,0.89450e+03_r8,0.10380e+04_r8,0.11815e+04_r8 /)
      kao(:, 2,10,16) = (/ &
        & 0.23362e+03_r8,0.50697e+03_r8,0.75913e+03_r8,0.37965e+03_r8,0.15877e+03_r8, &
        & 0.75002e+03_r8,0.89333e+03_r8,0.10366e+04_r8,0.11734e+04_r8 /)
      kao(:, 3,10,16) = (/ &
        & 0.66577e+03_r8,0.22676e+03_r8,0.63752e+03_r8,0.50488e+03_r8,0.52339e+03_r8, &
        & 0.74947e+03_r8,0.88778e+03_r8,0.10360e+04_r8,0.11793e+04_r8 /)
      kao(:, 4,10,16) = (/ &
        & 0.12040e+04_r8,0.37222e+03_r8,0.71269e+03_r8,0.68368e+02_r8,0.31445e+03_r8, &
        & 0.74453e+03_r8,0.88691e+03_r8,0.10293e+04_r8,0.11782e+04_r8 /)
      kao(:, 5,10,16) = (/ &
        & 0.85334e+03_r8,0.50951e+03_r8,0.43397e+03_r8,0.11861e+03_r8,0.15074e+03_r8, &
        & 0.74764e+03_r8,0.89065e+03_r8,0.10337e+04_r8,0.11767e+04_r8 /)
      kao(:, 1,11,16) = (/ &
        & 0.45853e+03_r8,0.29024e+03_r8,0.38275e+03_r8,0.26130e+03_r8,0.12124e+03_r8, &
        & 0.75062e+03_r8,0.89424e+03_r8,0.10379e+04_r8,0.11815e+04_r8 /)
      kao(:, 2,11,16) = (/ &
        & 0.66691e+03_r8,0.55656e+03_r8,0.39879e+03_r8,0.16526e+03_r8,0.24675e+03_r8, &
        & 0.74965e+03_r8,0.89309e+03_r8,0.10365e+04_r8,0.11800e+04_r8 /)
      kao(:, 3,11,16) = (/ &
        & 0.10239e+04_r8,0.60930e+03_r8,0.22001e+03_r8,0.10914e+03_r8,0.22748e+03_r8, &
        & 0.74913e+03_r8,0.89251e+03_r8,0.10359e+04_r8,0.11793e+04_r8 /)
      kao(:, 4,11,16) = (/ &
        & 0.80567e+03_r8,0.90344e+03_r8,0.77356e+03_r8,0.12489e+03_r8,0.55902e+03_r8, &
        & 0.74421e+03_r8,0.89165e+03_r8,0.10349e+04_r8,0.11782e+04_r8 /)
      kao(:, 5,11,16) = (/ &
        & 0.80619e+03_r8,0.87963e+03_r8,0.47254e+03_r8,0.39261e+03_r8,0.59752e+03_r8, &
        & 0.74319e+03_r8,0.88056e+03_r8,0.10336e+04_r8,0.11767e+04_r8 /)
      kao(:, 1,12,16) = (/ &
        & 0.54479e+03_r8,0.73809e+03_r8,0.74534e+03_r8,0.30870e+03_r8,0.60893e+03_r8, &
        & 0.75030e+03_r8,0.89402e+03_r8,0.10378e+04_r8,0.11815e+04_r8 /)
      kao(:, 2,12,16) = (/ &
        & 0.10600e+04_r8,0.76559e+03_r8,0.34957e+03_r8,0.18602e+03_r8,0.60736e+03_r8, &
        & 0.74935e+03_r8,0.89289e+03_r8,0.10307e+04_r8,0.11734e+04_r8 /)
      kao(:, 3,12,16) = (/ &
        & 0.10515e+04_r8,0.60079e+03_r8,0.43472e+03_r8,0.33220e+03_r8,0.60582e+03_r8, &
        & 0.74885e+03_r8,0.89233e+03_r8,0.10358e+04_r8,0.11793e+04_r8 /)
      kao(:, 4,12,16) = (/ &
        & 0.32670e+03_r8,0.23075e+03_r8,0.13581e+03_r8,0.17106e+03_r8,0.60474e+03_r8, &
        & 0.74811e+03_r8,0.89148e+03_r8,0.10348e+04_r8,0.11717e+04_r8 /)
      kao(:, 5,12,16) = (/ &
        & 0.20371e+03_r8,0.68798e+03_r8,0.91592e+02_r8,0.60316e+03_r8,0.60390e+03_r8, &
        & 0.74294e+03_r8,0.89029e+03_r8,0.10335e+04_r8,0.11767e+04_r8 /)
      kao(:, 1,13,16) = (/ &
        & 0.85988e+03_r8,0.94717e+03_r8,0.84544e+03_r8,0.31415e+03_r8,0.60500e+03_r8, &
        & 0.75003e+03_r8,0.89385e+03_r8,0.10377e+04_r8,0.11815e+04_r8 /)
      kao(:, 2,13,16) = (/ &
        & 0.10379e+04_r8,0.11189e+03_r8,0.20733e+03_r8,0.17410e+03_r8,0.60685e+03_r8, &
        & 0.74910e+03_r8,0.89272e+03_r8,0.10306e+04_r8,0.11800e+04_r8 /)
      kao(:, 3,13,16) = (/ &
        & 0.70206e+03_r8,0.77801e+03_r8,0.11974e+03_r8,0.34591e+03_r8,0.60534e+03_r8, &
        & 0.74861e+03_r8,0.89217e+03_r8,0.10357e+04_r8,0.11793e+04_r8 /)
      kao(:, 4,13,16) = (/ &
        & 0.69165e+03_r8,0.93369e+03_r8,0.16190e+03_r8,0.16396e+03_r8,0.60445e+03_r8, &
        & 0.74789e+03_r8,0.89133e+03_r8,0.10348e+04_r8,0.11782e+04_r8 /)
      kao(:, 5,13,16) = (/ &
        & 0.20016e+03_r8,0.25832e+03_r8,0.57797e+03_r8,0.24270e+03_r8,0.60363e+03_r8, &
        & 0.74689e+03_r8,0.88521e+03_r8,0.10334e+04_r8,0.11767e+04_r8 /)
  
!     -----------------------------------------------------------------
!     The array KBO contains absorption coefs at the 16 chosen g-values 
!     for a range of pressure levels < ~100mb and temperatures. The first 
!     index in the array, JT, which runs from 1 to 5, corresponds to 
!     different temperatures.  More specifically, JT = 3 means that the 
!     data are for the reference temperature TREF for this pressure 
!     level, JT = 2 refers to the temperature TREF-15, JT = 1 is for
!     TREF-30, JT = 4 is for TREF+15, and JT = 5 is for TREF+30.  
!     The second index, JP, runs from 13 to 59 and refers to the JPth
!     reference pressure level (see taumol.f for the value of these
!     pressure levels in mb).  The third index, IG, goes from 1 to 16,
!     and tells us which g-interval the absorption coefficients are for.
!     -----------------------------------------------------------------

      kbo(:, 1,13, 1) = (/ &
        & 0.27369e+02_r8,0.29903e+03_r8,0.42924e+03_r8,0.31039e+03_r8,0.35000e+02_r8 /)
      kbo(:, 2,13, 1) = (/ &
        & 0.27158e+02_r8,0.29898e+03_r8,0.42745e+03_r8,0.30840e+03_r8,0.35000e+02_r8 /)
      kbo(:, 3,13, 1) = (/ &
        & 0.26976e+02_r8,0.29889e+03_r8,0.42590e+03_r8,0.30668e+03_r8,0.35000e+02_r8 /)
      kbo(:, 4,13, 1) = (/ &
        & 0.26818e+02_r8,0.29875e+03_r8,0.42455e+03_r8,0.30517e+03_r8,0.35000e+02_r8 /)
      kbo(:, 5,13, 1) = (/ &
        & 0.26679e+02_r8,0.29855e+03_r8,0.42335e+03_r8,0.30384e+03_r8,0.35000e+02_r8 /)
      kbo(:, 1,14, 1) = (/ &
        & 0.26840e+02_r8,0.29863e+03_r8,0.42474e+03_r8,0.30538e+03_r8,0.35000e+02_r8 /)
      kbo(:, 2,14, 1) = (/ &
        & 0.26669e+02_r8,0.29862e+03_r8,0.42327e+03_r8,0.30375e+03_r8,0.35000e+02_r8 /)
      kbo(:, 3,14, 1) = (/ &
        & 0.26522e+02_r8,0.29854e+03_r8,0.42199e+03_r8,0.30234e+03_r8,0.35000e+02_r8 /)
      kbo(:, 4,14, 1) = (/ &
        & 0.26394e+02_r8,0.29842e+03_r8,0.42088e+03_r8,0.30111e+03_r8,0.35000e+02_r8 /)
      kbo(:, 5,14, 1) = (/ &
        & 0.26282e+02_r8,0.29824e+03_r8,0.41990e+03_r8,0.30002e+03_r8,0.35000e+02_r8 /)
      kbo(:, 1,15, 1) = (/ &
        & 0.26408e+02_r8,0.29831e+03_r8,0.42100e+03_r8,0.30124e+03_r8,0.35000e+02_r8 /)
      kbo(:, 2,15, 1) = (/ &
        & 0.26271e+02_r8,0.29832e+03_r8,0.41980e+03_r8,0.29991e+03_r8,0.35000e+02_r8 /)
      kbo(:, 3,15, 1) = (/ &
        & 0.26152e+02_r8,0.29826e+03_r8,0.41876e+03_r8,0.29877e+03_r8,0.35000e+02_r8 /)
      kbo(:, 4,15, 1) = (/ &
        & 0.26049e+02_r8,0.29814e+03_r8,0.41785e+03_r8,0.29776e+03_r8,0.35000e+02_r8 /)
      kbo(:, 5,15, 1) = (/ &
        & 0.25958e+02_r8,0.29797e+03_r8,0.41705e+03_r8,0.29688e+03_r8,0.35000e+02_r8 /)
      kbo(:, 1,16, 1) = (/ &
        & 0.26057e+02_r8,0.29806e+03_r8,0.41793e+03_r8,0.29784e+03_r8,0.35000e+02_r8 /)
      kbo(:, 2,16, 1) = (/ &
        & 0.25946e+02_r8,0.29807e+03_r8,0.41695e+03_r8,0.29676e+03_r8,0.35000e+02_r8 /)
      kbo(:, 3,16, 1) = (/ &
        & 0.25851e+02_r8,0.29803e+03_r8,0.41610e+03_r8,0.29583e+03_r8,0.35000e+02_r8 /)
      kbo(:, 4,16, 1) = (/ &
        & 0.25767e+02_r8,0.29792e+03_r8,0.41536e+03_r8,0.29502e+03_r8,0.35000e+02_r8 /)
      kbo(:, 5,16, 1) = (/ &
        & 0.25694e+02_r8,0.29776e+03_r8,0.41470e+03_r8,0.29430e+03_r8,0.35000e+02_r8 /)
      kbo(:, 1,17, 1) = (/ &
        & 0.25772e+02_r8,0.29785e+03_r8,0.41540e+03_r8,0.29506e+03_r8,0.35000e+02_r8 /)
      kbo(:, 2,17, 1) = (/ &
        & 0.25683e+02_r8,0.29787e+03_r8,0.41460e+03_r8,0.29419e+03_r8,0.35000e+02_r8 /)
      kbo(:, 3,17, 1) = (/ &
        & 0.25606e+02_r8,0.29784e+03_r8,0.41391e+03_r8,0.29343e+03_r8,0.35000e+02_r8 /)
      kbo(:, 4,17, 1) = (/ &
        & 0.25538e+02_r8,0.29774e+03_r8,0.41331e+03_r8,0.29277e+03_r8,0.35000e+02_r8 /)
      kbo(:, 5,17, 1) = (/ &
        & 0.25479e+02_r8,0.29758e+03_r8,0.41278e+03_r8,0.29219e+03_r8,0.35000e+02_r8 /)
      kbo(:, 1,18, 1) = (/ &
        & 0.25541e+02_r8,0.29768e+03_r8,0.41334e+03_r8,0.29280e+03_r8,0.35000e+02_r8 /)
      kbo(:, 2,18, 1) = (/ &
        & 0.25469e+02_r8,0.29772e+03_r8,0.41269e+03_r8,0.29209e+03_r8,0.35000e+02_r8 /)
      kbo(:, 3,18, 1) = (/ &
        & 0.25407e+02_r8,0.29768e+03_r8,0.41213e+03_r8,0.29147e+03_r8,0.35000e+02_r8 /)
      kbo(:, 4,18, 1) = (/ &
        & 0.25353e+02_r8,0.29758e+03_r8,0.41163e+03_r8,0.29094e+03_r8,0.35000e+02_r8 /)
      kbo(:, 5,18, 1) = (/ &
        & 0.25305e+02_r8,0.29743e+03_r8,0.41120e+03_r8,0.29046e+03_r8,0.35000e+02_r8 /)
      kbo(:, 1,19, 1) = (/ &
        & 0.25354e+02_r8,0.29755e+03_r8,0.41165e+03_r8,0.29095e+03_r8,0.35000e+02_r8 /)
      kbo(:, 2,19, 1) = (/ &
        & 0.25296e+02_r8,0.29758e+03_r8,0.41112e+03_r8,0.29037e+03_r8,0.35000e+02_r8 /)
      kbo(:, 3,19, 1) = (/ &
        & 0.25245e+02_r8,0.29755e+03_r8,0.41067e+03_r8,0.28988e+03_r8,0.35000e+02_r8 /)
      kbo(:, 4,19, 1) = (/ &
        & 0.25201e+02_r8,0.29746e+03_r8,0.41027e+03_r8,0.28944e+03_r8,0.35000e+02_r8 /)
      kbo(:, 5,19, 1) = (/ &
        & 0.25163e+02_r8,0.29730e+03_r8,0.40991e+03_r8,0.28905e+03_r8,0.35000e+02_r8 /)
      kbo(:, 1,20, 1) = (/ &
        & 0.25201e+02_r8,0.29744e+03_r8,0.41026e+03_r8,0.28943e+03_r8,0.35000e+02_r8 /)
      kbo(:, 2,20, 1) = (/ &
        & 0.25154e+02_r8,0.29748e+03_r8,0.40984e+03_r8,0.28897e+03_r8,0.35000e+02_r8 /)
      kbo(:, 3,20, 1) = (/ &
        & 0.25113e+02_r8,0.29745e+03_r8,0.40947e+03_r8,0.28856e+03_r8,0.35000e+02_r8 /)
      kbo(:, 4,20, 1) = (/ &
        & 0.25078e+02_r8,0.29735e+03_r8,0.40914e+03_r8,0.28821e+03_r8,0.35000e+02_r8 /)
      kbo(:, 5,20, 1) = (/ &
        & 0.25047e+02_r8,0.29719e+03_r8,0.40886e+03_r8,0.28790e+03_r8,0.35000e+02_r8 /)
      kbo(:, 1,21, 1) = (/ &
        & 0.25076e+02_r8,0.29736e+03_r8,0.40913e+03_r8,0.28819e+03_r8,0.35000e+02_r8 /)
      kbo(:, 2,21, 1) = (/ &
        & 0.25039e+02_r8,0.29739e+03_r8,0.40879e+03_r8,0.28782e+03_r8,0.35000e+02_r8 /)
      kbo(:, 3,21, 1) = (/ &
        & 0.25006e+02_r8,0.29736e+03_r8,0.40849e+03_r8,0.28749e+03_r8,0.35000e+02_r8 /)
      kbo(:, 4,21, 1) = (/ &
        & 0.24978e+02_r8,0.29726e+03_r8,0.40823e+03_r8,0.28722e+03_r8,0.35000e+02_r8 /)
      kbo(:, 5,21, 1) = (/ &
        & 0.24952e+02_r8,0.29710e+03_r8,0.40800e+03_r8,0.28695e+03_r8,0.35000e+02_r8 /)
      kbo(:, 1,22, 1) = (/ &
        & 0.24973e+02_r8,0.29729e+03_r8,0.40819e+03_r8,0.28717e+03_r8,0.35000e+02_r8 /)
      kbo(:, 2,22, 1) = (/ &
        & 0.24944e+02_r8,0.29732e+03_r8,0.40792e+03_r8,0.28687e+03_r8,0.35000e+02_r8 /)
      kbo(:, 3,22, 1) = (/ &
        & 0.24917e+02_r8,0.29728e+03_r8,0.40768e+03_r8,0.28661e+03_r8,0.35000e+02_r8 /)
      kbo(:, 4,22, 1) = (/ &
        & 0.24895e+02_r8,0.29717e+03_r8,0.40747e+03_r8,0.28638e+03_r8,0.35000e+02_r8 /)
      kbo(:, 5,22, 1) = (/ &
        & 0.24874e+02_r8,0.29700e+03_r8,0.40728e+03_r8,0.28618e+03_r8,0.35000e+02_r8 /)
      kbo(:, 1,23, 1) = (/ &
        & 0.24890e+02_r8,0.29724e+03_r8,0.40743e+03_r8,0.28634e+03_r8,0.35000e+02_r8 /)
      kbo(:, 2,23, 1) = (/ &
        & 0.24866e+02_r8,0.29726e+03_r8,0.40721e+03_r8,0.28610e+03_r8,0.35000e+02_r8 /)
      kbo(:, 3,23, 1) = (/ &
        & 0.24846e+02_r8,0.29721e+03_r8,0.40702e+03_r8,0.28589e+03_r8,0.35000e+02_r8 /)
      kbo(:, 4,23, 1) = (/ &
        & 0.24827e+02_r8,0.29710e+03_r8,0.40685e+03_r8,0.28571e+03_r8,0.35000e+02_r8 /)
      kbo(:, 5,23, 1) = (/ &
        & 0.24811e+02_r8,0.29692e+03_r8,0.40671e+03_r8,0.28554e+03_r8,0.35000e+02_r8 /)
      kbo(:, 1,24, 1) = (/ &
        & 0.24823e+02_r8,0.29721e+03_r8,0.40681e+03_r8,0.28566e+03_r8,0.35000e+02_r8 /)
      kbo(:, 2,24, 1) = (/ &
        & 0.24804e+02_r8,0.29721e+03_r8,0.40664e+03_r8,0.28547e+03_r8,0.35000e+02_r8 /)
      kbo(:, 3,24, 1) = (/ &
        & 0.24787e+02_r8,0.29715e+03_r8,0.40649e+03_r8,0.28530e+03_r8,0.35000e+02_r8 /)
      kbo(:, 4,24, 1) = (/ &
        & 0.24773e+02_r8,0.29703e+03_r8,0.40635e+03_r8,0.28516e+03_r8,0.35000e+02_r8 /)
      kbo(:, 5,24, 1) = (/ &
        & 0.24760e+02_r8,0.29684e+03_r8,0.40623e+03_r8,0.28503e+03_r8,0.35000e+02_r8 /)
      kbo(:, 1,25, 1) = (/ &
        & 0.24769e+02_r8,0.29717e+03_r8,0.40631e+03_r8,0.28511e+03_r8,0.35000e+02_r8 /)
      kbo(:, 2,25, 1) = (/ &
        & 0.24753e+02_r8,0.29717e+03_r8,0.40618e+03_r8,0.28496e+03_r8,0.35000e+02_r8 /)
      kbo(:, 3,25, 1) = (/ &
        & 0.24740e+02_r8,0.29710e+03_r8,0.40606e+03_r8,0.28483e+03_r8,0.35000e+02_r8 /)
      kbo(:, 4,25, 1) = (/ &
        & 0.24729e+02_r8,0.29696e+03_r8,0.40595e+03_r8,0.28472e+03_r8,0.35000e+02_r8 /)
      kbo(:, 5,25, 1) = (/ &
        & 0.24718e+02_r8,0.29676e+03_r8,0.40585e+03_r8,0.28462e+03_r8,0.35000e+02_r8 /)
      kbo(:, 1,26, 1) = (/ &
        & 0.24724e+02_r8,0.29715e+03_r8,0.40591e+03_r8,0.28467e+03_r8,0.35000e+02_r8 /)
      kbo(:, 2,26, 1) = (/ &
        & 0.24712e+02_r8,0.29713e+03_r8,0.40580e+03_r8,0.28456e+03_r8,0.35000e+02_r8 /)
      kbo(:, 3,26, 1) = (/ &
        & 0.24702e+02_r8,0.29704e+03_r8,0.40570e+03_r8,0.28445e+03_r8,0.35000e+02_r8 /)
      kbo(:, 4,26, 1) = (/ &
        & 0.24693e+02_r8,0.29689e+03_r8,0.40562e+03_r8,0.28435e+03_r8,0.35000e+02_r8 /)
      kbo(:, 5,26, 1) = (/ &
        & 0.24684e+02_r8,0.29668e+03_r8,0.40554e+03_r8,0.28427e+03_r8,0.35000e+02_r8 /)
      kbo(:, 1,27, 1) = (/ &
        & 0.24689e+02_r8,0.29713e+03_r8,0.40558e+03_r8,0.28431e+03_r8,0.35000e+02_r8 /)
      kbo(:, 2,27, 1) = (/ &
        & 0.24679e+02_r8,0.29709e+03_r8,0.40550e+03_r8,0.28422e+03_r8,0.35000e+02_r8 /)
      kbo(:, 3,27, 1) = (/ &
        & 0.24671e+02_r8,0.29699e+03_r8,0.40542e+03_r8,0.28423e+03_r8,0.35000e+02_r8 /)
      kbo(:, 4,27, 1) = (/ &
        & 0.24664e+02_r8,0.29683e+03_r8,0.40535e+03_r8,0.28405e+03_r8,0.35000e+02_r8 /)
      kbo(:, 5,27, 1) = (/ &
        & 0.24657e+02_r8,0.29660e+03_r8,0.40529e+03_r8,0.28399e+03_r8,0.35000e+02_r8 /)
      kbo(:, 1,28, 1) = (/ &
        & 0.24660e+02_r8,0.29710e+03_r8,0.40532e+03_r8,0.28404e+03_r8,0.35000e+02_r8 /)
      kbo(:, 2,28, 1) = (/ &
        & 0.24653e+02_r8,0.29706e+03_r8,0.40525e+03_r8,0.28395e+03_r8,0.35000e+02_r8 /)
      kbo(:, 3,28, 1) = (/ &
        & 0.24646e+02_r8,0.29694e+03_r8,0.40519e+03_r8,0.28389e+03_r8,0.35000e+02_r8 /)
      kbo(:, 4,28, 1) = (/ &
        & 0.24640e+02_r8,0.29676e+03_r8,0.40514e+03_r8,0.28383e+03_r8,0.35000e+02_r8 /)
      kbo(:, 5,28, 1) = (/ &
        & 0.24635e+02_r8,0.29651e+03_r8,0.40509e+03_r8,0.28376e+03_r8,0.35000e+02_r8 /)
      kbo(:, 1,29, 1) = (/ &
        & 0.24637e+02_r8,0.29708e+03_r8,0.40511e+03_r8,0.28380e+03_r8,0.35000e+02_r8 /)
      kbo(:, 2,29, 1) = (/ &
        & 0.24631e+02_r8,0.29702e+03_r8,0.40505e+03_r8,0.28374e+03_r8,0.35000e+02_r8 /)
      kbo(:, 3,29, 1) = (/ &
        & 0.24626e+02_r8,0.29689e+03_r8,0.40500e+03_r8,0.28368e+03_r8,0.35000e+02_r8 /)
      kbo(:, 4,29, 1) = (/ &
        & 0.24621e+02_r8,0.29669e+03_r8,0.40496e+03_r8,0.28364e+03_r8,0.35000e+02_r8 /)
      kbo(:, 5,29, 1) = (/ &
        & 0.24617e+02_r8,0.29643e+03_r8,0.40492e+03_r8,0.28359e+03_r8,0.35000e+02_r8 /)
      kbo(:, 1,30, 1) = (/ &
        & 0.24619e+02_r8,0.29706e+03_r8,0.40494e+03_r8,0.28360e+03_r8,0.35000e+02_r8 /)
      kbo(:, 2,30, 1) = (/ &
        & 0.24614e+02_r8,0.29698e+03_r8,0.40489e+03_r8,0.28355e+03_r8,0.35000e+02_r8 /)
      kbo(:, 3,30, 1) = (/ &
        & 0.24610e+02_r8,0.29683e+03_r8,0.40485e+03_r8,0.28351e+03_r8,0.35000e+02_r8 /)
      kbo(:, 4,30, 1) = (/ &
        & 0.24606e+02_r8,0.29662e+03_r8,0.40482e+03_r8,0.28347e+03_r8,0.35000e+02_r8 /)
      kbo(:, 5,30, 1) = (/ &
        & 0.24603e+02_r8,0.29634e+03_r8,0.40479e+03_r8,0.28344e+03_r8,0.35000e+02_r8 /)
      kbo(:, 1,31, 1) = (/ &
        & 0.24604e+02_r8,0.29704e+03_r8,0.40480e+03_r8,0.28345e+03_r8,0.35000e+02_r8 /)
      kbo(:, 2,31, 1) = (/ &
        & 0.24600e+02_r8,0.29694e+03_r8,0.40477e+03_r8,0.28341e+03_r8,0.35000e+02_r8 /)
      kbo(:, 3,31, 1) = (/ &
        & 0.24597e+02_r8,0.29678e+03_r8,0.40473e+03_r8,0.28338e+03_r8,0.35000e+02_r8 /)
      kbo(:, 4,31, 1) = (/ &
        & 0.24594e+02_r8,0.29655e+03_r8,0.40471e+03_r8,0.28336e+03_r8,0.35000e+02_r8 /)
      kbo(:, 5,31, 1) = (/ &
        & 0.24591e+02_r8,0.29625e+03_r8,0.40468e+03_r8,0.28332e+03_r8,0.35000e+02_r8 /)
      kbo(:, 1,32, 1) = (/ &
        & 0.24592e+02_r8,0.29701e+03_r8,0.40469e+03_r8,0.28333e+03_r8,0.35000e+02_r8 /)
      kbo(:, 2,32, 1) = (/ &
        & 0.24589e+02_r8,0.29689e+03_r8,0.40466e+03_r8,0.28330e+03_r8,0.35000e+02_r8 /)
      kbo(:, 3,32, 1) = (/ &
        & 0.24586e+02_r8,0.29672e+03_r8,0.40464e+03_r8,0.28328e+03_r8,0.35000e+02_r8 /)
      kbo(:, 4,32, 1) = (/ &
        & 0.24584e+02_r8,0.29647e+03_r8,0.40461e+03_r8,0.28324e+03_r8,0.35000e+02_r8 /)
      kbo(:, 5,32, 1) = (/ &
        & 0.24582e+02_r8,0.29615e+03_r8,0.40459e+03_r8,0.28325e+03_r8,0.35000e+02_r8 /)
      kbo(:, 1,33, 1) = (/ &
        & 0.24582e+02_r8,0.29698e+03_r8,0.40460e+03_r8,0.28323e+03_r8,0.35000e+02_r8 /)
      kbo(:, 2,33, 1) = (/ &
        & 0.24580e+02_r8,0.29685e+03_r8,0.40458e+03_r8,0.28321e+03_r8,0.35000e+02_r8 /)
      kbo(:, 3,33, 1) = (/ &
        & 0.24578e+02_r8,0.29665e+03_r8,0.40456e+03_r8,0.28318e+03_r8,0.35000e+02_r8 /)
      kbo(:, 4,33, 1) = (/ &
        & 0.24576e+02_r8,0.29639e+03_r8,0.40454e+03_r8,0.28317e+03_r8,0.35000e+02_r8 /)
      kbo(:, 5,33, 1) = (/ &
        & 0.24574e+02_r8,0.29605e+03_r8,0.40452e+03_r8,0.28315e+03_r8,0.35000e+02_r8 /)
      kbo(:, 1,34, 1) = (/ &
        & 0.24574e+02_r8,0.29695e+03_r8,0.40453e+03_r8,0.28315e+03_r8,0.35000e+02_r8 /)
      kbo(:, 2,34, 1) = (/ &
        & 0.24572e+02_r8,0.29680e+03_r8,0.40451e+03_r8,0.28313e+03_r8,0.35000e+02_r8 /)
      kbo(:, 3,34, 1) = (/ &
        & 0.24571e+02_r8,0.29659e+03_r8,0.40449e+03_r8,0.28312e+03_r8,0.35000e+02_r8 /)
      kbo(:, 4,34, 1) = (/ &
        & 0.24569e+02_r8,0.29631e+03_r8,0.40448e+03_r8,0.28310e+03_r8,0.35000e+02_r8 /)
      kbo(:, 5,34, 1) = (/ &
        & 0.24568e+02_r8,0.29596e+03_r8,0.40447e+03_r8,0.28308e+03_r8,0.35000e+02_r8 /)
      kbo(:, 1,35, 1) = (/ &
        & 0.24568e+02_r8,0.29693e+03_r8,0.40447e+03_r8,0.28309e+03_r8,0.35000e+02_r8 /)
      kbo(:, 2,35, 1) = (/ &
        & 0.24567e+02_r8,0.29678e+03_r8,0.40446e+03_r8,0.28308e+03_r8,0.35000e+02_r8 /)
      kbo(:, 3,35, 1) = (/ &
        & 0.24565e+02_r8,0.29656e+03_r8,0.40444e+03_r8,0.28306e+03_r8,0.35000e+02_r8 /)
      kbo(:, 4,35, 1) = (/ &
        & 0.24564e+02_r8,0.29627e+03_r8,0.40443e+03_r8,0.28305e+03_r8,0.35000e+02_r8 /)
      kbo(:, 5,35, 1) = (/ &
        & 0.24563e+02_r8,0.29590e+03_r8,0.40442e+03_r8,0.28304e+03_r8,0.35000e+02_r8 /)
      kbo(:, 1,36, 1) = (/ &
        & 0.24563e+02_r8,0.29692e+03_r8,0.40443e+03_r8,0.28305e+03_r8,0.35000e+02_r8 /)
      kbo(:, 2,36, 1) = (/ &
        & 0.24562e+02_r8,0.29677e+03_r8,0.40442e+03_r8,0.28304e+03_r8,0.35000e+02_r8 /)
      kbo(:, 3,36, 1) = (/ &
        & 0.24561e+02_r8,0.29655e+03_r8,0.40440e+03_r8,0.28301e+03_r8,0.35000e+02_r8 /)
      kbo(:, 4,36, 1) = (/ &
        & 0.24560e+02_r8,0.29626e+03_r8,0.40440e+03_r8,0.28302e+03_r8,0.35000e+02_r8 /)
      kbo(:, 5,36, 1) = (/ &
        & 0.24559e+02_r8,0.29589e+03_r8,0.40439e+03_r8,0.28301e+03_r8,0.35000e+02_r8 /)
      kbo(:, 1,37, 1) = (/ &
        & 0.24560e+02_r8,0.29693e+03_r8,0.40439e+03_r8,0.28301e+03_r8,0.35000e+02_r8 /)
      kbo(:, 2,37, 1) = (/ &
        & 0.24559e+02_r8,0.29679e+03_r8,0.40438e+03_r8,0.28299e+03_r8,0.35000e+02_r8 /)
      kbo(:, 3,37, 1) = (/ &
        & 0.24558e+02_r8,0.29658e+03_r8,0.40437e+03_r8,0.28299e+03_r8,0.35000e+02_r8 /)
      kbo(:, 4,37, 1) = (/ &
        & 0.24557e+02_r8,0.29630e+03_r8,0.40437e+03_r8,0.28297e+03_r8,0.35000e+02_r8 /)
      kbo(:, 5,37, 1) = (/ &
        & 0.24556e+02_r8,0.29594e+03_r8,0.40436e+03_r8,0.28297e+03_r8,0.35000e+02_r8 /)
      kbo(:, 1,38, 1) = (/ &
        & 0.24557e+02_r8,0.29695e+03_r8,0.40436e+03_r8,0.28297e+03_r8,0.35000e+02_r8 /)
      kbo(:, 2,38, 1) = (/ &
        & 0.24556e+02_r8,0.29681e+03_r8,0.40436e+03_r8,0.28296e+03_r8,0.35000e+02_r8 /)
      kbo(:, 3,38, 1) = (/ &
        & 0.24555e+02_r8,0.29661e+03_r8,0.40435e+03_r8,0.28297e+03_r8,0.35000e+02_r8 /)
      kbo(:, 4,38, 1) = (/ &
        & 0.24554e+02_r8,0.29634e+03_r8,0.40434e+03_r8,0.28296e+03_r8,0.35000e+02_r8 /)
      kbo(:, 5,38, 1) = (/ &
        & 0.24554e+02_r8,0.29599e+03_r8,0.40434e+03_r8,0.28294e+03_r8,0.35000e+02_r8 /)
      kbo(:, 1,39, 1) = (/ &
        & 0.24554e+02_r8,0.29696e+03_r8,0.40434e+03_r8,0.28295e+03_r8,0.35000e+02_r8 /)
      kbo(:, 2,39, 1) = (/ &
        & 0.24553e+02_r8,0.29683e+03_r8,0.40433e+03_r8,0.28294e+03_r8,0.35000e+02_r8 /)
      kbo(:, 3,39, 1) = (/ &
        & 0.24553e+02_r8,0.29664e+03_r8,0.40433e+03_r8,0.28293e+03_r8,0.35000e+02_r8 /)
      kbo(:, 4,39, 1) = (/ &
        & 0.24552e+02_r8,0.29638e+03_r8,0.40432e+03_r8,0.28292e+03_r8,0.35000e+02_r8 /)
      kbo(:, 5,39, 1) = (/ &
        & 0.24552e+02_r8,0.29604e+03_r8,0.40432e+03_r8,0.28292e+03_r8,0.35000e+02_r8 /)
      kbo(:, 1,40, 1) = (/ &
        & 0.24552e+02_r8,0.29698e+03_r8,0.40432e+03_r8,0.28292e+03_r8,0.35000e+02_r8 /)
      kbo(:, 2,40, 1) = (/ &
        & 0.24551e+02_r8,0.29687e+03_r8,0.40432e+03_r8,0.28293e+03_r8,0.35000e+02_r8 /)
      kbo(:, 3,40, 1) = (/ &
        & 0.24551e+02_r8,0.29669e+03_r8,0.40431e+03_r8,0.28292e+03_r8,0.35000e+02_r8 /)
      kbo(:, 4,40, 1) = (/ &
        & 0.24550e+02_r8,0.29645e+03_r8,0.40431e+03_r8,0.28291e+03_r8,0.35000e+02_r8 /)
      kbo(:, 5,40, 1) = (/ &
        & 0.24550e+02_r8,0.29613e+03_r8,0.40430e+03_r8,0.28291e+03_r8,0.35000e+02_r8 /)
      kbo(:, 1,41, 1) = (/ &
        & 0.24550e+02_r8,0.29699e+03_r8,0.40431e+03_r8,0.28290e+03_r8,0.35000e+02_r8 /)
      kbo(:, 2,41, 1) = (/ &
        & 0.24550e+02_r8,0.29690e+03_r8,0.40430e+03_r8,0.28291e+03_r8,0.35000e+02_r8 /)
      kbo(:, 3,41, 1) = (/ &
        & 0.24549e+02_r8,0.29674e+03_r8,0.40430e+03_r8,0.28289e+03_r8,0.35000e+02_r8 /)
      kbo(:, 4,41, 1) = (/ &
        & 0.24549e+02_r8,0.29651e+03_r8,0.40429e+03_r8,0.28290e+03_r8,0.35000e+02_r8 /)
      kbo(:, 5,41, 1) = (/ &
        & 0.24549e+02_r8,0.29622e+03_r8,0.40429e+03_r8,0.28289e+03_r8,0.35000e+02_r8 /)
      kbo(:, 1,42, 1) = (/ &
        & 0.24549e+02_r8,0.29700e+03_r8,0.40429e+03_r8,0.28289e+03_r8,0.35000e+02_r8 /)
      kbo(:, 2,42, 1) = (/ &
        & 0.24549e+02_r8,0.29693e+03_r8,0.40429e+03_r8,0.28289e+03_r8,0.35000e+02_r8 /)
      kbo(:, 3,42, 1) = (/ &
        & 0.24548e+02_r8,0.29679e+03_r8,0.40429e+03_r8,0.28289e+03_r8,0.35000e+02_r8 /)
      kbo(:, 4,42, 1) = (/ &
        & 0.24548e+02_r8,0.29658e+03_r8,0.40428e+03_r8,0.28289e+03_r8,0.35000e+02_r8 /)
      kbo(:, 5,42, 1) = (/ &
        & 0.24547e+02_r8,0.29630e+03_r8,0.40428e+03_r8,0.28288e+03_r8,0.35000e+02_r8 /)
      kbo(:, 1,43, 1) = (/ &
        & 0.24548e+02_r8,0.29701e+03_r8,0.40428e+03_r8,0.28288e+03_r8,0.35000e+02_r8 /)
      kbo(:, 2,43, 1) = (/ &
        & 0.24547e+02_r8,0.29696e+03_r8,0.40428e+03_r8,0.28288e+03_r8,0.35000e+02_r8 /)
      kbo(:, 3,43, 1) = (/ &
        & 0.24547e+02_r8,0.29684e+03_r8,0.40428e+03_r8,0.28288e+03_r8,0.35000e+02_r8 /)
      kbo(:, 4,43, 1) = (/ &
        & 0.24547e+02_r8,0.29665e+03_r8,0.40427e+03_r8,0.28288e+03_r8,0.35000e+02_r8 /)
      kbo(:, 5,43, 1) = (/ &
        & 0.24547e+02_r8,0.29639e+03_r8,0.40427e+03_r8,0.28288e+03_r8,0.35000e+02_r8 /)
      kbo(:, 1,44, 1) = (/ &
        & 0.24547e+02_r8,0.29702e+03_r8,0.40427e+03_r8,0.28287e+03_r8,0.35000e+02_r8 /)
      kbo(:, 2,44, 1) = (/ &
        & 0.24547e+02_r8,0.29698e+03_r8,0.40427e+03_r8,0.28287e+03_r8,0.35000e+02_r8 /)
      kbo(:, 3,44, 1) = (/ &
        & 0.24546e+02_r8,0.29688e+03_r8,0.40427e+03_r8,0.28287e+03_r8,0.35000e+02_r8 /)
      kbo(:, 4,44, 1) = (/ &
        & 0.24546e+02_r8,0.29672e+03_r8,0.40427e+03_r8,0.28287e+03_r8,0.35000e+02_r8 /)
      kbo(:, 5,44, 1) = (/ &
        & 0.24546e+02_r8,0.29649e+03_r8,0.40426e+03_r8,0.28286e+03_r8,0.35000e+02_r8 /)
      kbo(:, 1,45, 1) = (/ &
        & 0.24546e+02_r8,0.29701e+03_r8,0.40427e+03_r8,0.28287e+03_r8,0.35000e+02_r8 /)
      kbo(:, 2,45, 1) = (/ &
        & 0.24546e+02_r8,0.29700e+03_r8,0.40426e+03_r8,0.28287e+03_r8,0.35000e+02_r8 /)
      kbo(:, 3,45, 1) = (/ &
        & 0.24546e+02_r8,0.29692e+03_r8,0.40426e+03_r8,0.28286e+03_r8,0.35000e+02_r8 /)
      kbo(:, 4,45, 1) = (/ &
        & 0.24545e+02_r8,0.29678e+03_r8,0.40426e+03_r8,0.28286e+03_r8,0.35000e+02_r8 /)
      kbo(:, 5,45, 1) = (/ &
        & 0.24545e+02_r8,0.29657e+03_r8,0.40426e+03_r8,0.28286e+03_r8,0.35000e+02_r8 /)
      kbo(:, 1,46, 1) = (/ &
        & 0.24545e+02_r8,0.29699e+03_r8,0.40426e+03_r8,0.28287e+03_r8,0.35000e+02_r8 /)
      kbo(:, 2,46, 1) = (/ &
        & 0.24545e+02_r8,0.29701e+03_r8,0.40426e+03_r8,0.28285e+03_r8,0.35000e+02_r8 /)
      kbo(:, 3,46, 1) = (/ &
        & 0.24545e+02_r8,0.29696e+03_r8,0.40426e+03_r8,0.28286e+03_r8,0.35000e+02_r8 /)
      kbo(:, 4,46, 1) = (/ &
        & 0.24545e+02_r8,0.29684e+03_r8,0.40425e+03_r8,0.28285e+03_r8,0.35000e+02_r8 /)
      kbo(:, 5,46, 1) = (/ &
        & 0.24545e+02_r8,0.29665e+03_r8,0.40425e+03_r8,0.28285e+03_r8,0.35000e+02_r8 /)
      kbo(:, 1,47, 1) = (/ &
        & 0.24545e+02_r8,0.29696e+03_r8,0.40425e+03_r8,0.28285e+03_r8,0.35000e+02_r8 /)
      kbo(:, 2,47, 1) = (/ &
        & 0.24545e+02_r8,0.29701e+03_r8,0.40425e+03_r8,0.28286e+03_r8,0.35000e+02_r8 /)
      kbo(:, 3,47, 1) = (/ &
        & 0.24544e+02_r8,0.29699e+03_r8,0.40425e+03_r8,0.28285e+03_r8,0.35000e+02_r8 /)
      kbo(:, 4,47, 1) = (/ &
        & 0.24544e+02_r8,0.29690e+03_r8,0.40425e+03_r8,0.28285e+03_r8,0.35000e+02_r8 /)
      kbo(:, 5,47, 1) = (/ &
        & 0.24544e+02_r8,0.29674e+03_r8,0.40425e+03_r8,0.28286e+03_r8,0.35000e+02_r8 /)
      kbo(:, 1,48, 1) = (/ &
        & 0.24544e+02_r8,0.29691e+03_r8,0.40425e+03_r8,0.28286e+03_r8,0.35000e+02_r8 /)
      kbo(:, 2,48, 1) = (/ &
        & 0.24544e+02_r8,0.29700e+03_r8,0.40425e+03_r8,0.28285e+03_r8,0.35000e+02_r8 /)
      kbo(:, 3,48, 1) = (/ &
        & 0.24544e+02_r8,0.29701e+03_r8,0.40425e+03_r8,0.28284e+03_r8,0.35000e+02_r8 /)
      kbo(:, 4,48, 1) = (/ &
        & 0.24544e+02_r8,0.29694e+03_r8,0.40425e+03_r8,0.28285e+03_r8,0.35000e+02_r8 /)
      kbo(:, 5,48, 1) = (/ &
        & 0.24544e+02_r8,0.29681e+03_r8,0.40425e+03_r8,0.28284e+03_r8,0.35000e+02_r8 /)
      kbo(:, 1,49, 1) = (/ &
        & 0.24544e+02_r8,0.29685e+03_r8,0.40425e+03_r8,0.28284e+03_r8,0.35000e+02_r8 /)
      kbo(:, 2,49, 1) = (/ &
        & 0.24544e+02_r8,0.29698e+03_r8,0.40425e+03_r8,0.28284e+03_r8,0.35000e+02_r8 /)
      kbo(:, 3,49, 1) = (/ &
        & 0.24544e+02_r8,0.29701e+03_r8,0.40424e+03_r8,0.28284e+03_r8,0.35000e+02_r8 /)
      kbo(:, 4,49, 1) = (/ &
        & 0.24544e+02_r8,0.29697e+03_r8,0.40424e+03_r8,0.28285e+03_r8,0.35000e+02_r8 /)
      kbo(:, 5,49, 1) = (/ &
        & 0.24544e+02_r8,0.29687e+03_r8,0.40424e+03_r8,0.28284e+03_r8,0.35000e+02_r8 /)
      kbo(:, 1,50, 1) = (/ &
        & 0.24544e+02_r8,0.29678e+03_r8,0.40424e+03_r8,0.28284e+03_r8,0.35000e+02_r8 /)
      kbo(:, 2,50, 1) = (/ &
        & 0.24544e+02_r8,0.29694e+03_r8,0.40424e+03_r8,0.28284e+03_r8,0.35000e+02_r8 /)
      kbo(:, 3,50, 1) = (/ &
        & 0.24543e+02_r8,0.29701e+03_r8,0.40424e+03_r8,0.28284e+03_r8,0.35000e+02_r8 /)
      kbo(:, 4,50, 1) = (/ &
        & 0.24543e+02_r8,0.29700e+03_r8,0.40424e+03_r8,0.28284e+03_r8,0.35000e+02_r8 /)
      kbo(:, 5,50, 1) = (/ &
        & 0.24543e+02_r8,0.29692e+03_r8,0.40424e+03_r8,0.28284e+03_r8,0.35000e+02_r8 /)
      kbo(:, 1,51, 1) = (/ &
        & 0.24543e+02_r8,0.29670e+03_r8,0.40424e+03_r8,0.28284e+03_r8,0.35000e+02_r8 /)
      kbo(:, 2,51, 1) = (/ &
        & 0.24543e+02_r8,0.29689e+03_r8,0.40424e+03_r8,0.28284e+03_r8,0.35000e+02_r8 /)
      kbo(:, 3,51, 1) = (/ &
        & 0.24543e+02_r8,0.29699e+03_r8,0.40424e+03_r8,0.28284e+03_r8,0.35000e+02_r8 /)
      kbo(:, 4,51, 1) = (/ &
        & 0.24543e+02_r8,0.29701e+03_r8,0.40424e+03_r8,0.28284e+03_r8,0.35000e+02_r8 /)
      kbo(:, 5,51, 1) = (/ &
        & 0.24543e+02_r8,0.29695e+03_r8,0.40424e+03_r8,0.28284e+03_r8,0.35000e+02_r8 /)
      kbo(:, 1,52, 1) = (/ &
        & 0.24543e+02_r8,0.29660e+03_r8,0.40424e+03_r8,0.28283e+03_r8,0.35000e+02_r8 /)
      kbo(:, 2,52, 1) = (/ &
        & 0.24543e+02_r8,0.29684e+03_r8,0.40424e+03_r8,0.28283e+03_r8,0.35000e+02_r8 /)
      kbo(:, 3,52, 1) = (/ &
        & 0.24543e+02_r8,0.29697e+03_r8,0.40424e+03_r8,0.28283e+03_r8,0.35000e+02_r8 /)
      kbo(:, 4,52, 1) = (/ &
        & 0.24543e+02_r8,0.29701e+03_r8,0.40424e+03_r8,0.28283e+03_r8,0.35000e+02_r8 /)
      kbo(:, 5,52, 1) = (/ &
        & 0.24543e+02_r8,0.29698e+03_r8,0.40424e+03_r8,0.28283e+03_r8,0.35000e+02_r8 /)
      kbo(:, 1,53, 1) = (/ &
        & 0.24543e+02_r8,0.29648e+03_r8,0.40424e+03_r8,0.28283e+03_r8,0.35000e+02_r8 /)
      kbo(:, 2,53, 1) = (/ &
        & 0.24543e+02_r8,0.29676e+03_r8,0.40424e+03_r8,0.28283e+03_r8,0.35000e+02_r8 /)
      kbo(:, 3,53, 1) = (/ &
        & 0.24543e+02_r8,0.29693e+03_r8,0.40424e+03_r8,0.28284e+03_r8,0.35000e+02_r8 /)
      kbo(:, 4,53, 1) = (/ &
        & 0.24543e+02_r8,0.29701e+03_r8,0.40424e+03_r8,0.28283e+03_r8,0.35000e+02_r8 /)
      kbo(:, 5,53, 1) = (/ &
        & 0.24543e+02_r8,0.29700e+03_r8,0.40424e+03_r8,0.28284e+03_r8,0.35000e+02_r8 /)
      kbo(:, 1,54, 1) = (/ &
        & 0.24543e+02_r8,0.29635e+03_r8,0.40424e+03_r8,0.28283e+03_r8,0.35000e+02_r8 /)
      kbo(:, 2,54, 1) = (/ &
        & 0.24543e+02_r8,0.29668e+03_r8,0.40424e+03_r8,0.28284e+03_r8,0.35000e+02_r8 /)
      kbo(:, 3,54, 1) = (/ &
        & 0.24543e+02_r8,0.29688e+03_r8,0.40424e+03_r8,0.28283e+03_r8,0.35000e+02_r8 /)
      kbo(:, 4,54, 1) = (/ &
        & 0.24543e+02_r8,0.29699e+03_r8,0.40423e+03_r8,0.28283e+03_r8,0.35000e+02_r8 /)
      kbo(:, 5,54, 1) = (/ &
        & 0.24543e+02_r8,0.29701e+03_r8,0.40423e+03_r8,0.28285e+03_r8,0.35000e+02_r8 /)
      kbo(:, 1,55, 1) = (/ &
        & 0.24543e+02_r8,0.29622e+03_r8,0.40424e+03_r8,0.28285e+03_r8,0.35000e+02_r8 /)
      kbo(:, 2,55, 1) = (/ &
        & 0.24543e+02_r8,0.29659e+03_r8,0.40423e+03_r8,0.28283e+03_r8,0.35000e+02_r8 /)
      kbo(:, 3,55, 1) = (/ &
        & 0.24543e+02_r8,0.29683e+03_r8,0.40423e+03_r8,0.28284e+03_r8,0.35000e+02_r8 /)
      kbo(:, 4,55, 1) = (/ &
        & 0.24543e+02_r8,0.29696e+03_r8,0.40423e+03_r8,0.28283e+03_r8,0.35000e+02_r8 /)
      kbo(:, 5,55, 1) = (/ &
        & 0.24543e+02_r8,0.29701e+03_r8,0.40423e+03_r8,0.28283e+03_r8,0.35000e+02_r8 /)
      kbo(:, 1,56, 1) = (/ &
        & 0.24543e+02_r8,0.29607e+03_r8,0.40423e+03_r8,0.28283e+03_r8,0.35000e+02_r8 /)
      kbo(:, 2,56, 1) = (/ &
        & 0.24543e+02_r8,0.29649e+03_r8,0.40423e+03_r8,0.28283e+03_r8,0.35000e+02_r8 /)
      kbo(:, 3,56, 1) = (/ &
        & 0.24543e+02_r8,0.29676e+03_r8,0.40423e+03_r8,0.28283e+03_r8,0.35000e+02_r8 /)
      kbo(:, 4,56, 1) = (/ &
        & 0.24542e+02_r8,0.29693e+03_r8,0.40423e+03_r8,0.28282e+03_r8,0.35000e+02_r8 /)
      kbo(:, 5,56, 1) = (/ &
        & 0.24542e+02_r8,0.29700e+03_r8,0.40423e+03_r8,0.28283e+03_r8,0.35000e+02_r8 /)
      kbo(:, 1,57, 1) = (/ &
        & 0.24543e+02_r8,0.29591e+03_r8,0.40423e+03_r8,0.28283e+03_r8,0.35000e+02_r8 /)
      kbo(:, 2,57, 1) = (/ &
        & 0.24542e+02_r8,0.29637e+03_r8,0.40423e+03_r8,0.28283e+03_r8,0.35000e+02_r8 /)
      kbo(:, 3,57, 1) = (/ &
        & 0.24542e+02_r8,0.29669e+03_r8,0.40423e+03_r8,0.28283e+03_r8,0.35000e+02_r8 /)
      kbo(:, 4,57, 1) = (/ &
        & 0.24542e+02_r8,0.29689e+03_r8,0.40423e+03_r8,0.28283e+03_r8,0.35000e+02_r8 /)
      kbo(:, 5,57, 1) = (/ &
        & 0.24542e+02_r8,0.29699e+03_r8,0.40423e+03_r8,0.28283e+03_r8,0.35000e+02_r8 /)
      kbo(:, 1,58, 1) = (/ &
        & 0.24542e+02_r8,0.29574e+03_r8,0.40423e+03_r8,0.28282e+03_r8,0.35000e+02_r8 /)
      kbo(:, 2,58, 1) = (/ &
        & 0.24542e+02_r8,0.29624e+03_r8,0.40423e+03_r8,0.28282e+03_r8,0.35000e+02_r8 /)
      kbo(:, 3,58, 1) = (/ &
        & 0.24542e+02_r8,0.29660e+03_r8,0.40423e+03_r8,0.28283e+03_r8,0.35000e+02_r8 /)
      kbo(:, 4,58, 1) = (/ &
        & 0.24542e+02_r8,0.29684e+03_r8,0.40423e+03_r8,0.28284e+03_r8,0.35000e+02_r8 /)
      kbo(:, 5,58, 1) = (/ &
        & 0.24542e+02_r8,0.29697e+03_r8,0.40423e+03_r8,0.28282e+03_r8,0.35000e+02_r8 /)
      kbo(:, 1,59, 1) = (/ &
        & 0.24542e+02_r8,0.29566e+03_r8,0.40423e+03_r8,0.28283e+03_r8,0.35000e+02_r8 /)
      kbo(:, 2,59, 1) = (/ &
        & 0.24542e+02_r8,0.29619e+03_r8,0.40423e+03_r8,0.28282e+03_r8,0.35000e+02_r8 /)
      kbo(:, 3,59, 1) = (/ &
        & 0.24542e+02_r8,0.29657e+03_r8,0.40423e+03_r8,0.28283e+03_r8,0.35000e+02_r8 /)
      kbo(:, 4,59, 1) = (/ &
        & 0.24542e+02_r8,0.29682e+03_r8,0.40423e+03_r8,0.28283e+03_r8,0.35000e+02_r8 /)
      kbo(:, 5,59, 1) = (/ &
        & 0.24542e+02_r8,0.29696e+03_r8,0.40423e+03_r8,0.28283e+03_r8,0.35000e+02_r8 /)
      kbo(:, 1,13, 2) = (/ &
        & 0.10177e+03_r8,0.32761e+03_r8,0.45575e+03_r8,0.31335e+03_r8,0.71839e+02_r8 /)
      kbo(:, 2,13, 2) = (/ &
        & 0.10099e+03_r8,0.32713e+03_r8,0.45383e+03_r8,0.31125e+03_r8,0.71839e+02_r8 /)
      kbo(:, 3,13, 2) = (/ &
        & 0.10031e+03_r8,0.32663e+03_r8,0.45216e+03_r8,0.30943e+03_r8,0.71839e+02_r8 /)
      kbo(:, 4,13, 2) = (/ &
        & 0.99721e+02_r8,0.32612e+03_r8,0.45071e+03_r8,0.30785e+03_r8,0.71839e+02_r8 /)
      kbo(:, 5,13, 2) = (/ &
        & 0.99204e+02_r8,0.32558e+03_r8,0.44942e+03_r8,0.30646e+03_r8,0.71839e+02_r8 /)
      kbo(:, 1,14, 2) = (/ &
        & 0.99803e+02_r8,0.32613e+03_r8,0.45091e+03_r8,0.30807e+03_r8,0.71839e+02_r8 /)
      kbo(:, 2,14, 2) = (/ &
        & 0.99169e+02_r8,0.32574e+03_r8,0.44934e+03_r8,0.30636e+03_r8,0.71839e+02_r8 /)
      kbo(:, 3,14, 2) = (/ &
        & 0.98622e+02_r8,0.32534e+03_r8,0.44797e+03_r8,0.30489e+03_r8,0.71839e+02_r8 /)
      kbo(:, 4,14, 2) = (/ &
        & 0.98146e+02_r8,0.32491e+03_r8,0.44677e+03_r8,0.30362e+03_r8,0.71839e+02_r8 /)
      kbo(:, 5,14, 2) = (/ &
        & 0.97728e+02_r8,0.32444e+03_r8,0.44571e+03_r8,0.30248e+03_r8,0.71839e+02_r8 /)
      kbo(:, 1,15, 2) = (/ &
        & 0.98198e+02_r8,0.32493e+03_r8,0.44690e+03_r8,0.30375e+03_r8,0.71839e+02_r8 /)
      kbo(:, 2,15, 2) = (/ &
        & 0.97687e+02_r8,0.32462e+03_r8,0.44560e+03_r8,0.30237e+03_r8,0.71839e+02_r8 /)
      kbo(:, 3,15, 2) = (/ &
        & 0.97245e+02_r8,0.32429e+03_r8,0.44448e+03_r8,0.30119e+03_r8,0.71839e+02_r8 /)
      kbo(:, 4,15, 2) = (/ &
        & 0.96861e+02_r8,0.32392e+03_r8,0.44350e+03_r8,0.30014e+03_r8,0.71839e+02_r8 /)
      kbo(:, 5,15, 2) = (/ &
        & 0.96523e+02_r8,0.32350e+03_r8,0.44263e+03_r8,0.29923e+03_r8,0.71839e+02_r8 /)
      kbo(:, 1,16, 2) = (/ &
        & 0.96892e+02_r8,0.32395e+03_r8,0.44358e+03_r8,0.30023e+03_r8,0.71839e+02_r8 /)
      kbo(:, 2,16, 2) = (/ &
        & 0.96480e+02_r8,0.32371e+03_r8,0.44252e+03_r8,0.29912e+03_r8,0.71839e+02_r8 /)
      kbo(:, 3,16, 2) = (/ &
        & 0.96125e+02_r8,0.32343e+03_r8,0.44161e+03_r8,0.29817e+03_r8,0.71839e+02_r8 /)
      kbo(:, 4,16, 2) = (/ &
        & 0.95814e+02_r8,0.32311e+03_r8,0.44081e+03_r8,0.29733e+03_r8,0.71839e+02_r8 /)
      kbo(:, 5,16, 2) = (/ &
        & 0.95541e+02_r8,0.32273e+03_r8,0.44010e+03_r8,0.29661e+03_r8,0.71839e+02_r8 /)
      kbo(:, 1,17, 2) = (/ &
        & 0.95833e+02_r8,0.32316e+03_r8,0.44086e+03_r8,0.29737e+03_r8,0.71839e+02_r8 /)
      kbo(:, 2,17, 2) = (/ &
        & 0.95501e+02_r8,0.32297e+03_r8,0.44000e+03_r8,0.29648e+03_r8,0.71839e+02_r8 /)
      kbo(:, 3,17, 2) = (/ &
        & 0.95214e+02_r8,0.32274e+03_r8,0.43925e+03_r8,0.29569e+03_r8,0.71839e+02_r8 /)
      kbo(:, 4,17, 2) = (/ &
        & 0.94964e+02_r8,0.32245e+03_r8,0.43860e+03_r8,0.29502e+03_r8,0.71839e+02_r8 /)
      kbo(:, 5,17, 2) = (/ &
        & 0.94743e+02_r8,0.32210e+03_r8,0.43803e+03_r8,0.29442e+03_r8,0.71839e+02_r8 /)
      kbo(:, 1,18, 2) = (/ &
        & 0.94974e+02_r8,0.32251e+03_r8,0.43863e+03_r8,0.29504e+03_r8,0.71839e+02_r8 /)
      kbo(:, 2,18, 2) = (/ &
        & 0.94707e+02_r8,0.32236e+03_r8,0.43793e+03_r8,0.29432e+03_r8,0.71839e+02_r8 /)
      kbo(:, 3,18, 2) = (/ &
        & 0.94475e+02_r8,0.32217e+03_r8,0.43733e+03_r8,0.29369e+03_r8,0.71839e+02_r8 /)
      kbo(:, 4,18, 2) = (/ &
        & 0.94272e+02_r8,0.32191e+03_r8,0.43680e+03_r8,0.29315e+03_r8,0.71839e+02_r8 /)
      kbo(:, 5,18, 2) = (/ &
        & 0.94094e+02_r8,0.32158e+03_r8,0.43633e+03_r8,0.29267e+03_r8,0.71839e+02_r8 /)
      kbo(:, 1,19, 2) = (/ &
        & 0.94277e+02_r8,0.32199e+03_r8,0.43681e+03_r8,0.29316e+03_r8,0.71839e+02_r8 /)
      kbo(:, 2,19, 2) = (/ &
        & 0.94061e+02_r8,0.32187e+03_r8,0.43624e+03_r8,0.29258e+03_r8,0.71839e+02_r8 /)
      kbo(:, 3,19, 2) = (/ &
        & 0.93874e+02_r8,0.32170e+03_r8,0.43575e+03_r8,0.29207e+03_r8,0.71839e+02_r8 /)
      kbo(:, 4,19, 2) = (/ &
        & 0.93711e+02_r8,0.32146e+03_r8,0.43532e+03_r8,0.29164e+03_r8,0.71839e+02_r8 /)
      kbo(:, 5,19, 2) = (/ &
        & 0.93566e+02_r8,0.32115e+03_r8,0.43494e+03_r8,0.29125e+03_r8,0.71839e+02_r8 /)
      kbo(:, 1,20, 2) = (/ &
        & 0.93708e+02_r8,0.32157e+03_r8,0.43531e+03_r8,0.29163e+03_r8,0.71839e+02_r8 /)
      kbo(:, 2,20, 2) = (/ &
        & 0.93534e+02_r8,0.32147e+03_r8,0.43485e+03_r8,0.29117e+03_r8,0.71839e+02_r8 /)
      kbo(:, 3,20, 2) = (/ &
        & 0.93383e+02_r8,0.32132e+03_r8,0.43445e+03_r8,0.29076e+03_r8,0.71839e+02_r8 /)
      kbo(:, 4,20, 2) = (/ &
        & 0.93251e+02_r8,0.32109e+03_r8,0.43411e+03_r8,0.29041e+03_r8,0.71839e+02_r8 /)
      kbo(:, 5,20, 2) = (/ &
        & 0.93135e+02_r8,0.32079e+03_r8,0.43380e+03_r8,0.29010e+03_r8,0.71839e+02_r8 /)
      kbo(:, 1,21, 2) = (/ &
        & 0.93246e+02_r8,0.32122e+03_r8,0.43409e+03_r8,0.29040e+03_r8,0.71839e+02_r8 /)
      kbo(:, 2,21, 2) = (/ &
        & 0.93106e+02_r8,0.32114e+03_r8,0.43372e+03_r8,0.29003e+03_r8,0.71839e+02_r8 /)
      kbo(:, 3,21, 2) = (/ &
        & 0.92985e+02_r8,0.32100e+03_r8,0.43340e+03_r8,0.28970e+03_r8,0.71839e+02_r8 /)
      kbo(:, 4,21, 2) = (/ &
        & 0.92878e+02_r8,0.32079e+03_r8,0.43311e+03_r8,0.28941e+03_r8,0.71839e+02_r8 /)
      kbo(:, 5,21, 2) = (/ &
        & 0.92784e+02_r8,0.32049e+03_r8,0.43286e+03_r8,0.28917e+03_r8,0.71839e+02_r8 /)
      kbo(:, 1,22, 2) = (/ &
        & 0.92863e+02_r8,0.32094e+03_r8,0.43307e+03_r8,0.28938e+03_r8,0.71839e+02_r8 /)
      kbo(:, 2,22, 2) = (/ &
        & 0.92751e+02_r8,0.32087e+03_r8,0.43278e+03_r8,0.28908e+03_r8,0.71839e+02_r8 /)
      kbo(:, 3,22, 2) = (/ &
        & 0.92655e+02_r8,0.32073e+03_r8,0.43252e+03_r8,0.28882e+03_r8,0.71839e+02_r8 /)
      kbo(:, 4,22, 2) = (/ &
        & 0.92569e+02_r8,0.32051e+03_r8,0.43229e+03_r8,0.28860e+03_r8,0.71839e+02_r8 /)
      kbo(:, 5,22, 2) = (/ &
        & 0.92494e+02_r8,0.32022e+03_r8,0.43209e+03_r8,0.28840e+03_r8,0.71839e+02_r8 /)
      kbo(:, 1,23, 2) = (/ &
        & 0.92553e+02_r8,0.32072e+03_r8,0.43225e+03_r8,0.28855e+03_r8,0.71839e+02_r8 /)
      kbo(:, 2,23, 2) = (/ &
        & 0.92465e+02_r8,0.32064e+03_r8,0.43201e+03_r8,0.28832e+03_r8,0.71839e+02_r8 /)
      kbo(:, 3,23, 2) = (/ &
        & 0.92387e+02_r8,0.32050e+03_r8,0.43180e+03_r8,0.28811e+03_r8,0.71839e+02_r8 /)
      kbo(:, 4,23, 2) = (/ &
        & 0.92319e+02_r8,0.32029e+03_r8,0.43162e+03_r8,0.28793e+03_r8,0.71839e+02_r8 /)
      kbo(:, 5,23, 2) = (/ &
        & 0.92259e+02_r8,0.31998e+03_r8,0.43146e+03_r8,0.28778e+03_r8,0.71839e+02_r8 /)
      kbo(:, 1,24, 2) = (/ &
        & 0.92303e+02_r8,0.32053e+03_r8,0.43158e+03_r8,0.28789e+03_r8,0.71839e+02_r8 /)
      kbo(:, 2,24, 2) = (/ &
        & 0.92233e+02_r8,0.32046e+03_r8,0.43139e+03_r8,0.28770e+03_r8,0.71839e+02_r8 /)
      kbo(:, 3,24, 2) = (/ &
        & 0.92171e+02_r8,0.32031e+03_r8,0.43122e+03_r8,0.28754e+03_r8,0.71839e+02_r8 /)
      kbo(:, 4,24, 2) = (/ &
        & 0.92117e+02_r8,0.32009e+03_r8,0.43108e+03_r8,0.28740e+03_r8,0.71839e+02_r8 /)
      kbo(:, 5,24, 2) = (/ &
        & 0.92068e+02_r8,0.31978e+03_r8,0.43095e+03_r8,0.28727e+03_r8,0.71839e+02_r8 /)
      kbo(:, 1,25, 2) = (/ &
        & 0.92101e+02_r8,0.32038e+03_r8,0.43103e+03_r8,0.28736e+03_r8,0.71839e+02_r8 /)
      kbo(:, 2,25, 2) = (/ &
        & 0.92045e+02_r8,0.32030e+03_r8,0.43088e+03_r8,0.28721e+03_r8,0.71839e+02_r8 /)
      kbo(:, 3,25, 2) = (/ &
        & 0.91996e+02_r8,0.32015e+03_r8,0.43075e+03_r8,0.28708e+03_r8,0.71839e+02_r8 /)
      kbo(:, 4,25, 2) = (/ &
        & 0.91952e+02_r8,0.31991e+03_r8,0.43064e+03_r8,0.28696e+03_r8,0.71839e+02_r8 /)
      kbo(:, 5,25, 2) = (/ &
        & 0.91914e+02_r8,0.31959e+03_r8,0.43053e+03_r8,0.28684e+03_r8,0.71839e+02_r8 /)
      kbo(:, 1,26, 2) = (/ &
        & 0.91937e+02_r8,0.32025e+03_r8,0.43059e+03_r8,0.28693e+03_r8,0.71839e+02_r8 /)
      kbo(:, 2,26, 2) = (/ &
        & 0.91892e+02_r8,0.32016e+03_r8,0.43047e+03_r8,0.28680e+03_r8,0.71839e+02_r8 /)
      kbo(:, 3,26, 2) = (/ &
        & 0.91853e+02_r8,0.32000e+03_r8,0.43037e+03_r8,0.28670e+03_r8,0.71839e+02_r8 /)
      kbo(:, 4,26, 2) = (/ &
        & 0.91819e+02_r8,0.31975e+03_r8,0.43028e+03_r8,0.28661e+03_r8,0.71839e+02_r8 /)
      kbo(:, 5,26, 2) = (/ &
        & 0.91788e+02_r8,0.31942e+03_r8,0.43019e+03_r8,0.28653e+03_r8,0.71839e+02_r8 /)
      kbo(:, 1,27, 2) = (/ &
        & 0.91805e+02_r8,0.32015e+03_r8,0.43024e+03_r8,0.28658e+03_r8,0.71839e+02_r8 /)
      kbo(:, 2,27, 2) = (/ &
        & 0.91770e+02_r8,0.32005e+03_r8,0.43014e+03_r8,0.28648e+03_r8,0.71839e+02_r8 /)
      kbo(:, 3,27, 2) = (/ &
        & 0.91738e+02_r8,0.31986e+03_r8,0.43006e+03_r8,0.28630e+03_r8,0.71839e+02_r8 /)
      kbo(:, 4,27, 2) = (/ &
        & 0.91711e+02_r8,0.31960e+03_r8,0.42998e+03_r8,0.28633e+03_r8,0.71839e+02_r8 /)
      kbo(:, 5,27, 2) = (/ &
        & 0.91687e+02_r8,0.31925e+03_r8,0.42992e+03_r8,0.28626e+03_r8,0.71839e+02_r8 /)
      kbo(:, 1,28, 2) = (/ &
        & 0.91698e+02_r8,0.32005e+03_r8,0.42995e+03_r8,0.28628e+03_r8,0.71839e+02_r8 /)
      kbo(:, 2,28, 2) = (/ &
        & 0.91670e+02_r8,0.31994e+03_r8,0.42987e+03_r8,0.28622e+03_r8,0.71839e+02_r8 /)
      kbo(:, 3,28, 2) = (/ &
        & 0.91646e+02_r8,0.31974e+03_r8,0.42981e+03_r8,0.28615e+03_r8,0.71839e+02_r8 /)
      kbo(:, 4,28, 2) = (/ &
        & 0.91624e+02_r8,0.31946e+03_r8,0.42975e+03_r8,0.28609e+03_r8,0.71839e+02_r8 /)
      kbo(:, 5,28, 2) = (/ &
        & 0.91604e+02_r8,0.31910e+03_r8,0.42970e+03_r8,0.28605e+03_r8,0.71839e+02_r8 /)
      kbo(:, 1,29, 2) = (/ &
        & 0.91613e+02_r8,0.31997e+03_r8,0.42972e+03_r8,0.28605e+03_r8,0.71839e+02_r8 /)
      kbo(:, 2,29, 2) = (/ &
        & 0.91591e+02_r8,0.31984e+03_r8,0.42966e+03_r8,0.28600e+03_r8,0.71839e+02_r8 /)
      kbo(:, 3,29, 2) = (/ &
        & 0.91571e+02_r8,0.31963e+03_r8,0.42960e+03_r8,0.28595e+03_r8,0.71839e+02_r8 /)
      kbo(:, 4,29, 2) = (/ &
        & 0.91554e+02_r8,0.31933e+03_r8,0.42956e+03_r8,0.28590e+03_r8,0.71839e+02_r8 /)
      kbo(:, 5,29, 2) = (/ &
        & 0.91538e+02_r8,0.31895e+03_r8,0.42952e+03_r8,0.28586e+03_r8,0.71839e+02_r8 /)
      kbo(:, 1,30, 2) = (/ &
        & 0.91544e+02_r8,0.31990e+03_r8,0.42953e+03_r8,0.28589e+03_r8,0.71839e+02_r8 /)
      kbo(:, 2,30, 2) = (/ &
        & 0.91526e+02_r8,0.31975e+03_r8,0.42948e+03_r8,0.28584e+03_r8,0.71839e+02_r8 /)
      kbo(:, 3,30, 2) = (/ &
        & 0.91511e+02_r8,0.31952e+03_r8,0.42944e+03_r8,0.28580e+03_r8,0.71839e+02_r8 /)
      kbo(:, 4,30, 2) = (/ &
        & 0.91497e+02_r8,0.31920e+03_r8,0.42940e+03_r8,0.28577e+03_r8,0.71839e+02_r8 /)
      kbo(:, 5,30, 2) = (/ &
        & 0.91484e+02_r8,0.31880e+03_r8,0.42937e+03_r8,0.28573e+03_r8,0.71839e+02_r8 /)
      kbo(:, 1,31, 2) = (/ &
        & 0.91488e+02_r8,0.31983e+03_r8,0.42938e+03_r8,0.28574e+03_r8,0.71839e+02_r8 /)
      kbo(:, 2,31, 2) = (/ &
        & 0.91474e+02_r8,0.31966e+03_r8,0.42934e+03_r8,0.28571e+03_r8,0.71839e+02_r8 /)
      kbo(:, 3,31, 2) = (/ &
        & 0.91462e+02_r8,0.31941e+03_r8,0.42931e+03_r8,0.28567e+03_r8,0.71839e+02_r8 /)
      kbo(:, 4,31, 2) = (/ &
        & 0.91451e+02_r8,0.31908e+03_r8,0.42928e+03_r8,0.28564e+03_r8,0.71839e+02_r8 /)
      kbo(:, 5,31, 2) = (/ &
        & 0.91441e+02_r8,0.31866e+03_r8,0.42925e+03_r8,0.28562e+03_r8,0.71839e+02_r8 /)
      kbo(:, 1,32, 2) = (/ &
        & 0.91443e+02_r8,0.31976e+03_r8,0.42926e+03_r8,0.28562e+03_r8,0.71839e+02_r8 /)
      kbo(:, 2,32, 2) = (/ &
        & 0.91432e+02_r8,0.31958e+03_r8,0.42923e+03_r8,0.28559e+03_r8,0.71839e+02_r8 /)
      kbo(:, 3,32, 2) = (/ &
        & 0.91423e+02_r8,0.31930e+03_r8,0.42920e+03_r8,0.28557e+03_r8,0.71839e+02_r8 /)
      kbo(:, 4,32, 2) = (/ &
        & 0.91414e+02_r8,0.31895e+03_r8,0.42918e+03_r8,0.28555e+03_r8,0.71839e+02_r8 /)
      kbo(:, 5,32, 2) = (/ &
        & 0.91406e+02_r8,0.31851e+03_r8,0.42916e+03_r8,0.28551e+03_r8,0.71839e+02_r8 /)
      kbo(:, 1,33, 2) = (/ &
        & 0.91407e+02_r8,0.31970e+03_r8,0.42916e+03_r8,0.28553e+03_r8,0.71839e+02_r8 /)
      kbo(:, 2,33, 2) = (/ &
        & 0.91399e+02_r8,0.31949e+03_r8,0.42914e+03_r8,0.28551e+03_r8,0.71839e+02_r8 /)
      kbo(:, 3,33, 2) = (/ &
        & 0.91391e+02_r8,0.31920e+03_r8,0.42912e+03_r8,0.28549e+03_r8,0.71839e+02_r8 /)
      kbo(:, 4,33, 2) = (/ &
        & 0.91384e+02_r8,0.31882e+03_r8,0.42910e+03_r8,0.28547e+03_r8,0.71839e+02_r8 /)
      kbo(:, 5,33, 2) = (/ &
        & 0.91378e+02_r8,0.31837e+03_r8,0.42908e+03_r8,0.28546e+03_r8,0.71839e+02_r8 /)
      kbo(:, 1,34, 2) = (/ &
        & 0.91379e+02_r8,0.31964e+03_r8,0.42908e+03_r8,0.28546e+03_r8,0.71839e+02_r8 /)
      kbo(:, 2,34, 2) = (/ &
        & 0.91372e+02_r8,0.31941e+03_r8,0.42906e+03_r8,0.28544e+03_r8,0.71839e+02_r8 /)
      kbo(:, 3,34, 2) = (/ &
        & 0.91365e+02_r8,0.31910e+03_r8,0.42905e+03_r8,0.28542e+03_r8,0.71839e+02_r8 /)
      kbo(:, 4,34, 2) = (/ &
        & 0.91360e+02_r8,0.31871e+03_r8,0.42903e+03_r8,0.28541e+03_r8,0.71839e+02_r8 /)
      kbo(:, 5,34, 2) = (/ &
        & 0.91355e+02_r8,0.31824e+03_r8,0.42902e+03_r8,0.28540e+03_r8,0.71839e+02_r8 /)
      kbo(:, 1,35, 2) = (/ &
        & 0.91356e+02_r8,0.31960e+03_r8,0.42902e+03_r8,0.28539e+03_r8,0.71839e+02_r8 /)
      kbo(:, 2,35, 2) = (/ &
        & 0.91350e+02_r8,0.31936e+03_r8,0.42901e+03_r8,0.28538e+03_r8,0.71839e+02_r8 /)
      kbo(:, 3,35, 2) = (/ &
        & 0.91345e+02_r8,0.31904e+03_r8,0.42899e+03_r8,0.28537e+03_r8,0.71839e+02_r8 /)
      kbo(:, 4,35, 2) = (/ &
        & 0.91341e+02_r8,0.31863e+03_r8,0.42898e+03_r8,0.28535e+03_r8,0.71839e+02_r8 /)
      kbo(:, 5,35, 2) = (/ &
        & 0.91337e+02_r8,0.31816e+03_r8,0.42897e+03_r8,0.28535e+03_r8,0.71839e+02_r8 /)
      kbo(:, 1,36, 2) = (/ &
        & 0.91338e+02_r8,0.31958e+03_r8,0.42897e+03_r8,0.28535e+03_r8,0.71839e+02_r8 /)
      kbo(:, 2,36, 2) = (/ &
        & 0.91334e+02_r8,0.31934e+03_r8,0.42896e+03_r8,0.28533e+03_r8,0.71839e+02_r8 /)
      kbo(:, 3,36, 2) = (/ &
        & 0.91330e+02_r8,0.31902e+03_r8,0.42895e+03_r8,0.28533e+03_r8,0.71839e+02_r8 /)
      kbo(:, 4,36, 2) = (/ &
        & 0.91326e+02_r8,0.31862e+03_r8,0.42894e+03_r8,0.28530e+03_r8,0.71839e+02_r8 /)
      kbo(:, 5,36, 2) = (/ &
        & 0.91323e+02_r8,0.31814e+03_r8,0.42893e+03_r8,0.28530e+03_r8,0.71839e+02_r8 /)
      kbo(:, 1,37, 2) = (/ &
        & 0.91324e+02_r8,0.31959e+03_r8,0.42894e+03_r8,0.28531e+03_r8,0.71839e+02_r8 /)
      kbo(:, 2,37, 2) = (/ &
        & 0.91320e+02_r8,0.31937e+03_r8,0.42893e+03_r8,0.28530e+03_r8,0.71839e+02_r8 /)
      kbo(:, 3,37, 2) = (/ &
        & 0.91317e+02_r8,0.31906e+03_r8,0.42892e+03_r8,0.28529e+03_r8,0.71839e+02_r8 /)
      kbo(:, 4,37, 2) = (/ &
        & 0.91314e+02_r8,0.31866e+03_r8,0.42891e+03_r8,0.28529e+03_r8,0.71839e+02_r8 /)
      kbo(:, 5,37, 2) = (/ &
        & 0.91311e+02_r8,0.31819e+03_r8,0.42890e+03_r8,0.28527e+03_r8,0.71839e+02_r8 /)
      kbo(:, 1,38, 2) = (/ &
        & 0.91313e+02_r8,0.31961e+03_r8,0.42890e+03_r8,0.28528e+03_r8,0.71839e+02_r8 /)
      kbo(:, 2,38, 2) = (/ &
        & 0.91310e+02_r8,0.31939e+03_r8,0.42890e+03_r8,0.28528e+03_r8,0.71839e+02_r8 /)
      kbo(:, 3,38, 2) = (/ &
        & 0.91307e+02_r8,0.31910e+03_r8,0.42889e+03_r8,0.28526e+03_r8,0.71839e+02_r8 /)
      kbo(:, 4,38, 2) = (/ &
        & 0.91304e+02_r8,0.31871e+03_r8,0.42888e+03_r8,0.28525e+03_r8,0.71839e+02_r8 /)
      kbo(:, 5,38, 2) = (/ &
        & 0.91302e+02_r8,0.31826e+03_r8,0.42888e+03_r8,0.28525e+03_r8,0.71839e+02_r8 /)
      kbo(:, 1,39, 2) = (/ &
        & 0.91303e+02_r8,0.31962e+03_r8,0.42888e+03_r8,0.28525e+03_r8,0.71839e+02_r8 /)
      kbo(:, 2,39, 2) = (/ &
        & 0.91301e+02_r8,0.31942e+03_r8,0.42887e+03_r8,0.28525e+03_r8,0.71839e+02_r8 /)
      kbo(:, 3,39, 2) = (/ &
        & 0.91298e+02_r8,0.31914e+03_r8,0.42886e+03_r8,0.28525e+03_r8,0.71839e+02_r8 /)
      kbo(:, 4,39, 2) = (/ &
        & 0.91296e+02_r8,0.31877e+03_r8,0.42886e+03_r8,0.28524e+03_r8,0.71839e+02_r8 /)
      kbo(:, 5,39, 2) = (/ &
        & 0.91294e+02_r8,0.31832e+03_r8,0.42885e+03_r8,0.28523e+03_r8,0.71839e+02_r8 /)
      kbo(:, 1,40, 2) = (/ &
        & 0.91296e+02_r8,0.31965e+03_r8,0.42886e+03_r8,0.28524e+03_r8,0.71839e+02_r8 /)
      kbo(:, 2,40, 2) = (/ &
        & 0.91293e+02_r8,0.31947e+03_r8,0.42885e+03_r8,0.28522e+03_r8,0.71839e+02_r8 /)
      kbo(:, 3,40, 2) = (/ &
        & 0.91292e+02_r8,0.31921e+03_r8,0.42885e+03_r8,0.28522e+03_r8,0.71839e+02_r8 /)
      kbo(:, 4,40, 2) = (/ &
        & 0.91290e+02_r8,0.31886e+03_r8,0.42884e+03_r8,0.28522e+03_r8,0.71839e+02_r8 /)
      kbo(:, 5,40, 2) = (/ &
        & 0.91288e+02_r8,0.31843e+03_r8,0.42884e+03_r8,0.28521e+03_r8,0.71839e+02_r8 /)
      kbo(:, 1,41, 2) = (/ &
        & 0.91289e+02_r8,0.31968e+03_r8,0.42884e+03_r8,0.28523e+03_r8,0.71839e+02_r8 /)
      kbo(:, 2,41, 2) = (/ &
        & 0.91288e+02_r8,0.31952e+03_r8,0.42884e+03_r8,0.28521e+03_r8,0.71839e+02_r8 /)
      kbo(:, 3,41, 2) = (/ &
        & 0.91286e+02_r8,0.31928e+03_r8,0.42883e+03_r8,0.28522e+03_r8,0.71839e+02_r8 /)
      kbo(:, 4,41, 2) = (/ &
        & 0.91284e+02_r8,0.31895e+03_r8,0.42883e+03_r8,0.28521e+03_r8,0.71839e+02_r8 /)
      kbo(:, 5,41, 2) = (/ &
        & 0.91283e+02_r8,0.31854e+03_r8,0.42882e+03_r8,0.28521e+03_r8,0.71839e+02_r8 /)
      kbo(:, 1,42, 2) = (/ &
        & 0.91284e+02_r8,0.31970e+03_r8,0.42883e+03_r8,0.28521e+03_r8,0.71839e+02_r8 /)
      kbo(:, 2,42, 2) = (/ &
        & 0.91283e+02_r8,0.31957e+03_r8,0.42882e+03_r8,0.28521e+03_r8,0.71839e+02_r8 /)
      kbo(:, 3,42, 2) = (/ &
        & 0.91281e+02_r8,0.31934e+03_r8,0.42882e+03_r8,0.28520e+03_r8,0.71839e+02_r8 /)
      kbo(:, 4,42, 2) = (/ &
        & 0.91280e+02_r8,0.31904e+03_r8,0.42882e+03_r8,0.28519e+03_r8,0.71839e+02_r8 /)
      kbo(:, 5,42, 2) = (/ &
        & 0.91279e+02_r8,0.31865e+03_r8,0.42881e+03_r8,0.28520e+03_r8,0.71839e+02_r8 /)
      kbo(:, 1,43, 2) = (/ &
        & 0.91280e+02_r8,0.31972e+03_r8,0.42882e+03_r8,0.28520e+03_r8,0.71839e+02_r8 /)
      kbo(:, 2,43, 2) = (/ &
        & 0.91279e+02_r8,0.31961e+03_r8,0.42881e+03_r8,0.28520e+03_r8,0.71839e+02_r8 /)
      kbo(:, 3,43, 2) = (/ &
        & 0.91277e+02_r8,0.31942e+03_r8,0.42881e+03_r8,0.28519e+03_r8,0.71839e+02_r8 /)
      kbo(:, 4,43, 2) = (/ &
        & 0.91276e+02_r8,0.31914e+03_r8,0.42881e+03_r8,0.28518e+03_r8,0.71839e+02_r8 /)
      kbo(:, 5,43, 2) = (/ &
        & 0.91275e+02_r8,0.31878e+03_r8,0.42880e+03_r8,0.28518e+03_r8,0.71839e+02_r8 /)
      kbo(:, 1,44, 2) = (/ &
        & 0.91276e+02_r8,0.31974e+03_r8,0.42881e+03_r8,0.28519e+03_r8,0.71839e+02_r8 /)
      kbo(:, 2,44, 2) = (/ &
        & 0.91275e+02_r8,0.31966e+03_r8,0.42880e+03_r8,0.28519e+03_r8,0.71839e+02_r8 /)
      kbo(:, 3,44, 2) = (/ &
        & 0.91274e+02_r8,0.31949e+03_r8,0.42880e+03_r8,0.28518e+03_r8,0.71839e+02_r8 /)
      kbo(:, 4,44, 2) = (/ &
        & 0.91273e+02_r8,0.31924e+03_r8,0.42880e+03_r8,0.28518e+03_r8,0.71839e+02_r8 /)
      kbo(:, 5,44, 2) = (/ &
        & 0.91273e+02_r8,0.31890e+03_r8,0.42880e+03_r8,0.28518e+03_r8,0.71839e+02_r8 /)
      kbo(:, 1,45, 2) = (/ &
        & 0.91274e+02_r8,0.31974e+03_r8,0.42880e+03_r8,0.28518e+03_r8,0.71839e+02_r8 /)
      kbo(:, 2,45, 2) = (/ &
        & 0.91273e+02_r8,0.31969e+03_r8,0.42880e+03_r8,0.28517e+03_r8,0.71839e+02_r8 /)
      kbo(:, 3,45, 2) = (/ &
        & 0.91272e+02_r8,0.31955e+03_r8,0.42879e+03_r8,0.28518e+03_r8,0.71839e+02_r8 /)
      kbo(:, 4,45, 2) = (/ &
        & 0.91271e+02_r8,0.31933e+03_r8,0.42879e+03_r8,0.28517e+03_r8,0.71839e+02_r8 /)
      kbo(:, 5,45, 2) = (/ &
        & 0.91270e+02_r8,0.31903e+03_r8,0.42879e+03_r8,0.28517e+03_r8,0.71839e+02_r8 /)
      kbo(:, 1,46, 2) = (/ &
        & 0.91271e+02_r8,0.31974e+03_r8,0.42879e+03_r8,0.28516e+03_r8,0.71839e+02_r8 /)
      kbo(:, 2,46, 2) = (/ &
        & 0.91270e+02_r8,0.31972e+03_r8,0.42879e+03_r8,0.28517e+03_r8,0.71839e+02_r8 /)
      kbo(:, 3,46, 2) = (/ &
        & 0.91270e+02_r8,0.31961e+03_r8,0.42879e+03_r8,0.28517e+03_r8,0.71839e+02_r8 /)
      kbo(:, 4,46, 2) = (/ &
        & 0.91269e+02_r8,0.31942e+03_r8,0.42879e+03_r8,0.28517e+03_r8,0.71839e+02_r8 /)
      kbo(:, 5,46, 2) = (/ &
        & 0.91268e+02_r8,0.31914e+03_r8,0.42878e+03_r8,0.28516e+03_r8,0.71839e+02_r8 /)
      kbo(:, 1,47, 2) = (/ &
        & 0.91269e+02_r8,0.31973e+03_r8,0.42879e+03_r8,0.28517e+03_r8,0.71839e+02_r8 /)
      kbo(:, 2,47, 2) = (/ &
        & 0.91268e+02_r8,0.31974e+03_r8,0.42878e+03_r8,0.28516e+03_r8,0.71839e+02_r8 /)
      kbo(:, 3,47, 2) = (/ &
        & 0.91268e+02_r8,0.31966e+03_r8,0.42878e+03_r8,0.28516e+03_r8,0.71839e+02_r8 /)
      kbo(:, 4,47, 2) = (/ &
        & 0.91267e+02_r8,0.31951e+03_r8,0.42878e+03_r8,0.28516e+03_r8,0.71839e+02_r8 /)
      kbo(:, 5,47, 2) = (/ &
        & 0.91267e+02_r8,0.31926e+03_r8,0.42878e+03_r8,0.28515e+03_r8,0.71839e+02_r8 /)
      kbo(:, 1,48, 2) = (/ &
        & 0.91267e+02_r8,0.31970e+03_r8,0.42878e+03_r8,0.28516e+03_r8,0.71839e+02_r8 /)
      kbo(:, 2,48, 2) = (/ &
        & 0.91267e+02_r8,0.31974e+03_r8,0.42878e+03_r8,0.28516e+03_r8,0.71839e+02_r8 /)
      kbo(:, 3,48, 2) = (/ &
        & 0.91266e+02_r8,0.31970e+03_r8,0.42878e+03_r8,0.28517e+03_r8,0.71839e+02_r8 /)
      kbo(:, 4,48, 2) = (/ &
        & 0.91266e+02_r8,0.31958e+03_r8,0.42878e+03_r8,0.28515e+03_r8,0.71839e+02_r8 /)
      kbo(:, 5,48, 2) = (/ &
        & 0.91265e+02_r8,0.31937e+03_r8,0.42878e+03_r8,0.28516e+03_r8,0.71839e+02_r8 /)
      kbo(:, 1,49, 2) = (/ &
        & 0.91266e+02_r8,0.31966e+03_r8,0.42878e+03_r8,0.28516e+03_r8,0.71839e+02_r8 /)
      kbo(:, 2,49, 2) = (/ &
        & 0.91265e+02_r8,0.31973e+03_r8,0.42878e+03_r8,0.28516e+03_r8,0.71839e+02_r8 /)
      kbo(:, 3,49, 2) = (/ &
        & 0.91265e+02_r8,0.31973e+03_r8,0.42877e+03_r8,0.28516e+03_r8,0.71839e+02_r8 /)
      kbo(:, 4,49, 2) = (/ &
        & 0.91265e+02_r8,0.31964e+03_r8,0.42878e+03_r8,0.28515e+03_r8,0.71839e+02_r8 /)
      kbo(:, 5,49, 2) = (/ &
        & 0.91264e+02_r8,0.31946e+03_r8,0.42877e+03_r8,0.28515e+03_r8,0.71839e+02_r8 /)
      kbo(:, 1,50, 2) = (/ &
        & 0.91265e+02_r8,0.31962e+03_r8,0.42877e+03_r8,0.28516e+03_r8,0.71839e+02_r8 /)
      kbo(:, 2,50, 2) = (/ &
        & 0.91264e+02_r8,0.31972e+03_r8,0.42877e+03_r8,0.28515e+03_r8,0.71839e+02_r8 /)
      kbo(:, 3,50, 2) = (/ &
        & 0.91264e+02_r8,0.31974e+03_r8,0.42877e+03_r8,0.28515e+03_r8,0.71839e+02_r8 /)
      kbo(:, 4,50, 2) = (/ &
        & 0.91264e+02_r8,0.31968e+03_r8,0.42877e+03_r8,0.28515e+03_r8,0.71839e+02_r8 /)
      kbo(:, 5,50, 2) = (/ &
        & 0.91263e+02_r8,0.31954e+03_r8,0.42877e+03_r8,0.28515e+03_r8,0.71839e+02_r8 /)
      kbo(:, 1,51, 2) = (/ &
        & 0.91264e+02_r8,0.31958e+03_r8,0.42877e+03_r8,0.28515e+03_r8,0.71839e+02_r8 /)
      kbo(:, 2,51, 2) = (/ &
        & 0.91263e+02_r8,0.31969e+03_r8,0.42877e+03_r8,0.28515e+03_r8,0.71839e+02_r8 /)
      kbo(:, 3,51, 2) = (/ &
        & 0.91263e+02_r8,0.31974e+03_r8,0.42877e+03_r8,0.28515e+03_r8,0.71839e+02_r8 /)
      kbo(:, 4,51, 2) = (/ &
        & 0.91263e+02_r8,0.31971e+03_r8,0.42877e+03_r8,0.28515e+03_r8,0.71839e+02_r8 /)
      kbo(:, 5,51, 2) = (/ &
        & 0.91262e+02_r8,0.31960e+03_r8,0.42877e+03_r8,0.28515e+03_r8,0.71839e+02_r8 /)
      kbo(:, 1,52, 2) = (/ &
        & 0.91263e+02_r8,0.31953e+03_r8,0.42877e+03_r8,0.28515e+03_r8,0.71839e+02_r8 /)
      kbo(:, 2,52, 2) = (/ &
        & 0.91263e+02_r8,0.31965e+03_r8,0.42877e+03_r8,0.28515e+03_r8,0.71839e+02_r8 /)
      kbo(:, 3,52, 2) = (/ &
        & 0.91262e+02_r8,0.31973e+03_r8,0.42877e+03_r8,0.28515e+03_r8,0.71839e+02_r8 /)
      kbo(:, 4,52, 2) = (/ &
        & 0.91262e+02_r8,0.31973e+03_r8,0.42877e+03_r8,0.28515e+03_r8,0.71839e+02_r8 /)
      kbo(:, 5,52, 2) = (/ &
        & 0.91262e+02_r8,0.31965e+03_r8,0.42877e+03_r8,0.28515e+03_r8,0.71839e+02_r8 /)
      kbo(:, 1,53, 2) = (/ &
        & 0.91262e+02_r8,0.31948e+03_r8,0.42877e+03_r8,0.28515e+03_r8,0.71839e+02_r8 /)
      kbo(:, 2,53, 2) = (/ &
        & 0.91262e+02_r8,0.31961e+03_r8,0.42877e+03_r8,0.28515e+03_r8,0.71839e+02_r8 /)
      kbo(:, 3,53, 2) = (/ &
        & 0.91262e+02_r8,0.31971e+03_r8,0.42877e+03_r8,0.28515e+03_r8,0.71839e+02_r8 /)
      kbo(:, 4,53, 2) = (/ &
        & 0.91261e+02_r8,0.31974e+03_r8,0.42876e+03_r8,0.28515e+03_r8,0.71839e+02_r8 /)
      kbo(:, 5,53, 2) = (/ &
        & 0.91261e+02_r8,0.31969e+03_r8,0.42876e+03_r8,0.28514e+03_r8,0.71839e+02_r8 /)
      kbo(:, 1,54, 2) = (/ &
        & 0.91262e+02_r8,0.31942e+03_r8,0.42877e+03_r8,0.28515e+03_r8,0.71839e+02_r8 /)
      kbo(:, 2,54, 2) = (/ &
        & 0.91261e+02_r8,0.31957e+03_r8,0.42877e+03_r8,0.28514e+03_r8,0.71839e+02_r8 /)
      kbo(:, 3,54, 2) = (/ &
        & 0.91261e+02_r8,0.31968e+03_r8,0.42876e+03_r8,0.28515e+03_r8,0.71839e+02_r8 /)
      kbo(:, 4,54, 2) = (/ &
        & 0.91261e+02_r8,0.31973e+03_r8,0.42876e+03_r8,0.28515e+03_r8,0.71839e+02_r8 /)
      kbo(:, 5,54, 2) = (/ &
        & 0.91261e+02_r8,0.31971e+03_r8,0.42876e+03_r8,0.28513e+03_r8,0.71839e+02_r8 /)
      kbo(:, 1,55, 2) = (/ &
        & 0.91261e+02_r8,0.31937e+03_r8,0.42876e+03_r8,0.28513e+03_r8,0.71839e+02_r8 /)
      kbo(:, 2,55, 2) = (/ &
        & 0.91261e+02_r8,0.31953e+03_r8,0.42876e+03_r8,0.28515e+03_r8,0.71839e+02_r8 /)
      kbo(:, 3,55, 2) = (/ &
        & 0.91261e+02_r8,0.31965e+03_r8,0.42876e+03_r8,0.28513e+03_r8,0.71839e+02_r8 /)
      kbo(:, 4,55, 2) = (/ &
        & 0.91261e+02_r8,0.31973e+03_r8,0.42876e+03_r8,0.28514e+03_r8,0.71839e+02_r8 /)
      kbo(:, 5,55, 2) = (/ &
        & 0.91260e+02_r8,0.31973e+03_r8,0.42876e+03_r8,0.28515e+03_r8,0.71839e+02_r8 /)
      kbo(:, 1,56, 2) = (/ &
        & 0.91261e+02_r8,0.31932e+03_r8,0.42876e+03_r8,0.28514e+03_r8,0.71839e+02_r8 /)
      kbo(:, 2,56, 2) = (/ &
        & 0.91260e+02_r8,0.31947e+03_r8,0.42876e+03_r8,0.28515e+03_r8,0.71839e+02_r8 /)
      kbo(:, 3,56, 2) = (/ &
        & 0.91260e+02_r8,0.31961e+03_r8,0.42876e+03_r8,0.28515e+03_r8,0.71839e+02_r8 /)
      kbo(:, 4,56, 2) = (/ &
        & 0.91260e+02_r8,0.31971e+03_r8,0.42876e+03_r8,0.28515e+03_r8,0.71839e+02_r8 /)
      kbo(:, 5,56, 2) = (/ &
        & 0.91260e+02_r8,0.31974e+03_r8,0.42876e+03_r8,0.28515e+03_r8,0.71839e+02_r8 /)
      kbo(:, 1,57, 2) = (/ &
        & 0.91260e+02_r8,0.31927e+03_r8,0.42876e+03_r8,0.28514e+03_r8,0.71839e+02_r8 /)
      kbo(:, 2,57, 2) = (/ &
        & 0.91260e+02_r8,0.31943e+03_r8,0.42876e+03_r8,0.28514e+03_r8,0.71839e+02_r8 /)
      kbo(:, 3,57, 2) = (/ &
        & 0.91260e+02_r8,0.31957e+03_r8,0.42876e+03_r8,0.28515e+03_r8,0.71839e+02_r8 /)
      kbo(:, 4,57, 2) = (/ &
        & 0.91260e+02_r8,0.31968e+03_r8,0.42876e+03_r8,0.28514e+03_r8,0.71839e+02_r8 /)
      kbo(:, 5,57, 2) = (/ &
        & 0.91260e+02_r8,0.31974e+03_r8,0.42876e+03_r8,0.28514e+03_r8,0.71839e+02_r8 /)
      kbo(:, 1,58, 2) = (/ &
        & 0.91260e+02_r8,0.31922e+03_r8,0.42876e+03_r8,0.28515e+03_r8,0.71839e+02_r8 /)
      kbo(:, 2,58, 2) = (/ &
        & 0.91260e+02_r8,0.31938e+03_r8,0.42876e+03_r8,0.28515e+03_r8,0.71839e+02_r8 /)
      kbo(:, 3,58, 2) = (/ &
        & 0.91260e+02_r8,0.31953e+03_r8,0.42876e+03_r8,0.28514e+03_r8,0.71839e+02_r8 /)
      kbo(:, 4,58, 2) = (/ &
        & 0.91260e+02_r8,0.31965e+03_r8,0.42876e+03_r8,0.28513e+03_r8,0.71839e+02_r8 /)
      kbo(:, 5,58, 2) = (/ &
        & 0.91260e+02_r8,0.31973e+03_r8,0.42876e+03_r8,0.28515e+03_r8,0.71839e+02_r8 /)
      kbo(:, 1,59, 2) = (/ &
        & 0.91260e+02_r8,0.31920e+03_r8,0.42876e+03_r8,0.28514e+03_r8,0.71839e+02_r8 /)
      kbo(:, 2,59, 2) = (/ &
        & 0.91260e+02_r8,0.31936e+03_r8,0.42876e+03_r8,0.28515e+03_r8,0.71839e+02_r8 /)
      kbo(:, 3,59, 2) = (/ &
        & 0.91259e+02_r8,0.31952e+03_r8,0.42876e+03_r8,0.28515e+03_r8,0.71839e+02_r8 /)
      kbo(:, 4,59, 2) = (/ &
        & 0.91259e+02_r8,0.31964e+03_r8,0.42876e+03_r8,0.28514e+03_r8,0.71839e+02_r8 /)
      kbo(:, 5,59, 2) = (/ &
        & 0.91259e+02_r8,0.31972e+03_r8,0.42876e+03_r8,0.28514e+03_r8,0.71839e+02_r8 /)
      kbo(:, 1,13, 3) = (/ &
        & 0.26463e+03_r8,0.36163e+03_r8,0.49889e+03_r8,0.32504e+03_r8,0.17829e+03_r8 /)
      kbo(:, 2,13, 3) = (/ &
        & 0.26258e+03_r8,0.36010e+03_r8,0.49695e+03_r8,0.32345e+03_r8,0.17829e+03_r8 /)
      kbo(:, 3,13, 3) = (/ &
        & 0.26083e+03_r8,0.35879e+03_r8,0.49519e+03_r8,0.32209e+03_r8,0.17829e+03_r8 /)
      kbo(:, 4,13, 3) = (/ &
        & 0.25930e+03_r8,0.35766e+03_r8,0.49360e+03_r8,0.32093e+03_r8,0.17829e+03_r8 /)
      kbo(:, 5,13, 3) = (/ &
        & 0.25795e+03_r8,0.35666e+03_r8,0.49217e+03_r8,0.31991e+03_r8,0.17829e+03_r8 /)
      kbo(:, 1,14, 3) = (/ &
        & 0.25951e+03_r8,0.35782e+03_r8,0.49358e+03_r8,0.32109e+03_r8,0.17829e+03_r8 /)
      kbo(:, 2,14, 3) = (/ &
        & 0.25786e+03_r8,0.35659e+03_r8,0.49191e+03_r8,0.31984e+03_r8,0.17829e+03_r8 /)
      kbo(:, 3,14, 3) = (/ &
        & 0.25644e+03_r8,0.35554e+03_r8,0.49043e+03_r8,0.31877e+03_r8,0.17829e+03_r8 /)
      kbo(:, 4,14, 3) = (/ &
        & 0.25520e+03_r8,0.35461e+03_r8,0.48912e+03_r8,0.31784e+03_r8,0.17829e+03_r8 /)
      kbo(:, 5,14, 3) = (/ &
        & 0.25411e+03_r8,0.35381e+03_r8,0.48795e+03_r8,0.31704e+03_r8,0.17829e+03_r8 /)
      kbo(:, 1,15, 3) = (/ &
        & 0.25534e+03_r8,0.35471e+03_r8,0.48908e+03_r8,0.31794e+03_r8,0.17829e+03_r8 /)
      kbo(:, 2,15, 3) = (/ &
        & 0.25401e+03_r8,0.35373e+03_r8,0.48771e+03_r8,0.31695e+03_r8,0.17829e+03_r8 /)
      kbo(:, 3,15, 3) = (/ &
        & 0.25286e+03_r8,0.35287e+03_r8,0.48651e+03_r8,0.31610e+03_r8,0.17829e+03_r8 /)
      kbo(:, 4,15, 3) = (/ &
        & 0.25186e+03_r8,0.35213e+03_r8,0.48543e+03_r8,0.31537e+03_r8,0.17829e+03_r8 /)
      kbo(:, 5,15, 3) = (/ &
        & 0.25098e+03_r8,0.35147e+03_r8,0.48447e+03_r8,0.31472e+03_r8,0.17829e+03_r8 /)
      kbo(:, 1,16, 3) = (/ &
        & 0.25194e+03_r8,0.35219e+03_r8,0.48538e+03_r8,0.31543e+03_r8,0.17829e+03_r8 /)
      kbo(:, 2,16, 3) = (/ &
        & 0.25087e+03_r8,0.35140e+03_r8,0.48427e+03_r8,0.31463e+03_r8,0.17829e+03_r8 /)
      kbo(:, 3,16, 3) = (/ &
        & 0.24994e+03_r8,0.35071e+03_r8,0.48328e+03_r8,0.31395e+03_r8,0.17829e+03_r8 /)
      kbo(:, 4,16, 3) = (/ &
        & 0.24914e+03_r8,0.35011e+03_r8,0.48239e+03_r8,0.31337e+03_r8,0.17829e+03_r8 /)
      kbo(:, 5,16, 3) = (/ &
        & 0.24843e+03_r8,0.34958e+03_r8,0.48159e+03_r8,0.31282e+03_r8,0.17829e+03_r8 /)
      kbo(:, 1,17, 3) = (/ &
        & 0.24919e+03_r8,0.35014e+03_r8,0.48236e+03_r8,0.31341e+03_r8,0.17829e+03_r8 /)
      kbo(:, 2,17, 3) = (/ &
        & 0.24832e+03_r8,0.34950e+03_r8,0.48145e+03_r8,0.31278e+03_r8,0.17829e+03_r8 /)
      kbo(:, 3,17, 3) = (/ &
        & 0.24758e+03_r8,0.34895e+03_r8,0.48063e+03_r8,0.31225e+03_r8,0.17829e+03_r8 /)
      kbo(:, 4,17, 3) = (/ &
        & 0.24693e+03_r8,0.34847e+03_r8,0.47989e+03_r8,0.31178e+03_r8,0.17829e+03_r8 /)
      kbo(:, 5,17, 3) = (/ &
        & 0.24635e+03_r8,0.34804e+03_r8,0.47924e+03_r8,0.31137e+03_r8,0.17829e+03_r8 /)
      kbo(:, 1,18, 3) = (/ &
        & 0.24695e+03_r8,0.34848e+03_r8,0.47988e+03_r8,0.31180e+03_r8,0.17829e+03_r8 /)
      kbo(:, 2,18, 3) = (/ &
        & 0.24626e+03_r8,0.34797e+03_r8,0.47913e+03_r8,0.31130e+03_r8,0.17829e+03_r8 /)
      kbo(:, 3,18, 3) = (/ &
        & 0.24565e+03_r8,0.34752e+03_r8,0.47845e+03_r8,0.31086e+03_r8,0.17829e+03_r8 /)
      kbo(:, 4,18, 3) = (/ &
        & 0.24513e+03_r8,0.34713e+03_r8,0.47784e+03_r8,0.31048e+03_r8,0.17829e+03_r8 /)
      kbo(:, 5,18, 3) = (/ &
        & 0.24466e+03_r8,0.34679e+03_r8,0.47731e+03_r8,0.31015e+03_r8,0.17829e+03_r8 /)
      kbo(:, 1,19, 3) = (/ &
        & 0.24514e+03_r8,0.34714e+03_r8,0.47784e+03_r8,0.31049e+03_r8,0.17829e+03_r8 /)
      kbo(:, 2,19, 3) = (/ &
        & 0.24458e+03_r8,0.34672e+03_r8,0.47721e+03_r8,0.31009e+03_r8,0.17829e+03_r8 /)
      kbo(:, 3,19, 3) = (/ &
        & 0.24409e+03_r8,0.34636e+03_r8,0.47665e+03_r8,0.30974e+03_r8,0.17829e+03_r8 /)
      kbo(:, 4,19, 3) = (/ &
        & 0.24367e+03_r8,0.34605e+03_r8,0.47616e+03_r8,0.30943e+03_r8,0.17829e+03_r8 /)
      kbo(:, 5,19, 3) = (/ &
        & 0.24329e+03_r8,0.34577e+03_r8,0.47573e+03_r8,0.30916e+03_r8,0.17829e+03_r8 /)
      kbo(:, 1,20, 3) = (/ &
        & 0.24366e+03_r8,0.34604e+03_r8,0.47615e+03_r8,0.30943e+03_r8,0.17829e+03_r8 /)
      kbo(:, 2,20, 3) = (/ &
        & 0.24321e+03_r8,0.34571e+03_r8,0.47563e+03_r8,0.30910e+03_r8,0.17829e+03_r8 /)
      kbo(:, 3,20, 3) = (/ &
        & 0.24282e+03_r8,0.34542e+03_r8,0.47518e+03_r8,0.30882e+03_r8,0.17829e+03_r8 /)
      kbo(:, 4,20, 3) = (/ &
        & 0.24247e+03_r8,0.34516e+03_r8,0.47478e+03_r8,0.30857e+03_r8,0.17829e+03_r8 /)
      kbo(:, 5,20, 3) = (/ &
        & 0.24217e+03_r8,0.34494e+03_r8,0.47443e+03_r8,0.30835e+03_r8,0.17829e+03_r8 /)
      kbo(:, 1,21, 3) = (/ &
        & 0.24246e+03_r8,0.34515e+03_r8,0.47476e+03_r8,0.30856e+03_r8,0.17829e+03_r8 /)
      kbo(:, 2,21, 3) = (/ &
        & 0.24210e+03_r8,0.34488e+03_r8,0.47434e+03_r8,0.30830e+03_r8,0.17829e+03_r8 /)
      kbo(:, 3,21, 3) = (/ &
        & 0.24178e+03_r8,0.34465e+03_r8,0.47397e+03_r8,0.30807e+03_r8,0.17829e+03_r8 /)
      kbo(:, 4,21, 3) = (/ &
        & 0.24150e+03_r8,0.34444e+03_r8,0.47364e+03_r8,0.30787e+03_r8,0.17829e+03_r8 /)
      kbo(:, 5,21, 3) = (/ &
        & 0.24126e+03_r8,0.34426e+03_r8,0.47341e+03_r8,0.30769e+03_r8,0.17829e+03_r8 /)
      kbo(:, 1,22, 3) = (/ &
        & 0.24146e+03_r8,0.34441e+03_r8,0.47360e+03_r8,0.30784e+03_r8,0.17829e+03_r8 /)
      kbo(:, 2,22, 3) = (/ &
        & 0.24117e+03_r8,0.34420e+03_r8,0.47327e+03_r8,0.30763e+03_r8,0.17829e+03_r8 /)
      kbo(:, 3,22, 3) = (/ &
        & 0.24092e+03_r8,0.34401e+03_r8,0.47296e+03_r8,0.30745e+03_r8,0.17829e+03_r8 /)
      kbo(:, 4,22, 3) = (/ &
        & 0.24070e+03_r8,0.34385e+03_r8,0.47270e+03_r8,0.30729e+03_r8,0.17829e+03_r8 /)
      kbo(:, 5,22, 3) = (/ &
        & 0.24050e+03_r8,0.34370e+03_r8,0.47246e+03_r8,0.30715e+03_r8,0.17829e+03_r8 /)
      kbo(:, 1,23, 3) = (/ &
        & 0.24066e+03_r8,0.34382e+03_r8,0.47265e+03_r8,0.30726e+03_r8,0.17829e+03_r8 /)
      kbo(:, 2,23, 3) = (/ &
        & 0.24043e+03_r8,0.34365e+03_r8,0.47237e+03_r8,0.30709e+03_r8,0.17829e+03_r8 /)
      kbo(:, 3,23, 3) = (/ &
        & 0.24023e+03_r8,0.34350e+03_r8,0.47213e+03_r8,0.30695e+03_r8,0.17829e+03_r8 /)
      kbo(:, 4,23, 3) = (/ &
        & 0.24005e+03_r8,0.34336e+03_r8,0.47191e+03_r8,0.30682e+03_r8,0.17829e+03_r8 /)
      kbo(:, 5,23, 3) = (/ &
        & 0.23989e+03_r8,0.34325e+03_r8,0.47173e+03_r8,0.30671e+03_r8,0.17829e+03_r8 /)
      kbo(:, 1,24, 3) = (/ &
        & 0.24001e+03_r8,0.34333e+03_r8,0.47187e+03_r8,0.30679e+03_r8,0.17829e+03_r8 /)
      kbo(:, 2,24, 3) = (/ &
        & 0.23982e+03_r8,0.34320e+03_r8,0.47164e+03_r8,0.30666e+03_r8,0.17829e+03_r8 /)
      kbo(:, 3,24, 3) = (/ &
        & 0.23966e+03_r8,0.34308e+03_r8,0.47145e+03_r8,0.30654e+03_r8,0.17829e+03_r8 /)
      kbo(:, 4,24, 3) = (/ &
        & 0.23952e+03_r8,0.34297e+03_r8,0.47128e+03_r8,0.30644e+03_r8,0.17829e+03_r8 /)
      kbo(:, 5,24, 3) = (/ &
        & 0.23940e+03_r8,0.34288e+03_r8,0.47113e+03_r8,0.30635e+03_r8,0.17829e+03_r8 /)
      kbo(:, 1,25, 3) = (/ &
        & 0.23948e+03_r8,0.34294e+03_r8,0.47124e+03_r8,0.30641e+03_r8,0.17829e+03_r8 /)
      kbo(:, 2,25, 3) = (/ &
        & 0.23934e+03_r8,0.34284e+03_r8,0.47105e+03_r8,0.30631e+03_r8,0.17829e+03_r8 /)
      kbo(:, 3,25, 3) = (/ &
        & 0.23921e+03_r8,0.34274e+03_r8,0.47089e+03_r8,0.30622e+03_r8,0.17829e+03_r8 /)
      kbo(:, 4,25, 3) = (/ &
        & 0.23910e+03_r8,0.34266e+03_r8,0.47075e+03_r8,0.30613e+03_r8,0.17829e+03_r8 /)
      kbo(:, 5,25, 3) = (/ &
        & 0.23900e+03_r8,0.34258e+03_r8,0.47063e+03_r8,0.30606e+03_r8,0.17829e+03_r8 /)
      kbo(:, 1,26, 3) = (/ &
        & 0.23906e+03_r8,0.34263e+03_r8,0.47070e+03_r8,0.30610e+03_r8,0.17829e+03_r8 /)
      kbo(:, 2,26, 3) = (/ &
        & 0.23894e+03_r8,0.34254e+03_r8,0.47056e+03_r8,0.30602e+03_r8,0.17829e+03_r8 /)
      kbo(:, 3,26, 3) = (/ &
        & 0.23884e+03_r8,0.34247e+03_r8,0.47044e+03_r8,0.30595e+03_r8,0.17829e+03_r8 /)
      kbo(:, 4,26, 3) = (/ &
        & 0.23875e+03_r8,0.34240e+03_r8,0.47033e+03_r8,0.30588e+03_r8,0.17829e+03_r8 /)
      kbo(:, 5,26, 3) = (/ &
        & 0.23867e+03_r8,0.34234e+03_r8,0.47023e+03_r8,0.30583e+03_r8,0.17829e+03_r8 /)
      kbo(:, 1,27, 3) = (/ &
        & 0.23871e+03_r8,0.34237e+03_r8,0.47028e+03_r8,0.30586e+03_r8,0.17829e+03_r8 /)
      kbo(:, 2,27, 3) = (/ &
        & 0.23862e+03_r8,0.34230e+03_r8,0.47017e+03_r8,0.30579e+03_r8,0.17829e+03_r8 /)
      kbo(:, 3,27, 3) = (/ &
        & 0.23854e+03_r8,0.34225e+03_r8,0.47007e+03_r8,0.30573e+03_r8,0.17829e+03_r8 /)
      kbo(:, 4,27, 3) = (/ &
        & 0.23847e+03_r8,0.34219e+03_r8,0.46998e+03_r8,0.30568e+03_r8,0.17829e+03_r8 /)
      kbo(:, 5,27, 3) = (/ &
        & 0.23840e+03_r8,0.34214e+03_r8,0.46990e+03_r8,0.30564e+03_r8,0.17829e+03_r8 /)
      kbo(:, 1,28, 3) = (/ &
        & 0.23844e+03_r8,0.34217e+03_r8,0.46994e+03_r8,0.30566e+03_r8,0.17829e+03_r8 /)
      kbo(:, 2,28, 3) = (/ &
        & 0.23836e+03_r8,0.34211e+03_r8,0.46985e+03_r8,0.30561e+03_r8,0.17829e+03_r8 /)
      kbo(:, 3,28, 3) = (/ &
        & 0.23830e+03_r8,0.34207e+03_r8,0.46977e+03_r8,0.30556e+03_r8,0.17829e+03_r8 /)
      kbo(:, 4,28, 3) = (/ &
        & 0.23824e+03_r8,0.34202e+03_r8,0.46970e+03_r8,0.30552e+03_r8,0.17829e+03_r8 /)
      kbo(:, 5,28, 3) = (/ &
        & 0.23819e+03_r8,0.34198e+03_r8,0.46964e+03_r8,0.30548e+03_r8,0.17829e+03_r8 /)
      kbo(:, 1,29, 3) = (/ &
        & 0.23821e+03_r8,0.34200e+03_r8,0.46966e+03_r8,0.30550e+03_r8,0.17829e+03_r8 /)
      kbo(:, 2,29, 3) = (/ &
        & 0.23815e+03_r8,0.34196e+03_r8,0.46959e+03_r8,0.30546e+03_r8,0.17829e+03_r8 /)
      kbo(:, 3,29, 3) = (/ &
        & 0.23810e+03_r8,0.34192e+03_r8,0.46953e+03_r8,0.30542e+03_r8,0.17829e+03_r8 /)
      kbo(:, 4,29, 3) = (/ &
        & 0.23806e+03_r8,0.34189e+03_r8,0.46948e+03_r8,0.30539e+03_r8,0.17829e+03_r8 /)
      kbo(:, 5,29, 3) = (/ &
        & 0.23802e+03_r8,0.34185e+03_r8,0.46942e+03_r8,0.30536e+03_r8,0.17829e+03_r8 /)
      kbo(:, 1,30, 3) = (/ &
        & 0.23803e+03_r8,0.34187e+03_r8,0.46944e+03_r8,0.30537e+03_r8,0.17829e+03_r8 /)
      kbo(:, 2,30, 3) = (/ &
        & 0.23799e+03_r8,0.34184e+03_r8,0.46939e+03_r8,0.30533e+03_r8,0.17829e+03_r8 /)
      kbo(:, 3,30, 3) = (/ &
        & 0.23795e+03_r8,0.34180e+03_r8,0.46934e+03_r8,0.30531e+03_r8,0.17829e+03_r8 /)
      kbo(:, 4,30, 3) = (/ &
        & 0.23791e+03_r8,0.34178e+03_r8,0.46929e+03_r8,0.30528e+03_r8,0.17829e+03_r8 /)
      kbo(:, 5,30, 3) = (/ &
        & 0.23788e+03_r8,0.34175e+03_r8,0.46925e+03_r8,0.30526e+03_r8,0.17829e+03_r8 /)
      kbo(:, 1,31, 3) = (/ &
        & 0.23789e+03_r8,0.34176e+03_r8,0.46926e+03_r8,0.30526e+03_r8,0.17829e+03_r8 /)
      kbo(:, 2,31, 3) = (/ &
        & 0.23785e+03_r8,0.34173e+03_r8,0.46922e+03_r8,0.30524e+03_r8,0.17829e+03_r8 /)
      kbo(:, 3,31, 3) = (/ &
        & 0.23782e+03_r8,0.34171e+03_r8,0.46918e+03_r8,0.30521e+03_r8,0.17829e+03_r8 /)
      kbo(:, 4,31, 3) = (/ &
        & 0.23779e+03_r8,0.34169e+03_r8,0.46914e+03_r8,0.30519e+03_r8,0.17829e+03_r8 /)
      kbo(:, 5,31, 3) = (/ &
        & 0.23777e+03_r8,0.34167e+03_r8,0.46911e+03_r8,0.30518e+03_r8,0.17829e+03_r8 /)
      kbo(:, 1,32, 3) = (/ &
        & 0.23777e+03_r8,0.34168e+03_r8,0.46912e+03_r8,0.30518e+03_r8,0.17829e+03_r8 /)
      kbo(:, 2,32, 3) = (/ &
        & 0.23774e+03_r8,0.34166e+03_r8,0.46908e+03_r8,0.30516e+03_r8,0.17829e+03_r8 /)
      kbo(:, 3,32, 3) = (/ &
        & 0.23772e+03_r8,0.34163e+03_r8,0.46905e+03_r8,0.30514e+03_r8,0.17829e+03_r8 /)
      kbo(:, 4,32, 3) = (/ &
        & 0.23770e+03_r8,0.34162e+03_r8,0.46902e+03_r8,0.30512e+03_r8,0.17829e+03_r8 /)
      kbo(:, 5,32, 3) = (/ &
        & 0.23767e+03_r8,0.34160e+03_r8,0.46900e+03_r8,0.30511e+03_r8,0.17829e+03_r8 /)
      kbo(:, 1,33, 3) = (/ &
        & 0.23768e+03_r8,0.34161e+03_r8,0.46900e+03_r8,0.30511e+03_r8,0.17829e+03_r8 /)
      kbo(:, 2,33, 3) = (/ &
        & 0.23766e+03_r8,0.34159e+03_r8,0.46897e+03_r8,0.30510e+03_r8,0.17829e+03_r8 /)
      kbo(:, 3,33, 3) = (/ &
        & 0.23764e+03_r8,0.34157e+03_r8,0.46895e+03_r8,0.30508e+03_r8,0.17829e+03_r8 /)
      kbo(:, 4,33, 3) = (/ &
        & 0.23762e+03_r8,0.34156e+03_r8,0.46893e+03_r8,0.30507e+03_r8,0.17829e+03_r8 /)
      kbo(:, 5,33, 3) = (/ &
        & 0.23760e+03_r8,0.34154e+03_r8,0.46891e+03_r8,0.30506e+03_r8,0.17829e+03_r8 /)
      kbo(:, 1,34, 3) = (/ &
        & 0.23760e+03_r8,0.34155e+03_r8,0.46891e+03_r8,0.30506e+03_r8,0.17829e+03_r8 /)
      kbo(:, 2,34, 3) = (/ &
        & 0.23759e+03_r8,0.34154e+03_r8,0.46889e+03_r8,0.30505e+03_r8,0.17829e+03_r8 /)
      kbo(:, 3,34, 3) = (/ &
        & 0.23757e+03_r8,0.34152e+03_r8,0.46887e+03_r8,0.30503e+03_r8,0.17829e+03_r8 /)
      kbo(:, 4,34, 3) = (/ &
        & 0.23756e+03_r8,0.34151e+03_r8,0.46885e+03_r8,0.30502e+03_r8,0.17829e+03_r8 /)
      kbo(:, 5,34, 3) = (/ &
        & 0.23754e+03_r8,0.34150e+03_r8,0.46883e+03_r8,0.30501e+03_r8,0.17829e+03_r8 /)
      kbo(:, 1,35, 3) = (/ &
        & 0.23755e+03_r8,0.34151e+03_r8,0.46884e+03_r8,0.30502e+03_r8,0.17829e+03_r8 /)
      kbo(:, 2,35, 3) = (/ &
        & 0.23753e+03_r8,0.34150e+03_r8,0.46882e+03_r8,0.30501e+03_r8,0.17829e+03_r8 /)
      kbo(:, 3,35, 3) = (/ &
        & 0.23752e+03_r8,0.34148e+03_r8,0.46880e+03_r8,0.30500e+03_r8,0.17829e+03_r8 /)
      kbo(:, 4,35, 3) = (/ &
        & 0.23751e+03_r8,0.34147e+03_r8,0.46879e+03_r8,0.30499e+03_r8,0.17829e+03_r8 /)
      kbo(:, 5,35, 3) = (/ &
        & 0.23750e+03_r8,0.34146e+03_r8,0.46878e+03_r8,0.30498e+03_r8,0.17829e+03_r8 /)
      kbo(:, 1,36, 3) = (/ &
        & 0.23750e+03_r8,0.34147e+03_r8,0.46878e+03_r8,0.30498e+03_r8,0.17829e+03_r8 /)
      kbo(:, 2,36, 3) = (/ &
        & 0.23749e+03_r8,0.34146e+03_r8,0.46877e+03_r8,0.30497e+03_r8,0.17829e+03_r8 /)
      kbo(:, 3,36, 3) = (/ &
        & 0.23748e+03_r8,0.34145e+03_r8,0.46875e+03_r8,0.30497e+03_r8,0.17829e+03_r8 /)
      kbo(:, 4,36, 3) = (/ &
        & 0.23747e+03_r8,0.34144e+03_r8,0.46874e+03_r8,0.30496e+03_r8,0.17829e+03_r8 /)
      kbo(:, 5,36, 3) = (/ &
        & 0.23746e+03_r8,0.34144e+03_r8,0.46873e+03_r8,0.30495e+03_r8,0.17829e+03_r8 /)
      kbo(:, 1,37, 3) = (/ &
        & 0.23746e+03_r8,0.34145e+03_r8,0.46874e+03_r8,0.30496e+03_r8,0.17829e+03_r8 /)
      kbo(:, 2,37, 3) = (/ &
        & 0.23745e+03_r8,0.34144e+03_r8,0.46872e+03_r8,0.30495e+03_r8,0.17829e+03_r8 /)
      kbo(:, 3,37, 3) = (/ &
        & 0.23744e+03_r8,0.34143e+03_r8,0.46871e+03_r8,0.30494e+03_r8,0.17829e+03_r8 /)
      kbo(:, 4,37, 3) = (/ &
        & 0.23744e+03_r8,0.34142e+03_r8,0.46870e+03_r8,0.30494e+03_r8,0.17829e+03_r8 /)
      kbo(:, 5,37, 3) = (/ &
        & 0.23743e+03_r8,0.34141e+03_r8,0.46869e+03_r8,0.30493e+03_r8,0.17829e+03_r8 /)
      kbo(:, 1,38, 3) = (/ &
        & 0.23743e+03_r8,0.34143e+03_r8,0.46870e+03_r8,0.30493e+03_r8,0.17829e+03_r8 /)
      kbo(:, 2,38, 3) = (/ &
        & 0.23742e+03_r8,0.34142e+03_r8,0.46869e+03_r8,0.30493e+03_r8,0.17829e+03_r8 /)
      kbo(:, 3,38, 3) = (/ &
        & 0.23742e+03_r8,0.34141e+03_r8,0.46868e+03_r8,0.30492e+03_r8,0.17829e+03_r8 /)
      kbo(:, 4,38, 3) = (/ &
        & 0.23741e+03_r8,0.34140e+03_r8,0.46867e+03_r8,0.30492e+03_r8,0.17829e+03_r8 /)
      kbo(:, 5,38, 3) = (/ &
        & 0.23740e+03_r8,0.34140e+03_r8,0.46866e+03_r8,0.30491e+03_r8,0.17829e+03_r8 /)
      kbo(:, 1,39, 3) = (/ &
        & 0.23741e+03_r8,0.34141e+03_r8,0.46867e+03_r8,0.30492e+03_r8,0.17829e+03_r8 /)
      kbo(:, 2,39, 3) = (/ &
        & 0.23740e+03_r8,0.34140e+03_r8,0.46866e+03_r8,0.30491e+03_r8,0.17829e+03_r8 /)
      kbo(:, 3,39, 3) = (/ &
        & 0.23739e+03_r8,0.34139e+03_r8,0.46865e+03_r8,0.30491e+03_r8,0.17829e+03_r8 /)
      kbo(:, 4,39, 3) = (/ &
        & 0.23739e+03_r8,0.34139e+03_r8,0.46865e+03_r8,0.30490e+03_r8,0.17829e+03_r8 /)
      kbo(:, 5,39, 3) = (/ &
        & 0.23738e+03_r8,0.34138e+03_r8,0.46864e+03_r8,0.30490e+03_r8,0.17829e+03_r8 /)
      kbo(:, 1,40, 3) = (/ &
        & 0.23739e+03_r8,0.34139e+03_r8,0.46864e+03_r8,0.30490e+03_r8,0.17829e+03_r8 /)
      kbo(:, 2,40, 3) = (/ &
        & 0.23738e+03_r8,0.34139e+03_r8,0.46864e+03_r8,0.30490e+03_r8,0.17829e+03_r8 /)
      kbo(:, 3,40, 3) = (/ &
        & 0.23738e+03_r8,0.34138e+03_r8,0.46863e+03_r8,0.30489e+03_r8,0.17829e+03_r8 /)
      kbo(:, 4,40, 3) = (/ &
        & 0.23737e+03_r8,0.34138e+03_r8,0.46862e+03_r8,0.30489e+03_r8,0.17829e+03_r8 /)
      kbo(:, 5,40, 3) = (/ &
        & 0.23737e+03_r8,0.34137e+03_r8,0.46862e+03_r8,0.30489e+03_r8,0.17829e+03_r8 /)
      kbo(:, 1,41, 3) = (/ &
        & 0.23737e+03_r8,0.34138e+03_r8,0.46862e+03_r8,0.30489e+03_r8,0.17829e+03_r8 /)
      kbo(:, 2,41, 3) = (/ &
        & 0.23737e+03_r8,0.34138e+03_r8,0.46862e+03_r8,0.30489e+03_r8,0.17829e+03_r8 /)
      kbo(:, 3,41, 3) = (/ &
        & 0.23736e+03_r8,0.34137e+03_r8,0.46861e+03_r8,0.30488e+03_r8,0.17829e+03_r8 /)
      kbo(:, 4,41, 3) = (/ &
        & 0.23736e+03_r8,0.34137e+03_r8,0.46861e+03_r8,0.30488e+03_r8,0.17829e+03_r8 /)
      kbo(:, 5,41, 3) = (/ &
        & 0.23736e+03_r8,0.34136e+03_r8,0.46860e+03_r8,0.30488e+03_r8,0.17829e+03_r8 /)
      kbo(:, 1,42, 3) = (/ &
        & 0.23736e+03_r8,0.34137e+03_r8,0.46861e+03_r8,0.30488e+03_r8,0.17829e+03_r8 /)
      kbo(:, 2,42, 3) = (/ &
        & 0.23735e+03_r8,0.34137e+03_r8,0.46860e+03_r8,0.30488e+03_r8,0.17829e+03_r8 /)
      kbo(:, 3,42, 3) = (/ &
        & 0.23735e+03_r8,0.34136e+03_r8,0.46860e+03_r8,0.30488e+03_r8,0.17829e+03_r8 /)
      kbo(:, 4,42, 3) = (/ &
        & 0.23735e+03_r8,0.34136e+03_r8,0.46859e+03_r8,0.30487e+03_r8,0.17829e+03_r8 /)
      kbo(:, 5,42, 3) = (/ &
        & 0.23734e+03_r8,0.34135e+03_r8,0.46859e+03_r8,0.30487e+03_r8,0.17829e+03_r8 /)
      kbo(:, 1,43, 3) = (/ &
        & 0.23735e+03_r8,0.34136e+03_r8,0.46859e+03_r8,0.30487e+03_r8,0.17829e+03_r8 /)
      kbo(:, 2,43, 3) = (/ &
        & 0.23734e+03_r8,0.34136e+03_r8,0.46859e+03_r8,0.30487e+03_r8,0.17829e+03_r8 /)
      kbo(:, 3,43, 3) = (/ &
        & 0.23734e+03_r8,0.34136e+03_r8,0.46858e+03_r8,0.30487e+03_r8,0.17829e+03_r8 /)
      kbo(:, 4,43, 3) = (/ &
        & 0.23734e+03_r8,0.34135e+03_r8,0.46858e+03_r8,0.30487e+03_r8,0.17829e+03_r8 /)
      kbo(:, 5,43, 3) = (/ &
        & 0.23734e+03_r8,0.34135e+03_r8,0.46858e+03_r8,0.30486e+03_r8,0.17829e+03_r8 /)
      kbo(:, 1,44, 3) = (/ &
        & 0.23734e+03_r8,0.34136e+03_r8,0.46858e+03_r8,0.30487e+03_r8,0.17829e+03_r8 /)
      kbo(:, 2,44, 3) = (/ &
        & 0.23734e+03_r8,0.34135e+03_r8,0.46858e+03_r8,0.30486e+03_r8,0.17829e+03_r8 /)
      kbo(:, 3,44, 3) = (/ &
        & 0.23733e+03_r8,0.34135e+03_r8,0.46857e+03_r8,0.30486e+03_r8,0.17829e+03_r8 /)
      kbo(:, 4,44, 3) = (/ &
        & 0.23733e+03_r8,0.34135e+03_r8,0.46857e+03_r8,0.30486e+03_r8,0.17829e+03_r8 /)
      kbo(:, 5,44, 3) = (/ &
        & 0.23733e+03_r8,0.34134e+03_r8,0.46857e+03_r8,0.30486e+03_r8,0.17829e+03_r8 /)
      kbo(:, 1,45, 3) = (/ &
        & 0.23733e+03_r8,0.34135e+03_r8,0.46857e+03_r8,0.30486e+03_r8,0.17829e+03_r8 /)
      kbo(:, 2,45, 3) = (/ &
        & 0.23733e+03_r8,0.34135e+03_r8,0.46857e+03_r8,0.30486e+03_r8,0.17829e+03_r8 /)
      kbo(:, 3,45, 3) = (/ &
        & 0.23733e+03_r8,0.34135e+03_r8,0.46857e+03_r8,0.30486e+03_r8,0.17829e+03_r8 /)
      kbo(:, 4,45, 3) = (/ &
        & 0.23732e+03_r8,0.34134e+03_r8,0.46856e+03_r8,0.30486e+03_r8,0.17829e+03_r8 /)
      kbo(:, 5,45, 3) = (/ &
        & 0.23732e+03_r8,0.34134e+03_r8,0.46856e+03_r8,0.30486e+03_r8,0.17829e+03_r8 /)
      kbo(:, 1,46, 3) = (/ &
        & 0.23732e+03_r8,0.34135e+03_r8,0.46856e+03_r8,0.30486e+03_r8,0.17829e+03_r8 /)
      kbo(:, 2,46, 3) = (/ &
        & 0.23732e+03_r8,0.34134e+03_r8,0.46856e+03_r8,0.30486e+03_r8,0.17829e+03_r8 /)
      kbo(:, 3,46, 3) = (/ &
        & 0.23732e+03_r8,0.34134e+03_r8,0.46856e+03_r8,0.30485e+03_r8,0.17829e+03_r8 /)
      kbo(:, 4,46, 3) = (/ &
        & 0.23732e+03_r8,0.34134e+03_r8,0.46856e+03_r8,0.30485e+03_r8,0.17829e+03_r8 /)
      kbo(:, 5,46, 3) = (/ &
        & 0.23732e+03_r8,0.34134e+03_r8,0.46856e+03_r8,0.30485e+03_r8,0.17829e+03_r8 /)
      kbo(:, 1,47, 3) = (/ &
        & 0.23732e+03_r8,0.34135e+03_r8,0.46856e+03_r8,0.30485e+03_r8,0.17829e+03_r8 /)
      kbo(:, 2,47, 3) = (/ &
        & 0.23732e+03_r8,0.34134e+03_r8,0.46856e+03_r8,0.30485e+03_r8,0.17829e+03_r8 /)
      kbo(:, 3,47, 3) = (/ &
        & 0.23732e+03_r8,0.34134e+03_r8,0.46855e+03_r8,0.30485e+03_r8,0.17829e+03_r8 /)
      kbo(:, 4,47, 3) = (/ &
        & 0.23731e+03_r8,0.34134e+03_r8,0.46855e+03_r8,0.30485e+03_r8,0.17829e+03_r8 /)
      kbo(:, 5,47, 3) = (/ &
        & 0.23731e+03_r8,0.34133e+03_r8,0.46855e+03_r8,0.30485e+03_r8,0.17829e+03_r8 /)
      kbo(:, 1,48, 3) = (/ &
        & 0.23731e+03_r8,0.34135e+03_r8,0.46855e+03_r8,0.30485e+03_r8,0.17829e+03_r8 /)
      kbo(:, 2,48, 3) = (/ &
        & 0.23731e+03_r8,0.34134e+03_r8,0.46855e+03_r8,0.30485e+03_r8,0.17829e+03_r8 /)
      kbo(:, 3,48, 3) = (/ &
        & 0.23731e+03_r8,0.34134e+03_r8,0.46855e+03_r8,0.30485e+03_r8,0.17829e+03_r8 /)
      kbo(:, 4,48, 3) = (/ &
        & 0.23731e+03_r8,0.34134e+03_r8,0.46855e+03_r8,0.30485e+03_r8,0.17829e+03_r8 /)
      kbo(:, 5,48, 3) = (/ &
        & 0.23731e+03_r8,0.34133e+03_r8,0.46855e+03_r8,0.30485e+03_r8,0.17829e+03_r8 /)
      kbo(:, 1,49, 3) = (/ &
        & 0.23731e+03_r8,0.34135e+03_r8,0.46855e+03_r8,0.30485e+03_r8,0.17829e+03_r8 /)
      kbo(:, 2,49, 3) = (/ &
        & 0.23731e+03_r8,0.34134e+03_r8,0.46855e+03_r8,0.30485e+03_r8,0.17829e+03_r8 /)
      kbo(:, 3,49, 3) = (/ &
        & 0.23731e+03_r8,0.34133e+03_r8,0.46854e+03_r8,0.30485e+03_r8,0.17829e+03_r8 /)
      kbo(:, 4,49, 3) = (/ &
        & 0.23731e+03_r8,0.34133e+03_r8,0.46854e+03_r8,0.30484e+03_r8,0.17829e+03_r8 /)
      kbo(:, 5,49, 3) = (/ &
        & 0.23731e+03_r8,0.34133e+03_r8,0.46854e+03_r8,0.30484e+03_r8,0.17829e+03_r8 /)
      kbo(:, 1,50, 3) = (/ &
        & 0.23731e+03_r8,0.34136e+03_r8,0.46854e+03_r8,0.30484e+03_r8,0.17829e+03_r8 /)
      kbo(:, 2,50, 3) = (/ &
        & 0.23731e+03_r8,0.34134e+03_r8,0.46854e+03_r8,0.30484e+03_r8,0.17829e+03_r8 /)
      kbo(:, 3,50, 3) = (/ &
        & 0.23731e+03_r8,0.34133e+03_r8,0.46854e+03_r8,0.30484e+03_r8,0.17829e+03_r8 /)
      kbo(:, 4,50, 3) = (/ &
        & 0.23730e+03_r8,0.34133e+03_r8,0.46854e+03_r8,0.30484e+03_r8,0.17829e+03_r8 /)
      kbo(:, 5,50, 3) = (/ &
        & 0.23730e+03_r8,0.34133e+03_r8,0.46854e+03_r8,0.30484e+03_r8,0.17829e+03_r8 /)
      kbo(:, 1,51, 3) = (/ &
        & 0.23731e+03_r8,0.34136e+03_r8,0.46854e+03_r8,0.30484e+03_r8,0.17829e+03_r8 /)
      kbo(:, 2,51, 3) = (/ &
        & 0.23730e+03_r8,0.34134e+03_r8,0.46854e+03_r8,0.30484e+03_r8,0.17829e+03_r8 /)
      kbo(:, 3,51, 3) = (/ &
        & 0.23730e+03_r8,0.34133e+03_r8,0.46854e+03_r8,0.30484e+03_r8,0.17829e+03_r8 /)
      kbo(:, 4,51, 3) = (/ &
        & 0.23730e+03_r8,0.34133e+03_r8,0.46854e+03_r8,0.30484e+03_r8,0.17829e+03_r8 /)
      kbo(:, 5,51, 3) = (/ &
        & 0.23730e+03_r8,0.34133e+03_r8,0.46854e+03_r8,0.30484e+03_r8,0.17829e+03_r8 /)
      kbo(:, 1,52, 3) = (/ &
        & 0.23730e+03_r8,0.34136e+03_r8,0.46852e+03_r8,0.30484e+03_r8,0.17829e+03_r8 /)
      kbo(:, 2,52, 3) = (/ &
        & 0.23730e+03_r8,0.34135e+03_r8,0.46854e+03_r8,0.30484e+03_r8,0.17829e+03_r8 /)
      kbo(:, 3,52, 3) = (/ &
        & 0.23730e+03_r8,0.34133e+03_r8,0.46854e+03_r8,0.30484e+03_r8,0.17829e+03_r8 /)
      kbo(:, 4,52, 3) = (/ &
        & 0.23730e+03_r8,0.34132e+03_r8,0.46854e+03_r8,0.30484e+03_r8,0.17829e+03_r8 /)
      kbo(:, 5,52, 3) = (/ &
        & 0.23730e+03_r8,0.34133e+03_r8,0.46853e+03_r8,0.30484e+03_r8,0.17829e+03_r8 /)
      kbo(:, 1,53, 3) = (/ &
        & 0.23730e+03_r8,0.34137e+03_r8,0.46851e+03_r8,0.30484e+03_r8,0.17829e+03_r8 /)
      kbo(:, 2,53, 3) = (/ &
        & 0.23730e+03_r8,0.34135e+03_r8,0.46853e+03_r8,0.30484e+03_r8,0.17829e+03_r8 /)
      kbo(:, 3,53, 3) = (/ &
        & 0.23730e+03_r8,0.34134e+03_r8,0.46853e+03_r8,0.30484e+03_r8,0.17829e+03_r8 /)
      kbo(:, 4,53, 3) = (/ &
        & 0.23730e+03_r8,0.34133e+03_r8,0.46853e+03_r8,0.30484e+03_r8,0.17829e+03_r8 /)
      kbo(:, 5,53, 3) = (/ &
        & 0.23730e+03_r8,0.34133e+03_r8,0.46853e+03_r8,0.30484e+03_r8,0.17829e+03_r8 /)
      kbo(:, 1,54, 3) = (/ &
        & 0.23730e+03_r8,0.34137e+03_r8,0.46849e+03_r8,0.30484e+03_r8,0.17829e+03_r8 /)
      kbo(:, 2,54, 3) = (/ &
        & 0.23730e+03_r8,0.34136e+03_r8,0.46852e+03_r8,0.30484e+03_r8,0.17829e+03_r8 /)
      kbo(:, 3,54, 3) = (/ &
        & 0.23730e+03_r8,0.34134e+03_r8,0.46853e+03_r8,0.30484e+03_r8,0.17829e+03_r8 /)
      kbo(:, 4,54, 3) = (/ &
        & 0.23730e+03_r8,0.34133e+03_r8,0.46853e+03_r8,0.30484e+03_r8,0.17829e+03_r8 /)
      kbo(:, 5,54, 3) = (/ &
        & 0.23730e+03_r8,0.34132e+03_r8,0.46853e+03_r8,0.30484e+03_r8,0.17829e+03_r8 /)
      kbo(:, 1,55, 3) = (/ &
        & 0.23730e+03_r8,0.34138e+03_r8,0.46847e+03_r8,0.30484e+03_r8,0.17829e+03_r8 /)
      kbo(:, 2,55, 3) = (/ &
        & 0.23730e+03_r8,0.34136e+03_r8,0.46852e+03_r8,0.30484e+03_r8,0.17829e+03_r8 /)
      kbo(:, 3,55, 3) = (/ &
        & 0.23730e+03_r8,0.34134e+03_r8,0.46853e+03_r8,0.30484e+03_r8,0.17829e+03_r8 /)
      kbo(:, 4,55, 3) = (/ &
        & 0.23730e+03_r8,0.34133e+03_r8,0.46853e+03_r8,0.30484e+03_r8,0.17829e+03_r8 /)
      kbo(:, 5,55, 3) = (/ &
        & 0.23730e+03_r8,0.34132e+03_r8,0.46853e+03_r8,0.30484e+03_r8,0.17829e+03_r8 /)
      kbo(:, 1,56, 3) = (/ &
        & 0.23730e+03_r8,0.34139e+03_r8,0.46844e+03_r8,0.30484e+03_r8,0.17829e+03_r8 /)
      kbo(:, 2,56, 3) = (/ &
        & 0.23730e+03_r8,0.34137e+03_r8,0.46850e+03_r8,0.30484e+03_r8,0.17829e+03_r8 /)
      kbo(:, 3,56, 3) = (/ &
        & 0.23730e+03_r8,0.34135e+03_r8,0.46853e+03_r8,0.30484e+03_r8,0.17829e+03_r8 /)
      kbo(:, 4,56, 3) = (/ &
        & 0.23730e+03_r8,0.34133e+03_r8,0.46853e+03_r8,0.30484e+03_r8,0.17829e+03_r8 /)
      kbo(:, 5,56, 3) = (/ &
        & 0.23730e+03_r8,0.34133e+03_r8,0.46853e+03_r8,0.30484e+03_r8,0.17829e+03_r8 /)
      kbo(:, 1,57, 3) = (/ &
        & 0.23730e+03_r8,0.34140e+03_r8,0.46840e+03_r8,0.30484e+03_r8,0.17829e+03_r8 /)
      kbo(:, 2,57, 3) = (/ &
        & 0.23730e+03_r8,0.34137e+03_r8,0.46849e+03_r8,0.30484e+03_r8,0.17829e+03_r8 /)
      kbo(:, 3,57, 3) = (/ &
        & 0.23730e+03_r8,0.34135e+03_r8,0.46852e+03_r8,0.30484e+03_r8,0.17829e+03_r8 /)
      kbo(:, 4,57, 3) = (/ &
        & 0.23730e+03_r8,0.34134e+03_r8,0.46853e+03_r8,0.30484e+03_r8,0.17829e+03_r8 /)
      kbo(:, 5,57, 3) = (/ &
        & 0.23729e+03_r8,0.34132e+03_r8,0.46853e+03_r8,0.30484e+03_r8,0.17829e+03_r8 /)
      kbo(:, 1,58, 3) = (/ &
        & 0.23730e+03_r8,0.34140e+03_r8,0.46837e+03_r8,0.30484e+03_r8,0.17829e+03_r8 /)
      kbo(:, 2,58, 3) = (/ &
        & 0.23729e+03_r8,0.34138e+03_r8,0.46847e+03_r8,0.30484e+03_r8,0.17829e+03_r8 /)
      kbo(:, 3,58, 3) = (/ &
        & 0.23729e+03_r8,0.34136e+03_r8,0.46851e+03_r8,0.30484e+03_r8,0.17829e+03_r8 /)
      kbo(:, 4,58, 3) = (/ &
        & 0.23729e+03_r8,0.34134e+03_r8,0.46853e+03_r8,0.30484e+03_r8,0.17829e+03_r8 /)
      kbo(:, 5,58, 3) = (/ &
        & 0.23729e+03_r8,0.34133e+03_r8,0.46853e+03_r8,0.30483e+03_r8,0.17829e+03_r8 /)
      kbo(:, 1,59, 3) = (/ &
        & 0.23729e+03_r8,0.34141e+03_r8,0.46835e+03_r8,0.30484e+03_r8,0.17829e+03_r8 /)
      kbo(:, 2,59, 3) = (/ &
        & 0.23729e+03_r8,0.34138e+03_r8,0.46846e+03_r8,0.30484e+03_r8,0.17829e+03_r8 /)
      kbo(:, 3,59, 3) = (/ &
        & 0.23729e+03_r8,0.34136e+03_r8,0.46851e+03_r8,0.30483e+03_r8,0.17829e+03_r8 /)
      kbo(:, 4,59, 3) = (/ &
        & 0.23729e+03_r8,0.34134e+03_r8,0.46853e+03_r8,0.30483e+03_r8,0.17829e+03_r8 /)
      kbo(:, 5,59, 3) = (/ &
        & 0.23729e+03_r8,0.34133e+03_r8,0.46853e+03_r8,0.30483e+03_r8,0.17829e+03_r8 /)
      kbo(:, 1,13, 4) = (/ &
        & 0.51214e+03_r8,0.47089e+03_r8,0.53698e+03_r8,0.40623e+03_r8,0.38437e+03_r8 /)
      kbo(:, 2,13, 4) = (/ &
        & 0.50819e+03_r8,0.46793e+03_r8,0.53525e+03_r8,0.40532e+03_r8,0.38437e+03_r8 /)
      kbo(:, 3,13, 4) = (/ &
        & 0.50478e+03_r8,0.46537e+03_r8,0.53379e+03_r8,0.40453e+03_r8,0.38437e+03_r8 /)
      kbo(:, 4,13, 4) = (/ &
        & 0.50182e+03_r8,0.46315e+03_r8,0.53251e+03_r8,0.40385e+03_r8,0.38437e+03_r8 /)
      kbo(:, 5,13, 4) = (/ &
        & 0.49922e+03_r8,0.46120e+03_r8,0.53137e+03_r8,0.40325e+03_r8,0.38437e+03_r8 /)
      kbo(:, 1,14, 4) = (/ &
        & 0.50224e+03_r8,0.46346e+03_r8,0.53224e+03_r8,0.40395e+03_r8,0.38437e+03_r8 /)
      kbo(:, 2,14, 4) = (/ &
        & 0.49905e+03_r8,0.46107e+03_r8,0.53090e+03_r8,0.40321e+03_r8,0.38437e+03_r8 /)
      kbo(:, 3,14, 4) = (/ &
        & 0.49629e+03_r8,0.45901e+03_r8,0.52974e+03_r8,0.40258e+03_r8,0.38437e+03_r8 /)
      kbo(:, 4,14, 4) = (/ &
        & 0.49390e+03_r8,0.45721e+03_r8,0.52871e+03_r8,0.40203e+03_r8,0.38437e+03_r8 /)
      kbo(:, 5,14, 4) = (/ &
        & 0.49179e+03_r8,0.45563e+03_r8,0.52774e+03_r8,0.40154e+03_r8,0.38437e+03_r8 /)
      kbo(:, 1,15, 4) = (/ &
        & 0.49416e+03_r8,0.45741e+03_r8,0.52835e+03_r8,0.40209e+03_r8,0.38437e+03_r8 /)
      kbo(:, 2,15, 4) = (/ &
        & 0.49159e+03_r8,0.45548e+03_r8,0.52725e+03_r8,0.40149e+03_r8,0.38437e+03_r8 /)
      kbo(:, 3,15, 4) = (/ &
        & 0.48937e+03_r8,0.45381e+03_r8,0.52626e+03_r8,0.40098e+03_r8,0.38437e+03_r8 /)
      kbo(:, 4,15, 4) = (/ &
        & 0.48743e+03_r8,0.45236e+03_r8,0.52534e+03_r8,0.40054e+03_r8,0.38437e+03_r8 /)
      kbo(:, 5,15, 4) = (/ &
        & 0.48573e+03_r8,0.45108e+03_r8,0.52448e+03_r8,0.40015e+03_r8,0.38437e+03_r8 /)
      kbo(:, 1,16, 4) = (/ &
        & 0.48759e+03_r8,0.45248e+03_r8,0.52492e+03_r8,0.40057e+03_r8,0.38437e+03_r8 /)
      kbo(:, 2,16, 4) = (/ &
        & 0.48552e+03_r8,0.45092e+03_r8,0.52397e+03_r8,0.40010e+03_r8,0.38437e+03_r8 /)
      kbo(:, 3,16, 4) = (/ &
        & 0.48373e+03_r8,0.44958e+03_r8,0.52310e+03_r8,0.39968e+03_r8,0.38437e+03_r8 /)
      kbo(:, 4,16, 4) = (/ &
        & 0.48216e+03_r8,0.44841e+03_r8,0.52232e+03_r8,0.39932e+03_r8,0.38437e+03_r8 /)
      kbo(:, 5,16, 4) = (/ &
        & 0.48079e+03_r8,0.44738e+03_r8,0.52159e+03_r8,0.39901e+03_r8,0.38437e+03_r8 /)
      kbo(:, 1,17, 4) = (/ &
        & 0.48226e+03_r8,0.44848e+03_r8,0.52188e+03_r8,0.39935e+03_r8,0.38437e+03_r8 /)
      kbo(:, 2,17, 4) = (/ &
        & 0.48059e+03_r8,0.44723e+03_r8,0.52110e+03_r8,0.39896e+03_r8,0.38437e+03_r8 /)
      kbo(:, 3,17, 4) = (/ &
        & 0.47915e+03_r8,0.44615e+03_r8,0.52038e+03_r8,0.39863e+03_r8,0.38437e+03_r8 /)
      kbo(:, 4,17, 4) = (/ &
        & 0.47788e+03_r8,0.44520e+03_r8,0.51974e+03_r8,0.39834e+03_r8,0.38437e+03_r8 /)
      kbo(:, 5,17, 4) = (/ &
        & 0.47677e+03_r8,0.44437e+03_r8,0.51913e+03_r8,0.39808e+03_r8,0.38437e+03_r8 /)
      kbo(:, 1,18, 4) = (/ &
        & 0.47794e+03_r8,0.44524e+03_r8,0.51928e+03_r8,0.39835e+03_r8,0.38437e+03_r8 /)
      kbo(:, 2,18, 4) = (/ &
        & 0.47659e+03_r8,0.44423e+03_r8,0.51865e+03_r8,0.39804e+03_r8,0.38437e+03_r8 /)
      kbo(:, 3,18, 4) = (/ &
        & 0.47542e+03_r8,0.44336e+03_r8,0.51808e+03_r8,0.39777e+03_r8,0.38437e+03_r8 /)
      kbo(:, 4,18, 4) = (/ &
        & 0.47441e+03_r8,0.44259e+03_r8,0.51755e+03_r8,0.39754e+03_r8,0.38437e+03_r8 /)
      kbo(:, 5,18, 4) = (/ &
        & 0.47351e+03_r8,0.44192e+03_r8,0.51705e+03_r8,0.39733e+03_r8,0.38437e+03_r8 /)
      kbo(:, 1,19, 4) = (/ &
        & 0.47443e+03_r8,0.44261e+03_r8,0.51710e+03_r8,0.39754e+03_r8,0.38437e+03_r8 /)
      kbo(:, 2,19, 4) = (/ &
        & 0.47334e+03_r8,0.44179e+03_r8,0.51660e+03_r8,0.39729e+03_r8,0.38437e+03_r8 /)
      kbo(:, 3,19, 4) = (/ &
        & 0.47240e+03_r8,0.44109e+03_r8,0.51615e+03_r8,0.39708e+03_r8,0.38437e+03_r8 /)
      kbo(:, 4,19, 4) = (/ &
        & 0.47158e+03_r8,0.44047e+03_r8,0.51573e+03_r8,0.39689e+03_r8,0.38437e+03_r8 /)
      kbo(:, 5,19, 4) = (/ &
        & 0.47085e+03_r8,0.43993e+03_r8,0.51533e+03_r8,0.39672e+03_r8,0.38437e+03_r8 /)
      kbo(:, 1,20, 4) = (/ &
        & 0.47156e+03_r8,0.44046e+03_r8,0.51527e+03_r8,0.39688e+03_r8,0.38437e+03_r8 /)
      kbo(:, 2,20, 4) = (/ &
        & 0.47069e+03_r8,0.43980e+03_r8,0.51490e+03_r8,0.39668e+03_r8,0.38437e+03_r8 /)
      kbo(:, 3,20, 4) = (/ &
        & 0.46993e+03_r8,0.43924e+03_r8,0.51455e+03_r8,0.39651e+03_r8,0.38437e+03_r8 /)
      kbo(:, 4,20, 4) = (/ &
        & 0.46927e+03_r8,0.43874e+03_r8,0.51422e+03_r8,0.39635e+03_r8,0.38437e+03_r8 /)
      kbo(:, 5,20, 4) = (/ &
        & 0.46868e+03_r8,0.43830e+03_r8,0.51389e+03_r8,0.39622e+03_r8,0.38437e+03_r8 /)
      kbo(:, 1,21, 4) = (/ &
        & 0.46924e+03_r8,0.43872e+03_r8,0.51377e+03_r8,0.39635e+03_r8,0.38437e+03_r8 /)
      kbo(:, 2,21, 4) = (/ &
        & 0.46853e+03_r8,0.43819e+03_r8,0.51350e+03_r8,0.39619e+03_r8,0.38437e+03_r8 /)
      kbo(:, 3,21, 4) = (/ &
        & 0.46792e+03_r8,0.43773e+03_r8,0.51323e+03_r8,0.39604e+03_r8,0.38437e+03_r8 /)
      kbo(:, 4,21, 4) = (/ &
        & 0.46739e+03_r8,0.43733e+03_r8,0.51296e+03_r8,0.39592e+03_r8,0.38437e+03_r8 /)
      kbo(:, 5,21, 4) = (/ &
        & 0.46692e+03_r8,0.43697e+03_r8,0.51263e+03_r8,0.39581e+03_r8,0.38437e+03_r8 /)
      kbo(:, 1,22, 4) = (/ &
        & 0.46731e+03_r8,0.43727e+03_r8,0.51254e+03_r8,0.39590e+03_r8,0.38437e+03_r8 /)
      kbo(:, 2,22, 4) = (/ &
        & 0.46675e+03_r8,0.43685e+03_r8,0.51231e+03_r8,0.39577e+03_r8,0.38437e+03_r8 /)
      kbo(:, 3,22, 4) = (/ &
        & 0.46626e+03_r8,0.43648e+03_r8,0.51212e+03_r8,0.39566e+03_r8,0.38437e+03_r8 /)
      kbo(:, 4,22, 4) = (/ &
        & 0.46584e+03_r8,0.43616e+03_r8,0.51190e+03_r8,0.39556e+03_r8,0.38437e+03_r8 /)
      kbo(:, 5,22, 4) = (/ &
        & 0.46546e+03_r8,0.43588e+03_r8,0.51168e+03_r8,0.39548e+03_r8,0.38437e+03_r8 /)
      kbo(:, 1,23, 4) = (/ &
        & 0.46575e+03_r8,0.43610e+03_r8,0.51153e+03_r8,0.39554e+03_r8,0.38437e+03_r8 /)
      kbo(:, 2,23, 4) = (/ &
        & 0.46531e+03_r8,0.43577e+03_r8,0.51138e+03_r8,0.39544e+03_r8,0.38437e+03_r8 /)
      kbo(:, 3,23, 4) = (/ &
        & 0.46492e+03_r8,0.43548e+03_r8,0.51122e+03_r8,0.39535e+03_r8,0.38437e+03_r8 /)
      kbo(:, 4,23, 4) = (/ &
        & 0.46458e+03_r8,0.43522e+03_r8,0.51104e+03_r8,0.39527e+03_r8,0.38437e+03_r8 /)
      kbo(:, 5,23, 4) = (/ &
        & 0.46427e+03_r8,0.43499e+03_r8,0.51086e+03_r8,0.39520e+03_r8,0.38437e+03_r8 /)
      kbo(:, 1,24, 4) = (/ &
        & 0.46450e+03_r8,0.43516e+03_r8,0.51071e+03_r8,0.39525e+03_r8,0.38437e+03_r8 /)
      kbo(:, 2,24, 4) = (/ &
        & 0.46414e+03_r8,0.43489e+03_r8,0.51060e+03_r8,0.39517e+03_r8,0.38437e+03_r8 /)
      kbo(:, 3,24, 4) = (/ &
        & 0.46383e+03_r8,0.43466e+03_r8,0.51047e+03_r8,0.39510e+03_r8,0.38437e+03_r8 /)
      kbo(:, 4,24, 4) = (/ &
        & 0.46356e+03_r8,0.43445e+03_r8,0.51033e+03_r8,0.39504e+03_r8,0.38437e+03_r8 /)
      kbo(:, 5,24, 4) = (/ &
        & 0.46331e+03_r8,0.43427e+03_r8,0.51019e+03_r8,0.39498e+03_r8,0.38437e+03_r8 /)
      kbo(:, 1,25, 4) = (/ &
        & 0.46348e+03_r8,0.43439e+03_r8,0.51003e+03_r8,0.39502e+03_r8,0.38437e+03_r8 /)
      kbo(:, 2,25, 4) = (/ &
        & 0.46319e+03_r8,0.43418e+03_r8,0.50997e+03_r8,0.39496e+03_r8,0.38437e+03_r8 /)
      kbo(:, 3,25, 4) = (/ &
        & 0.46295e+03_r8,0.43400e+03_r8,0.50987e+03_r8,0.39490e+03_r8,0.38437e+03_r8 /)
      kbo(:, 4,25, 4) = (/ &
        & 0.46273e+03_r8,0.43383e+03_r8,0.50976e+03_r8,0.39485e+03_r8,0.38437e+03_r8 /)
      kbo(:, 5,25, 4) = (/ &
        & 0.46254e+03_r8,0.43369e+03_r8,0.50965e+03_r8,0.39480e+03_r8,0.38437e+03_r8 /)
      kbo(:, 1,26, 4) = (/ &
        & 0.46265e+03_r8,0.43378e+03_r8,0.50951e+03_r8,0.39483e+03_r8,0.38437e+03_r8 /)
      kbo(:, 2,26, 4) = (/ &
        & 0.46243e+03_r8,0.43361e+03_r8,0.50946e+03_r8,0.39478e+03_r8,0.38437e+03_r8 /)
      kbo(:, 3,26, 4) = (/ &
        & 0.46223e+03_r8,0.43346e+03_r8,0.50938e+03_r8,0.39473e+03_r8,0.38437e+03_r8 /)
      kbo(:, 4,26, 4) = (/ &
        & 0.46206e+03_r8,0.43333e+03_r8,0.50930e+03_r8,0.39469e+03_r8,0.38437e+03_r8 /)
      kbo(:, 5,26, 4) = (/ &
        & 0.46190e+03_r8,0.43321e+03_r8,0.50921e+03_r8,0.39466e+03_r8,0.38437e+03_r8 /)
      kbo(:, 1,27, 4) = (/ &
        & 0.46199e+03_r8,0.43328e+03_r8,0.50908e+03_r8,0.39468e+03_r8,0.38437e+03_r8 /)
      kbo(:, 2,27, 4) = (/ &
        & 0.46181e+03_r8,0.43314e+03_r8,0.50904e+03_r8,0.39464e+03_r8,0.38437e+03_r8 /)
      kbo(:, 3,27, 4) = (/ &
        & 0.46165e+03_r8,0.43303e+03_r8,0.50899e+03_r8,0.39460e+03_r8,0.38437e+03_r8 /)
      kbo(:, 4,27, 4) = (/ &
        & 0.46152e+03_r8,0.43292e+03_r8,0.50892e+03_r8,0.39457e+03_r8,0.38437e+03_r8 /)
      kbo(:, 5,27, 4) = (/ &
        & 0.46139e+03_r8,0.43283e+03_r8,0.50885e+03_r8,0.39454e+03_r8,0.38437e+03_r8 /)
      kbo(:, 1,28, 4) = (/ &
        & 0.46145e+03_r8,0.43288e+03_r8,0.50873e+03_r8,0.39455e+03_r8,0.38437e+03_r8 /)
      kbo(:, 2,28, 4) = (/ &
        & 0.46131e+03_r8,0.43277e+03_r8,0.50871e+03_r8,0.39452e+03_r8,0.38437e+03_r8 /)
      kbo(:, 3,28, 4) = (/ &
        & 0.46119e+03_r8,0.43268e+03_r8,0.50867e+03_r8,0.39449e+03_r8,0.38437e+03_r8 /)
      kbo(:, 4,28, 4) = (/ &
        & 0.46108e+03_r8,0.43259e+03_r8,0.50862e+03_r8,0.39447e+03_r8,0.38437e+03_r8 /)
      kbo(:, 5,28, 4) = (/ &
        & 0.46098e+03_r8,0.43252e+03_r8,0.50856e+03_r8,0.39445e+03_r8,0.38437e+03_r8 /)
      kbo(:, 1,29, 4) = (/ &
        & 0.46102e+03_r8,0.43255e+03_r8,0.50845e+03_r8,0.39445e+03_r8,0.38437e+03_r8 /)
      kbo(:, 2,29, 4) = (/ &
        & 0.46091e+03_r8,0.43247e+03_r8,0.50844e+03_r8,0.39443e+03_r8,0.38437e+03_r8 /)
      kbo(:, 3,29, 4) = (/ &
        & 0.46081e+03_r8,0.43239e+03_r8,0.50842e+03_r8,0.39441e+03_r8,0.38437e+03_r8 /)
      kbo(:, 4,29, 4) = (/ &
        & 0.46072e+03_r8,0.43233e+03_r8,0.50837e+03_r8,0.39439e+03_r8,0.38437e+03_r8 /)
      kbo(:, 5,29, 4) = (/ &
        & 0.46064e+03_r8,0.43227e+03_r8,0.50832e+03_r8,0.39437e+03_r8,0.38437e+03_r8 /)
      kbo(:, 1,30, 4) = (/ &
        & 0.46067e+03_r8,0.43229e+03_r8,0.50823e+03_r8,0.39437e+03_r8,0.38437e+03_r8 /)
      kbo(:, 2,30, 4) = (/ &
        & 0.46058e+03_r8,0.43223e+03_r8,0.50823e+03_r8,0.39435e+03_r8,0.38437e+03_r8 /)
      kbo(:, 3,30, 4) = (/ &
        & 0.46051e+03_r8,0.43217e+03_r8,0.50821e+03_r8,0.39434e+03_r8,0.38437e+03_r8 /)
      kbo(:, 4,30, 4) = (/ &
        & 0.46044e+03_r8,0.43211e+03_r8,0.50818e+03_r8,0.39432e+03_r8,0.38437e+03_r8 /)
      kbo(:, 5,30, 4) = (/ &
        & 0.46037e+03_r8,0.43207e+03_r8,0.50813e+03_r8,0.39431e+03_r8,0.38437e+03_r8 /)
      kbo(:, 1,31, 4) = (/ &
        & 0.46039e+03_r8,0.43208e+03_r8,0.50805e+03_r8,0.39431e+03_r8,0.38437e+03_r8 /)
      kbo(:, 2,31, 4) = (/ &
        & 0.46032e+03_r8,0.43203e+03_r8,0.50805e+03_r8,0.39429e+03_r8,0.38437e+03_r8 /)
      kbo(:, 3,31, 4) = (/ &
        & 0.46026e+03_r8,0.43198e+03_r8,0.50804e+03_r8,0.39428e+03_r8,0.38437e+03_r8 /)
      kbo(:, 4,31, 4) = (/ &
        & 0.46021e+03_r8,0.43194e+03_r8,0.50801e+03_r8,0.39427e+03_r8,0.38437e+03_r8 /)
      kbo(:, 5,31, 4) = (/ &
        & 0.46016e+03_r8,0.43190e+03_r8,0.50797e+03_r8,0.39426e+03_r8,0.38437e+03_r8 /)
      kbo(:, 1,32, 4) = (/ &
        & 0.46017e+03_r8,0.43191e+03_r8,0.50790e+03_r8,0.39426e+03_r8,0.38437e+03_r8 /)
      kbo(:, 2,32, 4) = (/ &
        & 0.46011e+03_r8,0.43187e+03_r8,0.50792e+03_r8,0.39425e+03_r8,0.38437e+03_r8 /)
      kbo(:, 3,32, 4) = (/ &
        & 0.46006e+03_r8,0.43183e+03_r8,0.50791e+03_r8,0.39423e+03_r8,0.38437e+03_r8 /)
      kbo(:, 4,32, 4) = (/ &
        & 0.46002e+03_r8,0.43180e+03_r8,0.50788e+03_r8,0.39422e+03_r8,0.38437e+03_r8 /)
      kbo(:, 5,32, 4) = (/ &
        & 0.45998e+03_r8,0.43177e+03_r8,0.50784e+03_r8,0.39421e+03_r8,0.38437e+03_r8 /)
      kbo(:, 1,33, 4) = (/ &
        & 0.45999e+03_r8,0.43178e+03_r8,0.50779e+03_r8,0.39422e+03_r8,0.38437e+03_r8 /)
      kbo(:, 2,33, 4) = (/ &
        & 0.45994e+03_r8,0.43174e+03_r8,0.50781e+03_r8,0.39421e+03_r8,0.38437e+03_r8 /)
      kbo(:, 3,33, 4) = (/ &
        & 0.45990e+03_r8,0.43171e+03_r8,0.50780e+03_r8,0.39420e+03_r8,0.38437e+03_r8 /)
      kbo(:, 4,33, 4) = (/ &
        & 0.45987e+03_r8,0.43169e+03_r8,0.50777e+03_r8,0.39419e+03_r8,0.38437e+03_r8 /)
      kbo(:, 5,33, 4) = (/ &
        & 0.45984e+03_r8,0.43166e+03_r8,0.50773e+03_r8,0.39418e+03_r8,0.38437e+03_r8 /)
      kbo(:, 1,34, 4) = (/ &
        & 0.45984e+03_r8,0.43167e+03_r8,0.50770e+03_r8,0.39418e+03_r8,0.38437e+03_r8 /)
      kbo(:, 2,34, 4) = (/ &
        & 0.45981e+03_r8,0.43164e+03_r8,0.50772e+03_r8,0.39418e+03_r8,0.38437e+03_r8 /)
      kbo(:, 3,34, 4) = (/ &
        & 0.45978e+03_r8,0.43162e+03_r8,0.50771e+03_r8,0.39417e+03_r8,0.38437e+03_r8 /)
      kbo(:, 4,34, 4) = (/ &
        & 0.45975e+03_r8,0.43160e+03_r8,0.50768e+03_r8,0.39416e+03_r8,0.38437e+03_r8 /)
      kbo(:, 5,34, 4) = (/ &
        & 0.45972e+03_r8,0.43158e+03_r8,0.50764e+03_r8,0.39416e+03_r8,0.38437e+03_r8 /)
      kbo(:, 1,35, 4) = (/ &
        & 0.45973e+03_r8,0.43158e+03_r8,0.50763e+03_r8,0.39416e+03_r8,0.38437e+03_r8 /)
      kbo(:, 2,35, 4) = (/ &
        & 0.45970e+03_r8,0.43156e+03_r8,0.50764e+03_r8,0.39415e+03_r8,0.38437e+03_r8 /)
      kbo(:, 3,35, 4) = (/ &
        & 0.45968e+03_r8,0.43154e+03_r8,0.50764e+03_r8,0.39414e+03_r8,0.38437e+03_r8 /)
      kbo(:, 4,35, 4) = (/ &
        & 0.45965e+03_r8,0.43153e+03_r8,0.50761e+03_r8,0.39414e+03_r8,0.38437e+03_r8 /)
      kbo(:, 5,35, 4) = (/ &
        & 0.45963e+03_r8,0.43151e+03_r8,0.50757e+03_r8,0.39413e+03_r8,0.38437e+03_r8 /)
      kbo(:, 1,36, 4) = (/ &
        & 0.45964e+03_r8,0.43152e+03_r8,0.50757e+03_r8,0.39414e+03_r8,0.38437e+03_r8 /)
      kbo(:, 2,36, 4) = (/ &
        & 0.45962e+03_r8,0.43150e+03_r8,0.50758e+03_r8,0.39413e+03_r8,0.38437e+03_r8 /)
      kbo(:, 3,36, 4) = (/ &
        & 0.45960e+03_r8,0.43148e+03_r8,0.50758e+03_r8,0.39413e+03_r8,0.38437e+03_r8 /)
      kbo(:, 4,36, 4) = (/ &
        & 0.45958e+03_r8,0.43147e+03_r8,0.50756e+03_r8,0.39412e+03_r8,0.38437e+03_r8 /)
      kbo(:, 5,36, 4) = (/ &
        & 0.45956e+03_r8,0.43146e+03_r8,0.50752e+03_r8,0.39412e+03_r8,0.38437e+03_r8 /)
      kbo(:, 1,37, 4) = (/ &
        & 0.45957e+03_r8,0.43146e+03_r8,0.50751e+03_r8,0.39412e+03_r8,0.38437e+03_r8 /)
      kbo(:, 2,37, 4) = (/ &
        & 0.45955e+03_r8,0.43145e+03_r8,0.50753e+03_r8,0.39412e+03_r8,0.38437e+03_r8 /)
      kbo(:, 3,37, 4) = (/ &
        & 0.45953e+03_r8,0.43144e+03_r8,0.50754e+03_r8,0.39411e+03_r8,0.38437e+03_r8 /)
      kbo(:, 4,37, 4) = (/ &
        & 0.45952e+03_r8,0.43142e+03_r8,0.50752e+03_r8,0.39411e+03_r8,0.38437e+03_r8 /)
      kbo(:, 5,37, 4) = (/ &
        & 0.45950e+03_r8,0.43141e+03_r8,0.50748e+03_r8,0.39411e+03_r8,0.38437e+03_r8 /)
      kbo(:, 1,38, 4) = (/ &
        & 0.45951e+03_r8,0.43142e+03_r8,0.50746e+03_r8,0.39411e+03_r8,0.38437e+03_r8 /)
      kbo(:, 2,38, 4) = (/ &
        & 0.45950e+03_r8,0.43141e+03_r8,0.50749e+03_r8,0.39410e+03_r8,0.38437e+03_r8 /)
      kbo(:, 3,38, 4) = (/ &
        & 0.45948e+03_r8,0.43140e+03_r8,0.50750e+03_r8,0.39410e+03_r8,0.38437e+03_r8 /)
      kbo(:, 4,38, 4) = (/ &
        & 0.45947e+03_r8,0.43139e+03_r8,0.50749e+03_r8,0.39410e+03_r8,0.38437e+03_r8 /)
      kbo(:, 5,38, 4) = (/ &
        & 0.45946e+03_r8,0.43138e+03_r8,0.50745e+03_r8,0.39409e+03_r8,0.38437e+03_r8 /)
      kbo(:, 1,39, 4) = (/ &
        & 0.45946e+03_r8,0.43138e+03_r8,0.50742e+03_r8,0.39410e+03_r8,0.38437e+03_r8 /)
      kbo(:, 2,39, 4) = (/ &
        & 0.45945e+03_r8,0.43137e+03_r8,0.50746e+03_r8,0.39409e+03_r8,0.38437e+03_r8 /)
      kbo(:, 3,39, 4) = (/ &
        & 0.45944e+03_r8,0.43137e+03_r8,0.50747e+03_r8,0.39409e+03_r8,0.38437e+03_r8 /)
      kbo(:, 4,39, 4) = (/ &
        & 0.45943e+03_r8,0.43136e+03_r8,0.50746e+03_r8,0.39409e+03_r8,0.38437e+03_r8 /)
      kbo(:, 5,39, 4) = (/ &
        & 0.45942e+03_r8,0.43135e+03_r8,0.50743e+03_r8,0.39409e+03_r8,0.38437e+03_r8 /)
      kbo(:, 1,40, 4) = (/ &
        & 0.45943e+03_r8,0.43136e+03_r8,0.50738e+03_r8,0.39409e+03_r8,0.38437e+03_r8 /)
      kbo(:, 2,40, 4) = (/ &
        & 0.45941e+03_r8,0.43135e+03_r8,0.50742e+03_r8,0.39408e+03_r8,0.38437e+03_r8 /)
      kbo(:, 3,40, 4) = (/ &
        & 0.45940e+03_r8,0.43134e+03_r8,0.50744e+03_r8,0.39408e+03_r8,0.38437e+03_r8 /)
      kbo(:, 4,40, 4) = (/ &
        & 0.45940e+03_r8,0.43133e+03_r8,0.50744e+03_r8,0.39408e+03_r8,0.38437e+03_r8 /)
      kbo(:, 5,40, 4) = (/ &
        & 0.45939e+03_r8,0.43133e+03_r8,0.50742e+03_r8,0.39408e+03_r8,0.38437e+03_r8 /)
      kbo(:, 1,41, 4) = (/ &
        & 0.45939e+03_r8,0.43133e+03_r8,0.50734e+03_r8,0.39408e+03_r8,0.38437e+03_r8 /)
      kbo(:, 2,41, 4) = (/ &
        & 0.45938e+03_r8,0.43133e+03_r8,0.50739e+03_r8,0.39408e+03_r8,0.38437e+03_r8 /)
      kbo(:, 3,41, 4) = (/ &
        & 0.45938e+03_r8,0.43132e+03_r8,0.50742e+03_r8,0.39408e+03_r8,0.38437e+03_r8 /)
      kbo(:, 4,41, 4) = (/ &
        & 0.45937e+03_r8,0.43131e+03_r8,0.50742e+03_r8,0.39407e+03_r8,0.38437e+03_r8 /)
      kbo(:, 5,41, 4) = (/ &
        & 0.45936e+03_r8,0.43131e+03_r8,0.50741e+03_r8,0.39407e+03_r8,0.38437e+03_r8 /)
      kbo(:, 1,42, 4) = (/ &
        & 0.45937e+03_r8,0.43131e+03_r8,0.50731e+03_r8,0.39407e+03_r8,0.38437e+03_r8 /)
      kbo(:, 2,42, 4) = (/ &
        & 0.45936e+03_r8,0.43131e+03_r8,0.50736e+03_r8,0.39407e+03_r8,0.38437e+03_r8 /)
      kbo(:, 3,42, 4) = (/ &
        & 0.45935e+03_r8,0.43130e+03_r8,0.50739e+03_r8,0.39407e+03_r8,0.38437e+03_r8 /)
      kbo(:, 4,42, 4) = (/ &
        & 0.45935e+03_r8,0.43130e+03_r8,0.50741e+03_r8,0.39407e+03_r8,0.38437e+03_r8 /)
      kbo(:, 5,42, 4) = (/ &
        & 0.45934e+03_r8,0.43129e+03_r8,0.50740e+03_r8,0.39407e+03_r8,0.38437e+03_r8 /)
      kbo(:, 1,43, 4) = (/ &
        & 0.45935e+03_r8,0.43130e+03_r8,0.50727e+03_r8,0.39407e+03_r8,0.38437e+03_r8 /)
      kbo(:, 2,43, 4) = (/ &
        & 0.45934e+03_r8,0.43129e+03_r8,0.50733e+03_r8,0.39407e+03_r8,0.38437e+03_r8 /)
      kbo(:, 3,43, 4) = (/ &
        & 0.45933e+03_r8,0.43129e+03_r8,0.50737e+03_r8,0.39407e+03_r8,0.38437e+03_r8 /)
      kbo(:, 4,43, 4) = (/ &
        & 0.45933e+03_r8,0.43128e+03_r8,0.50739e+03_r8,0.39406e+03_r8,0.38437e+03_r8 /)
      kbo(:, 5,43, 4) = (/ &
        & 0.45932e+03_r8,0.43128e+03_r8,0.50739e+03_r8,0.39406e+03_r8,0.38437e+03_r8 /)
      kbo(:, 1,44, 4) = (/ &
        & 0.45933e+03_r8,0.43128e+03_r8,0.50723e+03_r8,0.39406e+03_r8,0.38437e+03_r8 /)
      kbo(:, 2,44, 4) = (/ &
        & 0.45932e+03_r8,0.43128e+03_r8,0.50730e+03_r8,0.39406e+03_r8,0.38437e+03_r8 /)
      kbo(:, 3,44, 4) = (/ &
        & 0.45932e+03_r8,0.43128e+03_r8,0.50735e+03_r8,0.39406e+03_r8,0.38437e+03_r8 /)
      kbo(:, 4,44, 4) = (/ &
        & 0.45931e+03_r8,0.43127e+03_r8,0.50737e+03_r8,0.39406e+03_r8,0.38437e+03_r8 /)
      kbo(:, 5,44, 4) = (/ &
        & 0.45931e+03_r8,0.43127e+03_r8,0.50738e+03_r8,0.39406e+03_r8,0.38437e+03_r8 /)
      kbo(:, 1,45, 4) = (/ &
        & 0.45931e+03_r8,0.43127e+03_r8,0.50718e+03_r8,0.39406e+03_r8,0.38437e+03_r8 /)
      kbo(:, 2,45, 4) = (/ &
        & 0.45931e+03_r8,0.43127e+03_r8,0.50727e+03_r8,0.39406e+03_r8,0.38437e+03_r8 /)
      kbo(:, 3,45, 4) = (/ &
        & 0.45930e+03_r8,0.43127e+03_r8,0.50732e+03_r8,0.39406e+03_r8,0.38437e+03_r8 /)
      kbo(:, 4,45, 4) = (/ &
        & 0.45930e+03_r8,0.43126e+03_r8,0.50736e+03_r8,0.39406e+03_r8,0.38437e+03_r8 /)
      kbo(:, 5,45, 4) = (/ &
        & 0.45930e+03_r8,0.43126e+03_r8,0.50737e+03_r8,0.39406e+03_r8,0.38437e+03_r8 /)
      kbo(:, 1,46, 4) = (/ &
        & 0.45930e+03_r8,0.43126e+03_r8,0.50714e+03_r8,0.39406e+03_r8,0.38437e+03_r8 /)
      kbo(:, 2,46, 4) = (/ &
        & 0.45930e+03_r8,0.43126e+03_r8,0.50723e+03_r8,0.39406e+03_r8,0.38437e+03_r8 /)
      kbo(:, 3,46, 4) = (/ &
        & 0.45929e+03_r8,0.43126e+03_r8,0.50730e+03_r8,0.39406e+03_r8,0.38437e+03_r8 /)
      kbo(:, 4,46, 4) = (/ &
        & 0.45929e+03_r8,0.43125e+03_r8,0.50734e+03_r8,0.39406e+03_r8,0.38437e+03_r8 /)
      kbo(:, 5,46, 4) = (/ &
        & 0.45929e+03_r8,0.43125e+03_r8,0.50736e+03_r8,0.39406e+03_r8,0.38437e+03_r8 /)
      kbo(:, 1,47, 4) = (/ &
        & 0.45929e+03_r8,0.43126e+03_r8,0.50708e+03_r8,0.39406e+03_r8,0.38437e+03_r8 /)
      kbo(:, 2,47, 4) = (/ &
        & 0.45929e+03_r8,0.43125e+03_r8,0.50719e+03_r8,0.39406e+03_r8,0.38437e+03_r8 /)
      kbo(:, 3,47, 4) = (/ &
        & 0.45928e+03_r8,0.43125e+03_r8,0.50727e+03_r8,0.39405e+03_r8,0.38437e+03_r8 /)
      kbo(:, 4,47, 4) = (/ &
        & 0.45928e+03_r8,0.43125e+03_r8,0.50732e+03_r8,0.39405e+03_r8,0.38437e+03_r8 /)
      kbo(:, 5,47, 4) = (/ &
        & 0.45928e+03_r8,0.43125e+03_r8,0.50735e+03_r8,0.39405e+03_r8,0.38437e+03_r8 /)
      kbo(:, 1,48, 4) = (/ &
        & 0.45928e+03_r8,0.43125e+03_r8,0.50701e+03_r8,0.39405e+03_r8,0.38437e+03_r8 /)
      kbo(:, 2,48, 4) = (/ &
        & 0.45928e+03_r8,0.43125e+03_r8,0.50714e+03_r8,0.39405e+03_r8,0.38437e+03_r8 /)
      kbo(:, 3,48, 4) = (/ &
        & 0.45928e+03_r8,0.43124e+03_r8,0.50723e+03_r8,0.39405e+03_r8,0.38437e+03_r8 /)
      kbo(:, 4,48, 4) = (/ &
        & 0.45927e+03_r8,0.43124e+03_r8,0.50729e+03_r8,0.39405e+03_r8,0.38437e+03_r8 /)
      kbo(:, 5,48, 4) = (/ &
        & 0.45927e+03_r8,0.43124e+03_r8,0.50733e+03_r8,0.39405e+03_r8,0.38437e+03_r8 /)
      kbo(:, 1,49, 4) = (/ &
        & 0.45928e+03_r8,0.43124e+03_r8,0.50694e+03_r8,0.39405e+03_r8,0.38437e+03_r8 /)
      kbo(:, 2,49, 4) = (/ &
        & 0.45927e+03_r8,0.43124e+03_r8,0.50709e+03_r8,0.39405e+03_r8,0.38437e+03_r8 /)
      kbo(:, 3,49, 4) = (/ &
        & 0.45927e+03_r8,0.43124e+03_r8,0.50720e+03_r8,0.39405e+03_r8,0.38437e+03_r8 /)
      kbo(:, 4,49, 4) = (/ &
        & 0.45927e+03_r8,0.43124e+03_r8,0.50727e+03_r8,0.39405e+03_r8,0.38437e+03_r8 /)
      kbo(:, 5,49, 4) = (/ &
        & 0.45927e+03_r8,0.43124e+03_r8,0.50732e+03_r8,0.39405e+03_r8,0.38437e+03_r8 /)
      kbo(:, 1,50, 4) = (/ &
        & 0.45927e+03_r8,0.43124e+03_r8,0.50686e+03_r8,0.39405e+03_r8,0.38437e+03_r8 /)
      kbo(:, 2,50, 4) = (/ &
        & 0.45927e+03_r8,0.43124e+03_r8,0.50704e+03_r8,0.39405e+03_r8,0.38437e+03_r8 /)
      kbo(:, 3,50, 4) = (/ &
        & 0.45927e+03_r8,0.43124e+03_r8,0.50716e+03_r8,0.39405e+03_r8,0.38437e+03_r8 /)
      kbo(:, 4,50, 4) = (/ &
        & 0.45926e+03_r8,0.43123e+03_r8,0.50724e+03_r8,0.39405e+03_r8,0.38437e+03_r8 /)
      kbo(:, 5,50, 4) = (/ &
        & 0.45926e+03_r8,0.43123e+03_r8,0.50730e+03_r8,0.39405e+03_r8,0.38437e+03_r8 /)
      kbo(:, 1,51, 4) = (/ &
        & 0.45926e+03_r8,0.43124e+03_r8,0.50679e+03_r8,0.39405e+03_r8,0.38437e+03_r8 /)
      kbo(:, 2,51, 4) = (/ &
        & 0.45926e+03_r8,0.43123e+03_r8,0.50697e+03_r8,0.39405e+03_r8,0.38437e+03_r8 /)
      kbo(:, 3,51, 4) = (/ &
        & 0.45926e+03_r8,0.43123e+03_r8,0.50711e+03_r8,0.39405e+03_r8,0.38437e+03_r8 /)
      kbo(:, 4,51, 4) = (/ &
        & 0.45926e+03_r8,0.43123e+03_r8,0.50721e+03_r8,0.39405e+03_r8,0.38437e+03_r8 /)
      kbo(:, 5,51, 4) = (/ &
        & 0.45926e+03_r8,0.43123e+03_r8,0.50728e+03_r8,0.39405e+03_r8,0.38437e+03_r8 /)
      kbo(:, 1,52, 4) = (/ &
        & 0.45926e+03_r8,0.43123e+03_r8,0.50671e+03_r8,0.39405e+03_r8,0.38437e+03_r8 /)
      kbo(:, 2,52, 4) = (/ &
        & 0.45926e+03_r8,0.43123e+03_r8,0.50691e+03_r8,0.39405e+03_r8,0.38437e+03_r8 /)
      kbo(:, 3,52, 4) = (/ &
        & 0.45926e+03_r8,0.43123e+03_r8,0.50707e+03_r8,0.39405e+03_r8,0.38437e+03_r8 /)
      kbo(:, 4,52, 4) = (/ &
        & 0.45926e+03_r8,0.43123e+03_r8,0.50718e+03_r8,0.39405e+03_r8,0.38437e+03_r8 /)
      kbo(:, 5,52, 4) = (/ &
        & 0.45925e+03_r8,0.43123e+03_r8,0.50725e+03_r8,0.39405e+03_r8,0.38437e+03_r8 /)
      kbo(:, 1,53, 4) = (/ &
        & 0.45926e+03_r8,0.43123e+03_r8,0.50663e+03_r8,0.39405e+03_r8,0.38437e+03_r8 /)
      kbo(:, 2,53, 4) = (/ &
        & 0.45926e+03_r8,0.43123e+03_r8,0.50684e+03_r8,0.39405e+03_r8,0.38437e+03_r8 /)
      kbo(:, 3,53, 4) = (/ &
        & 0.45925e+03_r8,0.43123e+03_r8,0.50701e+03_r8,0.39405e+03_r8,0.38437e+03_r8 /)
      kbo(:, 4,53, 4) = (/ &
        & 0.45925e+03_r8,0.43123e+03_r8,0.50714e+03_r8,0.39405e+03_r8,0.38437e+03_r8 /)
      kbo(:, 5,53, 4) = (/ &
        & 0.45925e+03_r8,0.43123e+03_r8,0.50722e+03_r8,0.39405e+03_r8,0.38437e+03_r8 /)
      kbo(:, 1,54, 4) = (/ &
        & 0.45925e+03_r8,0.43123e+03_r8,0.50655e+03_r8,0.39405e+03_r8,0.38437e+03_r8 /)
      kbo(:, 2,54, 4) = (/ &
        & 0.45925e+03_r8,0.43123e+03_r8,0.50677e+03_r8,0.39405e+03_r8,0.38437e+03_r8 /)
      kbo(:, 3,54, 4) = (/ &
        & 0.45925e+03_r8,0.43123e+03_r8,0.50696e+03_r8,0.39405e+03_r8,0.38437e+03_r8 /)
      kbo(:, 4,54, 4) = (/ &
        & 0.45925e+03_r8,0.43122e+03_r8,0.50710e+03_r8,0.39405e+03_r8,0.38437e+03_r8 /)
      kbo(:, 5,54, 4) = (/ &
        & 0.45925e+03_r8,0.43122e+03_r8,0.50720e+03_r8,0.39405e+03_r8,0.38437e+03_r8 /)
      kbo(:, 1,55, 4) = (/ &
        & 0.45925e+03_r8,0.43123e+03_r8,0.50647e+03_r8,0.39405e+03_r8,0.38437e+03_r8 /)
      kbo(:, 2,55, 4) = (/ &
        & 0.45925e+03_r8,0.43122e+03_r8,0.50670e+03_r8,0.39405e+03_r8,0.38437e+03_r8 /)
      kbo(:, 3,55, 4) = (/ &
        & 0.45925e+03_r8,0.43122e+03_r8,0.50690e+03_r8,0.39405e+03_r8,0.38437e+03_r8 /)
      kbo(:, 4,55, 4) = (/ &
        & 0.45925e+03_r8,0.43122e+03_r8,0.50706e+03_r8,0.39405e+03_r8,0.38437e+03_r8 /)
      kbo(:, 5,55, 4) = (/ &
        & 0.45925e+03_r8,0.43122e+03_r8,0.50717e+03_r8,0.39405e+03_r8,0.38437e+03_r8 /)
      kbo(:, 1,56, 4) = (/ &
        & 0.45925e+03_r8,0.43122e+03_r8,0.50640e+03_r8,0.39405e+03_r8,0.38437e+03_r8 /)
      kbo(:, 2,56, 4) = (/ &
        & 0.45925e+03_r8,0.43122e+03_r8,0.50663e+03_r8,0.39405e+03_r8,0.38437e+03_r8 /)
      kbo(:, 3,56, 4) = (/ &
        & 0.45925e+03_r8,0.43122e+03_r8,0.50683e+03_r8,0.39405e+03_r8,0.38437e+03_r8 /)
      kbo(:, 4,56, 4) = (/ &
        & 0.45925e+03_r8,0.43122e+03_r8,0.50701e+03_r8,0.39405e+03_r8,0.38437e+03_r8 /)
      kbo(:, 5,56, 4) = (/ &
        & 0.45925e+03_r8,0.43122e+03_r8,0.50714e+03_r8,0.39405e+03_r8,0.38437e+03_r8 /)
      kbo(:, 1,57, 4) = (/ &
        & 0.45925e+03_r8,0.43122e+03_r8,0.50632e+03_r8,0.39405e+03_r8,0.38437e+03_r8 /)
      kbo(:, 2,57, 4) = (/ &
        & 0.45925e+03_r8,0.43122e+03_r8,0.50656e+03_r8,0.39405e+03_r8,0.38437e+03_r8 /)
      kbo(:, 3,57, 4) = (/ &
        & 0.45925e+03_r8,0.43122e+03_r8,0.50677e+03_r8,0.39405e+03_r8,0.38437e+03_r8 /)
      kbo(:, 4,57, 4) = (/ &
        & 0.45925e+03_r8,0.43122e+03_r8,0.50696e+03_r8,0.39405e+03_r8,0.38437e+03_r8 /)
      kbo(:, 5,57, 4) = (/ &
        & 0.45924e+03_r8,0.43122e+03_r8,0.50710e+03_r8,0.39405e+03_r8,0.38437e+03_r8 /)
      kbo(:, 1,58, 4) = (/ &
        & 0.45925e+03_r8,0.43122e+03_r8,0.50624e+03_r8,0.39405e+03_r8,0.38437e+03_r8 /)
      kbo(:, 2,58, 4) = (/ &
        & 0.45925e+03_r8,0.43122e+03_r8,0.50648e+03_r8,0.39405e+03_r8,0.38437e+03_r8 /)
      kbo(:, 3,58, 4) = (/ &
        & 0.45924e+03_r8,0.43122e+03_r8,0.50671e+03_r8,0.39405e+03_r8,0.38437e+03_r8 /)
      kbo(:, 4,58, 4) = (/ &
        & 0.45924e+03_r8,0.43122e+03_r8,0.50690e+03_r8,0.39405e+03_r8,0.38437e+03_r8 /)
      kbo(:, 5,58, 4) = (/ &
        & 0.45924e+03_r8,0.43122e+03_r8,0.50706e+03_r8,0.39405e+03_r8,0.38437e+03_r8 /)
      kbo(:, 1,59, 4) = (/ &
        & 0.45924e+03_r8,0.43122e+03_r8,0.50622e+03_r8,0.39405e+03_r8,0.38437e+03_r8 /)
      kbo(:, 2,59, 4) = (/ &
        & 0.45924e+03_r8,0.43122e+03_r8,0.50645e+03_r8,0.39405e+03_r8,0.38437e+03_r8 /)
      kbo(:, 3,59, 4) = (/ &
        & 0.45924e+03_r8,0.43122e+03_r8,0.50668e+03_r8,0.39405e+03_r8,0.38437e+03_r8 /)
      kbo(:, 4,59, 4) = (/ &
        & 0.45924e+03_r8,0.43122e+03_r8,0.50688e+03_r8,0.39405e+03_r8,0.38437e+03_r8 /)
      kbo(:, 5,59, 4) = (/ &
        & 0.45924e+03_r8,0.43122e+03_r8,0.50704e+03_r8,0.39405e+03_r8,0.38437e+03_r8 /)
      kbo(:, 1,13, 5) = (/ &
        & 0.78037e+03_r8,0.62743e+03_r8,0.56495e+03_r8,0.56633e+03_r8,0.67117e+03_r8 /)
      kbo(:, 2,13, 5) = (/ &
        & 0.77434e+03_r8,0.62291e+03_r8,0.56343e+03_r8,0.56584e+03_r8,0.67117e+03_r8 /)
      kbo(:, 3,13, 5) = (/ &
        & 0.76915e+03_r8,0.61902e+03_r8,0.56189e+03_r8,0.56542e+03_r8,0.67117e+03_r8 /)
      kbo(:, 4,13, 5) = (/ &
        & 0.76464e+03_r8,0.61563e+03_r8,0.56027e+03_r8,0.56506e+03_r8,0.67117e+03_r8 /)
      kbo(:, 5,13, 5) = (/ &
        & 0.76068e+03_r8,0.61266e+03_r8,0.55865e+03_r8,0.56474e+03_r8,0.67117e+03_r8 /)
      kbo(:, 1,14, 5) = (/ &
        & 0.76527e+03_r8,0.61611e+03_r8,0.56011e+03_r8,0.56511e+03_r8,0.67117e+03_r8 /)
      kbo(:, 2,14, 5) = (/ &
        & 0.76041e+03_r8,0.61246e+03_r8,0.55859e+03_r8,0.56472e+03_r8,0.67117e+03_r8 /)
      kbo(:, 3,14, 5) = (/ &
        & 0.75622e+03_r8,0.60932e+03_r8,0.55696e+03_r8,0.56438e+03_r8,0.67117e+03_r8 /)
      kbo(:, 4,14, 5) = (/ &
        & 0.75257e+03_r8,0.60658e+03_r8,0.55539e+03_r8,0.56408e+03_r8,0.67117e+03_r8 /)
      kbo(:, 5,14, 5) = (/ &
        & 0.74936e+03_r8,0.60417e+03_r8,0.55391e+03_r8,0.56383e+03_r8,0.67117e+03_r8 /)
      kbo(:, 1,15, 5) = (/ &
        & 0.75296e+03_r8,0.60688e+03_r8,0.55521e+03_r8,0.56412e+03_r8,0.67117e+03_r8 /)
      kbo(:, 2,15, 5) = (/ &
        & 0.74904e+03_r8,0.60394e+03_r8,0.55372e+03_r8,0.56380e+03_r8,0.67117e+03_r8 /)
      kbo(:, 3,15, 5) = (/ &
        & 0.74566e+03_r8,0.60140e+03_r8,0.55235e+03_r8,0.56353e+03_r8,0.67117e+03_r8 /)
      kbo(:, 4,15, 5) = (/ &
        & 0.74271e+03_r8,0.59919e+03_r8,0.55103e+03_r8,0.56329e+03_r8,0.67117e+03_r8 /)
      kbo(:, 5,15, 5) = (/ &
        & 0.74012e+03_r8,0.59724e+03_r8,0.54977e+03_r8,0.56308e+03_r8,0.67117e+03_r8 /)
      kbo(:, 1,16, 5) = (/ &
        & 0.74295e+03_r8,0.59937e+03_r8,0.55079e+03_r8,0.56331e+03_r8,0.67117e+03_r8 /)
      kbo(:, 2,16, 5) = (/ &
        & 0.73979e+03_r8,0.59700e+03_r8,0.54953e+03_r8,0.56305e+03_r8,0.67117e+03_r8 /)
      kbo(:, 3,16, 5) = (/ &
        & 0.73707e+03_r8,0.59495e+03_r8,0.54828e+03_r8,0.56283e+03_r8,0.67117e+03_r8 /)
      kbo(:, 4,16, 5) = (/ &
        & 0.73469e+03_r8,0.59317e+03_r8,0.54708e+03_r8,0.56264e+03_r8,0.67117e+03_r8 /)
      kbo(:, 5,16, 5) = (/ &
        & 0.73259e+03_r8,0.59160e+03_r8,0.54600e+03_r8,0.56247e+03_r8,0.67117e+03_r8 /)
      kbo(:, 1,17, 5) = (/ &
        & 0.73483e+03_r8,0.59328e+03_r8,0.54695e+03_r8,0.56265e+03_r8,0.67117e+03_r8 /)
      kbo(:, 2,17, 5) = (/ &
        & 0.73229e+03_r8,0.59137e+03_r8,0.54572e+03_r8,0.56245e+03_r8,0.67117e+03_r8 /)
      kbo(:, 3,17, 5) = (/ &
        & 0.73009e+03_r8,0.58972e+03_r8,0.54462e+03_r8,0.56227e+03_r8,0.67117e+03_r8 /)
      kbo(:, 4,17, 5) = (/ &
        & 0.72817e+03_r8,0.58828e+03_r8,0.54366e+03_r8,0.56212e+03_r8,0.67117e+03_r8 /)
      kbo(:, 5,17, 5) = (/ &
        & 0.72647e+03_r8,0.58701e+03_r8,0.54281e+03_r8,0.56198e+03_r8,0.67117e+03_r8 /)
      kbo(:, 1,18, 5) = (/ &
        & 0.72825e+03_r8,0.58834e+03_r8,0.54354e+03_r8,0.56212e+03_r8,0.67117e+03_r8 /)
      kbo(:, 2,18, 5) = (/ &
        & 0.72619e+03_r8,0.58680e+03_r8,0.54253e+03_r8,0.56196e+03_r8,0.67117e+03_r8 /)
      kbo(:, 3,18, 5) = (/ &
        & 0.72442e+03_r8,0.58547e+03_r8,0.54166e+03_r8,0.56181e+03_r8,0.67117e+03_r8 /)
      kbo(:, 4,18, 5) = (/ &
        & 0.72286e+03_r8,0.58430e+03_r8,0.54091e+03_r8,0.56169e+03_r8,0.67117e+03_r8 /)
      kbo(:, 5,18, 5) = (/ &
        & 0.72150e+03_r8,0.58328e+03_r8,0.54024e+03_r8,0.56158e+03_r8,0.67117e+03_r8 /)
      kbo(:, 1,19, 5) = (/ &
        & 0.72290e+03_r8,0.58433e+03_r8,0.54075e+03_r8,0.56169e+03_r8,0.67117e+03_r8 /)
      kbo(:, 2,19, 5) = (/ &
        & 0.72124e+03_r8,0.58309e+03_r8,0.53996e+03_r8,0.56156e+03_r8,0.67117e+03_r8 /)
      kbo(:, 3,19, 5) = (/ &
        & 0.71981e+03_r8,0.58201e+03_r8,0.53928e+03_r8,0.56144e+03_r8,0.67117e+03_r8 /)
      kbo(:, 4,19, 5) = (/ &
        & 0.71856e+03_r8,0.58107e+03_r8,0.53868e+03_r8,0.56134e+03_r8,0.67117e+03_r8 /)
      kbo(:, 5,19, 5) = (/ &
        & 0.71745e+03_r8,0.58024e+03_r8,0.53816e+03_r8,0.56125e+03_r8,0.67117e+03_r8 /)
      kbo(:, 1,20, 5) = (/ &
        & 0.71853e+03_r8,0.58105e+03_r8,0.53849e+03_r8,0.56134e+03_r8,0.67117e+03_r8 /)
      kbo(:, 2,20, 5) = (/ &
        & 0.71720e+03_r8,0.58006e+03_r8,0.53788e+03_r8,0.56123e+03_r8,0.67117e+03_r8 /)
      kbo(:, 3,20, 5) = (/ &
        & 0.71605e+03_r8,0.57919e+03_r8,0.53734e+03_r8,0.56114e+03_r8,0.67117e+03_r8 /)
      kbo(:, 4,20, 5) = (/ &
        & 0.71504e+03_r8,0.57843e+03_r8,0.53687e+03_r8,0.56106e+03_r8,0.67117e+03_r8 /)
      kbo(:, 5,20, 5) = (/ &
        & 0.71414e+03_r8,0.57776e+03_r8,0.53643e+03_r8,0.56098e+03_r8,0.67117e+03_r8 /)
      kbo(:, 1,21, 5) = (/ &
        & 0.71499e+03_r8,0.57840e+03_r8,0.53667e+03_r8,0.56105e+03_r8,0.67117e+03_r8 /)
      kbo(:, 2,21, 5) = (/ &
        & 0.71392e+03_r8,0.57759e+03_r8,0.53620e+03_r8,0.56097e+03_r8,0.67117e+03_r8 /)
      kbo(:, 3,21, 5) = (/ &
        & 0.71299e+03_r8,0.57690e+03_r8,0.53578e+03_r8,0.56089e+03_r8,0.67117e+03_r8 /)
      kbo(:, 4,21, 5) = (/ &
        & 0.71217e+03_r8,0.57628e+03_r8,0.53541e+03_r8,0.56083e+03_r8,0.67117e+03_r8 /)
      kbo(:, 5,21, 5) = (/ &
        & 0.71145e+03_r8,0.57574e+03_r8,0.53506e+03_r8,0.56077e+03_r8,0.67117e+03_r8 /)
      kbo(:, 1,22, 5) = (/ &
        & 0.71206e+03_r8,0.57620e+03_r8,0.53519e+03_r8,0.56082e+03_r8,0.67117e+03_r8 /)
      kbo(:, 2,22, 5) = (/ &
        & 0.71120e+03_r8,0.57555e+03_r8,0.53482e+03_r8,0.56075e+03_r8,0.67117e+03_r8 /)
      kbo(:, 3,22, 5) = (/ &
        & 0.71046e+03_r8,0.57500e+03_r8,0.53450e+03_r8,0.56069e+03_r8,0.67117e+03_r8 /)
      kbo(:, 4,22, 5) = (/ &
        & 0.70981e+03_r8,0.57451e+03_r8,0.53420e+03_r8,0.56064e+03_r8,0.67117e+03_r8 /)
      kbo(:, 5,22, 5) = (/ &
        & 0.70923e+03_r8,0.57408e+03_r8,0.53390e+03_r8,0.56059e+03_r8,0.67117e+03_r8 /)
      kbo(:, 1,23, 5) = (/ &
        & 0.70968e+03_r8,0.57442e+03_r8,0.53396e+03_r8,0.56063e+03_r8,0.67117e+03_r8 /)
      kbo(:, 2,23, 5) = (/ &
        & 0.70900e+03_r8,0.57391e+03_r8,0.53367e+03_r8,0.56057e+03_r8,0.67117e+03_r8 /)
      kbo(:, 3,23, 5) = (/ &
        & 0.70841e+03_r8,0.57346e+03_r8,0.53341e+03_r8,0.56052e+03_r8,0.67117e+03_r8 /)
      kbo(:, 4,23, 5) = (/ &
        & 0.70789e+03_r8,0.57307e+03_r8,0.53316e+03_r8,0.56048e+03_r8,0.67117e+03_r8 /)
      kbo(:, 5,23, 5) = (/ &
        & 0.70743e+03_r8,0.57272e+03_r8,0.53290e+03_r8,0.56044e+03_r8,0.67117e+03_r8 /)
      kbo(:, 1,24, 5) = (/ &
        & 0.70776e+03_r8,0.57298e+03_r8,0.53293e+03_r8,0.56047e+03_r8,0.67117e+03_r8 /)
      kbo(:, 2,24, 5) = (/ &
        & 0.70722e+03_r8,0.57257e+03_r8,0.53269e+03_r8,0.56043e+03_r8,0.67117e+03_r8 /)
      kbo(:, 3,24, 5) = (/ &
        & 0.70675e+03_r8,0.57222e+03_r8,0.53248e+03_r8,0.56039e+03_r8,0.67117e+03_r8 /)
      kbo(:, 4,24, 5) = (/ &
        & 0.70633e+03_r8,0.57190e+03_r8,0.53228e+03_r8,0.56036e+03_r8,0.67117e+03_r8 /)
      kbo(:, 5,24, 5) = (/ &
        & 0.70596e+03_r8,0.57163e+03_r8,0.53207e+03_r8,0.56033e+03_r8,0.67117e+03_r8 /)
      kbo(:, 1,25, 5) = (/ &
        & 0.70621e+03_r8,0.57181e+03_r8,0.53206e+03_r8,0.56035e+03_r8,0.67117e+03_r8 /)
      kbo(:, 2,25, 5) = (/ &
        & 0.70578e+03_r8,0.57149e+03_r8,0.53188e+03_r8,0.56031e+03_r8,0.67117e+03_r8 /)
      kbo(:, 3,25, 5) = (/ &
        & 0.70541e+03_r8,0.57121e+03_r8,0.53172e+03_r8,0.56028e+03_r8,0.67117e+03_r8 /)
      kbo(:, 4,25, 5) = (/ &
        & 0.70507e+03_r8,0.57096e+03_r8,0.53156e+03_r8,0.56025e+03_r8,0.67117e+03_r8 /)
      kbo(:, 5,25, 5) = (/ &
        & 0.70478e+03_r8,0.57074e+03_r8,0.53138e+03_r8,0.56023e+03_r8,0.67117e+03_r8 /)
      kbo(:, 1,26, 5) = (/ &
        & 0.70496e+03_r8,0.57087e+03_r8,0.53135e+03_r8,0.56024e+03_r8,0.67117e+03_r8 /)
      kbo(:, 2,26, 5) = (/ &
        & 0.70461e+03_r8,0.57061e+03_r8,0.53122e+03_r8,0.56022e+03_r8,0.67117e+03_r8 /)
      kbo(:, 3,26, 5) = (/ &
        & 0.70432e+03_r8,0.57039e+03_r8,0.53110e+03_r8,0.56019e+03_r8,0.67117e+03_r8 /)
      kbo(:, 4,26, 5) = (/ &
        & 0.70405e+03_r8,0.57019e+03_r8,0.53097e+03_r8,0.56017e+03_r8,0.67117e+03_r8 /)
      kbo(:, 5,26, 5) = (/ &
        & 0.70382e+03_r8,0.57001e+03_r8,0.53082e+03_r8,0.56015e+03_r8,0.67117e+03_r8 /)
      kbo(:, 1,27, 5) = (/ &
        & 0.70394e+03_r8,0.57011e+03_r8,0.53077e+03_r8,0.56016e+03_r8,0.67117e+03_r8 /)
      kbo(:, 2,27, 5) = (/ &
        & 0.70367e+03_r8,0.56991e+03_r8,0.53069e+03_r8,0.56014e+03_r8,0.67117e+03_r8 /)
      kbo(:, 3,27, 5) = (/ &
        & 0.70343e+03_r8,0.56973e+03_r8,0.53060e+03_r8,0.56012e+03_r8,0.67117e+03_r8 /)
      kbo(:, 4,27, 5) = (/ &
        & 0.70322e+03_r8,0.56957e+03_r8,0.53049e+03_r8,0.56010e+03_r8,0.67117e+03_r8 /)
      kbo(:, 5,27, 5) = (/ &
        & 0.70304e+03_r8,0.56943e+03_r8,0.53036e+03_r8,0.56009e+03_r8,0.67117e+03_r8 /)
      kbo(:, 1,28, 5) = (/ &
        & 0.70313e+03_r8,0.56950e+03_r8,0.53032e+03_r8,0.56010e+03_r8,0.67117e+03_r8 /)
      kbo(:, 2,28, 5) = (/ &
        & 0.70291e+03_r8,0.56934e+03_r8,0.53026e+03_r8,0.56008e+03_r8,0.67117e+03_r8 /)
      kbo(:, 3,28, 5) = (/ &
        & 0.70272e+03_r8,0.56920e+03_r8,0.53019e+03_r8,0.56006e+03_r8,0.67117e+03_r8 /)
      kbo(:, 4,28, 5) = (/ &
        & 0.70256e+03_r8,0.56907e+03_r8,0.53010e+03_r8,0.56005e+03_r8,0.67117e+03_r8 /)
      kbo(:, 5,28, 5) = (/ &
        & 0.70241e+03_r8,0.56896e+03_r8,0.52998e+03_r8,0.56004e+03_r8,0.67117e+03_r8 /)
      kbo(:, 1,29, 5) = (/ &
        & 0.70247e+03_r8,0.56901e+03_r8,0.52995e+03_r8,0.56004e+03_r8,0.67117e+03_r8 /)
      kbo(:, 2,29, 5) = (/ &
        & 0.70230e+03_r8,0.56888e+03_r8,0.52991e+03_r8,0.56003e+03_r8,0.67117e+03_r8 /)
      kbo(:, 3,29, 5) = (/ &
        & 0.70215e+03_r8,0.56877e+03_r8,0.52985e+03_r8,0.56002e+03_r8,0.67117e+03_r8 /)
      kbo(:, 4,29, 5) = (/ &
        & 0.70202e+03_r8,0.56867e+03_r8,0.52978e+03_r8,0.56001e+03_r8,0.67117e+03_r8 /)
      kbo(:, 5,29, 5) = (/ &
        & 0.70190e+03_r8,0.56858e+03_r8,0.52967e+03_r8,0.56000e+03_r8,0.67117e+03_r8 /)
      kbo(:, 1,30, 5) = (/ &
        & 0.70194e+03_r8,0.56861e+03_r8,0.52966e+03_r8,0.56000e+03_r8,0.67117e+03_r8 /)
      kbo(:, 2,30, 5) = (/ &
        & 0.70181e+03_r8,0.56851e+03_r8,0.52963e+03_r8,0.55999e+03_r8,0.67117e+03_r8 /)
      kbo(:, 3,30, 5) = (/ &
        & 0.70169e+03_r8,0.56842e+03_r8,0.52958e+03_r8,0.55998e+03_r8,0.67117e+03_r8 /)
      kbo(:, 4,30, 5) = (/ &
        & 0.70158e+03_r8,0.56834e+03_r8,0.52951e+03_r8,0.55997e+03_r8,0.67117e+03_r8 /)
      kbo(:, 5,30, 5) = (/ &
        & 0.70149e+03_r8,0.56827e+03_r8,0.52941e+03_r8,0.55996e+03_r8,0.67117e+03_r8 /)
      kbo(:, 1,31, 5) = (/ &
        & 0.70151e+03_r8,0.56829e+03_r8,0.52942e+03_r8,0.55997e+03_r8,0.67117e+03_r8 /)
      kbo(:, 2,31, 5) = (/ &
        & 0.70141e+03_r8,0.56821e+03_r8,0.52941e+03_r8,0.55996e+03_r8,0.67117e+03_r8 /)
      kbo(:, 3,31, 5) = (/ &
        & 0.70131e+03_r8,0.56814e+03_r8,0.52936e+03_r8,0.55995e+03_r8,0.67117e+03_r8 /)
      kbo(:, 4,31, 5) = (/ &
        & 0.70123e+03_r8,0.56807e+03_r8,0.52930e+03_r8,0.55994e+03_r8,0.67117e+03_r8 /)
      kbo(:, 5,31, 5) = (/ &
        & 0.70115e+03_r8,0.56802e+03_r8,0.52920e+03_r8,0.55994e+03_r8,0.67117e+03_r8 /)
      kbo(:, 1,32, 5) = (/ &
        & 0.70117e+03_r8,0.56803e+03_r8,0.52924e+03_r8,0.55994e+03_r8,0.67117e+03_r8 /)
      kbo(:, 2,32, 5) = (/ &
        & 0.70109e+03_r8,0.56797e+03_r8,0.52922e+03_r8,0.55993e+03_r8,0.67117e+03_r8 /)
      kbo(:, 3,32, 5) = (/ &
        & 0.70101e+03_r8,0.56791e+03_r8,0.52919e+03_r8,0.55993e+03_r8,0.67117e+03_r8 /)
      kbo(:, 4,32, 5) = (/ &
        & 0.70094e+03_r8,0.56786e+03_r8,0.52912e+03_r8,0.55992e+03_r8,0.67117e+03_r8 /)
      kbo(:, 5,32, 5) = (/ &
        & 0.70088e+03_r8,0.56782e+03_r8,0.52902e+03_r8,0.55992e+03_r8,0.67117e+03_r8 /)
      kbo(:, 1,33, 5) = (/ &
        & 0.70090e+03_r8,0.56782e+03_r8,0.52908e+03_r8,0.55992e+03_r8,0.67117e+03_r8 /)
      kbo(:, 2,33, 5) = (/ &
        & 0.70083e+03_r8,0.56777e+03_r8,0.52907e+03_r8,0.55991e+03_r8,0.67117e+03_r8 /)
      kbo(:, 3,33, 5) = (/ &
        & 0.70077e+03_r8,0.56773e+03_r8,0.52904e+03_r8,0.55991e+03_r8,0.67117e+03_r8 /)
      kbo(:, 4,33, 5) = (/ &
        & 0.70072e+03_r8,0.56769e+03_r8,0.52897e+03_r8,0.55990e+03_r8,0.67117e+03_r8 /)
      kbo(:, 5,33, 5) = (/ &
        & 0.70067e+03_r8,0.56765e+03_r8,0.52887e+03_r8,0.55990e+03_r8,0.67117e+03_r8 /)
      kbo(:, 1,34, 5) = (/ &
        & 0.70068e+03_r8,0.56766e+03_r8,0.52896e+03_r8,0.55990e+03_r8,0.67117e+03_r8 /)
      kbo(:, 2,34, 5) = (/ &
        & 0.70062e+03_r8,0.56762e+03_r8,0.52895e+03_r8,0.55989e+03_r8,0.67117e+03_r8 /)
      kbo(:, 3,34, 5) = (/ &
        & 0.70057e+03_r8,0.56758e+03_r8,0.52892e+03_r8,0.55989e+03_r8,0.67117e+03_r8 /)
      kbo(:, 4,34, 5) = (/ &
        & 0.70053e+03_r8,0.56755e+03_r8,0.52885e+03_r8,0.55989e+03_r8,0.67117e+03_r8 /)
      kbo(:, 5,34, 5) = (/ &
        & 0.70049e+03_r8,0.56752e+03_r8,0.52874e+03_r8,0.55988e+03_r8,0.67117e+03_r8 /)
      kbo(:, 1,35, 5) = (/ &
        & 0.70050e+03_r8,0.56753e+03_r8,0.52886e+03_r8,0.55988e+03_r8,0.67117e+03_r8 /)
      kbo(:, 2,35, 5) = (/ &
        & 0.70046e+03_r8,0.56750e+03_r8,0.52885e+03_r8,0.55988e+03_r8,0.67117e+03_r8 /)
      kbo(:, 3,35, 5) = (/ &
        & 0.70042e+03_r8,0.56747e+03_r8,0.52883e+03_r8,0.55988e+03_r8,0.67117e+03_r8 /)
      kbo(:, 4,35, 5) = (/ &
        & 0.70039e+03_r8,0.56744e+03_r8,0.52876e+03_r8,0.55988e+03_r8,0.67117e+03_r8 /)
      kbo(:, 5,35, 5) = (/ &
        & 0.70035e+03_r8,0.56742e+03_r8,0.52864e+03_r8,0.55987e+03_r8,0.67117e+03_r8 /)
      kbo(:, 1,36, 5) = (/ &
        & 0.70037e+03_r8,0.56743e+03_r8,0.52877e+03_r8,0.55987e+03_r8,0.67117e+03_r8 /)
      kbo(:, 2,36, 5) = (/ &
        & 0.70033e+03_r8,0.56740e+03_r8,0.52878e+03_r8,0.55987e+03_r8,0.67117e+03_r8 /)
      kbo(:, 3,36, 5) = (/ &
        & 0.70030e+03_r8,0.56738e+03_r8,0.52875e+03_r8,0.55987e+03_r8,0.67117e+03_r8 /)
      kbo(:, 4,36, 5) = (/ &
        & 0.70027e+03_r8,0.56736e+03_r8,0.52869e+03_r8,0.55987e+03_r8,0.67117e+03_r8 /)
      kbo(:, 5,36, 5) = (/ &
        & 0.70025e+03_r8,0.56734e+03_r8,0.52857e+03_r8,0.55986e+03_r8,0.67117e+03_r8 /)
      kbo(:, 1,37, 5) = (/ &
        & 0.70026e+03_r8,0.56735e+03_r8,0.52870e+03_r8,0.55986e+03_r8,0.67117e+03_r8 /)
      kbo(:, 2,37, 5) = (/ &
        & 0.70023e+03_r8,0.56733e+03_r8,0.52872e+03_r8,0.55986e+03_r8,0.67117e+03_r8 /)
      kbo(:, 3,37, 5) = (/ &
        & 0.70020e+03_r8,0.56731e+03_r8,0.52870e+03_r8,0.55986e+03_r8,0.67117e+03_r8 /)
      kbo(:, 4,37, 5) = (/ &
        & 0.70018e+03_r8,0.56729e+03_r8,0.52864e+03_r8,0.55986e+03_r8,0.67117e+03_r8 /)
      kbo(:, 5,37, 5) = (/ &
        & 0.70016e+03_r8,0.56727e+03_r8,0.52854e+03_r8,0.55986e+03_r8,0.67117e+03_r8 /)
      kbo(:, 1,38, 5) = (/ &
        & 0.70017e+03_r8,0.56728e+03_r8,0.52864e+03_r8,0.55986e+03_r8,0.67117e+03_r8 /)
      kbo(:, 2,38, 5) = (/ &
        & 0.70015e+03_r8,0.56726e+03_r8,0.52866e+03_r8,0.55986e+03_r8,0.67117e+03_r8 /)
      kbo(:, 3,38, 5) = (/ &
        & 0.70012e+03_r8,0.56725e+03_r8,0.52866e+03_r8,0.55985e+03_r8,0.67117e+03_r8 /)
      kbo(:, 4,38, 5) = (/ &
        & 0.70010e+03_r8,0.56723e+03_r8,0.52860e+03_r8,0.55985e+03_r8,0.67117e+03_r8 /)
      kbo(:, 5,38, 5) = (/ &
        & 0.70009e+03_r8,0.56722e+03_r8,0.52852e+03_r8,0.55985e+03_r8,0.67117e+03_r8 /)
      kbo(:, 1,39, 5) = (/ &
        & 0.70010e+03_r8,0.56723e+03_r8,0.52860e+03_r8,0.55985e+03_r8,0.67117e+03_r8 /)
      kbo(:, 2,39, 5) = (/ &
        & 0.70008e+03_r8,0.56721e+03_r8,0.52862e+03_r8,0.55985e+03_r8,0.67117e+03_r8 /)
      kbo(:, 3,39, 5) = (/ &
        & 0.70006e+03_r8,0.56720e+03_r8,0.52861e+03_r8,0.55985e+03_r8,0.67117e+03_r8 /)
      kbo(:, 4,39, 5) = (/ &
        & 0.70004e+03_r8,0.56719e+03_r8,0.52858e+03_r8,0.55985e+03_r8,0.67117e+03_r8 /)
      kbo(:, 5,39, 5) = (/ &
        & 0.70003e+03_r8,0.56717e+03_r8,0.52850e+03_r8,0.55985e+03_r8,0.67117e+03_r8 /)
      kbo(:, 1,40, 5) = (/ &
        & 0.70004e+03_r8,0.56718e+03_r8,0.52855e+03_r8,0.55985e+03_r8,0.67117e+03_r8 /)
      kbo(:, 2,40, 5) = (/ &
        & 0.70002e+03_r8,0.56717e+03_r8,0.52858e+03_r8,0.55985e+03_r8,0.67117e+03_r8 /)
      kbo(:, 3,40, 5) = (/ &
        & 0.70001e+03_r8,0.56716e+03_r8,0.52859e+03_r8,0.55984e+03_r8,0.67117e+03_r8 /)
      kbo(:, 4,40, 5) = (/ &
        & 0.69999e+03_r8,0.56715e+03_r8,0.52856e+03_r8,0.55984e+03_r8,0.67117e+03_r8 /)
      kbo(:, 5,40, 5) = (/ &
        & 0.69998e+03_r8,0.56714e+03_r8,0.52849e+03_r8,0.55984e+03_r8,0.67117e+03_r8 /)
      kbo(:, 1,41, 5) = (/ &
        & 0.69999e+03_r8,0.56715e+03_r8,0.52850e+03_r8,0.55984e+03_r8,0.67117e+03_r8 /)
      kbo(:, 2,41, 5) = (/ &
        & 0.69998e+03_r8,0.56714e+03_r8,0.52854e+03_r8,0.55984e+03_r8,0.67117e+03_r8 /)
      kbo(:, 3,41, 5) = (/ &
        & 0.69996e+03_r8,0.56713e+03_r8,0.52856e+03_r8,0.55984e+03_r8,0.67117e+03_r8 /)
      kbo(:, 4,41, 5) = (/ &
        & 0.69995e+03_r8,0.56712e+03_r8,0.52854e+03_r8,0.55984e+03_r8,0.67117e+03_r8 /)
      kbo(:, 5,41, 5) = (/ &
        & 0.69994e+03_r8,0.56711e+03_r8,0.52848e+03_r8,0.55984e+03_r8,0.67117e+03_r8 /)
      kbo(:, 1,42, 5) = (/ &
        & 0.69995e+03_r8,0.56712e+03_r8,0.52846e+03_r8,0.55984e+03_r8,0.67117e+03_r8 /)
      kbo(:, 2,42, 5) = (/ &
        & 0.69994e+03_r8,0.56711e+03_r8,0.52851e+03_r8,0.55984e+03_r8,0.67117e+03_r8 /)
      kbo(:, 3,42, 5) = (/ &
        & 0.69993e+03_r8,0.56710e+03_r8,0.52853e+03_r8,0.55984e+03_r8,0.67117e+03_r8 /)
      kbo(:, 4,42, 5) = (/ &
        & 0.69992e+03_r8,0.56709e+03_r8,0.52853e+03_r8,0.55984e+03_r8,0.67117e+03_r8 /)
      kbo(:, 5,42, 5) = (/ &
        & 0.69991e+03_r8,0.56709e+03_r8,0.52848e+03_r8,0.55984e+03_r8,0.67117e+03_r8 /)
      kbo(:, 1,43, 5) = (/ &
        & 0.69992e+03_r8,0.56709e+03_r8,0.52843e+03_r8,0.55984e+03_r8,0.67117e+03_r8 /)
      kbo(:, 2,43, 5) = (/ &
        & 0.69991e+03_r8,0.56708e+03_r8,0.52848e+03_r8,0.55984e+03_r8,0.67117e+03_r8 /)
      kbo(:, 3,43, 5) = (/ &
        & 0.69990e+03_r8,0.56708e+03_r8,0.52851e+03_r8,0.55984e+03_r8,0.67117e+03_r8 /)
      kbo(:, 4,43, 5) = (/ &
        & 0.69989e+03_r8,0.56707e+03_r8,0.52851e+03_r8,0.55984e+03_r8,0.67117e+03_r8 /)
      kbo(:, 5,43, 5) = (/ &
        & 0.69988e+03_r8,0.56707e+03_r8,0.52848e+03_r8,0.55983e+03_r8,0.67117e+03_r8 /)
      kbo(:, 1,44, 5) = (/ &
        & 0.69989e+03_r8,0.56707e+03_r8,0.52838e+03_r8,0.55984e+03_r8,0.67117e+03_r8 /)
      kbo(:, 2,44, 5) = (/ &
        & 0.69988e+03_r8,0.56707e+03_r8,0.52844e+03_r8,0.55983e+03_r8,0.67117e+03_r8 /)
      kbo(:, 3,44, 5) = (/ &
        & 0.69988e+03_r8,0.56706e+03_r8,0.52848e+03_r8,0.55983e+03_r8,0.67117e+03_r8 /)
      kbo(:, 4,44, 5) = (/ &
        & 0.69987e+03_r8,0.56705e+03_r8,0.52850e+03_r8,0.55983e+03_r8,0.67117e+03_r8 /)
      kbo(:, 5,44, 5) = (/ &
        & 0.69986e+03_r8,0.56705e+03_r8,0.52849e+03_r8,0.55983e+03_r8,0.67117e+03_r8 /)
      kbo(:, 1,45, 5) = (/ &
        & 0.69987e+03_r8,0.56706e+03_r8,0.52834e+03_r8,0.55983e+03_r8,0.67117e+03_r8 /)
      kbo(:, 2,45, 5) = (/ &
        & 0.69986e+03_r8,0.56705e+03_r8,0.52841e+03_r8,0.55983e+03_r8,0.67117e+03_r8 /)
      kbo(:, 3,45, 5) = (/ &
        & 0.69986e+03_r8,0.56704e+03_r8,0.52846e+03_r8,0.55983e+03_r8,0.67117e+03_r8 /)
      kbo(:, 4,45, 5) = (/ &
        & 0.69985e+03_r8,0.56704e+03_r8,0.52848e+03_r8,0.55983e+03_r8,0.67117e+03_r8 /)
      kbo(:, 5,45, 5) = (/ &
        & 0.69984e+03_r8,0.56704e+03_r8,0.52848e+03_r8,0.55983e+03_r8,0.67117e+03_r8 /)
      kbo(:, 1,46, 5) = (/ &
        & 0.69985e+03_r8,0.56704e+03_r8,0.52830e+03_r8,0.55983e+03_r8,0.67117e+03_r8 /)
      kbo(:, 2,46, 5) = (/ &
        & 0.69984e+03_r8,0.56704e+03_r8,0.52837e+03_r8,0.55983e+03_r8,0.67117e+03_r8 /)
      kbo(:, 3,46, 5) = (/ &
        & 0.69984e+03_r8,0.56703e+03_r8,0.52843e+03_r8,0.55983e+03_r8,0.67117e+03_r8 /)
      kbo(:, 4,46, 5) = (/ &
        & 0.69983e+03_r8,0.56703e+03_r8,0.52847e+03_r8,0.55983e+03_r8,0.67117e+03_r8 /)
      kbo(:, 5,46, 5) = (/ &
        & 0.69983e+03_r8,0.56703e+03_r8,0.52848e+03_r8,0.55983e+03_r8,0.67117e+03_r8 /)
      kbo(:, 1,47, 5) = (/ &
        & 0.69984e+03_r8,0.56703e+03_r8,0.52826e+03_r8,0.55983e+03_r8,0.67117e+03_r8 /)
      kbo(:, 2,47, 5) = (/ &
        & 0.69983e+03_r8,0.56703e+03_r8,0.52834e+03_r8,0.55983e+03_r8,0.67117e+03_r8 /)
      kbo(:, 3,47, 5) = (/ &
        & 0.69982e+03_r8,0.56702e+03_r8,0.52840e+03_r8,0.55983e+03_r8,0.67117e+03_r8 /)
      kbo(:, 4,47, 5) = (/ &
        & 0.69982e+03_r8,0.56702e+03_r8,0.52845e+03_r8,0.55983e+03_r8,0.67117e+03_r8 /)
      kbo(:, 5,47, 5) = (/ &
        & 0.69982e+03_r8,0.56702e+03_r8,0.52847e+03_r8,0.55983e+03_r8,0.67117e+03_r8 /)
      kbo(:, 1,48, 5) = (/ &
        & 0.69982e+03_r8,0.56702e+03_r8,0.52821e+03_r8,0.55983e+03_r8,0.67117e+03_r8 /)
      kbo(:, 2,48, 5) = (/ &
        & 0.69982e+03_r8,0.56702e+03_r8,0.52830e+03_r8,0.55983e+03_r8,0.67117e+03_r8 /)
      kbo(:, 3,48, 5) = (/ &
        & 0.69981e+03_r8,0.56701e+03_r8,0.52837e+03_r8,0.55983e+03_r8,0.67117e+03_r8 /)
      kbo(:, 4,48, 5) = (/ &
        & 0.69981e+03_r8,0.56701e+03_r8,0.52842e+03_r8,0.55983e+03_r8,0.67117e+03_r8 /)
      kbo(:, 5,48, 5) = (/ &
        & 0.69981e+03_r8,0.56701e+03_r8,0.52845e+03_r8,0.55983e+03_r8,0.67117e+03_r8 /)
      kbo(:, 1,49, 5) = (/ &
        & 0.69981e+03_r8,0.56701e+03_r8,0.52817e+03_r8,0.55983e+03_r8,0.67117e+03_r8 /)
      kbo(:, 2,49, 5) = (/ &
        & 0.69981e+03_r8,0.56701e+03_r8,0.52825e+03_r8,0.55983e+03_r8,0.67117e+03_r8 /)
      kbo(:, 3,49, 5) = (/ &
        & 0.69980e+03_r8,0.56701e+03_r8,0.52833e+03_r8,0.55983e+03_r8,0.67117e+03_r8 /)
      kbo(:, 4,49, 5) = (/ &
        & 0.69980e+03_r8,0.56700e+03_r8,0.52840e+03_r8,0.55983e+03_r8,0.67117e+03_r8 /)
      kbo(:, 5,49, 5) = (/ &
        & 0.69980e+03_r8,0.56700e+03_r8,0.52844e+03_r8,0.55983e+03_r8,0.67117e+03_r8 /)
      kbo(:, 1,50, 5) = (/ &
        & 0.69980e+03_r8,0.56701e+03_r8,0.52812e+03_r8,0.55983e+03_r8,0.67117e+03_r8 /)
      kbo(:, 2,50, 5) = (/ &
        & 0.69980e+03_r8,0.56700e+03_r8,0.52821e+03_r8,0.55983e+03_r8,0.67117e+03_r8 /)
      kbo(:, 3,50, 5) = (/ &
        & 0.69980e+03_r8,0.56700e+03_r8,0.52830e+03_r8,0.55983e+03_r8,0.67117e+03_r8 /)
      kbo(:, 4,50, 5) = (/ &
        & 0.69979e+03_r8,0.56700e+03_r8,0.52837e+03_r8,0.55983e+03_r8,0.67117e+03_r8 /)
      kbo(:, 5,50, 5) = (/ &
        & 0.69979e+03_r8,0.56700e+03_r8,0.52842e+03_r8,0.55983e+03_r8,0.67117e+03_r8 /)
      kbo(:, 1,51, 5) = (/ &
        & 0.69979e+03_r8,0.56700e+03_r8,0.52807e+03_r8,0.55983e+03_r8,0.67117e+03_r8 /)
      kbo(:, 2,51, 5) = (/ &
        & 0.69979e+03_r8,0.56700e+03_r8,0.52818e+03_r8,0.55983e+03_r8,0.67117e+03_r8 /)
      kbo(:, 3,51, 5) = (/ &
        & 0.69979e+03_r8,0.56699e+03_r8,0.52827e+03_r8,0.55983e+03_r8,0.67117e+03_r8 /)
      kbo(:, 4,51, 5) = (/ &
        & 0.69979e+03_r8,0.56699e+03_r8,0.52834e+03_r8,0.55983e+03_r8,0.67117e+03_r8 /)
      kbo(:, 5,51, 5) = (/ &
        & 0.69978e+03_r8,0.56699e+03_r8,0.52841e+03_r8,0.55983e+03_r8,0.67117e+03_r8 /)
      kbo(:, 1,52, 5) = (/ &
        & 0.69979e+03_r8,0.56699e+03_r8,0.52802e+03_r8,0.55983e+03_r8,0.67117e+03_r8 /)
      kbo(:, 2,52, 5) = (/ &
        & 0.69979e+03_r8,0.56699e+03_r8,0.52814e+03_r8,0.55983e+03_r8,0.67117e+03_r8 /)
      kbo(:, 3,52, 5) = (/ &
        & 0.69978e+03_r8,0.56699e+03_r8,0.52823e+03_r8,0.55983e+03_r8,0.67117e+03_r8 /)
      kbo(:, 4,52, 5) = (/ &
        & 0.69978e+03_r8,0.56699e+03_r8,0.52831e+03_r8,0.55983e+03_r8,0.67117e+03_r8 /)
      kbo(:, 5,52, 5) = (/ &
        & 0.69978e+03_r8,0.56699e+03_r8,0.52838e+03_r8,0.55983e+03_r8,0.67117e+03_r8 /)
      kbo(:, 1,53, 5) = (/ &
        & 0.69978e+03_r8,0.56699e+03_r8,0.52798e+03_r8,0.55983e+03_r8,0.67117e+03_r8 /)
      kbo(:, 2,53, 5) = (/ &
        & 0.69978e+03_r8,0.56699e+03_r8,0.52809e+03_r8,0.55983e+03_r8,0.67117e+03_r8 /)
      kbo(:, 3,53, 5) = (/ &
        & 0.69978e+03_r8,0.56699e+03_r8,0.52820e+03_r8,0.55983e+03_r8,0.67117e+03_r8 /)
      kbo(:, 4,53, 5) = (/ &
        & 0.69978e+03_r8,0.56699e+03_r8,0.52828e+03_r8,0.55983e+03_r8,0.67117e+03_r8 /)
      kbo(:, 5,53, 5) = (/ &
        & 0.69977e+03_r8,0.56698e+03_r8,0.52836e+03_r8,0.55983e+03_r8,0.67117e+03_r8 /)
      kbo(:, 1,54, 5) = (/ &
        & 0.69978e+03_r8,0.56699e+03_r8,0.52794e+03_r8,0.55983e+03_r8,0.67117e+03_r8 /)
      kbo(:, 2,54, 5) = (/ &
        & 0.69978e+03_r8,0.56699e+03_r8,0.52804e+03_r8,0.55983e+03_r8,0.67117e+03_r8 /)
      kbo(:, 3,54, 5) = (/ &
        & 0.69977e+03_r8,0.56698e+03_r8,0.52816e+03_r8,0.55983e+03_r8,0.67117e+03_r8 /)
      kbo(:, 4,54, 5) = (/ &
        & 0.69977e+03_r8,0.56698e+03_r8,0.52825e+03_r8,0.55983e+03_r8,0.67117e+03_r8 /)
      kbo(:, 5,54, 5) = (/ &
        & 0.69977e+03_r8,0.56698e+03_r8,0.52833e+03_r8,0.55983e+03_r8,0.67117e+03_r8 /)
      kbo(:, 1,55, 5) = (/ &
        & 0.69977e+03_r8,0.56698e+03_r8,0.52790e+03_r8,0.55983e+03_r8,0.67117e+03_r8 /)
      kbo(:, 2,55, 5) = (/ &
        & 0.69977e+03_r8,0.56698e+03_r8,0.52801e+03_r8,0.55983e+03_r8,0.67117e+03_r8 /)
      kbo(:, 3,55, 5) = (/ &
        & 0.69977e+03_r8,0.56698e+03_r8,0.52812e+03_r8,0.55983e+03_r8,0.67117e+03_r8 /)
      kbo(:, 4,55, 5) = (/ &
        & 0.69977e+03_r8,0.56698e+03_r8,0.52822e+03_r8,0.55983e+03_r8,0.67117e+03_r8 /)
      kbo(:, 5,55, 5) = (/ &
        & 0.69977e+03_r8,0.56698e+03_r8,0.52830e+03_r8,0.55983e+03_r8,0.67117e+03_r8 /)
      kbo(:, 1,56, 5) = (/ &
        & 0.69977e+03_r8,0.56698e+03_r8,0.52786e+03_r8,0.55983e+03_r8,0.67117e+03_r8 /)
      kbo(:, 2,56, 5) = (/ &
        & 0.69977e+03_r8,0.56698e+03_r8,0.52797e+03_r8,0.55983e+03_r8,0.67117e+03_r8 /)
      kbo(:, 3,56, 5) = (/ &
        & 0.69977e+03_r8,0.56698e+03_r8,0.52808e+03_r8,0.55983e+03_r8,0.67117e+03_r8 /)
      kbo(:, 4,56, 5) = (/ &
        & 0.69977e+03_r8,0.56698e+03_r8,0.52819e+03_r8,0.55983e+03_r8,0.67117e+03_r8 /)
      kbo(:, 5,56, 5) = (/ &
        & 0.69977e+03_r8,0.56698e+03_r8,0.52827e+03_r8,0.55983e+03_r8,0.67117e+03_r8 /)
      kbo(:, 1,57, 5) = (/ &
        & 0.69977e+03_r8,0.56698e+03_r8,0.52781e+03_r8,0.55983e+03_r8,0.67117e+03_r8 /)
      kbo(:, 2,57, 5) = (/ &
        & 0.69977e+03_r8,0.56698e+03_r8,0.52794e+03_r8,0.55983e+03_r8,0.67117e+03_r8 /)
      kbo(:, 3,57, 5) = (/ &
        & 0.69977e+03_r8,0.56698e+03_r8,0.52805e+03_r8,0.55983e+03_r8,0.67117e+03_r8 /)
      kbo(:, 4,57, 5) = (/ &
        & 0.69976e+03_r8,0.56698e+03_r8,0.52815e+03_r8,0.55983e+03_r8,0.67117e+03_r8 /)
      kbo(:, 5,57, 5) = (/ &
        & 0.69976e+03_r8,0.56698e+03_r8,0.52825e+03_r8,0.55983e+03_r8,0.67117e+03_r8 /)
      kbo(:, 1,58, 5) = (/ &
        & 0.69977e+03_r8,0.56698e+03_r8,0.52777e+03_r8,0.55983e+03_r8,0.67117e+03_r8 /)
      kbo(:, 2,58, 5) = (/ &
        & 0.69976e+03_r8,0.56698e+03_r8,0.52790e+03_r8,0.55983e+03_r8,0.67117e+03_r8 /)
      kbo(:, 3,58, 5) = (/ &
        & 0.69976e+03_r8,0.56698e+03_r8,0.52801e+03_r8,0.55983e+03_r8,0.67117e+03_r8 /)
      kbo(:, 4,58, 5) = (/ &
        & 0.69976e+03_r8,0.56698e+03_r8,0.52812e+03_r8,0.55982e+03_r8,0.67117e+03_r8 /)
      kbo(:, 5,58, 5) = (/ &
        & 0.69976e+03_r8,0.56697e+03_r8,0.52822e+03_r8,0.55982e+03_r8,0.67117e+03_r8 /)
      kbo(:, 1,59, 5) = (/ &
        & 0.69976e+03_r8,0.56698e+03_r8,0.52775e+03_r8,0.55983e+03_r8,0.67117e+03_r8 /)
      kbo(:, 2,59, 5) = (/ &
        & 0.69976e+03_r8,0.56698e+03_r8,0.52788e+03_r8,0.55982e+03_r8,0.67117e+03_r8 /)
      kbo(:, 3,59, 5) = (/ &
        & 0.69976e+03_r8,0.56697e+03_r8,0.52801e+03_r8,0.55982e+03_r8,0.67117e+03_r8 /)
      kbo(:, 4,59, 5) = (/ &
        & 0.69976e+03_r8,0.56697e+03_r8,0.52811e+03_r8,0.55982e+03_r8,0.67117e+03_r8 /)
      kbo(:, 5,59, 5) = (/ &
        & 0.69976e+03_r8,0.56697e+03_r8,0.52821e+03_r8,0.55982e+03_r8,0.67117e+03_r8 /)
      kbo(:, 1,13, 6) = (/ &
        & 0.99182e+03_r8,0.76479e+03_r8,0.58123e+03_r8,0.73928e+03_r8,0.94808e+03_r8 /)
      kbo(:, 2,13, 6) = (/ &
        & 0.98417e+03_r8,0.75904e+03_r8,0.57888e+03_r8,0.73991e+03_r8,0.94920e+03_r8 /)
      kbo(:, 3,13, 6) = (/ &
        & 0.97757e+03_r8,0.75410e+03_r8,0.57650e+03_r8,0.74029e+03_r8,0.94995e+03_r8 /)
      kbo(:, 4,13, 6) = (/ &
        & 0.97184e+03_r8,0.74980e+03_r8,0.57428e+03_r8,0.74046e+03_r8,0.95033e+03_r8 /)
      kbo(:, 5,13, 6) = (/ &
        & 0.96680e+03_r8,0.74602e+03_r8,0.57217e+03_r8,0.74043e+03_r8,0.95033e+03_r8 /)
      kbo(:, 1,14, 6) = (/ &
        & 0.97264e+03_r8,0.75040e+03_r8,0.57482e+03_r8,0.73884e+03_r8,0.94820e+03_r8 /)
      kbo(:, 2,14, 6) = (/ &
        & 0.96646e+03_r8,0.74576e+03_r8,0.57229e+03_r8,0.73949e+03_r8,0.94928e+03_r8 /)
      kbo(:, 3,14, 6) = (/ &
        & 0.96113e+03_r8,0.74177e+03_r8,0.57016e+03_r8,0.73988e+03_r8,0.95000e+03_r8 /)
      kbo(:, 4,14, 6) = (/ &
        & 0.95649e+03_r8,0.73829e+03_r8,0.56822e+03_r8,0.74006e+03_r8,0.95035e+03_r8 /)
      kbo(:, 5,14, 6) = (/ &
        & 0.95242e+03_r8,0.73523e+03_r8,0.56635e+03_r8,0.74003e+03_r8,0.95032e+03_r8 /)
      kbo(:, 1,15, 6) = (/ &
        & 0.95700e+03_r8,0.73867e+03_r8,0.56844e+03_r8,0.73851e+03_r8,0.94832e+03_r8 /)
      kbo(:, 2,15, 6) = (/ &
        & 0.95201e+03_r8,0.73493e+03_r8,0.56632e+03_r8,0.73916e+03_r8,0.94937e+03_r8 /)
      kbo(:, 3,15, 6) = (/ &
        & 0.94772e+03_r8,0.73170e+03_r8,0.56426e+03_r8,0.73956e+03_r8,0.95005e+03_r8 /)
      kbo(:, 4,15, 6) = (/ &
        & 0.94397e+03_r8,0.72889e+03_r8,0.56242e+03_r8,0.73973e+03_r8,0.95035e+03_r8 /)
      kbo(:, 5,15, 6) = (/ &
        & 0.94067e+03_r8,0.72642e+03_r8,0.56076e+03_r8,0.73970e+03_r8,0.95029e+03_r8 /)
      kbo(:, 1,16, 6) = (/ &
        & 0.94427e+03_r8,0.72912e+03_r8,0.56257e+03_r8,0.73826e+03_r8,0.94846e+03_r8 /)
      kbo(:, 2,16, 6) = (/ &
        & 0.94026e+03_r8,0.72611e+03_r8,0.56064e+03_r8,0.73891e+03_r8,0.94946e+03_r8 /)
      kbo(:, 3,16, 6) = (/ &
        & 0.93679e+03_r8,0.72351e+03_r8,0.55906e+03_r8,0.73929e+03_r8,0.95011e+03_r8 /)
      kbo(:, 4,16, 6) = (/ &
        & 0.93377e+03_r8,0.72124e+03_r8,0.55770e+03_r8,0.73948e+03_r8,0.95036e+03_r8 /)
      kbo(:, 5,16, 6) = (/ &
        & 0.93110e+03_r8,0.71925e+03_r8,0.55641e+03_r8,0.73943e+03_r8,0.95027e+03_r8 /)
      kbo(:, 1,17, 6) = (/ &
        & 0.93395e+03_r8,0.72138e+03_r8,0.55755e+03_r8,0.73807e+03_r8,0.94857e+03_r8 /)
      kbo(:, 2,17, 6) = (/ &
        & 0.93072e+03_r8,0.71896e+03_r8,0.55622e+03_r8,0.73871e+03_r8,0.94955e+03_r8 /)
      kbo(:, 3,17, 6) = (/ &
        & 0.92792e+03_r8,0.71686e+03_r8,0.55497e+03_r8,0.73909e+03_r8,0.95015e+03_r8 /)
      kbo(:, 4,17, 6) = (/ &
        & 0.92548e+03_r8,0.71503e+03_r8,0.55372e+03_r8,0.73925e+03_r8,0.95038e+03_r8 /)
      kbo(:, 5,17, 6) = (/ &
        & 0.92333e+03_r8,0.71341e+03_r8,0.55252e+03_r8,0.73921e+03_r8,0.95024e+03_r8 /)
      kbo(:, 1,18, 6) = (/ &
        & 0.92558e+03_r8,0.71510e+03_r8,0.55360e+03_r8,0.73792e+03_r8,0.94869e+03_r8 /)
      kbo(:, 2,18, 6) = (/ &
        & 0.92297e+03_r8,0.71315e+03_r8,0.55237e+03_r8,0.73856e+03_r8,0.94963e+03_r8 /)
      kbo(:, 3,18, 6) = (/ &
        & 0.92072e+03_r8,0.71146e+03_r8,0.55114e+03_r8,0.73892e+03_r8,0.95019e+03_r8 /)
      kbo(:, 4,18, 6) = (/ &
        & 0.91874e+03_r8,0.70998e+03_r8,0.55001e+03_r8,0.73908e+03_r8,0.95037e+03_r8 /)
      kbo(:, 5,18, 6) = (/ &
        & 0.91700e+03_r8,0.70867e+03_r8,0.54903e+03_r8,0.73903e+03_r8,0.95021e+03_r8 /)
      kbo(:, 1,19, 6) = (/ &
        & 0.91879e+03_r8,0.71001e+03_r8,0.55004e+03_r8,0.73782e+03_r8,0.94880e+03_r8 /)
      kbo(:, 2,19, 6) = (/ &
        & 0.91668e+03_r8,0.70843e+03_r8,0.54889e+03_r8,0.73844e+03_r8,0.94970e+03_r8 /)
      kbo(:, 3,19, 6) = (/ &
        & 0.91486e+03_r8,0.70706e+03_r8,0.54830e+03_r8,0.73880e+03_r8,0.95023e+03_r8 /)
      kbo(:, 4,19, 6) = (/ &
        & 0.91327e+03_r8,0.70587e+03_r8,0.54705e+03_r8,0.73894e+03_r8,0.95037e+03_r8 /)
      kbo(:, 5,19, 6) = (/ &
        & 0.91186e+03_r8,0.70481e+03_r8,0.54615e+03_r8,0.73887e+03_r8,0.95019e+03_r8 /)
      kbo(:, 1,20, 6) = (/ &
        & 0.91324e+03_r8,0.70585e+03_r8,0.54718e+03_r8,0.73776e+03_r8,0.94893e+03_r8 /)
      kbo(:, 2,20, 6) = (/ &
        & 0.91155e+03_r8,0.70458e+03_r8,0.54599e+03_r8,0.73835e+03_r8,0.94979e+03_r8 /)
      kbo(:, 3,20, 6) = (/ &
        & 0.91008e+03_r8,0.70348e+03_r8,0.54519e+03_r8,0.73870e+03_r8,0.95026e+03_r8 /)
      kbo(:, 4,20, 6) = (/ &
        & 0.90879e+03_r8,0.70251e+03_r8,0.54450e+03_r8,0.73882e+03_r8,0.95036e+03_r8 /)
      kbo(:, 5,20, 6) = (/ &
        & 0.90766e+03_r8,0.70166e+03_r8,0.54390e+03_r8,0.73874e+03_r8,0.95013e+03_r8 /)
      kbo(:, 1,21, 6) = (/ &
        & 0.90874e+03_r8,0.70247e+03_r8,0.54444e+03_r8,0.73773e+03_r8,0.94905e+03_r8 /)
      kbo(:, 2,21, 6) = (/ &
        & 0.90737e+03_r8,0.70145e+03_r8,0.54370e+03_r8,0.73831e+03_r8,0.94986e+03_r8 /)
      kbo(:, 3,21, 6) = (/ &
        & 0.90619e+03_r8,0.70056e+03_r8,0.54308e+03_r8,0.73862e+03_r8,0.95029e+03_r8 /)
      kbo(:, 4,21, 6) = (/ &
        & 0.90515e+03_r8,0.69978e+03_r8,0.54255e+03_r8,0.73872e+03_r8,0.95035e+03_r8 /)
      kbo(:, 5,21, 6) = (/ &
        & 0.90424e+03_r8,0.69910e+03_r8,0.54208e+03_r8,0.73862e+03_r8,0.95008e+03_r8 /)
      kbo(:, 1,22, 6) = (/ &
        & 0.90500e+03_r8,0.69967e+03_r8,0.54240e+03_r8,0.73776e+03_r8,0.94923e+03_r8 /)
      kbo(:, 2,22, 6) = (/ &
        & 0.90392e+03_r8,0.69886e+03_r8,0.54185e+03_r8,0.73829e+03_r8,0.94997e+03_r8 /)
      kbo(:, 3,22, 6) = (/ &
        & 0.90297e+03_r8,0.69815e+03_r8,0.54138e+03_r8,0.73857e+03_r8,0.95033e+03_r8 /)
      kbo(:, 4,22, 6) = (/ &
        & 0.90215e+03_r8,0.69753e+03_r8,0.54099e+03_r8,0.73864e+03_r8,0.95033e+03_r8 /)
      kbo(:, 5,22, 6) = (/ &
        & 0.90141e+03_r8,0.69698e+03_r8,0.54066e+03_r8,0.73851e+03_r8,0.94999e+03_r8 /)
      kbo(:, 1,23, 6) = (/ &
        & 0.90199e+03_r8,0.69741e+03_r8,0.54083e+03_r8,0.73780e+03_r8,0.94940e+03_r8 /)
      kbo(:, 2,23, 6) = (/ &
        & 0.90112e+03_r8,0.69676e+03_r8,0.54044e+03_r8,0.73828e+03_r8,0.95007e+03_r8 /)
      kbo(:, 3,23, 6) = (/ &
        & 0.90037e+03_r8,0.69620e+03_r8,0.54010e+03_r8,0.73854e+03_r8,0.95036e+03_r8 /)
      kbo(:, 4,23, 6) = (/ &
        & 0.89971e+03_r8,0.69570e+03_r8,0.53983e+03_r8,0.73858e+03_r8,0.95029e+03_r8 /)
      kbo(:, 5,23, 6) = (/ &
        & 0.89912e+03_r8,0.69526e+03_r8,0.53959e+03_r8,0.73840e+03_r8,0.94989e+03_r8 /)
      kbo(:, 1,24, 6) = (/ &
        & 0.89955e+03_r8,0.69558e+03_r8,0.53965e+03_r8,0.73787e+03_r8,0.94957e+03_r8 /)
      kbo(:, 2,24, 6) = (/ &
        & 0.89886e+03_r8,0.69507e+03_r8,0.53937e+03_r8,0.73829e+03_r8,0.95016e+03_r8 /)
      kbo(:, 3,24, 6) = (/ &
        & 0.89826e+03_r8,0.69461e+03_r8,0.53914e+03_r8,0.73851e+03_r8,0.95038e+03_r8 /)
      kbo(:, 4,24, 6) = (/ &
        & 0.89773e+03_r8,0.69422e+03_r8,0.53895e+03_r8,0.73850e+03_r8,0.95023e+03_r8 /)
      kbo(:, 5,24, 6) = (/ &
        & 0.89726e+03_r8,0.69387e+03_r8,0.53876e+03_r8,0.73829e+03_r8,0.94977e+03_r8 /)
      kbo(:, 1,25, 6) = (/ &
        & 0.89758e+03_r8,0.69410e+03_r8,0.53876e+03_r8,0.73792e+03_r8,0.94973e+03_r8 /)
      kbo(:, 2,25, 6) = (/ &
        & 0.89703e+03_r8,0.69369e+03_r8,0.53857e+03_r8,0.73831e+03_r8,0.95024e+03_r8 /)
      kbo(:, 3,25, 6) = (/ &
        & 0.89655e+03_r8,0.69333e+03_r8,0.53841e+03_r8,0.73848e+03_r8,0.95037e+03_r8 /)
      kbo(:, 4,25, 6) = (/ &
        & 0.89613e+03_r8,0.69302e+03_r8,0.53826e+03_r8,0.73843e+03_r8,0.95016e+03_r8 /)
      kbo(:, 5,25, 6) = (/ &
        & 0.89576e+03_r8,0.69273e+03_r8,0.53811e+03_r8,0.73818e+03_r8,0.94963e+03_r8 /)
      kbo(:, 1,26, 6) = (/ &
        & 0.89598e+03_r8,0.69290e+03_r8,0.53808e+03_r8,0.73799e+03_r8,0.94987e+03_r8 /)
      kbo(:, 2,26, 6) = (/ &
        & 0.89555e+03_r8,0.69258e+03_r8,0.53794e+03_r8,0.73834e+03_r8,0.95030e+03_r8 /)
      kbo(:, 3,26, 6) = (/ &
        & 0.89517e+03_r8,0.69229e+03_r8,0.53782e+03_r8,0.73845e+03_r8,0.95035e+03_r8 /)
      kbo(:, 4,26, 6) = (/ &
        & 0.89483e+03_r8,0.69204e+03_r8,0.53770e+03_r8,0.73836e+03_r8,0.95007e+03_r8 /)
      kbo(:, 5,26, 6) = (/ &
        & 0.89453e+03_r8,0.69182e+03_r8,0.53759e+03_r8,0.73806e+03_r8,0.94946e+03_r8 /)
      kbo(:, 1,27, 6) = (/ &
        & 0.89469e+03_r8,0.69194e+03_r8,0.53754e+03_r8,0.73806e+03_r8,0.95001e+03_r8 /)
      kbo(:, 2,27, 6) = (/ &
        & 0.89435e+03_r8,0.69168e+03_r8,0.53744e+03_r8,0.73835e+03_r8,0.95034e+03_r8 /)
      kbo(:, 3,27, 6) = (/ &
        & 0.89405e+03_r8,0.69145e+03_r8,0.53736e+03_r8,0.73843e+03_r8,0.95031e+03_r8 /)
      kbo(:, 4,27, 6) = (/ &
        & 0.89378e+03_r8,0.69125e+03_r8,0.53727e+03_r8,0.73828e+03_r8,0.94995e+03_r8 /)
      kbo(:, 5,27, 6) = (/ &
        & 0.89354e+03_r8,0.69107e+03_r8,0.53717e+03_r8,0.73792e+03_r8,0.94926e+03_r8 /)
      kbo(:, 1,28, 6) = (/ &
        & 0.89366e+03_r8,0.69116e+03_r8,0.53711e+03_r8,0.73814e+03_r8,0.95012e+03_r8 /)
      kbo(:, 2,28, 6) = (/ &
        & 0.89338e+03_r8,0.69096e+03_r8,0.53705e+03_r8,0.73836e+03_r8,0.95037e+03_r8 /)
      kbo(:, 3,28, 6) = (/ &
        & 0.89314e+03_r8,0.69078e+03_r8,0.53699e+03_r8,0.73838e+03_r8,0.95026e+03_r8 /)
      kbo(:, 4,28, 6) = (/ &
        & 0.89293e+03_r8,0.69062e+03_r8,0.53692e+03_r8,0.73819e+03_r8,0.94982e+03_r8 /)
      kbo(:, 5,28, 6) = (/ &
        & 0.89274e+03_r8,0.69047e+03_r8,0.53684e+03_r8,0.73778e+03_r8,0.94904e+03_r8 /)
      kbo(:, 1,29, 6) = (/ &
        & 0.89282e+03_r8,0.69053e+03_r8,0.53678e+03_r8,0.73818e+03_r8,0.95022e+03_r8 /)
      kbo(:, 2,29, 6) = (/ &
        & 0.89261e+03_r8,0.69037e+03_r8,0.53674e+03_r8,0.73837e+03_r8,0.95037e+03_r8 /)
      kbo(:, 3,29, 6) = (/ &
        & 0.89241e+03_r8,0.69023e+03_r8,0.53670e+03_r8,0.73834e+03_r8,0.95018e+03_r8 /)
      kbo(:, 4,29, 6) = (/ &
        & 0.89224e+03_r8,0.69010e+03_r8,0.53663e+03_r8,0.73810e+03_r8,0.94966e+03_r8 /)
      kbo(:, 5,29, 6) = (/ &
        & 0.89209e+03_r8,0.68999e+03_r8,0.53656e+03_r8,0.73762e+03_r8,0.94880e+03_r8 /)
      kbo(:, 1,30, 6) = (/ &
        & 0.89215e+03_r8,0.69003e+03_r8,0.53652e+03_r8,0.73823e+03_r8,0.95029e+03_r8 /)
      kbo(:, 2,30, 6) = (/ &
        & 0.89198e+03_r8,0.68990e+03_r8,0.53650e+03_r8,0.73836e+03_r8,0.95035e+03_r8 /)
      kbo(:, 3,30, 6) = (/ &
        & 0.89183e+03_r8,0.68979e+03_r8,0.53646e+03_r8,0.73828e+03_r8,0.95008e+03_r8 /)
      kbo(:, 4,30, 6) = (/ &
        & 0.89169e+03_r8,0.68969e+03_r8,0.53641e+03_r8,0.73798e+03_r8,0.94948e+03_r8 /)
      kbo(:, 5,30, 6) = (/ &
        & 0.89157e+03_r8,0.68960e+03_r8,0.53634e+03_r8,0.73744e+03_r8,0.94852e+03_r8 /)
      kbo(:, 1,31, 6) = (/ &
        & 0.89161e+03_r8,0.68962e+03_r8,0.53631e+03_r8,0.73827e+03_r8,0.95034e+03_r8 /)
      kbo(:, 2,31, 6) = (/ &
        & 0.89147e+03_r8,0.68952e+03_r8,0.53629e+03_r8,0.73835e+03_r8,0.95031e+03_r8 /)
      kbo(:, 3,31, 6) = (/ &
        & 0.89135e+03_r8,0.68943e+03_r8,0.53627e+03_r8,0.73821e+03_r8,0.94996e+03_r8 /)
      kbo(:, 4,31, 6) = (/ &
        & 0.89124e+03_r8,0.68935e+03_r8,0.53622e+03_r8,0.73786e+03_r8,0.94927e+03_r8 /)
      kbo(:, 5,31, 6) = (/ &
        & 0.89115e+03_r8,0.68928e+03_r8,0.53615e+03_r8,0.73725e+03_r8,0.94822e+03_r8 /)
      kbo(:, 1,32, 6) = (/ &
        & 0.89117e+03_r8,0.68930e+03_r8,0.53614e+03_r8,0.73830e+03_r8,0.95037e+03_r8 /)
      kbo(:, 2,32, 6) = (/ &
        & 0.89106e+03_r8,0.68922e+03_r8,0.53614e+03_r8,0.73833e+03_r8,0.95025e+03_r8 /)
      kbo(:, 3,32, 6) = (/ &
        & 0.89097e+03_r8,0.68914e+03_r8,0.53611e+03_r8,0.73813e+03_r8,0.94981e+03_r8 /)
      kbo(:, 4,32, 6) = (/ &
        & 0.89088e+03_r8,0.68908e+03_r8,0.53608e+03_r8,0.73772e+03_r8,0.94903e+03_r8 /)
      kbo(:, 5,32, 6) = (/ &
        & 0.89081e+03_r8,0.68902e+03_r8,0.53600e+03_r8,0.73703e+03_r8,0.94789e+03_r8 /)
      kbo(:, 1,33, 6) = (/ &
        & 0.89082e+03_r8,0.68903e+03_r8,0.53602e+03_r8,0.73832e+03_r8,0.95037e+03_r8 /)
      kbo(:, 2,33, 6) = (/ &
        & 0.89073e+03_r8,0.68897e+03_r8,0.53601e+03_r8,0.73829e+03_r8,0.95017e+03_r8 /)
      kbo(:, 3,33, 6) = (/ &
        & 0.89066e+03_r8,0.68891e+03_r8,0.53599e+03_r8,0.73804e+03_r8,0.94964e+03_r8 /)
      kbo(:, 4,33, 6) = (/ &
        & 0.89059e+03_r8,0.68886e+03_r8,0.53595e+03_r8,0.73756e+03_r8,0.94877e+03_r8 /)
      kbo(:, 5,33, 6) = (/ &
        & 0.89053e+03_r8,0.68882e+03_r8,0.53586e+03_r8,0.73678e+03_r8,0.94753e+03_r8 /)
      kbo(:, 1,34, 6) = (/ &
        & 0.89054e+03_r8,0.68882e+03_r8,0.53592e+03_r8,0.73832e+03_r8,0.95035e+03_r8 /)
      kbo(:, 2,34, 6) = (/ &
        & 0.89047e+03_r8,0.68877e+03_r8,0.53592e+03_r8,0.73824e+03_r8,0.95008e+03_r8 /)
      kbo(:, 3,34, 6) = (/ &
        & 0.89041e+03_r8,0.68873e+03_r8,0.53589e+03_r8,0.73795e+03_r8,0.94947e+03_r8 /)
      kbo(:, 4,34, 6) = (/ &
        & 0.89036e+03_r8,0.68869e+03_r8,0.53584e+03_r8,0.73741e+03_r8,0.94852e+03_r8 /)
      kbo(:, 5,34, 6) = (/ &
        & 0.89031e+03_r8,0.68865e+03_r8,0.53575e+03_r8,0.73655e+03_r8,0.94719e+03_r8 /)
      kbo(:, 1,35, 6) = (/ &
        & 0.89032e+03_r8,0.68866e+03_r8,0.53584e+03_r8,0.73832e+03_r8,0.95034e+03_r8 /)
      kbo(:, 2,35, 6) = (/ &
        & 0.89027e+03_r8,0.68862e+03_r8,0.53584e+03_r8,0.73821e+03_r8,0.95002e+03_r8 /)
      kbo(:, 3,35, 6) = (/ &
        & 0.89022e+03_r8,0.68858e+03_r8,0.53581e+03_r8,0.73788e+03_r8,0.94937e+03_r8 /)
      kbo(:, 4,35, 6) = (/ &
        & 0.89017e+03_r8,0.68855e+03_r8,0.53576e+03_r8,0.73731e+03_r8,0.94836e+03_r8 /)
      kbo(:, 5,35, 6) = (/ &
        & 0.89013e+03_r8,0.68852e+03_r8,0.53567e+03_r8,0.73640e+03_r8,0.94700e+03_r8 /)
      kbo(:, 1,36, 6) = (/ &
        & 0.89015e+03_r8,0.68853e+03_r8,0.53577e+03_r8,0.73831e+03_r8,0.95033e+03_r8 /)
      kbo(:, 2,36, 6) = (/ &
        & 0.89010e+03_r8,0.68849e+03_r8,0.53577e+03_r8,0.73820e+03_r8,0.95001e+03_r8 /)
      kbo(:, 3,36, 6) = (/ &
        & 0.89006e+03_r8,0.68846e+03_r8,0.53575e+03_r8,0.73787e+03_r8,0.94935e+03_r8 /)
      kbo(:, 4,36, 6) = (/ &
        & 0.89003e+03_r8,0.68844e+03_r8,0.53570e+03_r8,0.73729e+03_r8,0.94834e+03_r8 /)
      kbo(:, 5,36, 6) = (/ &
        & 0.88999e+03_r8,0.68841e+03_r8,0.53561e+03_r8,0.73637e+03_r8,0.94696e+03_r8 /)
      kbo(:, 1,37, 6) = (/ &
        & 0.89001e+03_r8,0.68843e+03_r8,0.53571e+03_r8,0.73831e+03_r8,0.95036e+03_r8 /)
      kbo(:, 2,37, 6) = (/ &
        & 0.88997e+03_r8,0.68840e+03_r8,0.53572e+03_r8,0.73823e+03_r8,0.95007e+03_r8 /)
      kbo(:, 3,37, 6) = (/ &
        & 0.88994e+03_r8,0.68837e+03_r8,0.53570e+03_r8,0.73792e+03_r8,0.94946e+03_r8 /)
      kbo(:, 4,37, 6) = (/ &
        & 0.88991e+03_r8,0.68835e+03_r8,0.53566e+03_r8,0.73738e+03_r8,0.94849e+03_r8 /)
      kbo(:, 5,37, 6) = (/ &
        & 0.88988e+03_r8,0.68833e+03_r8,0.53557e+03_r8,0.73651e+03_r8,0.94716e+03_r8 /)
      kbo(:, 1,38, 6) = (/ &
        & 0.88990e+03_r8,0.68834e+03_r8,0.53566e+03_r8,0.73830e+03_r8,0.95036e+03_r8 /)
      kbo(:, 2,38, 6) = (/ &
        & 0.88987e+03_r8,0.68832e+03_r8,0.53568e+03_r8,0.73825e+03_r8,0.95013e+03_r8 /)
      kbo(:, 3,38, 6) = (/ &
        & 0.88984e+03_r8,0.68830e+03_r8,0.53566e+03_r8,0.73798e+03_r8,0.94957e+03_r8 /)
      kbo(:, 4,38, 6) = (/ &
        & 0.88982e+03_r8,0.68828e+03_r8,0.53563e+03_r8,0.73747e+03_r8,0.94865e+03_r8 /)
      kbo(:, 5,38, 6) = (/ &
        & 0.88979e+03_r8,0.68826e+03_r8,0.53555e+03_r8,0.73665e+03_r8,0.94737e+03_r8 /)
      kbo(:, 1,39, 6) = (/ &
        & 0.88981e+03_r8,0.68827e+03_r8,0.53562e+03_r8,0.73829e+03_r8,0.95037e+03_r8 /)
      kbo(:, 2,39, 6) = (/ &
        & 0.88978e+03_r8,0.68825e+03_r8,0.53564e+03_r8,0.73826e+03_r8,0.95018e+03_r8 /)
      kbo(:, 3,39, 6) = (/ &
        & 0.88976e+03_r8,0.68824e+03_r8,0.53563e+03_r8,0.73803e+03_r8,0.94966e+03_r8 /)
      kbo(:, 4,39, 6) = (/ &
        & 0.88974e+03_r8,0.68822e+03_r8,0.53560e+03_r8,0.73755e+03_r8,0.94880e+03_r8 /)
      kbo(:, 5,39, 6) = (/ &
        & 0.88972e+03_r8,0.68821e+03_r8,0.53553e+03_r8,0.73679e+03_r8,0.94757e+03_r8 /)
      kbo(:, 1,40, 6) = (/ &
        & 0.88973e+03_r8,0.68822e+03_r8,0.53558e+03_r8,0.73826e+03_r8,0.95037e+03_r8 /)
      kbo(:, 2,40, 6) = (/ &
        & 0.88971e+03_r8,0.68820e+03_r8,0.53561e+03_r8,0.73829e+03_r8,0.95026e+03_r8 /)
      kbo(:, 3,40, 6) = (/ &
        & 0.88969e+03_r8,0.68819e+03_r8,0.53561e+03_r8,0.73810e+03_r8,0.94982e+03_r8 /)
      kbo(:, 4,40, 6) = (/ &
        & 0.88967e+03_r8,0.68817e+03_r8,0.53559e+03_r8,0.73769e+03_r8,0.94904e+03_r8 /)
      kbo(:, 5,40, 6) = (/ &
        & 0.88966e+03_r8,0.68816e+03_r8,0.53553e+03_r8,0.73700e+03_r8,0.94790e+03_r8 /)
      kbo(:, 1,41, 6) = (/ &
        & 0.88967e+03_r8,0.68817e+03_r8,0.53555e+03_r8,0.73822e+03_r8,0.95035e+03_r8 /)
      kbo(:, 2,41, 6) = (/ &
        & 0.88965e+03_r8,0.68816e+03_r8,0.53558e+03_r8,0.73830e+03_r8,0.95031e+03_r8 /)
      kbo(:, 3,41, 6) = (/ &
        & 0.88964e+03_r8,0.68815e+03_r8,0.53559e+03_r8,0.73817e+03_r8,0.94996e+03_r8 /)
      kbo(:, 4,41, 6) = (/ &
        & 0.88962e+03_r8,0.68813e+03_r8,0.53558e+03_r8,0.73782e+03_r8,0.94927e+03_r8 /)
      kbo(:, 5,41, 6) = (/ &
        & 0.88961e+03_r8,0.68812e+03_r8,0.53553e+03_r8,0.73722e+03_r8,0.94822e+03_r8 /)
      kbo(:, 1,42, 6) = (/ &
        & 0.88962e+03_r8,0.68813e+03_r8,0.53551e+03_r8,0.73816e+03_r8,0.95029e+03_r8 /)
      kbo(:, 2,42, 6) = (/ &
        & 0.88960e+03_r8,0.68812e+03_r8,0.53555e+03_r8,0.73830e+03_r8,0.95035e+03_r8 /)
      kbo(:, 3,42, 6) = (/ &
        & 0.88959e+03_r8,0.68811e+03_r8,0.53557e+03_r8,0.73822e+03_r8,0.95008e+03_r8 /)
      kbo(:, 4,42, 6) = (/ &
        & 0.88958e+03_r8,0.68810e+03_r8,0.53556e+03_r8,0.73793e+03_r8,0.94948e+03_r8 /)
      kbo(:, 5,42, 6) = (/ &
        & 0.88957e+03_r8,0.68809e+03_r8,0.53553e+03_r8,0.73739e+03_r8,0.94853e+03_r8 /)
      kbo(:, 1,43, 6) = (/ &
        & 0.88958e+03_r8,0.68810e+03_r8,0.53547e+03_r8,0.73807e+03_r8,0.95020e+03_r8 /)
      kbo(:, 2,43, 6) = (/ &
        & 0.88957e+03_r8,0.68809e+03_r8,0.53552e+03_r8,0.73828e+03_r8,0.95037e+03_r8 /)
      kbo(:, 3,43, 6) = (/ &
        & 0.88955e+03_r8,0.68808e+03_r8,0.53555e+03_r8,0.73826e+03_r8,0.95020e+03_r8 /)
      kbo(:, 4,43, 6) = (/ &
        & 0.88954e+03_r8,0.68808e+03_r8,0.53555e+03_r8,0.73804e+03_r8,0.94970e+03_r8 /)
      kbo(:, 5,43, 6) = (/ &
        & 0.88953e+03_r8,0.68807e+03_r8,0.53553e+03_r8,0.73758e+03_r8,0.94886e+03_r8 /)
      kbo(:, 1,44, 6) = (/ &
        & 0.88954e+03_r8,0.68808e+03_r8,0.53544e+03_r8,0.73795e+03_r8,0.95005e+03_r8 /)
      kbo(:, 2,44, 6) = (/ &
        & 0.88953e+03_r8,0.68807e+03_r8,0.53549e+03_r8,0.73823e+03_r8,0.95035e+03_r8 /)
      kbo(:, 3,44, 6) = (/ &
        & 0.88952e+03_r8,0.68806e+03_r8,0.53553e+03_r8,0.73829e+03_r8,0.95030e+03_r8 /)
      kbo(:, 4,44, 6) = (/ &
        & 0.88951e+03_r8,0.68805e+03_r8,0.53554e+03_r8,0.73815e+03_r8,0.94991e+03_r8 /)
      kbo(:, 5,44, 6) = (/ &
        & 0.88951e+03_r8,0.68805e+03_r8,0.53553e+03_r8,0.73776e+03_r8,0.94919e+03_r8 /)
      kbo(:, 1,45, 6) = (/ &
        & 0.88952e+03_r8,0.68806e+03_r8,0.53540e+03_r8,0.73782e+03_r8,0.94987e+03_r8 /)
      kbo(:, 2,45, 6) = (/ &
        & 0.88951e+03_r8,0.68805e+03_r8,0.53547e+03_r8,0.73816e+03_r8,0.95030e+03_r8 /)
      kbo(:, 3,45, 6) = (/ &
        & 0.88950e+03_r8,0.68804e+03_r8,0.53551e+03_r8,0.73830e+03_r8,0.95035e+03_r8 /)
      kbo(:, 4,45, 6) = (/ &
        & 0.88949e+03_r8,0.68804e+03_r8,0.53553e+03_r8,0.73821e+03_r8,0.95008e+03_r8 /)
      kbo(:, 5,45, 6) = (/ &
        & 0.88948e+03_r8,0.68803e+03_r8,0.53553e+03_r8,0.73792e+03_r8,0.94947e+03_r8 /)
      kbo(:, 1,46, 6) = (/ &
        & 0.88949e+03_r8,0.68804e+03_r8,0.53537e+03_r8,0.73763e+03_r8,0.94962e+03_r8 /)
      kbo(:, 2,46, 6) = (/ &
        & 0.88948e+03_r8,0.68803e+03_r8,0.53544e+03_r8,0.73806e+03_r8,0.95019e+03_r8 /)
      kbo(:, 3,46, 6) = (/ &
        & 0.88948e+03_r8,0.68803e+03_r8,0.53549e+03_r8,0.73827e+03_r8,0.95037e+03_r8 /)
      kbo(:, 4,46, 6) = (/ &
        & 0.88947e+03_r8,0.68802e+03_r8,0.53552e+03_r8,0.73827e+03_r8,0.95021e+03_r8 /)
      kbo(:, 5,46, 6) = (/ &
        & 0.88946e+03_r8,0.68802e+03_r8,0.53552e+03_r8,0.73805e+03_r8,0.94973e+03_r8 /)
      kbo(:, 1,47, 6) = (/ &
        & 0.88947e+03_r8,0.68802e+03_r8,0.53531e+03_r8,0.73737e+03_r8,0.94929e+03_r8 /)
      kbo(:, 2,47, 6) = (/ &
        & 0.88947e+03_r8,0.68802e+03_r8,0.53539e+03_r8,0.73792e+03_r8,0.95000e+03_r8 /)
      kbo(:, 3,47, 6) = (/ &
        & 0.88946e+03_r8,0.68801e+03_r8,0.53546e+03_r8,0.73821e+03_r8,0.95034e+03_r8 /)
      kbo(:, 4,47, 6) = (/ &
        & 0.88945e+03_r8,0.68801e+03_r8,0.53550e+03_r8,0.73829e+03_r8,0.95032e+03_r8 /)
      kbo(:, 5,47, 6) = (/ &
        & 0.88945e+03_r8,0.68800e+03_r8,0.53551e+03_r8,0.73816e+03_r8,0.94996e+03_r8 /)
      kbo(:, 1,48, 6) = (/ &
        & 0.88946e+03_r8,0.68801e+03_r8,0.53528e+03_r8,0.73708e+03_r8,0.94889e+03_r8 /)
      kbo(:, 2,48, 6) = (/ &
        & 0.88945e+03_r8,0.68801e+03_r8,0.53536e+03_r8,0.73773e+03_r8,0.94976e+03_r8 /)
      kbo(:, 3,48, 6) = (/ &
        & 0.88944e+03_r8,0.68800e+03_r8,0.53543e+03_r8,0.73812e+03_r8,0.95025e+03_r8 /)
      kbo(:, 4,48, 6) = (/ &
        & 0.88944e+03_r8,0.68800e+03_r8,0.53548e+03_r8,0.73829e+03_r8,0.95037e+03_r8 /)
      kbo(:, 5,48, 6) = (/ &
        & 0.88944e+03_r8,0.68800e+03_r8,0.53551e+03_r8,0.73824e+03_r8,0.95014e+03_r8 /)
      kbo(:, 1,49, 6) = (/ &
        & 0.88944e+03_r8,0.68800e+03_r8,0.53524e+03_r8,0.73674e+03_r8,0.94844e+03_r8 /)
      kbo(:, 2,49, 6) = (/ &
        & 0.88944e+03_r8,0.68800e+03_r8,0.53533e+03_r8,0.73750e+03_r8,0.94945e+03_r8 /)
      kbo(:, 3,49, 6) = (/ &
        & 0.88943e+03_r8,0.68799e+03_r8,0.53540e+03_r8,0.73799e+03_r8,0.95016e+03_r8 /)
      kbo(:, 4,49, 6) = (/ &
        & 0.88943e+03_r8,0.68799e+03_r8,0.53546e+03_r8,0.73825e+03_r8,0.95036e+03_r8 /)
      kbo(:, 5,49, 6) = (/ &
        & 0.88942e+03_r8,0.68799e+03_r8,0.53549e+03_r8,0.73828e+03_r8,0.95027e+03_r8 /)
      kbo(:, 1,50, 6) = (/ &
        & 0.88943e+03_r8,0.68799e+03_r8,0.53521e+03_r8,0.73638e+03_r8,0.94796e+03_r8 /)
      kbo(:, 2,50, 6) = (/ &
        & 0.88943e+03_r8,0.68799e+03_r8,0.53529e+03_r8,0.73724e+03_r8,0.94911e+03_r8 /)
      kbo(:, 3,50, 6) = (/ &
        & 0.88942e+03_r8,0.68798e+03_r8,0.53537e+03_r8,0.73783e+03_r8,0.94990e+03_r8 /)
      kbo(:, 4,50, 6) = (/ &
        & 0.88942e+03_r8,0.68798e+03_r8,0.53544e+03_r8,0.73817e+03_r8,0.95031e+03_r8 /)
      kbo(:, 5,50, 6) = (/ &
        & 0.88942e+03_r8,0.68798e+03_r8,0.53548e+03_r8,0.73829e+03_r8,0.95034e+03_r8 /)
      kbo(:, 1,51, 6) = (/ &
        & 0.88942e+03_r8,0.68798e+03_r8,0.53518e+03_r8,0.73600e+03_r8,0.94745e+03_r8 /)
      kbo(:, 2,51, 6) = (/ &
        & 0.88942e+03_r8,0.68798e+03_r8,0.53525e+03_r8,0.73696e+03_r8,0.94873e+03_r8 /)
      kbo(:, 3,51, 6) = (/ &
        & 0.88941e+03_r8,0.68798e+03_r8,0.53533e+03_r8,0.73765e+03_r8,0.94966e+03_r8 /)
      kbo(:, 4,51, 6) = (/ &
        & 0.88941e+03_r8,0.68798e+03_r8,0.53541e+03_r8,0.73807e+03_r8,0.95020e+03_r8 /)
      kbo(:, 5,51, 6) = (/ &
        & 0.88941e+03_r8,0.68797e+03_r8,0.53546e+03_r8,0.73827e+03_r8,0.95037e+03_r8 /)
      kbo(:, 1,52, 6) = (/ &
        & 0.88941e+03_r8,0.68798e+03_r8,0.53513e+03_r8,0.73556e+03_r8,0.94688e+03_r8 /)
      kbo(:, 2,52, 6) = (/ &
        & 0.88941e+03_r8,0.68798e+03_r8,0.53522e+03_r8,0.73664e+03_r8,0.94831e+03_r8 /)
      kbo(:, 3,52, 6) = (/ &
        & 0.88941e+03_r8,0.68797e+03_r8,0.53531e+03_r8,0.73743e+03_r8,0.94936e+03_r8 /)
      kbo(:, 4,52, 6) = (/ &
        & 0.88940e+03_r8,0.68797e+03_r8,0.53538e+03_r8,0.73795e+03_r8,0.95005e+03_r8 /)
      kbo(:, 5,52, 6) = (/ &
        & 0.88940e+03_r8,0.68797e+03_r8,0.53545e+03_r8,0.73822e+03_r8,0.95036e+03_r8 /)
      kbo(:, 1,53, 6) = (/ &
        & 0.88941e+03_r8,0.68797e+03_r8,0.53507e+03_r8,0.73509e+03_r8,0.94627e+03_r8 /)
      kbo(:, 2,53, 6) = (/ &
        & 0.88940e+03_r8,0.68797e+03_r8,0.53519e+03_r8,0.73629e+03_r8,0.94784e+03_r8 /)
      kbo(:, 3,53, 6) = (/ &
        & 0.88940e+03_r8,0.68797e+03_r8,0.53527e+03_r8,0.73717e+03_r8,0.94902e+03_r8 /)
      kbo(:, 4,53, 6) = (/ &
        & 0.88940e+03_r8,0.68797e+03_r8,0.53535e+03_r8,0.73779e+03_r8,0.94984e+03_r8 /)
      kbo(:, 5,53, 6) = (/ &
        & 0.88940e+03_r8,0.68797e+03_r8,0.53542e+03_r8,0.73815e+03_r8,0.95029e+03_r8 /)
      kbo(:, 1,54, 6) = (/ &
        & 0.88940e+03_r8,0.68797e+03_r8,0.53502e+03_r8,0.73463e+03_r8,0.94566e+03_r8 /)
      kbo(:, 2,54, 6) = (/ &
        & 0.88940e+03_r8,0.68797e+03_r8,0.53516e+03_r8,0.73592e+03_r8,0.94735e+03_r8 /)
      kbo(:, 3,54, 6) = (/ &
        & 0.88940e+03_r8,0.68796e+03_r8,0.53524e+03_r8,0.73691e+03_r8,0.94866e+03_r8 /)
      kbo(:, 4,54, 6) = (/ &
        & 0.88939e+03_r8,0.68796e+03_r8,0.53533e+03_r8,0.73761e+03_r8,0.94961e+03_r8 /)
      kbo(:, 5,54, 6) = (/ &
        & 0.88939e+03_r8,0.68796e+03_r8,0.53539e+03_r8,0.73805e+03_r8,0.95018e+03_r8 /)
      kbo(:, 1,55, 6) = (/ &
        & 0.88940e+03_r8,0.68796e+03_r8,0.53495e+03_r8,0.73415e+03_r8,0.94503e+03_r8 /)
      kbo(:, 2,55, 6) = (/ &
        & 0.88939e+03_r8,0.68796e+03_r8,0.53513e+03_r8,0.73554e+03_r8,0.94685e+03_r8 /)
      kbo(:, 3,55, 6) = (/ &
        & 0.88939e+03_r8,0.68796e+03_r8,0.53521e+03_r8,0.73662e+03_r8,0.94828e+03_r8 /)
      kbo(:, 4,55, 6) = (/ &
        & 0.88939e+03_r8,0.68796e+03_r8,0.53530e+03_r8,0.73742e+03_r8,0.94934e+03_r8 /)
      kbo(:, 5,55, 6) = (/ &
        & 0.88939e+03_r8,0.68796e+03_r8,0.53537e+03_r8,0.73794e+03_r8,0.95004e+03_r8 /)
      kbo(:, 1,56, 6) = (/ &
        & 0.88939e+03_r8,0.68796e+03_r8,0.53489e+03_r8,0.73364e+03_r8,0.94437e+03_r8 /)
      kbo(:, 2,56, 6) = (/ &
        & 0.88939e+03_r8,0.68796e+03_r8,0.53507e+03_r8,0.73512e+03_r8,0.94631e+03_r8 /)
      kbo(:, 3,56, 6) = (/ &
        & 0.88939e+03_r8,0.68796e+03_r8,0.53519e+03_r8,0.73631e+03_r8,0.94787e+03_r8 /)
      kbo(:, 4,56, 6) = (/ &
        & 0.88939e+03_r8,0.68796e+03_r8,0.53527e+03_r8,0.73719e+03_r8,0.94904e+03_r8 /)
      kbo(:, 5,56, 6) = (/ &
        & 0.88938e+03_r8,0.68796e+03_r8,0.53535e+03_r8,0.73780e+03_r8,0.94987e+03_r8 /)
      kbo(:, 1,57, 6) = (/ &
        & 0.88939e+03_r8,0.68796e+03_r8,0.53481e+03_r8,0.73310e+03_r8,0.94366e+03_r8 /)
      kbo(:, 2,57, 6) = (/ &
        & 0.88939e+03_r8,0.68796e+03_r8,0.53502e+03_r8,0.73469e+03_r8,0.94573e+03_r8 /)
      kbo(:, 3,57, 6) = (/ &
        & 0.88938e+03_r8,0.68796e+03_r8,0.53516e+03_r8,0.73597e+03_r8,0.94741e+03_r8 /)
      kbo(:, 4,57, 6) = (/ &
        & 0.88938e+03_r8,0.68796e+03_r8,0.53524e+03_r8,0.73694e+03_r8,0.94871e+03_r8 /)
      kbo(:, 5,57, 6) = (/ &
        & 0.88938e+03_r8,0.68795e+03_r8,0.53532e+03_r8,0.73764e+03_r8,0.94964e+03_r8 /)
      kbo(:, 1,58, 6) = (/ &
        & 0.88938e+03_r8,0.68796e+03_r8,0.53474e+03_r8,0.73255e+03_r8,0.94296e+03_r8 /)
      kbo(:, 2,58, 6) = (/ &
        & 0.88938e+03_r8,0.68796e+03_r8,0.53496e+03_r8,0.73423e+03_r8,0.94515e+03_r8 /)
      kbo(:, 3,58, 6) = (/ &
        & 0.88938e+03_r8,0.68795e+03_r8,0.53512e+03_r8,0.73561e+03_r8,0.94695e+03_r8 /)
      kbo(:, 4,58, 6) = (/ &
        & 0.88938e+03_r8,0.68795e+03_r8,0.53522e+03_r8,0.73667e+03_r8,0.94836e+03_r8 /)
      kbo(:, 5,58, 6) = (/ &
        & 0.88938e+03_r8,0.68795e+03_r8,0.53530e+03_r8,0.73745e+03_r8,0.94939e+03_r8 /)
      kbo(:, 1,59, 6) = (/ &
        & 0.88938e+03_r8,0.68795e+03_r8,0.53470e+03_r8,0.73233e+03_r8,0.94266e+03_r8 /)
      kbo(:, 2,59, 6) = (/ &
        & 0.88938e+03_r8,0.68795e+03_r8,0.53494e+03_r8,0.73405e+03_r8,0.94490e+03_r8 /)
      kbo(:, 3,59, 6) = (/ &
        & 0.88938e+03_r8,0.68795e+03_r8,0.53510e+03_r8,0.73546e+03_r8,0.94675e+03_r8 /)
      kbo(:, 4,59, 6) = (/ &
        & 0.88938e+03_r8,0.68795e+03_r8,0.53521e+03_r8,0.73657e+03_r8,0.94820e+03_r8 /)
      kbo(:, 5,59, 6) = (/ &
        & 0.88938e+03_r8,0.68795e+03_r8,0.53529e+03_r8,0.73737e+03_r8,0.94929e+03_r8 /)
      kbo(:, 1,13, 7) = (/ &
        & 0.11104e+04_r8,0.84453e+03_r8,0.58852e+03_r8,0.81799e+03_r8,0.10746e+04_r8 /)
      kbo(:, 2,13, 7) = (/ &
        & 0.11019e+04_r8,0.83810e+03_r8,0.58572e+03_r8,0.81836e+03_r8,0.10752e+04_r8 /)
      kbo(:, 3,13, 7) = (/ &
        & 0.10945e+04_r8,0.83257e+03_r8,0.58306e+03_r8,0.81848e+03_r8,0.10754e+04_r8 /)
      kbo(:, 4,13, 7) = (/ &
        & 0.10881e+04_r8,0.82775e+03_r8,0.58047e+03_r8,0.81831e+03_r8,0.10753e+04_r8 /)
      kbo(:, 5,13, 7) = (/ &
        & 0.10824e+04_r8,0.82352e+03_r8,0.57809e+03_r8,0.81788e+03_r8,0.10749e+04_r8 /)
      kbo(:, 1,14, 7) = (/ &
        & 0.10890e+04_r8,0.82842e+03_r8,0.58087e+03_r8,0.81780e+03_r8,0.10747e+04_r8 /)
      kbo(:, 2,14, 7) = (/ &
        & 0.10820e+04_r8,0.82323e+03_r8,0.57803e+03_r8,0.81816e+03_r8,0.10753e+04_r8 /)
      kbo(:, 3,14, 7) = (/ &
        & 0.10761e+04_r8,0.81875e+03_r8,0.57524e+03_r8,0.81827e+03_r8,0.10754e+04_r8 /)
      kbo(:, 4,14, 7) = (/ &
        & 0.10709e+04_r8,0.81486e+03_r8,0.57281e+03_r8,0.81809e+03_r8,0.10752e+04_r8 /)
      kbo(:, 5,14, 7) = (/ &
        & 0.10663e+04_r8,0.81144e+03_r8,0.57087e+03_r8,0.81766e+03_r8,0.10748e+04_r8 /)
      kbo(:, 1,15, 7) = (/ &
        & 0.10714e+04_r8,0.81529e+03_r8,0.57324e+03_r8,0.81765e+03_r8,0.10748e+04_r8 /)
      kbo(:, 2,15, 7) = (/ &
        & 0.10659e+04_r8,0.81110e+03_r8,0.57094e+03_r8,0.81800e+03_r8,0.10753e+04_r8 /)
      kbo(:, 3,15, 7) = (/ &
        & 0.10611e+04_r8,0.80749e+03_r8,0.56926e+03_r8,0.81809e+03_r8,0.10754e+04_r8 /)
      kbo(:, 4,15, 7) = (/ &
        & 0.10569e+04_r8,0.80434e+03_r8,0.56791e+03_r8,0.81790e+03_r8,0.10752e+04_r8 /)
      kbo(:, 5,15, 7) = (/ &
        & 0.10532e+04_r8,0.80157e+03_r8,0.56672e+03_r8,0.81746e+03_r8,0.10748e+04_r8 /)
      kbo(:, 1,16, 7) = (/ &
        & 0.10572e+04_r8,0.80460e+03_r8,0.56822e+03_r8,0.81755e+03_r8,0.10748e+04_r8 /)
      kbo(:, 2,16, 7) = (/ &
        & 0.10527e+04_r8,0.80122e+03_r8,0.56701e+03_r8,0.81788e+03_r8,0.10753e+04_r8 /)
      kbo(:, 3,16, 7) = (/ &
        & 0.10488e+04_r8,0.79831e+03_r8,0.56599e+03_r8,0.81796e+03_r8,0.10754e+04_r8 /)
      kbo(:, 4,16, 7) = (/ &
        & 0.10454e+04_r8,0.79577e+03_r8,0.56505e+03_r8,0.81773e+03_r8,0.10752e+04_r8 /)
      kbo(:, 5,16, 7) = (/ &
        & 0.10425e+04_r8,0.79354e+03_r8,0.56418e+03_r8,0.81728e+03_r8,0.10747e+04_r8 /)
      kbo(:, 1,17, 7) = (/ &
        & 0.10456e+04_r8,0.79593e+03_r8,0.56540e+03_r8,0.81747e+03_r8,0.10749e+04_r8 /)
      kbo(:, 2,17, 7) = (/ &
        & 0.10420e+04_r8,0.79321e+03_r8,0.56464e+03_r8,0.81778e+03_r8,0.10753e+04_r8 /)
      kbo(:, 3,17, 7) = (/ &
        & 0.10389e+04_r8,0.79086e+03_r8,0.56406e+03_r8,0.81783e+03_r8,0.10754e+04_r8 /)
      kbo(:, 4,17, 7) = (/ &
        & 0.10362e+04_r8,0.78881e+03_r8,0.56355e+03_r8,0.81761e+03_r8,0.10751e+04_r8 /)
      kbo(:, 5,17, 7) = (/ &
        & 0.10337e+04_r8,0.78701e+03_r8,0.56298e+03_r8,0.81712e+03_r8,0.10746e+04_r8 /)
      kbo(:, 1,18, 7) = (/ &
        & 0.10363e+04_r8,0.78890e+03_r8,0.56372e+03_r8,0.81741e+03_r8,0.10750e+04_r8 /)
      kbo(:, 2,18, 7) = (/ &
        & 0.10334e+04_r8,0.78671e+03_r8,0.56351e+03_r8,0.81771e+03_r8,0.10753e+04_r8 /)
      kbo(:, 3,18, 7) = (/ &
        & 0.10308e+04_r8,0.78481e+03_r8,0.56335e+03_r8,0.81775e+03_r8,0.10754e+04_r8 /)
      kbo(:, 4,18, 7) = (/ &
        & 0.10286e+04_r8,0.78316e+03_r8,0.56306e+03_r8,0.81749e+03_r8,0.10751e+04_r8 /)
      kbo(:, 5,18, 7) = (/ &
        & 0.10267e+04_r8,0.78170e+03_r8,0.56253e+03_r8,0.81698e+03_r8,0.10746e+04_r8 /)
      kbo(:, 1,19, 7) = (/ &
        & 0.10287e+04_r8,0.78319e+03_r8,0.56306e+03_r8,0.81737e+03_r8,0.10751e+04_r8 /)
      kbo(:, 2,19, 7) = (/ &
        & 0.10263e+04_r8,0.78143e+03_r8,0.56317e+03_r8,0.81766e+03_r8,0.10754e+04_r8 /)
      kbo(:, 3,19, 7) = (/ &
        & 0.10243e+04_r8,0.77990e+03_r8,0.56256e+03_r8,0.81764e+03_r8,0.10753e+04_r8 /)
      kbo(:, 4,19, 7) = (/ &
        & 0.10225e+04_r8,0.77856e+03_r8,0.56270e+03_r8,0.81737e+03_r8,0.10751e+04_r8 /)
      kbo(:, 5,19, 7) = (/ &
        & 0.10209e+04_r8,0.77738e+03_r8,0.56230e+03_r8,0.81685e+03_r8,0.10745e+04_r8 /)
      kbo(:, 1,20, 7) = (/ &
        & 0.10225e+04_r8,0.77853e+03_r8,0.56258e+03_r8,0.81735e+03_r8,0.10751e+04_r8 /)
      kbo(:, 2,20, 7) = (/ &
        & 0.10206e+04_r8,0.77711e+03_r8,0.56304e+03_r8,0.81761e+03_r8,0.10754e+04_r8 /)
      kbo(:, 3,20, 7) = (/ &
        & 0.10189e+04_r8,0.77589e+03_r8,0.56295e+03_r8,0.81757e+03_r8,0.10753e+04_r8 /)
      kbo(:, 4,20, 7) = (/ &
        & 0.10175e+04_r8,0.77480e+03_r8,0.56264e+03_r8,0.81728e+03_r8,0.10750e+04_r8 /)
      kbo(:, 5,20, 7) = (/ &
        & 0.10162e+04_r8,0.77385e+03_r8,0.56211e+03_r8,0.81672e+03_r8,0.10744e+04_r8 /)
      kbo(:, 1,21, 7) = (/ &
        & 0.10174e+04_r8,0.77475e+03_r8,0.56279e+03_r8,0.81734e+03_r8,0.10752e+04_r8 /)
      kbo(:, 2,21, 7) = (/ &
        & 0.10159e+04_r8,0.77361e+03_r8,0.56292e+03_r8,0.81756e+03_r8,0.10754e+04_r8 /)
      kbo(:, 3,21, 7) = (/ &
        & 0.10146e+04_r8,0.77262e+03_r8,0.56281e+03_r8,0.81751e+03_r8,0.10753e+04_r8 /)
      kbo(:, 4,21, 7) = (/ &
        & 0.10134e+04_r8,0.77175e+03_r8,0.56248e+03_r8,0.81718e+03_r8,0.10750e+04_r8 /)
      kbo(:, 5,21, 7) = (/ &
        & 0.10124e+04_r8,0.77098e+03_r8,0.56193e+03_r8,0.81661e+03_r8,0.10743e+04_r8 /)
      kbo(:, 1,22, 7) = (/ &
        & 0.10132e+04_r8,0.77163e+03_r8,0.56273e+03_r8,0.81736e+03_r8,0.10752e+04_r8 /)
      kbo(:, 2,22, 7) = (/ &
        & 0.10120e+04_r8,0.77071e+03_r8,0.56281e+03_r8,0.81753e+03_r8,0.10754e+04_r8 /)
      kbo(:, 3,22, 7) = (/ &
        & 0.10110e+04_r8,0.76992e+03_r8,0.56267e+03_r8,0.81743e+03_r8,0.10753e+04_r8 /)
      kbo(:, 4,22, 7) = (/ &
        & 0.10100e+04_r8,0.76922e+03_r8,0.56230e+03_r8,0.81706e+03_r8,0.10749e+04_r8 /)
      kbo(:, 5,22, 7) = (/ &
        & 0.10092e+04_r8,0.76860e+03_r8,0.56172e+03_r8,0.81643e+03_r8,0.10742e+04_r8 /)
      kbo(:, 1,23, 7) = (/ &
        & 0.10099e+04_r8,0.76909e+03_r8,0.56267e+03_r8,0.81738e+03_r8,0.10753e+04_r8 /)
      kbo(:, 2,23, 7) = (/ &
        & 0.10089e+04_r8,0.76836e+03_r8,0.56273e+03_r8,0.81751e+03_r8,0.10754e+04_r8 /)
      kbo(:, 3,23, 7) = (/ &
        & 0.10080e+04_r8,0.76773e+03_r8,0.56254e+03_r8,0.81734e+03_r8,0.10752e+04_r8 /)
      kbo(:, 4,23, 7) = (/ &
        & 0.10073e+04_r8,0.76717e+03_r8,0.56214e+03_r8,0.81691e+03_r8,0.10748e+04_r8 /)
      kbo(:, 5,23, 7) = (/ &
        & 0.10067e+04_r8,0.76668e+03_r8,0.56152e+03_r8,0.81625e+03_r8,0.10740e+04_r8 /)
      kbo(:, 1,24, 7) = (/ &
        & 0.10071e+04_r8,0.76704e+03_r8,0.56263e+03_r8,0.81739e+03_r8,0.10753e+04_r8 /)
      kbo(:, 2,24, 7) = (/ &
        & 0.10064e+04_r8,0.76647e+03_r8,0.56264e+03_r8,0.81747e+03_r8,0.10754e+04_r8 /)
      kbo(:, 3,24, 7) = (/ &
        & 0.10057e+04_r8,0.76596e+03_r8,0.56242e+03_r8,0.81725e+03_r8,0.10751e+04_r8 /)
      kbo(:, 4,24, 7) = (/ &
        & 0.10051e+04_r8,0.76551e+03_r8,0.56198e+03_r8,0.81678e+03_r8,0.10746e+04_r8 /)
      kbo(:, 5,24, 7) = (/ &
        & 0.10046e+04_r8,0.76512e+03_r8,0.56132e+03_r8,0.81606e+03_r8,0.10738e+04_r8 /)
      kbo(:, 1,25, 7) = (/ &
        & 0.10049e+04_r8,0.76538e+03_r8,0.56260e+03_r8,0.81741e+03_r8,0.10754e+04_r8 /)
      kbo(:, 2,25, 7) = (/ &
        & 0.10043e+04_r8,0.76492e+03_r8,0.56256e+03_r8,0.81742e+03_r8,0.10753e+04_r8 /)
      kbo(:, 3,25, 7) = (/ &
        & 0.10038e+04_r8,0.76453e+03_r8,0.56229e+03_r8,0.81717e+03_r8,0.10750e+04_r8 /)
      kbo(:, 4,25, 7) = (/ &
        & 0.10033e+04_r8,0.76417e+03_r8,0.56181e+03_r8,0.81663e+03_r8,0.10745e+04_r8 /)
      kbo(:, 5,25, 7) = (/ &
        & 0.10029e+04_r8,0.76385e+03_r8,0.56111e+03_r8,0.81585e+03_r8,0.10736e+04_r8 /)
      kbo(:, 1,26, 7) = (/ &
        & 0.10031e+04_r8,0.76404e+03_r8,0.56257e+03_r8,0.81743e+03_r8,0.10754e+04_r8 /)
      kbo(:, 2,26, 7) = (/ &
        & 0.10026e+04_r8,0.76368e+03_r8,0.56248e+03_r8,0.81736e+03_r8,0.10753e+04_r8 /)
      kbo(:, 3,26, 7) = (/ &
        & 0.10022e+04_r8,0.76336e+03_r8,0.56216e+03_r8,0.81707e+03_r8,0.10749e+04_r8 /)
      kbo(:, 4,26, 7) = (/ &
        & 0.10018e+04_r8,0.76308e+03_r8,0.56163e+03_r8,0.81645e+03_r8,0.10743e+04_r8 /)
      kbo(:, 5,26, 7) = (/ &
        & 0.10015e+04_r8,0.76282e+03_r8,0.56088e+03_r8,0.81561e+03_r8,0.10734e+04_r8 /)
      kbo(:, 1,27, 7) = (/ &
        & 0.10017e+04_r8,0.76296e+03_r8,0.56253e+03_r8,0.81743e+03_r8,0.10754e+04_r8 /)
      kbo(:, 2,27, 7) = (/ &
        & 0.10013e+04_r8,0.76268e+03_r8,0.56239e+03_r8,0.81730e+03_r8,0.10752e+04_r8 /)
      kbo(:, 3,27, 7) = (/ &
        & 0.10010e+04_r8,0.76242e+03_r8,0.56202e+03_r8,0.81696e+03_r8,0.10748e+04_r8 /)
      kbo(:, 4,27, 7) = (/ &
        & 0.10007e+04_r8,0.76220e+03_r8,0.56144e+03_r8,0.81630e+03_r8,0.10741e+04_r8 /)
      kbo(:, 5,27, 7) = (/ &
        & 0.10004e+04_r8,0.76200e+03_r8,0.56064e+03_r8,0.81536e+03_r8,0.10731e+04_r8 /)
      kbo(:, 1,28, 7) = (/ &
        & 0.10005e+04_r8,0.76209e+03_r8,0.56249e+03_r8,0.81738e+03_r8,0.10754e+04_r8 /)
      kbo(:, 2,28, 7) = (/ &
        & 0.10002e+04_r8,0.76186e+03_r8,0.56229e+03_r8,0.81724e+03_r8,0.10752e+04_r8 /)
      kbo(:, 3,28, 7) = (/ &
        & 0.99995e+03_r8,0.76166e+03_r8,0.56188e+03_r8,0.81687e+03_r8,0.10747e+04_r8 /)
      kbo(:, 4,28, 7) = (/ &
        & 0.99971e+03_r8,0.76148e+03_r8,0.56124e+03_r8,0.81607e+03_r8,0.10739e+04_r8 /)
      kbo(:, 5,28, 7) = (/ &
        & 0.99950e+03_r8,0.76132e+03_r8,0.56040e+03_r8,0.81510e+03_r8,0.10728e+04_r8 /)
      kbo(:, 1,29, 7) = (/ &
        & 0.99960e+03_r8,0.76139e+03_r8,0.56244e+03_r8,0.81739e+03_r8,0.10753e+04_r8 /)
      kbo(:, 2,29, 7) = (/ &
        & 0.99935e+03_r8,0.76121e+03_r8,0.56219e+03_r8,0.81712e+03_r8,0.10751e+04_r8 /)
      kbo(:, 3,29, 7) = (/ &
        & 0.99914e+03_r8,0.76105e+03_r8,0.56172e+03_r8,0.81663e+03_r8,0.10745e+04_r8 /)
      kbo(:, 4,29, 7) = (/ &
        & 0.99895e+03_r8,0.76091e+03_r8,0.56103e+03_r8,0.81584e+03_r8,0.10737e+04_r8 /)
      kbo(:, 5,29, 7) = (/ &
        & 0.99878e+03_r8,0.76078e+03_r8,0.56014e+03_r8,0.81482e+03_r8,0.10725e+04_r8 /)
      kbo(:, 1,30, 7) = (/ &
        & 0.99885e+03_r8,0.76083e+03_r8,0.56238e+03_r8,0.81733e+03_r8,0.10753e+04_r8 /)
      kbo(:, 2,30, 7) = (/ &
        & 0.99865e+03_r8,0.76069e+03_r8,0.56207e+03_r8,0.81703e+03_r8,0.10750e+04_r8 /)
      kbo(:, 3,30, 7) = (/ &
        & 0.99848e+03_r8,0.76055e+03_r8,0.56155e+03_r8,0.81643e+03_r8,0.10743e+04_r8 /)
      kbo(:, 4,30, 7) = (/ &
        & 0.99833e+03_r8,0.76044e+03_r8,0.56081e+03_r8,0.81561e+03_r8,0.10734e+04_r8 /)
      kbo(:, 5,30, 7) = (/ &
        & 0.99819e+03_r8,0.76034e+03_r8,0.55986e+03_r8,0.81451e+03_r8,0.10721e+04_r8 /)
      kbo(:, 1,31, 7) = (/ &
        & 0.99824e+03_r8,0.76037e+03_r8,0.56231e+03_r8,0.81727e+03_r8,0.10752e+04_r8 /)
      kbo(:, 2,31, 7) = (/ &
        & 0.99808e+03_r8,0.76026e+03_r8,0.56195e+03_r8,0.81690e+03_r8,0.10748e+04_r8 /)
      kbo(:, 3,31, 7) = (/ &
        & 0.99794e+03_r8,0.76015e+03_r8,0.56137e+03_r8,0.81625e+03_r8,0.10741e+04_r8 /)
      kbo(:, 4,31, 7) = (/ &
        & 0.99782e+03_r8,0.76006e+03_r8,0.56058e+03_r8,0.81535e+03_r8,0.10731e+04_r8 /)
      kbo(:, 5,31, 7) = (/ &
        & 0.99772e+03_r8,0.75998e+03_r8,0.55958e+03_r8,0.81419e+03_r8,0.10717e+04_r8 /)
      kbo(:, 1,32, 7) = (/ &
        & 0.99774e+03_r8,0.76000e+03_r8,0.56222e+03_r8,0.81719e+03_r8,0.10752e+04_r8 /)
      kbo(:, 2,32, 7) = (/ &
        & 0.99763e+03_r8,0.75991e+03_r8,0.56181e+03_r8,0.81675e+03_r8,0.10747e+04_r8 /)
      kbo(:, 3,32, 7) = (/ &
        & 0.99752e+03_r8,0.75984e+03_r8,0.56117e+03_r8,0.81604e+03_r8,0.10739e+04_r8 /)
      kbo(:, 4,32, 7) = (/ &
        & 0.99742e+03_r8,0.75976e+03_r8,0.56033e+03_r8,0.81507e+03_r8,0.10728e+04_r8 /)
      kbo(:, 5,32, 7) = (/ &
        & 0.99733e+03_r8,0.75970e+03_r8,0.55927e+03_r8,0.81384e+03_r8,0.10713e+04_r8 /)
      kbo(:, 1,33, 7) = (/ &
        & 0.99735e+03_r8,0.75971e+03_r8,0.56212e+03_r8,0.81709e+03_r8,0.10751e+04_r8 /)
      kbo(:, 2,33, 7) = (/ &
        & 0.99725e+03_r8,0.75964e+03_r8,0.56165e+03_r8,0.81658e+03_r8,0.10745e+04_r8 /)
      kbo(:, 3,33, 7) = (/ &
        & 0.99717e+03_r8,0.75957e+03_r8,0.56096e+03_r8,0.81581e+03_r8,0.10736e+04_r8 /)
      kbo(:, 4,33, 7) = (/ &
        & 0.99709e+03_r8,0.75952e+03_r8,0.56006e+03_r8,0.81477e+03_r8,0.10724e+04_r8 /)
      kbo(:, 5,33, 7) = (/ &
        & 0.99703e+03_r8,0.75946e+03_r8,0.55896e+03_r8,0.81347e+03_r8,0.10709e+04_r8 /)
      kbo(:, 1,34, 7) = (/ &
        & 0.99704e+03_r8,0.75947e+03_r8,0.56203e+03_r8,0.81702e+03_r8,0.10750e+04_r8 /)
      kbo(:, 2,34, 7) = (/ &
        & 0.99696e+03_r8,0.75942e+03_r8,0.56151e+03_r8,0.81642e+03_r8,0.10743e+04_r8 /)
      kbo(:, 3,34, 7) = (/ &
        & 0.99689e+03_r8,0.75937e+03_r8,0.56077e+03_r8,0.81558e+03_r8,0.10734e+04_r8 /)
      kbo(:, 4,34, 7) = (/ &
        & 0.99683e+03_r8,0.75932e+03_r8,0.55982e+03_r8,0.81449e+03_r8,0.10721e+04_r8 /)
      kbo(:, 5,34, 7) = (/ &
        & 0.99678e+03_r8,0.75928e+03_r8,0.55868e+03_r8,0.81314e+03_r8,0.10704e+04_r8 /)
      kbo(:, 1,35, 7) = (/ &
        & 0.99679e+03_r8,0.75929e+03_r8,0.56197e+03_r8,0.81693e+03_r8,0.10749e+04_r8 /)
      kbo(:, 2,35, 7) = (/ &
        & 0.99673e+03_r8,0.75925e+03_r8,0.56142e+03_r8,0.81633e+03_r8,0.10742e+04_r8 /)
      kbo(:, 3,35, 7) = (/ &
        & 0.99667e+03_r8,0.75920e+03_r8,0.56065e+03_r8,0.81545e+03_r8,0.10733e+04_r8 /)
      kbo(:, 4,35, 7) = (/ &
        & 0.99663e+03_r8,0.75916e+03_r8,0.55968e+03_r8,0.81434e+03_r8,0.10719e+04_r8 /)
      kbo(:, 5,35, 7) = (/ &
        & 0.99658e+03_r8,0.75913e+03_r8,0.55851e+03_r8,0.81294e+03_r8,0.10702e+04_r8 /)
      kbo(:, 1,36, 7) = (/ &
        & 0.99660e+03_r8,0.75914e+03_r8,0.56195e+03_r8,0.81692e+03_r8,0.10749e+04_r8 /)
      kbo(:, 2,36, 7) = (/ &
        & 0.99655e+03_r8,0.75911e+03_r8,0.56140e+03_r8,0.81631e+03_r8,0.10742e+04_r8 /)
      kbo(:, 3,36, 7) = (/ &
        & 0.99650e+03_r8,0.75907e+03_r8,0.56063e+03_r8,0.81543e+03_r8,0.10732e+04_r8 /)
      kbo(:, 4,36, 7) = (/ &
        & 0.99646e+03_r8,0.75904e+03_r8,0.55965e+03_r8,0.81430e+03_r8,0.10719e+04_r8 /)
      kbo(:, 5,36, 7) = (/ &
        & 0.99642e+03_r8,0.75901e+03_r8,0.55848e+03_r8,0.81290e+03_r8,0.10702e+04_r8 /)
      kbo(:, 1,37, 7) = (/ &
        & 0.99645e+03_r8,0.75903e+03_r8,0.56200e+03_r8,0.81697e+03_r8,0.10749e+04_r8 /)
      kbo(:, 2,37, 7) = (/ &
        & 0.99640e+03_r8,0.75900e+03_r8,0.56148e+03_r8,0.81640e+03_r8,0.10743e+04_r8 /)
      kbo(:, 3,37, 7) = (/ &
        & 0.99636e+03_r8,0.75897e+03_r8,0.56074e+03_r8,0.81556e+03_r8,0.10734e+04_r8 /)
      kbo(:, 4,37, 7) = (/ &
        & 0.99633e+03_r8,0.75894e+03_r8,0.55979e+03_r8,0.81446e+03_r8,0.10721e+04_r8 /)
      kbo(:, 5,37, 7) = (/ &
        & 0.99630e+03_r8,0.75892e+03_r8,0.55864e+03_r8,0.81313e+03_r8,0.10704e+04_r8 /)
      kbo(:, 1,38, 7) = (/ &
        & 0.99632e+03_r8,0.75894e+03_r8,0.56206e+03_r8,0.81703e+03_r8,0.10750e+04_r8 /)
      kbo(:, 2,38, 7) = (/ &
        & 0.99628e+03_r8,0.75891e+03_r8,0.56157e+03_r8,0.81650e+03_r8,0.10744e+04_r8 /)
      kbo(:, 3,38, 7) = (/ &
        & 0.99625e+03_r8,0.75889e+03_r8,0.56085e+03_r8,0.81569e+03_r8,0.10735e+04_r8 /)
      kbo(:, 4,38, 7) = (/ &
        & 0.99623e+03_r8,0.75887e+03_r8,0.55993e+03_r8,0.81464e+03_r8,0.10723e+04_r8 /)
      kbo(:, 5,38, 7) = (/ &
        & 0.99620e+03_r8,0.75885e+03_r8,0.55881e+03_r8,0.81331e+03_r8,0.10707e+04_r8 /)
      kbo(:, 1,39, 7) = (/ &
        & 0.99622e+03_r8,0.75886e+03_r8,0.56210e+03_r8,0.81708e+03_r8,0.10751e+04_r8 /)
      kbo(:, 2,39, 7) = (/ &
        & 0.99619e+03_r8,0.75884e+03_r8,0.56164e+03_r8,0.81666e+03_r8,0.10745e+04_r8 /)
      kbo(:, 3,39, 7) = (/ &
        & 0.99617e+03_r8,0.75882e+03_r8,0.56096e+03_r8,0.81582e+03_r8,0.10737e+04_r8 /)
      kbo(:, 4,39, 7) = (/ &
        & 0.99614e+03_r8,0.75880e+03_r8,0.56007e+03_r8,0.81479e+03_r8,0.10725e+04_r8 /)
      kbo(:, 5,39, 7) = (/ &
        & 0.99612e+03_r8,0.75878e+03_r8,0.55897e+03_r8,0.81351e+03_r8,0.10709e+04_r8 /)
      kbo(:, 1,40, 7) = (/ &
        & 0.99613e+03_r8,0.75880e+03_r8,0.56218e+03_r8,0.81716e+03_r8,0.10752e+04_r8 /)
      kbo(:, 2,40, 7) = (/ &
        & 0.99611e+03_r8,0.75878e+03_r8,0.56177e+03_r8,0.81672e+03_r8,0.10747e+04_r8 /)
      kbo(:, 3,40, 7) = (/ &
        & 0.99609e+03_r8,0.75876e+03_r8,0.56114e+03_r8,0.81603e+03_r8,0.10739e+04_r8 /)
      kbo(:, 4,40, 7) = (/ &
        & 0.99607e+03_r8,0.75875e+03_r8,0.56030e+03_r8,0.81506e+03_r8,0.10728e+04_r8 /)
      kbo(:, 5,40, 7) = (/ &
        & 0.99605e+03_r8,0.75874e+03_r8,0.55925e+03_r8,0.81383e+03_r8,0.10713e+04_r8 /)
      kbo(:, 1,41, 7) = (/ &
        & 0.99606e+03_r8,0.75874e+03_r8,0.56225e+03_r8,0.81724e+03_r8,0.10752e+04_r8 /)
      kbo(:, 2,41, 7) = (/ &
        & 0.99604e+03_r8,0.75873e+03_r8,0.56189e+03_r8,0.81688e+03_r8,0.10748e+04_r8 /)
      kbo(:, 3,41, 7) = (/ &
        & 0.99602e+03_r8,0.75871e+03_r8,0.56132e+03_r8,0.81623e+03_r8,0.10741e+04_r8 /)
      kbo(:, 4,41, 7) = (/ &
        & 0.99601e+03_r8,0.75870e+03_r8,0.56053e+03_r8,0.81532e+03_r8,0.10731e+04_r8 /)
      kbo(:, 5,41, 7) = (/ &
        & 0.99600e+03_r8,0.75869e+03_r8,0.55954e+03_r8,0.81416e+03_r8,0.10717e+04_r8 /)
      kbo(:, 1,42, 7) = (/ &
        & 0.99601e+03_r8,0.75870e+03_r8,0.56231e+03_r8,0.81730e+03_r8,0.10753e+04_r8 /)
      kbo(:, 2,42, 7) = (/ &
        & 0.99599e+03_r8,0.75869e+03_r8,0.56200e+03_r8,0.81698e+03_r8,0.10750e+04_r8 /)
      kbo(:, 3,42, 7) = (/ &
        & 0.99597e+03_r8,0.75868e+03_r8,0.56149e+03_r8,0.81641e+03_r8,0.10743e+04_r8 /)
      kbo(:, 4,42, 7) = (/ &
        & 0.99596e+03_r8,0.75867e+03_r8,0.56075e+03_r8,0.81559e+03_r8,0.10734e+04_r8 /)
      kbo(:, 5,42, 7) = (/ &
        & 0.99595e+03_r8,0.75866e+03_r8,0.55981e+03_r8,0.81449e+03_r8,0.10721e+04_r8 /)
      kbo(:, 1,43, 7) = (/ &
        & 0.99596e+03_r8,0.75867e+03_r8,0.56235e+03_r8,0.81734e+03_r8,0.10754e+04_r8 /)
      kbo(:, 2,43, 7) = (/ &
        & 0.99595e+03_r8,0.75866e+03_r8,0.56212e+03_r8,0.81712e+03_r8,0.10751e+04_r8 /)
      kbo(:, 3,43, 7) = (/ &
        & 0.99594e+03_r8,0.75865e+03_r8,0.56167e+03_r8,0.81662e+03_r8,0.10746e+04_r8 /)
      kbo(:, 4,43, 7) = (/ &
        & 0.99592e+03_r8,0.75864e+03_r8,0.56100e+03_r8,0.81588e+03_r8,0.10737e+04_r8 /)
      kbo(:, 5,43, 7) = (/ &
        & 0.99591e+03_r8,0.75863e+03_r8,0.56012e+03_r8,0.81487e+03_r8,0.10726e+04_r8 /)
      kbo(:, 1,44, 7) = (/ &
        & 0.99592e+03_r8,0.75864e+03_r8,0.56237e+03_r8,0.81736e+03_r8,0.10754e+04_r8 /)
      kbo(:, 2,44, 7) = (/ &
        & 0.99591e+03_r8,0.75863e+03_r8,0.56222e+03_r8,0.81722e+03_r8,0.10752e+04_r8 /)
      kbo(:, 3,44, 7) = (/ &
        & 0.99591e+03_r8,0.75862e+03_r8,0.56184e+03_r8,0.81680e+03_r8,0.10748e+04_r8 /)
      kbo(:, 4,44, 7) = (/ &
        & 0.99589e+03_r8,0.75861e+03_r8,0.56125e+03_r8,0.81614e+03_r8,0.10741e+04_r8 /)
      kbo(:, 5,44, 7) = (/ &
        & 0.99588e+03_r8,0.75861e+03_r8,0.56044e+03_r8,0.81523e+03_r8,0.10730e+04_r8 /)
      kbo(:, 1,45, 7) = (/ &
        & 0.99589e+03_r8,0.75861e+03_r8,0.56237e+03_r8,0.81733e+03_r8,0.10754e+04_r8 /)
      kbo(:, 2,45, 7) = (/ &
        & 0.99588e+03_r8,0.75861e+03_r8,0.56230e+03_r8,0.81729e+03_r8,0.10753e+04_r8 /)
      kbo(:, 3,45, 7) = (/ &
        & 0.99587e+03_r8,0.75860e+03_r8,0.56199e+03_r8,0.81699e+03_r8,0.10750e+04_r8 /)
      kbo(:, 4,45, 7) = (/ &
        & 0.99586e+03_r8,0.75859e+03_r8,0.56147e+03_r8,0.81641e+03_r8,0.10743e+04_r8 /)
      kbo(:, 5,45, 7) = (/ &
        & 0.99585e+03_r8,0.75859e+03_r8,0.56074e+03_r8,0.81557e+03_r8,0.10734e+04_r8 /)
      kbo(:, 1,46, 7) = (/ &
        & 0.99586e+03_r8,0.75859e+03_r8,0.56233e+03_r8,0.81728e+03_r8,0.10753e+04_r8 /)
      kbo(:, 2,46, 7) = (/ &
        & 0.99585e+03_r8,0.75859e+03_r8,0.56235e+03_r8,0.81734e+03_r8,0.10754e+04_r8 /)
      kbo(:, 3,46, 7) = (/ &
        & 0.99585e+03_r8,0.75858e+03_r8,0.56213e+03_r8,0.81712e+03_r8,0.10751e+04_r8 /)
      kbo(:, 4,46, 7) = (/ &
        & 0.99584e+03_r8,0.75858e+03_r8,0.56169e+03_r8,0.81663e+03_r8,0.10746e+04_r8 /)
      kbo(:, 5,46, 7) = (/ &
        & 0.99583e+03_r8,0.75858e+03_r8,0.56103e+03_r8,0.81590e+03_r8,0.10738e+04_r8 /)
      kbo(:, 1,47, 7) = (/ &
        & 0.99585e+03_r8,0.75858e+03_r8,0.56226e+03_r8,0.81718e+03_r8,0.10753e+04_r8 /)
      kbo(:, 2,47, 7) = (/ &
        & 0.99583e+03_r8,0.75857e+03_r8,0.56237e+03_r8,0.81736e+03_r8,0.10754e+04_r8 /)
      kbo(:, 3,47, 7) = (/ &
        & 0.99583e+03_r8,0.75857e+03_r8,0.56224e+03_r8,0.81723e+03_r8,0.10752e+04_r8 /)
      kbo(:, 4,47, 7) = (/ &
        & 0.99582e+03_r8,0.75856e+03_r8,0.56189e+03_r8,0.81686e+03_r8,0.10748e+04_r8 /)
      kbo(:, 5,47, 7) = (/ &
        & 0.99581e+03_r8,0.75856e+03_r8,0.56132e+03_r8,0.81626e+03_r8,0.10741e+04_r8 /)
      kbo(:, 1,48, 7) = (/ &
        & 0.99582e+03_r8,0.75856e+03_r8,0.56215e+03_r8,0.81703e+03_r8,0.10751e+04_r8 /)
      kbo(:, 2,48, 7) = (/ &
        & 0.99582e+03_r8,0.75856e+03_r8,0.56235e+03_r8,0.81732e+03_r8,0.10754e+04_r8 /)
      kbo(:, 3,48, 7) = (/ &
        & 0.99581e+03_r8,0.75855e+03_r8,0.56232e+03_r8,0.81733e+03_r8,0.10753e+04_r8 /)
      kbo(:, 4,48, 7) = (/ &
        & 0.99580e+03_r8,0.75855e+03_r8,0.56206e+03_r8,0.81704e+03_r8,0.10750e+04_r8 /)
      kbo(:, 5,48, 7) = (/ &
        & 0.99580e+03_r8,0.75855e+03_r8,0.56157e+03_r8,0.81651e+03_r8,0.10744e+04_r8 /)
      kbo(:, 1,49, 7) = (/ &
        & 0.99581e+03_r8,0.75855e+03_r8,0.56199e+03_r8,0.81684e+03_r8,0.10748e+04_r8 /)
      kbo(:, 2,49, 7) = (/ &
        & 0.99580e+03_r8,0.75855e+03_r8,0.56230e+03_r8,0.81724e+03_r8,0.10753e+04_r8 /)
      kbo(:, 3,49, 7) = (/ &
        & 0.99580e+03_r8,0.75854e+03_r8,0.56236e+03_r8,0.81736e+03_r8,0.10753e+04_r8 /)
      kbo(:, 4,49, 7) = (/ &
        & 0.99579e+03_r8,0.75854e+03_r8,0.56219e+03_r8,0.81718e+03_r8,0.10752e+04_r8 /)
      kbo(:, 5,49, 7) = (/ &
        & 0.99579e+03_r8,0.75854e+03_r8,0.56179e+03_r8,0.81678e+03_r8,0.10747e+04_r8 /)
      kbo(:, 1,50, 7) = (/ &
        & 0.99579e+03_r8,0.75854e+03_r8,0.56180e+03_r8,0.81662e+03_r8,0.10745e+04_r8 /)
      kbo(:, 2,50, 7) = (/ &
        & 0.99579e+03_r8,0.75854e+03_r8,0.56221e+03_r8,0.81713e+03_r8,0.10752e+04_r8 /)
      kbo(:, 3,50, 7) = (/ &
        & 0.99579e+03_r8,0.75854e+03_r8,0.56237e+03_r8,0.81735e+03_r8,0.10754e+04_r8 /)
      kbo(:, 4,50, 7) = (/ &
        & 0.99579e+03_r8,0.75854e+03_r8,0.56228e+03_r8,0.81728e+03_r8,0.10753e+04_r8 /)
      kbo(:, 5,50, 7) = (/ &
        & 0.99578e+03_r8,0.75853e+03_r8,0.56197e+03_r8,0.81695e+03_r8,0.10749e+04_r8 /)
      kbo(:, 1,51, 7) = (/ &
        & 0.99578e+03_r8,0.75853e+03_r8,0.56158e+03_r8,0.81637e+03_r8,0.10741e+04_r8 /)
      kbo(:, 2,51, 7) = (/ &
        & 0.99578e+03_r8,0.75853e+03_r8,0.56209e+03_r8,0.81697e+03_r8,0.10750e+04_r8 /)
      kbo(:, 3,51, 7) = (/ &
        & 0.99578e+03_r8,0.75853e+03_r8,0.56234e+03_r8,0.81729e+03_r8,0.10753e+04_r8 /)
      kbo(:, 4,51, 7) = (/ &
        & 0.99578e+03_r8,0.75853e+03_r8,0.56234e+03_r8,0.81734e+03_r8,0.10754e+04_r8 /)
      kbo(:, 5,51, 7) = (/ &
        & 0.99577e+03_r8,0.75852e+03_r8,0.56211e+03_r8,0.81712e+03_r8,0.10751e+04_r8 /)
      kbo(:, 1,52, 7) = (/ &
        & 0.99577e+03_r8,0.75853e+03_r8,0.56131e+03_r8,0.81608e+03_r8,0.10737e+04_r8 /)
      kbo(:, 2,52, 7) = (/ &
        & 0.99577e+03_r8,0.75852e+03_r8,0.56194e+03_r8,0.81678e+03_r8,0.10748e+04_r8 /)
      kbo(:, 3,52, 7) = (/ &
        & 0.99577e+03_r8,0.75852e+03_r8,0.56228e+03_r8,0.81721e+03_r8,0.10753e+04_r8 /)
      kbo(:, 4,52, 7) = (/ &
        & 0.99577e+03_r8,0.75852e+03_r8,0.56237e+03_r8,0.81738e+03_r8,0.10754e+04_r8 /)
      kbo(:, 5,52, 7) = (/ &
        & 0.99576e+03_r8,0.75852e+03_r8,0.56222e+03_r8,0.81722e+03_r8,0.10752e+04_r8 /)
      kbo(:, 1,53, 7) = (/ &
        & 0.99577e+03_r8,0.75852e+03_r8,0.56102e+03_r8,0.81574e+03_r8,0.10731e+04_r8 /)
      kbo(:, 2,53, 7) = (/ &
        & 0.99576e+03_r8,0.75852e+03_r8,0.56174e+03_r8,0.81656e+03_r8,0.10744e+04_r8 /)
      kbo(:, 3,53, 7) = (/ &
        & 0.99576e+03_r8,0.75852e+03_r8,0.56218e+03_r8,0.81709e+03_r8,0.10752e+04_r8 /)
      kbo(:, 4,53, 7) = (/ &
        & 0.99576e+03_r8,0.75851e+03_r8,0.56236e+03_r8,0.81734e+03_r8,0.10754e+04_r8 /)
      kbo(:, 5,53, 7) = (/ &
        & 0.99576e+03_r8,0.75852e+03_r8,0.56230e+03_r8,0.81736e+03_r8,0.10753e+04_r8 /)
      kbo(:, 1,54, 7) = (/ &
        & 0.99576e+03_r8,0.75852e+03_r8,0.56072e+03_r8,0.81536e+03_r8,0.10726e+04_r8 /)
      kbo(:, 2,54, 7) = (/ &
        & 0.99576e+03_r8,0.75851e+03_r8,0.56153e+03_r8,0.81633e+03_r8,0.10740e+04_r8 /)
      kbo(:, 3,54, 7) = (/ &
        & 0.99575e+03_r8,0.75851e+03_r8,0.56207e+03_r8,0.81694e+03_r8,0.10750e+04_r8 /)
      kbo(:, 4,54, 7) = (/ &
        & 0.99575e+03_r8,0.75851e+03_r8,0.56233e+03_r8,0.81728e+03_r8,0.10753e+04_r8 /)
      kbo(:, 5,54, 7) = (/ &
        & 0.99576e+03_r8,0.75851e+03_r8,0.56235e+03_r8,0.81734e+03_r8,0.10754e+04_r8 /)
      kbo(:, 1,55, 7) = (/ &
        & 0.99575e+03_r8,0.75851e+03_r8,0.56039e+03_r8,0.81495e+03_r8,0.10720e+04_r8 /)
      kbo(:, 2,55, 7) = (/ &
        & 0.99575e+03_r8,0.75851e+03_r8,0.56128e+03_r8,0.81606e+03_r8,0.10736e+04_r8 /)
      kbo(:, 3,55, 7) = (/ &
        & 0.99575e+03_r8,0.75851e+03_r8,0.56193e+03_r8,0.81677e+03_r8,0.10747e+04_r8 /)
      kbo(:, 4,55, 7) = (/ &
        & 0.99575e+03_r8,0.75851e+03_r8,0.56227e+03_r8,0.81720e+03_r8,0.10753e+04_r8 /)
      kbo(:, 5,55, 7) = (/ &
        & 0.99575e+03_r8,0.75851e+03_r8,0.56237e+03_r8,0.81736e+03_r8,0.10754e+04_r8 /)
      kbo(:, 1,56, 7) = (/ &
        & 0.99575e+03_r8,0.75851e+03_r8,0.56002e+03_r8,0.81448e+03_r8,0.10713e+04_r8 /)
      kbo(:, 2,56, 7) = (/ &
        & 0.99575e+03_r8,0.75851e+03_r8,0.56104e+03_r8,0.81576e+03_r8,0.10732e+04_r8 /)
      kbo(:, 3,56, 7) = (/ &
        & 0.99575e+03_r8,0.75851e+03_r8,0.56175e+03_r8,0.81659e+03_r8,0.10744e+04_r8 /)
      kbo(:, 4,56, 7) = (/ &
        & 0.99574e+03_r8,0.75850e+03_r8,0.56219e+03_r8,0.81709e+03_r8,0.10752e+04_r8 /)
      kbo(:, 5,56, 7) = (/ &
        & 0.99574e+03_r8,0.75850e+03_r8,0.56236e+03_r8,0.81734e+03_r8,0.10754e+04_r8 /)
      kbo(:, 1,57, 7) = (/ &
        & 0.99575e+03_r8,0.75851e+03_r8,0.55963e+03_r8,0.81395e+03_r8,0.10705e+04_r8 /)
      kbo(:, 2,57, 7) = (/ &
        & 0.99574e+03_r8,0.75850e+03_r8,0.56076e+03_r8,0.81540e+03_r8,0.10727e+04_r8 /)
      kbo(:, 3,57, 7) = (/ &
        & 0.99574e+03_r8,0.75850e+03_r8,0.56157e+03_r8,0.81635e+03_r8,0.10741e+04_r8 /)
      kbo(:, 4,57, 7) = (/ &
        & 0.99574e+03_r8,0.75850e+03_r8,0.56208e+03_r8,0.81696e+03_r8,0.10750e+04_r8 /)
      kbo(:, 5,57, 7) = (/ &
        & 0.99574e+03_r8,0.75850e+03_r8,0.56234e+03_r8,0.81729e+03_r8,0.10754e+04_r8 /)
      kbo(:, 1,58, 7) = (/ &
        & 0.99575e+03_r8,0.75850e+03_r8,0.55922e+03_r8,0.81340e+03_r8,0.10697e+04_r8 /)
      kbo(:, 2,58, 7) = (/ &
        & 0.99574e+03_r8,0.75850e+03_r8,0.56044e+03_r8,0.81503e+03_r8,0.10721e+04_r8 /)
      kbo(:, 3,58, 7) = (/ &
        & 0.99574e+03_r8,0.75851e+03_r8,0.56134e+03_r8,0.81611e+03_r8,0.10737e+04_r8 /)
      kbo(:, 4,58, 7) = (/ &
        & 0.99574e+03_r8,0.75851e+03_r8,0.56195e+03_r8,0.81681e+03_r8,0.10748e+04_r8 /)
      kbo(:, 5,58, 7) = (/ &
        & 0.99574e+03_r8,0.75850e+03_r8,0.56228e+03_r8,0.81722e+03_r8,0.10753e+04_r8 /)
      kbo(:, 1,59, 7) = (/ &
        & 0.99575e+03_r8,0.75850e+03_r8,0.55905e+03_r8,0.81317e+03_r8,0.10694e+04_r8 /)
      kbo(:, 2,59, 7) = (/ &
        & 0.99574e+03_r8,0.75850e+03_r8,0.56032e+03_r8,0.81485e+03_r8,0.10718e+04_r8 /)
      kbo(:, 3,59, 7) = (/ &
        & 0.99574e+03_r8,0.75850e+03_r8,0.56125e+03_r8,0.81601e+03_r8,0.10735e+04_r8 /)
      kbo(:, 4,59, 7) = (/ &
        & 0.99574e+03_r8,0.75850e+03_r8,0.56189e+03_r8,0.81673e+03_r8,0.10747e+04_r8 /)
      kbo(:, 5,59, 7) = (/ &
        & 0.99573e+03_r8,0.75850e+03_r8,0.56225e+03_r8,0.81718e+03_r8,0.10753e+04_r8 /)
      kbo(:, 1,13, 8) = (/ &
        & 0.11451e+04_r8,0.86748e+03_r8,0.59259e+03_r8,0.85187e+03_r8,0.11225e+04_r8 /)
      kbo(:, 2,13, 8) = (/ &
        & 0.11363e+04_r8,0.86085e+03_r8,0.58896e+03_r8,0.85188e+03_r8,0.11226e+04_r8 /)
      kbo(:, 3,13, 8) = (/ &
        & 0.11286e+04_r8,0.85515e+03_r8,0.58586e+03_r8,0.85170e+03_r8,0.11227e+04_r8 /)
      kbo(:, 4,13, 8) = (/ &
        & 0.11220e+04_r8,0.85016e+03_r8,0.58378e+03_r8,0.85132e+03_r8,0.11224e+04_r8 /)
      kbo(:, 5,13, 8) = (/ &
        & 0.11162e+04_r8,0.84582e+03_r8,0.58229e+03_r8,0.85074e+03_r8,0.11218e+04_r8 /)
      kbo(:, 1,14, 8) = (/ &
        & 0.11230e+04_r8,0.85087e+03_r8,0.58392e+03_r8,0.85168e+03_r8,0.11225e+04_r8 /)
      kbo(:, 2,14, 8) = (/ &
        & 0.11158e+04_r8,0.84552e+03_r8,0.58280e+03_r8,0.85169e+03_r8,0.11227e+04_r8 /)
      kbo(:, 3,14, 8) = (/ &
        & 0.11097e+04_r8,0.84090e+03_r8,0.58233e+03_r8,0.85151e+03_r8,0.11227e+04_r8 /)
      kbo(:, 4,14, 8) = (/ &
        & 0.11043e+04_r8,0.83689e+03_r8,0.58194e+03_r8,0.85113e+03_r8,0.11223e+04_r8 /)
      kbo(:, 5,14, 8) = (/ &
        & 0.10996e+04_r8,0.83336e+03_r8,0.58140e+03_r8,0.85052e+03_r8,0.11217e+04_r8 /)
      kbo(:, 1,15, 8) = (/ &
        & 0.11049e+04_r8,0.83731e+03_r8,0.58207e+03_r8,0.85153e+03_r8,0.11225e+04_r8 /)
      kbo(:, 2,15, 8) = (/ &
        & 0.10991e+04_r8,0.83301e+03_r8,0.58217e+03_r8,0.85153e+03_r8,0.11227e+04_r8 /)
      kbo(:, 3,15, 8) = (/ &
        & 0.10942e+04_r8,0.82928e+03_r8,0.58200e+03_r8,0.85134e+03_r8,0.11226e+04_r8 /)
      kbo(:, 4,15, 8) = (/ &
        & 0.10899e+04_r8,0.82605e+03_r8,0.58161e+03_r8,0.85094e+03_r8,0.11223e+04_r8 /)
      kbo(:, 5,15, 8) = (/ &
        & 0.10860e+04_r8,0.82320e+03_r8,0.58108e+03_r8,0.85034e+03_r8,0.11216e+04_r8 /)
      kbo(:, 1,16, 8) = (/ &
        & 0.10902e+04_r8,0.82630e+03_r8,0.58181e+03_r8,0.85141e+03_r8,0.11225e+04_r8 /)
      kbo(:, 2,16, 8) = (/ &
        & 0.10856e+04_r8,0.82283e+03_r8,0.58190e+03_r8,0.85139e+03_r8,0.11227e+04_r8 /)
      kbo(:, 3,16, 8) = (/ &
        & 0.10816e+04_r8,0.81983e+03_r8,0.58172e+03_r8,0.85119e+03_r8,0.11226e+04_r8 /)
      kbo(:, 4,16, 8) = (/ &
        & 0.10781e+04_r8,0.81721e+03_r8,0.58133e+03_r8,0.85078e+03_r8,0.11222e+04_r8 /)
      kbo(:, 5,16, 8) = (/ &
        & 0.10750e+04_r8,0.81491e+03_r8,0.58080e+03_r8,0.85015e+03_r8,0.11215e+04_r8 /)
      kbo(:, 1,17, 8) = (/ &
        & 0.10783e+04_r8,0.81738e+03_r8,0.58160e+03_r8,0.85131e+03_r8,0.11225e+04_r8 /)
      kbo(:, 2,17, 8) = (/ &
        & 0.10746e+04_r8,0.81457e+03_r8,0.58168e+03_r8,0.85129e+03_r8,0.11227e+04_r8 /)
      kbo(:, 3,17, 8) = (/ &
        & 0.10713e+04_r8,0.81215e+03_r8,0.58149e+03_r8,0.85108e+03_r8,0.11226e+04_r8 /)
      kbo(:, 4,17, 8) = (/ &
        & 0.10685e+04_r8,0.81004e+03_r8,0.58109e+03_r8,0.85064e+03_r8,0.11222e+04_r8 /)
      kbo(:, 5,17, 8) = (/ &
        & 0.10660e+04_r8,0.80818e+03_r8,0.58056e+03_r8,0.85000e+03_r8,0.11214e+04_r8 /)
      kbo(:, 1,18, 8) = (/ &
        & 0.10686e+04_r8,0.81013e+03_r8,0.58144e+03_r8,0.85124e+03_r8,0.11225e+04_r8 /)
      kbo(:, 2,18, 8) = (/ &
        & 0.10656e+04_r8,0.80786e+03_r8,0.58150e+03_r8,0.85119e+03_r8,0.11227e+04_r8 /)
      kbo(:, 3,18, 8) = (/ &
        & 0.10630e+04_r8,0.80591e+03_r8,0.58129e+03_r8,0.85095e+03_r8,0.11226e+04_r8 /)
      kbo(:, 4,18, 8) = (/ &
        & 0.10607e+04_r8,0.80419e+03_r8,0.58089e+03_r8,0.85052e+03_r8,0.11221e+04_r8 /)
      kbo(:, 5,18, 8) = (/ &
        & 0.10587e+04_r8,0.80269e+03_r8,0.58036e+03_r8,0.84984e+03_r8,0.11213e+04_r8 /)
      kbo(:, 1,19, 8) = (/ &
        & 0.10608e+04_r8,0.80424e+03_r8,0.58130e+03_r8,0.85117e+03_r8,0.11226e+04_r8 /)
      kbo(:, 2,19, 8) = (/ &
        & 0.10584e+04_r8,0.80242e+03_r8,0.58135e+03_r8,0.85109e+03_r8,0.11227e+04_r8 /)
      kbo(:, 3,19, 8) = (/ &
        & 0.10562e+04_r8,0.80084e+03_r8,0.58113e+03_r8,0.85087e+03_r8,0.11225e+04_r8 /)
      kbo(:, 4,19, 8) = (/ &
        & 0.10544e+04_r8,0.79946e+03_r8,0.58072e+03_r8,0.85040e+03_r8,0.11220e+04_r8 /)
      kbo(:, 5,19, 8) = (/ &
        & 0.10528e+04_r8,0.79825e+03_r8,0.58019e+03_r8,0.84971e+03_r8,0.11212e+04_r8 /)
      kbo(:, 1,20, 8) = (/ &
        & 0.10544e+04_r8,0.79943e+03_r8,0.58120e+03_r8,0.85111e+03_r8,0.11226e+04_r8 /)
      kbo(:, 2,20, 8) = (/ &
        & 0.10524e+04_r8,0.79797e+03_r8,0.58122e+03_r8,0.85103e+03_r8,0.11227e+04_r8 /)
      kbo(:, 3,20, 8) = (/ &
        & 0.10507e+04_r8,0.79669e+03_r8,0.58098e+03_r8,0.85078e+03_r8,0.11225e+04_r8 /)
      kbo(:, 4,20, 8) = (/ &
        & 0.10492e+04_r8,0.79558e+03_r8,0.58056e+03_r8,0.85028e+03_r8,0.11220e+04_r8 /)
      kbo(:, 5,20, 8) = (/ &
        & 0.10479e+04_r8,0.79460e+03_r8,0.58002e+03_r8,0.84958e+03_r8,0.11211e+04_r8 /)
      kbo(:, 1,21, 8) = (/ &
        & 0.10492e+04_r8,0.79553e+03_r8,0.58112e+03_r8,0.85107e+03_r8,0.11227e+04_r8 /)
      kbo(:, 2,21, 8) = (/ &
        & 0.10476e+04_r8,0.79436e+03_r8,0.58112e+03_r8,0.85096e+03_r8,0.11227e+04_r8 /)
      kbo(:, 3,21, 8) = (/ &
        & 0.10462e+04_r8,0.79334e+03_r8,0.58085e+03_r8,0.85069e+03_r8,0.11224e+04_r8 /)
      kbo(:, 4,21, 8) = (/ &
        & 0.10450e+04_r8,0.79243e+03_r8,0.58042e+03_r8,0.85021e+03_r8,0.11219e+04_r8 /)
      kbo(:, 5,21, 8) = (/ &
        & 0.10440e+04_r8,0.79165e+03_r8,0.57987e+03_r8,0.84945e+03_r8,0.11210e+04_r8 /)
      kbo(:, 1,22, 8) = (/ &
        & 0.10449e+04_r8,0.79230e+03_r8,0.58106e+03_r8,0.85103e+03_r8,0.11226e+04_r8 /)
      kbo(:, 2,22, 8) = (/ &
        & 0.10436e+04_r8,0.79136e+03_r8,0.58100e+03_r8,0.85090e+03_r8,0.11227e+04_r8 /)
      kbo(:, 3,22, 8) = (/ &
        & 0.10425e+04_r8,0.79054e+03_r8,0.58071e+03_r8,0.85058e+03_r8,0.11224e+04_r8 /)
      kbo(:, 4,22, 8) = (/ &
        & 0.10416e+04_r8,0.78983e+03_r8,0.58026e+03_r8,0.85002e+03_r8,0.11217e+04_r8 /)
      kbo(:, 5,22, 8) = (/ &
        & 0.10407e+04_r8,0.78921e+03_r8,0.57969e+03_r8,0.84925e+03_r8,0.11208e+04_r8 /)
      kbo(:, 1,23, 8) = (/ &
        & 0.10414e+04_r8,0.78969e+03_r8,0.58100e+03_r8,0.85099e+03_r8,0.11227e+04_r8 /)
      kbo(:, 2,23, 8) = (/ &
        & 0.10404e+04_r8,0.78894e+03_r8,0.58090e+03_r8,0.85083e+03_r8,0.11226e+04_r8 /)
      kbo(:, 3,23, 8) = (/ &
        & 0.10395e+04_r8,0.78829e+03_r8,0.58058e+03_r8,0.85047e+03_r8,0.11223e+04_r8 /)
      kbo(:, 4,23, 8) = (/ &
        & 0.10387e+04_r8,0.78772e+03_r8,0.58011e+03_r8,0.84989e+03_r8,0.11216e+04_r8 /)
      kbo(:, 5,23, 8) = (/ &
        & 0.10381e+04_r8,0.78721e+03_r8,0.57952e+03_r8,0.84905e+03_r8,0.11206e+04_r8 /)
      kbo(:, 1,24, 8) = (/ &
        & 0.10386e+04_r8,0.78759e+03_r8,0.58095e+03_r8,0.85095e+03_r8,0.11227e+04_r8 /)
      kbo(:, 2,24, 8) = (/ &
        & 0.10378e+04_r8,0.78698e+03_r8,0.58081e+03_r8,0.85075e+03_r8,0.11226e+04_r8 /)
      kbo(:, 3,24, 8) = (/ &
        & 0.10371e+04_r8,0.78646e+03_r8,0.58046e+03_r8,0.85035e+03_r8,0.11222e+04_r8 /)
      kbo(:, 4,24, 8) = (/ &
        & 0.10365e+04_r8,0.78601e+03_r8,0.57995e+03_r8,0.84971e+03_r8,0.11214e+04_r8 /)
      kbo(:, 5,24, 8) = (/ &
        & 0.10359e+04_r8,0.78561e+03_r8,0.57934e+03_r8,0.84885e+03_r8,0.11203e+04_r8 /)
      kbo(:, 1,25, 8) = (/ &
        & 0.10363e+04_r8,0.78588e+03_r8,0.58090e+03_r8,0.85090e+03_r8,0.11227e+04_r8 /)
      kbo(:, 2,25, 8) = (/ &
        & 0.10357e+04_r8,0.78541e+03_r8,0.58070e+03_r8,0.85067e+03_r8,0.11225e+04_r8 /)
      kbo(:, 3,25, 8) = (/ &
        & 0.10351e+04_r8,0.78498e+03_r8,0.58032e+03_r8,0.85020e+03_r8,0.11220e+04_r8 /)
      kbo(:, 4,25, 8) = (/ &
        & 0.10346e+04_r8,0.78461e+03_r8,0.57980e+03_r8,0.84953e+03_r8,0.11212e+04_r8 /)
      kbo(:, 5,25, 8) = (/ &
        & 0.10342e+04_r8,0.78430e+03_r8,0.57916e+03_r8,0.84863e+03_r8,0.11201e+04_r8 /)
      kbo(:, 1,26, 8) = (/ &
        & 0.10345e+04_r8,0.78450e+03_r8,0.58084e+03_r8,0.85084e+03_r8,0.11227e+04_r8 /)
      kbo(:, 2,26, 8) = (/ &
        & 0.10339e+04_r8,0.78411e+03_r8,0.58059e+03_r8,0.85057e+03_r8,0.11224e+04_r8 /)
      kbo(:, 3,26, 8) = (/ &
        & 0.10335e+04_r8,0.78378e+03_r8,0.58018e+03_r8,0.85004e+03_r8,0.11219e+04_r8 /)
      kbo(:, 4,26, 8) = (/ &
        & 0.10331e+04_r8,0.78349e+03_r8,0.57964e+03_r8,0.84934e+03_r8,0.11210e+04_r8 /)
      kbo(:, 5,26, 8) = (/ &
        & 0.10328e+04_r8,0.78323e+03_r8,0.57897e+03_r8,0.84838e+03_r8,0.11198e+04_r8 /)
      kbo(:, 1,27, 8) = (/ &
        & 0.10329e+04_r8,0.78338e+03_r8,0.58078e+03_r8,0.85078e+03_r8,0.11227e+04_r8 /)
      kbo(:, 2,27, 8) = (/ &
        & 0.10326e+04_r8,0.78307e+03_r8,0.58048e+03_r8,0.85045e+03_r8,0.11223e+04_r8 /)
      kbo(:, 3,27, 8) = (/ &
        & 0.10322e+04_r8,0.78282e+03_r8,0.58003e+03_r8,0.84982e+03_r8,0.11217e+04_r8 /)
      kbo(:, 4,27, 8) = (/ &
        & 0.10319e+04_r8,0.78258e+03_r8,0.57947e+03_r8,0.84907e+03_r8,0.11207e+04_r8 /)
      kbo(:, 5,27, 8) = (/ &
        & 0.10316e+04_r8,0.78237e+03_r8,0.57877e+03_r8,0.84811e+03_r8,0.11194e+04_r8 /)
      kbo(:, 1,28, 8) = (/ &
        & 0.10318e+04_r8,0.78248e+03_r8,0.58069e+03_r8,0.85072e+03_r8,0.11226e+04_r8 /)
      kbo(:, 2,28, 8) = (/ &
        & 0.10314e+04_r8,0.78225e+03_r8,0.58037e+03_r8,0.85030e+03_r8,0.11222e+04_r8 /)
      kbo(:, 3,28, 8) = (/ &
        & 0.10312e+04_r8,0.78205e+03_r8,0.57989e+03_r8,0.84960e+03_r8,0.11215e+04_r8 /)
      kbo(:, 4,28, 8) = (/ &
        & 0.10309e+04_r8,0.78185e+03_r8,0.57929e+03_r8,0.84888e+03_r8,0.11204e+04_r8 /)
      kbo(:, 5,28, 8) = (/ &
        & 0.10307e+04_r8,0.78168e+03_r8,0.57856e+03_r8,0.84784e+03_r8,0.11191e+04_r8 /)
      kbo(:, 1,29, 8) = (/ &
        & 0.10308e+04_r8,0.78175e+03_r8,0.58061e+03_r8,0.85062e+03_r8,0.11225e+04_r8 /)
      kbo(:, 2,29, 8) = (/ &
        & 0.10305e+04_r8,0.78157e+03_r8,0.58024e+03_r8,0.85019e+03_r8,0.11221e+04_r8 /)
      kbo(:, 3,29, 8) = (/ &
        & 0.10303e+04_r8,0.78140e+03_r8,0.57974e+03_r8,0.84950e+03_r8,0.11213e+04_r8 /)
      kbo(:, 4,29, 8) = (/ &
        & 0.10301e+04_r8,0.78126e+03_r8,0.57911e+03_r8,0.84863e+03_r8,0.11201e+04_r8 /)
      kbo(:, 5,29, 8) = (/ &
        & 0.10300e+04_r8,0.78112e+03_r8,0.57834e+03_r8,0.84752e+03_r8,0.11188e+04_r8 /)
      kbo(:, 1,30, 8) = (/ &
        & 0.10300e+04_r8,0.78117e+03_r8,0.58052e+03_r8,0.85055e+03_r8,0.11224e+04_r8 /)
      kbo(:, 2,30, 8) = (/ &
        & 0.10298e+04_r8,0.78102e+03_r8,0.58011e+03_r8,0.85001e+03_r8,0.11219e+04_r8 /)
      kbo(:, 3,30, 8) = (/ &
        & 0.10296e+04_r8,0.78089e+03_r8,0.57958e+03_r8,0.84932e+03_r8,0.11210e+04_r8 /)
      kbo(:, 4,30, 8) = (/ &
        & 0.10295e+04_r8,0.78077e+03_r8,0.57892e+03_r8,0.84838e+03_r8,0.11198e+04_r8 /)
      kbo(:, 5,30, 8) = (/ &
        & 0.10294e+04_r8,0.78066e+03_r8,0.57811e+03_r8,0.84720e+03_r8,0.11184e+04_r8 /)
      kbo(:, 1,31, 8) = (/ &
        & 0.10294e+04_r8,0.78070e+03_r8,0.58042e+03_r8,0.85041e+03_r8,0.11223e+04_r8 /)
      kbo(:, 2,31, 8) = (/ &
        & 0.10292e+04_r8,0.78058e+03_r8,0.57998e+03_r8,0.84985e+03_r8,0.11217e+04_r8 /)
      kbo(:, 3,31, 8) = (/ &
        & 0.10291e+04_r8,0.78049e+03_r8,0.57941e+03_r8,0.84908e+03_r8,0.11207e+04_r8 /)
      kbo(:, 4,31, 8) = (/ &
        & 0.10290e+04_r8,0.78039e+03_r8,0.57872e+03_r8,0.84808e+03_r8,0.11195e+04_r8 /)
      kbo(:, 5,31, 8) = (/ &
        & 0.10289e+04_r8,0.78030e+03_r8,0.57786e+03_r8,0.84686e+03_r8,0.11179e+04_r8 /)
      kbo(:, 1,32, 8) = (/ &
        & 0.10289e+04_r8,0.78033e+03_r8,0.58031e+03_r8,0.85030e+03_r8,0.11222e+04_r8 /)
      kbo(:, 2,32, 8) = (/ &
        & 0.10288e+04_r8,0.78024e+03_r8,0.57984e+03_r8,0.84967e+03_r8,0.11215e+04_r8 /)
      kbo(:, 3,32, 8) = (/ &
        & 0.10287e+04_r8,0.78016e+03_r8,0.57924e+03_r8,0.84884e+03_r8,0.11204e+04_r8 /)
      kbo(:, 4,32, 8) = (/ &
        & 0.10286e+04_r8,0.78009e+03_r8,0.57851e+03_r8,0.84778e+03_r8,0.11191e+04_r8 /)
      kbo(:, 5,32, 8) = (/ &
        & 0.10285e+04_r8,0.78000e+03_r8,0.57759e+03_r8,0.84651e+03_r8,0.11175e+04_r8 /)
      kbo(:, 1,33, 8) = (/ &
        & 0.10285e+04_r8,0.78003e+03_r8,0.58019e+03_r8,0.85016e+03_r8,0.11220e+04_r8 /)
      kbo(:, 2,33, 8) = (/ &
        & 0.10284e+04_r8,0.77995e+03_r8,0.57968e+03_r8,0.84947e+03_r8,0.11212e+04_r8 /)
      kbo(:, 3,33, 8) = (/ &
        & 0.10283e+04_r8,0.77988e+03_r8,0.57905e+03_r8,0.84858e+03_r8,0.11201e+04_r8 /)
      kbo(:, 4,33, 8) = (/ &
        & 0.10282e+04_r8,0.77982e+03_r8,0.57829e+03_r8,0.84747e+03_r8,0.11187e+04_r8 /)
      kbo(:, 5,33, 8) = (/ &
        & 0.10282e+04_r8,0.77978e+03_r8,0.57730e+03_r8,0.84615e+03_r8,0.11170e+04_r8 /)
      kbo(:, 1,34, 8) = (/ &
        & 0.10282e+04_r8,0.77978e+03_r8,0.58008e+03_r8,0.84998e+03_r8,0.11219e+04_r8 /)
      kbo(:, 2,34, 8) = (/ &
        & 0.10281e+04_r8,0.77972e+03_r8,0.57954e+03_r8,0.84930e+03_r8,0.11210e+04_r8 /)
      kbo(:, 3,34, 8) = (/ &
        & 0.10280e+04_r8,0.77967e+03_r8,0.57889e+03_r8,0.84836e+03_r8,0.11198e+04_r8 /)
      kbo(:, 4,34, 8) = (/ &
        & 0.10280e+04_r8,0.77962e+03_r8,0.57808e+03_r8,0.84718e+03_r8,0.11184e+04_r8 /)
      kbo(:, 5,34, 8) = (/ &
        & 0.10279e+04_r8,0.77958e+03_r8,0.57705e+03_r8,0.84582e+03_r8,0.11166e+04_r8 /)
      kbo(:, 1,35, 8) = (/ &
        & 0.10279e+04_r8,0.77958e+03_r8,0.58001e+03_r8,0.84995e+03_r8,0.11218e+04_r8 /)
      kbo(:, 2,35, 8) = (/ &
        & 0.10278e+04_r8,0.77953e+03_r8,0.57946e+03_r8,0.84916e+03_r8,0.11209e+04_r8 /)
      kbo(:, 3,35, 8) = (/ &
        & 0.10278e+04_r8,0.77951e+03_r8,0.57880e+03_r8,0.84823e+03_r8,0.11196e+04_r8 /)
      kbo(:, 4,35, 8) = (/ &
        & 0.10277e+04_r8,0.77946e+03_r8,0.57796e+03_r8,0.84701e+03_r8,0.11181e+04_r8 /)
      kbo(:, 5,35, 8) = (/ &
        & 0.10277e+04_r8,0.77943e+03_r8,0.57689e+03_r8,0.84563e+03_r8,0.11163e+04_r8 /)
      kbo(:, 1,36, 8) = (/ &
        & 0.10277e+04_r8,0.77944e+03_r8,0.58000e+03_r8,0.84992e+03_r8,0.11218e+04_r8 /)
      kbo(:, 2,36, 8) = (/ &
        & 0.10277e+04_r8,0.77940e+03_r8,0.57944e+03_r8,0.84917e+03_r8,0.11208e+04_r8 /)
      kbo(:, 3,36, 8) = (/ &
        & 0.10276e+04_r8,0.77936e+03_r8,0.57877e+03_r8,0.84819e+03_r8,0.11196e+04_r8 /)
      kbo(:, 4,36, 8) = (/ &
        & 0.10276e+04_r8,0.77933e+03_r8,0.57793e+03_r8,0.84697e+03_r8,0.11181e+04_r8 /)
      kbo(:, 5,36, 8) = (/ &
        & 0.10275e+04_r8,0.77931e+03_r8,0.57686e+03_r8,0.84561e+03_r8,0.11162e+04_r8 /)
      kbo(:, 1,37, 8) = (/ &
        & 0.10275e+04_r8,0.77932e+03_r8,0.58006e+03_r8,0.85002e+03_r8,0.11219e+04_r8 /)
      kbo(:, 2,37, 8) = (/ &
        & 0.10275e+04_r8,0.77929e+03_r8,0.57952e+03_r8,0.84927e+03_r8,0.11210e+04_r8 /)
      kbo(:, 3,37, 8) = (/ &
        & 0.10275e+04_r8,0.77926e+03_r8,0.57886e+03_r8,0.84832e+03_r8,0.11198e+04_r8 /)
      kbo(:, 4,37, 8) = (/ &
        & 0.10274e+04_r8,0.77924e+03_r8,0.57805e+03_r8,0.84715e+03_r8,0.11183e+04_r8 /)
      kbo(:, 5,37, 8) = (/ &
        & 0.10274e+04_r8,0.77921e+03_r8,0.57701e+03_r8,0.84575e+03_r8,0.11165e+04_r8 /)
      kbo(:, 1,38, 8) = (/ &
        & 0.10274e+04_r8,0.77922e+03_r8,0.58012e+03_r8,0.85009e+03_r8,0.11220e+04_r8 /)
      kbo(:, 2,38, 8) = (/ &
        & 0.10274e+04_r8,0.77920e+03_r8,0.57959e+03_r8,0.84938e+03_r8,0.11211e+04_r8 /)
      kbo(:, 3,38, 8) = (/ &
        & 0.10274e+04_r8,0.77918e+03_r8,0.57896e+03_r8,0.84848e+03_r8,0.11200e+04_r8 /)
      kbo(:, 4,38, 8) = (/ &
        & 0.10273e+04_r8,0.77915e+03_r8,0.57818e+03_r8,0.84731e+03_r8,0.11185e+04_r8 /)
      kbo(:, 5,38, 8) = (/ &
        & 0.10273e+04_r8,0.77912e+03_r8,0.57716e+03_r8,0.84599e+03_r8,0.11168e+04_r8 /)
      kbo(:, 1,39, 8) = (/ &
        & 0.10273e+04_r8,0.77914e+03_r8,0.58018e+03_r8,0.85016e+03_r8,0.11221e+04_r8 /)
      kbo(:, 2,39, 8) = (/ &
        & 0.10273e+04_r8,0.77912e+03_r8,0.57968e+03_r8,0.84939e+03_r8,0.11213e+04_r8 /)
      kbo(:, 3,39, 8) = (/ &
        & 0.10273e+04_r8,0.77911e+03_r8,0.57905e+03_r8,0.84861e+03_r8,0.11201e+04_r8 /)
      kbo(:, 4,39, 8) = (/ &
        & 0.10272e+04_r8,0.77910e+03_r8,0.57829e+03_r8,0.84750e+03_r8,0.11187e+04_r8 /)
      kbo(:, 5,39, 8) = (/ &
        & 0.10272e+04_r8,0.77907e+03_r8,0.57732e+03_r8,0.84617e+03_r8,0.11171e+04_r8 /)
      kbo(:, 1,40, 8) = (/ &
        & 0.10272e+04_r8,0.77908e+03_r8,0.58028e+03_r8,0.85029e+03_r8,0.11222e+04_r8 /)
      kbo(:, 2,40, 8) = (/ &
        & 0.10272e+04_r8,0.77906e+03_r8,0.57981e+03_r8,0.84968e+03_r8,0.11215e+04_r8 /)
      kbo(:, 3,40, 8) = (/ &
        & 0.10272e+04_r8,0.77904e+03_r8,0.57922e+03_r8,0.84885e+03_r8,0.11204e+04_r8 /)
      kbo(:, 4,40, 8) = (/ &
        & 0.10272e+04_r8,0.77904e+03_r8,0.57849e+03_r8,0.84779e+03_r8,0.11191e+04_r8 /)
      kbo(:, 5,40, 8) = (/ &
        & 0.10272e+04_r8,0.77901e+03_r8,0.57757e+03_r8,0.84651e+03_r8,0.11176e+04_r8 /)
      kbo(:, 1,41, 8) = (/ &
        & 0.10272e+04_r8,0.77903e+03_r8,0.58037e+03_r8,0.85041e+03_r8,0.11224e+04_r8 /)
      kbo(:, 2,41, 8) = (/ &
        & 0.10272e+04_r8,0.77902e+03_r8,0.57994e+03_r8,0.84983e+03_r8,0.11217e+04_r8 /)
      kbo(:, 3,41, 8) = (/ &
        & 0.10271e+04_r8,0.77900e+03_r8,0.57937e+03_r8,0.84906e+03_r8,0.11207e+04_r8 /)
      kbo(:, 4,41, 8) = (/ &
        & 0.10271e+04_r8,0.77898e+03_r8,0.57870e+03_r8,0.84808e+03_r8,0.11195e+04_r8 /)
      kbo(:, 5,41, 8) = (/ &
        & 0.10271e+04_r8,0.77898e+03_r8,0.57782e+03_r8,0.84685e+03_r8,0.11180e+04_r8 /)
      kbo(:, 1,42, 8) = (/ &
        & 0.10271e+04_r8,0.77900e+03_r8,0.58046e+03_r8,0.85051e+03_r8,0.11225e+04_r8 /)
      kbo(:, 2,42, 8) = (/ &
        & 0.10271e+04_r8,0.77898e+03_r8,0.58006e+03_r8,0.85002e+03_r8,0.11219e+04_r8 /)
      kbo(:, 3,42, 8) = (/ &
        & 0.10271e+04_r8,0.77896e+03_r8,0.57953e+03_r8,0.84930e+03_r8,0.11210e+04_r8 /)
      kbo(:, 4,42, 8) = (/ &
        & 0.10271e+04_r8,0.77895e+03_r8,0.57888e+03_r8,0.84835e+03_r8,0.11198e+04_r8 /)
      kbo(:, 5,42, 8) = (/ &
        & 0.10270e+04_r8,0.77894e+03_r8,0.57806e+03_r8,0.84718e+03_r8,0.11184e+04_r8 /)
      kbo(:, 1,43, 8) = (/ &
        & 0.10271e+04_r8,0.77895e+03_r8,0.58056e+03_r8,0.85062e+03_r8,0.11226e+04_r8 /)
      kbo(:, 2,43, 8) = (/ &
        & 0.10270e+04_r8,0.77895e+03_r8,0.58020e+03_r8,0.85017e+03_r8,0.11221e+04_r8 /)
      kbo(:, 3,43, 8) = (/ &
        & 0.10270e+04_r8,0.77892e+03_r8,0.57970e+03_r8,0.84954e+03_r8,0.11213e+04_r8 /)
      kbo(:, 4,43, 8) = (/ &
        & 0.10270e+04_r8,0.77892e+03_r8,0.57909e+03_r8,0.84866e+03_r8,0.11202e+04_r8 /)
      kbo(:, 5,43, 8) = (/ &
        & 0.10270e+04_r8,0.77891e+03_r8,0.57834e+03_r8,0.84756e+03_r8,0.11188e+04_r8 /)
      kbo(:, 1,44, 8) = (/ &
        & 0.10270e+04_r8,0.77892e+03_r8,0.58064e+03_r8,0.85071e+03_r8,0.11226e+04_r8 /)
      kbo(:, 2,44, 8) = (/ &
        & 0.10270e+04_r8,0.77891e+03_r8,0.58034e+03_r8,0.85036e+03_r8,0.11223e+04_r8 /)
      kbo(:, 3,44, 8) = (/ &
        & 0.10270e+04_r8,0.77891e+03_r8,0.57988e+03_r8,0.84979e+03_r8,0.11216e+04_r8 /)
      kbo(:, 4,44, 8) = (/ &
        & 0.10270e+04_r8,0.77890e+03_r8,0.57931e+03_r8,0.84899e+03_r8,0.11206e+04_r8 /)
      kbo(:, 5,44, 8) = (/ &
        & 0.10270e+04_r8,0.77888e+03_r8,0.57861e+03_r8,0.84797e+03_r8,0.11193e+04_r8 /)
      kbo(:, 1,45, 8) = (/ &
        & 0.10270e+04_r8,0.77889e+03_r8,0.58069e+03_r8,0.85078e+03_r8,0.11227e+04_r8 /)
      kbo(:, 2,45, 8) = (/ &
        & 0.10270e+04_r8,0.77888e+03_r8,0.58047e+03_r8,0.85051e+03_r8,0.11224e+04_r8 /)
      kbo(:, 3,45, 8) = (/ &
        & 0.10270e+04_r8,0.77888e+03_r8,0.58005e+03_r8,0.84999e+03_r8,0.11219e+04_r8 /)
      kbo(:, 4,45, 8) = (/ &
        & 0.10270e+04_r8,0.77888e+03_r8,0.57952e+03_r8,0.84927e+03_r8,0.11210e+04_r8 /)
      kbo(:, 5,45, 8) = (/ &
        & 0.10269e+04_r8,0.77886e+03_r8,0.57890e+03_r8,0.84837e+03_r8,0.11198e+04_r8 /)
      kbo(:, 1,46, 8) = (/ &
        & 0.10270e+04_r8,0.77887e+03_r8,0.58072e+03_r8,0.85082e+03_r8,0.11227e+04_r8 /)
      kbo(:, 2,46, 8) = (/ &
        & 0.10270e+04_r8,0.77886e+03_r8,0.58056e+03_r8,0.85063e+03_r8,0.11226e+04_r8 /)
      kbo(:, 3,46, 8) = (/ &
        & 0.10269e+04_r8,0.77886e+03_r8,0.58022e+03_r8,0.85021e+03_r8,0.11221e+04_r8 /)
      kbo(:, 4,46, 8) = (/ &
        & 0.10270e+04_r8,0.77885e+03_r8,0.57972e+03_r8,0.84957e+03_r8,0.11213e+04_r8 /)
      kbo(:, 5,46, 8) = (/ &
        & 0.10269e+04_r8,0.77884e+03_r8,0.57911e+03_r8,0.84871e+03_r8,0.11203e+04_r8 /)
      kbo(:, 1,47, 8) = (/ &
        & 0.10269e+04_r8,0.77885e+03_r8,0.58070e+03_r8,0.85086e+03_r8,0.11227e+04_r8 /)
      kbo(:, 2,47, 8) = (/ &
        & 0.10269e+04_r8,0.77886e+03_r8,0.58066e+03_r8,0.85073e+03_r8,0.11227e+04_r8 /)
      kbo(:, 3,47, 8) = (/ &
        & 0.10269e+04_r8,0.77885e+03_r8,0.58037e+03_r8,0.85041e+03_r8,0.11223e+04_r8 /)
      kbo(:, 4,47, 8) = (/ &
        & 0.10269e+04_r8,0.77884e+03_r8,0.57993e+03_r8,0.84985e+03_r8,0.11217e+04_r8 /)
      kbo(:, 5,47, 8) = (/ &
        & 0.10269e+04_r8,0.77883e+03_r8,0.57937e+03_r8,0.84903e+03_r8,0.11207e+04_r8 /)
      kbo(:, 1,48, 8) = (/ &
        & 0.10269e+04_r8,0.77884e+03_r8,0.58064e+03_r8,0.85086e+03_r8,0.11226e+04_r8 /)
      kbo(:, 2,48, 8) = (/ &
        & 0.10269e+04_r8,0.77883e+03_r8,0.58071e+03_r8,0.85080e+03_r8,0.11227e+04_r8 /)
      kbo(:, 3,48, 8) = (/ &
        & 0.10269e+04_r8,0.77883e+03_r8,0.58051e+03_r8,0.85055e+03_r8,0.11225e+04_r8 /)
      kbo(:, 4,48, 8) = (/ &
        & 0.10269e+04_r8,0.77883e+03_r8,0.58013e+03_r8,0.85010e+03_r8,0.11220e+04_r8 /)
      kbo(:, 5,48, 8) = (/ &
        & 0.10269e+04_r8,0.77883e+03_r8,0.57961e+03_r8,0.84941e+03_r8,0.11212e+04_r8 /)
      kbo(:, 1,49, 8) = (/ &
        & 0.10269e+04_r8,0.77884e+03_r8,0.58054e+03_r8,0.85082e+03_r8,0.11225e+04_r8 /)
      kbo(:, 2,49, 8) = (/ &
        & 0.10269e+04_r8,0.77882e+03_r8,0.58072e+03_r8,0.85085e+03_r8,0.11227e+04_r8 /)
      kbo(:, 3,49, 8) = (/ &
        & 0.10269e+04_r8,0.77883e+03_r8,0.58061e+03_r8,0.85068e+03_r8,0.11226e+04_r8 /)
      kbo(:, 4,49, 8) = (/ &
        & 0.10269e+04_r8,0.77882e+03_r8,0.58029e+03_r8,0.85032e+03_r8,0.11222e+04_r8 /)
      kbo(:, 5,49, 8) = (/ &
        & 0.10269e+04_r8,0.77881e+03_r8,0.57983e+03_r8,0.84969e+03_r8,0.11215e+04_r8 /)
      kbo(:, 1,50, 8) = (/ &
        & 0.10269e+04_r8,0.77883e+03_r8,0.58042e+03_r8,0.85074e+03_r8,0.11224e+04_r8 /)
      kbo(:, 2,50, 8) = (/ &
        & 0.10269e+04_r8,0.77881e+03_r8,0.58068e+03_r8,0.85085e+03_r8,0.11226e+04_r8 /)
      kbo(:, 3,50, 8) = (/ &
        & 0.10269e+04_r8,0.77882e+03_r8,0.58069e+03_r8,0.85077e+03_r8,0.11227e+04_r8 /)
      kbo(:, 4,50, 8) = (/ &
        & 0.10269e+04_r8,0.77880e+03_r8,0.58043e+03_r8,0.85048e+03_r8,0.11224e+04_r8 /)
      kbo(:, 5,50, 8) = (/ &
        & 0.10269e+04_r8,0.77880e+03_r8,0.58002e+03_r8,0.84997e+03_r8,0.11218e+04_r8 /)
      kbo(:, 1,51, 8) = (/ &
        & 0.10269e+04_r8,0.77881e+03_r8,0.58027e+03_r8,0.85064e+03_r8,0.11224e+04_r8 /)
      kbo(:, 2,51, 8) = (/ &
        & 0.10269e+04_r8,0.77882e+03_r8,0.58061e+03_r8,0.85085e+03_r8,0.11226e+04_r8 /)
      kbo(:, 3,51, 8) = (/ &
        & 0.10269e+04_r8,0.77880e+03_r8,0.58071e+03_r8,0.85082e+03_r8,0.11227e+04_r8 /)
      kbo(:, 4,51, 8) = (/ &
        & 0.10269e+04_r8,0.77880e+03_r8,0.58055e+03_r8,0.85061e+03_r8,0.11226e+04_r8 /)
      kbo(:, 5,51, 8) = (/ &
        & 0.10269e+04_r8,0.77881e+03_r8,0.58020e+03_r8,0.85015e+03_r8,0.11221e+04_r8 /)
      kbo(:, 1,52, 8) = (/ &
        & 0.10269e+04_r8,0.77880e+03_r8,0.58011e+03_r8,0.85051e+03_r8,0.11222e+04_r8 /)
      kbo(:, 2,52, 8) = (/ &
        & 0.10269e+04_r8,0.77880e+03_r8,0.58051e+03_r8,0.85080e+03_r8,0.11225e+04_r8 /)
      kbo(:, 3,52, 8) = (/ &
        & 0.10269e+04_r8,0.77880e+03_r8,0.58071e+03_r8,0.85085e+03_r8,0.11227e+04_r8 /)
      kbo(:, 4,52, 8) = (/ &
        & 0.10268e+04_r8,0.77879e+03_r8,0.58064e+03_r8,0.85068e+03_r8,0.11226e+04_r8 /)
      kbo(:, 5,52, 8) = (/ &
        & 0.10268e+04_r8,0.77879e+03_r8,0.58034e+03_r8,0.85037e+03_r8,0.11223e+04_r8 /)
      kbo(:, 1,53, 8) = (/ &
        & 0.10269e+04_r8,0.77880e+03_r8,0.57994e+03_r8,0.85036e+03_r8,0.11220e+04_r8 /)
      kbo(:, 2,53, 8) = (/ &
        & 0.10269e+04_r8,0.77879e+03_r8,0.58038e+03_r8,0.85072e+03_r8,0.11224e+04_r8 /)
      kbo(:, 3,53, 8) = (/ &
        & 0.10268e+04_r8,0.77879e+03_r8,0.58066e+03_r8,0.85087e+03_r8,0.11226e+04_r8 /)
      kbo(:, 4,53, 8) = (/ &
        & 0.10269e+04_r8,0.77880e+03_r8,0.58069e+03_r8,0.85078e+03_r8,0.11227e+04_r8 /)
      kbo(:, 5,53, 8) = (/ &
        & 0.10268e+04_r8,0.77878e+03_r8,0.58047e+03_r8,0.85044e+03_r8,0.11225e+04_r8 /)
      kbo(:, 1,54, 8) = (/ &
        & 0.10268e+04_r8,0.77879e+03_r8,0.57977e+03_r8,0.85022e+03_r8,0.11219e+04_r8 /)
      kbo(:, 2,54, 8) = (/ &
        & 0.10269e+04_r8,0.77879e+03_r8,0.58026e+03_r8,0.85061e+03_r8,0.11223e+04_r8 /)
      kbo(:, 3,54, 8) = (/ &
        & 0.10268e+04_r8,0.77881e+03_r8,0.58060e+03_r8,0.85084e+03_r8,0.11226e+04_r8 /)
      kbo(:, 4,54, 8) = (/ &
        & 0.10268e+04_r8,0.77879e+03_r8,0.58072e+03_r8,0.85083e+03_r8,0.11227e+04_r8 /)
      kbo(:, 5,54, 8) = (/ &
        & 0.10268e+04_r8,0.77878e+03_r8,0.58058e+03_r8,0.85063e+03_r8,0.11226e+04_r8 /)
      kbo(:, 1,55, 8) = (/ &
        & 0.10268e+04_r8,0.77879e+03_r8,0.57962e+03_r8,0.85008e+03_r8,0.11217e+04_r8 /)
      kbo(:, 2,55, 8) = (/ &
        & 0.10268e+04_r8,0.77878e+03_r8,0.58011e+03_r8,0.85050e+03_r8,0.11222e+04_r8 /)
      kbo(:, 3,55, 8) = (/ &
        & 0.10268e+04_r8,0.77879e+03_r8,0.58050e+03_r8,0.85080e+03_r8,0.11225e+04_r8 /)
      kbo(:, 4,55, 8) = (/ &
        & 0.10268e+04_r8,0.77880e+03_r8,0.58071e+03_r8,0.85085e+03_r8,0.11226e+04_r8 /)
      kbo(:, 5,55, 8) = (/ &
        & 0.10268e+04_r8,0.77878e+03_r8,0.58064e+03_r8,0.85072e+03_r8,0.11226e+04_r8 /)
      kbo(:, 1,56, 8) = (/ &
        & 0.10268e+04_r8,0.77878e+03_r8,0.57945e+03_r8,0.84993e+03_r8,0.11216e+04_r8 /)
      kbo(:, 2,56, 8) = (/ &
        & 0.10268e+04_r8,0.77877e+03_r8,0.57995e+03_r8,0.85037e+03_r8,0.11220e+04_r8 /)
      kbo(:, 3,56, 8) = (/ &
        & 0.10268e+04_r8,0.77877e+03_r8,0.58039e+03_r8,0.85071e+03_r8,0.11224e+04_r8 /)
      kbo(:, 4,56, 8) = (/ &
        & 0.10268e+04_r8,0.77878e+03_r8,0.58067e+03_r8,0.85086e+03_r8,0.11226e+04_r8 /)
      kbo(:, 5,56, 8) = (/ &
        & 0.10268e+04_r8,0.77878e+03_r8,0.58069e+03_r8,0.85078e+03_r8,0.11227e+04_r8 /)
      kbo(:, 1,57, 8) = (/ &
        & 0.10268e+04_r8,0.77879e+03_r8,0.57927e+03_r8,0.84978e+03_r8,0.11215e+04_r8 /)
      kbo(:, 2,57, 8) = (/ &
        & 0.10268e+04_r8,0.77878e+03_r8,0.57979e+03_r8,0.85024e+03_r8,0.11219e+04_r8 /)
      kbo(:, 3,57, 8) = (/ &
        & 0.10268e+04_r8,0.77878e+03_r8,0.58025e+03_r8,0.85063e+03_r8,0.11223e+04_r8 /)
      kbo(:, 4,57, 8) = (/ &
        & 0.10268e+04_r8,0.77878e+03_r8,0.58060e+03_r8,0.85084e+03_r8,0.11226e+04_r8 /)
      kbo(:, 5,57, 8) = (/ &
        & 0.10268e+04_r8,0.77878e+03_r8,0.58071e+03_r8,0.85083e+03_r8,0.11227e+04_r8 /)
      kbo(:, 1,58, 8) = (/ &
        & 0.10268e+04_r8,0.77878e+03_r8,0.57911e+03_r8,0.84962e+03_r8,0.11212e+04_r8 /)
      kbo(:, 2,58, 8) = (/ &
        & 0.10268e+04_r8,0.77878e+03_r8,0.57964e+03_r8,0.85010e+03_r8,0.11218e+04_r8 /)
      kbo(:, 3,58, 8) = (/ &
        & 0.10268e+04_r8,0.77877e+03_r8,0.58013e+03_r8,0.85053e+03_r8,0.11222e+04_r8 /)
      kbo(:, 4,58, 8) = (/ &
        & 0.10268e+04_r8,0.77877e+03_r8,0.58052e+03_r8,0.85080e+03_r8,0.11225e+04_r8 /)
      kbo(:, 5,58, 8) = (/ &
        & 0.10268e+04_r8,0.77879e+03_r8,0.58071e+03_r8,0.85085e+03_r8,0.11227e+04_r8 /)
      kbo(:, 1,59, 8) = (/ &
        & 0.10268e+04_r8,0.77878e+03_r8,0.57904e+03_r8,0.84955e+03_r8,0.11212e+04_r8 /)
      kbo(:, 2,59, 8) = (/ &
        & 0.10268e+04_r8,0.77877e+03_r8,0.57958e+03_r8,0.85006e+03_r8,0.11217e+04_r8 /)
      kbo(:, 3,59, 8) = (/ &
        & 0.10268e+04_r8,0.77877e+03_r8,0.58007e+03_r8,0.85048e+03_r8,0.11222e+04_r8 /)
      kbo(:, 4,59, 8) = (/ &
        & 0.10268e+04_r8,0.77878e+03_r8,0.58048e+03_r8,0.85078e+03_r8,0.11225e+04_r8 /)
      kbo(:, 5,59, 8) = (/ &
        & 0.10268e+04_r8,0.77877e+03_r8,0.58070e+03_r8,0.85086e+03_r8,0.11227e+04_r8 /)
      kbo(:, 1,13, 9) = (/ &
        & 0.11533e+04_r8,0.87327e+03_r8,0.59473e+03_r8,0.87046e+03_r8,0.11487e+04_r8 /)
      kbo(:, 2,13, 9) = (/ &
        & 0.11444e+04_r8,0.86660e+03_r8,0.59240e+03_r8,0.87005e+03_r8,0.11483e+04_r8 /)
      kbo(:, 3,13, 9) = (/ &
        & 0.11367e+04_r8,0.86090e+03_r8,0.59185e+03_r8,0.86950e+03_r8,0.11478e+04_r8 /)
      kbo(:, 4,13, 9) = (/ &
        & 0.11301e+04_r8,0.85587e+03_r8,0.59143e+03_r8,0.86883e+03_r8,0.11469e+04_r8 /)
      kbo(:, 5,13, 9) = (/ &
        & 0.11242e+04_r8,0.85148e+03_r8,0.59084e+03_r8,0.86797e+03_r8,0.11458e+04_r8 /)
      kbo(:, 1,14, 9) = (/ &
        & 0.11310e+04_r8,0.85656e+03_r8,0.59238e+03_r8,0.87026e+03_r8,0.11487e+04_r8 /)
      kbo(:, 2,14, 9) = (/ &
        & 0.11238e+04_r8,0.85118e+03_r8,0.59190e+03_r8,0.86988e+03_r8,0.11483e+04_r8 /)
      kbo(:, 3,14, 9) = (/ &
        & 0.11176e+04_r8,0.84654e+03_r8,0.59149e+03_r8,0.86931e+03_r8,0.11477e+04_r8 /)
      kbo(:, 4,14, 9) = (/ &
        & 0.11122e+04_r8,0.84248e+03_r8,0.59105e+03_r8,0.86863e+03_r8,0.11468e+04_r8 /)
      kbo(:, 5,14, 9) = (/ &
        & 0.11074e+04_r8,0.83890e+03_r8,0.59046e+03_r8,0.86777e+03_r8,0.11457e+04_r8 /)
      kbo(:, 1,15, 9) = (/ &
        & 0.11128e+04_r8,0.84292e+03_r8,0.59202e+03_r8,0.87009e+03_r8,0.11486e+04_r8 /)
      kbo(:, 2,15, 9) = (/ &
        & 0.11070e+04_r8,0.83857e+03_r8,0.59157e+03_r8,0.86969e+03_r8,0.11482e+04_r8 /)
      kbo(:, 3,15, 9) = (/ &
        & 0.11020e+04_r8,0.83480e+03_r8,0.59118e+03_r8,0.86913e+03_r8,0.11476e+04_r8 /)
      kbo(:, 4,15, 9) = (/ &
        & 0.10976e+04_r8,0.83151e+03_r8,0.59076e+03_r8,0.86843e+03_r8,0.11467e+04_r8 /)
      kbo(:, 5,15, 9) = (/ &
        & 0.10938e+04_r8,0.82865e+03_r8,0.59015e+03_r8,0.86756e+03_r8,0.11457e+04_r8 /)
      kbo(:, 1,16, 9) = (/ &
        & 0.10980e+04_r8,0.83182e+03_r8,0.59172e+03_r8,0.86994e+03_r8,0.11486e+04_r8 /)
      kbo(:, 2,16, 9) = (/ &
        & 0.10933e+04_r8,0.82831e+03_r8,0.59129e+03_r8,0.86966e+03_r8,0.11482e+04_r8 /)
      kbo(:, 3,16, 9) = (/ &
        & 0.10893e+04_r8,0.82527e+03_r8,0.59092e+03_r8,0.86898e+03_r8,0.11475e+04_r8 /)
      kbo(:, 4,16, 9) = (/ &
        & 0.10858e+04_r8,0.82261e+03_r8,0.59049e+03_r8,0.86826e+03_r8,0.11466e+04_r8 /)
      kbo(:, 5,16, 9) = (/ &
        & 0.10827e+04_r8,0.82037e+03_r8,0.58989e+03_r8,0.86738e+03_r8,0.11455e+04_r8 /)
      kbo(:, 1,17, 9) = (/ &
        & 0.10860e+04_r8,0.82280e+03_r8,0.59147e+03_r8,0.86983e+03_r8,0.11485e+04_r8 /)
      kbo(:, 2,17, 9) = (/ &
        & 0.10822e+04_r8,0.81997e+03_r8,0.59107e+03_r8,0.86941e+03_r8,0.11481e+04_r8 /)
      kbo(:, 3,17, 9) = (/ &
        & 0.10790e+04_r8,0.81753e+03_r8,0.59070e+03_r8,0.86883e+03_r8,0.11474e+04_r8 /)
      kbo(:, 4,17, 9) = (/ &
        & 0.10761e+04_r8,0.81539e+03_r8,0.59027e+03_r8,0.86811e+03_r8,0.11465e+04_r8 /)
      kbo(:, 5,17, 9) = (/ &
        & 0.10736e+04_r8,0.81353e+03_r8,0.58965e+03_r8,0.86721e+03_r8,0.11454e+04_r8 /)
      kbo(:, 1,18, 9) = (/ &
        & 0.10762e+04_r8,0.81555e+03_r8,0.59126e+03_r8,0.86969e+03_r8,0.11485e+04_r8 /)
      kbo(:, 2,18, 9) = (/ &
        & 0.10732e+04_r8,0.81322e+03_r8,0.59088e+03_r8,0.86928e+03_r8,0.11481e+04_r8 /)
      kbo(:, 3,18, 9) = (/ &
        & 0.10706e+04_r8,0.81128e+03_r8,0.59052e+03_r8,0.86870e+03_r8,0.11474e+04_r8 /)
      kbo(:, 4,18, 9) = (/ &
        & 0.10683e+04_r8,0.80956e+03_r8,0.59008e+03_r8,0.86800e+03_r8,0.11464e+04_r8 /)
      kbo(:, 5,18, 9) = (/ &
        & 0.10663e+04_r8,0.80808e+03_r8,0.58945e+03_r8,0.86705e+03_r8,0.11452e+04_r8 /)
      kbo(:, 1,19, 9) = (/ &
        & 0.10684e+04_r8,0.80963e+03_r8,0.59108e+03_r8,0.86962e+03_r8,0.11485e+04_r8 /)
      kbo(:, 2,19, 9) = (/ &
        & 0.10659e+04_r8,0.80774e+03_r8,0.59072e+03_r8,0.86917e+03_r8,0.11480e+04_r8 /)
      kbo(:, 3,19, 9) = (/ &
        & 0.10638e+04_r8,0.80613e+03_r8,0.59038e+03_r8,0.86858e+03_r8,0.11473e+04_r8 /)
      kbo(:, 4,19, 9) = (/ &
        & 0.10619e+04_r8,0.80481e+03_r8,0.58991e+03_r8,0.86784e+03_r8,0.11463e+04_r8 /)
      kbo(:, 5,19, 9) = (/ &
        & 0.10603e+04_r8,0.80353e+03_r8,0.58926e+03_r8,0.86690e+03_r8,0.11451e+04_r8 /)
      kbo(:, 1,20, 9) = (/ &
        & 0.10619e+04_r8,0.80474e+03_r8,0.59092e+03_r8,0.86952e+03_r8,0.11484e+04_r8 /)
      kbo(:, 2,20, 9) = (/ &
        & 0.10599e+04_r8,0.80326e+03_r8,0.59057e+03_r8,0.86907e+03_r8,0.11479e+04_r8 /)
      kbo(:, 3,20, 9) = (/ &
        & 0.10582e+04_r8,0.80198e+03_r8,0.59022e+03_r8,0.86845e+03_r8,0.11472e+04_r8 /)
      kbo(:, 4,20, 9) = (/ &
        & 0.10567e+04_r8,0.80089e+03_r8,0.58976e+03_r8,0.86771e+03_r8,0.11462e+04_r8 /)
      kbo(:, 5,20, 9) = (/ &
        & 0.10554e+04_r8,0.79986e+03_r8,0.58910e+03_r8,0.86674e+03_r8,0.11449e+04_r8 /)
      kbo(:, 1,21, 9) = (/ &
        & 0.10567e+04_r8,0.80080e+03_r8,0.59079e+03_r8,0.86945e+03_r8,0.11483e+04_r8 /)
      kbo(:, 2,21, 9) = (/ &
        & 0.10550e+04_r8,0.79960e+03_r8,0.59045e+03_r8,0.86897e+03_r8,0.11478e+04_r8 /)
      kbo(:, 3,21, 9) = (/ &
        & 0.10537e+04_r8,0.79858e+03_r8,0.59010e+03_r8,0.86836e+03_r8,0.11471e+04_r8 /)
      kbo(:, 4,21, 9) = (/ &
        & 0.10525e+04_r8,0.79770e+03_r8,0.58962e+03_r8,0.86752e+03_r8,0.11460e+04_r8 /)
      kbo(:, 5,21, 9) = (/ &
        & 0.10514e+04_r8,0.79685e+03_r8,0.58893e+03_r8,0.86654e+03_r8,0.11447e+04_r8 /)
      kbo(:, 1,22, 9) = (/ &
        & 0.10523e+04_r8,0.79754e+03_r8,0.59066e+03_r8,0.86933e+03_r8,0.11483e+04_r8 /)
      kbo(:, 2,22, 9) = (/ &
        & 0.10510e+04_r8,0.79661e+03_r8,0.59033e+03_r8,0.86884e+03_r8,0.11477e+04_r8 /)
      kbo(:, 3,22, 9) = (/ &
        & 0.10500e+04_r8,0.79577e+03_r8,0.58997e+03_r8,0.86819e+03_r8,0.11469e+04_r8 /)
      kbo(:, 4,22, 9) = (/ &
        & 0.10490e+04_r8,0.79506e+03_r8,0.58945e+03_r8,0.86737e+03_r8,0.11458e+04_r8 /)
      kbo(:, 5,22, 9) = (/ &
        & 0.10482e+04_r8,0.79443e+03_r8,0.58872e+03_r8,0.86635e+03_r8,0.11444e+04_r8 /)
      kbo(:, 1,23, 9) = (/ &
        & 0.10488e+04_r8,0.79491e+03_r8,0.59053e+03_r8,0.86922e+03_r8,0.11482e+04_r8 /)
      kbo(:, 2,23, 9) = (/ &
        & 0.10478e+04_r8,0.79417e+03_r8,0.59023e+03_r8,0.86872e+03_r8,0.11476e+04_r8 /)
      kbo(:, 3,23, 9) = (/ &
        & 0.10469e+04_r8,0.79351e+03_r8,0.58983e+03_r8,0.86802e+03_r8,0.11467e+04_r8 /)
      kbo(:, 4,23, 9) = (/ &
        & 0.10461e+04_r8,0.79293e+03_r8,0.58929e+03_r8,0.86717e+03_r8,0.11456e+04_r8 /)
      kbo(:, 5,23, 9) = (/ &
        & 0.10455e+04_r8,0.79241e+03_r8,0.58851e+03_r8,0.86610e+03_r8,0.11442e+04_r8 /)
      kbo(:, 1,24, 9) = (/ &
        & 0.10460e+04_r8,0.79285e+03_r8,0.59042e+03_r8,0.86910e+03_r8,0.11481e+04_r8 /)
      kbo(:, 2,24, 9) = (/ &
        & 0.10452e+04_r8,0.79220e+03_r8,0.59009e+03_r8,0.86856e+03_r8,0.11474e+04_r8 /)
      kbo(:, 3,24, 9) = (/ &
        & 0.10445e+04_r8,0.79170e+03_r8,0.58968e+03_r8,0.86785e+03_r8,0.11465e+04_r8 /)
      kbo(:, 4,24, 9) = (/ &
        & 0.10439e+04_r8,0.79123e+03_r8,0.58911e+03_r8,0.86698e+03_r8,0.11453e+04_r8 /)
      kbo(:, 5,24, 9) = (/ &
        & 0.10433e+04_r8,0.79086e+03_r8,0.58830e+03_r8,0.86584e+03_r8,0.11439e+04_r8 /)
      kbo(:, 1,25, 9) = (/ &
        & 0.10438e+04_r8,0.79109e+03_r8,0.59032e+03_r8,0.86899e+03_r8,0.11480e+04_r8 /)
      kbo(:, 2,25, 9) = (/ &
        & 0.10430e+04_r8,0.79059e+03_r8,0.58999e+03_r8,0.86841e+03_r8,0.11473e+04_r8 /)
      kbo(:, 3,25, 9) = (/ &
        & 0.10425e+04_r8,0.79018e+03_r8,0.58955e+03_r8,0.86768e+03_r8,0.11463e+04_r8 /)
      kbo(:, 4,25, 9) = (/ &
        & 0.10420e+04_r8,0.78985e+03_r8,0.58893e+03_r8,0.86674e+03_r8,0.11450e+04_r8 /)
      kbo(:, 5,25, 9) = (/ &
        & 0.10416e+04_r8,0.78947e+03_r8,0.58810e+03_r8,0.86557e+03_r8,0.11436e+04_r8 /)
      kbo(:, 1,26, 9) = (/ &
        & 0.10418e+04_r8,0.78966e+03_r8,0.59022e+03_r8,0.86886e+03_r8,0.11478e+04_r8 /)
      kbo(:, 2,26, 9) = (/ &
        & 0.10414e+04_r8,0.78932e+03_r8,0.58989e+03_r8,0.86824e+03_r8,0.11471e+04_r8 /)
      kbo(:, 3,26, 9) = (/ &
        & 0.10409e+04_r8,0.78898e+03_r8,0.58940e+03_r8,0.86743e+03_r8,0.11460e+04_r8 /)
      kbo(:, 4,26, 9) = (/ &
        & 0.10405e+04_r8,0.78870e+03_r8,0.58873e+03_r8,0.86647e+03_r8,0.11447e+04_r8 /)
      kbo(:, 5,26, 9) = (/ &
        & 0.10401e+04_r8,0.78842e+03_r8,0.58782e+03_r8,0.86527e+03_r8,0.11432e+04_r8 /)
      kbo(:, 1,27, 9) = (/ &
        & 0.10403e+04_r8,0.78855e+03_r8,0.59012e+03_r8,0.86872e+03_r8,0.11477e+04_r8 /)
      kbo(:, 2,27, 9) = (/ &
        & 0.10399e+04_r8,0.78827e+03_r8,0.58977e+03_r8,0.86806e+03_r8,0.11468e+04_r8 /)
      kbo(:, 3,27, 9) = (/ &
        & 0.10396e+04_r8,0.78799e+03_r8,0.58924e+03_r8,0.86723e+03_r8,0.11458e+04_r8 /)
      kbo(:, 4,27, 9) = (/ &
        & 0.10392e+04_r8,0.78776e+03_r8,0.58850e+03_r8,0.86619e+03_r8,0.11444e+04_r8 /)
      kbo(:, 5,27, 9) = (/ &
        & 0.10390e+04_r8,0.78757e+03_r8,0.58756e+03_r8,0.86495e+03_r8,0.11428e+04_r8 /)
      kbo(:, 1,28, 9) = (/ &
        & 0.10391e+04_r8,0.78770e+03_r8,0.59002e+03_r8,0.86856e+03_r8,0.11475e+04_r8 /)
      kbo(:, 2,28, 9) = (/ &
        & 0.10388e+04_r8,0.78747e+03_r8,0.58964e+03_r8,0.86790e+03_r8,0.11466e+04_r8 /)
      kbo(:, 3,28, 9) = (/ &
        & 0.10385e+04_r8,0.78719e+03_r8,0.58908e+03_r8,0.86701e+03_r8,0.11455e+04_r8 /)
      kbo(:, 4,28, 9) = (/ &
        & 0.10383e+04_r8,0.78704e+03_r8,0.58829e+03_r8,0.86590e+03_r8,0.11440e+04_r8 /)
      kbo(:, 5,28, 9) = (/ &
        & 0.10381e+04_r8,0.78687e+03_r8,0.58729e+03_r8,0.86461e+03_r8,0.11423e+04_r8 /)
      kbo(:, 1,29, 9) = (/ &
        & 0.10382e+04_r8,0.78694e+03_r8,0.58994e+03_r8,0.86841e+03_r8,0.11473e+04_r8 /)
      kbo(:, 2,29, 9) = (/ &
        & 0.10379e+04_r8,0.78677e+03_r8,0.58950e+03_r8,0.86767e+03_r8,0.11463e+04_r8 /)
      kbo(:, 3,29, 9) = (/ &
        & 0.10377e+04_r8,0.78658e+03_r8,0.58888e+03_r8,0.86674e+03_r8,0.11451e+04_r8 /)
      kbo(:, 4,29, 9) = (/ &
        & 0.10375e+04_r8,0.78645e+03_r8,0.58805e+03_r8,0.86559e+03_r8,0.11436e+04_r8 /)
      kbo(:, 5,29, 9) = (/ &
        & 0.10374e+04_r8,0.78628e+03_r8,0.58702e+03_r8,0.86429e+03_r8,0.11419e+04_r8 /)
      kbo(:, 1,30, 9) = (/ &
        & 0.10373e+04_r8,0.78632e+03_r8,0.58983e+03_r8,0.86822e+03_r8,0.11471e+04_r8 /)
      kbo(:, 2,30, 9) = (/ &
        & 0.10371e+04_r8,0.78619e+03_r8,0.58935e+03_r8,0.86746e+03_r8,0.11460e+04_r8 /)
      kbo(:, 3,30, 9) = (/ &
        & 0.10370e+04_r8,0.78613e+03_r8,0.58869e+03_r8,0.86647e+03_r8,0.11448e+04_r8 /)
      kbo(:, 4,30, 9) = (/ &
        & 0.10369e+04_r8,0.78594e+03_r8,0.58779e+03_r8,0.86529e+03_r8,0.11432e+04_r8 /)
      kbo(:, 5,30, 9) = (/ &
        & 0.10367e+04_r8,0.78585e+03_r8,0.58673e+03_r8,0.86393e+03_r8,0.11414e+04_r8 /)
      kbo(:, 1,31, 9) = (/ &
        & 0.10367e+04_r8,0.78588e+03_r8,0.58971e+03_r8,0.86804e+03_r8,0.11468e+04_r8 /)
      kbo(:, 2,31, 9) = (/ &
        & 0.10365e+04_r8,0.78574e+03_r8,0.58919e+03_r8,0.86720e+03_r8,0.11457e+04_r8 /)
      kbo(:, 3,31, 9) = (/ &
        & 0.10364e+04_r8,0.78562e+03_r8,0.58847e+03_r8,0.86618e+03_r8,0.11443e+04_r8 /)
      kbo(:, 4,31, 9) = (/ &
        & 0.10363e+04_r8,0.78557e+03_r8,0.58752e+03_r8,0.86495e+03_r8,0.11427e+04_r8 /)
      kbo(:, 5,31, 9) = (/ &
        & 0.10362e+04_r8,0.78546e+03_r8,0.58644e+03_r8,0.86356e+03_r8,0.11409e+04_r8 /)
      kbo(:, 1,32, 9) = (/ &
        & 0.10362e+04_r8,0.78556e+03_r8,0.58958e+03_r8,0.86784e+03_r8,0.11466e+04_r8 /)
      kbo(:, 2,32, 9) = (/ &
        & 0.10361e+04_r8,0.78539e+03_r8,0.58901e+03_r8,0.86697e+03_r8,0.11454e+04_r8 /)
      kbo(:, 3,32, 9) = (/ &
        & 0.10360e+04_r8,0.78539e+03_r8,0.58824e+03_r8,0.86587e+03_r8,0.11440e+04_r8 /)
      kbo(:, 4,32, 9) = (/ &
        & 0.10359e+04_r8,0.78525e+03_r8,0.58724e+03_r8,0.86459e+03_r8,0.11423e+04_r8 /)
      kbo(:, 5,32, 9) = (/ &
        & 0.10358e+04_r8,0.78516e+03_r8,0.58615e+03_r8,0.86318e+03_r8,0.11404e+04_r8 /)
      kbo(:, 1,33, 9) = (/ &
        & 0.10358e+04_r8,0.78520e+03_r8,0.58945e+03_r8,0.86763e+03_r8,0.11463e+04_r8 /)
      kbo(:, 2,33, 9) = (/ &
        & 0.10357e+04_r8,0.78510e+03_r8,0.58883e+03_r8,0.86670e+03_r8,0.11450e+04_r8 /)
      kbo(:, 3,33, 9) = (/ &
        & 0.10356e+04_r8,0.78504e+03_r8,0.58799e+03_r8,0.86554e+03_r8,0.11435e+04_r8 /)
      kbo(:, 4,33, 9) = (/ &
        & 0.10356e+04_r8,0.78500e+03_r8,0.58695e+03_r8,0.86422e+03_r8,0.11418e+04_r8 /)
      kbo(:, 5,33, 9) = (/ &
        & 0.10355e+04_r8,0.78493e+03_r8,0.58586e+03_r8,0.86281e+03_r8,0.11399e+04_r8 /)
      kbo(:, 1,34, 9) = (/ &
        & 0.10355e+04_r8,0.78495e+03_r8,0.58932e+03_r8,0.86743e+03_r8,0.11460e+04_r8 /)
      kbo(:, 2,34, 9) = (/ &
        & 0.10354e+04_r8,0.78487e+03_r8,0.58865e+03_r8,0.86644e+03_r8,0.11447e+04_r8 /)
      kbo(:, 3,34, 9) = (/ &
        & 0.10354e+04_r8,0.78485e+03_r8,0.58776e+03_r8,0.86524e+03_r8,0.11432e+04_r8 /)
      kbo(:, 4,34, 9) = (/ &
        & 0.10353e+04_r8,0.78479e+03_r8,0.58670e+03_r8,0.86390e+03_r8,0.11414e+04_r8 /)
      kbo(:, 5,34, 9) = (/ &
        & 0.10352e+04_r8,0.78474e+03_r8,0.58560e+03_r8,0.86249e+03_r8,0.11395e+04_r8 /)
      kbo(:, 1,35, 9) = (/ &
        & 0.10352e+04_r8,0.78478e+03_r8,0.58924e+03_r8,0.86731e+03_r8,0.11459e+04_r8 /)
      kbo(:, 2,35, 9) = (/ &
        & 0.10352e+04_r8,0.78472e+03_r8,0.58855e+03_r8,0.86632e+03_r8,0.11445e+04_r8 /)
      kbo(:, 3,35, 9) = (/ &
        & 0.10351e+04_r8,0.78465e+03_r8,0.58761e+03_r8,0.86508e+03_r8,0.11430e+04_r8 /)
      kbo(:, 4,35, 9) = (/ &
        & 0.10350e+04_r8,0.78465e+03_r8,0.58655e+03_r8,0.86369e+03_r8,0.11412e+04_r8 /)
      kbo(:, 5,35, 9) = (/ &
        & 0.10350e+04_r8,0.78456e+03_r8,0.58545e+03_r8,0.86237e+03_r8,0.11393e+04_r8 /)
      kbo(:, 1,36, 9) = (/ &
        & 0.10350e+04_r8,0.78465e+03_r8,0.58922e+03_r8,0.86729e+03_r8,0.11458e+04_r8 /)
      kbo(:, 2,36, 9) = (/ &
        & 0.10350e+04_r8,0.78456e+03_r8,0.58852e+03_r8,0.86627e+03_r8,0.11445e+04_r8 /)
      kbo(:, 3,36, 9) = (/ &
        & 0.10350e+04_r8,0.78452e+03_r8,0.58759e+03_r8,0.86505e+03_r8,0.11429e+04_r8 /)
      kbo(:, 4,36, 9) = (/ &
        & 0.10349e+04_r8,0.78450e+03_r8,0.58651e+03_r8,0.86369e+03_r8,0.11411e+04_r8 /)
      kbo(:, 5,36, 9) = (/ &
        & 0.10348e+04_r8,0.78444e+03_r8,0.58544e+03_r8,0.86227e+03_r8,0.11392e+04_r8 /)
      kbo(:, 1,37, 9) = (/ &
        & 0.10349e+04_r8,0.78446e+03_r8,0.58930e+03_r8,0.86738e+03_r8,0.11460e+04_r8 /)
      kbo(:, 2,37, 9) = (/ &
        & 0.10348e+04_r8,0.78444e+03_r8,0.58863e+03_r8,0.86642e+03_r8,0.11447e+04_r8 /)
      kbo(:, 3,37, 9) = (/ &
        & 0.10348e+04_r8,0.78441e+03_r8,0.58773e+03_r8,0.86522e+03_r8,0.11432e+04_r8 /)
      kbo(:, 4,37, 9) = (/ &
        & 0.10348e+04_r8,0.78439e+03_r8,0.58667e+03_r8,0.86387e+03_r8,0.11414e+04_r8 /)
      kbo(:, 5,37, 9) = (/ &
        & 0.10347e+04_r8,0.78436e+03_r8,0.58559e+03_r8,0.86245e+03_r8,0.11394e+04_r8 /)
      kbo(:, 1,38, 9) = (/ &
        & 0.10348e+04_r8,0.78440e+03_r8,0.58936e+03_r8,0.86753e+03_r8,0.11462e+04_r8 /)
      kbo(:, 2,38, 9) = (/ &
        & 0.10347e+04_r8,0.78434e+03_r8,0.58873e+03_r8,0.86658e+03_r8,0.11449e+04_r8 /)
      kbo(:, 3,38, 9) = (/ &
        & 0.10347e+04_r8,0.78432e+03_r8,0.58786e+03_r8,0.86537e+03_r8,0.11434e+04_r8 /)
      kbo(:, 4,38, 9) = (/ &
        & 0.10346e+04_r8,0.78431e+03_r8,0.58681e+03_r8,0.86407e+03_r8,0.11416e+04_r8 /)
      kbo(:, 5,38, 9) = (/ &
        & 0.10347e+04_r8,0.78428e+03_r8,0.58573e+03_r8,0.86265e+03_r8,0.11397e+04_r8 /)
      kbo(:, 1,39, 9) = (/ &
        & 0.10347e+04_r8,0.78431e+03_r8,0.58943e+03_r8,0.86764e+03_r8,0.11463e+04_r8 /)
      kbo(:, 2,39, 9) = (/ &
        & 0.10346e+04_r8,0.78431e+03_r8,0.58882e+03_r8,0.86672e+03_r8,0.11451e+04_r8 /)
      kbo(:, 3,39, 9) = (/ &
        & 0.10346e+04_r8,0.78424e+03_r8,0.58800e+03_r8,0.86557e+03_r8,0.11436e+04_r8 /)
      kbo(:, 4,39, 9) = (/ &
        & 0.10346e+04_r8,0.78421e+03_r8,0.58697e+03_r8,0.86426e+03_r8,0.11419e+04_r8 /)
      kbo(:, 5,39, 9) = (/ &
        & 0.10346e+04_r8,0.78429e+03_r8,0.58587e+03_r8,0.86284e+03_r8,0.11400e+04_r8 /)
      kbo(:, 1,40, 9) = (/ &
        & 0.10346e+04_r8,0.78426e+03_r8,0.58957e+03_r8,0.86785e+03_r8,0.11466e+04_r8 /)
      kbo(:, 2,40, 9) = (/ &
        & 0.10345e+04_r8,0.78427e+03_r8,0.58899e+03_r8,0.86697e+03_r8,0.11454e+04_r8 /)
      kbo(:, 3,40, 9) = (/ &
        & 0.10345e+04_r8,0.78422e+03_r8,0.58822e+03_r8,0.86585e+03_r8,0.11440e+04_r8 /)
      kbo(:, 4,40, 9) = (/ &
        & 0.10345e+04_r8,0.78421e+03_r8,0.58723e+03_r8,0.86460e+03_r8,0.11423e+04_r8 /)
      kbo(:, 5,40, 9) = (/ &
        & 0.10344e+04_r8,0.78416e+03_r8,0.58614e+03_r8,0.86319e+03_r8,0.11403e+04_r8 /)
      kbo(:, 1,41, 9) = (/ &
        & 0.10345e+04_r8,0.78421e+03_r8,0.58967e+03_r8,0.86804e+03_r8,0.11468e+04_r8 /)
      kbo(:, 2,41, 9) = (/ &
        & 0.10345e+04_r8,0.78418e+03_r8,0.58916e+03_r8,0.86720e+03_r8,0.11457e+04_r8 /)
      kbo(:, 3,41, 9) = (/ &
        & 0.10344e+04_r8,0.78415e+03_r8,0.58844e+03_r8,0.86618e+03_r8,0.11444e+04_r8 /)
      kbo(:, 4,41, 9) = (/ &
        & 0.10344e+04_r8,0.78413e+03_r8,0.58748e+03_r8,0.86492e+03_r8,0.11428e+04_r8 /)
      kbo(:, 5,41, 9) = (/ &
        & 0.10344e+04_r8,0.78411e+03_r8,0.58642e+03_r8,0.86355e+03_r8,0.11409e+04_r8 /)
      kbo(:, 1,42, 9) = (/ &
        & 0.10345e+04_r8,0.78414e+03_r8,0.58976e+03_r8,0.86830e+03_r8,0.11471e+04_r8 /)
      kbo(:, 2,42, 9) = (/ &
        & 0.10344e+04_r8,0.78417e+03_r8,0.58930e+03_r8,0.86744e+03_r8,0.11460e+04_r8 /)
      kbo(:, 3,42, 9) = (/ &
        & 0.10344e+04_r8,0.78411e+03_r8,0.58863e+03_r8,0.86645e+03_r8,0.11448e+04_r8 /)
      kbo(:, 4,42, 9) = (/ &
        & 0.10344e+04_r8,0.78409e+03_r8,0.58775e+03_r8,0.86525e+03_r8,0.11432e+04_r8 /)
      kbo(:, 5,42, 9) = (/ &
        & 0.10344e+04_r8,0.78408e+03_r8,0.58670e+03_r8,0.86391e+03_r8,0.11414e+04_r8 /)
      kbo(:, 1,43, 9) = (/ &
        & 0.10344e+04_r8,0.78410e+03_r8,0.58987e+03_r8,0.86842e+03_r8,0.11473e+04_r8 /)
      kbo(:, 2,43, 9) = (/ &
        & 0.10344e+04_r8,0.78408e+03_r8,0.58947e+03_r8,0.86769e+03_r8,0.11464e+04_r8 /)
      kbo(:, 3,43, 9) = (/ &
        & 0.10344e+04_r8,0.78409e+03_r8,0.58887e+03_r8,0.86678e+03_r8,0.11452e+04_r8 /)
      kbo(:, 4,43, 9) = (/ &
        & 0.10344e+04_r8,0.78410e+03_r8,0.58806e+03_r8,0.86567e+03_r8,0.11437e+04_r8 /)
      kbo(:, 5,43, 9) = (/ &
        & 0.10343e+04_r8,0.78406e+03_r8,0.58704e+03_r8,0.86435e+03_r8,0.11420e+04_r8 /)
      kbo(:, 1,44, 9) = (/ &
        & 0.10344e+04_r8,0.78409e+03_r8,0.58998e+03_r8,0.86862e+03_r8,0.11476e+04_r8 /)
      kbo(:, 2,44, 9) = (/ &
        & 0.10343e+04_r8,0.78407e+03_r8,0.58962e+03_r8,0.86796e+03_r8,0.11467e+04_r8 /)
      kbo(:, 3,44, 9) = (/ &
        & 0.10343e+04_r8,0.78406e+03_r8,0.58910e+03_r8,0.86711e+03_r8,0.11456e+04_r8 /)
      kbo(:, 4,44, 9) = (/ &
        & 0.10343e+04_r8,0.78403e+03_r8,0.58835e+03_r8,0.86607e+03_r8,0.11442e+04_r8 /)
      kbo(:, 5,44, 9) = (/ &
        & 0.10343e+04_r8,0.78403e+03_r8,0.58738e+03_r8,0.86483e+03_r8,0.11426e+04_r8 /)
      kbo(:, 1,45, 9) = (/ &
        & 0.10343e+04_r8,0.78404e+03_r8,0.59009e+03_r8,0.86881e+03_r8,0.11478e+04_r8 /)
      kbo(:, 2,45, 9) = (/ &
        & 0.10343e+04_r8,0.78405e+03_r8,0.58975e+03_r8,0.86821e+03_r8,0.11471e+04_r8 /)
      kbo(:, 3,45, 9) = (/ &
        & 0.10343e+04_r8,0.78404e+03_r8,0.58930e+03_r8,0.86741e+03_r8,0.11460e+04_r8 /)
      kbo(:, 4,45, 9) = (/ &
        & 0.10342e+04_r8,0.78400e+03_r8,0.58862e+03_r8,0.86644e+03_r8,0.11447e+04_r8 /)
      kbo(:, 5,45, 9) = (/ &
        & 0.10343e+04_r8,0.78402e+03_r8,0.58769e+03_r8,0.86520e+03_r8,0.11432e+04_r8 /)
      kbo(:, 1,46, 9) = (/ &
        & 0.10343e+04_r8,0.78403e+03_r8,0.59019e+03_r8,0.86899e+03_r8,0.11481e+04_r8 /)
      kbo(:, 2,46, 9) = (/ &
        & 0.10343e+04_r8,0.78403e+03_r8,0.58989e+03_r8,0.86845e+03_r8,0.11474e+04_r8 /)
      kbo(:, 3,46, 9) = (/ &
        & 0.10343e+04_r8,0.78403e+03_r8,0.58947e+03_r8,0.86773e+03_r8,0.11464e+04_r8 /)
      kbo(:, 4,46, 9) = (/ &
        & 0.10342e+04_r8,0.78401e+03_r8,0.58890e+03_r8,0.86681e+03_r8,0.11452e+04_r8 /)
      kbo(:, 5,46, 9) = (/ &
        & 0.10343e+04_r8,0.78405e+03_r8,0.58808e+03_r8,0.86568e+03_r8,0.11438e+04_r8 /)
      kbo(:, 1,47, 9) = (/ &
        & 0.10343e+04_r8,0.78401e+03_r8,0.59032e+03_r8,0.86917e+03_r8,0.11483e+04_r8 /)
      kbo(:, 2,47, 9) = (/ &
        & 0.10342e+04_r8,0.78398e+03_r8,0.59001e+03_r8,0.86868e+03_r8,0.11477e+04_r8 /)
      kbo(:, 3,47, 9) = (/ &
        & 0.10342e+04_r8,0.78398e+03_r8,0.58967e+03_r8,0.86807e+03_r8,0.11468e+04_r8 /)
      kbo(:, 4,47, 9) = (/ &
        & 0.10343e+04_r8,0.78397e+03_r8,0.58916e+03_r8,0.86720e+03_r8,0.11457e+04_r8 /)
      kbo(:, 5,47, 9) = (/ &
        & 0.10342e+04_r8,0.78399e+03_r8,0.58844e+03_r8,0.86618e+03_r8,0.11444e+04_r8 /)
      kbo(:, 1,48, 9) = (/ &
        & 0.10342e+04_r8,0.78399e+03_r8,0.59046e+03_r8,0.86932e+03_r8,0.11485e+04_r8 /)
      kbo(:, 2,48, 9) = (/ &
        & 0.10343e+04_r8,0.78398e+03_r8,0.59013e+03_r8,0.86890e+03_r8,0.11480e+04_r8 /)
      kbo(:, 3,48, 9) = (/ &
        & 0.10342e+04_r8,0.78402e+03_r8,0.58982e+03_r8,0.86829e+03_r8,0.11472e+04_r8 /)
      kbo(:, 4,48, 9) = (/ &
        & 0.10342e+04_r8,0.78396e+03_r8,0.58938e+03_r8,0.86756e+03_r8,0.11462e+04_r8 /)
      kbo(:, 5,48, 9) = (/ &
        & 0.10342e+04_r8,0.78400e+03_r8,0.58875e+03_r8,0.86661e+03_r8,0.11449e+04_r8 /)
      kbo(:, 1,49, 9) = (/ &
        & 0.10343e+04_r8,0.78402e+03_r8,0.59060e+03_r8,0.86945e+03_r8,0.11486e+04_r8 /)
      kbo(:, 2,49, 9) = (/ &
        & 0.10342e+04_r8,0.78398e+03_r8,0.59025e+03_r8,0.86908e+03_r8,0.11482e+04_r8 /)
      kbo(:, 3,49, 9) = (/ &
        & 0.10342e+04_r8,0.78399e+03_r8,0.58995e+03_r8,0.86856e+03_r8,0.11475e+04_r8 /)
      kbo(:, 4,49, 9) = (/ &
        & 0.10342e+04_r8,0.78399e+03_r8,0.58958e+03_r8,0.86790e+03_r8,0.11466e+04_r8 /)
      kbo(:, 5,49, 9) = (/ &
        & 0.10342e+04_r8,0.78398e+03_r8,0.58903e+03_r8,0.86700e+03_r8,0.11455e+04_r8 /)
      kbo(:, 1,50, 9) = (/ &
        & 0.10343e+04_r8,0.78395e+03_r8,0.59074e+03_r8,0.86956e+03_r8,0.11487e+04_r8 /)
      kbo(:, 2,50, 9) = (/ &
        & 0.10342e+04_r8,0.78399e+03_r8,0.59038e+03_r8,0.86924e+03_r8,0.11483e+04_r8 /)
      kbo(:, 3,50, 9) = (/ &
        & 0.10342e+04_r8,0.78394e+03_r8,0.59006e+03_r8,0.86878e+03_r8,0.11478e+04_r8 /)
      kbo(:, 4,50, 9) = (/ &
        & 0.10342e+04_r8,0.78399e+03_r8,0.58974e+03_r8,0.86817e+03_r8,0.11470e+04_r8 /)
      kbo(:, 5,50, 9) = (/ &
        & 0.10342e+04_r8,0.78395e+03_r8,0.58927e+03_r8,0.86736e+03_r8,0.11460e+04_r8 /)
      kbo(:, 1,51, 9) = (/ &
        & 0.10342e+04_r8,0.78399e+03_r8,0.59088e+03_r8,0.86965e+03_r8,0.11488e+04_r8 /)
      kbo(:, 2,51, 9) = (/ &
        & 0.10342e+04_r8,0.78393e+03_r8,0.59051e+03_r8,0.86937e+03_r8,0.11485e+04_r8 /)
      kbo(:, 3,51, 9) = (/ &
        & 0.10342e+04_r8,0.78400e+03_r8,0.59018e+03_r8,0.86897e+03_r8,0.11480e+04_r8 /)
      kbo(:, 4,51, 9) = (/ &
        & 0.10342e+04_r8,0.78396e+03_r8,0.58987e+03_r8,0.86840e+03_r8,0.11473e+04_r8 /)
      kbo(:, 5,51, 9) = (/ &
        & 0.10342e+04_r8,0.78396e+03_r8,0.58946e+03_r8,0.86768e+03_r8,0.11464e+04_r8 /)
      kbo(:, 1,52, 9) = (/ &
        & 0.10342e+04_r8,0.78395e+03_r8,0.59100e+03_r8,0.86971e+03_r8,0.11490e+04_r8 /)
      kbo(:, 2,52, 9) = (/ &
        & 0.10342e+04_r8,0.78394e+03_r8,0.59064e+03_r8,0.86949e+03_r8,0.11486e+04_r8 /)
      kbo(:, 3,52, 9) = (/ &
        & 0.10342e+04_r8,0.78395e+03_r8,0.59029e+03_r8,0.86915e+03_r8,0.11482e+04_r8 /)
      kbo(:, 4,52, 9) = (/ &
        & 0.10342e+04_r8,0.78394e+03_r8,0.58998e+03_r8,0.86864e+03_r8,0.11476e+04_r8 /)
      kbo(:, 5,52, 9) = (/ &
        & 0.10342e+04_r8,0.78395e+03_r8,0.58963e+03_r8,0.86796e+03_r8,0.11468e+04_r8 /)
      kbo(:, 1,53, 9) = (/ &
        & 0.10342e+04_r8,0.78397e+03_r8,0.59111e+03_r8,0.86975e+03_r8,0.11490e+04_r8 /)
      kbo(:, 2,53, 9) = (/ &
        & 0.10342e+04_r8,0.78394e+03_r8,0.59078e+03_r8,0.86960e+03_r8,0.11488e+04_r8 /)
      kbo(:, 3,53, 9) = (/ &
        & 0.10342e+04_r8,0.78396e+03_r8,0.59041e+03_r8,0.86926e+03_r8,0.11484e+04_r8 /)
      kbo(:, 4,53, 9) = (/ &
        & 0.10341e+04_r8,0.78393e+03_r8,0.59010e+03_r8,0.86884e+03_r8,0.11479e+04_r8 /)
      kbo(:, 5,53, 9) = (/ &
        & 0.10342e+04_r8,0.78395e+03_r8,0.58977e+03_r8,0.86822e+03_r8,0.11471e+04_r8 /)
      kbo(:, 1,54, 9) = (/ &
        & 0.10343e+04_r8,0.78394e+03_r8,0.59121e+03_r8,0.86979e+03_r8,0.11491e+04_r8 /)
      kbo(:, 2,54, 9) = (/ &
        & 0.10341e+04_r8,0.78399e+03_r8,0.59088e+03_r8,0.86966e+03_r8,0.11489e+04_r8 /)
      kbo(:, 3,54, 9) = (/ &
        & 0.10341e+04_r8,0.78394e+03_r8,0.59052e+03_r8,0.86939e+03_r8,0.11485e+04_r8 /)
      kbo(:, 4,54, 9) = (/ &
        & 0.10341e+04_r8,0.78394e+03_r8,0.59020e+03_r8,0.86900e+03_r8,0.11481e+04_r8 /)
      kbo(:, 5,54, 9) = (/ &
        & 0.10342e+04_r8,0.78395e+03_r8,0.58987e+03_r8,0.86845e+03_r8,0.11474e+04_r8 /)
      kbo(:, 1,55, 9) = (/ &
        & 0.10342e+04_r8,0.78396e+03_r8,0.59130e+03_r8,0.86983e+03_r8,0.11491e+04_r8 /)
      kbo(:, 2,55, 9) = (/ &
        & 0.10341e+04_r8,0.78393e+03_r8,0.59100e+03_r8,0.86971e+03_r8,0.11490e+04_r8 /)
      kbo(:, 3,55, 9) = (/ &
        & 0.10342e+04_r8,0.78393e+03_r8,0.59065e+03_r8,0.86949e+03_r8,0.11486e+04_r8 /)
      kbo(:, 4,55, 9) = (/ &
        & 0.10342e+04_r8,0.78395e+03_r8,0.59029e+03_r8,0.86914e+03_r8,0.11483e+04_r8 /)
      kbo(:, 5,55, 9) = (/ &
        & 0.10341e+04_r8,0.78393e+03_r8,0.59000e+03_r8,0.86864e+03_r8,0.11477e+04_r8 /)
      kbo(:, 1,56, 9) = (/ &
        & 0.10342e+04_r8,0.78393e+03_r8,0.59137e+03_r8,0.86987e+03_r8,0.11492e+04_r8 /)
      kbo(:, 2,56, 9) = (/ &
        & 0.10342e+04_r8,0.78395e+03_r8,0.59111e+03_r8,0.86975e+03_r8,0.11490e+04_r8 /)
      kbo(:, 3,56, 9) = (/ &
        & 0.10342e+04_r8,0.78392e+03_r8,0.59077e+03_r8,0.86958e+03_r8,0.11488e+04_r8 /)
      kbo(:, 4,56, 9) = (/ &
        & 0.10342e+04_r8,0.78393e+03_r8,0.59040e+03_r8,0.86926e+03_r8,0.11484e+04_r8 /)
      kbo(:, 5,56, 9) = (/ &
        & 0.10341e+04_r8,0.78393e+03_r8,0.59009e+03_r8,0.86883e+03_r8,0.11479e+04_r8 /)
      kbo(:, 1,57, 9) = (/ &
        & 0.10342e+04_r8,0.78396e+03_r8,0.59143e+03_r8,0.86993e+03_r8,0.11492e+04_r8 /)
      kbo(:, 2,57, 9) = (/ &
        & 0.10342e+04_r8,0.78392e+03_r8,0.59122e+03_r8,0.86979e+03_r8,0.11491e+04_r8 /)
      kbo(:, 3,57, 9) = (/ &
        & 0.10342e+04_r8,0.78392e+03_r8,0.59089e+03_r8,0.86966e+03_r8,0.11489e+04_r8 /)
      kbo(:, 4,57, 9) = (/ &
        & 0.10341e+04_r8,0.78395e+03_r8,0.59052e+03_r8,0.86938e+03_r8,0.11485e+04_r8 /)
      kbo(:, 5,57, 9) = (/ &
        & 0.10341e+04_r8,0.78393e+03_r8,0.59018e+03_r8,0.86897e+03_r8,0.11481e+04_r8 /)
      kbo(:, 1,58, 9) = (/ &
        & 0.10341e+04_r8,0.78395e+03_r8,0.59147e+03_r8,0.86996e+03_r8,0.11493e+04_r8 /)
      kbo(:, 2,58, 9) = (/ &
        & 0.10341e+04_r8,0.78397e+03_r8,0.59129e+03_r8,0.86982e+03_r8,0.11491e+04_r8 /)
      kbo(:, 3,58, 9) = (/ &
        & 0.10341e+04_r8,0.78393e+03_r8,0.59099e+03_r8,0.86970e+03_r8,0.11489e+04_r8 /)
      kbo(:, 4,58, 9) = (/ &
        & 0.10342e+04_r8,0.78397e+03_r8,0.59063e+03_r8,0.86948e+03_r8,0.11486e+04_r8 /)
      kbo(:, 5,58, 9) = (/ &
        & 0.10342e+04_r8,0.78390e+03_r8,0.59028e+03_r8,0.86913e+03_r8,0.11482e+04_r8 /)
      kbo(:, 1,59, 9) = (/ &
        & 0.10342e+04_r8,0.78393e+03_r8,0.59148e+03_r8,0.86998e+03_r8,0.11494e+04_r8 /)
      kbo(:, 2,59, 9) = (/ &
        & 0.10342e+04_r8,0.78396e+03_r8,0.59132e+03_r8,0.86982e+03_r8,0.11492e+04_r8 /)
      kbo(:, 3,59, 9) = (/ &
        & 0.10342e+04_r8,0.78393e+03_r8,0.59103e+03_r8,0.86972e+03_r8,0.11490e+04_r8 /)
      kbo(:, 4,59, 9) = (/ &
        & 0.10341e+04_r8,0.78394e+03_r8,0.59067e+03_r8,0.86951e+03_r8,0.11487e+04_r8 /)
      kbo(:, 5,59, 9) = (/ &
        & 0.10341e+04_r8,0.78397e+03_r8,0.59032e+03_r8,0.86918e+03_r8,0.11483e+04_r8 /)
      kbo(:, 1,13,10) = (/ &
        & 0.11544e+04_r8,0.87486e+03_r8,0.59975e+03_r8,0.88029e+03_r8,0.11631e+04_r8 /)
      kbo(:, 2,13,10) = (/ &
        & 0.11458e+04_r8,0.86752e+03_r8,0.59921e+03_r8,0.87889e+03_r8,0.11611e+04_r8 /)
      kbo(:, 3,13,10) = (/ &
        & 0.11380e+04_r8,0.86177e+03_r8,0.59836e+03_r8,0.87789e+03_r8,0.11592e+04_r8 /)
      kbo(:, 4,13,10) = (/ &
        & 0.11310e+04_r8,0.85697e+03_r8,0.59745e+03_r8,0.87697e+03_r8,0.11577e+04_r8 /)
      kbo(:, 5,13,10) = (/ &
        & 0.11259e+04_r8,0.85279e+03_r8,0.59663e+03_r8,0.87606e+03_r8,0.11564e+04_r8 /)
      kbo(:, 1,14,10) = (/ &
        & 0.11329e+04_r8,0.85757e+03_r8,0.59935e+03_r8,0.88000e+03_r8,0.11630e+04_r8 /)
      kbo(:, 2,14,10) = (/ &
        & 0.11257e+04_r8,0.85228e+03_r8,0.59878e+03_r8,0.87841e+03_r8,0.11609e+04_r8 /)
      kbo(:, 3,14,10) = (/ &
        & 0.11201e+04_r8,0.84731e+03_r8,0.59797e+03_r8,0.87766e+03_r8,0.11591e+04_r8 /)
      kbo(:, 4,14,10) = (/ &
        & 0.11140e+04_r8,0.84389e+03_r8,0.59731e+03_r8,0.87707e+03_r8,0.11577e+04_r8 /)
      kbo(:, 5,14,10) = (/ &
        & 0.11094e+04_r8,0.84001e+03_r8,0.59642e+03_r8,0.87571e+03_r8,0.11561e+04_r8 /)
      kbo(:, 1,15,10) = (/ &
        & 0.11142e+04_r8,0.84370e+03_r8,0.59900e+03_r8,0.87973e+03_r8,0.11627e+04_r8 /)
      kbo(:, 2,15,10) = (/ &
        & 0.11097e+04_r8,0.84029e+03_r8,0.59841e+03_r8,0.87827e+03_r8,0.11607e+04_r8 /)
      kbo(:, 3,15,10) = (/ &
        & 0.11039e+04_r8,0.83570e+03_r8,0.59763e+03_r8,0.87745e+03_r8,0.11587e+04_r8 /)
      kbo(:, 4,15,10) = (/ &
        & 0.10995e+04_r8,0.83295e+03_r8,0.59685e+03_r8,0.87664e+03_r8,0.11574e+04_r8 /)
      kbo(:, 5,15,10) = (/ &
        & 0.10956e+04_r8,0.82966e+03_r8,0.59611e+03_r8,0.87548e+03_r8,0.11555e+04_r8 /)
      kbo(:, 1,16,10) = (/ &
        & 0.11006e+04_r8,0.83290e+03_r8,0.59871e+03_r8,0.87947e+03_r8,0.11625e+04_r8 /)
      kbo(:, 2,16,10) = (/ &
        & 0.10967e+04_r8,0.82960e+03_r8,0.59809e+03_r8,0.87696e+03_r8,0.11605e+04_r8 /)
      kbo(:, 3,16,10) = (/ &
        & 0.10908e+04_r8,0.82627e+03_r8,0.59735e+03_r8,0.87716e+03_r8,0.11587e+04_r8 /)
      kbo(:, 4,16,10) = (/ &
        & 0.10878e+04_r8,0.82496e+03_r8,0.59665e+03_r8,0.87645e+03_r8,0.11573e+04_r8 /)
      kbo(:, 5,16,10) = (/ &
        & 0.10846e+04_r8,0.82140e+03_r8,0.59584e+03_r8,0.87537e+03_r8,0.11556e+04_r8 /)
      kbo(:, 1,17,10) = (/ &
        & 0.10872e+04_r8,0.82399e+03_r8,0.59847e+03_r8,0.87912e+03_r8,0.11623e+04_r8 /)
      kbo(:, 2,17,10) = (/ &
        & 0.10836e+04_r8,0.82137e+03_r8,0.59782e+03_r8,0.87785e+03_r8,0.11604e+04_r8 /)
      kbo(:, 3,17,10) = (/ &
        & 0.10806e+04_r8,0.81903e+03_r8,0.59710e+03_r8,0.87700e+03_r8,0.11586e+04_r8 /)
      kbo(:, 4,17,10) = (/ &
        & 0.10781e+04_r8,0.81649e+03_r8,0.59641e+03_r8,0.87627e+03_r8,0.11571e+04_r8 /)
      kbo(:, 5,17,10) = (/ &
        & 0.10750e+04_r8,0.81461e+03_r8,0.59560e+03_r8,0.87517e+03_r8,0.11554e+04_r8 /)
      kbo(:, 1,18,10) = (/ &
        & 0.10783e+04_r8,0.81627e+03_r8,0.59826e+03_r8,0.87902e+03_r8,0.11620e+04_r8 /)
      kbo(:, 2,18,10) = (/ &
        & 0.10752e+04_r8,0.81450e+03_r8,0.59759e+03_r8,0.87778e+03_r8,0.11602e+04_r8 /)
      kbo(:, 3,18,10) = (/ &
        & 0.10718e+04_r8,0.81284e+03_r8,0.59689e+03_r8,0.87707e+03_r8,0.11584e+04_r8 /)
      kbo(:, 4,18,10) = (/ &
        & 0.10695e+04_r8,0.81051e+03_r8,0.59620e+03_r8,0.87578e+03_r8,0.11570e+04_r8 /)
      kbo(:, 5,18,10) = (/ &
        & 0.10675e+04_r8,0.80859e+03_r8,0.59539e+03_r8,0.87498e+03_r8,0.11554e+04_r8 /)
      kbo(:, 1,19,10) = (/ &
        & 0.10693e+04_r8,0.81014e+03_r8,0.59808e+03_r8,0.87871e+03_r8,0.11618e+04_r8 /)
      kbo(:, 2,19,10) = (/ &
        & 0.10674e+04_r8,0.80961e+03_r8,0.59739e+03_r8,0.87763e+03_r8,0.11601e+04_r8 /)
      kbo(:, 3,19,10) = (/ &
        & 0.10651e+04_r8,0.80782e+03_r8,0.59664e+03_r8,0.87683e+03_r8,0.11582e+04_r8 /)
      kbo(:, 4,19,10) = (/ &
        & 0.10639e+04_r8,0.80562e+03_r8,0.59610e+03_r8,0.87595e+03_r8,0.11569e+04_r8 /)
      kbo(:, 5,19,10) = (/ &
        & 0.10620e+04_r8,0.80440e+03_r8,0.59520e+03_r8,0.87481e+03_r8,0.11551e+04_r8 /)
      kbo(:, 1,20,10) = (/ &
        & 0.10633e+04_r8,0.80580e+03_r8,0.59791e+03_r8,0.87862e+03_r8,0.11616e+04_r8 /)
      kbo(:, 2,20,10) = (/ &
        & 0.10619e+04_r8,0.80442e+03_r8,0.59720e+03_r8,0.87747e+03_r8,0.11598e+04_r8 /)
      kbo(:, 3,20,10) = (/ &
        & 0.10607e+04_r8,0.80344e+03_r8,0.59654e+03_r8,0.87680e+03_r8,0.11581e+04_r8 /)
      kbo(:, 4,20,10) = (/ &
        & 0.10584e+04_r8,0.80182e+03_r8,0.59585e+03_r8,0.87568e+03_r8,0.11568e+04_r8 /)
      kbo(:, 5,20,10) = (/ &
        & 0.10568e+04_r8,0.80142e+03_r8,0.59502e+03_r8,0.87461e+03_r8,0.11549e+04_r8 /)
      kbo(:, 1,21,10) = (/ &
        & 0.10577e+04_r8,0.80247e+03_r8,0.59775e+03_r8,0.87831e+03_r8,0.11614e+04_r8 /)
      kbo(:, 2,21,10) = (/ &
        & 0.10572e+04_r8,0.80108e+03_r8,0.59703e+03_r8,0.87733e+03_r8,0.11595e+04_r8 /)
      kbo(:, 3,21,10) = (/ &
        & 0.10551e+04_r8,0.79955e+03_r8,0.59639e+03_r8,0.87689e+03_r8,0.11579e+04_r8 /)
      kbo(:, 4,21,10) = (/ &
        & 0.10548e+04_r8,0.79914e+03_r8,0.59569e+03_r8,0.87563e+03_r8,0.11565e+04_r8 /)
      kbo(:, 5,21,10) = (/ &
        & 0.10533e+04_r8,0.79794e+03_r8,0.59484e+03_r8,0.87454e+03_r8,0.11546e+04_r8 /)
      kbo(:, 1,22,10) = (/ &
        & 0.10544e+04_r8,0.79901e+03_r8,0.59755e+03_r8,0.87816e+03_r8,0.11610e+04_r8 /)
      kbo(:, 2,22,10) = (/ &
        & 0.10524e+04_r8,0.79865e+03_r8,0.59692e+03_r8,0.87715e+03_r8,0.11592e+04_r8 /)
      kbo(:, 3,22,10) = (/ &
        & 0.10518e+04_r8,0.79733e+03_r8,0.59621e+03_r8,0.87638e+03_r8,0.11576e+04_r8 /)
      kbo(:, 4,22,10) = (/ &
        & 0.10503e+04_r8,0.79602e+03_r8,0.59549e+03_r8,0.87540e+03_r8,0.11562e+04_r8 /)
      kbo(:, 5,22,10) = (/ &
        & 0.10497e+04_r8,0.79577e+03_r8,0.59455e+03_r8,0.87415e+03_r8,0.11542e+04_r8 /)
      kbo(:, 1,23,10) = (/ &
        & 0.10504e+04_r8,0.79618e+03_r8,0.59736e+03_r8,0.87790e+03_r8,0.11608e+04_r8 /)
      kbo(:, 2,23,10) = (/ &
        & 0.10488e+04_r8,0.79542e+03_r8,0.59652e+03_r8,0.87687e+03_r8,0.11588e+04_r8 /)
      kbo(:, 3,23,10) = (/ &
        & 0.10489e+04_r8,0.79466e+03_r8,0.59603e+03_r8,0.87619e+03_r8,0.11574e+04_r8 /)
      kbo(:, 4,23,10) = (/ &
        & 0.10477e+04_r8,0.79399e+03_r8,0.59528e+03_r8,0.87505e+03_r8,0.11559e+04_r8 /)
      kbo(:, 5,23,10) = (/ &
        & 0.10468e+04_r8,0.79357e+03_r8,0.59440e+03_r8,0.87388e+03_r8,0.11537e+04_r8 /)
      kbo(:, 1,24,10) = (/ &
        & 0.10475e+04_r8,0.79355e+03_r8,0.59716e+03_r8,0.87766e+03_r8,0.11603e+04_r8 /)
      kbo(:, 2,24,10) = (/ &
        & 0.10471e+04_r8,0.79325e+03_r8,0.59650e+03_r8,0.87681e+03_r8,0.11585e+04_r8 /)
      kbo(:, 3,24,10) = (/ &
        & 0.10463e+04_r8,0.79243e+03_r8,0.59586e+03_r8,0.87587e+03_r8,0.11571e+04_r8 /)
      kbo(:, 4,24,10) = (/ &
        & 0.10454e+04_r8,0.79206e+03_r8,0.59508e+03_r8,0.87468e+03_r8,0.11555e+04_r8 /)
      kbo(:, 5,24,10) = (/ &
        & 0.10455e+04_r8,0.79146e+03_r8,0.59426e+03_r8,0.87360e+03_r8,0.11532e+04_r8 /)
      kbo(:, 1,25,10) = (/ &
        & 0.10443e+04_r8,0.79222e+03_r8,0.59698e+03_r8,0.87742e+03_r8,0.11598e+04_r8 /)
      kbo(:, 2,25,10) = (/ &
        & 0.10446e+04_r8,0.79165e+03_r8,0.59633e+03_r8,0.87696e+03_r8,0.11582e+04_r8 /)
      kbo(:, 3,25,10) = (/ &
        & 0.10440e+04_r8,0.79123e+03_r8,0.59567e+03_r8,0.87565e+03_r8,0.11568e+04_r8 /)
      kbo(:, 4,25,10) = (/ &
        & 0.10433e+04_r8,0.79106e+03_r8,0.59487e+03_r8,0.87451e+03_r8,0.11551e+04_r8 /)
      kbo(:, 5,25,10) = (/ &
        & 0.10423e+04_r8,0.79063e+03_r8,0.59375e+03_r8,0.87329e+03_r8,0.11525e+04_r8 /)
      kbo(:, 1,26,10) = (/ &
        & 0.10431e+04_r8,0.79112e+03_r8,0.59671e+03_r8,0.87720e+03_r8,0.11595e+04_r8 /)
      kbo(:, 2,26,10) = (/ &
        & 0.10430e+04_r8,0.79016e+03_r8,0.59608e+03_r8,0.87633e+03_r8,0.11579e+04_r8 /)
      kbo(:, 3,26,10) = (/ &
        & 0.10422e+04_r8,0.78992e+03_r8,0.59547e+03_r8,0.87551e+03_r8,0.11565e+04_r8 /)
      kbo(:, 4,26,10) = (/ &
        & 0.10418e+04_r8,0.78943e+03_r8,0.59456e+03_r8,0.87419e+03_r8,0.11545e+04_r8 /)
      kbo(:, 5,26,10) = (/ &
        & 0.10417e+04_r8,0.78966e+03_r8,0.59375e+03_r8,0.87285e+03_r8,0.11523e+04_r8 /)
      kbo(:, 1,27,10) = (/ &
        & 0.10421e+04_r8,0.78970e+03_r8,0.59653e+03_r8,0.87700e+03_r8,0.11589e+04_r8 /)
      kbo(:, 2,27,10) = (/ &
        & 0.10419e+04_r8,0.78911e+03_r8,0.59591e+03_r8,0.87623e+03_r8,0.11575e+04_r8 /)
      kbo(:, 3,27,10) = (/ &
        & 0.10414e+04_r8,0.78914e+03_r8,0.59527e+03_r8,0.87524e+03_r8,0.11555e+04_r8 /)
      kbo(:, 4,27,10) = (/ &
        & 0.10412e+04_r8,0.78891e+03_r8,0.59440e+03_r8,0.87398e+03_r8,0.11540e+04_r8 /)
      kbo(:, 5,27,10) = (/ &
        & 0.10400e+04_r8,0.78850e+03_r8,0.59354e+03_r8,0.87262e+03_r8,0.11516e+04_r8 /)
      kbo(:, 1,28,10) = (/ &
        & 0.10402e+04_r8,0.78860e+03_r8,0.59644e+03_r8,0.87682e+03_r8,0.11586e+04_r8 /)
      kbo(:, 2,28,10) = (/ &
        & 0.10405e+04_r8,0.78788e+03_r8,0.59574e+03_r8,0.87579e+03_r8,0.11571e+04_r8 /)
      kbo(:, 3,28,10) = (/ &
        & 0.10403e+04_r8,0.78855e+03_r8,0.59498e+03_r8,0.87473e+03_r8,0.11552e+04_r8 /)
      kbo(:, 4,28,10) = (/ &
        & 0.10397e+04_r8,0.78826e+03_r8,0.59417e+03_r8,0.87377e+03_r8,0.11534e+04_r8 /)
      kbo(:, 5,28,10) = (/ &
        & 0.10396e+04_r8,0.78810e+03_r8,0.59333e+03_r8,0.87227e+03_r8,0.11511e+04_r8 /)
      kbo(:, 1,29,10) = (/ &
        & 0.10391e+04_r8,0.78797e+03_r8,0.59612e+03_r8,0.87685e+03_r8,0.11584e+04_r8 /)
      kbo(:, 2,29,10) = (/ &
        & 0.10393e+04_r8,0.78808e+03_r8,0.59562e+03_r8,0.87577e+03_r8,0.11569e+04_r8 /)
      kbo(:, 3,29,10) = (/ &
        & 0.10401e+04_r8,0.78791e+03_r8,0.59476e+03_r8,0.87463e+03_r8,0.11550e+04_r8 /)
      kbo(:, 4,29,10) = (/ &
        & 0.10388e+04_r8,0.78727e+03_r8,0.59387e+03_r8,0.87332e+03_r8,0.11526e+04_r8 /)
      kbo(:, 5,29,10) = (/ &
        & 0.10383e+04_r8,0.78753e+03_r8,0.59306e+03_r8,0.87189e+03_r8,0.11504e+04_r8 /)
      kbo(:, 1,30,10) = (/ &
        & 0.10398e+04_r8,0.78748e+03_r8,0.59603e+03_r8,0.87643e+03_r8,0.11579e+04_r8 /)
      kbo(:, 2,30,10) = (/ &
        & 0.10387e+04_r8,0.78733e+03_r8,0.59550e+03_r8,0.87550e+03_r8,0.11567e+04_r8 /)
      kbo(:, 3,30,10) = (/ &
        & 0.10384e+04_r8,0.78700e+03_r8,0.59460e+03_r8,0.87431e+03_r8,0.11543e+04_r8 /)
      kbo(:, 4,30,10) = (/ &
        & 0.10381e+04_r8,0.78738e+03_r8,0.59372e+03_r8,0.87275e+03_r8,0.11522e+04_r8 /)
      kbo(:, 5,30,10) = (/ &
        & 0.10382e+04_r8,0.78707e+03_r8,0.59292e+03_r8,0.87137e+03_r8,0.11500e+04_r8 /)
      kbo(:, 1,31,10) = (/ &
        & 0.10388e+04_r8,0.78740e+03_r8,0.59593e+03_r8,0.87621e+03_r8,0.11575e+04_r8 /)
      kbo(:, 2,31,10) = (/ &
        & 0.10385e+04_r8,0.78757e+03_r8,0.59522e+03_r8,0.87522e+03_r8,0.11561e+04_r8 /)
      kbo(:, 3,31,10) = (/ &
        & 0.10386e+04_r8,0.78718e+03_r8,0.59436e+03_r8,0.87397e+03_r8,0.11540e+04_r8 /)
      kbo(:, 4,31,10) = (/ &
        & 0.10377e+04_r8,0.78650e+03_r8,0.59350e+03_r8,0.87250e+03_r8,0.11516e+04_r8 /)
      kbo(:, 5,31,10) = (/ &
        & 0.10376e+04_r8,0.78651e+03_r8,0.59269e+03_r8,0.87108e+03_r8,0.11495e+04_r8 /)
      kbo(:, 1,32,10) = (/ &
        & 0.10383e+04_r8,0.78682e+03_r8,0.59576e+03_r8,0.87597e+03_r8,0.11572e+04_r8 /)
      kbo(:, 2,32,10) = (/ &
        & 0.10383e+04_r8,0.78712e+03_r8,0.59500e+03_r8,0.87480e+03_r8,0.11556e+04_r8 /)
      kbo(:, 3,32,10) = (/ &
        & 0.10381e+04_r8,0.78606e+03_r8,0.59405e+03_r8,0.87362e+03_r8,0.11534e+04_r8 /)
      kbo(:, 4,32,10) = (/ &
        & 0.10372e+04_r8,0.78628e+03_r8,0.59329e+03_r8,0.87223e+03_r8,0.11510e+04_r8 /)
      kbo(:, 5,32,10) = (/ &
        & 0.10377e+04_r8,0.78690e+03_r8,0.59245e+03_r8,0.87068e+03_r8,0.11490e+04_r8 /)
      kbo(:, 1,33,10) = (/ &
        & 0.10380e+04_r8,0.78593e+03_r8,0.59549e+03_r8,0.87572e+03_r8,0.11567e+04_r8 /)
      kbo(:, 2,33,10) = (/ &
        & 0.10375e+04_r8,0.78654e+03_r8,0.59477e+03_r8,0.87458e+03_r8,0.11551e+04_r8 /)
      kbo(:, 3,33,10) = (/ &
        & 0.10374e+04_r8,0.78686e+03_r8,0.59389e+03_r8,0.87337e+03_r8,0.11527e+04_r8 /)
      kbo(:, 4,33,10) = (/ &
        & 0.10366e+04_r8,0.78593e+03_r8,0.59308e+03_r8,0.87194e+03_r8,0.11506e+04_r8 /)
      kbo(:, 5,33,10) = (/ &
        & 0.10369e+04_r8,0.78626e+03_r8,0.59219e+03_r8,0.87038e+03_r8,0.11486e+04_r8 /)
      kbo(:, 1,34,10) = (/ &
        & 0.10373e+04_r8,0.78657e+03_r8,0.59539e+03_r8,0.87559e+03_r8,0.11565e+04_r8 /)
      kbo(:, 2,34,10) = (/ &
        & 0.10370e+04_r8,0.78641e+03_r8,0.59464e+03_r8,0.87429e+03_r8,0.11546e+04_r8 /)
      kbo(:, 3,34,10) = (/ &
        & 0.10370e+04_r8,0.78587e+03_r8,0.59369e+03_r8,0.87295e+03_r8,0.11522e+04_r8 /)
      kbo(:, 4,34,10) = (/ &
        & 0.10371e+04_r8,0.78562e+03_r8,0.59289e+03_r8,0.87146e+03_r8,0.11500e+04_r8 /)
      kbo(:, 5,34,10) = (/ &
        & 0.10372e+04_r8,0.78597e+03_r8,0.59202e+03_r8,0.86991e+03_r8,0.11482e+04_r8 /)
      kbo(:, 1,35,10) = (/ &
        & 0.10364e+04_r8,0.78559e+03_r8,0.59529e+03_r8,0.87523e+03_r8,0.11563e+04_r8 /)
      kbo(:, 2,35,10) = (/ &
        & 0.10362e+04_r8,0.78545e+03_r8,0.59445e+03_r8,0.87400e+03_r8,0.11543e+04_r8 /)
      kbo(:, 3,35,10) = (/ &
        & 0.10372e+04_r8,0.78599e+03_r8,0.59365e+03_r8,0.87265e+03_r8,0.11519e+04_r8 /)
      kbo(:, 4,35,10) = (/ &
        & 0.10370e+04_r8,0.78527e+03_r8,0.59278e+03_r8,0.87136e+03_r8,0.11496e+04_r8 /)
      kbo(:, 5,35,10) = (/ &
        & 0.10363e+04_r8,0.78582e+03_r8,0.59179e+03_r8,0.86905e+03_r8,0.11477e+04_r8 /)
      kbo(:, 1,36,10) = (/ &
        & 0.10368e+04_r8,0.78515e+03_r8,0.59520e+03_r8,0.87532e+03_r8,0.11563e+04_r8 /)
      kbo(:, 2,36,10) = (/ &
        & 0.10358e+04_r8,0.78589e+03_r8,0.59443e+03_r8,0.87419e+03_r8,0.11542e+04_r8 /)
      kbo(:, 3,36,10) = (/ &
        & 0.10361e+04_r8,0.78556e+03_r8,0.59355e+03_r8,0.87273e+03_r8,0.11517e+04_r8 /)
      kbo(:, 4,36,10) = (/ &
        & 0.10361e+04_r8,0.78543e+03_r8,0.59275e+03_r8,0.87122e+03_r8,0.11497e+04_r8 /)
      kbo(:, 5,36,10) = (/ &
        & 0.10368e+04_r8,0.78570e+03_r8,0.59176e+03_r8,0.86999e+03_r8,0.11477e+04_r8 /)
      kbo(:, 1,37,10) = (/ &
        & 0.10363e+04_r8,0.78591e+03_r8,0.59537e+03_r8,0.87546e+03_r8,0.11565e+04_r8 /)
      kbo(:, 2,37,10) = (/ &
        & 0.10360e+04_r8,0.78548e+03_r8,0.59454e+03_r8,0.87425e+03_r8,0.11545e+04_r8 /)
      kbo(:, 3,37,10) = (/ &
        & 0.10362e+04_r8,0.78546e+03_r8,0.59366e+03_r8,0.87291e+03_r8,0.11521e+04_r8 /)
      kbo(:, 4,37,10) = (/ &
        & 0.10364e+04_r8,0.78543e+03_r8,0.59286e+03_r8,0.87142e+03_r8,0.11500e+04_r8 /)
      kbo(:, 5,37,10) = (/ &
        & 0.10360e+04_r8,0.78560e+03_r8,0.59177e+03_r8,0.86987e+03_r8,0.11482e+04_r8 /)
      kbo(:, 1,38,10) = (/ &
        & 0.10362e+04_r8,0.78542e+03_r8,0.59547e+03_r8,0.87560e+03_r8,0.11567e+04_r8 /)
      kbo(:, 2,38,10) = (/ &
        & 0.10357e+04_r8,0.78588e+03_r8,0.59466e+03_r8,0.87433e+03_r8,0.11549e+04_r8 /)
      kbo(:, 3,38,10) = (/ &
        & 0.10370e+04_r8,0.78605e+03_r8,0.59385e+03_r8,0.87310e+03_r8,0.11524e+04_r8 /)
      kbo(:, 4,38,10) = (/ &
        & 0.10362e+04_r8,0.78574e+03_r8,0.59297e+03_r8,0.87186e+03_r8,0.11501e+04_r8 /)
      kbo(:, 5,38,10) = (/ &
        & 0.10364e+04_r8,0.78533e+03_r8,0.59199e+03_r8,0.87009e+03_r8,0.11482e+04_r8 /)
      kbo(:, 1,39,10) = (/ &
        & 0.10359e+04_r8,0.78514e+03_r8,0.59557e+03_r8,0.87574e+03_r8,0.11567e+04_r8 /)
      kbo(:, 2,39,10) = (/ &
        & 0.10371e+04_r8,0.78541e+03_r8,0.59478e+03_r8,0.87461e+03_r8,0.11552e+04_r8 /)
      kbo(:, 3,39,10) = (/ &
        & 0.10366e+04_r8,0.78569e+03_r8,0.59382e+03_r8,0.87329e+03_r8,0.11528e+04_r8 /)
      kbo(:, 4,39,10) = (/ &
        & 0.10359e+04_r8,0.78528e+03_r8,0.59308e+03_r8,0.87198e+03_r8,0.11506e+04_r8 /)
      kbo(:, 5,39,10) = (/ &
        & 0.10356e+04_r8,0.78487e+03_r8,0.59220e+03_r8,0.87042e+03_r8,0.11486e+04_r8 /)
      kbo(:, 1,40,10) = (/ &
        & 0.10357e+04_r8,0.78518e+03_r8,0.59566e+03_r8,0.87586e+03_r8,0.11569e+04_r8 /)
      kbo(:, 2,40,10) = (/ &
        & 0.10357e+04_r8,0.78506e+03_r8,0.59498e+03_r8,0.87480e+03_r8,0.11555e+04_r8 /)
      kbo(:, 3,40,10) = (/ &
        & 0.10366e+04_r8,0.78504e+03_r8,0.59396e+03_r8,0.87362e+03_r8,0.11534e+04_r8 /)
      kbo(:, 4,40,10) = (/ &
        & 0.10363e+04_r8,0.78503e+03_r8,0.59319e+03_r8,0.87212e+03_r8,0.11511e+04_r8 /)
      kbo(:, 5,40,10) = (/ &
        & 0.10363e+04_r8,0.78540e+03_r8,0.59243e+03_r8,0.87078e+03_r8,0.11490e+04_r8 /)
      kbo(:, 1,41,10) = (/ &
        & 0.10363e+04_r8,0.78503e+03_r8,0.59590e+03_r8,0.87608e+03_r8,0.11576e+04_r8 /)
      kbo(:, 2,41,10) = (/ &
        & 0.10356e+04_r8,0.78491e+03_r8,0.59519e+03_r8,0.87520e+03_r8,0.11561e+04_r8 /)
      kbo(:, 3,41,10) = (/ &
        & 0.10364e+04_r8,0.78558e+03_r8,0.59433e+03_r8,0.87384e+03_r8,0.11540e+04_r8 /)
      kbo(:, 4,41,10) = (/ &
        & 0.10357e+04_r8,0.78518e+03_r8,0.59354e+03_r8,0.87259e+03_r8,0.11516e+04_r8 /)
      kbo(:, 5,41,10) = (/ &
        & 0.10360e+04_r8,0.78526e+03_r8,0.59259e+03_r8,0.87107e+03_r8,0.11495e+04_r8 /)
      kbo(:, 1,42,10) = (/ &
        & 0.10360e+04_r8,0.78488e+03_r8,0.59605e+03_r8,0.87553e+03_r8,0.11576e+04_r8 /)
      kbo(:, 2,42,10) = (/ &
        & 0.10363e+04_r8,0.78507e+03_r8,0.59538e+03_r8,0.87537e+03_r8,0.11565e+04_r8 /)
      kbo(:, 3,42,10) = (/ &
        & 0.10362e+04_r8,0.78535e+03_r8,0.59456e+03_r8,0.87429e+03_r8,0.11545e+04_r8 /)
      kbo(:, 4,42,10) = (/ &
        & 0.10361e+04_r8,0.78514e+03_r8,0.59368e+03_r8,0.87295e+03_r8,0.11522e+04_r8 /)
      kbo(:, 5,42,10) = (/ &
        & 0.10360e+04_r8,0.78523e+03_r8,0.59281e+03_r8,0.87146e+03_r8,0.11502e+04_r8 /)
      kbo(:, 1,43,10) = (/ &
        & 0.10359e+04_r8,0.78504e+03_r8,0.59624e+03_r8,0.87675e+03_r8,0.11584e+04_r8 /)
      kbo(:, 2,43,10) = (/ &
        & 0.10355e+04_r8,0.78552e+03_r8,0.59568e+03_r8,0.87580e+03_r8,0.11570e+04_r8 /)
      kbo(:, 3,43,10) = (/ &
        & 0.10354e+04_r8,0.78512e+03_r8,0.59483e+03_r8,0.87469e+03_r8,0.11553e+04_r8 /)
      kbo(:, 4,43,10) = (/ &
        & 0.10354e+04_r8,0.78569e+03_r8,0.59395e+03_r8,0.87316e+03_r8,0.11531e+04_r8 /)
      kbo(:, 5,43,10) = (/ &
        & 0.10359e+04_r8,0.78598e+03_r8,0.59313e+03_r8,0.87186e+03_r8,0.11507e+04_r8 /)
      kbo(:, 1,44,10) = (/ &
        & 0.10359e+04_r8,0.78521e+03_r8,0.59645e+03_r8,0.87700e+03_r8,0.11590e+04_r8 /)
      kbo(:, 2,44,10) = (/ &
        & 0.10361e+04_r8,0.78510e+03_r8,0.59583e+03_r8,0.87611e+03_r8,0.11574e+04_r8 /)
      kbo(:, 3,44,10) = (/ &
        & 0.10368e+04_r8,0.78519e+03_r8,0.59511e+03_r8,0.87509e+03_r8,0.11561e+04_r8 /)
      kbo(:, 4,44,10) = (/ &
        & 0.10360e+04_r8,0.78508e+03_r8,0.59424e+03_r8,0.87372e+03_r8,0.11538e+04_r8 /)
      kbo(:, 5,44,10) = (/ &
        & 0.10356e+04_r8,0.78537e+03_r8,0.59339e+03_r8,0.87213e+03_r8,0.11514e+04_r8 /)
      kbo(:, 1,45,10) = (/ &
        & 0.10357e+04_r8,0.78557e+03_r8,0.59666e+03_r8,0.87715e+03_r8,0.11597e+04_r8 /)
      kbo(:, 2,45,10) = (/ &
        & 0.10356e+04_r8,0.78527e+03_r8,0.59604e+03_r8,0.87639e+03_r8,0.11579e+04_r8 /)
      kbo(:, 3,45,10) = (/ &
        & 0.10360e+04_r8,0.78546e+03_r8,0.59537e+03_r8,0.87547e+03_r8,0.11565e+04_r8 /)
      kbo(:, 4,45,10) = (/ &
        & 0.10361e+04_r8,0.78506e+03_r8,0.59454e+03_r8,0.87427e+03_r8,0.11544e+04_r8 /)
      kbo(:, 5,45,10) = (/ &
        & 0.10353e+04_r8,0.78535e+03_r8,0.59366e+03_r8,0.87293e+03_r8,0.11520e+04_r8 /)
      kbo(:, 1,46,10) = (/ &
        & 0.10358e+04_r8,0.78506e+03_r8,0.59691e+03_r8,0.87749e+03_r8,0.11602e+04_r8 /)
      kbo(:, 2,46,10) = (/ &
        & 0.10353e+04_r8,0.78486e+03_r8,0.59626e+03_r8,0.87678e+03_r8,0.11584e+04_r8 /)
      kbo(:, 3,46,10) = (/ &
        & 0.10353e+04_r8,0.78495e+03_r8,0.59563e+03_r8,0.87572e+03_r8,0.11570e+04_r8 /)
      kbo(:, 4,46,10) = (/ &
        & 0.10363e+04_r8,0.78534e+03_r8,0.59478e+03_r8,0.87473e+03_r8,0.11554e+04_r8 /)
      kbo(:, 5,46,10) = (/ &
        & 0.10355e+04_r8,0.78455e+03_r8,0.59398e+03_r8,0.87342e+03_r8,0.11530e+04_r8 /)
      kbo(:, 1,47,10) = (/ &
        & 0.10357e+04_r8,0.78544e+03_r8,0.59719e+03_r8,0.87795e+03_r8,0.11609e+04_r8 /)
      kbo(:, 2,47,10) = (/ &
        & 0.10355e+04_r8,0.78533e+03_r8,0.59651e+03_r8,0.87696e+03_r8,0.11589e+04_r8 /)
      kbo(:, 3,47,10) = (/ &
        & 0.10358e+04_r8,0.78543e+03_r8,0.59590e+03_r8,0.87576e+03_r8,0.11576e+04_r8 /)
      kbo(:, 4,47,10) = (/ &
        & 0.10351e+04_r8,0.78562e+03_r8,0.59519e+03_r8,0.87521e+03_r8,0.11561e+04_r8 /)
      kbo(:, 5,47,10) = (/ &
        & 0.10359e+04_r8,0.78571e+03_r8,0.59433e+03_r8,0.87385e+03_r8,0.11540e+04_r8 /)
      kbo(:, 1,48,10) = (/ &
        & 0.10363e+04_r8,0.78513e+03_r8,0.59744e+03_r8,0.87846e+03_r8,0.11618e+04_r8 /)
      kbo(:, 2,48,10) = (/ &
        & 0.10360e+04_r8,0.78532e+03_r8,0.59677e+03_r8,0.87730e+03_r8,0.11598e+04_r8 /)
      kbo(:, 3,48,10) = (/ &
        & 0.10365e+04_r8,0.78483e+03_r8,0.59614e+03_r8,0.87707e+03_r8,0.11581e+04_r8 /)
      kbo(:, 4,48,10) = (/ &
        & 0.10355e+04_r8,0.78521e+03_r8,0.59549e+03_r8,0.87564e+03_r8,0.11567e+04_r8 /)
      kbo(:, 5,48,10) = (/ &
        & 0.10355e+04_r8,0.78531e+03_r8,0.59469e+03_r8,0.87448e+03_r8,0.11550e+04_r8 /)
      kbo(:, 1,49,10) = (/ &
        & 0.10351e+04_r8,0.78492e+03_r8,0.59768e+03_r8,0.87902e+03_r8,0.11625e+04_r8 /)
      kbo(:, 2,49,10) = (/ &
        & 0.10355e+04_r8,0.78541e+03_r8,0.59705e+03_r8,0.87772e+03_r8,0.11606e+04_r8 /)
      kbo(:, 3,49,10) = (/ &
        & 0.10352e+04_r8,0.78472e+03_r8,0.59639e+03_r8,0.87682e+03_r8,0.11587e+04_r8 /)
      kbo(:, 4,49,10) = (/ &
        & 0.10356e+04_r8,0.78511e+03_r8,0.59577e+03_r8,0.87591e+03_r8,0.11574e+04_r8 /)
      kbo(:, 5,49,10) = (/ &
        & 0.10352e+04_r8,0.78501e+03_r8,0.59510e+03_r8,0.87498e+03_r8,0.11558e+04_r8 /)
      kbo(:, 1,50,10) = (/ &
        & 0.10361e+04_r8,0.78540e+03_r8,0.59770e+03_r8,0.87956e+03_r8,0.11633e+04_r8 /)
      kbo(:, 2,50,10) = (/ &
        & 0.10357e+04_r8,0.78530e+03_r8,0.59731e+03_r8,0.87817e+03_r8,0.11612e+04_r8 /)
      kbo(:, 3,50,10) = (/ &
        & 0.10365e+04_r8,0.78510e+03_r8,0.59662e+03_r8,0.87710e+03_r8,0.11596e+04_r8 /)
      kbo(:, 4,50,10) = (/ &
        & 0.10365e+04_r8,0.78510e+03_r8,0.59601e+03_r8,0.87645e+03_r8,0.11578e+04_r8 /)
      kbo(:, 5,50,10) = (/ &
        & 0.10352e+04_r8,0.78588e+03_r8,0.59525e+03_r8,0.87541e+03_r8,0.11564e+04_r8 /)
      kbo(:, 1,51,10) = (/ &
        & 0.10356e+04_r8,0.78490e+03_r8,0.59781e+03_r8,0.88010e+03_r8,0.11639e+04_r8 /)
      kbo(:, 2,51,10) = (/ &
        & 0.10356e+04_r8,0.78539e+03_r8,0.59751e+03_r8,0.87866e+03_r8,0.11620e+04_r8 /)
      kbo(:, 3,51,10) = (/ &
        & 0.10359e+04_r8,0.78461e+03_r8,0.59687e+03_r8,0.87744e+03_r8,0.11601e+04_r8 /)
      kbo(:, 4,51,10) = (/ &
        & 0.10352e+04_r8,0.78519e+03_r8,0.59623e+03_r8,0.87674e+03_r8,0.11583e+04_r8 /)
      kbo(:, 5,51,10) = (/ &
        & 0.10356e+04_r8,0.78470e+03_r8,0.59552e+03_r8,0.87578e+03_r8,0.11569e+04_r8 /)
      kbo(:, 1,52,10) = (/ &
        & 0.10352e+04_r8,0.78509e+03_r8,0.59800e+03_r8,0.88094e+03_r8,0.11643e+04_r8 /)
      kbo(:, 2,52,10) = (/ &
        & 0.10355e+04_r8,0.78528e+03_r8,0.59763e+03_r8,0.87918e+03_r8,0.11627e+04_r8 /)
      kbo(:, 3,52,10) = (/ &
        & 0.10361e+04_r8,0.78479e+03_r8,0.59712e+03_r8,0.87762e+03_r8,0.11608e+04_r8 /)
      kbo(:, 4,52,10) = (/ &
        & 0.10358e+04_r8,0.78528e+03_r8,0.59645e+03_r8,0.87678e+03_r8,0.11589e+04_r8 /)
      kbo(:, 5,52,10) = (/ &
        & 0.10355e+04_r8,0.78528e+03_r8,0.59584e+03_r8,0.87612e+03_r8,0.11573e+04_r8 /)
      kbo(:, 1,53,10) = (/ &
        & 0.10357e+04_r8,0.78528e+03_r8,0.59832e+03_r8,0.88148e+03_r8,0.11650e+04_r8 /)
      kbo(:, 2,53,10) = (/ &
        & 0.10357e+04_r8,0.78596e+03_r8,0.59772e+03_r8,0.87969e+03_r8,0.11634e+04_r8 /)
      kbo(:, 3,53,10) = (/ &
        & 0.10361e+04_r8,0.78547e+03_r8,0.59737e+03_r8,0.87830e+03_r8,0.11614e+04_r8 /)
      kbo(:, 4,53,10) = (/ &
        & 0.10362e+04_r8,0.78537e+03_r8,0.59668e+03_r8,0.87707e+03_r8,0.11596e+04_r8 /)
      kbo(:, 5,53,10) = (/ &
        & 0.10356e+04_r8,0.78498e+03_r8,0.59606e+03_r8,0.87642e+03_r8,0.11578e+04_r8 /)
      kbo(:, 1,54,10) = (/ &
        & 0.10351e+04_r8,0.78567e+03_r8,0.59851e+03_r8,0.88199e+03_r8,0.11656e+04_r8 /)
      kbo(:, 2,54,10) = (/ &
        & 0.10366e+04_r8,0.78518e+03_r8,0.59776e+03_r8,0.88021e+03_r8,0.11638e+04_r8 /)
      kbo(:, 3,54,10) = (/ &
        & 0.10364e+04_r8,0.78478e+03_r8,0.59753e+03_r8,0.87875e+03_r8,0.11621e+04_r8 /)
      kbo(:, 4,54,10) = (/ &
        & 0.10356e+04_r8,0.78498e+03_r8,0.59692e+03_r8,0.87751e+03_r8,0.11602e+04_r8 /)
      kbo(:, 5,54,10) = (/ &
        & 0.10362e+04_r8,0.78527e+03_r8,0.59627e+03_r8,0.87657e+03_r8,0.11584e+04_r8 /)
      kbo(:, 1,55,10) = (/ &
        & 0.10355e+04_r8,0.78488e+03_r8,0.59876e+03_r8,0.88250e+03_r8,0.11663e+04_r8 /)
      kbo(:, 2,55,10) = (/ &
        & 0.10362e+04_r8,0.78527e+03_r8,0.59801e+03_r8,0.88087e+03_r8,0.11643e+04_r8 /)
      kbo(:, 3,55,10) = (/ &
        & 0.10356e+04_r8,0.78507e+03_r8,0.59764e+03_r8,0.87920e+03_r8,0.11628e+04_r8 /)
      kbo(:, 4,55,10) = (/ &
        & 0.10353e+04_r8,0.78488e+03_r8,0.59714e+03_r8,0.87787e+03_r8,0.11606e+04_r8 /)
      kbo(:, 5,55,10) = (/ &
        & 0.10356e+04_r8,0.78488e+03_r8,0.59639e+03_r8,0.87691e+03_r8,0.11585e+04_r8 /)
      kbo(:, 1,56,10) = (/ &
        & 0.10353e+04_r8,0.78537e+03_r8,0.59904e+03_r8,0.88318e+03_r8,0.11672e+04_r8 /)
      kbo(:, 2,56,10) = (/ &
        & 0.10354e+04_r8,0.78497e+03_r8,0.59830e+03_r8,0.88144e+03_r8,0.11649e+04_r8 /)
      kbo(:, 3,56,10) = (/ &
        & 0.10361e+04_r8,0.78536e+03_r8,0.59771e+03_r8,0.87966e+03_r8,0.11634e+04_r8 /)
      kbo(:, 4,56,10) = (/ &
        & 0.10357e+04_r8,0.78497e+03_r8,0.59736e+03_r8,0.87826e+03_r8,0.11615e+04_r8 /)
      kbo(:, 5,56,10) = (/ &
        & 0.10353e+04_r8,0.78478e+03_r8,0.59667e+03_r8,0.87705e+03_r8,0.11595e+04_r8 /)
      kbo(:, 1,57,10) = (/ &
        & 0.10358e+04_r8,0.78458e+03_r8,0.59927e+03_r8,0.88350e+03_r8,0.11679e+04_r8 /)
      kbo(:, 2,57,10) = (/ &
        & 0.10352e+04_r8,0.78536e+03_r8,0.59840e+03_r8,0.88193e+03_r8,0.11656e+04_r8 /)
      kbo(:, 3,57,10) = (/ &
        & 0.10352e+04_r8,0.78526e+03_r8,0.59782e+03_r8,0.88003e+03_r8,0.11638e+04_r8 /)
      kbo(:, 4,57,10) = (/ &
        & 0.10358e+04_r8,0.78497e+03_r8,0.59751e+03_r8,0.87869e+03_r8,0.11622e+04_r8 /)
      kbo(:, 5,57,10) = (/ &
        & 0.10360e+04_r8,0.78497e+03_r8,0.59689e+03_r8,0.87746e+03_r8,0.11601e+04_r8 /)
      kbo(:, 1,58,10) = (/ &
        & 0.10358e+04_r8,0.78468e+03_r8,0.59969e+03_r8,0.88402e+03_r8,0.11685e+04_r8 /)
      kbo(:, 2,58,10) = (/ &
        & 0.10357e+04_r8,0.78458e+03_r8,0.59873e+03_r8,0.88241e+03_r8,0.11662e+04_r8 /)
      kbo(:, 3,58,10) = (/ &
        & 0.10358e+04_r8,0.78526e+03_r8,0.59797e+03_r8,0.88085e+03_r8,0.11642e+04_r8 /)
      kbo(:, 4,58,10) = (/ &
        & 0.10356e+04_r8,0.78487e+03_r8,0.59762e+03_r8,0.87912e+03_r8,0.11626e+04_r8 /)
      kbo(:, 5,58,10) = (/ &
        & 0.10357e+04_r8,0.78565e+03_r8,0.59710e+03_r8,0.87769e+03_r8,0.11608e+04_r8 /)
      kbo(:, 1,59,10) = (/ &
        & 0.10360e+04_r8,0.78507e+03_r8,0.59979e+03_r8,0.88416e+03_r8,0.11687e+04_r8 /)
      kbo(:, 2,59,10) = (/ &
        & 0.10357e+04_r8,0.78477e+03_r8,0.59879e+03_r8,0.88260e+03_r8,0.11665e+04_r8 /)
      kbo(:, 3,59,10) = (/ &
        & 0.10350e+04_r8,0.78526e+03_r8,0.59804e+03_r8,0.88100e+03_r8,0.11644e+04_r8 /)
      kbo(:, 4,59,10) = (/ &
        & 0.10357e+04_r8,0.78467e+03_r8,0.59773e+03_r8,0.87930e+03_r8,0.11629e+04_r8 /)
      kbo(:, 5,59,10) = (/ &
        & 0.10358e+04_r8,0.78457e+03_r8,0.59718e+03_r8,0.87783e+03_r8,0.11609e+04_r8 /)
      kbo(:, 1,13,11) = (/ &
        & 0.11563e+04_r8,0.87491e+03_r8,0.60253e+03_r8,0.88362e+03_r8,0.11664e+04_r8 /)
      kbo(:, 2,13,11) = (/ &
        & 0.11454e+04_r8,0.86861e+03_r8,0.60211e+03_r8,0.88300e+03_r8,0.11639e+04_r8 /)
      kbo(:, 3,13,11) = (/ &
        & 0.11392e+04_r8,0.86181e+03_r8,0.60140e+03_r8,0.88181e+03_r8,0.11620e+04_r8 /)
      kbo(:, 4,13,11) = (/ &
        & 0.11315e+04_r8,0.85680e+03_r8,0.60042e+03_r8,0.88057e+03_r8,0.11602e+04_r8 /)
      kbo(:, 5,13,11) = (/ &
        & 0.11273e+04_r8,0.85330e+03_r8,0.59929e+03_r8,0.87908e+03_r8,0.11581e+04_r8 /)
      kbo(:, 1,14,11) = (/ &
        & 0.11333e+04_r8,0.85776e+03_r8,0.60215e+03_r8,0.88338e+03_r8,0.11660e+04_r8 /)
      kbo(:, 2,14,11) = (/ &
        & 0.11256e+04_r8,0.85211e+03_r8,0.60176e+03_r8,0.88258e+03_r8,0.11637e+04_r8 /)
      kbo(:, 3,14,11) = (/ &
        & 0.11185e+04_r8,0.84809e+03_r8,0.60101e+03_r8,0.88154e+03_r8,0.11618e+04_r8 /)
      kbo(:, 4,14,11) = (/ &
        & 0.11137e+04_r8,0.84328e+03_r8,0.59992e+03_r8,0.87989e+03_r8,0.11599e+04_r8 /)
      kbo(:, 5,14,11) = (/ &
        & 0.11092e+04_r8,0.83997e+03_r8,0.59898e+03_r8,0.87879e+03_r8,0.11581e+04_r8 /)
      kbo(:, 1,15,11) = (/ &
        & 0.11149e+04_r8,0.84435e+03_r8,0.60192e+03_r8,0.88317e+03_r8,0.11660e+04_r8 /)
      kbo(:, 2,15,11) = (/ &
        & 0.11071e+04_r8,0.83899e+03_r8,0.60145e+03_r8,0.88233e+03_r8,0.11635e+04_r8 /)
      kbo(:, 3,15,11) = (/ &
        & 0.11058e+04_r8,0.83612e+03_r8,0.60066e+03_r8,0.88128e+03_r8,0.11617e+04_r8 /)
      kbo(:, 4,15,11) = (/ &
        & 0.10996e+04_r8,0.83410e+03_r8,0.59965e+03_r8,0.88002e+03_r8,0.11599e+04_r8 /)
      kbo(:, 5,15,11) = (/ &
        & 0.10957e+04_r8,0.83022e+03_r8,0.59863e+03_r8,0.87850e+03_r8,0.11578e+04_r8 /)
      kbo(:, 1,16,11) = (/ &
        & 0.10993e+04_r8,0.83361e+03_r8,0.60157e+03_r8,0.88298e+03_r8,0.11657e+04_r8 /)
      kbo(:, 2,16,11) = (/ &
        & 0.10933e+04_r8,0.82961e+03_r8,0.60127e+03_r8,0.88210e+03_r8,0.11633e+04_r8 /)
      kbo(:, 3,16,11) = (/ &
        & 0.10924e+04_r8,0.82745e+03_r8,0.60035e+03_r8,0.88104e+03_r8,0.11615e+04_r8 /)
      kbo(:, 4,16,11) = (/ &
        & 0.10885e+04_r8,0.82319e+03_r8,0.59934e+03_r8,0.87977e+03_r8,0.11597e+04_r8 /)
      kbo(:, 5,16,11) = (/ &
        & 0.10838e+04_r8,0.82062e+03_r8,0.59823e+03_r8,0.87823e+03_r8,0.11577e+04_r8 /)
      kbo(:, 1,17,11) = (/ &
        & 0.10881e+04_r8,0.82385e+03_r8,0.60135e+03_r8,0.88282e+03_r8,0.11656e+04_r8 /)
      kbo(:, 2,17,11) = (/ &
        & 0.10840e+04_r8,0.82201e+03_r8,0.60094e+03_r8,0.88190e+03_r8,0.11631e+04_r8 /)
      kbo(:, 3,17,11) = (/ &
        & 0.10809e+04_r8,0.81908e+03_r8,0.60007e+03_r8,0.88083e+03_r8,0.11613e+04_r8 /)
      kbo(:, 4,17,11) = (/ &
        & 0.10772e+04_r8,0.81792e+03_r8,0.59907e+03_r8,0.87953e+03_r8,0.11595e+04_r8 /)
      kbo(:, 5,17,11) = (/ &
        & 0.10760e+04_r8,0.81580e+03_r8,0.59806e+03_r8,0.87798e+03_r8,0.11575e+04_r8 /)
      kbo(:, 1,18,11) = (/ &
        & 0.10780e+04_r8,0.81679e+03_r8,0.60116e+03_r8,0.88267e+03_r8,0.11653e+04_r8 /)
      kbo(:, 2,18,11) = (/ &
        & 0.10749e+04_r8,0.81512e+03_r8,0.60072e+03_r8,0.88171e+03_r8,0.11629e+04_r8 /)
      kbo(:, 3,18,11) = (/ &
        & 0.10728e+04_r8,0.81180e+03_r8,0.59983e+03_r8,0.88050e+03_r8,0.11611e+04_r8 /)
      kbo(:, 4,18,11) = (/ &
        & 0.10707e+04_r8,0.81081e+03_r8,0.59883e+03_r8,0.87944e+03_r8,0.11593e+04_r8 /)
      kbo(:, 5,18,11) = (/ &
        & 0.10678e+04_r8,0.80905e+03_r8,0.59782e+03_r8,0.87775e+03_r8,0.11574e+04_r8 /)
      kbo(:, 1,19,11) = (/ &
        & 0.10696e+04_r8,0.81122e+03_r8,0.60101e+03_r8,0.88252e+03_r8,0.11649e+04_r8 /)
      kbo(:, 2,19,11) = (/ &
        & 0.10692e+04_r8,0.80792e+03_r8,0.60053e+03_r8,0.88155e+03_r8,0.11625e+04_r8 /)
      kbo(:, 3,19,11) = (/ &
        & 0.10653e+04_r8,0.80791e+03_r8,0.59962e+03_r8,0.88058e+03_r8,0.11609e+04_r8 /)
      kbo(:, 4,19,11) = (/ &
        & 0.10635e+04_r8,0.80651e+03_r8,0.59853e+03_r8,0.87910e+03_r8,0.11591e+04_r8 /)
      kbo(:, 5,19,11) = (/ &
        & 0.10626e+04_r8,0.80552e+03_r8,0.59761e+03_r8,0.87753e+03_r8,0.11572e+04_r8 /)
      kbo(:, 1,20,11) = (/ &
        & 0.10638e+04_r8,0.80613e+03_r8,0.60096e+03_r8,0.88236e+03_r8,0.11646e+04_r8 /)
      kbo(:, 2,20,11) = (/ &
        & 0.10623e+04_r8,0.80416e+03_r8,0.60035e+03_r8,0.88137e+03_r8,0.11625e+04_r8 /)
      kbo(:, 3,20,11) = (/ &
        & 0.10590e+04_r8,0.80264e+03_r8,0.59950e+03_r8,0.88013e+03_r8,0.11607e+04_r8 /)
      kbo(:, 4,20,11) = (/ &
        & 0.10603e+04_r8,0.80308e+03_r8,0.59841e+03_r8,0.87915e+03_r8,0.11587e+04_r8 /)
      kbo(:, 5,20,11) = (/ &
        & 0.10573e+04_r8,0.80101e+03_r8,0.59740e+03_r8,0.87729e+03_r8,0.11568e+04_r8 /)
      kbo(:, 1,21,11) = (/ &
        & 0.10580e+04_r8,0.80255e+03_r8,0.60075e+03_r8,0.88233e+03_r8,0.11643e+04_r8 /)
      kbo(:, 2,21,11) = (/ &
        & 0.10580e+04_r8,0.80172e+03_r8,0.60017e+03_r8,0.88121e+03_r8,0.11623e+04_r8 /)
      kbo(:, 3,21,11) = (/ &
        & 0.10551e+04_r8,0.80129e+03_r8,0.59922e+03_r8,0.87954e+03_r8,0.11605e+04_r8 /)
      kbo(:, 4,21,11) = (/ &
        & 0.10544e+04_r8,0.79894e+03_r8,0.59822e+03_r8,0.87866e+03_r8,0.11586e+04_r8 /)
      kbo(:, 5,21,11) = (/ &
        & 0.10531e+04_r8,0.79850e+03_r8,0.59721e+03_r8,0.87693e+03_r8,0.11568e+04_r8 /)
      kbo(:, 1,22,11) = (/ &
        & 0.10535e+04_r8,0.79809e+03_r8,0.60064e+03_r8,0.88198e+03_r8,0.11639e+04_r8 /)
      kbo(:, 2,22,11) = (/ &
        & 0.10534e+04_r8,0.79679e+03_r8,0.59986e+03_r8,0.88098e+03_r8,0.11619e+04_r8 /)
      kbo(:, 3,22,11) = (/ &
        & 0.10517e+04_r8,0.79764e+03_r8,0.59897e+03_r8,0.87993e+03_r8,0.11602e+04_r8 /)
      kbo(:, 4,22,11) = (/ &
        & 0.10510e+04_r8,0.79739e+03_r8,0.59797e+03_r8,0.87835e+03_r8,0.11582e+04_r8 /)
      kbo(:, 5,22,11) = (/ &
        & 0.10492e+04_r8,0.79579e+03_r8,0.59697e+03_r8,0.87672e+03_r8,0.11565e+04_r8 /)
      kbo(:, 1,23,11) = (/ &
        & 0.10516e+04_r8,0.79606e+03_r8,0.60095e+03_r8,0.88176e+03_r8,0.11633e+04_r8 /)
      kbo(:, 2,23,11) = (/ &
        & 0.10497e+04_r8,0.79542e+03_r8,0.59972e+03_r8,0.88074e+03_r8,0.11616e+04_r8 /)
      kbo(:, 3,23,11) = (/ &
        & 0.10482e+04_r8,0.79453e+03_r8,0.59873e+03_r8,0.87952e+03_r8,0.11598e+04_r8 /)
      kbo(:, 4,23,11) = (/ &
        & 0.10486e+04_r8,0.79431e+03_r8,0.59782e+03_r8,0.87802e+03_r8,0.11579e+04_r8 /)
      kbo(:, 5,23,11) = (/ &
        & 0.10473e+04_r8,0.79522e+03_r8,0.59672e+03_r8,0.87637e+03_r8,0.11562e+04_r8 /)
      kbo(:, 1,24,11) = (/ &
        & 0.10467e+04_r8,0.79476e+03_r8,0.60034e+03_r8,0.88154e+03_r8,0.11630e+04_r8 /)
      kbo(:, 2,24,11) = (/ &
        & 0.10461e+04_r8,0.79357e+03_r8,0.59948e+03_r8,0.88049e+03_r8,0.11613e+04_r8 /)
      kbo(:, 3,24,11) = (/ &
        & 0.10460e+04_r8,0.79280e+03_r8,0.59849e+03_r8,0.87921e+03_r8,0.11596e+04_r8 /)
      kbo(:, 4,24,11) = (/ &
        & 0.10457e+04_r8,0.79222e+03_r8,0.59749e+03_r8,0.87768e+03_r8,0.11575e+04_r8 /)
      kbo(:, 5,24,11) = (/ &
        & 0.10450e+04_r8,0.79193e+03_r8,0.59639e+03_r8,0.87600e+03_r8,0.11558e+04_r8 /)
      kbo(:, 1,25,11) = (/ &
        & 0.10463e+04_r8,0.79209e+03_r8,0.60015e+03_r8,0.88131e+03_r8,0.11626e+04_r8 /)
      kbo(:, 2,25,11) = (/ &
        & 0.10455e+04_r8,0.79185e+03_r8,0.59924e+03_r8,0.87983e+03_r8,0.11609e+04_r8 /)
      kbo(:, 3,25,11) = (/ &
        & 0.10450e+04_r8,0.79214e+03_r8,0.59824e+03_r8,0.87889e+03_r8,0.11590e+04_r8 /)
      kbo(:, 4,25,11) = (/ &
        & 0.10445e+04_r8,0.79118e+03_r8,0.59725e+03_r8,0.87732e+03_r8,0.11571e+04_r8 /)
      kbo(:, 5,25,11) = (/ &
        & 0.10428e+04_r8,0.79168e+03_r8,0.59624e+03_r8,0.87561e+03_r8,0.11555e+04_r8 /)
      kbo(:, 1,26,11) = (/ &
        & 0.10437e+04_r8,0.79093e+03_r8,0.59993e+03_r8,0.88106e+03_r8,0.11624e+04_r8 /)
      kbo(:, 2,26,11) = (/ &
        & 0.10430e+04_r8,0.79091e+03_r8,0.59898e+03_r8,0.87993e+03_r8,0.11605e+04_r8 /)
      kbo(:, 3,26,11) = (/ &
        & 0.10430e+04_r8,0.79069e+03_r8,0.59808e+03_r8,0.87852e+03_r8,0.11586e+04_r8 /)
      kbo(:, 4,26,11) = (/ &
        & 0.10425e+04_r8,0.79087e+03_r8,0.59699e+03_r8,0.87692e+03_r8,0.11569e+04_r8 /)
      kbo(:, 5,26,11) = (/ &
        & 0.10414e+04_r8,0.78954e+03_r8,0.59598e+03_r8,0.87517e+03_r8,0.11547e+04_r8 /)
      kbo(:, 1,27,11) = (/ &
        & 0.10423e+04_r8,0.79028e+03_r8,0.59970e+03_r8,0.88080e+03_r8,0.11616e+04_r8 /)
      kbo(:, 2,27,11) = (/ &
        & 0.10415e+04_r8,0.78939e+03_r8,0.59872e+03_r8,0.87961e+03_r8,0.11600e+04_r8 /)
      kbo(:, 3,27,11) = (/ &
        & 0.10419e+04_r8,0.78972e+03_r8,0.59773e+03_r8,0.87814e+03_r8,0.11581e+04_r8 /)
      kbo(:, 4,27,11) = (/ &
        & 0.10405e+04_r8,0.78901e+03_r8,0.59673e+03_r8,0.87651e+03_r8,0.11564e+04_r8 /)
      kbo(:, 5,27,11) = (/ &
        & 0.10410e+04_r8,0.78880e+03_r8,0.59572e+03_r8,0.87471e+03_r8,0.11546e+04_r8 /)
      kbo(:, 1,28,11) = (/ &
        & 0.10411e+04_r8,0.78831e+03_r8,0.59945e+03_r8,0.88052e+03_r8,0.11614e+04_r8 /)
      kbo(:, 2,28,11) = (/ &
        & 0.10402e+04_r8,0.78866e+03_r8,0.59846e+03_r8,0.87954e+03_r8,0.11596e+04_r8 /)
      kbo(:, 3,28,11) = (/ &
        & 0.10401e+04_r8,0.78798e+03_r8,0.59747e+03_r8,0.87776e+03_r8,0.11577e+04_r8 /)
      kbo(:, 4,28,11) = (/ &
        & 0.10407e+04_r8,0.78779e+03_r8,0.59647e+03_r8,0.87596e+03_r8,0.11560e+04_r8 /)
      kbo(:, 5,28,11) = (/ &
        & 0.10407e+04_r8,0.78751e+03_r8,0.59548e+03_r8,0.87425e+03_r8,0.11542e+04_r8 /)
      kbo(:, 1,29,11) = (/ &
        & 0.10408e+04_r8,0.78876e+03_r8,0.59920e+03_r8,0.87983e+03_r8,0.11608e+04_r8 /)
      kbo(:, 2,29,11) = (/ &
        & 0.10408e+04_r8,0.78834e+03_r8,0.59820e+03_r8,0.87891e+03_r8,0.11591e+04_r8 /)
      kbo(:, 3,29,11) = (/ &
        & 0.10387e+04_r8,0.78864e+03_r8,0.59721e+03_r8,0.87735e+03_r8,0.11572e+04_r8 /)
      kbo(:, 4,29,11) = (/ &
        & 0.10384e+04_r8,0.78778e+03_r8,0.59621e+03_r8,0.87578e+03_r8,0.11555e+04_r8 /)
      kbo(:, 5,29,11) = (/ &
        & 0.10412e+04_r8,0.78824e+03_r8,0.59524e+03_r8,0.87368e+03_r8,0.11538e+04_r8 /)
      kbo(:, 1,30,11) = (/ &
        & 0.10383e+04_r8,0.78758e+03_r8,0.59894e+03_r8,0.87992e+03_r8,0.11605e+04_r8 /)
      kbo(:, 2,30,11) = (/ &
        & 0.10390e+04_r8,0.78755e+03_r8,0.59785e+03_r8,0.87840e+03_r8,0.11584e+04_r8 /)
      kbo(:, 3,30,11) = (/ &
        & 0.10391e+04_r8,0.78813e+03_r8,0.59695e+03_r8,0.87693e+03_r8,0.11568e+04_r8 /)
      kbo(:, 4,30,11) = (/ &
        & 0.10384e+04_r8,0.78683e+03_r8,0.59594e+03_r8,0.87519e+03_r8,0.11551e+04_r8 /)
      kbo(:, 5,30,11) = (/ &
        & 0.10388e+04_r8,0.78660e+03_r8,0.59501e+03_r8,0.87341e+03_r8,0.11534e+04_r8 /)
      kbo(:, 1,31,11) = (/ &
        & 0.10376e+04_r8,0.78640e+03_r8,0.59867e+03_r8,0.87959e+03_r8,0.11601e+04_r8 /)
      kbo(:, 2,31,11) = (/ &
        & 0.10381e+04_r8,0.78687e+03_r8,0.59768e+03_r8,0.87813e+03_r8,0.11581e+04_r8 /)
      kbo(:, 3,31,11) = (/ &
        & 0.10369e+04_r8,0.78736e+03_r8,0.59668e+03_r8,0.87650e+03_r8,0.11564e+04_r8 /)
      kbo(:, 4,31,11) = (/ &
        & 0.10380e+04_r8,0.78738e+03_r8,0.59577e+03_r8,0.87483e+03_r8,0.11546e+04_r8 /)
      kbo(:, 5,31,11) = (/ &
        & 0.10391e+04_r8,0.78671e+03_r8,0.59479e+03_r8,0.87299e+03_r8,0.11532e+04_r8 /)
      kbo(:, 1,32,11) = (/ &
        & 0.10371e+04_r8,0.78531e+03_r8,0.59840e+03_r8,0.87936e+03_r8,0.11596e+04_r8 /)
      kbo(:, 2,32,11) = (/ &
        & 0.10383e+04_r8,0.78734e+03_r8,0.59742e+03_r8,0.87771e+03_r8,0.11576e+04_r8 /)
      kbo(:, 3,32,11) = (/ &
        & 0.10363e+04_r8,0.78691e+03_r8,0.59641e+03_r8,0.87605e+03_r8,0.11559e+04_r8 /)
      kbo(:, 4,32,11) = (/ &
        & 0.10373e+04_r8,0.78648e+03_r8,0.59543e+03_r8,0.87420e+03_r8,0.11542e+04_r8 /)
      kbo(:, 5,32,11) = (/ &
        & 0.10376e+04_r8,0.78617e+03_r8,0.59455e+03_r8,0.87256e+03_r8,0.11529e+04_r8 /)
      kbo(:, 1,33,11) = (/ &
        & 0.10366e+04_r8,0.78725e+03_r8,0.59814e+03_r8,0.87885e+03_r8,0.11591e+04_r8 /)
      kbo(:, 2,33,11) = (/ &
        & 0.10366e+04_r8,0.78694e+03_r8,0.59715e+03_r8,0.87729e+03_r8,0.11572e+04_r8 /)
      kbo(:, 3,33,11) = (/ &
        & 0.10365e+04_r8,0.78534e+03_r8,0.59614e+03_r8,0.87545e+03_r8,0.11555e+04_r8 /)
      kbo(:, 4,33,11) = (/ &
        & 0.10377e+04_r8,0.78705e+03_r8,0.59518e+03_r8,0.87362e+03_r8,0.11536e+04_r8 /)
      kbo(:, 5,33,11) = (/ &
        & 0.10381e+04_r8,0.78546e+03_r8,0.59428e+03_r8,0.87201e+03_r8,0.11526e+04_r8 /)
      kbo(:, 1,34,11) = (/ &
        & 0.10370e+04_r8,0.78547e+03_r8,0.59791e+03_r8,0.87837e+03_r8,0.11586e+04_r8 /)
      kbo(:, 2,34,11) = (/ &
        & 0.10369e+04_r8,0.78635e+03_r8,0.59683e+03_r8,0.87691e+03_r8,0.11568e+04_r8 /)
      kbo(:, 3,34,11) = (/ &
        & 0.10373e+04_r8,0.78607e+03_r8,0.59591e+03_r8,0.87516e+03_r8,0.11551e+04_r8 /)
      kbo(:, 4,34,11) = (/ &
        & 0.10371e+04_r8,0.78696e+03_r8,0.59498e+03_r8,0.87338e+03_r8,0.11534e+04_r8 /)
      kbo(:, 5,34,11) = (/ &
        & 0.10366e+04_r8,0.78538e+03_r8,0.59374e+03_r8,0.87179e+03_r8,0.11524e+04_r8 /)
      kbo(:, 1,35,11) = (/ &
        & 0.10371e+04_r8,0.78681e+03_r8,0.59778e+03_r8,0.87830e+03_r8,0.11583e+04_r8 /)
      kbo(:, 2,35,11) = (/ &
        & 0.10367e+04_r8,0.78665e+03_r8,0.59678e+03_r8,0.87669e+03_r8,0.11566e+04_r8 /)
      kbo(:, 3,35,11) = (/ &
        & 0.10363e+04_r8,0.78613e+03_r8,0.59569e+03_r8,0.87491e+03_r8,0.11549e+04_r8 /)
      kbo(:, 4,35,11) = (/ &
        & 0.10364e+04_r8,0.78668e+03_r8,0.59487e+03_r8,0.87304e+03_r8,0.11533e+04_r8 /)
      kbo(:, 5,35,11) = (/ &
        & 0.10370e+04_r8,0.78641e+03_r8,0.59363e+03_r8,0.87159e+03_r8,0.11523e+04_r8 /)
      kbo(:, 1,36,11) = (/ &
        & 0.10366e+04_r8,0.78595e+03_r8,0.59775e+03_r8,0.87827e+03_r8,0.11583e+04_r8 /)
      kbo(:, 2,36,11) = (/ &
        & 0.10367e+04_r8,0.78568e+03_r8,0.59676e+03_r8,0.87652e+03_r8,0.11565e+04_r8 /)
      kbo(:, 3,36,11) = (/ &
        & 0.10363e+04_r8,0.78600e+03_r8,0.59575e+03_r8,0.87487e+03_r8,0.11548e+04_r8 /)
      kbo(:, 4,36,11) = (/ &
        & 0.10370e+04_r8,0.78596e+03_r8,0.59503e+03_r8,0.87314e+03_r8,0.11533e+04_r8 /)
      kbo(:, 5,36,11) = (/ &
        & 0.10356e+04_r8,0.78546e+03_r8,0.59359e+03_r8,0.87116e+03_r8,0.11523e+04_r8 /)
      kbo(:, 1,37,11) = (/ &
        & 0.10367e+04_r8,0.78524e+03_r8,0.59788e+03_r8,0.87847e+03_r8,0.11586e+04_r8 /)
      kbo(:, 2,37,11) = (/ &
        & 0.10373e+04_r8,0.78580e+03_r8,0.59689e+03_r8,0.87687e+03_r8,0.11567e+04_r8 /)
      kbo(:, 3,37,11) = (/ &
        & 0.10369e+04_r8,0.78554e+03_r8,0.59588e+03_r8,0.87512e+03_r8,0.11550e+04_r8 /)
      kbo(:, 4,37,11) = (/ &
        & 0.10372e+04_r8,0.78551e+03_r8,0.59495e+03_r8,0.87335e+03_r8,0.11534e+04_r8 /)
      kbo(:, 5,37,11) = (/ &
        & 0.10364e+04_r8,0.78631e+03_r8,0.59378e+03_r8,0.87175e+03_r8,0.11524e+04_r8 /)
      kbo(:, 1,38,11) = (/ &
        & 0.10372e+04_r8,0.78574e+03_r8,0.59801e+03_r8,0.87867e+03_r8,0.11588e+04_r8 /)
      kbo(:, 2,38,11) = (/ &
        & 0.10364e+04_r8,0.78476e+03_r8,0.59702e+03_r8,0.87710e+03_r8,0.11570e+04_r8 /)
      kbo(:, 3,38,11) = (/ &
        & 0.10351e+04_r8,0.78521e+03_r8,0.59593e+03_r8,0.87537e+03_r8,0.11553e+04_r8 /)
      kbo(:, 4,38,11) = (/ &
        & 0.10362e+04_r8,0.78507e+03_r8,0.59507e+03_r8,0.87344e+03_r8,0.11536e+04_r8 /)
      kbo(:, 5,38,11) = (/ &
        & 0.10371e+04_r8,0.78635e+03_r8,0.59400e+03_r8,0.87197e+03_r8,0.11525e+04_r8 /)
      kbo(:, 1,39,11) = (/ &
        & 0.10359e+04_r8,0.78601e+03_r8,0.59815e+03_r8,0.87888e+03_r8,0.11591e+04_r8 /)
      kbo(:, 2,39,11) = (/ &
        & 0.10375e+04_r8,0.78669e+03_r8,0.59716e+03_r8,0.87732e+03_r8,0.11572e+04_r8 /)
      kbo(:, 3,39,11) = (/ &
        & 0.10350e+04_r8,0.78597e+03_r8,0.59615e+03_r8,0.87562e+03_r8,0.11555e+04_r8 /)
      kbo(:, 4,39,11) = (/ &
        & 0.10366e+04_r8,0.78524e+03_r8,0.59519e+03_r8,0.87365e+03_r8,0.11538e+04_r8 /)
      kbo(:, 5,39,11) = (/ &
        & 0.10373e+04_r8,0.78605e+03_r8,0.59422e+03_r8,0.87205e+03_r8,0.11526e+04_r8 /)
      kbo(:, 1,40,11) = (/ &
        & 0.10361e+04_r8,0.78559e+03_r8,0.59838e+03_r8,0.87949e+03_r8,0.11596e+04_r8 /)
      kbo(:, 2,40,11) = (/ &
        & 0.10364e+04_r8,0.78533e+03_r8,0.59740e+03_r8,0.87771e+03_r8,0.11576e+04_r8 /)
      kbo(:, 3,40,11) = (/ &
        & 0.10357e+04_r8,0.78567e+03_r8,0.59640e+03_r8,0.87605e+03_r8,0.11559e+04_r8 /)
      kbo(:, 4,40,11) = (/ &
        & 0.10354e+04_r8,0.78518e+03_r8,0.59541e+03_r8,0.87434e+03_r8,0.11542e+04_r8 /)
      kbo(:, 5,40,11) = (/ &
        & 0.10361e+04_r8,0.78553e+03_r8,0.59453e+03_r8,0.87244e+03_r8,0.11529e+04_r8 /)
      kbo(:, 1,41,11) = (/ &
        & 0.10352e+04_r8,0.78554e+03_r8,0.59863e+03_r8,0.87958e+03_r8,0.11601e+04_r8 /)
      kbo(:, 2,41,11) = (/ &
        & 0.10361e+04_r8,0.78611e+03_r8,0.59765e+03_r8,0.87811e+03_r8,0.11581e+04_r8 /)
      kbo(:, 3,41,11) = (/ &
        & 0.10357e+04_r8,0.78586e+03_r8,0.59665e+03_r8,0.87648e+03_r8,0.11564e+04_r8 /)
      kbo(:, 4,41,11) = (/ &
        & 0.10369e+04_r8,0.78632e+03_r8,0.59556e+03_r8,0.87469e+03_r8,0.11547e+04_r8 /)
      kbo(:, 5,41,11) = (/ &
        & 0.10372e+04_r8,0.78631e+03_r8,0.59476e+03_r8,0.87298e+03_r8,0.11532e+04_r8 /)
      kbo(:, 1,42,11) = (/ &
        & 0.10352e+04_r8,0.78620e+03_r8,0.59889e+03_r8,0.87990e+03_r8,0.11605e+04_r8 /)
      kbo(:, 2,42,11) = (/ &
        & 0.10362e+04_r8,0.78666e+03_r8,0.59790e+03_r8,0.87851e+03_r8,0.11586e+04_r8 /)
      kbo(:, 3,42,11) = (/ &
        & 0.10358e+04_r8,0.78476e+03_r8,0.59691e+03_r8,0.87691e+03_r8,0.11568e+04_r8 /)
      kbo(:, 4,42,11) = (/ &
        & 0.10367e+04_r8,0.78534e+03_r8,0.59590e+03_r8,0.87517e+03_r8,0.11551e+04_r8 /)
      kbo(:, 5,42,11) = (/ &
        & 0.10374e+04_r8,0.78497e+03_r8,0.59497e+03_r8,0.87339e+03_r8,0.11533e+04_r8 /)
      kbo(:, 1,43,11) = (/ &
        & 0.10357e+04_r8,0.78569e+03_r8,0.59919e+03_r8,0.88014e+03_r8,0.11611e+04_r8 /)
      kbo(:, 2,43,11) = (/ &
        & 0.10384e+04_r8,0.78603e+03_r8,0.59811e+03_r8,0.87910e+03_r8,0.11592e+04_r8 /)
      kbo(:, 3,43,11) = (/ &
        & 0.10376e+04_r8,0.78685e+03_r8,0.59731e+03_r8,0.87742e+03_r8,0.11573e+04_r8 /)
      kbo(:, 4,43,11) = (/ &
        & 0.10368e+04_r8,0.78484e+03_r8,0.59612e+03_r8,0.87573e+03_r8,0.11555e+04_r8 /)
      kbo(:, 5,43,11) = (/ &
        & 0.10371e+04_r8,0.78612e+03_r8,0.59525e+03_r8,0.87389e+03_r8,0.11539e+04_r8 /)
      kbo(:, 1,44,11) = (/ &
        & 0.10362e+04_r8,0.78531e+03_r8,0.59952e+03_r8,0.88052e+03_r8,0.11615e+04_r8 /)
      kbo(:, 2,44,11) = (/ &
        & 0.10357e+04_r8,0.78506e+03_r8,0.59854e+03_r8,0.87945e+03_r8,0.11599e+04_r8 /)
      kbo(:, 3,44,11) = (/ &
        & 0.10347e+04_r8,0.78494e+03_r8,0.59755e+03_r8,0.87796e+03_r8,0.11576e+04_r8 /)
      kbo(:, 4,44,11) = (/ &
        & 0.10360e+04_r8,0.78599e+03_r8,0.59655e+03_r8,0.87632e+03_r8,0.11562e+04_r8 /)
      kbo(:, 5,44,11) = (/ &
        & 0.10364e+04_r8,0.78610e+03_r8,0.59556e+03_r8,0.87451e+03_r8,0.11545e+04_r8 /)
      kbo(:, 1,45,11) = (/ &
        & 0.10355e+04_r8,0.78552e+03_r8,0.59982e+03_r8,0.88100e+03_r8,0.11621e+04_r8 /)
      kbo(:, 2,45,11) = (/ &
        & 0.10357e+04_r8,0.78527e+03_r8,0.59887e+03_r8,0.87975e+03_r8,0.11605e+04_r8 /)
      kbo(:, 3,45,11) = (/ &
        & 0.10358e+04_r8,0.78432e+03_r8,0.59788e+03_r8,0.87848e+03_r8,0.11586e+04_r8 /)
      kbo(:, 4,45,11) = (/ &
        & 0.10358e+04_r8,0.78597e+03_r8,0.59689e+03_r8,0.87689e+03_r8,0.11568e+04_r8 /)
      kbo(:, 5,45,11) = (/ &
        & 0.10353e+04_r8,0.78525e+03_r8,0.59589e+03_r8,0.87514e+03_r8,0.11551e+04_r8 /)
      kbo(:, 1,46,11) = (/ &
        & 0.10358e+04_r8,0.78503e+03_r8,0.60010e+03_r8,0.88136e+03_r8,0.11629e+04_r8 /)
      kbo(:, 2,46,11) = (/ &
        & 0.10366e+04_r8,0.78667e+03_r8,0.59923e+03_r8,0.88004e+03_r8,0.11611e+04_r8 /)
      kbo(:, 3,46,11) = (/ &
        & 0.10372e+04_r8,0.78560e+03_r8,0.59824e+03_r8,0.87915e+03_r8,0.11593e+04_r8 /)
      kbo(:, 4,46,11) = (/ &
        & 0.10348e+04_r8,0.78513e+03_r8,0.59725e+03_r8,0.87748e+03_r8,0.11574e+04_r8 /)
      kbo(:, 5,46,11) = (/ &
        & 0.10372e+04_r8,0.78595e+03_r8,0.59625e+03_r8,0.87592e+03_r8,0.11557e+04_r8 /)
      kbo(:, 1,47,11) = (/ &
        & 0.10352e+04_r8,0.78466e+03_r8,0.60059e+03_r8,0.88175e+03_r8,0.11637e+04_r8 /)
      kbo(:, 2,47,11) = (/ &
        & 0.10362e+04_r8,0.78477e+03_r8,0.59970e+03_r8,0.88075e+03_r8,0.11618e+04_r8 /)
      kbo(:, 3,47,11) = (/ &
        & 0.10362e+04_r8,0.78559e+03_r8,0.59863e+03_r8,0.87958e+03_r8,0.11601e+04_r8 /)
      kbo(:, 4,47,11) = (/ &
        & 0.10356e+04_r8,0.78476e+03_r8,0.59765e+03_r8,0.87812e+03_r8,0.11581e+04_r8 /)
      kbo(:, 5,47,11) = (/ &
        & 0.10361e+04_r8,0.78428e+03_r8,0.59665e+03_r8,0.87649e+03_r8,0.11564e+04_r8 /)
      kbo(:, 1,48,11) = (/ &
        & 0.10354e+04_r8,0.78500e+03_r8,0.60042e+03_r8,0.88214e+03_r8,0.11645e+04_r8 /)
      kbo(:, 2,48,11) = (/ &
        & 0.10348e+04_r8,0.78582e+03_r8,0.59995e+03_r8,0.88117e+03_r8,0.11625e+04_r8 /)
      kbo(:, 3,48,11) = (/ &
        & 0.10353e+04_r8,0.78569e+03_r8,0.59903e+03_r8,0.87942e+03_r8,0.11608e+04_r8 /)
      kbo(:, 4,48,11) = (/ &
        & 0.10359e+04_r8,0.78569e+03_r8,0.59804e+03_r8,0.87873e+03_r8,0.11589e+04_r8 /)
      kbo(:, 5,48,11) = (/ &
        & 0.10354e+04_r8,0.78509e+03_r8,0.59705e+03_r8,0.87716e+03_r8,0.11570e+04_r8 /)
      kbo(:, 1,49,11) = (/ &
        & 0.10362e+04_r8,0.78463e+03_r8,0.60042e+03_r8,0.88242e+03_r8,0.11657e+04_r8 /)
      kbo(:, 2,49,11) = (/ &
        & 0.10367e+04_r8,0.78580e+03_r8,0.60023e+03_r8,0.88156e+03_r8,0.11633e+04_r8 /)
      kbo(:, 3,49,11) = (/ &
        & 0.10373e+04_r8,0.78533e+03_r8,0.59942e+03_r8,0.88054e+03_r8,0.11615e+04_r8 /)
      kbo(:, 4,49,11) = (/ &
        & 0.10373e+04_r8,0.78462e+03_r8,0.59844e+03_r8,0.87918e+03_r8,0.11595e+04_r8 /)
      kbo(:, 5,49,11) = (/ &
        & 0.10370e+04_r8,0.78532e+03_r8,0.59736e+03_r8,0.87781e+03_r8,0.11578e+04_r8 /)
      kbo(:, 1,50,11) = (/ &
        & 0.10356e+04_r8,0.78474e+03_r8,0.60056e+03_r8,0.88267e+03_r8,0.11666e+04_r8 /)
      kbo(:, 2,50,11) = (/ &
        & 0.10370e+04_r8,0.78497e+03_r8,0.60046e+03_r8,0.88192e+03_r8,0.11642e+04_r8 /)
      kbo(:, 3,50,11) = (/ &
        & 0.10348e+04_r8,0.78508e+03_r8,0.59977e+03_r8,0.88094e+03_r8,0.11634e+04_r8 /)
      kbo(:, 4,50,11) = (/ &
        & 0.10352e+04_r8,0.78473e+03_r8,0.59881e+03_r8,0.87954e+03_r8,0.11604e+04_r8 /)
      kbo(:, 5,50,11) = (/ &
        & 0.10360e+04_r8,0.78437e+03_r8,0.59782e+03_r8,0.87840e+03_r8,0.11585e+04_r8 /)
      kbo(:, 1,51,11) = (/ &
        & 0.10365e+04_r8,0.78532e+03_r8,0.60054e+03_r8,0.88306e+03_r8,0.11674e+04_r8 /)
      kbo(:, 2,51,11) = (/ &
        & 0.10360e+04_r8,0.78555e+03_r8,0.60046e+03_r8,0.88226e+03_r8,0.11651e+04_r8 /)
      kbo(:, 3,51,11) = (/ &
        & 0.10359e+04_r8,0.78508e+03_r8,0.60006e+03_r8,0.88131e+03_r8,0.11628e+04_r8 /)
      kbo(:, 4,51,11) = (/ &
        & 0.10359e+04_r8,0.78554e+03_r8,0.59917e+03_r8,0.88011e+03_r8,0.11610e+04_r8 /)
      kbo(:, 5,51,11) = (/ &
        & 0.10363e+04_r8,0.78507e+03_r8,0.59818e+03_r8,0.87894e+03_r8,0.11592e+04_r8 /)
      kbo(:, 1,52,11) = (/ &
        & 0.10357e+04_r8,0.78531e+03_r8,0.60048e+03_r8,0.88333e+03_r8,0.11687e+04_r8 /)
      kbo(:, 2,52,11) = (/ &
        & 0.10368e+04_r8,0.78554e+03_r8,0.60053e+03_r8,0.88249e+03_r8,0.11660e+04_r8 /)
      kbo(:, 3,52,11) = (/ &
        & 0.10362e+04_r8,0.78601e+03_r8,0.60037e+03_r8,0.88166e+03_r8,0.11635e+04_r8 /)
      kbo(:, 4,52,11) = (/ &
        & 0.10354e+04_r8,0.78507e+03_r8,0.59952e+03_r8,0.88066e+03_r8,0.11617e+04_r8 /)
      kbo(:, 5,52,11) = (/ &
        & 0.10363e+04_r8,0.78565e+03_r8,0.59854e+03_r8,0.87959e+03_r8,0.11599e+04_r8 /)
      kbo(:, 1,53,11) = (/ &
        & 0.10366e+04_r8,0.78460e+03_r8,0.60030e+03_r8,0.88415e+03_r8,0.11699e+04_r8 /)
      kbo(:, 2,53,11) = (/ &
        & 0.10366e+04_r8,0.78400e+03_r8,0.60056e+03_r8,0.88262e+03_r8,0.11668e+04_r8 /)
      kbo(:, 3,53,11) = (/ &
        & 0.10358e+04_r8,0.78459e+03_r8,0.60039e+03_r8,0.88202e+03_r8,0.11644e+04_r8 /)
      kbo(:, 4,53,11) = (/ &
        & 0.10348e+04_r8,0.78471e+03_r8,0.59985e+03_r8,0.88104e+03_r8,0.11623e+04_r8 /)
      kbo(:, 5,53,11) = (/ &
        & 0.10366e+04_r8,0.78577e+03_r8,0.59891e+03_r8,0.87992e+03_r8,0.11606e+04_r8 /)
      kbo(:, 1,54,11) = (/ &
        & 0.10355e+04_r8,0.78471e+03_r8,0.60033e+03_r8,0.88501e+03_r8,0.11708e+04_r8 /)
      kbo(:, 2,54,11) = (/ &
        & 0.10360e+04_r8,0.78494e+03_r8,0.60053e+03_r8,0.88313e+03_r8,0.11678e+04_r8 /)
      kbo(:, 3,54,11) = (/ &
        & 0.10360e+04_r8,0.78671e+03_r8,0.60047e+03_r8,0.88230e+03_r8,0.11652e+04_r8 /)
      kbo(:, 4,54,11) = (/ &
        & 0.10355e+04_r8,0.78588e+03_r8,0.60010e+03_r8,0.88137e+03_r8,0.11629e+04_r8 /)
      kbo(:, 5,54,11) = (/ &
        & 0.10357e+04_r8,0.78517e+03_r8,0.59924e+03_r8,0.88032e+03_r8,0.11612e+04_r8 /)
      kbo(:, 1,55,11) = (/ &
        & 0.10357e+04_r8,0.78506e+03_r8,0.60035e+03_r8,0.88567e+03_r8,0.11714e+04_r8 /)
      kbo(:, 2,55,11) = (/ &
        & 0.10357e+04_r8,0.78518e+03_r8,0.60047e+03_r8,0.88349e+03_r8,0.11688e+04_r8 /)
      kbo(:, 3,55,11) = (/ &
        & 0.10361e+04_r8,0.78517e+03_r8,0.60053e+03_r8,0.88250e+03_r8,0.11660e+04_r8 /)
      kbo(:, 4,55,11) = (/ &
        & 0.10357e+04_r8,0.78529e+03_r8,0.60029e+03_r8,0.88168e+03_r8,0.11636e+04_r8 /)
      kbo(:, 5,55,11) = (/ &
        & 0.10360e+04_r8,0.78529e+03_r8,0.59954e+03_r8,0.88068e+03_r8,0.11617e+04_r8 /)
      kbo(:, 1,56,11) = (/ &
        & 0.10361e+04_r8,0.78494e+03_r8,0.60049e+03_r8,0.88607e+03_r8,0.11718e+04_r8 /)
      kbo(:, 2,56,11) = (/ &
        & 0.10360e+04_r8,0.78482e+03_r8,0.60030e+03_r8,0.88410e+03_r8,0.11698e+04_r8 /)
      kbo(:, 3,56,11) = (/ &
        & 0.10354e+04_r8,0.78493e+03_r8,0.60056e+03_r8,0.88273e+03_r8,0.11667e+04_r8 /)
      kbo(:, 4,56,11) = (/ &
        & 0.10357e+04_r8,0.78552e+03_r8,0.60038e+03_r8,0.88199e+03_r8,0.11645e+04_r8 /)
      kbo(:, 5,56,11) = (/ &
        & 0.10357e+04_r8,0.78517e+03_r8,0.59983e+03_r8,0.88101e+03_r8,0.11624e+04_r8 /)
      kbo(:, 1,57,11) = (/ &
        & 0.10357e+04_r8,0.78588e+03_r8,0.60099e+03_r8,0.88686e+03_r8,0.11725e+04_r8 /)
      kbo(:, 2,57,11) = (/ &
        & 0.10366e+04_r8,0.78458e+03_r8,0.60033e+03_r8,0.88491e+03_r8,0.11707e+04_r8 /)
      kbo(:, 3,57,11) = (/ &
        & 0.10366e+04_r8,0.78481e+03_r8,0.60053e+03_r8,0.88335e+03_r8,0.11676e+04_r8 /)
      kbo(:, 4,57,11) = (/ &
        & 0.10358e+04_r8,0.78611e+03_r8,0.60046e+03_r8,0.88227e+03_r8,0.11650e+04_r8 /)
      kbo(:, 5,57,11) = (/ &
        & 0.10355e+04_r8,0.78599e+03_r8,0.60008e+03_r8,0.88133e+03_r8,0.11630e+04_r8 /)
      kbo(:, 1,58,11) = (/ &
        & 0.10363e+04_r8,0.78576e+03_r8,0.60143e+03_r8,0.88764e+03_r8,0.11733e+04_r8 /)
      kbo(:, 2,58,11) = (/ &
        & 0.10354e+04_r8,0.78611e+03_r8,0.60042e+03_r8,0.88557e+03_r8,0.11713e+04_r8 /)
      kbo(:, 3,58,11) = (/ &
        & 0.10363e+04_r8,0.78576e+03_r8,0.60048e+03_r8,0.88329e+03_r8,0.11686e+04_r8 /)
      kbo(:, 4,58,11) = (/ &
        & 0.10364e+04_r8,0.78505e+03_r8,0.60052e+03_r8,0.88247e+03_r8,0.11659e+04_r8 /)
      kbo(:, 5,58,11) = (/ &
        & 0.10357e+04_r8,0.78552e+03_r8,0.60026e+03_r8,0.88163e+03_r8,0.11633e+04_r8 /)
      kbo(:, 1,59,11) = (/ &
        & 0.10354e+04_r8,0.78634e+03_r8,0.60176e+03_r8,0.88797e+03_r8,0.11736e+04_r8 /)
      kbo(:, 2,59,11) = (/ &
        & 0.10350e+04_r8,0.78505e+03_r8,0.60038e+03_r8,0.88577e+03_r8,0.11715e+04_r8 /)
      kbo(:, 3,59,11) = (/ &
        & 0.10360e+04_r8,0.78469e+03_r8,0.60046e+03_r8,0.88358e+03_r8,0.11703e+04_r8 /)
      kbo(:, 4,59,11) = (/ &
        & 0.10357e+04_r8,0.78493e+03_r8,0.60045e+03_r8,0.88254e+03_r8,0.11662e+04_r8 /)
      kbo(:, 5,59,11) = (/ &
        & 0.10366e+04_r8,0.78516e+03_r8,0.60041e+03_r8,0.88174e+03_r8,0.11637e+04_r8 /)
      kbo(:, 1,13,12) = (/ &
        & 0.11535e+04_r8,0.87955e+03_r8,0.60434e+03_r8,0.88744e+03_r8,0.11710e+04_r8 /)
      kbo(:, 2,13,12) = (/ &
        & 0.11485e+04_r8,0.86886e+03_r8,0.60369e+03_r8,0.88598e+03_r8,0.11697e+04_r8 /)
      kbo(:, 3,13,12) = (/ &
        & 0.11395e+04_r8,0.86441e+03_r8,0.60332e+03_r8,0.88477e+03_r8,0.11680e+04_r8 /)
      kbo(:, 4,13,12) = (/ &
        & 0.11350e+04_r8,0.86216e+03_r8,0.60276e+03_r8,0.88294e+03_r8,0.11659e+04_r8 /)
      kbo(:, 5,13,12) = (/ &
        & 0.11237e+04_r8,0.85514e+03_r8,0.60186e+03_r8,0.88131e+03_r8,0.11640e+04_r8 /)
      kbo(:, 1,14,12) = (/ &
        & 0.11312e+04_r8,0.85960e+03_r8,0.60391e+03_r8,0.88683e+03_r8,0.11708e+04_r8 /)
      kbo(:, 2,14,12) = (/ &
        & 0.11248e+04_r8,0.85192e+03_r8,0.60329e+03_r8,0.88591e+03_r8,0.11696e+04_r8 /)
      kbo(:, 3,14,12) = (/ &
        & 0.11210e+04_r8,0.84824e+03_r8,0.60297e+03_r8,0.88444e+03_r8,0.11678e+04_r8 /)
      kbo(:, 4,14,12) = (/ &
        & 0.11139e+04_r8,0.84322e+03_r8,0.60241e+03_r8,0.88264e+03_r8,0.11657e+04_r8 /)
      kbo(:, 5,14,12) = (/ &
        & 0.11123e+04_r8,0.84158e+03_r8,0.60150e+03_r8,0.88104e+03_r8,0.11639e+04_r8 /)
      kbo(:, 1,15,12) = (/ &
        & 0.11159e+04_r8,0.84414e+03_r8,0.60344e+03_r8,0.88657e+03_r8,0.11715e+04_r8 /)
      kbo(:, 2,15,12) = (/ &
        & 0.11106e+04_r8,0.84043e+03_r8,0.60296e+03_r8,0.88568e+03_r8,0.11695e+04_r8 /)
      kbo(:, 3,15,12) = (/ &
        & 0.11018e+04_r8,0.83588e+03_r8,0.60268e+03_r8,0.88413e+03_r8,0.11676e+04_r8 /)
      kbo(:, 4,15,12) = (/ &
        & 0.10976e+04_r8,0.83213e+03_r8,0.60210e+03_r8,0.88235e+03_r8,0.11655e+04_r8 /)
      kbo(:, 5,15,12) = (/ &
        & 0.10965e+04_r8,0.83273e+03_r8,0.60128e+03_r8,0.88077e+03_r8,0.11639e+04_r8 /)
      kbo(:, 1,16,12) = (/ &
        & 0.11003e+04_r8,0.83414e+03_r8,0.60325e+03_r8,0.88634e+03_r8,0.11705e+04_r8 /)
      kbo(:, 2,16,12) = (/ &
        & 0.10991e+04_r8,0.82921e+03_r8,0.60259e+03_r8,0.88546e+03_r8,0.11694e+04_r8 /)
      kbo(:, 3,16,12) = (/ &
        & 0.10955e+04_r8,0.82665e+03_r8,0.60243e+03_r8,0.88384e+03_r8,0.11674e+04_r8 /)
      kbo(:, 4,16,12) = (/ &
        & 0.10851e+04_r8,0.82401e+03_r8,0.60183e+03_r8,0.88207e+03_r8,0.11653e+04_r8 /)
      kbo(:, 5,16,12) = (/ &
        & 0.10849e+04_r8,0.82356e+03_r8,0.60085e+03_r8,0.88053e+03_r8,0.11635e+04_r8 /)
      kbo(:, 1,17,12) = (/ &
        & 0.10876e+04_r8,0.82527e+03_r8,0.60299e+03_r8,0.88614e+03_r8,0.11702e+04_r8 /)
      kbo(:, 2,17,12) = (/ &
        & 0.10859e+04_r8,0.82135e+03_r8,0.60250e+03_r8,0.88526e+03_r8,0.11692e+04_r8 /)
      kbo(:, 3,17,12) = (/ &
        & 0.10841e+04_r8,0.81891e+03_r8,0.60222e+03_r8,0.88356e+03_r8,0.11671e+04_r8 /)
      kbo(:, 4,17,12) = (/ &
        & 0.10784e+04_r8,0.81708e+03_r8,0.60159e+03_r8,0.88183e+03_r8,0.11651e+04_r8 /)
      kbo(:, 5,17,12) = (/ &
        & 0.10763e+04_r8,0.81350e+03_r8,0.60170e+03_r8,0.88030e+03_r8,0.11634e+04_r8 /)
      kbo(:, 1,18,12) = (/ &
        & 0.10781e+04_r8,0.81748e+03_r8,0.60276e+03_r8,0.88597e+03_r8,0.11700e+04_r8 /)
      kbo(:, 2,18,12) = (/ &
        & 0.10771e+04_r8,0.81396e+03_r8,0.60232e+03_r8,0.88573e+03_r8,0.11691e+04_r8 /)
      kbo(:, 3,18,12) = (/ &
        & 0.10718e+04_r8,0.81415e+03_r8,0.60204e+03_r8,0.88331e+03_r8,0.11669e+04_r8 /)
      kbo(:, 4,18,12) = (/ &
        & 0.10689e+04_r8,0.81027e+03_r8,0.60137e+03_r8,0.88144e+03_r8,0.11649e+04_r8 /)
      kbo(:, 5,18,12) = (/ &
        & 0.10691e+04_r8,0.80937e+03_r8,0.60029e+03_r8,0.88009e+03_r8,0.11632e+04_r8 /)
      kbo(:, 1,19,12) = (/ &
        & 0.10732e+04_r8,0.81093e+03_r8,0.60257e+03_r8,0.88582e+03_r8,0.11702e+04_r8 /)
      kbo(:, 2,19,12) = (/ &
        & 0.10665e+04_r8,0.81093e+03_r8,0.60218e+03_r8,0.88486e+03_r8,0.11689e+04_r8 /)
      kbo(:, 3,19,12) = (/ &
        & 0.10668e+04_r8,0.80596e+03_r8,0.60188e+03_r8,0.88291e+03_r8,0.11667e+04_r8 /)
      kbo(:, 4,19,12) = (/ &
        & 0.10625e+04_r8,0.80871e+03_r8,0.60129e+03_r8,0.88139e+03_r8,0.11647e+04_r8 /)
      kbo(:, 5,19,12) = (/ &
        & 0.10641e+04_r8,0.80549e+03_r8,0.60005e+03_r8,0.87990e+03_r8,0.11631e+04_r8 /)
      kbo(:, 1,20,12) = (/ &
        & 0.10655e+04_r8,0.80608e+03_r8,0.60228e+03_r8,0.88568e+03_r8,0.11700e+04_r8 /)
      kbo(:, 2,20,12) = (/ &
        & 0.10621e+04_r8,0.80582e+03_r8,0.60205e+03_r8,0.88462e+03_r8,0.11686e+04_r8 /)
      kbo(:, 3,20,12) = (/ &
        & 0.10596e+04_r8,0.80439e+03_r8,0.60161e+03_r8,0.88282e+03_r8,0.11664e+04_r8 /)
      kbo(:, 4,20,12) = (/ &
        & 0.10569e+04_r8,0.80052e+03_r8,0.60133e+03_r8,0.88084e+03_r8,0.11645e+04_r8 /)
      kbo(:, 5,20,12) = (/ &
        & 0.10576e+04_r8,0.80029e+03_r8,0.59980e+03_r8,0.87969e+03_r8,0.11629e+04_r8 /)
      kbo(:, 1,21,12) = (/ &
        & 0.10601e+04_r8,0.80047e+03_r8,0.60235e+03_r8,0.88539e+03_r8,0.11699e+04_r8 /)
      kbo(:, 2,21,12) = (/ &
        & 0.10553e+04_r8,0.80126e+03_r8,0.60195e+03_r8,0.88437e+03_r8,0.11684e+04_r8 /)
      kbo(:, 3,21,12) = (/ &
        & 0.10581e+04_r8,0.79916e+03_r8,0.60159e+03_r8,0.88257e+03_r8,0.11662e+04_r8 /)
      kbo(:, 4,21,12) = (/ &
        & 0.10523e+04_r8,0.79871e+03_r8,0.60090e+03_r8,0.88096e+03_r8,0.11643e+04_r8 /)
      kbo(:, 5,21,12) = (/ &
        & 0.10536e+04_r8,0.79852e+03_r8,0.59957e+03_r8,0.87950e+03_r8,0.11627e+04_r8 /)
      kbo(:, 1,22,12) = (/ &
        & 0.10543e+04_r8,0.79995e+03_r8,0.60207e+03_r8,0.88538e+03_r8,0.11697e+04_r8 /)
      kbo(:, 2,22,12) = (/ &
        & 0.10531e+04_r8,0.79794e+03_r8,0.60195e+03_r8,0.88401e+03_r8,0.11680e+04_r8 /)
      kbo(:, 3,22,12) = (/ &
        & 0.10510e+04_r8,0.79590e+03_r8,0.60141e+03_r8,0.88205e+03_r8,0.11658e+04_r8 /)
      kbo(:, 4,22,12) = (/ &
        & 0.10516e+04_r8,0.79518e+03_r8,0.60121e+03_r8,0.88065e+03_r8,0.11640e+04_r8 /)
      kbo(:, 5,22,12) = (/ &
        & 0.10507e+04_r8,0.79514e+03_r8,0.59925e+03_r8,0.87922e+03_r8,0.11625e+04_r8 /)
      kbo(:, 1,23,12) = (/ &
        & 0.10496e+04_r8,0.79686e+03_r8,0.60138e+03_r8,0.88518e+03_r8,0.11695e+04_r8 /)
      kbo(:, 2,23,12) = (/ &
        & 0.10500e+04_r8,0.79504e+03_r8,0.60174e+03_r8,0.88363e+03_r8,0.11675e+04_r8 /)
      kbo(:, 3,23,12) = (/ &
        & 0.10497e+04_r8,0.79559e+03_r8,0.60122e+03_r8,0.88187e+03_r8,0.11654e+04_r8 /)
      kbo(:, 4,23,12) = (/ &
        & 0.10478e+04_r8,0.79456e+03_r8,0.60013e+03_r8,0.88034e+03_r8,0.11637e+04_r8 /)
      kbo(:, 5,23,12) = (/ &
        & 0.10481e+04_r8,0.79269e+03_r8,0.59893e+03_r8,0.87894e+03_r8,0.11623e+04_r8 /)
      kbo(:, 1,24,12) = (/ &
        & 0.10504e+04_r8,0.79322e+03_r8,0.60186e+03_r8,0.88494e+03_r8,0.11692e+04_r8 /)
      kbo(:, 2,24,12) = (/ &
        & 0.10474e+04_r8,0.79292e+03_r8,0.60174e+03_r8,0.88325e+03_r8,0.11671e+04_r8 /)
      kbo(:, 3,24,12) = (/ &
        & 0.10457e+04_r8,0.79315e+03_r8,0.60103e+03_r8,0.88153e+03_r8,0.11648e+04_r8 /)
      kbo(:, 4,24,12) = (/ &
        & 0.10462e+04_r8,0.79329e+03_r8,0.59996e+03_r8,0.88003e+03_r8,0.11633e+04_r8 /)
      kbo(:, 5,24,12) = (/ &
        & 0.10477e+04_r8,0.79348e+03_r8,0.59860e+03_r8,0.87867e+03_r8,0.11620e+04_r8 /)
      kbo(:, 1,25,12) = (/ &
        & 0.10437e+04_r8,0.79315e+03_r8,0.60179e+03_r8,0.88497e+03_r8,0.11688e+04_r8 /)
      kbo(:, 2,25,12) = (/ &
        & 0.10446e+04_r8,0.79177e+03_r8,0.60151e+03_r8,0.88285e+03_r8,0.11666e+04_r8 /)
      kbo(:, 3,25,12) = (/ &
        & 0.10443e+04_r8,0.79105e+03_r8,0.60081e+03_r8,0.88119e+03_r8,0.11647e+04_r8 /)
      kbo(:, 4,25,12) = (/ &
        & 0.10440e+04_r8,0.79204e+03_r8,0.59965e+03_r8,0.87971e+03_r8,0.11630e+04_r8 /)
      kbo(:, 5,25,12) = (/ &
        & 0.10441e+04_r8,0.79141e+03_r8,0.59825e+03_r8,0.87840e+03_r8,0.11618e+04_r8 /)
      kbo(:, 1,26,12) = (/ &
        & 0.10444e+04_r8,0.79040e+03_r8,0.60171e+03_r8,0.88422e+03_r8,0.11681e+04_r8 /)
      kbo(:, 2,26,12) = (/ &
        & 0.10415e+04_r8,0.78987e+03_r8,0.60136e+03_r8,0.88243e+03_r8,0.11661e+04_r8 /)
      kbo(:, 3,26,12) = (/ &
        & 0.10417e+04_r8,0.79014e+03_r8,0.60043e+03_r8,0.88082e+03_r8,0.11642e+04_r8 /)
      kbo(:, 4,26,12) = (/ &
        & 0.10442e+04_r8,0.78985e+03_r8,0.59932e+03_r8,0.87937e+03_r8,0.11625e+04_r8 /)
      kbo(:, 5,26,12) = (/ &
        & 0.10421e+04_r8,0.79004e+03_r8,0.59787e+03_r8,0.87814e+03_r8,0.11615e+04_r8 /)
      kbo(:, 1,27,12) = (/ &
        & 0.10431e+04_r8,0.78868e+03_r8,0.60163e+03_r8,0.88378e+03_r8,0.11678e+04_r8 /)
      kbo(:, 2,27,12) = (/ &
        & 0.10423e+04_r8,0.79138e+03_r8,0.60118e+03_r8,0.88201e+03_r8,0.11657e+04_r8 /)
      kbo(:, 3,27,12) = (/ &
        & 0.10404e+04_r8,0.78916e+03_r8,0.60037e+03_r8,0.88046e+03_r8,0.11638e+04_r8 /)
      kbo(:, 4,27,12) = (/ &
        & 0.10405e+04_r8,0.78893e+03_r8,0.59897e+03_r8,0.87905e+03_r8,0.11624e+04_r8 /)
      kbo(:, 5,27,12) = (/ &
        & 0.10396e+04_r8,0.78917e+03_r8,0.59748e+03_r8,0.87790e+03_r8,0.11613e+04_r8 /)
      kbo(:, 1,28,12) = (/ &
        & 0.10409e+04_r8,0.79152e+03_r8,0.60155e+03_r8,0.88334e+03_r8,0.11673e+04_r8 /)
      kbo(:, 2,28,12) = (/ &
        & 0.10439e+04_r8,0.78963e+03_r8,0.60099e+03_r8,0.88127e+03_r8,0.11652e+04_r8 /)
      kbo(:, 3,28,12) = (/ &
        & 0.10423e+04_r8,0.78823e+03_r8,0.60006e+03_r8,0.88010e+03_r8,0.11635e+04_r8 /)
      kbo(:, 4,28,12) = (/ &
        & 0.10442e+04_r8,0.78834e+03_r8,0.59861e+03_r8,0.87873e+03_r8,0.11621e+04_r8 /)
      kbo(:, 5,28,12) = (/ &
        & 0.10392e+04_r8,0.79042e+03_r8,0.59708e+03_r8,0.87768e+03_r8,0.11610e+04_r8 /)
      kbo(:, 1,29,12) = (/ &
        & 0.10405e+04_r8,0.79019e+03_r8,0.60167e+03_r8,0.88289e+03_r8,0.11667e+04_r8 /)
      kbo(:, 2,29,12) = (/ &
        & 0.10432e+04_r8,0.78865e+03_r8,0.60111e+03_r8,0.88122e+03_r8,0.11647e+04_r8 /)
      kbo(:, 3,29,12) = (/ &
        & 0.10406e+04_r8,0.78834e+03_r8,0.59962e+03_r8,0.87974e+03_r8,0.11631e+04_r8 /)
      kbo(:, 4,29,12) = (/ &
        & 0.10397e+04_r8,0.78909e+03_r8,0.59824e+03_r8,0.87826e+03_r8,0.11618e+04_r8 /)
      kbo(:, 5,29,12) = (/ &
        & 0.10387e+04_r8,0.78925e+03_r8,0.59665e+03_r8,0.87746e+03_r8,0.11608e+04_r8 /)
      kbo(:, 1,30,12) = (/ &
        & 0.10411e+04_r8,0.78840e+03_r8,0.60130e+03_r8,0.88244e+03_r8,0.11662e+04_r8 /)
      kbo(:, 2,30,12) = (/ &
        & 0.10395e+04_r8,0.79020e+03_r8,0.60051e+03_r8,0.88083e+03_r8,0.11643e+04_r8 /)
      kbo(:, 3,30,12) = (/ &
        & 0.10384e+04_r8,0.78543e+03_r8,0.59928e+03_r8,0.87938e+03_r8,0.11627e+04_r8 /)
      kbo(:, 4,30,12) = (/ &
        & 0.10394e+04_r8,0.78756e+03_r8,0.59785e+03_r8,0.87814e+03_r8,0.11615e+04_r8 /)
      kbo(:, 5,30,12) = (/ &
        & 0.10383e+04_r8,0.78820e+03_r8,0.59620e+03_r8,0.87743e+03_r8,0.11605e+04_r8 /)
      kbo(:, 1,31,12) = (/ &
        & 0.10385e+04_r8,0.78703e+03_r8,0.60113e+03_r8,0.88199e+03_r8,0.11657e+04_r8 /)
      kbo(:, 2,31,12) = (/ &
        & 0.10401e+04_r8,0.79050e+03_r8,0.60021e+03_r8,0.88045e+03_r8,0.11639e+04_r8 /)
      kbo(:, 3,31,12) = (/ &
        & 0.10412e+04_r8,0.78681e+03_r8,0.59892e+03_r8,0.87903e+03_r8,0.11624e+04_r8 /)
      kbo(:, 4,31,12) = (/ &
        & 0.10385e+04_r8,0.78582e+03_r8,0.59732e+03_r8,0.87772e+03_r8,0.11613e+04_r8 /)
      kbo(:, 5,31,12) = (/ &
        & 0.10372e+04_r8,0.78947e+03_r8,0.59573e+03_r8,0.87705e+03_r8,0.11602e+04_r8 /)
      kbo(:, 1,32,12) = (/ &
        & 0.10378e+04_r8,0.78710e+03_r8,0.60105e+03_r8,0.88140e+03_r8,0.11652e+04_r8 /)
      kbo(:, 2,32,12) = (/ &
        & 0.10375e+04_r8,0.78506e+03_r8,0.59989e+03_r8,0.88006e+03_r8,0.11634e+04_r8 /)
      kbo(:, 3,32,12) = (/ &
        & 0.10409e+04_r8,0.78648e+03_r8,0.59855e+03_r8,0.87869e+03_r8,0.11621e+04_r8 /)
      kbo(:, 4,32,12) = (/ &
        & 0.10389e+04_r8,0.78640e+03_r8,0.59701e+03_r8,0.87765e+03_r8,0.11610e+04_r8 /)
      kbo(:, 5,32,12) = (/ &
        & 0.10378e+04_r8,0.78589e+03_r8,0.59527e+03_r8,0.87675e+03_r8,0.11598e+04_r8 /)
      kbo(:, 1,33,12) = (/ &
        & 0.10380e+04_r8,0.78620e+03_r8,0.60093e+03_r8,0.88116e+03_r8,0.11647e+04_r8 /)
      kbo(:, 2,33,12) = (/ &
        & 0.10383e+04_r8,0.78582e+03_r8,0.59966e+03_r8,0.87968e+03_r8,0.11631e+04_r8 /)
      kbo(:, 3,33,12) = (/ &
        & 0.10388e+04_r8,0.78740e+03_r8,0.59816e+03_r8,0.87838e+03_r8,0.11618e+04_r8 /)
      kbo(:, 4,33,12) = (/ &
        & 0.10367e+04_r8,0.78734e+03_r8,0.59657e+03_r8,0.87743e+03_r8,0.11608e+04_r8 /)
      kbo(:, 5,33,12) = (/ &
        & 0.10382e+04_r8,0.78803e+03_r8,0.59484e+03_r8,0.87630e+03_r8,0.11592e+04_r8 /)
      kbo(:, 1,34,12) = (/ &
        & 0.10390e+04_r8,0.78774e+03_r8,0.60058e+03_r8,0.88098e+03_r8,0.11643e+04_r8 /)
      kbo(:, 2,34,12) = (/ &
        & 0.10374e+04_r8,0.78664e+03_r8,0.59936e+03_r8,0.87936e+03_r8,0.11627e+04_r8 /)
      kbo(:, 3,34,12) = (/ &
        & 0.10352e+04_r8,0.78733e+03_r8,0.59781e+03_r8,0.87813e+03_r8,0.11615e+04_r8 /)
      kbo(:, 4,34,12) = (/ &
        & 0.10386e+04_r8,0.78609e+03_r8,0.59617e+03_r8,0.87742e+03_r8,0.11605e+04_r8 /)
      kbo(:, 5,34,12) = (/ &
        & 0.10400e+04_r8,0.78709e+03_r8,0.59476e+03_r8,0.87581e+03_r8,0.11592e+04_r8 /)
      kbo(:, 1,35,12) = (/ &
        & 0.10374e+04_r8,0.78486e+03_r8,0.60032e+03_r8,0.88061e+03_r8,0.11641e+04_r8 /)
      kbo(:, 2,35,12) = (/ &
        & 0.10385e+04_r8,0.78482e+03_r8,0.59906e+03_r8,0.87918e+03_r8,0.11626e+04_r8 /)
      kbo(:, 3,35,12) = (/ &
        & 0.10371e+04_r8,0.78627e+03_r8,0.59760e+03_r8,0.87799e+03_r8,0.11614e+04_r8 /)
      kbo(:, 4,35,12) = (/ &
        & 0.10378e+04_r8,0.78697e+03_r8,0.59593e+03_r8,0.87715e+03_r8,0.11604e+04_r8 /)
      kbo(:, 5,35,12) = (/ &
        & 0.10370e+04_r8,0.78545e+03_r8,0.59500e+03_r8,0.87549e+03_r8,0.11592e+04_r8 /)
      kbo(:, 1,36,12) = (/ &
        & 0.10362e+04_r8,0.78845e+03_r8,0.60029e+03_r8,0.88058e+03_r8,0.11640e+04_r8 /)
      kbo(:, 2,36,12) = (/ &
        & 0.10379e+04_r8,0.78676e+03_r8,0.59903e+03_r8,0.87915e+03_r8,0.11625e+04_r8 /)
      kbo(:, 3,36,12) = (/ &
        & 0.10369e+04_r8,0.78598e+03_r8,0.59768e+03_r8,0.87797e+03_r8,0.11614e+04_r8 /)
      kbo(:, 4,36,12) = (/ &
        & 0.10369e+04_r8,0.78595e+03_r8,0.59566e+03_r8,0.87713e+03_r8,0.11604e+04_r8 /)
      kbo(:, 5,36,12) = (/ &
        & 0.10368e+04_r8,0.78548e+03_r8,0.59464e+03_r8,0.87594e+03_r8,0.11600e+04_r8 /)
      kbo(:, 1,37,12) = (/ &
        & 0.10374e+04_r8,0.78579e+03_r8,0.60055e+03_r8,0.88077e+03_r8,0.11642e+04_r8 /)
      kbo(:, 2,37,12) = (/ &
        & 0.10362e+04_r8,0.78844e+03_r8,0.59921e+03_r8,0.87933e+03_r8,0.11627e+04_r8 /)
      kbo(:, 3,37,12) = (/ &
        & 0.10360e+04_r8,0.78603e+03_r8,0.59777e+03_r8,0.87810e+03_r8,0.11615e+04_r8 /)
      kbo(:, 4,37,12) = (/ &
        & 0.10367e+04_r8,0.78734e+03_r8,0.59623e+03_r8,0.87723e+03_r8,0.11605e+04_r8 /)
      kbo(:, 5,37,12) = (/ &
        & 0.10361e+04_r8,0.78702e+03_r8,0.59474e+03_r8,0.87592e+03_r8,0.11587e+04_r8 /)
      kbo(:, 1,38,12) = (/ &
        & 0.10367e+04_r8,0.78778e+03_r8,0.60058e+03_r8,0.88098e+03_r8,0.11645e+04_r8 /)
      kbo(:, 2,38,12) = (/ &
        & 0.10387e+04_r8,0.78865e+03_r8,0.59939e+03_r8,0.87952e+03_r8,0.11629e+04_r8 /)
      kbo(:, 3,38,12) = (/ &
        & 0.10363e+04_r8,0.78758e+03_r8,0.59820e+03_r8,0.87825e+03_r8,0.11617e+04_r8 /)
      kbo(:, 4,38,12) = (/ &
        & 0.10372e+04_r8,0.78786e+03_r8,0.59636e+03_r8,0.87717e+03_r8,0.11609e+04_r8 /)
      kbo(:, 5,38,12) = (/ &
        & 0.10362e+04_r8,0.78470e+03_r8,0.59485e+03_r8,0.87657e+03_r8,0.11589e+04_r8 /)
      kbo(:, 1,39,12) = (/ &
        & 0.10374e+04_r8,0.78680e+03_r8,0.60094e+03_r8,0.88119e+03_r8,0.11647e+04_r8 /)
      kbo(:, 2,39,12) = (/ &
        & 0.10352e+04_r8,0.78618e+03_r8,0.60014e+03_r8,0.87971e+03_r8,0.11631e+04_r8 /)
      kbo(:, 3,39,12) = (/ &
        & 0.10401e+04_r8,0.78497e+03_r8,0.59818e+03_r8,0.87840e+03_r8,0.11618e+04_r8 /)
      kbo(:, 4,39,12) = (/ &
        & 0.10369e+04_r8,0.78868e+03_r8,0.59660e+03_r8,0.87744e+03_r8,0.11608e+04_r8 /)
      kbo(:, 5,39,12) = (/ &
        & 0.10353e+04_r8,0.78494e+03_r8,0.59497e+03_r8,0.87635e+03_r8,0.11593e+04_r8 /)
      kbo(:, 1,40,12) = (/ &
        & 0.10385e+04_r8,0.78584e+03_r8,0.60091e+03_r8,0.88123e+03_r8,0.11652e+04_r8 /)
      kbo(:, 2,40,12) = (/ &
        & 0.10387e+04_r8,0.78568e+03_r8,0.59987e+03_r8,0.88006e+03_r8,0.11635e+04_r8 /)
      kbo(:, 3,40,12) = (/ &
        & 0.10371e+04_r8,0.78626e+03_r8,0.59853e+03_r8,0.87869e+03_r8,0.11621e+04_r8 /)
      kbo(:, 4,40,12) = (/ &
        & 0.10386e+04_r8,0.78684e+03_r8,0.59700e+03_r8,0.87748e+03_r8,0.11610e+04_r8 /)
      kbo(:, 5,40,12) = (/ &
        & 0.10362e+04_r8,0.78503e+03_r8,0.59526e+03_r8,0.87692e+03_r8,0.11598e+04_r8 /)
      kbo(:, 1,41,12) = (/ &
        & 0.10384e+04_r8,0.78504e+03_r8,0.60109e+03_r8,0.88198e+03_r8,0.11657e+04_r8 /)
      kbo(:, 2,41,12) = (/ &
        & 0.10360e+04_r8,0.78533e+03_r8,0.60017e+03_r8,0.88043e+03_r8,0.11639e+04_r8 /)
      kbo(:, 3,41,12) = (/ &
        & 0.10374e+04_r8,0.78412e+03_r8,0.59889e+03_r8,0.87902e+03_r8,0.11624e+04_r8 /)
      kbo(:, 4,41,12) = (/ &
        & 0.10350e+04_r8,0.78545e+03_r8,0.59741e+03_r8,0.87788e+03_r8,0.11613e+04_r8 /)
      kbo(:, 5,41,12) = (/ &
        & 0.10385e+04_r8,0.78529e+03_r8,0.59570e+03_r8,0.87704e+03_r8,0.11607e+04_r8 /)
      kbo(:, 1,42,12) = (/ &
        & 0.10370e+04_r8,0.78560e+03_r8,0.60125e+03_r8,0.88242e+03_r8,0.11662e+04_r8 /)
      kbo(:, 2,42,12) = (/ &
        & 0.10383e+04_r8,0.78469e+03_r8,0.60057e+03_r8,0.88081e+03_r8,0.11643e+04_r8 /)
      kbo(:, 3,42,12) = (/ &
        & 0.10368e+04_r8,0.78617e+03_r8,0.59924e+03_r8,0.87937e+03_r8,0.11627e+04_r8 /)
      kbo(:, 4,42,12) = (/ &
        & 0.10362e+04_r8,0.78586e+03_r8,0.59780e+03_r8,0.87813e+03_r8,0.11615e+04_r8 /)
      kbo(:, 5,42,12) = (/ &
        & 0.10350e+04_r8,0.78958e+03_r8,0.59616e+03_r8,0.87725e+03_r8,0.11605e+04_r8 /)
      kbo(:, 1,43,12) = (/ &
        & 0.10375e+04_r8,0.78586e+03_r8,0.60140e+03_r8,0.88280e+03_r8,0.11669e+04_r8 /)
      kbo(:, 2,43,12) = (/ &
        & 0.10344e+04_r8,0.78615e+03_r8,0.60088e+03_r8,0.88112e+03_r8,0.11651e+04_r8 /)
      kbo(:, 3,43,12) = (/ &
        & 0.10344e+04_r8,0.78345e+03_r8,0.59953e+03_r8,0.87980e+03_r8,0.11632e+04_r8 /)
      kbo(:, 4,43,12) = (/ &
        & 0.10347e+04_r8,0.78777e+03_r8,0.59827e+03_r8,0.87847e+03_r8,0.11619e+04_r8 /)
      kbo(:, 5,43,12) = (/ &
        & 0.10355e+04_r8,0.78627e+03_r8,0.59681e+03_r8,0.87766e+03_r8,0.11609e+04_r8 /)
      kbo(:, 1,44,12) = (/ &
        & 0.10355e+04_r8,0.78449e+03_r8,0.60162e+03_r8,0.88358e+03_r8,0.11676e+04_r8 /)
      kbo(:, 2,44,12) = (/ &
        & 0.10359e+04_r8,0.78627e+03_r8,0.60103e+03_r8,0.88182e+03_r8,0.11655e+04_r8 /)
      kbo(:, 3,44,12) = (/ &
        & 0.10377e+04_r8,0.78715e+03_r8,0.60005e+03_r8,0.88029e+03_r8,0.11637e+04_r8 /)
      kbo(:, 4,44,12) = (/ &
        & 0.10378e+04_r8,0.78625e+03_r8,0.59875e+03_r8,0.87890e+03_r8,0.11623e+04_r8 /)
      kbo(:, 5,44,12) = (/ &
        & 0.10374e+04_r8,0.78401e+03_r8,0.59725e+03_r8,0.87779e+03_r8,0.11612e+04_r8 /)
      kbo(:, 1,45,12) = (/ &
        & 0.10390e+04_r8,0.78655e+03_r8,0.60158e+03_r8,0.88419e+03_r8,0.11684e+04_r8 /)
      kbo(:, 2,45,12) = (/ &
        & 0.10396e+04_r8,0.78684e+03_r8,0.60124e+03_r8,0.88239e+03_r8,0.11662e+04_r8 /)
      kbo(:, 3,45,12) = (/ &
        & 0.10355e+04_r8,0.78758e+03_r8,0.60044e+03_r8,0.88079e+03_r8,0.11643e+04_r8 /)
      kbo(:, 4,45,12) = (/ &
        & 0.10368e+04_r8,0.78548e+03_r8,0.59922e+03_r8,0.87935e+03_r8,0.11627e+04_r8 /)
      kbo(:, 5,45,12) = (/ &
        & 0.10360e+04_r8,0.78578e+03_r8,0.59778e+03_r8,0.87811e+03_r8,0.11615e+04_r8 /)
      kbo(:, 1,46,12) = (/ &
        & 0.10390e+04_r8,0.78534e+03_r8,0.60165e+03_r8,0.88476e+03_r8,0.11691e+04_r8 /)
      kbo(:, 2,46,12) = (/ &
        & 0.10368e+04_r8,0.78339e+03_r8,0.60141e+03_r8,0.88303e+03_r8,0.11669e+04_r8 /)
      kbo(:, 3,46,12) = (/ &
        & 0.10364e+04_r8,0.78696e+03_r8,0.60079e+03_r8,0.88117e+03_r8,0.11649e+04_r8 /)
      kbo(:, 4,46,12) = (/ &
        & 0.10407e+04_r8,0.78666e+03_r8,0.59968e+03_r8,0.87985e+03_r8,0.11632e+04_r8 /)
      kbo(:, 5,46,12) = (/ &
        & 0.10344e+04_r8,0.78501e+03_r8,0.59832e+03_r8,0.87835e+03_r8,0.11619e+04_r8 /)
      kbo(:, 1,47,12) = (/ &
        & 0.10372e+04_r8,0.78547e+03_r8,0.60140e+03_r8,0.88518e+03_r8,0.11696e+04_r8 /)
      kbo(:, 2,47,12) = (/ &
        & 0.10368e+04_r8,0.78740e+03_r8,0.60142e+03_r8,0.88376e+03_r8,0.11678e+04_r8 /)
      kbo(:, 3,47,12) = (/ &
        & 0.10360e+04_r8,0.78411e+03_r8,0.60109e+03_r8,0.88198e+03_r8,0.11657e+04_r8 /)
      kbo(:, 4,47,12) = (/ &
        & 0.10358e+04_r8,0.78709e+03_r8,0.60017e+03_r8,0.88044e+03_r8,0.11639e+04_r8 /)
      kbo(:, 5,47,12) = (/ &
        & 0.10354e+04_r8,0.78664e+03_r8,0.59889e+03_r8,0.87902e+03_r8,0.11624e+04_r8 /)
      kbo(:, 1,48,12) = (/ &
        & 0.10362e+04_r8,0.78680e+03_r8,0.60195e+03_r8,0.88548e+03_r8,0.11701e+04_r8 /)
      kbo(:, 2,48,12) = (/ &
        & 0.10362e+04_r8,0.78545e+03_r8,0.60161e+03_r8,0.88447e+03_r8,0.11687e+04_r8 /)
      kbo(:, 3,48,12) = (/ &
        & 0.10378e+04_r8,0.78604e+03_r8,0.60144e+03_r8,0.88268e+03_r8,0.11665e+04_r8 /)
      kbo(:, 4,48,12) = (/ &
        & 0.10382e+04_r8,0.78544e+03_r8,0.60061e+03_r8,0.88104e+03_r8,0.11646e+04_r8 /)
      kbo(:, 5,48,12) = (/ &
        & 0.10364e+04_r8,0.78424e+03_r8,0.59943e+03_r8,0.87957e+03_r8,0.11630e+04_r8 /)
      kbo(:, 1,49,12) = (/ &
        & 0.10370e+04_r8,0.78693e+03_r8,0.60225e+03_r8,0.88600e+03_r8,0.11705e+04_r8 /)
      kbo(:, 2,49,12) = (/ &
        & 0.10356e+04_r8,0.78469e+03_r8,0.60169e+03_r8,0.88499e+03_r8,0.11694e+04_r8 /)
      kbo(:, 3,49,12) = (/ &
        & 0.10350e+04_r8,0.78588e+03_r8,0.60148e+03_r8,0.88340e+03_r8,0.11674e+04_r8 /)
      kbo(:, 4,49,12) = (/ &
        & 0.10352e+04_r8,0.78677e+03_r8,0.60095e+03_r8,0.88166e+03_r8,0.11653e+04_r8 /)
      kbo(:, 5,49,12) = (/ &
        & 0.10356e+04_r8,0.78647e+03_r8,0.59993e+03_r8,0.88015e+03_r8,0.11636e+04_r8 /)
      kbo(:, 1,50,12) = (/ &
        & 0.10356e+04_r8,0.78558e+03_r8,0.60226e+03_r8,0.88620e+03_r8,0.11712e+04_r8 /)
      kbo(:, 2,50,12) = (/ &
        & 0.10346e+04_r8,0.78796e+03_r8,0.60171e+03_r8,0.88533e+03_r8,0.11698e+04_r8 /)
      kbo(:, 3,50,12) = (/ &
        & 0.10366e+04_r8,0.78751e+03_r8,0.60168e+03_r8,0.88408e+03_r8,0.11667e+04_r8 /)
      kbo(:, 4,50,12) = (/ &
        & 0.10366e+04_r8,0.78646e+03_r8,0.60132e+03_r8,0.88229e+03_r8,0.11661e+04_r8 /)
      kbo(:, 5,50,12) = (/ &
        & 0.10393e+04_r8,0.78616e+03_r8,0.60083e+03_r8,0.88070e+03_r8,0.11642e+04_r8 /)
      kbo(:, 1,51,12) = (/ &
        & 0.10356e+04_r8,0.78468e+03_r8,0.60241e+03_r8,0.88644e+03_r8,0.11719e+04_r8 /)
      kbo(:, 2,51,12) = (/ &
        & 0.10368e+04_r8,0.78423e+03_r8,0.60203e+03_r8,0.88559e+03_r8,0.11702e+04_r8 /)
      kbo(:, 3,51,12) = (/ &
        & 0.10356e+04_r8,0.78586e+03_r8,0.60163e+03_r8,0.88469e+03_r8,0.11690e+04_r8 /)
      kbo(:, 4,51,12) = (/ &
        & 0.10358e+04_r8,0.78601e+03_r8,0.60139e+03_r8,0.88294e+03_r8,0.11668e+04_r8 /)
      kbo(:, 5,51,12) = (/ &
        & 0.10379e+04_r8,0.78646e+03_r8,0.60074e+03_r8,0.88126e+03_r8,0.11648e+04_r8 /)
      kbo(:, 1,52,12) = (/ &
        & 0.10383e+04_r8,0.78512e+03_r8,0.60257e+03_r8,0.88672e+03_r8,0.11727e+04_r8 /)
      kbo(:, 2,52,12) = (/ &
        & 0.10350e+04_r8,0.78646e+03_r8,0.60217e+03_r8,0.88594e+03_r8,0.11707e+04_r8 /)
      kbo(:, 3,52,12) = (/ &
        & 0.10358e+04_r8,0.78466e+03_r8,0.60160e+03_r8,0.88510e+03_r8,0.11695e+04_r8 /)
      kbo(:, 4,52,12) = (/ &
        & 0.10356e+04_r8,0.78511e+03_r8,0.60151e+03_r8,0.88359e+03_r8,0.11676e+04_r8 /)
      kbo(:, 5,52,12) = (/ &
        & 0.10365e+04_r8,0.78541e+03_r8,0.60103e+03_r8,0.88167e+03_r8,0.11655e+04_r8 /)
      kbo(:, 1,53,12) = (/ &
        & 0.10352e+04_r8,0.78496e+03_r8,0.60273e+03_r8,0.88710e+03_r8,0.11735e+04_r8 /)
      kbo(:, 2,53,12) = (/ &
        & 0.10359e+04_r8,0.78600e+03_r8,0.60229e+03_r8,0.88628e+03_r8,0.11714e+04_r8 /)
      kbo(:, 3,53,12) = (/ &
        & 0.10369e+04_r8,0.78526e+03_r8,0.60188e+03_r8,0.88540e+03_r8,0.11699e+04_r8 /)
      kbo(:, 4,53,12) = (/ &
        & 0.10383e+04_r8,0.78660e+03_r8,0.60159e+03_r8,0.88425e+03_r8,0.11685e+04_r8 /)
      kbo(:, 5,53,12) = (/ &
        & 0.10373e+04_r8,0.78555e+03_r8,0.60126e+03_r8,0.88246e+03_r8,0.11663e+04_r8 /)
      kbo(:, 1,54,12) = (/ &
        & 0.10367e+04_r8,0.78451e+03_r8,0.60297e+03_r8,0.88752e+03_r8,0.11746e+04_r8 /)
      kbo(:, 2,54,12) = (/ &
        & 0.10355e+04_r8,0.78600e+03_r8,0.60244e+03_r8,0.88648e+03_r8,0.11721e+04_r8 /)
      kbo(:, 3,54,12) = (/ &
        & 0.10348e+04_r8,0.78301e+03_r8,0.60206e+03_r8,0.88564e+03_r8,0.11703e+04_r8 /)
      kbo(:, 4,54,12) = (/ &
        & 0.10395e+04_r8,0.78629e+03_r8,0.60165e+03_r8,0.88477e+03_r8,0.11691e+04_r8 /)
      kbo(:, 5,54,12) = (/ &
        & 0.10361e+04_r8,0.78420e+03_r8,0.60141e+03_r8,0.88305e+03_r8,0.11670e+04_r8 /)
      kbo(:, 1,55,12) = (/ &
        & 0.10361e+04_r8,0.78555e+03_r8,0.60296e+03_r8,0.88822e+03_r8,0.11760e+04_r8 /)
      kbo(:, 2,55,12) = (/ &
        & 0.10355e+04_r8,0.78495e+03_r8,0.60258e+03_r8,0.88674e+03_r8,0.11727e+04_r8 /)
      kbo(:, 3,55,12) = (/ &
        & 0.10349e+04_r8,0.78525e+03_r8,0.60217e+03_r8,0.88596e+03_r8,0.11709e+04_r8 /)
      kbo(:, 4,55,12) = (/ &
        & 0.10361e+04_r8,0.78465e+03_r8,0.60184e+03_r8,0.88512e+03_r8,0.11696e+04_r8 /)
      kbo(:, 5,55,12) = (/ &
        & 0.10363e+04_r8,0.78599e+03_r8,0.60163e+03_r8,0.88363e+03_r8,0.11677e+04_r8 /)
      kbo(:, 1,56,12) = (/ &
        & 0.10361e+04_r8,0.78599e+03_r8,0.60309e+03_r8,0.88918e+03_r8,0.11774e+04_r8 /)
      kbo(:, 2,56,12) = (/ &
        & 0.10391e+04_r8,0.78674e+03_r8,0.60272e+03_r8,0.88707e+03_r8,0.11734e+04_r8 /)
      kbo(:, 3,56,12) = (/ &
        & 0.10363e+04_r8,0.78584e+03_r8,0.60228e+03_r8,0.88626e+03_r8,0.11716e+04_r8 /)
      kbo(:, 4,56,12) = (/ &
        & 0.10369e+04_r8,0.78509e+03_r8,0.60186e+03_r8,0.88538e+03_r8,0.11695e+04_r8 /)
      kbo(:, 5,56,12) = (/ &
        & 0.10363e+04_r8,0.78554e+03_r8,0.60158e+03_r8,0.88421e+03_r8,0.11682e+04_r8 /)
      kbo(:, 1,57,12) = (/ &
        & 0.10381e+04_r8,0.78509e+03_r8,0.60327e+03_r8,0.89026e+03_r8,0.11789e+04_r8 /)
      kbo(:, 2,57,12) = (/ &
        & 0.10344e+04_r8,0.78852e+03_r8,0.60284e+03_r8,0.88747e+03_r8,0.11744e+04_r8 /)
      kbo(:, 3,57,12) = (/ &
        & 0.10369e+04_r8,0.78509e+03_r8,0.60242e+03_r8,0.88612e+03_r8,0.11720e+04_r8 /)
      kbo(:, 4,57,12) = (/ &
        & 0.10393e+04_r8,0.78330e+03_r8,0.60216e+03_r8,0.88561e+03_r8,0.11703e+04_r8 /)
      kbo(:, 5,57,12) = (/ &
        & 0.10365e+04_r8,0.78494e+03_r8,0.60164e+03_r8,0.88472e+03_r8,0.11688e+04_r8 /)
      kbo(:, 1,58,12) = (/ &
        & 0.10353e+04_r8,0.78509e+03_r8,0.60357e+03_r8,0.89125e+03_r8,0.11802e+04_r8 /)
      kbo(:, 2,58,12) = (/ &
        & 0.10371e+04_r8,0.78524e+03_r8,0.60283e+03_r8,0.88807e+03_r8,0.11757e+04_r8 /)
      kbo(:, 3,58,12) = (/ &
        & 0.10365e+04_r8,0.78718e+03_r8,0.60278e+03_r8,0.88669e+03_r8,0.11726e+04_r8 /)
      kbo(:, 4,58,12) = (/ &
        & 0.10349e+04_r8,0.78673e+03_r8,0.60216e+03_r8,0.88590e+03_r8,0.11708e+04_r8 /)
      kbo(:, 5,58,12) = (/ &
        & 0.10365e+04_r8,0.78389e+03_r8,0.60170e+03_r8,0.88506e+03_r8,0.11695e+04_r8 /)
      kbo(:, 1,59,12) = (/ &
        & 0.10365e+04_r8,0.78390e+03_r8,0.60373e+03_r8,0.89165e+03_r8,0.11808e+04_r8 /)
      kbo(:, 2,59,12) = (/ &
        & 0.10369e+04_r8,0.78479e+03_r8,0.60298e+03_r8,0.88840e+03_r8,0.11763e+04_r8 /)
      kbo(:, 3,59,12) = (/ &
        & 0.10357e+04_r8,0.78703e+03_r8,0.60261e+03_r8,0.88680e+03_r8,0.11713e+04_r8 /)
      kbo(:, 4,59,12) = (/ &
        & 0.10363e+04_r8,0.78509e+03_r8,0.60219e+03_r8,0.88602e+03_r8,0.11708e+04_r8 /)
      kbo(:, 5,59,12) = (/ &
        & 0.10365e+04_r8,0.78479e+03_r8,0.60174e+03_r8,0.88517e+03_r8,0.11696e+04_r8 /)
      kbo(:, 1,13,13) = (/ &
        & 0.11661e+04_r8,0.87073e+03_r8,0.60556e+03_r8,0.88929e+03_r8,0.11761e+04_r8 /)
      kbo(:, 2,13,13) = (/ &
        & 0.11527e+04_r8,0.87014e+03_r8,0.60489e+03_r8,0.88914e+03_r8,0.11754e+04_r8 /)
      kbo(:, 3,13,13) = (/ &
        & 0.11423e+04_r8,0.85968e+03_r8,0.60419e+03_r8,0.88867e+03_r8,0.11747e+04_r8 /)
      kbo(:, 4,13,13) = (/ &
        & 0.11371e+04_r8,0.85890e+03_r8,0.60344e+03_r8,0.88820e+03_r8,0.11742e+04_r8 /)
      kbo(:, 5,13,13) = (/ &
        & 0.11390e+04_r8,0.85008e+03_r8,0.60234e+03_r8,0.88705e+03_r8,0.11727e+04_r8 /)
      kbo(:, 1,14,13) = (/ &
        & 0.11362e+04_r8,0.85805e+03_r8,0.60511e+03_r8,0.88957e+03_r8,0.11761e+04_r8 /)
      kbo(:, 2,14,13) = (/ &
        & 0.11276e+04_r8,0.85398e+03_r8,0.60448e+03_r8,0.88893e+03_r8,0.11753e+04_r8 /)
      kbo(:, 3,14,13) = (/ &
        & 0.11208e+04_r8,0.84888e+03_r8,0.60397e+03_r8,0.88854e+03_r8,0.11747e+04_r8 /)
      kbo(:, 4,14,13) = (/ &
        & 0.11194e+04_r8,0.85006e+03_r8,0.60305e+03_r8,0.88823e+03_r8,0.11740e+04_r8 /)
      kbo(:, 5,14,13) = (/ &
        & 0.11083e+04_r8,0.84212e+03_r8,0.60191e+03_r8,0.88682e+03_r8,0.11725e+04_r8 /)
      kbo(:, 1,15,13) = (/ &
        & 0.11142e+04_r8,0.84766e+03_r8,0.60488e+03_r8,0.88941e+03_r8,0.11748e+04_r8 /)
      kbo(:, 2,15,13) = (/ &
        & 0.11176e+04_r8,0.84112e+03_r8,0.60414e+03_r8,0.88873e+03_r8,0.11752e+04_r8 /)
      kbo(:, 3,15,13) = (/ &
        & 0.11051e+04_r8,0.84191e+03_r8,0.60348e+03_r8,0.88843e+03_r8,0.11747e+04_r8 /)
      kbo(:, 4,15,13) = (/ &
        & 0.11036e+04_r8,0.83753e+03_r8,0.60270e+03_r8,0.88781e+03_r8,0.11739e+04_r8 /)
      kbo(:, 5,15,13) = (/ &
        & 0.10935e+04_r8,0.82883e+03_r8,0.60139e+03_r8,0.88658e+03_r8,0.11723e+04_r8 /)
      kbo(:, 1,16,13) = (/ &
        & 0.11074e+04_r8,0.83456e+03_r8,0.60440e+03_r8,0.88927e+03_r8,0.11760e+04_r8 /)
      kbo(:, 2,16,13) = (/ &
        & 0.11018e+04_r8,0.83298e+03_r8,0.60385e+03_r8,0.88856e+03_r8,0.11751e+04_r8 /)
      kbo(:, 3,16,13) = (/ &
        & 0.10859e+04_r8,0.83101e+03_r8,0.60319e+03_r8,0.88832e+03_r8,0.11747e+04_r8 /)
      kbo(:, 4,16,13) = (/ &
        & 0.10925e+04_r8,0.82836e+03_r8,0.60254e+03_r8,0.88762e+03_r8,0.11738e+04_r8 /)
      kbo(:, 5,16,13) = (/ &
        & 0.10900e+04_r8,0.82283e+03_r8,0.60124e+03_r8,0.88636e+03_r8,0.11721e+04_r8 /)
      kbo(:, 1,17,13) = (/ &
        & 0.10953e+04_r8,0.82596e+03_r8,0.60413e+03_r8,0.88915e+03_r8,0.11759e+04_r8 /)
      kbo(:, 2,17,13) = (/ &
        & 0.10864e+04_r8,0.82504e+03_r8,0.60360e+03_r8,0.88842e+03_r8,0.11750e+04_r8 /)
      kbo(:, 3,17,13) = (/ &
        & 0.10812e+04_r8,0.81898e+03_r8,0.60295e+03_r8,0.88822e+03_r8,0.11746e+04_r8 /)
      kbo(:, 4,17,13) = (/ &
        & 0.10806e+04_r8,0.81706e+03_r8,0.60242e+03_r8,0.88745e+03_r8,0.11736e+04_r8 /)
      kbo(:, 5,17,13) = (/ &
        & 0.10764e+04_r8,0.81771e+03_r8,0.59943e+03_r8,0.88638e+03_r8,0.11722e+04_r8 /)
      kbo(:, 1,18,13) = (/ &
        & 0.10787e+04_r8,0.82265e+03_r8,0.60390e+03_r8,0.88903e+03_r8,0.11759e+04_r8 /)
      kbo(:, 2,18,13) = (/ &
        & 0.10743e+04_r8,0.81466e+03_r8,0.60339e+03_r8,0.88738e+03_r8,0.11749e+04_r8 /)
      kbo(:, 3,18,13) = (/ &
        & 0.10792e+04_r8,0.81648e+03_r8,0.60273e+03_r8,0.88812e+03_r8,0.11749e+04_r8 /)
      kbo(:, 4,18,13) = (/ &
        & 0.10724e+04_r8,0.81516e+03_r8,0.60185e+03_r8,0.88728e+03_r8,0.11735e+04_r8 /)
      kbo(:, 5,18,13) = (/ &
        & 0.10737e+04_r8,0.81301e+03_r8,0.60092e+03_r8,0.88618e+03_r8,0.11717e+04_r8 /)
      kbo(:, 1,19,13) = (/ &
        & 0.10778e+04_r8,0.81646e+03_r8,0.60388e+03_r8,0.88893e+03_r8,0.11758e+04_r8 /)
      kbo(:, 2,19,13) = (/ &
        & 0.10709e+04_r8,0.81021e+03_r8,0.60321e+03_r8,0.88822e+03_r8,0.11748e+04_r8 /)
      kbo(:, 3,19,13) = (/ &
        & 0.10651e+04_r8,0.80945e+03_r8,0.60254e+03_r8,0.88803e+03_r8,0.11745e+04_r8 /)
      kbo(:, 4,19,13) = (/ &
        & 0.10677e+04_r8,0.80743e+03_r8,0.60147e+03_r8,0.88735e+03_r8,0.11733e+04_r8 /)
      kbo(:, 5,19,13) = (/ &
        & 0.10575e+04_r8,0.80245e+03_r8,0.60072e+03_r8,0.88575e+03_r8,0.11721e+04_r8 /)
      kbo(:, 1,20,13) = (/ &
        & 0.10622e+04_r8,0.81096e+03_r8,0.60356e+03_r8,0.88881e+03_r8,0.11757e+04_r8 /)
      kbo(:, 2,20,13) = (/ &
        & 0.10607e+04_r8,0.80739e+03_r8,0.60305e+03_r8,0.88816e+03_r8,0.11748e+04_r8 /)
      kbo(:, 3,20,13) = (/ &
        & 0.10623e+04_r8,0.80381e+03_r8,0.60252e+03_r8,0.88792e+03_r8,0.11744e+04_r8 /)
      kbo(:, 4,20,13) = (/ &
        & 0.10570e+04_r8,0.80456e+03_r8,0.60093e+03_r8,0.88695e+03_r8,0.11731e+04_r8 /)
      kbo(:, 5,20,13) = (/ &
        & 0.10628e+04_r8,0.80481e+03_r8,0.60051e+03_r8,0.88554e+03_r8,0.11713e+04_r8 /)
      kbo(:, 1,21,13) = (/ &
        & 0.10564e+04_r8,0.80721e+03_r8,0.60326e+03_r8,0.88869e+03_r8,0.11756e+04_r8 /)
      kbo(:, 2,21,13) = (/ &
        & 0.10630e+04_r8,0.79813e+03_r8,0.60290e+03_r8,0.88813e+03_r8,0.11748e+04_r8 /)
      kbo(:, 3,21,13) = (/ &
        & 0.10553e+04_r8,0.80228e+03_r8,0.60219e+03_r8,0.88781e+03_r8,0.11743e+04_r8 /)
      kbo(:, 4,21,13) = (/ &
        & 0.10544e+04_r8,0.79888e+03_r8,0.60136e+03_r8,0.88677e+03_r8,0.11729e+04_r8 /)
      kbo(:, 5,21,13) = (/ &
        & 0.10596e+04_r8,0.81049e+03_r8,0.60032e+03_r8,0.88532e+03_r8,0.11710e+04_r8 /)
      kbo(:, 1,22,13) = (/ &
        & 0.10550e+04_r8,0.80310e+03_r8,0.60326e+03_r8,0.88850e+03_r8,0.11754e+04_r8 /)
      kbo(:, 2,22,13) = (/ &
        & 0.10516e+04_r8,0.80380e+03_r8,0.60256e+03_r8,0.88810e+03_r8,0.11747e+04_r8 /)
      kbo(:, 3,22,13) = (/ &
        & 0.10562e+04_r8,0.80152e+03_r8,0.60229e+03_r8,0.88764e+03_r8,0.11741e+04_r8 /)
      kbo(:, 4,22,13) = (/ &
        & 0.10509e+04_r8,0.80224e+03_r8,0.60002e+03_r8,0.88651e+03_r8,0.11726e+04_r8 /)
      kbo(:, 5,22,13) = (/ &
        & 0.10563e+04_r8,0.79871e+03_r8,0.59990e+03_r8,0.88500e+03_r8,0.11706e+04_r8 /)
      kbo(:, 1,23,13) = (/ &
        & 0.10567e+04_r8,0.79860e+03_r8,0.60326e+03_r8,0.88832e+03_r8,0.11752e+04_r8 /)
      kbo(:, 2,23,13) = (/ &
        & 0.10532e+04_r8,0.79557e+03_r8,0.60254e+03_r8,0.88806e+03_r8,0.11747e+04_r8 /)
      kbo(:, 3,23,13) = (/ &
        & 0.10534e+04_r8,0.79512e+03_r8,0.60237e+03_r8,0.88744e+03_r8,0.11739e+04_r8 /)
      kbo(:, 4,23,13) = (/ &
        & 0.10472e+04_r8,0.79721e+03_r8,0.60072e+03_r8,0.88622e+03_r8,0.11723e+04_r8 /)
      kbo(:, 5,23,13) = (/ &
        & 0.10509e+04_r8,0.79423e+03_r8,0.59964e+03_r8,0.88466e+03_r8,0.11702e+04_r8 /)
      kbo(:, 1,24,13) = (/ &
        & 0.10549e+04_r8,0.79502e+03_r8,0.60296e+03_r8,0.88817e+03_r8,0.11750e+04_r8 /)
      kbo(:, 2,24,13) = (/ &
        & 0.10498e+04_r8,0.80428e+03_r8,0.60221e+03_r8,0.88799e+03_r8,0.11746e+04_r8 /)
      kbo(:, 3,24,13) = (/ &
        & 0.10553e+04_r8,0.79369e+03_r8,0.60149e+03_r8,0.88721e+03_r8,0.11736e+04_r8 /)
      kbo(:, 4,24,13) = (/ &
        & 0.10517e+04_r8,0.79240e+03_r8,0.60048e+03_r8,0.88592e+03_r8,0.11719e+04_r8 /)
      kbo(:, 5,24,13) = (/ &
        & 0.10493e+04_r8,0.79281e+03_r8,0.59936e+03_r8,0.88429e+03_r8,0.11697e+04_r8 /)
      kbo(:, 1,25,13) = (/ &
        & 0.10472e+04_r8,0.79884e+03_r8,0.60281e+03_r8,0.88760e+03_r8,0.11748e+04_r8 /)
      kbo(:, 2,25,13) = (/ &
        & 0.10433e+04_r8,0.79261e+03_r8,0.60217e+03_r8,0.88787e+03_r8,0.11745e+04_r8 /)
      kbo(:, 3,25,13) = (/ &
        & 0.10495e+04_r8,0.79568e+03_r8,0.60138e+03_r8,0.88696e+03_r8,0.11733e+04_r8 /)
      kbo(:, 4,25,13) = (/ &
        & 0.10412e+04_r8,0.79264e+03_r8,0.60023e+03_r8,0.88559e+03_r8,0.11715e+04_r8 /)
      kbo(:, 5,25,13) = (/ &
        & 0.10432e+04_r8,0.79682e+03_r8,0.59908e+03_r8,0.88390e+03_r8,0.11692e+04_r8 /)
      kbo(:, 1,26,13) = (/ &
        & 0.10426e+04_r8,0.79538e+03_r8,0.60266e+03_r8,0.88804e+03_r8,0.11748e+04_r8 /)
      kbo(:, 2,26,13) = (/ &
        & 0.10459e+04_r8,0.79909e+03_r8,0.60196e+03_r8,0.88771e+03_r8,0.11743e+04_r8 /)
      kbo(:, 3,26,13) = (/ &
        & 0.10455e+04_r8,0.79078e+03_r8,0.60113e+03_r8,0.88666e+03_r8,0.11729e+04_r8 /)
      kbo(:, 4,26,13) = (/ &
        & 0.10380e+04_r8,0.79069e+03_r8,0.60011e+03_r8,0.88521e+03_r8,0.11710e+04_r8 /)
      kbo(:, 5,26,13) = (/ &
        & 0.10428e+04_r8,0.79124e+03_r8,0.59892e+03_r8,0.88345e+03_r8,0.11686e+04_r8 /)
      kbo(:, 1,27,13) = (/ &
        & 0.10409e+04_r8,0.79057e+03_r8,0.60249e+03_r8,0.88802e+03_r8,0.11747e+04_r8 /)
      kbo(:, 2,27,13) = (/ &
        & 0.10432e+04_r8,0.78863e+03_r8,0.60172e+03_r8,0.88750e+03_r8,0.11740e+04_r8 /)
      kbo(:, 3,27,13) = (/ &
        & 0.10404e+04_r8,0.79041e+03_r8,0.60057e+03_r8,0.88634e+03_r8,0.11728e+04_r8 /)
      kbo(:, 4,27,13) = (/ &
        & 0.10425e+04_r8,0.78854e+03_r8,0.59967e+03_r8,0.88481e+03_r8,0.11704e+04_r8 /)
      kbo(:, 5,27,13) = (/ &
        & 0.10492e+04_r8,0.78874e+03_r8,0.59843e+03_r8,0.88297e+03_r8,0.11680e+04_r8 /)
      kbo(:, 1,28,13) = (/ &
        & 0.10434e+04_r8,0.79273e+03_r8,0.60231e+03_r8,0.88820e+03_r8,0.11747e+04_r8 /)
      kbo(:, 2,28,13) = (/ &
        & 0.10472e+04_r8,0.78799e+03_r8,0.60162e+03_r8,0.88726e+03_r8,0.11737e+04_r8 /)
      kbo(:, 3,28,13) = (/ &
        & 0.10366e+04_r8,0.79125e+03_r8,0.60032e+03_r8,0.88600e+03_r8,0.11720e+04_r8 /)
      kbo(:, 4,28,13) = (/ &
        & 0.10345e+04_r8,0.78841e+03_r8,0.59938e+03_r8,0.88440e+03_r8,0.11699e+04_r8 /)
      kbo(:, 5,28,13) = (/ &
        & 0.10534e+04_r8,0.78866e+03_r8,0.59808e+03_r8,0.88245e+03_r8,0.11673e+04_r8 /)
      kbo(:, 1,29,13) = (/ &
        & 0.10524e+04_r8,0.78934e+03_r8,0.60181e+03_r8,0.88786e+03_r8,0.11745e+04_r8 /)
      kbo(:, 2,29,13) = (/ &
        & 0.10481e+04_r8,0.78588e+03_r8,0.60321e+03_r8,0.88698e+03_r8,0.11734e+04_r8 /)
      kbo(:, 3,29,13) = (/ &
        & 0.10466e+04_r8,0.79266e+03_r8,0.60021e+03_r8,0.88562e+03_r8,0.11715e+04_r8 /)
      kbo(:, 4,29,13) = (/ &
        & 0.10466e+04_r8,0.79965e+03_r8,0.59906e+03_r8,0.88395e+03_r8,0.11693e+04_r8 /)
      kbo(:, 5,29,13) = (/ &
        & 0.10459e+04_r8,0.78993e+03_r8,0.59799e+03_r8,0.88185e+03_r8,0.11668e+04_r8 /)
      kbo(:, 1,30,13) = (/ &
        & 0.10360e+04_r8,0.78916e+03_r8,0.60191e+03_r8,0.88770e+03_r8,0.11743e+04_r8 /)
      kbo(:, 2,30,13) = (/ &
        & 0.10409e+04_r8,0.78411e+03_r8,0.60093e+03_r8,0.88667e+03_r8,0.11729e+04_r8 /)
      kbo(:, 3,30,13) = (/ &
        & 0.10391e+04_r8,0.79193e+03_r8,0.59993e+03_r8,0.88546e+03_r8,0.11710e+04_r8 /)
      kbo(:, 4,30,13) = (/ &
        & 0.10409e+04_r8,0.78876e+03_r8,0.59874e+03_r8,0.88348e+03_r8,0.11687e+04_r8 /)
      kbo(:, 5,30,13) = (/ &
        & 0.10396e+04_r8,0.78722e+03_r8,0.59722e+03_r8,0.88117e+03_r8,0.11665e+04_r8 /)
      kbo(:, 1,31,13) = (/ &
        & 0.10394e+04_r8,0.79419e+03_r8,0.60167e+03_r8,0.88749e+03_r8,0.11740e+04_r8 /)
      kbo(:, 2,31,13) = (/ &
        & 0.10363e+04_r8,0.79203e+03_r8,0.60068e+03_r8,0.88633e+03_r8,0.11725e+04_r8 /)
      kbo(:, 3,31,13) = (/ &
        & 0.10437e+04_r8,0.78663e+03_r8,0.59963e+03_r8,0.88481e+03_r8,0.11705e+04_r8 /)
      kbo(:, 4,31,13) = (/ &
        & 0.10406e+04_r8,0.79000e+03_r8,0.59839e+03_r8,0.88297e+03_r8,0.11680e+04_r8 /)
      kbo(:, 5,31,13) = (/ &
        & 0.10413e+04_r8,0.79093e+03_r8,0.59674e+03_r8,0.88044e+03_r8,0.11650e+04_r8 /)
      kbo(:, 1,32,13) = (/ &
        & 0.10440e+04_r8,0.79014e+03_r8,0.60327e+03_r8,0.88723e+03_r8,0.11737e+04_r8 /)
      kbo(:, 2,32,13) = (/ &
        & 0.10391e+04_r8,0.79106e+03_r8,0.60042e+03_r8,0.88596e+03_r8,0.11720e+04_r8 /)
      kbo(:, 3,32,13) = (/ &
        & 0.10467e+04_r8,0.78955e+03_r8,0.59932e+03_r8,0.88436e+03_r8,0.11699e+04_r8 /)
      kbo(:, 4,32,13) = (/ &
        & 0.10407e+04_r8,0.79722e+03_r8,0.59818e+03_r8,0.88241e+03_r8,0.11673e+04_r8 /)
      kbo(:, 5,32,13) = (/ &
        & 0.10382e+04_r8,0.78961e+03_r8,0.59626e+03_r8,0.87980e+03_r8,0.11639e+04_r8 /)
      kbo(:, 1,33,13) = (/ &
        & 0.10522e+04_r8,0.78494e+03_r8,0.60081e+03_r8,0.88693e+03_r8,0.11733e+04_r8 /)
      kbo(:, 2,33,13) = (/ &
        & 0.10373e+04_r8,0.79220e+03_r8,0.59999e+03_r8,0.88557e+03_r8,0.11715e+04_r8 /)
      kbo(:, 3,33,13) = (/ &
        & 0.10359e+04_r8,0.78622e+03_r8,0.59900e+03_r8,0.88389e+03_r8,0.11695e+04_r8 /)
      kbo(:, 4,33,13) = (/ &
        & 0.10377e+04_r8,0.78474e+03_r8,0.59760e+03_r8,0.88177e+03_r8,0.11667e+04_r8 /)
      kbo(:, 5,33,13) = (/ &
        & 0.10406e+04_r8,0.78876e+03_r8,0.59580e+03_r8,0.87933e+03_r8,0.11633e+04_r8 /)
      kbo(:, 1,34,13) = (/ &
        & 0.10360e+04_r8,0.79366e+03_r8,0.60074e+03_r8,0.88666e+03_r8,0.11729e+04_r8 /)
      kbo(:, 2,34,13) = (/ &
        & 0.10445e+04_r8,0.78362e+03_r8,0.59974e+03_r8,0.88521e+03_r8,0.11710e+04_r8 /)
      kbo(:, 3,34,13) = (/ &
        & 0.10445e+04_r8,0.78784e+03_r8,0.59871e+03_r8,0.88346e+03_r8,0.11687e+04_r8 /)
      kbo(:, 4,34,13) = (/ &
        & 0.10420e+04_r8,0.78840e+03_r8,0.59718e+03_r8,0.88091e+03_r8,0.11665e+04_r8 /)
      kbo(:, 5,34,13) = (/ &
        & 0.10384e+04_r8,0.79182e+03_r8,0.59540e+03_r8,0.87927e+03_r8,0.11620e+04_r8 /)
      kbo(:, 1,35,13) = (/ &
        & 0.10422e+04_r8,0.79326e+03_r8,0.60077e+03_r8,0.88648e+03_r8,0.11727e+04_r8 /)
      kbo(:, 2,35,13) = (/ &
        & 0.10360e+04_r8,0.79158e+03_r8,0.59975e+03_r8,0.88500e+03_r8,0.11707e+04_r8 /)
      kbo(:, 3,35,13) = (/ &
        & 0.10370e+04_r8,0.78869e+03_r8,0.59854e+03_r8,0.88320e+03_r8,0.11683e+04_r8 /)
      kbo(:, 4,35,13) = (/ &
        & 0.10364e+04_r8,0.79354e+03_r8,0.59694e+03_r8,0.88077e+03_r8,0.11651e+04_r8 /)
      kbo(:, 5,35,13) = (/ &
        & 0.10369e+04_r8,0.78943e+03_r8,0.59473e+03_r8,0.87892e+03_r8,0.11616e+04_r8 /)
      kbo(:, 1,36,13) = (/ &
        & 0.10401e+04_r8,0.78191e+03_r8,0.60075e+03_r8,0.88645e+03_r8,0.11727e+04_r8 /)
      kbo(:, 2,36,13) = (/ &
        & 0.10371e+04_r8,0.78614e+03_r8,0.59972e+03_r8,0.88519e+03_r8,0.11707e+04_r8 /)
      kbo(:, 3,36,13) = (/ &
        & 0.10392e+04_r8,0.78550e+03_r8,0.59835e+03_r8,0.88339e+03_r8,0.11683e+04_r8 /)
      kbo(:, 4,36,13) = (/ &
        & 0.10378e+04_r8,0.78649e+03_r8,0.59690e+03_r8,0.88071e+03_r8,0.11650e+04_r8 /)
      kbo(:, 5,36,13) = (/ &
        & 0.10389e+04_r8,0.79012e+03_r8,0.59516e+03_r8,0.87821e+03_r8,0.11604e+04_r8 /)
      kbo(:, 1,37,13) = (/ &
        & 0.10397e+04_r8,0.78790e+03_r8,0.60071e+03_r8,0.88662e+03_r8,0.11729e+04_r8 /)
      kbo(:, 2,37,13) = (/ &
        & 0.10413e+04_r8,0.78135e+03_r8,0.59986e+03_r8,0.88540e+03_r8,0.11710e+04_r8 /)
      kbo(:, 3,37,13) = (/ &
        & 0.10434e+04_r8,0.78885e+03_r8,0.59867e+03_r8,0.88341e+03_r8,0.11686e+04_r8 /)
      kbo(:, 4,37,13) = (/ &
        & 0.10382e+04_r8,0.79636e+03_r8,0.59698e+03_r8,0.88108e+03_r8,0.11655e+04_r8 /)
      kbo(:, 5,37,13) = (/ &
        & 0.10369e+04_r8,0.78656e+03_r8,0.59536e+03_r8,0.87879e+03_r8,0.11626e+04_r8 /)
      kbo(:, 1,38,13) = (/ &
        & 0.10433e+04_r8,0.78475e+03_r8,0.60099e+03_r8,0.88680e+03_r8,0.11731e+04_r8 /)
      kbo(:, 2,38,13) = (/ &
        & 0.10422e+04_r8,0.78187e+03_r8,0.60001e+03_r8,0.88539e+03_r8,0.11713e+04_r8 /)
      kbo(:, 3,38,13) = (/ &
        & 0.10376e+04_r8,0.78470e+03_r8,0.59854e+03_r8,0.88368e+03_r8,0.11690e+04_r8 /)
      kbo(:, 4,38,13) = (/ &
        & 0.10379e+04_r8,0.78467e+03_r8,0.59739e+03_r8,0.88147e+03_r8,0.11660e+04_r8 /)
      kbo(:, 5,38,13) = (/ &
        & 0.10346e+04_r8,0.79279e+03_r8,0.59559e+03_r8,0.87849e+03_r8,0.11631e+04_r8 /)
      kbo(:, 1,39,13) = (/ &
        & 0.10564e+04_r8,0.79016e+03_r8,0.60113e+03_r8,0.88696e+03_r8,0.11734e+04_r8 /)
      kbo(:, 2,39,13) = (/ &
        & 0.10405e+04_r8,0.78139e+03_r8,0.59938e+03_r8,0.88561e+03_r8,0.11715e+04_r8 /)
      kbo(:, 3,39,13) = (/ &
        & 0.10386e+04_r8,0.79256e+03_r8,0.59902e+03_r8,0.88393e+03_r8,0.11693e+04_r8 /)
      kbo(:, 4,39,13) = (/ &
        & 0.10351e+04_r8,0.78501e+03_r8,0.59779e+03_r8,0.88184e+03_r8,0.11668e+04_r8 /)
      kbo(:, 5,39,13) = (/ &
        & 0.10353e+04_r8,0.78561e+03_r8,0.59583e+03_r8,0.87937e+03_r8,0.11634e+04_r8 /)
      kbo(:, 1,40,13) = (/ &
        & 0.10351e+04_r8,0.78501e+03_r8,0.60325e+03_r8,0.88723e+03_r8,0.11737e+04_r8 /)
      kbo(:, 2,40,13) = (/ &
        & 0.10332e+04_r8,0.78519e+03_r8,0.60040e+03_r8,0.88596e+03_r8,0.11720e+04_r8 /)
      kbo(:, 3,40,13) = (/ &
        & 0.10393e+04_r8,0.78843e+03_r8,0.59931e+03_r8,0.88436e+03_r8,0.11699e+04_r8 /)
      kbo(:, 4,40,13) = (/ &
        & 0.10339e+04_r8,0.78821e+03_r8,0.59801e+03_r8,0.88242e+03_r8,0.11676e+04_r8 /)
      kbo(:, 5,40,13) = (/ &
        & 0.10476e+04_r8,0.78616e+03_r8,0.59626e+03_r8,0.87958e+03_r8,0.11639e+04_r8 /)
      kbo(:, 1,41,13) = (/ &
        & 0.10420e+04_r8,0.78658e+03_r8,0.60226e+03_r8,0.88748e+03_r8,0.11740e+04_r8 /)
      kbo(:, 2,41,13) = (/ &
        & 0.10471e+04_r8,0.78433e+03_r8,0.60065e+03_r8,0.88632e+03_r8,0.11725e+04_r8 /)
      kbo(:, 3,41,13) = (/ &
        & 0.10385e+04_r8,0.78777e+03_r8,0.59960e+03_r8,0.88480e+03_r8,0.11705e+04_r8 /)
      kbo(:, 4,41,13) = (/ &
        & 0.10374e+04_r8,0.79305e+03_r8,0.59837e+03_r8,0.88319e+03_r8,0.11680e+04_r8 /)
      kbo(:, 5,41,13) = (/ &
        & 0.10341e+04_r8,0.79121e+03_r8,0.59671e+03_r8,0.88067e+03_r8,0.11641e+04_r8 /)
      kbo(:, 1,42,13) = (/ &
        & 0.10427e+04_r8,0.78654e+03_r8,0.60202e+03_r8,0.88768e+03_r8,0.11743e+04_r8 /)
      kbo(:, 2,42,13) = (/ &
        & 0.10376e+04_r8,0.78774e+03_r8,0.60073e+03_r8,0.88666e+03_r8,0.11730e+04_r8 /)
      kbo(:, 3,42,13) = (/ &
        & 0.10387e+04_r8,0.78631e+03_r8,0.59989e+03_r8,0.88522e+03_r8,0.11710e+04_r8 /)
      kbo(:, 4,42,13) = (/ &
        & 0.10432e+04_r8,0.79240e+03_r8,0.59870e+03_r8,0.88347e+03_r8,0.11690e+04_r8 /)
      kbo(:, 5,42,13) = (/ &
        & 0.10408e+04_r8,0.78283e+03_r8,0.59718e+03_r8,0.88116e+03_r8,0.11677e+04_r8 /)
      kbo(:, 1,43,13) = (/ &
        & 0.10384e+04_r8,0.78732e+03_r8,0.60211e+03_r8,0.88787e+03_r8,0.11746e+04_r8 /)
      kbo(:, 2,43,13) = (/ &
        & 0.10392e+04_r8,0.79483e+03_r8,0.60103e+03_r8,0.88703e+03_r8,0.11735e+04_r8 /)
      kbo(:, 3,43,13) = (/ &
        & 0.10435e+04_r8,0.79279e+03_r8,0.60022e+03_r8,0.88570e+03_r8,0.11717e+04_r8 /)
      kbo(:, 4,43,13) = (/ &
        & 0.10453e+04_r8,0.78261e+03_r8,0.59909e+03_r8,0.88405e+03_r8,0.11698e+04_r8 /)
      kbo(:, 5,43,13) = (/ &
        & 0.10349e+04_r8,0.78239e+03_r8,0.59773e+03_r8,0.88200e+03_r8,0.11670e+04_r8 /)
      kbo(:, 1,44,13) = (/ &
        & 0.10376e+04_r8,0.78973e+03_r8,0.60218e+03_r8,0.88797e+03_r8,0.11747e+04_r8 /)
      kbo(:, 2,44,13) = (/ &
        & 0.10357e+04_r8,0.79073e+03_r8,0.60154e+03_r8,0.88738e+03_r8,0.11742e+04_r8 /)
      kbo(:, 3,44,13) = (/ &
        & 0.10381e+04_r8,0.78584e+03_r8,0.60056e+03_r8,0.88619e+03_r8,0.11723e+04_r8 /)
      kbo(:, 4,44,13) = (/ &
        & 0.10410e+04_r8,0.78726e+03_r8,0.59965e+03_r8,0.88464e+03_r8,0.11703e+04_r8 /)
      kbo(:, 5,44,13) = (/ &
        & 0.10370e+04_r8,0.78461e+03_r8,0.59824e+03_r8,0.88299e+03_r8,0.11677e+04_r8 /)
      kbo(:, 1,45,13) = (/ &
        & 0.10383e+04_r8,0.78177e+03_r8,0.60254e+03_r8,0.88799e+03_r8,0.11748e+04_r8 /)
      kbo(:, 2,45,13) = (/ &
        & 0.10337e+04_r8,0.78400e+03_r8,0.60200e+03_r8,0.88790e+03_r8,0.11743e+04_r8 /)
      kbo(:, 3,45,13) = (/ &
        & 0.10407e+04_r8,0.78928e+03_r8,0.60087e+03_r8,0.88664e+03_r8,0.11732e+04_r8 /)
      kbo(:, 4,45,13) = (/ &
        & 0.10410e+04_r8,0.79578e+03_r8,0.59987e+03_r8,0.88519e+03_r8,0.11713e+04_r8 /)
      kbo(:, 5,45,13) = (/ &
        & 0.10369e+04_r8,0.78337e+03_r8,0.59884e+03_r8,0.88344e+03_r8,0.11687e+04_r8 /)
      kbo(:, 1,46,13) = (/ &
        & 0.10415e+04_r8,0.79090e+03_r8,0.60272e+03_r8,0.88805e+03_r8,0.11749e+04_r8 /)
      kbo(:, 2,46,13) = (/ &
        & 0.10332e+04_r8,0.79374e+03_r8,0.60213e+03_r8,0.88788e+03_r8,0.11746e+04_r8 /)
      kbo(:, 3,46,13) = (/ &
        & 0.10495e+04_r8,0.78743e+03_r8,0.60122e+03_r8,0.88707e+03_r8,0.11738e+04_r8 /)
      kbo(:, 4,46,13) = (/ &
        & 0.10359e+04_r8,0.78275e+03_r8,0.60025e+03_r8,0.88575e+03_r8,0.11717e+04_r8 /)
      kbo(:, 5,46,13) = (/ &
        & 0.10407e+04_r8,0.79210e+03_r8,0.59913e+03_r8,0.88411e+03_r8,0.11695e+04_r8 /)
      kbo(:, 1,47,13) = (/ &
        & 0.10396e+04_r8,0.78478e+03_r8,0.60291e+03_r8,0.88833e+03_r8,0.11753e+04_r8 /)
      kbo(:, 2,47,13) = (/ &
        & 0.10391e+04_r8,0.78254e+03_r8,0.60239e+03_r8,0.88798e+03_r8,0.11747e+04_r8 /)
      kbo(:, 3,47,13) = (/ &
        & 0.10358e+04_r8,0.79087e+03_r8,0.60194e+03_r8,0.88748e+03_r8,0.11740e+04_r8 /)
      kbo(:, 4,47,13) = (/ &
        & 0.10382e+04_r8,0.78212e+03_r8,0.60065e+03_r8,0.88632e+03_r8,0.11725e+04_r8 /)
      kbo(:, 5,47,13) = (/ &
        & 0.10417e+04_r8,0.78639e+03_r8,0.59976e+03_r8,0.88480e+03_r8,0.11705e+04_r8 /)
      kbo(:, 1,48,13) = (/ &
        & 0.10401e+04_r8,0.78456e+03_r8,0.60307e+03_r8,0.88865e+03_r8,0.11757e+04_r8 /)
      kbo(:, 2,48,13) = (/ &
        & 0.10385e+04_r8,0.78639e+03_r8,0.60262e+03_r8,0.88799e+03_r8,0.11748e+04_r8 /)
      kbo(:, 3,48,13) = (/ &
        & 0.10377e+04_r8,0.78374e+03_r8,0.60183e+03_r8,0.88778e+03_r8,0.11745e+04_r8 /)
      kbo(:, 4,48,13) = (/ &
        & 0.10347e+04_r8,0.78455e+03_r8,0.60102e+03_r8,0.88707e+03_r8,0.11732e+04_r8 /)
      kbo(:, 5,48,13) = (/ &
        & 0.10420e+04_r8,0.79085e+03_r8,0.60005e+03_r8,0.88545e+03_r8,0.11713e+04_r8 /)
      kbo(:, 1,49,13) = (/ &
        & 0.10372e+04_r8,0.78740e+03_r8,0.60317e+03_r8,0.88862e+03_r8,0.11760e+04_r8 /)
      kbo(:, 2,49,13) = (/ &
        & 0.10417e+04_r8,0.78862e+03_r8,0.60282e+03_r8,0.88818e+03_r8,0.11751e+04_r8 /)
      kbo(:, 3,49,13) = (/ &
        & 0.10345e+04_r8,0.78780e+03_r8,0.60227e+03_r8,0.88818e+03_r8,0.11747e+04_r8 /)
      kbo(:, 4,49,13) = (/ &
        & 0.10406e+04_r8,0.78617e+03_r8,0.60221e+03_r8,0.88729e+03_r8,0.11738e+04_r8 /)
      kbo(:, 5,49,13) = (/ &
        & 0.10382e+04_r8,0.79023e+03_r8,0.60061e+03_r8,0.88605e+03_r8,0.11721e+04_r8 /)
      kbo(:, 1,50,13) = (/ &
        & 0.10347e+04_r8,0.79207e+03_r8,0.60367e+03_r8,0.88900e+03_r8,0.11761e+04_r8 /)
      kbo(:, 2,50,13) = (/ &
        & 0.10350e+04_r8,0.78739e+03_r8,0.60298e+03_r8,0.88872e+03_r8,0.11755e+04_r8 /)
      kbo(:, 3,50,13) = (/ &
        & 0.10353e+04_r8,0.78433e+03_r8,0.60234e+03_r8,0.88799e+03_r8,0.11744e+04_r8 /)
      kbo(:, 4,50,13) = (/ &
        & 0.10489e+04_r8,0.79267e+03_r8,0.60164e+03_r8,0.88763e+03_r8,0.11743e+04_r8 /)
      kbo(:, 5,50,13) = (/ &
        & 0.10406e+04_r8,0.78514e+03_r8,0.60019e+03_r8,0.88656e+03_r8,0.11728e+04_r8 /)
      kbo(:, 1,51,13) = (/ &
        & 0.10345e+04_r8,0.78799e+03_r8,0.60398e+03_r8,0.88932e+03_r8,0.11765e+04_r8 /)
      kbo(:, 2,51,13) = (/ &
        & 0.10401e+04_r8,0.78697e+03_r8,0.60314e+03_r8,0.88874e+03_r8,0.11758e+04_r8 /)
      kbo(:, 3,51,13) = (/ &
        & 0.10366e+04_r8,0.78656e+03_r8,0.60285e+03_r8,0.88803e+03_r8,0.11749e+04_r8 /)
      kbo(:, 4,51,13) = (/ &
        & 0.10374e+04_r8,0.78473e+03_r8,0.60240e+03_r8,0.88809e+03_r8,0.11746e+04_r8 /)
      kbo(:, 5,51,13) = (/ &
        & 0.10390e+04_r8,0.78920e+03_r8,0.60116e+03_r8,0.88701e+03_r8,0.11734e+04_r8 /)
      kbo(:, 1,52,13) = (/ &
        & 0.10369e+04_r8,0.78758e+03_r8,0.60425e+03_r8,0.88974e+03_r8,0.11770e+04_r8 /)
      kbo(:, 2,52,13) = (/ &
        & 0.10369e+04_r8,0.78229e+03_r8,0.60357e+03_r8,0.88889e+03_r8,0.11760e+04_r8 /)
      kbo(:, 3,52,13) = (/ &
        & 0.10371e+04_r8,0.78737e+03_r8,0.60287e+03_r8,0.88826e+03_r8,0.11752e+04_r8 /)
      kbo(:, 4,52,13) = (/ &
        & 0.10414e+04_r8,0.78574e+03_r8,0.60234e+03_r8,0.88797e+03_r8,0.11747e+04_r8 /)
      kbo(:, 5,52,13) = (/ &
        & 0.10377e+04_r8,0.78696e+03_r8,0.60170e+03_r8,0.88739e+03_r8,0.11739e+04_r8 /)
      kbo(:, 1,53,13) = (/ &
        & 0.10446e+04_r8,0.78533e+03_r8,0.60451e+03_r8,0.89022e+03_r8,0.11778e+04_r8 /)
      kbo(:, 2,53,13) = (/ &
        & 0.10366e+04_r8,0.78675e+03_r8,0.60391e+03_r8,0.88907e+03_r8,0.11762e+04_r8 /)
      kbo(:, 3,53,13) = (/ &
        & 0.10339e+04_r8,0.78472e+03_r8,0.60302e+03_r8,0.88857e+03_r8,0.11756e+04_r8 /)
      kbo(:, 4,53,13) = (/ &
        & 0.10347e+04_r8,0.78858e+03_r8,0.60271e+03_r8,0.88799e+03_r8,0.11748e+04_r8 /)
      kbo(:, 5,53,13) = (/ &
        & 0.10414e+04_r8,0.78370e+03_r8,0.60188e+03_r8,0.88770e+03_r8,0.11743e+04_r8 /)
      kbo(:, 1,54,13) = (/ &
        & 0.10366e+04_r8,0.78980e+03_r8,0.60463e+03_r8,0.89072e+03_r8,0.11788e+04_r8 /)
      kbo(:, 2,54,13) = (/ &
        & 0.10376e+04_r8,0.78289e+03_r8,0.60402e+03_r8,0.88939e+03_r8,0.11765e+04_r8 /)
      kbo(:, 3,54,13) = (/ &
        & 0.10387e+04_r8,0.78695e+03_r8,0.60318e+03_r8,0.88877e+03_r8,0.11759e+04_r8 /)
      kbo(:, 4,54,13) = (/ &
        & 0.10435e+04_r8,0.78370e+03_r8,0.60273e+03_r8,0.88806e+03_r8,0.11749e+04_r8 /)
      kbo(:, 5,54,13) = (/ &
        & 0.10492e+04_r8,0.79000e+03_r8,0.60214e+03_r8,0.88789e+03_r8,0.11746e+04_r8 /)
      kbo(:, 1,55,13) = (/ &
        & 0.10395e+04_r8,0.78654e+03_r8,0.60524e+03_r8,0.89136e+03_r8,0.11799e+04_r8 /)
      kbo(:, 2,55,13) = (/ &
        & 0.10379e+04_r8,0.78553e+03_r8,0.60426e+03_r8,0.88977e+03_r8,0.11770e+04_r8 /)
      kbo(:, 3,55,13) = (/ &
        & 0.10376e+04_r8,0.78959e+03_r8,0.60343e+03_r8,0.88890e+03_r8,0.11757e+04_r8 /)
      kbo(:, 4,55,13) = (/ &
        & 0.10360e+04_r8,0.78634e+03_r8,0.60272e+03_r8,0.88828e+03_r8,0.11752e+04_r8 /)
      kbo(:, 5,55,13) = (/ &
        & 0.10355e+04_r8,0.78796e+03_r8,0.60219e+03_r8,0.88821e+03_r8,0.11747e+04_r8 /)
      kbo(:, 1,56,13) = (/ &
        & 0.10500e+04_r8,0.78471e+03_r8,0.60540e+03_r8,0.89210e+03_r8,0.11812e+04_r8 /)
      kbo(:, 2,56,13) = (/ &
        & 0.10441e+04_r8,0.78735e+03_r8,0.60449e+03_r8,0.89019e+03_r8,0.11777e+04_r8 /)
      kbo(:, 3,56,13) = (/ &
        & 0.10382e+04_r8,0.78755e+03_r8,0.60374e+03_r8,0.88905e+03_r8,0.11759e+04_r8 /)
      kbo(:, 4,56,13) = (/ &
        & 0.10470e+04_r8,0.78715e+03_r8,0.60301e+03_r8,0.88855e+03_r8,0.11756e+04_r8 /)
      kbo(:, 5,56,13) = (/ &
        & 0.10358e+04_r8,0.78674e+03_r8,0.60270e+03_r8,0.88799e+03_r8,0.11748e+04_r8 /)
      kbo(:, 1,57,13) = (/ &
        & 0.10339e+04_r8,0.78715e+03_r8,0.60588e+03_r8,0.89295e+03_r8,0.11828e+04_r8 /)
      kbo(:, 2,57,13) = (/ &
        & 0.10441e+04_r8,0.78267e+03_r8,0.60475e+03_r8,0.89065e+03_r8,0.11787e+04_r8 /)
      kbo(:, 3,57,13) = (/ &
        & 0.10435e+04_r8,0.78938e+03_r8,0.60399e+03_r8,0.88934e+03_r8,0.11765e+04_r8 /)
      kbo(:, 4,57,13) = (/ &
        & 0.10392e+04_r8,0.79203e+03_r8,0.60300e+03_r8,0.88875e+03_r8,0.11758e+04_r8 /)
      kbo(:, 5,57,13) = (/ &
        & 0.10360e+04_r8,0.78491e+03_r8,0.60271e+03_r8,0.88827e+03_r8,0.11749e+04_r8 /)
      kbo(:, 1,58,13) = (/ &
        & 0.10392e+04_r8,0.78430e+03_r8,0.60601e+03_r8,0.89398e+03_r8,0.11847e+04_r8 /)
      kbo(:, 2,58,13) = (/ &
        & 0.10363e+04_r8,0.78694e+03_r8,0.60503e+03_r8,0.89124e+03_r8,0.11797e+04_r8 /)
      kbo(:, 3,58,13) = (/ &
        & 0.10360e+04_r8,0.78084e+03_r8,0.60391e+03_r8,0.88970e+03_r8,0.11769e+04_r8 /)
      kbo(:, 4,58,13) = (/ &
        & 0.10459e+04_r8,0.78267e+03_r8,0.60338e+03_r8,0.88888e+03_r8,0.11757e+04_r8 /)
      kbo(:, 5,58,13) = (/ &
        & 0.10368e+04_r8,0.79101e+03_r8,0.60285e+03_r8,0.88823e+03_r8,0.11752e+04_r8 /)
      kbo(:, 1,59,13) = (/ &
        & 0.10403e+04_r8,0.78613e+03_r8,0.60612e+03_r8,0.89444e+03_r8,0.11849e+04_r8 /)
      kbo(:, 2,59,13) = (/ &
        & 0.10349e+04_r8,0.78531e+03_r8,0.60514e+03_r8,0.89150e+03_r8,0.11802e+04_r8 /)
      kbo(:, 3,59,13) = (/ &
        & 0.10360e+04_r8,0.78470e+03_r8,0.60447e+03_r8,0.88985e+03_r8,0.11771e+04_r8 /)
      kbo(:, 4,59,13) = (/ &
        & 0.10411e+04_r8,0.78531e+03_r8,0.60349e+03_r8,0.88892e+03_r8,0.11761e+04_r8 /)
      kbo(:, 5,59,13) = (/ &
        & 0.10355e+04_r8,0.78795e+03_r8,0.60275e+03_r8,0.88833e+03_r8,0.11753e+04_r8 /)
      kbo(:, 1,13,14) = (/ &
        & 0.12194e+04_r8,0.91192e+03_r8,0.60649e+03_r8,0.89289e+03_r8,0.11803e+04_r8 /)
      kbo(:, 2,13,14) = (/ &
