!     path:      $Source: /storm/rc1/cvsroot/rc/rrtmg_sw/src/rrtmg_sw_k_g.f90,v $
!     author:    $Author: mike $
!     revision:  $Revision: 1.2 $
!     created:   $Date: 2007/08/23 20:40:13 $

!  --------------------------------------------------------------------------
! |                                                                          |
! |  Copyright 2002-2007, Atmospheric & Environmental Research, Inc. (AER).  |
! |  This software may be used, copied, or redistributed as long as it is    |
! |  not sold and this copyright notice is reproduced on each copy made.     |
! |  This model is provided as is without any express or implied warranties. |
! |                       (http://www.rtweb.aer.com/)                        |
! |                                                                          |
!  --------------------------------------------------------------------------

! **************************************************************************
!      subroutine sw_kgbnn
! **************************************************************************
!  RRTM Shortwave Radiative Transfer Model
!  Atmospheric and Environmental Research, Inc., Cambridge, MA
!
!  Original by J.Delamere, Atmospheric & Environmental Research.
!  Reformatted for F90: JJMorcrette, ECMWF
!  Further F90 and GCM revisions:  MJIacono, AER, July 2002
!
!  This file contains 14 subroutines that include the 
!  absorption coefficients and other data for each of the 14 shortwave
!  spectral bands used in RRTM_SW.  Here, the data are defined for 16
!  g-points, or sub-intervals, per band.  These data are combined and
!  weighted using a mapping procedure in routine RRTMG_SW_INIT to reduce
!  the total number of g-points from 224 to 112 for use in the GCM.
! **************************************************************************

! **************************************************************************

      subroutine sw_kgb20
! **************************************************************************

      use shr_kind_mod, only: r8 => shr_kind_r8

!      use parkind, only : jpim, jprb 
      use rrsw_kg20, only : kao, kbo, selfrefo, forrefo, sfluxrefo, &
                            absch4o, rayl, layreffr

      implicit none
      save

! Kurucz solar source function
      sfluxrefo(:) = (/ &
        & 9.34081_r8 , 8.93720_r8    , 8.19346_r8    , 7.39196_r8    , &
        & 6.12127_r8 , 5.23956_r8    , 4.24941_r8    , 3.20013_r8    , &
        & 2.16047_r8 , 0.234509_r8   , 0.194593_r8   , 0.151512_r8   , &
        & 0.110315_r8, 7.09959e-02_r8, 2.70573e-02_r8, 3.36042e-03_r8 /)
  
      absch4o(:) = (/ &  
        & 1.01381e-03_r8,6.33692e-03_r8,1.94185e-02_r8,4.83210e-02_r8, &
        & 2.36574e-03_r8,6.61973e-04_r8,5.64552e-04_r8,2.83183e-04_r8, &
        & 7.43623e-05_r8,8.90159e-07_r8,6.98728e-07_r8,6.51832e-08_r8, &
        & 2.96619e-08_r8,         0._r8,         0._r8,         0._r8 /)

! Rayleigh extinction coefficient at v = 5670 cm-1.
      rayl = 4.12e-09_r8

      layreffr = 3

!     ------------------------------------------------------------------
!     The array KAO contains absorption coefs at the 16 chosen g-values 
!     for a range of pressure levels> ~100mb, temperatures, and binary
!     species parameters (see taumol.f for definition).  The first 
!     index in the array, JS, runs from 1 to 9, and corresponds to 
!     different values of the binary species parameter.  For instance, 
!     JS=1 refers to dry air, JS = 2 corresponds to the paramter value 1/8, 
!     JS = 3 corresponds to the parameter value 2/8, etc.  The second index
!     in the array, JT, which runs from 1 to 5, corresponds to different
!     temperatures.  More specifically, JT = 3 means that the data are for
!     the reference temperature TREF for this  pressure level, JT = 2 refers
!     to TREF-15, JT = 1 is for TREF-30, JT = 4 is for TREF+15, and JT = 5
!     is for TREF+30.  The third index, JP, runs from 1 to 13 and refers
!     to the JPth reference pressure level (see taumol.f for these levels
!     in mb).  The fourth index, IG, goes from 1 to 16, and indicates
!     which g-interval the absorption coefficients are for.
!     -----------------------------------------------------------------

      kao(:, 1, 1) = (/ &
        & 0.78383e-06_r8,0.86220e-06_r8,0.95359e-06_r8,0.10590e-05_r8,0.11782e-05_r8 /)
      kao(:, 2, 1) = (/ &
        & 0.65040e-06_r8,0.72510e-06_r8,0.81318e-06_r8,0.90059e-06_r8,0.99786e-06_r8 /)
      kao(:, 3, 1) = (/ &
        & 0.58072e-06_r8,0.65888e-06_r8,0.74265e-06_r8,0.81854e-06_r8,0.90645e-06_r8 /)
      kao(:, 4, 1) = (/ &
        & 0.53601e-06_r8,0.60765e-06_r8,0.68088e-06_r8,0.75741e-06_r8,0.83801e-06_r8 /)
      kao(:, 5, 1) = (/ &
        & 0.50142e-06_r8,0.56951e-06_r8,0.64028e-06_r8,0.71944e-06_r8,0.79813e-06_r8 /)
      kao(:, 6, 1) = (/ &
        & 0.47164e-06_r8,0.54008e-06_r8,0.61040e-06_r8,0.68006e-06_r8,0.75034e-06_r8 /)
      kao(:, 7, 1) = (/ &
        & 0.49337e-06_r8,0.56178e-06_r8,0.62215e-06_r8,0.69127e-06_r8,0.76060e-06_r8 /)
      kao(:, 8, 1) = (/ &
        & 0.61581e-06_r8,0.70117e-06_r8,0.78942e-06_r8,0.87145e-06_r8,0.94647e-06_r8 /)
      kao(:, 9, 1) = (/ &
        & 0.14154e-05_r8,0.15754e-05_r8,0.17261e-05_r8,0.18739e-05_r8,0.19774e-05_r8 /)
      kao(:,10, 1) = (/ &
        & 0.34186e-05_r8,0.37012e-05_r8,0.39602e-05_r8,0.42235e-05_r8,0.44256e-05_r8 /)
      kao(:,11, 1) = (/ &
        & 0.38574e-05_r8,0.42080e-05_r8,0.44701e-05_r8,0.47454e-05_r8,0.50002e-05_r8 /)
      kao(:,12, 1) = (/ &
        & 0.35794e-05_r8,0.38686e-05_r8,0.41443e-05_r8,0.43939e-05_r8,0.46500e-05_r8 /)
      kao(:,13, 1) = (/ &
        & 0.29586e-05_r8,0.31938e-05_r8,0.34167e-05_r8,0.36253e-05_r8,0.38250e-05_r8 /)
      kao(:, 1, 2) = (/ &
        & 0.57098e-05_r8,0.64630e-05_r8,0.73117e-05_r8,0.82436e-05_r8,0.91947e-05_r8 /)
      kao(:, 2, 2) = (/ &
        & 0.46384e-05_r8,0.53125e-05_r8,0.60301e-05_r8,0.68028e-05_r8,0.75824e-05_r8 /)
      kao(:, 3, 2) = (/ &
        & 0.40657e-05_r8,0.46486e-05_r8,0.52459e-05_r8,0.58955e-05_r8,0.65546e-05_r8 /)
      kao(:, 4, 2) = (/ &
        & 0.38895e-05_r8,0.44258e-05_r8,0.49759e-05_r8,0.55663e-05_r8,0.61702e-05_r8 /)
      kao(:, 5, 2) = (/ &
        & 0.38971e-05_r8,0.44359e-05_r8,0.49933e-05_r8,0.55523e-05_r8,0.61234e-05_r8 /)
      kao(:, 6, 2) = (/ &
        & 0.39532e-05_r8,0.44644e-05_r8,0.49734e-05_r8,0.54875e-05_r8,0.60102e-05_r8 /)
      kao(:, 7, 2) = (/ &
        & 0.41068e-05_r8,0.45832e-05_r8,0.50698e-05_r8,0.55521e-05_r8,0.60175e-05_r8 /)
      kao(:, 8, 2) = (/ &
        & 0.47922e-05_r8,0.52156e-05_r8,0.56817e-05_r8,0.61576e-05_r8,0.66313e-05_r8 /)
      kao(:, 9, 2) = (/ &
        & 0.83199e-05_r8,0.88317e-05_r8,0.93688e-05_r8,0.99754e-05_r8,0.10620e-04_r8 /)
      kao(:,10, 2) = (/ &
        & 0.16836e-04_r8,0.18526e-04_r8,0.19887e-04_r8,0.21168e-04_r8,0.22104e-04_r8 /)
      kao(:,11, 2) = (/ &
        & 0.18882e-04_r8,0.21005e-04_r8,0.22896e-04_r8,0.24777e-04_r8,0.26115e-04_r8 /)
      kao(:,12, 2) = (/ &
        & 0.17744e-04_r8,0.19780e-04_r8,0.21600e-04_r8,0.23523e-04_r8,0.25128e-04_r8 /)
      kao(:,13, 2) = (/ &
        & 0.14736e-04_r8,0.16356e-04_r8,0.17955e-04_r8,0.19533e-04_r8,0.20861e-04_r8 /)
      kao(:, 1, 3) = (/ &
        & 0.41776e-04_r8,0.48150e-04_r8,0.55097e-04_r8,0.62661e-04_r8,0.70920e-04_r8 /)
      kao(:, 2, 3) = (/ &
        & 0.33909e-04_r8,0.39176e-04_r8,0.44622e-04_r8,0.50754e-04_r8,0.57336e-04_r8 /)
      kao(:, 3, 3) = (/ &
        & 0.27438e-04_r8,0.31473e-04_r8,0.36122e-04_r8,0.41134e-04_r8,0.46456e-04_r8 /)
      kao(:, 4, 3) = (/ &
        & 0.23222e-04_r8,0.26535e-04_r8,0.30141e-04_r8,0.34099e-04_r8,0.38416e-04_r8 /)
      kao(:, 5, 3) = (/ &
        & 0.21114e-04_r8,0.23888e-04_r8,0.26883e-04_r8,0.30340e-04_r8,0.33785e-04_r8 /)
      kao(:, 6, 3) = (/ &
        & 0.20750e-04_r8,0.22926e-04_r8,0.25536e-04_r8,0.28492e-04_r8,0.31676e-04_r8 /)
      kao(:, 7, 3) = (/ &
        & 0.21584e-04_r8,0.24112e-04_r8,0.26872e-04_r8,0.29794e-04_r8,0.32940e-04_r8 /)
      kao(:, 8, 3) = (/ &
        & 0.24194e-04_r8,0.26981e-04_r8,0.30137e-04_r8,0.33546e-04_r8,0.37182e-04_r8 /)
      kao(:, 9, 3) = (/ &
        & 0.37461e-04_r8,0.42158e-04_r8,0.46718e-04_r8,0.51048e-04_r8,0.55154e-04_r8 /)
      kao(:,10, 3) = (/ &
        & 0.72391e-04_r8,0.77164e-04_r8,0.84016e-04_r8,0.89658e-04_r8,0.95511e-04_r8 /)
      kao(:,11, 3) = (/ &
        & 0.91736e-04_r8,0.99107e-04_r8,0.10463e-03_r8,0.10952e-03_r8,0.11549e-03_r8 /)
      kao(:,12, 3) = (/ &
        & 0.91200e-04_r8,0.98812e-04_r8,0.10432e-03_r8,0.10893e-03_r8,0.11349e-03_r8 /)
      kao(:,13, 3) = (/ &
        & 0.76217e-04_r8,0.82702e-04_r8,0.87500e-04_r8,0.91349e-04_r8,0.95349e-04_r8 /)
      kao(:, 1, 4) = (/ &
        & 0.71705e-03_r8,0.82743e-03_r8,0.94700e-03_r8,0.10670e-02_r8,0.11902e-02_r8 /)
      kao(:, 2, 4) = (/ &
        & 0.57909e-03_r8,0.67096e-03_r8,0.76724e-03_r8,0.86582e-03_r8,0.97167e-03_r8 /)
      kao(:, 3, 4) = (/ &
        & 0.44771e-03_r8,0.51997e-03_r8,0.59861e-03_r8,0.67967e-03_r8,0.76676e-03_r8 /)
      kao(:, 4, 4) = (/ &
        & 0.34085e-03_r8,0.39833e-03_r8,0.46226e-03_r8,0.52889e-03_r8,0.60008e-03_r8 /)
      kao(:, 5, 4) = (/ &
        & 0.26678e-03_r8,0.31234e-03_r8,0.36341e-03_r8,0.41663e-03_r8,0.47418e-03_r8 /)
      kao(:, 6, 4) = (/ &
        & 0.20903e-03_r8,0.24718e-03_r8,0.28922e-03_r8,0.33353e-03_r8,0.38176e-03_r8 /)
      kao(:, 7, 4) = (/ &
        & 0.17173e-03_r8,0.20330e-03_r8,0.23711e-03_r8,0.27401e-03_r8,0.31445e-03_r8 /)
      kao(:, 8, 4) = (/ &
        & 0.16722e-03_r8,0.19396e-03_r8,0.22307e-03_r8,0.25347e-03_r8,0.28561e-03_r8 /)
      kao(:, 9, 4) = (/ &
        & 0.25043e-03_r8,0.28824e-03_r8,0.32547e-03_r8,0.36193e-03_r8,0.39806e-03_r8 /)
      kao(:,10, 4) = (/ &
        & 0.43323e-03_r8,0.48667e-03_r8,0.53462e-03_r8,0.57879e-03_r8,0.62040e-03_r8 /)
      kao(:,11, 4) = (/ &
        & 0.47719e-03_r8,0.52271e-03_r8,0.56402e-03_r8,0.60388e-03_r8,0.63520e-03_r8 /)
      kao(:,12, 4) = (/ &
        & 0.45061e-03_r8,0.49014e-03_r8,0.52391e-03_r8,0.55276e-03_r8,0.57760e-03_r8 /)
      kao(:,13, 4) = (/ &
        & 0.37664e-03_r8,0.40952e-03_r8,0.43690e-03_r8,0.46055e-03_r8,0.48018e-03_r8 /)
      kao(:, 1, 5) = (/ &
        & 0.66466e-02_r8,0.68686e-02_r8,0.70897e-02_r8,0.73019e-02_r8,0.74914e-02_r8 /)
      kao(:, 2, 5) = (/ &
        & 0.54023e-02_r8,0.56010e-02_r8,0.58008e-02_r8,0.59987e-02_r8,0.61685e-02_r8 /)
      kao(:, 3, 5) = (/ &
        & 0.43218e-02_r8,0.45127e-02_r8,0.46848e-02_r8,0.48647e-02_r8,0.50267e-02_r8 /)
      kao(:, 4, 5) = (/ &
        & 0.34639e-02_r8,0.36473e-02_r8,0.37951e-02_r8,0.39570e-02_r8,0.41049e-02_r8 /)
      kao(:, 5, 5) = (/ &
        & 0.27745e-02_r8,0.29370e-02_r8,0.30754e-02_r8,0.32148e-02_r8,0.33492e-02_r8 /)
      kao(:, 6, 5) = (/ &
        & 0.22020e-02_r8,0.23520e-02_r8,0.24836e-02_r8,0.25965e-02_r8,0.27119e-02_r8 /)
      kao(:, 7, 5) = (/ &
        & 0.17624e-02_r8,0.18963e-02_r8,0.20161e-02_r8,0.21153e-02_r8,0.22116e-02_r8 /)
      kao(:, 8, 5) = (/ &
        & 0.14169e-02_r8,0.15332e-02_r8,0.16350e-02_r8,0.17231e-02_r8,0.18121e-02_r8 /)
      kao(:, 9, 5) = (/ &
        & 0.13030e-02_r8,0.13904e-02_r8,0.14690e-02_r8,0.15500e-02_r8,0.16275e-02_r8 /)
      kao(:,10, 5) = (/ &
        & 0.17155e-02_r8,0.18169e-02_r8,0.18943e-02_r8,0.19620e-02_r8,0.20215e-02_r8 /)
      kao(:,11, 5) = (/ &
        & 0.17156e-02_r8,0.17808e-02_r8,0.18419e-02_r8,0.18925e-02_r8,0.19313e-02_r8 /)
      kao(:,12, 5) = (/ &
        & 0.15269e-02_r8,0.15811e-02_r8,0.16283e-02_r8,0.16686e-02_r8,0.17061e-02_r8 /)
      kao(:,13, 5) = (/ &
        & 0.12768e-02_r8,0.13207e-02_r8,0.13555e-02_r8,0.13924e-02_r8,0.14234e-02_r8 /)
      kao(:, 1, 6) = (/ &
        & 0.19191e-01_r8,0.19463e-01_r8,0.19692e-01_r8,0.19900e-01_r8,0.20112e-01_r8 /)
      kao(:, 2, 6) = (/ &
        & 0.15967e-01_r8,0.16219e-01_r8,0.16426e-01_r8,0.16613e-01_r8,0.16805e-01_r8 /)
      kao(:, 3, 6) = (/ &
        & 0.13186e-01_r8,0.13411e-01_r8,0.13614e-01_r8,0.13785e-01_r8,0.13944e-01_r8 /)
      kao(:, 4, 6) = (/ &
        & 0.10935e-01_r8,0.11131e-01_r8,0.11318e-01_r8,0.11475e-01_r8,0.11620e-01_r8 /)
      kao(:, 5, 6) = (/ &
        & 0.90541e-02_r8,0.92344e-02_r8,0.94035e-02_r8,0.95537e-02_r8,0.96862e-02_r8 /)
      kao(:, 6, 6) = (/ &
        & 0.74724e-02_r8,0.76320e-02_r8,0.77794e-02_r8,0.79294e-02_r8,0.80528e-02_r8 /)
      kao(:, 7, 6) = (/ &
        & 0.61183e-02_r8,0.62644e-02_r8,0.63961e-02_r8,0.65303e-02_r8,0.66478e-02_r8 /)
      kao(:, 8, 6) = (/ &
        & 0.50638e-02_r8,0.51984e-02_r8,0.53222e-02_r8,0.54412e-02_r8,0.55465e-02_r8 /)
      kao(:, 9, 6) = (/ &
        & 0.42870e-02_r8,0.44009e-02_r8,0.45109e-02_r8,0.45976e-02_r8,0.46796e-02_r8 /)
      kao(:,10, 6) = (/ &
        & 0.45239e-02_r8,0.46073e-02_r8,0.46968e-02_r8,0.47979e-02_r8,0.48956e-02_r8 /)
      kao(:,11, 6) = (/ &
        & 0.44089e-02_r8,0.45006e-02_r8,0.45881e-02_r8,0.46721e-02_r8,0.48015e-02_r8 /)
      kao(:,12, 6) = (/ &
        & 0.39598e-02_r8,0.40290e-02_r8,0.41108e-02_r8,0.41899e-02_r8,0.42672e-02_r8 /)
      kao(:,13, 6) = (/ &
        & 0.33425e-02_r8,0.34148e-02_r8,0.34808e-02_r8,0.35405e-02_r8,0.35983e-02_r8 /)
      kao(:, 1, 7) = (/ &
        & 0.50165e-01_r8,0.50343e-01_r8,0.50452e-01_r8,0.50424e-01_r8,0.50329e-01_r8 /)
      kao(:, 2, 7) = (/ &
        & 0.42723e-01_r8,0.42880e-01_r8,0.42939e-01_r8,0.42910e-01_r8,0.42861e-01_r8 /)
      kao(:, 3, 7) = (/ &
        & 0.36117e-01_r8,0.36255e-01_r8,0.36301e-01_r8,0.36294e-01_r8,0.36288e-01_r8 /)
      kao(:, 4, 7) = (/ &
        & 0.30585e-01_r8,0.30720e-01_r8,0.30787e-01_r8,0.30816e-01_r8,0.30842e-01_r8 /)
      kao(:, 5, 7) = (/ &
        & 0.25879e-01_r8,0.26029e-01_r8,0.26116e-01_r8,0.26179e-01_r8,0.26225e-01_r8 /)
      kao(:, 6, 7) = (/ &
        & 0.21822e-01_r8,0.21978e-01_r8,0.22094e-01_r8,0.22178e-01_r8,0.22244e-01_r8 /)
      kao(:, 7, 7) = (/ &
        & 0.18304e-01_r8,0.18476e-01_r8,0.18606e-01_r8,0.18705e-01_r8,0.18780e-01_r8 /)
      kao(:, 8, 7) = (/ &
        & 0.15224e-01_r8,0.15394e-01_r8,0.15519e-01_r8,0.15619e-01_r8,0.15690e-01_r8 /)
      kao(:, 9, 7) = (/ &
        & 0.12835e-01_r8,0.13029e-01_r8,0.13169e-01_r8,0.13281e-01_r8,0.13369e-01_r8 /)
      kao(:,10, 7) = (/ &
        & 0.11632e-01_r8,0.11714e-01_r8,0.11760e-01_r8,0.11776e-01_r8,0.11806e-01_r8 /)
      kao(:,11, 7) = (/ &
        & 0.11170e-01_r8,0.11252e-01_r8,0.11288e-01_r8,0.11357e-01_r8,0.11397e-01_r8 /)
      kao(:,12, 7) = (/ &
        & 0.10404e-01_r8,0.10533e-01_r8,0.10705e-01_r8,0.10833e-01_r8,0.10947e-01_r8 /)
      kao(:,13, 7) = (/ &
        & 0.91041e-02_r8,0.92674e-02_r8,0.94068e-02_r8,0.95412e-02_r8,0.96769e-02_r8 /)
      kao(:, 1, 8) = (/ &
        & 0.14527e+00_r8,0.14483e+00_r8,0.14432e+00_r8,0.14389e+00_r8,0.14349e+00_r8 /)
      kao(:, 2, 8) = (/ &
        & 0.12739e+00_r8,0.12702e+00_r8,0.12661e+00_r8,0.12624e+00_r8,0.12584e+00_r8 /)
      kao(:, 3, 8) = (/ &
        & 0.11091e+00_r8,0.11058e+00_r8,0.11024e+00_r8,0.10990e+00_r8,0.10953e+00_r8 /)
      kao(:, 4, 8) = (/ &
        & 0.96590e-01_r8,0.96335e-01_r8,0.96105e-01_r8,0.95818e-01_r8,0.95530e-01_r8 /)
      kao(:, 5, 8) = (/ &
        & 0.83799e-01_r8,0.83708e-01_r8,0.83572e-01_r8,0.83347e-01_r8,0.83126e-01_r8 /)
      kao(:, 6, 8) = (/ &
        & 0.72369e-01_r8,0.72388e-01_r8,0.72289e-01_r8,0.72143e-01_r8,0.71981e-01_r8 /)
      kao(:, 7, 8) = (/ &
        & 0.62158e-01_r8,0.62247e-01_r8,0.62185e-01_r8,0.62111e-01_r8,0.62007e-01_r8 /)
      kao(:, 8, 8) = (/ &
        & 0.52998e-01_r8,0.53142e-01_r8,0.53162e-01_r8,0.53154e-01_r8,0.53101e-01_r8 /)
      kao(:, 9, 8) = (/ &
        & 0.44776e-01_r8,0.44873e-01_r8,0.44920e-01_r8,0.44946e-01_r8,0.44885e-01_r8 /)
      kao(:,10, 8) = (/ &
        & 0.38237e-01_r8,0.38514e-01_r8,0.38716e-01_r8,0.38877e-01_r8,0.38966e-01_r8 /)
      kao(:,11, 8) = (/ &
        & 0.33511e-01_r8,0.33721e-01_r8,0.33843e-01_r8,0.33840e-01_r8,0.33839e-01_r8 /)
      kao(:,12, 8) = (/ &
        & 0.29704e-01_r8,0.29825e-01_r8,0.29808e-01_r8,0.29787e-01_r8,0.29794e-01_r8 /)
      kao(:,13, 8) = (/ &
        & 0.25973e-01_r8,0.26004e-01_r8,0.26032e-01_r8,0.26023e-01_r8,0.26107e-01_r8 /)
      kao(:, 1, 9) = (/ &
        & 0.56699e+00_r8,0.56615e+00_r8,0.56479e+00_r8,0.56318e+00_r8,0.56135e+00_r8 /)
      kao(:, 2, 9) = (/ &
        & 0.53130e+00_r8,0.53096e+00_r8,0.53038e+00_r8,0.52953e+00_r8,0.52828e+00_r8 /)
      kao(:, 3, 9) = (/ &
        & 0.48947e+00_r8,0.48989e+00_r8,0.48991e+00_r8,0.48970e+00_r8,0.48916e+00_r8 /)
      kao(:, 4, 9) = (/ &
        & 0.44646e+00_r8,0.44756e+00_r8,0.44841e+00_r8,0.44893e+00_r8,0.44859e+00_r8 /)
      kao(:, 5, 9) = (/ &
        & 0.40428e+00_r8,0.40594e+00_r8,0.40746e+00_r8,0.40811e+00_r8,0.40825e+00_r8 /)
      kao(:, 6, 9) = (/ &
        & 0.36305e+00_r8,0.36545e+00_r8,0.36730e+00_r8,0.36814e+00_r8,0.36854e+00_r8 /)
      kao(:, 7, 9) = (/ &
        & 0.32383e+00_r8,0.32659e+00_r8,0.32849e+00_r8,0.32954e+00_r8,0.33028e+00_r8 /)
      kao(:, 8, 9) = (/ &
        & 0.28691e+00_r8,0.28966e+00_r8,0.29156e+00_r8,0.29286e+00_r8,0.29379e+00_r8 /)
      kao(:, 9, 9) = (/ &
        & 0.25109e+00_r8,0.25404e+00_r8,0.25607e+00_r8,0.25752e+00_r8,0.25870e+00_r8 /)
      kao(:,10, 9) = (/ &
        & 0.21600e+00_r8,0.21860e+00_r8,0.22047e+00_r8,0.22164e+00_r8,0.22251e+00_r8 /)
      kao(:,11, 9) = (/ &
        & 0.19149e+00_r8,0.19387e+00_r8,0.19567e+00_r8,0.19725e+00_r8,0.19809e+00_r8 /)
      kao(:,12, 9) = (/ &
        & 0.16914e+00_r8,0.17134e+00_r8,0.17303e+00_r8,0.17407e+00_r8,0.17494e+00_r8 /)
      kao(:,13, 9) = (/ &
        & 0.14841e+00_r8,0.15027e+00_r8,0.15244e+00_r8,0.15403e+00_r8,0.15523e+00_r8 /)
      kao(:, 1,10) = (/ &
        & 0.14885e+01_r8,0.14756e+01_r8,0.14663e+01_r8,0.14567e+01_r8,0.14479e+01_r8 /)
      kao(:, 2,10) = (/ &
        & 0.14911e+01_r8,0.14850e+01_r8,0.14762e+01_r8,0.14677e+01_r8,0.14597e+01_r8 /)
      kao(:, 3,10) = (/ &
        & 0.14749e+01_r8,0.14716e+01_r8,0.14663e+01_r8,0.14579e+01_r8,0.14502e+01_r8 /)
      kao(:, 4,10) = (/ &
        & 0.14314e+01_r8,0.14303e+01_r8,0.14232e+01_r8,0.14150e+01_r8,0.14115e+01_r8 /)
      kao(:, 5,10) = (/ &
        & 0.13616e+01_r8,0.13604e+01_r8,0.13539e+01_r8,0.13506e+01_r8,0.13501e+01_r8 /)
      kao(:, 6,10) = (/ &
        & 0.12710e+01_r8,0.12700e+01_r8,0.12670e+01_r8,0.12702e+01_r8,0.12745e+01_r8 /)
      kao(:, 7,10) = (/ &
        & 0.11674e+01_r8,0.11690e+01_r8,0.11727e+01_r8,0.11812e+01_r8,0.11854e+01_r8 /)
      kao(:, 8,10) = (/ &
        & 0.10584e+01_r8,0.10652e+01_r8,0.10757e+01_r8,0.10857e+01_r8,0.10906e+01_r8 /)
      kao(:, 9,10) = (/ &
        & 0.95450e+00_r8,0.96414e+00_r8,0.97673e+00_r8,0.98621e+00_r8,0.99187e+00_r8 /)
      kao(:,10,10) = (/ &
        & 0.83626e+00_r8,0.84690e+00_r8,0.85901e+00_r8,0.86824e+00_r8,0.87535e+00_r8 /)
      kao(:,11,10) = (/ &
        & 0.73738e+00_r8,0.74729e+00_r8,0.75610e+00_r8,0.75994e+00_r8,0.76481e+00_r8 /)
      kao(:,12,10) = (/ &
        & 0.66891e+00_r8,0.67622e+00_r8,0.68092e+00_r8,0.68498e+00_r8,0.68877e+00_r8 /)
      kao(:,13,10) = (/ &
        & 0.58616e+00_r8,0.59614e+00_r8,0.59749e+00_r8,0.60310e+00_r8,0.60445e+00_r8 /)
      kao(:, 1,11) = (/ &
        & 0.20080e+01_r8,0.19998e+01_r8,0.19844e+01_r8,0.19679e+01_r8,0.19504e+01_r8 /)
      kao(:, 2,11) = (/ &
        & 0.20896e+01_r8,0.20752e+01_r8,0.20596e+01_r8,0.20445e+01_r8,0.20293e+01_r8 /)
      kao(:, 3,11) = (/ &
        & 0.21262e+01_r8,0.21143e+01_r8,0.21043e+01_r8,0.20968e+01_r8,0.20862e+01_r8 /)
      kao(:, 4,11) = (/ &
        & 0.21310e+01_r8,0.21263e+01_r8,0.21243e+01_r8,0.21203e+01_r8,0.21144e+01_r8 /)
      kao(:, 5,11) = (/ &
        & 0.21041e+01_r8,0.21063e+01_r8,0.21071e+01_r8,0.21077e+01_r8,0.21021e+01_r8 /)
      kao(:, 6,11) = (/ &
        & 0.20447e+01_r8,0.20491e+01_r8,0.20534e+01_r8,0.20532e+01_r8,0.20477e+01_r8 /)
      kao(:, 7,11) = (/ &
        & 0.19487e+01_r8,0.19563e+01_r8,0.19608e+01_r8,0.19593e+01_r8,0.19591e+01_r8 /)
      kao(:, 8,11) = (/ &
        & 0.18239e+01_r8,0.18317e+01_r8,0.18359e+01_r8,0.18391e+01_r8,0.18451e+01_r8 /)
      kao(:, 9,11) = (/ &
        & 0.16772e+01_r8,0.16879e+01_r8,0.16955e+01_r8,0.17047e+01_r8,0.17179e+01_r8 /)
      kao(:,10,11) = (/ &
        & 0.15007e+01_r8,0.15184e+01_r8,0.15343e+01_r8,0.15540e+01_r8,0.15756e+01_r8 /)
      kao(:,11,11) = (/ &
        & 0.13041e+01_r8,0.13245e+01_r8,0.13445e+01_r8,0.13685e+01_r8,0.13888e+01_r8 /)
      kao(:,12,11) = (/ &
        & 0.11590e+01_r8,0.11749e+01_r8,0.11906e+01_r8,0.12046e+01_r8,0.12212e+01_r8 /)
      kao(:,13,11) = (/ &
        & 0.10681e+01_r8,0.10905e+01_r8,0.11017e+01_r8,0.10997e+01_r8,0.11116e+01_r8 /)
      kao(:, 1,12) = (/ &
        & 0.26762e+01_r8,0.26701e+01_r8,0.26710e+01_r8,0.26742e+01_r8,0.26733e+01_r8 /)
      kao(:, 2,12) = (/ &
        & 0.28804e+01_r8,0.28775e+01_r8,0.28798e+01_r8,0.28773e+01_r8,0.28700e+01_r8 /)
      kao(:, 3,12) = (/ &
        & 0.30825e+01_r8,0.30790e+01_r8,0.30757e+01_r8,0.30631e+01_r8,0.30471e+01_r8 /)
      kao(:, 4,12) = (/ &
        & 0.32355e+01_r8,0.32278e+01_r8,0.32144e+01_r8,0.31959e+01_r8,0.31753e+01_r8 /)
      kao(:, 5,12) = (/ &
        & 0.33271e+01_r8,0.33191e+01_r8,0.33073e+01_r8,0.32879e+01_r8,0.32714e+01_r8 /)
      kao(:, 6,12) = (/ &
        & 0.33604e+01_r8,0.33571e+01_r8,0.33478e+01_r8,0.33355e+01_r8,0.33272e+01_r8 /)
      kao(:, 7,12) = (/ &
        & 0.33406e+01_r8,0.33436e+01_r8,0.33436e+01_r8,0.33435e+01_r8,0.33409e+01_r8 /)
      kao(:, 8,12) = (/ &
        & 0.32648e+01_r8,0.32808e+01_r8,0.32919e+01_r8,0.32976e+01_r8,0.32999e+01_r8 /)
      kao(:, 9,12) = (/ &
        & 0.31373e+01_r8,0.31630e+01_r8,0.31816e+01_r8,0.31936e+01_r8,0.31991e+01_r8 /)
      kao(:,10,12) = (/ &
        & 0.29678e+01_r8,0.29982e+01_r8,0.30244e+01_r8,0.30412e+01_r8,0.30500e+01_r8 /)
      kao(:,11,12) = (/ &
        & 0.27380e+01_r8,0.27731e+01_r8,0.28013e+01_r8,0.28227e+01_r8,0.28455e+01_r8 /)
      kao(:,12,12) = (/ &
        & 0.24616e+01_r8,0.24905e+01_r8,0.25348e+01_r8,0.25805e+01_r8,0.26155e+01_r8 /)
      kao(:,13,12) = (/ &
        & 0.22251e+01_r8,0.22562e+01_r8,0.22966e+01_r8,0.23312e+01_r8,0.23811e+01_r8 /)
      kao(:, 1,13) = (/ &
        & 0.38031e+01_r8,0.37992e+01_r8,0.37926e+01_r8,0.37822e+01_r8,0.37755e+01_r8 /)
      kao(:, 2,13) = (/ &
        & 0.41542e+01_r8,0.41473e+01_r8,0.41391e+01_r8,0.41329e+01_r8,0.41296e+01_r8 /)
      kao(:, 3,13) = (/ &
        & 0.44998e+01_r8,0.44963e+01_r8,0.44896e+01_r8,0.44914e+01_r8,0.44937e+01_r8 /)
      kao(:, 4,13) = (/ &
        & 0.48464e+01_r8,0.48445e+01_r8,0.48485e+01_r8,0.48565e+01_r8,0.48598e+01_r8 /)
      kao(:, 5,13) = (/ &
        & 0.52074e+01_r8,0.52112e+01_r8,0.52168e+01_r8,0.52231e+01_r8,0.52210e+01_r8 /)
      kao(:, 6,13) = (/ &
        & 0.55492e+01_r8,0.55575e+01_r8,0.55655e+01_r8,0.55693e+01_r8,0.55642e+01_r8 /)
      kao(:, 7,13) = (/ &
        & 0.58380e+01_r8,0.58479e+01_r8,0.58509e+01_r8,0.58482e+01_r8,0.58453e+01_r8 /)
      kao(:, 8,13) = (/ &
        & 0.60377e+01_r8,0.60538e+01_r8,0.60594e+01_r8,0.60647e+01_r8,0.60640e+01_r8 /)
      kao(:, 9,13) = (/ &
        & 0.61268e+01_r8,0.61532e+01_r8,0.61730e+01_r8,0.61888e+01_r8,0.61993e+01_r8 /)
      kao(:,10,13) = (/ &
        & 0.61216e+01_r8,0.61612e+01_r8,0.61936e+01_r8,0.62230e+01_r8,0.62454e+01_r8 /)
      kao(:,11,13) = (/ &
        & 0.60409e+01_r8,0.60960e+01_r8,0.61462e+01_r8,0.61882e+01_r8,0.62219e+01_r8 /)
      kao(:,12,13) = (/ &
        & 0.58645e+01_r8,0.59597e+01_r8,0.60234e+01_r8,0.60826e+01_r8,0.61390e+01_r8 /)
      kao(:,13,13) = (/ &
        & 0.56001e+01_r8,0.57009e+01_r8,0.58017e+01_r8,0.59181e+01_r8,0.59860e+01_r8 /)
      kao(:, 1,14) = (/ &
        & 0.53647e+01_r8,0.53127e+01_r8,0.52736e+01_r8,0.52471e+01_r8,0.52264e+01_r8 /)
      kao(:, 2,14) = (/ &
        & 0.62359e+01_r8,0.61753e+01_r8,0.61253e+01_r8,0.60847e+01_r8,0.60573e+01_r8 /)
      kao(:, 3,14) = (/ &
        & 0.72065e+01_r8,0.71249e+01_r8,0.70556e+01_r8,0.69965e+01_r8,0.69559e+01_r8 /)
      kao(:, 4,14) = (/ &
        & 0.81631e+01_r8,0.80714e+01_r8,0.79828e+01_r8,0.79081e+01_r8,0.78545e+01_r8 /)
      kao(:, 5,14) = (/ &
        & 0.90691e+01_r8,0.89602e+01_r8,0.88621e+01_r8,0.87858e+01_r8,0.87314e+01_r8 /)
      kao(:, 6,14) = (/ &
        & 0.99707e+01_r8,0.98474e+01_r8,0.97395e+01_r8,0.96541e+01_r8,0.95904e+01_r8 /)
      kao(:, 7,14) = (/ &
        & 0.10852e+02_r8,0.10724e+02_r8,0.10620e+02_r8,0.10536e+02_r8,0.10469e+02_r8 /)
      kao(:, 8,14) = (/ &
        & 0.11716e+02_r8,0.11588e+02_r8,0.11487e+02_r8,0.11403e+02_r8,0.11337e+02_r8 /)
      kao(:, 9,14) = (/ &
        & 0.12572e+02_r8,0.12448e+02_r8,0.12341e+02_r8,0.12260e+02_r8,0.12188e+02_r8 /)
      kao(:,10,14) = (/ &
        & 0.13374e+02_r8,0.13256e+02_r8,0.13159e+02_r8,0.13080e+02_r8,0.13010e+02_r8 /)
      kao(:,11,14) = (/ &
        & 0.14046e+02_r8,0.13957e+02_r8,0.13888e+02_r8,0.13824e+02_r8,0.13769e+02_r8 /)
      kao(:,12,14) = (/ &
        & 0.14644e+02_r8,0.14592e+02_r8,0.14548e+02_r8,0.14504e+02_r8,0.14461e+02_r8 /)
      kao(:,13,14) = (/ &
        & 0.15144e+02_r8,0.15129e+02_r8,0.15111e+02_r8,0.15095e+02_r8,0.15074e+02_r8 /)
      kao(:, 1,15) = (/ &
        & 0.72019e+01_r8,0.71097e+01_r8,0.70236e+01_r8,0.69449e+01_r8,0.68844e+01_r8 /)
      kao(:, 2,15) = (/ &
        & 0.87604e+01_r8,0.86468e+01_r8,0.85349e+01_r8,0.84375e+01_r8,0.83491e+01_r8 /)
      kao(:, 3,15) = (/ &
        & 0.10615e+02_r8,0.10469e+02_r8,0.10333e+02_r8,0.10214e+02_r8,0.10099e+02_r8 /)
      kao(:, 4,15) = (/ &
        & 0.12669e+02_r8,0.12473e+02_r8,0.12305e+02_r8,0.12161e+02_r8,0.12026e+02_r8 /)
      kao(:, 5,15) = (/ &
        & 0.14978e+02_r8,0.14741e+02_r8,0.14530e+02_r8,0.14329e+02_r8,0.14143e+02_r8 /)
      kao(:, 6,15) = (/ &
        & 0.17562e+02_r8,0.17282e+02_r8,0.17031e+02_r8,0.16791e+02_r8,0.16552e+02_r8 /)
      kao(:, 7,15) = (/ &
        & 0.20480e+02_r8,0.20136e+02_r8,0.19827e+02_r8,0.19524e+02_r8,0.19223e+02_r8 /)
      kao(:, 8,15) = (/ &
        & 0.23734e+02_r8,0.23307e+02_r8,0.22908e+02_r8,0.22521e+02_r8,0.22160e+02_r8 /)
      kao(:, 9,15) = (/ &
        & 0.27249e+02_r8,0.26733e+02_r8,0.26255e+02_r8,0.25787e+02_r8,0.25354e+02_r8 /)
      kao(:,10,15) = (/ &
        & 0.30889e+02_r8,0.30311e+02_r8,0.29740e+02_r8,0.29192e+02_r8,0.28690e+02_r8 /)
      kao(:,11,15) = (/ &
        & 0.34366e+02_r8,0.33687e+02_r8,0.33035e+02_r8,0.32430e+02_r8,0.31843e+02_r8 /)
      kao(:,12,15) = (/ &
        & 0.37839e+02_r8,0.37085e+02_r8,0.36360e+02_r8,0.35655e+02_r8,0.34957e+02_r8 /)
      kao(:,13,15) = (/ &
        & 0.41323e+02_r8,0.40503e+02_r8,0.39673e+02_r8,0.38847e+02_r8,0.38049e+02_r8 /)
      kao(:, 1,16) = (/ &
        & 0.82631e+01_r8,0.81761e+01_r8,0.80809e+01_r8,0.79778e+01_r8,0.79010e+01_r8 /)
      kao(:, 2,16) = (/ &
        & 0.10258e+02_r8,0.10128e+02_r8,0.10005e+02_r8,0.98803e+01_r8,0.97700e+01_r8 /)
      kao(:, 3,16) = (/ &
        & 0.12786e+02_r8,0.12614e+02_r8,0.12441e+02_r8,0.12267e+02_r8,0.12120e+02_r8 /)
      kao(:, 4,16) = (/ &
        & 0.15843e+02_r8,0.15549e+02_r8,0.15326e+02_r8,0.15095e+02_r8,0.14871e+02_r8 /)
      kao(:, 5,16) = (/ &
        & 0.19543e+02_r8,0.19089e+02_r8,0.18733e+02_r8,0.18430e+02_r8,0.18134e+02_r8 /)
      kao(:, 6,16) = (/ &
        & 0.24038e+02_r8,0.23415e+02_r8,0.22893e+02_r8,0.22427e+02_r8,0.22005e+02_r8 /)
      kao(:, 7,16) = (/ &
        & 0.29445e+02_r8,0.28630e+02_r8,0.27921e+02_r8,0.27268e+02_r8,0.26654e+02_r8 /)
      kao(:, 8,16) = (/ &
        & 0.35889e+02_r8,0.34849e+02_r8,0.33913e+02_r8,0.33036e+02_r8,0.32194e+02_r8 /)
      kao(:, 9,16) = (/ &
        & 0.43512e+02_r8,0.42175e+02_r8,0.40956e+02_r8,0.39809e+02_r8,0.38685e+02_r8 /)
      kao(:,10,16) = (/ &
        & 0.52253e+02_r8,0.50582e+02_r8,0.49011e+02_r8,0.47508e+02_r8,0.46037e+02_r8 /)
      kao(:,11,16) = (/ &
        & 0.61290e+02_r8,0.59240e+02_r8,0.57269e+02_r8,0.55343e+02_r8,0.53572e+02_r8 /)
      kao(:,12,16) = (/ &
        & 0.71193e+02_r8,0.68607e+02_r8,0.66135e+02_r8,0.63828e+02_r8,0.61720e+02_r8 /)
      kao(:,13,16) = (/ &
        & 0.81988e+02_r8,0.78665e+02_r8,0.75707e+02_r8,0.72932e+02_r8,0.70347e+02_r8 /)
  
!     -----------------------------------------------------------------
!     The array KBO contains absorption coefs at the 16 chosen g-values 
!     for a range of pressure levels < ~100mb and temperatures. The first 
!     index in the array, JT, which runs from 1 to 5, corresponds to 
!     different temperatures.  More specifically, JT = 3 means that the 
!     data are for the reference temperature TREF for this pressure 
!     level, JT = 2 refers to the temperature TREF-15, JT = 1 is for
!     TREF-30, JT = 4 is for TREF+15, and JT = 5 is for TREF+30.  
!     The second index, JP, runs from 13 to 59 and refers to the JPth
!     reference pressure level (see taumol.f for the value of these
!     pressure levels in mb).  The third index, IG, goes from 1 to 16,
!     and tells us which g-interval the absorption coefficients are for.
!     -----------------------------------------------------------------

      kbo(:,13, 1) = (/ &
        & 0.29597e-05_r8,0.31929e-05_r8,0.34159e-05_r8,0.36256e-05_r8,0.38264e-05_r8 /)
      kbo(:,14, 1) = (/ &
        & 0.24233e-05_r8,0.26151e-05_r8,0.27866e-05_r8,0.29502e-05_r8,0.31170e-05_r8 /)
      kbo(:,15, 1) = (/ &
        & 0.19206e-05_r8,0.20789e-05_r8,0.22099e-05_r8,0.23383e-05_r8,0.24505e-05_r8 /)
      kbo(:,16, 1) = (/ &
        & 0.14933e-05_r8,0.16071e-05_r8,0.17039e-05_r8,0.17994e-05_r8,0.18816e-05_r8 /)
      kbo(:,17, 1) = (/ &
        & 0.11429e-05_r8,0.12144e-05_r8,0.12895e-05_r8,0.13503e-05_r8,0.14174e-05_r8 /)
      kbo(:,18, 1) = (/ &
        & 0.84134e-06_r8,0.89264e-06_r8,0.94260e-06_r8,0.99003e-06_r8,0.10391e-05_r8 /)
      kbo(:,19, 1) = (/ &
        & 0.60683e-06_r8,0.64142e-06_r8,0.68018e-06_r8,0.72042e-06_r8,0.75479e-06_r8 /)
      kbo(:,20, 1) = (/ &
        & 0.45809e-06_r8,0.48813e-06_r8,0.51934e-06_r8,0.54823e-06_r8,0.57261e-06_r8 /)
      kbo(:,21, 1) = (/ &
        & 0.35219e-06_r8,0.37835e-06_r8,0.40322e-06_r8,0.42772e-06_r8,0.44736e-06_r8 /)
      kbo(:,22, 1) = (/ &
        & 0.27419e-06_r8,0.29542e-06_r8,0.31617e-06_r8,0.33398e-06_r8,0.34932e-06_r8 /)
      kbo(:,23, 1) = (/ &
        & 0.21385e-06_r8,0.23127e-06_r8,0.24670e-06_r8,0.25951e-06_r8,0.26952e-06_r8 /)
      kbo(:,24, 1) = (/ &
        & 0.16767e-06_r8,0.18179e-06_r8,0.19282e-06_r8,0.20136e-06_r8,0.21113e-06_r8 /)
      kbo(:,25, 1) = (/ &
        & 0.13361e-06_r8,0.14301e-06_r8,0.14980e-06_r8,0.15778e-06_r8,0.16615e-06_r8 /)
      kbo(:,26, 1) = (/ &
        & 0.10615e-06_r8,0.11218e-06_r8,0.11889e-06_r8,0.12574e-06_r8,0.13111e-06_r8 /)
      kbo(:,27, 1) = (/ &
        & 0.83660e-07_r8,0.89296e-07_r8,0.95019e-07_r8,0.10007e-06_r8,0.10397e-06_r8 /)
      kbo(:,28, 1) = (/ &
        & 0.66667e-07_r8,0.71217e-07_r8,0.75615e-07_r8,0.79237e-07_r8,0.82239e-07_r8 /)
      kbo(:,29, 1) = (/ &
        & 0.52776e-07_r8,0.56086e-07_r8,0.59828e-07_r8,0.62513e-07_r8,0.64218e-07_r8 /)
      kbo(:,30, 1) = (/ &
        & 0.41429e-07_r8,0.44370e-07_r8,0.46731e-07_r8,0.48553e-07_r8,0.50143e-07_r8 /)
      kbo(:,31, 1) = (/ &
        & 0.32437e-07_r8,0.34523e-07_r8,0.36208e-07_r8,0.37500e-07_r8,0.38571e-07_r8 /)
      kbo(:,32, 1) = (/ &
        & 0.25237e-07_r8,0.26730e-07_r8,0.27868e-07_r8,0.28829e-07_r8,0.29943e-07_r8 /)
      kbo(:,33, 1) = (/ &
        & 0.19545e-07_r8,0.20614e-07_r8,0.21467e-07_r8,0.22280e-07_r8,0.23141e-07_r8 /)
      kbo(:,34, 1) = (/ &
        & 0.15146e-07_r8,0.15869e-07_r8,0.16509e-07_r8,0.17179e-07_r8,0.17980e-07_r8 /)
      kbo(:,35, 1) = (/ &
        & 0.11482e-07_r8,0.12039e-07_r8,0.12547e-07_r8,0.13255e-07_r8,0.13874e-07_r8 /)
      kbo(:,36, 1) = (/ &
        & 0.86172e-08_r8,0.90023e-08_r8,0.95607e-08_r8,0.10106e-07_r8,0.10595e-07_r8 /)
      kbo(:,37, 1) = (/ &
        & 0.67411e-08_r8,0.70781e-08_r8,0.75553e-08_r8,0.79739e-08_r8,0.84011e-08_r8 /)
      kbo(:,38, 1) = (/ &
        & 0.52604e-08_r8,0.55743e-08_r8,0.59410e-08_r8,0.63031e-08_r8,0.66516e-08_r8 /)
      kbo(:,39, 1) = (/ &
        & 0.41129e-08_r8,0.43854e-08_r8,0.46851e-08_r8,0.49771e-08_r8,0.52463e-08_r8 /)
      kbo(:,40, 1) = (/ &
        & 0.33089e-08_r8,0.35289e-08_r8,0.37702e-08_r8,0.40125e-08_r8,0.42415e-08_r8 /)
      kbo(:,41, 1) = (/ &
        & 0.26794e-08_r8,0.28488e-08_r8,0.30428e-08_r8,0.32437e-08_r8,0.34420e-08_r8 /)
      kbo(:,42, 1) = (/ &
        & 0.21670e-08_r8,0.23030e-08_r8,0.24589e-08_r8,0.26252e-08_r8,0.27867e-08_r8 /)
      kbo(:,43, 1) = (/ &
        & 0.17699e-08_r8,0.18853e-08_r8,0.20001e-08_r8,0.21330e-08_r8,0.22657e-08_r8 /)
      kbo(:,44, 1) = (/ &
        & 0.14446e-08_r8,0.15471e-08_r8,0.16397e-08_r8,0.17423e-08_r8,0.18526e-08_r8 /)
      kbo(:,45, 1) = (/ &
        & 0.11734e-08_r8,0.12754e-08_r8,0.13542e-08_r8,0.14242e-08_r8,0.15193e-08_r8 /)
      kbo(:,46, 1) = (/ &
        & 0.95743e-09_r8,0.10470e-08_r8,0.11183e-08_r8,0.11726e-08_r8,0.12389e-08_r8 /)
      kbo(:,47, 1) = (/ &
        & 0.77345e-09_r8,0.85197e-09_r8,0.92184e-09_r8,0.97368e-09_r8,0.10149e-08_r8 /)
      kbo(:,48, 1) = (/ &
        & 0.62500e-09_r8,0.69288e-09_r8,0.75548e-09_r8,0.80446e-09_r8,0.84428e-09_r8 /)
      kbo(:,49, 1) = (/ &
        & 0.50095e-09_r8,0.55967e-09_r8,0.61904e-09_r8,0.66441e-09_r8,0.70339e-09_r8 /)
      kbo(:,50, 1) = (/ &
        & 0.40806e-09_r8,0.45712e-09_r8,0.50530e-09_r8,0.54974e-09_r8,0.58246e-09_r8 /)
      kbo(:,51, 1) = (/ &
        & 0.33102e-09_r8,0.37130e-09_r8,0.41121e-09_r8,0.45024e-09_r8,0.48436e-09_r8 /)
      kbo(:,52, 1) = (/ &
        & 0.26906e-09_r8,0.30739e-09_r8,0.33845e-09_r8,0.36884e-09_r8,0.40024e-09_r8 /)
      kbo(:,53, 1) = (/ &
        & 0.22202e-09_r8,0.25108e-09_r8,0.27937e-09_r8,0.30592e-09_r8,0.33012e-09_r8 /)
      kbo(:,54, 1) = (/ &
        & 0.18662e-09_r8,0.20761e-09_r8,0.23072e-09_r8,0.25342e-09_r8,0.27445e-09_r8 /)
      kbo(:,55, 1) = (/ &
        & 0.15741e-09_r8,0.17147e-09_r8,0.19146e-09_r8,0.21029e-09_r8,0.22857e-09_r8 /)
      kbo(:,56, 1) = (/ &
        & 0.13151e-09_r8,0.14637e-09_r8,0.15977e-09_r8,0.17547e-09_r8,0.18974e-09_r8 /)
      kbo(:,57, 1) = (/ &
        & 0.10874e-09_r8,0.12447e-09_r8,0.13634e-09_r8,0.14752e-09_r8,0.16022e-09_r8 /)
      kbo(:,58, 1) = (/ &
        & 0.90206e-10_r8,0.10484e-09_r8,0.11617e-09_r8,0.12545e-09_r8,0.13474e-09_r8 /)
      kbo(:,59, 1) = (/ &
        & 0.76759e-10_r8,0.88866e-10_r8,0.99340e-10_r8,0.10706e-09_r8,0.11444e-09_r8 /)
      kbo(:,13, 2) = (/ &
        & 0.14727e-04_r8,0.16357e-04_r8,0.17961e-04_r8,0.19530e-04_r8,0.20852e-04_r8 /)
      kbo(:,14, 2) = (/ &
        & 0.12148e-04_r8,0.13478e-04_r8,0.14818e-04_r8,0.16049e-04_r8,0.17100e-04_r8 /)
      kbo(:,15, 2) = (/ &
        & 0.96902e-05_r8,0.10787e-04_r8,0.11835e-04_r8,0.12770e-04_r8,0.13515e-04_r8 /)
      kbo(:,16, 2) = (/ &
        & 0.76235e-05_r8,0.84575e-05_r8,0.92217e-05_r8,0.98526e-05_r8,0.10449e-04_r8 /)
      kbo(:,17, 2) = (/ &
        & 0.58049e-05_r8,0.64239e-05_r8,0.69733e-05_r8,0.74131e-05_r8,0.78082e-05_r8 /)
      kbo(:,18, 2) = (/ &
        & 0.43204e-05_r8,0.47510e-05_r8,0.51165e-05_r8,0.54579e-05_r8,0.57434e-05_r8 /)
      kbo(:,19, 2) = (/ &
        & 0.32211e-05_r8,0.35327e-05_r8,0.38175e-05_r8,0.40535e-05_r8,0.42245e-05_r8 /)
      kbo(:,20, 2) = (/ &
        & 0.25265e-05_r8,0.27652e-05_r8,0.29644e-05_r8,0.31331e-05_r8,0.32730e-05_r8 /)
      kbo(:,21, 2) = (/ &
        & 0.19921e-05_r8,0.21749e-05_r8,0.23343e-05_r8,0.24377e-05_r8,0.25458e-05_r8 /)
      kbo(:,22, 2) = (/ &
        & 0.15859e-05_r8,0.17259e-05_r8,0.18236e-05_r8,0.19124e-05_r8,0.19942e-05_r8 /)
      kbo(:,23, 2) = (/ &
        & 0.12591e-05_r8,0.13565e-05_r8,0.14309e-05_r8,0.15032e-05_r8,0.15642e-05_r8 /)
      kbo(:,24, 2) = (/ &
        & 0.10012e-05_r8,0.10701e-05_r8,0.11246e-05_r8,0.11819e-05_r8,0.12279e-05_r8 /)
      kbo(:,25, 2) = (/ &
        & 0.78985e-06_r8,0.84074e-06_r8,0.89029e-06_r8,0.93145e-06_r8,0.97085e-06_r8 /)
      kbo(:,26, 2) = (/ &
        & 0.62996e-06_r8,0.66847e-06_r8,0.70637e-06_r8,0.73513e-06_r8,0.77135e-06_r8 /)
      kbo(:,27, 2) = (/ &
        & 0.50283e-06_r8,0.53111e-06_r8,0.55653e-06_r8,0.58306e-06_r8,0.61799e-06_r8 /)
      kbo(:,28, 2) = (/ &
        & 0.39962e-06_r8,0.42320e-06_r8,0.44265e-06_r8,0.46715e-06_r8,0.49516e-06_r8 /)
      kbo(:,29, 2) = (/ &
        & 0.31810e-06_r8,0.33597e-06_r8,0.35191e-06_r8,0.37448e-06_r8,0.39768e-06_r8 /)
      kbo(:,30, 2) = (/ &
        & 0.25242e-06_r8,0.26447e-06_r8,0.28109e-06_r8,0.30089e-06_r8,0.31543e-06_r8 /)
      kbo(:,31, 2) = (/ &
        & 0.19837e-06_r8,0.20954e-06_r8,0.22442e-06_r8,0.23762e-06_r8,0.25183e-06_r8 /)
      kbo(:,32, 2) = (/ &
        & 0.15599e-06_r8,0.16701e-06_r8,0.17789e-06_r8,0.18880e-06_r8,0.20030e-06_r8 /)
      kbo(:,33, 2) = (/ &
        & 0.12307e-06_r8,0.13211e-06_r8,0.14046e-06_r8,0.15111e-06_r8,0.15988e-06_r8 /)
      kbo(:,34, 2) = (/ &
        & 0.98429e-07_r8,0.10498e-06_r8,0.11326e-06_r8,0.12074e-06_r8,0.12779e-06_r8 /)
      kbo(:,35, 2) = (/ &
        & 0.77743e-07_r8,0.83951e-07_r8,0.90473e-07_r8,0.96277e-07_r8,0.10204e-06_r8 /)
      kbo(:,36, 2) = (/ &
        & 0.61220e-07_r8,0.66399e-07_r8,0.71102e-07_r8,0.75946e-07_r8,0.80803e-07_r8 /)
      kbo(:,37, 2) = (/ &
        & 0.48819e-07_r8,0.52962e-07_r8,0.56669e-07_r8,0.60817e-07_r8,0.64709e-07_r8 /)
      kbo(:,38, 2) = (/ &
        & 0.38871e-07_r8,0.42226e-07_r8,0.45376e-07_r8,0.48641e-07_r8,0.51855e-07_r8 /)
      kbo(:,39, 2) = (/ &
        & 0.30869e-07_r8,0.33485e-07_r8,0.36233e-07_r8,0.38868e-07_r8,0.41523e-07_r8 /)
      kbo(:,40, 2) = (/ &
        & 0.24798e-07_r8,0.26983e-07_r8,0.29180e-07_r8,0.31437e-07_r8,0.33600e-07_r8 /)
      kbo(:,41, 2) = (/ &
        & 0.19951e-07_r8,0.21784e-07_r8,0.23518e-07_r8,0.25460e-07_r8,0.27219e-07_r8 /)
      kbo(:,42, 2) = (/ &
        & 0.16098e-07_r8,0.17542e-07_r8,0.18979e-07_r8,0.20547e-07_r8,0.22016e-07_r8 /)
      kbo(:,43, 2) = (/ &
        & 0.13020e-07_r8,0.14144e-07_r8,0.15414e-07_r8,0.16610e-07_r8,0.17870e-07_r8 /)
      kbo(:,44, 2) = (/ &
        & 0.10548e-07_r8,0.11500e-07_r8,0.12492e-07_r8,0.13520e-07_r8,0.14524e-07_r8 /)
      kbo(:,45, 2) = (/ &
        & 0.85602e-08_r8,0.93245e-08_r8,0.10096e-07_r8,0.10978e-07_r8,0.11819e-07_r8 /)
      kbo(:,46, 2) = (/ &
        & 0.69149e-08_r8,0.75653e-08_r8,0.82154e-08_r8,0.88822e-08_r8,0.96002e-08_r8 /)
      kbo(:,47, 2) = (/ &
        & 0.55708e-08_r8,0.61164e-08_r8,0.66678e-08_r8,0.71922e-08_r8,0.77633e-08_r8 /)
      kbo(:,48, 2) = (/ &
        & 0.44804e-08_r8,0.49312e-08_r8,0.53967e-08_r8,0.58662e-08_r8,0.62780e-08_r8 /)
      kbo(:,49, 2) = (/ &
        & 0.36467e-08_r8,0.39866e-08_r8,0.43628e-08_r8,0.47589e-08_r8,0.51208e-08_r8 /)
      kbo(:,50, 2) = (/ &
        & 0.29524e-08_r8,0.32540e-08_r8,0.35471e-08_r8,0.38638e-08_r8,0.41887e-08_r8 /)
      kbo(:,51, 2) = (/ &
        & 0.23887e-08_r8,0.26526e-08_r8,0.28959e-08_r8,0.31504e-08_r8,0.34112e-08_r8 /)
      kbo(:,52, 2) = (/ &
        & 0.19321e-08_r8,0.21648e-08_r8,0.23625e-08_r8,0.25839e-08_r8,0.28173e-08_r8 /)
      kbo(:,53, 2) = (/ &
        & 0.15684e-08_r8,0.17725e-08_r8,0.19476e-08_r8,0.21240e-08_r8,0.23118e-08_r8 /)
      kbo(:,54, 2) = (/ &
        & 0.12799e-08_r8,0.14467e-08_r8,0.16073e-08_r8,0.17494e-08_r8,0.19160e-08_r8 /)
      kbo(:,55, 2) = (/ &
        & 0.10442e-08_r8,0.11911e-08_r8,0.13216e-08_r8,0.14537e-08_r8,0.15771e-08_r8 /)
      kbo(:,56, 2) = (/ &
        & 0.85741e-09_r8,0.97937e-09_r8,0.10936e-08_r8,0.12056e-08_r8,0.13167e-08_r8 /)
      kbo(:,57, 2) = (/ &
        & 0.70358e-09_r8,0.80334e-09_r8,0.90824e-09_r8,0.10056e-08_r8,0.11010e-08_r8 /)
      kbo(:,58, 2) = (/ &
        & 0.57428e-09_r8,0.66441e-09_r8,0.75420e-09_r8,0.83627e-09_r8,0.92485e-09_r8 /)
      kbo(:,59, 2) = (/ &
        & 0.47922e-09_r8,0.55592e-09_r8,0.63499e-09_r8,0.70731e-09_r8,0.78678e-09_r8 /)
      kbo(:,13, 3) = (/ &
        & 0.76201e-04_r8,0.82699e-04_r8,0.87499e-04_r8,0.91352e-04_r8,0.95348e-04_r8 /)
      kbo(:,14, 3) = (/ &
        & 0.62821e-04_r8,0.67861e-04_r8,0.71868e-04_r8,0.75108e-04_r8,0.78557e-04_r8 /)
      kbo(:,15, 3) = (/ &
        & 0.49775e-04_r8,0.53367e-04_r8,0.56639e-04_r8,0.59001e-04_r8,0.62303e-04_r8 /)
      kbo(:,16, 3) = (/ &
        & 0.38005e-04_r8,0.40883e-04_r8,0.43269e-04_r8,0.45403e-04_r8,0.48139e-04_r8 /)
      kbo(:,17, 3) = (/ &
        & 0.28550e-04_r8,0.30750e-04_r8,0.32331e-04_r8,0.34489e-04_r8,0.36687e-04_r8 /)
      kbo(:,18, 3) = (/ &
        & 0.20976e-04_r8,0.22322e-04_r8,0.23743e-04_r8,0.25554e-04_r8,0.27223e-04_r8 /)
      kbo(:,19, 3) = (/ &
        & 0.15389e-04_r8,0.16422e-04_r8,0.17792e-04_r8,0.19127e-04_r8,0.20295e-04_r8 /)
      kbo(:,20, 3) = (/ &
        & 0.11883e-04_r8,0.12816e-04_r8,0.13962e-04_r8,0.14872e-04_r8,0.15725e-04_r8 /)
      kbo(:,21, 3) = (/ &
        & 0.92948e-05_r8,0.10187e-04_r8,0.10986e-04_r8,0.11713e-04_r8,0.12426e-04_r8 /)
      kbo(:,22, 3) = (/ &
        & 0.73969e-05_r8,0.80840e-05_r8,0.87263e-05_r8,0.93856e-05_r8,0.99533e-05_r8 /)
      kbo(:,23, 3) = (/ &
        & 0.58961e-05_r8,0.64591e-05_r8,0.69648e-05_r8,0.74494e-05_r8,0.79385e-05_r8 /)
      kbo(:,24, 3) = (/ &
        & 0.47445e-05_r8,0.51742e-05_r8,0.56036e-05_r8,0.59758e-05_r8,0.63724e-05_r8 /)
      kbo(:,25, 3) = (/ &
        & 0.38442e-05_r8,0.41791e-05_r8,0.44837e-05_r8,0.48078e-05_r8,0.51294e-05_r8 /)
      kbo(:,26, 3) = (/ &
        & 0.31335e-05_r8,0.33923e-05_r8,0.36400e-05_r8,0.38961e-05_r8,0.41487e-05_r8 /)
      kbo(:,27, 3) = (/ &
        & 0.25499e-05_r8,0.27432e-05_r8,0.29560e-05_r8,0.31545e-05_r8,0.33433e-05_r8 /)
      kbo(:,28, 3) = (/ &
        & 0.20635e-05_r8,0.22231e-05_r8,0.23897e-05_r8,0.25516e-05_r8,0.26938e-05_r8 /)
      kbo(:,29, 3) = (/ &
        & 0.16635e-05_r8,0.18024e-05_r8,0.19279e-05_r8,0.20498e-05_r8,0.21627e-05_r8 /)
      kbo(:,30, 3) = (/ &
        & 0.13359e-05_r8,0.14474e-05_r8,0.15470e-05_r8,0.16346e-05_r8,0.17457e-05_r8 /)
      kbo(:,31, 3) = (/ &
        & 0.10697e-05_r8,0.11477e-05_r8,0.12254e-05_r8,0.13097e-05_r8,0.13914e-05_r8 /)
      kbo(:,32, 3) = (/ &
        & 0.84958e-06_r8,0.91464e-06_r8,0.98189e-06_r8,0.10489e-05_r8,0.11150e-05_r8 /)
      kbo(:,33, 3) = (/ &
        & 0.68178e-06_r8,0.73356e-06_r8,0.78905e-06_r8,0.84226e-06_r8,0.89476e-06_r8 /)
      kbo(:,34, 3) = (/ &
        & 0.54737e-06_r8,0.58995e-06_r8,0.63374e-06_r8,0.67732e-06_r8,0.72182e-06_r8 /)
      kbo(:,35, 3) = (/ &
        & 0.43680e-06_r8,0.47086e-06_r8,0.50771e-06_r8,0.54209e-06_r8,0.57687e-06_r8 /)
      kbo(:,36, 3) = (/ &
        & 0.34612e-06_r8,0.37466e-06_r8,0.40370e-06_r8,0.43073e-06_r8,0.45979e-06_r8 /)
      kbo(:,37, 3) = (/ &
        & 0.27725e-06_r8,0.30048e-06_r8,0.32451e-06_r8,0.34638e-06_r8,0.37105e-06_r8 /)
      kbo(:,38, 3) = (/ &
        & 0.22228e-06_r8,0.24114e-06_r8,0.26049e-06_r8,0.27871e-06_r8,0.29935e-06_r8 /)
      kbo(:,39, 3) = (/ &
        & 0.17797e-06_r8,0.19317e-06_r8,0.20878e-06_r8,0.22411e-06_r8,0.24102e-06_r8 /)
      kbo(:,40, 3) = (/ &
        & 0.14346e-06_r8,0.15601e-06_r8,0.16913e-06_r8,0.18197e-06_r8,0.19566e-06_r8 /)
      kbo(:,41, 3) = (/ &
        & 0.11559e-06_r8,0.12615e-06_r8,0.13697e-06_r8,0.14785e-06_r8,0.15874e-06_r8 /)
      kbo(:,42, 3) = (/ &
        & 0.93358e-07_r8,0.10214e-06_r8,0.11089e-06_r8,0.11998e-06_r8,0.12904e-06_r8 /)
      kbo(:,43, 3) = (/ &
        & 0.75599e-07_r8,0.82690e-07_r8,0.89808e-07_r8,0.97524e-07_r8,0.10511e-06_r8 /)
      kbo(:,44, 3) = (/ &
        & 0.61285e-07_r8,0.66786e-07_r8,0.72937e-07_r8,0.79087e-07_r8,0.85525e-07_r8 /)
      kbo(:,45, 3) = (/ &
        & 0.49725e-07_r8,0.54294e-07_r8,0.59263e-07_r8,0.64213e-07_r8,0.69583e-07_r8 /)
      kbo(:,46, 3) = (/ &
        & 0.40336e-07_r8,0.44186e-07_r8,0.48034e-07_r8,0.52184e-07_r8,0.56534e-07_r8 /)
      kbo(:,47, 3) = (/ &
        & 0.32904e-07_r8,0.35633e-07_r8,0.38959e-07_r8,0.42402e-07_r8,0.45883e-07_r8 /)
      kbo(:,48, 3) = (/ &
        & 0.26725e-07_r8,0.29104e-07_r8,0.31693e-07_r8,0.34312e-07_r8,0.37304e-07_r8 /)
      kbo(:,49, 3) = (/ &
        & 0.21751e-07_r8,0.23849e-07_r8,0.25803e-07_r8,0.28024e-07_r8,0.30356e-07_r8 /)
      kbo(:,50, 3) = (/ &
        & 0.17587e-07_r8,0.19609e-07_r8,0.21216e-07_r8,0.23022e-07_r8,0.24942e-07_r8 /)
      kbo(:,51, 3) = (/ &
        & 0.14376e-07_r8,0.15990e-07_r8,0.17493e-07_r8,0.18872e-07_r8,0.20463e-07_r8 /)
      kbo(:,52, 3) = (/ &
        & 0.11811e-07_r8,0.13106e-07_r8,0.14489e-07_r8,0.15615e-07_r8,0.16832e-07_r8 /)
      kbo(:,53, 3) = (/ &
        & 0.96001e-08_r8,0.10788e-07_r8,0.11921e-07_r8,0.12985e-07_r8,0.13904e-07_r8 /)
      kbo(:,54, 3) = (/ &
        & 0.78243e-08_r8,0.89178e-08_r8,0.98430e-08_r8,0.10840e-07_r8,0.11619e-07_r8 /)
      kbo(:,55, 3) = (/ &
        & 0.63638e-08_r8,0.73678e-08_r8,0.82214e-08_r8,0.89997e-08_r8,0.97565e-08_r8 /)
      kbo(:,56, 3) = (/ &
        & 0.51753e-08_r8,0.60497e-08_r8,0.68419e-08_r8,0.74560e-08_r8,0.82362e-08_r8 /)
      kbo(:,57, 3) = (/ &
        & 0.42164e-08_r8,0.49916e-08_r8,0.57066e-08_r8,0.63308e-08_r8,0.68950e-08_r8 /)
      kbo(:,58, 3) = (/ &
        & 0.34618e-08_r8,0.41424e-08_r8,0.48054e-08_r8,0.53757e-08_r8,0.58095e-08_r8 /)
      kbo(:,59, 3) = (/ &
        & 0.29083e-08_r8,0.35291e-08_r8,0.40932e-08_r8,0.46285e-08_r8,0.49865e-08_r8 /)
      kbo(:,13, 4) = (/ &
        & 0.37674e-03_r8,0.40953e-03_r8,0.43690e-03_r8,0.46059e-03_r8,0.48007e-03_r8 /)
      kbo(:,14, 4) = (/ &
        & 0.31202e-03_r8,0.33906e-03_r8,0.36066e-03_r8,0.38003e-03_r8,0.39627e-03_r8 /)
      kbo(:,15, 4) = (/ &
        & 0.25135e-03_r8,0.27271e-03_r8,0.29069e-03_r8,0.30661e-03_r8,0.32005e-03_r8 /)
      kbo(:,16, 4) = (/ &
        & 0.19797e-03_r8,0.21527e-03_r8,0.22955e-03_r8,0.24328e-03_r8,0.25456e-03_r8 /)
      kbo(:,17, 4) = (/ &
        & 0.15354e-03_r8,0.16679e-03_r8,0.17933e-03_r8,0.19101e-03_r8,0.20041e-03_r8 /)
      kbo(:,18, 4) = (/ &
        & 0.11742e-03_r8,0.12797e-03_r8,0.13923e-03_r8,0.14836e-03_r8,0.15654e-03_r8 /)
      kbo(:,19, 4) = (/ &
        & 0.90519e-04_r8,0.99386e-04_r8,0.10819e-03_r8,0.11601e-03_r8,0.12319e-03_r8 /)
      kbo(:,20, 4) = (/ &
        & 0.72579e-04_r8,0.79910e-04_r8,0.87075e-04_r8,0.93728e-04_r8,0.99656e-04_r8 /)
      kbo(:,21, 4) = (/ &
        & 0.58866e-04_r8,0.64805e-04_r8,0.70705e-04_r8,0.76153e-04_r8,0.80996e-04_r8 /)
      kbo(:,22, 4) = (/ &
        & 0.48157e-04_r8,0.52883e-04_r8,0.57740e-04_r8,0.62130e-04_r8,0.66100e-04_r8 /)
      kbo(:,23, 4) = (/ &
        & 0.39337e-04_r8,0.43289e-04_r8,0.47275e-04_r8,0.50906e-04_r8,0.54161e-04_r8 /)
      kbo(:,24, 4) = (/ &
        & 0.32289e-04_r8,0.35577e-04_r8,0.38808e-04_r8,0.41814e-04_r8,0.44433e-04_r8 /)
      kbo(:,25, 4) = (/ &
        & 0.26615e-04_r8,0.29301e-04_r8,0.31984e-04_r8,0.34396e-04_r8,0.36509e-04_r8 /)
      kbo(:,26, 4) = (/ &
        & 0.22060e-04_r8,0.24270e-04_r8,0.26460e-04_r8,0.28450e-04_r8,0.30203e-04_r8 /)
      kbo(:,27, 4) = (/ &
        & 0.18344e-04_r8,0.20177e-04_r8,0.21948e-04_r8,0.23595e-04_r8,0.25001e-04_r8 /)
      kbo(:,28, 4) = (/ &
        & 0.15256e-04_r8,0.16787e-04_r8,0.18242e-04_r8,0.19561e-04_r8,0.20696e-04_r8 /)
      kbo(:,29, 4) = (/ &
        & 0.12679e-04_r8,0.13952e-04_r8,0.15170e-04_r8,0.16211e-04_r8,0.17163e-04_r8 /)
      kbo(:,30, 4) = (/ &
        & 0.10550e-04_r8,0.11605e-04_r8,0.12579e-04_r8,0.13451e-04_r8,0.14210e-04_r8 /)
      kbo(:,31, 4) = (/ &
        & 0.87512e-05_r8,0.96322e-05_r8,0.10433e-04_r8,0.11133e-04_r8,0.11762e-04_r8 /)
      kbo(:,32, 4) = (/ &
        & 0.73001e-05_r8,0.80203e-05_r8,0.86745e-05_r8,0.92292e-05_r8,0.97295e-05_r8 /)
      kbo(:,33, 4) = (/ &
        & 0.60958e-05_r8,0.66862e-05_r8,0.72006e-05_r8,0.76359e-05_r8,0.80576e-05_r8 /)
      kbo(:,34, 4) = (/ &
        & 0.50855e-05_r8,0.55671e-05_r8,0.59670e-05_r8,0.63392e-05_r8,0.66869e-05_r8 /)
      kbo(:,35, 4) = (/ &
        & 0.42033e-05_r8,0.45905e-05_r8,0.49250e-05_r8,0.52384e-05_r8,0.55369e-05_r8 /)
      kbo(:,36, 4) = (/ &
        & 0.34384e-05_r8,0.37618e-05_r8,0.40430e-05_r8,0.43060e-05_r8,0.45577e-05_r8 /)
      kbo(:,37, 4) = (/ &
        & 0.28039e-05_r8,0.30749e-05_r8,0.33135e-05_r8,0.35344e-05_r8,0.37458e-05_r8 /)
      kbo(:,38, 4) = (/ &
        & 0.22842e-05_r8,0.25104e-05_r8,0.27126e-05_r8,0.28966e-05_r8,0.30768e-05_r8 /)
      kbo(:,39, 4) = (/ &
        & 0.18585e-05_r8,0.20510e-05_r8,0.22194e-05_r8,0.23731e-05_r8,0.25249e-05_r8 /)
      kbo(:,40, 4) = (/ &
        & 0.15041e-05_r8,0.16676e-05_r8,0.18097e-05_r8,0.19402e-05_r8,0.20681e-05_r8 /)
      kbo(:,41, 4) = (/ &
        & 0.12154e-05_r8,0.13541e-05_r8,0.14749e-05_r8,0.15852e-05_r8,0.16934e-05_r8 /)
      kbo(:,42, 4) = (/ &
        & 0.98033e-06_r8,0.10975e-05_r8,0.12011e-05_r8,0.12945e-05_r8,0.13859e-05_r8 /)
      kbo(:,43, 4) = (/ &
        & 0.78724e-06_r8,0.88625e-06_r8,0.97486e-06_r8,0.10554e-05_r8,0.11307e-05_r8 /)
      kbo(:,44, 4) = (/ &
        & 0.63059e-06_r8,0.71382e-06_r8,0.78948e-06_r8,0.85755e-06_r8,0.92044e-06_r8 /)
      kbo(:,45, 4) = (/ &
        & 0.50426e-06_r8,0.57391e-06_r8,0.63808e-06_r8,0.69718e-06_r8,0.74972e-06_r8 /)
      kbo(:,46, 4) = (/ &
        & 0.40133e-06_r8,0.45858e-06_r8,0.51414e-06_r8,0.56400e-06_r8,0.60964e-06_r8 /)
      kbo(:,47, 4) = (/ &
        & 0.31580e-06_r8,0.36440e-06_r8,0.41120e-06_r8,0.45433e-06_r8,0.49348e-06_r8 /)
      kbo(:,48, 4) = (/ &
        & 0.24847e-06_r8,0.28907e-06_r8,0.32879e-06_r8,0.36537e-06_r8,0.39903e-06_r8 /)
      kbo(:,49, 4) = (/ &
        & 0.19530e-06_r8,0.22858e-06_r8,0.26247e-06_r8,0.29331e-06_r8,0.32217e-06_r8 /)
      kbo(:,50, 4) = (/ &
        & 0.15364e-06_r8,0.18113e-06_r8,0.20911e-06_r8,0.23589e-06_r8,0.25994e-06_r8 /)
      kbo(:,51, 4) = (/ &
        & 0.12072e-06_r8,0.14413e-06_r8,0.16656e-06_r8,0.18952e-06_r8,0.20983e-06_r8 /)
      kbo(:,52, 4) = (/ &
        & 0.94925e-07_r8,0.11397e-06_r8,0.13255e-06_r8,0.15193e-06_r8,0.16960e-06_r8 /)
      kbo(:,53, 4) = (/ &
        & 0.74473e-07_r8,0.90197e-07_r8,0.10574e-06_r8,0.12153e-06_r8,0.13661e-06_r8 /)
      kbo(:,54, 4) = (/ &
        & 0.59009e-07_r8,0.71594e-07_r8,0.84781e-07_r8,0.97758e-07_r8,0.11018e-06_r8 /)
      kbo(:,55, 4) = (/ &
        & 0.47008e-07_r8,0.56997e-07_r8,0.67838e-07_r8,0.78753e-07_r8,0.89116e-07_r8 /)
      kbo(:,56, 4) = (/ &
        & 0.37415e-07_r8,0.45642e-07_r8,0.54420e-07_r8,0.63466e-07_r8,0.71910e-07_r8 /)
      kbo(:,57, 4) = (/ &
        & 0.29896e-07_r8,0.36635e-07_r8,0.43697e-07_r8,0.51036e-07_r8,0.58267e-07_r8 /)
      kbo(:,58, 4) = (/ &
        & 0.23946e-07_r8,0.29523e-07_r8,0.35316e-07_r8,0.41183e-07_r8,0.47391e-07_r8 /)
      kbo(:,59, 4) = (/ &
        & 0.19881e-07_r8,0.24642e-07_r8,0.29390e-07_r8,0.34099e-07_r8,0.39234e-07_r8 /)
      kbo(:,13, 5) = (/ &
        & 0.12771e-02_r8,0.13202e-02_r8,0.13557e-02_r8,0.13927e-02_r8,0.14233e-02_r8 /)
      kbo(:,14, 5) = (/ &
        & 0.10608e-02_r8,0.10951e-02_r8,0.11249e-02_r8,0.11549e-02_r8,0.11788e-02_r8 /)
      kbo(:,15, 5) = (/ &
        & 0.86750e-03_r8,0.89679e-03_r8,0.91986e-03_r8,0.94399e-03_r8,0.96405e-03_r8 /)
      kbo(:,16, 5) = (/ &
        & 0.70073e-03_r8,0.72504e-03_r8,0.74630e-03_r8,0.76495e-03_r8,0.78165e-03_r8 /)
      kbo(:,17, 5) = (/ &
        & 0.56280e-03_r8,0.58321e-03_r8,0.60153e-03_r8,0.61544e-03_r8,0.62885e-03_r8 /)
      kbo(:,18, 5) = (/ &
        & 0.44940e-03_r8,0.46598e-03_r8,0.47887e-03_r8,0.49058e-03_r8,0.50223e-03_r8 /)
      kbo(:,19, 5) = (/ &
        & 0.35753e-03_r8,0.37064e-03_r8,0.38290e-03_r8,0.39390e-03_r8,0.40387e-03_r8 /)
      kbo(:,20, 5) = (/ &
        & 0.29013e-03_r8,0.30099e-03_r8,0.31179e-03_r8,0.32117e-03_r8,0.33011e-03_r8 /)
      kbo(:,21, 5) = (/ &
        & 0.23657e-03_r8,0.24602e-03_r8,0.25504e-03_r8,0.26340e-03_r8,0.27145e-03_r8 /)
      kbo(:,22, 5) = (/ &
        & 0.19423e-03_r8,0.20224e-03_r8,0.20987e-03_r8,0.21711e-03_r8,0.22439e-03_r8 /)
      kbo(:,23, 5) = (/ &
        & 0.15963e-03_r8,0.16643e-03_r8,0.17308e-03_r8,0.17949e-03_r8,0.18580e-03_r8 /)
      kbo(:,24, 5) = (/ &
        & 0.13166e-03_r8,0.13745e-03_r8,0.14332e-03_r8,0.14871e-03_r8,0.15428e-03_r8 /)
      kbo(:,25, 5) = (/ &
        & 0.10885e-03_r8,0.11394e-03_r8,0.11896e-03_r8,0.12371e-03_r8,0.12846e-03_r8 /)
      kbo(:,26, 5) = (/ &
        & 0.90403e-04_r8,0.94914e-04_r8,0.99157e-04_r8,0.10310e-03_r8,0.10729e-03_r8 /)
      kbo(:,27, 5) = (/ &
        & 0.75265e-04_r8,0.79166e-04_r8,0.82648e-04_r8,0.86209e-04_r8,0.89882e-04_r8 /)
      kbo(:,28, 5) = (/ &
        & 0.62870e-04_r8,0.66050e-04_r8,0.69111e-04_r8,0.72289e-04_r8,0.75451e-04_r8 /)
      kbo(:,29, 5) = (/ &
        & 0.52465e-04_r8,0.55192e-04_r8,0.57887e-04_r8,0.60660e-04_r8,0.63367e-04_r8 /)
      kbo(:,30, 5) = (/ &
        & 0.43887e-04_r8,0.46191e-04_r8,0.48588e-04_r8,0.50910e-04_r8,0.53278e-04_r8 /)
      kbo(:,31, 5) = (/ &
        & 0.36760e-04_r8,0.38766e-04_r8,0.40783e-04_r8,0.42783e-04_r8,0.44780e-04_r8 /)
      kbo(:,32, 5) = (/ &
        & 0.30831e-04_r8,0.32561e-04_r8,0.34267e-04_r8,0.36000e-04_r8,0.37594e-04_r8 /)
      kbo(:,33, 5) = (/ &
        & 0.25908e-04_r8,0.27389e-04_r8,0.28832e-04_r8,0.30290e-04_r8,0.31581e-04_r8 /)
      kbo(:,34, 5) = (/ &
        & 0.21776e-04_r8,0.23026e-04_r8,0.24266e-04_r8,0.25444e-04_r8,0.26510e-04_r8 /)
      kbo(:,35, 5) = (/ &
        & 0.18233e-04_r8,0.19280e-04_r8,0.20324e-04_r8,0.21266e-04_r8,0.22141e-04_r8 /)
      kbo(:,36, 5) = (/ &
        & 0.15160e-04_r8,0.16042e-04_r8,0.16918e-04_r8,0.17686e-04_r8,0.18406e-04_r8 /)
      kbo(:,37, 5) = (/ &
        & 0.12538e-04_r8,0.13285e-04_r8,0.14015e-04_r8,0.14657e-04_r8,0.15269e-04_r8 /)
      kbo(:,38, 5) = (/ &
        & 0.10357e-04_r8,0.10990e-04_r8,0.11595e-04_r8,0.12148e-04_r8,0.12651e-04_r8 /)
      kbo(:,39, 5) = (/ &
        & 0.85566e-05_r8,0.90856e-05_r8,0.95986e-05_r8,0.10057e-04_r8,0.10478e-04_r8 /)
      kbo(:,40, 5) = (/ &
        & 0.70390e-05_r8,0.74826e-05_r8,0.79200e-05_r8,0.83061e-05_r8,0.86634e-05_r8 /)
      kbo(:,41, 5) = (/ &
        & 0.57827e-05_r8,0.61572e-05_r8,0.65269e-05_r8,0.68528e-05_r8,0.71595e-05_r8 /)
      kbo(:,42, 5) = (/ &
        & 0.47477e-05_r8,0.50656e-05_r8,0.53705e-05_r8,0.56486e-05_r8,0.59100e-05_r8 /)
      kbo(:,43, 5) = (/ &
        & 0.38802e-05_r8,0.41533e-05_r8,0.44089e-05_r8,0.46515e-05_r8,0.48719e-05_r8 /)
      kbo(:,44, 5) = (/ &
        & 0.31658e-05_r8,0.33971e-05_r8,0.36177e-05_r8,0.38205e-05_r8,0.40089e-05_r8 /)
      kbo(:,45, 5) = (/ &
        & 0.25796e-05_r8,0.27740e-05_r8,0.29635e-05_r8,0.31336e-05_r8,0.32986e-05_r8 /)
      kbo(:,46, 5) = (/ &
        & 0.20945e-05_r8,0.22636e-05_r8,0.24214e-05_r8,0.25698e-05_r8,0.27077e-05_r8 /)
      kbo(:,47, 5) = (/ &
        & 0.16931e-05_r8,0.18383e-05_r8,0.19729e-05_r8,0.20996e-05_r8,0.22172e-05_r8 /)
      kbo(:,48, 5) = (/ &
        & 0.13650e-05_r8,0.14889e-05_r8,0.16043e-05_r8,0.17139e-05_r8,0.18136e-05_r8 /)
      kbo(:,49, 5) = (/ &
        & 0.10981e-05_r8,0.12042e-05_r8,0.13028e-05_r8,0.13963e-05_r8,0.14824e-05_r8 /)
      kbo(:,50, 5) = (/ &
        & 0.88407e-06_r8,0.97370e-06_r8,0.10589e-05_r8,0.11383e-05_r8,0.12124e-05_r8 /)
      kbo(:,51, 5) = (/ &
        & 0.71150e-06_r8,0.78682e-06_r8,0.86048e-06_r8,0.92711e-06_r8,0.99128e-06_r8 /)
      kbo(:,52, 5) = (/ &
        & 0.57140e-06_r8,0.63513e-06_r8,0.69790e-06_r8,0.75466e-06_r8,0.80946e-06_r8 /)
      kbo(:,53, 5) = (/ &
        & 0.45871e-06_r8,0.51183e-06_r8,0.56494e-06_r8,0.61376e-06_r8,0.66022e-06_r8 /)
      kbo(:,54, 5) = (/ &
        & 0.36889e-06_r8,0.41319e-06_r8,0.45759e-06_r8,0.49973e-06_r8,0.53933e-06_r8 /)
      kbo(:,55, 5) = (/ &
        & 0.29683e-06_r8,0.33396e-06_r8,0.37110e-06_r8,0.40671e-06_r8,0.44026e-06_r8 /)
      kbo(:,56, 5) = (/ &
        & 0.23828e-06_r8,0.26973e-06_r8,0.30048e-06_r8,0.33099e-06_r8,0.35949e-06_r8 /)
      kbo(:,57, 5) = (/ &
        & 0.19083e-06_r8,0.21782e-06_r8,0.24350e-06_r8,0.26883e-06_r8,0.29309e-06_r8 /)
      kbo(:,58, 5) = (/ &
        & 0.15334e-06_r8,0.17592e-06_r8,0.19753e-06_r8,0.21869e-06_r8,0.23903e-06_r8 /)
      kbo(:,59, 5) = (/ &
        & 0.12635e-06_r8,0.14504e-06_r8,0.16321e-06_r8,0.18074e-06_r8,0.19759e-06_r8 /)
      kbo(:,13, 6) = (/ &
        & 0.33433e-02_r8,0.34159e-02_r8,0.34798e-02_r8,0.35397e-02_r8,0.35995e-02_r8 /)
      kbo(:,14, 6) = (/ &
        & 0.28039e-02_r8,0.28589e-02_r8,0.29090e-02_r8,0.29595e-02_r8,0.30108e-02_r8 /)
      kbo(:,15, 6) = (/ &
        & 0.23135e-02_r8,0.23579e-02_r8,0.24012e-02_r8,0.24470e-02_r8,0.24900e-02_r8 /)
      kbo(:,16, 6) = (/ &
        & 0.18925e-02_r8,0.19281e-02_r8,0.19671e-02_r8,0.20090e-02_r8,0.20445e-02_r8 /)
      kbo(:,17, 6) = (/ &
        & 0.15365e-02_r8,0.15703e-02_r8,0.16039e-02_r8,0.16424e-02_r8,0.16760e-02_r8 /)
      kbo(:,18, 6) = (/ &
        & 0.12424e-02_r8,0.12746e-02_r8,0.13067e-02_r8,0.13397e-02_r8,0.13687e-02_r8 /)
      kbo(:,19, 6) = (/ &
        & 0.10113e-02_r8,0.10417e-02_r8,0.10664e-02_r8,0.10958e-02_r8,0.11231e-02_r8 /)
      kbo(:,20, 6) = (/ &
        & 0.83375e-03_r8,0.85863e-03_r8,0.88098e-03_r8,0.90680e-03_r8,0.93093e-03_r8 /)
      kbo(:,21, 6) = (/ &
        & 0.68849e-03_r8,0.71056e-03_r8,0.73161e-03_r8,0.75402e-03_r8,0.77432e-03_r8 /)
      kbo(:,22, 6) = (/ &
        & 0.57076e-03_r8,0.59001e-03_r8,0.60925e-03_r8,0.62816e-03_r8,0.64531e-03_r8 /)
      kbo(:,23, 6) = (/ &
        & 0.47462e-03_r8,0.49138e-03_r8,0.50818e-03_r8,0.52421e-03_r8,0.53930e-03_r8 /)
      kbo(:,24, 6) = (/ &
        & 0.39552e-03_r8,0.41011e-03_r8,0.42460e-03_r8,0.43865e-03_r8,0.45206e-03_r8 /)
      kbo(:,25, 6) = (/ &
        & 0.33041e-03_r8,0.34317e-03_r8,0.35573e-03_r8,0.36800e-03_r8,0.38005e-03_r8 /)
      kbo(:,26, 6) = (/ &
        & 0.27699e-03_r8,0.28806e-03_r8,0.29892e-03_r8,0.30983e-03_r8,0.32038e-03_r8 /)
      kbo(:,27, 6) = (/ &
        & 0.23253e-03_r8,0.24229e-03_r8,0.25208e-03_r8,0.26144e-03_r8,0.27039e-03_r8 /)
      kbo(:,28, 6) = (/ &
        & 0.19573e-03_r8,0.20442e-03_r8,0.21276e-03_r8,0.22087e-03_r8,0.22869e-03_r8 /)
      kbo(:,29, 6) = (/ &
        & 0.16528e-03_r8,0.17271e-03_r8,0.17974e-03_r8,0.18681e-03_r8,0.19373e-03_r8 /)
      kbo(:,30, 6) = (/ &
        & 0.13949e-03_r8,0.14599e-03_r8,0.15214e-03_r8,0.15834e-03_r8,0.16448e-03_r8 /)
      kbo(:,31, 6) = (/ &
        & 0.11793e-03_r8,0.12345e-03_r8,0.12891e-03_r8,0.13432e-03_r8,0.13975e-03_r8 /)
      kbo(:,32, 6) = (/ &
        & 0.99845e-04_r8,0.10464e-03_r8,0.10941e-03_r8,0.11425e-03_r8,0.11896e-03_r8 /)
      kbo(:,33, 6) = (/ &
        & 0.84723e-04_r8,0.88808e-04_r8,0.93054e-04_r8,0.97257e-04_r8,0.10144e-03_r8 /)
      kbo(:,34, 6) = (/ &
        & 0.71857e-04_r8,0.75478e-04_r8,0.79245e-04_r8,0.82878e-04_r8,0.86527e-04_r8 /)
      kbo(:,35, 6) = (/ &
        & 0.60741e-04_r8,0.63987e-04_r8,0.67190e-04_r8,0.70445e-04_r8,0.73634e-04_r8 /)
      kbo(:,36, 6) = (/ &
        & 0.51094e-04_r8,0.53953e-04_r8,0.56787e-04_r8,0.59644e-04_r8,0.62421e-04_r8 /)
      kbo(:,37, 6) = (/ &
        & 0.42809e-04_r8,0.45324e-04_r8,0.47805e-04_r8,0.50314e-04_r8,0.52797e-04_r8 /)
      kbo(:,38, 6) = (/ &
        & 0.35862e-04_r8,0.38082e-04_r8,0.40249e-04_r8,0.42459e-04_r8,0.44691e-04_r8 /)
      kbo(:,39, 6) = (/ &
        & 0.30047e-04_r8,0.31970e-04_r8,0.33877e-04_r8,0.35841e-04_r8,0.37792e-04_r8 /)
      kbo(:,40, 6) = (/ &
        & 0.25051e-04_r8,0.26734e-04_r8,0.28429e-04_r8,0.30177e-04_r8,0.31859e-04_r8 /)
      kbo(:,41, 6) = (/ &
        & 0.20858e-04_r8,0.22337e-04_r8,0.23837e-04_r8,0.25348e-04_r8,0.26845e-04_r8 /)
      kbo(:,42, 6) = (/ &
        & 0.17358e-04_r8,0.18653e-04_r8,0.19947e-04_r8,0.21279e-04_r8,0.22614e-04_r8 /)
      kbo(:,43, 6) = (/ &
        & 0.14382e-04_r8,0.15507e-04_r8,0.16637e-04_r8,0.17808e-04_r8,0.18975e-04_r8 /)
      kbo(:,44, 6) = (/ &
        & 0.11875e-04_r8,0.12851e-04_r8,0.13847e-04_r8,0.14865e-04_r8,0.15886e-04_r8 /)
      kbo(:,45, 6) = (/ &
        & 0.97824e-05_r8,0.10641e-04_r8,0.11497e-04_r8,0.12386e-04_r8,0.13288e-04_r8 /)
      kbo(:,46, 6) = (/ &
        & 0.80305e-05_r8,0.87712e-05_r8,0.95170e-05_r8,0.10282e-04_r8,0.11073e-04_r8 /)
      kbo(:,47, 6) = (/ &
        & 0.65554e-05_r8,0.71881e-05_r8,0.78331e-05_r8,0.85022e-05_r8,0.91799e-05_r8 /)
      kbo(:,48, 6) = (/ &
        & 0.53399e-05_r8,0.58818e-05_r8,0.64364e-05_r8,0.70093e-05_r8,0.75992e-05_r8 /)
      kbo(:,49, 6) = (/ &
        & 0.43396e-05_r8,0.47990e-05_r8,0.52727e-05_r8,0.57633e-05_r8,0.62785e-05_r8 /)
      kbo(:,50, 6) = (/ &
        & 0.35272e-05_r8,0.39139e-05_r8,0.43230e-05_r8,0.47423e-05_r8,0.51819e-05_r8 /)
      kbo(:,51, 6) = (/ &
        & 0.28624e-05_r8,0.31913e-05_r8,0.35379e-05_r8,0.38979e-05_r8,0.42744e-05_r8 /)
      kbo(:,52, 6) = (/ &
        & 0.23189e-05_r8,0.25961e-05_r8,0.28907e-05_r8,0.31976e-05_r8,0.35200e-05_r8 /)
      kbo(:,53, 6) = (/ &
        & 0.18736e-05_r8,0.21072e-05_r8,0.23576e-05_r8,0.26179e-05_r8,0.28943e-05_r8 /)
      kbo(:,54, 6) = (/ &
        & 0.15155e-05_r8,0.17135e-05_r8,0.19245e-05_r8,0.21451e-05_r8,0.23808e-05_r8 /)
      kbo(:,55, 6) = (/ &
        & 0.12250e-05_r8,0.13923e-05_r8,0.15714e-05_r8,0.17578e-05_r8,0.19597e-05_r8 /)
      kbo(:,56, 6) = (/ &
        & 0.99012e-06_r8,0.11296e-05_r8,0.12801e-05_r8,0.14395e-05_r8,0.16107e-05_r8 /)
      kbo(:,57, 6) = (/ &
        & 0.79875e-06_r8,0.91418e-06_r8,0.10408e-05_r8,0.11777e-05_r8,0.13212e-05_r8 /)
      kbo(:,58, 6) = (/ &
        & 0.64474e-06_r8,0.74109e-06_r8,0.84664e-06_r8,0.96328e-06_r8,0.10849e-05_r8 /)
      kbo(:,59, 6) = (/ &
        & 0.53296e-06_r8,0.61427e-06_r8,0.70385e-06_r8,0.80375e-06_r8,0.90863e-06_r8 /)
      kbo(:,13, 7) = (/ &
        & 0.91063e-02_r8,0.92681e-02_r8,0.94045e-02_r8,0.95388e-02_r8,0.96735e-02_r8 /)
      kbo(:,14, 7) = (/ &
        & 0.78483e-02_r8,0.79806e-02_r8,0.81238e-02_r8,0.82528e-02_r8,0.83603e-02_r8 /)
      kbo(:,15, 7) = (/ &
        & 0.66269e-02_r8,0.67445e-02_r8,0.68845e-02_r8,0.69911e-02_r8,0.70854e-02_r8 /)
      kbo(:,16, 7) = (/ &
        & 0.55183e-02_r8,0.56414e-02_r8,0.57574e-02_r8,0.58487e-02_r8,0.59407e-02_r8 /)
      kbo(:,17, 7) = (/ &
        & 0.45693e-02_r8,0.46780e-02_r8,0.47743e-02_r8,0.48625e-02_r8,0.49467e-02_r8 /)
      kbo(:,18, 7) = (/ &
        & 0.37611e-02_r8,0.38535e-02_r8,0.39408e-02_r8,0.40234e-02_r8,0.41007e-02_r8 /)
      kbo(:,19, 7) = (/ &
        & 0.30991e-02_r8,0.31809e-02_r8,0.32647e-02_r8,0.33388e-02_r8,0.34042e-02_r8 /)
      kbo(:,20, 7) = (/ &
        & 0.25858e-02_r8,0.26585e-02_r8,0.27347e-02_r8,0.27990e-02_r8,0.28579e-02_r8 /)
      kbo(:,21, 7) = (/ &
        & 0.21672e-02_r8,0.22326e-02_r8,0.22973e-02_r8,0.23547e-02_r8,0.24058e-02_r8 /)
      kbo(:,22, 7) = (/ &
        & 0.18211e-02_r8,0.18809e-02_r8,0.19364e-02_r8,0.19859e-02_r8,0.20352e-02_r8 /)
      kbo(:,23, 7) = (/ &
        & 0.15314e-02_r8,0.15844e-02_r8,0.16332e-02_r8,0.16760e-02_r8,0.17243e-02_r8 /)
      kbo(:,24, 7) = (/ &
        & 0.12924e-02_r8,0.13385e-02_r8,0.13793e-02_r8,0.14209e-02_r8,0.14659e-02_r8 /)
      kbo(:,25, 7) = (/ &
        & 0.10926e-02_r8,0.11322e-02_r8,0.11689e-02_r8,0.12081e-02_r8,0.12493e-02_r8 /)
      kbo(:,26, 7) = (/ &
        & 0.92756e-03_r8,0.96136e-03_r8,0.99601e-03_r8,0.10324e-02_r8,0.10695e-02_r8 /)
      kbo(:,27, 7) = (/ &
        & 0.78832e-03_r8,0.81893e-03_r8,0.85137e-03_r8,0.88465e-03_r8,0.91885e-03_r8 /)
      kbo(:,28, 7) = (/ &
        & 0.67097e-03_r8,0.69979e-03_r8,0.72985e-03_r8,0.76038e-03_r8,0.79213e-03_r8 /)
      kbo(:,29, 7) = (/ &
        & 0.57231e-03_r8,0.59934e-03_r8,0.62727e-03_r8,0.65471e-03_r8,0.68389e-03_r8 /)
      kbo(:,30, 7) = (/ &
        & 0.48996e-03_r8,0.51441e-03_r8,0.53945e-03_r8,0.56564e-03_r8,0.59164e-03_r8 /)
      kbo(:,31, 7) = (/ &
        & 0.41998e-03_r8,0.44237e-03_r8,0.46551e-03_r8,0.48924e-03_r8,0.51322e-03_r8 /)
      kbo(:,32, 7) = (/ &
        & 0.36133e-03_r8,0.38168e-03_r8,0.40297e-03_r8,0.42441e-03_r8,0.44722e-03_r8 /)
      kbo(:,33, 7) = (/ &
        & 0.31153e-03_r8,0.33055e-03_r8,0.34980e-03_r8,0.36972e-03_r8,0.39086e-03_r8 /)
      kbo(:,34, 7) = (/ &
        & 0.26941e-03_r8,0.28657e-03_r8,0.30436e-03_r8,0.32295e-03_r8,0.34256e-03_r8 /)
      kbo(:,35, 7) = (/ &
        & 0.23210e-03_r8,0.24782e-03_r8,0.26411e-03_r8,0.28121e-03_r8,0.29930e-03_r8 /)
      kbo(:,36, 7) = (/ &
        & 0.19904e-03_r8,0.21311e-03_r8,0.22797e-03_r8,0.24380e-03_r8,0.26030e-03_r8 /)
      kbo(:,37, 7) = (/ &
        & 0.17000e-03_r8,0.18300e-03_r8,0.19666e-03_r8,0.21128e-03_r8,0.22641e-03_r8 /)
      kbo(:,38, 7) = (/ &
        & 0.14528e-03_r8,0.15704e-03_r8,0.16975e-03_r8,0.18320e-03_r8,0.19735e-03_r8 /)
      kbo(:,39, 7) = (/ &
        & 0.12414e-03_r8,0.13496e-03_r8,0.14654e-03_r8,0.15899e-03_r8,0.17211e-03_r8 /)
      kbo(:,40, 7) = (/ &
        & 0.10567e-03_r8,0.11547e-03_r8,0.12618e-03_r8,0.13765e-03_r8,0.14994e-03_r8 /)
      kbo(:,41, 7) = (/ &
        & 0.89774e-04_r8,0.98751e-04_r8,0.10852e-03_r8,0.11918e-03_r8,0.13057e-03_r8 /)
      kbo(:,42, 7) = (/ &
        & 0.76232e-04_r8,0.84383e-04_r8,0.93336e-04_r8,0.10314e-03_r8,0.11381e-03_r8 /)
      kbo(:,43, 7) = (/ &
        & 0.64370e-04_r8,0.71684e-04_r8,0.79797e-04_r8,0.88850e-04_r8,0.98733e-04_r8 /)
      kbo(:,44, 7) = (/ &
        & 0.54125e-04_r8,0.60680e-04_r8,0.68042e-04_r8,0.76313e-04_r8,0.85432e-04_r8 /)
      kbo(:,45, 7) = (/ &
        & 0.45374e-04_r8,0.51280e-04_r8,0.57932e-04_r8,0.65429e-04_r8,0.73852e-04_r8 /)
      kbo(:,46, 7) = (/ &
        & 0.37861e-04_r8,0.43078e-04_r8,0.49016e-04_r8,0.55844e-04_r8,0.63538e-04_r8 /)
      kbo(:,47, 7) = (/ &
        & 0.31342e-04_r8,0.35879e-04_r8,0.41175e-04_r8,0.47252e-04_r8,0.54286e-04_r8 /)
      kbo(:,48, 7) = (/ &
        & 0.25821e-04_r8,0.29777e-04_r8,0.34458e-04_r8,0.39880e-04_r8,0.46218e-04_r8 /)
      kbo(:,49, 7) = (/ &
        & 0.21180e-04_r8,0.24617e-04_r8,0.28719e-04_r8,0.33507e-04_r8,0.39184e-04_r8 /)
      kbo(:,50, 7) = (/ &
        & 0.17377e-04_r8,0.20345e-04_r8,0.23916e-04_r8,0.28177e-04_r8,0.33237e-04_r8 /)
      kbo(:,51, 7) = (/ &
        & 0.14223e-04_r8,0.16790e-04_r8,0.19868e-04_r8,0.23656e-04_r8,0.28163e-04_r8 /)
      kbo(:,52, 7) = (/ &
        & 0.11593e-04_r8,0.13788e-04_r8,0.16479e-04_r8,0.19773e-04_r8,0.23765e-04_r8 /)
      kbo(:,53, 7) = (/ &
        & 0.94141e-05_r8,0.11279e-04_r8,0.13591e-04_r8,0.16447e-04_r8,0.19969e-04_r8 /)
      kbo(:,54, 7) = (/ &
        & 0.76622e-05_r8,0.92417e-05_r8,0.11233e-04_r8,0.13709e-04_r8,0.16819e-04_r8 /)
      kbo(:,55, 7) = (/ &
        & 0.62315e-05_r8,0.75671e-05_r8,0.92699e-05_r8,0.11429e-04_r8,0.14186e-04_r8 /)
      kbo(:,56, 7) = (/ &
        & 0.50473e-05_r8,0.61766e-05_r8,0.76316e-05_r8,0.94979e-05_r8,0.11890e-04_r8 /)
      kbo(:,57, 7) = (/ &
        & 0.40773e-05_r8,0.50242e-05_r8,0.62540e-05_r8,0.78594e-05_r8,0.99378e-05_r8 /)
      kbo(:,58, 7) = (/ &
        & 0.32937e-05_r8,0.40862e-05_r8,0.51228e-05_r8,0.64992e-05_r8,0.83112e-05_r8 /)
      kbo(:,59, 7) = (/ &
        & 0.27593e-05_r8,0.34505e-05_r8,0.43716e-05_r8,0.56035e-05_r8,0.72609e-05_r8 /)
      kbo(:,13, 8) = (/ &
        & 0.25990e-01_r8,0.25997e-01_r8,0.26024e-01_r8,0.26038e-01_r8,0.26132e-01_r8 /)
      kbo(:,14, 8) = (/ &
        & 0.22648e-01_r8,0.22731e-01_r8,0.22803e-01_r8,0.22861e-01_r8,0.23020e-01_r8 /)
      kbo(:,15, 8) = (/ &
        & 0.19641e-01_r8,0.19812e-01_r8,0.19880e-01_r8,0.19998e-01_r8,0.20141e-01_r8 /)
      kbo(:,16, 8) = (/ &
        & 0.16909e-01_r8,0.17030e-01_r8,0.17148e-01_r8,0.17296e-01_r8,0.17502e-01_r8 /)
      kbo(:,17, 8) = (/ &
        & 0.14365e-01_r8,0.14504e-01_r8,0.14643e-01_r8,0.14808e-01_r8,0.14996e-01_r8 /)
      kbo(:,18, 8) = (/ &
        & 0.12072e-01_r8,0.12207e-01_r8,0.12346e-01_r8,0.12513e-01_r8,0.12742e-01_r8 /)
      kbo(:,19, 8) = (/ &
        & 0.10135e-01_r8,0.10263e-01_r8,0.10402e-01_r8,0.10602e-01_r8,0.10794e-01_r8 /)
      kbo(:,20, 8) = (/ &
        & 0.86508e-02_r8,0.87951e-02_r8,0.89765e-02_r8,0.91530e-02_r8,0.93447e-02_r8 /)
      kbo(:,21, 8) = (/ &
        & 0.74228e-02_r8,0.75964e-02_r8,0.77805e-02_r8,0.79441e-02_r8,0.81266e-02_r8 /)
      kbo(:,22, 8) = (/ &
        & 0.63949e-02_r8,0.65920e-02_r8,0.67584e-02_r8,0.69298e-02_r8,0.70968e-02_r8 /)
      kbo(:,23, 8) = (/ &
        & 0.55389e-02_r8,0.57165e-02_r8,0.58834e-02_r8,0.60490e-02_r8,0.62163e-02_r8 /)
      kbo(:,24, 8) = (/ &
        & 0.47980e-02_r8,0.49696e-02_r8,0.51333e-02_r8,0.53055e-02_r8,0.54695e-02_r8 /)
      kbo(:,25, 8) = (/ &
        & 0.41676e-02_r8,0.43357e-02_r8,0.44999e-02_r8,0.46749e-02_r8,0.48179e-02_r8 /)
      kbo(:,26, 8) = (/ &
        & 0.36391e-02_r8,0.38079e-02_r8,0.39834e-02_r8,0.41374e-02_r8,0.42754e-02_r8 /)
      kbo(:,27, 8) = (/ &
        & 0.31917e-02_r8,0.33580e-02_r8,0.35237e-02_r8,0.36737e-02_r8,0.37982e-02_r8 /)
      kbo(:,28, 8) = (/ &
        & 0.28096e-02_r8,0.29709e-02_r8,0.31242e-02_r8,0.32613e-02_r8,0.33829e-02_r8 /)
      kbo(:,29, 8) = (/ &
        & 0.24786e-02_r8,0.26272e-02_r8,0.27706e-02_r8,0.28986e-02_r8,0.30130e-02_r8 /)
      kbo(:,30, 8) = (/ &
        & 0.21907e-02_r8,0.23282e-02_r8,0.24574e-02_r8,0.25778e-02_r8,0.26806e-02_r8 /)
      kbo(:,31, 8) = (/ &
        & 0.19346e-02_r8,0.20569e-02_r8,0.21757e-02_r8,0.22805e-02_r8,0.23742e-02_r8 /)
      kbo(:,32, 8) = (/ &
        & 0.17101e-02_r8,0.18247e-02_r8,0.19308e-02_r8,0.20256e-02_r8,0.21176e-02_r8 /)
      kbo(:,33, 8) = (/ &
        & 0.15171e-02_r8,0.16168e-02_r8,0.17121e-02_r8,0.18035e-02_r8,0.18911e-02_r8 /)
      kbo(:,34, 8) = (/ &
        & 0.13466e-02_r8,0.14390e-02_r8,0.15246e-02_r8,0.16083e-02_r8,0.16921e-02_r8 /)
      kbo(:,35, 8) = (/ &
        & 0.11871e-02_r8,0.12698e-02_r8,0.13534e-02_r8,0.14320e-02_r8,0.15071e-02_r8 /)
      kbo(:,36, 8) = (/ &
        & 0.10388e-02_r8,0.11179e-02_r8,0.11934e-02_r8,0.12647e-02_r8,0.13391e-02_r8 /)
      kbo(:,37, 8) = (/ &
        & 0.92233e-03_r8,0.99854e-03_r8,0.10722e-02_r8,0.11426e-02_r8,0.12118e-02_r8 /)
      kbo(:,38, 8) = (/ &
        & 0.81843e-03_r8,0.89236e-03_r8,0.96605e-03_r8,0.10340e-02_r8,0.11003e-02_r8 /)
      kbo(:,39, 8) = (/ &
        & 0.72738e-03_r8,0.79777e-03_r8,0.86997e-03_r8,0.93496e-03_r8,0.99852e-03_r8 /)
      kbo(:,40, 8) = (/ &
        & 0.65149e-03_r8,0.72098e-03_r8,0.79235e-03_r8,0.86116e-03_r8,0.92474e-03_r8 /)
      kbo(:,41, 8) = (/ &
        & 0.58318e-03_r8,0.65154e-03_r8,0.72160e-03_r8,0.79400e-03_r8,0.85973e-03_r8 /)
      kbo(:,42, 8) = (/ &
        & 0.52127e-03_r8,0.58770e-03_r8,0.65781e-03_r8,0.73110e-03_r8,0.80165e-03_r8 /)
      kbo(:,43, 8) = (/ &
        & 0.46404e-03_r8,0.52960e-03_r8,0.59886e-03_r8,0.67366e-03_r8,0.74727e-03_r8 /)
      kbo(:,44, 8) = (/ &
        & 0.41229e-03_r8,0.47609e-03_r8,0.54424e-03_r8,0.61918e-03_r8,0.69366e-03_r8 /)
      kbo(:,45, 8) = (/ &
        & 0.36534e-03_r8,0.42624e-03_r8,0.49374e-03_r8,0.56668e-03_r8,0.64364e-03_r8 /)
      kbo(:,46, 8) = (/ &
        & 0.32134e-03_r8,0.37987e-03_r8,0.44597e-03_r8,0.51669e-03_r8,0.59469e-03_r8 /)
      kbo(:,47, 8) = (/ &
        & 0.27855e-03_r8,0.33531e-03_r8,0.39855e-03_r8,0.46832e-03_r8,0.54562e-03_r8 /)
      kbo(:,48, 8) = (/ &
        & 0.24094e-03_r8,0.29440e-03_r8,0.35477e-03_r8,0.42284e-03_r8,0.49767e-03_r8 /)
      kbo(:,49, 8) = (/ &
        & 0.20710e-03_r8,0.25712e-03_r8,0.31425e-03_r8,0.38098e-03_r8,0.45465e-03_r8 /)
      kbo(:,50, 8) = (/ &
        & 0.17757e-03_r8,0.22422e-03_r8,0.27906e-03_r8,0.34231e-03_r8,0.41419e-03_r8 /)
      kbo(:,51, 8) = (/ &
        & 0.15198e-03_r8,0.19538e-03_r8,0.24758e-03_r8,0.30796e-03_r8,0.37765e-03_r8 /)
      kbo(:,52, 8) = (/ &
        & 0.12943e-03_r8,0.16907e-03_r8,0.21812e-03_r8,0.27585e-03_r8,0.34284e-03_r8 /)
      kbo(:,53, 8) = (/ &
        & 0.10946e-03_r8,0.14560e-03_r8,0.19103e-03_r8,0.24633e-03_r8,0.31049e-03_r8 /)
      kbo(:,54, 8) = (/ &
        & 0.92950e-04_r8,0.12599e-03_r8,0.16848e-03_r8,0.22109e-03_r8,0.28266e-03_r8 /)
      kbo(:,55, 8) = (/ &
        & 0.78722e-04_r8,0.10883e-03_r8,0.14831e-03_r8,0.19790e-03_r8,0.25770e-03_r8 /)
      kbo(:,56, 8) = (/ &
        & 0.66323e-04_r8,0.93651e-04_r8,0.12983e-03_r8,0.17638e-03_r8,0.23393e-03_r8 /)
      kbo(:,57, 8) = (/ &
        & 0.55644e-04_r8,0.80085e-04_r8,0.11349e-03_r8,0.15741e-03_r8,0.21274e-03_r8 /)
      kbo(:,58, 8) = (/ &
        & 0.46537e-04_r8,0.68442e-04_r8,0.99190e-04_r8,0.14045e-03_r8,0.19327e-03_r8 /)
      kbo(:,59, 8) = (/ &
        & 0.41558e-04_r8,0.62503e-04_r8,0.92377e-04_r8,0.13258e-03_r8,0.18528e-03_r8 /)
      kbo(:,13, 9) = (/ &
        & 0.14836e+00_r8,0.15039e+00_r8,0.15239e+00_r8,0.15389e+00_r8,0.15517e+00_r8 /)
      kbo(:,14, 9) = (/ &
        & 0.12935e+00_r8,0.13183e+00_r8,0.13366e+00_r8,0.13551e+00_r8,0.13674e+00_r8 /)
      kbo(:,15, 9) = (/ &
        & 0.11269e+00_r8,0.11456e+00_r8,0.11672e+00_r8,0.11824e+00_r8,0.11951e+00_r8 /)
      kbo(:,16, 9) = (/ &
        & 0.97577e-01_r8,0.99647e-01_r8,0.10140e+00_r8,0.10272e+00_r8,0.10390e+00_r8 /)
      kbo(:,17, 9) = (/ &
        & 0.84601e-01_r8,0.86370e-01_r8,0.87860e-01_r8,0.89144e-01_r8,0.90341e-01_r8 /)
      kbo(:,18, 9) = (/ &
        & 0.72851e-01_r8,0.74498e-01_r8,0.75924e-01_r8,0.77220e-01_r8,0.78434e-01_r8 /)
      kbo(:,19, 9) = (/ &
        & 0.62688e-01_r8,0.64121e-01_r8,0.65574e-01_r8,0.66965e-01_r8,0.68243e-01_r8 /)
      kbo(:,20, 9) = (/ &
        & 0.54382e-01_r8,0.55704e-01_r8,0.57013e-01_r8,0.58303e-01_r8,0.59763e-01_r8 /)
      kbo(:,21, 9) = (/ &
        & 0.47190e-01_r8,0.48469e-01_r8,0.49752e-01_r8,0.51138e-01_r8,0.52452e-01_r8 /)
      kbo(:,22, 9) = (/ &
        & 0.41104e-01_r8,0.42378e-01_r8,0.43684e-01_r8,0.45035e-01_r8,0.46495e-01_r8 /)
      kbo(:,23, 9) = (/ &
        & 0.35910e-01_r8,0.37220e-01_r8,0.38484e-01_r8,0.39789e-01_r8,0.41443e-01_r8 /)
      kbo(:,24, 9) = (/ &
        & 0.31558e-01_r8,0.32836e-01_r8,0.34085e-01_r8,0.35462e-01_r8,0.37160e-01_r8 /)
      kbo(:,25, 9) = (/ &
        & 0.27861e-01_r8,0.29090e-01_r8,0.30363e-01_r8,0.31857e-01_r8,0.33566e-01_r8 /)
      kbo(:,26, 9) = (/ &
        & 0.24743e-01_r8,0.26003e-01_r8,0.27311e-01_r8,0.28788e-01_r8,0.30553e-01_r8 /)
      kbo(:,27, 9) = (/ &
        & 0.22141e-01_r8,0.23397e-01_r8,0.24754e-01_r8,0.26282e-01_r8,0.28040e-01_r8 /)
      kbo(:,28, 9) = (/ &
        & 0.19941e-01_r8,0.21165e-01_r8,0.22565e-01_r8,0.24131e-01_r8,0.25980e-01_r8 /)
      kbo(:,29, 9) = (/ &
        & 0.18046e-01_r8,0.19353e-01_r8,0.20736e-01_r8,0.22375e-01_r8,0.24248e-01_r8 /)
      kbo(:,30, 9) = (/ &
        & 0.16429e-01_r8,0.17775e-01_r8,0.19238e-01_r8,0.20907e-01_r8,0.22847e-01_r8 /)
      kbo(:,31, 9) = (/ &
        & 0.15094e-01_r8,0.16450e-01_r8,0.17992e-01_r8,0.19741e-01_r8,0.21608e-01_r8 /)
      kbo(:,32, 9) = (/ &
        & 0.13975e-01_r8,0.15315e-01_r8,0.16950e-01_r8,0.18741e-01_r8,0.20564e-01_r8 /)
      kbo(:,33, 9) = (/ &
        & 0.13026e-01_r8,0.14475e-01_r8,0.16113e-01_r8,0.17903e-01_r8,0.19794e-01_r8 /)
      kbo(:,34, 9) = (/ &
        & 0.12248e-01_r8,0.13747e-01_r8,0.15391e-01_r8,0.17142e-01_r8,0.19155e-01_r8 /)
      kbo(:,35, 9) = (/ &
        & 0.11491e-01_r8,0.12979e-01_r8,0.14611e-01_r8,0.16423e-01_r8,0.18475e-01_r8 /)
      kbo(:,36, 9) = (/ &
        & 0.10695e-01_r8,0.12142e-01_r8,0.13822e-01_r8,0.15678e-01_r8,0.17729e-01_r8 /)
      kbo(:,37, 9) = (/ &
        & 0.98761e-02_r8,0.11300e-01_r8,0.13000e-01_r8,0.14808e-01_r8,0.16848e-01_r8 /)
      kbo(:,38, 9) = (/ &
        & 0.91358e-02_r8,0.10538e-01_r8,0.12200e-01_r8,0.13999e-01_r8,0.16082e-01_r8 /)
      kbo(:,39, 9) = (/ &
        & 0.84558e-02_r8,0.98580e-02_r8,0.11508e-01_r8,0.13321e-01_r8,0.15372e-01_r8 /)
      kbo(:,40, 9) = (/ &
        & 0.78020e-02_r8,0.91740e-02_r8,0.10778e-01_r8,0.12588e-01_r8,0.14594e-01_r8 /)
      kbo(:,41, 9) = (/ &
        & 0.72028e-02_r8,0.85294e-02_r8,0.10093e-01_r8,0.11887e-01_r8,0.13872e-01_r8 /)
      kbo(:,42, 9) = (/ &
        & 0.66335e-02_r8,0.79299e-02_r8,0.94524e-02_r8,0.11233e-01_r8,0.13162e-01_r8 /)
      kbo(:,43, 9) = (/ &
        & 0.60936e-02_r8,0.73819e-02_r8,0.88361e-02_r8,0.10555e-01_r8,0.12456e-01_r8 /)
      kbo(:,44, 9) = (/ &
        & 0.55851e-02_r8,0.68018e-02_r8,0.82487e-02_r8,0.98836e-02_r8,0.11744e-01_r8 /)
      kbo(:,45, 9) = (/ &
        & 0.51361e-02_r8,0.62783e-02_r8,0.76910e-02_r8,0.92631e-02_r8,0.11096e-01_r8 /)
      kbo(:,46, 9) = (/ &
        & 0.46789e-02_r8,0.57877e-02_r8,0.71257e-02_r8,0.86688e-02_r8,0.10399e-01_r8 /)
      kbo(:,47, 9) = (/ &
        & 0.42434e-02_r8,0.53043e-02_r8,0.65448e-02_r8,0.80300e-02_r8,0.97286e-02_r8 /)
      kbo(:,48, 9) = (/ &
        & 0.38917e-02_r8,0.48269e-02_r8,0.60283e-02_r8,0.74378e-02_r8,0.90783e-02_r8 /)
      kbo(:,49, 9) = (/ &
        & 0.35823e-02_r8,0.43988e-02_r8,0.55409e-02_r8,0.68845e-02_r8,0.84495e-02_r8 /)
      kbo(:,50, 9) = (/ &
        & 0.33116e-02_r8,0.40852e-02_r8,0.51044e-02_r8,0.63885e-02_r8,0.78773e-02_r8 /)
      kbo(:,51, 9) = (/ &
        & 0.30752e-02_r8,0.38103e-02_r8,0.47346e-02_r8,0.59580e-02_r8,0.73779e-02_r8 /)
      kbo(:,52, 9) = (/ &
        & 0.28626e-02_r8,0.35553e-02_r8,0.44430e-02_r8,0.55409e-02_r8,0.69343e-02_r8 /)
      kbo(:,53, 9) = (/ &
        & 0.26485e-02_r8,0.33392e-02_r8,0.41695e-02_r8,0.51739e-02_r8,0.64753e-02_r8 /)
      kbo(:,54, 9) = (/ &
        & 0.24736e-02_r8,0.31489e-02_r8,0.39367e-02_r8,0.48954e-02_r8,0.61401e-02_r8 /)
      kbo(:,55, 9) = (/ &
        & 0.23362e-02_r8,0.29819e-02_r8,0.37593e-02_r8,0.46985e-02_r8,0.58363e-02_r8 /)
      kbo(:,56, 9) = (/ &
        & 0.22243e-02_r8,0.28447e-02_r8,0.35827e-02_r8,0.44762e-02_r8,0.55720e-02_r8 /)
      kbo(:,57, 9) = (/ &
        & 0.21389e-02_r8,0.27081e-02_r8,0.34315e-02_r8,0.43182e-02_r8,0.53898e-02_r8 /)
      kbo(:,58, 9) = (/ &
        & 0.20428e-02_r8,0.25997e-02_r8,0.33047e-02_r8,0.41726e-02_r8,0.52071e-02_r8 /)
      kbo(:,59, 9) = (/ &
        & 0.20538e-02_r8,0.26323e-02_r8,0.33247e-02_r8,0.41770e-02_r8,0.52496e-02_r8 /)
      kbo(:,13,10) = (/ &
        & 0.58637e+00_r8,0.59481e+00_r8,0.59811e+00_r8,0.60451e+00_r8,0.60418e+00_r8 /)
      kbo(:,14,10) = (/ &
        & 0.53191e+00_r8,0.53363e+00_r8,0.53861e+00_r8,0.53976e+00_r8,0.53933e+00_r8 /)
      kbo(:,15,10) = (/ &
        & 0.47845e+00_r8,0.48447e+00_r8,0.48498e+00_r8,0.48691e+00_r8,0.48935e+00_r8 /)
      kbo(:,16,10) = (/ &
        & 0.42695e+00_r8,0.43265e+00_r8,0.43442e+00_r8,0.43949e+00_r8,0.44244e+00_r8 /)
      kbo(:,17,10) = (/ &
        & 0.37796e+00_r8,0.38437e+00_r8,0.38958e+00_r8,0.39367e+00_r8,0.39802e+00_r8 /)
      kbo(:,18,10) = (/ &
        & 0.33399e+00_r8,0.33971e+00_r8,0.34517e+00_r8,0.35032e+00_r8,0.35265e+00_r8 /)
      kbo(:,19,10) = (/ &
        & 0.29538e+00_r8,0.30247e+00_r8,0.30713e+00_r8,0.30943e+00_r8,0.31544e+00_r8 /)
      kbo(:,20,10) = (/ &
        & 0.26154e+00_r8,0.26955e+00_r8,0.27264e+00_r8,0.27778e+00_r8,0.28167e+00_r8 /)
      kbo(:,21,10) = (/ &
        & 0.23200e+00_r8,0.23896e+00_r8,0.24468e+00_r8,0.24838e+00_r8,0.25453e+00_r8 /)
      kbo(:,22,10) = (/ &
        & 0.20714e+00_r8,0.21368e+00_r8,0.21959e+00_r8,0.22402e+00_r8,0.22934e+00_r8 /)
      kbo(:,23,10) = (/ &
        & 0.18514e+00_r8,0.19070e+00_r8,0.19771e+00_r8,0.20426e+00_r8,0.20794e+00_r8 /)
      kbo(:,24,10) = (/ &
        & 0.16629e+00_r8,0.17247e+00_r8,0.17943e+00_r8,0.18543e+00_r8,0.19044e+00_r8 /)
      kbo(:,25,10) = (/ &
        & 0.15103e+00_r8,0.15758e+00_r8,0.16440e+00_r8,0.16947e+00_r8,0.17504e+00_r8 /)
      kbo(:,26,10) = (/ &
        & 0.13782e+00_r8,0.14448e+00_r8,0.15050e+00_r8,0.15723e+00_r8,0.16403e+00_r8 /)
      kbo(:,27,10) = (/ &
        & 0.12675e+00_r8,0.13284e+00_r8,0.13902e+00_r8,0.14547e+00_r8,0.15299e+00_r8 /)
      kbo(:,28,10) = (/ &
        & 0.11700e+00_r8,0.12400e+00_r8,0.13029e+00_r8,0.13779e+00_r8,0.14535e+00_r8 /)
      kbo(:,29,10) = (/ &
        & 0.10975e+00_r8,0.11580e+00_r8,0.12300e+00_r8,0.13106e+00_r8,0.13981e+00_r8 /)
      kbo(:,30,10) = (/ &
        & 0.10326e+00_r8,0.10877e+00_r8,0.11694e+00_r8,0.12523e+00_r8,0.13409e+00_r8 /)
      kbo(:,31,10) = (/ &
        & 0.97072e-01_r8,0.10392e+00_r8,0.11191e+00_r8,0.12092e+00_r8,0.13156e+00_r8 /)
      kbo(:,32,10) = (/ &
        & 0.92483e-01_r8,0.10003e+00_r8,0.10847e+00_r8,0.11777e+00_r8,0.12978e+00_r8 /)
      kbo(:,33,10) = (/ &
        & 0.89436e-01_r8,0.96549e-01_r8,0.10550e+00_r8,0.11582e+00_r8,0.12938e+00_r8 /)
      kbo(:,34,10) = (/ &
        & 0.86605e-01_r8,0.93852e-01_r8,0.10437e+00_r8,0.11565e+00_r8,0.13025e+00_r8 /)
      kbo(:,35,10) = (/ &
        & 0.83755e-01_r8,0.92443e-01_r8,0.10318e+00_r8,0.11569e+00_r8,0.13035e+00_r8 /)
      kbo(:,36,10) = (/ &
        & 0.80159e-01_r8,0.90106e-01_r8,0.10185e+00_r8,0.11331e+00_r8,0.13105e+00_r8 /)
      kbo(:,37,10) = (/ &
        & 0.76863e-01_r8,0.86981e-01_r8,0.98816e-01_r8,0.11094e+00_r8,0.12837e+00_r8 /)
      kbo(:,38,10) = (/ &
        & 0.73911e-01_r8,0.84640e-01_r8,0.95988e-01_r8,0.10951e+00_r8,0.12524e+00_r8 /)
      kbo(:,39,10) = (/ &
        & 0.71484e-01_r8,0.82465e-01_r8,0.93807e-01_r8,0.10732e+00_r8,0.12288e+00_r8 /)
      kbo(:,40,10) = (/ &
        & 0.68367e-01_r8,0.78553e-01_r8,0.90288e-01_r8,0.10290e+00_r8,0.11884e+00_r8 /)
      kbo(:,41,10) = (/ &
        & 0.65972e-01_r8,0.75367e-01_r8,0.87331e-01_r8,0.98979e-01_r8,0.11479e+00_r8 /)
      kbo(:,42,10) = (/ &
        & 0.63899e-01_r8,0.72995e-01_r8,0.84392e-01_r8,0.96170e-01_r8,0.11066e+00_r8 /)
      kbo(:,43,10) = (/ &
        & 0.61601e-01_r8,0.69361e-01_r8,0.80265e-01_r8,0.92296e-01_r8,0.10575e+00_r8 /)
      kbo(:,44,10) = (/ &
        & 0.58053e-01_r8,0.67236e-01_r8,0.77057e-01_r8,0.88848e-01_r8,0.10118e+00_r8 /)
      kbo(:,45,10) = (/ &
        & 0.55041e-01_r8,0.64788e-01_r8,0.73479e-01_r8,0.85189e-01_r8,0.97294e-01_r8 /)
      kbo(:,46,10) = (/ &
        & 0.51538e-01_r8,0.61359e-01_r8,0.70493e-01_r8,0.81342e-01_r8,0.93711e-01_r8 /)
      kbo(:,47,10) = (/ &
        & 0.48229e-01_r8,0.57754e-01_r8,0.67703e-01_r8,0.77712e-01_r8,0.88779e-01_r8 /)
      kbo(:,48,10) = (/ &
        & 0.44328e-01_r8,0.53953e-01_r8,0.64327e-01_r8,0.74186e-01_r8,0.85354e-01_r8 /)
      kbo(:,49,10) = (/ &
        & 0.40181e-01_r8,0.50939e-01_r8,0.60544e-01_r8,0.71079e-01_r8,0.81883e-01_r8 /)
      kbo(:,50,10) = (/ &
        & 0.36327e-01_r8,0.47243e-01_r8,0.57625e-01_r8,0.67925e-01_r8,0.78806e-01_r8 /)
      kbo(:,51,10) = (/ &
        & 0.33026e-01_r8,0.43278e-01_r8,0.54464e-01_r8,0.64411e-01_r8,0.75916e-01_r8 /)
      kbo(:,52,10) = (/ &
        & 0.29600e-01_r8,0.39888e-01_r8,0.50913e-01_r8,0.61457e-01_r8,0.72719e-01_r8 /)
      kbo(:,53,10) = (/ &
        & 0.26994e-01_r8,0.36264e-01_r8,0.46926e-01_r8,0.58631e-01_r8,0.68972e-01_r8 /)
      kbo(:,54,10) = (/ &
        & 0.24928e-01_r8,0.33245e-01_r8,0.43870e-01_r8,0.55481e-01_r8,0.66121e-01_r8 /)
      kbo(:,55,10) = (/ &
        & 0.23329e-01_r8,0.30647e-01_r8,0.40729e-01_r8,0.52051e-01_r8,0.63960e-01_r8 /)
      kbo(:,56,10) = (/ &
        & 0.21581e-01_r8,0.28578e-01_r8,0.37651e-01_r8,0.48828e-01_r8,0.60673e-01_r8 /)
      kbo(:,57,10) = (/ &
        & 0.20121e-01_r8,0.27060e-01_r8,0.35152e-01_r8,0.45854e-01_r8,0.57152e-01_r8 /)
      kbo(:,58,10) = (/ &
        & 0.18692e-01_r8,0.25639e-01_r8,0.32995e-01_r8,0.42657e-01_r8,0.54655e-01_r8 /)
      kbo(:,59,10) = (/ &
        & 0.18277e-01_r8,0.25273e-01_r8,0.32791e-01_r8,0.42508e-01_r8,0.53680e-01_r8 /)
      kbo(:,13,11) = (/ &
        & 0.10693e+01_r8,0.10902e+01_r8,0.11032e+01_r8,0.10991e+01_r8,0.11118e+01_r8 /)
      kbo(:,14,11) = (/ &
        & 0.95953e+00_r8,0.97384e+00_r8,0.98577e+00_r8,0.99728e+00_r8,0.10070e+01_r8 /)
      kbo(:,15,11) = (/ &
        & 0.85940e+00_r8,0.86781e+00_r8,0.87766e+00_r8,0.88834e+00_r8,0.89855e+00_r8 /)
      kbo(:,16,11) = (/ &
        & 0.76187e+00_r8,0.76651e+00_r8,0.78116e+00_r8,0.79605e+00_r8,0.80429e+00_r8 /)
      kbo(:,17,11) = (/ &
        & 0.67627e+00_r8,0.68377e+00_r8,0.69734e+00_r8,0.70867e+00_r8,0.71758e+00_r8 /)
      kbo(:,18,11) = (/ &
        & 0.60442e+00_r8,0.61462e+00_r8,0.62319e+00_r8,0.63477e+00_r8,0.64696e+00_r8 /)
      kbo(:,19,11) = (/ &
        & 0.54250e+00_r8,0.55180e+00_r8,0.56132e+00_r8,0.57649e+00_r8,0.58604e+00_r8 /)
      kbo(:,20,11) = (/ &
        & 0.49000e+00_r8,0.49922e+00_r8,0.51229e+00_r8,0.52536e+00_r8,0.53903e+00_r8 /)
      kbo(:,21,11) = (/ &
        & 0.44362e+00_r8,0.45018e+00_r8,0.46523e+00_r8,0.48212e+00_r8,0.49590e+00_r8 /)
      kbo(:,22,11) = (/ &
        & 0.40390e+00_r8,0.41136e+00_r8,0.42554e+00_r8,0.44299e+00_r8,0.45956e+00_r8 /)
      kbo(:,23,11) = (/ &
        & 0.36600e+00_r8,0.37646e+00_r8,0.39144e+00_r8,0.40936e+00_r8,0.42622e+00_r8 /)
      kbo(:,24,11) = (/ &
        & 0.33488e+00_r8,0.34802e+00_r8,0.36259e+00_r8,0.38089e+00_r8,0.39832e+00_r8 /)
      kbo(:,25,11) = (/ &
        & 0.30569e+00_r8,0.32099e+00_r8,0.33730e+00_r8,0.35716e+00_r8,0.37447e+00_r8 /)
      kbo(:,26,11) = (/ &
        & 0.28345e+00_r8,0.29933e+00_r8,0.31861e+00_r8,0.33716e+00_r8,0.35400e+00_r8 /)
      kbo(:,27,11) = (/ &
        & 0.26524e+00_r8,0.28116e+00_r8,0.30310e+00_r8,0.32398e+00_r8,0.34341e+00_r8 /)
      kbo(:,28,11) = (/ &
        & 0.25036e+00_r8,0.26748e+00_r8,0.29040e+00_r8,0.31038e+00_r8,0.33527e+00_r8 /)
      kbo(:,29,11) = (/ &
        & 0.23678e+00_r8,0.25759e+00_r8,0.27958e+00_r8,0.30373e+00_r8,0.33097e+00_r8 /)
      kbo(:,30,11) = (/ &
        & 0.22835e+00_r8,0.25043e+00_r8,0.27298e+00_r8,0.30247e+00_r8,0.33069e+00_r8 /)
      kbo(:,31,11) = (/ &
        & 0.22381e+00_r8,0.24448e+00_r8,0.27386e+00_r8,0.30198e+00_r8,0.33135e+00_r8 /)
      kbo(:,32,11) = (/ &
        & 0.21945e+00_r8,0.24581e+00_r8,0.27557e+00_r8,0.30488e+00_r8,0.33817e+00_r8 /)
      kbo(:,33,11) = (/ &
        & 0.22020e+00_r8,0.24997e+00_r8,0.27933e+00_r8,0.31199e+00_r8,0.34537e+00_r8 /)
      kbo(:,34,11) = (/ &
        & 0.22328e+00_r8,0.25315e+00_r8,0.28560e+00_r8,0.31999e+00_r8,0.35204e+00_r8 /)
      kbo(:,35,11) = (/ &
        & 0.22463e+00_r8,0.25599e+00_r8,0.29016e+00_r8,0.32472e+00_r8,0.35705e+00_r8 /)
      kbo(:,36,11) = (/ &
        & 0.22454e+00_r8,0.25719e+00_r8,0.29064e+00_r8,0.32676e+00_r8,0.35643e+00_r8 /)
      kbo(:,37,11) = (/ &
        & 0.21917e+00_r8,0.25146e+00_r8,0.28533e+00_r8,0.32018e+00_r8,0.35207e+00_r8 /)
      kbo(:,38,11) = (/ &
        & 0.21431e+00_r8,0.24593e+00_r8,0.28070e+00_r8,0.31440e+00_r8,0.34740e+00_r8 /)
      kbo(:,39,11) = (/ &
        & 0.20995e+00_r8,0.24107e+00_r8,0.27540e+00_r8,0.30795e+00_r8,0.34247e+00_r8 /)
      kbo(:,40,11) = (/ &
        & 0.20148e+00_r8,0.23319e+00_r8,0.26577e+00_r8,0.30086e+00_r8,0.33366e+00_r8 /)
      kbo(:,41,11) = (/ &
        & 0.19132e+00_r8,0.22478e+00_r8,0.25632e+00_r8,0.29251e+00_r8,0.32436e+00_r8 /)
      kbo(:,42,11) = (/ &
        & 0.18231e+00_r8,0.21584e+00_r8,0.24724e+00_r8,0.28164e+00_r8,0.31641e+00_r8 /)
      kbo(:,43,11) = (/ &
        & 0.17273e+00_r8,0.20475e+00_r8,0.23702e+00_r8,0.26984e+00_r8,0.30535e+00_r8 /)
      kbo(:,44,11) = (/ &
        & 0.16365e+00_r8,0.19313e+00_r8,0.22566e+00_r8,0.25812e+00_r8,0.29340e+00_r8 /)
      kbo(:,45,11) = (/ &
        & 0.15471e+00_r8,0.18278e+00_r8,0.21464e+00_r8,0.24686e+00_r8,0.28060e+00_r8 /)
      kbo(:,46,11) = (/ &
        & 0.14477e+00_r8,0.17256e+00_r8,0.20328e+00_r8,0.23515e+00_r8,0.26753e+00_r8 /)
      kbo(:,47,11) = (/ &
        & 0.13513e+00_r8,0.16209e+00_r8,0.19092e+00_r8,0.22162e+00_r8,0.25481e+00_r8 /)
      kbo(:,48,11) = (/ &
        & 0.12632e+00_r8,0.15056e+00_r8,0.17900e+00_r8,0.20905e+00_r8,0.24085e+00_r8 /)
      kbo(:,49,11) = (/ &
        & 0.11846e+00_r8,0.14059e+00_r8,0.16812e+00_r8,0.19759e+00_r8,0.22701e+00_r8 /)
      kbo(:,50,11) = (/ &
        & 0.11278e+00_r8,0.13341e+00_r8,0.15756e+00_r8,0.18662e+00_r8,0.21629e+00_r8 /)
      kbo(:,51,11) = (/ &
        & 0.10711e+00_r8,0.12752e+00_r8,0.14951e+00_r8,0.17651e+00_r8,0.20555e+00_r8 /)
      kbo(:,52,11) = (/ &
        & 0.10062e+00_r8,0.12140e+00_r8,0.14273e+00_r8,0.16677e+00_r8,0.19594e+00_r8 /)
      kbo(:,53,11) = (/ &
        & 0.93686e-01_r8,0.11587e+00_r8,0.13705e+00_r8,0.15900e+00_r8,0.18673e+00_r8 /)
      kbo(:,54,11) = (/ &
        & 0.88183e-01_r8,0.10986e+00_r8,0.13159e+00_r8,0.15362e+00_r8,0.17808e+00_r8 /)
      kbo(:,55,11) = (/ &
        & 0.81924e-01_r8,0.10428e+00_r8,0.12662e+00_r8,0.14862e+00_r8,0.17143e+00_r8 /)
      kbo(:,56,11) = (/ &
        & 0.75991e-01_r8,0.98633e-01_r8,0.12219e+00_r8,0.14408e+00_r8,0.16698e+00_r8 /)
      kbo(:,57,11) = (/ &
        & 0.69399e-01_r8,0.92760e-01_r8,0.11664e+00_r8,0.14040e+00_r8,0.16308e+00_r8 /)
      kbo(:,58,11) = (/ &
        & 0.64018e-01_r8,0.88343e-01_r8,0.11169e+00_r8,0.13686e+00_r8,0.15969e+00_r8 /)
      kbo(:,59,11) = (/ &
        & 0.63145e-01_r8,0.86273e-01_r8,0.11143e+00_r8,0.13565e+00_r8,0.16187e+00_r8 /)
      kbo(:,13,12) = (/ &
        & 0.22241e+01_r8,0.22556e+01_r8,0.22932e+01_r8,0.23316e+01_r8,0.23817e+01_r8 /)
      kbo(:,14,12) = (/ &
        & 0.20015e+01_r8,0.20535e+01_r8,0.20976e+01_r8,0.21411e+01_r8,0.21895e+01_r8 /)
      kbo(:,15,12) = (/ &
        & 0.18111e+01_r8,0.18671e+01_r8,0.19196e+01_r8,0.19734e+01_r8,0.20226e+01_r8 /)
      kbo(:,16,12) = (/ &
        & 0.16513e+01_r8,0.17114e+01_r8,0.17632e+01_r8,0.18132e+01_r8,0.18623e+01_r8 /)
      kbo(:,17,12) = (/ &
        & 0.15041e+01_r8,0.15648e+01_r8,0.16197e+01_r8,0.16720e+01_r8,0.17169e+01_r8 /)
      kbo(:,18,12) = (/ &
        & 0.13731e+01_r8,0.14345e+01_r8,0.14937e+01_r8,0.15386e+01_r8,0.16052e+01_r8 /)
      kbo(:,19,12) = (/ &
        & 0.12478e+01_r8,0.13115e+01_r8,0.13641e+01_r8,0.14279e+01_r8,0.14977e+01_r8 /)
      kbo(:,20,12) = (/ &
        & 0.11298e+01_r8,0.11910e+01_r8,0.12495e+01_r8,0.13186e+01_r8,0.13914e+01_r8 /)
      kbo(:,21,12) = (/ &
        & 0.10266e+01_r8,0.10915e+01_r8,0.11508e+01_r8,0.12227e+01_r8,0.13004e+01_r8 /)
      kbo(:,22,12) = (/ &
        & 0.93959e+00_r8,0.10027e+01_r8,0.10735e+01_r8,0.11507e+01_r8,0.12312e+01_r8 /)
      kbo(:,23,12) = (/ &
        & 0.87016e+00_r8,0.93486e+00_r8,0.10125e+01_r8,0.10930e+01_r8,0.11794e+01_r8 /)
      kbo(:,24,12) = (/ &
        & 0.81213e+00_r8,0.88017e+00_r8,0.96483e+00_r8,0.10508e+01_r8,0.11396e+01_r8 /)
      kbo(:,25,12) = (/ &
        & 0.77134e+00_r8,0.84295e+00_r8,0.93081e+00_r8,0.10201e+01_r8,0.11152e+01_r8 /)
      kbo(:,26,12) = (/ &
        & 0.73832e+00_r8,0.81743e+00_r8,0.90746e+00_r8,0.10024e+01_r8,0.11020e+01_r8 /)
      kbo(:,27,12) = (/ &
        & 0.71831e+00_r8,0.80328e+00_r8,0.89505e+00_r8,0.99247e+00_r8,0.10943e+01_r8 /)
      kbo(:,28,12) = (/ &
        & 0.70848e+00_r8,0.79592e+00_r8,0.89143e+00_r8,0.99432e+00_r8,0.10940e+01_r8 /)
      kbo(:,29,12) = (/ &
        & 0.70725e+00_r8,0.79781e+00_r8,0.89906e+00_r8,0.10007e+01_r8,0.11009e+01_r8 /)
      kbo(:,30,12) = (/ &
        & 0.71125e+00_r8,0.80824e+00_r8,0.91144e+00_r8,0.10109e+01_r8,0.11144e+01_r8 /)
      kbo(:,31,12) = (/ &
        & 0.72057e+00_r8,0.82548e+00_r8,0.92423e+00_r8,0.10285e+01_r8,0.11338e+01_r8 /)
      kbo(:,32,12) = (/ &
        & 0.73855e+00_r8,0.84223e+00_r8,0.94322e+00_r8,0.10495e+01_r8,0.11523e+01_r8 /)
      kbo(:,33,12) = (/ &
        & 0.75860e+00_r8,0.86137e+00_r8,0.96653e+00_r8,0.10709e+01_r8,0.11736e+01_r8 /)
      kbo(:,34,12) = (/ &
        & 0.77584e+00_r8,0.88104e+00_r8,0.98358e+00_r8,0.10881e+01_r8,0.11928e+01_r8 /)
      kbo(:,35,12) = (/ &
        & 0.78526e+00_r8,0.88915e+00_r8,0.99181e+00_r8,0.10955e+01_r8,0.12024e+01_r8 /)
      kbo(:,36,12) = (/ &
        & 0.78420e+00_r8,0.88679e+00_r8,0.98962e+00_r8,0.10938e+01_r8,0.12013e+01_r8 /)
      kbo(:,37,12) = (/ &
        & 0.76619e+00_r8,0.86975e+00_r8,0.97162e+00_r8,0.10774e+01_r8,0.11823e+01_r8 /)
      kbo(:,38,12) = (/ &
        & 0.74778e+00_r8,0.85168e+00_r8,0.95355e+00_r8,0.10588e+01_r8,0.11642e+01_r8 /)
      kbo(:,39,12) = (/ &
        & 0.73003e+00_r8,0.83397e+00_r8,0.93638e+00_r8,0.10427e+01_r8,0.11461e+01_r8 /)
      kbo(:,40,12) = (/ &
        & 0.70694e+00_r8,0.80603e+00_r8,0.90951e+00_r8,0.10129e+01_r8,0.11179e+01_r8 /)
      kbo(:,41,12) = (/ &
        & 0.68380e+00_r8,0.77629e+00_r8,0.88021e+00_r8,0.98263e+00_r8,0.10876e+01_r8 /)
      kbo(:,42,12) = (/ &
        & 0.66231e+00_r8,0.74849e+00_r8,0.85130e+00_r8,0.95458e+00_r8,0.10576e+01_r8 /)
      kbo(:,43,12) = (/ &
        & 0.63688e+00_r8,0.72048e+00_r8,0.81634e+00_r8,0.92017e+00_r8,0.10227e+01_r8 /)
      kbo(:,44,12) = (/ &
        & 0.60858e+00_r8,0.69178e+00_r8,0.77940e+00_r8,0.88149e+00_r8,0.98460e+00_r8 /)
      kbo(:,45,12) = (/ &
        & 0.58153e+00_r8,0.66520e+00_r8,0.74925e+00_r8,0.84319e+00_r8,0.94694e+00_r8 /)
      kbo(:,46,12) = (/ &
        & 0.55197e+00_r8,0.63412e+00_r8,0.71872e+00_r8,0.80664e+00_r8,0.90684e+00_r8 /)
      kbo(:,47,12) = (/ &
        & 0.51844e+00_r8,0.60273e+00_r8,0.68769e+00_r8,0.77076e+00_r8,0.86117e+00_r8 /)
      kbo(:,48,12) = (/ &
        & 0.48120e+00_r8,0.57148e+00_r8,0.65491e+00_r8,0.74197e+00_r8,0.82485e+00_r8 /)
      kbo(:,49,12) = (/ &
        & 0.44584e+00_r8,0.53846e+00_r8,0.62079e+00_r8,0.70603e+00_r8,0.79220e+00_r8 /)
      kbo(:,50,12) = (/ &
        & 0.41289e+00_r8,0.50133e+00_r8,0.59314e+00_r8,0.67773e+00_r8,0.76297e+00_r8 /)
      kbo(:,51,12) = (/ &
        & 0.38263e+00_r8,0.46808e+00_r8,0.55994e+00_r8,0.64654e+00_r8,0.73545e+00_r8 /)
      kbo(:,52,12) = (/ &
        & 0.35216e+00_r8,0.43713e+00_r8,0.52781e+00_r8,0.61897e+00_r8,0.70212e+00_r8 /)
      kbo(:,53,12) = (/ &
        & 0.33102e+00_r8,0.40477e+00_r8,0.49059e+00_r8,0.58472e+00_r8,0.67270e+00_r8 /)
      kbo(:,54,12) = (/ &
        & 0.31146e+00_r8,0.37834e+00_r8,0.46271e+00_r8,0.55353e+00_r8,0.64596e+00_r8 /)
      kbo(:,55,12) = (/ &
        & 0.29087e+00_r8,0.35982e+00_r8,0.43598e+00_r8,0.52416e+00_r8,0.61765e+00_r8 /)
      kbo(:,56,12) = (/ &
        & 0.27304e+00_r8,0.34098e+00_r8,0.41224e+00_r8,0.49775e+00_r8,0.58771e+00_r8 /)
      kbo(:,57,12) = (/ &
        & 0.25824e+00_r8,0.32066e+00_r8,0.39085e+00_r8,0.46641e+00_r8,0.55829e+00_r8 /)
      kbo(:,58,12) = (/ &
        & 0.24548e+00_r8,0.30081e+00_r8,0.37338e+00_r8,0.44708e+00_r8,0.53062e+00_r8 /)
      kbo(:,59,12) = (/ &
        & 0.24212e+00_r8,0.29858e+00_r8,0.36550e+00_r8,0.44064e+00_r8,0.51789e+00_r8 /)
      kbo(:,13,13) = (/ &
        & 0.55998e+01_r8,0.57039e+01_r8,0.58049e+01_r8,0.59180e+01_r8,0.59854e+01_r8 /)
      kbo(:,14,13) = (/ &
        & 0.53275e+01_r8,0.54387e+01_r8,0.55543e+01_r8,0.56621e+01_r8,0.57635e+01_r8 /)
      kbo(:,15,13) = (/ &
        & 0.50203e+01_r8,0.51578e+01_r8,0.52898e+01_r8,0.54130e+01_r8,0.55373e+01_r8 /)
      kbo(:,16,13) = (/ &
        & 0.47246e+01_r8,0.48786e+01_r8,0.50266e+01_r8,0.51689e+01_r8,0.53242e+01_r8 /)
      kbo(:,17,13) = (/ &
        & 0.44403e+01_r8,0.46027e+01_r8,0.47680e+01_r8,0.49455e+01_r8,0.51299e+01_r8 /)
      kbo(:,18,13) = (/ &
        & 0.41648e+01_r8,0.43473e+01_r8,0.45415e+01_r8,0.47508e+01_r8,0.49298e+01_r8 /)
      kbo(:,19,13) = (/ &
        & 0.39134e+01_r8,0.41196e+01_r8,0.43493e+01_r8,0.45520e+01_r8,0.47522e+01_r8 /)
      kbo(:,20,13) = (/ &
        & 0.36873e+01_r8,0.39195e+01_r8,0.41603e+01_r8,0.43826e+01_r8,0.46005e+01_r8 /)
      kbo(:,21,13) = (/ &
        & 0.34974e+01_r8,0.37507e+01_r8,0.40010e+01_r8,0.42413e+01_r8,0.44759e+01_r8 /)
      kbo(:,22,13) = (/ &
        & 0.33605e+01_r8,0.36305e+01_r8,0.38873e+01_r8,0.41404e+01_r8,0.43929e+01_r8 /)
      kbo(:,23,13) = (/ &
        & 0.32571e+01_r8,0.35388e+01_r8,0.38042e+01_r8,0.40702e+01_r8,0.43353e+01_r8 /)
      kbo(:,24,13) = (/ &
        & 0.31836e+01_r8,0.34721e+01_r8,0.37495e+01_r8,0.40277e+01_r8,0.43044e+01_r8 /)
      kbo(:,25,13) = (/ &
        & 0.31346e+01_r8,0.34329e+01_r8,0.37222e+01_r8,0.40107e+01_r8,0.42953e+01_r8 /)
      kbo(:,26,13) = (/ &
        & 0.31155e+01_r8,0.34221e+01_r8,0.37222e+01_r8,0.40178e+01_r8,0.43079e+01_r8 /)
      kbo(:,27,13) = (/ &
        & 0.31157e+01_r8,0.34328e+01_r8,0.37392e+01_r8,0.40396e+01_r8,0.43346e+01_r8 /)
      kbo(:,28,13) = (/ &
        & 0.31335e+01_r8,0.34580e+01_r8,0.37695e+01_r8,0.40734e+01_r8,0.43720e+01_r8 /)
      kbo(:,29,13) = (/ &
        & 0.31697e+01_r8,0.34978e+01_r8,0.38120e+01_r8,0.41186e+01_r8,0.44189e+01_r8 /)
      kbo(:,30,13) = (/ &
        & 0.32194e+01_r8,0.35475e+01_r8,0.38638e+01_r8,0.41720e+01_r8,0.44722e+01_r8 /)
      kbo(:,31,13) = (/ &
        & 0.32811e+01_r8,0.36069e+01_r8,0.39241e+01_r8,0.42325e+01_r8,0.45314e+01_r8 /)
      kbo(:,32,13) = (/ &
        & 0.33484e+01_r8,0.36727e+01_r8,0.39897e+01_r8,0.42974e+01_r8,0.45949e+01_r8 /)
      kbo(:,33,13) = (/ &
        & 0.34186e+01_r8,0.37430e+01_r8,0.40586e+01_r8,0.43658e+01_r8,0.46602e+01_r8 /)
      kbo(:,34,13) = (/ &
        & 0.34801e+01_r8,0.38048e+01_r8,0.41197e+01_r8,0.44255e+01_r8,0.47156e+01_r8 /)
      kbo(:,35,13) = (/ &
        & 0.35126e+01_r8,0.38375e+01_r8,0.41525e+01_r8,0.44577e+01_r8,0.47454e+01_r8 /)
      kbo(:,36,13) = (/ &
        & 0.35115e+01_r8,0.38370e+01_r8,0.41529e+01_r8,0.44584e+01_r8,0.47449e+01_r8 /)
      kbo(:,37,13) = (/ &
        & 0.34620e+01_r8,0.37892e+01_r8,0.41066e+01_r8,0.44144e+01_r8,0.47052e+01_r8 /)
      kbo(:,38,13) = (/ &
        & 0.34108e+01_r8,0.37391e+01_r8,0.40587e+01_r8,0.43685e+01_r8,0.46624e+01_r8 /)
      kbo(:,39,13) = (/ &
        & 0.33603e+01_r8,0.36896e+01_r8,0.40114e+01_r8,0.43229e+01_r8,0.46208e+01_r8 /)
      kbo(:,40,13) = (/ &
        & 0.32696e+01_r8,0.36068e+01_r8,0.39317e+01_r8,0.42460e+01_r8,0.45479e+01_r8 /)
      kbo(:,41,13) = (/ &
        & 0.31746e+01_r8,0.35197e+01_r8,0.38475e+01_r8,0.41644e+01_r8,0.44716e+01_r8 /)
      kbo(:,42,13) = (/ &
        & 0.30768e+01_r8,0.34312e+01_r8,0.37630e+01_r8,0.40826e+01_r8,0.43924e+01_r8 /)
      kbo(:,43,13) = (/ &
        & 0.29558e+01_r8,0.33178e+01_r8,0.36587e+01_r8,0.39822e+01_r8,0.42959e+01_r8 /)
      kbo(:,44,13) = (/ &
        & 0.28280e+01_r8,0.31906e+01_r8,0.35435e+01_r8,0.38727e+01_r8,0.41899e+01_r8 /)
      kbo(:,45,13) = (/ &
        & 0.26988e+01_r8,0.30597e+01_r8,0.34201e+01_r8,0.37628e+01_r8,0.40831e+01_r8 /)
      kbo(:,46,13) = (/ &
        & 0.25661e+01_r8,0.29262e+01_r8,0.32865e+01_r8,0.36383e+01_r8,0.39682e+01_r8 /)
      kbo(:,47,13) = (/ &
        & 0.24176e+01_r8,0.27716e+01_r8,0.31308e+01_r8,0.34925e+01_r8,0.38381e+01_r8 /)
      kbo(:,48,13) = (/ &
        & 0.22754e+01_r8,0.26218e+01_r8,0.29793e+01_r8,0.33363e+01_r8,0.36948e+01_r8 /)
      kbo(:,49,13) = (/ &
        & 0.21329e+01_r8,0.24724e+01_r8,0.28302e+01_r8,0.31874e+01_r8,0.35454e+01_r8 /)
      kbo(:,50,13) = (/ &
        & 0.20005e+01_r8,0.23398e+01_r8,0.26856e+01_r8,0.30422e+01_r8,0.34002e+01_r8 /)
      kbo(:,51,13) = (/ &
        & 0.18713e+01_r8,0.22087e+01_r8,0.25515e+01_r8,0.29067e+01_r8,0.32588e+01_r8 /)
      kbo(:,52,13) = (/ &
        & 0.17459e+01_r8,0.20772e+01_r8,0.24169e+01_r8,0.27666e+01_r8,0.31241e+01_r8 /)
      kbo(:,53,13) = (/ &
        & 0.16095e+01_r8,0.19502e+01_r8,0.22895e+01_r8,0.26325e+01_r8,0.29855e+01_r8 /)
      kbo(:,54,13) = (/ &
        & 0.15066e+01_r8,0.18320e+01_r8,0.21659e+01_r8,0.25081e+01_r8,0.28569e+01_r8 /)
      kbo(:,55,13) = (/ &
        & 0.14318e+01_r8,0.17117e+01_r8,0.20491e+01_r8,0.23896e+01_r8,0.27343e+01_r8 /)
      kbo(:,56,13) = (/ &
        & 0.13449e+01_r8,0.16235e+01_r8,0.19309e+01_r8,0.22682e+01_r8,0.26139e+01_r8 /)
      kbo(:,57,13) = (/ &
        & 0.12667e+01_r8,0.15514e+01_r8,0.18274e+01_r8,0.21528e+01_r8,0.24919e+01_r8 /)
      kbo(:,58,13) = (/ &
        & 0.11763e+01_r8,0.14696e+01_r8,0.17445e+01_r8,0.20345e+01_r8,0.23757e+01_r8 /)
      kbo(:,59,13) = (/ &
        & 0.11472e+01_r8,0.14428e+01_r8,0.17312e+01_r8,0.20031e+01_r8,0.23234e+01_r8 /)
      kbo(:,13,14) = (/ &
        & 0.15147e+02_r8,0.15130e+02_r8,0.15113e+02_r8,0.15099e+02_r8,0.15078e+02_r8 /)
      kbo(:,14,14) = (/ &
        & 0.15510e+02_r8,0.15546e+02_r8,0.15567e+02_r8,0.15587e+02_r8,0.15585e+02_r8 /)
      kbo(:,15,14) = (/ &
        & 0.15739e+02_r8,0.15841e+02_r8,0.15930e+02_r8,0.15986e+02_r8,0.16004e+02_r8 /)
      kbo(:,16,14) = (/ &
        & 0.15858e+02_r8,0.16042e+02_r8,0.16196e+02_r8,0.16295e+02_r8,0.16347e+02_r8 /)
      kbo(:,17,14) = (/ &
        & 0.15892e+02_r8,0.16168e+02_r8,0.16375e+02_r8,0.16519e+02_r8,0.16620e+02_r8 /)
      kbo(:,18,14) = (/ &
        & 0.15890e+02_r8,0.16233e+02_r8,0.16495e+02_r8,0.16687e+02_r8,0.16843e+02_r8 /)
      kbo(:,19,14) = (/ &
        & 0.15860e+02_r8,0.16260e+02_r8,0.16572e+02_r8,0.16822e+02_r8,0.17016e+02_r8 /)
      kbo(:,20,14) = (/ &
        & 0.15821e+02_r8,0.16274e+02_r8,0.16642e+02_r8,0.16937e+02_r8,0.17165e+02_r8 /)
      kbo(:,21,14) = (/ &
        & 0.15778e+02_r8,0.16284e+02_r8,0.16705e+02_r8,0.17036e+02_r8,0.17293e+02_r8 /)
      kbo(:,22,14) = (/ &
        & 0.15777e+02_r8,0.16337e+02_r8,0.16794e+02_r8,0.17151e+02_r8,0.17417e+02_r8 /)
      kbo(:,23,14) = (/ &
        & 0.15815e+02_r8,0.16408e+02_r8,0.16883e+02_r8,0.17258e+02_r8,0.17537e+02_r8 /)
      kbo(:,24,14) = (/ &
        & 0.15884e+02_r8,0.16493e+02_r8,0.16982e+02_r8,0.17365e+02_r8,0.17648e+02_r8 /)
      kbo(:,25,14) = (/ &
        & 0.15973e+02_r8,0.16594e+02_r8,0.17087e+02_r8,0.17470e+02_r8,0.17753e+02_r8 /)
      kbo(:,26,14) = (/ &
        & 0.16098e+02_r8,0.16711e+02_r8,0.17198e+02_r8,0.17574e+02_r8,0.17853e+02_r8 /)
      kbo(:,27,14) = (/ &
        & 0.16232e+02_r8,0.16836e+02_r8,0.17310e+02_r8,0.17676e+02_r8,0.17946e+02_r8 /)
      kbo(:,28,14) = (/ &
        & 0.16376e+02_r8,0.16966e+02_r8,0.17425e+02_r8,0.17775e+02_r8,0.18032e+02_r8 /)
      kbo(:,29,14) = (/ &
        & 0.16527e+02_r8,0.17096e+02_r8,0.17538e+02_r8,0.17871e+02_r8,0.18111e+02_r8 /)
      kbo(:,30,14) = (/ &
        & 0.16681e+02_r8,0.17223e+02_r8,0.17646e+02_r8,0.17959e+02_r8,0.18183e+02_r8 /)
      kbo(:,31,14) = (/ &
        & 0.16832e+02_r8,0.17348e+02_r8,0.17747e+02_r8,0.18041e+02_r8,0.18247e+02_r8 /)
      kbo(:,32,14) = (/ &
        & 0.16982e+02_r8,0.17470e+02_r8,0.17844e+02_r8,0.18116e+02_r8,0.18304e+02_r8 /)
      kbo(:,33,14) = (/ &
        & 0.17125e+02_r8,0.17586e+02_r8,0.17935e+02_r8,0.18187e+02_r8,0.18356e+02_r8 /)
      kbo(:,34,14) = (/ &
        & 0.17243e+02_r8,0.17681e+02_r8,0.18009e+02_r8,0.18243e+02_r8,0.18396e+02_r8 /)
      kbo(:,35,14) = (/ &
        & 0.17308e+02_r8,0.17736e+02_r8,0.18053e+02_r8,0.18277e+02_r8,0.18422e+02_r8 /)
      kbo(:,36,14) = (/ &
        & 0.17321e+02_r8,0.17747e+02_r8,0.18064e+02_r8,0.18289e+02_r8,0.18431e+02_r8 /)
      kbo(:,37,14) = (/ &
        & 0.17259e+02_r8,0.17701e+02_r8,0.18033e+02_r8,0.18270e+02_r8,0.18425e+02_r8 /)
      kbo(:,38,14) = (/ &
        & 0.17190e+02_r8,0.17649e+02_r8,0.17997e+02_r8,0.18247e+02_r8,0.18415e+02_r8 /)
      kbo(:,39,14) = (/ &
        & 0.17116e+02_r8,0.17594e+02_r8,0.17957e+02_r8,0.18221e+02_r8,0.18401e+02_r8 /)
      kbo(:,40,14) = (/ &
        & 0.16981e+02_r8,0.17491e+02_r8,0.17882e+02_r8,0.18168e+02_r8,0.18367e+02_r8 /)
      kbo(:,41,14) = (/ &
        & 0.16829e+02_r8,0.17375e+02_r8,0.17795e+02_r8,0.18107e+02_r8,0.18328e+02_r8 /)
      kbo(:,42,14) = (/ &
        & 0.16667e+02_r8,0.17250e+02_r8,0.17700e+02_r8,0.18038e+02_r8,0.18281e+02_r8 /)
      kbo(:,43,14) = (/ &
        & 0.16452e+02_r8,0.17082e+02_r8,0.17573e+02_r8,0.17944e+02_r8,0.18214e+02_r8 /)
      kbo(:,44,14) = (/ &
        & 0.16203e+02_r8,0.16887e+02_r8,0.17421e+02_r8,0.17833e+02_r8,0.18135e+02_r8 /)
      kbo(:,45,14) = (/ &
        & 0.15935e+02_r8,0.16673e+02_r8,0.17257e+02_r8,0.17708e+02_r8,0.18046e+02_r8 /)
      kbo(:,46,14) = (/ &
        & 0.15628e+02_r8,0.16427e+02_r8,0.17064e+02_r8,0.17560e+02_r8,0.17936e+02_r8 /)
      kbo(:,47,14) = (/ &
        & 0.15258e+02_r8,0.16126e+02_r8,0.16827e+02_r8,0.17377e+02_r8,0.17799e+02_r8 /)
      kbo(:,48,14) = (/ &
        & 0.14864e+02_r8,0.15798e+02_r8,0.16564e+02_r8,0.17174e+02_r8,0.17643e+02_r8 /)
      kbo(:,49,14) = (/ &
        & 0.14439e+02_r8,0.15441e+02_r8,0.16276e+02_r8,0.16946e+02_r8,0.17469e+02_r8 /)
      kbo(:,50,14) = (/ &
        & 0.14012e+02_r8,0.15084e+02_r8,0.15980e+02_r8,0.16711e+02_r8,0.17289e+02_r8 /)
      kbo(:,51,14) = (/ &
        & 0.13576e+02_r8,0.14715e+02_r8,0.15671e+02_r8,0.16463e+02_r8,0.17096e+02_r8 /)
      kbo(:,52,14) = (/ &
        & 0.13120e+02_r8,0.14320e+02_r8,0.15341e+02_r8,0.16194e+02_r8,0.16882e+02_r8 /)
      kbo(:,53,14) = (/ &
        & 0.12642e+02_r8,0.13899e+02_r8,0.14988e+02_r8,0.15902e+02_r8,0.16649e+02_r8 /)
      kbo(:,54,14) = (/ &
        & 0.12147e+02_r8,0.13496e+02_r8,0.14645e+02_r8,0.15614e+02_r8,0.16418e+02_r8 /)
      kbo(:,55,14) = (/ &
        & 0.11626e+02_r8,0.13090e+02_r8,0.14295e+02_r8,0.15320e+02_r8,0.16178e+02_r8 /)
      kbo(:,56,14) = (/ &
        & 0.11110e+02_r8,0.12619e+02_r8,0.13926e+02_r8,0.15012e+02_r8,0.15922e+02_r8 /)
      kbo(:,57,14) = (/ &
        & 0.10565e+02_r8,0.12110e+02_r8,0.13518e+02_r8,0.14685e+02_r8,0.15649e+02_r8 /)
      kbo(:,58,14) = (/ &
        & 0.10061e+02_r8,0.11633e+02_r8,0.13084e+02_r8,0.14356e+02_r8,0.15374e+02_r8 /)
      kbo(:,59,14) = (/ &
        & 0.98377e+01_r8,0.11416e+02_r8,0.12868e+02_r8,0.14184e+02_r8,0.15259e+02_r8 /)
      kbo(:,13,15) = (/ &
        & 0.41304e+02_r8,0.40483e+02_r8,0.39654e+02_r8,0.38829e+02_r8,0.38029e+02_r8 /)
      kbo(:,14,15) = (/ &
        & 0.44686e+02_r8,0.43762e+02_r8,0.42836e+02_r8,0.41888e+02_r8,0.41004e+02_r8 /)
      kbo(:,15,15) = (/ &
        & 0.48004e+02_r8,0.46942e+02_r8,0.45864e+02_r8,0.44813e+02_r8,0.43844e+02_r8 /)
      kbo(:,16,15) = (/ &
        & 0.51150e+02_r8,0.49938e+02_r8,0.48734e+02_r8,0.47591e+02_r8,0.46512e+02_r8 /)
      kbo(:,17,15) = (/ &
        & 0.54100e+02_r8,0.52729e+02_r8,0.51435e+02_r8,0.50180e+02_r8,0.48962e+02_r8 /)
      kbo(:,18,15) = (/ &
        & 0.56777e+02_r8,0.55306e+02_r8,0.53894e+02_r8,0.52525e+02_r8,0.51164e+02_r8 /)
      kbo(:,19,15) = (/ &
        & 0.59186e+02_r8,0.57635e+02_r8,0.56100e+02_r8,0.54603e+02_r8,0.53129e+02_r8 /)
      kbo(:,20,15) = (/ &
        & 0.61293e+02_r8,0.59648e+02_r8,0.58005e+02_r8,0.56388e+02_r8,0.54798e+02_r8 /)
      kbo(:,21,15) = (/ &
        & 0.63124e+02_r8,0.61368e+02_r8,0.59613e+02_r8,0.57895e+02_r8,0.56204e+02_r8 /)
      kbo(:,22,15) = (/ &
        & 0.64562e+02_r8,0.62695e+02_r8,0.60841e+02_r8,0.59040e+02_r8,0.57268e+02_r8 /)
      kbo(:,23,15) = (/ &
        & 0.65690e+02_r8,0.63742e+02_r8,0.61820e+02_r8,0.59937e+02_r8,0.58087e+02_r8 /)
      kbo(:,24,15) = (/ &
        & 0.66548e+02_r8,0.64535e+02_r8,0.62550e+02_r8,0.60597e+02_r8,0.58690e+02_r8 /)
      kbo(:,25,15) = (/ &
        & 0.67194e+02_r8,0.65115e+02_r8,0.63062e+02_r8,0.61050e+02_r8,0.59091e+02_r8 /)
      kbo(:,26,15) = (/ &
        & 0.67597e+02_r8,0.65466e+02_r8,0.63369e+02_r8,0.61312e+02_r8,0.59309e+02_r8 /)
      kbo(:,27,15) = (/ &
        & 0.67831e+02_r8,0.65647e+02_r8,0.63518e+02_r8,0.61430e+02_r8,0.59393e+02_r8 /)
      kbo(:,28,15) = (/ &
        & 0.67908e+02_r8,0.65687e+02_r8,0.63527e+02_r8,0.61427e+02_r8,0.59357e+02_r8 /)
      kbo(:,29,15) = (/ &
        & 0.67845e+02_r8,0.65603e+02_r8,0.63419e+02_r8,0.61304e+02_r8,0.59222e+02_r8 /)
      kbo(:,30,15) = (/ &
        & 0.67682e+02_r8,0.65422e+02_r8,0.63225e+02_r8,0.61094e+02_r8,0.59010e+02_r8 /)
      kbo(:,31,15) = (/ &
        & 0.67415e+02_r8,0.65154e+02_r8,0.62953e+02_r8,0.60816e+02_r8,0.58721e+02_r8 /)
      kbo(:,32,15) = (/ &
        & 0.67084e+02_r8,0.64817e+02_r8,0.62622e+02_r8,0.60477e+02_r8,0.58393e+02_r8 /)
      kbo(:,33,15) = (/ &
        & 0.66692e+02_r8,0.64428e+02_r8,0.62242e+02_r8,0.60092e+02_r8,0.58024e+02_r8 /)
      kbo(:,34,15) = (/ &
        & 0.66346e+02_r8,0.64077e+02_r8,0.61890e+02_r8,0.59745e+02_r8,0.57700e+02_r8 /)
      kbo(:,35,15) = (/ &
        & 0.66188e+02_r8,0.63920e+02_r8,0.61727e+02_r8,0.59582e+02_r8,0.57542e+02_r8 /)
      kbo(:,36,15) = (/ &
        & 0.66248e+02_r8,0.63978e+02_r8,0.61782e+02_r8,0.59625e+02_r8,0.57587e+02_r8 /)
      kbo(:,37,15) = (/ &
        & 0.66642e+02_r8,0.64358e+02_r8,0.62144e+02_r8,0.59978e+02_r8,0.57911e+02_r8 /)
      kbo(:,38,15) = (/ &
        & 0.67048e+02_r8,0.64747e+02_r8,0.62516e+02_r8,0.60340e+02_r8,0.58249e+02_r8 /)
      kbo(:,39,15) = (/ &
        & 0.67435e+02_r8,0.65122e+02_r8,0.62879e+02_r8,0.60689e+02_r8,0.58578e+02_r8 /)
      kbo(:,40,15) = (/ &
        & 0.68061e+02_r8,0.65724e+02_r8,0.63462e+02_r8,0.61257e+02_r8,0.59113e+02_r8 /)
      kbo(:,41,15) = (/ &
        & 0.68702e+02_r8,0.66354e+02_r8,0.64067e+02_r8,0.61847e+02_r8,0.59682e+02_r8 /)
      kbo(:,42,15) = (/ &
        & 0.69355e+02_r8,0.66983e+02_r8,0.64678e+02_r8,0.62437e+02_r8,0.60259e+02_r8 /)
      kbo(:,43,15) = (/ &
        & 0.70142e+02_r8,0.67744e+02_r8,0.65416e+02_r8,0.63159e+02_r8,0.60959e+02_r8 /)
      kbo(:,44,15) = (/ &
        & 0.70991e+02_r8,0.68567e+02_r8,0.66218e+02_r8,0.63930e+02_r8,0.61713e+02_r8 /)
      kbo(:,45,15) = (/ &
        & 0.71837e+02_r8,0.69401e+02_r8,0.67026e+02_r8,0.64713e+02_r8,0.62473e+02_r8 /)
      kbo(:,46,15) = (/ &
        & 0.72733e+02_r8,0.70287e+02_r8,0.67885e+02_r8,0.65552e+02_r8,0.63292e+02_r8 /)
      kbo(:,47,15) = (/ &
        & 0.73741e+02_r8,0.71285e+02_r8,0.68859e+02_r8,0.66493e+02_r8,0.64198e+02_r8 /)
      kbo(:,48,15) = (/ &
        & 0.74725e+02_r8,0.72283e+02_r8,0.69840e+02_r8,0.67442e+02_r8,0.65125e+02_r8 /)
      kbo(:,49,15) = (/ &
        & 0.75665e+02_r8,0.73280e+02_r8,0.70828e+02_r8,0.68404e+02_r8,0.66060e+02_r8 /)
      kbo(:,50,15) = (/ &
        & 0.76534e+02_r8,0.74218e+02_r8,0.71764e+02_r8,0.69323e+02_r8,0.66942e+02_r8 /)
      kbo(:,51,15) = (/ &
        & 0.77333e+02_r8,0.75093e+02_r8,0.72664e+02_r8,0.70214e+02_r8,0.67806e+02_r8 /)
      kbo(:,52,15) = (/ &
        & 0.78102e+02_r8,0.75935e+02_r8,0.73563e+02_r8,0.71111e+02_r8,0.68683e+02_r8 /)
      kbo(:,53,15) = (/ &
        & 0.78815e+02_r8,0.76761e+02_r8,0.74462e+02_r8,0.72010e+02_r8,0.69568e+02_r8 /)
      kbo(:,54,15) = (/ &
        & 0.79431e+02_r8,0.77488e+02_r8,0.75258e+02_r8,0.72840e+02_r8,0.70386e+02_r8 /)
      kbo(:,55,15) = (/ &
        & 0.79987e+02_r8,0.78156e+02_r8,0.75999e+02_r8,0.73628e+02_r8,0.71177e+02_r8 /)
      kbo(:,56,15) = (/ &
        & 0.80478e+02_r8,0.78776e+02_r8,0.76714e+02_r8,0.74415e+02_r8,0.71963e+02_r8 /)
      kbo(:,57,15) = (/ &
        & 0.80898e+02_r8,0.79365e+02_r8,0.77410e+02_r8,0.75181e+02_r8,0.72750e+02_r8 /)
      kbo(:,58,15) = (/ &
        & 0.81210e+02_r8,0.79894e+02_r8,0.78053e+02_r8,0.75880e+02_r8,0.73498e+02_r8 /)
      kbo(:,59,15) = (/ &
        & 0.81312e+02_r8,0.80086e+02_r8,0.78299e+02_r8,0.76156e+02_r8,0.73801e+02_r8 /)
      kbo(:,13,16) = (/ &
        & 0.81866e+02_r8,0.78569e+02_r8,0.75624e+02_r8,0.72854e+02_r8,0.70288e+02_r8 /)
      kbo(:,14,16) = (/ &
        & 0.93095e+02_r8,0.88986e+02_r8,0.85351e+02_r8,0.82051e+02_r8,0.78936e+02_r8 /)
      kbo(:,15,16) = (/ &
        & 0.10470e+03_r8,0.99738e+02_r8,0.95227e+02_r8,0.91249e+02_r8,0.87478e+02_r8 /)
      kbo(:,16,16) = (/ &
        & 0.11635e+03_r8,0.11037e+03_r8,0.10495e+03_r8,0.10011e+03_r8,0.95646e+02_r8 /)
      kbo(:,17,16) = (/ &
        & 0.12769e+03_r8,0.12074e+03_r8,0.11431e+03_r8,0.10856e+03_r8,0.10332e+03_r8 /)
      kbo(:,18,16) = (/ &
        & 0.13851e+03_r8,0.13038e+03_r8,0.12299e+03_r8,0.11635e+03_r8,0.11033e+03_r8 /)
      kbo(:,19,16) = (/ &
        & 0.14848e+03_r8,0.13912e+03_r8,0.13084e+03_r8,0.12336e+03_r8,0.11656e+03_r8 /)
      kbo(:,20,16) = (/ &
        & 0.15718e+03_r8,0.14679e+03_r8,0.13761e+03_r8,0.12934e+03_r8,0.12188e+03_r8 /)
      kbo(:,21,16) = (/ &
        & 0.16462e+03_r8,0.15341e+03_r8,0.14345e+03_r8,0.13443e+03_r8,0.12636e+03_r8 /)
      kbo(:,22,16) = (/ &
        & 0.17012e+03_r8,0.15822e+03_r8,0.14760e+03_r8,0.13801e+03_r8,0.12950e+03_r8 /)
      kbo(:,23,16) = (/ &
        & 0.17437e+03_r8,0.16184e+03_r8,0.15069e+03_r8,0.14069e+03_r8,0.13184e+03_r8 /)
      kbo(:,24,16) = (/ &
        & 0.17733e+03_r8,0.16436e+03_r8,0.15282e+03_r8,0.14251e+03_r8,0.13340e+03_r8 /)
      kbo(:,25,16) = (/ &
        & 0.17910e+03_r8,0.16583e+03_r8,0.15401e+03_r8,0.14354e+03_r8,0.13426e+03_r8 /)
      kbo(:,26,16) = (/ &
        & 0.17968e+03_r8,0.16627e+03_r8,0.15433e+03_r8,0.14378e+03_r8,0.13445e+03_r8 /)
      kbo(:,27,16) = (/ &
        & 0.17946e+03_r8,0.16602e+03_r8,0.15406e+03_r8,0.14351e+03_r8,0.13417e+03_r8 /)
      kbo(:,28,16) = (/ &
        & 0.17860e+03_r8,0.16522e+03_r8,0.15334e+03_r8,0.14282e+03_r8,0.13355e+03_r8 /)
      kbo(:,29,16) = (/ &
        & 0.17717e+03_r8,0.16389e+03_r8,0.15216e+03_r8,0.14174e+03_r8,0.13260e+03_r8 /)
      kbo(:,30,16) = (/ &
        & 0.17533e+03_r8,0.16225e+03_r8,0.15066e+03_r8,0.14043e+03_r8,0.13143e+03_r8 /)
      kbo(:,31,16) = (/ &
        & 0.17313e+03_r8,0.16029e+03_r8,0.14890e+03_r8,0.13886e+03_r8,0.13004e+03_r8 /)
      kbo(:,32,16) = (/ &
        & 0.17069e+03_r8,0.15811e+03_r8,0.14694e+03_r8,0.13716e+03_r8,0.12847e+03_r8 /)
      kbo(:,33,16) = (/ &
        & 0.16804e+03_r8,0.15577e+03_r8,0.14487e+03_r8,0.13533e+03_r8,0.12682e+03_r8 /)
      kbo(:,34,16) = (/ &
        & 0.16580e+03_r8,0.15376e+03_r8,0.14309e+03_r8,0.13376e+03_r8,0.12539e+03_r8 /)
      kbo(:,35,16) = (/ &
        & 0.16467e+03_r8,0.15275e+03_r8,0.14221e+03_r8,0.13298e+03_r8,0.12468e+03_r8 /)
      kbo(:,36,16) = (/ &
        & 0.16486e+03_r8,0.15289e+03_r8,0.14233e+03_r8,0.13308e+03_r8,0.12477e+03_r8 /)
      kbo(:,37,16) = (/ &
        & 0.16688e+03_r8,0.15469e+03_r8,0.14392e+03_r8,0.13446e+03_r8,0.12602e+03_r8 /)
      kbo(:,38,16) = (/ &
        & 0.16902e+03_r8,0.15657e+03_r8,0.14555e+03_r8,0.13592e+03_r8,0.12732e+03_r8 /)
      kbo(:,39,16) = (/ &
        & 0.17110e+03_r8,0.15844e+03_r8,0.14718e+03_r8,0.13734e+03_r8,0.12861e+03_r8 /)
      kbo(:,40,16) = (/ &
        & 0.17468e+03_r8,0.16155e+03_r8,0.14992e+03_r8,0.13976e+03_r8,0.13077e+03_r8 /)
      kbo(:,41,16) = (/ &
        & 0.17848e+03_r8,0.16489e+03_r8,0.15289e+03_r8,0.14236e+03_r8,0.13307e+03_r8 /)
      kbo(:,42,16) = (/ &
        & 0.18237e+03_r8,0.16833e+03_r8,0.15592e+03_r8,0.14501e+03_r8,0.13541e+03_r8 /)
      kbo(:,43,16) = (/ &
        & 0.18726e+03_r8,0.17263e+03_r8,0.15975e+03_r8,0.14834e+03_r8,0.13835e+03_r8 /)
      kbo(:,44,16) = (/ &
        & 0.19275e+03_r8,0.17748e+03_r8,0.16403e+03_r8,0.15210e+03_r8,0.14166e+03_r8 /)
      kbo(:,45,16) = (/ &
        & 0.19851e+03_r8,0.18250e+03_r8,0.16844e+03_r8,0.15602e+03_r8,0.14507e+03_r8 /)
      kbo(:,46,16) = (/ &
        & 0.20490e+03_r8,0.18806e+03_r8,0.17333e+03_r8,0.16038e+03_r8,0.14888e+03_r8 /)
      kbo(:,47,16) = (/ &
        & 0.21238e+03_r8,0.19462e+03_r8,0.17910e+03_r8,0.16545e+03_r8,0.15337e+03_r8 /)
      kbo(:,48,16) = (/ &
        & 0.22029e+03_r8,0.20156e+03_r8,0.18514e+03_r8,0.17074e+03_r8,0.15806e+03_r8 /)
      kbo(:,49,16) = (/ &
        & 0.22889e+03_r8,0.20882e+03_r8,0.19150e+03_r8,0.17637e+03_r8,0.16304e+03_r8 /)
      kbo(:,50,16) = (/ &
        & 0.23745e+03_r8,0.21596e+03_r8,0.19782e+03_r8,0.18187e+03_r8,0.16787e+03_r8 /)
      kbo(:,51,16) = (/ &
        & 0.24629e+03_r8,0.22340e+03_r8,0.20422e+03_r8,0.18747e+03_r8,0.17280e+03_r8 /)
      kbo(:,52,16) = (/ &
        & 0.25553e+03_r8,0.23136e+03_r8,0.21090e+03_r8,0.19335e+03_r8,0.17798e+03_r8 /)
      kbo(:,53,16) = (/ &
        & 0.26553e+03_r8,0.23980e+03_r8,0.21793e+03_r8,0.19951e+03_r8,0.18336e+03_r8 /)
      kbo(:,54,16) = (/ &
        & 0.27524e+03_r8,0.24799e+03_r8,0.22485e+03_r8,0.20544e+03_r8,0.18854e+03_r8 /)
      kbo(:,55,16) = (/ &
        & 0.28502e+03_r8,0.25615e+03_r8,0.23188e+03_r8,0.21133e+03_r8,0.19372e+03_r8 /)
      kbo(:,56,16) = (/ &
        & 0.29529e+03_r8,0.26491e+03_r8,0.23927e+03_r8,0.21749e+03_r8,0.19913e+03_r8 /)
      kbo(:,57,16) = (/ &
        & 0.30624e+03_r8,0.27413e+03_r8,0.24703e+03_r8,0.22404e+03_r8,0.20478e+03_r8 /)
      kbo(:,58,16) = (/ &
        & 0.31727e+03_r8,0.28329e+03_r8,0.25471e+03_r8,0.23065e+03_r8,0.21031e+03_r8 /)
      kbo(:,59,16) = (/ &
        & 0.32188e+03_r8,0.28710e+03_r8,0.25796e+03_r8,0.23341e+03_r8,0.21261e+03_r8 /)

!     -----------------------------------------------------------------

      forrefo(:, 1) = (/ 0.214504e-06_r8, 0.460418e-06_r8, 0.357608e-05_r8, 0.192037e-05_r8 /)
      forrefo(:, 2) = (/ 0.142576e-05_r8, 0.364463e-05_r8, 0.117033e-04_r8, 0.112085e-04_r8 /)
      forrefo(:, 3) = (/ 0.101536e-04_r8, 0.124096e-04_r8, 0.509190e-04_r8, 0.565282e-04_r8 /)
      forrefo(:, 4) = (/ 0.143394e-03_r8, 0.154700e-03_r8, 0.466498e-03_r8, 0.918829e-03_r8 /)
      forrefo(:, 5) = (/ 0.251631e-02_r8, 0.241729e-02_r8, 0.240057e-02_r8, 0.350408e-02_r8 /)
      forrefo(:, 6) = (/ 0.410309e-02_r8, 0.416851e-02_r8, 0.390925e-02_r8, 0.383694e-02_r8 /)
      forrefo(:, 7) = (/ 0.445387e-02_r8, 0.448657e-02_r8, 0.432310e-02_r8, 0.370739e-02_r8 /)
      forrefo(:, 8) = (/ 0.458150e-02_r8, 0.460014e-02_r8, 0.450245e-02_r8, 0.336718e-02_r8 /)
      forrefo(:, 9) = (/ 0.465423e-02_r8, 0.465595e-02_r8, 0.467006e-02_r8, 0.368061e-02_r8 /)
      forrefo(:,10) = (/ 0.493955e-02_r8, 0.490181e-02_r8, 0.481941e-02_r8, 0.367577e-02_r8 /)
      forrefo(:,11) = (/ 0.511876e-02_r8, 0.490981e-02_r8, 0.493303e-02_r8, 0.357423e-02_r8 /)
      forrefo(:,12) = (/ 0.509845e-02_r8, 0.511556e-02_r8, 0.504031e-02_r8, 0.355915e-02_r8 /)
      forrefo(:,13) = (/ 0.523822e-02_r8, 0.530473e-02_r8, 0.523811e-02_r8, 0.414259e-02_r8 /)
      forrefo(:,14) = (/ 0.551133e-02_r8, 0.535831e-02_r8, 0.546702e-02_r8, 0.473875e-02_r8 /)
      forrefo(:,15) = (/ 0.609781e-02_r8, 0.589859e-02_r8, 0.561187e-02_r8, 0.528981e-02_r8 /)
      forrefo(:,16) = (/ 0.644958e-02_r8, 0.631718e-02_r8, 0.625201e-02_r8, 0.600448e-02_r8 /)

!     -----------------------------------------------------------------
!     The array SELFREFO contains the coefficient of the water vapor
!     self-continuum (including the energy term).  The first index
!     refers to temperature in 7.2 degree increments.  For instance,
!     JT = 1 refers to a temperature of 245.6, JT = 2 refers to 252.8,
!     etc.  The second index runs over the g-channel (1 to 16).

      selfrefo(:, 1) = (/ &
        &  0.217058e-03_r8, 0.176391e-03_r8, 0.143342e-03_r8, 0.116486e-03_r8, 0.946614e-04_r8, &
        &  0.769257e-04_r8, 0.625131e-04_r8, 0.508007e-04_r8, 0.412828e-04_r8, 0.335481e-04_r8 /)
      selfrefo(:, 2) = (/ &
        &  0.598055e-03_r8, 0.484805e-03_r8, 0.393000e-03_r8, 0.318580e-03_r8, 0.258252e-03_r8, &
        &  0.209348e-03_r8, 0.169705e-03_r8, 0.137569e-03_r8, 0.111518e-03_r8, 0.904008e-04_r8 /)
      selfrefo(:, 3) = (/ &
        &  0.102691e-02_r8, 0.930281e-03_r8, 0.842740e-03_r8, 0.763437e-03_r8, 0.691596e-03_r8, &
        &  0.626516e-03_r8, 0.567560e-03_r8, 0.514152e-03_r8, 0.465769e-03_r8, 0.421940e-03_r8 /)
      selfrefo(:, 4) = (/ &
        &  0.388569e-02_r8, 0.365098e-02_r8, 0.343045e-02_r8, 0.322324e-02_r8, 0.302854e-02_r8, &
        &  0.284561e-02_r8, 0.267372e-02_r8, 0.251222e-02_r8, 0.236047e-02_r8, 0.221789e-02_r8 /)
      selfrefo(:, 5) = (/ &
        &  0.349845e-01_r8, 0.326678e-01_r8, 0.305045e-01_r8, 0.284845e-01_r8, 0.265982e-01_r8, &
        &  0.248369e-01_r8, 0.231921e-01_r8, 0.216563e-01_r8, 0.202222e-01_r8, 0.188831e-01_r8 /)
      selfrefo(:, 6) = (/ &
        &  0.613705e-01_r8, 0.562676e-01_r8, 0.515890e-01_r8, 0.472994e-01_r8, 0.433665e-01_r8, &
        &  0.397606e-01_r8, 0.364545e-01_r8, 0.334233e-01_r8, 0.306442e-01_r8, 0.280961e-01_r8 /)
      selfrefo(:, 7) = (/ &
        &  0.656981e-01_r8, 0.602660e-01_r8, 0.552830e-01_r8, 0.507120e-01_r8, 0.465190e-01_r8, &
        &  0.426726e-01_r8, 0.391443e-01_r8, 0.359077e-01_r8, 0.329387e-01_r8, 0.302153e-01_r8 /)
      selfrefo(:, 8) = (/ &
        &  0.671782e-01_r8, 0.616461e-01_r8, 0.565695e-01_r8, 0.519110e-01_r8, 0.476361e-01_r8, &
        &  0.437132e-01_r8, 0.401134e-01_r8, 0.368100e-01_r8, 0.337787e-01_r8, 0.309970e-01_r8 /)
      selfrefo(:, 9) = (/ &
        &  0.675902e-01_r8, 0.620888e-01_r8, 0.570351e-01_r8, 0.523928e-01_r8, 0.481284e-01_r8, &
        &  0.442110e-01_r8, 0.406125e-01_r8, 0.373069e-01_r8, 0.342703e-01_r8, 0.314809e-01_r8 /)
      selfrefo(:,10) = (/ &
        &  0.708308e-01_r8, 0.651419e-01_r8, 0.599099e-01_r8, 0.550981e-01_r8, 0.506728e-01_r8, &
        &  0.466030e-01_r8, 0.428600e-01_r8, 0.394176e-01_r8, 0.362517e-01_r8, 0.333401e-01_r8 /)
      selfrefo(:,11) = (/ &
        &  0.698445e-01_r8, 0.646584e-01_r8, 0.598573e-01_r8, 0.554128e-01_r8, 0.512982e-01_r8, &
        &  0.474892e-01_r8, 0.439630e-01_r8, 0.406986e-01_r8, 0.376766e-01_r8, 0.348791e-01_r8 /)
      selfrefo(:,12) = (/ &
        &  0.743921e-01_r8, 0.682057e-01_r8, 0.625337e-01_r8, 0.573334e-01_r8, 0.525655e-01_r8, &
        &  0.481942e-01_r8, 0.441863e-01_r8, 0.405118e-01_r8, 0.371428e-01_r8, 0.340540e-01_r8 /)
      selfrefo(:,13) = (/ &
        &  0.775758e-01_r8, 0.709818e-01_r8, 0.649484e-01_r8, 0.594277e-01_r8, 0.543764e-01_r8, &
        &  0.497544e-01_r8, 0.455253e-01_r8, 0.416556e-01_r8, 0.381149e-01_r8, 0.348751e-01_r8 /)
      selfrefo(:,14) = (/ &
        &  0.776545e-01_r8, 0.714761e-01_r8, 0.657894e-01_r8, 0.605550e-01_r8, 0.557372e-01_r8, &
        &  0.513026e-01_r8, 0.472209e-01_r8, 0.434639e-01_r8, 0.400058e-01_r8, 0.368229e-01_r8 /)
      selfrefo(:,15) = (/ &
        &  0.855675e-01_r8, 0.787337e-01_r8, 0.724456e-01_r8, 0.666598e-01_r8, 0.613360e-01_r8, &
        &  0.564374e-01_r8, 0.519301e-01_r8, 0.477827e-01_r8, 0.439666e-01_r8, 0.404552e-01_r8 /)
      selfrefo(:,16) = (/ &
        &  0.934781e-01_r8, 0.855190e-01_r8, 0.782376e-01_r8, 0.715761e-01_r8, 0.654819e-01_r8, &
        &  0.599065e-01_r8, 0.548058e-01_r8, 0.501394e-01_r8, 0.458704e-01_r8, 0.419648e-01_r8 /)
     
      end subroutine sw_kgb20

! **************************************************************************
