!     path:      $Source: /storm/rc1/cvsroot/rc/rrtmg_sw/src/rrtmg_sw_k_g.f90,v $
!     author:    $Author: mike $
!     revision:  $Revision: 1.2 $
!     created:   $Date: 2007/08/23 20:40:13 $

!  --------------------------------------------------------------------------
! |                                                                          |
! |  Copyright 2002-2007, Atmospheric & Environmental Research, Inc. (AER).  |
! |  This software may be used, copied, or redistributed as long as it is    |
! |  not sold and this copyright notice is reproduced on each copy made.     |
! |  This model is provided as is without any express or implied warranties. |
! |                       (http://www.rtweb.aer.com/)                        |
! |                                                                          |
!  --------------------------------------------------------------------------

! **************************************************************************
!      subroutine sw_kgbnn
! **************************************************************************
!  RRTM Shortwave Radiative Transfer Model
!  Atmospheric and Environmental Research, Inc., Cambridge, MA
!
!  Original by J.Delamere, Atmospheric & Environmental Research.
!  Reformatted for F90: JJMorcrette, ECMWF
!  Further F90 and GCM revisions:  MJIacono, AER, July 2002
!
!  This file contains 14 subroutines that include the 
!  absorption coefficients and other data for each of the 14 shortwave
!  spectral bands used in RRTM_SW.  Here, the data are defined for 16
!  g-points, or sub-intervals, per band.  These data are combined and
!  weighted using a mapping procedure in routine RRTMG_SW_INIT to reduce
!  the total number of g-points from 224 to 112 for use in the GCM.
! **************************************************************************

! **************************************************************************
      subroutine sw_kgb21
! **************************************************************************

      use shr_kind_mod, only: r8 => shr_kind_r8

!      use parkind, only : jpim, jprb 
      use rrsw_kg21, only : kao, kbo, selfrefo, forrefo, sfluxrefo, &
                            rayl, strrat, layreffr

      implicit none
      save

! Kurucz solar source function
      sfluxrefo(:, 1) = (/ &
        & 16.1643_r8 , 15.5806_r8, 14.7254_r8    , 13.5541_r8    , &
        & 11.9519_r8 ,10.44410_r8, 8.37884_r8    , 6.26384_r8    , &
        & 4.28435_r8 ,0.465228_r8, 0.385095_r8   ,0.304226_r8    , &
        & 0.222479_r8,0.143286_r8, 5.58046e-02_r8, 7.84856e-03_r8 /)
      sfluxrefo(:, 2) = (/ &
        & 15.6451_r8 , 15.3170_r8, 14.6987_r8    , 13.7350_r8    , &
        & 12.2267_r8 ,10.51646_r8, 8.47150_r8    , 6.38873_r8    , &
        & 4.33536_r8 ,0.470610_r8,0.389426_r8    ,0.306461_r8    , &
        & 0.223537_r8,0.143273_r8, 5.58179e-02_r8, 7.84856e-03_r8 /)
      sfluxrefo(:, 3) = (/ &
        & 15.6092_r8 , 15.3293_r8, 14.6881_r8    , 13.6693_r8    , &
        & 12.2342_r8 ,10.52010_r8, 8.49442_r8    , 6.42138_r8    , &
        & 4.35865_r8 ,0.473349_r8,0.391349_r8    ,0.308861_r8    , &
        & 0.224666_r8,0.144799_r8, 5.58176e-02_r8, 7.84881e-03_r8 /)
      sfluxrefo(:, 4) = (/ &
        & 15.5786_r8 , 15.3422_r8, 14.6894_r8    , 13.6040_r8    , &
        & 12.2567_r8 ,10.49400_r8, 8.53521_r8    , 6.44427_r8    , &
        & 4.37208_r8 ,0.475709_r8,0.392956_r8    ,0.309737_r8    , &
        & 0.226274_r8,0.146483_r8, 5.59325e-02_r8, 7.84881e-03_r8 /)
      sfluxrefo(:, 5) = (/ &
        & 15.5380_r8 , 15.3826_r8, 14.6575_r8    , 13.5722_r8    , &
        & 12.2646_r8 ,10.47672_r8, 8.57158_r8    , 6.46343_r8    , &
        & 4.38259_r8 ,0.477647_r8,0.393982_r8    ,0.310686_r8    , &
        & 0.227620_r8,0.148376_r8, 5.60398e-02_r8, 7.83925e-03_r8 /)
      sfluxrefo(:, 6) = (/ &
        & 15.5124_r8 , 15.3986_r8, 14.6240_r8    , 13.5535_r8    , &
        & 12.2468_r8 ,10.48891_r8, 8.60434_r8    , 6.47985_r8    , &
        & 4.39448_r8 ,0.478267_r8,0.395618_r8    ,0.311043_r8    , &
        & 0.230927_r8,0.148774_r8, 5.61189e-02_r8, 7.83925e-03_r8 /)
      sfluxrefo(:, 7) = (/ &
        & 15.4910_r8 , 15.4028_r8, 14.5772_r8    , 13.5507_r8    , &
        & 12.2122_r8 ,10.52735_r8, 8.62650_r8    , 6.49644_r8    , &
        & 4.41173_r8 ,0.478627_r8,0.396433_r8    ,0.314199_r8    , & 
        & 0.233125_r8,0.149052_r8, 5.62309e-02_r8, 7.83925e-03_r8 /)
      sfluxrefo(:, 8) = (/ &
        & 15.4562_r8 , 15.3928_r8, 14.5510_r8    , 13.5122_r8    , &
        & 12.1890_r8 , 10.5826_r8, 8.65842_r8    , 6.51558_r8    , &
        & 4.42747_r8 ,0.480669_r8,0.400143_r8    ,0.318144_r8    , &
        & 0.233937_r8,0.149119_r8, 5.62309e-02_r8, 7.83925e-03_r8 /)
      sfluxrefo(:, 9) = (/ &
        & 15.0069_r8 , 15.1479_r8, 14.7802_r8    , 13.6085_r8    , &
        & 12.2793_r8 , 10.6929_r8, 8.72723_r8    , 6.57114_r8    , &
        & 4.46330_r8 ,0.486724_r8,0.401446_r8    ,0.318879_r8    , &
        & 0.233959_r8,0.149119_r8, 5.62309e-02_r8, 7.83925e-03_r8 /)

! Rayleigh extinction coefficient at v = 6925 cm-1.
      rayl = 9.41e-09_r8

      strrat = 0.0045321_r8

      layreffr = 8

!     ------------------------------------------------------------------
!     The array KAO contains absorption coefs at the 16 chosen g-values 
!     for a range of pressure levels> ~100mb, temperatures, and binary
!     species parameters (see taumol.f for definition).  The first 
!     index in the array, JS, runs from 1 to 9, and corresponds to 
!     different values of the binary species parameter.  For instance, 
!     JS=1 refers to dry air, JS = 2 corresponds to the paramter value 1/8, 
!     JS = 3 corresponds to the parameter value 2/8, etc.  The second index
!     in the array, JT, which runs from 1 to 5, corresponds to different
!     temperatures.  More specifically, JT = 3 means that the data are for
!     the reference temperature TREF for this  pressure level, JT = 2 refers
!     to TREF-15, JT = 1 is for TREF-30, JT = 4 is for TREF+15, and JT = 5
!     is for TREF+30.  The third index, JP, runs from 1 to 13 and refers
!     to the JPth reference pressure level (see taumol.f for these levels
!     in mb).  The fourth index, IG, goes from 1 to 16, and indicates
!     which g-interval the absorption coefficients are for.
!     -----------------------------------------------------------------

      kao(:, 1, 1, 1) = (/ &
        & 0.31482e-07_r8,0.64010e-05_r8,0.95017e-05_r8,0.11735e-04_r8,0.13561e-04_r8, &
        & 0.15077e-04_r8,0.16121e-04_r8,0.16138e-04_r8,0.41687e-06_r8 /)
      kao(:, 2, 1, 1) = (/ &
        & 0.29791e-07_r8,0.68206e-05_r8,0.10260e-04_r8,0.12764e-04_r8,0.14880e-04_r8, &
        & 0.16665e-04_r8,0.17944e-04_r8,0.18170e-04_r8,0.44246e-06_r8 /)
      kao(:, 3, 1, 1) = (/ &
        & 0.28272e-07_r8,0.72448e-05_r8,0.11083e-04_r8,0.13866e-04_r8,0.16256e-04_r8, &
        & 0.18323e-04_r8,0.19886e-04_r8,0.20229e-04_r8,0.47472e-06_r8 /)
      kao(:, 4, 1, 1) = (/ &
        & 0.26900e-07_r8,0.76935e-05_r8,0.11934e-04_r8,0.15015e-04_r8,0.17657e-04_r8, &
        & 0.20038e-04_r8,0.21902e-04_r8,0.22361e-04_r8,0.50770e-06_r8 /)
      kao(:, 5, 1, 1) = (/ &
        & 0.25656e-07_r8,0.81661e-05_r8,0.12769e-04_r8,0.16181e-04_r8,0.19127e-04_r8, &
        & 0.21755e-04_r8,0.23963e-04_r8,0.24421e-04_r8,0.54205e-06_r8 /)
      kao(:, 1, 2, 1) = (/ &
        & 0.26396e-07_r8,0.52225e-05_r8,0.77221e-05_r8,0.95150e-05_r8,0.11004e-04_r8, &
        & 0.12195e-04_r8,0.13037e-04_r8,0.12985e-04_r8,0.32097e-06_r8 /)
      kao(:, 2, 2, 1) = (/ &
        & 0.24945e-07_r8,0.55737e-05_r8,0.83612e-05_r8,0.10375e-04_r8,0.12116e-04_r8, &
        & 0.13569e-04_r8,0.14561e-04_r8,0.14711e-04_r8,0.34579e-06_r8 /)
      kao(:, 3, 2, 1) = (/ &
        & 0.23646e-07_r8,0.59333e-05_r8,0.90531e-05_r8,0.11301e-04_r8,0.13247e-04_r8, &
        & 0.14956e-04_r8,0.16193e-04_r8,0.16396e-04_r8,0.37200e-06_r8 /)
      kao(:, 4, 2, 1) = (/ &
        & 0.22476e-07_r8,0.63144e-05_r8,0.97732e-05_r8,0.12274e-04_r8,0.14436e-04_r8, &
        & 0.16377e-04_r8,0.17879e-04_r8,0.18223e-04_r8,0.40051e-06_r8 /)
      kao(:, 5, 2, 1) = (/ &
        & 0.21415e-07_r8,0.67133e-05_r8,0.10471e-04_r8,0.13264e-04_r8,0.15681e-04_r8, &
        & 0.17843e-04_r8,0.19627e-04_r8,0.19954e-04_r8,0.42929e-06_r8 /)
      kao(:, 1, 3, 1) = (/ &
        & 0.22397e-07_r8,0.41930e-05_r8,0.61559e-05_r8,0.75544e-05_r8,0.86902e-05_r8, &
        & 0.95896e-05_r8,0.10269e-04_r8,0.10114e-04_r8,0.24148e-06_r8 /)
      kao(:, 2, 3, 1) = (/ &
        & 0.21124e-07_r8,0.44837e-05_r8,0.66786e-05_r8,0.82475e-05_r8,0.96353e-05_r8, &
        & 0.10742e-04_r8,0.11469e-04_r8,0.11556e-04_r8,0.26304e-06_r8 /)
      kao(:, 3, 3, 1) = (/ &
        & 0.19988e-07_r8,0.47839e-05_r8,0.72499e-05_r8,0.90229e-05_r8,0.10560e-04_r8, &
        & 0.11900e-04_r8,0.12859e-04_r8,0.12935e-04_r8,0.28618e-06_r8 /)
      kao(:, 4, 3, 1) = (/ &
        & 0.18968e-07_r8,0.51040e-05_r8,0.78586e-05_r8,0.98308e-05_r8,0.11551e-04_r8, &
        & 0.13094e-04_r8,0.14240e-04_r8,0.14455e-04_r8,0.30983e-06_r8 /)
      kao(:, 5, 3, 1) = (/ &
        & 0.18047e-07_r8,0.54366e-05_r8,0.84462e-05_r8,0.10670e-04_r8,0.12585e-04_r8, &
        & 0.14313e-04_r8,0.15695e-04_r8,0.15934e-04_r8,0.33255e-06_r8 /)
      kao(:, 1, 4, 1) = (/ &
        & 0.19080e-07_r8,0.33409e-05_r8,0.48738e-05_r8,0.59354e-05_r8,0.67877e-05_r8, &
        & 0.74900e-05_r8,0.79142e-05_r8,0.77200e-05_r8,0.18466e-06_r8 /)
      kao(:, 2, 4, 1) = (/ &
        & 0.17954e-07_r8,0.35910e-05_r8,0.52960e-05_r8,0.65037e-05_r8,0.75744e-05_r8, &
        & 0.84082e-05_r8,0.89422e-05_r8,0.89302e-05_r8,0.20292e-06_r8 /)
      kao(:, 3, 4, 1) = (/ &
        & 0.16954e-07_r8,0.38317e-05_r8,0.57536e-05_r8,0.71322e-05_r8,0.83424e-05_r8, &
        & 0.93788e-05_r8,0.10063e-04_r8,0.10098e-04_r8,0.22173e-06_r8 /)
      kao(:, 4, 4, 1) = (/ &
        & 0.16059e-07_r8,0.40932e-05_r8,0.62586e-05_r8,0.77961e-05_r8,0.91475e-05_r8, &
        & 0.10347e-04_r8,0.11222e-04_r8,0.11312e-04_r8,0.24005e-06_r8 /)
      kao(:, 5, 4, 1) = (/ &
        & 0.15254e-07_r8,0.43678e-05_r8,0.67525e-05_r8,0.84873e-05_r8,0.99995e-05_r8, &
        & 0.11353e-04_r8,0.12416e-04_r8,0.12586e-04_r8,0.25939e-06_r8 /)
      kao(:, 1, 5, 1) = (/ &
        & 0.16261e-07_r8,0.26540e-05_r8,0.38541e-05_r8,0.46443e-05_r8,0.52961e-05_r8, &
        & 0.58054e-05_r8,0.60718e-05_r8,0.58540e-05_r8,0.14274e-06_r8 /)
      kao(:, 2, 5, 1) = (/ &
        & 0.15265e-07_r8,0.28598e-05_r8,0.41831e-05_r8,0.51221e-05_r8,0.59110e-05_r8, &
        & 0.65207e-05_r8,0.69761e-05_r8,0.68685e-05_r8,0.15725e-06_r8 /)
      kao(:, 3, 5, 1) = (/ &
        & 0.14384e-07_r8,0.30623e-05_r8,0.45528e-05_r8,0.56124e-05_r8,0.65650e-05_r8, &
        & 0.73436e-05_r8,0.78208e-05_r8,0.78523e-05_r8,0.17271e-06_r8 /)
      kao(:, 4, 5, 1) = (/ &
        & 0.13599e-07_r8,0.32720e-05_r8,0.49622e-05_r8,0.61605e-05_r8,0.72244e-05_r8, &
        & 0.81582e-05_r8,0.87971e-05_r8,0.88096e-05_r8,0.18766e-06_r8 /)
      kao(:, 5, 5, 1) = (/ &
        & 0.12895e-07_r8,0.34985e-05_r8,0.53833e-05_r8,0.67240e-05_r8,0.79091e-05_r8, &
        & 0.89688e-05_r8,0.97698e-05_r8,0.98639e-05_r8,0.20375e-06_r8 /)
      kao(:, 1, 6, 1) = (/ &
        & 0.13898e-07_r8,0.20981e-05_r8,0.30384e-05_r8,0.36041e-05_r8,0.41040e-05_r8, &
        & 0.44334e-05_r8,0.45761e-05_r8,0.43950e-05_r8,0.11025e-06_r8 /)
      kao(:, 2, 6, 1) = (/ &
        & 0.13011e-07_r8,0.22645e-05_r8,0.32890e-05_r8,0.40042e-05_r8,0.45851e-05_r8, &
        & 0.50473e-05_r8,0.53250e-05_r8,0.51854e-05_r8,0.12227e-06_r8 /)
      kao(:, 3, 6, 1) = (/ &
        & 0.12231e-07_r8,0.24322e-05_r8,0.35842e-05_r8,0.43915e-05_r8,0.51259e-05_r8, &
        & 0.56903e-05_r8,0.60343e-05_r8,0.60166e-05_r8,0.13506e-06_r8 /)
      kao(:, 4, 6, 1) = (/ &
        & 0.11539e-07_r8,0.26032e-05_r8,0.39107e-05_r8,0.48321e-05_r8,0.56525e-05_r8, &
        & 0.63625e-05_r8,0.68078e-05_r8,0.68024e-05_r8,0.14719e-06_r8 /)
      kao(:, 5, 6, 1) = (/ &
        & 0.10921e-07_r8,0.27866e-05_r8,0.42578e-05_r8,0.52919e-05_r8,0.62181e-05_r8, &
        & 0.70362e-05_r8,0.76140e-05_r8,0.76519e-05_r8,0.16052e-06_r8 /)
      kao(:, 1, 7, 1) = (/ &
        & 0.11886e-07_r8,0.16563e-05_r8,0.23860e-05_r8,0.28276e-05_r8,0.31449e-05_r8, &
        & 0.33771e-05_r8,0.34305e-05_r8,0.32824e-05_r8,0.84943e-07_r8 /)
      kao(:, 2, 7, 1) = (/ &
        & 0.11096e-07_r8,0.17874e-05_r8,0.25861e-05_r8,0.31100e-05_r8,0.35425e-05_r8, &
        & 0.38737e-05_r8,0.40468e-05_r8,0.38933e-05_r8,0.94734e-07_r8 /)
      kao(:, 3, 7, 1) = (/ &
        & 0.10405e-07_r8,0.19286e-05_r8,0.28166e-05_r8,0.34417e-05_r8,0.39786e-05_r8, &
        & 0.43804e-05_r8,0.46759e-05_r8,0.45835e-05_r8,0.10531e-06_r8 /)
      kao(:, 4, 7, 1) = (/ &
        & 0.97948e-08_r8,0.20680e-05_r8,0.30741e-05_r8,0.37803e-05_r8,0.44163e-05_r8, &
        & 0.49420e-05_r8,0.52477e-05_r8,0.52509e-05_r8,0.11517e-06_r8 /)
      kao(:, 5, 7, 1) = (/ &
        & 0.92522e-08_r8,0.22140e-05_r8,0.33558e-05_r8,0.41544e-05_r8,0.48719e-05_r8, &
        & 0.54968e-05_r8,0.59225e-05_r8,0.59027e-05_r8,0.12618e-06_r8 /)
      kao(:, 1, 8, 1) = (/ &
        & 0.10164e-07_r8,0.13056e-05_r8,0.18690e-05_r8,0.21940e-05_r8,0.24210e-05_r8, &
        & 0.25504e-05_r8,0.25676e-05_r8,0.24444e-05_r8,0.66021e-07_r8 /)
      kao(:, 2, 8, 1) = (/ &
        & 0.94612e-08_r8,0.14106e-05_r8,0.20398e-05_r8,0.24136e-05_r8,0.27424e-05_r8, &
        & 0.29578e-05_r8,0.30446e-05_r8,0.29182e-05_r8,0.73985e-07_r8 /)
      kao(:, 3, 8, 1) = (/ &
        & 0.88489e-08_r8,0.15256e-05_r8,0.22123e-05_r8,0.26894e-05_r8,0.30704e-05_r8, &
        & 0.33808e-05_r8,0.35521e-05_r8,0.34526e-05_r8,0.82666e-07_r8 /)
      kao(:, 4, 8, 1) = (/ &
        & 0.83111e-08_r8,0.16396e-05_r8,0.24159e-05_r8,0.29563e-05_r8,0.34504e-05_r8, &
        & 0.38196e-05_r8,0.40425e-05_r8,0.40093e-05_r8,0.90940e-07_r8 /)
      kao(:, 5, 8, 1) = (/ &
        & 0.78349e-08_r8,0.17570e-05_r8,0.26398e-05_r8,0.32547e-05_r8,0.38060e-05_r8, &
        & 0.42813e-05_r8,0.45732e-05_r8,0.45465e-05_r8,0.10022e-06_r8 /)
      kao(:, 1, 9, 1) = (/ &
        & 0.86983e-08_r8,0.10284e-05_r8,0.14734e-05_r8,0.16973e-05_r8,0.18551e-05_r8, &
        & 0.19223e-05_r8,0.19222e-05_r8,0.18289e-05_r8,0.53460e-07_r8 /)
      kao(:, 2, 9, 1) = (/ &
        & 0.80712e-08_r8,0.11141e-05_r8,0.16016e-05_r8,0.18902e-05_r8,0.21027e-05_r8, &
        & 0.22504e-05_r8,0.22800e-05_r8,0.21749e-05_r8,0.60180e-07_r8 /)
      kao(:, 3, 9, 1) = (/ &
        & 0.75284e-08_r8,0.12033e-05_r8,0.17376e-05_r8,0.20849e-05_r8,0.23719e-05_r8, &
        & 0.25906e-05_r8,0.26977e-05_r8,0.25910e-05_r8,0.66886e-07_r8 /)
      kao(:, 4, 9, 1) = (/ &
        & 0.70541e-08_r8,0.12979e-05_r8,0.18959e-05_r8,0.23090e-05_r8,0.26695e-05_r8, &
        & 0.29367e-05_r8,0.31239e-05_r8,0.30574e-05_r8,0.73978e-07_r8 /)
      kao(:, 5, 9, 1) = (/ &
        & 0.66359e-08_r8,0.13937e-05_r8,0.20720e-05_r8,0.25448e-05_r8,0.29680e-05_r8, &
        & 0.33208e-05_r8,0.35191e-05_r8,0.35097e-05_r8,0.81724e-07_r8 /)
      kao(:, 1,10, 1) = (/ &
        & 0.74006e-08_r8,0.81705e-06_r8,0.11610e-05_r8,0.13325e-05_r8,0.14305e-05_r8, &
        & 0.14668e-05_r8,0.14642e-05_r8,0.13765e-05_r8,0.44724e-07_r8 /)
      kao(:, 2,10, 1) = (/ &
        & 0.68477e-08_r8,0.88306e-06_r8,0.12640e-05_r8,0.14768e-05_r8,0.16329e-05_r8, &
        & 0.17209e-05_r8,0.17306e-05_r8,0.16441e-05_r8,0.50688e-07_r8 /)
      kao(:, 3,10, 1) = (/ &
        & 0.63717e-08_r8,0.95522e-06_r8,0.13783e-05_r8,0.16303e-05_r8,0.18546e-05_r8, &
        & 0.19963e-05_r8,0.20570e-05_r8,0.19678e-05_r8,0.56052e-07_r8 /)
      kao(:, 4,10, 1) = (/ &
        & 0.59576e-08_r8,0.10331e-05_r8,0.14975e-05_r8,0.18180e-05_r8,0.20770e-05_r8, &
        & 0.22813e-05_r8,0.24021e-05_r8,0.23350e-05_r8,0.62412e-07_r8 /)
      kao(:, 5,10, 1) = (/ &
        & 0.55940e-08_r8,0.11102e-05_r8,0.16370e-05_r8,0.19999e-05_r8,0.23349e-05_r8, &
        & 0.25900e-05_r8,0.27328e-05_r8,0.27057e-05_r8,0.69466e-07_r8 /)
      kao(:, 1,11, 1) = (/ &
        & 0.60617e-08_r8,0.67167e-06_r8,0.95594e-06_r8,0.10939e-05_r8,0.11767e-05_r8, &
        & 0.12059e-05_r8,0.12032e-05_r8,0.11314e-05_r8,0.37093e-07_r8 /)
      kao(:, 2,11, 1) = (/ &
        & 0.56087e-08_r8,0.72704e-06_r8,0.10406e-05_r8,0.12137e-05_r8,0.13434e-05_r8, &
        & 0.14171e-05_r8,0.14246e-05_r8,0.13521e-05_r8,0.41918e-07_r8 /)
      kao(:, 3,11, 1) = (/ &
        & 0.52187e-08_r8,0.78681e-06_r8,0.11338e-05_r8,0.13419e-05_r8,0.15254e-05_r8, &
        & 0.16426e-05_r8,0.16950e-05_r8,0.16203e-05_r8,0.46339e-07_r8 /)
      kao(:, 4,11, 1) = (/ &
        & 0.48793e-08_r8,0.85013e-06_r8,0.12327e-05_r8,0.14971e-05_r8,0.17109e-05_r8, &
        & 0.18776e-05_r8,0.19784e-05_r8,0.19240e-05_r8,0.51725e-07_r8 /)
      kao(:, 5,11, 1) = (/ &
        & 0.45815e-08_r8,0.91420e-06_r8,0.13427e-05_r8,0.16458e-05_r8,0.19221e-05_r8, &
        & 0.21323e-05_r8,0.22490e-05_r8,0.22263e-05_r8,0.57555e-07_r8 /)
      kao(:, 1,12, 1) = (/ &
        & 0.49629e-08_r8,0.55223e-06_r8,0.78677e-06_r8,0.89789e-06_r8,0.96778e-06_r8, &
        & 0.99148e-06_r8,0.98883e-06_r8,0.93028e-06_r8,0.30610e-07_r8 /)
      kao(:, 2,12, 1) = (/ &
        & 0.45920e-08_r8,0.59832e-06_r8,0.85632e-06_r8,0.99730e-06_r8,0.11052e-05_r8, &
        & 0.11665e-05_r8,0.11729e-05_r8,0.11125e-05_r8,0.34553e-07_r8 /)
      kao(:, 3,12, 1) = (/ &
        & 0.42727e-08_r8,0.64760e-06_r8,0.93315e-06_r8,0.11041e-05_r8,0.12552e-05_r8, &
        & 0.13521e-05_r8,0.13956e-05_r8,0.13333e-05_r8,0.38176e-07_r8 /)
      kao(:, 4,12, 1) = (/ &
        & 0.39949e-08_r8,0.69926e-06_r8,0.10110e-05_r8,0.12304e-05_r8,0.14083e-05_r8, &
        & 0.15442e-05_r8,0.16283e-05_r8,0.15837e-05_r8,0.42648e-07_r8 /)
      kao(:, 5,12, 1) = (/ &
        & 0.37510e-08_r8,0.75239e-06_r8,0.11006e-05_r8,0.13535e-05_r8,0.15785e-05_r8, &
        & 0.17547e-05_r8,0.18501e-05_r8,0.18298e-05_r8,0.47452e-07_r8 /)
      kao(:, 1,13, 1) = (/ &
        & 0.40633e-08_r8,0.45378e-06_r8,0.64719e-06_r8,0.73637e-06_r8,0.79571e-06_r8, &
        & 0.81503e-06_r8,0.81264e-06_r8,0.76488e-06_r8,0.25080e-07_r8 /)
      kao(:, 2,13, 1) = (/ &
        & 0.37596e-08_r8,0.49208e-06_r8,0.70430e-06_r8,0.81894e-06_r8,0.90856e-06_r8, &
        & 0.95919e-06_r8,0.96435e-06_r8,0.91411e-06_r8,0.28293e-07_r8 /)
      kao(:, 3,13, 1) = (/ &
        & 0.34982e-08_r8,0.53259e-06_r8,0.76370e-06_r8,0.90761e-06_r8,0.10316e-05_r8, &
        & 0.11116e-05_r8,0.11472e-05_r8,0.10956e-05_r8,0.31267e-07_r8 /)
      kao(:, 4,13, 1) = (/ &
        & 0.32707e-08_r8,0.57488e-06_r8,0.82833e-06_r8,0.10096e-05_r8,0.11577e-05_r8, &
        & 0.12688e-05_r8,0.13388e-05_r8,0.13015e-05_r8,0.34930e-07_r8 /)
      kao(:, 5,13, 1) = (/ &
        & 0.30710e-08_r8,0.61832e-06_r8,0.90250e-06_r8,0.11120e-05_r8,0.12962e-05_r8, &
        & 0.14424e-05_r8,0.15206e-05_r8,0.15032e-05_r8,0.38861e-07_r8 /)
      kao(:, 1, 1, 2) = (/ &
        & 0.14215e-06_r8,0.65726e-04_r8,0.11327e-03_r8,0.15324e-03_r8,0.18473e-03_r8, &
        & 0.20658e-03_r8,0.21603e-03_r8,0.20617e-03_r8,0.13252e-04_r8 /)
      kao(:, 2, 1, 2) = (/ &
        & 0.13452e-06_r8,0.69521e-04_r8,0.12059e-03_r8,0.16342e-03_r8,0.19613e-03_r8, &
        & 0.21987e-03_r8,0.22946e-03_r8,0.21879e-03_r8,0.14816e-04_r8 /)
      kao(:, 3, 1, 2) = (/ &
        & 0.12766e-06_r8,0.73313e-04_r8,0.12786e-03_r8,0.17303e-03_r8,0.20754e-03_r8, &
        & 0.23326e-03_r8,0.24324e-03_r8,0.22956e-03_r8,0.16536e-04_r8 /)
      kao(:, 4, 1, 2) = (/ &
        & 0.12147e-06_r8,0.77087e-04_r8,0.13521e-03_r8,0.18263e-03_r8,0.21904e-03_r8, &
        & 0.24614e-03_r8,0.25637e-03_r8,0.24060e-03_r8,0.18092e-04_r8 /)
      kao(:, 5, 1, 2) = (/ &
        & 0.11584e-06_r8,0.80946e-04_r8,0.14233e-03_r8,0.19230e-03_r8,0.23047e-03_r8, &
        & 0.25869e-03_r8,0.26904e-03_r8,0.25139e-03_r8,0.19768e-04_r8 /)
      kao(:, 1, 2, 2) = (/ &
        & 0.11918e-06_r8,0.55167e-04_r8,0.94557e-04_r8,0.12760e-03_r8,0.15322e-03_r8, &
        & 0.17148e-03_r8,0.17894e-03_r8,0.17049e-03_r8,0.10710e-04_r8 /)
      kao(:, 2, 2, 2) = (/ &
        & 0.11264e-06_r8,0.58581e-04_r8,0.10113e-03_r8,0.13648e-03_r8,0.16335e-03_r8, &
        & 0.18288e-03_r8,0.19059e-03_r8,0.18131e-03_r8,0.12067e-04_r8 /)
      kao(:, 3, 2, 2) = (/ &
        & 0.10678e-06_r8,0.61935e-04_r8,0.10756e-03_r8,0.14497e-03_r8,0.17335e-03_r8, &
        & 0.19437e-03_r8,0.20245e-03_r8,0.19070e-03_r8,0.13553e-04_r8 /)
      kao(:, 4, 2, 2) = (/ &
        & 0.10149e-06_r8,0.65261e-04_r8,0.11404e-03_r8,0.15331e-03_r8,0.18323e-03_r8, &
        & 0.20559e-03_r8,0.21385e-03_r8,0.20024e-03_r8,0.14801e-04_r8 /)
      kao(:, 5, 2, 2) = (/ &
        & 0.96699e-07_r8,0.68698e-04_r8,0.12038e-03_r8,0.16167e-03_r8,0.19308e-03_r8, &
        & 0.21635e-03_r8,0.22479e-03_r8,0.20964e-03_r8,0.16245e-04_r8 /)
      kao(:, 1, 3, 2) = (/ &
        & 0.10112e-06_r8,0.45399e-04_r8,0.77226e-04_r8,0.10397e-03_r8,0.12462e-03_r8, &
        & 0.13956e-03_r8,0.14531e-03_r8,0.13816e-03_r8,0.83635e-05_r8 /)
      kao(:, 2, 3, 2) = (/ &
        & 0.95381e-07_r8,0.48357e-04_r8,0.82986e-04_r8,0.11173e-03_r8,0.13338e-03_r8, &
        & 0.14898e-03_r8,0.15534e-03_r8,0.14786e-03_r8,0.94915e-05_r8 /)
      kao(:, 3, 3, 2) = (/ &
        & 0.90257e-07_r8,0.51355e-04_r8,0.88727e-04_r8,0.11920e-03_r8,0.14215e-03_r8, &
        & 0.15859e-03_r8,0.16541e-03_r8,0.15622e-03_r8,0.10683e-04_r8 /)
      kao(:, 4, 3, 2) = (/ &
        & 0.85653e-07_r8,0.54322e-04_r8,0.94369e-04_r8,0.12646e-03_r8,0.15072e-03_r8, &
        & 0.16838e-03_r8,0.17536e-03_r8,0.16433e-03_r8,0.11764e-04_r8 /)
      kao(:, 5, 3, 2) = (/ &
        & 0.81492e-07_r8,0.57300e-04_r8,0.99940e-04_r8,0.13355e-03_r8,0.15929e-03_r8, &
        & 0.17800e-03_r8,0.18496e-03_r8,0.17234e-03_r8,0.12979e-04_r8 /)
      kao(:, 1, 4, 2) = (/ &
        & 0.86132e-07_r8,0.36910e-04_r8,0.62346e-04_r8,0.83628e-04_r8,0.10025e-03_r8, &
        & 0.11224e-03_r8,0.11706e-03_r8,0.11109e-03_r8,0.64715e-05_r8 /)
      kao(:, 2, 4, 2) = (/ &
        & 0.81062e-07_r8,0.39490e-04_r8,0.67274e-04_r8,0.90384e-04_r8,0.10785e-03_r8, &
        & 0.12026e-03_r8,0.12543e-03_r8,0.11944e-03_r8,0.73991e-05_r8 /)
      kao(:, 3, 4, 2) = (/ &
        & 0.76553e-07_r8,0.42055e-04_r8,0.72269e-04_r8,0.96956e-04_r8,0.11528e-03_r8, &
        & 0.12833e-03_r8,0.13396e-03_r8,0.12697e-03_r8,0.83899e-05_r8 /)
      kao(:, 4, 4, 2) = (/ &
        & 0.72516e-07_r8,0.44696e-04_r8,0.77235e-04_r8,0.10321e-03_r8,0.12276e-03_r8, &
        & 0.13674e-03_r8,0.14260e-03_r8,0.13384e-03_r8,0.93052e-05_r8 /)
      kao(:, 5, 4, 2) = (/ &
        & 0.68881e-07_r8,0.47273e-04_r8,0.82118e-04_r8,0.10935e-03_r8,0.13016e-03_r8, &
        & 0.14506e-03_r8,0.15080e-03_r8,0.14062e-03_r8,0.10314e-04_r8 /)
      kao(:, 1, 5, 2) = (/ &
        & 0.73401e-07_r8,0.29772e-04_r8,0.49957e-04_r8,0.66720e-04_r8,0.80104e-04_r8, &
        & 0.89761e-04_r8,0.93853e-04_r8,0.88953e-04_r8,0.50171e-05_r8 /)
      kao(:, 2, 5, 2) = (/ &
        & 0.68916e-07_r8,0.31976e-04_r8,0.54217e-04_r8,0.72570e-04_r8,0.86671e-04_r8, &
        & 0.96653e-04_r8,0.10073e-03_r8,0.95875e-04_r8,0.57746e-05_r8 /)
      kao(:, 3, 5, 2) = (/ &
        & 0.64945e-07_r8,0.34219e-04_r8,0.58417e-04_r8,0.78327e-04_r8,0.92950e-04_r8, &
        & 0.10358e-03_r8,0.10803e-03_r8,0.10274e-03_r8,0.66197e-05_r8 /)
      kao(:, 4, 5, 2) = (/ &
        & 0.61405e-07_r8,0.36457e-04_r8,0.62694e-04_r8,0.83756e-04_r8,0.99356e-04_r8, &
        & 0.11058e-03_r8,0.11542e-03_r8,0.10858e-03_r8,0.73729e-05_r8 /)
      kao(:, 5, 5, 2) = (/ &
        & 0.58229e-07_r8,0.38713e-04_r8,0.67059e-04_r8,0.89033e-04_r8,0.10573e-03_r8, &
        & 0.11764e-03_r8,0.12243e-03_r8,0.11440e-03_r8,0.82149e-05_r8 /)
      kao(:, 1, 6, 2) = (/ &
        & 0.62723e-07_r8,0.23750e-04_r8,0.39643e-04_r8,0.52796e-04_r8,0.63478e-04_r8, &
        & 0.71151e-04_r8,0.74640e-04_r8,0.70193e-04_r8,0.38899e-05_r8 /)
      kao(:, 2, 6, 2) = (/ &
        & 0.58735e-07_r8,0.25657e-04_r8,0.43274e-04_r8,0.57719e-04_r8,0.69124e-04_r8, &
        & 0.77375e-04_r8,0.80498e-04_r8,0.76543e-04_r8,0.44833e-05_r8 /)
      kao(:, 3, 6, 2) = (/ &
        & 0.55222e-07_r8,0.27563e-04_r8,0.46866e-04_r8,0.62699e-04_r8,0.74494e-04_r8, &
        & 0.82946e-04_r8,0.86653e-04_r8,0.82509e-04_r8,0.51635e-05_r8 /)
      kao(:, 4, 6, 2) = (/ &
        & 0.52103e-07_r8,0.29528e-04_r8,0.50470e-04_r8,0.67473e-04_r8,0.79899e-04_r8, &
        & 0.89004e-04_r8,0.92786e-04_r8,0.87628e-04_r8,0.58104e-05_r8 /)
      kao(:, 5, 6, 2) = (/ &
        & 0.49317e-07_r8,0.31444e-04_r8,0.54175e-04_r8,0.72000e-04_r8,0.85322e-04_r8, &
        & 0.94885e-04_r8,0.98826e-04_r8,0.92648e-04_r8,0.64997e-05_r8 /)
      kao(:, 1, 7, 2) = (/ &
        & 0.53634e-07_r8,0.18862e-04_r8,0.31325e-04_r8,0.41575e-04_r8,0.50141e-04_r8, &
        & 0.56190e-04_r8,0.58882e-04_r8,0.55026e-04_r8,0.29795e-05_r8 /)
      kao(:, 2, 7, 2) = (/ &
        & 0.50084e-07_r8,0.20474e-04_r8,0.34342e-04_r8,0.45732e-04_r8,0.54884e-04_r8, &
        & 0.61494e-04_r8,0.64187e-04_r8,0.60857e-04_r8,0.34589e-05_r8 /)
      kao(:, 3, 7, 2) = (/ &
        & 0.46973e-07_r8,0.22063e-04_r8,0.37411e-04_r8,0.49893e-04_r8,0.59475e-04_r8, &
        & 0.66279e-04_r8,0.69129e-04_r8,0.65758e-04_r8,0.39983e-05_r8 /)
      kao(:, 4, 7, 2) = (/ &
        & 0.44224e-07_r8,0.23764e-04_r8,0.40481e-04_r8,0.54107e-04_r8,0.64026e-04_r8, &
        & 0.71350e-04_r8,0.74328e-04_r8,0.70513e-04_r8,0.45526e-05_r8 /)
      kao(:, 5, 7, 2) = (/ &
        & 0.41777e-07_r8,0.25434e-04_r8,0.43555e-04_r8,0.57958e-04_r8,0.68599e-04_r8, &
        & 0.76304e-04_r8,0.79456e-04_r8,0.74649e-04_r8,0.51046e-05_r8 /)
      kao(:, 1, 8, 2) = (/ &
        & 0.45857e-07_r8,0.14945e-04_r8,0.24594e-04_r8,0.32696e-04_r8,0.39571e-04_r8, &
        & 0.44348e-04_r8,0.46090e-04_r8,0.43034e-04_r8,0.22833e-05_r8 /)
      kao(:, 2, 8, 2) = (/ &
        & 0.42697e-07_r8,0.16265e-04_r8,0.27198e-04_r8,0.36108e-04_r8,0.43381e-04_r8, &
        & 0.48642e-04_r8,0.50943e-04_r8,0.47848e-04_r8,0.26669e-05_r8 /)
      kao(:, 3, 8, 2) = (/ &
        & 0.39944e-07_r8,0.17616e-04_r8,0.29775e-04_r8,0.39577e-04_r8,0.47366e-04_r8, &
        & 0.52791e-04_r8,0.54992e-04_r8,0.52236e-04_r8,0.30932e-05_r8 /)
      kao(:, 4, 8, 2) = (/ &
        & 0.37522e-07_r8,0.19042e-04_r8,0.32351e-04_r8,0.43126e-04_r8,0.51153e-04_r8, &
        & 0.56987e-04_r8,0.59316e-04_r8,0.56438e-04_r8,0.35666e-05_r8 /)
      kao(:, 5, 8, 2) = (/ &
        & 0.35376e-07_r8,0.20476e-04_r8,0.34946e-04_r8,0.46521e-04_r8,0.55009e-04_r8, &
        & 0.61221e-04_r8,0.63714e-04_r8,0.60035e-04_r8,0.40037e-05_r8 /)
      kao(:, 1, 9, 2) = (/ &
        & 0.39233e-07_r8,0.11817e-04_r8,0.19254e-04_r8,0.25596e-04_r8,0.30843e-04_r8, &
        & 0.34574e-04_r8,0.36035e-04_r8,0.33425e-04_r8,0.17673e-05_r8 /)
      kao(:, 2, 9, 2) = (/ &
        & 0.36418e-07_r8,0.12914e-04_r8,0.21404e-04_r8,0.28372e-04_r8,0.34161e-04_r8, &
        & 0.38321e-04_r8,0.40053e-04_r8,0.37435e-04_r8,0.20751e-05_r8 /)
      kao(:, 3, 9, 2) = (/ &
        & 0.33979e-07_r8,0.14026e-04_r8,0.23574e-04_r8,0.31316e-04_r8,0.37514e-04_r8, &
        & 0.41977e-04_r8,0.43747e-04_r8,0.41346e-04_r8,0.24151e-05_r8 /)
      kao(:, 4, 9, 2) = (/ &
        & 0.31844e-07_r8,0.15205e-04_r8,0.25770e-04_r8,0.34231e-04_r8,0.40723e-04_r8, &
        & 0.45315e-04_r8,0.47202e-04_r8,0.44869e-04_r8,0.28151e-05_r8 /)
      kao(:, 5, 9, 2) = (/ &
        & 0.29961e-07_r8,0.16420e-04_r8,0.27955e-04_r8,0.37187e-04_r8,0.43941e-04_r8, &
        & 0.48873e-04_r8,0.50856e-04_r8,0.48170e-04_r8,0.31733e-05_r8 /)
      kao(:, 1,10, 2) = (/ &
        & 0.33373e-07_r8,0.93505e-05_r8,0.15216e-04_r8,0.20198e-04_r8,0.24244e-04_r8, &
        & 0.27077e-04_r8,0.28186e-04_r8,0.25996e-04_r8,0.13941e-05_r8 /)
      kao(:, 2,10, 2) = (/ &
        & 0.30893e-07_r8,0.10284e-04_r8,0.16902e-04_r8,0.22468e-04_r8,0.27072e-04_r8, &
        & 0.30382e-04_r8,0.31603e-04_r8,0.29456e-04_r8,0.16352e-05_r8 /)
      kao(:, 3,10, 2) = (/ &
        & 0.28754e-07_r8,0.11207e-04_r8,0.18715e-04_r8,0.24849e-04_r8,0.29815e-04_r8, &
        & 0.33379e-04_r8,0.34901e-04_r8,0.32836e-04_r8,0.19188e-05_r8 /)
      kao(:, 4,10, 2) = (/ &
        & 0.26892e-07_r8,0.12172e-04_r8,0.20578e-04_r8,0.27269e-04_r8,0.32536e-04_r8, &
        & 0.36182e-04_r8,0.37703e-04_r8,0.35750e-04_r8,0.22467e-05_r8 /)
      kao(:, 5,10, 2) = (/ &
        & 0.25255e-07_r8,0.13195e-04_r8,0.22422e-04_r8,0.29781e-04_r8,0.35220e-04_r8, &
        & 0.39157e-04_r8,0.40719e-04_r8,0.38729e-04_r8,0.25535e-05_r8 /)
      kao(:, 1,11, 2) = (/ &
        & 0.27335e-07_r8,0.77491e-05_r8,0.12607e-04_r8,0.16695e-04_r8,0.20093e-04_r8, &
        & 0.22431e-04_r8,0.23345e-04_r8,0.21522e-04_r8,0.11569e-05_r8 /)
      kao(:, 2,11, 2) = (/ &
        & 0.25303e-07_r8,0.85322e-05_r8,0.14022e-04_r8,0.18593e-04_r8,0.22378e-04_r8, &
        & 0.25133e-04_r8,0.26161e-04_r8,0.24379e-04_r8,0.13709e-05_r8 /)
      kao(:, 3,11, 2) = (/ &
        & 0.23551e-07_r8,0.92912e-05_r8,0.15536e-04_r8,0.20618e-04_r8,0.24722e-04_r8, &
        & 0.27647e-04_r8,0.28874e-04_r8,0.27196e-04_r8,0.16099e-05_r8 /)
      kao(:, 4,11, 2) = (/ &
        & 0.22025e-07_r8,0.10117e-04_r8,0.17115e-04_r8,0.22645e-04_r8,0.26974e-04_r8, &
        & 0.29947e-04_r8,0.31210e-04_r8,0.29581e-04_r8,0.18845e-05_r8 /)
      kao(:, 5,11, 2) = (/ &
        & 0.20684e-07_r8,0.10977e-04_r8,0.18645e-04_r8,0.24734e-04_r8,0.29203e-04_r8, &
        & 0.32453e-04_r8,0.33733e-04_r8,0.32056e-04_r8,0.21326e-05_r8 /)
      kao(:, 1,12, 2) = (/ &
        & 0.22380e-07_r8,0.64144e-05_r8,0.10436e-04_r8,0.13802e-04_r8,0.16622e-04_r8, &
        & 0.18557e-04_r8,0.19314e-04_r8,0.17793e-04_r8,0.95906e-06_r8 /)
      kao(:, 2,12, 2) = (/ &
        & 0.20716e-07_r8,0.70603e-05_r8,0.11625e-04_r8,0.15385e-04_r8,0.18503e-04_r8, &
        & 0.20776e-04_r8,0.21630e-04_r8,0.20152e-04_r8,0.11363e-05_r8 /)
      kao(:, 3,12, 2) = (/ &
        & 0.19282e-07_r8,0.76960e-05_r8,0.12886e-04_r8,0.17087e-04_r8,0.20475e-04_r8, &
        & 0.22867e-04_r8,0.23856e-04_r8,0.22506e-04_r8,0.13400e-05_r8 /)
      kao(:, 4,12, 2) = (/ &
        & 0.18032e-07_r8,0.83983e-05_r8,0.14206e-04_r8,0.18783e-04_r8,0.22334e-04_r8, &
        & 0.24764e-04_r8,0.25815e-04_r8,0.24461e-04_r8,0.15637e-05_r8 /)
      kao(:, 5,12, 2) = (/ &
        & 0.16934e-07_r8,0.91186e-05_r8,0.15491e-04_r8,0.20513e-04_r8,0.24201e-04_r8, &
        & 0.26864e-04_r8,0.27917e-04_r8,0.26491e-04_r8,0.17707e-05_r8 /)
      kao(:, 1,13, 2) = (/ &
        & 0.18323e-07_r8,0.53022e-05_r8,0.86273e-05_r8,0.11385e-04_r8,0.13729e-04_r8, &
        & 0.15318e-04_r8,0.15952e-04_r8,0.14693e-04_r8,0.78927e-06_r8 /)
      kao(:, 2,13, 2) = (/ &
        & 0.16961e-07_r8,0.58316e-05_r8,0.96204e-05_r8,0.12717e-04_r8,0.15275e-04_r8, &
        & 0.17141e-04_r8,0.17863e-04_r8,0.16639e-04_r8,0.93659e-06_r8 /)
      kao(:, 3,13, 2) = (/ &
        & 0.15787e-07_r8,0.63710e-05_r8,0.10675e-04_r8,0.14140e-04_r8,0.16925e-04_r8, &
        & 0.18881e-04_r8,0.19675e-04_r8,0.18564e-04_r8,0.11050e-05_r8 /)
      kao(:, 4,13, 2) = (/ &
        & 0.14764e-07_r8,0.69607e-05_r8,0.11779e-04_r8,0.15554e-04_r8,0.18475e-04_r8, &
        & 0.20461e-04_r8,0.21320e-04_r8,0.20207e-04_r8,0.12868e-05_r8 /)
      kao(:, 5,13, 2) = (/ &
        & 0.13865e-07_r8,0.75611e-05_r8,0.12843e-04_r8,0.16991e-04_r8,0.20029e-04_r8, &
        & 0.22208e-04_r8,0.23079e-04_r8,0.21838e-04_r8,0.14565e-05_r8 /)
      kao(:, 1, 1, 3) = (/ &
        & 0.55948e-06_r8,0.43472e-03_r8,0.65689e-03_r8,0.80237e-03_r8,0.90326e-03_r8, &
        & 0.95995e-03_r8,0.94242e-03_r8,0.81801e-03_r8,0.18380e-03_r8 /)
      kao(:, 2, 1, 3) = (/ &
        & 0.53175e-06_r8,0.45395e-03_r8,0.68779e-03_r8,0.84040e-03_r8,0.94598e-03_r8, &
        & 0.10011e-02_r8,0.98481e-03_r8,0.85748e-03_r8,0.19567e-03_r8 /)
      kao(:, 3, 1, 3) = (/ &
        & 0.50648e-06_r8,0.46835e-03_r8,0.71403e-03_r8,0.87684e-03_r8,0.98520e-03_r8, &
        & 0.10393e-02_r8,0.10233e-02_r8,0.89729e-03_r8,0.20725e-03_r8 /)
      kao(:, 4, 1, 3) = (/ &
        & 0.48330e-06_r8,0.48143e-03_r8,0.73979e-03_r8,0.91063e-03_r8,0.10212e-02_r8, &
        & 0.10762e-02_r8,0.10600e-02_r8,0.93507e-03_r8,0.21814e-03_r8 /)
      kao(:, 5, 1, 3) = (/ &
        & 0.46195e-06_r8,0.49413e-03_r8,0.76470e-03_r8,0.94208e-03_r8,0.10547e-02_r8, &
        & 0.11099e-02_r8,0.10960e-02_r8,0.97164e-03_r8,0.23056e-03_r8 /)
      kao(:, 1, 2, 3) = (/ &
        & 0.46813e-06_r8,0.36711e-03_r8,0.55743e-03_r8,0.68070e-03_r8,0.76614e-03_r8, &
        & 0.81442e-03_r8,0.79940e-03_r8,0.69691e-03_r8,0.14988e-03_r8 /)
      kao(:, 2, 2, 3) = (/ &
        & 0.44450e-06_r8,0.38413e-03_r8,0.58502e-03_r8,0.71506e-03_r8,0.80409e-03_r8, &
        & 0.85191e-03_r8,0.83722e-03_r8,0.73231e-03_r8,0.15985e-03_r8 /)
      kao(:, 3, 2, 3) = (/ &
        & 0.42301e-06_r8,0.39744e-03_r8,0.60852e-03_r8,0.74741e-03_r8,0.83920e-03_r8, &
        & 0.88588e-03_r8,0.87206e-03_r8,0.76677e-03_r8,0.16968e-03_r8 /)
      kao(:, 4, 2, 3) = (/ &
        & 0.40335e-06_r8,0.40927e-03_r8,0.63200e-03_r8,0.77835e-03_r8,0.87190e-03_r8, &
        & 0.91843e-03_r8,0.90467e-03_r8,0.79859e-03_r8,0.17948e-03_r8 /)
      kao(:, 5, 2, 3) = (/ &
        & 0.38529e-06_r8,0.42034e-03_r8,0.65353e-03_r8,0.80758e-03_r8,0.90248e-03_r8, &
        & 0.94929e-03_r8,0.93715e-03_r8,0.83136e-03_r8,0.19018e-03_r8 /)
      kao(:, 1, 3, 3) = (/ &
        & 0.39591e-06_r8,0.30459e-03_r8,0.46364e-03_r8,0.56590e-03_r8,0.63680e-03_r8, &
        & 0.67681e-03_r8,0.66517e-03_r8,0.58106e-03_r8,0.11936e-03_r8 /)
      kao(:, 2, 3, 3) = (/ &
        & 0.37538e-06_r8,0.32036e-03_r8,0.48874e-03_r8,0.59649e-03_r8,0.67170e-03_r8, &
        & 0.71161e-03_r8,0.69943e-03_r8,0.61159e-03_r8,0.12804e-03_r8 /)
      kao(:, 3, 3, 3) = (/ &
        & 0.35675e-06_r8,0.33321e-03_r8,0.50999e-03_r8,0.62591e-03_r8,0.70319e-03_r8, &
        & 0.74333e-03_r8,0.73015e-03_r8,0.64070e-03_r8,0.13642e-03_r8 /)
      kao(:, 4, 3, 3) = (/ &
        & 0.33978e-06_r8,0.34382e-03_r8,0.53102e-03_r8,0.65391e-03_r8,0.73278e-03_r8, &
        & 0.77303e-03_r8,0.75990e-03_r8,0.66979e-03_r8,0.14477e-03_r8 /)
      kao(:, 5, 3, 3) = (/ &
        & 0.32422e-06_r8,0.35416e-03_r8,0.55071e-03_r8,0.68042e-03_r8,0.76041e-03_r8, &
        & 0.80118e-03_r8,0.78914e-03_r8,0.69923e-03_r8,0.15365e-03_r8 /)
      kao(:, 1, 4, 3) = (/ &
        & 0.33598e-06_r8,0.24970e-03_r8,0.38053e-03_r8,0.46464e-03_r8,0.52234e-03_r8, &
        & 0.55488e-03_r8,0.54675e-03_r8,0.47794e-03_r8,0.95275e-04_r8 /)
      kao(:, 2, 4, 3) = (/ &
        & 0.31800e-06_r8,0.26415e-03_r8,0.40313e-03_r8,0.49210e-03_r8,0.55359e-03_r8, &
        & 0.58661e-03_r8,0.57694e-03_r8,0.50393e-03_r8,0.10292e-03_r8 /)
      kao(:, 3, 4, 3) = (/ &
        & 0.30177e-06_r8,0.27638e-03_r8,0.42268e-03_r8,0.51823e-03_r8,0.58348e-03_r8, &
        & 0.61591e-03_r8,0.60497e-03_r8,0.52947e-03_r8,0.11016e-03_r8 /)
      kao(:, 4, 4, 3) = (/ &
        & 0.28703e-06_r8,0.28612e-03_r8,0.44165e-03_r8,0.54326e-03_r8,0.61010e-03_r8, &
        & 0.64299e-03_r8,0.63151e-03_r8,0.55558e-03_r8,0.11708e-03_r8 /)
      kao(:, 5, 4, 3) = (/ &
        & 0.27356e-06_r8,0.29550e-03_r8,0.45903e-03_r8,0.56703e-03_r8,0.63522e-03_r8, &
        & 0.66839e-03_r8,0.65812e-03_r8,0.58142e-03_r8,0.12444e-03_r8 /)
      kao(:, 1, 5, 3) = (/ &
        & 0.28517e-06_r8,0.20305e-03_r8,0.30940e-03_r8,0.37854e-03_r8,0.42516e-03_r8, &
        & 0.45167e-03_r8,0.44617e-03_r8,0.39006e-03_r8,0.76394e-04_r8 /)
      kao(:, 2, 5, 3) = (/ &
        & 0.26943e-06_r8,0.21631e-03_r8,0.32942e-03_r8,0.40279e-03_r8,0.45281e-03_r8, &
        & 0.47959e-03_r8,0.47274e-03_r8,0.41219e-03_r8,0.83093e-04_r8 /)
      kao(:, 3, 5, 3) = (/ &
        & 0.25526e-06_r8,0.22760e-03_r8,0.34736e-03_r8,0.42603e-03_r8,0.47928e-03_r8, &
        & 0.50573e-03_r8,0.49753e-03_r8,0.43423e-03_r8,0.89137e-04_r8 /)
      kao(:, 4, 5, 3) = (/ &
        & 0.24245e-06_r8,0.23661e-03_r8,0.36423e-03_r8,0.44832e-03_r8,0.50373e-03_r8, &
        & 0.53021e-03_r8,0.52092e-03_r8,0.45715e-03_r8,0.95026e-04_r8 /)
      kao(:, 5, 5, 3) = (/ &
        & 0.23079e-06_r8,0.24490e-03_r8,0.37979e-03_r8,0.46958e-03_r8,0.52671e-03_r8, &
        & 0.55360e-03_r8,0.54422e-03_r8,0.47982e-03_r8,0.10100e-03_r8 /)
      kao(:, 1, 6, 3) = (/ &
        & 0.24258e-06_r8,0.16374e-03_r8,0.24889e-03_r8,0.30526e-03_r8,0.34256e-03_r8, &
        & 0.36437e-03_r8,0.36054e-03_r8,0.31643e-03_r8,0.60983e-04_r8 /)
      kao(:, 2, 6, 3) = (/ &
        & 0.22873e-06_r8,0.17557e-03_r8,0.26674e-03_r8,0.32662e-03_r8,0.36698e-03_r8, &
        & 0.38862e-03_r8,0.38395e-03_r8,0.33481e-03_r8,0.66717e-04_r8 /)
      kao(:, 3, 6, 3) = (/ &
        & 0.21632e-06_r8,0.18596e-03_r8,0.28315e-03_r8,0.34710e-03_r8,0.39032e-03_r8, &
        & 0.41186e-03_r8,0.40597e-03_r8,0.35347e-03_r8,0.71805e-04_r8 /)
      kao(:, 4, 6, 3) = (/ &
        & 0.20515e-06_r8,0.19412e-03_r8,0.29825e-03_r8,0.36672e-03_r8,0.41223e-03_r8, &
        & 0.43370e-03_r8,0.42654e-03_r8,0.37308e-03_r8,0.76950e-04_r8 /)
      kao(:, 5, 6, 3) = (/ &
        & 0.19500e-06_r8,0.20163e-03_r8,0.31177e-03_r8,0.38573e-03_r8,0.43298e-03_r8, &
        & 0.45474e-03_r8,0.44659e-03_r8,0.39273e-03_r8,0.81854e-04_r8 /)
      kao(:, 1, 7, 3) = (/ &
        & 0.20644e-06_r8,0.13088e-03_r8,0.19883e-03_r8,0.24453e-03_r8,0.27379e-03_r8, &
        & 0.29133e-03_r8,0.28972e-03_r8,0.25527e-03_r8,0.48483e-04_r8 /)
      kao(:, 2, 7, 3) = (/ &
        & 0.19422e-06_r8,0.14123e-03_r8,0.21464e-03_r8,0.26307e-03_r8,0.29520e-03_r8, &
        & 0.31262e-03_r8,0.30976e-03_r8,0.27057e-03_r8,0.53189e-04_r8 /)
      kao(:, 3, 7, 3) = (/ &
        & 0.18334e-06_r8,0.15056e-03_r8,0.22945e-03_r8,0.28102e-03_r8,0.31570e-03_r8, &
        & 0.33336e-03_r8,0.32921e-03_r8,0.28657e-03_r8,0.57664e-04_r8 /)
      kao(:, 4, 7, 3) = (/ &
        & 0.17359e-06_r8,0.15845e-03_r8,0.24254e-03_r8,0.29812e-03_r8,0.33533e-03_r8, &
        & 0.35273e-03_r8,0.34737e-03_r8,0.30290e-03_r8,0.62080e-04_r8 /)
      kao(:, 5, 7, 3) = (/ &
        & 0.16476e-06_r8,0.16515e-03_r8,0.25472e-03_r8,0.31492e-03_r8,0.35368e-03_r8, &
        & 0.37134e-03_r8,0.36466e-03_r8,0.31971e-03_r8,0.66283e-04_r8 /)
      kao(:, 1, 8, 3) = (/ &
        & 0.17564e-06_r8,0.10377e-03_r8,0.15799e-03_r8,0.19443e-03_r8,0.21775e-03_r8, &
        & 0.23221e-03_r8,0.23178e-03_r8,0.20518e-03_r8,0.38613e-04_r8 /)
      kao(:, 2, 8, 3) = (/ &
        & 0.16486e-06_r8,0.11291e-03_r8,0.17177e-03_r8,0.21060e-03_r8,0.23605e-03_r8, &
        & 0.25023e-03_r8,0.24860e-03_r8,0.21840e-03_r8,0.42574e-04_r8 /)
      kao(:, 3, 8, 3) = (/ &
        & 0.15532e-06_r8,0.12160e-03_r8,0.18472e-03_r8,0.22613e-03_r8,0.25383e-03_r8, &
        & 0.26813e-03_r8,0.26569e-03_r8,0.23149e-03_r8,0.46438e-04_r8 /)
      kao(:, 4, 8, 3) = (/ &
        & 0.14679e-06_r8,0.12871e-03_r8,0.19629e-03_r8,0.24117e-03_r8,0.27101e-03_r8, &
        & 0.28546e-03_r8,0.28148e-03_r8,0.24511e-03_r8,0.50132e-04_r8 /)
      kao(:, 5, 8, 3) = (/ &
        & 0.13913e-06_r8,0.13470e-03_r8,0.20711e-03_r8,0.25583e-03_r8,0.28735e-03_r8, &
        & 0.30171e-03_r8,0.29653e-03_r8,0.25931e-03_r8,0.53892e-04_r8 /)
      kao(:, 1, 9, 3) = (/ &
        & 0.14950e-06_r8,0.81941e-04_r8,0.12473e-03_r8,0.15363e-03_r8,0.17257e-03_r8, &
        & 0.18409e-03_r8,0.18424e-03_r8,0.16439e-03_r8,0.30772e-04_r8 /)
      kao(:, 2, 9, 3) = (/ &
        & 0.13998e-06_r8,0.89702e-04_r8,0.13655e-03_r8,0.16763e-03_r8,0.18779e-03_r8, &
        & 0.19919e-03_r8,0.19877e-03_r8,0.17581e-03_r8,0.34022e-04_r8 /)
      kao(:, 3, 9, 3) = (/ &
        & 0.13160e-06_r8,0.97263e-04_r8,0.14776e-03_r8,0.18089e-03_r8,0.20292e-03_r8, &
        & 0.21451e-03_r8,0.21317e-03_r8,0.18640e-03_r8,0.37381e-04_r8 /)
      kao(:, 4, 9, 3) = (/ &
        & 0.12415e-06_r8,0.10389e-03_r8,0.15817e-03_r8,0.19404e-03_r8,0.21794e-03_r8, &
        & 0.22980e-03_r8,0.22715e-03_r8,0.19784e-03_r8,0.40457e-04_r8 /)
      kao(:, 5, 9, 3) = (/ &
        & 0.11749e-06_r8,0.10934e-03_r8,0.16768e-03_r8,0.20680e-03_r8,0.23234e-03_r8, &
        & 0.24414e-03_r8,0.24026e-03_r8,0.20959e-03_r8,0.43586e-04_r8 /)
      kao(:, 1,10, 3) = (/ &
        & 0.12658e-06_r8,0.64763e-04_r8,0.98690e-04_r8,0.12170e-03_r8,0.13709e-03_r8, &
        & 0.14644e-03_r8,0.14709e-03_r8,0.13215e-03_r8,0.24737e-04_r8 /)
      kao(:, 2,10, 3) = (/ &
        & 0.11826e-06_r8,0.71405e-04_r8,0.10875e-03_r8,0.13368e-03_r8,0.14978e-03_r8, &
        & 0.15901e-03_r8,0.15937e-03_r8,0.14153e-03_r8,0.27487e-04_r8 /)
      kao(:, 3,10, 3) = (/ &
        & 0.11097e-06_r8,0.77857e-04_r8,0.11842e-03_r8,0.14510e-03_r8,0.16261e-03_r8, &
        & 0.17204e-03_r8,0.17129e-03_r8,0.15041e-03_r8,0.30250e-04_r8 /)
      kao(:, 4,10, 3) = (/ &
        & 0.10451e-06_r8,0.83764e-04_r8,0.12762e-03_r8,0.15625e-03_r8,0.17544e-03_r8, &
        & 0.18516e-03_r8,0.18345e-03_r8,0.16010e-03_r8,0.32891e-04_r8 /)
      kao(:, 5,10, 3) = (/ &
        & 0.98767e-07_r8,0.88833e-04_r8,0.13595e-03_r8,0.16723e-03_r8,0.18798e-03_r8, &
        & 0.19766e-03_r8,0.19477e-03_r8,0.16979e-03_r8,0.35547e-04_r8 /)
      kao(:, 1,11, 3) = (/ &
        & 0.10368e-06_r8,0.53714e-04_r8,0.81748e-04_r8,0.10085e-03_r8,0.11349e-03_r8, &
        & 0.12126e-03_r8,0.12180e-03_r8,0.10950e-03_r8,0.20787e-04_r8 /)
      kao(:, 2,11, 3) = (/ &
        & 0.96854e-07_r8,0.59175e-04_r8,0.90131e-04_r8,0.11085e-03_r8,0.12425e-03_r8, &
        & 0.13166e-03_r8,0.13207e-03_r8,0.11733e-03_r8,0.23028e-04_r8 /)
      kao(:, 3,11, 3) = (/ &
        & 0.90882e-07_r8,0.64593e-04_r8,0.98275e-04_r8,0.12041e-03_r8,0.13497e-03_r8, &
        & 0.14273e-03_r8,0.14215e-03_r8,0.12479e-03_r8,0.25362e-04_r8 /)
      kao(:, 4,11, 3) = (/ &
        & 0.85602e-07_r8,0.69545e-04_r8,0.10592e-03_r8,0.12982e-03_r8,0.14583e-03_r8, &
        & 0.15388e-03_r8,0.15228e-03_r8,0.13297e-03_r8,0.27585e-04_r8 /)
      kao(:, 5,11, 3) = (/ &
        & 0.80889e-07_r8,0.73731e-04_r8,0.11290e-03_r8,0.13914e-03_r8,0.15637e-03_r8, &
        & 0.16431e-03_r8,0.16189e-03_r8,0.14116e-03_r8,0.29828e-04_r8 /)
      kao(:, 1,12, 3) = (/ &
        & 0.84886e-07_r8,0.44418e-04_r8,0.67641e-04_r8,0.83490e-04_r8,0.93906e-04_r8, &
        & 0.10034e-03_r8,0.10075e-03_r8,0.90614e-04_r8,0.17350e-04_r8 /)
      kao(:, 2,12, 3) = (/ &
        & 0.79297e-07_r8,0.48981e-04_r8,0.74656e-04_r8,0.91821e-04_r8,0.10299e-03_r8, &
        & 0.10891e-03_r8,0.10933e-03_r8,0.97221e-04_r8,0.19237e-04_r8 /)
      kao(:, 3,12, 3) = (/ &
        & 0.74408e-07_r8,0.53553e-04_r8,0.81503e-04_r8,0.99872e-04_r8,0.11196e-03_r8, &
        & 0.11832e-03_r8,0.11782e-03_r8,0.10341e-03_r8,0.21189e-04_r8 /)
      kao(:, 4,12, 3) = (/ &
        & 0.70085e-07_r8,0.57698e-04_r8,0.87887e-04_r8,0.10781e-03_r8,0.12107e-03_r8, &
        & 0.12775e-03_r8,0.12624e-03_r8,0.11034e-03_r8,0.23038e-04_r8 /)
      kao(:, 5,12, 3) = (/ &
        & 0.66226e-07_r8,0.61177e-04_r8,0.93694e-04_r8,0.11567e-03_r8,0.12995e-03_r8, &
        & 0.13645e-03_r8,0.13436e-03_r8,0.11726e-03_r8,0.24913e-04_r8 /)
      kao(:, 1,13, 3) = (/ &
        & 0.69499e-07_r8,0.36716e-04_r8,0.55902e-04_r8,0.69067e-04_r8,0.77635e-04_r8, &
        & 0.82934e-04_r8,0.83302e-04_r8,0.74905e-04_r8,0.14419e-04_r8 /)
      kao(:, 2,13, 3) = (/ &
        & 0.64923e-07_r8,0.40511e-04_r8,0.61779e-04_r8,0.75984e-04_r8,0.85239e-04_r8, &
        & 0.90090e-04_r8,0.90456e-04_r8,0.80264e-04_r8,0.15996e-04_r8 /)
      kao(:, 3,13, 3) = (/ &
        & 0.60920e-07_r8,0.44356e-04_r8,0.67533e-04_r8,0.82746e-04_r8,0.92816e-04_r8, &
        & 0.98017e-04_r8,0.97590e-04_r8,0.85621e-04_r8,0.17623e-04_r8 /)
      kao(:, 4,13, 3) = (/ &
        & 0.57381e-07_r8,0.47826e-04_r8,0.72874e-04_r8,0.89443e-04_r8,0.10040e-03_r8, &
        & 0.10588e-03_r8,0.10456e-03_r8,0.91429e-04_r8,0.19144e-04_r8 /)
      kao(:, 5,13, 3) = (/ &
        & 0.54221e-07_r8,0.50750e-04_r8,0.77698e-04_r8,0.96005e-04_r8,0.10784e-03_r8, &
        & 0.11318e-03_r8,0.11139e-03_r8,0.97258e-04_r8,0.20671e-04_r8 /)
      kao(:, 1, 1, 4) = (/ &
        & 0.36654e-05_r8,0.13689e-02_r8,0.21108e-02_r8,0.26314e-02_r8,0.29458e-02_r8, &
        & 0.30831e-02_r8,0.30207e-02_r8,0.26003e-02_r8,0.93689e-03_r8 /)
      kao(:, 2, 1, 4) = (/ &
        & 0.35304e-05_r8,0.14025e-02_r8,0.21716e-02_r8,0.27078e-02_r8,0.30551e-02_r8, &
        & 0.31948e-02_r8,0.31649e-02_r8,0.27258e-02_r8,0.97983e-03_r8 /)
      kao(:, 3, 1, 4) = (/ &
        & 0.34059e-05_r8,0.14340e-02_r8,0.22214e-02_r8,0.27773e-02_r8,0.31348e-02_r8, &
        & 0.33049e-02_r8,0.32835e-02_r8,0.28461e-02_r8,0.10251e-02_r8 /)
      kao(:, 4, 1, 4) = (/ &
        & 0.32895e-05_r8,0.14610e-02_r8,0.22596e-02_r8,0.28314e-02_r8,0.32113e-02_r8, &
        & 0.34131e-02_r8,0.33921e-02_r8,0.29508e-02_r8,0.10730e-02_r8 /)
      kao(:, 5, 1, 4) = (/ &
        & 0.31814e-05_r8,0.14814e-02_r8,0.22905e-02_r8,0.28789e-02_r8,0.32785e-02_r8, &
        & 0.34996e-02_r8,0.34952e-02_r8,0.30528e-02_r8,0.11205e-02_r8 /)
      kao(:, 1, 2, 4) = (/ &
        & 0.30293e-05_r8,0.11600e-02_r8,0.17946e-02_r8,0.22370e-02_r8,0.25205e-02_r8, &
        & 0.26432e-02_r8,0.26172e-02_r8,0.22691e-02_r8,0.78466e-03_r8 /)
      kao(:, 2, 2, 4) = (/ &
        & 0.29173e-05_r8,0.11916e-02_r8,0.18468e-02_r8,0.23072e-02_r8,0.26094e-02_r8, &
        & 0.27477e-02_r8,0.27388e-02_r8,0.23809e-02_r8,0.82356e-03_r8 /)
      kao(:, 3, 2, 4) = (/ &
        & 0.28152e-05_r8,0.12203e-02_r8,0.18939e-02_r8,0.23691e-02_r8,0.26814e-02_r8, &
        & 0.28506e-02_r8,0.28414e-02_r8,0.24825e-02_r8,0.86161e-03_r8 /)
      kao(:, 4, 2, 4) = (/ &
        & 0.27207e-05_r8,0.12454e-02_r8,0.19291e-02_r8,0.24180e-02_r8,0.27489e-02_r8, &
        & 0.29380e-02_r8,0.29345e-02_r8,0.25808e-02_r8,0.90328e-03_r8 /)
      kao(:, 5, 2, 4) = (/ &
        & 0.26316e-05_r8,0.12644e-02_r8,0.19586e-02_r8,0.24624e-02_r8,0.28146e-02_r8, &
        & 0.30125e-02_r8,0.30237e-02_r8,0.26695e-02_r8,0.94678e-03_r8 /)
      kao(:, 1, 3, 4) = (/ &
        & 0.25288e-05_r8,0.97348e-03_r8,0.15070e-02_r8,0.18795e-02_r8,0.21206e-02_r8, &
        & 0.22362e-02_r8,0.22210e-02_r8,0.19369e-02_r8,0.64308e-03_r8 /)
      kao(:, 2, 3, 4) = (/ &
        & 0.24353e-05_r8,0.10031e-02_r8,0.15552e-02_r8,0.19441e-02_r8,0.22013e-02_r8, &
        & 0.23257e-02_r8,0.23286e-02_r8,0.20362e-02_r8,0.67529e-03_r8 /)
      kao(:, 3, 3, 4) = (/ &
        & 0.23495e-05_r8,0.10295e-02_r8,0.15986e-02_r8,0.20019e-02_r8,0.22663e-02_r8, &
        & 0.24160e-02_r8,0.24204e-02_r8,0.21276e-02_r8,0.70991e-03_r8 /)
      kao(:, 4, 3, 4) = (/ &
        & 0.22699e-05_r8,0.10533e-02_r8,0.16337e-02_r8,0.20489e-02_r8,0.23288e-02_r8, &
        & 0.24911e-02_r8,0.25016e-02_r8,0.22148e-02_r8,0.74635e-03_r8 /)
      kao(:, 5, 3, 4) = (/ &
        & 0.21951e-05_r8,0.10724e-02_r8,0.16625e-02_r8,0.20891e-02_r8,0.23896e-02_r8, &
        & 0.25582e-02_r8,0.25812e-02_r8,0.22925e-02_r8,0.78432e-03_r8 /)
      kao(:, 1, 4, 4) = (/ &
        & 0.21169e-05_r8,0.81053e-03_r8,0.12568e-02_r8,0.15647e-02_r8,0.17654e-02_r8, &
        & 0.18662e-02_r8,0.18568e-02_r8,0.16269e-02_r8,0.52608e-03_r8 /)
      kao(:, 2, 4, 4) = (/ &
        & 0.20407e-05_r8,0.83875e-03_r8,0.13019e-02_r8,0.16252e-02_r8,0.18383e-02_r8, &
        & 0.19441e-02_r8,0.19538e-02_r8,0.17139e-02_r8,0.55325e-03_r8 /)
      kao(:, 3, 4, 4) = (/ &
        & 0.19674e-05_r8,0.86329e-03_r8,0.13417e-02_r8,0.16788e-02_r8,0.18985e-02_r8, &
        & 0.20246e-02_r8,0.20315e-02_r8,0.17978e-02_r8,0.58253e-03_r8 /)
      kao(:, 4, 4, 4) = (/ &
        & 0.18994e-05_r8,0.88551e-03_r8,0.13753e-02_r8,0.17238e-02_r8,0.19566e-02_r8, &
        & 0.20923e-02_r8,0.21035e-02_r8,0.18724e-02_r8,0.61438e-03_r8 /)
      kao(:, 5, 4, 4) = (/ &
        & 0.18358e-05_r8,0.90442e-03_r8,0.14042e-02_r8,0.17619e-02_r8,0.20119e-02_r8, &
        & 0.21542e-02_r8,0.21749e-02_r8,0.19425e-02_r8,0.64762e-03_r8 /)
      kao(:, 1, 5, 4) = (/ &
        & 0.17725e-05_r8,0.67146e-03_r8,0.10396e-02_r8,0.12935e-02_r8,0.14576e-02_r8, &
        & 0.15437e-02_r8,0.15341e-02_r8,0.13532e-02_r8,0.42981e-03_r8 /)
      kao(:, 2, 5, 4) = (/ &
        & 0.17095e-05_r8,0.69774e-03_r8,0.10823e-02_r8,0.13477e-02_r8,0.15227e-02_r8, &
        & 0.16117e-02_r8,0.16222e-02_r8,0.14302e-02_r8,0.45286e-03_r8 /)
      kao(:, 3, 5, 4) = (/ &
        & 0.16478e-05_r8,0.72044e-03_r8,0.11190e-02_r8,0.13967e-02_r8,0.15783e-02_r8, &
        & 0.16817e-02_r8,0.16897e-02_r8,0.15040e-02_r8,0.47782e-03_r8 /)
      kao(:, 4, 5, 4) = (/ &
        & 0.15896e-05_r8,0.74136e-03_r8,0.11512e-02_r8,0.14394e-02_r8,0.16307e-02_r8, &
        & 0.17435e-02_r8,0.17536e-02_r8,0.15687e-02_r8,0.50468e-03_r8 /)
      kao(:, 5, 5, 4) = (/ &
        & 0.15353e-05_r8,0.75977e-03_r8,0.11790e-02_r8,0.14755e-02_r8,0.16811e-02_r8, &
        & 0.17990e-02_r8,0.18175e-02_r8,0.16279e-02_r8,0.53353e-03_r8 /)
      kao(:, 1, 6, 4) = (/ &
        & 0.14856e-05_r8,0.55163e-03_r8,0.85182e-03_r8,0.10583e-02_r8,0.11933e-02_r8, &
        & 0.12633e-02_r8,0.12519e-02_r8,0.11126e-02_r8,0.34969e-03_r8 /)
      kao(:, 2, 6, 4) = (/ &
        & 0.14323e-05_r8,0.57534e-03_r8,0.89211e-03_r8,0.11084e-02_r8,0.12510e-02_r8, &
        & 0.13248e-02_r8,0.13302e-02_r8,0.11815e-02_r8,0.36893e-03_r8 /)
      kao(:, 3, 6, 4) = (/ &
        & 0.13818e-05_r8,0.59705e-03_r8,0.92552e-03_r8,0.11530e-02_r8,0.13018e-02_r8, &
        & 0.13860e-02_r8,0.13942e-02_r8,0.12437e-02_r8,0.38991e-03_r8 /)
      kao(:, 4, 6, 4) = (/ &
        & 0.13317e-05_r8,0.61671e-03_r8,0.95568e-03_r8,0.11922e-02_r8,0.13481e-02_r8, &
        & 0.14426e-02_r8,0.14508e-02_r8,0.13001e-02_r8,0.41248e-03_r8 /)
      kao(:, 5, 6, 4) = (/ &
        & 0.12851e-05_r8,0.63414e-03_r8,0.98227e-03_r8,0.12265e-02_r8,0.13936e-02_r8, &
        & 0.14913e-02_r8,0.15064e-02_r8,0.13512e-02_r8,0.43696e-03_r8 /)
      kao(:, 1, 7, 4) = (/ &
        & 0.12453e-05_r8,0.44982e-03_r8,0.69286e-03_r8,0.85857e-03_r8,0.97115e-03_r8, &
        & 0.10268e-02_r8,0.10132e-02_r8,0.90661e-03_r8,0.28333e-03_r8 /)
      kao(:, 2, 7, 4) = (/ &
        & 0.11997e-05_r8,0.47163e-03_r8,0.72984e-03_r8,0.90525e-03_r8,0.10209e-02_r8, &
        & 0.10830e-02_r8,0.10815e-02_r8,0.96820e-03_r8,0.29991e-03_r8 /)
      kao(:, 3, 7, 4) = (/ &
        & 0.11571e-05_r8,0.49170e-03_r8,0.76064e-03_r8,0.94597e-03_r8,0.10683e-02_r8, &
        & 0.11337e-02_r8,0.11418e-02_r8,0.10210e-02_r8,0.31738e-03_r8 /)
      kao(:, 4, 7, 4) = (/ &
        & 0.11157e-05_r8,0.50964e-03_r8,0.78859e-03_r8,0.98236e-03_r8,0.11088e-02_r8, &
        & 0.11859e-02_r8,0.11920e-02_r8,0.10690e-02_r8,0.33600e-03_r8 /)
      kao(:, 5, 7, 4) = (/ &
        & 0.10757e-05_r8,0.52578e-03_r8,0.81330e-03_r8,0.10141e-02_r8,0.11493e-02_r8, &
        & 0.12285e-02_r8,0.12399e-02_r8,0.11151e-02_r8,0.35631e-03_r8 /)
      kao(:, 1, 8, 4) = (/ &
        & 0.10436e-05_r8,0.36475e-03_r8,0.55948e-03_r8,0.69399e-03_r8,0.78699e-03_r8, &
        & 0.82733e-03_r8,0.81546e-03_r8,0.73443e-03_r8,0.22874e-03_r8 /)
      kao(:, 2, 8, 4) = (/ &
        & 0.10043e-05_r8,0.38461e-03_r8,0.59365e-03_r8,0.73631e-03_r8,0.82902e-03_r8, &
        & 0.87996e-03_r8,0.87589e-03_r8,0.78745e-03_r8,0.24281e-03_r8 /)
      kao(:, 3, 8, 4) = (/ &
        & 0.96785e-06_r8,0.40227e-03_r8,0.62191e-03_r8,0.77183e-03_r8,0.87067e-03_r8, &
        & 0.92338e-03_r8,0.93116e-03_r8,0.83334e-03_r8,0.25735e-03_r8 /)
      kao(:, 4, 8, 4) = (/ &
        & 0.93367e-06_r8,0.41881e-03_r8,0.64697e-03_r8,0.80474e-03_r8,0.90754e-03_r8, &
        & 0.96806e-03_r8,0.97434e-03_r8,0.87439e-03_r8,0.27286e-03_r8 /)
      kao(:, 5, 8, 4) = (/ &
        & 0.90017e-06_r8,0.43377e-03_r8,0.67026e-03_r8,0.83398e-03_r8,0.94269e-03_r8, &
        & 0.10080e-02_r8,0.10154e-02_r8,0.91479e-03_r8,0.28948e-03_r8 /)
      kao(:, 1, 9, 4) = (/ &
        & 0.87469e-06_r8,0.29345e-03_r8,0.44857e-03_r8,0.55653e-03_r8,0.63371e-03_r8, &
        & 0.66253e-03_r8,0.65229e-03_r8,0.59009e-03_r8,0.18475e-03_r8 /)
      kao(:, 2, 9, 4) = (/ &
        & 0.84062e-06_r8,0.31152e-03_r8,0.47975e-03_r8,0.59422e-03_r8,0.67077e-03_r8, &
        & 0.71168e-03_r8,0.70550e-03_r8,0.63674e-03_r8,0.19669e-03_r8 /)
      kao(:, 3, 9, 4) = (/ &
        & 0.80947e-06_r8,0.32779e-03_r8,0.50582e-03_r8,0.62707e-03_r8,0.70705e-03_r8, &
        & 0.74936e-03_r8,0.75252e-03_r8,0.67682e-03_r8,0.20896e-03_r8 /)
      kao(:, 4, 9, 4) = (/ &
        & 0.78052e-06_r8,0.34262e-03_r8,0.52820e-03_r8,0.65631e-03_r8,0.74002e-03_r8, &
        & 0.78731e-03_r8,0.79257e-03_r8,0.71155e-03_r8,0.22197e-03_r8 /)
      kao(:, 5, 9, 4) = (/ &
        & 0.75300e-06_r8,0.35618e-03_r8,0.54940e-03_r8,0.68236e-03_r8,0.76978e-03_r8, &
        & 0.82271e-03_r8,0.82806e-03_r8,0.74658e-03_r8,0.23588e-03_r8 /)
      kao(:, 1,10, 4) = (/ &
        & 0.73080e-06_r8,0.23619e-03_r8,0.36002e-03_r8,0.44769e-03_r8,0.51001e-03_r8, &
        & 0.53294e-03_r8,0.52319e-03_r8,0.47492e-03_r8,0.15005e-03_r8 /)
      kao(:, 2,10, 4) = (/ &
        & 0.70142e-06_r8,0.25225e-03_r8,0.38742e-03_r8,0.48039e-03_r8,0.54285e-03_r8, &
        & 0.57407e-03_r8,0.56765e-03_r8,0.51444e-03_r8,0.16000e-03_r8 /)
      kao(:, 3,10, 4) = (/ &
        & 0.67484e-06_r8,0.26687e-03_r8,0.41119e-03_r8,0.50924e-03_r8,0.57372e-03_r8, &
        & 0.60912e-03_r8,0.60813e-03_r8,0.54945e-03_r8,0.17036e-03_r8 /)
      kao(:, 4,10, 4) = (/ &
        & 0.65032e-06_r8,0.28002e-03_r8,0.43104e-03_r8,0.53513e-03_r8,0.60294e-03_r8, &
        & 0.63998e-03_r8,0.64485e-03_r8,0.57888e-03_r8,0.18120e-03_r8 /)
      kao(:, 5,10, 4) = (/ &
        & 0.62752e-06_r8,0.29182e-03_r8,0.44950e-03_r8,0.55836e-03_r8,0.62849e-03_r8, &
        & 0.67148e-03_r8,0.67570e-03_r8,0.60918e-03_r8,0.19271e-03_r8 /)
      kao(:, 1,11, 4) = (/ &
        & 0.59846e-06_r8,0.19603e-03_r8,0.29902e-03_r8,0.37159e-03_r8,0.42367e-03_r8, &
        & 0.44241e-03_r8,0.43550e-03_r8,0.39618e-03_r8,0.12498e-03_r8 /)
      kao(:, 2,11, 4) = (/ &
        & 0.57447e-06_r8,0.20953e-03_r8,0.32187e-03_r8,0.39882e-03_r8,0.45021e-03_r8, &
        & 0.47717e-03_r8,0.47240e-03_r8,0.42894e-03_r8,0.13362e-03_r8 /)
      kao(:, 3,11, 4) = (/ &
        & 0.55265e-06_r8,0.22185e-03_r8,0.34133e-03_r8,0.42283e-03_r8,0.47616e-03_r8, &
        & 0.50481e-03_r8,0.50553e-03_r8,0.45654e-03_r8,0.14246e-03_r8 /)
      kao(:, 4,11, 4) = (/ &
        & 0.53259e-06_r8,0.23301e-03_r8,0.35816e-03_r8,0.44448e-03_r8,0.50048e-03_r8, &
        & 0.53147e-03_r8,0.53574e-03_r8,0.48169e-03_r8,0.15168e-03_r8 /)
      kao(:, 5,11, 4) = (/ &
        & 0.51379e-06_r8,0.24302e-03_r8,0.37383e-03_r8,0.46352e-03_r8,0.52203e-03_r8, &
        & 0.55783e-03_r8,0.56175e-03_r8,0.50737e-03_r8,0.16153e-03_r8 /)
      kao(:, 1,12, 4) = (/ &
        & 0.49006e-06_r8,0.16259e-03_r8,0.24802e-03_r8,0.30804e-03_r8,0.35111e-03_r8, &
        & 0.36672e-03_r8,0.36166e-03_r8,0.32968e-03_r8,0.10401e-03_r8 /)
      kao(:, 2,12, 4) = (/ &
        & 0.47033e-06_r8,0.17379e-03_r8,0.26697e-03_r8,0.33069e-03_r8,0.37292e-03_r8, &
        & 0.39587e-03_r8,0.39239e-03_r8,0.35672e-03_r8,0.11138e-03_r8 /)
      kao(:, 3,12, 4) = (/ &
        & 0.45247e-06_r8,0.18417e-03_r8,0.28295e-03_r8,0.35045e-03_r8,0.39465e-03_r8, &
        & 0.41825e-03_r8,0.41984e-03_r8,0.37867e-03_r8,0.11882e-03_r8 /)
      kao(:, 4,12, 4) = (/ &
        & 0.43605e-06_r8,0.19351e-03_r8,0.29716e-03_r8,0.36850e-03_r8,0.41489e-03_r8, &
        & 0.44074e-03_r8,0.44460e-03_r8,0.40031e-03_r8,0.12667e-03_r8 /)
      kao(:, 5,12, 4) = (/ &
        & 0.42066e-06_r8,0.20206e-03_r8,0.31038e-03_r8,0.38464e-03_r8,0.43337e-03_r8, &
        & 0.46297e-03_r8,0.46667e-03_r8,0.42202e-03_r8,0.13498e-03_r8 /)
      kao(:, 1,13, 4) = (/ &
        & 0.40122e-06_r8,0.13465e-03_r8,0.20541e-03_r8,0.25488e-03_r8,0.29006e-03_r8, &
        & 0.30358e-03_r8,0.29984e-03_r8,0.27375e-03_r8,0.86406e-04_r8 /)
      kao(:, 2,13, 4) = (/ &
        & 0.38502e-06_r8,0.14398e-03_r8,0.22086e-03_r8,0.27376e-03_r8,0.30832e-03_r8, &
        & 0.32794e-03_r8,0.32517e-03_r8,0.29562e-03_r8,0.92614e-04_r8 /)
      kao(:, 3,13, 4) = (/ &
        & 0.37045e-06_r8,0.15266e-03_r8,0.23416e-03_r8,0.29013e-03_r8,0.32675e-03_r8, &
        & 0.34622e-03_r8,0.34816e-03_r8,0.31401e-03_r8,0.98880e-04_r8 /)
      kao(:, 4,13, 4) = (/ &
        & 0.35702e-06_r8,0.16050e-03_r8,0.24608e-03_r8,0.30521e-03_r8,0.34336e-03_r8, &
        & 0.36522e-03_r8,0.36857e-03_r8,0.33246e-03_r8,0.10559e-03_r8 /)
      kao(:, 5,13, 4) = (/ &
        & 0.34440e-06_r8,0.16771e-03_r8,0.25742e-03_r8,0.31904e-03_r8,0.35943e-03_r8, &
        & 0.38405e-03_r8,0.38715e-03_r8,0.35087e-03_r8,0.11262e-03_r8 /)
      kao(:, 1, 1, 5) = (/ &
        & 0.15583e-03_r8,0.37546e-02_r8,0.53536e-02_r8,0.64161e-02_r8,0.71223e-02_r8, &
        & 0.74982e-02_r8,0.73596e-02_r8,0.65135e-02_r8,0.35175e-02_r8 /)
      kao(:, 2, 1, 5) = (/ &
        & 0.16148e-03_r8,0.38569e-02_r8,0.55256e-02_r8,0.66461e-02_r8,0.73757e-02_r8, &
        & 0.77530e-02_r8,0.75665e-02_r8,0.66496e-02_r8,0.36840e-02_r8 /)
      kao(:, 3, 1, 5) = (/ &
        & 0.16484e-03_r8,0.39353e-02_r8,0.56745e-02_r8,0.68364e-02_r8,0.76166e-02_r8, &
        & 0.79711e-02_r8,0.77717e-02_r8,0.67846e-02_r8,0.38485e-02_r8 /)
      kao(:, 4, 1, 5) = (/ &
        & 0.16621e-03_r8,0.39946e-02_r8,0.57947e-02_r8,0.70071e-02_r8,0.78193e-02_r8, &
        & 0.81581e-02_r8,0.79592e-02_r8,0.69132e-02_r8,0.39769e-02_r8 /)
      kao(:, 5, 1, 5) = (/ &
        & 0.16518e-03_r8,0.40386e-02_r8,0.58925e-02_r8,0.71530e-02_r8,0.79946e-02_r8, &
        & 0.83258e-02_r8,0.81107e-02_r8,0.70226e-02_r8,0.41134e-02_r8 /)
      kao(:, 1, 2, 5) = (/ &
        & 0.12482e-03_r8,0.32204e-02_r8,0.46102e-02_r8,0.55475e-02_r8,0.61730e-02_r8, &
        & 0.65000e-02_r8,0.63942e-02_r8,0.56394e-02_r8,0.30002e-02_r8 /)
      kao(:, 2, 2, 5) = (/ &
        & 0.13027e-03_r8,0.33099e-02_r8,0.47617e-02_r8,0.57497e-02_r8,0.64031e-02_r8, &
        & 0.67184e-02_r8,0.65829e-02_r8,0.57721e-02_r8,0.31442e-02_r8 /)
      kao(:, 3, 2, 5) = (/ &
        & 0.13370e-03_r8,0.33808e-02_r8,0.48845e-02_r8,0.59235e-02_r8,0.66074e-02_r8, &
        & 0.69048e-02_r8,0.67660e-02_r8,0.59018e-02_r8,0.32788e-02_r8 /)
      kao(:, 4, 2, 5) = (/ &
        & 0.13549e-03_r8,0.34340e-02_r8,0.49885e-02_r8,0.60745e-02_r8,0.67877e-02_r8, &
        & 0.70780e-02_r8,0.69202e-02_r8,0.60131e-02_r8,0.33946e-02_r8 /)
      kao(:, 5, 2, 5) = (/ &
        & 0.13543e-03_r8,0.34778e-02_r8,0.50745e-02_r8,0.61981e-02_r8,0.69282e-02_r8, &
        & 0.72229e-02_r8,0.70521e-02_r8,0.61218e-02_r8,0.35097e-02_r8 /)
      kao(:, 1, 3, 5) = (/ &
        & 0.98437e-04_r8,0.27209e-02_r8,0.39035e-02_r8,0.47185e-02_r8,0.52706e-02_r8, &
        & 0.55579e-02_r8,0.54846e-02_r8,0.48469e-02_r8,0.25077e-02_r8 /)
      kao(:, 2, 3, 5) = (/ &
        & 0.10396e-03_r8,0.28031e-02_r8,0.40384e-02_r8,0.48993e-02_r8,0.54753e-02_r8, &
        & 0.57575e-02_r8,0.56525e-02_r8,0.49684e-02_r8,0.26366e-02_r8 /)
      kao(:, 3, 3, 5) = (/ &
        & 0.10770e-03_r8,0.28702e-02_r8,0.41513e-02_r8,0.50504e-02_r8,0.56640e-02_r8, &
        & 0.59245e-02_r8,0.58125e-02_r8,0.50922e-02_r8,0.27478e-02_r8 /)
      kao(:, 4, 3, 5) = (/ &
        & 0.10996e-03_r8,0.29232e-02_r8,0.42451e-02_r8,0.51838e-02_r8,0.58257e-02_r8, &
        & 0.60793e-02_r8,0.59498e-02_r8,0.51949e-02_r8,0.28490e-02_r8 /)
      kao(:, 5, 3, 5) = (/ &
        & 0.11088e-03_r8,0.29645e-02_r8,0.43251e-02_r8,0.52992e-02_r8,0.59468e-02_r8, &
        & 0.62096e-02_r8,0.60648e-02_r8,0.52904e-02_r8,0.29495e-02_r8 /)
      kao(:, 1, 4, 5) = (/ &
        & 0.76587e-04_r8,0.22792e-02_r8,0.32731e-02_r8,0.39724e-02_r8,0.44561e-02_r8, &
        & 0.47109e-02_r8,0.46706e-02_r8,0.41444e-02_r8,0.20810e-02_r8 /)
      kao(:, 2, 4, 5) = (/ &
        & 0.82225e-04_r8,0.23548e-02_r8,0.33943e-02_r8,0.41325e-02_r8,0.46415e-02_r8, &
        & 0.48939e-02_r8,0.48200e-02_r8,0.42591e-02_r8,0.21925e-02_r8 /)
      kao(:, 3, 4, 5) = (/ &
        & 0.86203e-04_r8,0.24180e-02_r8,0.34991e-02_r8,0.42684e-02_r8,0.48074e-02_r8, &
        & 0.50416e-02_r8,0.49651e-02_r8,0.43643e-02_r8,0.22938e-02_r8 /)
      kao(:, 4, 4, 5) = (/ &
        & 0.88766e-04_r8,0.24694e-02_r8,0.35874e-02_r8,0.43875e-02_r8,0.49469e-02_r8, &
        & 0.51810e-02_r8,0.50850e-02_r8,0.44606e-02_r8,0.23791e-02_r8 /)
      kao(:, 5, 4, 5) = (/ &
        & 0.90218e-04_r8,0.25110e-02_r8,0.36613e-02_r8,0.44937e-02_r8,0.50548e-02_r8, &
        & 0.52982e-02_r8,0.51883e-02_r8,0.45498e-02_r8,0.24658e-02_r8 /)
      kao(:, 1, 5, 5) = (/ &
        & 0.59080e-04_r8,0.18972e-02_r8,0.27294e-02_r8,0.33195e-02_r8,0.37395e-02_r8, &
        & 0.39683e-02_r8,0.39523e-02_r8,0.35161e-02_r8,0.17195e-02_r8 /)
      kao(:, 2, 5, 5) = (/ &
        & 0.64508e-04_r8,0.19673e-02_r8,0.28376e-02_r8,0.34632e-02_r8,0.39033e-02_r8, &
        & 0.41343e-02_r8,0.40826e-02_r8,0.36195e-02_r8,0.18173e-02_r8 /)
      kao(:, 3, 5, 5) = (/ &
        & 0.68538e-04_r8,0.20264e-02_r8,0.29342e-02_r8,0.35856e-02_r8,0.40488e-02_r8, &
        & 0.42664e-02_r8,0.42141e-02_r8,0.37144e-02_r8,0.19081e-02_r8 /)
      kao(:, 4, 5, 5) = (/ &
        & 0.71328e-04_r8,0.20750e-02_r8,0.30165e-02_r8,0.36933e-02_r8,0.41719e-02_r8, &
        & 0.43880e-02_r8,0.43221e-02_r8,0.38006e-02_r8,0.19818e-02_r8 /)
      kao(:, 5, 5, 5) = (/ &
        & 0.73073e-04_r8,0.21155e-02_r8,0.30861e-02_r8,0.37892e-02_r8,0.42690e-02_r8, &
        & 0.44901e-02_r8,0.44161e-02_r8,0.38864e-02_r8,0.20583e-02_r8 /)
      kao(:, 1, 6, 5) = (/ &
        & 0.45069e-04_r8,0.15673e-02_r8,0.22596e-02_r8,0.27566e-02_r8,0.31117e-02_r8, &
        & 0.33162e-02_r8,0.33135e-02_r8,0.29574e-02_r8,0.14089e-02_r8 /)
      kao(:, 2, 6, 5) = (/ &
        & 0.49959e-04_r8,0.16342e-02_r8,0.23577e-02_r8,0.28828e-02_r8,0.32572e-02_r8, &
        & 0.34626e-02_r8,0.34302e-02_r8,0.30476e-02_r8,0.14955e-02_r8 /)
      kao(:, 3, 6, 5) = (/ &
        & 0.54013e-04_r8,0.16891e-02_r8,0.24457e-02_r8,0.29926e-02_r8,0.33865e-02_r8, &
        & 0.35809e-02_r8,0.35427e-02_r8,0.31358e-02_r8,0.15763e-02_r8 /)
      kao(:, 4, 6, 5) = (/ &
        & 0.56910e-04_r8,0.17356e-02_r8,0.25220e-02_r8,0.30903e-02_r8,0.34968e-02_r8, &
        & 0.36853e-02_r8,0.36443e-02_r8,0.32140e-02_r8,0.16428e-02_r8 /)
      kao(:, 5, 6, 5) = (/ &
        & 0.58852e-04_r8,0.17743e-02_r8,0.25868e-02_r8,0.31771e-02_r8,0.35857e-02_r8, &
        & 0.37782e-02_r8,0.37284e-02_r8,0.32905e-02_r8,0.17079e-02_r8 /)
      kao(:, 1, 7, 5) = (/ &
        & 0.34131e-04_r8,0.12873e-02_r8,0.18619e-02_r8,0.22745e-02_r8,0.25688e-02_r8, &
        & 0.27494e-02_r8,0.27574e-02_r8,0.24658e-02_r8,0.11444e-02_r8 /)
      kao(:, 2, 7, 5) = (/ &
        & 0.38379e-04_r8,0.13503e-02_r8,0.19490e-02_r8,0.23869e-02_r8,0.26985e-02_r8, &
        & 0.28761e-02_r8,0.28607e-02_r8,0.25443e-02_r8,0.12242e-02_r8 /)
      kao(:, 3, 7, 5) = (/ &
        & 0.42146e-04_r8,0.14018e-02_r8,0.20287e-02_r8,0.24843e-02_r8,0.28119e-02_r8, &
        & 0.29848e-02_r8,0.29569e-02_r8,0.26258e-02_r8,0.12956e-02_r8 /)
      kao(:, 4, 7, 5) = (/ &
        & 0.45116e-04_r8,0.14454e-02_r8,0.20989e-02_r8,0.25718e-02_r8,0.29115e-02_r8, &
        & 0.30740e-02_r8,0.30482e-02_r8,0.26967e-02_r8,0.13537e-02_r8 /)
      kao(:, 5, 7, 5) = (/ &
        & 0.47178e-04_r8,0.14818e-02_r8,0.21591e-02_r8,0.26509e-02_r8,0.29945e-02_r8, &
        & 0.31590e-02_r8,0.31235e-02_r8,0.27641e-02_r8,0.14100e-02_r8 /)
      kao(:, 1, 8, 5) = (/ &
        & 0.25656e-04_r8,0.10525e-02_r8,0.15266e-02_r8,0.18648e-02_r8,0.21060e-02_r8, &
        & 0.22660e-02_r8,0.22807e-02_r8,0.20415e-02_r8,0.92482e-03_r8 /)
      kao(:, 2, 8, 5) = (/ &
        & 0.29313e-04_r8,0.11096e-02_r8,0.16027e-02_r8,0.19628e-02_r8,0.22224e-02_r8, &
        & 0.23730e-02_r8,0.23683e-02_r8,0.21111e-02_r8,0.99366e-03_r8 /)
      kao(:, 3, 8, 5) = (/ &
        & 0.32643e-04_r8,0.11579e-02_r8,0.16732e-02_r8,0.20503e-02_r8,0.23231e-02_r8, &
        & 0.24721e-02_r8,0.24512e-02_r8,0.21842e-02_r8,0.10570e-02_r8 /)
      kao(:, 4, 8, 5) = (/ &
        & 0.35509e-04_r8,0.11985e-02_r8,0.17379e-02_r8,0.21284e-02_r8,0.24110e-02_r8, &
        & 0.25519e-02_r8,0.25339e-02_r8,0.22496e-02_r8,0.11116e-02_r8 /)
      kao(:, 5, 8, 5) = (/ &
        & 0.37616e-04_r8,0.12327e-02_r8,0.17933e-02_r8,0.21996e-02_r8,0.24880e-02_r8, &
        & 0.26258e-02_r8,0.26029e-02_r8,0.23088e-02_r8,0.11595e-02_r8 /)
      kao(:, 1, 9, 5) = (/ &
        & 0.19166e-04_r8,0.85559e-03_r8,0.12446e-02_r8,0.15213e-02_r8,0.17160e-02_r8, &
        & 0.18527e-02_r8,0.18723e-02_r8,0.16794e-02_r8,0.74316e-03_r8 /)
      kao(:, 2, 9, 5) = (/ &
        & 0.22251e-04_r8,0.90701e-03_r8,0.13107e-02_r8,0.16061e-02_r8,0.18177e-02_r8, &
        & 0.19452e-02_r8,0.19496e-02_r8,0.17420e-02_r8,0.80168e-03_r8 /)
      kao(:, 3, 9, 5) = (/ &
        & 0.25123e-04_r8,0.95106e-03_r8,0.13724e-02_r8,0.16826e-02_r8,0.19064e-02_r8, &
        & 0.20352e-02_r8,0.20241e-02_r8,0.18064e-02_r8,0.85659e-03_r8 /)
      kao(:, 4, 9, 5) = (/ &
        & 0.27713e-04_r8,0.98903e-03_r8,0.14301e-02_r8,0.17523e-02_r8,0.19862e-02_r8, &
        & 0.21079e-02_r8,0.20944e-02_r8,0.18656e-02_r8,0.90655e-03_r8 /)
      kao(:, 5, 9, 5) = (/ &
        & 0.29821e-04_r8,0.10207e-02_r8,0.14813e-02_r8,0.18163e-02_r8,0.20570e-02_r8, &
        & 0.21737e-02_r8,0.21574e-02_r8,0.19153e-02_r8,0.94882e-03_r8 /)
      kao(:, 1,10, 5) = (/ &
        & 0.14455e-04_r8,0.69508e-03_r8,0.10143e-02_r8,0.12382e-02_r8,0.13977e-02_r8, &
        & 0.15101e-02_r8,0.15339e-02_r8,0.13794e-02_r8,0.60064e-03_r8 /)
      kao(:, 2,10, 5) = (/ &
        & 0.16975e-04_r8,0.74055e-03_r8,0.10715e-02_r8,0.13117e-02_r8,0.14851e-02_r8, &
        & 0.15938e-02_r8,0.16026e-02_r8,0.14354e-02_r8,0.65034e-03_r8 /)
      kao(:, 3,10, 5) = (/ &
        & 0.19421e-04_r8,0.77996e-03_r8,0.11243e-02_r8,0.13791e-02_r8,0.15636e-02_r8, &
        & 0.16707e-02_r8,0.16678e-02_r8,0.14908e-02_r8,0.69875e-03_r8 /)
      kao(:, 4,10, 5) = (/ &
        & 0.21659e-04_r8,0.81369e-03_r8,0.11746e-02_r8,0.14408e-02_r8,0.16340e-02_r8, &
        & 0.17376e-02_r8,0.17267e-02_r8,0.15418e-02_r8,0.74336e-03_r8 /)
      kao(:, 5,10, 5) = (/ &
        & 0.23616e-04_r8,0.84316e-03_r8,0.12215e-02_r8,0.14972e-02_r8,0.16971e-02_r8, &
        & 0.17945e-02_r8,0.17834e-02_r8,0.15844e-02_r8,0.78045e-03_r8 /)
      kao(:, 1,11, 5) = (/ &
        & 0.11812e-04_r8,0.58067e-03_r8,0.84658e-03_r8,0.10349e-02_r8,0.11681e-02_r8, &
        & 0.12622e-02_r8,0.12806e-02_r8,0.11518e-02_r8,0.50197e-03_r8 /)
      kao(:, 2,11, 5) = (/ &
        & 0.13870e-04_r8,0.61870e-03_r8,0.89364e-03_r8,0.10957e-02_r8,0.12411e-02_r8, &
        & 0.13307e-02_r8,0.13366e-02_r8,0.11990e-02_r8,0.54419e-03_r8 /)
      kao(:, 3,11, 5) = (/ &
        & 0.15872e-04_r8,0.65131e-03_r8,0.93843e-03_r8,0.11520e-02_r8,0.13068e-02_r8, &
        & 0.13966e-02_r8,0.13927e-02_r8,0.12459e-02_r8,0.58412e-03_r8 /)
      kao(:, 4,11, 5) = (/ &
        & 0.17706e-04_r8,0.67957e-03_r8,0.98128e-03_r8,0.12037e-02_r8,0.13653e-02_r8, &
        & 0.14510e-02_r8,0.14423e-02_r8,0.12873e-02_r8,0.62086e-03_r8 /)
      kao(:, 5,11, 5) = (/ &
        & 0.19307e-04_r8,0.70477e-03_r8,0.10208e-02_r8,0.12522e-02_r8,0.14187e-02_r8, &
        & 0.15000e-02_r8,0.14882e-02_r8,0.13223e-02_r8,0.65273e-03_r8 /)
      kao(:, 1,12, 5) = (/ &
        & 0.96633e-05_r8,0.48384e-03_r8,0.70464e-03_r8,0.86214e-03_r8,0.97325e-03_r8, &
        & 0.10525e-02_r8,0.10661e-02_r8,0.95818e-03_r8,0.41838e-03_r8 /)
      kao(:, 2,12, 5) = (/ &
        & 0.11346e-04_r8,0.51544e-03_r8,0.74375e-03_r8,0.91255e-03_r8,0.10346e-02_r8, &
        & 0.11088e-02_r8,0.11124e-02_r8,0.99787e-03_r8,0.45436e-03_r8 /)
      kao(:, 3,12, 5) = (/ &
        & 0.12983e-04_r8,0.54258e-03_r8,0.78191e-03_r8,0.95994e-03_r8,0.10893e-02_r8, &
        & 0.11636e-02_r8,0.11595e-02_r8,0.10379e-02_r8,0.48767e-03_r8 /)
      kao(:, 4,12, 5) = (/ &
        & 0.14483e-04_r8,0.56662e-03_r8,0.81795e-03_r8,0.10036e-02_r8,0.11385e-02_r8, &
        & 0.12091e-02_r8,0.12012e-02_r8,0.10707e-02_r8,0.51810e-03_r8 /)
      kao(:, 5,12, 5) = (/ &
        & 0.15790e-04_r8,0.58805e-03_r8,0.85165e-03_r8,0.10447e-02_r8,0.11830e-02_r8, &
        & 0.12500e-02_r8,0.12389e-02_r8,0.11012e-02_r8,0.54508e-03_r8 /)
      kao(:, 1,13, 5) = (/ &
        & 0.79057e-05_r8,0.40215e-03_r8,0.58516e-03_r8,0.71666e-03_r8,0.80969e-03_r8, &
        & 0.87518e-03_r8,0.88581e-03_r8,0.79569e-03_r8,0.34825e-03_r8 /)
      kao(:, 2,13, 5) = (/ &
        & 0.92808e-05_r8,0.42853e-03_r8,0.61818e-03_r8,0.75847e-03_r8,0.86082e-03_r8, &
        & 0.92160e-03_r8,0.92436e-03_r8,0.82894e-03_r8,0.37871e-03_r8 /)
      kao(:, 3,13, 5) = (/ &
        & 0.10621e-04_r8,0.45134e-03_r8,0.65028e-03_r8,0.79815e-03_r8,0.90622e-03_r8, &
        & 0.96752e-03_r8,0.96291e-03_r8,0.86177e-03_r8,0.40642e-03_r8 /)
      kao(:, 4,13, 5) = (/ &
        & 0.11849e-04_r8,0.47161e-03_r8,0.68090e-03_r8,0.83530e-03_r8,0.94770e-03_r8, &
        & 0.10054e-02_r8,0.99815e-03_r8,0.88908e-03_r8,0.43149e-03_r8 /)
      kao(:, 5,13, 5) = (/ &
        & 0.12897e-04_r8,0.49000e-03_r8,0.70944e-03_r8,0.86982e-03_r8,0.98430e-03_r8, &
        & 0.10398e-02_r8,0.10297e-02_r8,0.91483e-03_r8,0.45459e-03_r8 /)
      kao(:, 1, 1, 6) = (/ &
        & 0.23575e-02_r8,0.96457e-02_r8,0.13128e-01_r8,0.15361e-01_r8,0.16662e-01_r8, &
        & 0.16999e-01_r8,0.16303e-01_r8,0.14368e-01_r8,0.10185e-01_r8 /)
      kao(:, 2, 1, 6) = (/ &
        & 0.24508e-02_r8,0.99768e-02_r8,0.13562e-01_r8,0.15786e-01_r8,0.17046e-01_r8, &
        & 0.17316e-01_r8,0.16539e-01_r8,0.14627e-01_r8,0.10447e-01_r8 /)
      kao(:, 3, 1, 6) = (/ &
        & 0.25176e-02_r8,0.10262e-01_r8,0.13947e-01_r8,0.16182e-01_r8,0.17390e-01_r8, &
        & 0.17588e-01_r8,0.16752e-01_r8,0.14857e-01_r8,0.10699e-01_r8 /)
      kao(:, 4, 1, 6) = (/ &
        & 0.25627e-02_r8,0.10510e-01_r8,0.14271e-01_r8,0.16517e-01_r8,0.17678e-01_r8, &
        & 0.17815e-01_r8,0.16941e-01_r8,0.15073e-01_r8,0.10970e-01_r8 /)
      kao(:, 5, 1, 6) = (/ &
        & 0.25904e-02_r8,0.10712e-01_r8,0.14528e-01_r8,0.16788e-01_r8,0.17912e-01_r8, &
        & 0.18013e-01_r8,0.17126e-01_r8,0.15282e-01_r8,0.11215e-01_r8 /)
      kao(:, 1, 2, 6) = (/ &
        & 0.19422e-02_r8,0.85179e-02_r8,0.11603e-01_r8,0.13561e-01_r8,0.14694e-01_r8, &
        & 0.14952e-01_r8,0.14274e-01_r8,0.12616e-01_r8,0.86910e-02_r8 /)
      kao(:, 2, 2, 6) = (/ &
        & 0.20231e-02_r8,0.88208e-02_r8,0.11992e-01_r8,0.13942e-01_r8,0.15043e-01_r8, &
        & 0.15241e-01_r8,0.14503e-01_r8,0.12849e-01_r8,0.89203e-02_r8 /)
      kao(:, 3, 2, 6) = (/ &
        & 0.20824e-02_r8,0.90892e-02_r8,0.12333e-01_r8,0.14283e-01_r8,0.15343e-01_r8, &
        & 0.15493e-01_r8,0.14704e-01_r8,0.13065e-01_r8,0.91412e-02_r8 /)
      kao(:, 4, 2, 6) = (/ &
        & 0.21235e-02_r8,0.93193e-02_r8,0.12613e-01_r8,0.14573e-01_r8,0.15586e-01_r8, &
        & 0.15696e-01_r8,0.14900e-01_r8,0.13269e-01_r8,0.93731e-02_r8 /)
      kao(:, 5, 2, 6) = (/ &
        & 0.21501e-02_r8,0.95064e-02_r8,0.12844e-01_r8,0.14802e-01_r8,0.15789e-01_r8, &
        & 0.15872e-01_r8,0.15079e-01_r8,0.13459e-01_r8,0.95922e-02_r8 /)
      kao(:, 1, 3, 6) = (/ &
        & 0.15710e-02_r8,0.73739e-02_r8,0.10084e-01_r8,0.11795e-01_r8,0.12791e-01_r8, &
        & 0.13002e-01_r8,0.12408e-01_r8,0.10948e-01_r8,0.73256e-02_r8 /)
      kao(:, 2, 3, 6) = (/ &
        & 0.16445e-02_r8,0.76603e-02_r8,0.10441e-01_r8,0.12136e-01_r8,0.13098e-01_r8, &
        & 0.13272e-01_r8,0.12629e-01_r8,0.11169e-01_r8,0.75277e-02_r8 /)
      kao(:, 3, 3, 6) = (/ &
        & 0.17016e-02_r8,0.79120e-02_r8,0.10738e-01_r8,0.12444e-01_r8,0.13365e-01_r8, &
        & 0.13502e-01_r8,0.12827e-01_r8,0.11365e-01_r8,0.77275e-02_r8 /)
      kao(:, 4, 3, 6) = (/ &
        & 0.17419e-02_r8,0.81204e-02_r8,0.10992e-01_r8,0.12704e-01_r8,0.13579e-01_r8, &
        & 0.13687e-01_r8,0.13022e-01_r8,0.11565e-01_r8,0.79327e-02_r8 /)
      kao(:, 5, 3, 6) = (/ &
        & 0.17693e-02_r8,0.82896e-02_r8,0.11201e-01_r8,0.12903e-01_r8,0.13761e-01_r8, &
        & 0.13854e-01_r8,0.13193e-01_r8,0.11760e-01_r8,0.81324e-02_r8 /)
      kao(:, 1, 4, 6) = (/ &
        & 0.12568e-02_r8,0.62925e-02_r8,0.86570e-02_r8,0.10156e-01_r8,0.11020e-01_r8, &
        & 0.11220e-01_r8,0.10710e-01_r8,0.94329e-02_r8,0.61812e-02_r8 /)
      kao(:, 2, 4, 6) = (/ &
        & 0.13242e-02_r8,0.65532e-02_r8,0.89756e-02_r8,0.10460e-01_r8,0.11292e-01_r8, &
        & 0.11463e-01_r8,0.10924e-01_r8,0.96449e-02_r8,0.63620e-02_r8 /)
      kao(:, 3, 4, 6) = (/ &
        & 0.13782e-02_r8,0.67807e-02_r8,0.92447e-02_r8,0.10739e-01_r8,0.11531e-01_r8, &
        & 0.11676e-01_r8,0.11115e-01_r8,0.98384e-02_r8,0.65417e-02_r8 /)
      kao(:, 4, 4, 6) = (/ &
        & 0.14185e-02_r8,0.69728e-02_r8,0.94724e-02_r8,0.10967e-01_r8,0.11732e-01_r8, &
        & 0.11853e-01_r8,0.11299e-01_r8,0.10029e-01_r8,0.67314e-02_r8 /)
      kao(:, 5, 4, 6) = (/ &
        & 0.14466e-02_r8,0.71294e-02_r8,0.96551e-02_r8,0.11150e-01_r8,0.11897e-01_r8, &
        & 0.12003e-01_r8,0.11457e-01_r8,0.10212e-01_r8,0.69134e-02_r8 /)
      kao(:, 1, 5, 6) = (/ &
        & 0.99815e-03_r8,0.53184e-02_r8,0.73668e-02_r8,0.86661e-02_r8,0.94189e-02_r8, &
        & 0.96088e-02_r8,0.91860e-02_r8,0.80854e-02_r8,0.52147e-02_r8 /)
      kao(:, 2, 5, 6) = (/ &
        & 0.10594e-02_r8,0.55502e-02_r8,0.76480e-02_r8,0.89382e-02_r8,0.96675e-02_r8, &
        & 0.98281e-02_r8,0.93908e-02_r8,0.82904e-02_r8,0.53805e-02_r8 /)
      kao(:, 3, 5, 6) = (/ &
        & 0.11093e-02_r8,0.57534e-02_r8,0.78820e-02_r8,0.91873e-02_r8,0.98860e-02_r8, &
        & 0.10027e-01_r8,0.95739e-02_r8,0.84774e-02_r8,0.55398e-02_r8 /)
      kao(:, 4, 5, 6) = (/ &
        & 0.11487e-02_r8,0.59264e-02_r8,0.80746e-02_r8,0.93952e-02_r8,0.10070e-01_r8, &
        & 0.10196e-01_r8,0.97460e-02_r8,0.86586e-02_r8,0.57118e-02_r8 /)
      kao(:, 5, 5, 6) = (/ &
        & 0.11770e-02_r8,0.60715e-02_r8,0.82322e-02_r8,0.95590e-02_r8,0.10225e-01_r8, &
        & 0.10337e-01_r8,0.98891e-02_r8,0.88282e-02_r8,0.58756e-02_r8 /)
      kao(:, 1, 6, 6) = (/ &
        & 0.78484e-03_r8,0.44557e-02_r8,0.62088e-02_r8,0.73238e-02_r8,0.79758e-02_r8, &
        & 0.81565e-02_r8,0.78234e-02_r8,0.68949e-02_r8,0.43721e-02_r8 /)
      kao(:, 2, 6, 6) = (/ &
        & 0.84104e-03_r8,0.46584e-02_r8,0.64548e-02_r8,0.75720e-02_r8,0.82049e-02_r8, &
        & 0.83603e-02_r8,0.80139e-02_r8,0.70912e-02_r8,0.45208e-02_r8 /)
      kao(:, 3, 6, 6) = (/ &
        & 0.88703e-03_r8,0.48386e-02_r8,0.66585e-02_r8,0.77939e-02_r8,0.84077e-02_r8, &
        & 0.85494e-02_r8,0.81878e-02_r8,0.72673e-02_r8,0.46664e-02_r8 /)
      kao(:, 4, 6, 6) = (/ &
        & 0.92429e-03_r8,0.49939e-02_r8,0.68255e-02_r8,0.79793e-02_r8,0.85811e-02_r8, &
        & 0.87123e-02_r8,0.83423e-02_r8,0.74324e-02_r8,0.48193e-02_r8 /)
      kao(:, 5, 6, 6) = (/ &
        & 0.95287e-03_r8,0.51269e-02_r8,0.69664e-02_r8,0.81216e-02_r8,0.87256e-02_r8, &
        & 0.88404e-02_r8,0.84793e-02_r8,0.75885e-02_r8,0.49684e-02_r8 /)
      kao(:, 1, 7, 6) = (/ &
        & 0.61176e-03_r8,0.37105e-02_r8,0.51921e-02_r8,0.61495e-02_r8,0.67086e-02_r8, &
        & 0.68737e-02_r8,0.66196e-02_r8,0.58499e-02_r8,0.36398e-02_r8 /)
      kao(:, 2, 7, 6) = (/ &
        & 0.66355e-03_r8,0.38845e-02_r8,0.54092e-02_r8,0.63684e-02_r8,0.69191e-02_r8, &
        & 0.70638e-02_r8,0.67967e-02_r8,0.60329e-02_r8,0.37725e-02_r8 /)
      kao(:, 3, 7, 6) = (/ &
        & 0.70584e-03_r8,0.40429e-02_r8,0.55891e-02_r8,0.65665e-02_r8,0.71061e-02_r8, &
        & 0.72392e-02_r8,0.69566e-02_r8,0.61958e-02_r8,0.39040e-02_r8 /)
      kao(:, 4, 7, 6) = (/ &
        & 0.74016e-03_r8,0.41804e-02_r8,0.57362e-02_r8,0.67306e-02_r8,0.72656e-02_r8, &
        & 0.73939e-02_r8,0.71002e-02_r8,0.63458e-02_r8,0.40422e-02_r8 /)
      kao(:, 5, 7, 6) = (/ &
        & 0.76793e-03_r8,0.43013e-02_r8,0.58634e-02_r8,0.68605e-02_r8,0.73917e-02_r8, &
        & 0.75160e-02_r8,0.72292e-02_r8,0.64867e-02_r8,0.41753e-02_r8 /)
      kao(:, 1, 8, 6) = (/ &
        & 0.47383e-03_r8,0.30719e-02_r8,0.43157e-02_r8,0.51299e-02_r8,0.56113e-02_r8, &
        & 0.57604e-02_r8,0.55584e-02_r8,0.49263e-02_r8,0.30099e-02_r8 /)
      kao(:, 2, 8, 6) = (/ &
        & 0.52030e-03_r8,0.32224e-02_r8,0.45088e-02_r8,0.53256e-02_r8,0.58049e-02_r8, &
        & 0.59369e-02_r8,0.57249e-02_r8,0.50950e-02_r8,0.31335e-02_r8 /)
      kao(:, 3, 8, 6) = (/ &
        & 0.55897e-03_r8,0.33601e-02_r8,0.46690e-02_r8,0.55008e-02_r8,0.59733e-02_r8, &
        & 0.60982e-02_r8,0.58703e-02_r8,0.52416e-02_r8,0.32505e-02_r8 /)
      kao(:, 4, 8, 6) = (/ &
        & 0.59051e-03_r8,0.34823e-02_r8,0.48003e-02_r8,0.56492e-02_r8,0.61147e-02_r8, &
        & 0.62407e-02_r8,0.60011e-02_r8,0.53776e-02_r8,0.33691e-02_r8 /)
      kao(:, 5, 8, 6) = (/ &
        & 0.61638e-03_r8,0.35908e-02_r8,0.49151e-02_r8,0.57682e-02_r8,0.62269e-02_r8, &
        & 0.63505e-02_r8,0.61226e-02_r8,0.55061e-02_r8,0.34893e-02_r8 /)
      kao(:, 1, 9, 6) = (/ &
        & 0.36452e-03_r8,0.25301e-02_r8,0.35655e-02_r8,0.42558e-02_r8,0.46668e-02_r8, &
        & 0.47995e-02_r8,0.46391e-02_r8,0.41176e-02_r8,0.24723e-02_r8 /)
      kao(:, 2, 9, 6) = (/ &
        & 0.40521e-03_r8,0.26609e-02_r8,0.37368e-02_r8,0.44313e-02_r8,0.48422e-02_r8, &
        & 0.49605e-02_r8,0.47876e-02_r8,0.42682e-02_r8,0.25854e-02_r8 /)
      kao(:, 3, 9, 6) = (/ &
        & 0.44042e-03_r8,0.27811e-02_r8,0.38822e-02_r8,0.45871e-02_r8,0.49951e-02_r8, &
        & 0.51048e-02_r8,0.49189e-02_r8,0.43988e-02_r8,0.26922e-02_r8 /)
      kao(:, 4, 9, 6) = (/ &
        & 0.46934e-03_r8,0.28890e-02_r8,0.40015e-02_r8,0.47204e-02_r8,0.51195e-02_r8, &
        & 0.52329e-02_r8,0.50398e-02_r8,0.45211e-02_r8,0.27947e-02_r8 /)
      kao(:, 5, 9, 6) = (/ &
        & 0.49296e-03_r8,0.29863e-02_r8,0.41052e-02_r8,0.48296e-02_r8,0.52212e-02_r8, &
        & 0.53320e-02_r8,0.51516e-02_r8,0.46410e-02_r8,0.29014e-02_r8 /)
      kao(:, 1,10, 6) = (/ &
        & 0.28141e-03_r8,0.20839e-02_r8,0.29434e-02_r8,0.35250e-02_r8,0.38705e-02_r8, &
        & 0.39907e-02_r8,0.38574e-02_r8,0.34280e-02_r8,0.20276e-02_r8 /)
      kao(:, 2,10, 6) = (/ &
        & 0.31642e-03_r8,0.21962e-02_r8,0.30947e-02_r8,0.36798e-02_r8,0.40279e-02_r8, &
        & 0.41317e-02_r8,0.39905e-02_r8,0.35591e-02_r8,0.21304e-02_r8 /)
      kao(:, 3,10, 6) = (/ &
        & 0.34743e-03_r8,0.23002e-02_r8,0.32251e-02_r8,0.38167e-02_r8,0.41632e-02_r8, &
        & 0.42588e-02_r8,0.41077e-02_r8,0.36737e-02_r8,0.22246e-02_r8 /)
      kao(:, 4,10, 6) = (/ &
        & 0.37337e-03_r8,0.23958e-02_r8,0.33326e-02_r8,0.39351e-02_r8,0.42727e-02_r8, &
        & 0.43699e-02_r8,0.42167e-02_r8,0.37850e-02_r8,0.23171e-02_r8 /)
      kao(:, 5,10, 6) = (/ &
        & 0.39464e-03_r8,0.24818e-02_r8,0.34245e-02_r8,0.40341e-02_r8,0.43635e-02_r8, &
        & 0.44592e-02_r8,0.43133e-02_r8,0.38931e-02_r8,0.24123e-02_r8 /)
      kao(:, 1,11, 6) = (/ &
        & 0.23046e-03_r8,0.17561e-02_r8,0.24821e-02_r8,0.29697e-02_r8,0.32603e-02_r8, &
        & 0.33590e-02_r8,0.32465e-02_r8,0.28911e-02_r8,0.17000e-02_r8 /)
      kao(:, 2,11, 6) = (/ &
        & 0.25900e-03_r8,0.18499e-02_r8,0.26079e-02_r8,0.30983e-02_r8,0.33914e-02_r8, &
        & 0.34790e-02_r8,0.33598e-02_r8,0.30000e-02_r8,0.17879e-02_r8 /)
      kao(:, 3,11, 6) = (/ &
        & 0.28431e-03_r8,0.19371e-02_r8,0.27154e-02_r8,0.32123e-02_r8,0.35009e-02_r8, &
        & 0.35810e-02_r8,0.34582e-02_r8,0.30989e-02_r8,0.18709e-02_r8 /)
      kao(:, 4,11, 6) = (/ &
        & 0.30554e-03_r8,0.20175e-02_r8,0.28047e-02_r8,0.33094e-02_r8,0.35897e-02_r8, &
        & 0.36708e-02_r8,0.35500e-02_r8,0.31964e-02_r8,0.19524e-02_r8 /)
      kao(:, 5,11, 6) = (/ &
        & 0.32290e-03_r8,0.20906e-02_r8,0.28827e-02_r8,0.33907e-02_r8,0.36638e-02_r8, &
        & 0.37448e-02_r8,0.36322e-02_r8,0.32921e-02_r8,0.20342e-02_r8 /)
      kao(:, 1,12, 6) = (/ &
        & 0.18873e-03_r8,0.14753e-02_r8,0.20859e-02_r8,0.24932e-02_r8,0.27362e-02_r8, &
        & 0.28163e-02_r8,0.27231e-02_r8,0.24287e-02_r8,0.14226e-02_r8 /)
      kao(:, 2,12, 6) = (/ &
        & 0.21206e-03_r8,0.15542e-02_r8,0.21905e-02_r8,0.25997e-02_r8,0.28436e-02_r8, &
        & 0.29146e-02_r8,0.28182e-02_r8,0.25196e-02_r8,0.14964e-02_r8 /)
      kao(:, 3,12, 6) = (/ &
        & 0.23271e-03_r8,0.16282e-02_r8,0.22789e-02_r8,0.26937e-02_r8,0.29320e-02_r8, &
        & 0.29995e-02_r8,0.29004e-02_r8,0.26063e-02_r8,0.15684e-02_r8 /)
      kao(:, 4,12, 6) = (/ &
        & 0.25005e-03_r8,0.16959e-02_r8,0.23539e-02_r8,0.27739e-02_r8,0.30052e-02_r8, &
        & 0.30738e-02_r8,0.29781e-02_r8,0.26924e-02_r8,0.16388e-02_r8 /)
      kao(:, 5,12, 6) = (/ &
        & 0.26424e-03_r8,0.17579e-02_r8,0.24198e-02_r8,0.28418e-02_r8,0.30688e-02_r8, &
        & 0.31370e-02_r8,0.30478e-02_r8,0.27734e-02_r8,0.17090e-02_r8 /)
      kao(:, 1,13, 6) = (/ &
        & 0.15451e-03_r8,0.12362e-02_r8,0.17471e-02_r8,0.20856e-02_r8,0.22870e-02_r8, &
        & 0.23530e-02_r8,0.22758e-02_r8,0.20318e-02_r8,0.11868e-02_r8 /)
      kao(:, 2,13, 6) = (/ &
        & 0.17357e-03_r8,0.13027e-02_r8,0.18337e-02_r8,0.21736e-02_r8,0.23752e-02_r8, &
        & 0.24339e-02_r8,0.23549e-02_r8,0.21104e-02_r8,0.12492e-02_r8 /)
      kao(:, 3,13, 6) = (/ &
        & 0.19045e-03_r8,0.13651e-02_r8,0.19071e-02_r8,0.22520e-02_r8,0.24479e-02_r8, &
        & 0.25052e-02_r8,0.24255e-02_r8,0.21862e-02_r8,0.13114e-02_r8 /)
      kao(:, 4,13, 6) = (/ &
        & 0.20459e-03_r8,0.14225e-02_r8,0.19702e-02_r8,0.23195e-02_r8,0.25109e-02_r8, &
        & 0.25680e-02_r8,0.24906e-02_r8,0.22592e-02_r8,0.13717e-02_r8 /)
      kao(:, 5,13, 6) = (/ &
        & 0.21621e-03_r8,0.14751e-02_r8,0.20267e-02_r8,0.23775e-02_r8,0.25654e-02_r8, &
        & 0.26221e-02_r8,0.25513e-02_r8,0.23283e-02_r8,0.14321e-02_r8 /)
      kao(:, 1, 1, 7) = (/ &
        & 0.14551e-01_r8,0.26282e-01_r8,0.32053e-01_r8,0.35189e-01_r8,0.36600e-01_r8, &
        & 0.36646e-01_r8,0.35552e-01_r8,0.33215e-01_r8,0.27309e-01_r8 /)
      kao(:, 2, 1, 7) = (/ &
        & 0.15360e-01_r8,0.26847e-01_r8,0.32411e-01_r8,0.35426e-01_r8,0.36803e-01_r8, &
        & 0.36994e-01_r8,0.36037e-01_r8,0.33674e-01_r8,0.27881e-01_r8 /)
      kao(:, 3, 1, 7) = (/ &
        & 0.16052e-01_r8,0.27358e-01_r8,0.32711e-01_r8,0.35602e-01_r8,0.37002e-01_r8, &
        & 0.37322e-01_r8,0.36495e-01_r8,0.34092e-01_r8,0.28365e-01_r8 /)
      kao(:, 4, 1, 7) = (/ &
        & 0.16634e-01_r8,0.27765e-01_r8,0.32975e-01_r8,0.35757e-01_r8,0.37198e-01_r8, &
        & 0.37629e-01_r8,0.36871e-01_r8,0.34489e-01_r8,0.28817e-01_r8 /)
      kao(:, 5, 1, 7) = (/ &
        & 0.17092e-01_r8,0.28088e-01_r8,0.33173e-01_r8,0.35899e-01_r8,0.37369e-01_r8, &
        & 0.37894e-01_r8,0.37206e-01_r8,0.34856e-01_r8,0.29236e-01_r8 /)
      kao(:, 1, 2, 7) = (/ &
        & 0.12675e-01_r8,0.23757e-01_r8,0.28827e-01_r8,0.31475e-01_r8,0.32647e-01_r8, &
        & 0.32779e-01_r8,0.31874e-01_r8,0.29659e-01_r8,0.23735e-01_r8 /)
      kao(:, 2, 2, 7) = (/ &
        & 0.13363e-01_r8,0.24261e-01_r8,0.29165e-01_r8,0.31734e-01_r8,0.32905e-01_r8, &
        & 0.33137e-01_r8,0.32357e-01_r8,0.30114e-01_r8,0.24241e-01_r8 /)
      kao(:, 3, 2, 7) = (/ &
        & 0.13952e-01_r8,0.24673e-01_r8,0.29458e-01_r8,0.31940e-01_r8,0.33167e-01_r8, &
        & 0.33486e-01_r8,0.32794e-01_r8,0.30540e-01_r8,0.24704e-01_r8 /)
      kao(:, 4, 2, 7) = (/ &
        & 0.14440e-01_r8,0.25010e-01_r8,0.29692e-01_r8,0.32131e-01_r8,0.33402e-01_r8, &
        & 0.33816e-01_r8,0.33185e-01_r8,0.30944e-01_r8,0.25123e-01_r8 /)
      kao(:, 5, 2, 7) = (/ &
        & 0.14810e-01_r8,0.25246e-01_r8,0.29865e-01_r8,0.32323e-01_r8,0.33624e-01_r8, &
        & 0.34125e-01_r8,0.33530e-01_r8,0.31299e-01_r8,0.25501e-01_r8 /)
      kao(:, 1, 3, 7) = (/ &
        & 0.10764e-01_r8,0.21180e-01_r8,0.25645e-01_r8,0.27934e-01_r8,0.28891e-01_r8, &
        & 0.28978e-01_r8,0.28215e-01_r8,0.26250e-01_r8,0.20340e-01_r8 /)
      kao(:, 2, 3, 7) = (/ &
        & 0.11371e-01_r8,0.21611e-01_r8,0.25976e-01_r8,0.28221e-01_r8,0.29204e-01_r8, &
        & 0.29347e-01_r8,0.28689e-01_r8,0.26687e-01_r8,0.20803e-01_r8 /)
      kao(:, 3, 3, 7) = (/ &
        & 0.11882e-01_r8,0.21977e-01_r8,0.26258e-01_r8,0.28467e-01_r8,0.29498e-01_r8, &
        & 0.29730e-01_r8,0.29113e-01_r8,0.27115e-01_r8,0.21241e-01_r8 /)
      kao(:, 4, 3, 7) = (/ &
        & 0.12302e-01_r8,0.22273e-01_r8,0.26477e-01_r8,0.28696e-01_r8,0.29766e-01_r8, &
        & 0.30099e-01_r8,0.29507e-01_r8,0.27503e-01_r8,0.21620e-01_r8 /)
      kao(:, 5, 3, 7) = (/ &
        & 0.12624e-01_r8,0.22481e-01_r8,0.26631e-01_r8,0.28900e-01_r8,0.30032e-01_r8, &
        & 0.30425e-01_r8,0.29859e-01_r8,0.27842e-01_r8,0.21966e-01_r8 /)
      kao(:, 1, 4, 7) = (/ &
        & 0.89860e-02_r8,0.18659e-01_r8,0.22605e-01_r8,0.24580e-01_r8,0.25383e-01_r8, &
        & 0.25435e-01_r8,0.24761e-01_r8,0.23037e-01_r8,0.17414e-01_r8 /)
      kao(:, 2, 4, 7) = (/ &
        & 0.95207e-02_r8,0.19048e-01_r8,0.22924e-01_r8,0.24888e-01_r8,0.25739e-01_r8, &
        & 0.25823e-01_r8,0.25200e-01_r8,0.23450e-01_r8,0.17847e-01_r8 /)
      kao(:, 3, 4, 7) = (/ &
        & 0.99723e-02_r8,0.19380e-01_r8,0.23182e-01_r8,0.25155e-01_r8,0.26061e-01_r8, &
        & 0.26209e-01_r8,0.25611e-01_r8,0.23862e-01_r8,0.18251e-01_r8 /)
      kao(:, 4, 4, 7) = (/ &
        & 0.10354e-01_r8,0.19644e-01_r8,0.23397e-01_r8,0.25401e-01_r8,0.26345e-01_r8, &
        & 0.26580e-01_r8,0.26000e-01_r8,0.24233e-01_r8,0.18600e-01_r8 /)
      kao(:, 5, 4, 7) = (/ &
        & 0.10637e-01_r8,0.19822e-01_r8,0.23556e-01_r8,0.25605e-01_r8,0.26619e-01_r8, &
        & 0.26913e-01_r8,0.26359e-01_r8,0.24562e-01_r8,0.18925e-01_r8 /)
      kao(:, 1, 5, 7) = (/ &
        & 0.74104e-02_r8,0.16264e-01_r8,0.19717e-01_r8,0.21452e-01_r8,0.22172e-01_r8, &
        & 0.22207e-01_r8,0.21598e-01_r8,0.20075e-01_r8,0.14880e-01_r8 /)
      kao(:, 2, 5, 7) = (/ &
        & 0.78778e-02_r8,0.16624e-01_r8,0.20022e-01_r8,0.21765e-01_r8,0.22531e-01_r8, &
        & 0.22596e-01_r8,0.21999e-01_r8,0.20458e-01_r8,0.15279e-01_r8 /)
      kao(:, 3, 5, 7) = (/ &
        & 0.82694e-02_r8,0.16928e-01_r8,0.20277e-01_r8,0.22036e-01_r8,0.22859e-01_r8, &
        & 0.22978e-01_r8,0.22384e-01_r8,0.20834e-01_r8,0.15650e-01_r8 /)
      kao(:, 4, 5, 7) = (/ &
        & 0.85919e-02_r8,0.17168e-01_r8,0.20498e-01_r8,0.22274e-01_r8,0.23143e-01_r8, &
        & 0.23326e-01_r8,0.22754e-01_r8,0.21189e-01_r8,0.15980e-01_r8 /)
      kao(:, 5, 5, 7) = (/ &
        & 0.88337e-02_r8,0.17332e-01_r8,0.20664e-01_r8,0.22477e-01_r8,0.23407e-01_r8, &
        & 0.23648e-01_r8,0.23111e-01_r8,0.21509e-01_r8,0.16283e-01_r8 /)
      kao(:, 1, 6, 7) = (/ &
        & 0.60305e-02_r8,0.14008e-01_r8,0.17028e-01_r8,0.18574e-01_r8,0.19236e-01_r8, &
        & 0.19269e-01_r8,0.18720e-01_r8,0.17347e-01_r8,0.12656e-01_r8 /)
      kao(:, 2, 6, 7) = (/ &
        & 0.64356e-02_r8,0.14339e-01_r8,0.17318e-01_r8,0.18872e-01_r8,0.19580e-01_r8, &
        & 0.19645e-01_r8,0.19095e-01_r8,0.17705e-01_r8,0.13025e-01_r8 /)
      kao(:, 3, 6, 7) = (/ &
        & 0.67708e-02_r8,0.14626e-01_r8,0.17575e-01_r8,0.19135e-01_r8,0.19883e-01_r8, &
        & 0.20004e-01_r8,0.19454e-01_r8,0.18055e-01_r8,0.13366e-01_r8 /)
      kao(:, 4, 6, 7) = (/ &
        & 0.70449e-02_r8,0.14853e-01_r8,0.17795e-01_r8,0.19363e-01_r8,0.20156e-01_r8, &
        & 0.20324e-01_r8,0.19811e-01_r8,0.18392e-01_r8,0.13679e-01_r8 /)
      kao(:, 5, 6, 7) = (/ &
        & 0.72586e-02_r8,0.15014e-01_r8,0.17954e-01_r8,0.19569e-01_r8,0.20401e-01_r8, &
        & 0.20622e-01_r8,0.20155e-01_r8,0.18706e-01_r8,0.13963e-01_r8 /)
      kao(:, 1, 7, 7) = (/ &
        & 0.48615e-02_r8,0.11936e-01_r8,0.14574e-01_r8,0.15963e-01_r8,0.16578e-01_r8, &
        & 0.16615e-01_r8,0.16125e-01_r8,0.14904e-01_r8,0.10718e-01_r8 /)
      kao(:, 2, 7, 7) = (/ &
        & 0.52093e-02_r8,0.12247e-01_r8,0.14845e-01_r8,0.16239e-01_r8,0.16890e-01_r8, &
        & 0.16965e-01_r8,0.16477e-01_r8,0.15238e-01_r8,0.11050e-01_r8 /)
      kao(:, 3, 7, 7) = (/ &
        & 0.54981e-02_r8,0.12520e-01_r8,0.15089e-01_r8,0.16485e-01_r8,0.17163e-01_r8, &
        & 0.17296e-01_r8,0.16823e-01_r8,0.15561e-01_r8,0.11367e-01_r8 /)
      kao(:, 4, 7, 7) = (/ &
        & 0.57341e-02_r8,0.12732e-01_r8,0.15302e-01_r8,0.16709e-01_r8,0.17412e-01_r8, &
        & 0.17587e-01_r8,0.17156e-01_r8,0.15882e-01_r8,0.11657e-01_r8 /)
      kao(:, 5, 7, 7) = (/ &
        & 0.59245e-02_r8,0.12879e-01_r8,0.15460e-01_r8,0.16900e-01_r8,0.17646e-01_r8, &
        & 0.17862e-01_r8,0.17475e-01_r8,0.16189e-01_r8,0.11924e-01_r8 /)
      kao(:, 1, 8, 7) = (/ &
        & 0.38903e-02_r8,0.10086e-01_r8,0.12393e-01_r8,0.13617e-01_r8,0.14179e-01_r8, &
        & 0.14230e-01_r8,0.13810e-01_r8,0.12741e-01_r8,0.90402e-02_r8 /)
      kao(:, 2, 8, 7) = (/ &
        & 0.41883e-02_r8,0.10379e-01_r8,0.12642e-01_r8,0.13866e-01_r8,0.14454e-01_r8, &
        & 0.14549e-01_r8,0.14140e-01_r8,0.13050e-01_r8,0.93407e-02_r8 /)
      kao(:, 3, 8, 7) = (/ &
        & 0.44374e-02_r8,0.10628e-01_r8,0.12866e-01_r8,0.14093e-01_r8,0.14702e-01_r8, &
        & 0.14847e-01_r8,0.14466e-01_r8,0.13354e-01_r8,0.96289e-02_r8 /)
      kao(:, 4, 8, 7) = (/ &
        & 0.46417e-02_r8,0.10823e-01_r8,0.13067e-01_r8,0.14297e-01_r8,0.14936e-01_r8, &
        & 0.15113e-01_r8,0.14777e-01_r8,0.13659e-01_r8,0.98946e-02_r8 /)
      kao(:, 5, 8, 7) = (/ &
        & 0.48106e-02_r8,0.10958e-01_r8,0.13212e-01_r8,0.14477e-01_r8,0.15155e-01_r8, &
        & 0.15369e-01_r8,0.15065e-01_r8,0.13954e-01_r8,0.10137e-01_r8 /)
      kao(:, 1, 9, 7) = (/ &
        & 0.30906e-02_r8,0.84716e-02_r8,0.10475e-01_r8,0.11533e-01_r8,0.12037e-01_r8, &
        & 0.12102e-01_r8,0.11757e-01_r8,0.10840e-01_r8,0.75790e-02_r8 /)
      kao(:, 2, 9, 7) = (/ &
        & 0.33456e-02_r8,0.87380e-02_r8,0.10698e-01_r8,0.11759e-01_r8,0.12281e-01_r8, &
        & 0.12384e-01_r8,0.12063e-01_r8,0.11124e-01_r8,0.78524e-02_r8 /)
      kao(:, 3, 9, 7) = (/ &
        & 0.35624e-02_r8,0.89636e-02_r8,0.10908e-01_r8,0.11964e-01_r8,0.12503e-01_r8, &
        & 0.12651e-01_r8,0.12366e-01_r8,0.11413e-01_r8,0.81116e-02_r8 /)
      kao(:, 4, 9, 7) = (/ &
        & 0.37409e-02_r8,0.91394e-02_r8,0.11085e-01_r8,0.12156e-01_r8,0.12717e-01_r8, &
        & 0.12895e-01_r8,0.12646e-01_r8,0.11703e-01_r8,0.83543e-02_r8 /)
      kao(:, 5, 9, 7) = (/ &
        & 0.38899e-02_r8,0.92663e-02_r8,0.11210e-01_r8,0.12323e-01_r8,0.12923e-01_r8, &
        & 0.13135e-01_r8,0.12909e-01_r8,0.11979e-01_r8,0.85748e-02_r8 /)
      kao(:, 1,10, 7) = (/ &
        & 0.24588e-02_r8,0.70997e-02_r8,0.88156e-02_r8,0.97280e-02_r8,0.10175e-01_r8, &
        & 0.10246e-01_r8,0.99712e-02_r8,0.91951e-02_r8,0.63324e-02_r8 /)
      kao(:, 2,10, 7) = (/ &
        & 0.26743e-02_r8,0.73393e-02_r8,0.90183e-02_r8,0.99289e-02_r8,0.10387e-01_r8, &
        & 0.10496e-01_r8,0.10249e-01_r8,0.94566e-02_r8,0.65770e-02_r8 /)
      kao(:, 3,10, 7) = (/ &
        & 0.28610e-02_r8,0.75352e-02_r8,0.92028e-02_r8,0.10117e-01_r8,0.10586e-01_r8, &
        & 0.10730e-01_r8,0.10524e-01_r8,0.97307e-02_r8,0.68077e-02_r8 /)
      kao(:, 4,10, 7) = (/ &
        & 0.30147e-02_r8,0.76899e-02_r8,0.93550e-02_r8,0.10291e-01_r8,0.10781e-01_r8, &
        & 0.10954e-01_r8,0.10778e-01_r8,0.10001e-01_r8,0.70201e-02_r8 /)
      kao(:, 5,10, 7) = (/ &
        & 0.31444e-02_r8,0.78050e-02_r8,0.94668e-02_r8,0.10433e-01_r8,0.10974e-01_r8, &
        & 0.11173e-01_r8,0.11019e-01_r8,0.10253e-01_r8,0.72189e-02_r8 /)
      kao(:, 1,11, 7) = (/ &
        & 0.20345e-02_r8,0.60249e-02_r8,0.74716e-02_r8,0.82496e-02_r8,0.86458e-02_r8, &
        & 0.87340e-02_r8,0.85222e-02_r8,0.78657e-02_r8,0.53714e-02_r8 /)
      kao(:, 2,11, 7) = (/ &
        & 0.22071e-02_r8,0.62176e-02_r8,0.76440e-02_r8,0.84251e-02_r8,0.88273e-02_r8, &
        & 0.89461e-02_r8,0.87689e-02_r8,0.81125e-02_r8,0.55835e-02_r8 /)
      kao(:, 3,11, 7) = (/ &
        & 0.23554e-02_r8,0.63729e-02_r8,0.77932e-02_r8,0.85868e-02_r8,0.90058e-02_r8, &
        & 0.91548e-02_r8,0.90075e-02_r8,0.83660e-02_r8,0.57827e-02_r8 /)
      kao(:, 4,11, 7) = (/ &
        & 0.24780e-02_r8,0.64944e-02_r8,0.79106e-02_r8,0.87291e-02_r8,0.91857e-02_r8, &
        & 0.93565e-02_r8,0.92302e-02_r8,0.86036e-02_r8,0.59695e-02_r8 /)
      kao(:, 5,11, 7) = (/ &
        & 0.25820e-02_r8,0.65802e-02_r8,0.79974e-02_r8,0.88427e-02_r8,0.93482e-02_r8, &
        & 0.95539e-02_r8,0.94443e-02_r8,0.88180e-02_r8,0.61512e-02_r8 /)
      kao(:, 1,12, 7) = (/ &
        & 0.16789e-02_r8,0.50906e-02_r8,0.63078e-02_r8,0.69750e-02_r8,0.73172e-02_r8, &
        & 0.74078e-02_r8,0.72504e-02_r8,0.67015e-02_r8,0.45394e-02_r8 /)
      kao(:, 2,12, 7) = (/ &
        & 0.18170e-02_r8,0.52437e-02_r8,0.64512e-02_r8,0.71255e-02_r8,0.74790e-02_r8, &
        & 0.75959e-02_r8,0.74655e-02_r8,0.69307e-02_r8,0.47237e-02_r8 /)
      kao(:, 3,12, 7) = (/ &
        & 0.19356e-02_r8,0.53689e-02_r8,0.65701e-02_r8,0.72610e-02_r8,0.76415e-02_r8, &
        & 0.77811e-02_r8,0.76703e-02_r8,0.71508e-02_r8,0.48953e-02_r8 /)
      kao(:, 4,12, 7) = (/ &
        & 0.20342e-02_r8,0.54644e-02_r8,0.66640e-02_r8,0.73792e-02_r8,0.77929e-02_r8, &
        & 0.79635e-02_r8,0.78660e-02_r8,0.73532e-02_r8,0.50607e-02_r8 /)
      kao(:, 5,12, 7) = (/ &
        & 0.21182e-02_r8,0.55328e-02_r8,0.67352e-02_r8,0.74736e-02_r8,0.79282e-02_r8, &
        & 0.81307e-02_r8,0.80542e-02_r8,0.75407e-02_r8,0.52234e-02_r8 /)
      kao(:, 1,13, 7) = (/ &
        & 0.13819e-02_r8,0.42823e-02_r8,0.53096e-02_r8,0.58771e-02_r8,0.61745e-02_r8, &
        & 0.62601e-02_r8,0.61411e-02_r8,0.56893e-02_r8,0.38201e-02_r8 /)
      kao(:, 2,13, 7) = (/ &
        & 0.14927e-02_r8,0.44078e-02_r8,0.54261e-02_r8,0.60055e-02_r8,0.63167e-02_r8, &
        & 0.64278e-02_r8,0.63268e-02_r8,0.58891e-02_r8,0.39789e-02_r8 /)
      kao(:, 3,13, 7) = (/ &
        & 0.15884e-02_r8,0.45090e-02_r8,0.55246e-02_r8,0.61217e-02_r8,0.64577e-02_r8, &
        & 0.65903e-02_r8,0.65044e-02_r8,0.60758e-02_r8,0.41288e-02_r8 /)
      kao(:, 4,13, 7) = (/ &
        & 0.16683e-02_r8,0.45858e-02_r8,0.56029e-02_r8,0.62193e-02_r8,0.65859e-02_r8, &
        & 0.67454e-02_r8,0.66768e-02_r8,0.62506e-02_r8,0.42765e-02_r8 /)
      kao(:, 5,13, 7) = (/ &
        & 0.17364e-02_r8,0.46419e-02_r8,0.56644e-02_r8,0.62996e-02_r8,0.66998e-02_r8, &
        & 0.68888e-02_r8,0.68404e-02_r8,0.64188e-02_r8,0.44198e-02_r8 /)
      kao(:, 1, 1, 8) = (/ &
        & 0.57760e-01_r8,0.69432e-01_r8,0.76402e-01_r8,0.81517e-01_r8,0.85125e-01_r8, &
        & 0.87289e-01_r8,0.87408e-01_r8,0.83317e-01_r8,0.74720e-01_r8 /)
      kao(:, 2, 1, 8) = (/ &
        & 0.58256e-01_r8,0.69667e-01_r8,0.76723e-01_r8,0.81911e-01_r8,0.85362e-01_r8, &
        & 0.87289e-01_r8,0.87306e-01_r8,0.83357e-01_r8,0.75177e-01_r8 /)
      kao(:, 3, 1, 8) = (/ &
        & 0.58710e-01_r8,0.69859e-01_r8,0.76973e-01_r8,0.82328e-01_r8,0.85690e-01_r8, &
        & 0.87420e-01_r8,0.87264e-01_r8,0.83435e-01_r8,0.75701e-01_r8 /)
      kao(:, 4, 1, 8) = (/ &
        & 0.59052e-01_r8,0.70050e-01_r8,0.77176e-01_r8,0.82642e-01_r8,0.86071e-01_r8, &
        & 0.87660e-01_r8,0.87341e-01_r8,0.83544e-01_r8,0.76230e-01_r8 /)
      kao(:, 5, 1, 8) = (/ &
        & 0.59298e-01_r8,0.70198e-01_r8,0.77374e-01_r8,0.82883e-01_r8,0.86469e-01_r8, &
        & 0.87977e-01_r8,0.87473e-01_r8,0.83691e-01_r8,0.76769e-01_r8 /)
      kao(:, 1, 2, 8) = (/ &
        & 0.50908e-01_r8,0.62848e-01_r8,0.70003e-01_r8,0.75263e-01_r8,0.78670e-01_r8, &
        & 0.80594e-01_r8,0.80694e-01_r8,0.77048e-01_r8,0.67048e-01_r8 /)
      kao(:, 2, 2, 8) = (/ &
        & 0.51469e-01_r8,0.63178e-01_r8,0.70395e-01_r8,0.75763e-01_r8,0.79033e-01_r8, &
        & 0.80775e-01_r8,0.80686e-01_r8,0.77199e-01_r8,0.67605e-01_r8 /)
      kao(:, 3, 2, 8) = (/ &
        & 0.51956e-01_r8,0.63519e-01_r8,0.70748e-01_r8,0.76221e-01_r8,0.79512e-01_r8, &
        & 0.81067e-01_r8,0.80797e-01_r8,0.77370e-01_r8,0.68182e-01_r8 /)
      kao(:, 4, 2, 8) = (/ &
        & 0.52329e-01_r8,0.63831e-01_r8,0.71115e-01_r8,0.76591e-01_r8,0.80032e-01_r8, &
        & 0.81445e-01_r8,0.81001e-01_r8,0.77568e-01_r8,0.68768e-01_r8 /)
      kao(:, 5, 2, 8) = (/ &
        & 0.52648e-01_r8,0.64108e-01_r8,0.71441e-01_r8,0.76941e-01_r8,0.80464e-01_r8, &
        & 0.81866e-01_r8,0.81282e-01_r8,0.77796e-01_r8,0.69377e-01_r8 /)
      kao(:, 1, 3, 8) = (/ &
        & 0.44636e-01_r8,0.56575e-01_r8,0.63667e-01_r8,0.68804e-01_r8,0.72146e-01_r8, &
        & 0.73940e-01_r8,0.73756e-01_r8,0.70359e-01_r8,0.59446e-01_r8 /)
      kao(:, 2, 3, 8) = (/ &
        & 0.45216e-01_r8,0.57005e-01_r8,0.64111e-01_r8,0.69328e-01_r8,0.72620e-01_r8, &
        & 0.74228e-01_r8,0.73854e-01_r8,0.70600e-01_r8,0.60086e-01_r8 /)
      kao(:, 3, 3, 8) = (/ &
        & 0.45716e-01_r8,0.57448e-01_r8,0.64591e-01_r8,0.69816e-01_r8,0.73178e-01_r8, &
        & 0.74616e-01_r8,0.74093e-01_r8,0.70843e-01_r8,0.60738e-01_r8 /)
      kao(:, 4, 3, 8) = (/ &
        & 0.46137e-01_r8,0.57862e-01_r8,0.65060e-01_r8,0.70283e-01_r8,0.73724e-01_r8, &
        & 0.75067e-01_r8,0.74408e-01_r8,0.71130e-01_r8,0.61385e-01_r8 /)
      kao(:, 5, 3, 8) = (/ &
        & 0.46490e-01_r8,0.58240e-01_r8,0.65537e-01_r8,0.70752e-01_r8,0.74187e-01_r8, &
        & 0.75545e-01_r8,0.74817e-01_r8,0.71479e-01_r8,0.61998e-01_r8 /)
      kao(:, 1, 4, 8) = (/ &
        & 0.38910e-01_r8,0.50823e-01_r8,0.57505e-01_r8,0.62364e-01_r8,0.65559e-01_r8, &
        & 0.67154e-01_r8,0.66798e-01_r8,0.63531e-01_r8,0.52401e-01_r8 /)
      kao(:, 2, 4, 8) = (/ &
        & 0.39488e-01_r8,0.51307e-01_r8,0.58022e-01_r8,0.62912e-01_r8,0.66074e-01_r8, &
        & 0.67518e-01_r8,0.67025e-01_r8,0.63840e-01_r8,0.53093e-01_r8 /)
      kao(:, 3, 4, 8) = (/ &
        & 0.39991e-01_r8,0.51812e-01_r8,0.58566e-01_r8,0.63451e-01_r8,0.66632e-01_r8, &
        & 0.68010e-01_r8,0.67348e-01_r8,0.64169e-01_r8,0.53782e-01_r8 /)
      kao(:, 4, 4, 8) = (/ &
        & 0.40387e-01_r8,0.52291e-01_r8,0.59117e-01_r8,0.64001e-01_r8,0.67196e-01_r8, &
        & 0.68514e-01_r8,0.67789e-01_r8,0.64555e-01_r8,0.54470e-01_r8 /)
      kao(:, 5, 4, 8) = (/ &
        & 0.40719e-01_r8,0.52739e-01_r8,0.59691e-01_r8,0.64572e-01_r8,0.67725e-01_r8, &
        & 0.69031e-01_r8,0.68307e-01_r8,0.64985e-01_r8,0.55091e-01_r8 /)
      kao(:, 1, 5, 8) = (/ &
        & 0.33692e-01_r8,0.45459e-01_r8,0.51705e-01_r8,0.56111e-01_r8,0.58984e-01_r8, &
        & 0.60384e-01_r8,0.59951e-01_r8,0.56770e-01_r8,0.45939e-01_r8 /)
      kao(:, 2, 5, 8) = (/ &
        & 0.34254e-01_r8,0.45979e-01_r8,0.52252e-01_r8,0.56664e-01_r8,0.59515e-01_r8, &
        & 0.60816e-01_r8,0.60273e-01_r8,0.57146e-01_r8,0.46647e-01_r8 /)
      kao(:, 3, 5, 8) = (/ &
        & 0.34738e-01_r8,0.46532e-01_r8,0.52846e-01_r8,0.57238e-01_r8,0.60077e-01_r8, &
        & 0.61352e-01_r8,0.60714e-01_r8,0.57566e-01_r8,0.47359e-01_r8 /)
      kao(:, 4, 5, 8) = (/ &
        & 0.35117e-01_r8,0.47047e-01_r8,0.53459e-01_r8,0.57849e-01_r8,0.60668e-01_r8, &
        & 0.61902e-01_r8,0.61259e-01_r8,0.58030e-01_r8,0.48036e-01_r8 /)
      kao(:, 5, 5, 8) = (/ &
        & 0.35428e-01_r8,0.47508e-01_r8,0.54083e-01_r8,0.58493e-01_r8,0.61253e-01_r8, &
        & 0.62481e-01_r8,0.61851e-01_r8,0.58523e-01_r8,0.48648e-01_r8 /)
      kao(:, 1, 6, 8) = (/ &
        & 0.28910e-01_r8,0.40429e-01_r8,0.46176e-01_r8,0.50108e-01_r8,0.52609e-01_r8, &
        & 0.53750e-01_r8,0.53289e-01_r8,0.50286e-01_r8,0.40061e-01_r8 /)
      kao(:, 2, 6, 8) = (/ &
        & 0.29433e-01_r8,0.40967e-01_r8,0.46731e-01_r8,0.50653e-01_r8,0.53149e-01_r8, &
        & 0.54232e-01_r8,0.53687e-01_r8,0.50714e-01_r8,0.40756e-01_r8 /)
      kao(:, 3, 6, 8) = (/ &
        & 0.29883e-01_r8,0.41520e-01_r8,0.47349e-01_r8,0.51251e-01_r8,0.53731e-01_r8, &
        & 0.54796e-01_r8,0.54207e-01_r8,0.51188e-01_r8,0.41443e-01_r8 /)
      kao(:, 4, 6, 8) = (/ &
        & 0.30252e-01_r8,0.42024e-01_r8,0.47998e-01_r8,0.51918e-01_r8,0.54339e-01_r8, &
        & 0.55387e-01_r8,0.54820e-01_r8,0.51711e-01_r8,0.42085e-01_r8 /)
      kao(:, 5, 6, 8) = (/ &
        & 0.30542e-01_r8,0.42447e-01_r8,0.48635e-01_r8,0.52598e-01_r8,0.54986e-01_r8, &
        & 0.56038e-01_r8,0.55430e-01_r8,0.52236e-01_r8,0.42675e-01_r8 /)
      kao(:, 1, 7, 8) = (/ &
        & 0.24600e-01_r8,0.35725e-01_r8,0.40952e-01_r8,0.44398e-01_r8,0.46558e-01_r8, &
        & 0.47462e-01_r8,0.46950e-01_r8,0.44227e-01_r8,0.34751e-01_r8 /)
      kao(:, 2, 7, 8) = (/ &
        & 0.25060e-01_r8,0.36250e-01_r8,0.41498e-01_r8,0.44950e-01_r8,0.47097e-01_r8, &
        & 0.47977e-01_r8,0.47399e-01_r8,0.44690e-01_r8,0.35410e-01_r8 /)
      kao(:, 3, 7, 8) = (/ &
        & 0.25466e-01_r8,0.36769e-01_r8,0.42119e-01_r8,0.45572e-01_r8,0.47696e-01_r8, &
        & 0.48548e-01_r8,0.47965e-01_r8,0.45198e-01_r8,0.36050e-01_r8 /)
      kao(:, 4, 7, 8) = (/ &
        & 0.25804e-01_r8,0.37232e-01_r8,0.42764e-01_r8,0.46249e-01_r8,0.48349e-01_r8, &
        & 0.49173e-01_r8,0.48603e-01_r8,0.45737e-01_r8,0.36649e-01_r8 /)
      kao(:, 5, 7, 8) = (/ &
        & 0.26075e-01_r8,0.37645e-01_r8,0.43371e-01_r8,0.46950e-01_r8,0.49045e-01_r8, &
        & 0.49856e-01_r8,0.49223e-01_r8,0.46279e-01_r8,0.37198e-01_r8 /)
      kao(:, 1, 8, 8) = (/ &
        & 0.20747e-01_r8,0.31325e-01_r8,0.36016e-01_r8,0.39047e-01_r8,0.40921e-01_r8, &
        & 0.41656e-01_r8,0.41097e-01_r8,0.38682e-01_r8,0.29955e-01_r8 /)
      kao(:, 2, 8, 8) = (/ &
        & 0.21145e-01_r8,0.31811e-01_r8,0.36541e-01_r8,0.39597e-01_r8,0.41455e-01_r8, &
        & 0.42169e-01_r8,0.41575e-01_r8,0.39145e-01_r8,0.30577e-01_r8 /)
      kao(:, 3, 8, 8) = (/ &
        & 0.21497e-01_r8,0.32290e-01_r8,0.37155e-01_r8,0.40238e-01_r8,0.42067e-01_r8, &
        & 0.42744e-01_r8,0.42154e-01_r8,0.39648e-01_r8,0.31178e-01_r8 /)
      kao(:, 4, 8, 8) = (/ &
        & 0.21796e-01_r8,0.32717e-01_r8,0.37766e-01_r8,0.40923e-01_r8,0.42738e-01_r8, &
        & 0.43394e-01_r8,0.42768e-01_r8,0.40185e-01_r8,0.31733e-01_r8 /)
      kao(:, 5, 8, 8) = (/ &
        & 0.22044e-01_r8,0.33112e-01_r8,0.38338e-01_r8,0.41597e-01_r8,0.43462e-01_r8, &
        & 0.44087e-01_r8,0.43385e-01_r8,0.40740e-01_r8,0.32254e-01_r8 /)
      kao(:, 1, 9, 8) = (/ &
        & 0.17360e-01_r8,0.27218e-01_r8,0.31401e-01_r8,0.34084e-01_r8,0.35741e-01_r8, &
        & 0.36373e-01_r8,0.35798e-01_r8,0.33594e-01_r8,0.25664e-01_r8 /)
      kao(:, 2, 9, 8) = (/ &
        & 0.17693e-01_r8,0.27662e-01_r8,0.31908e-01_r8,0.34622e-01_r8,0.36264e-01_r8, &
        & 0.36877e-01_r8,0.36285e-01_r8,0.34049e-01_r8,0.26251e-01_r8 /)
      kao(:, 3, 9, 8) = (/ &
        & 0.17992e-01_r8,0.28089e-01_r8,0.32477e-01_r8,0.35255e-01_r8,0.36874e-01_r8, &
        & 0.37444e-01_r8,0.36831e-01_r8,0.34544e-01_r8,0.26814e-01_r8 /)
      kao(:, 4, 9, 8) = (/ &
        & 0.18258e-01_r8,0.28481e-01_r8,0.33050e-01_r8,0.35909e-01_r8,0.37552e-01_r8, &
        & 0.38078e-01_r8,0.37421e-01_r8,0.35073e-01_r8,0.27335e-01_r8 /)
      kao(:, 5, 9, 8) = (/ &
        & 0.18484e-01_r8,0.28849e-01_r8,0.33601e-01_r8,0.36536e-01_r8,0.38254e-01_r8, &
        & 0.38756e-01_r8,0.38026e-01_r8,0.35616e-01_r8,0.27829e-01_r8 /)
      kao(:, 1,10, 8) = (/ &
        & 0.14462e-01_r8,0.23463e-01_r8,0.27186e-01_r8,0.29588e-01_r8,0.31079e-01_r8, &
        & 0.31625e-01_r8,0.31053e-01_r8,0.29012e-01_r8,0.21916e-01_r8 /)
      kao(:, 2,10, 8) = (/ &
        & 0.14737e-01_r8,0.23853e-01_r8,0.27662e-01_r8,0.30109e-01_r8,0.31581e-01_r8, &
        & 0.32116e-01_r8,0.31527e-01_r8,0.29461e-01_r8,0.22460e-01_r8 /)
      kao(:, 3,10, 8) = (/ &
        & 0.14983e-01_r8,0.24238e-01_r8,0.28187e-01_r8,0.30710e-01_r8,0.32176e-01_r8, &
        & 0.32664e-01_r8,0.32044e-01_r8,0.29948e-01_r8,0.22987e-01_r8 /)
      kao(:, 4,10, 8) = (/ &
        & 0.15228e-01_r8,0.24593e-01_r8,0.28718e-01_r8,0.31312e-01_r8,0.32826e-01_r8, &
        & 0.33282e-01_r8,0.32615e-01_r8,0.30467e-01_r8,0.23478e-01_r8 /)
      kao(:, 5,10, 8) = (/ &
        & 0.15411e-01_r8,0.24932e-01_r8,0.29228e-01_r8,0.31903e-01_r8,0.33455e-01_r8, &
        & 0.33943e-01_r8,0.33207e-01_r8,0.30994e-01_r8,0.23939e-01_r8 /)
      kao(:, 1,11, 8) = (/ &
        & 0.12097e-01_r8,0.20230e-01_r8,0.23554e-01_r8,0.25737e-01_r8,0.27070e-01_r8, &
        & 0.27526e-01_r8,0.26987e-01_r8,0.25125e-01_r8,0.18843e-01_r8 /)
      kao(:, 2,11, 8) = (/ &
        & 0.12316e-01_r8,0.20564e-01_r8,0.24014e-01_r8,0.26265e-01_r8,0.27589e-01_r8, &
        & 0.28021e-01_r8,0.27462e-01_r8,0.25580e-01_r8,0.19341e-01_r8 /)
      kao(:, 3,11, 8) = (/ &
        & 0.12525e-01_r8,0.20893e-01_r8,0.24494e-01_r8,0.26817e-01_r8,0.28172e-01_r8, &
        & 0.28578e-01_r8,0.27985e-01_r8,0.26073e-01_r8,0.19811e-01_r8 /)
      kao(:, 4,11, 8) = (/ &
        & 0.12698e-01_r8,0.21212e-01_r8,0.24971e-01_r8,0.27358e-01_r8,0.28752e-01_r8, &
        & 0.29196e-01_r8,0.28554e-01_r8,0.26575e-01_r8,0.20254e-01_r8 /)
      kao(:, 5,11, 8) = (/ &
        & 0.12813e-01_r8,0.21527e-01_r8,0.25428e-01_r8,0.27886e-01_r8,0.29316e-01_r8, &
        & 0.29794e-01_r8,0.29144e-01_r8,0.27095e-01_r8,0.20669e-01_r8 /)
      kao(:, 1,12, 8) = (/ &
        & 0.10079e-01_r8,0.17332e-01_r8,0.20326e-01_r8,0.22283e-01_r8,0.23452e-01_r8, &
        & 0.23840e-01_r8,0.23351e-01_r8,0.21701e-01_r8,0.16150e-01_r8 /)
      kao(:, 2,12, 8) = (/ &
        & 0.10253e-01_r8,0.17624e-01_r8,0.20738e-01_r8,0.22772e-01_r8,0.23963e-01_r8, &
        & 0.24343e-01_r8,0.23830e-01_r8,0.22159e-01_r8,0.16605e-01_r8 /)
      kao(:, 3,12, 8) = (/ &
        & 0.10412e-01_r8,0.17914e-01_r8,0.21165e-01_r8,0.23257e-01_r8,0.24491e-01_r8, &
        & 0.24907e-01_r8,0.24364e-01_r8,0.22633e-01_r8,0.17031e-01_r8 /)
      kao(:, 4,12, 8) = (/ &
        & 0.10528e-01_r8,0.18203e-01_r8,0.21585e-01_r8,0.23732e-01_r8,0.25019e-01_r8, &
        & 0.25466e-01_r8,0.24925e-01_r8,0.23123e-01_r8,0.17440e-01_r8 /)
      kao(:, 5,12, 8) = (/ &
        & 0.10595e-01_r8,0.18491e-01_r8,0.21987e-01_r8,0.24205e-01_r8,0.25526e-01_r8, &
        & 0.26013e-01_r8,0.25497e-01_r8,0.23633e-01_r8,0.17825e-01_r8 /)
      kao(:, 1,13, 8) = (/ &
        & 0.83675e-02_r8,0.14778e-01_r8,0.17455e-01_r8,0.19201e-01_r8,0.20214e-01_r8, &
        & 0.20545e-01_r8,0.20133e-01_r8,0.18703e-01_r8,0.13810e-01_r8 /)
      kao(:, 2,13, 8) = (/ &
        & 0.85037e-02_r8,0.15033e-01_r8,0.17824e-01_r8,0.19621e-01_r8,0.20684e-01_r8, &
        & 0.21052e-01_r8,0.20616e-01_r8,0.19145e-01_r8,0.14218e-01_r8 /)
      kao(:, 3,13, 8) = (/ &
        & 0.86129e-02_r8,0.15303e-01_r8,0.18197e-01_r8,0.20043e-01_r8,0.21163e-01_r8, &
        & 0.21577e-01_r8,0.21143e-01_r8,0.19600e-01_r8,0.14617e-01_r8 /)
      kao(:, 4,13, 8) = (/ &
        & 0.86912e-02_r8,0.15568e-01_r8,0.18565e-01_r8,0.20472e-01_r8,0.21636e-01_r8, &
        & 0.22091e-01_r8,0.21674e-01_r8,0.20090e-01_r8,0.14991e-01_r8 /)
      kao(:, 5,13, 8) = (/ &
        & 0.87302e-02_r8,0.15800e-01_r8,0.18917e-01_r8,0.20887e-01_r8,0.22103e-01_r8, &
        & 0.22594e-01_r8,0.22198e-01_r8,0.20586e-01_r8,0.15351e-01_r8 /)
      kao(:, 1, 1, 9) = (/ &
        & 0.23898e+00_r8,0.24353e+00_r8,0.26297e+00_r8,0.27410e+00_r8,0.27635e+00_r8, &
        & 0.27151e+00_r8,0.26001e+00_r8,0.24536e+00_r8,0.24840e+00_r8 /)
      kao(:, 2, 1, 9) = (/ &
        & 0.23703e+00_r8,0.24151e+00_r8,0.26057e+00_r8,0.27148e+00_r8,0.27415e+00_r8, &
        & 0.26993e+00_r8,0.25912e+00_r8,0.24520e+00_r8,0.24830e+00_r8 /)
      kao(:, 3, 1, 9) = (/ &
        & 0.23567e+00_r8,0.23998e+00_r8,0.25868e+00_r8,0.26917e+00_r8,0.27195e+00_r8, &
        & 0.26833e+00_r8,0.25809e+00_r8,0.24488e+00_r8,0.24801e+00_r8 /)
      kao(:, 4, 1, 9) = (/ &
        & 0.23478e+00_r8,0.23885e+00_r8,0.25713e+00_r8,0.26729e+00_r8,0.26990e+00_r8, &
        & 0.26662e+00_r8,0.25696e+00_r8,0.24453e+00_r8,0.24772e+00_r8 /)
      kao(:, 5, 1, 9) = (/ &
        & 0.23430e+00_r8,0.23810e+00_r8,0.25588e+00_r8,0.26568e+00_r8,0.26809e+00_r8, &
        & 0.26490e+00_r8,0.25575e+00_r8,0.24412e+00_r8,0.24745e+00_r8 /)
      kao(:, 1, 2, 9) = (/ &
        & 0.22071e+00_r8,0.23189e+00_r8,0.25280e+00_r8,0.26428e+00_r8,0.26846e+00_r8, &
        & 0.26544e+00_r8,0.25423e+00_r8,0.23818e+00_r8,0.23526e+00_r8 /)
      kao(:, 2, 2, 9) = (/ &
        & 0.21924e+00_r8,0.23025e+00_r8,0.25076e+00_r8,0.26194e+00_r8,0.26631e+00_r8, &
        & 0.26393e+00_r8,0.25356e+00_r8,0.23803e+00_r8,0.23534e+00_r8 /)
      kao(:, 3, 2, 9) = (/ &
        & 0.21843e+00_r8,0.22915e+00_r8,0.24919e+00_r8,0.26005e+00_r8,0.26425e+00_r8, &
        & 0.26237e+00_r8,0.25262e+00_r8,0.23788e+00_r8,0.23535e+00_r8 /)
      kao(:, 4, 2, 9) = (/ &
        & 0.21819e+00_r8,0.22852e+00_r8,0.24801e+00_r8,0.25855e+00_r8,0.26247e+00_r8, &
        & 0.26079e+00_r8,0.25163e+00_r8,0.23767e+00_r8,0.23532e+00_r8 /)
      kao(:, 5, 2, 9) = (/ &
        & 0.21836e+00_r8,0.22826e+00_r8,0.24718e+00_r8,0.25726e+00_r8,0.26101e+00_r8, &
        & 0.25924e+00_r8,0.25059e+00_r8,0.23733e+00_r8,0.23520e+00_r8 /)
      kao(:, 1, 3, 9) = (/ &
        & 0.20172e+00_r8,0.21909e+00_r8,0.24049e+00_r8,0.25259e+00_r8,0.25809e+00_r8, &
        & 0.25661e+00_r8,0.24776e+00_r8,0.23048e+00_r8,0.22176e+00_r8 /)
      kao(:, 2, 3, 9) = (/ &
        & 0.20072e+00_r8,0.21779e+00_r8,0.23872e+00_r8,0.25058e+00_r8,0.25610e+00_r8, &
        & 0.25527e+00_r8,0.24712e+00_r8,0.23055e+00_r8,0.22209e+00_r8 /)
      kao(:, 3, 3, 9) = (/ &
        & 0.20047e+00_r8,0.21708e+00_r8,0.23748e+00_r8,0.24902e+00_r8,0.25438e+00_r8, &
        & 0.25391e+00_r8,0.24629e+00_r8,0.23063e+00_r8,0.22233e+00_r8 /)
      kao(:, 4, 3, 9) = (/ &
        & 0.20080e+00_r8,0.21687e+00_r8,0.23670e+00_r8,0.24777e+00_r8,0.25298e+00_r8, &
        & 0.25252e+00_r8,0.24542e+00_r8,0.23053e+00_r8,0.22249e+00_r8 /)
      kao(:, 5, 3, 9) = (/ &
        & 0.20160e+00_r8,0.21710e+00_r8,0.23623e+00_r8,0.24683e+00_r8,0.25186e+00_r8, &
        & 0.25126e+00_r8,0.24453e+00_r8,0.23018e+00_r8,0.22257e+00_r8 /)
      kao(:, 1, 4, 9) = (/ &
        & 0.18271e+00_r8,0.20499e+00_r8,0.22645e+00_r8,0.23921e+00_r8,0.24553e+00_r8, &
        & 0.24573e+00_r8,0.23916e+00_r8,0.22190e+00_r8,0.20803e+00_r8 /)
      kao(:, 2, 4, 9) = (/ &
        & 0.18212e+00_r8,0.20407e+00_r8,0.22500e+00_r8,0.23755e+00_r8,0.24385e+00_r8, &
        & 0.24460e+00_r8,0.23866e+00_r8,0.22223e+00_r8,0.20862e+00_r8 /)
      kao(:, 3, 4, 9) = (/ &
        & 0.18234e+00_r8,0.20374e+00_r8,0.22412e+00_r8,0.23625e+00_r8,0.24249e+00_r8, &
        & 0.24341e+00_r8,0.23801e+00_r8,0.22245e+00_r8,0.20916e+00_r8 /)
      kao(:, 4, 4, 9) = (/ &
        & 0.18327e+00_r8,0.20396e+00_r8,0.22372e+00_r8,0.23535e+00_r8,0.24149e+00_r8, &
        & 0.24231e+00_r8,0.23730e+00_r8,0.22248e+00_r8,0.20951e+00_r8 /)
      kao(:, 5, 4, 9) = (/ &
        & 0.18465e+00_r8,0.20466e+00_r8,0.22368e+00_r8,0.23479e+00_r8,0.24072e+00_r8, &
        & 0.24142e+00_r8,0.23656e+00_r8,0.22226e+00_r8,0.20975e+00_r8 /)
      kao(:, 1, 5, 9) = (/ &
        & 0.16429e+00_r8,0.19018e+00_r8,0.21120e+00_r8,0.22440e+00_r8,0.23155e+00_r8, &
        & 0.23328e+00_r8,0.22834e+00_r8,0.21231e+00_r8,0.19389e+00_r8 /)
      kao(:, 2, 5, 9) = (/ &
        & 0.16411e+00_r8,0.18954e+00_r8,0.21010e+00_r8,0.22306e+00_r8,0.23026e+00_r8, &
        & 0.23235e+00_r8,0.22803e+00_r8,0.21280e+00_r8,0.19477e+00_r8 /)
      kao(:, 3, 5, 9) = (/ &
        & 0.16481e+00_r8,0.18955e+00_r8,0.20958e+00_r8,0.22215e+00_r8,0.22928e+00_r8, &
        & 0.23142e+00_r8,0.22762e+00_r8,0.21318e+00_r8,0.19549e+00_r8 /)
      kao(:, 4, 5, 9) = (/ &
        & 0.16626e+00_r8,0.19018e+00_r8,0.20952e+00_r8,0.22166e+00_r8,0.22860e+00_r8, &
        & 0.23069e+00_r8,0.22713e+00_r8,0.21333e+00_r8,0.19598e+00_r8 /)
      kao(:, 5, 5, 9) = (/ &
        & 0.16812e+00_r8,0.19134e+00_r8,0.20988e+00_r8,0.22152e+00_r8,0.22816e+00_r8, &
        & 0.23013e+00_r8,0.22663e+00_r8,0.21325e+00_r8,0.19645e+00_r8 /)
      kao(:, 1, 6, 9) = (/ &
        & 0.14677e+00_r8,0.17503e+00_r8,0.19553e+00_r8,0.20871e+00_r8,0.21680e+00_r8, &
        & 0.21948e+00_r8,0.21556e+00_r8,0.20158e+00_r8,0.17922e+00_r8 /)
      kao(:, 2, 6, 9) = (/ &
        & 0.14688e+00_r8,0.17460e+00_r8,0.19479e+00_r8,0.20777e+00_r8,0.21582e+00_r8, &
        & 0.21883e+00_r8,0.21549e+00_r8,0.20223e+00_r8,0.18038e+00_r8 /)
      kao(:, 3, 6, 9) = (/ &
        & 0.14791e+00_r8,0.17490e+00_r8,0.19459e+00_r8,0.20727e+00_r8,0.21519e+00_r8, &
        & 0.21822e+00_r8,0.21533e+00_r8,0.20278e+00_r8,0.18127e+00_r8 /)
      kao(:, 4, 6, 9) = (/ &
        & 0.14970e+00_r8,0.17592e+00_r8,0.19488e+00_r8,0.20713e+00_r8,0.21485e+00_r8, &
        & 0.21785e+00_r8,0.21514e+00_r8,0.20305e+00_r8,0.18200e+00_r8 /)
      kao(:, 5, 6, 9) = (/ &
        & 0.15169e+00_r8,0.17756e+00_r8,0.19568e+00_r8,0.20736e+00_r8,0.21479e+00_r8, &
        & 0.21766e+00_r8,0.21494e+00_r8,0.20315e+00_r8,0.18271e+00_r8 /)
      kao(:, 1, 7, 9) = (/ &
        & 0.13000e+00_r8,0.15987e+00_r8,0.17978e+00_r8,0.19301e+00_r8,0.20129e+00_r8, &
        & 0.20436e+00_r8,0.20140e+00_r8,0.18919e+00_r8,0.16414e+00_r8 /)
      kao(:, 2, 7, 9) = (/ &
        & 0.13035e+00_r8,0.15964e+00_r8,0.17934e+00_r8,0.19244e+00_r8,0.20068e+00_r8, &
        & 0.20402e+00_r8,0.20156e+00_r8,0.19006e+00_r8,0.16551e+00_r8 /)
      kao(:, 3, 7, 9) = (/ &
        & 0.13166e+00_r8,0.16021e+00_r8,0.17944e+00_r8,0.19225e+00_r8,0.20040e+00_r8, &
        & 0.20381e+00_r8,0.20166e+00_r8,0.19078e+00_r8,0.16662e+00_r8 /)
      kao(:, 4, 7, 9) = (/ &
        & 0.13361e+00_r8,0.16157e+00_r8,0.18010e+00_r8,0.19248e+00_r8,0.20041e+00_r8, &
        & 0.20379e+00_r8,0.20172e+00_r8,0.19125e+00_r8,0.16758e+00_r8 /)
      kao(:, 5, 7, 9) = (/ &
        & 0.13554e+00_r8,0.16344e+00_r8,0.18132e+00_r8,0.19308e+00_r8,0.20075e+00_r8, &
        & 0.20397e+00_r8,0.20182e+00_r8,0.19159e+00_r8,0.16855e+00_r8 /)
      kao(:, 1, 8, 9) = (/ &
        & 0.11433e+00_r8,0.14488e+00_r8,0.16431e+00_r8,0.17738e+00_r8,0.18527e+00_r8, &
        & 0.18841e+00_r8,0.18617e+00_r8,0.17535e+00_r8,0.14893e+00_r8 /)
      kao(:, 2, 8, 9) = (/ &
        & 0.11487e+00_r8,0.14487e+00_r8,0.16414e+00_r8,0.17713e+00_r8,0.18501e+00_r8, &
        & 0.18837e+00_r8,0.18658e+00_r8,0.17646e+00_r8,0.15049e+00_r8 /)
      kao(:, 3, 8, 9) = (/ &
        & 0.11635e+00_r8,0.14571e+00_r8,0.16452e+00_r8,0.17724e+00_r8,0.18506e+00_r8, &
        & 0.18853e+00_r8,0.18695e+00_r8,0.17741e+00_r8,0.15180e+00_r8 /)
      kao(:, 4, 8, 9) = (/ &
        & 0.11822e+00_r8,0.14733e+00_r8,0.16549e+00_r8,0.17782e+00_r8,0.18544e+00_r8, &
        & 0.18888e+00_r8,0.18734e+00_r8,0.17811e+00_r8,0.15295e+00_r8 /)
      kao(:, 5, 8, 9) = (/ &
        & 0.12009e+00_r8,0.14924e+00_r8,0.16704e+00_r8,0.17887e+00_r8,0.18614e+00_r8, &
        & 0.18940e+00_r8,0.18775e+00_r8,0.17867e+00_r8,0.15411e+00_r8 /)
      kao(:, 1, 9, 9) = (/ &
        & 0.10002e+00_r8,0.13043e+00_r8,0.14919e+00_r8,0.16171e+00_r8,0.16913e+00_r8, &
        & 0.17211e+00_r8,0.17023e+00_r8,0.16067e+00_r8,0.13380e+00_r8 /)
      kao(:, 2, 9, 9) = (/ &
        & 0.10070e+00_r8,0.13063e+00_r8,0.14927e+00_r8,0.16171e+00_r8,0.16923e+00_r8, &
        & 0.17237e+00_r8,0.17091e+00_r8,0.16202e+00_r8,0.13552e+00_r8 /)
      kao(:, 3, 9, 9) = (/ &
        & 0.10219e+00_r8,0.13166e+00_r8,0.14990e+00_r8,0.16210e+00_r8,0.16959e+00_r8, &
        & 0.17285e+00_r8,0.17161e+00_r8,0.16316e+00_r8,0.13700e+00_r8 /)
      kao(:, 4, 9, 9) = (/ &
        & 0.10390e+00_r8,0.13341e+00_r8,0.15118e+00_r8,0.16299e+00_r8,0.17031e+00_r8, &
        & 0.17358e+00_r8,0.17229e+00_r8,0.16405e+00_r8,0.13837e+00_r8 /)
      kao(:, 5, 9, 9) = (/ &
        & 0.10569e+00_r8,0.13530e+00_r8,0.15298e+00_r8,0.16444e+00_r8,0.17139e+00_r8, &
        & 0.17443e+00_r8,0.17301e+00_r8,0.16481e+00_r8,0.13976e+00_r8 /)
      kao(:, 1,10, 9) = (/ &
        & 0.87148e-01_r8,0.11690e+00_r8,0.13450e+00_r8,0.14609e+00_r8,0.15307e+00_r8, &
        & 0.15588e+00_r8,0.15420e+00_r8,0.14572e+00_r8,0.11917e+00_r8 /)
      kao(:, 2,10, 9) = (/ &
        & 0.87948e-01_r8,0.11730e+00_r8,0.13485e+00_r8,0.14637e+00_r8,0.15348e+00_r8, &
        & 0.15645e+00_r8,0.15513e+00_r8,0.14723e+00_r8,0.12103e+00_r8 /)
      kao(:, 3,10, 9) = (/ &
        & 0.89341e-01_r8,0.11856e+00_r8,0.13575e+00_r8,0.14709e+00_r8,0.15418e+00_r8, &
        & 0.15726e+00_r8,0.15609e+00_r8,0.14852e+00_r8,0.12266e+00_r8 /)
      kao(:, 4,10, 9) = (/ &
        & 0.90912e-01_r8,0.12032e+00_r8,0.13733e+00_r8,0.14835e+00_r8,0.15527e+00_r8, &
        & 0.15827e+00_r8,0.15702e+00_r8,0.14960e+00_r8,0.12424e+00_r8 /)
      kao(:, 5,10, 9) = (/ &
        & 0.92651e-01_r8,0.12218e+00_r8,0.13930e+00_r8,0.15018e+00_r8,0.15676e+00_r8, &
        & 0.15942e+00_r8,0.15802e+00_r8,0.15063e+00_r8,0.12583e+00_r8 /)
      kao(:, 1,11, 9) = (/ &
        & 0.75810e-01_r8,0.10456e+00_r8,0.12069e+00_r8,0.13117e+00_r8,0.13761e+00_r8, &
        & 0.14039e+00_r8,0.13895e+00_r8,0.13157e+00_r8,0.10610e+00_r8 /)
      kao(:, 2,11, 9) = (/ &
        & 0.76895e-01_r8,0.10557e+00_r8,0.12151e+00_r8,0.13190e+00_r8,0.13842e+00_r8, &
        & 0.14134e+00_r8,0.14014e+00_r8,0.13312e+00_r8,0.10796e+00_r8 /)
      kao(:, 3,11, 9) = (/ &
        & 0.78244e-01_r8,0.10718e+00_r8,0.12298e+00_r8,0.13318e+00_r8,0.13962e+00_r8, &
        & 0.14250e+00_r8,0.14130e+00_r8,0.13446e+00_r8,0.10971e+00_r8 /)
      kao(:, 4,11, 9) = (/ &
        & 0.79823e-01_r8,0.10896e+00_r8,0.12491e+00_r8,0.13508e+00_r8,0.14123e+00_r8, &
        & 0.14382e+00_r8,0.14250e+00_r8,0.13575e+00_r8,0.11145e+00_r8 /)
      kao(:, 5,11, 9) = (/ &
        & 0.81587e-01_r8,0.11081e+00_r8,0.12696e+00_r8,0.13729e+00_r8,0.14323e+00_r8, &
        & 0.14541e+00_r8,0.14385e+00_r8,0.13708e+00_r8,0.11322e+00_r8 /)
      kao(:, 1,12, 9) = (/ &
        & 0.65751e-01_r8,0.93358e-01_r8,0.10793e+00_r8,0.11727e+00_r8,0.12307e+00_r8, &
        & 0.12565e+00_r8,0.12447e+00_r8,0.11782e+00_r8,0.93944e-01_r8 /)
      kao(:, 2,12, 9) = (/ &
        & 0.66851e-01_r8,0.94791e-01_r8,0.10927e+00_r8,0.11849e+00_r8,0.12430e+00_r8, &
        & 0.12692e+00_r8,0.12584e+00_r8,0.11940e+00_r8,0.95825e-01_r8 /)
      kao(:, 3,12, 9) = (/ &
        & 0.68215e-01_r8,0.96468e-01_r8,0.11113e+00_r8,0.12035e+00_r8,0.12596e+00_r8, &
        & 0.12837e+00_r8,0.12723e+00_r8,0.12088e+00_r8,0.97697e-01_r8 /)
      kao(:, 4,12, 9) = (/ &
        & 0.69822e-01_r8,0.98288e-01_r8,0.11318e+00_r8,0.12260e+00_r8,0.12800e+00_r8, &
        & 0.13009e+00_r8,0.12875e+00_r8,0.12246e+00_r8,0.99558e-01_r8 /)
      kao(:, 5,12, 9) = (/ &
        & 0.71562e-01_r8,0.10021e+00_r8,0.11536e+00_r8,0.12491e+00_r8,0.13035e+00_r8, &
        & 0.13218e+00_r8,0.13049e+00_r8,0.12412e+00_r8,0.10142e+00_r8 /)
      kao(:, 1,13, 9) = (/ &
        & 0.56716e-01_r8,0.83175e-01_r8,0.96227e-01_r8,0.10452e+00_r8,0.10961e+00_r8, &
        & 0.11186e+00_r8,0.11078e+00_r8,0.10487e+00_r8,0.82822e-01_r8 /)
      kao(:, 2,13, 9) = (/ &
        & 0.57829e-01_r8,0.84711e-01_r8,0.97973e-01_r8,0.10625e+00_r8,0.11123e+00_r8, &
        & 0.11339e+00_r8,0.11236e+00_r8,0.10648e+00_r8,0.84781e-01_r8 /)
      kao(:, 3,13, 9) = (/ &
        & 0.59231e-01_r8,0.86426e-01_r8,0.99996e-01_r8,0.10847e+00_r8,0.11329e+00_r8, &
        & 0.11518e+00_r8,0.11401e+00_r8,0.10821e+00_r8,0.86727e-01_r8 /)
      kao(:, 4,13, 9) = (/ &
        & 0.60793e-01_r8,0.88335e-01_r8,0.10220e+00_r8,0.11080e+00_r8,0.11568e+00_r8, &
        & 0.11734e+00_r8,0.11592e+00_r8,0.11003e+00_r8,0.88652e-01_r8 /)
      kao(:, 5,13, 9) = (/ &
        & 0.62288e-01_r8,0.90379e-01_r8,0.10449e+00_r8,0.11321e+00_r8,0.11819e+00_r8, &
        & 0.11985e+00_r8,0.11808e+00_r8,0.11193e+00_r8,0.90608e-01_r8 /)
      kao(:, 1, 1,10) = (/ &
        & 0.73370e+00_r8,0.66239e+00_r8,0.64754e+00_r8,0.65671e+00_r8,0.64798e+00_r8, &
        & 0.62443e+00_r8,0.62156e+00_r8,0.59642e+00_r8,0.65694e+00_r8 /)
      kao(:, 2, 1,10) = (/ &
        & 0.72227e+00_r8,0.65245e+00_r8,0.64115e+00_r8,0.65244e+00_r8,0.64519e+00_r8, &
        & 0.62272e+00_r8,0.62178e+00_r8,0.59807e+00_r8,0.65734e+00_r8 /)
      kao(:, 3, 1,10) = (/ &
        & 0.71096e+00_r8,0.64287e+00_r8,0.63490e+00_r8,0.64719e+00_r8,0.64246e+00_r8, &
        & 0.61928e+00_r8,0.62164e+00_r8,0.59971e+00_r8,0.65975e+00_r8 /)
      kao(:, 4, 1,10) = (/ &
        & 0.69997e+00_r8,0.63340e+00_r8,0.62893e+00_r8,0.64188e+00_r8,0.63859e+00_r8, &
        & 0.61601e+00_r8,0.62127e+00_r8,0.59924e+00_r8,0.66003e+00_r8 /)
      kao(:, 5, 1,10) = (/ &
        & 0.68921e+00_r8,0.62412e+00_r8,0.62274e+00_r8,0.63660e+00_r8,0.63341e+00_r8, &
        & 0.61371e+00_r8,0.61976e+00_r8,0.59796e+00_r8,0.65874e+00_r8 /)
      kao(:, 1, 2,10) = (/ &
        & 0.71435e+00_r8,0.65898e+00_r8,0.65791e+00_r8,0.67621e+00_r8,0.66803e+00_r8, &
        & 0.63952e+00_r8,0.62227e+00_r8,0.60345e+00_r8,0.64341e+00_r8 /)
      kao(:, 2, 2,10) = (/ &
        & 0.70295e+00_r8,0.64927e+00_r8,0.65209e+00_r8,0.67168e+00_r8,0.66601e+00_r8, &
        & 0.63761e+00_r8,0.62183e+00_r8,0.60472e+00_r8,0.64489e+00_r8 /)
      kao(:, 3, 2,10) = (/ &
        & 0.69214e+00_r8,0.64012e+00_r8,0.64637e+00_r8,0.66639e+00_r8,0.66353e+00_r8, &
        & 0.63487e+00_r8,0.62217e+00_r8,0.60467e+00_r8,0.64521e+00_r8 /)
      kao(:, 4, 2,10) = (/ &
        & 0.68145e+00_r8,0.63089e+00_r8,0.64022e+00_r8,0.66099e+00_r8,0.65898e+00_r8, &
        & 0.63312e+00_r8,0.62106e+00_r8,0.60298e+00_r8,0.64380e+00_r8 /)
      kao(:, 5, 2,10) = (/ &
        & 0.67068e+00_r8,0.62208e+00_r8,0.63390e+00_r8,0.65546e+00_r8,0.65376e+00_r8, &
        & 0.63122e+00_r8,0.61818e+00_r8,0.60158e+00_r8,0.64256e+00_r8 /)
      kao(:, 1, 3,10) = (/ &
        & 0.68340e+00_r8,0.64482e+00_r8,0.66290e+00_r8,0.68284e+00_r8,0.67896e+00_r8, &
        & 0.65800e+00_r8,0.61589e+00_r8,0.60026e+00_r8,0.62209e+00_r8 /)
      kao(:, 2, 3,10) = (/ &
        & 0.67251e+00_r8,0.63550e+00_r8,0.65818e+00_r8,0.67891e+00_r8,0.67722e+00_r8, &
        & 0.65575e+00_r8,0.61745e+00_r8,0.60017e+00_r8,0.62247e+00_r8 /)
      kao(:, 3, 3,10) = (/ &
        & 0.66182e+00_r8,0.62604e+00_r8,0.65231e+00_r8,0.67447e+00_r8,0.67369e+00_r8, &
        & 0.65314e+00_r8,0.61804e+00_r8,0.59851e+00_r8,0.62084e+00_r8 /)
      kao(:, 4, 3,10) = (/ &
        & 0.65114e+00_r8,0.61727e+00_r8,0.64569e+00_r8,0.67007e+00_r8,0.66854e+00_r8, &
        & 0.65146e+00_r8,0.61713e+00_r8,0.59641e+00_r8,0.61922e+00_r8 /)
      kao(:, 5, 3,10) = (/ &
        & 0.64110e+00_r8,0.60881e+00_r8,0.63926e+00_r8,0.66468e+00_r8,0.66347e+00_r8, &
        & 0.64931e+00_r8,0.61433e+00_r8,0.59600e+00_r8,0.61885e+00_r8 /)
      kao(:, 1, 4,10) = (/ &
        & 0.64233e+00_r8,0.62207e+00_r8,0.65747e+00_r8,0.67845e+00_r8,0.68170e+00_r8, &
        & 0.66374e+00_r8,0.61548e+00_r8,0.59270e+00_r8,0.60473e+00_r8 /)
      kao(:, 2, 4,10) = (/ &
        & 0.63185e+00_r8,0.61324e+00_r8,0.65237e+00_r8,0.67473e+00_r8,0.67959e+00_r8, &
        & 0.66215e+00_r8,0.61741e+00_r8,0.59134e+00_r8,0.60361e+00_r8 /)
      kao(:, 3, 4,10) = (/ &
        & 0.62122e+00_r8,0.60440e+00_r8,0.64660e+00_r8,0.67096e+00_r8,0.67570e+00_r8, &
        & 0.66004e+00_r8,0.61834e+00_r8,0.58886e+00_r8,0.60079e+00_r8 /)
      kao(:, 4, 4,10) = (/ &
        & 0.61111e+00_r8,0.59616e+00_r8,0.64034e+00_r8,0.66675e+00_r8,0.67073e+00_r8, &
        & 0.65786e+00_r8,0.61721e+00_r8,0.58692e+00_r8,0.59978e+00_r8 /)
      kao(:, 5, 4,10) = (/ &
        & 0.60223e+00_r8,0.58851e+00_r8,0.63401e+00_r8,0.66136e+00_r8,0.66631e+00_r8, &
        & 0.65503e+00_r8,0.61469e+00_r8,0.58697e+00_r8,0.60040e+00_r8 /)
      kao(:, 1, 5,10) = (/ &
        & 0.59185e+00_r8,0.59370e+00_r8,0.63992e+00_r8,0.66463e+00_r8,0.67279e+00_r8, &
        & 0.65610e+00_r8,0.61852e+00_r8,0.58331e+00_r8,0.58763e+00_r8 /)
      kao(:, 2, 5,10) = (/ &
        & 0.58158e+00_r8,0.58584e+00_r8,0.63500e+00_r8,0.66123e+00_r8,0.67045e+00_r8, &
        & 0.65504e+00_r8,0.62015e+00_r8,0.58225e+00_r8,0.58623e+00_r8 /)
      kao(:, 3, 5,10) = (/ &
        & 0.57197e+00_r8,0.57827e+00_r8,0.62932e+00_r8,0.65791e+00_r8,0.66630e+00_r8, &
        & 0.65353e+00_r8,0.61959e+00_r8,0.58025e+00_r8,0.58483e+00_r8 /)
      kao(:, 4, 5,10) = (/ &
        & 0.56277e+00_r8,0.57099e+00_r8,0.62369e+00_r8,0.65326e+00_r8,0.66229e+00_r8, &
        & 0.65156e+00_r8,0.61745e+00_r8,0.57913e+00_r8,0.58544e+00_r8 /)
      kao(:, 5, 5,10) = (/ &
        & 0.55581e+00_r8,0.56431e+00_r8,0.61807e+00_r8,0.64784e+00_r8,0.65855e+00_r8, &
        & 0.64845e+00_r8,0.61479e+00_r8,0.57987e+00_r8,0.58646e+00_r8 /)
      kao(:, 1, 6,10) = (/ &
        & 0.53954e+00_r8,0.56255e+00_r8,0.61290e+00_r8,0.64303e+00_r8,0.64974e+00_r8, &
        & 0.64176e+00_r8,0.61714e+00_r8,0.56940e+00_r8,0.56484e+00_r8 /)
      kao(:, 2, 6,10) = (/ &
        & 0.53060e+00_r8,0.55651e+00_r8,0.60789e+00_r8,0.63988e+00_r8,0.64820e+00_r8, &
        & 0.64042e+00_r8,0.61834e+00_r8,0.56932e+00_r8,0.56418e+00_r8 /)
      kao(:, 3, 6,10) = (/ &
        & 0.52216e+00_r8,0.54988e+00_r8,0.60294e+00_r8,0.63619e+00_r8,0.64521e+00_r8, &
        & 0.63878e+00_r8,0.61726e+00_r8,0.56850e+00_r8,0.56474e+00_r8 /)
      kao(:, 4, 6,10) = (/ &
        & 0.51474e+00_r8,0.54331e+00_r8,0.59815e+00_r8,0.63165e+00_r8,0.64200e+00_r8, &
        & 0.63625e+00_r8,0.61431e+00_r8,0.56860e+00_r8,0.56684e+00_r8 /)
      kao(:, 5, 6,10) = (/ &
        & 0.51206e+00_r8,0.53704e+00_r8,0.59303e+00_r8,0.62695e+00_r8,0.63853e+00_r8, &
        & 0.63290e+00_r8,0.61169e+00_r8,0.57018e+00_r8,0.56804e+00_r8 /)
      kao(:, 1, 7,10) = (/ &
        & 0.49102e+00_r8,0.52896e+00_r8,0.58005e+00_r8,0.60940e+00_r8,0.62179e+00_r8, &
        & 0.62452e+00_r8,0.60693e+00_r8,0.55666e+00_r8,0.53830e+00_r8 /)
      kao(:, 2, 7,10) = (/ &
        & 0.48351e+00_r8,0.52394e+00_r8,0.57551e+00_r8,0.60647e+00_r8,0.62043e+00_r8, &
        & 0.62318e+00_r8,0.60808e+00_r8,0.55693e+00_r8,0.53902e+00_r8 /)
      kao(:, 3, 7,10) = (/ &
        & 0.47604e+00_r8,0.51848e+00_r8,0.57124e+00_r8,0.60324e+00_r8,0.61835e+00_r8, &
        & 0.62080e+00_r8,0.60698e+00_r8,0.55691e+00_r8,0.54116e+00_r8 /)
      kao(:, 4, 7,10) = (/ &
        & 0.47121e+00_r8,0.51294e+00_r8,0.56659e+00_r8,0.59937e+00_r8,0.61527e+00_r8, &
        & 0.61807e+00_r8,0.60502e+00_r8,0.55819e+00_r8,0.54361e+00_r8 /)
      kao(:, 5, 7,10) = (/ &
        & 0.47306e+00_r8,0.50884e+00_r8,0.56199e+00_r8,0.59548e+00_r8,0.61135e+00_r8, &
        & 0.61474e+00_r8,0.60372e+00_r8,0.56024e+00_r8,0.54444e+00_r8 /)
      kao(:, 1, 8,10) = (/ &
        & 0.44396e+00_r8,0.49532e+00_r8,0.54249e+00_r8,0.57145e+00_r8,0.59186e+00_r8, &
        & 0.60060e+00_r8,0.58785e+00_r8,0.54441e+00_r8,0.50913e+00_r8 /)
      kao(:, 2, 8,10) = (/ &
        & 0.43707e+00_r8,0.49048e+00_r8,0.53914e+00_r8,0.56868e+00_r8,0.59107e+00_r8, &
        & 0.60049e+00_r8,0.58883e+00_r8,0.54507e+00_r8,0.51101e+00_r8 /)
      kao(:, 3, 8,10) = (/ &
        & 0.43098e+00_r8,0.48531e+00_r8,0.53541e+00_r8,0.56592e+00_r8,0.58911e+00_r8, &
        & 0.59846e+00_r8,0.58812e+00_r8,0.54578e+00_r8,0.51441e+00_r8 /)
      kao(:, 4, 8,10) = (/ &
        & 0.42957e+00_r8,0.48093e+00_r8,0.53173e+00_r8,0.56262e+00_r8,0.58636e+00_r8, &
        & 0.59589e+00_r8,0.58708e+00_r8,0.54776e+00_r8,0.51773e+00_r8 /)
      kao(:, 5, 8,10) = (/ &
        & 0.43487e+00_r8,0.48035e+00_r8,0.52822e+00_r8,0.55903e+00_r8,0.58272e+00_r8, &
        & 0.59353e+00_r8,0.58697e+00_r8,0.54985e+00_r8,0.51918e+00_r8 /)
      kao(:, 1, 9,10) = (/ &
        & 0.39531e+00_r8,0.46021e+00_r8,0.50510e+00_r8,0.53588e+00_r8,0.55895e+00_r8, &
        & 0.56979e+00_r8,0.56191e+00_r8,0.52659e+00_r8,0.47758e+00_r8 /)
      kao(:, 2, 9,10) = (/ &
        & 0.38905e+00_r8,0.45517e+00_r8,0.50180e+00_r8,0.53416e+00_r8,0.55846e+00_r8, &
        & 0.57047e+00_r8,0.56355e+00_r8,0.52717e+00_r8,0.48088e+00_r8 /)
      kao(:, 3, 9,10) = (/ &
        & 0.38493e+00_r8,0.45067e+00_r8,0.49854e+00_r8,0.53220e+00_r8,0.55699e+00_r8, &
        & 0.56934e+00_r8,0.56332e+00_r8,0.52868e+00_r8,0.48536e+00_r8 /)
      kao(:, 4, 9,10) = (/ &
        & 0.38723e+00_r8,0.44786e+00_r8,0.49546e+00_r8,0.52928e+00_r8,0.55471e+00_r8, &
        & 0.56730e+00_r8,0.56372e+00_r8,0.53178e+00_r8,0.48902e+00_r8 /)
      kao(:, 5, 9,10) = (/ &
        & 0.39433e+00_r8,0.45054e+00_r8,0.49350e+00_r8,0.52621e+00_r8,0.55192e+00_r8, &
        & 0.56604e+00_r8,0.56481e+00_r8,0.53491e+00_r8,0.49067e+00_r8 /)
      kao(:, 1,10,10) = (/ &
        & 0.34716e+00_r8,0.41992e+00_r8,0.46841e+00_r8,0.50264e+00_r8,0.52377e+00_r8, &
        & 0.53462e+00_r8,0.53096e+00_r8,0.50215e+00_r8,0.44481e+00_r8 /)
      kao(:, 2,10,10) = (/ &
        & 0.34195e+00_r8,0.41601e+00_r8,0.46506e+00_r8,0.50165e+00_r8,0.52385e+00_r8, &
        & 0.53574e+00_r8,0.53310e+00_r8,0.50401e+00_r8,0.44924e+00_r8 /)
      kao(:, 3,10,10) = (/ &
        & 0.34072e+00_r8,0.41255e+00_r8,0.46265e+00_r8,0.50007e+00_r8,0.52273e+00_r8, &
        & 0.53553e+00_r8,0.53434e+00_r8,0.50668e+00_r8,0.45414e+00_r8 /)
      kao(:, 4,10,10) = (/ &
        & 0.34572e+00_r8,0.41258e+00_r8,0.46029e+00_r8,0.49770e+00_r8,0.52100e+00_r8, &
        & 0.53482e+00_r8,0.53633e+00_r8,0.51056e+00_r8,0.45768e+00_r8 /)
      kao(:, 5,10,10) = (/ &
        & 0.35242e+00_r8,0.41826e+00_r8,0.46028e+00_r8,0.49520e+00_r8,0.51927e+00_r8, &
        & 0.53500e+00_r8,0.53892e+00_r8,0.51405e+00_r8,0.45947e+00_r8 /)
      kao(:, 1,11,10) = (/ &
        & 0.30160e+00_r8,0.37714e+00_r8,0.42971e+00_r8,0.46717e+00_r8,0.48926e+00_r8, &
        & 0.49871e+00_r8,0.49756e+00_r8,0.47436e+00_r8,0.41261e+00_r8 /)
      kao(:, 2,11,10) = (/ &
        & 0.29962e+00_r8,0.37395e+00_r8,0.42779e+00_r8,0.46654e+00_r8,0.48929e+00_r8, &
        & 0.49998e+00_r8,0.50016e+00_r8,0.47769e+00_r8,0.41819e+00_r8 /)
      kao(:, 3,11,10) = (/ &
        & 0.30371e+00_r8,0.37339e+00_r8,0.42611e+00_r8,0.46502e+00_r8,0.48821e+00_r8, &
        & 0.50080e+00_r8,0.50323e+00_r8,0.48215e+00_r8,0.42266e+00_r8 /)
      kao(:, 4,11,10) = (/ &
        & 0.30955e+00_r8,0.37857e+00_r8,0.42639e+00_r8,0.46320e+00_r8,0.48745e+00_r8, &
        & 0.50213e+00_r8,0.50694e+00_r8,0.48639e+00_r8,0.42570e+00_r8 /)
      kao(:, 5,11,10) = (/ &
        & 0.31511e+00_r8,0.38606e+00_r8,0.43107e+00_r8,0.46346e+00_r8,0.48731e+00_r8, &
        & 0.50398e+00_r8,0.50975e+00_r8,0.48945e+00_r8,0.42790e+00_r8 /)
      kao(:, 1,12,10) = (/ &
        & 0.26311e+00_r8,0.33847e+00_r8,0.39159e+00_r8,0.42993e+00_r8,0.45370e+00_r8, &
        & 0.46372e+00_r8,0.46279e+00_r8,0.44427e+00_r8,0.37907e+00_r8 /)
      kao(:, 2,12,10) = (/ &
        & 0.26583e+00_r8,0.33679e+00_r8,0.39073e+00_r8,0.42938e+00_r8,0.45415e+00_r8, &
        & 0.46569e+00_r8,0.46639e+00_r8,0.44945e+00_r8,0.38485e+00_r8 /)
      kao(:, 3,12,10) = (/ &
        & 0.27082e+00_r8,0.34071e+00_r8,0.39077e+00_r8,0.42842e+00_r8,0.45412e+00_r8, &
        & 0.46820e+00_r8,0.47089e+00_r8,0.45477e+00_r8,0.38900e+00_r8 /)
      kao(:, 4,12,10) = (/ &
        & 0.27574e+00_r8,0.34733e+00_r8,0.39532e+00_r8,0.42923e+00_r8,0.45504e+00_r8, &
        & 0.47097e+00_r8,0.47486e+00_r8,0.45848e+00_r8,0.39247e+00_r8 /)
      kao(:, 5,12,10) = (/ &
        & 0.28099e+00_r8,0.35386e+00_r8,0.40190e+00_r8,0.43447e+00_r8,0.45757e+00_r8, &
        & 0.47294e+00_r8,0.47760e+00_r8,0.46125e+00_r8,0.39629e+00_r8 /)
      kao(:, 1,13,10) = (/ &
        & 0.23133e+00_r8,0.30448e+00_r8,0.35592e+00_r8,0.39245e+00_r8,0.41703e+00_r8, &
        & 0.42944e+00_r8,0.42838e+00_r8,0.41191e+00_r8,0.34405e+00_r8 /)
      kao(:, 2,13,10) = (/ &
        & 0.23569e+00_r8,0.30675e+00_r8,0.35574e+00_r8,0.39238e+00_r8,0.41854e+00_r8, &
        & 0.43261e+00_r8,0.43319e+00_r8,0.41851e+00_r8,0.34979e+00_r8 /)
      kao(:, 3,13,10) = (/ &
        & 0.23995e+00_r8,0.31287e+00_r8,0.35958e+00_r8,0.39339e+00_r8,0.42025e+00_r8, &
        & 0.43649e+00_r8,0.43814e+00_r8,0.42387e+00_r8,0.35427e+00_r8 /)
      kao(:, 4,13,10) = (/ &
        & 0.24491e+00_r8,0.31868e+00_r8,0.36597e+00_r8,0.39887e+00_r8,0.42348e+00_r8, &
        & 0.43960e+00_r8,0.44180e+00_r8,0.42781e+00_r8,0.35946e+00_r8 /)
      kao(:, 5,13,10) = (/ &
        & 0.25204e+00_r8,0.32443e+00_r8,0.37244e+00_r8,0.40709e+00_r8,0.42924e+00_r8, &
        & 0.44176e+00_r8,0.44465e+00_r8,0.43196e+00_r8,0.36481e+00_r8 /)
      kao(:, 1, 1,11) = (/ &
        & 0.10293e+01_r8,0.90445e+00_r8,0.86137e+00_r8,0.83022e+00_r8,0.84086e+00_r8, &
        & 0.86548e+00_r8,0.85587e+00_r8,0.85325e+00_r8,0.97261e+00_r8 /)
      kao(:, 2, 1,11) = (/ &
        & 0.10191e+01_r8,0.89556e+00_r8,0.85472e+00_r8,0.82839e+00_r8,0.83827e+00_r8, &
        & 0.86712e+00_r8,0.85626e+00_r8,0.85096e+00_r8,0.97088e+00_r8 /)
      kao(:, 3, 1,11) = (/ &
        & 0.10070e+01_r8,0.88513e+00_r8,0.84750e+00_r8,0.82570e+00_r8,0.83354e+00_r8, &
        & 0.86668e+00_r8,0.85692e+00_r8,0.84837e+00_r8,0.96710e+00_r8 /)
      kao(:, 4, 1,11) = (/ &
        & 0.99477e+00_r8,0.87449e+00_r8,0.83958e+00_r8,0.82146e+00_r8,0.82897e+00_r8, &
        & 0.86436e+00_r8,0.85744e+00_r8,0.84703e+00_r8,0.96450e+00_r8 /)
      kao(:, 5, 1,11) = (/ &
        & 0.98126e+00_r8,0.86272e+00_r8,0.83128e+00_r8,0.81555e+00_r8,0.82401e+00_r8, &
        & 0.85929e+00_r8,0.85825e+00_r8,0.84707e+00_r8,0.96358e+00_r8 /)
      kao(:, 1, 2,11) = (/ &
        & 0.10475e+01_r8,0.93151e+00_r8,0.89830e+00_r8,0.88420e+00_r8,0.87933e+00_r8, &
        & 0.87846e+00_r8,0.87987e+00_r8,0.86086e+00_r8,0.97265e+00_r8 /)
      kao(:, 2, 2,11) = (/ &
        & 0.10370e+01_r8,0.92196e+00_r8,0.89215e+00_r8,0.88284e+00_r8,0.87783e+00_r8, &
        & 0.88073e+00_r8,0.88059e+00_r8,0.85882e+00_r8,0.96972e+00_r8 /)
      kao(:, 3, 2,11) = (/ &
        & 0.10244e+01_r8,0.91082e+00_r8,0.88511e+00_r8,0.87976e+00_r8,0.87455e+00_r8, &
        & 0.88046e+00_r8,0.88070e+00_r8,0.85623e+00_r8,0.96599e+00_r8 /)
      kao(:, 4, 2,11) = (/ &
        & 0.10111e+01_r8,0.89911e+00_r8,0.87761e+00_r8,0.87481e+00_r8,0.87132e+00_r8, &
        & 0.87692e+00_r8,0.88074e+00_r8,0.85652e+00_r8,0.96500e+00_r8 /)
      kao(:, 5, 2,11) = (/ &
        & 0.99734e+00_r8,0.88696e+00_r8,0.86940e+00_r8,0.86908e+00_r8,0.86706e+00_r8, &
        & 0.87191e+00_r8,0.88156e+00_r8,0.85742e+00_r8,0.96567e+00_r8 /)
      kao(:, 1, 3,11) = (/ &
        & 0.10481e+01_r8,0.94949e+00_r8,0.92754e+00_r8,0.93134e+00_r8,0.92020e+00_r8, &
        & 0.88963e+00_r8,0.89353e+00_r8,0.87368e+00_r8,0.96341e+00_r8 /)
      kao(:, 2, 3,11) = (/ &
        & 0.10364e+01_r8,0.93961e+00_r8,0.92141e+00_r8,0.92962e+00_r8,0.91951e+00_r8, &
        & 0.89266e+00_r8,0.89347e+00_r8,0.87218e+00_r8,0.95995e+00_r8 /)
      kao(:, 3, 3,11) = (/ &
        & 0.10237e+01_r8,0.92877e+00_r8,0.91434e+00_r8,0.92574e+00_r8,0.91740e+00_r8, &
        & 0.89302e+00_r8,0.89281e+00_r8,0.87167e+00_r8,0.95907e+00_r8 /)
      kao(:, 4, 3,11) = (/ &
        & 0.10107e+01_r8,0.91711e+00_r8,0.90716e+00_r8,0.92023e+00_r8,0.91517e+00_r8, &
        & 0.89037e+00_r8,0.89222e+00_r8,0.87266e+00_r8,0.95928e+00_r8 /)
      kao(:, 5, 3,11) = (/ &
        & 0.99633e+00_r8,0.90470e+00_r8,0.89927e+00_r8,0.91439e+00_r8,0.91120e+00_r8, &
        & 0.88600e+00_r8,0.89266e+00_r8,0.87273e+00_r8,0.95886e+00_r8 /)
      kao(:, 1, 4,11) = (/ &
        & 0.10264e+01_r8,0.95071e+00_r8,0.94674e+00_r8,0.96322e+00_r8,0.95099e+00_r8, &
        & 0.91374e+00_r8,0.89446e+00_r8,0.87855e+00_r8,0.93628e+00_r8 /)
      kao(:, 2, 4,11) = (/ &
        & 0.10149e+01_r8,0.94036e+00_r8,0.94196e+00_r8,0.96089e+00_r8,0.95153e+00_r8, &
        & 0.91752e+00_r8,0.89401e+00_r8,0.87842e+00_r8,0.93496e+00_r8 /)
      kao(:, 3, 4,11) = (/ &
        & 0.10022e+01_r8,0.92957e+00_r8,0.93566e+00_r8,0.95688e+00_r8,0.95066e+00_r8, &
        & 0.91784e+00_r8,0.89284e+00_r8,0.87926e+00_r8,0.93586e+00_r8 /)
      kao(:, 4, 4,11) = (/ &
        & 0.98847e+00_r8,0.91773e+00_r8,0.92854e+00_r8,0.95134e+00_r8,0.94862e+00_r8, &
        & 0.91547e+00_r8,0.89366e+00_r8,0.87951e+00_r8,0.93591e+00_r8 /)
      kao(:, 5, 4,11) = (/ &
        & 0.97390e+00_r8,0.90550e+00_r8,0.92045e+00_r8,0.94604e+00_r8,0.94431e+00_r8, &
        & 0.91218e+00_r8,0.89395e+00_r8,0.87858e+00_r8,0.93476e+00_r8 /)
      kao(:, 1, 5,11) = (/ &
        & 0.98609e+00_r8,0.93424e+00_r8,0.95643e+00_r8,0.97684e+00_r8,0.96999e+00_r8, &
        & 0.93774e+00_r8,0.88693e+00_r8,0.86915e+00_r8,0.90145e+00_r8 /)
      kao(:, 2, 5,11) = (/ &
        & 0.97412e+00_r8,0.92401e+00_r8,0.95137e+00_r8,0.97507e+00_r8,0.97005e+00_r8, &
        & 0.94299e+00_r8,0.88698e+00_r8,0.86947e+00_r8,0.90218e+00_r8 /)
      kao(:, 3, 5,11) = (/ &
        & 0.96114e+00_r8,0.91242e+00_r8,0.94531e+00_r8,0.97096e+00_r8,0.96958e+00_r8, &
        & 0.94325e+00_r8,0.88812e+00_r8,0.86965e+00_r8,0.90220e+00_r8 /)
      kao(:, 4, 5,11) = (/ &
        & 0.94742e+00_r8,0.90067e+00_r8,0.93796e+00_r8,0.96622e+00_r8,0.96802e+00_r8, &
        & 0.94082e+00_r8,0.89013e+00_r8,0.86974e+00_r8,0.90156e+00_r8 /)
      kao(:, 5, 5,11) = (/ &
        & 0.93336e+00_r8,0.88866e+00_r8,0.92975e+00_r8,0.96102e+00_r8,0.96365e+00_r8, &
        & 0.93814e+00_r8,0.89133e+00_r8,0.86813e+00_r8,0.89955e+00_r8 /)
      kao(:, 1, 6,11) = (/ &
        & 0.92984e+00_r8,0.90494e+00_r8,0.94972e+00_r8,0.97425e+00_r8,0.97662e+00_r8, &
        & 0.94556e+00_r8,0.88351e+00_r8,0.85584e+00_r8,0.87463e+00_r8 /)
      kao(:, 2, 6,11) = (/ &
        & 0.91725e+00_r8,0.89370e+00_r8,0.94535e+00_r8,0.97222e+00_r8,0.97680e+00_r8, &
        & 0.95110e+00_r8,0.88518e+00_r8,0.85597e+00_r8,0.87435e+00_r8 /)
      kao(:, 3, 6,11) = (/ &
        & 0.90427e+00_r8,0.88250e+00_r8,0.93903e+00_r8,0.96844e+00_r8,0.97606e+00_r8, &
        & 0.95304e+00_r8,0.88753e+00_r8,0.85497e+00_r8,0.87307e+00_r8 /)
      kao(:, 4, 6,11) = (/ &
        & 0.89063e+00_r8,0.87150e+00_r8,0.93110e+00_r8,0.96495e+00_r8,0.97386e+00_r8, &
        & 0.95208e+00_r8,0.89056e+00_r8,0.85380e+00_r8,0.87067e+00_r8 /)
      kao(:, 5, 6,11) = (/ &
        & 0.87675e+00_r8,0.86027e+00_r8,0.92261e+00_r8,0.96002e+00_r8,0.96930e+00_r8, &
        & 0.94959e+00_r8,0.89201e+00_r8,0.85155e+00_r8,0.86905e+00_r8 /)
      kao(:, 1, 7,11) = (/ &
        & 0.85919e+00_r8,0.86562e+00_r8,0.92649e+00_r8,0.95965e+00_r8,0.96523e+00_r8, &
        & 0.93650e+00_r8,0.88529e+00_r8,0.84057e+00_r8,0.84722e+00_r8 /)
      kao(:, 2, 7,11) = (/ &
        & 0.84717e+00_r8,0.85599e+00_r8,0.92166e+00_r8,0.95676e+00_r8,0.96677e+00_r8, &
        & 0.94156e+00_r8,0.88807e+00_r8,0.84087e+00_r8,0.84785e+00_r8 /)
      kao(:, 3, 7,11) = (/ &
        & 0.83473e+00_r8,0.84556e+00_r8,0.91525e+00_r8,0.95342e+00_r8,0.96579e+00_r8, &
        & 0.94506e+00_r8,0.89084e+00_r8,0.83990e+00_r8,0.84680e+00_r8 /)
      kao(:, 4, 7,11) = (/ &
        & 0.82211e+00_r8,0.83508e+00_r8,0.90782e+00_r8,0.94944e+00_r8,0.96296e+00_r8, &
        & 0.94530e+00_r8,0.89295e+00_r8,0.83822e+00_r8,0.84533e+00_r8 /)
      kao(:, 5, 7,11) = (/ &
        & 0.80945e+00_r8,0.82542e+00_r8,0.90011e+00_r8,0.94513e+00_r8,0.95957e+00_r8, &
        & 0.94356e+00_r8,0.89326e+00_r8,0.83636e+00_r8,0.84582e+00_r8 /)
      kao(:, 1, 8,11) = (/ &
        & 0.78535e+00_r8,0.81958e+00_r8,0.89069e+00_r8,0.92943e+00_r8,0.93702e+00_r8, &
        & 0.91895e+00_r8,0.88182e+00_r8,0.81942e+00_r8,0.81355e+00_r8 /)
      kao(:, 2, 8,11) = (/ &
        & 0.77455e+00_r8,0.81120e+00_r8,0.88449e+00_r8,0.92737e+00_r8,0.93847e+00_r8, &
        & 0.92275e+00_r8,0.88568e+00_r8,0.82187e+00_r8,0.81529e+00_r8 /)
      kao(:, 3, 8,11) = (/ &
        & 0.76320e+00_r8,0.80325e+00_r8,0.87799e+00_r8,0.92413e+00_r8,0.93785e+00_r8, &
        & 0.92584e+00_r8,0.88848e+00_r8,0.82246e+00_r8,0.81526e+00_r8 /)
      kao(:, 4, 8,11) = (/ &
        & 0.75209e+00_r8,0.79461e+00_r8,0.87173e+00_r8,0.92037e+00_r8,0.93562e+00_r8, &
        & 0.92659e+00_r8,0.89042e+00_r8,0.82203e+00_r8,0.81583e+00_r8 /)
      kao(:, 5, 8,11) = (/ &
        & 0.74191e+00_r8,0.78569e+00_r8,0.86500e+00_r8,0.91565e+00_r8,0.93275e+00_r8, &
        & 0.92508e+00_r8,0.89021e+00_r8,0.82215e+00_r8,0.81833e+00_r8 /)
      kao(:, 1, 9,11) = (/ &
        & 0.71539e+00_r8,0.77045e+00_r8,0.84442e+00_r8,0.88339e+00_r8,0.89968e+00_r8, &
        & 0.89536e+00_r8,0.86841e+00_r8,0.79955e+00_r8,0.77318e+00_r8 /)
      kao(:, 2, 9,11) = (/ &
        & 0.70564e+00_r8,0.76424e+00_r8,0.83867e+00_r8,0.88222e+00_r8,0.90019e+00_r8, &
        & 0.89929e+00_r8,0.87308e+00_r8,0.80390e+00_r8,0.77664e+00_r8 /)
      kao(:, 3, 9,11) = (/ &
        & 0.69566e+00_r8,0.75811e+00_r8,0.83280e+00_r8,0.87940e+00_r8,0.90026e+00_r8, &
        & 0.90222e+00_r8,0.87663e+00_r8,0.80593e+00_r8,0.77834e+00_r8 /)
      kao(:, 4, 9,11) = (/ &
        & 0.68611e+00_r8,0.75067e+00_r8,0.82727e+00_r8,0.87623e+00_r8,0.89845e+00_r8, &
        & 0.90248e+00_r8,0.87886e+00_r8,0.80698e+00_r8,0.78085e+00_r8 /)
      kao(:, 5, 9,11) = (/ &
        & 0.67924e+00_r8,0.74336e+00_r8,0.82173e+00_r8,0.87192e+00_r8,0.89575e+00_r8, &
        & 0.90118e+00_r8,0.87929e+00_r8,0.80840e+00_r8,0.78556e+00_r8 /)
      kao(:, 1,10,11) = (/ &
        & 0.64750e+00_r8,0.72291e+00_r8,0.79049e+00_r8,0.83093e+00_r8,0.85723e+00_r8, &
        & 0.86420e+00_r8,0.84410e+00_r8,0.78062e+00_r8,0.72995e+00_r8 /)
      kao(:, 2,10,11) = (/ &
        & 0.63786e+00_r8,0.71701e+00_r8,0.78689e+00_r8,0.82920e+00_r8,0.85838e+00_r8, &
        & 0.86903e+00_r8,0.84994e+00_r8,0.78581e+00_r8,0.73484e+00_r8 /)
      kao(:, 3,10,11) = (/ &
        & 0.62879e+00_r8,0.71055e+00_r8,0.78212e+00_r8,0.82630e+00_r8,0.85919e+00_r8, &
        & 0.87234e+00_r8,0.85358e+00_r8,0.78925e+00_r8,0.73873e+00_r8 /)
      kao(:, 4,10,11) = (/ &
        & 0.62087e+00_r8,0.70389e+00_r8,0.77761e+00_r8,0.82356e+00_r8,0.85812e+00_r8, &
        & 0.87281e+00_r8,0.85602e+00_r8,0.79174e+00_r8,0.74394e+00_r8 /)
      kao(:, 5,10,11) = (/ &
        & 0.61947e+00_r8,0.69759e+00_r8,0.77360e+00_r8,0.82013e+00_r8,0.85542e+00_r8, &
        & 0.87157e+00_r8,0.85709e+00_r8,0.79529e+00_r8,0.75052e+00_r8 /)
      kao(:, 1,11,11) = (/ &
        & 0.57317e+00_r8,0.67082e+00_r8,0.73559e+00_r8,0.77934e+00_r8,0.81170e+00_r8, &
        & 0.82582e+00_r8,0.81431e+00_r8,0.75887e+00_r8,0.68710e+00_r8 /)
      kao(:, 2,11,11) = (/ &
        & 0.56447e+00_r8,0.66437e+00_r8,0.73216e+00_r8,0.77740e+00_r8,0.81370e+00_r8, &
        & 0.83183e+00_r8,0.81926e+00_r8,0.76438e+00_r8,0.69316e+00_r8 /)
      kao(:, 3,11,11) = (/ &
        & 0.55710e+00_r8,0.65798e+00_r8,0.72792e+00_r8,0.77609e+00_r8,0.81480e+00_r8, &
        & 0.83377e+00_r8,0.82304e+00_r8,0.76833e+00_r8,0.70018e+00_r8 /)
      kao(:, 4,11,11) = (/ &
        & 0.55630e+00_r8,0.65257e+00_r8,0.72437e+00_r8,0.77329e+00_r8,0.81397e+00_r8, &
        & 0.83437e+00_r8,0.82566e+00_r8,0.77320e+00_r8,0.70886e+00_r8 /)
      kao(:, 5,11,11) = (/ &
        & 0.56411e+00_r8,0.65194e+00_r8,0.72119e+00_r8,0.77017e+00_r8,0.81118e+00_r8, &
        & 0.83405e+00_r8,0.82785e+00_r8,0.77913e+00_r8,0.71658e+00_r8 /)
      kao(:, 1,12,11) = (/ &
        & 0.50093e+00_r8,0.61265e+00_r8,0.68222e+00_r8,0.73081e+00_r8,0.76376e+00_r8, &
        & 0.78196e+00_r8,0.77611e+00_r8,0.73046e+00_r8,0.64374e+00_r8 /)
      kao(:, 2,12,11) = (/ &
        & 0.49374e+00_r8,0.60693e+00_r8,0.67860e+00_r8,0.73087e+00_r8,0.76701e+00_r8, &
        & 0.78657e+00_r8,0.78196e+00_r8,0.73646e+00_r8,0.65183e+00_r8 /)
      kao(:, 3,12,11) = (/ &
        & 0.49262e+00_r8,0.60232e+00_r8,0.67517e+00_r8,0.73017e+00_r8,0.76805e+00_r8, &
        & 0.78863e+00_r8,0.78651e+00_r8,0.74261e+00_r8,0.66205e+00_r8 /)
      kao(:, 4,12,11) = (/ &
        & 0.49989e+00_r8,0.60234e+00_r8,0.67259e+00_r8,0.72790e+00_r8,0.76753e+00_r8, &
        & 0.79017e+00_r8,0.79054e+00_r8,0.75027e+00_r8,0.67174e+00_r8 /)
      kao(:, 5,12,11) = (/ &
        & 0.51177e+00_r8,0.60963e+00_r8,0.67313e+00_r8,0.72489e+00_r8,0.76606e+00_r8, &
        & 0.79187e+00_r8,0.79524e+00_r8,0.75809e+00_r8,0.67955e+00_r8 /)
      kao(:, 1,13,11) = (/ &
        & 0.43610e+00_r8,0.55280e+00_r8,0.62805e+00_r8,0.68236e+00_r8,0.71726e+00_r8, &
        & 0.73439e+00_r8,0.73316e+00_r8,0.69581e+00_r8,0.60098e+00_r8 /)
      kao(:, 2,13,11) = (/ &
        & 0.43332e+00_r8,0.54879e+00_r8,0.62602e+00_r8,0.68387e+00_r8,0.71981e+00_r8, &
        & 0.73863e+00_r8,0.74004e+00_r8,0.70395e+00_r8,0.61188e+00_r8 /)
      kao(:, 3,13,11) = (/ &
        & 0.43938e+00_r8,0.54819e+00_r8,0.62420e+00_r8,0.68392e+00_r8,0.72120e+00_r8, &
        & 0.74159e+00_r8,0.74634e+00_r8,0.71286e+00_r8,0.62343e+00_r8 /)
      kao(:, 4,13,11) = (/ &
        & 0.44997e+00_r8,0.55515e+00_r8,0.62479e+00_r8,0.68255e+00_r8,0.72173e+00_r8, &
        & 0.74510e+00_r8,0.75297e+00_r8,0.72278e+00_r8,0.63265e+00_r8 /)
      kao(:, 5,13,11) = (/ &
        & 0.46055e+00_r8,0.56787e+00_r8,0.63110e+00_r8,0.68248e+00_r8,0.72225e+00_r8, &
        & 0.74921e+00_r8,0.75987e+00_r8,0.73098e+00_r8,0.64026e+00_r8 /)
      kao(:, 1, 1,12) = (/ &
        & 0.14171e+01_r8,0.12412e+01_r8,0.11453e+01_r8,0.11122e+01_r8,0.11253e+01_r8, &
        & 0.11573e+01_r8,0.11791e+01_r8,0.12973e+01_r8,0.14638e+01_r8 /)
      kao(:, 2, 1,12) = (/ &
        & 0.14090e+01_r8,0.12342e+01_r8,0.11388e+01_r8,0.11095e+01_r8,0.11322e+01_r8, &
        & 0.11607e+01_r8,0.11781e+01_r8,0.12938e+01_r8,0.14611e+01_r8 /)
      kao(:, 3, 1,12) = (/ &
        & 0.13994e+01_r8,0.12258e+01_r8,0.11299e+01_r8,0.11046e+01_r8,0.11339e+01_r8, &
        & 0.11641e+01_r8,0.11762e+01_r8,0.12907e+01_r8,0.14569e+01_r8 /)
      kao(:, 4, 1,12) = (/ &
        & 0.13872e+01_r8,0.12151e+01_r8,0.11205e+01_r8,0.10983e+01_r8,0.11321e+01_r8, &
        & 0.11655e+01_r8,0.11746e+01_r8,0.12884e+01_r8,0.14537e+01_r8 /)
      kao(:, 5, 1,12) = (/ &
        & 0.13737e+01_r8,0.12034e+01_r8,0.11101e+01_r8,0.10915e+01_r8,0.11280e+01_r8, &
        & 0.11664e+01_r8,0.11724e+01_r8,0.12834e+01_r8,0.14491e+01_r8 /)
      kao(:, 1, 2,12) = (/ &
        & 0.15051e+01_r8,0.13181e+01_r8,0.12304e+01_r8,0.11719e+01_r8,0.11855e+01_r8, &
        & 0.12309e+01_r8,0.12496e+01_r8,0.13203e+01_r8,0.15049e+01_r8 /)
      kao(:, 2, 2,12) = (/ &
        & 0.14984e+01_r8,0.13123e+01_r8,0.12250e+01_r8,0.11699e+01_r8,0.11925e+01_r8, &
        & 0.12340e+01_r8,0.12487e+01_r8,0.13193e+01_r8,0.15024e+01_r8 /)
      kao(:, 3, 2,12) = (/ &
        & 0.14884e+01_r8,0.13036e+01_r8,0.12176e+01_r8,0.11665e+01_r8,0.11942e+01_r8, &
        & 0.12376e+01_r8,0.12478e+01_r8,0.13196e+01_r8,0.15020e+01_r8 /)
      kao(:, 4, 2,12) = (/ &
        & 0.14762e+01_r8,0.12929e+01_r8,0.12082e+01_r8,0.11628e+01_r8,0.11911e+01_r8, &
        & 0.12406e+01_r8,0.12476e+01_r8,0.13168e+01_r8,0.15001e+01_r8 /)
      kao(:, 5, 2,12) = (/ &
        & 0.14614e+01_r8,0.12800e+01_r8,0.11975e+01_r8,0.11575e+01_r8,0.11857e+01_r8, &
        & 0.12414e+01_r8,0.12460e+01_r8,0.13124e+01_r8,0.14945e+01_r8 /)
      kao(:, 1, 3,12) = (/ &
        & 0.15822e+01_r8,0.13890e+01_r8,0.13182e+01_r8,0.12547e+01_r8,0.12476e+01_r8, &
        & 0.12873e+01_r8,0.13056e+01_r8,0.13300e+01_r8,0.15181e+01_r8 /)
      kao(:, 2, 3,12) = (/ &
        & 0.15752e+01_r8,0.13826e+01_r8,0.13120e+01_r8,0.12557e+01_r8,0.12556e+01_r8, &
        & 0.12906e+01_r8,0.13067e+01_r8,0.13310e+01_r8,0.15193e+01_r8 /)
      kao(:, 3, 3,12) = (/ &
        & 0.15647e+01_r8,0.13732e+01_r8,0.13046e+01_r8,0.12538e+01_r8,0.12575e+01_r8, &
        & 0.12941e+01_r8,0.13084e+01_r8,0.13307e+01_r8,0.15193e+01_r8 /)
      kao(:, 4, 3,12) = (/ &
        & 0.15514e+01_r8,0.13616e+01_r8,0.12950e+01_r8,0.12500e+01_r8,0.12556e+01_r8, &
        & 0.12989e+01_r8,0.13088e+01_r8,0.13292e+01_r8,0.15174e+01_r8 /)
      kao(:, 5, 3,12) = (/ &
        & 0.15358e+01_r8,0.13480e+01_r8,0.12843e+01_r8,0.12443e+01_r8,0.12517e+01_r8, &
        & 0.13009e+01_r8,0.13074e+01_r8,0.13265e+01_r8,0.15142e+01_r8 /)
      kao(:, 1, 4,12) = (/ &
        & 0.16350e+01_r8,0.14490e+01_r8,0.13916e+01_r8,0.13443e+01_r8,0.13174e+01_r8, &
        & 0.13244e+01_r8,0.13476e+01_r8,0.13365e+01_r8,0.15180e+01_r8 /)
      kao(:, 2, 4,12) = (/ &
        & 0.16281e+01_r8,0.14425e+01_r8,0.13866e+01_r8,0.13479e+01_r8,0.13260e+01_r8, &
        & 0.13268e+01_r8,0.13503e+01_r8,0.13390e+01_r8,0.15205e+01_r8 /)
      kao(:, 3, 4,12) = (/ &
        & 0.16161e+01_r8,0.14310e+01_r8,0.13789e+01_r8,0.13476e+01_r8,0.13293e+01_r8, &
        & 0.13314e+01_r8,0.13532e+01_r8,0.13408e+01_r8,0.15220e+01_r8 /)
      kao(:, 4, 4,12) = (/ &
        & 0.16014e+01_r8,0.14178e+01_r8,0.13691e+01_r8,0.13444e+01_r8,0.13282e+01_r8, &
        & 0.13379e+01_r8,0.13534e+01_r8,0.13410e+01_r8,0.15212e+01_r8 /)
      kao(:, 5, 4,12) = (/ &
        & 0.15848e+01_r8,0.14026e+01_r8,0.13577e+01_r8,0.13378e+01_r8,0.13257e+01_r8, &
        & 0.13408e+01_r8,0.13534e+01_r8,0.13387e+01_r8,0.15183e+01_r8 /)
      kao(:, 1, 5,12) = (/ &
        & 0.16591e+01_r8,0.14947e+01_r8,0.14480e+01_r8,0.14262e+01_r8,0.13903e+01_r8, &
        & 0.13587e+01_r8,0.13777e+01_r8,0.13491e+01_r8,0.15046e+01_r8 /)
      kao(:, 2, 5,12) = (/ &
        & 0.16509e+01_r8,0.14862e+01_r8,0.14440e+01_r8,0.14316e+01_r8,0.13991e+01_r8, &
        & 0.13598e+01_r8,0.13805e+01_r8,0.13541e+01_r8,0.15083e+01_r8 /)
      kao(:, 3, 5,12) = (/ &
        & 0.16386e+01_r8,0.14750e+01_r8,0.14364e+01_r8,0.14307e+01_r8,0.14045e+01_r8, &
        & 0.13655e+01_r8,0.13826e+01_r8,0.13579e+01_r8,0.15118e+01_r8 /)
      kao(:, 4, 5,12) = (/ &
        & 0.16229e+01_r8,0.14605e+01_r8,0.14277e+01_r8,0.14269e+01_r8,0.14036e+01_r8, &
        & 0.13722e+01_r8,0.13840e+01_r8,0.13579e+01_r8,0.15115e+01_r8 /)
      kao(:, 5, 5,12) = (/ &
        & 0.16043e+01_r8,0.14439e+01_r8,0.14169e+01_r8,0.14203e+01_r8,0.14024e+01_r8, &
        & 0.13765e+01_r8,0.13831e+01_r8,0.13575e+01_r8,0.15115e+01_r8 /)
      kao(:, 1, 6,12) = (/ &
        & 0.16482e+01_r8,0.15147e+01_r8,0.14918e+01_r8,0.14883e+01_r8,0.14555e+01_r8, &
        & 0.14030e+01_r8,0.13913e+01_r8,0.13585e+01_r8,0.14685e+01_r8 /)
      kao(:, 2, 6,12) = (/ &
        & 0.16385e+01_r8,0.15059e+01_r8,0.14880e+01_r8,0.14958e+01_r8,0.14629e+01_r8, &
        & 0.14056e+01_r8,0.13940e+01_r8,0.13659e+01_r8,0.14762e+01_r8 /)
      kao(:, 3, 6,12) = (/ &
        & 0.16253e+01_r8,0.14941e+01_r8,0.14803e+01_r8,0.14965e+01_r8,0.14689e+01_r8, &
        & 0.14106e+01_r8,0.13970e+01_r8,0.13717e+01_r8,0.14817e+01_r8 /)
      kao(:, 4, 6,12) = (/ &
        & 0.16089e+01_r8,0.14791e+01_r8,0.14713e+01_r8,0.14908e+01_r8,0.14702e+01_r8, &
        & 0.14165e+01_r8,0.13983e+01_r8,0.13748e+01_r8,0.14851e+01_r8 /)
      kao(:, 5, 6,12) = (/ &
        & 0.15910e+01_r8,0.14633e+01_r8,0.14618e+01_r8,0.14838e+01_r8,0.14693e+01_r8, &
        & 0.14213e+01_r8,0.13976e+01_r8,0.13770e+01_r8,0.14876e+01_r8 /)
      kao(:, 1, 7,12) = (/ &
        & 0.16064e+01_r8,0.15086e+01_r8,0.15144e+01_r8,0.15268e+01_r8,0.15040e+01_r8, &
        & 0.14507e+01_r8,0.13904e+01_r8,0.13521e+01_r8,0.14179e+01_r8 /)
      kao(:, 2, 7,12) = (/ &
        & 0.15953e+01_r8,0.14985e+01_r8,0.15140e+01_r8,0.15345e+01_r8,0.15085e+01_r8, &
        & 0.14549e+01_r8,0.13952e+01_r8,0.13604e+01_r8,0.14259e+01_r8 /)
      kao(:, 3, 7,12) = (/ &
        & 0.15801e+01_r8,0.14851e+01_r8,0.15073e+01_r8,0.15363e+01_r8,0.15134e+01_r8, &
        & 0.14598e+01_r8,0.13998e+01_r8,0.13678e+01_r8,0.14328e+01_r8 /)
      kao(:, 4, 7,12) = (/ &
        & 0.15629e+01_r8,0.14703e+01_r8,0.14995e+01_r8,0.15318e+01_r8,0.15172e+01_r8, &
        & 0.14656e+01_r8,0.14020e+01_r8,0.13732e+01_r8,0.14388e+01_r8 /)
      kao(:, 5, 7,12) = (/ &
        & 0.15443e+01_r8,0.14531e+01_r8,0.14892e+01_r8,0.15236e+01_r8,0.15169e+01_r8, &
        & 0.14692e+01_r8,0.14038e+01_r8,0.13766e+01_r8,0.14425e+01_r8 /)
      kao(:, 1, 8,12) = (/ &
        & 0.15344e+01_r8,0.14766e+01_r8,0.15157e+01_r8,0.15423e+01_r8,0.15330e+01_r8, &
        & 0.14811e+01_r8,0.13889e+01_r8,0.13373e+01_r8,0.13698e+01_r8 /)
      kao(:, 2, 8,12) = (/ &
        & 0.15222e+01_r8,0.14679e+01_r8,0.15175e+01_r8,0.15473e+01_r8,0.15363e+01_r8, &
        & 0.14872e+01_r8,0.13948e+01_r8,0.13442e+01_r8,0.13786e+01_r8 /)
      kao(:, 3, 8,12) = (/ &
        & 0.15059e+01_r8,0.14533e+01_r8,0.15144e+01_r8,0.15489e+01_r8,0.15409e+01_r8, &
        & 0.14932e+01_r8,0.14005e+01_r8,0.13518e+01_r8,0.13861e+01_r8 /)
      kao(:, 4, 8,12) = (/ &
        & 0.14877e+01_r8,0.14368e+01_r8,0.15058e+01_r8,0.15451e+01_r8,0.15445e+01_r8, &
        & 0.14989e+01_r8,0.14044e+01_r8,0.13574e+01_r8,0.13922e+01_r8 /)
      kao(:, 5, 8,12) = (/ &
        & 0.14686e+01_r8,0.14200e+01_r8,0.14953e+01_r8,0.15388e+01_r8,0.15447e+01_r8, &
        & 0.15024e+01_r8,0.14082e+01_r8,0.13605e+01_r8,0.13964e+01_r8 /)
      kao(:, 1, 9,12) = (/ &
        & 0.14373e+01_r8,0.14266e+01_r8,0.14938e+01_r8,0.15367e+01_r8,0.15341e+01_r8, &
        & 0.14871e+01_r8,0.13939e+01_r8,0.13173e+01_r8,0.13285e+01_r8 /)
      kao(:, 2, 9,12) = (/ &
        & 0.14250e+01_r8,0.14168e+01_r8,0.14968e+01_r8,0.15390e+01_r8,0.15386e+01_r8, &
        & 0.14934e+01_r8,0.13987e+01_r8,0.13260e+01_r8,0.13388e+01_r8 /)
      kao(:, 3, 9,12) = (/ &
        & 0.14085e+01_r8,0.14020e+01_r8,0.14946e+01_r8,0.15393e+01_r8,0.15430e+01_r8, &
        & 0.14996e+01_r8,0.14050e+01_r8,0.13340e+01_r8,0.13471e+01_r8 /)
      kao(:, 4, 9,12) = (/ &
        & 0.13898e+01_r8,0.13862e+01_r8,0.14874e+01_r8,0.15365e+01_r8,0.15469e+01_r8, &
        & 0.15061e+01_r8,0.14095e+01_r8,0.13387e+01_r8,0.13529e+01_r8 /)
      kao(:, 5, 9,12) = (/ &
        & 0.13711e+01_r8,0.13694e+01_r8,0.14772e+01_r8,0.15321e+01_r8,0.15481e+01_r8, &
        & 0.15103e+01_r8,0.14136e+01_r8,0.13413e+01_r8,0.13557e+01_r8 /)
      kao(:, 1,10,12) = (/ &
        & 0.13234e+01_r8,0.13585e+01_r8,0.14531e+01_r8,0.15073e+01_r8,0.15094e+01_r8, &
        & 0.14728e+01_r8,0.13972e+01_r8,0.12936e+01_r8,0.12835e+01_r8 /)
      kao(:, 2,10,12) = (/ &
        & 0.13109e+01_r8,0.13494e+01_r8,0.14540e+01_r8,0.15085e+01_r8,0.15139e+01_r8, &
        & 0.14784e+01_r8,0.14019e+01_r8,0.13047e+01_r8,0.12968e+01_r8 /)
      kao(:, 3,10,12) = (/ &
        & 0.12956e+01_r8,0.13371e+01_r8,0.14504e+01_r8,0.15092e+01_r8,0.15192e+01_r8, &
        & 0.14835e+01_r8,0.14094e+01_r8,0.13136e+01_r8,0.13076e+01_r8 /)
      kao(:, 4,10,12) = (/ &
        & 0.12784e+01_r8,0.13237e+01_r8,0.14435e+01_r8,0.15071e+01_r8,0.15234e+01_r8, &
        & 0.14905e+01_r8,0.14145e+01_r8,0.13190e+01_r8,0.13139e+01_r8 /)
      kao(:, 5,10,12) = (/ &
        & 0.12607e+01_r8,0.13090e+01_r8,0.14344e+01_r8,0.15038e+01_r8,0.15261e+01_r8, &
        & 0.14956e+01_r8,0.14181e+01_r8,0.13210e+01_r8,0.13178e+01_r8 /)
      kao(:, 1,11,12) = (/ &
        & 0.12047e+01_r8,0.12789e+01_r8,0.13923e+01_r8,0.14530e+01_r8,0.14659e+01_r8, &
        & 0.14483e+01_r8,0.13898e+01_r8,0.12749e+01_r8,0.12386e+01_r8 /)
      kao(:, 2,11,12) = (/ &
        & 0.11911e+01_r8,0.12701e+01_r8,0.13902e+01_r8,0.14549e+01_r8,0.14710e+01_r8, &
        & 0.14517e+01_r8,0.13981e+01_r8,0.12874e+01_r8,0.12546e+01_r8 /)
      kao(:, 3,11,12) = (/ &
        & 0.11768e+01_r8,0.12599e+01_r8,0.13852e+01_r8,0.14552e+01_r8,0.14760e+01_r8, &
        & 0.14581e+01_r8,0.14056e+01_r8,0.12968e+01_r8,0.12644e+01_r8 /)
      kao(:, 4,11,12) = (/ &
        & 0.11609e+01_r8,0.12491e+01_r8,0.13785e+01_r8,0.14542e+01_r8,0.14794e+01_r8, &
        & 0.14643e+01_r8,0.14106e+01_r8,0.13015e+01_r8,0.12707e+01_r8 /)
      kao(:, 5,11,12) = (/ &
        & 0.11453e+01_r8,0.12370e+01_r8,0.13722e+01_r8,0.14526e+01_r8,0.14820e+01_r8, &
        & 0.14680e+01_r8,0.14139e+01_r8,0.13041e+01_r8,0.12775e+01_r8 /)
      kao(:, 1,12,12) = (/ &
        & 0.10892e+01_r8,0.11978e+01_r8,0.13175e+01_r8,0.13800e+01_r8,0.14113e+01_r8, &
        & 0.14104e+01_r8,0.13697e+01_r8,0.12563e+01_r8,0.11895e+01_r8 /)
      kao(:, 2,12,12) = (/ &
        & 0.10764e+01_r8,0.11912e+01_r8,0.13142e+01_r8,0.13828e+01_r8,0.14151e+01_r8, &
        & 0.14161e+01_r8,0.13800e+01_r8,0.12704e+01_r8,0.12046e+01_r8 /)
      kao(:, 3,12,12) = (/ &
        & 0.10634e+01_r8,0.11835e+01_r8,0.13099e+01_r8,0.13835e+01_r8,0.14196e+01_r8, &
        & 0.14241e+01_r8,0.13887e+01_r8,0.12786e+01_r8,0.12148e+01_r8 /)
      kao(:, 4,12,12) = (/ &
        & 0.10495e+01_r8,0.11751e+01_r8,0.13057e+01_r8,0.13846e+01_r8,0.14230e+01_r8, &
        & 0.14300e+01_r8,0.13945e+01_r8,0.12836e+01_r8,0.12244e+01_r8 /)
      kao(:, 5,12,12) = (/ &
        & 0.10406e+01_r8,0.11650e+01_r8,0.13011e+01_r8,0.13864e+01_r8,0.14254e+01_r8, &
        & 0.14322e+01_r8,0.13980e+01_r8,0.12878e+01_r8,0.12342e+01_r8 /)
      kao(:, 1,13,12) = (/ &
        & 0.97671e+00_r8,0.11194e+01_r8,0.12352e+01_r8,0.13029e+01_r8,0.13468e+01_r8, &
        & 0.13623e+01_r8,0.13355e+01_r8,0.12363e+01_r8,0.11351e+01_r8 /)
      kao(:, 2,13,12) = (/ &
        & 0.96514e+00_r8,0.11135e+01_r8,0.12326e+01_r8,0.13049e+01_r8,0.13523e+01_r8, &
        & 0.13721e+01_r8,0.13488e+01_r8,0.12496e+01_r8,0.11500e+01_r8 /)
      kao(:, 3,13,12) = (/ &
        & 0.95350e+00_r8,0.11073e+01_r8,0.12308e+01_r8,0.13063e+01_r8,0.13575e+01_r8, &
        & 0.13815e+01_r8,0.13588e+01_r8,0.12584e+01_r8,0.11629e+01_r8 /)
      kao(:, 4,13,12) = (/ &
        & 0.94648e+00_r8,0.11002e+01_r8,0.12294e+01_r8,0.13087e+01_r8,0.13617e+01_r8, &
        & 0.13873e+01_r8,0.13660e+01_r8,0.12653e+01_r8,0.11761e+01_r8 /)
      kao(:, 5,13,12) = (/ &
        & 0.94953e+00_r8,0.10941e+01_r8,0.12277e+01_r8,0.13116e+01_r8,0.13645e+01_r8, &
        & 0.13901e+01_r8,0.13713e+01_r8,0.12717e+01_r8,0.11896e+01_r8 /)
      kao(:, 1, 1,13) = (/ &
        & 0.21877e+01_r8,0.19168e+01_r8,0.16830e+01_r8,0.16306e+01_r8,0.15763e+01_r8, &
        & 0.15398e+01_r8,0.15859e+01_r8,0.18468e+01_r8,0.20593e+01_r8 /)
      kao(:, 2, 1,13) = (/ &
        & 0.22022e+01_r8,0.19296e+01_r8,0.16916e+01_r8,0.16400e+01_r8,0.15796e+01_r8, &
        & 0.15432e+01_r8,0.15912e+01_r8,0.18534e+01_r8,0.20655e+01_r8 /)
      kao(:, 3, 1,13) = (/ &
        & 0.22022e+01_r8,0.19297e+01_r8,0.16911e+01_r8,0.16436e+01_r8,0.15885e+01_r8, &
        & 0.15469e+01_r8,0.15941e+01_r8,0.18569e+01_r8,0.20695e+01_r8 /)
      kao(:, 4, 1,13) = (/ &
        & 0.21895e+01_r8,0.19186e+01_r8,0.16803e+01_r8,0.16425e+01_r8,0.15962e+01_r8, &
        & 0.15525e+01_r8,0.15947e+01_r8,0.18575e+01_r8,0.20703e+01_r8 /)
      kao(:, 5, 1,13) = (/ &
        & 0.21697e+01_r8,0.19013e+01_r8,0.16648e+01_r8,0.16344e+01_r8,0.16003e+01_r8, &
        & 0.15574e+01_r8,0.15941e+01_r8,0.18572e+01_r8,0.20709e+01_r8 /)
      kao(:, 1, 2,13) = (/ &
        & 0.22550e+01_r8,0.19753e+01_r8,0.17734e+01_r8,0.17443e+01_r8,0.17102e+01_r8, &
        & 0.16986e+01_r8,0.17217e+01_r8,0.19863e+01_r8,0.22329e+01_r8 /)
      kao(:, 2, 2,13) = (/ &
        & 0.22679e+01_r8,0.19867e+01_r8,0.17791e+01_r8,0.17520e+01_r8,0.17112e+01_r8, &
        & 0.17026e+01_r8,0.17283e+01_r8,0.19934e+01_r8,0.22409e+01_r8 /)
      kao(:, 3, 2,13) = (/ &
        & 0.22698e+01_r8,0.19883e+01_r8,0.17767e+01_r8,0.17568e+01_r8,0.17174e+01_r8, &
        & 0.17053e+01_r8,0.17318e+01_r8,0.19966e+01_r8,0.22448e+01_r8 /)
      kao(:, 4, 2,13) = (/ &
        & 0.22597e+01_r8,0.19796e+01_r8,0.17668e+01_r8,0.17548e+01_r8,0.17261e+01_r8, &
        & 0.17073e+01_r8,0.17314e+01_r8,0.19968e+01_r8,0.22451e+01_r8 /)
      kao(:, 5, 2,13) = (/ &
        & 0.22409e+01_r8,0.19632e+01_r8,0.17511e+01_r8,0.17475e+01_r8,0.17318e+01_r8, &
        & 0.17099e+01_r8,0.17295e+01_r8,0.19947e+01_r8,0.22431e+01_r8 /)
      kao(:, 1, 3,13) = (/ &
        & 0.23526e+01_r8,0.20603e+01_r8,0.18829e+01_r8,0.18493e+01_r8,0.18420e+01_r8, &
        & 0.18637e+01_r8,0.18729e+01_r8,0.21122e+01_r8,0.23977e+01_r8 /)
      kao(:, 2, 3,13) = (/ &
        & 0.23692e+01_r8,0.20749e+01_r8,0.18925e+01_r8,0.18515e+01_r8,0.18400e+01_r8, &
        & 0.18683e+01_r8,0.18793e+01_r8,0.21211e+01_r8,0.24079e+01_r8 /)
      kao(:, 3, 3,13) = (/ &
        & 0.23722e+01_r8,0.20775e+01_r8,0.18924e+01_r8,0.18562e+01_r8,0.18451e+01_r8, &
        & 0.18704e+01_r8,0.18820e+01_r8,0.21249e+01_r8,0.24125e+01_r8 /)
      kao(:, 4, 3,13) = (/ &
        & 0.23635e+01_r8,0.20699e+01_r8,0.18842e+01_r8,0.18555e+01_r8,0.18524e+01_r8, &
        & 0.18695e+01_r8,0.18827e+01_r8,0.21252e+01_r8,0.24130e+01_r8 /)
      kao(:, 5, 3,13) = (/ &
        & 0.23480e+01_r8,0.20564e+01_r8,0.18701e+01_r8,0.18499e+01_r8,0.18587e+01_r8, &
        & 0.18689e+01_r8,0.18824e+01_r8,0.21250e+01_r8,0.24123e+01_r8 /)
      kao(:, 1, 4,13) = (/ &
        & 0.24939e+01_r8,0.21837e+01_r8,0.20232e+01_r8,0.19589e+01_r8,0.19737e+01_r8, &
        & 0.20251e+01_r8,0.20263e+01_r8,0.22145e+01_r8,0.25248e+01_r8 /)
      kao(:, 2, 4,13) = (/ &
        & 0.25110e+01_r8,0.21986e+01_r8,0.20314e+01_r8,0.19589e+01_r8,0.19697e+01_r8, &
        & 0.20307e+01_r8,0.20352e+01_r8,0.22253e+01_r8,0.25374e+01_r8 /)
      kao(:, 3, 4,13) = (/ &
        & 0.25161e+01_r8,0.22032e+01_r8,0.20346e+01_r8,0.19625e+01_r8,0.19727e+01_r8, &
        & 0.20334e+01_r8,0.20403e+01_r8,0.22301e+01_r8,0.25429e+01_r8 /)
      kao(:, 4, 4,13) = (/ &
        & 0.25095e+01_r8,0.21974e+01_r8,0.20283e+01_r8,0.19657e+01_r8,0.19780e+01_r8, &
        & 0.20313e+01_r8,0.20420e+01_r8,0.22330e+01_r8,0.25458e+01_r8 /)
      kao(:, 5, 4,13) = (/ &
        & 0.24957e+01_r8,0.21853e+01_r8,0.20162e+01_r8,0.19613e+01_r8,0.19825e+01_r8, &
        & 0.20289e+01_r8,0.20423e+01_r8,0.22370e+01_r8,0.25500e+01_r8 /)
      kao(:, 1, 5,13) = (/ &
        & 0.26637e+01_r8,0.23330e+01_r8,0.21864e+01_r8,0.20904e+01_r8,0.21013e+01_r8, &
        & 0.21699e+01_r8,0.21691e+01_r8,0.22859e+01_r8,0.26102e+01_r8 /)
      kao(:, 2, 5,13) = (/ &
        & 0.26795e+01_r8,0.23466e+01_r8,0.21930e+01_r8,0.20883e+01_r8,0.21007e+01_r8, &
        & 0.21775e+01_r8,0.21807e+01_r8,0.22957e+01_r8,0.26216e+01_r8 /)
      kao(:, 3, 5,13) = (/ &
        & 0.26872e+01_r8,0.23531e+01_r8,0.22001e+01_r8,0.20926e+01_r8,0.21029e+01_r8, &
        & 0.21797e+01_r8,0.21879e+01_r8,0.23020e+01_r8,0.26289e+01_r8 /)
      kao(:, 4, 5,13) = (/ &
        & 0.26803e+01_r8,0.23471e+01_r8,0.21948e+01_r8,0.20970e+01_r8,0.21069e+01_r8, &
        & 0.21770e+01_r8,0.21901e+01_r8,0.23087e+01_r8,0.26364e+01_r8 /)
      kao(:, 5, 5,13) = (/ &
        & 0.26667e+01_r8,0.23351e+01_r8,0.21832e+01_r8,0.20959e+01_r8,0.21091e+01_r8, &
        & 0.21729e+01_r8,0.21936e+01_r8,0.23158e+01_r8,0.26444e+01_r8 /)
      kao(:, 1, 6,13) = (/ &
        & 0.28246e+01_r8,0.24844e+01_r8,0.23554e+01_r8,0.22494e+01_r8,0.22325e+01_r8, &
        & 0.22877e+01_r8,0.22925e+01_r8,0.23319e+01_r8,0.26619e+01_r8 /)
      kao(:, 2, 6,13) = (/ &
        & 0.28376e+01_r8,0.24941e+01_r8,0.23589e+01_r8,0.22458e+01_r8,0.22369e+01_r8, &
        & 0.22959e+01_r8,0.23048e+01_r8,0.23408e+01_r8,0.26720e+01_r8 /)
      kao(:, 3, 6,13) = (/ &
        & 0.28468e+01_r8,0.25010e+01_r8,0.23646e+01_r8,0.22473e+01_r8,0.22379e+01_r8, &
        & 0.22992e+01_r8,0.23116e+01_r8,0.23486e+01_r8,0.26812e+01_r8 /)
      kao(:, 4, 6,13) = (/ &
        & 0.28432e+01_r8,0.24967e+01_r8,0.23643e+01_r8,0.22531e+01_r8,0.22409e+01_r8, &
        & 0.22981e+01_r8,0.23157e+01_r8,0.23572e+01_r8,0.26911e+01_r8 /)
      kao(:, 5, 6,13) = (/ &
        & 0.28266e+01_r8,0.24816e+01_r8,0.23521e+01_r8,0.22549e+01_r8,0.22433e+01_r8, &
        & 0.22953e+01_r8,0.23213e+01_r8,0.23655e+01_r8,0.27010e+01_r8 /)
      kao(:, 1, 7,13) = (/ &
        & 0.29507e+01_r8,0.26186e+01_r8,0.25154e+01_r8,0.24214e+01_r8,0.23698e+01_r8, &
        & 0.23809e+01_r8,0.23936e+01_r8,0.23723e+01_r8,0.26904e+01_r8 /)
      kao(:, 2, 7,13) = (/ &
        & 0.29579e+01_r8,0.26218e+01_r8,0.25131e+01_r8,0.24179e+01_r8,0.23791e+01_r8, &
        & 0.23895e+01_r8,0.24036e+01_r8,0.23830e+01_r8,0.27026e+01_r8 /)
      kao(:, 3, 7,13) = (/ &
        & 0.29645e+01_r8,0.26250e+01_r8,0.25156e+01_r8,0.24180e+01_r8,0.23828e+01_r8, &
        & 0.23929e+01_r8,0.24104e+01_r8,0.23923e+01_r8,0.27131e+01_r8 /)
      kao(:, 4, 7,13) = (/ &
        & 0.29630e+01_r8,0.26222e+01_r8,0.25142e+01_r8,0.24231e+01_r8,0.23851e+01_r8, &
        & 0.23923e+01_r8,0.24170e+01_r8,0.24017e+01_r8,0.27241e+01_r8 /)
      kao(:, 5, 7,13) = (/ &
        & 0.29476e+01_r8,0.26071e+01_r8,0.25053e+01_r8,0.24267e+01_r8,0.23855e+01_r8, &
        & 0.23922e+01_r8,0.24228e+01_r8,0.24116e+01_r8,0.27361e+01_r8 /)
      kao(:, 1, 8,13) = (/ &
        & 0.30283e+01_r8,0.27271e+01_r8,0.26499e+01_r8,0.25812e+01_r8,0.25068e+01_r8, &
        & 0.24674e+01_r8,0.24700e+01_r8,0.24088e+01_r8,0.26873e+01_r8 /)
      kao(:, 2, 8,13) = (/ &
        & 0.30302e+01_r8,0.27229e+01_r8,0.26429e+01_r8,0.25805e+01_r8,0.25199e+01_r8, &
        & 0.24758e+01_r8,0.24797e+01_r8,0.24223e+01_r8,0.27017e+01_r8 /)
      kao(:, 3, 8,13) = (/ &
        & 0.30313e+01_r8,0.27198e+01_r8,0.26386e+01_r8,0.25814e+01_r8,0.25257e+01_r8, &
        & 0.24788e+01_r8,0.24874e+01_r8,0.24335e+01_r8,0.27156e+01_r8 /)
      kao(:, 4, 8,13) = (/ &
        & 0.30296e+01_r8,0.27153e+01_r8,0.26358e+01_r8,0.25865e+01_r8,0.25285e+01_r8, &
        & 0.24798e+01_r8,0.24941e+01_r8,0.24451e+01_r8,0.27296e+01_r8 /)
      kao(:, 5, 8,13) = (/ &
        & 0.30139e+01_r8,0.26994e+01_r8,0.26290e+01_r8,0.25893e+01_r8,0.25296e+01_r8, &
        & 0.24809e+01_r8,0.25004e+01_r8,0.24568e+01_r8,0.27436e+01_r8 /)
      kao(:, 1, 9,13) = (/ &
        & 0.30493e+01_r8,0.27941e+01_r8,0.27550e+01_r8,0.27119e+01_r8,0.26405e+01_r8, &
        & 0.25561e+01_r8,0.25144e+01_r8,0.24302e+01_r8,0.26456e+01_r8 /)
      kao(:, 2, 9,13) = (/ &
        & 0.30457e+01_r8,0.27865e+01_r8,0.27445e+01_r8,0.27145e+01_r8,0.26540e+01_r8, &
        & 0.25649e+01_r8,0.25264e+01_r8,0.24468e+01_r8,0.26636e+01_r8 /)
      kao(:, 3, 9,13) = (/ &
        & 0.30433e+01_r8,0.27809e+01_r8,0.27367e+01_r8,0.27179e+01_r8,0.26606e+01_r8, &
        & 0.25683e+01_r8,0.25354e+01_r8,0.24613e+01_r8,0.26815e+01_r8 /)
      kao(:, 4, 9,13) = (/ &
        & 0.30389e+01_r8,0.27734e+01_r8,0.27309e+01_r8,0.27229e+01_r8,0.26627e+01_r8, &
        & 0.25715e+01_r8,0.25441e+01_r8,0.24765e+01_r8,0.27005e+01_r8 /)
      kao(:, 5, 9,13) = (/ &
        & 0.30246e+01_r8,0.27583e+01_r8,0.27239e+01_r8,0.27244e+01_r8,0.26642e+01_r8, &
        & 0.25740e+01_r8,0.25518e+01_r8,0.24921e+01_r8,0.27199e+01_r8 /)
      kao(:, 1,10,13) = (/ &
        & 0.30121e+01_r8,0.28154e+01_r8,0.28201e+01_r8,0.28057e+01_r8,0.27531e+01_r8, &
        & 0.26438e+01_r8,0.25360e+01_r8,0.24395e+01_r8,0.25814e+01_r8 /)
      kao(:, 2,10,13) = (/ &
        & 0.30058e+01_r8,0.28055e+01_r8,0.28091e+01_r8,0.28117e+01_r8,0.27659e+01_r8, &
        & 0.26536e+01_r8,0.25505e+01_r8,0.24578e+01_r8,0.26020e+01_r8 /)
      kao(:, 3,10,13) = (/ &
        & 0.29984e+01_r8,0.27957e+01_r8,0.28033e+01_r8,0.28172e+01_r8,0.27717e+01_r8, &
        & 0.26597e+01_r8,0.25631e+01_r8,0.24765e+01_r8,0.26239e+01_r8 /)
      kao(:, 4,10,13) = (/ &
        & 0.29909e+01_r8,0.27859e+01_r8,0.27980e+01_r8,0.28231e+01_r8,0.27737e+01_r8, &
        & 0.26641e+01_r8,0.25752e+01_r8,0.24953e+01_r8,0.26473e+01_r8 /)
      kao(:, 5,10,13) = (/ &
        & 0.29757e+01_r8,0.27703e+01_r8,0.27906e+01_r8,0.28248e+01_r8,0.27751e+01_r8, &
        & 0.26687e+01_r8,0.25862e+01_r8,0.25141e+01_r8,0.26704e+01_r8 /)
      kao(:, 1,11,13) = (/ &
        & 0.29105e+01_r8,0.27849e+01_r8,0.28418e+01_r8,0.28641e+01_r8,0.28368e+01_r8, &
        & 0.27205e+01_r8,0.25555e+01_r8,0.24401e+01_r8,0.25196e+01_r8 /)
      kao(:, 2,11,13) = (/ &
        & 0.29013e+01_r8,0.27742e+01_r8,0.28363e+01_r8,0.28719e+01_r8,0.28460e+01_r8, &
        & 0.27321e+01_r8,0.25730e+01_r8,0.24607e+01_r8,0.25412e+01_r8 /)
      kao(:, 3,11,13) = (/ &
        & 0.28911e+01_r8,0.27633e+01_r8,0.28321e+01_r8,0.28799e+01_r8,0.28506e+01_r8, &
        & 0.27417e+01_r8,0.25892e+01_r8,0.24813e+01_r8,0.25665e+01_r8 /)
      kao(:, 4,11,13) = (/ &
        & 0.28805e+01_r8,0.27495e+01_r8,0.28275e+01_r8,0.28852e+01_r8,0.28551e+01_r8, &
        & 0.27503e+01_r8,0.26048e+01_r8,0.25023e+01_r8,0.25905e+01_r8 /)
      kao(:, 5,11,13) = (/ &
        & 0.28607e+01_r8,0.27299e+01_r8,0.28179e+01_r8,0.28868e+01_r8,0.28597e+01_r8, &
        & 0.27578e+01_r8,0.26198e+01_r8,0.25207e+01_r8,0.26120e+01_r8 /)
      kao(:, 1,12,13) = (/ &
        & 0.27583e+01_r8,0.27145e+01_r8,0.28231e+01_r8,0.28871e+01_r8,0.28764e+01_r8, &
        & 0.27674e+01_r8,0.25743e+01_r8,0.24278e+01_r8,0.24570e+01_r8 /)
      kao(:, 2,12,13) = (/ &
        & 0.27477e+01_r8,0.27023e+01_r8,0.28226e+01_r8,0.28962e+01_r8,0.28884e+01_r8, &
        & 0.27832e+01_r8,0.25939e+01_r8,0.24483e+01_r8,0.24817e+01_r8 /)
      kao(:, 3,12,13) = (/ &
        & 0.27363e+01_r8,0.26890e+01_r8,0.28229e+01_r8,0.29041e+01_r8,0.28966e+01_r8, &
        & 0.27972e+01_r8,0.26117e+01_r8,0.24706e+01_r8,0.25053e+01_r8 /)
      kao(:, 4,12,13) = (/ &
        & 0.27215e+01_r8,0.26719e+01_r8,0.28199e+01_r8,0.29098e+01_r8,0.29044e+01_r8, &
        & 0.28097e+01_r8,0.26305e+01_r8,0.24926e+01_r8,0.25297e+01_r8 /)
      kao(:, 5,12,13) = (/ &
        & 0.27019e+01_r8,0.26521e+01_r8,0.28123e+01_r8,0.29106e+01_r8,0.29127e+01_r8, &
        & 0.28234e+01_r8,0.26485e+01_r8,0.25112e+01_r8,0.25512e+01_r8 /)
      kao(:, 1,13,13) = (/ &
        & 0.25703e+01_r8,0.26073e+01_r8,0.27736e+01_r8,0.28686e+01_r8,0.28762e+01_r8, &
        & 0.27819e+01_r8,0.25967e+01_r8,0.24069e+01_r8,0.23967e+01_r8 /)
      kao(:, 2,13,13) = (/ &
        & 0.25597e+01_r8,0.25968e+01_r8,0.27777e+01_r8,0.28810e+01_r8,0.28904e+01_r8, &
        & 0.28011e+01_r8,0.26158e+01_r8,0.24298e+01_r8,0.24224e+01_r8 /)
      kao(:, 3,13,13) = (/ &
        & 0.25492e+01_r8,0.25857e+01_r8,0.27800e+01_r8,0.28929e+01_r8,0.29040e+01_r8, &
        & 0.28202e+01_r8,0.26351e+01_r8,0.24527e+01_r8,0.24494e+01_r8 /)
      kao(:, 4,13,13) = (/ &
        & 0.25336e+01_r8,0.25705e+01_r8,0.27801e+01_r8,0.29008e+01_r8,0.29182e+01_r8, &
        & 0.28403e+01_r8,0.26542e+01_r8,0.24758e+01_r8,0.24745e+01_r8 /)
      kao(:, 5,13,13) = (/ &
        & 0.25174e+01_r8,0.25538e+01_r8,0.27760e+01_r8,0.29061e+01_r8,0.29321e+01_r8, &
        & 0.28592e+01_r8,0.26728e+01_r8,0.24954e+01_r8,0.24962e+01_r8 /)
      kao(:, 1, 1,14) = (/ &
        & 0.34915e+01_r8,0.30588e+01_r8,0.26262e+01_r8,0.23144e+01_r8,0.22122e+01_r8, &
        & 0.21892e+01_r8,0.25558e+01_r8,0.29818e+01_r8,0.32991e+01_r8 /)
      kao(:, 2, 1,14) = (/ &
        & 0.35009e+01_r8,0.30672e+01_r8,0.26335e+01_r8,0.23059e+01_r8,0.22071e+01_r8, &
        & 0.21796e+01_r8,0.25444e+01_r8,0.29683e+01_r8,0.32820e+01_r8 /)
      kao(:, 3, 1,14) = (/ &
        & 0.35192e+01_r8,0.30832e+01_r8,0.26472e+01_r8,0.23037e+01_r8,0.22014e+01_r8, &
        & 0.21706e+01_r8,0.25342e+01_r8,0.29565e+01_r8,0.32692e+01_r8 /)
      kao(:, 4, 1,14) = (/ &
        & 0.35462e+01_r8,0.31069e+01_r8,0.26676e+01_r8,0.23054e+01_r8,0.21967e+01_r8, &
        & 0.21619e+01_r8,0.25265e+01_r8,0.29475e+01_r8,0.32591e+01_r8 /)
      kao(:, 5, 1,14) = (/ &
        & 0.35714e+01_r8,0.31290e+01_r8,0.26866e+01_r8,0.23141e+01_r8,0.21952e+01_r8, &
        & 0.21552e+01_r8,0.25228e+01_r8,0.29432e+01_r8,0.32501e+01_r8 /)
      kao(:, 1, 2,14) = (/ &
        & 0.38742e+01_r8,0.33939e+01_r8,0.29135e+01_r8,0.26368e+01_r8,0.25318e+01_r8, &
        & 0.24566e+01_r8,0.27984e+01_r8,0.32648e+01_r8,0.36583e+01_r8 /)
      kao(:, 2, 2,14) = (/ &
        & 0.38780e+01_r8,0.33972e+01_r8,0.29165e+01_r8,0.26245e+01_r8,0.25266e+01_r8, &
        & 0.24447e+01_r8,0.27836e+01_r8,0.32475e+01_r8,0.36397e+01_r8 /)
      kao(:, 3, 2,14) = (/ &
        & 0.38887e+01_r8,0.34066e+01_r8,0.29246e+01_r8,0.26139e+01_r8,0.25181e+01_r8, &
        & 0.24355e+01_r8,0.27726e+01_r8,0.32346e+01_r8,0.36242e+01_r8 /)
      kao(:, 4, 2,14) = (/ &
        & 0.39063e+01_r8,0.34220e+01_r8,0.29378e+01_r8,0.26094e+01_r8,0.25085e+01_r8, &
        & 0.24291e+01_r8,0.27676e+01_r8,0.32288e+01_r8,0.36150e+01_r8 /)
      kao(:, 5, 2,14) = (/ &
        & 0.39241e+01_r8,0.34376e+01_r8,0.29511e+01_r8,0.26073e+01_r8,0.25021e+01_r8, &
        & 0.24243e+01_r8,0.27677e+01_r8,0.32289e+01_r8,0.36134e+01_r8 /)
      kao(:, 1, 3,14) = (/ &
        & 0.42487e+01_r8,0.37216e+01_r8,0.32039e+01_r8,0.29799e+01_r8,0.28758e+01_r8, &
        & 0.27551e+01_r8,0.30498e+01_r8,0.35581e+01_r8,0.40304e+01_r8 /)
      kao(:, 2, 3,14) = (/ &
        & 0.42439e+01_r8,0.37174e+01_r8,0.31977e+01_r8,0.29675e+01_r8,0.28698e+01_r8, &
        & 0.27440e+01_r8,0.30347e+01_r8,0.35405e+01_r8,0.40101e+01_r8 /)
      kao(:, 3, 3,14) = (/ &
        & 0.42511e+01_r8,0.37238e+01_r8,0.32007e+01_r8,0.29528e+01_r8,0.28598e+01_r8, &
        & 0.27364e+01_r8,0.30269e+01_r8,0.35313e+01_r8,0.39978e+01_r8 /)
      kao(:, 4, 3,14) = (/ &
        & 0.42624e+01_r8,0.37337e+01_r8,0.32078e+01_r8,0.29428e+01_r8,0.28469e+01_r8, &
        & 0.27311e+01_r8,0.30242e+01_r8,0.35281e+01_r8,0.39928e+01_r8 /)
      kao(:, 5, 3,14) = (/ &
        & 0.42720e+01_r8,0.37420e+01_r8,0.32138e+01_r8,0.29343e+01_r8,0.28324e+01_r8, &
        & 0.27276e+01_r8,0.30224e+01_r8,0.35261e+01_r8,0.39910e+01_r8 /)
      kao(:, 1, 4,14) = (/ &
        & 0.45954e+01_r8,0.40249e+01_r8,0.35022e+01_r8,0.33403e+01_r8,0.32328e+01_r8, &
        & 0.30833e+01_r8,0.33112e+01_r8,0.38621e+01_r8,0.43957e+01_r8 /)
      kao(:, 2, 4,14) = (/ &
        & 0.45847e+01_r8,0.40157e+01_r8,0.34904e+01_r8,0.33265e+01_r8,0.32256e+01_r8, &
        & 0.30748e+01_r8,0.32975e+01_r8,0.38466e+01_r8,0.43773e+01_r8 /)
      kao(:, 3, 4,14) = (/ &
        & 0.45864e+01_r8,0.40172e+01_r8,0.34822e+01_r8,0.33081e+01_r8,0.32132e+01_r8, &
        & 0.30693e+01_r8,0.32915e+01_r8,0.38399e+01_r8,0.43696e+01_r8 /)
      kao(:, 4, 4,14) = (/ &
        & 0.45919e+01_r8,0.40220e+01_r8,0.34808e+01_r8,0.32873e+01_r8,0.31989e+01_r8, &
        & 0.30656e+01_r8,0.32892e+01_r8,0.38374e+01_r8,0.43666e+01_r8 /)
      kao(:, 5, 4,14) = (/ &
        & 0.45961e+01_r8,0.40254e+01_r8,0.34809e+01_r8,0.32746e+01_r8,0.31817e+01_r8, &
        & 0.30639e+01_r8,0.32889e+01_r8,0.38370e+01_r8,0.43660e+01_r8 /)
      kao(:, 1, 5,14) = (/ &
        & 0.49114e+01_r8,0.43012e+01_r8,0.38001e+01_r8,0.37007e+01_r8,0.36023e+01_r8, &
        & 0.34476e+01_r8,0.35973e+01_r8,0.41814e+01_r8,0.47692e+01_r8 /)
      kao(:, 2, 5,14) = (/ &
        & 0.49023e+01_r8,0.42934e+01_r8,0.37862e+01_r8,0.36850e+01_r8,0.35912e+01_r8, &
        & 0.34412e+01_r8,0.35890e+01_r8,0.41727e+01_r8,0.47592e+01_r8 /)
      kao(:, 3, 5,14) = (/ &
        & 0.48929e+01_r8,0.42852e+01_r8,0.37666e+01_r8,0.36647e+01_r8,0.35739e+01_r8, &
        & 0.34368e+01_r8,0.35843e+01_r8,0.41678e+01_r8,0.47530e+01_r8 /)
      kao(:, 4, 5,14) = (/ &
        & 0.48957e+01_r8,0.42875e+01_r8,0.37577e+01_r8,0.36399e+01_r8,0.35570e+01_r8, &
        & 0.34352e+01_r8,0.35822e+01_r8,0.41658e+01_r8,0.47507e+01_r8 /)
      kao(:, 5, 5,14) = (/ &
        & 0.48955e+01_r8,0.42870e+01_r8,0.37502e+01_r8,0.36181e+01_r8,0.35379e+01_r8, &
        & 0.34333e+01_r8,0.35807e+01_r8,0.41639e+01_r8,0.47483e+01_r8 /)
      kao(:, 1, 6,14) = (/ &
        & 0.52336e+01_r8,0.45828e+01_r8,0.41059e+01_r8,0.40455e+01_r8,0.39709e+01_r8, &
        & 0.38438e+01_r8,0.39195e+01_r8,0.45101e+01_r8,0.51488e+01_r8 /)
      kao(:, 2, 6,14) = (/ &
        & 0.52264e+01_r8,0.45766e+01_r8,0.40903e+01_r8,0.40272e+01_r8,0.39556e+01_r8, &
        & 0.38368e+01_r8,0.39154e+01_r8,0.45074e+01_r8,0.51460e+01_r8 /)
      kao(:, 3, 6,14) = (/ &
        & 0.52116e+01_r8,0.45637e+01_r8,0.40682e+01_r8,0.40069e+01_r8,0.39387e+01_r8, &
        & 0.38311e+01_r8,0.39117e+01_r8,0.45034e+01_r8,0.51413e+01_r8 /)
      kao(:, 4, 6,14) = (/ &
        & 0.52061e+01_r8,0.45585e+01_r8,0.40484e+01_r8,0.39793e+01_r8,0.39195e+01_r8, &
        & 0.38275e+01_r8,0.39110e+01_r8,0.45018e+01_r8,0.51396e+01_r8 /)
      kao(:, 5, 6,14) = (/ &
        & 0.52033e+01_r8,0.45559e+01_r8,0.40356e+01_r8,0.39520e+01_r8,0.38983e+01_r8, &
        & 0.38238e+01_r8,0.39105e+01_r8,0.45008e+01_r8,0.51385e+01_r8 /)
      kao(:, 1, 7,14) = (/ &
        & 0.55789e+01_r8,0.48845e+01_r8,0.44392e+01_r8,0.43787e+01_r8,0.43341e+01_r8, &
        & 0.42496e+01_r8,0.42580e+01_r8,0.48177e+01_r8,0.55034e+01_r8 /)
      kao(:, 2, 7,14) = (/ &
        & 0.55750e+01_r8,0.48811e+01_r8,0.44216e+01_r8,0.43602e+01_r8,0.43147e+01_r8, &
        & 0.42460e+01_r8,0.42594e+01_r8,0.48202e+01_r8,0.55064e+01_r8 /)
      kao(:, 3, 7,14) = (/ &
        & 0.55641e+01_r8,0.48716e+01_r8,0.43996e+01_r8,0.43387e+01_r8,0.42975e+01_r8, &
        & 0.42414e+01_r8,0.42613e+01_r8,0.48234e+01_r8,0.55098e+01_r8 /)
      kao(:, 4, 7,14) = (/ &
        & 0.55497e+01_r8,0.48588e+01_r8,0.43740e+01_r8,0.43098e+01_r8,0.42767e+01_r8, &
        & 0.42365e+01_r8,0.42657e+01_r8,0.48283e+01_r8,0.55153e+01_r8 /)
      kao(:, 5, 7,14) = (/ &
        & 0.55426e+01_r8,0.48524e+01_r8,0.43530e+01_r8,0.42800e+01_r8,0.42577e+01_r8, &
        & 0.42309e+01_r8,0.42668e+01_r8,0.48295e+01_r8,0.55168e+01_r8 /)
      kao(:, 1, 8,14) = (/ &
        & 0.59399e+01_r8,0.51999e+01_r8,0.48042e+01_r8,0.47185e+01_r8,0.46865e+01_r8, &
        & 0.46496e+01_r8,0.46000e+01_r8,0.50897e+01_r8,0.58161e+01_r8 /)
      kao(:, 2, 8,14) = (/ &
        & 0.59397e+01_r8,0.51999e+01_r8,0.47874e+01_r8,0.46998e+01_r8,0.46665e+01_r8, &
        & 0.46493e+01_r8,0.46097e+01_r8,0.50997e+01_r8,0.58275e+01_r8 /)
      kao(:, 3, 8,14) = (/ &
        & 0.59349e+01_r8,0.51955e+01_r8,0.47656e+01_r8,0.46767e+01_r8,0.46485e+01_r8, &
        & 0.46473e+01_r8,0.46203e+01_r8,0.51120e+01_r8,0.58414e+01_r8 /)
      kao(:, 4, 8,14) = (/ &
        & 0.59186e+01_r8,0.51811e+01_r8,0.47381e+01_r8,0.46470e+01_r8,0.46283e+01_r8, &
        & 0.46432e+01_r8,0.46335e+01_r8,0.51262e+01_r8,0.58574e+01_r8 /)
      kao(:, 5, 8,14) = (/ &
        & 0.59097e+01_r8,0.51733e+01_r8,0.47110e+01_r8,0.46158e+01_r8,0.46095e+01_r8, &
        & 0.46379e+01_r8,0.46369e+01_r8,0.51321e+01_r8,0.58644e+01_r8 /)
      kao(:, 1, 9,14) = (/ &
        & 0.63127e+01_r8,0.55322e+01_r8,0.51834e+01_r8,0.50691e+01_r8,0.50247e+01_r8, &
        & 0.50209e+01_r8,0.49367e+01_r8,0.53236e+01_r8,0.60842e+01_r8 /)
      kao(:, 2, 9,14) = (/ &
        & 0.63183e+01_r8,0.55346e+01_r8,0.51727e+01_r8,0.50532e+01_r8,0.50080e+01_r8, &
        & 0.50274e+01_r8,0.49592e+01_r8,0.53436e+01_r8,0.61069e+01_r8 /)
      kao(:, 3, 9,14) = (/ &
        & 0.63124e+01_r8,0.55272e+01_r8,0.51546e+01_r8,0.50297e+01_r8,0.49909e+01_r8, &
        & 0.50310e+01_r8,0.49812e+01_r8,0.53668e+01_r8,0.61332e+01_r8 /)
      kao(:, 4, 9,14) = (/ &
        & 0.63001e+01_r8,0.55154e+01_r8,0.51286e+01_r8,0.50009e+01_r8,0.49750e+01_r8, &
        & 0.50299e+01_r8,0.49995e+01_r8,0.53888e+01_r8,0.61587e+01_r8 /)
      kao(:, 5, 9,14) = (/ &
        & 0.62858e+01_r8,0.55023e+01_r8,0.50977e+01_r8,0.49708e+01_r8,0.49573e+01_r8, &
        & 0.50270e+01_r8,0.50058e+01_r8,0.53988e+01_r8,0.61697e+01_r8 /)
      kao(:, 1,10,14) = (/ &
        & 0.66894e+01_r8,0.58832e+01_r8,0.55701e+01_r8,0.54237e+01_r8,0.53594e+01_r8, &
        & 0.53556e+01_r8,0.52686e+01_r8,0.55192e+01_r8,0.63037e+01_r8 /)
      kao(:, 2,10,14) = (/ &
        & 0.66981e+01_r8,0.58851e+01_r8,0.55643e+01_r8,0.54120e+01_r8,0.53500e+01_r8, &
        & 0.53705e+01_r8,0.53019e+01_r8,0.55500e+01_r8,0.63389e+01_r8 /)
      kao(:, 3,10,14) = (/ &
        & 0.66967e+01_r8,0.58795e+01_r8,0.55464e+01_r8,0.53921e+01_r8,0.53372e+01_r8, &
        & 0.53796e+01_r8,0.53288e+01_r8,0.55798e+01_r8,0.63734e+01_r8 /)
      kao(:, 4,10,14) = (/ &
        & 0.66854e+01_r8,0.58646e+01_r8,0.55228e+01_r8,0.53676e+01_r8,0.53254e+01_r8, &
        & 0.53837e+01_r8,0.53529e+01_r8,0.56104e+01_r8,0.64086e+01_r8 /)
      kao(:, 5,10,14) = (/ &
        & 0.66717e+01_r8,0.58486e+01_r8,0.54914e+01_r8,0.53392e+01_r8,0.53082e+01_r8, &
        & 0.53849e+01_r8,0.53627e+01_r8,0.56270e+01_r8,0.64281e+01_r8 /)
      kao(:, 1,11,14) = (/ &
        & 0.70715e+01_r8,0.62495e+01_r8,0.59582e+01_r8,0.57869e+01_r8,0.56930e+01_r8, &
        & 0.56655e+01_r8,0.56036e+01_r8,0.57057e+01_r8,0.64838e+01_r8 /)
      kao(:, 2,11,14) = (/ &
        & 0.70771e+01_r8,0.62459e+01_r8,0.59461e+01_r8,0.57734e+01_r8,0.56903e+01_r8, &
        & 0.56860e+01_r8,0.56380e+01_r8,0.57455e+01_r8,0.65310e+01_r8 /)
      kao(:, 3,11,14) = (/ &
        & 0.70723e+01_r8,0.62337e+01_r8,0.59291e+01_r8,0.57507e+01_r8,0.56859e+01_r8, &
        & 0.56988e+01_r8,0.56691e+01_r8,0.57882e+01_r8,0.65837e+01_r8 /)
      kao(:, 4,11,14) = (/ &
        & 0.70579e+01_r8,0.62141e+01_r8,0.59017e+01_r8,0.57243e+01_r8,0.56747e+01_r8, &
        & 0.57061e+01_r8,0.56917e+01_r8,0.58206e+01_r8,0.66248e+01_r8 /)
      kao(:, 5,11,14) = (/ &
        & 0.70436e+01_r8,0.61942e+01_r8,0.58711e+01_r8,0.56953e+01_r8,0.56563e+01_r8, &
        & 0.57095e+01_r8,0.57007e+01_r8,0.58439e+01_r8,0.66547e+01_r8 /)
      kao(:, 1,12,14) = (/ &
        & 0.73996e+01_r8,0.65875e+01_r8,0.63444e+01_r8,0.61468e+01_r8,0.60255e+01_r8, &
        & 0.59627e+01_r8,0.59009e+01_r8,0.58767e+01_r8,0.66113e+01_r8 /)
      kao(:, 2,12,14) = (/ &
        & 0.74059e+01_r8,0.65818e+01_r8,0.63297e+01_r8,0.61319e+01_r8,0.60289e+01_r8, &
        & 0.59857e+01_r8,0.59393e+01_r8,0.59291e+01_r8,0.66795e+01_r8 /)
      kao(:, 3,12,14) = (/ &
        & 0.73985e+01_r8,0.65639e+01_r8,0.63058e+01_r8,0.61104e+01_r8,0.60278e+01_r8, &
        & 0.60017e+01_r8,0.59765e+01_r8,0.59805e+01_r8,0.67466e+01_r8 /)
      kao(:, 4,12,14) = (/ &
        & 0.73888e+01_r8,0.65439e+01_r8,0.62733e+01_r8,0.60850e+01_r8,0.60189e+01_r8, &
        & 0.60123e+01_r8,0.59968e+01_r8,0.60157e+01_r8,0.67935e+01_r8 /)
      kao(:, 5,12,14) = (/ &
        & 0.73717e+01_r8,0.65185e+01_r8,0.62375e+01_r8,0.60536e+01_r8,0.59983e+01_r8, &
        & 0.60180e+01_r8,0.60067e+01_r8,0.60456e+01_r8,0.68365e+01_r8 /)
      kao(:, 1,13,14) = (/ &
        & 0.76469e+01_r8,0.68731e+01_r8,0.66871e+01_r8,0.64997e+01_r8,0.63502e+01_r8, &
        & 0.62466e+01_r8,0.61469e+01_r8,0.60253e+01_r8,0.66908e+01_r8 /)
      kao(:, 2,13,14) = (/ &
        & 0.76513e+01_r8,0.68603e+01_r8,0.66717e+01_r8,0.64853e+01_r8,0.63628e+01_r8, &
        & 0.62754e+01_r8,0.61942e+01_r8,0.60911e+01_r8,0.67781e+01_r8 /)
      kao(:, 3,13,14) = (/ &
        & 0.76480e+01_r8,0.68404e+01_r8,0.66430e+01_r8,0.64664e+01_r8,0.63629e+01_r8, &
        & 0.62938e+01_r8,0.62370e+01_r8,0.61432e+01_r8,0.68460e+01_r8 /)
      kao(:, 4,13,14) = (/ &
        & 0.76417e+01_r8,0.68180e+01_r8,0.66082e+01_r8,0.64389e+01_r8,0.63512e+01_r8, &
        & 0.63082e+01_r8,0.62633e+01_r8,0.61842e+01_r8,0.69071e+01_r8 /)
      kao(:, 5,13,14) = (/ &
        & 0.76283e+01_r8,0.67918e+01_r8,0.65683e+01_r8,0.64071e+01_r8,0.63329e+01_r8, &
        & 0.63131e+01_r8,0.62779e+01_r8,0.62184e+01_r8,0.69616e+01_r8 /)
      kao(:, 1, 1,15) = (/ &
        & 0.48056e+01_r8,0.42094e+01_r8,0.36132e+01_r8,0.30171e+01_r8,0.28404e+01_r8, &
        & 0.34490e+01_r8,0.41388e+01_r8,0.48284e+01_r8,0.52314e+01_r8 /)
      kao(:, 2, 1,15) = (/ &
        & 0.48171e+01_r8,0.42194e+01_r8,0.36219e+01_r8,0.30243e+01_r8,0.28141e+01_r8, &
        & 0.34073e+01_r8,0.40887e+01_r8,0.47701e+01_r8,0.51637e+01_r8 /)
      kao(:, 3, 1,15) = (/ &
        & 0.48231e+01_r8,0.42245e+01_r8,0.36259e+01_r8,0.30275e+01_r8,0.27871e+01_r8, &
        & 0.33709e+01_r8,0.40450e+01_r8,0.47190e+01_r8,0.51029e+01_r8 /)
      kao(:, 4, 1,15) = (/ &
        & 0.48223e+01_r8,0.42236e+01_r8,0.36250e+01_r8,0.30265e+01_r8,0.27616e+01_r8, &
        & 0.33346e+01_r8,0.40014e+01_r8,0.46682e+01_r8,0.50473e+01_r8 /)
      kao(:, 5, 1,15) = (/ &
        & 0.48164e+01_r8,0.42183e+01_r8,0.36202e+01_r8,0.30224e+01_r8,0.27378e+01_r8, &
        & 0.32980e+01_r8,0.39575e+01_r8,0.46170e+01_r8,0.49922e+01_r8 /)
      kao(:, 1, 2,15) = (/ &
        & 0.56696e+01_r8,0.49649e+01_r8,0.42601e+01_r8,0.35603e+01_r8,0.33660e+01_r8, &
        & 0.40230e+01_r8,0.48275e+01_r8,0.56320e+01_r8,0.62204e+01_r8 /)
      kao(:, 2, 2,15) = (/ &
        & 0.56853e+01_r8,0.49788e+01_r8,0.42721e+01_r8,0.35690e+01_r8,0.33370e+01_r8, &
        & 0.39815e+01_r8,0.47778e+01_r8,0.55740e+01_r8,0.61522e+01_r8 /)
      kao(:, 3, 2,15) = (/ &
        & 0.56912e+01_r8,0.49841e+01_r8,0.42769e+01_r8,0.35723e+01_r8,0.33088e+01_r8, &
        & 0.39404e+01_r8,0.47285e+01_r8,0.55164e+01_r8,0.60886e+01_r8 /)
      kao(:, 4, 2,15) = (/ &
        & 0.56900e+01_r8,0.49829e+01_r8,0.42759e+01_r8,0.35705e+01_r8,0.32819e+01_r8, &
        & 0.38975e+01_r8,0.46769e+01_r8,0.54563e+01_r8,0.60227e+01_r8 /)
      kao(:, 5, 2,15) = (/ &
        & 0.56828e+01_r8,0.49765e+01_r8,0.42703e+01_r8,0.35653e+01_r8,0.32552e+01_r8, &
        & 0.38520e+01_r8,0.46223e+01_r8,0.53926e+01_r8,0.59537e+01_r8 /)
      kao(:, 1, 3,15) = (/ &
        & 0.66640e+01_r8,0.58345e+01_r8,0.50050e+01_r8,0.41960e+01_r8,0.39837e+01_r8, &
        & 0.46765e+01_r8,0.56117e+01_r8,0.65468e+01_r8,0.73624e+01_r8 /)
      kao(:, 2, 3,15) = (/ &
        & 0.66851e+01_r8,0.58530e+01_r8,0.50209e+01_r8,0.42035e+01_r8,0.39538e+01_r8, &
        & 0.46274e+01_r8,0.55528e+01_r8,0.64781e+01_r8,0.72849e+01_r8 /)
      kao(:, 3, 3,15) = (/ &
        & 0.66916e+01_r8,0.58588e+01_r8,0.50261e+01_r8,0.42046e+01_r8,0.39240e+01_r8, &
        & 0.45763e+01_r8,0.54915e+01_r8,0.64066e+01_r8,0.72060e+01_r8 /)
      kao(:, 4, 3,15) = (/ &
        & 0.66884e+01_r8,0.58563e+01_r8,0.50241e+01_r8,0.42004e+01_r8,0.38957e+01_r8, &
        & 0.45225e+01_r8,0.54270e+01_r8,0.63313e+01_r8,0.71219e+01_r8 /)
      kao(:, 5, 3,15) = (/ &
        & 0.66766e+01_r8,0.58462e+01_r8,0.50163e+01_r8,0.41933e+01_r8,0.38675e+01_r8, &
        & 0.44702e+01_r8,0.53642e+01_r8,0.62581e+01_r8,0.70387e+01_r8 /)
      kao(:, 1, 4,15) = (/ &
        & 0.77848e+01_r8,0.68149e+01_r8,0.58451e+01_r8,0.49331e+01_r8,0.46977e+01_r8, &
        & 0.54033e+01_r8,0.64839e+01_r8,0.75644e+01_r8,0.85830e+01_r8 /)
      kao(:, 2, 4,15) = (/ &
        & 0.78108e+01_r8,0.68377e+01_r8,0.58646e+01_r8,0.49375e+01_r8,0.46695e+01_r8, &
        & 0.53453e+01_r8,0.64143e+01_r8,0.74831e+01_r8,0.84915e+01_r8 /)
      kao(:, 3, 4,15) = (/ &
        & 0.78236e+01_r8,0.68489e+01_r8,0.58743e+01_r8,0.49373e+01_r8,0.46417e+01_r8, &
        & 0.52821e+01_r8,0.63384e+01_r8,0.73947e+01_r8,0.83915e+01_r8 /)
      kao(:, 4, 4,15) = (/ &
        & 0.78238e+01_r8,0.68493e+01_r8,0.58748e+01_r8,0.49301e+01_r8,0.46103e+01_r8, &
        & 0.52166e+01_r8,0.62599e+01_r8,0.73031e+01_r8,0.82871e+01_r8 /)
      kao(:, 5, 4,15) = (/ &
        & 0.78090e+01_r8,0.68373e+01_r8,0.58658e+01_r8,0.49180e+01_r8,0.45786e+01_r8, &
        & 0.51516e+01_r8,0.61819e+01_r8,0.72121e+01_r8,0.81837e+01_r8 /)
      kao(:, 1, 5,15) = (/ &
        & 0.90367e+01_r8,0.79101e+01_r8,0.67835e+01_r8,0.57840e+01_r8,0.55090e+01_r8, &
        & 0.61816e+01_r8,0.74174e+01_r8,0.86536e+01_r8,0.98560e+01_r8 /)
      kao(:, 2, 5,15) = (/ &
        & 0.90658e+01_r8,0.79355e+01_r8,0.68052e+01_r8,0.57840e+01_r8,0.54825e+01_r8, &
        & 0.61122e+01_r8,0.73329e+01_r8,0.85548e+01_r8,0.97452e+01_r8 /)
      kao(:, 3, 5,15) = (/ &
        & 0.90837e+01_r8,0.79512e+01_r8,0.68188e+01_r8,0.57766e+01_r8,0.54581e+01_r8, &
        & 0.60426e+01_r8,0.72485e+01_r8,0.84564e+01_r8,0.96328e+01_r8 /)
      kao(:, 4, 5,15) = (/ &
        & 0.90830e+01_r8,0.79510e+01_r8,0.68192e+01_r8,0.57645e+01_r8,0.54297e+01_r8, &
        & 0.59729e+01_r8,0.71644e+01_r8,0.83583e+01_r8,0.95205e+01_r8 /)
      kao(:, 5, 5,15) = (/ &
        & 0.90677e+01_r8,0.79386e+01_r8,0.68094e+01_r8,0.57479e+01_r8,0.53962e+01_r8, &
        & 0.58998e+01_r8,0.70740e+01_r8,0.82528e+01_r8,0.94008e+01_r8 /)
      kao(:, 1, 6,15) = (/ &
        & 0.10412e+02_r8,0.91128e+01_r8,0.78140e+01_r8,0.67504e+01_r8,0.64389e+01_r8, &
        & 0.70217e+01_r8,0.83899e+01_r8,0.97882e+01_r8,0.11168e+02_r8 /)
      kao(:, 2, 6,15) = (/ &
        & 0.10449e+02_r8,0.91451e+01_r8,0.78417e+01_r8,0.67466e+01_r8,0.64110e+01_r8, &
        & 0.69507e+01_r8,0.82964e+01_r8,0.96789e+01_r8,0.11043e+02_r8 /)
      kao(:, 3, 6,15) = (/ &
        & 0.10469e+02_r8,0.91634e+01_r8,0.78574e+01_r8,0.67323e+01_r8,0.63834e+01_r8, &
        & 0.68804e+01_r8,0.82097e+01_r8,0.95778e+01_r8,0.10928e+02_r8 /)
      kao(:, 4, 6,15) = (/ &
        & 0.10466e+02_r8,0.91614e+01_r8,0.78568e+01_r8,0.67135e+01_r8,0.63530e+01_r8, &
        & 0.68083e+01_r8,0.81167e+01_r8,0.94694e+01_r8,0.10805e+02_r8 /)
      kao(:, 5, 6,15) = (/ &
        & 0.10450e+02_r8,0.91481e+01_r8,0.78461e+01_r8,0.66866e+01_r8,0.63182e+01_r8, &
        & 0.67317e+01_r8,0.80175e+01_r8,0.93536e+01_r8,0.10671e+02_r8 /)
      kao(:, 1, 7,15) = (/ &
        & 0.11882e+02_r8,0.10399e+02_r8,0.89166e+01_r8,0.78253e+01_r8,0.74792e+01_r8, &
        & 0.79512e+01_r8,0.94202e+01_r8,0.10990e+02_r8,0.12550e+02_r8 /)
      kao(:, 2, 7,15) = (/ &
        & 0.11932e+02_r8,0.10443e+02_r8,0.89541e+01_r8,0.78202e+01_r8,0.74549e+01_r8, &
        & 0.78754e+01_r8,0.93207e+01_r8,0.10874e+02_r8,0.12417e+02_r8 /)
      kao(:, 3, 7,15) = (/ &
        & 0.11956e+02_r8,0.10464e+02_r8,0.89727e+01_r8,0.78020e+01_r8,0.74258e+01_r8, &
        & 0.78051e+01_r8,0.92218e+01_r8,0.10758e+02_r8,0.12285e+02_r8 /)
      kao(:, 4, 7,15) = (/ &
        & 0.11956e+02_r8,0.10465e+02_r8,0.89740e+01_r8,0.77736e+01_r8,0.73912e+01_r8, &
        & 0.77319e+01_r8,0.91108e+01_r8,0.10629e+02_r8,0.12138e+02_r8 /)
      kao(:, 5, 7,15) = (/ &
        & 0.11934e+02_r8,0.10446e+02_r8,0.89587e+01_r8,0.77346e+01_r8,0.73464e+01_r8, &
        & 0.76503e+01_r8,0.90007e+01_r8,0.10501e+02_r8,0.11991e+02_r8 /)
      kao(:, 1, 8,15) = (/ &
        & 0.13440e+02_r8,0.11762e+02_r8,0.10084e+02_r8,0.90134e+01_r8,0.86298e+01_r8, &
        & 0.89787e+01_r8,0.10509e+02_r8,0.12260e+02_r8,0.14008e+02_r8 /)
      kao(:, 2, 8,15) = (/ &
        & 0.13496e+02_r8,0.11811e+02_r8,0.10127e+02_r8,0.90042e+01_r8,0.86075e+01_r8, &
        & 0.89016e+01_r8,0.10401e+02_r8,0.12134e+02_r8,0.13863e+02_r8 /)
      kao(:, 3, 8,15) = (/ &
        & 0.13522e+02_r8,0.11835e+02_r8,0.10148e+02_r8,0.89806e+01_r8,0.85777e+01_r8, &
        & 0.88306e+01_r8,0.10284e+02_r8,0.11998e+02_r8,0.13707e+02_r8 /)
      kao(:, 4, 8,15) = (/ &
        & 0.13526e+02_r8,0.11839e+02_r8,0.10151e+02_r8,0.89422e+01_r8,0.85378e+01_r8, &
        & 0.87510e+01_r8,0.10150e+02_r8,0.11842e+02_r8,0.13529e+02_r8 /)
      kao(:, 5, 8,15) = (/ &
        & 0.13498e+02_r8,0.11814e+02_r8,0.10131e+02_r8,0.88918e+01_r8,0.84819e+01_r8, &
        & 0.86621e+01_r8,0.10028e+02_r8,0.11700e+02_r8,0.13367e+02_r8 /)
      kao(:, 1, 9,15) = (/ &
        & 0.15050e+02_r8,0.13171e+02_r8,0.11325e+02_r8,0.10314e+02_r8,0.98844e+01_r8, &
        & 0.10113e+02_r8,0.11655e+02_r8,0.13598e+02_r8,0.15538e+02_r8 /)
      kao(:, 2, 9,15) = (/ &
        & 0.15110e+02_r8,0.13224e+02_r8,0.11358e+02_r8,0.10290e+02_r8,0.98636e+01_r8, &
        & 0.10034e+02_r8,0.11528e+02_r8,0.13449e+02_r8,0.15369e+02_r8 /)
      kao(:, 3, 9,15) = (/ &
        & 0.15142e+02_r8,0.13253e+02_r8,0.11372e+02_r8,0.10253e+02_r8,0.98329e+01_r8, &
        & 0.99565e+01_r8,0.11387e+02_r8,0.13285e+02_r8,0.15182e+02_r8 /)
      kao(:, 4, 9,15) = (/ &
        & 0.15140e+02_r8,0.13251e+02_r8,0.11368e+02_r8,0.10200e+02_r8,0.97822e+01_r8, &
        & 0.98656e+01_r8,0.11236e+02_r8,0.13109e+02_r8,0.14981e+02_r8 /)
      kao(:, 5, 9,15) = (/ &
        & 0.15112e+02_r8,0.13227e+02_r8,0.11344e+02_r8,0.10134e+02_r8,0.97132e+01_r8, &
        & 0.97634e+01_r8,0.11104e+02_r8,0.12955e+02_r8,0.14806e+02_r8 /)
      kao(:, 1,10,15) = (/ &
        & 0.16679e+02_r8,0.14596e+02_r8,0.12639e+02_r8,0.11713e+02_r8,0.11234e+02_r8, &
        & 0.11344e+02_r8,0.12833e+02_r8,0.14972e+02_r8,0.17110e+02_r8 /)
      kao(:, 2,10,15) = (/ &
        & 0.16740e+02_r8,0.14649e+02_r8,0.12658e+02_r8,0.11669e+02_r8,0.11203e+02_r8, &
        & 0.11257e+02_r8,0.12688e+02_r8,0.14803e+02_r8,0.16918e+02_r8 /)
      kao(:, 3,10,15) = (/ &
        & 0.16768e+02_r8,0.14675e+02_r8,0.12658e+02_r8,0.11609e+02_r8,0.11161e+02_r8, &
        & 0.11169e+02_r8,0.12530e+02_r8,0.14619e+02_r8,0.16708e+02_r8 /)
      kao(:, 4,10,15) = (/ &
        & 0.16761e+02_r8,0.14669e+02_r8,0.12632e+02_r8,0.11528e+02_r8,0.11096e+02_r8, &
        & 0.11064e+02_r8,0.12360e+02_r8,0.14420e+02_r8,0.16480e+02_r8 /)
      kao(:, 5,10,15) = (/ &
        & 0.16723e+02_r8,0.14636e+02_r8,0.12592e+02_r8,0.11437e+02_r8,0.11017e+02_r8, &
        & 0.10938e+02_r8,0.12210e+02_r8,0.14245e+02_r8,0.16279e+02_r8 /)
      kao(:, 1,11,15) = (/ &
        & 0.18294e+02_r8,0.16009e+02_r8,0.13989e+02_r8,0.13135e+02_r8,0.12643e+02_r8, &
        & 0.12628e+02_r8,0.13972e+02_r8,0.16290e+02_r8,0.18616e+02_r8 /)
      kao(:, 2,11,15) = (/ &
        & 0.18347e+02_r8,0.16056e+02_r8,0.13990e+02_r8,0.13069e+02_r8,0.12593e+02_r8, &
        & 0.12524e+02_r8,0.13808e+02_r8,0.16097e+02_r8,0.18396e+02_r8 /)
      kao(:, 3,11,15) = (/ &
        & 0.18360e+02_r8,0.16067e+02_r8,0.13961e+02_r8,0.12977e+02_r8,0.12519e+02_r8, &
        & 0.12404e+02_r8,0.13621e+02_r8,0.15875e+02_r8,0.18143e+02_r8 /)
      kao(:, 4,11,15) = (/ &
        & 0.18335e+02_r8,0.16046e+02_r8,0.13912e+02_r8,0.12870e+02_r8,0.12428e+02_r8, &
        & 0.12262e+02_r8,0.13438e+02_r8,0.15668e+02_r8,0.17906e+02_r8 /)
      kao(:, 5,11,15) = (/ &
        & 0.18275e+02_r8,0.15994e+02_r8,0.13835e+02_r8,0.12741e+02_r8,0.12318e+02_r8, &
        & 0.12107e+02_r8,0.13269e+02_r8,0.15473e+02_r8,0.17684e+02_r8 /)
      kao(:, 1,12,15) = (/ &
        & 0.19924e+02_r8,0.17435e+02_r8,0.15328e+02_r8,0.14570e+02_r8,0.14103e+02_r8, &
        & 0.13966e+02_r8,0.15137e+02_r8,0.17574e+02_r8,0.20085e+02_r8 /)
      kao(:, 2,12,15) = (/ &
        & 0.19952e+02_r8,0.17460e+02_r8,0.15303e+02_r8,0.14472e+02_r8,0.14016e+02_r8, &
        & 0.13836e+02_r8,0.14951e+02_r8,0.17356e+02_r8,0.19836e+02_r8 /)
      kao(:, 3,12,15) = (/ &
        & 0.19950e+02_r8,0.17459e+02_r8,0.15252e+02_r8,0.14354e+02_r8,0.13911e+02_r8, &
        & 0.13674e+02_r8,0.14736e+02_r8,0.17121e+02_r8,0.19567e+02_r8 /)
      kao(:, 4,12,15) = (/ &
        & 0.19898e+02_r8,0.17414e+02_r8,0.15172e+02_r8,0.14207e+02_r8,0.13782e+02_r8, &
        & 0.13496e+02_r8,0.14540e+02_r8,0.16905e+02_r8,0.19321e+02_r8 /)
      kao(:, 5,12,15) = (/ &
        & 0.19813e+02_r8,0.17339e+02_r8,0.15067e+02_r8,0.14045e+02_r8,0.13635e+02_r8, &
        & 0.13302e+02_r8,0.14349e+02_r8,0.16691e+02_r8,0.19076e+02_r8 /)
      kao(:, 1,13,15) = (/ &
        & 0.21582e+02_r8,0.18886e+02_r8,0.16708e+02_r8,0.15984e+02_r8,0.15578e+02_r8, &
        & 0.15338e+02_r8,0.16324e+02_r8,0.18812e+02_r8,0.21500e+02_r8 /)
      kao(:, 2,13,15) = (/ &
        & 0.21595e+02_r8,0.18898e+02_r8,0.16645e+02_r8,0.15860e+02_r8,0.15448e+02_r8, &
        & 0.15169e+02_r8,0.16117e+02_r8,0.18583e+02_r8,0.21237e+02_r8 /)
      kao(:, 3,13,15) = (/ &
        & 0.21561e+02_r8,0.18868e+02_r8,0.16562e+02_r8,0.15696e+02_r8,0.15303e+02_r8, &
        & 0.14968e+02_r8,0.15881e+02_r8,0.18352e+02_r8,0.20974e+02_r8 /)
      kao(:, 4,13,15) = (/ &
        & 0.21483e+02_r8,0.18800e+02_r8,0.16445e+02_r8,0.15517e+02_r8,0.15132e+02_r8, &
        & 0.14742e+02_r8,0.15661e+02_r8,0.18119e+02_r8,0.20709e+02_r8 /)
      kao(:, 5,13,15) = (/ &
        & 0.21359e+02_r8,0.18692e+02_r8,0.16307e+02_r8,0.15310e+02_r8,0.14932e+02_r8, &
        & 0.14513e+02_r8,0.15442e+02_r8,0.17892e+02_r8,0.20448e+02_r8 /)
      kao(:, 1, 1,16) = (/ &
        & 0.54900e+01_r8,0.48060e+01_r8,0.41232e+01_r8,0.34422e+01_r8,0.34870e+01_r8, &
        & 0.43588e+01_r8,0.52305e+01_r8,0.61020e+01_r8,0.65047e+01_r8 /)
      kao(:, 2, 1,16) = (/ &
        & 0.54959e+01_r8,0.48102e+01_r8,0.41246e+01_r8,0.34396e+01_r8,0.34389e+01_r8, &
        & 0.42986e+01_r8,0.51583e+01_r8,0.60178e+01_r8,0.64181e+01_r8 /)
      kao(:, 3, 1,16) = (/ &
        & 0.54964e+01_r8,0.48111e+01_r8,0.41257e+01_r8,0.34404e+01_r8,0.33906e+01_r8, &
        & 0.42383e+01_r8,0.50859e+01_r8,0.59334e+01_r8,0.63255e+01_r8 /)
      kao(:, 4, 1,16) = (/ &
        & 0.54872e+01_r8,0.48032e+01_r8,0.41193e+01_r8,0.34354e+01_r8,0.33485e+01_r8, &
        & 0.41856e+01_r8,0.50227e+01_r8,0.58596e+01_r8,0.62437e+01_r8 /)
      kao(:, 5, 1,16) = (/ &
        & 0.54677e+01_r8,0.47864e+01_r8,0.41051e+01_r8,0.34238e+01_r8,0.33099e+01_r8, &
        & 0.41373e+01_r8,0.49647e+01_r8,0.57920e+01_r8,0.61726e+01_r8 /)
      kao(:, 1, 2,16) = (/ &
        & 0.65993e+01_r8,0.57796e+01_r8,0.49604e+01_r8,0.41421e+01_r8,0.42011e+01_r8, &
        & 0.52514e+01_r8,0.63014e+01_r8,0.73516e+01_r8,0.80279e+01_r8 /)
      kao(:, 2, 2,16) = (/ &
        & 0.66032e+01_r8,0.57810e+01_r8,0.49597e+01_r8,0.41395e+01_r8,0.41430e+01_r8, &
        & 0.51787e+01_r8,0.62144e+01_r8,0.72499e+01_r8,0.79170e+01_r8 /)
      kao(:, 3, 2,16) = (/ &
        & 0.66114e+01_r8,0.57864e+01_r8,0.49618e+01_r8,0.41380e+01_r8,0.40849e+01_r8, &
        & 0.51061e+01_r8,0.61273e+01_r8,0.71483e+01_r8,0.78058e+01_r8 /)
      kao(:, 4, 2,16) = (/ &
        & 0.66055e+01_r8,0.57814e+01_r8,0.49573e+01_r8,0.41341e+01_r8,0.40341e+01_r8, &
        & 0.50426e+01_r8,0.60510e+01_r8,0.70593e+01_r8,0.77043e+01_r8 /)
      kao(:, 5, 2,16) = (/ &
        & 0.65867e+01_r8,0.57651e+01_r8,0.49435e+01_r8,0.41221e+01_r8,0.39863e+01_r8, &
        & 0.49829e+01_r8,0.59794e+01_r8,0.69758e+01_r8,0.76124e+01_r8 /)
      kao(:, 1, 3,16) = (/ &
        & 0.79380e+01_r8,0.69526e+01_r8,0.59676e+01_r8,0.49832e+01_r8,0.50788e+01_r8, &
        & 0.63485e+01_r8,0.76181e+01_r8,0.88875e+01_r8,0.99377e+01_r8 /)
      kao(:, 2, 3,16) = (/ &
        & 0.79519e+01_r8,0.69640e+01_r8,0.59765e+01_r8,0.49895e+01_r8,0.50033e+01_r8, &
        & 0.62541e+01_r8,0.75048e+01_r8,0.87554e+01_r8,0.97869e+01_r8 /)
      kao(:, 3, 3,16) = (/ &
        & 0.79564e+01_r8,0.69660e+01_r8,0.59762e+01_r8,0.49871e+01_r8,0.49341e+01_r8, &
        & 0.61676e+01_r8,0.74011e+01_r8,0.86343e+01_r8,0.96531e+01_r8 /)
      kao(:, 4, 3,16) = (/ &
        & 0.79604e+01_r8,0.69678e+01_r8,0.59753e+01_r8,0.49833e+01_r8,0.48716e+01_r8, &
        & 0.60895e+01_r8,0.73073e+01_r8,0.85250e+01_r8,0.95280e+01_r8 /)
      kao(:, 5, 3,16) = (/ &
        & 0.79454e+01_r8,0.69546e+01_r8,0.59641e+01_r8,0.49739e+01_r8,0.48117e+01_r8, &
        & 0.60146e+01_r8,0.72174e+01_r8,0.84201e+01_r8,0.94106e+01_r8 /)
      kao(:, 1, 4,16) = (/ &
        & 0.95482e+01_r8,0.83619e+01_r8,0.71758e+01_r8,0.59904e+01_r8,0.61617e+01_r8, &
        & 0.77021e+01_r8,0.92425e+01_r8,0.10783e+02_r8,0.12199e+02_r8 /)
      kao(:, 2, 4,16) = (/ &
        & 0.95751e+01_r8,0.83849e+01_r8,0.71952e+01_r8,0.60057e+01_r8,0.60507e+01_r8, &
        & 0.75634e+01_r8,0.90760e+01_r8,0.10588e+02_r8,0.11979e+02_r8 /)
      kao(:, 3, 4,16) = (/ &
        & 0.95851e+01_r8,0.83928e+01_r8,0.72008e+01_r8,0.60093e+01_r8,0.59519e+01_r8, &
        & 0.74398e+01_r8,0.89277e+01_r8,0.10415e+02_r8,0.11784e+02_r8 /)
      kao(:, 4, 4,16) = (/ &
        & 0.95899e+01_r8,0.83956e+01_r8,0.72016e+01_r8,0.60083e+01_r8,0.58751e+01_r8, &
        & 0.73438e+01_r8,0.88125e+01_r8,0.10281e+02_r8,0.11628e+02_r8 /)
      kao(:, 5, 4,16) = (/ &
        & 0.95802e+01_r8,0.83858e+01_r8,0.71919e+01_r8,0.59984e+01_r8,0.58004e+01_r8, &
        & 0.72505e+01_r8,0.87005e+01_r8,0.10150e+02_r8,0.11482e+02_r8 /)
      kao(:, 1, 5,16) = (/ &
        & 0.11467e+02_r8,0.10041e+02_r8,0.86153e+01_r8,0.71899e+01_r8,0.74662e+01_r8, &
        & 0.93327e+01_r8,0.11199e+02_r8,0.13065e+02_r8,0.14858e+02_r8 /)
      kao(:, 2, 5,16) = (/ &
        & 0.11518e+02_r8,0.10085e+02_r8,0.86526e+01_r8,0.72201e+01_r8,0.73208e+01_r8, &
        & 0.91509e+01_r8,0.10981e+02_r8,0.12811e+02_r8,0.14568e+02_r8 /)
      kao(:, 3, 5,16) = (/ &
        & 0.11535e+02_r8,0.10099e+02_r8,0.86636e+01_r8,0.72282e+01_r8,0.71844e+01_r8, &
        & 0.89805e+01_r8,0.10776e+02_r8,0.12572e+02_r8,0.14298e+02_r8 /)
      kao(:, 4, 5,16) = (/ &
        & 0.11542e+02_r8,0.10105e+02_r8,0.86677e+01_r8,0.72309e+01_r8,0.70636e+01_r8, &
        & 0.88295e+01_r8,0.10595e+02_r8,0.12361e+02_r8,0.14056e+02_r8 /)
      kao(:, 5, 5,16) = (/ &
        & 0.11528e+02_r8,0.10092e+02_r8,0.86561e+01_r8,0.72209e+01_r8,0.69634e+01_r8, &
        & 0.87042e+01_r8,0.10445e+02_r8,0.12185e+02_r8,0.13857e+02_r8 /)
      kao(:, 1, 6,16) = (/ &
        & 0.13743e+02_r8,0.12032e+02_r8,0.10321e+02_r8,0.86104e+01_r8,0.90301e+01_r8, &
        & 0.11288e+02_r8,0.13545e+02_r8,0.15802e+02_r8,0.18010e+02_r8 /)
      kao(:, 2, 6,16) = (/ &
        & 0.13809e+02_r8,0.12090e+02_r8,0.10370e+02_r8,0.86513e+01_r8,0.88422e+01_r8, &
        & 0.11053e+02_r8,0.13263e+02_r8,0.15473e+02_r8,0.17638e+02_r8 /)
      kao(:, 3, 6,16) = (/ &
        & 0.13850e+02_r8,0.12125e+02_r8,0.10400e+02_r8,0.86753e+01_r8,0.86607e+01_r8, &
        & 0.10826e+02_r8,0.12991e+02_r8,0.15156e+02_r8,0.17275e+02_r8 /)
      kao(:, 4, 6,16) = (/ &
        & 0.13866e+02_r8,0.12138e+02_r8,0.10411e+02_r8,0.86837e+01_r8,0.84930e+01_r8, &
        & 0.10616e+02_r8,0.12739e+02_r8,0.14862e+02_r8,0.16940e+02_r8 /)
      kao(:, 5, 6,16) = (/ &
        & 0.13850e+02_r8,0.12124e+02_r8,0.10399e+02_r8,0.86732e+01_r8,0.83442e+01_r8, &
        & 0.10430e+02_r8,0.12516e+02_r8,0.14602e+02_r8,0.16644e+02_r8 /)
      kao(:, 1, 7,16) = (/ &
        & 0.16450e+02_r8,0.14400e+02_r8,0.12350e+02_r8,0.10300e+02_r8,0.10874e+02_r8, &
        & 0.13593e+02_r8,0.16311e+02_r8,0.19030e+02_r8,0.21722e+02_r8 /)
      kao(:, 2, 7,16) = (/ &
        & 0.16525e+02_r8,0.14465e+02_r8,0.12405e+02_r8,0.10346e+02_r8,0.10632e+02_r8, &
        & 0.13290e+02_r8,0.15948e+02_r8,0.18606e+02_r8,0.21239e+02_r8 /)
      kao(:, 3, 7,16) = (/ &
        & 0.16563e+02_r8,0.14499e+02_r8,0.12434e+02_r8,0.10370e+02_r8,0.10395e+02_r8, &
        & 0.12994e+02_r8,0.15592e+02_r8,0.18191e+02_r8,0.20762e+02_r8 /)
      kao(:, 4, 7,16) = (/ &
        & 0.16590e+02_r8,0.14522e+02_r8,0.12454e+02_r8,0.10386e+02_r8,0.10172e+02_r8, &
        & 0.12715e+02_r8,0.15258e+02_r8,0.17801e+02_r8,0.20317e+02_r8 /)
      kao(:, 5, 7,16) = (/ &
        & 0.16576e+02_r8,0.14509e+02_r8,0.12443e+02_r8,0.10377e+02_r8,0.99688e+01_r8, &
        & 0.12461e+02_r8,0.14953e+02_r8,0.17445e+02_r8,0.19913e+02_r8 /)
      kao(:, 1, 8,16) = (/ &
        & 0.19629e+02_r8,0.17181e+02_r8,0.14733e+02_r8,0.12285e+02_r8,0.13022e+02_r8, &
        & 0.16277e+02_r8,0.19532e+02_r8,0.22787e+02_r8,0.26029e+02_r8 /)
      kao(:, 2, 8,16) = (/ &
        & 0.19728e+02_r8,0.17267e+02_r8,0.14807e+02_r8,0.12346e+02_r8,0.12711e+02_r8, &
        & 0.15888e+02_r8,0.19066e+02_r8,0.22243e+02_r8,0.25406e+02_r8 /)
      kao(:, 3, 8,16) = (/ &
        & 0.19768e+02_r8,0.17302e+02_r8,0.14837e+02_r8,0.12371e+02_r8,0.12399e+02_r8, &
        & 0.15499e+02_r8,0.18599e+02_r8,0.21698e+02_r8,0.24782e+02_r8 /)
      kao(:, 4, 8,16) = (/ &
        & 0.19773e+02_r8,0.17307e+02_r8,0.14840e+02_r8,0.12374e+02_r8,0.12111e+02_r8, &
        & 0.15139e+02_r8,0.18167e+02_r8,0.21194e+02_r8,0.24210e+02_r8 /)
      kao(:, 5, 8,16) = (/ &
        & 0.19744e+02_r8,0.17281e+02_r8,0.14818e+02_r8,0.12356e+02_r8,0.11840e+02_r8, &
        & 0.14800e+02_r8,0.17760e+02_r8,0.20720e+02_r8,0.23667e+02_r8 /)
      kao(:, 1, 9,16) = (/ &
        & 0.23312e+02_r8,0.20403e+02_r8,0.17494e+02_r8,0.14584e+02_r8,0.15488e+02_r8, &
        & 0.19360e+02_r8,0.23231e+02_r8,0.27103e+02_r8,0.30970e+02_r8 /)
      kao(:, 2, 9,16) = (/ &
        & 0.23439e+02_r8,0.20514e+02_r8,0.17588e+02_r8,0.14663e+02_r8,0.15085e+02_r8, &
        & 0.18856e+02_r8,0.22627e+02_r8,0.26397e+02_r8,0.30166e+02_r8 /)
      kao(:, 3, 9,16) = (/ &
        & 0.23492e+02_r8,0.20560e+02_r8,0.17628e+02_r8,0.14696e+02_r8,0.14687e+02_r8, &
        & 0.18356e+02_r8,0.22027e+02_r8,0.25697e+02_r8,0.29367e+02_r8 /)
      kao(:, 4, 9,16) = (/ &
        & 0.23479e+02_r8,0.20549e+02_r8,0.17619e+02_r8,0.14689e+02_r8,0.14321e+02_r8, &
        & 0.17895e+02_r8,0.21474e+02_r8,0.25052e+02_r8,0.28629e+02_r8 /)
      kao(:, 5, 9,16) = (/ &
        & 0.23411e+02_r8,0.20489e+02_r8,0.17567e+02_r8,0.14646e+02_r8,0.13982e+02_r8, &
        & 0.17451e+02_r8,0.20941e+02_r8,0.24431e+02_r8,0.27917e+02_r8 /)
      kao(:, 1,10,16) = (/ &
        & 0.27592e+02_r8,0.24147e+02_r8,0.20702e+02_r8,0.17264e+02_r8,0.18240e+02_r8, &
        & 0.22793e+02_r8,0.27352e+02_r8,0.31910e+02_r8,0.36473e+02_r8 /)
      kao(:, 2,10,16) = (/ &
        & 0.27703e+02_r8,0.24245e+02_r8,0.20786e+02_r8,0.17327e+02_r8,0.17749e+02_r8, &
        & 0.22147e+02_r8,0.26577e+02_r8,0.31006e+02_r8,0.35436e+02_r8 /)
      kao(:, 3,10,16) = (/ &
        & 0.27743e+02_r8,0.24279e+02_r8,0.20816e+02_r8,0.17352e+02_r8,0.17266e+02_r8, &
        & 0.21525e+02_r8,0.25830e+02_r8,0.30134e+02_r8,0.34441e+02_r8 /)
      kao(:, 4,10,16) = (/ &
        & 0.27709e+02_r8,0.24250e+02_r8,0.20790e+02_r8,0.17331e+02_r8,0.16811e+02_r8, &
        & 0.20946e+02_r8,0.25135e+02_r8,0.29324e+02_r8,0.33510e+02_r8 /)
      kao(:, 5,10,16) = (/ &
        & 0.27598e+02_r8,0.24153e+02_r8,0.20707e+02_r8,0.17262e+02_r8,0.16378e+02_r8, &
        & 0.20388e+02_r8,0.24466e+02_r8,0.28543e+02_r8,0.32622e+02_r8 /)
      kao(:, 1,11,16) = (/ &
        & 0.32570e+02_r8,0.28502e+02_r8,0.24434e+02_r8,0.20393e+02_r8,0.21083e+02_r8, &
        & 0.26245e+02_r8,0.31494e+02_r8,0.36742e+02_r8,0.41994e+02_r8 /)
      kao(:, 2,11,16) = (/ &
        & 0.32601e+02_r8,0.28529e+02_r8,0.24458e+02_r8,0.20386e+02_r8,0.20492e+02_r8, &
        & 0.25469e+02_r8,0.30563e+02_r8,0.35657e+02_r8,0.40747e+02_r8 /)
      kao(:, 3,11,16) = (/ &
        & 0.32535e+02_r8,0.28472e+02_r8,0.24408e+02_r8,0.20345e+02_r8,0.19916e+02_r8, &
        & 0.24733e+02_r8,0.29679e+02_r8,0.34625e+02_r8,0.39568e+02_r8 /)
      kao(:, 4,11,16) = (/ &
        & 0.32390e+02_r8,0.28345e+02_r8,0.24301e+02_r8,0.20256e+02_r8,0.19358e+02_r8, &
        & 0.24023e+02_r8,0.28827e+02_r8,0.33631e+02_r8,0.38435e+02_r8 /)
      kao(:, 5,11,16) = (/ &
        & 0.32175e+02_r8,0.28157e+02_r8,0.24140e+02_r8,0.20122e+02_r8,0.18819e+02_r8, &
        & 0.23330e+02_r8,0.27996e+02_r8,0.32661e+02_r8,0.37328e+02_r8 /)
      kao(:, 1,12,16) = (/ &
        & 0.38135e+02_r8,0.33371e+02_r8,0.28607e+02_r8,0.23891e+02_r8,0.24203e+02_r8, &
        & 0.29981e+02_r8,0.35977e+02_r8,0.41973e+02_r8,0.47971e+02_r8 /)
      kao(:, 2,12,16) = (/ &
        & 0.38033e+02_r8,0.33282e+02_r8,0.28531e+02_r8,0.23779e+02_r8,0.23491e+02_r8, &
        & 0.29038e+02_r8,0.34845e+02_r8,0.40652e+02_r8,0.46464e+02_r8 /)
      kao(:, 3,12,16) = (/ &
        & 0.37806e+02_r8,0.33084e+02_r8,0.28361e+02_r8,0.23639e+02_r8,0.22788e+02_r8, &
        & 0.28150e+02_r8,0.33780e+02_r8,0.39409e+02_r8,0.45036e+02_r8 /)
      kao(:, 4,12,16) = (/ &
        & 0.37497e+02_r8,0.32813e+02_r8,0.28129e+02_r8,0.23446e+02_r8,0.22100e+02_r8, &
        & 0.27270e+02_r8,0.32724e+02_r8,0.38179e+02_r8,0.43632e+02_r8 /)
      kao(:, 5,12,16) = (/ &
        & 0.37099e+02_r8,0.32465e+02_r8,0.27831e+02_r8,0.23198e+02_r8,0.21440e+02_r8, &
        & 0.26398e+02_r8,0.31678e+02_r8,0.36957e+02_r8,0.42237e+02_r8 /)
      kao(:, 1,13,16) = (/ &
        & 0.44217e+02_r8,0.38692e+02_r8,0.33167e+02_r8,0.27730e+02_r8,0.27605e+02_r8, &
        & 0.33969e+02_r8,0.40763e+02_r8,0.47556e+02_r8,0.54352e+02_r8 /)
      kao(:, 2,13,16) = (/ &
        & 0.43915e+02_r8,0.38428e+02_r8,0.32941e+02_r8,0.27455e+02_r8,0.26738e+02_r8, &
        & 0.32787e+02_r8,0.39345e+02_r8,0.45901e+02_r8,0.52455e+02_r8 /)
      kao(:, 3,13,16) = (/ &
        & 0.43489e+02_r8,0.38055e+02_r8,0.32622e+02_r8,0.27188e+02_r8,0.25861e+02_r8, &
        & 0.31686e+02_r8,0.38022e+02_r8,0.44359e+02_r8,0.50700e+02_r8 /)
      kao(:, 4,13,16) = (/ &
        & 0.42951e+02_r8,0.37585e+02_r8,0.32219e+02_r8,0.26853e+02_r8,0.25006e+02_r8, &
        & 0.30590e+02_r8,0.36708e+02_r8,0.42826e+02_r8,0.48946e+02_r8 /)
      kao(:, 5,13,16) = (/ &
        & 0.42298e+02_r8,0.37013e+02_r8,0.31729e+02_r8,0.26445e+02_r8,0.24180e+02_r8, &
        & 0.29511e+02_r8,0.35413e+02_r8,0.41314e+02_r8,0.47218e+02_r8 /)
  
!     -----------------------------------------------------------------
!     The array KBO contains absorption coefs at the 16 chosen g-values 
!     for a range of pressure levels < ~100mb and temperatures. The first 
!     index in the array, JT, which runs from 1 to 5, corresponds to 
!     different temperatures.  More specifically, JT = 3 means that the 
!     data are for the reference temperature TREF for this pressure 
!     level, JT = 2 refers to the temperature TREF-15, JT = 1 is for
!     TREF-30, JT = 4 is for TREF+15, and JT = 5 is for TREF+30.  
!     The second index, JP, runs from 13 to 59 and refers to the JPth
!     reference pressure level (see taumol.f for the value of these
!     pressure levels in mb).  The third index, IG, goes from 1 to 16,
!     and tells us which g-interval the absorption coefficients are for.
!     -----------------------------------------------------------------

      kbo(:, 1,13, 1) = (/ &
        & 0.40633e-08_r8,0.64718e-06_r8,0.79567e-06_r8,0.81264e-06_r8,0.25080e-07_r8 /)
      kbo(:, 2,13, 1) = (/ &
        & 0.37596e-08_r8,0.70429e-06_r8,0.90855e-06_r8,0.96432e-06_r8,0.28292e-07_r8 /)
      kbo(:, 3,13, 1) = (/ &
        & 0.34982e-08_r8,0.76370e-06_r8,0.10316e-05_r8,0.11472e-05_r8,0.31265e-07_r8 /)
      kbo(:, 4,13, 1) = (/ &
        & 0.32707e-08_r8,0.82834e-06_r8,0.11577e-05_r8,0.13387e-05_r8,0.34928e-07_r8 /)
      kbo(:, 5,13, 1) = (/ &
        & 0.30710e-08_r8,0.90252e-06_r8,0.12962e-05_r8,0.15206e-05_r8,0.38859e-07_r8 /)
      kbo(:, 1,14, 1) = (/ &
        & 0.33026e-08_r8,0.53592e-06_r8,0.66171e-06_r8,0.67633e-06_r8,0.20767e-07_r8 /)
      kbo(:, 2,14, 1) = (/ &
        & 0.30574e-08_r8,0.57959e-06_r8,0.75386e-06_r8,0.80395e-06_r8,0.23334e-07_r8 /)
      kbo(:, 3,14, 1) = (/ &
        & 0.28461e-08_r8,0.62897e-06_r8,0.85486e-06_r8,0.95745e-06_r8,0.25841e-07_r8 /)
      kbo(:, 4,14, 1) = (/ &
        & 0.26621e-08_r8,0.68352e-06_r8,0.96132e-06_r8,0.11148e-05_r8,0.28862e-07_r8 /)
      kbo(:, 5,14, 1) = (/ &
        & 0.25005e-08_r8,0.74517e-06_r8,0.10739e-05_r8,0.12632e-05_r8,0.32093e-07_r8 /)
      kbo(:, 1,15, 1) = (/ &
        & 0.26821e-08_r8,0.44081e-06_r8,0.55093e-06_r8,0.56465e-06_r8,0.17186e-07_r8 /)
      kbo(:, 2,15, 1) = (/ &
        & 0.24845e-08_r8,0.47773e-06_r8,0.62636e-06_r8,0.67180e-06_r8,0.19234e-07_r8 /)
      kbo(:, 3,15, 1) = (/ &
        & 0.23140e-08_r8,0.51811e-06_r8,0.70791e-06_r8,0.79658e-06_r8,0.21348e-07_r8 /)
      kbo(:, 4,15, 1) = (/ &
        & 0.21654e-08_r8,0.56416e-06_r8,0.79893e-06_r8,0.92873e-06_r8,0.23832e-07_r8 /)
      kbo(:, 5,15, 1) = (/ &
        & 0.20347e-08_r8,0.61535e-06_r8,0.88985e-06_r8,0.10499e-05_r8,0.26485e-07_r8 /)
      kbo(:, 1,16, 1) = (/ &
        & 0.21775e-08_r8,0.36254e-06_r8,0.45870e-06_r8,0.47125e-06_r8,0.14211e-07_r8 /)
      kbo(:, 2,16, 1) = (/ &
        & 0.20183e-08_r8,0.39376e-06_r8,0.52053e-06_r8,0.56163e-06_r8,0.15869e-07_r8 /)
      kbo(:, 3,16, 1) = (/ &
        & 0.18808e-08_r8,0.42687e-06_r8,0.58699e-06_r8,0.66386e-06_r8,0.17627e-07_r8 /)
      kbo(:, 4,16, 1) = (/ &
        & 0.17608e-08_r8,0.46559e-06_r8,0.66388e-06_r8,0.77063e-06_r8,0.19664e-07_r8 /)
      kbo(:, 5,16, 1) = (/ &
        & 0.16552e-08_r8,0.50747e-06_r8,0.73699e-06_r8,0.87249e-06_r8,0.21844e-07_r8 /)
      kbo(:, 1,17, 1) = (/ &
        & 0.17682e-08_r8,0.29836e-06_r8,0.38104e-06_r8,0.39314e-06_r8,0.11735e-07_r8 /)
      kbo(:, 2,17, 1) = (/ &
        & 0.16399e-08_r8,0.32493e-06_r8,0.43215e-06_r8,0.46897e-06_r8,0.13077e-07_r8 /)
      kbo(:, 3,17, 1) = (/ &
        & 0.15290e-08_r8,0.35203e-06_r8,0.48665e-06_r8,0.55328e-06_r8,0.14535e-07_r8 /)
      kbo(:, 4,17, 1) = (/ &
        & 0.14321e-08_r8,0.38383e-06_r8,0.55033e-06_r8,0.63844e-06_r8,0.16208e-07_r8 /)
      kbo(:, 5,17, 1) = (/ &
        & 0.13468e-08_r8,0.41822e-06_r8,0.60950e-06_r8,0.72376e-06_r8,0.17995e-07_r8 /)
      kbo(:, 1,18, 1) = (/ &
        & 0.14362e-08_r8,0.24560e-06_r8,0.31667e-06_r8,0.32797e-06_r8,0.96831e-08_r8 /)
      kbo(:, 2,18, 1) = (/ &
        & 0.13327e-08_r8,0.26784e-06_r8,0.35872e-06_r8,0.39134e-06_r8,0.10773e-07_r8 /)
      kbo(:, 3,18, 1) = (/ &
        & 0.12432e-08_r8,0.29008e-06_r8,0.40334e-06_r8,0.46026e-06_r8,0.11980e-07_r8 /)
      kbo(:, 4,18, 1) = (/ &
        & 0.11650e-08_r8,0.31637e-06_r8,0.45583e-06_r8,0.52880e-06_r8,0.13350e-07_r8 /)
      kbo(:, 5,18, 1) = (/ &
        & 0.10960e-08_r8,0.34503e-06_r8,0.50363e-06_r8,0.59967e-06_r8,0.14815e-07_r8 /)
      kbo(:, 1,19, 1) = (/ &
        & 0.11667e-08_r8,0.20231e-06_r8,0.26313e-06_r8,0.27359e-06_r8,0.79934e-08_r8 /)
      kbo(:, 2,19, 1) = (/ &
        & 0.10833e-08_r8,0.22085e-06_r8,0.29760e-06_r8,0.32620e-06_r8,0.88807e-08_r8 /)
      kbo(:, 3,19, 1) = (/ &
        & 0.10110e-08_r8,0.23912e-06_r8,0.33423e-06_r8,0.38271e-06_r8,0.98771e-08_r8 /)
      kbo(:, 4,19, 1) = (/ &
        & 0.94778e-09_r8,0.26073e-06_r8,0.37685e-06_r8,0.43791e-06_r8,0.11002e-07_r8 /)
      kbo(:, 5,19, 1) = (/ &
        & 0.89198e-09_r8,0.28425e-06_r8,0.41589e-06_r8,0.49682e-06_r8,0.12204e-07_r8 /)
      kbo(:, 1,20, 1) = (/ &
        & 0.94668e-09_r8,0.16735e-06_r8,0.21822e-06_r8,0.22914e-06_r8,0.66237e-08_r8 /)
      kbo(:, 2,20, 1) = (/ &
        & 0.87956e-09_r8,0.18255e-06_r8,0.24770e-06_r8,0.27290e-06_r8,0.73470e-08_r8 /)
      kbo(:, 3,20, 1) = (/ &
        & 0.82132e-09_r8,0.19776e-06_r8,0.27786e-06_r8,0.31913e-06_r8,0.81732e-08_r8 /)
      kbo(:, 4,20, 1) = (/ &
        & 0.77032e-09_r8,0.21557e-06_r8,0.31197e-06_r8,0.36380e-06_r8,0.91019e-08_r8 /)
      kbo(:, 5,20, 1) = (/ &
        & 0.72528e-09_r8,0.23458e-06_r8,0.34449e-06_r8,0.41257e-06_r8,0.10084e-07_r8 /)
      kbo(:, 1,21, 1) = (/ &
        & 0.76809e-09_r8,0.13858e-06_r8,0.18138e-06_r8,0.19188e-06_r8,0.54929e-08_r8 /)
      kbo(:, 2,21, 1) = (/ &
        & 0.71408e-09_r8,0.15088e-06_r8,0.20614e-06_r8,0.22835e-06_r8,0.60825e-08_r8 /)
      kbo(:, 3,21, 1) = (/ &
        & 0.66717e-09_r8,0.16366e-06_r8,0.23111e-06_r8,0.26622e-06_r8,0.67680e-08_r8 /)
      kbo(:, 4,21, 1) = (/ &
        & 0.62605e-09_r8,0.17816e-06_r8,0.25834e-06_r8,0.30242e-06_r8,0.75344e-08_r8 /)
      kbo(:, 5,21, 1) = (/ &
        & 0.58970e-09_r8,0.19374e-06_r8,0.28542e-06_r8,0.34222e-06_r8,0.83394e-08_r8 /)
      kbo(:, 1,22, 1) = (/ &
        & 0.62013e-09_r8,0.11547e-06_r8,0.15212e-06_r8,0.16227e-06_r8,0.45926e-08_r8 /)
      kbo(:, 2,22, 1) = (/ &
        & 0.57709e-09_r8,0.12552e-06_r8,0.17211e-06_r8,0.19265e-06_r8,0.50728e-08_r8 /)
      kbo(:, 3,22, 1) = (/ &
        & 0.53964e-09_r8,0.13619e-06_r8,0.19363e-06_r8,0.22402e-06_r8,0.56454e-08_r8 /)
      kbo(:, 4,22, 1) = (/ &
        & 0.50675e-09_r8,0.14805e-06_r8,0.21557e-06_r8,0.25320e-06_r8,0.62805e-08_r8 /)
      kbo(:, 5,22, 1) = (/ &
        & 0.47764e-09_r8,0.16097e-06_r8,0.23799e-06_r8,0.28574e-06_r8,0.69414e-08_r8 /)
      kbo(:, 1,23, 1) = (/ &
        & 0.50055e-09_r8,0.96165e-07_r8,0.12776e-06_r8,0.13752e-06_r8,0.37933e-08_r8 /)
      kbo(:, 2,23, 1) = (/ &
        & 0.46627e-09_r8,0.10421e-06_r8,0.14387e-06_r8,0.16226e-06_r8,0.42154e-08_r8 /)
      kbo(:, 3,23, 1) = (/ &
        & 0.43638e-09_r8,0.11320e-06_r8,0.16240e-06_r8,0.18806e-06_r8,0.46761e-08_r8 /)
      kbo(:, 4,23, 1) = (/ &
        & 0.41009e-09_r8,0.12312e-06_r8,0.18002e-06_r8,0.21214e-06_r8,0.51724e-08_r8 /)
      kbo(:, 5,23, 1) = (/ &
        & 0.38679e-09_r8,0.13380e-06_r8,0.19835e-06_r8,0.23836e-06_r8,0.56863e-08_r8 /)
      kbo(:, 1,24, 1) = (/ &
        & 0.40384e-09_r8,0.80174e-07_r8,0.10742e-06_r8,0.11665e-06_r8,0.31435e-08_r8 /)
      kbo(:, 2,24, 1) = (/ &
        & 0.37656e-09_r8,0.86611e-07_r8,0.12062e-06_r8,0.13694e-06_r8,0.34746e-08_r8 /)
      kbo(:, 3,24, 1) = (/ &
        & 0.35273e-09_r8,0.94203e-07_r8,0.13610e-06_r8,0.15729e-06_r8,0.38586e-08_r8 /)
      kbo(:, 4,24, 1) = (/ &
        & 0.33174e-09_r8,0.10246e-06_r8,0.15035e-06_r8,0.17775e-06_r8,0.42707e-08_r8 /)
      kbo(:, 5,24, 1) = (/ &
        & 0.31310e-09_r8,0.11122e-06_r8,0.16543e-06_r8,0.19917e-06_r8,0.47020e-08_r8 /)
      kbo(:, 1,25, 1) = (/ &
        & 0.32562e-09_r8,0.66785e-07_r8,0.90447e-07_r8,0.99059e-07_r8,0.26134e-08_r8 /)
      kbo(:, 2,25, 1) = (/ &
        & 0.30393e-09_r8,0.72133e-07_r8,0.10139e-06_r8,0.11571e-06_r8,0.28872e-08_r8 /)
      kbo(:, 3,25, 1) = (/ &
        & 0.28495e-09_r8,0.78448e-07_r8,0.11385e-06_r8,0.13178e-06_r8,0.32061e-08_r8 /)
      kbo(:, 4,25, 1) = (/ &
        & 0.26821e-09_r8,0.85339e-07_r8,0.12563e-06_r8,0.14914e-06_r8,0.35489e-08_r8 /)
      kbo(:, 5,25, 1) = (/ &
        & 0.25332e-09_r8,0.92445e-07_r8,0.13814e-06_r8,0.16674e-06_r8,0.39060e-08_r8 /)
      kbo(:, 1,26, 1) = (/ &
        & 0.26224e-09_r8,0.55680e-07_r8,0.76369e-07_r8,0.84400e-07_r8,0.21759e-08_r8 /)
      kbo(:, 2,26, 1) = (/ &
        & 0.24504e-09_r8,0.60204e-07_r8,0.85423e-07_r8,0.97885e-07_r8,0.24118e-08_r8 /)
      kbo(:, 3,26, 1) = (/ &
        & 0.22996e-09_r8,0.65477e-07_r8,0.95321e-07_r8,0.11093e-06_r8,0.26774e-08_r8 /)
      kbo(:, 4,26, 1) = (/ &
        & 0.21663e-09_r8,0.71188e-07_r8,0.10529e-06_r8,0.12544e-06_r8,0.29615e-08_r8 /)
      kbo(:, 5,26, 1) = (/ &
        & 0.20475e-09_r8,0.76940e-07_r8,0.11556e-06_r8,0.13977e-06_r8,0.32569e-08_r8 /)
      kbo(:, 1,27, 1) = (/ &
        & 0.21120e-09_r8,0.46382e-07_r8,0.63894e-07_r8,0.71379e-07_r8,0.18178e-08_r8 /)
      kbo(:, 2,27, 1) = (/ &
        & 0.19756e-09_r8,0.50278e-07_r8,0.72033e-07_r8,0.82909e-07_r8,0.20181e-08_r8 /)
      kbo(:, 3,27, 1) = (/ &
        & 0.18557e-09_r8,0.54670e-07_r8,0.79953e-07_r8,0.93505e-07_r8,0.22396e-08_r8 /)
      kbo(:, 4,27, 1) = (/ &
        & 0.17496e-09_r8,0.59408e-07_r8,0.88179e-07_r8,0.10553e-06_r8,0.24737e-08_r8 /)
      kbo(:, 5,27, 1) = (/ &
        & 0.16549e-09_r8,0.64025e-07_r8,0.96696e-07_r8,0.11704e-06_r8,0.27092e-08_r8 /)
      kbo(:, 1,28, 1) = (/ &
        & 0.17010e-09_r8,0.38631e-07_r8,0.53773e-07_r8,0.60579e-07_r8,0.15220e-08_r8 /)
      kbo(:, 2,28, 1) = (/ &
        & 0.15928e-09_r8,0.42001e-07_r8,0.60660e-07_r8,0.69727e-07_r8,0.16901e-08_r8 /)
      kbo(:, 3,28, 1) = (/ &
        & 0.14976e-09_r8,0.45661e-07_r8,0.67065e-07_r8,0.78845e-07_r8,0.18696e-08_r8 /)
      kbo(:, 4,28, 1) = (/ &
        & 0.14131e-09_r8,0.49571e-07_r8,0.73809e-07_r8,0.88481e-07_r8,0.20611e-08_r8 /)
      kbo(:, 5,28, 1) = (/ &
        & 0.13376e-09_r8,0.53304e-07_r8,0.80910e-07_r8,0.98017e-07_r8,0.22565e-08_r8 /)
      kbo(:, 1,29, 1) = (/ &
        & 0.13696e-09_r8,0.32270e-07_r8,0.45392e-07_r8,0.51438e-07_r8,0.12721e-08_r8 /)
      kbo(:, 2,29, 1) = (/ &
        & 0.12839e-09_r8,0.35079e-07_r8,0.50946e-07_r8,0.58726e-07_r8,0.14118e-08_r8 /)
      kbo(:, 3,29, 1) = (/ &
        & 0.12082e-09_r8,0.38150e-07_r8,0.56258e-07_r8,0.66493e-07_r8,0.15628e-08_r8 /)
      kbo(:, 4,29, 1) = (/ &
        & 0.11410e-09_r8,0.41324e-07_r8,0.61843e-07_r8,0.74387e-07_r8,0.17205e-08_r8 /)
      kbo(:, 5,29, 1) = (/ &
        & 0.10808e-09_r8,0.44387e-07_r8,0.67739e-07_r8,0.82216e-07_r8,0.18745e-08_r8 /)
      kbo(:, 1,30, 1) = (/ &
        & 0.11029e-09_r8,0.26970e-07_r8,0.38330e-07_r8,0.43698e-07_r8,0.10655e-08_r8 /)
      kbo(:, 2,30, 1) = (/ &
        & 0.10349e-09_r8,0.29319e-07_r8,0.42739e-07_r8,0.49552e-07_r8,0.11823e-08_r8 /)
      kbo(:, 3,30, 1) = (/ &
        & 0.97483e-10_r8,0.31869e-07_r8,0.47210e-07_r8,0.56057e-07_r8,0.13038e-08_r8 /)
      kbo(:, 4,30, 1) = (/ &
        & 0.92133e-10_r8,0.34436e-07_r8,0.51812e-07_r8,0.62485e-07_r8,0.14285e-08_r8 /)
      kbo(:, 5,30, 1) = (/ &
        & 0.87340e-10_r8,0.36953e-07_r8,0.56709e-07_r8,0.68921e-07_r8,0.15563e-08_r8 /)
      kbo(:, 1,31, 1) = (/ &
        & 0.88806e-10_r8,0.22555e-07_r8,0.32386e-07_r8,0.37129e-07_r8,0.89029e-09_r8 /)
      kbo(:, 2,31, 1) = (/ &
        & 0.83417e-10_r8,0.24519e-07_r8,0.35921e-07_r8,0.41870e-07_r8,0.98548e-09_r8 /)
      kbo(:, 3,31, 1) = (/ &
        & 0.78644e-10_r8,0.26638e-07_r8,0.39609e-07_r8,0.47273e-07_r8,0.10854e-08_r8 /)
      kbo(:, 4,31, 1) = (/ &
        & 0.74388e-10_r8,0.28694e-07_r8,0.43423e-07_r8,0.52435e-07_r8,0.11880e-08_r8 /)
      kbo(:, 5,31, 1) = (/ &
        & 0.70568e-10_r8,0.30776e-07_r8,0.47411e-07_r8,0.57750e-07_r8,0.12931e-08_r8 /)
      kbo(:, 1,32, 1) = (/ &
        & 0.71507e-10_r8,0.18870e-07_r8,0.27332e-07_r8,0.31309e-07_r8,0.74436e-09_r8 /)
      kbo(:, 2,32, 1) = (/ &
        & 0.67235e-10_r8,0.20512e-07_r8,0.30189e-07_r8,0.35407e-07_r8,0.82294e-09_r8 /)
      kbo(:, 3,32, 1) = (/ &
        & 0.63444e-10_r8,0.22259e-07_r8,0.33218e-07_r8,0.39730e-07_r8,0.90483e-09_r8 /)
      kbo(:, 4,32, 1) = (/ &
        & 0.60058e-10_r8,0.23923e-07_r8,0.36405e-07_r8,0.43976e-07_r8,0.98908e-09_r8 /)
      kbo(:, 5,32, 1) = (/ &
        & 0.57015e-10_r8,0.25634e-07_r8,0.39548e-07_r8,0.48346e-07_r8,0.10750e-08_r8 /)
      kbo(:, 1,33, 1) = (/ &
        & 0.57586e-10_r8,0.15779e-07_r8,0.22950e-07_r8,0.26415e-07_r8,0.62256e-09_r8 /)
      kbo(:, 2,33, 1) = (/ &
        & 0.54199e-10_r8,0.17153e-07_r8,0.25354e-07_r8,0.29904e-07_r8,0.68734e-09_r8 /)
      kbo(:, 3,33, 1) = (/ &
        & 0.51188e-10_r8,0.18569e-07_r8,0.27869e-07_r8,0.33404e-07_r8,0.75467e-09_r8 /)
      kbo(:, 4,33, 1) = (/ &
        & 0.48493e-10_r8,0.19935e-07_r8,0.30437e-07_r8,0.36856e-07_r8,0.82369e-09_r8 /)
      kbo(:, 5,33, 1) = (/ &
        & 0.46069e-10_r8,0.21345e-07_r8,0.32988e-07_r8,0.40478e-07_r8,0.89402e-09_r8 /)
      kbo(:, 1,34, 1) = (/ &
        & 0.46487e-10_r8,0.13161e-07_r8,0.19216e-07_r8,0.22212e-07_r8,0.51910e-09_r8 /)
      kbo(:, 2,34, 1) = (/ &
        & 0.43789e-10_r8,0.14301e-07_r8,0.21182e-07_r8,0.25090e-07_r8,0.57247e-09_r8 /)
      kbo(:, 3,34, 1) = (/ &
        & 0.41386e-10_r8,0.15447e-07_r8,0.23208e-07_r8,0.27938e-07_r8,0.62767e-09_r8 /)
      kbo(:, 4,34, 1) = (/ &
        & 0.39234e-10_r8,0.16571e-07_r8,0.25347e-07_r8,0.30795e-07_r8,0.68426e-09_r8 /)
      kbo(:, 5,34, 1) = (/ &
        & 0.37294e-10_r8,0.17725e-07_r8,0.27392e-07_r8,0.33781e-07_r8,0.74179e-09_r8 /)
      kbo(:, 1,35, 1) = (/ &
        & 0.37756e-10_r8,0.10890e-07_r8,0.15882e-07_r8,0.18441e-07_r8,0.42871e-09_r8 /)
      kbo(:, 2,35, 1) = (/ &
        & 0.35581e-10_r8,0.11830e-07_r8,0.17514e-07_r8,0.20810e-07_r8,0.47251e-09_r8 /)
      kbo(:, 3,35, 1) = (/ &
        & 0.33643e-10_r8,0.12757e-07_r8,0.19184e-07_r8,0.23148e-07_r8,0.51769e-09_r8 /)
      kbo(:, 4,35, 1) = (/ &
        & 0.31905e-10_r8,0.13682e-07_r8,0.20941e-07_r8,0.25477e-07_r8,0.56394e-09_r8 /)
      kbo(:, 5,35, 1) = (/ &
        & 0.30338e-10_r8,0.14628e-07_r8,0.22613e-07_r8,0.27948e-07_r8,0.61100e-09_r8 /)
      kbo(:, 1,36, 1) = (/ &
        & 0.30872e-10_r8,0.89290e-08_r8,0.13007e-07_r8,0.15108e-07_r8,0.35034e-09_r8 /)
      kbo(:, 2,36, 1) = (/ &
        & 0.29096e-10_r8,0.96995e-08_r8,0.14343e-07_r8,0.17051e-07_r8,0.38609e-09_r8 /)
      kbo(:, 3,36, 1) = (/ &
        & 0.27513e-10_r8,0.10456e-07_r8,0.15713e-07_r8,0.18968e-07_r8,0.42296e-09_r8 /)
      kbo(:, 4,36, 1) = (/ &
        & 0.26093e-10_r8,0.11213e-07_r8,0.17153e-07_r8,0.20875e-07_r8,0.46073e-09_r8 /)
      kbo(:, 5,36, 1) = (/ &
        & 0.24812e-10_r8,0.11987e-07_r8,0.18522e-07_r8,0.22899e-07_r8,0.49916e-09_r8 /)
      kbo(:, 1,37, 1) = (/ &
        & 0.25479e-10_r8,0.72338e-08_r8,0.10508e-07_r8,0.12165e-07_r8,0.28268e-09_r8 /)
      kbo(:, 2,37, 1) = (/ &
        & 0.24002e-10_r8,0.78593e-08_r8,0.11594e-07_r8,0.13747e-07_r8,0.31173e-09_r8 /)
      kbo(:, 3,37, 1) = (/ &
        & 0.22687e-10_r8,0.84845e-08_r8,0.12712e-07_r8,0.15315e-07_r8,0.34178e-09_r8 /)
      kbo(:, 4,37, 1) = (/ &
        & 0.21508e-10_r8,0.90997e-08_r8,0.13892e-07_r8,0.16886e-07_r8,0.37260e-09_r8 /)
      kbo(:, 5,37, 1) = (/ &
        & 0.20446e-10_r8,0.97322e-08_r8,0.15012e-07_r8,0.18526e-07_r8,0.40398e-09_r8 /)
      kbo(:, 1,38, 1) = (/ &
        & 0.21041e-10_r8,0.58565e-08_r8,0.84831e-08_r8,0.97892e-08_r8,0.22791e-09_r8 /)
      kbo(:, 2,38, 1) = (/ &
        & 0.19811e-10_r8,0.63636e-08_r8,0.93619e-08_r8,0.11072e-07_r8,0.25148e-09_r8 /)
      kbo(:, 3,38, 1) = (/ &
        & 0.18717e-10_r8,0.68784e-08_r8,0.10276e-07_r8,0.12360e-07_r8,0.27595e-09_r8 /)
      kbo(:, 4,38, 1) = (/ &
        & 0.17738e-10_r8,0.73792e-08_r8,0.11234e-07_r8,0.13638e-07_r8,0.30109e-09_r8 /)
      kbo(:, 5,38, 1) = (/ &
        & 0.16856e-10_r8,0.78971e-08_r8,0.12166e-07_r8,0.14977e-07_r8,0.32671e-09_r8 /)
      kbo(:, 1,39, 1) = (/ &
        & 0.17377e-10_r8,0.47418e-08_r8,0.68561e-08_r8,0.78795e-08_r8,0.18373e-09_r8 /)
      kbo(:, 2,39, 1) = (/ &
        & 0.16353e-10_r8,0.51532e-08_r8,0.75620e-08_r8,0.89128e-08_r8,0.20284e-09_r8 /)
      kbo(:, 3,39, 1) = (/ &
        & 0.15443e-10_r8,0.55752e-08_r8,0.83069e-08_r8,0.99666e-08_r8,0.22279e-09_r8 /)
      kbo(:, 4,39, 1) = (/ &
        & 0.14629e-10_r8,0.59857e-08_r8,0.90872e-08_r8,0.11011e-07_r8,0.24327e-09_r8 /)
      kbo(:, 5,39, 1) = (/ &
        & 0.13896e-10_r8,0.64086e-08_r8,0.98616e-08_r8,0.12104e-07_r8,0.26420e-09_r8 /)
      kbo(:, 1,40, 1) = (/ &
        & 0.14445e-10_r8,0.38091e-08_r8,0.54799e-08_r8,0.62754e-08_r8,0.14679e-09_r8 /)
      kbo(:, 2,40, 1) = (/ &
        & 0.13581e-10_r8,0.41391e-08_r8,0.60530e-08_r8,0.70909e-08_r8,0.16220e-09_r8 /)
      kbo(:, 3,40, 1) = (/ &
        & 0.12815e-10_r8,0.44888e-08_r8,0.66555e-08_r8,0.79532e-08_r8,0.17842e-09_r8 /)
      kbo(:, 4,40, 1) = (/ &
        & 0.12131e-10_r8,0.48207e-08_r8,0.72855e-08_r8,0.88071e-08_r8,0.19509e-09_r8 /)
      kbo(:, 5,40, 1) = (/ &
        & 0.11516e-10_r8,0.51646e-08_r8,0.79268e-08_r8,0.96932e-08_r8,0.21214e-09_r8 /)
      kbo(:, 1,41, 1) = (/ &
        & 0.12021e-10_r8,0.30566e-08_r8,0.43606e-08_r8,0.49921e-08_r8,0.11713e-09_r8 /)
      kbo(:, 2,41, 1) = (/ &
        & 0.11291e-10_r8,0.33205e-08_r8,0.48340e-08_r8,0.56256e-08_r8,0.12954e-09_r8 /)
      kbo(:, 3,41, 1) = (/ &
        & 0.10645e-10_r8,0.36053e-08_r8,0.53261e-08_r8,0.63473e-08_r8,0.14269e-09_r8 /)
      kbo(:, 4,41, 1) = (/ &
        & 0.10069e-10_r8,0.38782e-08_r8,0.58347e-08_r8,0.70386e-08_r8,0.15624e-09_r8 /)
      kbo(:, 5,41, 1) = (/ &
        & 0.95520e-11_r8,0.41580e-08_r8,0.63647e-08_r8,0.77515e-08_r8,0.17013e-09_r8 /)
      kbo(:, 1,42, 1) = (/ &
        & 0.10007e-10_r8,0.24516e-08_r8,0.34653e-08_r8,0.39398e-08_r8,0.93475e-10_r8 /)
      kbo(:, 2,42, 1) = (/ &
        & 0.93902e-11_r8,0.26631e-08_r8,0.38588e-08_r8,0.44635e-08_r8,0.10342e-09_r8 /)
      kbo(:, 3,42, 1) = (/ &
        & 0.88449e-11_r8,0.28926e-08_r8,0.42600e-08_r8,0.50466e-08_r8,0.11406e-09_r8 /)
      kbo(:, 4,42, 1) = (/ &
        & 0.83594e-11_r8,0.31198e-08_r8,0.46719e-08_r8,0.56218e-08_r8,0.12507e-09_r8 /)
      kbo(:, 5,42, 1) = (/ &
        & 0.79244e-11_r8,0.33465e-08_r8,0.51065e-08_r8,0.61999e-08_r8,0.13640e-09_r8 /)
      kbo(:, 1,43, 1) = (/ &
        & 0.83647e-11_r8,0.19578e-08_r8,0.27341e-08_r8,0.30827e-08_r8,0.74277e-10_r8 /)
      kbo(:, 2,43, 1) = (/ &
        & 0.78389e-11_r8,0.21263e-08_r8,0.30690e-08_r8,0.35212e-08_r8,0.82118e-10_r8 /)
      kbo(:, 3,43, 1) = (/ &
        & 0.73752e-11_r8,0.23103e-08_r8,0.33865e-08_r8,0.39836e-08_r8,0.90672e-10_r8 /)
      kbo(:, 4,43, 1) = (/ &
        & 0.69633e-11_r8,0.24984e-08_r8,0.37198e-08_r8,0.44569e-08_r8,0.99628e-10_r8 /)
      kbo(:, 5,43, 1) = (/ &
        & 0.65950e-11_r8,0.26833e-08_r8,0.40709e-08_r8,0.49265e-08_r8,0.10883e-09_r8 /)
      kbo(:, 1,44, 1) = (/ &
        & 0.70070e-11_r8,0.15628e-08_r8,0.21521e-08_r8,0.24017e-08_r8,0.59116e-10_r8 /)
      kbo(:, 2,44, 1) = (/ &
        & 0.65570e-11_r8,0.16954e-08_r8,0.24254e-08_r8,0.27772e-08_r8,0.65027e-10_r8 /)
      kbo(:, 3,44, 1) = (/ &
        & 0.61612e-11_r8,0.18413e-08_r8,0.26845e-08_r8,0.31310e-08_r8,0.71892e-10_r8 /)
      kbo(:, 4,44, 1) = (/ &
        & 0.58106e-11_r8,0.19977e-08_r8,0.29542e-08_r8,0.35211e-08_r8,0.79144e-10_r8 /)
      kbo(:, 5,44, 1) = (/ &
        & 0.54976e-11_r8,0.21464e-08_r8,0.32360e-08_r8,0.39045e-08_r8,0.86629e-10_r8 /)
      kbo(:, 1,45, 1) = (/ &
        & 0.58728e-11_r8,0.12500e-08_r8,0.17079e-08_r8,0.18743e-08_r8,0.46646e-10_r8 /)
      kbo(:, 2,45, 1) = (/ &
        & 0.54873e-11_r8,0.13505e-08_r8,0.19105e-08_r8,0.21719e-08_r8,0.51499e-10_r8 /)
      kbo(:, 3,45, 1) = (/ &
        & 0.51492e-11_r8,0.14670e-08_r8,0.21250e-08_r8,0.24590e-08_r8,0.56982e-10_r8 /)
      kbo(:, 4,45, 1) = (/ &
        & 0.48504e-11_r8,0.15931e-08_r8,0.23464e-08_r8,0.27802e-08_r8,0.62839e-10_r8 /)
      kbo(:, 5,45, 1) = (/ &
        & 0.45844e-11_r8,0.17167e-08_r8,0.25731e-08_r8,0.30954e-08_r8,0.68908e-10_r8 /)
      kbo(:, 1,46, 1) = (/ &
        & 0.49328e-11_r8,0.99811e-09_r8,0.13397e-08_r8,0.14457e-08_r8,0.36694e-10_r8 /)
      kbo(:, 2,46, 1) = (/ &
        & 0.46012e-11_r8,0.10742e-08_r8,0.14986e-08_r8,0.16875e-08_r8,0.40742e-10_r8 /)
      kbo(:, 3,46, 1) = (/ &
        & 0.43113e-11_r8,0.11665e-08_r8,0.16813e-08_r8,0.19281e-08_r8,0.45049e-10_r8 /)
      kbo(:, 4,46, 1) = (/ &
        & 0.40558e-11_r8,0.12673e-08_r8,0.18567e-08_r8,0.21817e-08_r8,0.49751e-10_r8 /)
      kbo(:, 5,46, 1) = (/ &
        & 0.38288e-11_r8,0.13702e-08_r8,0.20399e-08_r8,0.24419e-08_r8,0.54679e-10_r8 /)
      kbo(:, 1,47, 1) = (/ &
        & 0.41592e-11_r8,0.79205e-09_r8,0.10438e-08_r8,0.11055e-08_r8,0.28709e-10_r8 /)
      kbo(:, 2,47, 1) = (/ &
        & 0.38717e-11_r8,0.85357e-09_r8,0.11710e-08_r8,0.13015e-08_r8,0.32198e-10_r8 /)
      kbo(:, 3,47, 1) = (/ &
        & 0.36215e-11_r8,0.92515e-09_r8,0.13196e-08_r8,0.15103e-08_r8,0.35448e-10_r8 /)
      kbo(:, 4,47, 1) = (/ &
        & 0.34016e-11_r8,0.10046e-08_r8,0.14619e-08_r8,0.17010e-08_r8,0.39203e-10_r8 /)
      kbo(:, 5,47, 1) = (/ &
        & 0.32069e-11_r8,0.10904e-08_r8,0.16100e-08_r8,0.19168e-08_r8,0.43187e-10_r8 /)
      kbo(:, 1,48, 1) = (/ &
        & 0.35100e-11_r8,0.62849e-09_r8,0.81319e-09_r8,0.84567e-09_r8,0.22456e-10_r8 /)
      kbo(:, 2,48, 1) = (/ &
        & 0.32605e-11_r8,0.68021e-09_r8,0.92169e-09_r8,0.10040e-08_r8,0.25229e-10_r8 /)
      kbo(:, 3,48, 1) = (/ &
        & 0.30441e-11_r8,0.73294e-09_r8,0.10314e-08_r8,0.11665e-08_r8,0.27903e-10_r8 /)
      kbo(:, 4,48, 1) = (/ &
        & 0.28547e-11_r8,0.79615e-09_r8,0.11495e-08_r8,0.13251e-08_r8,0.30879e-10_r8 /)
      kbo(:, 5,48, 1) = (/ &
        & 0.26874e-11_r8,0.86463e-09_r8,0.12703e-08_r8,0.14994e-08_r8,0.34082e-10_r8 /)
      kbo(:, 1,49, 1) = (/ &
        & 0.29649e-11_r8,0.49867e-09_r8,0.63572e-09_r8,0.64557e-09_r8,0.17554e-10_r8 /)
      kbo(:, 2,49, 1) = (/ &
        & 0.27480e-11_r8,0.54124e-09_r8,0.71871e-09_r8,0.76840e-09_r8,0.19749e-10_r8 /)
      kbo(:, 3,49, 1) = (/ &
        & 0.25606e-11_r8,0.58140e-09_r8,0.80413e-09_r8,0.90054e-09_r8,0.22012e-10_r8 /)
      kbo(:, 4,49, 1) = (/ &
        & 0.23972e-11_r8,0.63097e-09_r8,0.90637e-09_r8,0.10349e-08_r8,0.24308e-10_r8 /)
      kbo(:, 5,49, 1) = (/ &
        & 0.22534e-11_r8,0.68545e-09_r8,0.10006e-08_r8,0.11704e-08_r8,0.26872e-10_r8 /)
      kbo(:, 1,50, 1) = (/ &
        & 0.25019e-11_r8,0.39853e-09_r8,0.49374e-09_r8,0.49615e-09_r8,0.13762e-10_r8 /)
      kbo(:, 2,50, 1) = (/ &
        & 0.23136e-11_r8,0.42952e-09_r8,0.56141e-09_r8,0.58980e-09_r8,0.15500e-10_r8 /)
      kbo(:, 3,50, 1) = (/ &
        & 0.21517e-11_r8,0.46334e-09_r8,0.63284e-09_r8,0.69788e-09_r8,0.17390e-10_r8 /)
      kbo(:, 4,50, 1) = (/ &
        & 0.20110e-11_r8,0.50130e-09_r8,0.71124e-09_r8,0.80903e-09_r8,0.19184e-10_r8 /)
      kbo(:, 5,50, 1) = (/ &
        & 0.18875e-11_r8,0.54446e-09_r8,0.78908e-09_r8,0.91435e-09_r8,0.21230e-10_r8 /)
      kbo(:, 1,51, 1) = (/ &
        & 0.21111e-11_r8,0.31534e-09_r8,0.38552e-09_r8,0.38324e-09_r8,0.10851e-10_r8 /)
      kbo(:, 2,51, 1) = (/ &
        & 0.19478e-11_r8,0.34179e-09_r8,0.43986e-09_r8,0.45355e-09_r8,0.12176e-10_r8 /)
      kbo(:, 3,51, 1) = (/ &
        & 0.18079e-11_r8,0.37016e-09_r8,0.49835e-09_r8,0.53919e-09_r8,0.13683e-10_r8 /)
      kbo(:, 4,51, 1) = (/ &
        & 0.16868e-11_r8,0.39846e-09_r8,0.55746e-09_r8,0.62805e-09_r8,0.15164e-10_r8 /)
      kbo(:, 5,51, 1) = (/ &
        & 0.15809e-11_r8,0.43272e-09_r8,0.62310e-09_r8,0.71587e-09_r8,0.16785e-10_r8 /)
      kbo(:, 1,52, 1) = (/ &
        & 0.17830e-11_r8,0.24939e-09_r8,0.30033e-09_r8,0.29708e-09_r8,0.85480e-11_r8 /)
      kbo(:, 2,52, 1) = (/ &
        & 0.16410e-11_r8,0.27244e-09_r8,0.34467e-09_r8,0.34870e-09_r8,0.95642e-11_r8 /)
      kbo(:, 3,52, 1) = (/ &
        & 0.15200e-11_r8,0.29507e-09_r8,0.39020e-09_r8,0.41505e-09_r8,0.10764e-10_r8 /)
      kbo(:, 4,52, 1) = (/ &
        & 0.14156e-11_r8,0.31736e-09_r8,0.43693e-09_r8,0.48758e-09_r8,0.12016e-10_r8 /)
      kbo(:, 5,52, 1) = (/ &
        & 0.13246e-11_r8,0.34409e-09_r8,0.49243e-09_r8,0.56181e-09_r8,0.13267e-10_r8 /)
      kbo(:, 1,53, 1) = (/ &
        & 0.15074e-11_r8,0.19746e-09_r8,0.23442e-09_r8,0.23027e-09_r8,0.66942e-11_r8 /)
      kbo(:, 2,53, 1) = (/ &
        & 0.13838e-11_r8,0.21754e-09_r8,0.26812e-09_r8,0.26865e-09_r8,0.75095e-11_r8 /)
      kbo(:, 3,53, 1) = (/ &
        & 0.12789e-11_r8,0.23445e-09_r8,0.30510e-09_r8,0.31916e-09_r8,0.84626e-11_r8 /)
      kbo(:, 4,53, 1) = (/ &
        & 0.11888e-11_r8,0.25305e-09_r8,0.34496e-09_r8,0.37906e-09_r8,0.94963e-11_r8 /)
      kbo(:, 5,53, 1) = (/ &
        & 0.11106e-11_r8,0.27355e-09_r8,0.38680e-09_r8,0.43882e-09_r8,0.10486e-10_r8 /)
      kbo(:, 1,54, 1) = (/ &
        & 0.12722e-11_r8,0.15676e-09_r8,0.18436e-09_r8,0.18188e-09_r8,0.52601e-11_r8 /)
      kbo(:, 2,54, 1) = (/ &
        & 0.11649e-11_r8,0.17256e-09_r8,0.21030e-09_r8,0.20876e-09_r8,0.59465e-11_r8 /)
      kbo(:, 3,54, 1) = (/ &
        & 0.10743e-11_r8,0.18706e-09_r8,0.24022e-09_r8,0.24657e-09_r8,0.66750e-11_r8 /)
      kbo(:, 4,54, 1) = (/ &
        & 0.99683e-12_r8,0.20263e-09_r8,0.27206e-09_r8,0.29337e-09_r8,0.75016e-11_r8 /)
      kbo(:, 5,54, 1) = (/ &
        & 0.92975e-12_r8,0.21798e-09_r8,0.30420e-09_r8,0.34203e-09_r8,0.83182e-11_r8 /)
      kbo(:, 1,55, 1) = (/ &
        & 0.10733e-11_r8,0.12552e-09_r8,0.14668e-09_r8,0.14477e-09_r8,0.41440e-11_r8 /)
      kbo(:, 2,55, 1) = (/ &
        & 0.98027e-12_r8,0.13705e-09_r8,0.16480e-09_r8,0.16298e-09_r8,0.47137e-11_r8 /)
      kbo(:, 3,55, 1) = (/ &
        & 0.90209e-12_r8,0.14966e-09_r8,0.18911e-09_r8,0.19117e-09_r8,0.52730e-11_r8 /)
      kbo(:, 4,55, 1) = (/ &
        & 0.83546e-12_r8,0.16210e-09_r8,0.21410e-09_r8,0.22758e-09_r8,0.59349e-11_r8 /)
      kbo(:, 5,55, 1) = (/ &
        & 0.77800e-12_r8,0.17423e-09_r8,0.23972e-09_r8,0.26725e-09_r8,0.66163e-11_r8 /)
      kbo(:, 1,56, 1) = (/ &
        & 0.90624e-12_r8,0.99786e-10_r8,0.11674e-09_r8,0.11286e-09_r8,0.32776e-11_r8 /)
      kbo(:, 2,56, 1) = (/ &
        & 0.82547e-12_r8,0.10897e-09_r8,0.12938e-09_r8,0.12705e-09_r8,0.37161e-11_r8 /)
      kbo(:, 3,56, 1) = (/ &
        & 0.75791e-12_r8,0.12009e-09_r8,0.14804e-09_r8,0.14827e-09_r8,0.41646e-11_r8 /)
      kbo(:, 4,56, 1) = (/ &
        & 0.70058e-12_r8,0.12925e-09_r8,0.16837e-09_r8,0.17630e-09_r8,0.46957e-11_r8 /)
      kbo(:, 5,56, 1) = (/ &
        & 0.65131e-12_r8,0.13937e-09_r8,0.18999e-09_r8,0.20899e-09_r8,0.52742e-11_r8 /)
      kbo(:, 1,57, 1) = (/ &
        & 0.76595e-12_r8,0.78822e-10_r8,0.93863e-10_r8,0.87529e-10_r8,0.26033e-11_r8 /)
      kbo(:, 2,57, 1) = (/ &
        & 0.69568e-12_r8,0.86555e-10_r8,0.10190e-09_r8,0.10022e-09_r8,0.29288e-11_r8 /)
      kbo(:, 3,57, 1) = (/ &
        & 0.63721e-12_r8,0.95385e-10_r8,0.11640e-09_r8,0.11533e-09_r8,0.32994e-11_r8 /)
      kbo(:, 4,57, 1) = (/ &
        & 0.58782e-12_r8,0.10325e-09_r8,0.13264e-09_r8,0.13663e-09_r8,0.37186e-11_r8 /)
      kbo(:, 5,57, 1) = (/ &
        & 0.54552e-12_r8,0.11173e-09_r8,0.15042e-09_r8,0.16253e-09_r8,0.41819e-11_r8 /)
      kbo(:, 1,58, 1) = (/ &
        & 0.64693e-12_r8,0.62421e-10_r8,0.76174e-10_r8,0.68324e-10_r8,0.20833e-11_r8 /)
      kbo(:, 2,58, 1) = (/ &
        & 0.58588e-12_r8,0.69278e-10_r8,0.81197e-10_r8,0.79691e-10_r8,0.23130e-11_r8 /)
      kbo(:, 3,58, 1) = (/ &
        & 0.53535e-12_r8,0.75873e-10_r8,0.91414e-10_r8,0.90398e-10_r8,0.26350e-11_r8 /)
      kbo(:, 4,58, 1) = (/ &
        & 0.49285e-12_r8,0.82653e-10_r8,0.10493e-09_r8,0.10617e-09_r8,0.29473e-11_r8 /)
      kbo(:, 5,58, 1) = (/ &
        & 0.45660e-12_r8,0.89643e-10_r8,0.11861e-09_r8,0.12647e-09_r8,0.33231e-11_r8 /)
      kbo(:, 1,59, 1) = (/ &
        & 0.53645e-12_r8,0.50557e-10_r8,0.62240e-10_r8,0.54854e-10_r8,0.16930e-11_r8 /)
      kbo(:, 2,59, 1) = (/ &
        & 0.48523e-12_r8,0.56468e-10_r8,0.65604e-10_r8,0.64827e-10_r8,0.18702e-11_r8 /)
      kbo(:, 3,59, 1) = (/ &
        & 0.44294e-12_r8,0.61442e-10_r8,0.73667e-10_r8,0.72688e-10_r8,0.21292e-11_r8 /)
      kbo(:, 4,59, 1) = (/ &
        & 0.40744e-12_r8,0.67184e-10_r8,0.84490e-10_r8,0.85217e-10_r8,0.23832e-11_r8 /)
      kbo(:, 5,59, 1) = (/ &
        & 0.37720e-12_r8,0.72657e-10_r8,0.95692e-10_r8,0.10144e-09_r8,0.26852e-11_r8 /)
      kbo(:, 1,13, 2) = (/ &
        & 0.18323e-07_r8,0.86266e-05_r8,0.13728e-04_r8,0.15952e-04_r8,0.78927e-06_r8 /)
      kbo(:, 2,13, 2) = (/ &
        & 0.16961e-07_r8,0.96203e-05_r8,0.15275e-04_r8,0.17863e-04_r8,0.93659e-06_r8 /)
      kbo(:, 3,13, 2) = (/ &
        & 0.15787e-07_r8,0.10675e-04_r8,0.16924e-04_r8,0.19675e-04_r8,0.11050e-05_r8 /)
      kbo(:, 4,13, 2) = (/ &
        & 0.14764e-07_r8,0.11779e-04_r8,0.18474e-04_r8,0.21320e-04_r8,0.12868e-05_r8 /)
      kbo(:, 5,13, 2) = (/ &
        & 0.13865e-07_r8,0.12843e-04_r8,0.20029e-04_r8,0.23080e-04_r8,0.14565e-05_r8 /)
      kbo(:, 1,14, 2) = (/ &
        & 0.14893e-07_r8,0.71882e-05_r8,0.11443e-04_r8,0.13271e-04_r8,0.65835e-06_r8 /)
      kbo(:, 2,14, 2) = (/ &
        & 0.13793e-07_r8,0.80276e-05_r8,0.12732e-04_r8,0.14890e-04_r8,0.78132e-06_r8 /)
      kbo(:, 3,14, 2) = (/ &
        & 0.12844e-07_r8,0.89189e-05_r8,0.14101e-04_r8,0.16339e-04_r8,0.92233e-06_r8 /)
      kbo(:, 4,14, 2) = (/ &
        & 0.12017e-07_r8,0.98309e-05_r8,0.15384e-04_r8,0.17721e-04_r8,0.10676e-05_r8 /)
      kbo(:, 5,14, 2) = (/ &
        & 0.11289e-07_r8,0.10704e-04_r8,0.16679e-04_r8,0.19194e-04_r8,0.12091e-05_r8 /)
      kbo(:, 1,15, 2) = (/ &
        & 0.12096e-07_r8,0.59934e-05_r8,0.95449e-05_r8,0.11058e-04_r8,0.54969e-06_r8 /)
      kbo(:, 2,15, 2) = (/ &
        & 0.11209e-07_r8,0.66932e-05_r8,0.10623e-04_r8,0.12407e-04_r8,0.65197e-06_r8 /)
      kbo(:, 3,15, 2) = (/ &
        & 0.10443e-07_r8,0.74449e-05_r8,0.11746e-04_r8,0.13571e-04_r8,0.76940e-06_r8 /)
      kbo(:, 4,15, 2) = (/ &
        & 0.97747e-08_r8,0.81948e-05_r8,0.12814e-04_r8,0.14732e-04_r8,0.88496e-06_r8 /)
      kbo(:, 5,15, 2) = (/ &
        & 0.91864e-08_r8,0.89188e-05_r8,0.13883e-04_r8,0.15946e-04_r8,0.10023e-05_r8 /)
      kbo(:, 1,16, 2) = (/ &
        & 0.98205e-08_r8,0.50027e-05_r8,0.79644e-05_r8,0.92248e-05_r8,0.45876e-06_r8 /)
      kbo(:, 2,16, 2) = (/ &
        & 0.91061e-08_r8,0.55846e-05_r8,0.88593e-05_r8,0.10331e-04_r8,0.54334e-06_r8 /)
      kbo(:, 3,16, 2) = (/ &
        & 0.84882e-08_r8,0.62183e-05_r8,0.97757e-05_r8,0.11279e-04_r8,0.64050e-06_r8 /)
      kbo(:, 4,16, 2) = (/ &
        & 0.79486e-08_r8,0.68276e-05_r8,0.10664e-04_r8,0.12244e-04_r8,0.73344e-06_r8 /)
      kbo(:, 5,16, 2) = (/ &
        & 0.74732e-08_r8,0.74268e-05_r8,0.11545e-04_r8,0.13224e-04_r8,0.82955e-06_r8 /)
      kbo(:, 1,17, 2) = (/ &
        & 0.79753e-08_r8,0.41713e-05_r8,0.66153e-05_r8,0.76892e-05_r8,0.38247e-06_r8 /)
      kbo(:, 2,17, 2) = (/ &
        & 0.73994e-08_r8,0.46562e-05_r8,0.73753e-05_r8,0.85922e-05_r8,0.45188e-06_r8 /)
      kbo(:, 3,17, 2) = (/ &
        & 0.69008e-08_r8,0.51829e-05_r8,0.81280e-05_r8,0.93638e-05_r8,0.53211e-06_r8 /)
      kbo(:, 4,17, 2) = (/ &
        & 0.64650e-08_r8,0.56765e-05_r8,0.88560e-05_r8,0.10168e-04_r8,0.60647e-06_r8 /)
      kbo(:, 5,17, 2) = (/ &
        & 0.60807e-08_r8,0.61758e-05_r8,0.95894e-05_r8,0.10949e-04_r8,0.68549e-06_r8 /)
      kbo(:, 1,18, 2) = (/ &
        & 0.64779e-08_r8,0.34727e-05_r8,0.54875e-05_r8,0.64000e-05_r8,0.31851e-06_r8 /)
      kbo(:, 2,18, 2) = (/ &
        & 0.60135e-08_r8,0.38751e-05_r8,0.61308e-05_r8,0.71372e-05_r8,0.37552e-06_r8 /)
      kbo(:, 3,18, 2) = (/ &
        & 0.56111e-08_r8,0.43132e-05_r8,0.67478e-05_r8,0.77698e-05_r8,0.44141e-06_r8 /)
      kbo(:, 4,18, 2) = (/ &
        & 0.52590e-08_r8,0.47150e-05_r8,0.73444e-05_r8,0.84370e-05_r8,0.50075e-06_r8 /)
      kbo(:, 5,18, 2) = (/ &
        & 0.49483e-08_r8,0.51345e-05_r8,0.79495e-05_r8,0.90637e-05_r8,0.56601e-06_r8 /)
      kbo(:, 1,19, 2) = (/ &
        & 0.52627e-08_r8,0.28908e-05_r8,0.45586e-05_r8,0.53260e-05_r8,0.26516e-06_r8 /)
      kbo(:, 2,19, 2) = (/ &
        & 0.48882e-08_r8,0.32260e-05_r8,0.50940e-05_r8,0.59200e-05_r8,0.31190e-06_r8 /)
      kbo(:, 3,19, 2) = (/ &
        & 0.45632e-08_r8,0.35843e-05_r8,0.55992e-05_r8,0.64397e-05_r8,0.36608e-06_r8 /)
      kbo(:, 4,19, 2) = (/ &
        & 0.42786e-08_r8,0.39167e-05_r8,0.60923e-05_r8,0.69972e-05_r8,0.41361e-06_r8 /)
      kbo(:, 5,19, 2) = (/ &
        & 0.40273e-08_r8,0.42667e-05_r8,0.65904e-05_r8,0.75021e-05_r8,0.46741e-06_r8 /)
      kbo(:, 1,20, 2) = (/ &
        & 0.42704e-08_r8,0.24074e-05_r8,0.37990e-05_r8,0.44458e-05_r8,0.22103e-06_r8 /)
      kbo(:, 2,20, 2) = (/ &
        & 0.39690e-08_r8,0.26942e-05_r8,0.42393e-05_r8,0.49120e-05_r8,0.26014e-06_r8 /)
      kbo(:, 3,20, 2) = (/ &
        & 0.37071e-08_r8,0.29827e-05_r8,0.46574e-05_r8,0.53487e-05_r8,0.30416e-06_r8 /)
      kbo(:, 4,20, 2) = (/ &
        & 0.34776e-08_r8,0.32601e-05_r8,0.50635e-05_r8,0.58076e-05_r8,0.34304e-06_r8 /)
      kbo(:, 5,20, 2) = (/ &
        & 0.32747e-08_r8,0.35518e-05_r8,0.54700e-05_r8,0.62197e-05_r8,0.38752e-06_r8 /)
      kbo(:, 1,21, 2) = (/ &
        & 0.34649e-08_r8,0.20096e-05_r8,0.31689e-05_r8,0.37070e-05_r8,0.18424e-06_r8 /)
      kbo(:, 2,21, 2) = (/ &
        & 0.32224e-08_r8,0.22503e-05_r8,0.35271e-05_r8,0.40784e-05_r8,0.21705e-06_r8 /)
      kbo(:, 3,21, 2) = (/ &
        & 0.30114e-08_r8,0.24834e-05_r8,0.38737e-05_r8,0.44436e-05_r8,0.25229e-06_r8 /)
      kbo(:, 4,21, 2) = (/ &
        & 0.28263e-08_r8,0.27149e-05_r8,0.42083e-05_r8,0.48061e-05_r8,0.28464e-06_r8 /)
      kbo(:, 5,21, 2) = (/ &
        & 0.26626e-08_r8,0.29556e-05_r8,0.45394e-05_r8,0.51565e-05_r8,0.32148e-06_r8 /)
      kbo(:, 1,22, 2) = (/ &
        & 0.27976e-08_r8,0.16913e-05_r8,0.26632e-05_r8,0.31108e-05_r8,0.15537e-06_r8 /)
      kbo(:, 2,22, 2) = (/ &
        & 0.26043e-08_r8,0.18908e-05_r8,0.29553e-05_r8,0.34067e-05_r8,0.18311e-06_r8 /)
      kbo(:, 3,22, 2) = (/ &
        & 0.24359e-08_r8,0.20811e-05_r8,0.32390e-05_r8,0.37110e-05_r8,0.21094e-06_r8 /)
      kbo(:, 4,22, 2) = (/ &
        & 0.22878e-08_r8,0.22746e-05_r8,0.35144e-05_r8,0.40009e-05_r8,0.23816e-06_r8 /)
      kbo(:, 5,22, 2) = (/ &
        & 0.21567e-08_r8,0.24714e-05_r8,0.37839e-05_r8,0.42910e-05_r8,0.26886e-06_r8 /)
      kbo(:, 1,23, 2) = (/ &
        & 0.22583e-08_r8,0.14234e-05_r8,0.22388e-05_r8,0.26088e-05_r8,0.13143e-06_r8 /)
      kbo(:, 2,23, 2) = (/ &
        & 0.21043e-08_r8,0.15864e-05_r8,0.24776e-05_r8,0.28493e-05_r8,0.15460e-06_r8 /)
      kbo(:, 3,23, 2) = (/ &
        & 0.19699e-08_r8,0.17436e-05_r8,0.27072e-05_r8,0.31009e-05_r8,0.17669e-06_r8 /)
      kbo(:, 4,23, 2) = (/ &
        & 0.18515e-08_r8,0.19057e-05_r8,0.29355e-05_r8,0.33308e-05_r8,0.19953e-06_r8 /)
      kbo(:, 5,23, 2) = (/ &
        & 0.17465e-08_r8,0.20653e-05_r8,0.31542e-05_r8,0.35663e-05_r8,0.22501e-06_r8 /)
      kbo(:, 1,24, 2) = (/ &
        & 0.18221e-08_r8,0.12001e-05_r8,0.18808e-05_r8,0.21868e-05_r8,0.11138e-06_r8 /)
      kbo(:, 2,24, 2) = (/ &
        & 0.16995e-08_r8,0.13315e-05_r8,0.20779e-05_r8,0.23825e-05_r8,0.13068e-06_r8 /)
      kbo(:, 3,24, 2) = (/ &
        & 0.15923e-08_r8,0.14625e-05_r8,0.22647e-05_r8,0.25884e-05_r8,0.14820e-06_r8 /)
      kbo(:, 4,24, 2) = (/ &
        & 0.14978e-08_r8,0.15972e-05_r8,0.24512e-05_r8,0.27771e-05_r8,0.16734e-06_r8 /)
      kbo(:, 5,24, 2) = (/ &
        & 0.14138e-08_r8,0.17254e-05_r8,0.26296e-05_r8,0.29649e-05_r8,0.18848e-06_r8 /)
      kbo(:, 1,25, 2) = (/ &
        & 0.14693e-08_r8,0.10111e-05_r8,0.15809e-05_r8,0.18286e-05_r8,0.94366e-07_r8 /)
      kbo(:, 2,25, 2) = (/ &
        & 0.13718e-08_r8,0.11199e-05_r8,0.17430e-05_r8,0.19952e-05_r8,0.11045e-06_r8 /)
      kbo(:, 3,25, 2) = (/ &
        & 0.12864e-08_r8,0.12273e-05_r8,0.18957e-05_r8,0.21572e-05_r8,0.12445e-06_r8 /)
      kbo(:, 4,25, 2) = (/ &
        & 0.12110e-08_r8,0.13373e-05_r8,0.20462e-05_r8,0.23162e-05_r8,0.14042e-06_r8 /)
      kbo(:, 5,25, 2) = (/ &
        & 0.11438e-08_r8,0.14410e-05_r8,0.21916e-05_r8,0.24648e-05_r8,0.15767e-06_r8 /)
      kbo(:, 1,26, 2) = (/ &
        & 0.11834e-08_r8,0.85331e-06_r8,0.13316e-05_r8,0.15329e-05_r8,0.80212e-07_r8 /)
      kbo(:, 2,26, 2) = (/ &
        & 0.11061e-08_r8,0.94192e-06_r8,0.14626e-05_r8,0.16729e-05_r8,0.92775e-07_r8 /)
      kbo(:, 3,26, 2) = (/ &
        & 0.10382e-08_r8,0.10317e-05_r8,0.15890e-05_r8,0.18006e-05_r8,0.10462e-06_r8 /)
      kbo(:, 4,26, 2) = (/ &
        & 0.97810e-09_r8,0.11205e-05_r8,0.17099e-05_r8,0.19314e-05_r8,0.11800e-06_r8 /)
      kbo(:, 5,26, 2) = (/ &
        & 0.92457e-09_r8,0.12034e-05_r8,0.18276e-05_r8,0.20504e-05_r8,0.13209e-06_r8 /)
      kbo(:, 1,27, 2) = (/ &
        & 0.95311e-09_r8,0.71890e-06_r8,0.11218e-05_r8,0.12867e-05_r8,0.68084e-07_r8 /)
      kbo(:, 2,27, 2) = (/ &
        & 0.89177e-09_r8,0.79258e-06_r8,0.12275e-05_r8,0.14019e-05_r8,0.77999e-07_r8 /)
      kbo(:, 3,27, 2) = (/ &
        & 0.83781e-09_r8,0.86605e-06_r8,0.13308e-05_r8,0.15040e-05_r8,0.88027e-07_r8 /)
      kbo(:, 4,27, 2) = (/ &
        & 0.78998e-09_r8,0.93815e-06_r8,0.14285e-05_r8,0.16091e-05_r8,0.99057e-07_r8 /)
      kbo(:, 5,27, 2) = (/ &
        & 0.74729e-09_r8,0.10046e-05_r8,0.15236e-05_r8,0.17059e-05_r8,0.11074e-06_r8 /)
      kbo(:, 1,28, 2) = (/ &
        & 0.76771e-09_r8,0.60623e-06_r8,0.94427e-06_r8,0.10796e-05_r8,0.57844e-07_r8 /)
      kbo(:, 2,28, 2) = (/ &
        & 0.71904e-09_r8,0.66653e-06_r8,0.10298e-05_r8,0.11699e-05_r8,0.65726e-07_r8 /)
      kbo(:, 3,28, 2) = (/ &
        & 0.67614e-09_r8,0.72689e-06_r8,0.11131e-05_r8,0.12568e-05_r8,0.74009e-07_r8 /)
      kbo(:, 4,28, 2) = (/ &
        & 0.63806e-09_r8,0.78482e-06_r8,0.11927e-05_r8,0.13406e-05_r8,0.83200e-07_r8 /)
      kbo(:, 5,28, 2) = (/ &
        & 0.60401e-09_r8,0.83806e-06_r8,0.12695e-05_r8,0.14186e-05_r8,0.92306e-07_r8 /)
      kbo(:, 1,29, 2) = (/ &
        & 0.61817e-09_r8,0.51053e-06_r8,0.79450e-06_r8,0.90687e-06_r8,0.49078e-07_r8 /)
      kbo(:, 2,29, 2) = (/ &
        & 0.57958e-09_r8,0.56071e-06_r8,0.86403e-06_r8,0.97690e-06_r8,0.55257e-07_r8 /)
      kbo(:, 3,29, 2) = (/ &
        & 0.54551e-09_r8,0.61009e-06_r8,0.93077e-06_r8,0.10495e-05_r8,0.62286e-07_r8 /)
      kbo(:, 4,29, 2) = (/ &
        & 0.51520e-09_r8,0.65631e-06_r8,0.99567e-06_r8,0.11159e-05_r8,0.69954e-07_r8 /)
      kbo(:, 5,29, 2) = (/ &
        & 0.48806e-09_r8,0.69830e-06_r8,0.10576e-05_r8,0.11790e-05_r8,0.77228e-07_r8 /)
      kbo(:, 1,30, 2) = (/ &
        & 0.49783e-09_r8,0.43014e-06_r8,0.66732e-06_r8,0.76058e-06_r8,0.41306e-07_r8 /)
      kbo(:, 2,30, 2) = (/ &
        & 0.46723e-09_r8,0.47148e-06_r8,0.72434e-06_r8,0.81682e-06_r8,0.46537e-07_r8 /)
      kbo(:, 3,30, 2) = (/ &
        & 0.44015e-09_r8,0.51146e-06_r8,0.77809e-06_r8,0.87537e-06_r8,0.52451e-07_r8 /)
      kbo(:, 4,30, 2) = (/ &
        & 0.41603e-09_r8,0.54877e-06_r8,0.83073e-06_r8,0.92884e-06_r8,0.58793e-07_r8 /)
      kbo(:, 5,30, 2) = (/ &
        & 0.39440e-09_r8,0.58159e-06_r8,0.88054e-06_r8,0.98030e-06_r8,0.64630e-07_r8 /)
      kbo(:, 1,31, 2) = (/ &
        & 0.40087e-09_r8,0.36256e-06_r8,0.56062e-06_r8,0.63549e-06_r8,0.34778e-07_r8 /)
      kbo(:, 2,31, 2) = (/ &
        & 0.37660e-09_r8,0.39620e-06_r8,0.60674e-06_r8,0.68313e-06_r8,0.39213e-07_r8 /)
      kbo(:, 3,31, 2) = (/ &
        & 0.35510e-09_r8,0.42855e-06_r8,0.65037e-06_r8,0.72999e-06_r8,0.44176e-07_r8 /)
      kbo(:, 4,31, 2) = (/ &
        & 0.33590e-09_r8,0.45852e-06_r8,0.69308e-06_r8,0.77338e-06_r8,0.49424e-07_r8 /)
      kbo(:, 5,31, 2) = (/ &
        & 0.31866e-09_r8,0.48459e-06_r8,0.73297e-06_r8,0.81484e-06_r8,0.54137e-07_r8 /)
      kbo(:, 1,32, 2) = (/ &
        & 0.32280e-09_r8,0.30547e-06_r8,0.47083e-06_r8,0.53147e-06_r8,0.29353e-07_r8 /)
      kbo(:, 2,32, 2) = (/ &
        & 0.30356e-09_r8,0.33271e-06_r8,0.50770e-06_r8,0.57112e-06_r8,0.33078e-07_r8 /)
      kbo(:, 3,32, 2) = (/ &
        & 0.28647e-09_r8,0.35876e-06_r8,0.54339e-06_r8,0.60852e-06_r8,0.37211e-07_r8 /)
      kbo(:, 4,32, 2) = (/ &
        & 0.27120e-09_r8,0.38214e-06_r8,0.57781e-06_r8,0.64354e-06_r8,0.41295e-07_r8 /)
      kbo(:, 5,32, 2) = (/ &
        & 0.25746e-09_r8,0.40374e-06_r8,0.60990e-06_r8,0.67711e-06_r8,0.45362e-07_r8 /)
      kbo(:, 1,33, 2) = (/ &
        & 0.25997e-09_r8,0.25723e-06_r8,0.39505e-06_r8,0.44467e-06_r8,0.24754e-07_r8 /)
      kbo(:, 2,33, 2) = (/ &
        & 0.24471e-09_r8,0.27926e-06_r8,0.42469e-06_r8,0.47702e-06_r8,0.27907e-07_r8 /)
      kbo(:, 3,33, 2) = (/ &
        & 0.23113e-09_r8,0.30024e-06_r8,0.45384e-06_r8,0.50672e-06_r8,0.31344e-07_r8 /)
      kbo(:, 4,33, 2) = (/ &
        & 0.21898e-09_r8,0.31862e-06_r8,0.48142e-06_r8,0.53515e-06_r8,0.34590e-07_r8 /)
      kbo(:, 5,33, 2) = (/ &
        & 0.20803e-09_r8,0.33624e-06_r8,0.50721e-06_r8,0.56242e-06_r8,0.37957e-07_r8 /)
      kbo(:, 1,34, 2) = (/ &
        & 0.20987e-09_r8,0.21561e-06_r8,0.33035e-06_r8,0.37093e-06_r8,0.20801e-07_r8 /)
      kbo(:, 2,34, 2) = (/ &
        & 0.19771e-09_r8,0.23356e-06_r8,0.35433e-06_r8,0.39723e-06_r8,0.23443e-07_r8 /)
      kbo(:, 3,34, 2) = (/ &
        & 0.18688e-09_r8,0.25042e-06_r8,0.37804e-06_r8,0.42127e-06_r8,0.26271e-07_r8 /)
      kbo(:, 4,34, 2) = (/ &
        & 0.17716e-09_r8,0.26514e-06_r8,0.40029e-06_r8,0.44433e-06_r8,0.28867e-07_r8 /)
      kbo(:, 5,34, 2) = (/ &
        & 0.16840e-09_r8,0.27949e-06_r8,0.42102e-06_r8,0.46612e-06_r8,0.31620e-07_r8 /)
      kbo(:, 1,35, 2) = (/ &
        & 0.17046e-09_r8,0.17909e-06_r8,0.27397e-06_r8,0.30730e-06_r8,0.17283e-07_r8 /)
      kbo(:, 2,35, 2) = (/ &
        & 0.16066e-09_r8,0.19378e-06_r8,0.29367e-06_r8,0.32869e-06_r8,0.19456e-07_r8 /)
      kbo(:, 3,35, 2) = (/ &
        & 0.15191e-09_r8,0.20716e-06_r8,0.31287e-06_r8,0.34820e-06_r8,0.21759e-07_r8 /)
      kbo(:, 4,35, 2) = (/ &
        & 0.14407e-09_r8,0.21938e-06_r8,0.33090e-06_r8,0.36703e-06_r8,0.23854e-07_r8 /)
      kbo(:, 5,35, 2) = (/ &
        & 0.13699e-09_r8,0.23115e-06_r8,0.34779e-06_r8,0.38459e-06_r8,0.26128e-07_r8 /)
      kbo(:, 1,36, 2) = (/ &
        & 0.13938e-09_r8,0.14742e-06_r8,0.22535e-06_r8,0.25261e-06_r8,0.14145e-07_r8 /)
      kbo(:, 2,36, 2) = (/ &
        & 0.13137e-09_r8,0.15949e-06_r8,0.24155e-06_r8,0.27011e-06_r8,0.15917e-07_r8 /)
      kbo(:, 3,36, 2) = (/ &
        & 0.12423e-09_r8,0.17037e-06_r8,0.25721e-06_r8,0.28606e-06_r8,0.17809e-07_r8 /)
      kbo(:, 4,36, 2) = (/ &
        & 0.11782e-09_r8,0.18044e-06_r8,0.27200e-06_r8,0.30149e-06_r8,0.19530e-07_r8 /)
      kbo(:, 5,36, 2) = (/ &
        & 0.11204e-09_r8,0.19011e-06_r8,0.28582e-06_r8,0.31581e-06_r8,0.21391e-07_r8 /)
      kbo(:, 1,37, 2) = (/ &
        & 0.11503e-09_r8,0.11991e-06_r8,0.18339e-06_r8,0.20540e-06_r8,0.11398e-07_r8 /)
      kbo(:, 2,37, 2) = (/ &
        & 0.10837e-09_r8,0.12985e-06_r8,0.19670e-06_r8,0.21991e-06_r8,0.12829e-07_r8 /)
      kbo(:, 3,37, 2) = (/ &
        & 0.10244e-09_r8,0.13895e-06_r8,0.20964e-06_r8,0.23310e-06_r8,0.14370e-07_r8 /)
      kbo(:, 4,37, 2) = (/ &
        & 0.97122e-10_r8,0.14725e-06_r8,0.22183e-06_r8,0.24582e-06_r8,0.15790e-07_r8 /)
      kbo(:, 5,37, 2) = (/ &
        & 0.92325e-10_r8,0.15526e-06_r8,0.23327e-06_r8,0.25767e-06_r8,0.17308e-07_r8 /)
      kbo(:, 1,38, 2) = (/ &
        & 0.94990e-10_r8,0.97434e-07_r8,0.14912e-06_r8,0.16699e-06_r8,0.91745e-08_r8 /)
      kbo(:, 2,38, 2) = (/ &
        & 0.89449e-10_r8,0.10563e-06_r8,0.16007e-06_r8,0.17890e-06_r8,0.10330e-07_r8 /)
      kbo(:, 3,38, 2) = (/ &
        & 0.84516e-10_r8,0.11322e-06_r8,0.17071e-06_r8,0.18982e-06_r8,0.11585e-07_r8 /)
      kbo(:, 4,38, 2) = (/ &
        & 0.80096e-10_r8,0.12009e-06_r8,0.18084e-06_r8,0.20030e-06_r8,0.12759e-07_r8 /)
      kbo(:, 5,38, 2) = (/ &
        & 0.76113e-10_r8,0.12672e-06_r8,0.19028e-06_r8,0.21012e-06_r8,0.13992e-07_r8 /)
      kbo(:, 1,39, 2) = (/ &
        & 0.78444e-10_r8,0.79147e-07_r8,0.12122e-06_r8,0.13573e-06_r8,0.73846e-08_r8 /)
      kbo(:, 2,39, 2) = (/ &
        & 0.73832e-10_r8,0.85901e-07_r8,0.13022e-06_r8,0.14552e-06_r8,0.83180e-08_r8 /)
      kbo(:, 3,39, 2) = (/ &
        & 0.69729e-10_r8,0.92230e-07_r8,0.13899e-06_r8,0.15459e-06_r8,0.93374e-08_r8 /)
      kbo(:, 4,39, 2) = (/ &
        & 0.66056e-10_r8,0.97919e-07_r8,0.14737e-06_r8,0.16325e-06_r8,0.10307e-07_r8 /)
      kbo(:, 5,39, 2) = (/ &
        & 0.62749e-10_r8,0.10341e-06_r8,0.15518e-06_r8,0.17133e-06_r8,0.11312e-07_r8 /)
      kbo(:, 1,40, 2) = (/ &
        & 0.65207e-10_r8,0.63715e-07_r8,0.97755e-07_r8,0.10945e-06_r8,0.58831e-08_r8 /)
      kbo(:, 2,40, 2) = (/ &
        & 0.61319e-10_r8,0.69289e-07_r8,0.10524e-06_r8,0.11757e-06_r8,0.66237e-08_r8 /)
      kbo(:, 3,40, 2) = (/ &
        & 0.57866e-10_r8,0.74694e-07_r8,0.11245e-06_r8,0.12515e-06_r8,0.74455e-08_r8 /)
      kbo(:, 4,40, 2) = (/ &
        & 0.54779e-10_r8,0.79359e-07_r8,0.11941e-06_r8,0.13229e-06_r8,0.82595e-08_r8 /)
      kbo(:, 5,40, 2) = (/ &
        & 0.52003e-10_r8,0.83957e-07_r8,0.12593e-06_r8,0.13909e-06_r8,0.90698e-08_r8 /)
      kbo(:, 1,41, 2) = (/ &
        & 0.54263e-10_r8,0.51172e-07_r8,0.78714e-07_r8,0.88183e-07_r8,0.46740e-08_r8 /)
      kbo(:, 2,41, 2) = (/ &
        & 0.50978e-10_r8,0.55838e-07_r8,0.84939e-07_r8,0.94828e-07_r8,0.52655e-08_r8 /)
      kbo(:, 3,41, 2) = (/ &
        & 0.48066e-10_r8,0.60328e-07_r8,0.90859e-07_r8,0.10118e-06_r8,0.59273e-08_r8 /)
      kbo(:, 4,41, 2) = (/ &
        & 0.45467e-10_r8,0.64260e-07_r8,0.96667e-07_r8,0.10710e-06_r8,0.66279e-08_r8 /)
      kbo(:, 5,41, 2) = (/ &
        & 0.43134e-10_r8,0.68089e-07_r8,0.10208e-06_r8,0.11279e-06_r8,0.72560e-08_r8 /)
      kbo(:, 1,42, 2) = (/ &
        & 0.45170e-10_r8,0.41073e-07_r8,0.63333e-07_r8,0.71067e-07_r8,0.37185e-08_r8 /)
      kbo(:, 2,42, 2) = (/ &
        & 0.42393e-10_r8,0.44964e-07_r8,0.68507e-07_r8,0.76455e-07_r8,0.41864e-08_r8 /)
      kbo(:, 3,42, 2) = (/ &
        & 0.39936e-10_r8,0.48667e-07_r8,0.73382e-07_r8,0.81772e-07_r8,0.47157e-08_r8 /)
      kbo(:, 4,42, 2) = (/ &
        & 0.37747e-10_r8,0.51996e-07_r8,0.78220e-07_r8,0.86689e-07_r8,0.52834e-08_r8 /)
      kbo(:, 5,42, 2) = (/ &
        & 0.35784e-10_r8,0.55178e-07_r8,0.82739e-07_r8,0.91434e-07_r8,0.58040e-08_r8 /)
      kbo(:, 1,43, 2) = (/ &
        & 0.37754e-10_r8,0.32770e-07_r8,0.50662e-07_r8,0.56979e-07_r8,0.29405e-08_r8 /)
      kbo(:, 2,43, 2) = (/ &
        & 0.35387e-10_r8,0.35997e-07_r8,0.54993e-07_r8,0.61357e-07_r8,0.33066e-08_r8 /)
      kbo(:, 3,43, 2) = (/ &
        & 0.33299e-10_r8,0.39073e-07_r8,0.59036e-07_r8,0.65793e-07_r8,0.37265e-08_r8 /)
      kbo(:, 4,43, 2) = (/ &
        & 0.31442e-10_r8,0.41903e-07_r8,0.63014e-07_r8,0.69920e-07_r8,0.41848e-08_r8 /)
      kbo(:, 5,43, 2) = (/ &
        & 0.29781e-10_r8,0.44546e-07_r8,0.66822e-07_r8,0.73849e-07_r8,0.46204e-08_r8 /)
      kbo(:, 1,44, 2) = (/ &
        & 0.31623e-10_r8,0.26054e-07_r8,0.40405e-07_r8,0.45692e-07_r8,0.22918e-08_r8 /)
      kbo(:, 2,44, 2) = (/ &
        & 0.29599e-10_r8,0.28713e-07_r8,0.44010e-07_r8,0.49122e-07_r8,0.26053e-08_r8 /)
      kbo(:, 3,44, 2) = (/ &
        & 0.27817e-10_r8,0.31296e-07_r8,0.47391e-07_r8,0.52815e-07_r8,0.29353e-08_r8 /)
      kbo(:, 4,44, 2) = (/ &
        & 0.26236e-10_r8,0.33677e-07_r8,0.50655e-07_r8,0.56264e-07_r8,0.33023e-08_r8 /)
      kbo(:, 5,44, 2) = (/ &
        & 0.24825e-10_r8,0.35896e-07_r8,0.53863e-07_r8,0.59538e-07_r8,0.36730e-08_r8 /)
      kbo(:, 1,45, 2) = (/ &
        & 0.26502e-10_r8,0.20705e-07_r8,0.32152e-07_r8,0.36448e-07_r8,0.17841e-08_r8 /)
      kbo(:, 2,45, 2) = (/ &
        & 0.24768e-10_r8,0.22868e-07_r8,0.35185e-07_r8,0.39329e-07_r8,0.20515e-08_r8 /)
      kbo(:, 3,45, 2) = (/ &
        & 0.23247e-10_r8,0.25027e-07_r8,0.37999e-07_r8,0.42338e-07_r8,0.23118e-08_r8 /)
      kbo(:, 4,45, 2) = (/ &
        & 0.21900e-10_r8,0.27063e-07_r8,0.40694e-07_r8,0.45258e-07_r8,0.26048e-08_r8 /)
      kbo(:, 5,45, 2) = (/ &
        & 0.20701e-10_r8,0.28901e-07_r8,0.43361e-07_r8,0.47969e-07_r8,0.29174e-08_r8 /)
      kbo(:, 1,46, 2) = (/ &
        & 0.22258e-10_r8,0.16422e-07_r8,0.25480e-07_r8,0.28991e-07_r8,0.13830e-08_r8 /)
      kbo(:, 2,46, 2) = (/ &
        & 0.20767e-10_r8,0.18158e-07_r8,0.28033e-07_r8,0.31442e-07_r8,0.16144e-08_r8 /)
      kbo(:, 3,46, 2) = (/ &
        & 0.19462e-10_r8,0.19953e-07_r8,0.30402e-07_r8,0.33850e-07_r8,0.18162e-08_r8 /)
      kbo(:, 4,46, 2) = (/ &
        & 0.18312e-10_r8,0.21658e-07_r8,0.32639e-07_r8,0.36308e-07_r8,0.20475e-08_r8 /)
      kbo(:, 5,46, 2) = (/ &
        & 0.17289e-10_r8,0.23211e-07_r8,0.34839e-07_r8,0.38583e-07_r8,0.22994e-08_r8 /)
      kbo(:, 1,47, 2) = (/ &
        & 0.18764e-10_r8,0.12951e-07_r8,0.20072e-07_r8,0.22982e-07_r8,0.10645e-08_r8 /)
      kbo(:, 2,47, 2) = (/ &
        & 0.17473e-10_r8,0.14335e-07_r8,0.22214e-07_r8,0.25085e-07_r8,0.12479e-08_r8 /)
      kbo(:, 3,47, 2) = (/ &
        & 0.16347e-10_r8,0.15813e-07_r8,0.24205e-07_r8,0.26971e-07_r8,0.14207e-08_r8 /)
      kbo(:, 4,47, 2) = (/ &
        & 0.15357e-10_r8,0.17255e-07_r8,0.26075e-07_r8,0.29015e-07_r8,0.16008e-08_r8 /)
      kbo(:, 5,47, 2) = (/ &
        & 0.14480e-10_r8,0.18558e-07_r8,0.27885e-07_r8,0.30922e-07_r8,0.18018e-08_r8 /)
      kbo(:, 1,48, 2) = (/ &
        & 0.15833e-10_r8,0.10186e-07_r8,0.15782e-07_r8,0.18174e-07_r8,0.81718e-09_r8 /)
      kbo(:, 2,48, 2) = (/ &
        & 0.14713e-10_r8,0.11312e-07_r8,0.17555e-07_r8,0.19891e-07_r8,0.96098e-09_r8 /)
      kbo(:, 3,48, 2) = (/ &
        & 0.13740e-10_r8,0.12509e-07_r8,0.19248e-07_r8,0.21482e-07_r8,0.11112e-08_r8 /)
      kbo(:, 4,48, 2) = (/ &
        & 0.12887e-10_r8,0.13719e-07_r8,0.20811e-07_r8,0.23140e-07_r8,0.12515e-08_r8 /)
      kbo(:, 5,48, 2) = (/ &
        & 0.12134e-10_r8,0.14840e-07_r8,0.22313e-07_r8,0.24769e-07_r8,0.14105e-08_r8 /)
      kbo(:, 1,49, 2) = (/ &
        & 0.13372e-10_r8,0.80050e-08_r8,0.12403e-07_r8,0.14283e-07_r8,0.63117e-09_r8 /)
      kbo(:, 2,49, 2) = (/ &
        & 0.12398e-10_r8,0.89393e-08_r8,0.13840e-07_r8,0.15751e-07_r8,0.73907e-09_r8 /)
      kbo(:, 3,49, 2) = (/ &
        & 0.11556e-10_r8,0.98821e-08_r8,0.15261e-07_r8,0.17104e-07_r8,0.86645e-09_r8 /)
      kbo(:, 4,49, 2) = (/ &
        & 0.10821e-10_r8,0.10884e-07_r8,0.16582e-07_r8,0.18441e-07_r8,0.97829e-09_r8 /)
      kbo(:, 5,49, 2) = (/ &
        & 0.10174e-10_r8,0.11841e-07_r8,0.17828e-07_r8,0.19804e-07_r8,0.11034e-08_r8 /)
      kbo(:, 1,50, 2) = (/ &
        & 0.11282e-10_r8,0.62726e-08_r8,0.97478e-08_r8,0.11226e-07_r8,0.48398e-09_r8 /)
      kbo(:, 2,50, 2) = (/ &
        & 0.10437e-10_r8,0.70546e-08_r8,0.10932e-07_r8,0.12518e-07_r8,0.57051e-09_r8 /)
      kbo(:, 3,50, 2) = (/ &
        & 0.97101e-11_r8,0.78193e-08_r8,0.12114e-07_r8,0.13671e-07_r8,0.66997e-09_r8 /)
      kbo(:, 4,50, 2) = (/ &
        & 0.90772e-11_r8,0.86379e-08_r8,0.13218e-07_r8,0.14712e-07_r8,0.76625e-09_r8 /)
      kbo(:, 5,50, 2) = (/ &
        & 0.85216e-11_r8,0.94405e-08_r8,0.14258e-07_r8,0.15844e-07_r8,0.86488e-09_r8 /)
      kbo(:, 1,51, 2) = (/ &
        & 0.95179e-11_r8,0.49251e-08_r8,0.76356e-08_r8,0.87761e-08_r8,0.37213e-09_r8 /)
      kbo(:, 2,51, 2) = (/ &
        & 0.87856e-11_r8,0.55681e-08_r8,0.86220e-08_r8,0.99159e-08_r8,0.44074e-09_r8 /)
      kbo(:, 3,51, 2) = (/ &
        & 0.81576e-11_r8,0.61930e-08_r8,0.95989e-08_r8,0.10865e-07_r8,0.51843e-09_r8 /)
      kbo(:, 4,51, 2) = (/ &
        & 0.76131e-11_r8,0.68518e-08_r8,0.10539e-07_r8,0.11746e-07_r8,0.60210e-09_r8 /)
      kbo(:, 5,51, 2) = (/ &
        & 0.71366e-11_r8,0.75206e-08_r8,0.11403e-07_r8,0.12659e-07_r8,0.67841e-09_r8 /)
      kbo(:, 1,52, 2) = (/ &
        & 0.80368e-11_r8,0.38608e-08_r8,0.60010e-08_r8,0.68441e-08_r8,0.28848e-09_r8 /)
      kbo(:, 2,52, 2) = (/ &
        & 0.74007e-11_r8,0.43903e-08_r8,0.67974e-08_r8,0.78127e-08_r8,0.34245e-09_r8 /)
      kbo(:, 3,52, 2) = (/ &
        & 0.68577e-11_r8,0.49086e-08_r8,0.75959e-08_r8,0.86279e-08_r8,0.40106e-09_r8 /)
      kbo(:, 4,52, 2) = (/ &
        & 0.63886e-11_r8,0.54297e-08_r8,0.83801e-08_r8,0.93778e-08_r8,0.47058e-09_r8 /)
      kbo(:, 5,52, 2) = (/ &
        & 0.59795e-11_r8,0.59829e-08_r8,0.91103e-08_r8,0.10111e-07_r8,0.53218e-09_r8 /)
      kbo(:, 1,53, 2) = (/ &
        & 0.67932e-11_r8,0.30102e-08_r8,0.47269e-08_r8,0.53395e-08_r8,0.22432e-09_r8 /)
      kbo(:, 2,53, 2) = (/ &
        & 0.62397e-11_r8,0.34450e-08_r8,0.53458e-08_r8,0.61449e-08_r8,0.26282e-09_r8 /)
      kbo(:, 3,53, 2) = (/ &
        & 0.57693e-11_r8,0.38768e-08_r8,0.60006e-08_r8,0.68613e-08_r8,0.31020e-09_r8 /)
      kbo(:, 4,53, 2) = (/ &
        & 0.53647e-11_r8,0.43002e-08_r8,0.66533e-08_r8,0.74990e-08_r8,0.36446e-09_r8 /)
      kbo(:, 5,53, 2) = (/ &
        & 0.50129e-11_r8,0.47527e-08_r8,0.72638e-08_r8,0.80717e-08_r8,0.41759e-09_r8 /)
      kbo(:, 1,54, 2) = (/ &
        & 0.57320e-11_r8,0.23582e-08_r8,0.36837e-08_r8,0.41317e-08_r8,0.17477e-09_r8 /)
      kbo(:, 2,54, 2) = (/ &
        & 0.52518e-11_r8,0.27163e-08_r8,0.42048e-08_r8,0.48208e-08_r8,0.20321e-09_r8 /)
      kbo(:, 3,54, 2) = (/ &
        & 0.48457e-11_r8,0.30678e-08_r8,0.47472e-08_r8,0.54472e-08_r8,0.24081e-09_r8 /)
      kbo(:, 4,54, 2) = (/ &
        & 0.44978e-11_r8,0.34148e-08_r8,0.52851e-08_r8,0.59735e-08_r8,0.28345e-09_r8 /)
      kbo(:, 5,54, 2) = (/ &
        & 0.41963e-11_r8,0.37804e-08_r8,0.58001e-08_r8,0.64570e-08_r8,0.32923e-09_r8 /)
      kbo(:, 1,55, 2) = (/ &
        & 0.48347e-11_r8,0.18534e-08_r8,0.28539e-08_r8,0.31828e-08_r8,0.13492e-09_r8 /)
      kbo(:, 2,55, 2) = (/ &
        & 0.44186e-11_r8,0.21392e-08_r8,0.33190e-08_r8,0.37817e-08_r8,0.15848e-09_r8 /)
      kbo(:, 3,55, 2) = (/ &
        & 0.40683e-11_r8,0.24320e-08_r8,0.37592e-08_r8,0.43156e-08_r8,0.18835e-09_r8 /)
      kbo(:, 4,55, 2) = (/ &
        & 0.37693e-11_r8,0.27150e-08_r8,0.41999e-08_r8,0.47625e-08_r8,0.22076e-09_r8 /)
      kbo(:, 5,55, 2) = (/ &
        & 0.35111e-11_r8,0.30082e-08_r8,0.46345e-08_r8,0.51736e-08_r8,0.25916e-09_r8 /)
      kbo(:, 1,56, 2) = (/ &
        & 0.40813e-11_r8,0.14543e-08_r8,0.22038e-08_r8,0.24488e-08_r8,0.10328e-09_r8 /)
      kbo(:, 2,56, 2) = (/ &
        & 0.37201e-11_r8,0.16813e-08_r8,0.26371e-08_r8,0.29640e-08_r8,0.12446e-09_r8 /)
      kbo(:, 3,56, 2) = (/ &
        & 0.34175e-11_r8,0.19191e-08_r8,0.29747e-08_r8,0.34115e-08_r8,0.14604e-09_r8 /)
      kbo(:, 4,56, 2) = (/ &
        & 0.31604e-11_r8,0.21575e-08_r8,0.33348e-08_r8,0.38018e-08_r8,0.17202e-09_r8 /)
      kbo(:, 5,56, 2) = (/ &
        & 0.29391e-11_r8,0.23932e-08_r8,0.36930e-08_r8,0.41472e-08_r8,0.20235e-09_r8 /)
      kbo(:, 1,57, 2) = (/ &
        & 0.34486e-11_r8,0.11480e-08_r8,0.17032e-08_r8,0.18771e-08_r8,0.78787e-10_r8 /)
      kbo(:, 2,57, 2) = (/ &
        & 0.31345e-11_r8,0.13189e-08_r8,0.20615e-08_r8,0.23121e-08_r8,0.96832e-10_r8 /)
      kbo(:, 3,57, 2) = (/ &
        & 0.28728e-11_r8,0.15144e-08_r8,0.23440e-08_r8,0.26863e-08_r8,0.11317e-09_r8 /)
      kbo(:, 4,57, 2) = (/ &
        & 0.26513e-11_r8,0.17102e-08_r8,0.26436e-08_r8,0.30246e-08_r8,0.13393e-09_r8 /)
      kbo(:, 5,57, 2) = (/ &
        & 0.24615e-11_r8,0.19022e-08_r8,0.29394e-08_r8,0.33135e-08_r8,0.15772e-09_r8 /)
      kbo(:, 1,58, 2) = (/ &
        & 0.29119e-11_r8,0.89500e-09_r8,0.13020e-08_r8,0.14383e-08_r8,0.60253e-10_r8 /)
      kbo(:, 2,58, 2) = (/ &
        & 0.26392e-11_r8,0.10369e-08_r8,0.16036e-08_r8,0.17891e-08_r8,0.75765e-10_r8 /)
      kbo(:, 3,58, 2) = (/ &
        & 0.24132e-11_r8,0.11975e-08_r8,0.18523e-08_r8,0.21114e-08_r8,0.88260e-10_r8 /)
      kbo(:, 4,58, 2) = (/ &
        & 0.22227e-11_r8,0.13570e-08_r8,0.20959e-08_r8,0.24045e-08_r8,0.10478e-09_r8 /)
      kbo(:, 5,58, 2) = (/ &
        & 0.20601e-11_r8,0.15139e-08_r8,0.23406e-08_r8,0.26456e-08_r8,0.12331e-09_r8 /)
      kbo(:, 1,59, 2) = (/ &
        & 0.24143e-11_r8,0.71851e-09_r8,0.10362e-08_r8,0.11516e-08_r8,0.48086e-10_r8 /)
      kbo(:, 2,59, 2) = (/ &
        & 0.21857e-11_r8,0.83732e-09_r8,0.12892e-08_r8,0.14335e-08_r8,0.60630e-10_r8 /)
      kbo(:, 3,59, 2) = (/ &
        & 0.19965e-11_r8,0.96815e-09_r8,0.14990e-08_r8,0.17039e-08_r8,0.71208e-10_r8 /)
      kbo(:, 4,59, 2) = (/ &
        & 0.18374e-11_r8,0.10982e-08_r8,0.16973e-08_r8,0.19455e-08_r8,0.84514e-10_r8 /)
      kbo(:, 5,59, 2) = (/ &
        & 0.17017e-11_r8,0.12277e-08_r8,0.18981e-08_r8,0.21472e-08_r8,0.99289e-10_r8 /)
      kbo(:, 1,13, 3) = (/ &
        & 0.69497e-07_r8,0.55900e-04_r8,0.77634e-04_r8,0.83300e-04_r8,0.14419e-04_r8 /)
      kbo(:, 2,13, 3) = (/ &
        & 0.64923e-07_r8,0.61779e-04_r8,0.85238e-04_r8,0.90458e-04_r8,0.15996e-04_r8 /)
      kbo(:, 3,13, 3) = (/ &
        & 0.60920e-07_r8,0.67532e-04_r8,0.92811e-04_r8,0.97588e-04_r8,0.17622e-04_r8 /)
      kbo(:, 4,13, 3) = (/ &
        & 0.57379e-07_r8,0.72876e-04_r8,0.10040e-03_r8,0.10455e-03_r8,0.19144e-04_r8 /)
      kbo(:, 5,13, 3) = (/ &
        & 0.54220e-07_r8,0.77699e-04_r8,0.10784e-03_r8,0.11139e-03_r8,0.20671e-04_r8 /)
      kbo(:, 1,14, 3) = (/ &
        & 0.56538e-07_r8,0.46627e-04_r8,0.64678e-04_r8,0.69399e-04_r8,0.12086e-04_r8 /)
      kbo(:, 2,14, 3) = (/ &
        & 0.52839e-07_r8,0.51536e-04_r8,0.71080e-04_r8,0.75292e-04_r8,0.13414e-04_r8 /)
      kbo(:, 3,14, 3) = (/ &
        & 0.49600e-07_r8,0.56334e-04_r8,0.77384e-04_r8,0.81277e-04_r8,0.14732e-04_r8 /)
      kbo(:, 4,14, 3) = (/ &
        & 0.46731e-07_r8,0.60751e-04_r8,0.83753e-04_r8,0.87067e-04_r8,0.15973e-04_r8 /)
      kbo(:, 5,14, 3) = (/ &
        & 0.44171e-07_r8,0.64792e-04_r8,0.89963e-04_r8,0.92617e-04_r8,0.17214e-04_r8 /)
      kbo(:, 1,15, 3) = (/ &
        & 0.45963e-07_r8,0.38920e-04_r8,0.53921e-04_r8,0.57824e-04_r8,0.10089e-04_r8 /)
      kbo(:, 2,15, 3) = (/ &
        & 0.42976e-07_r8,0.42987e-04_r8,0.59286e-04_r8,0.62615e-04_r8,0.11238e-04_r8 /)
      kbo(:, 3,15, 3) = (/ &
        & 0.40358e-07_r8,0.47014e-04_r8,0.64557e-04_r8,0.67658e-04_r8,0.12293e-04_r8 /)
      kbo(:, 4,15, 3) = (/ &
        & 0.38037e-07_r8,0.50641e-04_r8,0.69879e-04_r8,0.72487e-04_r8,0.13317e-04_r8 /)
      kbo(:, 5,15, 3) = (/ &
        & 0.35964e-07_r8,0.54003e-04_r8,0.75064e-04_r8,0.77083e-04_r8,0.14321e-04_r8 /)
      kbo(:, 1,16, 3) = (/ &
        & 0.37354e-07_r8,0.32479e-04_r8,0.44953e-04_r8,0.48146e-04_r8,0.84079e-05_r8 /)
      kbo(:, 2,16, 3) = (/ &
        & 0.34944e-07_r8,0.35873e-04_r8,0.49454e-04_r8,0.52120e-04_r8,0.93405e-05_r8 /)
      kbo(:, 3,16, 3) = (/ &
        & 0.32829e-07_r8,0.39220e-04_r8,0.53861e-04_r8,0.56293e-04_r8,0.10209e-04_r8 /)
      kbo(:, 4,16, 3) = (/ &
        & 0.30952e-07_r8,0.42155e-04_r8,0.58309e-04_r8,0.60268e-04_r8,0.11080e-04_r8 /)
      kbo(:, 5,16, 3) = (/ &
        & 0.29274e-07_r8,0.45014e-04_r8,0.62610e-04_r8,0.64184e-04_r8,0.11887e-04_r8 /)
      kbo(:, 1,17, 3) = (/ &
        & 0.30364e-07_r8,0.27086e-04_r8,0.37451e-04_r8,0.39995e-04_r8,0.70049e-05_r8 /)
      kbo(:, 2,17, 3) = (/ &
        & 0.28420e-07_r8,0.29919e-04_r8,0.41194e-04_r8,0.43367e-04_r8,0.77736e-05_r8 /)
      kbo(:, 3,17, 3) = (/ &
        & 0.26710e-07_r8,0.32650e-04_r8,0.44902e-04_r8,0.46817e-04_r8,0.84838e-05_r8 /)
      kbo(:, 4,17, 3) = (/ &
        & 0.25192e-07_r8,0.35098e-04_r8,0.48605e-04_r8,0.50103e-04_r8,0.92038e-05_r8 /)
      kbo(:, 5,17, 3) = (/ &
        & 0.23833e-07_r8,0.37507e-04_r8,0.52188e-04_r8,0.53413e-04_r8,0.98607e-05_r8 /)
      kbo(:, 1,18, 3) = (/ &
        & 0.24687e-07_r8,0.22581e-04_r8,0.31211e-04_r8,0.33220e-04_r8,0.58361e-05_r8 /)
      kbo(:, 2,18, 3) = (/ &
        & 0.23116e-07_r8,0.24940e-04_r8,0.34308e-04_r8,0.36078e-04_r8,0.64640e-05_r8 /)
      kbo(:, 3,18, 3) = (/ &
        & 0.21734e-07_r8,0.27181e-04_r8,0.37414e-04_r8,0.38933e-04_r8,0.70344e-05_r8 /)
      kbo(:, 4,18, 3) = (/ &
        & 0.20506e-07_r8,0.29216e-04_r8,0.40517e-04_r8,0.41653e-04_r8,0.76276e-05_r8 /)
      kbo(:, 5,18, 3) = (/ &
        & 0.19406e-07_r8,0.31237e-04_r8,0.43490e-04_r8,0.44397e-04_r8,0.81753e-05_r8 /)
      kbo(:, 1,19, 3) = (/ &
        & 0.20074e-07_r8,0.18818e-04_r8,0.25999e-04_r8,0.27597e-04_r8,0.48662e-05_r8 /)
      kbo(:, 2,19, 3) = (/ &
        & 0.18805e-07_r8,0.20784e-04_r8,0.28562e-04_r8,0.29993e-04_r8,0.53723e-05_r8 /)
      kbo(:, 3,19, 3) = (/ &
        & 0.17688e-07_r8,0.22626e-04_r8,0.31151e-04_r8,0.32363e-04_r8,0.58377e-05_r8 /)
      kbo(:, 4,19, 3) = (/ &
        & 0.16693e-07_r8,0.24300e-04_r8,0.33760e-04_r8,0.34629e-04_r8,0.63177e-05_r8 /)
      kbo(:, 5,19, 3) = (/ &
        & 0.15802e-07_r8,0.25985e-04_r8,0.36226e-04_r8,0.36903e-04_r8,0.67742e-05_r8 /)
      kbo(:, 1,20, 3) = (/ &
        & 0.16306e-07_r8,0.15717e-04_r8,0.21686e-04_r8,0.22959e-04_r8,0.40680e-05_r8 /)
      kbo(:, 2,20, 3) = (/ &
        & 0.15283e-07_r8,0.17355e-04_r8,0.23826e-04_r8,0.24969e-04_r8,0.44706e-05_r8 /)
      kbo(:, 3,20, 3) = (/ &
        & 0.14381e-07_r8,0.18856e-04_r8,0.25992e-04_r8,0.26912e-04_r8,0.48550e-05_r8 /)
      kbo(:, 4,20, 3) = (/ &
        & 0.13578e-07_r8,0.20265e-04_r8,0.28162e-04_r8,0.28817e-04_r8,0.52355e-05_r8 /)
      kbo(:, 5,20, 3) = (/ &
        & 0.12857e-07_r8,0.21638e-04_r8,0.30215e-04_r8,0.30707e-04_r8,0.56224e-05_r8 /)
      kbo(:, 1,21, 3) = (/ &
        & 0.13245e-07_r8,0.13128e-04_r8,0.18091e-04_r8,0.19107e-04_r8,0.33880e-05_r8 /)
      kbo(:, 2,21, 3) = (/ &
        & 0.12420e-07_r8,0.14495e-04_r8,0.19887e-04_r8,0.20794e-04_r8,0.37144e-05_r8 /)
      kbo(:, 3,21, 3) = (/ &
        & 0.11692e-07_r8,0.15704e-04_r8,0.21703e-04_r8,0.22397e-04_r8,0.40415e-05_r8 /)
      kbo(:, 4,21, 3) = (/ &
        & 0.11043e-07_r8,0.16904e-04_r8,0.23489e-04_r8,0.23984e-04_r8,0.43455e-05_r8 /)
      kbo(:, 5,21, 3) = (/ &
        & 0.10460e-07_r8,0.18037e-04_r8,0.25197e-04_r8,0.25558e-04_r8,0.46662e-05_r8 /)
      kbo(:, 1,22, 3) = (/ &
        & 0.10711e-07_r8,0.11044e-04_r8,0.15199e-04_r8,0.16008e-04_r8,0.28409e-05_r8 /)
      kbo(:, 2,22, 3) = (/ &
        & 0.10052e-07_r8,0.12165e-04_r8,0.16699e-04_r8,0.17419e-04_r8,0.31041e-05_r8 /)
      kbo(:, 3,22, 3) = (/ &
        & 0.94690e-08_r8,0.13158e-04_r8,0.18224e-04_r8,0.18733e-04_r8,0.33768e-05_r8 /)
      kbo(:, 4,22, 3) = (/ &
        & 0.89484e-08_r8,0.14166e-04_r8,0.19691e-04_r8,0.20050e-04_r8,0.36237e-05_r8 /)
      kbo(:, 5,22, 3) = (/ &
        & 0.84804e-08_r8,0.15085e-04_r8,0.21105e-04_r8,0.21356e-04_r8,0.38876e-05_r8 /)
      kbo(:, 1,23, 3) = (/ &
        & 0.86606e-08_r8,0.93002e-05_r8,0.12775e-04_r8,0.13420e-04_r8,0.23815e-05_r8 /)
      kbo(:, 2,23, 3) = (/ &
        & 0.81340e-08_r8,0.10210e-04_r8,0.14034e-04_r8,0.14552e-04_r8,0.25955e-05_r8 /)
      kbo(:, 3,23, 3) = (/ &
        & 0.76671e-08_r8,0.11035e-04_r8,0.15302e-04_r8,0.15657e-04_r8,0.28150e-05_r8 /)
      kbo(:, 4,23, 3) = (/ &
        & 0.72497e-08_r8,0.11863e-04_r8,0.16513e-04_r8,0.16770e-04_r8,0.30198e-05_r8 /)
      kbo(:, 5,23, 3) = (/ &
        & 0.68739e-08_r8,0.12616e-04_r8,0.17664e-04_r8,0.17848e-04_r8,0.32387e-05_r8 /)
      kbo(:, 1,24, 3) = (/ &
        & 0.69995e-08_r8,0.78392e-05_r8,0.10754e-04_r8,0.11250e-04_r8,0.19986e-05_r8 /)
      kbo(:, 2,24, 3) = (/ &
        & 0.65790e-08_r8,0.85674e-05_r8,0.11806e-04_r8,0.12186e-04_r8,0.21738e-05_r8 /)
      kbo(:, 3,24, 3) = (/ &
        & 0.62055e-08_r8,0.92664e-05_r8,0.12850e-04_r8,0.13103e-04_r8,0.23469e-05_r8 /)
      kbo(:, 4,24, 3) = (/ &
        & 0.58710e-08_r8,0.99376e-05_r8,0.13854e-04_r8,0.14027e-04_r8,0.25195e-05_r8 /)
      kbo(:, 5,24, 3) = (/ &
        & 0.55696e-08_r8,0.10527e-04_r8,0.14795e-04_r8,0.14917e-04_r8,0.26988e-05_r8 /)
      kbo(:, 1,25, 3) = (/ &
        & 0.56538e-08_r8,0.66118e-05_r8,0.90610e-05_r8,0.94422e-05_r8,0.16753e-05_r8 /)
      kbo(:, 2,25, 3) = (/ &
        & 0.53184e-08_r8,0.71986e-05_r8,0.99389e-05_r8,0.10209e-04_r8,0.18223e-05_r8 /)
      kbo(:, 3,25, 3) = (/ &
        & 0.50199e-08_r8,0.77863e-05_r8,0.10800e-04_r8,0.10981e-04_r8,0.19590e-05_r8 /)
      kbo(:, 4,25, 3) = (/ &
        & 0.47522e-08_r8,0.83415e-05_r8,0.11626e-04_r8,0.11737e-04_r8,0.21020e-05_r8 /)
      kbo(:, 5,25, 3) = (/ &
        & 0.45105e-08_r8,0.88017e-05_r8,0.12373e-04_r8,0.12468e-04_r8,0.22498e-05_r8 /)
      kbo(:, 1,26, 3) = (/ &
        & 0.45620e-08_r8,0.55749e-05_r8,0.76463e-05_r8,0.79285e-05_r8,0.14032e-05_r8 /)
      kbo(:, 2,26, 3) = (/ &
        & 0.42950e-08_r8,0.60590e-05_r8,0.83822e-05_r8,0.85652e-05_r8,0.15255e-05_r8 /)
      kbo(:, 3,26, 3) = (/ &
        & 0.40569e-08_r8,0.65510e-05_r8,0.90888e-05_r8,0.92116e-05_r8,0.16373e-05_r8 /)
      kbo(:, 4,26, 3) = (/ &
        & 0.38429e-08_r8,0.69918e-05_r8,0.97604e-05_r8,0.98329e-05_r8,0.17561e-05_r8 /)
      kbo(:, 5,26, 3) = (/ &
        & 0.36495e-08_r8,0.73566e-05_r8,0.10367e-04_r8,0.10429e-04_r8,0.18769e-05_r8 /)
      kbo(:, 1,27, 3) = (/ &
        & 0.36809e-08_r8,0.46967e-05_r8,0.64580e-05_r8,0.66649e-05_r8,0.11786e-05_r8 /)
      kbo(:, 2,27, 3) = (/ &
        & 0.34683e-08_r8,0.51072e-05_r8,0.70661e-05_r8,0.71902e-05_r8,0.12759e-05_r8 /)
      kbo(:, 3,27, 3) = (/ &
        & 0.32784e-08_r8,0.55053e-05_r8,0.76470e-05_r8,0.77250e-05_r8,0.13691e-05_r8 /)
      kbo(:, 4,27, 3) = (/ &
        & 0.31074e-08_r8,0.58474e-05_r8,0.81898e-05_r8,0.82340e-05_r8,0.14666e-05_r8 /)
      kbo(:, 5,27, 3) = (/ &
        & 0.29526e-08_r8,0.61493e-05_r8,0.86815e-05_r8,0.87199e-05_r8,0.15650e-05_r8 /)
      kbo(:, 1,28, 3) = (/ &
        & 0.29701e-08_r8,0.39582e-05_r8,0.54573e-05_r8,0.55959e-05_r8,0.99037e-06_r8 /)
      kbo(:, 2,28, 3) = (/ &
        & 0.28008e-08_r8,0.43048e-05_r8,0.59546e-05_r8,0.60406e-05_r8,0.10659e-05_r8 /)
      kbo(:, 3,28, 3) = (/ &
        & 0.26493e-08_r8,0.46277e-05_r8,0.64286e-05_r8,0.64745e-05_r8,0.11442e-05_r8 /)
      kbo(:, 4,28, 3) = (/ &
        & 0.25127e-08_r8,0.48940e-05_r8,0.68612e-05_r8,0.68918e-05_r8,0.12250e-05_r8 /)
      kbo(:, 5,28, 3) = (/ &
        & 0.23888e-08_r8,0.51428e-05_r8,0.72654e-05_r8,0.72865e-05_r8,0.13046e-05_r8 /)
      kbo(:, 1,29, 3) = (/ &
        & 0.23958e-08_r8,0.33409e-05_r8,0.46115e-05_r8,0.47054e-05_r8,0.83021e-06_r8 /)
      kbo(:, 2,29, 3) = (/ &
        & 0.22611e-08_r8,0.36267e-05_r8,0.50192e-05_r8,0.50754e-05_r8,0.89157e-06_r8 /)
      kbo(:, 3,29, 3) = (/ &
        & 0.21402e-08_r8,0.38805e-05_r8,0.54053e-05_r8,0.54291e-05_r8,0.95663e-06_r8 /)
      kbo(:, 4,29, 3) = (/ &
        & 0.20311e-08_r8,0.40929e-05_r8,0.57529e-05_r8,0.57685e-05_r8,0.10232e-05_r8 /)
      kbo(:, 5,29, 3) = (/ &
        & 0.19320e-08_r8,0.43014e-05_r8,0.60684e-05_r8,0.60868e-05_r8,0.10874e-05_r8 /)
      kbo(:, 1,30, 3) = (/ &
        & 0.19328e-08_r8,0.28217e-05_r8,0.38955e-05_r8,0.39562e-05_r8,0.69464e-06_r8 /)
      kbo(:, 2,30, 3) = (/ &
        & 0.18255e-08_r8,0.30515e-05_r8,0.42293e-05_r8,0.42605e-05_r8,0.74588e-06_r8 /)
      kbo(:, 3,30, 3) = (/ &
        & 0.17291e-08_r8,0.32496e-05_r8,0.45390e-05_r8,0.45501e-05_r8,0.79957e-06_r8 /)
      kbo(:, 4,30, 3) = (/ &
        & 0.16419e-08_r8,0.34235e-05_r8,0.48191e-05_r8,0.48249e-05_r8,0.85373e-06_r8 /)
      kbo(:, 5,30, 3) = (/ &
        & 0.15626e-08_r8,0.35992e-05_r8,0.50632e-05_r8,0.50805e-05_r8,0.90582e-06_r8 /)
      kbo(:, 1,31, 3) = (/ &
        & 0.15590e-08_r8,0.23841e-05_r8,0.32890e-05_r8,0.33282e-05_r8,0.58108e-06_r8 /)
      kbo(:, 2,31, 3) = (/ &
        & 0.14736e-08_r8,0.25683e-05_r8,0.35605e-05_r8,0.35756e-05_r8,0.62401e-06_r8 /)
      kbo(:, 3,31, 3) = (/ &
        & 0.13967e-08_r8,0.27223e-05_r8,0.38055e-05_r8,0.38110e-05_r8,0.66862e-06_r8 /)
      kbo(:, 4,31, 3) = (/ &
        & 0.13271e-08_r8,0.28652e-05_r8,0.40295e-05_r8,0.40331e-05_r8,0.71216e-06_r8 /)
      kbo(:, 5,31, 3) = (/ &
        & 0.12637e-08_r8,0.30069e-05_r8,0.42257e-05_r8,0.42393e-05_r8,0.75527e-06_r8 /)
      kbo(:, 1,32, 3) = (/ &
        & 0.12575e-08_r8,0.20099e-05_r8,0.27764e-05_r8,0.27988e-05_r8,0.48614e-06_r8 /)
      kbo(:, 2,32, 3) = (/ &
        & 0.11895e-08_r8,0.21551e-05_r8,0.29961e-05_r8,0.29996e-05_r8,0.52199e-06_r8 /)
      kbo(:, 3,32, 3) = (/ &
        & 0.11282e-08_r8,0.22771e-05_r8,0.31901e-05_r8,0.31897e-05_r8,0.55867e-06_r8 /)
      kbo(:, 4,32, 3) = (/ &
        & 0.10726e-08_r8,0.23969e-05_r8,0.33657e-05_r8,0.33696e-05_r8,0.59410e-06_r8 /)
      kbo(:, 5,32, 3) = (/ &
        & 0.10218e-08_r8,0.25076e-05_r8,0.35232e-05_r8,0.35366e-05_r8,0.62965e-06_r8 /)
      kbo(:, 1,33, 3) = (/ &
        & 0.10144e-08_r8,0.16940e-05_r8,0.23421e-05_r8,0.23519e-05_r8,0.40701e-06_r8 /)
      kbo(:, 2,33, 3) = (/ &
        & 0.96024e-09_r8,0.18066e-05_r8,0.25146e-05_r8,0.25148e-05_r8,0.43657e-06_r8 /)
      kbo(:, 3,33, 3) = (/ &
        & 0.91134e-09_r8,0.19053e-05_r8,0.26738e-05_r8,0.26690e-05_r8,0.46656e-06_r8 /)
      kbo(:, 4,33, 3) = (/ &
        & 0.86689e-09_r8,0.20038e-05_r8,0.28104e-05_r8,0.28139e-05_r8,0.49516e-06_r8 /)
      kbo(:, 5,33, 3) = (/ &
        & 0.82630e-09_r8,0.20860e-05_r8,0.29294e-05_r8,0.29485e-05_r8,0.52462e-06_r8 /)
      kbo(:, 1,34, 3) = (/ &
        & 0.82000e-09_r8,0.14231e-05_r8,0.19661e-05_r8,0.19700e-05_r8,0.33996e-06_r8 /)
      kbo(:, 2,34, 3) = (/ &
        & 0.77672e-09_r8,0.15105e-05_r8,0.21047e-05_r8,0.21018e-05_r8,0.36435e-06_r8 /)
      kbo(:, 3,34, 3) = (/ &
        & 0.73757e-09_r8,0.15908e-05_r8,0.22307e-05_r8,0.22272e-05_r8,0.38851e-06_r8 /)
      kbo(:, 4,34, 3) = (/ &
        & 0.70193e-09_r8,0.16706e-05_r8,0.23421e-05_r8,0.23448e-05_r8,0.41219e-06_r8 /)
      kbo(:, 5,34, 3) = (/ &
        & 0.66936e-09_r8,0.17330e-05_r8,0.24342e-05_r8,0.24538e-05_r8,0.43607e-06_r8 /)
      kbo(:, 1,35, 3) = (/ &
        & 0.66652e-09_r8,0.11842e-05_r8,0.16383e-05_r8,0.16382e-05_r8,0.28183e-06_r8 /)
      kbo(:, 2,35, 3) = (/ &
        & 0.63156e-09_r8,0.12541e-05_r8,0.17499e-05_r8,0.17457e-05_r8,0.30195e-06_r8 /)
      kbo(:, 3,35, 3) = (/ &
        & 0.59990e-09_r8,0.13209e-05_r8,0.18504e-05_r8,0.18484e-05_r8,0.32174e-06_r8 /)
      kbo(:, 4,35, 3) = (/ &
        & 0.57107e-09_r8,0.13850e-05_r8,0.19418e-05_r8,0.19438e-05_r8,0.34124e-06_r8 /)
      kbo(:, 5,35, 3) = (/ &
        & 0.54470e-09_r8,0.14348e-05_r8,0.20135e-05_r8,0.20335e-05_r8,0.36050e-06_r8 /)
      kbo(:, 1,36, 3) = (/ &
        & 0.54506e-09_r8,0.97870e-06_r8,0.13541e-05_r8,0.13520e-05_r8,0.23190e-06_r8 /)
      kbo(:, 2,36, 3) = (/ &
        & 0.51650e-09_r8,0.10354e-05_r8,0.14455e-05_r8,0.14404e-05_r8,0.24845e-06_r8 /)
      kbo(:, 3,36, 3) = (/ &
        & 0.49063e-09_r8,0.10910e-05_r8,0.15270e-05_r8,0.15247e-05_r8,0.26464e-06_r8 /)
      kbo(:, 4,36, 3) = (/ &
        & 0.46707e-09_r8,0.11427e-05_r8,0.16012e-05_r8,0.16033e-05_r8,0.28072e-06_r8 /)
      kbo(:, 5,36, 3) = (/ &
        & 0.44553e-09_r8,0.11833e-05_r8,0.16604e-05_r8,0.16774e-05_r8,0.29643e-06_r8 /)
      kbo(:, 1,37, 3) = (/ &
        & 0.44949e-09_r8,0.80104e-06_r8,0.11066e-05_r8,0.11045e-05_r8,0.18888e-06_r8 /)
      kbo(:, 2,37, 3) = (/ &
        & 0.42579e-09_r8,0.84810e-06_r8,0.11826e-05_r8,0.11777e-05_r8,0.20242e-06_r8 /)
      kbo(:, 3,37, 3) = (/ &
        & 0.40435e-09_r8,0.89404e-06_r8,0.12504e-05_r8,0.12477e-05_r8,0.21578e-06_r8 /)
      kbo(:, 4,37, 3) = (/ &
        & 0.38483e-09_r8,0.93737e-06_r8,0.13124e-05_r8,0.13129e-05_r8,0.22892e-06_r8 /)
      kbo(:, 5,37, 3) = (/ &
        & 0.36699e-09_r8,0.97118e-06_r8,0.13617e-05_r8,0.13744e-05_r8,0.24190e-06_r8 /)
      kbo(:, 1,38, 3) = (/ &
        & 0.37088e-09_r8,0.65468e-06_r8,0.90347e-06_r8,0.90140e-06_r8,0.15371e-06_r8 /)
      kbo(:, 2,38, 3) = (/ &
        & 0.35120e-09_r8,0.69421e-06_r8,0.96676e-06_r8,0.96222e-06_r8,0.16484e-06_r8 /)
      kbo(:, 3,38, 3) = (/ &
        & 0.33340e-09_r8,0.73211e-06_r8,0.10233e-05_r8,0.10203e-05_r8,0.17578e-06_r8 /)
      kbo(:, 4,38, 3) = (/ &
        & 0.31721e-09_r8,0.76838e-06_r8,0.10750e-05_r8,0.10745e-05_r8,0.18656e-06_r8 /)
      kbo(:, 5,38, 3) = (/ &
        & 0.30242e-09_r8,0.79676e-06_r8,0.11164e-05_r8,0.11256e-05_r8,0.19730e-06_r8 /)
      kbo(:, 1,39, 3) = (/ &
        & 0.30603e-09_r8,0.53518e-06_r8,0.73755e-06_r8,0.73560e-06_r8,0.12509e-06_r8 /)
      kbo(:, 2,39, 3) = (/ &
        & 0.28967e-09_r8,0.56827e-06_r8,0.79017e-06_r8,0.78607e-06_r8,0.13420e-06_r8 /)
      kbo(:, 3,39, 3) = (/ &
        & 0.27490e-09_r8,0.59946e-06_r8,0.83729e-06_r8,0.83418e-06_r8,0.14320e-06_r8 /)
      kbo(:, 4,39, 3) = (/ &
        & 0.26148e-09_r8,0.62968e-06_r8,0.88045e-06_r8,0.87919e-06_r8,0.15206e-06_r8 /)
      kbo(:, 5,39, 3) = (/ &
        & 0.24922e-09_r8,0.65358e-06_r8,0.91511e-06_r8,0.92187e-06_r8,0.16092e-06_r8 /)
      kbo(:, 1,40, 3) = (/ &
        & 0.25401e-09_r8,0.43491e-06_r8,0.59706e-06_r8,0.59583e-06_r8,0.10103e-06_r8 /)
      kbo(:, 2,40, 3) = (/ &
        & 0.24027e-09_r8,0.46243e-06_r8,0.64127e-06_r8,0.63780e-06_r8,0.10854e-06_r8 /)
      kbo(:, 3,40, 3) = (/ &
        & 0.22788e-09_r8,0.48789e-06_r8,0.68111e-06_r8,0.67785e-06_r8,0.11596e-06_r8 /)
      kbo(:, 4,40, 3) = (/ &
        & 0.21664e-09_r8,0.51370e-06_r8,0.71776e-06_r8,0.71557e-06_r8,0.12318e-06_r8 /)
      kbo(:, 5,40, 3) = (/ &
        & 0.20639e-09_r8,0.53413e-06_r8,0.74738e-06_r8,0.75116e-06_r8,0.13055e-06_r8 /)
      kbo(:, 1,41, 3) = (/ &
        & 0.21103e-09_r8,0.35162e-06_r8,0.48245e-06_r8,0.48181e-06_r8,0.81551e-07_r8 /)
      kbo(:, 2,41, 3) = (/ &
        & 0.19947e-09_r8,0.37577e-06_r8,0.51975e-06_r8,0.51683e-06_r8,0.87624e-07_r8 /)
      kbo(:, 3,41, 3) = (/ &
        & 0.18906e-09_r8,0.39681e-06_r8,0.55372e-06_r8,0.55016e-06_r8,0.93775e-07_r8 /)
      kbo(:, 4,41, 3) = (/ &
        & 0.17963e-09_r8,0.41856e-06_r8,0.58405e-06_r8,0.58177e-06_r8,0.99677e-07_r8 /)
      kbo(:, 5,41, 3) = (/ &
        & 0.17105e-09_r8,0.43610e-06_r8,0.60957e-06_r8,0.61150e-06_r8,0.10578e-06_r8 /)
      kbo(:, 1,42, 3) = (/ &
        & 0.17536e-09_r8,0.28412e-06_r8,0.38948e-06_r8,0.38933e-06_r8,0.65791e-07_r8 /)
      kbo(:, 2,42, 3) = (/ &
        & 0.16563e-09_r8,0.30504e-06_r8,0.42097e-06_r8,0.41854e-06_r8,0.70752e-07_r8 /)
      kbo(:, 3,42, 3) = (/ &
        & 0.15688e-09_r8,0.32265e-06_r8,0.44957e-06_r8,0.44624e-06_r8,0.75790e-07_r8 /)
      kbo(:, 4,42, 3) = (/ &
        & 0.14897e-09_r8,0.34080e-06_r8,0.47502e-06_r8,0.47268e-06_r8,0.80648e-07_r8 /)
      kbo(:, 5,42, 3) = (/ &
        & 0.14178e-09_r8,0.35584e-06_r8,0.49696e-06_r8,0.49747e-06_r8,0.85685e-07_r8 /)
      kbo(:, 1,43, 3) = (/ &
        & 0.14625e-09_r8,0.22828e-06_r8,0.31269e-06_r8,0.31301e-06_r8,0.52858e-07_r8 /)
      kbo(:, 2,43, 3) = (/ &
        & 0.13800e-09_r8,0.24660e-06_r8,0.33945e-06_r8,0.33736e-06_r8,0.56872e-07_r8 /)
      kbo(:, 3,43, 3) = (/ &
        & 0.13060e-09_r8,0.26150e-06_r8,0.36382e-06_r8,0.36052e-06_r8,0.61005e-07_r8 /)
      kbo(:, 4,43, 3) = (/ &
        & 0.12392e-09_r8,0.27637e-06_r8,0.38496e-06_r8,0.38262e-06_r8,0.65064e-07_r8 /)
      kbo(:, 5,43, 3) = (/ &
        & 0.11786e-09_r8,0.28960e-06_r8,0.40432e-06_r8,0.40346e-06_r8,0.69134e-07_r8 /)
      kbo(:, 1,44, 3) = (/ &
        & 0.12220e-09_r8,0.18299e-06_r8,0.25003e-06_r8,0.25075e-06_r8,0.42426e-07_r8 /)
      kbo(:, 2,44, 3) = (/ &
        & 0.11518e-09_r8,0.19858e-06_r8,0.27271e-06_r8,0.27124e-06_r8,0.45605e-07_r8 /)
      kbo(:, 3,44, 3) = (/ &
        & 0.10890e-09_r8,0.21149e-06_r8,0.29306e-06_r8,0.29059e-06_r8,0.48989e-07_r8 /)
      kbo(:, 4,44, 3) = (/ &
        & 0.10324e-09_r8,0.22361e-06_r8,0.31128e-06_r8,0.30909e-06_r8,0.52357e-07_r8 /)
      kbo(:, 5,44, 3) = (/ &
        & 0.98119e-10_r8,0.23540e-06_r8,0.32782e-06_r8,0.32657e-06_r8,0.55650e-07_r8 /)
      kbo(:, 1,45, 3) = (/ &
        & 0.10215e-09_r8,0.14604e-06_r8,0.19957e-06_r8,0.20079e-06_r8,0.34009e-07_r8 /)
      kbo(:, 2,45, 3) = (/ &
        & 0.96168e-10_r8,0.15976e-06_r8,0.21859e-06_r8,0.21782e-06_r8,0.36565e-07_r8 /)
      kbo(:, 3,45, 3) = (/ &
        & 0.90832e-10_r8,0.17092e-06_r8,0.23594e-06_r8,0.23403e-06_r8,0.39336e-07_r8 /)
      kbo(:, 4,45, 3) = (/ &
        & 0.86039e-10_r8,0.18076e-06_r8,0.25148e-06_r8,0.24940e-06_r8,0.42120e-07_r8 /)
      kbo(:, 5,45, 3) = (/ &
        & 0.81705e-10_r8,0.19091e-06_r8,0.26579e-06_r8,0.26417e-06_r8,0.44806e-07_r8 /)
      kbo(:, 1,46, 3) = (/ &
        & 0.85548e-10_r8,0.11606e-06_r8,0.15858e-06_r8,0.16025e-06_r8,0.27138e-07_r8 /)
      kbo(:, 2,46, 3) = (/ &
        & 0.80430e-10_r8,0.12777e-06_r8,0.17465e-06_r8,0.17439e-06_r8,0.29260e-07_r8 /)
      kbo(:, 3,46, 3) = (/ &
        & 0.75882e-10_r8,0.13771e-06_r8,0.18956e-06_r8,0.18801e-06_r8,0.31519e-07_r8 /)
      kbo(:, 4,46, 3) = (/ &
        & 0.71807e-10_r8,0.14597e-06_r8,0.20282e-06_r8,0.20085e-06_r8,0.33790e-07_r8 /)
      kbo(:, 5,46, 3) = (/ &
        & 0.68131e-10_r8,0.15454e-06_r8,0.21485e-06_r8,0.21321e-06_r8,0.36016e-07_r8 /)
      kbo(:, 1,47, 3) = (/ &
        & 0.71880e-10_r8,0.91677e-07_r8,0.12518e-06_r8,0.12717e-06_r8,0.21548e-07_r8 /)
      kbo(:, 2,47, 3) = (/ &
        & 0.67474e-10_r8,0.10182e-06_r8,0.13885e-06_r8,0.13887e-06_r8,0.23366e-07_r8 /)
      kbo(:, 3,47, 3) = (/ &
        & 0.63573e-10_r8,0.11037e-06_r8,0.15155e-06_r8,0.15037e-06_r8,0.25140e-07_r8 /)
      kbo(:, 4,47, 3) = (/ &
        & 0.60089e-10_r8,0.11757e-06_r8,0.16292e-06_r8,0.16115e-06_r8,0.27023e-07_r8 /)
      kbo(:, 5,47, 3) = (/ &
        & 0.56955e-10_r8,0.12460e-06_r8,0.17303e-06_r8,0.17150e-06_r8,0.28886e-07_r8 /)
      kbo(:, 1,48, 3) = (/ &
        & 0.60438e-10_r8,0.72378e-07_r8,0.98586e-07_r8,0.10075e-06_r8,0.17068e-07_r8 /)
      kbo(:, 2,48, 3) = (/ &
        & 0.56639e-10_r8,0.80662e-07_r8,0.11003e-06_r8,0.11052e-06_r8,0.18643e-07_r8 /)
      kbo(:, 3,48, 3) = (/ &
        & 0.53288e-10_r8,0.88391e-07_r8,0.12069e-06_r8,0.12007e-06_r8,0.20050e-07_r8 /)
      kbo(:, 4,48, 3) = (/ &
        & 0.50306e-10_r8,0.94624e-07_r8,0.13045e-06_r8,0.12916e-06_r8,0.21587e-07_r8 /)
      kbo(:, 5,48, 3) = (/ &
        & 0.47632e-10_r8,0.10026e-06_r8,0.13914e-06_r8,0.13778e-06_r8,0.23136e-07_r8 /)
      kbo(:, 1,49, 3) = (/ &
        & 0.50856e-10_r8,0.57046e-07_r8,0.77565e-07_r8,0.79741e-07_r8,0.13510e-07_r8 /)
      kbo(:, 2,49, 3) = (/ &
        & 0.47574e-10_r8,0.63730e-07_r8,0.86939e-07_r8,0.87826e-07_r8,0.14811e-07_r8 /)
      kbo(:, 3,49, 3) = (/ &
        & 0.44692e-10_r8,0.70367e-07_r8,0.95974e-07_r8,0.95707e-07_r8,0.15992e-07_r8 /)
      kbo(:, 4,49, 3) = (/ &
        & 0.42136e-10_r8,0.75959e-07_r8,0.10441e-06_r8,0.10336e-06_r8,0.17235e-07_r8 /)
      kbo(:, 5,49, 3) = (/ &
        & 0.39851e-10_r8,0.80662e-07_r8,0.11179e-06_r8,0.11061e-06_r8,0.18501e-07_r8 /)
      kbo(:, 1,50, 3) = (/ &
        & 0.42752e-10_r8,0.44994e-07_r8,0.60933e-07_r8,0.63170e-07_r8,0.10733e-07_r8 /)
      kbo(:, 2,50, 3) = (/ &
        & 0.39920e-10_r8,0.50417e-07_r8,0.68695e-07_r8,0.69776e-07_r8,0.11778e-07_r8 /)
      kbo(:, 3,50, 3) = (/ &
        & 0.37445e-10_r8,0.56129e-07_r8,0.76381e-07_r8,0.76292e-07_r8,0.12796e-07_r8 /)
      kbo(:, 4,50, 3) = (/ &
        & 0.35258e-10_r8,0.60916e-07_r8,0.83533e-07_r8,0.82746e-07_r8,0.13770e-07_r8 /)
      kbo(:, 5,50, 3) = (/ &
        & 0.33309e-10_r8,0.65010e-07_r8,0.89933e-07_r8,0.88828e-07_r8,0.14809e-07_r8 /)
      kbo(:, 1,51, 3) = (/ &
        & 0.35935e-10_r8,0.35278e-07_r8,0.47901e-07_r8,0.50056e-07_r8,0.85239e-08_r8 /)
      kbo(:, 2,51, 3) = (/ &
        & 0.33494e-10_r8,0.39897e-07_r8,0.54245e-07_r8,0.55439e-07_r8,0.93562e-08_r8 /)
      kbo(:, 3,51, 3) = (/ &
        & 0.31368e-10_r8,0.44577e-07_r8,0.60687e-07_r8,0.60854e-07_r8,0.10229e-07_r8 /)
      kbo(:, 4,51, 3) = (/ &
        & 0.29497e-10_r8,0.48906e-07_r8,0.66668e-07_r8,0.66217e-07_r8,0.11009e-07_r8 /)
      kbo(:, 5,51, 3) = (/ &
        & 0.27834e-10_r8,0.52348e-07_r8,0.72154e-07_r8,0.71322e-07_r8,0.11856e-07_r8 /)
      kbo(:, 1,52, 3) = (/ &
        & 0.30227e-10_r8,0.27572e-07_r8,0.37524e-07_r8,0.39754e-07_r8,0.67198e-08_r8 /)
      kbo(:, 2,52, 3) = (/ &
        & 0.28118e-10_r8,0.31560e-07_r8,0.42810e-07_r8,0.44031e-07_r8,0.74267e-08_r8 /)
      kbo(:, 3,52, 3) = (/ &
        & 0.26290e-10_r8,0.35319e-07_r8,0.48079e-07_r8,0.48486e-07_r8,0.81511e-08_r8 /)
      kbo(:, 4,52, 3) = (/ &
        & 0.24687e-10_r8,0.39041e-07_r8,0.53141e-07_r8,0.52898e-07_r8,0.88044e-08_r8 /)
      kbo(:, 5,52, 3) = (/ &
        & 0.23267e-10_r8,0.42123e-07_r8,0.57835e-07_r8,0.57177e-07_r8,0.94934e-08_r8 /)
      kbo(:, 1,53, 3) = (/ &
        & 0.25448e-10_r8,0.21456e-07_r8,0.29324e-07_r8,0.31450e-07_r8,0.53035e-08_r8 /)
      kbo(:, 2,53, 3) = (/ &
        & 0.23623e-10_r8,0.24922e-07_r8,0.33706e-07_r8,0.34903e-07_r8,0.59025e-08_r8 /)
      kbo(:, 3,53, 3) = (/ &
        & 0.22048e-10_r8,0.27931e-07_r8,0.38009e-07_r8,0.38548e-07_r8,0.64842e-08_r8 /)
      kbo(:, 4,53, 3) = (/ &
        & 0.20673e-10_r8,0.31117e-07_r8,0.42293e-07_r8,0.42180e-07_r8,0.70454e-08_r8 /)
      kbo(:, 5,53, 3) = (/ &
        & 0.19459e-10_r8,0.33800e-07_r8,0.46316e-07_r8,0.45776e-07_r8,0.75886e-08_r8 /)
      kbo(:, 1,54, 3) = (/ &
        & 0.21390e-10_r8,0.16743e-07_r8,0.23031e-07_r8,0.24877e-07_r8,0.41777e-08_r8 /)
      kbo(:, 2,54, 3) = (/ &
        & 0.19815e-10_r8,0.19619e-07_r8,0.26556e-07_r8,0.27722e-07_r8,0.47031e-08_r8 /)
      kbo(:, 3,54, 3) = (/ &
        & 0.18463e-10_r8,0.22167e-07_r8,0.30101e-07_r8,0.30708e-07_r8,0.51646e-08_r8 /)
      kbo(:, 4,54, 3) = (/ &
        & 0.17286e-10_r8,0.24804e-07_r8,0.33704e-07_r8,0.33716e-07_r8,0.56448e-08_r8 /)
      kbo(:, 5,54, 3) = (/ &
        & 0.16251e-10_r8,0.27183e-07_r8,0.37049e-07_r8,0.36696e-07_r8,0.60788e-08_r8 /)
      kbo(:, 1,55, 3) = (/ &
        & 0.17973e-10_r8,0.13037e-07_r8,0.18115e-07_r8,0.19727e-07_r8,0.32912e-08_r8 /)
      kbo(:, 2,55, 3) = (/ &
        & 0.16615e-10_r8,0.15402e-07_r8,0.20942e-07_r8,0.22043e-07_r8,0.37301e-08_r8 /)
      kbo(:, 3,55, 3) = (/ &
        & 0.15454e-10_r8,0.17592e-07_r8,0.23848e-07_r8,0.24485e-07_r8,0.41129e-08_r8 /)
      kbo(:, 4,55, 3) = (/ &
        & 0.14448e-10_r8,0.19733e-07_r8,0.26815e-07_r8,0.26954e-07_r8,0.45146e-08_r8 /)
      kbo(:, 5,55, 3) = (/ &
        & 0.13565e-10_r8,0.21785e-07_r8,0.29633e-07_r8,0.29414e-07_r8,0.48762e-08_r8 /)
      kbo(:, 1,56, 3) = (/ &
        & 0.15112e-10_r8,0.10127e-07_r8,0.14262e-07_r8,0.15637e-07_r8,0.25986e-08_r8 /)
      kbo(:, 2,56, 3) = (/ &
        & 0.13939e-10_r8,0.12082e-07_r8,0.16458e-07_r8,0.17567e-07_r8,0.29510e-08_r8 /)
      kbo(:, 3,56, 3) = (/ &
        & 0.12942e-10_r8,0.13980e-07_r8,0.18876e-07_r8,0.19499e-07_r8,0.32803e-08_r8 /)
      kbo(:, 4,56, 3) = (/ &
        & 0.12080e-10_r8,0.15677e-07_r8,0.21298e-07_r8,0.21516e-07_r8,0.36078e-08_r8 /)
      kbo(:, 5,56, 3) = (/ &
        & 0.11328e-10_r8,0.17421e-07_r8,0.23674e-07_r8,0.23552e-07_r8,0.39142e-08_r8 /)
      kbo(:, 1,57, 3) = (/ &
        & 0.12716e-10_r8,0.78423e-08_r8,0.11218e-07_r8,0.12368e-07_r8,0.20572e-08_r8 /)
      kbo(:, 2,57, 3) = (/ &
        & 0.11703e-10_r8,0.94468e-08_r8,0.12944e-07_r8,0.13939e-07_r8,0.23449e-08_r8 /)
      kbo(:, 3,57, 3) = (/ &
        & 0.10844e-10_r8,0.11054e-07_r8,0.14933e-07_r8,0.15504e-07_r8,0.26161e-08_r8 /)
      kbo(:, 4,57, 3) = (/ &
        & 0.10105e-10_r8,0.12445e-07_r8,0.16895e-07_r8,0.17167e-07_r8,0.28789e-08_r8 /)
      kbo(:, 5,57, 3) = (/ &
        & 0.94629e-11_r8,0.13929e-07_r8,0.18884e-07_r8,0.18837e-07_r8,0.31391e-08_r8 /)
      kbo(:, 1,58, 3) = (/ &
        & 0.10694e-10_r8,0.61084e-08_r8,0.88278e-08_r8,0.97801e-08_r8,0.16192e-08_r8 /)
      kbo(:, 2,58, 3) = (/ &
        & 0.98180e-11_r8,0.73859e-08_r8,0.10206e-07_r8,0.11064e-07_r8,0.18486e-08_r8 /)
      kbo(:, 3,58, 3) = (/ &
        & 0.90797e-11_r8,0.87113e-08_r8,0.11801e-07_r8,0.12348e-07_r8,0.20872e-08_r8 /)
      kbo(:, 4,58, 3) = (/ &
        & 0.84478e-11_r8,0.99003e-08_r8,0.13409e-07_r8,0.13707e-07_r8,0.22967e-08_r8 /)
      kbo(:, 5,58, 3) = (/ &
        & 0.78998e-11_r8,0.11108e-07_r8,0.15069e-07_r8,0.15082e-07_r8,0.25182e-08_r8 /)
      kbo(:, 1,59, 3) = (/ &
        & 0.88513e-11_r8,0.49239e-08_r8,0.71386e-08_r8,0.79170e-08_r8,0.13089e-08_r8 /)
      kbo(:, 2,59, 3) = (/ &
        & 0.81187e-11_r8,0.59541e-08_r8,0.82539e-08_r8,0.89758e-08_r8,0.14952e-08_r8 /)
      kbo(:, 3,59, 3) = (/ &
        & 0.75021e-11_r8,0.70450e-08_r8,0.95567e-08_r8,0.10024e-07_r8,0.16919e-08_r8 /)
      kbo(:, 4,59, 3) = (/ &
        & 0.69753e-11_r8,0.80391e-08_r8,0.10874e-07_r8,0.11143e-07_r8,0.18646e-08_r8 /)
      kbo(:, 5,59, 3) = (/ &
        & 0.65191e-11_r8,0.90265e-08_r8,0.12240e-07_r8,0.12268e-07_r8,0.20471e-08_r8 /)
      kbo(:, 1,13, 4) = (/ &
        & 0.40115e-06_r8,0.20542e-03_r8,0.29006e-03_r8,0.29983e-03_r8,0.86404e-04_r8 /)
      kbo(:, 2,13, 4) = (/ &
        & 0.38503e-06_r8,0.22086e-03_r8,0.30833e-03_r8,0.32518e-03_r8,0.92611e-04_r8 /)
      kbo(:, 3,13, 4) = (/ &
        & 0.37042e-06_r8,0.23415e-03_r8,0.32674e-03_r8,0.34814e-03_r8,0.98878e-04_r8 /)
      kbo(:, 4,13, 4) = (/ &
        & 0.35699e-06_r8,0.24607e-03_r8,0.34335e-03_r8,0.36858e-03_r8,0.10559e-03_r8 /)
      kbo(:, 5,13, 4) = (/ &
        & 0.34439e-06_r8,0.25741e-03_r8,0.35943e-03_r8,0.38716e-03_r8,0.11262e-03_r8 /)
      kbo(:, 1,14, 4) = (/ &
        & 0.32717e-06_r8,0.17086e-03_r8,0.24121e-03_r8,0.25001e-03_r8,0.72120e-04_r8 /)
      kbo(:, 2,14, 4) = (/ &
        & 0.31411e-06_r8,0.18358e-03_r8,0.25599e-03_r8,0.27089e-03_r8,0.77351e-04_r8 /)
      kbo(:, 3,14, 4) = (/ &
        & 0.30225e-06_r8,0.19456e-03_r8,0.27149e-03_r8,0.29002e-03_r8,0.82676e-04_r8 /)
      kbo(:, 4,14, 4) = (/ &
        & 0.29132e-06_r8,0.20460e-03_r8,0.28544e-03_r8,0.30678e-03_r8,0.88331e-04_r8 /)
      kbo(:, 5,14, 4) = (/ &
        & 0.28105e-06_r8,0.21410e-03_r8,0.29919e-03_r8,0.32271e-03_r8,0.94451e-04_r8 /)
      kbo(:, 1,15, 4) = (/ &
        & 0.26673e-06_r8,0.14221e-03_r8,0.20048e-03_r8,0.20843e-03_r8,0.60213e-04_r8 /)
      kbo(:, 2,15, 4) = (/ &
        & 0.25615e-06_r8,0.15268e-03_r8,0.21264e-03_r8,0.22531e-03_r8,0.64531e-04_r8 /)
      kbo(:, 3,15, 4) = (/ &
        & 0.24652e-06_r8,0.16170e-03_r8,0.22567e-03_r8,0.24157e-03_r8,0.69102e-04_r8 /)
      kbo(:, 4,15, 4) = (/ &
        & 0.23764e-06_r8,0.17023e-03_r8,0.23750e-03_r8,0.25543e-03_r8,0.73891e-04_r8 /)
      kbo(:, 5,15, 4) = (/ &
        & 0.22926e-06_r8,0.17815e-03_r8,0.24912e-03_r8,0.26892e-03_r8,0.79167e-04_r8 /)
      kbo(:, 1,16, 4) = (/ &
        & 0.21740e-06_r8,0.11824e-03_r8,0.16644e-03_r8,0.17381e-03_r8,0.50227e-04_r8 /)
      kbo(:, 2,16, 4) = (/ &
        & 0.20884e-06_r8,0.12696e-03_r8,0.17683e-03_r8,0.18780e-03_r8,0.53903e-04_r8 /)
      kbo(:, 3,16, 4) = (/ &
        & 0.20104e-06_r8,0.13434e-03_r8,0.18764e-03_r8,0.20094e-03_r8,0.57777e-04_r8 /)
      kbo(:, 4,16, 4) = (/ &
        & 0.19381e-06_r8,0.14177e-03_r8,0.19757e-03_r8,0.21259e-03_r8,0.61821e-04_r8 /)
      kbo(:, 5,16, 4) = (/ &
        & 0.18698e-06_r8,0.14828e-03_r8,0.20747e-03_r8,0.22416e-03_r8,0.66326e-04_r8 /)
      kbo(:, 1,17, 4) = (/ &
        & 0.17724e-06_r8,0.98287e-04_r8,0.13813e-03_r8,0.14496e-03_r8,0.41851e-04_r8 /)
      kbo(:, 2,17, 4) = (/ &
        & 0.17029e-06_r8,0.10548e-03_r8,0.14701e-03_r8,0.15636e-03_r8,0.44943e-04_r8 /)
      kbo(:, 3,17, 4) = (/ &
        & 0.16396e-06_r8,0.11169e-03_r8,0.15605e-03_r8,0.16727e-03_r8,0.48176e-04_r8 /)
      kbo(:, 4,17, 4) = (/ &
        & 0.15809e-06_r8,0.11795e-03_r8,0.16435e-03_r8,0.17684e-03_r8,0.51716e-04_r8 /)
      kbo(:, 5,17, 4) = (/ &
        & 0.15251e-06_r8,0.12332e-03_r8,0.17265e-03_r8,0.18683e-03_r8,0.55480e-04_r8 /)
      kbo(:, 1,18, 4) = (/ &
        & 0.14450e-06_r8,0.81703e-04_r8,0.11464e-03_r8,0.12079e-03_r8,0.34849e-04_r8 /)
      kbo(:, 2,18, 4) = (/ &
        & 0.13887e-06_r8,0.87580e-04_r8,0.12224e-03_r8,0.13028e-03_r8,0.37465e-04_r8 /)
      kbo(:, 3,18, 4) = (/ &
        & 0.13373e-06_r8,0.92869e-04_r8,0.12966e-03_r8,0.13906e-03_r8,0.40225e-04_r8 /)
      kbo(:, 4,18, 4) = (/ &
        & 0.12896e-06_r8,0.98034e-04_r8,0.13668e-03_r8,0.14712e-03_r8,0.43227e-04_r8 /)
      kbo(:, 5,18, 4) = (/ &
        & 0.12439e-06_r8,0.10250e-03_r8,0.14367e-03_r8,0.15557e-03_r8,0.46383e-04_r8 /)
      kbo(:, 1,19, 4) = (/ &
        & 0.11782e-06_r8,0.67922e-04_r8,0.95121e-04_r8,0.10059e-03_r8,0.29014e-04_r8 /)
      kbo(:, 2,19, 4) = (/ &
        & 0.11325e-06_r8,0.72759e-04_r8,0.10166e-03_r8,0.10843e-03_r8,0.31239e-04_r8 /)
      kbo(:, 3,19, 4) = (/ &
        & 0.10909e-06_r8,0.77213e-04_r8,0.10769e-03_r8,0.11563e-03_r8,0.33594e-04_r8 /)
      kbo(:, 4,19, 4) = (/ &
        & 0.10521e-06_r8,0.81507e-04_r8,0.11367e-03_r8,0.12244e-03_r8,0.36087e-04_r8 /)
      kbo(:, 5,19, 4) = (/ &
        & 0.10146e-06_r8,0.85229e-04_r8,0.11951e-03_r8,0.12955e-03_r8,0.38760e-04_r8 /)
      kbo(:, 1,20, 4) = (/ &
        & 0.96005e-07_r8,0.56539e-04_r8,0.79048e-04_r8,0.83638e-04_r8,0.24182e-04_r8 /)
      kbo(:, 2,20, 4) = (/ &
        & 0.92311e-07_r8,0.60522e-04_r8,0.84506e-04_r8,0.90308e-04_r8,0.26052e-04_r8 /)
      kbo(:, 3,20, 4) = (/ &
        & 0.88927e-07_r8,0.64305e-04_r8,0.89608e-04_r8,0.96229e-04_r8,0.28071e-04_r8 /)
      kbo(:, 4,20, 4) = (/ &
        & 0.85775e-07_r8,0.67811e-04_r8,0.94659e-04_r8,0.10203e-03_r8,0.30185e-04_r8 /)
      kbo(:, 5,20, 4) = (/ &
        & 0.82709e-07_r8,0.70967e-04_r8,0.99551e-04_r8,0.10796e-03_r8,0.32438e-04_r8 /)
      kbo(:, 1,21, 4) = (/ &
        & 0.78225e-07_r8,0.47094e-04_r8,0.65736e-04_r8,0.69706e-04_r8,0.20168e-04_r8 /)
      kbo(:, 2,21, 4) = (/ &
        & 0.75235e-07_r8,0.50383e-04_r8,0.70309e-04_r8,0.75210e-04_r8,0.21748e-04_r8 /)
      kbo(:, 3,21, 4) = (/ &
        & 0.72491e-07_r8,0.53581e-04_r8,0.74579e-04_r8,0.80106e-04_r8,0.23442e-04_r8 /)
      kbo(:, 4,21, 4) = (/ &
        & 0.69929e-07_r8,0.56448e-04_r8,0.78864e-04_r8,0.85108e-04_r8,0.25248e-04_r8 /)
      kbo(:, 5,21, 4) = (/ &
        & 0.67419e-07_r8,0.59090e-04_r8,0.82932e-04_r8,0.89870e-04_r8,0.27098e-04_r8 /)
      kbo(:, 1,22, 4) = (/ &
        & 0.63572e-07_r8,0.39426e-04_r8,0.54979e-04_r8,0.58443e-04_r8,0.16913e-04_r8 /)
      kbo(:, 2,22, 4) = (/ &
        & 0.61166e-07_r8,0.42097e-04_r8,0.58779e-04_r8,0.62933e-04_r8,0.18259e-04_r8 /)
      kbo(:, 3,22, 4) = (/ &
        & 0.58951e-07_r8,0.44794e-04_r8,0.62330e-04_r8,0.66952e-04_r8,0.19670e-04_r8 /)
      kbo(:, 4,22, 4) = (/ &
        & 0.56872e-07_r8,0.47147e-04_r8,0.65961e-04_r8,0.71230e-04_r8,0.21221e-04_r8 /)
      kbo(:, 5,22, 4) = (/ &
        & 0.54822e-07_r8,0.49377e-04_r8,0.69234e-04_r8,0.75038e-04_r8,0.22743e-04_r8 /)
      kbo(:, 1,23, 4) = (/ &
        & 0.51656e-07_r8,0.32950e-04_r8,0.46052e-04_r8,0.49084e-04_r8,0.14181e-04_r8 /)
      kbo(:, 2,23, 4) = (/ &
        & 0.49721e-07_r8,0.35250e-04_r8,0.49106e-04_r8,0.52675e-04_r8,0.15330e-04_r8 /)
      kbo(:, 3,23, 4) = (/ &
        & 0.47930e-07_r8,0.37438e-04_r8,0.52152e-04_r8,0.56097e-04_r8,0.16532e-04_r8 /)
      kbo(:, 4,23, 4) = (/ &
        & 0.46242e-07_r8,0.39418e-04_r8,0.55160e-04_r8,0.59674e-04_r8,0.17811e-04_r8 /)
      kbo(:, 5,23, 4) = (/ &
        & 0.44570e-07_r8,0.41280e-04_r8,0.57899e-04_r8,0.62654e-04_r8,0.19100e-04_r8 /)
      kbo(:, 1,24, 4) = (/ &
        & 0.41962e-07_r8,0.27608e-04_r8,0.38527e-04_r8,0.41167e-04_r8,0.11908e-04_r8 /)
      kbo(:, 2,24, 4) = (/ &
        & 0.40405e-07_r8,0.29547e-04_r8,0.41099e-04_r8,0.44081e-04_r8,0.12880e-04_r8 /)
      kbo(:, 3,24, 4) = (/ &
        & 0.38959e-07_r8,0.31321e-04_r8,0.43687e-04_r8,0.47051e-04_r8,0.13912e-04_r8 /)
      kbo(:, 4,24, 4) = (/ &
        & 0.37583e-07_r8,0.32994e-04_r8,0.46190e-04_r8,0.49890e-04_r8,0.14961e-04_r8 /)
      kbo(:, 5,24, 4) = (/ &
        & 0.36227e-07_r8,0.34560e-04_r8,0.48473e-04_r8,0.52358e-04_r8,0.16039e-04_r8 /)
      kbo(:, 1,25, 4) = (/ &
        & 0.34075e-07_r8,0.23153e-04_r8,0.32305e-04_r8,0.34566e-04_r8,0.10014e-04_r8 /)
      kbo(:, 2,25, 4) = (/ &
        & 0.32822e-07_r8,0.24769e-04_r8,0.34435e-04_r8,0.36968e-04_r8,0.10822e-04_r8 /)
      kbo(:, 3,25, 4) = (/ &
        & 0.31655e-07_r8,0.26242e-04_r8,0.36635e-04_r8,0.39484e-04_r8,0.11699e-04_r8 /)
      kbo(:, 4,25, 4) = (/ &
        & 0.30528e-07_r8,0.27624e-04_r8,0.38648e-04_r8,0.41770e-04_r8,0.12588e-04_r8 /)
      kbo(:, 5,25, 4) = (/ &
        & 0.29434e-07_r8,0.28951e-04_r8,0.40632e-04_r8,0.43774e-04_r8,0.13479e-04_r8 /)
      kbo(:, 1,26, 4) = (/ &
        & 0.27652e-07_r8,0.19460e-04_r8,0.27114e-04_r8,0.29052e-04_r8,0.84372e-05_r8 /)
      kbo(:, 2,26, 4) = (/ &
        & 0.26645e-07_r8,0.20785e-04_r8,0.28933e-04_r8,0.31091e-04_r8,0.91305e-05_r8 /)
      kbo(:, 3,26, 4) = (/ &
        & 0.25703e-07_r8,0.22018e-04_r8,0.30749e-04_r8,0.33173e-04_r8,0.98560e-05_r8 /)
      kbo(:, 4,26, 4) = (/ &
        & 0.24780e-07_r8,0.23166e-04_r8,0.32405e-04_r8,0.34971e-04_r8,0.10593e-04_r8 /)
      kbo(:, 5,26, 4) = (/ &
        & 0.23900e-07_r8,0.24286e-04_r8,0.34048e-04_r8,0.36663e-04_r8,0.11346e-04_r8 /)
      kbo(:, 1,27, 4) = (/ &
        & 0.22439e-07_r8,0.16370e-04_r8,0.22763e-04_r8,0.24397e-04_r8,0.71084e-05_r8 /)
      kbo(:, 2,27, 4) = (/ &
        & 0.21628e-07_r8,0.17461e-04_r8,0.24318e-04_r8,0.26140e-04_r8,0.76961e-05_r8 /)
      kbo(:, 3,27, 4) = (/ &
        & 0.20865e-07_r8,0.18493e-04_r8,0.25826e-04_r8,0.27824e-04_r8,0.83080e-05_r8 /)
      kbo(:, 4,27, 4) = (/ &
        & 0.20113e-07_r8,0.19452e-04_r8,0.27215e-04_r8,0.29287e-04_r8,0.89207e-05_r8 /)
      kbo(:, 5,27, 4) = (/ &
        & 0.19405e-07_r8,0.20376e-04_r8,0.28543e-04_r8,0.30710e-04_r8,0.95477e-05_r8 /)
      kbo(:, 1,28, 4) = (/ &
        & 0.18208e-07_r8,0.13777e-04_r8,0.19138e-04_r8,0.20524e-04_r8,0.59952e-05_r8 /)
      kbo(:, 2,28, 4) = (/ &
        & 0.17555e-07_r8,0.14679e-04_r8,0.20448e-04_r8,0.21996e-04_r8,0.64907e-05_r8 /)
      kbo(:, 3,28, 4) = (/ &
        & 0.16936e-07_r8,0.15522e-04_r8,0.21661e-04_r8,0.23357e-04_r8,0.69966e-05_r8 /)
      kbo(:, 4,28, 4) = (/ &
        & 0.16325e-07_r8,0.16334e-04_r8,0.22846e-04_r8,0.24537e-04_r8,0.75124e-05_r8 /)
      kbo(:, 5,28, 4) = (/ &
        & 0.15755e-07_r8,0.17088e-04_r8,0.23931e-04_r8,0.25722e-04_r8,0.80305e-05_r8 /)
      kbo(:, 1,29, 4) = (/ &
        & 0.14772e-07_r8,0.11598e-04_r8,0.16117e-04_r8,0.17294e-04_r8,0.50602e-05_r8 /)
      kbo(:, 2,29, 4) = (/ &
        & 0.14246e-07_r8,0.12346e-04_r8,0.17198e-04_r8,0.18521e-04_r8,0.54799e-05_r8 /)
      kbo(:, 3,29, 4) = (/ &
        & 0.13739e-07_r8,0.13047e-04_r8,0.18205e-04_r8,0.19566e-04_r8,0.58992e-05_r8 /)
      kbo(:, 4,29, 4) = (/ &
        & 0.13247e-07_r8,0.13729e-04_r8,0.19173e-04_r8,0.20574e-04_r8,0.63251e-05_r8 /)
      kbo(:, 5,29, 4) = (/ &
        & 0.12789e-07_r8,0.14341e-04_r8,0.20068e-04_r8,0.21536e-04_r8,0.67496e-05_r8 /)
      kbo(:, 1,30, 4) = (/ &
        & 0.11984e-07_r8,0.97679e-05_r8,0.13568e-04_r8,0.14565e-04_r8,0.42721e-05_r8 /)
      kbo(:, 2,30, 4) = (/ &
        & 0.11560e-07_r8,0.10389e-04_r8,0.14461e-04_r8,0.15560e-04_r8,0.46182e-05_r8 /)
      kbo(:, 3,30, 4) = (/ &
        & 0.11144e-07_r8,0.10973e-04_r8,0.15302e-04_r8,0.16410e-04_r8,0.49715e-05_r8 /)
      kbo(:, 4,30, 4) = (/ &
        & 0.10750e-07_r8,0.11532e-04_r8,0.16091e-04_r8,0.17244e-04_r8,0.53212e-05_r8 /)
      kbo(:, 5,30, 4) = (/ &
        & 0.10381e-07_r8,0.12034e-04_r8,0.16821e-04_r8,0.18023e-04_r8,0.56712e-05_r8 /)
      kbo(:, 1,31, 4) = (/ &
        & 0.97205e-08_r8,0.82296e-05_r8,0.11440e-04_r8,0.12288e-04_r8,0.36079e-05_r8 /)
      kbo(:, 2,31, 4) = (/ &
        & 0.93777e-08_r8,0.87431e-05_r8,0.12158e-04_r8,0.13067e-04_r8,0.38974e-05_r8 /)
      kbo(:, 3,31, 4) = (/ &
        & 0.90391e-08_r8,0.92300e-05_r8,0.12862e-04_r8,0.13769e-04_r8,0.41885e-05_r8 /)
      kbo(:, 4,31, 4) = (/ &
        & 0.87219e-08_r8,0.96854e-05_r8,0.13508e-04_r8,0.14454e-04_r8,0.44756e-05_r8 /)
      kbo(:, 5,31, 4) = (/ &
        & 0.84251e-08_r8,0.10101e-04_r8,0.14090e-04_r8,0.15064e-04_r8,0.47643e-05_r8 /)
      kbo(:, 1,32, 4) = (/ &
        & 0.78842e-08_r8,0.69379e-05_r8,0.96378e-05_r8,0.10350e-04_r8,0.30462e-05_r8 /)
      kbo(:, 2,32, 4) = (/ &
        & 0.76058e-08_r8,0.73605e-05_r8,0.10230e-04_r8,0.10964e-04_r8,0.32879e-05_r8 /)
      kbo(:, 3,32, 4) = (/ &
        & 0.73312e-08_r8,0.77685e-05_r8,0.10806e-04_r8,0.11552e-04_r8,0.35258e-05_r8 /)
      kbo(:, 4,32, 4) = (/ &
        & 0.70761e-08_r8,0.81393e-05_r8,0.11329e-04_r8,0.12109e-04_r8,0.37642e-05_r8 /)
      kbo(:, 5,32, 4) = (/ &
        & 0.68375e-08_r8,0.84723e-05_r8,0.11806e-04_r8,0.12582e-04_r8,0.40027e-05_r8 /)
      kbo(:, 1,33, 4) = (/ &
        & 0.63946e-08_r8,0.58484e-05_r8,0.81132e-05_r8,0.87138e-05_r8,0.25722e-05_r8 /)
      kbo(:, 2,33, 4) = (/ &
        & 0.61668e-08_r8,0.61985e-05_r8,0.86152e-05_r8,0.92043e-05_r8,0.27716e-05_r8 /)
      kbo(:, 3,33, 4) = (/ &
        & 0.59460e-08_r8,0.65329e-05_r8,0.90761e-05_r8,0.96914e-05_r8,0.29672e-05_r8 /)
      kbo(:, 4,33, 4) = (/ &
        & 0.57410e-08_r8,0.68349e-05_r8,0.94991e-05_r8,0.10128e-04_r8,0.31649e-05_r8 /)
      kbo(:, 5,33, 4) = (/ &
        & 0.55490e-08_r8,0.71098e-05_r8,0.98972e-05_r8,0.10494e-04_r8,0.33613e-05_r8 /)
      kbo(:, 1,34, 4) = (/ &
        & 0.51931e-08_r8,0.49155e-05_r8,0.68122e-05_r8,0.73003e-05_r8,0.21648e-05_r8 /)
      kbo(:, 2,34, 4) = (/ &
        & 0.50066e-08_r8,0.52108e-05_r8,0.72299e-05_r8,0.77128e-05_r8,0.23280e-05_r8 /)
      kbo(:, 3,34, 4) = (/ &
        & 0.48289e-08_r8,0.54838e-05_r8,0.76076e-05_r8,0.81077e-05_r8,0.24906e-05_r8 /)
      kbo(:, 4,34, 4) = (/ &
        & 0.46636e-08_r8,0.57271e-05_r8,0.79460e-05_r8,0.84494e-05_r8,0.26534e-05_r8 /)
      kbo(:, 5,34, 4) = (/ &
        & 0.45089e-08_r8,0.59543e-05_r8,0.82751e-05_r8,0.87422e-05_r8,0.28159e-05_r8 /)
      kbo(:, 1,35, 4) = (/ &
        & 0.42177e-08_r8,0.41104e-05_r8,0.56914e-05_r8,0.60852e-05_r8,0.18078e-05_r8 /)
      kbo(:, 2,35, 4) = (/ &
        & 0.40795e-08_r8,0.43580e-05_r8,0.60334e-05_r8,0.64274e-05_r8,0.19421e-05_r8 /)
      kbo(:, 3,35, 4) = (/ &
        & 0.39353e-08_r8,0.45814e-05_r8,0.63407e-05_r8,0.67443e-05_r8,0.20767e-05_r8 /)
      kbo(:, 4,35, 4) = (/ &
        & 0.38012e-08_r8,0.47803e-05_r8,0.66196e-05_r8,0.70144e-05_r8,0.22114e-05_r8 /)
      kbo(:, 5,35, 4) = (/ &
        & 0.36756e-08_r8,0.49682e-05_r8,0.68884e-05_r8,0.72539e-05_r8,0.23458e-05_r8 /)
      kbo(:, 1,36, 4) = (/ &
        & 0.34162e-08_r8,0.34141e-05_r8,0.47224e-05_r8,0.50412e-05_r8,0.14965e-05_r8 /)
      kbo(:, 2,36, 4) = (/ &
        & 0.33196e-08_r8,0.36215e-05_r8,0.50037e-05_r8,0.53241e-05_r8,0.16078e-05_r8 /)
      kbo(:, 3,36, 4) = (/ &
        & 0.32195e-08_r8,0.38064e-05_r8,0.52583e-05_r8,0.55817e-05_r8,0.17188e-05_r8 /)
      kbo(:, 4,36, 4) = (/ &
        & 0.31099e-08_r8,0.39715e-05_r8,0.54881e-05_r8,0.58006e-05_r8,0.18307e-05_r8 /)
      kbo(:, 5,36, 4) = (/ &
        & 0.30072e-08_r8,0.41270e-05_r8,0.57065e-05_r8,0.59974e-05_r8,0.19419e-05_r8 /)
      kbo(:, 1,37, 4) = (/ &
        & 0.28008e-08_r8,0.28094e-05_r8,0.38801e-05_r8,0.41393e-05_r8,0.12248e-05_r8 /)
      kbo(:, 2,37, 4) = (/ &
        & 0.27121e-08_r8,0.29836e-05_r8,0.41155e-05_r8,0.43748e-05_r8,0.13168e-05_r8 /)
      kbo(:, 3,37, 4) = (/ &
        & 0.26482e-08_r8,0.31397e-05_r8,0.43282e-05_r8,0.45885e-05_r8,0.14087e-05_r8 /)
      kbo(:, 4,37, 4) = (/ &
        & 0.25576e-08_r8,0.32779e-05_r8,0.45200e-05_r8,0.47706e-05_r8,0.15013e-05_r8 /)
      kbo(:, 5,37, 4) = (/ &
        & 0.24727e-08_r8,0.34082e-05_r8,0.47023e-05_r8,0.49354e-05_r8,0.15935e-05_r8 /)
      kbo(:, 1,38, 4) = (/ &
        & 0.22984e-08_r8,0.23106e-05_r8,0.31856e-05_r8,0.33961e-05_r8,0.10016e-05_r8 /)
      kbo(:, 2,38, 4) = (/ &
        & 0.22220e-08_r8,0.24563e-05_r8,0.33826e-05_r8,0.35915e-05_r8,0.10776e-05_r8 /)
      kbo(:, 3,38, 4) = (/ &
        & 0.21588e-08_r8,0.25882e-05_r8,0.35600e-05_r8,0.37696e-05_r8,0.11538e-05_r8 /)
      kbo(:, 4,38, 4) = (/ &
        & 0.21040e-08_r8,0.27033e-05_r8,0.37199e-05_r8,0.39213e-05_r8,0.12304e-05_r8 /)
      kbo(:, 5,38, 4) = (/ &
        & 0.20339e-08_r8,0.28122e-05_r8,0.38728e-05_r8,0.40597e-05_r8,0.13067e-05_r8 /)
      kbo(:, 1,39, 4) = (/ &
        & 0.18867e-08_r8,0.18990e-05_r8,0.26147e-05_r8,0.27855e-05_r8,0.81895e-06_r8 /)
      kbo(:, 2,39, 4) = (/ &
        & 0.18219e-08_r8,0.20211e-05_r8,0.27789e-05_r8,0.29482e-05_r8,0.88168e-06_r8 /)
      kbo(:, 3,39, 4) = (/ &
        & 0.17671e-08_r8,0.21324e-05_r8,0.29272e-05_r8,0.30962e-05_r8,0.94475e-06_r8 /)
      kbo(:, 4,39, 4) = (/ &
        & 0.17201e-08_r8,0.22287e-05_r8,0.30607e-05_r8,0.32231e-05_r8,0.10080e-05_r8 /)
      kbo(:, 5,39, 4) = (/ &
        & 0.16729e-08_r8,0.23197e-05_r8,0.31885e-05_r8,0.33389e-05_r8,0.10713e-05_r8 /)
      kbo(:, 1,40, 4) = (/ &
        & 0.15567e-08_r8,0.15486e-05_r8,0.21299e-05_r8,0.22697e-05_r8,0.66418e-06_r8 /)
      kbo(:, 2,40, 4) = (/ &
        & 0.15030e-08_r8,0.16525e-05_r8,0.22686e-05_r8,0.24063e-05_r8,0.71591e-06_r8 /)
      kbo(:, 3,40, 4) = (/ &
        & 0.14559e-08_r8,0.17468e-05_r8,0.23938e-05_r8,0.25304e-05_r8,0.76804e-06_r8 /)
      kbo(:, 4,40, 4) = (/ &
        & 0.14147e-08_r8,0.18284e-05_r8,0.25062e-05_r8,0.26377e-05_r8,0.82053e-06_r8 /)
      kbo(:, 5,40, 4) = (/ &
        & 0.13808e-08_r8,0.19051e-05_r8,0.26142e-05_r8,0.27362e-05_r8,0.87282e-06_r8 /)
      kbo(:, 1,41, 4) = (/ &
        & 0.12855e-08_r8,0.12622e-05_r8,0.17326e-05_r8,0.18472e-05_r8,0.53778e-06_r8 /)
      kbo(:, 2,41, 4) = (/ &
        & 0.12414e-08_r8,0.13486e-05_r8,0.18494e-05_r8,0.19612e-05_r8,0.58062e-06_r8 /)
      kbo(:, 3,41, 4) = (/ &
        & 0.12006e-08_r8,0.14290e-05_r8,0.19551e-05_r8,0.20665e-05_r8,0.62365e-06_r8 /)
      kbo(:, 4,41, 4) = (/ &
        & 0.11655e-08_r8,0.14984e-05_r8,0.20506e-05_r8,0.21570e-05_r8,0.66707e-06_r8 /)
      kbo(:, 5,41, 4) = (/ &
        & 0.11366e-08_r8,0.15630e-05_r8,0.21416e-05_r8,0.22404e-05_r8,0.71035e-06_r8 /)
      kbo(:, 1,42, 4) = (/ &
        & 0.10616e-08_r8,0.10273e-05_r8,0.14085e-05_r8,0.15034e-05_r8,0.43514e-06_r8 /)
      kbo(:, 2,42, 4) = (/ &
        & 0.10250e-08_r8,0.10997e-05_r8,0.15070e-05_r8,0.15973e-05_r8,0.47061e-06_r8 /)
      kbo(:, 3,42, 4) = (/ &
        & 0.99030e-09_r8,0.11679e-05_r8,0.15953e-05_r8,0.16861e-05_r8,0.50613e-06_r8 /)
      kbo(:, 4,42, 4) = (/ &
        & 0.96062e-09_r8,0.12272e-05_r8,0.16766e-05_r8,0.17642e-05_r8,0.54216e-06_r8 /)
      kbo(:, 5,42, 4) = (/ &
        & 0.93443e-09_r8,0.12817e-05_r8,0.17529e-05_r8,0.18333e-05_r8,0.57784e-06_r8 /)
      kbo(:, 1,43, 4) = (/ &
        & 0.87883e-09_r8,0.83199e-06_r8,0.11402e-05_r8,0.12168e-05_r8,0.35025e-06_r8 /)
      kbo(:, 2,43, 4) = (/ &
        & 0.84829e-09_r8,0.89254e-06_r8,0.12225e-05_r8,0.12958e-05_r8,0.37960e-06_r8 /)
      kbo(:, 3,43, 4) = (/ &
        & 0.81903e-09_r8,0.95072e-06_r8,0.12966e-05_r8,0.13708e-05_r8,0.40893e-06_r8 /)
      kbo(:, 4,43, 4) = (/ &
        & 0.79369e-09_r8,0.10020e-05_r8,0.13665e-05_r8,0.14379e-05_r8,0.43862e-06_r8 /)
      kbo(:, 5,43, 4) = (/ &
        & 0.77108e-09_r8,0.10478e-05_r8,0.14302e-05_r8,0.14962e-05_r8,0.46817e-06_r8 /)
      kbo(:, 1,44, 4) = (/ &
        & 0.72838e-09_r8,0.67080e-06_r8,0.91962e-06_r8,0.98102e-06_r8,0.28107e-06_r8 /)
      kbo(:, 2,44, 4) = (/ &
        & 0.70279e-09_r8,0.72271e-06_r8,0.98853e-06_r8,0.10491e-05_r8,0.30540e-06_r8 /)
      kbo(:, 3,44, 4) = (/ &
        & 0.67858e-09_r8,0.77203e-06_r8,0.10522e-05_r8,0.11122e-05_r8,0.32958e-06_r8 /)
      kbo(:, 4,44, 4) = (/ &
        & 0.65651e-09_r8,0.81625e-06_r8,0.11115e-05_r8,0.11697e-05_r8,0.35407e-06_r8 /)
      kbo(:, 5,44, 4) = (/ &
        & 0.63727e-09_r8,0.85495e-06_r8,0.11651e-05_r8,0.12192e-05_r8,0.37850e-06_r8 /)
      kbo(:, 1,45, 4) = (/ &
        & 0.60379e-09_r8,0.54047e-06_r8,0.74128e-06_r8,0.79100e-06_r8,0.22535e-06_r8 /)
      kbo(:, 2,45, 4) = (/ &
        & 0.58228e-09_r8,0.58429e-06_r8,0.79854e-06_r8,0.84841e-06_r8,0.24548e-06_r8 /)
      kbo(:, 3,45, 4) = (/ &
        & 0.56220e-09_r8,0.62606e-06_r8,0.85283e-06_r8,0.90157e-06_r8,0.26541e-06_r8 /)
      kbo(:, 4,45, 4) = (/ &
        & 0.54320e-09_r8,0.66423e-06_r8,0.90296e-06_r8,0.95015e-06_r8,0.28558e-06_r8 /)
      kbo(:, 5,45, 4) = (/ &
        & 0.52686e-09_r8,0.69719e-06_r8,0.94830e-06_r8,0.99254e-06_r8,0.30580e-06_r8 /)
      kbo(:, 1,46, 4) = (/ &
        & 0.50108e-09_r8,0.43361e-06_r8,0.59554e-06_r8,0.63432e-06_r8,0.18023e-06_r8 /)
      kbo(:, 2,46, 4) = (/ &
        & 0.48291e-09_r8,0.47127e-06_r8,0.64349e-06_r8,0.68510e-06_r8,0.19677e-06_r8 /)
      kbo(:, 3,46, 4) = (/ &
        & 0.46612e-09_r8,0.50621e-06_r8,0.68942e-06_r8,0.72929e-06_r8,0.21325e-06_r8 /)
      kbo(:, 4,46, 4) = (/ &
        & 0.45004e-09_r8,0.53903e-06_r8,0.73169e-06_r8,0.77095e-06_r8,0.22986e-06_r8 /)
      kbo(:, 5,46, 4) = (/ &
        & 0.43600e-09_r8,0.56740e-06_r8,0.77081e-06_r8,0.80714e-06_r8,0.24654e-06_r8 /)
      kbo(:, 1,47, 4) = (/ &
        & 0.41665e-09_r8,0.34614e-06_r8,0.47565e-06_r8,0.50598e-06_r8,0.14345e-06_r8 /)
      kbo(:, 2,47, 4) = (/ &
        & 0.40119e-09_r8,0.37779e-06_r8,0.51642e-06_r8,0.55015e-06_r8,0.15697e-06_r8 /)
      kbo(:, 3,47, 4) = (/ &
        & 0.38702e-09_r8,0.40752e-06_r8,0.55525e-06_r8,0.58759e-06_r8,0.17064e-06_r8 /)
      kbo(:, 4,47, 4) = (/ &
        & 0.37372e-09_r8,0.43563e-06_r8,0.59076e-06_r8,0.62318e-06_r8,0.18430e-06_r8 /)
      kbo(:, 5,47, 4) = (/ &
        & 0.36139e-09_r8,0.46041e-06_r8,0.62474e-06_r8,0.65515e-06_r8,0.19800e-06_r8 /)
      kbo(:, 1,48, 4) = (/ &
        & 0.34658e-09_r8,0.27494e-06_r8,0.37924e-06_r8,0.40349e-06_r8,0.11407e-06_r8 /)
      kbo(:, 2,48, 4) = (/ &
        & 0.33340e-09_r8,0.30243e-06_r8,0.41340e-06_r8,0.44066e-06_r8,0.12508e-06_r8 /)
      kbo(:, 3,48, 4) = (/ &
        & 0.32143e-09_r8,0.32756e-06_r8,0.44635e-06_r8,0.47308e-06_r8,0.13636e-06_r8 /)
      kbo(:, 4,48, 4) = (/ &
        & 0.31032e-09_r8,0.35149e-06_r8,0.47669e-06_r8,0.50309e-06_r8,0.14763e-06_r8 /)
      kbo(:, 5,48, 4) = (/ &
        & 0.29969e-09_r8,0.37323e-06_r8,0.50542e-06_r8,0.53062e-06_r8,0.15892e-06_r8 /)
      kbo(:, 1,49, 4) = (/ &
        & 0.28846e-09_r8,0.21778e-06_r8,0.30168e-06_r8,0.32158e-06_r8,0.90607e-07_r8 /)
      kbo(:, 2,49, 4) = (/ &
        & 0.27716e-09_r8,0.24139e-06_r8,0.33071e-06_r8,0.35214e-06_r8,0.99577e-07_r8 /)
      kbo(:, 3,49, 4) = (/ &
        & 0.26700e-09_r8,0.26304e-06_r8,0.35804e-06_r8,0.38049e-06_r8,0.10881e-06_r8 /)
      kbo(:, 4,49, 4) = (/ &
        & 0.25767e-09_r8,0.28313e-06_r8,0.38394e-06_r8,0.40566e-06_r8,0.11814e-06_r8 /)
      kbo(:, 5,49, 4) = (/ &
        & 0.24875e-09_r8,0.30183e-06_r8,0.40832e-06_r8,0.42906e-06_r8,0.12742e-06_r8 /)
      kbo(:, 1,50, 4) = (/ &
        & 0.23994e-09_r8,0.17276e-06_r8,0.24039e-06_r8,0.25644e-06_r8,0.72124e-07_r8 /)
      kbo(:, 2,50, 4) = (/ &
        & 0.23028e-09_r8,0.19275e-06_r8,0.26429e-06_r8,0.28117e-06_r8,0.79388e-07_r8 /)
      kbo(:, 3,50, 4) = (/ &
        & 0.22162e-09_r8,0.21106e-06_r8,0.28758e-06_r8,0.30606e-06_r8,0.86922e-07_r8 /)
      kbo(:, 4,50, 4) = (/ &
        & 0.21377e-09_r8,0.22807e-06_r8,0.30947e-06_r8,0.32714e-06_r8,0.94628e-07_r8 /)
      kbo(:, 5,50, 4) = (/ &
        & 0.20641e-09_r8,0.24400e-06_r8,0.32962e-06_r8,0.34715e-06_r8,0.10228e-06_r8 /)
      kbo(:, 1,51, 4) = (/ &
        & 0.19960e-09_r8,0.13709e-06_r8,0.19101e-06_r8,0.20407e-06_r8,0.57566e-07_r8 /)
      kbo(:, 2,51, 4) = (/ &
        & 0.19132e-09_r8,0.15352e-06_r8,0.21120e-06_r8,0.22455e-06_r8,0.63308e-07_r8 /)
      kbo(:, 3,51, 4) = (/ &
        & 0.18395e-09_r8,0.16924e-06_r8,0.23068e-06_r8,0.24563e-06_r8,0.69421e-07_r8 /)
      kbo(:, 4,51, 4) = (/ &
        & 0.17732e-09_r8,0.18352e-06_r8,0.24926e-06_r8,0.26383e-06_r8,0.75773e-07_r8 /)
      kbo(:, 5,51, 4) = (/ &
        & 0.17117e-09_r8,0.19715e-06_r8,0.26630e-06_r8,0.28068e-06_r8,0.82097e-07_r8 /)
      kbo(:, 1,52, 4) = (/ &
        & 0.16616e-09_r8,0.10852e-06_r8,0.15191e-06_r8,0.16137e-06_r8,0.45975e-07_r8 /)
      kbo(:, 2,52, 4) = (/ &
        & 0.15901e-09_r8,0.12188e-06_r8,0.16855e-06_r8,0.17943e-06_r8,0.50454e-07_r8 /)
      kbo(:, 3,52, 4) = (/ &
        & 0.15272e-09_r8,0.13535e-06_r8,0.18502e-06_r8,0.19705e-06_r8,0.55424e-07_r8 /)
      kbo(:, 4,52, 4) = (/ &
        & 0.14711e-09_r8,0.14765e-06_r8,0.20042e-06_r8,0.21252e-06_r8,0.60616e-07_r8 /)
      kbo(:, 5,52, 4) = (/ &
        & 0.14194e-09_r8,0.15907e-06_r8,0.21484e-06_r8,0.22673e-06_r8,0.65826e-07_r8 /)
      kbo(:, 1,53, 4) = (/ &
        & 0.13839e-09_r8,0.85704e-07_r8,0.12023e-06_r8,0.12744e-06_r8,0.36523e-07_r8 /)
      kbo(:, 2,53, 4) = (/ &
        & 0.13223e-09_r8,0.96600e-07_r8,0.13438e-06_r8,0.14312e-06_r8,0.40152e-07_r8 /)
      kbo(:, 3,53, 4) = (/ &
        & 0.12684e-09_r8,0.10804e-06_r8,0.14784e-06_r8,0.15735e-06_r8,0.44207e-07_r8 /)
      kbo(:, 4,53, 4) = (/ &
        & 0.12208e-09_r8,0.11851e-06_r8,0.16093e-06_r8,0.17108e-06_r8,0.48435e-07_r8 /)
      kbo(:, 5,53, 4) = (/ &
        & 0.11772e-09_r8,0.12811e-06_r8,0.17313e-06_r8,0.18293e-06_r8,0.52733e-07_r8 /)
      kbo(:, 1,54, 4) = (/ &
        & 0.11516e-09_r8,0.67802e-07_r8,0.95400e-07_r8,0.10065e-06_r8,0.29040e-07_r8 /)
      kbo(:, 2,54, 4) = (/ &
        & 0.10986e-09_r8,0.76927e-07_r8,0.10712e-06_r8,0.11428e-06_r8,0.32044e-07_r8 /)
      kbo(:, 3,54, 4) = (/ &
        & 0.10526e-09_r8,0.86295e-07_r8,0.11833e-06_r8,0.12580e-06_r8,0.35335e-07_r8 /)
      kbo(:, 4,54, 4) = (/ &
        & 0.10122e-09_r8,0.95190e-07_r8,0.12936e-06_r8,0.13763e-06_r8,0.38764e-07_r8 /)
      kbo(:, 5,54, 4) = (/ &
        & 0.97545e-10_r8,0.10324e-06_r8,0.13969e-06_r8,0.14768e-06_r8,0.42312e-07_r8 /)
      kbo(:, 1,55, 4) = (/ &
        & 0.95832e-10_r8,0.53610e-07_r8,0.75981e-07_r8,0.79667e-07_r8,0.23117e-07_r8 /)
      kbo(:, 2,55, 4) = (/ &
        & 0.91281e-10_r8,0.61130e-07_r8,0.85329e-07_r8,0.91005e-07_r8,0.25657e-07_r8 /)
      kbo(:, 3,55, 4) = (/ &
        & 0.87335e-10_r8,0.68825e-07_r8,0.94736e-07_r8,0.10075e-06_r8,0.28264e-07_r8 /)
      kbo(:, 4,55, 4) = (/ &
        & 0.83897e-10_r8,0.76435e-07_r8,0.10396e-06_r8,0.11070e-06_r8,0.31057e-07_r8 /)
      kbo(:, 5,55, 4) = (/ &
        & 0.80810e-10_r8,0.83278e-07_r8,0.11269e-06_r8,0.11928e-06_r8,0.33972e-07_r8 /)
      kbo(:, 1,56, 4) = (/ &
        & 0.79810e-10_r8,0.42322e-07_r8,0.60374e-07_r8,0.62926e-07_r8,0.18404e-07_r8 /)
      kbo(:, 2,56, 4) = (/ &
        & 0.75864e-10_r8,0.48559e-07_r8,0.68039e-07_r8,0.72241e-07_r8,0.20548e-07_r8 /)
      kbo(:, 3,56, 4) = (/ &
        & 0.72485e-10_r8,0.54773e-07_r8,0.75799e-07_r8,0.80757e-07_r8,0.22581e-07_r8 /)
      kbo(:, 4,56, 4) = (/ &
        & 0.69560e-10_r8,0.61224e-07_r8,0.83554e-07_r8,0.88967e-07_r8,0.24859e-07_r8 /)
      kbo(:, 5,56, 4) = (/ &
        & 0.66951e-10_r8,0.67084e-07_r8,0.90797e-07_r8,0.96246e-07_r8,0.27245e-07_r8 /)
      kbo(:, 1,57, 4) = (/ &
        & 0.66524e-10_r8,0.33320e-07_r8,0.47516e-07_r8,0.49541e-07_r8,0.14620e-07_r8 /)
      kbo(:, 2,57, 4) = (/ &
        & 0.63081e-10_r8,0.38443e-07_r8,0.54027e-07_r8,0.57142e-07_r8,0.16370e-07_r8 /)
      kbo(:, 3,57, 4) = (/ &
        & 0.60187e-10_r8,0.43587e-07_r8,0.60611e-07_r8,0.64608e-07_r8,0.18036e-07_r8 /)
      kbo(:, 4,57, 4) = (/ &
        & 0.57689e-10_r8,0.48970e-07_r8,0.66915e-07_r8,0.71233e-07_r8,0.19895e-07_r8 /)
      kbo(:, 5,57, 4) = (/ &
        & 0.55478e-10_r8,0.53925e-07_r8,0.73045e-07_r8,0.77618e-07_r8,0.21831e-07_r8 /)
      kbo(:, 1,58, 4) = (/ &
        & 0.55447e-10_r8,0.26240e-07_r8,0.37435e-07_r8,0.38989e-07_r8,0.11606e-07_r8 /)
      kbo(:, 2,58, 4) = (/ &
        & 0.52442e-10_r8,0.30460e-07_r8,0.42955e-07_r8,0.45233e-07_r8,0.13047e-07_r8 /)
      kbo(:, 3,58, 4) = (/ &
        & 0.49962e-10_r8,0.34761e-07_r8,0.48418e-07_r8,0.51680e-07_r8,0.14431e-07_r8 /)
      kbo(:, 4,58, 4) = (/ &
        & 0.47826e-10_r8,0.39152e-07_r8,0.53626e-07_r8,0.57047e-07_r8,0.15934e-07_r8 /)
      kbo(:, 5,58, 4) = (/ &
        & 0.45954e-10_r8,0.43380e-07_r8,0.58786e-07_r8,0.62538e-07_r8,0.17511e-07_r8 /)
      kbo(:, 1,59, 4) = (/ &
        & 0.45740e-10_r8,0.21248e-07_r8,0.30261e-07_r8,0.31577e-07_r8,0.94221e-08_r8 /)
      kbo(:, 2,59, 4) = (/ &
        & 0.43210e-10_r8,0.24730e-07_r8,0.34948e-07_r8,0.36722e-07_r8,0.10608e-07_r8 /)
      kbo(:, 3,59, 4) = (/ &
        & 0.41141e-10_r8,0.28288e-07_r8,0.39410e-07_r8,0.42052e-07_r8,0.11754e-07_r8 /)
      kbo(:, 4,59, 4) = (/ &
        & 0.39361e-10_r8,0.31904e-07_r8,0.43740e-07_r8,0.46527e-07_r8,0.12986e-07_r8 /)
      kbo(:, 5,59, 4) = (/ &
        & 0.37805e-10_r8,0.35442e-07_r8,0.48020e-07_r8,0.51083e-07_r8,0.14278e-07_r8 /)
      kbo(:, 1,13, 5) = (/ &
        & 0.79045e-05_r8,0.58512e-03_r8,0.80967e-03_r8,0.88578e-03_r8,0.34824e-03_r8 /)
      kbo(:, 2,13, 5) = (/ &
        & 0.92807e-05_r8,0.61818e-03_r8,0.86083e-03_r8,0.92437e-03_r8,0.37870e-03_r8 /)
      kbo(:, 3,13, 5) = (/ &
        & 0.10620e-04_r8,0.65025e-03_r8,0.90617e-03_r8,0.96290e-03_r8,0.40639e-03_r8 /)
      kbo(:, 4,13, 5) = (/ &
        & 0.11847e-04_r8,0.68086e-03_r8,0.94767e-03_r8,0.99815e-03_r8,0.43149e-03_r8 /)
      kbo(:, 5,13, 5) = (/ &
        & 0.12897e-04_r8,0.70941e-03_r8,0.98426e-03_r8,0.10296e-02_r8,0.45459e-03_r8 /)
      kbo(:, 1,14, 5) = (/ &
        & 0.65683e-05_r8,0.48798e-03_r8,0.67570e-03_r8,0.73755e-03_r8,0.29172e-03_r8 /)
      kbo(:, 2,14, 5) = (/ &
        & 0.76957e-05_r8,0.51555e-03_r8,0.71856e-03_r8,0.76978e-03_r8,0.31709e-03_r8 /)
      kbo(:, 3,14, 5) = (/ &
        & 0.87852e-05_r8,0.54243e-03_r8,0.75604e-03_r8,0.80142e-03_r8,0.34064e-03_r8 /)
      kbo(:, 4,14, 5) = (/ &
        & 0.97622e-05_r8,0.56817e-03_r8,0.79038e-03_r8,0.83091e-03_r8,0.36095e-03_r8 /)
      kbo(:, 5,14, 5) = (/ &
        & 0.10614e-04_r8,0.59208e-03_r8,0.82018e-03_r8,0.85691e-03_r8,0.38095e-03_r8 /)
      kbo(:, 1,15, 5) = (/ &
        & 0.54643e-05_r8,0.40660e-03_r8,0.56371e-03_r8,0.61286e-03_r8,0.24435e-03_r8 /)
      kbo(:, 2,15, 5) = (/ &
        & 0.63883e-05_r8,0.42973e-03_r8,0.59914e-03_r8,0.64093e-03_r8,0.26475e-03_r8 /)
      kbo(:, 3,15, 5) = (/ &
        & 0.72593e-05_r8,0.45218e-03_r8,0.63004e-03_r8,0.66659e-03_r8,0.28486e-03_r8 /)
      kbo(:, 4,15, 5) = (/ &
        & 0.80526e-05_r8,0.47373e-03_r8,0.65847e-03_r8,0.69128e-03_r8,0.30200e-03_r8 /)
      kbo(:, 5,15, 5) = (/ &
        & 0.87364e-05_r8,0.49393e-03_r8,0.68318e-03_r8,0.71321e-03_r8,0.31930e-03_r8 /)
      kbo(:, 1,16, 5) = (/ &
        & 0.45482e-05_r8,0.33872e-03_r8,0.47003e-03_r8,0.50920e-03_r8,0.20473e-03_r8 /)
      kbo(:, 2,16, 5) = (/ &
        & 0.52893e-05_r8,0.35785e-03_r8,0.49898e-03_r8,0.53306e-03_r8,0.22171e-03_r8 /)
      kbo(:, 3,16, 5) = (/ &
        & 0.59989e-05_r8,0.37673e-03_r8,0.52467e-03_r8,0.55461e-03_r8,0.23803e-03_r8 /)
      kbo(:, 4,16, 5) = (/ &
        & 0.66426e-05_r8,0.39470e-03_r8,0.54827e-03_r8,0.57515e-03_r8,0.25244e-03_r8 /)
      kbo(:, 5,16, 5) = (/ &
        & 0.71759e-05_r8,0.41193e-03_r8,0.56909e-03_r8,0.59361e-03_r8,0.26773e-03_r8 /)
      kbo(:, 1,17, 5) = (/ &
        & 0.37690e-05_r8,0.28177e-03_r8,0.39153e-03_r8,0.42265e-03_r8,0.17155e-03_r8 /)
      kbo(:, 2,17, 5) = (/ &
        & 0.43790e-05_r8,0.29778e-03_r8,0.41535e-03_r8,0.44288e-03_r8,0.18563e-03_r8 /)
      kbo(:, 3,17, 5) = (/ &
        & 0.49545e-05_r8,0.31371e-03_r8,0.43664e-03_r8,0.46090e-03_r8,0.19908e-03_r8 /)
      kbo(:, 4,17, 5) = (/ &
        & 0.54563e-05_r8,0.32886e-03_r8,0.45637e-03_r8,0.47854e-03_r8,0.21097e-03_r8 /)
      kbo(:, 5,17, 5) = (/ &
        & 0.58879e-05_r8,0.34359e-03_r8,0.47416e-03_r8,0.49387e-03_r8,0.22440e-03_r8 /)
      kbo(:, 1,18, 5) = (/ &
        & 0.31260e-05_r8,0.23432e-03_r8,0.32596e-03_r8,0.35082e-03_r8,0.14348e-03_r8 /)
      kbo(:, 2,18, 5) = (/ &
        & 0.36185e-05_r8,0.24786e-03_r8,0.34561e-03_r8,0.36765e-03_r8,0.15546e-03_r8 /)
      kbo(:, 3,18, 5) = (/ &
        & 0.40732e-05_r8,0.26120e-03_r8,0.36343e-03_r8,0.38325e-03_r8,0.16623e-03_r8 /)
      kbo(:, 4,18, 5) = (/ &
        & 0.44839e-05_r8,0.27403e-03_r8,0.37997e-03_r8,0.39811e-03_r8,0.17659e-03_r8 /)
      kbo(:, 5,18, 5) = (/ &
        & 0.48304e-05_r8,0.28674e-03_r8,0.39513e-03_r8,0.41114e-03_r8,0.18813e-03_r8 /)
      kbo(:, 1,19, 5) = (/ &
        & 0.25853e-05_r8,0.19483e-03_r8,0.27128e-03_r8,0.29126e-03_r8,0.11969e-03_r8 /)
      kbo(:, 2,19, 5) = (/ &
        & 0.29834e-05_r8,0.20623e-03_r8,0.28749e-03_r8,0.30541e-03_r8,0.12978e-03_r8 /)
      kbo(:, 3,19, 5) = (/ &
        & 0.33546e-05_r8,0.21750e-03_r8,0.30267e-03_r8,0.31871e-03_r8,0.13874e-03_r8 /)
      kbo(:, 4,19, 5) = (/ &
        & 0.36863e-05_r8,0.22842e-03_r8,0.31656e-03_r8,0.33115e-03_r8,0.14789e-03_r8 /)
      kbo(:, 5,19, 5) = (/ &
        & 0.39634e-05_r8,0.23942e-03_r8,0.32944e-03_r8,0.34220e-03_r8,0.15742e-03_r8 /)
      kbo(:, 1,20, 5) = (/ &
        & 0.21486e-05_r8,0.16221e-03_r8,0.22609e-03_r8,0.24236e-03_r8,0.10014e-03_r8 /)
      kbo(:, 2,20, 5) = (/ &
        & 0.24735e-05_r8,0.17178e-03_r8,0.23949e-03_r8,0.25399e-03_r8,0.10857e-03_r8 /)
      kbo(:, 3,20, 5) = (/ &
        & 0.27744e-05_r8,0.18136e-03_r8,0.25226e-03_r8,0.26535e-03_r8,0.11604e-03_r8 /)
      kbo(:, 4,20, 5) = (/ &
        & 0.30414e-05_r8,0.19076e-03_r8,0.26397e-03_r8,0.27566e-03_r8,0.12398e-03_r8 /)
      kbo(:, 5,20, 5) = (/ &
        & 0.32610e-05_r8,0.20019e-03_r8,0.27488e-03_r8,0.28510e-03_r8,0.13199e-03_r8 /)
      kbo(:, 1,21, 5) = (/ &
        & 0.17877e-05_r8,0.13507e-03_r8,0.18845e-03_r8,0.20163e-03_r8,0.83879e-04_r8 /)
      kbo(:, 2,21, 5) = (/ &
        & 0.20518e-05_r8,0.14319e-03_r8,0.19968e-03_r8,0.21134e-03_r8,0.90858e-04_r8 /)
      kbo(:, 3,21, 5) = (/ &
        & 0.22953e-05_r8,0.15137e-03_r8,0.21038e-03_r8,0.22094e-03_r8,0.97098e-04_r8 /)
      kbo(:, 4,21, 5) = (/ &
        & 0.25098e-05_r8,0.15947e-03_r8,0.22019e-03_r8,0.22948e-03_r8,0.10402e-03_r8 /)
      kbo(:, 5,21, 5) = (/ &
        & 0.26830e-05_r8,0.16749e-03_r8,0.22950e-03_r8,0.23761e-03_r8,0.11069e-03_r8 /)
      kbo(:, 1,22, 5) = (/ &
        & 0.15022e-05_r8,0.11297e-03_r8,0.15773e-03_r8,0.16819e-03_r8,0.70808e-04_r8 /)
      kbo(:, 2,22, 5) = (/ &
        & 0.17157e-05_r8,0.11998e-03_r8,0.16714e-03_r8,0.17644e-03_r8,0.76345e-04_r8 /)
      kbo(:, 3,22, 5) = (/ &
        & 0.19111e-05_r8,0.12690e-03_r8,0.17611e-03_r8,0.18454e-03_r8,0.81804e-04_r8 /)
      kbo(:, 4,22, 5) = (/ &
        & 0.20812e-05_r8,0.13385e-03_r8,0.18425e-03_r8,0.19164e-03_r8,0.87591e-04_r8 /)
      kbo(:, 5,22, 5) = (/ &
        & 0.22144e-05_r8,0.14066e-03_r8,0.19235e-03_r8,0.19867e-03_r8,0.93228e-04_r8 /)
      kbo(:, 1,23, 5) = (/ &
        & 0.12621e-05_r8,0.94681e-04_r8,0.13210e-03_r8,0.14032e-03_r8,0.59630e-04_r8 /)
      kbo(:, 2,23, 5) = (/ &
        & 0.14346e-05_r8,0.10061e-03_r8,0.14009e-03_r8,0.14751e-03_r8,0.64142e-04_r8 /)
      kbo(:, 3,23, 5) = (/ &
        & 0.15908e-05_r8,0.10655e-03_r8,0.14749e-03_r8,0.15413e-03_r8,0.68988e-04_r8 /)
      kbo(:, 4,23, 5) = (/ &
        & 0.17253e-05_r8,0.11246e-03_r8,0.15437e-03_r8,0.16013e-03_r8,0.73893e-04_r8 /)
      kbo(:, 5,23, 5) = (/ &
        & 0.18272e-05_r8,0.11825e-03_r8,0.16130e-03_r8,0.16627e-03_r8,0.78649e-04_r8 /)
      kbo(:, 1,24, 5) = (/ &
        & 0.10611e-05_r8,0.79419e-04_r8,0.11079e-03_r8,0.11736e-03_r8,0.50244e-04_r8 /)
      kbo(:, 2,24, 5) = (/ &
        & 0.11996e-05_r8,0.84486e-04_r8,0.11749e-03_r8,0.12345e-03_r8,0.54054e-04_r8 /)
      kbo(:, 3,24, 5) = (/ &
        & 0.13241e-05_r8,0.89565e-04_r8,0.12364e-03_r8,0.12883e-03_r8,0.58259e-04_r8 /)
      kbo(:, 4,24, 5) = (/ &
        & 0.14300e-05_r8,0.94592e-04_r8,0.12949e-03_r8,0.13406e-03_r8,0.62300e-04_r8 /)
      kbo(:, 5,24, 5) = (/ &
        & 0.15070e-05_r8,0.99545e-04_r8,0.13538e-03_r8,0.13928e-03_r8,0.66485e-04_r8 /)
      kbo(:, 1,25, 5) = (/ &
        & 0.89248e-06_r8,0.66757e-04_r8,0.93043e-04_r8,0.98269e-04_r8,0.42396e-04_r8 /)
      kbo(:, 2,25, 5) = (/ &
        & 0.10034e-05_r8,0.71082e-04_r8,0.98652e-04_r8,0.10332e-03_r8,0.45719e-04_r8 /)
      kbo(:, 3,25, 5) = (/ &
        & 0.11024e-05_r8,0.75404e-04_r8,0.10375e-03_r8,0.10782e-03_r8,0.49228e-04_r8 /)
      kbo(:, 4,25, 5) = (/ &
        & 0.11835e-05_r8,0.79694e-04_r8,0.10882e-03_r8,0.11234e-03_r8,0.52649e-04_r8 /)
      kbo(:, 5,25, 5) = (/ &
        & 0.12406e-05_r8,0.83915e-04_r8,0.11376e-03_r8,0.11677e-03_r8,0.56264e-04_r8 /)
      kbo(:, 1,26, 5) = (/ &
        & 0.75147e-06_r8,0.56248e-04_r8,0.78291e-04_r8,0.82441e-04_r8,0.35781e-04_r8 /)
      kbo(:, 2,26, 5) = (/ &
        & 0.84025e-06_r8,0.59929e-04_r8,0.82917e-04_r8,0.86562e-04_r8,0.38715e-04_r8 /)
      kbo(:, 3,26, 5) = (/ &
        & 0.91728e-06_r8,0.63618e-04_r8,0.87231e-04_r8,0.90442e-04_r8,0.41682e-04_r8 /)
      kbo(:, 4,26, 5) = (/ &
        & 0.97947e-06_r8,0.67285e-04_r8,0.91606e-04_r8,0.94311e-04_r8,0.44610e-04_r8 /)
      kbo(:, 5,26, 5) = (/ &
        & 0.10222e-05_r8,0.70879e-04_r8,0.95759e-04_r8,0.97954e-04_r8,0.47678e-04_r8 /)
      kbo(:, 1,27, 5) = (/ &
        & 0.63228e-06_r8,0.47448e-04_r8,0.65926e-04_r8,0.69211e-04_r8,0.30312e-04_r8 /)
      kbo(:, 2,27, 5) = (/ &
        & 0.70187e-06_r8,0.50583e-04_r8,0.69752e-04_r8,0.72622e-04_r8,0.32844e-04_r8 /)
      kbo(:, 3,27, 5) = (/ &
        & 0.76263e-06_r8,0.53723e-04_r8,0.73431e-04_r8,0.75943e-04_r8,0.35283e-04_r8 /)
      kbo(:, 4,27, 5) = (/ &
        & 0.80975e-06_r8,0.56884e-04_r8,0.77139e-04_r8,0.79235e-04_r8,0.37837e-04_r8 /)
      kbo(:, 5,27, 5) = (/ &
        & 0.84099e-06_r8,0.59937e-04_r8,0.80670e-04_r8,0.82198e-04_r8,0.40398e-04_r8 /)
      kbo(:, 1,28, 5) = (/ &
        & 0.53062e-06_r8,0.40054e-04_r8,0.55536e-04_r8,0.58105e-04_r8,0.25683e-04_r8 /)
      kbo(:, 2,28, 5) = (/ &
        & 0.58581e-06_r8,0.42748e-04_r8,0.58719e-04_r8,0.60988e-04_r8,0.27829e-04_r8 /)
      kbo(:, 3,28, 5) = (/ &
        & 0.63283e-06_r8,0.45445e-04_r8,0.61927e-04_r8,0.63808e-04_r8,0.29914e-04_r8 /)
      kbo(:, 4,28, 5) = (/ &
        & 0.66841e-06_r8,0.48141e-04_r8,0.65033e-04_r8,0.66567e-04_r8,0.32101e-04_r8 /)
      kbo(:, 5,28, 5) = (/ &
        & 0.69132e-06_r8,0.50744e-04_r8,0.68002e-04_r8,0.69024e-04_r8,0.34196e-04_r8 /)
      kbo(:, 1,29, 5) = (/ &
        & 0.44482e-06_r8,0.33876e-04_r8,0.46813e-04_r8,0.48820e-04_r8,0.21822e-04_r8 /)
      kbo(:, 2,29, 5) = (/ &
        & 0.48830e-06_r8,0.36173e-04_r8,0.49534e-04_r8,0.51267e-04_r8,0.23598e-04_r8 /)
      kbo(:, 3,29, 5) = (/ &
        & 0.52520e-06_r8,0.38507e-04_r8,0.52264e-04_r8,0.53700e-04_r8,0.25407e-04_r8 /)
      kbo(:, 4,29, 5) = (/ &
        & 0.55142e-06_r8,0.40790e-04_r8,0.54879e-04_r8,0.55934e-04_r8,0.27233e-04_r8 /)
      kbo(:, 5,29, 5) = (/ &
        & 0.56821e-06_r8,0.43005e-04_r8,0.57374e-04_r8,0.57995e-04_r8,0.28939e-04_r8 /)
      kbo(:, 1,30, 5) = (/ &
        & 0.37240e-06_r8,0.28688e-04_r8,0.39498e-04_r8,0.41082e-04_r8,0.18542e-04_r8 /)
      kbo(:, 2,30, 5) = (/ &
        & 0.40697e-06_r8,0.30662e-04_r8,0.41832e-04_r8,0.43139e-04_r8,0.20037e-04_r8 /)
      kbo(:, 3,30, 5) = (/ &
        & 0.43518e-06_r8,0.32657e-04_r8,0.44137e-04_r8,0.45198e-04_r8,0.21592e-04_r8 /)
      kbo(:, 4,30, 5) = (/ &
        & 0.45459e-06_r8,0.34600e-04_r8,0.46342e-04_r8,0.47030e-04_r8,0.23099e-04_r8 /)
      kbo(:, 5,30, 5) = (/ &
        & 0.46674e-06_r8,0.36468e-04_r8,0.48427e-04_r8,0.48752e-04_r8,0.24524e-04_r8 /)
      kbo(:, 1,31, 5) = (/ &
        & 0.31167e-06_r8,0.24328e-04_r8,0.33365e-04_r8,0.34577e-04_r8,0.15775e-04_r8 /)
      kbo(:, 2,31, 5) = (/ &
        & 0.33880e-06_r8,0.26033e-04_r8,0.35376e-04_r8,0.36343e-04_r8,0.17037e-04_r8 /)
      kbo(:, 3,31, 5) = (/ &
        & 0.36022e-06_r8,0.27728e-04_r8,0.37306e-04_r8,0.38025e-04_r8,0.18334e-04_r8 /)
      kbo(:, 4,31, 5) = (/ &
        & 0.37443e-06_r8,0.29381e-04_r8,0.39153e-04_r8,0.39551e-04_r8,0.19559e-04_r8 /)
      kbo(:, 5,31, 5) = (/ &
        & 0.38304e-06_r8,0.30940e-04_r8,0.40888e-04_r8,0.41012e-04_r8,0.20735e-04_r8 /)
      kbo(:, 1,32, 5) = (/ &
        & 0.26065e-06_r8,0.20666e-04_r8,0.28226e-04_r8,0.29128e-04_r8,0.13403e-04_r8 /)
      kbo(:, 2,32, 5) = (/ &
        & 0.28179e-06_r8,0.22130e-04_r8,0.29934e-04_r8,0.30642e-04_r8,0.14495e-04_r8 /)
      kbo(:, 3,32, 5) = (/ &
        & 0.29791e-06_r8,0.23572e-04_r8,0.31554e-04_r8,0.32005e-04_r8,0.15576e-04_r8 /)
      kbo(:, 4,32, 5) = (/ &
        & 0.30813e-06_r8,0.24963e-04_r8,0.33101e-04_r8,0.33278e-04_r8,0.16582e-04_r8 /)
      kbo(:, 5,32, 5) = (/ &
        & 0.31412e-06_r8,0.26261e-04_r8,0.34510e-04_r8,0.34497e-04_r8,0.17533e-04_r8 /)
      kbo(:, 1,33, 5) = (/ &
        & 0.21768e-06_r8,0.17581e-04_r8,0.23903e-04_r8,0.24558e-04_r8,0.11405e-04_r8 /)
      kbo(:, 2,33, 5) = (/ &
        & 0.23409e-06_r8,0.18827e-04_r8,0.25333e-04_r8,0.25812e-04_r8,0.12331e-04_r8 /)
      kbo(:, 3,33, 5) = (/ &
        & 0.24596e-06_r8,0.20053e-04_r8,0.26696e-04_r8,0.26942e-04_r8,0.13200e-04_r8 /)
      kbo(:, 4,33, 5) = (/ &
        & 0.25338e-06_r8,0.21211e-04_r8,0.27978e-04_r8,0.28012e-04_r8,0.14037e-04_r8 /)
      kbo(:, 5,33, 5) = (/ &
        & 0.25735e-06_r8,0.22292e-04_r8,0.29113e-04_r8,0.29019e-04_r8,0.14789e-04_r8 /)
      kbo(:, 1,34, 5) = (/ &
        & 0.18111e-06_r8,0.14933e-04_r8,0.20221e-04_r8,0.20691e-04_r8,0.96853e-05_r8 /)
      kbo(:, 2,34, 5) = (/ &
        & 0.19373e-06_r8,0.15993e-04_r8,0.21413e-04_r8,0.21708e-04_r8,0.10459e-04_r8 /)
      kbo(:, 3,34, 5) = (/ &
        & 0.20262e-06_r8,0.17025e-04_r8,0.22551e-04_r8,0.22651e-04_r8,0.11170e-04_r8 /)
      kbo(:, 4,34, 5) = (/ &
        & 0.20802e-06_r8,0.17992e-04_r8,0.23603e-04_r8,0.23540e-04_r8,0.11847e-04_r8 /)
      kbo(:, 5,34, 5) = (/ &
        & 0.21068e-06_r8,0.18892e-04_r8,0.24522e-04_r8,0.24370e-04_r8,0.12444e-04_r8 /)
      kbo(:, 1,35, 5) = (/ &
        & 0.14940e-06_r8,0.12604e-04_r8,0.17001e-04_r8,0.17339e-04_r8,0.81630e-05_r8 /)
      kbo(:, 2,35, 5) = (/ &
        & 0.15934e-06_r8,0.13505e-04_r8,0.18008e-04_r8,0.18183e-04_r8,0.87890e-05_r8 /)
      kbo(:, 3,35, 5) = (/ &
        & 0.16626e-06_r8,0.14374e-04_r8,0.18963e-04_r8,0.18976e-04_r8,0.93838e-05_r8 /)
      kbo(:, 4,35, 5) = (/ &
        & 0.17040e-06_r8,0.15187e-04_r8,0.19824e-04_r8,0.19720e-04_r8,0.99229e-05_r8 /)
      kbo(:, 5,35, 5) = (/ &
        & 0.17229e-06_r8,0.15939e-04_r8,0.20582e-04_r8,0.20394e-04_r8,0.10412e-04_r8 /)
      kbo(:, 1,36, 5) = (/ &
        & 0.12224e-06_r8,0.10560e-04_r8,0.14203e-04_r8,0.14447e-04_r8,0.68196e-05_r8 /)
      kbo(:, 2,36, 5) = (/ &
        & 0.13030e-06_r8,0.11326e-04_r8,0.15055e-04_r8,0.15156e-04_r8,0.73321e-05_r8 /)
      kbo(:, 3,36, 5) = (/ &
        & 0.13590e-06_r8,0.12062e-04_r8,0.15856e-04_r8,0.15823e-04_r8,0.78230e-05_r8 /)
      kbo(:, 4,36, 5) = (/ &
        & 0.13929e-06_r8,0.12750e-04_r8,0.16573e-04_r8,0.16449e-04_r8,0.82632e-05_r8 /)
      kbo(:, 5,36, 5) = (/ &
        & 0.14081e-06_r8,0.13384e-04_r8,0.17208e-04_r8,0.17006e-04_r8,0.86656e-05_r8 /)
      kbo(:, 1,37, 5) = (/ &
        & 0.98979e-07_r8,0.87500e-05_r8,0.11755e-04_r8,0.11943e-04_r8,0.56269e-05_r8 /)
      kbo(:, 2,37, 5) = (/ &
        & 0.10583e-06_r8,0.94035e-05_r8,0.12480e-04_r8,0.12544e-04_r8,0.60528e-05_r8 /)
      kbo(:, 3,37, 5) = (/ &
        & 0.11068e-06_r8,0.10031e-04_r8,0.13161e-04_r8,0.13110e-04_r8,0.64604e-05_r8 /)
      kbo(:, 4,37, 5) = (/ &
        & 0.11365e-06_r8,0.10619e-04_r8,0.13767e-04_r8,0.13642e-04_r8,0.68253e-05_r8 /)
      kbo(:, 5,37, 5) = (/ &
        & 0.11510e-06_r8,0.11162e-04_r8,0.14306e-04_r8,0.14108e-04_r8,0.71615e-05_r8 /)
      kbo(:, 1,38, 5) = (/ &
        & 0.80050e-07_r8,0.72436e-05_r8,0.97225e-05_r8,0.98657e-05_r8,0.46375e-05_r8 /)
      kbo(:, 2,38, 5) = (/ &
        & 0.85886e-07_r8,0.78006e-05_r8,0.10338e-04_r8,0.10378e-04_r8,0.49919e-05_r8 /)
      kbo(:, 3,38, 5) = (/ &
        & 0.90108e-07_r8,0.83355e-05_r8,0.10916e-04_r8,0.10856e-04_r8,0.53303e-05_r8 /)
      kbo(:, 4,38, 5) = (/ &
        & 0.92690e-07_r8,0.88380e-05_r8,0.11429e-04_r8,0.11306e-04_r8,0.56349e-05_r8 /)
      kbo(:, 5,38, 5) = (/ &
        & 0.94046e-07_r8,0.93019e-05_r8,0.11885e-04_r8,0.11696e-04_r8,0.59152e-05_r8 /)
      kbo(:, 1,39, 5) = (/ &
        & 0.64720e-07_r8,0.59955e-05_r8,0.80389e-05_r8,0.81488e-05_r8,0.38192e-05_r8 /)
      kbo(:, 2,39, 5) = (/ &
        & 0.69663e-07_r8,0.64699e-05_r8,0.85613e-05_r8,0.85818e-05_r8,0.41159e-05_r8 /)
      kbo(:, 3,39, 5) = (/ &
        & 0.73305e-07_r8,0.69246e-05_r8,0.90506e-05_r8,0.89861e-05_r8,0.43968e-05_r8 /)
      kbo(:, 4,39, 5) = (/ &
        & 0.75588e-07_r8,0.73530e-05_r8,0.94857e-05_r8,0.93637e-05_r8,0.46505e-05_r8 /)
      kbo(:, 5,39, 5) = (/ &
        & 0.76825e-07_r8,0.77492e-05_r8,0.98708e-05_r8,0.96898e-05_r8,0.48841e-05_r8 /)
      kbo(:, 1,40, 5) = (/ &
        & 0.51871e-07_r8,0.49191e-05_r8,0.65994e-05_r8,0.66890e-05_r8,0.31186e-05_r8 /)
      kbo(:, 2,40, 5) = (/ &
        & 0.56127e-07_r8,0.53227e-05_r8,0.70435e-05_r8,0.70578e-05_r8,0.33678e-05_r8 /)
      kbo(:, 3,40, 5) = (/ &
        & 0.59395e-07_r8,0.57124e-05_r8,0.74609e-05_r8,0.74018e-05_r8,0.36025e-05_r8 /)
      kbo(:, 4,40, 5) = (/ &
        & 0.61501e-07_r8,0.60790e-05_r8,0.78333e-05_r8,0.77210e-05_r8,0.38164e-05_r8 /)
      kbo(:, 5,40, 5) = (/ &
        & 0.62710e-07_r8,0.64194e-05_r8,0.81613e-05_r8,0.79980e-05_r8,0.40122e-05_r8 /)
      kbo(:, 1,41, 5) = (/ &
        & 0.41471e-07_r8,0.40276e-05_r8,0.54076e-05_r8,0.54815e-05_r8,0.25402e-05_r8 /)
      kbo(:, 2,41, 5) = (/ &
        & 0.45127e-07_r8,0.43711e-05_r8,0.57847e-05_r8,0.57971e-05_r8,0.27507e-05_r8 /)
      kbo(:, 3,41, 5) = (/ &
        & 0.48018e-07_r8,0.47040e-05_r8,0.61407e-05_r8,0.60883e-05_r8,0.29479e-05_r8 /)
      kbo(:, 4,41, 5) = (/ &
        & 0.49983e-07_r8,0.50177e-05_r8,0.64595e-05_r8,0.63587e-05_r8,0.31286e-05_r8 /)
      kbo(:, 5,41, 5) = (/ &
        & 0.51153e-07_r8,0.53098e-05_r8,0.67389e-05_r8,0.65950e-05_r8,0.32928e-05_r8 /)
      kbo(:, 1,42, 5) = (/ &
        & 0.33108e-07_r8,0.32945e-05_r8,0.44261e-05_r8,0.44871e-05_r8,0.20674e-05_r8 /)
      kbo(:, 2,42, 5) = (/ &
        & 0.36228e-07_r8,0.35861e-05_r8,0.47462e-05_r8,0.47571e-05_r8,0.22452e-05_r8 /)
      kbo(:, 3,42, 5) = (/ &
        & 0.38776e-07_r8,0.38701e-05_r8,0.50505e-05_r8,0.50046e-05_r8,0.24106e-05_r8 /)
      kbo(:, 4,42, 5) = (/ &
        & 0.40580e-07_r8,0.41378e-05_r8,0.53219e-05_r8,0.52323e-05_r8,0.25622e-05_r8 /)
      kbo(:, 5,42, 5) = (/ &
        & 0.41689e-07_r8,0.43881e-05_r8,0.55607e-05_r8,0.54356e-05_r8,0.27015e-05_r8 /)
      kbo(:, 1,43, 5) = (/ &
        & 0.26243e-07_r8,0.26780e-05_r8,0.36021e-05_r8,0.36578e-05_r8,0.16722e-05_r8 /)
      kbo(:, 2,43, 5) = (/ &
        & 0.28903e-07_r8,0.29254e-05_r8,0.38754e-05_r8,0.38886e-05_r8,0.18235e-05_r8 /)
      kbo(:, 3,43, 5) = (/ &
        & 0.31158e-07_r8,0.31674e-05_r8,0.41363e-05_r8,0.40998e-05_r8,0.19628e-05_r8 /)
      kbo(:, 4,43, 5) = (/ &
        & 0.32828e-07_r8,0.33966e-05_r8,0.43687e-05_r8,0.42935e-05_r8,0.20906e-05_r8 /)
      kbo(:, 5,43, 5) = (/ &
        & 0.33896e-07_r8,0.36112e-05_r8,0.45745e-05_r8,0.44680e-05_r8,0.22088e-05_r8 /)
      kbo(:, 1,44, 5) = (/ &
        & 0.20692e-07_r8,0.21688e-05_r8,0.29226e-05_r8,0.29738e-05_r8,0.13486e-05_r8 /)
      kbo(:, 2,44, 5) = (/ &
        & 0.22961e-07_r8,0.23776e-05_r8,0.31556e-05_r8,0.31699e-05_r8,0.14759e-05_r8 /)
      kbo(:, 3,44, 5) = (/ &
        & 0.24934e-07_r8,0.25834e-05_r8,0.33779e-05_r8,0.33507e-05_r8,0.15926e-05_r8 /)
      kbo(:, 4,44, 5) = (/ &
        & 0.26472e-07_r8,0.27800e-05_r8,0.35779e-05_r8,0.35162e-05_r8,0.17017e-05_r8 /)
      kbo(:, 5,44, 5) = (/ &
        & 0.27504e-07_r8,0.29637e-05_r8,0.37558e-05_r8,0.36666e-05_r8,0.18017e-05_r8 /)
      kbo(:, 1,45, 5) = (/ &
        & 0.16269e-07_r8,0.17537e-05_r8,0.23672e-05_r8,0.24133e-05_r8,0.10856e-05_r8 /)
      kbo(:, 2,45, 5) = (/ &
        & 0.18194e-07_r8,0.19291e-05_r8,0.25663e-05_r8,0.25809e-05_r8,0.11927e-05_r8 /)
      kbo(:, 3,45, 5) = (/ &
        & 0.19903e-07_r8,0.21039e-05_r8,0.27552e-05_r8,0.27360e-05_r8,0.12909e-05_r8 /)
      kbo(:, 4,45, 5) = (/ &
        & 0.21293e-07_r8,0.22721e-05_r8,0.29270e-05_r8,0.28775e-05_r8,0.13839e-05_r8 /)
      kbo(:, 5,45, 5) = (/ &
        & 0.22283e-07_r8,0.24292e-05_r8,0.30802e-05_r8,0.30067e-05_r8,0.14686e-05_r8 /)
      kbo(:, 1,46, 5) = (/ &
        & 0.12712e-07_r8,0.14128e-05_r8,0.19113e-05_r8,0.19548e-05_r8,0.87114e-06_r8 /)
      kbo(:, 2,46, 5) = (/ &
        & 0.14351e-07_r8,0.15596e-05_r8,0.20802e-05_r8,0.20949e-05_r8,0.96118e-06_r8 /)
      kbo(:, 3,46, 5) = (/ &
        & 0.15815e-07_r8,0.17076e-05_r8,0.22404e-05_r8,0.22289e-05_r8,0.10436e-05_r8 /)
      kbo(:, 4,46, 5) = (/ &
        & 0.17062e-07_r8,0.18511e-05_r8,0.23889e-05_r8,0.23492e-05_r8,0.11225e-05_r8 /)
      kbo(:, 5,46, 5) = (/ &
        & 0.17993e-07_r8,0.19855e-05_r8,0.25206e-05_r8,0.24609e-05_r8,0.11948e-05_r8 /)
      kbo(:, 1,47, 5) = (/ &
        & 0.98364e-08_r8,0.11306e-05_r8,0.15353e-05_r8,0.15746e-05_r8,0.69554e-06_r8 /)
      kbo(:, 2,47, 5) = (/ &
        & 0.11226e-07_r8,0.12534e-05_r8,0.16765e-05_r8,0.16944e-05_r8,0.76925e-06_r8 /)
      kbo(:, 3,47, 5) = (/ &
        & 0.12483e-07_r8,0.13784e-05_r8,0.18130e-05_r8,0.18087e-05_r8,0.84036e-06_r8 /)
      kbo(:, 4,47, 5) = (/ &
        & 0.13587e-07_r8,0.15007e-05_r8,0.19418e-05_r8,0.19122e-05_r8,0.90712e-06_r8 /)
      kbo(:, 5,47, 5) = (/ &
        & 0.14457e-07_r8,0.16158e-05_r8,0.20557e-05_r8,0.20073e-05_r8,0.96847e-06_r8 /)
      kbo(:, 1,48, 5) = (/ &
        & 0.75824e-08_r8,0.90329e-06_r8,0.12307e-05_r8,0.12653e-05_r8,0.55346e-06_r8 /)
      kbo(:, 2,48, 5) = (/ &
        & 0.87453e-08_r8,0.10050e-05_r8,0.13490e-05_r8,0.13676e-05_r8,0.61470e-06_r8 /)
      kbo(:, 3,48, 5) = (/ &
        & 0.98194e-08_r8,0.11101e-05_r8,0.14650e-05_r8,0.14651e-05_r8,0.67492e-06_r8 /)
      kbo(:, 4,48, 5) = (/ &
        & 0.10779e-07_r8,0.12141e-05_r8,0.15756e-05_r8,0.15544e-05_r8,0.73163e-06_r8 /)
      kbo(:, 5,48, 5) = (/ &
        & 0.11579e-07_r8,0.13125e-05_r8,0.16743e-05_r8,0.16359e-05_r8,0.78405e-06_r8 /)
      kbo(:, 1,49, 5) = (/ &
        & 0.58219e-08_r8,0.72015e-06_r8,0.98379e-06_r8,0.10143e-05_r8,0.43933e-06_r8 /)
      kbo(:, 2,49, 5) = (/ &
        & 0.67817e-08_r8,0.80423e-06_r8,0.10832e-05_r8,0.11023e-05_r8,0.49018e-06_r8 /)
      kbo(:, 3,49, 5) = (/ &
        & 0.76966e-08_r8,0.89205e-06_r8,0.11819e-05_r8,0.11846e-05_r8,0.54131e-06_r8 /)
      kbo(:, 4,49, 5) = (/ &
        & 0.85224e-08_r8,0.98005e-06_r8,0.12760e-05_r8,0.12617e-05_r8,0.58858e-06_r8 /)
      kbo(:, 5,49, 5) = (/ &
        & 0.92350e-08_r8,0.10644e-05_r8,0.13615e-05_r8,0.13319e-05_r8,0.63358e-06_r8 /)
      kbo(:, 1,50, 5) = (/ &
        & 0.44790e-08_r8,0.57418e-06_r8,0.78635e-06_r8,0.81296e-06_r8,0.34881e-06_r8 /)
      kbo(:, 2,50, 5) = (/ &
        & 0.52579e-08_r8,0.64388e-06_r8,0.87056e-06_r8,0.88896e-06_r8,0.39135e-06_r8 /)
      kbo(:, 3,50, 5) = (/ &
        & 0.60279e-08_r8,0.71722e-06_r8,0.95348e-06_r8,0.95809e-06_r8,0.43444e-06_r8 /)
      kbo(:, 4,50, 5) = (/ &
        & 0.67324e-08_r8,0.79134e-06_r8,0.10331e-05_r8,0.10243e-05_r8,0.47391e-06_r8 /)
      kbo(:, 5,50, 5) = (/ &
        & 0.73551e-08_r8,0.86330e-06_r8,0.11073e-05_r8,0.10842e-05_r8,0.51234e-06_r8 /)
      kbo(:, 1,51, 5) = (/ &
        & 0.34450e-08_r8,0.45753e-06_r8,0.62814e-06_r8,0.65158e-06_r8,0.27625e-06_r8 /)
      kbo(:, 2,51, 5) = (/ &
        & 0.40690e-08_r8,0.51530e-06_r8,0.69892e-06_r8,0.71555e-06_r8,0.31260e-06_r8 /)
      kbo(:, 3,51, 5) = (/ &
        & 0.47087e-08_r8,0.57624e-06_r8,0.76840e-06_r8,0.77477e-06_r8,0.34804e-06_r8 /)
      kbo(:, 4,51, 5) = (/ &
        & 0.53086e-08_r8,0.63843e-06_r8,0.83580e-06_r8,0.83092e-06_r8,0.38181e-06_r8 /)
      kbo(:, 5,51, 5) = (/ &
        & 0.58439e-08_r8,0.69956e-06_r8,0.89962e-06_r8,0.88225e-06_r8,0.41412e-06_r8 /)
      kbo(:, 1,52, 5) = (/ &
        & 0.26454e-08_r8,0.36387e-06_r8,0.50007e-06_r8,0.52179e-06_r8,0.21894e-06_r8 /)
      kbo(:, 2,52, 5) = (/ &
        & 0.31403e-08_r8,0.41173e-06_r8,0.55997e-06_r8,0.57479e-06_r8,0.24870e-06_r8 /)
      kbo(:, 3,52, 5) = (/ &
        & 0.36655e-08_r8,0.46211e-06_r8,0.61819e-06_r8,0.62511e-06_r8,0.27840e-06_r8 /)
      kbo(:, 4,52, 5) = (/ &
        & 0.41730e-08_r8,0.51415e-06_r8,0.67546e-06_r8,0.67307e-06_r8,0.30695e-06_r8 /)
      kbo(:, 5,52, 5) = (/ &
        & 0.46311e-08_r8,0.56582e-06_r8,0.72973e-06_r8,0.71697e-06_r8,0.33407e-06_r8 /)
      kbo(:, 1,53, 5) = (/ &
        & 0.20275e-08_r8,0.28873e-06_r8,0.39749e-06_r8,0.41647e-06_r8,0.17355e-06_r8 /)
      kbo(:, 2,53, 5) = (/ &
        & 0.24190e-08_r8,0.32821e-06_r8,0.44730e-06_r8,0.46063e-06_r8,0.19774e-06_r8 /)
      kbo(:, 3,53, 5) = (/ &
        & 0.28440e-08_r8,0.36981e-06_r8,0.49677e-06_r8,0.50411e-06_r8,0.22218e-06_r8 /)
      kbo(:, 4,53, 5) = (/ &
        & 0.32690e-08_r8,0.41315e-06_r8,0.54488e-06_r8,0.54408e-06_r8,0.24647e-06_r8 /)
      kbo(:, 5,53, 5) = (/ &
        & 0.36592e-08_r8,0.45680e-06_r8,0.59090e-06_r8,0.58189e-06_r8,0.26902e-06_r8 /)
      kbo(:, 1,54, 5) = (/ &
        & 0.15611e-08_r8,0.22962e-06_r8,0.31613e-06_r8,0.33300e-06_r8,0.13730e-06_r8 /)
      kbo(:, 2,54, 5) = (/ &
        & 0.18696e-08_r8,0.26187e-06_r8,0.35802e-06_r8,0.36954e-06_r8,0.15701e-06_r8 /)
      kbo(:, 3,54, 5) = (/ &
        & 0.22100e-08_r8,0.29641e-06_r8,0.39970e-06_r8,0.40683e-06_r8,0.17764e-06_r8 /)
      kbo(:, 4,54, 5) = (/ &
        & 0.25619e-08_r8,0.33255e-06_r8,0.44009e-06_r8,0.44063e-06_r8,0.19808e-06_r8 /)
      kbo(:, 5,54, 5) = (/ &
        & 0.28928e-08_r8,0.36908e-06_r8,0.47892e-06_r8,0.47270e-06_r8,0.21696e-06_r8 /)
      kbo(:, 1,55, 5) = (/ &
        & 0.12041e-08_r8,0.18259e-06_r8,0.25108e-06_r8,0.26608e-06_r8,0.10842e-06_r8 /)
      kbo(:, 2,55, 5) = (/ &
        & 0.14466e-08_r8,0.20918e-06_r8,0.28633e-06_r8,0.29677e-06_r8,0.12468e-06_r8 /)
      kbo(:, 3,55, 5) = (/ &
        & 0.17176e-08_r8,0.23765e-06_r8,0.32139e-06_r8,0.32799e-06_r8,0.14213e-06_r8 /)
      kbo(:, 4,55, 5) = (/ &
        & 0.20058e-08_r8,0.26766e-06_r8,0.35523e-06_r8,0.35664e-06_r8,0.15907e-06_r8 /)
      kbo(:, 5,55, 5) = (/ &
        & 0.22852e-08_r8,0.29818e-06_r8,0.38806e-06_r8,0.38381e-06_r8,0.17512e-06_r8 /)
      kbo(:, 1,56, 5) = (/ &
        & 0.92934e-09_r8,0.14496e-06_r8,0.19887e-06_r8,0.21215e-06_r8,0.85185e-07_r8 /)
      kbo(:, 2,56, 5) = (/ &
        & 0.11180e-08_r8,0.16668e-06_r8,0.22841e-06_r8,0.23799e-06_r8,0.99172e-07_r8 /)
      kbo(:, 3,56, 5) = (/ &
        & 0.13333e-08_r8,0.19024e-06_r8,0.25790e-06_r8,0.26385e-06_r8,0.11331e-06_r8 /)
      kbo(:, 4,56, 5) = (/ &
        & 0.15668e-08_r8,0.21512e-06_r8,0.28626e-06_r8,0.28820e-06_r8,0.12758e-06_r8 /)
      kbo(:, 5,56, 5) = (/ &
        & 0.18000e-08_r8,0.24055e-06_r8,0.31405e-06_r8,0.31134e-06_r8,0.14106e-06_r8 /)
      kbo(:, 1,57, 5) = (/ &
        & 0.71747e-09_r8,0.11491e-06_r8,0.15760e-06_r8,0.16907e-06_r8,0.66762e-07_r8 /)
      kbo(:, 2,57, 5) = (/ &
        & 0.86318e-09_r8,0.13266e-06_r8,0.18198e-06_r8,0.19051e-06_r8,0.78844e-07_r8 /)
      kbo(:, 3,57, 5) = (/ &
        & 0.10332e-08_r8,0.15199e-06_r8,0.20646e-06_r8,0.21185e-06_r8,0.90317e-07_r8 /)
      kbo(:, 4,57, 5) = (/ &
        & 0.12205e-08_r8,0.17255e-06_r8,0.23049e-06_r8,0.23280e-06_r8,0.10211e-06_r8 /)
      kbo(:, 5,57, 5) = (/ &
        & 0.14137e-08_r8,0.19374e-06_r8,0.25377e-06_r8,0.25209e-06_r8,0.11347e-06_r8 /)
      kbo(:, 1,58, 5) = (/ &
        & 0.55534e-09_r8,0.91161e-07_r8,0.12495e-06_r8,0.13481e-06_r8,0.52524e-07_r8 /)
      kbo(:, 2,58, 5) = (/ &
        & 0.66796e-09_r8,0.10564e-06_r8,0.14490e-06_r8,0.15246e-06_r8,0.62491e-07_r8 /)
      kbo(:, 3,58, 5) = (/ &
        & 0.80208e-09_r8,0.12142e-06_r8,0.16540e-06_r8,0.17013e-06_r8,0.71923e-07_r8 /)
      kbo(:, 4,58, 5) = (/ &
        & 0.95155e-09_r8,0.13846e-06_r8,0.18562e-06_r8,0.18803e-06_r8,0.81760e-07_r8 /)
      kbo(:, 5,58, 5) = (/ &
        & 0.11100e-08_r8,0.15608e-06_r8,0.20513e-06_r8,0.20425e-06_r8,0.91405e-07_r8 /)
      kbo(:, 1,59, 5) = (/ &
        & 0.44483e-09_r8,0.74201e-07_r8,0.10175e-06_r8,0.10986e-06_r8,0.42626e-07_r8 /)
      kbo(:, 2,59, 5) = (/ &
        & 0.53478e-09_r8,0.86257e-07_r8,0.11818e-06_r8,0.12453e-06_r8,0.50816e-07_r8 /)
      kbo(:, 3,59, 5) = (/ &
        & 0.64265e-09_r8,0.99390e-07_r8,0.13535e-06_r8,0.13928e-06_r8,0.58658e-07_r8 /)
      kbo(:, 4,59, 5) = (/ &
        & 0.76369e-09_r8,0.11360e-06_r8,0.15224e-06_r8,0.15417e-06_r8,0.66845e-07_r8 /)
      kbo(:, 5,59, 5) = (/ &
        & 0.89316e-09_r8,0.12826e-06_r8,0.16850e-06_r8,0.16775e-06_r8,0.74841e-07_r8 /)
      kbo(:, 1,13, 6) = (/ &
        & 0.15452e-03_r8,0.17471e-02_r8,0.22870e-02_r8,0.22757e-02_r8,0.11868e-02_r8 /)
      kbo(:, 2,13, 6) = (/ &
        & 0.17358e-03_r8,0.18337e-02_r8,0.23752e-02_r8,0.23549e-02_r8,0.12492e-02_r8 /)
      kbo(:, 3,13, 6) = (/ &
        & 0.19043e-03_r8,0.19070e-02_r8,0.24479e-02_r8,0.24255e-02_r8,0.13114e-02_r8 /)
      kbo(:, 4,13, 6) = (/ &
        & 0.20459e-03_r8,0.19702e-02_r8,0.25109e-02_r8,0.24905e-02_r8,0.13717e-02_r8 /)
      kbo(:, 5,13, 6) = (/ &
        & 0.21621e-03_r8,0.20266e-02_r8,0.25653e-02_r8,0.25512e-02_r8,0.14320e-02_r8 /)
      kbo(:, 1,14, 6) = (/ &
        & 0.12793e-03_r8,0.14662e-02_r8,0.19141e-02_r8,0.19032e-02_r8,0.99404e-03_r8 /)
      kbo(:, 2,14, 6) = (/ &
        & 0.14335e-03_r8,0.15367e-02_r8,0.19852e-02_r8,0.19691e-02_r8,0.10462e-02_r8 /)
      kbo(:, 3,14, 6) = (/ &
        & 0.15698e-03_r8,0.15974e-02_r8,0.20454e-02_r8,0.20285e-02_r8,0.10986e-02_r8 /)
      kbo(:, 4,14, 6) = (/ &
        & 0.16837e-03_r8,0.16505e-02_r8,0.20982e-02_r8,0.20828e-02_r8,0.11509e-02_r8 /)
      kbo(:, 5,14, 6) = (/ &
        & 0.17765e-03_r8,0.16990e-02_r8,0.21452e-02_r8,0.21357e-02_r8,0.12020e-02_r8 /)
      kbo(:, 1,15, 6) = (/ &
        & 0.10600e-03_r8,0.12280e-02_r8,0.15987e-02_r8,0.15899e-02_r8,0.83160e-03_r8 /)
      kbo(:, 2,15, 6) = (/ &
        & 0.11846e-03_r8,0.12858e-02_r8,0.16570e-02_r8,0.16438e-02_r8,0.87641e-03_r8 /)
      kbo(:, 3,15, 6) = (/ &
        & 0.12947e-03_r8,0.13362e-02_r8,0.17073e-02_r8,0.16937e-02_r8,0.92037e-03_r8 /)
      kbo(:, 4,15, 6) = (/ &
        & 0.13860e-03_r8,0.13818e-02_r8,0.17519e-02_r8,0.17401e-02_r8,0.96514e-03_r8 /)
      kbo(:, 5,15, 6) = (/ &
        & 0.14605e-03_r8,0.14231e-02_r8,0.17922e-02_r8,0.17849e-02_r8,0.10088e-02_r8 /)
      kbo(:, 1,16, 6) = (/ &
        & 0.87844e-04_r8,0.10268e-02_r8,0.13337e-02_r8,0.13258e-02_r8,0.69471e-03_r8 /)
      kbo(:, 2,16, 6) = (/ &
        & 0.97921e-04_r8,0.10747e-02_r8,0.13816e-02_r8,0.13704e-02_r8,0.73309e-03_r8 /)
      kbo(:, 3,16, 6) = (/ &
        & 0.10678e-03_r8,0.11173e-02_r8,0.14240e-02_r8,0.14122e-02_r8,0.77126e-03_r8 /)
      kbo(:, 4,16, 6) = (/ &
        & 0.11410e-03_r8,0.11561e-02_r8,0.14619e-02_r8,0.14525e-02_r8,0.80983e-03_r8 /)
      kbo(:, 5,16, 6) = (/ &
        & 0.12008e-03_r8,0.11913e-02_r8,0.14957e-02_r8,0.14904e-02_r8,0.84685e-03_r8 /)
      kbo(:, 1,17, 6) = (/ &
        & 0.72736e-04_r8,0.85770e-03_r8,0.11110e-02_r8,0.11043e-02_r8,0.57988e-03_r8 /)
      kbo(:, 2,17, 6) = (/ &
        & 0.80870e-04_r8,0.89737e-03_r8,0.11508e-02_r8,0.11412e-02_r8,0.61310e-03_r8 /)
      kbo(:, 3,17, 6) = (/ &
        & 0.87984e-04_r8,0.93334e-03_r8,0.11865e-02_r8,0.11769e-02_r8,0.64563e-03_r8 /)
      kbo(:, 4,17, 6) = (/ &
        & 0.93900e-04_r8,0.96637e-03_r8,0.12188e-02_r8,0.12115e-02_r8,0.67946e-03_r8 /)
      kbo(:, 5,17, 6) = (/ &
        & 0.98669e-04_r8,0.99682e-03_r8,0.12477e-02_r8,0.12444e-02_r8,0.71129e-03_r8 /)
      kbo(:, 1,18, 6) = (/ &
        & 0.60196e-04_r8,0.71585e-03_r8,0.92484e-03_r8,0.91885e-03_r8,0.48428e-03_r8 /)
      kbo(:, 2,18, 6) = (/ &
        & 0.66759e-04_r8,0.74902e-03_r8,0.95806e-03_r8,0.95007e-03_r8,0.51254e-03_r8 /)
      kbo(:, 3,18, 6) = (/ &
        & 0.72486e-04_r8,0.77936e-03_r8,0.98828e-03_r8,0.98036e-03_r8,0.54118e-03_r8 /)
      kbo(:, 4,18, 6) = (/ &
        & 0.77210e-04_r8,0.80757e-03_r8,0.10157e-02_r8,0.10101e-02_r8,0.56995e-03_r8 /)
      kbo(:, 5,18, 6) = (/ &
        & 0.81046e-04_r8,0.83344e-03_r8,0.10405e-02_r8,0.10390e-02_r8,0.59762e-03_r8 /)
      kbo(:, 1,19, 6) = (/ &
        & 0.49797e-04_r8,0.59714e-03_r8,0.76951e-03_r8,0.76408e-03_r8,0.40487e-03_r8 /)
      kbo(:, 2,19, 6) = (/ &
        & 0.55098e-04_r8,0.62505e-03_r8,0.79728e-03_r8,0.79071e-03_r8,0.42904e-03_r8 /)
      kbo(:, 3,19, 6) = (/ &
        & 0.59690e-04_r8,0.65071e-03_r8,0.82294e-03_r8,0.81671e-03_r8,0.45375e-03_r8 /)
      kbo(:, 4,19, 6) = (/ &
        & 0.63457e-04_r8,0.67490e-03_r8,0.84635e-03_r8,0.84245e-03_r8,0.47833e-03_r8 /)
      kbo(:, 5,19, 6) = (/ &
        & 0.66538e-04_r8,0.69683e-03_r8,0.86805e-03_r8,0.86812e-03_r8,0.50238e-03_r8 /)
      kbo(:, 1,20, 6) = (/ &
        & 0.41277e-04_r8,0.49854e-03_r8,0.64043e-03_r8,0.63582e-03_r8,0.33885e-03_r8 /)
      kbo(:, 2,20, 6) = (/ &
        & 0.45557e-04_r8,0.52197e-03_r8,0.66408e-03_r8,0.65859e-03_r8,0.35960e-03_r8 /)
      kbo(:, 3,20, 6) = (/ &
        & 0.49226e-04_r8,0.54380e-03_r8,0.68582e-03_r8,0.68111e-03_r8,0.38108e-03_r8 /)
      kbo(:, 4,20, 6) = (/ &
        & 0.52238e-04_r8,0.56442e-03_r8,0.70598e-03_r8,0.70364e-03_r8,0.40199e-03_r8 /)
      kbo(:, 5,20, 6) = (/ &
        & 0.54694e-04_r8,0.58320e-03_r8,0.72504e-03_r8,0.72645e-03_r8,0.42282e-03_r8 /)
      kbo(:, 1,21, 6) = (/ &
        & 0.34218e-04_r8,0.41624e-03_r8,0.53312e-03_r8,0.52912e-03_r8,0.28376e-03_r8 /)
      kbo(:, 2,21, 6) = (/ &
        & 0.37670e-04_r8,0.43597e-03_r8,0.55316e-03_r8,0.54893e-03_r8,0.30161e-03_r8 /)
      kbo(:, 3,21, 6) = (/ &
        & 0.40602e-04_r8,0.45467e-03_r8,0.57178e-03_r8,0.56861e-03_r8,0.32023e-03_r8 /)
      kbo(:, 4,21, 6) = (/ &
        & 0.43009e-04_r8,0.47220e-03_r8,0.58931e-03_r8,0.58850e-03_r8,0.33805e-03_r8 /)
      kbo(:, 5,21, 6) = (/ &
        & 0.44968e-04_r8,0.48850e-03_r8,0.60624e-03_r8,0.60867e-03_r8,0.35633e-03_r8 /)
      kbo(:, 1,22, 6) = (/ &
        & 0.28554e-04_r8,0.34872e-03_r8,0.44519e-03_r8,0.44203e-03_r8,0.23865e-03_r8 /)
      kbo(:, 2,22, 6) = (/ &
        & 0.31312e-04_r8,0.36543e-03_r8,0.46215e-03_r8,0.45896e-03_r8,0.25429e-03_r8 /)
      kbo(:, 3,22, 6) = (/ &
        & 0.33623e-04_r8,0.38136e-03_r8,0.47808e-03_r8,0.47625e-03_r8,0.27020e-03_r8 /)
      kbo(:, 4,22, 6) = (/ &
        & 0.35518e-04_r8,0.39638e-03_r8,0.49352e-03_r8,0.49393e-03_r8,0.28567e-03_r8 /)
      kbo(:, 5,22, 6) = (/ &
        & 0.37060e-04_r8,0.41046e-03_r8,0.50833e-03_r8,0.51152e-03_r8,0.30169e-03_r8 /)
      kbo(:, 1,23, 6) = (/ &
        & 0.23825e-04_r8,0.29241e-03_r8,0.37202e-03_r8,0.36957e-03_r8,0.20120e-03_r8 /)
      kbo(:, 2,23, 6) = (/ &
        & 0.26019e-04_r8,0.30664e-03_r8,0.38650e-03_r8,0.38433e-03_r8,0.21484e-03_r8 /)
      kbo(:, 3,23, 6) = (/ &
        & 0.27840e-04_r8,0.32027e-03_r8,0.40038e-03_r8,0.39957e-03_r8,0.22829e-03_r8 /)
      kbo(:, 4,23, 6) = (/ &
        & 0.29329e-04_r8,0.33317e-03_r8,0.41396e-03_r8,0.41498e-03_r8,0.24169e-03_r8 /)
      kbo(:, 5,23, 6) = (/ &
        & 0.30542e-04_r8,0.34547e-03_r8,0.42681e-03_r8,0.43048e-03_r8,0.25568e-03_r8 /)
      kbo(:, 1,24, 6) = (/ &
        & 0.19879e-04_r8,0.24552e-03_r8,0.31135e-03_r8,0.30936e-03_r8,0.16986e-03_r8 /)
      kbo(:, 2,24, 6) = (/ &
        & 0.21617e-04_r8,0.25767e-03_r8,0.32376e-03_r8,0.32228e-03_r8,0.18173e-03_r8 /)
      kbo(:, 3,24, 6) = (/ &
        & 0.23050e-04_r8,0.26937e-03_r8,0.33590e-03_r8,0.33579e-03_r8,0.19320e-03_r8 /)
      kbo(:, 4,24, 6) = (/ &
        & 0.24217e-04_r8,0.28054e-03_r8,0.34772e-03_r8,0.34922e-03_r8,0.20501e-03_r8 /)
      kbo(:, 5,24, 6) = (/ &
        & 0.25164e-04_r8,0.29121e-03_r8,0.35883e-03_r8,0.36286e-03_r8,0.21708e-03_r8 /)
      kbo(:, 1,25, 6) = (/ &
        & 0.16589e-04_r8,0.20645e-03_r8,0.26087e-03_r8,0.25944e-03_r8,0.14369e-03_r8 /)
      kbo(:, 2,25, 6) = (/ &
        & 0.17961e-04_r8,0.21688e-03_r8,0.27162e-03_r8,0.27083e-03_r8,0.15386e-03_r8 /)
      kbo(:, 3,25, 6) = (/ &
        & 0.19083e-04_r8,0.22697e-03_r8,0.28229e-03_r8,0.28258e-03_r8,0.16383e-03_r8 /)
      kbo(:, 4,25, 6) = (/ &
        & 0.19998e-04_r8,0.23668e-03_r8,0.29245e-03_r8,0.29438e-03_r8,0.17418e-03_r8 /)
      kbo(:, 5,25, 6) = (/ &
        & 0.20737e-04_r8,0.24589e-03_r8,0.30216e-03_r8,0.30647e-03_r8,0.18465e-03_r8 /)
      kbo(:, 1,26, 6) = (/ &
        & 0.13858e-04_r8,0.17402e-03_r8,0.21906e-03_r8,0.21804e-03_r8,0.12205e-03_r8 /)
      kbo(:, 2,26, 6) = (/ &
        & 0.14930e-04_r8,0.18300e-03_r8,0.22843e-03_r8,0.22813e-03_r8,0.13065e-03_r8 /)
      kbo(:, 3,26, 6) = (/ &
        & 0.15807e-04_r8,0.19174e-03_r8,0.23770e-03_r8,0.23830e-03_r8,0.13933e-03_r8 /)
      kbo(:, 4,26, 6) = (/ &
        & 0.16522e-04_r8,0.20010e-03_r8,0.24640e-03_r8,0.24876e-03_r8,0.14837e-03_r8 /)
      kbo(:, 5,26, 6) = (/ &
        & 0.17090e-04_r8,0.20798e-03_r8,0.25500e-03_r8,0.25943e-03_r8,0.15748e-03_r8 /)
      kbo(:, 1,27, 6) = (/ &
        & 0.11565e-04_r8,0.14689e-03_r8,0.18423e-03_r8,0.18358e-03_r8,0.10372e-03_r8 /)
      kbo(:, 2,27, 6) = (/ &
        & 0.12404e-04_r8,0.15466e-03_r8,0.19242e-03_r8,0.19242e-03_r8,0.11104e-03_r8 /)
      kbo(:, 3,27, 6) = (/ &
        & 0.13088e-04_r8,0.16225e-03_r8,0.20035e-03_r8,0.20136e-03_r8,0.11877e-03_r8 /)
      kbo(:, 4,27, 6) = (/ &
        & 0.13644e-04_r8,0.16938e-03_r8,0.20793e-03_r8,0.21054e-03_r8,0.12658e-03_r8 /)
      kbo(:, 5,27, 6) = (/ &
        & 0.14079e-04_r8,0.17614e-03_r8,0.21553e-03_r8,0.22004e-03_r8,0.13455e-03_r8 /)
      kbo(:, 1,28, 6) = (/ &
        & 0.96429e-05_r8,0.12422e-03_r8,0.15518e-03_r8,0.15486e-03_r8,0.88240e-04_r8 /)
      kbo(:, 2,28, 6) = (/ &
        & 0.10297e-04_r8,0.13093e-03_r8,0.16229e-03_r8,0.16255e-03_r8,0.94664e-04_r8 /)
      kbo(:, 3,28, 6) = (/ &
        & 0.10829e-04_r8,0.13744e-03_r8,0.16911e-03_r8,0.17043e-03_r8,0.10137e-03_r8 /)
      kbo(:, 4,28, 6) = (/ &
        & 0.11263e-04_r8,0.14355e-03_r8,0.17577e-03_r8,0.17861e-03_r8,0.10818e-03_r8 /)
      kbo(:, 5,28, 6) = (/ &
        & 0.11593e-04_r8,0.14936e-03_r8,0.18245e-03_r8,0.18698e-03_r8,0.11517e-03_r8 /)
      kbo(:, 1,29, 6) = (/ &
        & 0.80357e-05_r8,0.10525e-03_r8,0.13098e-03_r8,0.13087e-03_r8,0.75199e-04_r8 /)
      kbo(:, 2,29, 6) = (/ &
        & 0.85457e-05_r8,0.11106e-03_r8,0.13709e-03_r8,0.13756e-03_r8,0.80877e-04_r8 /)
      kbo(:, 3,29, 6) = (/ &
        & 0.89585e-05_r8,0.11659e-03_r8,0.14298e-03_r8,0.14458e-03_r8,0.86703e-04_r8 /)
      kbo(:, 4,29, 6) = (/ &
        & 0.92936e-05_r8,0.12185e-03_r8,0.14887e-03_r8,0.15184e-03_r8,0.92679e-04_r8 /)
      kbo(:, 5,29, 6) = (/ &
        & 0.95413e-05_r8,0.12685e-03_r8,0.15476e-03_r8,0.15926e-03_r8,0.98770e-04_r8 /)
      kbo(:, 1,30, 6) = (/ &
        & 0.66891e-05_r8,0.89326e-04_r8,0.11070e-03_r8,0.11075e-03_r8,0.64254e-04_r8 /)
      kbo(:, 2,30, 6) = (/ &
        & 0.70855e-05_r8,0.94280e-04_r8,0.11595e-03_r8,0.11668e-03_r8,0.69215e-04_r8 /)
      kbo(:, 3,30, 6) = (/ &
        & 0.74068e-05_r8,0.99029e-04_r8,0.12112e-03_r8,0.12290e-03_r8,0.74278e-04_r8 /)
      kbo(:, 4,30, 6) = (/ &
        & 0.76634e-05_r8,0.10356e-03_r8,0.12631e-03_r8,0.12933e-03_r8,0.79489e-04_r8 /)
      kbo(:, 5,30, 6) = (/ &
        & 0.78499e-05_r8,0.10785e-03_r8,0.13152e-03_r8,0.13588e-03_r8,0.84762e-04_r8 /)
      kbo(:, 1,31, 6) = (/ &
        & 0.55647e-05_r8,0.75943e-04_r8,0.93695e-04_r8,0.93906e-04_r8,0.55002e-04_r8 /)
      kbo(:, 2,31, 6) = (/ &
        & 0.58719e-05_r8,0.80167e-04_r8,0.98229e-04_r8,0.99204e-04_r8,0.59329e-04_r8 /)
      kbo(:, 3,31, 6) = (/ &
        & 0.61212e-05_r8,0.84249e-04_r8,0.10281e-03_r8,0.10471e-03_r8,0.63778e-04_r8 /)
      kbo(:, 4,31, 6) = (/ &
        & 0.63162e-05_r8,0.88122e-04_r8,0.10738e-03_r8,0.11041e-03_r8,0.68318e-04_r8 /)
      kbo(:, 5,31, 6) = (/ &
        & 0.64553e-05_r8,0.91835e-04_r8,0.11204e-03_r8,0.11614e-03_r8,0.72907e-04_r8 /)
      kbo(:, 1,32, 6) = (/ &
        & 0.46246e-05_r8,0.64633e-04_r8,0.79398e-04_r8,0.79831e-04_r8,0.47190e-04_r8 /)
      kbo(:, 2,32, 6) = (/ &
        & 0.48628e-05_r8,0.68258e-04_r8,0.83383e-04_r8,0.84521e-04_r8,0.50953e-04_r8 /)
      kbo(:, 3,32, 6) = (/ &
        & 0.50557e-05_r8,0.71758e-04_r8,0.87418e-04_r8,0.89417e-04_r8,0.54823e-04_r8 /)
      kbo(:, 4,32, 6) = (/ &
        & 0.52035e-05_r8,0.75099e-04_r8,0.91481e-04_r8,0.94423e-04_r8,0.58785e-04_r8 /)
      kbo(:, 5,32, 6) = (/ &
        & 0.53068e-05_r8,0.78317e-04_r8,0.95646e-04_r8,0.99452e-04_r8,0.62766e-04_r8 /)
      kbo(:, 1,33, 6) = (/ &
        & 0.38403e-05_r8,0.55077e-04_r8,0.67410e-04_r8,0.68024e-04_r8,0.40538e-04_r8 /)
      kbo(:, 2,33, 6) = (/ &
        & 0.40244e-05_r8,0.58199e-04_r8,0.70924e-04_r8,0.72180e-04_r8,0.43839e-04_r8 /)
      kbo(:, 3,33, 6) = (/ &
        & 0.41730e-05_r8,0.61206e-04_r8,0.74475e-04_r8,0.76502e-04_r8,0.47222e-04_r8 /)
      kbo(:, 4,33, 6) = (/ &
        & 0.42835e-05_r8,0.64091e-04_r8,0.78114e-04_r8,0.80883e-04_r8,0.50652e-04_r8 /)
      kbo(:, 5,33, 6) = (/ &
        & 0.43604e-05_r8,0.66898e-04_r8,0.81798e-04_r8,0.85293e-04_r8,0.54102e-04_r8 /)
      kbo(:, 1,34, 6) = (/ &
        & 0.31801e-05_r8,0.46888e-04_r8,0.57233e-04_r8,0.57945e-04_r8,0.34781e-04_r8 /)
      kbo(:, 2,34, 6) = (/ &
        & 0.33244e-05_r8,0.49586e-04_r8,0.60319e-04_r8,0.61625e-04_r8,0.37646e-04_r8 /)
      kbo(:, 3,34, 6) = (/ &
        & 0.34389e-05_r8,0.52183e-04_r8,0.63465e-04_r8,0.65422e-04_r8,0.40606e-04_r8 /)
      kbo(:, 4,34, 6) = (/ &
        & 0.35228e-05_r8,0.54696e-04_r8,0.66697e-04_r8,0.69266e-04_r8,0.43571e-04_r8 /)
      kbo(:, 5,34, 6) = (/ &
        & 0.35804e-05_r8,0.57162e-04_r8,0.69964e-04_r8,0.73120e-04_r8,0.46562e-04_r8 /)
      kbo(:, 1,35, 6) = (/ &
        & 0.26200e-05_r8,0.39742e-04_r8,0.48410e-04_r8,0.49141e-04_r8,0.29639e-04_r8 /)
      kbo(:, 2,35, 6) = (/ &
        & 0.27351e-05_r8,0.42075e-04_r8,0.51122e-04_r8,0.52382e-04_r8,0.32146e-04_r8 /)
      kbo(:, 3,35, 6) = (/ &
        & 0.28253e-05_r8,0.44325e-04_r8,0.53916e-04_r8,0.55698e-04_r8,0.34701e-04_r8 /)
      kbo(:, 4,35, 6) = (/ &
        & 0.28907e-05_r8,0.46530e-04_r8,0.56769e-04_r8,0.59068e-04_r8,0.37280e-04_r8 /)
      kbo(:, 5,35, 6) = (/ &
        & 0.29354e-05_r8,0.48707e-04_r8,0.59649e-04_r8,0.62461e-04_r8,0.39864e-04_r8 /)
      kbo(:, 1,36, 6) = (/ &
        & 0.21469e-05_r8,0.33498e-04_r8,0.40744e-04_r8,0.41427e-04_r8,0.25045e-04_r8 /)
      kbo(:, 2,36, 6) = (/ &
        & 0.22407e-05_r8,0.35513e-04_r8,0.43124e-04_r8,0.44262e-04_r8,0.27227e-04_r8 /)
      kbo(:, 3,36, 6) = (/ &
        & 0.23140e-05_r8,0.37481e-04_r8,0.45588e-04_r8,0.47157e-04_r8,0.29433e-04_r8 /)
      kbo(:, 4,36, 6) = (/ &
        & 0.23673e-05_r8,0.39419e-04_r8,0.48109e-04_r8,0.50107e-04_r8,0.31672e-04_r8 /)
      kbo(:, 5,36, 6) = (/ &
        & 0.24035e-05_r8,0.41345e-04_r8,0.50640e-04_r8,0.53089e-04_r8,0.33911e-04_r8 /)
      kbo(:, 1,37, 6) = (/ &
        & 0.17464e-05_r8,0.27984e-04_r8,0.34007e-04_r8,0.34584e-04_r8,0.20899e-04_r8 /)
      kbo(:, 2,37, 6) = (/ &
        & 0.18252e-05_r8,0.29737e-04_r8,0.36088e-04_r8,0.37051e-04_r8,0.22785e-04_r8 /)
      kbo(:, 3,37, 6) = (/ &
        & 0.18877e-05_r8,0.31460e-04_r8,0.38247e-04_r8,0.39573e-04_r8,0.24687e-04_r8 /)
      kbo(:, 4,37, 6) = (/ &
        & 0.19333e-05_r8,0.33165e-04_r8,0.40460e-04_r8,0.42146e-04_r8,0.26626e-04_r8 /)
      kbo(:, 5,37, 6) = (/ &
        & 0.19647e-05_r8,0.34869e-04_r8,0.42691e-04_r8,0.44765e-04_r8,0.28561e-04_r8 /)
      kbo(:, 1,38, 6) = (/ &
        & 0.14198e-05_r8,0.23364e-04_r8,0.28367e-04_r8,0.28854e-04_r8,0.17422e-04_r8 /)
      kbo(:, 2,38, 6) = (/ &
        & 0.14862e-05_r8,0.24892e-04_r8,0.30186e-04_r8,0.30994e-04_r8,0.19047e-04_r8 /)
      kbo(:, 3,38, 6) = (/ &
        & 0.15394e-05_r8,0.26399e-04_r8,0.32076e-04_r8,0.33192e-04_r8,0.20688e-04_r8 /)
      kbo(:, 4,38, 6) = (/ &
        & 0.15786e-05_r8,0.27898e-04_r8,0.34020e-04_r8,0.35441e-04_r8,0.22360e-04_r8 /)
      kbo(:, 5,38, 6) = (/ &
        & 0.16058e-05_r8,0.29401e-04_r8,0.35983e-04_r8,0.37735e-04_r8,0.24033e-04_r8 /)
      kbo(:, 1,39, 6) = (/ &
        & 0.11541e-05_r8,0.19509e-04_r8,0.23663e-04_r8,0.24072e-04_r8,0.14521e-04_r8 /)
      kbo(:, 2,39, 6) = (/ &
        & 0.12100e-05_r8,0.20837e-04_r8,0.25252e-04_r8,0.25929e-04_r8,0.15915e-04_r8 /)
      kbo(:, 3,39, 6) = (/ &
        & 0.12551e-05_r8,0.22155e-04_r8,0.26902e-04_r8,0.27842e-04_r8,0.17331e-04_r8 /)
      kbo(:, 4,39, 6) = (/ &
        & 0.12888e-05_r8,0.23470e-04_r8,0.28603e-04_r8,0.29806e-04_r8,0.18773e-04_r8 /)
      kbo(:, 5,39, 6) = (/ &
        & 0.13123e-05_r8,0.24794e-04_r8,0.30331e-04_r8,0.31815e-04_r8,0.20216e-04_r8 /)
      kbo(:, 1,40, 6) = (/ &
        & 0.93244e-06_r8,0.16171e-04_r8,0.19599e-04_r8,0.19918e-04_r8,0.11977e-04_r8 /)
      kbo(:, 2,40, 6) = (/ &
        & 0.98059e-06_r8,0.17324e-04_r8,0.20976e-04_r8,0.21519e-04_r8,0.13169e-04_r8 /)
      kbo(:, 3,40, 6) = (/ &
        & 0.10196e-05_r8,0.18475e-04_r8,0.22411e-04_r8,0.23178e-04_r8,0.14387e-04_r8 /)
      kbo(:, 4,40, 6) = (/ &
        & 0.10496e-05_r8,0.19626e-04_r8,0.23897e-04_r8,0.24887e-04_r8,0.15625e-04_r8 /)
      kbo(:, 5,40, 6) = (/ &
        & 0.10706e-05_r8,0.20792e-04_r8,0.25411e-04_r8,0.26641e-04_r8,0.16871e-04_r8 /)
      kbo(:, 1,41, 6) = (/ &
        & 0.75206e-06_r8,0.13381e-04_r8,0.16204e-04_r8,0.16448e-04_r8,0.98582e-05_r8 /)
      kbo(:, 2,41, 6) = (/ &
        & 0.79368e-06_r8,0.14380e-04_r8,0.17395e-04_r8,0.17824e-04_r8,0.10873e-04_r8 /)
      kbo(:, 3,41, 6) = (/ &
        & 0.82742e-06_r8,0.15382e-04_r8,0.18640e-04_r8,0.19259e-04_r8,0.11916e-04_r8 /)
      kbo(:, 4,41, 6) = (/ &
        & 0.85390e-06_r8,0.16388e-04_r8,0.19935e-04_r8,0.20745e-04_r8,0.12979e-04_r8 /)
      kbo(:, 5,41, 6) = (/ &
        & 0.87281e-06_r8,0.17412e-04_r8,0.21261e-04_r8,0.22271e-04_r8,0.14053e-04_r8 /)
      kbo(:, 1,42, 6) = (/ &
        & 0.60591e-06_r8,0.11061e-04_r8,0.13385e-04_r8,0.13568e-04_r8,0.81045e-05_r8 /)
      kbo(:, 2,42, 6) = (/ &
        & 0.64182e-06_r8,0.11926e-04_r8,0.14412e-04_r8,0.14751e-04_r8,0.89661e-05_r8 /)
      kbo(:, 3,42, 6) = (/ &
        & 0.67101e-06_r8,0.12797e-04_r8,0.15489e-04_r8,0.15987e-04_r8,0.98578e-05_r8 /)
      kbo(:, 4,42, 6) = (/ &
        & 0.69427e-06_r8,0.13675e-04_r8,0.16616e-04_r8,0.17274e-04_r8,0.10770e-04_r8 /)
      kbo(:, 5,42, 6) = (/ &
        & 0.71122e-06_r8,0.14573e-04_r8,0.17774e-04_r8,0.18601e-04_r8,0.11690e-04_r8 /)
      kbo(:, 1,43, 6) = (/ &
        & 0.48565e-06_r8,0.90929e-05_r8,0.10998e-04_r8,0.11127e-04_r8,0.66136e-05_r8 /)
      kbo(:, 2,43, 6) = (/ &
        & 0.51703e-06_r8,0.98401e-05_r8,0.11878e-04_r8,0.12136e-04_r8,0.73431e-05_r8 /)
      kbo(:, 3,43, 6) = (/ &
        & 0.54246e-06_r8,0.10594e-04_r8,0.12807e-04_r8,0.13197e-04_r8,0.81019e-05_r8 /)
      kbo(:, 4,43, 6) = (/ &
        & 0.56309e-06_r8,0.11359e-04_r8,0.13782e-04_r8,0.14306e-04_r8,0.88812e-05_r8 /)
      kbo(:, 5,43, 6) = (/ &
        & 0.57854e-06_r8,0.12144e-04_r8,0.14791e-04_r8,0.15456e-04_r8,0.96685e-05_r8 /)
      kbo(:, 1,44, 6) = (/ &
        & 0.38777e-06_r8,0.74478e-05_r8,0.90062e-05_r8,0.90921e-05_r8,0.53709e-05_r8 /)
      kbo(:, 2,44, 6) = (/ &
        & 0.41522e-06_r8,0.80919e-05_r8,0.97570e-05_r8,0.99478e-05_r8,0.59889e-05_r8 /)
      kbo(:, 3,44, 6) = (/ &
        & 0.43761e-06_r8,0.87433e-05_r8,0.10555e-04_r8,0.10856e-04_r8,0.66332e-05_r8 /)
      kbo(:, 4,44, 6) = (/ &
        & 0.45584e-06_r8,0.94063e-05_r8,0.11395e-04_r8,0.11808e-04_r8,0.72955e-05_r8 /)
      kbo(:, 5,44, 6) = (/ &
        & 0.46990e-06_r8,0.10091e-04_r8,0.12269e-04_r8,0.12799e-04_r8,0.79696e-05_r8 /)
      kbo(:, 1,45, 6) = (/ &
        & 0.30888e-06_r8,0.60898e-05_r8,0.73632e-05_r8,0.74181e-05_r8,0.43535e-05_r8 /)
      kbo(:, 2,45, 6) = (/ &
        & 0.33291e-06_r8,0.66440e-05_r8,0.80023e-05_r8,0.81416e-05_r8,0.48741e-05_r8 /)
      kbo(:, 3,45, 6) = (/ &
        & 0.35255e-06_r8,0.72052e-05_r8,0.86855e-05_r8,0.89154e-05_r8,0.54207e-05_r8 /)
      kbo(:, 4,45, 6) = (/ &
        & 0.36854e-06_r8,0.77787e-05_r8,0.94068e-05_r8,0.97308e-05_r8,0.59833e-05_r8 /)
      kbo(:, 5,45, 6) = (/ &
        & 0.38125e-06_r8,0.83745e-05_r8,0.10163e-04_r8,0.10583e-04_r8,0.65578e-05_r8 /)
      kbo(:, 1,46, 6) = (/ &
        & 0.24494e-06_r8,0.49598e-05_r8,0.59987e-05_r8,0.60289e-05_r8,0.35123e-05_r8 /)
      kbo(:, 2,46, 6) = (/ &
        & 0.26595e-06_r8,0.54355e-05_r8,0.65411e-05_r8,0.66383e-05_r8,0.39494e-05_r8 /)
      kbo(:, 3,46, 6) = (/ &
        & 0.28328e-06_r8,0.59173e-05_r8,0.71233e-05_r8,0.72943e-05_r8,0.44113e-05_r8 /)
      kbo(:, 4,46, 6) = (/ &
        & 0.29735e-06_r8,0.64123e-05_r8,0.77406e-05_r8,0.79904e-05_r8,0.48883e-05_r8 /)
      kbo(:, 5,46, 6) = (/ &
        & 0.30876e-06_r8,0.69283e-05_r8,0.83913e-05_r8,0.87211e-05_r8,0.53766e-05_r8 /)
      kbo(:, 1,47, 6) = (/ &
        & 0.19287e-06_r8,0.40134e-05_r8,0.48586e-05_r8,0.48718e-05_r8,0.28114e-05_r8 /)
      kbo(:, 2,47, 6) = (/ &
        & 0.21123e-06_r8,0.44208e-05_r8,0.53178e-05_r8,0.53794e-05_r8,0.31781e-05_r8 /)
      kbo(:, 3,47, 6) = (/ &
        & 0.22658e-06_r8,0.48332e-05_r8,0.58104e-05_r8,0.59335e-05_r8,0.35646e-05_r8 /)
      kbo(:, 4,47, 6) = (/ &
        & 0.23912e-06_r8,0.52582e-05_r8,0.63354e-05_r8,0.65230e-05_r8,0.39676e-05_r8 /)
      kbo(:, 5,47, 6) = (/ &
        & 0.24931e-06_r8,0.57025e-05_r8,0.68920e-05_r8,0.71458e-05_r8,0.43826e-05_r8 /)
      kbo(:, 1,48, 6) = (/ &
        & 0.15132e-06_r8,0.32395e-05_r8,0.39269e-05_r8,0.39289e-05_r8,0.22458e-05_r8 /)
      kbo(:, 2,48, 6) = (/ &
        & 0.16716e-06_r8,0.35866e-05_r8,0.43144e-05_r8,0.43511e-05_r8,0.25512e-05_r8 /)
      kbo(:, 3,48, 6) = (/ &
        & 0.18076e-06_r8,0.39391e-05_r8,0.47294e-05_r8,0.48161e-05_r8,0.28746e-05_r8 /)
      kbo(:, 4,48, 6) = (/ &
        & 0.19194e-06_r8,0.43030e-05_r8,0.51748e-05_r8,0.53142e-05_r8,0.32135e-05_r8 /)
      kbo(:, 5,48, 6) = (/ &
        & 0.20099e-06_r8,0.46842e-05_r8,0.56488e-05_r8,0.58430e-05_r8,0.35644e-05_r8 /)
      kbo(:, 1,49, 6) = (/ &
        & 0.11828e-06_r8,0.26078e-05_r8,0.31672e-05_r8,0.31617e-05_r8,0.17894e-05_r8 /)
      kbo(:, 2,49, 6) = (/ &
        & 0.13185e-06_r8,0.29029e-05_r8,0.34929e-05_r8,0.35125e-05_r8,0.20423e-05_r8 /)
      kbo(:, 3,49, 6) = (/ &
        & 0.14378e-06_r8,0.32030e-05_r8,0.38409e-05_r8,0.39000e-05_r8,0.23121e-05_r8 /)
      kbo(:, 4,49, 6) = (/ &
        & 0.15369e-06_r8,0.35139e-05_r8,0.42179e-05_r8,0.43198e-05_r8,0.25971e-05_r8 /)
      kbo(:, 5,49, 6) = (/ &
        & 0.16176e-06_r8,0.38391e-05_r8,0.46198e-05_r8,0.47667e-05_r8,0.28929e-05_r8 /)
      kbo(:, 1,50, 6) = (/ &
        & 0.92362e-07_r8,0.20997e-05_r8,0.25556e-05_r8,0.25471e-05_r8,0.14267e-05_r8 /)
      kbo(:, 2,50, 6) = (/ &
        & 0.10390e-06_r8,0.23496e-05_r8,0.28286e-05_r8,0.28368e-05_r8,0.16356e-05_r8 /)
      kbo(:, 3,50, 6) = (/ &
        & 0.11421e-06_r8,0.26049e-05_r8,0.31213e-05_r8,0.31606e-05_r8,0.18609e-05_r8 /)
      kbo(:, 4,50, 6) = (/ &
        & 0.12297e-06_r8,0.28694e-05_r8,0.34392e-05_r8,0.35125e-05_r8,0.20996e-05_r8 /)
      kbo(:, 5,50, 6) = (/ &
        & 0.13012e-06_r8,0.31471e-05_r8,0.37794e-05_r8,0.38900e-05_r8,0.23486e-05_r8 /)
      kbo(:, 1,51, 6) = (/ &
        & 0.72029e-07_r8,0.16879e-05_r8,0.20606e-05_r8,0.20506e-05_r8,0.11365e-05_r8 /)
      kbo(:, 2,51, 6) = (/ &
        & 0.81717e-07_r8,0.18994e-05_r8,0.22886e-05_r8,0.22902e-05_r8,0.13081e-05_r8 /)
      kbo(:, 3,51, 6) = (/ &
        & 0.90547e-07_r8,0.21162e-05_r8,0.25347e-05_r8,0.25588e-05_r8,0.14964e-05_r8 /)
      kbo(:, 4,51, 6) = (/ &
        & 0.98231e-07_r8,0.23407e-05_r8,0.28017e-05_r8,0.28537e-05_r8,0.16958e-05_r8 /)
      kbo(:, 5,51, 6) = (/ &
        & 0.10454e-06_r8,0.25770e-05_r8,0.30891e-05_r8,0.31719e-05_r8,0.19053e-05_r8 /)
      kbo(:, 1,52, 6) = (/ &
        & 0.55994e-07_r8,0.13535e-05_r8,0.16583e-05_r8,0.16483e-05_r8,0.90215e-06_r8 /)
      kbo(:, 2,52, 6) = (/ &
        & 0.64065e-07_r8,0.15318e-05_r8,0.18483e-05_r8,0.18452e-05_r8,0.10447e-05_r8 /)
      kbo(:, 3,52, 6) = (/ &
        & 0.71601e-07_r8,0.17156e-05_r8,0.20541e-05_r8,0.20679e-05_r8,0.12005e-05_r8 /)
      kbo(:, 4,52, 6) = (/ &
        & 0.78265e-07_r8,0.19055e-05_r8,0.22786e-05_r8,0.23151e-05_r8,0.13673e-05_r8 /)
      kbo(:, 5,52, 6) = (/ &
        & 0.83827e-07_r8,0.21062e-05_r8,0.25201e-05_r8,0.25812e-05_r8,0.15426e-05_r8 /)
      kbo(:, 1,53, 6) = (/ &
        & 0.43376e-07_r8,0.10823e-05_r8,0.13316e-05_r8,0.13229e-05_r8,0.71387e-06_r8 /)
      kbo(:, 2,53, 6) = (/ &
        & 0.50078e-07_r8,0.12320e-05_r8,0.14898e-05_r8,0.14843e-05_r8,0.83196e-06_r8 /)
      kbo(:, 3,53, 6) = (/ &
        & 0.56440e-07_r8,0.13873e-05_r8,0.16612e-05_r8,0.16678e-05_r8,0.96085e-06_r8 /)
      kbo(:, 4,53, 6) = (/ &
        & 0.62188e-07_r8,0.15481e-05_r8,0.18489e-05_r8,0.18736e-05_r8,0.10995e-05_r8 /)
      kbo(:, 5,53, 6) = (/ &
        & 0.67072e-07_r8,0.17179e-05_r8,0.20520e-05_r8,0.20964e-05_r8,0.12465e-05_r8 /)
      kbo(:, 1,54, 6) = (/ &
        & 0.33662e-07_r8,0.86685e-06_r8,0.10712e-05_r8,0.10638e-05_r8,0.56675e-06_r8 /)
      kbo(:, 2,54, 6) = (/ &
        & 0.39188e-07_r8,0.99237e-06_r8,0.12024e-05_r8,0.11965e-05_r8,0.66407e-06_r8 /)
      kbo(:, 3,54, 6) = (/ &
        & 0.44517e-07_r8,0.11234e-05_r8,0.13453e-05_r8,0.13477e-05_r8,0.77015e-06_r8 /)
      kbo(:, 4,54, 6) = (/ &
        & 0.49410e-07_r8,0.12591e-05_r8,0.15022e-05_r8,0.15186e-05_r8,0.88568e-06_r8 /)
      kbo(:, 5,54, 6) = (/ &
        & 0.53662e-07_r8,0.14028e-05_r8,0.16732e-05_r8,0.17054e-05_r8,0.10088e-05_r8 /)
      kbo(:, 1,55, 6) = (/ &
        & 0.26107e-07_r8,0.69409e-06_r8,0.86148e-06_r8,0.85535e-06_r8,0.44993e-06_r8 /)
      kbo(:, 2,55, 6) = (/ &
        & 0.30648e-07_r8,0.79874e-06_r8,0.97050e-06_r8,0.96432e-06_r8,0.52987e-06_r8 /)
      kbo(:, 3,55, 6) = (/ &
        & 0.35070e-07_r8,0.90919e-06_r8,0.10893e-05_r8,0.10889e-05_r8,0.61727e-06_r8 /)
      kbo(:, 4,55, 6) = (/ &
        & 0.39223e-07_r8,0.10237e-05_r8,0.12206e-05_r8,0.12308e-05_r8,0.71345e-06_r8 /)
      kbo(:, 5,55, 6) = (/ &
        & 0.42897e-07_r8,0.11450e-05_r8,0.13641e-05_r8,0.13878e-05_r8,0.81614e-06_r8 /)
      kbo(:, 1,56, 6) = (/ &
        & 0.20183e-07_r8,0.55461e-06_r8,0.69187e-06_r8,0.68686e-06_r8,0.35634e-06_r8 /)
      kbo(:, 2,56, 6) = (/ &
        & 0.23906e-07_r8,0.64143e-06_r8,0.78193e-06_r8,0.77615e-06_r8,0.42133e-06_r8 /)
      kbo(:, 3,56, 6) = (/ &
        & 0.27573e-07_r8,0.73422e-06_r8,0.88059e-06_r8,0.87848e-06_r8,0.49387e-06_r8 /)
      kbo(:, 4,56, 6) = (/ &
        & 0.31066e-07_r8,0.83083e-06_r8,0.99001e-06_r8,0.99604e-06_r8,0.57362e-06_r8 /)
      kbo(:, 5,56, 6) = (/ &
        & 0.34213e-07_r8,0.93302e-06_r8,0.11103e-05_r8,0.11271e-05_r8,0.65906e-06_r8 /)
      kbo(:, 1,57, 6) = (/ &
        & 0.15553e-07_r8,0.44221e-06_r8,0.55475e-06_r8,0.55051e-06_r8,0.28158e-06_r8 /)
      kbo(:, 2,57, 6) = (/ &
        & 0.18597e-07_r8,0.51387e-06_r8,0.62883e-06_r8,0.62381e-06_r8,0.33432e-06_r8 /)
      kbo(:, 3,57, 6) = (/ &
        & 0.21627e-07_r8,0.59165e-06_r8,0.71079e-06_r8,0.70768e-06_r8,0.39423e-06_r8 /)
      kbo(:, 4,57, 6) = (/ &
        & 0.24548e-07_r8,0.67286e-06_r8,0.80159e-06_r8,0.80451e-06_r8,0.46009e-06_r8 /)
      kbo(:, 5,57, 6) = (/ &
        & 0.27223e-07_r8,0.75870e-06_r8,0.90196e-06_r8,0.91372e-06_r8,0.53126e-06_r8 /)
      kbo(:, 1,58, 6) = (/ &
        & 0.11989e-07_r8,0.35271e-06_r8,0.44504e-06_r8,0.44164e-06_r8,0.22247e-06_r8 /)
      kbo(:, 2,58, 6) = (/ &
        & 0.14473e-07_r8,0.41167e-06_r8,0.50593e-06_r8,0.50179e-06_r8,0.26557e-06_r8 /)
      kbo(:, 3,58, 6) = (/ &
        & 0.16959e-07_r8,0.47681e-06_r8,0.57389e-06_r8,0.57055e-06_r8,0.31488e-06_r8 /)
      kbo(:, 4,58, 6) = (/ &
        & 0.19386e-07_r8,0.54503e-06_r8,0.64933e-06_r8,0.65043e-06_r8,0.36927e-06_r8 /)
      kbo(:, 5,58, 6) = (/ &
        & 0.21655e-07_r8,0.61705e-06_r8,0.73285e-06_r8,0.74092e-06_r8,0.42823e-06_r8 /)
      kbo(:, 1,59, 6) = (/ &
        & 0.95745e-08_r8,0.28909e-06_r8,0.36504e-06_r8,0.36221e-06_r8,0.18143e-06_r8 /)
      kbo(:, 2,59, 6) = (/ &
        & 0.11602e-07_r8,0.33869e-06_r8,0.41625e-06_r8,0.41267e-06_r8,0.21754e-06_r8 /)
      kbo(:, 3,59, 6) = (/ &
        & 0.13639e-07_r8,0.39363e-06_r8,0.47345e-06_r8,0.47053e-06_r8,0.25873e-06_r8 /)
      kbo(:, 4,59, 6) = (/ &
        & 0.15635e-07_r8,0.45132e-06_r8,0.53722e-06_r8,0.53779e-06_r8,0.30436e-06_r8 /)
      kbo(:, 5,59, 6) = (/ &
        & 0.17515e-07_r8,0.51255e-06_r8,0.60804e-06_r8,0.61445e-06_r8,0.35395e-06_r8 /)
      kbo(:, 1,13, 7) = (/ &
        & 0.13818e-02_r8,0.53095e-02_r8,0.61744e-02_r8,0.61409e-02_r8,0.38201e-02_r8 /)
      kbo(:, 2,13, 7) = (/ &
        & 0.14927e-02_r8,0.54262e-02_r8,0.63169e-02_r8,0.63268e-02_r8,0.39787e-02_r8 /)
      kbo(:, 3,13, 7) = (/ &
        & 0.15882e-02_r8,0.55245e-02_r8,0.64575e-02_r8,0.65042e-02_r8,0.41285e-02_r8 /)
      kbo(:, 4,13, 7) = (/ &
        & 0.16683e-02_r8,0.56028e-02_r8,0.65859e-02_r8,0.66764e-02_r8,0.42766e-02_r8 /)
      kbo(:, 5,13, 7) = (/ &
        & 0.17364e-02_r8,0.56642e-02_r8,0.66996e-02_r8,0.68400e-02_r8,0.44196e-02_r8 /)
      kbo(:, 1,14, 7) = (/ &
        & 0.11439e-02_r8,0.44642e-02_r8,0.52052e-02_r8,0.51954e-02_r8,0.32185e-02_r8 /)
      kbo(:, 2,14, 7) = (/ &
        & 0.12322e-02_r8,0.45612e-02_r8,0.53295e-02_r8,0.53554e-02_r8,0.33544e-02_r8 /)
      kbo(:, 3,14, 7) = (/ &
        & 0.13082e-02_r8,0.46425e-02_r8,0.54474e-02_r8,0.55111e-02_r8,0.34869e-02_r8 /)
      kbo(:, 4,14, 7) = (/ &
        & 0.13723e-02_r8,0.47078e-02_r8,0.55568e-02_r8,0.56605e-02_r8,0.36178e-02_r8 /)
      kbo(:, 5,14, 7) = (/ &
        & 0.14273e-02_r8,0.47614e-02_r8,0.56536e-02_r8,0.58004e-02_r8,0.37445e-02_r8 /)
      kbo(:, 1,15, 7) = (/ &
        & 0.94600e-03_r8,0.37452e-02_r8,0.43786e-02_r8,0.43839e-02_r8,0.27064e-02_r8 /)
      kbo(:, 2,15, 7) = (/ &
        & 0.10166e-02_r8,0.38272e-02_r8,0.44845e-02_r8,0.45238e-02_r8,0.28259e-02_r8 /)
      kbo(:, 3,15, 7) = (/ &
        & 0.10772e-02_r8,0.38951e-02_r8,0.45852e-02_r8,0.46569e-02_r8,0.29424e-02_r8 /)
      kbo(:, 4,15, 7) = (/ &
        & 0.11287e-02_r8,0.39508e-02_r8,0.46776e-02_r8,0.47856e-02_r8,0.30573e-02_r8 /)
      kbo(:, 5,15, 7) = (/ &
        & 0.11727e-02_r8,0.39984e-02_r8,0.47639e-02_r8,0.49094e-02_r8,0.31707e-02_r8 /)
      kbo(:, 1,16, 7) = (/ &
        & 0.78170e-03_r8,0.31386e-02_r8,0.36753e-02_r8,0.36925e-02_r8,0.22749e-02_r8 /)
      kbo(:, 2,16, 7) = (/ &
        & 0.83828e-03_r8,0.32067e-02_r8,0.37655e-02_r8,0.38108e-02_r8,0.23791e-02_r8 /)
      kbo(:, 3,16, 7) = (/ &
        & 0.88677e-03_r8,0.32636e-02_r8,0.38524e-02_r8,0.39267e-02_r8,0.24809e-02_r8 /)
      kbo(:, 4,16, 7) = (/ &
        & 0.92814e-03_r8,0.33127e-02_r8,0.39332e-02_r8,0.40389e-02_r8,0.25819e-02_r8 /)
      kbo(:, 5,16, 7) = (/ &
        & 0.96342e-03_r8,0.33561e-02_r8,0.40123e-02_r8,0.41493e-02_r8,0.26825e-02_r8 /)
      kbo(:, 1,17, 7) = (/ &
        & 0.64513e-03_r8,0.26258e-02_r8,0.30792e-02_r8,0.31027e-02_r8,0.19109e-02_r8 /)
      kbo(:, 2,17, 7) = (/ &
        & 0.69065e-03_r8,0.26830e-02_r8,0.31573e-02_r8,0.32056e-02_r8,0.20013e-02_r8 /)
      kbo(:, 3,17, 7) = (/ &
        & 0.72951e-03_r8,0.27321e-02_r8,0.32326e-02_r8,0.33061e-02_r8,0.20905e-02_r8 /)
      kbo(:, 4,17, 7) = (/ &
        & 0.76279e-03_r8,0.27759e-02_r8,0.33057e-02_r8,0.34049e-02_r8,0.21791e-02_r8 /)
      kbo(:, 5,17, 7) = (/ &
        & 0.79127e-03_r8,0.28164e-02_r8,0.33776e-02_r8,0.35037e-02_r8,0.22680e-02_r8 /)
      kbo(:, 1,18, 7) = (/ &
        & 0.53216e-03_r8,0.21945e-02_r8,0.25768e-02_r8,0.26041e-02_r8,0.16047e-02_r8 /)
      kbo(:, 2,18, 7) = (/ &
        & 0.56878e-03_r8,0.22431e-02_r8,0.26453e-02_r8,0.26934e-02_r8,0.16829e-02_r8 /)
      kbo(:, 3,18, 7) = (/ &
        & 0.60002e-03_r8,0.22864e-02_r8,0.27121e-02_r8,0.27812e-02_r8,0.17605e-02_r8 /)
      kbo(:, 4,18, 7) = (/ &
        & 0.62666e-03_r8,0.23265e-02_r8,0.27778e-02_r8,0.28689e-02_r8,0.18389e-02_r8 /)
      kbo(:, 5,18, 7) = (/ &
        & 0.64956e-03_r8,0.23645e-02_r8,0.28436e-02_r8,0.29587e-02_r8,0.19175e-02_r8 /)
      kbo(:, 1,19, 7) = (/ &
        & 0.43878e-03_r8,0.18328e-02_r8,0.21555e-02_r8,0.21844e-02_r8,0.13470e-02_r8 /)
      kbo(:, 2,19, 7) = (/ &
        & 0.46832e-03_r8,0.18749e-02_r8,0.22160e-02_r8,0.22619e-02_r8,0.14147e-02_r8 /)
      kbo(:, 3,19, 7) = (/ &
        & 0.49337e-03_r8,0.19136e-02_r8,0.22752e-02_r8,0.23395e-02_r8,0.14834e-02_r8 /)
      kbo(:, 4,19, 7) = (/ &
        & 0.51483e-03_r8,0.19509e-02_r8,0.23344e-02_r8,0.24177e-02_r8,0.15526e-02_r8 /)
      kbo(:, 5,19, 7) = (/ &
        & 0.53321e-03_r8,0.19863e-02_r8,0.23950e-02_r8,0.24983e-02_r8,0.16228e-02_r8 /)
      kbo(:, 1,20, 7) = (/ &
        & 0.36218e-03_r8,0.15310e-02_r8,0.18044e-02_r8,0.18333e-02_r8,0.11320e-02_r8 /)
      kbo(:, 2,20, 7) = (/ &
        & 0.38587e-03_r8,0.15681e-02_r8,0.18573e-02_r8,0.19010e-02_r8,0.11911e-02_r8 /)
      kbo(:, 3,20, 7) = (/ &
        & 0.40599e-03_r8,0.16034e-02_r8,0.19105e-02_r8,0.19693e-02_r8,0.12516e-02_r8 /)
      kbo(:, 4,20, 7) = (/ &
        & 0.42327e-03_r8,0.16372e-02_r8,0.19642e-02_r8,0.20400e-02_r8,0.13133e-02_r8 /)
      kbo(:, 5,20, 7) = (/ &
        & 0.43800e-03_r8,0.16702e-02_r8,0.20196e-02_r8,0.21120e-02_r8,0.13760e-02_r8 /)
      kbo(:, 1,21, 7) = (/ &
        & 0.29894e-03_r8,0.12794e-02_r8,0.15109e-02_r8,0.15392e-02_r8,0.95196e-03_r8 /)
      kbo(:, 2,21, 7) = (/ &
        & 0.31795e-03_r8,0.13126e-02_r8,0.15578e-02_r8,0.15985e-02_r8,0.10041e-02_r8 /)
      kbo(:, 3,21, 7) = (/ &
        & 0.33409e-03_r8,0.13444e-02_r8,0.16054e-02_r8,0.16590e-02_r8,0.10575e-02_r8 /)
      kbo(:, 4,21, 7) = (/ &
        & 0.34798e-03_r8,0.13752e-02_r8,0.16542e-02_r8,0.17228e-02_r8,0.11124e-02_r8 /)
      kbo(:, 5,21, 7) = (/ &
        & 0.35982e-03_r8,0.14062e-02_r8,0.17046e-02_r8,0.17872e-02_r8,0.11688e-02_r8 /)
      kbo(:, 1,22, 7) = (/ &
        & 0.24779e-03_r8,0.10720e-02_r8,0.12687e-02_r8,0.12959e-02_r8,0.80428e-03_r8 /)
      kbo(:, 2,22, 7) = (/ &
        & 0.26287e-03_r8,0.11012e-02_r8,0.13104e-02_r8,0.13483e-02_r8,0.85046e-03_r8 /)
      kbo(:, 3,22, 7) = (/ &
        & 0.27570e-03_r8,0.11300e-02_r8,0.13532e-02_r8,0.14032e-02_r8,0.89796e-03_r8 /)
      kbo(:, 4,22, 7) = (/ &
        & 0.28676e-03_r8,0.11583e-02_r8,0.13978e-02_r8,0.14602e-02_r8,0.94722e-03_r8 /)
      kbo(:, 5,22, 7) = (/ &
        & 0.29612e-03_r8,0.11873e-02_r8,0.14439e-02_r8,0.15185e-02_r8,0.99812e-03_r8 /)
      kbo(:, 1,23, 7) = (/ &
        & 0.20536e-03_r8,0.89901e-03_r8,0.10666e-02_r8,0.10925e-02_r8,0.68077e-03_r8 /)
      kbo(:, 2,23, 7) = (/ &
        & 0.21732e-03_r8,0.92514e-03_r8,0.11037e-02_r8,0.11394e-02_r8,0.72189e-03_r8 /)
      kbo(:, 3,23, 7) = (/ &
        & 0.22752e-03_r8,0.95109e-03_r8,0.11426e-02_r8,0.11888e-02_r8,0.76437e-03_r8 /)
      kbo(:, 4,23, 7) = (/ &
        & 0.23632e-03_r8,0.97728e-03_r8,0.11832e-02_r8,0.12403e-02_r8,0.80877e-03_r8 /)
      kbo(:, 5,23, 7) = (/ &
        & 0.24369e-03_r8,0.10040e-02_r8,0.12260e-02_r8,0.12934e-02_r8,0.85489e-03_r8 /)
      kbo(:, 1,24, 7) = (/ &
        & 0.17021e-03_r8,0.75506e-03_r8,0.89800e-03_r8,0.92265e-03_r8,0.57788e-03_r8 /)
      kbo(:, 2,24, 7) = (/ &
        & 0.17969e-03_r8,0.77853e-03_r8,0.93149e-03_r8,0.96497e-03_r8,0.61443e-03_r8 /)
      kbo(:, 3,24, 7) = (/ &
        & 0.18778e-03_r8,0.80207e-03_r8,0.96680e-03_r8,0.10097e-02_r8,0.65278e-03_r8 /)
      kbo(:, 4,24, 7) = (/ &
        & 0.19477e-03_r8,0.82622e-03_r8,0.10041e-02_r8,0.10564e-02_r8,0.69293e-03_r8 /)
      kbo(:, 5,24, 7) = (/ &
        & 0.20055e-03_r8,0.85104e-03_r8,0.10439e-02_r8,0.11053e-02_r8,0.73424e-03_r8 /)
      kbo(:, 1,25, 7) = (/ &
        & 0.14110e-03_r8,0.63531e-03_r8,0.75746e-03_r8,0.78109e-03_r8,0.49195e-03_r8 /)
      kbo(:, 2,25, 7) = (/ &
        & 0.14860e-03_r8,0.65629e-03_r8,0.78801e-03_r8,0.81951e-03_r8,0.52472e-03_r8 /)
      kbo(:, 3,25, 7) = (/ &
        & 0.15502e-03_r8,0.67802e-03_r8,0.82018e-03_r8,0.86005e-03_r8,0.55929e-03_r8 /)
      kbo(:, 4,25, 7) = (/ &
        & 0.16054e-03_r8,0.70023e-03_r8,0.85487e-03_r8,0.90270e-03_r8,0.59546e-03_r8 /)
      kbo(:, 5,25, 7) = (/ &
        & 0.16506e-03_r8,0.72333e-03_r8,0.89213e-03_r8,0.94794e-03_r8,0.63296e-03_r8 /)
      kbo(:, 1,26, 7) = (/ &
        & 0.11704e-03_r8,0.53563e-03_r8,0.64089e-03_r8,0.66348e-03_r8,0.42036e-03_r8 /)
      kbo(:, 2,26, 7) = (/ &
        & 0.12296e-03_r8,0.55482e-03_r8,0.66859e-03_r8,0.69842e-03_r8,0.44986e-03_r8 /)
      kbo(:, 3,26, 7) = (/ &
        & 0.12804e-03_r8,0.57460e-03_r8,0.69838e-03_r8,0.73532e-03_r8,0.48115e-03_r8 /)
      kbo(:, 4,26, 7) = (/ &
        & 0.13237e-03_r8,0.59528e-03_r8,0.73081e-03_r8,0.77472e-03_r8,0.51371e-03_r8 /)
      kbo(:, 5,26, 7) = (/ &
        & 0.13587e-03_r8,0.61708e-03_r8,0.76562e-03_r8,0.81649e-03_r8,0.54800e-03_r8 /)
      kbo(:, 1,27, 7) = (/ &
        & 0.97037e-04_r8,0.45263e-03_r8,0.54353e-03_r8,0.56528e-03_r8,0.36031e-03_r8 /)
      kbo(:, 2,27, 7) = (/ &
        & 0.10171e-03_r8,0.47018e-03_r8,0.56899e-03_r8,0.59710e-03_r8,0.38698e-03_r8 /)
      kbo(:, 3,27, 7) = (/ &
        & 0.10572e-03_r8,0.48833e-03_r8,0.59675e-03_r8,0.63096e-03_r8,0.41505e-03_r8 /)
      kbo(:, 4,27, 7) = (/ &
        & 0.10911e-03_r8,0.50767e-03_r8,0.62713e-03_r8,0.66736e-03_r8,0.44466e-03_r8 /)
      kbo(:, 5,27, 7) = (/ &
        & 0.11182e-03_r8,0.52830e-03_r8,0.65949e-03_r8,0.70600e-03_r8,0.47625e-03_r8 /)
      kbo(:, 1,28, 7) = (/ &
        & 0.80419e-04_r8,0.38349e-03_r8,0.46224e-03_r8,0.48308e-03_r8,0.30982e-03_r8 /)
      kbo(:, 2,28, 7) = (/ &
        & 0.84110e-04_r8,0.39943e-03_r8,0.48584e-03_r8,0.51214e-03_r8,0.33386e-03_r8 /)
      kbo(:, 3,28, 7) = (/ &
        & 0.87283e-04_r8,0.41636e-03_r8,0.51189e-03_r8,0.54353e-03_r8,0.35924e-03_r8 /)
      kbo(:, 4,28, 7) = (/ &
        & 0.89914e-04_r8,0.43456e-03_r8,0.54020e-03_r8,0.57698e-03_r8,0.38635e-03_r8 /)
      kbo(:, 5,28, 7) = (/ &
        & 0.92003e-04_r8,0.45406e-03_r8,0.57030e-03_r8,0.61286e-03_r8,0.41553e-03_r8 /)
      kbo(:, 1,29, 7) = (/ &
        & 0.66637e-04_r8,0.32580e-03_r8,0.39453e-03_r8,0.41439e-03_r8,0.26738e-03_r8 /)
      kbo(:, 2,29, 7) = (/ &
        & 0.69552e-04_r8,0.34052e-03_r8,0.41660e-03_r8,0.44116e-03_r8,0.28904e-03_r8 /)
      kbo(:, 3,29, 7) = (/ &
        & 0.72042e-04_r8,0.35633e-03_r8,0.44102e-03_r8,0.47005e-03_r8,0.31218e-03_r8 /)
      kbo(:, 4,29, 7) = (/ &
        & 0.74082e-04_r8,0.37351e-03_r8,0.46731e-03_r8,0.50108e-03_r8,0.33714e-03_r8 /)
      kbo(:, 5,29, 7) = (/ &
        & 0.75692e-04_r8,0.39190e-03_r8,0.49529e-03_r8,0.53447e-03_r8,0.36421e-03_r8 /)
      kbo(:, 1,30, 7) = (/ &
        & 0.55194e-04_r8,0.27757e-03_r8,0.33804e-03_r8,0.35670e-03_r8,0.23148e-03_r8 /)
      kbo(:, 2,30, 7) = (/ &
        & 0.57489e-04_r8,0.29130e-03_r8,0.35876e-03_r8,0.38143e-03_r8,0.25115e-03_r8 /)
      kbo(:, 3,30, 7) = (/ &
        & 0.59445e-04_r8,0.30619e-03_r8,0.38148e-03_r8,0.40810e-03_r8,0.27242e-03_r8 /)
      kbo(:, 4,30, 7) = (/ &
        & 0.61024e-04_r8,0.32233e-03_r8,0.40578e-03_r8,0.43698e-03_r8,0.29552e-03_r8 /)
      kbo(:, 5,30, 7) = (/ &
        & 0.62251e-04_r8,0.33969e-03_r8,0.43185e-03_r8,0.46830e-03_r8,0.32052e-03_r8 /)
      kbo(:, 1,31, 7) = (/ &
        & 0.45701e-04_r8,0.23736e-03_r8,0.29086e-03_r8,0.30834e-03_r8,0.20114e-03_r8 /)
      kbo(:, 2,31, 7) = (/ &
        & 0.47516e-04_r8,0.25020e-03_r8,0.31032e-03_r8,0.33113e-03_r8,0.21916e-03_r8 /)
      kbo(:, 3,31, 7) = (/ &
        & 0.49034e-04_r8,0.26424e-03_r8,0.33131e-03_r8,0.35593e-03_r8,0.23874e-03_r8 /)
      kbo(:, 4,31, 7) = (/ &
        & 0.50247e-04_r8,0.27943e-03_r8,0.35395e-03_r8,0.38299e-03_r8,0.26024e-03_r8 /)
      kbo(:, 5,31, 7) = (/ &
        & 0.51186e-04_r8,0.29578e-03_r8,0.37829e-03_r8,0.41250e-03_r8,0.28341e-03_r8 /)
      kbo(:, 1,32, 7) = (/ &
        & 0.37829e-04_r8,0.20379e-03_r8,0.25145e-03_r8,0.26761e-03_r8,0.17549e-03_r8 /)
      kbo(:, 2,32, 7) = (/ &
        & 0.39256e-04_r8,0.21585e-03_r8,0.26951e-03_r8,0.28871e-03_r8,0.19207e-03_r8 /)
      kbo(:, 3,32, 7) = (/ &
        & 0.40434e-04_r8,0.22904e-03_r8,0.28903e-03_r8,0.31192e-03_r8,0.21034e-03_r8 /)
      kbo(:, 4,32, 7) = (/ &
        & 0.41367e-04_r8,0.24332e-03_r8,0.31020e-03_r8,0.33744e-03_r8,0.23024e-03_r8 /)
      kbo(:, 5,32, 7) = (/ &
        & 0.42072e-04_r8,0.25873e-03_r8,0.33309e-03_r8,0.36527e-03_r8,0.25179e-03_r8 /)
      kbo(:, 1,33, 7) = (/ &
        & 0.31302e-04_r8,0.17572e-03_r8,0.21830e-03_r8,0.23321e-03_r8,0.15375e-03_r8 /)
      kbo(:, 2,33, 7) = (/ &
        & 0.32419e-04_r8,0.18706e-03_r8,0.23504e-03_r8,0.25291e-03_r8,0.16915e-03_r8 /)
      kbo(:, 3,33, 7) = (/ &
        & 0.33327e-04_r8,0.19940e-03_r8,0.25328e-03_r8,0.27479e-03_r8,0.18617e-03_r8 /)
      kbo(:, 4,33, 7) = (/ &
        & 0.34039e-04_r8,0.21283e-03_r8,0.27315e-03_r8,0.29887e-03_r8,0.20465e-03_r8 /)
      kbo(:, 5,33, 7) = (/ &
        & 0.34568e-04_r8,0.22731e-03_r8,0.29474e-03_r8,0.32519e-03_r8,0.22485e-03_r8 /)
      kbo(:, 1,34, 7) = (/ &
        & 0.25851e-04_r8,0.15182e-03_r8,0.18976e-03_r8,0.20353e-03_r8,0.13483e-03_r8 /)
      kbo(:, 2,34, 7) = (/ &
        & 0.26731e-04_r8,0.16241e-03_r8,0.20531e-03_r8,0.22199e-03_r8,0.14918e-03_r8 /)
      kbo(:, 3,34, 7) = (/ &
        & 0.27437e-04_r8,0.17395e-03_r8,0.22237e-03_r8,0.24258e-03_r8,0.16491e-03_r8 /)
      kbo(:, 4,34, 7) = (/ &
        & 0.27988e-04_r8,0.18656e-03_r8,0.24113e-03_r8,0.26529e-03_r8,0.18217e-03_r8 /)
      kbo(:, 5,34, 7) = (/ &
        & 0.28384e-04_r8,0.20017e-03_r8,0.26144e-03_r8,0.29020e-03_r8,0.20116e-03_r8 /)
      kbo(:, 1,35, 7) = (/ &
        & 0.21271e-04_r8,0.13078e-03_r8,0.16426e-03_r8,0.17685e-03_r8,0.11756e-03_r8 /)
      kbo(:, 2,35, 7) = (/ &
        & 0.21975e-04_r8,0.14058e-03_r8,0.17865e-03_r8,0.19403e-03_r8,0.13072e-03_r8 /)
      kbo(:, 3,35, 7) = (/ &
        & 0.22533e-04_r8,0.15132e-03_r8,0.19456e-03_r8,0.21323e-03_r8,0.14523e-03_r8 /)
      kbo(:, 4,35, 7) = (/ &
        & 0.22966e-04_r8,0.16307e-03_r8,0.21206e-03_r8,0.23454e-03_r8,0.16133e-03_r8 /)
      kbo(:, 5,35, 7) = (/ &
        & 0.23274e-04_r8,0.17579e-03_r8,0.23112e-03_r8,0.25800e-03_r8,0.17911e-03_r8 /)
      kbo(:, 1,36, 7) = (/ &
        & 0.17431e-04_r8,0.11205e-03_r8,0.14128e-03_r8,0.15260e-03_r8,0.10161e-03_r8 /)
      kbo(:, 2,36, 7) = (/ &
        & 0.18004e-04_r8,0.12103e-03_r8,0.15448e-03_r8,0.16840e-03_r8,0.11356e-03_r8 /)
      kbo(:, 3,36, 7) = (/ &
        & 0.18458e-04_r8,0.13095e-03_r8,0.16918e-03_r8,0.18616e-03_r8,0.12687e-03_r8 /)
      kbo(:, 4,36, 7) = (/ &
        & 0.18810e-04_r8,0.14182e-03_r8,0.18539e-03_r8,0.20596e-03_r8,0.14179e-03_r8 /)
      kbo(:, 5,36, 7) = (/ &
        & 0.19059e-04_r8,0.15363e-03_r8,0.20317e-03_r8,0.22788e-03_r8,0.15831e-03_r8 /)
      kbo(:, 1,37, 7) = (/ &
        & 0.14204e-04_r8,0.95010e-04_r8,0.12008e-03_r8,0.12996e-03_r8,0.86482e-04_r8 /)
      kbo(:, 2,37, 7) = (/ &
        & 0.14685e-04_r8,0.10313e-03_r8,0.13200e-03_r8,0.14426e-03_r8,0.97179e-04_r8 /)
      kbo(:, 3,37, 7) = (/ &
        & 0.15069e-04_r8,0.11214e-03_r8,0.14536e-03_r8,0.16042e-03_r8,0.10922e-03_r8 /)
      kbo(:, 4,37, 7) = (/ &
        & 0.15369e-04_r8,0.12211e-03_r8,0.16020e-03_r8,0.17855e-03_r8,0.12282e-03_r8 /)
      kbo(:, 5,37, 7) = (/ &
        & 0.15586e-04_r8,0.13296e-03_r8,0.17661e-03_r8,0.19876e-03_r8,0.13797e-03_r8 /)
      kbo(:, 1,38, 7) = (/ &
        & 0.11571e-04_r8,0.80545e-04_r8,0.10206e-03_r8,0.11063e-03_r8,0.73563e-04_r8 /)
      kbo(:, 2,38, 7) = (/ &
        & 0.11976e-04_r8,0.87875e-04_r8,0.11281e-03_r8,0.12357e-03_r8,0.83149e-04_r8 /)
      kbo(:, 3,38, 7) = (/ &
        & 0.12301e-04_r8,0.96063e-04_r8,0.12495e-03_r8,0.13829e-03_r8,0.94026e-04_r8 /)
      kbo(:, 4,38, 7) = (/ &
        & 0.12557e-04_r8,0.10518e-03_r8,0.13851e-03_r8,0.15487e-03_r8,0.10642e-03_r8 /)
      kbo(:, 5,38, 7) = (/ &
        & 0.12744e-04_r8,0.11515e-03_r8,0.15364e-03_r8,0.17352e-03_r8,0.12029e-03_r8 /)
      kbo(:, 1,39, 7) = (/ &
        & 0.94254e-05_r8,0.68333e-04_r8,0.86798e-04_r8,0.94247e-04_r8,0.62604e-04_r8 /)
      kbo(:, 2,39, 7) = (/ &
        & 0.97657e-05_r8,0.74945e-04_r8,0.96495e-04_r8,0.10595e-03_r8,0.71185e-04_r8 /)
      kbo(:, 3,39, 7) = (/ &
        & 0.10041e-04_r8,0.82376e-04_r8,0.10752e-03_r8,0.11934e-03_r8,0.81022e-04_r8 /)
      kbo(:, 4,39, 7) = (/ &
        & 0.10258e-04_r8,0.90687e-04_r8,0.11992e-03_r8,0.13453e-03_r8,0.92315e-04_r8 /)
      kbo(:, 5,39, 7) = (/ &
        & 0.10419e-04_r8,0.99852e-04_r8,0.13387e-03_r8,0.15177e-03_r8,0.10504e-03_r8 /)
      kbo(:, 1,40, 7) = (/ &
        & 0.76452e-05_r8,0.57428e-04_r8,0.73021e-04_r8,0.79333e-04_r8,0.52568e-04_r8 /)
      kbo(:, 2,40, 7) = (/ &
        & 0.79354e-05_r8,0.63315e-04_r8,0.81650e-04_r8,0.89752e-04_r8,0.60144e-04_r8 /)
      kbo(:, 3,40, 7) = (/ &
        & 0.81739e-05_r8,0.69961e-04_r8,0.91542e-04_r8,0.10176e-03_r8,0.68905e-04_r8 /)
      kbo(:, 4,40, 7) = (/ &
        & 0.83626e-05_r8,0.77456e-04_r8,0.10275e-03_r8,0.11552e-03_r8,0.79059e-04_r8 /)
      kbo(:, 5,40, 7) = (/ &
        & 0.85064e-05_r8,0.85795e-04_r8,0.11542e-03_r8,0.13128e-03_r8,0.90578e-04_r8 /)
      kbo(:, 1,41, 7) = (/ &
        & 0.61953e-05_r8,0.48163e-04_r8,0.61287e-04_r8,0.66616e-04_r8,0.44011e-04_r8 /)
      kbo(:, 2,41, 7) = (/ &
        & 0.64418e-05_r8,0.53383e-04_r8,0.68934e-04_r8,0.75842e-04_r8,0.50670e-04_r8 /)
      kbo(:, 3,41, 7) = (/ &
        & 0.66484e-05_r8,0.59312e-04_r8,0.77785e-04_r8,0.86580e-04_r8,0.58448e-04_r8 /)
      kbo(:, 4,41, 7) = (/ &
        & 0.68134e-05_r8,0.66054e-04_r8,0.87876e-04_r8,0.98995e-04_r8,0.67543e-04_r8 /)
      kbo(:, 5,41, 7) = (/ &
        & 0.69402e-05_r8,0.73614e-04_r8,0.99378e-04_r8,0.11337e-03_r8,0.77942e-04_r8 /)
      kbo(:, 1,42, 7) = (/ &
        & 0.50170e-05_r8,0.40358e-04_r8,0.51378e-04_r8,0.55875e-04_r8,0.36794e-04_r8 /)
      kbo(:, 2,42, 7) = (/ &
        & 0.52266e-05_r8,0.44971e-04_r8,0.58141e-04_r8,0.64024e-04_r8,0.42639e-04_r8 /)
      kbo(:, 3,42, 7) = (/ &
        & 0.54046e-05_r8,0.50250e-04_r8,0.66034e-04_r8,0.73601e-04_r8,0.49527e-04_r8 /)
      kbo(:, 4,42, 7) = (/ &
        & 0.55484e-05_r8,0.56302e-04_r8,0.75111e-04_r8,0.84788e-04_r8,0.57654e-04_r8 /)
      kbo(:, 5,42, 7) = (/ &
        & 0.56600e-05_r8,0.63153e-04_r8,0.85551e-04_r8,0.97898e-04_r8,0.67040e-04_r8 /)
      kbo(:, 1,43, 7) = (/ &
        & 0.40498e-05_r8,0.33563e-04_r8,0.42716e-04_r8,0.46433e-04_r8,0.30447e-04_r8 /)
      kbo(:, 2,43, 7) = (/ &
        & 0.42291e-05_r8,0.37603e-04_r8,0.48619e-04_r8,0.53551e-04_r8,0.35516e-04_r8 /)
      kbo(:, 3,43, 7) = (/ &
        & 0.43833e-05_r8,0.42260e-04_r8,0.55585e-04_r8,0.61999e-04_r8,0.41549e-04_r8 /)
      kbo(:, 4,43, 7) = (/ &
        & 0.45099e-05_r8,0.47650e-04_r8,0.63668e-04_r8,0.71964e-04_r8,0.48728e-04_r8 /)
      kbo(:, 5,43, 7) = (/ &
        & 0.46096e-05_r8,0.53790e-04_r8,0.73053e-04_r8,0.83779e-04_r8,0.57105e-04_r8 /)
      kbo(:, 1,44, 7) = (/ &
        & 0.32616e-05_r8,0.27781e-04_r8,0.35335e-04_r8,0.38366e-04_r8,0.25032e-04_r8 /)
      kbo(:, 2,44, 7) = (/ &
        & 0.34164e-05_r8,0.31296e-04_r8,0.40444e-04_r8,0.44531e-04_r8,0.29399e-04_r8 /)
      kbo(:, 3,44, 7) = (/ &
        & 0.35491e-05_r8,0.35375e-04_r8,0.46540e-04_r8,0.51925e-04_r8,0.34633e-04_r8 /)
      kbo(:, 4,44, 7) = (/ &
        & 0.36610e-05_r8,0.40146e-04_r8,0.53687e-04_r8,0.60738e-04_r8,0.40935e-04_r8 /)
      kbo(:, 5,44, 7) = (/ &
        & 0.37500e-05_r8,0.45618e-04_r8,0.62061e-04_r8,0.71298e-04_r8,0.48356e-04_r8 /)
      kbo(:, 1,45, 7) = (/ &
        & 0.26238e-05_r8,0.22952e-04_r8,0.29162e-04_r8,0.31630e-04_r8,0.20522e-04_r8 /)
      kbo(:, 2,45, 7) = (/ &
        & 0.27571e-05_r8,0.25992e-04_r8,0.33567e-04_r8,0.36938e-04_r8,0.24268e-04_r8 /)
      kbo(:, 3,45, 7) = (/ &
        & 0.28713e-05_r8,0.29549e-04_r8,0.38881e-04_r8,0.43383e-04_r8,0.28792e-04_r8 /)
      kbo(:, 4,45, 7) = (/ &
        & 0.29693e-05_r8,0.33760e-04_r8,0.45177e-04_r8,0.51149e-04_r8,0.34303e-04_r8 /)
      kbo(:, 5,45, 7) = (/ &
        & 0.30482e-05_r8,0.38627e-04_r8,0.52624e-04_r8,0.60551e-04_r8,0.40857e-04_r8 /)
      kbo(:, 1,46, 7) = (/ &
        & 0.21051e-05_r8,0.18867e-04_r8,0.23935e-04_r8,0.25917e-04_r8,0.16710e-04_r8 /)
      kbo(:, 2,46, 7) = (/ &
        & 0.22206e-05_r8,0.21480e-04_r8,0.27705e-04_r8,0.30449e-04_r8,0.19893e-04_r8 /)
      kbo(:, 3,46, 7) = (/ &
        & 0.23191e-05_r8,0.24557e-04_r8,0.32298e-04_r8,0.36019e-04_r8,0.23769e-04_r8 /)
      kbo(:, 4,46, 7) = (/ &
        & 0.24046e-05_r8,0.28239e-04_r8,0.37798e-04_r8,0.42807e-04_r8,0.28545e-04_r8 /)
      kbo(:, 5,46, 7) = (/ &
        & 0.24746e-05_r8,0.32543e-04_r8,0.44374e-04_r8,0.51109e-04_r8,0.34299e-04_r8 /)
      kbo(:, 1,47, 7) = (/ &
        & 0.16817e-05_r8,0.15386e-04_r8,0.19464e-04_r8,0.21024e-04_r8,0.13455e-04_r8 /)
      kbo(:, 2,47, 7) = (/ &
        & 0.17822e-05_r8,0.17605e-04_r8,0.22652e-04_r8,0.24840e-04_r8,0.16124e-04_r8 /)
      kbo(:, 3,47, 7) = (/ &
        & 0.18680e-05_r8,0.20236e-04_r8,0.26567e-04_r8,0.29585e-04_r8,0.19401e-04_r8 /)
      kbo(:, 4,47, 7) = (/ &
        & 0.19423e-05_r8,0.23413e-04_r8,0.31317e-04_r8,0.35433e-04_r8,0.23476e-04_r8 /)
      kbo(:, 5,47, 7) = (/ &
        & 0.20049e-05_r8,0.27181e-04_r8,0.37054e-04_r8,0.42668e-04_r8,0.28466e-04_r8 /)
      kbo(:, 1,48, 7) = (/ &
        & 0.13405e-05_r8,0.12514e-04_r8,0.15779e-04_r8,0.16993e-04_r8,0.10791e-04_r8 /)
      kbo(:, 2,48, 7) = (/ &
        & 0.14280e-05_r8,0.14385e-04_r8,0.18460e-04_r8,0.20187e-04_r8,0.13017e-04_r8 /)
      kbo(:, 3,48, 7) = (/ &
        & 0.15026e-05_r8,0.16623e-04_r8,0.21773e-04_r8,0.24205e-04_r8,0.15768e-04_r8 /)
      kbo(:, 4,48, 7) = (/ &
        & 0.15671e-05_r8,0.19354e-04_r8,0.25854e-04_r8,0.29218e-04_r8,0.19227e-04_r8 /)
      kbo(:, 5,48, 7) = (/ &
        & 0.16224e-05_r8,0.22629e-04_r8,0.30833e-04_r8,0.35479e-04_r8,0.23525e-04_r8 /)
      kbo(:, 1,49, 7) = (/ &
        & 0.10664e-05_r8,0.10149e-04_r8,0.12751e-04_r8,0.13684e-04_r8,0.86188e-05_r8 /)
      kbo(:, 2,49, 7) = (/ &
        & 0.11418e-05_r8,0.11720e-04_r8,0.14999e-04_r8,0.16352e-04_r8,0.10467e-04_r8 /)
      kbo(:, 3,49, 7) = (/ &
        & 0.12069e-05_r8,0.13612e-04_r8,0.17780e-04_r8,0.19716e-04_r8,0.12759e-04_r8 /)
      kbo(:, 4,49, 7) = (/ &
        & 0.12630e-05_r8,0.15945e-04_r8,0.21262e-04_r8,0.23990e-04_r8,0.15676e-04_r8 /)
      kbo(:, 5,49, 7) = (/ &
        & 0.13113e-05_r8,0.18775e-04_r8,0.25560e-04_r8,0.29382e-04_r8,0.19352e-04_r8 /)
      kbo(:, 1,50, 7) = (/ &
        & 0.84808e-06_r8,0.82401e-05_r8,0.10318e-04_r8,0.11036e-04_r8,0.68939e-05_r8 /)
      kbo(:, 2,50, 7) = (/ &
        & 0.91269e-06_r8,0.95513e-05_r8,0.12189e-04_r8,0.13247e-04_r8,0.84209e-05_r8 /)
      kbo(:, 3,50, 7) = (/ &
        & 0.96928e-06_r8,0.11160e-04_r8,0.14539e-04_r8,0.16084e-04_r8,0.10336e-04_r8 /)
      kbo(:, 4,50, 7) = (/ &
        & 0.10177e-05_r8,0.13146e-04_r8,0.17498e-04_r8,0.19711e-04_r8,0.12790e-04_r8 /)
      kbo(:, 5,50, 7) = (/ &
        & 0.10595e-05_r8,0.15592e-04_r8,0.21207e-04_r8,0.24356e-04_r8,0.15929e-04_r8 /)
      kbo(:, 1,51, 7) = (/ &
        & 0.67378e-06_r8,0.66826e-05_r8,0.83381e-05_r8,0.88828e-05_r8,0.55052e-05_r8 /)
      kbo(:, 2,51, 7) = (/ &
        & 0.72873e-06_r8,0.77753e-05_r8,0.98905e-05_r8,0.10714e-04_r8,0.67636e-05_r8 /)
      kbo(:, 3,51, 7) = (/ &
        & 0.77763e-06_r8,0.91368e-05_r8,0.11866e-04_r8,0.13091e-04_r8,0.83559e-05_r8 /)
      kbo(:, 4,51, 7) = (/ &
        & 0.81953e-06_r8,0.10824e-04_r8,0.14378e-04_r8,0.16168e-04_r8,0.10417e-04_r8 /)
      kbo(:, 5,51, 7) = (/ &
        & 0.85561e-06_r8,0.12933e-04_r8,0.17571e-04_r8,0.20159e-04_r8,0.13087e-04_r8 /)
      kbo(:, 1,52, 7) = (/ &
        & 0.53444e-06_r8,0.54066e-05_r8,0.67197e-05_r8,0.71297e-05_r8,0.43814e-05_r8 /)
      kbo(:, 2,52, 7) = (/ &
        & 0.58095e-06_r8,0.63124e-05_r8,0.79989e-05_r8,0.86346e-05_r8,0.54122e-05_r8 /)
      kbo(:, 3,52, 7) = (/ &
        & 0.62282e-06_r8,0.74561e-05_r8,0.96489e-05_r8,0.10614e-04_r8,0.67289e-05_r8 /)
      kbo(:, 4,52, 7) = (/ &
        & 0.65913e-06_r8,0.88917e-05_r8,0.11780e-04_r8,0.13220e-04_r8,0.84497e-05_r8 /)
      kbo(:, 5,52, 7) = (/ &
        & 0.69032e-06_r8,0.10691e-04_r8,0.14504e-04_r8,0.16615e-04_r8,0.10706e-04_r8 /)
      kbo(:, 1,53, 7) = (/ &
        & 0.42309e-06_r8,0.43635e-05_r8,0.54017e-05_r8,0.57047e-05_r8,0.34733e-05_r8 /)
      kbo(:, 2,53, 7) = (/ &
        & 0.46223e-06_r8,0.51097e-05_r8,0.64465e-05_r8,0.69322e-05_r8,0.43120e-05_r8 /)
      kbo(:, 3,53, 7) = (/ &
        & 0.49791e-06_r8,0.60643e-05_r8,0.78166e-05_r8,0.85690e-05_r8,0.53948e-05_r8 /)
      kbo(:, 4,53, 7) = (/ &
        & 0.52942e-06_r8,0.72726e-05_r8,0.96042e-05_r8,0.10748e-04_r8,0.68211e-05_r8 /)
      kbo(:, 5,53, 7) = (/ &
        & 0.55635e-06_r8,0.88074e-05_r8,0.11924e-04_r8,0.13632e-04_r8,0.87176e-05_r8 /)
      kbo(:, 1,54, 7) = (/ &
        & 0.33525e-06_r8,0.35291e-05_r8,0.43533e-05_r8,0.45783e-05_r8,0.27618e-05_r8 /)
      kbo(:, 2,54, 7) = (/ &
        & 0.36801e-06_r8,0.41464e-05_r8,0.52098e-05_r8,0.55821e-05_r8,0.34468e-05_r8 /)
      kbo(:, 3,54, 7) = (/ &
        & 0.39830e-06_r8,0.49442e-05_r8,0.63495e-05_r8,0.69393e-05_r8,0.43390e-05_r8 /)
      kbo(:, 4,54, 7) = (/ &
        & 0.42530e-06_r8,0.59638e-05_r8,0.78520e-05_r8,0.87652e-05_r8,0.55238e-05_r8 /)
      kbo(:, 5,54, 7) = (/ &
        & 0.44850e-06_r8,0.72711e-05_r8,0.98256e-05_r8,0.11213e-04_r8,0.71180e-05_r8 /)
      kbo(:, 1,55, 7) = (/ &
        & 0.26561e-06_r8,0.28535e-05_r8,0.35091e-05_r8,0.36747e-05_r8,0.21953e-05_r8 /)
      kbo(:, 2,55, 7) = (/ &
        & 0.29299e-06_r8,0.33630e-05_r8,0.42093e-05_r8,0.44935e-05_r8,0.27543e-05_r8 /)
      kbo(:, 3,55, 7) = (/ &
        & 0.31855e-06_r8,0.40286e-05_r8,0.51555e-05_r8,0.56160e-05_r8,0.34885e-05_r8 /)
      kbo(:, 4,55, 7) = (/ &
        & 0.34149e-06_r8,0.48884e-05_r8,0.64166e-05_r8,0.71432e-05_r8,0.44712e-05_r8 /)
      kbo(:, 5,55, 7) = (/ &
        & 0.36149e-06_r8,0.60082e-05_r8,0.81053e-05_r8,0.92338e-05_r8,0.58114e-05_r8 /)
      kbo(:, 1,56, 7) = (/ &
        & 0.21017e-06_r8,0.23019e-05_r8,0.28217e-05_r8,0.29420e-05_r8,0.17403e-05_r8 /)
      kbo(:, 2,56, 7) = (/ &
        & 0.23294e-06_r8,0.27215e-05_r8,0.33922e-05_r8,0.36070e-05_r8,0.21943e-05_r8 /)
      kbo(:, 3,56, 7) = (/ &
        & 0.25436e-06_r8,0.32732e-05_r8,0.41720e-05_r8,0.45291e-05_r8,0.27950e-05_r8 /)
      kbo(:, 4,56, 7) = (/ &
        & 0.27383e-06_r8,0.39951e-05_r8,0.52252e-05_r8,0.57990e-05_r8,0.36054e-05_r8 /)
      kbo(:, 5,56, 7) = (/ &
        & 0.29106e-06_r8,0.49429e-05_r8,0.66518e-05_r8,0.75613e-05_r8,0.47246e-05_r8 /)
      kbo(:, 1,57, 7) = (/ &
        & 0.16608e-06_r8,0.18531e-05_r8,0.22639e-05_r8,0.23504e-05_r8,0.13760e-05_r8 /)
      kbo(:, 2,57, 7) = (/ &
        & 0.18488e-06_r8,0.21971e-05_r8,0.27271e-05_r8,0.28870e-05_r8,0.17421e-05_r8 /)
      kbo(:, 3,57, 7) = (/ &
        & 0.20279e-06_r8,0.26520e-05_r8,0.33659e-05_r8,0.36392e-05_r8,0.22316e-05_r8 /)
      kbo(:, 4,57, 7) = (/ &
        & 0.21931e-06_r8,0.32543e-05_r8,0.42391e-05_r8,0.46891e-05_r8,0.28949e-05_r8 /)
      kbo(:, 5,57, 7) = (/ &
        & 0.23404e-06_r8,0.40527e-05_r8,0.54380e-05_r8,0.61649e-05_r8,0.38234e-05_r8 /)
      kbo(:, 1,58, 7) = (/ &
        & 0.13131e-06_r8,0.14927e-05_r8,0.18179e-05_r8,0.18787e-05_r8,0.10893e-05_r8 /)
      kbo(:, 2,58, 7) = (/ &
        & 0.14677e-06_r8,0.17748e-05_r8,0.21946e-05_r8,0.23122e-05_r8,0.13839e-05_r8 /)
      kbo(:, 3,58, 7) = (/ &
        & 0.16171e-06_r8,0.21494e-05_r8,0.27171e-05_r8,0.29256e-05_r8,0.17827e-05_r8 /)
      kbo(:, 4,58, 7) = (/ &
        & 0.17567e-06_r8,0.26514e-05_r8,0.34407e-05_r8,0.37923e-05_r8,0.23269e-05_r8 /)
      kbo(:, 5,58, 7) = (/ &
        & 0.18816e-06_r8,0.33237e-05_r8,0.44466e-05_r8,0.50280e-05_r8,0.30958e-05_r8 /)
      kbo(:, 1,59, 7) = (/ &
        & 0.10599e-06_r8,0.12374e-05_r8,0.15060e-05_r8,0.15543e-05_r8,0.89750e-06_r8 /)
      kbo(:, 2,59, 7) = (/ &
        & 0.11868e-06_r8,0.14795e-05_r8,0.18285e-05_r8,0.19251e-05_r8,0.11479e-05_r8 /)
      kbo(:, 3,59, 7) = (/ &
        & 0.13098e-06_r8,0.18042e-05_r8,0.22807e-05_r8,0.24552e-05_r8,0.14897e-05_r8 /)
      kbo(:, 4,59, 7) = (/ &
        & 0.14252e-06_r8,0.22439e-05_r8,0.29152e-05_r8,0.32163e-05_r8,0.19622e-05_r8 /)
      kbo(:, 5,59, 7) = (/ &
        & 0.15291e-06_r8,0.28396e-05_r8,0.38087e-05_r8,0.43138e-05_r8,0.26387e-05_r8 /)
      kbo(:, 1,13, 8) = (/ &
        & 0.83673e-02_r8,0.17454e-01_r8,0.20213e-01_r8,0.20132e-01_r8,0.13810e-01_r8 /)
      kbo(:, 2,13, 8) = (/ &
        & 0.85039e-02_r8,0.17824e-01_r8,0.20684e-01_r8,0.20616e-01_r8,0.14219e-01_r8 /)
      kbo(:, 3,13, 8) = (/ &
        & 0.86129e-02_r8,0.18196e-01_r8,0.21163e-01_r8,0.21143e-01_r8,0.14616e-01_r8 /)
      kbo(:, 4,13, 8) = (/ &
        & 0.86913e-02_r8,0.18563e-01_r8,0.21635e-01_r8,0.21674e-01_r8,0.14991e-01_r8 /)
      kbo(:, 5,13, 8) = (/ &
        & 0.87301e-02_r8,0.18916e-01_r8,0.22103e-01_r8,0.22198e-01_r8,0.15351e-01_r8 /)
      kbo(:, 1,14, 8) = (/ &
        & 0.69346e-02_r8,0.14952e-01_r8,0.17380e-01_r8,0.17342e-01_r8,0.11803e-01_r8 /)
      kbo(:, 2,14, 8) = (/ &
        & 0.70328e-02_r8,0.15276e-01_r8,0.17808e-01_r8,0.17830e-01_r8,0.12181e-01_r8 /)
      kbo(:, 3,14, 8) = (/ &
        & 0.71113e-02_r8,0.15604e-01_r8,0.18240e-01_r8,0.18321e-01_r8,0.12544e-01_r8 /)
      kbo(:, 4,14, 8) = (/ &
        & 0.71580e-02_r8,0.15937e-01_r8,0.18667e-01_r8,0.18814e-01_r8,0.12884e-01_r8 /)
      kbo(:, 5,14, 8) = (/ &
        & 0.71785e-02_r8,0.16228e-01_r8,0.19093e-01_r8,0.19299e-01_r8,0.13230e-01_r8 /)
      kbo(:, 1,15, 8) = (/ &
        & 0.57307e-02_r8,0.12763e-01_r8,0.14890e-01_r8,0.14912e-01_r8,0.10073e-01_r8 /)
      kbo(:, 2,15, 8) = (/ &
        & 0.58017e-02_r8,0.13052e-01_r8,0.15278e-01_r8,0.15370e-01_r8,0.10417e-01_r8 /)
      kbo(:, 3,15, 8) = (/ &
        & 0.58533e-02_r8,0.13347e-01_r8,0.15666e-01_r8,0.15828e-01_r8,0.10742e-01_r8 /)
      kbo(:, 4,15, 8) = (/ &
        & 0.58826e-02_r8,0.13628e-01_r8,0.16057e-01_r8,0.16289e-01_r8,0.11066e-01_r8 /)
      kbo(:, 5,15, 8) = (/ &
        & 0.58933e-02_r8,0.13873e-01_r8,0.16444e-01_r8,0.16739e-01_r8,0.11388e-01_r8 /)
      kbo(:, 1,16, 8) = (/ &
        & 0.47247e-02_r8,0.10863e-01_r8,0.12723e-01_r8,0.12788e-01_r8,0.85822e-02_r8 /)
      kbo(:, 2,16, 8) = (/ &
        & 0.47755e-02_r8,0.11124e-01_r8,0.13076e-01_r8,0.13211e-01_r8,0.88907e-02_r8 /)
      kbo(:, 3,16, 8) = (/ &
        & 0.48095e-02_r8,0.11385e-01_r8,0.13431e-01_r8,0.13641e-01_r8,0.91903e-02_r8 /)
      kbo(:, 4,16, 8) = (/ &
        & 0.48283e-02_r8,0.11622e-01_r8,0.13790e-01_r8,0.14066e-01_r8,0.94912e-02_r8 /)
      kbo(:, 5,16, 8) = (/ &
        & 0.48333e-02_r8,0.11841e-01_r8,0.14135e-01_r8,0.14487e-01_r8,0.97938e-02_r8 /)
      kbo(:, 1,17, 8) = (/ &
        & 0.38881e-02_r8,0.92313e-02_r8,0.10848e-01_r8,0.10942e-01_r8,0.73006e-02_r8 /)
      kbo(:, 2,17, 8) = (/ &
        & 0.39238e-02_r8,0.94601e-02_r8,0.11171e-01_r8,0.11333e-01_r8,0.75792e-02_r8 /)
      kbo(:, 3,17, 8) = (/ &
        & 0.39468e-02_r8,0.96874e-02_r8,0.11500e-01_r8,0.11732e-01_r8,0.78560e-02_r8 /)
      kbo(:, 4,17, 8) = (/ &
        & 0.39590e-02_r8,0.98962e-02_r8,0.11826e-01_r8,0.12129e-01_r8,0.81376e-02_r8 /)
      kbo(:, 5,17, 8) = (/ &
        & 0.39612e-02_r8,0.10094e-01_r8,0.12144e-01_r8,0.12521e-01_r8,0.84293e-02_r8 /)
      kbo(:, 1,18, 8) = (/ &
        & 0.31953e-02_r8,0.78309e-02_r8,0.92361e-02_r8,0.93523e-02_r8,0.62048e-02_r8 /)
      kbo(:, 2,18, 8) = (/ &
        & 0.32208e-02_r8,0.80372e-02_r8,0.95350e-02_r8,0.97148e-02_r8,0.64590e-02_r8 /)
      kbo(:, 3,18, 8) = (/ &
        & 0.32365e-02_r8,0.82342e-02_r8,0.98382e-02_r8,0.10082e-01_r8,0.67154e-02_r8 /)
      kbo(:, 4,18, 8) = (/ &
        & 0.32447e-02_r8,0.84229e-02_r8,0.10138e-01_r8,0.10450e-01_r8,0.69838e-02_r8 /)
      kbo(:, 5,18, 8) = (/ &
        & 0.32450e-02_r8,0.86061e-02_r8,0.10427e-01_r8,0.10814e-01_r8,0.72626e-02_r8 /)
      kbo(:, 1,19, 8) = (/ &
        & 0.26235e-02_r8,0.66399e-02_r8,0.78599e-02_r8,0.79875e-02_r8,0.52728e-02_r8 /)
      kbo(:, 2,19, 8) = (/ &
        & 0.26414e-02_r8,0.68231e-02_r8,0.81351e-02_r8,0.83230e-02_r8,0.55070e-02_r8 /)
      kbo(:, 3,19, 8) = (/ &
        & 0.26530e-02_r8,0.70004e-02_r8,0.84138e-02_r8,0.86629e-02_r8,0.57468e-02_r8 /)
      kbo(:, 4,19, 8) = (/ &
        & 0.26583e-02_r8,0.71756e-02_r8,0.86887e-02_r8,0.90029e-02_r8,0.60006e-02_r8 /)
      kbo(:, 5,19, 8) = (/ &
        & 0.26573e-02_r8,0.73457e-02_r8,0.89549e-02_r8,0.93422e-02_r8,0.62658e-02_r8 /)
      kbo(:, 1,20, 8) = (/ &
        & 0.21528e-02_r8,0.56300e-02_r8,0.66928e-02_r8,0.68275e-02_r8,0.44887e-02_r8 /)
      kbo(:, 2,20, 8) = (/ &
        & 0.21659e-02_r8,0.57965e-02_r8,0.69483e-02_r8,0.71374e-02_r8,0.47044e-02_r8 /)
      kbo(:, 3,20, 8) = (/ &
        & 0.21742e-02_r8,0.59617e-02_r8,0.72036e-02_r8,0.74503e-02_r8,0.49314e-02_r8 /)
      kbo(:, 4,20, 8) = (/ &
        & 0.21777e-02_r8,0.61251e-02_r8,0.74562e-02_r8,0.77657e-02_r8,0.51700e-02_r8 /)
      kbo(:, 5,20, 8) = (/ &
        & 0.21757e-02_r8,0.62850e-02_r8,0.77065e-02_r8,0.80891e-02_r8,0.54225e-02_r8 /)
      kbo(:, 1,21, 8) = (/ &
        & 0.17659e-02_r8,0.47778e-02_r8,0.57054e-02_r8,0.58417e-02_r8,0.38271e-02_r8 /)
      kbo(:, 2,21, 8) = (/ &
        & 0.17754e-02_r8,0.49299e-02_r8,0.59393e-02_r8,0.61257e-02_r8,0.40264e-02_r8 /)
      kbo(:, 3,21, 8) = (/ &
        & 0.17817e-02_r8,0.50836e-02_r8,0.61750e-02_r8,0.64148e-02_r8,0.42397e-02_r8 /)
      kbo(:, 4,21, 8) = (/ &
        & 0.17836e-02_r8,0.52370e-02_r8,0.64083e-02_r8,0.67125e-02_r8,0.44647e-02_r8 /)
      kbo(:, 5,21, 8) = (/ &
        & 0.17811e-02_r8,0.53876e-02_r8,0.66480e-02_r8,0.70201e-02_r8,0.47076e-02_r8 /)
      kbo(:, 1,22, 8) = (/ &
        & 0.14486e-02_r8,0.40679e-02_r8,0.48826e-02_r8,0.50205e-02_r8,0.32805e-02_r8 /)
      kbo(:, 2,22, 8) = (/ &
        & 0.14554e-02_r8,0.42085e-02_r8,0.50980e-02_r8,0.52827e-02_r8,0.34669e-02_r8 /)
      kbo(:, 3,22, 8) = (/ &
        & 0.14597e-02_r8,0.43515e-02_r8,0.53153e-02_r8,0.55535e-02_r8,0.36674e-02_r8 /)
      kbo(:, 4,22, 8) = (/ &
        & 0.14606e-02_r8,0.44957e-02_r8,0.55353e-02_r8,0.58376e-02_r8,0.38816e-02_r8 /)
      kbo(:, 5,22, 8) = (/ &
        & 0.14577e-02_r8,0.46383e-02_r8,0.57672e-02_r8,0.61302e-02_r8,0.41156e-02_r8 /)
      kbo(:, 1,23, 8) = (/ &
        & 0.11880e-02_r8,0.34698e-02_r8,0.41861e-02_r8,0.43248e-02_r8,0.28199e-02_r8 /)
      kbo(:, 2,23, 8) = (/ &
        & 0.11929e-02_r8,0.36010e-02_r8,0.43862e-02_r8,0.45689e-02_r8,0.29956e-02_r8 /)
      kbo(:, 3,23, 8) = (/ &
        & 0.11958e-02_r8,0.37344e-02_r8,0.45877e-02_r8,0.48273e-02_r8,0.31843e-02_r8 /)
      kbo(:, 4,23, 8) = (/ &
        & 0.11959e-02_r8,0.38697e-02_r8,0.48007e-02_r8,0.50965e-02_r8,0.33903e-02_r8 /)
      kbo(:, 5,23, 8) = (/ &
        & 0.11929e-02_r8,0.40068e-02_r8,0.50232e-02_r8,0.53791e-02_r8,0.36136e-02_r8 /)
      kbo(:, 1,24, 8) = (/ &
        & 0.97406e-03_r8,0.29675e-02_r8,0.36006e-02_r8,0.37379e-02_r8,0.24344e-02_r8 /)
      kbo(:, 2,24, 8) = (/ &
        & 0.97756e-03_r8,0.30896e-02_r8,0.37850e-02_r8,0.39686e-02_r8,0.25994e-02_r8 /)
      kbo(:, 3,24, 8) = (/ &
        & 0.97946e-03_r8,0.32150e-02_r8,0.39775e-02_r8,0.42135e-02_r8,0.27776e-02_r8 /)
      kbo(:, 4,24, 8) = (/ &
        & 0.97899e-03_r8,0.33430e-02_r8,0.41825e-02_r8,0.44708e-02_r8,0.29753e-02_r8 /)
      kbo(:, 5,24, 8) = (/ &
        & 0.97615e-03_r8,0.34761e-02_r8,0.43966e-02_r8,0.47457e-02_r8,0.31900e-02_r8 /)
      kbo(:, 1,25, 8) = (/ &
        & 0.79856e-03_r8,0.25459e-02_r8,0.31077e-02_r8,0.32447e-02_r8,0.21114e-02_r8 /)
      kbo(:, 2,25, 8) = (/ &
        & 0.80110e-03_r8,0.26605e-02_r8,0.32805e-02_r8,0.34640e-02_r8,0.22664e-02_r8 /)
      kbo(:, 3,25, 8) = (/ &
        & 0.80222e-03_r8,0.27778e-02_r8,0.34666e-02_r8,0.36958e-02_r8,0.24376e-02_r8 /)
      kbo(:, 4,25, 8) = (/ &
        & 0.80129e-03_r8,0.29014e-02_r8,0.36623e-02_r8,0.39444e-02_r8,0.26269e-02_r8 /)
      kbo(:, 5,25, 8) = (/ &
        & 0.79857e-03_r8,0.30302e-02_r8,0.38698e-02_r8,0.42126e-02_r8,0.28335e-02_r8 /)
      kbo(:, 1,26, 8) = (/ &
        & 0.65460e-03_r8,0.21933e-02_r8,0.26944e-02_r8,0.28334e-02_r8,0.18417e-02_r8 /)
      kbo(:, 2,26, 8) = (/ &
        & 0.65639e-03_r8,0.23003e-02_r8,0.28599e-02_r8,0.30409e-02_r8,0.19886e-02_r8 /)
      kbo(:, 3,26, 8) = (/ &
        & 0.65685e-03_r8,0.24132e-02_r8,0.30384e-02_r8,0.32639e-02_r8,0.21545e-02_r8 /)
      kbo(:, 4,26, 8) = (/ &
        & 0.65577e-03_r8,0.25323e-02_r8,0.32275e-02_r8,0.35055e-02_r8,0.23366e-02_r8 /)
      kbo(:, 5,26, 8) = (/ &
        & 0.65325e-03_r8,0.26572e-02_r8,0.34294e-02_r8,0.37687e-02_r8,0.25365e-02_r8 /)
      kbo(:, 1,27, 8) = (/ &
        & 0.53655e-03_r8,0.18966e-02_r8,0.23474e-02_r8,0.24873e-02_r8,0.16142e-02_r8 /)
      kbo(:, 2,27, 8) = (/ &
        & 0.53777e-03_r8,0.19979e-02_r8,0.25069e-02_r8,0.26849e-02_r8,0.17570e-02_r8 /)
      kbo(:, 3,27, 8) = (/ &
        & 0.53783e-03_r8,0.21070e-02_r8,0.26778e-02_r8,0.29010e-02_r8,0.19163e-02_r8 /)
      kbo(:, 4,27, 8) = (/ &
        & 0.53661e-03_r8,0.22218e-02_r8,0.28609e-02_r8,0.31373e-02_r8,0.20925e-02_r8 /)
      kbo(:, 5,27, 8) = (/ &
        & 0.53426e-03_r8,0.23437e-02_r8,0.30591e-02_r8,0.33953e-02_r8,0.22871e-02_r8 /)
      kbo(:, 1,28, 8) = (/ &
        & 0.43973e-03_r8,0.16467e-02_r8,0.20564e-02_r8,0.21950e-02_r8,0.14243e-02_r8 /)
      kbo(:, 2,28, 8) = (/ &
        & 0.44046e-03_r8,0.17445e-02_r8,0.22094e-02_r8,0.23854e-02_r8,0.15622e-02_r8 /)
      kbo(:, 3,28, 8) = (/ &
        & 0.44027e-03_r8,0.18495e-02_r8,0.23737e-02_r8,0.25954e-02_r8,0.17160e-02_r8 /)
      kbo(:, 4,28, 8) = (/ &
        & 0.43902e-03_r8,0.19607e-02_r8,0.25527e-02_r8,0.28280e-02_r8,0.18875e-02_r8 /)
      kbo(:, 5,28, 8) = (/ &
        & 0.43690e-03_r8,0.20797e-02_r8,0.27483e-02_r8,0.30809e-02_r8,0.20783e-02_r8 /)
      kbo(:, 1,29, 8) = (/ &
        & 0.36035e-03_r8,0.14377e-02_r8,0.18129e-02_r8,0.19502e-02_r8,0.12665e-02_r8 /)
      kbo(:, 2,29, 8) = (/ &
        & 0.36078e-03_r8,0.15322e-02_r8,0.19593e-02_r8,0.21346e-02_r8,0.13993e-02_r8 /)
      kbo(:, 3,29, 8) = (/ &
        & 0.36035e-03_r8,0.16333e-02_r8,0.21194e-02_r8,0.23407e-02_r8,0.15489e-02_r8 /)
      kbo(:, 4,29, 8) = (/ &
        & 0.35917e-03_r8,0.17416e-02_r8,0.22958e-02_r8,0.25693e-02_r8,0.17169e-02_r8 /)
      kbo(:, 5,29, 8) = (/ &
        & 0.35722e-03_r8,0.18583e-02_r8,0.24893e-02_r8,0.28199e-02_r8,0.19058e-02_r8 /)
      kbo(:, 1,30, 8) = (/ &
        & 0.29522e-03_r8,0.12625e-02_r8,0.16073e-02_r8,0.17444e-02_r8,0.11337e-02_r8 /)
      kbo(:, 2,30, 8) = (/ &
        & 0.29544e-03_r8,0.13534e-02_r8,0.17493e-02_r8,0.19248e-02_r8,0.12629e-02_r8 /)
      kbo(:, 3,30, 8) = (/ &
        & 0.29489e-03_r8,0.14513e-02_r8,0.19064e-02_r8,0.21281e-02_r8,0.14093e-02_r8 /)
      kbo(:, 4,30, 8) = (/ &
        & 0.29377e-03_r8,0.15575e-02_r8,0.20813e-02_r8,0.23536e-02_r8,0.15751e-02_r8 /)
      kbo(:, 5,30, 8) = (/ &
        & 0.29201e-03_r8,0.16725e-02_r8,0.22728e-02_r8,0.26031e-02_r8,0.17633e-02_r8 /)
      kbo(:, 1,31, 8) = (/ &
        & 0.24186e-03_r8,0.11155e-02_r8,0.14353e-02_r8,0.15729e-02_r8,0.10232e-02_r8 /)
      kbo(:, 2,31, 8) = (/ &
        & 0.24189e-03_r8,0.12032e-02_r8,0.15739e-02_r8,0.17508e-02_r8,0.11498e-02_r8 /)
      kbo(:, 3,31, 8) = (/ &
        & 0.24130e-03_r8,0.12988e-02_r8,0.17296e-02_r8,0.19516e-02_r8,0.12942e-02_r8 /)
      kbo(:, 4,31, 8) = (/ &
        & 0.24025e-03_r8,0.14034e-02_r8,0.19030e-02_r8,0.21764e-02_r8,0.14594e-02_r8 /)
      kbo(:, 5,31, 8) = (/ &
        & 0.23866e-03_r8,0.15170e-02_r8,0.20940e-02_r8,0.24270e-02_r8,0.16471e-02_r8 /)
      kbo(:, 1,32, 8) = (/ &
        & 0.19811e-03_r8,0.99188e-03_r8,0.12914e-02_r8,0.14311e-02_r8,0.93157e-03_r8 /)
      kbo(:, 2,32, 8) = (/ &
        & 0.19799e-03_r8,0.10771e-02_r8,0.14282e-02_r8,0.16073e-02_r8,0.10562e-02_r8 /)
      kbo(:, 3,32, 8) = (/ &
        & 0.19741e-03_r8,0.11711e-02_r8,0.15828e-02_r8,0.18068e-02_r8,0.11999e-02_r8 /)
      kbo(:, 4,32, 8) = (/ &
        & 0.19645e-03_r8,0.12746e-02_r8,0.17559e-02_r8,0.20320e-02_r8,0.13654e-02_r8 /)
      kbo(:, 5,32, 8) = (/ &
        & 0.19503e-03_r8,0.13871e-02_r8,0.19473e-02_r8,0.22851e-02_r8,0.15533e-02_r8 /)
      kbo(:, 1,33, 8) = (/ &
        & 0.16225e-03_r8,0.88803e-03_r8,0.11717e-02_r8,0.13138e-02_r8,0.85556e-03_r8 /)
      kbo(:, 2,33, 8) = (/ &
        & 0.16205e-03_r8,0.97174e-03_r8,0.13077e-02_r8,0.14890e-02_r8,0.97930e-03_r8 /)
      kbo(:, 3,33, 8) = (/ &
        & 0.16148e-03_r8,0.10648e-02_r8,0.14621e-02_r8,0.16891e-02_r8,0.11237e-02_r8 /)
      kbo(:, 4,33, 8) = (/ &
        & 0.16059e-03_r8,0.11673e-02_r8,0.16357e-02_r8,0.19165e-02_r8,0.12896e-02_r8 /)
      kbo(:, 5,33, 8) = (/ &
        & 0.15934e-03_r8,0.12795e-02_r8,0.18288e-02_r8,0.21736e-02_r8,0.14791e-02_r8 /)
      kbo(:, 1,34, 8) = (/ &
        & 0.13286e-03_r8,0.79835e-03_r8,0.10683e-02_r8,0.12117e-02_r8,0.78908e-03_r8 /)
      kbo(:, 2,34, 8) = (/ &
        & 0.13261e-03_r8,0.88066e-03_r8,0.12036e-02_r8,0.13865e-02_r8,0.91252e-03_r8 /)
      kbo(:, 3,34, 8) = (/ &
        & 0.13209e-03_r8,0.97270e-03_r8,0.13580e-02_r8,0.15871e-02_r8,0.10570e-02_r8 /)
      kbo(:, 4,34, 8) = (/ &
        & 0.13130e-03_r8,0.10748e-02_r8,0.15318e-02_r8,0.18171e-02_r8,0.12236e-02_r8 /)
      kbo(:, 5,34, 8) = (/ &
        & 0.13022e-03_r8,0.11866e-02_r8,0.17264e-02_r8,0.20786e-02_r8,0.14148e-02_r8 /)
      kbo(:, 1,35, 8) = (/ &
        & 0.10879e-03_r8,0.71567e-03_r8,0.97075e-03_r8,0.11118e-02_r8,0.72353e-03_r8 /)
      kbo(:, 2,35, 8) = (/ &
        & 0.10855e-03_r8,0.79625e-03_r8,0.11041e-02_r8,0.12845e-02_r8,0.84540e-03_r8 /)
      kbo(:, 3,35, 8) = (/ &
        & 0.10811e-03_r8,0.88686e-03_r8,0.12569e-02_r8,0.14847e-02_r8,0.98831e-03_r8 /)
      kbo(:, 4,35, 8) = (/ &
        & 0.10743e-03_r8,0.98761e-03_r8,0.14300e-02_r8,0.17157e-02_r8,0.11541e-02_r8 /)
      kbo(:, 5,35, 8) = (/ &
        & 0.10650e-03_r8,0.10987e-02_r8,0.16251e-02_r8,0.19799e-02_r8,0.13460e-02_r8 /)
      kbo(:, 1,36, 8) = (/ &
        & 0.89091e-04_r8,0.63773e-03_r8,0.87525e-03_r8,0.10106e-02_r8,0.65643e-03_r8 /)
      kbo(:, 2,36, 8) = (/ &
        & 0.88892e-04_r8,0.71572e-03_r8,0.10050e-02_r8,0.11794e-02_r8,0.77482e-03_r8 /)
      kbo(:, 3,36, 8) = (/ &
        & 0.88510e-04_r8,0.80390e-03_r8,0.11544e-02_r8,0.13768e-02_r8,0.91437e-03_r8 /)
      kbo(:, 4,36, 8) = (/ &
        & 0.87951e-04_r8,0.90253e-03_r8,0.13255e-02_r8,0.16063e-02_r8,0.10779e-02_r8 /)
      kbo(:, 5,36, 8) = (/ &
        & 0.87175e-04_r8,0.10120e-02_r8,0.15187e-02_r8,0.18703e-02_r8,0.12677e-02_r8 /)
      kbo(:, 1,37, 8) = (/ &
        & 0.72967e-04_r8,0.56051e-03_r8,0.77586e-03_r8,0.90139e-03_r8,0.58319e-03_r8 /)
      kbo(:, 2,37, 8) = (/ &
        & 0.72818e-04_r8,0.63459e-03_r8,0.89962e-03_r8,0.10627e-02_r8,0.69545e-03_r8 /)
      kbo(:, 3,37, 8) = (/ &
        & 0.72523e-04_r8,0.71909e-03_r8,0.10433e-02_r8,0.12533e-02_r8,0.82896e-03_r8 /)
      kbo(:, 4,37, 8) = (/ &
        & 0.72087e-04_r8,0.81427e-03_r8,0.12092e-02_r8,0.14766e-02_r8,0.98671e-03_r8 /)
      kbo(:, 5,37, 8) = (/ &
        & 0.71486e-04_r8,0.92093e-03_r8,0.13977e-02_r8,0.17355e-02_r8,0.11708e-02_r8 /)
      kbo(:, 1,38, 8) = (/ &
        & 0.59765e-04_r8,0.49320e-03_r8,0.68844e-03_r8,0.80478e-03_r8,0.51849e-03_r8 /)
      kbo(:, 2,38, 8) = (/ &
        & 0.59660e-04_r8,0.56354e-03_r8,0.80640e-03_r8,0.95876e-03_r8,0.62466e-03_r8 /)
      kbo(:, 3,38, 8) = (/ &
        & 0.59436e-04_r8,0.64440e-03_r8,0.94454e-03_r8,0.11426e-02_r8,0.75236e-03_r8 /)
      kbo(:, 4,38, 8) = (/ &
        & 0.59102e-04_r8,0.73631e-03_r8,0.11052e-02_r8,0.13599e-02_r8,0.90433e-03_r8 /)
      kbo(:, 5,38, 8) = (/ &
        & 0.58635e-04_r8,0.84009e-03_r8,0.12891e-02_r8,0.16134e-02_r8,0.10829e-02_r8 /)
      kbo(:, 1,39, 8) = (/ &
        & 0.48956e-04_r8,0.43499e-03_r8,0.61231e-03_r8,0.72017e-03_r8,0.46189e-03_r8 /)
      kbo(:, 2,39, 8) = (/ &
        & 0.48890e-04_r8,0.50181e-03_r8,0.72478e-03_r8,0.86730e-03_r8,0.56244e-03_r8 /)
      kbo(:, 3,39, 8) = (/ &
        & 0.48717e-04_r8,0.57923e-03_r8,0.85778e-03_r8,0.10448e-02_r8,0.68464e-03_r8 /)
      kbo(:, 4,39, 8) = (/ &
        & 0.48451e-04_r8,0.66799e-03_r8,0.10132e-02_r8,0.12563e-02_r8,0.83112e-03_r8 /)
      kbo(:, 5,39, 8) = (/ &
        & 0.48085e-04_r8,0.76898e-03_r8,0.11928e-02_r8,0.15047e-02_r8,0.10044e-02_r8 /)
      kbo(:, 1,40, 8) = (/ &
        & 0.40107e-04_r8,0.37860e-03_r8,0.53596e-03_r8,0.63302e-03_r8,0.40350e-03_r8 /)
      kbo(:, 2,40, 8) = (/ &
        & 0.40068e-04_r8,0.44099e-03_r8,0.64126e-03_r8,0.77105e-03_r8,0.49697e-03_r8 /)
      kbo(:, 3,40, 8) = (/ &
        & 0.39945e-04_r8,0.51399e-03_r8,0.76694e-03_r8,0.93934e-03_r8,0.61166e-03_r8 /)
      kbo(:, 4,40, 8) = (/ &
        & 0.39752e-04_r8,0.59851e-03_r8,0.91528e-03_r8,0.11416e-02_r8,0.75037e-03_r8 /)
      kbo(:, 5,40, 8) = (/ &
        & 0.39469e-04_r8,0.69544e-03_r8,0.10880e-02_r8,0.13809e-02_r8,0.91593e-03_r8 /)
      kbo(:, 1,41, 8) = (/ &
        & 0.32851e-04_r8,0.32878e-03_r8,0.46786e-03_r8,0.55469e-03_r8,0.35120e-03_r8 /)
      kbo(:, 2,41, 8) = (/ &
        & 0.32839e-04_r8,0.38683e-03_r8,0.56607e-03_r8,0.68394e-03_r8,0.43769e-03_r8 /)
      kbo(:, 3,41, 8) = (/ &
        & 0.32749e-04_r8,0.45542e-03_r8,0.68444e-03_r8,0.84259e-03_r8,0.54490e-03_r8 /)
      kbo(:, 4,41, 8) = (/ &
        & 0.32607e-04_r8,0.53564e-03_r8,0.82547e-03_r8,0.10352e-02_r8,0.67585e-03_r8 /)
      kbo(:, 5,41, 8) = (/ &
        & 0.32395e-04_r8,0.62841e-03_r8,0.99133e-03_r8,0.12652e-02_r8,0.83332e-03_r8 /)
      kbo(:, 1,42, 8) = (/ &
        & 0.26906e-04_r8,0.28534e-03_r8,0.40805e-03_r8,0.48535e-03_r8,0.30526e-03_r8 /)
      kbo(:, 2,42, 8) = (/ &
        & 0.26908e-04_r8,0.33922e-03_r8,0.49950e-03_r8,0.60603e-03_r8,0.38505e-03_r8 /)
      kbo(:, 3,42, 8) = (/ &
        & 0.26846e-04_r8,0.40361e-03_r8,0.61076e-03_r8,0.75564e-03_r8,0.48524e-03_r8 /)
      kbo(:, 4,42, 8) = (/ &
        & 0.26739e-04_r8,0.47953e-03_r8,0.74454e-03_r8,0.93882e-03_r8,0.60861e-03_r8 /)
      kbo(:, 5,42, 8) = (/ &
        & 0.26585e-04_r8,0.56816e-03_r8,0.90363e-03_r8,0.11597e-02_r8,0.75829e-03_r8 /)
      kbo(:, 1,43, 8) = (/ &
        & 0.22034e-04_r8,0.24494e-03_r8,0.35126e-03_r8,0.41862e-03_r8,0.26133e-03_r8 /)
      kbo(:, 2,43, 8) = (/ &
        & 0.22045e-04_r8,0.29428e-03_r8,0.43526e-03_r8,0.52960e-03_r8,0.33379e-03_r8 /)
      kbo(:, 3,43, 8) = (/ &
        & 0.22009e-04_r8,0.35394e-03_r8,0.53838e-03_r8,0.66893e-03_r8,0.42599e-03_r8 /)
      kbo(:, 4,43, 8) = (/ &
        & 0.21933e-04_r8,0.42510e-03_r8,0.66392e-03_r8,0.84090e-03_r8,0.54061e-03_r8 /)
      kbo(:, 5,43, 8) = (/ &
        & 0.21820e-04_r8,0.50878e-03_r8,0.81474e-03_r8,0.10503e-02_r8,0.68139e-03_r8 /)
      kbo(:, 1,44, 8) = (/ &
        & 0.18042e-04_r8,0.20878e-03_r8,0.29988e-03_r8,0.35782e-03_r8,0.22160e-03_r8 /)
      kbo(:, 2,44, 8) = (/ &
        & 0.18058e-04_r8,0.25360e-03_r8,0.37621e-03_r8,0.45875e-03_r8,0.28670e-03_r8 /)
      kbo(:, 3,44, 8) = (/ &
        & 0.18041e-04_r8,0.30845e-03_r8,0.47123e-03_r8,0.58727e-03_r8,0.37070e-03_r8 /)
      kbo(:, 4,44, 8) = (/ &
        & 0.17989e-04_r8,0.37459e-03_r8,0.58804e-03_r8,0.74739e-03_r8,0.47650e-03_r8 /)
      kbo(:, 5,44, 8) = (/ &
        & 0.17906e-04_r8,0.45317e-03_r8,0.73003e-03_r8,0.94454e-03_r8,0.60768e-03_r8 /)
      kbo(:, 1,45, 8) = (/ &
        & 0.14770e-04_r8,0.17743e-03_r8,0.25518e-03_r8,0.30461e-03_r8,0.18718e-03_r8 /)
      kbo(:, 2,45, 8) = (/ &
        & 0.14790e-04_r8,0.21794e-03_r8,0.32424e-03_r8,0.39603e-03_r8,0.24534e-03_r8 /)
      kbo(:, 3,45, 8) = (/ &
        & 0.14785e-04_r8,0.26822e-03_r8,0.41132e-03_r8,0.51406e-03_r8,0.32158e-03_r8 /)
      kbo(:, 4,45, 8) = (/ &
        & 0.14751e-04_r8,0.32948e-03_r8,0.51968e-03_r8,0.66288e-03_r8,0.41889e-03_r8 /)
      kbo(:, 5,45, 8) = (/ &
        & 0.14692e-04_r8,0.40309e-03_r8,0.65298e-03_r8,0.84795e-03_r8,0.54078e-03_r8 /)
      kbo(:, 1,46, 8) = (/ &
        & 0.12091e-04_r8,0.14956e-03_r8,0.21507e-03_r8,0.25664e-03_r8,0.15641e-03_r8 /)
      kbo(:, 2,46, 8) = (/ &
        & 0.12112e-04_r8,0.18585e-03_r8,0.27689e-03_r8,0.33853e-03_r8,0.20778e-03_r8 /)
      kbo(:, 3,46, 8) = (/ &
        & 0.12113e-04_r8,0.23156e-03_r8,0.35597e-03_r8,0.44575e-03_r8,0.27619e-03_r8 /)
      kbo(:, 4,46, 8) = (/ &
        & 0.12094e-04_r8,0.28789e-03_r8,0.45576e-03_r8,0.58313e-03_r8,0.36492e-03_r8 /)
      kbo(:, 5,46, 8) = (/ &
        & 0.12054e-04_r8,0.35628e-03_r8,0.57980e-03_r8,0.75523e-03_r8,0.47721e-03_r8 /)
      kbo(:, 1,47, 8) = (/ &
        & 0.98958e-05_r8,0.12436e-03_r8,0.17838e-03_r8,0.21241e-03_r8,0.12841e-03_r8 /)
      kbo(:, 2,47, 8) = (/ &
        & 0.99157e-05_r8,0.15633e-03_r8,0.23279e-03_r8,0.28443e-03_r8,0.17291e-03_r8 /)
      kbo(:, 3,47, 8) = (/ &
        & 0.99224e-05_r8,0.19724e-03_r8,0.30350e-03_r8,0.38017e-03_r8,0.23323e-03_r8 /)
      kbo(:, 4,47, 8) = (/ &
        & 0.99150e-05_r8,0.24831e-03_r8,0.39396e-03_r8,0.50488e-03_r8,0.31274e-03_r8 /)
      kbo(:, 5,47, 8) = (/ &
        & 0.98881e-05_r8,0.31110e-03_r8,0.50788e-03_r8,0.66304e-03_r8,0.41485e-03_r8 /)
      kbo(:, 1,48, 8) = (/ &
        & 0.80981e-05_r8,0.10284e-03_r8,0.14701e-03_r8,0.17457e-03_r8,0.10464e-03_r8 /)
      kbo(:, 2,48, 8) = (/ &
        & 0.81170e-05_r8,0.13083e-03_r8,0.19452e-03_r8,0.23734e-03_r8,0.14298e-03_r8 /)
      kbo(:, 3,48, 8) = (/ &
        & 0.81254e-05_r8,0.16716e-03_r8,0.25727e-03_r8,0.32230e-03_r8,0.19565e-03_r8 /)
      kbo(:, 4,48, 8) = (/ &
        & 0.81253e-05_r8,0.21328e-03_r8,0.33887e-03_r8,0.43475e-03_r8,0.26652e-03_r8 /)
      kbo(:, 5,48, 8) = (/ &
        & 0.81092e-05_r8,0.27062e-03_r8,0.44301e-03_r8,0.57972e-03_r8,0.35887e-03_r8 /)
      kbo(:, 1,49, 8) = (/ &
        & 0.66262e-05_r8,0.84542e-04_r8,0.12034e-03_r8,0.14245e-03_r8,0.84636e-04_r8 /)
      kbo(:, 2,49, 8) = (/ &
        & 0.66435e-05_r8,0.10903e-03_r8,0.16168e-03_r8,0.19686e-03_r8,0.11740e-03_r8 /)
      kbo(:, 3,49, 8) = (/ &
        & 0.66527e-05_r8,0.14092e-03_r8,0.21685e-03_r8,0.27156e-03_r8,0.16309e-03_r8 /)
      kbo(:, 4,49, 8) = (/ &
        & 0.66567e-05_r8,0.18229e-03_r8,0.28989e-03_r8,0.37214e-03_r8,0.22572e-03_r8 /)
      kbo(:, 5,49, 8) = (/ &
        & 0.66489e-05_r8,0.23443e-03_r8,0.38461e-03_r8,0.50418e-03_r8,0.30883e-03_r8 /)
      kbo(:, 1,50, 8) = (/ &
        & 0.54202e-05_r8,0.69608e-04_r8,0.98680e-04_r8,0.11646e-03_r8,0.68510e-04_r8 /)
      kbo(:, 2,50, 8) = (/ &
        & 0.54374e-05_r8,0.90802e-04_r8,0.13434e-03_r8,0.16330e-03_r8,0.96499e-04_r8 /)
      kbo(:, 3,50, 8) = (/ &
        & 0.54475e-05_r8,0.11916e-03_r8,0.18327e-03_r8,0.22932e-03_r8,0.13620e-03_r8 /)
      kbo(:, 4,50, 8) = (/ &
        & 0.54521e-05_r8,0.15608e-03_r8,0.24845e-03_r8,0.31928e-03_r8,0.19154e-03_r8 /)
      kbo(:, 5,50, 8) = (/ &
        & 0.54498e-05_r8,0.20348e-03_r8,0.33466e-03_r8,0.43937e-03_r8,0.26626e-03_r8 /)
      kbo(:, 1,51, 8) = (/ &
        & 0.44351e-05_r8,0.57088e-04_r8,0.80582e-04_r8,0.94790e-04_r8,0.55250e-04_r8 /)
      kbo(:, 2,51, 8) = (/ &
        & 0.44504e-05_r8,0.75435e-04_r8,0.11131e-03_r8,0.13503e-03_r8,0.79024e-04_r8 /)
      kbo(:, 3,51, 8) = (/ &
        & 0.44599e-05_r8,0.10037e-03_r8,0.15428e-03_r8,0.19291e-03_r8,0.11343e-03_r8 /)
      kbo(:, 4,51, 8) = (/ &
        & 0.44651e-05_r8,0.13336e-03_r8,0.21252e-03_r8,0.27335e-03_r8,0.16218e-03_r8 /)
      kbo(:, 5,51, 8) = (/ &
        & 0.44653e-05_r8,0.17640e-03_r8,0.29075e-03_r8,0.38229e-03_r8,0.22923e-03_r8 /)
      kbo(:, 1,52, 8) = (/ &
        & 0.36290e-05_r8,0.46565e-04_r8,0.65364e-04_r8,0.76598e-04_r8,0.44240e-04_r8 /)
      kbo(:, 2,52, 8) = (/ &
        & 0.36420e-05_r8,0.62314e-04_r8,0.91644e-04_r8,0.11090e-03_r8,0.64234e-04_r8 /)
      kbo(:, 3,52, 8) = (/ &
        & 0.36509e-05_r8,0.84102e-04_r8,0.12910e-03_r8,0.16125e-03_r8,0.93833e-04_r8 /)
      kbo(:, 4,52, 8) = (/ &
        & 0.36555e-05_r8,0.11362e-03_r8,0.18115e-03_r8,0.23297e-03_r8,0.13657e-03_r8 /)
      kbo(:, 5,52, 8) = (/ &
        & 0.36579e-05_r8,0.15226e-03_r8,0.25136e-03_r8,0.33099e-03_r8,0.19621e-03_r8 /)
      kbo(:, 1,53, 8) = (/ &
        & 0.29692e-05_r8,0.37746e-04_r8,0.52632e-04_r8,0.61397e-04_r8,0.35165e-04_r8 /)
      kbo(:, 2,53, 8) = (/ &
        & 0.29808e-05_r8,0.51149e-04_r8,0.74879e-04_r8,0.90335e-04_r8,0.51807e-04_r8 /)
      kbo(:, 3,53, 8) = (/ &
        & 0.29880e-05_r8,0.70028e-04_r8,0.10724e-03_r8,0.13375e-03_r8,0.77010e-04_r8 /)
      kbo(:, 4,53, 8) = (/ &
        & 0.29931e-05_r8,0.96105e-04_r8,0.15314e-03_r8,0.19689e-03_r8,0.11417e-03_r8 /)
      kbo(:, 5,53, 8) = (/ &
        & 0.29959e-05_r8,0.13074e-03_r8,0.21612e-03_r8,0.28492e-03_r8,0.16697e-03_r8 /)
      kbo(:, 1,54, 8) = (/ &
        & 0.24296e-05_r8,0.30698e-04_r8,0.42544e-04_r8,0.49406e-04_r8,0.28072e-04_r8 /)
      kbo(:, 2,54, 8) = (/ &
        & 0.24393e-05_r8,0.42122e-04_r8,0.61454e-04_r8,0.73927e-04_r8,0.41964e-04_r8 /)
      kbo(:, 3,54, 8) = (/ &
        & 0.24460e-05_r8,0.58528e-04_r8,0.89500e-04_r8,0.11146e-03_r8,0.63503e-04_r8 /)
      kbo(:, 4,54, 8) = (/ &
        & 0.24507e-05_r8,0.81611e-04_r8,0.13009e-03_r8,0.16728e-03_r8,0.95947e-04_r8 /)
      kbo(:, 5,54, 8) = (/ &
        & 0.24535e-05_r8,0.11276e-03_r8,0.18682e-03_r8,0.24654e-03_r8,0.14286e-03_r8 /)
      kbo(:, 1,55, 8) = (/ &
        & 0.19883e-05_r8,0.24921e-04_r8,0.34312e-04_r8,0.39666e-04_r8,0.22375e-04_r8 /)
      kbo(:, 2,55, 8) = (/ &
        & 0.19963e-05_r8,0.34641e-04_r8,0.50344e-04_r8,0.60381e-04_r8,0.33942e-04_r8 /)
      kbo(:, 3,55, 8) = (/ &
        & 0.20020e-05_r8,0.48868e-04_r8,0.74618e-04_r8,0.92809e-04_r8,0.52280e-04_r8 /)
      kbo(:, 4,55, 8) = (/ &
        & 0.20065e-05_r8,0.69255e-04_r8,0.11042e-03_r8,0.14203e-03_r8,0.80566e-04_r8 /)
      kbo(:, 5,55, 8) = (/ &
        & 0.20089e-05_r8,0.97527e-04_r8,0.16182e-03_r8,0.21373e-03_r8,0.12228e-03_r8 /)
      kbo(:, 1,56, 8) = (/ &
        & 0.16268e-05_r8,0.20122e-04_r8,0.27506e-04_r8,0.31629e-04_r8,0.17718e-04_r8 /)
      kbo(:, 2,56, 8) = (/ &
        & 0.16337e-05_r8,0.28321e-04_r8,0.40966e-04_r8,0.48960e-04_r8,0.27271e-04_r8 /)
      kbo(:, 3,56, 8) = (/ &
        & 0.16385e-05_r8,0.40579e-04_r8,0.61828e-04_r8,0.76747e-04_r8,0.42739e-04_r8 /)
      kbo(:, 4,56, 8) = (/ &
        & 0.16424e-05_r8,0.58490e-04_r8,0.93220e-04_r8,0.11991e-03_r8,0.67232e-04_r8 /)
      kbo(:, 5,56, 8) = (/ &
        & 0.16450e-05_r8,0.83776e-04_r8,0.13917e-03_r8,0.18401e-03_r8,0.10406e-03_r8 /)
      kbo(:, 1,57, 8) = (/ &
        & 0.13311e-05_r8,0.16151e-04_r8,0.21901e-04_r8,0.25044e-04_r8,0.13934e-04_r8 /)
      kbo(:, 2,57, 8) = (/ &
        & 0.13369e-05_r8,0.23005e-04_r8,0.33083e-04_r8,0.39377e-04_r8,0.21751e-04_r8 /)
      kbo(:, 3,57, 8) = (/ &
        & 0.13411e-05_r8,0.33501e-04_r8,0.50888e-04_r8,0.63014e-04_r8,0.34696e-04_r8 /)
      kbo(:, 4,57, 8) = (/ &
        & 0.13443e-05_r8,0.49111e-04_r8,0.78191e-04_r8,0.10051e-03_r8,0.55711e-04_r8 /)
      kbo(:, 5,57, 8) = (/ &
        & 0.13467e-05_r8,0.71586e-04_r8,0.11902e-03_r8,0.15744e-03_r8,0.88025e-04_r8 /)
      kbo(:, 1,58, 8) = (/ &
        & 0.10892e-05_r8,0.12962e-04_r8,0.17443e-04_r8,0.19825e-04_r8,0.10955e-04_r8 /)
      kbo(:, 2,58, 8) = (/ &
        & 0.10942e-05_r8,0.18688e-04_r8,0.26716e-04_r8,0.31664e-04_r8,0.17348e-04_r8 /)
      kbo(:, 3,58, 8) = (/ &
        & 0.10976e-05_r8,0.27650e-04_r8,0.41864e-04_r8,0.51716e-04_r8,0.28159e-04_r8 /)
      kbo(:, 4,58, 8) = (/ &
        & 0.11004e-05_r8,0.41251e-04_r8,0.65630e-04_r8,0.84299e-04_r8,0.46156e-04_r8 /)
      kbo(:, 5,58, 8) = (/ &
        & 0.11025e-05_r8,0.61261e-04_r8,0.10196e-03_r8,0.13496e-03_r8,0.74536e-04_r8 /)
      kbo(:, 1,59, 8) = (/ &
        & 0.89197e-06_r8,0.11047e-04_r8,0.14899e-04_r8,0.16964e-04_r8,0.92999e-05_r8 /)
      kbo(:, 2,59, 8) = (/ &
        & 0.89605e-06_r8,0.16215e-04_r8,0.23291e-04_r8,0.27686e-04_r8,0.15019e-04_r8 /)
      kbo(:, 3,59, 8) = (/ &
        & 0.89875e-06_r8,0.24462e-04_r8,0.37267e-04_r8,0.46243e-04_r8,0.24905e-04_r8 /)
      kbo(:, 4,59, 8) = (/ &
        & 0.90117e-06_r8,0.37175e-04_r8,0.59594e-04_r8,0.76969e-04_r8,0.41672e-04_r8 /)
      kbo(:, 5,59, 8) = (/ &
        & 0.90310e-06_r8,0.56115e-04_r8,0.94187e-04_r8,0.12528e-03_r8,0.68497e-04_r8 /)
      kbo(:, 1,13, 9) = (/ &
        & 0.56714e-01_r8,0.96228e-01_r8,0.10961e+00_r8,0.11078e+00_r8,0.82822e-01_r8 /)
      kbo(:, 2,13, 9) = (/ &
        & 0.57828e-01_r8,0.97972e-01_r8,0.11123e+00_r8,0.11236e+00_r8,0.84782e-01_r8 /)
      kbo(:, 3,13, 9) = (/ &
        & 0.59232e-01_r8,0.99998e-01_r8,0.11329e+00_r8,0.11400e+00_r8,0.86728e-01_r8 /)
      kbo(:, 4,13, 9) = (/ &
        & 0.60790e-01_r8,0.10219e+00_r8,0.11568e+00_r8,0.11591e+00_r8,0.88651e-01_r8 /)
      kbo(:, 5,13, 9) = (/ &
        & 0.62290e-01_r8,0.10448e+00_r8,0.11818e+00_r8,0.11808e+00_r8,0.90606e-01_r8 /)
      kbo(:, 1,14, 9) = (/ &
        & 0.48757e-01_r8,0.85742e-01_r8,0.97473e-01_r8,0.98306e-01_r8,0.73073e-01_r8 /)
      kbo(:, 2,14, 9) = (/ &
        & 0.49942e-01_r8,0.87692e-01_r8,0.99489e-01_r8,0.10004e+00_r8,0.75064e-01_r8 /)
      kbo(:, 3,14, 9) = (/ &
        & 0.51318e-01_r8,0.89856e-01_r8,0.10188e+00_r8,0.10205e+00_r8,0.77018e-01_r8 /)
      kbo(:, 4,14, 9) = (/ &
        & 0.52660e-01_r8,0.92153e-01_r8,0.10444e+00_r8,0.10434e+00_r8,0.78996e-01_r8 /)
      kbo(:, 5,14, 9) = (/ &
        & 0.53901e-01_r8,0.94584e-01_r8,0.10712e+00_r8,0.10687e+00_r8,0.81028e-01_r8 /)
      kbo(:, 1,15, 9) = (/ &
        & 0.41752e-01_r8,0.76198e-01_r8,0.86593e-01_r8,0.87037e-01_r8,0.64464e-01_r8 /)
      kbo(:, 2,15, 9) = (/ &
        & 0.42945e-01_r8,0.78277e-01_r8,0.88919e-01_r8,0.89055e-01_r8,0.66440e-01_r8 /)
      kbo(:, 3,15, 9) = (/ &
        & 0.44132e-01_r8,0.80544e-01_r8,0.91468e-01_r8,0.91397e-01_r8,0.68401e-01_r8 /)
      kbo(:, 4,15, 9) = (/ &
        & 0.45260e-01_r8,0.82968e-01_r8,0.94189e-01_r8,0.93993e-01_r8,0.70410e-01_r8 /)
      kbo(:, 5,15, 9) = (/ &
        & 0.46298e-01_r8,0.85502e-01_r8,0.97029e-01_r8,0.96802e-01_r8,0.72466e-01_r8 /)
      kbo(:, 1,16, 9) = (/ &
        & 0.35640e-01_r8,0.67555e-01_r8,0.76928e-01_r8,0.77126e-01_r8,0.56847e-01_r8 /)
      kbo(:, 2,16, 9) = (/ &
        & 0.36668e-01_r8,0.69730e-01_r8,0.79394e-01_r8,0.79411e-01_r8,0.58796e-01_r8 /)
      kbo(:, 3,16, 9) = (/ &
        & 0.37665e-01_r8,0.72105e-01_r8,0.82070e-01_r8,0.81996e-01_r8,0.60763e-01_r8 /)
      kbo(:, 4,16, 9) = (/ &
        & 0.38606e-01_r8,0.74641e-01_r8,0.84920e-01_r8,0.84810e-01_r8,0.62792e-01_r8 /)
      kbo(:, 5,16, 9) = (/ &
        & 0.39473e-01_r8,0.77118e-01_r8,0.87904e-01_r8,0.87777e-01_r8,0.64884e-01_r8 /)
      kbo(:, 1,17, 9) = (/ &
        & 0.30249e-01_r8,0.59768e-01_r8,0.68325e-01_r8,0.68492e-01_r8,0.50101e-01_r8 /)
      kbo(:, 2,17, 9) = (/ &
        & 0.31103e-01_r8,0.62060e-01_r8,0.70903e-01_r8,0.70988e-01_r8,0.52022e-01_r8 /)
      kbo(:, 3,17, 9) = (/ &
        & 0.31936e-01_r8,0.64534e-01_r8,0.73696e-01_r8,0.73735e-01_r8,0.54005e-01_r8 /)
      kbo(:, 4,17, 9) = (/ &
        & 0.32730e-01_r8,0.67029e-01_r8,0.76655e-01_r8,0.76665e-01_r8,0.56059e-01_r8 /)
      kbo(:, 5,17, 9) = (/ &
        & 0.33443e-01_r8,0.69449e-01_r8,0.79757e-01_r8,0.79742e-01_r8,0.58173e-01_r8 /)
      kbo(:, 1,18, 9) = (/ &
        & 0.25545e-01_r8,0.52871e-01_r8,0.60740e-01_r8,0.60992e-01_r8,0.44172e-01_r8 /)
      kbo(:, 2,18, 9) = (/ &
        & 0.26254e-01_r8,0.55233e-01_r8,0.63406e-01_r8,0.63637e-01_r8,0.46086e-01_r8 /)
      kbo(:, 3,18, 9) = (/ &
        & 0.26956e-01_r8,0.57692e-01_r8,0.66286e-01_r8,0.66462e-01_r8,0.48089e-01_r8 /)
      kbo(:, 4,18, 9) = (/ &
        & 0.27612e-01_r8,0.60136e-01_r8,0.69343e-01_r8,0.69465e-01_r8,0.50154e-01_r8 /)
      kbo(:, 5,18, 9) = (/ &
        & 0.28200e-01_r8,0.62534e-01_r8,0.72542e-01_r8,0.72608e-01_r8,0.52275e-01_r8 /)
      kbo(:, 1,19, 9) = (/ &
        & 0.21487e-01_r8,0.46786e-01_r8,0.54092e-01_r8,0.54451e-01_r8,0.38986e-01_r8 /)
      kbo(:, 2,19, 9) = (/ &
        & 0.22086e-01_r8,0.49151e-01_r8,0.56837e-01_r8,0.57167e-01_r8,0.40916e-01_r8 /)
      kbo(:, 3,19, 9) = (/ &
        & 0.22671e-01_r8,0.51565e-01_r8,0.59787e-01_r8,0.60059e-01_r8,0.42916e-01_r8 /)
      kbo(:, 4,19, 9) = (/ &
        & 0.23212e-01_r8,0.53966e-01_r8,0.62913e-01_r8,0.63134e-01_r8,0.44993e-01_r8 /)
      kbo(:, 5,19, 9) = (/ &
        & 0.23674e-01_r8,0.56335e-01_r8,0.66121e-01_r8,0.66362e-01_r8,0.47140e-01_r8 /)
      kbo(:, 1,20, 9) = (/ &
        & 0.18039e-01_r8,0.41493e-01_r8,0.48348e-01_r8,0.48783e-01_r8,0.34522e-01_r8 /)
      kbo(:, 2,20, 9) = (/ &
        & 0.18543e-01_r8,0.43801e-01_r8,0.51155e-01_r8,0.51541e-01_r8,0.36457e-01_r8 /)
      kbo(:, 3,20, 9) = (/ &
        & 0.19027e-01_r8,0.46166e-01_r8,0.54164e-01_r8,0.54503e-01_r8,0.38468e-01_r8 /)
      kbo(:, 4,20, 9) = (/ &
        & 0.19452e-01_r8,0.48538e-01_r8,0.57292e-01_r8,0.57654e-01_r8,0.40551e-01_r8 /)
      kbo(:, 5,20, 9) = (/ &
        & 0.19805e-01_r8,0.50879e-01_r8,0.60490e-01_r8,0.60969e-01_r8,0.42726e-01_r8 /)
      kbo(:, 1,21, 9) = (/ &
        & 0.15116e-01_r8,0.36867e-01_r8,0.43373e-01_r8,0.43860e-01_r8,0.30692e-01_r8 /)
      kbo(:, 2,21, 9) = (/ &
        & 0.15537e-01_r8,0.39121e-01_r8,0.46234e-01_r8,0.46663e-01_r8,0.32616e-01_r8 /)
      kbo(:, 3,21, 9) = (/ &
        & 0.15924e-01_r8,0.41438e-01_r8,0.49238e-01_r8,0.49692e-01_r8,0.34628e-01_r8 /)
      kbo(:, 4,21, 9) = (/ &
        & 0.16258e-01_r8,0.43774e-01_r8,0.52361e-01_r8,0.52910e-01_r8,0.36736e-01_r8 /)
      kbo(:, 5,21, 9) = (/ &
        & 0.16525e-01_r8,0.46101e-01_r8,0.55542e-01_r8,0.56309e-01_r8,0.38934e-01_r8 /)
      kbo(:, 1,22, 9) = (/ &
        & 0.12675e-01_r8,0.32993e-01_r8,0.39256e-01_r8,0.39779e-01_r8,0.27529e-01_r8 /)
      kbo(:, 2,22, 9) = (/ &
        & 0.13009e-01_r8,0.35201e-01_r8,0.42138e-01_r8,0.42658e-01_r8,0.29453e-01_r8 /)
      kbo(:, 3,22, 9) = (/ &
        & 0.13317e-01_r8,0.37474e-01_r8,0.45144e-01_r8,0.45756e-01_r8,0.31474e-01_r8 /)
      kbo(:, 4,22, 9) = (/ &
        & 0.13574e-01_r8,0.39784e-01_r8,0.48260e-01_r8,0.49049e-01_r8,0.33608e-01_r8 /)
      kbo(:, 5,22, 9) = (/ &
        & 0.13778e-01_r8,0.42099e-01_r8,0.51448e-01_r8,0.52529e-01_r8,0.35844e-01_r8 /)
      kbo(:, 1,23, 9) = (/ &
        & 0.10608e-01_r8,0.29677e-01_r8,0.35736e-01_r8,0.36323e-01_r8,0.24847e-01_r8 /)
      kbo(:, 2,23, 9) = (/ &
        & 0.10880e-01_r8,0.31843e-01_r8,0.38613e-01_r8,0.39274e-01_r8,0.26772e-01_r8 /)
      kbo(:, 3,23, 9) = (/ &
        & 0.11120e-01_r8,0.34081e-01_r8,0.41634e-01_r8,0.42440e-01_r8,0.28816e-01_r8 /)
      kbo(:, 4,23, 9) = (/ &
        & 0.11313e-01_r8,0.36372e-01_r8,0.44754e-01_r8,0.45808e-01_r8,0.30978e-01_r8 /)
      kbo(:, 5,23, 9) = (/ &
        & 0.11474e-01_r8,0.38689e-01_r8,0.47973e-01_r8,0.49367e-01_r8,0.33255e-01_r8 /)
      kbo(:, 1,24, 9) = (/ &
        & 0.88685e-02_r8,0.26862e-01_r8,0.32736e-01_r8,0.33437e-01_r8,0.22600e-01_r8 /)
      kbo(:, 2,24, 9) = (/ &
        & 0.90884e-02_r8,0.28994e-01_r8,0.35625e-01_r8,0.36451e-01_r8,0.24532e-01_r8 /)
      kbo(:, 3,24, 9) = (/ &
        & 0.92759e-02_r8,0.31210e-01_r8,0.38663e-01_r8,0.39696e-01_r8,0.26600e-01_r8 /)
      kbo(:, 4,24, 9) = (/ &
        & 0.94299e-02_r8,0.33488e-01_r8,0.41810e-01_r8,0.43137e-01_r8,0.28795e-01_r8 /)
      kbo(:, 5,24, 9) = (/ &
        & 0.95655e-02_r8,0.35810e-01_r8,0.45067e-01_r8,0.46765e-01_r8,0.31119e-01_r8 /)
      kbo(:, 1,25, 9) = (/ &
        & 0.74112e-02_r8,0.24493e-01_r8,0.30220e-01_r8,0.31056e-01_r8,0.20732e-01_r8 /)
      kbo(:, 2,25, 9) = (/ &
        & 0.75852e-02_r8,0.26600e-01_r8,0.33130e-01_r8,0.34139e-01_r8,0.22685e-01_r8 /)
      kbo(:, 3,25, 9) = (/ &
        & 0.77307e-02_r8,0.28805e-01_r8,0.36194e-01_r8,0.37461e-01_r8,0.24778e-01_r8 /)
      kbo(:, 4,25, 9) = (/ &
        & 0.78603e-02_r8,0.31085e-01_r8,0.39384e-01_r8,0.40978e-01_r8,0.27016e-01_r8 /)
      kbo(:, 5,25, 9) = (/ &
        & 0.79718e-02_r8,0.33416e-01_r8,0.42696e-01_r8,0.44682e-01_r8,0.29393e-01_r8 /)
      kbo(:, 1,26, 9) = (/ &
        & 0.61902e-02_r8,0.22538e-01_r8,0.28170e-01_r8,0.29154e-01_r8,0.19220e-01_r8 /)
      kbo(:, 2,26, 9) = (/ &
        & 0.63276e-02_r8,0.24632e-01_r8,0.31111e-01_r8,0.32321e-01_r8,0.21200e-01_r8 /)
      kbo(:, 3,26, 9) = (/ &
        & 0.64499e-02_r8,0.26835e-01_r8,0.34213e-01_r8,0.35713e-01_r8,0.23332e-01_r8 /)
      kbo(:, 4,26, 9) = (/ &
        & 0.65597e-02_r8,0.29126e-01_r8,0.37461e-01_r8,0.39319e-01_r8,0.25615e-01_r8 /)
      kbo(:, 5,26, 9) = (/ &
        & 0.66551e-02_r8,0.31472e-01_r8,0.40844e-01_r8,0.43117e-01_r8,0.28057e-01_r8 /)
      kbo(:, 1,27, 9) = (/ &
        & 0.51713e-02_r8,0.20911e-01_r8,0.26500e-01_r8,0.27639e-01_r8,0.17995e-01_r8 /)
      kbo(:, 2,27, 9) = (/ &
        & 0.52848e-02_r8,0.23004e-01_r8,0.29475e-01_r8,0.30887e-01_r8,0.20007e-01_r8 /)
      kbo(:, 3,27, 9) = (/ &
        & 0.53879e-02_r8,0.25219e-01_r8,0.32635e-01_r8,0.34364e-01_r8,0.22181e-01_r8 /)
      kbo(:, 4,27, 9) = (/ &
        & 0.54763e-02_r8,0.27525e-01_r8,0.35956e-01_r8,0.38064e-01_r8,0.24520e-01_r8 /)
      kbo(:, 5,27, 9) = (/ &
        & 0.55573e-02_r8,0.29889e-01_r8,0.39426e-01_r8,0.41977e-01_r8,0.27035e-01_r8 /)
      kbo(:, 1,28, 9) = (/ &
        & 0.43195e-02_r8,0.19576e-01_r8,0.25160e-01_r8,0.26468e-01_r8,0.17016e-01_r8 /)
      kbo(:, 2,28, 9) = (/ &
        & 0.44139e-02_r8,0.21680e-01_r8,0.28188e-01_r8,0.29800e-01_r8,0.19070e-01_r8 /)
      kbo(:, 3,28, 9) = (/ &
        & 0.44969e-02_r8,0.23912e-01_r8,0.31420e-01_r8,0.33375e-01_r8,0.21294e-01_r8 /)
      kbo(:, 4,28, 9) = (/ &
        & 0.45726e-02_r8,0.26235e-01_r8,0.34830e-01_r8,0.37186e-01_r8,0.23695e-01_r8 /)
      kbo(:, 5,28, 9) = (/ &
        & 0.46426e-02_r8,0.28627e-01_r8,0.38395e-01_r8,0.41222e-01_r8,0.26282e-01_r8 /)
      kbo(:, 1,29, 9) = (/ &
        & 0.36095e-02_r8,0.18508e-01_r8,0.24142e-01_r8,0.25625e-01_r8,0.16268e-01_r8 /)
      kbo(:, 2,29, 9) = (/ &
        & 0.36856e-02_r8,0.20634e-01_r8,0.27243e-01_r8,0.29053e-01_r8,0.18372e-01_r8 /)
      kbo(:, 3,29, 9) = (/ &
        & 0.37545e-02_r8,0.22890e-01_r8,0.30565e-01_r8,0.32742e-01_r8,0.20653e-01_r8 /)
      kbo(:, 4,29, 9) = (/ &
        & 0.38219e-02_r8,0.25246e-01_r8,0.34070e-01_r8,0.36676e-01_r8,0.23125e-01_r8 /)
      kbo(:, 5,29, 9) = (/ &
        & 0.38805e-02_r8,0.27676e-01_r8,0.37739e-01_r8,0.40837e-01_r8,0.25787e-01_r8 /)
      kbo(:, 1,30, 9) = (/ &
        & 0.30149e-02_r8,0.17668e-01_r8,0.23401e-01_r8,0.25061e-01_r8,0.15717e-01_r8 /)
      kbo(:, 2,30, 9) = (/ &
        & 0.30780e-02_r8,0.19823e-01_r8,0.26594e-01_r8,0.28602e-01_r8,0.17873e-01_r8 /)
      kbo(:, 3,30, 9) = (/ &
        & 0.31391e-02_r8,0.22111e-01_r8,0.30012e-01_r8,0.32409e-01_r8,0.20220e-01_r8 /)
      kbo(:, 4,30, 9) = (/ &
        & 0.31952e-02_r8,0.24511e-01_r8,0.33620e-01_r8,0.36467e-01_r8,0.22768e-01_r8 /)
      kbo(:, 5,30, 9) = (/ &
        & 0.32462e-02_r8,0.26992e-01_r8,0.37393e-01_r8,0.40756e-01_r8,0.25513e-01_r8 /)
      kbo(:, 1,31, 9) = (/ &
        & 0.25190e-02_r8,0.17039e-01_r8,0.22932e-01_r8,0.24769e-01_r8,0.15346e-01_r8 /)
      kbo(:, 2,31, 9) = (/ &
        & 0.25729e-02_r8,0.19232e-01_r8,0.26227e-01_r8,0.28432e-01_r8,0.17564e-01_r8 /)
      kbo(:, 3,31, 9) = (/ &
        & 0.26259e-02_r8,0.21567e-01_r8,0.29750e-01_r8,0.32369e-01_r8,0.19984e-01_r8 /)
      kbo(:, 4,31, 9) = (/ &
        & 0.26746e-02_r8,0.24020e-01_r8,0.33463e-01_r8,0.36549e-01_r8,0.22614e-01_r8 /)
      kbo(:, 5,31, 9) = (/ &
        & 0.27170e-02_r8,0.26556e-01_r8,0.37338e-01_r8,0.40957e-01_r8,0.25451e-01_r8 /)
      kbo(:, 1,32, 9) = (/ &
        & 0.21057e-02_r8,0.16597e-01_r8,0.22710e-01_r8,0.24723e-01_r8,0.15137e-01_r8 /)
      kbo(:, 2,32, 9) = (/ &
        & 0.21537e-02_r8,0.18840e-01_r8,0.26112e-01_r8,0.28512e-01_r8,0.17424e-01_r8 /)
      kbo(:, 3,32, 9) = (/ &
        & 0.21983e-02_r8,0.21233e-01_r8,0.29743e-01_r8,0.32575e-01_r8,0.19926e-01_r8 /)
      kbo(:, 4,32, 9) = (/ &
        & 0.22397e-02_r8,0.23745e-01_r8,0.33557e-01_r8,0.36873e-01_r8,0.22643e-01_r8 /)
      kbo(:, 5,32, 9) = (/ &
        & 0.22779e-02_r8,0.26339e-01_r8,0.37525e-01_r8,0.41395e-01_r8,0.25571e-01_r8 /)
      kbo(:, 1,33, 9) = (/ &
        & 0.17621e-02_r8,0.16326e-01_r8,0.22706e-01_r8,0.24894e-01_r8,0.15071e-01_r8 /)
      kbo(:, 2,33, 9) = (/ &
        & 0.18037e-02_r8,0.18626e-01_r8,0.26218e-01_r8,0.28807e-01_r8,0.17434e-01_r8 /)
      kbo(:, 3,33, 9) = (/ &
        & 0.18413e-02_r8,0.21083e-01_r8,0.29952e-01_r8,0.32989e-01_r8,0.20023e-01_r8 /)
      kbo(:, 4,33, 9) = (/ &
        & 0.18774e-02_r8,0.23655e-01_r8,0.33863e-01_r8,0.37400e-01_r8,0.22833e-01_r8 /)
      kbo(:, 5,33, 9) = (/ &
        & 0.19114e-02_r8,0.26308e-01_r8,0.37916e-01_r8,0.42025e-01_r8,0.25847e-01_r8 /)
      kbo(:, 1,34, 9) = (/ &
        & 0.14751e-02_r8,0.16125e-01_r8,0.22769e-01_r8,0.25117e-01_r8,0.15050e-01_r8 /)
      kbo(:, 2,34, 9) = (/ &
        & 0.15101e-02_r8,0.18488e-01_r8,0.26381e-01_r8,0.29139e-01_r8,0.17489e-01_r8 /)
      kbo(:, 3,34, 9) = (/ &
        & 0.15432e-02_r8,0.21005e-01_r8,0.30205e-01_r8,0.33424e-01_r8,0.20158e-01_r8 /)
      kbo(:, 4,34, 9) = (/ &
        & 0.15747e-02_r8,0.23633e-01_r8,0.34198e-01_r8,0.37931e-01_r8,0.23050e-01_r8 /)
      kbo(:, 5,34, 9) = (/ &
        & 0.16051e-02_r8,0.26339e-01_r8,0.38321e-01_r8,0.42642e-01_r8,0.26140e-01_r8 /)
      kbo(:, 1,35, 9) = (/ &
        & 0.12323e-02_r8,0.15834e-01_r8,0.22646e-01_r8,0.25106e-01_r8,0.14908e-01_r8 /)
      kbo(:, 2,35, 9) = (/ &
        & 0.12626e-02_r8,0.18245e-01_r8,0.26331e-01_r8,0.29206e-01_r8,0.17403e-01_r8 /)
      kbo(:, 3,35, 9) = (/ &
        & 0.12919e-02_r8,0.20808e-01_r8,0.30221e-01_r8,0.33562e-01_r8,0.20132e-01_r8 /)
      kbo(:, 4,35, 9) = (/ &
        & 0.13197e-02_r8,0.23481e-01_r8,0.34270e-01_r8,0.38136e-01_r8,0.23081e-01_r8 /)
      kbo(:, 5,35, 9) = (/ &
        & 0.13470e-02_r8,0.26228e-01_r8,0.38442e-01_r8,0.42907e-01_r8,0.26222e-01_r8 /)
      kbo(:, 1,36, 9) = (/ &
        & 0.10273e-02_r8,0.15393e-01_r8,0.22247e-01_r8,0.24766e-01_r8,0.14589e-01_r8 /)
      kbo(:, 2,36, 9) = (/ &
        & 0.10537e-02_r8,0.17833e-01_r8,0.25974e-01_r8,0.28911e-01_r8,0.17115e-01_r8 /)
      kbo(:, 3,36, 9) = (/ &
        & 0.10795e-02_r8,0.20426e-01_r8,0.29904e-01_r8,0.33307e-01_r8,0.19875e-01_r8 /)
      kbo(:, 4,36, 9) = (/ &
        & 0.11043e-02_r8,0.23131e-01_r8,0.33989e-01_r8,0.37917e-01_r8,0.22855e-01_r8 /)
      kbo(:, 5,36, 9) = (/ &
        & 0.11288e-02_r8,0.25909e-01_r8,0.38197e-01_r8,0.42722e-01_r8,0.26026e-01_r8 /)
      kbo(:, 1,37, 9) = (/ &
        & 0.85383e-03_r8,0.14679e-01_r8,0.21388e-01_r8,0.23897e-01_r8,0.13970e-01_r8 /)
      kbo(:, 2,37, 9) = (/ &
        & 0.87682e-03_r8,0.17120e-01_r8,0.25115e-01_r8,0.28039e-01_r8,0.16489e-01_r8 /)
      kbo(:, 3,37, 9) = (/ &
        & 0.89996e-03_r8,0.19721e-01_r8,0.29054e-01_r8,0.32436e-01_r8,0.19242e-01_r8 /)
      kbo(:, 4,37, 9) = (/ &
        & 0.92246e-03_r8,0.22439e-01_r8,0.33150e-01_r8,0.37047e-01_r8,0.22217e-01_r8 /)
      kbo(:, 5,37, 9) = (/ &
        & 0.94506e-03_r8,0.25234e-01_r8,0.37369e-01_r8,0.41852e-01_r8,0.25386e-01_r8 /)
      kbo(:, 1,38, 9) = (/ &
        & 0.70953e-03_r8,0.14014e-01_r8,0.20566e-01_r8,0.23058e-01_r8,0.13383e-01_r8 /)
      kbo(:, 2,38, 9) = (/ &
        & 0.73008e-03_r8,0.16455e-01_r8,0.24289e-01_r8,0.27191e-01_r8,0.15892e-01_r8 /)
      kbo(:, 3,38, 9) = (/ &
        & 0.75050e-03_r8,0.19058e-01_r8,0.28230e-01_r8,0.31581e-01_r8,0.18633e-01_r8 /)
      kbo(:, 4,38, 9) = (/ &
        & 0.77107e-03_r8,0.21784e-01_r8,0.32331e-01_r8,0.36184e-01_r8,0.21597e-01_r8 /)
      kbo(:, 5,38, 9) = (/ &
        & 0.79117e-03_r8,0.24590e-01_r8,0.36557e-01_r8,0.40986e-01_r8,0.24760e-01_r8 /)
      kbo(:, 1,39, 9) = (/ &
        & 0.58982e-03_r8,0.13410e-01_r8,0.19807e-01_r8,0.22275e-01_r8,0.12843e-01_r8 /)
      kbo(:, 2,39, 9) = (/ &
        & 0.60777e-03_r8,0.15847e-01_r8,0.23520e-01_r8,0.26395e-01_r8,0.15340e-01_r8 /)
      kbo(:, 3,39, 9) = (/ &
        & 0.62607e-03_r8,0.18449e-01_r8,0.27458e-01_r8,0.30773e-01_r8,0.18067e-01_r8 /)
      kbo(:, 4,39, 9) = (/ &
        & 0.64471e-03_r8,0.21179e-01_r8,0.31559e-01_r8,0.35367e-01_r8,0.21018e-01_r8 /)
      kbo(:, 5,39, 9) = (/ &
        & 0.66285e-03_r8,0.23994e-01_r8,0.35788e-01_r8,0.40160e-01_r8,0.24170e-01_r8 /)
      kbo(:, 1,40, 9) = (/ &
        & 0.48914e-03_r8,0.12617e-01_r8,0.18733e-01_r8,0.21131e-01_r8,0.12100e-01_r8 /)
      kbo(:, 2,40, 9) = (/ &
        & 0.50499e-03_r8,0.15028e-01_r8,0.22406e-01_r8,0.25206e-01_r8,0.14559e-01_r8 /)
      kbo(:, 3,40, 9) = (/ &
        & 0.52119e-03_r8,0.17611e-01_r8,0.26314e-01_r8,0.29544e-01_r8,0.17245e-01_r8 /)
      kbo(:, 4,40, 9) = (/ &
        & 0.53770e-03_r8,0.20330e-01_r8,0.30397e-01_r8,0.34103e-01_r8,0.20159e-01_r8 /)
      kbo(:, 5,40, 9) = (/ &
        & 0.55398e-03_r8,0.23142e-01_r8,0.34616e-01_r8,0.38867e-01_r8,0.23278e-01_r8 /)
      kbo(:, 1,41, 9) = (/ &
        & 0.40532e-03_r8,0.11840e-01_r8,0.17661e-01_r8,0.19981e-01_r8,0.11365e-01_r8 /)
      kbo(:, 2,41, 9) = (/ &
        & 0.41916e-03_r8,0.14219e-01_r8,0.21285e-01_r8,0.24002e-01_r8,0.13782e-01_r8 /)
      kbo(:, 3,41, 9) = (/ &
        & 0.43354e-03_r8,0.16775e-01_r8,0.25154e-01_r8,0.28292e-01_r8,0.16423e-01_r8 /)
      kbo(:, 4,41, 9) = (/ &
        & 0.44807e-03_r8,0.19478e-01_r8,0.29214e-01_r8,0.32812e-01_r8,0.19291e-01_r8 /)
      kbo(:, 5,41, 9) = (/ &
        & 0.46282e-03_r8,0.22283e-01_r8,0.33415e-01_r8,0.37538e-01_r8,0.22373e-01_r8 /)
      kbo(:, 1,42, 9) = (/ &
        & 0.33573e-03_r8,0.11104e-01_r8,0.16634e-01_r8,0.18873e-01_r8,0.10664e-01_r8 /)
      kbo(:, 2,42, 9) = (/ &
        & 0.34776e-03_r8,0.13446e-01_r8,0.20201e-01_r8,0.22835e-01_r8,0.13037e-01_r8 /)
      kbo(:, 3,42, 9) = (/ &
        & 0.36046e-03_r8,0.15973e-01_r8,0.24027e-01_r8,0.27071e-01_r8,0.15631e-01_r8 /)
      kbo(:, 4,42, 9) = (/ &
        & 0.37344e-03_r8,0.18654e-01_r8,0.28057e-01_r8,0.31550e-01_r8,0.18451e-01_r8 /)
      kbo(:, 5,42, 9) = (/ &
        & 0.38663e-03_r8,0.21448e-01_r8,0.32235e-01_r8,0.36231e-01_r8,0.21492e-01_r8 /)
      kbo(:, 1,43, 9) = (/ &
        & 0.27733e-03_r8,0.10283e-01_r8,0.15460e-01_r8,0.17597e-01_r8,0.98707e-02_r8 /)
      kbo(:, 2,43, 9) = (/ &
        & 0.28779e-03_r8,0.12571e-01_r8,0.18947e-01_r8,0.21473e-01_r8,0.12183e-01_r8 /)
      kbo(:, 3,43, 9) = (/ &
        & 0.29891e-03_r8,0.15054e-01_r8,0.22712e-01_r8,0.25638e-01_r8,0.14718e-01_r8 /)
      kbo(:, 4,43, 9) = (/ &
        & 0.31033e-03_r8,0.17702e-01_r8,0.26696e-01_r8,0.30055e-01_r8,0.17477e-01_r8 /)
      kbo(:, 5,43, 9) = (/ &
        & 0.32200e-03_r8,0.20476e-01_r8,0.30841e-01_r8,0.34682e-01_r8,0.20459e-01_r8 /)
      kbo(:, 1,44, 9) = (/ &
        & 0.22878e-03_r8,0.94499e-02_r8,0.14251e-01_r8,0.16276e-01_r8,0.90607e-02_r8 /)
      kbo(:, 2,44, 9) = (/ &
        & 0.23775e-03_r8,0.11673e-01_r8,0.17646e-01_r8,0.20049e-01_r8,0.11303e-01_r8 /)
      kbo(:, 3,44, 9) = (/ &
        & 0.24747e-03_r8,0.14106e-01_r8,0.21336e-01_r8,0.24135e-01_r8,0.13772e-01_r8 /)
      kbo(:, 4,44, 9) = (/ &
        & 0.25755e-03_r8,0.16710e-01_r8,0.25261e-01_r8,0.28479e-01_r8,0.16464e-01_r8 /)
      kbo(:, 5,44, 9) = (/ &
        & 0.26798e-03_r8,0.19454e-01_r8,0.29363e-01_r8,0.33046e-01_r8,0.19378e-01_r8 /)
      kbo(:, 1,45, 9) = (/ &
        & 0.18849e-03_r8,0.86584e-02_r8,0.13096e-01_r8,0.15007e-01_r8,0.82904e-02_r8 /)
      kbo(:, 2,45, 9) = (/ &
        & 0.19636e-03_r8,0.10814e-01_r8,0.16390e-01_r8,0.18672e-01_r8,0.10458e-01_r8 /)
      kbo(:, 3,45, 9) = (/ &
        & 0.20470e-03_r8,0.13189e-01_r8,0.19995e-01_r8,0.22671e-01_r8,0.12861e-01_r8 /)
      kbo(:, 4,45, 9) = (/ &
        & 0.21344e-03_r8,0.15746e-01_r8,0.23854e-01_r8,0.26936e-01_r8,0.15483e-01_r8 /)
      kbo(:, 5,45, 9) = (/ &
        & 0.22266e-03_r8,0.18454e-01_r8,0.27912e-01_r8,0.31439e-01_r8,0.18328e-01_r8 /)
      kbo(:, 1,46, 9) = (/ &
        & 0.15507e-03_r8,0.78632e-02_r8,0.11928e-01_r8,0.13712e-01_r8,0.75164e-02_r8 /)
      kbo(:, 2,46, 9) = (/ &
        & 0.16179e-03_r8,0.99413e-02_r8,0.15104e-01_r8,0.17260e-01_r8,0.95985e-02_r8 /)
      kbo(:, 3,46, 9) = (/ &
        & 0.16890e-03_r8,0.12249e-01_r8,0.18612e-01_r8,0.21154e-01_r8,0.11927e-01_r8 /)
      kbo(:, 4,46, 9) = (/ &
        & 0.17659e-03_r8,0.14751e-01_r8,0.22394e-01_r8,0.25333e-01_r8,0.14476e-01_r8 /)
      kbo(:, 5,46, 9) = (/ &
        & 0.18474e-03_r8,0.17415e-01_r8,0.26393e-01_r8,0.29761e-01_r8,0.17246e-01_r8 /)
      kbo(:, 1,47, 9) = (/ &
        & 0.12726e-03_r8,0.70304e-02_r8,0.10696e-01_r8,0.12336e-01_r8,0.67029e-02_r8 /)
      kbo(:, 2,47, 9) = (/ &
        & 0.13291e-03_r8,0.90171e-02_r8,0.13730e-01_r8,0.15745e-01_r8,0.86863e-02_r8 /)
      kbo(:, 3,47, 9) = (/ &
        & 0.13906e-03_r8,0.11243e-01_r8,0.17120e-01_r8,0.19510e-01_r8,0.10925e-01_r8 /)
      kbo(:, 4,47, 9) = (/ &
        & 0.14561e-03_r8,0.13678e-01_r8,0.20805e-01_r8,0.23588e-01_r8,0.13392e-01_r8 /)
      kbo(:, 5,47, 9) = (/ &
        & 0.15268e-03_r8,0.16286e-01_r8,0.24728e-01_r8,0.27924e-01_r8,0.16077e-01_r8 /)
      kbo(:, 1,48, 9) = (/ &
        & 0.10430e-03_r8,0.62479e-02_r8,0.95325e-02_r8,0.11029e-01_r8,0.59380e-02_r8 /)
      kbo(:, 2,48, 9) = (/ &
        & 0.10909e-03_r8,0.81380e-02_r8,0.12419e-01_r8,0.14291e-01_r8,0.78205e-02_r8 /)
      kbo(:, 3,48, 9) = (/ &
        & 0.11429e-03_r8,0.10277e-01_r8,0.15680e-01_r8,0.17922e-01_r8,0.99641e-02_r8 /)
      kbo(:, 4,48, 9) = (/ &
        & 0.11996e-03_r8,0.12637e-01_r8,0.19259e-01_r8,0.21888e-01_r8,0.12347e-01_r8 /)
      kbo(:, 5,48, 9) = (/ &
        & 0.12611e-03_r8,0.15183e-01_r8,0.23095e-01_r8,0.26125e-01_r8,0.14947e-01_r8 /)
      kbo(:, 1,49, 9) = (/ &
        & 0.85361e-04_r8,0.55178e-02_r8,0.84413e-02_r8,0.97939e-02_r8,0.52224e-02_r8 /)
      kbo(:, 2,49, 9) = (/ &
        & 0.89682e-04_r8,0.73124e-02_r8,0.11182e-01_r8,0.12906e-01_r8,0.70024e-02_r8 /)
      kbo(:, 3,49, 9) = (/ &
        & 0.93818e-04_r8,0.93518e-02_r8,0.14295e-01_r8,0.16393e-01_r8,0.90454e-02_r8 /)
      kbo(:, 4,49, 9) = (/ &
        & 0.98731e-04_r8,0.11631e-01_r8,0.17758e-01_r8,0.20234e-01_r8,0.11339e-01_r8 /)
      kbo(:, 5,49, 9) = (/ &
        & 0.10398e-03_r8,0.14111e-01_r8,0.21502e-01_r8,0.24370e-01_r8,0.13856e-01_r8 /)
      kbo(:, 1,50, 9) = (/ &
        & 0.70068e-04_r8,0.48843e-02_r8,0.74862e-02_r8,0.87029e-02_r8,0.45961e-02_r8 /)
      kbo(:, 2,50, 9) = (/ &
        & 0.73528e-04_r8,0.65706e-02_r8,0.10074e-01_r8,0.11661e-01_r8,0.62737e-02_r8 /)
      kbo(:, 3,50, 9) = (/ &
        & 0.77377e-04_r8,0.85288e-02_r8,0.13057e-01_r8,0.15019e-01_r8,0.82236e-02_r8 /)
      kbo(:, 4,50, 9) = (/ &
        & 0.81195e-04_r8,0.10720e-01_r8,0.16396e-01_r8,0.18728e-01_r8,0.10428e-01_r8 /)
      kbo(:, 5,50, 9) = (/ &
        & 0.85703e-04_r8,0.13133e-01_r8,0.20042e-01_r8,0.22765e-01_r8,0.12867e-01_r8 /)
      kbo(:, 1,51, 9) = (/ &
        & 0.57383e-04_r8,0.43058e-02_r8,0.66126e-02_r8,0.77023e-02_r8,0.40299e-02_r8 /)
      kbo(:, 2,51, 9) = (/ &
        & 0.60290e-04_r8,0.58916e-02_r8,0.90543e-02_r8,0.10509e-01_r8,0.56057e-02_r8 /)
      kbo(:, 3,51, 9) = (/ &
        & 0.63513e-04_r8,0.77586e-02_r8,0.11901e-01_r8,0.13729e-01_r8,0.74620e-02_r8 /)
      kbo(:, 4,51, 9) = (/ &
        & 0.66727e-04_r8,0.98672e-02_r8,0.15116e-01_r8,0.17314e-01_r8,0.95779e-02_r8 /)
      kbo(:, 5,51, 9) = (/ &
        & 0.70598e-04_r8,0.12209e-01_r8,0.18661e-01_r8,0.21244e-01_r8,0.11938e-01_r8 /)
      kbo(:, 1,52, 9) = (/ &
        & 0.46933e-04_r8,0.37683e-02_r8,0.57987e-02_r8,0.67684e-02_r8,0.35066e-02_r8 /)
      kbo(:, 2,52, 9) = (/ &
        & 0.49374e-04_r8,0.52554e-02_r8,0.80944e-02_r8,0.94163e-02_r8,0.49785e-02_r8 /)
      kbo(:, 3,52, 9) = (/ &
        & 0.52069e-04_r8,0.70251e-02_r8,0.10799e-01_r8,0.12493e-01_r8,0.67384e-02_r8 /)
      kbo(:, 4,52, 9) = (/ &
        & 0.55066e-04_r8,0.90579e-02_r8,0.13892e-01_r8,0.15957e-01_r8,0.87644e-02_r8 /)
      kbo(:, 5,52, 9) = (/ &
        & 0.58094e-04_r8,0.11314e-01_r8,0.17321e-01_r8,0.19762e-01_r8,0.11039e-01_r8 /)
      kbo(:, 1,53, 9) = (/ &
        & 0.38369e-04_r8,0.32705e-02_r8,0.50428e-02_r8,0.58997e-02_r8,0.30250e-02_r8 /)
      kbo(:, 2,53, 9) = (/ &
        & 0.40389e-04_r8,0.46579e-02_r8,0.71882e-02_r8,0.83794e-02_r8,0.43908e-02_r8 /)
      kbo(:, 3,53, 9) = (/ &
        & 0.42656e-04_r8,0.63275e-02_r8,0.97486e-02_r8,0.11308e-01_r8,0.60500e-02_r8 /)
      kbo(:, 4,53, 9) = (/ &
        & 0.45173e-04_r8,0.82714e-02_r8,0.12706e-01_r8,0.14639e-01_r8,0.79824e-02_r8 /)
      kbo(:, 5,53, 9) = (/ &
        & 0.47733e-04_r8,0.10447e-01_r8,0.16018e-01_r8,0.18320e-01_r8,0.10170e-01_r8 /)
      kbo(:, 1,54, 9) = (/ &
        & 0.31373e-04_r8,0.28489e-02_r8,0.44023e-02_r8,0.51602e-02_r8,0.26198e-02_r8 /)
      kbo(:, 2,54, 9) = (/ &
        & 0.33072e-04_r8,0.41448e-02_r8,0.64072e-02_r8,0.74821e-02_r8,0.38868e-02_r8 /)
      kbo(:, 3,54, 9) = (/ &
        & 0.34962e-04_r8,0.57219e-02_r8,0.88331e-02_r8,0.10271e-01_r8,0.54518e-02_r8 /)
      kbo(:, 4,54, 9) = (/ &
        & 0.37073e-04_r8,0.75801e-02_r8,0.11663e-01_r8,0.13472e-01_r8,0.72975e-02_r8 /)
      kbo(:, 5,54, 9) = (/ &
        & 0.39224e-04_r8,0.96795e-02_r8,0.14861e-01_r8,0.17039e-01_r8,0.94030e-02_r8 /)
      kbo(:, 1,55, 9) = (/ &
        & 0.25649e-04_r8,0.24774e-02_r8,0.38358e-02_r8,0.45027e-02_r8,0.22635e-02_r8 /)
      kbo(:, 2,55, 9) = (/ &
        & 0.27065e-04_r8,0.36831e-02_r8,0.57040e-02_r8,0.66733e-02_r8,0.34361e-02_r8 /)
      kbo(:, 3,55, 9) = (/ &
        & 0.28649e-04_r8,0.51728e-02_r8,0.80003e-02_r8,0.93199e-02_r8,0.49087e-02_r8 /)
      kbo(:, 4,55, 9) = (/ &
        & 0.30419e-04_r8,0.69443e-02_r8,0.10704e-01_r8,0.12395e-01_r8,0.66688e-02_r8 /)
      kbo(:, 5,55, 9) = (/ &
        & 0.32478e-04_r8,0.89781e-02_r8,0.13794e-01_r8,0.15856e-01_r8,0.86947e-02_r8 /)
      kbo(:, 1,56, 9) = (/ &
        & 0.20960e-04_r8,0.21374e-02_r8,0.33161e-02_r8,0.38972e-02_r8,0.19394e-02_r8 /)
      kbo(:, 2,56, 9) = (/ &
        & 0.22130e-04_r8,0.32530e-02_r8,0.50471e-02_r8,0.59166e-02_r8,0.30185e-02_r8 /)
      kbo(:, 3,56, 9) = (/ &
        & 0.23455e-04_r8,0.46545e-02_r8,0.72105e-02_r8,0.84156e-02_r8,0.43975e-02_r8 /)
      kbo(:, 4,56, 9) = (/ &
        & 0.24958e-04_r8,0.63377e-02_r8,0.97876e-02_r8,0.11360e-01_r8,0.60688e-02_r8 /)
      kbo(:, 5,56, 9) = (/ &
        & 0.26672e-04_r8,0.82933e-02_r8,0.12759e-01_r8,0.14704e-01_r8,0.80123e-02_r8 /)
      kbo(:, 1,57, 9) = (/ &
        & 0.17108e-04_r8,0.18275e-02_r8,0.28407e-02_r8,0.33429e-02_r8,0.16463e-02_r8 /)
      kbo(:, 2,57, 9) = (/ &
        & 0.18082e-04_r8,0.28535e-02_r8,0.44360e-02_r8,0.52097e-02_r8,0.26326e-02_r8 /)
      kbo(:, 3,57, 9) = (/ &
        & 0.19184e-04_r8,0.41668e-02_r8,0.64646e-02_r8,0.75572e-02_r8,0.39170e-02_r8 /)
      kbo(:, 4,57, 9) = (/ &
        & 0.20446e-04_r8,0.57610e-02_r8,0.89128e-02_r8,0.10368e-01_r8,0.54979e-02_r8 /)
      kbo(:, 5,57, 9) = (/ &
        & 0.21854e-04_r8,0.76342e-02_r8,0.11762e-01_r8,0.13588e-01_r8,0.73577e-02_r8 /)
      kbo(:, 1,58, 9) = (/ &
        & 0.13963e-04_r8,0.15602e-02_r8,0.24292e-02_r8,0.28638e-02_r8,0.13965e-02_r8 /)
      kbo(:, 2,58, 9) = (/ &
        & 0.14773e-04_r8,0.25031e-02_r8,0.38984e-02_r8,0.45849e-02_r8,0.22957e-02_r8 /)
      kbo(:, 3,58, 9) = (/ &
        & 0.15698e-04_r8,0.37311e-02_r8,0.57975e-02_r8,0.67885e-02_r8,0.34899e-02_r8 /)
      kbo(:, 4,58, 9) = (/ &
        & 0.16731e-04_r8,0.52413e-02_r8,0.81221e-02_r8,0.94657e-02_r8,0.49831e-02_r8 /)
      kbo(:, 5,58, 9) = (/ &
        & 0.17926e-04_r8,0.70329e-02_r8,0.10852e-01_r8,0.12566e-01_r8,0.67622e-02_r8 /)
      kbo(:, 1,59, 9) = (/ &
        & 0.11515e-04_r8,0.14557e-02_r8,0.22712e-02_r8,0.26808e-02_r8,0.13001e-02_r8 /)
      kbo(:, 2,59, 9) = (/ &
        & 0.12194e-04_r8,0.23665e-02_r8,0.36913e-02_r8,0.43444e-02_r8,0.21654e-02_r8 /)
      kbo(:, 3,59, 9) = (/ &
        & 0.12975e-04_r8,0.35608e-02_r8,0.55385e-02_r8,0.64911e-02_r8,0.33241e-02_r8 /)
      kbo(:, 4,59, 9) = (/ &
        & 0.13854e-04_r8,0.50382e-02_r8,0.78142e-02_r8,0.91137e-02_r8,0.47825e-02_r8 /)
      kbo(:, 5,59, 9) = (/ &
        & 0.14890e-04_r8,0.67966e-02_r8,0.10497e-01_r8,0.12166e-01_r8,0.65291e-02_r8 /)
      kbo(:, 1,13,10) = (/ &
        & 0.23136e+00_r8,0.35590e+00_r8,0.41705e+00_r8,0.42838e+00_r8,0.34405e+00_r8 /)
      kbo(:, 2,13,10) = (/ &
        & 0.23570e+00_r8,0.35573e+00_r8,0.41855e+00_r8,0.43318e+00_r8,0.34979e+00_r8 /)
      kbo(:, 3,13,10) = (/ &
        & 0.23997e+00_r8,0.35949e+00_r8,0.42029e+00_r8,0.43813e+00_r8,0.35426e+00_r8 /)
      kbo(:, 4,13,10) = (/ &
        & 0.24492e+00_r8,0.36590e+00_r8,0.42350e+00_r8,0.44177e+00_r8,0.35947e+00_r8 /)
      kbo(:, 5,13,10) = (/ &
        & 0.25202e+00_r8,0.37242e+00_r8,0.42924e+00_r8,0.44467e+00_r8,0.36481e+00_r8 /)
      kbo(:, 1,14,10) = (/ &
        & 0.20433e+00_r8,0.32280e+00_r8,0.38114e+00_r8,0.39530e+00_r8,0.30987e+00_r8 /)
      kbo(:, 2,14,10) = (/ &
        & 0.20812e+00_r8,0.32580e+00_r8,0.38400e+00_r8,0.40099e+00_r8,0.31521e+00_r8 /)
      kbo(:, 3,14,10) = (/ &
        & 0.21260e+00_r8,0.33207e+00_r8,0.38794e+00_r8,0.40573e+00_r8,0.32135e+00_r8 /)
      kbo(:, 4,14,10) = (/ &
        & 0.21971e+00_r8,0.33857e+00_r8,0.39426e+00_r8,0.40959e+00_r8,0.32811e+00_r8 /)
      kbo(:, 5,14,10) = (/ &
        & 0.22862e+00_r8,0.34522e+00_r8,0.40235e+00_r8,0.41376e+00_r8,0.33439e+00_r8 /)
      kbo(:, 1,15,10) = (/ &
        & 0.17974e+00_r8,0.29385e+00_r8,0.34710e+00_r8,0.36214e+00_r8,0.27698e+00_r8 /)
      kbo(:, 2,15,10) = (/ &
        & 0.18361e+00_r8,0.29985e+00_r8,0.35176e+00_r8,0.36835e+00_r8,0.28361e+00_r8 /)
      kbo(:, 3,15,10) = (/ &
        & 0.19011e+00_r8,0.30650e+00_r8,0.35844e+00_r8,0.37336e+00_r8,0.29140e+00_r8 /)
      kbo(:, 4,15,10) = (/ &
        & 0.19870e+00_r8,0.31340e+00_r8,0.36676e+00_r8,0.37856e+00_r8,0.29913e+00_r8 /)
      kbo(:, 5,15,10) = (/ &
        & 0.20713e+00_r8,0.32067e+00_r8,0.37517e+00_r8,0.38452e+00_r8,0.30673e+00_r8 /)
      kbo(:, 1,16,10) = (/ &
        & 0.15768e+00_r8,0.26909e+00_r8,0.31566e+00_r8,0.32905e+00_r8,0.24795e+00_r8 /)
      kbo(:, 2,16,10) = (/ &
        & 0.16341e+00_r8,0.27579e+00_r8,0.32257e+00_r8,0.33542e+00_r8,0.25593e+00_r8 /)
      kbo(:, 3,16,10) = (/ &
        & 0.17143e+00_r8,0.28283e+00_r8,0.33152e+00_r8,0.34164e+00_r8,0.26468e+00_r8 /)
      kbo(:, 4,16,10) = (/ &
        & 0.17943e+00_r8,0.29026e+00_r8,0.34054e+00_r8,0.34897e+00_r8,0.27328e+00_r8 /)
      kbo(:, 5,16,10) = (/ &
        & 0.18690e+00_r8,0.29935e+00_r8,0.34954e+00_r8,0.35767e+00_r8,0.28225e+00_r8 /)
      kbo(:, 1,17,10) = (/ &
        & 0.13875e+00_r8,0.24652e+00_r8,0.28696e+00_r8,0.29693e+00_r8,0.22321e+00_r8 /)
      kbo(:, 2,17,10) = (/ &
        & 0.14611e+00_r8,0.25366e+00_r8,0.29630e+00_r8,0.30411e+00_r8,0.23216e+00_r8 /)
      kbo(:, 3,17,10) = (/ &
        & 0.15377e+00_r8,0.26122e+00_r8,0.30597e+00_r8,0.31229e+00_r8,0.24127e+00_r8 /)
      kbo(:, 4,17,10) = (/ &
        & 0.16099e+00_r8,0.27029e+00_r8,0.31565e+00_r8,0.32218e+00_r8,0.25077e+00_r8 /)
      kbo(:, 5,17,10) = (/ &
        & 0.16791e+00_r8,0.28100e+00_r8,0.32533e+00_r8,0.33316e+00_r8,0.26091e+00_r8 /)
      kbo(:, 1,18,10) = (/ &
        & 0.12258e+00_r8,0.22568e+00_r8,0.26154e+00_r8,0.26746e+00_r8,0.20208e+00_r8 /)
      kbo(:, 2,18,10) = (/ &
        & 0.12972e+00_r8,0.23340e+00_r8,0.27183e+00_r8,0.27607e+00_r8,0.21144e+00_r8 /)
      kbo(:, 3,18,10) = (/ &
        & 0.13673e+00_r8,0.24228e+00_r8,0.28202e+00_r8,0.28661e+00_r8,0.22093e+00_r8 /)
      kbo(:, 4,18,10) = (/ &
        & 0.14352e+00_r8,0.25285e+00_r8,0.29256e+00_r8,0.29859e+00_r8,0.23121e+00_r8 /)
      kbo(:, 5,18,10) = (/ &
        & 0.14999e+00_r8,0.26447e+00_r8,0.30340e+00_r8,0.31163e+00_r8,0.24203e+00_r8 /)
      kbo(:, 1,19,10) = (/ &
        & 0.10785e+00_r8,0.20667e+00_r8,0.23879e+00_r8,0.24194e+00_r8,0.18368e+00_r8 /)
      kbo(:, 2,19,10) = (/ &
        & 0.11429e+00_r8,0.21546e+00_r8,0.24926e+00_r8,0.25235e+00_r8,0.19325e+00_r8 /)
      kbo(:, 3,19,10) = (/ &
        & 0.12064e+00_r8,0.22577e+00_r8,0.26022e+00_r8,0.26472e+00_r8,0.20338e+00_r8 /)
      kbo(:, 4,19,10) = (/ &
        & 0.12700e+00_r8,0.23751e+00_r8,0.27175e+00_r8,0.27823e+00_r8,0.21416e+00_r8 /)
      kbo(:, 5,19,10) = (/ &
        & 0.13335e+00_r8,0.24924e+00_r8,0.28423e+00_r8,0.29239e+00_r8,0.22548e+00_r8 /)
      kbo(:, 1,20,10) = (/ &
        & 0.94314e-01_r8,0.18969e+00_r8,0.21843e+00_r8,0.22089e+00_r8,0.16767e+00_r8 /)
      kbo(:, 2,20,10) = (/ &
        & 0.10011e+00_r8,0.20009e+00_r8,0.22938e+00_r8,0.23290e+00_r8,0.17759e+00_r8 /)
      kbo(:, 3,20,10) = (/ &
        & 0.10602e+00_r8,0.21171e+00_r8,0.24114e+00_r8,0.24650e+00_r8,0.18815e+00_r8 /)
      kbo(:, 4,20,10) = (/ &
        & 0.11212e+00_r8,0.22366e+00_r8,0.25410e+00_r8,0.26076e+00_r8,0.19951e+00_r8 /)
      kbo(:, 5,20,10) = (/ &
        & 0.11820e+00_r8,0.23566e+00_r8,0.26816e+00_r8,0.27572e+00_r8,0.21140e+00_r8 /)
      kbo(:, 1,21,10) = (/ &
        & 0.82096e-01_r8,0.17498e+00_r8,0.20057e+00_r8,0.20349e+00_r8,0.15368e+00_r8 /)
      kbo(:, 2,21,10) = (/ &
        & 0.87376e-01_r8,0.18671e+00_r8,0.21217e+00_r8,0.21678e+00_r8,0.16394e+00_r8 /)
      kbo(:, 3,21,10) = (/ &
        & 0.92996e-01_r8,0.19901e+00_r8,0.22527e+00_r8,0.23088e+00_r8,0.17505e+00_r8 /)
      kbo(:, 4,21,10) = (/ &
        & 0.98752e-01_r8,0.21131e+00_r8,0.23942e+00_r8,0.24575e+00_r8,0.18685e+00_r8 /)
      kbo(:, 5,21,10) = (/ &
        & 0.10451e+00_r8,0.22356e+00_r8,0.25490e+00_r8,0.26152e+00_r8,0.19924e+00_r8 /)
      kbo(:, 1,22,10) = (/ &
        & 0.71578e-01_r8,0.16309e+00_r8,0.18609e+00_r8,0.19018e+00_r8,0.14217e+00_r8 /)
      kbo(:, 2,22,10) = (/ &
        & 0.76626e-01_r8,0.17564e+00_r8,0.19884e+00_r8,0.20398e+00_r8,0.15291e+00_r8 /)
      kbo(:, 3,22,10) = (/ &
        & 0.81885e-01_r8,0.18840e+00_r8,0.21309e+00_r8,0.21858e+00_r8,0.16461e+00_r8 /)
      kbo(:, 4,22,10) = (/ &
        & 0.87223e-01_r8,0.20113e+00_r8,0.22859e+00_r8,0.23430e+00_r8,0.17688e+00_r8 /)
      kbo(:, 5,22,10) = (/ &
        & 0.92500e-01_r8,0.21374e+00_r8,0.24532e+00_r8,0.25104e+00_r8,0.18976e+00_r8 /)
      kbo(:, 1,23,10) = (/ &
        & 0.62506e-01_r8,0.15298e+00_r8,0.17442e+00_r8,0.17913e+00_r8,0.13258e+00_r8 /)
      kbo(:, 2,23,10) = (/ &
        & 0.67194e-01_r8,0.16597e+00_r8,0.18829e+00_r8,0.19340e+00_r8,0.14391e+00_r8 /)
      kbo(:, 3,23,10) = (/ &
        & 0.72099e-01_r8,0.17922e+00_r8,0.20360e+00_r8,0.20869e+00_r8,0.15600e+00_r8 /)
      kbo(:, 4,23,10) = (/ &
        & 0.77023e-01_r8,0.19243e+00_r8,0.22032e+00_r8,0.22532e+00_r8,0.16873e+00_r8 /)
      kbo(:, 5,23,10) = (/ &
        & 0.81629e-01_r8,0.20537e+00_r8,0.23792e+00_r8,0.24291e+00_r8,0.18203e+00_r8 /)
      kbo(:, 1,24,10) = (/ &
        & 0.54705e-01_r8,0.14435e+00_r8,0.16539e+00_r8,0.17004e+00_r8,0.12479e+00_r8 /)
      kbo(:, 2,24,10) = (/ &
        & 0.59055e-01_r8,0.15781e+00_r8,0.18024e+00_r8,0.18505e+00_r8,0.13663e+00_r8 /)
      kbo(:, 3,24,10) = (/ &
        & 0.63456e-01_r8,0.17157e+00_r8,0.19662e+00_r8,0.20113e+00_r8,0.14915e+00_r8 /)
      kbo(:, 4,24,10) = (/ &
        & 0.67778e-01_r8,0.18520e+00_r8,0.21409e+00_r8,0.21860e+00_r8,0.16222e+00_r8 /)
      kbo(:, 5,24,10) = (/ &
        & 0.71741e-01_r8,0.19852e+00_r8,0.23252e+00_r8,0.23726e+00_r8,0.17594e+00_r8 /)
      kbo(:, 1,25,10) = (/ &
        & 0.47972e-01_r8,0.13725e+00_r8,0.15860e+00_r8,0.16297e+00_r8,0.11866e+00_r8 /)
      kbo(:, 2,25,10) = (/ &
        & 0.51893e-01_r8,0.15121e+00_r8,0.17443e+00_r8,0.17877e+00_r8,0.13085e+00_r8 /)
      kbo(:, 3,25,10) = (/ &
        & 0.55832e-01_r8,0.16535e+00_r8,0.19157e+00_r8,0.19578e+00_r8,0.14380e+00_r8 /)
      kbo(:, 4,25,10) = (/ &
        & 0.59570e-01_r8,0.17943e+00_r8,0.20993e+00_r8,0.21423e+00_r8,0.15728e+00_r8 /)
      kbo(:, 5,25,10) = (/ &
        & 0.62996e-01_r8,0.19323e+00_r8,0.22909e+00_r8,0.23401e+00_r8,0.17147e+00_r8 /)
      kbo(:, 1,26,10) = (/ &
        & 0.42166e-01_r8,0.13173e+00_r8,0.15395e+00_r8,0.15801e+00_r8,0.11401e+00_r8 /)
      kbo(:, 2,26,10) = (/ &
        & 0.45660e-01_r8,0.14616e+00_r8,0.17062e+00_r8,0.17468e+00_r8,0.12664e+00_r8 /)
      kbo(:, 3,26,10) = (/ &
        & 0.49079e-01_r8,0.16071e+00_r8,0.18859e+00_r8,0.19278e+00_r8,0.14002e+00_r8 /)
      kbo(:, 4,26,10) = (/ &
        & 0.52306e-01_r8,0.17521e+00_r8,0.20782e+00_r8,0.21223e+00_r8,0.15402e+00_r8 /)
      kbo(:, 5,26,10) = (/ &
        & 0.55285e-01_r8,0.18955e+00_r8,0.22765e+00_r8,0.23299e+00_r8,0.16864e+00_r8 /)
      kbo(:, 1,27,10) = (/ &
        & 0.37040e-01_r8,0.12755e+00_r8,0.15088e+00_r8,0.15474e+00_r8,0.11059e+00_r8 /)
      kbo(:, 2,27,10) = (/ &
        & 0.40121e-01_r8,0.14241e+00_r8,0.16845e+00_r8,0.17243e+00_r8,0.12369e+00_r8 /)
      kbo(:, 3,27,10) = (/ &
        & 0.43101e-01_r8,0.15742e+00_r8,0.18726e+00_r8,0.19156e+00_r8,0.13753e+00_r8 /)
      kbo(:, 4,27,10) = (/ &
        & 0.45931e-01_r8,0.17241e+00_r8,0.20722e+00_r8,0.21200e+00_r8,0.15204e+00_r8 /)
      kbo(:, 5,27,10) = (/ &
        & 0.48598e-01_r8,0.18733e+00_r8,0.22772e+00_r8,0.23361e+00_r8,0.16711e+00_r8 /)
      kbo(:, 1,28,10) = (/ &
        & 0.32582e-01_r8,0.12457e+00_r8,0.14931e+00_r8,0.15310e+00_r8,0.10829e+00_r8 /)
      kbo(:, 2,28,10) = (/ &
        & 0.35269e-01_r8,0.13987e+00_r8,0.16776e+00_r8,0.17185e+00_r8,0.12185e+00_r8 /)
      kbo(:, 3,28,10) = (/ &
        & 0.37905e-01_r8,0.15538e+00_r8,0.18740e+00_r8,0.19192e+00_r8,0.13621e+00_r8 /)
      kbo(:, 4,28,10) = (/ &
        & 0.40411e-01_r8,0.17101e+00_r8,0.20797e+00_r8,0.21319e+00_r8,0.15122e+00_r8 /)
      kbo(:, 5,28,10) = (/ &
        & 0.42843e-01_r8,0.18643e+00_r8,0.22906e+00_r8,0.23551e+00_r8,0.16683e+00_r8 /)
      kbo(:, 1,29,10) = (/ &
        & 0.28694e-01_r8,0.12285e+00_r8,0.14922e+00_r8,0.15309e+00_r8,0.10715e+00_r8 /)
      kbo(:, 2,29,10) = (/ &
        & 0.31078e-01_r8,0.13867e+00_r8,0.16851e+00_r8,0.17281e+00_r8,0.12115e+00_r8 /)
      kbo(:, 3,29,10) = (/ &
        & 0.33398e-01_r8,0.15475e+00_r8,0.18886e+00_r8,0.19373e+00_r8,0.13609e+00_r8 /)
      kbo(:, 4,29,10) = (/ &
        & 0.35655e-01_r8,0.17087e+00_r8,0.21002e+00_r8,0.21569e+00_r8,0.15161e+00_r8 /)
      kbo(:, 5,29,10) = (/ &
        & 0.37934e-01_r8,0.18672e+00_r8,0.23156e+00_r8,0.23855e+00_r8,0.16767e+00_r8 /)
      kbo(:, 1,30,10) = (/ &
        & 0.25318e-01_r8,0.12223e+00_r8,0.15038e+00_r8,0.15442e+00_r8,0.10692e+00_r8 /)
      kbo(:, 2,30,10) = (/ &
        & 0.27416e-01_r8,0.13863e+00_r8,0.17040e+00_r8,0.17493e+00_r8,0.12146e+00_r8 /)
      kbo(:, 3,30,10) = (/ &
        & 0.29487e-01_r8,0.15524e+00_r8,0.19136e+00_r8,0.19656e+00_r8,0.13693e+00_r8 /)
      kbo(:, 4,30,10) = (/ &
        & 0.31585e-01_r8,0.17178e+00_r8,0.21298e+00_r8,0.21911e+00_r8,0.15294e+00_r8 /)
      kbo(:, 5,30,10) = (/ &
        & 0.33743e-01_r8,0.18794e+00_r8,0.23489e+00_r8,0.24234e+00_r8,0.16937e+00_r8 /)
      kbo(:, 1,31,10) = (/ &
        & 0.22384e-01_r8,0.12276e+00_r8,0.15268e+00_r8,0.15694e+00_r8,0.10764e+00_r8 /)
      kbo(:, 2,31,10) = (/ &
        & 0.24241e-01_r8,0.13972e+00_r8,0.17333e+00_r8,0.17809e+00_r8,0.12275e+00_r8 /)
      kbo(:, 3,31,10) = (/ &
        & 0.26155e-01_r8,0.15678e+00_r8,0.19481e+00_r8,0.20028e+00_r8,0.13870e+00_r8 /)
      kbo(:, 4,31,10) = (/ &
        & 0.28119e-01_r8,0.17362e+00_r8,0.21675e+00_r8,0.22330e+00_r8,0.15510e+00_r8 /)
      kbo(:, 5,31,10) = (/ &
        & 0.30218e-01_r8,0.19000e+00_r8,0.23891e+00_r8,0.24680e+00_r8,0.17182e+00_r8 /)
      kbo(:, 1,32,10) = (/ &
        & 0.19818e-01_r8,0.12431e+00_r8,0.15590e+00_r8,0.16037e+00_r8,0.10919e+00_r8 /)
      kbo(:, 2,32,10) = (/ &
        & 0.21499e-01_r8,0.14174e+00_r8,0.17710e+00_r8,0.18207e+00_r8,0.12484e+00_r8 /)
      kbo(:, 3,32,10) = (/ &
        & 0.23289e-01_r8,0.15910e+00_r8,0.19892e+00_r8,0.20468e+00_r8,0.14116e+00_r8 /)
      kbo(:, 4,32,10) = (/ &
        & 0.25197e-01_r8,0.17612e+00_r8,0.22110e+00_r8,0.22808e+00_r8,0.15787e+00_r8 /)
      kbo(:, 5,32,10) = (/ &
        & 0.27257e-01_r8,0.19267e+00_r8,0.24341e+00_r8,0.25172e+00_r8,0.17483e+00_r8 /)
      kbo(:, 1,33,10) = (/ &
        & 0.17588e-01_r8,0.12670e+00_r8,0.15984e+00_r8,0.16448e+00_r8,0.11147e+00_r8 /)
      kbo(:, 2,33,10) = (/ &
        & 0.19157e-01_r8,0.14450e+00_r8,0.18143e+00_r8,0.18665e+00_r8,0.12758e+00_r8 /)
      kbo(:, 3,33,10) = (/ &
        & 0.20859e-01_r8,0.16204e+00_r8,0.20353e+00_r8,0.20957e+00_r8,0.14421e+00_r8 /)
      kbo(:, 4,33,10) = (/ &
        & 0.22735e-01_r8,0.17915e+00_r8,0.22585e+00_r8,0.23324e+00_r8,0.16113e+00_r8 /)
      kbo(:, 5,33,10) = (/ &
        & 0.24799e-01_r8,0.19574e+00_r8,0.24826e+00_r8,0.25697e+00_r8,0.17829e+00_r8 /)
      kbo(:, 1,34,10) = (/ &
        & 0.15617e-01_r8,0.12913e+00_r8,0.16354e+00_r8,0.16830e+00_r8,0.11378e+00_r8 /)
      kbo(:, 2,34,10) = (/ &
        & 0.17096e-01_r8,0.14716e+00_r8,0.18538e+00_r8,0.19084e+00_r8,0.13021e+00_r8 /)
      kbo(:, 3,34,10) = (/ &
        & 0.18753e-01_r8,0.16482e+00_r8,0.20769e+00_r8,0.21402e+00_r8,0.14705e+00_r8 /)
      kbo(:, 4,34,10) = (/ &
        & 0.20625e-01_r8,0.18194e+00_r8,0.23012e+00_r8,0.23784e+00_r8,0.16411e+00_r8 /)
      kbo(:, 5,34,10) = (/ &
        & 0.22709e-01_r8,0.19848e+00_r8,0.25256e+00_r8,0.26160e+00_r8,0.18143e+00_r8 /)
      kbo(:, 1,35,10) = (/ &
        & 0.13789e-01_r8,0.13026e+00_r8,0.16543e+00_r8,0.17032e+00_r8,0.11490e+00_r8 /)
      kbo(:, 2,35,10) = (/ &
        & 0.15216e-01_r8,0.14846e+00_r8,0.18743e+00_r8,0.19307e+00_r8,0.13153e+00_r8 /)
      kbo(:, 3,35,10) = (/ &
        & 0.16842e-01_r8,0.16621e+00_r8,0.20987e+00_r8,0.21641e+00_r8,0.14851e+00_r8 /)
      kbo(:, 4,35,10) = (/ &
        & 0.18686e-01_r8,0.18333e+00_r8,0.23239e+00_r8,0.24032e+00_r8,0.16565e+00_r8 /)
      kbo(:, 5,35,10) = (/ &
        & 0.20799e-01_r8,0.19983e+00_r8,0.25487e+00_r8,0.26409e+00_r8,0.18307e+00_r8 /)
      kbo(:, 1,36,10) = (/ &
        & 0.12099e-01_r8,0.12969e+00_r8,0.16517e+00_r8,0.17011e+00_r8,0.11448e+00_r8 /)
      kbo(:, 2,36,10) = (/ &
        & 0.13456e-01_r8,0.14803e+00_r8,0.18723e+00_r8,0.19293e+00_r8,0.13120e+00_r8 /)
      kbo(:, 3,36,10) = (/ &
        & 0.15032e-01_r8,0.16587e+00_r8,0.20973e+00_r8,0.21635e+00_r8,0.14826e+00_r8 /)
      kbo(:, 4,36,10) = (/ &
        & 0.16854e-01_r8,0.18305e+00_r8,0.23232e+00_r8,0.24032e+00_r8,0.16546e+00_r8 /)
      kbo(:, 5,36,10) = (/ &
        & 0.18993e-01_r8,0.19959e+00_r8,0.25485e+00_r8,0.26414e+00_r8,0.18292e+00_r8 /)
      kbo(:, 1,37,10) = (/ &
        & 0.10461e-01_r8,0.12652e+00_r8,0.16173e+00_r8,0.16663e+00_r8,0.11173e+00_r8 /)
      kbo(:, 2,37,10) = (/ &
        & 0.11729e-01_r8,0.14498e+00_r8,0.18379e+00_r8,0.18940e+00_r8,0.12844e+00_r8 /)
      kbo(:, 3,37,10) = (/ &
        & 0.13230e-01_r8,0.16298e+00_r8,0.20628e+00_r8,0.21278e+00_r8,0.14553e+00_r8 /)
      kbo(:, 4,37,10) = (/ &
        & 0.15005e-01_r8,0.18033e+00_r8,0.22891e+00_r8,0.23679e+00_r8,0.16275e+00_r8 /)
      kbo(:, 5,37,10) = (/ &
        & 0.17126e-01_r8,0.19699e+00_r8,0.25151e+00_r8,0.26065e+00_r8,0.18019e+00_r8 /)
      kbo(:, 1,38,10) = (/ &
        & 0.90496e-02_r8,0.12333e+00_r8,0.15823e+00_r8,0.16307e+00_r8,0.10897e+00_r8 /)
      kbo(:, 2,38,10) = (/ &
        & 0.10227e-01_r8,0.14188e+00_r8,0.18026e+00_r8,0.18578e+00_r8,0.12565e+00_r8 /)
      kbo(:, 3,38,10) = (/ &
        & 0.11665e-01_r8,0.16002e+00_r8,0.20273e+00_r8,0.20911e+00_r8,0.14274e+00_r8 /)
      kbo(:, 4,38,10) = (/ &
        & 0.13392e-01_r8,0.17754e+00_r8,0.22537e+00_r8,0.23309e+00_r8,0.15996e+00_r8 /)
      kbo(:, 5,38,10) = (/ &
        & 0.15506e-01_r8,0.19433e+00_r8,0.24804e+00_r8,0.25702e+00_r8,0.17741e+00_r8 /)
      kbo(:, 1,39,10) = (/ &
        & 0.78338e-02_r8,0.12027e+00_r8,0.15482e+00_r8,0.15961e+00_r8,0.10632e+00_r8 /)
      kbo(:, 2,39,10) = (/ &
        & 0.89378e-02_r8,0.13888e+00_r8,0.17682e+00_r8,0.18224e+00_r8,0.12295e+00_r8 /)
      kbo(:, 3,39,10) = (/ &
        & 0.10310e-01_r8,0.15714e+00_r8,0.19926e+00_r8,0.20553e+00_r8,0.14003e+00_r8 /)
      kbo(:, 4,39,10) = (/ &
        & 0.12002e-01_r8,0.17480e+00_r8,0.22192e+00_r8,0.22947e+00_r8,0.15725e+00_r8 /)
      kbo(:, 5,39,10) = (/ &
        & 0.14105e-01_r8,0.19172e+00_r8,0.24464e+00_r8,0.25344e+00_r8,0.17470e+00_r8 /)
      kbo(:, 1,40,10) = (/ &
        & 0.66914e-02_r8,0.11542e+00_r8,0.14925e+00_r8,0.15395e+00_r8,0.10210e+00_r8 /)
      kbo(:, 2,40,10) = (/ &
        & 0.77047e-02_r8,0.13403e+00_r8,0.17118e+00_r8,0.17643e+00_r8,0.11860e+00_r8 /)
      kbo(:, 3,40,10) = (/ &
        & 0.89835e-02_r8,0.15246e+00_r8,0.19353e+00_r8,0.19961e+00_r8,0.13564e+00_r8 /)
      kbo(:, 4,40,10) = (/ &
        & 0.10606e-01_r8,0.17030e+00_r8,0.21619e+00_r8,0.22340e+00_r8,0.15283e+00_r8 /)
      kbo(:, 5,40,10) = (/ &
        & 0.12648e-01_r8,0.18743e+00_r8,0.23893e+00_r8,0.24746e+00_r8,0.17023e+00_r8 /)
      kbo(:, 1,41,10) = (/ &
        & 0.57043e-02_r8,0.11041e+00_r8,0.14350e+00_r8,0.14812e+00_r8,0.97770e-01_r8 /)
      kbo(:, 2,41,10) = (/ &
        & 0.66329e-02_r8,0.12897e+00_r8,0.16532e+00_r8,0.17041e+00_r8,0.11409e+00_r8 /)
      kbo(:, 3,41,10) = (/ &
        & 0.78105e-02_r8,0.14755e+00_r8,0.18757e+00_r8,0.19344e+00_r8,0.13104e+00_r8 /)
      kbo(:, 4,41,10) = (/ &
        & 0.93536e-02_r8,0.16558e+00_r8,0.21020e+00_r8,0.21707e+00_r8,0.14824e+00_r8 /)
      kbo(:, 5,41,10) = (/ &
        & 0.11328e-01_r8,0.18290e+00_r8,0.23295e+00_r8,0.24119e+00_r8,0.16557e+00_r8 /)
      kbo(:, 1,42,10) = (/ &
        & 0.48607e-02_r8,0.10547e+00_r8,0.13783e+00_r8,0.14238e+00_r8,0.93542e-01_r8 /)
      kbo(:, 2,42,10) = (/ &
        & 0.56953e-02_r8,0.12396e+00_r8,0.15948e+00_r8,0.16442e+00_r8,0.10965e+00_r8 /)
      kbo(:, 3,42,10) = (/ &
        & 0.67857e-02_r8,0.14262e+00_r8,0.18165e+00_r8,0.18732e+00_r8,0.12648e+00_r8 /)
      kbo(:, 4,42,10) = (/ &
        & 0.82516e-02_r8,0.16083e+00_r8,0.20424e+00_r8,0.21080e+00_r8,0.14367e+00_r8 /)
      kbo(:, 5,42,10) = (/ &
        & 0.10149e-01_r8,0.17836e+00_r8,0.22696e+00_r8,0.23490e+00_r8,0.16095e+00_r8 /)
      kbo(:, 1,43,10) = (/ &
        & 0.40934e-02_r8,0.99600e-01_r8,0.13106e+00_r8,0.13554e+00_r8,0.88531e-01_r8 /)
      kbo(:, 2,43,10) = (/ &
        & 0.48473e-02_r8,0.11796e+00_r8,0.15249e+00_r8,0.15728e+00_r8,0.10438e+00_r8 /)
      kbo(:, 3,43,10) = (/ &
        & 0.58407e-02_r8,0.13665e+00_r8,0.17453e+00_r8,0.17995e+00_r8,0.12102e+00_r8 /)
      kbo(:, 4,43,10) = (/ &
        & 0.71922e-02_r8,0.15505e+00_r8,0.19702e+00_r8,0.20328e+00_r8,0.13817e+00_r8 /)
      kbo(:, 5,43,10) = (/ &
        & 0.89819e-02_r8,0.17282e+00_r8,0.21974e+00_r8,0.22722e+00_r8,0.15541e+00_r8 /)
      kbo(:, 1,44,10) = (/ &
        & 0.34279e-02_r8,0.93376e-01_r8,0.12386e+00_r8,0.12828e+00_r8,0.83256e-01_r8 /)
      kbo(:, 2,44,10) = (/ &
        & 0.40981e-02_r8,0.11153e+00_r8,0.14501e+00_r8,0.14969e+00_r8,0.98786e-01_r8 /)
      kbo(:, 3,44,10) = (/ &
        & 0.49801e-02_r8,0.13017e+00_r8,0.16691e+00_r8,0.17209e+00_r8,0.11523e+00_r8 /)
      kbo(:, 4,44,10) = (/ &
        & 0.62140e-02_r8,0.14877e+00_r8,0.18924e+00_r8,0.19525e+00_r8,0.13223e+00_r8 /)
      kbo(:, 5,44,10) = (/ &
        & 0.78865e-02_r8,0.16678e+00_r8,0.21196e+00_r8,0.21896e+00_r8,0.14947e+00_r8 /)
      kbo(:, 1,45,10) = (/ &
        & 0.28724e-02_r8,0.87295e-01_r8,0.11671e+00_r8,0.12114e+00_r8,0.78089e-01_r8 /)
      kbo(:, 2,45,10) = (/ &
        & 0.34468e-02_r8,0.10517e+00_r8,0.13765e+00_r8,0.14225e+00_r8,0.93322e-01_r8 /)
      kbo(:, 3,45,10) = (/ &
        & 0.42450e-02_r8,0.12371e+00_r8,0.15937e+00_r8,0.16431e+00_r8,0.10950e+00_r8 /)
      kbo(:, 4,45,10) = (/ &
        & 0.53608e-02_r8,0.14242e+00_r8,0.18156e+00_r8,0.18727e+00_r8,0.12633e+00_r8 /)
      kbo(:, 5,45,10) = (/ &
        & 0.69069e-02_r8,0.16067e+00_r8,0.20420e+00_r8,0.21079e+00_r8,0.14356e+00_r8 /)
      kbo(:, 1,46,10) = (/ &
        & 0.23836e-02_r8,0.81023e-01_r8,0.10917e+00_r8,0.11375e+00_r8,0.72722e-01_r8 /)
      kbo(:, 2,46,10) = (/ &
        & 0.28929e-02_r8,0.98528e-01_r8,0.12997e+00_r8,0.13446e+00_r8,0.87653e-01_r8 /)
      kbo(:, 3,46,10) = (/ &
        & 0.35850e-02_r8,0.11690e+00_r8,0.15139e+00_r8,0.15617e+00_r8,0.10350e+00_r8 /)
      kbo(:, 4,46,10) = (/ &
        & 0.45850e-02_r8,0.13564e+00_r8,0.17345e+00_r8,0.17887e+00_r8,0.12014e+00_r8 /)
      kbo(:, 5,46,10) = (/ &
        & 0.59899e-02_r8,0.15409e+00_r8,0.19595e+00_r8,0.20220e+00_r8,0.13729e+00_r8 /)
      kbo(:, 1,47,10) = (/ &
        & 0.19470e-02_r8,0.74238e-01_r8,0.10082e+00_r8,0.10569e+00_r8,0.66936e-01_r8 /)
      kbo(:, 2,47,10) = (/ &
        & 0.23890e-02_r8,0.91244e-01_r8,0.12148e+00_r8,0.12591e+00_r8,0.81479e-01_r8 /)
      kbo(:, 3,47,10) = (/ &
        & 0.29827e-02_r8,0.10934e+00_r8,0.14258e+00_r8,0.14724e+00_r8,0.96940e-01_r8 /)
      kbo(:, 4,47,10) = (/ &
        & 0.38583e-02_r8,0.12800e+00_r8,0.16447e+00_r8,0.16958e+00_r8,0.11333e+00_r8 /)
      kbo(:, 5,47,10) = (/ &
        & 0.51142e-02_r8,0.14666e+00_r8,0.18678e+00_r8,0.19270e+00_r8,0.13028e+00_r8 /)
      kbo(:, 1,48,10) = (/ &
        & 0.15861e-02_r8,0.67739e-01_r8,0.92637e-01_r8,0.97854e-01_r8,0.61349e-01_r8 /)
      kbo(:, 2,48,10) = (/ &
        & 0.19649e-02_r8,0.84157e-01_r8,0.11305e+00_r8,0.11755e+00_r8,0.75432e-01_r8 /)
      kbo(:, 3,48,10) = (/ &
        & 0.24852e-02_r8,0.10189e+00_r8,0.13395e+00_r8,0.13849e+00_r8,0.90556e-01_r8 /)
      kbo(:, 4,48,10) = (/ &
        & 0.32371e-02_r8,0.12039e+00_r8,0.15554e+00_r8,0.16041e+00_r8,0.10658e+00_r8 /)
      kbo(:, 5,48,10) = (/ &
        & 0.43439e-02_r8,0.13914e+00_r8,0.17770e+00_r8,0.18327e+00_r8,0.12334e+00_r8 /)
      kbo(:, 1,49,10) = (/ &
        & 0.12857e-02_r8,0.61441e-01_r8,0.84638e-01_r8,0.90184e-01_r8,0.55928e-01_r8 /)
      kbo(:, 2,49,10) = (/ &
        & 0.16127e-02_r8,0.77337e-01_r8,0.10472e+00_r8,0.10945e+00_r8,0.69577e-01_r8 /)
      kbo(:, 3,49,10) = (/ &
        & 0.20537e-02_r8,0.94575e-01_r8,0.12545e+00_r8,0.12989e+00_r8,0.84331e-01_r8 /)
      kbo(:, 4,49,10) = (/ &
        & 0.26910e-02_r8,0.11284e+00_r8,0.14670e+00_r8,0.15143e+00_r8,0.99981e-01_r8 /)
      kbo(:, 5,49,10) = (/ &
        & 0.36640e-02_r8,0.13156e+00_r8,0.16870e+00_r8,0.17395e+00_r8,0.11651e+00_r8 /)
      kbo(:, 1,50,10) = (/ &
        & 0.10457e-02_r8,0.55773e-01_r8,0.77388e-01_r8,0.83215e-01_r8,0.51035e-01_r8 /)
      kbo(:, 2,50,10) = (/ &
        & 0.13145e-02_r8,0.71139e-01_r8,0.96987e-01_r8,0.10202e+00_r8,0.64279e-01_r8 /)
      kbo(:, 3,50,10) = (/ &
        & 0.17051e-02_r8,0.87902e-01_r8,0.11756e+00_r8,0.12199e+00_r8,0.78626e-01_r8 /)
      kbo(:, 4,50,10) = (/ &
        & 0.22648e-02_r8,0.10582e+00_r8,0.13854e+00_r8,0.14317e+00_r8,0.93933e-01_r8 /)
      kbo(:, 5,50,10) = (/ &
        & 0.31061e-02_r8,0.12442e+00_r8,0.16033e+00_r8,0.16532e+00_r8,0.11017e+00_r8 /)
      kbo(:, 1,51,10) = (/ &
        & 0.84549e-03_r8,0.50472e-01_r8,0.70528e-01_r8,0.76615e-01_r8,0.46420e-01_r8 /)
      kbo(:, 2,51,10) = (/ &
        & 0.10690e-02_r8,0.65329e-01_r8,0.89631e-01_r8,0.94967e-01_r8,0.59271e-01_r8 /)
      kbo(:, 3,51,10) = (/ &
        & 0.14006e-02_r8,0.81572e-01_r8,0.10994e+00_r8,0.11450e+00_r8,0.73207e-01_r8 /)
      kbo(:, 4,51,10) = (/ &
        & 0.18893e-02_r8,0.99123e-01_r8,0.13077e+00_r8,0.13529e+00_r8,0.88203e-01_r8 /)
      kbo(:, 5,51,10) = (/ &
        & 0.26211e-02_r8,0.11756e+00_r8,0.15226e+00_r8,0.15707e+00_r8,0.10410e+00_r8 /)
      kbo(:, 1,52,10) = (/ &
        & 0.67948e-03_r8,0.45452e-01_r8,0.63925e-01_r8,0.70191e-01_r8,0.41984e-01_r8 /)
      kbo(:, 2,52,10) = (/ &
        & 0.86532e-03_r8,0.59697e-01_r8,0.82454e-01_r8,0.88085e-01_r8,0.54427e-01_r8 /)
      kbo(:, 3,52,10) = (/ &
        & 0.11431e-02_r8,0.75434e-01_r8,0.10239e+00_r8,0.10721e+00_r8,0.67964e-01_r8 /)
      kbo(:, 4,52,10) = (/ &
        & 0.15771e-02_r8,0.92585e-01_r8,0.12313e+00_r8,0.12757e+00_r8,0.82618e-01_r8 /)
      kbo(:, 5,52,10) = (/ &
        & 0.22169e-02_r8,0.11074e+00_r8,0.14429e+00_r8,0.14899e+00_r8,0.98166e-01_r8 /)
      kbo(:, 1,53,10) = (/ &
        & 0.54404e-03_r8,0.40689e-01_r8,0.57565e-01_r8,0.63870e-01_r8,0.37709e-01_r8 /)
      kbo(:, 2,53,10) = (/ &
        & 0.69516e-03_r8,0.54249e-01_r8,0.75469e-01_r8,0.81366e-01_r8,0.49728e-01_r8 /)
      kbo(:, 3,53,10) = (/ &
        & 0.92495e-03_r8,0.69505e-01_r8,0.94951e-01_r8,0.10007e+00_r8,0.62880e-01_r8 /)
      kbo(:, 4,53,10) = (/ &
        & 0.12935e-02_r8,0.86139e-01_r8,0.11548e+00_r8,0.11993e+00_r8,0.77126e-01_r8 /)
      kbo(:, 5,53,10) = (/ &
        & 0.18603e-02_r8,0.10397e+00_r8,0.13641e+00_r8,0.14102e+00_r8,0.92352e-01_r8 /)
      kbo(:, 1,54,10) = (/ &
        & 0.43618e-03_r8,0.36557e-01_r8,0.51984e-01_r8,0.58236e-01_r8,0.33960e-01_r8 /)
      kbo(:, 2,54,10) = (/ &
        & 0.56166e-03_r8,0.49456e-01_r8,0.69241e-01_r8,0.75371e-01_r8,0.45540e-01_r8 /)
      kbo(:, 3,54,10) = (/ &
        & 0.75035e-03_r8,0.64217e-01_r8,0.88252e-01_r8,0.93648e-01_r8,0.58325e-01_r8 /)
      kbo(:, 4,54,10) = (/ &
        & 0.10628e-02_r8,0.80385e-01_r8,0.10853e+00_r8,0.11313e+00_r8,0.72201e-01_r8 /)
      kbo(:, 5,54,10) = (/ &
        & 0.15600e-02_r8,0.97867e-01_r8,0.12933e+00_r8,0.13384e+00_r8,0.87138e-01_r8 /)
      kbo(:, 1,55,10) = (/ &
        & 0.34930e-03_r8,0.32793e-01_r8,0.46881e-01_r8,0.52981e-01_r8,0.30517e-01_r8 /)
      kbo(:, 2,55,10) = (/ &
        & 0.45330e-03_r8,0.45087e-01_r8,0.63469e-01_r8,0.69744e-01_r8,0.41669e-01_r8 /)
      kbo(:, 3,55,10) = (/ &
        & 0.61016e-03_r8,0.59300e-01_r8,0.81969e-01_r8,0.87622e-01_r8,0.54097e-01_r8 /)
      kbo(:, 4,55,10) = (/ &
        & 0.87186e-03_r8,0.75017e-01_r8,0.10190e+00_r8,0.10674e+00_r8,0.67613e-01_r8 /)
      kbo(:, 5,55,10) = (/ &
        & 0.13255e-02_r8,0.92144e-01_r8,0.12263e+00_r8,0.12707e+00_r8,0.82251e-01_r8 /)
      kbo(:, 1,56,10) = (/ &
        & 0.27869e-03_r8,0.29255e-01_r8,0.42021e-01_r8,0.47895e-01_r8,0.27250e-01_r8 /)
      kbo(:, 2,56,10) = (/ &
        & 0.36450e-03_r8,0.40920e-01_r8,0.57903e-01_r8,0.64209e-01_r8,0.37931e-01_r8 /)
      kbo(:, 3,56,10) = (/ &
        & 0.49136e-03_r8,0.54534e-01_r8,0.75862e-01_r8,0.81747e-01_r8,0.49990e-01_r8 /)
      kbo(:, 4,56,10) = (/ &
        & 0.71172e-03_r8,0.69828e-01_r8,0.95390e-01_r8,0.10049e+00_r8,0.63168e-01_r8 /)
      kbo(:, 5,56,10) = (/ &
        & 0.11017e-02_r8,0.86502e-01_r8,0.11594e+00_r8,0.12039e+00_r8,0.77442e-01_r8 /)
      kbo(:, 1,57,10) = (/ &
        & 0.22107e-03_r8,0.25925e-01_r8,0.37436e-01_r8,0.42992e-01_r8,0.24134e-01_r8 /)
      kbo(:, 2,57,10) = (/ &
        & 0.29170e-03_r8,0.36963e-01_r8,0.52553e-01_r8,0.58819e-01_r8,0.34341e-01_r8 /)
      kbo(:, 3,57,10) = (/ &
        & 0.39477e-03_r8,0.49943e-01_r8,0.69900e-01_r8,0.76011e-01_r8,0.45979e-01_r8 /)
      kbo(:, 4,57,10) = (/ &
        & 0.57598e-03_r8,0.64771e-01_r8,0.88986e-01_r8,0.94351e-01_r8,0.58814e-01_r8 /)
      kbo(:, 5,57,10) = (/ &
        & 0.90995e-03_r8,0.80998e-01_r8,0.10929e+00_r8,0.11387e+00_r8,0.72731e-01_r8 /)
      kbo(:, 1,58,10) = (/ &
        & 0.17561e-03_r8,0.22952e-01_r8,0.33334e-01_r8,0.38531e-01_r8,0.21328e-01_r8 /)
      kbo(:, 2,58,10) = (/ &
        & 0.23328e-03_r8,0.33378e-01_r8,0.47700e-01_r8,0.53835e-01_r8,0.31067e-01_r8 /)
      kbo(:, 3,58,10) = (/ &
        & 0.31697e-03_r8,0.45784e-01_r8,0.64416e-01_r8,0.70683e-01_r8,0.42303e-01_r8 /)
      kbo(:, 4,58,10) = (/ &
        & 0.46537e-03_r8,0.60108e-01_r8,0.83029e-01_r8,0.88636e-01_r8,0.54797e-01_r8 /)
      kbo(:, 5,58,10) = (/ &
        & 0.74786e-03_r8,0.75908e-01_r8,0.10302e+00_r8,0.10782e+00_r8,0.68377e-01_r8 /)
      kbo(:, 1,59,10) = (/ &
        & 0.14648e-03_r8,0.21806e-01_r8,0.31752e-01_r8,0.36796e-01_r8,0.20240e-01_r8 /)
      kbo(:, 2,59,10) = (/ &
        & 0.19618e-03_r8,0.31995e-01_r8,0.45805e-01_r8,0.51875e-01_r8,0.29797e-01_r8 /)
      kbo(:, 3,59,10) = (/ &
        & 0.27063e-03_r8,0.44166e-01_r8,0.62268e-01_r8,0.68564e-01_r8,0.40859e-01_r8 /)
      kbo(:, 4,59,10) = (/ &
        & 0.40629e-03_r8,0.58271e-01_r8,0.80681e-01_r8,0.86380e-01_r8,0.53223e-01_r8 /)
      kbo(:, 5,59,10) = (/ &
        & 0.67143e-03_r8,0.73904e-01_r8,0.10053e+00_r8,0.10542e+00_r8,0.66665e-01_r8 /)
      kbo(:, 1,13,11) = (/ &
        & 0.43607e+00_r8,0.62808e+00_r8,0.71724e+00_r8,0.73315e+00_r8,0.60101e+00_r8 /)
      kbo(:, 2,13,11) = (/ &
        & 0.43332e+00_r8,0.62604e+00_r8,0.71980e+00_r8,0.74002e+00_r8,0.61186e+00_r8 /)
      kbo(:, 3,13,11) = (/ &
        & 0.43924e+00_r8,0.62431e+00_r8,0.72116e+00_r8,0.74635e+00_r8,0.62343e+00_r8 /)
      kbo(:, 4,13,11) = (/ &
        & 0.44984e+00_r8,0.62482e+00_r8,0.72168e+00_r8,0.75298e+00_r8,0.63261e+00_r8 /)
      kbo(:, 5,13,11) = (/ &
        & 0.46047e+00_r8,0.63112e+00_r8,0.72222e+00_r8,0.75987e+00_r8,0.64021e+00_r8 /)
      kbo(:, 1,14,11) = (/ &
        & 0.38105e+00_r8,0.57533e+00_r8,0.67001e+00_r8,0.68808e+00_r8,0.55899e+00_r8 /)
      kbo(:, 2,14,11) = (/ &
        & 0.38509e+00_r8,0.57518e+00_r8,0.67285e+00_r8,0.69660e+00_r8,0.57227e+00_r8 /)
      kbo(:, 3,14,11) = (/ &
        & 0.39449e+00_r8,0.57649e+00_r8,0.67532e+00_r8,0.70510e+00_r8,0.58361e+00_r8 /)
      kbo(:, 4,14,11) = (/ &
        & 0.40382e+00_r8,0.58297e+00_r8,0.67784e+00_r8,0.71417e+00_r8,0.59305e+00_r8 /)
      kbo(:, 5,14,11) = (/ &
        & 0.41367e+00_r8,0.59430e+00_r8,0.68136e+00_r8,0.72200e+00_r8,0.60202e+00_r8 /)
      kbo(:, 1,15,11) = (/ &
        & 0.33634e+00_r8,0.52577e+00_r8,0.62172e+00_r8,0.64383e+00_r8,0.51752e+00_r8 /)
      kbo(:, 2,15,11) = (/ &
        & 0.34434e+00_r8,0.52795e+00_r8,0.62601e+00_r8,0.65389e+00_r8,0.53138e+00_r8 /)
      kbo(:, 3,15,11) = (/ &
        & 0.35278e+00_r8,0.53440e+00_r8,0.63064e+00_r8,0.66483e+00_r8,0.54288e+00_r8 /)
      kbo(:, 4,15,11) = (/ &
        & 0.36194e+00_r8,0.54564e+00_r8,0.63643e+00_r8,0.67473e+00_r8,0.55371e+00_r8 /)
      kbo(:, 5,15,11) = (/ &
        & 0.37392e+00_r8,0.55836e+00_r8,0.64562e+00_r8,0.68317e+00_r8,0.56497e+00_r8 /)
      kbo(:, 1,16,11) = (/ &
        & 0.29938e+00_r8,0.48063e+00_r8,0.57442e+00_r8,0.60090e+00_r8,0.47563e+00_r8 /)
      kbo(:, 2,16,11) = (/ &
        & 0.30677e+00_r8,0.48684e+00_r8,0.58100e+00_r8,0.61362e+00_r8,0.49008e+00_r8 /)
      kbo(:, 3,16,11) = (/ &
        & 0.31495e+00_r8,0.49797e+00_r8,0.58852e+00_r8,0.62578e+00_r8,0.50309e+00_r8 /)
      kbo(:, 4,16,11) = (/ &
        & 0.32635e+00_r8,0.51101e+00_r8,0.59933e+00_r8,0.63613e+00_r8,0.51641e+00_r8 /)
      kbo(:, 5,16,11) = (/ &
        & 0.34098e+00_r8,0.52383e+00_r8,0.61318e+00_r8,0.64534e+00_r8,0.52976e+00_r8 /)
      kbo(:, 1,17,11) = (/ &
        & 0.26573e+00_r8,0.44123e+00_r8,0.53003e+00_r8,0.56054e+00_r8,0.43533e+00_r8 /)
      kbo(:, 2,17,11) = (/ &
        & 0.27295e+00_r8,0.45155e+00_r8,0.53872e+00_r8,0.57479e+00_r8,0.45023e+00_r8 /)
      kbo(:, 3,17,11) = (/ &
        & 0.28334e+00_r8,0.46499e+00_r8,0.55060e+00_r8,0.58775e+00_r8,0.46535e+00_r8 /)
      kbo(:, 4,17,11) = (/ &
        & 0.29718e+00_r8,0.47854e+00_r8,0.56610e+00_r8,0.59925e+00_r8,0.48105e+00_r8 /)
      kbo(:, 5,17,11) = (/ &
        & 0.31347e+00_r8,0.49215e+00_r8,0.58364e+00_r8,0.61031e+00_r8,0.49645e+00_r8 /)
      kbo(:, 1,18,11) = (/ &
        & 0.23548e+00_r8,0.40722e+00_r8,0.48899e+00_r8,0.52175e+00_r8,0.39754e+00_r8 /)
      kbo(:, 2,18,11) = (/ &
        & 0.24465e+00_r8,0.42091e+00_r8,0.50155e+00_r8,0.53754e+00_r8,0.41400e+00_r8 /)
      kbo(:, 3,18,11) = (/ &
        & 0.25717e+00_r8,0.43494e+00_r8,0.51756e+00_r8,0.55168e+00_r8,0.43132e+00_r8 /)
      kbo(:, 4,18,11) = (/ &
        & 0.27241e+00_r8,0.44915e+00_r8,0.53619e+00_r8,0.56524e+00_r8,0.44875e+00_r8 /)
      kbo(:, 5,18,11) = (/ &
        & 0.28792e+00_r8,0.46398e+00_r8,0.55551e+00_r8,0.57930e+00_r8,0.46590e+00_r8 /)
      kbo(:, 1,19,11) = (/ &
        & 0.20944e+00_r8,0.37826e+00_r8,0.45234e+00_r8,0.48406e+00_r8,0.36392e+00_r8 /)
      kbo(:, 2,19,11) = (/ &
        & 0.22089e+00_r8,0.39288e+00_r8,0.46903e+00_r8,0.50178e+00_r8,0.38211e+00_r8 /)
      kbo(:, 3,19,11) = (/ &
        & 0.23514e+00_r8,0.40761e+00_r8,0.48827e+00_r8,0.51821e+00_r8,0.40103e+00_r8 /)
      kbo(:, 4,19,11) = (/ &
        & 0.24973e+00_r8,0.42303e+00_r8,0.50894e+00_r8,0.53472e+00_r8,0.42003e+00_r8 /)
      kbo(:, 5,19,11) = (/ &
        & 0.26400e+00_r8,0.44033e+00_r8,0.52950e+00_r8,0.55236e+00_r8,0.43892e+00_r8 /)
      kbo(:, 1,20,11) = (/ &
        & 0.18773e+00_r8,0.35288e+00_r8,0.42094e+00_r8,0.44918e+00_r8,0.33536e+00_r8 /)
      kbo(:, 2,20,11) = (/ &
        & 0.20090e+00_r8,0.36792e+00_r8,0.44069e+00_r8,0.46887e+00_r8,0.35493e+00_r8 /)
      kbo(:, 3,20,11) = (/ &
        & 0.21482e+00_r8,0.38362e+00_r8,0.46266e+00_r8,0.48831e+00_r8,0.37530e+00_r8 /)
      kbo(:, 4,20,11) = (/ &
        & 0.22865e+00_r8,0.40117e+00_r8,0.48452e+00_r8,0.50881e+00_r8,0.39557e+00_r8 /)
      kbo(:, 5,20,11) = (/ &
        & 0.24234e+00_r8,0.42087e+00_r8,0.50657e+00_r8,0.53012e+00_r8,0.41595e+00_r8 /)
      kbo(:, 1,21,11) = (/ &
        & 0.16913e+00_r8,0.33019e+00_r8,0.39388e+00_r8,0.41795e+00_r8,0.31127e+00_r8 /)
      kbo(:, 2,21,11) = (/ &
        & 0.18253e+00_r8,0.34600e+00_r8,0.41645e+00_r8,0.43947e+00_r8,0.33210e+00_r8 /)
      kbo(:, 3,21,11) = (/ &
        & 0.19592e+00_r8,0.36350e+00_r8,0.43977e+00_r8,0.46279e+00_r8,0.35347e+00_r8 /)
      kbo(:, 4,21,11) = (/ &
        & 0.20921e+00_r8,0.38317e+00_r8,0.46337e+00_r8,0.48719e+00_r8,0.37483e+00_r8 /)
      kbo(:, 5,21,11) = (/ &
        & 0.22258e+00_r8,0.40476e+00_r8,0.48708e+00_r8,0.51206e+00_r8,0.39691e+00_r8 /)
      kbo(:, 1,22,11) = (/ &
        & 0.15329e+00_r8,0.31121e+00_r8,0.37219e+00_r8,0.39211e+00_r8,0.29266e+00_r8 /)
      kbo(:, 2,22,11) = (/ &
        & 0.16615e+00_r8,0.32878e+00_r8,0.39682e+00_r8,0.41672e+00_r8,0.31445e+00_r8 /)
      kbo(:, 3,22,11) = (/ &
        & 0.17924e+00_r8,0.34835e+00_r8,0.42167e+00_r8,0.44342e+00_r8,0.33660e+00_r8 /)
      kbo(:, 4,22,11) = (/ &
        & 0.19225e+00_r8,0.36990e+00_r8,0.44699e+00_r8,0.47133e+00_r8,0.35944e+00_r8 /)
      kbo(:, 5,22,11) = (/ &
        & 0.20541e+00_r8,0.39323e+00_r8,0.47271e+00_r8,0.49943e+00_r8,0.38308e+00_r8 /)
      kbo(:, 1,23,11) = (/ &
        & 0.13887e+00_r8,0.29534e+00_r8,0.35451e+00_r8,0.37144e+00_r8,0.27763e+00_r8 /)
      kbo(:, 2,23,11) = (/ &
        & 0.15131e+00_r8,0.31502e+00_r8,0.38068e+00_r8,0.39927e+00_r8,0.30013e+00_r8 /)
      kbo(:, 3,23,11) = (/ &
        & 0.16398e+00_r8,0.33651e+00_r8,0.40726e+00_r8,0.42913e+00_r8,0.32331e+00_r8 /)
      kbo(:, 4,23,11) = (/ &
        & 0.17699e+00_r8,0.35967e+00_r8,0.43436e+00_r8,0.45990e+00_r8,0.34758e+00_r8 /)
      kbo(:, 5,23,11) = (/ &
        & 0.19026e+00_r8,0.38467e+00_r8,0.46223e+00_r8,0.49074e+00_r8,0.37282e+00_r8 /)
      kbo(:, 1,24,11) = (/ &
        & 0.12585e+00_r8,0.28281e+00_r8,0.34015e+00_r8,0.35619e+00_r8,0.26580e+00_r8 /)
      kbo(:, 2,24,11) = (/ &
        & 0.13791e+00_r8,0.30436e+00_r8,0.36812e+00_r8,0.38675e+00_r8,0.28903e+00_r8 /)
      kbo(:, 3,24,11) = (/ &
        & 0.15049e+00_r8,0.32769e+00_r8,0.39648e+00_r8,0.41925e+00_r8,0.31342e+00_r8 /)
      kbo(:, 4,24,11) = (/ &
        & 0.16367e+00_r8,0.35256e+00_r8,0.42575e+00_r8,0.45270e+00_r8,0.33923e+00_r8 /)
      kbo(:, 5,24,11) = (/ &
        & 0.17705e+00_r8,0.37855e+00_r8,0.45558e+00_r8,0.48562e+00_r8,0.36598e+00_r8 /)
      kbo(:, 1,25,11) = (/ &
        & 0.11440e+00_r8,0.27340e+00_r8,0.32939e+00_r8,0.34570e+00_r8,0.25676e+00_r8 /)
      kbo(:, 2,25,11) = (/ &
        & 0.12619e+00_r8,0.29667e+00_r8,0.35918e+00_r8,0.37882e+00_r8,0.28103e+00_r8 /)
      kbo(:, 3,25,11) = (/ &
        & 0.13880e+00_r8,0.32182e+00_r8,0.38965e+00_r8,0.41370e+00_r8,0.30678e+00_r8 /)
      kbo(:, 4,25,11) = (/ &
        & 0.15209e+00_r8,0.34806e+00_r8,0.42076e+00_r8,0.44907e+00_r8,0.33404e+00_r8 /)
      kbo(:, 5,25,11) = (/ &
        & 0.16564e+00_r8,0.37478e+00_r8,0.45238e+00_r8,0.48364e+00_r8,0.36209e+00_r8 /)
      kbo(:, 1,26,11) = (/ &
        & 0.10459e+00_r8,0.26698e+00_r8,0.32246e+00_r8,0.33976e+00_r8,0.25076e+00_r8 /)
      kbo(:, 2,26,11) = (/ &
        & 0.11626e+00_r8,0.29209e+00_r8,0.35422e+00_r8,0.37512e+00_r8,0.27618e+00_r8 /)
      kbo(:, 3,26,11) = (/ &
        & 0.12895e+00_r8,0.31885e+00_r8,0.38669e+00_r8,0.41203e+00_r8,0.30332e+00_r8 /)
      kbo(:, 4,26,11) = (/ &
        & 0.14230e+00_r8,0.34607e+00_r8,0.41933e+00_r8,0.44889e+00_r8,0.33190e+00_r8 /)
      kbo(:, 5,26,11) = (/ &
        & 0.15605e+00_r8,0.37346e+00_r8,0.45243e+00_r8,0.48462e+00_r8,0.36103e+00_r8 /)
      kbo(:, 1,27,11) = (/ &
        & 0.96118e-01_r8,0.26319e+00_r8,0.31888e+00_r8,0.33748e+00_r8,0.24718e+00_r8 /)
      kbo(:, 2,27,11) = (/ &
        & 0.10777e+00_r8,0.29006e+00_r8,0.35247e+00_r8,0.37471e+00_r8,0.27379e+00_r8 /)
      kbo(:, 3,27,11) = (/ &
        & 0.12054e+00_r8,0.31789e+00_r8,0.38657e+00_r8,0.41315e+00_r8,0.30239e+00_r8 /)
      kbo(:, 4,27,11) = (/ &
        & 0.13403e+00_r8,0.34597e+00_r8,0.42050e+00_r8,0.45108e+00_r8,0.33196e+00_r8 /)
      kbo(:, 5,27,11) = (/ &
        & 0.14803e+00_r8,0.37409e+00_r8,0.45469e+00_r8,0.48753e+00_r8,0.36202e+00_r8 /)
      kbo(:, 1,28,11) = (/ &
        & 0.88934e-01_r8,0.26189e+00_r8,0.31824e+00_r8,0.33815e+00_r8,0.24575e+00_r8 /)
      kbo(:, 2,28,11) = (/ &
        & 0.10066e+00_r8,0.29004e+00_r8,0.35339e+00_r8,0.37699e+00_r8,0.27368e+00_r8 /)
      kbo(:, 3,28,11) = (/ &
        & 0.11346e+00_r8,0.31878e+00_r8,0.38868e+00_r8,0.41646e+00_r8,0.30334e+00_r8 /)
      kbo(:, 4,28,11) = (/ &
        & 0.12719e+00_r8,0.34746e+00_r8,0.42368e+00_r8,0.45510e+00_r8,0.33384e+00_r8 /)
      kbo(:, 5,28,11) = (/ &
        & 0.14149e+00_r8,0.37622e+00_r8,0.45856e+00_r8,0.49189e+00_r8,0.36458e+00_r8 /)
      kbo(:, 1,29,11) = (/ &
        & 0.82953e-01_r8,0.26276e+00_r8,0.32032e+00_r8,0.34153e+00_r8,0.24649e+00_r8 /)
      kbo(:, 2,29,11) = (/ &
        & 0.94812e-01_r8,0.29186e+00_r8,0.35678e+00_r8,0.38153e+00_r8,0.27563e+00_r8 /)
      kbo(:, 3,29,11) = (/ &
        & 0.10778e+00_r8,0.32138e+00_r8,0.39278e+00_r8,0.42163e+00_r8,0.30623e+00_r8 /)
      kbo(:, 4,29,11) = (/ &
        & 0.12182e+00_r8,0.35053e+00_r8,0.42853e+00_r8,0.46064e+00_r8,0.33743e+00_r8 /)
      kbo(:, 5,29,11) = (/ &
        & 0.13655e+00_r8,0.37990e+00_r8,0.46387e+00_r8,0.49754e+00_r8,0.36866e+00_r8 /)
      kbo(:, 1,30,11) = (/ &
        & 0.78111e-01_r8,0.26530e+00_r8,0.32451e+00_r8,0.34680e+00_r8,0.24893e+00_r8 /)
      kbo(:, 2,30,11) = (/ &
        & 0.90075e-01_r8,0.29517e+00_r8,0.36183e+00_r8,0.38763e+00_r8,0.27915e+00_r8 /)
      kbo(:, 3,30,11) = (/ &
        & 0.10336e+00_r8,0.32522e+00_r8,0.39838e+00_r8,0.42809e+00_r8,0.31046e+00_r8 /)
      kbo(:, 4,30,11) = (/ &
        & 0.11787e+00_r8,0.35483e+00_r8,0.43455e+00_r8,0.46718e+00_r8,0.34218e+00_r8 /)
      kbo(:, 5,30,11) = (/ &
        & 0.13307e+00_r8,0.38452e+00_r8,0.47003e+00_r8,0.50395e+00_r8,0.37368e+00_r8 /)
      kbo(:, 1,31,11) = (/ &
        & 0.74235e-01_r8,0.26927e+00_r8,0.33033e+00_r8,0.35368e+00_r8,0.25294e+00_r8 /)
      kbo(:, 2,31,11) = (/ &
        & 0.86475e-01_r8,0.29980e+00_r8,0.36814e+00_r8,0.39505e+00_r8,0.28398e+00_r8 /)
      kbo(:, 3,31,11) = (/ &
        & 0.10025e+00_r8,0.33020e+00_r8,0.40500e+00_r8,0.43563e+00_r8,0.31586e+00_r8 /)
      kbo(:, 4,31,11) = (/ &
        & 0.11530e+00_r8,0.36008e+00_r8,0.44151e+00_r8,0.47461e+00_r8,0.34790e+00_r8 /)
      kbo(:, 5,31,11) = (/ &
        & 0.13103e+00_r8,0.38989e+00_r8,0.47695e+00_r8,0.51108e+00_r8,0.37953e+00_r8 /)
      kbo(:, 1,32,11) = (/ &
        & 0.71362e-01_r8,0.27445e+00_r8,0.33748e+00_r8,0.36171e+00_r8,0.25820e+00_r8 /)
      kbo(:, 2,32,11) = (/ &
        & 0.84060e-01_r8,0.30547e+00_r8,0.37545e+00_r8,0.40335e+00_r8,0.28988e+00_r8 /)
      kbo(:, 3,32,11) = (/ &
        & 0.98456e-01_r8,0.33600e+00_r8,0.41253e+00_r8,0.44393e+00_r8,0.32217e+00_r8 /)
      kbo(:, 4,32,11) = (/ &
        & 0.11408e+00_r8,0.36612e+00_r8,0.44914e+00_r8,0.48266e+00_r8,0.35443e+00_r8 /)
      kbo(:, 5,32,11) = (/ &
        & 0.13035e+00_r8,0.39590e+00_r8,0.48448e+00_r8,0.51873e+00_r8,0.38602e+00_r8 /)
      kbo(:, 1,33,11) = (/ &
        & 0.69437e-01_r8,0.28056e+00_r8,0.34548e+00_r8,0.37055e+00_r8,0.26439e+00_r8 /)
      kbo(:, 2,33,11) = (/ &
        & 0.82778e-01_r8,0.31179e+00_r8,0.38345e+00_r8,0.41222e+00_r8,0.29653e+00_r8 /)
      kbo(:, 3,33,11) = (/ &
        & 0.97818e-01_r8,0.34234e+00_r8,0.42058e+00_r8,0.45271e+00_r8,0.32902e+00_r8 /)
      kbo(:, 4,33,11) = (/ &
        & 0.11406e+00_r8,0.37264e+00_r8,0.45719e+00_r8,0.49102e+00_r8,0.36138e+00_r8 /)
      kbo(:, 5,33,11) = (/ &
        & 0.13083e+00_r8,0.40228e+00_r8,0.49234e+00_r8,0.52669e+00_r8,0.39293e+00_r8 /)
      kbo(:, 1,34,11) = (/ &
        & 0.68001e-01_r8,0.28611e+00_r8,0.35258e+00_r8,0.37843e+00_r8,0.27007e+00_r8 /)
      kbo(:, 2,34,11) = (/ &
        & 0.82015e-01_r8,0.31742e+00_r8,0.39059e+00_r8,0.42007e+00_r8,0.30253e+00_r8 /)
      kbo(:, 3,34,11) = (/ &
        & 0.97684e-01_r8,0.34800e+00_r8,0.42777e+00_r8,0.46038e+00_r8,0.33518e+00_r8 /)
      kbo(:, 4,34,11) = (/ &
        & 0.11453e+00_r8,0.37836e+00_r8,0.46423e+00_r8,0.49832e+00_r8,0.36754e+00_r8 /)
      kbo(:, 5,34,11) = (/ &
        & 0.13165e+00_r8,0.40799e+00_r8,0.49927e+00_r8,0.53358e+00_r8,0.39902e+00_r8 /)
      kbo(:, 1,35,11) = (/ &
        & 0.66173e-01_r8,0.28901e+00_r8,0.35634e+00_r8,0.38261e+00_r8,0.27305e+00_r8 /)
      kbo(:, 2,35,11) = (/ &
        & 0.80679e-01_r8,0.32036e+00_r8,0.39443e+00_r8,0.42428e+00_r8,0.30572e+00_r8 /)
      kbo(:, 3,35,11) = (/ &
        & 0.96839e-01_r8,0.35097e+00_r8,0.43164e+00_r8,0.46448e+00_r8,0.33845e+00_r8 /)
      kbo(:, 4,35,11) = (/ &
        & 0.11412e+00_r8,0.38139e+00_r8,0.46804e+00_r8,0.50225e+00_r8,0.37079e+00_r8 /)
      kbo(:, 5,35,11) = (/ &
        & 0.13154e+00_r8,0.41104e+00_r8,0.50302e+00_r8,0.53730e+00_r8,0.40230e+00_r8 /)
      kbo(:, 1,36,11) = (/ &
        & 0.63512e-01_r8,0.28876e+00_r8,0.35615e+00_r8,0.38246e+00_r8,0.27277e+00_r8 /)
      kbo(:, 2,36,11) = (/ &
        & 0.78322e-01_r8,0.32017e+00_r8,0.39440e+00_r8,0.42423e+00_r8,0.30554e+00_r8 /)
      kbo(:, 3,36,11) = (/ &
        & 0.94792e-01_r8,0.35084e+00_r8,0.43169e+00_r8,0.46451e+00_r8,0.33835e+00_r8 /)
      kbo(:, 4,36,11) = (/ &
        & 0.11239e+00_r8,0.38129e+00_r8,0.46814e+00_r8,0.50234e+00_r8,0.37075e+00_r8 /)
      kbo(:, 5,36,11) = (/ &
        & 0.13007e+00_r8,0.41105e+00_r8,0.50318e+00_r8,0.53745e+00_r8,0.40235e+00_r8 /)
      kbo(:, 1,37,11) = (/ &
        & 0.59276e-01_r8,0.28388e+00_r8,0.35018e+00_r8,0.37605e+00_r8,0.26777e+00_r8 /)
      kbo(:, 2,37,11) = (/ &
        & 0.74070e-01_r8,0.31543e+00_r8,0.38877e+00_r8,0.41809e+00_r8,0.30055e+00_r8 /)
      kbo(:, 3,37,11) = (/ &
        & 0.90621e-01_r8,0.34621e+00_r8,0.42622e+00_r8,0.45870e+00_r8,0.33345e+00_r8 /)
      kbo(:, 4,37,11) = (/ &
        & 0.10838e+00_r8,0.37677e+00_r8,0.46291e+00_r8,0.49695e+00_r8,0.36598e+00_r8 /)
      kbo(:, 5,37,11) = (/ &
        & 0.12629e+00_r8,0.40664e+00_r8,0.49817e+00_r8,0.53255e+00_r8,0.39771e+00_r8 /)
      kbo(:, 1,38,11) = (/ &
        & 0.55352e-01_r8,0.27885e+00_r8,0.34399e+00_r8,0.36943e+00_r8,0.26263e+00_r8 /)
      kbo(:, 2,38,11) = (/ &
        & 0.70099e-01_r8,0.31053e+00_r8,0.38289e+00_r8,0.41165e+00_r8,0.29537e+00_r8 /)
      kbo(:, 3,38,11) = (/ &
        & 0.86674e-01_r8,0.34144e+00_r8,0.42052e+00_r8,0.45261e+00_r8,0.32834e+00_r8 /)
      kbo(:, 4,38,11) = (/ &
        & 0.10451e+00_r8,0.37207e+00_r8,0.45745e+00_r8,0.49130e+00_r8,0.36103e+00_r8 /)
      kbo(:, 5,38,11) = (/ &
        & 0.12261e+00_r8,0.40208e+00_r8,0.49291e+00_r8,0.52735e+00_r8,0.39288e+00_r8 /)
      kbo(:, 1,39,11) = (/ &
        & 0.51830e-01_r8,0.27388e+00_r8,0.33795e+00_r8,0.36294e+00_r8,0.25765e+00_r8 /)
      kbo(:, 2,39,11) = (/ &
        & 0.66473e-01_r8,0.30570e+00_r8,0.37709e+00_r8,0.40534e+00_r8,0.29029e+00_r8 /)
      kbo(:, 3,39,11) = (/ &
        & 0.83032e-01_r8,0.33678e+00_r8,0.41490e+00_r8,0.44656e+00_r8,0.32332e+00_r8 /)
      kbo(:, 4,39,11) = (/ &
        & 0.10089e+00_r8,0.36746e+00_r8,0.45203e+00_r8,0.48569e+00_r8,0.35615e+00_r8 /)
      kbo(:, 5,39,11) = (/ &
        & 0.11914e+00_r8,0.39759e+00_r8,0.48773e+00_r8,0.52218e+00_r8,0.38813e+00_r8 /)
      kbo(:, 1,40,11) = (/ &
        & 0.47273e-01_r8,0.26566e+00_r8,0.32789e+00_r8,0.35219e+00_r8,0.24948e+00_r8 /)
      kbo(:, 2,40,11) = (/ &
        & 0.61538e-01_r8,0.29768e+00_r8,0.36730e+00_r8,0.39473e+00_r8,0.28193e+00_r8 /)
      kbo(:, 3,40,11) = (/ &
        & 0.77858e-01_r8,0.32903e+00_r8,0.40551e+00_r8,0.43635e+00_r8,0.31499e+00_r8 /)
      kbo(:, 4,40,11) = (/ &
        & 0.95580e-01_r8,0.35975e+00_r8,0.44288e+00_r8,0.47617e+00_r8,0.34794e+00_r8 /)
      kbo(:, 5,40,11) = (/ &
        & 0.11394e+00_r8,0.39008e+00_r8,0.47900e+00_r8,0.51333e+00_r8,0.38020e+00_r8 /)
      kbo(:, 1,41,11) = (/ &
        & 0.42888e-01_r8,0.25708e+00_r8,0.31732e+00_r8,0.34096e+00_r8,0.24098e+00_r8 /)
      kbo(:, 2,41,11) = (/ &
        & 0.56697e-01_r8,0.28927e+00_r8,0.35696e+00_r8,0.38355e+00_r8,0.27327e+00_r8 /)
      kbo(:, 3,41,11) = (/ &
        & 0.72702e-01_r8,0.32083e+00_r8,0.39561e+00_r8,0.42555e+00_r8,0.30626e+00_r8 /)
      kbo(:, 4,41,11) = (/ &
        & 0.90227e-01_r8,0.35164e+00_r8,0.43315e+00_r8,0.46599e+00_r8,0.33930e+00_r8 /)
      kbo(:, 5,41,11) = (/ &
        & 0.10861e+00_r8,0.38219e+00_r8,0.46971e+00_r8,0.50385e+00_r8,0.37183e+00_r8 /)
      kbo(:, 1,42,11) = (/ &
        & 0.38819e-01_r8,0.24850e+00_r8,0.30677e+00_r8,0.32968e+00_r8,0.23256e+00_r8 /)
      kbo(:, 2,42,11) = (/ &
        & 0.52147e-01_r8,0.28080e+00_r8,0.34660e+00_r8,0.37239e+00_r8,0.26466e+00_r8 /)
      kbo(:, 3,42,11) = (/ &
        & 0.67768e-01_r8,0.31263e+00_r8,0.38564e+00_r8,0.41466e+00_r8,0.29758e+00_r8 /)
      kbo(:, 4,42,11) = (/ &
        & 0.85041e-01_r8,0.34356e+00_r8,0.42336e+00_r8,0.45563e+00_r8,0.33065e+00_r8 /)
      kbo(:, 5,42,11) = (/ &
        & 0.10335e+00_r8,0.37426e+00_r8,0.46032e+00_r8,0.49419e+00_r8,0.36339e+00_r8 /)
      kbo(:, 1,43,11) = (/ &
        & 0.34406e-01_r8,0.23801e+00_r8,0.29406e+00_r8,0.31601e+00_r8,0.22240e+00_r8 /)
      kbo(:, 2,43,11) = (/ &
        & 0.47048e-01_r8,0.27050e+00_r8,0.33401e+00_r8,0.35883e+00_r8,0.25435e+00_r8 /)
      kbo(:, 3,43,11) = (/ &
        & 0.62114e-01_r8,0.30257e+00_r8,0.37337e+00_r8,0.40135e+00_r8,0.28701e+00_r8 /)
      kbo(:, 4,43,11) = (/ &
        & 0.79018e-01_r8,0.33381e+00_r8,0.41146e+00_r8,0.44285e+00_r8,0.32012e+00_r8 /)
      kbo(:, 5,43,11) = (/ &
        & 0.97123e-01_r8,0.36459e+00_r8,0.44877e+00_r8,0.48229e+00_r8,0.35311e+00_r8 /)
      kbo(:, 1,44,11) = (/ &
        & 0.30068e-01_r8,0.22661e+00_r8,0.28047e+00_r8,0.30141e+00_r8,0.21157e+00_r8 /)
      kbo(:, 2,44,11) = (/ &
        & 0.41934e-01_r8,0.25939e+00_r8,0.32031e+00_r8,0.34420e+00_r8,0.24331e+00_r8 /)
      kbo(:, 3,44,11) = (/ &
        & 0.56334e-01_r8,0.29165e+00_r8,0.35997e+00_r8,0.38686e+00_r8,0.27569e+00_r8 /)
      kbo(:, 4,44,11) = (/ &
        & 0.72738e-01_r8,0.32319e+00_r8,0.39860e+00_r8,0.42881e+00_r8,0.30880e+00_r8 /)
      kbo(:, 5,44,11) = (/ &
        & 0.90538e-01_r8,0.35407e+00_r8,0.43616e+00_r8,0.46913e+00_r8,0.34187e+00_r8 /)
      kbo(:, 1,45,11) = (/ &
        & 0.26090e-01_r8,0.21511e+00_r8,0.26705e+00_r8,0.28701e+00_r8,0.20089e+00_r8 /)
      kbo(:, 2,45,11) = (/ &
        & 0.37182e-01_r8,0.24828e+00_r8,0.30662e+00_r8,0.32954e+00_r8,0.23239e+00_r8 /)
      kbo(:, 3,45,11) = (/ &
        & 0.50828e-01_r8,0.28069e+00_r8,0.34649e+00_r8,0.37235e+00_r8,0.26452e+00_r8 /)
      kbo(:, 4,45,11) = (/ &
        & 0.66683e-01_r8,0.31254e+00_r8,0.38562e+00_r8,0.41465e+00_r8,0.29751e+00_r8 /)
      kbo(:, 5,45,11) = (/ &
        & 0.84110e-01_r8,0.34354e+00_r8,0.42341e+00_r8,0.45565e+00_r8,0.33061e+00_r8 /)
      kbo(:, 1,46,11) = (/ &
        & 0.22282e-01_r8,0.20276e+00_r8,0.25300e+00_r8,0.27194e+00_r8,0.18966e+00_r8 /)
      kbo(:, 2,46,11) = (/ &
        & 0.32494e-01_r8,0.23634e+00_r8,0.29212e+00_r8,0.31397e+00_r8,0.22083e+00_r8 /)
      kbo(:, 3,46,11) = (/ &
        & 0.45322e-01_r8,0.26893e+00_r8,0.33209e+00_r8,0.35685e+00_r8,0.25276e+00_r8 /)
      kbo(:, 4,46,11) = (/ &
        & 0.60492e-01_r8,0.30105e+00_r8,0.37160e+00_r8,0.39945e+00_r8,0.28546e+00_r8 /)
      kbo(:, 5,46,11) = (/ &
        & 0.77449e-01_r8,0.33241e+00_r8,0.40979e+00_r8,0.44100e+00_r8,0.31859e+00_r8 /)
      kbo(:, 1,47,11) = (/ &
        & 0.18534e-01_r8,0.18898e+00_r8,0.23758e+00_r8,0.25552e+00_r8,0.17724e+00_r8 /)
      kbo(:, 2,47,11) = (/ &
        & 0.27732e-01_r8,0.22283e+00_r8,0.27608e+00_r8,0.29673e+00_r8,0.20806e+00_r8 /)
      kbo(:, 3,47,11) = (/ &
        & 0.39604e-01_r8,0.25581e+00_r8,0.31589e+00_r8,0.33953e+00_r8,0.23975e+00_r8 /)
      kbo(:, 4,47,11) = (/ &
        & 0.53911e-01_r8,0.28814e+00_r8,0.35568e+00_r8,0.38226e+00_r8,0.27210e+00_r8 /)
      kbo(:, 5,47,11) = (/ &
        & 0.70242e-01_r8,0.31982e+00_r8,0.39452e+00_r8,0.42435e+00_r8,0.30521e+00_r8 /)
      kbo(:, 1,48,11) = (/ &
        & 0.15230e-01_r8,0.17512e+00_r8,0.22238e+00_r8,0.23953e+00_r8,0.16496e+00_r8 /)
      kbo(:, 2,48,11) = (/ &
        & 0.23424e-01_r8,0.20917e+00_r8,0.26028e+00_r8,0.27977e+00_r8,0.19549e+00_r8 /)
      kbo(:, 3,48,11) = (/ &
        & 0.34289e-01_r8,0.24261e+00_r8,0.29967e+00_r8,0.32213e+00_r8,0.22686e+00_r8 /)
      kbo(:, 4,48,11) = (/ &
        & 0.47677e-01_r8,0.27510e+00_r8,0.33967e+00_r8,0.36502e+00_r8,0.25892e+00_r8 /)
      kbo(:, 5,48,11) = (/ &
        & 0.63303e-01_r8,0.30711e+00_r8,0.37902e+00_r8,0.40749e+00_r8,0.29180e+00_r8 /)
      kbo(:, 1,49,11) = (/ &
        & 0.12348e-01_r8,0.16145e+00_r8,0.20748e+00_r8,0.22396e+00_r8,0.15290e+00_r8 /)
      kbo(:, 2,49,11) = (/ &
        & 0.19656e-01_r8,0.19547e+00_r8,0.24481e+00_r8,0.26319e+00_r8,0.18304e+00_r8 /)
      kbo(:, 3,49,11) = (/ &
        & 0.29411e-01_r8,0.22922e+00_r8,0.28358e+00_r8,0.30484e+00_r8,0.21403e+00_r8 /)
      kbo(:, 4,49,11) = (/ &
        & 0.41852e-01_r8,0.26199e+00_r8,0.32356e+00_r8,0.34774e+00_r8,0.24589e+00_r8 /)
      kbo(:, 5,49,11) = (/ &
        & 0.56641e-01_r8,0.29425e+00_r8,0.36325e+00_r8,0.39043e+00_r8,0.27839e+00_r8 /)
      kbo(:, 1,50,11) = (/ &
        & 0.10059e-01_r8,0.14901e+00_r8,0.19385e+00_r8,0.20977e+00_r8,0.14182e+00_r8 /)
      kbo(:, 2,50,11) = (/ &
        & 0.16439e-01_r8,0.18255e+00_r8,0.23049e+00_r8,0.24806e+00_r8,0.17150e+00_r8 /)
      kbo(:, 3,50,11) = (/ &
        & 0.25328e-01_r8,0.21656e+00_r8,0.26875e+00_r8,0.28888e+00_r8,0.20219e+00_r8 /)
      kbo(:, 4,50,11) = (/ &
        & 0.36730e-01_r8,0.24971e+00_r8,0.30839e+00_r8,0.33151e+00_r8,0.23378e+00_r8 /)
      kbo(:, 5,50,11) = (/ &
        & 0.50682e-01_r8,0.28213e+00_r8,0.34832e+00_r8,0.37432e+00_r8,0.26599e+00_r8 /)
      kbo(:, 1,51,11) = (/ &
        & 0.81000e-02_r8,0.13718e+00_r8,0.18086e+00_r8,0.19633e+00_r8,0.13125e+00_r8 /)
      kbo(:, 2,51,11) = (/ &
        & 0.13663e-01_r8,0.17002e+00_r8,0.21682e+00_r8,0.23372e+00_r8,0.16044e+00_r8 /)
      kbo(:, 3,51,11) = (/ &
        & 0.21646e-01_r8,0.20410e+00_r8,0.25452e+00_r8,0.27362e+00_r8,0.19085e+00_r8 /)
      kbo(:, 4,51,11) = (/ &
        & 0.32117e-01_r8,0.23766e+00_r8,0.29370e+00_r8,0.31573e+00_r8,0.22210e+00_r8 /)
      kbo(:, 5,51,11) = (/ &
        & 0.45217e-01_r8,0.27026e+00_r8,0.33377e+00_r8,0.35865e+00_r8,0.25409e+00_r8 /)
      kbo(:, 1,52,11) = (/ &
        & 0.64392e-02_r8,0.12568e+00_r8,0.16814e+00_r8,0.18321e+00_r8,0.12091e+00_r8 /)
      kbo(:, 2,52,11) = (/ &
        & 0.11223e-01_r8,0.15773e+00_r8,0.20341e+00_r8,0.21973e+00_r8,0.14959e+00_r8 /)
      kbo(:, 3,52,11) = (/ &
        & 0.18327e-01_r8,0.19165e+00_r8,0.24057e+00_r8,0.25870e+00_r8,0.17960e+00_r8 /)
      kbo(:, 4,52,11) = (/ &
        & 0.27978e-01_r8,0.22553e+00_r8,0.27924e+00_r8,0.30015e+00_r8,0.21055e+00_r8 /)
      kbo(:, 5,52,11) = (/ &
        & 0.40066e-01_r8,0.25840e+00_r8,0.31913e+00_r8,0.34300e+00_r8,0.24233e+00_r8 /)
      kbo(:, 1,53,11) = (/ &
        & 0.50582e-02_r8,0.11452e+00_r8,0.15565e+00_r8,0.17040e+00_r8,0.11082e+00_r8 /)
      kbo(:, 2,53,11) = (/ &
        & 0.90986e-02_r8,0.14571e+00_r8,0.19026e+00_r8,0.20608e+00_r8,0.13891e+00_r8 /)
      kbo(:, 3,53,11) = (/ &
        & 0.15360e-01_r8,0.17911e+00_r8,0.22674e+00_r8,0.24415e+00_r8,0.16845e+00_r8 /)
      kbo(:, 4,53,11) = (/ &
        & 0.24079e-01_r8,0.21320e+00_r8,0.26488e+00_r8,0.28473e+00_r8,0.19911e+00_r8 /)
      kbo(:, 5,53,11) = (/ &
        & 0.35249e-01_r8,0.24647e+00_r8,0.30443e+00_r8,0.32725e+00_r8,0.23061e+00_r8 /)
      kbo(:, 1,54,11) = (/ &
        & 0.39947e-02_r8,0.10467e+00_r8,0.14438e+00_r8,0.15895e+00_r8,0.10183e+00_r8 /)
      kbo(:, 2,54,11) = (/ &
        & 0.74123e-02_r8,0.13495e+00_r8,0.17842e+00_r8,0.19384e+00_r8,0.12928e+00_r8 /)
      kbo(:, 3,54,11) = (/ &
        & 0.12928e-01_r8,0.16768e+00_r8,0.21428e+00_r8,0.23108e+00_r8,0.15838e+00_r8 /)
      kbo(:, 4,54,11) = (/ &
        & 0.20817e-01_r8,0.20178e+00_r8,0.25191e+00_r8,0.27082e+00_r8,0.18875e+00_r8 /)
      kbo(:, 5,54,11) = (/ &
        & 0.31131e-01_r8,0.23540e+00_r8,0.29100e+00_r8,0.31283e+00_r8,0.21994e+00_r8 /)
      kbo(:, 1,55,11) = (/ &
        & 0.31444e-02_r8,0.95645e-01_r8,0.13357e+00_r8,0.14821e+00_r8,0.93456e-01_r8 /)
      kbo(:, 2,55,11) = (/ &
        & 0.60192e-02_r8,0.12488e+00_r8,0.16728e+00_r8,0.18235e+00_r8,0.12022e+00_r8 /)
      kbo(:, 3,55,11) = (/ &
        & 0.10844e-01_r8,0.15692e+00_r8,0.20255e+00_r8,0.21884e+00_r8,0.14887e+00_r8 /)
      kbo(:, 4,55,11) = (/ &
        & 0.17966e-01_r8,0.19085e+00_r8,0.23968e+00_r8,0.25776e+00_r8,0.17889e+00_r8 /)
      kbo(:, 5,55,11) = (/ &
        & 0.27575e-01_r8,0.22475e+00_r8,0.27833e+00_r8,0.29920e+00_r8,0.20981e+00_r8 /)
      kbo(:, 1,56,11) = (/ &
        & 0.24408e-02_r8,0.87042e-01_r8,0.12294e+00_r8,0.13774e+00_r8,0.85384e-01_r8 /)
      kbo(:, 2,56,11) = (/ &
        & 0.48425e-02_r8,0.11512e+00_r8,0.15634e+00_r8,0.17115e+00_r8,0.11140e+00_r8 /)
      kbo(:, 3,56,11) = (/ &
        & 0.90070e-02_r8,0.14641e+00_r8,0.19103e+00_r8,0.20689e+00_r8,0.13953e+00_r8 /)
      kbo(:, 4,56,11) = (/ &
        & 0.15384e-01_r8,0.17987e+00_r8,0.22757e+00_r8,0.24502e+00_r8,0.16913e+00_r8 /)
      kbo(:, 5,56,11) = (/ &
        & 0.24183e-01_r8,0.21396e+00_r8,0.26576e+00_r8,0.28569e+00_r8,0.19980e+00_r8 /)
      kbo(:, 1,57,11) = (/ &
        & 0.18661e-02_r8,0.78869e-01_r8,0.11259e+00_r8,0.12744e+00_r8,0.77594e-01_r8 /)
      kbo(:, 2,57,11) = (/ &
        & 0.38393e-02_r8,0.10567e+00_r8,0.14558e+00_r8,0.16018e+00_r8,0.10279e+00_r8 /)
      kbo(:, 3,57,11) = (/ &
        & 0.73986e-02_r8,0.13611e+00_r8,0.17972e+00_r8,0.19518e+00_r8,0.13032e+00_r8 /)
      kbo(:, 4,57,11) = (/ &
        & 0.13057e-01_r8,0.16895e+00_r8,0.21565e+00_r8,0.23253e+00_r8,0.15951e+00_r8 /)
      kbo(:, 5,57,11) = (/ &
        & 0.21059e-01_r8,0.20305e+00_r8,0.25335e+00_r8,0.27238e+00_r8,0.18989e+00_r8 /)
      kbo(:, 1,58,11) = (/ &
        & 0.14289e-02_r8,0.71481e-01_r8,0.10314e+00_r8,0.11789e+00_r8,0.70461e-01_r8 /)
      kbo(:, 2,58,11) = (/ &
        & 0.30447e-02_r8,0.97100e-01_r8,0.13537e+00_r8,0.15001e+00_r8,0.94840e-01_r8 /)
      kbo(:, 3,58,11) = (/ &
        & 0.60785e-02_r8,0.12656e+00_r8,0.16917e+00_r8,0.18428e+00_r8,0.12173e+00_r8 /)
      kbo(:, 4,58,11) = (/ &
        & 0.11073e-01_r8,0.15875e+00_r8,0.20453e+00_r8,0.22090e+00_r8,0.15049e+00_r8 /)
      kbo(:, 5,58,11) = (/ &
        & 0.18344e-01_r8,0.19271e+00_r8,0.24175e+00_r8,0.25997e+00_r8,0.18056e+00_r8 /)
      kbo(:, 1,59,11) = (/ &
        & 0.12466e-02_r8,0.68608e-01_r8,0.99449e-01_r8,0.11409e+00_r8,0.67679e-01_r8 /)
      kbo(:, 2,59,11) = (/ &
        & 0.27400e-02_r8,0.93756e-01_r8,0.13130e+00_r8,0.14598e+00_r8,0.91727e-01_r8 /)
      kbo(:, 3,59,11) = (/ &
        & 0.55829e-02_r8,0.12280e+00_r8,0.16498e+00_r8,0.17997e+00_r8,0.11835e+00_r8 /)
      kbo(:, 4,59,11) = (/ &
        & 0.10327e-01_r8,0.15471e+00_r8,0.20012e+00_r8,0.21632e+00_r8,0.14691e+00_r8 /)
      kbo(:, 5,59,11) = (/ &
        & 0.17312e-01_r8,0.18856e+00_r8,0.23714e+00_r8,0.25511e+00_r8,0.17685e+00_r8 /)
      kbo(:, 1,13,12) = (/ &
        & 0.97672e+00_r8,0.12351e+01_r8,0.13467e+01_r8,0.13355e+01_r8,0.11350e+01_r8 /)
      kbo(:, 2,13,12) = (/ &
        & 0.96517e+00_r8,0.12326e+01_r8,0.13523e+01_r8,0.13488e+01_r8,0.11500e+01_r8 /)
      kbo(:, 3,13,12) = (/ &
        & 0.95359e+00_r8,0.12308e+01_r8,0.13576e+01_r8,0.13588e+01_r8,0.11629e+01_r8 /)
      kbo(:, 4,13,12) = (/ &
        & 0.94644e+00_r8,0.12294e+01_r8,0.13618e+01_r8,0.13660e+01_r8,0.11761e+01_r8 /)
      kbo(:, 5,13,12) = (/ &
        & 0.94938e+00_r8,0.12277e+01_r8,0.13647e+01_r8,0.13713e+01_r8,0.11895e+01_r8 /)
      kbo(:, 1,14,12) = (/ &
        & 0.86287e+00_r8,0.11528e+01_r8,0.12800e+01_r8,0.12931e+01_r8,0.10793e+01_r8 /)
      kbo(:, 2,14,12) = (/ &
        & 0.85328e+00_r8,0.11519e+01_r8,0.12878e+01_r8,0.13082e+01_r8,0.10960e+01_r8 /)
      kbo(:, 3,14,12) = (/ &
        & 0.84776e+00_r8,0.11522e+01_r8,0.12944e+01_r8,0.13193e+01_r8,0.11122e+01_r8 /)
      kbo(:, 4,14,12) = (/ &
        & 0.85264e+00_r8,0.11532e+01_r8,0.12995e+01_r8,0.13287e+01_r8,0.11288e+01_r8 /)
      kbo(:, 5,14,12) = (/ &
        & 0.86761e+00_r8,0.11556e+01_r8,0.13039e+01_r8,0.13378e+01_r8,0.11458e+01_r8 /)
      kbo(:, 1,15,12) = (/ &
        & 0.75595e+00_r8,0.10736e+01_r8,0.12146e+01_r8,0.12437e+01_r8,0.10230e+01_r8 /)
      kbo(:, 2,15,12) = (/ &
        & 0.75063e+00_r8,0.10744e+01_r8,0.12248e+01_r8,0.12603e+01_r8,0.10430e+01_r8 /)
      kbo(:, 3,15,12) = (/ &
        & 0.75594e+00_r8,0.10769e+01_r8,0.12334e+01_r8,0.12743e+01_r8,0.10635e+01_r8 /)
      kbo(:, 4,15,12) = (/ &
        & 0.77107e+00_r8,0.10807e+01_r8,0.12402e+01_r8,0.12881e+01_r8,0.10841e+01_r8 /)
      kbo(:, 5,15,12) = (/ &
        & 0.79469e+00_r8,0.10902e+01_r8,0.12461e+01_r8,0.13012e+01_r8,0.11031e+01_r8 /)
      kbo(:, 1,16,12) = (/ &
        & 0.66063e+00_r8,0.99640e+00_r8,0.11502e+01_r8,0.11902e+01_r8,0.96912e+00_r8 /)
      kbo(:, 2,16,12) = (/ &
        & 0.66454e+00_r8,0.10001e+01_r8,0.11634e+01_r8,0.12095e+01_r8,0.99257e+00_r8 /)
      kbo(:, 3,16,12) = (/ &
        & 0.67895e+00_r8,0.10049e+01_r8,0.11739e+01_r8,0.12282e+01_r8,0.10170e+01_r8 /)
      kbo(:, 4,16,12) = (/ &
        & 0.70145e+00_r8,0.10153e+01_r8,0.11833e+01_r8,0.12469e+01_r8,0.10404e+01_r8 /)
      kbo(:, 5,16,12) = (/ &
        & 0.72525e+00_r8,0.10330e+01_r8,0.11925e+01_r8,0.12646e+01_r8,0.10610e+01_r8 /)
      kbo(:, 1,17,12) = (/ &
        & 0.58214e+00_r8,0.92297e+00_r8,0.10896e+01_r8,0.11346e+01_r8,0.91647e+00_r8 /)
      kbo(:, 2,17,12) = (/ &
        & 0.59400e+00_r8,0.92929e+00_r8,0.11045e+01_r8,0.11590e+01_r8,0.94550e+00_r8 /)
      kbo(:, 3,17,12) = (/ &
        & 0.61460e+00_r8,0.94000e+00_r8,0.11172e+01_r8,0.11832e+01_r8,0.97371e+00_r8 /)
      kbo(:, 4,17,12) = (/ &
        & 0.63691e+00_r8,0.95830e+00_r8,0.11303e+01_r8,0.12071e+01_r8,0.99891e+00_r8 /)
      kbo(:, 5,17,12) = (/ &
        & 0.66003e+00_r8,0.98295e+00_r8,0.11440e+01_r8,0.12298e+01_r8,0.10215e+01_r8 /)
      kbo(:, 1,18,12) = (/ &
        & 0.51831e+00_r8,0.85586e+00_r8,0.10313e+01_r8,0.10823e+01_r8,0.86734e+00_r8 /)
      kbo(:, 2,18,12) = (/ &
        & 0.53638e+00_r8,0.86645e+00_r8,0.10487e+01_r8,0.11114e+01_r8,0.90071e+00_r8 /)
      kbo(:, 3,18,12) = (/ &
        & 0.55679e+00_r8,0.88410e+00_r8,0.10657e+01_r8,0.11407e+01_r8,0.93149e+00_r8 /)
      kbo(:, 4,18,12) = (/ &
        & 0.57819e+00_r8,0.90902e+00_r8,0.10831e+01_r8,0.11693e+01_r8,0.95937e+00_r8 /)
      kbo(:, 5,18,12) = (/ &
        & 0.60387e+00_r8,0.94010e+00_r8,0.11032e+01_r8,0.11966e+01_r8,0.98550e+00_r8 /)
      kbo(:, 1,19,12) = (/ &
        & 0.46547e+00_r8,0.79533e+00_r8,0.97579e+00_r8,0.10353e+01_r8,0.82208e+00_r8 /)
      kbo(:, 2,19,12) = (/ &
        & 0.48441e+00_r8,0.81281e+00_r8,0.99768e+00_r8,0.10690e+01_r8,0.85858e+00_r8 /)
      kbo(:, 3,19,12) = (/ &
        & 0.50438e+00_r8,0.83723e+00_r8,0.10197e+01_r8,0.11027e+01_r8,0.89202e+00_r8 /)
      kbo(:, 4,19,12) = (/ &
        & 0.52861e+00_r8,0.86772e+00_r8,0.10433e+01_r8,0.11355e+01_r8,0.92298e+00_r8 /)
      kbo(:, 5,19,12) = (/ &
        & 0.55711e+00_r8,0.90301e+00_r8,0.10701e+01_r8,0.11672e+01_r8,0.95266e+00_r8 /)
      kbo(:, 1,20,12) = (/ &
        & 0.41965e+00_r8,0.74319e+00_r8,0.92508e+00_r8,0.99412e+00_r8,0.78089e+00_r8 /)
      kbo(:, 2,20,12) = (/ &
        & 0.43802e+00_r8,0.76766e+00_r8,0.95235e+00_r8,0.10327e+01_r8,0.82017e+00_r8 /)
      kbo(:, 3,20,12) = (/ &
        & 0.46025e+00_r8,0.79818e+00_r8,0.98022e+00_r8,0.10706e+01_r8,0.85677e+00_r8 /)
      kbo(:, 4,20,12) = (/ &
        & 0.48727e+00_r8,0.83370e+00_r8,0.10109e+01_r8,0.11072e+01_r8,0.89127e+00_r8 /)
      kbo(:, 5,20,12) = (/ &
        & 0.51863e+00_r8,0.87091e+00_r8,0.10440e+01_r8,0.11423e+01_r8,0.92433e+00_r8 /)
      kbo(:, 1,21,12) = (/ &
        & 0.37915e+00_r8,0.69998e+00_r8,0.88069e+00_r8,0.95835e+00_r8,0.74387e+00_r8 /)
      kbo(:, 2,21,12) = (/ &
        & 0.39885e+00_r8,0.72965e+00_r8,0.91291e+00_r8,0.10022e+01_r8,0.78645e+00_r8 /)
      kbo(:, 3,21,12) = (/ &
        & 0.42350e+00_r8,0.76561e+00_r8,0.94765e+00_r8,0.10443e+01_r8,0.82639e+00_r8 /)
      kbo(:, 4,21,12) = (/ &
        & 0.45298e+00_r8,0.80432e+00_r8,0.98473e+00_r8,0.10842e+01_r8,0.86477e+00_r8 /)
      kbo(:, 5,21,12) = (/ &
        & 0.48674e+00_r8,0.84344e+00_r8,0.10236e+01_r8,0.11221e+01_r8,0.90082e+00_r8 /)
      kbo(:, 1,22,12) = (/ &
        & 0.34554e+00_r8,0.66631e+00_r8,0.84565e+00_r8,0.93193e+00_r8,0.71462e+00_r8 /)
      kbo(:, 2,22,12) = (/ &
        & 0.36807e+00_r8,0.70096e+00_r8,0.88353e+00_r8,0.98021e+00_r8,0.76038e+00_r8 /)
      kbo(:, 3,22,12) = (/ &
        & 0.39520e+00_r8,0.74099e+00_r8,0.92460e+00_r8,0.10260e+01_r8,0.80381e+00_r8 /)
      kbo(:, 4,22,12) = (/ &
        & 0.42700e+00_r8,0.78213e+00_r8,0.96750e+00_r8,0.10688e+01_r8,0.84544e+00_r8 /)
      kbo(:, 5,22,12) = (/ &
        & 0.46306e+00_r8,0.82357e+00_r8,0.10116e+01_r8,0.11089e+01_r8,0.88444e+00_r8 /)
      kbo(:, 1,23,12) = (/ &
        & 0.31790e+00_r8,0.64007e+00_r8,0.81825e+00_r8,0.91240e+00_r8,0.69117e+00_r8 /)
      kbo(:, 2,23,12) = (/ &
        & 0.34313e+00_r8,0.67943e+00_r8,0.86200e+00_r8,0.96400e+00_r8,0.74026e+00_r8 /)
      kbo(:, 3,23,12) = (/ &
        & 0.37292e+00_r8,0.72179e+00_r8,0.90853e+00_r8,0.10128e+01_r8,0.78692e+00_r8 /)
      kbo(:, 4,23,12) = (/ &
        & 0.40683e+00_r8,0.76528e+00_r8,0.95638e+00_r8,0.10584e+01_r8,0.83132e+00_r8 /)
      kbo(:, 5,23,12) = (/ &
        & 0.44434e+00_r8,0.80906e+00_r8,0.10049e+01_r8,0.11007e+01_r8,0.87324e+00_r8 /)
      kbo(:, 1,24,12) = (/ &
        & 0.29587e+00_r8,0.62091e+00_r8,0.79898e+00_r8,0.89859e+00_r8,0.67383e+00_r8 /)
      kbo(:, 2,24,12) = (/ &
        & 0.32356e+00_r8,0.66370e+00_r8,0.84800e+00_r8,0.95354e+00_r8,0.72591e+00_r8 /)
      kbo(:, 3,24,12) = (/ &
        & 0.35587e+00_r8,0.70805e+00_r8,0.89882e+00_r8,0.10049e+01_r8,0.77551e+00_r8 /)
      kbo(:, 4,24,12) = (/ &
        & 0.39090e+00_r8,0.75345e+00_r8,0.95073e+00_r8,0.10524e+01_r8,0.82233e+00_r8 /)
      kbo(:, 5,24,12) = (/ &
        & 0.42938e+00_r8,0.80019e+00_r8,0.10026e+01_r8,0.10965e+01_r8,0.86634e+00_r8 /)
      kbo(:, 1,25,12) = (/ &
        & 0.27857e+00_r8,0.60799e+00_r8,0.78705e+00_r8,0.89081e+00_r8,0.66256e+00_r8 /)
      kbo(:, 2,25,12) = (/ &
        & 0.30889e+00_r8,0.65303e+00_r8,0.84032e+00_r8,0.94841e+00_r8,0.71733e+00_r8 /)
      kbo(:, 3,25,12) = (/ &
        & 0.34245e+00_r8,0.69924e+00_r8,0.89488e+00_r8,0.10015e+01_r8,0.76917e+00_r8 /)
      kbo(:, 4,25,12) = (/ &
        & 0.37871e+00_r8,0.74693e+00_r8,0.95015e+00_r8,0.10506e+01_r8,0.81807e+00_r8 /)
      kbo(:, 5,25,12) = (/ &
        & 0.41833e+00_r8,0.79644e+00_r8,0.10044e+01_r8,0.10958e+01_r8,0.86374e+00_r8 /)
      kbo(:, 1,26,12) = (/ &
        & 0.26580e+00_r8,0.60063e+00_r8,0.78228e+00_r8,0.88879e+00_r8,0.65720e+00_r8 /)
      kbo(:, 2,26,12) = (/ &
        & 0.29790e+00_r8,0.64759e+00_r8,0.83895e+00_r8,0.94821e+00_r8,0.71439e+00_r8 /)
      kbo(:, 3,26,12) = (/ &
        & 0.33261e+00_r8,0.69574e+00_r8,0.89642e+00_r8,0.10025e+01_r8,0.76782e+00_r8 /)
      kbo(:, 4,26,12) = (/ &
        & 0.37054e+00_r8,0.74591e+00_r8,0.95396e+00_r8,0.10524e+01_r8,0.81818e+00_r8 /)
      kbo(:, 5,26,12) = (/ &
        & 0.41158e+00_r8,0.79751e+00_r8,0.10099e+01_r8,0.10981e+01_r8,0.86507e+00_r8 /)
      kbo(:, 1,27,12) = (/ &
        & 0.25628e+00_r8,0.59727e+00_r8,0.78261e+00_r8,0.89115e+00_r8,0.65648e+00_r8 /)
      kbo(:, 2,27,12) = (/ &
        & 0.28973e+00_r8,0.64617e+00_r8,0.84187e+00_r8,0.95137e+00_r8,0.71531e+00_r8 /)
      kbo(:, 3,27,12) = (/ &
        & 0.32602e+00_r8,0.69640e+00_r8,0.90149e+00_r8,0.10062e+01_r8,0.76992e+00_r8 /)
      kbo(:, 4,27,12) = (/ &
        & 0.36566e+00_r8,0.74858e+00_r8,0.96067e+00_r8,0.10565e+01_r8,0.82130e+00_r8 /)
      kbo(:, 5,27,12) = (/ &
        & 0.40839e+00_r8,0.80160e+00_r8,0.10174e+01_r8,0.11025e+01_r8,0.86892e+00_r8 /)
      kbo(:, 1,28,12) = (/ &
        & 0.24931e+00_r8,0.59767e+00_r8,0.78703e+00_r8,0.89664e+00_r8,0.65970e+00_r8 /)
      kbo(:, 2,28,12) = (/ &
        & 0.28438e+00_r8,0.64828e+00_r8,0.84808e+00_r8,0.95711e+00_r8,0.71948e+00_r8 /)
      kbo(:, 3,28,12) = (/ &
        & 0.32259e+00_r8,0.70046e+00_r8,0.90930e+00_r8,0.10123e+01_r8,0.77494e+00_r8 /)
      kbo(:, 4,28,12) = (/ &
        & 0.36394e+00_r8,0.75423e+00_r8,0.96943e+00_r8,0.10625e+01_r8,0.82683e+00_r8 /)
      kbo(:, 5,28,12) = (/ &
        & 0.40857e+00_r8,0.80828e+00_r8,0.10265e+01_r8,0.11085e+01_r8,0.87457e+00_r8 /)
      kbo(:, 1,29,12) = (/ &
        & 0.24529e+00_r8,0.60153e+00_r8,0.79470e+00_r8,0.90469e+00_r8,0.66635e+00_r8 /)
      kbo(:, 2,29,12) = (/ &
        & 0.28215e+00_r8,0.65374e+00_r8,0.85707e+00_r8,0.96518e+00_r8,0.72659e+00_r8 /)
      kbo(:, 3,29,12) = (/ &
        & 0.32237e+00_r8,0.70744e+00_r8,0.91955e+00_r8,0.10202e+01_r8,0.78233e+00_r8 /)
      kbo(:, 4,29,12) = (/ &
        & 0.36548e+00_r8,0.76246e+00_r8,0.98006e+00_r8,0.10704e+01_r8,0.83435e+00_r8 /)
      kbo(:, 5,29,12) = (/ &
        & 0.41179e+00_r8,0.81715e+00_r8,0.10368e+01_r8,0.11160e+01_r8,0.88198e+00_r8 /)
      kbo(:, 1,30,12) = (/ &
        & 0.24386e+00_r8,0.60816e+00_r8,0.80473e+00_r8,0.91460e+00_r8,0.67543e+00_r8 /)
      kbo(:, 2,30,12) = (/ &
        & 0.28279e+00_r8,0.66165e+00_r8,0.86804e+00_r8,0.97470e+00_r8,0.73566e+00_r8 /)
      kbo(:, 3,30,12) = (/ &
        & 0.32483e+00_r8,0.71650e+00_r8,0.93115e+00_r8,0.10292e+01_r8,0.79124e+00_r8 /)
      kbo(:, 4,30,12) = (/ &
        & 0.36954e+00_r8,0.77208e+00_r8,0.99158e+00_r8,0.10790e+01_r8,0.84299e+00_r8 /)
      kbo(:, 5,30,12) = (/ &
        & 0.41749e+00_r8,0.82738e+00_r8,0.10478e+01_r8,0.11245e+01_r8,0.89039e+00_r8 /)
      kbo(:, 1,31,12) = (/ &
        & 0.24525e+00_r8,0.61702e+00_r8,0.81682e+00_r8,0.92621e+00_r8,0.68640e+00_r8 /)
      kbo(:, 2,31,12) = (/ &
        & 0.28616e+00_r8,0.67142e+00_r8,0.88072e+00_r8,0.98550e+00_r8,0.74643e+00_r8 /)
      kbo(:, 3,31,12) = (/ &
        & 0.32989e+00_r8,0.72710e+00_r8,0.94409e+00_r8,0.10393e+01_r8,0.80152e+00_r8 /)
      kbo(:, 4,31,12) = (/ &
        & 0.37609e+00_r8,0.78314e+00_r8,0.10041e+01_r8,0.10886e+01_r8,0.85269e+00_r8 /)
      kbo(:, 5,31,12) = (/ &
        & 0.42530e+00_r8,0.83896e+00_r8,0.10596e+01_r8,0.11338e+01_r8,0.89957e+00_r8 /)
      kbo(:, 1,32,12) = (/ &
        & 0.24917e+00_r8,0.62738e+00_r8,0.83018e+00_r8,0.93886e+00_r8,0.69870e+00_r8 /)
      kbo(:, 2,32,12) = (/ &
        & 0.29180e+00_r8,0.68257e+00_r8,0.89466e+00_r8,0.99723e+00_r8,0.75819e+00_r8 /)
      kbo(:, 3,32,12) = (/ &
        & 0.33695e+00_r8,0.73898e+00_r8,0.95783e+00_r8,0.10503e+01_r8,0.81270e+00_r8 /)
      kbo(:, 4,32,12) = (/ &
        & 0.38441e+00_r8,0.79527e+00_r8,0.10172e+01_r8,0.10987e+01_r8,0.86313e+00_r8 /)
      kbo(:, 5,32,12) = (/ &
        & 0.43473e+00_r8,0.85145e+00_r8,0.10718e+01_r8,0.11436e+01_r8,0.90933e+00_r8 /)
      kbo(:, 1,33,12) = (/ &
        & 0.25524e+00_r8,0.63888e+00_r8,0.84456e+00_r8,0.95208e+00_r8,0.71177e+00_r8 /)
      kbo(:, 2,33,12) = (/ &
        & 0.29923e+00_r8,0.69477e+00_r8,0.90943e+00_r8,0.10094e+01_r8,0.77043e+00_r8 /)
      kbo(:, 3,33,12) = (/ &
        & 0.34555e+00_r8,0.75166e+00_r8,0.97211e+00_r8,0.10616e+01_r8,0.82442e+00_r8 /)
      kbo(:, 4,33,12) = (/ &
        & 0.39409e+00_r8,0.80804e+00_r8,0.10306e+01_r8,0.11094e+01_r8,0.87396e+00_r8 /)
      kbo(:, 5,33,12) = (/ &
        & 0.44532e+00_r8,0.86454e+00_r8,0.10842e+01_r8,0.11536e+01_r8,0.91947e+00_r8 /)
      kbo(:, 1,34,12) = (/ &
        & 0.26139e+00_r8,0.64937e+00_r8,0.85738e+00_r8,0.96358e+00_r8,0.72330e+00_r8 /)
      kbo(:, 2,34,12) = (/ &
        & 0.30644e+00_r8,0.70578e+00_r8,0.92238e+00_r8,0.10200e+01_r8,0.78117e+00_r8 /)
      kbo(:, 3,34,12) = (/ &
        & 0.35368e+00_r8,0.76284e+00_r8,0.98445e+00_r8,0.10715e+01_r8,0.83457e+00_r8 /)
      kbo(:, 4,34,12) = (/ &
        & 0.40294e+00_r8,0.81944e+00_r8,0.10421e+01_r8,0.11185e+01_r8,0.88331e+00_r8 /)
      kbo(:, 5,34,12) = (/ &
        & 0.45497e+00_r8,0.87610e+00_r8,0.10949e+01_r8,0.11623e+01_r8,0.92821e+00_r8 /)
      kbo(:, 1,35,12) = (/ &
        & 0.26429e+00_r8,0.65495e+00_r8,0.86437e+00_r8,0.96967e+00_r8,0.72944e+00_r8 /)
      kbo(:, 2,35,12) = (/ &
        & 0.31003e+00_r8,0.71171e+00_r8,0.92940e+00_r8,0.10257e+01_r8,0.78687e+00_r8 /)
      kbo(:, 3,35,12) = (/ &
        & 0.35779e+00_r8,0.76892e+00_r8,0.99113e+00_r8,0.10767e+01_r8,0.83993e+00_r8 /)
      kbo(:, 4,35,12) = (/ &
        & 0.40757e+00_r8,0.82572e+00_r8,0.10483e+01_r8,0.11235e+01_r8,0.88834e+00_r8 /)
      kbo(:, 5,35,12) = (/ &
        & 0.46005e+00_r8,0.88243e+00_r8,0.11007e+01_r8,0.11671e+01_r8,0.93291e+00_r8 /)
      kbo(:, 1,36,12) = (/ &
        & 0.26301e+00_r8,0.65478e+00_r8,0.86458e+00_r8,0.96965e+00_r8,0.72937e+00_r8 /)
      kbo(:, 2,36,12) = (/ &
        & 0.30906e+00_r8,0.71167e+00_r8,0.92967e+00_r8,0.10257e+01_r8,0.78687e+00_r8 /)
      kbo(:, 3,36,12) = (/ &
        & 0.35709e+00_r8,0.76907e+00_r8,0.99151e+00_r8,0.10769e+01_r8,0.84005e+00_r8 /)
      kbo(:, 4,36,12) = (/ &
        & 0.40702e+00_r8,0.82602e+00_r8,0.10488e+01_r8,0.11238e+01_r8,0.88850e+00_r8 /)
      kbo(:, 5,36,12) = (/ &
        & 0.45966e+00_r8,0.88282e+00_r8,0.11012e+01_r8,0.11674e+01_r8,0.93315e+00_r8 /)
      kbo(:, 1,37,12) = (/ &
        & 0.25532e+00_r8,0.64621e+00_r8,0.85496e+00_r8,0.96073e+00_r8,0.72018e+00_r8 /)
      kbo(:, 2,37,12) = (/ &
        & 0.30133e+00_r8,0.70315e+00_r8,0.92046e+00_r8,0.10178e+01_r8,0.77861e+00_r8 /)
      kbo(:, 3,37,12) = (/ &
        & 0.34928e+00_r8,0.76070e+00_r8,0.98300e+00_r8,0.10697e+01_r8,0.83253e+00_r8 /)
      kbo(:, 4,37,12) = (/ &
        & 0.39901e+00_r8,0.81782e+00_r8,0.10410e+01_r8,0.11173e+01_r8,0.88173e+00_r8 /)
      kbo(:, 5,37,12) = (/ &
        & 0.45136e+00_r8,0.87470e+00_r8,0.10942e+01_r8,0.11614e+01_r8,0.92694e+00_r8 /)
      kbo(:, 1,38,12) = (/ &
        & 0.24761e+00_r8,0.63742e+00_r8,0.84491e+00_r8,0.95139e+00_r8,0.71066e+00_r8 /)
      kbo(:, 2,38,12) = (/ &
        & 0.29353e+00_r8,0.69428e+00_r8,0.91068e+00_r8,0.10095e+01_r8,0.76992e+00_r8 /)
      kbo(:, 3,38,12) = (/ &
        & 0.34135e+00_r8,0.75196e+00_r8,0.97396e+00_r8,0.10621e+01_r8,0.82461e+00_r8 /)
      kbo(:, 4,38,12) = (/ &
        & 0.39084e+00_r8,0.80925e+00_r8,0.10327e+01_r8,0.11104e+01_r8,0.87459e+00_r8 /)
      kbo(:, 5,38,12) = (/ &
        & 0.44289e+00_r8,0.86617e+00_r8,0.10866e+01_r8,0.11550e+01_r8,0.92038e+00_r8 /)
      kbo(:, 1,39,12) = (/ &
        & 0.24017e+00_r8,0.62886e+00_r8,0.83503e+00_r8,0.94210e+00_r8,0.70124e+00_r8 /)
      kbo(:, 2,39,12) = (/ &
        & 0.28601e+00_r8,0.68569e+00_r8,0.90106e+00_r8,0.10011e+01_r8,0.76142e+00_r8 /)
      kbo(:, 3,39,12) = (/ &
        & 0.33368e+00_r8,0.74335e+00_r8,0.96490e+00_r8,0.10546e+01_r8,0.81673e+00_r8 /)
      kbo(:, 4,39,12) = (/ &
        & 0.38296e+00_r8,0.80081e+00_r8,0.10243e+01_r8,0.11035e+01_r8,0.86747e+00_r8 /)
      kbo(:, 5,39,12) = (/ &
        & 0.43465e+00_r8,0.85778e+00_r8,0.10791e+01_r8,0.11488e+01_r8,0.91385e+00_r8 /)
      kbo(:, 1,40,12) = (/ &
        & 0.22833e+00_r8,0.61463e+00_r8,0.81821e+00_r8,0.92620e+00_r8,0.68530e+00_r8 /)
      kbo(:, 2,40,12) = (/ &
        & 0.27395e+00_r8,0.67134e+00_r8,0.88467e+00_r8,0.98686e+00_r8,0.74688e+00_r8 /)
      kbo(:, 3,40,12) = (/ &
        & 0.32124e+00_r8,0.72890e+00_r8,0.94943e+00_r8,0.10418e+01_r8,0.80324e+00_r8 /)
      kbo(:, 4,40,12) = (/ &
        & 0.37015e+00_r8,0.78652e+00_r8,0.10100e+01_r8,0.10918e+01_r8,0.85523e+00_r8 /)
      kbo(:, 5,40,12) = (/ &
        & 0.42126e+00_r8,0.84372e+00_r8,0.10660e+01_r8,0.11379e+01_r8,0.90264e+00_r8 /)
      kbo(:, 1,41,12) = (/ &
        & 0.21612e+00_r8,0.59971e+00_r8,0.80041e+00_r8,0.90904e+00_r8,0.66824e+00_r8 /)
      kbo(:, 2,41,12) = (/ &
        & 0.26150e+00_r8,0.65630e+00_r8,0.86743e+00_r8,0.97155e+00_r8,0.73120e+00_r8 /)
      kbo(:, 3,41,12) = (/ &
        & 0.30837e+00_r8,0.71376e+00_r8,0.93288e+00_r8,0.10279e+01_r8,0.78880e+00_r8 /)
      kbo(:, 4,41,12) = (/ &
        & 0.35698e+00_r8,0.77150e+00_r8,0.99473e+00_r8,0.10791e+01_r8,0.84209e+00_r8 /)
      kbo(:, 5,41,12) = (/ &
        & 0.40745e+00_r8,0.82887e+00_r8,0.10519e+01_r8,0.11261e+01_r8,0.89062e+00_r8 /)
      kbo(:, 1,42,12) = (/ &
        & 0.20417e+00_r8,0.58472e+00_r8,0.78237e+00_r8,0.89154e+00_r8,0.65066e+00_r8 /)
      kbo(:, 2,42,12) = (/ &
        & 0.24921e+00_r8,0.64136e+00_r8,0.85007e+00_r8,0.95580e+00_r8,0.71510e+00_r8 /)
      kbo(:, 3,42,12) = (/ &
        & 0.29566e+00_r8,0.69861e+00_r8,0.91611e+00_r8,0.10137e+01_r8,0.77414e+00_r8 /)
      kbo(:, 4,42,12) = (/ &
        & 0.34395e+00_r8,0.75651e+00_r8,0.97922e+00_r8,0.10662e+01_r8,0.82865e+00_r8 /)
      kbo(:, 5,42,12) = (/ &
        & 0.39383e+00_r8,0.81397e+00_r8,0.10376e+01_r8,0.11142e+01_r8,0.87842e+00_r8 /)
      kbo(:, 1,43,12) = (/ &
        & 0.18997e+00_r8,0.56647e+00_r8,0.76032e+00_r8,0.86976e+00_r8,0.62901e+00_r8 /)
      kbo(:, 2,43,12) = (/ &
        & 0.23447e+00_r8,0.62342e+00_r8,0.82892e+00_r8,0.93617e+00_r8,0.69524e+00_r8 /)
      kbo(:, 3,43,12) = (/ &
        & 0.28050e+00_r8,0.68037e+00_r8,0.89544e+00_r8,0.99597e+00_r8,0.75607e+00_r8 /)
      kbo(:, 4,43,12) = (/ &
        & 0.32830e+00_r8,0.73817e+00_r8,0.95981e+00_r8,0.10502e+01_r8,0.81194e+00_r8 /)
      kbo(:, 5,43,12) = (/ &
        & 0.37763e+00_r8,0.79580e+00_r8,0.10196e+01_r8,0.10995e+01_r8,0.86317e+00_r8 /)
      kbo(:, 1,44,12) = (/ &
        & 0.17494e+00_r8,0.54678e+00_r8,0.73637e+00_r8,0.84544e+00_r8,0.60542e+00_r8 /)
      kbo(:, 2,44,12) = (/ &
        & 0.21877e+00_r8,0.60406e+00_r8,0.80575e+00_r8,0.91415e+00_r8,0.67322e+00_r8 /)
      kbo(:, 3,44,12) = (/ &
        & 0.26445e+00_r8,0.66075e+00_r8,0.87287e+00_r8,0.97625e+00_r8,0.73598e+00_r8 /)
      kbo(:, 4,44,12) = (/ &
        & 0.31161e+00_r8,0.71841e+00_r8,0.93827e+00_r8,0.10322e+01_r8,0.79326e+00_r8 /)
      kbo(:, 5,44,12) = (/ &
        & 0.36052e+00_r8,0.77622e+00_r8,0.99972e+00_r8,0.10831e+01_r8,0.84620e+00_r8 /)
      kbo(:, 1,45,12) = (/ &
        & 0.16016e+00_r8,0.52729e+00_r8,0.71224e+00_r8,0.82038e+00_r8,0.58172e+00_r8 /)
      kbo(:, 2,45,12) = (/ &
        & 0.20336e+00_r8,0.58455e+00_r8,0.78227e+00_r8,0.89144e+00_r8,0.65050e+00_r8 /)
      kbo(:, 3,45,12) = (/ &
        & 0.24861e+00_r8,0.64128e+00_r8,0.85023e+00_r8,0.95584e+00_r8,0.71509e+00_r8 /)
      kbo(:, 4,45,12) = (/ &
        & 0.29518e+00_r8,0.69870e+00_r8,0.91640e+00_r8,0.10138e+01_r8,0.77417e+00_r8 /)
      kbo(:, 5,45,12) = (/ &
        & 0.34361e+00_r8,0.75661e+00_r8,0.97947e+00_r8,0.10663e+01_r8,0.82874e+00_r8 /)
      kbo(:, 1,46,12) = (/ &
        & 0.14495e+00_r8,0.50668e+00_r8,0.68614e+00_r8,0.79268e+00_r8,0.55619e+00_r8 /)
      kbo(:, 2,46,12) = (/ &
        & 0.18729e+00_r8,0.56366e+00_r8,0.75707e+00_r8,0.86650e+00_r8,0.62580e+00_r8 /)
      kbo(:, 3,46,12) = (/ &
        & 0.23189e+00_r8,0.62077e+00_r8,0.82600e+00_r8,0.93336e+00_r8,0.69232e+00_r8 /)
      kbo(:, 4,46,12) = (/ &
        & 0.27798e+00_r8,0.67784e+00_r8,0.89269e+00_r8,0.99345e+00_r8,0.75352e+00_r8 /)
      kbo(:, 5,46,12) = (/ &
        & 0.32583e+00_r8,0.73560e+00_r8,0.95715e+00_r8,0.10480e+01_r8,0.80957e+00_r8 /)
      kbo(:, 1,47,12) = (/ &
        & 0.12858e+00_r8,0.48369e+00_r8,0.65638e+00_r8,0.76017e+00_r8,0.52730e+00_r8 /)
      kbo(:, 2,47,12) = (/ &
        & 0.16969e+00_r8,0.54041e+00_r8,0.72859e+00_r8,0.83745e+00_r8,0.59783e+00_r8 /)
      kbo(:, 3,47,12) = (/ &
        & 0.21344e+00_r8,0.59783e+00_r8,0.79837e+00_r8,0.90704e+00_r8,0.66606e+00_r8 /)
      kbo(:, 4,47,12) = (/ &
        & 0.25910e+00_r8,0.65455e+00_r8,0.86586e+00_r8,0.96989e+00_r8,0.72949e+00_r8 /)
      kbo(:, 5,47,12) = (/ &
        & 0.30618e+00_r8,0.71222e+00_r8,0.93155e+00_r8,0.10265e+01_r8,0.78728e+00_r8 /)
      kbo(:, 1,48,12) = (/ &
        & 0.11298e+00_r8,0.46082e+00_r8,0.62642e+00_r8,0.72640e+00_r8,0.49809e+00_r8 /)
      kbo(:, 2,48,12) = (/ &
        & 0.15246e+00_r8,0.51740e+00_r8,0.69983e+00_r8,0.80735e+00_r8,0.56961e+00_r8 /)
      kbo(:, 3,48,12) = (/ &
        & 0.19539e+00_r8,0.57459e+00_r8,0.77041e+00_r8,0.87978e+00_r8,0.63885e+00_r8 /)
      kbo(:, 4,48,12) = (/ &
        & 0.24045e+00_r8,0.63157e+00_r8,0.83892e+00_r8,0.94534e+00_r8,0.70441e+00_r8 /)
      kbo(:, 5,48,12) = (/ &
        & 0.28683e+00_r8,0.68881e+00_r8,0.90534e+00_r8,0.10043e+01_r8,0.76449e+00_r8 /)
      kbo(:, 1,49,12) = (/ &
        & 0.98247e-01_r8,0.43787e+00_r8,0.59630e+00_r8,0.69142e+00_r8,0.46886e+00_r8 /)
      kbo(:, 2,49,12) = (/ &
        & 0.13602e+00_r8,0.49453e+00_r8,0.67051e+00_r8,0.77567e+00_r8,0.54098e+00_r8 /)
      kbo(:, 3,49,12) = (/ &
        & 0.17773e+00_r8,0.55136e+00_r8,0.74221e+00_r8,0.85142e+00_r8,0.61109e+00_r8 /)
      kbo(:, 4,49,12) = (/ &
        & 0.22196e+00_r8,0.60876e+00_r8,0.81162e+00_r8,0.91969e+00_r8,0.67863e+00_r8 /)
      kbo(:, 5,49,12) = (/ &
        & 0.26789e+00_r8,0.66564e+00_r8,0.87866e+00_r8,0.98128e+00_r8,0.74108e+00_r8 /)
      kbo(:, 1,50,12) = (/ &
        & 0.85448e-01_r8,0.41621e+00_r8,0.56763e+00_r8,0.65757e+00_r8,0.44117e+00_r8 /)
      kbo(:, 2,50,12) = (/ &
        & 0.12109e+00_r8,0.47310e+00_r8,0.64247e+00_r8,0.74462e+00_r8,0.51379e+00_r8 /)
      kbo(:, 3,50,12) = (/ &
        & 0.16156e+00_r8,0.52985e+00_r8,0.71554e+00_r8,0.82373e+00_r8,0.58488e+00_r8 /)
      kbo(:, 4,50,12) = (/ &
        & 0.20488e+00_r8,0.58711e+00_r8,0.78559e+00_r8,0.89468e+00_r8,0.65362e+00_r8 /)
      kbo(:, 5,50,12) = (/ &
        & 0.25037e+00_r8,0.64398e+00_r8,0.85353e+00_r8,0.95880e+00_r8,0.71804e+00_r8 /)
      kbo(:, 1,51,12) = (/ &
        & 0.73759e-01_r8,0.39485e+00_r8,0.53977e+00_r8,0.62407e+00_r8,0.41437e+00_r8 /)
      kbo(:, 2,51,12) = (/ &
        & 0.10727e+00_r8,0.45237e+00_r8,0.61531e+00_r8,0.71353e+00_r8,0.48727e+00_r8 /)
      kbo(:, 3,51,12) = (/ &
        & 0.14620e+00_r8,0.50899e+00_r8,0.68916e+00_r8,0.79586e+00_r8,0.55909e+00_r8 /)
      kbo(:, 4,51,12) = (/ &
        & 0.18867e+00_r8,0.56597e+00_r8,0.76009e+00_r8,0.86950e+00_r8,0.62868e+00_r8 /)
      kbo(:, 5,51,12) = (/ &
        & 0.23351e+00_r8,0.62321e+00_r8,0.82900e+00_r8,0.93613e+00_r8,0.69507e+00_r8 /)
      kbo(:, 1,52,12) = (/ &
        & 0.62975e-01_r8,0.37352e+00_r8,0.51168e+00_r8,0.59007e+00_r8,0.38790e+00_r8 /)
      kbo(:, 2,52,12) = (/ &
        & 0.94238e-01_r8,0.43155e+00_r8,0.58786e+00_r8,0.68153e+00_r8,0.46072e+00_r8 /)
      kbo(:, 3,52,12) = (/ &
        & 0.13138e+00_r8,0.48824e+00_r8,0.66233e+00_r8,0.76673e+00_r8,0.53305e+00_r8 /)
      kbo(:, 4,52,12) = (/ &
        & 0.17291e+00_r8,0.54507e+00_r8,0.73444e+00_r8,0.84335e+00_r8,0.60343e+00_r8 /)
      kbo(:, 5,52,12) = (/ &
        & 0.21681e+00_r8,0.60245e+00_r8,0.80402e+00_r8,0.91249e+00_r8,0.67147e+00_r8 /)
      kbo(:, 1,53,12) = (/ &
        & 0.53060e-01_r8,0.35230e+00_r8,0.48353e+00_r8,0.55561e+00_r8,0.36178e+00_r8 /)
      kbo(:, 2,53,12) = (/ &
        & 0.81984e-01_r8,0.41041e+00_r8,0.56005e+00_r8,0.64855e+00_r8,0.43393e+00_r8 /)
      kbo(:, 3,53,12) = (/ &
        & 0.11713e+00_r8,0.46754e+00_r8,0.63518e+00_r8,0.73640e+00_r8,0.50665e+00_r8 /)
      kbo(:, 4,53,12) = (/ &
        & 0.15723e+00_r8,0.52417e+00_r8,0.70847e+00_r8,0.81636e+00_r8,0.57800e+00_r8 /)
      kbo(:, 5,53,12) = (/ &
        & 0.20038e+00_r8,0.58144e+00_r8,0.77877e+00_r8,0.88807e+00_r8,0.64700e+00_r8 /)
      kbo(:, 1,54,12) = (/ &
        & 0.44825e-01_r8,0.33285e+00_r8,0.45764e+00_r8,0.52392e+00_r8,0.33821e+00_r8 /)
      kbo(:, 2,54,12) = (/ &
        & 0.71480e-01_r8,0.39083e+00_r8,0.53456e+00_r8,0.61778e+00_r8,0.40943e+00_r8 /)
      kbo(:, 3,54,12) = (/ &
        & 0.10463e+00_r8,0.44857e+00_r8,0.61031e+00_r8,0.70773e+00_r8,0.48234e+00_r8 /)
      kbo(:, 4,54,12) = (/ &
        & 0.14329e+00_r8,0.50511e+00_r8,0.68427e+00_r8,0.79060e+00_r8,0.55433e+00_r8 /)
      kbo(:, 5,54,12) = (/ &
        & 0.18561e+00_r8,0.56209e+00_r8,0.75543e+00_r8,0.86487e+00_r8,0.62409e+00_r8 /)
      kbo(:, 1,55,12) = (/ &
        & 0.37713e-01_r8,0.31417e+00_r8,0.43292e+00_r8,0.49354e+00_r8,0.31617e+00_r8 /)
      kbo(:, 2,55,12) = (/ &
        & 0.62120e-01_r8,0.37210e+00_r8,0.50985e+00_r8,0.58786e+00_r8,0.38623e+00_r8 /)
      kbo(:, 3,55,12) = (/ &
        & 0.93283e-01_r8,0.43021e+00_r8,0.58608e+00_r8,0.67950e+00_r8,0.45902e+00_r8 /)
      kbo(:, 4,55,12) = (/ &
        & 0.13035e+00_r8,0.48690e+00_r8,0.66064e+00_r8,0.76487e+00_r8,0.53142e+00_r8 /)
      kbo(:, 5,55,12) = (/ &
        & 0.17183e+00_r8,0.54374e+00_r8,0.73284e+00_r8,0.84168e+00_r8,0.60189e+00_r8 /)
      kbo(:, 1,56,12) = (/ &
        & 0.31364e-01_r8,0.29533e+00_r8,0.40826e+00_r8,0.46346e+00_r8,0.29456e+00_r8 /)
      kbo(:, 2,56,12) = (/ &
        & 0.53447e-01_r8,0.35352e+00_r8,0.48522e+00_r8,0.55771e+00_r8,0.36336e+00_r8 /)
      kbo(:, 3,56,12) = (/ &
        & 0.82579e-01_r8,0.41171e+00_r8,0.56173e+00_r8,0.65061e+00_r8,0.43556e+00_r8 /)
      kbo(:, 4,56,12) = (/ &
        & 0.11788e+00_r8,0.46877e+00_r8,0.63683e+00_r8,0.73828e+00_r8,0.50830e+00_r8 /)
      kbo(:, 5,56,12) = (/ &
        & 0.15810e+00_r8,0.52547e+00_r8,0.71011e+00_r8,0.81806e+00_r8,0.57961e+00_r8 /)
      kbo(:, 1,57,12) = (/ &
        & 0.25728e-01_r8,0.27641e+00_r8,0.38366e+00_r8,0.43364e+00_r8,0.27324e+00_r8 /)
      kbo(:, 2,57,12) = (/ &
        & 0.45538e-01_r8,0.33495e+00_r8,0.46047e+00_r8,0.52741e+00_r8,0.34078e+00_r8 /)
      kbo(:, 3,57,12) = (/ &
        & 0.72492e-01_r8,0.39302e+00_r8,0.53741e+00_r8,0.62128e+00_r8,0.41216e+00_r8 /)
      kbo(:, 4,57,12) = (/ &
        & 0.10590e+00_r8,0.45065e+00_r8,0.61311e+00_r8,0.71103e+00_r8,0.48510e+00_r8 /)
      kbo(:, 5,57,12) = (/ &
        & 0.14476e+00_r8,0.50725e+00_r8,0.68700e+00_r8,0.79354e+00_r8,0.55702e+00_r8 /)
      kbo(:, 1,58,12) = (/ &
        & 0.21034e-01_r8,0.25862e+00_r8,0.36035e+00_r8,0.40559e+00_r8,0.25327e+00_r8 /)
      kbo(:, 2,58,12) = (/ &
        & 0.38718e-01_r8,0.31732e+00_r8,0.43714e+00_r8,0.49876e+00_r8,0.31992e+00_r8 /)
      kbo(:, 3,58,12) = (/ &
        & 0.63552e-01_r8,0.37529e+00_r8,0.51407e+00_r8,0.59305e+00_r8,0.39018e+00_r8 /)
      kbo(:, 4,58,12) = (/ &
        & 0.95105e-01_r8,0.43334e+00_r8,0.59030e+00_r8,0.68443e+00_r8,0.46307e+00_r8 /)
      kbo(:, 5,58,12) = (/ &
        & 0.13248e+00_r8,0.49002e+00_r8,0.66471e+00_r8,0.76934e+00_r8,0.53538e+00_r8 /)
      kbo(:, 1,59,12) = (/ &
        & 0.19312e-01_r8,0.25156e+00_r8,0.35103e+00_r8,0.39450e+00_r8,0.24538e+00_r8 /)
      kbo(:, 2,59,12) = (/ &
        & 0.36163e-01_r8,0.31020e+00_r8,0.42773e+00_r8,0.48723e+00_r8,0.31163e+00_r8 /)
      kbo(:, 3,59,12) = (/ &
        & 0.60143e-01_r8,0.36820e+00_r8,0.50471e+00_r8,0.58164e+00_r8,0.38146e+00_r8 /)
      kbo(:, 4,59,12) = (/ &
        & 0.90924e-01_r8,0.42637e+00_r8,0.58105e+00_r8,0.67358e+00_r8,0.45417e+00_r8 /)
      kbo(:, 5,59,12) = (/ &
        & 0.12765e+00_r8,0.48313e+00_r8,0.65572e+00_r8,0.75941e+00_r8,0.52665e+00_r8 /)
      kbo(:, 1,13,13) = (/ &
        & 0.25702e+01_r8,0.27735e+01_r8,0.28760e+01_r8,0.25966e+01_r8,0.23968e+01_r8 /)
      kbo(:, 2,13,13) = (/ &
        & 0.25597e+01_r8,0.27776e+01_r8,0.28903e+01_r8,0.26158e+01_r8,0.24224e+01_r8 /)
      kbo(:, 3,13,13) = (/ &
        & 0.25494e+01_r8,0.27801e+01_r8,0.29040e+01_r8,0.26351e+01_r8,0.24494e+01_r8 /)
      kbo(:, 4,13,13) = (/ &
        & 0.25338e+01_r8,0.27802e+01_r8,0.29182e+01_r8,0.26543e+01_r8,0.24747e+01_r8 /)
      kbo(:, 5,13,13) = (/ &
        & 0.25177e+01_r8,0.27760e+01_r8,0.29320e+01_r8,0.26728e+01_r8,0.24963e+01_r8 /)
      kbo(:, 1,14,13) = (/ &
        & 0.23659e+01_r8,0.26936e+01_r8,0.28410e+01_r8,0.26130e+01_r8,0.23363e+01_r8 /)
      kbo(:, 2,14,13) = (/ &
        & 0.23577e+01_r8,0.27024e+01_r8,0.28615e+01_r8,0.26344e+01_r8,0.23684e+01_r8 /)
      kbo(:, 3,14,13) = (/ &
        & 0.23468e+01_r8,0.27102e+01_r8,0.28819e+01_r8,0.26565e+01_r8,0.24004e+01_r8 /)
      kbo(:, 4,14,13) = (/ &
        & 0.23350e+01_r8,0.27153e+01_r8,0.29051e+01_r8,0.26785e+01_r8,0.24267e+01_r8 /)
      kbo(:, 5,14,13) = (/ &
        & 0.23244e+01_r8,0.27141e+01_r8,0.29262e+01_r8,0.26967e+01_r8,0.24480e+01_r8 /)
      kbo(:, 1,15,13) = (/ &
        & 0.21606e+01_r8,0.25927e+01_r8,0.27805e+01_r8,0.26146e+01_r8,0.22773e+01_r8 /)
      kbo(:, 2,15,13) = (/ &
        & 0.21537e+01_r8,0.26084e+01_r8,0.28087e+01_r8,0.26417e+01_r8,0.23162e+01_r8 /)
      kbo(:, 3,15,13) = (/ &
        & 0.21448e+01_r8,0.26237e+01_r8,0.28408e+01_r8,0.26683e+01_r8,0.23515e+01_r8 /)
      kbo(:, 4,15,13) = (/ &
        & 0.21380e+01_r8,0.26327e+01_r8,0.28720e+01_r8,0.26931e+01_r8,0.23792e+01_r8 /)
      kbo(:, 5,15,13) = (/ &
        & 0.21347e+01_r8,0.26387e+01_r8,0.29018e+01_r8,0.27159e+01_r8,0.24036e+01_r8 /)
      kbo(:, 1,16,13) = (/ &
        & 0.19588e+01_r8,0.24824e+01_r8,0.27086e+01_r8,0.26036e+01_r8,0.22170e+01_r8 /)
      kbo(:, 2,16,13) = (/ &
        & 0.19544e+01_r8,0.25053e+01_r8,0.27466e+01_r8,0.26370e+01_r8,0.22638e+01_r8 /)
      kbo(:, 3,16,13) = (/ &
        & 0.19508e+01_r8,0.25256e+01_r8,0.27882e+01_r8,0.26694e+01_r8,0.23023e+01_r8 /)
      kbo(:, 4,16,13) = (/ &
        & 0.19522e+01_r8,0.25422e+01_r8,0.28288e+01_r8,0.26997e+01_r8,0.23338e+01_r8 /)
      kbo(:, 5,16,13) = (/ &
        & 0.19669e+01_r8,0.25568e+01_r8,0.28660e+01_r8,0.27268e+01_r8,0.23639e+01_r8 /)
      kbo(:, 1,17,13) = (/ &
        & 0.17683e+01_r8,0.23717e+01_r8,0.26296e+01_r8,0.25828e+01_r8,0.21586e+01_r8 /)
      kbo(:, 2,17,13) = (/ &
        & 0.17670e+01_r8,0.24002e+01_r8,0.26798e+01_r8,0.26243e+01_r8,0.22104e+01_r8 /)
      kbo(:, 3,17,13) = (/ &
        & 0.17705e+01_r8,0.24261e+01_r8,0.27313e+01_r8,0.26643e+01_r8,0.22525e+01_r8 /)
      kbo(:, 4,17,13) = (/ &
        & 0.17889e+01_r8,0.24495e+01_r8,0.27802e+01_r8,0.27001e+01_r8,0.22912e+01_r8 /)
      kbo(:, 5,17,13) = (/ &
        & 0.18206e+01_r8,0.24734e+01_r8,0.28261e+01_r8,0.27304e+01_r8,0.23278e+01_r8 /)
      kbo(:, 1,18,13) = (/ &
        & 0.15903e+01_r8,0.22606e+01_r8,0.25530e+01_r8,0.25561e+01_r8,0.21033e+01_r8 /)
      kbo(:, 2,18,13) = (/ &
        & 0.15961e+01_r8,0.22974e+01_r8,0.26139e+01_r8,0.26069e+01_r8,0.21585e+01_r8 /)
      kbo(:, 3,18,13) = (/ &
        & 0.16151e+01_r8,0.23303e+01_r8,0.26738e+01_r8,0.26546e+01_r8,0.22069e+01_r8 /)
      kbo(:, 4,18,13) = (/ &
        & 0.16495e+01_r8,0.23625e+01_r8,0.27316e+01_r8,0.26970e+01_r8,0.22532e+01_r8 /)
      kbo(:, 5,18,13) = (/ &
        & 0.16970e+01_r8,0.23957e+01_r8,0.27859e+01_r8,0.27320e+01_r8,0.22970e+01_r8 /)
      kbo(:, 1,19,13) = (/ &
        & 0.14257e+01_r8,0.21563e+01_r8,0.24826e+01_r8,0.25271e+01_r8,0.20500e+01_r8 /)
      kbo(:, 2,19,13) = (/ &
        & 0.14448e+01_r8,0.21999e+01_r8,0.25521e+01_r8,0.25882e+01_r8,0.21113e+01_r8 /)
      kbo(:, 3,19,13) = (/ &
        & 0.14809e+01_r8,0.22420e+01_r8,0.26202e+01_r8,0.26436e+01_r8,0.21676e+01_r8 /)
      kbo(:, 4,19,13) = (/ &
        & 0.15301e+01_r8,0.22839e+01_r8,0.26861e+01_r8,0.26918e+01_r8,0.22215e+01_r8 /)
      kbo(:, 5,19,13) = (/ &
        & 0.15917e+01_r8,0.23278e+01_r8,0.27486e+01_r8,0.27324e+01_r8,0.22720e+01_r8 /)
      kbo(:, 1,20,13) = (/ &
        & 0.12800e+01_r8,0.20626e+01_r8,0.24230e+01_r8,0.25008e+01_r8,0.20040e+01_r8 /)
      kbo(:, 2,20,13) = (/ &
        & 0.13152e+01_r8,0.21132e+01_r8,0.24996e+01_r8,0.25711e+01_r8,0.20725e+01_r8 /)
      kbo(:, 3,20,13) = (/ &
        & 0.13653e+01_r8,0.21643e+01_r8,0.25750e+01_r8,0.26341e+01_r8,0.21362e+01_r8 /)
      kbo(:, 4,20,13) = (/ &
        & 0.14290e+01_r8,0.22166e+01_r8,0.26493e+01_r8,0.26871e+01_r8,0.21969e+01_r8 /)
      kbo(:, 5,20,13) = (/ &
        & 0.15047e+01_r8,0.22739e+01_r8,0.27186e+01_r8,0.27332e+01_r8,0.22536e+01_r8 /)
      kbo(:, 1,21,13) = (/ &
        & 0.11565e+01_r8,0.19804e+01_r8,0.23723e+01_r8,0.24790e+01_r8,0.19652e+01_r8 /)
      kbo(:, 2,21,13) = (/ &
        & 0.12043e+01_r8,0.20401e+01_r8,0.24563e+01_r8,0.25572e+01_r8,0.20406e+01_r8 /)
      kbo(:, 3,21,13) = (/ &
        & 0.12682e+01_r8,0.20995e+01_r8,0.25386e+01_r8,0.26265e+01_r8,0.21117e+01_r8 /)
      kbo(:, 4,21,13) = (/ &
        & 0.13446e+01_r8,0.21634e+01_r8,0.26197e+01_r8,0.26846e+01_r8,0.21783e+01_r8 /)
      kbo(:, 5,21,13) = (/ &
        & 0.14328e+01_r8,0.22322e+01_r8,0.26943e+01_r8,0.27351e+01_r8,0.22400e+01_r8 /)
      kbo(:, 1,22,13) = (/ &
        & 0.10567e+01_r8,0.19161e+01_r8,0.23380e+01_r8,0.24675e+01_r8,0.19394e+01_r8 /)
      kbo(:, 2,22,13) = (/ &
        & 0.11171e+01_r8,0.19843e+01_r8,0.24279e+01_r8,0.25525e+01_r8,0.20217e+01_r8 /)
      kbo(:, 3,22,13) = (/ &
        & 0.11926e+01_r8,0.20529e+01_r8,0.25167e+01_r8,0.26264e+01_r8,0.20987e+01_r8 /)
      kbo(:, 4,22,13) = (/ &
        & 0.12819e+01_r8,0.21280e+01_r8,0.26028e+01_r8,0.26881e+01_r8,0.21696e+01_r8 /)
      kbo(:, 5,22,13) = (/ &
        & 0.13818e+01_r8,0.22069e+01_r8,0.26807e+01_r8,0.27417e+01_r8,0.22350e+01_r8 /)
      kbo(:, 1,23,13) = (/ &
        & 0.97722e+00_r8,0.18665e+01_r8,0.23140e+01_r8,0.24623e+01_r8,0.19226e+01_r8 /)
      kbo(:, 2,23,13) = (/ &
        & 0.10487e+01_r8,0.19424e+01_r8,0.24103e+01_r8,0.25530e+01_r8,0.20109e+01_r8 /)
      kbo(:, 3,23,13) = (/ &
        & 0.11351e+01_r8,0.20216e+01_r8,0.25035e+01_r8,0.26294e+01_r8,0.20926e+01_r8 /)
      kbo(:, 4,23,13) = (/ &
        & 0.12356e+01_r8,0.21056e+01_r8,0.25931e+01_r8,0.26937e+01_r8,0.21670e+01_r8 /)
      kbo(:, 5,23,13) = (/ &
        & 0.13470e+01_r8,0.21926e+01_r8,0.26734e+01_r8,0.27495e+01_r8,0.22345e+01_r8 /)
      kbo(:, 1,24,13) = (/ &
        & 0.91609e+00_r8,0.18302e+01_r8,0.23004e+01_r8,0.24641e+01_r8,0.19149e+01_r8 /)
      kbo(:, 2,24,13) = (/ &
        & 0.99757e+00_r8,0.19150e+01_r8,0.24014e+01_r8,0.25579e+01_r8,0.20076e+01_r8 /)
      kbo(:, 3,24,13) = (/ &
        & 0.10945e+01_r8,0.20031e+01_r8,0.24987e+01_r8,0.26360e+01_r8,0.20926e+01_r8 /)
      kbo(:, 4,24,13) = (/ &
        & 0.12058e+01_r8,0.20942e+01_r8,0.25896e+01_r8,0.27020e+01_r8,0.21691e+01_r8 /)
      kbo(:, 5,24,13) = (/ &
        & 0.13269e+01_r8,0.21869e+01_r8,0.26718e+01_r8,0.27594e+01_r8,0.22381e+01_r8 /)
      kbo(:, 1,25,13) = (/ &
        & 0.87183e+00_r8,0.18068e+01_r8,0.22964e+01_r8,0.24719e+01_r8,0.19153e+01_r8 /)
      kbo(:, 2,25,13) = (/ &
        & 0.96269e+00_r8,0.19004e+01_r8,0.24012e+01_r8,0.25669e+01_r8,0.20109e+01_r8 /)
      kbo(:, 3,25,13) = (/ &
        & 0.10701e+01_r8,0.19953e+01_r8,0.24998e+01_r8,0.26458e+01_r8,0.20980e+01_r8 /)
      kbo(:, 4,25,13) = (/ &
        & 0.11910e+01_r8,0.20919e+01_r8,0.25913e+01_r8,0.27126e+01_r8,0.21754e+01_r8 /)
      kbo(:, 5,25,13) = (/ &
        & 0.13188e+01_r8,0.21891e+01_r8,0.26749e+01_r8,0.27711e+01_r8,0.22449e+01_r8 /)
      kbo(:, 1,26,13) = (/ &
        & 0.84313e+00_r8,0.17965e+01_r8,0.23011e+01_r8,0.24858e+01_r8,0.19238e+01_r8 /)
      kbo(:, 2,26,13) = (/ &
        & 0.94434e+00_r8,0.18970e+01_r8,0.24073e+01_r8,0.25798e+01_r8,0.20205e+01_r8 /)
      kbo(:, 3,26,13) = (/ &
        & 0.10612e+01_r8,0.19972e+01_r8,0.25069e+01_r8,0.26589e+01_r8,0.21080e+01_r8 /)
      kbo(:, 4,26,13) = (/ &
        & 0.11887e+01_r8,0.20979e+01_r8,0.25988e+01_r8,0.27257e+01_r8,0.21853e+01_r8 /)
      kbo(:, 5,26,13) = (/ &
        & 0.13225e+01_r8,0.21985e+01_r8,0.26831e+01_r8,0.27841e+01_r8,0.22550e+01_r8 /)
      kbo(:, 1,27,13) = (/ &
        & 0.82783e+00_r8,0.17960e+01_r8,0.23110e+01_r8,0.25019e+01_r8,0.19363e+01_r8 /)
      kbo(:, 2,27,13) = (/ &
        & 0.93873e+00_r8,0.19014e+01_r8,0.24182e+01_r8,0.25950e+01_r8,0.20338e+01_r8 /)
      kbo(:, 3,27,13) = (/ &
        & 0.10628e+01_r8,0.20052e+01_r8,0.25176e+01_r8,0.26735e+01_r8,0.21206e+01_r8 /)
      kbo(:, 4,27,13) = (/ &
        & 0.11961e+01_r8,0.21092e+01_r8,0.26097e+01_r8,0.27398e+01_r8,0.21974e+01_r8 /)
      kbo(:, 5,27,13) = (/ &
        & 0.13342e+01_r8,0.22123e+01_r8,0.26944e+01_r8,0.27973e+01_r8,0.22665e+01_r8 /)
      kbo(:, 1,28,13) = (/ &
        & 0.82452e+00_r8,0.18027e+01_r8,0.23247e+01_r8,0.25200e+01_r8,0.19523e+01_r8 /)
      kbo(:, 2,28,13) = (/ &
        & 0.94277e+00_r8,0.19121e+01_r8,0.24323e+01_r8,0.26114e+01_r8,0.20494e+01_r8 /)
      kbo(:, 3,28,13) = (/ &
        & 0.10725e+01_r8,0.20183e+01_r8,0.25313e+01_r8,0.26888e+01_r8,0.21352e+01_r8 /)
      kbo(:, 4,28,13) = (/ &
        & 0.12107e+01_r8,0.21244e+01_r8,0.26233e+01_r8,0.27544e+01_r8,0.22110e+01_r8 /)
      kbo(:, 5,28,13) = (/ &
        & 0.13516e+01_r8,0.22292e+01_r8,0.27078e+01_r8,0.28106e+01_r8,0.22794e+01_r8 /)
      kbo(:, 1,29,13) = (/ &
        & 0.83075e+00_r8,0.18160e+01_r8,0.23425e+01_r8,0.25401e+01_r8,0.19712e+01_r8 /)
      kbo(:, 2,29,13) = (/ &
        & 0.95513e+00_r8,0.19278e+01_r8,0.24494e+01_r8,0.26294e+01_r8,0.20669e+01_r8 /)
      kbo(:, 3,29,13) = (/ &
        & 0.10900e+01_r8,0.20358e+01_r8,0.25478e+01_r8,0.27053e+01_r8,0.21513e+01_r8 /)
      kbo(:, 4,29,13) = (/ &
        & 0.12315e+01_r8,0.21431e+01_r8,0.26391e+01_r8,0.27692e+01_r8,0.22259e+01_r8 /)
      kbo(:, 5,29,13) = (/ &
        & 0.13745e+01_r8,0.22488e+01_r8,0.27235e+01_r8,0.28240e+01_r8,0.22934e+01_r8 /)
      kbo(:, 1,30,13) = (/ &
        & 0.84416e+00_r8,0.18336e+01_r8,0.23624e+01_r8,0.25609e+01_r8,0.19916e+01_r8 /)
      kbo(:, 2,30,13) = (/ &
        & 0.97368e+00_r8,0.19464e+01_r8,0.24682e+01_r8,0.26481e+01_r8,0.20854e+01_r8 /)
      kbo(:, 3,30,13) = (/ &
        & 0.11126e+01_r8,0.20559e+01_r8,0.25658e+01_r8,0.27219e+01_r8,0.21680e+01_r8 /)
      kbo(:, 4,30,13) = (/ &
        & 0.12564e+01_r8,0.21643e+01_r8,0.26566e+01_r8,0.27840e+01_r8,0.22414e+01_r8 /)
      kbo(:, 5,30,13) = (/ &
        & 0.14008e+01_r8,0.22700e+01_r8,0.27405e+01_r8,0.28371e+01_r8,0.23076e+01_r8 /)
      kbo(:, 1,31,13) = (/ &
        & 0.86384e+00_r8,0.18548e+01_r8,0.23844e+01_r8,0.25824e+01_r8,0.20133e+01_r8 /)
      kbo(:, 2,31,13) = (/ &
        & 0.99753e+00_r8,0.19681e+01_r8,0.24888e+01_r8,0.26671e+01_r8,0.21046e+01_r8 /)
      kbo(:, 3,31,13) = (/ &
        & 0.11394e+01_r8,0.20787e+01_r8,0.25856e+01_r8,0.27387e+01_r8,0.21855e+01_r8 /)
      kbo(:, 4,31,13) = (/ &
        & 0.12850e+01_r8,0.21876e+01_r8,0.26758e+01_r8,0.27988e+01_r8,0.22577e+01_r8 /)
      kbo(:, 5,31,13) = (/ &
        & 0.14304e+01_r8,0.22931e+01_r8,0.27584e+01_r8,0.28498e+01_r8,0.23225e+01_r8 /)
      kbo(:, 1,32,13) = (/ &
        & 0.88808e+00_r8,0.18788e+01_r8,0.24078e+01_r8,0.26044e+01_r8,0.20359e+01_r8 /)
      kbo(:, 2,32,13) = (/ &
        & 0.10254e+01_r8,0.19921e+01_r8,0.25106e+01_r8,0.26862e+01_r8,0.21246e+01_r8 /)
      kbo(:, 3,32,13) = (/ &
        & 0.11696e+01_r8,0.21031e+01_r8,0.26064e+01_r8,0.27554e+01_r8,0.22034e+01_r8 /)
      kbo(:, 4,32,13) = (/ &
        & 0.13164e+01_r8,0.22122e+01_r8,0.26955e+01_r8,0.28135e+01_r8,0.22742e+01_r8 /)
      kbo(:, 5,32,13) = (/ &
        & 0.14621e+01_r8,0.23175e+01_r8,0.27772e+01_r8,0.28624e+01_r8,0.23376e+01_r8 /)
      kbo(:, 1,33,13) = (/ &
        & 0.91576e+00_r8,0.19044e+01_r8,0.24318e+01_r8,0.26262e+01_r8,0.20585e+01_r8 /)
      kbo(:, 2,33,13) = (/ &
        & 0.10563e+01_r8,0.20178e+01_r8,0.25332e+01_r8,0.27053e+01_r8,0.21448e+01_r8 /)
      kbo(:, 3,33,13) = (/ &
        & 0.12022e+01_r8,0.21286e+01_r8,0.26280e+01_r8,0.27719e+01_r8,0.22216e+01_r8 /)
      kbo(:, 4,33,13) = (/ &
        & 0.13498e+01_r8,0.22379e+01_r8,0.27158e+01_r8,0.28276e+01_r8,0.22909e+01_r8 /)
      kbo(:, 5,33,13) = (/ &
        & 0.14952e+01_r8,0.23427e+01_r8,0.27963e+01_r8,0.28748e+01_r8,0.23524e+01_r8 /)
      kbo(:, 1,34,13) = (/ &
        & 0.94113e+00_r8,0.19270e+01_r8,0.24527e+01_r8,0.26448e+01_r8,0.20775e+01_r8 /)
      kbo(:, 2,34,13) = (/ &
        & 0.10840e+01_r8,0.20405e+01_r8,0.25528e+01_r8,0.27213e+01_r8,0.21619e+01_r8 /)
      kbo(:, 3,34,13) = (/ &
        & 0.12311e+01_r8,0.21512e+01_r8,0.26466e+01_r8,0.27855e+01_r8,0.22370e+01_r8 /)
      kbo(:, 4,34,13) = (/ &
        & 0.13793e+01_r8,0.22602e+01_r8,0.27333e+01_r8,0.28395e+01_r8,0.23050e+01_r8 /)
      kbo(:, 5,34,13) = (/ &
        & 0.15242e+01_r8,0.23644e+01_r8,0.28128e+01_r8,0.28850e+01_r8,0.23650e+01_r8 /)
      kbo(:, 1,35,13) = (/ &
        & 0.95467e+00_r8,0.19391e+01_r8,0.24637e+01_r8,0.26549e+01_r8,0.20879e+01_r8 /)
      kbo(:, 2,35,13) = (/ &
        & 0.10989e+01_r8,0.20529e+01_r8,0.25635e+01_r8,0.27301e+01_r8,0.21712e+01_r8 /)
      kbo(:, 3,35,13) = (/ &
        & 0.12468e+01_r8,0.21638e+01_r8,0.26569e+01_r8,0.27931e+01_r8,0.22456e+01_r8 /)
      kbo(:, 4,35,13) = (/ &
        & 0.13953e+01_r8,0.22726e+01_r8,0.27430e+01_r8,0.28463e+01_r8,0.23128e+01_r8 /)
      kbo(:, 5,35,13) = (/ &
        & 0.15401e+01_r8,0.23764e+01_r8,0.28219e+01_r8,0.28908e+01_r8,0.23721e+01_r8 /)
      kbo(:, 1,36,13) = (/ &
        & 0.95401e+00_r8,0.19393e+01_r8,0.24641e+01_r8,0.26563e+01_r8,0.20890e+01_r8 /)
      kbo(:, 2,36,13) = (/ &
        & 0.10986e+01_r8,0.20534e+01_r8,0.25640e+01_r8,0.27314e+01_r8,0.21722e+01_r8 /)
      kbo(:, 3,36,13) = (/ &
        & 0.12470e+01_r8,0.21646e+01_r8,0.26577e+01_r8,0.27946e+01_r8,0.22466e+01_r8 /)
      kbo(:, 4,36,13) = (/ &
        & 0.13959e+01_r8,0.22738e+01_r8,0.27440e+01_r8,0.28477e+01_r8,0.23138e+01_r8 /)
      kbo(:, 5,36,13) = (/ &
        & 0.15410e+01_r8,0.23778e+01_r8,0.28230e+01_r8,0.28922e+01_r8,0.23732e+01_r8 /)
      kbo(:, 1,37,13) = (/ &
        & 0.93269e+00_r8,0.19221e+01_r8,0.24490e+01_r8,0.26452e+01_r8,0.20765e+01_r8 /)
      kbo(:, 2,37,13) = (/ &
        & 0.10767e+01_r8,0.20372e+01_r8,0.25499e+01_r8,0.27223e+01_r8,0.21614e+01_r8 /)
      kbo(:, 3,37,13) = (/ &
        & 0.12250e+01_r8,0.21490e+01_r8,0.26449e+01_r8,0.27873e+01_r8,0.22369e+01_r8 /)
      kbo(:, 4,37,13) = (/ &
        & 0.13744e+01_r8,0.22588e+01_r8,0.27324e+01_r8,0.28416e+01_r8,0.23053e+01_r8 /)
      kbo(:, 5,37,13) = (/ &
        & 0.15205e+01_r8,0.23639e+01_r8,0.28124e+01_r8,0.28871e+01_r8,0.23656e+01_r8 /)
      kbo(:, 1,38,13) = (/ &
        & 0.91080e+00_r8,0.19040e+01_r8,0.24332e+01_r8,0.26332e+01_r8,0.20631e+01_r8 /)
      kbo(:, 2,38,13) = (/ &
        & 0.10540e+01_r8,0.20201e+01_r8,0.25351e+01_r8,0.27123e+01_r8,0.21497e+01_r8 /)
      kbo(:, 3,38,13) = (/ &
        & 0.12022e+01_r8,0.21326e+01_r8,0.26310e+01_r8,0.27790e+01_r8,0.22264e+01_r8 /)
      kbo(:, 4,38,13) = (/ &
        & 0.13520e+01_r8,0.22432e+01_r8,0.27202e+01_r8,0.28347e+01_r8,0.22959e+01_r8 /)
      kbo(:, 5,38,13) = (/ &
        & 0.14989e+01_r8,0.23490e+01_r8,0.28012e+01_r8,0.28815e+01_r8,0.23575e+01_r8 /)
      kbo(:, 1,39,13) = (/ &
        & 0.88956e+00_r8,0.18861e+01_r8,0.24173e+01_r8,0.26207e+01_r8,0.20495e+01_r8 /)
      kbo(:, 2,39,13) = (/ &
        & 0.10319e+01_r8,0.20032e+01_r8,0.25205e+01_r8,0.27021e+01_r8,0.21379e+01_r8 /)
      kbo(:, 3,39,13) = (/ &
        & 0.11798e+01_r8,0.21163e+01_r8,0.26173e+01_r8,0.27704e+01_r8,0.22159e+01_r8 /)
      kbo(:, 4,39,13) = (/ &
        & 0.13298e+01_r8,0.22272e+01_r8,0.27078e+01_r8,0.28277e+01_r8,0.22865e+01_r8 /)
      kbo(:, 5,39,13) = (/ &
        & 0.14775e+01_r8,0.23341e+01_r8,0.27901e+01_r8,0.28757e+01_r8,0.23493e+01_r8 /)
      kbo(:, 1,40,13) = (/ &
        & 0.85494e+00_r8,0.18558e+01_r8,0.23904e+01_r8,0.25985e+01_r8,0.20255e+01_r8 /)
      kbo(:, 2,40,13) = (/ &
        & 0.99514e+00_r8,0.19745e+01_r8,0.24954e+01_r8,0.26836e+01_r8,0.21170e+01_r8 /)
      kbo(:, 3,40,13) = (/ &
        & 0.11424e+01_r8,0.20885e+01_r8,0.25938e+01_r8,0.27547e+01_r8,0.21975e+01_r8 /)
      kbo(:, 4,40,13) = (/ &
        & 0.12924e+01_r8,0.22001e+01_r8,0.26861e+01_r8,0.28148e+01_r8,0.22700e+01_r8 /)
      kbo(:, 5,40,13) = (/ &
        & 0.14413e+01_r8,0.23083e+01_r8,0.27705e+01_r8,0.28664e+01_r8,0.23349e+01_r8 /)
      kbo(:, 1,41,13) = (/ &
        & 0.81957e+00_r8,0.18237e+01_r8,0.23613e+01_r8,0.25741e+01_r8,0.19997e+01_r8 /)
      kbo(:, 2,41,13) = (/ &
        & 0.95728e+00_r8,0.19441e+01_r8,0.24688e+01_r8,0.26632e+01_r8,0.20945e+01_r8 /)
      kbo(:, 3,41,13) = (/ &
        & 0.11034e+01_r8,0.20591e+01_r8,0.25687e+01_r8,0.27378e+01_r8,0.21777e+01_r8 /)
      kbo(:, 4,41,13) = (/ &
        & 0.12530e+01_r8,0.21714e+01_r8,0.26630e+01_r8,0.28005e+01_r8,0.22519e+01_r8 /)
      kbo(:, 5,41,13) = (/ &
        & 0.14027e+01_r8,0.22807e+01_r8,0.27494e+01_r8,0.28533e+01_r8,0.23190e+01_r8 /)
      kbo(:, 1,42,13) = (/ &
        & 0.78503e+00_r8,0.17918e+01_r8,0.23317e+01_r8,0.25487e+01_r8,0.19734e+01_r8 /)
      kbo(:, 2,42,13) = (/ &
        & 0.92016e+00_r8,0.19132e+01_r8,0.24418e+01_r8,0.26418e+01_r8,0.20712e+01_r8 /)
      kbo(:, 3,42,13) = (/ &
        & 0.10646e+01_r8,0.20294e+01_r8,0.25432e+01_r8,0.27200e+01_r8,0.21575e+01_r8 /)
      kbo(:, 4,42,13) = (/ &
        & 0.12137e+01_r8,0.21426e+01_r8,0.26392e+01_r8,0.27859e+01_r8,0.22336e+01_r8 /)
      kbo(:, 5,42,13) = (/ &
        & 0.13639e+01_r8,0.22528e+01_r8,0.27279e+01_r8,0.28411e+01_r8,0.23026e+01_r8 /)
      kbo(:, 1,43,13) = (/ &
        & 0.74423e+00_r8,0.17527e+01_r8,0.22949e+01_r8,0.25159e+01_r8,0.19403e+01_r8 /)
      kbo(:, 2,43,13) = (/ &
        & 0.87589e+00_r8,0.18750e+01_r8,0.24080e+01_r8,0.26143e+01_r8,0.20417e+01_r8 /)
      kbo(:, 3,43,13) = (/ &
        & 0.10179e+01_r8,0.19932e+01_r8,0.25118e+01_r8,0.26972e+01_r8,0.21315e+01_r8 /)
      kbo(:, 4,43,13) = (/ &
        & 0.11661e+01_r8,0.21073e+01_r8,0.26096e+01_r8,0.27665e+01_r8,0.22105e+01_r8 /)
      kbo(:, 5,43,13) = (/ &
        & 0.13165e+01_r8,0.22185e+01_r8,0.27008e+01_r8,0.28247e+01_r8,0.22817e+01_r8 /)
      kbo(:, 1,44,13) = (/ &
        & 0.70183e+00_r8,0.17101e+01_r8,0.22539e+01_r8,0.24783e+01_r8,0.19029e+01_r8 /)
      kbo(:, 2,44,13) = (/ &
        & 0.82940e+00_r8,0.18334e+01_r8,0.23707e+01_r8,0.25829e+01_r8,0.20083e+01_r8 /)
      kbo(:, 3,44,13) = (/ &
        & 0.96829e+00_r8,0.19537e+01_r8,0.24774e+01_r8,0.26707e+01_r8,0.21022e+01_r8 /)
      kbo(:, 4,44,13) = (/ &
        & 0.11151e+01_r8,0.20687e+01_r8,0.25770e+01_r8,0.27443e+01_r8,0.21846e+01_r8 /)
      kbo(:, 5,44,13) = (/ &
        & 0.12651e+01_r8,0.21808e+01_r8,0.26707e+01_r8,0.28061e+01_r8,0.22584e+01_r8 /)
      kbo(:, 1,45,13) = (/ &
        & 0.66118e+00_r8,0.16676e+01_r8,0.22119e+01_r8,0.24384e+01_r8,0.18634e+01_r8 /)
      kbo(:, 2,45,13) = (/ &
        & 0.78445e+00_r8,0.17917e+01_r8,0.23321e+01_r8,0.25495e+01_r8,0.19739e+01_r8 /)
      kbo(:, 3,45,13) = (/ &
        & 0.91984e+00_r8,0.19133e+01_r8,0.24421e+01_r8,0.26427e+01_r8,0.20718e+01_r8 /)
      kbo(:, 4,45,13) = (/ &
        & 0.10646e+01_r8,0.20301e+01_r8,0.25439e+01_r8,0.27211e+01_r8,0.21582e+01_r8 /)
      kbo(:, 5,45,13) = (/ &
        & 0.12138e+01_r8,0.21430e+01_r8,0.26395e+01_r8,0.27867e+01_r8,0.22343e+01_r8 /)
      kbo(:, 1,46,13) = (/ &
        & 0.61933e+00_r8,0.16221e+01_r8,0.21659e+01_r8,0.23935e+01_r8,0.18196e+01_r8 /)
      kbo(:, 2,46,13) = (/ &
        & 0.73807e+00_r8,0.17470e+01_r8,0.22898e+01_r8,0.25118e+01_r8,0.19358e+01_r8 /)
      kbo(:, 3,46,13) = (/ &
        & 0.86934e+00_r8,0.18696e+01_r8,0.24034e+01_r8,0.26109e+01_r8,0.20379e+01_r8 /)
      kbo(:, 4,46,13) = (/ &
        & 0.10113e+01_r8,0.19884e+01_r8,0.25076e+01_r8,0.26946e+01_r8,0.21283e+01_r8 /)
      kbo(:, 5,46,13) = (/ &
        & 0.11593e+01_r8,0.21025e+01_r8,0.26055e+01_r8,0.27643e+01_r8,0.22076e+01_r8 /)
      kbo(:, 1,47,13) = (/ &
        & 0.57374e+00_r8,0.15709e+01_r8,0.21131e+01_r8,0.23400e+01_r8,0.17680e+01_r8 /)
      kbo(:, 2,47,13) = (/ &
        & 0.68838e+00_r8,0.16965e+01_r8,0.22409e+01_r8,0.24665e+01_r8,0.18907e+01_r8 /)
      kbo(:, 3,47,13) = (/ &
        & 0.81478e+00_r8,0.18201e+01_r8,0.23589e+01_r8,0.25731e+01_r8,0.19980e+01_r8 /)
      kbo(:, 4,47,13) = (/ &
        & 0.95278e+00_r8,0.19412e+01_r8,0.24665e+01_r8,0.26626e+01_r8,0.20931e+01_r8 /)
      kbo(:, 5,47,13) = (/ &
        & 0.10991e+01_r8,0.20567e+01_r8,0.25667e+01_r8,0.27376e+01_r8,0.21769e+01_r8 /)
      kbo(:, 1,48,13) = (/ &
        & 0.52946e+00_r8,0.15198e+01_r8,0.20592e+01_r8,0.22834e+01_r8,0.17136e+01_r8 /)
      kbo(:, 2,48,13) = (/ &
        & 0.64089e+00_r8,0.16459e+01_r8,0.21904e+01_r8,0.24180e+01_r8,0.18431e+01_r8 /)
      kbo(:, 3,48,13) = (/ &
        & 0.76211e+00_r8,0.17708e+01_r8,0.23126e+01_r8,0.25324e+01_r8,0.19565e+01_r8 /)
      kbo(:, 4,48,13) = (/ &
        & 0.89568e+00_r8,0.18928e+01_r8,0.24241e+01_r8,0.26284e+01_r8,0.20564e+01_r8 /)
      kbo(:, 5,48,13) = (/ &
        & 0.10393e+01_r8,0.20105e+01_r8,0.25268e+01_r8,0.27091e+01_r8,0.21445e+01_r8 /)
      kbo(:, 1,49,13) = (/ &
        & 0.48708e+00_r8,0.14681e+01_r8,0.20029e+01_r8,0.22232e+01_r8,0.16566e+01_r8 /)
      kbo(:, 2,49,13) = (/ &
        & 0.59510e+00_r8,0.15951e+01_r8,0.21382e+01_r8,0.23660e+01_r8,0.17928e+01_r8 /)
      kbo(:, 3,49,13) = (/ &
        & 0.71141e+00_r8,0.17205e+01_r8,0.22646e+01_r8,0.24889e+01_r8,0.19130e+01_r8 /)
      kbo(:, 4,49,13) = (/ &
        & 0.84034e+00_r8,0.18437e+01_r8,0.23804e+01_r8,0.25917e+01_r8,0.20174e+01_r8 /)
      kbo(:, 5,49,13) = (/ &
        & 0.98023e+00_r8,0.19637e+01_r8,0.24863e+01_r8,0.26785e+01_r8,0.21102e+01_r8 /)
      kbo(:, 1,50,13) = (/ &
        & 0.44946e+00_r8,0.14198e+01_r8,0.19480e+01_r8,0.21639e+01_r8,0.16005e+01_r8 /)
      kbo(:, 2,50,13) = (/ &
        & 0.55308e+00_r8,0.15472e+01_r8,0.20885e+01_r8,0.23146e+01_r8,0.17433e+01_r8 /)
      kbo(:, 3,50,13) = (/ &
        & 0.66640e+00_r8,0.16732e+01_r8,0.22179e+01_r8,0.24447e+01_r8,0.18693e+01_r8 /)
      kbo(:, 4,50,13) = (/ &
        & 0.79021e+00_r8,0.17975e+01_r8,0.23380e+01_r8,0.25550e+01_r8,0.19794e+01_r8 /)
      kbo(:, 5,50,13) = (/ &
        & 0.92626e+00_r8,0.19191e+01_r8,0.24474e+01_r8,0.26476e+01_r8,0.20768e+01_r8 /)
      kbo(:, 1,51,13) = (/ &
        & 0.41452e+00_r8,0.13727e+01_r8,0.18922e+01_r8,0.21038e+01_r8,0.15428e+01_r8 /)
      kbo(:, 2,51,13) = (/ &
        & 0.51362e+00_r8,0.15005e+01_r8,0.20385e+01_r8,0.22616e+01_r8,0.16930e+01_r8 /)
      kbo(:, 3,51,13) = (/ &
        & 0.62394e+00_r8,0.16272e+01_r8,0.21714e+01_r8,0.23993e+01_r8,0.18251e+01_r8 /)
      kbo(:, 4,51,13) = (/ &
        & 0.74304e+00_r8,0.17523e+01_r8,0.22953e+01_r8,0.25171e+01_r8,0.19410e+01_r8 /)
      kbo(:, 5,51,13) = (/ &
        & 0.87505e+00_r8,0.18748e+01_r8,0.24082e+01_r8,0.26155e+01_r8,0.20426e+01_r8 /)
      kbo(:, 1,52,13) = (/ &
        & 0.38121e+00_r8,0.13250e+01_r8,0.18350e+01_r8,0.20413e+01_r8,0.14822e+01_r8 /)
      kbo(:, 2,52,13) = (/ &
        & 0.47581e+00_r8,0.14538e+01_r8,0.19870e+01_r8,0.22062e+01_r8,0.16405e+01_r8 /)
      kbo(:, 3,52,13) = (/ &
        & 0.58258e+00_r8,0.15810e+01_r8,0.21239e+01_r8,0.23514e+01_r8,0.17789e+01_r8 /)
      kbo(:, 4,52,13) = (/ &
        & 0.69813e+00_r8,0.17065e+01_r8,0.22509e+01_r8,0.24762e+01_r8,0.19005e+01_r8 /)
      kbo(:, 5,52,13) = (/ &
        & 0.82543e+00_r8,0.18301e+01_r8,0.23683e+01_r8,0.25815e+01_r8,0.20067e+01_r8 /)
      kbo(:, 1,53,13) = (/ &
        & 0.34902e+00_r8,0.12769e+01_r8,0.17751e+01_r8,0.19762e+01_r8,0.14178e+01_r8 /)
      kbo(:, 2,53,13) = (/ &
        & 0.43953e+00_r8,0.14068e+01_r8,0.19332e+01_r8,0.21485e+01_r8,0.15854e+01_r8 /)
      kbo(:, 3,53,13) = (/ &
        & 0.54216e+00_r8,0.15348e+01_r8,0.20756e+01_r8,0.23010e+01_r8,0.17302e+01_r8 /)
      kbo(:, 4,53,13) = (/ &
        & 0.65469e+00_r8,0.16608e+01_r8,0.22054e+01_r8,0.24328e+01_r8,0.18578e+01_r8 /)
      kbo(:, 5,53,13) = (/ &
        & 0.77730e+00_r8,0.17854e+01_r8,0.23267e+01_r8,0.25453e+01_r8,0.19695e+01_r8 /)
      kbo(:, 1,54,13) = (/ &
        & 0.32058e+00_r8,0.12324e+01_r8,0.17175e+01_r8,0.19140e+01_r8,0.13553e+01_r8 /)
      kbo(:, 2,54,13) = (/ &
        & 0.40795e+00_r8,0.13637e+01_r8,0.18819e+01_r8,0.20929e+01_r8,0.15321e+01_r8 /)
      kbo(:, 3,54,13) = (/ &
        & 0.50645e+00_r8,0.14920e+01_r8,0.20295e+01_r8,0.22518e+01_r8,0.16837e+01_r8 /)
      kbo(:, 4,54,13) = (/ &
        & 0.61609e+00_r8,0.16187e+01_r8,0.21628e+01_r8,0.23909e+01_r8,0.18169e+01_r8 /)
      kbo(:, 5,54,13) = (/ &
        & 0.73448e+00_r8,0.17439e+01_r8,0.22873e+01_r8,0.25101e+01_r8,0.19340e+01_r8 /)
      kbo(:, 1,55,13) = (/ &
        & 0.29443e+00_r8,0.11892e+01_r8,0.16600e+01_r8,0.18513e+01_r8,0.12929e+01_r8 /)
      kbo(:, 2,55,13) = (/ &
        & 0.37883e+00_r8,0.13219e+01_r8,0.18314e+01_r8,0.20376e+01_r8,0.14784e+01_r8 /)
      kbo(:, 3,55,13) = (/ &
        & 0.47335e+00_r8,0.14508e+01_r8,0.19839e+01_r8,0.22027e+01_r8,0.16372e+01_r8 /)
      kbo(:, 4,55,13) = (/ &
        & 0.57989e+00_r8,0.15780e+01_r8,0.21210e+01_r8,0.23485e+01_r8,0.17761e+01_r8 /)
      kbo(:, 5,55,13) = (/ &
        & 0.69533e+00_r8,0.17037e+01_r8,0.22482e+01_r8,0.24738e+01_r8,0.18980e+01_r8 /)
      kbo(:, 1,56,13) = (/ &
        & 0.26936e+00_r8,0.11459e+01_r8,0.16007e+01_r8,0.17863e+01_r8,0.12289e+01_r8 /)
      kbo(:, 2,56,13) = (/ &
        & 0.35065e+00_r8,0.12797e+01_r8,0.17789e+01_r8,0.19807e+01_r8,0.14221e+01_r8 /)
      kbo(:, 3,56,13) = (/ &
        & 0.44158e+00_r8,0.14097e+01_r8,0.19368e+01_r8,0.21523e+01_r8,0.15891e+01_r8 /)
      kbo(:, 4,56,13) = (/ &
        & 0.54448e+00_r8,0.15375e+01_r8,0.20786e+01_r8,0.23043e+01_r8,0.17334e+01_r8 /)
      kbo(:, 5,56,13) = (/ &
        & 0.65732e+00_r8,0.16637e+01_r8,0.22084e+01_r8,0.24358e+01_r8,0.18606e+01_r8 /)
      kbo(:, 1,57,13) = (/ &
        & 0.24515e+00_r8,0.11022e+01_r8,0.15388e+01_r8,0.17186e+01_r8,0.11645e+01_r8 /)
      kbo(:, 2,57,13) = (/ &
        & 0.32341e+00_r8,0.12372e+01_r8,0.17241e+01_r8,0.19215e+01_r8,0.13626e+01_r8 /)
      kbo(:, 3,57,13) = (/ &
        & 0.41131e+00_r8,0.13686e+01_r8,0.18879e+01_r8,0.20994e+01_r8,0.15383e+01_r8 /)
      kbo(:, 4,57,13) = (/ &
        & 0.51026e+00_r8,0.14967e+01_r8,0.20347e+01_r8,0.22575e+01_r8,0.16892e+01_r8 /)
      kbo(:, 5,57,13) = (/ &
        & 0.62036e+00_r8,0.16234e+01_r8,0.21677e+01_r8,0.23959e+01_r8,0.18217e+01_r8 /)
      kbo(:, 1,58,13) = (/ &
        & 0.22298e+00_r8,0.10601e+01_r8,0.14788e+01_r8,0.16521e+01_r8,0.11024e+01_r8 /)
      kbo(:, 2,58,13) = (/ &
        & 0.29857e+00_r8,0.11965e+01_r8,0.16700e+01_r8,0.18625e+01_r8,0.13039e+01_r8 /)
      kbo(:, 3,58,13) = (/ &
        & 0.38366e+00_r8,0.13291e+01_r8,0.18404e+01_r8,0.20474e+01_r8,0.14880e+01_r8 /)
      kbo(:, 4,58,13) = (/ &
        & 0.47882e+00_r8,0.14579e+01_r8,0.19918e+01_r8,0.22114e+01_r8,0.16455e+01_r8 /)
      kbo(:, 5,58,13) = (/ &
        & 0.58601e+00_r8,0.15850e+01_r8,0.21282e+01_r8,0.23561e+01_r8,0.17833e+01_r8 /)
      kbo(:, 1,59,13) = (/ &
        & 0.21427e+00_r8,0.10429e+01_r8,0.14544e+01_r8,0.16247e+01_r8,0.10771e+01_r8 /)
      kbo(:, 2,59,13) = (/ &
        & 0.28885e+00_r8,0.11801e+01_r8,0.16480e+01_r8,0.18384e+01_r8,0.12798e+01_r8 /)
      kbo(:, 3,59,13) = (/ &
        & 0.37281e+00_r8,0.13132e+01_r8,0.18209e+01_r8,0.20260e+01_r8,0.14670e+01_r8 /)
      kbo(:, 4,59,13) = (/ &
        & 0.46652e+00_r8,0.14422e+01_r8,0.19743e+01_r8,0.21926e+01_r8,0.16276e+01_r8 /)
      kbo(:, 5,59,13) = (/ &
        & 0.57246e+00_r8,0.15697e+01_r8,0.21123e+01_r8,0.23397e+01_r8,0.17674e+01_r8 /)
      kbo(:, 1,13,14) = (/ &
        & 0.76467e+01_r8,0.66870e+01_r8,0.63502e+01_r8,0.61468e+01_r8,0.66906e+01_r8 /)
      kbo(:, 2,13,14) = (/ &
        & 0.76514e+01_r8,0.66716e+01_r8,0.63627e+01_r8,0.61942e+01_r8,0.67780e+01_r8 /)
      kbo(:, 3,13,14) = (/ &
        & 0.76475e+01_r8,0.66428e+01_r8,0.63628e+01_r8,0.62371e+01_r8,0.68460e+01_r8 /)
      kbo(:, 4,13,14) = (/ &
        & 0.76415e+01_r8,0.66083e+01_r8,0.63514e+01_r8,0.62630e+01_r8,0.69072e+01_r8 /)
      kbo(:, 5,13,14) = (/ &
        & 0.76283e+01_r8,0.65686e+01_r8,0.63330e+01_r8,0.62779e+01_r8,0.69614e+01_r8 /)
      kbo(:, 1,14,14) = (/ &
        & 0.77958e+01_r8,0.69779e+01_r8,0.66658e+01_r8,0.63591e+01_r8,0.67479e+01_r8 /)
      kbo(:, 2,14,14) = (/ &
        & 0.78014e+01_r8,0.69599e+01_r8,0.66792e+01_r8,0.64167e+01_r8,0.68357e+01_r8 /)
      kbo(:, 3,14,14) = (/ &
        & 0.78100e+01_r8,0.69314e+01_r8,0.66809e+01_r8,0.64627e+01_r8,0.69109e+01_r8 /)
      kbo(:, 4,14,14) = (/ &
        & 0.78098e+01_r8,0.68950e+01_r8,0.66685e+01_r8,0.64923e+01_r8,0.69838e+01_r8 /)
      kbo(:, 5,14,14) = (/ &
        & 0.77999e+01_r8,0.68585e+01_r8,0.66494e+01_r8,0.65137e+01_r8,0.70531e+01_r8 /)
      kbo(:, 1,15,14) = (/ &
        & 0.78397e+01_r8,0.72065e+01_r8,0.69626e+01_r8,0.65521e+01_r8,0.67717e+01_r8 /)
      kbo(:, 2,15,14) = (/ &
        & 0.78630e+01_r8,0.71900e+01_r8,0.69770e+01_r8,0.66166e+01_r8,0.68639e+01_r8 /)
      kbo(:, 3,15,14) = (/ &
        & 0.78829e+01_r8,0.71661e+01_r8,0.69761e+01_r8,0.66643e+01_r8,0.69508e+01_r8 /)
      kbo(:, 4,15,14) = (/ &
        & 0.78961e+01_r8,0.71374e+01_r8,0.69668e+01_r8,0.66987e+01_r8,0.70374e+01_r8 /)
      kbo(:, 5,15,14) = (/ &
        & 0.78984e+01_r8,0.71026e+01_r8,0.69440e+01_r8,0.67207e+01_r8,0.71207e+01_r8 /)
      kbo(:, 1,16,14) = (/ &
        & 0.77976e+01_r8,0.73768e+01_r8,0.72331e+01_r8,0.67309e+01_r8,0.67735e+01_r8 /)
      kbo(:, 2,16,14) = (/ &
        & 0.78456e+01_r8,0.73704e+01_r8,0.72485e+01_r8,0.67988e+01_r8,0.68801e+01_r8 /)
      kbo(:, 3,16,14) = (/ &
        & 0.78840e+01_r8,0.73590e+01_r8,0.72505e+01_r8,0.68482e+01_r8,0.69801e+01_r8 /)
      kbo(:, 4,16,14) = (/ &
        & 0.79146e+01_r8,0.73379e+01_r8,0.72385e+01_r8,0.68847e+01_r8,0.70795e+01_r8 /)
      kbo(:, 5,16,14) = (/ &
        & 0.79322e+01_r8,0.73060e+01_r8,0.72179e+01_r8,0.69099e+01_r8,0.71779e+01_r8 /)
      kbo(:, 1,17,14) = (/ &
        & 0.76851e+01_r8,0.74978e+01_r8,0.74681e+01_r8,0.68923e+01_r8,0.67646e+01_r8 /)
      kbo(:, 2,17,14) = (/ &
        & 0.77622e+01_r8,0.75112e+01_r8,0.74909e+01_r8,0.69618e+01_r8,0.68880e+01_r8 /)
      kbo(:, 3,17,14) = (/ &
        & 0.78293e+01_r8,0.75089e+01_r8,0.74964e+01_r8,0.70134e+01_r8,0.70063e+01_r8 /)
      kbo(:, 4,17,14) = (/ &
        & 0.78832e+01_r8,0.75014e+01_r8,0.74883e+01_r8,0.70540e+01_r8,0.71204e+01_r8 /)
      kbo(:, 5,17,14) = (/ &
        & 0.79237e+01_r8,0.74752e+01_r8,0.74629e+01_r8,0.70833e+01_r8,0.72311e+01_r8 /)
      kbo(:, 1,18,14) = (/ &
        & 0.75343e+01_r8,0.75844e+01_r8,0.76679e+01_r8,0.70369e+01_r8,0.67530e+01_r8 /)
      kbo(:, 2,18,14) = (/ &
        & 0.76372e+01_r8,0.76127e+01_r8,0.76999e+01_r8,0.71100e+01_r8,0.68939e+01_r8 /)
      kbo(:, 3,18,14) = (/ &
        & 0.77344e+01_r8,0.76293e+01_r8,0.77123e+01_r8,0.71649e+01_r8,0.70305e+01_r8 /)
      kbo(:, 4,18,14) = (/ &
        & 0.78168e+01_r8,0.76302e+01_r8,0.77077e+01_r8,0.72057e+01_r8,0.71594e+01_r8 /)
      kbo(:, 5,18,14) = (/ &
        & 0.78848e+01_r8,0.76120e+01_r8,0.76799e+01_r8,0.72369e+01_r8,0.72819e+01_r8 /)
      kbo(:, 1,19,14) = (/ &
        & 0.73642e+01_r8,0.76427e+01_r8,0.78392e+01_r8,0.71673e+01_r8,0.67426e+01_r8 /)
      kbo(:, 2,19,14) = (/ &
        & 0.75027e+01_r8,0.76890e+01_r8,0.78792e+01_r8,0.72411e+01_r8,0.69029e+01_r8 /)
      kbo(:, 3,19,14) = (/ &
        & 0.76261e+01_r8,0.77218e+01_r8,0.78995e+01_r8,0.72995e+01_r8,0.70551e+01_r8 /)
      kbo(:, 4,19,14) = (/ &
        & 0.77358e+01_r8,0.77317e+01_r8,0.78972e+01_r8,0.73431e+01_r8,0.71976e+01_r8 /)
      kbo(:, 5,19,14) = (/ &
        & 0.78306e+01_r8,0.77206e+01_r8,0.78669e+01_r8,0.73734e+01_r8,0.73288e+01_r8 /)
      kbo(:, 1,20,14) = (/ &
        & 0.71989e+01_r8,0.76856e+01_r8,0.79830e+01_r8,0.72835e+01_r8,0.67408e+01_r8 /)
      kbo(:, 2,20,14) = (/ &
        & 0.73691e+01_r8,0.77492e+01_r8,0.80344e+01_r8,0.73623e+01_r8,0.69200e+01_r8 /)
      kbo(:, 3,20,14) = (/ &
        & 0.75204e+01_r8,0.77952e+01_r8,0.80604e+01_r8,0.74206e+01_r8,0.70842e+01_r8 /)
      kbo(:, 4,20,14) = (/ &
        & 0.76560e+01_r8,0.78150e+01_r8,0.80567e+01_r8,0.74651e+01_r8,0.72381e+01_r8 /)
      kbo(:, 5,20,14) = (/ &
        & 0.77736e+01_r8,0.78108e+01_r8,0.80255e+01_r8,0.74944e+01_r8,0.73772e+01_r8 /)
      kbo(:, 1,21,14) = (/ &
        & 0.70426e+01_r8,0.77166e+01_r8,0.81049e+01_r8,0.73883e+01_r8,0.67480e+01_r8 /)
      kbo(:, 2,21,14) = (/ &
        & 0.72474e+01_r8,0.77946e+01_r8,0.81668e+01_r8,0.74708e+01_r8,0.69410e+01_r8 /)
      kbo(:, 3,21,14) = (/ &
        & 0.74271e+01_r8,0.78518e+01_r8,0.81976e+01_r8,0.75283e+01_r8,0.71153e+01_r8 /)
      kbo(:, 4,21,14) = (/ &
        & 0.75881e+01_r8,0.78806e+01_r8,0.81926e+01_r8,0.75722e+01_r8,0.72765e+01_r8 /)
      kbo(:, 5,21,14) = (/ &
        & 0.77244e+01_r8,0.78840e+01_r8,0.81605e+01_r8,0.76005e+01_r8,0.74219e+01_r8 /)
      kbo(:, 1,22,14) = (/ &
        & 0.69208e+01_r8,0.77467e+01_r8,0.82134e+01_r8,0.74892e+01_r8,0.67760e+01_r8 /)
      kbo(:, 2,22,14) = (/ &
        & 0.71527e+01_r8,0.78380e+01_r8,0.82825e+01_r8,0.75703e+01_r8,0.69788e+01_r8 /)
      kbo(:, 3,22,14) = (/ &
        & 0.73591e+01_r8,0.79026e+01_r8,0.83138e+01_r8,0.76265e+01_r8,0.71614e+01_r8 /)
      kbo(:, 4,22,14) = (/ &
        & 0.75412e+01_r8,0.79369e+01_r8,0.83052e+01_r8,0.76676e+01_r8,0.73269e+01_r8 /)
      kbo(:, 5,22,14) = (/ &
        & 0.76931e+01_r8,0.79423e+01_r8,0.82705e+01_r8,0.76932e+01_r8,0.74734e+01_r8 /)
      kbo(:, 1,23,14) = (/ &
        & 0.68264e+01_r8,0.77768e+01_r8,0.83085e+01_r8,0.75813e+01_r8,0.68129e+01_r8 /)
      kbo(:, 2,23,14) = (/ &
        & 0.70814e+01_r8,0.78791e+01_r8,0.83807e+01_r8,0.76573e+01_r8,0.70223e+01_r8 /)
      kbo(:, 3,23,14) = (/ &
        & 0.73108e+01_r8,0.79473e+01_r8,0.84103e+01_r8,0.77115e+01_r8,0.72087e+01_r8 /)
      kbo(:, 4,23,14) = (/ &
        & 0.75083e+01_r8,0.79850e+01_r8,0.83989e+01_r8,0.77500e+01_r8,0.73762e+01_r8 /)
      kbo(:, 5,23,14) = (/ &
        & 0.76738e+01_r8,0.79912e+01_r8,0.83608e+01_r8,0.77715e+01_r8,0.75218e+01_r8 /)
      kbo(:, 1,24,14) = (/ &
        & 0.67597e+01_r8,0.78092e+01_r8,0.83929e+01_r8,0.76639e+01_r8,0.68571e+01_r8 /)
      kbo(:, 2,24,14) = (/ &
        & 0.70359e+01_r8,0.79159e+01_r8,0.84653e+01_r8,0.77347e+01_r8,0.70700e+01_r8 /)
      kbo(:, 3,24,14) = (/ &
        & 0.72818e+01_r8,0.79869e+01_r8,0.84905e+01_r8,0.77860e+01_r8,0.72578e+01_r8 /)
      kbo(:, 4,24,14) = (/ &
        & 0.74908e+01_r8,0.80269e+01_r8,0.84765e+01_r8,0.78202e+01_r8,0.74248e+01_r8 /)
      kbo(:, 5,24,14) = (/ &
        & 0.76673e+01_r8,0.80324e+01_r8,0.84337e+01_r8,0.78375e+01_r8,0.75690e+01_r8 /)
      kbo(:, 1,25,14) = (/ &
        & 0.67209e+01_r8,0.78436e+01_r8,0.84676e+01_r8,0.77356e+01_r8,0.69066e+01_r8 /)
      kbo(:, 2,25,14) = (/ &
        & 0.70147e+01_r8,0.79506e+01_r8,0.85366e+01_r8,0.78027e+01_r8,0.71216e+01_r8 /)
      kbo(:, 3,25,14) = (/ &
        & 0.72710e+01_r8,0.80222e+01_r8,0.85567e+01_r8,0.78495e+01_r8,0.73079e+01_r8 /)
      kbo(:, 4,25,14) = (/ &
        & 0.74891e+01_r8,0.80627e+01_r8,0.85388e+01_r8,0.78803e+01_r8,0.74736e+01_r8 /)
      kbo(:, 5,25,14) = (/ &
        & 0.76763e+01_r8,0.80663e+01_r8,0.84908e+01_r8,0.78920e+01_r8,0.76152e+01_r8 /)
      kbo(:, 1,26,14) = (/ &
        & 0.67117e+01_r8,0.78809e+01_r8,0.85346e+01_r8,0.77996e+01_r8,0.69621e+01_r8 /)
      kbo(:, 2,26,14) = (/ &
        & 0.70163e+01_r8,0.79848e+01_r8,0.85977e+01_r8,0.78624e+01_r8,0.71766e+01_r8 /)
      kbo(:, 3,26,14) = (/ &
        & 0.72800e+01_r8,0.80555e+01_r8,0.86111e+01_r8,0.79043e+01_r8,0.73612e+01_r8 /)
      kbo(:, 4,26,14) = (/ &
        & 0.75048e+01_r8,0.80927e+01_r8,0.85874e+01_r8,0.79312e+01_r8,0.75235e+01_r8 /)
      kbo(:, 5,26,14) = (/ &
        & 0.76969e+01_r8,0.80929e+01_r8,0.85318e+01_r8,0.79367e+01_r8,0.76615e+01_r8 /)
      kbo(:, 1,27,14) = (/ &
        & 0.67222e+01_r8,0.79165e+01_r8,0.85935e+01_r8,0.78553e+01_r8,0.70208e+01_r8 /)
      kbo(:, 2,27,14) = (/ &
        & 0.70339e+01_r8,0.80174e+01_r8,0.86486e+01_r8,0.79134e+01_r8,0.72318e+01_r8 /)
      kbo(:, 3,27,14) = (/ &
        & 0.73021e+01_r8,0.80859e+01_r8,0.86549e+01_r8,0.79502e+01_r8,0.74127e+01_r8 /)
      kbo(:, 4,27,14) = (/ &
        & 0.75298e+01_r8,0.81175e+01_r8,0.86239e+01_r8,0.79721e+01_r8,0.75702e+01_r8 /)
      kbo(:, 5,27,14) = (/ &
        & 0.77246e+01_r8,0.81143e+01_r8,0.85613e+01_r8,0.79734e+01_r8,0.77047e+01_r8 /)
      kbo(:, 1,28,14) = (/ &
        & 0.67490e+01_r8,0.79508e+01_r8,0.86448e+01_r8,0.79039e+01_r8,0.70793e+01_r8 /)
      kbo(:, 2,28,14) = (/ &
        & 0.70641e+01_r8,0.80481e+01_r8,0.86903e+01_r8,0.79567e+01_r8,0.72853e+01_r8 /)
      kbo(:, 3,28,14) = (/ &
        & 0.73339e+01_r8,0.81119e+01_r8,0.86890e+01_r8,0.79886e+01_r8,0.74622e+01_r8 /)
      kbo(:, 4,28,14) = (/ &
        & 0.75625e+01_r8,0.81383e+01_r8,0.86502e+01_r8,0.80049e+01_r8,0.76145e+01_r8 /)
      kbo(:, 5,28,14) = (/ &
        & 0.77567e+01_r8,0.81304e+01_r8,0.85806e+01_r8,0.80023e+01_r8,0.77455e+01_r8 /)
      kbo(:, 1,29,14) = (/ &
        & 0.67914e+01_r8,0.79845e+01_r8,0.86886e+01_r8,0.79462e+01_r8,0.71386e+01_r8 /)
      kbo(:, 2,29,14) = (/ &
        & 0.71068e+01_r8,0.80770e+01_r8,0.87239e+01_r8,0.79933e+01_r8,0.73389e+01_r8 /)
      kbo(:, 3,29,14) = (/ &
        & 0.73751e+01_r8,0.81344e+01_r8,0.87144e+01_r8,0.80208e+01_r8,0.75104e+01_r8 /)
      kbo(:, 4,29,14) = (/ &
        & 0.76020e+01_r8,0.81550e+01_r8,0.86676e+01_r8,0.80316e+01_r8,0.76575e+01_r8 /)
      kbo(:, 5,29,14) = (/ &
        & 0.77937e+01_r8,0.81425e+01_r8,0.85914e+01_r8,0.80248e+01_r8,0.77840e+01_r8 /)
      kbo(:, 1,30,14) = (/ &
        & 0.68445e+01_r8,0.80166e+01_r8,0.87256e+01_r8,0.79827e+01_r8,0.71970e+01_r8 /)
      kbo(:, 2,30,14) = (/ &
        & 0.71563e+01_r8,0.81037e+01_r8,0.87505e+01_r8,0.80234e+01_r8,0.73900e+01_r8 /)
      kbo(:, 3,30,14) = (/ &
        & 0.74214e+01_r8,0.81535e+01_r8,0.87321e+01_r8,0.80469e+01_r8,0.75564e+01_r8 /)
      kbo(:, 4,30,14) = (/ &
        & 0.76455e+01_r8,0.81683e+01_r8,0.86770e+01_r8,0.80524e+01_r8,0.76986e+01_r8 /)
      kbo(:, 5,30,14) = (/ &
        & 0.78317e+01_r8,0.81499e+01_r8,0.85949e+01_r8,0.80416e+01_r8,0.78203e+01_r8 /)
      kbo(:, 1,31,14) = (/ &
        & 0.69054e+01_r8,0.80478e+01_r8,0.87566e+01_r8,0.80136e+01_r8,0.72537e+01_r8 /)
      kbo(:, 2,31,14) = (/ &
        & 0.72125e+01_r8,0.81281e+01_r8,0.87710e+01_r8,0.80494e+01_r8,0.74404e+01_r8 /)
      kbo(:, 3,31,14) = (/ &
        & 0.74718e+01_r8,0.81700e+01_r8,0.87427e+01_r8,0.80677e+01_r8,0.76003e+01_r8 /)
      kbo(:, 4,31,14) = (/ &
        & 0.76912e+01_r8,0.81779e+01_r8,0.86791e+01_r8,0.80682e+01_r8,0.77384e+01_r8 /)
      kbo(:, 5,31,14) = (/ &
        & 0.78715e+01_r8,0.81532e+01_r8,0.85914e+01_r8,0.80538e+01_r8,0.78547e+01_r8 /)
      kbo(:, 1,32,14) = (/ &
        & 0.69718e+01_r8,0.80767e+01_r8,0.87812e+01_r8,0.80405e+01_r8,0.73093e+01_r8 /)
      kbo(:, 2,32,14) = (/ &
        & 0.72714e+01_r8,0.81493e+01_r8,0.87845e+01_r8,0.80705e+01_r8,0.74889e+01_r8 /)
      kbo(:, 3,32,14) = (/ &
        & 0.75255e+01_r8,0.81843e+01_r8,0.87476e+01_r8,0.80843e+01_r8,0.76427e+01_r8 /)
      kbo(:, 4,32,14) = (/ &
        & 0.77373e+01_r8,0.81836e+01_r8,0.86757e+01_r8,0.80798e+01_r8,0.77759e+01_r8 /)
      kbo(:, 5,32,14) = (/ &
        & 0.79115e+01_r8,0.81523e+01_r8,0.85821e+01_r8,0.80611e+01_r8,0.78870e+01_r8 /)
      kbo(:, 1,33,14) = (/ &
        & 0.70424e+01_r8,0.81041e+01_r8,0.88003e+01_r8,0.80631e+01_r8,0.73621e+01_r8 /)
      kbo(:, 2,33,14) = (/ &
        & 0.73332e+01_r8,0.81674e+01_r8,0.87934e+01_r8,0.80887e+01_r8,0.75359e+01_r8 /)
      kbo(:, 3,33,14) = (/ &
        & 0.75797e+01_r8,0.81949e+01_r8,0.87467e+01_r8,0.80962e+01_r8,0.76832e+01_r8 /)
      kbo(:, 4,33,14) = (/ &
        & 0.77832e+01_r8,0.81860e+01_r8,0.86679e+01_r8,0.80880e+01_r8,0.78112e+01_r8 /)
      kbo(:, 5,33,14) = (/ &
        & 0.79514e+01_r8,0.81480e+01_r8,0.85688e+01_r8,0.80650e+01_r8,0.79176e+01_r8 /)
      kbo(:, 1,34,14) = (/ &
        & 0.71032e+01_r8,0.81256e+01_r8,0.88135e+01_r8,0.80801e+01_r8,0.74073e+01_r8 /)
      kbo(:, 2,34,14) = (/ &
        & 0.73864e+01_r8,0.81812e+01_r8,0.87981e+01_r8,0.81025e+01_r8,0.75752e+01_r8 /)
      kbo(:, 3,34,14) = (/ &
        & 0.76257e+01_r8,0.82022e+01_r8,0.87428e+01_r8,0.81055e+01_r8,0.77177e+01_r8 /)
      kbo(:, 4,34,14) = (/ &
        & 0.78229e+01_r8,0.81866e+01_r8,0.86595e+01_r8,0.80934e+01_r8,0.78409e+01_r8 /)
      kbo(:, 5,34,14) = (/ &
        & 0.79841e+01_r8,0.81428e+01_r8,0.85553e+01_r8,0.80663e+01_r8,0.79427e+01_r8 /)
      kbo(:, 1,35,14) = (/ &
        & 0.71357e+01_r8,0.81386e+01_r8,0.88238e+01_r8,0.80923e+01_r8,0.74328e+01_r8 /)
      kbo(:, 2,35,14) = (/ &
        & 0.74155e+01_r8,0.81901e+01_r8,0.88028e+01_r8,0.81125e+01_r8,0.75980e+01_r8 /)
      kbo(:, 3,35,14) = (/ &
        & 0.76506e+01_r8,0.82068e+01_r8,0.87428e+01_r8,0.81128e+01_r8,0.77381e+01_r8 /)
      kbo(:, 4,35,14) = (/ &
        & 0.78446e+01_r8,0.81876e+01_r8,0.86563e+01_r8,0.80980e+01_r8,0.78583e+01_r8 /)
      kbo(:, 5,35,14) = (/ &
        & 0.80022e+01_r8,0.81408e+01_r8,0.85492e+01_r8,0.80683e+01_r8,0.79574e+01_r8 /)
      kbo(:, 1,36,14) = (/ &
        & 0.71358e+01_r8,0.81426e+01_r8,0.88312e+01_r8,0.80996e+01_r8,0.74385e+01_r8 /)
      kbo(:, 2,36,14) = (/ &
        & 0.74168e+01_r8,0.81942e+01_r8,0.88101e+01_r8,0.81195e+01_r8,0.76033e+01_r8 /)
      kbo(:, 3,36,14) = (/ &
        & 0.76530e+01_r8,0.82111e+01_r8,0.87491e+01_r8,0.81189e+01_r8,0.77431e+01_r8 /)
      kbo(:, 4,36,14) = (/ &
        & 0.78475e+01_r8,0.81916e+01_r8,0.86625e+01_r8,0.81041e+01_r8,0.78633e+01_r8 /)
      kbo(:, 5,36,14) = (/ &
        & 0.80053e+01_r8,0.81444e+01_r8,0.85549e+01_r8,0.80739e+01_r8,0.79624e+01_r8 /)
      kbo(:, 1,37,14) = (/ &
        & 0.70898e+01_r8,0.81353e+01_r8,0.88375e+01_r8,0.81022e+01_r8,0.74173e+01_r8 /)
      kbo(:, 2,37,14) = (/ &
        & 0.73792e+01_r8,0.81923e+01_r8,0.88220e+01_r8,0.81236e+01_r8,0.75852e+01_r8 /)
      kbo(:, 3,37,14) = (/ &
        & 0.76229e+01_r8,0.82146e+01_r8,0.87658e+01_r8,0.81255e+01_r8,0.77281e+01_r8 /)
      kbo(:, 4,37,14) = (/ &
        & 0.78232e+01_r8,0.81996e+01_r8,0.86818e+01_r8,0.81120e+01_r8,0.78508e+01_r8 /)
      kbo(:, 5,37,14) = (/ &
        & 0.79866e+01_r8,0.81554e+01_r8,0.85764e+01_r8,0.80843e+01_r8,0.79525e+01_r8 /)
      kbo(:, 1,38,14) = (/ &
        & 0.70419e+01_r8,0.81271e+01_r8,0.88418e+01_r8,0.81031e+01_r8,0.73933e+01_r8 /)
      kbo(:, 2,38,14) = (/ &
        & 0.73389e+01_r8,0.81889e+01_r8,0.88323e+01_r8,0.81261e+01_r8,0.75648e+01_r8 /)
      kbo(:, 3,38,14) = (/ &
        & 0.75899e+01_r8,0.82161e+01_r8,0.87808e+01_r8,0.81301e+01_r8,0.77105e+01_r8 /)
      kbo(:, 4,38,14) = (/ &
        & 0.77971e+01_r8,0.82068e+01_r8,0.87000e+01_r8,0.81195e+01_r8,0.78368e+01_r8 /)
      kbo(:, 5,38,14) = (/ &
        & 0.79663e+01_r8,0.81665e+01_r8,0.85976e+01_r8,0.80935e+01_r8,0.79412e+01_r8 /)
      kbo(:, 1,39,14) = (/ &
        & 0.69923e+01_r8,0.81165e+01_r8,0.88435e+01_r8,0.81024e+01_r8,0.73685e+01_r8 /)
      kbo(:, 2,39,14) = (/ &
        & 0.72982e+01_r8,0.81845e+01_r8,0.88409e+01_r8,0.81277e+01_r8,0.75441e+01_r8 /)
      kbo(:, 3,39,14) = (/ &
        & 0.75563e+01_r8,0.82164e+01_r8,0.87952e+01_r8,0.81347e+01_r8,0.76928e+01_r8 /)
      kbo(:, 4,39,14) = (/ &
        & 0.77695e+01_r8,0.82122e+01_r8,0.87165e+01_r8,0.81250e+01_r8,0.78216e+01_r8 /)
      kbo(:, 5,39,14) = (/ &
        & 0.79452e+01_r8,0.81762e+01_r8,0.86172e+01_r8,0.81015e+01_r8,0.79291e+01_r8 /)
      kbo(:, 1,40,14) = (/ &
        & 0.69080e+01_r8,0.80958e+01_r8,0.88413e+01_r8,0.80965e+01_r8,0.73229e+01_r8 /)
      kbo(:, 2,40,14) = (/ &
        & 0.72277e+01_r8,0.81734e+01_r8,0.88495e+01_r8,0.81259e+01_r8,0.75046e+01_r8 /)
      kbo(:, 3,40,14) = (/ &
        & 0.74967e+01_r8,0.82131e+01_r8,0.88131e+01_r8,0.81381e+01_r8,0.76600e+01_r8 /)
      kbo(:, 4,40,14) = (/ &
        & 0.77214e+01_r8,0.82184e+01_r8,0.87413e+01_r8,0.81320e+01_r8,0.77938e+01_r8 /)
      kbo(:, 5,40,14) = (/ &
        & 0.79055e+01_r8,0.81894e+01_r8,0.86471e+01_r8,0.81094e+01_r8,0.79066e+01_r8 /)
      kbo(:, 1,41,14) = (/ &
        & 0.68155e+01_r8,0.80708e+01_r8,0.88352e+01_r8,0.80885e+01_r8,0.72719e+01_r8 /)
      kbo(:, 2,41,14) = (/ &
        & 0.71495e+01_r8,0.81585e+01_r8,0.88545e+01_r8,0.81224e+01_r8,0.74618e+01_r8 /)
      kbo(:, 3,41,14) = (/ &
        & 0.74308e+01_r8,0.82074e+01_r8,0.88291e+01_r8,0.81392e+01_r8,0.76238e+01_r8 /)
      kbo(:, 4,41,14) = (/ &
        & 0.76675e+01_r8,0.82222e+01_r8,0.87650e+01_r8,0.81374e+01_r8,0.77629e+01_r8 /)
      kbo(:, 5,41,14) = (/ &
        & 0.78621e+01_r8,0.82014e+01_r8,0.86761e+01_r8,0.81197e+01_r8,0.78805e+01_r8 /)
      kbo(:, 1,42,14) = (/ &
        & 0.67210e+01_r8,0.80436e+01_r8,0.88257e+01_r8,0.80787e+01_r8,0.72181e+01_r8 /)
      kbo(:, 2,42,14) = (/ &
        & 0.70672e+01_r8,0.81413e+01_r8,0.88562e+01_r8,0.81177e+01_r8,0.74171e+01_r8 /)
      kbo(:, 3,42,14) = (/ &
        & 0.73618e+01_r8,0.81993e+01_r8,0.88420e+01_r8,0.81387e+01_r8,0.75853e+01_r8 /)
      kbo(:, 4,42,14) = (/ &
        & 0.76110e+01_r8,0.82240e+01_r8,0.87872e+01_r8,0.81416e+01_r8,0.77301e+01_r8 /)
      kbo(:, 5,42,14) = (/ &
        & 0.78157e+01_r8,0.82114e+01_r8,0.87034e+01_r8,0.81275e+01_r8,0.78533e+01_r8 /)
      kbo(:, 1,43,14) = (/ &
        & 0.66012e+01_r8,0.80077e+01_r8,0.88083e+01_r8,0.80639e+01_r8,0.71482e+01_r8 /)
      kbo(:, 2,43,14) = (/ &
        & 0.69627e+01_r8,0.81158e+01_r8,0.88532e+01_r8,0.81101e+01_r8,0.73596e+01_r8 /)
      kbo(:, 3,43,14) = (/ &
        & 0.72743e+01_r8,0.81862e+01_r8,0.88533e+01_r8,0.81352e+01_r8,0.75360e+01_r8 /)
      kbo(:, 4,43,14) = (/ &
        & 0.75376e+01_r8,0.82203e+01_r8,0.88101e+01_r8,0.81444e+01_r8,0.76876e+01_r8 /)
      kbo(:, 5,43,14) = (/ &
        & 0.77560e+01_r8,0.82200e+01_r8,0.87338e+01_r8,0.81353e+01_r8,0.78176e+01_r8 /)
      kbo(:, 1,44,14) = (/ &
        & 0.64654e+01_r8,0.79624e+01_r8,0.87841e+01_r8,0.80450e+01_r8,0.70696e+01_r8 /)
      kbo(:, 2,44,14) = (/ &
        & 0.68452e+01_r8,0.80842e+01_r8,0.88456e+01_r8,0.80985e+01_r8,0.72931e+01_r8 /)
      kbo(:, 3,44,14) = (/ &
        & 0.71736e+01_r8,0.81668e+01_r8,0.88594e+01_r8,0.81294e+01_r8,0.74799e+01_r8 /)
      kbo(:, 4,44,14) = (/ &
        & 0.74536e+01_r8,0.82135e+01_r8,0.88309e+01_r8,0.81455e+01_r8,0.76398e+01_r8 /)
      kbo(:, 5,44,14) = (/ &
        & 0.76864e+01_r8,0.82252e+01_r8,0.87641e+01_r8,0.81417e+01_r8,0.77771e+01_r8 /)
      kbo(:, 1,45,14) = (/ &
        & 0.63246e+01_r8,0.79121e+01_r8,0.87529e+01_r8,0.80227e+01_r8,0.69872e+01_r8 /)
      kbo(:, 2,45,14) = (/ &
        & 0.67215e+01_r8,0.80478e+01_r8,0.88314e+01_r8,0.80840e+01_r8,0.72219e+01_r8 /)
      kbo(:, 3,45,14) = (/ &
        & 0.70680e+01_r8,0.81447e+01_r8,0.88609e+01_r8,0.81218e+01_r8,0.74205e+01_r8 /)
      kbo(:, 4,45,14) = (/ &
        & 0.73633e+01_r8,0.82020e+01_r8,0.88464e+01_r8,0.81437e+01_r8,0.75896e+01_r8 /)
      kbo(:, 5,45,14) = (/ &
        & 0.76123e+01_r8,0.82264e+01_r8,0.87913e+01_r8,0.81458e+01_r8,0.77333e+01_r8 /)
      kbo(:, 1,46,14) = (/ &
        & 0.61677e+01_r8,0.78522e+01_r8,0.87120e+01_r8,0.79958e+01_r8,0.68962e+01_r8 /)
      kbo(:, 2,46,14) = (/ &
        & 0.65843e+01_r8,0.80056e+01_r8,0.88106e+01_r8,0.80659e+01_r8,0.71413e+01_r8 /)
      kbo(:, 3,46,14) = (/ &
        & 0.69482e+01_r8,0.81147e+01_r8,0.88565e+01_r8,0.81122e+01_r8,0.73539e+01_r8 /)
      kbo(:, 4,46,14) = (/ &
        & 0.72620e+01_r8,0.81857e+01_r8,0.88581e+01_r8,0.81382e+01_r8,0.75320e+01_r8 /)
      kbo(:, 5,46,14) = (/ &
        & 0.75285e+01_r8,0.82222e+01_r8,0.88171e+01_r8,0.81482e+01_r8,0.76841e+01_r8 /)
      kbo(:, 1,47,14) = (/ &
        & 0.59872e+01_r8,0.77759e+01_r8,0.86581e+01_r8,0.79599e+01_r8,0.67904e+01_r8 /)
      kbo(:, 2,47,14) = (/ &
        & 0.64227e+01_r8,0.79505e+01_r8,0.87794e+01_r8,0.80417e+01_r8,0.70463e+01_r8 /)
      kbo(:, 3,47,14) = (/ &
        & 0.68067e+01_r8,0.80750e+01_r8,0.88445e+01_r8,0.80966e+01_r8,0.72732e+01_r8 /)
      kbo(:, 4,47,14) = (/ &
        & 0.71415e+01_r8,0.81619e+01_r8,0.88634e+01_r8,0.81302e+01_r8,0.74640e+01_r8 /)
      kbo(:, 5,47,14) = (/ &
        & 0.74259e+01_r8,0.82118e+01_r8,0.88390e+01_r8,0.81478e+01_r8,0.76260e+01_r8 /)
      kbo(:, 1,48,14) = (/ &
        & 0.57999e+01_r8,0.76897e+01_r8,0.85924e+01_r8,0.79165e+01_r8,0.66812e+01_r8 /)
      kbo(:, 2,48,14) = (/ &
        & 0.62523e+01_r8,0.78878e+01_r8,0.87384e+01_r8,0.80135e+01_r8,0.69471e+01_r8 /)
      kbo(:, 3,48,14) = (/ &
        & 0.66581e+01_r8,0.80303e+01_r8,0.88250e+01_r8,0.80783e+01_r8,0.71862e+01_r8 /)
      kbo(:, 4,48,14) = (/ &
        & 0.70120e+01_r8,0.81321e+01_r8,0.88616e+01_r8,0.81203e+01_r8,0.73915e+01_r8 /)
      kbo(:, 5,48,14) = (/ &
        & 0.73167e+01_r8,0.81963e+01_r8,0.88550e+01_r8,0.81433e+01_r8,0.75640e+01_r8 /)
      kbo(:, 1,49,14) = (/ &
        & 0.56056e+01_r8,0.75967e+01_r8,0.85186e+01_r8,0.78664e+01_r8,0.65684e+01_r8 /)
      kbo(:, 2,49,14) = (/ &
        & 0.60725e+01_r8,0.78139e+01_r8,0.86868e+01_r8,0.79799e+01_r8,0.68428e+01_r8 /)
      kbo(:, 3,49,14) = (/ &
        & 0.65005e+01_r8,0.79789e+01_r8,0.87970e+01_r8,0.80551e+01_r8,0.70936e+01_r8 /)
      kbo(:, 4,49,14) = (/ &
        & 0.68750e+01_r8,0.80955e+01_r8,0.88532e+01_r8,0.81069e+01_r8,0.73141e+01_r8 /)
      kbo(:, 5,49,14) = (/ &
        & 0.72008e+01_r8,0.81753e+01_r8,0.88640e+01_r8,0.81362e+01_r8,0.74980e+01_r8 /)
      kbo(:, 1,50,14) = (/ &
        & 0.54125e+01_r8,0.74991e+01_r8,0.84401e+01_r8,0.78123e+01_r8,0.64595e+01_r8 /)
      kbo(:, 2,50,14) = (/ &
        & 0.59003e+01_r8,0.77375e+01_r8,0.86301e+01_r8,0.79423e+01_r8,0.67420e+01_r8 /)
      kbo(:, 3,50,14) = (/ &
        & 0.63429e+01_r8,0.79215e+01_r8,0.87619e+01_r8,0.80304e+01_r8,0.70024e+01_r8 /)
      kbo(:, 4,50,14) = (/ &
        & 0.67393e+01_r8,0.80557e+01_r8,0.88380e+01_r8,0.80904e+01_r8,0.72354e+01_r8 /)
      kbo(:, 5,50,14) = (/ &
        & 0.70838e+01_r8,0.81507e+01_r8,0.88659e+01_r8,0.81277e+01_r8,0.74327e+01_r8 /)
      kbo(:, 1,51,14) = (/ &
        & 0.52191e+01_r8,0.73982e+01_r8,0.83585e+01_r8,0.77548e+01_r8,0.63504e+01_r8 /)
      kbo(:, 2,51,14) = (/ &
        & 0.57281e+01_r8,0.76566e+01_r8,0.85673e+01_r8,0.79002e+01_r8,0.66408e+01_r8 /)
      kbo(:, 3,51,14) = (/ &
        & 0.61850e+01_r8,0.78612e+01_r8,0.87206e+01_r8,0.80029e+01_r8,0.69102e+01_r8 /)
      kbo(:, 4,51,14) = (/ &
        & 0.66013e+01_r8,0.80131e+01_r8,0.88169e+01_r8,0.80719e+01_r8,0.71542e+01_r8 /)
      kbo(:, 5,51,14) = (/ &
        & 0.69630e+01_r8,0.81207e+01_r8,0.88611e+01_r8,0.81171e+01_r8,0.73645e+01_r8 /)
      kbo(:, 1,52,14) = (/ &
        & 0.50203e+01_r8,0.72853e+01_r8,0.82659e+01_r8,0.76900e+01_r8,0.62362e+01_r8 /)
      kbo(:, 2,52,14) = (/ &
        & 0.55489e+01_r8,0.75692e+01_r8,0.84974e+01_r8,0.78525e+01_r8,0.65380e+01_r8 /)
      kbo(:, 3,52,14) = (/ &
        & 0.60223e+01_r8,0.77933e+01_r8,0.86726e+01_r8,0.79710e+01_r8,0.68148e+01_r8 /)
      kbo(:, 4,52,14) = (/ &
        & 0.64533e+01_r8,0.79619e+01_r8,0.87883e+01_r8,0.80495e+01_r8,0.70682e+01_r8 /)
      kbo(:, 5,52,14) = (/ &
        & 0.68363e+01_r8,0.80853e+01_r8,0.88509e+01_r8,0.81034e+01_r8,0.72926e+01_r8 /)
      kbo(:, 1,53,14) = (/ &
        & 0.48171e+01_r8,0.71626e+01_r8,0.81646e+01_r8,0.76188e+01_r8,0.61179e+01_r8 /)
      kbo(:, 2,53,14) = (/ &
        & 0.53620e+01_r8,0.74745e+01_r8,0.84206e+01_r8,0.77982e+01_r8,0.64310e+01_r8 /)
      kbo(:, 3,53,14) = (/ &
        & 0.58544e+01_r8,0.77168e+01_r8,0.86150e+01_r8,0.79329e+01_r8,0.67166e+01_r8 /)
      kbo(:, 4,53,14) = (/ &
        & 0.63007e+01_r8,0.79064e+01_r8,0.87527e+01_r8,0.80244e+01_r8,0.69787e+01_r8 /)
      kbo(:, 5,53,14) = (/ &
        & 0.67036e+01_r8,0.80457e+01_r8,0.88348e+01_r8,0.80870e+01_r8,0.72150e+01_r8 /)
      kbo(:, 1,54,14) = (/ &
        & 0.46268e+01_r8,0.70415e+01_r8,0.80643e+01_r8,0.75453e+01_r8,0.60051e+01_r8 /)
      kbo(:, 2,54,14) = (/ &
        & 0.51834e+01_r8,0.73793e+01_r8,0.83436e+01_r8,0.77439e+01_r8,0.63304e+01_r8 /)
      kbo(:, 3,54,14) = (/ &
        & 0.56952e+01_r8,0.76416e+01_r8,0.85557e+01_r8,0.78930e+01_r8,0.66233e+01_r8 /)
      kbo(:, 4,54,14) = (/ &
        & 0.61555e+01_r8,0.78501e+01_r8,0.87136e+01_r8,0.79986e+01_r8,0.68935e+01_r8 /)
      kbo(:, 5,54,14) = (/ &
        & 0.65754e+01_r8,0.80055e+01_r8,0.88139e+01_r8,0.80689e+01_r8,0.71391e+01_r8 /)
      kbo(:, 1,55,14) = (/ &
        & 0.44418e+01_r8,0.69152e+01_r8,0.79589e+01_r8,0.74683e+01_r8,0.58909e+01_r8 /)
      kbo(:, 2,55,14) = (/ &
        & 0.50082e+01_r8,0.72786e+01_r8,0.82608e+01_r8,0.76866e+01_r8,0.62296e+01_r8 /)
      kbo(:, 3,55,14) = (/ &
        & 0.55372e+01_r8,0.75641e+01_r8,0.84935e+01_r8,0.78502e+01_r8,0.65324e+01_r8 /)
      kbo(:, 4,55,14) = (/ &
        & 0.60119e+01_r8,0.77891e+01_r8,0.86705e+01_r8,0.79700e+01_r8,0.68094e+01_r8 /)
      kbo(:, 5,55,14) = (/ &
        & 0.64443e+01_r8,0.79596e+01_r8,0.87874e+01_r8,0.80489e+01_r8,0.70636e+01_r8 /)
      kbo(:, 1,56,14) = (/ &
        & 0.42552e+01_r8,0.67816e+01_r8,0.78463e+01_r8,0.73861e+01_r8,0.57693e+01_r8 /)
      kbo(:, 2,56,14) = (/ &
        & 0.48302e+01_r8,0.71710e+01_r8,0.81721e+01_r8,0.76241e+01_r8,0.61259e+01_r8 /)
      kbo(:, 3,56,14) = (/ &
        & 0.53736e+01_r8,0.74812e+01_r8,0.84261e+01_r8,0.78026e+01_r8,0.64389e+01_r8 /)
      kbo(:, 4,56,14) = (/ &
        & 0.58648e+01_r8,0.77223e+01_r8,0.86198e+01_r8,0.79361e+01_r8,0.67232e+01_r8 /)
      kbo(:, 5,56,14) = (/ &
        & 0.63103e+01_r8,0.79105e+01_r8,0.87564e+01_r8,0.80271e+01_r8,0.69853e+01_r8 /)
      kbo(:, 1,57,14) = (/ &
        & 0.40639e+01_r8,0.66394e+01_r8,0.77238e+01_r8,0.72954e+01_r8,0.56390e+01_r8 /)
      kbo(:, 2,57,14) = (/ &
        & 0.46488e+01_r8,0.70563e+01_r8,0.80768e+01_r8,0.75544e+01_r8,0.60187e+01_r8 /)
      kbo(:, 3,57,14) = (/ &
        & 0.52035e+01_r8,0.73909e+01_r8,0.83529e+01_r8,0.77510e+01_r8,0.63425e+01_r8 /)
      kbo(:, 4,57,14) = (/ &
        & 0.57137e+01_r8,0.76510e+01_r8,0.85638e+01_r8,0.78985e+01_r8,0.66342e+01_r8 /)
      kbo(:, 5,57,14) = (/ &
        & 0.61722e+01_r8,0.78574e+01_r8,0.87192e+01_r8,0.80023e+01_r8,0.69038e+01_r8 /)
      kbo(:, 1,58,14) = (/ &
        & 0.38805e+01_r8,0.64976e+01_r8,0.75961e+01_r8,0.72010e+01_r8,0.55107e+01_r8 /)
      kbo(:, 2,58,14) = (/ &
        & 0.44745e+01_r8,0.69383e+01_r8,0.79787e+01_r8,0.74825e+01_r8,0.59115e+01_r8 /)
      kbo(:, 3,58,14) = (/ &
        & 0.50386e+01_r8,0.72976e+01_r8,0.82763e+01_r8,0.76973e+01_r8,0.62480e+01_r8 /)
      kbo(:, 4,58,14) = (/ &
        & 0.55648e+01_r8,0.75780e+01_r8,0.85055e+01_r8,0.78586e+01_r8,0.65486e+01_r8 /)
      kbo(:, 5,58,14) = (/ &
        & 0.60366e+01_r8,0.78002e+01_r8,0.86790e+01_r8,0.79756e+01_r8,0.68245e+01_r8 /)
      kbo(:, 1,59,14) = (/ &
        & 0.38057e+01_r8,0.64388e+01_r8,0.75416e+01_r8,0.71615e+01_r8,0.54582e+01_r8 /)
      kbo(:, 2,59,14) = (/ &
        & 0.44044e+01_r8,0.68893e+01_r8,0.79374e+01_r8,0.74528e+01_r8,0.58671e+01_r8 /)
      kbo(:, 3,59,14) = (/ &
        & 0.49711e+01_r8,0.72574e+01_r8,0.82432e+01_r8,0.76750e+01_r8,0.62091e+01_r8 /)
      kbo(:, 4,59,14) = (/ &
        & 0.55038e+01_r8,0.75476e+01_r8,0.84809e+01_r8,0.78415e+01_r8,0.65137e+01_r8 /)
      kbo(:, 5,59,14) = (/ &
        & 0.59820e+01_r8,0.77764e+01_r8,0.86612e+01_r8,0.79636e+01_r8,0.67922e+01_r8 /)
      kbo(:, 1,13,15) = (/ &
        & 0.21583e+02_r8,0.16708e+02_r8,0.15578e+02_r8,0.16324e+02_r8,0.21499e+02_r8 /)
      kbo(:, 2,13,15) = (/ &
        & 0.21596e+02_r8,0.16646e+02_r8,0.15448e+02_r8,0.16116e+02_r8,0.21237e+02_r8 /)
      kbo(:, 3,13,15) = (/ &
        & 0.21561e+02_r8,0.16562e+02_r8,0.15303e+02_r8,0.15881e+02_r8,0.20975e+02_r8 /)
      kbo(:, 4,13,15) = (/ &
        & 0.21482e+02_r8,0.16444e+02_r8,0.15131e+02_r8,0.15663e+02_r8,0.20709e+02_r8 /)
      kbo(:, 5,13,15) = (/ &
        & 0.21360e+02_r8,0.16308e+02_r8,0.14933e+02_r8,0.15443e+02_r8,0.20449e+02_r8 /)
      kbo(:, 1,14,15) = (/ &
        & 0.23286e+02_r8,0.18105e+02_r8,0.17022e+02_r8,0.17494e+02_r8,0.22811e+02_r8 /)
      kbo(:, 2,14,15) = (/ &
        & 0.23268e+02_r8,0.18001e+02_r8,0.16845e+02_r8,0.17259e+02_r8,0.22563e+02_r8 /)
      kbo(:, 3,14,15) = (/ &
        & 0.23185e+02_r8,0.17865e+02_r8,0.16645e+02_r8,0.17010e+02_r8,0.22295e+02_r8 /)
      kbo(:, 4,14,15) = (/ &
        & 0.23065e+02_r8,0.17707e+02_r8,0.16417e+02_r8,0.16757e+02_r8,0.22015e+02_r8 /)
      kbo(:, 5,14,15) = (/ &
        & 0.22894e+02_r8,0.17515e+02_r8,0.16163e+02_r8,0.16504e+02_r8,0.21733e+02_r8 /)
      kbo(:, 1,15,15) = (/ &
        & 0.24991e+02_r8,0.19505e+02_r8,0.18411e+02_r8,0.18638e+02_r8,0.24057e+02_r8 /)
      kbo(:, 2,15,15) = (/ &
        & 0.24920e+02_r8,0.19349e+02_r8,0.18180e+02_r8,0.18374e+02_r8,0.23810e+02_r8 /)
      kbo(:, 3,15,15) = (/ &
        & 0.24797e+02_r8,0.19155e+02_r8,0.17917e+02_r8,0.18103e+02_r8,0.23536e+02_r8 /)
      kbo(:, 4,15,15) = (/ &
        & 0.24619e+02_r8,0.18942e+02_r8,0.17624e+02_r8,0.17814e+02_r8,0.23238e+02_r8 /)
      kbo(:, 5,15,15) = (/ &
        & 0.24389e+02_r8,0.18694e+02_r8,0.17313e+02_r8,0.17524e+02_r8,0.22925e+02_r8 /)
      kbo(:, 1,16,15) = (/ &
        & 0.26656e+02_r8,0.20879e+02_r8,0.19716e+02_r8,0.19730e+02_r8,0.25227e+02_r8 /)
      kbo(:, 2,16,15) = (/ &
        & 0.26523e+02_r8,0.20660e+02_r8,0.19424e+02_r8,0.19442e+02_r8,0.24961e+02_r8 /)
      kbo(:, 3,16,15) = (/ &
        & 0.26348e+02_r8,0.20405e+02_r8,0.19093e+02_r8,0.19135e+02_r8,0.24671e+02_r8 /)
      kbo(:, 4,16,15) = (/ &
        & 0.26107e+02_r8,0.20124e+02_r8,0.18741e+02_r8,0.18812e+02_r8,0.24357e+02_r8 /)
      kbo(:, 5,16,15) = (/ &
        & 0.25816e+02_r8,0.19816e+02_r8,0.18364e+02_r8,0.18476e+02_r8,0.24001e+02_r8 /)
      kbo(:, 1,17,15) = (/ &
        & 0.28242e+02_r8,0.22184e+02_r8,0.20936e+02_r8,0.20769e+02_r8,0.26307e+02_r8 /)
      kbo(:, 2,17,15) = (/ &
        & 0.28053e+02_r8,0.21895e+02_r8,0.20570e+02_r8,0.20444e+02_r8,0.26016e+02_r8 /)
      kbo(:, 3,17,15) = (/ &
        & 0.27803e+02_r8,0.21584e+02_r8,0.20174e+02_r8,0.20096e+02_r8,0.25702e+02_r8 /)
      kbo(:, 4,17,15) = (/ &
        & 0.27499e+02_r8,0.21233e+02_r8,0.19753e+02_r8,0.19726e+02_r8,0.25351e+02_r8 /)
      kbo(:, 5,17,15) = (/ &
        & 0.27139e+02_r8,0.20859e+02_r8,0.19319e+02_r8,0.19342e+02_r8,0.24955e+02_r8 /)
      kbo(:, 1,18,15) = (/ &
        & 0.29720e+02_r8,0.23411e+02_r8,0.22065e+02_r8,0.21731e+02_r8,0.27280e+02_r8 /)
      kbo(:, 2,18,15) = (/ &
        & 0.29480e+02_r8,0.23053e+02_r8,0.21624e+02_r8,0.21360e+02_r8,0.26972e+02_r8 /)
      kbo(:, 3,18,15) = (/ &
        & 0.29159e+02_r8,0.22667e+02_r8,0.21156e+02_r8,0.20967e+02_r8,0.26625e+02_r8 /)
      kbo(:, 4,18,15) = (/ &
        & 0.28776e+02_r8,0.22248e+02_r8,0.20663e+02_r8,0.20553e+02_r8,0.26229e+02_r8 /)
      kbo(:, 5,18,15) = (/ &
        & 0.28340e+02_r8,0.21810e+02_r8,0.20170e+02_r8,0.20119e+02_r8,0.25790e+02_r8 /)
      kbo(:, 1,19,15) = (/ &
        & 0.31079e+02_r8,0.24533e+02_r8,0.23084e+02_r8,0.22601e+02_r8,0.28156e+02_r8 /)
      kbo(:, 2,19,15) = (/ &
        & 0.30766e+02_r8,0.24108e+02_r8,0.22572e+02_r8,0.22185e+02_r8,0.27815e+02_r8 /)
      kbo(:, 3,19,15) = (/ &
        & 0.30376e+02_r8,0.23641e+02_r8,0.22030e+02_r8,0.21741e+02_r8,0.27429e+02_r8 /)
      kbo(:, 4,19,15) = (/ &
        & 0.29923e+02_r8,0.23160e+02_r8,0.21471e+02_r8,0.21280e+02_r8,0.26992e+02_r8 /)
      kbo(:, 5,19,15) = (/ &
        & 0.29415e+02_r8,0.22660e+02_r8,0.20920e+02_r8,0.20797e+02_r8,0.26511e+02_r8 /)
      kbo(:, 1,20,15) = (/ &
        & 0.32290e+02_r8,0.25527e+02_r8,0.23984e+02_r8,0.23373e+02_r8,0.28918e+02_r8 /)
      kbo(:, 2,20,15) = (/ &
        & 0.31907e+02_r8,0.25035e+02_r8,0.23397e+02_r8,0.22899e+02_r8,0.28537e+02_r8 /)
      kbo(:, 3,20,15) = (/ &
        & 0.31450e+02_r8,0.24496e+02_r8,0.22784e+02_r8,0.22408e+02_r8,0.28112e+02_r8 /)
      kbo(:, 4,20,15) = (/ &
        & 0.30926e+02_r8,0.23946e+02_r8,0.22166e+02_r8,0.21898e+02_r8,0.27628e+02_r8 /)
      kbo(:, 5,20,15) = (/ &
        & 0.30351e+02_r8,0.23384e+02_r8,0.21559e+02_r8,0.21369e+02_r8,0.27109e+02_r8 /)
      kbo(:, 1,21,15) = (/ &
        & 0.33354e+02_r8,0.26397e+02_r8,0.24768e+02_r8,0.24040e+02_r8,0.29575e+02_r8 /)
      kbo(:, 2,21,15) = (/ &
        & 0.32901e+02_r8,0.25842e+02_r8,0.24107e+02_r8,0.23511e+02_r8,0.29153e+02_r8 /)
      kbo(:, 3,21,15) = (/ &
        & 0.32374e+02_r8,0.25240e+02_r8,0.23426e+02_r8,0.22972e+02_r8,0.28686e+02_r8 /)
      kbo(:, 4,21,15) = (/ &
        & 0.31781e+02_r8,0.24624e+02_r8,0.22754e+02_r8,0.22416e+02_r8,0.28162e+02_r8 /)
      kbo(:, 5,21,15) = (/ &
        & 0.31147e+02_r8,0.24003e+02_r8,0.22095e+02_r8,0.21845e+02_r8,0.27608e+02_r8 /)
      kbo(:, 1,22,15) = (/ &
        & 0.34245e+02_r8,0.27109e+02_r8,0.25388e+02_r8,0.24566e+02_r8,0.30099e+02_r8 /)
      kbo(:, 2,22,15) = (/ &
        & 0.33719e+02_r8,0.26481e+02_r8,0.24655e+02_r8,0.23987e+02_r8,0.29635e+02_r8 /)
      kbo(:, 3,22,15) = (/ &
        & 0.33121e+02_r8,0.25821e+02_r8,0.23916e+02_r8,0.23403e+02_r8,0.29124e+02_r8 /)
      kbo(:, 4,22,15) = (/ &
        & 0.32461e+02_r8,0.25147e+02_r8,0.23196e+02_r8,0.22805e+02_r8,0.28562e+02_r8 /)
      kbo(:, 5,22,15) = (/ &
        & 0.31774e+02_r8,0.24482e+02_r8,0.22495e+02_r8,0.22197e+02_r8,0.27979e+02_r8 /)
      kbo(:, 1,23,15) = (/ &
        & 0.34979e+02_r8,0.27686e+02_r8,0.25885e+02_r8,0.24985e+02_r8,0.30523e+02_r8 /)
      kbo(:, 2,23,15) = (/ &
        & 0.34390e+02_r8,0.26989e+02_r8,0.25088e+02_r8,0.24366e+02_r8,0.30015e+02_r8 /)
      kbo(:, 3,23,15) = (/ &
        & 0.33724e+02_r8,0.26279e+02_r8,0.24300e+02_r8,0.23742e+02_r8,0.29464e+02_r8 /)
      kbo(:, 4,23,15) = (/ &
        & 0.33013e+02_r8,0.25562e+02_r8,0.23538e+02_r8,0.23108e+02_r8,0.28875e+02_r8 /)
      kbo(:, 5,23,15) = (/ &
        & 0.32269e+02_r8,0.24853e+02_r8,0.22796e+02_r8,0.22467e+02_r8,0.28265e+02_r8 /)
      kbo(:, 1,24,15) = (/ &
        & 0.35573e+02_r8,0.28136e+02_r8,0.26264e+02_r8,0.25305e+02_r8,0.30849e+02_r8 /)
      kbo(:, 2,24,15) = (/ &
        & 0.34922e+02_r8,0.27387e+02_r8,0.25413e+02_r8,0.24653e+02_r8,0.30308e+02_r8 /)
      kbo(:, 3,24,15) = (/ &
        & 0.34200e+02_r8,0.26632e+02_r8,0.24587e+02_r8,0.23994e+02_r8,0.29723e+02_r8 /)
      kbo(:, 4,24,15) = (/ &
        & 0.33439e+02_r8,0.25872e+02_r8,0.23787e+02_r8,0.23329e+02_r8,0.29105e+02_r8 /)
      kbo(:, 5,24,15) = (/ &
        & 0.32647e+02_r8,0.25128e+02_r8,0.23014e+02_r8,0.22661e+02_r8,0.28477e+02_r8 /)
      kbo(:, 1,25,15) = (/ &
        & 0.36033e+02_r8,0.28469e+02_r8,0.26533e+02_r8,0.25539e+02_r8,0.31091e+02_r8 /)
      kbo(:, 2,25,15) = (/ &
        & 0.35324e+02_r8,0.27679e+02_r8,0.25640e+02_r8,0.24852e+02_r8,0.30512e+02_r8 /)
      kbo(:, 3,25,15) = (/ &
        & 0.34555e+02_r8,0.26887e+02_r8,0.24782e+02_r8,0.24167e+02_r8,0.29902e+02_r8 /)
      kbo(:, 4,25,15) = (/ &
        & 0.33752e+02_r8,0.26092e+02_r8,0.23953e+02_r8,0.23474e+02_r8,0.29262e+02_r8 /)
      kbo(:, 5,25,15) = (/ &
        & 0.32915e+02_r8,0.25319e+02_r8,0.23155e+02_r8,0.22787e+02_r8,0.28617e+02_r8 /)
      kbo(:, 1,26,15) = (/ &
        & 0.36371e+02_r8,0.28696e+02_r8,0.26697e+02_r8,0.25688e+02_r8,0.31254e+02_r8 /)
      kbo(:, 2,26,15) = (/ &
        & 0.35607e+02_r8,0.27872e+02_r8,0.25775e+02_r8,0.24975e+02_r8,0.30642e+02_r8 /)
      kbo(:, 3,26,15) = (/ &
        & 0.34798e+02_r8,0.27047e+02_r8,0.24890e+02_r8,0.24264e+02_r8,0.30007e+02_r8 /)
      kbo(:, 4,26,15) = (/ &
        & 0.33956e+02_r8,0.26227e+02_r8,0.24040e+02_r8,0.23549e+02_r8,0.29351e+02_r8 /)
      kbo(:, 5,26,15) = (/ &
        & 0.33076e+02_r8,0.25425e+02_r8,0.23222e+02_r8,0.22845e+02_r8,0.28688e+02_r8 /)
      kbo(:, 1,27,15) = (/ &
        & 0.36605e+02_r8,0.28839e+02_r8,0.26780e+02_r8,0.25770e+02_r8,0.31349e+02_r8 /)
      kbo(:, 2,27,15) = (/ &
        & 0.35796e+02_r8,0.27987e+02_r8,0.25836e+02_r8,0.25037e+02_r8,0.30713e+02_r8 /)
      kbo(:, 3,27,15) = (/ &
        & 0.34952e+02_r8,0.27136e+02_r8,0.24934e+02_r8,0.24306e+02_r8,0.30059e+02_r8 /)
      kbo(:, 4,27,15) = (/ &
        & 0.34075e+02_r8,0.26294e+02_r8,0.24068e+02_r8,0.23575e+02_r8,0.29392e+02_r8 /)
      kbo(:, 5,27,15) = (/ &
        & 0.33166e+02_r8,0.25473e+02_r8,0.23238e+02_r8,0.22856e+02_r8,0.28711e+02_r8 /)
      kbo(:, 1,28,15) = (/ &
        & 0.36758e+02_r8,0.28917e+02_r8,0.26804e+02_r8,0.25803e+02_r8,0.31396e+02_r8 /)
      kbo(:, 2,28,15) = (/ &
        & 0.35910e+02_r8,0.28037e+02_r8,0.25842e+02_r8,0.25051e+02_r8,0.30739e+02_r8 /)
      kbo(:, 3,28,15) = (/ &
        & 0.35033e+02_r8,0.27165e+02_r8,0.24925e+02_r8,0.24304e+02_r8,0.30070e+02_r8 /)
      kbo(:, 4,28,15) = (/ &
        & 0.34125e+02_r8,0.26307e+02_r8,0.24049e+02_r8,0.23563e+02_r8,0.29393e+02_r8 /)
      kbo(:, 5,28,15) = (/ &
        & 0.33188e+02_r8,0.25468e+02_r8,0.23210e+02_r8,0.22829e+02_r8,0.28695e+02_r8 /)
      kbo(:, 1,29,15) = (/ &
        & 0.36829e+02_r8,0.28926e+02_r8,0.26766e+02_r8,0.25785e+02_r8,0.31393e+02_r8 /)
      kbo(:, 2,29,15) = (/ &
        & 0.35949e+02_r8,0.28025e+02_r8,0.25792e+02_r8,0.25019e+02_r8,0.30723e+02_r8 /)
      kbo(:, 3,29,15) = (/ &
        & 0.35045e+02_r8,0.27141e+02_r8,0.24868e+02_r8,0.24260e+02_r8,0.30042e+02_r8 /)
      kbo(:, 4,29,15) = (/ &
        & 0.34114e+02_r8,0.26272e+02_r8,0.23986e+02_r8,0.23509e+02_r8,0.29353e+02_r8 /)
      kbo(:, 5,29,15) = (/ &
        & 0.33154e+02_r8,0.25419e+02_r8,0.23142e+02_r8,0.22765e+02_r8,0.28643e+02_r8 /)
      kbo(:, 1,30,15) = (/ &
        & 0.36836e+02_r8,0.28884e+02_r8,0.26681e+02_r8,0.25729e+02_r8,0.31353e+02_r8 /)
      kbo(:, 2,30,15) = (/ &
        & 0.35935e+02_r8,0.27972e+02_r8,0.25704e+02_r8,0.24955e+02_r8,0.30675e+02_r8 /)
      kbo(:, 3,30,15) = (/ &
        & 0.35002e+02_r8,0.27075e+02_r8,0.24775e+02_r8,0.24184e+02_r8,0.29984e+02_r8 /)
      kbo(:, 4,30,15) = (/ &
        & 0.34050e+02_r8,0.26196e+02_r8,0.23891e+02_r8,0.23427e+02_r8,0.29283e+02_r8 /)
      kbo(:, 5,30,15) = (/ &
        & 0.33076e+02_r8,0.25337e+02_r8,0.23046e+02_r8,0.22676e+02_r8,0.28566e+02_r8 /)
      kbo(:, 1,31,15) = (/ &
        & 0.36791e+02_r8,0.28797e+02_r8,0.26557e+02_r8,0.25640e+02_r8,0.31284e+02_r8 /)
      kbo(:, 2,31,15) = (/ &
        & 0.35869e+02_r8,0.27877e+02_r8,0.25582e+02_r8,0.24857e+02_r8,0.30596e+02_r8 /)
      kbo(:, 3,31,15) = (/ &
        & 0.34914e+02_r8,0.26971e+02_r8,0.24653e+02_r8,0.24083e+02_r8,0.29901e+02_r8 /)
      kbo(:, 4,31,15) = (/ &
        & 0.33941e+02_r8,0.26084e+02_r8,0.23767e+02_r8,0.23319e+02_r8,0.29185e+02_r8 /)
      kbo(:, 5,31,15) = (/ &
        & 0.32958e+02_r8,0.25224e+02_r8,0.22924e+02_r8,0.22563e+02_r8,0.28464e+02_r8 /)
      kbo(:, 1,32,15) = (/ &
        & 0.36704e+02_r8,0.28676e+02_r8,0.26402e+02_r8,0.25521e+02_r8,0.31186e+02_r8 /)
      kbo(:, 2,32,15) = (/ &
        & 0.35759e+02_r8,0.27748e+02_r8,0.25429e+02_r8,0.24734e+02_r8,0.30492e+02_r8 /)
      kbo(:, 3,32,15) = (/ &
        & 0.34789e+02_r8,0.26839e+02_r8,0.24504e+02_r8,0.23956e+02_r8,0.29792e+02_r8 /)
      kbo(:, 4,32,15) = (/ &
        & 0.33799e+02_r8,0.25947e+02_r8,0.23622e+02_r8,0.23189e+02_r8,0.29067e+02_r8 /)
      kbo(:, 5,32,15) = (/ &
        & 0.32807e+02_r8,0.25086e+02_r8,0.22780e+02_r8,0.22431e+02_r8,0.28343e+02_r8 /)
      kbo(:, 1,33,15) = (/ &
        & 0.36581e+02_r8,0.28529e+02_r8,0.26229e+02_r8,0.25386e+02_r8,0.31076e+02_r8 /)
      kbo(:, 2,33,15) = (/ &
        & 0.35618e+02_r8,0.27597e+02_r8,0.25258e+02_r8,0.24592e+02_r8,0.30373e+02_r8 /)
      kbo(:, 3,33,15) = (/ &
        & 0.34634e+02_r8,0.26685e+02_r8,0.24337e+02_r8,0.23815e+02_r8,0.29666e+02_r8 /)
      kbo(:, 4,33,15) = (/ &
        & 0.33632e+02_r8,0.25791e+02_r8,0.23459e+02_r8,0.23042e+02_r8,0.28931e+02_r8 /)
      kbo(:, 5,33,15) = (/ &
        & 0.32632e+02_r8,0.24931e+02_r8,0.22622e+02_r8,0.22288e+02_r8,0.28210e+02_r8 /)
      kbo(:, 1,34,15) = (/ &
        & 0.36458e+02_r8,0.28392e+02_r8,0.26072e+02_r8,0.25264e+02_r8,0.30972e+02_r8 /)
      kbo(:, 2,34,15) = (/ &
        & 0.35483e+02_r8,0.27459e+02_r8,0.25106e+02_r8,0.24467e+02_r8,0.30265e+02_r8 /)
      kbo(:, 3,34,15) = (/ &
        & 0.34486e+02_r8,0.26542e+02_r8,0.24189e+02_r8,0.23688e+02_r8,0.29550e+02_r8 /)
      kbo(:, 4,34,15) = (/ &
        & 0.33480e+02_r8,0.25653e+02_r8,0.23315e+02_r8,0.22913e+02_r8,0.28811e+02_r8 /)
      kbo(:, 5,34,15) = (/ &
        & 0.32478e+02_r8,0.24793e+02_r8,0.22484e+02_r8,0.22163e+02_r8,0.28094e+02_r8 /)
      kbo(:, 1,35,15) = (/ &
        & 0.36414e+02_r8,0.28334e+02_r8,0.25999e+02_r8,0.25206e+02_r8,0.30923e+02_r8 /)
      kbo(:, 2,35,15) = (/ &
        & 0.35425e+02_r8,0.27395e+02_r8,0.25033e+02_r8,0.24406e+02_r8,0.30215e+02_r8 /)
      kbo(:, 3,35,15) = (/ &
        & 0.34420e+02_r8,0.26476e+02_r8,0.24117e+02_r8,0.23624e+02_r8,0.29493e+02_r8 /)
      kbo(:, 4,35,15) = (/ &
        & 0.33407e+02_r8,0.25585e+02_r8,0.23243e+02_r8,0.22849e+02_r8,0.28753e+02_r8 /)
      kbo(:, 5,35,15) = (/ &
        & 0.32403e+02_r8,0.24726e+02_r8,0.22415e+02_r8,0.22101e+02_r8,0.28034e+02_r8 /)
      kbo(:, 1,36,15) = (/ &
        & 0.36456e+02_r8,0.28365e+02_r8,0.26023e+02_r8,0.25227e+02_r8,0.30947e+02_r8 /)
      kbo(:, 2,36,15) = (/ &
        & 0.35465e+02_r8,0.27424e+02_r8,0.25054e+02_r8,0.24425e+02_r8,0.30235e+02_r8 /)
      kbo(:, 3,36,15) = (/ &
        & 0.34451e+02_r8,0.26498e+02_r8,0.24134e+02_r8,0.23640e+02_r8,0.29510e+02_r8 /)
      kbo(:, 4,36,15) = (/ &
        & 0.33436e+02_r8,0.25606e+02_r8,0.23259e+02_r8,0.22862e+02_r8,0.28768e+02_r8 /)
      kbo(:, 5,36,15) = (/ &
        & 0.32427e+02_r8,0.24743e+02_r8,0.22427e+02_r8,0.22112e+02_r8,0.28048e+02_r8 /)
      kbo(:, 1,37,15) = (/ &
        & 0.36638e+02_r8,0.28533e+02_r8,0.26191e+02_r8,0.25363e+02_r8,0.31069e+02_r8 /)
      kbo(:, 2,37,15) = (/ &
        & 0.35645e+02_r8,0.27585e+02_r8,0.25212e+02_r8,0.24557e+02_r8,0.30356e+02_r8 /)
      kbo(:, 3,37,15) = (/ &
        & 0.34632e+02_r8,0.26655e+02_r8,0.24283e+02_r8,0.23768e+02_r8,0.29633e+02_r8 /)
      kbo(:, 4,37,15) = (/ &
        & 0.33611e+02_r8,0.25753e+02_r8,0.23398e+02_r8,0.22987e+02_r8,0.28889e+02_r8 /)
      kbo(:, 5,37,15) = (/ &
        & 0.32597e+02_r8,0.24885e+02_r8,0.22559e+02_r8,0.22230e+02_r8,0.28165e+02_r8 /)
      kbo(:, 1,38,15) = (/ &
        & 0.36818e+02_r8,0.28702e+02_r8,0.26363e+02_r8,0.25503e+02_r8,0.31194e+02_r8 /)
      kbo(:, 2,38,15) = (/ &
        & 0.35825e+02_r8,0.27749e+02_r8,0.25373e+02_r8,0.24692e+02_r8,0.30479e+02_r8 /)
      kbo(:, 3,38,15) = (/ &
        & 0.34809e+02_r8,0.26811e+02_r8,0.24434e+02_r8,0.23900e+02_r8,0.29757e+02_r8 /)
      kbo(:, 4,38,15) = (/ &
        & 0.33789e+02_r8,0.25904e+02_r8,0.23543e+02_r8,0.23114e+02_r8,0.29012e+02_r8 /)
      kbo(:, 5,38,15) = (/ &
        & 0.32767e+02_r8,0.25028e+02_r8,0.22694e+02_r8,0.22351e+02_r8,0.28285e+02_r8 /)
      kbo(:, 1,39,15) = (/ &
        & 0.36989e+02_r8,0.28865e+02_r8,0.26530e+02_r8,0.25636e+02_r8,0.31312e+02_r8 /)
      kbo(:, 2,39,15) = (/ &
        & 0.35999e+02_r8,0.27907e+02_r8,0.25529e+02_r8,0.24823e+02_r8,0.30597e+02_r8 /)
      kbo(:, 3,39,15) = (/ &
        & 0.34983e+02_r8,0.26966e+02_r8,0.24583e+02_r8,0.24027e+02_r8,0.29878e+02_r8 /)
      kbo(:, 4,39,15) = (/ &
        & 0.33957e+02_r8,0.26048e+02_r8,0.23683e+02_r8,0.23240e+02_r8,0.29134e+02_r8 /)
      kbo(:, 5,39,15) = (/ &
        & 0.32935e+02_r8,0.25169e+02_r8,0.22826e+02_r8,0.22468e+02_r8,0.28398e+02_r8 /)
      kbo(:, 1,40,15) = (/ &
        & 0.37254e+02_r8,0.29125e+02_r8,0.26800e+02_r8,0.25853e+02_r8,0.31502e+02_r8 /)
      kbo(:, 2,40,15) = (/ &
        & 0.36269e+02_r8,0.28159e+02_r8,0.25786e+02_r8,0.25036e+02_r8,0.30787e+02_r8 /)
      kbo(:, 3,40,15) = (/ &
        & 0.35253e+02_r8,0.27211e+02_r8,0.24825e+02_r8,0.24233e+02_r8,0.30069e+02_r8 /)
      kbo(:, 4,40,15) = (/ &
        & 0.34229e+02_r8,0.26287e+02_r8,0.23913e+02_r8,0.23442e+02_r8,0.29327e+02_r8 /)
      kbo(:, 5,40,15) = (/ &
        & 0.33202e+02_r8,0.25396e+02_r8,0.23042e+02_r8,0.22665e+02_r8,0.28587e+02_r8 /)
      kbo(:, 1,41,15) = (/ &
        & 0.37526e+02_r8,0.29396e+02_r8,0.27087e+02_r8,0.26081e+02_r8,0.31701e+02_r8 /)
      kbo(:, 2,41,15) = (/ &
        & 0.36546e+02_r8,0.28422e+02_r8,0.26056e+02_r8,0.25257e+02_r8,0.30982e+02_r8 /)
      kbo(:, 3,41,15) = (/ &
        & 0.35534e+02_r8,0.27467e+02_r8,0.25079e+02_r8,0.24448e+02_r8,0.30265e+02_r8 /)
      kbo(:, 4,41,15) = (/ &
        & 0.34510e+02_r8,0.26534e+02_r8,0.24153e+02_r8,0.23654e+02_r8,0.29528e+02_r8 /)
      kbo(:, 5,41,15) = (/ &
        & 0.33481e+02_r8,0.25633e+02_r8,0.23271e+02_r8,0.22872e+02_r8,0.28783e+02_r8 /)
      kbo(:, 1,42,15) = (/ &
        & 0.37791e+02_r8,0.29665e+02_r8,0.27375e+02_r8,0.26306e+02_r8,0.31897e+02_r8 /)
      kbo(:, 2,42,15) = (/ &
        & 0.36818e+02_r8,0.28682e+02_r8,0.26328e+02_r8,0.25479e+02_r8,0.31179e+02_r8 /)
      kbo(:, 3,42,15) = (/ &
        & 0.35814e+02_r8,0.27725e+02_r8,0.25336e+02_r8,0.24663e+02_r8,0.30459e+02_r8 /)
      kbo(:, 4,42,15) = (/ &
        & 0.34792e+02_r8,0.26784e+02_r8,0.24397e+02_r8,0.23867e+02_r8,0.29730e+02_r8 /)
      kbo(:, 5,42,15) = (/ &
        & 0.33761e+02_r8,0.25873e+02_r8,0.23504e+02_r8,0.23079e+02_r8,0.28983e+02_r8 /)
      kbo(:, 1,43,15) = (/ &
        & 0.38102e+02_r8,0.29987e+02_r8,0.27726e+02_r8,0.26579e+02_r8,0.32132e+02_r8 /)
      kbo(:, 2,43,15) = (/ &
        & 0.37142e+02_r8,0.29000e+02_r8,0.26660e+02_r8,0.25743e+02_r8,0.31410e+02_r8 /)
      kbo(:, 3,43,15) = (/ &
        & 0.36146e+02_r8,0.28034e+02_r8,0.25651e+02_r8,0.24927e+02_r8,0.30694e+02_r8 /)
      kbo(:, 4,43,15) = (/ &
        & 0.35125e+02_r8,0.27087e+02_r8,0.24694e+02_r8,0.24121e+02_r8,0.29968e+02_r8 /)
      kbo(:, 5,43,15) = (/ &
        & 0.34093e+02_r8,0.26161e+02_r8,0.23786e+02_r8,0.23330e+02_r8,0.29223e+02_r8 /)
      kbo(:, 1,44,15) = (/ &
        & 0.38433e+02_r8,0.30339e+02_r8,0.28106e+02_r8,0.26874e+02_r8,0.32381e+02_r8 /)
      kbo(:, 2,44,15) = (/ &
        & 0.37485e+02_r8,0.29344e+02_r8,0.27023e+02_r8,0.26033e+02_r8,0.31664e+02_r8 /)
      kbo(:, 3,44,15) = (/ &
        & 0.36497e+02_r8,0.28368e+02_r8,0.25996e+02_r8,0.25211e+02_r8,0.30945e+02_r8 /)
      kbo(:, 4,44,15) = (/ &
        & 0.35483e+02_r8,0.27414e+02_r8,0.25019e+02_r8,0.24397e+02_r8,0.30221e+02_r8 /)
      kbo(:, 5,44,15) = (/ &
        & 0.34454e+02_r8,0.26480e+02_r8,0.24095e+02_r8,0.23603e+02_r8,0.29482e+02_r8 /)
      kbo(:, 1,45,15) = (/ &
        & 0.38755e+02_r8,0.30690e+02_r8,0.28491e+02_r8,0.27169e+02_r8,0.32624e+02_r8 /)
      kbo(:, 2,45,15) = (/ &
        & 0.37819e+02_r8,0.29686e+02_r8,0.27393e+02_r8,0.26324e+02_r8,0.31916e+02_r8 /)
      kbo(:, 3,45,15) = (/ &
        & 0.36842e+02_r8,0.28700e+02_r8,0.26343e+02_r8,0.25494e+02_r8,0.31195e+02_r8 /)
      kbo(:, 4,45,15) = (/ &
        & 0.35840e+02_r8,0.27743e+02_r8,0.25350e+02_r8,0.24674e+02_r8,0.30470e+02_r8 /)
      kbo(:, 5,45,15) = (/ &
        & 0.34814e+02_r8,0.26800e+02_r8,0.24408e+02_r8,0.23874e+02_r8,0.29739e+02_r8 /)
      kbo(:, 1,46,15) = (/ &
        & 0.39090e+02_r8,0.31065e+02_r8,0.28908e+02_r8,0.27486e+02_r8,0.32877e+02_r8 /)
      kbo(:, 2,46,15) = (/ &
        & 0.38170e+02_r8,0.30050e+02_r8,0.27790e+02_r8,0.26631e+02_r8,0.32180e+02_r8 /)
      kbo(:, 3,46,15) = (/ &
        & 0.37208e+02_r8,0.29060e+02_r8,0.26719e+02_r8,0.25793e+02_r8,0.31457e+02_r8 /)
      kbo(:, 4,46,15) = (/ &
        & 0.36211e+02_r8,0.28091e+02_r8,0.25705e+02_r8,0.24972e+02_r8,0.30735e+02_r8 /)
      kbo(:, 5,46,15) = (/ &
        & 0.35190e+02_r8,0.27143e+02_r8,0.24746e+02_r8,0.24165e+02_r8,0.30011e+02_r8 /)
      kbo(:, 1,47,15) = (/ &
        & 0.39451e+02_r8,0.31490e+02_r8,0.29378e+02_r8,0.27842e+02_r8,0.33145e+02_r8 /)
      kbo(:, 2,47,15) = (/ &
        & 0.38554e+02_r8,0.30463e+02_r8,0.28238e+02_r8,0.26977e+02_r8,0.32470e+02_r8 /)
      kbo(:, 3,47,15) = (/ &
        & 0.37608e+02_r8,0.29464e+02_r8,0.27149e+02_r8,0.26134e+02_r8,0.31753e+02_r8 /)
      kbo(:, 4,47,15) = (/ &
        & 0.36624e+02_r8,0.28485e+02_r8,0.26114e+02_r8,0.25307e+02_r8,0.31030e+02_r8 /)
      kbo(:, 5,47,15) = (/ &
        & 0.35612e+02_r8,0.27529e+02_r8,0.25131e+02_r8,0.24491e+02_r8,0.30307e+02_r8 /)
      kbo(:, 1,48,15) = (/ &
        & 0.39789e+02_r8,0.31912e+02_r8,0.29855e+02_r8,0.28207e+02_r8,0.33402e+02_r8 /)
      kbo(:, 2,48,15) = (/ &
        & 0.38929e+02_r8,0.30877e+02_r8,0.28697e+02_r8,0.27328e+02_r8,0.32755e+02_r8 /)
      kbo(:, 3,48,15) = (/ &
        & 0.38000e+02_r8,0.29868e+02_r8,0.27588e+02_r8,0.26477e+02_r8,0.32050e+02_r8 /)
      kbo(:, 4,48,15) = (/ &
        & 0.37030e+02_r8,0.28879e+02_r8,0.26527e+02_r8,0.25639e+02_r8,0.31322e+02_r8 /)
      kbo(:, 5,48,15) = (/ &
        & 0.36027e+02_r8,0.27916e+02_r8,0.25523e+02_r8,0.24819e+02_r8,0.30601e+02_r8 /)
      kbo(:, 1,49,15) = (/ &
        & 0.40116e+02_r8,0.32336e+02_r8,0.30332e+02_r8,0.28574e+02_r8,0.33637e+02_r8 /)
      kbo(:, 2,49,15) = (/ &
        & 0.39295e+02_r8,0.31299e+02_r8,0.29164e+02_r8,0.27682e+02_r8,0.33028e+02_r8 /)
      kbo(:, 3,49,15) = (/ &
        & 0.38385e+02_r8,0.30275e+02_r8,0.28033e+02_r8,0.26821e+02_r8,0.32341e+02_r8 /)
      kbo(:, 4,49,15) = (/ &
        & 0.37432e+02_r8,0.29281e+02_r8,0.26949e+02_r8,0.25975e+02_r8,0.31615e+02_r8 /)
      kbo(:, 5,49,15) = (/ &
        & 0.36440e+02_r8,0.28306e+02_r8,0.25923e+02_r8,0.25151e+02_r8,0.30893e+02_r8 /)
      kbo(:, 1,50,15) = (/ &
        & 0.40414e+02_r8,0.32736e+02_r8,0.30783e+02_r8,0.28924e+02_r8,0.33845e+02_r8 /)
      kbo(:, 2,50,15) = (/ &
        & 0.39619e+02_r8,0.31694e+02_r8,0.29608e+02_r8,0.28020e+02_r8,0.33276e+02_r8 /)
      kbo(:, 3,50,15) = (/ &
        & 0.38737e+02_r8,0.30661e+02_r8,0.28456e+02_r8,0.27146e+02_r8,0.32609e+02_r8 /)
      kbo(:, 4,50,15) = (/ &
        & 0.37800e+02_r8,0.29658e+02_r8,0.27356e+02_r8,0.26296e+02_r8,0.31894e+02_r8 /)
      kbo(:, 5,50,15) = (/ &
        & 0.36822e+02_r8,0.28673e+02_r8,0.26306e+02_r8,0.25463e+02_r8,0.31168e+02_r8 /)
      kbo(:, 1,51,15) = (/ &
        & 0.40689e+02_r8,0.33123e+02_r8,0.31211e+02_r8,0.29252e+02_r8,0.34023e+02_r8 /)
      kbo(:, 2,51,15) = (/ &
        & 0.39919e+02_r8,0.32076e+02_r8,0.30039e+02_r8,0.28350e+02_r8,0.33499e+02_r8 /)
      kbo(:, 3,51,15) = (/ &
        & 0.39075e+02_r8,0.31039e+02_r8,0.28875e+02_r8,0.27462e+02_r8,0.32860e+02_r8 /)
      kbo(:, 4,51,15) = (/ &
        & 0.38151e+02_r8,0.30023e+02_r8,0.27755e+02_r8,0.26605e+02_r8,0.32160e+02_r8 /)
      kbo(:, 5,51,15) = (/ &
        & 0.37189e+02_r8,0.29033e+02_r8,0.26685e+02_r8,0.25765e+02_r8,0.31432e+02_r8 /)
      kbo(:, 1,52,15) = (/ &
        & 0.40936e+02_r8,0.33510e+02_r8,0.31640e+02_r8,0.29576e+02_r8,0.34183e+02_r8 /)
      kbo(:, 2,52,15) = (/ &
        & 0.40210e+02_r8,0.32459e+02_r8,0.30471e+02_r8,0.28683e+02_r8,0.33706e+02_r8 /)
      kbo(:, 3,52,15) = (/ &
        & 0.39397e+02_r8,0.31418e+02_r8,0.29296e+02_r8,0.27784e+02_r8,0.33107e+02_r8 /)
      kbo(:, 4,52,15) = (/ &
        & 0.38495e+02_r8,0.30394e+02_r8,0.28160e+02_r8,0.26919e+02_r8,0.32422e+02_r8 /)
      kbo(:, 5,52,15) = (/ &
        & 0.37548e+02_r8,0.29397e+02_r8,0.27070e+02_r8,0.26070e+02_r8,0.31697e+02_r8 /)
      kbo(:, 1,53,15) = (/ &
        & 0.41161e+02_r8,0.33900e+02_r8,0.32075e+02_r8,0.29895e+02_r8,0.34325e+02_r8 /)
      kbo(:, 2,53,15) = (/ &
        & 0.40494e+02_r8,0.32844e+02_r8,0.30901e+02_r8,0.29015e+02_r8,0.33898e+02_r8 /)
      kbo(:, 3,53,15) = (/ &
        & 0.39709e+02_r8,0.31802e+02_r8,0.29726e+02_r8,0.28110e+02_r8,0.33339e+02_r8 /)
      kbo(:, 4,53,15) = (/ &
        & 0.38833e+02_r8,0.30766e+02_r8,0.28570e+02_r8,0.27234e+02_r8,0.32680e+02_r8 /)
      kbo(:, 5,53,15) = (/ &
        & 0.37902e+02_r8,0.29761e+02_r8,0.27465e+02_r8,0.26380e+02_r8,0.31966e+02_r8 /)
      kbo(:, 1,54,15) = (/ &
        & 0.41350e+02_r8,0.34259e+02_r8,0.32468e+02_r8,0.30182e+02_r8,0.34433e+02_r8 /)
      kbo(:, 2,54,15) = (/ &
        & 0.40740e+02_r8,0.33197e+02_r8,0.31292e+02_r8,0.29316e+02_r8,0.34057e+02_r8 /)
      kbo(:, 3,54,15) = (/ &
        & 0.39978e+02_r8,0.32149e+02_r8,0.30122e+02_r8,0.28414e+02_r8,0.33542e+02_r8 /)
      kbo(:, 4,54,15) = (/ &
        & 0.39139e+02_r8,0.31111e+02_r8,0.28955e+02_r8,0.27524e+02_r8,0.32911e+02_r8 /)
      kbo(:, 5,54,15) = (/ &
        & 0.38222e+02_r8,0.30095e+02_r8,0.27832e+02_r8,0.26664e+02_r8,0.32209e+02_r8 /)
      kbo(:, 1,55,15) = (/ &
        & 0.41508e+02_r8,0.34608e+02_r8,0.32849e+02_r8,0.30454e+02_r8,0.34522e+02_r8 /)
      kbo(:, 2,55,15) = (/ &
        & 0.40955e+02_r8,0.33539e+02_r8,0.31671e+02_r8,0.29598e+02_r8,0.34194e+02_r8 /)
      kbo(:, 3,55,15) = (/ &
        & 0.40232e+02_r8,0.32485e+02_r8,0.30501e+02_r8,0.28707e+02_r8,0.33722e+02_r8 /)
      kbo(:, 4,55,15) = (/ &
        & 0.39425e+02_r8,0.31448e+02_r8,0.29326e+02_r8,0.27805e+02_r8,0.33122e+02_r8 /)
      kbo(:, 5,55,15) = (/ &
        & 0.38521e+02_r8,0.30419e+02_r8,0.28187e+02_r8,0.26941e+02_r8,0.32441e+02_r8 /)
      kbo(:, 1,56,15) = (/ &
        & 0.41645e+02_r8,0.34957e+02_r8,0.33233e+02_r8,0.30720e+02_r8,0.34599e+02_r8 /)
      kbo(:, 2,56,15) = (/ &
        & 0.41152e+02_r8,0.33880e+02_r8,0.32050e+02_r8,0.29874e+02_r8,0.34316e+02_r8 /)
      kbo(:, 3,56,15) = (/ &
        & 0.40482e+02_r8,0.32823e+02_r8,0.30877e+02_r8,0.28999e+02_r8,0.33890e+02_r8 /)
      kbo(:, 4,56,15) = (/ &
        & 0.39696e+02_r8,0.31783e+02_r8,0.29704e+02_r8,0.28093e+02_r8,0.33329e+02_r8 /)
      kbo(:, 5,56,15) = (/ &
        & 0.38819e+02_r8,0.30747e+02_r8,0.28547e+02_r8,0.27216e+02_r8,0.32666e+02_r8 /)
      kbo(:, 1,57,15) = (/ &
        & 0.41772e+02_r8,0.35313e+02_r8,0.33621e+02_r8,0.30980e+02_r8,0.34653e+02_r8 /)
      kbo(:, 2,57,15) = (/ &
        & 0.41335e+02_r8,0.34223e+02_r8,0.32428e+02_r8,0.30152e+02_r8,0.34423e+02_r8 /)
      kbo(:, 3,57,15) = (/ &
        & 0.40717e+02_r8,0.33158e+02_r8,0.31249e+02_r8,0.29283e+02_r8,0.34041e+02_r8 /)
      kbo(:, 4,57,15) = (/ &
        & 0.39952e+02_r8,0.32113e+02_r8,0.30080e+02_r8,0.28382e+02_r8,0.33523e+02_r8 /)
      kbo(:, 5,57,15) = (/ &
        & 0.39110e+02_r8,0.31075e+02_r8,0.28913e+02_r8,0.27492e+02_r8,0.32886e+02_r8 /)
      kbo(:, 1,58,15) = (/ &
        & 0.41872e+02_r8,0.35648e+02_r8,0.33990e+02_r8,0.31215e+02_r8,0.34668e+02_r8 /)
      kbo(:, 2,58,15) = (/ &
        & 0.41486e+02_r8,0.34551e+02_r8,0.32786e+02_r8,0.30408e+02_r8,0.34507e+02_r8 /)
      kbo(:, 3,58,15) = (/ &
        & 0.40923e+02_r8,0.33481e+02_r8,0.31606e+02_r8,0.29553e+02_r8,0.34175e+02_r8 /)
      kbo(:, 4,58,15) = (/ &
        & 0.40193e+02_r8,0.32431e+02_r8,0.30438e+02_r8,0.28657e+02_r8,0.33692e+02_r8 /)
      kbo(:, 5,58,15) = (/ &
        & 0.39381e+02_r8,0.31393e+02_r8,0.29263e+02_r8,0.27758e+02_r8,0.33088e+02_r8 /)
      kbo(:, 1,59,15) = (/ &
        & 0.41905e+02_r8,0.35780e+02_r8,0.34140e+02_r8,0.31306e+02_r8,0.34668e+02_r8 /)
      kbo(:, 2,59,15) = (/ &
        & 0.41541e+02_r8,0.34683e+02_r8,0.32931e+02_r8,0.30509e+02_r8,0.34539e+02_r8 /)
      kbo(:, 3,59,15) = (/ &
        & 0.41000e+02_r8,0.33610e+02_r8,0.31751e+02_r8,0.29658e+02_r8,0.34225e+02_r8 /)
      kbo(:, 4,59,15) = (/ &
        & 0.40289e+02_r8,0.32559e+02_r8,0.30582e+02_r8,0.28769e+02_r8,0.33760e+02_r8 /)
      kbo(:, 5,59,15) = (/ &
        & 0.39484e+02_r8,0.31518e+02_r8,0.29405e+02_r8,0.27867e+02_r8,0.33169e+02_r8 /)
      kbo(:, 1,13,16) = (/ &
        & 0.44218e+02_r8,0.33168e+02_r8,0.27605e+02_r8,0.40761e+02_r8,0.54348e+02_r8 /)
      kbo(:, 2,13,16) = (/ &
        & 0.43915e+02_r8,0.32941e+02_r8,0.26738e+02_r8,0.39342e+02_r8,0.52457e+02_r8 /)
      kbo(:, 3,13,16) = (/ &
        & 0.43491e+02_r8,0.32624e+02_r8,0.25861e+02_r8,0.38022e+02_r8,0.50696e+02_r8 /)
      kbo(:, 4,13,16) = (/ &
        & 0.42952e+02_r8,0.32220e+02_r8,0.25010e+02_r8,0.36713e+02_r8,0.48951e+02_r8 /)
      kbo(:, 5,13,16) = (/ &
        & 0.42305e+02_r8,0.31735e+02_r8,0.24184e+02_r8,0.35417e+02_r8,0.47222e+02_r8 /)
      kbo(:, 1,14,16) = (/ &
        & 0.50640e+02_r8,0.37984e+02_r8,0.31138e+02_r8,0.45571e+02_r8,0.60761e+02_r8 /)
      kbo(:, 2,14,16) = (/ &
        & 0.50072e+02_r8,0.37558e+02_r8,0.30053e+02_r8,0.43809e+02_r8,0.58413e+02_r8 /)
      kbo(:, 3,14,16) = (/ &
        & 0.49384e+02_r8,0.37043e+02_r8,0.28981e+02_r8,0.42162e+02_r8,0.56216e+02_r8 /)
      kbo(:, 4,14,16) = (/ &
        & 0.48531e+02_r8,0.36404e+02_r8,0.27924e+02_r8,0.40555e+02_r8,0.54074e+02_r8 /)
      kbo(:, 5,14,16) = (/ &
        & 0.47588e+02_r8,0.35696e+02_r8,0.26896e+02_r8,0.38961e+02_r8,0.51948e+02_r8 /)
      kbo(:, 1,15,16) = (/ &
        & 0.57280e+02_r8,0.42964e+02_r8,0.34740e+02_r8,0.50323e+02_r8,0.67098e+02_r8 /)
      kbo(:, 2,15,16) = (/ &
        & 0.56367e+02_r8,0.42280e+02_r8,0.33407e+02_r8,0.48191e+02_r8,0.64255e+02_r8 /)
      kbo(:, 3,15,16) = (/ &
        & 0.55318e+02_r8,0.41493e+02_r8,0.32092e+02_r8,0.46141e+02_r8,0.61520e+02_r8 /)
      kbo(:, 4,15,16) = (/ &
        & 0.54108e+02_r8,0.40586e+02_r8,0.30808e+02_r8,0.44198e+02_r8,0.58930e+02_r8 /)
      kbo(:, 5,15,16) = (/ &
        & 0.52826e+02_r8,0.39625e+02_r8,0.29570e+02_r8,0.42303e+02_r8,0.56404e+02_r8 /)
      kbo(:, 1,16,16) = (/ &
        & 0.63967e+02_r8,0.47979e+02_r8,0.38312e+02_r8,0.54909e+02_r8,0.73213e+02_r8 /)
      kbo(:, 2,16,16) = (/ &
        & 0.62626e+02_r8,0.46973e+02_r8,0.36695e+02_r8,0.52345e+02_r8,0.69794e+02_r8 /)
      kbo(:, 3,16,16) = (/ &
        & 0.61112e+02_r8,0.45838e+02_r8,0.35123e+02_r8,0.49904e+02_r8,0.66539e+02_r8 /)
      kbo(:, 4,16,16) = (/ &
        & 0.59503e+02_r8,0.44632e+02_r8,0.33592e+02_r8,0.47568e+02_r8,0.63425e+02_r8 /)
      kbo(:, 5,16,16) = (/ &
        & 0.57855e+02_r8,0.43396e+02_r8,0.32125e+02_r8,0.45372e+02_r8,0.60497e+02_r8 /)
      kbo(:, 1,17,16) = (/ &
        & 0.70540e+02_r8,0.52908e+02_r8,0.41791e+02_r8,0.59184e+02_r8,0.78912e+02_r8 /)
      kbo(:, 2,17,16) = (/ &
        & 0.68668e+02_r8,0.51504e+02_r8,0.39850e+02_r8,0.56189e+02_r8,0.74919e+02_r8 /)
      kbo(:, 3,17,16) = (/ &
        & 0.66662e+02_r8,0.50000e+02_r8,0.37983e+02_r8,0.53339e+02_r8,0.71119e+02_r8 /)
      kbo(:, 4,17,16) = (/ &
        & 0.64633e+02_r8,0.48479e+02_r8,0.36199e+02_r8,0.50655e+02_r8,0.67541e+02_r8 /)
      kbo(:, 5,17,16) = (/ &
        & 0.62569e+02_r8,0.46932e+02_r8,0.34500e+02_r8,0.48144e+02_r8,0.64192e+02_r8 /)
      kbo(:, 1,18,16) = (/ &
        & 0.76762e+02_r8,0.57574e+02_r8,0.45062e+02_r8,0.63079e+02_r8,0.84105e+02_r8 /)
      kbo(:, 2,18,16) = (/ &
        & 0.74320e+02_r8,0.55743e+02_r8,0.42789e+02_r8,0.59653e+02_r8,0.79537e+02_r8 /)
      kbo(:, 3,18,16) = (/ &
        & 0.71820e+02_r8,0.53869e+02_r8,0.40630e+02_r8,0.56414e+02_r8,0.75219e+02_r8 /)
      kbo(:, 4,18,16) = (/ &
        & 0.69367e+02_r8,0.52029e+02_r8,0.38584e+02_r8,0.53391e+02_r8,0.71188e+02_r8 /)
      kbo(:, 5,18,16) = (/ &
        & 0.66895e+02_r8,0.50176e+02_r8,0.36663e+02_r8,0.50596e+02_r8,0.67461e+02_r8 /)
      kbo(:, 1,19,16) = (/ &
        & 0.82534e+02_r8,0.61903e+02_r8,0.48066e+02_r8,0.66533e+02_r8,0.88711e+02_r8 /)
      kbo(:, 2,19,16) = (/ &
        & 0.79500e+02_r8,0.59627e+02_r8,0.45463e+02_r8,0.62698e+02_r8,0.83597e+02_r8 /)
      kbo(:, 3,19,16) = (/ &
        & 0.76531e+02_r8,0.57402e+02_r8,0.43003e+02_r8,0.59107e+02_r8,0.78810e+02_r8 /)
      kbo(:, 4,19,16) = (/ &
        & 0.73621e+02_r8,0.55219e+02_r8,0.40714e+02_r8,0.55776e+02_r8,0.74368e+02_r8 /)
      kbo(:, 5,19,16) = (/ &
        & 0.70758e+02_r8,0.53072e+02_r8,0.38580e+02_r8,0.52720e+02_r8,0.70294e+02_r8 /)
      kbo(:, 1,20,16) = (/ &
        & 0.87685e+02_r8,0.65766e+02_r8,0.50694e+02_r8,0.69445e+02_r8,0.92594e+02_r8 /)
      kbo(:, 2,20,16) = (/ &
        & 0.84090e+02_r8,0.63070e+02_r8,0.47778e+02_r8,0.65259e+02_r8,0.87012e+02_r8 /)
      kbo(:, 3,20,16) = (/ &
        & 0.80661e+02_r8,0.60499e+02_r8,0.45053e+02_r8,0.61350e+02_r8,0.81800e+02_r8 /)
      kbo(:, 4,20,16) = (/ &
        & 0.77340e+02_r8,0.58008e+02_r8,0.42537e+02_r8,0.57756e+02_r8,0.77009e+02_r8 /)
      kbo(:, 5,20,16) = (/ &
        & 0.74079e+02_r8,0.55564e+02_r8,0.40201e+02_r8,0.54475e+02_r8,0.72633e+02_r8 /)
      kbo(:, 1,21,16) = (/ &
        & 0.92165e+02_r8,0.69126e+02_r8,0.52960e+02_r8,0.71872e+02_r8,0.95829e+02_r8 /)
      kbo(:, 2,21,16) = (/ &
        & 0.88084e+02_r8,0.66065e+02_r8,0.49750e+02_r8,0.67363e+02_r8,0.89818e+02_r8 /)
      kbo(:, 3,21,16) = (/ &
        & 0.84210e+02_r8,0.63159e+02_r8,0.46796e+02_r8,0.63194e+02_r8,0.84259e+02_r8 /)
      kbo(:, 4,21,16) = (/ &
        & 0.80508e+02_r8,0.60384e+02_r8,0.44071e+02_r8,0.59388e+02_r8,0.79185e+02_r8 /)
      kbo(:, 5,21,16) = (/ &
        & 0.76889e+02_r8,0.57670e+02_r8,0.41555e+02_r8,0.55904e+02_r8,0.74538e+02_r8 /)
      kbo(:, 1,22,16) = (/ &
        & 0.95696e+02_r8,0.71774e+02_r8,0.54631e+02_r8,0.73526e+02_r8,0.98034e+02_r8 /)
      kbo(:, 2,22,16) = (/ &
        & 0.91190e+02_r8,0.68395e+02_r8,0.51188e+02_r8,0.68768e+02_r8,0.91690e+02_r8 /)
      kbo(:, 3,22,16) = (/ &
        & 0.86939e+02_r8,0.65206e+02_r8,0.48040e+02_r8,0.64409e+02_r8,0.85879e+02_r8 /)
      kbo(:, 4,22,16) = (/ &
        & 0.82890e+02_r8,0.62171e+02_r8,0.45151e+02_r8,0.60441e+02_r8,0.80589e+02_r8 /)
      kbo(:, 5,22,16) = (/ &
        & 0.78983e+02_r8,0.59241e+02_r8,0.42494e+02_r8,0.56811e+02_r8,0.75748e+02_r8 /)
      kbo(:, 1,23,16) = (/ &
        & 0.98505e+02_r8,0.73881e+02_r8,0.55897e+02_r8,0.74690e+02_r8,0.99587e+02_r8 /)
      kbo(:, 2,23,16) = (/ &
        & 0.93651e+02_r8,0.70240e+02_r8,0.52277e+02_r8,0.69755e+02_r8,0.93007e+02_r8 /)
      kbo(:, 3,23,16) = (/ &
        & 0.89065e+02_r8,0.66801e+02_r8,0.48963e+02_r8,0.65256e+02_r8,0.87008e+02_r8 /)
      kbo(:, 4,23,16) = (/ &
        & 0.84725e+02_r8,0.63546e+02_r8,0.45949e+02_r8,0.61155e+02_r8,0.81540e+02_r8 /)
      kbo(:, 5,23,16) = (/ &
        & 0.80582e+02_r8,0.60440e+02_r8,0.43182e+02_r8,0.57417e+02_r8,0.76556e+02_r8 /)
      kbo(:, 1,24,16) = (/ &
        & 0.10064e+03_r8,0.75484e+02_r8,0.56783e+02_r8,0.75422e+02_r8,0.10056e+03_r8 /)
      kbo(:, 2,24,16) = (/ &
        & 0.95486e+02_r8,0.71616e+02_r8,0.53021e+02_r8,0.70355e+02_r8,0.93807e+02_r8 /)
      kbo(:, 3,24,16) = (/ &
        & 0.90630e+02_r8,0.67975e+02_r8,0.49592e+02_r8,0.65751e+02_r8,0.87668e+02_r8 /)
      kbo(:, 4,24,16) = (/ &
        & 0.86059e+02_r8,0.64548e+02_r8,0.46483e+02_r8,0.61565e+02_r8,0.82086e+02_r8 /)
      kbo(:, 5,24,16) = (/ &
        & 0.81718e+02_r8,0.61292e+02_r8,0.43631e+02_r8,0.57753e+02_r8,0.77003e+02_r8 /)
      kbo(:, 1,25,16) = (/ &
        & 0.10215e+03_r8,0.76618e+02_r8,0.57324e+02_r8,0.75759e+02_r8,0.10101e+03_r8 /)
      kbo(:, 2,25,16) = (/ &
        & 0.96743e+02_r8,0.72560e+02_r8,0.53446e+02_r8,0.70607e+02_r8,0.94143e+02_r8 /)
      kbo(:, 3,25,16) = (/ &
        & 0.91681e+02_r8,0.68763e+02_r8,0.49955e+02_r8,0.65940e+02_r8,0.87921e+02_r8 /)
      kbo(:, 4,25,16) = (/ &
        & 0.86919e+02_r8,0.65192e+02_r8,0.46773e+02_r8,0.61703e+02_r8,0.82270e+02_r8 /)
      kbo(:, 5,25,16) = (/ &
        & 0.82440e+02_r8,0.61834e+02_r8,0.43873e+02_r8,0.57842e+02_r8,0.77123e+02_r8 /)
      kbo(:, 1,26,16) = (/ &
        & 0.10303e+03_r8,0.77274e+02_r8,0.57519e+02_r8,0.75701e+02_r8,0.10093e+03_r8 /)
      kbo(:, 2,26,16) = (/ &
        & 0.97444e+02_r8,0.73085e+02_r8,0.53575e+02_r8,0.70525e+02_r8,0.94033e+02_r8 /)
      kbo(:, 3,26,16) = (/ &
        & 0.92222e+02_r8,0.69170e+02_r8,0.50048e+02_r8,0.65828e+02_r8,0.87771e+02_r8 /)
      kbo(:, 4,26,16) = (/ &
        & 0.87336e+02_r8,0.65505e+02_r8,0.46824e+02_r8,0.61566e+02_r8,0.82088e+02_r8 /)
      kbo(:, 5,26,16) = (/ &
        & 0.82771e+02_r8,0.62082e+02_r8,0.43909e+02_r8,0.57710e+02_r8,0.76947e+02_r8 /)
      kbo(:, 1,27,16) = (/ &
        & 0.10345e+03_r8,0.77590e+02_r8,0.57467e+02_r8,0.75392e+02_r8,0.10052e+03_r8 /)
      kbo(:, 2,27,16) = (/ &
        & 0.97739e+02_r8,0.73306e+02_r8,0.53511e+02_r8,0.70214e+02_r8,0.93619e+02_r8 /)
      kbo(:, 3,27,16) = (/ &
        & 0.92406e+02_r8,0.69307e+02_r8,0.49956e+02_r8,0.65525e+02_r8,0.87366e+02_r8 /)
      kbo(:, 4,27,16) = (/ &
        & 0.87439e+02_r8,0.65583e+02_r8,0.46715e+02_r8,0.61255e+02_r8,0.81674e+02_r8 /)
      kbo(:, 5,27,16) = (/ &
        & 0.82826e+02_r8,0.62123e+02_r8,0.43807e+02_r8,0.57432e+02_r8,0.76576e+02_r8 /)
      kbo(:, 1,28,16) = (/ &
        & 0.10350e+03_r8,0.77625e+02_r8,0.57222e+02_r8,0.74881e+02_r8,0.99841e+02_r8 /)
      kbo(:, 2,28,16) = (/ &
        & 0.97691e+02_r8,0.73271e+02_r8,0.53275e+02_r8,0.69730e+02_r8,0.92974e+02_r8 /)
      kbo(:, 3,28,16) = (/ &
        & 0.92289e+02_r8,0.69219e+02_r8,0.49719e+02_r8,0.65057e+02_r8,0.86743e+02_r8 /)
      kbo(:, 4,28,16) = (/ &
        & 0.87284e+02_r8,0.65466e+02_r8,0.46485e+02_r8,0.60817e+02_r8,0.81090e+02_r8 /)
      kbo(:, 5,28,16) = (/ &
        & 0.82640e+02_r8,0.61984e+02_r8,0.43588e+02_r8,0.57042e+02_r8,0.76055e+02_r8 /)
      kbo(:, 1,29,16) = (/ &
        & 0.10319e+03_r8,0.77394e+02_r8,0.56799e+02_r8,0.74179e+02_r8,0.98906e+02_r8 /)
      kbo(:, 2,29,16) = (/ &
        & 0.97340e+02_r8,0.73008e+02_r8,0.52885e+02_r8,0.69064e+02_r8,0.92086e+02_r8 /)
      kbo(:, 3,29,16) = (/ &
        & 0.91909e+02_r8,0.68935e+02_r8,0.49342e+02_r8,0.64439e+02_r8,0.85918e+02_r8 /)
      kbo(:, 4,29,16) = (/ &
        & 0.86890e+02_r8,0.65171e+02_r8,0.46144e+02_r8,0.60253e+02_r8,0.80337e+02_r8 /)
      kbo(:, 5,29,16) = (/ &
        & 0.82249e+02_r8,0.61690e+02_r8,0.43266e+02_r8,0.56539e+02_r8,0.75385e+02_r8 /)
      kbo(:, 1,30,16) = (/ &
        & 0.10264e+03_r8,0.76981e+02_r8,0.56267e+02_r8,0.73352e+02_r8,0.97803e+02_r8 /)
      kbo(:, 2,30,16) = (/ &
        & 0.96761e+02_r8,0.72573e+02_r8,0.52390e+02_r8,0.68302e+02_r8,0.91070e+02_r8 /)
      kbo(:, 3,30,16) = (/ &
        & 0.91349e+02_r8,0.68515e+02_r8,0.48877e+02_r8,0.63734e+02_r8,0.84978e+02_r8 /)
      kbo(:, 4,30,16) = (/ &
        & 0.86346e+02_r8,0.64763e+02_r8,0.45722e+02_r8,0.59615e+02_r8,0.79487e+02_r8 /)
      kbo(:, 5,30,16) = (/ &
        & 0.81701e+02_r8,0.61280e+02_r8,0.42874e+02_r8,0.55973e+02_r8,0.74631e+02_r8 /)
      kbo(:, 1,31,16) = (/ &
        & 0.10185e+03_r8,0.76389e+02_r8,0.55624e+02_r8,0.72410e+02_r8,0.96547e+02_r8 /)
      kbo(:, 2,31,16) = (/ &
        & 0.95999e+02_r8,0.72002e+02_r8,0.51796e+02_r8,0.67443e+02_r8,0.89924e+02_r8 /)
      kbo(:, 3,31,16) = (/ &
        & 0.90614e+02_r8,0.67963e+02_r8,0.48327e+02_r8,0.62938e+02_r8,0.83917e+02_r8 /)
      kbo(:, 4,31,16) = (/ &
        & 0.85645e+02_r8,0.64237e+02_r8,0.45228e+02_r8,0.58906e+02_r8,0.78542e+02_r8 /)
      kbo(:, 5,31,16) = (/ &
        & 0.81007e+02_r8,0.60759e+02_r8,0.42414e+02_r8,0.55328e+02_r8,0.73771e+02_r8 /)
      kbo(:, 1,32,16) = (/ &
        & 0.10089e+03_r8,0.75672e+02_r8,0.54904e+02_r8,0.71387e+02_r8,0.95183e+02_r8 /)
      kbo(:, 2,32,16) = (/ &
        & 0.95077e+02_r8,0.71310e+02_r8,0.51129e+02_r8,0.66501e+02_r8,0.88668e+02_r8 /)
      kbo(:, 3,32,16) = (/ &
        & 0.89743e+02_r8,0.67310e+02_r8,0.47720e+02_r8,0.62089e+02_r8,0.82785e+02_r8 /)
      kbo(:, 4,32,16) = (/ &
        & 0.84830e+02_r8,0.63626e+02_r8,0.44676e+02_r8,0.58147e+02_r8,0.77529e+02_r8 /)
      kbo(:, 5,32,16) = (/ &
        & 0.80208e+02_r8,0.60160e+02_r8,0.41909e+02_r8,0.54638e+02_r8,0.72851e+02_r8 /)
      kbo(:, 1,33,16) = (/ &
        & 0.99806e+02_r8,0.74857e+02_r8,0.54124e+02_r8,0.70307e+02_r8,0.93742e+02_r8 /)
      kbo(:, 2,33,16) = (/ &
        & 0.94060e+02_r8,0.70548e+02_r8,0.50418e+02_r8,0.65525e+02_r8,0.87366e+02_r8 /)
      kbo(:, 3,33,16) = (/ &
        & 0.88780e+02_r8,0.66588e+02_r8,0.47080e+02_r8,0.61195e+02_r8,0.81594e+02_r8 /)
      kbo(:, 4,33,16) = (/ &
        & 0.83926e+02_r8,0.62948e+02_r8,0.44091e+02_r8,0.57369e+02_r8,0.76493e+02_r8 /)
      kbo(:, 5,33,16) = (/ &
        & 0.79342e+02_r8,0.59511e+02_r8,0.41372e+02_r8,0.53910e+02_r8,0.71880e+02_r8 /)
      kbo(:, 1,34,16) = (/ &
        & 0.98842e+02_r8,0.74134e+02_r8,0.53446e+02_r8,0.69373e+02_r8,0.92498e+02_r8 /)
      kbo(:, 2,34,16) = (/ &
        & 0.93169e+02_r8,0.69879e+02_r8,0.49796e+02_r8,0.64672e+02_r8,0.86229e+02_r8 /)
      kbo(:, 3,34,16) = (/ &
        & 0.87940e+02_r8,0.65958e+02_r8,0.46525e+02_r8,0.60437e+02_r8,0.80583e+02_r8 /)
      kbo(:, 4,34,16) = (/ &
        & 0.83124e+02_r8,0.62347e+02_r8,0.43581e+02_r8,0.56689e+02_r8,0.75585e+02_r8 /)
      kbo(:, 5,34,16) = (/ &
        & 0.78566e+02_r8,0.58929e+02_r8,0.40900e+02_r8,0.53287e+02_r8,0.71049e+02_r8 /)
      kbo(:, 1,35,16) = (/ &
        & 0.98383e+02_r8,0.73790e+02_r8,0.53104e+02_r8,0.68893e+02_r8,0.91857e+02_r8 /)
      kbo(:, 2,35,16) = (/ &
        & 0.92731e+02_r8,0.69551e+02_r8,0.49484e+02_r8,0.64233e+02_r8,0.85643e+02_r8 /)
      kbo(:, 3,35,16) = (/ &
        & 0.87537e+02_r8,0.65656e+02_r8,0.46247e+02_r8,0.60050e+02_r8,0.80067e+02_r8 /)
      kbo(:, 4,35,16) = (/ &
        & 0.82730e+02_r8,0.62051e+02_r8,0.43325e+02_r8,0.56336e+02_r8,0.75115e+02_r8 /)
      kbo(:, 5,35,16) = (/ &
        & 0.78184e+02_r8,0.58642e+02_r8,0.40664e+02_r8,0.52959e+02_r8,0.70611e+02_r8 /)
      kbo(:, 1,36,16) = (/ &
        & 0.98510e+02_r8,0.73885e+02_r8,0.53153e+02_r8,0.68921e+02_r8,0.91895e+02_r8 /)
      kbo(:, 2,36,16) = (/ &
        & 0.92845e+02_r8,0.69637e+02_r8,0.49525e+02_r8,0.64248e+02_r8,0.85664e+02_r8 /)
      kbo(:, 3,36,16) = (/ &
        & 0.87626e+02_r8,0.65723e+02_r8,0.46281e+02_r8,0.60067e+02_r8,0.80090e+02_r8 /)
      kbo(:, 4,36,16) = (/ &
        & 0.82805e+02_r8,0.62108e+02_r8,0.43352e+02_r8,0.56351e+02_r8,0.75135e+02_r8 /)
      kbo(:, 5,36,16) = (/ &
        & 0.78246e+02_r8,0.58689e+02_r8,0.40687e+02_r8,0.52970e+02_r8,0.70627e+02_r8 /)
      kbo(:, 1,37,16) = (/ &
        & 0.99499e+02_r8,0.74626e+02_r8,0.53765e+02_r8,0.69681e+02_r8,0.92907e+02_r8 /)
      kbo(:, 2,37,16) = (/ &
        & 0.93737e+02_r8,0.70305e+02_r8,0.50072e+02_r8,0.64938e+02_r8,0.86584e+02_r8 /)
      kbo(:, 3,37,16) = (/ &
        & 0.88443e+02_r8,0.66336e+02_r8,0.46765e+02_r8,0.60669e+02_r8,0.80892e+02_r8 /)
      kbo(:, 4,37,16) = (/ &
        & 0.83569e+02_r8,0.62680e+02_r8,0.43792e+02_r8,0.56887e+02_r8,0.75849e+02_r8 /)
      kbo(:, 5,37,16) = (/ &
        & 0.78959e+02_r8,0.59223e+02_r8,0.41087e+02_r8,0.53464e+02_r8,0.71286e+02_r8 /)
      kbo(:, 1,38,16) = (/ &
        & 0.10053e+03_r8,0.75401e+02_r8,0.54401e+02_r8,0.70469e+02_r8,0.93958e+02_r8 /)
      kbo(:, 2,38,16) = (/ &
        & 0.94665e+02_r8,0.71001e+02_r8,0.50643e+02_r8,0.65651e+02_r8,0.87535e+02_r8 /)
      kbo(:, 3,38,16) = (/ &
        & 0.89287e+02_r8,0.66968e+02_r8,0.47272e+02_r8,0.61298e+02_r8,0.81730e+02_r8 /)
      kbo(:, 4,38,16) = (/ &
        & 0.84354e+02_r8,0.63269e+02_r8,0.44250e+02_r8,0.57455e+02_r8,0.76607e+02_r8 /)
      kbo(:, 5,38,16) = (/ &
        & 0.79688e+02_r8,0.59770e+02_r8,0.41502e+02_r8,0.53978e+02_r8,0.71970e+02_r8 /)
      kbo(:, 1,39,16) = (/ &
        & 0.10152e+03_r8,0.76145e+02_r8,0.55030e+02_r8,0.71266e+02_r8,0.95022e+02_r8 /)
      kbo(:, 2,39,16) = (/ &
        & 0.95574e+02_r8,0.71683e+02_r8,0.51208e+02_r8,0.66359e+02_r8,0.88479e+02_r8 /)
      kbo(:, 3,39,16) = (/ &
        & 0.90127e+02_r8,0.67598e+02_r8,0.47776e+02_r8,0.61934e+02_r8,0.82579e+02_r8 /)
      kbo(:, 4,39,16) = (/ &
        & 0.85122e+02_r8,0.63845e+02_r8,0.44704e+02_r8,0.58015e+02_r8,0.77353e+02_r8 /)
      kbo(:, 5,39,16) = (/ &
        & 0.80410e+02_r8,0.60311e+02_r8,0.41916e+02_r8,0.54486e+02_r8,0.72649e+02_r8 /)
      kbo(:, 1,40,16) = (/ &
        & 0.10316e+03_r8,0.77371e+02_r8,0.56077e+02_r8,0.72600e+02_r8,0.96800e+02_r8 /)
      kbo(:, 2,40,16) = (/ &
        & 0.97060e+02_r8,0.72797e+02_r8,0.52149e+02_r8,0.67558e+02_r8,0.90077e+02_r8 /)
      kbo(:, 3,40,16) = (/ &
        & 0.91509e+02_r8,0.68635e+02_r8,0.48618e+02_r8,0.63010e+02_r8,0.84013e+02_r8 /)
      kbo(:, 4,40,16) = (/ &
        & 0.86384e+02_r8,0.64791e+02_r8,0.45460e+02_r8,0.58959e+02_r8,0.78612e+02_r8 /)
      kbo(:, 5,40,16) = (/ &
        & 0.81600e+02_r8,0.61204e+02_r8,0.42605e+02_r8,0.55349e+02_r8,0.73798e+02_r8 /)
      kbo(:, 1,41,16) = (/ &
        & 0.10490e+03_r8,0.78677e+02_r8,0.57202e+02_r8,0.74030e+02_r8,0.98707e+02_r8 /)
      kbo(:, 2,41,16) = (/ &
        & 0.98655e+02_r8,0.73994e+02_r8,0.53155e+02_r8,0.68836e+02_r8,0.91782e+02_r8 /)
      kbo(:, 3,41,16) = (/ &
        & 0.92964e+02_r8,0.69726e+02_r8,0.49517e+02_r8,0.64156e+02_r8,0.85541e+02_r8 /)
      kbo(:, 4,41,16) = (/ &
        & 0.87720e+02_r8,0.65793e+02_r8,0.46275e+02_r8,0.59984e+02_r8,0.79978e+02_r8 /)
      kbo(:, 5,41,16) = (/ &
        & 0.82858e+02_r8,0.62147e+02_r8,0.43340e+02_r8,0.56275e+02_r8,0.75033e+02_r8 /)
      kbo(:, 1,42,16) = (/ &
        & 0.10666e+03_r8,0.79997e+02_r8,0.58340e+02_r8,0.75485e+02_r8,0.10065e+03_r8 /)
      kbo(:, 2,42,16) = (/ &
        & 0.10028e+03_r8,0.75211e+02_r8,0.54189e+02_r8,0.70153e+02_r8,0.93537e+02_r8 /)
      kbo(:, 3,42,16) = (/ &
        & 0.94432e+02_r8,0.70827e+02_r8,0.50443e+02_r8,0.65340e+02_r8,0.87121e+02_r8 /)
      kbo(:, 4,42,16) = (/ &
        & 0.89075e+02_r8,0.66809e+02_r8,0.47102e+02_r8,0.61032e+02_r8,0.81376e+02_r8 /)
      kbo(:, 5,42,16) = (/ &
        & 0.84125e+02_r8,0.63097e+02_r8,0.44086e+02_r8,0.57211e+02_r8,0.76281e+02_r8 /)
      kbo(:, 1,43,16) = (/ &
        & 0.10883e+03_r8,0.81624e+02_r8,0.59771e+02_r8,0.77309e+02_r8,0.10308e+03_r8 /)
      kbo(:, 2,43,16) = (/ &
        & 0.10228e+03_r8,0.76711e+02_r8,0.55476e+02_r8,0.71797e+02_r8,0.95729e+02_r8 /)
      kbo(:, 3,43,16) = (/ &
        & 0.96257e+02_r8,0.72196e+02_r8,0.51599e+02_r8,0.66824e+02_r8,0.89098e+02_r8 /)
      kbo(:, 4,43,16) = (/ &
        & 0.90745e+02_r8,0.68062e+02_r8,0.48126e+02_r8,0.62350e+02_r8,0.83134e+02_r8 /)
      kbo(:, 5,43,16) = (/ &
        & 0.85682e+02_r8,0.64265e+02_r8,0.45017e+02_r8,0.58380e+02_r8,0.77840e+02_r8 /)
      kbo(:, 1,44,16) = (/ &
        & 0.11122e+03_r8,0.83416e+02_r8,0.61378e+02_r8,0.79350e+02_r8,0.10580e+03_r8 /)
      kbo(:, 2,44,16) = (/ &
        & 0.10448e+03_r8,0.78362e+02_r8,0.56905e+02_r8,0.73629e+02_r8,0.98171e+02_r8 /)
      kbo(:, 3,44,16) = (/ &
        & 0.98280e+02_r8,0.73712e+02_r8,0.52886e+02_r8,0.68474e+02_r8,0.91299e+02_r8 /)
      kbo(:, 4,44,16) = (/ &
        & 0.92614e+02_r8,0.69464e+02_r8,0.49277e+02_r8,0.63819e+02_r8,0.85092e+02_r8 /)
      kbo(:, 5,44,16) = (/ &
        & 0.87390e+02_r8,0.65546e+02_r8,0.46054e+02_r8,0.59688e+02_r8,0.79585e+02_r8 /)
      kbo(:, 1,45,16) = (/ &
        & 0.11367e+03_r8,0.85251e+02_r8,0.63043e+02_r8,0.81458e+02_r8,0.10861e+03_r8 /)
      kbo(:, 2,45,16) = (/ &
        & 0.10674e+03_r8,0.80056e+02_r8,0.58377e+02_r8,0.75516e+02_r8,0.10069e+03_r8 /)
      kbo(:, 3,45,16) = (/ &
        & 0.10036e+03_r8,0.75271e+02_r8,0.54217e+02_r8,0.70172e+02_r8,0.93562e+02_r8 /)
      kbo(:, 4,45,16) = (/ &
        & 0.94507e+02_r8,0.70883e+02_r8,0.50472e+02_r8,0.65352e+02_r8,0.87137e+02_r8 /)
      kbo(:, 5,45,16) = (/ &
        & 0.89124e+02_r8,0.66846e+02_r8,0.47119e+02_r8,0.61044e+02_r8,0.81393e+02_r8 /)
      kbo(:, 1,46,16) = (/ &
        & 0.11634e+03_r8,0.87256e+02_r8,0.64886e+02_r8,0.83772e+02_r8,0.11170e+03_r8 /)
      kbo(:, 2,46,16) = (/ &
        & 0.10921e+03_r8,0.81909e+02_r8,0.60009e+02_r8,0.77600e+02_r8,0.10347e+03_r8 /)
      kbo(:, 3,46,16) = (/ &
        & 0.10262e+03_r8,0.76969e+02_r8,0.55682e+02_r8,0.72046e+02_r8,0.96062e+02_r8 /)
      kbo(:, 4,46,16) = (/ &
        & 0.96578e+02_r8,0.72436e+02_r8,0.51790e+02_r8,0.67050e+02_r8,0.89399e+02_r8 /)
      kbo(:, 5,46,16) = (/ &
        & 0.91036e+02_r8,0.68280e+02_r8,0.48293e+02_r8,0.62556e+02_r8,0.83408e+02_r8 /)
      kbo(:, 1,47,16) = (/ &
        & 0.11944e+03_r8,0.89580e+02_r8,0.67039e+02_r8,0.86470e+02_r8,0.11529e+03_r8 /)
      kbo(:, 2,47,16) = (/ &
        & 0.11203e+03_r8,0.84025e+02_r8,0.61916e+02_r8,0.80032e+02_r8,0.10671e+03_r8 /)
      kbo(:, 3,47,16) = (/ &
        & 0.10523e+03_r8,0.78928e+02_r8,0.57378e+02_r8,0.74229e+02_r8,0.98972e+02_r8 /)
      kbo(:, 4,47,16) = (/ &
        & 0.98975e+02_r8,0.74234e+02_r8,0.53317e+02_r8,0.69003e+02_r8,0.92005e+02_r8 /)
      kbo(:, 5,47,16) = (/ &
        & 0.93247e+02_r8,0.69938e+02_r8,0.49666e+02_r8,0.64309e+02_r8,0.85745e+02_r8 /)
      kbo(:, 1,48,16) = (/ &
        & 0.12267e+03_r8,0.92006e+02_r8,0.69290e+02_r8,0.89280e+02_r8,0.11904e+03_r8 /)
      kbo(:, 2,48,16) = (/ &
        & 0.11495e+03_r8,0.86215e+02_r8,0.63917e+02_r8,0.82556e+02_r8,0.11008e+03_r8 /)
      kbo(:, 3,48,16) = (/ &
        & 0.10793e+03_r8,0.80951e+02_r8,0.59146e+02_r8,0.76493e+02_r8,0.10199e+03_r8 /)
      kbo(:, 4,48,16) = (/ &
        & 0.10147e+03_r8,0.76101e+02_r8,0.54918e+02_r8,0.71050e+02_r8,0.94733e+02_r8 /)
      kbo(:, 5,48,16) = (/ &
        & 0.95498e+02_r8,0.71626e+02_r8,0.51095e+02_r8,0.66155e+02_r8,0.88207e+02_r8 /)
      kbo(:, 1,49,16) = (/ &
        & 0.12603e+03_r8,0.94521e+02_r8,0.71680e+02_r8,0.92236e+02_r8,0.12298e+03_r8 /)
      kbo(:, 2,49,16) = (/ &
        & 0.11801e+03_r8,0.88509e+02_r8,0.66027e+02_r8,0.85192e+02_r8,0.11359e+03_r8 /)
      kbo(:, 3,49,16) = (/ &
        & 0.11070e+03_r8,0.83029e+02_r8,0.61003e+02_r8,0.78868e+02_r8,0.10516e+03_r8 /)
      kbo(:, 4,49,16) = (/ &
        & 0.10402e+03_r8,0.78016e+02_r8,0.56578e+02_r8,0.73185e+02_r8,0.97580e+02_r8 /)
      kbo(:, 5,49,16) = (/ &
        & 0.97847e+02_r8,0.73387e+02_r8,0.52593e+02_r8,0.68075e+02_r8,0.90767e+02_r8 /)
      kbo(:, 1,50,16) = (/ &
        & 0.12933e+03_r8,0.96996e+02_r8,0.74078e+02_r8,0.95132e+02_r8,0.12684e+03_r8 /)
      kbo(:, 2,50,16) = (/ &
        & 0.12097e+03_r8,0.90726e+02_r8,0.68085e+02_r8,0.87768e+02_r8,0.11702e+03_r8 /)
      kbo(:, 3,50,16) = (/ &
        & 0.11343e+03_r8,0.85073e+02_r8,0.62849e+02_r8,0.81185e+02_r8,0.10825e+03_r8 /)
      kbo(:, 4,50,16) = (/ &
        & 0.10650e+03_r8,0.79879e+02_r8,0.58193e+02_r8,0.75257e+02_r8,0.10034e+03_r8 /)
      kbo(:, 5,50,16) = (/ &
        & 0.10012e+03_r8,0.75094e+02_r8,0.54050e+02_r8,0.69940e+02_r8,0.93253e+02_r8 /)
      kbo(:, 1,51,16) = (/ &
        & 0.13262e+03_r8,0.99463e+02_r8,0.76537e+02_r8,0.98089e+02_r8,0.13079e+03_r8 /)
      kbo(:, 2,51,16) = (/ &
        & 0.12396e+03_r8,0.92972e+02_r8,0.70180e+02_r8,0.90371e+02_r8,0.12049e+03_r8 /)
      kbo(:, 3,51,16) = (/ &
        & 0.11611e+03_r8,0.87085e+02_r8,0.64700e+02_r8,0.83525e+02_r8,0.11137e+03_r8 /)
      kbo(:, 4,51,16) = (/ &
        & 0.10897e+03_r8,0.81728e+02_r8,0.59829e+02_r8,0.77356e+02_r8,0.10314e+03_r8 /)
      kbo(:, 5,51,16) = (/ &
        & 0.10241e+03_r8,0.76807e+02_r8,0.55526e+02_r8,0.71828e+02_r8,0.95771e+02_r8 /)
      kbo(:, 1,52,16) = (/ &
        & 0.13607e+03_r8,0.10205e+03_r8,0.79117e+02_r8,0.10117e+03_r8,0.13489e+03_r8 /)
      kbo(:, 2,52,16) = (/ &
        & 0.12703e+03_r8,0.95276e+02_r8,0.72382e+02_r8,0.93082e+02_r8,0.12411e+03_r8 /)
      kbo(:, 3,52,16) = (/ &
        & 0.11888e+03_r8,0.89162e+02_r8,0.66631e+02_r8,0.85943e+02_r8,0.11459e+03_r8 /)
      kbo(:, 4,52,16) = (/ &
        & 0.11155e+03_r8,0.83666e+02_r8,0.61557e+02_r8,0.79542e+02_r8,0.10606e+03_r8 /)
      kbo(:, 5,52,16) = (/ &
        & 0.10475e+03_r8,0.78563e+02_r8,0.57053e+02_r8,0.73794e+02_r8,0.98392e+02_r8 /)
      kbo(:, 1,53,16) = (/ &
        & 0.13969e+03_r8,0.10477e+03_r8,0.81852e+02_r8,0.10445e+03_r8,0.13926e+03_r8 /)
      kbo(:, 2,53,16) = (/ &
        & 0.13021e+03_r8,0.97660e+02_r8,0.74731e+02_r8,0.95923e+02_r8,0.12790e+03_r8 /)
      kbo(:, 3,53,16) = (/ &
        & 0.12178e+03_r8,0.91333e+02_r8,0.68644e+02_r8,0.88461e+02_r8,0.11795e+03_r8 /)
      kbo(:, 4,53,16) = (/ &
        & 0.11417e+03_r8,0.85628e+02_r8,0.63346e+02_r8,0.81812e+02_r8,0.10908e+03_r8 /)
      kbo(:, 5,53,16) = (/ &
        & 0.10716e+03_r8,0.80376e+02_r8,0.58630e+02_r8,0.75816e+02_r8,0.10109e+03_r8 /)
      kbo(:, 1,54,16) = (/ &
        & 0.14312e+03_r8,0.10734e+03_r8,0.84505e+02_r8,0.10757e+03_r8,0.14343e+03_r8 /)
      kbo(:, 2,54,16) = (/ &
        & 0.13326e+03_r8,0.99943e+02_r8,0.77008e+02_r8,0.98653e+02_r8,0.13154e+03_r8 /)
      kbo(:, 3,54,16) = (/ &
        & 0.12453e+03_r8,0.93400e+02_r8,0.70583e+02_r8,0.90867e+02_r8,0.12116e+03_r8 /)
      kbo(:, 4,54,16) = (/ &
        & 0.11663e+03_r8,0.87472e+02_r8,0.65055e+02_r8,0.83971e+02_r8,0.11196e+03_r8 /)
      kbo(:, 5,54,16) = (/ &
        & 0.10944e+03_r8,0.82085e+02_r8,0.60143e+02_r8,0.77761e+02_r8,0.10368e+03_r8 /)
      kbo(:, 1,55,16) = (/ &
        & 0.14652e+03_r8,0.10989e+03_r8,0.87185e+02_r8,0.11072e+03_r8,0.14762e+03_r8 /)
      kbo(:, 2,55,16) = (/ &
        & 0.13631e+03_r8,0.10223e+03_r8,0.79292e+02_r8,0.10139e+03_r8,0.13518e+03_r8 /)
      kbo(:, 3,55,16) = (/ &
        & 0.12725e+03_r8,0.95436e+02_r8,0.72534e+02_r8,0.93260e+02_r8,0.12435e+03_r8 /)
      kbo(:, 4,55,16) = (/ &
        & 0.11908e+03_r8,0.89315e+02_r8,0.66761e+02_r8,0.86100e+02_r8,0.11480e+03_r8 /)
      kbo(:, 5,55,16) = (/ &
        & 0.11172e+03_r8,0.83789e+02_r8,0.61666e+02_r8,0.79683e+02_r8,0.10624e+03_r8 /)
      kbo(:, 1,56,16) = (/ &
        & 0.15005e+03_r8,0.11254e+03_r8,0.89964e+02_r8,0.11399e+03_r8,0.15199e+03_r8 /)
      kbo(:, 2,56,16) = (/ &
        & 0.13946e+03_r8,0.10459e+03_r8,0.81673e+02_r8,0.10424e+03_r8,0.13899e+03_r8 /)
      kbo(:, 3,56,16) = (/ &
        & 0.13002e+03_r8,0.97512e+02_r8,0.74583e+02_r8,0.95730e+02_r8,0.12764e+03_r8 /)
      kbo(:, 4,56,16) = (/ &
        & 0.12160e+03_r8,0.91205e+02_r8,0.68519e+02_r8,0.88312e+02_r8,0.11775e+03_r8 /)
      kbo(:, 5,56,16) = (/ &
        & 0.11401e+03_r8,0.85509e+02_r8,0.63233e+02_r8,0.81665e+02_r8,0.10889e+03_r8 /)
      kbo(:, 1,57,16) = (/ &
        & 0.15367e+03_r8,0.11525e+03_r8,0.92893e+02_r8,0.11745e+03_r8,0.15659e+03_r8 /)
      kbo(:, 2,57,16) = (/ &
        & 0.14273e+03_r8,0.10705e+03_r8,0.84201e+02_r8,0.10722e+03_r8,0.14296e+03_r8 /)
      kbo(:, 3,57,16) = (/ &
        & 0.13291e+03_r8,0.99681e+02_r8,0.76750e+02_r8,0.98336e+02_r8,0.13111e+03_r8 /)
      kbo(:, 4,57,16) = (/ &
        & 0.12423e+03_r8,0.93171e+02_r8,0.70357e+02_r8,0.90589e+02_r8,0.12079e+03_r8 /)
      kbo(:, 5,57,16) = (/ &
        & 0.11636e+03_r8,0.87269e+02_r8,0.64859e+02_r8,0.83719e+02_r8,0.11162e+03_r8 /)
      kbo(:, 1,58,16) = (/ &
        & 0.15720e+03_r8,0.11790e+03_r8,0.95809e+02_r8,0.12090e+03_r8,0.16121e+03_r8 /)
      kbo(:, 2,58,16) = (/ &
        & 0.14594e+03_r8,0.10946e+03_r8,0.86713e+02_r8,0.11017e+03_r8,0.14690e+03_r8 /)
      kbo(:, 3,58,16) = (/ &
        & 0.13577e+03_r8,0.10183e+03_r8,0.78898e+02_r8,0.10090e+03_r8,0.13454e+03_r8 /)
      kbo(:, 4,58,16) = (/ &
        & 0.12678e+03_r8,0.95087e+02_r8,0.72188e+02_r8,0.92844e+02_r8,0.12379e+03_r8 /)
      kbo(:, 5,58,16) = (/ &
        & 0.11865e+03_r8,0.88989e+02_r8,0.66460e+02_r8,0.85728e+02_r8,0.11430e+03_r8 /)
      kbo(:, 1,59,16) = (/ &
        & 0.15867e+03_r8,0.11900e+03_r8,0.97023e+02_r8,0.12235e+03_r8,0.16313e+03_r8 /)
      kbo(:, 2,59,16) = (/ &
        & 0.14725e+03_r8,0.11044e+03_r8,0.87747e+02_r8,0.11139e+03_r8,0.14852e+03_r8 /)
      kbo(:, 3,59,16) = (/ &
        & 0.13696e+03_r8,0.10272e+03_r8,0.79780e+02_r8,0.10196e+03_r8,0.13595e+03_r8 /)
      kbo(:, 4,59,16) = (/ &
        & 0.12782e+03_r8,0.95865e+02_r8,0.72946e+02_r8,0.93765e+02_r8,0.12502e+03_r8 /)
      kbo(:, 5,59,16) = (/ &
        & 0.11961e+03_r8,0.89706e+02_r8,0.67116e+02_r8,0.86544e+02_r8,0.11539e+03_r8 /)

!     -----------------------------------------------------------------

      forrefo(:, 1) = (/ 0.110008e-06_r8, 0.630912e-06_r8, 0.363159e-05_r8, 0.616892e-05_r8 /)
      forrefo(:, 2) = (/ 0.429709e-05_r8, 0.789174e-05_r8, 0.217416e-04_r8, 0.639393e-04_r8 /)
      forrefo(:, 3) = (/ 0.436283e-04_r8, 0.526247e-04_r8, 0.116341e-03_r8, 0.205616e-03_r8 /)
      forrefo(:, 4) = (/ 0.215627e-03_r8, 0.234522e-03_r8, 0.280497e-03_r8, 0.838668e-03_r8 /)
      forrefo(:, 5) = (/ 0.529283e-03_r8, 0.620848e-03_r8, 0.935561e-03_r8, 0.171252e-02_r8 /)
      forrefo(:, 6) = (/ 0.212267e-02_r8, 0.218564e-02_r8, 0.222227e-02_r8, 0.199650e-02_r8 /)
      forrefo(:, 7) = (/ 0.291120e-02_r8, 0.281168e-02_r8, 0.259543e-02_r8, 0.210159e-02_r8 /)
      forrefo(:, 8) = (/ 0.316249e-02_r8, 0.310695e-02_r8, 0.279501e-02_r8, 0.208076e-02_r8 /)
      forrefo(:, 9) = (/ 0.354993e-02_r8, 0.336989e-02_r8, 0.298930e-02_r8, 0.180424e-02_r8 /)
      forrefo(:,10) = (/ 0.397729e-02_r8, 0.367409e-02_r8, 0.328982e-02_r8, 0.177807e-02_r8 /)
      forrefo(:,11) = (/ 0.408831e-02_r8, 0.398792e-02_r8, 0.352727e-02_r8, 0.192470e-02_r8 /)
      forrefo(:,12) = (/ 0.433926e-02_r8, 0.420667e-02_r8, 0.383894e-02_r8, 0.220836e-02_r8 /)
      forrefo(:,13) = (/ 0.436397e-02_r8, 0.433769e-02_r8, 0.425752e-02_r8, 0.237343e-02_r8 /)
      forrefo(:,14) = (/ 0.440525e-02_r8, 0.449018e-02_r8, 0.451881e-02_r8, 0.269169e-02_r8 /)
      forrefo(:,15) = (/ 0.491350e-02_r8, 0.481760e-02_r8, 0.475799e-02_r8, 0.362666e-02_r8 /)
      forrefo(:,16) = (/ 0.561641e-02_r8, 0.524553e-02_r8, 0.512473e-02_r8, 0.493802e-02_r8 /)

!     -----------------------------------------------------------------
!     The array SELFREFO contains the coefficient of the water vapor
!     self-continuum (including the energy term).  The first index
!     refers to temperature in 7.2 degree increments.  For instance,
!     JT = 1 refers to a temperature of 245.6, JT = 2 refers to 252.8,
!     etc.  The second index runs over the g-channel (1 to 16).

      selfrefo(:, 1) = (/ &
        &  0.115887e-03_r8, 0.926537e-04_r8, 0.740783e-04_r8, 0.592270e-04_r8, 0.473530e-04_r8, &
        &  0.378596e-04_r8, 0.302694e-04_r8, 0.242010e-04_r8, 0.193491e-04_r8, 0.154700e-04_r8 /)
      selfrefo(:, 2) = (/ &
        &  0.459557e-03_r8, 0.381962e-03_r8, 0.317469e-03_r8, 0.263866e-03_r8, 0.219313e-03_r8, &
        &  0.182283e-03_r8, 0.151505e-03_r8, 0.125924e-03_r8, 0.104662e-03_r8, 0.869904e-04_r8 /)
      selfrefo(:, 3) = (/ &
        &  0.166821e-02_r8, 0.151103e-02_r8, 0.136866e-02_r8, 0.123970e-02_r8, 0.112290e-02_r8, &
        &  0.101710e-02_r8, 0.921266e-03_r8, 0.834463e-03_r8, 0.755839e-03_r8, 0.684623e-03_r8 /)
      selfrefo(:, 4) = (/ &
        &  0.460175e-02_r8, 0.421372e-02_r8, 0.385842e-02_r8, 0.353307e-02_r8, 0.323516e-02_r8, &
        &  0.296236e-02_r8, 0.271257e-02_r8, 0.248385e-02_r8, 0.227440e-02_r8, 0.208262e-02_r8 /)
      selfrefo(:, 5) = (/ &
        &  0.101589e-01_r8, 0.924742e-02_r8, 0.841772e-02_r8, 0.766247e-02_r8, 0.697497e-02_r8, &
        &  0.634917e-02_r8, 0.577951e-02_r8, 0.526096e-02_r8, 0.478893e-02_r8, 0.435926e-02_r8 /)
      selfrefo(:, 6) = (/ &
        &  0.328043e-01_r8, 0.300853e-01_r8, 0.275917e-01_r8, 0.253048e-01_r8, 0.232075e-01_r8, &
        &  0.212839e-01_r8, 0.195198e-01_r8, 0.179020e-01_r8, 0.164182e-01_r8, 0.150574e-01_r8 /)
      selfrefo(:, 7) = (/ &
        &  0.405936e-01_r8, 0.376032e-01_r8, 0.348331e-01_r8, 0.322671e-01_r8, 0.298901e-01_r8, &
        &  0.276883e-01_r8, 0.256486e-01_r8, 0.237591e-01_r8, 0.220089e-01_r8, 0.203876e-01_r8 /)
      selfrefo(:, 8) = (/ &
        &  0.448362e-01_r8, 0.413811e-01_r8, 0.381923e-01_r8, 0.352492e-01_r8, 0.325329e-01_r8, &
        &  0.300259e-01_r8, 0.277121e-01_r8, 0.255766e-01_r8, 0.236056e-01_r8, 0.217866e-01_r8 /)
      selfrefo(:, 9) = (/ &
        &  0.479741e-01_r8, 0.445389e-01_r8, 0.413497e-01_r8, 0.383889e-01_r8, 0.356400e-01_r8, &
        &  0.330880e-01_r8, 0.307188e-01_r8, 0.285191e-01_r8, 0.264770e-01_r8, 0.245812e-01_r8 /)
      selfrefo(:,10) = (/ &
        &  0.519308e-01_r8, 0.484130e-01_r8, 0.451335e-01_r8, 0.420761e-01_r8, 0.392259e-01_r8, &
        &  0.365687e-01_r8, 0.340916e-01_r8, 0.317822e-01_r8, 0.296293e-01_r8, 0.276222e-01_r8 /)
      selfrefo(:,11) = (/ &
        &  0.572039e-01_r8, 0.527780e-01_r8, 0.486945e-01_r8, 0.449270e-01_r8, 0.414510e-01_r8, &
        &  0.382439e-01_r8, 0.352849e-01_r8, 0.325549e-01_r8, 0.300361e-01_r8, 0.277122e-01_r8 /)
      selfrefo(:,12) = (/ &
        &  0.601046e-01_r8, 0.554411e-01_r8, 0.511395e-01_r8, 0.471716e-01_r8, 0.435116e-01_r8, &
        &  0.401356e-01_r8, 0.370215e-01_r8, 0.341490e-01_r8, 0.314994e-01_r8, 0.290554e-01_r8 /)
      selfrefo(:,13) = (/ &
        &  0.616595e-01_r8, 0.567145e-01_r8, 0.521662e-01_r8, 0.479826e-01_r8, 0.441346e-01_r8, &
        &  0.405951e-01_r8, 0.373395e-01_r8, 0.343450e-01_r8, 0.315906e-01_r8, 0.290571e-01_r8 /)
      selfrefo(:,14) = (/ &
        &  0.647916e-01_r8, 0.592493e-01_r8, 0.541811e-01_r8, 0.495465e-01_r8, 0.453083e-01_r8, &
        &  0.414326e-01_r8, 0.378885e-01_r8, 0.346475e-01_r8, 0.316837e-01_r8, 0.289735e-01_r8 /)
      selfrefo(:,15) = (/ &
        &  0.694231e-01_r8, 0.637703e-01_r8, 0.585777e-01_r8, 0.538079e-01_r8, 0.494265e-01_r8, &
        &  0.454019e-01_r8, 0.417050e-01_r8, 0.383091e-01_r8, 0.351897e-01_r8, 0.323244e-01_r8 /)
      selfrefo(:,16) = (/ &
        &  0.761764e-01_r8, 0.701815e-01_r8, 0.646584e-01_r8, 0.595700e-01_r8, 0.548820e-01_r8, &
        &  0.505629e-01_r8, 0.465838e-01_r8, 0.429178e-01_r8, 0.395403e-01_r8, 0.364286e-01_r8 /)
     
      end subroutine sw_kgb21

! **************************************************************************
