!     path:      $Source: /storm/rc1/cvsroot/rc/rrtmg_sw/src/rrtmg_sw_k_g.f90,v $
!     author:    $Author: mike $
!     revision:  $Revision: 1.2 $
!     created:   $Date: 2007/08/23 20:40:13 $

!  --------------------------------------------------------------------------
! |                                                                          |
! |  Copyright 2002-2007, Atmospheric & Environmental Research, Inc. (AER).  |
! |  This software may be used, copied, or redistributed as long as it is    |
! |  not sold and this copyright notice is reproduced on each copy made.     |
! |  This model is provided as is without any express or implied warranties. |
! |                       (http://www.rtweb.aer.com/)                        |
! |                                                                          |
!  --------------------------------------------------------------------------

! **************************************************************************
!      subroutine sw_kgbnn
! **************************************************************************
!  RRTM Shortwave Radiative Transfer Model
!  Atmospheric and Environmental Research, Inc., Cambridge, MA
!
!  Original by J.Delamere, Atmospheric & Environmental Research.
!  Reformatted for F90: JJMorcrette, ECMWF
!  Further F90 and GCM revisions:  MJIacono, AER, July 2002
!
!  This file contains 14 subroutines that include the 
!  absorption coefficients and other data for each of the 14 shortwave
!  spectral bands used in RRTM_SW.  Here, the data are defined for 16
!  g-points, or sub-intervals, per band.  These data are combined and
!  weighted using a mapping procedure in routine RRTMG_SW_INIT to reduce
!  the total number of g-points from 224 to 112 for use in the GCM.
! **************************************************************************

! **************************************************************************
! **************************************************************************
      subroutine sw_kgb23
! **************************************************************************

      use shr_kind_mod, only: r8 => shr_kind_r8

!      use parkind, only : jpim, jprb 
      use rrsw_kg23, only : kao, selfrefo, forrefo, sfluxrefo, &
                            raylo, givfac, layreffr

      implicit none
      save

! Kurucz solar source function
      sfluxrefo(:) = (/ &
        & 53.2101_r8 , 51.4143_r8, 49.3348_r8, 45.4612_r8    , &
        & 40.8294_r8 , 35.1801_r8, 28.6947_r8, 21.5751_r8    , &
        & 14.6388_r8 , 1.59111_r8, 1.31860_r8, 1.04018_r8    , &
        & 0.762140_r8,0.484214_r8,0.182275_r8, 2.54948e-02_r8 /)

! Rayleigh extinction coefficient at all v 
      raylo(:) = (/ &
        & 5.94837e-08_r8,5.70593e-08_r8,6.27845e-08_r8,5.56602e-08_r8, &
        & 5.25571e-08_r8,4.73388e-08_r8,4.17466e-08_r8,3.98097e-08_r8, &
        & 4.00786e-08_r8,3.67478e-08_r8,3.45186e-08_r8,3.46156e-08_r8, &
        & 3.32155e-08_r8,3.23642e-08_r8,2.72590e-08_r8,2.96813e-08_r8 /)

! Average Giver et al. correction factor for this band.
      givfac = 1.029_r8

      layreffr = 6

!     ------------------------------------------------------------------
!     The array KAO contains absorption coefs at the 16 chosen g-values 
!     for a range of pressure levels> ~100mb, temperatures, and binary
!     species parameters (see taumol.f for definition).  The first 
!     index in the array, JS, runs from 1 to 9, and corresponds to 
!     different values of the binary species parameter.  For instance, 
!     JS=1 refers to dry air, JS = 2 corresponds to the paramter value 1/8, 
!     JS = 3 corresponds to the parameter value 2/8, etc.  The second index
!     in the array, JT, which runs from 1 to 5, corresponds to different
!     temperatures.  More specifically, JT = 3 means that the data are for
!     the reference temperature TREF for this  pressure level, JT = 2 refers
!     to TREF-15, JT = 1 is for TREF-30, JT = 4 is for TREF+15, and JT = 5
!     is for TREF+30.  The third index, JP, runs from 1 to 13 and refers
!     to the JPth reference pressure level (see taumol.f for these levels
!     in mb).  The fourth index, IG, goes from 1 to 16, and indicates
!     which g-interval the absorption coefficients are for.
!     -----------------------------------------------------------------

      kao(:, 1, 1) = (/ &
        & 0.33078e-07_r8,0.34034e-07_r8,0.35124e-07_r8,0.34187e-07_r8,0.34744e-07_r8 /)
      kao(:, 2, 1) = (/ &
        & 0.25544e-07_r8,0.25873e-07_r8,0.26742e-07_r8,0.27512e-07_r8,0.27504e-07_r8 /)
      kao(:, 3, 1) = (/ &
        & 0.18549e-07_r8,0.19611e-07_r8,0.20840e-07_r8,0.22548e-07_r8,0.23069e-07_r8 /)
      kao(:, 4, 1) = (/ &
        & 0.28794e-07_r8,0.30837e-07_r8,0.32679e-07_r8,0.34307e-07_r8,0.36901e-07_r8 /)
      kao(:, 5, 1) = (/ &
        & 0.36776e-07_r8,0.39144e-07_r8,0.41300e-07_r8,0.43264e-07_r8,0.46626e-07_r8 /)
      kao(:, 6, 1) = (/ &
        & 0.59710e-07_r8,0.62941e-07_r8,0.65500e-07_r8,0.67353e-07_r8,0.68774e-07_r8 /)
      kao(:, 7, 1) = (/ &
        & 0.12143e-06_r8,0.12932e-06_r8,0.13250e-06_r8,0.13526e-06_r8,0.13849e-06_r8 /)
      kao(:, 8, 1) = (/ &
        & 0.12531e-06_r8,0.13241e-06_r8,0.13939e-06_r8,0.14705e-06_r8,0.15465e-06_r8 /)
      kao(:, 9, 1) = (/ &
        & 0.20209e-06_r8,0.21134e-06_r8,0.22163e-06_r8,0.23098e-06_r8,0.24004e-06_r8 /)
      kao(:,10, 1) = (/ &
        & 0.10750e-05_r8,0.11204e-05_r8,0.11575e-05_r8,0.11923e-05_r8,0.12227e-05_r8 /)
      kao(:,11, 1) = (/ &
        & 0.27782e-05_r8,0.28204e-05_r8,0.28406e-05_r8,0.28380e-05_r8,0.28440e-05_r8 /)
      kao(:,12, 1) = (/ &
        & 0.38510e-05_r8,0.39934e-05_r8,0.40697e-05_r8,0.41102e-05_r8,0.41571e-05_r8 /)
      kao(:,13, 1) = (/ &
        & 0.43157e-05_r8,0.44488e-05_r8,0.45799e-05_r8,0.46585e-05_r8,0.47223e-05_r8 /)
      kao(:, 1, 2) = (/ &
        & 0.84637e-06_r8,0.86989e-06_r8,0.90697e-06_r8,0.90000e-06_r8,0.91373e-06_r8 /)
      kao(:, 2, 2) = (/ &
        & 0.67062e-06_r8,0.68649e-06_r8,0.72334e-06_r8,0.73645e-06_r8,0.72978e-06_r8 /)
      kao(:, 3, 2) = (/ &
        & 0.52317e-06_r8,0.53924e-06_r8,0.55425e-06_r8,0.58347e-06_r8,0.57813e-06_r8 /)
      kao(:, 4, 2) = (/ &
        & 0.39868e-06_r8,0.41431e-06_r8,0.42761e-06_r8,0.43892e-06_r8,0.45982e-06_r8 /)
      kao(:, 5, 2) = (/ &
        & 0.32074e-06_r8,0.33452e-06_r8,0.34754e-06_r8,0.35582e-06_r8,0.37378e-06_r8 /)
      kao(:, 6, 2) = (/ &
        & 0.42465e-06_r8,0.44058e-06_r8,0.45605e-06_r8,0.47192e-06_r8,0.48493e-06_r8 /)
      kao(:, 7, 2) = (/ &
        & 0.47581e-06_r8,0.50000e-06_r8,0.52487e-06_r8,0.54192e-06_r8,0.55955e-06_r8 /)
      kao(:, 8, 2) = (/ &
        & 0.10592e-05_r8,0.11093e-05_r8,0.11483e-05_r8,0.11923e-05_r8,0.12169e-05_r8 /)
      kao(:, 9, 2) = (/ &
        & 0.50835e-05_r8,0.51710e-05_r8,0.52329e-05_r8,0.52644e-05_r8,0.52818e-05_r8 /)
      kao(:,10, 2) = (/ &
        & 0.77867e-05_r8,0.82156e-05_r8,0.86002e-05_r8,0.89664e-05_r8,0.92394e-05_r8 /)
      kao(:,11, 2) = (/ &
        & 0.89031e-05_r8,0.93573e-05_r8,0.97686e-05_r8,0.10236e-04_r8,0.10591e-04_r8 /)
      kao(:,12, 2) = (/ &
        & 0.98068e-05_r8,0.10238e-04_r8,0.10700e-04_r8,0.11108e-04_r8,0.11471e-04_r8 /)
      kao(:,13, 2) = (/ &
        & 0.11145e-04_r8,0.11697e-04_r8,0.12123e-04_r8,0.12482e-04_r8,0.12856e-04_r8 /)
      kao(:, 1, 3) = (/ &
        & 0.66049e-05_r8,0.67547e-05_r8,0.70104e-05_r8,0.69745e-05_r8,0.70687e-05_r8 /)
      kao(:, 2, 3) = (/ &
        & 0.54104e-05_r8,0.55245e-05_r8,0.57623e-05_r8,0.58532e-05_r8,0.58099e-05_r8 /)
      kao(:, 3, 3) = (/ &
        & 0.43608e-05_r8,0.44784e-05_r8,0.45778e-05_r8,0.47665e-05_r8,0.47295e-05_r8 /)
      kao(:, 4, 3) = (/ &
        & 0.35399e-05_r8,0.36454e-05_r8,0.37356e-05_r8,0.38107e-05_r8,0.39586e-05_r8 /)
      kao(:, 5, 3) = (/ &
        & 0.28576e-05_r8,0.29552e-05_r8,0.30325e-05_r8,0.31028e-05_r8,0.32276e-05_r8 /)
      kao(:, 6, 3) = (/ &
        & 0.21017e-05_r8,0.21836e-05_r8,0.22554e-05_r8,0.23121e-05_r8,0.23486e-05_r8 /)
      kao(:, 7, 3) = (/ &
        & 0.19384e-05_r8,0.19914e-05_r8,0.20428e-05_r8,0.20879e-05_r8,0.21191e-05_r8 /)
      kao(:, 8, 3) = (/ &
        & 0.32672e-05_r8,0.33753e-05_r8,0.34694e-05_r8,0.35273e-05_r8,0.35984e-05_r8 /)
      kao(:, 9, 3) = (/ &
        & 0.82257e-05_r8,0.84975e-05_r8,0.86969e-05_r8,0.88995e-05_r8,0.90123e-05_r8 /)
      kao(:,10, 3) = (/ &
        & 0.35363e-04_r8,0.36204e-04_r8,0.36916e-04_r8,0.37708e-04_r8,0.38294e-04_r8 /)
      kao(:,11, 3) = (/ &
        & 0.48837e-04_r8,0.50952e-04_r8,0.52710e-04_r8,0.54347e-04_r8,0.55976e-04_r8 /)
      kao(:,12, 3) = (/ &
        & 0.56059e-04_r8,0.58301e-04_r8,0.60100e-04_r8,0.61776e-04_r8,0.63179e-04_r8 /)
      kao(:,13, 3) = (/ &
        & 0.57871e-04_r8,0.59505e-04_r8,0.60930e-04_r8,0.62289e-04_r8,0.63278e-04_r8 /)
      kao(:, 1, 4) = (/ &
        & 0.27624e-04_r8,0.28017e-04_r8,0.29078e-04_r8,0.28567e-04_r8,0.28724e-04_r8 /)
      kao(:, 2, 4) = (/ &
        & 0.23107e-04_r8,0.23464e-04_r8,0.24357e-04_r8,0.24519e-04_r8,0.24024e-04_r8 /)
      kao(:, 3, 4) = (/ &
        & 0.19113e-04_r8,0.19400e-04_r8,0.19615e-04_r8,0.20420e-04_r8,0.19962e-04_r8 /)
      kao(:, 4, 4) = (/ &
        & 0.15873e-04_r8,0.16138e-04_r8,0.16349e-04_r8,0.16528e-04_r8,0.17176e-04_r8 /)
      kao(:, 5, 4) = (/ &
        & 0.13198e-04_r8,0.13437e-04_r8,0.13641e-04_r8,0.13810e-04_r8,0.14393e-04_r8 /)
      kao(:, 6, 4) = (/ &
        & 0.10951e-04_r8,0.11172e-04_r8,0.11352e-04_r8,0.11506e-04_r8,0.11631e-04_r8 /)
      kao(:, 7, 4) = (/ &
        & 0.86121e-05_r8,0.88300e-05_r8,0.90149e-05_r8,0.91565e-05_r8,0.92594e-05_r8 /)
      kao(:, 8, 4) = (/ &
        & 0.71478e-05_r8,0.72918e-05_r8,0.74035e-05_r8,0.74959e-05_r8,0.75566e-05_r8 /)
      kao(:, 9, 4) = (/ &
        & 0.16458e-04_r8,0.17092e-04_r8,0.17686e-04_r8,0.17967e-04_r8,0.18273e-04_r8 /)
      kao(:,10, 4) = (/ &
        & 0.47953e-04_r8,0.49663e-04_r8,0.51524e-04_r8,0.52800e-04_r8,0.54192e-04_r8 /)
      kao(:,11, 4) = (/ &
        & 0.94263e-04_r8,0.95557e-04_r8,0.96513e-04_r8,0.97430e-04_r8,0.97733e-04_r8 /)
      kao(:,12, 4) = (/ &
        & 0.12087e-03_r8,0.12152e-03_r8,0.12240e-03_r8,0.12318e-03_r8,0.12403e-03_r8 /)
      kao(:,13, 4) = (/ &
        & 0.12781e-03_r8,0.12897e-03_r8,0.13049e-03_r8,0.13171e-03_r8,0.13337e-03_r8 /)
      kao(:, 1, 5) = (/ &
        & 0.82859e-04_r8,0.84817e-04_r8,0.89056e-04_r8,0.88057e-04_r8,0.89410e-04_r8 /)
      kao(:, 2, 5) = (/ &
        & 0.70937e-04_r8,0.72685e-04_r8,0.76796e-04_r8,0.77955e-04_r8,0.76735e-04_r8 /)
      kao(:, 3, 5) = (/ &
        & 0.59876e-04_r8,0.61448e-04_r8,0.62837e-04_r8,0.66293e-04_r8,0.64996e-04_r8 /)
      kao(:, 4, 5) = (/ &
        & 0.50598e-04_r8,0.52054e-04_r8,0.53293e-04_r8,0.54332e-04_r8,0.57333e-04_r8 /)
      kao(:, 5, 5) = (/ &
        & 0.42742e-04_r8,0.44035e-04_r8,0.45164e-04_r8,0.46134e-04_r8,0.48935e-04_r8 /)
      kao(:, 6, 5) = (/ &
        & 0.35769e-04_r8,0.36975e-04_r8,0.38038e-04_r8,0.38917e-04_r8,0.39681e-04_r8 /)
      kao(:, 7, 5) = (/ &
        & 0.29747e-04_r8,0.30824e-04_r8,0.31756e-04_r8,0.32589e-04_r8,0.33314e-04_r8 /)
      kao(:, 8, 5) = (/ &
        & 0.21994e-04_r8,0.22945e-04_r8,0.23786e-04_r8,0.24517e-04_r8,0.25155e-04_r8 /)
      kao(:, 9, 5) = (/ &
        & 0.22298e-04_r8,0.22688e-04_r8,0.23127e-04_r8,0.23803e-04_r8,0.24335e-04_r8 /)
      kao(:,10, 5) = (/ &
        & 0.88898e-04_r8,0.91280e-04_r8,0.93333e-04_r8,0.95224e-04_r8,0.96298e-04_r8 /)
      kao(:,11, 5) = (/ &
        & 0.12299e-03_r8,0.12407e-03_r8,0.12536e-03_r8,0.12642e-03_r8,0.12813e-03_r8 /)
      kao(:,12, 5) = (/ &
        & 0.14539e-03_r8,0.14851e-03_r8,0.15022e-03_r8,0.15157e-03_r8,0.15204e-03_r8 /)
      kao(:,13, 5) = (/ &
        & 0.15949e-03_r8,0.16239e-03_r8,0.16467e-03_r8,0.16667e-03_r8,0.16801e-03_r8 /)
      kao(:, 1, 6) = (/ &
        & 0.25339e-03_r8,0.25995e-03_r8,0.27170e-03_r8,0.26963e-03_r8,0.27413e-03_r8 /)
      kao(:, 2, 6) = (/ &
        & 0.21908e-03_r8,0.22404e-03_r8,0.23522e-03_r8,0.23902e-03_r8,0.23717e-03_r8 /)
      kao(:, 3, 6) = (/ &
        & 0.18611e-03_r8,0.19076e-03_r8,0.19518e-03_r8,0.20503e-03_r8,0.20222e-03_r8 /)
      kao(:, 4, 6) = (/ &
        & 0.15769e-03_r8,0.16210e-03_r8,0.16597e-03_r8,0.16948e-03_r8,0.17817e-03_r8 /)
      kao(:, 5, 6) = (/ &
        & 0.13402e-03_r8,0.13792e-03_r8,0.14153e-03_r8,0.14434e-03_r8,0.15267e-03_r8 /)
      kao(:, 6, 6) = (/ &
        & 0.11390e-03_r8,0.11743e-03_r8,0.12065e-03_r8,0.12316e-03_r8,0.12543e-03_r8 /)
      kao(:, 7, 6) = (/ &
        & 0.96417e-04_r8,0.99612e-04_r8,0.10233e-03_r8,0.10453e-03_r8,0.10652e-03_r8 /)
      kao(:, 8, 6) = (/ &
        & 0.81395e-04_r8,0.84205e-04_r8,0.86346e-04_r8,0.88406e-04_r8,0.90122e-04_r8 /)
      kao(:, 9, 6) = (/ &
        & 0.47776e-04_r8,0.48971e-04_r8,0.49736e-04_r8,0.49917e-04_r8,0.50289e-04_r8 /)
      kao(:,10, 6) = (/ &
        & 0.10698e-03_r8,0.10815e-03_r8,0.10817e-03_r8,0.10799e-03_r8,0.10851e-03_r8 /)
      kao(:,11, 6) = (/ &
        & 0.20220e-03_r8,0.20727e-03_r8,0.21241e-03_r8,0.21675e-03_r8,0.21989e-03_r8 /)
      kao(:,12, 6) = (/ &
        & 0.23474e-03_r8,0.23601e-03_r8,0.23974e-03_r8,0.24383e-03_r8,0.24876e-03_r8 /)
      kao(:,13, 6) = (/ &
        & 0.23410e-03_r8,0.23809e-03_r8,0.24185e-03_r8,0.24554e-03_r8,0.24952e-03_r8 /)
      kao(:, 1, 7) = (/ &
        & 0.67024e-03_r8,0.68026e-03_r8,0.70419e-03_r8,0.70159e-03_r8,0.71089e-03_r8 /)
      kao(:, 2, 7) = (/ &
        & 0.58729e-03_r8,0.59778e-03_r8,0.62097e-03_r8,0.62912e-03_r8,0.62423e-03_r8 /)
      kao(:, 3, 7) = (/ &
        & 0.50967e-03_r8,0.51900e-03_r8,0.52765e-03_r8,0.54794e-03_r8,0.54266e-03_r8 /)
      kao(:, 4, 7) = (/ &
        & 0.44167e-03_r8,0.45006e-03_r8,0.45793e-03_r8,0.46469e-03_r8,0.48335e-03_r8 /)
      kao(:, 5, 7) = (/ &
        & 0.38096e-03_r8,0.38881e-03_r8,0.39576e-03_r8,0.40259e-03_r8,0.42086e-03_r8 /)
      kao(:, 6, 7) = (/ &
        & 0.32818e-03_r8,0.33539e-03_r8,0.34192e-03_r8,0.34829e-03_r8,0.35405e-03_r8 /)
      kao(:, 7, 7) = (/ &
        & 0.28259e-03_r8,0.28946e-03_r8,0.29584e-03_r8,0.30203e-03_r8,0.30742e-03_r8 /)
      kao(:, 8, 7) = (/ &
        & 0.24273e-03_r8,0.24912e-03_r8,0.25546e-03_r8,0.26110e-03_r8,0.26607e-03_r8 /)
      kao(:, 9, 7) = (/ &
        & 0.19937e-03_r8,0.20653e-03_r8,0.21314e-03_r8,0.21968e-03_r8,0.22520e-03_r8 /)
      kao(:,10, 7) = (/ &
        & 0.13306e-03_r8,0.13331e-03_r8,0.13393e-03_r8,0.13538e-03_r8,0.13616e-03_r8 /)
      kao(:,11, 7) = (/ &
        & 0.16236e-03_r8,0.16154e-03_r8,0.16187e-03_r8,0.16113e-03_r8,0.16209e-03_r8 /)
      kao(:,12, 7) = (/ &
        & 0.17872e-03_r8,0.18355e-03_r8,0.18612e-03_r8,0.18792e-03_r8,0.18745e-03_r8 /)
      kao(:,13, 7) = (/ &
        & 0.18970e-03_r8,0.19384e-03_r8,0.19773e-03_r8,0.20261e-03_r8,0.20377e-03_r8 /)
      kao(:, 1, 8) = (/ &
        & 0.18130e-02_r8,0.18305e-02_r8,0.18716e-02_r8,0.18655e-02_r8,0.18814e-02_r8 /)
      kao(:, 2, 8) = (/ &
        & 0.16420e-02_r8,0.16600e-02_r8,0.17006e-02_r8,0.17156e-02_r8,0.17108e-02_r8 /)
      kao(:, 3, 8) = (/ &
        & 0.14687e-02_r8,0.14870e-02_r8,0.15042e-02_r8,0.15423e-02_r8,0.15376e-02_r8 /)
      kao(:, 4, 8) = (/ &
        & 0.13068e-02_r8,0.13248e-02_r8,0.13421e-02_r8,0.13592e-02_r8,0.13960e-02_r8 /)
      kao(:, 5, 8) = (/ &
        & 0.11574e-02_r8,0.11753e-02_r8,0.11928e-02_r8,0.12097e-02_r8,0.12467e-02_r8 /)
      kao(:, 6, 8) = (/ &
        & 0.10167e-02_r8,0.10342e-02_r8,0.10515e-02_r8,0.10681e-02_r8,0.10840e-02_r8 /)
      kao(:, 7, 8) = (/ &
        & 0.88992e-03_r8,0.90662e-03_r8,0.92299e-03_r8,0.93844e-03_r8,0.95347e-03_r8 /)
      kao(:, 8, 8) = (/ &
        & 0.78445e-03_r8,0.80031e-03_r8,0.81639e-03_r8,0.83131e-03_r8,0.84631e-03_r8 /)
      kao(:, 9, 8) = (/ &
        & 0.69812e-03_r8,0.71312e-03_r8,0.72801e-03_r8,0.74222e-03_r8,0.75605e-03_r8 /)
      kao(:,10, 8) = (/ &
        & 0.32521e-03_r8,0.33835e-03_r8,0.35194e-03_r8,0.36381e-03_r8,0.37594e-03_r8 /)
      kao(:,11, 8) = (/ &
        & 0.31406e-03_r8,0.32013e-03_r8,0.32456e-03_r8,0.33261e-03_r8,0.33741e-03_r8 /)
      kao(:,12, 8) = (/ &
        & 0.28132e-03_r8,0.28732e-03_r8,0.29674e-03_r8,0.30509e-03_r8,0.31393e-03_r8 /)
      kao(:,13, 8) = (/ &
        & 0.25704e-03_r8,0.26316e-03_r8,0.27195e-03_r8,0.27732e-03_r8,0.28905e-03_r8 /)
      kao(:, 1, 9) = (/ &
        & 0.67370e-02_r8,0.67873e-02_r8,0.68896e-02_r8,0.68819e-02_r8,0.69268e-02_r8 /)
      kao(:, 2, 9) = (/ &
        & 0.63111e-02_r8,0.63622e-02_r8,0.64623e-02_r8,0.65060e-02_r8,0.65027e-02_r8 /)
      kao(:, 3, 9) = (/ &
        & 0.58834e-02_r8,0.59361e-02_r8,0.59858e-02_r8,0.60811e-02_r8,0.60806e-02_r8 /)
      kao(:, 4, 9) = (/ &
        & 0.54753e-02_r8,0.55309e-02_r8,0.55823e-02_r8,0.56306e-02_r8,0.57229e-02_r8 /)
      kao(:, 5, 9) = (/ &
        & 0.50781e-02_r8,0.51373e-02_r8,0.51895e-02_r8,0.52391e-02_r8,0.53328e-02_r8 /)
      kao(:, 6, 9) = (/ &
        & 0.46791e-02_r8,0.47408e-02_r8,0.47949e-02_r8,0.48470e-02_r8,0.48993e-02_r8 /)
      kao(:, 7, 9) = (/ &
        & 0.42724e-02_r8,0.43381e-02_r8,0.43951e-02_r8,0.44503e-02_r8,0.45061e-02_r8 /)
      kao(:, 8, 9) = (/ &
        & 0.38568e-02_r8,0.39254e-02_r8,0.39848e-02_r8,0.40431e-02_r8,0.41005e-02_r8 /)
      kao(:, 9, 9) = (/ &
        & 0.35657e-02_r8,0.36362e-02_r8,0.36994e-02_r8,0.37608e-02_r8,0.38215e-02_r8 /)
      kao(:,10, 9) = (/ &
        & 0.33774e-02_r8,0.34501e-02_r8,0.35171e-02_r8,0.35811e-02_r8,0.36450e-02_r8 /)
      kao(:,11, 9) = (/ &
        & 0.23923e-02_r8,0.24623e-02_r8,0.25263e-02_r8,0.25890e-02_r8,0.26517e-02_r8 /)
      kao(:,12, 9) = (/ &
        & 0.16959e-02_r8,0.17542e-02_r8,0.18077e-02_r8,0.18614e-02_r8,0.19187e-02_r8 /)
      kao(:,13, 9) = (/ &
        & 0.11732e-02_r8,0.12232e-02_r8,0.12712e-02_r8,0.13221e-02_r8,0.13677e-02_r8 /)
      kao(:, 1,10) = (/ &
        & 0.19604e-01_r8,0.19698e-01_r8,0.19938e-01_r8,0.19854e-01_r8,0.19950e-01_r8 /)
      kao(:, 2,10) = (/ &
        & 0.18714e-01_r8,0.18803e-01_r8,0.19035e-01_r8,0.19131e-01_r8,0.19102e-01_r8 /)
      kao(:, 3,10) = (/ &
        & 0.17676e-01_r8,0.17785e-01_r8,0.17904e-01_r8,0.18189e-01_r8,0.18156e-01_r8 /)
      kao(:, 4,10) = (/ &
        & 0.16662e-01_r8,0.16773e-01_r8,0.16908e-01_r8,0.17056e-01_r8,0.17303e-01_r8 /)
      kao(:, 5,10) = (/ &
        & 0.15655e-01_r8,0.15775e-01_r8,0.15942e-01_r8,0.16103e-01_r8,0.16359e-01_r8 /)
      kao(:, 6,10) = (/ &
        & 0.14694e-01_r8,0.14838e-01_r8,0.15029e-01_r8,0.15200e-01_r8,0.15320e-01_r8 /)
      kao(:, 7,10) = (/ &
        & 0.13797e-01_r8,0.13959e-01_r8,0.14174e-01_r8,0.14350e-01_r8,0.14471e-01_r8 /)
      kao(:, 8,10) = (/ &
        & 0.12902e-01_r8,0.13089e-01_r8,0.13313e-01_r8,0.13489e-01_r8,0.13626e-01_r8 /)
      kao(:, 9,10) = (/ &
        & 0.11897e-01_r8,0.12105e-01_r8,0.12333e-01_r8,0.12512e-01_r8,0.12656e-01_r8 /)
      kao(:,10,10) = (/ &
        & 0.11834e-01_r8,0.12072e-01_r8,0.12331e-01_r8,0.12548e-01_r8,0.12721e-01_r8 /)
      kao(:,11,10) = (/ &
        & 0.11416e-01_r8,0.11699e-01_r8,0.11968e-01_r8,0.12141e-01_r8,0.12311e-01_r8 /)
      kao(:,12,10) = (/ &
        & 0.10776e-01_r8,0.11070e-01_r8,0.11309e-01_r8,0.11507e-01_r8,0.11702e-01_r8 /)
      kao(:,13,10) = (/ &
        & 0.99577e-02_r8,0.10263e-01_r8,0.10492e-01_r8,0.10719e-01_r8,0.10951e-01_r8 /)
      kao(:, 1,11) = (/ &
        & 0.29783e-01_r8,0.29883e-01_r8,0.30210e-01_r8,0.30141e-01_r8,0.30248e-01_r8 /)
      kao(:, 2,11) = (/ &
        & 0.28562e-01_r8,0.28743e-01_r8,0.29186e-01_r8,0.29339e-01_r8,0.29258e-01_r8 /)
      kao(:, 3,11) = (/ &
        & 0.27212e-01_r8,0.27429e-01_r8,0.27654e-01_r8,0.28083e-01_r8,0.28023e-01_r8 /)
      kao(:, 4,11) = (/ &
        & 0.25949e-01_r8,0.26197e-01_r8,0.26424e-01_r8,0.26623e-01_r8,0.27069e-01_r8 /)
      kao(:, 5,11) = (/ &
        & 0.24686e-01_r8,0.24942e-01_r8,0.25176e-01_r8,0.25403e-01_r8,0.25908e-01_r8 /)
      kao(:, 6,11) = (/ &
        & 0.23430e-01_r8,0.23686e-01_r8,0.23923e-01_r8,0.24158e-01_r8,0.24433e-01_r8 /)
      kao(:, 7,11) = (/ &
        & 0.22171e-01_r8,0.22424e-01_r8,0.22653e-01_r8,0.22909e-01_r8,0.23203e-01_r8 /)
      kao(:, 8,11) = (/ &
        & 0.20928e-01_r8,0.21171e-01_r8,0.21407e-01_r8,0.21699e-01_r8,0.22018e-01_r8 /)
      kao(:, 9,11) = (/ &
        & 0.19076e-01_r8,0.19320e-01_r8,0.19548e-01_r8,0.19858e-01_r8,0.20150e-01_r8 /)
      kao(:,10,11) = (/ &
        & 0.19537e-01_r8,0.19788e-01_r8,0.20064e-01_r8,0.20391e-01_r8,0.20843e-01_r8 /)
      kao(:,11,11) = (/ &
        & 0.19137e-01_r8,0.19444e-01_r8,0.19793e-01_r8,0.20268e-01_r8,0.20695e-01_r8 /)
      kao(:,12,11) = (/ &
        & 0.18393e-01_r8,0.18715e-01_r8,0.19143e-01_r8,0.19652e-01_r8,0.20037e-01_r8 /)
      kao(:,13,11) = (/ &
        & 0.17255e-01_r8,0.17680e-01_r8,0.18170e-01_r8,0.18641e-01_r8,0.19010e-01_r8 /)
      kao(:, 1,12) = (/ &
        & 0.46641e-01_r8,0.46796e-01_r8,0.47107e-01_r8,0.46977e-01_r8,0.47093e-01_r8 /)
      kao(:, 2,12) = (/ &
        & 0.46819e-01_r8,0.46956e-01_r8,0.47337e-01_r8,0.47426e-01_r8,0.47339e-01_r8 /)
      kao(:, 3,12) = (/ &
        & 0.46276e-01_r8,0.46366e-01_r8,0.46462e-01_r8,0.46935e-01_r8,0.46862e-01_r8 /)
      kao(:, 4,12) = (/ &
        & 0.44986e-01_r8,0.45103e-01_r8,0.45287e-01_r8,0.45535e-01_r8,0.46152e-01_r8 /)
      kao(:, 5,12) = (/ &
        & 0.43367e-01_r8,0.43552e-01_r8,0.43761e-01_r8,0.44035e-01_r8,0.44674e-01_r8 /)
      kao(:, 6,12) = (/ &
        & 0.41584e-01_r8,0.41793e-01_r8,0.42020e-01_r8,0.42344e-01_r8,0.42701e-01_r8 /)
      kao(:, 7,12) = (/ &
        & 0.39785e-01_r8,0.40007e-01_r8,0.40269e-01_r8,0.40635e-01_r8,0.41003e-01_r8 /)
      kao(:, 8,12) = (/ &
        & 0.37918e-01_r8,0.38155e-01_r8,0.38468e-01_r8,0.38839e-01_r8,0.39210e-01_r8 /)
      kao(:, 9,12) = (/ &
        & 0.35060e-01_r8,0.35328e-01_r8,0.35698e-01_r8,0.36105e-01_r8,0.36551e-01_r8 /)
      kao(:,10,12) = (/ &
        & 0.35216e-01_r8,0.35547e-01_r8,0.35872e-01_r8,0.36327e-01_r8,0.36542e-01_r8 /)
      kao(:,11,12) = (/ &
        & 0.35158e-01_r8,0.35374e-01_r8,0.35869e-01_r8,0.36242e-01_r8,0.36691e-01_r8 /)
      kao(:,12,12) = (/ &
        & 0.34264e-01_r8,0.34598e-01_r8,0.35106e-01_r8,0.35505e-01_r8,0.36021e-01_r8 /)
      kao(:,13,12) = (/ &
        & 0.32716e-01_r8,0.33195e-01_r8,0.33830e-01_r8,0.34228e-01_r8,0.34925e-01_r8 /)
      kao(:, 1,13) = (/ &
        & 0.76084e-01_r8,0.76052e-01_r8,0.76051e-01_r8,0.75851e-01_r8,0.75753e-01_r8 /)
      kao(:, 2,13) = (/ &
        & 0.79580e-01_r8,0.79564e-01_r8,0.79664e-01_r8,0.79619e-01_r8,0.79414e-01_r8 /)
      kao(:, 3,13) = (/ &
        & 0.82218e-01_r8,0.82302e-01_r8,0.82367e-01_r8,0.82543e-01_r8,0.82246e-01_r8 /)
      kao(:, 4,13) = (/ &
        & 0.83613e-01_r8,0.83740e-01_r8,0.83824e-01_r8,0.83866e-01_r8,0.84103e-01_r8 /)
      kao(:, 5,13) = (/ &
        & 0.83913e-01_r8,0.84123e-01_r8,0.84289e-01_r8,0.84403e-01_r8,0.84840e-01_r8 /)
      kao(:, 6,13) = (/ &
        & 0.83159e-01_r8,0.83442e-01_r8,0.83718e-01_r8,0.83891e-01_r8,0.83993e-01_r8 /)
      kao(:, 7,13) = (/ &
        & 0.81401e-01_r8,0.81826e-01_r8,0.82202e-01_r8,0.82451e-01_r8,0.82656e-01_r8 /)
      kao(:, 8,13) = (/ &
        & 0.78949e-01_r8,0.79505e-01_r8,0.79978e-01_r8,0.80351e-01_r8,0.80690e-01_r8 /)
      kao(:, 9,13) = (/ &
        & 0.76002e-01_r8,0.76671e-01_r8,0.77279e-01_r8,0.77752e-01_r8,0.78257e-01_r8 /)
      kao(:,10,13) = (/ &
        & 0.69777e-01_r8,0.70425e-01_r8,0.71054e-01_r8,0.71706e-01_r8,0.72167e-01_r8 /)
      kao(:,11,13) = (/ &
        & 0.72929e-01_r8,0.73732e-01_r8,0.74323e-01_r8,0.75246e-01_r8,0.75786e-01_r8 /)
      kao(:,12,13) = (/ &
        & 0.73007e-01_r8,0.74429e-01_r8,0.74922e-01_r8,0.75916e-01_r8,0.76947e-01_r8 /)
      kao(:,13,13) = (/ &
        & 0.71376e-01_r8,0.72507e-01_r8,0.73710e-01_r8,0.74716e-01_r8,0.75702e-01_r8 /)
      kao(:, 1,14) = (/ &
        & 0.12585e+00_r8,0.12569e+00_r8,0.12576e+00_r8,0.12571e+00_r8,0.12570e+00_r8 /)
      kao(:, 2,14) = (/ &
        & 0.13868e+00_r8,0.13853e+00_r8,0.13849e+00_r8,0.13824e+00_r8,0.13803e+00_r8 /)
      kao(:, 3,14) = (/ &
        & 0.15142e+00_r8,0.15135e+00_r8,0.15112e+00_r8,0.15093e+00_r8,0.15074e+00_r8 /)
      kao(:, 4,14) = (/ &
        & 0.16359e+00_r8,0.16359e+00_r8,0.16339e+00_r8,0.16311e+00_r8,0.16285e+00_r8 /)
      kao(:, 5,14) = (/ &
        & 0.17462e+00_r8,0.17472e+00_r8,0.17456e+00_r8,0.17421e+00_r8,0.17393e+00_r8 /)
      kao(:, 6,14) = (/ &
        & 0.18403e+00_r8,0.18447e+00_r8,0.18450e+00_r8,0.18424e+00_r8,0.18395e+00_r8 /)
      kao(:, 7,14) = (/ &
        & 0.19179e+00_r8,0.19239e+00_r8,0.19256e+00_r8,0.19253e+00_r8,0.19252e+00_r8 /)
      kao(:, 8,14) = (/ &
        & 0.19772e+00_r8,0.19863e+00_r8,0.19901e+00_r8,0.19923e+00_r8,0.19947e+00_r8 /)
      kao(:, 9,14) = (/ &
        & 0.20154e+00_r8,0.20279e+00_r8,0.20355e+00_r8,0.20417e+00_r8,0.20473e+00_r8 /)
      kao(:,10,14) = (/ &
        & 0.18853e+00_r8,0.19028e+00_r8,0.19160e+00_r8,0.19253e+00_r8,0.19393e+00_r8 /)
      kao(:,11,14) = (/ &
        & 0.18013e+00_r8,0.18167e+00_r8,0.18320e+00_r8,0.18375e+00_r8,0.18507e+00_r8 /)
      kao(:,12,14) = (/ &
        & 0.19011e+00_r8,0.19027e+00_r8,0.19283e+00_r8,0.19402e+00_r8,0.19478e+00_r8 /)
      kao(:,13,14) = (/ &
        & 0.19594e+00_r8,0.19738e+00_r8,0.19911e+00_r8,0.20124e+00_r8,0.20282e+00_r8 /)
      kao(:, 1,15) = (/ &
        & 0.22369e+00_r8,0.22259e+00_r8,0.22155e+00_r8,0.22059e+00_r8,0.21997e+00_r8 /)
      kao(:, 2,15) = (/ &
        & 0.25602e+00_r8,0.25478e+00_r8,0.25377e+00_r8,0.25306e+00_r8,0.25237e+00_r8 /)
      kao(:, 3,15) = (/ &
        & 0.29258e+00_r8,0.29107e+00_r8,0.28998e+00_r8,0.28920e+00_r8,0.28830e+00_r8 /)
      kao(:, 4,15) = (/ &
        & 0.33067e+00_r8,0.32888e+00_r8,0.32753e+00_r8,0.32646e+00_r8,0.32566e+00_r8 /)
      kao(:, 5,15) = (/ &
        & 0.37114e+00_r8,0.36880e+00_r8,0.36713e+00_r8,0.36598e+00_r8,0.36499e+00_r8 /)
      kao(:, 6,15) = (/ &
        & 0.41494e+00_r8,0.41167e+00_r8,0.40935e+00_r8,0.40779e+00_r8,0.40636e+00_r8 /)
      kao(:, 7,15) = (/ &
        & 0.46115e+00_r8,0.45729e+00_r8,0.45455e+00_r8,0.45230e+00_r8,0.45004e+00_r8 /)
      kao(:, 8,15) = (/ &
        & 0.50906e+00_r8,0.50463e+00_r8,0.50137e+00_r8,0.49843e+00_r8,0.49550e+00_r8 /)
      kao(:, 9,15) = (/ &
        & 0.55829e+00_r8,0.55330e+00_r8,0.54936e+00_r8,0.54557e+00_r8,0.54168e+00_r8 /)
      kao(:,10,15) = (/ &
        & 0.60814e+00_r8,0.60274e+00_r8,0.59806e+00_r8,0.59326e+00_r8,0.58833e+00_r8 /)
      kao(:,11,15) = (/ &
        & 0.62954e+00_r8,0.62588e+00_r8,0.62076e+00_r8,0.61665e+00_r8,0.61184e+00_r8 /)
      kao(:,12,15) = (/ &
        & 0.62585e+00_r8,0.62437e+00_r8,0.61807e+00_r8,0.61303e+00_r8,0.60869e+00_r8 /)
      kao(:,13,15) = (/ &
        & 0.64856e+00_r8,0.64505e+00_r8,0.63861e+00_r8,0.63277e+00_r8,0.62702e+00_r8 /)
      kao(:, 1,16) = (/ &
        & 0.33327e+00_r8,0.33385e+00_r8,0.33538e+00_r8,0.33638e+00_r8,0.33736e+00_r8 /)
      kao(:, 2,16) = (/ &
        & 0.40916e+00_r8,0.40842e+00_r8,0.40848e+00_r8,0.40865e+00_r8,0.40854e+00_r8 /)
      kao(:, 3,16) = (/ &
        & 0.50099e+00_r8,0.49888e+00_r8,0.49727e+00_r8,0.49588e+00_r8,0.49422e+00_r8 /)
      kao(:, 4,16) = (/ &
        & 0.60389e+00_r8,0.60029e+00_r8,0.59704e+00_r8,0.59367e+00_r8,0.59071e+00_r8 /)
      kao(:, 5,16) = (/ &
        & 0.71868e+00_r8,0.71337e+00_r8,0.70835e+00_r8,0.70318e+00_r8,0.69852e+00_r8 /)
      kao(:, 6,16) = (/ &
        & 0.84815e+00_r8,0.84138e+00_r8,0.83446e+00_r8,0.82728e+00_r8,0.82023e+00_r8 /)
      kao(:, 7,16) = (/ &
        & 0.99512e+00_r8,0.98644e+00_r8,0.97698e+00_r8,0.96695e+00_r8,0.95712e+00_r8 /)
      kao(:, 8,16) = (/ &
        & 0.11606e+01_r8,0.11485e+01_r8,0.11354e+01_r8,0.11218e+01_r8,0.11077e+01_r8 /)
      kao(:, 9,16) = (/ &
        & 0.13444e+01_r8,0.13282e+01_r8,0.13102e+01_r8,0.12917e+01_r8,0.12735e+01_r8 /)
      kao(:,10,16) = (/ &
        & 0.15423e+01_r8,0.15207e+01_r8,0.14970e+01_r8,0.14733e+01_r8,0.14494e+01_r8 /)
      kao(:,11,16) = (/ &
        & 0.17462e+01_r8,0.17138e+01_r8,0.16827e+01_r8,0.16518e+01_r8,0.16199e+01_r8 /)
      kao(:,12,16) = (/ &
        & 0.19577e+01_r8,0.19145e+01_r8,0.18728e+01_r8,0.18320e+01_r8,0.17910e+01_r8 /)
      kao(:,13,16) = (/ &
        & 0.21716e+01_r8,0.21171e+01_r8,0.20639e+01_r8,0.20113e+01_r8,0.19587e+01_r8 /)
  
!     -----------------------------------------------------------------

      forrefo(:, 1) = (/ 0.315770e-07_r8, 0.671978e-07_r8, 0.440649e-06_r8 /)
      forrefo(:, 2) = (/ 0.313674e-06_r8, 0.285252e-06_r8, 0.421024e-05_r8 /)
      forrefo(:, 3) = (/ 0.135818e-05_r8, 0.145071e-05_r8, 0.611285e-05_r8 /)
      forrefo(:, 4) = (/ 0.534065e-05_r8, 0.586268e-05_r8, 0.933970e-05_r8 /)
      forrefo(:, 5) = (/ 0.964007e-05_r8, 0.107110e-04_r8, 0.104486e-04_r8 /)
      forrefo(:, 6) = (/ 0.302775e-04_r8, 0.357530e-04_r8, 0.340724e-04_r8 /)
      forrefo(:, 7) = (/ 0.102437e-03_r8, 0.108475e-03_r8, 0.105245e-03_r8 /)
      forrefo(:, 8) = (/ 0.146054e-03_r8, 0.141490e-03_r8, 0.133071e-03_r8 /)
      forrefo(:, 9) = (/ 0.163978e-03_r8, 0.150208e-03_r8, 0.142864e-03_r8 /)
      forrefo(:,10) = (/ 0.220412e-03_r8, 0.182943e-03_r8, 0.150941e-03_r8 /)
      forrefo(:,11) = (/ 0.228877e-03_r8, 0.197679e-03_r8, 0.163220e-03_r8 /)
      forrefo(:,12) = (/ 0.234177e-03_r8, 0.217734e-03_r8, 0.185038e-03_r8 /)
      forrefo(:,13) = (/ 0.257187e-03_r8, 0.241570e-03_r8, 0.221178e-03_r8 /)
      forrefo(:,14) = (/ 0.272455e-03_r8, 0.270637e-03_r8, 0.256269e-03_r8 /)
      forrefo(:,15) = (/ 0.339445e-03_r8, 0.300268e-03_r8, 0.286574e-03_r8 /)
      forrefo(:,16) = (/ 0.338841e-03_r8, 0.355428e-03_r8, 0.353794e-03_r8 /)

!     -----------------------------------------------------------------
!     The array SELFREFO contains the coefficient of the water vapor
!     self-continuum (including the energy term).  The first index
!     refers to temperature in 7.2 degree increments.  For instance,
!     JT = 1 refers to a temperature of 245.6, JT = 2 refers to 252.8,
!     etc.  The second index runs over the g-channel (1 to 16).

      selfrefo(:, 1) = (/ &
        &  0.100945e-04_r8, 0.801113e-05_r8, 0.635771e-05_r8, 0.504554e-05_r8, 0.400419e-05_r8, &
        &  0.317777e-05_r8, 0.252191e-05_r8, 0.200141e-05_r8, 0.158834e-05_r8, 0.126052e-05_r8 /)
      selfrefo(:, 2) = (/ &
        &  0.107573e-04_r8, 0.999809e-05_r8, 0.929245e-05_r8, 0.863661e-05_r8, 0.802706e-05_r8, &
        &  0.746053e-05_r8, 0.693399e-05_r8, 0.644460e-05_r8, 0.598976e-05_r8, 0.556702e-05_r8 /)
      selfrefo(:, 3) = (/ &
        &  0.350389e-04_r8, 0.319234e-04_r8, 0.290850e-04_r8, 0.264989e-04_r8, 0.241428e-04_r8, &
        &  0.219962e-04_r8, 0.200404e-04_r8, 0.182586e-04_r8, 0.166351e-04_r8, 0.151560e-04_r8 /)
      selfrefo(:, 4) = (/ &
        &  0.122993e-03_r8, 0.110885e-03_r8, 0.999691e-04_r8, 0.901277e-04_r8, 0.812551e-04_r8, &
        &  0.732559e-04_r8, 0.660443e-04_r8, 0.595426e-04_r8, 0.536809e-04_r8, 0.483963e-04_r8 /)
      selfrefo(:, 5) = (/ &
        &  0.206434e-03_r8, 0.187435e-03_r8, 0.170185e-03_r8, 0.154522e-03_r8, 0.140301e-03_r8, &
        &  0.127388e-03_r8, 0.115664e-03_r8, 0.105019e-03_r8, 0.953540e-04_r8, 0.865783e-04_r8 /)
      selfrefo(:, 6) = (/ &
        &  0.590645e-03_r8, 0.533109e-03_r8, 0.481177e-03_r8, 0.434305e-03_r8, 0.391998e-03_r8, &
        &  0.353812e-03_r8, 0.319346e-03_r8, 0.288238e-03_r8, 0.260160e-03_r8, 0.234817e-03_r8 /)
      selfrefo(:, 7) = (/ &
        &  0.163029e-02_r8, 0.148773e-02_r8, 0.135763e-02_r8, 0.123891e-02_r8, 0.113057e-02_r8, &
        &  0.103170e-02_r8, 0.941483e-03_r8, 0.859153e-03_r8, 0.784023e-03_r8, 0.715462e-03_r8 /)
      selfrefo(:, 8) = (/ &
        &  0.204528e-02_r8, 0.189258e-02_r8, 0.175128e-02_r8, 0.162053e-02_r8, 0.149954e-02_r8, &
        &  0.138758e-02_r8, 0.128398e-02_r8, 0.118812e-02_r8, 0.109941e-02_r8, 0.101733e-02_r8 /)
      selfrefo(:, 9) = (/ &
        &  0.210589e-02_r8, 0.197078e-02_r8, 0.184434e-02_r8, 0.172601e-02_r8, 0.161528e-02_r8, &
        &  0.151164e-02_r8, 0.141466e-02_r8, 0.132390e-02_r8, 0.123896e-02_r8, 0.115947e-02_r8 /)
      selfrefo(:,10) = (/ &
        &  0.245098e-02_r8, 0.233745e-02_r8, 0.222918e-02_r8, 0.212592e-02_r8, 0.202745e-02_r8, &
        &  0.193353e-02_r8, 0.184397e-02_r8, 0.175856e-02_r8, 0.167710e-02_r8, 0.159941e-02_r8 /)
      selfrefo(:,11) = (/ &
        &  0.267460e-02_r8, 0.253325e-02_r8, 0.239936e-02_r8, 0.227255e-02_r8, 0.215244e-02_r8, &
        &  0.203868e-02_r8, 0.193093e-02_r8, 0.182888e-02_r8, 0.173222e-02_r8, 0.164067e-02_r8 /)
      selfrefo(:,12) = (/ &
        &  0.304510e-02_r8, 0.283919e-02_r8, 0.264720e-02_r8, 0.246820e-02_r8, 0.230130e-02_r8, &
        &  0.214568e-02_r8, 0.200059e-02_r8, 0.186531e-02_r8, 0.173918e-02_r8, 0.162157e-02_r8 /)
      selfrefo(:,13) = (/ &
        &  0.338445e-02_r8, 0.314719e-02_r8, 0.292655e-02_r8, 0.272139e-02_r8, 0.253060e-02_r8, &
        &  0.235319e-02_r8, 0.218822e-02_r8, 0.203482e-02_r8, 0.189217e-02_r8, 0.175952e-02_r8 /)
      selfrefo(:,14) = (/ &
        &  0.388649e-02_r8, 0.357018e-02_r8, 0.327961e-02_r8, 0.301269e-02_r8, 0.276750e-02_r8, &
        &  0.254226e-02_r8, 0.233535e-02_r8, 0.214528e-02_r8, 0.197068e-02_r8, 0.181029e-02_r8 /)
      selfrefo(:,15) = (/ &
        &  0.412547e-02_r8, 0.387413e-02_r8, 0.363810e-02_r8, 0.341646e-02_r8, 0.320831e-02_r8, &
        &  0.301285e-02_r8, 0.282930e-02_r8, 0.265693e-02_r8, 0.249506e-02_r8, 0.234305e-02_r8 /)
      selfrefo(:,16) = (/ &
        &  0.534327e-02_r8, 0.482967e-02_r8, 0.436544e-02_r8, 0.394583e-02_r8, 0.356655e-02_r8, &
        &  0.322373e-02_r8, 0.291387e-02_r8, 0.263378e-02_r8, 0.238062e-02_r8, 0.215179e-02_r8 /)
     
      end subroutine sw_kgb23

! **************************************************************************
