      subroutine mpi_isend(buf,count,datatype,source,
     & tag,comm,request,ierror)
      integer buf(*), count,datatype,source,tag,comm,
     & request,ierror
      print *, " mpi_isend invoked" 
      call mpi_error()
      return
      end  

      subroutine mpi_irecv(buf,count,datatype,source,
     & tag,comm,request,ierror)
      integer buf(*), count,datatype,source,tag,comm,
     & request,ierror
      print *, " mpi_irecv invoked" 
      call mpi_error()
      return
      end

      subroutine mpi_send(buf,count,datatype,dest,tag,comm,ierror)
      integer buf(*), count,datatype,dest,tag,comm,ierror
      print *, " mpi_send invoked" 
      call mpi_error()
      return
      end
      
      subroutine mpi_recv(buf,count,datatype,source,
     & tag,comm,status,ierror)
      integer buf(*), count,datatype,source,tag,comm,
     & status(*),ierror
      print *, " mpi_recv invoked" 
      call mpi_error()
      return
      end

      subroutine mpi_comm_split(comm,color,key,newcomm,ierror)
      integer comm,color,key,newcomm,ierror
      newcomm=comm
      return
      end

      subroutine mpi_comm_rank(comm, rank,ierr)
      implicit none
      integer comm, rank,ierr
      rank = 0
      return
      end

      subroutine mpi_comm_size(comm, size, ierr)
      implicit none
      integer comm, size, ierr
      size = 1
      return
      end

	subroutine mpi_group_excl(intin,n,ranks,ngroup,ierr)
	integer intin,n,ranks(n),ngroup,ierr
	ngroup=intin
	return
	end

	subroutine mpi_group_free (intin,ierr )
	integer intin,ierr
	return
	end

	subroutine mpi_intercomm_create (lcom,llead,ipeer,irem,itag,
     &			newcom,ierr )
	integer lcom,llead,ipeer,irem,itag,newcom,ierr
	newcom=lcom
	write(6,*) 'shouldnt be calling this!'
	return
	end

	subroutine mpi_comm_create (com,group,ncom,ierr ) 
	integer com,group,ncom,ierr
	ncom=com
	return
	end

	subroutine mpi_comm_group (com,group,ierr )
	integer com,group,ierr
	write(6,*) 'dont want to see this'
	group=com
	return
	end
	

      double precision function mpi_wtime()
      implicit none
      double precision t
      mpi_wtime = 1
      return
      end

      subroutine mpi_barrier(comm,ierror)
      return
      end

      subroutine mpi_bcast(buf, nitems, type, root, comm, ierr)
      implicit none
      integer buf(*), nitems, type, root, comm, ierr
      return
      end

      subroutine mpi_comm_dup(oldcomm, newcomm,ierror)
      integer oldcomm, newcomm,ierror
      newcomm= oldcomm
      return
      end

      subroutine mpi_error()
      print *, 'mpi_error called'
      stop
      end 

      subroutine mpi_abort(comm, errcode, ierr)
      implicit none
      integer comm, errcode, ierr
      print *, 'mpi_abort called'
      stop
      end

      subroutine mpi_finalize(ierr)
      return
      end

      subroutine mpi_init(ierr)
      return
      end


      subroutine mpi_reduce(inbuf, outbuf, nitems, 
     $                      type, op, root, comm, ierr)
      implicit none
      include 'mpif.h'
      integer nitems, type, op, root, comm, ierr
      double precision inbuf(*), outbuf(*)

      if (type .eq. mpi_real8) then
         call mpi_reduce_dp(inbuf, outbuf, nitems, 
     $                      type, op, root, comm, ierr)
      else if (type .eq.  mpi_double_complex) then
         call mpi_reduce_dc(inbuf, outbuf, nitems, 
     $                      type, op, root, comm, ierr)
      else if (type .eq.  mpi_complex) then
         call mpi_reduce_complex(inbuf, outbuf, nitems, 
     $                      type, op, root, comm, ierr)
      else if (type .eq.  mpi_real) then
         call mpi_reduce_real(inbuf, outbuf, nitems, 
     $                      type, op, root, comm, ierr)
      else if (type .eq.  mpi_integer) then
         call mpi_reduce_int(inbuf, outbuf, nitems, 
     $                      type, op, root, comm, ierr)
      else 
         print *, 'mpi_reduce: unknown type ', type
      end if
      return
      end


      subroutine mpi_reduce_real(inbuf, outbuf, nitems, 
     $                      type, op, root, comm, ierr)
      implicit none
      integer nitems, type, op, root, comm, ierr, i
      real inbuf(*), outbuf(*)
      do i = 1, nitems
         outbuf(i) = inbuf(i)
      end do
      
      return
      end

      subroutine mpi_reduce_dp(inbuf, outbuf, nitems, 
     $                      type, op, root, comm, ierr)
      implicit none
      integer nitems, type, op, root, comm, ierr, i
      double precision inbuf(*), outbuf(*)
      do i = 1, nitems
         outbuf(i) = inbuf(i)
      end do
      
      return
      end

      subroutine mpi_reduce_dc(inbuf, outbuf, nitems, 
     $                      type, op, root, comm, ierr)
      implicit none
      integer nitems, type, op, root, comm, ierr, i
      double complex inbuf(*), outbuf(*)
      do i = 1, nitems
         outbuf(i) = inbuf(i)
      end do
      
      return
      end


      subroutine mpi_reduce_complex(inbuf, outbuf, nitems, 
     $                      type, op, root, comm, ierr)
      implicit none
      integer nitems, type, op, root, comm, ierr, i
      complex inbuf(*), outbuf(*)
      do i = 1, nitems
         outbuf(i) = inbuf(i)
      end do
      
      return
      end

      subroutine mpi_reduce_int(inbuf, outbuf, nitems, 
     $                      type, op, root, comm, ierr)
      implicit none
      integer nitems, type, op, root, comm, ierr, i
      integer inbuf(*), outbuf(*)
      do i = 1, nitems
         outbuf(i) = inbuf(i)
      end do
      
      return
      end

      subroutine mpi_allreduce(inbuf, outbuf, nitems, 
     $                      type, op, comm, ierr)
      implicit none
      integer nitems, type, op, comm, ierr
      double precision inbuf(*), outbuf(*)

      call mpi_reduce(inbuf, outbuf, nitems, 
     $                      type, op, 0, comm, ierr)
      return
      end

      subroutine mpi_alltoall(inbuf, nitems, type, outbuf, nitems_dum, 
     $                        type_dum, comm, ierr)
      implicit none
      include 'mpif.h'
      integer nitems, type, comm, ierr, nitems_dum, type_dum
      double precision inbuf(*), outbuf(*)
      if (type .eq. mpi_real8) then
         call mpi_alltoall_dp(inbuf, outbuf, nitems, 
     $                      type, comm, ierr)
      else if (type .eq.  mpi_double_complex) then
         call mpi_alltoall_dc(inbuf, outbuf, nitems, 
     $                      type, comm, ierr)
      else if (type .eq.  mpi_complex) then
         call mpi_alltoall_complex(inbuf, outbuf, nitems, 
     $                      type, comm, ierr)
      else if (type .eq.  mpi_real) then
         call mpi_alltoall_real(inbuf, outbuf, nitems, 
     $                      type, comm, ierr)
      else if (type .eq.  mpi_integer) then
         call mpi_alltoall_int(inbuf, outbuf, nitems, 
     $                      type, comm, ierr)
      else 
         print *, 'mpi_alltoall: unknown type ', type
      end if
      return
      end

      subroutine mpi_alltoall_dc(inbuf, outbuf, nitems, 
     $                           type, comm, ierr)
      implicit none
      integer nitems, type, comm, ierr, i
      double complex inbuf(*), outbuf(*)
      do i = 1, nitems
         outbuf(i) = inbuf(i)
      end do
      
      return
      end


      subroutine mpi_alltoall_complex(inbuf, outbuf, nitems, 
     $                           type, comm, ierr)
      implicit none
      integer nitems, type, comm, ierr, i
      double complex inbuf(*), outbuf(*)
      do i = 1, nitems
         outbuf(i) = inbuf(i)
      end do
      
      return
      end

      subroutine mpi_alltoall_dp(inbuf, outbuf, nitems, 
     $                           type, comm, ierr)
      implicit none
      integer nitems, type, comm, ierr, i
      double precision inbuf(*), outbuf(*)
      do i = 1, nitems
         outbuf(i) = inbuf(i)
      end do
      
      return
      end

      subroutine mpi_alltoall_real(inbuf, outbuf, nitems, 
     $                             type, comm, ierr)
      implicit none
      integer nitems, type, comm, ierr, i
      real inbuf(*), outbuf(*)
      do i = 1, nitems
         outbuf(i) = inbuf(i)
      end do
      
      return
      end

      subroutine mpi_alltoall_int(inbuf, outbuf, nitems, 
     $                            type, comm, ierr)
      implicit none
      integer nitems, type, comm, ierr, i
      integer inbuf(*), outbuf(*)
      do i = 1, nitems
         outbuf(i) = inbuf(i)
      end do
      
      return
      end

      subroutine mpi_wait(request,status,ierror)
      integer request,status,ierror
      return
      end

      subroutine mpi_waitall(count,requests,status,ierror)
      integer count,requests(*),status(*),ierror
      return
      end

CC      three more added 2000/11/14 to deal with MPI post


        subroutine mpi_gatherv(sendbuf,sendcount,sendtype,
     +  recvbuf,recvcounts,displs,recvtype,root,comm,ierr)

        integer sendcount,sendtype,recvcounts(*),displs(*)
        integer recvtype,root,comm,ierr
        print *, " mpi_gatherv invoked" 
        call mpi_error()

        return
        end


        subroutine mpi_sendrecv(sendbuf,sendcount,sendtype,
     +  dest,sendtag,recvbuf,recvcount,recvtype,source,recvtag,
     +  comm,status,ierr)

        integer sendcount,sendtype
        integer dest,sendtag,recvcount
        integer recvtype,source,recvtag,comm,ierr,status(*)
        
	print *, " mpi_sendrecv invoked" 
        call mpi_error()

        return
        end

        subroutine mpi_scatterv(sendbuf,sendcounts,displs,
     +  sendtype,recvbuf,recvcount,recvtype,root,comm,ierr)

        integer sendcounts(*),sendtype,recvcount,displs(*)
        integer recvtype,root,comm,ierr

        print *, " mpi_scatterv invoked" 
        call mpi_error()

        return
        end
	
        Subroutine MPI_Waitany(count, array_of_requests, index, 
     &                        status, ierror) 
           Integer, parameter :: MPI_STATUS_SIZE = 6

!
           Integer count, index, ierror
           Integer array_of_requests (*)
           Integer status (MPI_STATUS_SIZE)
        End Subroutine MPI_Waitany

        Subroutine MPI_Type_commit (datatype, ierror)
           Integer datatype, ierror
        End Subroutine MPI_Type_commit

        Subroutine MPI_Type_free (datatype, ierror)
           Integer  datatype, ierror
        End Subroutine MPI_Type_free

        Subroutine MPI_Type_vector(count, blocklength, stride,         
     &                            oldtype, newtype, ierror) 
           Integer count, blocklength, stride, oldtype, newtype
           Integer ierror
        End Subroutine MPI_Type_vector
!
        Subroutine MPI_Get_processor_name( name, resultlen, ierror)
           Character (len=*) name
           Integer resultlen, ierror
        End Subroutine MPI_Get_processor_name
        subroutine MPI_ALLGATHERV(SENDBUF,SENDCOUNT,SENDTYPE,
     &      RECVBUF,RECVCOUNTS,DISPLS,
     &      RECVTYPE,COMM,IERROR)
        REAL    SENDBUF(*)!is the starting address of the send buffer (choice) (IN)
        INTEGER SENDCOUNT!is the number of elements in the send buffer (integer) (IN)
        INTEGER SENDTYPE !is the datatype of the send buffer elements (handle) (IN)
        REAL    RECVBUF(*)!is the address of the receive buffer (choice) (OUT)
        INTEGER RECVCOUNTS(*)!is the address of the receive buffer (choice) (OUT)
        INTEGER DISPLS(*)!integer array (of length groupsize) that contains the number of elements received from each task (IN)
        INTEGER RECVTYPE!is the datatype of the receive buffer elements (handle) (IN)
        INTEGER COMM!is the communictor (handle) (IN)
        INTEGER IERROR!is the FORTRAN return code. It is always the last argument.
        return
        end
                                                                                                                 427,9         Bot

