!
!  $Author: pkubota $
!  $Date: 2006/10/30 18:37:09 $
!  $Revision: 1.2 $
!
MODULE Conversion

  USE Constants, ONLY : r8

  IMPLICIT NONE

  PRIVATE


  !--(DMK-CCATT-INI)------------------------------------------------------
!  INTEGER, PARAMETER :: nunits=260
!  INTEGER, PARAMETER :: nunits=301
  INTEGER, PARAMETER :: nunits=310
  !--(DMK-CCATT-FIM)------------------------------------------------------

  INTEGER, PARAMETER :: numx=nunits-1
  INTEGER, PARAMETER :: ngrp=nunits/10
  INTEGER, PARAMETER :: ncf=100
  INTEGER, PARAMETER :: ncf2=ncf/2
  INTEGER, PARAMETER :: ngrmx=ngrp-1

  REAL (KIND=r8) :: cnfac(ncf)
  REAL (KIND=r8) :: cnfac2(ncf2)

  INTEGER :: looku(0:9,0:9,0:ngrmx)

  CHARACTER (LEN=16) :: aunits(-1:numx)

  PUBLIC :: CreateConversion, GiveUnit, cnvout

CONTAINS

  SUBROUTINE CreateConversion()

    aunits( -1: -1) = 'Unknown         '
    aunits(  0:  9) = (/ &
      'No Dim          ','%               ','Gm/Kg           ','Ppm             ','Unset           ', &
      'Unset           ','Unset           ','Unset           ','Unset           ','Unset           ' /)
    aunits( 10: 19) = (/ &
      'M               ','Cm              ','Unset           ','Unset           ','Unset           ', &
      'Unset           ','Unset           ','Unset           ','Unset           ','Unset           ' /)
    aunits( 20: 29) = (/ &
      'Kg              ','Gm              ','Unset           ','Unset           ','Unset           ', &
      'Unset           ','Unset           ','Unset           ','Unset           ','Unset           ' /)
    aunits( 30: 39) = (/ &
      'Sec             ','Days            ','Yrs             ','Unset           ','Unset           ', &
      'Unset           ','Unset           ','Unset           ','Unset           ','Unset           ' /)
    aunits( 40: 49) = (/ &
      'K               ','C               ','F               ','Unset           ','Unset           ', &
      'Unset           ','Unset           ','Unset           ','Unset           ','Unset           ' /)
    aunits( 50: 59) = (/ &
      '1/Sec           ','1/Day           ','Gm/Kg/Day       ','10**-5 1/Sec    ','10**-6 1/Sec    ', &
      'Unset           ','Unset           ','Unset           ','Unset           ','Unset           ' /)
    aunits( 60: 69) = (/ &
      'M/Sec           ','Unset           ','Unset           ','Unset           ','Unset           ', &
      'Unset           ','Unset           ','Unset           ','Unset           ','Unset           ' /)
    aunits( 70: 79) = (/ &
      'K/Sec           ','K/Day           ','Unset           ','Unset           ','Unset           ', &
      'Unset           ','Unset           ','Unset           ','Unset           ','Unset           ' /)
    aunits( 80: 89) = (/ &
      'Sec**-2         ','1/Sec/Day       ','Unset           ','Unset           ','Unset           ', &
      'Unset           ','Unset           ','Unset           ','Unset           ','Unset           ' /)
    aunits( 90: 99) = (/ &
      'M**2/Sec        ','10**6 M**2/Sec  ','Unset           ','Unset           ','Unset           ', &
      'Unset           ','Unset           ','Unset           ','Unset           ','Unset           ' /)
    aunits(100:109) = (/ &
      'M Sec**-2       ','M/Sec/Day       ','Unset           ','Unset           ','Unset           ', &
      'Unset           ','Unset           ','Unset           ','Unset           ','Unset           ' /)
    aunits(110:119) = (/ &
      'Kg M**-2        ','Unset           ','Unset           ','Unset           ','Unset           ', &
      'Unset           ','Unset           ','Unset           ','Unset           ','Unset           ' /)
    aunits(120:129) = (/ &
      'Kg M**-2 Sec**-1','Kg M**-2 Day**-1','Unset           ','Unset           ','Unset           ', &
      'Unset           ','Unset           ','Unset           ','Unset           ','Unset           ' /)
    aunits(130:139) = (/ &
      'Pa              ','Mb              ','Cb              ','Dynes Cm**-2    ','Mb-1000         ', &
      'Unset           ','Unset           ','Unset           ','Unset           ','Unset           ' /)
    aunits(140:149) = (/ &
      'Ln(Pa)          ','Ln(Mb)          ','Ln(Cb)          ','Unset           ','Unset           ', &
      'Unset           ','Unset           ','Unset           ','Unset           ','Unset           ' /)
    aunits(150:159) = (/ &
      'Pa/Sec          ','Mb/Sec          ','Mb/Day          ','Cb/Sec          ','Unset           ', &
      'Unset           ','Unset           ','Unset           ','Unset           ','Unset           ' /)
    aunits(160:169) = (/ &
      'Log(Pa)/Sec     ','Log(Mb)/Sec     ','Log(Cb)/Sec     ','Unset           ','Unset           ', &
      'Unset           ','Unset           ','Unset           ','Unset           ','Unset           ' /)
    aunits(170:179) = (/ &
      'W M**-2         ','Unset           ','Unset           ','Unset           ','Unset           ', &
      'Unset           ','Unset           ','Unset           ','Unset           ','Unset           ' /)
    aunits(180:189) = (/ &
      'M**2 Sec**-2    ','Unset           ','Unset           ','Unset           ','Unset           ', &
      'Unset           ','Unset           ','Unset           ','Unset           ','Unset           ' /)
    aunits(190:199) = (/ &
      'Sec/M           ','Unset           ','Unset           ','Unset           ','Unset           ', &
      'Unset           ','Unset           ','Unset           ','Unset           ','Unset           ' /)
    aunits(200:209) = (/ &
      'Kg M**-3        ','g M**-3         ','Unset           ','Unset           ','Unset           ', &
      'Unset           ','Unset           ','Unset           ','Unset           ','Unset           ' /)
    aunits(210:219) = (/ &
      'Kg M**-1 Sec**-1','Kg M**-1 Day**-1','Unset           ','Unset           ','Unset           ', &
      'Unset           ','Unset           ','Unset           ','Unset           ','Unset           ' /)
    aunits(220:229) = (/ &
      'Kg Sec**-1      ','10**9 Kg Sec**-1','Unset           ','Unset           ','Unset           ', &
      'Unset           ','Unset           ','Unset           ','Unset           ','Unset           ' /)
    aunits(230:239) = (/ &
      'K M Sec**-1     ','Unset           ','Unset           ','Unset           ','Unset           ', &
      'Unset           ','Unset           ','Unset           ','Unset           ','Unset           ' /)
    aunits(240:249) = (/ &
      'K Pa Sec**-1    ','K Mb Sec**-1    ','K Cb Sec**-1    ','Unset           ','Unset           ', &
      'Unset           ','Unset           ','Unset           ','Unset           ','Unset           ' /)
    aunits(250:259) = (/ &
      'M Pa Sec**-2    ','M Mb Sec**-2    ','M Cb Sec**-2    ','Unset           ','Unset           ', &
      'Unset           ','Unset           ','Unset           ','Unset           ','Unset           ' /)

    aunits(260:269) = (/ &
      'kg_C/m**2       ','kg_N m-2        ','kg_h2o          ','Unset           ','Unset           ', &
      'Unset           ','Unset           ','Unset           ','Unset           ','Unset           ' /)

    aunits(270:279) = (/ &
      'kg_C/m**2/yr    ','kg_C/m**2/month ','Unset           ','Unset           ','Unset           ', &
      'Unset           ','Unset           ','Unset           ','Unset           ','Unset           ' /)
 
    aunits(280:289) = (/ &
      'mol_CO2/m**2/Sec','mol_CO2/mol_AIR ','Unset           ','Unset           ','Unset           ', &
      'Unset           ','Unset           ','Unset           ','Unset           ','Unset           ' /)

  !--(DMK-CCATT-INI)------------------------------------------------------
    aunits(290:299) = (/ &
      'ppbv            ','Unset           ','Unset           ','Unset           ','Unset           ', &
      'Unset           ','Unset           ','Unset           ','Unset           ','Unset           ' /)
  !--(DMK-CCATT-FIM)------------------------------------------------------
  !--(DMK-CCATT-INI)------------------------------------------------------
    aunits(300:309) = (/ &
      'Degrees         ','Rad             ','Unset           ','Unset           ','Unset           ', &
      'Unset           ','Unset           ','Unset           ','Unset           ','Unset           ' /)
  !--(DMK-CCATT-FIM)------------------------------------------------------

    looku (:, 0, 0) = (/  51, 52, 54, 58,  0,  0,  0,  0,  0,  0 /)
    looku (:, 1, 0) = (/  53, 51, 56, 60,  0,  0,  0,  0,  0,  0 /)
    looku (:, 2, 0) = (/  55, 57, 51, 54,  0,  0,  0,  0,  0,  0 /)
    looku (:, 3, 0) = (/  59, 61, 55, 51,  0,  0,  0,  0,  0,  0 /)
    looku (:, 4, 0) = (/   0,  0,  0,  0, 51,  0,  0,  0,  0,  0 /)
    looku (:, 5, 0) = (/   0,  0,  0,  0,  0, 51,  0,  0,  0,  0 /)
    looku (:, 6, 0) = (/   0,  0,  0,  0,  0,  0, 51,  0,  0,  0 /)
    looku (:, 7, 0) = (/   0,  0,  0,  0,  0,  0,  0, 51,  0,  0 /)
    looku (:, 8, 0) = (/   0,  0,  0,  0,  0,  0,  0,  0, 51,  0 /)
    looku (:, 9, 0) = (/   0,  0,  0,  0,  0,  0,  0,  0,  0, 51 /)

    looku (:, 0, 1) = (/  51, 52,  0,  0,  0,  0,  0,  0,  0,  0 /)
    looku (:, 1, 1) = (/  53, 51,  0,  0,  0,  0,  0,  0,  0,  0 /)
    looku (:, 2, 1) = (/   0,  0, 51,  0,  0,  0,  0,  0,  0,  0 /)
    looku (:, 3, 1) = (/   0,  0,  0, 51,  0,  0,  0,  0,  0,  0 /)
    looku (:, 4, 1) = (/   0,  0,  0,  0, 51,  0,  0,  0,  0,  0 /)
    looku (:, 5, 1) = (/   0,  0,  0,  0,  0, 51,  0,  0,  0,  0 /)
    looku (:, 6, 1) = (/   0,  0,  0,  0,  0,  0, 51,  0,  0,  0 /)
    looku (:, 7, 1) = (/   0,  0,  0,  0,  0,  0,  0, 51,  0,  0 /)
    looku (:, 8, 1) = (/   0,  0,  0,  0,  0,  0,  0,  0, 51,  0 /)
    looku (:, 9, 1) = (/   0,  0,  0,  0,  0,  0,  0,  0,  0, 51 /)

    looku (:, 0, 2) = (/  51, 54,  0,  0,  0,  0,  0,  0,  0,  0 /)
    looku (:, 1, 2) = (/  55, 51,  0,  0,  0,  0,  0,  0,  0,  0 /)
    looku (:, 2, 2) = (/   0,  0, 51,  0,  0,  0,  0,  0,  0,  0 /)
    looku (:, 3, 2) = (/   0,  0,  0, 51,  0,  0,  0,  0,  0,  0 /)
    looku (:, 4, 2) = (/   0,  0,  0,  0, 51,  0,  0,  0,  0,  0 /)
    looku (:, 5, 2) = (/   0,  0,  0,  0,  0, 51,  0,  0,  0,  0 /)
    looku (:, 6, 2) = (/   0,  0,  0,  0,  0,  0, 51,  0,  0,  0 /)
    looku (:, 7, 2) = (/   0,  0,  0,  0,  0,  0,  0, 51,  0,  0 /)
    looku (:, 8, 2) = (/   0,  0,  0,  0,  0,  0,  0,  0, 51,  0 /)
    looku (:, 9, 2) = (/   0,  0,  0,  0,  0,  0,  0,  0,  0, 51 /)

    looku (:, 0, 3) = (/  51, 62, 64,  0,  0,  0,  0,  0,  0,  0 /)
    looku (:, 1, 3) = (/  63, 51, 66,  0,  0,  0,  0,  0,  0,  0 /)
    looku (:, 2, 3) = (/  65, 67, 51,  0,  0,  0,  0,  0,  0,  0 /)
    looku (:, 3, 3) = (/   0,  0,  0, 51,  0,  0,  0,  0,  0,  0 /)
    looku (:, 4, 3) = (/   0,  0,  0,  0, 51,  0,  0,  0,  0,  0 /)
    looku (:, 5, 3) = (/   0,  0,  0,  0,  0, 51,  0,  0,  0,  0 /)
    looku (:, 6, 3) = (/   0,  0,  0,  0,  0,  0, 51,  0,  0,  0 /)
    looku (:, 7, 3) = (/   0,  0,  0,  0,  0,  0,  0, 51,  0,  0 /)
    looku (:, 8, 3) = (/   0,  0,  0,  0,  0,  0,  0,  0, 51,  0 /)
    looku (:, 9, 3) = (/   0,  0,  0,  0,  0,  0,  0,  0,  0, 51 /)

    looku (:, 0, 4) = (/  51,  1,  9,  0,  0,  0,  0,  0,  0,  0 /)
    looku (:, 1, 4) = (/   2, 51, 11,  0,  0,  0,  0,  0,  0,  0 /)
    looku (:, 2, 4) = (/  10, 12, 51,  0,  0,  0,  0,  0,  0,  0 /)
    looku (:, 3, 4) = (/   0,  0,  0, 51,  0,  0,  0,  0,  0,  0 /)
    looku (:, 4, 4) = (/   0,  0,  0,  0, 51,  0,  0,  0,  0,  0 /)
    looku (:, 5, 4) = (/   0,  0,  0,  0,  0, 51,  0,  0,  0,  0 /)
    looku (:, 6, 4) = (/   0,  0,  0,  0,  0,  0, 51,  0,  0,  0 /)
    looku (:, 7, 4) = (/   0,  0,  0,  0,  0,  0,  0, 51,  0,  0 /)
    looku (:, 8, 4) = (/   0,  0,  0,  0,  0,  0,  0,  0, 51,  0 /)
    looku (:, 9, 4) = (/   0,  0,  0,  0,  0,  0,  0,  0,  0, 51 /)

    looku (:, 0, 5) = (/  51, 63, 69, 70, 58,  0,  0,  0,  0,  0 /)
    looku (:, 1, 5) = (/  62, 51, 54, 72, 76,  0,  0,  0,  0,  0 /)
    looku (:, 2, 5) = (/  68, 55, 51, 74, 78,  0,  0,  0,  0,  0 /)
    looku (:, 3, 5) = (/  71, 73, 75, 51, 56,  0,  0,  0,  0,  0 /)
    looku (:, 4, 5) = (/  59, 77, 79, 57, 51,  0,  0,  0,  0,  0 /)
    looku (:, 5, 5) = (/   0,  0,  0,  0,  0, 51,  0,  0,  0,  0 /)
    looku (:, 6, 5) = (/   0,  0,  0,  0,  0,  0, 51,  0,  0,  0 /)
    looku (:, 7, 5) = (/   0,  0,  0,  0,  0,  0,  0, 51,  0,  0 /)
    looku (:, 8, 5) = (/   0,  0,  0,  0,  0,  0,  0,  0, 51,  0 /)
    looku (:, 9, 5) = (/   0,  0,  0,  0,  0,  0,  0,  0,  0, 51 /)

    looku (:, 0, 6) = (/  51,  0,  0,  0,  0,  0,  0,  0,  0,  0 /)
    looku (:, 1, 6) = (/   0, 51,  0,  0,  0,  0,  0,  0,  0,  0 /)
    looku (:, 2, 6) = (/   0,  0, 51,  0,  0,  0,  0,  0,  0,  0 /)
    looku (:, 3, 6) = (/   0,  0,  0, 51,  0,  0,  0,  0,  0,  0 /)
    looku (:, 4, 6) = (/   0,  0,  0,  0, 51,  0,  0,  0,  0,  0 /)
    looku (:, 5, 6) = (/   0,  0,  0,  0,  0, 51,  0,  0,  0,  0 /)
    looku (:, 6, 6) = (/   0,  0,  0,  0,  0,  0, 51,  0,  0,  0 /)
    looku (:, 7, 6) = (/   0,  0,  0,  0,  0,  0,  0, 51,  0,  0 /)
    looku (:, 8, 6) = (/   0,  0,  0,  0,  0,  0,  0,  0, 51,  0 /)
    looku (:, 9, 6) = (/   0,  0,  0,  0,  0,  0,  0,  0,  0, 51 /)

    looku (:, 0, 7) = (/  51, 63,  0,  0,  0,  0,  0,  0,  0,  0 /)
    looku (:, 1, 7) = (/  62, 51,  0,  0,  0,  0,  0,  0,  0,  0 /)
    looku (:, 2, 7) = (/   0,  0, 51,  0,  0,  0,  0,  0,  0,  0 /)
    looku (:, 3, 7) = (/   0,  0,  0, 51,  0,  0,  0,  0,  0,  0 /)
    looku (:, 4, 7) = (/   0,  0,  0,  0, 51,  0,  0,  0,  0,  0 /)
    looku (:, 5, 7) = (/   0,  0,  0,  0,  0, 51,  0,  0,  0,  0 /)
    looku (:, 6, 7) = (/   0,  0,  0,  0,  0,  0, 51,  0,  0,  0 /)
    looku (:, 7, 7) = (/   0,  0,  0,  0,  0,  0,  0, 51,  0,  0 /)
    looku (:, 8, 7) = (/   0,  0,  0,  0,  0,  0,  0,  0, 51,  0 /)
    looku (:, 9, 7) = (/   0,  0,  0,  0,  0,  0,  0,  0,  0, 51 /)

    looku (:, 0, 8) = (/  51, 63,  0,  0,  0,  0,  0,  0,  0,  0 /)
    looku (:, 1, 8) = (/  62, 51,  0,  0,  0,  0,  0,  0,  0,  0 /)
    looku (:, 2, 8) = (/   0,  0, 51,  0,  0,  0,  0,  0,  0,  0 /)
    looku (:, 3, 8) = (/   0,  0,  0, 51,  0,  0,  0,  0,  0,  0 /)
    looku (:, 4, 8) = (/   0,  0,  0,  0, 51,  0,  0,  0,  0,  0 /)
    looku (:, 5, 8) = (/   0,  0,  0,  0,  0, 51,  0,  0,  0,  0 /)
    looku (:, 6, 8) = (/   0,  0,  0,  0,  0,  0, 51,  0,  0,  0 /)
    looku (:, 7, 8) = (/   0,  0,  0,  0,  0,  0,  0, 51,  0,  0 /)
    looku (:, 8, 8) = (/   0,  0,  0,  0,  0,  0,  0,  0, 51,  0 /)
    looku (:, 9, 8) = (/   0,  0,  0,  0,  0,  0,  0,  0,  0, 51 /)

    looku (:, 0, 9) = (/  51, 59,  0,  0,  0,  0,  0,  0,  0,  0 /)
    looku (:, 1, 9) = (/  58, 51,  0,  0,  0,  0,  0,  0,  0,  0 /)
    looku (:, 2, 9) = (/   0,  0, 51,  0,  0,  0,  0,  0,  0,  0 /)
    looku (:, 3, 9) = (/   0,  0,  0, 51,  0,  0,  0,  0,  0,  0 /)
    looku (:, 4, 9) = (/   0,  0,  0,  0, 51,  0,  0,  0,  0,  0 /)
    looku (:, 5, 9) = (/   0,  0,  0,  0,  0, 51,  0,  0,  0,  0 /)
    looku (:, 6, 9) = (/   0,  0,  0,  0,  0,  0, 51,  0,  0,  0 /)
    looku (:, 7, 9) = (/   0,  0,  0,  0,  0,  0,  0, 51,  0,  0 /)
    looku (:, 8, 9) = (/   0,  0,  0,  0,  0,  0,  0,  0, 51,  0 /)
    looku (:, 9, 9) = (/   0,  0,  0,  0,  0,  0,  0,  0,  0, 51 /)

    looku (:, 0,10) = (/  51, 63,  0,  0,  0,  0,  0,  0,  0,  0 /)
    looku (:, 1,10) = (/  62, 51,  0,  0,  0,  0,  0,  0,  0,  0 /)
    looku (:, 2,10) = (/   0,  0, 51,  0,  0,  0,  0,  0,  0,  0 /)
    looku (:, 3,10) = (/   0,  0,  0, 51,  0,  0,  0,  0,  0,  0 /)
    looku (:, 4,10) = (/   0,  0,  0,  0, 51,  0,  0,  0,  0,  0 /)
    looku (:, 5,10) = (/   0,  0,  0,  0,  0, 51,  0,  0,  0,  0 /)
    looku (:, 6,10) = (/   0,  0,  0,  0,  0,  0, 51,  0,  0,  0 /)
    looku (:, 7,10) = (/   0,  0,  0,  0,  0,  0,  0, 51,  0,  0 /)
    looku (:, 8,10) = (/   0,  0,  0,  0,  0,  0,  0,  0, 51,  0 /)
    looku (:, 9,10) = (/   0,  0,  0,  0,  0,  0,  0,  0,  0, 51 /)

    looku (:, 0,11) = (/  51,  0,  0,  0,  0,  0,  0,  0,  0,  0 /)
    looku (:, 1,11) = (/   0, 51,  0,  0,  0,  0,  0,  0,  0,  0 /)
    looku (:, 2,11) = (/   0,  0, 51,  0,  0,  0,  0,  0,  0,  0 /)
    looku (:, 3,11) = (/   0,  0,  0, 51,  0,  0,  0,  0,  0,  0 /)
    looku (:, 4,11) = (/   0,  0,  0,  0, 51,  0,  0,  0,  0,  0 /)
    looku (:, 5,11) = (/   0,  0,  0,  0,  0, 51,  0,  0,  0,  0 /)
    looku (:, 6,11) = (/   0,  0,  0,  0,  0,  0, 51,  0,  0,  0 /)
    looku (:, 7,11) = (/   0,  0,  0,  0,  0,  0,  0, 51,  0,  0 /)
    looku (:, 8,11) = (/   0,  0,  0,  0,  0,  0,  0,  0, 51,  0 /)
    looku (:, 9,11) = (/   0,  0,  0,  0,  0,  0,  0,  0,  0, 51 /)

    looku (:, 0,12) = (/  51, 63,  0,  0,  0,  0,  0,  0,  0,  0 /)
    looku (:, 1,12) = (/  62, 51,  0,  0,  0,  0,  0,  0,  0,  0 /)
    looku (:, 2,12) = (/   0,  0, 51,  0,  0,  0,  0,  0,  0,  0 /)
    looku (:, 3,12) = (/   0,  0,  0, 51,  0,  0,  0,  0,  0,  0 /)
    looku (:, 4,12) = (/   0,  0,  0,  0, 51,  0,  0,  0,  0,  0 /)
    looku (:, 5,12) = (/   0,  0,  0,  0,  0, 51,  0,  0,  0,  0 /)
    looku (:, 6,12) = (/   0,  0,  0,  0,  0,  0, 51,  0,  0,  0 /)
    looku (:, 7,12) = (/   0,  0,  0,  0,  0,  0,  0, 51,  0,  0 /)
    looku (:, 8,12) = (/   0,  0,  0,  0,  0,  0,  0,  0, 51,  0 /)
    looku (:, 9,12) = (/   0,  0,  0,  0,  0,  0,  0,  0,  0, 51 /)

    looku (:, 0,13) = (/  51, 53, 55, 56, 13,  0,  0,  0,  0,  0 /)
    looku (:, 1,13) = (/  52, 51, 57, 54, 15,  0,  0,  0,  0,  0 /)
    looku (:, 2,13) = (/  54, 56, 51, 60, 17,  0,  0,  0,  0,  0 /)
    looku (:, 3,13) = (/  57, 55, 61, 51, 19,  0,  0,  0,  0,  0 /)
    looku (:, 4,13) = (/  14, 16, 18, 20, 51,  0,  0,  0,  0,  0 /)
    looku (:, 5,13) = (/   0,  0,  0,  0,  0, 51,  0,  0,  0,  0 /)
    looku (:, 6,13) = (/   0,  0,  0,  0,  0,  0, 51,  0,  0,  0 /)
    looku (:, 7,13) = (/   0,  0,  0,  0,  0,  0,  0, 51,  0,  0 /)
    looku (:, 8,13) = (/   0,  0,  0,  0,  0,  0,  0,  0, 51,  0 /)
    looku (:, 9,13) = (/   0,  0,  0,  0,  0,  0,  0,  0,  0, 51 /)

    looku (:, 0,14) = (/  51,  3,  5,  0,  0,  0,  0,  0,  0,  0 /)
    looku (:, 1,14) = (/   4, 51,  7,  0,  0,  0,  0,  0,  0,  0 /)
    looku (:, 2,14) = (/   6,  8, 51,  0,  0,  0,  0,  0,  0,  0 /)
    looku (:, 3,14) = (/   0,  0,  0, 51,  0,  0,  0,  0,  0,  0 /)
    looku (:, 4,14) = (/   0,  0,  0,  0, 51,  0,  0,  0,  0,  0 /)
    looku (:, 5,14) = (/   0,  0,  0,  0,  0, 51,  0,  0,  0,  0 /)
    looku (:, 6,14) = (/   0,  0,  0,  0,  0,  0, 51,  0,  0,  0 /)
    looku (:, 7,14) = (/   0,  0,  0,  0,  0,  0,  0, 51,  0,  0 /)
    looku (:, 8,14) = (/   0,  0,  0,  0,  0,  0,  0,  0, 51,  0 /)
    looku (:, 9,14) = (/   0,  0,  0,  0,  0,  0,  0,  0,  0, 51 /)

    looku (:, 0,15) = (/  51, 53, 75, 55,  0,  0,  0,  0,  0,  0 /)
    looku (:, 1,15) = (/  52, 51, 63, 57,  0,  0,  0,  0,  0,  0 /)
    looku (:, 2,15) = (/  74, 62, 51, 80,  0,  0,  0,  0,  0,  0 /)
    looku (:, 3,15) = (/  54, 56, 81, 51,  0,  0,  0,  0,  0,  0 /)
    looku (:, 4,15) = (/   0,  0,  0,  0, 51,  0,  0,  0,  0,  0 /)
    looku (:, 5,15) = (/   0,  0,  0,  0,  0, 51,  0,  0,  0,  0 /)
    looku (:, 6,15) = (/   0,  0,  0,  0,  0,  0, 51,  0,  0,  0 /)
    looku (:, 7,15) = (/   0,  0,  0,  0,  0,  0,  0, 51,  0,  0 /)
    looku (:, 8,15) = (/   0,  0,  0,  0,  0,  0,  0,  0, 51,  0 /)
    looku (:, 9,15) = (/   0,  0,  0,  0,  0,  0,  0,  0,  0, 51 /)

    looku (:, 0,16) = (/  51,  3,  5,  0,  0,  0,  0,  0,  0,  0 /)
    looku (:, 1,16) = (/   4, 51,  7,  0,  0,  0,  0,  0,  0,  0 /)
    looku (:, 2,16) = (/   6,  8, 51,  0,  0,  0,  0,  0,  0,  0 /)
    looku (:, 3,16) = (/   0,  0,  0, 51,  0,  0,  0,  0,  0,  0 /)
    looku (:, 4,16) = (/   0,  0,  0,  0, 51,  0,  0,  0,  0,  0 /)
    looku (:, 5,16) = (/   0,  0,  0,  0,  0, 51,  0,  0,  0,  0 /)
    looku (:, 6,16) = (/   0,  0,  0,  0,  0,  0, 51,  0,  0,  0 /)
    looku (:, 7,16) = (/   0,  0,  0,  0,  0,  0,  0, 51,  0,  0 /)
    looku (:, 8,16) = (/   0,  0,  0,  0,  0,  0,  0,  0, 51,  0 /)
    looku (:, 9,16) = (/   0,  0,  0,  0,  0,  0,  0,  0,  0, 51 /)

    looku (:, 0,17) = (/  51,  0,  0,  0,  0,  0,  0,  0,  0,  0 /)
    looku (:, 1,17) = (/   0, 51,  0,  0,  0,  0,  0,  0,  0,  0 /)
    looku (:, 2,17) = (/   0,  0, 51,  0,  0,  0,  0,  0,  0,  0 /)
    looku (:, 3,17) = (/   0,  0,  0, 51,  0,  0,  0,  0,  0,  0 /)
    looku (:, 4,17) = (/   0,  0,  0,  0, 51,  0,  0,  0,  0,  0 /)
    looku (:, 5,17) = (/   0,  0,  0,  0,  0, 51,  0,  0,  0,  0 /)
    looku (:, 6,17) = (/   0,  0,  0,  0,  0,  0, 51,  0,  0,  0 /)
    looku (:, 7,17) = (/   0,  0,  0,  0,  0,  0,  0, 51,  0,  0 /)
    looku (:, 8,17) = (/   0,  0,  0,  0,  0,  0,  0,  0, 51,  0 /)
    looku (:, 9,17) = (/   0,  0,  0,  0,  0,  0,  0,  0,  0, 51 /)

    looku (:, 0,18) = (/  51,  0,  0,  0,  0,  0,  0,  0,  0,  0 /)
    looku (:, 1,18) = (/   0, 51,  0,  0,  0,  0,  0,  0,  0,  0 /)
    looku (:, 2,18) = (/   0,  0, 51,  0,  0,  0,  0,  0,  0,  0 /)
    looku (:, 3,18) = (/   0,  0,  0, 51,  0,  0,  0,  0,  0,  0 /)
    looku (:, 4,18) = (/   0,  0,  0,  0, 51,  0,  0,  0,  0,  0 /)
    looku (:, 5,18) = (/   0,  0,  0,  0,  0, 51,  0,  0,  0,  0 /)
    looku (:, 6,18) = (/   0,  0,  0,  0,  0,  0, 51,  0,  0,  0 /)
    looku (:, 7,18) = (/   0,  0,  0,  0,  0,  0,  0, 51,  0,  0 /)
    looku (:, 8,18) = (/   0,  0,  0,  0,  0,  0,  0,  0, 51,  0 /)
    looku (:, 9,18) = (/   0,  0,  0,  0,  0,  0,  0,  0,  0, 51 /)

    looku (:, 0,19) = (/  51,  0,  0,  0,  0,  0,  0,  0,  0,  0 /)
    looku (:, 1,19) = (/   0, 51,  0,  0,  0,  0,  0,  0,  0,  0 /)
    looku (:, 2,19) = (/   0,  0, 51,  0,  0,  0,  0,  0,  0,  0 /)
    looku (:, 3,19) = (/   0,  0,  0, 51,  0,  0,  0,  0,  0,  0 /)
    looku (:, 4,19) = (/   0,  0,  0,  0, 51,  0,  0,  0,  0,  0 /)
    looku (:, 5,19) = (/   0,  0,  0,  0,  0, 51,  0,  0,  0,  0 /)
    looku (:, 6,19) = (/   0,  0,  0,  0,  0,  0, 51,  0,  0,  0 /)
    looku (:, 7,19) = (/   0,  0,  0,  0,  0,  0,  0, 51,  0,  0 /)
    looku (:, 8,19) = (/   0,  0,  0,  0,  0,  0,  0,  0, 51,  0 /)
    looku (:, 9,19) = (/   0,  0,  0,  0,  0,  0,  0,  0,  0, 51 /)

    looku (:, 0,20) = (/  51,  0,  0,  0,  0,  0,  0,  0,  0,  0 /)
    looku (:, 1,20) = (/   0, 51,  0,  0,  0,  0,  0,  0,  0,  0 /)
    looku (:, 2,20) = (/   0,  0, 51,  0,  0,  0,  0,  0,  0,  0 /)
    looku (:, 3,20) = (/   0,  0,  0, 51,  0,  0,  0,  0,  0,  0 /)
    looku (:, 4,20) = (/   0,  0,  0,  0, 51,  0,  0,  0,  0,  0 /)
    looku (:, 5,20) = (/   0,  0,  0,  0,  0, 51,  0,  0,  0,  0 /)
    looku (:, 6,20) = (/   0,  0,  0,  0,  0,  0, 51,  0,  0,  0 /)
    looku (:, 7,20) = (/   0,  0,  0,  0,  0,  0,  0, 51,  0,  0 /)
    looku (:, 8,20) = (/   0,  0,  0,  0,  0,  0,  0,  0, 51,  0 /)
    looku (:, 9,20) = (/   0,  0,  0,  0,  0,  0,  0,  0,  0, 51 /)

    looku (:, 0,21) = (/  51, 63,  0,  0,  0,  0,  0,  0,  0,  0 /)
    looku (:, 1,21) = (/  62, 51,  0,  0,  0,  0,  0,  0,  0,  0 /)
    looku (:, 2,21) = (/   0,  0, 51,  0,  0,  0,  0,  0,  0,  0 /)
    looku (:, 3,21) = (/   0,  0,  0, 51,  0,  0,  0,  0,  0,  0 /)
    looku (:, 4,21) = (/   0,  0,  0,  0, 51,  0,  0,  0,  0,  0 /)
    looku (:, 5,21) = (/   0,  0,  0,  0,  0, 51,  0,  0,  0,  0 /)
    looku (:, 6,21) = (/   0,  0,  0,  0,  0,  0, 51,  0,  0,  0 /)
    looku (:, 7,21) = (/   0,  0,  0,  0,  0,  0,  0, 51,  0,  0 /)
    looku (:, 8,21) = (/   0,  0,  0,  0,  0,  0,  0,  0, 51,  0 /)
    looku (:, 9,21) = (/   0,  0,  0,  0,  0,  0,  0,  0,  0, 51 /)

    looku (:, 0,22) = (/  51, 82,  0,  0,  0,  0,  0,  0,  0,  0 /)
    looku (:, 1,22) = (/  83, 51,  0,  0,  0,  0,  0,  0,  0,  0 /)
    looku (:, 2,22) = (/   0,  0, 51,  0,  0,  0,  0,  0,  0,  0 /)
    looku (:, 3,22) = (/   0,  0,  0, 51,  0,  0,  0,  0,  0,  0 /)
    looku (:, 4,22) = (/   0,  0,  0,  0, 51,  0,  0,  0,  0,  0 /)
    looku (:, 5,22) = (/   0,  0,  0,  0,  0, 51,  0,  0,  0,  0 /)
    looku (:, 6,22) = (/   0,  0,  0,  0,  0,  0, 51,  0,  0,  0 /)
    looku (:, 7,22) = (/   0,  0,  0,  0,  0,  0,  0, 51,  0,  0 /)
    looku (:, 8,22) = (/   0,  0,  0,  0,  0,  0,  0,  0, 51,  0 /)
    looku (:, 9,22) = (/   0,  0,  0,  0,  0,  0,  0,  0,  0, 51 /)

    looku (:, 0,23) = (/  51,  0,  0,  0,  0,  0,  0,  0,  0,  0 /)
    looku (:, 1,23) = (/   0, 51,  0,  0,  0,  0,  0,  0,  0,  0 /)
    looku (:, 2,23) = (/   0,  0, 51,  0,  0,  0,  0,  0,  0,  0 /)
    looku (:, 3,23) = (/   0,  0,  0, 51,  0,  0,  0,  0,  0,  0 /)
    looku (:, 4,23) = (/   0,  0,  0,  0, 51,  0,  0,  0,  0,  0 /)
    looku (:, 5,23) = (/   0,  0,  0,  0,  0, 51,  0,  0,  0,  0 /)
    looku (:, 6,23) = (/   0,  0,  0,  0,  0,  0, 51,  0,  0,  0 /)
    looku (:, 7,23) = (/   0,  0,  0,  0,  0,  0,  0, 51,  0,  0 /)
    looku (:, 8,23) = (/   0,  0,  0,  0,  0,  0,  0,  0, 51,  0 /)
    looku (:, 9,23) = (/   0,  0,  0,  0,  0,  0,  0,  0,  0, 51 /)

    looku (:, 0,24) = (/  51, 53, 55,  0,  0,  0,  0,  0,  0,  0 /)
    looku (:, 1,24) = (/  52, 51, 57,  0,  0,  0,  0,  0,  0,  0 /)
    looku (:, 2,24) = (/  54, 56, 51,  0,  0,  0,  0,  0,  0,  0 /)
    looku (:, 3,24) = (/   0,  0,  0, 51,  0,  0,  0,  0,  0,  0 /)
    looku (:, 4,24) = (/   0,  0,  0,  0, 51,  0,  0,  0,  0,  0 /)
    looku (:, 5,24) = (/   0,  0,  0,  0,  0, 51,  0,  0,  0,  0 /)
    looku (:, 6,24) = (/   0,  0,  0,  0,  0,  0, 51,  0,  0,  0 /)
    looku (:, 7,24) = (/   0,  0,  0,  0,  0,  0,  0, 51,  0,  0 /)
    looku (:, 8,24) = (/   0,  0,  0,  0,  0,  0,  0,  0, 51,  0 /)
    looku (:, 9,24) = (/   0,  0,  0,  0,  0,  0,  0,  0,  0, 51 /)

    looku (:, 0,25) = (/  51, 53, 55,  0,  0,  0,  0,  0,  0,  0 /)
    looku (:, 1,25) = (/  52, 51, 57,  0,  0,  0,  0,  0,  0,  0 /)
    looku (:, 2,25) = (/  54, 56, 51,  0,  0,  0,  0,  0,  0,  0 /)
    looku (:, 3,25) = (/   0,  0,  0, 51,  0,  0,  0,  0,  0,  0 /)
    looku (:, 4,25) = (/   0,  0,  0,  0, 51,  0,  0,  0,  0,  0 /)
    looku (:, 5,25) = (/   0,  0,  0,  0,  0, 51,  0,  0,  0,  0 /)
    looku (:, 6,25) = (/   0,  0,  0,  0,  0,  0, 51,  0,  0,  0 /)
    looku (:, 7,25) = (/   0,  0,  0,  0,  0,  0,  0, 51,  0,  0 /)
    looku (:, 8,25) = (/   0,  0,  0,  0,  0,  0,  0,  0, 51,  0 /)
    looku (:, 9,25) = (/   0,  0,  0,  0,  0,  0,  0,  0,  0, 51 /)

    looku (:, 0,26) = (/  51,  0, 0,  0,  0,  0,  0,  0,  0,  0 /)
    looku (:, 1,26) = (/   0, 51, 0,  0,  0,  0,  0,  0,  0,  0 /)
    looku (:, 2,26) = (/   0,  0, 51,  0,  0,  0,  0,  0,  0,  0 /)
    looku (:, 3,26) = (/   0,  0,  0, 51,  0,  0,  0,  0,  0,  0 /)
    looku (:, 4,26) = (/   0,  0,  0,  0, 51,  0,  0,  0,  0,  0 /)
    looku (:, 5,26) = (/   0,  0,  0,  0,  0, 51,  0,  0,  0,  0 /)
    looku (:, 6,26) = (/   0,  0,  0,  0,  0,  0, 51,  0,  0,  0 /)
    looku (:, 7,26) = (/   0,  0,  0,  0,  0,  0,  0, 51,  0,  0 /)
    looku (:, 8,26) = (/   0,  0,  0,  0,  0,  0,  0,  0, 51,  0 /)
    looku (:, 9,26) = (/   0,  0,  0,  0,  0,  0,  0,  0,  0, 51 /)

    looku (:, 0,27) = (/  51,  0, 0,  0,  0,  0,  0,  0,  0,  0 /)
    looku (:, 1,27) = (/   0, 51, 0,  0,  0,  0,  0,  0,  0,  0 /)
    looku (:, 2,27) = (/   0,  0, 51,  0,  0,  0,  0,  0,  0,  0 /)
    looku (:, 3,27) = (/   0,  0,  0, 51,  0,  0,  0,  0,  0,  0 /)
    looku (:, 4,27) = (/   0,  0,  0,  0, 51,  0,  0,  0,  0,  0 /)
    looku (:, 5,27) = (/   0,  0,  0,  0,  0, 51,  0,  0,  0,  0 /)
    looku (:, 6,27) = (/   0,  0,  0,  0,  0,  0, 51,  0,  0,  0 /)
    looku (:, 7,27) = (/   0,  0,  0,  0,  0,  0,  0, 51,  0,  0 /)
    looku (:, 8,27) = (/   0,  0,  0,  0,  0,  0,  0,  0, 51,  0 /)
    looku (:, 9,27) = (/   0,  0,  0,  0,  0,  0,  0,  0,  0, 51 /)

    looku (:, 0,28) = (/  51,  0, 0,  0,  0,  0,  0,  0,  0,  0 /)
    looku (:, 1,28) = (/   0, 51, 0,  0,  0,  0,  0,  0,  0,  0 /)
    looku (:, 2,28) = (/   0,  0, 51,  0,  0,  0,  0,  0,  0,  0 /)
    looku (:, 3,28) = (/   0,  0,  0, 51,  0,  0,  0,  0,  0,  0 /)
    looku (:, 4,28) = (/   0,  0,  0,  0, 51,  0,  0,  0,  0,  0 /)
    looku (:, 5,28) = (/   0,  0,  0,  0,  0, 51,  0,  0,  0,  0 /)
    looku (:, 6,28) = (/   0,  0,  0,  0,  0,  0, 51,  0,  0,  0 /)
    looku (:, 7,28) = (/   0,  0,  0,  0,  0,  0,  0, 51,  0,  0 /)
    looku (:, 8,28) = (/   0,  0,  0,  0,  0,  0,  0,  0, 51,  0 /)
    looku (:, 9,28) = (/   0,  0,  0,  0,  0,  0,  0,  0,  0, 51 /)

    !--(DMK-CCATT-INI)--------------------------------------
    looku (:, 0,29) = (/  51,  0, 0,  0,  0,  0,  0,  0,  0,  0 /)
    looku (:, 1,29) = (/   0, 51, 0,  0,  0,  0,  0,  0,  0,  0 /)
    looku (:, 2,29) = (/   0,  0, 51,  0,  0,  0,  0,  0,  0,  0 /)
    looku (:, 3,29) = (/   0,  0,  0, 51,  0,  0,  0,  0,  0,  0 /)
    looku (:, 4,29) = (/   0,  0,  0,  0, 51,  0,  0,  0,  0,  0 /)
    looku (:, 5,29) = (/   0,  0,  0,  0,  0, 51,  0,  0,  0,  0 /)
    looku (:, 6,29) = (/   0,  0,  0,  0,  0,  0, 51,  0,  0,  0 /)
    looku (:, 7,29) = (/   0,  0,  0,  0,  0,  0,  0, 51,  0,  0 /)
    looku (:, 8,29) = (/   0,  0,  0,  0,  0,  0,  0,  0, 51,  0 /)
    looku (:, 9,29) = (/   0,  0,  0,  0,  0,  0,  0,  0,  0, 51 /)
    !--(DMK-CCATT-FIM)--------------------------------------

    !--(DMK-CCATT-INI)--------------------------------------
    looku (:, 0,30) = (/  51,  0, 0,  0,  0,  0,  0,  0,  0,  0 /)
    looku (:, 1,30) = (/   0, 51, 0,  0,  0,  0,  0,  0,  0,  0 /)
    looku (:, 2,30) = (/   0,  0, 51,  0,  0,  0,  0,  0,  0,  0 /)
    looku (:, 3,30) = (/   0,  0,  0, 51,  0,  0,  0,  0,  0,  0 /)
    looku (:, 4,30) = (/   0,  0,  0,  0, 51,  0,  0,  0,  0,  0 /)
    looku (:, 5,30) = (/   0,  0,  0,  0,  0, 51,  0,  0,  0,  0 /)
    looku (:, 6,30) = (/   0,  0,  0,  0,  0,  0, 51,  0,  0,  0 /)
    looku (:, 7,30) = (/   0,  0,  0,  0,  0,  0,  0, 51,  0,  0 /)
    looku (:, 8,30) = (/   0,  0,  0,  0,  0,  0,  0,  0, 51,  0 /)
    looku (:, 9,30) = (/   0,  0,  0,  0,  0,  0,  0,  0,  0, 51 /)
    !--(DMK-CCATT-FIM)--------------------------------------

    cnfac(1:ncf2) = (/ &
        1.00000000E+00_r8,  1.00000000E+00_r8,  1.00000000E+00_r8,  1.00000000E+00_r8,  1.00000000E+00_r8, &
        1.00000000E+00_r8,  1.00000000E+00_r8,  1.00000000E+00_r8,  5.55555555E-01_r8,  1.80000000E+00_r8, &
        5.55555555E-01_r8,  1.80000000E+00_r8,  1.00000000E+02_r8,  1.00000000E-02_r8,  1.00000000E+00_r8, &
        1.00000000E+00_r8,  1.00000000E-01_r8,  1.00000000E+01_r8,  1.00000000E+03_r8,  1.00000000E-03_r8, &
        0.00000000E+00_r8,  0.00000000E+00_r8,  0.00000000E+00_r8,  0.00000000E+00_r8,  0.00000000E+00_r8, &
        0.00000000E+00_r8,  0.00000000E+00_r8,  0.00000000E+00_r8,  0.00000000E+00_r8,  0.00000000E+00_r8, &
        0.00000000E+00_r8,  0.00000000E+00_r8,  0.00000000E+00_r8,  0.00000000E+00_r8,  0.00000000E+00_r8, &
        0.00000000E+00_r8,  0.00000000E+00_r8,  0.00000000E+00_r8,  0.00000000E+00_r8,  0.00000000E+00_r8, &
        0.00000000E+00_r8,  0.00000000E+00_r8,  0.00000000E+00_r8,  0.00000000E+00_r8,  0.00000000E+00_r8, &
        0.00000000E+00_r8,  0.00000000E+00_r8,  0.00000000E+00_r8,  0.00000000E+00_r8,  0.00000000E+00_r8 /)
    cnfac(ncf2+1:ncf) = (/ &
        1.00000000E+00_r8,  1.00000000E-02_r8,  1.00000000E+02_r8,  1.00000000E-03_r8,  1.00000000E+03_r8, &
        1.00000000E-01_r8,  1.00000000E+01_r8,  1.00000000E-06_r8,  1.00000000E+06_r8,  1.00000000E-04_r8, &
        1.00000000E+04_r8,  8.64000000E+04_r8,  1.15740741E-05_r8,  3.15576000E+07_r8,  3.16880878E-08_r8, &
        3.65250000E+02_r8,  2.73785079E-03_r8,  8.64000000E+07_r8,  1.15740741E-08_r8,  1.00000000E-05_r8, &
        1.00000000E+05_r8,  8.64000000E-01_r8,  1.15740741E+00_r8,  8.64000000E+02_r8,  1.15740741E-03_r8, &
        8.64000000E-02_r8,  1.15740741E+01_r8,  8.64000000E+01_r8,  1.15740741E-02_r8,  8.64000000E+05_r8, &
        1.15740741E-06_r8,  1.00000000E+09_r8,  1.00000000E-09_r8,  0.00000000E+00_r8,  0.00000000E+00_r8, &
        0.00000000E+00_r8,  0.00000000E+00_r8,  0.00000000E+00_r8,  0.00000000E+00_r8,  0.00000000E+00_r8, &
        0.00000000E+00_r8,  0.00000000E+00_r8,  0.00000000E+00_r8,  0.00000000E+00_r8,  0.00000000E+00_r8, &
        0.00000000E+00_r8,  0.00000000E+00_r8,  0.00000000E+00_r8,  0.00000000E+00_r8,  0.00000000E+00_r8 /)

    cnfac2(1:ncf2) = (/ &
        2.73150000E+02_r8, -2.73150000E+02_r8,  4.60517019E+00_r8, -4.60517019E+00_r8,  6.90775528E+00_r8, &
       -6.90775528E+00_r8, -2.30258509E+00_r8,  2.30258509E+00_r8,  2.55372222E+02_r8, -4.59670000E+02_r8, &
       -1.77777778E+01_r8,  3.20000000E+01_r8,  1.00000000E+05_r8, -1.00000000E+03_r8,  1.00000000E+03_r8, &
       -1.00000000E+03_r8,  1.00000000E+02_r8, -1.00000000E+03_r8,  1.00000000E+06_r8, -1.00000000E+03_r8, &
        0.00000000E+00_r8,  0.00000000E+00_r8,  0.00000000E+00_r8,  0.00000000E+00_r8,  0.00000000E+00_r8, &
        0.00000000E+00_r8,  0.00000000E+00_r8,  0.00000000E+00_r8,  0.00000000E+00_r8,  0.00000000E+00_r8, &
        0.00000000E+00_r8,  0.00000000E+00_r8,  0.00000000E+00_r8,  0.00000000E+00_r8,  0.00000000E+00_r8, &
        0.00000000E+00_r8,  0.00000000E+00_r8,  0.00000000E+00_r8,  0.00000000E+00_r8,  0.00000000E+00_r8, &
        0.00000000E+00_r8,  0.00000000E+00_r8,  0.00000000E+00_r8,  0.00000000E+00_r8,  0.00000000E+00_r8, &
        0.00000000E+00_r8,  0.00000000E+00_r8,  0.00000000E+00_r8,  0.00000000E+00_r8,  0.00000000E+00_r8 /)

  END SUBROUTINE CreateConversion


  FUNCTION GiveUnit(i) RESULT (u)

    INTEGER, INTENT(IN) :: i
    CHARACTER (LEN=16) :: u
    u=aunits(i)

  END FUNCTION GiveUnit


  SUBROUTINE cnvout (ndim, ifr, ito, arin, arout, ierr)

    ! convert units of array arin to array arout
    ! according to ifr and ito
    ! returns error code (ierr == 0 means OK)

    INTEGER, INTENT(IN)  :: ndim
    INTEGER, INTENT(IN)  :: ifr
    INTEGER, INTENT(IN)  :: ito
    REAL (KIND=r8),    INTENT(IN)  :: arin(ndim)
    REAL (KIND=r8),    INTENT(OUT) :: arout(ndim)
    INTEGER, INTENT(OUT) :: ierr

    INTEGER :: igpf
    INTEGER :: iuf
    INTEGER :: iut
    INTEGER :: icf
    INTEGER :: i
    REAL (KIND=r8)    :: cf1
    REAL (KIND=r8)    :: cf2
    LOGICAL :: l700a
    LOGICAL :: l700b
    LOGICAL :: l300a
    LOGICAL :: l300b

    l700a = (ifr < -1) .OR. (ito < -1)
    l700b = (ifr >  numx) .OR. (ito >  numx)
    IF (l700a .OR. l700b) THEN
       ierr=3
       RETURN
    END IF

    l300a = ifr == -1
    l300b = ito == -1
    IF (l300a .OR. l300b) THEN
       ierr=-1
       RETURN
    END IF

    IF (ito == ifr) THEN
       ierr=0
       RETURN
    END IF

    igpf=ifr/10
    iuf=MOD(ifr,10)
    iut=MOD(ito,10)
    IF (igpf /= ito/10) THEN
       ierr=1
       RETURN
    END IF

    icf=looku(iuf,iut,igpf)
    IF (icf == 0) THEN
       ierr=2
       RETURN
    END IF

    cf1 = cnfac(icf)
    IF (icf <= ncf2) THEN
       cf2=cnfac2(icf)
    ELSE
       cf2=0.0_r8
    END IF

    DO i=1,ndim
       arout(i)=cf1*arin(i)+cf2
    END DO
    ierr=0

  END SUBROUTINE cnvout


END MODULE Conversion
