#include "cnames.h"

/*
 * GRIB table 201 at DWD
 *     Helmut P. Frank, 30.08.2001
 * updated 24.07.2003:  DQC_GSP, DQI_GSP, T_SO, W_SO, W_SO_ICE, T_ICE
 *         19.10.2005:  SOTR_RA, QRS_GSP, RHO_SNOW to table 201, and others
 */

const struct ParmTable parm_table_dwd_201[256] = {
    /* 0 */ {"var0", "undefined"},
    /* 1 */ {"dw sw flux", "downward shortwave radiant flux density [W/m**2]"},
    /* 2 */ {"uw sw flux", "upward shortwave radiant flux density [W/m**2]"},
    /* 3 */ {"dw lw flux", "downward longwave radiant flux density [W/m**2]"},
    /* 4 */ {"uw lw flux", "upward longwave radiant flux density [W/m**2]"},
    /* 5 */ {"APAB_S", "downwd photosynthetic active radiant flux density [W/m**2]"},
    /* 6 */ {"net s flux", "net shortwave flux [W/m**2]"},
    /* 7 */ {"net l flux", "net longwave flux [W/m**2]"},
    /* 8 */ {"net flux", "total net radiative flux density [W/m**2]"},
    /* 9 */ {"dw sw clfr", "downw shortw radiant flux density, cloudfree part [W/m**2]"},
    /* 10 */ {"uw sw cldy", "upw shortw radiant flux density, cloudy part [W/m**2]"},
    /* 11 */ {"dw lw clfr", "downw longw radiant flux density, cloudfree part [W/m**2]"},
    /* 12 */ {"uw lw cldy", "upw longw radiant flux density, cloudy part [W/m**2]"},
    /* 13 */ {"SOHR_RAD", "shortwave radiative heating rate [K/s]"},
    /* 14 */ {"THHR_RAD", "longwave radiative heating rate [K/s]"},
    /* 15 */ {"rad heat", "total radiative heating rate [K/s]"},
    /* 16 */ {"soilheat S", "soil heat flux, surface [W/m**2]"},
    /* 17 */ {"soilheat L", "soil heat flux, bottom of layer [W/m**2]"},
    /* 18 */ {"var18", "undefined"},
    /* 19 */ {"var19", "undefined"},
    /* 20 */ {"var20", "undefined"},
    /* 21 */ {"var21", "undefined"},
    /* 22 */ {"var22", "undefined"},
    /* 23 */ {"var23", "undefined"},
    /* 24 */ {"var24", "undefined"},
    /* 25 */ {"var25", "undefined"},
    /* 26 */ {"var26", "undefined"},
    /* 27 */ {"var27", "undefined"},
    /* 28 */ {"var28", "undefined"},
    /* 29 */ {"CLC", "cloud cover, grid scale + convective [1]"},
    /* 30 */ {"clc gr sc", "cloud cover, grid scale  (0...1) [1]"},
    /* 31 */ {"QC", "specific cloud water content, grid scale [kg/kg]"},
    /* 32 */ {"clw gs vi", "cloud water content, grid scale, vert integrated [kg/m**2]"},
    /* 33 */ {"QI", "specific cloud ice content, grid scale [kg/kg]"},
    /* 34 */ {"cli gs vi", "cloud ice content, grid scale, vert integrated [kg/m**2]"},
    /* 35 */ {"QR", "specific rainwater content, grid scale [kg/kg]"},
    /* 36 */ {"QS", "specific snow content, grid scale [kg/kg]"},
    /* 37 */ {"src gs vi", "specific rainwater content, gs, vert. integrated [kg/m**2]"},
    /* 38 */ {"ssc gs vi", "specific snow content, gs, vert. integrated [kg/m**2]"},
    /* 39 */ {"QG", "specific graupel content, grid scale [kg/kg]"},
    /* 40 */ {"var40", "undefined"},
    /* 41 */ {"TWATER", "vert. integral of humidity, cloud water (and ice) [kg/(m**2)]"},
    /* 42 */ {"TDIV_HUM", "vert. integral of divergence of tot. water content [kg/(m**2)]"},
    /* 43 */ {"var43", "undefined"},
    /* 44 */ {"var44", "undefined"},
    /* 45 */ {"var45", "undefined"},
    /* 46 */ {"var46", "undefined"},
    /* 47 */ {"var47", "undefined"},
    /* 48 */ {"var48", "undefined"},
    /* 49 */ {"var49", "undefined"},
    /* 50 */ {"CH_CM_CL", "cloud covers CH_CM_CL (000...888) [1]"},
    /* 51 */ {"cl cov. CH", "cloud cover CH (0..8) [1]"},
    /* 52 */ {"cl cov. CM", "cloud cover CM (0..8) [1]"},
    /* 53 */ {"cl cov. CL", "cloud cover CL (0..8) [1]"},
    /* 54 */ {"cloud cov.", "total cloud cover (0..8) [1]"},
    /* 55 */ {"fog", "fog (0..8) [1]"},
    /* 56 */ {"fog", "fog [1]"},
    /* 57 */ {"var57", "undefined"},
    /* 58 */ {"var58", "undefined"},
    /* 59 */ {"var59", "undefined"},
    /* 60 */ {"clc con ci", "cloud cover, convective cirrus  (0...1) [1]"},
    /* 61 */ {"CLW_CON", "specific cloud water content, convective clouds [kg/kg]"},
    /* 62 */ {"clw con vi", "cloud water content, conv clouds, vert integrated [kg/m**2]"},
    /* 63 */ {"cli con", "specific cloud ice content, convective clouds [kg/kg]"},
    /* 64 */ {"cli con vi", "cloud ice content, conv clouds, vert integrated [kg/m**2]"},
    /* 65 */ {"mass fl co", "convective mass flux [kg/(s*m**2)]"},
    /* 66 */ {"upd vel co", "updraft velocity, convection [m/s]"},
    /* 67 */ {"entr p co", "entrainment parameter, convection [m**(-1)]"},
    /* 68 */ {"HBAS_CON", "cloud base, convective clouds (above msl) [m]"},
    /* 69 */ {"HTOP_CON", "cloud top, convective clouds (above msl) [m]"},
    /* 70 */ {"con layers", "convective layers (00...77)  (BKE) [1]"},
    /* 71 */ {"KO-index", "KO-index [1]"},
    /* 72 */ {"BAS_CON", "convection base index [1]"},
    /* 73 */ {"TOP_CON", "convection top index [1]"},
    /* 74 */ {"DT_CON", "convective temperature tendency [K/s]"},
    /* 75 */ {"DQV_CON", "convective tendency of specific humidity [s**(-1)]"},
    /* 76 */ {"H ten co", "convective tendency of total heat [J/(kg*s)]"},
    /* 77 */ {"QDW ten co", "convective tendency of total water [s**(-1)]"},
    /* 78 */ {"DU_CON", "convective momentum tendency (X-component) [m/s**2]"},
    /* 79 */ {"DV_CON", "convective momentum tendency (Y-component) [m/s**2]"},
    /* 80 */ {"vor ten co", "convective vorticity tendency [s**(-2)]"},
    /* 81 */ {"div ten co", "convective divergence tendency [s**(-2)]"},
    /* 82 */ {"HTOP_DC", "top of dry convection (above msl) [m]"},
    /* 83 */ {"top ind dc", "dry convection top index [1]"},
    /* 84 */ {"HZEROCL", "height of 0 degree Celsius isotherm above msl [m]"},
    /* 85 */ {"SNOWLMT", "height of snowfall limit above msl [m]"},
    /* 86 */ {"var86", "undefined"},
    /* 87 */ {"var87", "undefined"},
    /* 88 */ {"var88", "undefined"},
    /* 89 */ {"var89", "undefined"},
    /* 90 */ {"var90", "undefined"},
    /* 91 */ {"var91", "undefined"},
    /* 92 */ {"var92", "undefined"},
    /* 93 */ {"var93", "undefined"},
    /* 94 */ {"var94", "undefined"},
    /* 95 */ {"var95", "undefined"},
    /* 96 */ {"var96", "undefined"},
    /* 97 */ {"var97", "undefined"},
    /* 98 */ {"var98", "undefined"},
    /* 99 */ {"QRS_GSP", "spec water cont of rain/snow needed for w loading [kg/kg]"},
    /* 100 */ {"PRR_GSP", "surface precipitation rate, rain, grid scale [kg/(s*m**2)]"},
    /* 101 */ {"PRS_GSP", "surface precipitation rate, snow, grid scale [kg/(s*m**2)]"},
    /* 102 */ {"RAIN_GSP", "surface precipitation amount, rain, grid scale [kg/m**2]"},
    /* 103 */ {"condens gs", "condensation rate, grid scale [kg/(kg*s)]"},
    /* 104 */ {"autocon gs", "autoconversion rate, grid scale   (C+C  --> R) [kg/(kg*s)]"},
    /* 105 */ {"accret gs", "accretion rate, grid scale        (R+C  --> R) [kg/(kg*s)]"},
    /* 106 */ {"nucleat gs", "nucleation rate, grid scale       (C+C  --> S) [kg/(kg*s)]"},
    /* 107 */ {"riming gs", "riming rate, grid scale           (S+C  --> S) [kg/(kg*s)]"},
    /* 108 */ {"deposit gs", "deposition rate, grid scale       (S+V <--> S) [kg/(kg*s)]"},
    /* 109 */ {"melting gs", "melting rate, grid scale          (S    --> R) [kg/(kg*s)]"},
    /* 110 */ {"evapor gs", "evaporation rate, grid scale      (R+V <--  R) [kg/(kg*s)]"},
    /* 111 */ {"PRR_CON", "surface precipitation rate, rain, convective [kg/(s*m**2)]"},
    /* 112 */ {"PRS_CON", "surface precipitation rate, snow, convective [kg/(s*m**2)]"},
    /* 113 */ {"RAIN_CON", "surface precipitation amount, rain, convective [kg/m**2]"},
    /* 114 */ {"condens co", "condensation rate, convective [kg/(kg*s)]"},
    /* 115 */ {"autocon co", "autoconversion rate, convective [kg/(kg*s)]"},
    /* 116 */ {"accret co", "accretion rate, convective [kg/(kg*s)]"},
    /* 117 */ {"nucleat co", "nucleation rate, convective [kg/(kg*s)]"},
    /* 118 */ {"riming co", "riming rate, convective [kg/(kg*s)]"},
    /* 119 */ {"sublim co", "sublimation rate, convective [kg/(kg*s)]"},
    /* 120 */ {"melting co", "melting rate, convective [kg/(kg*s)]"},
    /* 121 */ {"evapor co", "evaporation rate, convective [kg/(kg*s)]"},
    /* 122 */ {"rain am", "rain amount, grid-scale plus convective [kg/m**2]"},
    /* 123 */ {"snow am", "snow amount, grid-scale plus convective [kg/m**2]"},
    /* 124 */ {"DT_GSP", "temperature tendency, grid-scale condensation [K/s]"},
    /* 125 */ {"DQV_GSP", "tendency of specific humidity, grid-scale condens [s**(-1)]"},
    /* 126 */ {"H ten gs", "tendency of total heat, grid-scale condensation [J/(kg*s)]"},
    /* 127 */ {"DQC_GSP", "tendency of total water, grid-scale condensation [s**(-1)]"},
    /* 128 */ {"snowfall", "snowfall  (dimension"},
    /* 129 */ {"FRESHSNW", "fresh snow factor [1]"},
    /* 130 */ {"DQI_GSP", "tend of the sp cl ice cont due to gs precipitation [kg/(kg*s)]"},
    /* 131 */ {"PRG_GSP", "surface precipitation rate, graupel, grid scale [kg/(s*m**2)]"},
    /* 132 */ {"GRAU_GSP", "surface precipitation amount, graupel, grid scale [kg/(m**2)]"},
    /* 133 */ {"RHO_SNOW", "snow density [kg/m**3"},
    /* 134 */ {"var134", "undefined"},
    /* 135 */ {"var135", "undefined"},
    /* 136 */ {"var136", "undefined"},
    /* 137 */ {"var137", "undefined"},
    /* 138 */ {"var138", "undefined"},
    /* 139 */ {"PP", "deviation of pressure from reference value [Pa]"},
    /* 140 */ {"var140", "undefined"},
    /* 141 */ {"var141", "undefined"},
    /* 142 */ {"var142", "undefined"},
    /* 143 */ {"var143", "undefined"},
    /* 144 */ {"var144", "undefined"},
    /* 145 */ {"var145", "undefined"},
    /* 146 */ {"var146", "undefined"},
    /* 147 */ {"var147", "undefined"},
    /* 148 */ {"var148", "undefined"},
    /* 149 */ {"KE", "kinetic energy ((u**2 + v**2) / 2) [(m**2/s**2)]"},
    /* 150 */ {"hdi coeff", "coefficient of horizontal diffusion [m**2/s]"},
    /* 151 */ {"dissp rate", "dissipation rate [W/(Pa*m**2)]"},
    /* 152 */ {"TKE", "turbulent kinetic energy [(m/s)**2]"},
    /* 153 */ {"TKVM", "coefficient of vertical diffusion, momentum [m**2/s]"},
    /* 154 */ {"TKVH", "coefficient of vertical diffusion, heat [m**2/s]"},
    /* 155 */ {"vdi coe cw", "coefficient of vertical diffusion, cloud water [m**2/s]"},
    /* 156 */ {"vdi coe ci", "coefficient of vertical diffusion, cloud ice [m**2/s]"},
    /* 157 */ {"vdi coe vp", "coefficient of vertical diffusion, water vapour [m**2/s]"},
    /* 158 */ {"dis len m", "turbulent dissipation length for momentum [m]"},
    /* 159 */ {"dis len h", "turbulent dissipation length for heat [m]"},
    /* 160 */ {"var u mom", "variance of u-component of momentum [(m/s)**2]"},
    /* 161 */ {"var v mom", "variance of v-component of momentum [(m/s)**2]"},
    /* 162 */ {"var w mom", "variance of w-component of momentum [(m/s)**2]"},
    /* 163 */ {"var temp", "variance of temperature [K**2]"},
    /* 164 */ {"var cl wat", "variance of specific cloud water content [(kg/kg)**2]"},
    /* 165 */ {"var cl ice", "variance of specific cloud ice content [(kg/kg)**2]"},
    /* 166 */ {"var vap mr", "variance of water vapour mixing ratio [(kg/kg)**2]"},
    /* 167 */ {"c wat flux", "turbulent vertical flux of spec cloud water [m/s]"},
    /* 168 */ {"c ice flux", "turbulent vertical flux of spec cloud ice [m/s]"},
    /* 169 */ {"w vap flux", "turbulent vertical flux of water vapour mix ratio [m/s]"},
    /* 170 */ {"TCM", "drag coefficient CD [1]"},
    /* 171 */ {"TCH", "transfer coefficient CH (sensible heat) [1]"},
    /* 172 */ {"tr coef CQ", "transfer coefficient CQ (latent heat) [1]"},
    /* 173 */ {"PBL-top h", "PBL-top h [m]"},
    /* 174 */ {"T-jump  h", "temperature jump at PBL-top [K]"},
    /* 175 */ {"q-jump  h", "specific humidity jump at PBL-top [kg/kg]"},
    /* 176 */ {"entr at h", "entrainment at PBL-top [kg/(s*m**2)]"},
    /* 177 */ {"mass fl h", "upward mass flux at PBL-top [kg/(s*m**2)]"},
    /* 178 */ {"cl cov PBL", "cloud cover of PBL-clouds (0...1) [1]"},
    /* 179 */ {"cl wat PBL", "specific cloud water content of PBL-clouds [kg/kg]"},
    /* 180 */ {"cl top PBL", "cloud top of PBL-clouds [m]"},
    /* 181 */ {"cl bas PBL", "cloud base of PBL-clouds [m]"},
    /* 182 */ {"moun wav X", "vertical mountain wave momentum flux (X component) [kg/(m*s**2)]"},
    /* 183 */ {"moun wav Y", "vertical mountain wave momentum flux (Y component) [kg/(m*s**2)]"},
    /* 184 */ {"wave Ri", "wave Richardson number [1]"},
    /* 185 */ {"wav div X", "mountain wave momentum flux divergence (X comp) [m/s**2]"},
    /* 186 */ {"wav div Y", "mountain wave momentum flux divergence (Y comp) [m/s**2]"},
    /* 187 */ {"VMAX_10M", "maximum wind velocity [m/s]"},
    /* 188 */ {"wav dis vi", "mountain wave dissipation, vert integrated [W/m**2]"},
    /* 189 */ {"wv en flux", "vertical wave energy flux [kg*m/s**4]"},
    /* 190 */ {"var190", "undefined"},
    /* 191 */ {"var191", "undefined"},
    /* 192 */ {"var192", "undefined"},
    /* 193 */ {"var193", "undefined"},
    /* 194 */ {"var194", "undefined"},
    /* 195 */ {"var195", "undefined"},
    /* 196 */ {"var196", "undefined"},
    /* 197 */ {"T_SO", "temperature of soil layers [K]"},
    /* 198 */ {"W_SO", "water + ice content of soil layers [kg/(m**2)]"},
    /* 199 */ {"W_SO_ICE", "ice content of soil layers [kg/(m**2)]"},
    /* 200 */ {"W_I", "water content of interception store [kg/(m**2)]"},
    /* 201 */ {"interc ice", "icebit for interception store [1]"},
    /* 202 */ {"snow fract", "snow fraction [1]"},
    /* 203 */ {"T_SNOW", "snow temperature [K]"},
    /* 204 */ {"foliag tem", "foliage temperature [K]"},
    /* 205 */ {"infiltrat", "infiltration [m/s]"},
    /* 206 */ {"runoff", "runoff [m/s]"},
    /* 207 */ {"soil evap", "bare soil evaporation [m/s]"},
    /* 208 */ {"plant tran", "plant transpiration [m/s]"},
    /* 209 */ {"inter evap", "interception store evaporation [m/s]"},
    /* 210 */ {"water evap", "evaporation from water surfaces [m/s]"},
    /* 211 */ {"aero resis", "aerodynamic resistance [s/m]"},
    /* 212 */ {"plant res", "plant resistance [s/m]"},
    /* 213 */ {"soil res", "soil resistance [s/m]"},
    /* 214 */ {"total evap", "total evaporation (water, soil, plants) [m/s]"},
    /* 215 */ {"T_ICE", "temperature of sea ice [K]"},
    /* 216 */ {"var216", "undefined"},
    /* 217 */ {"max wind m", "maximum wind velocity (modified) [m/s]"},
    /* 218 */ {"var218", "undefined"},
    /* 219 */ {"var219", "undefined"},
    /* 220 */ {"var220", "undefined"},
    /* 221 */ {"var221", "undefined"},
    /* 222 */ {"var222", "undefined"},
    /* 223 */ {"var223", "undefined"},
    /* 224 */ {"var224", "undefined"},
    /* 225 */ {"var225", "undefined"},
    /* 226 */ {"var226", "undefined"},
    /* 227 */ {"var227", "undefined"},
    /* 228 */ {"var228", "undefined"},
    /* 229 */ {"var229", "undefined"},
    /* 230 */ {"XYZ", "S1 [1]"},
    /* 231 */ {"RHS_SI", "S2 [1]"},
    /* 232 */ {"DTTDIV", "S3 [1]"},
    /* 233 */ {"SOTR_RAD", "effective transmissivity of solar rad. [1]"},
    /* 234 */ {"GEN_TEN1", "averaged tendencies [x/s]"},
    /* 235 */ {"GEN_TEN2", "averaged tendencies [x/s]"},
    /* 236 */ {"S7", "S7 [1]"},
    /* 237 */ {"S8", "S8 [1]"},
    /* 238 */ {"S9", "S9 [1]"},
    /* 239 */ {"S10", "S10 [1]"},
    /* 240 */ {"MFLX_CON", "cloud base mass flux kg/(s*m**2)"},
    /* 241 */ {"CAPE_CON", "convective available potential energy [J/kg]"},
    /* 242 */ {"QCVG_CON", "moisture convergence for Kuo-type closure [1/s]"},
    /* 243 */ {"TKE_CON", "convective turbulent energy [J/kg]"},
    /* 244 */ {"MOS pTS fq", "MOS Gewitter-Wahrscheinlichkeit (frequent) [1]"},
    /* 245 */ {"MOS TS cov", "MOS Gewitteranteil (occasional - frequent (1 - 2)) [1]"},
    /* 246 */ {"S17", "S17 [1]"},
    /* 247 */ {"S18", "S18 [1]"},
    /* 248 */ {"S19", "S19 [1]"},
    /* 249 */ {"S20", "S20 [1]"},
    /* 250 */ {"MOS TSISO1", "MOS Wahrscheinlichkeit mindestens ein Blitz [1]"},
    /* 251 */ {"MOS TSISO2", "MOS Wahrscheinlichkeit mindestens zehn Blitze [1]"},
    /* 252 */ {"MOS TSISO3", "MOS Wahrscheinlichkeit mindestens hundert Blitze [1]"},
    /* 253 */ {"MOS TS DEN", "MOS Vorhersage der Blitzanzahl [1]"},
    /* 254 */ {"MOS TS OCC", "MOS Gewitter-Wahrscheinlichkeit (occasional) [1]"},
    /* 255 */ {"MOS TS FRQ", "MOS Gewitter-Wahrscheinlichkeit (frequent) [1]"},
};
