#include "cnames.h"

/*
 * GRIB table 203 at DWD
 *     Helmut P. Frank, 30.08.2001
 *     updated: 19.10.2005
 */

const struct ParmTable parm_table_dwd_203[256] = {
    /* 0 */ {"var0", "undefined"},
    /* 1 */ {"pressure", "pressure [hPa]"},
    /* 2 */ {"geopot h", "geopotential height [10 * gpm]"},
    /* 3 */ {"var3", "undefined"},
    /* 4 */ {"temperatur", "temperature [1*degree Celsius]"},
    /* 5 */ {"dew-pnt te", "dew-point temperature [1*degree Celsius]"},
    /* 6 */ {"windcompXY", "wind components X/Y (X*100000 + ((Y*10)+5000)) [m/s]"},
    /* 7 */ {"geomet h", "geometrical height [kft]"},
    /* 8 */ {"geomet h", "geometrical height [hft]"},
    /* 9 */ {"wind di/sp", "wind direction and speed (dd*1000 + ff) [1*degree, 1*kt]"},
    /* 10 */ {"3 h pr cha", "3 hour pressure change [Pa/(3*h)]"},
    /* 11 */ {"Schnee-Mge", "Schneemenge [mm]"},
    /* 12 */ {"var12", "undefined"},
    /* 13 */ {"Bod-Wass-G", "Bodenwassergehalt [mm]"},
    /* 14 */ {"var14", "undefined"},
    /* 15 */ {"stab. ind.", "stability index [K]"},
    /* 16 */ {"var16", "undefined"},
    /* 17 */ {"var17", "undefined"},
    /* 18 */ {"max wind", "maximum wind velocity [km/h]"},
    /* 19 */ {"max wind", "maximum wind velocity [kt]"},
    /* 20 */ {"wind di/sp", "wind direction and speed (dd*1000 + ff) [5*degrees, 1*(m/s)]"},
    /* 21 */ {"wind di/sp", "wind direction and speed (dd*1000 + ff) [5*degrees, 1*kt]"},
    /* 22 */ {"wave di/he", "direction and height of wind waves (dd*1000 + h) [1*degree, 1*cm]"},
    /* 23 */ {"swe. di/he", "direction and height of swell (dd*1000 + h) [1*degree, 1*cm]"},
    /* 24 */ {"wave m d/h", "mean direction and height of waves (dd*1000 + h) [1*degree, 1*cm]"},
    /* 25 */ {"wind speed", "wind speed [kt]"},
    /* 26 */ {"var26", "undefined"},
    /* 27 */ {"wind compX", "wind component X-direction [kt]"},
    /* 28 */ {"wind compY", "wind component Y-direction [kt]"},
    /* 29 */ {"var29", "undefined"},
    /* 30 */ {"var30", "undefined"},
    /* 31 */ {"var31", "undefined"},
    /* 32 */ {"var32", "undefined"},
    /* 33 */ {"abs voradv", "absolute vorticity advection [1/(s**2)]"},
    /* 34 */ {"var34", "undefined"},
    /* 35 */ {"var35", "undefined"},
    /* 36 */ {"var36", "undefined"},
    /* 37 */ {"var37", "undefined"},
    /* 38 */ {"var38", "undefined"},
    /* 39 */ {"var39", "undefined"},
    /* 40 */ {"var40", "undefined"},
    /* 41 */ {"var41", "undefined"},
    /* 42 */ {"vert. vel.", "vertical velocity [hPa/h]"},
    /* 43 */ {"var43", "undefined"},
    /* 44 */ {"var44", "undefined"},
    /* 45 */ {"var45", "undefined"},
    /* 46 */ {"var46", "undefined"},
    /* 47 */ {"var47", "undefined"},
    /* 48 */ {"var48", "undefined"},
    /* 49 */ {"var49", "undefined"},
    /* 50 */ {"var50", "undefined"},
    /* 51 */ {"var51", "undefined"},
    /* 52 */ {"var52", "undefined"},
    /* 53 */ {"var53", "undefined"},
    /* 54 */ {"var54", "undefined"},
    /* 55 */ {"max. temp.", "maximum temperature [1*degree Celsius]"},
    /* 56 */ {"min. temp.", "minimum temperature [1*degree Celsius]"},
    /* 57 */ {"sul_prob", "probability to perceive sultriness [1]"},
    /* 58 */ {"clo", "value of isolation of clothes [1]"},
    /* 59 */ {"pmva", "predected mean vote (angepasst) [1]"},
    /* 60 */ {"feeled t", "feeled temperature [1*degree Celsius]"},
    /* 61 */ {"sea temper", "sea temperature [1*degree Celsius]"},
    /* 62 */ {"var62", "undefined"},
    /* 63 */ {"var63", "undefined"},
    /* 64 */ {"var64", "undefined"},
    /* 65 */ {"var65", "undefined"},
    /* 66 */ {"var66", "undefined"},
    /* 67 */ {"var67", "undefined"},
    /* 68 */ {"var68", "undefined"},
    /* 69 */ {"var69", "undefined"},
    /* 70 */ {"var70", "undefined"},
    /* 71 */ {"var71", "undefined"},
    /* 72 */ {"var72", "undefined"},
    /* 73 */ {"var73", "undefined"},
    /* 74 */ {"var74", "undefined"},
    /* 75 */ {"var75", "undefined"},
    /* 76 */ {"var76", "undefined"},
    /* 77 */ {"var77", "undefined"},
    /* 78 */ {"var78", "undefined"},
    /* 79 */ {"var79", "undefined"},
    /* 80 */ {"var80", "undefined"},
    /* 81 */ {"var81", "undefined"},
    /* 82 */ {"var82", "undefined"},
    /* 83 */ {"var83", "undefined"},
    /* 84 */ {"var84", "undefined"},
    /* 85 */ {"var85", "undefined"},
    /* 86 */ {"Globalstr.", "Summe der Globalstrahlung ueber einen Zeitraum [kWh/m**2]"},
    /* 87 */ {"Nied-GW-GE", "Niederschlagsart+Gewitter+Glatteis (T23-i) (0..99) [1]"},
    /* 88 */ {"NiedGW-Art", "Niederschlagsart+Gewitter (T23-intern)     (0..99) [1]"},
    /* 89 */ {"NiedGE-Art", "Niederschlagsart+Glatteis (T23-intern)     (0..99) [1]"},
    /* 90 */ {"NiedBewArt", "Kombination Niederschl.-Bew.-Blautherm. (283..407) [1]"},
    /* 91 */ {"Konv.U-Gr.", "Hoehe der Konvektionsuntergrenze ueber Grund [m]"},
    /* 92 */ {"Nied.-Art", "Niederschlagsart -ww- (T23-intern)         (0..99) [1]"},
    /* 93 */ {"Konv.-Art", "Konvektionsart                              (0..4) [1]"},
    /* 94 */ {"Konv.UG-nn", "Hoehe der Konvektionsuntergrenze ueber nn [m]"},
    /* 95 */ {"var95", "undefined"},
    /* 96 */ {"var96", "undefined"},
    /* 97 */ {"var97", "undefined"},
    /* 98 */ {"var98", "undefined"},
    /* 99 */ {"WW", "Wetter (verschluesselt nach ww-Tabelle"},
    /* 100 */ {"geostr Vor", "geostrophische Vorticity [1/s]"},
    /* 101 */ {"Geo VorAdv", "geostrophische  Vorticityadvektion [1/s**2]"},
    /* 102 */ {"VerGraVoAd", "vert. Gradient der geostr. Vorticityadvektion [m/(kg*s)]"},
    /* 103 */ {"Geo TemAdv", "geostrophische Schichtdickenadvektion [m**3/(kg*s)]"},
    /* 104 */ {"Lap TemAdv", "Kruemmung der geostr. Schichtdickenadvektion [m/(kg*s)]"},
    /* 105 */ {"Omega Forc", "Forcing rechte Seite Omegagleichung [m/(kg*s)]"},
    /* 106 */ {"var106", "undefined"},
    /* 107 */ {"Schichtd.A", "Schichtdicken-Advektion [m**3/(kg*s)]"},
    /* 108 */ {"AdGeVoThWi", "Advektion von geostr. Vorticity mit dem therm Wind [m/(kg*s)]"},
    /* 109 */ {"Wind-Div.", "Winddivergenz [1/s]"},
    /* 110 */ {"Q", "Q-vector direction and speed (dd*1000 + fff*1E13) [5*deg,1E13*m**2/kg/s]"},
    /* 111 */ {"Qx", "Q-Vektor X-Komponente [m**2/(kg*s)]"},
    /* 112 */ {"Qy", "Q-Vektor Y-Komponente [m**2/(kg*s)]"},
    /* 113 */ {"Div Q", "Divergenz Q [m/(kg*s)]"},
    /* 114 */ {"FrontoGeQn", "Frontogenesefunktion, Q isother-senkrecht-Kompon. [m**2/(kg*s)]"},
    /* 115 */ {"Qs (geo)", "Qs (geo),Komp. Q-Vektor parallel zu den Isothermen [m**2/(kg*s)]"},
    /* 116 */ {"DivQn(geo)", "Divergenz Qn  geostrophisch [m/(kg*s)]"},
    /* 117 */ {"DivQs(geo)", "Divergenz Qs  geostrophisch [m/(kg*s)]"},
    /* 118 */ {"Fronto Gen", "Frontogenesefunktion [K**2/(m**2*s)]"},
    /* 119 */ {"var119", "undefined"},
    /* 120 */ {"var120", "undefined"},
    /* 121 */ {"var121", "undefined"},
    /* 122 */ {"var122", "undefined"},
    /* 123 */ {"var123", "undefined"},
    /* 124 */ {"FrontoGenP", "Frontogenese-Parameter [1]"},
    /* 125 */ {"Qs-Vektor", "Qs, Komp. Q-Vektor parallel zu den Isothermen [m**2/(kg*s)]"},
    /* 126 */ {"var126", "undefined"},
    /* 127 */ {"Div Qs", "Divergenz Qs [m/(kg*s)]"},
    /* 128 */ {"var128", "undefined"},
    /* 129 */ {"var129", "undefined"},
    /* 130 */ {"IPV", "Isentrope potentielle Vorticity [K*m**2/(s*kg)]"},
    /* 131 */ {"Wind KompX", "Wind X-Komponente auf isentropen Flaechen [m/s]"},
    /* 132 */ {"Wind KompY", "Wind Y-Komponente auf isentropen Flaechen [m/s]"},
    /* 133 */ {"Druck-Ise.", "Druck einer isentropen Flaeche [hPa]"},
    /* 134 */ {"var134", "undefined"},
    /* 135 */ {"var135", "undefined"},
    /* 136 */ {"var136", "undefined"},
    /* 137 */ {"var137", "undefined"},
    /* 138 */ {"var138", "undefined"},
    /* 139 */ {"var139", "undefined"},
    /* 140 */ {"KO-Index", "KO-Index [K]"},
    /* 141 */ {"TT-Index", "Totals-Totals-Index [K]"},
    /* 142 */ {"S-Index", "S-Index [K]"},
    /* 143 */ {"Stein-Ind", "Steinbeck-Index [1]"},
    /* 144 */ {"Baily-Ind", "Baily-Index [1]"},
    /* 145 */ {"Microburst", "Microburst-Index [1]"},
    /* 146 */ {"Cat-Index", "Clear Air Turbulence Index [1/s]"},
    /* 147 */ {"var147", "undefined"},
    /* 148 */ {"Lab-Energ", "Labilit{tsenergie [J/g]"},
    /* 149 */ {"var149", "undefined"},
    /* 150 */ {"Virt T", "Virtuelle Temperatur [K]"},
    /* 151 */ {"Pseudo T", "Pseudo-Temperatur [K]"},
    /* 152 */ {"Pseudo Pot", "Pseudopotentielle Temperatur [K]"},
    /* 153 */ {"Aequi T", "Aequivalent-Temperatur [K]"},
    /* 154 */ {"Aequi Pot", "Aequivalentpotentielle Temperatur [K]"},
    /* 155 */ {"var155", "undefined"},
    /* 156 */ {"var156", "undefined"},
    /* 157 */ {"var157", "undefined"},
    /* 158 */ {"var158", "undefined"},
    /* 159 */ {"var159", "undefined"},
    /* 160 */ {"Bas St Wol", "Untergrenze strat. Bew|lkung [hft]"},
    /* 161 */ {"Bas St Wol", "Untergrenze strat. Bew|lkung [hPa]"},
    /* 162 */ {"Bas Cu Wol", "Untergrenze cumul. Bew|lkung [hft]"},
    /* 163 */ {"Bas Cu Wol", "Untergrenze cumul. Bew|lkung [hPa]"},
    /* 164 */ {"Top St Wol", "Obergrenze strat. Bew|lkung [hft]"},
    /* 165 */ {"Top St Wol", "Obergrenze strat. Bew|lkung [hPa]"},
    /* 166 */ {"Top Cu Wol", "Obergrenze cumul. Bew|lkung [hft]"},
    /* 167 */ {"Top Cu Wol", "Obergrenze cumul. Bew|lkung [hPa]"},
    /* 168 */ {"var168", "undefined"},
    /* 169 */ {"var169", "undefined"},
    /* 170 */ {"Bas Tur Wo", "Untergrenze Wolkenturbulenz [hft]"},
    /* 171 */ {"Bas Tur Wo", "Untergrenze Wolkenturbulenz [hPa]"},
    /* 172 */ {"Top Tur Wo", "Obergrenze Wolkenturbulenz [hft]"},
    /* 173 */ {"Top Tur Wo", "Obergrenze Wolkenturbulenz [hPa]"},
    /* 174 */ {"Bas Eis Wo", "Untergrenze Vereisung in Wolken [hft]"},
    /* 175 */ {"Bas Eis Wo", "Untergrenze Vereisung in Wolken [hPa]"},
    /* 176 */ {"Top Eis Wo", "Obergrenze Vereisung in Wolken [hft]"},
    /* 177 */ {"Top Eis Wo", "Obergrenze Vereisung in Wolken [hPa]"},
    /* 178 */ {"Int Tur Wo", "Intensitaet der Turbulenz in Wolken  (0..4) [1]"},
    /* 179 */ {"Int Eis Wo", "Intensitaet der Vereisung  (0..4) [1]"},
    /* 180 */ {"var180", "undefined"},
    /* 181 */ {"var181", "undefined"},
    /* 182 */ {"var182", "undefined"},
    /* 183 */ {"var183", "undefined"},
    /* 184 */ {"var184", "undefined"},
    /* 185 */ {"var185", "undefined"},
    /* 186 */ {"var186", "undefined"},
    /* 187 */ {"var187", "undefined"},
    /* 188 */ {"var188", "undefined"},
    /* 189 */ {"var189", "undefined"},
    /* 190 */ {"Sichtweite", "Sichtweite [m]"},
    /* 191 */ {"PIP_degree", "Prognostic Icing"},
    /* 192 */ {"PIP_scenar", "Prog Icing"},
    /* 193 */ {"DIP_degree", "Diagnostic Icing"},
    /* 194 */ {"DIP_scenar", "Diag Icing"},
    /* 195 */ {"IcingGuess", "Icing Regime 1.Guess(1=gen,2=conv,3=strat,4=freez) [1]"},
    /* 196 */ {"IcingGrade", "Icing Grade (1=LGT,2=MOD,3=SEV) [1]"},
    /* 197 */ {"IcingRegim", "Icing Regime(1=general,2=convect,3=strat,4=freez) [1]"},
    /* 198 */ {"var198", "undefined"},
    /* 199 */ {"var199", "undefined"},
    /* 200 */ {"Gru Wetter", "Wetter - Grundzustand   (ww"},
    /* 201 */ {"Lok Wetter", "Wetter - 1. lokale Abweichung  (ww"},
    /* 202 */ {"Lok Wetter", "Wetter - 2. lokale Abweichung  (ww"},
    /* 203 */ {"CLDEPTH", "cloud depth (grey scale"},
    /* 204 */ {"CLCT_MOD", "modified total cloud cover  (0..1) [1]"},
    /* 205 */ {"curr weath", "current weather (symbol number"},
    /* 206 */ {"var206", "undefined"},
    /* 207 */ {"var207", "undefined"},
    /* 208 */ {"var208", "undefined"},
    /* 209 */ {"var209", "undefined"},
    /* 210 */ {"var210", "undefined"},
    /* 211 */ {"Cu", "Cumulus  (0..1) [1]"},
    /* 212 */ {"Cb", "Cumulimbus  (0..1) [1]"},
    /* 213 */ {"Sc", "Stratocumulus  (0..1) [1]"},
    /* 214 */ {"Ac", "Altocumulus  (0..1) [1]"},
    /* 215 */ {"Ci", "Cirrus  (0..1) [1]"},
    /* 216 */ {"St", "Stratus  (0..1) [1]"},
    /* 217 */ {"As", "Altostratus  (0..1) [1]"},
    /* 218 */ {"var218", "undefined"},
    /* 219 */ {"var219", "undefined"},
    /* 220 */ {"var220", "undefined"},
    /* 221 */ {"Bedeckung", "Bedeckung in Stufen [1]"},
    /* 222 */ {"Konvektion", "Konvektion  ja/nein [1]"},
    /* 223 */ {"MN >90%", "Gesamtbedeckung > 90%  ja/nein [1]"},
    /* 224 */ {"RF700 >89%", "relative Feuchte 700 hPa >= 90%  ja/nein [1]"},
    /* 225 */ {"RR12 zentr", "Niederschlag 12 std. zentriert [mm]"},
    /* 226 */ {"RR12 <=0.5", "Niederschlag 12 std. zentriert, Werte <= 0.5mm [mm]"},
    /* 227 */ {"RR12 SA>60", "RR12 zentriert, Schneeanteil > 60%  ja/nein [1]"},
    /* 228 */ {"RR12 Kv>60", "RR12 zentriert, konvektiver Anteil > 60%  ja/nein [1]"},
    /* 229 */ {"SRR12ff", "Starkniederschlag in Stufen (12 std. Folgezeitr) [1]"},
    /* 230 */ {"RRMAX/STD", "Maximaler Starkniederschlag / std [mm/h]"},
    /* 231 */ {"RRMAX/MIN", "Maximaler Starkniederschlag / min [mm/min]"},
    /* 232 */ {"SN12ff >15", "Schneefall (12std. Folgezeitraum) > 15 mm  ja/nein [1]"},
    /* 233 */ {"RRgefr12ff", "gefrierender Regen (12std. Folgezeitraum)  ja/nein [1]"},
    /* 234 */ {"FFboe", "Boeenstaerke in Stufen [1]"},
    /* 235 */ {"Gewitter", "Gewitter in Stufen [1]"},
    /* 236 */ {"Tx2m12h ze", "2m Maximumtemperatur 12h zentriert [Grad Celsius]"},
    /* 237 */ {"Tn2m12h ze", "2m Minimumtemperatur 12h zentriert [Grad Celsius]"},
    /* 238 */ {"var238", "undefined"},
    /* 239 */ {"var239", "undefined"},
    /* 240 */ {"var240", "undefined"},
    /* 241 */ {"var241", "undefined"},
    /* 242 */ {"var242", "undefined"},
    /* 243 */ {"var243", "undefined"},
    /* 244 */ {"var244", "undefined"},
    /* 245 */ {"var245", "undefined"},
    /* 246 */ {"var246", "undefined"},
    /* 247 */ {"var247", "undefined"},
    /* 248 */ {"var248", "undefined"},
    /* 249 */ {"var249", "undefined"},
    /* 250 */ {"var250", "undefined"},
    /* 251 */ {"SCHWUELIND", "Schwuele-Index [1]"},
    /* 252 */ {"SMOGSTUFEN", "Smog-Intensitaetsstufen [1]"},
    /* 253 */ {"var253", "undefined"},
    /* 254 */ {"SMOGHOEHE", "Obergrenze Smog  ( Inversionshoehe ) [m]"},
    /* 255 */ {"var255", "undefined"},
};
