#include "cnames.h"

const struct ParmTable parm_table_mdl_nceptab[256] = {
      /* 0 */ {"var0", "undefined"},
      /* 1 */ {"PRES", "Pressure [Pa]"},
      /* 2 */ {"PRMSL", "Pressure reduced to MSL [Pa]"},
      /* 3 */ {"PTEND", "Pressure tendency [Pa/s]"},
      /* 4 */ {"PVORT", "Pot. vorticity [km^2/kg/s]"},
      /* 5 */ {"ICAHT", "ICAO Standard Atmosphere Reference Height [M]"},
      /* 6 */ {"GP", "Geopotential [m^2/s^2]"},
      /* 7 */ {"HGT", "Geopotential height [gpm]"},
      /* 8 */ {"DIST", "Geometric height [m]"},
      /* 9 */ {"HSTDV", "Std dev of height [m]"},
      /* 10 */ {"TOZNE", "Total ozone [Dobson]"},
      /* 11 */ {"TMP", "Temp. [K]"},
      /* 12 */ {"VTMP", "Virtual temp. [K]"},
      /* 13 */ {"POT", "Potential temp. [K]"},
      /* 14 */ {"EPOT", "Pseudo-adiabatic pot. temp. [K]"},
      /* 15 */ {"TMAX", "Max. temp. [K]"},
      /* 16 */ {"TMIN", "Min. temp. [K]"},
      /* 17 */ {"DPT", "Dew point temp. [K]"},
      /* 18 */ {"DEPR", "Dew point depression [K]"},
      /* 19 */ {"LAPR", "Lapse rate [K/m]"},
      /* 20 */ {"VIS", "Visibility [m]"},
      /* 21 */ {"RDSP1", "Radar spectra (1) [non-dim]"},
      /* 22 */ {"RDSP2", "Radar spectra (2) [non-dim]"},
      /* 23 */ {"RDSP3", "Radar spectra (3) [non-dim]"},
      /* 24 */ {"PLI", "Parcel lifted index (to 500 hPa) [K]"},
      /* 25 */ {"TMPA", "Temp. anomaly [K]"},
      /* 26 */ {"PRESA", "Pressure anomaly [Pa]"},
      /* 27 */ {"GPA", "Geopotential height anomaly [gpm]"},
      /* 28 */ {"WVSP1", "Wave spectra (1) [non-dim]"},
      /* 29 */ {"WVSP2", "Wave spectra (2) [non-dim]"},
      /* 30 */ {"WVSP3", "Wave spectra (3) [non-dim]"},
      /* 31 */ {"WDIR", "Wind direction [deg]"},
      /* 32 */ {"WIND", "Wind speed [m/s]"},
      /* 33 */ {"UGRD", "u wind [m/s]"},
      /* 34 */ {"VGRD", "v wind [m/s]"},
      /* 35 */ {"STRM", "Stream function [m^2/s]"},
      /* 36 */ {"VPOT", "Velocity potential [m^2/s]"},
      /* 37 */ {"MNTSF", "Montgomery stream function [m^2/s^2]"},
      /* 38 */ {"SGCVV", "Sigma coord. vertical velocity [/s]"},
      /* 39 */ {"VVEL", "Pressure vertical velocity [Pa/s]"},
      /* 40 */ {"DZDT", "Geometric vertical velocity [m/s]"},
      /* 41 */ {"ABSV", "Absolute vorticity [/s]"},
      /* 42 */ {"ABSD", "Absolute divergence [/s]"},
      /* 43 */ {"RELV", "Relative vorticity [/s]"},
      /* 44 */ {"RELD", "Relative divergence [/s]"},
      /* 45 */ {"VUCSH", "Vertical u shear [/s]"},
      /* 46 */ {"VVCSH", "Vertical v shear [/s]"},
      /* 47 */ {"DIRC", "Direction of current [deg]"},
      /* 48 */ {"SPC", "Speed of current [m/s]"},
      /* 49 */ {"UOGRD", "u of current [m/s]"},
      /* 50 */ {"VOGRD", "v of current [m/s]"},
      /* 51 */ {"SPFH", "Specific humidity [kg/kg]"},
      /* 52 */ {"RH", "Relative humidity [%]"},
      /* 53 */ {"MIXR", "Humidity mixing ratio [kg/kg]"},
      /* 54 */ {"PWAT", "Precipitable water [kg/m^2]"},
      /* 55 */ {"VAPP", "Vapor pressure [Pa]"},
      /* 56 */ {"SATD", "Saturation deficit [Pa]"},
      /* 57 */ {"EVP", "Evaporation [kg/m^2]"},
      /* 58 */ {"CICE", "Cloud Ice [kg/m^2]"},
      /* 59 */ {"PRATE", "Precipitation rate [kg/m^2/s]"},
      /* 60 */ {"TSTM", "Thunderstorm probability [%]"},
      /* 61 */ {"APCP", "Total precipitation [kg/m^2]"},
      /* 62 */ {"NCPCP", "Large scale precipitation [kg/m^2]"},
      /* 63 */ {"ACPCP", "Convective precipitation [kg/m^2]"},
      /* 64 */ {"SRWEQ", "Snowfall rate water equiv. [kg/m^2/s]"},
      /* 65 */ {"WEASD", "Accum. snow [kg/m^2]"},
      /* 66 */ {"SNOD", "Snow depth [m]"},
      /* 67 */ {"MIXHT", "Mixed layer depth [m]"},
      /* 68 */ {"TTHDP", "Transient thermocline depth [m]"},
      /* 69 */ {"MTHD", "Main thermocline depth [m]"},
      /* 70 */ {"MTHA", "Main thermocline anomaly [m]"},
      /* 71 */ {"TCDC", "Total cloud cover [%]"},
      /* 72 */ {"CDCON", "Convective cloud cover [%]"},
      /* 73 */ {"LCDC", "Low level cloud cover [%]"},
      /* 74 */ {"MCDC", "Mid level cloud cover [%]"},
      /* 75 */ {"HCDC", "High level cloud cover [%]"},
      /* 76 */ {"CWAT", "Cloud water [kg/m^2]"},
      /* 77 */ {"BLI", "Best lifted index (to 500 hPa) [K]"},
      /* 78 */ {"SNOC", "Convective snow [kg/m^2]"},
      /* 79 */ {"SNOL", "Large scale snow [kg/m^2]"},
      /* 80 */ {"WTMP", "Water temp. [K]"},
      /* 81 */ {"LAND", "Land cover (land=1;sea=0) [fraction]"},
      /* 82 */ {"DSLM", "Deviation of sea level from mean [m]"},
      /* 83 */ {"SFCR", "Surface roughness [m]"},
      /* 84 */ {"ALBDO", "Albedo [%]"},
      /* 85 */ {"TSOIL", "Soil temp. [K]"},
      /* 86 */ {"SOILM", "Soil moisture content [kg/m^2]"},
      /* 87 */ {"VEG", "Vegetation [%]"},
      /* 88 */ {"SALTY", "Salinity [kg/kg]"},
      /* 89 */ {"DEN", "Density [kg/m^3]"},
      /* 90 */ {"WATR", "Water runoff [kg/m^2]"},
      /* 91 */ {"ICEC", "Ice concentration (ice=1;no ice=0) [fraction]"},
      /* 92 */ {"ICETK", "Ice thickness [m]"},
      /* 93 */ {"DICED", "Direction of ice drift [deg]"},
      /* 94 */ {"SICED", "Speed of ice drift [m/s]"},
      /* 95 */ {"UICE", "u of ice drift [m/s]"},
      /* 96 */ {"VICE", "v of ice drift [m/s]"},
      /* 97 */ {"ICEG", "Ice growth rate [m/s]"},
      /* 98 */ {"ICED", "Ice divergence [/s]"},
      /* 99 */ {"SNOM", "Snow melt [kg/m^2]"},
      /* 100 */ {"HTSGW", "Sig height of wind waves and swell [m]"},
      /* 101 */ {"WVDIR", "Direction of wind waves [deg]"},
      /* 102 */ {"WVHGT", "Sig height of wind waves [m]"},
      /* 103 */ {"WVPER", "Mean period of wind waves [s]"},
      /* 104 */ {"SWDIR", "Direction of swell waves [deg]"},
      /* 105 */ {"SWELL", "Sig height of swell waves [m]"},
      /* 106 */ {"SWPER", "Mean period of swell waves [s]"},
      /* 107 */ {"DIRPW", "Primary wave direction [deg]"},
      /* 108 */ {"PERPW", "Primary wave mean period [s]"},
      /* 109 */ {"DIRSW", "Secondary wave direction [deg]"},
      /* 110 */ {"PERSW", "Secondary wave mean period [s]"},
      /* 111 */ {"NSWRS", "Net short wave (surface) [W/m^2]"},
      /* 112 */ {"NLWRS", "Net long wave (surface) [W/m^2]"},
      /* 113 */ {"NSWRT", "Net short wave (top) [W/m^2]"},
      /* 114 */ {"NLWRT", "Net long wave (top) [W/m^2]"},
      /* 115 */ {"LWAVR", "Long wave [W/m^2]"},
      /* 116 */ {"SWAVR", "Short wave [W/m^2]"},
      /* 117 */ {"GRAD", "Global radiation [W/m^2]"},
      /* 118 */ {"BRTMP", "Brightness temperature [K]"},
      /* 119 */ {"LWRAD", "Radiance with respect to wave no. [W/m/sr]"},
      /* 120 */ {"SWRAD", "Radiance with respect ot wave len. [W/m^3/sr]"},
      /* 121 */ {"LHTFL", "Latent heat flux [W/m^2]"},
      /* 122 */ {"SHTFL", "Sensible heat flux [W/m^2]"},
      /* 123 */ {"BLYDP", "Boundary layer dissipation [W/m^2]"},
      /* 124 */ {"UFLX", "Zonal momentum flux [N/m^2]"},
      /* 125 */ {"VFLX", "Meridional momentum flux [N/m^2]"},
      /* 126 */ {"WMIXE", "Wind mixing energy [J]"},
      /* 127 */ {"IMGD", "Image data []"},
      /* 128 */ {"TMPF", "TEMPERATURE (Fahrenheit) [F]"},
      /* 129 */ {"MAXK", "DAYTIME MAX TEMP (MAX) (Kelvin) [K]"},
      /* 130 */ {"MAXF", "DAYTIME MAX TEMP (MAX) (deg F) [F]"},
      /* 131 */ {"NMAXK", "NORMAL MAX TEMPERATURE (Kelvin) [K]"},
      /* 132 */ {"NMAXF", "NORMAL MAX TEMPERATURE (deg F) [F]"},
      /* 133 */ {"DMAXK", "DEPARTURE FROM NORMAL MAX (K) [K]"},
      /* 134 */ {"DMAXF", "DEPARTURE FROM NORMAL MAX (deg F) [F]"},
      /* 135 */ {"MINK", "NIGHTTIME MIN TEMP (MIN) (Kelvin) [K]"},
      /* 136 */ {"MINF", "NIGHTTIME MIN TEMP (MIN) (deg F) [F]"},
      /* 137 */ {"NMINK", "NORMAL MIN TEMPERATURE (Kelvin) [K]"},
      /* 138 */ {"NMINF", "NORMAL NIGHTTIME MIN TEMP (deg F) [F]"},
      /* 139 */ {"DMINK", "DEPARTURE FROM NORMAL MIN (K) [K]"},
      /* 140 */ {"DMINF", "DEPARTURE FROM NORMAL MIN (deg F) [F]"},
      /* 141 */ {"DWPF", "DEW POINT TEMPERATURE (deg F) [F]"},
      /* 142 */ {"DPDF", "DEW POINT DEPRESSION (deg F) [F]"},
      /* 143 */ {"HTINF", "HEAT INDEX (deg F) [F]"},
      /* 144 */ {"WNCHF", "WIND CHILL (deg F) [F]"},
      /* 145 */ {"var145", "undefined"},
      /* 146 */ {"POP", "PROB OF 0.01 IN. OF PRECIP (PoP) [%]"},
      /* 147 */ {"PQPF2", "PROB OF QPF >= 0.10 INCHES [%]"},
      /* 148 */ {"PQPF3", "PROB OF QPF >= 0.25 INCHES [%]"},
      /* 149 */ {"PQPF4", "PROB OF QPF >= 0.50 INCHES [%]"},
      /* 150 */ {"PQPF5", "PROB OF QPF >= 1.00 INCHES [%]"},
      /* 151 */ {"PQPF6", "PROB OF QPF >= 2.00 INCHES [%]"},
      /* 152 */ {"PQPF7", "PROB OF QPF >= 3.00 INCHES FUTURE [%]"},
      /* 153 */ {"BQPF", "BEST CATEGORY OF QPF [num]"},
      /* 154 */ {"NPOP", "NML REL. FREQ. OF 0.01 IN OF PCP [%]"},
      /* 155 */ {"DPOP", "DEPARTURE FROM NML OF 0.01 POP [%]"},
      /* 156 */ {"PCPM", "EXPECTED VALUE OF PRECIPITATION [mm]"},
      /* 157 */ {"PCPI", "EXPECTED VALUE OF PRECIPITATION [in]"},
      /* 158 */ {"CPCPM", "CONDITIONAL EXPECTED PRECIP AMT [mm]"},
      /* 159 */ {"CPCPI", "CONDITIONAL EXPECTED PRECIP AMT [in]"},
      /* 160 */ {"PSNA1", "PROB OF SNOW AMOUNT >= 0.10 [%]"},
      /* 161 */ {"PSNA2", "PROB OF SNOW AMOUNT >= 2 INCHES [%]"},
      /* 162 */ {"PSNA3", "PROB OF SNOW AMOUNT >= 4 INCHES [%]"},
      /* 163 */ {"PSNA4", "PROB OF SNOW AMOUNT >= 6 INCHES [%]"},
      /* 164 */ {"PSNA5", "PROB OF SNOW AMOUNT >= 8 INCHES [%]"},
      /* 165 */ {"BSNA", "BEST CATEGORY FOR SNOW AMOUNT [num]"},
      /* 166 */ {"SNWM", "EXPECTED VALUE OF SNOW AMOUNT [mm]"},
      /* 167 */ {"SNWI", "EXPECTED VALUE OF SNOW AMOUNT [in]"},
      /* 168 */ {"MWSPK", "INFLATED MAX WIND SPEED (knots) [kts]"},
      /* 169 */ {"IWSPM", "INFLATED WIND SPEED (meter/sec) [m/s]"},
      /* 170 */ {"SKNT", "INFLATED WIND SPEED (knots) [kts]"},
      /* 171 */ {"PWSP1", "PROB OF MAX WIND SPEED 0-12 kts [%]"},
      /* 172 */ {"PWSP2", "PROB OF MAX WIND SPEED 13-21 kts [%]"},
      /* 173 */ {"PWSP3", "PROB OF MAX WIND SPEED 22-31 kts [%]"},
      /* 174 */ {"PWSP4", "PROB OF MAX WIND SPEED >=32 kts [%]"},
      /* 175 */ {"WSPDC", "CATEGORICAL MAX WIND SPEED [num]"},
      /* 176 */ {"XSPDM", "EXPECTED VALUE OF MAX WIND SPEED [m/s]"},
      /* 177 */ {"XSPDK", "EXPECTED VALUE OF MAX WIND SPEED [kts]"},
      /* 178 */ {"PWDRN", "PROB OF WIND DIRECTION NORTH [%]"},
      /* 179 */ {"PWDRNE", "PROB OF WIND DIRECTION NORTHEAST [%]"},
      /* 180 */ {"PWDRE", "PROB OF WIND DIRECTION EAST [%]"},
      /* 181 */ {"PWDRSE", "PROB OF WIND DIRECTION SOUTHEAST [%]"},
      /* 182 */ {"PWDRS", "PROB OF WIND DIRECTION SOUTH [%]"},
      /* 183 */ {"PWDRSW", "PROB OF WIND DIRECTION SOUTHWEST [%]"},
      /* 184 */ {"PWDRW", "PROB OF WIND DIRECTION WEST [%]"},
      /* 185 */ {"PWDRNW", "PROB OF WIND DIRECTION NORTHWEST [%]"},
      /* 186 */ {"WDIRC", "CATEGORICAL WIND DIRECTION [num]"},
      /* 187 */ {"var187", "undefined"},
      /* 188 */ {"PSKCL", "PROB OF TOTAL SKY"},
      /* 189 */ {"PSKFW", "PROB OF TOTAL SKY"},
      /* 190 */ {"PSKSC", "PROB OF TOTAL SKY"},
      /* 191 */ {"PSKBK", "PROB OF TOTAL SKY"},
      /* 192 */ {"PSKOV", "PROB OF TOTAL SKY"},
      /* 193 */ {"SKYC", "CATEGORICAL TOTAL SKY COVER [num]"},
      /* 194 */ {"MSKCL", "PROB MEAN SKY CVR"},
      /* 195 */ {"MSKOV", "PROB MEAN SKY CVR"},
      /* 196 */ {"MSKMC", "PROB MEAN SKY CVR"},
      /* 197 */ {"MSKPC", "PROB MEAN SKY CVR"},
      /* 198 */ {"MSKMO", "PROB MEAN SKY CVR"},
      /* 199 */ {"MSKYC", "CATEGORICAL MEAN SKY COVER [num]"},
      /* 200 */ {"PCIG1", "PROB OF CIG HGT < 200 FT [%]"},
      /* 201 */ {"PCIG2", "PROB OF CIG HGT 200-400 FT [%]"},
      /* 202 */ {"PCIG3", "PROB OF CIG HGT 500-900 FT [%]"},
      /* 203 */ {"PCIG4", "PROB OF CIG HGT 1000-3000 FT [%]"},
      /* 204 */ {"PCIG5", "PROB OF CIG HGT 3100-6500 FT [%]"},
      /* 205 */ {"PCIG6", "PROB OF CIG HGT 6600-12000 FT [%]"},
      /* 206 */ {"PCIG7", "PROB OF CIG HGT > 12000 FT [%]"},
      /* 207 */ {"BCIG", "BEST CATEGORY OF CEILING HEIGHT [num]"},
      /* 208 */ {"PVIS1", "PROB OF VIS <=1/4 MILE [%]"},
      /* 209 */ {"PVIS2", "PROB OF VIS <=1/2 MILE [%]"},
      /* 210 */ {"PVIS3", "PROB OF VIS <=7/8 MILE [%]"},
      /* 211 */ {"PVIS4", "PROB OF VIS <=2 3/4 MILES [%]"},
      /* 212 */ {"PVIS5", "PROB OF VIS <=5 MILES [%]"},
      /* 213 */ {"PVIS6", "PROB OF VIS <=6 MILES [%]"},
      /* 214 */ {"VISC", "CATEGORICAL VISIBILITY [num]"},
      /* 215 */ {"POBVN", "PROB OF OBSTRUCTION TO VIS"},
      /* 216 */ {"POBVH", "PROB OF OBSTRUCTION TO VIS"},
      /* 217 */ {"POBVM", "PROB OF OBSTRUCTION TO VIS"},
      /* 218 */ {"POBVF", "PROB OF OBSTRUCTION TO VIS"},
      /* 219 */ {"POVBL", "PROB OF BLOWING OBVIS [%]"},
      /* 220 */ {"OBVC", "BEST CATEGORY OF OBVIS [num]"},
      /* 221 */ {"var221", "undefined"},
      /* 222 */ {"NTSM", "NORMAL PROB OF THUNDERSTORMS [%]"},
      /* 223 */ {"CSVR", "COND PROB OF SEVERE WEATHER [%]"},
      /* 224 */ {"USVR", "UNCOND PROB OF SEVERE WX [%]"},
      /* 225 */ {"NSVR", "NORMAL PROB OF SEVERE WX [%]"},
      /* 226 */ {"UHAI", "UNCONDITIONAL PROB OF HAIL [%]"},
      /* 227 */ {"UTOR", "UNCONDITIONAL PROB OF TORNADO [%]"},
      /* 228 */ {"UTSW", "UNCOND PROB OF DAMAGING WIND [%]"},
      /* 229 */ {"CFZI", "COND PROB FRZING PRECIP (INSTANT) [%]"},
      /* 230 */ {"UFZI", "UNCND PROB FRZING PRECIP (INSTNT) [%]"},
      /* 231 */ {"CZNI", "COND PROB FROZEN PRECIP (INSTANT) [%]"},
      /* 232 */ {"UZNI", "UNCND PROB FROZEN PRECIP (INSTNT) [%]"},
      /* 233 */ {"CLQI", "COND PROB LIQUID PRECIP (INSTANT) [%]"},
      /* 234 */ {"ULQI", "UNCND PROB LIQUID PRECIP (INSTNT) [%]"},
      /* 235 */ {"PTYPI", "CATEGORICAL PRECIP TYPE (INSTANT) [num]"},
      /* 236 */ {"CPOZP", "COND PROB OF FRZING PRECIP [%]"},
      /* 237 */ {"UPOZP", "UNCOND PROB OF FRZING PRECIP [%]"},
      /* 238 */ {"CPOS", "COND PROB OF SNOW (CPoS) [%]"},
      /* 239 */ {"UPOS", "UNCOND PROB OF SNOW (CPoS) [%]"},
      /* 240 */ {"CPORS", "COND PROB OF RAIN/SNOW MIXED [%]"},
      /* 241 */ {"UPORS", "UNCOND PROB OF RAIN/SNOW MIXED [%]"},
      /* 242 */ {"CPORA", "COND PROB OF RAIN [%]"},
      /* 243 */ {"var243", "undefined"},
      /* 244 */ {"BPCPT", "BEST CATEGORY OF PRECIP TYPE [num]"},
      /* 245 */ {"POPOH", "POPO PRECIP OCCURRING AT AN HOUR [%]"},
      /* 246 */ {"POPOP", "POPO PRECIP DURING A PERIOD [%]"},
      /* 247 */ {"CPDRZ", "COND PROB OF DRIZZLE [%]"},
      /* 248 */ {"CPSTY", "COND PROB OF CONT (STEADY) PRECIP [%]"},
      /* 249 */ {"CPSHW", "COND PROB OF SHOWERS [%]"},
      /* 250 */ {"BPCHR", "BEST CAT PRECIP CHARACTERISTIC [num]"},
      /* 251 */ {"SUNSH", "PERCENT OF POSSIBLE SUNSHINE [%]"},
      /* 252 */ {"HRSUN", "HOURS OF SUNSHINE [hrs]"},
      /* 253 */ {"SCQP", "SCAN 0-3H CATEGORICAL QPF [num]"},
      /* 254 */ {"SCTS", "SCAN 0-3H C-G LIGHTNING PROB [%]"},
      /* 255 */ {"var255", "undefined"},
};
