#include "cnames.h"

const struct ParmTable parm_table_nceptab_129[256] = {
      /* 0 */ {"var0", "undefined"},
      /* 1 */ {"PRES", "Pressure [Pa]"},
      /* 2 */ {"PRMSL", "Pressure reduced to MSL [Pa]"},
      /* 3 */ {"PTEND", "Pressure tendency [Pa/s]"},
      /* 4 */ {"PVORT", "Pot. vorticity [km^2/kg/s]"},
      /* 5 */ {"ICAHT", "ICAO Standard Atmosphere Reference Height [M]"},
      /* 6 */ {"GP", "Geopotential [m^2/s^2]"},
      /* 7 */ {"HGT", "Geopotential height [gpm]"},
      /* 8 */ {"DIST", "Geometric height [m]"},
      /* 9 */ {"HSTDV", "Std dev of height [m]"},
      /* 10 */ {"TOZNE", "Total ozone [Dobson]"},
      /* 11 */ {"TMP", "Temp. [K]"},
      /* 12 */ {"VTMP", "Virtual temp. [K]"},
      /* 13 */ {"POT", "Potential temp. [K]"},
      /* 14 */ {"EPOT", "Pseudo-adiabatic pot. temp. [K]"},
      /* 15 */ {"TMAX", "Max. temp. [K]"},
      /* 16 */ {"TMIN", "Min. temp. [K]"},
      /* 17 */ {"DPT", "Dew point temp. [K]"},
      /* 18 */ {"DEPR", "Dew point depression [K]"},
      /* 19 */ {"LAPR", "Lapse rate [K/m]"},
      /* 20 */ {"VIS", "Visibility [m]"},
      /* 21 */ {"RDSP1", "Radar spectra (1) [non-dim]"},
      /* 22 */ {"RDSP2", "Radar spectra (2) [non-dim]"},
      /* 23 */ {"RDSP3", "Radar spectra (3) [non-dim]"},
      /* 24 */ {"PLI", "Parcel lifted index (to 500 hPa) [K]"},
      /* 25 */ {"TMPA", "Temp. anomaly [K]"},
      /* 26 */ {"PRESA", "Pressure anomaly [Pa]"},
      /* 27 */ {"GPA", "Geopotential height anomaly [gpm]"},
      /* 28 */ {"WVSP1", "Wave spectra (1) [non-dim]"},
      /* 29 */ {"WVSP2", "Wave spectra (2) [non-dim]"},
      /* 30 */ {"WVSP3", "Wave spectra (3) [non-dim]"},
      /* 31 */ {"WDIR", "Wind direction [deg]"},
      /* 32 */ {"WIND", "Wind speed [m/s]"},
      /* 33 */ {"UGRD", "u wind [m/s]"},
      /* 34 */ {"VGRD", "v wind [m/s]"},
      /* 35 */ {"STRM", "Stream function [m^2/s]"},
      /* 36 */ {"VPOT", "Velocity potential [m^2/s]"},
      /* 37 */ {"MNTSF", "Montgomery stream function [m^2/s^2]"},
      /* 38 */ {"SGCVV", "Sigma coord. vertical velocity [/s]"},
      /* 39 */ {"VVEL", "Pressure vertical velocity [Pa/s]"},
      /* 40 */ {"DZDT", "Geometric vertical velocity [m/s]"},
      /* 41 */ {"ABSV", "Absolute vorticity [/s]"},
      /* 42 */ {"ABSD", "Absolute divergence [/s]"},
      /* 43 */ {"RELV", "Relative vorticity [/s]"},
      /* 44 */ {"RELD", "Relative divergence [/s]"},
      /* 45 */ {"VUCSH", "Vertical u shear [/s]"},
      /* 46 */ {"VVCSH", "Vertical v shear [/s]"},
      /* 47 */ {"DIRC", "Direction of current [deg]"},
      /* 48 */ {"SPC", "Speed of current [m/s]"},
      /* 49 */ {"UOGRD", "u of current [m/s]"},
      /* 50 */ {"VOGRD", "v of current [m/s]"},
      /* 51 */ {"SPFH", "Specific humidity [kg/kg]"},
      /* 52 */ {"RH", "Relative humidity [%]"},
      /* 53 */ {"MIXR", "Humidity mixing ratio [kg/kg]"},
      /* 54 */ {"PWAT", "Precipitable water [kg/m^2]"},
      /* 55 */ {"VAPP", "Vapor pressure [Pa]"},
      /* 56 */ {"SATD", "Saturation deficit [Pa]"},
      /* 57 */ {"EVP", "Evaporation [kg/m^2]"},
      /* 58 */ {"CICE", "Cloud Ice [kg/m^2]"},
      /* 59 */ {"PRATE", "Precipitation rate [kg/m^2/s]"},
      /* 60 */ {"TSTM", "Thunderstorm probability [%]"},
      /* 61 */ {"APCP", "Total precipitation [kg/m^2]"},
      /* 62 */ {"NCPCP", "Large scale precipitation [kg/m^2]"},
      /* 63 */ {"ACPCP", "Convective precipitation [kg/m^2]"},
      /* 64 */ {"SRWEQ", "Snowfall rate water equiv. [kg/m^2/s]"},
      /* 65 */ {"WEASD", "Accum. snow [kg/m^2]"},
      /* 66 */ {"SNOD", "Snow depth [m]"},
      /* 67 */ {"MIXHT", "Mixed layer depth [m]"},
      /* 68 */ {"TTHDP", "Transient thermocline depth [m]"},
      /* 69 */ {"MTHD", "Main thermocline depth [m]"},
      /* 70 */ {"MTHA", "Main thermocline anomaly [m]"},
      /* 71 */ {"TCDC", "Total cloud cover [%]"},
      /* 72 */ {"CDCON", "Convective cloud cover [%]"},
      /* 73 */ {"LCDC", "Low level cloud cover [%]"},
      /* 74 */ {"MCDC", "Mid level cloud cover [%]"},
      /* 75 */ {"HCDC", "High level cloud cover [%]"},
      /* 76 */ {"CWAT", "Cloud water [kg/m^2]"},
      /* 77 */ {"BLI", "Best lifted index (to 500 hPa) [K]"},
      /* 78 */ {"SNOC", "Convective snow [kg/m^2]"},
      /* 79 */ {"SNOL", "Large scale snow [kg/m^2]"},
      /* 80 */ {"WTMP", "Water temp. [K]"},
      /* 81 */ {"LAND", "Land cover (land=1;sea=0) [fraction]"},
      /* 82 */ {"DSLM", "Deviation of sea level from mean [m]"},
      /* 83 */ {"SFCR", "Surface roughness [m]"},
      /* 84 */ {"ALBDO", "Albedo [%]"},
      /* 85 */ {"TSOIL", "Soil temp. [K]"},
      /* 86 */ {"SOILM", "Soil moisture content [kg/m^2]"},
      /* 87 */ {"VEG", "Vegetation [%]"},
      /* 88 */ {"SALTY", "Salinity [kg/kg]"},
      /* 89 */ {"DEN", "Density [kg/m^3]"},
      /* 90 */ {"WATR", "Water runoff [kg/m^2]"},
      /* 91 */ {"ICEC", "Ice concentration (ice=1;no ice=0) [fraction]"},
      /* 92 */ {"ICETK", "Ice thickness [m]"},
      /* 93 */ {"DICED", "Direction of ice drift [deg]"},
      /* 94 */ {"SICED", "Speed of ice drift [m/s]"},
      /* 95 */ {"UICE", "u of ice drift [m/s]"},
      /* 96 */ {"VICE", "v of ice drift [m/s]"},
      /* 97 */ {"ICEG", "Ice growth rate [m/s]"},
      /* 98 */ {"ICED", "Ice divergence [/s]"},
      /* 99 */ {"SNOM", "Snow melt [kg/m^2]"},
      /* 100 */ {"HTSGW", "Sig height of wind waves and swell [m]"},
      /* 101 */ {"WVDIR", "Direction of wind waves [deg]"},
      /* 102 */ {"WVHGT", "Sig height of wind waves [m]"},
      /* 103 */ {"WVPER", "Mean period of wind waves [s]"},
      /* 104 */ {"SWDIR", "Direction of swell waves [deg]"},
      /* 105 */ {"SWELL", "Sig height of swell waves [m]"},
      /* 106 */ {"SWPER", "Mean period of swell waves [s]"},
      /* 107 */ {"DIRPW", "Primary wave direction [deg]"},
      /* 108 */ {"PERPW", "Primary wave mean period [s]"},
      /* 109 */ {"DIRSW", "Secondary wave direction [deg]"},
      /* 110 */ {"PERSW", "Secondary wave mean period [s]"},
      /* 111 */ {"NSWRS", "Net short wave (surface) [W/m^2]"},
      /* 112 */ {"NLWRS", "Net long wave (surface) [W/m^2]"},
      /* 113 */ {"NSWRT", "Net short wave (top) [W/m^2]"},
      /* 114 */ {"NLWRT", "Net long wave (top) [W/m^2]"},
      /* 115 */ {"LWAVR", "Long wave [W/m^2]"},
      /* 116 */ {"SWAVR", "Short wave [W/m^2]"},
      /* 117 */ {"GRAD", "Global radiation [W/m^2]"},
      /* 118 */ {"BRTMP", "Brightness temperature [K]"},
      /* 119 */ {"LWRAD", "Radiance with respect to wave no. [W/m/sr]"},
      /* 120 */ {"SWRAD", "Radiance with respect ot wave len. [W/m^3/sr]"},
      /* 121 */ {"LHTFL", "Latent heat flux [W/m^2]"},
      /* 122 */ {"SHTFL", "Sensible heat flux [W/m^2]"},
      /* 123 */ {"BLYDP", "Boundary layer dissipation [W/m^2]"},
      /* 124 */ {"UFLX", "Zonal momentum flux [N/m^2]"},
      /* 125 */ {"VFLX", "Meridional momentum flux [N/m^2]"},
      /* 126 */ {"WMIXE", "Wind mixing energy [J]"},
      /* 127 */ {"IMGD", "Image data []"},
      /* 128 */ {"PAOT", "Probability anomaly of temp [%]"},
      /* 129 */ {"PAOP", "Probability anomaly of precip [%]"},
      /* 130 */ {"CWR", "Probability of wetting rain > 0.1 in [%]"},
      /* 131 */ {"FRAIN", "Rain fraction of total liquid water []"},
      /* 132 */ {"FICE", "Ice fraction of total condensate []"},
      /* 133 */ {"FRIME", "Rime factor []"},
      /* 134 */ {"CUEFI", "Convective cloud efficiency []"},
      /* 135 */ {"TCOND", "Total condensate [kg/kg]"},
      /* 136 */ {"TCOLW", "Total column cloud water [kg/m/m]"},
      /* 137 */ {"TCOLI", "Total column cloud ice [kg/m/m]"},
      /* 138 */ {"TCOLR", "Total column rain [kg/m/m]"},
      /* 139 */ {"TCOLS", "Total column snow [kg/m/m]"},
      /* 140 */ {"TCOLC", "Total column condensate [kg/m/m]"},
      /* 141 */ {"PLPL", "Pressure of level from which parcel was lifted [Pa]"},
      /* 142 */ {"HLPL", "Height of level from which parcel was lifted [m]"},
      /* 143 */ {"CEMS", "Cloud Emissivity [fraction]"},
      /* 144 */ {"COPD", "Cloud Optical Depth [non-dim]"},
      /* 145 */ {"PSIZ", "Effective Particle size [microns]"},
      /* 146 */ {"TCWAT", "Total Water Cloud [%]"},
      /* 147 */ {"TCICE", "Total Ice Cloud [%]"},
      /* 148 */ {"WDIF", "Wind Difference [m/s]"},
      /* 149 */ {"WSTP", "Wave Steepness [non-dim]"},
      /* 150 */ {"PTAN", "Probability of Temp. above normal [%]"},
      /* 151 */ {"PTNN", "Probability of Temp. near normal [%]"},
      /* 152 */ {"PTBN", "Probability of Temp. below normal [%]"},
      /* 153 */ {"PPAN", "Probability of Precip. above normal [%]"},
      /* 154 */ {"PPNN", "Probability of Precip. near normal [%]"},
      /* 155 */ {"PPBN", "Probability of Precip. below normal [%]"},
      /* 156 */ {"PMTC", "Particulate matter (coarse) [ug/m^3]"},
      /* 157 */ {"PMTF", "Particulate matter (fine) [ug/m^3]"},
      /* 158 */ {"AETMP", "Analysis Error of Temperature [K]"},
      /* 159 */ {"AEDPT", "Analysis Error of Dew Point [K]"},
      /* 160 */ {"AESPH", "Analysis Error of Specific Humidity [kg/kg] wne"},
      /* 161 */ {"AEUWD", "Analysis Error of U-wind [m/s]"},
      /* 162 */ {"AEVWD", "Analysis Error of V-wind [m/s]"},
      /* 163 */ {"LPMTF", "Particulate matter (fine) [log10(ug/m^3)]"},
      /* 164 */ {"LIPMF", "Integrated Column Particulate matter (fine) [log10(ug/m^2)] wne"},
      /* 165 */ {"REFZR", "Derived radar reflectivity backscatter from rain [mm^6/m^3]"},
      /* 166 */ {"REFZI", "Derived radar reflectivity backscatter from ice [mm^6/m^3]"},
      /* 167 */ {"REFZC", "Derived radar reflectivity backscatter from parameterized convection [mm^6/m^3]"},
      /* 168 */ {"TCLSW", "Integrated supercooled liquid water [kg/m^2]"},
      /* 169 */ {"TCOLM", "Total Column Integrated Melting Ice [kg/m^2]"},
      /* 170 */ {"ELRDI", "Ellrod Index [non-dim]"},
      /* 171 */ {"TSEC", "Seconds prior to initial reference time [sec]"},
      /* 172 */ {"TSECA", "Seconds after initial reference time [sec]"},
      /* 173 */ {"NUM", "Number of samples/observations [non-dim]"},
      /* 174 */ {"AEPRS", "Analysis Error of Pressure [Pa]"},
      /* 175 */ {"ICSEV", "Icing Severity [non-dim]"},
      /* 176 */ {"ICPRB", "Icing Probability [non-dim]"},
      /* 177 */ {"LAVNI", "Low-level Aviation Interest [non-dim]"},
      /* 178 */ {"HAVNI", "High-level Aviation Interest [non-dim]"},
      /* 179 */ {"FLGHT", "Flight Category [non-dim]"},
      /* 180 */ {"OZCON", "Ozone concentration [ppb]"},
      /* 181 */ {"OZCAT", "Categorical ozone concentration [?]"},
      /* 182 */ {"VEDH", "vertical heat eddy diffusivity [m^2/s]"},
      /* 183 */ {"SIGV", "Sigma level value [non-dim]"},
      /* 184 */ {"EWGT", "Ensemble Weight [non-dim]"},
      /* 185 */ {"CICEL", "Confidence indicator - Ceiling [non-dim]"},
      /* 186 */ {"CIVIS", "Confidence indicator - Visibility [non-dim] 186"},
      /* 187 */ {"var187", "undefined"},
      /* 188 */ {"LAVV", "Latitude of V wind component of velocity [deg]"},
      /* 189 */ {"LOVV", "Longitude of V wind component of velocity [deg]"},
      /* 190 */ {"USCT", "Scatterometer est. U wind component [m/s]"},
      /* 191 */ {"VSCT", "Scatterometer est. V wind component [m/s]"},
      /* 192 */ {"LAUV", "Latitude of U wind component of velocity [deg]"},
      /* 193 */ {"LOUV", "Longitude of U wind component of velocity [deg]"},
      /* 194 */ {"TCHP", "Tropical Cyclone Heat Potential [J/m^2]"},
      /* 195 */ {"DBSS", "Geometric Depth Below Sea Surface [m]"},
      /* 196 */ {"ODHA", "Ocean Dynamic Heat Anomaly [dynamic m]"},
      /* 197 */ {"OHC", "Ocean Heat Content [J/m^2]"},
      /* 198 */ {"SSHG", "Sea Surface Height Relative to Geoid [m]"},
      /* 199 */ {"SLTFL", "Salt flux [g/cm^2/s]"},
      /* 200 */ {"DUVB", "UV-B Downward Solar Flux [W/m^2]"},
      /* 201 */ {"CDUVB", "Clear Sky UV-B Downward Solar Flux [W/m^2]"},
      /* 202 */ {"THFLX", "Total downward heat flux at surface [W/m^2]"},
      /* 203 */ {"UVAR", "U velocity variance [m^2/s^2]"},
      /* 204 */ {"VVAR", "V velocity variance [m^2/s^2]"},
      /* 205 */ {"UVVCC", "UV Velocity Cross Correlation [m^2/s^2]"},
      /* 206 */ {"MCLS", "Meteorological Correlation Length Scale [m]"},
      /* 207 */ {"LAPP", "Latitude of pressure point [deg]"},
      /* 208 */ {"LOPP", "Longitude of pressure point [deg]"},
      /* 209 */ {"var209", "undefined"},
      /* 210 */ {"REFO", "Observed radar reflectivity [dbZ]"},
      /* 211 */ {"REFD", "Derived radar reflectivity [dbZ]"},
      /* 212 */ {"REFC", "Maximum/Composite radar reflectivity [dbZ]"},
      /* 213 */ {"SBT122", "Simulated Brightness Temperature for GOES12, Channel 2 [K]"},
      /* 214 */ {"SBT123", "Simulated Brightness Temperature for GOES12, Channel 3 [K]"},
      /* 215 */ {"SBT124", "Simulated Brightness Temperature for GOES12, Channel 4 [K]"},
      /* 216 */ {"SBT125", "Simulated Brightness Temperature for GOES12, Channel 5 [K]"},
      /* 217 */ {"MINRH", "Minimum Relative Humumidity [%]"},
      /* 218 */ {"MAXRH", "Maximum Relative Humumidity [%]"},
      /* 219 */ {"CEIL", "Ceiling [m]"},
      /* 220 */ {"PBLREG", "Planetary boundary layer regime []"},
      /* 221 */ {"SBC123", "Simulated brightness counts for GOES12, Channel 3 [byte]"},
      /* 222 */ {"SBC124", "Simulated brightness counts for GOES12, Channel 4 [byte]"},
      /* 223 */ {"RPRATE", "Rain precipitation rate [kg/m^2/s]"},
      /* 224 */ {"SPRATE", "Snow precipitation rate [kg/m^2/s]"},
      /* 225 */ {"FPRATE", "Freezing rain precipitation rate [kg/m^2/s]"},
      /* 226 */ {"IPRATE", "Ice pellets precipitation rate [kg/m^2/s]"},
      /* 227 */ {"UPHL", "Updraft Helicity [m^2/s^2]"},
      /* 228 */ {"SURGE", "Storm Surge [m]"},
      /* 229 */ {"ETSRG", "Extra-tropical storm Surge [m]"},
      /* 230 */ {"RHPW", "Relative humidity with respect to precip water [%]"},
      /* 231 */ {"OZMAX1", "Ozone daily max from 1-hour ave [ppbV]"},
      /* 232 */ {"OZMAX8", "Ozone daily max from 8-hour ave [ppbV]"},
      /* 233 */ {"var233", "undefined"},
      /* 234 */ {"var234", "undefined"},
      /* 235 */ {"var235", "undefined"},
      /* 236 */ {"var236", "undefined"},
      /* 237 */ {"var237", "undefined"},
      /* 238 */ {"var238", "undefined"},
      /* 239 */ {"var239", "undefined"},
      /* 240 */ {"var240", "undefined"},
      /* 241 */ {"var241", "undefined"},
      /* 242 */ {"TCSRG20", "20% tropical cyclone storm exceedance [m]"},
      /* 243 */ {"TCSRG30", "30% tropical cyclone storm exceedance [m]"},
      /* 244 */ {"TCSRG40", "40% tropical cyclone storm exceedance [m]"},
      /* 245 */ {"TCSRG50", "50% tropical cyclone storm exceedance [m]"},
      /* 246 */ {"TCSRG60", "60% tropical cyclone storm exceedance [m]"},
      /* 247 */ {"TCSRG70", "70% tropical cyclone storm exceedance [m]"},
      /* 248 */ {"TCSRG80", "80% tropical cyclone storm exceedance [m]"},
      /* 249 */ {"TCSRG90", "90% tropical cyclone storm exceedance [m]"},
      /* 250 */ {"RETOP", "Radar echo top (18.3 DBZ) [m]"},
      /* 251 */ {"TENV", "Total energy norm variance []"},
      /* 252 */ {"var252", "undefined"},
      /* 253 */ {"var253", "undefined"},
      /* 254 */ {"var254", "undefined"},
      /* 255 */ {"var255", "undefined"},
};
