#!/bin/tcsh
# 
# This is a daily test script for H4CF Conversion Toolkit
cd /scr/hdfeos/src/h4cflib

# Check if there's any change in the source.
if ( -e svn.txt ) then
  mv svn.txt svn.old.txt
endif

svn up >& svn.txt
if ( -e svn.old.txt ) then
  diff -u svn.txt svn.old.txt > diff.out
endif

# Perform test if and only if there's a change.
if ( -s diff.out )  then
chmod u+x *.sh
# This is where NetCDF-4 is installed. 
set path=(/scr/hdfeos/bin $path)
./configure --with-hdfeos2=/scr/hdfeos --with-hdf4=/scr/hdfeos --with-jpeg=/scr/hdfeos
make
# Test APIs and fake data.
make check >& check.nc.txt
cp testsuite/h4cfTest.log check.nc.log.txt
# Test with real NASA files.
cp testsuite/h4cfTest.nc.at testsuite/h4cfTest.nc.at.orig
cp testsuite/h4cfTest.nc.nasa1.at testsuite/h4cfTest.nc.at
make check >& check.nc.nasa1.txt
cp testsuite/h4cfTest.log check.nc.nasa1.log.txt
cp testsuite/h4cfTest.nc.at.orig testsuite/h4cfTest.nc.at
make distclean

set path=(/scr/netcdf3/bin $path)
./configure --with-hdfeos2=/scr/hdfeos --with-hdf4=/scr/hdfeos --with-jpeg=/scr/hdfeos
make
# Test APIs and fake data.
make check >& check.nc3.txt
cp testsuite/h4cfTest.log check.nc3.log.txt
# Test with real NASA files.
cp testsuite/h4cfTest.nc3.at testsuite/h4cfTest.nc3.at.orig
cp testsuite/h4cfTest.nc3.nasa1.at testsuite/h4cfTest.nc3.at
make check >& check.nc3.nasa1.txt
cp testsuite/h4cfTest.log check.nc3.nasa1.log.txt
cp testsuite/h4cfTest.nc3.at.orig testsuite/h4cfTest.nc3.at
make distclean


set M="H4CF Conversion Toolkit test failure on "
set H=`hostname`
set S=`echo $M $H` 
grep 'failed unexpectedly' *.txt
set RETVAL=$?
[ $RETVAL -eq 0 ] && grep FAILED *.txt | mail -s "${S}" "hyoklee@hdfgroup.org"
endif
