// Copyright by The HDF Group.
// All rights reserved.                                                      
//                                                                           
// This file is part of the H4CF Conversion Toolkit. The full H4CF Conversion
// Toolkit copyright notice including terms governing use, modification, and 
// redistribution, is contained in the file COPYING.     
// COPYING can be found at the root of the source code    
// distribution tree. If you do not have access to this file, you may request
// a copy from eoshelp@hdfgroup.org.     
#include "h4cf.h"
#include <iostream>
#include <string>
#include <map>
#include <vector>
#include <list>


// This example code is to demonstrate how to open an HDF file and read the 
// specified data field.
int main(int argc, char* argv[])
{
    // Open file and initialize library.
    h4cf_open("geo.hdf"); 
	
    const list<var*> pvars = h4cf_get_vars();
    for(list<var*>::const_iterator var_iter = pvars.begin(); 
        var_iter != pvars.end(); 
        var_iter++)
        {
            // Find the specified variable according its name. In this case, 
            // the variable name is "temp".
            if(h4cf_get_var_name((*var_iter))=="temp")
		{
                    vector<char> vals;
                    // Obtain variable data. In this case, its dataset type is 
                    // double and its size is of 18*36.
                    h4cf_get_var_value(&vals, (*var_iter));
                    for(int i = 0; i < 18; i++) 
			{
                            // Print dataset out.
                            cout << "Row: " << i << endl;
                            for(int j=0; j<36; j++)
                                cout << 
                                    (double)*(float64*)
                                    &(vals[(i*36+j)* sizeof(float64)]) 
                                     << "\t";
                            cout << endl;
			} // for(int i = 0; i < 18; i++) 
		} // if(h4cf_get_var_name((*var_iter))=="temp")
	} // for(list<var*>::const_iterator var_iter = pvars.begin(); 
	
    h4cf_close(); // Close file and library.
	
    return 0;
}
