// Copyright by The HDF Group.
// All rights reserved.                                                      
//                                                                           
// This file is part of the H4CF Conversion Toolkit. The full H4CF Conversion
// Toolkit copyright notice including terms governing use, modification, and 
// redistribution, is contained in the file COPYING.     
// COPYING can be found at the root of the source code    
// distribution tree. If you do not have access to this file, you may request
// a copy from eoshelp@hdfgroup.org.     
#include "h4cf.h"
#include <iostream>
#include <string>
#include <map>
#include <vector>
#include <list>

// This example code is to demonstrate how to open a hdf file and read a 
// subset of specified data field.
int main(int argc, char* argv[])
{
    h4cf_open("geo.hdf"); // Open file and initialize library.
	
    const list<var*> pvars = h4cf_get_vars();
    for(list<var*>::const_iterator var_iter = pvars.begin(); 
        var_iter != pvars.end(); var_iter++)
        {
            // Find the specified variable according its name. In this case, 
            // it is "temp".
            if(h4cf_get_var_name((*var_iter))=="temp") 
		{
                    vector<char> vals;
                    // For each dimension, specify starting position.
                    int32 start[2] = {0,0}; 
                    // For each dimension, specify the interval between values
                    // to be picked up.
                    int32 stride[2] = {2,2};
                    // For each dimension, specify the count of values along 
                    // the corresponding dimension to be picked up.
                    int32 edge[2] = {4, 4}; 
                    h4cf_get_var_value(&vals, (*var_iter), 
                                       start, stride, edge);
                    // Obtain variable data. In this case, its dataset type is 
                    // double and its size is of 4*4.
                    for(int i=0; i<4; i++) // Print dataset out.
			{
                            for(int j=0; j<4; j++)
                                cout << "\ttemp[" << i*2 << "," << j*2 << "]=" 
                                     << (double)*(float64*)
                                    &(vals[(i*4+j)*sizeof(float64)]);
                            cout << endl;
			}
		}
	}
	
    h4cf_close(); // Close file and library.
	
    return 0;
}
