// Copyright by The HDF Group.
// All rights reserved.                                                      
//                                                                           
// This file is part of the H4CF Conversion Toolkit. The full H4CF Conversion
// Toolkit copyright notice including terms governing use, modification, and 
// redistribution, is contained in the file COPYING.     
// COPYING can be found at the root of the source code    
// distribution tree. If you do not have access to this file, you may request
// a copy from eoshelp@hdfgroup.org.     
#include "h4cf.h"
#include <iostream>
#include <string>
#include <map>
#include <vector>
#include <list>

void write_global_dims()
{
    const map<string, int> dims = h4cf_get_dims();
    for(map<string, int>::const_iterator dim_iter = dims.begin(); 
        dim_iter != dims.end(); 
        dim_iter++){
			cout << "Dimension name:" 
                             << (*dim_iter).first
				<< " size:" 
				<< (*dim_iter).second
				<< endl;
	} // for(...); 

}
void write_var_dims(var* v)
{
	const vector< map<string, int> > vdims = h4cf_get_var_dims(v);
	cout << h4cf_get_var_name(v)
		<< " has the following dimensions:" << endl;
	for(vector< map<string, int> >::const_iterator vdim_iter = vdims.begin();
		vdim_iter != vdims.end();
		vdim_iter++){
			map<string, int> dims = (*vdim_iter);
			for(map<string, int>::const_iterator dim_iter = dims.begin(); 
				dim_iter != dims.end(); 
				dim_iter++){
					cout << "Dimension name:" 
						<< (*dim_iter).first
						<< " size:" 
						<< (*dim_iter).second
						<< endl;
			} // for(each dim map);
	} // for(each dim vector)
}
// This example code is to demonstrate how to open an HDF file and read the 
// dimensions.
int main(int argc, char* argv[])
{
    // Open file and initialize library.
    h4cf_open("testvs1.hdf"); 
	
	// Print global dimension name and size.
	write_global_dims();

	// Print each variable's dimension name and size.
	const list<var*> pvars = h4cf_get_vars();
    for(list<var*>::const_iterator var_iter = pvars.begin(); 
        var_iter != pvars.end(); var_iter++){
			write_var_dims(*var_iter);
	}
    h4cf_close(); // Close file and library.
	
    return 0;
}
