// Copyright by The HDF Group.
// All rights reserved.                                                      
//                                                                           
// This file is part of the H4CF Conversion Toolkit. The full H4CF Conversion
// Toolkit copyright notice including terms governing use, modification, and 
// redistribution, is contained in the file COPYING.     
// COPYING can be found at the root of the source code    
// distribution tree. If you do not have access to this file, you may request
// a copy from eoshelp@hdfgroup.org.     
#include "h4cf.h"
#include <iostream>
#include <string>
#include <map>
#include <vector>
#include <list>

// This example code is to demonstrate how to open a hdf file and read a 
// subset of specified data field.
int main(int argc, char* argv[])
{
    // Open file and initialize library.
    h4cf_open("testvs1.hdf"); 
	
    const list<var*> pvars = h4cf_get_vars();
    for(list<var*>::const_iterator var_iter = pvars.begin(); 
        var_iter != pvars.end(); var_iter++)
        {
            // Find the specified variable according its name. In this case, 
            // it is "Vdata_DFNT_FLOAT32".
            if(h4cf_get_var_name((*var_iter))=="vdata_Vdata_DFNT_FLOAT32_vdf_Field_DFNT_FLOAT32") 
		{
                    vector<char> vals;
                    // For each dimension, specify starting position.
                    int32 start[1] = {0}; 
                    // For each dimension, specify the interval between values
                    // to be picked up.
                    int32 stride[1] = {3};
                    // For each dimension, specify the count of values along 
                    // the corresponding dimension to be picked up.
                    int32 edge[1] = {3};
                    h4cf_get_var_value(&vals, (*var_iter), 
                                       start, stride, edge);
                    // Obtain variable data. In this case, its dataset type is 
                    // float.
                    for(int i=0; i < 3; i++) // Print dataset out.
			{

                            cout << "vdata_Vdata_DFNT_FLOAT32_vdf_Field_DFNT_FLOAT32[" 
                                 << 3*i 
                                 << "]=" 
                                 << (float)*(float*) &(vals[i*sizeof(float)])
                                 << endl;
			}
		}
	}
	
    h4cf_close(); // Close file and library.
	
    return 0;
}
