// Copyright by The HDF Group.
// All rights reserved.                                                      
//                                                                           
// This file is part of the H4CF Conversion Toolkit. The full H4CF Conversion
// Toolkit copyright notice including terms governing use, modification, and 
// redistribution, is contained in the file COPYING.     
// COPYING can be found at the root of the source code    
// distribution tree. If you do not have access to this file, you may request
// a copy from eoshelp@hdfgroup.org.     
#include "h4cf.h"
#include <iostream>
#include <string>
#include <map>
#include <vector>
#include <list>


// This example code is to demonstrate how to open an HDF4 file and read 
// attributes of the specified data field.
//
int main(int argc, char* argv[])
{
    // Open file and initialize library.
    h4cf_open("testvs1.hdf"); 
	
    const list<var*> pvars = h4cf_get_vars();
    for(list<var*>::const_iterator var_iter = pvars.begin(); 
        var_iter != pvars.end(); var_iter++)
        {
            // Find the specified variable according its name.
            // In this case, it is "Vdata_DFNT_INT32".
            if(h4cf_get_var_name((*var_iter))=="vdata_Vdata_DFNT_INT32_vdf_Field_DFNT_INT32") 
		{
                    // Obtain variable attributes.
                    const list<attr*> vattrs = h4cf_get_var_attrs(*var_iter); 
                    vector<char>  vals;
                    for(list<attr*>::const_iterator 
                            vattr_iter = vattrs.begin(); 
                        vattr_iter != vattrs.end(); vattr_iter++)
        		{
                            // Find the specified attribute according to its 
                            // name.
                            if(h4cf_get_attr_name((*vattr_iter)) ==
                               "valid_range") 
				{
                                    // Obtain attribute's data. In this case, 
                                    // its data type is int.
                                    h4cf_get_attr_value(&vals, 
                                                            (*vattr_iter));
                                    cout << (*vattr_iter)->get_name() << " = " 
                                         << *((int *)&(vals[0]))
                                         << " " 
                                         << *((int *)&(vals[0+sizeof(int)]))
                                         << " " 
                                         << *((int *)&(vals[0+2*sizeof(int)]))
                                         << " " 
                                          << *((int *)&(vals[0+3*sizeof(int)]))
                                         << endl; // Print data out.
				}
			}

		}
	}
    h4cf_close(); // Close file and library.
    return 0;
}
