// Copyright by The HDF Group.
// All rights reserved.                                                      
//                                                                           
// This file is part of the H4CF Conversion Toolkit. The full H4CF Conversion
// Toolkit copyright notice including terms governing use, modification, and 
// redistribution, is contained in the file COPYING.     
// COPYING can be found at the root of the source code    
// distribution tree. If you do not have access to this file, you may request
// a copy from eoshelp@hdfgroup.org.     
#include "h4cf.h"
#include <iostream>
#include <string>
#include <map>
#include <vector>
#include <list>


// This example code is to demostrate how to open an Hybrid HDF file and read 
// the specified data field. The Hybrid means that HDF-EOS2 file has additional
// dataset that was written by the HDF4 library later.
// This file includes two SDS objects that share the same name temperature.
// One SDS object is an HDF-EOS2 grid. According to the translation convention,
// another SDS object temperature will be renamed to temperature_NONEOS.
//
// Please note that the current H4CF library will read the HDF-EOS2 
// "temperature" dataset. It doesn't read "temperature" dataset written by
// the HDF4 API.
int main(int argc, char* argv[])
{
    // Open file and initialize library.
    h4cf_open("h_grid.hdf"); 
	
    const list<var*> pvars = h4cf_get_vars();
    for(list<var*>::const_iterator var_iter = pvars.begin(); 
        var_iter != pvars.end(); 
        var_iter++)
        {
            // Find the specified variable according its name. In this case, 
            // the variable name is "temperature".
            if(h4cf_get_var_name((*var_iter))=="temperature")
		{
                    vector<char> vals;
                    h4cf_get_var_value(&vals, (*var_iter));
                    for(int i = 0; i < 4; i++) 
			{
                            // Print dataset out.
                            cout << "Row: " << i << endl;
                            for(int j=0; j< 8; j++)
                                cout << 
                                    (float)*((float*)
                                    &(vals[(i*8+j)* sizeof(float)]))
                                     << "\t";
                            cout << endl;
			} // for(int i = 0; i < 4; i++) 
		} // if(h4cf_get_var_name((*var_iter))=="temp")
	} // for(list<var*>::const_iterator var_iter = pvars.begin(); 
	
    h4cf_close(); // Close file and library.
	
    return 0;
}
