// Copyright by The HDF Group.
// All rights reserved.                                                      
//                                                                           
// This file is part of the H4CF Conversion Toolkit. The full H4CF Conversion
// Toolkit copyright notice including terms governing use, modification, and 
// redistribution, is contained in the file COPYING.     
// COPYING can be found at the root of the source code    
// distribution tree. If you do not have access to this file, you may request
// a copy from eoshelp@hdfgroup.org.     
#include "h4cf.h"
#include <iostream>
#include <string>
#include <map>
#include <vector>
#include <list>


// This example code is to demostrate how to open an Hybrid file and read the 
// file attributes.
int main(int argc, char* argv[])
{
    // Open file and initialize library.
    h4cf_open("h_grid.hdf"); 

    const list<attr*> file_attrs = h4cf_get_file_attrs();
    for(list<attr*>::const_iterator attr_iter = file_attrs.begin(); 
        attr_iter != file_attrs.end(); 
        attr_iter++)
        {
            vector<char>  vals;
            cout << "Name: " << h4cf_get_attr_name((*attr_iter)) << ", ";
            cout << "Type: " << h4cf_get_attr_type((*attr_iter)) << ", ";
            const int count = h4cf_get_attr_count((*attr_iter));
            cout << "Count: " << count << ", ";
            cout <<  "Value: ";
            h4cf_get_attr_value(&vals, (*attr_iter)) ;
            for (int i=0;i < count; i++){ 
                // We assume that we know its type (i.e., char in this file).
                cout <<  (char)*((char *)&(vals[i]));
            }
            cout << endl;
        }
	
    // Close file and library.
    h4cf_close();
	
    return 0;
}
