// Copyright by The HDF Group.
// All rights reserved.                                                      
//                                                                           
// This file is part of the H4CF Conversion Toolkit. The full H4CF Conversion
// Toolkit copyright notice including terms governing use, modification, and 
// redistribution, is contained in the file COPYING.     
// COPYING can be found at the root of the source code    
// distribution tree. If you do not have access to this file, you may request
// a copy from eoshelp@hdfgroup.org.     
#include "h4cf.h"
#include <iostream>
#include <string>
#include <map>
#include <vector>
#include <list>

// This example code is to demonstrate how to open an Hybrid file and read a 
// subset of specified data field.
// Notice: the conversion toolkit checked the boundary of the subset. If 
// the subset exceeds the whole domain, the conversion tool will stop and exit.
// For example, for file h_grid.hdf, the temperature variable is a 4 by 8 domain.
// So the start[index]+stride[index]*edge[index] should be less than the total 
// domain 4 when index is 0 and 8 when index is 1. This is more strict than the 
// OPeNDAP handler but I think we can keep it this way for the time being. KY 2013-02-11
int main(int argc, char* argv[])
{
    // Open file and initialize library.
    h4cf_open("h_grid.hdf"); 
	
    const list<var*> pvars = h4cf_get_vars();
    for(list<var*>::const_iterator var_iter = pvars.begin(); 
        var_iter != pvars.end(); var_iter++)
        {
            // Find the specified variable according its name. In this case, 
            // it is "temperature".
            if(h4cf_get_var_name((*var_iter))=="temperature") 
		{
                    vector<char> vals;
                    // For each dimension, specify starting position.
                    int32 start[2] = {0,3}; 
                    // For each dimension, specify the interval between values
                    // to be picked up.
                    int32 stride[2] = {2,2};
                    int32 edge[2] = {1, 2}; 
                    h4cf_get_var_value(&vals, (*var_iter), 
                                       start, stride, edge);
                    // Obtain varialbe data. In this case, its dataset type is 
                    // float and its size is of 4*8.
                    for(int i=0; i< edge[0] ; i++) // Print dataset out.
			{
                            for(int j=0; j < edge[1]; j++)
                                cout << "\ttemperature[" 
                                     << i*stride[0] + start[0]  
                                     << "," 
                                     << j*stride[1] + start[1] 
                                     << "]=" 
                                     << (float)*(float*)
                                    &(vals[(i*edge[1]+j)*sizeof(float)]);
                            cout << endl;
			}
		}
	}
	
    h4cf_close(); // Close file and library.
	
    return 0;
}
