///////////////////////////////////////////////////////////////////////////////
// Copyright The HDF Group
// All rights reserved.
//                                                      
// This code is provided as open source but it NOT licensed, has no limitations
// and has no expressed or implied warranties.
// For questions contact eoshelp@hdfgroup.org                      
///////////////////////////////////////////////////////////////////////////////
#include "h4cf.h"
#include <iostream>
#include <string>
#include <map>
#include <vector>
#include <list>


// This example code is to demostrate how to open an HDF4 file and read 
// attributes of the specifed data field.
int main(int argc, char* argv[])
{
    // Open file and initialize library.
    h4cf_open("h_grid.hdf"); 
	
    const list<var*> pvars = h4cf_get_vars();
    for(list<var*>::const_iterator var_iter = pvars.begin(); 
        var_iter != pvars.end(); var_iter++)
        {
            // Find the specified variable according its name.
            // In this case, it is "fire mask".
            if(h4cf_get_var_name((*var_iter))=="temperature") 
		{
                    // Obtain variable attributes.
                    const list<attr*> vattrs = h4cf_get_var_attrs(*var_iter); 
                    vector<char>  vals;
                    for(list<attr*>::const_iterator 
                            vattr_iter = vattrs.begin(); 
                        vattr_iter != vattrs.end(); vattr_iter++)
        		{
                            // Find the specified attribute according to its 
                            // name.
                            if(h4cf_get_attr_name((*vattr_iter)) ==
                               "_FillValue") 
				{
                                    // Obtain attribute's data. In this case, 
                                    // its data type is 8-bit unsigned integer.
                                    h4cf_get_attr_value(&vals, 
                                                            (*vattr_iter));
                                    cout << (*vattr_iter)->get_name() << " = " 
                                         << (float)*((float *)&(vals[0]))
                                         << endl; // Print data out.
				}
			}
		}
	}
    h4cf_close(); // Close file and library.
    return 0;
}
