/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of the H4CF conversion toolkit. The full H4CF conversion*
 * toolkit copyright notice including terms governing use, modification, and *
 * redistribution, is contained in the file COPYING.     *
 * COPYING can be found at the root of the source code    *
 * distribution tree.                                                        *
 * For questions contact eoshelp@hdfgroup.org or help@hdfgroup.org.          *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/*****************************************************************************

Description:

This file is used for interal testint, not for public use.


*****************************************************************************/

#ifndef CDLDUMPER_H
#define CDLDUMPER_H

#include <string>
#include "h4cf.h"

extern group *root;
extern hdf4::hdf4_file *file;
extern bool is4;

string get_cdl_type_str(value_type_t type);
void dump_cdl(group *g, ostream &os, bool bDumpData=true);
void cdl_output(attr *attr, ostream &os) throw(range_error);
void cdl_output(var *v, ostream &os);

string remove_non_printable_chars(const string&);
void dump_cdl(bool bDumpData=true);

#endif
