/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of the H4CF conversion toolkit. The full H4CF conversion*
 * toolkit copyright notice including terms governing use, modification, and *
 * redistribution, is contained in the file COPYING.     *
 * COPYING can be found at the root of the source code    *
 * distribution tree.                                                        *
 * For questions contact eoshelp@hdfgroup.org or help@hdfgroup.org.          *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/*****************************************************************************

Description:

This file is used for interal testint, not for public use.


*****************************************************************************/

#include <hdf.h>
#include <HdfEosDef.h>
#include "cdldumper.h"
#include "h4cf.h"
#include <iostream>
#include <string>
#include <map>

int main(int argc, char* argv[])
{
	if(argc == 1)
	{
		std::cerr << "Usage: cdldumper [-H] [hdf file name]\nAttention: If '-H' is specified, only header part is dumped." << std::endl;
		return -1;
	}
	else
	{
		// If true, data values will be dumped in CDL files, otherwise only header will be dumped.
		bool bDumpData = true;
		
		for(int i=1; i<argc; i++)
		{
			if(std::string(argv[i]) == "-H")
				bDumpData = false;
			else
			{
				h4cf_open(argv[i]);
				
				if(is4) //HDF4 files only.
					dump_cdl(bDumpData);
				else //HDFEOS2 or Hybrid files.
					dump_cdl(root, std::cout, bDumpData);
				
				h4cf_close();
			}
		}
		return 0;
	}
}
