#include <iostream>
#include <gtest/gtest.h>
#include "eoslib_file.h"
#include "eos2_defs.h"
#include "filterset.h"
#include "sstream"
#include "fstream"
#include "unittest_enable.h"
#include "mem_group.h"
#include "mem_dim.h"
#include "mem_var.h"
#include "mem_attr.h"
#include "cdldumper.h"

#include "hdf4_file.h"

extern bool bDumpData;
extern hdf4::hdf4_file *file;

namespace eoslib {

extern FILTER_SET(cf);

#if 0
extern FILTER_SET(cf);

TEST(cf, AMSR1)
{
	std::string filename = "../test/AMSR_E_L3_5DaySnow_V09_20050126.hdf";

	group* root = open(filename.c_str());
	ASSERT_TRUE(root->get_child_groups().size() == 2);

	int c = APPLY_FILTER_SET(cf, root);
	ASSERT_TRUE(c==1);

	root->dump_r();

	ASSERT_TRUE(root->get_child_groups().size() == 0);
}
#endif

#if 0
TEST(cf, AMSR1)
{
	std::string filename = "../test/AIRS.2005.01.01.L3.CO2Std031.v5.4.12.67.X09261141415.hdf";

	group* root = open(filename.c_str(), CF);
	ASSERT_TRUE(root);
	root->dump_r();

	delete root;
}
#endif 

/*
TEST(cf, tmp)
{
	std::string filename = "../test/AIRS.2005.01.01.L3.CO2Std031.v5.4.12.67.X09261141415.hdf";
	
	group* root = open(filename.c_str(), NONE);
	ASSERT_TRUE(root);

	//root->dump_cdl(std::cout, false);
	//root->dump_r(0);

	delete root;
}
*/

static void cf(const std::string& filename)
{
	bDumpData = false;

	file = new hdf4::hdf4_file();
	file->read(filename.c_str());

	group* root = open(filename.c_str(), CF);
	ASSERT_TRUE(root);

#ifdef CF_CMP_HEADER
	{
		std::ostringstream oss;
		dump_cdl(root, oss, false);
		std::string cdlstr = oss.str();

		std::string cdlfilename = filename + ".headeronly.cdl";
		std::ifstream f(cdlfilename.c_str());
		ASSERT_TRUE(f.is_open());

		std::vector<char> cdlfilestr;
		cdlfilestr.resize(cdlstr.length()+1, 0);
		f.read(&cdlfilestr[0], cdlstr.length());

		//std::cout << cdlstr.length() << std::endl;
		//std::cout << cdlfilestr.size() << std::endl;

		//ASSERT_TRUE(cdlstr == &cdlfilestr[0]);
	}
#endif
/*
#ifdef CF_CMP_DATA
	{
		std::ostringstream oss;
		dump_cdl(root, oss);
			
		std::string cdlfilename = filename + ".cdl";
		std::ifstream f(cdlfilename.c_str());
		ASSERT_TRUE(f.is_open());

		std::vector<char> cdlfilestr;
		cdlfilestr.resize(oss.tellp());
		f.read(&cdlfilestr[0], oss.tellp());

		//ASSERT_TRUE(oss.str() == &cdlfilestr[0]);
	}
#endif
*/
	delete file;
	delete root;
}


#ifdef CF_AIRS_2002_09_01
TEST(cf, AIRS_2002_09_01)
{
	std::string filename = "test_files/AIRS.2002.09.01.L3.RetQuant_H030.v5.0.14.0.G07191213218.hdf";
	cf(filename);
}
#endif

#ifdef CF_AIRS_2002_12_31
TEST(cf, AIRS_2002_12_31)
{
	std::string filename = "test_files/AIRS.2002.12.31.001.L2.CC_H.v5.0.14.0.G07282131425.hdf";
	cf(filename);
}
#endif

#ifdef CF_AIRS_2005_01_01
TEST(cf, AIRS_2005_01_01)
{
	std::string filename = "test_files/AIRS.2005.01.01.L3.CO2Std031.v5.4.12.67.X09261141415.hdf";
	cf(filename);
}
#endif

#ifdef CF_AIRS_2009_11_16
TEST(cf, AIRS_2009_11_16)
{
	std::string filename = "test_files/AIRS.2009.11.16.L1B.Cal_Subset.v5.0.16.0.G09321225806.hdf";
	cf(filename);
}
#endif

#ifdef CF_AIRS_V4_GRID
TEST(cf, AIRSv4grid)
{
	std::string filename = "test_files/AIRSv4grid.hdf";
	cf(filename);
}
#endif

#ifdef CF_AMSR_E_L3_5DaySnow_V09_20050126
TEST(cf, AMSR_E_L3_5DaySnow_V09_20050126)
{
	std::string filename = "test_files/AMSR_E_L3_5DaySnow_V09_20050126.hdf";
	cf(filename);
}
#endif

#ifdef CF_MYD06_L2_A2009001
TEST(cf, MYD06_L2_A2009001)
{
	std::string filename = "test_files/MYD06_L2.A2009001.0000.005.2009033195945.hdf";
	cf(filename);
}
#endif

#ifdef CF_MYD03_A2002226
TEST(cf, MYD03_A2002226)
{
	std::string filename = "test_files/MYD03.A2002226.0000.005.2009193071127.hdf";
	cf(filename);
}
#endif

#ifdef CF_AMSR_E_L3_RainGrid_V06_200206
TEST(cf, AMSR_E_L3_RainGrid_V06_200206)
{
	std::string filename = "test_files/AMSR_E_L3_RainGrid_V06_200206.hdf";
	cf(filename);
}
#endif

TEST(cf, flatten)
{
	file = NULL;

	mem_group *root, *a, *b;
	root = new mem_group();
	a = new mem_group("GroupA");
	b = new mem_group("GroupB");
	root->add_group(a);
	root->add_group(b);

	dim *d1, *d2;
	d1 = new mem_dim(a, "dim10", 10);
	d2 = new mem_dim(b, "dim10", 10);
	a->add_dim(d1);
	b->add_dim(d2);

	mem_var *v1;
	v1 = new mem_var(a, "v");
	std::vector<int32> v1_data(d1->get_size());
	for(int i=0; i<d1->get_size(); i++)
		v1_data[i] = i*10;
	v1->set(DFNT_INT32, d1, &v1_data[0]);
	a->add_var(v1);

	ASSERT_TRUE(v1->get_tot_num_elements() == d1->get_size());

	mem_var *v2;
	v2 = new mem_var(b, "v");
	std::vector<int32> v2_data(d2->get_size());
	for(int i=0; i<d2->get_size(); i++)
		v2_data[i] = i*20;
	v2->set(DFNT_INT32, d2, &v2_data[0]);
	b->add_var(v2);

	mem_var *v3;
	v3 = new mem_var(b, "w");
	std::vector<int32> v3_data(d2->get_size());
	for(int i=0; i<d2->get_size(); i++)
		v3_data[i] = i*20;
	v3->set(DFNT_INT32, d2, &v3_data[0]);
	b->add_var(v3);

	mem_attr *a1;
	a1 = new mem_attr(v3, "attr_somename$");
	a1->set_value("Some text");
	v3->add_attr(a1);

	mem_attr *a2;
	a2 = new mem_attr(v3, "attr_somename#");
	a2->set_value("Some text");
	v3->add_attr(a2);

	//root->dump_r(0);

	APPLY_FILTER_SET(cf, root);

	//root->dump_r(0);
	ASSERT_TRUE(root->get_dim_by_name("dim10_GroupA") != NULL);
	ASSERT_TRUE(root->get_dim_by_name("dim10_GroupB") != NULL);

	std::list<var*> vars;
	root->get_vars_by_name("v_GroupA", &vars);
	ASSERT_TRUE(vars.size() == 1);
	vars.clear();
	root->get_vars_by_name("v_GroupB", &vars);
	ASSERT_TRUE(vars.size() == 1);

	vars.clear();
	root->get_vars_by_name("w", &vars);
	ASSERT_TRUE(vars.size() == 1);
	var* x = *(vars.begin());

	std::list<attr*>& xattrs = x->get_attrs();
	for(std::list<attr*>::iterator it = xattrs.begin();
			it != xattrs.end(); it++)
	{
		std::string name = (*it)->get_name();
		if(name.length() > 4 && name.substr(0, 4) == "attr")
		{
			ASSERT_TRUE(name == "attr_somename__0" || name == "attr_somename__1");
		}
		//std::cout << name << std::endl;
	}
	//root->dump_r(0);
}
} // namespace
