#include <iostream>
#include <gtest/gtest.h>
#include "eoslib_file.h"
#include "eos2_defs.h"
#include "filterset.h"

#if 1

using namespace eoslib;

#if 0
TEST(eos2, AIRS1)
{
	std::string filename = "../test/AIRS.2002.09.01.L3.RetQuant_H030.v5.0.14.0.G07191213218.hdf";

	file* e = file::open(filename.c_str(), CF);
	ASSERT_TRUE(e != NULL);
	ASSERT_TRUE(e->file_type() == "eos2_file");

	group* root = e->get_group();
	ASSERT_TRUE(root);

	const std::list<attr*>& as = root->get_attrs();
	ASSERT_TRUE(as.size() == 0);

	const std::list<group*>& child_groups = root->get_child_groups();
	ASSERT_TRUE(child_groups.size() == 1);
	group* g = *child_groups.begin();
	ASSERT_TRUE(g != NULL);
	ASSERT_TRUE(g->get_name() == "L3Quant");
	{
		eos2_group* g2 = dynamic_cast<eos2_group*>(g);
		ASSERT_TRUE(g2->get_type() == eoslib::GRID);
	}

	const std::list<var*>& v = g->get_vars();
	ASSERT_TRUE(v.size() == 17);	// Including latitude and longitude

	{
		// One variable check
		var* v_first = *v.begin();
		ASSERT_TRUE(v_first->get_dims().size() == 2);
		//ASSERT_TRUE(v_first->get_attrs().size() == 1);
	}

	const std::list<dim*>& d = g->get_dims();
	ASSERT_TRUE(d.size() == 7);

	root->dump_r();
}
#endif

#if 0
// Regular grid file
TEST(eos2, MOD1)
{
	std::string filename = "../test/MOD10A1.A2000065.h00v08.005.2008237034422.hdf";
	file* e = file::open(filename.c_str(), CF);
	ASSERT_TRUE(e != NULL);
	ASSERT_TRUE(e->file_type() == "eos2_file");

	group* root = e->get_group();
	ASSERT_TRUE(root);

	root->dump_r();

	const std::list<attr*>& as = root->get_attrs();
	ASSERT_TRUE(as.size() == 0);

	const std::list<group*>& child_groups = root->get_child_groups();
	ASSERT_TRUE(child_groups.size() == 1);
	group* g = *child_groups.begin();
	ASSERT_TRUE(g != NULL);
	ASSERT_TRUE(g->get_name() == "MOD_Grid_Snow_500m");
	{
		eos2_group* g2 = dynamic_cast<eos2_group*>(g);
		ASSERT_TRUE(g2->get_type() == eoslib::GRID);
	}
	{
	}

	const std::list<var*>& v = g->get_vars();
	ASSERT_TRUE(v.size() == 6);	// Including latitude and longitude

	{
		// One variable check
		var* v_first = *v.begin();
		ASSERT_TRUE(v_first->get_name() == "Snow_Cover_Daily_Tile");
		ASSERT_TRUE(v_first->get_dims().size() == 2);

		ASSERT_TRUE(v_first->get_type() == UINT8);

		const std::list<attr*> attrs = v_first->get_attrs();
		ASSERT_TRUE(attrs.size() == 0);
	}

	const std::list<dim*>& d = g->get_dims();
	ASSERT_TRUE(d.size() == 2);

}
#endif



namespace eoslib {

#if 0
TEST(eos2, AMSR1)
{
	std::string filename = "../test/AMSR_E_L3_5DaySnow_V09_20050126.hdf";

	group* root = open(filename.c_str());
	
	std::list<group*>& child_groups = root->get_child_groups();
	ASSERT_TRUE(child_groups.size() == 2);

	group* first_grid = *(child_groups.begin());
	ASSERT_TRUE(first_grid->get_vars().size() == 4);

	var* lat = first_grid->get_var_by_name("latitude");
	ASSERT_TRUE(lat);

	//root->dump_r();

	//std::cout << "-----" << std::endl;

	std::string nn1 = "Some_group_name";
	first_grid->rename(nn1);
	ASSERT_TRUE(first_grid->get_name() == nn1);

	std::string nn2 = "NEW_LAT";
	lat->rename(nn2);
	ASSERT_TRUE(lat->get_name() == nn2);
	//root->dump_r();

	//std::cout << "-----" << std::endl;

	group *remaining_group = *root->get_child_groups().begin();

	remaining_group->move_all(root);
	root->remove(remaining_group);

	//root->dump_r();

	//ASSERT_TRUE(root->get_vars.size() == 4);




	//child_groups.pop_front();

	//root->dump_r();
	delete root; 
	
	/*

	mem_group *m = new mem_group();
	copy(m, root);

	mem_group *n = NULL;
	n = flatten(root);

	*/

	//root->flatten();
	//root->dump_r();
}
#endif

/*
TEST(eos2, swath1)
{
	std::string filename = "../test/MYD021KM.A2002226.0000.005.2009193222735.hdf";
	group* root = open(filename.c_str(), NONE);

	delete root;
}
*/


} // namespace
#endif
