#include <iostream>
#include <gtest/gtest.h>
#include "eoslib_group.h"
#include "mem_group.h"
#include "mem_dim.h"
#include "mem_var.h"
#include <vector>

namespace eoslib {

TEST(group, copy)
{
	mem_group *root, *a, *b;
	root = new mem_group();
	a = new mem_group("GroupA");
	b = new mem_group("GroupB");
	root->add_group(a);
	root->add_group(b);

	dim *d1, *d2, *d3;
	d1 = new mem_dim(a, "dim10", 10);
	d2 = new mem_dim(a, "dim20", 20);
	d3 = new mem_dim(b, "dim10", 10);
	a->add_dim(d1);
	a->add_dim(d2);
	b->add_dim(d3);

	mem_var *v1;
	v1 = new mem_var(a, "v1");
	std::vector<int32> v1_data(d1->get_size());
	for(int i=0; i<d1->get_size(); i++)
		v1_data[i] = i*10;
	v1->set(DFNT_INT32, d1, &v1_data[0]);
	a->add_var(v1);

	ASSERT_TRUE(v1->get_tot_num_elements() == d1->get_size());

	mem_var *v2;
	v2 = new mem_var(a, "v2");
	std::vector<int32> v2_data(d2->get_size());
	for(int i=0; i<d2->get_size(); i++)
		v2_data[i] = i*10;
	v2->set(DFNT_INT32, d2, &v2_data[0]);
	a->add_var(v2);

	//root->dump_r(0);

	ASSERT_TRUE(b->copy(a, v1) != NULL);
	ASSERT_TRUE(b->copy(a, v2) == NULL);

	std::list<var*> vars;
	b->get_vars_by_name(v1->get_name(), &vars);
	ASSERT_TRUE(!vars.empty());
	var* bv1 = *(vars.begin());

	//root->dump_r(0);
	ASSERT_TRUE(bv1->is_equivalent_to(v1));
}

} // namespace
