#include <iostream>
#include <gtest/gtest.h>
#include "eoslib_file.h"
#include "eos2_defs.h"
#include "mem_attr.h"

namespace eoslib {

#if 0
TEST(mem_attr, test1)
{
	mem_attr a("some memory attr");

	uint32 i = 1, j;
	a.set_value(DFNT_UINT32, 1, (void*)&i);
	ASSERT_TRUE(a.get_type() == DFNT_UINT32);
	ASSERT_TRUE(a.get_size() == 1);
	a.get_value(&j);
	ASSERT_TRUE(i==j);
}

TEST(mem_attr, test2)
{
	mem_attr a("some memory attr");

	float32 i = 123.456, j;
	a.set_value(DFNT_FLOAT32, 1, (const void*)&i);
	ASSERT_TRUE(a.get_type() == DFNT_FLOAT32);
	ASSERT_TRUE(a.get_size() == 1);
	a.get_value(&j);
	ASSERT_TRUE(i==j);
}

TEST(mem_attr, test3)
{
	mem_attr a("some memory attr");

	std::string i = "abc sljdflk alsdfjlskjda sdf";
	std::string j;

	a.set_value(DFNT_CHAR8, i.size(), i.c_str());
	ASSERT_TRUE(a.get_type() == DFNT_CHAR8);
	ASSERT_TRUE(a.get_size() == i.size());
	j.resize(a.get_size());
	a.get_value(const_cast<char*>(j.c_str()));
	ASSERT_TRUE(i==j);
}

TEST(mem_attr, test4)
{
	mem_attr a("some memory attr");

	std::string i = "abcd";
	std::string j;

	a.set_value(i);
	a.get_str(&j);
	ASSERT_TRUE(i==j);
}

#endif

} // namespace
