#include <iostream>
#include <gtest/gtest.h>
#include "eoslib_file.h"
#include "eos2_defs.h"
#include "mem_var.h"
#include "mem_dim.h"

namespace eoslib {

TEST(mem_var, test1)
{
	std::vector<float> a;
	for(int i=0; i<5; i++)
		for(int j=0; j<3; j++)
			a.push_back(i * 0.1 + j * 0.01);
	
	std::list<dim*> dims;
	dim* d1 = new mem_dim(NULL, "somedim", 5);
	dim* d2 = new mem_dim(NULL, "somedim2", 3);
	dims.push_back(d1);
	dims.push_back(d2);

	mem_var v(NULL, "some memory attr");
	v.set(DFNT_FLOAT32, dims, &a[0]);

	ASSERT_TRUE(v.get_type() == DFNT_FLOAT32);

	float buf[5][3];
	int32 start[2] = {0,0};
	int32 stride[2] = {1,1};
	int32 edge[2] = {5,3};
	v.get_value(start, stride, edge, (void*)&buf[0][0]);
	for(int i=0; i<5; i++)
		for(int j=0; j<3; j++)
			ASSERT_TRUE(buf[i][j] == a[i*3+j]);
	
	delete d1;
	delete d2;

}


} // namespace
