#include <iostream>
#include <gtest/gtest.h>
#include <vector>
#include <string>
#include "misc_util.h"

TEST(util, split)
{
	std::string str = "ABC,DEF.GHI,.JKL";
	std::string delim = ",.";
	std::vector<std::string> tokens;
	util_split_str(str, delim, &tokens);
	//for(size_t i=0; i<tokens.size(); i++)
	//	std::cout << "\"" << tokens[i] << "\"" <<  std::endl;
	ASSERT_TRUE(tokens.size()==4);
	ASSERT_TRUE(tokens[0]=="ABC");
	ASSERT_TRUE(tokens[1]=="DEF");
	ASSERT_TRUE(tokens[2]=="GHI");
	ASSERT_TRUE(tokens[3]=="JKL");
}
