#include <iostream>
#include <gtest/gtest.h>
#include "eos2_defs.h"
#include "filterset.h"

namespace eoslib {

static int val(int x, int y)
{
	return x*10+y;
}

TEST(var, subset)
{
	std::vector<int> input;
	for(int i=0; i<10; i++)
	{
		for(int j=0; j<9; j++)
		{
			input.push_back(val(i, j));
			//std::cout << val(i,j) << "\t";
		}
		//std::cout << std::endl;
	}

	std::vector<int32> dim;
	dim.push_back(10);
	dim.push_back(9);

	// Test 1
	std::vector<int> output1;
	std::vector<int32> start1, stride1, edge1;

	start1.push_back(0);
	start1.push_back(1);

	stride1.push_back(3);
	stride1.push_back(2);

	edge1.push_back(7);
	edge1.push_back(6);

	eoslib::var::subset(&input[0], (int32)dim.size(), &dim[0], &start1[0], &stride1[0], &edge1[0], &output1);
	ASSERT_TRUE(output1.size() == 9);
	for(int i=0, k=0; i<3; i++)
	{
		for(int j=0; j<3; j++, k++)
		{
			//std::cout << output1[k] << "\t";
			ASSERT_TRUE(output1[k] == val(i*3+0, j*2+1));
		}
		//std::cout << std::endl;
	}

	// Test 2
	std::vector<int> output2;
	std::vector<int32> start2, stride2, edge2;

	start2.push_back(0);
	start2.push_back(0);

	stride2.push_back(1);
	stride2.push_back(1);

	edge2 = dim;

	eoslib::var::subset(&input[0], (int32)dim.size(), &dim[0], &start2[0], &stride2[0], &edge2[0], &output2);
	ASSERT_TRUE(output2 == input);

	// Test 3
	std::vector<int> output3;
	std::vector<int32> start3, stride3, edge3;

	start3.push_back(0);
	start3.push_back(2);

	stride3.push_back(4);
	stride3.push_back(2);

	edge3.push_back(5);
	edge3.push_back(8);

	eoslib::var::subset(&input[0], (int32)dim.size(), &dim[0], &start3[0], &stride3[0], &edge3[0], &output3);
	ASSERT_TRUE(output3.size() == 6);
	for(int i=0, k=0; i<2; i++)
	{
		for(int j=0; j<3; j++, k++)
		{
			//std::cout << output3[k] << "\t";
			ASSERT_TRUE(output3[k] == val(i*4+0, j*2+2));
		}
		//std::cout << std::endl;
	}

}


} // namespace
