/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of the H4CF conversion toolkit. The full H4CF conversion*
 * toolkit copyright notice including terms governing use, modification, and *
 * redistribution, is contained in the file COPYING.     *
 * COPYING can be found at the root of the source code    *
 * distribution tree.                                                        *
 * For questions contact eoshelp@hdfgroup.org or help@hdfgroup.org.          *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/*****************************************************************************

Description:

This file defines filter set to check whether the final output has no children groups. To follow CF conventions,the group hierarchy should be flat.

*****************************************************************************/

#include "filterset.h"

namespace eoslib {

filter_set g_filter_set_cf_checker;
//FILTER_SET(cf_checker);

/**
 * Multi-level structure is not allowed.
 */
int cc_flat(group* root, void *arg)
{
    if(root->get_child_groups_c().size()==0)
        return 0;
    else
        return -1;
} 

//ADD_FILTER("CFchecker", cf_checker, 0, cc_flat);

class add_filter_2
{
    public:
        add_filter_2()
        {
            g_filter_set_cf_checker.add("CFchecker", 0, cc_flat, NULL);
        }
};
add_filter_2 af2;


} // namespace

