/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of the H4CF conversion toolkit. The full H4CF conversion*
 * toolkit copyright notice including terms governing use, modification, and *
 * redistribution, is contained in the file COPYING.     *
 * COPYING can be found at the root of the source code    *
 * distribution tree.                                                        *
 * For questions contact eoshelp@hdfgroup.org or help@hdfgroup.org.          *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/*****************************************************************************

Category: Header file for the EOS2 module under the eoslib namespace


Description:

This file consists of HDF-EOS2 _FillValue attribute and related method declarations.   

*****************************************************************************/

#ifndef EOS2_ATTR_FILLVALUE_H
#define EOS2_ATTR_FILLVALUE_H

#include "eos2_file.h"
#include "eoslib_attr.h"

namespace eoslib
{

//! HDF-EOS2 Fill value attribute
/**
 * This class represents the fillvalue of
 * HDF-EOS2 files. Since a fillvalue takes
 * very small storage and is read when
 * checking it existence, we store the 
 * values in the class instance.
 */
class eos2_attr_fillvalue: public attr
{
    public:
        eos2_attr_fillvalue(
            var *v,
            file_info *f, /* Though eos2_file ptr is not used, still keep this for completeness. */
            value_type_t type,
            char *fillvalue);

        virtual ~eos2_attr_fillvalue();

        virtual value_type_t get_type() const;
        virtual unsigned int get_num_elements() const;
        virtual void get_value(void *buf) const; 
        virtual attr *clone() const;
        virtual bool same_obj_test(attr *) const;

    protected:
        file_info *m_file_info;
        value_type_t m_type;
        std::vector<char> m_value;

    private:
        /* Copy constructor is used by duplicate() */
        eos2_attr_fillvalue(const eos2_attr_fillvalue&);

        /* diabled constuctors */
        eos2_attr_fillvalue();
};

} // namespace
#endif

