/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of the H4CF conversion toolkit. The full H4CF conversion*
 * toolkit copyright notice including terms governing use, modification, and *
 * redistribution, is contained in the file COPYING.     *
 * COPYING can be found at the root of the source code    *
 * distribution tree.                                                        *
 * For questions contact eoshelp@hdfgroup.org or help@hdfgroup.org.          *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/*****************************************************************************

Category: Header file for the EOS2 module under the eoslib namespace

Description:

This file includes all header files of the EOS2 module. It also contains declarations of EOS2 module classes.  

*****************************************************************************/

#ifndef EOS2_DEFS_H
#define EOS2_DEFS_H

namespace eoslib
{
    class eos2_attr_fillvalue;
    class eos2_attr_gdsw;
    class eos2_dim;
    class eos2_file;
    class eos2_group;
    class eos2_var_data;
    class eos2_var_geo;
    class eos2_var_dm;
    class eos2_var_gd_ll;
    class eos2_handle;

    // EOS2 type includes 
    // ROOT: existing global attributes and variables copied from SWATH or GRID.
    // SWATH: swath objects(fields, attributes)
    // GRID: grid objects(fields, attributes)
    // NONEOS: objects added by HDF4 APIs(cannot understood by EOS)
    typedef enum _eos2_group_type_t {ROOT, SWATH, GRID,NONEOS} eos2_group_type_t;

    // Represent different MODIS scale and offset rules.
    // MOD_DEFAULT_TYPE: No scale/offset or follow the default CF rule
    // MULTI_TYPE: final_data = scale_factor*(scaled_data-offset)
    // EQU_TYPE: final_data = scale_factor*scaled_data + offset
    // DIV_TYPE: final_data = (scaled_data -offset)/scale_factor;
    enum MODISType {MOD_DEFAULT_TYPE,MULTI_TYPE, EQU_TYPE, DIV_TYPE};

    // Here group names are used to distinguish the different MODIS scale offset rules.
    // This is based on our current collections. We still need to investigate more and the cases may change.
    // KY 2013-01-25

    /*
        MULTI_TYPE = {
	    L1B(group name starting with MOD or mod and ending with L1B), 
            MOD03(group name is MODIS_Swath_Type_GEO), 
            MOD08(group name  is mod08),
            MOD05_L2(group name is mod05),
            MOD06_L2(group name is mod06)
            MOD07_L2(group name is mod07),
            MYD08_D3(HDFView can not open this file),
            MCD43B4(group name is MOD_Grid_BRDF),
            MCD43C1(group name is MOD_CMG_BRDF_0.05Deg),
            MYD09A1(group name is MOD_Grid_500m_Surface_Reflectance),
            MOD17A2(group name is MOD_Grid_MOD17A2),
            MYD17A2(group name is MOD_Grid_MOD17A2),
            MOD43B4(group name is MOD_Grid_BRDF),
            MOD29E1(two groups. names are MOD_Grid_Seaice_4km_North and MOD_Grid_Seaice_4km_South)
            MODATML2(group name is atml2. scale_factor and add_offset only.)
            MYD15A2GFS(group name is MODIS_NACP_LAI)
            MYD15A2(group name is MOD_Grid_MOD15A2)
            MYD(MOD)09GA/09GHK(two groups: group name is MODIS_Grid_1km_2D);
            EQUATION is correct_data_value =  scale * (raw_data_value - offset)
        }
        EQU_TYPE = {
            MOD11_L2(group name is MOD_Swath_LST),
            MOD11_C2(group name is MODIS_8DAY_0.05DEG_CMG_LST),
            MYD11_L2(group name is MOD_Swath_LST),
            MYD11_C2(group name is MODIS_8DAY_0.05DEG_CMG_LST) 
            EQUATION is correct_data_value =  scale * raw_data_value
            If having offset, EQUATION is correct_data_value =  scale * raw_data_value + offset
        }
        DIV_TYPE = {
            MOD(MYD)13A(group name is MODIS_Grid_16DAY_500m_VI),
            MOD(MYD)13C(group name is MOD_Grid_monthly_CMG_VI)
            MOD(MYD)13A1(group name is MODIS_Grid_16DAY_500m_VI),
            MOD(MYD)13C1(group name is MODIS---_VI_CMG)
            
            MOD(MYD)09GA/GHK(two groups: only the group MODIS_Grid_500m_2D),
            MOD(MYD)09GQK(group name is MOD_Grid_L2g_2d)
            MOD09.A(group name is MODIS SWATH TYPE L2)
            MEaSURES VIP(group name is VIP_CMG_GRID)
            EQUATION is correct_data_value=(raw_data_value -offset)/scale_factor  
        }
     */
}

#include "eos2_attr_fillvalue.h"
#include "eos2_attr_gdsw.h"
#include "eos2_dim.h"
#include "eos2_file.h"
#include "eos2_group.h"
#include "eos2_var_data.h"
#include "eos2_var_geo.h"
#include "eos2_var_dm.h"
#include "eos2_var_gd_ll.h"
#include "eos2_handle.h"

#endif

