/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of the H4CF conversion toolkit. The full H4CF conversion*
 * toolkit copyright notice including terms governing use, modification, and *
 * redistribution, is contained in the file COPYING.     *
 * COPYING can be found at the root of the source code    *
 * distribution tree.                                                        *
 * For questions contact eoshelp@hdfgroup.org or help@hdfgroup.org.          *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/*****************************************************************************

Description:

This file includes the implementation related to an HDF-EOS2 dimension.


*****************************************************************************/

#include "eos2_dim.h"
#include <assert.h>

namespace eoslib
{

eos2_dim::eos2_dim(
    group *g,
    file_info *f,
    eos2_group_type_t gdsw,
    eos2_handle *handle,
    const std::string& nickname,
    const std::string& eos2dimname,
    unsigned int size):
        dim(g, nickname, size),
        m_file_info(f),
        m_gdsw(gdsw),
        m_handle(handle),
        m_eos2dimname(eos2dimname)
{
    assert(m_handle);

    if(m_gdsw!= NONEOS) {
        m_file_info->inc(this);
        m_handle->inc(this);
    }

    if(m_gdsw == NONEOS)
        disable_clone = true;


}

eos2_dim::eos2_dim(const eos2_dim& r): dim(r),
    m_file_info(r.m_file_info),
    m_gdsw(r.m_gdsw),
    m_handle(r.m_handle),
    m_eos2dimname(r.m_eos2dimname)
{

    if(m_gdsw !=NONEOS) { 
        m_file_info->inc(this);
        m_handle->inc(this);
    }
}

eos2_dim::~eos2_dim()
{
    if(m_gdsw !=NONEOS) {
       m_file_info->dec(this);
       m_handle->dec(this);
    }
}

dim* eos2_dim::clone(group *g) const
{
    eos2_dim *d = new eos2_dim(*this);
    d->m_group = g;
    return d;
}

} // namespace
