/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of the H4CF conversion toolkit. The full H4CF conversion*
 * toolkit copyright notice including terms governing use, modification, and *
 * redistribution, is contained in the file COPYING.     *
 * COPYING can be found at the root of the source code    *
 * distribution tree.                                                        *
 * For questions contact eoshelp@hdfgroup.org or help@hdfgroup.org.          *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/*****************************************************************************
Category: Header file for the EOS2 module under the eoslib namespace

Description:

This file contains information of an HDF-EOS2 dimension class.

*****************************************************************************/


#ifndef EOS2_DIM_H
#define EOS2_DIM_H

#include "eos2_file.h"
#include "eos2_group.h"
#include "eos2_var_data.h"
#include "eoslib_dim.h"

namespace eoslib
{

//!HDF-EOS2 dimension class
class eos2_dim: public dim
{
    public:
        eos2_dim(
            group *g,
            file_info *f,
            eos2_group_type_t gdsw,
            eos2_handle *handle,
            const std::string& nickname,
            const std::string& eos2dimname,
            unsigned int size);
            eos2_dim(const eos2_dim &r);
        virtual ~eos2_dim();
        virtual dim *clone(group *g) const;
	
    protected:
        file_info *m_file_info;
        eos2_group_type_t m_gdsw;
        eos2_handle *m_handle;

        std::string m_eos2dimname;

    friend class eos2_group;
    friend class eos2_var_data;
    friend int _cb_on_each_gd_datafield(char *name, void *arg);	
};


} // namespace

#endif
