/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of the H4CF conversion toolkit. The full H4CF conversion*
 * toolkit copyright notice including terms governing use, modification, and *
 * redistribution, is contained in the file COPYING.     *
 * COPYING can be found at the root of the source code    *
 * distribution tree.                                                        *
 * For questions contact eoshelp@hdfgroup.org or help@hdfgroup.org.          *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/*****************************************************************************

Description:

This file includes the implementation related to an HDF-EOS2 file.


*****************************************************************************/

#include <iostream>
#include <cassert>

#include <hdf.h>
#include <HdfEosDef.h>

#include "eos2_defs.h"
#include "eoslib_err.h"
#include "eoslib_file.h"

namespace eoslib
{

group* eos2_fopen(const char *filename)
{
    try {
        eos2_group *g = new eos2_group(filename);
        return g;
    } catch (std::runtime_error e)
    {
        return NULL;
    }
}

}  // namespace
