/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of the H4CF conversion toolkit. The full H4CF conversion*
 * toolkit copyright notice including terms governing use, modification, and *
 * redistribution, is contained in the file COPYING.     *
 * COPYING can be found at the root of the source code    *
 * distribution tree.                                                        *
 * For questions contact eoshelp@hdfgroup.org or help@hdfgroup.org.          *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/*****************************************************************************

Category: Header file for the eos2 module of the eoslib namespace.

Description:

This file contains the declaration of an open function for an HDF-EOS2 module.  

*****************************************************************************/

#ifndef EOS2_FILE_H
#define EOS2_FILE_H

/* #include <gtest/gtest.h> */
#include "eoslib_file.h"
#include <hdf.h>
#include <HdfEosDef.h>
#include "eos2_handle.h"

namespace eoslib
{
    /**
     * This class stores all eos2-specific information.
     */

    group* eos2_fopen(const char *filename);
} // namespace

#endif
