/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of the H4CF conversion toolkit. The full H4CF conversion*
 * toolkit copyright notice including terms governing use, modification, and *
 * redistribution, is contained in the file COPYING.     *
 * COPYING can be found at the root of the source code    *
 * distribution tree.                                                        *
 * For questions contact eoshelp@hdfgroup.org or help@hdfgroup.org.          *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/*****************************************************************************

Description:

This file includes the method stubs related to the processing of a NcML file
specific to HDF-EOS2.

NcML support may be added in the future if necessary. This file only includes the skeleton. If we decide not support NcML in the conversion toolkit, this file and the corresponding header file should be removed.


*****************************************************************************/

#include <map>
#include "filterset.h"
#include "eoslib_ncml_file.h"

extern eoslib::ncml_file *ncmlfile;

namespace eoslib {
//extern ncml_file *ncmlfile;

int prepare_ncml(group *root, void *)
{
    std::map<std::string, std::string>::iterator it;
    it = (ncmlfile->attrs_to_be_renamed).begin();
    std::cout << "[eos2_ncml]" << (*it).first << "\t" << (*it).second << std::endl;
    return 0;
}

int rename_attr(group *root, void *)
{
    std::cout << "[eos2_ncml]rename attributes" << std::endl;
    return 0;
}

int change_attr_value(group *root, void *)
{
    std::cout << "[eos2_ncml]change attribute's value" << std::endl;
    return 0;
}

//FILTER_SET(ncml);
filter_set g_filter_set_ncml;

//ADD_FILTER("Prepare NCML", ncml, 60, prepare_ncml);
//ADD_FILTER("Rename name", ncml, 70, rename_attr);
//ADD_FILTER("Change attribute's value", ncml, 80, change_attr_value);

class add_filter_3
{
    public:
    add_filter_3()
    {
        g_filter_set_ncml.add("Prepare NCML", 60, prepare_ncml, NULL);
        g_filter_set_ncml.add("Rename name", 70, rename_attr, NULL);
        g_filter_set_ncml.add("Change attribute's value", 80, change_attr_value, NULL);
    }	
};
add_filter_3 af3;
} //end of namespace
