/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of the H4CF conversion toolkit. The full H4CF conversion*
 * toolkit copyright notice including terms governing use, modification, and *
 * redistribution, is contained in the file COPYING.     *
 * COPYING can be found at the root of the source code    *
 * distribution tree.                                                        *
 * For questions contact eoshelp@hdfgroup.org or help@hdfgroup.org.          *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/*****************************************************************************
Category: Header file for the EOS2 module under the eoslib namespace

Description:

This file includes a definition of an HDF-EOS2 data field class. It also includes related method
declarations.


*****************************************************************************/


#ifndef EOS2_VAR_DATA_H_
#define EOS2_VAR_DATA_H_

#include "eos2_defs.h"
#include "vector"

namespace eoslib
{
class eos2_var_data: public var 
{
    public:
        /**
         *
         * eos2_var_data() reads the file using the given
         * grid/swath id and name.
         */
    
        /* For pure HDFEOS2 variables. */
        eos2_var_data(
	    group *g,
            file_info *f,
            eos2_group_type_t group_type,
            eos2_handle *handle,
            const std::string& name,
            const std::list<dim*>& dims,	/* in */
            std::list<dim*>* p_hidden_dims	/* in/out */
        );

        /* For variables added by using HDF4 APIs. */
        eos2_var_data(
            group *g,
            file_info *f,
            eos2_handle *handle,
            const std::string& name, /* in */
            const std::string& origname, /*in */
            const std::vector<std::string> vdims, /* in */
            int32 *dimsbuf, /* in */
            value_type_t type,
            int32 order, /* remember vdata order */
            int32 count, /* count of the number of bytes */
            void *p, /* pointer to store data, just for objects added by HDF4 APIs. */
            const std::list<dim*>& dims,    /* in */
            std::list<dim*>* p_hidden_dims  /* in/out */
        );

        /* Obtain total bytes used by this variable. */
        inline int32 get_bytes() const {return total_bytes;}

        /* Obtain order of VDATA. */
        inline int32 get_order() const {return order;}

        virtual ~eos2_var_data();			
        virtual value_type_t get_type() const;
        virtual void get_value(int32 start[], int32 stride[], int32 edge[], void *buf) const;
        virtual var *_clone() const;

    protected:
        eos2_var_data(const eos2_var_data&);

        file_info *m_file_info;
        eos2_group_type_t m_group_type;
        eos2_handle *m_handle; 
        std::string m_eos2varname;
        std::string m_eos2varorigname;

        value_type_t m_value_type;

        int32 order; // vdata order.
        int32 total_bytes; // total bytes of the data buffer for objects added by HDF4 APIs.
        void *ptr;// Hold the field data, this is only used by objects added by HDF4 APIs

        virtual bool same_obj_test(var*) const;

    private:
        eos2_var_data();

        friend class eos2_group;
        friend class eos2_var_dm; 
        friend int _cb_on_each_gd_datafield(char *name, void *arg);
};
} // namespace
#endif

