/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of the H4CF conversion toolkit. The full H4CF conversion*
 * toolkit copyright notice including terms governing use, modification, and *
 * redistribution, is contained in the file COPYING.     *
 * COPYING can be found at the root of the source code    *
 * distribution tree.                                                        *
 * For questions contact eoshelp@hdfgroup.org or help@hdfgroup.org.          *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/*****************************************************************************

Category: Header file for the EOS2 module under the eoslib namespace

Description:

This file includes a definition of an HDF-EOS2 swath dimension-mapped data field(eos2_var_dm) class and 
includes related method declarations.


*****************************************************************************/


#ifndef EOS2_VAR_DM_H_
#define EOS2_VAR_DM_H_

#include "eos2_defs.h"

namespace eoslib
{

//! EOS2 Swath Dimmension-mapped variable
/**
 * If a variable in EOS2 file is reduced using
 * dimension map, it can be expanded.
 * This class represents the expanded variable.
 * Note that the expanded variable is NOT in the original file.
 */
class eos2_var_dm: public var 
{
    public:
        //! Constructor for Geo Fields(using eos2_var_geo)
        eos2_var_dm(
            group *g,
            const std::string& name,
            const eos2_var_geo *v,
            const std::list<dim*>& dims, /* in */
            std::list<dim*>* p_hidden_dims	/* in/out */
        );

        // Constructor for Data Fields(using eos2_var_dm)
        // Some "data" fields also use dimension maps 
        eos2_var_dm(
            group *g,
            const std::string& name,
            const eos2_var_data *v,
            const std::list<dim*>& dims, /* in */
            std::list<dim*>* p_hidden_dims	/* in/out */
        );

        virtual ~eos2_var_dm();
		
        virtual value_type_t get_type() const;
        virtual void get_value(int32 start[], int32 stride[], int32 edge[], void *buf) const;
        virtual var *_clone() const;

    protected:
        eos2_var_dm(const eos2_var_dm&);

        file_info *m_file_info;
        eos2_group_type_t m_group_type;
        eos2_handle *m_handle; 
        std::string m_eos2varname;
        value_type_t m_value_type;

        std::vector<int32> m_reduced_size;
        std::vector<int32> m_expanded_size;
        std::vector<int32> m_offset;
        std::vector<int32> m_inc;
	
        virtual bool same_obj_test(var*) const;

    private:
        eos2_var_dm();

        friend class eos2_group;
};
} /* namespace */
#endif

