/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of the H4CF conversion toolkit. The full H4CF conversion*
 * toolkit copyright notice including terms governing use, modification, and *
 * redistribution, is contained in the file COPYING.     *
 * COPYING can be found at the root of the source code    *
 * distribution tree.                                                        *
 * For questions contact eoshelp@hdfgroup.org or help@hdfgroup.org.          *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/*****************************************************************************

Description:

This file includes a definition of an HDF-EOS2 swath geo-location field(eos2_var_geo) class. It also  includes related method declarations.

*****************************************************************************/


#ifndef EOS2_VAR_GEO_H_
#define EOS2_VAR_GEO_H_

#include "eos2_defs.h"

namespace eoslib
{

//! EOS2 Swath Geolocation field
class eos2_var_geo: public var 
{
    public:
        /**
         *
         * eos2_var_geo() reads the file using the given
         * swath id and name.
         */

        eos2_var_geo(
            group *g,
            file_info *f,
            eos2_handle *handle,
            const std::string& name,
            const std::list<dim*>& dims, /* in */
            std::list<dim*>* p_hidden_dims /* in/out */
        );

        virtual ~eos2_var_geo();
		
        virtual value_type_t get_type() const;
        virtual void get_value(int32 start[], int32 stride[], int32 edge[], void *buf) const;
        virtual var *_clone() const;

        //! Checking whether the var is a reduced one (by dimension mapping)
        bool is_dimmap_reduced() const;

    protected:
        eos2_var_geo(const eos2_var_geo&);

        file_info *m_file_info;
        eos2_group_type_t m_group_type;
        eos2_handle *m_handle; 
        std::string m_eos2varname;

        value_type_t m_value_type;
	
        virtual bool same_obj_test(var*) const;

    private:
        eos2_var_geo();

        friend class eos2_group;
        friend class eos2_var_dm;
        friend int _cb_on_each_gd_geofield(char *name, void *arg);
};
} // namespace
#endif

