/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of the H4CF conversion toolkit. The full H4CF conversion*
 * toolkit copyright notice including terms governing use, modification, and *
 * redistribution, is contained in the file COPYING.     *
 * COPYING can be found at the root of the source code    *
 * distribution tree.                                                        *
 * For questions contact eoshelp@hdfgroup.org or help@hdfgroup.org.          *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/*****************************************************************************

Description:

This file inlcudes the implementation related to the processing of an 
attribute.

*****************************************************************************/

#include <iostream>
#include <iomanip>
#include "eoslib_attr.h"
#include <vector>
#include <cassert>
#include <stdexcept>
#include "eoslib_err.h"

namespace eoslib 
{

// For internal testing only.
void attr::dump_r(int sp) const
{
    std::cout << std::setfill(' ') << std::setw(sp) << "";
    std::cout << "Attribute: " << this->get_name() << " (";

#if 0
    // Cast vector<char> to specific data type and print it out.
    /*
        value_type_t type = get_type();
        unsigned int size = get_size();
        std::vector<char> buf(size);
        this->get_value((void*)&buf[0]);

        switch(type)
        {
            case DFNT_CHAR8:
                std::cout << (char*)&buf[0];
                break;
            case DFNT_UCHAR8:
                std::cout << (char*)&buf[0];
                break;
            case DFNT_UINT8:
                assert(size==1);
                std::cout << (unsigned int)*((uint8_t*)&buf[0]);
                break;
            case DFNT_INT8:
                assert(size==1);
                std::cout << (int)(*((int8_t*)&buf[0]));
                break;
            case DFNT_UINT16:
                assert(size==2);
                std::cout << (unsigned int)*((uint16_t*)&buf[0]);
                break;
            case DFNT_INT16:
                assert(size==2);
                std::cout << (int)*((int16_t*)&buf[0]);
                break;
            case DFNT_UINT32:
                assert(size==4);
                std::cout << (unsigned int)*((uint32_t*)&buf[0]);
                break;
            case DFNT_INT32:
                assert(size==4);
                std::cout << (int)*((int32_t*)&buf[0]);
                break;
            case DFNT_FLOAT32:
                assert(size==4);
                std::cout << *((float*)&buf[0]);
                break;
            case DFNT_FLOAT64:
                assert(size==8);
                std::cout << *((double*)&buf[0]);
                break;
            default:
                throw std::range_error("Attribute's type is unknown(" __FILE__ ":" TOSTRING(__LINE__)")" );
        }; // end of switch	
    */
#endif
    std::cout << ")";

    //std::cout << " (rc: " << get_refcnt() << ")";
    std::cout << std::endl;
}

void attr::get_value_str(std::string *pVal) throw(std::runtime_error)
{
    if(get_type() != DFNT_CHAR8)
        std::runtime_error("Attribute's type is not string");
    std::vector<char> buf;
    buf.resize(get_num_elements()+1, '\0');

    this->get_value(&buf[0]);
    *pVal = &buf[0];
}

bool attr::is_equivalent_to(attr* r) const
{
    if(this->get_name() != r->get_name())
        return false;

    std::vector<char> lb, rb;
    this->get_value(&lb);
    r->get_value(&rb);

    if(lb != rb)
        return false;

    return true;
}

void attr::get_value(std::vector<char>* pbuf) const
{
    value_type_t type = get_type();
    unsigned int num = get_num_elements();

    unsigned int totsize = get_type_size(type) * num;
    pbuf->resize(totsize);
    get_value(&((*pbuf)[0]));
}

///////////////////
// Static funcs
///////////////////

std::string attr::s_get_name(const attr*a)
{
    return a->get_name();
}

bool attr::s_same_obj_test(attr *a1, attr *a2)
{
    return a1->same_obj_test(a2);
}

} // namespace
